window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "acgc", "modulename": "acgc", "kind": "module", "doc": "<p>Data analysis programs from the ACGC research group</p>\n\n<h1 id=\"installation\">Installation</h1>\n\n<p>For conda users:</p>\n\n<p><code>conda install -c conda-forge acgc</code></p>\n\n<p>For pip users:</p>\n\n<p><code>pip install acgc</code></p>\n\n<h3 id=\"for-developers\">For developers</h3>\n\n<p>If you plan to modify or improve the acgc package, an editable installation may be better:\n<code>pip install -e git+https://github.com/cdholmes/acgc-python</code>\nYour local files can then be managed with git, including keeping up-to-date with the \ngithub source repository (e.g. <code>git pull</code>).</p>\n\n<!-- ----------------------- SECTION BREAK ----------------------- -->\n\n<h1 id=\"get-started\">Get started</h1>\n\n<p>Submodules within <code>acgc</code> contain all the capabilities of the package.\nSubmodules are imported via <code>import acgc.&lt;submodule&gt;</code> or <code>from acgc import &lt;submodule&gt;</code>. </p>\n\n<h2 id=\"better-looking-figures\">Better looking figures</h2>\n\n<p>The default appearance of figures from Matplotlib doesn't meet the standards of most \nscientific journals (high-resolution, Helvetica-like font). With the <code>acgc.figstyle</code> module,\nfigures meet these criteria. Simply use <code>from acgc import figstyle</code> before creating your figures.\nSee <a href=\"https://github.com/cdholmes/acgc-python/blob/main/demo/demo_figstyle.ipynb\">example</a></p>\n\n<h2 id=\"standard-major-axis-sma-line-fitting\">Standard major axis (SMA) line fitting</h2>\n\n<p>SMA line fitting (also called reduced major axis or RMA) quantifies the linear relationship \nbetween variables in which neither one depends on the other.\nIt is available via <code>from acgc.stats import sma</code>.\nSee <a href=\"https://github.com/cdholmes/acgc-python/blob/main/demo/demo_sma.ipynb\">example</a> </p>\n\n<!-- ----------------------- SECTION BREAK ----------------------- -->\n\n<h1 id=\"demos\">Demos</h1>\n\n<p>The <a href=\"https://github.com/cdholmes/acgc-python/blob/main/demo\">demo</a> \nfolder contains examples of how to accomplish common data analysis and visualization tasks. \nThe examples include uses of the <code>acgc</code> library as well as other libraries for \ngeospatial data analysis.</p>\n\n<!-- ----------------------- SECTION BREAK ----------------------- -->\n\n<h1 id=\"quick-summary-of-submodules\">Quick summary of submodules</h1>\n\n<h2 id=\"key-submodules\">Key submodules</h2>\n\n<ul>\n<li><p><code>acgc.figstyle</code> <br />\nStyle settings for matplotlib, for publication-ready figures.\n<a href=\"https://github.com/cdholmes/acgc-python/blob/main/demo/demo_figstyle.ipynb\">demo</a></p></li>\n<li><p><code>acgc.stats</code> <br />\nCollection of statistical methods. \n<a href=\"https://github.com/cdholmes/acgc-python/blob/main/demo/demo_stats.ipynb\">demo</a> </p></li>\n</ul>\n\n<h2 id=\"other-submodules\">Other submodules</h2>\n\n<ul>\n<li><p><code>acgc.erroranalysis</code> <br />\nPropagation of error through complex numerical models</p></li>\n<li><p><code>acgc.geoschem</code> or <code>acgc.gc</code> <br />\nTools for GEOS-Chem grids (e.g. indexing, remapping, interpolating)</p></li>\n<li><p><code>acgc.hysplit</code> <br />\nRead HYSPLIT output and write HYSPLIT CONTROL files</p></li>\n<li><p><code>acgc.icartt</code> <br />\nRead and write ICARTT format files</p></li>\n<li><p><code>acgc.igra</code> <br />\nRead IGRA radiosonde data files</p></li>\n<li><p><code>acgc.mapping</code> <br />\nDistance calculation, scale bar for display on maps</p></li>\n<li><p><code>acgc.met</code> <br />\nMiscelaneous functions for PBL properties</p></li>\n<li><p><code>acgc.modetools</code> <br />\nVisualization of eigenmode systems</p></li>\n<li><p><code>acgc.netcdf</code> <br />\nHigh-level functions for reading and writing netCDF files. Legacy code. \n<code>acgc.netcdf.write_geo_nc</code> is still useful for concisely creating netCDF files, \nbut xarray is better for reading netCDF.</p></li>\n<li><p><code>acgc.solar</code> <br />\nSolar zenith angle, azimuth, declination, equation of time</p></li>\n<li><p><code>acgc.time</code> <br />\nFunctions for manimulating times and dates. Legacy code.</p></li>\n</ul>\n"}, {"fullname": "acgc.erroranalysis", "modulename": "acgc.erroranalysis", "kind": "module", "doc": "<p>Propagation of error through complex numerical models</p>\n"}, {"fullname": "acgc.erroranalysis.funcerror_uncorr", "modulename": "acgc.erroranalysis", "qualname": "funcerror_uncorr", "kind": "function", "doc": "<p>Propagate uncertainties in function parameters to uncertainty in function value. </p>\n\n<p>The uncertainty will be evaluated at f(x0). The method uses \na numerical estimate of the derivative of f(x0). For non-linear functions\nthe method is appropriate for small relative errors (i.e. small xerr/x0).\nThe method neglects possible error correlations between multiple parameters \nin x0.\nThe function variables must all be continuous variables \n(no categorical or discrete variables).</p>\n\n<p>Example. To find the uncertainty in <code>f(x,y)</code> at for values <code>x=1; y=2</code>, where \nthe uncertainty (e.g. standard error) in <code>x</code> is 0.1 and the uncertainty in <code>y</code> \nis 0.3.\n<code>print( funcerr_uncorr( f, [1,2], [0.1,0.3] ) )</code></p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>func</strong> (callable):\nfunction to be evaluated</li>\n<li><strong>x0</strong> (list or tuple (n,)):\nparameter values for func</li>\n<li><strong>xerr</strong> (list or tuple (n,)):\nuncertainty in parameter values x0</li>\n<li><strong>h</strong> (float, default=1e-3):\nfractional perturbation to x0 used to estimate slope of func via finite difference</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>ferr</strong> (float):\nthe uncertainty in <code>f(x0)</code> given <code>xerr</code> uncertainty in <code>x0</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func</span>, </span><span class=\"param\"><span class=\"n\">x0</span>, </span><span class=\"param\"><span class=\"n\">xerr</span>, </span><span class=\"param\"><span class=\"n\">h</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.figstyle", "modulename": "acgc.figstyle", "kind": "module", "doc": "<p>Style settings for matplotlib, for publication-ready figures</p>\n\n<p>Activate the style by importing this module:</p>\n\n<p><code>from acgc import figstyle</code></p>\n\n<p>Figures generated by Matplotlib will then use the new style.\nThe style includes grid lines (horizontal and vertical) by default.\nTurn these off and on with <code>grid_off</code> and <code>grid_on</code>:</p>\n\n<p><code>figstyle.grid_off()</code></p>\n\n<p><code>figstyle.grid_on()</code></p>\n"}, {"fullname": "acgc.figstyle.activate_style", "modulename": "acgc.figstyle", "qualname": "activate_style", "kind": "function", "doc": "<p>Activate style sheet </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>grid</strong> (bool, default=True):\nturn grid lines on (True) or off (False)</li>\n<li><strong>gridaxis</strong> (str, default='both'):\nspecifies which axes should have grid lines</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">grid</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">gridaxis</span><span class=\"o\">=</span><span class=\"s1\">&#39;both&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.figstyle.grid_off", "modulename": "acgc.figstyle", "qualname": "grid_off", "kind": "function", "doc": "<p>Turn off grid lines</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.figstyle.grid_on", "modulename": "acgc.figstyle", "qualname": "grid_on", "kind": "function", "doc": "<p>Turn on grid lines</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>axis</strong> ({'both', 'x', 'y'}):\nspecifies which axes should have grid lines</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">axis</span><span class=\"o\">=</span><span class=\"s1\">&#39;both&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.figstyle.load_fonts", "modulename": "acgc.figstyle", "qualname": "load_fonts", "kind": "function", "doc": "<p>Load fonts contained in the acgc/fonts subdirectory</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.gc", "modulename": "acgc.gc", "kind": "module", "doc": "<p>Alias for <code>acgc.geoschem</code>.</p>\n"}, {"fullname": "acgc.geoschem", "modulename": "acgc.geoschem", "kind": "module", "doc": "<p>Tools for indexing, remapping, interpolating GEOS-Chem grids</p>\n"}, {"fullname": "acgc.geoschem.mapweight1d", "modulename": "acgc.geoschem", "qualname": "mapweight1d", "kind": "function", "doc": "<p>Calculate mapping weights from source grid with edge1 to destination grid with edge2</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>edge1</strong> (array (n,)):\nsource grid edge coordinates</li>\n<li><strong>edge2</strong> (array (m,)):\ndestination grid edge coordinates</li>\n<li><strong>edgelump</strong> (bool, default=True)):\nedgelump only affects situations where the source grid covers a larger domain \nthan the destination grid (i.e. min(edge1)<min(edge2) or max(edge1)&gt;max(edge2) ).\nIf True, enforce total mass conservation in mapping weights by lumping excess mass \nin source grid into the corresponding end of destination grid.\nIf False, the mass is conserved in the overlapping domains, but some total mass\ncan be lost due to difference in overall domain.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>weight</strong> (array (m,n)):\nmapping weights from source to destination grid: new = np.dot(weight,old)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">edge1</span>, </span><span class=\"param\"><span class=\"n\">edge2</span>, </span><span class=\"param\"><span class=\"n\">edgelump</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.regrid2d", "modulename": "acgc.geoschem", "qualname": "regrid2d", "kind": "function", "doc": "<p>Mass-conserving remapping of data between regular x-y or lat-lon grids</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>array1</strong> (array (n,m)):\ninput data. Quantities should be extensive (e.g. mass, not mixing ratio).</li>\n<li><strong>xe1</strong> (array (n+1,)):\nsource grid edges in x dimension, e.g. longitude</li>\n<li><strong>ye1</strong> (array (m+1,)):\nsource grid edges in y dimension, e.g. latitude</li>\n<li><strong>xe2</strong> (array (p+1,)):\ndestination grid edges in x dimension, e.g. longitude</li>\n<li><strong>ye2</strong> (array (q+1,)):\ndestination grid edges in y dimension, e.g. latitude</li>\n<li><strong>edgelump</strong> (bool, default=True):\nedgelump only affects situations where the source grid covers a larger domain \nthan the destination grid (i.e. min(edge1)<min(edge2) or max(edge1)&gt;max(edge2) ).\nIf True, enforce total mass conservation in mapping weights by lumping excess mass \nin source grid into the corresponding end of destination grid.\nIf False, the mass is conserved in the overlapping domains, but some total mass\ncan be lost due to difference in overall domain.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>outarray</strong> (array (p,q)):\ninput data remapped to the destination grid</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">array1</span>, </span><span class=\"param\"><span class=\"n\">xe1</span>, </span><span class=\"param\"><span class=\"n\">ye1</span>, </span><span class=\"param\"><span class=\"n\">xe2</span>, </span><span class=\"param\"><span class=\"n\">ye2</span>, </span><span class=\"param\"><span class=\"n\">edgelump</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.regrid_plevels", "modulename": "acgc.geoschem", "qualname": "regrid_plevels", "kind": "function", "doc": "<p>Mass-conserving regridding of data on pressure levels\nData from the input array will be remapped to the output pressure levels while \nconserving total mass.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>array1</strong> (array, (p,)):\nArray of data that will be remapped.\nQuantities should be extensive (e.g. mass, not mixing ratio) unless the \nintensive keyword is used.</li>\n<li><strong>pedge1</strong> (array (p+1,)):\nPressure edges of the input array1. The length of pedge1 should be one greater than array1. \nThe element array1[i] is bounded by edges pedge1[i], pedge1[i+1]</li>\n<li><strong>pedge2</strong> (array (q+1,)):\nPressure edges of the desired output array.</li>\n<li><strong>intensive</strong> (bool, default=False):\nIf True, then array1 will be treated as an intensive quantity (e.g mole fraction, \nmixing ratio) during regridding. Each element array1[i] will be multiplied by \n(pedge1[i]-pedge[i+1]), which is proportional to airmass if pedge1 is pressure, \nbefore regridding. The output array2, will similarly be dividied by (pedge2[i]-pedge[i+1]) \nso that the output is also intensive. \nBy default, intensive=False is used and the input array is assumed to be extensive.</li>\n<li><strong>edgelump</strong> (bool, default=True):\nIf the max or min of pedge1 extend beyond the max or min of pedge2 and edgelump=True, \nthe mass will be placed in in the first or last grid level of the output array2, \nensuring that the mass of array2 is the same as array1. \nIf edgelump=False, then the mass of array2 can be less than array1.</li>\n<li><strong>Returns</strong></li>\n<li><strong>array2</strong> (array (q,)):\nArray of remapped data. The length of array2 will be one less than pedge2.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">array1</span>, </span><span class=\"param\"><span class=\"n\">pedge1</span>, </span><span class=\"param\"><span class=\"n\">pedge2</span>, </span><span class=\"param\"><span class=\"n\">intensive</span><span class=\"o\">=</span><span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">edgelump</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.lon2i", "modulename": "acgc.geoschem", "qualname": "lon2i", "kind": "function", "doc": "<p>Find I grid index for longitude</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lon</strong> (float):\nlongitude in degrees</li>\n<li><strong>res</strong> (float, default=4):\nresolution of grid. See <code>get_lon</code> for allowed values</li>\n</ul>\n\n<h6 id=\"result\">Result</h6>\n\n<p>index : int\n    grid index location closest to longitude</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lon</span>, </span><span class=\"param\"><span class=\"n\">res</span><span class=\"o\">=</span><span class=\"mi\">4</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.lat2j", "modulename": "acgc.geoschem", "qualname": "lat2j", "kind": "function", "doc": "<p>Find J grid index for latitude</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lat</strong> (float):\nlatitude in degrees</li>\n<li><strong>res</strong> (float, default=4):\nresolution of grid. See <code>get_lon</code> for allowed values</li>\n</ul>\n\n<h6 id=\"result\">Result</h6>\n\n<p>index : int\n    grid index location closest to latitude</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lat</span>, </span><span class=\"param\"><span class=\"n\">res</span><span class=\"o\">=</span><span class=\"mi\">4</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.ll2ij", "modulename": "acgc.geoschem", "qualname": "ll2ij", "kind": "function", "doc": "<p>Find (I,J) grid index for longitude, latitude</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lon, lat</strong> (float):\nlongitude and latitude in degrees</li>\n<li><strong>res</strong> (float, default=4):\nresolution of grid. See <code>get_lon</code> for allowed values</li>\n</ul>\n\n<h6 id=\"result\">Result</h6>\n\n<p>i, j : int\n    grid index location closest to longitude, latitude</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lon</span>, </span><span class=\"param\"><span class=\"n\">lat</span>, </span><span class=\"param\"><span class=\"n\">res</span><span class=\"o\">=</span><span class=\"mi\">4</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.get_lon", "modulename": "acgc.geoschem", "qualname": "get_lon", "kind": "function", "doc": "<p>Get array of longitudes for grid centers or edges. </p>\n\n<p>GMAO grids assumed</p>\n\n<ul>\n<li>res = 0.5 for 0.5x0.625</li>\n<li>res = 2 for 2x2.5</li>\n<li>res = 4 for 4x5</li>\n</ul>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>res</strong> (float, default=4):\nlatitude resolution of grid</li>\n<li><strong>center, edge</strong> (bool or None, default=None):\ndetermines whether returned values are at grid center (center=True) or grid edge (edge=True)\nIf both center and edge are None, then center is used</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>lon</strong> (array (n,)):\nlongitude in degrees at grid center or edges</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">res</span><span class=\"o\">=</span><span class=\"mi\">4</span>, </span><span class=\"param\"><span class=\"n\">center</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">edge</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.get_lat", "modulename": "acgc.geoschem", "qualname": "get_lat", "kind": "function", "doc": "<p>Get array of latitudes at grid center or edges</p>\n\n<p>GMAO grids assumed</p>\n\n<ul>\n<li>res = 0.5 for 0.5x0.625</li>\n<li>res = 2 for 2x2.5</li>\n<li>res = 4 for 4x5</li>\n</ul>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>res</strong> (float, default=4):\nlatitude resolution of grid</li>\n<li><strong>center, edge</strong> (bool or None, default=None):\ndetermines whether returned values are at grid center (center=True) or grid edge (edge=True)\nIf both center and edge are None, then center is used</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>lat</strong> (array (n,)):\nlatitude in degrees at grid center or edges</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">res</span><span class=\"o\">=</span><span class=\"mi\">4</span>, </span><span class=\"param\"><span class=\"n\">center</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">edge</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.get_lev_p", "modulename": "acgc.geoschem", "qualname": "get_lev_p", "kind": "function", "doc": "<p>Get array of pressures at grid centers or edges</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>p_surf</strong> (float):\nsurface pressure, hPa</li>\n<li><strong>nlev</strong> ({47,72}):\nnumber of vertical levels (47 or 72)</li>\n<li><strong>edge</strong> (bool):\nspecify edges (True) or centers (False, default)</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>p</strong> (array of float):\npressures for each vertical level</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">p_surf</span><span class=\"o\">=</span><span class=\"mf\">1013.25</span>, </span><span class=\"param\"><span class=\"n\">nlev</span><span class=\"o\">=</span><span class=\"mi\">47</span>, </span><span class=\"param\"><span class=\"n\">edge</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.get_lev_z", "modulename": "acgc.geoschem", "qualname": "get_lev_z", "kind": "function", "doc": "<p>Calculate the geopotential heights of level edges or centers</p>\n\n<p>Calculations use hypsometric equation, assuing hydrostatic balance</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>TK</strong> (array of float):\nTemperature for each grid level, K</li>\n<li><strong>p_surf</strong> (float):\nSurface pressure, hPa</li>\n<li><strong>p_edge</strong> (array of float, optional):\nPressure at each grid level edge, hPa\nWill be calculated if length differs from TK</li>\n<li><strong>Q</strong> (array of float):\nSpecific humidity for each grid level, kg/kg</li>\n<li><strong>z_surf</strong> (float):\nSurface altitude, m</li>\n<li><strong>edge</strong> (bool):\nspecify edges (True) or centers (False, default) for output</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>z</strong> (array of float):\nGeopotential height for each grid edge or center, m</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">TK</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"mi\">273</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">p_surf</span><span class=\"o\">=</span><span class=\"mf\">1013.25</span>, </span><span class=\"param\"><span class=\"n\">p_edge</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">Q</span><span class=\"o\">=</span><span class=\"mi\">0</span>, </span><span class=\"param\"><span class=\"n\">z_surf</span><span class=\"o\">=</span><span class=\"mi\">0</span>, </span><span class=\"param\"><span class=\"n\">edge</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.geoschem.get_hybrid_ab", "modulename": "acgc.geoschem", "qualname": "get_hybrid_ab", "kind": "function", "doc": "<p>Get A and B values for the GEOS-5/MERRA/MERRA2 hybrid sigma-pressure vertical coordinate.</p>\n\n<p>The pressure at level edge L is P(L) = A(L) + B(L) * PS, where PS is surface pressure in hPa</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>nlev</strong> ({47,72}):\nnumber of levels in the desired grid (47 or 72)</li>\n<li><strong>center, edge</strong> (bool):\nspecify if values for level center or edges are desired</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<p>A, B : array (n,)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">nlev</span><span class=\"o\">=</span><span class=\"mi\">47</span>, </span><span class=\"param\"><span class=\"n\">edge</span><span class=\"o\">=</span><span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">center</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.hysplit", "modulename": "acgc.hysplit", "kind": "module", "doc": "<p>Package of functions to read HYSPLIT output </p>\n\n<p>Assumed directory structure for meteorological data. \nAll directories are archived meteorology except for \"forecast/\" directory.</p>\n\n<pre><code>metroot/\n  forecast/     (All forecasts in subdirectories for each initialization date)\n    YYYYMMDD/   (forecasts initialized on YYYYMMDD)\n  gdas1/\n  gdas0p5/\n  gfs0p25/\n  hrrr/\n  nam12/        (what ARL calls nams)\n  nam3/         (pieced forecast of NAM CONUS nest (3 km))\n</code></pre>\n"}, {"fullname": "acgc.hysplit.METROOT", "modulename": "acgc.hysplit", "qualname": "METROOT", "kind": "variable", "doc": "<p>Default location for ARL met data</p>\n", "default_value": "&#x27;/data/MetData/ARL/&#x27;"}, {"fullname": "acgc.hysplit.check_METROOT", "modulename": "acgc.hysplit", "qualname": "check_METROOT", "kind": "function", "doc": "<p>Check if METROOT is a valid directory path</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.hysplit.set_METROOT", "modulename": "acgc.hysplit", "qualname": "set_METROOT", "kind": "function", "doc": "<p>Set METROOT, the directory for ARL meteorology data</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>path</strong> (str or path):\nabsolute path</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"o\">=</span><span class=\"s1\">&#39;/data/MetData/ARL/&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.hysplit.tdump2nc", "modulename": "acgc.hysplit", "qualname": "tdump2nc", "kind": "function", "doc": "<p>Convert a HYSPLIT tdump file to netCDF\nWorks with single point or ensemble trajectories</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>inFile</strong> (str):\nname/path of HYSPLIT tdump file</li>\n<li><strong>outFile</strong> (str):\nname/path of netCDF file that will be created</li>\n<li><strong>clobber</strong> (bool, default=False):\ndetermines whether outFile will be overwrite any previous file</li>\n<li><strong>globalAtt</strong> (dict, default=None):\nIf present, dict keys will be added to outFile as global attributes</li>\n<li><strong>altIsMSL</strong> (bool, default=False):\nDetermines whether altitude in HYSPLIT tdump file is treated as altitude above sea level\n(altIsMSL=True) or altitude above ground (altIsMSL=False). In either case, the netCDF\nfile will contain both altitude variables.</li>\n<li><strong>dropOneTime</strong> (bool, default=False):\nKludge to address back trajectories that start 1 minute after the hour,\ndue to CONTROL files created with write_control(... exacttime=False )\nset True only for trajectories using this setup.</li>\n<li><strong>pack</strong> (bool, default=False):\nNOT IMPLEMENTED\ndetermines whether variables in the netCDF file should be compressed with <em>lossy</em>\ninteger packing.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">inFile</span>,</span><span class=\"param\">\t<span class=\"n\">outFile</span>,</span><span class=\"param\">\t<span class=\"n\">clobber</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">globalAtt</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">altIsMSL</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">dropOneTime</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">pack</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.hysplit.read_tdump", "modulename": "acgc.hysplit", "qualname": "read_tdump", "kind": "function", "doc": "<p>Read trajectory file output from HYSPLIT</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>file</strong> (str):\nname of trajectory file to read</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>pandas.DataFrame</strong>: DataFrame contains columns:\n<ul>\n<li>time : datetime object</li>\n<li>year, month, day, hour, minute : floats, same as time</li>\n<li>lat, lon, alt : trajectory location</li>\n<li>thour : hours since trajectory initialization, \nnegative for back trajectories</li>\n<li>tnum : trajectory number tnum=1 for single trajectory, \ntnum=1-27 for trajectory ensemble</li>\n<li>metnum : index number of met file used at this point in trajectory, \nsee tdump file for corresponding file paths</li>\n<li>fcasthr : hours since the meteorological dataset was initialized</li>\n</ul></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.hysplit.find_arl_metfiles", "modulename": "acgc.hysplit", "qualname": "find_arl_metfiles", "kind": "function", "doc": "<p>Find ARL meteorology files for specified dates, models, forecast and archive</p>\n\n<p>Files will be located for start_time and extending ndays forward or backward</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>start_time</strong> (datetime.datetime or pandas.Timestamp):\nstart date and time for finding meteorology data files</li>\n<li><strong>ndays</strong> (int):\nnumber of days of files to retrieve</li>\n<li><strong>back</strong> (bool, default=False):\nspecifies files should go ndays backward (back=True) from start_time</li>\n<li><strong>metmodels</strong> (list or str, default=['gdas0p5','gdas1']):\nmeteorological models that will be used, in order of decreasing resolution and priority</li>\n<li><strong>forecast</strong> (bool, default=False):\nset forecast=True to use forecast meteorology for trajectory computation\nset forecast=False to use archived (past) meteorology for trajectory computation\nNote: hybrid=True will supercede forecast=True</li>\n<li><strong>forecastcycle</strong> (datetime.datetime, pandas.Timestamp, or None, default=None):\nif forecast=True, this sets the forecast initialization cycle that will be used\nset forecastcycle=None to use the latest available cycle for which files are found\nif forecast=False, this parameter has no effect</li>\n<li><strong>hybrid</strong> (bool, default=False):\nset hybrid=True for trajectories that use a combination of past archive and \nforecast meteorlogy. This supercedes forecast=True</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>metfiles</strong> (list):\npath to meteorology files meeting the criteria</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start_time</span>,</span><span class=\"param\">\t<span class=\"n\">ndays</span>,</span><span class=\"param\">\t<span class=\"n\">back</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">metmodels</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">forecast</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">forecastcycle</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">hybrid</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.hysplit.write_control", "modulename": "acgc.hysplit", "qualname": "write_control", "kind": "function", "doc": "<p>Write HYSPLIT control file for trajectory starting at designated time and coordinates</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>time</strong> (datetime.datetime or pandas.Timestamp):\ntrajectory initialization time</li>\n<li><strong>lat, lon</strong> (float or list):\ntrajectory initialization latitude and longitude in degrees</li>\n<li><strong>alt</strong> (float or list):\ntrajectory initialization altitude in meters\nThe setup.cfg determines whether this is above ground or above mean sea level</li>\n<li><strong>trajhours</strong> (int):\ndesired trajectory duration in hours. Use negative for back trajectories</li>\n<li><strong>fname</strong> (str, default='CONTROL.000'):\npath and name for the file that will be written</li>\n<li><strong>clobber</strong> (bool, default=False):\nif clobber=True, then fname will be overwritten</li>\n<li><strong>maxheight</strong> (float, default=15000):\nterminate trajectories that exceed maxheight altitude in meters</li>\n<li><strong>outdir</strong> (str, default='./'):\ndirectory path where HYSPLIT output will be written</li>\n<li><strong>tfile</strong> (str, default='tdump'):\nname of the trajectory file that HYSPLIT will write</li>\n<li><strong>metfiles</strong> (list or str, default=None):\npaths to ARL meteorology files needed for the trajectory computation\nIf metfiles=None, then find_arl_metfiles will be used to locate necessary files</li>\n<li><strong>exacttime</strong> (bool, default=True):\nIt is not recommended to change this default, but keyword is retained for backward\ncompatibility with some scripts. Setting exacttime=False will shift the actual \nstart time of trajectories that begin at 00:00 UTC to 00:01 UTC to avoid reading\nan additional day of meteorological data.</li>\n<li><strong>**kwargs</strong>: kwargs will be passed to find_arl_metfiles to locate ARL meteorlogy files if metfiles=None\nThese keywords should include metmodels and possibly forecast, forecastcycle, or hybrid\nSee find_arl_metfiles for definitions of these parameters</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">time</span>,</span><span class=\"param\">\t<span class=\"n\">lat</span>,</span><span class=\"param\">\t<span class=\"n\">lon</span>,</span><span class=\"param\">\t<span class=\"n\">alt</span>,</span><span class=\"param\">\t<span class=\"n\">trajhours</span>,</span><span class=\"param\">\t<span class=\"n\">fname</span><span class=\"o\">=</span><span class=\"s1\">&#39;CONTROL.000&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">clobber</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">maxheight</span><span class=\"o\">=</span><span class=\"mf\">15000.0</span>,</span><span class=\"param\">\t<span class=\"n\">outdir</span><span class=\"o\">=</span><span class=\"s1\">&#39;./&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">tfile</span><span class=\"o\">=</span><span class=\"s1\">&#39;tdump&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">metfiles</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">exacttime</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.icartt", "modulename": "acgc.icartt", "kind": "module", "doc": "<p>Read and write ICARTT (ffi1001) format files</p>\n"}, {"fullname": "acgc.icartt.read_icartt", "modulename": "acgc.icartt", "qualname": "read_icartt", "kind": "function", "doc": "<p>Read ICARTT file or files into a pandas DataFrame</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>files</strong> (list or str):\npath to ICARTT file or files that will be read. \nData within these files will be concatenated, so files should all contain the same variables</li>\n<li><strong>usePickle</strong> (bool, default=False):\nif usePickle=True, the data will be written to a pkl file with \".pkl\" appended to path\nOn subsequent read_icartt calls, data will be read from the .pkl file, if it exists</li>\n<li><strong>timeIndex</strong> (bool, default=False):\nsets DataFrame index to the time variable from the ICARTT file, rather than a row counter</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>obs</strong> (pandas.DataFrame):\nICARTT file contents. In addition to column names for the ICARTT variables, \nthe DataFrame columns also include 'time' in pandas.DatetimeIndex format and \n'file' that is the ordinal number of the input file that each row was read from</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">files</span>, </span><span class=\"param\"><span class=\"n\">usePickle</span><span class=\"o\">=</span><span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">timeIndex</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.icartt.write_icartt", "modulename": "acgc.icartt", "qualname": "write_icartt", "kind": "function", "doc": "<p>Write an ICARTT ffi1001 file</p>\n\n<p>The contents of a pandas DataFrame (<code>df</code>) are written to a text file in ICARTT format\nusing <code>metadata</code> to specify which variables are written and provide ICARTT file header.</p>\n\n<p>ICARTT file format specification document:\n<a href=\"https://www.earthdata.nasa.gov/esdis/esco/standards-and-practices/icartt-file-format\">https://www.earthdata.nasa.gov/esdis/esco/standards-and-practices/icartt-file-format</a></p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>filename</strong> (str):\nFile to be created</li>\n<li><strong>df</strong> (pandas.DataFrame):\nData values that will be written</li>\n<li><strong>metadata</strong> (dict or obj):\nSee notes below for the attributes or keys that <code>metadata</code> must contain</li>\n<li><strong>**kwargs</strong>: passed to pandas.to_csv</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p><code>metadata</code> can be a dict or any object, so long as it contains the following attributes or keys:</p>\n\n<ul>\n<li>independent_variable_definition (dict)\nshould have only one key</li>\n<li>dependent_variable_definition (dict)\nControls which variables from <code>df</code> are written to file</li>\n<li>measurement_start_date (pandas.Timestamp or datetime.datetime)\ndate UTC when measurement collection began</li>\n<li>pi_name (str)</li>\n<li>pi_contact_info (str)</li>\n<li>organization_name (str)</li>\n<li>dm_contact_info (str)</li>\n<li>mission_name (str)</li>\n<li>project_info (str)</li>\n<li>special_comments (list of str)</li>\n<li>platform (str)</li>\n<li>location (str)</li>\n<li>associated_data (str)</li>\n<li>intrument_info (str)</li>\n<li>data_info (str)</li>\n<li>uncertainty (str)</li>\n<li>ulod_flag (str)\ncommonly '-7777'</li>\n<li>ulod_value (str)</li>\n<li>llod_flag (str)\ncommonly '-8888'</li>\n<li>llod_value (str)</li>\n<li>stipulations_on_use (str)</li>\n<li>other_comments (str)</li>\n<li>revision (str)</li>\n<li>revision_comments (list of str)</li>\n</ul>\n\n<p>The <code>independent_variable_defintion</code> and <code>dependent_variable_definition</code> are dicts\nwith entries of the form <code>{'VariableName':'units, standard name, [optional long name]'}</code>\nThe keys must correspond to columns of <code>df</code>.\n<code>independent_variable_definition</code> should have only one key while \n<code>dependent_variable_definition</code> can have many. For example,\n<code>metadata.INDEPENDENT_VARIABLE_DEFINITION = \n        {'Time_Start':'seconds, time at start of measurement, seconds since midnight UTC'}</code>\nSee Examples below.</p>\n\n<h6 id=\"examples\">Examples</h6>\n\n<pre><code>import pandas as pd\nfrom acgc import icartt\n\ndf = pd.DataFrame( [[1,0,30],\n                    [2,10,29],\n                    [3,20,27],\n                    [4,30,25]],\n                    columns=['Time_Start','Alt','Temp'])\n\nmetadata = dict(\n    INDEPENDENT_VARIABLE_DEFINITION = \n        {'Time_Start':'seconds, time, measurement time in seconds after takeoff'},\n    DEPENDENT_VARIABLE_DEFINITION = \n        {'Alt':'m, altitude, altitude above ground level',\n         'Temp':'C, temperature, air temperature in Celsius'},\n    PI_NAME = 'Jane Doe',\n    ORGANIZATION_NAME = 'NASA',\n    SOURCE_DESCRIPTION = 'Invented Instrument',\n    MISSION_NAME = 'FIREX-AQ',\n    SPECIAL_COMMENTS = ['Special comments are optional and can be omitted.',\n                    'If used, they should be a list of one or more strings'],\n    PI_CONTACT_INFO = 'jdoe@email.com or postal address',\n    PLATFORM = 'NASA DC-8',\n    LOCATION = 'Boise, ID, USA',\n    ASSOCIATED_DATA = 'N/A',\n    INSTRUMENT_INFO = 'N/A',\n    DATA_INFO = 'N/A',\n    UNCERTAINTY = r'10% uncertainty in all values',\n    ULOD_FLAG = '-7777',\n    ULOD_VALUE = 'N/A',\n    LLOD_FLAG = '-8888',\n    LLOD_VALUE = 'N/A',\n    DM_CONTACT_INFO = 'Alice, data manager, alice@email.com',\n    STIPULATIONS_ON_USE = 'FIREX-AQ Data Use Policy',\n    PROJECT_INFO = 'FIREX-AQ 2019, https://project.com',\n    OTHER_COMMENTS = 'One line of comments',\n    REVISION = 'R1',\n    REVISION_COMMENTS = ['R0: Initial data',\n                        'R1: One string per revision'],\n    measurement_start_date = pd.Timestamp('2020-01-30 10:20')\n    )\n\nicartt.write_icartt( 'test.ict', df, metadata )\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span>, </span><span class=\"param\"><span class=\"n\">df</span>, </span><span class=\"param\"><span class=\"n\">metadata</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.igra", "modulename": "acgc.igra", "kind": "module", "doc": "<p>Functions for reading and using IGRA v2 radiosonde data files</p>\n"}, {"fullname": "acgc.igra.read_igra_country", "modulename": "acgc.igra", "qualname": "read_igra_country", "kind": "function", "doc": "<p>Read file of IGRA country codes</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>file</strong> (str):\nname/path of file to read</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>pandas.DataFrame</strong>: Contains columns: \n<ul>\n<li><code>countryID</code> (str) : 2-letter code</li>\n<li><code>countryName</code> (str) : full name</li>\n</ul></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.igra.read_igra_stations", "modulename": "acgc.igra", "qualname": "read_igra_stations", "kind": "function", "doc": "<p>Read file of IGRA station coordinates and dates of observations</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>file</strong> (str):\nname/path of file to read</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>pandas.DataFrame</strong>: Contains columns:\n<ul>\n<li>siteID : IGRA station code</li>\n<li>countryID : 2-letter country code</li>\n<li>lat : latitude</li>\n<li>lon : longitude</li>\n<li>elev : elevation, m</li>\n<li>state : if applicable</li>\n<li>name : station name</li>\n<li>firstyear : first year with observations</li>\n<li>lastyear : final year with observations</li>\n<li>nobs : number of sounding columns</li>\n</ul></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.igra.read_igra_file", "modulename": "acgc.igra", "qualname": "read_igra_file", "kind": "function", "doc": "<p>Read file with IGRA soundings</p>\n\n<p>This function can read IGRA files with and without derived variables.\nIf only the derived variables are needed, reading the profiles can be skipped to improve speed.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>file</strong> (str):\nname/path of file to read</li>\n<li><strong>derived</strong> (bool):\nSet derived=True for files with derived variables and \nderived=False (default) for files with only profile measurements</li>\n<li><strong>readprofiles</strong> (bool):\nSet readprofiles=False to skip reading the profiles. \nThen, only header info and derived variables will be read</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>pandas.Dataframe</strong>: Containing columns\n<ul>\n<li>siteID  = ID code </li>\n<li>syntime = Nominal synoptic time (0Z or 12Z) of launch</li>\n<li>time    = Actual launch time, if provided, otherwise same as synoptic time</li>\n<li>numlev  = number of measurement levels in the profile</li>\n<li>profile = sub-dataframe containing vertical profile (numlev rows). \nSee below for data columns. profile is only present when readprofiles=True</li>\n</ul></li>\n</ul>\n\n<p>For \"derived\" files, the returned DataFrame also contains the following profile summary columns        </p>\n\n<ul>\n<li>pw         = precipitable water, mm</li>\n<li>invpress   = inversion pressure, hPa</li>\n<li>invhgt     = inversion height, m AGL</li>\n<li>invtempdif = temperature difference from surface to inversion, K</li>\n<li>mixpress   = pressure at top of mixed layer (parcel method), hPa</li>\n<li>mixhgt     = height of mixed layer, m AGL</li>\n<li>frzpress   = pressure at freezing level, hPa</li>\n<li>frzhgt     = height of mixing level, m AGL</li>\n<li>lclpress   = pressure at the LCL, hPa</li>\n<li>lclhgt     = height of the LCL, m AGL</li>\n<li>lfcpress   = pressure of the LFC, hPa</li>\n<li>lfchgt     = height of the LFC, m AGL</li>\n<li>lnbpress   = pressure of the LNB, hPa</li>\n<li>lnbhgt     = height of LNB, m AGL</li>\n<li>LI         = Lifted index, C</li>\n<li>SI         = Showalter index, C</li>\n<li>KI         = K index, C</li>\n<li>TTI        = Total totals index, C</li>\n<li>CAPE       = CAPE, J/kg</li>\n<li>CIN        = Convective inhibition, J/kg</li>\n</ul>\n\n<p>The \"profile\" field is a sub-DataFrame containing the following variables and \"numlev\" rows\"</p>\n\n<ul>\n<li>p       = pressure, hPa </li>\n<li>z       = altitude, m</li>\n<li>T       = temperature, C</li>\n<li>Td      = dewpoint, C</li>\n<li>RH      = relative humidity, %</li>\n<li>dpdp    = dewpoint depression, C</li>\n<li>wdir    = wind direction, 0-360 degrees</li>\n<li>wspd    = wind speed, m/s</li>\n<li>pflag   = pressure flag, see IGRA documentation</li>\n<li>zflag   = altitude flag, see IGRA documentation</li>\n<li>Tflag   = temperature flag, see IGRA documentation\nFor \"derived\" files, \"profile\" also contains the following variables</li>\n<li>zrep    = ?</li>\n<li>Tgrad   = ?</li>\n<li>Tpot    = potential temperature, K?</li>\n<li>Tpotgrad = ?</li>\n<li>Tvirt   = virtual temperature, K?</li>\n<li>Tvirtpot= virtual potential temperature, K?</li>\n<li>e       = water vapor pressure, hPa</li>\n<li>es      = saturation water vapor pressure, hPa</li>\n<li>RHrep   = ?</li>\n<li>RHgrad  = ?</li>\n<li>u       = eastward component of wind, m/s</li>\n<li>v       = northward component of wind, m/s</li>\n<li>ugrad   = ? m/s</li>\n<li>vgrad   = ? m/s</li>\n<li>N       = ?</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span>, </span><span class=\"param\"><span class=\"n\">derived</span><span class=\"o\">=</span><span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">readprofiles</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.igra.demo", "modulename": "acgc.igra", "qualname": "demo", "kind": "function", "doc": "<p>Read some sample data and plot it</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.mapping", "modulename": "acgc.mapping", "kind": "module", "doc": "<p>Package of mapping functions</p>\n"}, {"fullname": "acgc.mapping.pi180", "modulename": "acgc.mapping", "qualname": "pi180", "kind": "variable", "doc": "<p></p>\n", "default_value": "0.017453292519943295"}, {"fullname": "acgc.mapping.great_circle", "modulename": "acgc.mapping", "qualname": "great_circle", "kind": "function", "doc": "<p>Great circle distance between two points on Earth</p>\n\n<p>Usage: \ndistance = great_circle( start_lon, start_lat, end_lon, end_lat )\ndistance = great_circle( start_points, end_points )</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>*args</strong> (array_likes or str):\nLongitude and latitude of the start and end points, degrees\nCoordinates can be passed as four 1D arrays (n,) or two 2D arrays (n,2)\nIf four arrays, they should be <code>start_lon</code>, <code>start_lat</code>, <code>end_lon</code>, <code>end_lat</code> \nIf two arrays, they should be (n,2) shape with longitude as the first column\nIf strings, the <code>data</code> keyword must be used and args are interpreted as key names</li>\n<li><strong>data</strong> (dict_like, optional):\nIf provided, *args should be strings that are keys to <code>data</code>.</li>\n<li><strong>radius</strong> (float, optional):\nradius of the sphere in meters. If None, WGS84 will be used.</li>\n<li><strong>flattening</strong> (float, optional):\nflattening of the ellipsoid. Use 0 for a sphere. If None, WGS84 will be used.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>distance</strong> (ndarray):\ndistance between points, m</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">radius</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">flattening</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.mapping.scale_bar", "modulename": "acgc.mapping", "qualname": "scale_bar", "kind": "function", "doc": "<p>Add a scale bar to CartoPy axes.</p>\n\n<p>For angles between 0 and 90 the text and line may be plotted at\nslightly different angles for unknown reasons. To work around this,\noverride the 'rotation' keyword argument with text_kwargs.</p>\n\n<p>From StackOverflow\n<a href=\"https://stackoverflow.com/questions/32333870/how-can-i-show-a-km-ruler-on-a-cartopy-matplotlib-plot\">https://stackoverflow.com/questions/32333870/how-can-i-show-a-km-ruler-on-a-cartopy-matplotlib-plot</a></p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>ax</strong> ():\nCartoPy axes</li>\n<li><strong>location</strong> ():\nPosition of left-side of bar in axes coordinates.</li>\n<li><strong>length</strong> ():\nGeodesic length of the scale bar.</li>\n<li><strong>metres_per_unit</strong> (default=1000):\nNumber of metres in the given unit.</li>\n<li><strong>unit_name</strong> (str, default='km'):\nName of the given unit.</li>\n<li><strong>tol</strong> (float, default=0.01):\nAllowed relative error in length of bar</li>\n<li><strong>angle</strong> (float):\nAnti-clockwise rotation of the bar.</li>\n<li><strong>color</strong> (str, default='black'):\nColor of the bar and text.</li>\n<li><strong>linewidth</strong> (float):\nSame argument as for plot.</li>\n<li><strong>text_offset</strong> (float, default=0.005):\nPerpendicular offset for text in axes coordinates.</li>\n<li><strong>ha</strong> (str or float [0-1], default='center'):\nHorizontal alignment.</li>\n<li><strong>va</strong> (str or float [0-1], default='bottom'):\nVertical alignment.</li>\n<li><strong>plot_kwargs</strong> (dict):\nKeyword arguments for plot, overridden by **kwargs.</li>\n<li><strong>text_kwargs</strong> (dict):\nKeyword arguments for text, overridden by **kwargs.</li>\n<li><strong>**kwargs</strong> ():\nKeyword arguments for both plot and text.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">ax</span>,</span><span class=\"param\">\t<span class=\"n\">location</span>,</span><span class=\"param\">\t<span class=\"n\">length</span>,</span><span class=\"param\">\t<span class=\"n\">metres_per_unit</span><span class=\"o\">=</span><span class=\"mi\">1000</span>,</span><span class=\"param\">\t<span class=\"n\">unit_name</span><span class=\"o\">=</span><span class=\"s1\">&#39;km&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">tol</span><span class=\"o\">=</span><span class=\"mf\">0.01</span>,</span><span class=\"param\">\t<span class=\"n\">angle</span><span class=\"o\">=</span><span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">color</span><span class=\"o\">=</span><span class=\"s1\">&#39;black&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">linewidth</span><span class=\"o\">=</span><span class=\"mi\">3</span>,</span><span class=\"param\">\t<span class=\"n\">text_offset</span><span class=\"o\">=</span><span class=\"mf\">0.005</span>,</span><span class=\"param\">\t<span class=\"n\">ha</span><span class=\"o\">=</span><span class=\"s1\">&#39;center&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">va</span><span class=\"o\">=</span><span class=\"s1\">&#39;bottom&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">plot_kwargs</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">text_kwargs</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.met", "modulename": "acgc.met", "kind": "module", "doc": "<p>Functions for computing boundary layer meteorological properties</p>\n"}, {"fullname": "acgc.met.pbl_bulk_richardson", "modulename": "acgc.met", "qualname": "pbl_bulk_richardson", "kind": "function", "doc": "<p>Compute PBL mixing height from critical value of bulk Richardson number</p>\n\n<h6 id=\"arguments\">Arguments</h6>\n\n<p>z : array, float\n    altitude, m\nthetav  : array, float\n    virtual potential temperature, K\nws : array, float\n    wind speed, m/s\ncrit : float\n    critical value defining the top of the PBL mixing (default=0.25)</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>zpbl</strong> (float):\naltitude of PBL top, m</li>\n<li><strong>L</strong> (float):\nlevel number within z array corresponding to altitude zpbl</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">z</span>, </span><span class=\"param\"><span class=\"n\">thetav</span>, </span><span class=\"param\"><span class=\"n\">ws</span>, </span><span class=\"param\"><span class=\"n\">crit</span><span class=\"o\">=</span><span class=\"mf\">0.25</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.met.pbl_parcel", "modulename": "acgc.met", "qualname": "pbl_parcel", "kind": "function", "doc": "<p>Compute PBL mixing height with parcel method</p>\n\n<p>The mixing height is defined as the altitude where a rising parcel of air\nfrom the base of the profile becomes neutrally buoyant. More formally, where\nthe virtual potential temperature exceeds the value at the base plus delta.</p>\n\n<h6 id=\"arguments\">Arguments</h6>\n\n<p>z : array, float\n    altitude, m\nthetav  : array, float\n    virtual potential temperature, K or C\ndelta : float\n    incremental threshold of virtual potential temperature, K or C</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>zpbl</strong> (float):\naltitude of PBL top, m</li>\n<li><strong>L</strong> (float):\nlevel number within z array corresponding to altitude zpbl</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">z</span>, </span><span class=\"param\"><span class=\"n\">thetav</span>, </span><span class=\"param\"><span class=\"n\">delta</span><span class=\"o\">=</span><span class=\"mf\">0.5</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.met.mo_wind", "modulename": "acgc.met", "qualname": "mo_wind", "kind": "function", "doc": "<p>Predict wind speed at altitude z using Monin-Obukhov similarity theory</p>\n\n<h6 id=\"arguments\">Arguments</h6>\n\n<p>surfaceP : float\n    surface pressure, hPa\nq2m : float\n    specific humidity at 2m, kg/kg\ntemp2m : float\n    temperature at 2m, K\nustar : float\n    friction velocity, m/s\nshf, lhf : float\n    sensible and latent heat fluxes, W/m2\nz0 : float\n    roughness length, m\nd : float\n    displacement height, m\nz : float\n    height at which wind speed will be calculated, m</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>ws</strong> (float):\nwind speed at altitude z, m/s</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">surfaceP</span>, </span><span class=\"param\"><span class=\"n\">q2m</span>, </span><span class=\"param\"><span class=\"n\">temp2m</span>, </span><span class=\"param\"><span class=\"n\">ustar</span>, </span><span class=\"param\"><span class=\"n\">shf</span>, </span><span class=\"param\"><span class=\"n\">lhf</span>, </span><span class=\"param\"><span class=\"n\">z0</span>, </span><span class=\"param\"><span class=\"n\">d</span>, </span><span class=\"param\"><span class=\"n\">z</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.modetools", "modulename": "acgc.modetools", "kind": "module", "doc": "<p>Graphical display of eigenmodes</p>\n"}, {"fullname": "acgc.modetools.show_modes", "modulename": "acgc.modetools", "qualname": "show_modes", "kind": "function", "doc": "<p>Plot figure showing eigenmodes</p>\n\n<p>This program assumes that all modes will be displayed, so it is expected that\nlen(labels) = len(eigval) = nmodes and eigvec has shape nmodes x nmodes. </p>\n\n<h6 id=\"arguments\">Arguments</h6>\n\n<p>labels : list, str\n    names for the component variables decomposed into modes\neigval : list or array, float\n    eigenvalues\neigvec : 2D array, float\n    eigenvector matrix. Vectors should be the columns of eigvec\nax : subplot axis (optional)\n    location where graph will be displayed. If not provided, then a new axis will be created.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">labels</span>, </span><span class=\"param\"><span class=\"n\">eigval</span>, </span><span class=\"param\"><span class=\"n\">eigvec</span>, </span><span class=\"param\"><span class=\"n\">ax</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.netcdf", "modulename": "acgc.netcdf", "kind": "module", "doc": "<p>High-level tools for writing and reading netCDF files</p>\n\n<p>Comparison to xarray:</p>\n\n<ul>\n<li>For <em>reading</em> netCDF files, xarray is generally better than <code>acgc.netcdf</code>.</li>\n<li>For <em>creating</em> new netCDF files, using <code>write_geo_nc</code> is often more concise than xarray.</li>\n<li>For <em>editing</em> netCDF files (e.g. modifying a few attributes or variables), \n<code>put_nc_att</code> and <code>put_nc_var</code> can be convenient because the rest of the file remains unchanged, \nunlike xarray. (As of 2023-12, using xarray to read and write a netCDF file does <em>not</em> produce \nidentical files. Command line netCDF operators (NCO) is another option for editing netCDF.)</li>\n</ul>\n"}, {"fullname": "acgc.netcdf.get_nc_var", "modulename": "acgc.netcdf", "qualname": "get_nc_var", "kind": "function", "doc": "<p>Read a variable from a netCDF file</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>filename</strong> (str):\nname/path of netCDF file</li>\n<li><strong>varname</strong> (str):\nname of variable that will be retrieved</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>data</strong> (N-D array):\nvalue of variable</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span>, </span><span class=\"param\"><span class=\"n\">varname</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.netcdf.get_nc_att", "modulename": "acgc.netcdf", "qualname": "get_nc_att", "kind": "function", "doc": "<p>Read an attribute from a netCDF file</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>filename</strong> (str):\nname/path of netCDF file</li>\n<li><strong>varname</strong> (str):\nname of variable</li>\n<li><strong>attname</strong> (str):\nname of attribute that will be retrieved</li>\n<li><strong>glob</strong> (bool, default=False):\nSet glob=True to access global file attribues (varname will be ignored) \nand glob=False for variable attributes</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>data</strong> (float or str):\nattribute value</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span>, </span><span class=\"param\"><span class=\"n\">varname</span>, </span><span class=\"param\"><span class=\"n\">attname</span>, </span><span class=\"param\"><span class=\"n\">glob</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.netcdf.get_nc_varnames", "modulename": "acgc.netcdf", "qualname": "get_nc_varnames", "kind": "function", "doc": "<p>Read variable names from a netCDF file</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>filename</strong> (str):\nname/path of netCDF file</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>list of strings containing variable names within filename</strong></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.netcdf.get_nc_attnames", "modulename": "acgc.netcdf", "qualname": "get_nc_attnames", "kind": "function", "doc": "<p>Read attributes from a netCDF file</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>filename</strong> (str):\nname/path of netCDF file</li>\n<li><strong>varname</strong> (str):\nname of variable</li>\n<li><strong>glob</strong> (bool, default=False):\nSet glob=True to access global file attribues (varname will be ignored) \nand glob=False for variable attributes</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>list of strings containing attribute names</strong></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span>, </span><span class=\"param\"><span class=\"n\">varname</span>, </span><span class=\"param\"><span class=\"n\">glob</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.netcdf.put_nc_var", "modulename": "acgc.netcdf", "qualname": "put_nc_var", "kind": "function", "doc": "<p>Assign a new value to an existing variable and existing file</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>filename</strong> (str):\nname/path of netCDF file</li>\n<li><strong>varname</strong> (str):\nname of variable that will be assigned</li>\n<li><strong>value</strong> (N-D array):\ndata values that will be assigned to variable\nmust have same shape as the current variable values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span>, </span><span class=\"param\"><span class=\"n\">varname</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.netcdf.put_nc_att", "modulename": "acgc.netcdf", "qualname": "put_nc_att", "kind": "function", "doc": "<p>Assign a new value to an existing attribute</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>filename</strong> (str):\nname/path of netCDF file</li>\n<li><strong>varname</strong> (str):\nname of variable</li>\n<li><strong>attname</strong> (str):\nname of attribute that will be assigned</li>\n<li><strong>value</strong> (str, float, list):\ndata values that will be assigned to the attribute</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span>, </span><span class=\"param\"><span class=\"n\">varname</span>, </span><span class=\"param\"><span class=\"n\">attname</span>, </span><span class=\"param\"><span class=\"n\">value</span>, </span><span class=\"param\"><span class=\"n\">glob</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.netcdf.write_geo_nc", "modulename": "acgc.netcdf", "qualname": "write_geo_nc", "kind": "function", "doc": "<p>Create a NetCDF file with geospatial data. Output file is COARDS/CF compliant</p>\n\n<p>This function allows specification of netCDF files more concisely than many alternative\npython packages (e.g. xarray, netCDF4) by making assumptions about the dimensions and \ninferring the dimensions for each variable from the variable shape. This is well suited \nfor many lat-lon-lev-time and xyzt datasets. </p>\n\n<p>Each variable is defined as a dict. </p>\n\n<p>Required keys: </p>\n\n<ul>\n<li>'name'  (str)       variable name </li>\n<li>'value' (array)     N-D array of variable data </li>\n</ul>\n\n<p>Special keys (all optional):</p>\n\n<ul>\n<li>'dim_names' (list of str)  names of the dimension variables corresponding to dimensions of variable\n<ul>\n<li>If dim_names is not provided, the dimension variables will be inferred from the data shape.</li>\n<li>If all dimensions have unique lengths, the inferred dimensions are unambiguous. </li>\n<li>If two or more dimensions have equal lengths, then the dim_names key should be used.</li>\n</ul></li>\n<li>'fill_value'(numeric) value that should replace NaNs</li>\n<li>'unlimited' (bool)  specifies if dimension is unlimited</li>\n<li>'pack'      (bool)  specifies that variable should be compressed with integer packing</li>\n<li>'packtype'  (str, default='i2')   numeric type for packed data, commonly i1 or i2</li>\n<li>'calendar'  (str)   string for COARDS/CF calendar convention. Only used for time variable</li>\n</ul>\n\n<p>All other keys are assigned to variable attributes. CF conventions expect the following:</p>\n\n<ul>\n<li>'long_name' (str)   long name for variable</li>\n<li>'units'     (str)   units of variable</li>\n</ul>\n\n<p>Example: <code>{'name': 'O3',\n      'value': data,\n      'long_name': 'ozone mole fraction',\n      'units': 'mol/mol'}</code></p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>filename</strong> (str):\nname/path for file that will be created</li>\n<li><strong>variables</strong> (list of dict-like):\nEach variable is specified as a dict, as described above.</li>\n<li><strong>xDim</strong> (array or dict-like, optional):\nx dimension of data. If dict-like, then it should contain same keys as variables.\nIf xDim is an array, then it is assumed to be longitude in degrees east and named 'lat'</li>\n<li><strong>yDim</strong> (array or dict-like, optional):\ny dimension of data. If dict-like, then it should contain same keys as variables.\nIf yDim is an array, then it is assumed to be latitude in degrees north and named 'lon'</li>\n<li><strong>zDim</strong> (array or dict-like, optional):\nz dimension of data. If dict-like, then it should contain same keys as variables.\nIf zDim is an array, then it is named 'lev'\nzUnits is named used to infer the variable long name:\n<ul>\n<li>m, km   -> zDim is \"altitude\"</li>\n<li>Pa, hPa -> zDim is \"pressure\"</li>\n<li>None    -> zDim is \"level\"</li>\n</ul></li>\n<li><strong>zUnits</strong> ({'m','km','Pa','hPa','level','' None}):\nUnits for zDim. Ignored if zDim is dict-like.</li>\n<li><strong>tDim</strong> (array or dict-like, optional):\ntime dimension of data. If dict-like, then it should contain the same keys as variables.\nIf tDim is an array, then tUnits is used and the dimension is set as unlimited and \nnamed 'time'. datetime-like variables are supported, as are floats and numeric.</li>\n<li><strong>tUnits</strong> (str, optional):\nUnits for tDim. Special treatment will be used for <code>\"&lt;time units&gt; since &lt;date&gt;\"</code></li>\n<li><strong>globalAtt</strong> (dict-like, optional):\ndict of global file attributes</li>\n<li><strong>classic</strong> (bool, default=True):\nspecify whether file should use netCDF classic data model (includes netCDF4 classic)</li>\n<li><strong>nc4</strong> (bool, default=True):\nspecify whether file should be netCDF4. Required for compression.</li>\n<li><strong>compress</strong> (bool, default=True):\nspecify whether all variables should be compressed (lossless). \nIn addition to lossless compression, setting pack=True for individual variables enables \nlossy integer packing compression.</li>\n<li><strong>clobber</strong> (bool, default=False):\nspecify whether a pre-existing file with the same name should be overwritten</li>\n<li><strong>verbose</strong> (bool, default=False):\nspecify whether extra output should be written while creating the netCDF file</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">filename</span>,</span><span class=\"param\">\t<span class=\"n\">variables</span>,</span><span class=\"param\">\t<span class=\"n\">xDim</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">yDim</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">zDim</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">zUnits</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">tDim</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">tUnits</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">globalAtt</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">classic</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">nc4</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">compress</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">clobber</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar", "modulename": "acgc.solar", "kind": "module", "doc": "<p>Module to calculate solar zenith angle, solar declination, and equation of time \nResults should be accurate to &lt; 0.1 degree, but other modules should be used for \nhigh-precision calculations.</p>\n\n<p>C.D. Holmes 9 Nov 2018</p>\n"}, {"fullname": "acgc.solar.pi180", "modulename": "acgc.solar", "qualname": "pi180", "kind": "variable", "doc": "<p></p>\n", "default_value": "0.017453292519943295"}, {"fullname": "acgc.solar.solar_azimuth_angle", "modulename": "acgc.solar", "qualname": "solar_azimuth_angle", "kind": "function", "doc": "<p>Solar azimuth angle (degrees) for a latitude, longitude, date and time</p>\n\n<p>SAA is degrees clockwise from north.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lat</strong> (float or ndarray):\nlatitude in degrees</li>\n<li><strong>lon</strong> (float or ndarray):\nlongitudes in degrees</li>\n<li><strong>datetimeUTC</strong> (pandas.Timestamp, datetime, or str):\ndate and time in UTC</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>saa</strong> (float or ndarray):\nsolar azimuth angle in degrees (clockwise from north)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lat</span>, </span><span class=\"param\"><span class=\"n\">lon</span>, </span><span class=\"param\"><span class=\"n\">datetimeUTC</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.solar_elevation_angle", "modulename": "acgc.solar", "qualname": "solar_elevation_angle", "kind": "function", "doc": "<p>Solar elevation angle (degrees) above the horizon</p>\n\n<p>The altitude parameter should be the vertical distance \nabove the surrounding terrain that defines the horizon,\nnot necessarily the altitude above sea level or the altitude above ground level.\nFor example, on a mountain peak that is 4000 m above sea level and \n1500 m above the surrounding plateau, the relevant altitude is 1500 m.\nFor an observer on the plateau, the relevant altitude is 0 m.</p>\n\n<p>See documentation for <code>solar_zenith_angle</code> and <code>horizon_zenith_angle</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lat</strong> (float or ndarray):\nlatitude in degrees</li>\n<li><strong>lon</strong> (float or ndarray):\nlongitudes in degrees</li>\n<li><strong>alt</strong> (float or ndarray):\naltitude above surrounding terrain that defines the horizon, meters</li>\n<li><strong>datetimeUTC</strong> (pandas.Timestamp, datetime, or str):\ndate and time in UTC</li>\n<li><strong>refraction</strong> (bool, optional (default=False)):\nspecifies whether to account for atmospheric refraction</li>\n<li><strong>temperature</strong> (float or ndarray, optional (default=10)):\nsurface atmospheric temperature (Celsius), only used for refraction calculation</li>\n<li><strong>pressure</strong> (float or ndarray, optional (default=101325)):\nsurface atmospheric pressure (Pa), only used for refraction calculation</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>sea</strong> (float or ndarray):\nsolar elevation angle in degrees at the designated locations and times\nIf refraction=False, this is the true solar elevation angle\nIf refraction=True, this is the apparent solar elevation angle</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">lat</span>,</span><span class=\"param\">\t<span class=\"n\">lon</span>,</span><span class=\"param\">\t<span class=\"n\">alt</span>,</span><span class=\"param\">\t<span class=\"n\">datetimeUTC</span>,</span><span class=\"param\">\t<span class=\"n\">refraction</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">temperature</span><span class=\"o\">=</span><span class=\"mf\">10.0</span>,</span><span class=\"param\">\t<span class=\"n\">pressure</span><span class=\"o\">=</span><span class=\"mf\">101325.0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.solar_zenith_angle", "modulename": "acgc.solar", "qualname": "solar_zenith_angle", "kind": "function", "doc": "<p>Solar zenith angle (degrees) for a given latitude, longitude, date and time.</p>\n\n<p>Accounts for equation of time and (optionally) for atmospheric refraction.\nAltitude of the observer is not accounted for, which can be important when the sun \nis near the horizon. </p>\n\n<p>Results are accurate to tenths of a degree, except where altitude is important\n(&lt; 20 degrees solar elevation)</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lat</strong> (float or ndarray):\nlatitude in degrees</li>\n<li><strong>lon</strong> (float or ndarray):\nlongitudes in degrees</li>\n<li><strong>datetimeUTC</strong> (pandas.Timestamp, datetime, or str):\ndate and time in UTC</li>\n<li><strong>refraction</strong> (bool, optional (default=False)):\nspecifies whether to account for atmospheric refraction</li>\n<li><strong>temperature</strong> (float or ndarray, optional (default=10)):\nsurface atmospheric temperature (Celsius), only used for refraction calculation</li>\n<li><strong>pressure</strong> (float or ndarray, optional (default=101325)):\nsurface atmospheric pressure (Pa), only used for refraction calculation</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>sza</strong> (float or ndarray):\nsolar zenith angle in degrees at the designated locations and times\nIf refraction=False, this is the true solar zenith angle\nIf refraction=True, this is the apparent solar zenith angle</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">lat</span>,</span><span class=\"param\">\t<span class=\"n\">lon</span>,</span><span class=\"param\">\t<span class=\"n\">datetimeUTC</span>,</span><span class=\"param\">\t<span class=\"n\">refraction</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">temperature</span><span class=\"o\">=</span><span class=\"mf\">10.0</span>,</span><span class=\"param\">\t<span class=\"n\">pressure</span><span class=\"o\">=</span><span class=\"mf\">101325.0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.equation_of_time", "modulename": "acgc.solar", "qualname": "equation_of_time", "kind": "function", "doc": "<p>Equation of time (degrees) for specified date</p>\n\n<p>Implements the \"alternative equation\" from Wikipedia, derived from\n<a href=\"https://web.archive.org/web/20120323231813/http://www.green-life-innovators.org/tiki-index.php?page=The%2BLatitude%2Band%2BLongitude%2Bof%2Bthe%2BSun%2Bby%2BDavid%2BWilliams\">https://web.archive.org/web/20120323231813/http://www.green-life-innovators.org/tiki-index.php?page=The%2BLatitude%2Band%2BLongitude%2Bof%2Bthe%2BSun%2Bby%2BDavid%2BWilliams</a>\nResults checked against NOAA solar calculator and agree within 10 seconds.</p>\n\n<h6 id=\"argument\">Argument</h6>\n\n<p>date : pandas.Timestamp, date, or datetime\n    date for calculation</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>eot</strong> (float):\nequation of time in degrees on the specified date</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">date</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.horizon_zenith_angle", "modulename": "acgc.solar", "qualname": "horizon_zenith_angle", "kind": "function", "doc": "<p>Angle from the zenith to the horizon</p>\n\n<p>The horizon is the locii of points where a line from the \nobservation location to the ellipsoid is tangent to the ellipsoid surface.</p>\n\n<p>The altitude parameter should be the vertical distance \nabove the surrounding terrain that defines the horizon,\nnot necessarily the altitude above sea level or the altitude above ground level.\nFor example, on a mountain peak that is 4000 m above sea level and \n1500 m above the surrounding plateau, the relevant altitude is 1500 m.\nFor an observer on the plateau, the relevant altitude is 0 m.</p>\n\n<p>The implementation below assumes a spherical Earth.\nResults using the WGS84 ellipsoid (see commented code below)\ndiffer from the spherical case by &lt;&lt; 1\u00b0. Terrain,\nwhich is neglected here, has a larger effect on the horizon\nlocation, so the simpler spherical calculation is appropriate. </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lat</strong> (float or ndarray):\nlatitude in degrees</li>\n<li><strong>alt</strong> (float or ndarray):\naltitude above surrounding terrain that defines the horizon, meters</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>hza</strong> (float or ndarray):\nhorizon zenith angle in degrees</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">alt</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.solar_declination", "modulename": "acgc.solar", "qualname": "solar_declination", "kind": "function", "doc": "<p>Calculate solar declination (degrees) for specified date</p>\n\n<p>Implements Eq. 9.68-9.72 from M.Z. Jacobson, Fundamentals of Atmospheric Modeling</p>\n\n<h6 id=\"argument\">Argument</h6>\n\n<p>date : pandas.Timestamp, date, datetime, or str\n    date for calculation</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dec</strong> (float):\nsolar declination in degrees at the specified date</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">date</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.solar_hour_angle", "modulename": "acgc.solar", "qualname": "solar_hour_angle", "kind": "function", "doc": "<p>Solar hour angle (degrees) for specified longitude, date and time</p>\n\n<p>Hour angle is the angular displacement of the sun from the local meridian.\nIt is zero at local noon, negative in the morning, and positive is afternoon.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lon</strong> (float):\nlongitude in degrees east</li>\n<li><strong>datetimeUTC</strong> (pandas.Timestamp or datetime):\ndate and time for calculation, must be UTC</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>ha</strong> (float):\nhour angle in degrees at the specified location and time</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lon</span>, </span><span class=\"param\"><span class=\"n\">datetimeUTC</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.refraction_angle", "modulename": "acgc.solar", "qualname": "refraction_angle", "kind": "function", "doc": "<p>Atmospheric refraction angle for light passing through Earth's atmosphere</p>\n\n<p>The apparent locations in the sky of objects outsides Earth's atmosphere \ndiffers from their true locations due to atmospheric refraction. \n(e.g. sun and moon when they rise and set)\nThe apparent elevation of an object above the horizon is\napparent elevation angle = (true elevation angle) + (refraction angle)</p>\n\n<p>The equations here are from Saemundsson/Bennett, whose calculations use\na typical vertical profile of atmospheric density (i.e. temperature and pressure).\nThe profiles can be rescaled to a particular surface temperature and pressure\nto approximately account for varying atmospheric conditions.\nAccurate refraction calculations should use fully specified vertical profile\nof temperature and pressure, which cannot be done here.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>true_elevation_angle</strong> (float):\ndegrees above horizon of sun or other object</li>\n<li><strong>pressure</strong> (float (default=101325)):\nsurface atmospheric pressure (Pa)</li>\n<li><strong>temperature_celsius</strong> (float (default=10)):\nsurface atmospheric temperature (C)</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>angle</strong> (float):\nrefraction angle in degrees. Value is zero when apparent elevation is below horizon</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">true_elevation_angle</span>, </span><span class=\"param\"><span class=\"n\">pressure</span><span class=\"o\">=</span><span class=\"mf\">101325.0</span>, </span><span class=\"param\"><span class=\"n\">temperature_celsius</span><span class=\"o\">=</span><span class=\"mf\">10.0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.sza", "modulename": "acgc.solar", "qualname": "sza", "kind": "function", "doc": "<p>Solar zenith angle (degrees) for a given latitude, longitude, date and time.</p>\n\n<p>Accounts for equation of time and (optionally) for atmospheric refraction.\nAltitude of the observer is not accounted for, which can be important when the sun \nis near the horizon. </p>\n\n<p>Results are accurate to tenths of a degree, except where altitude is important\n(&lt; 20 degrees solar elevation)</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lat</strong> (float or ndarray):\nlatitude in degrees</li>\n<li><strong>lon</strong> (float or ndarray):\nlongitudes in degrees</li>\n<li><strong>datetimeUTC</strong> (pandas.Timestamp, datetime, or str):\ndate and time in UTC</li>\n<li><strong>refraction</strong> (bool, optional (default=False)):\nspecifies whether to account for atmospheric refraction</li>\n<li><strong>temperature</strong> (float or ndarray, optional (default=10)):\nsurface atmospheric temperature (Celsius), only used for refraction calculation</li>\n<li><strong>pressure</strong> (float or ndarray, optional (default=101325)):\nsurface atmospheric pressure (Pa), only used for refraction calculation</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>sza</strong> (float or ndarray):\nsolar zenith angle in degrees at the designated locations and times\nIf refraction=False, this is the true solar zenith angle\nIf refraction=True, this is the apparent solar zenith angle</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">lat</span>,</span><span class=\"param\">\t<span class=\"n\">lon</span>,</span><span class=\"param\">\t<span class=\"n\">datetimeUTC</span>,</span><span class=\"param\">\t<span class=\"n\">refraction</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">temperature</span><span class=\"o\">=</span><span class=\"mf\">10.0</span>,</span><span class=\"param\">\t<span class=\"n\">pressure</span><span class=\"o\">=</span><span class=\"mf\">101325.0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.saa", "modulename": "acgc.solar", "qualname": "saa", "kind": "function", "doc": "<p>Solar azimuth angle (degrees) for a latitude, longitude, date and time</p>\n\n<p>SAA is degrees clockwise from north.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lat</strong> (float or ndarray):\nlatitude in degrees</li>\n<li><strong>lon</strong> (float or ndarray):\nlongitudes in degrees</li>\n<li><strong>datetimeUTC</strong> (pandas.Timestamp, datetime, or str):\ndate and time in UTC</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>saa</strong> (float or ndarray):\nsolar azimuth angle in degrees (clockwise from north)</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">lat</span>, </span><span class=\"param\"><span class=\"n\">lon</span>, </span><span class=\"param\"><span class=\"n\">datetimeUTC</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.sea", "modulename": "acgc.solar", "qualname": "sea", "kind": "function", "doc": "<p>Solar elevation angle (degrees) above the horizon</p>\n\n<p>The altitude parameter should be the vertical distance \nabove the surrounding terrain that defines the horizon,\nnot necessarily the altitude above sea level or the altitude above ground level.\nFor example, on a mountain peak that is 4000 m above sea level and \n1500 m above the surrounding plateau, the relevant altitude is 1500 m.\nFor an observer on the plateau, the relevant altitude is 0 m.</p>\n\n<p>See documentation for <code>solar_zenith_angle</code> and <code>horizon_zenith_angle</code>.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>lat</strong> (float or ndarray):\nlatitude in degrees</li>\n<li><strong>lon</strong> (float or ndarray):\nlongitudes in degrees</li>\n<li><strong>alt</strong> (float or ndarray):\naltitude above surrounding terrain that defines the horizon, meters</li>\n<li><strong>datetimeUTC</strong> (pandas.Timestamp, datetime, or str):\ndate and time in UTC</li>\n<li><strong>refraction</strong> (bool, optional (default=False)):\nspecifies whether to account for atmospheric refraction</li>\n<li><strong>temperature</strong> (float or ndarray, optional (default=10)):\nsurface atmospheric temperature (Celsius), only used for refraction calculation</li>\n<li><strong>pressure</strong> (float or ndarray, optional (default=101325)):\nsurface atmospheric pressure (Pa), only used for refraction calculation</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>sea</strong> (float or ndarray):\nsolar elevation angle in degrees at the designated locations and times\nIf refraction=False, this is the true solar elevation angle\nIf refraction=True, this is the apparent solar elevation angle</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">lat</span>,</span><span class=\"param\">\t<span class=\"n\">lon</span>,</span><span class=\"param\">\t<span class=\"n\">alt</span>,</span><span class=\"param\">\t<span class=\"n\">datetimeUTC</span>,</span><span class=\"param\">\t<span class=\"n\">refraction</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">temperature</span><span class=\"o\">=</span><span class=\"mf\">10.0</span>,</span><span class=\"param\">\t<span class=\"n\">pressure</span><span class=\"o\">=</span><span class=\"mf\">101325.0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.equationOfTime", "modulename": "acgc.solar", "qualname": "equationOfTime", "kind": "function", "doc": "<p>Equation of time (degrees) for specified date</p>\n\n<p>Implements the \"alternative equation\" from Wikipedia, derived from\n<a href=\"https://web.archive.org/web/20120323231813/http://www.green-life-innovators.org/tiki-index.php?page=The%2BLatitude%2Band%2BLongitude%2Bof%2Bthe%2BSun%2Bby%2BDavid%2BWilliams\">https://web.archive.org/web/20120323231813/http://www.green-life-innovators.org/tiki-index.php?page=The%2BLatitude%2Band%2BLongitude%2Bof%2Bthe%2BSun%2Bby%2BDavid%2BWilliams</a>\nResults checked against NOAA solar calculator and agree within 10 seconds.</p>\n\n<h6 id=\"argument\">Argument</h6>\n\n<p>date : pandas.Timestamp, date, or datetime\n    date for calculation</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>eot</strong> (float):\nequation of time in degrees on the specified date</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">date</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.solar.solarDeclination", "modulename": "acgc.solar", "qualname": "solarDeclination", "kind": "function", "doc": "<p>Calculate solar declination (degrees) for specified date</p>\n\n<p>Implements Eq. 9.68-9.72 from M.Z. Jacobson, Fundamentals of Atmospheric Modeling</p>\n\n<h6 id=\"argument\">Argument</h6>\n\n<p>date : pandas.Timestamp, date, datetime, or str\n    date for calculation</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>dec</strong> (float):\nsolar declination in degrees at the specified date</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">date</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats", "modulename": "acgc.stats", "kind": "module", "doc": "<p>A collection of statistical methods</p>\n\n<p>The contents of all submodules are imported into <code>acgc.stats</code>. \nFor example, <code>acgc.stats.sma</code> is the function <code>acgc.stats.bivariate_lines.sma</code>\nwithin <code>acgc.stats.bivariate_lines</code>.</p>\n\n<p>Useful functions include BivariateStatistics, line fitting methods (sma, sen, york), \nweighted statistics (wmean, wmedian, wcov, wcorr, etc.), partial_corr, among others. \nSee <code>help(acgc.stats)</code> for complete list of methods.</p>\n\n<p>See documentation within submodules.</p>\n"}, {"fullname": "acgc.stats.bivariate", "modulename": "acgc.stats.bivariate", "kind": "module", "doc": "<p>Bivariate statistics</p>\n\n<p>Statistical measures of relationships between two populations</p>\n"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics", "kind": "class", "doc": "<p>A suite of common statistics to quantify bivariate relationships</p>\n\n<p>Class method 'summary' provides a formatted summary of these statistics</p>\n\n<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>xmean, ymean</strong> (float):\nmean of x and y variables</li>\n<li><strong>xmedian, ymedian</strong> (float):\nmedian of x and y variables</li>\n<li><strong>xstd, ystd</strong> (float):\nstandard deviation of x and y variables</li>\n<li><strong>mean_difference, md</strong> (float):\nymean - xmean</li>\n<li><strong>mean_absolute_difference, mad</strong> (float):\nmean( |y-x| )</li>\n<li><strong>relative_mean_difference, rmd</strong> (float):\nmd / xmean</li>\n<li><strong>relative_mean_absolute_difference, rmad</strong> (float):\nmad / xmean</li>\n<li><strong>standardized_mean_difference, smd</strong> (float):\nmd / xstd</li>\n<li><strong>standardized_mean_absolute_difference, smad</strong> (float):\nmad /xstd</li>\n<li><strong>mean_relative_difference, mrd</strong> (float):\nmean(y/x) - 1</li>\n<li><strong>mean_log10_ratio, mlr</strong> (float):\nmean( log10(y/x) )</li>\n<li><strong>mean_absolute_log10_ratio, malr</strong> (float):\nmean( abs( log10(y/x) ) )</li>\n<li><strong>median_difference, medd</strong> (float):\nmedian(y-x)</li>\n<li><strong>median_absolute_difference, medad</strong> (float):\nmedian(|y-x|)</li>\n<li><strong>relative_median_difference, rmedd</strong> (float):\nmedian(y-x) / xmedian</li>\n<li><strong>relative_median_absolute_difference, rmedad</strong> (float):\nmedian(|y-x|) / xmedian</li>\n<li><strong>median_relative_difference, medianrd, medrd</strong> (float):\nmedian(y/x)-1</li>\n<li><strong>median_log10_ratio, medlr</strong> (float):\nmedian( log10(y/x) )</li>\n<li><strong>median_absolute_log10_ratio, medalr</strong> (float):\nmedian( abs( log10(y/x) ) )</li>\n<li><strong>normalized_mean_bias_factor, nmbf</strong> (float):\nsee <code>nmbf</code></li>\n<li><strong>normalized_mean_absolute_error_factor, nmaef</strong> (float):\nsee <code>nmaef</code></li>\n<li><strong>root_mean_square_difference, rmsd</strong> (float):\n$\\sqrt{ \\langle (y - x)^2 \\rangle }$</li>\n<li><strong>covariance</strong> (float):\ncov(x,y)</li>\n<li><strong>correlation_pearson, correlation, pearsonr, R, r</strong> (float):\nPearson linear correlation coefficient</li>\n<li><strong>correlation_spearman, spearmanr</strong> (float):\nSpearman, non-parametric rank correlation coefficient</li>\n<li><strong>R2, r2</strong> (float):\nLinear coefficient of determination, $R^2$</li>\n</ul>\n"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.__init__", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.__init__", "kind": "function", "doc": "<p>Compute suite of bivariate statistics during initialization</p>\n\n<p>Statistic values are saved in attributes.\nCAUTION: Weights w are ignored except in SMA fit</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x</strong> (ndarray or str):\nindependent variable values</li>\n<li><strong>y</strong> (ndarray or str):\ndependent variable values, same size as x</li>\n<li><strong>w</strong> (ndarray or str, optional):\nweights for points (x,y), same size as x and y</li>\n<li><strong>dropna</strong> (bool, optional (default=False)):\ndrops NaN values from x, y, and w</li>\n<li><strong>data</strong> (dict-like, optional):\nif x, y, or w are str, then they should be keys in data</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">w</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">dropna</span><span class=\"o\">=</span><span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.xmean", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.xmean", "kind": "variable", "doc": "<p></p>\n"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.ymean", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.ymean", "kind": "variable", "doc": "<p></p>\n"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.xmedian", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.xmedian", "kind": "variable", "doc": "<p></p>\n"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.ymedian", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.ymedian", "kind": "variable", "doc": "<p></p>\n"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.xstd", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.xstd", "kind": "variable", "doc": "<p></p>\n"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.ystd", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.ystd", "kind": "variable", "doc": "<p></p>\n"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.covariance", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.covariance", "kind": "variable", "doc": "<p></p>\n"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.fitline", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.fitline", "kind": "function", "doc": "<p>Compute bivariate line fit</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>method</strong> (str):\nline fitting method: sma (default), ols, wls, York, sen, siegel</li>\n<li><strong>intercept</strong> (bool):\ndefines whether non-zero intercept should be fitted</li>\n<li><strong>**kwargs</strong>: passed to <code>acgc.stats.sma</code> (e.g. robust=True)</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>result</strong> (dict):\ndictionary with keys:\n<ul>\n<li>slope (float)\nslope of fitted line</li>\n<li>intercept (float)\nintercept of fitted line</li>\n<li>fittedvalues (array (N,))\nvalues on fit line</li>\n<li>residuals (array (N,))\nresidual from fit line</li>\n</ul></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;sma&#39;</span>, </span><span class=\"param\"><span class=\"n\">intercept</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.slope", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.slope", "kind": "function", "doc": "<p>Compute slope of bivariate line fit</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>method</strong> (str):\nline fitting method: sma (default), ols, wls</li>\n<li><strong>intercept</strong> (bool):\ndefines whether non-zero intercept should be fitted</li>\n<li><strong>**kwargs</strong>: passed to <code>fitline</code></li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>slope</strong> (float):\nvalue of y intercept</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;sma&#39;</span>, </span><span class=\"param\"><span class=\"n\">intercept</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.intercept", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.intercept", "kind": "function", "doc": "<p>Compute intercept of bivariate line fit</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>method</strong> (str):\nline fitting method: sma (default) or ols</li>\n<li><strong>intercept</strong> (bool):\ndefines whether non-zero intercept should be fitted</li>\n<li><strong>**kwargs</strong>: passed to <code>fitline</code></li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>intercept</strong> (float):\nvalue of y intercept</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;sma&#39;</span>, </span><span class=\"param\"><span class=\"n\">intercept</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.summary_dict", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.summary_dict", "kind": "function", "doc": "<p>Summarize bivariate statistics into a dict</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>vars</strong> (list or str, default='common'):\nnames of attribute variables to include in summary\nnames are case insensitive <br />\nThe following strings are also accepted in place of a list \n    \"all\" (displays all variables)\n    \"common\" (displays all measures of mean difference)</li>\n<li><strong>fitline_kw</strong> (dict, default=None)):\nkeywords passed to self.fitline()</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>summary</strong> (dict):\nnames and values of variables</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">variables</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">fitline_kw</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">floatformat_fiteqn</span><span class=\"o\">=</span><span class=\"s1\">&#39;</span><span class=\"si\">{:.3f}</span><span class=\"s1\">&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.summary", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.summary", "kind": "function", "doc": "<p>Summarize bivariate statistics</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>vars</strong> (list or str, default='common'):\nnames of attribute variables to include in summary\nnames are case insensitive <br />\nThe following strings are also accepted in place of a list \n    \"all\" (displays all variables)\n    \"common\" (displays all measures of mean difference)</li>\n<li><strong>floatformat : str, default='{</strong> (.4f}'):\nformat specifier for floating point values</li>\n<li><strong>floatformat_fiteqn</strong> (str, default=floatformat):\nformat specifier for slope and intercept (a,b) in y = a x + b</li>\n<li><strong>stringlength</strong> (int, default=None):\nlength of the variables on output\ndefault (None) is to use the length of the longest variable name</li>\n<li><strong>fitline_kw</strong> (dict, default=None):\nkeywords passed to <code>fitline</code></li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>summary</strong> (str):\nnames and values of variables</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">variables</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fitline_kw</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">floatformat</span><span class=\"o\">=</span><span class=\"s1\">&#39;</span><span class=\"si\">{:.4f}</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">floatformat_fiteqn</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">stringlength</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate.BivariateStatistics.summary_fig_inset", "modulename": "acgc.stats.bivariate", "qualname": "BivariateStatistics.summary_fig_inset", "kind": "function", "doc": "<p>Display bivariate statistics as a table inset on a plot axis</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>ax</strong> (matplotlib.Figure.Axis):\naxis where the table will be displayed</li>\n<li><strong>variables</strong> (list or str, default='common'):\nnames of attribute variables to include in summary\nnames are case insensitive <br />\nThe following strings are also accepted in place of a list \n    \"all\" (displays all variables)\n    \"common\" (displays all measures of mean difference)</li>\n<li><strong>fitline_kw</strong> (dict, default=None):\nkeywords passed to <code>fitline</code></li>\n<li><strong>floatformat : str, default='{</strong> (.3f}'):\nformat specifier for floating point values</li>\n<li><strong>floatformat_fiteqn</strong> (str, default=floatformat):\nformat specifier for slope and intercept (a,b) in y = a x + b</li>\n<li><strong>loc</strong> (tuple (x0,y0), default=(0.85, 0.05)):\nlocation on the axis where the table will be drawn\ncan be in data units or axes units [0-1]</li>\n<li><strong>loc_units</strong> ({'axes' (default), 'data'}):\nspecifies whether loc has 'data' units or 'axes' units [0-1]</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>text1, text2</strong> (matplotlib text object):\nArtist for the two text boxes</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">ax</span>,</span><span class=\"param\">\t<span class=\"n\">variables</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fitline_kw</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">floatformat</span><span class=\"o\">=</span><span class=\"s1\">&#39;</span><span class=\"si\">{:.3f}</span><span class=\"s1\">&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">floatformat_fiteqn</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">loc</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">loc_units</span><span class=\"o\">=</span><span class=\"s1\">&#39;axes&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate.nmb", "modulename": "acgc.stats.bivariate", "qualname": "nmb", "kind": "function", "doc": "<p>Compute Normalized Mean Bias (NMB)</p>\n\n<p>NMB = ( mean(x1) - mean(x0) ) / mean(x0)</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x0</strong> (array_like):\nreference values</li>\n<li><strong>x1</strong> (array_like):\nexperiment values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x0</span>, </span><span class=\"param\"><span class=\"n\">x1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate.nmae", "modulename": "acgc.stats.bivariate", "qualname": "nmae", "kind": "function", "doc": "<p>Compute Normalized Mean Absolute Error (NMAE)</p>\n\n<p>NMAE = mean(abs(x1 - x0)) / abs(mean(x0))</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x0</strong> (array_like):\nreference values</li>\n<li><strong>x1</strong> (array_like):\nexperiment values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x0</span>, </span><span class=\"param\"><span class=\"n\">x1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate.nmbf", "modulename": "acgc.stats.bivariate", "qualname": "nmbf", "kind": "function", "doc": "<p>Compute Normalized Mean Bias Factor (NMBF)</p>\n\n<p>Definition from Yu et al. (2006) <a href=\"https://doi.org/10.1002/asl.125\">https://doi.org/10.1002/asl.125</a></p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x0</strong> (array_like):\nreference values</li>\n<li><strong>x1</strong> (array_like):\nexperiment values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x0</span>, </span><span class=\"param\"><span class=\"n\">x1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate.nmaef", "modulename": "acgc.stats.bivariate", "qualname": "nmaef", "kind": "function", "doc": "<p>Compute Normalized Mean Absolute Error Factor (NMAEF)</p>\n\n<p>Definition from Yu et al. (2006) <a href=\"https://doi.org/10.1002/asl.125\">https://doi.org/10.1002/asl.125</a></p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x0</strong> (array_like):\nreference values</li>\n<li><strong>x1</strong> (array_like):\nexperiment values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x0</span>, </span><span class=\"param\"><span class=\"n\">x1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate_lines", "modulename": "acgc.stats.bivariate_lines", "kind": "module", "doc": "<p>Specialized methods of bivariate line fitting</p>\n\n<ul>\n<li>Standard major axis (SMA) also called reduced major axis (RMA)</li>\n<li>York regression, for data with errors in x and y</li>\n<li>Theil-Sen, non-parametric slope estimation (use numba to accelerate the function in this module)</li>\n</ul>\n"}, {"fullname": "acgc.stats.bivariate_lines.bivariate_line_equation", "modulename": "acgc.stats.bivariate_lines", "qualname": "bivariate_line_equation", "kind": "function", "doc": "<p>Write equation for the fitted line</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>fitresult</strong> (dict):\nresults of the line fit</li>\n<li><strong>floatformat</strong> (str):\nformat string for the numerical values (default='{:.3f}')</li>\n<li><strong>ystring</strong> ({'include' (default), 'separate', 'none'}):\nspecifies whether \"y =\" should be included in result, a separate item in tuple, or none</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>fitline_string</strong> (str):\nequation for the the fitted line, in the form \"y = a x + b\" or \"y = a x\"</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">fitresult</span>, </span><span class=\"param\"><span class=\"n\">floatformat</span><span class=\"o\">=</span><span class=\"s1\">&#39;</span><span class=\"si\">{:.3f}</span><span class=\"s1\">&#39;</span>, </span><span class=\"param\"><span class=\"n\">ystring</span><span class=\"o\">=</span><span class=\"s1\">&#39;include&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate_lines.sma", "modulename": "acgc.stats.bivariate_lines", "qualname": "sma", "kind": "function", "doc": "<p>Standard Major-Axis (SMA) line fitting</p>\n\n<p>Calculate standard major axis, aka reduced major axis, fit to \ndata X and Y. The main advantage of this over ordinary least squares is \nthat the best fit of Y to X will be the same as the best fit of X to Y.</p>\n\n<p>The fit equations and confidence intervals are implemented following \nWarton et al. (2006). Robust fits use the FastMCD covariance estimate \nfrom Rousseeuw and Van Driessen (1999). While there are many alternative \nrobust covariance estimators (e.g. other papers by D.I. Warton using M-estimators), \nthe FastMCD algorithm is default in Matlab. When the standard error or \nuncertainty of each point is known, then weighted SMA may be preferrable to \nrobust SMA. The conventional choice of weights for each point i is \nW_i = 1 / ( var(X_i) + var(Y_i) ), where var() is the variance \n(squared standard error).</p>\n\n<p>References \nWarton, D. I., Wright, I. J., Falster, D. S. and Westoby, M.: \n    Bivariate line-fitting methods for allometry, Biol. Rev., 81(02), 259, \n    doi:10.1017/S1464793106007007, 2006.\nRousseeuw, P. J. and Van Driessen, K.: A Fast Algorithm for the Minimum \n    Covariance Determinant Estimator, Technometrics, 41(3), 1999.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>X, Y</strong> (array_like or str):\nInput values, Must have same length.</li>\n<li><strong>W</strong> (array_like or str, optional):\narray of weights for each X-Y point, typically W_i = 1/(var(X_i)+var(Y_i))</li>\n<li><strong>data</strong> (dict_like, optional):\ndata structure containing variables. Used when X, Y, or W are str.</li>\n<li><strong>alpha</strong> (float (default = 0.95)):\nDesired confidence level [0,1] for output.</li>\n<li><strong>intercept</strong> (bool, default=True):\nSpecify if the fitted model should include a non-zero intercept.\nThe model will be forced through the origin (0,0) if intercept=False.</li>\n<li><strong>robust</strong> (bool, default=False):\nUse statistical methods that are robust to the presence of outliers</li>\n<li><strong>robust_method</strong> ({'FastMCD' (default), 'Huber', 'Biweight'}):\nMethod for calculating robust variance and covariance. Options:\n<ul>\n<li>'MCD' or 'FastMCD' for Fast MCD</li>\n<li>'Huber' for Huber's T: reduce, not eliminate, influence of outliers</li>\n<li>'Biweight' for Tukey's Biweight: reduces then eliminates influence of outliers</li>\n</ul></li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>fitresult</strong> (dict):\nContains the following keys:\n<ul>\n<li>slope (float)\nSlope or Gradient of Y vs. X</li>\n<li>intercept (float)\nY intercept.</li>\n<li>slope_ste (float)\nStandard error of slope estimate</li>\n<li>intercept_ste (float)\nstandard error of intercept estimate</li>\n<li>slope_interval ([float, float])\nconfidence interval for gradient at confidence level alpha</li>\n<li>intercept_interval ([float, float])\nconfidence interval for intercept at confidence level alpha</li>\n<li>alpha (float)\nconfidence level [0,1] for slope and intercept intervals</li>\n<li>df_model (float)\ndegrees of freedom for model</li>\n<li>df_resid (float)\ndegrees of freedom for residuals</li>\n<li>params ([float,float])\narray of fitted parameters</li>\n<li>fittedvalues (ndarray)\narray of fitted values</li>\n<li>resid (ndarray)\narray of residual values</li>\n</ul></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">X</span>,</span><span class=\"param\">\t<span class=\"n\">Y</span>,</span><span class=\"param\">\t<span class=\"n\">W</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"mf\">0.95</span>,</span><span class=\"param\">\t<span class=\"n\">intercept</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">robust</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">robust_method</span><span class=\"o\">=</span><span class=\"s1\">&#39;FastMCD&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate_lines.smafit", "modulename": "acgc.stats.bivariate_lines", "qualname": "smafit", "kind": "function", "doc": "<p>Alias for <code>sma</code></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate_lines.sen", "modulename": "acgc.stats.bivariate_lines", "qualname": "sen", "kind": "function", "doc": "<p>'Theil-Sen slope estimate</p>\n\n<p>This function wraps <code>scipy.stats.theilslopes</code> and provides\nresults in the same dict format as the other line fitting methods \nin this module</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x, y</strong> (ndarray):\ndependent (x) and independent (y) variables for fitting</li>\n<li><strong>alpha</strong> (float (default = 0.95)):\nDesired confidence level [0,1] for output.</li>\n<li><strong>method</strong> ({'separate' (default), 'joint'}):\nMethod for estimating intercept. \n<ul>\n<li>'separate' uses np.median(y) - slope * np.median(x)</li>\n<li>'joint' uses np.median( y - slope * x )</li>\n</ul></li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>fitresult</strong> (dict):\nContains the following keys:\n<ul>\n<li>slope (float)\nSlope or Gradient of Y vs. X</li>\n<li>intercept (float)\nY intercept.</li>\n<li>slope_ste (float)\nStandard error of slope estimate</li>\n<li>intercept_ste (float)\nstandard error of intercept estimate</li>\n<li>slope_interval ([float, float])\nconfidence interval for gradient at confidence level alpha</li>\n<li>intercept_interval ([float, float])\nconfidence interval for intercept at confidence level alpha</li>\n<li>alpha (float)\nconfidence level [0,1] for slope and intercept intervals</li>\n<li>df_model (float)\ndegrees of freedom for model</li>\n<li>df_resid (float)\ndegrees of freedom for residuals</li>\n<li>params ([float,float])\narray of fitted parameters</li>\n<li>fittedvalues (ndarray)\narray of fitted values</li>\n<li>resid (ndarray)\narray of residual values</li>\n</ul></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"mf\">0.95</span>, </span><span class=\"param\"><span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;separate&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate_lines.sen_slope", "modulename": "acgc.stats.bivariate_lines", "qualname": "sen_slope", "kind": "function", "doc": "<p>Alias for <code>sen</code></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate_lines.sen_numba", "modulename": "acgc.stats.bivariate_lines", "qualname": "sen_numba", "kind": "function", "doc": "<p>Estimate linear trend using the Thiel-Sen method</p>\n\n<p>This non-parametric method finds the median slope among all\ncombinations of time points. \nscipy.stats.theilslopes provides the same slope estimate, with <br />\nconfidence intervals. However, this function is faster for \nlarge datasets due to Numba </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x</strong> (array_like (N,)):\nindependent variable</li>\n<li><strong>y</strong> (array_like (N,)):\ndependent variable</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>sen</strong> (float):\nthe median slope</li>\n<li><strong>slopes</strong> (array (N*N,)):\nall slope estimates from all combinations of x and y</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.bivariate_lines.york", "modulename": "acgc.stats.bivariate_lines", "qualname": "york", "kind": "function", "doc": "<p>York regression accounting for error in x and y\nFollows the notation and algorithm of York et al. (2004) Section III</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x, y</strong> (ndarray):\ndependent (x) and independent (y) variables for fitting</li>\n<li><strong>err_x, err_y</strong> (ndarray (default=1)):\nstandard deviation of errors/uncertainty in x and y</li>\n<li><strong>rerr_xy</strong> (float (default=0)):\ncorrelation coefficient for errors in x and y, \ndefault to rerr_xy=0 meaning that the errors in x are unrelated to errors in y\nerr_x, err_y, and rerr_xy can be constants or arrays of the same length as x and y</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>fitresult</strong> (dict):\nContains the following keys:\n<ul>\n<li>slope (float)\nSlope or Gradient of Y vs. X</li>\n<li>intercept (float)\nY intercept.</li>\n<li>slope_ste (float)\nStandard error of slope estimate</li>\n<li>intercept_ste (float)\nstandard error of intercept estimate</li>\n<li>slope_interval ([float, float])\nconfidence interval for gradient at confidence level alpha</li>\n<li>intercept_interval ([float, float])\nconfidence interval for intercept at confidence level alpha</li>\n<li>alpha (float)\nconfidence level [0,1] for slope and intercept intervals</li>\n<li>df_model (float)\ndegrees of freedom for model</li>\n<li>df_resid (float)\ndegrees of freedom for residuals</li>\n<li>params ([float,float])\narray of fitted parameters</li>\n<li>fittedvalues (ndarray)\narray of fitted values</li>\n<li>resid (ndarray)\narray of residual values</li>\n</ul></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">err_x</span><span class=\"o\">=</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">err_y</span><span class=\"o\">=</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">rerr_xy</span><span class=\"o\">=</span><span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.boxcar", "modulename": "acgc.stats.boxcar", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "acgc.stats.boxcar.boxcar", "modulename": "acgc.stats.boxcar", "qualname": "boxcar", "kind": "function", "doc": "<p>Calculate a boxcar average (i.e. running mean, median, or polynomial fit) of an array. </p>\n\n<p>Elements of input array are assumed to be equally spaced along an (unspecified) \ncoordinate dimension.</p>\n\n<p>A centered boxcar average with even widths is traditionally\nnot allowed. This BOXCAR program allows even widths by\ngiving half weights to elements on either end of the\naveraging window and full weights to all others. A centered\naverage with even width therefore uses uses WIDTH+1\nelements in its averaging kernel.  </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>array</strong> (array of float (N,)):\n1D array of values to average</li>\n<li><strong>width</strong> (int):\nnumber of elements to include in the average.</li>\n<li><strong>align</strong> (str):\nspecifies how the averaging window for each element of the output array\naligns with the input array. \nValues: center (default), forward (trailing elements), backward (leading elements)</li>\n<li><strong>method</strong> ({'mean' (default), 'median', 'polynomial'}):\nspecifies the averaging kernel function</li>\n<li><strong>order</strong> (int, default=2):\nspecifies the polynomial order to fit within each boxcar window.\nThis has no effect unless <code>method</code>='polynomial'\nA parabola is order=2; order=0 is equivalent to method=\"mean\"</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>result</strong> (array of float (N,)):\n1D array with averages with same size as input array. \nElements on either end may be NaN</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">array</span>, </span><span class=\"param\"><span class=\"n\">width</span>, </span><span class=\"param\"><span class=\"n\">align</span><span class=\"o\">=</span><span class=\"s1\">&#39;center&#39;</span>, </span><span class=\"param\"><span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;mean&#39;</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.boxcar.boxcarpoly", "modulename": "acgc.stats.boxcar", "qualname": "boxcarpoly", "kind": "function", "doc": "<p>Calculate a boxcar polynomial (i.e. running polynomial fit) of an array. </p>\n\n<p>See <code>boxcar</code> for parameter definitions</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">array</span>, </span><span class=\"param\"><span class=\"n\">width</span>, </span><span class=\"param\"><span class=\"n\">order</span><span class=\"o\">=</span><span class=\"mi\">2</span>, </span><span class=\"param\"><span class=\"n\">align</span><span class=\"o\">=</span><span class=\"s1\">&#39;center&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.partial_corr", "modulename": "acgc.stats.partial_corr", "kind": "module", "doc": "<p>Partial Correlation in Python </p>\n\n<p>Clone of Matlab's partialcorr, written by Fabian Pedregosa-Izquierdo, f@bianp.net</p>\n"}, {"fullname": "acgc.stats.partial_corr.partial_corr", "modulename": "acgc.stats.partial_corr", "qualname": "partial_corr", "kind": "function", "doc": "<p>Returns the sample linear partial correlation coefficients between pairs of variables in C, \ncontrolling for the remaining variables in C.</p>\n\n<p>This uses the linear regression approach to compute the partial \ncorrelation (might be slow for a huge number of variables). The \nalgorithm is detailed here:\n<a href=\"http://en.wikipedia.org/wiki/Partial_correlation#Using_linear_regression\">http://en.wikipedia.org/wiki/Partial_correlation#Using_linear_regression</a>\nTaking X and Y two variables of interest and Z the matrix with all the variable minus {X, Y},\nthe algorithm can be summarized as\n    1) perform a normal linear least-squares regression with X as the target and Z as the predictor\n    2) calculate the residuals in Step #1\n    3) perform a normal linear least-squares regression with Y as the target and Z as the predictor\n    4) calculate the residuals in Step #3\n    5) calculate the correlation coefficient between the residuals from Steps #2 and #4; \nThe result is the partial correlation between X and Y while controlling for the effect of Z</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>C</strong> (array-like, (n, p)):\nArray with the different variables. Each column of C is taken as a variable</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>P</strong> (array-like, (p, p)):\nP[i, j] contains the partial correlation of C[:, i] and C[:, j] controlling\nfor the remaining variables in C.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">C</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.sma_warton_fit", "modulename": "acgc.stats.sma_warton_fit", "kind": "module", "doc": "<p>Alternate implementation of Robust SMA line fitting</p>\n\n<p>This module implements the robust fitting method of Taskinen and Warton \n(2013, http://dx.doi.org/10.1016/j.jtbi.2013.05.010). \nThe main difference from <code>acgc.stats.bivariate_lines.sma</code> is the method\nfor computing the robust covariance. For normal (non-robust) SMA, both\nfunctions should give the same results.</p>\n"}, {"fullname": "acgc.stats.sma_warton_fit.sma_warton", "modulename": "acgc.stats.sma_warton_fit", "qualname": "sma_warton", "kind": "function", "doc": "<p>Standard major axis, aka reduced major axis</p>\n\n<p>The main advantage of this is that the best fit\nof Y to X will be the same as the best fit of X to Y.\nMore details in Warton et al. Biology Review 2006 </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>X, Y</strong> (array_like):\nInput values, Must have same length.</li>\n<li><strong>alpha</strong> (float):\nDesired confidence level for output.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>Gradient</strong> (float):\nGradient or Slope of Y vs. X</li>\n<li><strong>Intercept</strong> (floats):\nY intercept.</li>\n<li><strong>stdgrad</strong> (float):\nStandard error of gradient estimate</li>\n<li><strong>stdint</strong> (float):\nstandard error of intercept estimate</li>\n<li><strong>ci_grad</strong> ([float, float]):\nconfidence interval for gradient at confidence level alpha</li>\n<li><strong>ci_int</strong> ([float, float]):\nconfidence interval for intercept at confidence level alpha</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">X0</span>, </span><span class=\"param\"><span class=\"n\">Y0</span>, </span><span class=\"param\"><span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"mf\">0.05</span>, </span><span class=\"param\"><span class=\"n\">intercept</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">robust</span><span class=\"o\">=</span><span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">wartonrobust</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.tapply", "modulename": "acgc.stats.tapply", "kind": "module", "doc": "<p>tapply</p>\n"}, {"fullname": "acgc.stats.tapply.tapply", "modulename": "acgc.stats.tapply", "qualname": "tapply", "kind": "function", "doc": "<p>Apply user-specified function to array elements within each group</p>\n\n<p>Reproduces tapply function in R</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>array</strong> (array_like):\nvalues that will be grouped</li>\n<li><strong>group</strong> (array_like):\ngroup ids for the elements of array, must have same size as array</li>\n<li><strong>f</strong> (callable):\nfunction with one argument that will be applied to each group, e.g. np.mean</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>result</strong> (array_like):\nvalue of function applied to each group. \nThe number of elements in result equals the number of unique elements of the group argument</li>\n<li><strong>groupvalues</strong> (array_like):\ngroup ids corresponding to the elements of result</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">array</span>, </span><span class=\"param\"><span class=\"n\">group</span>, </span><span class=\"param\"><span class=\"n\">f</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.weighted", "modulename": "acgc.stats.weighted", "kind": "module", "doc": "<p>Weighted variance, covariance, correlation, median, and quantiles</p>\n"}, {"fullname": "acgc.stats.weighted.wcorr", "modulename": "acgc.stats.weighted", "qualname": "wcorr", "kind": "function", "doc": "<p>Weighted correlation coeffient</p>\n\n<p>Calculate the Pearson linear correlation coefficient of x and y using weights w. \nThis is derived from the weighted covariance and weighted variance.\nEquivalent to R2w in Eq. 4 from Willett and Singer (1988).\nSee notes below on interpretation.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x, y</strong> (array_like):\nvalues to be analyzed</li>\n<li><strong>w</strong> (array_like, default=None):\nweights for each element of x; can be ommitted if robust=True</li>\n<li><strong>ddof</strong> (int, default=1):\ndifferential degrees of freedom. See note above.</li>\n<li><strong>robust</strong> (bool, default=False):\nif robust=True, weights will be internally calculated using FastMCD;\nignored if w is used</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>float</strong>: weighted correlation coefficient of x and y</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>The weighted correlation coefficient here may be usedful to construct a \na \"weighted R2\" or \"weighted coefficient of determination\" from a \nWeighted Least Squares regression: R2w = wcorr(x,y,w)**2. The resulting R2w is\nequivalent to equation 4 from Willett and Singer (1988, American Statistician) \nand their caveats apply. </p>\n\n<p>Craig Milligan provides the following advice in an online forum:\n\"What is the meaning of this (corrected) weighted r-squared? \nWillett and Singer interpret it as: \"the coefficient of determination in the \ntransformed [weighted] dataset. It is a measure of the proportion of the \nvariation in weighted Y that can be accounted for by weighted X, and is the \nquantity that is output as R2 by the major statistical computer packages when a \nWLS regression is performed\".</p>\n\n<p>Is it meaningful as a measure of goodness of fit? \nThis depends on how it is presented and interpreted. Willett and Singer caution \nthat it is typically quite a bit higher than the r-squared obtained in ordinary \nleast squares regression, and the high value encourages prominent display... \nbut this display may be deceptive IF it is interpreted in the conventional \nsense of r-squared (as the proportion of unweighted variation explained by a \nmodel). Willett and Singer propose that a less 'deceptive' alternative is \ntheir equation 7 [usual unweighted R2, called pseudor2wls by Willett and Singer]. \nIn general, Willett and Singer also caution that it is \nnot good to rely on any r2 (even their pseudor2wls) as a sole measure of \ngoodness of fit. Despite these cautions, the whole premise of robust regression \nis that some cases are judged 'not as good' and don't count as much in the model \nfitting, and it may be good to reflect this in part of the model assessment \nprocess. The weighted r-squared described, can be one good measure of goodness \nof fit - as long as the correct interpretation is clearly given in the \npresentation and it is not relied on as the sole assessment of goodness of fit.\"</p>\n\n<p>Willett, J. B. and Singer, J. D.: Another Cautionary Note About R2: \n    Its Use in Weighted Least-Squares Regression-Analysis, American Statistician, \n    42(3), 236\u2013238, 1988.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">w</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">robust</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.weighted.wcorrcoef", "modulename": "acgc.stats.weighted", "qualname": "wcorrcoef", "kind": "function", "doc": "<p>Weighted correlation coeffient</p>\n\n<p>Calculate the Pearson linear correlation coefficient of x and y using weights w. \nThis is derived from the weighted covariance and weighted variance.\nEquivalent to R2w in Eq. 4 from Willett and Singer (1988).\nSee notes below on interpretation.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x, y</strong> (array_like):\nvalues to be analyzed</li>\n<li><strong>w</strong> (array_like, default=None):\nweights for each element of x; can be ommitted if robust=True</li>\n<li><strong>ddof</strong> (int, default=1):\ndifferential degrees of freedom. See note above.</li>\n<li><strong>robust</strong> (bool, default=False):\nif robust=True, weights will be internally calculated using FastMCD;\nignored if w is used</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>float</strong>: weighted correlation coefficient of x and y</li>\n</ul>\n\n<h6 id=\"notes\">Notes</h6>\n\n<p>The weighted correlation coefficient here may be usedful to construct a \na \"weighted R2\" or \"weighted coefficient of determination\" from a \nWeighted Least Squares regression: R2w = wcorr(x,y,w)**2. The resulting R2w is\nequivalent to equation 4 from Willett and Singer (1988, American Statistician) \nand their caveats apply. </p>\n\n<p>Craig Milligan provides the following advice in an online forum:\n\"What is the meaning of this (corrected) weighted r-squared? \nWillett and Singer interpret it as: \"the coefficient of determination in the \ntransformed [weighted] dataset. It is a measure of the proportion of the \nvariation in weighted Y that can be accounted for by weighted X, and is the \nquantity that is output as R2 by the major statistical computer packages when a \nWLS regression is performed\".</p>\n\n<p>Is it meaningful as a measure of goodness of fit? \nThis depends on how it is presented and interpreted. Willett and Singer caution \nthat it is typically quite a bit higher than the r-squared obtained in ordinary \nleast squares regression, and the high value encourages prominent display... \nbut this display may be deceptive IF it is interpreted in the conventional \nsense of r-squared (as the proportion of unweighted variation explained by a \nmodel). Willett and Singer propose that a less 'deceptive' alternative is \ntheir equation 7 [usual unweighted R2, called pseudor2wls by Willett and Singer]. \nIn general, Willett and Singer also caution that it is \nnot good to rely on any r2 (even their pseudor2wls) as a sole measure of \ngoodness of fit. Despite these cautions, the whole premise of robust regression \nis that some cases are judged 'not as good' and don't count as much in the model \nfitting, and it may be good to reflect this in part of the model assessment \nprocess. The weighted r-squared described, can be one good measure of goodness \nof fit - as long as the correct interpretation is clearly given in the \npresentation and it is not relied on as the sole assessment of goodness of fit.\"</p>\n\n<p>Willett, J. B. and Singer, J. D.: Another Cautionary Note About R2: \n    Its Use in Weighted Least-Squares Regression-Analysis, American Statistician, \n    42(3), 236\u2013238, 1988.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">w</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">robust</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.weighted.wcov", "modulename": "acgc.stats.weighted", "qualname": "wcov", "kind": "function", "doc": "<p>Weighted covariance </p>\n\n<p>Calculate the covariance of x and y using weights w. If ddof=1 (default),\nthen the result is the unbiased (sample) covariance when w=1.</p>\n\n<p>Implements weighted covariance as defined by NIST Dataplot \n<a href=\"https://www.itl.nist.gov/div898/software/dataplot/refman2/ch2/weighvar.pdf\">https://www.itl.nist.gov/div898/software/dataplot/refman2/ch2/weighvar.pdf</a></p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x, y</strong> (array_like):\nvalues to be analyzed</li>\n<li><strong>w</strong> (array_like, default=None):\nweights for each element of x; can be ommitted if robust=True</li>\n<li><strong>ddof</strong> (int (default=1)):\ndifferential degrees of freedom. See note above.</li>\n<li><strong>robust</strong> (bool, default=False):\nif robust=True, weights will be internally calculated using FastMCD;\nignored if w is used</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>float</strong>: weighted covariance of x and y</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">w</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">ddof</span><span class=\"o\">=</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">robust</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.weighted.wmean", "modulename": "acgc.stats.weighted", "qualname": "wmean", "kind": "function", "doc": "<p>Weighted mean </p>\n\n<p>Calculate the mean of x using weights w.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x</strong> (array_like):\nvalues to be averaged</li>\n<li><strong>w</strong> (array_like, default=None):\nweights for each element of x; can be ommitted if robust=True</li>\n<li><strong>robust</strong> (bool, default=False):\nif robust=True, weights will be internally calculated using FastMCD;\nignored if w is used</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>float</strong>: weighted mean of x</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">w</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">robust</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.weighted.wmedian", "modulename": "acgc.stats.weighted", "qualname": "wmedian", "kind": "function", "doc": "<p>Weighted median</p>\n\n<p>See documentation for <code>wquantile</code></p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x</strong> (array_like):\nvalues to be analyzed</li>\n<li><strong>w</strong> (array_like):\nweights for each element of x, representing frequency</li>\n<li><strong>**kwargs passed to <code>wquantile</code></strong></li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>float</strong>: weighted median of x</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">w</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.weighted.wquantile", "modulename": "acgc.stats.weighted", "qualname": "wquantile", "kind": "function", "doc": "<p>Weighted quantile </p>\n\n<p>Calculate the quantile q from data array x using data weights w.\nIf weights reflect the relative frequency of the elements of x in a large population,\nthen the weighted quantile result is equivalent to numpy.quantile or numpy.percentile \noperating on an array of that larger population (containing many repeated elements).</p>\n\n<p>For uniform weights and interpolation=partition or partition0, this function \ndiffers from numpy.percentile. This behavior is expected and desirable.\nThe numpy.percentile behaviro can be reproduced here by using \ninterpolation = linear, lower, higher, or nearest.\nNote that numpy.quantile is equivalent to numpy.percentile(interpolation='linear')</p>\n\n<p>This naive algorithm is O(n) and may be slow for large samples (x).\nConsider using Robustats or another optimized package.       </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x</strong> (array_like (N,)):\nvalues to be analyzed</li>\n<li><strong>q</strong> (list (m,)):\nquantiles that will be calculated, in range 0-1</li>\n<li><strong>w</strong> (array_like (N,)):\nweights for each element of x. \nThese represent the frequency of elements x in a large population</li>\n<li><strong>interpolation</strong> ({'partition' (default),'partition0','linear','nearest','lower','higher'}):\nThis parameter specifies the interpolation method to use when the desired quantile \nlies bewteen elements i &lt; j in x. Allowed values:\n<ul>\n<li>'partition': [default] choose the element of x that partitions the \nsum of weights on either side to q and (1-q)\nWhen two elements both satisfy partition, then average them.\nThis is the Edgeworth method (<a href=\"https://en.wikipedia.org/wiki/Weighted_median\"><a href=\"https://en.wikipedia.org/wiki/Weighted_median\">https://en.wikipedia.org/wiki/Weighted_median</a></a>)</li>\n<li>'partition0': Same as partition, but result is always an element of x (no averaging). \nInstead return the element of x that partitions weights most closely \nto q and (1-q) or, if there is still a tie, then the smaller element.</li>\n<li>'linear'  : i + (j-1) * fraction. replicates behavior of numpy.quantile when all \nweights are equal</li>\n<li>'nearest' : i or j element that most closely divides data at the q quantile</li>\n<li>'lower'   : i, the largest element &lt;= the q quantile</li>\n<li>'higher'  : j, the smallest element &gt;= the q quantile</li>\n</ul></li>\n</ul>\n\n<h6 id=\"result\">Result</h6>\n\n<p>array (m,)\n    weighted quantiles of x. Length is the same as input q</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">q</span>, </span><span class=\"param\"><span class=\"n\">w</span>, </span><span class=\"param\"><span class=\"n\">interpolation</span><span class=\"o\">=</span><span class=\"s1\">&#39;partition&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.weighted.wstd", "modulename": "acgc.stats.weighted", "qualname": "wstd", "kind": "function", "doc": "<p>Weighted standard deviation</p>\n\n<p>Calculate the standard deviation of x using weights w. If ddof=1 (default),\nthen the result is the unbiased (sample) standard deviation when w=1.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x</strong> (array_like):\nvalues to be analyzed</li>\n<li><strong>w</strong> (array_like, default=None):\nweights for each element of x; can be ommitted if robust=True</li>\n<li><strong>ddof</strong> (int, default=1):\ndifferential degrees of freedom. See note above.</li>\n<li><strong>robust</strong> (bool, default=False):\nif robust=True, weights will be internally calculated using FastMCD;\nignored if w is used</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>float</strong>: weighted standard deviation of x</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">w</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">ddof</span><span class=\"o\">=</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">robust</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.stats.weighted.wvar", "modulename": "acgc.stats.weighted", "qualname": "wvar", "kind": "function", "doc": "<p>Weighted variance </p>\n\n<p>Calculate the variance of x using weights w. If ddof=1 (default),\nthen the result is the unbiased (sample) variance when w=1.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>x</strong> (array_like):\nvalues to be analyzed</li>\n<li><strong>w</strong> (array_like, default=None):\nweights for each element of x; can be ommitted if robust=True</li>\n<li><strong>ddof</strong> (int, default=1):\ndifferential degrees of freedom. See note above.</li>\n<li><strong>robust</strong> (bool, default=False):\nif robust=True, weights will be internally calculated using FastMCD;\nignored if w is used</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>float</strong>: weighted variance of x</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">w</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">ddof</span><span class=\"o\">=</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">robust</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.time", "modulename": "acgc.time", "kind": "module", "doc": "<p>Collection of functions for manipulating times and dates</p>\n\n<p>This module is outdated. These functions can be accomplished with pandas.Timestamp.</p>\n\n<p>@author: cdholmes</p>\n"}, {"fullname": "acgc.time.date2yearf", "modulename": "acgc.time", "qualname": "date2yearf", "kind": "function", "doc": "<p>Convert datetime to year with fraction</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>datetime</strong> (datetime.date or datetime.datetime or list/array of same):\ndate and time</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>yearfrac</strong> (float or list):\nyear and fraction corresponding to input dates. e.g. 2005.156</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">datetime</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.time.yearf2date", "modulename": "acgc.time", "qualname": "yearf2date", "kind": "function", "doc": "<p>Convert year with fraction to datetime </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>yearfrac</strong> (float or list of float):\nyear and fraction, e.g. 2005.156</li>\n<li><strong>roundSec</strong> (bool (default=True)):\nspecify if output should be rounded to the nearest second</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>date</strong> (datetime.datetime or list of same):\ndate and time corresponding to input</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">yearf</span>, </span><span class=\"param\"><span class=\"n\">roundSec</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.time.date2doyf", "modulename": "acgc.time", "qualname": "date2doyf", "kind": "function", "doc": "<p>Convert datetime to day of year with fraction</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>datetime</strong> (datetime.date or datetime.datetime or list of same):\ndate and time</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>doyfrac</strong> (float or list):\nday of year and fraction corresponding to input dates. e.g. 100.156</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">datetime</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "acgc.time.doyf2date", "modulename": "acgc.time", "qualname": "doyf2date", "kind": "function", "doc": "<p>Convert day of year with fraction to datetime </p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>doyf</strong> (float or list of float):\nday of year and fraction, e.g. 100.156</li>\n<li><strong>year</strong> (float or list of float):\nyear</li>\n<li><strong>roundSec</strong> (bool (default=True)):\nspecify if output should be rounded to the nearest second</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>date</strong> (datetime.datetime or list of same):\ndate and time corresponding to input</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">doyf</span>, </span><span class=\"param\"><span class=\"n\">year</span>, </span><span class=\"param\"><span class=\"n\">roundSec</span><span class=\"o\">=</span><span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();