# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobProperties(Model):
    """JobProperties.

    :param job_id: The unique identifier of the job.
    :type job_id: str
    :param start_time_utc: System generated. Ignored at creation. The start
     date and time of the job in UTC.
    :type start_time_utc: datetime
    :param end_time_utc: System generated. Ignored at creation. The end date
     and time of the job in UTC.
    :type end_time_utc: datetime
    :param type: The job type. Possible values include: 'unknown', 'export',
     'import', 'backup', 'readDeviceProperties', 'writeDeviceProperties',
     'updateDeviceConfiguration', 'rebootDevice', 'factoryResetDevice',
     'firmwareUpdate', 'scheduleDeviceMethod', 'scheduleUpdateTwin',
     'restoreFromBackup', 'failoverDataCopy'
    :type type: str or ~protocol.models.enum
    :param status: System generated. Ignored at creation. The status of the
     job. Possible values include: 'unknown', 'enqueued', 'running',
     'completed', 'failed', 'cancelled', 'scheduled', 'queued'
    :type status: str or ~protocol.models.enum
    :param progress: System generated. Ignored at creation. The percentage of
     job completion.
    :type progress: int
    :param input_blob_container_uri: The URI containing SAS token to a blob
     container that contains registry data to sync.
    :type input_blob_container_uri: str
    :param input_blob_name: The blob name to use when importing from the input
     blob container.
    :type input_blob_name: str
    :param output_blob_container_uri: The SAS token to access the blob
     container. This is used to output the status and results of the job.
    :type output_blob_container_uri: str
    :param output_blob_name: The blob name that will be created in the output
     blob container. This blob will contain the exported device registry
     information for the IoT Hub.
    :type output_blob_name: str
    :param exclude_keys_in_export: Optional for export jobs; ignored for other
     jobs. If not specified, the service defaults to false. If false,
     authorization keys are included in export output. Keys are exported as
     null otherwise.
    :type exclude_keys_in_export: bool
    :param storage_authentication_type: The authentication type used for
     connecting to the storage account. Possible values include: 'keyBased',
     'identityBased'
    :type storage_authentication_type: str or ~protocol.models.enum
    :param identity:
    :type identity: ~protocol.models.ManagedIdentity
    :param failure_reason: System genereated.  Ignored at creation. The reason
     for failure, if a failure occurred.
    :type failure_reason: str
    :param include_configurations: Defaults to false. If true, then
     configurations are included in the data export/import.
    :type include_configurations: bool
    :param configurations_blob_name: Defaults to configurations.txt. Specifies
     the name of the blob to use when exporting/importing configurations.
    :type configurations_blob_name: str
    """

    _attribute_map = {
        "job_id": {"key": "jobId", "type": "str"},
        "start_time_utc": {"key": "startTimeUtc", "type": "iso-8601"},
        "end_time_utc": {"key": "endTimeUtc", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "progress": {"key": "progress", "type": "int"},
        "input_blob_container_uri": {"key": "inputBlobContainerUri", "type": "str"},
        "input_blob_name": {"key": "inputBlobName", "type": "str"},
        "output_blob_container_uri": {"key": "outputBlobContainerUri", "type": "str"},
        "output_blob_name": {"key": "outputBlobName", "type": "str"},
        "exclude_keys_in_export": {"key": "excludeKeysInExport", "type": "bool"},
        "storage_authentication_type": {"key": "storageAuthenticationType", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedIdentity"},
        "failure_reason": {"key": "failureReason", "type": "str"},
        "include_configurations": {"key": "includeConfigurations", "type": "bool"},
        "configurations_blob_name": {"key": "configurationsBlobName", "type": "str"},
    }

    def __init__(
        self,
        *,
        job_id: str = None,
        start_time_utc=None,
        end_time_utc=None,
        type=None,
        status=None,
        progress: int = None,
        input_blob_container_uri: str = None,
        input_blob_name: str = None,
        output_blob_container_uri: str = None,
        output_blob_name: str = None,
        exclude_keys_in_export: bool = None,
        storage_authentication_type=None,
        identity=None,
        failure_reason: str = None,
        include_configurations: bool = None,
        configurations_blob_name: str = None,
        **kwargs
    ) -> None:
        super(JobProperties, self).__init__(**kwargs)
        self.job_id = job_id
        self.start_time_utc = start_time_utc
        self.end_time_utc = end_time_utc
        self.type = type
        self.status = status
        self.progress = progress
        self.input_blob_container_uri = input_blob_container_uri
        self.input_blob_name = input_blob_name
        self.output_blob_container_uri = output_blob_container_uri
        self.output_blob_name = output_blob_name
        self.exclude_keys_in_export = exclude_keys_in_export
        self.storage_authentication_type = storage_authentication_type
        self.identity = identity
        self.failure_reason = failure_reason
        self.include_configurations = include_configurations
        self.configurations_blob_name = configurations_blob_name
