# OmdenaLore

OmdenaLore is a community-driven library build by certified Omdena collaborators. The codebase is a mixture of tutorials and codes structured by specific domain names. With a growing number of collaborators, the library is ever-growing and versatile to handle simple and complex data science tasks.

**We encourage coders around the world to collaborate in the repository and make a real-world impact. Get access to the repository and the community here.**

### [Documentation and Guidelines](https://omdenaai.github.io/)

## FAQ and Support
If you have a question that is not listed below, please feel free to reach out to us at kaushal@omdena.com

Q. Will there be a redundancy check to make sure the code pushed in the Pull Requests is verified?

Yes: The main branch is protected in the repository which means that for a Pull Request to be merged into the main branch, at least one reviewer will need to review it.

Q. Will we have access to the repository?

Yes: Since this repository is private, you will be given push access ON REQUEST to the repository. To submit a request, please fill this request form.

Q. Can I push my changes to the main branch?

No: In order to make sure the main branch consists of functional and usable code for all collaborators, we have protected the branch so that a proper Pull Request + review process can be used to merge new changes into the main branch.

Q. Is it okay if I add code from the internet to the repository?

Yes: The code taken from the internet is acceptable but please make sure that a similar or same code doesn’t exist in the repository.

Q. How do I check if a code already exists in the repository or not?

The repository is divided into several domains and all domains contain name specific modules. According to the functionality of the code you are pushing, please check the corresponding domain folder and module to see if a similar code exists or not.

Q. Do I need to take care of any specification before I create a pull request?

Yes: Please refer to the Guideline section of this document.

Q. Should I add author name or credits to the code?

Optional: If you wish to add credits or author name to the code, please do so in the doc string of your functions or end of the module.

Q. What should I do if I don’t find any modules or domain folder for my code?

If you don’t find an appropriate location for your code, you can create your own folder or module. If you are unsure if a similar module or domain exists, please get in touch with the repository manager or get support from the Omdena team.