# Covid-surge
COVID-19 mortality surge period calculation for communities afflicted by the corona virus SARS-CoV-2.

  + [University of Massachusetts Lowell](https://www.uml.edu/)
  + [Dept. of Chemical Engineering](https://www.uml.edu/Engineering/Chemical/) (Nuclear Program)
  + [Prof. Valmor F. de Almeida](https://www.uml.edu/Engineering/Chemical/faculty/de-Almeida-Valmor.aspx) (valmor_dealmeida@uml.edu)

-----------

[![NBViewer](https://raw.githubusercontent.com/jupyter/design/master/logos/Badges/nbviewer_badge.svg)](https://nbviewer.jupyter.org/github/dpploy/covid-surge/tree/master/notebooks/)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/dpploy/covid-surge/master)
[![Azure Notebooks](https://notebooks.azure.com/launch.svg)](https://notebooks.azure.com/dealmeidavf/projects/covid-surge)

[![PyPI Version](https://img.shields.io/pypi/v/covid-surge)](https://pypi.org/project/covid-surge/)
[![PyPI Python Version](https://img.shields.io/pypi/pyversions/covid-surge)](https://pypi.org/project/covid-surge/)
[![Repo Size](https://img.shields.io/github/repo-size/dpploy/covid-surge)](https://github.com/dpploy/covid-surge)

![CircleCI](https://img.shields.io/circleci/build/github/dpploy/covid-surge/master)
![Codecov](https://img.shields.io/codecov/c/github/dpploy/covid-surge)

------------

**Preprint**: [How Long is the Worst Part of the COVID-19 Mortality Surge?](https://doi.org/10.31219/osf.io/z59uy)


|   |
|:---|
|----------------------------------------------------\|**WORLD**\|---------------------------------------------------------|
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_global.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
| Distribution of mortality critical surge periods for the countries with fully evolved epidemics. The average critical surge period is the number of days between the points of maximum and minimum curvatures on the sigmoid curve approximating the data. Countries to the right are less stressed than countries to the left. The colored bar plot shows locations grouped by 2-day bin widths. |
| The world average critical surge period at the date indicated by the plot is **23 days with a 3-day standard deviation**.|
| *To update this plot with live data, [run this Jupyter Notebook](https://nbviewer.jupyter.org/github/dpploy/covid-surge/blob/master/notebooks/countries-surge.ipynb).* |
|---------------------------------------------------------\|**US**\|-------------------------------------------------------|
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_us.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
| Distribution of mortality critical surge periods for the US states with fully evolved epidemics. The average critical surge period is the number of days between the points of maximum and minimum curvatures on the sigmoid curve approximating the data. Countries to the right are less stressed than countries to the left. The colored bar plot shows locations grouped by 2-day bin widths. |
| The US state average critical surge period at the date indicated by the plot is **25 days with a 3-day standard deviation**.|
| *To update this plot with live data, [run this Jupyter Notebook](https://nbviewer.jupyter.org/github/dpploy/covid-surge/blob/master/notebooks/us-states-surge.ipynb).*  |
|--------------------------------------------\|**US State Counties/Towns (Top 3)**\|---------------------------------------|
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_us_new_york.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
| Distribution of mortality critical surge periods for the US state New York with fully evolved epidemics. The average critical surge period is the number of days between the points of maximum and minimum curvatures on the sigmoid curve approximating the data. Countries to the right are less stressed than countries to the left. The colored bar plot shows locations grouped by 2-day bin widths.|
| The average critical surge period at the date indicated by the plot is **21 days with a 3-day standard deviation**.|
| *To update this plot with live data, [run this Jupyter Notebook](https://nbviewer.jupyter.org/github/dpploy/covid-surge/blob/master/notebooks/us-state-counties-surge.ipynb).*  |
|-------------------------------------------------------------------------------------------------------------------------|
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_us_new_jersey.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
|-------------------------------------------------------------------------------------------------------------------------|
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_us_massachusetts.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
