"""A simple transformation that truncates the text of input documents to a
given character length."""

from annif.exception import ConfigurationException

from . import transform


class InputLimiter(transform.BaseTransform):
    name = "limit"

    def __init__(self, project, input_limit):
        super().__init__(project)
        self.input_limit = int(input_limit)
        self._validate_value(self.input_limit)

    def transform_fn(self, text):
        return text[: self.input_limit]

    def _validate_value(self, input_limit):
        if input_limit < 0:
            raise ConfigurationException(
                "input_limit in limit_input transform cannot be negative",
                project_id=self.project.project_id,
            )
