"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.FSxMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class FSxMetrics {
    static dataReadBytesSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'DataReadBytes',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static dataWriteBytesSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'DataWriteBytes',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static freeStorageCapacityAverage(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'FreeStorageCapacity',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static freeDataStorageCapacitySum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'FreeDataStorageCapacity',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static dataReadOperationsSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'DataReadOperations',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static dataWriteOperationsSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'DataWriteOperations',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static metadataOperationsSum(dimensions) {
        return {
            namespace: 'AWS/FSx',
            metricName: 'MetadataOperations',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.FSxMetrics = FSxMetrics;
//# sourceMappingURL=data:application/json;base64,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