-- Record contains two integer bins, name1 and name2.
-- For name1 even integers, add value to existing name1 bin.
-- For name1 integers with a multiple of 5, delete name2 bin.
-- For name1 integers with a multiple of 9, delete record. 
function process_test_rec(r,name1,name2,addValue)
    local v = r[name1]

    if (v % 9 == 0) then
        aerospike:remove(r)
        return
    end

    if (v % 5 == 0) then
        r[name2] = nil
        aerospike:update(r)
        return
    end

    if (v % 2 == 0) then
        r[name1] = v + addValue
        aerospike:update(r)
    end
end


-- Aggregation(sum of bins with value as double type)
local function get_bin(rec)
    return rec['a_double_bin']
end

local function add(a, b)
    return a + b
end

function sum_bin(stream)
    return stream : map(get_bin) : reduce(add)
end
