![Test python package](https://github.com/mshumko/aurora-asi-lib/workflows/Test%20python%20package/badge.svg) [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.4746447.svg)](https://doi.org/10.5281/zenodo.4746446)

# aurora-asi-lib
aurora-asi-lib is an open source package providing data access and analysis tools for the world's all-sky imager (ASI) data.

The purpose of this project is to combine data from numerous observational ASI arrays into a single unified framework and is thus not associated with the development and operations of all sky cameras, or the curation of ASI datasets. All data is publicly available and is provided as-is. Please give appropriate credit and coordinate with instrument teams with regards to data issues and/or interpretation. See the [Acknowledgements](https://aurora-asi-lib.readthedocs.io/en/latest/index.html#acknowledgements) section for more information. Currently the supported camera systems (arrays) are: 
* [Red-line Emission Geospace Observatory (REGO)](https://aurora-asi-lib.readthedocs.io/en/latest/imager_api.html#rego-asi)
* [Time History of Events and Macroscale Interactions during Substorms (THEMIS)](https://aurora-asi-lib.readthedocs.io/en/latest/imager_api.html#module-asilib.asi.themis)
* [Transition Region Explorer (TREx)](https://aurora-asi-lib.readthedocs.io/en/latest/imager_api.html#module-asilib.asi.trex)

[Documentation](https://aurora-asi-lib.readthedocs.io/) | [Code on GitHub](https://github.com/mshumko/aurora-asi-lib) | [PyPI archive](https://pypi.org/project/aurora-asi-lib/) | [Zenodo archive](https://doi.org/10.5281/zenodo.4746446)

![A geographic map showing the spatial coverage (field of view rings) of all imagers supported by aurora-asi-lib.](https://github.com/mshumko/aurora-asi-lib/blob/main/docs/_static/global_coverage.png?raw=true)

![An asilib collage showing fisheye images, mapped images, and a keogram from the THEMIS and REGO imagers at RANK.](https://github.com/mshumko/aurora-asi-lib/blob/main/docs/_static/collage.png?raw=true)

[And you can animate images & conjunctions!](https://aurora-asi-lib.readthedocs.io/en/latest/basics_tutorial.html#Satellite-conjunction)

See more examples in the [online documentation](https://aurora-asi-lib.readthedocs.io/en/latest/examples.html) 

Your contributions and ideas are always welcome. The easiest way is to submit [Issues](https://github.com/mshumko/aurora-asi-lib/issues) or [Pull Requests](https://github.com/mshumko/aurora-asi-lib/pulls).

# Acknowledgments
Are in the [Acknowledgements](https://aurora-asi-lib.readthedocs.io/en/latest/index.html#acknowledgements) section of the online documentation.
