#!/usr/bin/env python3
# -*- coding: utf-8 -*-

#import pytest
from aiida_kkr.tools.tools_kkrimp import modify_potential, kkrimp_parser_functions
    

class Test_modify_potential():
    """ Tests for the modify_potential class functions. """
    
    def test_shapefun_from_scoef(self):
        shapefun_path = '../tests/files/mod_pot/test2/shapefun'
        scoefpath = '../tests/files/mod_pot/test2/scoef'
        atom2shapes = [1]
        shapefun_new = '../tests/files/mod_pot/test2/shapefun_new'
        modify_potential().shapefun_from_scoef(scoefpath, shapefun_path, atom2shapes, shapefun_new)
        reftxt = ['   7\n', '  1.000000000000E+00\n', '    3  135 NPAN,MESHN;  Shape number     1;     # serial: voro_v1.0-16-g2d2b8f1_serial_20180516213647\n', '   10   70   55\n', '  0.495000000000D+00  0.555555555556D-03  0.495555555556D+00  0.555555555556D-03\n', '  0.496111111111D+00  0.555555555556D-03  0.496666666667D+00  0.555555555556D-03\n', '  0.497222222222D+00  0.555555555556D-03  0.497777777778D+00  0.555555555556D-03\n', '  0.498333333333D+00  0.555555555556D-03  0.498888888889D+00  0.555555555556D-03\n', '  0.499444444444D+00  0.555555555556D-03  0.500000000000D+00  0.555555555556D-03\n', '  0.500000000000D+00  0.300154755343D-02  0.503001547553D+00  0.300154755343D-02\n', '  0.506003095107D+00  0.300154755343D-02  0.509004642660D+00  0.300154755343D-02\n', '  0.512006190214D+00  0.300154755343D-02  0.515007737767D+00  0.300154755343D-02\n', '  0.518009285321D+00  0.300154755343D-02  0.521010832874D+00  0.300154755343D-02\n', '  0.524012380427D+00  0.300154755343D-02  0.527013927981D+00  0.300154755343D-02\n', '  0.530015475534D+00  0.300154755343D-02  0.533017023088D+00  0.300154755343D-02\n', '  0.536018570641D+00  0.300154755343D-02  0.539020118195D+00  0.300154755343D-02\n', '  0.542021665748D+00  0.300154755343D-02  0.545023213301D+00  0.300154755343D-02\n', '  0.548024760855D+00  0.300154755343D-02  0.551026308408D+00  0.300154755343D-02\n', '  0.554027855962D+00  0.300154755343D-02  0.557029403515D+00  0.300154755343D-02\n', '  0.560030951069D+00  0.300154755343D-02  0.563032498622D+00  0.300154755343D-02\n', '  0.566034046175D+00  0.300154755343D-02  0.569035593729D+00  0.300154755343D-02\n', '  0.572037141282D+00  0.300154755343D-02  0.575038688836D+00  0.300154755343D-02\n', '  0.578040236389D+00  0.300154755343D-02  0.581041783943D+00  0.300154755343D-02\n', '  0.584043331496D+00  0.300154755343D-02  0.587044879049D+00  0.300154755343D-02\n', '  0.590046426603D+00  0.300154755343D-02  0.593047974156D+00  0.300154755343D-02\n', '  0.596049521710D+00  0.300154755343D-02  0.599051069263D+00  0.300154755343D-02\n', '  0.602052616817D+00  0.300154755343D-02  0.605054164370D+00  0.300154755343D-02\n', '  0.608055711923D+00  0.300154755343D-02  0.611057259477D+00  0.300154755343D-02\n', '  0.614058807030D+00  0.300154755343D-02  0.617060354584D+00  0.300154755343D-02\n', '  0.620061902137D+00  0.300154755343D-02  0.623063449691D+00  0.300154755343D-02\n', '  0.626064997244D+00  0.300154755343D-02  0.629066544797D+00  0.300154755343D-02\n', '  0.632068092351D+00  0.300154755343D-02  0.635069639904D+00  0.300154755343D-02\n', '  0.638071187458D+00  0.300154755343D-02  0.641072735011D+00  0.300154755343D-02\n', '  0.644074282565D+00  0.300154755343D-02  0.647075830118D+00  0.300154755343D-02\n', '  0.650077377671D+00  0.300154755343D-02  0.653078925225D+00  0.300154755343D-02\n', '  0.656080472778D+00  0.300154755343D-02  0.659082020332D+00  0.300154755343D-02\n', '  0.662083567885D+00  0.300154755343D-02  0.665085115439D+00  0.300154755343D-02\n', '  0.668086662992D+00  0.300154755343D-02  0.671088210545D+00  0.300154755343D-02\n', '  0.674089758099D+00  0.300154755343D-02  0.677091305652D+00  0.300154755343D-02\n', '  0.680092853206D+00  0.300154755343D-02  0.683094400759D+00  0.300154755343D-02\n', '  0.686095948313D+00  0.300154755343D-02  0.689097495866D+00  0.300154755343D-02\n', '  0.692099043419D+00  0.300154755343D-02  0.695100590973D+00  0.300154755343D-02\n', '  0.698102138526D+00  0.300154755343D-02  0.701103686080D+00  0.300154755343D-02\n', '  0.704105233633D+00  0.300154755343D-02  0.707106781187D+00  0.300154755343D-02\n', '  0.707106781187D+00  0.294293745552D-02  0.710049718642D+00  0.294293745552D-02\n', '  0.712992656098D+00  0.294293745552D-02  0.715935593553D+00  0.294293745552D-02\n', '  0.718878531009D+00  0.294293745552D-02  0.721821468464D+00  0.294293745552D-02\n', '  0.724764405920D+00  0.294293745552D-02  0.727707343375D+00  0.294293745552D-02\n', '  0.730650280831D+00  0.294293745552D-02  0.733593218286D+00  0.294293745552D-02\n', '  0.736536155742D+00  0.294293745552D-02  0.739479093197D+00  0.294293745552D-02\n', '  0.742422030653D+00  0.294293745552D-02  0.745364968108D+00  0.294293745552D-02\n', '  0.748307905564D+00  0.294293745552D-02  0.751250843019D+00  0.294293745552D-02\n', '  0.754193780475D+00  0.294293745552D-02  0.757136717930D+00  0.294293745552D-02\n', '  0.760079655386D+00  0.294293745552D-02  0.763022592841D+00  0.294293745552D-02\n', '  0.765965530297D+00  0.294293745552D-02  0.768908467752D+00  0.294293745552D-02\n', '  0.771851405208D+00  0.294293745552D-02  0.774794342663D+00  0.294293745552D-02\n', '  0.777737280119D+00  0.294293745552D-02  0.780680217574D+00  0.294293745552D-02\n', '  0.783623155030D+00  0.294293745552D-02  0.786566092485D+00  0.294293745552D-02\n', '  0.789509029941D+00  0.294293745552D-02  0.792451967397D+00  0.294293745552D-02\n', '  0.795394904852D+00  0.294293745552D-02  0.798337842308D+00  0.294293745552D-02\n', '  0.801280779763D+00  0.294293745552D-02  0.804223717219D+00  0.294293745552D-02\n', '  0.807166654674D+00  0.294293745552D-02  0.810109592130D+00  0.294293745552D-02\n', '  0.813052529585D+00  0.294293745552D-02  0.815995467041D+00  0.294293745552D-02\n', '  0.818938404496D+00  0.294293745552D-02  0.821881341952D+00  0.294293745552D-02\n', '  0.824824279407D+00  0.294293745552D-02  0.827767216863D+00  0.294293745552D-02\n', '  0.830710154318D+00  0.294293745552D-02  0.833653091774D+00  0.294293745552D-02\n', '  0.836596029229D+00  0.294293745552D-02  0.839538966685D+00  0.294293745552D-02\n', '  0.842481904140D+00  0.294293745552D-02  0.845424841596D+00  0.294293745552D-02\n', '  0.848367779051D+00  0.294293745552D-02  0.851310716507D+00  0.294293745552D-02\n', '  0.854253653962D+00  0.294293745552D-02  0.857196591418D+00  0.294293745552D-02\n', '  0.860139528873D+00  0.294293745552D-02  0.863082466329D+00  0.294293745552D-02\n', '  0.866025403784D+00  0.294293745552D-02\n', '    8\n', '    1\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.348144740577D+01\n', '  0.341873998692D+01  0.335677212636D+01  0.329553081748D+01  0.323500335691D+01\n', '  0.317517733570D+01  0.311604063086D+01  0.305758139715D+01  0.299978805921D+01\n', '  0.294264930386D+01  0.288615407276D+01  0.283029155528D+01  0.277505118156D+01\n', '  0.272042261588D+01  0.266639575022D+01  0.261296069799D+01  0.256010778802D+01\n', '  0.250782755873D+01  0.245611075245D+01  0.240494831001D+01  0.235433136540D+01\n', '  0.230425124068D+01  0.225469944100D+01  0.220566764980D+01  0.215714772417D+01\n', '  0.210913169033D+01  0.206161173925D+01  0.201458022246D+01  0.196802964790D+01\n', '  0.192195267594D+01  0.187634211556D+01  0.183119092059D+01  0.178649218608D+01\n', '  0.174223914475D+01  0.169842516366D+01  0.165504374078D+01  0.161208850186D+01\n', '  0.156955319730D+01  0.152743169906D+01  0.148571799778D+01  0.144440619990D+01\n', '  0.140349052487D+01  0.136296530248D+01  0.132282497020D+01  0.128306407070D+01\n', '  0.124367724929D+01  0.120465925162D+01  0.116600492124D+01  0.112770919739D+01\n', '  0.108976711279D+01  0.105217379146D+01  0.101492444666D+01  0.978014378839D+00\n', '  0.941438973679D+00  0.905193700153D+00  0.869274108662D+00  0.833675829215D+00\n', '  0.798394569651D+00  0.763426113922D+00  0.728766320407D+00  0.694411120278D+00\n', '  0.660356515910D+00  0.626598579329D+00  0.593133450700D+00  0.559957336859D+00\n', '  0.527066509878D+00  0.494457305668D+00  0.462126122617D+00  0.430069420271D+00\n', '  0.430069420271D+00  0.402303316540D+00  0.377539313460D+00  0.354743340664D+00\n', '  0.333530457006D+00  0.313670769379D+00  0.295004615108D+00  0.277411710302D+00\n', '  0.260796664908D+00  0.245081108278D+00  0.230198970219D+00  0.216093447552D+00\n', '  0.202714947697D+00  0.190019635093D+00  0.177968368454D+00  0.166525901810D+00\n', '  0.155660269630D+00  0.145342304080D+00  0.135545249448D+00  0.126244449527D+00\n', '  0.117417090804D+00  0.109041989005D+00  0.101099409844D+00  0.935709170764D-01\n', '  0.864392426117D-01  0.796881746491D-01  0.733024606555D-01  0.672677226928D-01\n', '  0.615703830911D-01  0.561975988595D-01  0.511372035220D-01  0.463776553057D-01\n', '  0.419079907936D-01  0.377177833043D-01  0.337971053812D-01  0.301364948711D-01\n', '  0.267269241521D-01  0.235597721351D-01  0.206267987196D-01  0.179201214265D-01\n', '  0.154321939709D-01  0.131557865685D-01  0.110839677947D-01  0.921008784091D-02\n', '  0.752776303004D-02  0.603086146903D-02  0.471348973284D-02  0.356998048451D-02\n', '  0.259488094746D-02  0.178294215513D-02  0.112910891116D-02  0.628510400363D-03\n', '  0.276451396771D-03  0.684040205092D-04  0.457411886146D-13\n', '   21\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.107771580765D+00\n', ' -0.207927768303D+00 -0.300879928222D+00 -0.387017301583D+00 -0.466708260187D+00\n', ' -0.540301485561D+00 -0.608127076621D+00 -0.670497590656D+00 -0.727709021934D+00\n', ' -0.780041721948D+00 -0.827761265034D+00 -0.871119262839D+00 -0.910354130889D+00\n', ' -0.945691810260D+00 -0.977346447194D+00 -0.100552103326D+01 -0.103040800855D+01\n', ' -0.105218983014D+01 -0.107103950802D+01 -0.108712111043D+01 -0.110059024054D+01\n', ' -0.111159448612D+01 -0.112027384388D+01 -0.112676112010D+01 -0.113118230872D+01\n', ' -0.113365694857D+01 -0.113429846067D+01 -0.113321446694D+01 -0.113050709147D+01\n', ' -0.112627324514D+01 -0.112060489489D+01 -0.111358931816D+01 -0.110530934371D+01\n', ' -0.109584357938D+01 -0.108526662757D+01 -0.107364928929D+01 -0.106105875719D+01\n', ' -0.104755879842D+01 -0.103320992775D+01 -0.101806957159D+01 -0.100219222331D+01\n', ' -0.985629590493D+00 -0.968430734425D+00 -0.950642202363D+00 -0.932308152903D+00\n', ' -0.913470474873D+00 -0.894168900091D+00 -0.874441110314D+00 -0.854322838707D+00\n', ' -0.833847966132D+00 -0.813048612513D+00 -0.791955223572D+00 -0.770596653163D+00\n', ' -0.749000241447D+00 -0.727191889129D+00 -0.705196127964D+00 -0.683036187733D+00\n', ' -0.660734059870D+00 -0.638310557917D+00 -0.615785374981D+00 -0.593177138329D+00\n', ' -0.570503461300D+00 -0.547780992645D+00 -0.525025463440D+00 -0.502251731701D+00\n', ' -0.479473824810D+00 -0.456704979869D+00 -0.433957682089D+00 -0.411243701307D+00\n', ' -0.411243701307D+00 -0.390528872452D+00 -0.371153728294D+00 -0.352708702956D+00\n', ' -0.335055250348D+00 -0.318115790182D+00 -0.301838817656D+00 -0.286186587040D+00\n', ' -0.271129514420D+00 -0.256643242282D+00 -0.242706948687D+00 -0.229302306517D+00\n', ' -0.216412810451D+00 -0.204023324895D+00 -0.192119771086D+00 -0.180688905193D+00\n', ' -0.169718157817D+00 -0.159195515938D+00 -0.149109434868D+00 -0.139448771777D+00\n', ' -0.130202734970D+00 -0.121360844815D+00 -0.112912903371D+00 -0.104848970587D+00\n', ' -0.971593454900D-01 -0.898345511834D-01 -0.828653227895D-01 -0.762425976473D-01\n', ' -0.699575072669D-01 -0.640013706413D-01 -0.583656886141D-01 -0.530421390663D-01\n', ' -0.480225727376D-01 -0.432990095404D-01 -0.388636352520D-01 -0.347087984988D-01\n', ' -0.308270079625D-01 -0.272109297547D-01 -0.238533849179D-01 -0.207473470199D-01\n', ' -0.178859398176D-01 -0.152624349680D-01 -0.128702497753D-01 -0.107029449600D-01\n', ' -0.875422244382D-02 -0.701792314373D-02 -0.548802477161D-02 -0.415863963680D-02\n', ' -0.302401245044D-02 -0.207851813067D-02 -0.131665960939D-02 -0.733065640768D-03\n', ' -0.322488612760D-03 -0.798023629498D-04 -0.130951788091D-13\n', '   25\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.910836100221D-01\n', ' -0.175731038058D+00 -0.254289951499D+00 -0.327089319087D+00 -0.394440471814D+00\n', ' -0.456638099358D+00 -0.513961186222D+00 -0.566673891528D+00 -0.615026376092D+00\n', ' -0.659255580170D+00 -0.699585955043D+00 -0.736230151364D+00 -0.769389667030D+00\n', ' -0.799255457103D+00 -0.826008508190D+00 -0.849820379482D+00 -0.870853712536D+00\n', ' -0.889262711727D+00 -0.905193597184D+00 -0.918785031886D+00 -0.930168524507D+00\n', ' -0.939468809474D+00 -0.946804205618D+00 -0.952286954712D+00 -0.956023541090D+00\n', ' -0.958114993490D+00 -0.958657170165D+00 -0.957741028255D+00 -0.955452878353D+00\n', ' -0.951874625121D+00 -0.947083994787D+00 -0.941154750263D+00 -0.934156894630D+00\n', ' -0.926156863626D+00 -0.917217707805D+00 -0.907399264928D+00 -0.896758323153D+00\n', ' -0.885348775560D+00 -0.873221766467D+00 -0.860425830039D+00 -0.847007021587D+00\n', ' -0.833009041991D+00 -0.818473355609D+00 -0.803439302052D+00 -0.787944202144D+00\n', ' -0.772023458408D+00 -0.755710650358D+00 -0.739037624891D+00 -0.722034582045D+00\n', ' -0.704730156373D+00 -0.687151494166D+00 -0.669324326756D+00 -0.651273040100D+00\n', ' -0.633020740852D+00 -0.614589319101D+00 -0.595999507967D+00 -0.577270940196D+00\n', ' -0.558422201943D+00 -0.539470883862D+00 -0.520433629664D+00 -0.501326182266D+00\n', ' -0.482163427655D+00 -0.462959436593D+00 -0.443727504267D+00 -0.424480187992D+00\n', ' -0.405229343069D+00 -0.385986156892D+00 -0.366761181390D+00 -0.347564363890D+00\n', ' -0.347564363890D+00 -0.330057138148D+00 -0.313682152626D+00 -0.298093260983D+00\n', ' -0.283173370401D+00 -0.268856913569D+00 -0.255100360984D+00 -0.241871811683D+00\n', ' -0.229146262694D+00 -0.216903128162D+00 -0.205124810335D+00 -0.193795819972D+00\n', ' -0.182902207530D+00 -0.172431181099D+00 -0.162370841951D+00 -0.152709997006D+00\n', ' -0.143438023184D+00 -0.134544767629D+00 -0.126020473299D+00 -0.117855722784D+00\n', ' -0.110041395437D+00 -0.102568634352D+00 -0.954288206976D-01 -0.886135535959D-01\n', ' -0.821146342275D-01 -0.759240531543D-01 -0.700339801250D-01 -0.644367557932D-01\n', ' -0.591248849168D-01 -0.540910307059D-01 -0.493280100624D-01 -0.448287895118D-01\n', ' -0.405864816722D-01 -0.365943421386D-01 -0.328457666874D-01 -0.293342887278D-01\n', ' -0.260535769401D-01 -0.229974330573D-01 -0.201597897530D-01 -0.175347086082D-01\n', ' -0.151163781367D-01 -0.128991118507D-01 -0.108773463570D-01 -0.904563947108D-02\n', ' -0.739866834524D-02 -0.593122760428D-02 -0.463822748578D-02 -0.351469198292D-02\n', ' -0.255575698884D-02 -0.175666844166D-02 -0.111278047091D-02 -0.619553545292D-03\n', ' -0.272552623174D-03 -0.674453065838D-04 -0.112512836764D-13\n', '   43\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.268444513742D-01\n', ' -0.500548066307D-01 -0.699457900360D-01 -0.868078731501D-01 -0.100909115568D+00\n', ' -0.112496862702D+00 -0.121799312141D+00 -0.129026959167D+00 -0.134373931089D+00\n', ' -0.138019219277D+00 -0.140127817026D+00 -0.140851770688D+00 -0.140331150927D+00\n', ' -0.138694950372D+00 -0.136061913408D+00 -0.132541303434D+00 -0.128233612407D+00\n', ' -0.123231217174D+00 -0.117618986681D+00 -0.111474843842D+00 -0.104870285545D+00\n', ' -0.978708639919D-01 -0.905366323184D-01 -0.829225572075D-01 -0.750789009913D-01\n', ' -0.670515755483D-01 -0.588824701153D-01 -0.506097549736D-01 -0.422681628129D-01\n', ' -0.338892494404D-01 -0.255016353702D-01 -0.171312297148D-01 -0.880143768684D-02\n', ' -0.533352923024D-03  0.765406425161D-02  0.157438215857D-01  0.237207417339D-01\n', '  0.315713202766D-01  0.392835941091D-01  0.468470194448D-01  0.542523587328D-01\n', '  0.614915758422D-01  0.685577389142D-01  0.754449303262D-01  0.821481632554D-01\n', '  0.886633043631D-01  0.949870021620D-01  0.101116620654D+00  0.107050177862D+00\n', '  0.112786288906D+00  0.118324113288D+00  0.123663306099D+00  0.128803972858D+00\n', '  0.133746627717D+00  0.138492154809D+00  0.143041772497D+00  0.147397000323D+00\n', '  0.151559628473D+00  0.155531689558D+00  0.159315432565D+00  0.162913298813D+00\n', '  0.166327899774D+00  0.169561996620D+00  0.172618481381D+00  0.175500359595D+00\n', '  0.178210734336D+00  0.180752791535D+00  0.183129786488D+00  0.185345031472D+00\n', '  0.185345031472D+00  0.184931678626D+00  0.182571003170D+00  0.179102705992D+00\n', '  0.174861661976D+00  0.170054289762D+00  0.164825839363D+00  0.159285689158D+00\n', '  0.153519615050D+00  0.147596680139D+00  0.141573498882D+00  0.135497066883D+00\n', '  0.129406739952D+00  0.123335675859D+00  0.117311919408D+00  0.111359240949D+00\n', '  0.105497798650D+00  0.997446711754D-01  0.941142927526D-01  0.886188131823D-01\n', '  0.832683990877D-01  0.780714884291D-01  0.730350073337D-01  0.681645561664D-01\n', '  0.634645702171D-01  0.589384592422D-01  0.545887292324D-01  0.504170891306D-01\n', '  0.464245447124D-01  0.426114814506D-01  0.389777378725D-01  0.355226706676D-01\n', '  0.322452126076D-01  0.291439241729D-01  0.262170396519D-01  0.234625083646D-01\n', '  0.208780315749D-01  0.184610955785D-01  0.162090013874D-01  0.141188913829D-01\n', '  0.121877732559D-01  0.104125415219D-01  0.878999685767D-02  0.731686348191D-02\n', '  0.598980477569D-02  0.480543731577D-02  0.376034347671D-02  0.285108273952D-02\n', '  0.207420183130D-02  0.142624380619D-02  0.903756167956D-03  0.503298123378D-03\n', '  0.221447047829D-03  0.548042354075D-04  0.212654742276D-13\n', '   47\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.710237424182D-01\n', '  0.132432570268D+00  0.185059165691D+00  0.229672044198D+00  0.266980424813D+00\n', '  0.297638721984D+00  0.322250689785D+00  0.341373246380D+00  0.355520004351D+00\n', '  0.365164530355D+00  0.370743355613D+00  0.372658756962D+00  0.371281326549D+00\n', '  0.366952346784D+00  0.359985985786D+00  0.350671327331D+00  0.339274248149D+00\n', '  0.326039154403D+00  0.311190588218D+00  0.294934714247D+00  0.277460695473D+00\n', '  0.258941966722D+00  0.239537413656D+00  0.219392464448D+00  0.198640100731D+00\n', '  0.177401793916D+00  0.155788372506D+00  0.133900825574D+00  0.111831047179D+00\n', '  0.896625261379D-01  0.674709852150D-01  0.453249734781D-01  0.232864152992D-01\n', '  0.141111919535D-02 -0.202507505287D-01 -0.416542366014D-01 -0.627591835418D-01\n', ' -0.835298620138D-01 -0.103934620617D+00 -0.123945563116D+00 -0.143538249246D+00\n', ' -0.162691417404D+00 -0.181386727616D+00 -0.199608523324D+00 -0.217343610635D+00\n', ' -0.234581053762D+00 -0.251311985504D+00 -0.267529431666D+00 -0.283228148429D+00\n', ' -0.298404471743D+00 -0.313056177862D+00 -0.327182354243D+00 -0.340783280060D+00\n', ' -0.353860315633D+00 -0.366415800159D+00 -0.378452957120D+00 -0.389975806852D+00\n', ' -0.400989085737D+00 -0.411498171559D+00 -0.421509014581D+00 -0.431028073925D+00\n', ' -0.440062258894D+00 -0.448618874864D+00 -0.456705573429D+00 -0.464330306491D+00\n', ' -0.471501284016D+00 -0.478226935182D+00 -0.484515872695D+00 -0.490376860015D+00\n', ' -0.490376860015D+00 -0.489283231183D+00 -0.483037471001D+00 -0.473861219194D+00\n', ' -0.462640471428D+00 -0.449921360090D+00 -0.436088180592D+00 -0.421430320923D+00\n', ' -0.406174722792D+00 -0.390504109986D+00 -0.374568270278D+00 -0.358491542350D+00\n', ' -0.342378051888D+00 -0.326315526106D+00 -0.310378164577D+00 -0.294628857739D+00\n', ' -0.279120939092D+00 -0.263899594534D+00 -0.249003013440D+00 -0.234463341162D+00\n', ' -0.220307476057D+00 -0.206557742868D+00 -0.193232466407D+00 -0.180346463845D+00\n', ' -0.167911469858D+00 -0.155936505812D+00 -0.144428201936D+00 -0.133391079667D+00\n', ' -0.122827800038D+00 -0.112739382914D+00 -0.103125401078D+00 -0.939841524914D-01\n', ' -0.853128135320D-01 -0.771075755900D-01 -0.693637670313D-01 -0.620759622664D-01\n', ' -0.552380794118D-01 -0.488434678304D-01 -0.428849866719D-01 -0.373550753871D-01\n', ' -0.322458170709D-01 -0.275489953832D-01 -0.232561457104D-01 -0.193586011502D-01\n', ' -0.158475338383D-01 -0.127139920785D-01 -0.994893368355D-02 -0.754325589604D-02\n', ' -0.548782221457D-02 -0.377348642013D-02 -0.239111406624D-02 -0.133160166979D-02\n', ' -0.585893817112D-03 -0.144998377667D-03 -0.576892540902D-13\n', '   73\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.120919961757D+00\n', ' -0.214786820424D+00 -0.285128512040D+00 -0.335095657689D+00 -0.367499098133D+00\n', ' -0.384843759298D+00 -0.389359210512D+00 -0.383027240913D+00 -0.367606746704D+00\n', ' -0.344656192610D+00 -0.315553884595D+00 -0.281516267282D+00 -0.243614438314D+00\n', ' -0.202789052911D+00 -0.159863774732D+00 -0.115557413810D+00 -0.704948785238D-01\n', ' -0.252170561122D-01  0.198102749088D-01  0.641884071634D-01  0.107578457441D+00\n', '  0.149694834283D+00  0.190299351434D+00  0.229195925094D+00  0.266225798879D+00\n', '  0.301263245802D+00  0.334211701450D+00  0.365000286900D+00  0.393580683926D+00\n', '  0.419924328576D+00  0.444019892484D+00  0.465871024148D+00  0.485494325107D+00\n', '  0.502917538266D+00  0.518177927851D+00  0.531320832352D+00  0.542398373649D+00\n', '  0.551468307049D+00  0.558592998456D+00  0.563838516178D+00  0.567273826059D+00\n', '  0.568970079710D+00  0.568999986582D+00  0.567437261474D+00  0.564356139923D+00\n', '  0.559830954572D+00  0.553935766337D+00  0.546744044736D+00  0.538328392293D+00\n', '  0.528760308437D+00  0.518109988718D+00  0.506446155605D+00  0.493835917454D+00\n', '  0.480344652589D+00  0.466035915721D+00  0.450971364214D+00  0.435210701935D+00\n', '  0.418811638652D+00  0.401829863159D+00  0.384319028467D+00  0.366330747570D+00\n', '  0.347914598470D+00  0.329118137231D+00  0.309986918002D+00  0.290564519036D+00\n', '  0.270892573831D+00  0.251010806625D+00  0.230957071537D+00  0.210767394748D+00\n', '  0.210767394748D+00  0.194872722910D+00  0.181954147621D+00  0.170720796879D+00\n', '  0.160691324308D+00  0.151585755783D+00  0.143217785841D+00  0.135454581775D+00\n', '  0.128197437948D+00  0.121371007313D+00  0.114916705224D+00  0.108788385526D+00\n', '  0.102949360099D+00  0.973702639649D-01  0.920274795158D-01  0.869019453892D-01\n', '  0.819782387537D-01  0.772438572460D-01  0.726886500433D-01  0.683043625011D-01\n', '  0.640842686815D-01  0.600228728605D-01  0.561156658172D-01  0.523589250768D-01\n', '  0.487495507301D-01  0.452849302651D-01  0.419628272086D-01  0.387812894162D-01\n', '  0.357385736489D-01  0.328330837010D-01  0.300633198412D-01  0.274278377140D-01\n', '  0.249252151739D-01  0.225540257744D-01  0.203128178425D-01  0.182000982443D-01\n', '  0.162143200854D-01  0.143538737057D-01  0.126170804319D-01  0.110021886245D-01\n', '  0.950737163371D-02  0.813072732961D-02  0.687027892533D-02  0.572397685272D-02\n', '  0.468970148569D-02  0.376526653556D-02  0.294842297179D-02  0.223686334081D-02\n', '  0.162822637464D-02  0.112010180264D-02  0.710035283844D-03  0.395533403271D-03\n', '  0.174068670187D-03  0.430844801113D-04 -0.125071680895D-12\n', '   77\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.643071732209D-01\n', ' -0.114227072733D+00 -0.151635911453D+00 -0.178209240157D+00 -0.195441909001D+00\n', ' -0.204666077730D+00 -0.207067467039D+00 -0.203700024146D+00 -0.195499158236D+00\n', ' -0.183293685821D+00 -0.167816612099D+00 -0.149714861810D+00 -0.129558061846D+00\n', ' -0.107846467724D+00 -0.850181169764D-01 -0.614552842961D-01 -0.374903059721D-01\n', ' -0.134108345054D-01  0.105354216260D-01  0.341364234511D-01  0.572119474482D-01\n', '  0.796101115036D-01  0.101204244350D+00  0.121890065481D+00  0.141583145707D+00\n', '  0.160216621403D+00  0.177739138065D+00  0.194113001148D+00  0.209312514243D+00\n', '  0.223322486585D+00  0.236136893566D+00  0.247757675516D+00  0.258193661399D+00\n', '  0.267459605338D+00  0.275575325044D+00  0.282564932253D+00  0.288456146215D+00\n', '  0.293279682129D+00  0.297068707182D+00  0.299858357558D+00  0.301685310398D+00\n', '  0.302587405270D+00  0.302603310223D+00  0.301772227971D+00  0.300133638159D+00\n', '  0.297727072080D+00  0.294591916516D+00  0.290767243732D+00  0.286291664915D+00\n', '  0.281203204606D+00  0.275539193924D+00  0.269336180580D+00  0.262629853871D+00\n', '  0.255454983039D+00  0.247845367497D+00  0.239833797619D+00  0.231452024878D+00\n', '  0.222730740254D+00  0.213699559940D+00  0.204387017466D+00  0.194820561451D+00\n', '  0.185026558269D+00  0.175030298997D+00  0.164856010062D+00  0.154526867078D+00\n', '  0.144065011405D+00  0.133491569030D+00  0.122826671379D+00  0.112089477754D+00\n', '  0.112089477754D+00  0.103636436582D+00  0.967661312431D-01  0.907920553210D-01\n', '  0.854582211008D-01  0.806157338563D-01  0.761655133573D-01  0.720369170416D-01\n', '  0.681774516694D-01  0.645470464748D-01  0.611145452033D-01  0.578554065912D-01\n', '  0.547501193073D-01  0.517830665868D-01  0.489416882068D-01  0.462158470294D-01\n', '  0.435973409458D-01  0.410795209987D-01  0.386569888181D-01  0.363253544515D-01\n', '  0.340810409377D-01  0.319211255624D-01  0.298432102497D-01  0.278453153280D-01\n', '  0.259257922156D-01  0.240832515371D-01  0.223165039000D-01  0.206245111227D-01\n', '  0.190063461227D-01  0.174611600124D-01  0.159881552105D-01  0.145865635856D-01\n', '  0.132556288181D-01  0.119945923008D-01  0.108026820106D-01  0.967910387520D-02\n', '  0.862303523121D-02  0.763362003566D-02  0.670996554319D-02  0.585114020384D-02\n', '  0.505617257596D-02  0.432405107641D-02  0.365372441826D-02  0.304410260828D-02\n', '  0.249405839542D-02  0.200242907626D-02  0.156801858040D-02  0.118959976698D-02\n', '  0.865916875895D-03  0.595688086562D-03  0.377608141186D-03  0.210351001681D-03\n', '  0.925725079864D-04  0.229130169002D-04 -0.594900858547D-13\n', '   81\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.979799203734D-01\n', ' -0.174039052415D+00 -0.231036038218D+00 -0.271523786318D+00 -0.297779885546D+00\n', ' -0.311834045795D+00 -0.315492858980D+00 -0.310362143852D+00 -0.297867111826D+00\n', ' -0.279270567219D+00 -0.255689333976D+00 -0.228109081836D+00 -0.197397707714D+00\n', ' -0.164317412676D+00 -0.129535600998D+00 -0.936347153865D-01 -0.571211112219D-01\n', ' -0.204330626145D-01  0.160520159776D-01  0.520110569948D-01  0.871694676443D-01\n', '  0.121295836768D+00  0.154197165048D+00  0.185714568251D+00  0.215719408081D+00\n', '  0.244109809548D+00  0.270807527723D+00  0.295755130311D+00  0.318913465661D+00\n', '  0.340259388763D+00  0.359783720384D+00  0.377489416858D+00  0.393389930201D+00\n', '  0.407507740141D+00  0.419873041409D+00  0.430522571212D+00  0.439498563251D+00\n', '  0.446847815925D+00  0.452620863540D+00  0.456871240411D+00  0.459654828693D+00\n', '  0.461029281639D+00  0.461053514800D+00  0.459787258350D+00  0.457290664405D+00\n', '  0.453623963772D+00  0.448847167075D+00  0.443019805740D+00  0.436200708676D+00\n', '  0.428447810968D+00  0.419817991186D+00  0.410366934280D+00  0.400149017304D+00\n', '  0.389217215491D+00  0.377623026420D+00  0.365416410278D+00  0.352645744354D+00\n', '  0.339357790146D+00  0.325597671582D+00  0.311408863019D+00  0.296833185816D+00\n', '  0.281910812404D+00  0.266680276860D+00  0.251178491138D+00  0.235440766146D+00\n', '  0.219500836983D+00  0.203390891699D+00  0.187141603008D+00  0.170782162470D+00\n', '  0.170782162470D+00  0.157902910290D+00  0.147435151619D+00  0.138332909150D+00\n', '  0.130206153984D+00  0.122828026618D+00  0.116047566083D+00  0.109757139712D+00\n', '  0.103876767571D+00  0.983453969002D-01  0.931155572972D-01  0.881498571163D-01\n', '  0.834185684345D-01  0.788978971823D-01  0.745687063085D-01  0.704155506318D-01\n', '  0.664259332265D-01  0.625897235849D-01  0.588986966237D-01  0.553461637082D-01\n', '  0.519266748958D-01  0.486357770709D-01  0.454698164684D-01  0.424257768139D-01\n', '  0.395011462901D-01  0.366938080115D-01  0.340019497921D-01  0.314239898339D-01\n', '  0.289585156121D-01  0.266042337418D-01  0.243599290092D-01  0.222244310713D-01\n', '  0.201965875819D-01  0.182752427090D-01  0.164592201804D-01  0.147473101285D-01\n', '  0.131382591244D-01  0.116307628806D-01  0.102234611895D-01  0.891493471958D-02\n', '  0.770370335957D-02  0.658822583760D-02  0.556690038820D-02  0.463806627207D-02\n', '  0.380000598301D-02  0.305094799877D-02  0.238906995839D-02  0.181250216122D-02\n', '  0.131933130164D-02  0.907604367683D-03  0.575332637913D-03  0.320495729523D-03\n', '  0.141045648670D-03  0.349108110181D-04 -0.908372818246D-13\n', '    3  135 NPAN,MESHN;  Shape number     1;     # serial: voro_v1.0-16-g2d2b8f1_serial_20180516213647\n', '   10   70   55\n', '  0.495000000000D+00  0.555555555556D-03  0.495555555556D+00  0.555555555556D-03\n', '  0.496111111111D+00  0.555555555556D-03  0.496666666667D+00  0.555555555556D-03\n', '  0.497222222222D+00  0.555555555556D-03  0.497777777778D+00  0.555555555556D-03\n', '  0.498333333333D+00  0.555555555556D-03  0.498888888889D+00  0.555555555556D-03\n', '  0.499444444444D+00  0.555555555556D-03  0.500000000000D+00  0.555555555556D-03\n', '  0.500000000000D+00  0.300154755343D-02  0.503001547553D+00  0.300154755343D-02\n', '  0.506003095107D+00  0.300154755343D-02  0.509004642660D+00  0.300154755343D-02\n', '  0.512006190214D+00  0.300154755343D-02  0.515007737767D+00  0.300154755343D-02\n', '  0.518009285321D+00  0.300154755343D-02  0.521010832874D+00  0.300154755343D-02\n', '  0.524012380427D+00  0.300154755343D-02  0.527013927981D+00  0.300154755343D-02\n', '  0.530015475534D+00  0.300154755343D-02  0.533017023088D+00  0.300154755343D-02\n', '  0.536018570641D+00  0.300154755343D-02  0.539020118195D+00  0.300154755343D-02\n', '  0.542021665748D+00  0.300154755343D-02  0.545023213301D+00  0.300154755343D-02\n', '  0.548024760855D+00  0.300154755343D-02  0.551026308408D+00  0.300154755343D-02\n', '  0.554027855962D+00  0.300154755343D-02  0.557029403515D+00  0.300154755343D-02\n', '  0.560030951069D+00  0.300154755343D-02  0.563032498622D+00  0.300154755343D-02\n', '  0.566034046175D+00  0.300154755343D-02  0.569035593729D+00  0.300154755343D-02\n', '  0.572037141282D+00  0.300154755343D-02  0.575038688836D+00  0.300154755343D-02\n', '  0.578040236389D+00  0.300154755343D-02  0.581041783943D+00  0.300154755343D-02\n', '  0.584043331496D+00  0.300154755343D-02  0.587044879049D+00  0.300154755343D-02\n', '  0.590046426603D+00  0.300154755343D-02  0.593047974156D+00  0.300154755343D-02\n', '  0.596049521710D+00  0.300154755343D-02  0.599051069263D+00  0.300154755343D-02\n', '  0.602052616817D+00  0.300154755343D-02  0.605054164370D+00  0.300154755343D-02\n', '  0.608055711923D+00  0.300154755343D-02  0.611057259477D+00  0.300154755343D-02\n', '  0.614058807030D+00  0.300154755343D-02  0.617060354584D+00  0.300154755343D-02\n', '  0.620061902137D+00  0.300154755343D-02  0.623063449691D+00  0.300154755343D-02\n', '  0.626064997244D+00  0.300154755343D-02  0.629066544797D+00  0.300154755343D-02\n', '  0.632068092351D+00  0.300154755343D-02  0.635069639904D+00  0.300154755343D-02\n', '  0.638071187458D+00  0.300154755343D-02  0.641072735011D+00  0.300154755343D-02\n', '  0.644074282565D+00  0.300154755343D-02  0.647075830118D+00  0.300154755343D-02\n', '  0.650077377671D+00  0.300154755343D-02  0.653078925225D+00  0.300154755343D-02\n', '  0.656080472778D+00  0.300154755343D-02  0.659082020332D+00  0.300154755343D-02\n', '  0.662083567885D+00  0.300154755343D-02  0.665085115439D+00  0.300154755343D-02\n', '  0.668086662992D+00  0.300154755343D-02  0.671088210545D+00  0.300154755343D-02\n', '  0.674089758099D+00  0.300154755343D-02  0.677091305652D+00  0.300154755343D-02\n', '  0.680092853206D+00  0.300154755343D-02  0.683094400759D+00  0.300154755343D-02\n', '  0.686095948313D+00  0.300154755343D-02  0.689097495866D+00  0.300154755343D-02\n', '  0.692099043419D+00  0.300154755343D-02  0.695100590973D+00  0.300154755343D-02\n', '  0.698102138526D+00  0.300154755343D-02  0.701103686080D+00  0.300154755343D-02\n', '  0.704105233633D+00  0.300154755343D-02  0.707106781187D+00  0.300154755343D-02\n', '  0.707106781187D+00  0.294293745552D-02  0.710049718642D+00  0.294293745552D-02\n', '  0.712992656098D+00  0.294293745552D-02  0.715935593553D+00  0.294293745552D-02\n', '  0.718878531009D+00  0.294293745552D-02  0.721821468464D+00  0.294293745552D-02\n', '  0.724764405920D+00  0.294293745552D-02  0.727707343375D+00  0.294293745552D-02\n', '  0.730650280831D+00  0.294293745552D-02  0.733593218286D+00  0.294293745552D-02\n', '  0.736536155742D+00  0.294293745552D-02  0.739479093197D+00  0.294293745552D-02\n', '  0.742422030653D+00  0.294293745552D-02  0.745364968108D+00  0.294293745552D-02\n', '  0.748307905564D+00  0.294293745552D-02  0.751250843019D+00  0.294293745552D-02\n', '  0.754193780475D+00  0.294293745552D-02  0.757136717930D+00  0.294293745552D-02\n', '  0.760079655386D+00  0.294293745552D-02  0.763022592841D+00  0.294293745552D-02\n', '  0.765965530297D+00  0.294293745552D-02  0.768908467752D+00  0.294293745552D-02\n', '  0.771851405208D+00  0.294293745552D-02  0.774794342663D+00  0.294293745552D-02\n', '  0.777737280119D+00  0.294293745552D-02  0.780680217574D+00  0.294293745552D-02\n', '  0.783623155030D+00  0.294293745552D-02  0.786566092485D+00  0.294293745552D-02\n', '  0.789509029941D+00  0.294293745552D-02  0.792451967397D+00  0.294293745552D-02\n', '  0.795394904852D+00  0.294293745552D-02  0.798337842308D+00  0.294293745552D-02\n', '  0.801280779763D+00  0.294293745552D-02  0.804223717219D+00  0.294293745552D-02\n', '  0.807166654674D+00  0.294293745552D-02  0.810109592130D+00  0.294293745552D-02\n', '  0.813052529585D+00  0.294293745552D-02  0.815995467041D+00  0.294293745552D-02\n', '  0.818938404496D+00  0.294293745552D-02  0.821881341952D+00  0.294293745552D-02\n', '  0.824824279407D+00  0.294293745552D-02  0.827767216863D+00  0.294293745552D-02\n', '  0.830710154318D+00  0.294293745552D-02  0.833653091774D+00  0.294293745552D-02\n', '  0.836596029229D+00  0.294293745552D-02  0.839538966685D+00  0.294293745552D-02\n', '  0.842481904140D+00  0.294293745552D-02  0.845424841596D+00  0.294293745552D-02\n', '  0.848367779051D+00  0.294293745552D-02  0.851310716507D+00  0.294293745552D-02\n', '  0.854253653962D+00  0.294293745552D-02  0.857196591418D+00  0.294293745552D-02\n', '  0.860139528873D+00  0.294293745552D-02  0.863082466329D+00  0.294293745552D-02\n', '  0.866025403784D+00  0.294293745552D-02\n', '    8\n', '    1\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.348144740577D+01\n', '  0.341873998692D+01  0.335677212636D+01  0.329553081748D+01  0.323500335691D+01\n', '  0.317517733570D+01  0.311604063086D+01  0.305758139715D+01  0.299978805921D+01\n', '  0.294264930386D+01  0.288615407276D+01  0.283029155528D+01  0.277505118156D+01\n', '  0.272042261588D+01  0.266639575022D+01  0.261296069799D+01  0.256010778802D+01\n', '  0.250782755873D+01  0.245611075245D+01  0.240494831001D+01  0.235433136540D+01\n', '  0.230425124068D+01  0.225469944100D+01  0.220566764980D+01  0.215714772417D+01\n', '  0.210913169033D+01  0.206161173925D+01  0.201458022246D+01  0.196802964790D+01\n', '  0.192195267594D+01  0.187634211556D+01  0.183119092059D+01  0.178649218608D+01\n', '  0.174223914475D+01  0.169842516366D+01  0.165504374078D+01  0.161208850186D+01\n', '  0.156955319730D+01  0.152743169906D+01  0.148571799778D+01  0.144440619990D+01\n', '  0.140349052487D+01  0.136296530248D+01  0.132282497020D+01  0.128306407070D+01\n', '  0.124367724929D+01  0.120465925162D+01  0.116600492124D+01  0.112770919739D+01\n', '  0.108976711279D+01  0.105217379146D+01  0.101492444666D+01  0.978014378839D+00\n', '  0.941438973679D+00  0.905193700153D+00  0.869274108662D+00  0.833675829215D+00\n', '  0.798394569651D+00  0.763426113922D+00  0.728766320407D+00  0.694411120278D+00\n', '  0.660356515910D+00  0.626598579329D+00  0.593133450700D+00  0.559957336859D+00\n', '  0.527066509878D+00  0.494457305668D+00  0.462126122617D+00  0.430069420271D+00\n', '  0.430069420271D+00  0.402303316540D+00  0.377539313460D+00  0.354743340664D+00\n', '  0.333530457006D+00  0.313670769379D+00  0.295004615108D+00  0.277411710302D+00\n', '  0.260796664908D+00  0.245081108278D+00  0.230198970219D+00  0.216093447552D+00\n', '  0.202714947697D+00  0.190019635093D+00  0.177968368454D+00  0.166525901810D+00\n', '  0.155660269630D+00  0.145342304080D+00  0.135545249448D+00  0.126244449527D+00\n', '  0.117417090804D+00  0.109041989005D+00  0.101099409844D+00  0.935709170764D-01\n', '  0.864392426117D-01  0.796881746491D-01  0.733024606555D-01  0.672677226928D-01\n', '  0.615703830911D-01  0.561975988595D-01  0.511372035220D-01  0.463776553057D-01\n', '  0.419079907936D-01  0.377177833043D-01  0.337971053812D-01  0.301364948711D-01\n', '  0.267269241521D-01  0.235597721351D-01  0.206267987196D-01  0.179201214265D-01\n', '  0.154321939709D-01  0.131557865685D-01  0.110839677947D-01  0.921008784091D-02\n', '  0.752776303004D-02  0.603086146903D-02  0.471348973284D-02  0.356998048451D-02\n', '  0.259488094746D-02  0.178294215513D-02  0.112910891116D-02  0.628510400363D-03\n', '  0.276451396771D-03  0.684040205092D-04  0.457411886146D-13\n', '   21\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.107771580765D+00\n', ' -0.207927768303D+00 -0.300879928222D+00 -0.387017301583D+00 -0.466708260187D+00\n', ' -0.540301485561D+00 -0.608127076621D+00 -0.670497590656D+00 -0.727709021934D+00\n', ' -0.780041721948D+00 -0.827761265034D+00 -0.871119262839D+00 -0.910354130889D+00\n', ' -0.945691810260D+00 -0.977346447194D+00 -0.100552103326D+01 -0.103040800855D+01\n', ' -0.105218983014D+01 -0.107103950802D+01 -0.108712111043D+01 -0.110059024054D+01\n', ' -0.111159448612D+01 -0.112027384388D+01 -0.112676112010D+01 -0.113118230872D+01\n', ' -0.113365694857D+01 -0.113429846067D+01 -0.113321446694D+01 -0.113050709147D+01\n', ' -0.112627324514D+01 -0.112060489489D+01 -0.111358931816D+01 -0.110530934371D+01\n', ' -0.109584357938D+01 -0.108526662757D+01 -0.107364928929D+01 -0.106105875719D+01\n', ' -0.104755879842D+01 -0.103320992775D+01 -0.101806957159D+01 -0.100219222331D+01\n', ' -0.985629590493D+00 -0.968430734425D+00 -0.950642202363D+00 -0.932308152903D+00\n', ' -0.913470474873D+00 -0.894168900091D+00 -0.874441110314D+00 -0.854322838707D+00\n', ' -0.833847966132D+00 -0.813048612513D+00 -0.791955223572D+00 -0.770596653163D+00\n', ' -0.749000241447D+00 -0.727191889129D+00 -0.705196127964D+00 -0.683036187733D+00\n', ' -0.660734059870D+00 -0.638310557917D+00 -0.615785374981D+00 -0.593177138329D+00\n', ' -0.570503461300D+00 -0.547780992645D+00 -0.525025463440D+00 -0.502251731701D+00\n', ' -0.479473824810D+00 -0.456704979869D+00 -0.433957682089D+00 -0.411243701307D+00\n', ' -0.411243701307D+00 -0.390528872452D+00 -0.371153728294D+00 -0.352708702956D+00\n', ' -0.335055250348D+00 -0.318115790182D+00 -0.301838817656D+00 -0.286186587040D+00\n', ' -0.271129514420D+00 -0.256643242282D+00 -0.242706948687D+00 -0.229302306517D+00\n', ' -0.216412810451D+00 -0.204023324895D+00 -0.192119771086D+00 -0.180688905193D+00\n', ' -0.169718157817D+00 -0.159195515938D+00 -0.149109434868D+00 -0.139448771777D+00\n', ' -0.130202734970D+00 -0.121360844815D+00 -0.112912903371D+00 -0.104848970587D+00\n', ' -0.971593454900D-01 -0.898345511834D-01 -0.828653227895D-01 -0.762425976473D-01\n', ' -0.699575072669D-01 -0.640013706413D-01 -0.583656886141D-01 -0.530421390663D-01\n', ' -0.480225727376D-01 -0.432990095404D-01 -0.388636352520D-01 -0.347087984988D-01\n', ' -0.308270079625D-01 -0.272109297547D-01 -0.238533849179D-01 -0.207473470199D-01\n', ' -0.178859398176D-01 -0.152624349680D-01 -0.128702497753D-01 -0.107029449600D-01\n', ' -0.875422244382D-02 -0.701792314373D-02 -0.548802477161D-02 -0.415863963680D-02\n', ' -0.302401245044D-02 -0.207851813067D-02 -0.131665960939D-02 -0.733065640768D-03\n', ' -0.322488612760D-03 -0.798023629498D-04 -0.130951788091D-13\n', '   25\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.910836100221D-01\n', ' -0.175731038058D+00 -0.254289951499D+00 -0.327089319087D+00 -0.394440471814D+00\n', ' -0.456638099358D+00 -0.513961186222D+00 -0.566673891528D+00 -0.615026376092D+00\n', ' -0.659255580170D+00 -0.699585955043D+00 -0.736230151364D+00 -0.769389667030D+00\n', ' -0.799255457103D+00 -0.826008508190D+00 -0.849820379482D+00 -0.870853712536D+00\n', ' -0.889262711727D+00 -0.905193597184D+00 -0.918785031886D+00 -0.930168524507D+00\n', ' -0.939468809474D+00 -0.946804205618D+00 -0.952286954712D+00 -0.956023541090D+00\n', ' -0.958114993490D+00 -0.958657170165D+00 -0.957741028255D+00 -0.955452878353D+00\n', ' -0.951874625121D+00 -0.947083994787D+00 -0.941154750263D+00 -0.934156894630D+00\n', ' -0.926156863626D+00 -0.917217707805D+00 -0.907399264928D+00 -0.896758323153D+00\n', ' -0.885348775560D+00 -0.873221766467D+00 -0.860425830039D+00 -0.847007021587D+00\n', ' -0.833009041991D+00 -0.818473355609D+00 -0.803439302052D+00 -0.787944202144D+00\n', ' -0.772023458408D+00 -0.755710650358D+00 -0.739037624891D+00 -0.722034582045D+00\n', ' -0.704730156373D+00 -0.687151494166D+00 -0.669324326756D+00 -0.651273040100D+00\n', ' -0.633020740852D+00 -0.614589319101D+00 -0.595999507967D+00 -0.577270940196D+00\n', ' -0.558422201943D+00 -0.539470883862D+00 -0.520433629664D+00 -0.501326182266D+00\n', ' -0.482163427655D+00 -0.462959436593D+00 -0.443727504267D+00 -0.424480187992D+00\n', ' -0.405229343069D+00 -0.385986156892D+00 -0.366761181390D+00 -0.347564363890D+00\n', ' -0.347564363890D+00 -0.330057138148D+00 -0.313682152626D+00 -0.298093260983D+00\n', ' -0.283173370401D+00 -0.268856913569D+00 -0.255100360984D+00 -0.241871811683D+00\n', ' -0.229146262694D+00 -0.216903128162D+00 -0.205124810335D+00 -0.193795819972D+00\n', ' -0.182902207530D+00 -0.172431181099D+00 -0.162370841951D+00 -0.152709997006D+00\n', ' -0.143438023184D+00 -0.134544767629D+00 -0.126020473299D+00 -0.117855722784D+00\n', ' -0.110041395437D+00 -0.102568634352D+00 -0.954288206976D-01 -0.886135535959D-01\n', ' -0.821146342275D-01 -0.759240531543D-01 -0.700339801250D-01 -0.644367557932D-01\n', ' -0.591248849168D-01 -0.540910307059D-01 -0.493280100624D-01 -0.448287895118D-01\n', ' -0.405864816722D-01 -0.365943421386D-01 -0.328457666874D-01 -0.293342887278D-01\n', ' -0.260535769401D-01 -0.229974330573D-01 -0.201597897530D-01 -0.175347086082D-01\n', ' -0.151163781367D-01 -0.128991118507D-01 -0.108773463570D-01 -0.904563947108D-02\n', ' -0.739866834524D-02 -0.593122760428D-02 -0.463822748578D-02 -0.351469198292D-02\n', ' -0.255575698884D-02 -0.175666844166D-02 -0.111278047091D-02 -0.619553545292D-03\n', ' -0.272552623174D-03 -0.674453065838D-04 -0.112512836764D-13\n', '   43\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.268444513742D-01\n', ' -0.500548066307D-01 -0.699457900360D-01 -0.868078731501D-01 -0.100909115568D+00\n', ' -0.112496862702D+00 -0.121799312141D+00 -0.129026959167D+00 -0.134373931089D+00\n', ' -0.138019219277D+00 -0.140127817026D+00 -0.140851770688D+00 -0.140331150927D+00\n', ' -0.138694950372D+00 -0.136061913408D+00 -0.132541303434D+00 -0.128233612407D+00\n', ' -0.123231217174D+00 -0.117618986681D+00 -0.111474843842D+00 -0.104870285545D+00\n', ' -0.978708639919D-01 -0.905366323184D-01 -0.829225572075D-01 -0.750789009913D-01\n', ' -0.670515755483D-01 -0.588824701153D-01 -0.506097549736D-01 -0.422681628129D-01\n', ' -0.338892494404D-01 -0.255016353702D-01 -0.171312297148D-01 -0.880143768684D-02\n', ' -0.533352923024D-03  0.765406425161D-02  0.157438215857D-01  0.237207417339D-01\n', '  0.315713202766D-01  0.392835941091D-01  0.468470194448D-01  0.542523587328D-01\n', '  0.614915758422D-01  0.685577389142D-01  0.754449303262D-01  0.821481632554D-01\n', '  0.886633043631D-01  0.949870021620D-01  0.101116620654D+00  0.107050177862D+00\n', '  0.112786288906D+00  0.118324113288D+00  0.123663306099D+00  0.128803972858D+00\n', '  0.133746627717D+00  0.138492154809D+00  0.143041772497D+00  0.147397000323D+00\n', '  0.151559628473D+00  0.155531689558D+00  0.159315432565D+00  0.162913298813D+00\n', '  0.166327899774D+00  0.169561996620D+00  0.172618481381D+00  0.175500359595D+00\n', '  0.178210734336D+00  0.180752791535D+00  0.183129786488D+00  0.185345031472D+00\n', '  0.185345031472D+00  0.184931678626D+00  0.182571003170D+00  0.179102705992D+00\n', '  0.174861661976D+00  0.170054289762D+00  0.164825839363D+00  0.159285689158D+00\n', '  0.153519615050D+00  0.147596680139D+00  0.141573498882D+00  0.135497066883D+00\n', '  0.129406739952D+00  0.123335675859D+00  0.117311919408D+00  0.111359240949D+00\n', '  0.105497798650D+00  0.997446711754D-01  0.941142927526D-01  0.886188131823D-01\n', '  0.832683990877D-01  0.780714884291D-01  0.730350073337D-01  0.681645561664D-01\n', '  0.634645702171D-01  0.589384592422D-01  0.545887292324D-01  0.504170891306D-01\n', '  0.464245447124D-01  0.426114814506D-01  0.389777378725D-01  0.355226706676D-01\n', '  0.322452126076D-01  0.291439241729D-01  0.262170396519D-01  0.234625083646D-01\n', '  0.208780315749D-01  0.184610955785D-01  0.162090013874D-01  0.141188913829D-01\n', '  0.121877732559D-01  0.104125415219D-01  0.878999685767D-02  0.731686348191D-02\n', '  0.598980477569D-02  0.480543731577D-02  0.376034347671D-02  0.285108273952D-02\n', '  0.207420183130D-02  0.142624380619D-02  0.903756167956D-03  0.503298123378D-03\n', '  0.221447047829D-03  0.548042354075D-04  0.212654742276D-13\n', '   47\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.710237424182D-01\n', '  0.132432570268D+00  0.185059165691D+00  0.229672044198D+00  0.266980424813D+00\n', '  0.297638721984D+00  0.322250689785D+00  0.341373246380D+00  0.355520004351D+00\n', '  0.365164530355D+00  0.370743355613D+00  0.372658756962D+00  0.371281326549D+00\n', '  0.366952346784D+00  0.359985985786D+00  0.350671327331D+00  0.339274248149D+00\n', '  0.326039154403D+00  0.311190588218D+00  0.294934714247D+00  0.277460695473D+00\n', '  0.258941966722D+00  0.239537413656D+00  0.219392464448D+00  0.198640100731D+00\n', '  0.177401793916D+00  0.155788372506D+00  0.133900825574D+00  0.111831047179D+00\n', '  0.896625261379D-01  0.674709852150D-01  0.453249734781D-01  0.232864152992D-01\n', '  0.141111919535D-02 -0.202507505287D-01 -0.416542366014D-01 -0.627591835418D-01\n', ' -0.835298620138D-01 -0.103934620617D+00 -0.123945563116D+00 -0.143538249246D+00\n', ' -0.162691417404D+00 -0.181386727616D+00 -0.199608523324D+00 -0.217343610635D+00\n', ' -0.234581053762D+00 -0.251311985504D+00 -0.267529431666D+00 -0.283228148429D+00\n', ' -0.298404471743D+00 -0.313056177862D+00 -0.327182354243D+00 -0.340783280060D+00\n', ' -0.353860315633D+00 -0.366415800159D+00 -0.378452957120D+00 -0.389975806852D+00\n', ' -0.400989085737D+00 -0.411498171559D+00 -0.421509014581D+00 -0.431028073925D+00\n', ' -0.440062258894D+00 -0.448618874864D+00 -0.456705573429D+00 -0.464330306491D+00\n', ' -0.471501284016D+00 -0.478226935182D+00 -0.484515872695D+00 -0.490376860015D+00\n', ' -0.490376860015D+00 -0.489283231183D+00 -0.483037471001D+00 -0.473861219194D+00\n', ' -0.462640471428D+00 -0.449921360090D+00 -0.436088180592D+00 -0.421430320923D+00\n', ' -0.406174722792D+00 -0.390504109986D+00 -0.374568270278D+00 -0.358491542350D+00\n', ' -0.342378051888D+00 -0.326315526106D+00 -0.310378164577D+00 -0.294628857739D+00\n', ' -0.279120939092D+00 -0.263899594534D+00 -0.249003013440D+00 -0.234463341162D+00\n', ' -0.220307476057D+00 -0.206557742868D+00 -0.193232466407D+00 -0.180346463845D+00\n', ' -0.167911469858D+00 -0.155936505812D+00 -0.144428201936D+00 -0.133391079667D+00\n', ' -0.122827800038D+00 -0.112739382914D+00 -0.103125401078D+00 -0.939841524914D-01\n', ' -0.853128135320D-01 -0.771075755900D-01 -0.693637670313D-01 -0.620759622664D-01\n', ' -0.552380794118D-01 -0.488434678304D-01 -0.428849866719D-01 -0.373550753871D-01\n', ' -0.322458170709D-01 -0.275489953832D-01 -0.232561457104D-01 -0.193586011502D-01\n', ' -0.158475338383D-01 -0.127139920785D-01 -0.994893368355D-02 -0.754325589604D-02\n', ' -0.548782221457D-02 -0.377348642013D-02 -0.239111406624D-02 -0.133160166979D-02\n', ' -0.585893817112D-03 -0.144998377667D-03 -0.576892540902D-13\n', '   73\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.120919961757D+00\n', ' -0.214786820424D+00 -0.285128512040D+00 -0.335095657689D+00 -0.367499098133D+00\n', ' -0.384843759298D+00 -0.389359210512D+00 -0.383027240913D+00 -0.367606746704D+00\n', ' -0.344656192610D+00 -0.315553884595D+00 -0.281516267282D+00 -0.243614438314D+00\n', ' -0.202789052911D+00 -0.159863774732D+00 -0.115557413810D+00 -0.704948785238D-01\n', ' -0.252170561122D-01  0.198102749088D-01  0.641884071634D-01  0.107578457441D+00\n', '  0.149694834283D+00  0.190299351434D+00  0.229195925094D+00  0.266225798879D+00\n', '  0.301263245802D+00  0.334211701450D+00  0.365000286900D+00  0.393580683926D+00\n', '  0.419924328576D+00  0.444019892484D+00  0.465871024148D+00  0.485494325107D+00\n', '  0.502917538266D+00  0.518177927851D+00  0.531320832352D+00  0.542398373649D+00\n', '  0.551468307049D+00  0.558592998456D+00  0.563838516178D+00  0.567273826059D+00\n', '  0.568970079710D+00  0.568999986582D+00  0.567437261474D+00  0.564356139923D+00\n', '  0.559830954572D+00  0.553935766337D+00  0.546744044736D+00  0.538328392293D+00\n', '  0.528760308437D+00  0.518109988718D+00  0.506446155605D+00  0.493835917454D+00\n', '  0.480344652589D+00  0.466035915721D+00  0.450971364214D+00  0.435210701935D+00\n', '  0.418811638652D+00  0.401829863159D+00  0.384319028467D+00  0.366330747570D+00\n', '  0.347914598470D+00  0.329118137231D+00  0.309986918002D+00  0.290564519036D+00\n', '  0.270892573831D+00  0.251010806625D+00  0.230957071537D+00  0.210767394748D+00\n', '  0.210767394748D+00  0.194872722910D+00  0.181954147621D+00  0.170720796879D+00\n', '  0.160691324308D+00  0.151585755783D+00  0.143217785841D+00  0.135454581775D+00\n', '  0.128197437948D+00  0.121371007313D+00  0.114916705224D+00  0.108788385526D+00\n', '  0.102949360099D+00  0.973702639649D-01  0.920274795158D-01  0.869019453892D-01\n', '  0.819782387537D-01  0.772438572460D-01  0.726886500433D-01  0.683043625011D-01\n', '  0.640842686815D-01  0.600228728605D-01  0.561156658172D-01  0.523589250768D-01\n', '  0.487495507301D-01  0.452849302651D-01  0.419628272086D-01  0.387812894162D-01\n', '  0.357385736489D-01  0.328330837010D-01  0.300633198412D-01  0.274278377140D-01\n', '  0.249252151739D-01  0.225540257744D-01  0.203128178425D-01  0.182000982443D-01\n', '  0.162143200854D-01  0.143538737057D-01  0.126170804319D-01  0.110021886245D-01\n', '  0.950737163371D-02  0.813072732961D-02  0.687027892533D-02  0.572397685272D-02\n', '  0.468970148569D-02  0.376526653556D-02  0.294842297179D-02  0.223686334081D-02\n', '  0.162822637464D-02  0.112010180264D-02  0.710035283844D-03  0.395533403271D-03\n', '  0.174068670187D-03  0.430844801113D-04 -0.125071680895D-12\n', '   77\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.643071732209D-01\n', ' -0.114227072733D+00 -0.151635911453D+00 -0.178209240157D+00 -0.195441909001D+00\n', ' -0.204666077730D+00 -0.207067467039D+00 -0.203700024146D+00 -0.195499158236D+00\n', ' -0.183293685821D+00 -0.167816612099D+00 -0.149714861810D+00 -0.129558061846D+00\n', ' -0.107846467724D+00 -0.850181169764D-01 -0.614552842961D-01 -0.374903059721D-01\n', ' -0.134108345054D-01  0.105354216260D-01  0.341364234511D-01  0.572119474482D-01\n', '  0.796101115036D-01  0.101204244350D+00  0.121890065481D+00  0.141583145707D+00\n', '  0.160216621403D+00  0.177739138065D+00  0.194113001148D+00  0.209312514243D+00\n', '  0.223322486585D+00  0.236136893566D+00  0.247757675516D+00  0.258193661399D+00\n', '  0.267459605338D+00  0.275575325044D+00  0.282564932253D+00  0.288456146215D+00\n', '  0.293279682129D+00  0.297068707182D+00  0.299858357558D+00  0.301685310398D+00\n', '  0.302587405270D+00  0.302603310223D+00  0.301772227971D+00  0.300133638159D+00\n', '  0.297727072080D+00  0.294591916516D+00  0.290767243732D+00  0.286291664915D+00\n', '  0.281203204606D+00  0.275539193924D+00  0.269336180580D+00  0.262629853871D+00\n', '  0.255454983039D+00  0.247845367497D+00  0.239833797619D+00  0.231452024878D+00\n', '  0.222730740254D+00  0.213699559940D+00  0.204387017466D+00  0.194820561451D+00\n', '  0.185026558269D+00  0.175030298997D+00  0.164856010062D+00  0.154526867078D+00\n', '  0.144065011405D+00  0.133491569030D+00  0.122826671379D+00  0.112089477754D+00\n', '  0.112089477754D+00  0.103636436582D+00  0.967661312431D-01  0.907920553210D-01\n', '  0.854582211008D-01  0.806157338563D-01  0.761655133573D-01  0.720369170416D-01\n', '  0.681774516694D-01  0.645470464748D-01  0.611145452033D-01  0.578554065912D-01\n', '  0.547501193073D-01  0.517830665868D-01  0.489416882068D-01  0.462158470294D-01\n', '  0.435973409458D-01  0.410795209987D-01  0.386569888181D-01  0.363253544515D-01\n', '  0.340810409377D-01  0.319211255624D-01  0.298432102497D-01  0.278453153280D-01\n', '  0.259257922156D-01  0.240832515371D-01  0.223165039000D-01  0.206245111227D-01\n', '  0.190063461227D-01  0.174611600124D-01  0.159881552105D-01  0.145865635856D-01\n', '  0.132556288181D-01  0.119945923008D-01  0.108026820106D-01  0.967910387520D-02\n', '  0.862303523121D-02  0.763362003566D-02  0.670996554319D-02  0.585114020384D-02\n', '  0.505617257596D-02  0.432405107641D-02  0.365372441826D-02  0.304410260828D-02\n', '  0.249405839542D-02  0.200242907626D-02  0.156801858040D-02  0.118959976698D-02\n', '  0.865916875895D-03  0.595688086562D-03  0.377608141186D-03  0.210351001681D-03\n', '  0.925725079864D-04  0.229130169002D-04 -0.594900858547D-13\n', '   81\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.979799203734D-01\n', ' -0.174039052415D+00 -0.231036038218D+00 -0.271523786318D+00 -0.297779885546D+00\n', ' -0.311834045795D+00 -0.315492858980D+00 -0.310362143852D+00 -0.297867111826D+00\n', ' -0.279270567219D+00 -0.255689333976D+00 -0.228109081836D+00 -0.197397707714D+00\n', ' -0.164317412676D+00 -0.129535600998D+00 -0.936347153865D-01 -0.571211112219D-01\n', ' -0.204330626145D-01  0.160520159776D-01  0.520110569948D-01  0.871694676443D-01\n', '  0.121295836768D+00  0.154197165048D+00  0.185714568251D+00  0.215719408081D+00\n', '  0.244109809548D+00  0.270807527723D+00  0.295755130311D+00  0.318913465661D+00\n', '  0.340259388763D+00  0.359783720384D+00  0.377489416858D+00  0.393389930201D+00\n', '  0.407507740141D+00  0.419873041409D+00  0.430522571212D+00  0.439498563251D+00\n', '  0.446847815925D+00  0.452620863540D+00  0.456871240411D+00  0.459654828693D+00\n', '  0.461029281639D+00  0.461053514800D+00  0.459787258350D+00  0.457290664405D+00\n', '  0.453623963772D+00  0.448847167075D+00  0.443019805740D+00  0.436200708676D+00\n', '  0.428447810968D+00  0.419817991186D+00  0.410366934280D+00  0.400149017304D+00\n', '  0.389217215491D+00  0.377623026420D+00  0.365416410278D+00  0.352645744354D+00\n', '  0.339357790146D+00  0.325597671582D+00  0.311408863019D+00  0.296833185816D+00\n', '  0.281910812404D+00  0.266680276860D+00  0.251178491138D+00  0.235440766146D+00\n', '  0.219500836983D+00  0.203390891699D+00  0.187141603008D+00  0.170782162470D+00\n', '  0.170782162470D+00  0.157902910290D+00  0.147435151619D+00  0.138332909150D+00\n', '  0.130206153984D+00  0.122828026618D+00  0.116047566083D+00  0.109757139712D+00\n', '  0.103876767571D+00  0.983453969002D-01  0.931155572972D-01  0.881498571163D-01\n', '  0.834185684345D-01  0.788978971823D-01  0.745687063085D-01  0.704155506318D-01\n', '  0.664259332265D-01  0.625897235849D-01  0.588986966237D-01  0.553461637082D-01\n', '  0.519266748958D-01  0.486357770709D-01  0.454698164684D-01  0.424257768139D-01\n', '  0.395011462901D-01  0.366938080115D-01  0.340019497921D-01  0.314239898339D-01\n', '  0.289585156121D-01  0.266042337418D-01  0.243599290092D-01  0.222244310713D-01\n', '  0.201965875819D-01  0.182752427090D-01  0.164592201804D-01  0.147473101285D-01\n', '  0.131382591244D-01  0.116307628806D-01  0.102234611895D-01  0.891493471958D-02\n', '  0.770370335957D-02  0.658822583760D-02  0.556690038820D-02  0.463806627207D-02\n', '  0.380000598301D-02  0.305094799877D-02  0.238906995839D-02  0.181250216122D-02\n', '  0.131933130164D-02  0.907604367683D-03  0.575332637913D-03  0.320495729523D-03\n', '  0.141045648670D-03  0.349108110181D-04 -0.908372818246D-13\n', '    3  135 NPAN,MESHN;  Shape number     1;     # serial: voro_v1.0-16-g2d2b8f1_serial_20180516213647\n', '   10   70   55\n', '  0.495000000000D+00  0.555555555556D-03  0.495555555556D+00  0.555555555556D-03\n', '  0.496111111111D+00  0.555555555556D-03  0.496666666667D+00  0.555555555556D-03\n', '  0.497222222222D+00  0.555555555556D-03  0.497777777778D+00  0.555555555556D-03\n', '  0.498333333333D+00  0.555555555556D-03  0.498888888889D+00  0.555555555556D-03\n', '  0.499444444444D+00  0.555555555556D-03  0.500000000000D+00  0.555555555556D-03\n', '  0.500000000000D+00  0.300154755343D-02  0.503001547553D+00  0.300154755343D-02\n', '  0.506003095107D+00  0.300154755343D-02  0.509004642660D+00  0.300154755343D-02\n', '  0.512006190214D+00  0.300154755343D-02  0.515007737767D+00  0.300154755343D-02\n', '  0.518009285321D+00  0.300154755343D-02  0.521010832874D+00  0.300154755343D-02\n', '  0.524012380427D+00  0.300154755343D-02  0.527013927981D+00  0.300154755343D-02\n', '  0.530015475534D+00  0.300154755343D-02  0.533017023088D+00  0.300154755343D-02\n', '  0.536018570641D+00  0.300154755343D-02  0.539020118195D+00  0.300154755343D-02\n', '  0.542021665748D+00  0.300154755343D-02  0.545023213301D+00  0.300154755343D-02\n', '  0.548024760855D+00  0.300154755343D-02  0.551026308408D+00  0.300154755343D-02\n', '  0.554027855962D+00  0.300154755343D-02  0.557029403515D+00  0.300154755343D-02\n', '  0.560030951069D+00  0.300154755343D-02  0.563032498622D+00  0.300154755343D-02\n', '  0.566034046175D+00  0.300154755343D-02  0.569035593729D+00  0.300154755343D-02\n', '  0.572037141282D+00  0.300154755343D-02  0.575038688836D+00  0.300154755343D-02\n', '  0.578040236389D+00  0.300154755343D-02  0.581041783943D+00  0.300154755343D-02\n', '  0.584043331496D+00  0.300154755343D-02  0.587044879049D+00  0.300154755343D-02\n', '  0.590046426603D+00  0.300154755343D-02  0.593047974156D+00  0.300154755343D-02\n', '  0.596049521710D+00  0.300154755343D-02  0.599051069263D+00  0.300154755343D-02\n', '  0.602052616817D+00  0.300154755343D-02  0.605054164370D+00  0.300154755343D-02\n', '  0.608055711923D+00  0.300154755343D-02  0.611057259477D+00  0.300154755343D-02\n', '  0.614058807030D+00  0.300154755343D-02  0.617060354584D+00  0.300154755343D-02\n', '  0.620061902137D+00  0.300154755343D-02  0.623063449691D+00  0.300154755343D-02\n', '  0.626064997244D+00  0.300154755343D-02  0.629066544797D+00  0.300154755343D-02\n', '  0.632068092351D+00  0.300154755343D-02  0.635069639904D+00  0.300154755343D-02\n', '  0.638071187458D+00  0.300154755343D-02  0.641072735011D+00  0.300154755343D-02\n', '  0.644074282565D+00  0.300154755343D-02  0.647075830118D+00  0.300154755343D-02\n', '  0.650077377671D+00  0.300154755343D-02  0.653078925225D+00  0.300154755343D-02\n', '  0.656080472778D+00  0.300154755343D-02  0.659082020332D+00  0.300154755343D-02\n', '  0.662083567885D+00  0.300154755343D-02  0.665085115439D+00  0.300154755343D-02\n', '  0.668086662992D+00  0.300154755343D-02  0.671088210545D+00  0.300154755343D-02\n', '  0.674089758099D+00  0.300154755343D-02  0.677091305652D+00  0.300154755343D-02\n', '  0.680092853206D+00  0.300154755343D-02  0.683094400759D+00  0.300154755343D-02\n', '  0.686095948313D+00  0.300154755343D-02  0.689097495866D+00  0.300154755343D-02\n', '  0.692099043419D+00  0.300154755343D-02  0.695100590973D+00  0.300154755343D-02\n', '  0.698102138526D+00  0.300154755343D-02  0.701103686080D+00  0.300154755343D-02\n', '  0.704105233633D+00  0.300154755343D-02  0.707106781187D+00  0.300154755343D-02\n', '  0.707106781187D+00  0.294293745552D-02  0.710049718642D+00  0.294293745552D-02\n', '  0.712992656098D+00  0.294293745552D-02  0.715935593553D+00  0.294293745552D-02\n', '  0.718878531009D+00  0.294293745552D-02  0.721821468464D+00  0.294293745552D-02\n', '  0.724764405920D+00  0.294293745552D-02  0.727707343375D+00  0.294293745552D-02\n', '  0.730650280831D+00  0.294293745552D-02  0.733593218286D+00  0.294293745552D-02\n', '  0.736536155742D+00  0.294293745552D-02  0.739479093197D+00  0.294293745552D-02\n', '  0.742422030653D+00  0.294293745552D-02  0.745364968108D+00  0.294293745552D-02\n', '  0.748307905564D+00  0.294293745552D-02  0.751250843019D+00  0.294293745552D-02\n', '  0.754193780475D+00  0.294293745552D-02  0.757136717930D+00  0.294293745552D-02\n', '  0.760079655386D+00  0.294293745552D-02  0.763022592841D+00  0.294293745552D-02\n', '  0.765965530297D+00  0.294293745552D-02  0.768908467752D+00  0.294293745552D-02\n', '  0.771851405208D+00  0.294293745552D-02  0.774794342663D+00  0.294293745552D-02\n', '  0.777737280119D+00  0.294293745552D-02  0.780680217574D+00  0.294293745552D-02\n', '  0.783623155030D+00  0.294293745552D-02  0.786566092485D+00  0.294293745552D-02\n', '  0.789509029941D+00  0.294293745552D-02  0.792451967397D+00  0.294293745552D-02\n', '  0.795394904852D+00  0.294293745552D-02  0.798337842308D+00  0.294293745552D-02\n', '  0.801280779763D+00  0.294293745552D-02  0.804223717219D+00  0.294293745552D-02\n', '  0.807166654674D+00  0.294293745552D-02  0.810109592130D+00  0.294293745552D-02\n', '  0.813052529585D+00  0.294293745552D-02  0.815995467041D+00  0.294293745552D-02\n', '  0.818938404496D+00  0.294293745552D-02  0.821881341952D+00  0.294293745552D-02\n', '  0.824824279407D+00  0.294293745552D-02  0.827767216863D+00  0.294293745552D-02\n', '  0.830710154318D+00  0.294293745552D-02  0.833653091774D+00  0.294293745552D-02\n', '  0.836596029229D+00  0.294293745552D-02  0.839538966685D+00  0.294293745552D-02\n', '  0.842481904140D+00  0.294293745552D-02  0.845424841596D+00  0.294293745552D-02\n', '  0.848367779051D+00  0.294293745552D-02  0.851310716507D+00  0.294293745552D-02\n', '  0.854253653962D+00  0.294293745552D-02  0.857196591418D+00  0.294293745552D-02\n', '  0.860139528873D+00  0.294293745552D-02  0.863082466329D+00  0.294293745552D-02\n', '  0.866025403784D+00  0.294293745552D-02\n', '    8\n', '    1\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.348144740577D+01\n', '  0.341873998692D+01  0.335677212636D+01  0.329553081748D+01  0.323500335691D+01\n', '  0.317517733570D+01  0.311604063086D+01  0.305758139715D+01  0.299978805921D+01\n', '  0.294264930386D+01  0.288615407276D+01  0.283029155528D+01  0.277505118156D+01\n', '  0.272042261588D+01  0.266639575022D+01  0.261296069799D+01  0.256010778802D+01\n', '  0.250782755873D+01  0.245611075245D+01  0.240494831001D+01  0.235433136540D+01\n', '  0.230425124068D+01  0.225469944100D+01  0.220566764980D+01  0.215714772417D+01\n', '  0.210913169033D+01  0.206161173925D+01  0.201458022246D+01  0.196802964790D+01\n', '  0.192195267594D+01  0.187634211556D+01  0.183119092059D+01  0.178649218608D+01\n', '  0.174223914475D+01  0.169842516366D+01  0.165504374078D+01  0.161208850186D+01\n', '  0.156955319730D+01  0.152743169906D+01  0.148571799778D+01  0.144440619990D+01\n', '  0.140349052487D+01  0.136296530248D+01  0.132282497020D+01  0.128306407070D+01\n', '  0.124367724929D+01  0.120465925162D+01  0.116600492124D+01  0.112770919739D+01\n', '  0.108976711279D+01  0.105217379146D+01  0.101492444666D+01  0.978014378839D+00\n', '  0.941438973679D+00  0.905193700153D+00  0.869274108662D+00  0.833675829215D+00\n', '  0.798394569651D+00  0.763426113922D+00  0.728766320407D+00  0.694411120278D+00\n', '  0.660356515910D+00  0.626598579329D+00  0.593133450700D+00  0.559957336859D+00\n', '  0.527066509878D+00  0.494457305668D+00  0.462126122617D+00  0.430069420271D+00\n', '  0.430069420271D+00  0.402303316540D+00  0.377539313460D+00  0.354743340664D+00\n', '  0.333530457006D+00  0.313670769379D+00  0.295004615108D+00  0.277411710302D+00\n', '  0.260796664908D+00  0.245081108278D+00  0.230198970219D+00  0.216093447552D+00\n', '  0.202714947697D+00  0.190019635093D+00  0.177968368454D+00  0.166525901810D+00\n', '  0.155660269630D+00  0.145342304080D+00  0.135545249448D+00  0.126244449527D+00\n', '  0.117417090804D+00  0.109041989005D+00  0.101099409844D+00  0.935709170764D-01\n', '  0.864392426117D-01  0.796881746491D-01  0.733024606555D-01  0.672677226928D-01\n', '  0.615703830911D-01  0.561975988595D-01  0.511372035220D-01  0.463776553057D-01\n', '  0.419079907936D-01  0.377177833043D-01  0.337971053812D-01  0.301364948711D-01\n', '  0.267269241521D-01  0.235597721351D-01  0.206267987196D-01  0.179201214265D-01\n', '  0.154321939709D-01  0.131557865685D-01  0.110839677947D-01  0.921008784091D-02\n', '  0.752776303004D-02  0.603086146903D-02  0.471348973284D-02  0.356998048451D-02\n', '  0.259488094746D-02  0.178294215513D-02  0.112910891116D-02  0.628510400363D-03\n', '  0.276451396771D-03  0.684040205092D-04  0.457411886146D-13\n', '   21\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.107771580765D+00\n', ' -0.207927768303D+00 -0.300879928222D+00 -0.387017301583D+00 -0.466708260187D+00\n', ' -0.540301485561D+00 -0.608127076621D+00 -0.670497590656D+00 -0.727709021934D+00\n', ' -0.780041721948D+00 -0.827761265034D+00 -0.871119262839D+00 -0.910354130889D+00\n', ' -0.945691810260D+00 -0.977346447194D+00 -0.100552103326D+01 -0.103040800855D+01\n', ' -0.105218983014D+01 -0.107103950802D+01 -0.108712111043D+01 -0.110059024054D+01\n', ' -0.111159448612D+01 -0.112027384388D+01 -0.112676112010D+01 -0.113118230872D+01\n', ' -0.113365694857D+01 -0.113429846067D+01 -0.113321446694D+01 -0.113050709147D+01\n', ' -0.112627324514D+01 -0.112060489489D+01 -0.111358931816D+01 -0.110530934371D+01\n', ' -0.109584357938D+01 -0.108526662757D+01 -0.107364928929D+01 -0.106105875719D+01\n', ' -0.104755879842D+01 -0.103320992775D+01 -0.101806957159D+01 -0.100219222331D+01\n', ' -0.985629590493D+00 -0.968430734425D+00 -0.950642202363D+00 -0.932308152903D+00\n', ' -0.913470474873D+00 -0.894168900091D+00 -0.874441110314D+00 -0.854322838707D+00\n', ' -0.833847966132D+00 -0.813048612513D+00 -0.791955223572D+00 -0.770596653163D+00\n', ' -0.749000241447D+00 -0.727191889129D+00 -0.705196127964D+00 -0.683036187733D+00\n', ' -0.660734059870D+00 -0.638310557917D+00 -0.615785374981D+00 -0.593177138329D+00\n', ' -0.570503461300D+00 -0.547780992645D+00 -0.525025463440D+00 -0.502251731701D+00\n', ' -0.479473824810D+00 -0.456704979869D+00 -0.433957682089D+00 -0.411243701307D+00\n', ' -0.411243701307D+00 -0.390528872452D+00 -0.371153728294D+00 -0.352708702956D+00\n', ' -0.335055250348D+00 -0.318115790182D+00 -0.301838817656D+00 -0.286186587040D+00\n', ' -0.271129514420D+00 -0.256643242282D+00 -0.242706948687D+00 -0.229302306517D+00\n', ' -0.216412810451D+00 -0.204023324895D+00 -0.192119771086D+00 -0.180688905193D+00\n', ' -0.169718157817D+00 -0.159195515938D+00 -0.149109434868D+00 -0.139448771777D+00\n', ' -0.130202734970D+00 -0.121360844815D+00 -0.112912903371D+00 -0.104848970587D+00\n', ' -0.971593454900D-01 -0.898345511834D-01 -0.828653227895D-01 -0.762425976473D-01\n', ' -0.699575072669D-01 -0.640013706413D-01 -0.583656886141D-01 -0.530421390663D-01\n', ' -0.480225727376D-01 -0.432990095404D-01 -0.388636352520D-01 -0.347087984988D-01\n', ' -0.308270079625D-01 -0.272109297547D-01 -0.238533849179D-01 -0.207473470199D-01\n', ' -0.178859398176D-01 -0.152624349680D-01 -0.128702497753D-01 -0.107029449600D-01\n', ' -0.875422244382D-02 -0.701792314373D-02 -0.548802477161D-02 -0.415863963680D-02\n', ' -0.302401245044D-02 -0.207851813067D-02 -0.131665960939D-02 -0.733065640768D-03\n', ' -0.322488612760D-03 -0.798023629498D-04 -0.130951788091D-13\n', '   25\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.910836100221D-01\n', ' -0.175731038058D+00 -0.254289951499D+00 -0.327089319087D+00 -0.394440471814D+00\n', ' -0.456638099358D+00 -0.513961186222D+00 -0.566673891528D+00 -0.615026376092D+00\n', ' -0.659255580170D+00 -0.699585955043D+00 -0.736230151364D+00 -0.769389667030D+00\n', ' -0.799255457103D+00 -0.826008508190D+00 -0.849820379482D+00 -0.870853712536D+00\n', ' -0.889262711727D+00 -0.905193597184D+00 -0.918785031886D+00 -0.930168524507D+00\n', ' -0.939468809474D+00 -0.946804205618D+00 -0.952286954712D+00 -0.956023541090D+00\n', ' -0.958114993490D+00 -0.958657170165D+00 -0.957741028255D+00 -0.955452878353D+00\n', ' -0.951874625121D+00 -0.947083994787D+00 -0.941154750263D+00 -0.934156894630D+00\n', ' -0.926156863626D+00 -0.917217707805D+00 -0.907399264928D+00 -0.896758323153D+00\n', ' -0.885348775560D+00 -0.873221766467D+00 -0.860425830039D+00 -0.847007021587D+00\n', ' -0.833009041991D+00 -0.818473355609D+00 -0.803439302052D+00 -0.787944202144D+00\n', ' -0.772023458408D+00 -0.755710650358D+00 -0.739037624891D+00 -0.722034582045D+00\n', ' -0.704730156373D+00 -0.687151494166D+00 -0.669324326756D+00 -0.651273040100D+00\n', ' -0.633020740852D+00 -0.614589319101D+00 -0.595999507967D+00 -0.577270940196D+00\n', ' -0.558422201943D+00 -0.539470883862D+00 -0.520433629664D+00 -0.501326182266D+00\n', ' -0.482163427655D+00 -0.462959436593D+00 -0.443727504267D+00 -0.424480187992D+00\n', ' -0.405229343069D+00 -0.385986156892D+00 -0.366761181390D+00 -0.347564363890D+00\n', ' -0.347564363890D+00 -0.330057138148D+00 -0.313682152626D+00 -0.298093260983D+00\n', ' -0.283173370401D+00 -0.268856913569D+00 -0.255100360984D+00 -0.241871811683D+00\n', ' -0.229146262694D+00 -0.216903128162D+00 -0.205124810335D+00 -0.193795819972D+00\n', ' -0.182902207530D+00 -0.172431181099D+00 -0.162370841951D+00 -0.152709997006D+00\n', ' -0.143438023184D+00 -0.134544767629D+00 -0.126020473299D+00 -0.117855722784D+00\n', ' -0.110041395437D+00 -0.102568634352D+00 -0.954288206976D-01 -0.886135535959D-01\n', ' -0.821146342275D-01 -0.759240531543D-01 -0.700339801250D-01 -0.644367557932D-01\n', ' -0.591248849168D-01 -0.540910307059D-01 -0.493280100624D-01 -0.448287895118D-01\n', ' -0.405864816722D-01 -0.365943421386D-01 -0.328457666874D-01 -0.293342887278D-01\n', ' -0.260535769401D-01 -0.229974330573D-01 -0.201597897530D-01 -0.175347086082D-01\n', ' -0.151163781367D-01 -0.128991118507D-01 -0.108773463570D-01 -0.904563947108D-02\n', ' -0.739866834524D-02 -0.593122760428D-02 -0.463822748578D-02 -0.351469198292D-02\n', ' -0.255575698884D-02 -0.175666844166D-02 -0.111278047091D-02 -0.619553545292D-03\n', ' -0.272552623174D-03 -0.674453065838D-04 -0.112512836764D-13\n', '   43\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.268444513742D-01\n', ' -0.500548066307D-01 -0.699457900360D-01 -0.868078731501D-01 -0.100909115568D+00\n', ' -0.112496862702D+00 -0.121799312141D+00 -0.129026959167D+00 -0.134373931089D+00\n', ' -0.138019219277D+00 -0.140127817026D+00 -0.140851770688D+00 -0.140331150927D+00\n', ' -0.138694950372D+00 -0.136061913408D+00 -0.132541303434D+00 -0.128233612407D+00\n', ' -0.123231217174D+00 -0.117618986681D+00 -0.111474843842D+00 -0.104870285545D+00\n', ' -0.978708639919D-01 -0.905366323184D-01 -0.829225572075D-01 -0.750789009913D-01\n', ' -0.670515755483D-01 -0.588824701153D-01 -0.506097549736D-01 -0.422681628129D-01\n', ' -0.338892494404D-01 -0.255016353702D-01 -0.171312297148D-01 -0.880143768684D-02\n', ' -0.533352923024D-03  0.765406425161D-02  0.157438215857D-01  0.237207417339D-01\n', '  0.315713202766D-01  0.392835941091D-01  0.468470194448D-01  0.542523587328D-01\n', '  0.614915758422D-01  0.685577389142D-01  0.754449303262D-01  0.821481632554D-01\n', '  0.886633043631D-01  0.949870021620D-01  0.101116620654D+00  0.107050177862D+00\n', '  0.112786288906D+00  0.118324113288D+00  0.123663306099D+00  0.128803972858D+00\n', '  0.133746627717D+00  0.138492154809D+00  0.143041772497D+00  0.147397000323D+00\n', '  0.151559628473D+00  0.155531689558D+00  0.159315432565D+00  0.162913298813D+00\n', '  0.166327899774D+00  0.169561996620D+00  0.172618481381D+00  0.175500359595D+00\n', '  0.178210734336D+00  0.180752791535D+00  0.183129786488D+00  0.185345031472D+00\n', '  0.185345031472D+00  0.184931678626D+00  0.182571003170D+00  0.179102705992D+00\n', '  0.174861661976D+00  0.170054289762D+00  0.164825839363D+00  0.159285689158D+00\n', '  0.153519615050D+00  0.147596680139D+00  0.141573498882D+00  0.135497066883D+00\n', '  0.129406739952D+00  0.123335675859D+00  0.117311919408D+00  0.111359240949D+00\n', '  0.105497798650D+00  0.997446711754D-01  0.941142927526D-01  0.886188131823D-01\n', '  0.832683990877D-01  0.780714884291D-01  0.730350073337D-01  0.681645561664D-01\n', '  0.634645702171D-01  0.589384592422D-01  0.545887292324D-01  0.504170891306D-01\n', '  0.464245447124D-01  0.426114814506D-01  0.389777378725D-01  0.355226706676D-01\n', '  0.322452126076D-01  0.291439241729D-01  0.262170396519D-01  0.234625083646D-01\n', '  0.208780315749D-01  0.184610955785D-01  0.162090013874D-01  0.141188913829D-01\n', '  0.121877732559D-01  0.104125415219D-01  0.878999685767D-02  0.731686348191D-02\n', '  0.598980477569D-02  0.480543731577D-02  0.376034347671D-02  0.285108273952D-02\n', '  0.207420183130D-02  0.142624380619D-02  0.903756167956D-03  0.503298123378D-03\n', '  0.221447047829D-03  0.548042354075D-04  0.212654742276D-13\n', '   47\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.710237424182D-01\n', '  0.132432570268D+00  0.185059165691D+00  0.229672044198D+00  0.266980424813D+00\n', '  0.297638721984D+00  0.322250689785D+00  0.341373246380D+00  0.355520004351D+00\n', '  0.365164530355D+00  0.370743355613D+00  0.372658756962D+00  0.371281326549D+00\n', '  0.366952346784D+00  0.359985985786D+00  0.350671327331D+00  0.339274248149D+00\n', '  0.326039154403D+00  0.311190588218D+00  0.294934714247D+00  0.277460695473D+00\n', '  0.258941966722D+00  0.239537413656D+00  0.219392464448D+00  0.198640100731D+00\n', '  0.177401793916D+00  0.155788372506D+00  0.133900825574D+00  0.111831047179D+00\n', '  0.896625261379D-01  0.674709852150D-01  0.453249734781D-01  0.232864152992D-01\n', '  0.141111919535D-02 -0.202507505287D-01 -0.416542366014D-01 -0.627591835418D-01\n', ' -0.835298620138D-01 -0.103934620617D+00 -0.123945563116D+00 -0.143538249246D+00\n', ' -0.162691417404D+00 -0.181386727616D+00 -0.199608523324D+00 -0.217343610635D+00\n', ' -0.234581053762D+00 -0.251311985504D+00 -0.267529431666D+00 -0.283228148429D+00\n', ' -0.298404471743D+00 -0.313056177862D+00 -0.327182354243D+00 -0.340783280060D+00\n', ' -0.353860315633D+00 -0.366415800159D+00 -0.378452957120D+00 -0.389975806852D+00\n', ' -0.400989085737D+00 -0.411498171559D+00 -0.421509014581D+00 -0.431028073925D+00\n', ' -0.440062258894D+00 -0.448618874864D+00 -0.456705573429D+00 -0.464330306491D+00\n', ' -0.471501284016D+00 -0.478226935182D+00 -0.484515872695D+00 -0.490376860015D+00\n', ' -0.490376860015D+00 -0.489283231183D+00 -0.483037471001D+00 -0.473861219194D+00\n', ' -0.462640471428D+00 -0.449921360090D+00 -0.436088180592D+00 -0.421430320923D+00\n', ' -0.406174722792D+00 -0.390504109986D+00 -0.374568270278D+00 -0.358491542350D+00\n', ' -0.342378051888D+00 -0.326315526106D+00 -0.310378164577D+00 -0.294628857739D+00\n', ' -0.279120939092D+00 -0.263899594534D+00 -0.249003013440D+00 -0.234463341162D+00\n', ' -0.220307476057D+00 -0.206557742868D+00 -0.193232466407D+00 -0.180346463845D+00\n', ' -0.167911469858D+00 -0.155936505812D+00 -0.144428201936D+00 -0.133391079667D+00\n', ' -0.122827800038D+00 -0.112739382914D+00 -0.103125401078D+00 -0.939841524914D-01\n', ' -0.853128135320D-01 -0.771075755900D-01 -0.693637670313D-01 -0.620759622664D-01\n', ' -0.552380794118D-01 -0.488434678304D-01 -0.428849866719D-01 -0.373550753871D-01\n', ' -0.322458170709D-01 -0.275489953832D-01 -0.232561457104D-01 -0.193586011502D-01\n', ' -0.158475338383D-01 -0.127139920785D-01 -0.994893368355D-02 -0.754325589604D-02\n', ' -0.548782221457D-02 -0.377348642013D-02 -0.239111406624D-02 -0.133160166979D-02\n', ' -0.585893817112D-03 -0.144998377667D-03 -0.576892540902D-13\n', '   73\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.120919961757D+00\n', ' -0.214786820424D+00 -0.285128512040D+00 -0.335095657689D+00 -0.367499098133D+00\n', ' -0.384843759298D+00 -0.389359210512D+00 -0.383027240913D+00 -0.367606746704D+00\n', ' -0.344656192610D+00 -0.315553884595D+00 -0.281516267282D+00 -0.243614438314D+00\n', ' -0.202789052911D+00 -0.159863774732D+00 -0.115557413810D+00 -0.704948785238D-01\n', ' -0.252170561122D-01  0.198102749088D-01  0.641884071634D-01  0.107578457441D+00\n', '  0.149694834283D+00  0.190299351434D+00  0.229195925094D+00  0.266225798879D+00\n', '  0.301263245802D+00  0.334211701450D+00  0.365000286900D+00  0.393580683926D+00\n', '  0.419924328576D+00  0.444019892484D+00  0.465871024148D+00  0.485494325107D+00\n', '  0.502917538266D+00  0.518177927851D+00  0.531320832352D+00  0.542398373649D+00\n', '  0.551468307049D+00  0.558592998456D+00  0.563838516178D+00  0.567273826059D+00\n', '  0.568970079710D+00  0.568999986582D+00  0.567437261474D+00  0.564356139923D+00\n', '  0.559830954572D+00  0.553935766337D+00  0.546744044736D+00  0.538328392293D+00\n', '  0.528760308437D+00  0.518109988718D+00  0.506446155605D+00  0.493835917454D+00\n', '  0.480344652589D+00  0.466035915721D+00  0.450971364214D+00  0.435210701935D+00\n', '  0.418811638652D+00  0.401829863159D+00  0.384319028467D+00  0.366330747570D+00\n', '  0.347914598470D+00  0.329118137231D+00  0.309986918002D+00  0.290564519036D+00\n', '  0.270892573831D+00  0.251010806625D+00  0.230957071537D+00  0.210767394748D+00\n', '  0.210767394748D+00  0.194872722910D+00  0.181954147621D+00  0.170720796879D+00\n', '  0.160691324308D+00  0.151585755783D+00  0.143217785841D+00  0.135454581775D+00\n', '  0.128197437948D+00  0.121371007313D+00  0.114916705224D+00  0.108788385526D+00\n', '  0.102949360099D+00  0.973702639649D-01  0.920274795158D-01  0.869019453892D-01\n', '  0.819782387537D-01  0.772438572460D-01  0.726886500433D-01  0.683043625011D-01\n', '  0.640842686815D-01  0.600228728605D-01  0.561156658172D-01  0.523589250768D-01\n', '  0.487495507301D-01  0.452849302651D-01  0.419628272086D-01  0.387812894162D-01\n', '  0.357385736489D-01  0.328330837010D-01  0.300633198412D-01  0.274278377140D-01\n', '  0.249252151739D-01  0.225540257744D-01  0.203128178425D-01  0.182000982443D-01\n', '  0.162143200854D-01  0.143538737057D-01  0.126170804319D-01  0.110021886245D-01\n', '  0.950737163371D-02  0.813072732961D-02  0.687027892533D-02  0.572397685272D-02\n', '  0.468970148569D-02  0.376526653556D-02  0.294842297179D-02  0.223686334081D-02\n', '  0.162822637464D-02  0.112010180264D-02  0.710035283844D-03  0.395533403271D-03\n', '  0.174068670187D-03  0.430844801113D-04 -0.125071680895D-12\n', '   77\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.643071732209D-01\n', ' -0.114227072733D+00 -0.151635911453D+00 -0.178209240157D+00 -0.195441909001D+00\n', ' -0.204666077730D+00 -0.207067467039D+00 -0.203700024146D+00 -0.195499158236D+00\n', ' -0.183293685821D+00 -0.167816612099D+00 -0.149714861810D+00 -0.129558061846D+00\n', ' -0.107846467724D+00 -0.850181169764D-01 -0.614552842961D-01 -0.374903059721D-01\n', ' -0.134108345054D-01  0.105354216260D-01  0.341364234511D-01  0.572119474482D-01\n', '  0.796101115036D-01  0.101204244350D+00  0.121890065481D+00  0.141583145707D+00\n', '  0.160216621403D+00  0.177739138065D+00  0.194113001148D+00  0.209312514243D+00\n', '  0.223322486585D+00  0.236136893566D+00  0.247757675516D+00  0.258193661399D+00\n', '  0.267459605338D+00  0.275575325044D+00  0.282564932253D+00  0.288456146215D+00\n', '  0.293279682129D+00  0.297068707182D+00  0.299858357558D+00  0.301685310398D+00\n', '  0.302587405270D+00  0.302603310223D+00  0.301772227971D+00  0.300133638159D+00\n', '  0.297727072080D+00  0.294591916516D+00  0.290767243732D+00  0.286291664915D+00\n', '  0.281203204606D+00  0.275539193924D+00  0.269336180580D+00  0.262629853871D+00\n', '  0.255454983039D+00  0.247845367497D+00  0.239833797619D+00  0.231452024878D+00\n', '  0.222730740254D+00  0.213699559940D+00  0.204387017466D+00  0.194820561451D+00\n', '  0.185026558269D+00  0.175030298997D+00  0.164856010062D+00  0.154526867078D+00\n', '  0.144065011405D+00  0.133491569030D+00  0.122826671379D+00  0.112089477754D+00\n', '  0.112089477754D+00  0.103636436582D+00  0.967661312431D-01  0.907920553210D-01\n', '  0.854582211008D-01  0.806157338563D-01  0.761655133573D-01  0.720369170416D-01\n', '  0.681774516694D-01  0.645470464748D-01  0.611145452033D-01  0.578554065912D-01\n', '  0.547501193073D-01  0.517830665868D-01  0.489416882068D-01  0.462158470294D-01\n', '  0.435973409458D-01  0.410795209987D-01  0.386569888181D-01  0.363253544515D-01\n', '  0.340810409377D-01  0.319211255624D-01  0.298432102497D-01  0.278453153280D-01\n', '  0.259257922156D-01  0.240832515371D-01  0.223165039000D-01  0.206245111227D-01\n', '  0.190063461227D-01  0.174611600124D-01  0.159881552105D-01  0.145865635856D-01\n', '  0.132556288181D-01  0.119945923008D-01  0.108026820106D-01  0.967910387520D-02\n', '  0.862303523121D-02  0.763362003566D-02  0.670996554319D-02  0.585114020384D-02\n', '  0.505617257596D-02  0.432405107641D-02  0.365372441826D-02  0.304410260828D-02\n', '  0.249405839542D-02  0.200242907626D-02  0.156801858040D-02  0.118959976698D-02\n', '  0.865916875895D-03  0.595688086562D-03  0.377608141186D-03  0.210351001681D-03\n', '  0.925725079864D-04  0.229130169002D-04 -0.594900858547D-13\n', '   81\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.979799203734D-01\n', ' -0.174039052415D+00 -0.231036038218D+00 -0.271523786318D+00 -0.297779885546D+00\n', ' -0.311834045795D+00 -0.315492858980D+00 -0.310362143852D+00 -0.297867111826D+00\n', ' -0.279270567219D+00 -0.255689333976D+00 -0.228109081836D+00 -0.197397707714D+00\n', ' -0.164317412676D+00 -0.129535600998D+00 -0.936347153865D-01 -0.571211112219D-01\n', ' -0.204330626145D-01  0.160520159776D-01  0.520110569948D-01  0.871694676443D-01\n', '  0.121295836768D+00  0.154197165048D+00  0.185714568251D+00  0.215719408081D+00\n', '  0.244109809548D+00  0.270807527723D+00  0.295755130311D+00  0.318913465661D+00\n', '  0.340259388763D+00  0.359783720384D+00  0.377489416858D+00  0.393389930201D+00\n', '  0.407507740141D+00  0.419873041409D+00  0.430522571212D+00  0.439498563251D+00\n', '  0.446847815925D+00  0.452620863540D+00  0.456871240411D+00  0.459654828693D+00\n', '  0.461029281639D+00  0.461053514800D+00  0.459787258350D+00  0.457290664405D+00\n', '  0.453623963772D+00  0.448847167075D+00  0.443019805740D+00  0.436200708676D+00\n', '  0.428447810968D+00  0.419817991186D+00  0.410366934280D+00  0.400149017304D+00\n', '  0.389217215491D+00  0.377623026420D+00  0.365416410278D+00  0.352645744354D+00\n', '  0.339357790146D+00  0.325597671582D+00  0.311408863019D+00  0.296833185816D+00\n', '  0.281910812404D+00  0.266680276860D+00  0.251178491138D+00  0.235440766146D+00\n', '  0.219500836983D+00  0.203390891699D+00  0.187141603008D+00  0.170782162470D+00\n', '  0.170782162470D+00  0.157902910290D+00  0.147435151619D+00  0.138332909150D+00\n', '  0.130206153984D+00  0.122828026618D+00  0.116047566083D+00  0.109757139712D+00\n', '  0.103876767571D+00  0.983453969002D-01  0.931155572972D-01  0.881498571163D-01\n', '  0.834185684345D-01  0.788978971823D-01  0.745687063085D-01  0.704155506318D-01\n', '  0.664259332265D-01  0.625897235849D-01  0.588986966237D-01  0.553461637082D-01\n', '  0.519266748958D-01  0.486357770709D-01  0.454698164684D-01  0.424257768139D-01\n', '  0.395011462901D-01  0.366938080115D-01  0.340019497921D-01  0.314239898339D-01\n', '  0.289585156121D-01  0.266042337418D-01  0.243599290092D-01  0.222244310713D-01\n', '  0.201965875819D-01  0.182752427090D-01  0.164592201804D-01  0.147473101285D-01\n', '  0.131382591244D-01  0.116307628806D-01  0.102234611895D-01  0.891493471958D-02\n', '  0.770370335957D-02  0.658822583760D-02  0.556690038820D-02  0.463806627207D-02\n', '  0.380000598301D-02  0.305094799877D-02  0.238906995839D-02  0.181250216122D-02\n', '  0.131933130164D-02  0.907604367683D-03  0.575332637913D-03  0.320495729523D-03\n', '  0.141045648670D-03  0.349108110181D-04 -0.908372818246D-13\n', '    3  135 NPAN,MESHN;  Shape number     1;     # serial: voro_v1.0-16-g2d2b8f1_serial_20180516213647\n', '   10   70   55\n', '  0.495000000000D+00  0.555555555556D-03  0.495555555556D+00  0.555555555556D-03\n', '  0.496111111111D+00  0.555555555556D-03  0.496666666667D+00  0.555555555556D-03\n', '  0.497222222222D+00  0.555555555556D-03  0.497777777778D+00  0.555555555556D-03\n', '  0.498333333333D+00  0.555555555556D-03  0.498888888889D+00  0.555555555556D-03\n', '  0.499444444444D+00  0.555555555556D-03  0.500000000000D+00  0.555555555556D-03\n', '  0.500000000000D+00  0.300154755343D-02  0.503001547553D+00  0.300154755343D-02\n', '  0.506003095107D+00  0.300154755343D-02  0.509004642660D+00  0.300154755343D-02\n', '  0.512006190214D+00  0.300154755343D-02  0.515007737767D+00  0.300154755343D-02\n', '  0.518009285321D+00  0.300154755343D-02  0.521010832874D+00  0.300154755343D-02\n', '  0.524012380427D+00  0.300154755343D-02  0.527013927981D+00  0.300154755343D-02\n', '  0.530015475534D+00  0.300154755343D-02  0.533017023088D+00  0.300154755343D-02\n', '  0.536018570641D+00  0.300154755343D-02  0.539020118195D+00  0.300154755343D-02\n', '  0.542021665748D+00  0.300154755343D-02  0.545023213301D+00  0.300154755343D-02\n', '  0.548024760855D+00  0.300154755343D-02  0.551026308408D+00  0.300154755343D-02\n', '  0.554027855962D+00  0.300154755343D-02  0.557029403515D+00  0.300154755343D-02\n', '  0.560030951069D+00  0.300154755343D-02  0.563032498622D+00  0.300154755343D-02\n', '  0.566034046175D+00  0.300154755343D-02  0.569035593729D+00  0.300154755343D-02\n', '  0.572037141282D+00  0.300154755343D-02  0.575038688836D+00  0.300154755343D-02\n', '  0.578040236389D+00  0.300154755343D-02  0.581041783943D+00  0.300154755343D-02\n', '  0.584043331496D+00  0.300154755343D-02  0.587044879049D+00  0.300154755343D-02\n', '  0.590046426603D+00  0.300154755343D-02  0.593047974156D+00  0.300154755343D-02\n', '  0.596049521710D+00  0.300154755343D-02  0.599051069263D+00  0.300154755343D-02\n', '  0.602052616817D+00  0.300154755343D-02  0.605054164370D+00  0.300154755343D-02\n', '  0.608055711923D+00  0.300154755343D-02  0.611057259477D+00  0.300154755343D-02\n', '  0.614058807030D+00  0.300154755343D-02  0.617060354584D+00  0.300154755343D-02\n', '  0.620061902137D+00  0.300154755343D-02  0.623063449691D+00  0.300154755343D-02\n', '  0.626064997244D+00  0.300154755343D-02  0.629066544797D+00  0.300154755343D-02\n', '  0.632068092351D+00  0.300154755343D-02  0.635069639904D+00  0.300154755343D-02\n', '  0.638071187458D+00  0.300154755343D-02  0.641072735011D+00  0.300154755343D-02\n', '  0.644074282565D+00  0.300154755343D-02  0.647075830118D+00  0.300154755343D-02\n', '  0.650077377671D+00  0.300154755343D-02  0.653078925225D+00  0.300154755343D-02\n', '  0.656080472778D+00  0.300154755343D-02  0.659082020332D+00  0.300154755343D-02\n', '  0.662083567885D+00  0.300154755343D-02  0.665085115439D+00  0.300154755343D-02\n', '  0.668086662992D+00  0.300154755343D-02  0.671088210545D+00  0.300154755343D-02\n', '  0.674089758099D+00  0.300154755343D-02  0.677091305652D+00  0.300154755343D-02\n', '  0.680092853206D+00  0.300154755343D-02  0.683094400759D+00  0.300154755343D-02\n', '  0.686095948313D+00  0.300154755343D-02  0.689097495866D+00  0.300154755343D-02\n', '  0.692099043419D+00  0.300154755343D-02  0.695100590973D+00  0.300154755343D-02\n', '  0.698102138526D+00  0.300154755343D-02  0.701103686080D+00  0.300154755343D-02\n', '  0.704105233633D+00  0.300154755343D-02  0.707106781187D+00  0.300154755343D-02\n', '  0.707106781187D+00  0.294293745552D-02  0.710049718642D+00  0.294293745552D-02\n', '  0.712992656098D+00  0.294293745552D-02  0.715935593553D+00  0.294293745552D-02\n', '  0.718878531009D+00  0.294293745552D-02  0.721821468464D+00  0.294293745552D-02\n', '  0.724764405920D+00  0.294293745552D-02  0.727707343375D+00  0.294293745552D-02\n', '  0.730650280831D+00  0.294293745552D-02  0.733593218286D+00  0.294293745552D-02\n', '  0.736536155742D+00  0.294293745552D-02  0.739479093197D+00  0.294293745552D-02\n', '  0.742422030653D+00  0.294293745552D-02  0.745364968108D+00  0.294293745552D-02\n', '  0.748307905564D+00  0.294293745552D-02  0.751250843019D+00  0.294293745552D-02\n', '  0.754193780475D+00  0.294293745552D-02  0.757136717930D+00  0.294293745552D-02\n', '  0.760079655386D+00  0.294293745552D-02  0.763022592841D+00  0.294293745552D-02\n', '  0.765965530297D+00  0.294293745552D-02  0.768908467752D+00  0.294293745552D-02\n', '  0.771851405208D+00  0.294293745552D-02  0.774794342663D+00  0.294293745552D-02\n', '  0.777737280119D+00  0.294293745552D-02  0.780680217574D+00  0.294293745552D-02\n', '  0.783623155030D+00  0.294293745552D-02  0.786566092485D+00  0.294293745552D-02\n', '  0.789509029941D+00  0.294293745552D-02  0.792451967397D+00  0.294293745552D-02\n', '  0.795394904852D+00  0.294293745552D-02  0.798337842308D+00  0.294293745552D-02\n', '  0.801280779763D+00  0.294293745552D-02  0.804223717219D+00  0.294293745552D-02\n', '  0.807166654674D+00  0.294293745552D-02  0.810109592130D+00  0.294293745552D-02\n', '  0.813052529585D+00  0.294293745552D-02  0.815995467041D+00  0.294293745552D-02\n', '  0.818938404496D+00  0.294293745552D-02  0.821881341952D+00  0.294293745552D-02\n', '  0.824824279407D+00  0.294293745552D-02  0.827767216863D+00  0.294293745552D-02\n', '  0.830710154318D+00  0.294293745552D-02  0.833653091774D+00  0.294293745552D-02\n', '  0.836596029229D+00  0.294293745552D-02  0.839538966685D+00  0.294293745552D-02\n', '  0.842481904140D+00  0.294293745552D-02  0.845424841596D+00  0.294293745552D-02\n', '  0.848367779051D+00  0.294293745552D-02  0.851310716507D+00  0.294293745552D-02\n', '  0.854253653962D+00  0.294293745552D-02  0.857196591418D+00  0.294293745552D-02\n', '  0.860139528873D+00  0.294293745552D-02  0.863082466329D+00  0.294293745552D-02\n', '  0.866025403784D+00  0.294293745552D-02\n', '    8\n', '    1\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.348144740577D+01\n', '  0.341873998692D+01  0.335677212636D+01  0.329553081748D+01  0.323500335691D+01\n', '  0.317517733570D+01  0.311604063086D+01  0.305758139715D+01  0.299978805921D+01\n', '  0.294264930386D+01  0.288615407276D+01  0.283029155528D+01  0.277505118156D+01\n', '  0.272042261588D+01  0.266639575022D+01  0.261296069799D+01  0.256010778802D+01\n', '  0.250782755873D+01  0.245611075245D+01  0.240494831001D+01  0.235433136540D+01\n', '  0.230425124068D+01  0.225469944100D+01  0.220566764980D+01  0.215714772417D+01\n', '  0.210913169033D+01  0.206161173925D+01  0.201458022246D+01  0.196802964790D+01\n', '  0.192195267594D+01  0.187634211556D+01  0.183119092059D+01  0.178649218608D+01\n', '  0.174223914475D+01  0.169842516366D+01  0.165504374078D+01  0.161208850186D+01\n', '  0.156955319730D+01  0.152743169906D+01  0.148571799778D+01  0.144440619990D+01\n', '  0.140349052487D+01  0.136296530248D+01  0.132282497020D+01  0.128306407070D+01\n', '  0.124367724929D+01  0.120465925162D+01  0.116600492124D+01  0.112770919739D+01\n', '  0.108976711279D+01  0.105217379146D+01  0.101492444666D+01  0.978014378839D+00\n', '  0.941438973679D+00  0.905193700153D+00  0.869274108662D+00  0.833675829215D+00\n', '  0.798394569651D+00  0.763426113922D+00  0.728766320407D+00  0.694411120278D+00\n', '  0.660356515910D+00  0.626598579329D+00  0.593133450700D+00  0.559957336859D+00\n', '  0.527066509878D+00  0.494457305668D+00  0.462126122617D+00  0.430069420271D+00\n', '  0.430069420271D+00  0.402303316540D+00  0.377539313460D+00  0.354743340664D+00\n', '  0.333530457006D+00  0.313670769379D+00  0.295004615108D+00  0.277411710302D+00\n', '  0.260796664908D+00  0.245081108278D+00  0.230198970219D+00  0.216093447552D+00\n', '  0.202714947697D+00  0.190019635093D+00  0.177968368454D+00  0.166525901810D+00\n', '  0.155660269630D+00  0.145342304080D+00  0.135545249448D+00  0.126244449527D+00\n', '  0.117417090804D+00  0.109041989005D+00  0.101099409844D+00  0.935709170764D-01\n', '  0.864392426117D-01  0.796881746491D-01  0.733024606555D-01  0.672677226928D-01\n', '  0.615703830911D-01  0.561975988595D-01  0.511372035220D-01  0.463776553057D-01\n', '  0.419079907936D-01  0.377177833043D-01  0.337971053812D-01  0.301364948711D-01\n', '  0.267269241521D-01  0.235597721351D-01  0.206267987196D-01  0.179201214265D-01\n', '  0.154321939709D-01  0.131557865685D-01  0.110839677947D-01  0.921008784091D-02\n', '  0.752776303004D-02  0.603086146903D-02  0.471348973284D-02  0.356998048451D-02\n', '  0.259488094746D-02  0.178294215513D-02  0.112910891116D-02  0.628510400363D-03\n', '  0.276451396771D-03  0.684040205092D-04  0.457411886146D-13\n', '   21\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.107771580765D+00\n', ' -0.207927768303D+00 -0.300879928222D+00 -0.387017301583D+00 -0.466708260187D+00\n', ' -0.540301485561D+00 -0.608127076621D+00 -0.670497590656D+00 -0.727709021934D+00\n', ' -0.780041721948D+00 -0.827761265034D+00 -0.871119262839D+00 -0.910354130889D+00\n', ' -0.945691810260D+00 -0.977346447194D+00 -0.100552103326D+01 -0.103040800855D+01\n', ' -0.105218983014D+01 -0.107103950802D+01 -0.108712111043D+01 -0.110059024054D+01\n', ' -0.111159448612D+01 -0.112027384388D+01 -0.112676112010D+01 -0.113118230872D+01\n', ' -0.113365694857D+01 -0.113429846067D+01 -0.113321446694D+01 -0.113050709147D+01\n', ' -0.112627324514D+01 -0.112060489489D+01 -0.111358931816D+01 -0.110530934371D+01\n', ' -0.109584357938D+01 -0.108526662757D+01 -0.107364928929D+01 -0.106105875719D+01\n', ' -0.104755879842D+01 -0.103320992775D+01 -0.101806957159D+01 -0.100219222331D+01\n', ' -0.985629590493D+00 -0.968430734425D+00 -0.950642202363D+00 -0.932308152903D+00\n', ' -0.913470474873D+00 -0.894168900091D+00 -0.874441110314D+00 -0.854322838707D+00\n', ' -0.833847966132D+00 -0.813048612513D+00 -0.791955223572D+00 -0.770596653163D+00\n', ' -0.749000241447D+00 -0.727191889129D+00 -0.705196127964D+00 -0.683036187733D+00\n', ' -0.660734059870D+00 -0.638310557917D+00 -0.615785374981D+00 -0.593177138329D+00\n', ' -0.570503461300D+00 -0.547780992645D+00 -0.525025463440D+00 -0.502251731701D+00\n', ' -0.479473824810D+00 -0.456704979869D+00 -0.433957682089D+00 -0.411243701307D+00\n', ' -0.411243701307D+00 -0.390528872452D+00 -0.371153728294D+00 -0.352708702956D+00\n', ' -0.335055250348D+00 -0.318115790182D+00 -0.301838817656D+00 -0.286186587040D+00\n', ' -0.271129514420D+00 -0.256643242282D+00 -0.242706948687D+00 -0.229302306517D+00\n', ' -0.216412810451D+00 -0.204023324895D+00 -0.192119771086D+00 -0.180688905193D+00\n', ' -0.169718157817D+00 -0.159195515938D+00 -0.149109434868D+00 -0.139448771777D+00\n', ' -0.130202734970D+00 -0.121360844815D+00 -0.112912903371D+00 -0.104848970587D+00\n', ' -0.971593454900D-01 -0.898345511834D-01 -0.828653227895D-01 -0.762425976473D-01\n', ' -0.699575072669D-01 -0.640013706413D-01 -0.583656886141D-01 -0.530421390663D-01\n', ' -0.480225727376D-01 -0.432990095404D-01 -0.388636352520D-01 -0.347087984988D-01\n', ' -0.308270079625D-01 -0.272109297547D-01 -0.238533849179D-01 -0.207473470199D-01\n', ' -0.178859398176D-01 -0.152624349680D-01 -0.128702497753D-01 -0.107029449600D-01\n', ' -0.875422244382D-02 -0.701792314373D-02 -0.548802477161D-02 -0.415863963680D-02\n', ' -0.302401245044D-02 -0.207851813067D-02 -0.131665960939D-02 -0.733065640768D-03\n', ' -0.322488612760D-03 -0.798023629498D-04 -0.130951788091D-13\n', '   25\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.910836100221D-01\n', ' -0.175731038058D+00 -0.254289951499D+00 -0.327089319087D+00 -0.394440471814D+00\n', ' -0.456638099358D+00 -0.513961186222D+00 -0.566673891528D+00 -0.615026376092D+00\n', ' -0.659255580170D+00 -0.699585955043D+00 -0.736230151364D+00 -0.769389667030D+00\n', ' -0.799255457103D+00 -0.826008508190D+00 -0.849820379482D+00 -0.870853712536D+00\n', ' -0.889262711727D+00 -0.905193597184D+00 -0.918785031886D+00 -0.930168524507D+00\n', ' -0.939468809474D+00 -0.946804205618D+00 -0.952286954712D+00 -0.956023541090D+00\n', ' -0.958114993490D+00 -0.958657170165D+00 -0.957741028255D+00 -0.955452878353D+00\n', ' -0.951874625121D+00 -0.947083994787D+00 -0.941154750263D+00 -0.934156894630D+00\n', ' -0.926156863626D+00 -0.917217707805D+00 -0.907399264928D+00 -0.896758323153D+00\n', ' -0.885348775560D+00 -0.873221766467D+00 -0.860425830039D+00 -0.847007021587D+00\n', ' -0.833009041991D+00 -0.818473355609D+00 -0.803439302052D+00 -0.787944202144D+00\n', ' -0.772023458408D+00 -0.755710650358D+00 -0.739037624891D+00 -0.722034582045D+00\n', ' -0.704730156373D+00 -0.687151494166D+00 -0.669324326756D+00 -0.651273040100D+00\n', ' -0.633020740852D+00 -0.614589319101D+00 -0.595999507967D+00 -0.577270940196D+00\n', ' -0.558422201943D+00 -0.539470883862D+00 -0.520433629664D+00 -0.501326182266D+00\n', ' -0.482163427655D+00 -0.462959436593D+00 -0.443727504267D+00 -0.424480187992D+00\n', ' -0.405229343069D+00 -0.385986156892D+00 -0.366761181390D+00 -0.347564363890D+00\n', ' -0.347564363890D+00 -0.330057138148D+00 -0.313682152626D+00 -0.298093260983D+00\n', ' -0.283173370401D+00 -0.268856913569D+00 -0.255100360984D+00 -0.241871811683D+00\n', ' -0.229146262694D+00 -0.216903128162D+00 -0.205124810335D+00 -0.193795819972D+00\n', ' -0.182902207530D+00 -0.172431181099D+00 -0.162370841951D+00 -0.152709997006D+00\n', ' -0.143438023184D+00 -0.134544767629D+00 -0.126020473299D+00 -0.117855722784D+00\n', ' -0.110041395437D+00 -0.102568634352D+00 -0.954288206976D-01 -0.886135535959D-01\n', ' -0.821146342275D-01 -0.759240531543D-01 -0.700339801250D-01 -0.644367557932D-01\n', ' -0.591248849168D-01 -0.540910307059D-01 -0.493280100624D-01 -0.448287895118D-01\n', ' -0.405864816722D-01 -0.365943421386D-01 -0.328457666874D-01 -0.293342887278D-01\n', ' -0.260535769401D-01 -0.229974330573D-01 -0.201597897530D-01 -0.175347086082D-01\n', ' -0.151163781367D-01 -0.128991118507D-01 -0.108773463570D-01 -0.904563947108D-02\n', ' -0.739866834524D-02 -0.593122760428D-02 -0.463822748578D-02 -0.351469198292D-02\n', ' -0.255575698884D-02 -0.175666844166D-02 -0.111278047091D-02 -0.619553545292D-03\n', ' -0.272552623174D-03 -0.674453065838D-04 -0.112512836764D-13\n', '   43\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.268444513742D-01\n', ' -0.500548066307D-01 -0.699457900360D-01 -0.868078731501D-01 -0.100909115568D+00\n', ' -0.112496862702D+00 -0.121799312141D+00 -0.129026959167D+00 -0.134373931089D+00\n', ' -0.138019219277D+00 -0.140127817026D+00 -0.140851770688D+00 -0.140331150927D+00\n', ' -0.138694950372D+00 -0.136061913408D+00 -0.132541303434D+00 -0.128233612407D+00\n', ' -0.123231217174D+00 -0.117618986681D+00 -0.111474843842D+00 -0.104870285545D+00\n', ' -0.978708639919D-01 -0.905366323184D-01 -0.829225572075D-01 -0.750789009913D-01\n', ' -0.670515755483D-01 -0.588824701153D-01 -0.506097549736D-01 -0.422681628129D-01\n', ' -0.338892494404D-01 -0.255016353702D-01 -0.171312297148D-01 -0.880143768684D-02\n', ' -0.533352923024D-03  0.765406425161D-02  0.157438215857D-01  0.237207417339D-01\n', '  0.315713202766D-01  0.392835941091D-01  0.468470194448D-01  0.542523587328D-01\n', '  0.614915758422D-01  0.685577389142D-01  0.754449303262D-01  0.821481632554D-01\n', '  0.886633043631D-01  0.949870021620D-01  0.101116620654D+00  0.107050177862D+00\n', '  0.112786288906D+00  0.118324113288D+00  0.123663306099D+00  0.128803972858D+00\n', '  0.133746627717D+00  0.138492154809D+00  0.143041772497D+00  0.147397000323D+00\n', '  0.151559628473D+00  0.155531689558D+00  0.159315432565D+00  0.162913298813D+00\n', '  0.166327899774D+00  0.169561996620D+00  0.172618481381D+00  0.175500359595D+00\n', '  0.178210734336D+00  0.180752791535D+00  0.183129786488D+00  0.185345031472D+00\n', '  0.185345031472D+00  0.184931678626D+00  0.182571003170D+00  0.179102705992D+00\n', '  0.174861661976D+00  0.170054289762D+00  0.164825839363D+00  0.159285689158D+00\n', '  0.153519615050D+00  0.147596680139D+00  0.141573498882D+00  0.135497066883D+00\n', '  0.129406739952D+00  0.123335675859D+00  0.117311919408D+00  0.111359240949D+00\n', '  0.105497798650D+00  0.997446711754D-01  0.941142927526D-01  0.886188131823D-01\n', '  0.832683990877D-01  0.780714884291D-01  0.730350073337D-01  0.681645561664D-01\n', '  0.634645702171D-01  0.589384592422D-01  0.545887292324D-01  0.504170891306D-01\n', '  0.464245447124D-01  0.426114814506D-01  0.389777378725D-01  0.355226706676D-01\n', '  0.322452126076D-01  0.291439241729D-01  0.262170396519D-01  0.234625083646D-01\n', '  0.208780315749D-01  0.184610955785D-01  0.162090013874D-01  0.141188913829D-01\n', '  0.121877732559D-01  0.104125415219D-01  0.878999685767D-02  0.731686348191D-02\n', '  0.598980477569D-02  0.480543731577D-02  0.376034347671D-02  0.285108273952D-02\n', '  0.207420183130D-02  0.142624380619D-02  0.903756167956D-03  0.503298123378D-03\n', '  0.221447047829D-03  0.548042354075D-04  0.212654742276D-13\n', '   47\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.710237424182D-01\n', '  0.132432570268D+00  0.185059165691D+00  0.229672044198D+00  0.266980424813D+00\n', '  0.297638721984D+00  0.322250689785D+00  0.341373246380D+00  0.355520004351D+00\n', '  0.365164530355D+00  0.370743355613D+00  0.372658756962D+00  0.371281326549D+00\n', '  0.366952346784D+00  0.359985985786D+00  0.350671327331D+00  0.339274248149D+00\n', '  0.326039154403D+00  0.311190588218D+00  0.294934714247D+00  0.277460695473D+00\n', '  0.258941966722D+00  0.239537413656D+00  0.219392464448D+00  0.198640100731D+00\n', '  0.177401793916D+00  0.155788372506D+00  0.133900825574D+00  0.111831047179D+00\n', '  0.896625261379D-01  0.674709852150D-01  0.453249734781D-01  0.232864152992D-01\n', '  0.141111919535D-02 -0.202507505287D-01 -0.416542366014D-01 -0.627591835418D-01\n', ' -0.835298620138D-01 -0.103934620617D+00 -0.123945563116D+00 -0.143538249246D+00\n', ' -0.162691417404D+00 -0.181386727616D+00 -0.199608523324D+00 -0.217343610635D+00\n', ' -0.234581053762D+00 -0.251311985504D+00 -0.267529431666D+00 -0.283228148429D+00\n', ' -0.298404471743D+00 -0.313056177862D+00 -0.327182354243D+00 -0.340783280060D+00\n', ' -0.353860315633D+00 -0.366415800159D+00 -0.378452957120D+00 -0.389975806852D+00\n', ' -0.400989085737D+00 -0.411498171559D+00 -0.421509014581D+00 -0.431028073925D+00\n', ' -0.440062258894D+00 -0.448618874864D+00 -0.456705573429D+00 -0.464330306491D+00\n', ' -0.471501284016D+00 -0.478226935182D+00 -0.484515872695D+00 -0.490376860015D+00\n', ' -0.490376860015D+00 -0.489283231183D+00 -0.483037471001D+00 -0.473861219194D+00\n', ' -0.462640471428D+00 -0.449921360090D+00 -0.436088180592D+00 -0.421430320923D+00\n', ' -0.406174722792D+00 -0.390504109986D+00 -0.374568270278D+00 -0.358491542350D+00\n', ' -0.342378051888D+00 -0.326315526106D+00 -0.310378164577D+00 -0.294628857739D+00\n', ' -0.279120939092D+00 -0.263899594534D+00 -0.249003013440D+00 -0.234463341162D+00\n', ' -0.220307476057D+00 -0.206557742868D+00 -0.193232466407D+00 -0.180346463845D+00\n', ' -0.167911469858D+00 -0.155936505812D+00 -0.144428201936D+00 -0.133391079667D+00\n', ' -0.122827800038D+00 -0.112739382914D+00 -0.103125401078D+00 -0.939841524914D-01\n', ' -0.853128135320D-01 -0.771075755900D-01 -0.693637670313D-01 -0.620759622664D-01\n', ' -0.552380794118D-01 -0.488434678304D-01 -0.428849866719D-01 -0.373550753871D-01\n', ' -0.322458170709D-01 -0.275489953832D-01 -0.232561457104D-01 -0.193586011502D-01\n', ' -0.158475338383D-01 -0.127139920785D-01 -0.994893368355D-02 -0.754325589604D-02\n', ' -0.548782221457D-02 -0.377348642013D-02 -0.239111406624D-02 -0.133160166979D-02\n', ' -0.585893817112D-03 -0.144998377667D-03 -0.576892540902D-13\n', '   73\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.120919961757D+00\n', ' -0.214786820424D+00 -0.285128512040D+00 -0.335095657689D+00 -0.367499098133D+00\n', ' -0.384843759298D+00 -0.389359210512D+00 -0.383027240913D+00 -0.367606746704D+00\n', ' -0.344656192610D+00 -0.315553884595D+00 -0.281516267282D+00 -0.243614438314D+00\n', ' -0.202789052911D+00 -0.159863774732D+00 -0.115557413810D+00 -0.704948785238D-01\n', ' -0.252170561122D-01  0.198102749088D-01  0.641884071634D-01  0.107578457441D+00\n', '  0.149694834283D+00  0.190299351434D+00  0.229195925094D+00  0.266225798879D+00\n', '  0.301263245802D+00  0.334211701450D+00  0.365000286900D+00  0.393580683926D+00\n', '  0.419924328576D+00  0.444019892484D+00  0.465871024148D+00  0.485494325107D+00\n', '  0.502917538266D+00  0.518177927851D+00  0.531320832352D+00  0.542398373649D+00\n', '  0.551468307049D+00  0.558592998456D+00  0.563838516178D+00  0.567273826059D+00\n', '  0.568970079710D+00  0.568999986582D+00  0.567437261474D+00  0.564356139923D+00\n', '  0.559830954572D+00  0.553935766337D+00  0.546744044736D+00  0.538328392293D+00\n', '  0.528760308437D+00  0.518109988718D+00  0.506446155605D+00  0.493835917454D+00\n', '  0.480344652589D+00  0.466035915721D+00  0.450971364214D+00  0.435210701935D+00\n', '  0.418811638652D+00  0.401829863159D+00  0.384319028467D+00  0.366330747570D+00\n', '  0.347914598470D+00  0.329118137231D+00  0.309986918002D+00  0.290564519036D+00\n', '  0.270892573831D+00  0.251010806625D+00  0.230957071537D+00  0.210767394748D+00\n', '  0.210767394748D+00  0.194872722910D+00  0.181954147621D+00  0.170720796879D+00\n', '  0.160691324308D+00  0.151585755783D+00  0.143217785841D+00  0.135454581775D+00\n', '  0.128197437948D+00  0.121371007313D+00  0.114916705224D+00  0.108788385526D+00\n', '  0.102949360099D+00  0.973702639649D-01  0.920274795158D-01  0.869019453892D-01\n', '  0.819782387537D-01  0.772438572460D-01  0.726886500433D-01  0.683043625011D-01\n', '  0.640842686815D-01  0.600228728605D-01  0.561156658172D-01  0.523589250768D-01\n', '  0.487495507301D-01  0.452849302651D-01  0.419628272086D-01  0.387812894162D-01\n', '  0.357385736489D-01  0.328330837010D-01  0.300633198412D-01  0.274278377140D-01\n', '  0.249252151739D-01  0.225540257744D-01  0.203128178425D-01  0.182000982443D-01\n', '  0.162143200854D-01  0.143538737057D-01  0.126170804319D-01  0.110021886245D-01\n', '  0.950737163371D-02  0.813072732961D-02  0.687027892533D-02  0.572397685272D-02\n', '  0.468970148569D-02  0.376526653556D-02  0.294842297179D-02  0.223686334081D-02\n', '  0.162822637464D-02  0.112010180264D-02  0.710035283844D-03  0.395533403271D-03\n', '  0.174068670187D-03  0.430844801113D-04 -0.125071680895D-12\n', '   77\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.643071732209D-01\n', ' -0.114227072733D+00 -0.151635911453D+00 -0.178209240157D+00 -0.195441909001D+00\n', ' -0.204666077730D+00 -0.207067467039D+00 -0.203700024146D+00 -0.195499158236D+00\n', ' -0.183293685821D+00 -0.167816612099D+00 -0.149714861810D+00 -0.129558061846D+00\n', ' -0.107846467724D+00 -0.850181169764D-01 -0.614552842961D-01 -0.374903059721D-01\n', ' -0.134108345054D-01  0.105354216260D-01  0.341364234511D-01  0.572119474482D-01\n', '  0.796101115036D-01  0.101204244350D+00  0.121890065481D+00  0.141583145707D+00\n', '  0.160216621403D+00  0.177739138065D+00  0.194113001148D+00  0.209312514243D+00\n', '  0.223322486585D+00  0.236136893566D+00  0.247757675516D+00  0.258193661399D+00\n', '  0.267459605338D+00  0.275575325044D+00  0.282564932253D+00  0.288456146215D+00\n', '  0.293279682129D+00  0.297068707182D+00  0.299858357558D+00  0.301685310398D+00\n', '  0.302587405270D+00  0.302603310223D+00  0.301772227971D+00  0.300133638159D+00\n', '  0.297727072080D+00  0.294591916516D+00  0.290767243732D+00  0.286291664915D+00\n', '  0.281203204606D+00  0.275539193924D+00  0.269336180580D+00  0.262629853871D+00\n', '  0.255454983039D+00  0.247845367497D+00  0.239833797619D+00  0.231452024878D+00\n', '  0.222730740254D+00  0.213699559940D+00  0.204387017466D+00  0.194820561451D+00\n', '  0.185026558269D+00  0.175030298997D+00  0.164856010062D+00  0.154526867078D+00\n', '  0.144065011405D+00  0.133491569030D+00  0.122826671379D+00  0.112089477754D+00\n', '  0.112089477754D+00  0.103636436582D+00  0.967661312431D-01  0.907920553210D-01\n', '  0.854582211008D-01  0.806157338563D-01  0.761655133573D-01  0.720369170416D-01\n', '  0.681774516694D-01  0.645470464748D-01  0.611145452033D-01  0.578554065912D-01\n', '  0.547501193073D-01  0.517830665868D-01  0.489416882068D-01  0.462158470294D-01\n', '  0.435973409458D-01  0.410795209987D-01  0.386569888181D-01  0.363253544515D-01\n', '  0.340810409377D-01  0.319211255624D-01  0.298432102497D-01  0.278453153280D-01\n', '  0.259257922156D-01  0.240832515371D-01  0.223165039000D-01  0.206245111227D-01\n', '  0.190063461227D-01  0.174611600124D-01  0.159881552105D-01  0.145865635856D-01\n', '  0.132556288181D-01  0.119945923008D-01  0.108026820106D-01  0.967910387520D-02\n', '  0.862303523121D-02  0.763362003566D-02  0.670996554319D-02  0.585114020384D-02\n', '  0.505617257596D-02  0.432405107641D-02  0.365372441826D-02  0.304410260828D-02\n', '  0.249405839542D-02  0.200242907626D-02  0.156801858040D-02  0.118959976698D-02\n', '  0.865916875895D-03  0.595688086562D-03  0.377608141186D-03  0.210351001681D-03\n', '  0.925725079864D-04  0.229130169002D-04 -0.594900858547D-13\n', '   81\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.979799203734D-01\n', ' -0.174039052415D+00 -0.231036038218D+00 -0.271523786318D+00 -0.297779885546D+00\n', ' -0.311834045795D+00 -0.315492858980D+00 -0.310362143852D+00 -0.297867111826D+00\n', ' -0.279270567219D+00 -0.255689333976D+00 -0.228109081836D+00 -0.197397707714D+00\n', ' -0.164317412676D+00 -0.129535600998D+00 -0.936347153865D-01 -0.571211112219D-01\n', ' -0.204330626145D-01  0.160520159776D-01  0.520110569948D-01  0.871694676443D-01\n', '  0.121295836768D+00  0.154197165048D+00  0.185714568251D+00  0.215719408081D+00\n', '  0.244109809548D+00  0.270807527723D+00  0.295755130311D+00  0.318913465661D+00\n', '  0.340259388763D+00  0.359783720384D+00  0.377489416858D+00  0.393389930201D+00\n', '  0.407507740141D+00  0.419873041409D+00  0.430522571212D+00  0.439498563251D+00\n', '  0.446847815925D+00  0.452620863540D+00  0.456871240411D+00  0.459654828693D+00\n', '  0.461029281639D+00  0.461053514800D+00  0.459787258350D+00  0.457290664405D+00\n', '  0.453623963772D+00  0.448847167075D+00  0.443019805740D+00  0.436200708676D+00\n', '  0.428447810968D+00  0.419817991186D+00  0.410366934280D+00  0.400149017304D+00\n', '  0.389217215491D+00  0.377623026420D+00  0.365416410278D+00  0.352645744354D+00\n', '  0.339357790146D+00  0.325597671582D+00  0.311408863019D+00  0.296833185816D+00\n', '  0.281910812404D+00  0.266680276860D+00  0.251178491138D+00  0.235440766146D+00\n', '  0.219500836983D+00  0.203390891699D+00  0.187141603008D+00  0.170782162470D+00\n', '  0.170782162470D+00  0.157902910290D+00  0.147435151619D+00  0.138332909150D+00\n', '  0.130206153984D+00  0.122828026618D+00  0.116047566083D+00  0.109757139712D+00\n', '  0.103876767571D+00  0.983453969002D-01  0.931155572972D-01  0.881498571163D-01\n', '  0.834185684345D-01  0.788978971823D-01  0.745687063085D-01  0.704155506318D-01\n', '  0.664259332265D-01  0.625897235849D-01  0.588986966237D-01  0.553461637082D-01\n', '  0.519266748958D-01  0.486357770709D-01  0.454698164684D-01  0.424257768139D-01\n', '  0.395011462901D-01  0.366938080115D-01  0.340019497921D-01  0.314239898339D-01\n', '  0.289585156121D-01  0.266042337418D-01  0.243599290092D-01  0.222244310713D-01\n', '  0.201965875819D-01  0.182752427090D-01  0.164592201804D-01  0.147473101285D-01\n', '  0.131382591244D-01  0.116307628806D-01  0.102234611895D-01  0.891493471958D-02\n', '  0.770370335957D-02  0.658822583760D-02  0.556690038820D-02  0.463806627207D-02\n', '  0.380000598301D-02  0.305094799877D-02  0.238906995839D-02  0.181250216122D-02\n', '  0.131933130164D-02  0.907604367683D-03  0.575332637913D-03  0.320495729523D-03\n', '  0.141045648670D-03  0.349108110181D-04 -0.908372818246D-13\n', '    3  135 NPAN,MESHN;  Shape number     1;     # serial: voro_v1.0-16-g2d2b8f1_serial_20180516213647\n', '   10   70   55\n', '  0.495000000000D+00  0.555555555556D-03  0.495555555556D+00  0.555555555556D-03\n', '  0.496111111111D+00  0.555555555556D-03  0.496666666667D+00  0.555555555556D-03\n', '  0.497222222222D+00  0.555555555556D-03  0.497777777778D+00  0.555555555556D-03\n', '  0.498333333333D+00  0.555555555556D-03  0.498888888889D+00  0.555555555556D-03\n', '  0.499444444444D+00  0.555555555556D-03  0.500000000000D+00  0.555555555556D-03\n', '  0.500000000000D+00  0.300154755343D-02  0.503001547553D+00  0.300154755343D-02\n', '  0.506003095107D+00  0.300154755343D-02  0.509004642660D+00  0.300154755343D-02\n', '  0.512006190214D+00  0.300154755343D-02  0.515007737767D+00  0.300154755343D-02\n', '  0.518009285321D+00  0.300154755343D-02  0.521010832874D+00  0.300154755343D-02\n', '  0.524012380427D+00  0.300154755343D-02  0.527013927981D+00  0.300154755343D-02\n', '  0.530015475534D+00  0.300154755343D-02  0.533017023088D+00  0.300154755343D-02\n', '  0.536018570641D+00  0.300154755343D-02  0.539020118195D+00  0.300154755343D-02\n', '  0.542021665748D+00  0.300154755343D-02  0.545023213301D+00  0.300154755343D-02\n', '  0.548024760855D+00  0.300154755343D-02  0.551026308408D+00  0.300154755343D-02\n', '  0.554027855962D+00  0.300154755343D-02  0.557029403515D+00  0.300154755343D-02\n', '  0.560030951069D+00  0.300154755343D-02  0.563032498622D+00  0.300154755343D-02\n', '  0.566034046175D+00  0.300154755343D-02  0.569035593729D+00  0.300154755343D-02\n', '  0.572037141282D+00  0.300154755343D-02  0.575038688836D+00  0.300154755343D-02\n', '  0.578040236389D+00  0.300154755343D-02  0.581041783943D+00  0.300154755343D-02\n', '  0.584043331496D+00  0.300154755343D-02  0.587044879049D+00  0.300154755343D-02\n', '  0.590046426603D+00  0.300154755343D-02  0.593047974156D+00  0.300154755343D-02\n', '  0.596049521710D+00  0.300154755343D-02  0.599051069263D+00  0.300154755343D-02\n', '  0.602052616817D+00  0.300154755343D-02  0.605054164370D+00  0.300154755343D-02\n', '  0.608055711923D+00  0.300154755343D-02  0.611057259477D+00  0.300154755343D-02\n', '  0.614058807030D+00  0.300154755343D-02  0.617060354584D+00  0.300154755343D-02\n', '  0.620061902137D+00  0.300154755343D-02  0.623063449691D+00  0.300154755343D-02\n', '  0.626064997244D+00  0.300154755343D-02  0.629066544797D+00  0.300154755343D-02\n', '  0.632068092351D+00  0.300154755343D-02  0.635069639904D+00  0.300154755343D-02\n', '  0.638071187458D+00  0.300154755343D-02  0.641072735011D+00  0.300154755343D-02\n', '  0.644074282565D+00  0.300154755343D-02  0.647075830118D+00  0.300154755343D-02\n', '  0.650077377671D+00  0.300154755343D-02  0.653078925225D+00  0.300154755343D-02\n', '  0.656080472778D+00  0.300154755343D-02  0.659082020332D+00  0.300154755343D-02\n', '  0.662083567885D+00  0.300154755343D-02  0.665085115439D+00  0.300154755343D-02\n', '  0.668086662992D+00  0.300154755343D-02  0.671088210545D+00  0.300154755343D-02\n', '  0.674089758099D+00  0.300154755343D-02  0.677091305652D+00  0.300154755343D-02\n', '  0.680092853206D+00  0.300154755343D-02  0.683094400759D+00  0.300154755343D-02\n', '  0.686095948313D+00  0.300154755343D-02  0.689097495866D+00  0.300154755343D-02\n', '  0.692099043419D+00  0.300154755343D-02  0.695100590973D+00  0.300154755343D-02\n', '  0.698102138526D+00  0.300154755343D-02  0.701103686080D+00  0.300154755343D-02\n', '  0.704105233633D+00  0.300154755343D-02  0.707106781187D+00  0.300154755343D-02\n', '  0.707106781187D+00  0.294293745552D-02  0.710049718642D+00  0.294293745552D-02\n', '  0.712992656098D+00  0.294293745552D-02  0.715935593553D+00  0.294293745552D-02\n', '  0.718878531009D+00  0.294293745552D-02  0.721821468464D+00  0.294293745552D-02\n', '  0.724764405920D+00  0.294293745552D-02  0.727707343375D+00  0.294293745552D-02\n', '  0.730650280831D+00  0.294293745552D-02  0.733593218286D+00  0.294293745552D-02\n', '  0.736536155742D+00  0.294293745552D-02  0.739479093197D+00  0.294293745552D-02\n', '  0.742422030653D+00  0.294293745552D-02  0.745364968108D+00  0.294293745552D-02\n', '  0.748307905564D+00  0.294293745552D-02  0.751250843019D+00  0.294293745552D-02\n', '  0.754193780475D+00  0.294293745552D-02  0.757136717930D+00  0.294293745552D-02\n', '  0.760079655386D+00  0.294293745552D-02  0.763022592841D+00  0.294293745552D-02\n', '  0.765965530297D+00  0.294293745552D-02  0.768908467752D+00  0.294293745552D-02\n', '  0.771851405208D+00  0.294293745552D-02  0.774794342663D+00  0.294293745552D-02\n', '  0.777737280119D+00  0.294293745552D-02  0.780680217574D+00  0.294293745552D-02\n', '  0.783623155030D+00  0.294293745552D-02  0.786566092485D+00  0.294293745552D-02\n', '  0.789509029941D+00  0.294293745552D-02  0.792451967397D+00  0.294293745552D-02\n', '  0.795394904852D+00  0.294293745552D-02  0.798337842308D+00  0.294293745552D-02\n', '  0.801280779763D+00  0.294293745552D-02  0.804223717219D+00  0.294293745552D-02\n', '  0.807166654674D+00  0.294293745552D-02  0.810109592130D+00  0.294293745552D-02\n', '  0.813052529585D+00  0.294293745552D-02  0.815995467041D+00  0.294293745552D-02\n', '  0.818938404496D+00  0.294293745552D-02  0.821881341952D+00  0.294293745552D-02\n', '  0.824824279407D+00  0.294293745552D-02  0.827767216863D+00  0.294293745552D-02\n', '  0.830710154318D+00  0.294293745552D-02  0.833653091774D+00  0.294293745552D-02\n', '  0.836596029229D+00  0.294293745552D-02  0.839538966685D+00  0.294293745552D-02\n', '  0.842481904140D+00  0.294293745552D-02  0.845424841596D+00  0.294293745552D-02\n', '  0.848367779051D+00  0.294293745552D-02  0.851310716507D+00  0.294293745552D-02\n', '  0.854253653962D+00  0.294293745552D-02  0.857196591418D+00  0.294293745552D-02\n', '  0.860139528873D+00  0.294293745552D-02  0.863082466329D+00  0.294293745552D-02\n', '  0.866025403784D+00  0.294293745552D-02\n', '    8\n', '    1\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.348144740577D+01\n', '  0.341873998692D+01  0.335677212636D+01  0.329553081748D+01  0.323500335691D+01\n', '  0.317517733570D+01  0.311604063086D+01  0.305758139715D+01  0.299978805921D+01\n', '  0.294264930386D+01  0.288615407276D+01  0.283029155528D+01  0.277505118156D+01\n', '  0.272042261588D+01  0.266639575022D+01  0.261296069799D+01  0.256010778802D+01\n', '  0.250782755873D+01  0.245611075245D+01  0.240494831001D+01  0.235433136540D+01\n', '  0.230425124068D+01  0.225469944100D+01  0.220566764980D+01  0.215714772417D+01\n', '  0.210913169033D+01  0.206161173925D+01  0.201458022246D+01  0.196802964790D+01\n', '  0.192195267594D+01  0.187634211556D+01  0.183119092059D+01  0.178649218608D+01\n', '  0.174223914475D+01  0.169842516366D+01  0.165504374078D+01  0.161208850186D+01\n', '  0.156955319730D+01  0.152743169906D+01  0.148571799778D+01  0.144440619990D+01\n', '  0.140349052487D+01  0.136296530248D+01  0.132282497020D+01  0.128306407070D+01\n', '  0.124367724929D+01  0.120465925162D+01  0.116600492124D+01  0.112770919739D+01\n', '  0.108976711279D+01  0.105217379146D+01  0.101492444666D+01  0.978014378839D+00\n', '  0.941438973679D+00  0.905193700153D+00  0.869274108662D+00  0.833675829215D+00\n', '  0.798394569651D+00  0.763426113922D+00  0.728766320407D+00  0.694411120278D+00\n', '  0.660356515910D+00  0.626598579329D+00  0.593133450700D+00  0.559957336859D+00\n', '  0.527066509878D+00  0.494457305668D+00  0.462126122617D+00  0.430069420271D+00\n', '  0.430069420271D+00  0.402303316540D+00  0.377539313460D+00  0.354743340664D+00\n', '  0.333530457006D+00  0.313670769379D+00  0.295004615108D+00  0.277411710302D+00\n', '  0.260796664908D+00  0.245081108278D+00  0.230198970219D+00  0.216093447552D+00\n', '  0.202714947697D+00  0.190019635093D+00  0.177968368454D+00  0.166525901810D+00\n', '  0.155660269630D+00  0.145342304080D+00  0.135545249448D+00  0.126244449527D+00\n', '  0.117417090804D+00  0.109041989005D+00  0.101099409844D+00  0.935709170764D-01\n', '  0.864392426117D-01  0.796881746491D-01  0.733024606555D-01  0.672677226928D-01\n', '  0.615703830911D-01  0.561975988595D-01  0.511372035220D-01  0.463776553057D-01\n', '  0.419079907936D-01  0.377177833043D-01  0.337971053812D-01  0.301364948711D-01\n', '  0.267269241521D-01  0.235597721351D-01  0.206267987196D-01  0.179201214265D-01\n', '  0.154321939709D-01  0.131557865685D-01  0.110839677947D-01  0.921008784091D-02\n', '  0.752776303004D-02  0.603086146903D-02  0.471348973284D-02  0.356998048451D-02\n', '  0.259488094746D-02  0.178294215513D-02  0.112910891116D-02  0.628510400363D-03\n', '  0.276451396771D-03  0.684040205092D-04  0.457411886146D-13\n', '   21\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.107771580765D+00\n', ' -0.207927768303D+00 -0.300879928222D+00 -0.387017301583D+00 -0.466708260187D+00\n', ' -0.540301485561D+00 -0.608127076621D+00 -0.670497590656D+00 -0.727709021934D+00\n', ' -0.780041721948D+00 -0.827761265034D+00 -0.871119262839D+00 -0.910354130889D+00\n', ' -0.945691810260D+00 -0.977346447194D+00 -0.100552103326D+01 -0.103040800855D+01\n', ' -0.105218983014D+01 -0.107103950802D+01 -0.108712111043D+01 -0.110059024054D+01\n', ' -0.111159448612D+01 -0.112027384388D+01 -0.112676112010D+01 -0.113118230872D+01\n', ' -0.113365694857D+01 -0.113429846067D+01 -0.113321446694D+01 -0.113050709147D+01\n', ' -0.112627324514D+01 -0.112060489489D+01 -0.111358931816D+01 -0.110530934371D+01\n', ' -0.109584357938D+01 -0.108526662757D+01 -0.107364928929D+01 -0.106105875719D+01\n', ' -0.104755879842D+01 -0.103320992775D+01 -0.101806957159D+01 -0.100219222331D+01\n', ' -0.985629590493D+00 -0.968430734425D+00 -0.950642202363D+00 -0.932308152903D+00\n', ' -0.913470474873D+00 -0.894168900091D+00 -0.874441110314D+00 -0.854322838707D+00\n', ' -0.833847966132D+00 -0.813048612513D+00 -0.791955223572D+00 -0.770596653163D+00\n', ' -0.749000241447D+00 -0.727191889129D+00 -0.705196127964D+00 -0.683036187733D+00\n', ' -0.660734059870D+00 -0.638310557917D+00 -0.615785374981D+00 -0.593177138329D+00\n', ' -0.570503461300D+00 -0.547780992645D+00 -0.525025463440D+00 -0.502251731701D+00\n', ' -0.479473824810D+00 -0.456704979869D+00 -0.433957682089D+00 -0.411243701307D+00\n', ' -0.411243701307D+00 -0.390528872452D+00 -0.371153728294D+00 -0.352708702956D+00\n', ' -0.335055250348D+00 -0.318115790182D+00 -0.301838817656D+00 -0.286186587040D+00\n', ' -0.271129514420D+00 -0.256643242282D+00 -0.242706948687D+00 -0.229302306517D+00\n', ' -0.216412810451D+00 -0.204023324895D+00 -0.192119771086D+00 -0.180688905193D+00\n', ' -0.169718157817D+00 -0.159195515938D+00 -0.149109434868D+00 -0.139448771777D+00\n', ' -0.130202734970D+00 -0.121360844815D+00 -0.112912903371D+00 -0.104848970587D+00\n', ' -0.971593454900D-01 -0.898345511834D-01 -0.828653227895D-01 -0.762425976473D-01\n', ' -0.699575072669D-01 -0.640013706413D-01 -0.583656886141D-01 -0.530421390663D-01\n', ' -0.480225727376D-01 -0.432990095404D-01 -0.388636352520D-01 -0.347087984988D-01\n', ' -0.308270079625D-01 -0.272109297547D-01 -0.238533849179D-01 -0.207473470199D-01\n', ' -0.178859398176D-01 -0.152624349680D-01 -0.128702497753D-01 -0.107029449600D-01\n', ' -0.875422244382D-02 -0.701792314373D-02 -0.548802477161D-02 -0.415863963680D-02\n', ' -0.302401245044D-02 -0.207851813067D-02 -0.131665960939D-02 -0.733065640768D-03\n', ' -0.322488612760D-03 -0.798023629498D-04 -0.130951788091D-13\n', '   25\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.910836100221D-01\n', ' -0.175731038058D+00 -0.254289951499D+00 -0.327089319087D+00 -0.394440471814D+00\n', ' -0.456638099358D+00 -0.513961186222D+00 -0.566673891528D+00 -0.615026376092D+00\n', ' -0.659255580170D+00 -0.699585955043D+00 -0.736230151364D+00 -0.769389667030D+00\n', ' -0.799255457103D+00 -0.826008508190D+00 -0.849820379482D+00 -0.870853712536D+00\n', ' -0.889262711727D+00 -0.905193597184D+00 -0.918785031886D+00 -0.930168524507D+00\n', ' -0.939468809474D+00 -0.946804205618D+00 -0.952286954712D+00 -0.956023541090D+00\n', ' -0.958114993490D+00 -0.958657170165D+00 -0.957741028255D+00 -0.955452878353D+00\n', ' -0.951874625121D+00 -0.947083994787D+00 -0.941154750263D+00 -0.934156894630D+00\n', ' -0.926156863626D+00 -0.917217707805D+00 -0.907399264928D+00 -0.896758323153D+00\n', ' -0.885348775560D+00 -0.873221766467D+00 -0.860425830039D+00 -0.847007021587D+00\n', ' -0.833009041991D+00 -0.818473355609D+00 -0.803439302052D+00 -0.787944202144D+00\n', ' -0.772023458408D+00 -0.755710650358D+00 -0.739037624891D+00 -0.722034582045D+00\n', ' -0.704730156373D+00 -0.687151494166D+00 -0.669324326756D+00 -0.651273040100D+00\n', ' -0.633020740852D+00 -0.614589319101D+00 -0.595999507967D+00 -0.577270940196D+00\n', ' -0.558422201943D+00 -0.539470883862D+00 -0.520433629664D+00 -0.501326182266D+00\n', ' -0.482163427655D+00 -0.462959436593D+00 -0.443727504267D+00 -0.424480187992D+00\n', ' -0.405229343069D+00 -0.385986156892D+00 -0.366761181390D+00 -0.347564363890D+00\n', ' -0.347564363890D+00 -0.330057138148D+00 -0.313682152626D+00 -0.298093260983D+00\n', ' -0.283173370401D+00 -0.268856913569D+00 -0.255100360984D+00 -0.241871811683D+00\n', ' -0.229146262694D+00 -0.216903128162D+00 -0.205124810335D+00 -0.193795819972D+00\n', ' -0.182902207530D+00 -0.172431181099D+00 -0.162370841951D+00 -0.152709997006D+00\n', ' -0.143438023184D+00 -0.134544767629D+00 -0.126020473299D+00 -0.117855722784D+00\n', ' -0.110041395437D+00 -0.102568634352D+00 -0.954288206976D-01 -0.886135535959D-01\n', ' -0.821146342275D-01 -0.759240531543D-01 -0.700339801250D-01 -0.644367557932D-01\n', ' -0.591248849168D-01 -0.540910307059D-01 -0.493280100624D-01 -0.448287895118D-01\n', ' -0.405864816722D-01 -0.365943421386D-01 -0.328457666874D-01 -0.293342887278D-01\n', ' -0.260535769401D-01 -0.229974330573D-01 -0.201597897530D-01 -0.175347086082D-01\n', ' -0.151163781367D-01 -0.128991118507D-01 -0.108773463570D-01 -0.904563947108D-02\n', ' -0.739866834524D-02 -0.593122760428D-02 -0.463822748578D-02 -0.351469198292D-02\n', ' -0.255575698884D-02 -0.175666844166D-02 -0.111278047091D-02 -0.619553545292D-03\n', ' -0.272552623174D-03 -0.674453065838D-04 -0.112512836764D-13\n', '   43\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.268444513742D-01\n', ' -0.500548066307D-01 -0.699457900360D-01 -0.868078731501D-01 -0.100909115568D+00\n', ' -0.112496862702D+00 -0.121799312141D+00 -0.129026959167D+00 -0.134373931089D+00\n', ' -0.138019219277D+00 -0.140127817026D+00 -0.140851770688D+00 -0.140331150927D+00\n', ' -0.138694950372D+00 -0.136061913408D+00 -0.132541303434D+00 -0.128233612407D+00\n', ' -0.123231217174D+00 -0.117618986681D+00 -0.111474843842D+00 -0.104870285545D+00\n', ' -0.978708639919D-01 -0.905366323184D-01 -0.829225572075D-01 -0.750789009913D-01\n', ' -0.670515755483D-01 -0.588824701153D-01 -0.506097549736D-01 -0.422681628129D-01\n', ' -0.338892494404D-01 -0.255016353702D-01 -0.171312297148D-01 -0.880143768684D-02\n', ' -0.533352923024D-03  0.765406425161D-02  0.157438215857D-01  0.237207417339D-01\n', '  0.315713202766D-01  0.392835941091D-01  0.468470194448D-01  0.542523587328D-01\n', '  0.614915758422D-01  0.685577389142D-01  0.754449303262D-01  0.821481632554D-01\n', '  0.886633043631D-01  0.949870021620D-01  0.101116620654D+00  0.107050177862D+00\n', '  0.112786288906D+00  0.118324113288D+00  0.123663306099D+00  0.128803972858D+00\n', '  0.133746627717D+00  0.138492154809D+00  0.143041772497D+00  0.147397000323D+00\n', '  0.151559628473D+00  0.155531689558D+00  0.159315432565D+00  0.162913298813D+00\n', '  0.166327899774D+00  0.169561996620D+00  0.172618481381D+00  0.175500359595D+00\n', '  0.178210734336D+00  0.180752791535D+00  0.183129786488D+00  0.185345031472D+00\n', '  0.185345031472D+00  0.184931678626D+00  0.182571003170D+00  0.179102705992D+00\n', '  0.174861661976D+00  0.170054289762D+00  0.164825839363D+00  0.159285689158D+00\n', '  0.153519615050D+00  0.147596680139D+00  0.141573498882D+00  0.135497066883D+00\n', '  0.129406739952D+00  0.123335675859D+00  0.117311919408D+00  0.111359240949D+00\n', '  0.105497798650D+00  0.997446711754D-01  0.941142927526D-01  0.886188131823D-01\n', '  0.832683990877D-01  0.780714884291D-01  0.730350073337D-01  0.681645561664D-01\n', '  0.634645702171D-01  0.589384592422D-01  0.545887292324D-01  0.504170891306D-01\n', '  0.464245447124D-01  0.426114814506D-01  0.389777378725D-01  0.355226706676D-01\n', '  0.322452126076D-01  0.291439241729D-01  0.262170396519D-01  0.234625083646D-01\n', '  0.208780315749D-01  0.184610955785D-01  0.162090013874D-01  0.141188913829D-01\n', '  0.121877732559D-01  0.104125415219D-01  0.878999685767D-02  0.731686348191D-02\n', '  0.598980477569D-02  0.480543731577D-02  0.376034347671D-02  0.285108273952D-02\n', '  0.207420183130D-02  0.142624380619D-02  0.903756167956D-03  0.503298123378D-03\n', '  0.221447047829D-03  0.548042354075D-04  0.212654742276D-13\n', '   47\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.710237424182D-01\n', '  0.132432570268D+00  0.185059165691D+00  0.229672044198D+00  0.266980424813D+00\n', '  0.297638721984D+00  0.322250689785D+00  0.341373246380D+00  0.355520004351D+00\n', '  0.365164530355D+00  0.370743355613D+00  0.372658756962D+00  0.371281326549D+00\n', '  0.366952346784D+00  0.359985985786D+00  0.350671327331D+00  0.339274248149D+00\n', '  0.326039154403D+00  0.311190588218D+00  0.294934714247D+00  0.277460695473D+00\n', '  0.258941966722D+00  0.239537413656D+00  0.219392464448D+00  0.198640100731D+00\n', '  0.177401793916D+00  0.155788372506D+00  0.133900825574D+00  0.111831047179D+00\n', '  0.896625261379D-01  0.674709852150D-01  0.453249734781D-01  0.232864152992D-01\n', '  0.141111919535D-02 -0.202507505287D-01 -0.416542366014D-01 -0.627591835418D-01\n', ' -0.835298620138D-01 -0.103934620617D+00 -0.123945563116D+00 -0.143538249246D+00\n', ' -0.162691417404D+00 -0.181386727616D+00 -0.199608523324D+00 -0.217343610635D+00\n', ' -0.234581053762D+00 -0.251311985504D+00 -0.267529431666D+00 -0.283228148429D+00\n', ' -0.298404471743D+00 -0.313056177862D+00 -0.327182354243D+00 -0.340783280060D+00\n', ' -0.353860315633D+00 -0.366415800159D+00 -0.378452957120D+00 -0.389975806852D+00\n', ' -0.400989085737D+00 -0.411498171559D+00 -0.421509014581D+00 -0.431028073925D+00\n', ' -0.440062258894D+00 -0.448618874864D+00 -0.456705573429D+00 -0.464330306491D+00\n', ' -0.471501284016D+00 -0.478226935182D+00 -0.484515872695D+00 -0.490376860015D+00\n', ' -0.490376860015D+00 -0.489283231183D+00 -0.483037471001D+00 -0.473861219194D+00\n', ' -0.462640471428D+00 -0.449921360090D+00 -0.436088180592D+00 -0.421430320923D+00\n', ' -0.406174722792D+00 -0.390504109986D+00 -0.374568270278D+00 -0.358491542350D+00\n', ' -0.342378051888D+00 -0.326315526106D+00 -0.310378164577D+00 -0.294628857739D+00\n', ' -0.279120939092D+00 -0.263899594534D+00 -0.249003013440D+00 -0.234463341162D+00\n', ' -0.220307476057D+00 -0.206557742868D+00 -0.193232466407D+00 -0.180346463845D+00\n', ' -0.167911469858D+00 -0.155936505812D+00 -0.144428201936D+00 -0.133391079667D+00\n', ' -0.122827800038D+00 -0.112739382914D+00 -0.103125401078D+00 -0.939841524914D-01\n', ' -0.853128135320D-01 -0.771075755900D-01 -0.693637670313D-01 -0.620759622664D-01\n', ' -0.552380794118D-01 -0.488434678304D-01 -0.428849866719D-01 -0.373550753871D-01\n', ' -0.322458170709D-01 -0.275489953832D-01 -0.232561457104D-01 -0.193586011502D-01\n', ' -0.158475338383D-01 -0.127139920785D-01 -0.994893368355D-02 -0.754325589604D-02\n', ' -0.548782221457D-02 -0.377348642013D-02 -0.239111406624D-02 -0.133160166979D-02\n', ' -0.585893817112D-03 -0.144998377667D-03 -0.576892540902D-13\n', '   73\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.120919961757D+00\n', ' -0.214786820424D+00 -0.285128512040D+00 -0.335095657689D+00 -0.367499098133D+00\n', ' -0.384843759298D+00 -0.389359210512D+00 -0.383027240913D+00 -0.367606746704D+00\n', ' -0.344656192610D+00 -0.315553884595D+00 -0.281516267282D+00 -0.243614438314D+00\n', ' -0.202789052911D+00 -0.159863774732D+00 -0.115557413810D+00 -0.704948785238D-01\n', ' -0.252170561122D-01  0.198102749088D-01  0.641884071634D-01  0.107578457441D+00\n', '  0.149694834283D+00  0.190299351434D+00  0.229195925094D+00  0.266225798879D+00\n', '  0.301263245802D+00  0.334211701450D+00  0.365000286900D+00  0.393580683926D+00\n', '  0.419924328576D+00  0.444019892484D+00  0.465871024148D+00  0.485494325107D+00\n', '  0.502917538266D+00  0.518177927851D+00  0.531320832352D+00  0.542398373649D+00\n', '  0.551468307049D+00  0.558592998456D+00  0.563838516178D+00  0.567273826059D+00\n', '  0.568970079710D+00  0.568999986582D+00  0.567437261474D+00  0.564356139923D+00\n', '  0.559830954572D+00  0.553935766337D+00  0.546744044736D+00  0.538328392293D+00\n', '  0.528760308437D+00  0.518109988718D+00  0.506446155605D+00  0.493835917454D+00\n', '  0.480344652589D+00  0.466035915721D+00  0.450971364214D+00  0.435210701935D+00\n', '  0.418811638652D+00  0.401829863159D+00  0.384319028467D+00  0.366330747570D+00\n', '  0.347914598470D+00  0.329118137231D+00  0.309986918002D+00  0.290564519036D+00\n', '  0.270892573831D+00  0.251010806625D+00  0.230957071537D+00  0.210767394748D+00\n', '  0.210767394748D+00  0.194872722910D+00  0.181954147621D+00  0.170720796879D+00\n', '  0.160691324308D+00  0.151585755783D+00  0.143217785841D+00  0.135454581775D+00\n', '  0.128197437948D+00  0.121371007313D+00  0.114916705224D+00  0.108788385526D+00\n', '  0.102949360099D+00  0.973702639649D-01  0.920274795158D-01  0.869019453892D-01\n', '  0.819782387537D-01  0.772438572460D-01  0.726886500433D-01  0.683043625011D-01\n', '  0.640842686815D-01  0.600228728605D-01  0.561156658172D-01  0.523589250768D-01\n', '  0.487495507301D-01  0.452849302651D-01  0.419628272086D-01  0.387812894162D-01\n', '  0.357385736489D-01  0.328330837010D-01  0.300633198412D-01  0.274278377140D-01\n', '  0.249252151739D-01  0.225540257744D-01  0.203128178425D-01  0.182000982443D-01\n', '  0.162143200854D-01  0.143538737057D-01  0.126170804319D-01  0.110021886245D-01\n', '  0.950737163371D-02  0.813072732961D-02  0.687027892533D-02  0.572397685272D-02\n', '  0.468970148569D-02  0.376526653556D-02  0.294842297179D-02  0.223686334081D-02\n', '  0.162822637464D-02  0.112010180264D-02  0.710035283844D-03  0.395533403271D-03\n', '  0.174068670187D-03  0.430844801113D-04 -0.125071680895D-12\n', '   77\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.643071732209D-01\n', ' -0.114227072733D+00 -0.151635911453D+00 -0.178209240157D+00 -0.195441909001D+00\n', ' -0.204666077730D+00 -0.207067467039D+00 -0.203700024146D+00 -0.195499158236D+00\n', ' -0.183293685821D+00 -0.167816612099D+00 -0.149714861810D+00 -0.129558061846D+00\n', ' -0.107846467724D+00 -0.850181169764D-01 -0.614552842961D-01 -0.374903059721D-01\n', ' -0.134108345054D-01  0.105354216260D-01  0.341364234511D-01  0.572119474482D-01\n', '  0.796101115036D-01  0.101204244350D+00  0.121890065481D+00  0.141583145707D+00\n', '  0.160216621403D+00  0.177739138065D+00  0.194113001148D+00  0.209312514243D+00\n', '  0.223322486585D+00  0.236136893566D+00  0.247757675516D+00  0.258193661399D+00\n', '  0.267459605338D+00  0.275575325044D+00  0.282564932253D+00  0.288456146215D+00\n', '  0.293279682129D+00  0.297068707182D+00  0.299858357558D+00  0.301685310398D+00\n', '  0.302587405270D+00  0.302603310223D+00  0.301772227971D+00  0.300133638159D+00\n', '  0.297727072080D+00  0.294591916516D+00  0.290767243732D+00  0.286291664915D+00\n', '  0.281203204606D+00  0.275539193924D+00  0.269336180580D+00  0.262629853871D+00\n', '  0.255454983039D+00  0.247845367497D+00  0.239833797619D+00  0.231452024878D+00\n', '  0.222730740254D+00  0.213699559940D+00  0.204387017466D+00  0.194820561451D+00\n', '  0.185026558269D+00  0.175030298997D+00  0.164856010062D+00  0.154526867078D+00\n', '  0.144065011405D+00  0.133491569030D+00  0.122826671379D+00  0.112089477754D+00\n', '  0.112089477754D+00  0.103636436582D+00  0.967661312431D-01  0.907920553210D-01\n', '  0.854582211008D-01  0.806157338563D-01  0.761655133573D-01  0.720369170416D-01\n', '  0.681774516694D-01  0.645470464748D-01  0.611145452033D-01  0.578554065912D-01\n', '  0.547501193073D-01  0.517830665868D-01  0.489416882068D-01  0.462158470294D-01\n', '  0.435973409458D-01  0.410795209987D-01  0.386569888181D-01  0.363253544515D-01\n', '  0.340810409377D-01  0.319211255624D-01  0.298432102497D-01  0.278453153280D-01\n', '  0.259257922156D-01  0.240832515371D-01  0.223165039000D-01  0.206245111227D-01\n', '  0.190063461227D-01  0.174611600124D-01  0.159881552105D-01  0.145865635856D-01\n', '  0.132556288181D-01  0.119945923008D-01  0.108026820106D-01  0.967910387520D-02\n', '  0.862303523121D-02  0.763362003566D-02  0.670996554319D-02  0.585114020384D-02\n', '  0.505617257596D-02  0.432405107641D-02  0.365372441826D-02  0.304410260828D-02\n', '  0.249405839542D-02  0.200242907626D-02  0.156801858040D-02  0.118959976698D-02\n', '  0.865916875895D-03  0.595688086562D-03  0.377608141186D-03  0.210351001681D-03\n', '  0.925725079864D-04  0.229130169002D-04 -0.594900858547D-13\n', '   81\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.979799203734D-01\n', ' -0.174039052415D+00 -0.231036038218D+00 -0.271523786318D+00 -0.297779885546D+00\n', ' -0.311834045795D+00 -0.315492858980D+00 -0.310362143852D+00 -0.297867111826D+00\n', ' -0.279270567219D+00 -0.255689333976D+00 -0.228109081836D+00 -0.197397707714D+00\n', ' -0.164317412676D+00 -0.129535600998D+00 -0.936347153865D-01 -0.571211112219D-01\n', ' -0.204330626145D-01  0.160520159776D-01  0.520110569948D-01  0.871694676443D-01\n', '  0.121295836768D+00  0.154197165048D+00  0.185714568251D+00  0.215719408081D+00\n', '  0.244109809548D+00  0.270807527723D+00  0.295755130311D+00  0.318913465661D+00\n', '  0.340259388763D+00  0.359783720384D+00  0.377489416858D+00  0.393389930201D+00\n', '  0.407507740141D+00  0.419873041409D+00  0.430522571212D+00  0.439498563251D+00\n', '  0.446847815925D+00  0.452620863540D+00  0.456871240411D+00  0.459654828693D+00\n', '  0.461029281639D+00  0.461053514800D+00  0.459787258350D+00  0.457290664405D+00\n', '  0.453623963772D+00  0.448847167075D+00  0.443019805740D+00  0.436200708676D+00\n', '  0.428447810968D+00  0.419817991186D+00  0.410366934280D+00  0.400149017304D+00\n', '  0.389217215491D+00  0.377623026420D+00  0.365416410278D+00  0.352645744354D+00\n', '  0.339357790146D+00  0.325597671582D+00  0.311408863019D+00  0.296833185816D+00\n', '  0.281910812404D+00  0.266680276860D+00  0.251178491138D+00  0.235440766146D+00\n', '  0.219500836983D+00  0.203390891699D+00  0.187141603008D+00  0.170782162470D+00\n', '  0.170782162470D+00  0.157902910290D+00  0.147435151619D+00  0.138332909150D+00\n', '  0.130206153984D+00  0.122828026618D+00  0.116047566083D+00  0.109757139712D+00\n', '  0.103876767571D+00  0.983453969002D-01  0.931155572972D-01  0.881498571163D-01\n', '  0.834185684345D-01  0.788978971823D-01  0.745687063085D-01  0.704155506318D-01\n', '  0.664259332265D-01  0.625897235849D-01  0.588986966237D-01  0.553461637082D-01\n', '  0.519266748958D-01  0.486357770709D-01  0.454698164684D-01  0.424257768139D-01\n', '  0.395011462901D-01  0.366938080115D-01  0.340019497921D-01  0.314239898339D-01\n', '  0.289585156121D-01  0.266042337418D-01  0.243599290092D-01  0.222244310713D-01\n', '  0.201965875819D-01  0.182752427090D-01  0.164592201804D-01  0.147473101285D-01\n', '  0.131382591244D-01  0.116307628806D-01  0.102234611895D-01  0.891493471958D-02\n', '  0.770370335957D-02  0.658822583760D-02  0.556690038820D-02  0.463806627207D-02\n', '  0.380000598301D-02  0.305094799877D-02  0.238906995839D-02  0.181250216122D-02\n', '  0.131933130164D-02  0.907604367683D-03  0.575332637913D-03  0.320495729523D-03\n', '  0.141045648670D-03  0.349108110181D-04 -0.908372818246D-13\n', '    3  135 NPAN,MESHN;  Shape number     1;     # serial: voro_v1.0-16-g2d2b8f1_serial_20180516213647\n', '   10   70   55\n', '  0.495000000000D+00  0.555555555556D-03  0.495555555556D+00  0.555555555556D-03\n', '  0.496111111111D+00  0.555555555556D-03  0.496666666667D+00  0.555555555556D-03\n', '  0.497222222222D+00  0.555555555556D-03  0.497777777778D+00  0.555555555556D-03\n', '  0.498333333333D+00  0.555555555556D-03  0.498888888889D+00  0.555555555556D-03\n', '  0.499444444444D+00  0.555555555556D-03  0.500000000000D+00  0.555555555556D-03\n', '  0.500000000000D+00  0.300154755343D-02  0.503001547553D+00  0.300154755343D-02\n', '  0.506003095107D+00  0.300154755343D-02  0.509004642660D+00  0.300154755343D-02\n', '  0.512006190214D+00  0.300154755343D-02  0.515007737767D+00  0.300154755343D-02\n', '  0.518009285321D+00  0.300154755343D-02  0.521010832874D+00  0.300154755343D-02\n', '  0.524012380427D+00  0.300154755343D-02  0.527013927981D+00  0.300154755343D-02\n', '  0.530015475534D+00  0.300154755343D-02  0.533017023088D+00  0.300154755343D-02\n', '  0.536018570641D+00  0.300154755343D-02  0.539020118195D+00  0.300154755343D-02\n', '  0.542021665748D+00  0.300154755343D-02  0.545023213301D+00  0.300154755343D-02\n', '  0.548024760855D+00  0.300154755343D-02  0.551026308408D+00  0.300154755343D-02\n', '  0.554027855962D+00  0.300154755343D-02  0.557029403515D+00  0.300154755343D-02\n', '  0.560030951069D+00  0.300154755343D-02  0.563032498622D+00  0.300154755343D-02\n', '  0.566034046175D+00  0.300154755343D-02  0.569035593729D+00  0.300154755343D-02\n', '  0.572037141282D+00  0.300154755343D-02  0.575038688836D+00  0.300154755343D-02\n', '  0.578040236389D+00  0.300154755343D-02  0.581041783943D+00  0.300154755343D-02\n', '  0.584043331496D+00  0.300154755343D-02  0.587044879049D+00  0.300154755343D-02\n', '  0.590046426603D+00  0.300154755343D-02  0.593047974156D+00  0.300154755343D-02\n', '  0.596049521710D+00  0.300154755343D-02  0.599051069263D+00  0.300154755343D-02\n', '  0.602052616817D+00  0.300154755343D-02  0.605054164370D+00  0.300154755343D-02\n', '  0.608055711923D+00  0.300154755343D-02  0.611057259477D+00  0.300154755343D-02\n', '  0.614058807030D+00  0.300154755343D-02  0.617060354584D+00  0.300154755343D-02\n', '  0.620061902137D+00  0.300154755343D-02  0.623063449691D+00  0.300154755343D-02\n', '  0.626064997244D+00  0.300154755343D-02  0.629066544797D+00  0.300154755343D-02\n', '  0.632068092351D+00  0.300154755343D-02  0.635069639904D+00  0.300154755343D-02\n', '  0.638071187458D+00  0.300154755343D-02  0.641072735011D+00  0.300154755343D-02\n', '  0.644074282565D+00  0.300154755343D-02  0.647075830118D+00  0.300154755343D-02\n', '  0.650077377671D+00  0.300154755343D-02  0.653078925225D+00  0.300154755343D-02\n', '  0.656080472778D+00  0.300154755343D-02  0.659082020332D+00  0.300154755343D-02\n', '  0.662083567885D+00  0.300154755343D-02  0.665085115439D+00  0.300154755343D-02\n', '  0.668086662992D+00  0.300154755343D-02  0.671088210545D+00  0.300154755343D-02\n', '  0.674089758099D+00  0.300154755343D-02  0.677091305652D+00  0.300154755343D-02\n', '  0.680092853206D+00  0.300154755343D-02  0.683094400759D+00  0.300154755343D-02\n', '  0.686095948313D+00  0.300154755343D-02  0.689097495866D+00  0.300154755343D-02\n', '  0.692099043419D+00  0.300154755343D-02  0.695100590973D+00  0.300154755343D-02\n', '  0.698102138526D+00  0.300154755343D-02  0.701103686080D+00  0.300154755343D-02\n', '  0.704105233633D+00  0.300154755343D-02  0.707106781187D+00  0.300154755343D-02\n', '  0.707106781187D+00  0.294293745552D-02  0.710049718642D+00  0.294293745552D-02\n', '  0.712992656098D+00  0.294293745552D-02  0.715935593553D+00  0.294293745552D-02\n', '  0.718878531009D+00  0.294293745552D-02  0.721821468464D+00  0.294293745552D-02\n', '  0.724764405920D+00  0.294293745552D-02  0.727707343375D+00  0.294293745552D-02\n', '  0.730650280831D+00  0.294293745552D-02  0.733593218286D+00  0.294293745552D-02\n', '  0.736536155742D+00  0.294293745552D-02  0.739479093197D+00  0.294293745552D-02\n', '  0.742422030653D+00  0.294293745552D-02  0.745364968108D+00  0.294293745552D-02\n', '  0.748307905564D+00  0.294293745552D-02  0.751250843019D+00  0.294293745552D-02\n', '  0.754193780475D+00  0.294293745552D-02  0.757136717930D+00  0.294293745552D-02\n', '  0.760079655386D+00  0.294293745552D-02  0.763022592841D+00  0.294293745552D-02\n', '  0.765965530297D+00  0.294293745552D-02  0.768908467752D+00  0.294293745552D-02\n', '  0.771851405208D+00  0.294293745552D-02  0.774794342663D+00  0.294293745552D-02\n', '  0.777737280119D+00  0.294293745552D-02  0.780680217574D+00  0.294293745552D-02\n', '  0.783623155030D+00  0.294293745552D-02  0.786566092485D+00  0.294293745552D-02\n', '  0.789509029941D+00  0.294293745552D-02  0.792451967397D+00  0.294293745552D-02\n', '  0.795394904852D+00  0.294293745552D-02  0.798337842308D+00  0.294293745552D-02\n', '  0.801280779763D+00  0.294293745552D-02  0.804223717219D+00  0.294293745552D-02\n', '  0.807166654674D+00  0.294293745552D-02  0.810109592130D+00  0.294293745552D-02\n', '  0.813052529585D+00  0.294293745552D-02  0.815995467041D+00  0.294293745552D-02\n', '  0.818938404496D+00  0.294293745552D-02  0.821881341952D+00  0.294293745552D-02\n', '  0.824824279407D+00  0.294293745552D-02  0.827767216863D+00  0.294293745552D-02\n', '  0.830710154318D+00  0.294293745552D-02  0.833653091774D+00  0.294293745552D-02\n', '  0.836596029229D+00  0.294293745552D-02  0.839538966685D+00  0.294293745552D-02\n', '  0.842481904140D+00  0.294293745552D-02  0.845424841596D+00  0.294293745552D-02\n', '  0.848367779051D+00  0.294293745552D-02  0.851310716507D+00  0.294293745552D-02\n', '  0.854253653962D+00  0.294293745552D-02  0.857196591418D+00  0.294293745552D-02\n', '  0.860139528873D+00  0.294293745552D-02  0.863082466329D+00  0.294293745552D-02\n', '  0.866025403784D+00  0.294293745552D-02\n', '    8\n', '    1\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.348144740577D+01\n', '  0.341873998692D+01  0.335677212636D+01  0.329553081748D+01  0.323500335691D+01\n', '  0.317517733570D+01  0.311604063086D+01  0.305758139715D+01  0.299978805921D+01\n', '  0.294264930386D+01  0.288615407276D+01  0.283029155528D+01  0.277505118156D+01\n', '  0.272042261588D+01  0.266639575022D+01  0.261296069799D+01  0.256010778802D+01\n', '  0.250782755873D+01  0.245611075245D+01  0.240494831001D+01  0.235433136540D+01\n', '  0.230425124068D+01  0.225469944100D+01  0.220566764980D+01  0.215714772417D+01\n', '  0.210913169033D+01  0.206161173925D+01  0.201458022246D+01  0.196802964790D+01\n', '  0.192195267594D+01  0.187634211556D+01  0.183119092059D+01  0.178649218608D+01\n', '  0.174223914475D+01  0.169842516366D+01  0.165504374078D+01  0.161208850186D+01\n', '  0.156955319730D+01  0.152743169906D+01  0.148571799778D+01  0.144440619990D+01\n', '  0.140349052487D+01  0.136296530248D+01  0.132282497020D+01  0.128306407070D+01\n', '  0.124367724929D+01  0.120465925162D+01  0.116600492124D+01  0.112770919739D+01\n', '  0.108976711279D+01  0.105217379146D+01  0.101492444666D+01  0.978014378839D+00\n', '  0.941438973679D+00  0.905193700153D+00  0.869274108662D+00  0.833675829215D+00\n', '  0.798394569651D+00  0.763426113922D+00  0.728766320407D+00  0.694411120278D+00\n', '  0.660356515910D+00  0.626598579329D+00  0.593133450700D+00  0.559957336859D+00\n', '  0.527066509878D+00  0.494457305668D+00  0.462126122617D+00  0.430069420271D+00\n', '  0.430069420271D+00  0.402303316540D+00  0.377539313460D+00  0.354743340664D+00\n', '  0.333530457006D+00  0.313670769379D+00  0.295004615108D+00  0.277411710302D+00\n', '  0.260796664908D+00  0.245081108278D+00  0.230198970219D+00  0.216093447552D+00\n', '  0.202714947697D+00  0.190019635093D+00  0.177968368454D+00  0.166525901810D+00\n', '  0.155660269630D+00  0.145342304080D+00  0.135545249448D+00  0.126244449527D+00\n', '  0.117417090804D+00  0.109041989005D+00  0.101099409844D+00  0.935709170764D-01\n', '  0.864392426117D-01  0.796881746491D-01  0.733024606555D-01  0.672677226928D-01\n', '  0.615703830911D-01  0.561975988595D-01  0.511372035220D-01  0.463776553057D-01\n', '  0.419079907936D-01  0.377177833043D-01  0.337971053812D-01  0.301364948711D-01\n', '  0.267269241521D-01  0.235597721351D-01  0.206267987196D-01  0.179201214265D-01\n', '  0.154321939709D-01  0.131557865685D-01  0.110839677947D-01  0.921008784091D-02\n', '  0.752776303004D-02  0.603086146903D-02  0.471348973284D-02  0.356998048451D-02\n', '  0.259488094746D-02  0.178294215513D-02  0.112910891116D-02  0.628510400363D-03\n', '  0.276451396771D-03  0.684040205092D-04  0.457411886146D-13\n', '   21\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.107771580765D+00\n', ' -0.207927768303D+00 -0.300879928222D+00 -0.387017301583D+00 -0.466708260187D+00\n', ' -0.540301485561D+00 -0.608127076621D+00 -0.670497590656D+00 -0.727709021934D+00\n', ' -0.780041721948D+00 -0.827761265034D+00 -0.871119262839D+00 -0.910354130889D+00\n', ' -0.945691810260D+00 -0.977346447194D+00 -0.100552103326D+01 -0.103040800855D+01\n', ' -0.105218983014D+01 -0.107103950802D+01 -0.108712111043D+01 -0.110059024054D+01\n', ' -0.111159448612D+01 -0.112027384388D+01 -0.112676112010D+01 -0.113118230872D+01\n', ' -0.113365694857D+01 -0.113429846067D+01 -0.113321446694D+01 -0.113050709147D+01\n', ' -0.112627324514D+01 -0.112060489489D+01 -0.111358931816D+01 -0.110530934371D+01\n', ' -0.109584357938D+01 -0.108526662757D+01 -0.107364928929D+01 -0.106105875719D+01\n', ' -0.104755879842D+01 -0.103320992775D+01 -0.101806957159D+01 -0.100219222331D+01\n', ' -0.985629590493D+00 -0.968430734425D+00 -0.950642202363D+00 -0.932308152903D+00\n', ' -0.913470474873D+00 -0.894168900091D+00 -0.874441110314D+00 -0.854322838707D+00\n', ' -0.833847966132D+00 -0.813048612513D+00 -0.791955223572D+00 -0.770596653163D+00\n', ' -0.749000241447D+00 -0.727191889129D+00 -0.705196127964D+00 -0.683036187733D+00\n', ' -0.660734059870D+00 -0.638310557917D+00 -0.615785374981D+00 -0.593177138329D+00\n', ' -0.570503461300D+00 -0.547780992645D+00 -0.525025463440D+00 -0.502251731701D+00\n', ' -0.479473824810D+00 -0.456704979869D+00 -0.433957682089D+00 -0.411243701307D+00\n', ' -0.411243701307D+00 -0.390528872452D+00 -0.371153728294D+00 -0.352708702956D+00\n', ' -0.335055250348D+00 -0.318115790182D+00 -0.301838817656D+00 -0.286186587040D+00\n', ' -0.271129514420D+00 -0.256643242282D+00 -0.242706948687D+00 -0.229302306517D+00\n', ' -0.216412810451D+00 -0.204023324895D+00 -0.192119771086D+00 -0.180688905193D+00\n', ' -0.169718157817D+00 -0.159195515938D+00 -0.149109434868D+00 -0.139448771777D+00\n', ' -0.130202734970D+00 -0.121360844815D+00 -0.112912903371D+00 -0.104848970587D+00\n', ' -0.971593454900D-01 -0.898345511834D-01 -0.828653227895D-01 -0.762425976473D-01\n', ' -0.699575072669D-01 -0.640013706413D-01 -0.583656886141D-01 -0.530421390663D-01\n', ' -0.480225727376D-01 -0.432990095404D-01 -0.388636352520D-01 -0.347087984988D-01\n', ' -0.308270079625D-01 -0.272109297547D-01 -0.238533849179D-01 -0.207473470199D-01\n', ' -0.178859398176D-01 -0.152624349680D-01 -0.128702497753D-01 -0.107029449600D-01\n', ' -0.875422244382D-02 -0.701792314373D-02 -0.548802477161D-02 -0.415863963680D-02\n', ' -0.302401245044D-02 -0.207851813067D-02 -0.131665960939D-02 -0.733065640768D-03\n', ' -0.322488612760D-03 -0.798023629498D-04 -0.130951788091D-13\n', '   25\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.910836100221D-01\n', ' -0.175731038058D+00 -0.254289951499D+00 -0.327089319087D+00 -0.394440471814D+00\n', ' -0.456638099358D+00 -0.513961186222D+00 -0.566673891528D+00 -0.615026376092D+00\n', ' -0.659255580170D+00 -0.699585955043D+00 -0.736230151364D+00 -0.769389667030D+00\n', ' -0.799255457103D+00 -0.826008508190D+00 -0.849820379482D+00 -0.870853712536D+00\n', ' -0.889262711727D+00 -0.905193597184D+00 -0.918785031886D+00 -0.930168524507D+00\n', ' -0.939468809474D+00 -0.946804205618D+00 -0.952286954712D+00 -0.956023541090D+00\n', ' -0.958114993490D+00 -0.958657170165D+00 -0.957741028255D+00 -0.955452878353D+00\n', ' -0.951874625121D+00 -0.947083994787D+00 -0.941154750263D+00 -0.934156894630D+00\n', ' -0.926156863626D+00 -0.917217707805D+00 -0.907399264928D+00 -0.896758323153D+00\n', ' -0.885348775560D+00 -0.873221766467D+00 -0.860425830039D+00 -0.847007021587D+00\n', ' -0.833009041991D+00 -0.818473355609D+00 -0.803439302052D+00 -0.787944202144D+00\n', ' -0.772023458408D+00 -0.755710650358D+00 -0.739037624891D+00 -0.722034582045D+00\n', ' -0.704730156373D+00 -0.687151494166D+00 -0.669324326756D+00 -0.651273040100D+00\n', ' -0.633020740852D+00 -0.614589319101D+00 -0.595999507967D+00 -0.577270940196D+00\n', ' -0.558422201943D+00 -0.539470883862D+00 -0.520433629664D+00 -0.501326182266D+00\n', ' -0.482163427655D+00 -0.462959436593D+00 -0.443727504267D+00 -0.424480187992D+00\n', ' -0.405229343069D+00 -0.385986156892D+00 -0.366761181390D+00 -0.347564363890D+00\n', ' -0.347564363890D+00 -0.330057138148D+00 -0.313682152626D+00 -0.298093260983D+00\n', ' -0.283173370401D+00 -0.268856913569D+00 -0.255100360984D+00 -0.241871811683D+00\n', ' -0.229146262694D+00 -0.216903128162D+00 -0.205124810335D+00 -0.193795819972D+00\n', ' -0.182902207530D+00 -0.172431181099D+00 -0.162370841951D+00 -0.152709997006D+00\n', ' -0.143438023184D+00 -0.134544767629D+00 -0.126020473299D+00 -0.117855722784D+00\n', ' -0.110041395437D+00 -0.102568634352D+00 -0.954288206976D-01 -0.886135535959D-01\n', ' -0.821146342275D-01 -0.759240531543D-01 -0.700339801250D-01 -0.644367557932D-01\n', ' -0.591248849168D-01 -0.540910307059D-01 -0.493280100624D-01 -0.448287895118D-01\n', ' -0.405864816722D-01 -0.365943421386D-01 -0.328457666874D-01 -0.293342887278D-01\n', ' -0.260535769401D-01 -0.229974330573D-01 -0.201597897530D-01 -0.175347086082D-01\n', ' -0.151163781367D-01 -0.128991118507D-01 -0.108773463570D-01 -0.904563947108D-02\n', ' -0.739866834524D-02 -0.593122760428D-02 -0.463822748578D-02 -0.351469198292D-02\n', ' -0.255575698884D-02 -0.175666844166D-02 -0.111278047091D-02 -0.619553545292D-03\n', ' -0.272552623174D-03 -0.674453065838D-04 -0.112512836764D-13\n', '   43\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.268444513742D-01\n', ' -0.500548066307D-01 -0.699457900360D-01 -0.868078731501D-01 -0.100909115568D+00\n', ' -0.112496862702D+00 -0.121799312141D+00 -0.129026959167D+00 -0.134373931089D+00\n', ' -0.138019219277D+00 -0.140127817026D+00 -0.140851770688D+00 -0.140331150927D+00\n', ' -0.138694950372D+00 -0.136061913408D+00 -0.132541303434D+00 -0.128233612407D+00\n', ' -0.123231217174D+00 -0.117618986681D+00 -0.111474843842D+00 -0.104870285545D+00\n', ' -0.978708639919D-01 -0.905366323184D-01 -0.829225572075D-01 -0.750789009913D-01\n', ' -0.670515755483D-01 -0.588824701153D-01 -0.506097549736D-01 -0.422681628129D-01\n', ' -0.338892494404D-01 -0.255016353702D-01 -0.171312297148D-01 -0.880143768684D-02\n', ' -0.533352923024D-03  0.765406425161D-02  0.157438215857D-01  0.237207417339D-01\n', '  0.315713202766D-01  0.392835941091D-01  0.468470194448D-01  0.542523587328D-01\n', '  0.614915758422D-01  0.685577389142D-01  0.754449303262D-01  0.821481632554D-01\n', '  0.886633043631D-01  0.949870021620D-01  0.101116620654D+00  0.107050177862D+00\n', '  0.112786288906D+00  0.118324113288D+00  0.123663306099D+00  0.128803972858D+00\n', '  0.133746627717D+00  0.138492154809D+00  0.143041772497D+00  0.147397000323D+00\n', '  0.151559628473D+00  0.155531689558D+00  0.159315432565D+00  0.162913298813D+00\n', '  0.166327899774D+00  0.169561996620D+00  0.172618481381D+00  0.175500359595D+00\n', '  0.178210734336D+00  0.180752791535D+00  0.183129786488D+00  0.185345031472D+00\n', '  0.185345031472D+00  0.184931678626D+00  0.182571003170D+00  0.179102705992D+00\n', '  0.174861661976D+00  0.170054289762D+00  0.164825839363D+00  0.159285689158D+00\n', '  0.153519615050D+00  0.147596680139D+00  0.141573498882D+00  0.135497066883D+00\n', '  0.129406739952D+00  0.123335675859D+00  0.117311919408D+00  0.111359240949D+00\n', '  0.105497798650D+00  0.997446711754D-01  0.941142927526D-01  0.886188131823D-01\n', '  0.832683990877D-01  0.780714884291D-01  0.730350073337D-01  0.681645561664D-01\n', '  0.634645702171D-01  0.589384592422D-01  0.545887292324D-01  0.504170891306D-01\n', '  0.464245447124D-01  0.426114814506D-01  0.389777378725D-01  0.355226706676D-01\n', '  0.322452126076D-01  0.291439241729D-01  0.262170396519D-01  0.234625083646D-01\n', '  0.208780315749D-01  0.184610955785D-01  0.162090013874D-01  0.141188913829D-01\n', '  0.121877732559D-01  0.104125415219D-01  0.878999685767D-02  0.731686348191D-02\n', '  0.598980477569D-02  0.480543731577D-02  0.376034347671D-02  0.285108273952D-02\n', '  0.207420183130D-02  0.142624380619D-02  0.903756167956D-03  0.503298123378D-03\n', '  0.221447047829D-03  0.548042354075D-04  0.212654742276D-13\n', '   47\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.710237424182D-01\n', '  0.132432570268D+00  0.185059165691D+00  0.229672044198D+00  0.266980424813D+00\n', '  0.297638721984D+00  0.322250689785D+00  0.341373246380D+00  0.355520004351D+00\n', '  0.365164530355D+00  0.370743355613D+00  0.372658756962D+00  0.371281326549D+00\n', '  0.366952346784D+00  0.359985985786D+00  0.350671327331D+00  0.339274248149D+00\n', '  0.326039154403D+00  0.311190588218D+00  0.294934714247D+00  0.277460695473D+00\n', '  0.258941966722D+00  0.239537413656D+00  0.219392464448D+00  0.198640100731D+00\n', '  0.177401793916D+00  0.155788372506D+00  0.133900825574D+00  0.111831047179D+00\n', '  0.896625261379D-01  0.674709852150D-01  0.453249734781D-01  0.232864152992D-01\n', '  0.141111919535D-02 -0.202507505287D-01 -0.416542366014D-01 -0.627591835418D-01\n', ' -0.835298620138D-01 -0.103934620617D+00 -0.123945563116D+00 -0.143538249246D+00\n', ' -0.162691417404D+00 -0.181386727616D+00 -0.199608523324D+00 -0.217343610635D+00\n', ' -0.234581053762D+00 -0.251311985504D+00 -0.267529431666D+00 -0.283228148429D+00\n', ' -0.298404471743D+00 -0.313056177862D+00 -0.327182354243D+00 -0.340783280060D+00\n', ' -0.353860315633D+00 -0.366415800159D+00 -0.378452957120D+00 -0.389975806852D+00\n', ' -0.400989085737D+00 -0.411498171559D+00 -0.421509014581D+00 -0.431028073925D+00\n', ' -0.440062258894D+00 -0.448618874864D+00 -0.456705573429D+00 -0.464330306491D+00\n', ' -0.471501284016D+00 -0.478226935182D+00 -0.484515872695D+00 -0.490376860015D+00\n', ' -0.490376860015D+00 -0.489283231183D+00 -0.483037471001D+00 -0.473861219194D+00\n', ' -0.462640471428D+00 -0.449921360090D+00 -0.436088180592D+00 -0.421430320923D+00\n', ' -0.406174722792D+00 -0.390504109986D+00 -0.374568270278D+00 -0.358491542350D+00\n', ' -0.342378051888D+00 -0.326315526106D+00 -0.310378164577D+00 -0.294628857739D+00\n', ' -0.279120939092D+00 -0.263899594534D+00 -0.249003013440D+00 -0.234463341162D+00\n', ' -0.220307476057D+00 -0.206557742868D+00 -0.193232466407D+00 -0.180346463845D+00\n', ' -0.167911469858D+00 -0.155936505812D+00 -0.144428201936D+00 -0.133391079667D+00\n', ' -0.122827800038D+00 -0.112739382914D+00 -0.103125401078D+00 -0.939841524914D-01\n', ' -0.853128135320D-01 -0.771075755900D-01 -0.693637670313D-01 -0.620759622664D-01\n', ' -0.552380794118D-01 -0.488434678304D-01 -0.428849866719D-01 -0.373550753871D-01\n', ' -0.322458170709D-01 -0.275489953832D-01 -0.232561457104D-01 -0.193586011502D-01\n', ' -0.158475338383D-01 -0.127139920785D-01 -0.994893368355D-02 -0.754325589604D-02\n', ' -0.548782221457D-02 -0.377348642013D-02 -0.239111406624D-02 -0.133160166979D-02\n', ' -0.585893817112D-03 -0.144998377667D-03 -0.576892540902D-13\n', '   73\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.120919961757D+00\n', ' -0.214786820424D+00 -0.285128512040D+00 -0.335095657689D+00 -0.367499098133D+00\n', ' -0.384843759298D+00 -0.389359210512D+00 -0.383027240913D+00 -0.367606746704D+00\n', ' -0.344656192610D+00 -0.315553884595D+00 -0.281516267282D+00 -0.243614438314D+00\n', ' -0.202789052911D+00 -0.159863774732D+00 -0.115557413810D+00 -0.704948785238D-01\n', ' -0.252170561122D-01  0.198102749088D-01  0.641884071634D-01  0.107578457441D+00\n', '  0.149694834283D+00  0.190299351434D+00  0.229195925094D+00  0.266225798879D+00\n', '  0.301263245802D+00  0.334211701450D+00  0.365000286900D+00  0.393580683926D+00\n', '  0.419924328576D+00  0.444019892484D+00  0.465871024148D+00  0.485494325107D+00\n', '  0.502917538266D+00  0.518177927851D+00  0.531320832352D+00  0.542398373649D+00\n', '  0.551468307049D+00  0.558592998456D+00  0.563838516178D+00  0.567273826059D+00\n', '  0.568970079710D+00  0.568999986582D+00  0.567437261474D+00  0.564356139923D+00\n', '  0.559830954572D+00  0.553935766337D+00  0.546744044736D+00  0.538328392293D+00\n', '  0.528760308437D+00  0.518109988718D+00  0.506446155605D+00  0.493835917454D+00\n', '  0.480344652589D+00  0.466035915721D+00  0.450971364214D+00  0.435210701935D+00\n', '  0.418811638652D+00  0.401829863159D+00  0.384319028467D+00  0.366330747570D+00\n', '  0.347914598470D+00  0.329118137231D+00  0.309986918002D+00  0.290564519036D+00\n', '  0.270892573831D+00  0.251010806625D+00  0.230957071537D+00  0.210767394748D+00\n', '  0.210767394748D+00  0.194872722910D+00  0.181954147621D+00  0.170720796879D+00\n', '  0.160691324308D+00  0.151585755783D+00  0.143217785841D+00  0.135454581775D+00\n', '  0.128197437948D+00  0.121371007313D+00  0.114916705224D+00  0.108788385526D+00\n', '  0.102949360099D+00  0.973702639649D-01  0.920274795158D-01  0.869019453892D-01\n', '  0.819782387537D-01  0.772438572460D-01  0.726886500433D-01  0.683043625011D-01\n', '  0.640842686815D-01  0.600228728605D-01  0.561156658172D-01  0.523589250768D-01\n', '  0.487495507301D-01  0.452849302651D-01  0.419628272086D-01  0.387812894162D-01\n', '  0.357385736489D-01  0.328330837010D-01  0.300633198412D-01  0.274278377140D-01\n', '  0.249252151739D-01  0.225540257744D-01  0.203128178425D-01  0.182000982443D-01\n', '  0.162143200854D-01  0.143538737057D-01  0.126170804319D-01  0.110021886245D-01\n', '  0.950737163371D-02  0.813072732961D-02  0.687027892533D-02  0.572397685272D-02\n', '  0.468970148569D-02  0.376526653556D-02  0.294842297179D-02  0.223686334081D-02\n', '  0.162822637464D-02  0.112010180264D-02  0.710035283844D-03  0.395533403271D-03\n', '  0.174068670187D-03  0.430844801113D-04 -0.125071680895D-12\n', '   77\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.643071732209D-01\n', ' -0.114227072733D+00 -0.151635911453D+00 -0.178209240157D+00 -0.195441909001D+00\n', ' -0.204666077730D+00 -0.207067467039D+00 -0.203700024146D+00 -0.195499158236D+00\n', ' -0.183293685821D+00 -0.167816612099D+00 -0.149714861810D+00 -0.129558061846D+00\n', ' -0.107846467724D+00 -0.850181169764D-01 -0.614552842961D-01 -0.374903059721D-01\n', ' -0.134108345054D-01  0.105354216260D-01  0.341364234511D-01  0.572119474482D-01\n', '  0.796101115036D-01  0.101204244350D+00  0.121890065481D+00  0.141583145707D+00\n', '  0.160216621403D+00  0.177739138065D+00  0.194113001148D+00  0.209312514243D+00\n', '  0.223322486585D+00  0.236136893566D+00  0.247757675516D+00  0.258193661399D+00\n', '  0.267459605338D+00  0.275575325044D+00  0.282564932253D+00  0.288456146215D+00\n', '  0.293279682129D+00  0.297068707182D+00  0.299858357558D+00  0.301685310398D+00\n', '  0.302587405270D+00  0.302603310223D+00  0.301772227971D+00  0.300133638159D+00\n', '  0.297727072080D+00  0.294591916516D+00  0.290767243732D+00  0.286291664915D+00\n', '  0.281203204606D+00  0.275539193924D+00  0.269336180580D+00  0.262629853871D+00\n', '  0.255454983039D+00  0.247845367497D+00  0.239833797619D+00  0.231452024878D+00\n', '  0.222730740254D+00  0.213699559940D+00  0.204387017466D+00  0.194820561451D+00\n', '  0.185026558269D+00  0.175030298997D+00  0.164856010062D+00  0.154526867078D+00\n', '  0.144065011405D+00  0.133491569030D+00  0.122826671379D+00  0.112089477754D+00\n', '  0.112089477754D+00  0.103636436582D+00  0.967661312431D-01  0.907920553210D-01\n', '  0.854582211008D-01  0.806157338563D-01  0.761655133573D-01  0.720369170416D-01\n', '  0.681774516694D-01  0.645470464748D-01  0.611145452033D-01  0.578554065912D-01\n', '  0.547501193073D-01  0.517830665868D-01  0.489416882068D-01  0.462158470294D-01\n', '  0.435973409458D-01  0.410795209987D-01  0.386569888181D-01  0.363253544515D-01\n', '  0.340810409377D-01  0.319211255624D-01  0.298432102497D-01  0.278453153280D-01\n', '  0.259257922156D-01  0.240832515371D-01  0.223165039000D-01  0.206245111227D-01\n', '  0.190063461227D-01  0.174611600124D-01  0.159881552105D-01  0.145865635856D-01\n', '  0.132556288181D-01  0.119945923008D-01  0.108026820106D-01  0.967910387520D-02\n', '  0.862303523121D-02  0.763362003566D-02  0.670996554319D-02  0.585114020384D-02\n', '  0.505617257596D-02  0.432405107641D-02  0.365372441826D-02  0.304410260828D-02\n', '  0.249405839542D-02  0.200242907626D-02  0.156801858040D-02  0.118959976698D-02\n', '  0.865916875895D-03  0.595688086562D-03  0.377608141186D-03  0.210351001681D-03\n', '  0.925725079864D-04  0.229130169002D-04 -0.594900858547D-13\n', '   81\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.979799203734D-01\n', ' -0.174039052415D+00 -0.231036038218D+00 -0.271523786318D+00 -0.297779885546D+00\n', ' -0.311834045795D+00 -0.315492858980D+00 -0.310362143852D+00 -0.297867111826D+00\n', ' -0.279270567219D+00 -0.255689333976D+00 -0.228109081836D+00 -0.197397707714D+00\n', ' -0.164317412676D+00 -0.129535600998D+00 -0.936347153865D-01 -0.571211112219D-01\n', ' -0.204330626145D-01  0.160520159776D-01  0.520110569948D-01  0.871694676443D-01\n', '  0.121295836768D+00  0.154197165048D+00  0.185714568251D+00  0.215719408081D+00\n', '  0.244109809548D+00  0.270807527723D+00  0.295755130311D+00  0.318913465661D+00\n', '  0.340259388763D+00  0.359783720384D+00  0.377489416858D+00  0.393389930201D+00\n', '  0.407507740141D+00  0.419873041409D+00  0.430522571212D+00  0.439498563251D+00\n', '  0.446847815925D+00  0.452620863540D+00  0.456871240411D+00  0.459654828693D+00\n', '  0.461029281639D+00  0.461053514800D+00  0.459787258350D+00  0.457290664405D+00\n', '  0.453623963772D+00  0.448847167075D+00  0.443019805740D+00  0.436200708676D+00\n', '  0.428447810968D+00  0.419817991186D+00  0.410366934280D+00  0.400149017304D+00\n', '  0.389217215491D+00  0.377623026420D+00  0.365416410278D+00  0.352645744354D+00\n', '  0.339357790146D+00  0.325597671582D+00  0.311408863019D+00  0.296833185816D+00\n', '  0.281910812404D+00  0.266680276860D+00  0.251178491138D+00  0.235440766146D+00\n', '  0.219500836983D+00  0.203390891699D+00  0.187141603008D+00  0.170782162470D+00\n', '  0.170782162470D+00  0.157902910290D+00  0.147435151619D+00  0.138332909150D+00\n', '  0.130206153984D+00  0.122828026618D+00  0.116047566083D+00  0.109757139712D+00\n', '  0.103876767571D+00  0.983453969002D-01  0.931155572972D-01  0.881498571163D-01\n', '  0.834185684345D-01  0.788978971823D-01  0.745687063085D-01  0.704155506318D-01\n', '  0.664259332265D-01  0.625897235849D-01  0.588986966237D-01  0.553461637082D-01\n', '  0.519266748958D-01  0.486357770709D-01  0.454698164684D-01  0.424257768139D-01\n', '  0.395011462901D-01  0.366938080115D-01  0.340019497921D-01  0.314239898339D-01\n', '  0.289585156121D-01  0.266042337418D-01  0.243599290092D-01  0.222244310713D-01\n', '  0.201965875819D-01  0.182752427090D-01  0.164592201804D-01  0.147473101285D-01\n', '  0.131382591244D-01  0.116307628806D-01  0.102234611895D-01  0.891493471958D-02\n', '  0.770370335957D-02  0.658822583760D-02  0.556690038820D-02  0.463806627207D-02\n', '  0.380000598301D-02  0.305094799877D-02  0.238906995839D-02  0.181250216122D-02\n', '  0.131933130164D-02  0.907604367683D-03  0.575332637913D-03  0.320495729523D-03\n', '  0.141045648670D-03  0.349108110181D-04 -0.908372818246D-13\n', '    3  135 NPAN,MESHN;  Shape number     1;     # serial: voro_v1.0-16-g2d2b8f1_serial_20180516213647\n', '   10   70   55\n', '  0.495000000000D+00  0.555555555556D-03  0.495555555556D+00  0.555555555556D-03\n', '  0.496111111111D+00  0.555555555556D-03  0.496666666667D+00  0.555555555556D-03\n', '  0.497222222222D+00  0.555555555556D-03  0.497777777778D+00  0.555555555556D-03\n', '  0.498333333333D+00  0.555555555556D-03  0.498888888889D+00  0.555555555556D-03\n', '  0.499444444444D+00  0.555555555556D-03  0.500000000000D+00  0.555555555556D-03\n', '  0.500000000000D+00  0.300154755343D-02  0.503001547553D+00  0.300154755343D-02\n', '  0.506003095107D+00  0.300154755343D-02  0.509004642660D+00  0.300154755343D-02\n', '  0.512006190214D+00  0.300154755343D-02  0.515007737767D+00  0.300154755343D-02\n', '  0.518009285321D+00  0.300154755343D-02  0.521010832874D+00  0.300154755343D-02\n', '  0.524012380427D+00  0.300154755343D-02  0.527013927981D+00  0.300154755343D-02\n', '  0.530015475534D+00  0.300154755343D-02  0.533017023088D+00  0.300154755343D-02\n', '  0.536018570641D+00  0.300154755343D-02  0.539020118195D+00  0.300154755343D-02\n', '  0.542021665748D+00  0.300154755343D-02  0.545023213301D+00  0.300154755343D-02\n', '  0.548024760855D+00  0.300154755343D-02  0.551026308408D+00  0.300154755343D-02\n', '  0.554027855962D+00  0.300154755343D-02  0.557029403515D+00  0.300154755343D-02\n', '  0.560030951069D+00  0.300154755343D-02  0.563032498622D+00  0.300154755343D-02\n', '  0.566034046175D+00  0.300154755343D-02  0.569035593729D+00  0.300154755343D-02\n', '  0.572037141282D+00  0.300154755343D-02  0.575038688836D+00  0.300154755343D-02\n', '  0.578040236389D+00  0.300154755343D-02  0.581041783943D+00  0.300154755343D-02\n', '  0.584043331496D+00  0.300154755343D-02  0.587044879049D+00  0.300154755343D-02\n', '  0.590046426603D+00  0.300154755343D-02  0.593047974156D+00  0.300154755343D-02\n', '  0.596049521710D+00  0.300154755343D-02  0.599051069263D+00  0.300154755343D-02\n', '  0.602052616817D+00  0.300154755343D-02  0.605054164370D+00  0.300154755343D-02\n', '  0.608055711923D+00  0.300154755343D-02  0.611057259477D+00  0.300154755343D-02\n', '  0.614058807030D+00  0.300154755343D-02  0.617060354584D+00  0.300154755343D-02\n', '  0.620061902137D+00  0.300154755343D-02  0.623063449691D+00  0.300154755343D-02\n', '  0.626064997244D+00  0.300154755343D-02  0.629066544797D+00  0.300154755343D-02\n', '  0.632068092351D+00  0.300154755343D-02  0.635069639904D+00  0.300154755343D-02\n', '  0.638071187458D+00  0.300154755343D-02  0.641072735011D+00  0.300154755343D-02\n', '  0.644074282565D+00  0.300154755343D-02  0.647075830118D+00  0.300154755343D-02\n', '  0.650077377671D+00  0.300154755343D-02  0.653078925225D+00  0.300154755343D-02\n', '  0.656080472778D+00  0.300154755343D-02  0.659082020332D+00  0.300154755343D-02\n', '  0.662083567885D+00  0.300154755343D-02  0.665085115439D+00  0.300154755343D-02\n', '  0.668086662992D+00  0.300154755343D-02  0.671088210545D+00  0.300154755343D-02\n', '  0.674089758099D+00  0.300154755343D-02  0.677091305652D+00  0.300154755343D-02\n', '  0.680092853206D+00  0.300154755343D-02  0.683094400759D+00  0.300154755343D-02\n', '  0.686095948313D+00  0.300154755343D-02  0.689097495866D+00  0.300154755343D-02\n', '  0.692099043419D+00  0.300154755343D-02  0.695100590973D+00  0.300154755343D-02\n', '  0.698102138526D+00  0.300154755343D-02  0.701103686080D+00  0.300154755343D-02\n', '  0.704105233633D+00  0.300154755343D-02  0.707106781187D+00  0.300154755343D-02\n', '  0.707106781187D+00  0.294293745552D-02  0.710049718642D+00  0.294293745552D-02\n', '  0.712992656098D+00  0.294293745552D-02  0.715935593553D+00  0.294293745552D-02\n', '  0.718878531009D+00  0.294293745552D-02  0.721821468464D+00  0.294293745552D-02\n', '  0.724764405920D+00  0.294293745552D-02  0.727707343375D+00  0.294293745552D-02\n', '  0.730650280831D+00  0.294293745552D-02  0.733593218286D+00  0.294293745552D-02\n', '  0.736536155742D+00  0.294293745552D-02  0.739479093197D+00  0.294293745552D-02\n', '  0.742422030653D+00  0.294293745552D-02  0.745364968108D+00  0.294293745552D-02\n', '  0.748307905564D+00  0.294293745552D-02  0.751250843019D+00  0.294293745552D-02\n', '  0.754193780475D+00  0.294293745552D-02  0.757136717930D+00  0.294293745552D-02\n', '  0.760079655386D+00  0.294293745552D-02  0.763022592841D+00  0.294293745552D-02\n', '  0.765965530297D+00  0.294293745552D-02  0.768908467752D+00  0.294293745552D-02\n', '  0.771851405208D+00  0.294293745552D-02  0.774794342663D+00  0.294293745552D-02\n', '  0.777737280119D+00  0.294293745552D-02  0.780680217574D+00  0.294293745552D-02\n', '  0.783623155030D+00  0.294293745552D-02  0.786566092485D+00  0.294293745552D-02\n', '  0.789509029941D+00  0.294293745552D-02  0.792451967397D+00  0.294293745552D-02\n', '  0.795394904852D+00  0.294293745552D-02  0.798337842308D+00  0.294293745552D-02\n', '  0.801280779763D+00  0.294293745552D-02  0.804223717219D+00  0.294293745552D-02\n', '  0.807166654674D+00  0.294293745552D-02  0.810109592130D+00  0.294293745552D-02\n', '  0.813052529585D+00  0.294293745552D-02  0.815995467041D+00  0.294293745552D-02\n', '  0.818938404496D+00  0.294293745552D-02  0.821881341952D+00  0.294293745552D-02\n', '  0.824824279407D+00  0.294293745552D-02  0.827767216863D+00  0.294293745552D-02\n', '  0.830710154318D+00  0.294293745552D-02  0.833653091774D+00  0.294293745552D-02\n', '  0.836596029229D+00  0.294293745552D-02  0.839538966685D+00  0.294293745552D-02\n', '  0.842481904140D+00  0.294293745552D-02  0.845424841596D+00  0.294293745552D-02\n', '  0.848367779051D+00  0.294293745552D-02  0.851310716507D+00  0.294293745552D-02\n', '  0.854253653962D+00  0.294293745552D-02  0.857196591418D+00  0.294293745552D-02\n', '  0.860139528873D+00  0.294293745552D-02  0.863082466329D+00  0.294293745552D-02\n', '  0.866025403784D+00  0.294293745552D-02\n', '    8\n', '    1\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01\n', '  0.354490770181D+01  0.354490770181D+01  0.354490770181D+01  0.348144740577D+01\n', '  0.341873998692D+01  0.335677212636D+01  0.329553081748D+01  0.323500335691D+01\n', '  0.317517733570D+01  0.311604063086D+01  0.305758139715D+01  0.299978805921D+01\n', '  0.294264930386D+01  0.288615407276D+01  0.283029155528D+01  0.277505118156D+01\n', '  0.272042261588D+01  0.266639575022D+01  0.261296069799D+01  0.256010778802D+01\n', '  0.250782755873D+01  0.245611075245D+01  0.240494831001D+01  0.235433136540D+01\n', '  0.230425124068D+01  0.225469944100D+01  0.220566764980D+01  0.215714772417D+01\n', '  0.210913169033D+01  0.206161173925D+01  0.201458022246D+01  0.196802964790D+01\n', '  0.192195267594D+01  0.187634211556D+01  0.183119092059D+01  0.178649218608D+01\n', '  0.174223914475D+01  0.169842516366D+01  0.165504374078D+01  0.161208850186D+01\n', '  0.156955319730D+01  0.152743169906D+01  0.148571799778D+01  0.144440619990D+01\n', '  0.140349052487D+01  0.136296530248D+01  0.132282497020D+01  0.128306407070D+01\n', '  0.124367724929D+01  0.120465925162D+01  0.116600492124D+01  0.112770919739D+01\n', '  0.108976711279D+01  0.105217379146D+01  0.101492444666D+01  0.978014378839D+00\n', '  0.941438973679D+00  0.905193700153D+00  0.869274108662D+00  0.833675829215D+00\n', '  0.798394569651D+00  0.763426113922D+00  0.728766320407D+00  0.694411120278D+00\n', '  0.660356515910D+00  0.626598579329D+00  0.593133450700D+00  0.559957336859D+00\n', '  0.527066509878D+00  0.494457305668D+00  0.462126122617D+00  0.430069420271D+00\n', '  0.430069420271D+00  0.402303316540D+00  0.377539313460D+00  0.354743340664D+00\n', '  0.333530457006D+00  0.313670769379D+00  0.295004615108D+00  0.277411710302D+00\n', '  0.260796664908D+00  0.245081108278D+00  0.230198970219D+00  0.216093447552D+00\n', '  0.202714947697D+00  0.190019635093D+00  0.177968368454D+00  0.166525901810D+00\n', '  0.155660269630D+00  0.145342304080D+00  0.135545249448D+00  0.126244449527D+00\n', '  0.117417090804D+00  0.109041989005D+00  0.101099409844D+00  0.935709170764D-01\n', '  0.864392426117D-01  0.796881746491D-01  0.733024606555D-01  0.672677226928D-01\n', '  0.615703830911D-01  0.561975988595D-01  0.511372035220D-01  0.463776553057D-01\n', '  0.419079907936D-01  0.377177833043D-01  0.337971053812D-01  0.301364948711D-01\n', '  0.267269241521D-01  0.235597721351D-01  0.206267987196D-01  0.179201214265D-01\n', '  0.154321939709D-01  0.131557865685D-01  0.110839677947D-01  0.921008784091D-02\n', '  0.752776303004D-02  0.603086146903D-02  0.471348973284D-02  0.356998048451D-02\n', '  0.259488094746D-02  0.178294215513D-02  0.112910891116D-02  0.628510400363D-03\n', '  0.276451396771D-03  0.684040205092D-04  0.457411886146D-13\n', '   21\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.107771580765D+00\n', ' -0.207927768303D+00 -0.300879928222D+00 -0.387017301583D+00 -0.466708260187D+00\n', ' -0.540301485561D+00 -0.608127076621D+00 -0.670497590656D+00 -0.727709021934D+00\n', ' -0.780041721948D+00 -0.827761265034D+00 -0.871119262839D+00 -0.910354130889D+00\n', ' -0.945691810260D+00 -0.977346447194D+00 -0.100552103326D+01 -0.103040800855D+01\n', ' -0.105218983014D+01 -0.107103950802D+01 -0.108712111043D+01 -0.110059024054D+01\n', ' -0.111159448612D+01 -0.112027384388D+01 -0.112676112010D+01 -0.113118230872D+01\n', ' -0.113365694857D+01 -0.113429846067D+01 -0.113321446694D+01 -0.113050709147D+01\n', ' -0.112627324514D+01 -0.112060489489D+01 -0.111358931816D+01 -0.110530934371D+01\n', ' -0.109584357938D+01 -0.108526662757D+01 -0.107364928929D+01 -0.106105875719D+01\n', ' -0.104755879842D+01 -0.103320992775D+01 -0.101806957159D+01 -0.100219222331D+01\n', ' -0.985629590493D+00 -0.968430734425D+00 -0.950642202363D+00 -0.932308152903D+00\n', ' -0.913470474873D+00 -0.894168900091D+00 -0.874441110314D+00 -0.854322838707D+00\n', ' -0.833847966132D+00 -0.813048612513D+00 -0.791955223572D+00 -0.770596653163D+00\n', ' -0.749000241447D+00 -0.727191889129D+00 -0.705196127964D+00 -0.683036187733D+00\n', ' -0.660734059870D+00 -0.638310557917D+00 -0.615785374981D+00 -0.593177138329D+00\n', ' -0.570503461300D+00 -0.547780992645D+00 -0.525025463440D+00 -0.502251731701D+00\n', ' -0.479473824810D+00 -0.456704979869D+00 -0.433957682089D+00 -0.411243701307D+00\n', ' -0.411243701307D+00 -0.390528872452D+00 -0.371153728294D+00 -0.352708702956D+00\n', ' -0.335055250348D+00 -0.318115790182D+00 -0.301838817656D+00 -0.286186587040D+00\n', ' -0.271129514420D+00 -0.256643242282D+00 -0.242706948687D+00 -0.229302306517D+00\n', ' -0.216412810451D+00 -0.204023324895D+00 -0.192119771086D+00 -0.180688905193D+00\n', ' -0.169718157817D+00 -0.159195515938D+00 -0.149109434868D+00 -0.139448771777D+00\n', ' -0.130202734970D+00 -0.121360844815D+00 -0.112912903371D+00 -0.104848970587D+00\n', ' -0.971593454900D-01 -0.898345511834D-01 -0.828653227895D-01 -0.762425976473D-01\n', ' -0.699575072669D-01 -0.640013706413D-01 -0.583656886141D-01 -0.530421390663D-01\n', ' -0.480225727376D-01 -0.432990095404D-01 -0.388636352520D-01 -0.347087984988D-01\n', ' -0.308270079625D-01 -0.272109297547D-01 -0.238533849179D-01 -0.207473470199D-01\n', ' -0.178859398176D-01 -0.152624349680D-01 -0.128702497753D-01 -0.107029449600D-01\n', ' -0.875422244382D-02 -0.701792314373D-02 -0.548802477161D-02 -0.415863963680D-02\n', ' -0.302401245044D-02 -0.207851813067D-02 -0.131665960939D-02 -0.733065640768D-03\n', ' -0.322488612760D-03 -0.798023629498D-04 -0.130951788091D-13\n', '   25\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.910836100221D-01\n', ' -0.175731038058D+00 -0.254289951499D+00 -0.327089319087D+00 -0.394440471814D+00\n', ' -0.456638099358D+00 -0.513961186222D+00 -0.566673891528D+00 -0.615026376092D+00\n', ' -0.659255580170D+00 -0.699585955043D+00 -0.736230151364D+00 -0.769389667030D+00\n', ' -0.799255457103D+00 -0.826008508190D+00 -0.849820379482D+00 -0.870853712536D+00\n', ' -0.889262711727D+00 -0.905193597184D+00 -0.918785031886D+00 -0.930168524507D+00\n', ' -0.939468809474D+00 -0.946804205618D+00 -0.952286954712D+00 -0.956023541090D+00\n', ' -0.958114993490D+00 -0.958657170165D+00 -0.957741028255D+00 -0.955452878353D+00\n', ' -0.951874625121D+00 -0.947083994787D+00 -0.941154750263D+00 -0.934156894630D+00\n', ' -0.926156863626D+00 -0.917217707805D+00 -0.907399264928D+00 -0.896758323153D+00\n', ' -0.885348775560D+00 -0.873221766467D+00 -0.860425830039D+00 -0.847007021587D+00\n', ' -0.833009041991D+00 -0.818473355609D+00 -0.803439302052D+00 -0.787944202144D+00\n', ' -0.772023458408D+00 -0.755710650358D+00 -0.739037624891D+00 -0.722034582045D+00\n', ' -0.704730156373D+00 -0.687151494166D+00 -0.669324326756D+00 -0.651273040100D+00\n', ' -0.633020740852D+00 -0.614589319101D+00 -0.595999507967D+00 -0.577270940196D+00\n', ' -0.558422201943D+00 -0.539470883862D+00 -0.520433629664D+00 -0.501326182266D+00\n', ' -0.482163427655D+00 -0.462959436593D+00 -0.443727504267D+00 -0.424480187992D+00\n', ' -0.405229343069D+00 -0.385986156892D+00 -0.366761181390D+00 -0.347564363890D+00\n', ' -0.347564363890D+00 -0.330057138148D+00 -0.313682152626D+00 -0.298093260983D+00\n', ' -0.283173370401D+00 -0.268856913569D+00 -0.255100360984D+00 -0.241871811683D+00\n', ' -0.229146262694D+00 -0.216903128162D+00 -0.205124810335D+00 -0.193795819972D+00\n', ' -0.182902207530D+00 -0.172431181099D+00 -0.162370841951D+00 -0.152709997006D+00\n', ' -0.143438023184D+00 -0.134544767629D+00 -0.126020473299D+00 -0.117855722784D+00\n', ' -0.110041395437D+00 -0.102568634352D+00 -0.954288206976D-01 -0.886135535959D-01\n', ' -0.821146342275D-01 -0.759240531543D-01 -0.700339801250D-01 -0.644367557932D-01\n', ' -0.591248849168D-01 -0.540910307059D-01 -0.493280100624D-01 -0.448287895118D-01\n', ' -0.405864816722D-01 -0.365943421386D-01 -0.328457666874D-01 -0.293342887278D-01\n', ' -0.260535769401D-01 -0.229974330573D-01 -0.201597897530D-01 -0.175347086082D-01\n', ' -0.151163781367D-01 -0.128991118507D-01 -0.108773463570D-01 -0.904563947108D-02\n', ' -0.739866834524D-02 -0.593122760428D-02 -0.463822748578D-02 -0.351469198292D-02\n', ' -0.255575698884D-02 -0.175666844166D-02 -0.111278047091D-02 -0.619553545292D-03\n', ' -0.272552623174D-03 -0.674453065838D-04 -0.112512836764D-13\n', '   43\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.268444513742D-01\n', ' -0.500548066307D-01 -0.699457900360D-01 -0.868078731501D-01 -0.100909115568D+00\n', ' -0.112496862702D+00 -0.121799312141D+00 -0.129026959167D+00 -0.134373931089D+00\n', ' -0.138019219277D+00 -0.140127817026D+00 -0.140851770688D+00 -0.140331150927D+00\n', ' -0.138694950372D+00 -0.136061913408D+00 -0.132541303434D+00 -0.128233612407D+00\n', ' -0.123231217174D+00 -0.117618986681D+00 -0.111474843842D+00 -0.104870285545D+00\n', ' -0.978708639919D-01 -0.905366323184D-01 -0.829225572075D-01 -0.750789009913D-01\n', ' -0.670515755483D-01 -0.588824701153D-01 -0.506097549736D-01 -0.422681628129D-01\n', ' -0.338892494404D-01 -0.255016353702D-01 -0.171312297148D-01 -0.880143768684D-02\n', ' -0.533352923024D-03  0.765406425161D-02  0.157438215857D-01  0.237207417339D-01\n', '  0.315713202766D-01  0.392835941091D-01  0.468470194448D-01  0.542523587328D-01\n', '  0.614915758422D-01  0.685577389142D-01  0.754449303262D-01  0.821481632554D-01\n', '  0.886633043631D-01  0.949870021620D-01  0.101116620654D+00  0.107050177862D+00\n', '  0.112786288906D+00  0.118324113288D+00  0.123663306099D+00  0.128803972858D+00\n', '  0.133746627717D+00  0.138492154809D+00  0.143041772497D+00  0.147397000323D+00\n', '  0.151559628473D+00  0.155531689558D+00  0.159315432565D+00  0.162913298813D+00\n', '  0.166327899774D+00  0.169561996620D+00  0.172618481381D+00  0.175500359595D+00\n', '  0.178210734336D+00  0.180752791535D+00  0.183129786488D+00  0.185345031472D+00\n', '  0.185345031472D+00  0.184931678626D+00  0.182571003170D+00  0.179102705992D+00\n', '  0.174861661976D+00  0.170054289762D+00  0.164825839363D+00  0.159285689158D+00\n', '  0.153519615050D+00  0.147596680139D+00  0.141573498882D+00  0.135497066883D+00\n', '  0.129406739952D+00  0.123335675859D+00  0.117311919408D+00  0.111359240949D+00\n', '  0.105497798650D+00  0.997446711754D-01  0.941142927526D-01  0.886188131823D-01\n', '  0.832683990877D-01  0.780714884291D-01  0.730350073337D-01  0.681645561664D-01\n', '  0.634645702171D-01  0.589384592422D-01  0.545887292324D-01  0.504170891306D-01\n', '  0.464245447124D-01  0.426114814506D-01  0.389777378725D-01  0.355226706676D-01\n', '  0.322452126076D-01  0.291439241729D-01  0.262170396519D-01  0.234625083646D-01\n', '  0.208780315749D-01  0.184610955785D-01  0.162090013874D-01  0.141188913829D-01\n', '  0.121877732559D-01  0.104125415219D-01  0.878999685767D-02  0.731686348191D-02\n', '  0.598980477569D-02  0.480543731577D-02  0.376034347671D-02  0.285108273952D-02\n', '  0.207420183130D-02  0.142624380619D-02  0.903756167956D-03  0.503298123378D-03\n', '  0.221447047829D-03  0.548042354075D-04  0.212654742276D-13\n', '   47\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.710237424182D-01\n', '  0.132432570268D+00  0.185059165691D+00  0.229672044198D+00  0.266980424813D+00\n', '  0.297638721984D+00  0.322250689785D+00  0.341373246380D+00  0.355520004351D+00\n', '  0.365164530355D+00  0.370743355613D+00  0.372658756962D+00  0.371281326549D+00\n', '  0.366952346784D+00  0.359985985786D+00  0.350671327331D+00  0.339274248149D+00\n', '  0.326039154403D+00  0.311190588218D+00  0.294934714247D+00  0.277460695473D+00\n', '  0.258941966722D+00  0.239537413656D+00  0.219392464448D+00  0.198640100731D+00\n', '  0.177401793916D+00  0.155788372506D+00  0.133900825574D+00  0.111831047179D+00\n', '  0.896625261379D-01  0.674709852150D-01  0.453249734781D-01  0.232864152992D-01\n', '  0.141111919535D-02 -0.202507505287D-01 -0.416542366014D-01 -0.627591835418D-01\n', ' -0.835298620138D-01 -0.103934620617D+00 -0.123945563116D+00 -0.143538249246D+00\n', ' -0.162691417404D+00 -0.181386727616D+00 -0.199608523324D+00 -0.217343610635D+00\n', ' -0.234581053762D+00 -0.251311985504D+00 -0.267529431666D+00 -0.283228148429D+00\n', ' -0.298404471743D+00 -0.313056177862D+00 -0.327182354243D+00 -0.340783280060D+00\n', ' -0.353860315633D+00 -0.366415800159D+00 -0.378452957120D+00 -0.389975806852D+00\n', ' -0.400989085737D+00 -0.411498171559D+00 -0.421509014581D+00 -0.431028073925D+00\n', ' -0.440062258894D+00 -0.448618874864D+00 -0.456705573429D+00 -0.464330306491D+00\n', ' -0.471501284016D+00 -0.478226935182D+00 -0.484515872695D+00 -0.490376860015D+00\n', ' -0.490376860015D+00 -0.489283231183D+00 -0.483037471001D+00 -0.473861219194D+00\n', ' -0.462640471428D+00 -0.449921360090D+00 -0.436088180592D+00 -0.421430320923D+00\n', ' -0.406174722792D+00 -0.390504109986D+00 -0.374568270278D+00 -0.358491542350D+00\n', ' -0.342378051888D+00 -0.326315526106D+00 -0.310378164577D+00 -0.294628857739D+00\n', ' -0.279120939092D+00 -0.263899594534D+00 -0.249003013440D+00 -0.234463341162D+00\n', ' -0.220307476057D+00 -0.206557742868D+00 -0.193232466407D+00 -0.180346463845D+00\n', ' -0.167911469858D+00 -0.155936505812D+00 -0.144428201936D+00 -0.133391079667D+00\n', ' -0.122827800038D+00 -0.112739382914D+00 -0.103125401078D+00 -0.939841524914D-01\n', ' -0.853128135320D-01 -0.771075755900D-01 -0.693637670313D-01 -0.620759622664D-01\n', ' -0.552380794118D-01 -0.488434678304D-01 -0.428849866719D-01 -0.373550753871D-01\n', ' -0.322458170709D-01 -0.275489953832D-01 -0.232561457104D-01 -0.193586011502D-01\n', ' -0.158475338383D-01 -0.127139920785D-01 -0.994893368355D-02 -0.754325589604D-02\n', ' -0.548782221457D-02 -0.377348642013D-02 -0.239111406624D-02 -0.133160166979D-02\n', ' -0.585893817112D-03 -0.144998377667D-03 -0.576892540902D-13\n', '   73\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.120919961757D+00\n', ' -0.214786820424D+00 -0.285128512040D+00 -0.335095657689D+00 -0.367499098133D+00\n', ' -0.384843759298D+00 -0.389359210512D+00 -0.383027240913D+00 -0.367606746704D+00\n', ' -0.344656192610D+00 -0.315553884595D+00 -0.281516267282D+00 -0.243614438314D+00\n', ' -0.202789052911D+00 -0.159863774732D+00 -0.115557413810D+00 -0.704948785238D-01\n', ' -0.252170561122D-01  0.198102749088D-01  0.641884071634D-01  0.107578457441D+00\n', '  0.149694834283D+00  0.190299351434D+00  0.229195925094D+00  0.266225798879D+00\n', '  0.301263245802D+00  0.334211701450D+00  0.365000286900D+00  0.393580683926D+00\n', '  0.419924328576D+00  0.444019892484D+00  0.465871024148D+00  0.485494325107D+00\n', '  0.502917538266D+00  0.518177927851D+00  0.531320832352D+00  0.542398373649D+00\n', '  0.551468307049D+00  0.558592998456D+00  0.563838516178D+00  0.567273826059D+00\n', '  0.568970079710D+00  0.568999986582D+00  0.567437261474D+00  0.564356139923D+00\n', '  0.559830954572D+00  0.553935766337D+00  0.546744044736D+00  0.538328392293D+00\n', '  0.528760308437D+00  0.518109988718D+00  0.506446155605D+00  0.493835917454D+00\n', '  0.480344652589D+00  0.466035915721D+00  0.450971364214D+00  0.435210701935D+00\n', '  0.418811638652D+00  0.401829863159D+00  0.384319028467D+00  0.366330747570D+00\n', '  0.347914598470D+00  0.329118137231D+00  0.309986918002D+00  0.290564519036D+00\n', '  0.270892573831D+00  0.251010806625D+00  0.230957071537D+00  0.210767394748D+00\n', '  0.210767394748D+00  0.194872722910D+00  0.181954147621D+00  0.170720796879D+00\n', '  0.160691324308D+00  0.151585755783D+00  0.143217785841D+00  0.135454581775D+00\n', '  0.128197437948D+00  0.121371007313D+00  0.114916705224D+00  0.108788385526D+00\n', '  0.102949360099D+00  0.973702639649D-01  0.920274795158D-01  0.869019453892D-01\n', '  0.819782387537D-01  0.772438572460D-01  0.726886500433D-01  0.683043625011D-01\n', '  0.640842686815D-01  0.600228728605D-01  0.561156658172D-01  0.523589250768D-01\n', '  0.487495507301D-01  0.452849302651D-01  0.419628272086D-01  0.387812894162D-01\n', '  0.357385736489D-01  0.328330837010D-01  0.300633198412D-01  0.274278377140D-01\n', '  0.249252151739D-01  0.225540257744D-01  0.203128178425D-01  0.182000982443D-01\n', '  0.162143200854D-01  0.143538737057D-01  0.126170804319D-01  0.110021886245D-01\n', '  0.950737163371D-02  0.813072732961D-02  0.687027892533D-02  0.572397685272D-02\n', '  0.468970148569D-02  0.376526653556D-02  0.294842297179D-02  0.223686334081D-02\n', '  0.162822637464D-02  0.112010180264D-02  0.710035283844D-03  0.395533403271D-03\n', '  0.174068670187D-03  0.430844801113D-04 -0.125071680895D-12\n', '   77\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.643071732209D-01\n', ' -0.114227072733D+00 -0.151635911453D+00 -0.178209240157D+00 -0.195441909001D+00\n', ' -0.204666077730D+00 -0.207067467039D+00 -0.203700024146D+00 -0.195499158236D+00\n', ' -0.183293685821D+00 -0.167816612099D+00 -0.149714861810D+00 -0.129558061846D+00\n', ' -0.107846467724D+00 -0.850181169764D-01 -0.614552842961D-01 -0.374903059721D-01\n', ' -0.134108345054D-01  0.105354216260D-01  0.341364234511D-01  0.572119474482D-01\n', '  0.796101115036D-01  0.101204244350D+00  0.121890065481D+00  0.141583145707D+00\n', '  0.160216621403D+00  0.177739138065D+00  0.194113001148D+00  0.209312514243D+00\n', '  0.223322486585D+00  0.236136893566D+00  0.247757675516D+00  0.258193661399D+00\n', '  0.267459605338D+00  0.275575325044D+00  0.282564932253D+00  0.288456146215D+00\n', '  0.293279682129D+00  0.297068707182D+00  0.299858357558D+00  0.301685310398D+00\n', '  0.302587405270D+00  0.302603310223D+00  0.301772227971D+00  0.300133638159D+00\n', '  0.297727072080D+00  0.294591916516D+00  0.290767243732D+00  0.286291664915D+00\n', '  0.281203204606D+00  0.275539193924D+00  0.269336180580D+00  0.262629853871D+00\n', '  0.255454983039D+00  0.247845367497D+00  0.239833797619D+00  0.231452024878D+00\n', '  0.222730740254D+00  0.213699559940D+00  0.204387017466D+00  0.194820561451D+00\n', '  0.185026558269D+00  0.175030298997D+00  0.164856010062D+00  0.154526867078D+00\n', '  0.144065011405D+00  0.133491569030D+00  0.122826671379D+00  0.112089477754D+00\n', '  0.112089477754D+00  0.103636436582D+00  0.967661312431D-01  0.907920553210D-01\n', '  0.854582211008D-01  0.806157338563D-01  0.761655133573D-01  0.720369170416D-01\n', '  0.681774516694D-01  0.645470464748D-01  0.611145452033D-01  0.578554065912D-01\n', '  0.547501193073D-01  0.517830665868D-01  0.489416882068D-01  0.462158470294D-01\n', '  0.435973409458D-01  0.410795209987D-01  0.386569888181D-01  0.363253544515D-01\n', '  0.340810409377D-01  0.319211255624D-01  0.298432102497D-01  0.278453153280D-01\n', '  0.259257922156D-01  0.240832515371D-01  0.223165039000D-01  0.206245111227D-01\n', '  0.190063461227D-01  0.174611600124D-01  0.159881552105D-01  0.145865635856D-01\n', '  0.132556288181D-01  0.119945923008D-01  0.108026820106D-01  0.967910387520D-02\n', '  0.862303523121D-02  0.763362003566D-02  0.670996554319D-02  0.585114020384D-02\n', '  0.505617257596D-02  0.432405107641D-02  0.365372441826D-02  0.304410260828D-02\n', '  0.249405839542D-02  0.200242907626D-02  0.156801858040D-02  0.118959976698D-02\n', '  0.865916875895D-03  0.595688086562D-03  0.377608141186D-03  0.210351001681D-03\n', '  0.925725079864D-04  0.229130169002D-04 -0.594900858547D-13\n', '   81\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00\n', '  0.000000000000D+00  0.000000000000D+00  0.000000000000D+00 -0.979799203734D-01\n', ' -0.174039052415D+00 -0.231036038218D+00 -0.271523786318D+00 -0.297779885546D+00\n', ' -0.311834045795D+00 -0.315492858980D+00 -0.310362143852D+00 -0.297867111826D+00\n', ' -0.279270567219D+00 -0.255689333976D+00 -0.228109081836D+00 -0.197397707714D+00\n', ' -0.164317412676D+00 -0.129535600998D+00 -0.936347153865D-01 -0.571211112219D-01\n', ' -0.204330626145D-01  0.160520159776D-01  0.520110569948D-01  0.871694676443D-01\n', '  0.121295836768D+00  0.154197165048D+00  0.185714568251D+00  0.215719408081D+00\n', '  0.244109809548D+00  0.270807527723D+00  0.295755130311D+00  0.318913465661D+00\n', '  0.340259388763D+00  0.359783720384D+00  0.377489416858D+00  0.393389930201D+00\n', '  0.407507740141D+00  0.419873041409D+00  0.430522571212D+00  0.439498563251D+00\n', '  0.446847815925D+00  0.452620863540D+00  0.456871240411D+00  0.459654828693D+00\n', '  0.461029281639D+00  0.461053514800D+00  0.459787258350D+00  0.457290664405D+00\n', '  0.453623963772D+00  0.448847167075D+00  0.443019805740D+00  0.436200708676D+00\n', '  0.428447810968D+00  0.419817991186D+00  0.410366934280D+00  0.400149017304D+00\n', '  0.389217215491D+00  0.377623026420D+00  0.365416410278D+00  0.352645744354D+00\n', '  0.339357790146D+00  0.325597671582D+00  0.311408863019D+00  0.296833185816D+00\n', '  0.281910812404D+00  0.266680276860D+00  0.251178491138D+00  0.235440766146D+00\n', '  0.219500836983D+00  0.203390891699D+00  0.187141603008D+00  0.170782162470D+00\n', '  0.170782162470D+00  0.157902910290D+00  0.147435151619D+00  0.138332909150D+00\n', '  0.130206153984D+00  0.122828026618D+00  0.116047566083D+00  0.109757139712D+00\n', '  0.103876767571D+00  0.983453969002D-01  0.931155572972D-01  0.881498571163D-01\n', '  0.834185684345D-01  0.788978971823D-01  0.745687063085D-01  0.704155506318D-01\n', '  0.664259332265D-01  0.625897235849D-01  0.588986966237D-01  0.553461637082D-01\n', '  0.519266748958D-01  0.486357770709D-01  0.454698164684D-01  0.424257768139D-01\n', '  0.395011462901D-01  0.366938080115D-01  0.340019497921D-01  0.314239898339D-01\n', '  0.289585156121D-01  0.266042337418D-01  0.243599290092D-01  0.222244310713D-01\n', '  0.201965875819D-01  0.182752427090D-01  0.164592201804D-01  0.147473101285D-01\n', '  0.131382591244D-01  0.116307628806D-01  0.102234611895D-01  0.891493471958D-02\n', '  0.770370335957D-02  0.658822583760D-02  0.556690038820D-02  0.463806627207D-02\n', '  0.380000598301D-02  0.305094799877D-02  0.238906995839D-02  0.181250216122D-02\n', '  0.131933130164D-02  0.907604367683D-03  0.575332637913D-03  0.320495729523D-03\n', '  0.141045648670D-03  0.349108110181D-04 -0.908372818246D-13\n']
        txt = open(shapefun_new).readlines()
        print(txt)
        assert txt==reftxt
        
    def test_neworder_potential_no_replace(self):
        path = '../tests/files/mod_pot/test1/'
        pot = path+'pot'
        out_pot = path+'pot_new'
        neworder = [0,1,2]
        # test 1: neworder_potential standard
        modify_potential().neworder_potential(pot, out_pot, neworder)
        reftxt = ['Au79 POTENTIAL                      exc: Vosko,Wilk,Nusair       #serial: kkrimp_v1.2-26-g84cbc08_serial_20180502163421                                             \n', '   2.38779078000000        4.82381975000676        2.38779078000000     \n', '  29.00000\n', '   3.41096   0.6285993399   0.7168465117\n', '484\n', ' 0.25000000D-01 0.39783834D-03\n', ' 5 1\n', '    0  -6.48338926687D+02\n', '    0  -7.71318775307D+01\n', '    0  -7.57179639043D+00\n', '    1  -6.65450234120D+01\n', '    1  -4.47233316155D+00\n', '  484  199   25    1\n', ' 2.1759441523018D+02 2.1819475080749D+02 2.1881026236697D+02 2.1917688185765D+02\n', ' 2.1944135872046D+02 2.1965147406096D+02 2.1982711562857D+02 2.1997904825423D+02\n', ' 2.2011373491322D+02 2.2023534840148D+02 2.2034673451484D+02 2.2044992337168D+02\n', ' 2.2054641278738D+02 2.2063734116153D+02 2.2072359294082D+02 2.2080587063205D+02\n', ' 2.2088474038225D+02 2.2096066680867D+02 2.2103403469802D+02 2.2110516797233D+02\n', ' 2.2117434060218D+02 2.2124178803200D+02 2.2130771274044D+02 2.2137229176865D+02\n', ' 2.2143567942083D+02 2.2149801263952D+02 2.2155941208437D+02 2.2161998625148D+02\n', ' 2.2167983158616D+02 2.2173903583539D+02 2.2179767756105D+02 2.2185582900557D+02\n', ' 2.2191355521989D+02 2.2197091660943D+02 2.2202796780683D+02 2.2208476000181D+02\n', ' 2.2214133963982D+02 2.2219775058279D+02 2.2225402975912D+02 2.2231022136274D+02\n', ' 2.2236635669203D+02 2.2242246888432D+02 2.2247858808059D+02 2.2253474336281D+02\n', ' 2.2259096113770D+02 2.2264726703007D+02 2.2270368423197D+02 2.2276023536191D+02\n', ' 2.2281694078753D+02 2.2287382045783D+02 2.2293089220513D+02 2.2298817355560D+02\n', ' 2.2304568001469D+02 2.2310342685981D+02 2.2316142741226D+02 2.2321969481495D+02\n', ' 2.2327824029306D+02 2.2333707491898D+02 2.2339620786334D+02 2.2345564814863D+02\n', ' 2.2351540289195D+02 2.2357547904851D+02 2.2363588164683D+02 2.2369661552312D+02\n', ' 2.2375768354952D+02 2.2381908836002D+02 2.2388083057214D+02 2.2394291050486D+02\n', ' 2.2400532639407D+02 2.2406807610284D+02 2.2413115533076D+02 2.2419455931677D+02\n', ' 2.2425828104263D+02 2.2432231292836D+02 2.2438664502980D+02 2.2445126672689D+02\n', ' 2.2451616491525D+02 2.2458132568737D+02 2.2464673251819D+02 2.2471236793925D+02\n', ' 2.2477821171821D+02 2.2484424252598D+02 2.2491043611020D+02 2.2497676695536D+02\n', ' 2.2504320645021D+02 2.2510972454100D+02 2.2517628789281D+02 2.2524286153598D+02\n', ' 2.2530940702151D+02 2.2537588406077D+02 2.2544224867516D+02 2.2550845482934D+02\n', ' 2.2557445257532D+02 2.2564018967957D+02 2.2570560976184D+02 2.2577065391661D+02\n', ' 2.2583525884706D+02 2.2589935848143D+02 2.2596288210274D+02 2.2602575596069D+02\n', ' 2.2608790139794D+02 2.2614923645843D+02 2.2620967401113D+02 2.2626912335583D+02\n', ' 2.2632748834555D+02 2.2638466899108D+02 2.2644055958332D+02 2.2649505029826D+02\n', ' 2.2654802532084D+02 2.2659936445204D+02 2.2664894123635D+02 2.2669662457302D+02\n', ' 2.2674227684927D+02 2.2678575555820D+02 2.2682691144031D+02 2.2686559011074D+02\n', ' 2.2690163021207D+02 2.2693486505395D+02 2.2696512078041D+02 2.2699221802546D+02\n', ' 2.2701597009844D+02 2.2703618465942D+02 2.2705266192667D+02 2.2706519637601D+02\n', ' 2.2707357497470D+02 2.2707757890935D+02 2.2707698185094D+02 2.2707155171610D+02\n', ' 2.2706104896829D+02 2.2704522841746D+02 2.2702383756273D+02 2.2699661843578D+02\n', ' 2.2696330599018D+02 2.2692362999416D+02 2.2687731347199D+02 2.2682407465138D+02\n', ' 2.2676362546233D+02 2.2669567354433D+02 2.2661992080788D+02 2.2653606550624D+02\n', ' 2.2644380086416D+02 2.2634281721860D+02 2.2623280071839D+02 2.2611343553747D+02\n', ' 2.2598440264831D+02 2.2584538210983D+02 2.2569605191624D+02 2.2553609036033D+02\n', ' 2.2536517495753D+02 2.2518298488347D+02 2.2498919997095D+02 2.2478350321820D+02\n', ' 2.2456557985406D+02 2.2433511991062D+02 2.2409181734871D+02 2.2383537268551D+02\n', ' 2.2356549216892D+02 2.2328189044697D+02 2.2298428977590D+02 2.2267242271386D+02\n', ' 2.2234603134313D+02 2.2200486996628D+02 2.2164870431818D+02 2.2127731423789D+02\n', ' 2.2089049284115D+02 2.2048804913638D+02 2.2006980712346D+02 2.1963560831698D+02\n', ' 2.1918531073229D+02 2.1871879127478D+02 2.1823594456974D+02 2.1773668517224D+02\n', ' 2.1722094619394D+02 2.1668868128549D+02 2.1613986301135D+02 2.1557448455546D+02\n', ' 2.1499255779521D+02 2.1439411468270D+02 2.1377920497221D+02 2.1314789723332D+02\n', ' 2.1250027619725D+02 2.1183644336767D+02 2.1115651395458D+02 2.1046061707360D+02\n', ' 2.0974889226369D+02 2.0902148927988D+02 2.0827856422167D+02 2.0752027896405D+02\n', ' 2.0674679696385D+02 2.0595828242230D+02 2.0515489589207D+02 2.0433679332716D+02\n', ' 2.0350412168286D+02 2.0265701808451D+02 2.0179560569314D+02 2.0091999330777D+02\n', ' 2.0003027185237D+02 1.9912651480393D+02 1.9820877572179D+02 1.9727708993976D+02\n', ' 1.9633147357549D+02 1.9537192689963D+02 1.9439843518391D+02 1.9341097401488D+02\n', ' 1.9240951211535D+02 1.9139401856057D+02 1.9036446731065D+02 1.8932084581000D+02\n', ' 1.8826316043091D+02 1.8719144537215D+02 1.8610576766875D+02 1.8500623483927D+02\n', ' 1.8389299779457D+02 1.8276625556894D+02 1.8162625460712D+02 1.8047328935068D+02\n', ' 1.7930769710463D+02 1.7812985421877D+02 1.7694016687230D+02 1.7573906378954D+02\n', ' 1.7452698442329D+02 1.7330437011236D+02 1.7207165184218D+02 1.7082924211730D+02\n', ' 1.6957752449241D+02 1.6831684811908D+02 1.6704752065437D+02 1.6576980666216D+02\n', ' 1.6448392462256D+02 1.6319004946297D+02 1.6188831353540D+02 1.6057881279725D+02\n', ' 1.5926161100051D+02 1.5793674856361D+02 1.5660424888072D+02 1.5526412871965D+02\n', ' 1.5391640546331D+02 1.5256110786239D+02 1.5119828308337D+02 1.4982800675653D+02\n', ' 1.4845038885273D+02 1.4706558213293D+02 1.4567378605828D+02 1.4427525294929D+02\n', ' 1.4287028932369D+02 1.4145925926420D+02 1.4004258279085D+02 1.3862073614347D+02\n', ' 1.3719424700385D+02 1.3576369162357D+02 1.3432968693227D+02 1.3289288468655D+02\n', ' 1.3145396079032D+02 1.3001360691002D+02 1.2857251763317D+02 1.2713138037871D+02\n', ' 1.2569086142608D+02 1.2425159540122D+02 1.2281417173331D+02 1.2137912557852D+02\n', ' 1.1994692688890D+02 1.1851797527414D+02 1.1709259444901D+02 1.1567103394857D+02\n', ' 1.1425347180428D+02 1.1284002556180D+02 1.1143076476784D+02 1.1002573143287D+02\n', ' 1.0862496043142D+02 1.0722850498972D+02 1.0583645789064D+02 1.0444897255032D+02\n', ' 1.0306627428575D+02 1.0168866657234D+02 1.0031652427665D+02 9.8950281127418D+01\n', ' 9.7590406184439D+01 9.6237379029633D+01 9.4891660040693D+01 9.3553665915330D+01\n', ' 9.2223746126658D+01 9.0902168979057D+01 8.9589111068815D+01 8.8284656983767D+01\n', ' 8.6988801550291D+01 8.5701460415778D+01 8.4422480887691D+01 8.3151658323652D+01\n', ' 8.1888750473850D+01 8.0633495385457D+01 7.9385625282129D+01 7.8144882784920D+01\n', ' 7.6911032077137D+01 7.5683871738704D+01 7.4463242102894D+01 7.3249034060800D+01\n', ' 7.2041192378577D+01 7.0839720566258D+01 6.9644680414675D+01 6.8456193396922D+01\n', ' 6.7274437050446D+01 6.6099643600619D+01 6.4932093946760D+01 6.3772114300483D+01\n', ' 6.2620068580670D+01 6.1476353863538D+01 6.0341391959896D+01 5.9215624411872D+01\n', ' 5.8099503938492D+01 5.6993489606260D+01 5.5898038705416D+01 5.4813602586280D+01\n', ' 5.3740619385786D+01 5.2679510875173D+01 5.1630676309954D+01 5.0594490491132D+01\n', ' 4.9571298874009D+01 4.8561416915304D+01 4.7565126455961D+01 4.6582676317038D+01\n', ' 4.5614279873548D+01 4.4660116775388D+01 4.3720331553926D+01 4.2795036279569D+01\n', ' 4.1884309987830D+01 4.0988202039162D+01 4.0106732113322D+01 3.9239894006939D+01\n', ' 3.8387655922838D+01 3.7549964427597D+01 3.6726744759978D+01 3.5917904681538D+01\n', ' 3.5123334555116D+01 3.4342910867236D+01 3.3576495893591D+01 3.2823940758272D+01\n', ' 3.2085084606975D+01 3.1359757184135D+01 3.0647777554415D+01 2.9948956292952D+01\n', ' 2.9263093893599D+01 2.8589982740288D+01 2.7929405383598D+01 2.7281136468980D+01\n', ' 2.6644941036934D+01 2.6020576644497D+01 2.5407791424022D+01 2.4806326835651D+01\n', ' 2.4215915611159D+01 2.4217296258767D+01 2.4191046731904D+01 2.4164848486427D+01\n', ' 2.4138701355590D+01 2.4112605173538D+01 2.4086559774925D+01 2.4060564995281D+01\n', ' 2.4034620670642D+01 2.4008726637915D+01 2.3982882734504D+01 2.3982882734504D+01\n', ' 2.3906675613860D+01 2.3830803882889D+01 2.3755270199388D+01 2.3680076998294D+01\n', ' 2.3605226503155D+01 2.3530720735561D+01 2.3456561525246D+01 2.3382750518648D+01\n', ' 2.3309289187637D+01 2.3236178837123D+01 2.3163420613045D+01 2.3091015508973D+01\n', ' 2.3018964373299D+01 2.2947267915117D+01 2.2875926710692D+01 2.2804941208702D+01\n', ' 2.2734311736085D+01 2.2664038502718D+01 2.2594121606716D+01 2.2524561038594D+01\n', ' 2.2455356686233D+01 2.2386508338428D+01 2.2318015689414D+01 2.2249878342262D+01\n', ' 2.2182095812848D+01 2.2114667532977D+01 2.2047592854015D+01 2.1980871049723D+01\n', ' 2.1914501319587D+01 2.1848482791409D+01 2.1782814524361D+01 2.1717495511323D+01\n', ' 2.1652524681838D+01 2.1587900904070D+01 2.1523622987538D+01 2.1459689685094D+01\n', ' 2.1396099695303D+01 2.1332851664305D+01 2.1269944188015D+01 2.1207375813848D+01\n', ' 2.1145145042752D+01 2.1083250330811D+01 2.1021690091131D+01 2.0960462695330D+01\n', ' 2.0899566475240D+01 2.0838999724455D+01 2.0838999724455D+01 2.0784369133277D+01\n', ' 2.0729953910598D+01 2.0675774655486D+01 2.0621838286920D+01 2.0568148581249D+01\n', ' 2.0514707564816D+01 2.0461516538311D+01 2.0408576050509D+01 2.0355886396845D+01\n', ' 2.0303447422545D+01 2.0251258880712D+01 2.0199320209886D+01 2.0147630826017D+01\n', ' 2.0096189906317D+01 2.0044996639297D+01 1.9994050023121D+01 1.9943349084747D+01\n', ' 1.9892892694780D+01 1.9842679761646D+01 1.9792709062837D+01 1.9742979418059D+01\n', ' 1.9693489535798D+01 1.9644238168818D+01 1.9644238168818D+01 1.9586732831135D+01\n', ' 1.9529564617155D+01 1.9472730933061D+01 1.9416229183758D+01 1.9360056775947D+01\n', ' 1.9304211120650D+01 1.9248689635626D+01 1.9193489747205D+01 1.9138608892343D+01\n', ' 1.9084044520022D+01 1.9029794092749D+01 1.8975855087751D+01 1.8922224998121D+01\n', ' 1.8868901333744D+01 1.8815881622200D+01 1.8763163409466D+01 1.8710744260619D+01\n', ' 1.8658621760360D+01 1.8606793513556D+01 1.8555257145615D+01 1.8504010302886D+01\n', ' 1.8453050652931D+01 1.8402375884796D+01 1.8351983709191D+01 1.8301871858667D+01\n', ' 1.8252038087713D+01 1.8202480172859D+01 1.8153195912700D+01 1.8104183127933D+01\n', ' 1.8055439661332D+01 1.8006963377757D+01 1.7958752163964D+01 1.7910803928716D+01\n', ' 1.7863116602558D+01 1.7815688137736D+01 1.7768516508073D+01 1.7721599708819D+01\n', ' 1.7674935756496D+01 1.7628522688739D+01 1.7582358564107D+01 1.7536441461910D+01\n', ' 1.7490769482005D+01 1.7445340744607D+01 1.7400153390072D+01 1.7355205578690D+01\n', ' 1.7310495490469D+01 1.7266021324917D+01 1.7221781300811D+01 1.7177773655981D+01\n', ' 1.7133996647068D+01 1.7090448549313D+01 1.7047127656308D+01 1.7004032279769D+01\n', '   21\n', ' 4.5631185736868D-03 4.8455663362266D-03 5.1159600173099D-03 5.3708921417927D-03\n', ' 5.6075886763412D-03 5.8238548047410D-03 6.0180472784632D-03 6.1890227043064D-03\n', ' 6.3361036236968D-03 6.4590300478123D-03 6.5579298124462D-03 6.6332790365093D-03\n', ' 6.6858797575958D-03 6.7168295859529D-03 6.7275066971080D-03 6.7195472954536D-03\n', ' 6.6948369428276D-03 6.6554941833194D-03 6.6038674821808D-03 6.5425236106301D-03\n', ' 6.4742499384389D-03 6.4020465411450D-03 6.3291340276284D-03 6.2589485818475D-03\n', ' 6.1951558050871D-03 6.1416479842603D-03 6.1025645686054D-03 6.0822908679790D-03\n', ' 6.0854857847725D-03 6.1170809172425D-03 6.1823160731308D-03 6.2867374439888D-03\n', ' 6.4362413203186D-03 6.6370697292084D-03 6.8958628081478D-03 7.2196502766620D-03\n', ' 7.6159133800401D-03 8.0925711500735D-03 8.6580541065516D-03 9.3212859221462D-03\n', ' 1.0091773626139D-02 1.0979588436847D-02 1.1995481283925D-02 1.3150871161936D-02\n', ' 1.4457999896501D-02 1.5929941343732D-02 1.7580813806416D-02 1.9425826411500D-02\n', ' 2.1481568751477D-02 2.3766108945038D-02 2.6299375693618D-02 2.9103314562877D-02\n', ' 3.2202368295384D-02 3.5623686185302D-02 3.9397698847110D-02 4.3558366096532D-02\n', ' 4.8143839065144D-02 5.3196730247653D-02 5.8764862808189D-02 6.4901552938390D-02\n', ' 7.1666461670902D-02 7.9125890899519D-02 8.7353766343464D-02 9.6431958094136D-02\n', ' 1.0645144868738D-01 1.0647094766716D-01 1.0694382759541D-01 1.0741828061875D-01\n', ' 1.0789431041242D-01 1.0837192065193D-01 1.0885111501964D-01 1.0933189719805D-01\n', ' 1.0981427087652D-01 1.1029823974448D-01 1.1078380749831D-01 1.1078380749831D-01\n', ' 1.0965100412745D-01 1.0878913065205D-01 1.0816936846958D-01 1.0776463239111D-01\n', ' 1.0754947352182D-01 1.0749999254724D-01 1.0759375617578D-01 1.0780972185061D-01\n', ' 1.0812816504281D-01 1.0853061312639D-01 1.0899978143072D-01 1.0951951454597D-01\n', ' 1.1007472954040D-01 1.1065136336890D-01 1.1123632202437D-01 1.1181743303543D-01\n', ' 1.1238339960534D-01 1.1292375742295D-01 1.1342883305406D-01 1.1388970447095D-01\n', ' 1.1429816312283D-01 1.1464667772275D-01 1.1492835955676D-01 1.1513692915678D-01\n', ' 1.1526668449229D-01 1.1531247025282D-01 1.1526964863185D-01 1.1513407098453D-01\n', ' 1.1490205097570D-01 1.1457033842125D-01 1.1413609460339D-01 1.1359686813787D-01\n', ' 1.1295057228817D-01 1.1219546272335D-01 1.1133011668993D-01 1.1035341253131D-01\n', ' 1.0926451059042D-01 1.0806283438610D-01 1.0674805312657D-01 1.0532006444117D-01\n', ' 1.0377897840325D-01 1.0212510171748D-01 1.0035892315533D-01 9.8481099105981D-02\n', ' 9.6492440338358D-02 9.4393898826295D-02 9.4393898826295D-02 9.2512406479178D-02\n', ' 9.0652776839737D-02 8.8795058961372D-02 8.6935963893825D-02 8.5076227849844D-02\n', ' 8.3217233714723D-02 8.1361514020148D-02 7.9511238453835D-02 7.7669245609439D-02\n', ' 7.5837794785204D-02 7.4019662001588D-02 7.2216991283701D-02 7.0432374807191D-02\n', ' 6.8667771612168D-02 6.6925548388591D-02 6.5207458142096D-02 6.3515631968649D-02\n', ' 6.1851616283162D-02 6.0217310617425D-02 5.8614063675610D-02 5.7043554228543D-02\n', ' 5.5506946624279D-02 5.4005712950990D-02 5.4005712950990D-02 5.2263701553498D-02\n', ' 5.0522250609553D-02 4.8784703007433D-02 4.7054173322214D-02 4.5333560742609D-02\n', ' 4.3625560612020D-02 4.1932676411297D-02 4.0257230437509D-02 3.8601374811831D-02\n', ' 3.6967101275677D-02 3.5356251235472D-02 3.3770524686946D-02 3.2211489325467D-02\n', ' 3.0680588630065D-02 2.9179150081660D-02 2.7708392448902D-02 2.6269433166237D-02\n', ' 2.4863294869415D-02 2.3490911989458D-02 2.2153136589684D-02 2.0850744233991D-02\n', ' 1.9584439178478D-02 1.8354859571834D-02 1.7162582054943D-02 1.6008126350437D-02\n', ' 1.4891959321885D-02 1.3814499007653D-02 1.2776118189285D-02 1.1777147922230D-02\n', ' 1.0817880660538D-02 9.8985733340674D-03 9.0194500737241D-03 8.1807048815652D-03\n', ' 7.3825039976557D-03 6.6249882066245D-03 5.9082748841140D-03 5.2324599794618D-03\n', ' 4.5976197771954D-03 4.0038125923158D-03 3.4510802789501D-03 2.9394496719152D-03\n', ' 2.4689338717326D-03 2.0395334629405D-03 1.6512376021161D-03 1.3040250406330D-03\n', ' 9.9786503966239D-04 7.3271822238026D-04 5.0853733760166D-04 3.2526796395246D-04\n', ' 1.8284914146876D-04 8.1213948028722D-05 2.0290016197226D-05 3.3281651140516D-15\n', '   25\n', ' 3.8565390773813D-03 4.0952510056308D-03 4.3237753756491D-03 4.5392323453237D-03\n', ' 4.7392774285767D-03 4.9220556671475D-03 5.0861782625495D-03 5.2306788711552D-03\n', ' 5.3549849359675D-03 5.4588767263274D-03 5.5424622831991D-03 5.6061440005062D-03\n', ' 5.6505997237349D-03 5.6767571028534D-03 5.6857809087747D-03 5.6790539866015D-03\n', ' 5.6581699269439D-03 5.6249192263527D-03 5.5812867002273D-03 5.5294416661854D-03\n', ' 5.4717398816467D-03 5.4107168732190D-03 5.3490945521967D-03 5.2897770240748D-03\n', ' 5.2358622873753D-03 5.1906399249420D-03 5.1576084099117D-03 5.1404740055684D-03\n', ' 5.1431742030898D-03 5.1698769637253D-03 5.2250107332829D-03 5.3132628991476D-03\n', ' 5.4396167363262D-03 5.6093477205697D-03 5.8280677923297D-03 6.1017181489718D-03\n', ' 6.4366215967839D-03 6.8394709391776D-03 7.3173912658215D-03 7.8779244566419D-03\n', ' 8.5291054178881D-03 9.2794458825681D-03 1.0138032044624D-02 1.1114514715896D-02\n', ' 1.2219240127392D-02 1.3463257704230D-02 1.4858499590081D-02 1.6417819843296D-02\n', ' 1.8155239228553D-02 2.0086028093240D-02 2.2227029264163D-02 2.4596790129516D-02\n', ' 2.7215968577176D-02 3.0107509948619D-02 3.3297132807147D-02 3.6813538435504D-02\n', ' 4.0688970424869D-02 4.4959442906447D-02 4.9665373830875D-02 5.4851823604363D-02\n', ' 6.0569215002497D-02 6.6873583352908D-02 7.3827407291734D-02 8.1499879675057D-02\n', ' 8.9967894780152D-02 8.9984374425869D-02 9.0384030909205D-02 9.0785016900547D-02\n', ' 9.1187335506051D-02 9.1590989832078D-02 9.1995982990786D-02 9.2402318094468D-02\n', ' 9.2809998261191D-02 9.3219026609106D-02 9.3629406262214D-02 9.3629406262214D-02\n', ' 9.2672012673557D-02 9.1943596638802D-02 9.1419801993342D-02 9.1077737574588D-02\n', ' 9.0895895140750D-02 9.0854076084609D-02 9.0933320814217D-02 9.1115845123114D-02\n', ' 9.1384978741907D-02 9.1725109452037D-02 9.2121629040681D-02 9.2560883694350D-02\n', ' 9.3030126009198D-02 9.3517470542773D-02 9.4011850839240D-02 9.4502979282743D-02\n', ' 9.4981308337275D-02 9.5437994045939D-02 9.5864860864534D-02 9.6254368303401D-02\n', ' 9.6599578870901D-02 9.6894127467891D-02 9.7132192068369D-02 9.7308465553241D-02\n', ' 9.7418128827068D-02 9.7456824857432D-02 9.7420633982233D-02 9.7306049956797D-02\n', ' 9.7109957259180D-02 9.6829608982385D-02 9.6462605972107D-02 9.6006876430570D-02\n', ' 9.5460656743379D-02 9.4822472681901D-02 9.4091121799908D-02 9.3265656124648D-02\n', ' 9.2345366016333D-02 9.1329764259431D-02 9.0218571283884D-02 8.9011700570728D-02\n', ' 8.7709245148881D-02 8.6311464231079D-02 8.4818770904692D-02 8.3231719919715D-02\n', ' 8.1550996501115D-02 7.9777405213448D-02 7.9777405213448D-02 7.8187253951061D-02\n', ' 7.6615580049071D-02 7.5045521880074D-02 7.3474299773795D-02 7.1902535943550D-02\n', ' 7.0331399140765D-02 6.8763029745245D-02 6.7199261478002D-02 6.5642493388385D-02\n', ' 6.4094634931958D-02 6.2558032274248D-02 6.1034497447091D-02 5.9526221238939D-02\n', ' 5.8034859340771D-02 5.6562411970642D-02 5.5110360688809D-02 5.3680506600073D-02\n', ' 5.2274156663543D-02 5.0892916276658D-02 4.9537925302349D-02 4.8210602561068D-02\n', ' 4.6911932106489D-02 4.5643158080163D-02 4.5643158080163D-02 4.4170889735777D-02\n', ' 4.2699095061136D-02 4.1230599312422D-02 3.9768034786007D-02 3.8313851743603D-02\n', ' 3.6870328166183D-02 3.5439579881171D-02 3.4023569587845D-02 3.2624116160602D-02\n', ' 3.1242902928121D-02 2.9881486162896D-02 2.8541302623585D-02 2.7223677254557D-02\n', ' 2.5929830018273D-02 2.4660882840859D-02 2.3417865769890D-02 2.2201723209754D-02\n', ' 2.1013319445476D-02 1.9853444215347D-02 1.8722817644358D-02 1.7622095203602D-02\n', ' 1.6551872098183D-02 1.5512687662081D-02 1.4505029245866D-02 1.3529336095302D-02\n', ' 1.2586002782135D-02 1.1675382613260D-02 1.0797790646587D-02 9.9535066750428D-03\n', ' 9.1427778673996D-03 8.3658213690287D-03 7.6228266051164D-03 6.9139575373293D-03\n', ' 6.2393546641741D-03 5.5991369703535D-03 4.9934036564146D-03 4.4222358143422D-03\n', ' 3.8856979163174D-03 3.3838392475291D-03 2.9166951811619D-03 2.4842883967824D-03\n', ' 2.0866299663400D-03 1.7237203838651D-03 1.3955504849965D-03 1.1021023113631D-03\n', ' 8.4334988391467D-04 6.1925992316241D-04 4.2979249456172D-04 2.7490160366047D-04\n', ' 1.5453572988574D-04 6.8638313718914D-05 1.7148193518295D-05 2.6046694427370D-15\n', '    1\n', 'Cu29 POTENTIAL                      exc: Vosko,Wilk,Nusair       #serial: kkrimp_v1.2-26-g84cbc08_serial_20180502163421                                             \n', '   2.38779078000000        4.82381975000676        2.38779078000000     \n', '  29.00000\n', '   3.41096   0.6285993399   0.7168465117\n', '484\n', ' 0.25000000D-01 0.39783834D-03\n', ' 5 1\n', '    0  -6.48338926687D+02\n', '    0  -7.71318775307D+01\n', '    0  -7.57179639043D+00\n', '    1  -6.65450234120D+01\n', '    1  -4.47233316155D+00\n', '  484  199   25    1\n', ' 2.1759441563850D+02 2.1819475121581D+02 2.1881026277529D+02 2.1917688226597D+02\n', ' 2.1944135912878D+02 2.1965147446928D+02 2.1982711603689D+02 2.1997904866255D+02\n', ' 2.2011373532154D+02 2.2023534880980D+02 2.2034673492315D+02 2.2044992377999D+02\n', ' 2.2054641319570D+02 2.2063734156985D+02 2.2072359334914D+02 2.2080587104037D+02\n', ' 2.2088474079057D+02 2.2096066721699D+02 2.2103403510634D+02 2.2110516838065D+02\n', ' 2.2117434101050D+02 2.2124178844032D+02 2.2130771314876D+02 2.2137229217697D+02\n', ' 2.2143567982915D+02 2.2149801304784D+02 2.2155941249269D+02 2.2161998665980D+02\n', ' 2.2167983199448D+02 2.2173903624371D+02 2.2179767796937D+02 2.2185582941389D+02\n', ' 2.2191355562821D+02 2.2197091701775D+02 2.2202796821515D+02 2.2208476041013D+02\n', ' 2.2214134004814D+02 2.2219775099111D+02 2.2225403016744D+02 2.2231022177106D+02\n', ' 2.2236635710035D+02 2.2242246929264D+02 2.2247858848891D+02 2.2253474377113D+02\n', ' 2.2259096154602D+02 2.2264726743839D+02 2.2270368464028D+02 2.2276023577023D+02\n', ' 2.2281694119585D+02 2.2287382086615D+02 2.2293089261344D+02 2.2298817396392D+02\n', ' 2.2304568042301D+02 2.2310342726813D+02 2.2316142782058D+02 2.2321969522327D+02\n', ' 2.2327824070138D+02 2.2333707532730D+02 2.2339620827166D+02 2.2345564855695D+02\n', ' 2.2351540330027D+02 2.2357547945683D+02 2.2363588205515D+02 2.2369661593144D+02\n', ' 2.2375768395784D+02 2.2381908876834D+02 2.2388083098046D+02 2.2394291091318D+02\n', ' 2.2400532680239D+02 2.2406807651116D+02 2.2413115573908D+02 2.2419455972509D+02\n', ' 2.2425828145095D+02 2.2432231333668D+02 2.2438664543812D+02 2.2445126713521D+02\n', ' 2.2451616532357D+02 2.2458132609569D+02 2.2464673292651D+02 2.2471236834757D+02\n', ' 2.2477821212653D+02 2.2484424293430D+02 2.2491043651852D+02 2.2497676736368D+02\n', ' 2.2504320685853D+02 2.2510972494932D+02 2.2517628830113D+02 2.2524286194430D+02\n', ' 2.2530940742983D+02 2.2537588446909D+02 2.2544224908348D+02 2.2550845523766D+02\n', ' 2.2557445298364D+02 2.2564019008789D+02 2.2570561017016D+02 2.2577065432493D+02\n', ' 2.2583525925538D+02 2.2589935888975D+02 2.2596288251106D+02 2.2602575636901D+02\n', ' 2.2608790180626D+02 2.2614923686675D+02 2.2620967441944D+02 2.2626912376414D+02\n', ' 2.2632748875386D+02 2.2638466939939D+02 2.2644055999164D+02 2.2649505070658D+02\n', ' 2.2654802572916D+02 2.2659936486036D+02 2.2664894164467D+02 2.2669662498134D+02\n', ' 2.2674227725759D+02 2.2678575596652D+02 2.2682691184863D+02 2.2686559051906D+02\n', ' 2.2690163062039D+02 2.2693486546227D+02 2.2696512118873D+02 2.2699221843378D+02\n', ' 2.2701597050675D+02 2.2703618506774D+02 2.2705266233499D+02 2.2706519678433D+02\n', ' 2.2707357538302D+02 2.2707757931767D+02 2.2707698225926D+02 2.2707155212442D+02\n', ' 2.2706104937660D+02 2.2704522882578D+02 2.2702383797105D+02 2.2699661884410D+02\n', ' 2.2696330639850D+02 2.2692363040248D+02 2.2687731388031D+02 2.2682407505970D+02\n', ' 2.2676362587065D+02 2.2669567395265D+02 2.2661992121619D+02 2.2653606591456D+02\n', ' 2.2644380127248D+02 2.2634281762692D+02 2.2623280112671D+02 2.2611343594579D+02\n', ' 2.2598440305663D+02 2.2584538251815D+02 2.2569605232456D+02 2.2553609076865D+02\n', ' 2.2536517536585D+02 2.2518298529179D+02 2.2498920037927D+02 2.2478350362652D+02\n', ' 2.2456558026238D+02 2.2433512031894D+02 2.2409181775703D+02 2.2383537309383D+02\n', ' 2.2356549257724D+02 2.2328189085529D+02 2.2298429018422D+02 2.2267242312218D+02\n', ' 2.2234603175144D+02 2.2200487037460D+02 2.2164870472650D+02 2.2127731464621D+02\n', ' 2.2089049324947D+02 2.2048804954470D+02 2.2006980753177D+02 2.1963560872530D+02\n', ' 2.1918531114061D+02 2.1871879168310D+02 2.1823594497806D+02 2.1773668558056D+02\n', ' 2.1722094660225D+02 2.1668868169380D+02 2.1613986341967D+02 2.1557448496378D+02\n', ' 2.1499255820352D+02 2.1439411509101D+02 2.1377920538053D+02 2.1314789764164D+02\n', ' 2.1250027660557D+02 2.1183644377599D+02 2.1115651436290D+02 2.1046061748192D+02\n', ' 2.0974889267201D+02 2.0902148968820D+02 2.0827856462999D+02 2.0752027937237D+02\n', ' 2.0674679737217D+02 2.0595828283062D+02 2.0515489630039D+02 2.0433679373548D+02\n', ' 2.0350412209118D+02 2.0265701849283D+02 2.0179560610146D+02 2.0091999371609D+02\n', ' 2.0003027226069D+02 1.9912651521224D+02 1.9820877613011D+02 1.9727709034808D+02\n', ' 1.9633147398381D+02 1.9537192730795D+02 1.9439843559222D+02 1.9341097442320D+02\n', ' 1.9240951252367D+02 1.9139401896888D+02 1.9036446771897D+02 1.8932084621831D+02\n', ' 1.8826316083923D+02 1.8719144578047D+02 1.8610576807707D+02 1.8500623524759D+02\n', ' 1.8389299820288D+02 1.8276625597726D+02 1.8162625501544D+02 1.8047328975900D+02\n', ' 1.7930769751295D+02 1.7812985462709D+02 1.7694016728062D+02 1.7573906419785D+02\n', ' 1.7452698483161D+02 1.7330437052068D+02 1.7207165225050D+02 1.7082924252562D+02\n', ' 1.6957752490073D+02 1.6831684852739D+02 1.6704752106269D+02 1.6576980707048D+02\n', ' 1.6448392503088D+02 1.6319004987128D+02 1.6188831394372D+02 1.6057881320557D+02\n', ' 1.5926161140883D+02 1.5793674897193D+02 1.5660424928904D+02 1.5526412912797D+02\n', ' 1.5391640587163D+02 1.5256110827071D+02 1.5119828349169D+02 1.4982800716485D+02\n', ' 1.4845038926105D+02 1.4706558254124D+02 1.4567378646660D+02 1.4427525335760D+02\n', ' 1.4287028973201D+02 1.4145925967252D+02 1.4004258319916D+02 1.3862073655179D+02\n', ' 1.3719424741217D+02 1.3576369203189D+02 1.3432968734059D+02 1.3289288509486D+02\n', ' 1.3145396119864D+02 1.3001360731834D+02 1.2857251804149D+02 1.2713138078703D+02\n', ' 1.2569086183440D+02 1.2425159580954D+02 1.2281417214163D+02 1.2137912598684D+02\n', ' 1.1994692729722D+02 1.1851797568245D+02 1.1709259485733D+02 1.1567103435688D+02\n', ' 1.1425347221260D+02 1.1284002597012D+02 1.1143076517616D+02 1.1002573184119D+02\n', ' 1.0862496083974D+02 1.0722850539804D+02 1.0583645829896D+02 1.0444897295863D+02\n', ' 1.0306627469407D+02 1.0168866698066D+02 1.0031652468497D+02 9.8950281535736D+01\n', ' 9.7590406592757D+01 9.6237379437951D+01 9.4891660449011D+01 9.3553666323648D+01\n', ' 9.2223746534976D+01 9.0902169387375D+01 8.9589111477133D+01 8.8284657392085D+01\n', ' 8.6988801958609D+01 8.5701460824096D+01 8.4422481296008D+01 8.3151658731970D+01\n', ' 8.1888750882168D+01 8.0633495793775D+01 7.9385625690446D+01 7.8144883193238D+01\n', ' 7.6911032485454D+01 7.5683872147021D+01 7.4463242511212D+01 7.3249034469117D+01\n', ' 7.2041192786894D+01 7.0839720974575D+01 6.9644680822992D+01 6.8456193805239D+01\n', ' 6.7274437458763D+01 6.6099644008936D+01 6.4932094355076D+01 6.3772114708800D+01\n', ' 6.2620068988986D+01 6.1476354271855D+01 6.0341392368212D+01 5.9215624820188D+01\n', ' 5.8099504346808D+01 5.6993490014576D+01 5.5898039113731D+01 5.4813602994596D+01\n', ' 5.3740619794101D+01 5.2679511283489D+01 5.1630676718269D+01 5.0594490899448D+01\n', ' 4.9571299282324D+01 4.8561417323619D+01 4.7565126864276D+01 4.6582676725353D+01\n', ' 4.5614280281863D+01 4.4660117183703D+01 4.3720331962240D+01 4.2795036687884D+01\n', ' 4.1884310396145D+01 4.0988202447476D+01 4.0106732521637D+01 3.9239894415254D+01\n', ' 3.8387656331152D+01 3.7549964835912D+01 3.6726745168292D+01 3.5917905089852D+01\n', ' 3.5123334963430D+01 3.4342911275550D+01 3.3576496301905D+01 3.2823941166586D+01\n', ' 3.2085085015289D+01 3.1359757592449D+01 3.0647777962729D+01 2.9948956701266D+01\n', ' 2.9263094301912D+01 2.8589983148601D+01 2.7929405791911D+01 2.7281136877294D+01\n', ' 2.6644941445248D+01 2.6020577052810D+01 2.5407791832336D+01 2.4806327243964D+01\n', ' 2.4215916019473D+01 2.4217296667081D+01 2.4191047140217D+01 2.4164848894740D+01\n', ' 2.4138701763903D+01 2.4112605581851D+01 2.4086560183238D+01 2.4060565403594D+01\n', ' 2.4034621078955D+01 2.4008727046229D+01 2.3982883142818D+01 2.3982883142818D+01\n', ' 2.3906676013917D+01 2.3830804274745D+01 2.3755270583097D+01 2.3680077373912D+01\n', ' 2.3605226870735D+01 2.3530721095155D+01 2.3456561876909D+01 2.3382750862431D+01\n', ' 2.3309289523592D+01 2.3236179165301D+01 2.3163420933498D+01 2.3091015821750D+01\n', ' 2.3018964678451D+01 2.2947268212692D+01 2.2875927000740D+01 2.2804941491271D+01\n', ' 2.2734312011222D+01 2.2664038770471D+01 2.2594121867132D+01 2.2524561291720D+01\n', ' 2.2455356932116D+01 2.2386508577113D+01 2.2318015920947D+01 2.2249878566686D+01\n', ' 2.2182096030209D+01 2.2114667743319D+01 2.2047593057381D+01 2.1980871246156D+01\n', ' 2.1914501509131D+01 2.1848482974106D+01 2.1782814700254D+01 2.1717495680452D+01\n', ' 2.1652524844246D+01 2.1587901059797D+01 2.1523623136624D+01 2.1459689827580D+01\n', ' 2.1396099831230D+01 2.1332851793712D+01 2.1269944310940D+01 2.1207375930331D+01\n', ' 2.1145145152831D+01 2.1083250434525D+01 2.1021690188517D+01 2.0960462786425D+01\n', ' 2.0899566560082D+01 2.0838999803082D+01 2.0838999803082D+01 2.0784369206998D+01\n', ' 2.0729953980003D+01 2.0675774720955D+01 2.0621838348757D+01 2.0568148639711D+01\n', ' 2.0514707620129D+01 2.0461516590677D+01 2.0408576100111D+01 2.0355886443851D+01\n', ' 2.0303447467111D+01 2.0251258922982D+01 2.0199320249997D+01 2.0147630864093D+01\n', ' 2.0096189942478D+01 2.0044996673656D+01 1.9994050055783D+01 1.9943349115814D+01\n', ' 1.9892892724348D+01 1.9842679789806D+01 1.9792709089676D+01 1.9742979443660D+01\n', ' 1.9693489560241D+01 1.9644238192180D+01 1.9644238192180D+01 1.9586732853297D+01\n', ' 1.9529564638167D+01 1.9472730952971D+01 1.9416229202614D+01 1.9360056793792D+01\n', ' 1.9304211137528D+01 1.9248689651576D+01 1.9193489762267D+01 1.9138608906555D+01\n', ' 1.9084044533419D+01 1.9029794105367D+01 1.8975855099623D+01 1.8922225009280D+01\n', ' 1.8868901344220D+01 1.8815881632023D+01 1.8763163418666D+01 1.8710744269224D+01\n', ' 1.8658621768397D+01 1.8606793521050D+01 1.8555257152592D+01 1.8504010309371D+01\n', ' 1.8453050658946D+01 1.8402375890365D+01 1.8351983714336D+01 1.8301871863409D+01\n', ' 1.8252038092074D+01 1.8202480176858D+01 1.8153195916357D+01 1.8104183131266D+01\n', ' 1.8055439664361D+01 1.8006963380498D+01 1.7958752166435D+01 1.7910803930933D+01\n', ' 1.7863116604538D+01 1.7815688139495D+01 1.7768516509626D+01 1.7721599710180D+01\n', ' 1.7674935757680D+01 1.7628522689760D+01 1.7582358564978D+01 1.7536441462645D+01\n', ' 1.7490769482617D+01 1.7445340745107D+01 1.7400153390473D+01 1.7355205579004D+01\n', ' 1.7310495490707D+01 1.7266021325090D+01 1.7221781300930D+01 1.7177773656056D+01\n', ' 1.7133996647110D+01 1.7090448549332D+01 1.7047127656312D+01 1.7004032279769D+01\n', '    2\n', '-1.0867779003139D-07-1.1143124975425D-07-1.1425441334663D-07-1.1714904535316D-07\n', '-1.2011695503354D-07-1.2315999740485D-07-1.2628007446737D-07-1.2947913634937D-07\n', '-1.3275918261458D-07-1.3612226340139D-07-1.3957048070404D-07-1.4310598984235D-07\n', '-1.4673100060883D-07-1.5044777876145D-07-1.5425864743962D-07-1.5816598857239D-07\n', '-1.6217224442260D-07-1.6627991902514D-07-1.7049157988510D-07-1.7480985944993D-07\n', '-1.7923745682125D-07-1.8377713946463D-07-1.8843174486146D-07-1.9320418234961D-07\n', '-1.9809743493054D-07-2.0311456112316D-07-2.0825869687519D-07-2.1353305750150D-07\n', '-2.1894093977111D-07-2.2448572383496D-07-2.3017087551577D-07-2.3599994830812D-07\n', '-2.4197658565441D-07-2.4810452332239D-07-2.5438759152846D-07-2.6082971753186D-07\n', '-2.6743492801076D-07-2.7420735155158D-07-2.8115122123411D-07-2.8827087733312D-07\n', '-2.9557076995241D-07-3.0305546185648D-07-3.1072963129910D-07-3.1859807493657D-07\n', '-3.2666571084675D-07-3.3493758156451D-07-3.4341885729330D-07-3.5211483907037D-07\n', '-3.6103096210100D-07-3.7017279917827D-07-3.7954606413704D-07-3.8915661547013D-07\n', '-3.9901045991076D-07-4.0911375630947D-07-4.1947281937094D-07-4.3009412367878D-07\n', '-4.4098430773497D-07-4.5215017806474D-07-4.6359871354088D-07-4.7533706972051D-07\n', '-4.8737258329261D-07-4.9971277667420D-07-5.1236536275588D-07-5.2533824965200D-07\n', '-5.3863954570585D-07-5.3863954679371D-07-5.3924408149106D-07-5.3984861619568D-07\n', '-5.4045315088752D-07-5.4105768557827D-07-5.4166222027008D-07-5.4226675496077D-07\n', '-5.4287128964693D-07-5.4347582433469D-07-5.4408035901790D-07-5.4408035901790D-07\n', '-5.3487219536643D-07-5.2566522634912D-07-5.1645943810664D-07-5.0725481697698D-07\n', '-4.9805134955280D-07-4.8884902262842D-07-4.7964782322234D-07-4.7044773855535D-07\n', '-4.6124875607841D-07-4.5205086342465D-07-4.4285404844291D-07-4.3365829916219D-07\n', '-4.2446360382601D-07-4.1526995083857D-07-4.0607732881205D-07-3.9688572653013D-07\n', '-3.8769513296265D-07-3.7850553723611D-07-3.6931692867515D-07-3.6012929675129D-07\n', '-3.5094263110496D-07-3.4175692154719D-07-3.3257215803765D-07-3.2338833069749D-07\n', '-3.1420542980733D-07-3.0502344578365D-07-2.9584236919381D-07-2.8666219076413D-07\n', '-2.7748290134221D-07-2.6830449193083D-07-2.5912695366731D-07-2.4995027780995D-07\n', '-2.4077445576927D-07-2.3159947906728D-07-2.2242533936790D-07-2.1325202845136D-07\n', '-2.0407953822119D-07-1.9490786070874D-07-1.8573698804938D-07-1.7656691250844D-07\n', '-1.6739762646009D-07-1.5822912239146D-07-1.4906139290017D-07-1.3989443068946D-07\n', '-1.3072822857250D-07-1.2156277946598D-07-1.2156277946598D-07-1.1432829732023D-07\n', '-1.0796343659823D-07-1.0215203727973D-07-9.6778871013881D-08-9.1776301714793D-08\n', '-8.7098095455870D-08-8.2709931739944D-08-7.8584965636949D-08-7.4701424528357D-08\n', '-7.1041173537938D-08-6.7588797058003D-08-6.4330978649095D-08-6.1256064583133D-08\n', '-5.8353746116333D-08-5.5614821696581D-08-5.3031014789423D-08-5.0594831529849D-08\n', '-4.8299447566075D-08-4.6138616772712D-08-4.4106596624332D-08-4.2198086497768D-08\n', '-4.0408176114269D-08-3.8732302077654D-08-3.8732302077654D-08-3.6866998781668D-08\n', '-3.5073012696957D-08-3.3347390891523D-08-3.1687389065546D-08-3.0090449743622D-08\n', '-2.8554183509701D-08-2.7076352760114D-08-2.5654857553622D-08-2.4287723218550D-08\n', '-2.2973089448571D-08-2.1709200661774D-08-2.0494397439783D-08-1.9327108899846D-08\n', '-1.8205845867851D-08-1.7129194748938D-08-1.6095812011460D-08-1.5104419199335D-08\n', '-1.4153798416356D-08-1.3242788224247D-08-1.2370279907115D-08-1.1535214061070D-08\n', '-1.0736577475739D-08-9.9734002739990D-09-9.2447532855278D-09-8.5497456285062D-09\n', '-7.8875224805236D-09-7.2572630189883D-09-6.6581785159307D-09-6.0895105724431D-09\n', '-5.5505294799813D-09-5.0405326971367D-09-4.5588434324740D-09-4.1048093232660D-09\n', '-3.6778012026710D-09-3.2772119478553D-09-2.9024554028412D-09-2.5529653692523D-09\n', '-2.2281946606732D-09-1.9276142147067D-09-1.6507122591619D-09-1.3969935277935D-09\n', '-1.1659785221220D-09-9.5720281606639D-10-7.7021640014373D-10-6.0458306262512D-10\n', '-4.5987980502181D-10-3.3569628945879D-10-2.3163431597574D-10-1.4730732757666D-10\n', '-8.2339941363560D-11-3.6367503943469D-11-9.0356696338917D-12-1.1485845543309D-20\n', '    3\n', '-1.0867779007261D-07-1.1143124977652D-07-1.1425441336107D-07-1.1714904537088D-07\n', '-1.2011695503791D-07-1.2315999742085D-07-1.2628007446449D-07-1.2947913636648D-07\n', '-1.3275918264338D-07-1.3612226343356D-07-1.3957048073126D-07-1.4310598986186D-07\n', '-1.4673100063454D-07-1.5044777879891D-07-1.5425864746665D-07-1.5816598858900D-07\n', '-1.6217224444825D-07-1.6627991906539D-07-1.7049157992054D-07-1.7480985948891D-07\n', '-1.7923745687211D-07-1.8377713951074D-07-1.8843174489451D-07-1.9320418238906D-07\n', '-1.9809743496252D-07-2.0311456116574D-07-2.0825869691313D-07-2.1353305754731D-07\n', '-2.1894093980261D-07-2.2448572388548D-07-2.3017087556035D-07-2.3599994833846D-07\n', '-2.4197658570245D-07-2.4810452334931D-07-2.5438759156898D-07-2.6082971758601D-07\n', '-2.6743492806051D-07-2.7420735159974D-07-2.8115122128904D-07-2.8827087739209D-07\n', '-2.9557077000849D-07-3.0305546191387D-07-3.1072963135645D-07-3.1859807498905D-07\n', '-3.2666571090272D-07-3.3493758162193D-07-3.4341885735289D-07-3.5211483912384D-07\n', '-3.6103096216158D-07-3.7017279924043D-07-3.7954606420917D-07-3.8915661553490D-07\n', '-3.9901045998278D-07-4.0911375638256D-07-4.1947281944720D-07-4.3009412375271D-07\n', '-4.4098430780453D-07-4.5215017814525D-07-4.6359871362544D-07-4.7533706980777D-07\n', '-4.8737258337361D-07-4.9971277675869D-07-5.1236536284046D-07-5.2533824974642D-07\n', '-5.3863954579837D-07-5.3863954688346D-07-5.3924408158646D-07-5.3984861628563D-07\n', '-5.4045315097827D-07-5.4105768567397D-07-5.4166222036103D-07-5.4226675505252D-07\n', '-5.4287128974433D-07-5.4347582442803D-07-5.4408035910648D-07-5.4408035910648D-07\n', '-5.3487219545843D-07-5.2566522644503D-07-5.1645943819573D-07-5.0725481706660D-07\n', '-4.9805134964147D-07-4.8884902271681D-07-4.7964782330620D-07-4.7044773864064D-07\n', '-4.6124875616121D-07-4.5205086350923D-07-4.4285404852369D-07-4.3365829924430D-07\n', '-4.2446360390025D-07-4.1526995090992D-07-4.0607732888350D-07-3.9688572660087D-07\n', '-3.8769513302932D-07-3.7850553730577D-07-3.6931692874353D-07-3.6012929681375D-07\n', '-3.5094263116724D-07-3.4175692160910D-07-3.3257215809811D-07-3.2338833075761D-07\n', '-3.1420542986380D-07-3.0502344583735D-07-2.9584236924966D-07-2.8666219081518D-07\n', '-2.7748290139481D-07-2.6830449198114D-07-2.5912695371479D-07-2.4995027785639D-07\n', '-2.4077445581423D-07-2.3159947911316D-07-2.2242533941053D-07-2.1325202849355D-07\n', '-2.0407953826105D-07-1.9490786074366D-07-1.8573698808504D-07-1.7656691254239D-07\n', '-1.6739762649289D-07-1.5822912242378D-07-1.4906139292989D-07-1.3989443071720D-07\n', '-1.3072822859997D-07-1.2156277949203D-07-1.2156277949203D-07-1.1432829734423D-07\n', '-1.0796343662042D-07-1.0215203730224D-07-9.6778871034153D-08-9.1776301735053D-08\n', '-8.7098095474605D-08-8.2709931758141D-08-7.8584965654001D-08-7.4701424544493D-08\n', '-7.1041173554121D-08-6.7588797074022D-08-6.4330978664287D-08-6.1256064597056D-08\n', '-5.8353746130412D-08-5.5614821709432D-08-5.3031014801906D-08-5.0594831541733D-08\n', '-4.8299447577411D-08-4.6138616783955D-08-4.4106596635090D-08-4.2198086507752D-08\n', '-4.0408176124208D-08-3.8732302087114D-08-3.8732302087114D-08-3.6866998791088D-08\n', '-3.5073012706106D-08-3.3347390900014D-08-3.1687389073533D-08-3.0090449751172D-08\n', '-2.8554183516662D-08-2.7076352766897D-08-2.5654857560227D-08-2.4287723224824D-08\n', '-2.2973089454270D-08-2.1709200667375D-08-2.0494397445078D-08-1.9327108904996D-08\n', '-1.8205845872538D-08-1.7129194753451D-08-1.6095812015559D-08-1.5104419203165D-08\n', '-1.4153798420007D-08-1.3242788227685D-08-1.2370279910387D-08-1.1535214064147D-08\n', '-1.0736577478506D-08-9.9734002766678D-09-9.2447532879530D-09-8.5497456308046D-09\n', '-7.8875224826164D-09-7.2572630210155D-09-6.6581785177281D-09-6.0895105741136D-09\n', '-5.5505294814448D-09-5.0405326985186D-09-4.5588434337359D-09-4.1048093243912D-09\n', '-3.6778012036368D-09-3.2772119487373D-09-2.9024554036301D-09-2.5529653699373D-09\n', '-2.2281946612744D-09-1.9276142152144D-09-1.6507122596184D-09-1.3969935281765D-09\n', '-1.1659785224466D-09-9.5720281632646D-10-7.7021640035188D-10-6.0458306279581D-10\n', '-4.5987980515044D-10-3.3569628955508D-10-2.3163431604240D-10-1.4730732761895D-10\n', '-8.2339941387318D-11-3.6367503953192D-11-9.0356696363779D-12-1.1478470662795D-20\n', '    6\n', '-3.2861672835412D-09-3.4547859568192D-09-3.6320530893832D-09-3.8184121701146D-09\n', '-4.0143293925676D-09-4.2202949433128D-09-4.4368241030359D-09-4.6644586185627D-09\n', '-4.9037679272227D-09-5.1553507892035D-09-5.4198366320807D-09-5.6978871052596D-09\n', '-5.9901979038299D-09-6.2975002442020D-09-6.6205630034465D-09-6.9601943639200D-09\n', '-7.3172439922017D-09-7.6926051411971D-09-8.0872168250824D-09-8.5020662336406D-09\n', '-8.9381911420867D-09-9.3966826000978D-09-9.8786875152073D-09-1.0385411624485D-08\n', '-1.0918122531402D-08-1.1478152747414D-08-1.2066903197226D-08-1.2685846541042D-08\n', '-1.3336530994247D-08-1.4020584129150D-08-1.4739716950199D-08-1.5495728229236D-08\n', '-1.6290508900567D-08-1.7126046890683D-08-1.8004432025309D-08-1.8927861269067D-08\n', '-1.9898644220616D-08-2.0919208904764D-08-2.1992107841277D-08-2.3120024370901D-08\n', '-2.4305779468229D-08-2.5552338699489D-08-2.6862819693259D-08-2.8240499933133D-08\n', '-2.9688824935487D-08-3.1211416884939D-08-3.2812083667085D-08-3.4494828449587D-08\n', '-3.6263859632052D-08-3.8123601401388D-08-4.0078704792633D-08-4.2134059325249D-08\n', '-4.4294805217553D-08-4.6566346250826D-08-4.8954363274907D-08-5.1464828419657D-08\n', '-5.4104020014395D-08-5.6878538289480D-08-5.9795321892260D-08-6.2861665208739D-08\n', '-6.6085236615420D-08-6.9474097651490D-08-7.3036723160537D-08-7.6782022501563D-08\n', '-8.0719361797469D-08-8.0719360134193D-08-8.0900648249557D-08-8.1082139716387D-08\n', '-8.1263834524904D-08-8.1445732682760D-08-8.1627834182954D-08-8.1810139033135D-08\n', '-8.1992647231162D-08-8.2175358770111D-08-8.2358273659637D-08-8.2358273659637D-08\n', '-8.0705020095855D-08-7.9060935624552D-08-7.7425638468640D-08-7.5798754868151D-08\n', '-7.4179918860301D-08-7.2568772127392D-08-7.0964963786897D-08-6.9368150235363D-08\n', '-6.7777994968024D-08-6.6194168404196D-08-6.4616347742643D-08-6.3044216791818D-08\n', '-6.1477465803865D-08-5.9915791352440D-08-5.8358896159151D-08-5.6806488972116D-08\n', '-5.5258284411871D-08-5.3714002841393D-08-5.2173370235000D-08-5.0636118053634D-08\n', '-4.9101983107812D-08-4.7570707452524D-08-4.6042038256361D-08-4.4515727683525D-08\n', '-4.2991532791892D-08-4.1469215414120D-08-3.9948542058605D-08-3.8429283796959D-08\n', '-3.6911216164173D-08-3.5394119063890D-08-3.3877776661540D-08-3.2361977305348D-08\n', '-3.0846513419384D-08-2.9331181417738D-08-2.7815781624130D-08-2.6300118178450D-08\n', '-2.4783998954577D-08-2.3267235483752D-08-2.1749642866137D-08-2.0231039706610D-08\n', '-1.8711248026055D-08-1.7190093194892D-08-1.5667403859571D-08-1.4143011872395D-08\n', '-1.2616752222447D-08-1.1088462969543D-08-1.1088462969543D-08-9.9224355600570D-09\n', '-8.9337933532450D-09-8.0571017877347D-09-7.2684522946303D-09-6.5537844425333D-09\n', '-5.9034723960190D-09-5.3103625071826D-09-4.7688549357556D-09-4.2744059675527D-09\n', '-3.8232307037501D-09-3.4121125445537D-09-3.0382744445693D-09-2.6992882000054D-09\n', '-2.3930083439651D-09-2.1175226110435D-09-1.8711139444078D-09-1.6522307678034D-09\n', '-1.4594633236608D-09-1.2915245557900D-09-1.1472344602925D-09-1.0255071260679D-09\n', '-9.2533989087793D-10-8.4580418339265D-10-8.4580418339265D-10-7.6762649022023D-10\n', '-6.9592618705268D-10-6.3019397348778D-10-5.6996380398466D-10-5.1480828444978D-10\n', '-4.6433470759978D-10-4.1818161694957D-10-3.7601581127418D-10-3.3752971932918D-10\n', '-3.0243908807908D-10-2.7048093722517D-10-2.4141174223370D-10-2.1500581444696D-10\n', '-1.9105385072592D-10-1.6936163136321D-10-1.4974884748786D-10-1.3204804147969D-10\n', '-1.1610364725309D-10-1.0177111891413D-10-8.8916137419709D-11-7.7413886765385D-11\n', '-6.7148392329994D-11-5.8011914769467D-11-4.9904393527455D-11-4.2732935375925D-11\n', '-3.6411343221770D-11-3.0859681497873D-11-2.6003874598378D-11-2.1775335403345D-11\n', '-1.8110621026788D-11-1.4951113535759D-11-1.2242723351124D-11-9.9356134314248D-12\n', '-7.9839425253551D-12-6.3456258285078D-12-4.9821117716307D-12-3.8581735057261D-12\n', '-2.9417140493384D-12-2.2035839504382D-12-1.6174106152090D-12-1.1594383077674D-12\n', '-8.0837812950999D-13-5.4526722358725D-13-3.5333651108713D-13-2.1788640714220D-13\n', '-1.2616992144306D-13-6.7282653249237D-14-3.2059203147732D-14-1.2975576825091D-14\n', '-4.0571818831883D-15-7.9204683775542D-16-4.8930043424249D-17-2.1031199044751D-21\n', '   10\n', '-1.1511850873695D-10-1.2409294983534D-10-1.3376680144304D-10-1.4419461744343D-10\n', '-1.5543508520873D-10-1.6755156439980D-10-1.8061229348612D-10-1.9469082664431D-10\n', '-2.0986648949062D-10-2.2622471163799D-10-2.4385765771063D-10-2.6286460162476D-10\n', '-2.8335259385126D-10-3.0543701401048D-10-3.2924219816565D-10-3.5490221939536D-10\n', '-3.8256156747253D-10-4.1237597057793D-10-4.4451329702843D-10-4.7915450307758D-10\n', '-5.1649465155387D-10-5.5674395708812D-10-6.0012903621449D-10-6.4689417746789D-10\n', '-6.9730264978320D-10-7.5163825397168D-10-8.1020689527207D-10-8.7333832193795D-10\n', '-9.4138794521542D-10-1.0147388538163D-09-1.0938040092036D-09-1.1790285033321D-09\n', '-1.2708921154016D-09-1.3699119915493D-09-1.4766455501594D-09-1.5916936332798D-09\n', '-1.7157039024343D-09-1.8493744186930D-09-1.9934576662846D-09-2.1487646962304D-09\n', '-2.3161697580826D-09-2.4966151955722D-09-2.6911167491348D-09-2.9007692631438D-09\n', '-3.1267528898042D-09-3.3703396771631D-09-3.6329007771945D-09-3.9159141309217D-09\n', '-4.2209728129293D-09-4.5497939708923D-09-4.9042285328690D-09-5.2862715672478D-09\n', '-5.6980735630230D-09-6.1419525087940D-09-6.6204069512294D-09-7.1361300360723D-09\n', '-7.6920246776889D-09-8.2912199081574D-09-8.9370884592777D-09-9.6332657595199D-09\n', '-1.0383670390630D-08-1.1192526130422D-08-1.2064385742353D-08-1.3004156559850D-08\n', '-1.4017128150204D-08-1.4017126529968D-08-1.4064374209546D-08-1.4111727945395D-08\n', '-1.4159187843379D-08-1.4206754043716D-08-1.4254426645333D-08-1.4302205775957D-08\n', '-1.4350091560190D-08-1.4398084102166D-08-1.4446183535506D-08-1.4446183535506D-08\n', '-1.0949713917055D-08-7.5647198654719D-09-4.2883038179098D-09-1.1176427510956D-09\n', ' 1.9500139047194D-09 4.9173462972840D-09 7.7869661221756D-09 1.0561418529862D-08\n', ' 1.3243183968225D-08 1.5834679984851D-08 1.8338262959200D-08 2.0756229781983D-08\n', ' 2.3090819511094D-08 2.5344214927731D-08 2.7518544104568D-08 2.9615881871448D-08\n', ' 3.1638251288261D-08 3.3587625026517D-08 3.5465926752530D-08 3.7275032434206D-08\n', ' 3.9016771636513D-08 4.0692928759087D-08 4.2305244257393D-08 4.3855415803197D-08\n', ' 4.5345099434984D-08 4.6775910660489D-08 4.8149425529710D-08 4.9467181690447D-08\n', ' 5.0730679382039D-08 5.1941382440395D-08 5.3100719244106D-08 5.4210083637512D-08\n', ' 5.5270835851931D-08 5.6284303361510D-08 5.7251781751820D-08 5.8174535538562D-08\n', ' 5.9053798972099D-08 5.9890776825284D-08 6.0686645148724D-08 6.1442552011720D-08\n', ' 6.2159618217160D-08 6.2838938004000D-08 6.3481579722379D-08 6.4088586494836D-08\n', ' 6.4660976856176D-08 6.5199745382327D-08 6.5199745382327D-08 6.5312670467263D-08\n', ' 6.5125471582011D-08 6.4747559423369D-08 6.4220795294550D-08 6.3570644923799D-08\n', ' 6.2815045890130D-08 6.1967658554173D-08 6.1039404301120D-08 6.0039308381664D-08\n', ' 5.8975009056280D-08 5.7853087552817D-08 5.6679293584843D-08 5.5458706092868D-08\n', ' 5.4195851736303D-08 5.2894794723368D-08 5.1559206511287D-08 5.0192420984803D-08\n', ' 4.8797478880336D-08 4.7377164101514D-08 4.5934033778958D-08 4.4470443456991D-08\n', ' 4.2988568394428D-08 4.1490421766781D-08 4.1490421766781D-08 3.9744016275567D-08\n', ' 3.8039746302063D-08 3.6377706113628D-08 3.4757915702518D-08 3.3180329853258D-08\n', ' 3.1644845975945D-08 3.0151310917860D-08 2.8699526913928D-08 2.7289256807499D-08\n', ' 2.5920228652851D-08 2.4592139783878D-08 2.3304660425411D-08 2.2057436907975D-08\n', ' 2.0850094536842D-08 1.9682240156723D-08 1.8553464456266D-08 1.7463344033840D-08\n', ' 1.6411443260136D-08 1.5397315956620D-08 1.4420506911529D-08 1.3480553248789D-08\n', ' 1.2576985669497D-08 1.1709329574589D-08 1.0877106084475D-08 1.0079832962754D-08\n', ' 9.3170254561004D-09 8.5881970560622D-09 7.8928601917409D-09 7.2305268589754D-09\n', ' 6.6007091921613D-09 6.0029199833118D-09 5.4366731541731D-09 4.9014841843799D-09\n', ' 4.3968704996876D-09 3.9223518243197D-09 3.4774505000237D-09 3.0616917743861D-09\n', ' 2.6746040615223D-09 2.3157191770015D-09 1.9845725492936D-09 1.6807034096382D-09\n', ' 1.4036549619480D-09 1.1529745345786D-09 9.2821371512506D-10 7.2892846986161D-10\n', ' 5.5467924889469D-10 4.0503107808918D-10 2.7955363903982D-10 1.7782133774537D-10\n', ' 9.9413363123970D-11 4.3913735960334D-11 1.0911349169323D-11 1.6669374284445D-21\n', '   13\n', ' 6.1917128853224D-11 6.6746297903366D-11 7.1951985447820D-11 7.7563570356923D-11\n', ' 8.3612708572481D-11 9.0133474854217D-11 9.7162621142686D-11 1.0473971107331D-10\n', ' 1.1290750657360D-10 1.2171192772448D-10 1.3120259482301D-10 1.4143294929743D-10\n', ' 1.5246057959567D-10 1.6434756495321D-10 1.7716086111358D-10 1.9097253008309D-10\n', ' 2.0586038506857D-10 2.2190816743815D-10 2.3920624630317D-10 2.5785197736163D-10\n', ' 2.7795027068501D-10 2.9961429832826D-10 3.2296597042327D-10 3.4813671481803D-10\n', ' 3.7526822831912D-10 4.0451317312801D-10 4.3603617965822D-10 4.7001469562065D-10\n', ' 5.0663992672074D-10 5.4611805772713D-10 5.8867127152031D-10 6.3453909856741D-10\n', ' 6.8397970423609D-10 7.3727138515430D-10 7.9471409550562D-10 8.5663116327729D-10\n', ' 9.2337112554185D-10 9.9530963742800D-10 1.0728516296586D-09 1.1564335863031D-09\n', ' 1.2465259653783D-09 1.3436358898194D-09 1.4483099961558D-09 1.5611374838993D-09\n', ' 1.6827534594093D-09 1.8138424817410D-09 1.9551424618780D-09 2.1074487682616D-09\n', ' 2.2716187411734D-09 2.4485764800003D-09 2.6393180826830D-09 2.8449172317928D-09\n', ' 3.0665312276957D-09 3.3054075192155D-09 3.5628907118040D-09 3.8404301521116D-09\n', ' 4.1395880485713D-09 4.4620483005433D-09 4.8096259463681D-09 5.1842773915152D-09\n', ' 5.5881114060129D-09 6.0234010061027D-09 6.4925962471210D-09 6.9983379747960D-09\n', ' 7.5434727449389D-09 7.5434711170721D-09 7.5688976513332D-09 7.5943812544110D-09\n', ' 7.6199219938375D-09 7.6455199348793D-09 7.6711751353539D-09 7.6968876695481D-09\n', ' 7.7226575938922D-09 7.7484849708761D-09 7.7743698728900D-09 7.7743698728900D-09\n', ' 3.7033997539252D-09-2.3777007361676D-10-4.0523991767476D-09-7.7436635211013D-09\n', '-1.1314657781367D-08-1.4768397639080D-08-1.8107821956959D-08-2.1335794934113D-08\n', '-2.4455108159460D-08-2.7468482614122D-08-3.0378570640445D-08-3.3187957799370D-08\n', '-3.5899164709007D-08-3.8514648827719D-08-4.1036806161626D-08-4.3467972950734D-08\n', '-4.5810427270300D-08-4.8066390621880D-08-5.0238029439213D-08-5.2327456586184D-08\n', '-5.4336732792530D-08-5.6267868037997D-08-5.8122822908553D-08-5.9903509920057D-08\n', '-6.1611794792601D-08-6.3249497690686D-08-6.4818394410593D-08-6.6320217575126D-08\n', '-6.7756657752999D-08-6.9129364561886D-08-7.0439947749631D-08-7.1689978225593D-08\n', '-7.2880989074692D-08-7.4014476537658D-08-7.5091900969982D-08-7.6114687776000D-08\n', '-7.7084228284493D-08-7.8001880655543D-08-7.8868970716886D-08-7.9686792791745D-08\n', '-8.0456610509853D-08-8.1179657583226D-08-8.1857138566653D-08-8.2490229608768D-08\n', '-8.3080079158000D-08-8.3627808668777D-08-8.3627808668777D-08-8.3669507668556D-08\n', '-8.3347614201420D-08-8.2794451952750D-08-8.2060691842442D-08-8.1177179508844D-08\n', '-8.0165655902593D-08-7.9042688283477D-08-7.7821530479246D-08-7.6513142272559D-08\n', '-7.5126805234225D-08-7.3670521838336D-08-7.2151288265421D-08-7.0575288845769D-08\n', '-6.8948039397951D-08-6.7274495886505D-08-6.5559138747673D-08-6.3806039626521D-08\n', '-6.2018915118376D-08-6.0201170697784D-08-5.8355937074259D-08-5.6486100662394D-08\n', '-5.4594329347353D-08-5.2683094495983D-08-5.2683094495983D-08-5.0456351806800D-08\n', '-4.8284255427709D-08-4.6166832167726D-08-4.4104021354140D-08-4.2095685729199D-08\n', '-4.0141620857733D-08-3.8241563302604D-08-3.6395197756880D-08-3.4602163300280D-08\n', '-3.2862058905825D-08-3.1174448307126D-08-2.9538864308153D-08-2.7954812621728D-08\n', '-2.6421775286116D-08-2.4939213721540D-08-2.3506571465272D-08-2.2123276628161D-08\n', '-2.0788744100607D-08-1.9502377539679D-08-1.8263571161331D-08-1.7071711356015D-08\n', '-1.5926178150645D-08-1.4826346528907D-08-1.3771587626846D-08-1.2761269816021D-08\n', '-1.1794759683326D-08-1.0871422920215D-08-9.9906251267489D-09-9.1517325427059D-09\n', '-8.3541127071727D-09-7.5971350580069D-09-6.8801714730352D-09-6.2025967608156D-09\n', '-5.5637891028795D-09-4.9631304538303D-09-4.4000069012345D-09-3.8738089899859D-09\n', '-3.3839320135896D-09-2.9297762746719D-09-2.5107473182142D-09-2.1262561389143D-09\n', '-1.7757193655706D-09-1.4585594234569D-09-1.1742046773781D-09-9.2208955624352D-10\n', '-7.0165466113721D-10-5.1234685793809D-10-3.5361935584261D-10-2.2493177286118D-10\n', '-1.2575018940691D-10-5.5547190841271D-11-1.3801899931175D-11-2.7214063952793D-21\n', '   21\n', ' 4.5631185522476D-03 4.8455663125134D-03 5.1159599910797D-03 5.3708921127769D-03\n', ' 5.6075886442427D-03 5.8238547692316D-03 6.0180472391801D-03 6.1890226608487D-03\n', ' 6.3361035756217D-03 6.4590299946303D-03 6.5579297536169D-03 6.6332789714355D-03\n', ' 6.6858796856178D-03 6.7168295063418D-03 6.7275066090587D-03 6.7195471980764D-03\n', ' 6.6948368351397D-03 6.6554940642348D-03 6.6038673504998D-03 6.5425234650269D-03\n', ' 6.4742497774486D-03 6.4020463631490D-03 6.3291338308380D-03 6.2589483642862D-03\n', ' 6.1951555645709D-03 6.1416477183754D-03 6.1025642746847D-03 6.0822905430747D-03\n', ' 6.0854854256272D-03 6.1170805202563D-03 6.1823156343253D-03 6.2867369589672D-03\n', ' 6.4362407842217D-03 6.6370691366662D-03 6.8958621532252D-03 7.2196495527998D-03\n', ' 7.6159125799893D-03 8.0925702658224D-03 8.6580531292458D-03 9.3212848419999D-03\n', ' 1.0091772432337D-02 1.0979587117436D-02 1.1995479825695D-02 1.3150869550287D-02\n', ' 1.4457998115296D-02 1.5929939375138D-02 1.7580811630724D-02 1.9425824006924D-02\n', ' 2.1481566093944D-02 2.3766106007940D-02 2.6299372447547D-02 2.9103310975334D-02\n', ' 3.2202364330448D-02 3.5623681803277D-02 3.9397694004121D-02 4.3558360744090D-02\n', ' 4.8143833149661D-02 5.3196723709902D-02 5.8764855582713D-02 6.4901544952848D-02\n', ' 7.1666452845345D-02 7.9125881145587D-02 8.7353755563504D-02 9.6431946180224D-02\n', ' 1.0645143552024D-01 1.0647093450002D-01 1.0694381436906D-01 1.0741826733298D-01\n', ' 1.0789429706704D-01 1.0837190724675D-01 1.0885110155444D-01 1.0933188367264D-01\n', ' 1.0981425729069D-01 1.1029822609804D-01 1.1078379379105D-01 1.1078379379105D-01\n', ' 1.0965100294939D-01 1.0878914149477D-01 1.0816939084100D-01 1.0776466581497D-01\n', ' 1.0754951753721D-01 1.0750004670808D-01 1.0759382005042D-01 1.0780979502135D-01\n', ' 1.0812824710545D-01 1.0853070368985D-01 1.0899988011661D-01 1.0951962098823D-01\n', ' 1.1007484338489D-01 1.1065148427304D-01 1.1123644965679D-01 1.1181756707562D-01\n', ' 1.1238353974335D-01 1.1292390335903D-01 1.1342898449836D-01 1.1388986114322D-01\n', ' 1.1429832475214D-01 1.1464684404718D-01 1.1492853032315D-01 1.1513710412046D-01\n', ' 1.1526686341682D-01 1.1531265290973D-01 1.1526983480043D-01 1.1513426045156D-01\n', ' 1.1490224353524D-01 1.1457053387443D-01 1.1413629275819D-01 1.1359706880891D-01\n', ' 1.1295077529649D-01 1.1219566789628D-01 1.1133032386084D-01 1.1035362153945D-01\n', ' 1.0926472128075D-01 1.0806304660911D-01 1.0674826673814D-01 1.0532027930235D-01\n', ' 1.0377919438017D-01 1.0212531868116D-01 1.0035914098156D-01 9.8481317675146D-02\n', ' 9.6492659535334D-02 9.4394118540298D-02 9.4394118540298D-02 9.2512625506801D-02\n', ' 9.0652994265453D-02 8.8795274211001D-02 8.6936176525404D-02 8.5076437502452D-02\n', ' 8.3217440084805D-02 8.1361716847980D-02 7.9511437514797D-02 7.7669440707933D-02\n', ' 7.5837985750183D-02 7.4019848683127D-02 7.2217173550290D-02 7.0432552543537D-02\n', ' 6.8667944717381D-02 6.6925716774659D-02 6.5207621732588D-02 6.3515790697594D-02\n', ' 6.1851770094075D-02 6.0217459462453D-02 5.8614207514774D-02 5.7043693029070D-02\n', ' 5.5507080359998D-02 5.4005841601790D-02 5.4005841601790D-02 5.2263824313830D-02\n', ' 5.0522367654505D-02 4.8784814510288D-02 4.7054279454268D-02 4.5333661673017D-02\n', ' 4.3625656507668D-02 4.1932767436693D-02 4.0257316754695D-02 3.8601456580307D-02\n', ' 3.6967178652344D-02 3.5356324374584D-02 3.3770593740070D-02 3.2211554441461D-02\n', ' 3.0680649955052D-02 2.9179207759022D-02 2.7708446619271D-02 2.6269483967497D-02\n', ' 2.4863342436704D-02 2.3490956455181D-02 2.2153178083525D-02 2.0850782882928D-02\n', ' 1.9584475106806D-02 1.8354892901183D-02 1.7162612904308D-02 1.6008154836202D-02\n', ' 1.4891985557848D-02 1.3814523105064D-02 1.2776140256870D-02 1.1777168066229D-02\n', ' 1.0817898984733D-02 9.8985899398210D-03 9.0194650600126D-03 8.1807183450144D-03\n', ' 7.3825160325766D-03 6.6249989050499D-03 5.9082843358347D-03 5.2324682720632D-03\n', ' 4.5976269960944D-03 4.0038188207973D-03 3.4510855982040D-03 2.9394541610729D-03\n', ' 2.4689376079033D-03 2.0395365212476D-03 1.6512400557334D-03 1.3040269608203D-03\n', ' 9.9786649580119D-04 7.3271928200883D-04 5.0853806644997D-04 3.2526842597670D-04\n', ' 1.8284939888544D-04 8.1214061348428D-05 2.0290044257939D-05 3.3281712055412D-15\n', '   25\n', ' 3.8565390690777D-03 4.0952509964394D-03 4.3237753654734D-03 4.5392323340571D-03\n', ' 4.7392774161014D-03 4.9220556533332D-03 5.0861782472521D-03 5.2306788542157D-03\n', ' 5.3549849172102D-03 5.4588767055583D-03 5.5424622602038D-03 5.6061439750483D-03\n', ' 5.6505996955531D-03 5.6767570716591D-03 5.6857808742494D-03 5.6790539483934D-03\n', ' 5.6581698846642D-03 5.6249191795723D-03 5.5812866484720D-03 5.5294416089315D-03\n', ' 5.4717398183156D-03 5.4107168031715D-03 5.3490944747267D-03 5.2897769384020D-03\n', ' 5.2358621926376D-03 5.1906398201868D-03 5.1576082940866D-03 5.1404738775103D-03\n', ' 5.1431740615134D-03 5.1698768072105D-03 5.2250105602600D-03 5.3132627078822D-03\n', ' 5.4396165249015D-03 5.6093474868673D-03 5.8280675340085D-03 6.1017178634445D-03\n', ' 6.4366212811911D-03 6.8394705903592D-03 7.3173908802848D-03 7.8779240305269D-03\n', ' 8.5291049469288D-03 9.2794453620494D-03 1.0138031469335D-02 1.1114514080077D-02\n', ' 1.2219239424679D-02 1.3463256927587D-02 1.4858498731734D-02 1.6417818894650D-02\n', ' 1.8155238180113D-02 2.0086026934507D-02 2.2227027983537D-02 2.4596788714175D-02\n', ' 2.7215967012950D-02 3.0107508219847D-02 3.3297130896519D-02 3.6813536323892D-02\n', ' 4.0688968091129D-02 4.4959440327214D-02 4.9665370980325D-02 5.4851820453957D-02\n', ' 6.0569211520691D-02 6.6873579504843D-02 7.3827403038884D-02 8.1499874974843D-02\n', ' 8.9967889585518D-02 8.9984369231237D-02 9.0384025691213D-02 9.0785011659116D-02\n', ' 9.1187330241102D-02 9.1590984543533D-02 9.1995977678565D-02 9.2402312758491D-02\n', ' 9.2809992901379D-02 9.3219021225379D-02 9.3629400854492D-02 9.3629400854492D-02\n', ' 9.2672017689632D-02 9.1943611658241D-02 9.1419826609075D-02 9.1077771392490D-02\n', ' 9.0895937779238D-02 9.0854127174252D-02 9.0933379997361D-02 9.1115912053514D-02\n', ' 9.1385053084379D-02 9.1725190882112D-02 9.2121717244278D-02 9.2560978367455D-02\n', ' 9.3030226857552D-02 9.3517577281578D-02 9.4011963192864D-02 9.4503096984443D-02\n', ' 9.4981431128921D-02 9.5438121677756D-02 9.5864993094842D-02 9.6254504898374D-02\n', ' 9.6599719604321D-02 9.6894272120925D-02 9.7132340429337D-02 9.7308617417405D-02\n', ' 9.7418283996416D-02 9.7456983140480D-02 9.7420795193823D-02 9.7306213917911D-02\n', ' 9.7110123796749D-02 9.6829777929112D-02 9.6462777166294D-02 9.6007049715950D-02\n', ' 9.5460831968948D-02 9.4822649701766D-02 9.4091300473128D-02 9.3265836315089D-02\n', ' 9.2345547592521D-02 9.1329947094416D-02 9.0218755255100D-02 8.9011885559865D-02\n', ' 8.7709431041754D-02 8.6311650917511D-02 8.4818958278386D-02 8.3231907878145D-02\n', ' 8.1551184945407D-02 7.9777594048276D-02 7.9777594048276D-02 7.8187442161728D-02\n', ' 7.6615766860263D-02 7.5045706805297D-02 7.3474482438474D-02 7.1902716041724D-02\n', ' 7.0331576415060D-02 6.8763203975420D-02 6.7199432473560D-02 6.5642660983431D-02\n', ' 6.4094798981413D-02 6.2558192650947D-02 6.1034654039491D-02 5.9526373949262D-02\n', ' 5.8035008083465D-02 5.6562556671095D-02 5.5110501282245D-02 5.3680643030607D-02\n', ' 5.2274288883357D-02 5.0893044245276D-02 4.9538048985998D-02 4.8210721932109D-02\n', ' 4.6912047142905D-02 4.5643268765106D-02 4.5643268765106D-02 4.4170995379302D-02\n', ' 4.2699195811548D-02 4.1230695316563D-02 3.9768126189104D-02 3.8313938689130D-02\n', ' 3.6870410795753D-02 3.5439658334443D-02 3.4023644002444D-02 3.2624186672056D-02\n', ' 3.1242969669806D-02 2.9881549265998D-02 2.8541362217064D-02 2.7223733465121D-02\n', ' 2.5929882970362D-02 2.4660932656633D-02 2.3417912569221D-02 2.2201767110226D-02\n', ' 2.1013360562385D-02 1.9853482661711D-02 1.8722853530924D-02 1.7622128638860D-02\n', ' 1.6551903188381D-02 1.5512716511243D-02 1.4505055955811D-02 1.3529360765665D-02\n', ' 1.2586025510391D-02 1.1675403494748D-02 1.0797809774534D-02 9.9535241405909D-03\n', ' 9.1427937596346D-03 8.3658357750065D-03 7.6228396098920D-03 6.9139692239858D-03\n', ' 6.2393651138520D-03 5.5991462622808D-03 4.9934118679366D-03 4.4222430209513D-03\n', ' 3.8857041916842D-03 3.3838446635318D-03 2.9166998079174D-03 2.4842923026759D-03\n', ' 2.0866332180555D-03 1.7237230464154D-03 1.3955526217530D-03 1.1021039840857D-03\n', ' 8.4335115278083D-04 6.1926084679667D-04 4.2979313006454D-04 2.7490200663692D-04\n', ' 1.5453595447388D-04 6.8638412617807D-05 1.7148218015763D-05 2.6046745821324D-15\n', '    1\n', 'Cu29 POTENTIAL                      exc: Vosko,Wilk,Nusair       #serial: kkrimp_v1.2-26-g84cbc08_serial_20180502163421                                             \n', '   2.38779078000000        4.82381975000676        2.38779078000000     \n', '  29.00000\n', '   3.41096   0.6285993399   0.7168465117\n', '484\n', ' 0.25000000D-01 0.39783834D-03\n', ' 5 1\n', '    0  -6.48338926687D+02\n', '    0  -7.71318775307D+01\n', '    0  -7.57179639043D+00\n', '    1  -6.65450234120D+01\n', '    1  -4.47233316155D+00\n', '  484  199   25    1\n', ' 2.1759441563850D+02 2.1819475121581D+02 2.1881026277529D+02 2.1917688226597D+02\n', ' 2.1944135912878D+02 2.1965147446928D+02 2.1982711603689D+02 2.1997904866255D+02\n', ' 2.2011373532154D+02 2.2023534880980D+02 2.2034673492315D+02 2.2044992377999D+02\n', ' 2.2054641319570D+02 2.2063734156985D+02 2.2072359334914D+02 2.2080587104037D+02\n', ' 2.2088474079057D+02 2.2096066721699D+02 2.2103403510634D+02 2.2110516838065D+02\n', ' 2.2117434101050D+02 2.2124178844032D+02 2.2130771314876D+02 2.2137229217697D+02\n', ' 2.2143567982915D+02 2.2149801304784D+02 2.2155941249269D+02 2.2161998665980D+02\n', ' 2.2167983199448D+02 2.2173903624371D+02 2.2179767796937D+02 2.2185582941389D+02\n', ' 2.2191355562821D+02 2.2197091701775D+02 2.2202796821515D+02 2.2208476041013D+02\n', ' 2.2214134004814D+02 2.2219775099111D+02 2.2225403016744D+02 2.2231022177106D+02\n', ' 2.2236635710035D+02 2.2242246929264D+02 2.2247858848891D+02 2.2253474377113D+02\n', ' 2.2259096154602D+02 2.2264726743839D+02 2.2270368464028D+02 2.2276023577023D+02\n', ' 2.2281694119585D+02 2.2287382086615D+02 2.2293089261344D+02 2.2298817396392D+02\n', ' 2.2304568042301D+02 2.2310342726813D+02 2.2316142782058D+02 2.2321969522327D+02\n', ' 2.2327824070138D+02 2.2333707532730D+02 2.2339620827166D+02 2.2345564855695D+02\n', ' 2.2351540330027D+02 2.2357547945683D+02 2.2363588205515D+02 2.2369661593144D+02\n', ' 2.2375768395784D+02 2.2381908876834D+02 2.2388083098046D+02 2.2394291091318D+02\n', ' 2.2400532680239D+02 2.2406807651116D+02 2.2413115573908D+02 2.2419455972509D+02\n', ' 2.2425828145095D+02 2.2432231333668D+02 2.2438664543812D+02 2.2445126713521D+02\n', ' 2.2451616532357D+02 2.2458132609569D+02 2.2464673292651D+02 2.2471236834757D+02\n', ' 2.2477821212653D+02 2.2484424293430D+02 2.2491043651852D+02 2.2497676736368D+02\n', ' 2.2504320685853D+02 2.2510972494932D+02 2.2517628830113D+02 2.2524286194430D+02\n', ' 2.2530940742983D+02 2.2537588446909D+02 2.2544224908348D+02 2.2550845523766D+02\n', ' 2.2557445298364D+02 2.2564019008789D+02 2.2570561017016D+02 2.2577065432493D+02\n', ' 2.2583525925538D+02 2.2589935888975D+02 2.2596288251106D+02 2.2602575636901D+02\n', ' 2.2608790180626D+02 2.2614923686675D+02 2.2620967441944D+02 2.2626912376414D+02\n', ' 2.2632748875386D+02 2.2638466939939D+02 2.2644055999164D+02 2.2649505070658D+02\n', ' 2.2654802572916D+02 2.2659936486036D+02 2.2664894164467D+02 2.2669662498134D+02\n', ' 2.2674227725759D+02 2.2678575596652D+02 2.2682691184863D+02 2.2686559051906D+02\n', ' 2.2690163062039D+02 2.2693486546227D+02 2.2696512118873D+02 2.2699221843378D+02\n', ' 2.2701597050675D+02 2.2703618506774D+02 2.2705266233499D+02 2.2706519678433D+02\n', ' 2.2707357538302D+02 2.2707757931767D+02 2.2707698225926D+02 2.2707155212442D+02\n', ' 2.2706104937660D+02 2.2704522882578D+02 2.2702383797105D+02 2.2699661884410D+02\n', ' 2.2696330639850D+02 2.2692363040248D+02 2.2687731388031D+02 2.2682407505970D+02\n', ' 2.2676362587065D+02 2.2669567395265D+02 2.2661992121619D+02 2.2653606591456D+02\n', ' 2.2644380127248D+02 2.2634281762692D+02 2.2623280112671D+02 2.2611343594579D+02\n', ' 2.2598440305663D+02 2.2584538251815D+02 2.2569605232456D+02 2.2553609076865D+02\n', ' 2.2536517536585D+02 2.2518298529179D+02 2.2498920037927D+02 2.2478350362652D+02\n', ' 2.2456558026238D+02 2.2433512031894D+02 2.2409181775703D+02 2.2383537309383D+02\n', ' 2.2356549257724D+02 2.2328189085529D+02 2.2298429018422D+02 2.2267242312218D+02\n', ' 2.2234603175144D+02 2.2200487037460D+02 2.2164870472650D+02 2.2127731464621D+02\n', ' 2.2089049324947D+02 2.2048804954470D+02 2.2006980753177D+02 2.1963560872530D+02\n', ' 2.1918531114061D+02 2.1871879168310D+02 2.1823594497806D+02 2.1773668558056D+02\n', ' 2.1722094660225D+02 2.1668868169380D+02 2.1613986341967D+02 2.1557448496378D+02\n', ' 2.1499255820352D+02 2.1439411509101D+02 2.1377920538053D+02 2.1314789764164D+02\n', ' 2.1250027660557D+02 2.1183644377599D+02 2.1115651436290D+02 2.1046061748192D+02\n', ' 2.0974889267201D+02 2.0902148968820D+02 2.0827856462999D+02 2.0752027937237D+02\n', ' 2.0674679737217D+02 2.0595828283062D+02 2.0515489630039D+02 2.0433679373548D+02\n', ' 2.0350412209118D+02 2.0265701849283D+02 2.0179560610146D+02 2.0091999371609D+02\n', ' 2.0003027226069D+02 1.9912651521224D+02 1.9820877613011D+02 1.9727709034808D+02\n', ' 1.9633147398381D+02 1.9537192730795D+02 1.9439843559222D+02 1.9341097442320D+02\n', ' 1.9240951252367D+02 1.9139401896888D+02 1.9036446771897D+02 1.8932084621831D+02\n', ' 1.8826316083923D+02 1.8719144578047D+02 1.8610576807707D+02 1.8500623524759D+02\n', ' 1.8389299820288D+02 1.8276625597726D+02 1.8162625501544D+02 1.8047328975900D+02\n', ' 1.7930769751295D+02 1.7812985462709D+02 1.7694016728062D+02 1.7573906419785D+02\n', ' 1.7452698483161D+02 1.7330437052068D+02 1.7207165225050D+02 1.7082924252562D+02\n', ' 1.6957752490073D+02 1.6831684852739D+02 1.6704752106269D+02 1.6576980707048D+02\n', ' 1.6448392503088D+02 1.6319004987128D+02 1.6188831394372D+02 1.6057881320557D+02\n', ' 1.5926161140883D+02 1.5793674897193D+02 1.5660424928904D+02 1.5526412912797D+02\n', ' 1.5391640587163D+02 1.5256110827071D+02 1.5119828349169D+02 1.4982800716485D+02\n', ' 1.4845038926105D+02 1.4706558254124D+02 1.4567378646660D+02 1.4427525335760D+02\n', ' 1.4287028973201D+02 1.4145925967252D+02 1.4004258319916D+02 1.3862073655179D+02\n', ' 1.3719424741217D+02 1.3576369203189D+02 1.3432968734059D+02 1.3289288509486D+02\n', ' 1.3145396119864D+02 1.3001360731834D+02 1.2857251804149D+02 1.2713138078703D+02\n', ' 1.2569086183440D+02 1.2425159580954D+02 1.2281417214163D+02 1.2137912598684D+02\n', ' 1.1994692729722D+02 1.1851797568245D+02 1.1709259485733D+02 1.1567103435688D+02\n', ' 1.1425347221260D+02 1.1284002597012D+02 1.1143076517616D+02 1.1002573184119D+02\n', ' 1.0862496083974D+02 1.0722850539804D+02 1.0583645829896D+02 1.0444897295863D+02\n', ' 1.0306627469407D+02 1.0168866698066D+02 1.0031652468497D+02 9.8950281535736D+01\n', ' 9.7590406592757D+01 9.6237379437951D+01 9.4891660449011D+01 9.3553666323648D+01\n', ' 9.2223746534976D+01 9.0902169387375D+01 8.9589111477133D+01 8.8284657392085D+01\n', ' 8.6988801958609D+01 8.5701460824096D+01 8.4422481296008D+01 8.3151658731970D+01\n', ' 8.1888750882168D+01 8.0633495793775D+01 7.9385625690446D+01 7.8144883193238D+01\n', ' 7.6911032485454D+01 7.5683872147021D+01 7.4463242511212D+01 7.3249034469117D+01\n', ' 7.2041192786894D+01 7.0839720974575D+01 6.9644680822992D+01 6.8456193805239D+01\n', ' 6.7274437458763D+01 6.6099644008936D+01 6.4932094355076D+01 6.3772114708800D+01\n', ' 6.2620068988986D+01 6.1476354271855D+01 6.0341392368212D+01 5.9215624820188D+01\n', ' 5.8099504346808D+01 5.6993490014576D+01 5.5898039113731D+01 5.4813602994596D+01\n', ' 5.3740619794101D+01 5.2679511283489D+01 5.1630676718269D+01 5.0594490899448D+01\n', ' 4.9571299282324D+01 4.8561417323619D+01 4.7565126864276D+01 4.6582676725353D+01\n', ' 4.5614280281863D+01 4.4660117183703D+01 4.3720331962240D+01 4.2795036687884D+01\n', ' 4.1884310396145D+01 4.0988202447476D+01 4.0106732521637D+01 3.9239894415254D+01\n', ' 3.8387656331152D+01 3.7549964835912D+01 3.6726745168292D+01 3.5917905089852D+01\n', ' 3.5123334963430D+01 3.4342911275550D+01 3.3576496301905D+01 3.2823941166586D+01\n', ' 3.2085085015289D+01 3.1359757592449D+01 3.0647777962729D+01 2.9948956701266D+01\n', ' 2.9263094301912D+01 2.8589983148601D+01 2.7929405791911D+01 2.7281136877294D+01\n', ' 2.6644941445248D+01 2.6020577052810D+01 2.5407791832336D+01 2.4806327243964D+01\n', ' 2.4215916019473D+01 2.4217296667081D+01 2.4191047140217D+01 2.4164848894740D+01\n', ' 2.4138701763903D+01 2.4112605581851D+01 2.4086560183238D+01 2.4060565403594D+01\n', ' 2.4034621078955D+01 2.4008727046229D+01 2.3982883142818D+01 2.3982883142818D+01\n', ' 2.3906676013917D+01 2.3830804274745D+01 2.3755270583097D+01 2.3680077373912D+01\n', ' 2.3605226870735D+01 2.3530721095155D+01 2.3456561876909D+01 2.3382750862431D+01\n', ' 2.3309289523592D+01 2.3236179165301D+01 2.3163420933498D+01 2.3091015821750D+01\n', ' 2.3018964678451D+01 2.2947268212692D+01 2.2875927000740D+01 2.2804941491271D+01\n', ' 2.2734312011222D+01 2.2664038770471D+01 2.2594121867132D+01 2.2524561291720D+01\n', ' 2.2455356932116D+01 2.2386508577113D+01 2.2318015920947D+01 2.2249878566686D+01\n', ' 2.2182096030209D+01 2.2114667743319D+01 2.2047593057381D+01 2.1980871246156D+01\n', ' 2.1914501509131D+01 2.1848482974106D+01 2.1782814700254D+01 2.1717495680452D+01\n', ' 2.1652524844246D+01 2.1587901059797D+01 2.1523623136624D+01 2.1459689827580D+01\n', ' 2.1396099831230D+01 2.1332851793712D+01 2.1269944310940D+01 2.1207375930331D+01\n', ' 2.1145145152831D+01 2.1083250434525D+01 2.1021690188517D+01 2.0960462786425D+01\n', ' 2.0899566560082D+01 2.0838999803082D+01 2.0838999803082D+01 2.0784369206998D+01\n', ' 2.0729953980003D+01 2.0675774720955D+01 2.0621838348757D+01 2.0568148639711D+01\n', ' 2.0514707620129D+01 2.0461516590677D+01 2.0408576100111D+01 2.0355886443851D+01\n', ' 2.0303447467111D+01 2.0251258922982D+01 2.0199320249997D+01 2.0147630864093D+01\n', ' 2.0096189942478D+01 2.0044996673656D+01 1.9994050055783D+01 1.9943349115814D+01\n', ' 1.9892892724348D+01 1.9842679789806D+01 1.9792709089676D+01 1.9742979443660D+01\n', ' 1.9693489560241D+01 1.9644238192180D+01 1.9644238192180D+01 1.9586732853297D+01\n', ' 1.9529564638167D+01 1.9472730952971D+01 1.9416229202614D+01 1.9360056793792D+01\n', ' 1.9304211137528D+01 1.9248689651576D+01 1.9193489762267D+01 1.9138608906555D+01\n', ' 1.9084044533419D+01 1.9029794105367D+01 1.8975855099623D+01 1.8922225009280D+01\n', ' 1.8868901344220D+01 1.8815881632023D+01 1.8763163418666D+01 1.8710744269224D+01\n', ' 1.8658621768397D+01 1.8606793521050D+01 1.8555257152592D+01 1.8504010309371D+01\n', ' 1.8453050658946D+01 1.8402375890365D+01 1.8351983714336D+01 1.8301871863409D+01\n', ' 1.8252038092074D+01 1.8202480176858D+01 1.8153195916357D+01 1.8104183131266D+01\n', ' 1.8055439664361D+01 1.8006963380498D+01 1.7958752166435D+01 1.7910803930933D+01\n', ' 1.7863116604538D+01 1.7815688139495D+01 1.7768516509626D+01 1.7721599710180D+01\n', ' 1.7674935757680D+01 1.7628522689760D+01 1.7582358564978D+01 1.7536441462645D+01\n', ' 1.7490769482617D+01 1.7445340745107D+01 1.7400153390473D+01 1.7355205579004D+01\n', ' 1.7310495490707D+01 1.7266021325090D+01 1.7221781300930D+01 1.7177773656056D+01\n', ' 1.7133996647110D+01 1.7090448549332D+01 1.7047127656312D+01 1.7004032279769D+01\n', '    3\n', '-1.0867779006195D-07-1.1143124977115D-07-1.1425441335264D-07-1.1714904533996D-07\n', '-1.2011695503167D-07-1.2315999739211D-07-1.2628007444377D-07-1.2947913636764D-07\n', '-1.3275918263589D-07-1.3612226339520D-07-1.3957048073142D-07-1.4310598986445D-07\n', '-1.4673100062566D-07-1.5044777876192D-07-1.5425864744593D-07-1.5816598858177D-07\n', '-1.6217224442119D-07-1.6627991904903D-07-1.7049157990376D-07-1.7480985947726D-07\n', '-1.7923745683781D-07-1.8377713947322D-07-1.8843174487595D-07-1.9320418236725D-07\n', '-1.9809743494856D-07-2.0311456115267D-07-2.0825869689954D-07-2.1353305754015D-07\n', '-2.1894093977548D-07-2.2448572387168D-07-2.3017087554182D-07-2.3599994831798D-07\n', '-2.4197658567721D-07-2.4810452332346D-07-2.5438759153141D-07-2.6082971754502D-07\n', '-2.6743492803553D-07-2.7420735156993D-07-2.8115122126964D-07-2.8827087737198D-07\n', '-2.9557076998905D-07-3.0305546188537D-07-3.1072963132303D-07-3.1859807495971D-07\n', '-3.2666571087258D-07-3.3493758159167D-07-3.4341885732249D-07-3.5211483909051D-07\n', '-3.6103096212389D-07-3.7017279920255D-07-3.7954606416689D-07-3.8915661549584D-07\n', '-3.9901045994275D-07-4.0911375634153D-07-4.1947281940516D-07-4.3009412371517D-07\n', '-4.4098430776522D-07-4.5215017809860D-07-4.6359871358183D-07-4.7533706975953D-07\n', '-4.8737258332349D-07-4.9971277671222D-07-5.1236536278858D-07-5.2533824969743D-07\n', '-5.3863954574322D-07-5.3863954683316D-07-5.3924408153610D-07-5.3984861623105D-07\n', '-5.4045315092988D-07-5.4105768562067D-07-5.4166222031044D-07-5.4226675500117D-07\n', '-5.4287128968668D-07-5.4347582437449D-07-5.4408035905565D-07-5.4408035905565D-07\n', '-5.3487219540304D-07-5.2566522639328D-07-5.1645943814359D-07-5.0725481701544D-07\n', '-4.9805134959382D-07-4.8884902266989D-07-4.7964782325720D-07-4.7044773859439D-07\n', '-4.6124875611580D-07-4.5205086346224D-07-4.4285404848350D-07-4.3365829920055D-07\n', '-4.2446360386034D-07-4.1526995087164D-07-4.0607732884372D-07-3.9688572656285D-07\n', '-3.8769513299072D-07-3.7850553726841D-07-3.6931692870360D-07-3.6012929677820D-07\n', '-3.5094263113429D-07-3.4175692157225D-07-3.3257215806487D-07-3.2338833072560D-07\n', '-3.1420542983424D-07-3.0502344580883D-07-2.9584236922026D-07-2.8666219078797D-07\n', '-2.7748290136484D-07-2.6830449195589D-07-2.5912695368935D-07-2.4995027783141D-07\n', '-2.4077445579073D-07-2.3159947909057D-07-2.2242533938988D-07-2.1325202847286D-07\n', '-2.0407953824118D-07-1.9490786072643D-07-1.8573698806822D-07-1.7656691252463D-07\n', '-1.6739762647721D-07-1.5822912240842D-07-1.4906139291515D-07-1.3989443070378D-07\n', '-1.3072822858809D-07-1.2156277947945D-07-1.2156277947945D-07-1.1432829733311D-07\n', '-1.0796343661092D-07-1.0215203729189D-07-9.6778871024563D-08-9.1776301726341D-08\n', '-8.7098095466856D-08-8.2709931750158D-08-7.8584965646604D-08-7.4701424538074D-08\n', '-7.1041173547778D-08-6.7588797067391D-08-6.4330978657754D-08-6.1256064591813D-08\n', '-5.8353746124305D-08-5.5614821704438D-08-5.3031014796970D-08-5.0594831537086D-08\n', '-4.8299447572786D-08-4.6138616779558D-08-4.4106596631195D-08-4.2198086504260D-08\n', '-4.0408176120195D-08-3.8732302083478D-08-3.8732302083478D-08-3.6866998787462D-08\n', '-3.5073012702979D-08-3.3347390897038D-08-3.1687389070729D-08-3.0090449748575D-08\n', '-2.8554183514151D-08-2.7076352764323D-08-2.5654857557636D-08-2.4287723222581D-08\n', '-2.2973089452126D-08-2.1709200665062D-08-2.0494397443166D-08-1.9327108903098D-08\n', '-1.8205845871024D-08-1.7129194751886D-08-1.6095812014088D-08-1.5104419201687D-08\n', '-1.4153798418702D-08-1.3242788226498D-08-1.2370279909204D-08-1.1535214063098D-08\n', '-1.0736577477594D-08-9.9734002757359D-09-9.2447532870992D-09-8.5497456299943D-09\n', '-7.8875224819367D-09-7.2572630203360D-09-6.6581785171551D-09-6.0895105735351D-09\n', '-5.5505294809427D-09-5.0405326980078D-09-4.5588434332698D-09-4.1048093240004D-09\n', '-3.6778012033360D-09-3.2772119484323D-09-2.9024554033356D-09-2.5529653697086D-09\n', '-2.2281946610893D-09-1.9276142150486D-09-1.6507122594611D-09-1.3969935280592D-09\n', '-1.1659785223464D-09-9.5720281624478D-10-7.7021640028848D-10-6.0458306274372D-10\n', '-4.5987980510989D-10-3.3569628952538D-10-2.3163431601958D-10-1.4730732760431D-10\n', '-8.2339941379803D-11-3.6367503950138D-11-9.0356696356114D-12-1.1478470661648D-20\n', '    4\n', '-1.0867779006974D-07-1.1143124977635D-07-1.1425441336359D-07-1.1714904535944D-07\n', '-1.2011695504025D-07-1.2315999740646D-07-1.2628007448608D-07-1.2947913636855D-07\n', '-1.3275918265644D-07-1.3612226341599D-07-1.3957048073580D-07-1.4310598987462D-07\n', '-1.4673100064163D-07-1.5044777878369D-07-1.5425864745131D-07-1.5816598859576D-07\n', '-1.6217224444100D-07-1.6627991905524D-07-1.7049157991581D-07-1.7480985949794D-07\n', '-1.7923745685879D-07-1.8377713948619D-07-1.8843174488924D-07-1.9320418237255D-07\n', '-1.9809743496806D-07-2.0311456116420D-07-2.0825869690310D-07-2.1353305752741D-07\n', '-2.1894093979226D-07-2.2448572387080D-07-2.3017087555799D-07-2.3599994833732D-07\n', '-2.4197658570113D-07-2.4810452334226D-07-2.5438759154647D-07-2.6082971757025D-07\n', '-2.6743492805289D-07-2.7420735158915D-07-2.8115122127270D-07-2.8827087737832D-07\n', '-2.9557077000145D-07-3.0305546190523D-07-3.1072963134066D-07-3.1859807498345D-07\n', '-3.2666571089065D-07-3.3493758162074D-07-3.4341885734800D-07-3.5211483911386D-07\n', '-3.6103096214997D-07-3.7017279922998D-07-3.7954606419569D-07-3.8915661552465D-07\n', '-3.9901045997228D-07-4.0911375637110D-07-4.1947281943133D-07-4.3009412374490D-07\n', '-4.4098430779992D-07-4.5215017813413D-07-4.6359871361612D-07-4.7533706979055D-07\n', '-4.8737258336027D-07-4.9971277674785D-07-5.1236536283140D-07-5.2533824973222D-07\n', '-5.3863954578110D-07-5.3863954687313D-07-5.3924408157472D-07-5.3984861627249D-07\n', '-5.4045315096442D-07-5.4105768566220D-07-5.4166222034994D-07-5.4226675504210D-07\n', '-5.4287128972974D-07-5.4347582441204D-07-5.4408035909672D-07-5.4408035909672D-07\n', '-5.3487219544000D-07-5.2566522643088D-07-5.1645943818318D-07-5.0725481705359D-07\n', '-4.9805134962690D-07-4.8884902270124D-07-4.7964782329384D-07-4.7044773862575D-07\n', '-4.6124875614859D-07-4.5205086349376D-07-4.4285404851062D-07-4.3365829923506D-07\n', '-4.2446360389004D-07-4.1526995090236D-07-4.0607732887458D-07-3.9688572659205D-07\n', '-3.8769513301774D-07-3.7850553729578D-07-3.6931692873065D-07-3.6012929680280D-07\n', '-3.5094263115903D-07-3.4175692159922D-07-3.3257215808675D-07-3.2338833075034D-07\n', '-3.1420542985456D-07-3.0502344583056D-07-2.9584236924288D-07-2.8666219080802D-07\n', '-2.7748290138683D-07-2.6830449197407D-07-2.5912695370651D-07-2.4995027785067D-07\n', '-2.4077445580722D-07-2.3159947910515D-07-2.2242533940497D-07-2.1325202848649D-07\n', '-2.0407953825474D-07-1.9490786073953D-07-1.8573698807973D-07-1.7656691253814D-07\n', '-1.6739762648857D-07-1.5822912241868D-07-1.4906139292512D-07-1.3989443071372D-07\n', '-1.3072822859546D-07-1.2156277948729D-07-1.2156277948729D-07-1.1432829734031D-07\n', '-1.0796343661810D-07-1.0215203729841D-07-9.6778871031289D-08-9.1776301732047D-08\n', '-8.7098095472488D-08-8.2709931755624D-08-7.8584965651378D-08-7.4701424542833D-08\n', '-7.1041173551956D-08-6.7588797070979D-08-6.4330978661940D-08-6.1256064595104D-08\n', '-5.8353746128106D-08-5.5614821707981D-08-5.3031014800022D-08-5.0594831539688D-08\n', '-4.8299447576299D-08-4.6138616782324D-08-4.4106596633698D-08-4.2198086506750D-08\n', '-4.0408176122906D-08-3.8732302085844D-08-3.8732302085844D-08-3.6866998789646D-08\n', '-3.5073012704776D-08-3.3347390899014D-08-3.1687389072805D-08-3.0090449750158D-08\n', '-2.8554183515995D-08-2.7076352766008D-08-2.5654857559011D-08-2.4287723223946D-08\n', '-2.2973089453595D-08-2.1709200666603D-08-2.0494397444209D-08-1.9327108904365D-08\n', '-1.8205845871926D-08-1.7129194752786D-08-1.6095812015053D-08-1.5104419202672D-08\n', '-1.4153798419571D-08-1.3242788227246D-08-1.2370279909902D-08-1.1535214063715D-08\n', '-1.0736577478230D-08-9.9734002762866D-09-9.2447532876669D-09-8.5497456305003D-09\n', '-7.8875224823528D-09-7.2572630206897D-09-6.6581785175710D-09-6.0895105739200D-09\n', '-5.5505294812310D-09-5.0405326983313D-09-4.5588434335505D-09-4.1048093242010D-09\n', '-3.6778012035264D-09-3.2772119486275D-09-2.9024554035048D-09-2.5529653698606D-09\n', '-2.2281946611926D-09-1.9276142151703D-09-1.6507122595617D-09-1.3969935281346D-09\n', '-1.1659785224130D-09-9.5720281629672D-10-7.7021640032761D-10-6.0458306277636D-10\n', '-4.5987980513272D-10-3.3569628954093D-10-2.3163431603337D-10-1.4730732761292D-10\n', '-8.2339941383794D-11-3.6367503952119D-11-9.0356696360223D-12-1.1485845545137D-20\n', '    8\n', '-3.2861672683330D-09-3.4547859416091D-09-3.6320530866578D-09-3.8184121673876D-09\n', '-4.0143293967749D-09-4.2202949558453D-09-4.4368241086255D-09-4.6644586005588D-09\n', '-4.9037679328077D-09-5.1553508128285D-09-5.4198366341921D-09-5.6978871136150D-09\n', '-5.9901979010805D-09-6.2975002463089D-09-6.6205630013878D-09-6.9601943583911D-09\n', '-7.3172439963853D-09-7.6926051432983D-09-8.0872168292636D-09-8.5020662301885D-09\n', '-8.9381911532047D-09-9.3966825966436D-09-9.8786875048129D-09-1.0385411621029D-08\n', '-1.0918122525864D-08-1.1478152749508D-08-1.2066903196543D-08-1.2685846532032D-08\n', '-1.3336530993563D-08-1.4020584122915D-08-1.4739716947433D-08-1.5495728221612D-08\n', '-1.6290508901963D-08-1.7126046895548D-08-1.8004432027051D-08-1.8927861265605D-08\n', '-1.9898644221317D-08-2.0919208912404D-08-2.1992107840243D-08-2.3120024372990D-08\n', '-2.4305779472052D-08-2.5552338699496D-08-2.6862819697430D-08-2.8240499937997D-08\n', '-2.9688824936188D-08-3.1211416882171D-08-3.2812083666745D-08-3.4494828449248D-08\n', '-3.6263859634835D-08-3.8123601402090D-08-4.0078704791253D-08-4.2134059325604D-08\n', '-4.4294805220338D-08-4.6566346251529D-08-4.8954363279080D-08-5.1464828418453D-08\n', '-5.4104020010762D-08-5.6878538290531D-08-5.9795321892097D-08-6.2861665209791D-08\n', '-6.6085236615431D-08-6.9474097652369D-08-7.3036723159855D-08-7.6782022499666D-08\n', '-8.0719361795226D-08-8.0719360134552D-08-8.0900648248702D-08-8.1082139714490D-08\n', '-8.1263834522314D-08-8.1445732682425D-08-8.1627834184700D-08-8.1810139032800D-08\n', '-8.1992647230133D-08-8.2175358771857D-08-8.2358273658608D-08-8.2358273658608D-08\n', '-8.0705020096699D-08-7.9060935623780D-08-7.7425638468268D-08-7.5798754867175D-08\n', '-7.4179918859992D-08-7.2568772126672D-08-7.0964963783945D-08-6.9368150236511D-08\n', '-6.7777994967660D-08-6.6194168405478D-08-6.4616347742817D-08-6.3044216791196D-08\n', '-6.1477465802664D-08-5.9915791351757D-08-5.8358896158018D-08-5.6806488972419D-08\n', '-5.5258284412693D-08-5.3714002840322D-08-5.2173370235154D-08-5.0636118053592D-08\n', '-4.9101983109771D-08-4.7570707453828D-08-4.6042038256102D-08-4.4515727683121D-08\n', '-4.2991532789789D-08-4.1469215414048D-08-3.9948542059443D-08-3.8429283795900D-08\n', '-3.6911216164510D-08-3.5394119063705D-08-3.3877776663017D-08-3.2361977305095D-08\n', '-3.0846513418654D-08-2.9331181418283D-08-2.7815781623810D-08-2.6300118178448D-08\n', '-2.4783998954613D-08-2.3267235483396D-08-2.1749642866756D-08-2.0231039706851D-08\n', '-1.8711248026715D-08-1.7190093194870D-08-1.5667403859446D-08-1.4143011872297D-08\n', '-1.2616752222519D-08-1.1088462969269D-08-1.1088462969269D-08-9.9224355599410D-09\n', '-8.9337933530799D-09-8.0571017875313D-09-7.2684522945165D-09-6.5537844426155D-09\n', '-5.9034723959969D-09-5.3103625071563D-09-4.7688549357185D-09-4.2744059675736D-09\n', '-3.8232307037416D-09-3.4121125445986D-09-3.0382744445379D-09-2.6992882000608D-09\n', '-2.3930083439831D-09-2.1175226110335D-09-1.8711139444097D-09-1.6522307678411D-09\n', '-1.4594633236464D-09-1.2915245558291D-09-1.1472344603048D-09-1.0255071261028D-09\n', '-9.2533989087189D-10-8.4580418340418D-10-8.4580418340418D-10-7.6762649021122D-10\n', '-6.9592618706247D-10-6.3019397349425D-10-5.6996380399607D-10-5.1480828446244D-10\n', '-4.6433470760346D-10-4.1818161694536D-10-3.7601581127082D-10-3.3752971933535D-10\n', '-3.0243908808545D-10-2.7048093722246D-10-2.4141174223447D-10-2.1500581444827D-10\n', '-1.9105385072385D-10-1.6936163135961D-10-1.4974884749349D-10-1.3204804148020D-10\n', '-1.1610364725123D-10-1.0177111891359D-10-8.8916137419429D-11-7.7413886765272D-11\n', '-6.7148392329193D-11-5.8011914767896D-11-4.9904393526767D-11-4.2732935376939D-11\n', '-3.6411343222479D-11-3.0859681498170D-11-2.6003874598665D-11-2.1775335402452D-11\n', '-1.8110621027080D-11-1.4951113535543D-11-1.2242723351044D-11-9.9356134315537D-12\n', '-7.9839425253001D-12-6.3456258285134D-12-4.9821117716183D-12-3.8581735057698D-12\n', '-2.9417140493666D-12-2.2035839504569D-12-1.6174106152272D-12-1.1594383077813D-12\n', '-8.0837812949791D-13-5.4526722359377D-13-3.5333651108289D-13-2.1788640714674D-13\n', '-1.2616992144399D-13-6.7282653249497D-14-3.2059203147786D-14-1.2975576824950D-14\n', '-4.0571818831921D-15-7.9204683774831D-16-4.8930043426147D-17-2.1031199044597D-21\n', '   13\n', ' 6.1917139974621D-11 6.6746300695594D-11 7.1951996562058D-11 7.7563587019617D-11\n', ' 8.3612725230690D-11 9.0133466529506D-11 9.7162621140192D-11 1.0473971661871D-10\n', ' 1.1290749546110D-10 1.2171191383280D-10 1.3120258925322D-10 1.4143295482578D-10\n', ' 1.5246057956778D-10 1.6434757324734D-10 1.7716086662657D-10 1.9097253281524D-10\n', ' 2.0586038224346D-10 2.2190817848480D-10 2.3920624068962D-10 2.5785197451677D-10\n', ' 2.7795027060803D-10 2.9961429546790D-10 3.2296595922759D-10 3.4813671749120D-10\n', ' 3.7526822126806D-10 4.0451316884230D-10 4.3603617952474D-10 4.7001469547550D-10\n', ' 5.0663993211407D-10 5.4611805616821D-10 5.8867127549807D-10 6.3453909281541D-10\n', ' 6.8397970401869D-10 7.3727138075599D-10 7.9471409802728D-10 8.5663116439097D-10\n', ' 9.2337112524601D-10 9.9530964266003D-10 1.0728516320900D-09 1.1564335831567D-09\n', ' 1.2465259594275D-09 1.3436358935521D-09 1.4483099943041D-09 1.5611374854813D-09\n', ' 1.6827534581773D-09 1.8138424811615D-09 1.9551424633357D-09 2.1074487689775D-09\n', ' 2.2716187404500D-09 2.4485764778337D-09 2.6393180839261D-09 2.8449172301961D-09\n', ' 3.0665312246419D-09 3.3054075167810D-09 3.5628907127586D-09 3.8404301522858D-09\n', ' 4.1395880493460D-09 4.4620482991358D-09 4.8096259455463D-09 5.1842773864133D-09\n', ' 5.5881114049485D-09 6.0234010049026D-09 6.4925962436931D-09 6.9983379767616D-09\n', ' 7.5434727467344D-09 7.5434711160922D-09 7.5688976503453D-09 7.5943812520274D-09\n', ' 7.6199219928337D-09 7.6455199324797D-09 7.6711751350280D-09 7.6968876650509D-09\n', ' 7.7226575914685D-09 7.7484849684444D-09 7.7743698718380D-09 7.7743698718380D-09\n', ' 3.7033997505135D-09-2.3777007597588D-10-4.0523991780200D-09-7.7436635233677D-09\n', '-1.1314657784715D-08-1.4768397638057D-08-1.8107821956130D-08-2.1335794933728D-08\n', '-2.4455108157465D-08-2.7468482616128D-08-3.0378570640080D-08-3.3187957796448D-08\n', '-3.5899164703666D-08-3.8514648825285D-08-4.1036806159864D-08-4.3467972947653D-08\n', '-4.5810427266216D-08-4.8066390616501D-08-5.0238029433654D-08-5.2327456583675D-08\n', '-5.4336732790077D-08-5.6267868032371D-08-5.8122822902238D-08-5.9903509913162D-08\n', '-6.1611794790692D-08-6.3249497685315D-08-6.4818394406461D-08-6.6320217568920D-08\n', '-6.7756657746973D-08-6.9129364555083D-08-7.0439947744402D-08-7.1689978218142D-08\n', '-7.2880989067325D-08-7.4014476532337D-08-7.5091900964868D-08-7.6114687769728D-08\n', '-7.7084228276189D-08-7.8001880650017D-08-7.8868970711042D-08-7.9686792784918D-08\n', '-8.0456610503473D-08-8.1179657575017D-08-8.1857138559556D-08-8.2490229601587D-08\n', '-8.3080079150413D-08-8.3627808660221D-08-8.3627808660221D-08-8.3669507660226D-08\n', '-8.3347614194353D-08-8.2794451944583D-08-8.2060691834632D-08-8.1177179501859D-08\n', '-8.0165655895940D-08-7.9042688276274D-08-7.7821530472001D-08-7.6513142266695D-08\n', '-7.5126805227842D-08-7.3670521831279D-08-7.2151288258145D-08-7.0575288839917D-08\n', '-6.8948039390774D-08-6.7274495880745D-08-6.5559138741786D-08-6.3806039620746D-08\n', '-6.2018915112532D-08-6.0201170692151D-08-5.8355937069215D-08-5.6486100657862D-08\n', '-5.4594329341963D-08-5.2683094491068D-08-5.2683094491068D-08-5.0456351801886D-08\n', '-4.8284255423490D-08-4.6166832163658D-08-4.4104021350274D-08-4.2095685725600D-08\n', '-4.0141620854241D-08-3.8241563298990D-08-3.6395197753203D-08-3.4602163297106D-08\n', '-3.2862058902778D-08-3.1174448303806D-08-2.9538864305420D-08-2.7954812618991D-08\n', '-2.6421775283930D-08-2.4939213719270D-08-2.3506571463136D-08-2.2123276625998D-08\n', '-2.0788744098697D-08-1.9502377537938D-08-1.8263571159588D-08-1.7071711354466D-08\n', '-1.5926178149299D-08-1.4826346527527D-08-1.3771587625578D-08-1.2761269814814D-08\n', '-1.1794759682312D-08-1.0871422919198D-08-9.9906251258916D-09-9.1517325418375D-09\n', '-8.3541127064176D-09-7.5971350572371D-09-6.8801714723321D-09-6.2025967602256D-09\n', '-5.5637891024252D-09-4.9631304533692D-09-4.4000069007880D-09-3.8738089896391D-09\n', '-3.3839320133088D-09-2.9297762744202D-09-2.5107473179751D-09-2.1262561387361D-09\n', '-1.7757193654181D-09-1.4585594233324D-09-1.1742046772815D-09-9.2208955616410D-10\n', '-7.0165466107535D-10-5.1234685789276D-10-3.5361935580777D-10-2.2493177283882D-10\n', '-1.2575018939543D-10-5.5547190836606D-11-1.3801899930004D-11-2.7214063951057D-21\n', '   16\n', ' 1.1511850307710D-10 1.2409294416639D-10 1.3376680409023D-10 1.4419462008022D-10\n', ' 1.5543509616041D-10 1.6755156146176D-10 1.8061228775920D-10 1.9469082645478D-10\n', ' 2.0986648373480D-10 2.2622470864190D-10 2.4385766024827D-10 2.6286459304185D-10\n', ' 2.8335259635058D-10 3.0543700538637D-10 3.2924221172293D-10 3.5490222460138D-10\n', ' 3.8256156710074D-10 4.1237596185093D-10 4.4451329104607D-10 4.7915450122542D-10\n', ' 5.1649464411473D-10 5.5674395377380D-10 6.0012904396077D-10 6.4689417545496D-10\n', ' 6.9730264217081D-10 7.5163826157282D-10 8.1020690004148D-10 8.7333831693240D-10\n', ' 9.4138794569569D-10 1.0147388583896D-09 1.0938040123132D-09 1.1790285077476D-09\n', ' 1.2708921127900D-09 1.3699119846792D-09 1.4766455542889D-09 1.5916936275843D-09\n', ' 1.7157038966195D-09 1.8493744224640D-09 1.9934576629781D-09 2.1487646955499D-09\n', ' 2.3161697593225D-09 2.4966151903932D-09 2.6911167458500D-09 2.9007692631264D-09\n', ' 3.1267528854054D-09 3.3703396732233D-09 3.6329007771646D-09 3.9159141250675D-09\n', ' 4.2209728081683D-09 4.5497939672015D-09 4.9042285239785D-09 5.2862715607637D-09\n', ' 5.6980735568347D-09 6.1419525056460D-09 6.6204069448431D-09 7.1361300229421D-09\n', ' 7.6920246681842D-09 8.2912199029300D-09 8.9370884499555D-09 9.6332657516053D-09\n', ' 1.0383670379213D-08 1.1192526120996D-08 1.2064385730696D-08 1.3004156547281D-08\n', ' 1.4017128137000D-08 1.4017126517111D-08 1.4064374194215D-08 1.4111727931058D-08\n', ' 1.4159187831425D-08 1.4206754026859D-08 1.4254426633634D-08 1.4302205767681D-08\n', ' 1.4350091543541D-08 1.4398084093103D-08 1.4446183522927D-08 1.4446183522927D-08\n', ' 1.0949713902548D-08 7.5647198491838D-09 4.2883038018455D-09 1.1176427333206D-09\n', '-1.9500139214794D-09-4.9173463139738D-09-7.7869661373749D-09-1.0561418549426D-08\n', '-1.3243183986716D-08-1.5834680005207D-08-1.8338262977835D-08-2.0756229802164D-08\n', '-2.3090819528482D-08-2.5344214946967D-08-2.7518544124754D-08-2.9615881889621D-08\n', '-3.1638251306347D-08-3.3587625047158D-08-3.5465926771320D-08-3.7275032452464D-08\n', '-3.9016771656666D-08-4.0692928779311D-08-4.2305244277859D-08-4.3855415822030D-08\n', '-4.5345099453894D-08-4.6775910681112D-08-4.8149425550804D-08-4.9467181708912D-08\n', '-5.0730679399854D-08-5.1941382459250D-08-5.3100719262336D-08-5.4210083658228D-08\n', '-5.5270835871388D-08-5.6284303381338D-08-5.7251781771643D-08-5.8174535557745D-08\n', '-5.9053798990368D-08-5.9890776843912D-08-6.0686645167257D-08-6.1442552030146D-08\n', '-6.2159618236039D-08-6.2838938021490D-08-6.3481579739253D-08-6.4088586512165D-08\n', '-6.4660976873147D-08-6.5199745399045D-08-6.5199745399045D-08-6.5312670483286D-08\n', '-6.5125471598064D-08-6.4747559439364D-08-6.4220795309827D-08-6.3570644939170D-08\n', '-6.2815045905169D-08-6.1967658568980D-08-6.1039404314964D-08-6.0039308395644D-08\n', '-5.8975009070005D-08-5.7853087565790D-08-5.6679293598021D-08-5.5458706105310D-08\n', '-5.4195851748636D-08-5.2894794735466D-08-5.1559206522734D-08-5.0192420995505D-08\n', '-4.8797478891517D-08-4.7377164112182D-08-4.5934033789400D-08-4.4470443467051D-08\n', '-4.2988568404171D-08-4.1490421776060D-08-4.1490421776060D-08-3.9744016284651D-08\n', '-3.8039746310992D-08-3.6377706122209D-08-3.4757915710851D-08-3.3180329860777D-08\n', '-3.1644845983196D-08-3.0151310924672D-08-2.8699526920162D-08-2.7289256813793D-08\n', '-2.5920228658698D-08-2.4592139789511D-08-2.3304660430588D-08-2.2057436913281D-08\n', '-2.0850094541624D-08-1.9682240161253D-08-1.8553464460504D-08-1.7463344037784D-08\n', '-1.6411443263937D-08-1.5397315960170D-08-1.4420506914834D-08-1.3480553251930D-08\n', '-1.2576985672460D-08-1.1709329577315D-08-1.0877106087026D-08-1.0079832965134D-08\n', '-9.3170254582853D-09-8.5881970580969D-09-7.8928601937040D-09-7.2305268607443D-09\n', '-6.6007091936589D-09-6.0029199847443D-09-5.4366731554656D-09-4.9014841855029D-09\n', '-4.3968705007156D-09-3.9223518252483D-09-3.4774505008221D-09-3.0616917751183D-09\n', '-2.6746040621478D-09-2.3157191775600D-09-1.9845725497754D-09-1.6807034100494D-09\n', '-1.4036549622989D-09-1.1529745348564D-09-9.2821371534691D-10-7.2892847004412D-10\n', '-5.5467924902855D-10-4.0503107818833D-10-2.7955363910939D-10-1.7782133778914D-10\n', '-9.9413363148403D-11-4.3913735970778D-11-1.0911349171896D-11-1.6669374294130D-21\n', '   21\n', ' 4.5631185522476D-03 4.8455663125134D-03 5.1159599910797D-03 5.3708921127769D-03\n', ' 5.6075886442427D-03 5.8238547692316D-03 6.0180472391801D-03 6.1890226608487D-03\n', ' 6.3361035756217D-03 6.4590299946303D-03 6.5579297536169D-03 6.6332789714355D-03\n', ' 6.6858796856178D-03 6.7168295063418D-03 6.7275066090587D-03 6.7195471980763D-03\n', ' 6.6948368351397D-03 6.6554940642348D-03 6.6038673504998D-03 6.5425234650269D-03\n', ' 6.4742497774486D-03 6.4020463631490D-03 6.3291338308381D-03 6.2589483642862D-03\n', ' 6.1951555645709D-03 6.1416477183754D-03 6.1025642746847D-03 6.0822905430747D-03\n', ' 6.0854854256272D-03 6.1170805202563D-03 6.1823156343253D-03 6.2867369589672D-03\n', ' 6.4362407842217D-03 6.6370691366662D-03 6.8958621532252D-03 7.2196495527998D-03\n', ' 7.6159125799893D-03 8.0925702658224D-03 8.6580531292458D-03 9.3212848419999D-03\n', ' 1.0091772432337D-02 1.0979587117436D-02 1.1995479825695D-02 1.3150869550287D-02\n', ' 1.4457998115296D-02 1.5929939375138D-02 1.7580811630724D-02 1.9425824006924D-02\n', ' 2.1481566093944D-02 2.3766106007940D-02 2.6299372447547D-02 2.9103310975334D-02\n', ' 3.2202364330448D-02 3.5623681803277D-02 3.9397694004121D-02 4.3558360744090D-02\n', ' 4.8143833149661D-02 5.3196723709902D-02 5.8764855582713D-02 6.4901544952848D-02\n', ' 7.1666452845345D-02 7.9125881145587D-02 8.7353755563504D-02 9.6431946180224D-02\n', ' 1.0645143552024D-01 1.0647093450002D-01 1.0694381436906D-01 1.0741826733298D-01\n', ' 1.0789429706704D-01 1.0837190724675D-01 1.0885110155444D-01 1.0933188367264D-01\n', ' 1.0981425729069D-01 1.1029822609804D-01 1.1078379379105D-01 1.1078379379105D-01\n', ' 1.0965100294939D-01 1.0878914149477D-01 1.0816939084100D-01 1.0776466581497D-01\n', ' 1.0754951753721D-01 1.0750004670808D-01 1.0759382005042D-01 1.0780979502135D-01\n', ' 1.0812824710545D-01 1.0853070368985D-01 1.0899988011661D-01 1.0951962098823D-01\n', ' 1.1007484338489D-01 1.1065148427304D-01 1.1123644965679D-01 1.1181756707562D-01\n', ' 1.1238353974335D-01 1.1292390335903D-01 1.1342898449836D-01 1.1388986114322D-01\n', ' 1.1429832475214D-01 1.1464684404718D-01 1.1492853032315D-01 1.1513710412046D-01\n', ' 1.1526686341682D-01 1.1531265290973D-01 1.1526983480043D-01 1.1513426045156D-01\n', ' 1.1490224353524D-01 1.1457053387443D-01 1.1413629275819D-01 1.1359706880891D-01\n', ' 1.1295077529649D-01 1.1219566789628D-01 1.1133032386084D-01 1.1035362153945D-01\n', ' 1.0926472128075D-01 1.0806304660911D-01 1.0674826673813D-01 1.0532027930235D-01\n', ' 1.0377919438017D-01 1.0212531868116D-01 1.0035914098156D-01 9.8481317675145D-02\n', ' 9.6492659535334D-02 9.4394118540297D-02 9.4394118540297D-02 9.2512625506801D-02\n', ' 9.0652994265453D-02 8.8795274211001D-02 8.6936176525404D-02 8.5076437502452D-02\n', ' 8.3217440084805D-02 8.1361716847979D-02 7.9511437514797D-02 7.7669440707933D-02\n', ' 7.5837985750183D-02 7.4019848683127D-02 7.2217173550290D-02 7.0432552543536D-02\n', ' 6.8667944717381D-02 6.6925716774659D-02 6.5207621732588D-02 6.3515790697594D-02\n', ' 6.1851770094075D-02 6.0217459462453D-02 5.8614207514774D-02 5.7043693029070D-02\n', ' 5.5507080359998D-02 5.4005841601790D-02 5.4005841601790D-02 5.2263824313830D-02\n', ' 5.0522367654505D-02 4.8784814510288D-02 4.7054279454268D-02 4.5333661673017D-02\n', ' 4.3625656507668D-02 4.1932767436693D-02 4.0257316754695D-02 3.8601456580307D-02\n', ' 3.6967178652344D-02 3.5356324374584D-02 3.3770593740070D-02 3.2211554441461D-02\n', ' 3.0680649955052D-02 2.9179207759022D-02 2.7708446619271D-02 2.6269483967497D-02\n', ' 2.4863342436704D-02 2.3490956455181D-02 2.2153178083525D-02 2.0850782882928D-02\n', ' 1.9584475106806D-02 1.8354892901183D-02 1.7162612904308D-02 1.6008154836202D-02\n', ' 1.4891985557848D-02 1.3814523105064D-02 1.2776140256870D-02 1.1777168066229D-02\n', ' 1.0817898984733D-02 9.8985899398210D-03 9.0194650600126D-03 8.1807183450144D-03\n', ' 7.3825160325766D-03 6.6249989050499D-03 5.9082843358347D-03 5.2324682720632D-03\n', ' 4.5976269960944D-03 4.0038188207973D-03 3.4510855982040D-03 2.9394541610729D-03\n', ' 2.4689376079033D-03 2.0395365212476D-03 1.6512400557334D-03 1.3040269608203D-03\n', ' 9.9786649580119D-04 7.3271928200883D-04 5.0853806644997D-04 3.2526842597670D-04\n', ' 1.8284939888544D-04 8.1214061348428D-05 2.0290044257939D-05 3.3281712055412D-15\n', '   25\n', ' 3.8565390690777D-03 4.0952509964394D-03 4.3237753654734D-03 4.5392323340571D-03\n', ' 4.7392774161014D-03 4.9220556533332D-03 5.0861782472521D-03 5.2306788542157D-03\n', ' 5.3549849172102D-03 5.4588767055582D-03 5.5424622602038D-03 5.6061439750483D-03\n', ' 5.6505996955531D-03 5.6767570716591D-03 5.6857808742494D-03 5.6790539483934D-03\n', ' 5.6581698846642D-03 5.6249191795722D-03 5.5812866484720D-03 5.5294416089315D-03\n', ' 5.4717398183156D-03 5.4107168031715D-03 5.3490944747267D-03 5.2897769384020D-03\n', ' 5.2358621926376D-03 5.1906398201868D-03 5.1576082940866D-03 5.1404738775103D-03\n', ' 5.1431740615134D-03 5.1698768072105D-03 5.2250105602600D-03 5.3132627078822D-03\n', ' 5.4396165249015D-03 5.6093474868673D-03 5.8280675340085D-03 6.1017178634445D-03\n', ' 6.4366212811911D-03 6.8394705903592D-03 7.3173908802848D-03 7.8779240305269D-03\n', ' 8.5291049469288D-03 9.2794453620494D-03 1.0138031469335D-02 1.1114514080077D-02\n', ' 1.2219239424679D-02 1.3463256927587D-02 1.4858498731734D-02 1.6417818894650D-02\n', ' 1.8155238180113D-02 2.0086026934507D-02 2.2227027983537D-02 2.4596788714175D-02\n', ' 2.7215967012950D-02 3.0107508219847D-02 3.3297130896519D-02 3.6813536323892D-02\n', ' 4.0688968091129D-02 4.4959440327214D-02 4.9665370980325D-02 5.4851820453957D-02\n', ' 6.0569211520691D-02 6.6873579504843D-02 7.3827403038884D-02 8.1499874974843D-02\n', ' 8.9967889585518D-02 8.9984369231237D-02 9.0384025691213D-02 9.0785011659116D-02\n', ' 9.1187330241102D-02 9.1590984543533D-02 9.1995977678565D-02 9.2402312758491D-02\n', ' 9.2809992901379D-02 9.3219021225379D-02 9.3629400854492D-02 9.3629400854492D-02\n', ' 9.2672017689632D-02 9.1943611658241D-02 9.1419826609075D-02 9.1077771392490D-02\n', ' 9.0895937779238D-02 9.0854127174252D-02 9.0933379997361D-02 9.1115912053514D-02\n', ' 9.1385053084379D-02 9.1725190882112D-02 9.2121717244278D-02 9.2560978367455D-02\n', ' 9.3030226857552D-02 9.3517577281578D-02 9.4011963192864D-02 9.4503096984443D-02\n', ' 9.4981431128921D-02 9.5438121677756D-02 9.5864993094842D-02 9.6254504898374D-02\n', ' 9.6599719604321D-02 9.6894272120925D-02 9.7132340429337D-02 9.7308617417405D-02\n', ' 9.7418283996416D-02 9.7456983140480D-02 9.7420795193823D-02 9.7306213917911D-02\n', ' 9.7110123796749D-02 9.6829777929112D-02 9.6462777166294D-02 9.6007049715950D-02\n', ' 9.5460831968948D-02 9.4822649701765D-02 9.4091300473128D-02 9.3265836315089D-02\n', ' 9.2345547592521D-02 9.1329947094416D-02 9.0218755255100D-02 8.9011885559865D-02\n', ' 8.7709431041754D-02 8.6311650917511D-02 8.4818958278386D-02 8.3231907878144D-02\n', ' 8.1551184945407D-02 7.9777594048276D-02 7.9777594048276D-02 7.8187442161728D-02\n', ' 7.6615766860262D-02 7.5045706805297D-02 7.3474482438473D-02 7.1902716041724D-02\n', ' 7.0331576415060D-02 6.8763203975420D-02 6.7199432473560D-02 6.5642660983431D-02\n', ' 6.4094798981413D-02 6.2558192650946D-02 6.1034654039491D-02 5.9526373949261D-02\n', ' 5.8035008083464D-02 5.6562556671095D-02 5.5110501282245D-02 5.3680643030607D-02\n', ' 5.2274288883357D-02 5.0893044245276D-02 4.9538048985998D-02 4.8210721932109D-02\n', ' 4.6912047142905D-02 4.5643268765105D-02 4.5643268765105D-02 4.4170995379302D-02\n', ' 4.2699195811547D-02 4.1230695316563D-02 3.9768126189104D-02 3.8313938689130D-02\n', ' 3.6870410795753D-02 3.5439658334443D-02 3.4023644002444D-02 3.2624186672055D-02\n', ' 3.1242969669806D-02 2.9881549265998D-02 2.8541362217064D-02 2.7223733465121D-02\n', ' 2.5929882970362D-02 2.4660932656633D-02 2.3417912569221D-02 2.2201767110226D-02\n', ' 2.1013360562385D-02 1.9853482661711D-02 1.8722853530924D-02 1.7622128638860D-02\n', ' 1.6551903188381D-02 1.5512716511243D-02 1.4505055955811D-02 1.3529360765665D-02\n', ' 1.2586025510391D-02 1.1675403494748D-02 1.0797809774534D-02 9.9535241405909D-03\n', ' 9.1427937596346D-03 8.3658357750065D-03 7.6228396098920D-03 6.9139692239858D-03\n', ' 6.2393651138520D-03 5.5991462622808D-03 4.9934118679365D-03 4.4222430209513D-03\n', ' 3.8857041916842D-03 3.3838446635318D-03 2.9166998079174D-03 2.4842923026759D-03\n', ' 2.0866332180555D-03 1.7237230464154D-03 1.3955526217530D-03 1.1021039840857D-03\n', ' 8.4335115278083D-04 6.1926084679667D-04 4.2979313006454D-04 2.7490200663692D-04\n', ' 1.5453595447388D-04 6.8638412617807D-05 1.7148218015763D-05 2.6046745821324D-15\n', '    1\n']
        txt = open(out_pot).readlines()
        assert txt==reftxt
        
    def test_neworder_potential_with_replace(self):
        path = '../tests/files/mod_pot/test1/'
        pot1 = path+'out_potential'
        pot2 = path+'pot'
        out_pot = path+'pot_new'
        neworder = [0,1,2]
        # test 2: neworder_potential with replace from second potential
        replace_newpos = [[0, 0], [2, 0]]
        modify_potential().neworder_potential(pot1, out_pot, neworder, potfile_2=pot2, 
                                              replace_from_pot2=replace_newpos)
        # now compare to reference:
        reftxt = ['Au79 POTENTIAL                      exc: Vosko,Wilk,Nusair       #serial: kkrimp_v1.2-26-g84cbc08_serial_20180502163421                                             \n', '   2.38779078000000        4.82381975000676        2.38779078000000     \n', '  29.00000\n', '   3.41096   0.6285993399   0.7168465117\n', '484\n', ' 0.25000000D-01 0.39783834D-03\n', ' 5 1\n', '    0  -6.48338926687D+02\n', '    0  -7.71318775307D+01\n', '    0  -7.57179639043D+00\n', '    1  -6.65450234120D+01\n', '    1  -4.47233316155D+00\n', '  484  199   25    1\n', ' 2.1759441523018D+02 2.1819475080749D+02 2.1881026236697D+02 2.1917688185765D+02\n', ' 2.1944135872046D+02 2.1965147406096D+02 2.1982711562857D+02 2.1997904825423D+02\n', ' 2.2011373491322D+02 2.2023534840148D+02 2.2034673451484D+02 2.2044992337168D+02\n', ' 2.2054641278738D+02 2.2063734116153D+02 2.2072359294082D+02 2.2080587063205D+02\n', ' 2.2088474038225D+02 2.2096066680867D+02 2.2103403469802D+02 2.2110516797233D+02\n', ' 2.2117434060218D+02 2.2124178803200D+02 2.2130771274044D+02 2.2137229176865D+02\n', ' 2.2143567942083D+02 2.2149801263952D+02 2.2155941208437D+02 2.2161998625148D+02\n', ' 2.2167983158616D+02 2.2173903583539D+02 2.2179767756105D+02 2.2185582900557D+02\n', ' 2.2191355521989D+02 2.2197091660943D+02 2.2202796780683D+02 2.2208476000181D+02\n', ' 2.2214133963982D+02 2.2219775058279D+02 2.2225402975912D+02 2.2231022136274D+02\n', ' 2.2236635669203D+02 2.2242246888432D+02 2.2247858808059D+02 2.2253474336281D+02\n', ' 2.2259096113770D+02 2.2264726703007D+02 2.2270368423197D+02 2.2276023536191D+02\n', ' 2.2281694078753D+02 2.2287382045783D+02 2.2293089220513D+02 2.2298817355560D+02\n', ' 2.2304568001469D+02 2.2310342685981D+02 2.2316142741226D+02 2.2321969481495D+02\n', ' 2.2327824029306D+02 2.2333707491898D+02 2.2339620786334D+02 2.2345564814863D+02\n', ' 2.2351540289195D+02 2.2357547904851D+02 2.2363588164683D+02 2.2369661552312D+02\n', ' 2.2375768354952D+02 2.2381908836002D+02 2.2388083057214D+02 2.2394291050486D+02\n', ' 2.2400532639407D+02 2.2406807610284D+02 2.2413115533076D+02 2.2419455931677D+02\n', ' 2.2425828104263D+02 2.2432231292836D+02 2.2438664502980D+02 2.2445126672689D+02\n', ' 2.2451616491525D+02 2.2458132568737D+02 2.2464673251819D+02 2.2471236793925D+02\n', ' 2.2477821171821D+02 2.2484424252598D+02 2.2491043611020D+02 2.2497676695536D+02\n', ' 2.2504320645021D+02 2.2510972454100D+02 2.2517628789281D+02 2.2524286153598D+02\n', ' 2.2530940702151D+02 2.2537588406077D+02 2.2544224867516D+02 2.2550845482934D+02\n', ' 2.2557445257532D+02 2.2564018967957D+02 2.2570560976184D+02 2.2577065391661D+02\n', ' 2.2583525884706D+02 2.2589935848143D+02 2.2596288210274D+02 2.2602575596069D+02\n', ' 2.2608790139794D+02 2.2614923645843D+02 2.2620967401113D+02 2.2626912335583D+02\n', ' 2.2632748834555D+02 2.2638466899108D+02 2.2644055958332D+02 2.2649505029826D+02\n', ' 2.2654802532084D+02 2.2659936445204D+02 2.2664894123635D+02 2.2669662457302D+02\n', ' 2.2674227684927D+02 2.2678575555820D+02 2.2682691144031D+02 2.2686559011074D+02\n', ' 2.2690163021207D+02 2.2693486505395D+02 2.2696512078041D+02 2.2699221802546D+02\n', ' 2.2701597009844D+02 2.2703618465942D+02 2.2705266192667D+02 2.2706519637601D+02\n', ' 2.2707357497470D+02 2.2707757890935D+02 2.2707698185094D+02 2.2707155171610D+02\n', ' 2.2706104896829D+02 2.2704522841746D+02 2.2702383756273D+02 2.2699661843578D+02\n', ' 2.2696330599018D+02 2.2692362999416D+02 2.2687731347199D+02 2.2682407465138D+02\n', ' 2.2676362546233D+02 2.2669567354433D+02 2.2661992080788D+02 2.2653606550624D+02\n', ' 2.2644380086416D+02 2.2634281721860D+02 2.2623280071839D+02 2.2611343553747D+02\n', ' 2.2598440264831D+02 2.2584538210983D+02 2.2569605191624D+02 2.2553609036033D+02\n', ' 2.2536517495753D+02 2.2518298488347D+02 2.2498919997095D+02 2.2478350321820D+02\n', ' 2.2456557985406D+02 2.2433511991062D+02 2.2409181734871D+02 2.2383537268551D+02\n', ' 2.2356549216892D+02 2.2328189044697D+02 2.2298428977590D+02 2.2267242271386D+02\n', ' 2.2234603134313D+02 2.2200486996628D+02 2.2164870431818D+02 2.2127731423789D+02\n', ' 2.2089049284115D+02 2.2048804913638D+02 2.2006980712346D+02 2.1963560831698D+02\n', ' 2.1918531073229D+02 2.1871879127478D+02 2.1823594456974D+02 2.1773668517224D+02\n', ' 2.1722094619394D+02 2.1668868128549D+02 2.1613986301135D+02 2.1557448455546D+02\n', ' 2.1499255779521D+02 2.1439411468270D+02 2.1377920497221D+02 2.1314789723332D+02\n', ' 2.1250027619725D+02 2.1183644336767D+02 2.1115651395458D+02 2.1046061707360D+02\n', ' 2.0974889226369D+02 2.0902148927988D+02 2.0827856422167D+02 2.0752027896405D+02\n', ' 2.0674679696385D+02 2.0595828242230D+02 2.0515489589207D+02 2.0433679332716D+02\n', ' 2.0350412168286D+02 2.0265701808451D+02 2.0179560569314D+02 2.0091999330777D+02\n', ' 2.0003027185237D+02 1.9912651480393D+02 1.9820877572179D+02 1.9727708993976D+02\n', ' 1.9633147357549D+02 1.9537192689963D+02 1.9439843518391D+02 1.9341097401488D+02\n', ' 1.9240951211535D+02 1.9139401856057D+02 1.9036446731065D+02 1.8932084581000D+02\n', ' 1.8826316043091D+02 1.8719144537215D+02 1.8610576766875D+02 1.8500623483927D+02\n', ' 1.8389299779457D+02 1.8276625556894D+02 1.8162625460712D+02 1.8047328935068D+02\n', ' 1.7930769710463D+02 1.7812985421877D+02 1.7694016687230D+02 1.7573906378954D+02\n', ' 1.7452698442329D+02 1.7330437011236D+02 1.7207165184218D+02 1.7082924211730D+02\n', ' 1.6957752449241D+02 1.6831684811908D+02 1.6704752065437D+02 1.6576980666216D+02\n', ' 1.6448392462256D+02 1.6319004946297D+02 1.6188831353540D+02 1.6057881279725D+02\n', ' 1.5926161100051D+02 1.5793674856361D+02 1.5660424888072D+02 1.5526412871965D+02\n', ' 1.5391640546331D+02 1.5256110786239D+02 1.5119828308337D+02 1.4982800675653D+02\n', ' 1.4845038885273D+02 1.4706558213293D+02 1.4567378605828D+02 1.4427525294929D+02\n', ' 1.4287028932369D+02 1.4145925926420D+02 1.4004258279085D+02 1.3862073614347D+02\n', ' 1.3719424700385D+02 1.3576369162357D+02 1.3432968693227D+02 1.3289288468655D+02\n', ' 1.3145396079032D+02 1.3001360691002D+02 1.2857251763317D+02 1.2713138037871D+02\n', ' 1.2569086142608D+02 1.2425159540122D+02 1.2281417173331D+02 1.2137912557852D+02\n', ' 1.1994692688890D+02 1.1851797527414D+02 1.1709259444901D+02 1.1567103394857D+02\n', ' 1.1425347180428D+02 1.1284002556180D+02 1.1143076476784D+02 1.1002573143287D+02\n', ' 1.0862496043142D+02 1.0722850498972D+02 1.0583645789064D+02 1.0444897255032D+02\n', ' 1.0306627428575D+02 1.0168866657234D+02 1.0031652427665D+02 9.8950281127418D+01\n', ' 9.7590406184439D+01 9.6237379029633D+01 9.4891660040693D+01 9.3553665915330D+01\n', ' 9.2223746126658D+01 9.0902168979057D+01 8.9589111068815D+01 8.8284656983767D+01\n', ' 8.6988801550291D+01 8.5701460415778D+01 8.4422480887691D+01 8.3151658323652D+01\n', ' 8.1888750473850D+01 8.0633495385457D+01 7.9385625282129D+01 7.8144882784920D+01\n', ' 7.6911032077137D+01 7.5683871738704D+01 7.4463242102894D+01 7.3249034060800D+01\n', ' 7.2041192378577D+01 7.0839720566258D+01 6.9644680414675D+01 6.8456193396922D+01\n', ' 6.7274437050446D+01 6.6099643600619D+01 6.4932093946760D+01 6.3772114300483D+01\n', ' 6.2620068580670D+01 6.1476353863538D+01 6.0341391959896D+01 5.9215624411872D+01\n', ' 5.8099503938492D+01 5.6993489606260D+01 5.5898038705416D+01 5.4813602586280D+01\n', ' 5.3740619385786D+01 5.2679510875173D+01 5.1630676309954D+01 5.0594490491132D+01\n', ' 4.9571298874009D+01 4.8561416915304D+01 4.7565126455961D+01 4.6582676317038D+01\n', ' 4.5614279873548D+01 4.4660116775388D+01 4.3720331553926D+01 4.2795036279569D+01\n', ' 4.1884309987830D+01 4.0988202039162D+01 4.0106732113322D+01 3.9239894006939D+01\n', ' 3.8387655922838D+01 3.7549964427597D+01 3.6726744759978D+01 3.5917904681538D+01\n', ' 3.5123334555116D+01 3.4342910867236D+01 3.3576495893591D+01 3.2823940758272D+01\n', ' 3.2085084606975D+01 3.1359757184135D+01 3.0647777554415D+01 2.9948956292952D+01\n', ' 2.9263093893599D+01 2.8589982740288D+01 2.7929405383598D+01 2.7281136468980D+01\n', ' 2.6644941036934D+01 2.6020576644497D+01 2.5407791424022D+01 2.4806326835651D+01\n', ' 2.4215915611159D+01 2.4217296258767D+01 2.4191046731904D+01 2.4164848486427D+01\n', ' 2.4138701355590D+01 2.4112605173538D+01 2.4086559774925D+01 2.4060564995281D+01\n', ' 2.4034620670642D+01 2.4008726637915D+01 2.3982882734504D+01 2.3982882734504D+01\n', ' 2.3906675613860D+01 2.3830803882889D+01 2.3755270199388D+01 2.3680076998294D+01\n', ' 2.3605226503155D+01 2.3530720735561D+01 2.3456561525246D+01 2.3382750518648D+01\n', ' 2.3309289187637D+01 2.3236178837123D+01 2.3163420613045D+01 2.3091015508973D+01\n', ' 2.3018964373299D+01 2.2947267915117D+01 2.2875926710692D+01 2.2804941208702D+01\n', ' 2.2734311736085D+01 2.2664038502718D+01 2.2594121606716D+01 2.2524561038594D+01\n', ' 2.2455356686233D+01 2.2386508338428D+01 2.2318015689414D+01 2.2249878342262D+01\n', ' 2.2182095812848D+01 2.2114667532977D+01 2.2047592854015D+01 2.1980871049723D+01\n', ' 2.1914501319587D+01 2.1848482791409D+01 2.1782814524361D+01 2.1717495511323D+01\n', ' 2.1652524681838D+01 2.1587900904070D+01 2.1523622987538D+01 2.1459689685094D+01\n', ' 2.1396099695303D+01 2.1332851664305D+01 2.1269944188015D+01 2.1207375813848D+01\n', ' 2.1145145042752D+01 2.1083250330811D+01 2.1021690091131D+01 2.0960462695330D+01\n', ' 2.0899566475240D+01 2.0838999724455D+01 2.0838999724455D+01 2.0784369133277D+01\n', ' 2.0729953910598D+01 2.0675774655486D+01 2.0621838286920D+01 2.0568148581249D+01\n', ' 2.0514707564816D+01 2.0461516538311D+01 2.0408576050509D+01 2.0355886396845D+01\n', ' 2.0303447422545D+01 2.0251258880712D+01 2.0199320209886D+01 2.0147630826017D+01\n', ' 2.0096189906317D+01 2.0044996639297D+01 1.9994050023121D+01 1.9943349084747D+01\n', ' 1.9892892694780D+01 1.9842679761646D+01 1.9792709062837D+01 1.9742979418059D+01\n', ' 1.9693489535798D+01 1.9644238168818D+01 1.9644238168818D+01 1.9586732831135D+01\n', ' 1.9529564617155D+01 1.9472730933061D+01 1.9416229183758D+01 1.9360056775947D+01\n', ' 1.9304211120650D+01 1.9248689635626D+01 1.9193489747205D+01 1.9138608892343D+01\n', ' 1.9084044520022D+01 1.9029794092749D+01 1.8975855087751D+01 1.8922224998121D+01\n', ' 1.8868901333744D+01 1.8815881622200D+01 1.8763163409466D+01 1.8710744260619D+01\n', ' 1.8658621760360D+01 1.8606793513556D+01 1.8555257145615D+01 1.8504010302886D+01\n', ' 1.8453050652931D+01 1.8402375884796D+01 1.8351983709191D+01 1.8301871858667D+01\n', ' 1.8252038087713D+01 1.8202480172859D+01 1.8153195912700D+01 1.8104183127933D+01\n', ' 1.8055439661332D+01 1.8006963377757D+01 1.7958752163964D+01 1.7910803928716D+01\n', ' 1.7863116602558D+01 1.7815688137736D+01 1.7768516508073D+01 1.7721599708819D+01\n', ' 1.7674935756496D+01 1.7628522688739D+01 1.7582358564107D+01 1.7536441461910D+01\n', ' 1.7490769482005D+01 1.7445340744607D+01 1.7400153390072D+01 1.7355205578690D+01\n', ' 1.7310495490469D+01 1.7266021324917D+01 1.7221781300811D+01 1.7177773655981D+01\n', ' 1.7133996647068D+01 1.7090448549313D+01 1.7047127656308D+01 1.7004032279769D+01\n', '   21\n', ' 4.5631185736868D-03 4.8455663362266D-03 5.1159600173099D-03 5.3708921417927D-03\n', ' 5.6075886763412D-03 5.8238548047410D-03 6.0180472784632D-03 6.1890227043064D-03\n', ' 6.3361036236968D-03 6.4590300478123D-03 6.5579298124462D-03 6.6332790365093D-03\n', ' 6.6858797575958D-03 6.7168295859529D-03 6.7275066971080D-03 6.7195472954536D-03\n', ' 6.6948369428276D-03 6.6554941833194D-03 6.6038674821808D-03 6.5425236106301D-03\n', ' 6.4742499384389D-03 6.4020465411450D-03 6.3291340276284D-03 6.2589485818475D-03\n', ' 6.1951558050871D-03 6.1416479842603D-03 6.1025645686054D-03 6.0822908679790D-03\n', ' 6.0854857847725D-03 6.1170809172425D-03 6.1823160731308D-03 6.2867374439888D-03\n', ' 6.4362413203186D-03 6.6370697292084D-03 6.8958628081478D-03 7.2196502766620D-03\n', ' 7.6159133800401D-03 8.0925711500735D-03 8.6580541065516D-03 9.3212859221462D-03\n', ' 1.0091773626139D-02 1.0979588436847D-02 1.1995481283925D-02 1.3150871161936D-02\n', ' 1.4457999896501D-02 1.5929941343732D-02 1.7580813806416D-02 1.9425826411500D-02\n', ' 2.1481568751477D-02 2.3766108945038D-02 2.6299375693618D-02 2.9103314562877D-02\n', ' 3.2202368295384D-02 3.5623686185302D-02 3.9397698847110D-02 4.3558366096532D-02\n', ' 4.8143839065144D-02 5.3196730247653D-02 5.8764862808189D-02 6.4901552938390D-02\n', ' 7.1666461670902D-02 7.9125890899519D-02 8.7353766343464D-02 9.6431958094136D-02\n', ' 1.0645144868738D-01 1.0647094766716D-01 1.0694382759541D-01 1.0741828061875D-01\n', ' 1.0789431041242D-01 1.0837192065193D-01 1.0885111501964D-01 1.0933189719805D-01\n', ' 1.0981427087652D-01 1.1029823974448D-01 1.1078380749831D-01 1.1078380749831D-01\n', ' 1.0965100412745D-01 1.0878913065205D-01 1.0816936846958D-01 1.0776463239111D-01\n', ' 1.0754947352182D-01 1.0749999254724D-01 1.0759375617578D-01 1.0780972185061D-01\n', ' 1.0812816504281D-01 1.0853061312639D-01 1.0899978143072D-01 1.0951951454597D-01\n', ' 1.1007472954040D-01 1.1065136336890D-01 1.1123632202437D-01 1.1181743303543D-01\n', ' 1.1238339960534D-01 1.1292375742295D-01 1.1342883305406D-01 1.1388970447095D-01\n', ' 1.1429816312283D-01 1.1464667772275D-01 1.1492835955676D-01 1.1513692915678D-01\n', ' 1.1526668449229D-01 1.1531247025282D-01 1.1526964863185D-01 1.1513407098453D-01\n', ' 1.1490205097570D-01 1.1457033842125D-01 1.1413609460339D-01 1.1359686813787D-01\n', ' 1.1295057228817D-01 1.1219546272335D-01 1.1133011668993D-01 1.1035341253131D-01\n', ' 1.0926451059042D-01 1.0806283438610D-01 1.0674805312657D-01 1.0532006444117D-01\n', ' 1.0377897840325D-01 1.0212510171748D-01 1.0035892315533D-01 9.8481099105981D-02\n', ' 9.6492440338358D-02 9.4393898826295D-02 9.4393898826295D-02 9.2512406479178D-02\n', ' 9.0652776839737D-02 8.8795058961372D-02 8.6935963893825D-02 8.5076227849844D-02\n', ' 8.3217233714723D-02 8.1361514020148D-02 7.9511238453835D-02 7.7669245609439D-02\n', ' 7.5837794785204D-02 7.4019662001588D-02 7.2216991283701D-02 7.0432374807191D-02\n', ' 6.8667771612168D-02 6.6925548388591D-02 6.5207458142096D-02 6.3515631968649D-02\n', ' 6.1851616283162D-02 6.0217310617425D-02 5.8614063675610D-02 5.7043554228543D-02\n', ' 5.5506946624279D-02 5.4005712950990D-02 5.4005712950990D-02 5.2263701553498D-02\n', ' 5.0522250609553D-02 4.8784703007433D-02 4.7054173322214D-02 4.5333560742609D-02\n', ' 4.3625560612020D-02 4.1932676411297D-02 4.0257230437509D-02 3.8601374811831D-02\n', ' 3.6967101275677D-02 3.5356251235472D-02 3.3770524686946D-02 3.2211489325467D-02\n', ' 3.0680588630065D-02 2.9179150081660D-02 2.7708392448902D-02 2.6269433166237D-02\n', ' 2.4863294869415D-02 2.3490911989458D-02 2.2153136589684D-02 2.0850744233991D-02\n', ' 1.9584439178478D-02 1.8354859571834D-02 1.7162582054943D-02 1.6008126350437D-02\n', ' 1.4891959321885D-02 1.3814499007653D-02 1.2776118189285D-02 1.1777147922230D-02\n', ' 1.0817880660538D-02 9.8985733340674D-03 9.0194500737241D-03 8.1807048815652D-03\n', ' 7.3825039976557D-03 6.6249882066245D-03 5.9082748841140D-03 5.2324599794618D-03\n', ' 4.5976197771954D-03 4.0038125923158D-03 3.4510802789501D-03 2.9394496719152D-03\n', ' 2.4689338717326D-03 2.0395334629405D-03 1.6512376021161D-03 1.3040250406330D-03\n', ' 9.9786503966239D-04 7.3271822238026D-04 5.0853733760166D-04 3.2526796395246D-04\n', ' 1.8284914146876D-04 8.1213948028722D-05 2.0290016197226D-05 3.3281651140516D-15\n', '   25\n', ' 3.8565390773813D-03 4.0952510056308D-03 4.3237753756491D-03 4.5392323453237D-03\n', ' 4.7392774285767D-03 4.9220556671475D-03 5.0861782625495D-03 5.2306788711552D-03\n', ' 5.3549849359675D-03 5.4588767263274D-03 5.5424622831991D-03 5.6061440005062D-03\n', ' 5.6505997237349D-03 5.6767571028534D-03 5.6857809087747D-03 5.6790539866015D-03\n', ' 5.6581699269439D-03 5.6249192263527D-03 5.5812867002273D-03 5.5294416661854D-03\n', ' 5.4717398816467D-03 5.4107168732190D-03 5.3490945521967D-03 5.2897770240748D-03\n', ' 5.2358622873753D-03 5.1906399249420D-03 5.1576084099117D-03 5.1404740055684D-03\n', ' 5.1431742030898D-03 5.1698769637253D-03 5.2250107332829D-03 5.3132628991476D-03\n', ' 5.4396167363262D-03 5.6093477205697D-03 5.8280677923297D-03 6.1017181489718D-03\n', ' 6.4366215967839D-03 6.8394709391776D-03 7.3173912658215D-03 7.8779244566419D-03\n', ' 8.5291054178881D-03 9.2794458825681D-03 1.0138032044624D-02 1.1114514715896D-02\n', ' 1.2219240127392D-02 1.3463257704230D-02 1.4858499590081D-02 1.6417819843296D-02\n', ' 1.8155239228553D-02 2.0086028093240D-02 2.2227029264163D-02 2.4596790129516D-02\n', ' 2.7215968577176D-02 3.0107509948619D-02 3.3297132807147D-02 3.6813538435504D-02\n', ' 4.0688970424869D-02 4.4959442906447D-02 4.9665373830875D-02 5.4851823604363D-02\n', ' 6.0569215002497D-02 6.6873583352908D-02 7.3827407291734D-02 8.1499879675057D-02\n', ' 8.9967894780152D-02 8.9984374425869D-02 9.0384030909205D-02 9.0785016900547D-02\n', ' 9.1187335506051D-02 9.1590989832078D-02 9.1995982990786D-02 9.2402318094468D-02\n', ' 9.2809998261191D-02 9.3219026609106D-02 9.3629406262214D-02 9.3629406262214D-02\n', ' 9.2672012673557D-02 9.1943596638802D-02 9.1419801993342D-02 9.1077737574588D-02\n', ' 9.0895895140750D-02 9.0854076084609D-02 9.0933320814217D-02 9.1115845123114D-02\n', ' 9.1384978741907D-02 9.1725109452037D-02 9.2121629040681D-02 9.2560883694350D-02\n', ' 9.3030126009198D-02 9.3517470542773D-02 9.4011850839240D-02 9.4502979282743D-02\n', ' 9.4981308337275D-02 9.5437994045939D-02 9.5864860864534D-02 9.6254368303401D-02\n', ' 9.6599578870901D-02 9.6894127467891D-02 9.7132192068369D-02 9.7308465553241D-02\n', ' 9.7418128827068D-02 9.7456824857432D-02 9.7420633982233D-02 9.7306049956797D-02\n', ' 9.7109957259180D-02 9.6829608982385D-02 9.6462605972107D-02 9.6006876430570D-02\n', ' 9.5460656743379D-02 9.4822472681901D-02 9.4091121799908D-02 9.3265656124648D-02\n', ' 9.2345366016333D-02 9.1329764259431D-02 9.0218571283884D-02 8.9011700570728D-02\n', ' 8.7709245148881D-02 8.6311464231079D-02 8.4818770904692D-02 8.3231719919715D-02\n', ' 8.1550996501115D-02 7.9777405213448D-02 7.9777405213448D-02 7.8187253951061D-02\n', ' 7.6615580049071D-02 7.5045521880074D-02 7.3474299773795D-02 7.1902535943550D-02\n', ' 7.0331399140765D-02 6.8763029745245D-02 6.7199261478002D-02 6.5642493388385D-02\n', ' 6.4094634931958D-02 6.2558032274248D-02 6.1034497447091D-02 5.9526221238939D-02\n', ' 5.8034859340771D-02 5.6562411970642D-02 5.5110360688809D-02 5.3680506600073D-02\n', ' 5.2274156663543D-02 5.0892916276658D-02 4.9537925302349D-02 4.8210602561068D-02\n', ' 4.6911932106489D-02 4.5643158080163D-02 4.5643158080163D-02 4.4170889735777D-02\n', ' 4.2699095061136D-02 4.1230599312422D-02 3.9768034786007D-02 3.8313851743603D-02\n', ' 3.6870328166183D-02 3.5439579881171D-02 3.4023569587845D-02 3.2624116160602D-02\n', ' 3.1242902928121D-02 2.9881486162896D-02 2.8541302623585D-02 2.7223677254557D-02\n', ' 2.5929830018273D-02 2.4660882840859D-02 2.3417865769890D-02 2.2201723209754D-02\n', ' 2.1013319445476D-02 1.9853444215347D-02 1.8722817644358D-02 1.7622095203602D-02\n', ' 1.6551872098183D-02 1.5512687662081D-02 1.4505029245866D-02 1.3529336095302D-02\n', ' 1.2586002782135D-02 1.1675382613260D-02 1.0797790646587D-02 9.9535066750428D-03\n', ' 9.1427778673996D-03 8.3658213690287D-03 7.6228266051164D-03 6.9139575373293D-03\n', ' 6.2393546641741D-03 5.5991369703535D-03 4.9934036564146D-03 4.4222358143422D-03\n', ' 3.8856979163174D-03 3.3838392475291D-03 2.9166951811619D-03 2.4842883967824D-03\n', ' 2.0866299663400D-03 1.7237203838651D-03 1.3955504849965D-03 1.1021023113631D-03\n', ' 8.4334988391467D-04 6.1925992316241D-04 4.2979249456172D-04 2.7490160366047D-04\n', ' 1.5453572988574D-04 6.8638313718914D-05 1.7148193518295D-05 2.6046694427370D-15\n', '    1\n', 'Cu29 POTENTIAL                      exc: Vosko,Wilk,Nusair       #serial: kkrimp_v1.2-26-g84cbc08_serial_20180502163421                                             \n', '   2.38779078000000        4.82381975000676        2.38779078000000     \n', '  29.00000\n', '   3.41096   0.6285993399   0.7168465117\n', '484\n', ' 0.25000000D-01 0.39783834D-03\n', ' 5 1\n', '    0  -6.48338926687D+02\n', '    0  -7.71318775307D+01\n', '    0  -7.57179639043D+00\n', '    1  -6.65450234120D+01\n', '    1  -4.47233316155D+00\n', '  484  199   25    1\n', ' 2.1759441563850D+02 2.1819475121581D+02 2.1881026277529D+02 2.1917688226597D+02\n', ' 2.1944135912878D+02 2.1965147446928D+02 2.1982711603689D+02 2.1997904866255D+02\n', ' 2.2011373532154D+02 2.2023534880980D+02 2.2034673492315D+02 2.2044992377999D+02\n', ' 2.2054641319570D+02 2.2063734156985D+02 2.2072359334914D+02 2.2080587104037D+02\n', ' 2.2088474079057D+02 2.2096066721699D+02 2.2103403510634D+02 2.2110516838065D+02\n', ' 2.2117434101050D+02 2.2124178844032D+02 2.2130771314876D+02 2.2137229217697D+02\n', ' 2.2143567982915D+02 2.2149801304784D+02 2.2155941249269D+02 2.2161998665980D+02\n', ' 2.2167983199448D+02 2.2173903624371D+02 2.2179767796937D+02 2.2185582941389D+02\n', ' 2.2191355562821D+02 2.2197091701775D+02 2.2202796821515D+02 2.2208476041013D+02\n', ' 2.2214134004814D+02 2.2219775099111D+02 2.2225403016744D+02 2.2231022177106D+02\n', ' 2.2236635710035D+02 2.2242246929264D+02 2.2247858848891D+02 2.2253474377113D+02\n', ' 2.2259096154602D+02 2.2264726743839D+02 2.2270368464028D+02 2.2276023577023D+02\n', ' 2.2281694119585D+02 2.2287382086615D+02 2.2293089261344D+02 2.2298817396392D+02\n', ' 2.2304568042301D+02 2.2310342726813D+02 2.2316142782058D+02 2.2321969522327D+02\n', ' 2.2327824070138D+02 2.2333707532730D+02 2.2339620827166D+02 2.2345564855695D+02\n', ' 2.2351540330027D+02 2.2357547945683D+02 2.2363588205515D+02 2.2369661593144D+02\n', ' 2.2375768395784D+02 2.2381908876834D+02 2.2388083098046D+02 2.2394291091318D+02\n', ' 2.2400532680239D+02 2.2406807651116D+02 2.2413115573908D+02 2.2419455972509D+02\n', ' 2.2425828145095D+02 2.2432231333668D+02 2.2438664543812D+02 2.2445126713521D+02\n', ' 2.2451616532357D+02 2.2458132609569D+02 2.2464673292651D+02 2.2471236834757D+02\n', ' 2.2477821212653D+02 2.2484424293430D+02 2.2491043651852D+02 2.2497676736368D+02\n', ' 2.2504320685853D+02 2.2510972494932D+02 2.2517628830113D+02 2.2524286194430D+02\n', ' 2.2530940742983D+02 2.2537588446909D+02 2.2544224908348D+02 2.2550845523766D+02\n', ' 2.2557445298364D+02 2.2564019008789D+02 2.2570561017016D+02 2.2577065432493D+02\n', ' 2.2583525925538D+02 2.2589935888975D+02 2.2596288251106D+02 2.2602575636901D+02\n', ' 2.2608790180626D+02 2.2614923686675D+02 2.2620967441944D+02 2.2626912376414D+02\n', ' 2.2632748875386D+02 2.2638466939939D+02 2.2644055999164D+02 2.2649505070658D+02\n', ' 2.2654802572916D+02 2.2659936486036D+02 2.2664894164467D+02 2.2669662498134D+02\n', ' 2.2674227725759D+02 2.2678575596652D+02 2.2682691184863D+02 2.2686559051906D+02\n', ' 2.2690163062039D+02 2.2693486546227D+02 2.2696512118873D+02 2.2699221843378D+02\n', ' 2.2701597050675D+02 2.2703618506774D+02 2.2705266233499D+02 2.2706519678433D+02\n', ' 2.2707357538302D+02 2.2707757931767D+02 2.2707698225926D+02 2.2707155212442D+02\n', ' 2.2706104937660D+02 2.2704522882578D+02 2.2702383797105D+02 2.2699661884410D+02\n', ' 2.2696330639850D+02 2.2692363040248D+02 2.2687731388031D+02 2.2682407505970D+02\n', ' 2.2676362587065D+02 2.2669567395265D+02 2.2661992121619D+02 2.2653606591456D+02\n', ' 2.2644380127248D+02 2.2634281762692D+02 2.2623280112671D+02 2.2611343594579D+02\n', ' 2.2598440305663D+02 2.2584538251815D+02 2.2569605232456D+02 2.2553609076865D+02\n', ' 2.2536517536585D+02 2.2518298529179D+02 2.2498920037927D+02 2.2478350362652D+02\n', ' 2.2456558026238D+02 2.2433512031894D+02 2.2409181775703D+02 2.2383537309383D+02\n', ' 2.2356549257724D+02 2.2328189085529D+02 2.2298429018422D+02 2.2267242312218D+02\n', ' 2.2234603175144D+02 2.2200487037460D+02 2.2164870472650D+02 2.2127731464621D+02\n', ' 2.2089049324947D+02 2.2048804954470D+02 2.2006980753177D+02 2.1963560872530D+02\n', ' 2.1918531114061D+02 2.1871879168310D+02 2.1823594497806D+02 2.1773668558056D+02\n', ' 2.1722094660225D+02 2.1668868169380D+02 2.1613986341967D+02 2.1557448496378D+02\n', ' 2.1499255820352D+02 2.1439411509101D+02 2.1377920538053D+02 2.1314789764164D+02\n', ' 2.1250027660557D+02 2.1183644377599D+02 2.1115651436290D+02 2.1046061748192D+02\n', ' 2.0974889267201D+02 2.0902148968820D+02 2.0827856462999D+02 2.0752027937237D+02\n', ' 2.0674679737217D+02 2.0595828283062D+02 2.0515489630039D+02 2.0433679373548D+02\n', ' 2.0350412209118D+02 2.0265701849283D+02 2.0179560610146D+02 2.0091999371609D+02\n', ' 2.0003027226069D+02 1.9912651521224D+02 1.9820877613011D+02 1.9727709034808D+02\n', ' 1.9633147398381D+02 1.9537192730795D+02 1.9439843559222D+02 1.9341097442320D+02\n', ' 1.9240951252367D+02 1.9139401896888D+02 1.9036446771897D+02 1.8932084621831D+02\n', ' 1.8826316083923D+02 1.8719144578047D+02 1.8610576807707D+02 1.8500623524759D+02\n', ' 1.8389299820288D+02 1.8276625597726D+02 1.8162625501544D+02 1.8047328975900D+02\n', ' 1.7930769751295D+02 1.7812985462709D+02 1.7694016728062D+02 1.7573906419785D+02\n', ' 1.7452698483161D+02 1.7330437052068D+02 1.7207165225050D+02 1.7082924252562D+02\n', ' 1.6957752490073D+02 1.6831684852739D+02 1.6704752106269D+02 1.6576980707048D+02\n', ' 1.6448392503088D+02 1.6319004987128D+02 1.6188831394372D+02 1.6057881320557D+02\n', ' 1.5926161140883D+02 1.5793674897193D+02 1.5660424928904D+02 1.5526412912797D+02\n', ' 1.5391640587163D+02 1.5256110827071D+02 1.5119828349169D+02 1.4982800716485D+02\n', ' 1.4845038926105D+02 1.4706558254124D+02 1.4567378646660D+02 1.4427525335760D+02\n', ' 1.4287028973201D+02 1.4145925967252D+02 1.4004258319916D+02 1.3862073655179D+02\n', ' 1.3719424741217D+02 1.3576369203189D+02 1.3432968734059D+02 1.3289288509486D+02\n', ' 1.3145396119864D+02 1.3001360731834D+02 1.2857251804149D+02 1.2713138078703D+02\n', ' 1.2569086183440D+02 1.2425159580954D+02 1.2281417214163D+02 1.2137912598684D+02\n', ' 1.1994692729722D+02 1.1851797568245D+02 1.1709259485733D+02 1.1567103435688D+02\n', ' 1.1425347221260D+02 1.1284002597012D+02 1.1143076517616D+02 1.1002573184119D+02\n', ' 1.0862496083974D+02 1.0722850539804D+02 1.0583645829896D+02 1.0444897295863D+02\n', ' 1.0306627469407D+02 1.0168866698066D+02 1.0031652468497D+02 9.8950281535736D+01\n', ' 9.7590406592757D+01 9.6237379437951D+01 9.4891660449011D+01 9.3553666323648D+01\n', ' 9.2223746534976D+01 9.0902169387375D+01 8.9589111477133D+01 8.8284657392085D+01\n', ' 8.6988801958609D+01 8.5701460824096D+01 8.4422481296008D+01 8.3151658731970D+01\n', ' 8.1888750882168D+01 8.0633495793775D+01 7.9385625690446D+01 7.8144883193238D+01\n', ' 7.6911032485454D+01 7.5683872147021D+01 7.4463242511212D+01 7.3249034469117D+01\n', ' 7.2041192786894D+01 7.0839720974575D+01 6.9644680822992D+01 6.8456193805239D+01\n', ' 6.7274437458763D+01 6.6099644008936D+01 6.4932094355076D+01 6.3772114708800D+01\n', ' 6.2620068988986D+01 6.1476354271855D+01 6.0341392368212D+01 5.9215624820188D+01\n', ' 5.8099504346808D+01 5.6993490014576D+01 5.5898039113731D+01 5.4813602994596D+01\n', ' 5.3740619794101D+01 5.2679511283489D+01 5.1630676718269D+01 5.0594490899448D+01\n', ' 4.9571299282324D+01 4.8561417323619D+01 4.7565126864276D+01 4.6582676725353D+01\n', ' 4.5614280281863D+01 4.4660117183703D+01 4.3720331962240D+01 4.2795036687884D+01\n', ' 4.1884310396145D+01 4.0988202447476D+01 4.0106732521637D+01 3.9239894415254D+01\n', ' 3.8387656331152D+01 3.7549964835912D+01 3.6726745168292D+01 3.5917905089852D+01\n', ' 3.5123334963430D+01 3.4342911275550D+01 3.3576496301905D+01 3.2823941166586D+01\n', ' 3.2085085015289D+01 3.1359757592449D+01 3.0647777962729D+01 2.9948956701266D+01\n', ' 2.9263094301912D+01 2.8589983148601D+01 2.7929405791911D+01 2.7281136877294D+01\n', ' 2.6644941445248D+01 2.6020577052810D+01 2.5407791832336D+01 2.4806327243964D+01\n', ' 2.4215916019473D+01 2.4217296667081D+01 2.4191047140217D+01 2.4164848894740D+01\n', ' 2.4138701763903D+01 2.4112605581851D+01 2.4086560183238D+01 2.4060565403594D+01\n', ' 2.4034621078955D+01 2.4008727046229D+01 2.3982883142818D+01 2.3982883142818D+01\n', ' 2.3906676013917D+01 2.3830804274745D+01 2.3755270583097D+01 2.3680077373912D+01\n', ' 2.3605226870735D+01 2.3530721095155D+01 2.3456561876909D+01 2.3382750862431D+01\n', ' 2.3309289523592D+01 2.3236179165301D+01 2.3163420933498D+01 2.3091015821750D+01\n', ' 2.3018964678451D+01 2.2947268212692D+01 2.2875927000740D+01 2.2804941491271D+01\n', ' 2.2734312011222D+01 2.2664038770471D+01 2.2594121867132D+01 2.2524561291720D+01\n', ' 2.2455356932116D+01 2.2386508577113D+01 2.2318015920947D+01 2.2249878566686D+01\n', ' 2.2182096030209D+01 2.2114667743319D+01 2.2047593057381D+01 2.1980871246156D+01\n', ' 2.1914501509131D+01 2.1848482974106D+01 2.1782814700254D+01 2.1717495680452D+01\n', ' 2.1652524844246D+01 2.1587901059797D+01 2.1523623136624D+01 2.1459689827580D+01\n', ' 2.1396099831230D+01 2.1332851793712D+01 2.1269944310940D+01 2.1207375930331D+01\n', ' 2.1145145152831D+01 2.1083250434525D+01 2.1021690188517D+01 2.0960462786425D+01\n', ' 2.0899566560082D+01 2.0838999803082D+01 2.0838999803082D+01 2.0784369206998D+01\n', ' 2.0729953980003D+01 2.0675774720955D+01 2.0621838348757D+01 2.0568148639711D+01\n', ' 2.0514707620129D+01 2.0461516590677D+01 2.0408576100111D+01 2.0355886443851D+01\n', ' 2.0303447467111D+01 2.0251258922982D+01 2.0199320249997D+01 2.0147630864093D+01\n', ' 2.0096189942478D+01 2.0044996673656D+01 1.9994050055783D+01 1.9943349115814D+01\n', ' 1.9892892724348D+01 1.9842679789806D+01 1.9792709089676D+01 1.9742979443660D+01\n', ' 1.9693489560241D+01 1.9644238192180D+01 1.9644238192180D+01 1.9586732853297D+01\n', ' 1.9529564638167D+01 1.9472730952971D+01 1.9416229202614D+01 1.9360056793792D+01\n', ' 1.9304211137528D+01 1.9248689651576D+01 1.9193489762267D+01 1.9138608906555D+01\n', ' 1.9084044533419D+01 1.9029794105367D+01 1.8975855099623D+01 1.8922225009280D+01\n', ' 1.8868901344220D+01 1.8815881632023D+01 1.8763163418666D+01 1.8710744269224D+01\n', ' 1.8658621768397D+01 1.8606793521050D+01 1.8555257152592D+01 1.8504010309371D+01\n', ' 1.8453050658946D+01 1.8402375890365D+01 1.8351983714336D+01 1.8301871863409D+01\n', ' 1.8252038092074D+01 1.8202480176858D+01 1.8153195916357D+01 1.8104183131266D+01\n', ' 1.8055439664361D+01 1.8006963380498D+01 1.7958752166435D+01 1.7910803930933D+01\n', ' 1.7863116604538D+01 1.7815688139495D+01 1.7768516509626D+01 1.7721599710180D+01\n', ' 1.7674935757680D+01 1.7628522689760D+01 1.7582358564978D+01 1.7536441462645D+01\n', ' 1.7490769482617D+01 1.7445340745107D+01 1.7400153390473D+01 1.7355205579004D+01\n', ' 1.7310495490707D+01 1.7266021325090D+01 1.7221781300930D+01 1.7177773656056D+01\n', ' 1.7133996647110D+01 1.7090448549332D+01 1.7047127656312D+01 1.7004032279769D+01\n', '    2\n', '-1.0867779003139D-07-1.1143124975425D-07-1.1425441334663D-07-1.1714904535316D-07\n', '-1.2011695503354D-07-1.2315999740485D-07-1.2628007446737D-07-1.2947913634937D-07\n', '-1.3275918261458D-07-1.3612226340139D-07-1.3957048070404D-07-1.4310598984235D-07\n', '-1.4673100060883D-07-1.5044777876145D-07-1.5425864743962D-07-1.5816598857239D-07\n', '-1.6217224442260D-07-1.6627991902514D-07-1.7049157988510D-07-1.7480985944993D-07\n', '-1.7923745682125D-07-1.8377713946463D-07-1.8843174486146D-07-1.9320418234961D-07\n', '-1.9809743493054D-07-2.0311456112316D-07-2.0825869687519D-07-2.1353305750150D-07\n', '-2.1894093977111D-07-2.2448572383496D-07-2.3017087551577D-07-2.3599994830812D-07\n', '-2.4197658565441D-07-2.4810452332239D-07-2.5438759152846D-07-2.6082971753186D-07\n', '-2.6743492801076D-07-2.7420735155158D-07-2.8115122123411D-07-2.8827087733312D-07\n', '-2.9557076995241D-07-3.0305546185648D-07-3.1072963129910D-07-3.1859807493657D-07\n', '-3.2666571084675D-07-3.3493758156451D-07-3.4341885729330D-07-3.5211483907037D-07\n', '-3.6103096210100D-07-3.7017279917827D-07-3.7954606413704D-07-3.8915661547013D-07\n', '-3.9901045991076D-07-4.0911375630947D-07-4.1947281937094D-07-4.3009412367878D-07\n', '-4.4098430773497D-07-4.5215017806474D-07-4.6359871354088D-07-4.7533706972051D-07\n', '-4.8737258329261D-07-4.9971277667420D-07-5.1236536275588D-07-5.2533824965200D-07\n', '-5.3863954570585D-07-5.3863954679371D-07-5.3924408149106D-07-5.3984861619568D-07\n', '-5.4045315088752D-07-5.4105768557827D-07-5.4166222027008D-07-5.4226675496077D-07\n', '-5.4287128964693D-07-5.4347582433469D-07-5.4408035901790D-07-5.4408035901790D-07\n', '-5.3487219536643D-07-5.2566522634912D-07-5.1645943810664D-07-5.0725481697698D-07\n', '-4.9805134955280D-07-4.8884902262842D-07-4.7964782322234D-07-4.7044773855535D-07\n', '-4.6124875607841D-07-4.5205086342465D-07-4.4285404844291D-07-4.3365829916219D-07\n', '-4.2446360382601D-07-4.1526995083857D-07-4.0607732881205D-07-3.9688572653013D-07\n', '-3.8769513296265D-07-3.7850553723611D-07-3.6931692867515D-07-3.6012929675129D-07\n', '-3.5094263110496D-07-3.4175692154719D-07-3.3257215803765D-07-3.2338833069749D-07\n', '-3.1420542980733D-07-3.0502344578365D-07-2.9584236919381D-07-2.8666219076413D-07\n', '-2.7748290134221D-07-2.6830449193083D-07-2.5912695366731D-07-2.4995027780995D-07\n', '-2.4077445576927D-07-2.3159947906728D-07-2.2242533936790D-07-2.1325202845136D-07\n', '-2.0407953822119D-07-1.9490786070874D-07-1.8573698804938D-07-1.7656691250844D-07\n', '-1.6739762646009D-07-1.5822912239146D-07-1.4906139290017D-07-1.3989443068946D-07\n', '-1.3072822857250D-07-1.2156277946598D-07-1.2156277946598D-07-1.1432829732023D-07\n', '-1.0796343659823D-07-1.0215203727973D-07-9.6778871013881D-08-9.1776301714793D-08\n', '-8.7098095455870D-08-8.2709931739944D-08-7.8584965636949D-08-7.4701424528357D-08\n', '-7.1041173537938D-08-6.7588797058003D-08-6.4330978649095D-08-6.1256064583133D-08\n', '-5.8353746116333D-08-5.5614821696581D-08-5.3031014789423D-08-5.0594831529849D-08\n', '-4.8299447566075D-08-4.6138616772712D-08-4.4106596624332D-08-4.2198086497768D-08\n', '-4.0408176114269D-08-3.8732302077654D-08-3.8732302077654D-08-3.6866998781668D-08\n', '-3.5073012696957D-08-3.3347390891523D-08-3.1687389065546D-08-3.0090449743622D-08\n', '-2.8554183509701D-08-2.7076352760114D-08-2.5654857553622D-08-2.4287723218550D-08\n', '-2.2973089448571D-08-2.1709200661774D-08-2.0494397439783D-08-1.9327108899846D-08\n', '-1.8205845867851D-08-1.7129194748938D-08-1.6095812011460D-08-1.5104419199335D-08\n', '-1.4153798416356D-08-1.3242788224247D-08-1.2370279907115D-08-1.1535214061070D-08\n', '-1.0736577475739D-08-9.9734002739990D-09-9.2447532855278D-09-8.5497456285062D-09\n', '-7.8875224805236D-09-7.2572630189883D-09-6.6581785159307D-09-6.0895105724431D-09\n', '-5.5505294799813D-09-5.0405326971367D-09-4.5588434324740D-09-4.1048093232660D-09\n', '-3.6778012026710D-09-3.2772119478553D-09-2.9024554028412D-09-2.5529653692523D-09\n', '-2.2281946606732D-09-1.9276142147067D-09-1.6507122591619D-09-1.3969935277935D-09\n', '-1.1659785221220D-09-9.5720281606639D-10-7.7021640014373D-10-6.0458306262512D-10\n', '-4.5987980502181D-10-3.3569628945879D-10-2.3163431597574D-10-1.4730732757666D-10\n', '-8.2339941363560D-11-3.6367503943469D-11-9.0356696338917D-12-1.1485845543309D-20\n', '    3\n', '-1.0867779007261D-07-1.1143124977652D-07-1.1425441336107D-07-1.1714904537088D-07\n', '-1.2011695503791D-07-1.2315999742085D-07-1.2628007446449D-07-1.2947913636648D-07\n', '-1.3275918264338D-07-1.3612226343356D-07-1.3957048073126D-07-1.4310598986186D-07\n', '-1.4673100063454D-07-1.5044777879891D-07-1.5425864746665D-07-1.5816598858900D-07\n', '-1.6217224444825D-07-1.6627991906539D-07-1.7049157992054D-07-1.7480985948891D-07\n', '-1.7923745687211D-07-1.8377713951074D-07-1.8843174489451D-07-1.9320418238906D-07\n', '-1.9809743496252D-07-2.0311456116574D-07-2.0825869691313D-07-2.1353305754731D-07\n', '-2.1894093980261D-07-2.2448572388548D-07-2.3017087556035D-07-2.3599994833846D-07\n', '-2.4197658570245D-07-2.4810452334931D-07-2.5438759156898D-07-2.6082971758601D-07\n', '-2.6743492806051D-07-2.7420735159974D-07-2.8115122128904D-07-2.8827087739209D-07\n', '-2.9557077000849D-07-3.0305546191387D-07-3.1072963135645D-07-3.1859807498905D-07\n', '-3.2666571090272D-07-3.3493758162193D-07-3.4341885735289D-07-3.5211483912384D-07\n', '-3.6103096216158D-07-3.7017279924043D-07-3.7954606420917D-07-3.8915661553490D-07\n', '-3.9901045998278D-07-4.0911375638256D-07-4.1947281944720D-07-4.3009412375271D-07\n', '-4.4098430780453D-07-4.5215017814525D-07-4.6359871362544D-07-4.7533706980777D-07\n', '-4.8737258337361D-07-4.9971277675869D-07-5.1236536284046D-07-5.2533824974642D-07\n', '-5.3863954579837D-07-5.3863954688346D-07-5.3924408158646D-07-5.3984861628563D-07\n', '-5.4045315097827D-07-5.4105768567397D-07-5.4166222036103D-07-5.4226675505252D-07\n', '-5.4287128974433D-07-5.4347582442803D-07-5.4408035910648D-07-5.4408035910648D-07\n', '-5.3487219545843D-07-5.2566522644503D-07-5.1645943819573D-07-5.0725481706660D-07\n', '-4.9805134964147D-07-4.8884902271681D-07-4.7964782330620D-07-4.7044773864064D-07\n', '-4.6124875616121D-07-4.5205086350923D-07-4.4285404852369D-07-4.3365829924430D-07\n', '-4.2446360390025D-07-4.1526995090992D-07-4.0607732888350D-07-3.9688572660087D-07\n', '-3.8769513302932D-07-3.7850553730577D-07-3.6931692874353D-07-3.6012929681375D-07\n', '-3.5094263116724D-07-3.4175692160910D-07-3.3257215809811D-07-3.2338833075761D-07\n', '-3.1420542986380D-07-3.0502344583735D-07-2.9584236924966D-07-2.8666219081518D-07\n', '-2.7748290139481D-07-2.6830449198114D-07-2.5912695371479D-07-2.4995027785639D-07\n', '-2.4077445581423D-07-2.3159947911316D-07-2.2242533941053D-07-2.1325202849355D-07\n', '-2.0407953826105D-07-1.9490786074366D-07-1.8573698808504D-07-1.7656691254239D-07\n', '-1.6739762649289D-07-1.5822912242378D-07-1.4906139292989D-07-1.3989443071720D-07\n', '-1.3072822859997D-07-1.2156277949203D-07-1.2156277949203D-07-1.1432829734423D-07\n', '-1.0796343662042D-07-1.0215203730224D-07-9.6778871034153D-08-9.1776301735053D-08\n', '-8.7098095474605D-08-8.2709931758141D-08-7.8584965654001D-08-7.4701424544493D-08\n', '-7.1041173554121D-08-6.7588797074022D-08-6.4330978664287D-08-6.1256064597056D-08\n', '-5.8353746130412D-08-5.5614821709432D-08-5.3031014801906D-08-5.0594831541733D-08\n', '-4.8299447577411D-08-4.6138616783955D-08-4.4106596635090D-08-4.2198086507752D-08\n', '-4.0408176124208D-08-3.8732302087114D-08-3.8732302087114D-08-3.6866998791088D-08\n', '-3.5073012706106D-08-3.3347390900014D-08-3.1687389073533D-08-3.0090449751172D-08\n', '-2.8554183516662D-08-2.7076352766897D-08-2.5654857560227D-08-2.4287723224824D-08\n', '-2.2973089454270D-08-2.1709200667375D-08-2.0494397445078D-08-1.9327108904996D-08\n', '-1.8205845872538D-08-1.7129194753451D-08-1.6095812015559D-08-1.5104419203165D-08\n', '-1.4153798420007D-08-1.3242788227685D-08-1.2370279910387D-08-1.1535214064147D-08\n', '-1.0736577478506D-08-9.9734002766678D-09-9.2447532879530D-09-8.5497456308046D-09\n', '-7.8875224826164D-09-7.2572630210155D-09-6.6581785177281D-09-6.0895105741136D-09\n', '-5.5505294814448D-09-5.0405326985186D-09-4.5588434337359D-09-4.1048093243912D-09\n', '-3.6778012036368D-09-3.2772119487373D-09-2.9024554036301D-09-2.5529653699373D-09\n', '-2.2281946612744D-09-1.9276142152144D-09-1.6507122596184D-09-1.3969935281765D-09\n', '-1.1659785224466D-09-9.5720281632646D-10-7.7021640035188D-10-6.0458306279581D-10\n', '-4.5987980515044D-10-3.3569628955508D-10-2.3163431604240D-10-1.4730732761895D-10\n', '-8.2339941387318D-11-3.6367503953192D-11-9.0356696363779D-12-1.1478470662795D-20\n', '    6\n', '-3.2861672835412D-09-3.4547859568192D-09-3.6320530893832D-09-3.8184121701146D-09\n', '-4.0143293925676D-09-4.2202949433128D-09-4.4368241030359D-09-4.6644586185627D-09\n', '-4.9037679272227D-09-5.1553507892035D-09-5.4198366320807D-09-5.6978871052596D-09\n', '-5.9901979038299D-09-6.2975002442020D-09-6.6205630034465D-09-6.9601943639200D-09\n', '-7.3172439922017D-09-7.6926051411971D-09-8.0872168250824D-09-8.5020662336406D-09\n', '-8.9381911420867D-09-9.3966826000978D-09-9.8786875152073D-09-1.0385411624485D-08\n', '-1.0918122531402D-08-1.1478152747414D-08-1.2066903197226D-08-1.2685846541042D-08\n', '-1.3336530994247D-08-1.4020584129150D-08-1.4739716950199D-08-1.5495728229236D-08\n', '-1.6290508900567D-08-1.7126046890683D-08-1.8004432025309D-08-1.8927861269067D-08\n', '-1.9898644220616D-08-2.0919208904764D-08-2.1992107841277D-08-2.3120024370901D-08\n', '-2.4305779468229D-08-2.5552338699489D-08-2.6862819693259D-08-2.8240499933133D-08\n', '-2.9688824935487D-08-3.1211416884939D-08-3.2812083667085D-08-3.4494828449587D-08\n', '-3.6263859632052D-08-3.8123601401388D-08-4.0078704792633D-08-4.2134059325249D-08\n', '-4.4294805217553D-08-4.6566346250826D-08-4.8954363274907D-08-5.1464828419657D-08\n', '-5.4104020014395D-08-5.6878538289480D-08-5.9795321892260D-08-6.2861665208739D-08\n', '-6.6085236615420D-08-6.9474097651490D-08-7.3036723160537D-08-7.6782022501563D-08\n', '-8.0719361797469D-08-8.0719360134193D-08-8.0900648249557D-08-8.1082139716387D-08\n', '-8.1263834524904D-08-8.1445732682760D-08-8.1627834182954D-08-8.1810139033135D-08\n', '-8.1992647231162D-08-8.2175358770111D-08-8.2358273659637D-08-8.2358273659637D-08\n', '-8.0705020095855D-08-7.9060935624552D-08-7.7425638468640D-08-7.5798754868151D-08\n', '-7.4179918860301D-08-7.2568772127392D-08-7.0964963786897D-08-6.9368150235363D-08\n', '-6.7777994968024D-08-6.6194168404196D-08-6.4616347742643D-08-6.3044216791818D-08\n', '-6.1477465803865D-08-5.9915791352440D-08-5.8358896159151D-08-5.6806488972116D-08\n', '-5.5258284411871D-08-5.3714002841393D-08-5.2173370235000D-08-5.0636118053634D-08\n', '-4.9101983107812D-08-4.7570707452524D-08-4.6042038256361D-08-4.4515727683525D-08\n', '-4.2991532791892D-08-4.1469215414120D-08-3.9948542058605D-08-3.8429283796959D-08\n', '-3.6911216164173D-08-3.5394119063890D-08-3.3877776661540D-08-3.2361977305348D-08\n', '-3.0846513419384D-08-2.9331181417738D-08-2.7815781624130D-08-2.6300118178450D-08\n', '-2.4783998954577D-08-2.3267235483752D-08-2.1749642866137D-08-2.0231039706610D-08\n', '-1.8711248026055D-08-1.7190093194892D-08-1.5667403859571D-08-1.4143011872395D-08\n', '-1.2616752222447D-08-1.1088462969543D-08-1.1088462969543D-08-9.9224355600570D-09\n', '-8.9337933532450D-09-8.0571017877347D-09-7.2684522946303D-09-6.5537844425333D-09\n', '-5.9034723960190D-09-5.3103625071826D-09-4.7688549357556D-09-4.2744059675527D-09\n', '-3.8232307037501D-09-3.4121125445537D-09-3.0382744445693D-09-2.6992882000054D-09\n', '-2.3930083439651D-09-2.1175226110435D-09-1.8711139444078D-09-1.6522307678034D-09\n', '-1.4594633236608D-09-1.2915245557900D-09-1.1472344602925D-09-1.0255071260679D-09\n', '-9.2533989087793D-10-8.4580418339265D-10-8.4580418339265D-10-7.6762649022023D-10\n', '-6.9592618705268D-10-6.3019397348778D-10-5.6996380398466D-10-5.1480828444978D-10\n', '-4.6433470759978D-10-4.1818161694957D-10-3.7601581127418D-10-3.3752971932918D-10\n', '-3.0243908807908D-10-2.7048093722517D-10-2.4141174223370D-10-2.1500581444696D-10\n', '-1.9105385072592D-10-1.6936163136321D-10-1.4974884748786D-10-1.3204804147969D-10\n', '-1.1610364725309D-10-1.0177111891413D-10-8.8916137419709D-11-7.7413886765385D-11\n', '-6.7148392329994D-11-5.8011914769467D-11-4.9904393527455D-11-4.2732935375925D-11\n', '-3.6411343221770D-11-3.0859681497873D-11-2.6003874598378D-11-2.1775335403345D-11\n', '-1.8110621026788D-11-1.4951113535759D-11-1.2242723351124D-11-9.9356134314248D-12\n', '-7.9839425253551D-12-6.3456258285078D-12-4.9821117716307D-12-3.8581735057261D-12\n', '-2.9417140493384D-12-2.2035839504382D-12-1.6174106152090D-12-1.1594383077674D-12\n', '-8.0837812950999D-13-5.4526722358725D-13-3.5333651108713D-13-2.1788640714220D-13\n', '-1.2616992144306D-13-6.7282653249237D-14-3.2059203147732D-14-1.2975576825091D-14\n', '-4.0571818831883D-15-7.9204683775542D-16-4.8930043424249D-17-2.1031199044751D-21\n', '   10\n', '-1.1511850873695D-10-1.2409294983534D-10-1.3376680144304D-10-1.4419461744343D-10\n', '-1.5543508520873D-10-1.6755156439980D-10-1.8061229348612D-10-1.9469082664431D-10\n', '-2.0986648949062D-10-2.2622471163799D-10-2.4385765771063D-10-2.6286460162476D-10\n', '-2.8335259385126D-10-3.0543701401048D-10-3.2924219816565D-10-3.5490221939536D-10\n', '-3.8256156747253D-10-4.1237597057793D-10-4.4451329702843D-10-4.7915450307758D-10\n', '-5.1649465155387D-10-5.5674395708812D-10-6.0012903621449D-10-6.4689417746789D-10\n', '-6.9730264978320D-10-7.5163825397168D-10-8.1020689527207D-10-8.7333832193795D-10\n', '-9.4138794521542D-10-1.0147388538163D-09-1.0938040092036D-09-1.1790285033321D-09\n', '-1.2708921154016D-09-1.3699119915493D-09-1.4766455501594D-09-1.5916936332798D-09\n', '-1.7157039024343D-09-1.8493744186930D-09-1.9934576662846D-09-2.1487646962304D-09\n', '-2.3161697580826D-09-2.4966151955722D-09-2.6911167491348D-09-2.9007692631438D-09\n', '-3.1267528898042D-09-3.3703396771631D-09-3.6329007771945D-09-3.9159141309217D-09\n', '-4.2209728129293D-09-4.5497939708923D-09-4.9042285328690D-09-5.2862715672478D-09\n', '-5.6980735630230D-09-6.1419525087940D-09-6.6204069512294D-09-7.1361300360723D-09\n', '-7.6920246776889D-09-8.2912199081574D-09-8.9370884592777D-09-9.6332657595199D-09\n', '-1.0383670390630D-08-1.1192526130422D-08-1.2064385742353D-08-1.3004156559850D-08\n', '-1.4017128150204D-08-1.4017126529968D-08-1.4064374209546D-08-1.4111727945395D-08\n', '-1.4159187843379D-08-1.4206754043716D-08-1.4254426645333D-08-1.4302205775957D-08\n', '-1.4350091560190D-08-1.4398084102166D-08-1.4446183535506D-08-1.4446183535506D-08\n', '-1.0949713917055D-08-7.5647198654719D-09-4.2883038179098D-09-1.1176427510956D-09\n', ' 1.9500139047194D-09 4.9173462972840D-09 7.7869661221756D-09 1.0561418529862D-08\n', ' 1.3243183968225D-08 1.5834679984851D-08 1.8338262959200D-08 2.0756229781983D-08\n', ' 2.3090819511094D-08 2.5344214927731D-08 2.7518544104568D-08 2.9615881871448D-08\n', ' 3.1638251288261D-08 3.3587625026517D-08 3.5465926752530D-08 3.7275032434206D-08\n', ' 3.9016771636513D-08 4.0692928759087D-08 4.2305244257393D-08 4.3855415803197D-08\n', ' 4.5345099434984D-08 4.6775910660489D-08 4.8149425529710D-08 4.9467181690447D-08\n', ' 5.0730679382039D-08 5.1941382440395D-08 5.3100719244106D-08 5.4210083637512D-08\n', ' 5.5270835851931D-08 5.6284303361510D-08 5.7251781751820D-08 5.8174535538562D-08\n', ' 5.9053798972099D-08 5.9890776825284D-08 6.0686645148724D-08 6.1442552011720D-08\n', ' 6.2159618217160D-08 6.2838938004000D-08 6.3481579722379D-08 6.4088586494836D-08\n', ' 6.4660976856176D-08 6.5199745382327D-08 6.5199745382327D-08 6.5312670467263D-08\n', ' 6.5125471582011D-08 6.4747559423369D-08 6.4220795294550D-08 6.3570644923799D-08\n', ' 6.2815045890130D-08 6.1967658554173D-08 6.1039404301120D-08 6.0039308381664D-08\n', ' 5.8975009056280D-08 5.7853087552817D-08 5.6679293584843D-08 5.5458706092868D-08\n', ' 5.4195851736303D-08 5.2894794723368D-08 5.1559206511287D-08 5.0192420984803D-08\n', ' 4.8797478880336D-08 4.7377164101514D-08 4.5934033778958D-08 4.4470443456991D-08\n', ' 4.2988568394428D-08 4.1490421766781D-08 4.1490421766781D-08 3.9744016275567D-08\n', ' 3.8039746302063D-08 3.6377706113628D-08 3.4757915702518D-08 3.3180329853258D-08\n', ' 3.1644845975945D-08 3.0151310917860D-08 2.8699526913928D-08 2.7289256807499D-08\n', ' 2.5920228652851D-08 2.4592139783878D-08 2.3304660425411D-08 2.2057436907975D-08\n', ' 2.0850094536842D-08 1.9682240156723D-08 1.8553464456266D-08 1.7463344033840D-08\n', ' 1.6411443260136D-08 1.5397315956620D-08 1.4420506911529D-08 1.3480553248789D-08\n', ' 1.2576985669497D-08 1.1709329574589D-08 1.0877106084475D-08 1.0079832962754D-08\n', ' 9.3170254561004D-09 8.5881970560622D-09 7.8928601917409D-09 7.2305268589754D-09\n', ' 6.6007091921613D-09 6.0029199833118D-09 5.4366731541731D-09 4.9014841843799D-09\n', ' 4.3968704996876D-09 3.9223518243197D-09 3.4774505000237D-09 3.0616917743861D-09\n', ' 2.6746040615223D-09 2.3157191770015D-09 1.9845725492936D-09 1.6807034096382D-09\n', ' 1.4036549619480D-09 1.1529745345786D-09 9.2821371512506D-10 7.2892846986161D-10\n', ' 5.5467924889469D-10 4.0503107808918D-10 2.7955363903982D-10 1.7782133774537D-10\n', ' 9.9413363123970D-11 4.3913735960334D-11 1.0911349169323D-11 1.6669374284445D-21\n', '   13\n', ' 6.1917128853224D-11 6.6746297903366D-11 7.1951985447820D-11 7.7563570356923D-11\n', ' 8.3612708572481D-11 9.0133474854217D-11 9.7162621142686D-11 1.0473971107331D-10\n', ' 1.1290750657360D-10 1.2171192772448D-10 1.3120259482301D-10 1.4143294929743D-10\n', ' 1.5246057959567D-10 1.6434756495321D-10 1.7716086111358D-10 1.9097253008309D-10\n', ' 2.0586038506857D-10 2.2190816743815D-10 2.3920624630317D-10 2.5785197736163D-10\n', ' 2.7795027068501D-10 2.9961429832826D-10 3.2296597042327D-10 3.4813671481803D-10\n', ' 3.7526822831912D-10 4.0451317312801D-10 4.3603617965822D-10 4.7001469562065D-10\n', ' 5.0663992672074D-10 5.4611805772713D-10 5.8867127152031D-10 6.3453909856741D-10\n', ' 6.8397970423609D-10 7.3727138515430D-10 7.9471409550562D-10 8.5663116327729D-10\n', ' 9.2337112554185D-10 9.9530963742800D-10 1.0728516296586D-09 1.1564335863031D-09\n', ' 1.2465259653783D-09 1.3436358898194D-09 1.4483099961558D-09 1.5611374838993D-09\n', ' 1.6827534594093D-09 1.8138424817410D-09 1.9551424618780D-09 2.1074487682616D-09\n', ' 2.2716187411734D-09 2.4485764800003D-09 2.6393180826830D-09 2.8449172317928D-09\n', ' 3.0665312276957D-09 3.3054075192155D-09 3.5628907118040D-09 3.8404301521116D-09\n', ' 4.1395880485713D-09 4.4620483005433D-09 4.8096259463681D-09 5.1842773915152D-09\n', ' 5.5881114060129D-09 6.0234010061027D-09 6.4925962471210D-09 6.9983379747960D-09\n', ' 7.5434727449389D-09 7.5434711170721D-09 7.5688976513332D-09 7.5943812544110D-09\n', ' 7.6199219938375D-09 7.6455199348793D-09 7.6711751353539D-09 7.6968876695481D-09\n', ' 7.7226575938922D-09 7.7484849708761D-09 7.7743698728900D-09 7.7743698728900D-09\n', ' 3.7033997539252D-09-2.3777007361676D-10-4.0523991767476D-09-7.7436635211013D-09\n', '-1.1314657781367D-08-1.4768397639080D-08-1.8107821956959D-08-2.1335794934113D-08\n', '-2.4455108159460D-08-2.7468482614122D-08-3.0378570640445D-08-3.3187957799370D-08\n', '-3.5899164709007D-08-3.8514648827719D-08-4.1036806161626D-08-4.3467972950734D-08\n', '-4.5810427270300D-08-4.8066390621880D-08-5.0238029439213D-08-5.2327456586184D-08\n', '-5.4336732792530D-08-5.6267868037997D-08-5.8122822908553D-08-5.9903509920057D-08\n', '-6.1611794792601D-08-6.3249497690686D-08-6.4818394410593D-08-6.6320217575126D-08\n', '-6.7756657752999D-08-6.9129364561886D-08-7.0439947749631D-08-7.1689978225593D-08\n', '-7.2880989074692D-08-7.4014476537658D-08-7.5091900969982D-08-7.6114687776000D-08\n', '-7.7084228284493D-08-7.8001880655543D-08-7.8868970716886D-08-7.9686792791745D-08\n', '-8.0456610509853D-08-8.1179657583226D-08-8.1857138566653D-08-8.2490229608768D-08\n', '-8.3080079158000D-08-8.3627808668777D-08-8.3627808668777D-08-8.3669507668556D-08\n', '-8.3347614201420D-08-8.2794451952750D-08-8.2060691842442D-08-8.1177179508844D-08\n', '-8.0165655902593D-08-7.9042688283477D-08-7.7821530479246D-08-7.6513142272559D-08\n', '-7.5126805234225D-08-7.3670521838336D-08-7.2151288265421D-08-7.0575288845769D-08\n', '-6.8948039397951D-08-6.7274495886505D-08-6.5559138747673D-08-6.3806039626521D-08\n', '-6.2018915118376D-08-6.0201170697784D-08-5.8355937074259D-08-5.6486100662394D-08\n', '-5.4594329347353D-08-5.2683094495983D-08-5.2683094495983D-08-5.0456351806800D-08\n', '-4.8284255427709D-08-4.6166832167726D-08-4.4104021354140D-08-4.2095685729199D-08\n', '-4.0141620857733D-08-3.8241563302604D-08-3.6395197756880D-08-3.4602163300280D-08\n', '-3.2862058905825D-08-3.1174448307126D-08-2.9538864308153D-08-2.7954812621728D-08\n', '-2.6421775286116D-08-2.4939213721540D-08-2.3506571465272D-08-2.2123276628161D-08\n', '-2.0788744100607D-08-1.9502377539679D-08-1.8263571161331D-08-1.7071711356015D-08\n', '-1.5926178150645D-08-1.4826346528907D-08-1.3771587626846D-08-1.2761269816021D-08\n', '-1.1794759683326D-08-1.0871422920215D-08-9.9906251267489D-09-9.1517325427059D-09\n', '-8.3541127071727D-09-7.5971350580069D-09-6.8801714730352D-09-6.2025967608156D-09\n', '-5.5637891028795D-09-4.9631304538303D-09-4.4000069012345D-09-3.8738089899859D-09\n', '-3.3839320135896D-09-2.9297762746719D-09-2.5107473182142D-09-2.1262561389143D-09\n', '-1.7757193655706D-09-1.4585594234569D-09-1.1742046773781D-09-9.2208955624352D-10\n', '-7.0165466113721D-10-5.1234685793809D-10-3.5361935584261D-10-2.2493177286118D-10\n', '-1.2575018940691D-10-5.5547190841271D-11-1.3801899931175D-11-2.7214063952793D-21\n', '   21\n', ' 4.5631185522476D-03 4.8455663125134D-03 5.1159599910797D-03 5.3708921127769D-03\n', ' 5.6075886442427D-03 5.8238547692316D-03 6.0180472391801D-03 6.1890226608487D-03\n', ' 6.3361035756217D-03 6.4590299946303D-03 6.5579297536169D-03 6.6332789714355D-03\n', ' 6.6858796856178D-03 6.7168295063418D-03 6.7275066090587D-03 6.7195471980764D-03\n', ' 6.6948368351397D-03 6.6554940642348D-03 6.6038673504998D-03 6.5425234650269D-03\n', ' 6.4742497774486D-03 6.4020463631490D-03 6.3291338308380D-03 6.2589483642862D-03\n', ' 6.1951555645709D-03 6.1416477183754D-03 6.1025642746847D-03 6.0822905430747D-03\n', ' 6.0854854256272D-03 6.1170805202563D-03 6.1823156343253D-03 6.2867369589672D-03\n', ' 6.4362407842217D-03 6.6370691366662D-03 6.8958621532252D-03 7.2196495527998D-03\n', ' 7.6159125799893D-03 8.0925702658224D-03 8.6580531292458D-03 9.3212848419999D-03\n', ' 1.0091772432337D-02 1.0979587117436D-02 1.1995479825695D-02 1.3150869550287D-02\n', ' 1.4457998115296D-02 1.5929939375138D-02 1.7580811630724D-02 1.9425824006924D-02\n', ' 2.1481566093944D-02 2.3766106007940D-02 2.6299372447547D-02 2.9103310975334D-02\n', ' 3.2202364330448D-02 3.5623681803277D-02 3.9397694004121D-02 4.3558360744090D-02\n', ' 4.8143833149661D-02 5.3196723709902D-02 5.8764855582713D-02 6.4901544952848D-02\n', ' 7.1666452845345D-02 7.9125881145587D-02 8.7353755563504D-02 9.6431946180224D-02\n', ' 1.0645143552024D-01 1.0647093450002D-01 1.0694381436906D-01 1.0741826733298D-01\n', ' 1.0789429706704D-01 1.0837190724675D-01 1.0885110155444D-01 1.0933188367264D-01\n', ' 1.0981425729069D-01 1.1029822609804D-01 1.1078379379105D-01 1.1078379379105D-01\n', ' 1.0965100294939D-01 1.0878914149477D-01 1.0816939084100D-01 1.0776466581497D-01\n', ' 1.0754951753721D-01 1.0750004670808D-01 1.0759382005042D-01 1.0780979502135D-01\n', ' 1.0812824710545D-01 1.0853070368985D-01 1.0899988011661D-01 1.0951962098823D-01\n', ' 1.1007484338489D-01 1.1065148427304D-01 1.1123644965679D-01 1.1181756707562D-01\n', ' 1.1238353974335D-01 1.1292390335903D-01 1.1342898449836D-01 1.1388986114322D-01\n', ' 1.1429832475214D-01 1.1464684404718D-01 1.1492853032315D-01 1.1513710412046D-01\n', ' 1.1526686341682D-01 1.1531265290973D-01 1.1526983480043D-01 1.1513426045156D-01\n', ' 1.1490224353524D-01 1.1457053387443D-01 1.1413629275819D-01 1.1359706880891D-01\n', ' 1.1295077529649D-01 1.1219566789628D-01 1.1133032386084D-01 1.1035362153945D-01\n', ' 1.0926472128075D-01 1.0806304660911D-01 1.0674826673814D-01 1.0532027930235D-01\n', ' 1.0377919438017D-01 1.0212531868116D-01 1.0035914098156D-01 9.8481317675146D-02\n', ' 9.6492659535334D-02 9.4394118540298D-02 9.4394118540298D-02 9.2512625506801D-02\n', ' 9.0652994265453D-02 8.8795274211001D-02 8.6936176525404D-02 8.5076437502452D-02\n', ' 8.3217440084805D-02 8.1361716847980D-02 7.9511437514797D-02 7.7669440707933D-02\n', ' 7.5837985750183D-02 7.4019848683127D-02 7.2217173550290D-02 7.0432552543537D-02\n', ' 6.8667944717381D-02 6.6925716774659D-02 6.5207621732588D-02 6.3515790697594D-02\n', ' 6.1851770094075D-02 6.0217459462453D-02 5.8614207514774D-02 5.7043693029070D-02\n', ' 5.5507080359998D-02 5.4005841601790D-02 5.4005841601790D-02 5.2263824313830D-02\n', ' 5.0522367654505D-02 4.8784814510288D-02 4.7054279454268D-02 4.5333661673017D-02\n', ' 4.3625656507668D-02 4.1932767436693D-02 4.0257316754695D-02 3.8601456580307D-02\n', ' 3.6967178652344D-02 3.5356324374584D-02 3.3770593740070D-02 3.2211554441461D-02\n', ' 3.0680649955052D-02 2.9179207759022D-02 2.7708446619271D-02 2.6269483967497D-02\n', ' 2.4863342436704D-02 2.3490956455181D-02 2.2153178083525D-02 2.0850782882928D-02\n', ' 1.9584475106806D-02 1.8354892901183D-02 1.7162612904308D-02 1.6008154836202D-02\n', ' 1.4891985557848D-02 1.3814523105064D-02 1.2776140256870D-02 1.1777168066229D-02\n', ' 1.0817898984733D-02 9.8985899398210D-03 9.0194650600126D-03 8.1807183450144D-03\n', ' 7.3825160325766D-03 6.6249989050499D-03 5.9082843358347D-03 5.2324682720632D-03\n', ' 4.5976269960944D-03 4.0038188207973D-03 3.4510855982040D-03 2.9394541610729D-03\n', ' 2.4689376079033D-03 2.0395365212476D-03 1.6512400557334D-03 1.3040269608203D-03\n', ' 9.9786649580119D-04 7.3271928200883D-04 5.0853806644997D-04 3.2526842597670D-04\n', ' 1.8284939888544D-04 8.1214061348428D-05 2.0290044257939D-05 3.3281712055412D-15\n', '   25\n', ' 3.8565390690777D-03 4.0952509964394D-03 4.3237753654734D-03 4.5392323340571D-03\n', ' 4.7392774161014D-03 4.9220556533332D-03 5.0861782472521D-03 5.2306788542157D-03\n', ' 5.3549849172102D-03 5.4588767055583D-03 5.5424622602038D-03 5.6061439750483D-03\n', ' 5.6505996955531D-03 5.6767570716591D-03 5.6857808742494D-03 5.6790539483934D-03\n', ' 5.6581698846642D-03 5.6249191795723D-03 5.5812866484720D-03 5.5294416089315D-03\n', ' 5.4717398183156D-03 5.4107168031715D-03 5.3490944747267D-03 5.2897769384020D-03\n', ' 5.2358621926376D-03 5.1906398201868D-03 5.1576082940866D-03 5.1404738775103D-03\n', ' 5.1431740615134D-03 5.1698768072105D-03 5.2250105602600D-03 5.3132627078822D-03\n', ' 5.4396165249015D-03 5.6093474868673D-03 5.8280675340085D-03 6.1017178634445D-03\n', ' 6.4366212811911D-03 6.8394705903592D-03 7.3173908802848D-03 7.8779240305269D-03\n', ' 8.5291049469288D-03 9.2794453620494D-03 1.0138031469335D-02 1.1114514080077D-02\n', ' 1.2219239424679D-02 1.3463256927587D-02 1.4858498731734D-02 1.6417818894650D-02\n', ' 1.8155238180113D-02 2.0086026934507D-02 2.2227027983537D-02 2.4596788714175D-02\n', ' 2.7215967012950D-02 3.0107508219847D-02 3.3297130896519D-02 3.6813536323892D-02\n', ' 4.0688968091129D-02 4.4959440327214D-02 4.9665370980325D-02 5.4851820453957D-02\n', ' 6.0569211520691D-02 6.6873579504843D-02 7.3827403038884D-02 8.1499874974843D-02\n', ' 8.9967889585518D-02 8.9984369231237D-02 9.0384025691213D-02 9.0785011659116D-02\n', ' 9.1187330241102D-02 9.1590984543533D-02 9.1995977678565D-02 9.2402312758491D-02\n', ' 9.2809992901379D-02 9.3219021225379D-02 9.3629400854492D-02 9.3629400854492D-02\n', ' 9.2672017689632D-02 9.1943611658241D-02 9.1419826609075D-02 9.1077771392490D-02\n', ' 9.0895937779238D-02 9.0854127174252D-02 9.0933379997361D-02 9.1115912053514D-02\n', ' 9.1385053084379D-02 9.1725190882112D-02 9.2121717244278D-02 9.2560978367455D-02\n', ' 9.3030226857552D-02 9.3517577281578D-02 9.4011963192864D-02 9.4503096984443D-02\n', ' 9.4981431128921D-02 9.5438121677756D-02 9.5864993094842D-02 9.6254504898374D-02\n', ' 9.6599719604321D-02 9.6894272120925D-02 9.7132340429337D-02 9.7308617417405D-02\n', ' 9.7418283996416D-02 9.7456983140480D-02 9.7420795193823D-02 9.7306213917911D-02\n', ' 9.7110123796749D-02 9.6829777929112D-02 9.6462777166294D-02 9.6007049715950D-02\n', ' 9.5460831968948D-02 9.4822649701766D-02 9.4091300473128D-02 9.3265836315089D-02\n', ' 9.2345547592521D-02 9.1329947094416D-02 9.0218755255100D-02 8.9011885559865D-02\n', ' 8.7709431041754D-02 8.6311650917511D-02 8.4818958278386D-02 8.3231907878145D-02\n', ' 8.1551184945407D-02 7.9777594048276D-02 7.9777594048276D-02 7.8187442161728D-02\n', ' 7.6615766860263D-02 7.5045706805297D-02 7.3474482438474D-02 7.1902716041724D-02\n', ' 7.0331576415060D-02 6.8763203975420D-02 6.7199432473560D-02 6.5642660983431D-02\n', ' 6.4094798981413D-02 6.2558192650947D-02 6.1034654039491D-02 5.9526373949262D-02\n', ' 5.8035008083465D-02 5.6562556671095D-02 5.5110501282245D-02 5.3680643030607D-02\n', ' 5.2274288883357D-02 5.0893044245276D-02 4.9538048985998D-02 4.8210721932109D-02\n', ' 4.6912047142905D-02 4.5643268765106D-02 4.5643268765106D-02 4.4170995379302D-02\n', ' 4.2699195811548D-02 4.1230695316563D-02 3.9768126189104D-02 3.8313938689130D-02\n', ' 3.6870410795753D-02 3.5439658334443D-02 3.4023644002444D-02 3.2624186672056D-02\n', ' 3.1242969669806D-02 2.9881549265998D-02 2.8541362217064D-02 2.7223733465121D-02\n', ' 2.5929882970362D-02 2.4660932656633D-02 2.3417912569221D-02 2.2201767110226D-02\n', ' 2.1013360562385D-02 1.9853482661711D-02 1.8722853530924D-02 1.7622128638860D-02\n', ' 1.6551903188381D-02 1.5512716511243D-02 1.4505055955811D-02 1.3529360765665D-02\n', ' 1.2586025510391D-02 1.1675403494748D-02 1.0797809774534D-02 9.9535241405909D-03\n', ' 9.1427937596346D-03 8.3658357750065D-03 7.6228396098920D-03 6.9139692239858D-03\n', ' 6.2393651138520D-03 5.5991462622808D-03 4.9934118679366D-03 4.4222430209513D-03\n', ' 3.8857041916842D-03 3.3838446635318D-03 2.9166998079174D-03 2.4842923026759D-03\n', ' 2.0866332180555D-03 1.7237230464154D-03 1.3955526217530D-03 1.1021039840857D-03\n', ' 8.4335115278083D-04 6.1926084679667D-04 4.2979313006454D-04 2.7490200663692D-04\n', ' 1.5453595447388D-04 6.8638412617807D-05 1.7148218015763D-05 2.6046745821324D-15\n', '    1\n', 'Au79 POTENTIAL                      exc: Vosko,Wilk,Nusair       #serial: kkrimp_v1.2-26-g84cbc08_serial_20180502163421                                             \n', '   2.38779078000000        4.82381975000676        2.38779078000000     \n', '  29.00000\n', '   3.41096   0.6285993399   0.7168465117\n', '484\n', ' 0.25000000D-01 0.39783834D-03\n', ' 5 1\n', '    0  -6.48338926687D+02\n', '    0  -7.71318775307D+01\n', '    0  -7.57179639043D+00\n', '    1  -6.65450234120D+01\n', '    1  -4.47233316155D+00\n', '  484  199   25    1\n', ' 2.1759441523018D+02 2.1819475080749D+02 2.1881026236697D+02 2.1917688185765D+02\n', ' 2.1944135872046D+02 2.1965147406096D+02 2.1982711562857D+02 2.1997904825423D+02\n', ' 2.2011373491322D+02 2.2023534840148D+02 2.2034673451484D+02 2.2044992337168D+02\n', ' 2.2054641278738D+02 2.2063734116153D+02 2.2072359294082D+02 2.2080587063205D+02\n', ' 2.2088474038225D+02 2.2096066680867D+02 2.2103403469802D+02 2.2110516797233D+02\n', ' 2.2117434060218D+02 2.2124178803200D+02 2.2130771274044D+02 2.2137229176865D+02\n', ' 2.2143567942083D+02 2.2149801263952D+02 2.2155941208437D+02 2.2161998625148D+02\n', ' 2.2167983158616D+02 2.2173903583539D+02 2.2179767756105D+02 2.2185582900557D+02\n', ' 2.2191355521989D+02 2.2197091660943D+02 2.2202796780683D+02 2.2208476000181D+02\n', ' 2.2214133963982D+02 2.2219775058279D+02 2.2225402975912D+02 2.2231022136274D+02\n', ' 2.2236635669203D+02 2.2242246888432D+02 2.2247858808059D+02 2.2253474336281D+02\n', ' 2.2259096113770D+02 2.2264726703007D+02 2.2270368423197D+02 2.2276023536191D+02\n', ' 2.2281694078753D+02 2.2287382045783D+02 2.2293089220513D+02 2.2298817355560D+02\n', ' 2.2304568001469D+02 2.2310342685981D+02 2.2316142741226D+02 2.2321969481495D+02\n', ' 2.2327824029306D+02 2.2333707491898D+02 2.2339620786334D+02 2.2345564814863D+02\n', ' 2.2351540289195D+02 2.2357547904851D+02 2.2363588164683D+02 2.2369661552312D+02\n', ' 2.2375768354952D+02 2.2381908836002D+02 2.2388083057214D+02 2.2394291050486D+02\n', ' 2.2400532639407D+02 2.2406807610284D+02 2.2413115533076D+02 2.2419455931677D+02\n', ' 2.2425828104263D+02 2.2432231292836D+02 2.2438664502980D+02 2.2445126672689D+02\n', ' 2.2451616491525D+02 2.2458132568737D+02 2.2464673251819D+02 2.2471236793925D+02\n', ' 2.2477821171821D+02 2.2484424252598D+02 2.2491043611020D+02 2.2497676695536D+02\n', ' 2.2504320645021D+02 2.2510972454100D+02 2.2517628789281D+02 2.2524286153598D+02\n', ' 2.2530940702151D+02 2.2537588406077D+02 2.2544224867516D+02 2.2550845482934D+02\n', ' 2.2557445257532D+02 2.2564018967957D+02 2.2570560976184D+02 2.2577065391661D+02\n', ' 2.2583525884706D+02 2.2589935848143D+02 2.2596288210274D+02 2.2602575596069D+02\n', ' 2.2608790139794D+02 2.2614923645843D+02 2.2620967401113D+02 2.2626912335583D+02\n', ' 2.2632748834555D+02 2.2638466899108D+02 2.2644055958332D+02 2.2649505029826D+02\n', ' 2.2654802532084D+02 2.2659936445204D+02 2.2664894123635D+02 2.2669662457302D+02\n', ' 2.2674227684927D+02 2.2678575555820D+02 2.2682691144031D+02 2.2686559011074D+02\n', ' 2.2690163021207D+02 2.2693486505395D+02 2.2696512078041D+02 2.2699221802546D+02\n', ' 2.2701597009844D+02 2.2703618465942D+02 2.2705266192667D+02 2.2706519637601D+02\n', ' 2.2707357497470D+02 2.2707757890935D+02 2.2707698185094D+02 2.2707155171610D+02\n', ' 2.2706104896829D+02 2.2704522841746D+02 2.2702383756273D+02 2.2699661843578D+02\n', ' 2.2696330599018D+02 2.2692362999416D+02 2.2687731347199D+02 2.2682407465138D+02\n', ' 2.2676362546233D+02 2.2669567354433D+02 2.2661992080788D+02 2.2653606550624D+02\n', ' 2.2644380086416D+02 2.2634281721860D+02 2.2623280071839D+02 2.2611343553747D+02\n', ' 2.2598440264831D+02 2.2584538210983D+02 2.2569605191624D+02 2.2553609036033D+02\n', ' 2.2536517495753D+02 2.2518298488347D+02 2.2498919997095D+02 2.2478350321820D+02\n', ' 2.2456557985406D+02 2.2433511991062D+02 2.2409181734871D+02 2.2383537268551D+02\n', ' 2.2356549216892D+02 2.2328189044697D+02 2.2298428977590D+02 2.2267242271386D+02\n', ' 2.2234603134313D+02 2.2200486996628D+02 2.2164870431818D+02 2.2127731423789D+02\n', ' 2.2089049284115D+02 2.2048804913638D+02 2.2006980712346D+02 2.1963560831698D+02\n', ' 2.1918531073229D+02 2.1871879127478D+02 2.1823594456974D+02 2.1773668517224D+02\n', ' 2.1722094619394D+02 2.1668868128549D+02 2.1613986301135D+02 2.1557448455546D+02\n', ' 2.1499255779521D+02 2.1439411468270D+02 2.1377920497221D+02 2.1314789723332D+02\n', ' 2.1250027619725D+02 2.1183644336767D+02 2.1115651395458D+02 2.1046061707360D+02\n', ' 2.0974889226369D+02 2.0902148927988D+02 2.0827856422167D+02 2.0752027896405D+02\n', ' 2.0674679696385D+02 2.0595828242230D+02 2.0515489589207D+02 2.0433679332716D+02\n', ' 2.0350412168286D+02 2.0265701808451D+02 2.0179560569314D+02 2.0091999330777D+02\n', ' 2.0003027185237D+02 1.9912651480393D+02 1.9820877572179D+02 1.9727708993976D+02\n', ' 1.9633147357549D+02 1.9537192689963D+02 1.9439843518391D+02 1.9341097401488D+02\n', ' 1.9240951211535D+02 1.9139401856057D+02 1.9036446731065D+02 1.8932084581000D+02\n', ' 1.8826316043091D+02 1.8719144537215D+02 1.8610576766875D+02 1.8500623483927D+02\n', ' 1.8389299779457D+02 1.8276625556894D+02 1.8162625460712D+02 1.8047328935068D+02\n', ' 1.7930769710463D+02 1.7812985421877D+02 1.7694016687230D+02 1.7573906378954D+02\n', ' 1.7452698442329D+02 1.7330437011236D+02 1.7207165184218D+02 1.7082924211730D+02\n', ' 1.6957752449241D+02 1.6831684811908D+02 1.6704752065437D+02 1.6576980666216D+02\n', ' 1.6448392462256D+02 1.6319004946297D+02 1.6188831353540D+02 1.6057881279725D+02\n', ' 1.5926161100051D+02 1.5793674856361D+02 1.5660424888072D+02 1.5526412871965D+02\n', ' 1.5391640546331D+02 1.5256110786239D+02 1.5119828308337D+02 1.4982800675653D+02\n', ' 1.4845038885273D+02 1.4706558213293D+02 1.4567378605828D+02 1.4427525294929D+02\n', ' 1.4287028932369D+02 1.4145925926420D+02 1.4004258279085D+02 1.3862073614347D+02\n', ' 1.3719424700385D+02 1.3576369162357D+02 1.3432968693227D+02 1.3289288468655D+02\n', ' 1.3145396079032D+02 1.3001360691002D+02 1.2857251763317D+02 1.2713138037871D+02\n', ' 1.2569086142608D+02 1.2425159540122D+02 1.2281417173331D+02 1.2137912557852D+02\n', ' 1.1994692688890D+02 1.1851797527414D+02 1.1709259444901D+02 1.1567103394857D+02\n', ' 1.1425347180428D+02 1.1284002556180D+02 1.1143076476784D+02 1.1002573143287D+02\n', ' 1.0862496043142D+02 1.0722850498972D+02 1.0583645789064D+02 1.0444897255032D+02\n', ' 1.0306627428575D+02 1.0168866657234D+02 1.0031652427665D+02 9.8950281127418D+01\n', ' 9.7590406184439D+01 9.6237379029633D+01 9.4891660040693D+01 9.3553665915330D+01\n', ' 9.2223746126658D+01 9.0902168979057D+01 8.9589111068815D+01 8.8284656983767D+01\n', ' 8.6988801550291D+01 8.5701460415778D+01 8.4422480887691D+01 8.3151658323652D+01\n', ' 8.1888750473850D+01 8.0633495385457D+01 7.9385625282129D+01 7.8144882784920D+01\n', ' 7.6911032077137D+01 7.5683871738704D+01 7.4463242102894D+01 7.3249034060800D+01\n', ' 7.2041192378577D+01 7.0839720566258D+01 6.9644680414675D+01 6.8456193396922D+01\n', ' 6.7274437050446D+01 6.6099643600619D+01 6.4932093946760D+01 6.3772114300483D+01\n', ' 6.2620068580670D+01 6.1476353863538D+01 6.0341391959896D+01 5.9215624411872D+01\n', ' 5.8099503938492D+01 5.6993489606260D+01 5.5898038705416D+01 5.4813602586280D+01\n', ' 5.3740619385786D+01 5.2679510875173D+01 5.1630676309954D+01 5.0594490491132D+01\n', ' 4.9571298874009D+01 4.8561416915304D+01 4.7565126455961D+01 4.6582676317038D+01\n', ' 4.5614279873548D+01 4.4660116775388D+01 4.3720331553926D+01 4.2795036279569D+01\n', ' 4.1884309987830D+01 4.0988202039162D+01 4.0106732113322D+01 3.9239894006939D+01\n', ' 3.8387655922838D+01 3.7549964427597D+01 3.6726744759978D+01 3.5917904681538D+01\n', ' 3.5123334555116D+01 3.4342910867236D+01 3.3576495893591D+01 3.2823940758272D+01\n', ' 3.2085084606975D+01 3.1359757184135D+01 3.0647777554415D+01 2.9948956292952D+01\n', ' 2.9263093893599D+01 2.8589982740288D+01 2.7929405383598D+01 2.7281136468980D+01\n', ' 2.6644941036934D+01 2.6020576644497D+01 2.5407791424022D+01 2.4806326835651D+01\n', ' 2.4215915611159D+01 2.4217296258767D+01 2.4191046731904D+01 2.4164848486427D+01\n', ' 2.4138701355590D+01 2.4112605173538D+01 2.4086559774925D+01 2.4060564995281D+01\n', ' 2.4034620670642D+01 2.4008726637915D+01 2.3982882734504D+01 2.3982882734504D+01\n', ' 2.3906675613860D+01 2.3830803882889D+01 2.3755270199388D+01 2.3680076998294D+01\n', ' 2.3605226503155D+01 2.3530720735561D+01 2.3456561525246D+01 2.3382750518648D+01\n', ' 2.3309289187637D+01 2.3236178837123D+01 2.3163420613045D+01 2.3091015508973D+01\n', ' 2.3018964373299D+01 2.2947267915117D+01 2.2875926710692D+01 2.2804941208702D+01\n', ' 2.2734311736085D+01 2.2664038502718D+01 2.2594121606716D+01 2.2524561038594D+01\n', ' 2.2455356686233D+01 2.2386508338428D+01 2.2318015689414D+01 2.2249878342262D+01\n', ' 2.2182095812848D+01 2.2114667532977D+01 2.2047592854015D+01 2.1980871049723D+01\n', ' 2.1914501319587D+01 2.1848482791409D+01 2.1782814524361D+01 2.1717495511323D+01\n', ' 2.1652524681838D+01 2.1587900904070D+01 2.1523622987538D+01 2.1459689685094D+01\n', ' 2.1396099695303D+01 2.1332851664305D+01 2.1269944188015D+01 2.1207375813848D+01\n', ' 2.1145145042752D+01 2.1083250330811D+01 2.1021690091131D+01 2.0960462695330D+01\n', ' 2.0899566475240D+01 2.0838999724455D+01 2.0838999724455D+01 2.0784369133277D+01\n', ' 2.0729953910598D+01 2.0675774655486D+01 2.0621838286920D+01 2.0568148581249D+01\n', ' 2.0514707564816D+01 2.0461516538311D+01 2.0408576050509D+01 2.0355886396845D+01\n', ' 2.0303447422545D+01 2.0251258880712D+01 2.0199320209886D+01 2.0147630826017D+01\n', ' 2.0096189906317D+01 2.0044996639297D+01 1.9994050023121D+01 1.9943349084747D+01\n', ' 1.9892892694780D+01 1.9842679761646D+01 1.9792709062837D+01 1.9742979418059D+01\n', ' 1.9693489535798D+01 1.9644238168818D+01 1.9644238168818D+01 1.9586732831135D+01\n', ' 1.9529564617155D+01 1.9472730933061D+01 1.9416229183758D+01 1.9360056775947D+01\n', ' 1.9304211120650D+01 1.9248689635626D+01 1.9193489747205D+01 1.9138608892343D+01\n', ' 1.9084044520022D+01 1.9029794092749D+01 1.8975855087751D+01 1.8922224998121D+01\n', ' 1.8868901333744D+01 1.8815881622200D+01 1.8763163409466D+01 1.8710744260619D+01\n', ' 1.8658621760360D+01 1.8606793513556D+01 1.8555257145615D+01 1.8504010302886D+01\n', ' 1.8453050652931D+01 1.8402375884796D+01 1.8351983709191D+01 1.8301871858667D+01\n', ' 1.8252038087713D+01 1.8202480172859D+01 1.8153195912700D+01 1.8104183127933D+01\n', ' 1.8055439661332D+01 1.8006963377757D+01 1.7958752163964D+01 1.7910803928716D+01\n', ' 1.7863116602558D+01 1.7815688137736D+01 1.7768516508073D+01 1.7721599708819D+01\n', ' 1.7674935756496D+01 1.7628522688739D+01 1.7582358564107D+01 1.7536441461910D+01\n', ' 1.7490769482005D+01 1.7445340744607D+01 1.7400153390072D+01 1.7355205578690D+01\n', ' 1.7310495490469D+01 1.7266021324917D+01 1.7221781300811D+01 1.7177773655981D+01\n', ' 1.7133996647068D+01 1.7090448549313D+01 1.7047127656308D+01 1.7004032279769D+01\n', '   21\n', ' 4.5631185736868D-03 4.8455663362266D-03 5.1159600173099D-03 5.3708921417927D-03\n', ' 5.6075886763412D-03 5.8238548047410D-03 6.0180472784632D-03 6.1890227043064D-03\n', ' 6.3361036236968D-03 6.4590300478123D-03 6.5579298124462D-03 6.6332790365093D-03\n', ' 6.6858797575958D-03 6.7168295859529D-03 6.7275066971080D-03 6.7195472954536D-03\n', ' 6.6948369428276D-03 6.6554941833194D-03 6.6038674821808D-03 6.5425236106301D-03\n', ' 6.4742499384389D-03 6.4020465411450D-03 6.3291340276284D-03 6.2589485818475D-03\n', ' 6.1951558050871D-03 6.1416479842603D-03 6.1025645686054D-03 6.0822908679790D-03\n', ' 6.0854857847725D-03 6.1170809172425D-03 6.1823160731308D-03 6.2867374439888D-03\n', ' 6.4362413203186D-03 6.6370697292084D-03 6.8958628081478D-03 7.2196502766620D-03\n', ' 7.6159133800401D-03 8.0925711500735D-03 8.6580541065516D-03 9.3212859221462D-03\n', ' 1.0091773626139D-02 1.0979588436847D-02 1.1995481283925D-02 1.3150871161936D-02\n', ' 1.4457999896501D-02 1.5929941343732D-02 1.7580813806416D-02 1.9425826411500D-02\n', ' 2.1481568751477D-02 2.3766108945038D-02 2.6299375693618D-02 2.9103314562877D-02\n', ' 3.2202368295384D-02 3.5623686185302D-02 3.9397698847110D-02 4.3558366096532D-02\n', ' 4.8143839065144D-02 5.3196730247653D-02 5.8764862808189D-02 6.4901552938390D-02\n', ' 7.1666461670902D-02 7.9125890899519D-02 8.7353766343464D-02 9.6431958094136D-02\n', ' 1.0645144868738D-01 1.0647094766716D-01 1.0694382759541D-01 1.0741828061875D-01\n', ' 1.0789431041242D-01 1.0837192065193D-01 1.0885111501964D-01 1.0933189719805D-01\n', ' 1.0981427087652D-01 1.1029823974448D-01 1.1078380749831D-01 1.1078380749831D-01\n', ' 1.0965100412745D-01 1.0878913065205D-01 1.0816936846958D-01 1.0776463239111D-01\n', ' 1.0754947352182D-01 1.0749999254724D-01 1.0759375617578D-01 1.0780972185061D-01\n', ' 1.0812816504281D-01 1.0853061312639D-01 1.0899978143072D-01 1.0951951454597D-01\n', ' 1.1007472954040D-01 1.1065136336890D-01 1.1123632202437D-01 1.1181743303543D-01\n', ' 1.1238339960534D-01 1.1292375742295D-01 1.1342883305406D-01 1.1388970447095D-01\n', ' 1.1429816312283D-01 1.1464667772275D-01 1.1492835955676D-01 1.1513692915678D-01\n', ' 1.1526668449229D-01 1.1531247025282D-01 1.1526964863185D-01 1.1513407098453D-01\n', ' 1.1490205097570D-01 1.1457033842125D-01 1.1413609460339D-01 1.1359686813787D-01\n', ' 1.1295057228817D-01 1.1219546272335D-01 1.1133011668993D-01 1.1035341253131D-01\n', ' 1.0926451059042D-01 1.0806283438610D-01 1.0674805312657D-01 1.0532006444117D-01\n', ' 1.0377897840325D-01 1.0212510171748D-01 1.0035892315533D-01 9.8481099105981D-02\n', ' 9.6492440338358D-02 9.4393898826295D-02 9.4393898826295D-02 9.2512406479178D-02\n', ' 9.0652776839737D-02 8.8795058961372D-02 8.6935963893825D-02 8.5076227849844D-02\n', ' 8.3217233714723D-02 8.1361514020148D-02 7.9511238453835D-02 7.7669245609439D-02\n', ' 7.5837794785204D-02 7.4019662001588D-02 7.2216991283701D-02 7.0432374807191D-02\n', ' 6.8667771612168D-02 6.6925548388591D-02 6.5207458142096D-02 6.3515631968649D-02\n', ' 6.1851616283162D-02 6.0217310617425D-02 5.8614063675610D-02 5.7043554228543D-02\n', ' 5.5506946624279D-02 5.4005712950990D-02 5.4005712950990D-02 5.2263701553498D-02\n', ' 5.0522250609553D-02 4.8784703007433D-02 4.7054173322214D-02 4.5333560742609D-02\n', ' 4.3625560612020D-02 4.1932676411297D-02 4.0257230437509D-02 3.8601374811831D-02\n', ' 3.6967101275677D-02 3.5356251235472D-02 3.3770524686946D-02 3.2211489325467D-02\n', ' 3.0680588630065D-02 2.9179150081660D-02 2.7708392448902D-02 2.6269433166237D-02\n', ' 2.4863294869415D-02 2.3490911989458D-02 2.2153136589684D-02 2.0850744233991D-02\n', ' 1.9584439178478D-02 1.8354859571834D-02 1.7162582054943D-02 1.6008126350437D-02\n', ' 1.4891959321885D-02 1.3814499007653D-02 1.2776118189285D-02 1.1777147922230D-02\n', ' 1.0817880660538D-02 9.8985733340674D-03 9.0194500737241D-03 8.1807048815652D-03\n', ' 7.3825039976557D-03 6.6249882066245D-03 5.9082748841140D-03 5.2324599794618D-03\n', ' 4.5976197771954D-03 4.0038125923158D-03 3.4510802789501D-03 2.9394496719152D-03\n', ' 2.4689338717326D-03 2.0395334629405D-03 1.6512376021161D-03 1.3040250406330D-03\n', ' 9.9786503966239D-04 7.3271822238026D-04 5.0853733760166D-04 3.2526796395246D-04\n', ' 1.8284914146876D-04 8.1213948028722D-05 2.0290016197226D-05 3.3281651140516D-15\n', '   25\n', ' 3.8565390773813D-03 4.0952510056308D-03 4.3237753756491D-03 4.5392323453237D-03\n', ' 4.7392774285767D-03 4.9220556671475D-03 5.0861782625495D-03 5.2306788711552D-03\n', ' 5.3549849359675D-03 5.4588767263274D-03 5.5424622831991D-03 5.6061440005062D-03\n', ' 5.6505997237349D-03 5.6767571028534D-03 5.6857809087747D-03 5.6790539866015D-03\n', ' 5.6581699269439D-03 5.6249192263527D-03 5.5812867002273D-03 5.5294416661854D-03\n', ' 5.4717398816467D-03 5.4107168732190D-03 5.3490945521967D-03 5.2897770240748D-03\n', ' 5.2358622873753D-03 5.1906399249420D-03 5.1576084099117D-03 5.1404740055684D-03\n', ' 5.1431742030898D-03 5.1698769637253D-03 5.2250107332829D-03 5.3132628991476D-03\n', ' 5.4396167363262D-03 5.6093477205697D-03 5.8280677923297D-03 6.1017181489718D-03\n', ' 6.4366215967839D-03 6.8394709391776D-03 7.3173912658215D-03 7.8779244566419D-03\n', ' 8.5291054178881D-03 9.2794458825681D-03 1.0138032044624D-02 1.1114514715896D-02\n', ' 1.2219240127392D-02 1.3463257704230D-02 1.4858499590081D-02 1.6417819843296D-02\n', ' 1.8155239228553D-02 2.0086028093240D-02 2.2227029264163D-02 2.4596790129516D-02\n', ' 2.7215968577176D-02 3.0107509948619D-02 3.3297132807147D-02 3.6813538435504D-02\n', ' 4.0688970424869D-02 4.4959442906447D-02 4.9665373830875D-02 5.4851823604363D-02\n', ' 6.0569215002497D-02 6.6873583352908D-02 7.3827407291734D-02 8.1499879675057D-02\n', ' 8.9967894780152D-02 8.9984374425869D-02 9.0384030909205D-02 9.0785016900547D-02\n', ' 9.1187335506051D-02 9.1590989832078D-02 9.1995982990786D-02 9.2402318094468D-02\n', ' 9.2809998261191D-02 9.3219026609106D-02 9.3629406262214D-02 9.3629406262214D-02\n', ' 9.2672012673557D-02 9.1943596638802D-02 9.1419801993342D-02 9.1077737574588D-02\n', ' 9.0895895140750D-02 9.0854076084609D-02 9.0933320814217D-02 9.1115845123114D-02\n', ' 9.1384978741907D-02 9.1725109452037D-02 9.2121629040681D-02 9.2560883694350D-02\n', ' 9.3030126009198D-02 9.3517470542773D-02 9.4011850839240D-02 9.4502979282743D-02\n', ' 9.4981308337275D-02 9.5437994045939D-02 9.5864860864534D-02 9.6254368303401D-02\n', ' 9.6599578870901D-02 9.6894127467891D-02 9.7132192068369D-02 9.7308465553241D-02\n', ' 9.7418128827068D-02 9.7456824857432D-02 9.7420633982233D-02 9.7306049956797D-02\n', ' 9.7109957259180D-02 9.6829608982385D-02 9.6462605972107D-02 9.6006876430570D-02\n', ' 9.5460656743379D-02 9.4822472681901D-02 9.4091121799908D-02 9.3265656124648D-02\n', ' 9.2345366016333D-02 9.1329764259431D-02 9.0218571283884D-02 8.9011700570728D-02\n', ' 8.7709245148881D-02 8.6311464231079D-02 8.4818770904692D-02 8.3231719919715D-02\n', ' 8.1550996501115D-02 7.9777405213448D-02 7.9777405213448D-02 7.8187253951061D-02\n', ' 7.6615580049071D-02 7.5045521880074D-02 7.3474299773795D-02 7.1902535943550D-02\n', ' 7.0331399140765D-02 6.8763029745245D-02 6.7199261478002D-02 6.5642493388385D-02\n', ' 6.4094634931958D-02 6.2558032274248D-02 6.1034497447091D-02 5.9526221238939D-02\n', ' 5.8034859340771D-02 5.6562411970642D-02 5.5110360688809D-02 5.3680506600073D-02\n', ' 5.2274156663543D-02 5.0892916276658D-02 4.9537925302349D-02 4.8210602561068D-02\n', ' 4.6911932106489D-02 4.5643158080163D-02 4.5643158080163D-02 4.4170889735777D-02\n', ' 4.2699095061136D-02 4.1230599312422D-02 3.9768034786007D-02 3.8313851743603D-02\n', ' 3.6870328166183D-02 3.5439579881171D-02 3.4023569587845D-02 3.2624116160602D-02\n', ' 3.1242902928121D-02 2.9881486162896D-02 2.8541302623585D-02 2.7223677254557D-02\n', ' 2.5929830018273D-02 2.4660882840859D-02 2.3417865769890D-02 2.2201723209754D-02\n', ' 2.1013319445476D-02 1.9853444215347D-02 1.8722817644358D-02 1.7622095203602D-02\n', ' 1.6551872098183D-02 1.5512687662081D-02 1.4505029245866D-02 1.3529336095302D-02\n', ' 1.2586002782135D-02 1.1675382613260D-02 1.0797790646587D-02 9.9535066750428D-03\n', ' 9.1427778673996D-03 8.3658213690287D-03 7.6228266051164D-03 6.9139575373293D-03\n', ' 6.2393546641741D-03 5.5991369703535D-03 4.9934036564146D-03 4.4222358143422D-03\n', ' 3.8856979163174D-03 3.3838392475291D-03 2.9166951811619D-03 2.4842883967824D-03\n', ' 2.0866299663400D-03 1.7237203838651D-03 1.3955504849965D-03 1.1021023113631D-03\n', ' 8.4334988391467D-04 6.1925992316241D-04 4.2979249456172D-04 2.7490160366047D-04\n', ' 1.5453572988574D-04 6.8638313718914D-05 1.7148193518295D-05 2.6046694427370D-15\n', '    1\n']
        txt = open(out_pot).readlines()
        assert txt==reftxt
        
        
        
class Test_kkrimp_parser_functions():
    """ Tests for the KKRimp parser functions. """
    
    def test_parse_outfiles_full(self):
        path = 'files/kkrimp_parser/test1/'
        files = {}
        files['outfile'] = path+'out_kkrimp'
        files['out_log'] = path+'out_log.000.txt'
        files['out_pot'] = path+'out_potential'
        files['out_enersp_at'] = path+'out_energysp_per_atom_eV'
        files['out_enertot_at'] = path+'out_energytotal_per_atom_eV'
        files['out_timing'] = path+'out_timing.000.txt'
        files['kkrflex_llyfac'] = path+'out_timing.000.txt'
        files['kkrflex_angles'] = path+'out_timing.000.txt'
        files['out_spinmoms'] = path+'out_magneticmoments.txt'
        files['out_orbmoms'] = path+'out_magneticmoments.txt'
        s, m, o = kkrimp_parser_functions().parse_kkrimp_outputfile({}, files)
        print('\nsuccess?\n{}\n'.format(s))
        print('\nmessages?\n{}\n'.format(m))
        print('\nout_dict?\n{}\n'.format(o))
        ref = {'nspin': 1, 'single_particle_energies': [-444.3596464334259, -444.35964643713214, -444.35964643713214, -444.35964643713214, -444.35964643713214, -444.35964643713214, -444.35964643713214, -444.35964643713214, -444.35964643713214, -444.35964643713214, -444.35964643713214, -444.35964643713214, -444.35964643713214], 'energy_contour_group': {'epoints_weights': [[0.0, -0.0394094337777778], [0.0, -0.0630550940444444], [0.0, -0.0394094337777778], [-0.0024769822541747, 0.0], [-0.0057404630128926, 0.0], [-0.0089479779326236, 0.0], [-0.0120610679922089, 0.0], [-0.0150463937353027, 0.0], [-0.0178722499181652, 0.0], [-0.020508665764491, 0.0], [-0.0229276891406109, 0.0], [-0.0251036755825742, 0.0], [-0.0270135580801038, 0.0], [-0.0286370908964098, 0.0], [-0.0299570639079892, 0.0], [-0.0309594849201664, 0.0], [-0.0316337279339673, 0.0], [-0.0319726457580817, 0.0], [-0.0319726457580817, 0.0], [-0.0316337279339673, 0.0], [-0.0309594849201664, 0.0], [-0.0299570639079892, 0.0], [-0.0286370908964098, 0.0], [-0.0270135580801038, 0.0], [-0.0251036755825742, 0.0], [-0.0229276891406109, 0.0], [-0.020508665764491, 0.0], [-0.0178722499181652, 0.0], [-0.0150463937353027, 0.0], [-0.0120610679922089, 0.0], [-0.0089479779326236, 0.0], [-0.0057404630128926, 0.0], [-0.0024769822541747, 0.0], [-0.0279266575629318, 0.0], [-0.04448270793805, 0.0], [-0.0243618157190317, 0.0], [0.0, 0.0202677088], [0.0, 0.0202677088], [0.0, 0.0202677088], [0.0, 0.0202677088], [0.0, 0.0202677088], [0.0, 0.0202677088], [0.0, 0.0202677088]], 'emin_unit': 'Rydberg', 'emin': -0.5, 'epoints_contour': [[-0.5, 0.0251161406545832], [-0.5, 0.1114275488745601], [-0.5, 0.197738957094537], [-0.4984831014391768, 0.2228550977491202], [-0.4920252138125773, 0.2228550977491202], [-0.4804788460927884, 0.2228550977491202], [-0.4639637959265489, 0.2228550977491202], [-0.4426548073399023, 0.2228550977491202], [-0.4167776840778908, 0.2228550977491202], [-0.3866067042643217, 0.2228550977491202], [-0.3524616771279685, 0.2228550977491202], [-0.3147045433772342, 0.2228550977491202], [-0.273735535341155, 0.2228550977491202], [-0.2299889331560792, 0.2228550977491202], [-0.1839284607372149, 0.2228550977491202], [-0.1360423699231033, 0.2228550977491202], [-0.0868382647445915, 0.2228550977491202], [-0.0368377206159634, 0.2228550977491202], [0.0134292445445464, 0.2228550977491202], [0.0634297886731745, 0.2228550977491202], [0.1126338938516863, 0.2228550977491202], [0.1605199846657979, 0.2228550977491202], [0.2065804570846622, 0.2228550977491202], [0.2503270592697379, 0.2228550977491202], [0.2912960673058172, 0.2228550977491202], [0.3290532010565514, 0.2228550977491202], [0.3631982281929046, 0.2228550977491202], [0.3933692080064737, 0.2228550977491202], [0.4192463312684852, 0.2228550977491202], [0.4405553198551319, 0.2228550977491202], [0.4570703700213714, 0.2228550977491202], [0.4686167377411602, 0.2228550977491202], [0.4750746253677597, 0.2228550977491202], [0.4943938904856447, 0.2228550977491202], [0.5554567937782341, 0.2228550977491202], [0.615192526540722, 0.2228550977491202], [0.628599339928583, 0.2069368764813259], [0.628599339928583, 0.1751004339457373], [0.628599339928583, 0.1432639914101487], [0.628599339928583, 0.1114275488745601], [0.628599339928583, 0.0795911063389715], [0.628599339928583, 0.0477546638033829], [0.628599339928583, 0.0159182212677943]], 'epoints_contour_unit': 'Rydberg', 'number_of_energy_points': 43}, 'energy': -585774.7465183247, 'warnings_group': {'number_of_warnings': 0, 'warnings_list': []}, 'energy_unit': 'eV', 'charge_core_states_per_atom': [18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0], 'timings_group': {'Total running time': 8.0738000869751, 'energyloop': 7.4141001701355, 'time until scf starts': 0.102099999785423, 'gref->gmat': 0.06130000069970265, 'vpot->tmat': 2.6435999982059, 'Iteration number': 7.97079992294312, 'gonsite->density': 4.697899959981443}, 'core_states_group': {'energy_highest_lying_core_state_per_atom_unit': 'Rydberg', 'energy_highest_lying_core_state_per_atom': [-4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155, -4.47233316155], 'number_of_core_states_per_atom': [5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5], 'descr_highest_lying_core_state_per_atom': ['3p', '3p', '3p', '3p', '3p', '3p', '3p', '3p', '3p', '3p', '3p', '3p', '3p']}, 'total_energy_Ry': -43053.65012505, 'fermi_energy': 0.6285993399, 'convergence_group': {'strmix': 0.05, 'rms': 2.3716e-05, 'rms_unit': 'unitless', 'qbound': 1e-07, 'calculation_converged': False, 'nsteps_exhausted': True, 'brymix': 0.05, 'number_of_iterations_max': 1, 'number_of_iterations': 1, 'rms_per_atom': [2.8353e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05, 2.2917e-05], 'fcm': 2.0, 'rms_all_iterations': [2.3716e-05], 'total_energy_Ry_all_iterations': [-43053.65012505], 'imix': 0}, 'total_energy_Ry_unit': 'Rydberg', 'use_newsosol': False, 'total_energies_atom_unit': 'eV', 'charge_core_states_per_atom_unit': 'electron charge', 'total_energies_atom': [-350719.5210815695, -350719.52108157217, -350719.52108157217, -350719.52108157217, -350719.52108157217, -350719.52108157217, -350719.52108157217, -350719.52108157217, -350719.52108157217, -350719.52108157217, -350719.52108157217, -350719.52108157217, -350719.52108157217], 'charge_valence_states_per_atom_unit': 'electron charge', 'timings_unit': 'seconds', 'total_charge_per_atom_unit': 'electron charge', 'code_info_group': {'code_version': 'v1.2-26-g84cbc08', 'calculation_serial_number': '20180502163421', 'compile_options': 'serial'}, 'single_particle_energies_unit': 'eV', 'fermi_energy_units': 'Ry', 'charge_valence_states_per_atom': [10.999993, 10.999993, 10.999993, 10.999993, 10.999993, 10.999993, 10.999993, 10.999993, 10.999993, 10.999993, 10.999993, 10.999993, 10.999993], 'number_of_atoms_in_unit_cell': 13, 'total_charge_per_atom': [28.999993, 28.999993, 28.999993, 28.999993, 28.999993, 28.999993, 28.999993, 28.999993, 28.999993, 28.999993, 28.999993, 28.999993, 28.999993]}
        assert s
        assert m==[]
        assert o==ref
        
    def test_parse_file_errors(self):
        files = {}
        files['outfile'] = 'no_file_there'
        files['out_log'] = 'no_file_there'
        files['out_pot'] = 'no_file_there'
        files['out_enersp_at'] = 'no_file_there'
        files['out_enertot_at'] = 'no_file_there'
        files['out_timing'] = 'no_file_there'
        files['kkrflex_llyfac'] = 'no_file_there'
        files['kkrflex_angles'] = 'no_file_there'
        files['out_spinmoms'] = 'no_file_there'
        files['out_orbmoms'] = 'no_file_there'
        s, m, o = kkrimp_parser_functions().parse_kkrimp_outputfile({}, files)
        print('\nsuccess?\n{}\n'.format(s))
        print('\nmessages?\n{}\n'.format(m))
        print('\nout_dict?\n{}\n'.format(o))
        assert (not s)
        assert m==['Error parsing output of KKRimp: Version Info', 'Error parsing output of KKRimp: rms-error', 'Error parsing output of KKRimp: nspin/natom', 'Error parsing output of KKRimp: spin moment per atom', 'Error parsing output of KKRimp: orbital moment', 'Error parsing output of KKRimp: EF', 'Error parsing output of KKRimp: total energy', 'Error parsing output of KKRimp: search for warnings', 'Error parsing output of KKRimp: timings', 'Error parsing output of KKRimp: single particle energies', 'Error parsing output of KKRimp: charges', 'Error parsing output of KKRimp: energy contour', 'Error parsing output of KKRimp: core_states', 'Error parsing output of KKRimp: scfinfo']
        assert o=={'convergence_group': {}}
