# coding: utf-8

"""
    Portainer API

    Portainer API is an HTTP API served by Portainer. It is used by the Portainer UI and everything you can do with the UI can be done using the HTTP API. Examples are available at https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8 You can find out more about Portainer at [http://portainer.io](http://portainer.io) and get some support on [Slack](http://portainer.io/slack/).  # Authentication  Most of the API endpoints require to be authenticated as well as some level of authorization to be used. Portainer API uses JSON Web Token to manage authentication and thus requires you to provide a token in the **Authorization** header of each request with the **Bearer** authentication mechanism.  Example: ``` Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MSwidXNlcm5hbWUiOiJhZG1pbiIsInJvbGUiOjEsImV4cCI6MTQ5OTM3NjE1NH0.NJ6vE8FY1WG6jsRQzfMqeatJ4vh2TWAeeYfDhP71YEE ```  # Security  Each API endpoint has an associated access policy, it is documented in the description of each endpoint.  Different access policies are available: * Public access * Authenticated access * Restricted access * Administrator access  ### Public access  No authentication is required to access the endpoints with this access policy.  ### Authenticated access  Authentication is required to access the endpoints with this access policy.  ### Restricted access  Authentication is required to access the endpoints with this access policy. Extra-checks might be added to ensure access to the resource is granted. Returned data might also be filtered.  ### Administrator access  Authentication as well as an administrator role are required to access the endpoints with this access policy.  # Execute Docker requests  Portainer **DO NOT** expose specific endpoints to manage your Docker resources (create a container, remove a volume, etc...).  Instead, it acts as a reverse-proxy to the Docker HTTP API. This means that you can execute Docker requests **via** the Portainer HTTP API.  To do so, you can use the `/endpoints/{id}/docker` Portainer API endpoint (which is not documented below due to Swagger limitations). This endpoint has a restricted access policy so you still need to be authenticated to be able to query this endpoint. Any query on this endpoint will be proxied to the Docker API of the associated endpoint (requests and responses objects are the same as documented in the Docker API).  **NOTE**: You can find more information on how to query the Docker API in the [Docker official documentation](https://docs.docker.com/engine/api/v1.30/) as well as in [this Portainer example](https://gist.github.com/deviantony/77026d402366b4b43fa5918d41bc42f8).   # noqa: E501

    OpenAPI spec version: 1.22.1
    Contact: info@portainer.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from portainer_api.api_client import ApiClient


class EndpointsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def endpoint_create(self, name, endpoint_type, **kwargs):  # noqa: E501
        """Create a new endpoint  # noqa: E501

        Create a new endpoint that will be used to manage a Docker environment. **Access policy**: administrator   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_create(name, endpoint_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name that will be used to identify this endpoint (example: my-endpoint) (required)
        :param int endpoint_type: Environment type. Value must be one of: 1 (Docker environment), 2 (Agent environment), 3 (Azure environment) or 4 (Edge agent environment) (required)
        :param str url: URL or IP address of a Docker host (example: docker.mydomain.tld:2375). Defaults to local if not specified (Linux: /var/run/docker.sock, Windows: //./pipe/docker_engine)
        :param str public_url: URL or IP address where exposed containers will be reachable. Defaults to URL if not specified (example: docker.mydomain.tld:2375)
        :param str group_id: Endpoint group identifier. If not specified will default to 1 (unassigned).
        :param str tls: Require TLS to connect against this endpoint (example: true)
        :param str tls_skip_verify: Skip server verification when using TLS (example: false)
        :param str tls_skip_client_verify: Skip client verification when using TLS (example: false)
        :param file tlsca_cert_file: TLS CA certificate file
        :param file tls_cert_file: TLS client certificate file
        :param file tls_key_file: TLS client key file
        :param str azure_application_id: Azure application ID. Required if endpoint type is set to 3
        :param str azure_tenant_id: Azure tenant ID. Required if endpoint type is set to 3
        :param str azure_authentication_key: Azure authentication key. Required if endpoint type is set to 3
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.endpoint_create_with_http_info(name, endpoint_type, **kwargs)  # noqa: E501
        else:
            (data) = self.endpoint_create_with_http_info(name, endpoint_type, **kwargs)  # noqa: E501
            return data

    def endpoint_create_with_http_info(self, name, endpoint_type, **kwargs):  # noqa: E501
        """Create a new endpoint  # noqa: E501

        Create a new endpoint that will be used to manage a Docker environment. **Access policy**: administrator   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_create_with_http_info(name, endpoint_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name that will be used to identify this endpoint (example: my-endpoint) (required)
        :param int endpoint_type: Environment type. Value must be one of: 1 (Docker environment), 2 (Agent environment), 3 (Azure environment) or 4 (Edge agent environment) (required)
        :param str url: URL or IP address of a Docker host (example: docker.mydomain.tld:2375). Defaults to local if not specified (Linux: /var/run/docker.sock, Windows: //./pipe/docker_engine)
        :param str public_url: URL or IP address where exposed containers will be reachable. Defaults to URL if not specified (example: docker.mydomain.tld:2375)
        :param str group_id: Endpoint group identifier. If not specified will default to 1 (unassigned).
        :param str tls: Require TLS to connect against this endpoint (example: true)
        :param str tls_skip_verify: Skip server verification when using TLS (example: false)
        :param str tls_skip_client_verify: Skip client verification when using TLS (example: false)
        :param file tlsca_cert_file: TLS CA certificate file
        :param file tls_cert_file: TLS client certificate file
        :param file tls_key_file: TLS client key file
        :param str azure_application_id: Azure application ID. Required if endpoint type is set to 3
        :param str azure_tenant_id: Azure tenant ID. Required if endpoint type is set to 3
        :param str azure_authentication_key: Azure authentication key. Required if endpoint type is set to 3
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'endpoint_type', 'url', 'public_url', 'group_id', 'tls', 'tls_skip_verify', 'tls_skip_client_verify', 'tlsca_cert_file', 'tls_cert_file', 'tls_key_file', 'azure_application_id', 'azure_tenant_id', 'azure_authentication_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method endpoint_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `endpoint_create`")  # noqa: E501
        # verify the required parameter 'endpoint_type' is set
        if ('endpoint_type' not in params or
                params['endpoint_type'] is None):
            raise ValueError("Missing the required parameter `endpoint_type` when calling `endpoint_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('Name', params['name']))  # noqa: E501
        if 'endpoint_type' in params:
            form_params.append(('EndpointCreationType', params['endpoint_type']))  # noqa: E501
        if 'url' in params:
            form_params.append(('URL', params['url']))  # noqa: E501
        if 'public_url' in params:
            form_params.append(('PublicURL', params['public_url']))  # noqa: E501
        if 'group_id' in params:
            form_params.append(('GroupID', params['group_id']))  # noqa: E501
        if 'tls' in params:
            form_params.append(('TLS', params['tls']))  # noqa: E501
        if 'tls_skip_verify' in params:
            form_params.append(('TLSSkipVerify', params['tls_skip_verify']))  # noqa: E501
        if 'tls_skip_client_verify' in params:
            form_params.append(('TLSSkipClientVerify', params['tls_skip_client_verify']))  # noqa: E501
        if 'tlsca_cert_file' in params:
            local_var_files['TLSCACertFile'] = params['tlsca_cert_file']  # noqa: E501
        if 'tls_cert_file' in params:
            local_var_files['TLSCertFile'] = params['tls_cert_file']  # noqa: E501
        if 'tls_key_file' in params:
            local_var_files['TLSKeyFile'] = params['tls_key_file']  # noqa: E501
        if 'azure_application_id' in params:
            form_params.append(('AzureApplicationID', params['azure_application_id']))  # noqa: E501
        if 'azure_tenant_id' in params:
            form_params.append(('AzureTenantID', params['azure_tenant_id']))  # noqa: E501
        if 'azure_authentication_key' in params:
            form_params.append(('AzureAuthenticationKey', params['azure_authentication_key']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Endpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def endpoint_delete(self, id, **kwargs):  # noqa: E501
        """Remove an endpoint  # noqa: E501

        Remove an endpoint. **Access policy**: administrator   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Endpoint identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.endpoint_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.endpoint_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def endpoint_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Remove an endpoint  # noqa: E501

        Remove an endpoint. **Access policy**: administrator   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Endpoint identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method endpoint_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `endpoint_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def endpoint_inspect(self, id, **kwargs):  # noqa: E501
        """Inspect an endpoint  # noqa: E501

        Retrieve details abount an endpoint. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_inspect(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Endpoint identifier (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.endpoint_inspect_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.endpoint_inspect_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def endpoint_inspect_with_http_info(self, id, **kwargs):  # noqa: E501
        """Inspect an endpoint  # noqa: E501

        Retrieve details abount an endpoint. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_inspect_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Endpoint identifier (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method endpoint_inspect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `endpoint_inspect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Endpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def endpoint_job(self, id, method, node_name, body, **kwargs):  # noqa: E501
        """Execute a job on the endpoint host  # noqa: E501

        Execute a job (script) on the underlying host of the endpoint. **Access policy**: administrator   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_job(id, method, node_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Endpoint identifier (required)
        :param str method: Job execution method. Possible values: file or string. (required)
        :param str node_name: Optional. Hostname of a node when targeting a Portainer agent cluster. (required)
        :param EndpointJobRequest body: Job details. Required when method equals string. (required)
        :param str image: Container image which will be used to execute the job. Required when method equals file.
        :param file file: Job script file. Required when method equals file.
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.endpoint_job_with_http_info(id, method, node_name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.endpoint_job_with_http_info(id, method, node_name, body, **kwargs)  # noqa: E501
            return data

    def endpoint_job_with_http_info(self, id, method, node_name, body, **kwargs):  # noqa: E501
        """Execute a job on the endpoint host  # noqa: E501

        Execute a job (script) on the underlying host of the endpoint. **Access policy**: administrator   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_job_with_http_info(id, method, node_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Endpoint identifier (required)
        :param str method: Job execution method. Possible values: file or string. (required)
        :param str node_name: Optional. Hostname of a node when targeting a Portainer agent cluster. (required)
        :param EndpointJobRequest body: Job details. Required when method equals string. (required)
        :param str image: Container image which will be used to execute the job. Required when method equals file.
        :param file file: Job script file. Required when method equals file.
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'method', 'node_name', 'body', 'image', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method endpoint_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `endpoint_job`")  # noqa: E501
        # verify the required parameter 'method' is set
        if ('method' not in params or
                params['method'] is None):
            raise ValueError("Missing the required parameter `method` when calling `endpoint_job`")  # noqa: E501
        # verify the required parameter 'node_name' is set
        if ('node_name' not in params or
                params['node_name'] is None):
            raise ValueError("Missing the required parameter `node_name` when calling `endpoint_job`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `endpoint_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'method' in params:
            query_params.append(('method', params['method']))  # noqa: E501
        if 'node_name' in params:
            query_params.append(('nodeName', params['node_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image' in params:
            form_params.append(('Image', params['image']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}/job', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Endpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def endpoint_list(self, **kwargs):  # noqa: E501
        """List endpoints  # noqa: E501

        List all endpoints based on the current user authorizations. Will return all endpoints if using an administrator account otherwise it will only return authorized endpoints. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EndpointListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.endpoint_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.endpoint_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def endpoint_list_with_http_info(self, **kwargs):  # noqa: E501
        """List endpoints  # noqa: E501

        List all endpoints based on the current user authorizations. Will return all endpoints if using an administrator account otherwise it will only return authorized endpoints. **Access policy**: restricted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EndpointListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method endpoint_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EndpointListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def endpoint_update(self, id, body, **kwargs):  # noqa: E501
        """Update an endpoint  # noqa: E501

        Update an endpoint. **Access policy**: administrator   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_update(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Endpoint identifier (required)
        :param EndpointUpdateRequest body: Endpoint details (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.endpoint_update_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.endpoint_update_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def endpoint_update_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """Update an endpoint  # noqa: E501

        Update an endpoint. **Access policy**: administrator   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.endpoint_update_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Endpoint identifier (required)
        :param EndpointUpdateRequest body: Endpoint details (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method endpoint_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `endpoint_update`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `endpoint_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['jwt']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
