"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
from isolate.connections.grpc.definitions import common_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
from isolate.server.definitions import server_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class HostedMap(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENVIRONMENTS_FIELD_NUMBER: builtins.int
    MACHINE_REQUIREMENTS_FIELD_NUMBER: builtins.int
    FUNCTION_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    @property
    def environments(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        server_pb2.EnvironmentDefinition
    ]:
        """Environment definitions."""
    @property
    def machine_requirements(self) -> global___MachineRequirements:
        """Machine requirements"""
    @property
    def function(self) -> common_pb2.SerializedObject:
        """Function to run."""
    @property
    def inputs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        common_pb2.SerializedObject
    ]:
        """Inputs to the function"""
    def __init__(
        self,
        *,
        environments: collections.abc.Iterable[server_pb2.EnvironmentDefinition]
        | None = ...,
        machine_requirements: global___MachineRequirements | None = ...,
        function: common_pb2.SerializedObject | None = ...,
        inputs: collections.abc.Iterable[common_pb2.SerializedObject] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_machine_requirements",
            b"_machine_requirements",
            "function",
            b"function",
            "machine_requirements",
            b"machine_requirements",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_machine_requirements",
            b"_machine_requirements",
            "environments",
            b"environments",
            "function",
            b"function",
            "inputs",
            b"inputs",
            "machine_requirements",
            b"machine_requirements",
        ],
    ) -> None: ...
    def WhichOneof(
        self,
        oneof_group: typing_extensions.Literal[
            "_machine_requirements", b"_machine_requirements"
        ],
    ) -> typing_extensions.Literal["machine_requirements"] | None: ...

global___HostedMap = HostedMap

@typing_extensions.final
class HostedRun(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENVIRONMENTS_FIELD_NUMBER: builtins.int
    MACHINE_REQUIREMENTS_FIELD_NUMBER: builtins.int
    FUNCTION_FIELD_NUMBER: builtins.int
    SETUP_FUNC_FIELD_NUMBER: builtins.int
    @property
    def environments(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        server_pb2.EnvironmentDefinition
    ]:
        """Environment definitions."""
    @property
    def machine_requirements(self) -> global___MachineRequirements:
        """Machine requirements"""
    @property
    def function(self) -> common_pb2.SerializedObject:
        """Function to run."""
    @property
    def setup_func(self) -> common_pb2.SerializedObject:
        """Optional setup function to pass as the first argument to the function."""
    def __init__(
        self,
        *,
        environments: collections.abc.Iterable[server_pb2.EnvironmentDefinition]
        | None = ...,
        machine_requirements: global___MachineRequirements | None = ...,
        function: common_pb2.SerializedObject | None = ...,
        setup_func: common_pb2.SerializedObject | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_machine_requirements",
            b"_machine_requirements",
            "_setup_func",
            b"_setup_func",
            "function",
            b"function",
            "machine_requirements",
            b"machine_requirements",
            "setup_func",
            b"setup_func",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_machine_requirements",
            b"_machine_requirements",
            "_setup_func",
            b"_setup_func",
            "environments",
            b"environments",
            "function",
            b"function",
            "machine_requirements",
            b"machine_requirements",
            "setup_func",
            b"setup_func",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self,
        oneof_group: typing_extensions.Literal[
            "_machine_requirements", b"_machine_requirements"
        ],
    ) -> typing_extensions.Literal["machine_requirements"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_setup_func", b"_setup_func"]
    ) -> typing_extensions.Literal["setup_func"] | None: ...

global___HostedRun = HostedRun

@typing_extensions.final
class HostedRunCron(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENVIRONMENTS_FIELD_NUMBER: builtins.int
    MACHINE_REQUIREMENTS_FIELD_NUMBER: builtins.int
    FUNCTION_FIELD_NUMBER: builtins.int
    CRON_FIELD_NUMBER: builtins.int
    @property
    def environments(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        server_pb2.EnvironmentDefinition
    ]:
        """Environment definitions."""
    @property
    def machine_requirements(self) -> global___MachineRequirements:
        """Machine requirements"""
    @property
    def function(self) -> common_pb2.SerializedObject:
        """Function to run."""
    cron: builtins.str
    """cron string to represent the run schedule"""
    def __init__(
        self,
        *,
        environments: collections.abc.Iterable[server_pb2.EnvironmentDefinition]
        | None = ...,
        machine_requirements: global___MachineRequirements | None = ...,
        function: common_pb2.SerializedObject | None = ...,
        cron: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_machine_requirements",
            b"_machine_requirements",
            "function",
            b"function",
            "machine_requirements",
            b"machine_requirements",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_machine_requirements",
            b"_machine_requirements",
            "cron",
            b"cron",
            "environments",
            b"environments",
            "function",
            b"function",
            "machine_requirements",
            b"machine_requirements",
        ],
    ) -> None: ...
    def WhichOneof(
        self,
        oneof_group: typing_extensions.Literal[
            "_machine_requirements", b"_machine_requirements"
        ],
    ) -> typing_extensions.Literal["machine_requirements"] | None: ...

global___HostedRunCron = HostedRunCron

@typing_extensions.final
class CancelScheduledRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """The id of the scheduled run to cancel."""
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["run_id", b"run_id"]
    ) -> None: ...

global___CancelScheduledRunRequest = CancelScheduledRunRequest

@typing_extensions.final
class CancelScheduledRunResponse(google.protobuf.message.Message):
    """Empty. For future use."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CancelScheduledRunResponse = CancelScheduledRunResponse

@typing_extensions.final
class ListScheduledRunsRequest(google.protobuf.message.Message):
    """Empty. For future use."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListScheduledRunsRequest = ListScheduledRunsRequest

@typing_extensions.final
class ListScheduledRunActivationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """The id of the scheduled run to list activations for."""
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["run_id", b"run_id"]
    ) -> None: ...

global___ListScheduledRunActivationsRequest = ListScheduledRunActivationsRequest

@typing_extensions.final
class ListScheduledRunActivationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTIVATION_IDS_FIELD_NUMBER: builtins.int
    @property
    def activation_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The list of activations (which correspond to timestamps)"""
    def __init__(
        self,
        *,
        activation_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["activation_ids", b"activation_ids"]
    ) -> None: ...

global___ListScheduledRunActivationsResponse = ListScheduledRunActivationsResponse

@typing_extensions.final
class ListScheduledRunsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCHEDULED_RUNS_FIELD_NUMBER: builtins.int
    @property
    def scheduled_runs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ScheduleInfo
    ]: ...
    def __init__(
        self,
        *,
        scheduled_runs: collections.abc.Iterable[global___ScheduleInfo] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["scheduled_runs", b"scheduled_runs"]
    ) -> None: ...

global___ListScheduledRunsResponse = ListScheduledRunsResponse

@typing_extensions.final
class GetScheduledActivationLogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    ACTIVATION_ID_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """The id of the scheduled run to get."""
    activation_id: builtins.str
    """The id of the activation to get logs for."""
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
        activation_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "activation_id", b"activation_id", "run_id", b"run_id"
        ],
    ) -> None: ...

global___GetScheduledActivationLogsRequest = GetScheduledActivationLogsRequest

@typing_extensions.final
class GetScheduledActivationLogsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAW_LOGS_FIELD_NUMBER: builtins.int
    raw_logs: builtins.bytes
    """All the logs from this activation (the format is TBD, currently raw strings)."""
    def __init__(
        self,
        *,
        raw_logs: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["raw_logs", b"raw_logs"]
    ) -> None: ...

global___GetScheduledActivationLogsResponse = GetScheduledActivationLogsResponse

@typing_extensions.final
class CreateUserKeyRequest(google.protobuf.message.Message):
    """Empty. For future use."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CreateUserKeyRequest = CreateUserKeyRequest

@typing_extensions.final
class CreateUserKeyResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_SECRET_FIELD_NUMBER: builtins.int
    KEY_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    key_secret: builtins.str
    key_id: builtins.str
    description: builtins.str
    def __init__(
        self,
        *,
        key_secret: builtins.str = ...,
        key_id: builtins.str = ...,
        description: builtins.str | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_description", b"_description", "description", b"description"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_description",
            b"_description",
            "description",
            b"description",
            "key_id",
            b"key_id",
            "key_secret",
            b"key_secret",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_description", b"_description"]
    ) -> typing_extensions.Literal["description"] | None: ...

global___CreateUserKeyResponse = CreateUserKeyResponse

@typing_extensions.final
class ListUserKeysRequest(google.protobuf.message.Message):
    """Empty. For future use."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListUserKeysRequest = ListUserKeysRequest

@typing_extensions.final
class ListUserKeysResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_KEYS_FIELD_NUMBER: builtins.int
    @property
    def user_keys(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___UserKeyInfo
    ]: ...
    def __init__(
        self,
        *,
        user_keys: collections.abc.Iterable[global___UserKeyInfo] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["user_keys", b"user_keys"]
    ) -> None: ...

global___ListUserKeysResponse = ListUserKeysResponse

@typing_extensions.final
class RevokeUserKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["key_id", b"key_id"]
    ) -> None: ...

global___RevokeUserKeyRequest = RevokeUserKeyRequest

@typing_extensions.final
class RevokeUserKeyResponse(google.protobuf.message.Message):
    """Empty. For future use."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RevokeUserKeyResponse = RevokeUserKeyResponse

@typing_extensions.final
class UserKeyInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    key_id: builtins.str
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        key_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["created_at", b"created_at"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at", b"created_at", "key_id", b"key_id"
        ],
    ) -> None: ...

global___UserKeyInfo = UserKeyInfo

@typing_extensions.final
class ScheduleInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _State:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            ScheduleInfo._State.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SCHEDULED: ScheduleInfo._State.ValueType  # 0
        """The run has been scheduled."""
        INTERNAL_FAILURE: ScheduleInfo._State.ValueType  # 1
        """The run has failed because of isolate."""
        CANCELLED: ScheduleInfo._State.ValueType  # 2
        """The run has been cancelled."""

    class State(_State, metaclass=_StateEnumTypeWrapper): ...
    SCHEDULED: ScheduleInfo.State.ValueType  # 0
    """The run has been scheduled."""
    INTERNAL_FAILURE: ScheduleInfo.State.ValueType  # 1
    """The run has failed because of isolate."""
    CANCELLED: ScheduleInfo.State.ValueType  # 2
    """The run has been cancelled."""

    RUN_ID_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CRON_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """Unique run id / token."""
    state: global___ScheduleInfo.State.ValueType
    """The state of the run."""
    cron: builtins.str
    """Cron string to represent the run schedule."""
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
        state: global___ScheduleInfo.State.ValueType = ...,
        cron: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cron", b"cron", "run_id", b"run_id", "state", b"state"
        ],
    ) -> None: ...

global___ScheduleInfo = ScheduleInfo

@typing_extensions.final
class HostedRunResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUN_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    LOGS_FIELD_NUMBER: builtins.int
    RETURN_VALUE_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    """Unique run id / token."""
    @property
    def status(self) -> global___HostedRunStatus:
        """Optionally the status of the current run (in terms of
        fal cloud).
        """
    @property
    def logs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        common_pb2.Log
    ]:
        """The most recent logs from the run."""
    @property
    def return_value(self) -> common_pb2.SerializedObject:
        """The result of the run, if it is complete (indicated by
        status.is_complete).
        """
    def __init__(
        self,
        *,
        run_id: builtins.str = ...,
        status: global___HostedRunStatus | None = ...,
        logs: collections.abc.Iterable[common_pb2.Log] | None = ...,
        return_value: common_pb2.SerializedObject | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_return_value",
            b"_return_value",
            "_status",
            b"_status",
            "return_value",
            b"return_value",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_return_value",
            b"_return_value",
            "_status",
            b"_status",
            "logs",
            b"logs",
            "return_value",
            b"return_value",
            "run_id",
            b"run_id",
            "status",
            b"status",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_return_value", b"_return_value"]
    ) -> typing_extensions.Literal["return_value"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_status", b"_status"]
    ) -> typing_extensions.Literal["status"] | None: ...

global___HostedRunResult = HostedRunResult

@typing_extensions.final
class HostedRunStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _State:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            HostedRunStatus._State.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IN_PROGRESS: HostedRunStatus._State.ValueType  # 0
        """The run is in progress."""
        SUCCESS: HostedRunStatus._State.ValueType  # 1
        """The run has completed successfully."""
        INTERNAL_FAILURE: HostedRunStatus._State.ValueType  # 2
        """The run has failed because of isolate.
        TODO: probably QUEUED, etc.
        """

    class State(_State, metaclass=_StateEnumTypeWrapper): ...
    IN_PROGRESS: HostedRunStatus.State.ValueType  # 0
    """The run is in progress."""
    SUCCESS: HostedRunStatus.State.ValueType  # 1
    """The run has completed successfully."""
    INTERNAL_FAILURE: HostedRunStatus.State.ValueType  # 2
    """The run has failed because of isolate.
    TODO: probably QUEUED, etc.
    """

    STATE_FIELD_NUMBER: builtins.int
    state: global___HostedRunStatus.State.ValueType
    """The state of the run."""
    def __init__(
        self,
        *,
        state: global___HostedRunStatus.State.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["state", b"state"]
    ) -> None: ...

global___HostedRunStatus = HostedRunStatus

@typing_extensions.final
class MachineRequirements(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MACHINE_TYPE_FIELD_NUMBER: builtins.int
    KEEP_ALIVE_FIELD_NUMBER: builtins.int
    machine_type: builtins.str
    """Machine type. It is not an enum because we want to be able
    to dynamically add new machine types without regenerating
    both the client and the server. Validation is done at the
    server side.
    """
    keep_alive: builtins.int
    def __init__(
        self,
        *,
        machine_type: builtins.str = ...,
        keep_alive: builtins.int | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_keep_alive", b"_keep_alive", "keep_alive", b"keep_alive"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_keep_alive",
            b"_keep_alive",
            "keep_alive",
            b"keep_alive",
            "machine_type",
            b"machine_type",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_keep_alive", b"_keep_alive"]
    ) -> typing_extensions.Literal["keep_alive"] | None: ...

global___MachineRequirements = MachineRequirements

@typing_extensions.final
class WorkerStatusListRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    MACHINE_TYPE_FIELD_NUMBER: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    user_id: builtins.str
    machine_type: builtins.str
    def __init__(
        self,
        *,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        user_id: builtins.str | None = ...,
        machine_type: builtins.str | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_end_time",
            b"_end_time",
            "_machine_type",
            b"_machine_type",
            "_start_time",
            b"_start_time",
            "_user_id",
            b"_user_id",
            "end_time",
            b"end_time",
            "machine_type",
            b"machine_type",
            "start_time",
            b"start_time",
            "user_id",
            b"user_id",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_end_time",
            b"_end_time",
            "_machine_type",
            b"_machine_type",
            "_start_time",
            b"_start_time",
            "_user_id",
            b"_user_id",
            "end_time",
            b"end_time",
            "machine_type",
            b"machine_type",
            "start_time",
            b"start_time",
            "user_id",
            b"user_id",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_end_time", b"_end_time"]
    ) -> typing_extensions.Literal["end_time"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_machine_type", b"_machine_type"]
    ) -> typing_extensions.Literal["machine_type"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_start_time", b"_start_time"]
    ) -> typing_extensions.Literal["start_time"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_user_id", b"_user_id"]
    ) -> typing_extensions.Literal["user_id"] | None: ...

global___WorkerStatusListRequest = WorkerStatusListRequest

@typing_extensions.final
class WorkerStatusListResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKER_STATUS_FIELD_NUMBER: builtins.int
    @property
    def worker_status(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___WorkerStatus
    ]: ...
    def __init__(
        self,
        *,
        worker_status: collections.abc.Iterable[global___WorkerStatus] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["worker_status", b"worker_status"]
    ) -> None: ...

global___WorkerStatusListResponse = WorkerStatusListResponse

@typing_extensions.final
class WorkerStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKER_ID_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    MACHINE_TYPE_FIELD_NUMBER: builtins.int
    worker_id: builtins.str
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration: ...
    user_id: builtins.str
    machine_type: builtins.str
    def __init__(
        self,
        *,
        worker_id: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
        user_id: builtins.str = ...,
        machine_type: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "duration",
            b"duration",
            "end_time",
            b"end_time",
            "start_time",
            b"start_time",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "duration",
            b"duration",
            "end_time",
            b"end_time",
            "machine_type",
            b"machine_type",
            "start_time",
            b"start_time",
            "user_id",
            b"user_id",
            "worker_id",
            b"worker_id",
        ],
    ) -> None: ...

global___WorkerStatus = WorkerStatus
