### neatutils
A Simple Reference Utility for Getting the Abbreviation of ML Estimators,Algorithms and Awesome List

### Installation
```bash
pip install neatutils
```

### Benefits
+ Simplify finding ML estimator name for pycaret

### Why Neatutils?
+ During usage of the powerful ML library Pycaret, I noticed that it was difficult to know which abbreviation/short name can be used each ML Estimator, hence we decided to build something simple to make it easier to know the most common name/abbreviation for most Machine Learning/Data Science Algorithms and Estimators used.

### Usage
#### Get Abbreviations
+ Neatutils offers the ability to analyse sequences for more insight

```python
>>> import neatutils
>>> neatutils.get_abbrev('Logistic Regression')
>>> lr
```

#### Get Full Name of Estimators
```python
>>> import neatutils
>>> neatutils.get_fullname('lr')
'Logistic Regression'

```
#### Documentation
+ Please read the [documentation](https://github.com/Jcharis/neatutils/wiki) for more information on what neatutils does and how to use is for your needs.

#### More Features To Add
+ awesome list
+ support for more file formats



#### Acknowledgements
   + Inspired by packages like PyCaret,Awesome-hub

### NB
+ Contributions Are Welcomed
+ Notice a bug, please let us know.
+ Thanks A lot

### By
+ Jesse E.Agbe(JCharis)
+ Jesus Saves @JCharisTech
