# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ManagedLicenseArgs', 'ManagedLicense']

@pulumi.input_type
class ManagedLicenseArgs:
    def __init__(__self__, *,
                 approval_status: pulumi.Input[str],
                 project: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ManagedLicense resource.
        :param pulumi.Input[str] approval_status: Whether the license is approved or not. Only 'approved' or 'blacklisted' allowed.
        :param pulumi.Input[str] project: The ID of the project under which the managed license will be created.
        :param pulumi.Input[str] name: The name of the managed license (I.e., 'Apache License 2.0' or 'MIT license')
        """
        pulumi.set(__self__, "approval_status", approval_status)
        pulumi.set(__self__, "project", project)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="approvalStatus")
    def approval_status(self) -> pulumi.Input[str]:
        """
        Whether the license is approved or not. Only 'approved' or 'blacklisted' allowed.
        """
        return pulumi.get(self, "approval_status")

    @approval_status.setter
    def approval_status(self, value: pulumi.Input[str]):
        pulumi.set(self, "approval_status", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID of the project under which the managed license will be created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the managed license (I.e., 'Apache License 2.0' or 'MIT license')
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ManagedLicenseState:
    def __init__(__self__, *,
                 approval_status: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ManagedLicense resources.
        :param pulumi.Input[str] approval_status: Whether the license is approved or not. Only 'approved' or 'blacklisted' allowed.
        :param pulumi.Input[str] name: The name of the managed license (I.e., 'Apache License 2.0' or 'MIT license')
        :param pulumi.Input[str] project: The ID of the project under which the managed license will be created.
        """
        if approval_status is not None:
            pulumi.set(__self__, "approval_status", approval_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="approvalStatus")
    def approval_status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the license is approved or not. Only 'approved' or 'blacklisted' allowed.
        """
        return pulumi.get(self, "approval_status")

    @approval_status.setter
    def approval_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "approval_status", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the managed license (I.e., 'Apache License 2.0' or 'MIT license')
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project under which the managed license will be created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class ManagedLicense(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_status: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource allows you to add rules for managing licenses on a project.
        For additional information, please see the [gitlab documentation](https://docs.gitlab.com/ee/user/compliance/license_compliance/).

        > Using this resource requires an active [gitlab ultimate](https://about.gitlab.com/pricing/)subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        foo = gitlab.Project("foo",
            description="Lorem Ipsum",
            visibility_level="public")
        mit = gitlab.ManagedLicense("mit",
            project=foo.id,
            approval_status="approved")
        ```

        ## Import

        # You can import this resource with an id made up of `{project-id}:{license-id}`, e.g.

        ```sh
         $ pulumi import gitlab:index/managedLicense:ManagedLicense foo 1:2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] approval_status: Whether the license is approved or not. Only 'approved' or 'blacklisted' allowed.
        :param pulumi.Input[str] name: The name of the managed license (I.e., 'Apache License 2.0' or 'MIT license')
        :param pulumi.Input[str] project: The ID of the project under which the managed license will be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedLicenseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to add rules for managing licenses on a project.
        For additional information, please see the [gitlab documentation](https://docs.gitlab.com/ee/user/compliance/license_compliance/).

        > Using this resource requires an active [gitlab ultimate](https://about.gitlab.com/pricing/)subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        foo = gitlab.Project("foo",
            description="Lorem Ipsum",
            visibility_level="public")
        mit = gitlab.ManagedLicense("mit",
            project=foo.id,
            approval_status="approved")
        ```

        ## Import

        # You can import this resource with an id made up of `{project-id}:{license-id}`, e.g.

        ```sh
         $ pulumi import gitlab:index/managedLicense:ManagedLicense foo 1:2
        ```

        :param str resource_name: The name of the resource.
        :param ManagedLicenseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedLicenseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_status: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedLicenseArgs.__new__(ManagedLicenseArgs)

            if approval_status is None and not opts.urn:
                raise TypeError("Missing required property 'approval_status'")
            __props__.__dict__["approval_status"] = approval_status
            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
        super(ManagedLicense, __self__).__init__(
            'gitlab:index/managedLicense:ManagedLicense',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_status: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'ManagedLicense':
        """
        Get an existing ManagedLicense resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] approval_status: Whether the license is approved or not. Only 'approved' or 'blacklisted' allowed.
        :param pulumi.Input[str] name: The name of the managed license (I.e., 'Apache License 2.0' or 'MIT license')
        :param pulumi.Input[str] project: The ID of the project under which the managed license will be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedLicenseState.__new__(_ManagedLicenseState)

        __props__.__dict__["approval_status"] = approval_status
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return ManagedLicense(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvalStatus")
    def approval_status(self) -> pulumi.Output[str]:
        """
        Whether the license is approved or not. Only 'approved' or 'blacklisted' allowed.
        """
        return pulumi.get(self, "approval_status")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the managed license (I.e., 'Apache License 2.0' or 'MIT license')
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project under which the managed license will be created.
        """
        return pulumi.get(self, "project")

