# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TopicArgs', 'Topic']

@pulumi.input_type
class TopicArgs:
    def __init__(__self__, *,
                 soft_destroy: pulumi.Input[bool],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Topic resource.
        :param pulumi.Input[bool] soft_destroy: Empty the topics fields instead of deleting it
        :param pulumi.Input[str] description: A text describing the topic
        :param pulumi.Input[str] name: The topic's name
        """
        pulumi.set(__self__, "soft_destroy", soft_destroy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="softDestroy")
    def soft_destroy(self) -> pulumi.Input[bool]:
        """
        Empty the topics fields instead of deleting it
        """
        return pulumi.get(self, "soft_destroy")

    @soft_destroy.setter
    def soft_destroy(self, value: pulumi.Input[bool]):
        pulumi.set(self, "soft_destroy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A text describing the topic
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The topic's name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TopicState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 soft_destroy: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Topic resources.
        :param pulumi.Input[str] description: A text describing the topic
        :param pulumi.Input[str] name: The topic's name
        :param pulumi.Input[bool] soft_destroy: Empty the topics fields instead of deleting it
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if soft_destroy is not None:
            pulumi.set(__self__, "soft_destroy", soft_destroy)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A text describing the topic
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The topic's name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="softDestroy")
    def soft_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Empty the topics fields instead of deleting it
        """
        return pulumi.get(self, "soft_destroy")

    @soft_destroy.setter
    def soft_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "soft_destroy", value)


class Topic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 soft_destroy: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage topics that are then assignable to projects. Topics are the successors for project tags. Aside from avoiding terminology collisions with Git tags, they are more descriptive and better searchable.

        For assigning topics, use the project resource.

        > Deleting a resource doesn't delete the corresponding topic as the GitLab API doesn't support deleting topics yet. You can set soft_destroy to true if you want the topics description to be emptied instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        functional_programming = gitlab.Topic("functionalProgramming", description="In computer science, functional programming is a programming paradigm where programs are constructed by applying and composing functions.")
        ```

        ## Import

        ```sh
         $ pulumi import gitlab:index/topic:Topic # You can import a topic to terraform state using `<resource> <id>`.
        ```

        # The `id` must be an integer for the id of the topic you want to import, # for example

        ```sh
         $ pulumi import gitlab:index/topic:Topic functional_programming 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A text describing the topic
        :param pulumi.Input[str] name: The topic's name
        :param pulumi.Input[bool] soft_destroy: Empty the topics fields instead of deleting it
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage topics that are then assignable to projects. Topics are the successors for project tags. Aside from avoiding terminology collisions with Git tags, they are more descriptive and better searchable.

        For assigning topics, use the project resource.

        > Deleting a resource doesn't delete the corresponding topic as the GitLab API doesn't support deleting topics yet. You can set soft_destroy to true if you want the topics description to be emptied instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        functional_programming = gitlab.Topic("functionalProgramming", description="In computer science, functional programming is a programming paradigm where programs are constructed by applying and composing functions.")
        ```

        ## Import

        ```sh
         $ pulumi import gitlab:index/topic:Topic # You can import a topic to terraform state using `<resource> <id>`.
        ```

        # The `id` must be an integer for the id of the topic you want to import, # for example

        ```sh
         $ pulumi import gitlab:index/topic:Topic functional_programming 1
        ```

        :param str resource_name: The name of the resource.
        :param TopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 soft_destroy: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicArgs.__new__(TopicArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if soft_destroy is None and not opts.urn:
                raise TypeError("Missing required property 'soft_destroy'")
            __props__.__dict__["soft_destroy"] = soft_destroy
        super(Topic, __self__).__init__(
            'gitlab:index/topic:Topic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            soft_destroy: Optional[pulumi.Input[bool]] = None) -> 'Topic':
        """
        Get an existing Topic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A text describing the topic
        :param pulumi.Input[str] name: The topic's name
        :param pulumi.Input[bool] soft_destroy: Empty the topics fields instead of deleting it
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicState.__new__(_TopicState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["soft_destroy"] = soft_destroy
        return Topic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A text describing the topic
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The topic's name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="softDestroy")
    def soft_destroy(self) -> pulumi.Output[bool]:
        """
        Empty the topics fields instead of deleting it
        """
        return pulumi.get(self, "soft_destroy")

