# Copyright 2018 Donald Stufft and individual contributors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
__all__ = (
    "__title__",
    "__summary__",
    "__uri__",
    "__version__",
    "__author__",
    "__email__",
    "__license__",
    "__copyright__",
)

__copyright__ = "Copyright 2019 Donald Stufft and individual contributors"

import sys

if sys.version_info[:2] >= (3, 8):
    from importlib import metadata as importlib_metadata
else:
    # Using `as` to workaround "implicit reexport disabled"
    # https://mypy.readthedocs.io/en/stable/config_file.html#confval-implicit_reexport
    import importlib_metadata as importlib_metadata

# print(importlib_metadata.__all__)
# print(importlib_metadata.entry_points())
# for i in importlib_metadata.distributions():
#     print(dir(i))

try:
    metadata = importlib_metadata.metadata("lyptest1")
    print(metadata)
except  Exception as e:
    print(e)


__title__ = metadata["name"]
__summary__ = metadata["summary"]
__uri__ = metadata["home-page"]
__version__ = metadata["version"]
__author__ = metadata["author"]
__email__ = metadata["author-email"]
__license__ = metadata["license"]
