# Generated by Django 2.0 on 2020-10-28 17:36

from django.db import migrations


def add_maintenance_banner(apps, schema_editor):
    """
    This creates the maintenance banner dynamic element which allows us to edit and turn on and off the maintenance
    banner dynamically from the admin panel.
    """
    DynamicElement = apps.get_model("common", "DynamicElement")
    DynamicElement.objects.create(name="Maintenance banner")


def remove_maintenance_banner(apps, schema_editor):
    DynamicElement = apps.get_model("common", "DynamicElement")
    maintenance_banner = DynamicElement.objects.get(name="Maintenance banner")
    maintenance_banner.delete()


class Migration(migrations.Migration):

    dependencies = [("common", "0029_dynamicelement")]

    operations = [
        migrations.RunPython(add_maintenance_banner, remove_maintenance_banner)
    ]
