"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
class CopyOperation extends core_1.Construct {
    constructor(parent, name, props) {
        super(parent, name);
        const lambdaProvider = new lambda.SingletonFunction(this, 'Provider', {
            uuid: 'f7d4f730-4ee1-11e8-9c2d-fa7ae01bbebc',
            runtime: lambda.Runtime.PYTHON_3_7,
            code: lambda.Code.fromAsset('../copy-handler'),
            handler: 'index.handler',
            timeout: core_1.Duration.seconds(60),
        });
        new lib_1.CustomResource(this, 'Resource', {
            provider: lib_1.CustomResourceProvider.fromLambda(lambdaProvider),
            properties: {
                sourceBucketArn: props.sourceBucket.bucketArn,
                targetBucketArn: props.targetBucket.bucketArn,
            }
        });
    }
}
/// !hide
new CopyOperation(new core_1.Stack(), 'Test', {
    sourceBucket: { bucketArn: 'x' },
    targetBucket: { bucketArn: 'y' },
});
//# sourceMappingURL=data:application/json;base64,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