"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const cfn = require("../lib");
class YourNestedStack extends cfn.NestedStack {
    constructor(scope, id) {
        super(scope, id);
        new sns.Topic(this, 'YourResource');
    }
}
class MyNestedStack extends cfn.NestedStack {
    constructor(scope, id) {
        super(scope, id);
        new sns.Topic(this, 'MyResource');
        new YourNestedStack(this, 'NestedChild');
    }
}
const app = new core_1.App();
const stack = new core_1.Stack(app, 'nested-stacks-multi');
new MyNestedStack(stack, 'NestedStack');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubmVzdGVkLXN0YWNrcy1tdWx0aS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLm5lc3RlZC1zdGFja3MtbXVsdGkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx3Q0FBd0M7QUFDeEMsd0NBQXNEO0FBQ3RELDhCQUE4QjtBQUU5QixNQUFNLGVBQWdCLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFDM0MsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLGNBQWMsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7Q0FDRjtBQUVELE1BQU0sYUFBYyxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBQ3pDLFlBQVksS0FBZ0IsRUFBRSxFQUFVO1FBQ3RDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxZQUFZLENBQUMsQ0FBQztRQUVsQyxJQUFJLGVBQWUsQ0FBQyxJQUFJLEVBQUUsYUFBYSxDQUFDLENBQUM7SUFDM0MsQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxVQUFHLEVBQUUsQ0FBQztBQUN0QixNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssQ0FBQyxHQUFHLEVBQUUscUJBQXFCLENBQUMsQ0FBQztBQUNwRCxJQUFJLGFBQWEsQ0FBQyxLQUFLLEVBQUUsYUFBYSxDQUFDLENBQUM7QUFFeEMsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuaW1wb3J0IHsgQXBwLCBDb25zdHJ1Y3QsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjZm4gZnJvbSAnLi4vbGliJztcblxuY2xhc3MgWW91ck5lc3RlZFN0YWNrIGV4dGVuZHMgY2ZuLk5lc3RlZFN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBuZXcgc25zLlRvcGljKHRoaXMsICdZb3VyUmVzb3VyY2UnKTtcbiAgfVxufVxuXG5jbGFzcyBNeU5lc3RlZFN0YWNrIGV4dGVuZHMgY2ZuLk5lc3RlZFN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBuZXcgc25zLlRvcGljKHRoaXMsICdNeVJlc291cmNlJyk7XG5cbiAgICBuZXcgWW91ck5lc3RlZFN0YWNrKHRoaXMsICdOZXN0ZWRDaGlsZCcpO1xuICB9XG59XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ25lc3RlZC1zdGFja3MtbXVsdGknKTtcbm5ldyBNeU5lc3RlZFN0YWNrKHN0YWNrLCAnTmVzdGVkU3RhY2snKTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=