"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const cfn = require("../lib");
// non-nested non-parent stack consumes a resource from a nested stack
class ProducerNestedStack extends cfn.NestedStack {
    constructor(scope, id) {
        super(scope, id);
        this.topic = new sns.Topic(this, 'MyTopic');
    }
}
class ParentStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const nested = new ProducerNestedStack(this, 'Nested1');
        this.topic = nested.topic;
    }
}
class ConsumerStack extends core_1.Stack {
    constructor(scope, id, topic) {
        super(scope, id);
        new sns.Topic(this, 'ConsumerTopic', {
            displayName: `Consuming ${core_1.Fn.select(2, core_1.Fn.split('-', topic.topicName))}` // just shorten because display name is limited
        });
    }
}
const app = new core_1.App();
const parent = new ParentStack(app, 'nested-stacks-refs2-parent-with-producer');
new ConsumerStack(app, 'nested-stacks-refs2-consumer', parent.topic);
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubmVzdGVkLXN0YWNrcy1yZWZzMi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLm5lc3RlZC1zdGFja3MtcmVmczIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQkFBZ0I7QUFDaEIsd0NBQXdDO0FBQ3hDLHdDQUEwRDtBQUMxRCw4QkFBOEI7QUFFOUIsc0VBQXNFO0FBRXRFLE1BQU0sbUJBQW9CLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFHL0MsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsU0FBUyxDQUFDLENBQUM7SUFDOUMsQ0FBQztDQUNGO0FBRUQsTUFBTSxXQUFZLFNBQVEsWUFBSztJQUc3QixZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sTUFBTSxHQUFHLElBQUksbUJBQW1CLENBQUMsSUFBSSxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBQ3hELElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQztJQUM1QixDQUFDO0NBQ0Y7QUFFRCxNQUFNLGFBQWMsU0FBUSxZQUFLO0lBQy9CLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBZ0I7UUFDeEQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLGVBQWUsRUFBRTtZQUNuQyxXQUFXLEVBQUUsYUFBYSxTQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxTQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsRUFBRSxDQUFDLCtDQUErQztTQUN6SCxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFFRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sTUFBTSxHQUFHLElBQUksV0FBVyxDQUFDLEdBQUcsRUFBRSwwQ0FBMEMsQ0FBQyxDQUFDO0FBQ2hGLElBQUksYUFBYSxDQUFDLEdBQUcsRUFBRSw4QkFBOEIsRUFBRSxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7QUFDckUsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8vICFjZGstaW50ZWcgKlxuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuaW1wb3J0IHsgQXBwLCBDb25zdHJ1Y3QsIEZuLCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgY2ZuIGZyb20gJy4uL2xpYic7XG5cbi8vIG5vbi1uZXN0ZWQgbm9uLXBhcmVudCBzdGFjayBjb25zdW1lcyBhIHJlc291cmNlIGZyb20gYSBuZXN0ZWQgc3RhY2tcblxuY2xhc3MgUHJvZHVjZXJOZXN0ZWRTdGFjayBleHRlbmRzIGNmbi5OZXN0ZWRTdGFjayB7XG4gIHB1YmxpYyByZWFkb25seSB0b3BpYzogc25zLlRvcGljO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy50b3BpYyA9IG5ldyBzbnMuVG9waWModGhpcywgJ015VG9waWMnKTtcbiAgfVxufVxuXG5jbGFzcyBQYXJlbnRTdGFjayBleHRlbmRzIFN0YWNrIHtcbiAgcHVibGljIHJlYWRvbmx5IHRvcGljOiBzbnMuVG9waWM7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBuZXN0ZWQgPSBuZXcgUHJvZHVjZXJOZXN0ZWRTdGFjayh0aGlzLCAnTmVzdGVkMScpO1xuICAgIHRoaXMudG9waWMgPSBuZXN0ZWQudG9waWM7XG4gIH1cbn1cblxuY2xhc3MgQ29uc3VtZXJTdGFjayBleHRlbmRzIFN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgdG9waWM6IHNucy5Ub3BpYykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBuZXcgc25zLlRvcGljKHRoaXMsICdDb25zdW1lclRvcGljJywge1xuICAgICAgZGlzcGxheU5hbWU6IGBDb25zdW1pbmcgJHtGbi5zZWxlY3QoMiwgRm4uc3BsaXQoJy0nLCB0b3BpYy50b3BpY05hbWUpKX1gIC8vIGp1c3Qgc2hvcnRlbiBiZWNhdXNlIGRpc3BsYXkgbmFtZSBpcyBsaW1pdGVkXG4gICAgfSk7XG4gIH1cbn1cblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3QgcGFyZW50ID0gbmV3IFBhcmVudFN0YWNrKGFwcCwgJ25lc3RlZC1zdGFja3MtcmVmczItcGFyZW50LXdpdGgtcHJvZHVjZXInKTtcbm5ldyBDb25zdW1lclN0YWNrKGFwcCwgJ25lc3RlZC1zdGFja3MtcmVmczItY29uc3VtZXInLCBwYXJlbnQudG9waWMpO1xuYXBwLnN5bnRoKCk7XG4iXX0=