"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const cfn = require("../lib");
// references between siblings
class ProducerNestedStack extends cfn.NestedStack {
    constructor(scope, id) {
        super(scope, id);
        this.topic = new sns.Topic(this, 'MyTopic');
    }
}
class ConsumerNestedStack extends cfn.NestedStack {
    constructor(scope, id, topic) {
        super(scope, id);
        new sns.Topic(this, 'ConsumerTopic', {
            displayName: `Consuming ${core_1.Fn.select(2, core_1.Fn.split('-', topic.topicName))}` // just shorten because display name is limited
        });
    }
}
class ParentStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const nested = new ProducerNestedStack(this, 'Nested1');
        new ConsumerNestedStack(this, 'Nested2', nested.topic);
    }
}
const app = new core_1.App();
new ParentStack(app, 'nested-stacks-refs3-siblings');
app.synth();
//# sourceMappingURL=data:application/json;base64,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