"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const fs = require("fs");
const lib_1 = require("../lib");
class DemoResource extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new lib_1.CustomResource(this, 'Resource', {
            provider: lib_1.CustomResourceProvider.fromLambda(new lambda.SingletonFunction(this, 'Singleton', {
                uuid: 'f7d4f730-4ee1-11e8-9c2d-fa7ae01bbebc',
                // This makes the demo only work as top-level TypeScript program, but that's fine for now
                code: new lambda.InlineCode(fs.readFileSync('integ.trivial-lambda-provider.py', { encoding: 'utf-8' })),
                handler: 'index.main',
                timeout: cdk.Duration.minutes(5),
                runtime: lambda.Runtime.PYTHON_2_7,
            })),
            properties: props
        });
        this.response = resource.getAtt('Response').toString();
    }
}
/**
 * A stack that only sets up the CustomResource and shows how to get an attribute from it
 */
class SucceedingStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const resource = new DemoResource(this, 'DemoResource', {
            message: 'CustomResource says hello',
        });
        // Publish the custom resource output
        new cdk.CfnOutput(this, 'ResponseMessage', {
            description: 'The message that came back from the Custom Resource',
            value: resource.response
        });
    }
}
const app = new cdk.App();
new SucceedingStack(app, 'SucceedingStack');
app.synth();
//# sourceMappingURL=data:application/json;base64,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