magic = {
    "инверт": "invert",
    "нег": "neg",
    "поз": "pos",
    "абс": "abs",
    "сложение": "add",
    "и": "and",
    "деление": "div",
    "делост": "divmod",
    "целдел": "floordiv",
    "лсдвиг": "lshift",
    "ост": "mod",
    "умножение": "mul",
    "или": "or",
    "степень": "pow",
    "псдвиг": "rshift",
    "вычитание": "sub",
    "правдел": "truediv",
    "искл_или": "xor",
    "содержит": "contains",
    "рсложение": "radd",
    "ри": "rand",
    "рделение": "rdiv",
    "рделост": "rdivmod",
    "рцелдел": "rfloordiv",
    "рлсдвиг": "rlshift",
    "рост": "rmod",
    "румножение": "rmul",
    "рили": "ror",
    "рстепень": "rpow",
    "рпсдвиг": "rrshift",
    "рвычитание": "rsub",
    "рправдел": "rtruediv",
    "рискл_или": "rxor",
    "нмсложение": "iadd",
    "нми": "iand",
    "нмделение": "idiv",
    "нмцелдел": "ifloordiv",
    "нмлсдвиг": "ilshift",
    "нмост": "imod",
    "нмумножение": "imul",
    "нмили": "ior",
    "нмстепень": "ipow",
    "нмпсдвиг": "irshift",
    "нмвычитание": "isub",
    "нмправдел": "itruediv",
    "нмискл_или": "ixor",
    "равно": "eq",
    "болравно": "ge",
    "больше": "gt",
    "менравно": "le",
    "меньше": "lt",
    "неравно": "ne",
    "сравн": "cmp",
    "рсравн": "rcmp",
    "логический": "bool",
    "строка": "str",
    "ненулевое": "nonzero",
    "юникод": "unicode",
    "байты": "bytes",
    "комплексное": "complex",
    "нецелое": "float",
    "индекс": "index",
    "целое": "int",
    "округлить": "round",
    "длинное": "long",
    "формат": "format",
    "длина": "len",
    "подсказка_длины": "length_hint",
    "хэш": "hash",
    "представление": "repr",
    "развернутый": "reversed",
    "конвертация": "coerce",
    "шестн": "hex",
    "восьм": "oct",
    "путьфс": "fspath",
    "итер": "iter",
    "след": "next",
    "аитер": "aiter",
    "аслед": "anext",
    "ожидать": "await",
    "удалатр": "delattr",
    "удалэлем": "delitem",
    "удалсрез": "delslice",
    "полатр": "getattr",
    "полатрибут": "getattribute",
    "полэлем": "getitem",
    "полсрез": "getslice",
    "устатр": "setattr",
    "устэлем": "setitem",
    "устсрез": "setslice",
    "свойства": "dir",
    "отсутствует": "missing",
    "войти": "enter",
    "выйти": "exit",
    "авойти": "aenter",
    "авыйти": "aexit",
    "вызвать": "call",
    "удал": "del",
    "инициализация": "init",
    "новый": "new",
    "инициализация_подкласса": "init_subclass",
    "проверкаэкземпляра": "instancecheck",
    "проверкаподкласса": "subclasscheck",
    "полноваргументы": "getnewargs",
    "полноваргументы_экс": "getnewargs_ex",
    "полсостояние": "getstate",
    "устсостояние": "setstate",
    "свести": "reduce",
    "севсти_экс": "reduce_ex",
    "удалить": "delete",
    "получить": "get",
    "установить": "set",
    "установить_имя": "set_name",
    "подклассы": "subclasses",
    "после_инициализации": "post_init",
    "класс_полэлем": "class_getitem",
    "прм_записи": "mro_entries",
    "класс": "class",
    "словарь": "dict",
    "документация": "doc",
    "модуль": "module",
    "имя": "name",
    "всё": "all",
    "файл": "file",
    "пакет": "package",
    "аннотации": "annotations",
    "замыкание": "closure",
    "код": "code",
    "умолчания": "defaults",
    "функ": "func",
    "глобальные": "globals",
    "клумолчания": "kwdefaults",
    "сам": "self",
    "квалимя": "qualname",
    "базы": "bases",
    "подготовить": "prepare",
    "слоты": "slots",
    "метакласс": "metaclass",
    "прм": "mro",
}
magic = {f"__{k}__": f"__{v}__" for k, v in magic.items()}

types = {
    "строка": "str",
    "целое": "int",
    "нецелое": "float",
    "логический": "bool",
    "Многоточие": "Ellipsis",
    "срез": "slice",
    "список": "list",
    "массивбайтов": "bytearray",
    "байты": "bytes",
    "комплексное": "complex",
    "словарь": "dict",
    "морозноемножество": "frozenset",
    "память": "memoryview",
    "объект": "object",
    "множество": "set",
    "кортеж": "tuple",
}

builtin_functions = {
    "__подключить__": "__import__",
    "все": "all",
    "абс": "abs",
    "любой": "any",
    "бин": "bin",
    "вызываемое": "callable",
    "символ": "chr",
    "метод_класса": "classmethod",
    "собрать": "compile",
    "удалатр": "delattr",
    "свойства": "dir",
    "делост": "divmod",
    "пронумеровать": "enumerate",
    "вычислить": "eval",
    "фильтр": "filter",
    "формат": "format",
    "полатр": "getattr",
    "глобальные": "globals",
    "естьатр": "hasattr",
    "хэш": "hash",
    "помощь": "help",
    "шестн": "hex",
    "айди": "id",
    "ввод": "input",
    "есть_экземпляр": "isinstance",
    "есть_подкласс": "issubclass",
    "итер": "iter",
    "длина": "len",
    "местные": "locals",
    "применить": "map",
    "максимум": "max",
    "минимум": "min",
    "след": "next",
    "восьм": "oct",
    "открыть": "open",
    "код_символа": "ord",
    "степень": "pow",
    "свойство": "property",
    "диапазон": "range",
    "представление": "repr",
    "развернутый": "reversed",
    "округлить": "round",
    "устатр": "setattr",
    "сортированный": "sorted",
    "статическийметод": "staticmethod",
    "сумма": "sum",
    "вышестоящий": "super",
    "тип": "type",
    "переменные": "vars",
    "комбинировать": "zip",
    "точкаостановки": "breakpoint",
    "выполнить": "exec",
    "вывод": "print",
}

errors = {
    "ОшибкаАрифметики": "ArithmeticError",
    "ОшибкаПроверки": "AssertionError",
    "ОшибкаАтрибута": "AttributeError",
    "ОшибкаБлокирующегоВводаВывода": "BlockingIOError",
    "ОшибкаСломаннойТрубы": "BrokenPipeError",
    "ОшибкаБуфера": "BufferError",
    "ОшибкаДочернегоПроцесса": "ChildProcessError",
    "ОшибкаРазорванногоСоединения": "ConnectionError",
    "ОшибкаОтклоненногоСоединения": "ConnectionAbortedError",
    "ОшибкаСброшенногоСоединения": "ConnectionRefusedError",
    "ОшибкаСоединения": "ConnectionResetError",
    "ОшибкаКонцаФайла": "EOFError",
    "ОшибкаОкружения": "EnvironmentError",
    "ОшибкаСуществованияФайла": "FileExistsError",
    "ОшибкаНесуществующегоФайла": "FileNotFoundError",
    "ОшибкаПлавающейТочки": "FloatingPointError",
    "ОшибкаПрерывания": "InterruptedError",
    "ОшибкаВводаВывода": "IOError",
    "ОшибкаДиректории": "IsADirectoryError",
    "ОшибкаПодключения": "ImportError",
    "ОшибкаОтступов": "IndentationError",
    "ОшибкаИндекса": "IndexError",
    "ОшибкаКлюча": "KeyError",
    "ОшибкаПоиска": "LookupError",
    "ОшибкаПамяти": "MemoryError",
    "ОшибкаИмени": "NameError",
    "ОшибкаНеДиректории": "NotADirectoryError",
    "ОшибкаНереализованности": "NotImplementedError",
    "ОшибкаОС": "OSError",
    "ОшибкаПереполнения": "OverflowError",
    "ОшибкаРазрешения": "PermissionError",
    "ОшибкаПоискаПроцесса": "ProcessLookupError",
    "ОшибкаСсылки": "ReferenceError",
    "ОшибкаВыполнения": "RuntimeError",
    "ОшибкаСтандартная": "StandardError",
    "ОшибкаСинтаксиса": "SyntaxError",
    "ОшибкаСистемы": "SystemError",
    "ОшибкаТабов": "TabError",
    "ОшибкаТаймаута": "TimeoutError",
    "ОшибкаТипа": "TypeError",
    "ОшибкаНесвязаннойЛокальнойПеременной": "UnboundLocalError",
    "ОшибкаКодированияЮникода": "UnicodeError",
    "ОшибкаДекодированияЮникода": "UnicodeEncodeError",
    "ОшибкаТрансляцииЮникода": "UnicodeDecodeError",
    "ОшибкаЮникода": "UnicodeTranslateError",
    "ОшибкаЗначения": "ValueError",
    "ОшибкаVMS": "VMSError",
    "ОшибкаВиндовс": "WindowsError",
    "ОшибкаДеленияНаНоль": "ZeroDivisionError",
    "Предупреждение": "Warning",
    "ПредупреждениеОжидающегосяУстаревания": "PendingDeprecationWarning",
    "ПредупреждениеУстаревания": "DeprecationWarning",
    "ПредупреждениеРесурса": "ResourceWarning",
    "ПредупреждениеВыполнения": "RuntimeWarning",
    "ПредупреждениеСинтаксиса": "SyntaxWarning",
    "ПредупреждениеПользователя": "UserWarning",
    "ПредупреждениеБудущего": "FutureWarning",
    "ПредупреждениеПодключения": "ImportWarning",
    "ПредупреждениеЮникода": "UnicodeWarning",
    "ПредупреждениеБайтов": "BytesWarning",
    "БазовоеИсключение": "BaseException",
    "Исключение": "Exception",
    "СистемныйВыход": "SystemExit",
    "ОстановкаИнтерации": "StopIteration",
    "НеРеализовано": "NotImplemented",
    "КлавиатурноеПрерывание": "KeyboardInterrupt",
    "ВыходГенератора": "GeneratorExit",
}

methods = {
    "заменить": "replace",
    "соединить": "join",
    "элементы": "items",
    "расширить": "extend",
    "добавить": "append",
    "вставить": "insert",
    "хлопнуть": "pop",
    "есть_алфчисл": "isalnum",
    "есть_алфавитный": "isalpha",
    "есть_ascii": "isascii",
    "есть_десятичный": "isdecimal",
    "есть_цифровой": "isdigit",
    "есть_идентификатор": "isidentifier",
    "есть_числовой": "isnumeric",
    "есть_печатный": "isprintable",
    "есть_пробел": "isspace",
    "есть_заголовок": "istitle",
    "есть_верхний": "isupper",
    "есть_нижний": "islower",
    "читать": "read",
    "писать": "write",
    "начинаетсяс": "startswith",
    "заканчиваетсяна": "endswith",
    "нижний": "lower",
    "верхний": "upper",
    "индекс": "index",
    "обновить": "update",
    "ключи": "keys",
    "значения": "values",
    "разделить": "split",
    "лразделить": "lsplit",
    "празделить": "rsplit",
    "обрезать": "strip",
    "лобрезать": "lstrip",
    "побрезать": "rstrip",
    "поменятьрегистр": "swapcase",
    "как_целая_пропорция": "as_integer_ratio",
    "мнимое": "imag",
    "действительное": "real",
    "копировать": "copy",
    "очистить": "clear",
    "хлопнутьэлемент": "popitem",
    "удалить": "remove",
    "количество": "count",
    "развернуть": "reverse",
    "сортировать": "sort",
    "получить": "get"
}

other_names = {
    "сам": "self",
    "клс": "cls",
    "значение": "value",
    "ключ": "key",
    "атрибут": "attr",
    "атрибуты": "attributes",
    "токены": "tokens",
    "токен": "token",
    "код": "code",
    "описание": "description",
    "результат": "result",
    "аргумент": "arg",
    "аргументы": "args",
    "файл": "file",
    "время": "time",
    "датавремя": "datetime",
    "дата": "date",
    "данные": "data",
    "ответ": "response",
    "запрос": "request",
    "ошибка": "error",
    "имя": "name",
    "элемент": "item",
    "состояние": "state",
    "проверить": "check",
    "статус": "status",
    "текст": "text",
    "преобразовать": "transform",
    "парсить": "parse",
    "парсер": "parser",
    "приятный": "pretty",
    "дерево": "tree",
    "число": "number",
    "граница": "bound",
    "главный": "main",
    "слово": "word",
    "слова": "words",
}

translated = {
    **types,
    **magic,
    **builtin_functions,
    **methods,
    **errors,
    **other_names,
}
