import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [billingconductor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingconductor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Billingconductor extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [billingconductor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingconductor.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to associate between one and 30 accounts to a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_AssociateAccounts.html
     */
    toAssociateAccounts(): this;
    /**
     * Grants permission to associate pricing rules
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_AssociatePricingRules.html
     */
    toAssociatePricingRules(): this;
    /**
     * Grants permission to batch associate resources to a percentage custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_BatchAssociateResourcesToCustomLineItem.html
     */
    toBatchAssociateResourcesToCustomLineItem(): this;
    /**
     * Grants permission to batch disassociate resources from a percentage custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_BatchDisassociateResourcesFromCustomLineItem.html
     */
    toBatchDisassociateResourcesFromCustomLineItem(): this;
    /**
     * Grants permission to create a billing group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreateBillingGroup.html
     */
    toCreateBillingGroup(): this;
    /**
     * Grants permission to create a custom line item
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreateCustomLineItem.html
     */
    toCreateCustomLineItem(): this;
    /**
     * Grants permission to create a pricing plan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreatePricingPlan.html
     */
    toCreatePricingPlan(): this;
    /**
     * Grants permission to create a pricing rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreatePricingRule.html
     */
    toCreatePricingRule(): this;
    /**
     * Grants permission to delete a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeleteBillingGroup.html
     */
    toDeleteBillingGroup(): this;
    /**
     * Grants permission to delete a custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeleteCustomLineItem.html
     */
    toDeleteCustomLineItem(): this;
    /**
     * Grants permission to delete a pricing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeletePricingPlan.html
     */
    toDeletePricingPlan(): this;
    /**
     * Grants permission to delete a pricing rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeletePricingRule.html
     */
    toDeletePricingRule(): this;
    /**
     * Grants permission to detach between one and 30 accounts from a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DisassociateAccounts.html
     */
    toDisassociateAccounts(): this;
    /**
     * Grants permission to disassociate pricing rules
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DisassociatePricingRules.html
     */
    toDisassociatePricingRules(): this;
    /**
     * Grants permission to list the linked accounts of the payer account for the given billing period while also providing the billing group the linked accounts belong to
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListAccountAssociations.html
     */
    toListAccountAssociations(): this;
    /**
     * Grants permission to view the billing group cost report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListBillingGroupCostReports.html
     */
    toListBillingGroupCostReports(): this;
    /**
     * Grants permission to view the details of billing groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListBillingGroups.html
     */
    toListBillingGroups(): this;
    /**
     * Grants permission to view custom line item details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListCustomLineItems.html
     */
    toListCustomLineItems(): this;
    /**
     * Grants permission to view the pricing plans details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingPlans.html
     */
    toListPricingPlans(): this;
    /**
     * Grants permission to list pricing plans associated with a pricing rule
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingPlansAssociatedWithPricingRule.html
     */
    toListPricingPlansAssociatedWithPricingRule(): this;
    /**
     * Grants permission to view pricing rules details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingRules.html
     */
    toListPricingRules(): this;
    /**
     * Grants permission to list pricing rules associated to a pricing plan
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingRulesAssociatedToPricingPlan.html
     */
    toListPricingRulesAssociatedToPricingPlan(): this;
    /**
     * Grants permission to list resources associated to a percentage custom line item
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListResourcesAssociatedToCustomLineItem.html
     */
    toListResourcesAssociatedToCustomLineItem(): this;
    /**
     * Grants permission to list tags of a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsResource(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdateBillingGroup.html
     */
    toUpdateBillingGroup(): this;
    /**
     * Grants permission to update a custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdateCustomLineItem.html
     */
    toUpdateCustomLineItem(): this;
    /**
     * Grants permission to update a pricing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdatePricingPlan.html
     */
    toUpdatePricingPlan(): this;
    /**
     * Grants permission to update a pricing rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdatePricingRule.html
     */
    toUpdatePricingRule(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type billingGroup to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBillingGroup(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type pricingPlan to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPricingPlan(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type pricingRule to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPricingRule(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type customLineItem to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCustomLineItem(resourceId: string, account?: string, partition?: string): this;
}
