import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Drs extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to get associate failback client to recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toAssociateFailbackClientToRecoveryInstanceForDrs(): this;
    /**
     * Grants permission to batch create volume snapshot group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toBatchCreateVolumeSnapshotGroupForDrs(): this;
    /**
     * Grants permission to batch delete snapshot request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toBatchDeleteSnapshotRequestForDrs(): this;
    /**
     * Grants permission to create recovery instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateRecoveryInstanceForDrs(): this;
    /**
     * Grants permission to create replication configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     */
    toCreateReplicationConfigurationTemplate(): this;
    /**
     * Grants permission to create a session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateSessionForDrs(): this;
    /**
     * Grants permission to create a source server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateSourceServerForDrs(): this;
    /**
     * Grants permission to delete a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteJob.html
     */
    toDeleteJob(): this;
    /**
     * Grants permission to delete recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteRecoveryInstance.html
     */
    toDeleteRecoveryInstance(): this;
    /**
     * Grants permission to delete replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     */
    toDeleteReplicationConfigurationTemplate(): this;
    /**
     * Grants permission to delete source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteSourceServer.html
     */
    toDeleteSourceServer(): this;
    /**
     * Grants permission to describe job log items
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobLogItems.html
     */
    toDescribeJobLogItems(): this;
    /**
     * Grants permission to describe jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobs.html
     */
    toDescribeJobs(): this;
    /**
     * Grants permission to describe recovery instances
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoveryInstances.html
     */
    toDescribeRecoveryInstances(): this;
    /**
     * Grants permission to describe recovery snapshots
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoverySnapshots.html
     */
    toDescribeRecoverySnapshots(): this;
    /**
     * Grants permission to describe replication configuration template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     */
    toDescribeReplicationConfigurationTemplates(): this;
    /**
     * Grants permission to describe replication server associations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toDescribeReplicationServerAssociationsForDrs(): this;
    /**
     * Grants permission to describe snapshot requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toDescribeSnapshotRequestsForDrs(): this;
    /**
     * Grants permission to describe source servers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeSourceServers.html
     */
    toDescribeSourceServers(): this;
    /**
     * Grants permission to disconnect recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectRecoveryInstance.html
     */
    toDisconnectRecoveryInstance(): this;
    /**
     * Grants permission to disconnect source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectSourceServer.html
     */
    toDisconnectSourceServer(): this;
    /**
     * Grants permission to get agent command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentCommandForDrs(): this;
    /**
     * Grants permission to get agent confirmed resume info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentConfirmedResumeInfoForDrs(): this;
    /**
     * Grants permission to get agent installation assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentInstallationAssetsForDrs(): this;
    /**
     * Grants permission to get agent replication info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentReplicationInfoForDrs(): this;
    /**
     * Grants permission to get agent runtime configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentRuntimeConfigurationForDrs(): this;
    /**
     * Grants permission to get agent snapshot credits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentSnapshotCreditsForDrs(): this;
    /**
     * Grants permission to get channel commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetChannelCommandsForDrs(): this;
    /**
     * Grants permission to get failback command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetFailbackCommandForDrs(): this;
    /**
     * Grants permission to get failback launch requested
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetFailbackLaunchRequestedForDrs(): this;
    /**
     * Grants permission to get failback replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetFailbackReplicationConfiguration.html
     */
    toGetFailbackReplicationConfiguration(): this;
    /**
     * Grants permission to get launch configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetLaunchConfiguration.html
     */
    toGetLaunchConfiguration(): this;
    /**
     * Grants permission to get replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetReplicationConfiguration.html
     */
    toGetReplicationConfiguration(): this;
    /**
     * Grants permission to get suggested failback client device mapping
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetSuggestedFailbackClientDeviceMappingForDrs(): this;
    /**
     * Grants permission to initialize service
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_InitializeService.html
     */
    toInitializeService(): this;
    /**
     * Grants permission to issue an agent certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toIssueAgentCertificateForDrs(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to notify agent authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentAuthenticationForDrs(): this;
    /**
     * Grants permission to notify agent is connected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentConnectedForDrs(): this;
    /**
     * Grants permission to notify agent is disconnected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentDisconnectedForDrs(): this;
    /**
     * Grants permission to notify agent replication progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentReplicationProgressForDrs(): this;
    /**
     * Grants permission to notify consistency attained
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyConsistencyAttainedForDrs(): this;
    /**
     * Grants permission to notify replication server authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyReplicationServerAuthenticationForDrs(): this;
    /**
     * Grants permission to retry data replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_RetryDataReplication.html
     */
    toRetryDataReplication(): this;
    /**
     * Grants permission to send agent logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendAgentLogsForDrs(): this;
    /**
     * Grants permission to send agent metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendAgentMetricsForDrs(): this;
    /**
     * Grants permission to send channel command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendChannelCommandResultForDrs(): this;
    /**
     * Grants permission to send client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendClientLogsForDrs(): this;
    /**
     * Grants permission to send client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendClientMetricsForDrs(): this;
    /**
     * Grants permission to start failback launch
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartFailbackLaunch.html
     */
    toStartFailbackLaunch(): this;
    /**
     * Grants permission to start recovery
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - drs:CreateRecoveryInstanceForDrs
     * - drs:ListTagsForResource
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartRecovery.html
     */
    toStartRecovery(): this;
    /**
     * Grants permission to stop failback
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StopFailback.html
     */
    toStopFailback(): this;
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to terminate recovery instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TerminateRecoveryInstances.html
     */
    toTerminateRecoveryInstances(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update agent backlog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentBacklogForDrs(): this;
    /**
     * Grants permission to update agent conversion info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentConversionInfoForDrs(): this;
    /**
     * Grants permission to update agent replication info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentReplicationInfoForDrs(): this;
    /**
     * Grants permission to update agent replication process state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentReplicationProcessStateForDrs(): this;
    /**
     * Grants permission to update agent source properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentSourcePropertiesForDrs(): this;
    /**
     * Grants permission to update failback client device mapping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateFailbackClientDeviceMappingForDrs(): this;
    /**
     * Grants permission to update failback client last seen
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateFailbackClientLastSeenForDrs(): this;
    /**
     * Grants permission to update failback replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateFailbackReplicationConfiguration.html
     */
    toUpdateFailbackReplicationConfiguration(): this;
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateLaunchConfiguration.html
     */
    toUpdateLaunchConfiguration(): this;
    /**
     * Grants permission to update a replication certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateReplicationCertificateForDrs(): this;
    /**
     * Grants permission to update replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfiguration.html
     */
    toUpdateReplicationConfiguration(): this;
    /**
     * Grants permission to update replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     */
    toUpdateReplicationConfigurationTemplate(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type JobResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/failback-overview.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobResource(jobID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type RecoveryInstanceResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/recovery-instances.html
     *
     * @param recoveryInstanceID - Identifier for the recoveryInstanceID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifEC2InstanceARN()
     */
    onRecoveryInstanceResource(recoveryInstanceID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ReplicationConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SourceServerResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceServerResource(sourceServerID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the EC2 instance the request originated from
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/security_iam_authentication.html
     *
     * Applies to resource types:
     * - RecoveryInstanceResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifEC2InstanceARN(value: string | string[], operator?: Operator | string): this;
}
