"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rekognition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [rekognition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Rekognition extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [rekognition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'rekognition';
        this.accessLevelList = {
            Read: [
                'CompareFaces',
                'DescribeCollection',
                'DescribeDataset',
                'DescribeProjectVersions',
                'DescribeProjects',
                'DescribeStreamProcessor',
                'DetectCustomLabels',
                'DetectFaces',
                'DetectLabels',
                'DetectModerationLabels',
                'DetectProtectiveEquipment',
                'DetectText',
                'GetCelebrityInfo',
                'GetCelebrityRecognition',
                'GetContentModeration',
                'GetFaceDetection',
                'GetFaceSearch',
                'GetLabelDetection',
                'GetPersonTracking',
                'GetSegmentDetection',
                'GetTextDetection',
                'ListCollections',
                'ListDatasetEntries',
                'ListDatasetLabels',
                'ListFaces',
                'ListTagsForResource',
                'RecognizeCelebrities',
                'SearchFaces',
                'SearchFacesByImage'
            ],
            Write: [
                'CreateCollection',
                'CreateDataset',
                'CreateProject',
                'CreateProjectVersion',
                'CreateStreamProcessor',
                'DeleteCollection',
                'DeleteDataset',
                'DeleteFaces',
                'DeleteProject',
                'DeleteProjectVersion',
                'DeleteStreamProcessor',
                'DistributeDatasetEntries',
                'IndexFaces',
                'StartCelebrityRecognition',
                'StartContentModeration',
                'StartFaceDetection',
                'StartFaceSearch',
                'StartLabelDetection',
                'StartPersonTracking',
                'StartProjectVersion',
                'StartSegmentDetection',
                'StartStreamProcessor',
                'StartTextDetection',
                'StopProjectVersion',
                'StopStreamProcessor',
                'UpdateDatasetEntries'
            ],
            List: [
                'ListStreamProcessors'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to compare faces in the source input image with each face detected in the target input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CompareFaces.html
     */
    toCompareFaces() {
        return this.to('CompareFaces');
    }
    /**
     * Grants permission to create a collection in an AWS Region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateCollection.html
     */
    toCreateCollection() {
        return this.to('CreateCollection');
    }
    /**
     * Grants permission to create a new Amazon Rekognition Custom Labels dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateDataset.html
     */
    toCreateDataset() {
        return this.to('CreateDataset');
    }
    /**
     * Grants permission to create an Amazon Rekognition Custom Labels project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateProject.html
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to begin training a new version of a model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateProjectVersion.html
     */
    toCreateProjectVersion() {
        return this.to('CreateProjectVersion');
    }
    /**
     * Grants permission to create an Amazon Rekognition stream processor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateStreamProcessor.html
     */
    toCreateStreamProcessor() {
        return this.to('CreateStreamProcessor');
    }
    /**
     * Grants permission to delete the specified collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteCollection.html
     */
    toDeleteCollection() {
        return this.to('DeleteCollection');
    }
    /**
     * Grants permission to delete an existing Amazon Rekognition Custom Labels dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteDataset.html
     */
    toDeleteDataset() {
        return this.to('DeleteDataset');
    }
    /**
     * Grants permission to delete faces from a collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteFaces.html
     */
    toDeleteFaces() {
        return this.to('DeleteFaces');
    }
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteProject.html
     */
    toDeleteProject() {
        return this.to('DeleteProject');
    }
    /**
     * Grants permission to delete a model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteProjectVersion.html
     */
    toDeleteProjectVersion() {
        return this.to('DeleteProjectVersion');
    }
    /**
     * Grants permission to delete the specified stream processor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DeleteStreamProcessor.html
     */
    toDeleteStreamProcessor() {
        return this.to('DeleteStreamProcessor');
    }
    /**
     * Grants permission to read details about a collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeCollection.html
     */
    toDescribeCollection() {
        return this.to('DescribeCollection');
    }
    /**
     * Grants permission to describe an Amazon Rekognition Custom Labels dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeDataset.html
     */
    toDescribeDataset() {
        return this.to('DescribeDataset');
    }
    /**
     * Grants permission to list the versions of a model in an Amazon Rekognition Custom Labels project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeProjectVersions.html
     */
    toDescribeProjectVersions() {
        return this.to('DescribeProjectVersions');
    }
    /**
     * Grants permission to list Amazon Rekognition Custom Labels projects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeProjects.html
     */
    toDescribeProjects() {
        return this.to('DescribeProjects');
    }
    /**
     * Grants permission to get information about the specified stream processor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DescribeStreamProcessorh.html
     */
    toDescribeStreamProcessor() {
        return this.to('DescribeStreamProcessor');
    }
    /**
     * Grants permission to detect custom labels in a supplied image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectCustomLabels.html
     */
    toDetectCustomLabels() {
        return this.to('DetectCustomLabels');
    }
    /**
     * Grants permission to detect human faces within an image provided as input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectFaces.html
     */
    toDetectFaces() {
        return this.to('DetectFaces');
    }
    /**
     * Grants permission to detect instances of real-world labels within an image provided as input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectLabels.html
     */
    toDetectLabels() {
        return this.to('DetectLabels');
    }
    /**
     * Grants permission to detect moderation labels within the input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectModerationLabels.html
     */
    toDetectModerationLabels() {
        return this.to('DetectModerationLabels');
    }
    /**
     * Grants permission to detect Personal Protective Equipment in the input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectProtectiveEquipment.html
     */
    toDetectProtectiveEquipment() {
        return this.to('DetectProtectiveEquipment');
    }
    /**
     * Grants permission to detect text in the input image and convert it into machine-readable text
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DetectText.html
     */
    toDetectText() {
        return this.to('DetectText');
    }
    /**
     * Grants permission to distribute the entries in a training dataset across the training dataset and the test dataset for a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_DistributeDatasetEntries.html
     */
    toDistributeDatasetEntries() {
        return this.to('DistributeDatasetEntries');
    }
    /**
     * Grants permission to read the name, and additional information, of a celebrity
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetCelebrityInfo.html
     */
    toGetCelebrityInfo() {
        return this.to('GetCelebrityInfo');
    }
    /**
     * Grants permission to read the celebrity recognition results found in a stored video by an asynchronous celebrity recognition job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetCelebrityRecognition.html
     */
    toGetCelebrityRecognition() {
        return this.to('GetCelebrityRecognition');
    }
    /**
     * Grants permission to read the content moderation analysis results found in a stored video by an asynchronous content moderation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetContentModeration.html
     */
    toGetContentModeration() {
        return this.to('GetContentModeration');
    }
    /**
     * Grants permission to read the faces detection results found in a stored video by an asynchronous face detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetFaceDetection.html
     */
    toGetFaceDetection() {
        return this.to('GetFaceDetection');
    }
    /**
     * Grants permission to read the matching collection faces found in a stored video by an asynchronous face search job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetFaceSearch.html
     */
    toGetFaceSearch() {
        return this.to('GetFaceSearch');
    }
    /**
     * Grants permission to read the label detected resuls found in a stored video by an asynchronous label detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetLabelDetection.html
     */
    toGetLabelDetection() {
        return this.to('GetLabelDetection');
    }
    /**
     * Grants permission to read the list of persons detected in a stored video by an asynchronous person tracking job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetPersonTracking.html
     */
    toGetPersonTracking() {
        return this.to('GetPersonTracking');
    }
    /**
     * Grants permission to get the vdeo segments found in a stored video by an asynchronous segment detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetSegmentDetection.html
     */
    toGetSegmentDetection() {
        return this.to('GetSegmentDetection');
    }
    /**
     * Grants permission to get the text found in a stored video by an asynchronous text detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_GetTextDetection.html
     */
    toGetTextDetection() {
        return this.to('GetTextDetection');
    }
    /**
     * Grants permission to update an existing collection with faces detected in the input image
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_IndexFaces.html
     */
    toIndexFaces() {
        return this.to('IndexFaces');
    }
    /**
     * Grants permission to read the collection Id's in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListCollections.html
     */
    toListCollections() {
        return this.to('ListCollections');
    }
    /**
     * Grants permission to list the dataset entries in an existing Amazon Rekognition Custom Labels dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListDatasetEntries.html
     */
    toListDatasetEntries() {
        return this.to('ListDatasetEntries');
    }
    /**
     * Grants permission to list the labels in a dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListDatasetLabels.html
     */
    toListDatasetLabels() {
        return this.to('ListDatasetLabels');
    }
    /**
     * Grants permission to read metadata for faces in the specificed collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListFaces.html
     */
    toListFaces() {
        return this.to('ListFaces');
    }
    /**
     * Grants permission to get a list of your stream processors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListStreamProcessors.html
     */
    toListStreamProcessors() {
        return this.to('ListStreamProcessors');
    }
    /**
     * Grants permission to return a list of tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to detect celebrities in the input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_RecognizeCelebrities.html
     */
    toRecognizeCelebrities() {
        return this.to('RecognizeCelebrities');
    }
    /**
     * Grants permission to search the specificed collection for the supplied face ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_SearchFaces.html
     */
    toSearchFaces() {
        return this.to('SearchFaces');
    }
    /**
     * Grants permission to search the specificed collection for the largest face in the input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_SearchFacesByImage.html
     */
    toSearchFacesByImage() {
        return this.to('SearchFacesByImage');
    }
    /**
     * Grants permission to start the asynchronous recognition of celebrities in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartCelebrityRecognition.html
     */
    toStartCelebrityRecognition() {
        return this.to('StartCelebrityRecognition');
    }
    /**
     * Grants permission to start asynchronous detection of explicit or suggestive adult content in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartContentModeration.html
     */
    toStartContentModeration() {
        return this.to('StartContentModeration');
    }
    /**
     * Grants permission to start asynchronous detection of faces in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartFaceDetection.html
     */
    toStartFaceDetection() {
        return this.to('StartFaceDetection');
    }
    /**
     * Grants permission to start an asynchronous search for faces in a collection that match the faces of persons detected in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartFaceSearch.html
     */
    toStartFaceSearch() {
        return this.to('StartFaceSearch');
    }
    /**
     * Grants permission to start asynchronous detection of labels in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartLabelDetection.html
     */
    toStartLabelDetection() {
        return this.to('StartLabelDetection');
    }
    /**
     * Grants permission to start the asynchronous tracking of persons in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartPersonTracking.html
     */
    toStartPersonTracking() {
        return this.to('StartPersonTracking');
    }
    /**
     * Grants permission to start running a model version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartProjectVersion.html
     */
    toStartProjectVersion() {
        return this.to('StartProjectVersion');
    }
    /**
     * Grants permission to start the asynchronous detection of segments in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartSegmentDetection.html
     */
    toStartSegmentDetection() {
        return this.to('StartSegmentDetection');
    }
    /**
     * Grants permission to start running a stream processor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartStreamProcessor.html
     */
    toStartStreamProcessor() {
        return this.to('StartStreamProcessor');
    }
    /**
     * Grants permission to start the asynchronous detection of text in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StartTextDetection.html
     */
    toStartTextDetection() {
        return this.to('StartTextDetection');
    }
    /**
     * Grants permission to stop a running model version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StopProjectVersion.html
     */
    toStopProjectVersion() {
        return this.to('StopProjectVersion');
    }
    /**
     * Grants permission to stop a running stream processor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_StopStreamProcessor.html
     */
    toStopStreamProcessor() {
        return this.to('StopStreamProcessor');
    }
    /**
     * Grants permission to add one or more tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove one or more tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to add or update one or more JSON Lines (entries) in a dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_UpdateDatasetEntries.html
     */
    toUpdateDatasetEntries() {
        return this.to('UpdateDatasetEntries');
    }
    /**
     * Adds a resource of type collection to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/howitworks-collection.html
     *
     * @param collectionId - Identifier for the collectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCollection(collectionId, account, region, partition) {
        return this.on(`arn:${partition || Rekognition.defaultPartition}:rekognition:${region || '*'}:${account || '*'}:collection/${collectionId}`);
    }
    /**
     * Adds a resource of type streamprocessor to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/using-rekognition-video-stream-processor.html
     *
     * @param streamprocessorId - Identifier for the streamprocessorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onStreamprocessor(streamprocessorId, account, region, partition) {
        return this.on(`arn:${partition || Rekognition.defaultPartition}:rekognition:${region || '*'}:${account || '*'}:streamprocessor/${streamprocessorId}`);
    }
    /**
     * Adds a resource of type project to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/cp-create-project.html
     *
     * @param projectName - Identifier for the projectName.
     * @param creationTimestamp - Identifier for the creationTimestamp.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProject(projectName, creationTimestamp, account, region, partition) {
        return this.on(`arn:${partition || Rekognition.defaultPartition}:rekognition:${region || '*'}:${account || '*'}:project/${projectName}/${creationTimestamp}`);
    }
    /**
     * Adds a resource of type projectversion to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/API_CreateProjectVersion.html
     *
     * @param projectName - Identifier for the projectName.
     * @param versionName - Identifier for the versionName.
     * @param creationTimestamp - Identifier for the creationTimestamp.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProjectversion(projectName, versionName, creationTimestamp, account, region, partition) {
        return this.on(`arn:${partition || Rekognition.defaultPartition}:rekognition:${region || '*'}:${account || '*'}:project/${projectName}/version/${versionName}/${creationTimestamp}`);
    }
    /**
     * Adds a resource of type dataset to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/cd-create-dataset.html
     *
     * @param projectName - Identifier for the projectName.
     * @param datasetType - Identifier for the datasetType.
     * @param creationTimestamp - Identifier for the creationTimestamp.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDataset(projectName, datasetType, creationTimestamp, account, region, partition) {
        return this.on(`arn:${partition || Rekognition.defaultPartition}:rekognition:${region || '*'}:${account || '*'}:project/${projectName}/dataset/${datasetType}/${creationTimestamp}`);
    }
}
exports.Rekognition = Rekognition;
_a = JSII_RTTI_SYMBOL_1;
Rekognition[_a] = { fqn: "iam-floyd.Rekognition", version: "0.353.0" };
//# sourceMappingURL=data:application/json;base64,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