#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

void f_ini_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[67]*x[0] + p[57]*(x[1] - y[35]);
out[1] = (1.0/2.0)*(-p[65]*(x[1] - y[35]) - y[26]*(p[66]*y[26] + y[0]*sin(x[0] - y[1])) - y[27]*(p[66]*y[27] + y[0]*cos(x[0] - y[1])) + y[32])/p[58];
out[2] = (-x[2] - y[26]*(-p[63] + p[61]) + y[30])/p[59];
out[3] = (-x[3] + y[27]*(-p[64] + p[62]))/p[60];
out[4] = (y[0] - x[4])/p[71];
out[5] = -p[74]*(p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] - y[30]) - x[4] + y[34] + u[26];
out[6] = (y[31] - x[6])/p[76];
out[7] = (x[6] - x[7])/p[78];
out[8] = p[79]*(u[28] - y[28]) - 9.9999999999999995e-7*x[8];
out[9] = (x[1] - x[9] - 1.0)/p[81];
out[10] = (-x[10] + y[33])/p[83];
out[11] = 1 - y[35];

}
void g_ini_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -u[0]/p[0] + pow(y[0], 2)*(p[1] + p[37]) + y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) - p[56]*y[28]/p[0];
out[1] = -u[1]/p[0] + pow(y[0], 2)*(-p[2] - p[38] - 1.0/2.0*p[3] - 1.0/2.0*p[39]) + y[0]*y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[0]*y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23])) - p[56]*y[29]/p[0];
out[2] = -u[2]/p[0] + y[0]*y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + pow(y[2], 2)*(p[1] + p[4]) + y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[3] = -u[3]/p[0] + y[0]*y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + pow(y[2], 2)*(-p[2] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[6]) + y[2]*y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[4] = -u[4]/p[0] + y[2]*y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + pow(y[4], 2)*(p[4] + p[7] + p[34]) + y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[5] = -u[5]/p[0] + y[2]*y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5])) + pow(y[4], 2)*(-p[5] - p[8] - p[35] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[36]) + y[4]*y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[4]*y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[6] = -u[6]/p[0] + y[4]*y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + pow(y[6], 2)*(p[7] + p[10] + p[31]) + y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[7] = -u[7]/p[0] + y[4]*y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + pow(y[6], 2)*(-p[8] - p[11] - p[32] - 1.0/2.0*p[9] - 1.0/2.0*p[12] - 1.0/2.0*p[33]) + y[6]*y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[6]*y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[8] = -u[8]/p[0] + y[6]*y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + pow(y[8], 2)*(p[10] + p[13]) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[9] = -u[9]/p[0] + y[6]*y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + pow(y[8], 2)*(-p[11] - p[14] - 1.0/2.0*p[12] - 1.0/2.0*p[15]) + y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[10] = -u[10]/p[0] + y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + pow(y[10], 2)*(p[13] + p[16]) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[11] = -u[11]/p[0] + y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + pow(y[10], 2)*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[12] = -u[12]/p[0] + y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + pow(y[12], 2)*(p[16] + p[19]) + y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[13] = -u[13]/p[0] + y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + pow(y[12], 2)*(-p[17] - p[20] - 1.0/2.0*p[18] - 1.0/2.0*p[21]) + y[12]*y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[14] = -u[14]/p[0] + y[4]*y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + pow(y[14], 2)*(p[34] + p[19] + p[22]) + y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[15] = -u[15]/p[0] + y[4]*y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15])) + y[12]*y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15])) + pow(y[14], 2)*(-p[35] - p[20] - p[23] - 1.0/2.0*p[36] - 1.0/2.0*p[21] - 1.0/2.0*p[24]) + y[14]*y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[16] = -u[16]/p[0] + y[14]*y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + pow(y[16], 2)*(p[22] + p[25]) + y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[17] = -u[17]/p[0] + y[14]*y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17])) + pow(y[16], 2)*(-p[23] - p[26] - 1.0/2.0*p[24] - 1.0/2.0*p[27]) + y[16]*y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[18] = -u[18]/p[0] + y[16]*y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + pow(y[18], 2)*(p[25] + p[28]) + y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[19] = -u[19]/p[0] + y[16]*y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19])) + pow(y[18], 2)*(-p[26] - p[29] - 1.0/2.0*p[27] - 1.0/2.0*p[30]) + y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[20] = -u[20]/p[0] + y[6]*y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + pow(y[20], 2)*(p[28] + p[31]);
out[21] = -u[21]/p[0] + y[6]*y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21])) + y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + pow(y[20], 2)*(-p[29] - p[32] - 1.0/2.0*p[30] - 1.0/2.0*p[33]);
out[22] = -u[22]/p[0] + y[0]*y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + pow(y[22], 2)*(p[37] + p[40]) + y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[23] = -u[23]/p[0] + y[0]*y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23])) + pow(y[22], 2)*(-p[38] - p[41] - 1.0/2.0*p[39] - 1.0/2.0*p[42]) + y[22]*y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[24] = -u[24]/p[0] + y[22]*y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25])) + pow(y[24], 2)*p[40];
out[25] = -u[25]/p[0] + y[22]*y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25])) + pow(y[24], 2)*(-p[41] - 1.0/2.0*p[42]);
out[26] = p[66]*y[27] + y[0]*cos(x[0] - y[1]) + p[63]*y[26] - x[2];
out[27] = p[66]*y[26] + y[0]*sin(x[0] - y[1]) - p[64]*y[27] - x[3];
out[28] = y[0]*y[26]*sin(x[0] - y[1]) + y[0]*y[27]*cos(x[0] - y[1]) - y[28];
out[29] = y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]) - y[29];
out[30] = -y[30] + ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   p[72]
)
: ((p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   p[73]
)
: (
   p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]
)));
out[31] = p[68]*y[36] - y[31] + u[29] + x[8] - (x[1] - p[80])/p[75];
out[32] = p[77]*(x[6] - x[7])/p[78] - y[32] + x[7];
out[33] = x[1] - x[9] - y[33] - 1.0;
out[34] = -y[34] + ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   -p[85]
)
: ((p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   p[85]
)
: (
   p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])
)));
out[35] = x[1] - y[35];
out[36] = p[87]*x[11] + p[86]*(1 - y[35]) - y[36];

}
void f_run_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[67]*x[0] + p[57]*(x[1] - y[35]);
out[1] = (1.0/2.0)*(-p[65]*(x[1] - y[35]) - y[26]*(p[66]*y[26] + y[0]*sin(x[0] - y[1])) - y[27]*(p[66]*y[27] + y[0]*cos(x[0] - y[1])) + y[32])/p[58];
out[2] = (-x[2] - y[26]*(-p[63] + p[61]) + y[30])/p[59];
out[3] = (-x[3] + y[27]*(-p[64] + p[62]))/p[60];
out[4] = (y[0] - x[4])/p[71];
out[5] = -p[74]*(p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] - y[30]) - x[4] + y[34] + u[26];
out[6] = (y[31] - x[6])/p[76];
out[7] = (x[6] - x[7])/p[78];
out[8] = p[79]*(u[28] - y[28]) - 9.9999999999999995e-7*x[8];
out[9] = (x[1] - x[9] - 1.0)/p[81];
out[10] = (-x[10] + y[33])/p[83];
out[11] = 1 - y[35];

}
void g_run_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -u[0]/p[0] + pow(y[0], 2)*(p[1] + p[37]) + y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) - p[56]*y[28]/p[0];
out[1] = -u[1]/p[0] + pow(y[0], 2)*(-p[2] - p[38] - 1.0/2.0*p[3] - 1.0/2.0*p[39]) + y[0]*y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[0]*y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23])) - p[56]*y[29]/p[0];
out[2] = -u[2]/p[0] + y[0]*y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + pow(y[2], 2)*(p[1] + p[4]) + y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[3] = -u[3]/p[0] + y[0]*y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + pow(y[2], 2)*(-p[2] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[6]) + y[2]*y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[4] = -u[4]/p[0] + y[2]*y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + pow(y[4], 2)*(p[4] + p[7] + p[34]) + y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[5] = -u[5]/p[0] + y[2]*y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5])) + pow(y[4], 2)*(-p[5] - p[8] - p[35] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[36]) + y[4]*y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[4]*y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[6] = -u[6]/p[0] + y[4]*y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + pow(y[6], 2)*(p[7] + p[10] + p[31]) + y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[7] = -u[7]/p[0] + y[4]*y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + pow(y[6], 2)*(-p[8] - p[11] - p[32] - 1.0/2.0*p[9] - 1.0/2.0*p[12] - 1.0/2.0*p[33]) + y[6]*y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[6]*y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[8] = -u[8]/p[0] + y[6]*y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + pow(y[8], 2)*(p[10] + p[13]) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[9] = -u[9]/p[0] + y[6]*y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + pow(y[8], 2)*(-p[11] - p[14] - 1.0/2.0*p[12] - 1.0/2.0*p[15]) + y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[10] = -u[10]/p[0] + y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + pow(y[10], 2)*(p[13] + p[16]) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[11] = -u[11]/p[0] + y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + pow(y[10], 2)*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[12] = -u[12]/p[0] + y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + pow(y[12], 2)*(p[16] + p[19]) + y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[13] = -u[13]/p[0] + y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + pow(y[12], 2)*(-p[17] - p[20] - 1.0/2.0*p[18] - 1.0/2.0*p[21]) + y[12]*y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[14] = -u[14]/p[0] + y[4]*y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + pow(y[14], 2)*(p[34] + p[19] + p[22]) + y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[15] = -u[15]/p[0] + y[4]*y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15])) + y[12]*y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15])) + pow(y[14], 2)*(-p[35] - p[20] - p[23] - 1.0/2.0*p[36] - 1.0/2.0*p[21] - 1.0/2.0*p[24]) + y[14]*y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[16] = -u[16]/p[0] + y[14]*y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + pow(y[16], 2)*(p[22] + p[25]) + y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[17] = -u[17]/p[0] + y[14]*y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17])) + pow(y[16], 2)*(-p[23] - p[26] - 1.0/2.0*p[24] - 1.0/2.0*p[27]) + y[16]*y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[18] = -u[18]/p[0] + y[16]*y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + pow(y[18], 2)*(p[25] + p[28]) + y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[19] = -u[19]/p[0] + y[16]*y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19])) + pow(y[18], 2)*(-p[26] - p[29] - 1.0/2.0*p[27] - 1.0/2.0*p[30]) + y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[20] = -u[20]/p[0] + y[6]*y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + pow(y[20], 2)*(p[28] + p[31]);
out[21] = -u[21]/p[0] + y[6]*y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21])) + y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + pow(y[20], 2)*(-p[29] - p[32] - 1.0/2.0*p[30] - 1.0/2.0*p[33]);
out[22] = -u[22]/p[0] + y[0]*y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + pow(y[22], 2)*(p[37] + p[40]) + y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[23] = -u[23]/p[0] + y[0]*y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23])) + pow(y[22], 2)*(-p[38] - p[41] - 1.0/2.0*p[39] - 1.0/2.0*p[42]) + y[22]*y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[24] = -u[24]/p[0] + y[22]*y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25])) + pow(y[24], 2)*p[40];
out[25] = -u[25]/p[0] + y[22]*y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25])) + pow(y[24], 2)*(-p[41] - 1.0/2.0*p[42]);
out[26] = p[66]*y[27] + y[0]*cos(x[0] - y[1]) + p[63]*y[26] - x[2];
out[27] = p[66]*y[26] + y[0]*sin(x[0] - y[1]) - p[64]*y[27] - x[3];
out[28] = y[0]*y[26]*sin(x[0] - y[1]) + y[0]*y[27]*cos(x[0] - y[1]) - y[28];
out[29] = y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]) - y[29];
out[30] = -y[30] + ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   p[72]
)
: ((p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   p[73]
)
: (
   p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]
)));
out[31] = p[68]*y[36] - y[31] + u[29] + x[8] - (x[1] - p[80])/p[75];
out[32] = p[77]*(x[6] - x[7])/p[78] - y[32] + x[7];
out[33] = x[1] - x[9] - y[33] - 1.0;
out[34] = -y[34] + ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   -p[85]
)
: ((p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   p[85]
)
: (
   p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])
)));
out[35] = x[1] - y[35];
out[36] = p[87]*x[11] + p[86]*(1 - y[35]) - y[36];

}
void h_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = y[0];
out[1] = y[2];
out[2] = y[4];
out[3] = y[6];
out[4] = y[8];
out[5] = y[10];
out[6] = y[12];
out[7] = y[14];
out[8] = y[16];
out[9] = y[18];
out[10] = y[20];
out[11] = y[22];
out[12] = y[24];
out[13] = y[26]*(p[66]*y[26] + y[0]*sin(x[0] - y[1])) + y[27]*(p[66]*y[27] + y[0]*cos(x[0] - y[1]));

}
void de_jac_ini_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[49] = (1.0/2.0)*(-y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[61] = (1.0/2.0)*(-y[26]*sin(x[0] - y[1]) - y[27]*cos(x[0] - y[1]))/p[58];
out[62] = (1.0/2.0)*(y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[87] = (1.0/2.0)*(-2*p[66]*y[26] - y[0]*sin(x[0] - y[1]))/p[58];
out[88] = (1.0/2.0)*(-2*p[66]*y[27] - y[0]*cos(x[0] - y[1]))/p[58];
out[600] = 2*y[0]*(p[1] + p[37]) + y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[601] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[602] = y[0]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[603] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[622] = y[0]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[623] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[649] = 2*y[0]*(-p[2] - p[38] - 1.0/2.0*p[3] - 1.0/2.0*p[39]) + y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[650] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[651] = y[0]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[652] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[671] = y[0]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[672] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[698] = y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[699] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[700] = y[0]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + 2*y[2]*(p[1] + p[4]) + y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[701] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[702] = y[2]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[703] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[747] = y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[748] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[749] = y[0]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + 2*y[2]*(-p[2] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[6]) + y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[750] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[751] = y[2]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[752] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[798] = y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[799] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[800] = y[2]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + 2*y[4]*(p[4] + p[7] + p[34]) + y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[801] = y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5])) + y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[802] = y[4]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[803] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[810] = y[4]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[811] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[847] = y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[848] = y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[849] = y[2]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5])) + 2*y[4]*(-p[5] - p[8] - p[35] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[36]) + y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[850] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[851] = y[4]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[852] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[859] = y[4]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[860] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[898] = y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[899] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[900] = y[4]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + 2*y[6]*(p[7] + p[10] + p[31]) + y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[901] = y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[902] = y[6]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[903] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[914] = y[6]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[915] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[947] = y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[948] = y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[949] = y[4]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + 2*y[6]*(-p[8] - p[11] - p[32] - 1.0/2.0*p[9] - 1.0/2.0*p[12] - 1.0/2.0*p[33]) + y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[950] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[951] = y[6]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[952] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[963] = y[6]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[964] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[998] = y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[999] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[1000] = y[6]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + 2*y[8]*(p[10] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1001] = y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[1002] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1003] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[1047] = y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[1048] = y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[1049] = y[6]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + 2*y[8]*(-p[11] - p[14] - 1.0/2.0*p[12] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[1050] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1051] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[1052] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[1098] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1099] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[1100] = y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1101] = y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[1102] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1103] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[1147] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[1148] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[1149] = y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[1150] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1151] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[1152] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[1198] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1199] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[1200] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + p[19]) + y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1201] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[1202] = y[12]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1203] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[1247] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[1248] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[1249] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - p[20] - 1.0/2.0*p[18] - 1.0/2.0*p[21]) + y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[1250] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1251] = y[12]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[1252] = y[12]*y[14]*(p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[1290] = y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[1291] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[1298] = y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1299] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[1300] = y[4]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + 2*y[14]*(p[34] + p[19] + p[22]) + y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1301] = y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[1302] = y[14]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1303] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[1339] = y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[1340] = y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[1347] = y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[1348] = y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[1349] = y[4]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15])) + y[12]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15])) + 2*y[14]*(-p[35] - p[20] - p[23] - 1.0/2.0*p[36] - 1.0/2.0*p[21] - 1.0/2.0*p[24]) + y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[1350] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1351] = y[14]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[1352] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[1398] = y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1399] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[1400] = y[14]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + 2*y[16]*(p[22] + p[25]) + y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1401] = y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17])) + y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[1402] = y[16]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1403] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[1447] = y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[1448] = y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[1449] = y[14]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17])) + 2*y[16]*(-p[23] - p[26] - 1.0/2.0*p[24] - 1.0/2.0*p[27]) + y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[1450] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1451] = y[16]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[1452] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[1498] = y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1499] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[1500] = y[16]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + 2*y[18]*(p[25] + p[28]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1501] = y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[1502] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1503] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1547] = y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[1548] = y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[1549] = y[16]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19])) + 2*y[18]*(-p[26] - p[29] - 1.0/2.0*p[27] - 1.0/2.0*p[30]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1550] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1551] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1552] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[1586] = y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[1587] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[1598] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1599] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[1600] = y[6]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[31]);
out[1601] = y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1635] = y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[1636] = y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[1647] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[1648] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[1649] = y[6]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21])) + y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[32] - 1.0/2.0*p[30] - 1.0/2.0*p[33]);
out[1650] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1678] = y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[1679] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[1700] = y[0]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + 2*y[22]*(p[37] + p[40]) + y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1701] = y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23])) + y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[1702] = y[22]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1703] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1727] = y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[1728] = y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[1749] = y[0]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23])) + 2*y[22]*(-p[38] - p[41] - 1.0/2.0*p[39] - 1.0/2.0*p[42]) + y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1750] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1751] = y[22]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1752] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[1798] = y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1799] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[1800] = y[22]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25])) + 2*y[24]*p[40];
out[1801] = y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1847] = y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[1848] = y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[1849] = y[22]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25])) + 2*y[24]*(-p[41] - 1.0/2.0*p[42]);
out[1850] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1862] = -y[0]*sin(x[0] - y[1]);
out[1874] = cos(x[0] - y[1]);
out[1875] = y[0]*sin(x[0] - y[1]);
out[1911] = y[0]*cos(x[0] - y[1]);
out[1923] = sin(x[0] - y[1]);
out[1924] = -y[0]*cos(x[0] - y[1]);
out[1960] = y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]);
out[1972] = y[26]*sin(x[0] - y[1]) + y[27]*cos(x[0] - y[1]);
out[1973] = -y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]);
out[1998] = y[0]*sin(x[0] - y[1]);
out[1999] = y[0]*cos(x[0] - y[1]);
out[2009] = -y[0]*y[26]*sin(x[0] - y[1]) - y[0]*y[27]*cos(x[0] - y[1]);
out[2021] = y[26]*cos(x[0] - y[1]) - y[27]*sin(x[0] - y[1]);
out[2022] = y[0]*y[26]*sin(x[0] - y[1]) + y[0]*y[27]*cos(x[0] - y[1]);
out[2047] = y[0]*cos(x[0] - y[1]);
out[2048] = -y[0]*sin(x[0] - y[1]);
out[2062] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   -p[69]
));
out[2063] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[70]
));
out[2104] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[69]
));
out[2264] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*(-p[82]/p[83] + 1)
));
out[2299] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*p[82]/p[83]
));

}

void de_jac_ini_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[67];
out[1] = p[57];
out[47] = -p[57];
out[50] = -1.0/2.0*p[65]/p[58];
out[93] = (1.0/2.0)/p[58];
out[96] = (1.0/2.0)*p[65]/p[58];
out[100] = -1/p[59];
out[136] = (p[63] - p[61])/p[59];
out[140] = 1.0/p[59];
out[150] = -1/p[60];
out[186] = (-p[64] + p[62])/p[60];
out[200] = -1/p[71];
out[208] = 1.0/p[71];
out[249] = p[69]*p[74] - 1;
out[250] = -p[70]*p[74];
out[287] = p[74];
out[291] = -p[69]*p[74] + 1;
out[300] = -1/p[76];
out[337] = 1.0/p[76];
out[349] = 1.0/p[78];
out[350] = -1/p[78];
out[432] = -p[79];
out[442] = 1.0/p[81];
out[450] = -1/p[81];
out[500] = -1/p[83];
out[535] = 1.0/p[83];
out[628] = -p[56]/p[0];
out[678] = -p[56]/p[0];
out[1900] = p[63];
out[1901] = p[66];
out[1949] = p[66];
out[1950] = -p[64];
out[2108] = -1/p[75];
out[2155] = p[68];
out[2162] = p[77]/p[78];
out[2163] = -p[77]/p[78] + 1;
out[2363] = p[87];
out[2399] = -p[86];

}

void de_jac_ini_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[400] = -9.9999999999999995e-7;
out[586] = -1;
out[1864] = -1;
out[1914] = -1;
out[2000] = -1;
out[2050] = -1;
out[2100] = -1;
out[2115] = 1;
out[2150] = -1;
out[2200] = -1;
out[2206] = 1;
out[2214] = -1;
out[2250] = -1;
out[2300] = -1;
out[2304] = 1;
out[2350] = -1;
out[2400] = -1;

}

void sp_jac_ini_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[3] = (1.0/2.0)*(-y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[5] = (1.0/2.0)*(-y[26]*sin(x[0] - y[1]) - y[27]*cos(x[0] - y[1]))/p[58];
out[6] = (1.0/2.0)*(y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[7] = (1.0/2.0)*(-2*p[66]*y[26] - y[0]*sin(x[0] - y[1]))/p[58];
out[8] = (1.0/2.0)*(-2*p[66]*y[27] - y[0]*cos(x[0] - y[1]))/p[58];
out[33] = 2*y[0]*(p[1] + p[37]) + y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[34] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[35] = y[0]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[36] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[37] = y[0]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[38] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[40] = 2*y[0]*(-p[2] - p[38] - 1.0/2.0*p[3] - 1.0/2.0*p[39]) + y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[41] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[42] = y[0]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[43] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[44] = y[0]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[45] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[47] = y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[48] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[49] = y[0]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + 2*y[2]*(p[1] + p[4]) + y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[50] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[51] = y[2]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[52] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[53] = y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[54] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[55] = y[0]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + 2*y[2]*(-p[2] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[6]) + y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[56] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[57] = y[2]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[58] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[59] = y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[60] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[61] = y[2]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + 2*y[4]*(p[4] + p[7] + p[34]) + y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[62] = y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5])) + y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[63] = y[4]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[64] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[65] = y[4]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[66] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[67] = y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[68] = y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[69] = y[2]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5])) + 2*y[4]*(-p[5] - p[8] - p[35] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[36]) + y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[70] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[71] = y[4]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[72] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[73] = y[4]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[74] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[75] = y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[76] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[77] = y[4]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + 2*y[6]*(p[7] + p[10] + p[31]) + y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[78] = y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[79] = y[6]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[80] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[81] = y[6]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[82] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[83] = y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[84] = y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[85] = y[4]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + 2*y[6]*(-p[8] - p[11] - p[32] - 1.0/2.0*p[9] - 1.0/2.0*p[12] - 1.0/2.0*p[33]) + y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[86] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[87] = y[6]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[88] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[89] = y[6]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[90] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[91] = y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[92] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[93] = y[6]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + 2*y[8]*(p[10] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[94] = y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[95] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[96] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[97] = y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[98] = y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[99] = y[6]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + 2*y[8]*(-p[11] - p[14] - 1.0/2.0*p[12] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[100] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[101] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[102] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[103] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[104] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[105] = y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[106] = y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[107] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[108] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[109] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[110] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[111] = y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[112] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[113] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[114] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[115] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[116] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[117] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + p[19]) + y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[118] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[119] = y[12]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[120] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[121] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[122] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[123] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - p[20] - 1.0/2.0*p[18] - 1.0/2.0*p[21]) + y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[124] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[125] = y[12]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[126] = y[12]*y[14]*(p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[127] = y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[128] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[129] = y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[130] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[131] = y[4]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + 2*y[14]*(p[34] + p[19] + p[22]) + y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[132] = y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[133] = y[14]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[134] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[135] = y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[136] = y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[137] = y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[138] = y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[139] = y[4]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15])) + y[12]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15])) + 2*y[14]*(-p[35] - p[20] - p[23] - 1.0/2.0*p[36] - 1.0/2.0*p[21] - 1.0/2.0*p[24]) + y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[140] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[141] = y[14]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[142] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[143] = y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[144] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[145] = y[14]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + 2*y[16]*(p[22] + p[25]) + y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[146] = y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17])) + y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[147] = y[16]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[148] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[149] = y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[150] = y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[151] = y[14]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17])) + 2*y[16]*(-p[23] - p[26] - 1.0/2.0*p[24] - 1.0/2.0*p[27]) + y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[152] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[153] = y[16]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[154] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[155] = y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[156] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[157] = y[16]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + 2*y[18]*(p[25] + p[28]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[158] = y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[159] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[160] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[161] = y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[162] = y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[163] = y[16]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19])) + 2*y[18]*(-p[26] - p[29] - 1.0/2.0*p[27] - 1.0/2.0*p[30]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[164] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[165] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[166] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[167] = y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[168] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[169] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[170] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[171] = y[6]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[31]);
out[172] = y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[173] = y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[174] = y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[175] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[176] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[177] = y[6]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21])) + y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[32] - 1.0/2.0*p[30] - 1.0/2.0*p[33]);
out[178] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[179] = y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[180] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[181] = y[0]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + 2*y[22]*(p[37] + p[40]) + y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[182] = y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23])) + y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[183] = y[22]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[184] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[185] = y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[186] = y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[187] = y[0]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23])) + 2*y[22]*(-p[38] - p[41] - 1.0/2.0*p[39] - 1.0/2.0*p[42]) + y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[188] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[189] = y[22]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[190] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[191] = y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[192] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[193] = y[22]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25])) + 2*y[24]*p[40];
out[194] = y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[195] = y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[196] = y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[197] = y[22]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25])) + 2*y[24]*(-p[41] - 1.0/2.0*p[42]);
out[198] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[199] = -y[0]*sin(x[0] - y[1]);
out[201] = cos(x[0] - y[1]);
out[202] = y[0]*sin(x[0] - y[1]);
out[205] = y[0]*cos(x[0] - y[1]);
out[207] = sin(x[0] - y[1]);
out[208] = -y[0]*cos(x[0] - y[1]);
out[211] = y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]);
out[212] = y[26]*sin(x[0] - y[1]) + y[27]*cos(x[0] - y[1]);
out[213] = -y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]);
out[214] = y[0]*sin(x[0] - y[1]);
out[215] = y[0]*cos(x[0] - y[1]);
out[217] = -y[0]*y[26]*sin(x[0] - y[1]) - y[0]*y[27]*cos(x[0] - y[1]);
out[218] = y[26]*cos(x[0] - y[1]) - y[27]*sin(x[0] - y[1]);
out[219] = y[0]*y[26]*sin(x[0] - y[1]) + y[0]*y[27]*cos(x[0] - y[1]);
out[220] = y[0]*cos(x[0] - y[1]);
out[221] = -y[0]*sin(x[0] - y[1]);
out[223] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   -p[69]
));
out[224] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[70]
));
out[226] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[69]
));
out[237] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*(-p[82]/p[83] + 1)
));
out[238] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*p[82]/p[83]
));

}

void sp_jac_ini_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[67];
out[1] = p[57];
out[2] = -p[57];
out[4] = -1.0/2.0*p[65]/p[58];
out[9] = (1.0/2.0)/p[58];
out[10] = (1.0/2.0)*p[65]/p[58];
out[11] = -1/p[59];
out[12] = (p[63] - p[61])/p[59];
out[13] = 1.0/p[59];
out[14] = -1/p[60];
out[15] = (-p[64] + p[62])/p[60];
out[16] = -1/p[71];
out[17] = 1.0/p[71];
out[18] = p[69]*p[74] - 1;
out[19] = -p[70]*p[74];
out[20] = p[74];
out[21] = -p[69]*p[74] + 1;
out[22] = -1/p[76];
out[23] = 1.0/p[76];
out[24] = 1.0/p[78];
out[25] = -1/p[78];
out[27] = -p[79];
out[28] = 1.0/p[81];
out[29] = -1/p[81];
out[30] = -1/p[83];
out[31] = 1.0/p[83];
out[39] = -p[56]/p[0];
out[46] = -p[56]/p[0];
out[203] = p[63];
out[204] = p[66];
out[209] = p[66];
out[210] = -p[64];
out[227] = -1/p[75];
out[230] = p[68];
out[231] = p[77]/p[78];
out[232] = -p[77]/p[78] + 1;
out[242] = p[87];
out[243] = -p[86];

}

void sp_jac_ini_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[26] = -9.9999999999999995e-7;
out[32] = -1;
out[200] = -1;
out[206] = -1;
out[216] = -1;
out[222] = -1;
out[225] = -1;
out[228] = 1;
out[229] = -1;
out[233] = -1;
out[234] = 1;
out[235] = -1;
out[236] = -1;
out[239] = -1;
out[240] = 1;
out[241] = -1;
out[244] = -1;

}

void de_jac_run_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[49] = (1.0/2.0)*(-y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[61] = (1.0/2.0)*(-y[26]*sin(x[0] - y[1]) - y[27]*cos(x[0] - y[1]))/p[58];
out[62] = (1.0/2.0)*(y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[87] = (1.0/2.0)*(-2*p[66]*y[26] - y[0]*sin(x[0] - y[1]))/p[58];
out[88] = (1.0/2.0)*(-2*p[66]*y[27] - y[0]*cos(x[0] - y[1]))/p[58];
out[600] = 2*y[0]*(p[1] + p[37]) + y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[601] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[602] = y[0]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[603] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[622] = y[0]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[623] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[649] = 2*y[0]*(-p[2] - p[38] - 1.0/2.0*p[3] - 1.0/2.0*p[39]) + y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[650] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[651] = y[0]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[652] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[671] = y[0]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[672] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[698] = y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[699] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[700] = y[0]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + 2*y[2]*(p[1] + p[4]) + y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[701] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[702] = y[2]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[703] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[747] = y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[748] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[749] = y[0]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + 2*y[2]*(-p[2] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[6]) + y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[750] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[751] = y[2]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[752] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[798] = y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[799] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[800] = y[2]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + 2*y[4]*(p[4] + p[7] + p[34]) + y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[801] = y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5])) + y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[802] = y[4]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[803] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[810] = y[4]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[811] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[847] = y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[848] = y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[849] = y[2]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5])) + 2*y[4]*(-p[5] - p[8] - p[35] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[36]) + y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[850] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[851] = y[4]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[852] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[859] = y[4]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[860] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[898] = y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[899] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[900] = y[4]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + 2*y[6]*(p[7] + p[10] + p[31]) + y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[901] = y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[902] = y[6]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[903] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[914] = y[6]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[915] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[947] = y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[948] = y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[949] = y[4]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + 2*y[6]*(-p[8] - p[11] - p[32] - 1.0/2.0*p[9] - 1.0/2.0*p[12] - 1.0/2.0*p[33]) + y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[950] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[951] = y[6]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[952] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[963] = y[6]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[964] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[998] = y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[999] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[1000] = y[6]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + 2*y[8]*(p[10] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1001] = y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[1002] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1003] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[1047] = y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[1048] = y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[1049] = y[6]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + 2*y[8]*(-p[11] - p[14] - 1.0/2.0*p[12] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[1050] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1051] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[1052] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[1098] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1099] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[1100] = y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1101] = y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[1102] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1103] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[1147] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[1148] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[1149] = y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[1150] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1151] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[1152] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[1198] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1199] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[1200] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + p[19]) + y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1201] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[1202] = y[12]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1203] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[1247] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[1248] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[1249] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - p[20] - 1.0/2.0*p[18] - 1.0/2.0*p[21]) + y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[1250] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1251] = y[12]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[1252] = y[12]*y[14]*(p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[1290] = y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[1291] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[1298] = y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1299] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[1300] = y[4]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + 2*y[14]*(p[34] + p[19] + p[22]) + y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1301] = y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[1302] = y[14]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1303] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[1339] = y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[1340] = y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[1347] = y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[1348] = y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[1349] = y[4]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15])) + y[12]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15])) + 2*y[14]*(-p[35] - p[20] - p[23] - 1.0/2.0*p[36] - 1.0/2.0*p[21] - 1.0/2.0*p[24]) + y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[1350] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1351] = y[14]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[1352] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[1398] = y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1399] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[1400] = y[14]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + 2*y[16]*(p[22] + p[25]) + y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1401] = y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17])) + y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[1402] = y[16]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1403] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[1447] = y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[1448] = y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[1449] = y[14]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17])) + 2*y[16]*(-p[23] - p[26] - 1.0/2.0*p[24] - 1.0/2.0*p[27]) + y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[1450] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1451] = y[16]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[1452] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[1498] = y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1499] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[1500] = y[16]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + 2*y[18]*(p[25] + p[28]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1501] = y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[1502] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1503] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1547] = y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[1548] = y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[1549] = y[16]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19])) + 2*y[18]*(-p[26] - p[29] - 1.0/2.0*p[27] - 1.0/2.0*p[30]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1550] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1551] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1552] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[1586] = y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[1587] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[1598] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1599] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[1600] = y[6]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[31]);
out[1601] = y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1635] = y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[1636] = y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[1647] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[1648] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[1649] = y[6]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21])) + y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[32] - 1.0/2.0*p[30] - 1.0/2.0*p[33]);
out[1650] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1678] = y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[1679] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[1700] = y[0]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + 2*y[22]*(p[37] + p[40]) + y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1701] = y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23])) + y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[1702] = y[22]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1703] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1727] = y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[1728] = y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[1749] = y[0]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23])) + 2*y[22]*(-p[38] - p[41] - 1.0/2.0*p[39] - 1.0/2.0*p[42]) + y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1750] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1751] = y[22]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1752] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[1798] = y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1799] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[1800] = y[22]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25])) + 2*y[24]*p[40];
out[1801] = y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1847] = y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[1848] = y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[1849] = y[22]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25])) + 2*y[24]*(-p[41] - 1.0/2.0*p[42]);
out[1850] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1862] = -y[0]*sin(x[0] - y[1]);
out[1874] = cos(x[0] - y[1]);
out[1875] = y[0]*sin(x[0] - y[1]);
out[1911] = y[0]*cos(x[0] - y[1]);
out[1923] = sin(x[0] - y[1]);
out[1924] = -y[0]*cos(x[0] - y[1]);
out[1960] = y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]);
out[1972] = y[26]*sin(x[0] - y[1]) + y[27]*cos(x[0] - y[1]);
out[1973] = -y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]);
out[1998] = y[0]*sin(x[0] - y[1]);
out[1999] = y[0]*cos(x[0] - y[1]);
out[2009] = -y[0]*y[26]*sin(x[0] - y[1]) - y[0]*y[27]*cos(x[0] - y[1]);
out[2021] = y[26]*cos(x[0] - y[1]) - y[27]*sin(x[0] - y[1]);
out[2022] = y[0]*y[26]*sin(x[0] - y[1]) + y[0]*y[27]*cos(x[0] - y[1]);
out[2047] = y[0]*cos(x[0] - y[1]);
out[2048] = -y[0]*sin(x[0] - y[1]);
out[2062] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   -p[69]
));
out[2063] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[70]
));
out[2104] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[69]
));
out[2264] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*(-p[82]/p[83] + 1)
));
out[2299] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*p[82]/p[83]
));

}

void de_jac_run_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[67];
out[1] = p[57];
out[47] = -p[57];
out[50] = -1.0/2.0*p[65]/p[58];
out[93] = (1.0/2.0)/p[58];
out[96] = (1.0/2.0)*p[65]/p[58];
out[100] = -1/p[59];
out[136] = (p[63] - p[61])/p[59];
out[140] = 1.0/p[59];
out[150] = -1/p[60];
out[186] = (-p[64] + p[62])/p[60];
out[200] = -1/p[71];
out[208] = 1.0/p[71];
out[249] = p[69]*p[74] - 1;
out[250] = -p[70]*p[74];
out[287] = p[74];
out[291] = -p[69]*p[74] + 1;
out[300] = -1/p[76];
out[337] = 1.0/p[76];
out[349] = 1.0/p[78];
out[350] = -1/p[78];
out[432] = -p[79];
out[442] = 1.0/p[81];
out[450] = -1/p[81];
out[500] = -1/p[83];
out[535] = 1.0/p[83];
out[628] = -p[56]/p[0];
out[678] = -p[56]/p[0];
out[1900] = p[63];
out[1901] = p[66];
out[1949] = p[66];
out[1950] = -p[64];
out[2108] = -1/p[75];
out[2155] = p[68];
out[2162] = p[77]/p[78];
out[2163] = -p[77]/p[78] + 1;
out[2363] = p[87];
out[2399] = -p[86];

}

void de_jac_run_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[400] = -9.9999999999999995e-7;
out[586] = -1;
out[1864] = -1;
out[1914] = -1;
out[2000] = -1;
out[2050] = -1;
out[2100] = -1;
out[2115] = 1;
out[2150] = -1;
out[2200] = -1;
out[2206] = 1;
out[2214] = -1;
out[2250] = -1;
out[2300] = -1;
out[2304] = 1;
out[2350] = -1;
out[2400] = -1;

}

void sp_jac_run_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[3] = (1.0/2.0)*(-y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[5] = (1.0/2.0)*(-y[26]*sin(x[0] - y[1]) - y[27]*cos(x[0] - y[1]))/p[58];
out[6] = (1.0/2.0)*(y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[7] = (1.0/2.0)*(-2*p[66]*y[26] - y[0]*sin(x[0] - y[1]))/p[58];
out[8] = (1.0/2.0)*(-2*p[66]*y[27] - y[0]*cos(x[0] - y[1]))/p[58];
out[33] = 2*y[0]*(p[1] + p[37]) + y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[34] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[35] = y[0]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[36] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[37] = y[0]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[38] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[40] = 2*y[0]*(-p[2] - p[38] - 1.0/2.0*p[3] - 1.0/2.0*p[39]) + y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[41] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[42] = y[0]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[43] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[44] = y[0]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[45] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[47] = y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[48] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[49] = y[0]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + 2*y[2]*(p[1] + p[4]) + y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[50] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[51] = y[2]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[52] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[53] = y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[54] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[55] = y[0]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + 2*y[2]*(-p[2] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[6]) + y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[56] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[57] = y[2]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[58] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[59] = y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[60] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[61] = y[2]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + 2*y[4]*(p[4] + p[7] + p[34]) + y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[62] = y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5])) + y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[63] = y[4]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[64] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[65] = y[4]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[66] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[67] = y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[68] = y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[69] = y[2]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5])) + 2*y[4]*(-p[5] - p[8] - p[35] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[36]) + y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[70] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[71] = y[4]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[72] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[73] = y[4]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[74] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[75] = y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[76] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[77] = y[4]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + 2*y[6]*(p[7] + p[10] + p[31]) + y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[78] = y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[79] = y[6]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[80] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[81] = y[6]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[82] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[83] = y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[84] = y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[85] = y[4]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + 2*y[6]*(-p[8] - p[11] - p[32] - 1.0/2.0*p[9] - 1.0/2.0*p[12] - 1.0/2.0*p[33]) + y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[86] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[87] = y[6]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[88] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[89] = y[6]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[90] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[91] = y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[92] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[93] = y[6]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + 2*y[8]*(p[10] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[94] = y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[95] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[96] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[97] = y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[98] = y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[99] = y[6]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + 2*y[8]*(-p[11] - p[14] - 1.0/2.0*p[12] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[100] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[101] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[102] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[103] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[104] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[105] = y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[106] = y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[107] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[108] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[109] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[110] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[111] = y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[112] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[113] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[114] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[115] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[116] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[117] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + p[19]) + y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[118] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[119] = y[12]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[120] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[121] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[122] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[123] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - p[20] - 1.0/2.0*p[18] - 1.0/2.0*p[21]) + y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[124] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[125] = y[12]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[126] = y[12]*y[14]*(p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[127] = y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[128] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[129] = y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[130] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[131] = y[4]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + 2*y[14]*(p[34] + p[19] + p[22]) + y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[132] = y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[133] = y[14]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[134] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[135] = y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[136] = y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[137] = y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[138] = y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[139] = y[4]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15])) + y[12]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15])) + 2*y[14]*(-p[35] - p[20] - p[23] - 1.0/2.0*p[36] - 1.0/2.0*p[21] - 1.0/2.0*p[24]) + y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[140] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[141] = y[14]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[142] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[143] = y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[144] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[145] = y[14]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + 2*y[16]*(p[22] + p[25]) + y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[146] = y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17])) + y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[147] = y[16]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[148] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[149] = y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[150] = y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[151] = y[14]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17])) + 2*y[16]*(-p[23] - p[26] - 1.0/2.0*p[24] - 1.0/2.0*p[27]) + y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[152] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[153] = y[16]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[154] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[155] = y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[156] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[157] = y[16]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + 2*y[18]*(p[25] + p[28]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[158] = y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[159] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[160] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[161] = y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[162] = y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[163] = y[16]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19])) + 2*y[18]*(-p[26] - p[29] - 1.0/2.0*p[27] - 1.0/2.0*p[30]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[164] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[165] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[166] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[167] = y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[168] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[169] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[170] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[171] = y[6]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[31]);
out[172] = y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[173] = y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[174] = y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[175] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[176] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[177] = y[6]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21])) + y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[32] - 1.0/2.0*p[30] - 1.0/2.0*p[33]);
out[178] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[179] = y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[180] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[181] = y[0]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + 2*y[22]*(p[37] + p[40]) + y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[182] = y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23])) + y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[183] = y[22]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[184] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[185] = y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[186] = y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[187] = y[0]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23])) + 2*y[22]*(-p[38] - p[41] - 1.0/2.0*p[39] - 1.0/2.0*p[42]) + y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[188] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[189] = y[22]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[190] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[191] = y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[192] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[193] = y[22]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25])) + 2*y[24]*p[40];
out[194] = y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[195] = y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[196] = y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[197] = y[22]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25])) + 2*y[24]*(-p[41] - 1.0/2.0*p[42]);
out[198] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[199] = -y[0]*sin(x[0] - y[1]);
out[201] = cos(x[0] - y[1]);
out[202] = y[0]*sin(x[0] - y[1]);
out[205] = y[0]*cos(x[0] - y[1]);
out[207] = sin(x[0] - y[1]);
out[208] = -y[0]*cos(x[0] - y[1]);
out[211] = y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]);
out[212] = y[26]*sin(x[0] - y[1]) + y[27]*cos(x[0] - y[1]);
out[213] = -y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]);
out[214] = y[0]*sin(x[0] - y[1]);
out[215] = y[0]*cos(x[0] - y[1]);
out[217] = -y[0]*y[26]*sin(x[0] - y[1]) - y[0]*y[27]*cos(x[0] - y[1]);
out[218] = y[26]*cos(x[0] - y[1]) - y[27]*sin(x[0] - y[1]);
out[219] = y[0]*y[26]*sin(x[0] - y[1]) + y[0]*y[27]*cos(x[0] - y[1]);
out[220] = y[0]*cos(x[0] - y[1]);
out[221] = -y[0]*sin(x[0] - y[1]);
out[223] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   -p[69]
));
out[224] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[70]
));
out[226] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[69]
));
out[237] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*(-p[82]/p[83] + 1)
));
out[238] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*p[82]/p[83]
));

}

void sp_jac_run_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[67];
out[1] = p[57];
out[2] = -p[57];
out[4] = -1.0/2.0*p[65]/p[58];
out[9] = (1.0/2.0)/p[58];
out[10] = (1.0/2.0)*p[65]/p[58];
out[11] = -1/p[59];
out[12] = (p[63] - p[61])/p[59];
out[13] = 1.0/p[59];
out[14] = -1/p[60];
out[15] = (-p[64] + p[62])/p[60];
out[16] = -1/p[71];
out[17] = 1.0/p[71];
out[18] = p[69]*p[74] - 1;
out[19] = -p[70]*p[74];
out[20] = p[74];
out[21] = -p[69]*p[74] + 1;
out[22] = -1/p[76];
out[23] = 1.0/p[76];
out[24] = 1.0/p[78];
out[25] = -1/p[78];
out[27] = -p[79];
out[28] = 1.0/p[81];
out[29] = -1/p[81];
out[30] = -1/p[83];
out[31] = 1.0/p[83];
out[39] = -p[56]/p[0];
out[46] = -p[56]/p[0];
out[203] = p[63];
out[204] = p[66];
out[209] = p[66];
out[210] = -p[64];
out[227] = -1/p[75];
out[230] = p[68];
out[231] = p[77]/p[78];
out[232] = -p[77]/p[78] + 1;
out[242] = p[87];
out[243] = -p[86];

}

void sp_jac_run_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[26] = -9.9999999999999995e-7;
out[32] = -1;
out[200] = -1;
out[206] = -1;
out[216] = -1;
out[222] = -1;
out[225] = -1;
out[228] = 1;
out[229] = -1;
out[233] = -1;
out[234] = 1;
out[235] = -1;
out[236] = -1;
out[239] = -1;
out[240] = 1;
out[241] = -1;
out[244] = -1;

}

void de_jac_trap_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[49] = -0.25*Dt*(-y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[61] = -0.25*Dt*(-y[26]*sin(x[0] - y[1]) - y[27]*cos(x[0] - y[1]))/p[58];
out[62] = -0.25*Dt*(y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[87] = -0.25*Dt*(-2*p[66]*y[26] - y[0]*sin(x[0] - y[1]))/p[58];
out[88] = -0.25*Dt*(-2*p[66]*y[27] - y[0]*cos(x[0] - y[1]))/p[58];
out[600] = 2*y[0]*(p[1] + p[37]) + y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[601] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[602] = y[0]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[603] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[622] = y[0]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[623] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[649] = 2*y[0]*(-p[2] - p[38] - 1.0/2.0*p[3] - 1.0/2.0*p[39]) + y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[650] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[651] = y[0]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[652] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[671] = y[0]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[672] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[698] = y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[699] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[700] = y[0]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + 2*y[2]*(p[1] + p[4]) + y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[701] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[702] = y[2]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[703] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[747] = y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[748] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[749] = y[0]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + 2*y[2]*(-p[2] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[6]) + y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[750] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[751] = y[2]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[752] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[798] = y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[799] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[800] = y[2]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + 2*y[4]*(p[4] + p[7] + p[34]) + y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[801] = y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5])) + y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[802] = y[4]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[803] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[810] = y[4]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[811] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[847] = y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[848] = y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[849] = y[2]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5])) + 2*y[4]*(-p[5] - p[8] - p[35] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[36]) + y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[850] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[851] = y[4]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[852] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[859] = y[4]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[860] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[898] = y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[899] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[900] = y[4]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + 2*y[6]*(p[7] + p[10] + p[31]) + y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[901] = y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[902] = y[6]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[903] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[914] = y[6]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[915] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[947] = y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[948] = y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[949] = y[4]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + 2*y[6]*(-p[8] - p[11] - p[32] - 1.0/2.0*p[9] - 1.0/2.0*p[12] - 1.0/2.0*p[33]) + y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[950] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[951] = y[6]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[952] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[963] = y[6]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[964] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[998] = y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[999] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[1000] = y[6]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + 2*y[8]*(p[10] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1001] = y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[1002] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1003] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[1047] = y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[1048] = y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[1049] = y[6]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + 2*y[8]*(-p[11] - p[14] - 1.0/2.0*p[12] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[1050] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1051] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[1052] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[1098] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[1099] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[1100] = y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1101] = y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[1102] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1103] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[1147] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[1148] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[1149] = y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[1150] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1151] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[1152] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[1198] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[1199] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[1200] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + p[19]) + y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1201] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[1202] = y[12]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1203] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[1247] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[1248] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[1249] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - p[20] - 1.0/2.0*p[18] - 1.0/2.0*p[21]) + y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[1250] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1251] = y[12]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[1252] = y[12]*y[14]*(p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[1290] = y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[1291] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[1298] = y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[1299] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[1300] = y[4]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + 2*y[14]*(p[34] + p[19] + p[22]) + y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1301] = y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[1302] = y[14]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1303] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[1339] = y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[1340] = y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[1347] = y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[1348] = y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[1349] = y[4]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15])) + y[12]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15])) + 2*y[14]*(-p[35] - p[20] - p[23] - 1.0/2.0*p[36] - 1.0/2.0*p[21] - 1.0/2.0*p[24]) + y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[1350] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1351] = y[14]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[1352] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[1398] = y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[1399] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[1400] = y[14]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + 2*y[16]*(p[22] + p[25]) + y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1401] = y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17])) + y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[1402] = y[16]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1403] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[1447] = y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[1448] = y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[1449] = y[14]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17])) + 2*y[16]*(-p[23] - p[26] - 1.0/2.0*p[24] - 1.0/2.0*p[27]) + y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[1450] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1451] = y[16]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[1452] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[1498] = y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[1499] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[1500] = y[16]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + 2*y[18]*(p[25] + p[28]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1501] = y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[1502] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1503] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1547] = y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[1548] = y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[1549] = y[16]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19])) + 2*y[18]*(-p[26] - p[29] - 1.0/2.0*p[27] - 1.0/2.0*p[30]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1550] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1551] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1552] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[1586] = y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[1587] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[1598] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1599] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[1600] = y[6]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[31]);
out[1601] = y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[1635] = y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[1636] = y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[1647] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[1648] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[1649] = y[6]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21])) + y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[32] - 1.0/2.0*p[30] - 1.0/2.0*p[33]);
out[1650] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[1678] = y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[1679] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[1700] = y[0]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + 2*y[22]*(p[37] + p[40]) + y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1701] = y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23])) + y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[1702] = y[22]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1703] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1727] = y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[1728] = y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[1749] = y[0]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23])) + 2*y[22]*(-p[38] - p[41] - 1.0/2.0*p[39] - 1.0/2.0*p[42]) + y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1750] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1751] = y[22]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1752] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[1798] = y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1799] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[1800] = y[22]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25])) + 2*y[24]*p[40];
out[1801] = y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[1847] = y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[1848] = y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[1849] = y[22]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25])) + 2*y[24]*(-p[41] - 1.0/2.0*p[42]);
out[1850] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[1862] = -y[0]*sin(x[0] - y[1]);
out[1874] = cos(x[0] - y[1]);
out[1875] = y[0]*sin(x[0] - y[1]);
out[1911] = y[0]*cos(x[0] - y[1]);
out[1923] = sin(x[0] - y[1]);
out[1924] = -y[0]*cos(x[0] - y[1]);
out[1960] = y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]);
out[1972] = y[26]*sin(x[0] - y[1]) + y[27]*cos(x[0] - y[1]);
out[1973] = -y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]);
out[1998] = y[0]*sin(x[0] - y[1]);
out[1999] = y[0]*cos(x[0] - y[1]);
out[2009] = -y[0]*y[26]*sin(x[0] - y[1]) - y[0]*y[27]*cos(x[0] - y[1]);
out[2021] = y[26]*cos(x[0] - y[1]) - y[27]*sin(x[0] - y[1]);
out[2022] = y[0]*y[26]*sin(x[0] - y[1]) + y[0]*y[27]*cos(x[0] - y[1]);
out[2047] = y[0]*cos(x[0] - y[1]);
out[2048] = -y[0]*sin(x[0] - y[1]);
out[2062] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   -p[69]
));
out[2063] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[70]
));
out[2104] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[69]
));
out[2264] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*(-p[82]/p[83] + 1)
));
out[2299] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*p[82]/p[83]
));

}

void de_jac_trap_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = 0.5*Dt*p[67] + 1;
out[1] = -0.5*Dt*p[57];
out[47] = 0.5*Dt*p[57];
out[50] = 0.25*p[65]*Dt/p[58] + 1;
out[93] = -0.25*Dt/p[58];
out[96] = -0.25*p[65]*Dt/p[58];
out[100] = 0.5*Dt/p[59] + 1;
out[136] = -0.5*Dt*(p[63] - p[61])/p[59];
out[140] = -0.5*Dt/p[59];
out[150] = 0.5*Dt/p[60] + 1;
out[186] = -0.5*Dt*(-p[64] + p[62])/p[60];
out[200] = 0.5*Dt/p[71] + 1;
out[208] = -0.5*Dt/p[71];
out[249] = -0.5*Dt*(p[69]*p[74] - 1);
out[250] = 0.5*Dt*p[70]*p[74] + 1;
out[287] = -0.5*Dt*p[74];
out[291] = -0.5*Dt*(-p[69]*p[74] + 1);
out[300] = 0.5*Dt/p[76] + 1;
out[337] = -0.5*Dt/p[76];
out[349] = -0.5*Dt/p[78];
out[350] = 0.5*Dt/p[78] + 1;
out[400] = 4.9999999999999998e-7*Dt + 1;
out[432] = 0.5*Dt*p[79];
out[442] = -0.5*Dt/p[81];
out[450] = 0.5*Dt/p[81] + 1;
out[500] = 0.5*Dt/p[83] + 1;
out[535] = -0.5*Dt/p[83];
out[586] = 0.5*Dt;
out[628] = -p[56]/p[0];
out[678] = -p[56]/p[0];
out[1900] = p[63];
out[1901] = p[66];
out[1949] = p[66];
out[1950] = -p[64];
out[2108] = -1/p[75];
out[2155] = p[68];
out[2162] = p[77]/p[78];
out[2163] = -p[77]/p[78] + 1;
out[2363] = p[87];
out[2399] = -p[86];

}

void de_jac_trap_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[550] = 1;
out[1864] = -1;
out[1914] = -1;
out[2000] = -1;
out[2050] = -1;
out[2100] = -1;
out[2115] = 1;
out[2150] = -1;
out[2200] = -1;
out[2206] = 1;
out[2214] = -1;
out[2250] = -1;
out[2300] = -1;
out[2304] = 1;
out[2350] = -1;
out[2400] = -1;

}

void sp_jac_trap_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[3] = -0.25*Dt*(-y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[5] = -0.25*Dt*(-y[26]*sin(x[0] - y[1]) - y[27]*cos(x[0] - y[1]))/p[58];
out[6] = -0.25*Dt*(y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]))/p[58];
out[7] = -0.25*Dt*(-2*p[66]*y[26] - y[0]*sin(x[0] - y[1]))/p[58];
out[8] = -0.25*Dt*(-2*p[66]*y[27] - y[0]*cos(x[0] - y[1]))/p[58];
out[34] = 2*y[0]*(p[1] + p[37]) + y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[35] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[36] = y[0]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[37] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[38] = y[0]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[39] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[41] = 2*y[0]*(-p[2] - p[38] - 1.0/2.0*p[3] - 1.0/2.0*p[39]) + y[2]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[22]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[42] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[43] = y[0]*(p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3]));
out[44] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[45] = y[0]*(p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23]));
out[46] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[48] = y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3]));
out[49] = y[0]*y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[50] = y[0]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + 2*y[2]*(p[1] + p[4]) + y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[51] = y[0]*y[2]*(-p[2]*cos(y[1] - y[3]) - p[1]*sin(y[1] - y[3])) + y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[52] = y[2]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[53] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[54] = y[2]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3]));
out[55] = y[0]*y[2]*(-p[2]*sin(y[1] - y[3]) + p[1]*cos(y[1] - y[3]));
out[56] = y[0]*(p[2]*cos(y[1] - y[3]) + p[1]*sin(y[1] - y[3])) + 2*y[2]*(-p[2] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[6]) + y[4]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[57] = y[0]*y[2]*(p[2]*sin(y[1] - y[3]) - p[1]*cos(y[1] - y[3])) + y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[58] = y[2]*(p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5]));
out[59] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[60] = y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5]));
out[61] = y[2]*y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[62] = y[2]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + 2*y[4]*(p[4] + p[7] + p[34]) + y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[63] = y[2]*y[4]*(-p[5]*cos(y[3] - y[5]) - p[4]*sin(y[3] - y[5])) + y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[64] = y[4]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[65] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[66] = y[4]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[67] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[68] = y[4]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5]));
out[69] = y[2]*y[4]*(-p[5]*sin(y[3] - y[5]) + p[4]*cos(y[3] - y[5]));
out[70] = y[2]*(p[5]*cos(y[3] - y[5]) + p[4]*sin(y[3] - y[5])) + 2*y[4]*(-p[5] - p[8] - p[35] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[36]) + y[6]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[14]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[71] = y[2]*y[4]*(p[5]*sin(y[3] - y[5]) - p[4]*cos(y[3] - y[5])) + y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[72] = y[4]*(p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7]));
out[73] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[74] = y[4]*(p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15]));
out[75] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[76] = y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7]));
out[77] = y[4]*y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[78] = y[4]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + 2*y[6]*(p[7] + p[10] + p[31]) + y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[79] = y[4]*y[6]*(-p[8]*cos(y[5] - y[7]) - p[7]*sin(y[5] - y[7])) + y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[80] = y[6]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[81] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[82] = y[6]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[83] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[84] = y[6]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7]));
out[85] = y[4]*y[6]*(-p[8]*sin(y[5] - y[7]) + p[7]*cos(y[5] - y[7]));
out[86] = y[4]*(p[8]*cos(y[5] - y[7]) + p[7]*sin(y[5] - y[7])) + 2*y[6]*(-p[8] - p[11] - p[32] - 1.0/2.0*p[9] - 1.0/2.0*p[12] - 1.0/2.0*p[33]) + y[8]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[20]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[87] = y[4]*y[6]*(p[8]*sin(y[5] - y[7]) - p[7]*cos(y[5] - y[7])) + y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[88] = y[6]*(p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9]));
out[89] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[90] = y[6]*(p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21]));
out[91] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[92] = y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9]));
out[93] = y[6]*y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[94] = y[6]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + 2*y[8]*(p[10] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[95] = y[6]*y[8]*(-p[11]*cos(y[7] - y[9]) - p[10]*sin(y[7] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[96] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[97] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[98] = y[8]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9]));
out[99] = y[6]*y[8]*(-p[11]*sin(y[7] - y[9]) + p[10]*cos(y[7] - y[9]));
out[100] = y[6]*(p[11]*cos(y[7] - y[9]) + p[10]*sin(y[7] - y[9])) + 2*y[8]*(-p[11] - p[14] - 1.0/2.0*p[12] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[101] = y[6]*y[8]*(p[11]*sin(y[7] - y[9]) - p[10]*cos(y[7] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[102] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[103] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[104] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[105] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[106] = y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[107] = y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[108] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[109] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[110] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[111] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[112] = y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[113] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[114] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[115] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[116] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[117] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[118] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + p[19]) + y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[119] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[120] = y[12]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[121] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[122] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[123] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[124] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - p[20] - 1.0/2.0*p[18] - 1.0/2.0*p[21]) + y[14]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[125] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[126] = y[12]*(p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15]));
out[127] = y[12]*y[14]*(p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[128] = y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15]));
out[129] = y[4]*y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[130] = y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15]));
out[131] = y[12]*y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[132] = y[4]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + 2*y[14]*(p[34] + p[19] + p[22]) + y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[133] = y[4]*y[14]*(-p[35]*cos(y[5] - y[15]) - p[34]*sin(y[5] - y[15])) + y[12]*y[14]*(-p[20]*cos(y[13] - y[15]) - p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[134] = y[14]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[135] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[136] = y[14]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15]));
out[137] = y[4]*y[14]*(-p[35]*sin(y[5] - y[15]) + p[34]*cos(y[5] - y[15]));
out[138] = y[14]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15]));
out[139] = y[12]*y[14]*(-p[20]*sin(y[13] - y[15]) + p[19]*cos(y[13] - y[15]));
out[140] = y[4]*(p[35]*cos(y[5] - y[15]) + p[34]*sin(y[5] - y[15])) + y[12]*(p[20]*cos(y[13] - y[15]) + p[19]*sin(y[13] - y[15])) + 2*y[14]*(-p[35] - p[20] - p[23] - 1.0/2.0*p[36] - 1.0/2.0*p[21] - 1.0/2.0*p[24]) + y[16]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[141] = y[4]*y[14]*(p[35]*sin(y[5] - y[15]) - p[34]*cos(y[5] - y[15])) + y[12]*y[14]*(p[20]*sin(y[13] - y[15]) - p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[142] = y[14]*(p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17]));
out[143] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[144] = y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17]));
out[145] = y[14]*y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[146] = y[14]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + 2*y[16]*(p[22] + p[25]) + y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[147] = y[14]*y[16]*(-p[23]*cos(y[15] - y[17]) - p[22]*sin(y[15] - y[17])) + y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[148] = y[16]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[149] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[150] = y[16]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17]));
out[151] = y[14]*y[16]*(-p[23]*sin(y[15] - y[17]) + p[22]*cos(y[15] - y[17]));
out[152] = y[14]*(p[23]*cos(y[15] - y[17]) + p[22]*sin(y[15] - y[17])) + 2*y[16]*(-p[23] - p[26] - 1.0/2.0*p[24] - 1.0/2.0*p[27]) + y[18]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[153] = y[14]*y[16]*(p[23]*sin(y[15] - y[17]) - p[22]*cos(y[15] - y[17])) + y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[154] = y[16]*(p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19]));
out[155] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[156] = y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19]));
out[157] = y[16]*y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[158] = y[16]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + 2*y[18]*(p[25] + p[28]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[159] = y[16]*y[18]*(-p[26]*cos(y[17] - y[19]) - p[25]*sin(y[17] - y[19])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[160] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[161] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[162] = y[18]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19]));
out[163] = y[16]*y[18]*(-p[26]*sin(y[17] - y[19]) + p[25]*cos(y[17] - y[19]));
out[164] = y[16]*(p[26]*cos(y[17] - y[19]) + p[25]*sin(y[17] - y[19])) + 2*y[18]*(-p[26] - p[29] - 1.0/2.0*p[27] - 1.0/2.0*p[30]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[165] = y[16]*y[18]*(p[26]*sin(y[17] - y[19]) - p[25]*cos(y[17] - y[19])) + y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[166] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[167] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[168] = y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21]));
out[169] = y[6]*y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[170] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[171] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[172] = y[6]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[31]);
out[173] = y[6]*y[20]*(-p[32]*cos(y[7] - y[21]) - p[31]*sin(y[7] - y[21])) + y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[174] = y[20]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21]));
out[175] = y[6]*y[20]*(-p[32]*sin(y[7] - y[21]) + p[31]*cos(y[7] - y[21]));
out[176] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[177] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[178] = y[6]*(p[32]*cos(y[7] - y[21]) + p[31]*sin(y[7] - y[21])) + y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[32] - 1.0/2.0*p[30] - 1.0/2.0*p[33]);
out[179] = y[6]*y[20]*(p[32]*sin(y[7] - y[21]) - p[31]*cos(y[7] - y[21])) + y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[180] = y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23]));
out[181] = y[0]*y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[182] = y[0]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + 2*y[22]*(p[37] + p[40]) + y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[183] = y[0]*y[22]*(-p[38]*cos(y[1] - y[23]) - p[37]*sin(y[1] - y[23])) + y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[184] = y[22]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[185] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[186] = y[22]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23]));
out[187] = y[0]*y[22]*(-p[38]*sin(y[1] - y[23]) + p[37]*cos(y[1] - y[23]));
out[188] = y[0]*(p[38]*cos(y[1] - y[23]) + p[37]*sin(y[1] - y[23])) + 2*y[22]*(-p[38] - p[41] - 1.0/2.0*p[39] - 1.0/2.0*p[42]) + y[24]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[189] = y[0]*y[22]*(p[38]*sin(y[1] - y[23]) - p[37]*cos(y[1] - y[23])) + y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[190] = y[22]*(p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[191] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[192] = y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[193] = y[22]*y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[194] = y[22]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25])) + 2*y[24]*p[40];
out[195] = y[22]*y[24]*(-p[41]*cos(y[23] - y[25]) - p[40]*sin(y[23] - y[25]));
out[196] = y[24]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25]));
out[197] = y[22]*y[24]*(-p[41]*sin(y[23] - y[25]) + p[40]*cos(y[23] - y[25]));
out[198] = y[22]*(p[41]*cos(y[23] - y[25]) + p[40]*sin(y[23] - y[25])) + 2*y[24]*(-p[41] - 1.0/2.0*p[42]);
out[199] = y[22]*y[24]*(p[41]*sin(y[23] - y[25]) - p[40]*cos(y[23] - y[25]));
out[200] = -y[0]*sin(x[0] - y[1]);
out[202] = cos(x[0] - y[1]);
out[203] = y[0]*sin(x[0] - y[1]);
out[206] = y[0]*cos(x[0] - y[1]);
out[208] = sin(x[0] - y[1]);
out[209] = -y[0]*cos(x[0] - y[1]);
out[212] = y[0]*y[26]*cos(x[0] - y[1]) - y[0]*y[27]*sin(x[0] - y[1]);
out[213] = y[26]*sin(x[0] - y[1]) + y[27]*cos(x[0] - y[1]);
out[214] = -y[0]*y[26]*cos(x[0] - y[1]) + y[0]*y[27]*sin(x[0] - y[1]);
out[215] = y[0]*sin(x[0] - y[1]);
out[216] = y[0]*cos(x[0] - y[1]);
out[218] = -y[0]*y[26]*sin(x[0] - y[1]) - y[0]*y[27]*cos(x[0] - y[1]);
out[219] = y[26]*cos(x[0] - y[1]) - y[27]*sin(x[0] - y[1]);
out[220] = y[0]*y[26]*sin(x[0] - y[1]) + y[0]*y[27]*cos(x[0] - y[1]);
out[221] = y[0]*cos(x[0] - y[1]);
out[222] = -y[0]*sin(x[0] - y[1]);
out[224] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   -p[69]
));
out[225] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[70]
));
out[227] = ((p[72] > p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5] || p[73] < p[69]*(-x[4] + y[34] + u[26]) + p[70]*x[5]) ? (
   0
)
: (
   p[69]
));
out[238] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*(-p[82]/p[83] + 1)
));
out[239] = ((p[85] < -p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10]) || p[85] < p[84]*(p[82]*(-x[10] + y[33])/p[83] + x[10])) ? (
   0
)
: (
   p[84]*p[82]/p[83]
));

}

void sp_jac_trap_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = 0.5*Dt*p[67] + 1;
out[1] = -0.5*Dt*p[57];
out[2] = 0.5*Dt*p[57];
out[4] = 0.25*p[65]*Dt/p[58] + 1;
out[9] = -0.25*Dt/p[58];
out[10] = -0.25*p[65]*Dt/p[58];
out[11] = 0.5*Dt/p[59] + 1;
out[12] = -0.5*Dt*(p[63] - p[61])/p[59];
out[13] = -0.5*Dt/p[59];
out[14] = 0.5*Dt/p[60] + 1;
out[15] = -0.5*Dt*(-p[64] + p[62])/p[60];
out[16] = 0.5*Dt/p[71] + 1;
out[17] = -0.5*Dt/p[71];
out[18] = -0.5*Dt*(p[69]*p[74] - 1);
out[19] = 0.5*Dt*p[70]*p[74] + 1;
out[20] = -0.5*Dt*p[74];
out[21] = -0.5*Dt*(-p[69]*p[74] + 1);
out[22] = 0.5*Dt/p[76] + 1;
out[23] = -0.5*Dt/p[76];
out[24] = -0.5*Dt/p[78];
out[25] = 0.5*Dt/p[78] + 1;
out[26] = 4.9999999999999998e-7*Dt + 1;
out[27] = 0.5*Dt*p[79];
out[28] = -0.5*Dt/p[81];
out[29] = 0.5*Dt/p[81] + 1;
out[30] = 0.5*Dt/p[83] + 1;
out[31] = -0.5*Dt/p[83];
out[33] = 0.5*Dt;
out[40] = -p[56]/p[0];
out[47] = -p[56]/p[0];
out[204] = p[63];
out[205] = p[66];
out[210] = p[66];
out[211] = -p[64];
out[228] = -1/p[75];
out[231] = p[68];
out[232] = p[77]/p[78];
out[233] = -p[77]/p[78] + 1;
out[243] = p[87];
out[244] = -p[86];

}

void sp_jac_trap_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[32] = 1;
out[201] = -1;
out[207] = -1;
out[217] = -1;
out[223] = -1;
out[226] = -1;
out[229] = 1;
out[230] = -1;
out[234] = -1;
out[235] = 1;
out[236] = -1;
out[237] = -1;
out[240] = -1;
out[241] = 1;
out[242] = -1;
out[245] = -1;

}



/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // void()(double *, double *, double *, double *, double *, double)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 6), // double *
/*  2 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  3 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  4 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  5 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static void _cffi_d_de_jac_ini_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_ini_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_ini_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_ini_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_ini_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_ini_num_eval _cffi_d_de_jac_ini_num_eval
#endif

static void _cffi_d_de_jac_ini_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_ini_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_ini_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_ini_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_ini_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_ini_up_eval _cffi_d_de_jac_ini_up_eval
#endif

static void _cffi_d_de_jac_ini_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_ini_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_ini_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_ini_xy_eval _cffi_d_de_jac_ini_xy_eval
#endif

static void _cffi_d_de_jac_run_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_run_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_run_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_run_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_run_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_run_num_eval _cffi_d_de_jac_run_num_eval
#endif

static void _cffi_d_de_jac_run_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_run_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_run_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_run_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_run_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_run_up_eval _cffi_d_de_jac_run_up_eval
#endif

static void _cffi_d_de_jac_run_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_run_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_run_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_run_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_run_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_run_xy_eval _cffi_d_de_jac_run_xy_eval
#endif

static void _cffi_d_de_jac_trap_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_trap_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_trap_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_trap_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_trap_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_trap_num_eval _cffi_d_de_jac_trap_num_eval
#endif

static void _cffi_d_de_jac_trap_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_trap_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_trap_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_trap_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_trap_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_trap_up_eval _cffi_d_de_jac_trap_up_eval
#endif

static void _cffi_d_de_jac_trap_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_trap_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_trap_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_trap_xy_eval _cffi_d_de_jac_trap_xy_eval
#endif

static void _cffi_d_f_ini_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  f_ini_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_f_ini_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "f_ini_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { f_ini_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_f_ini_eval _cffi_d_f_ini_eval
#endif

static void _cffi_d_f_run_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  f_run_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_f_run_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "f_run_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { f_run_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_f_run_eval _cffi_d_f_run_eval
#endif

static void _cffi_d_g_ini_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  g_ini_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_ini_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "g_ini_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_ini_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_ini_eval _cffi_d_g_ini_eval
#endif

static void _cffi_d_g_run_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  g_run_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_run_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "g_run_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_run_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_run_eval _cffi_d_g_run_eval
#endif

static void _cffi_d_h_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  h_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_h_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "h_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { h_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_h_eval _cffi_d_h_eval
#endif

static void _cffi_d_sp_jac_ini_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_num_eval _cffi_d_sp_jac_ini_num_eval
#endif

static void _cffi_d_sp_jac_ini_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_up_eval _cffi_d_sp_jac_ini_up_eval
#endif

static void _cffi_d_sp_jac_ini_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_xy_eval _cffi_d_sp_jac_ini_xy_eval
#endif

static void _cffi_d_sp_jac_run_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_run_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_run_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_run_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_run_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_run_num_eval _cffi_d_sp_jac_run_num_eval
#endif

static void _cffi_d_sp_jac_run_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_run_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_run_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_run_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_run_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_run_up_eval _cffi_d_sp_jac_run_up_eval
#endif

static void _cffi_d_sp_jac_run_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_run_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_run_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_run_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_run_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_run_xy_eval _cffi_d_sp_jac_run_xy_eval
#endif

static void _cffi_d_sp_jac_trap_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_trap_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_trap_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_trap_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_trap_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_trap_num_eval _cffi_d_sp_jac_trap_num_eval
#endif

static void _cffi_d_sp_jac_trap_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_trap_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_trap_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_trap_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_trap_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_trap_up_eval _cffi_d_sp_jac_trap_up_eval
#endif

static void _cffi_d_sp_jac_trap_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_trap_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_trap_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_trap_xy_eval _cffi_d_sp_jac_trap_xy_eval
#endif

static const struct _cffi_global_s _cffi_globals[] = {
  { "de_jac_ini_num_eval", (void *)_cffi_f_de_jac_ini_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_ini_num_eval },
  { "de_jac_ini_up_eval", (void *)_cffi_f_de_jac_ini_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_ini_up_eval },
  { "de_jac_ini_xy_eval", (void *)_cffi_f_de_jac_ini_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_ini_xy_eval },
  { "de_jac_run_num_eval", (void *)_cffi_f_de_jac_run_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_run_num_eval },
  { "de_jac_run_up_eval", (void *)_cffi_f_de_jac_run_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_run_up_eval },
  { "de_jac_run_xy_eval", (void *)_cffi_f_de_jac_run_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_run_xy_eval },
  { "de_jac_trap_num_eval", (void *)_cffi_f_de_jac_trap_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_trap_num_eval },
  { "de_jac_trap_up_eval", (void *)_cffi_f_de_jac_trap_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_trap_up_eval },
  { "de_jac_trap_xy_eval", (void *)_cffi_f_de_jac_trap_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_trap_xy_eval },
  { "f_ini_eval", (void *)_cffi_f_f_ini_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_f_ini_eval },
  { "f_run_eval", (void *)_cffi_f_f_run_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_f_run_eval },
  { "g_ini_eval", (void *)_cffi_f_g_ini_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_g_ini_eval },
  { "g_run_eval", (void *)_cffi_f_g_run_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_g_run_eval },
  { "h_eval", (void *)_cffi_f_h_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_h_eval },
  { "sp_jac_ini_num_eval", (void *)_cffi_f_sp_jac_ini_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_num_eval },
  { "sp_jac_ini_up_eval", (void *)_cffi_f_sp_jac_ini_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_up_eval },
  { "sp_jac_ini_xy_eval", (void *)_cffi_f_sp_jac_ini_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_xy_eval },
  { "sp_jac_run_num_eval", (void *)_cffi_f_sp_jac_run_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_run_num_eval },
  { "sp_jac_run_up_eval", (void *)_cffi_f_sp_jac_run_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_run_up_eval },
  { "sp_jac_run_xy_eval", (void *)_cffi_f_sp_jac_run_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_run_xy_eval },
  { "sp_jac_trap_num_eval", (void *)_cffi_f_sp_jac_trap_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_trap_num_eval },
  { "sp_jac_trap_up_eval", (void *)_cffi_f_sp_jac_trap_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_trap_up_eval },
  { "sp_jac_trap_xy_eval", (void *)_cffi_f_sp_jac_trap_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_trap_xy_eval },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  NULL,  /* no struct_unions */
  NULL,  /* no enums */
  NULL,  /* no typenames */
  23,  /* num_globals */
  0,  /* num_struct_unions */
  0,  /* num_enums */
  0,  /* num_typenames */
  NULL,  /* no includes */
  9,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit_cigre_eu_mv_lab_cffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit_cigre_eu_mv_lab_cffi(void) { return NULL; }
#  else
     initcigre_eu_mv_lab_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit_cigre_eu_mv_lab_cffi(void)
{
  return _cffi_init("cigre_eu_mv_lab_cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
initcigre_eu_mv_lab_cffi(void)
{
  _cffi_init("cigre_eu_mv_lab_cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
