#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

void jac_ini_xy_eval(double *jac_ini,double *x,double *y,double *u,double *p,double Dt){

jac_ini[105] = (1.0/2.0)*(-y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]))/p[44];
jac_ini[150] = (1.0/2.0)*(-y[22]*sin(x[0] - y[1]) - y[23]*cos(x[0] - y[1]))/p[44];
jac_ini[151] = (1.0/2.0)*(y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]))/p[44];
jac_ini[172] = (1.0/2.0)*(-2*p[52]*y[22] - y[0]*sin(x[0] - y[1]))/p[44];
jac_ini[173] = (1.0/2.0)*(-2*p[52]*y[23] - y[0]*cos(x[0] - y[1]))/p[44];
jac_ini[1271] = (1.0/2.0)*(-y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]))/p[74];
jac_ini[1307] = (1.0/2.0)*(-y[31]*sin(x[11] - y[3]) - y[32]*cos(x[11] - y[3]))/p[74];
jac_ini[1308] = (1.0/2.0)*(y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]))/p[74];
jac_ini[1336] = (1.0/2.0)*(-2*p[82]*y[31] - y[2]*sin(x[11] - y[3]))/p[74];
jac_ini[1337] = (1.0/2.0)*(-2*p[82]*y[32] - y[2]*cos(x[11] - y[3]))/p[74];
jac_ini[2437] = (1.0/2.0)*(-y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]))/p[104];
jac_ini[2464] = (1.0/2.0)*(-y[40]*sin(x[22] - y[5]) - y[41]*cos(x[22] - y[5]))/p[104];
jac_ini[2465] = (1.0/2.0)*(y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]))/p[104];
jac_ini[2500] = (1.0/2.0)*(-2*p[112]*y[40] - y[4]*sin(x[22] - y[5]))/p[104];
jac_ini[2501] = (1.0/2.0)*(-2*p[112]*y[41] - y[4]*cos(x[22] - y[5]))/p[104];
jac_ini[3603] = (1.0/2.0)*(-y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]))/p[134];
jac_ini[3621] = (1.0/2.0)*(-y[49]*sin(x[33] - y[7]) - y[50]*cos(x[33] - y[7]))/p[134];
jac_ini[3622] = (1.0/2.0)*(y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]))/p[134];
jac_ini[3664] = (1.0/2.0)*(-2*p[142]*y[49] - y[6]*sin(x[33] - y[7]))/p[134];
jac_ini[3665] = (1.0/2.0)*(-2*p[142]*y[50] - y[6]*cos(x[33] - y[7]))/p[134];
jac_ini[4770] = 2*y[0]*p[1] + y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
jac_ini[4771] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
jac_ini[4778] = y[0]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
jac_ini[4779] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
jac_ini[4875] = 2*y[0]*(-p[2] - 1.0/2.0*p[3]) + y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
jac_ini[4876] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
jac_ini[4883] = y[0]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
jac_ini[4884] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
jac_ini[4982] = 2*y[2]*p[4] + y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
jac_ini[4983] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
jac_ini[4990] = y[2]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
jac_ini[4991] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
jac_ini[5087] = 2*y[2]*(-p[5] - 1.0/2.0*p[6]) + y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
jac_ini[5088] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
jac_ini[5095] = y[2]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
jac_ini[5096] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
jac_ini[5194] = y[20]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5])) + 2*y[4]*p[7];
jac_ini[5195] = y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
jac_ini[5210] = y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
jac_ini[5211] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
jac_ini[5299] = y[20]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5])) + 2*y[4]*(-p[8] - 1.0/2.0*p[9]);
jac_ini[5300] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
jac_ini[5315] = y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
jac_ini[5316] = y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
jac_ini[5406] = y[18]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + 2*y[6]*p[10];
jac_ini[5407] = y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
jac_ini[5418] = y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
jac_ini[5419] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
jac_ini[5511] = y[18]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + 2*y[6]*(-p[11] - 1.0/2.0*p[12]);
jac_ini[5512] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
jac_ini[5523] = y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
jac_ini[5524] = y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
jac_ini[5610] = y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
jac_ini[5611] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
jac_ini[5618] = y[0]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + 2*y[8]*(p[1] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
jac_ini[5619] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
jac_ini[5620] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
jac_ini[5621] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
jac_ini[5715] = y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
jac_ini[5716] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
jac_ini[5723] = y[0]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9])) + 2*y[8]*(-p[2] - p[14] - 1.0/2.0*p[3] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
jac_ini[5724] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
jac_ini[5725] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
jac_ini[5726] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
jac_ini[5822] = y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
jac_ini[5823] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
jac_ini[5828] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
jac_ini[5829] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
jac_ini[5830] = y[2]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[4] + p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
jac_ini[5831] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
jac_ini[5832] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
jac_ini[5833] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
jac_ini[5927] = y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
jac_ini[5928] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
jac_ini[5933] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
jac_ini[5934] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
jac_ini[5935] = y[2]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11])) + y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[5] - p[14] - p[17] - 1.0/2.0*p[6] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
jac_ini[5936] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
jac_ini[5937] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
jac_ini[5938] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
jac_ini[6040] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
jac_ini[6041] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
jac_ini[6042] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + 2*p[19]) + y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
jac_ini[6043] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
jac_ini[6044] = y[12]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
jac_ini[6045] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
jac_ini[6145] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
jac_ini[6146] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
jac_ini[6147] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - 2*p[20] - 1.0/2.0*p[18] - p[21]) + y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
jac_ini[6148] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
jac_ini[6149] = y[12]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
jac_ini[6150] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
jac_ini[6252] = y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
jac_ini[6253] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
jac_ini[6254] = y[12]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + 2*y[14]*(2*p[19] + 2*p[22]) + y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
jac_ini[6255] = y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
jac_ini[6256] = y[14]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
jac_ini[6257] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
jac_ini[6357] = y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
jac_ini[6358] = y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
jac_ini[6359] = y[12]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15])) + 2*y[14]*(-2*p[20] - 2*p[23] - p[21] - p[24]) + y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
jac_ini[6360] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
jac_ini[6361] = y[14]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
jac_ini[6362] = y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
jac_ini[6464] = y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
jac_ini[6465] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
jac_ini[6466] = y[18]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17])) + 2*y[16]*(2*p[22] + p[25]);
jac_ini[6467] = y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
jac_ini[6468] = y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
jac_ini[6469] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
jac_ini[6569] = y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
jac_ini[6570] = y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
jac_ini[6571] = y[18]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17])) + y[14]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17])) + 2*y[16]*(-2*p[23] - p[26] - p[24] - 1.0/2.0*p[27]);
jac_ini[6572] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
jac_ini[6573] = y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
jac_ini[6574] = y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
jac_ini[6666] = y[18]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
jac_ini[6667] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
jac_ini[6676] = y[18]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
jac_ini[6677] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
jac_ini[6678] = 2*y[18]*(p[28] + p[10] + p[25]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
jac_ini[6679] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
jac_ini[6680] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
jac_ini[6681] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
jac_ini[6771] = y[18]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
jac_ini[6772] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
jac_ini[6781] = y[18]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
jac_ini[6782] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
jac_ini[6783] = 2*y[18]*(-p[29] - p[11] - p[26] - 1.0/2.0*p[30] - 1.0/2.0*p[12] - 1.0/2.0*p[27]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7])) + y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
jac_ini[6784] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
jac_ini[6785] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
jac_ini[6786] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
jac_ini[6874] = y[20]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
jac_ini[6875] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
jac_ini[6888] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
jac_ini[6889] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
jac_ini[6890] = y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[7]) + y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
jac_ini[6891] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
jac_ini[6979] = y[20]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
jac_ini[6980] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
jac_ini[6993] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
jac_ini[6994] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
jac_ini[6995] = y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[8] - 1.0/2.0*p[30] - 1.0/2.0*p[9]) + y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
jac_ini[6996] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
jac_ini[7035] = -y[0]*sin(x[0] - y[1]);
jac_ini[7080] = cos(x[0] - y[1]);
jac_ini[7081] = y[0]*sin(x[0] - y[1]);
jac_ini[7140] = y[0]*cos(x[0] - y[1]);
jac_ini[7185] = sin(x[0] - y[1]);
jac_ini[7186] = -y[0]*cos(x[0] - y[1]);
jac_ini[7245] = y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]);
jac_ini[7290] = y[22]*sin(x[0] - y[1]) + y[23]*cos(x[0] - y[1]);
jac_ini[7291] = -y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]);
jac_ini[7312] = y[0]*sin(x[0] - y[1]);
jac_ini[7313] = y[0]*cos(x[0] - y[1]);
jac_ini[7350] = -y[0]*y[22]*sin(x[0] - y[1]) - y[0]*y[23]*cos(x[0] - y[1]);
jac_ini[7395] = y[22]*cos(x[0] - y[1]) - y[23]*sin(x[0] - y[1]);
jac_ini[7396] = y[0]*y[22]*sin(x[0] - y[1]) + y[0]*y[23]*cos(x[0] - y[1]);
jac_ini[7417] = y[0]*cos(x[0] - y[1]);
jac_ini[7418] = -y[0]*sin(x[0] - y[1]);
if (p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) {
   jac_ini[7459] = 0;
}
else {
   jac_ini[7459] = -p[55];
}
if (p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) {
   jac_ini[7460] = 0;
}
else {
   jac_ini[7460] = p[56];
}
if (p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) {
   jac_ini[7530] = 0;
}
else {
   jac_ini[7530] = p[55];
}
if (p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) {
   jac_ini[7885] = 0;
}
else {
   jac_ini[7885] = p[70]*(-p[68]/p[69] + 1);
}
if (p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) {
   jac_ini[7949] = 0;
}
else {
   jac_ini[7949] = p[70]*p[68]/p[69];
}
jac_ini[7991] = -y[2]*sin(x[11] - y[3]);
jac_ini[8027] = cos(x[11] - y[3]);
jac_ini[8028] = y[2]*sin(x[11] - y[3]);
jac_ini[8096] = y[2]*cos(x[11] - y[3]);
jac_ini[8132] = sin(x[11] - y[3]);
jac_ini[8133] = -y[2]*cos(x[11] - y[3]);
jac_ini[8201] = y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]);
jac_ini[8237] = y[31]*sin(x[11] - y[3]) + y[32]*cos(x[11] - y[3]);
jac_ini[8238] = -y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]);
jac_ini[8266] = y[2]*sin(x[11] - y[3]);
jac_ini[8267] = y[2]*cos(x[11] - y[3]);
jac_ini[8306] = -y[2]*y[31]*sin(x[11] - y[3]) - y[2]*y[32]*cos(x[11] - y[3]);
jac_ini[8342] = y[31]*cos(x[11] - y[3]) - y[32]*sin(x[11] - y[3]);
jac_ini[8343] = y[2]*y[31]*sin(x[11] - y[3]) + y[2]*y[32]*cos(x[11] - y[3]);
jac_ini[8371] = y[2]*cos(x[11] - y[3]);
jac_ini[8372] = -y[2]*sin(x[11] - y[3]);
if (p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) {
   jac_ini[8415] = 0;
}
else {
   jac_ini[8415] = -p[85];
}
if (p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) {
   jac_ini[8416] = 0;
}
else {
   jac_ini[8416] = p[86];
}
if (p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) {
   jac_ini[8484] = 0;
}
else {
   jac_ini[8484] = p[85];
}
if (p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) {
   jac_ini[8841] = 0;
}
else {
   jac_ini[8841] = p[100]*(-p[98]/p[99] + 1);
}
if (p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) {
   jac_ini[8903] = 0;
}
else {
   jac_ini[8903] = p[100]*p[98]/p[99];
}
jac_ini[8947] = -y[4]*sin(x[22] - y[5]);
jac_ini[8974] = cos(x[22] - y[5]);
jac_ini[8975] = y[4]*sin(x[22] - y[5]);
jac_ini[9052] = y[4]*cos(x[22] - y[5]);
jac_ini[9079] = sin(x[22] - y[5]);
jac_ini[9080] = -y[4]*cos(x[22] - y[5]);
jac_ini[9157] = y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]);
jac_ini[9184] = y[40]*sin(x[22] - y[5]) + y[41]*cos(x[22] - y[5]);
jac_ini[9185] = -y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]);
jac_ini[9220] = y[4]*sin(x[22] - y[5]);
jac_ini[9221] = y[4]*cos(x[22] - y[5]);
jac_ini[9262] = -y[4]*y[40]*sin(x[22] - y[5]) - y[4]*y[41]*cos(x[22] - y[5]);
jac_ini[9289] = y[40]*cos(x[22] - y[5]) - y[41]*sin(x[22] - y[5]);
jac_ini[9290] = y[4]*y[40]*sin(x[22] - y[5]) + y[4]*y[41]*cos(x[22] - y[5]);
jac_ini[9325] = y[4]*cos(x[22] - y[5]);
jac_ini[9326] = -y[4]*sin(x[22] - y[5]);
if (p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) {
   jac_ini[9371] = 0;
}
else {
   jac_ini[9371] = -p[115];
}
if (p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) {
   jac_ini[9372] = 0;
}
else {
   jac_ini[9372] = p[116];
}
if (p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) {
   jac_ini[9438] = 0;
}
else {
   jac_ini[9438] = p[115];
}
if (p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) {
   jac_ini[9797] = 0;
}
else {
   jac_ini[9797] = p[130]*(-p[128]/p[129] + 1);
}
if (p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) {
   jac_ini[9857] = 0;
}
else {
   jac_ini[9857] = p[130]*p[128]/p[129];
}
jac_ini[9903] = -y[6]*sin(x[33] - y[7]);
jac_ini[9921] = cos(x[33] - y[7]);
jac_ini[9922] = y[6]*sin(x[33] - y[7]);
jac_ini[10008] = y[6]*cos(x[33] - y[7]);
jac_ini[10026] = sin(x[33] - y[7]);
jac_ini[10027] = -y[6]*cos(x[33] - y[7]);
jac_ini[10113] = y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]);
jac_ini[10131] = y[49]*sin(x[33] - y[7]) + y[50]*cos(x[33] - y[7]);
jac_ini[10132] = -y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]);
jac_ini[10174] = y[6]*sin(x[33] - y[7]);
jac_ini[10175] = y[6]*cos(x[33] - y[7]);
jac_ini[10218] = -y[6]*y[49]*sin(x[33] - y[7]) - y[6]*y[50]*cos(x[33] - y[7]);
jac_ini[10236] = y[49]*cos(x[33] - y[7]) - y[50]*sin(x[33] - y[7]);
jac_ini[10237] = y[6]*y[49]*sin(x[33] - y[7]) + y[6]*y[50]*cos(x[33] - y[7]);
jac_ini[10279] = y[6]*cos(x[33] - y[7]);
jac_ini[10280] = -y[6]*sin(x[33] - y[7]);
if (p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) {
   jac_ini[10327] = 0;
}
else {
   jac_ini[10327] = -p[145];
}
if (p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) {
   jac_ini[10328] = 0;
}
else {
   jac_ini[10328] = p[146];
}
if (p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) {
   jac_ini[10392] = 0;
}
else {
   jac_ini[10392] = p[145];
}
if (p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) {
   jac_ini[10753] = 0;
}
else {
   jac_ini[10753] = p[160]*(-p[158]/p[159] + 1);
}
if (p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) {
   jac_ini[10811] = 0;
}
else {
   jac_ini[10811] = p[160]*p[158]/p[159];
}

}

void jac_ini_up_eval(double *jac_ini,double *x,double *y,double *u,double *p,double Dt){

jac_ini[0] = -p[53];
jac_ini[1] = p[43];
jac_ini[103] = -p[43];
jac_ini[106] = -1.0/2.0*p[51]/p[44];
jac_ini[178] = (1.0/2.0)/p[44];
jac_ini[208] = (1.0/2.0)*p[51]/p[44];
jac_ini[212] = -1/p[45];
jac_ini[277] = (p[49] - p[47])/p[45];
jac_ini[281] = 1.0/p[45];
jac_ini[318] = -1/p[46];
jac_ini[383] = (-p[50] + p[48])/p[46];
jac_ini[424] = -1/p[57];
jac_ini[465] = 1.0/p[57];
jac_ini[529] = p[55]*p[60] - 1;
jac_ini[530] = -p[56]*p[60];
jac_ini[596] = p[60];
jac_ini[600] = -p[55]*p[60] + 1;
jac_ini[636] = -1/p[62];
jac_ini[702] = 1.0/p[62];
jac_ini[741] = 1.0/p[64];
jac_ini[742] = -1/p[64];
jac_ini[909] = -p[65];
jac_ini[946] = 1.0/p[67];
jac_ini[954] = -1/p[67];
jac_ini[1060] = -1/p[69];
jac_ini[1124] = 1.0/p[69];
jac_ini[1166] = -p[83];
jac_ini[1167] = p[73];
jac_ini[1258] = -p[73];
jac_ini[1272] = -1.0/2.0*p[81]/p[74];
jac_ini[1342] = (1.0/2.0)/p[74];
jac_ini[1363] = (1.0/2.0)*p[81]/p[74];
jac_ini[1378] = -1/p[75];
jac_ini[1441] = (p[79] - p[77])/p[75];
jac_ini[1445] = 1.0/p[75];
jac_ini[1484] = -1/p[76];
jac_ini[1547] = (-p[80] + p[78])/p[76];
jac_ini[1590] = -1/p[87];
jac_ini[1622] = 1.0/p[87];
jac_ini[1695] = p[85]*p[90] - 1;
jac_ini[1696] = -p[86]*p[90];
jac_ini[1760] = p[90];
jac_ini[1764] = -p[85]*p[90] + 1;
jac_ini[1802] = -1/p[92];
jac_ini[1866] = 1.0/p[92];
jac_ini[1907] = 1.0/p[94];
jac_ini[1908] = -1/p[94];
jac_ini[2073] = -p[95];
jac_ini[2112] = 1.0/p[97];
jac_ini[2120] = -1/p[97];
jac_ini[2226] = -1/p[99];
jac_ini[2288] = 1.0/p[99];
jac_ini[2332] = -p[113];
jac_ini[2333] = p[103];
jac_ini[2413] = -p[103];
jac_ini[2438] = -1.0/2.0*p[111]/p[104];
jac_ini[2506] = (1.0/2.0)/p[104];
jac_ini[2518] = (1.0/2.0)*p[111]/p[104];
jac_ini[2544] = -1/p[105];
jac_ini[2605] = (p[109] - p[107])/p[105];
jac_ini[2609] = 1.0/p[105];
jac_ini[2650] = -1/p[106];
jac_ini[2711] = (-p[110] + p[108])/p[106];
jac_ini[2756] = -1/p[117];
jac_ini[2779] = 1.0/p[117];
jac_ini[2861] = p[115]*p[120] - 1;
jac_ini[2862] = -p[116]*p[120];
jac_ini[2924] = p[120];
jac_ini[2928] = -p[115]*p[120] + 1;
jac_ini[2968] = -1/p[122];
jac_ini[3030] = 1.0/p[122];
jac_ini[3073] = 1.0/p[124];
jac_ini[3074] = -1/p[124];
jac_ini[3237] = -p[125];
jac_ini[3278] = 1.0/p[127];
jac_ini[3286] = -1/p[127];
jac_ini[3392] = -1/p[129];
jac_ini[3452] = 1.0/p[129];
jac_ini[3498] = -p[143];
jac_ini[3499] = p[133];
jac_ini[3568] = -p[133];
jac_ini[3604] = -1.0/2.0*p[141]/p[134];
jac_ini[3670] = (1.0/2.0)/p[134];
jac_ini[3673] = (1.0/2.0)*p[141]/p[134];
jac_ini[3710] = -1/p[135];
jac_ini[3769] = (p[139] - p[137])/p[135];
jac_ini[3773] = 1.0/p[135];
jac_ini[3816] = -1/p[136];
jac_ini[3875] = (-p[140] + p[138])/p[136];
jac_ini[3922] = -1/p[147];
jac_ini[3936] = 1.0/p[147];
jac_ini[4027] = p[145]*p[150] - 1;
jac_ini[4028] = -p[146]*p[150];
jac_ini[4088] = p[150];
jac_ini[4092] = -p[145]*p[150] + 1;
jac_ini[4134] = -1/p[152];
jac_ini[4194] = 1.0/p[152];
jac_ini[4239] = 1.0/p[154];
jac_ini[4240] = -1/p[154];
jac_ini[4401] = -p[155];
jac_ini[4444] = 1.0/p[157];
jac_ini[4452] = -1/p[157];
jac_ini[4558] = -1/p[159];
jac_ini[4616] = 1.0/p[159];
jac_ini[4794] = -p[42]/p[0];
jac_ini[4900] = -p[42]/p[0];
jac_ini[5013] = -p[72]/p[0];
jac_ini[5119] = -p[72]/p[0];
jac_ini[5232] = -p[102]/p[0];
jac_ini[5338] = -p[102]/p[0];
jac_ini[5451] = -p[132]/p[0];
jac_ini[5557] = -p[132]/p[0];
jac_ini[7102] = p[49];
jac_ini[7103] = p[52];
jac_ini[7207] = p[52];
jac_ini[7208] = -p[50];
jac_ini[7561] = -1/p[61];
jac_ini[7664] = p[54];
jac_ini[7671] = p[63]/p[64];
jac_ini[7672] = -p[63]/p[64] + 1;
jac_ini[8056] = p[79];
jac_ini[8057] = p[82];
jac_ini[8161] = p[82];
jac_ini[8162] = -p[80];
jac_ini[8517] = -1/p[91];
jac_ini[8609] = p[84];
jac_ini[8627] = p[93]/p[94];
jac_ini[8628] = -p[93]/p[94] + 1;
jac_ini[9010] = p[109];
jac_ini[9011] = p[112];
jac_ini[9115] = p[112];
jac_ini[9116] = -p[110];
jac_ini[9473] = -1/p[121];
jac_ini[9554] = p[114];
jac_ini[9583] = p[123]/p[124];
jac_ini[9584] = -p[123]/p[124] + 1;
jac_ini[9964] = p[139];
jac_ini[9965] = p[142];
jac_ini[10069] = p[142];
jac_ini[10070] = -p[140];
jac_ini[10429] = -1/p[151];
jac_ini[10499] = p[144];
jac_ini[10539] = p[153]/p[154];
jac_ini[10540] = -p[153]/p[154] + 1;
jac_ini[10816] = p[44]*p[42]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
jac_ini[10827] = p[74]*p[72]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
jac_ini[10838] = p[104]*p[102]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
jac_ini[10849] = p[134]*p[132]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
jac_ini[10964] = p[163];
jac_ini[11023] = -p[162];

}

void jac_ini_num_eval(double *jac_ini,double *x,double *y,double *u,double *p,double Dt){

jac_ini[848] = -9.9999999999999995e-7;
jac_ini[2014] = -9.9999999999999995e-7;
jac_ini[3180] = -9.9999999999999995e-7;
jac_ini[4346] = -9.9999999999999995e-7;
jac_ini[4723] = -1;
jac_ini[7037] = -1;
jac_ini[7143] = -1;
jac_ini[7314] = -1;
jac_ini[7420] = -1;
jac_ini[7526] = -1;
jac_ini[7568] = 1;
jac_ini[7632] = -1;
jac_ini[7738] = -1;
jac_ini[7771] = 1;
jac_ini[7779] = -1;
jac_ini[7844] = -1;
jac_ini[7950] = -1;
jac_ini[7993] = -1;
jac_ini[8099] = -1;
jac_ini[8268] = -1;
jac_ini[8374] = -1;
jac_ini[8480] = -1;
jac_ini[8524] = 1;
jac_ini[8586] = -1;
jac_ini[8692] = -1;
jac_ini[8727] = 1;
jac_ini[8735] = -1;
jac_ini[8798] = -1;
jac_ini[8904] = -1;
jac_ini[8949] = -1;
jac_ini[9055] = -1;
jac_ini[9222] = -1;
jac_ini[9328] = -1;
jac_ini[9434] = -1;
jac_ini[9480] = 1;
jac_ini[9540] = -1;
jac_ini[9646] = -1;
jac_ini[9683] = 1;
jac_ini[9691] = -1;
jac_ini[9752] = -1;
jac_ini[9858] = -1;
jac_ini[9905] = -1;
jac_ini[10011] = -1;
jac_ini[10176] = -1;
jac_ini[10282] = -1;
jac_ini[10388] = -1;
jac_ini[10436] = 1;
jac_ini[10494] = -1;
jac_ini[10600] = -1;
jac_ini[10639] = 1;
jac_ini[10647] = -1;
jac_ini[10706] = -1;
jac_ini[10812] = -1;
jac_ini[10918] = -1;
jac_ini[11024] = -1;

}

void sp_jac_ini_xy_eval(double *sp_jac_ini,double *x,double *y,double *u,double *p,double Dt){

sp_jac_ini[3] = (1.0/2.0)*(-y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]))/p[44];
sp_jac_ini[5] = (1.0/2.0)*(-y[22]*sin(x[0] - y[1]) - y[23]*cos(x[0] - y[1]))/p[44];
sp_jac_ini[6] = (1.0/2.0)*(y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]))/p[44];
sp_jac_ini[7] = (1.0/2.0)*(-2*p[52]*y[22] - y[0]*sin(x[0] - y[1]))/p[44];
sp_jac_ini[8] = (1.0/2.0)*(-2*p[52]*y[23] - y[0]*cos(x[0] - y[1]))/p[44];
sp_jac_ini[35] = (1.0/2.0)*(-y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]))/p[74];
sp_jac_ini[37] = (1.0/2.0)*(-y[31]*sin(x[11] - y[3]) - y[32]*cos(x[11] - y[3]))/p[74];
sp_jac_ini[38] = (1.0/2.0)*(y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]))/p[74];
sp_jac_ini[39] = (1.0/2.0)*(-2*p[82]*y[31] - y[2]*sin(x[11] - y[3]))/p[74];
sp_jac_ini[40] = (1.0/2.0)*(-2*p[82]*y[32] - y[2]*cos(x[11] - y[3]))/p[74];
sp_jac_ini[67] = (1.0/2.0)*(-y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]))/p[104];
sp_jac_ini[69] = (1.0/2.0)*(-y[40]*sin(x[22] - y[5]) - y[41]*cos(x[22] - y[5]))/p[104];
sp_jac_ini[70] = (1.0/2.0)*(y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]))/p[104];
sp_jac_ini[71] = (1.0/2.0)*(-2*p[112]*y[40] - y[4]*sin(x[22] - y[5]))/p[104];
sp_jac_ini[72] = (1.0/2.0)*(-2*p[112]*y[41] - y[4]*cos(x[22] - y[5]))/p[104];
sp_jac_ini[99] = (1.0/2.0)*(-y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]))/p[134];
sp_jac_ini[101] = (1.0/2.0)*(-y[49]*sin(x[33] - y[7]) - y[50]*cos(x[33] - y[7]))/p[134];
sp_jac_ini[102] = (1.0/2.0)*(y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]))/p[134];
sp_jac_ini[103] = (1.0/2.0)*(-2*p[142]*y[49] - y[6]*sin(x[33] - y[7]))/p[134];
sp_jac_ini[104] = (1.0/2.0)*(-2*p[142]*y[50] - y[6]*cos(x[33] - y[7]))/p[134];
sp_jac_ini[129] = 2*y[0]*p[1] + y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
sp_jac_ini[130] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
sp_jac_ini[131] = y[0]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
sp_jac_ini[132] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
sp_jac_ini[134] = 2*y[0]*(-p[2] - 1.0/2.0*p[3]) + y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
sp_jac_ini[135] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
sp_jac_ini[136] = y[0]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
sp_jac_ini[137] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
sp_jac_ini[139] = 2*y[2]*p[4] + y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
sp_jac_ini[140] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
sp_jac_ini[141] = y[2]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
sp_jac_ini[142] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
sp_jac_ini[144] = 2*y[2]*(-p[5] - 1.0/2.0*p[6]) + y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
sp_jac_ini[145] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
sp_jac_ini[146] = y[2]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
sp_jac_ini[147] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
sp_jac_ini[149] = y[20]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5])) + 2*y[4]*p[7];
sp_jac_ini[150] = y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
sp_jac_ini[151] = y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
sp_jac_ini[152] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
sp_jac_ini[154] = y[20]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5])) + 2*y[4]*(-p[8] - 1.0/2.0*p[9]);
sp_jac_ini[155] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
sp_jac_ini[156] = y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
sp_jac_ini[157] = y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
sp_jac_ini[159] = y[18]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + 2*y[6]*p[10];
sp_jac_ini[160] = y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
sp_jac_ini[161] = y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
sp_jac_ini[162] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
sp_jac_ini[164] = y[18]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + 2*y[6]*(-p[11] - 1.0/2.0*p[12]);
sp_jac_ini[165] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
sp_jac_ini[166] = y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
sp_jac_ini[167] = y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
sp_jac_ini[169] = y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
sp_jac_ini[170] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
sp_jac_ini[171] = y[0]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + 2*y[8]*(p[1] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
sp_jac_ini[172] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
sp_jac_ini[173] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
sp_jac_ini[174] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
sp_jac_ini[175] = y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
sp_jac_ini[176] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
sp_jac_ini[177] = y[0]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9])) + 2*y[8]*(-p[2] - p[14] - 1.0/2.0*p[3] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
sp_jac_ini[178] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
sp_jac_ini[179] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
sp_jac_ini[180] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
sp_jac_ini[181] = y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
sp_jac_ini[182] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
sp_jac_ini[183] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
sp_jac_ini[184] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
sp_jac_ini[185] = y[2]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[4] + p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
sp_jac_ini[186] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
sp_jac_ini[187] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
sp_jac_ini[188] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
sp_jac_ini[189] = y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
sp_jac_ini[190] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
sp_jac_ini[191] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
sp_jac_ini[192] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
sp_jac_ini[193] = y[2]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11])) + y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[5] - p[14] - p[17] - 1.0/2.0*p[6] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
sp_jac_ini[194] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
sp_jac_ini[195] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
sp_jac_ini[196] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
sp_jac_ini[197] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
sp_jac_ini[198] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
sp_jac_ini[199] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + 2*p[19]) + y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
sp_jac_ini[200] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
sp_jac_ini[201] = y[12]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
sp_jac_ini[202] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
sp_jac_ini[203] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
sp_jac_ini[204] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
sp_jac_ini[205] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - 2*p[20] - 1.0/2.0*p[18] - p[21]) + y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
sp_jac_ini[206] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
sp_jac_ini[207] = y[12]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
sp_jac_ini[208] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
sp_jac_ini[209] = y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
sp_jac_ini[210] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
sp_jac_ini[211] = y[12]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + 2*y[14]*(2*p[19] + 2*p[22]) + y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
sp_jac_ini[212] = y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
sp_jac_ini[213] = y[14]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
sp_jac_ini[214] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
sp_jac_ini[215] = y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
sp_jac_ini[216] = y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
sp_jac_ini[217] = y[12]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15])) + 2*y[14]*(-2*p[20] - 2*p[23] - p[21] - p[24]) + y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
sp_jac_ini[218] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
sp_jac_ini[219] = y[14]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
sp_jac_ini[220] = y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
sp_jac_ini[221] = y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
sp_jac_ini[222] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
sp_jac_ini[223] = y[18]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17])) + 2*y[16]*(2*p[22] + p[25]);
sp_jac_ini[224] = y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
sp_jac_ini[225] = y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
sp_jac_ini[226] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
sp_jac_ini[227] = y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
sp_jac_ini[228] = y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
sp_jac_ini[229] = y[18]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17])) + y[14]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17])) + 2*y[16]*(-2*p[23] - p[26] - p[24] - 1.0/2.0*p[27]);
sp_jac_ini[230] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
sp_jac_ini[231] = y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
sp_jac_ini[232] = y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
sp_jac_ini[233] = y[18]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
sp_jac_ini[234] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
sp_jac_ini[235] = y[18]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
sp_jac_ini[236] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
sp_jac_ini[237] = 2*y[18]*(p[28] + p[10] + p[25]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
sp_jac_ini[238] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
sp_jac_ini[239] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
sp_jac_ini[240] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
sp_jac_ini[241] = y[18]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
sp_jac_ini[242] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
sp_jac_ini[243] = y[18]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
sp_jac_ini[244] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
sp_jac_ini[245] = 2*y[18]*(-p[29] - p[11] - p[26] - 1.0/2.0*p[30] - 1.0/2.0*p[12] - 1.0/2.0*p[27]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7])) + y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
sp_jac_ini[246] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
sp_jac_ini[247] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
sp_jac_ini[248] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
sp_jac_ini[249] = y[20]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
sp_jac_ini[250] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
sp_jac_ini[251] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
sp_jac_ini[252] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
sp_jac_ini[253] = y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[7]) + y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
sp_jac_ini[254] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
sp_jac_ini[255] = y[20]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
sp_jac_ini[256] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
sp_jac_ini[257] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
sp_jac_ini[258] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
sp_jac_ini[259] = y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[8] - 1.0/2.0*p[30] - 1.0/2.0*p[9]) + y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
sp_jac_ini[260] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
sp_jac_ini[261] = -y[0]*sin(x[0] - y[1]);
sp_jac_ini[263] = cos(x[0] - y[1]);
sp_jac_ini[264] = y[0]*sin(x[0] - y[1]);
sp_jac_ini[267] = y[0]*cos(x[0] - y[1]);
sp_jac_ini[269] = sin(x[0] - y[1]);
sp_jac_ini[270] = -y[0]*cos(x[0] - y[1]);
sp_jac_ini[273] = y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]);
sp_jac_ini[274] = y[22]*sin(x[0] - y[1]) + y[23]*cos(x[0] - y[1]);
sp_jac_ini[275] = -y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]);
sp_jac_ini[276] = y[0]*sin(x[0] - y[1]);
sp_jac_ini[277] = y[0]*cos(x[0] - y[1]);
sp_jac_ini[279] = -y[0]*y[22]*sin(x[0] - y[1]) - y[0]*y[23]*cos(x[0] - y[1]);
sp_jac_ini[280] = y[22]*cos(x[0] - y[1]) - y[23]*sin(x[0] - y[1]);
sp_jac_ini[281] = y[0]*y[22]*sin(x[0] - y[1]) + y[0]*y[23]*cos(x[0] - y[1]);
sp_jac_ini[282] = y[0]*cos(x[0] - y[1]);
sp_jac_ini[283] = -y[0]*sin(x[0] - y[1]);
if (p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) {
   sp_jac_ini[285] = 0;
}
else {
   sp_jac_ini[285] = -p[55];
}
if (p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) {
   sp_jac_ini[286] = 0;
}
else {
   sp_jac_ini[286] = p[56];
}
if (p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) {
   sp_jac_ini[288] = 0;
}
else {
   sp_jac_ini[288] = p[55];
}
if (p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) {
   sp_jac_ini[299] = 0;
}
else {
   sp_jac_ini[299] = p[70]*(-p[68]/p[69] + 1);
}
if (p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) {
   sp_jac_ini[300] = 0;
}
else {
   sp_jac_ini[300] = p[70]*p[68]/p[69];
}
sp_jac_ini[302] = -y[2]*sin(x[11] - y[3]);
sp_jac_ini[304] = cos(x[11] - y[3]);
sp_jac_ini[305] = y[2]*sin(x[11] - y[3]);
sp_jac_ini[308] = y[2]*cos(x[11] - y[3]);
sp_jac_ini[310] = sin(x[11] - y[3]);
sp_jac_ini[311] = -y[2]*cos(x[11] - y[3]);
sp_jac_ini[314] = y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]);
sp_jac_ini[315] = y[31]*sin(x[11] - y[3]) + y[32]*cos(x[11] - y[3]);
sp_jac_ini[316] = -y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]);
sp_jac_ini[317] = y[2]*sin(x[11] - y[3]);
sp_jac_ini[318] = y[2]*cos(x[11] - y[3]);
sp_jac_ini[320] = -y[2]*y[31]*sin(x[11] - y[3]) - y[2]*y[32]*cos(x[11] - y[3]);
sp_jac_ini[321] = y[31]*cos(x[11] - y[3]) - y[32]*sin(x[11] - y[3]);
sp_jac_ini[322] = y[2]*y[31]*sin(x[11] - y[3]) + y[2]*y[32]*cos(x[11] - y[3]);
sp_jac_ini[323] = y[2]*cos(x[11] - y[3]);
sp_jac_ini[324] = -y[2]*sin(x[11] - y[3]);
if (p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) {
   sp_jac_ini[326] = 0;
}
else {
   sp_jac_ini[326] = -p[85];
}
if (p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) {
   sp_jac_ini[327] = 0;
}
else {
   sp_jac_ini[327] = p[86];
}
if (p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) {
   sp_jac_ini[329] = 0;
}
else {
   sp_jac_ini[329] = p[85];
}
if (p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) {
   sp_jac_ini[340] = 0;
}
else {
   sp_jac_ini[340] = p[100]*(-p[98]/p[99] + 1);
}
if (p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) {
   sp_jac_ini[341] = 0;
}
else {
   sp_jac_ini[341] = p[100]*p[98]/p[99];
}
sp_jac_ini[343] = -y[4]*sin(x[22] - y[5]);
sp_jac_ini[345] = cos(x[22] - y[5]);
sp_jac_ini[346] = y[4]*sin(x[22] - y[5]);
sp_jac_ini[349] = y[4]*cos(x[22] - y[5]);
sp_jac_ini[351] = sin(x[22] - y[5]);
sp_jac_ini[352] = -y[4]*cos(x[22] - y[5]);
sp_jac_ini[355] = y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]);
sp_jac_ini[356] = y[40]*sin(x[22] - y[5]) + y[41]*cos(x[22] - y[5]);
sp_jac_ini[357] = -y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]);
sp_jac_ini[358] = y[4]*sin(x[22] - y[5]);
sp_jac_ini[359] = y[4]*cos(x[22] - y[5]);
sp_jac_ini[361] = -y[4]*y[40]*sin(x[22] - y[5]) - y[4]*y[41]*cos(x[22] - y[5]);
sp_jac_ini[362] = y[40]*cos(x[22] - y[5]) - y[41]*sin(x[22] - y[5]);
sp_jac_ini[363] = y[4]*y[40]*sin(x[22] - y[5]) + y[4]*y[41]*cos(x[22] - y[5]);
sp_jac_ini[364] = y[4]*cos(x[22] - y[5]);
sp_jac_ini[365] = -y[4]*sin(x[22] - y[5]);
if (p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) {
   sp_jac_ini[367] = 0;
}
else {
   sp_jac_ini[367] = -p[115];
}
if (p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) {
   sp_jac_ini[368] = 0;
}
else {
   sp_jac_ini[368] = p[116];
}
if (p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) {
   sp_jac_ini[370] = 0;
}
else {
   sp_jac_ini[370] = p[115];
}
if (p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) {
   sp_jac_ini[381] = 0;
}
else {
   sp_jac_ini[381] = p[130]*(-p[128]/p[129] + 1);
}
if (p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) {
   sp_jac_ini[382] = 0;
}
else {
   sp_jac_ini[382] = p[130]*p[128]/p[129];
}
sp_jac_ini[384] = -y[6]*sin(x[33] - y[7]);
sp_jac_ini[386] = cos(x[33] - y[7]);
sp_jac_ini[387] = y[6]*sin(x[33] - y[7]);
sp_jac_ini[390] = y[6]*cos(x[33] - y[7]);
sp_jac_ini[392] = sin(x[33] - y[7]);
sp_jac_ini[393] = -y[6]*cos(x[33] - y[7]);
sp_jac_ini[396] = y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]);
sp_jac_ini[397] = y[49]*sin(x[33] - y[7]) + y[50]*cos(x[33] - y[7]);
sp_jac_ini[398] = -y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]);
sp_jac_ini[399] = y[6]*sin(x[33] - y[7]);
sp_jac_ini[400] = y[6]*cos(x[33] - y[7]);
sp_jac_ini[402] = -y[6]*y[49]*sin(x[33] - y[7]) - y[6]*y[50]*cos(x[33] - y[7]);
sp_jac_ini[403] = y[49]*cos(x[33] - y[7]) - y[50]*sin(x[33] - y[7]);
sp_jac_ini[404] = y[6]*y[49]*sin(x[33] - y[7]) + y[6]*y[50]*cos(x[33] - y[7]);
sp_jac_ini[405] = y[6]*cos(x[33] - y[7]);
sp_jac_ini[406] = -y[6]*sin(x[33] - y[7]);
if (p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) {
   sp_jac_ini[408] = 0;
}
else {
   sp_jac_ini[408] = -p[145];
}
if (p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) {
   sp_jac_ini[409] = 0;
}
else {
   sp_jac_ini[409] = p[146];
}
if (p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) {
   sp_jac_ini[411] = 0;
}
else {
   sp_jac_ini[411] = p[145];
}
if (p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) {
   sp_jac_ini[422] = 0;
}
else {
   sp_jac_ini[422] = p[160]*(-p[158]/p[159] + 1);
}
if (p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) {
   sp_jac_ini[423] = 0;
}
else {
   sp_jac_ini[423] = p[160]*p[158]/p[159];
}

}

void sp_jac_ini_up_eval(double *sp_jac_ini,double *x,double *y,double *u,double *p,double Dt){

sp_jac_ini[0] = -p[53];
sp_jac_ini[1] = p[43];
sp_jac_ini[2] = -p[43];
sp_jac_ini[4] = -1.0/2.0*p[51]/p[44];
sp_jac_ini[9] = (1.0/2.0)/p[44];
sp_jac_ini[10] = (1.0/2.0)*p[51]/p[44];
sp_jac_ini[11] = -1/p[45];
sp_jac_ini[12] = (p[49] - p[47])/p[45];
sp_jac_ini[13] = 1.0/p[45];
sp_jac_ini[14] = -1/p[46];
sp_jac_ini[15] = (-p[50] + p[48])/p[46];
sp_jac_ini[16] = -1/p[57];
sp_jac_ini[17] = 1.0/p[57];
sp_jac_ini[18] = p[55]*p[60] - 1;
sp_jac_ini[19] = -p[56]*p[60];
sp_jac_ini[20] = p[60];
sp_jac_ini[21] = -p[55]*p[60] + 1;
sp_jac_ini[22] = -1/p[62];
sp_jac_ini[23] = 1.0/p[62];
sp_jac_ini[24] = 1.0/p[64];
sp_jac_ini[25] = -1/p[64];
sp_jac_ini[27] = -p[65];
sp_jac_ini[28] = 1.0/p[67];
sp_jac_ini[29] = -1/p[67];
sp_jac_ini[30] = -1/p[69];
sp_jac_ini[31] = 1.0/p[69];
sp_jac_ini[32] = -p[83];
sp_jac_ini[33] = p[73];
sp_jac_ini[34] = -p[73];
sp_jac_ini[36] = -1.0/2.0*p[81]/p[74];
sp_jac_ini[41] = (1.0/2.0)/p[74];
sp_jac_ini[42] = (1.0/2.0)*p[81]/p[74];
sp_jac_ini[43] = -1/p[75];
sp_jac_ini[44] = (p[79] - p[77])/p[75];
sp_jac_ini[45] = 1.0/p[75];
sp_jac_ini[46] = -1/p[76];
sp_jac_ini[47] = (-p[80] + p[78])/p[76];
sp_jac_ini[48] = -1/p[87];
sp_jac_ini[49] = 1.0/p[87];
sp_jac_ini[50] = p[85]*p[90] - 1;
sp_jac_ini[51] = -p[86]*p[90];
sp_jac_ini[52] = p[90];
sp_jac_ini[53] = -p[85]*p[90] + 1;
sp_jac_ini[54] = -1/p[92];
sp_jac_ini[55] = 1.0/p[92];
sp_jac_ini[56] = 1.0/p[94];
sp_jac_ini[57] = -1/p[94];
sp_jac_ini[59] = -p[95];
sp_jac_ini[60] = 1.0/p[97];
sp_jac_ini[61] = -1/p[97];
sp_jac_ini[62] = -1/p[99];
sp_jac_ini[63] = 1.0/p[99];
sp_jac_ini[64] = -p[113];
sp_jac_ini[65] = p[103];
sp_jac_ini[66] = -p[103];
sp_jac_ini[68] = -1.0/2.0*p[111]/p[104];
sp_jac_ini[73] = (1.0/2.0)/p[104];
sp_jac_ini[74] = (1.0/2.0)*p[111]/p[104];
sp_jac_ini[75] = -1/p[105];
sp_jac_ini[76] = (p[109] - p[107])/p[105];
sp_jac_ini[77] = 1.0/p[105];
sp_jac_ini[78] = -1/p[106];
sp_jac_ini[79] = (-p[110] + p[108])/p[106];
sp_jac_ini[80] = -1/p[117];
sp_jac_ini[81] = 1.0/p[117];
sp_jac_ini[82] = p[115]*p[120] - 1;
sp_jac_ini[83] = -p[116]*p[120];
sp_jac_ini[84] = p[120];
sp_jac_ini[85] = -p[115]*p[120] + 1;
sp_jac_ini[86] = -1/p[122];
sp_jac_ini[87] = 1.0/p[122];
sp_jac_ini[88] = 1.0/p[124];
sp_jac_ini[89] = -1/p[124];
sp_jac_ini[91] = -p[125];
sp_jac_ini[92] = 1.0/p[127];
sp_jac_ini[93] = -1/p[127];
sp_jac_ini[94] = -1/p[129];
sp_jac_ini[95] = 1.0/p[129];
sp_jac_ini[96] = -p[143];
sp_jac_ini[97] = p[133];
sp_jac_ini[98] = -p[133];
sp_jac_ini[100] = -1.0/2.0*p[141]/p[134];
sp_jac_ini[105] = (1.0/2.0)/p[134];
sp_jac_ini[106] = (1.0/2.0)*p[141]/p[134];
sp_jac_ini[107] = -1/p[135];
sp_jac_ini[108] = (p[139] - p[137])/p[135];
sp_jac_ini[109] = 1.0/p[135];
sp_jac_ini[110] = -1/p[136];
sp_jac_ini[111] = (-p[140] + p[138])/p[136];
sp_jac_ini[112] = -1/p[147];
sp_jac_ini[113] = 1.0/p[147];
sp_jac_ini[114] = p[145]*p[150] - 1;
sp_jac_ini[115] = -p[146]*p[150];
sp_jac_ini[116] = p[150];
sp_jac_ini[117] = -p[145]*p[150] + 1;
sp_jac_ini[118] = -1/p[152];
sp_jac_ini[119] = 1.0/p[152];
sp_jac_ini[120] = 1.0/p[154];
sp_jac_ini[121] = -1/p[154];
sp_jac_ini[123] = -p[155];
sp_jac_ini[124] = 1.0/p[157];
sp_jac_ini[125] = -1/p[157];
sp_jac_ini[126] = -1/p[159];
sp_jac_ini[127] = 1.0/p[159];
sp_jac_ini[133] = -p[42]/p[0];
sp_jac_ini[138] = -p[42]/p[0];
sp_jac_ini[143] = -p[72]/p[0];
sp_jac_ini[148] = -p[72]/p[0];
sp_jac_ini[153] = -p[102]/p[0];
sp_jac_ini[158] = -p[102]/p[0];
sp_jac_ini[163] = -p[132]/p[0];
sp_jac_ini[168] = -p[132]/p[0];
sp_jac_ini[265] = p[49];
sp_jac_ini[266] = p[52];
sp_jac_ini[271] = p[52];
sp_jac_ini[272] = -p[50];
sp_jac_ini[289] = -1/p[61];
sp_jac_ini[292] = p[54];
sp_jac_ini[293] = p[63]/p[64];
sp_jac_ini[294] = -p[63]/p[64] + 1;
sp_jac_ini[306] = p[79];
sp_jac_ini[307] = p[82];
sp_jac_ini[312] = p[82];
sp_jac_ini[313] = -p[80];
sp_jac_ini[330] = -1/p[91];
sp_jac_ini[333] = p[84];
sp_jac_ini[334] = p[93]/p[94];
sp_jac_ini[335] = -p[93]/p[94] + 1;
sp_jac_ini[347] = p[109];
sp_jac_ini[348] = p[112];
sp_jac_ini[353] = p[112];
sp_jac_ini[354] = -p[110];
sp_jac_ini[371] = -1/p[121];
sp_jac_ini[374] = p[114];
sp_jac_ini[375] = p[123]/p[124];
sp_jac_ini[376] = -p[123]/p[124] + 1;
sp_jac_ini[388] = p[139];
sp_jac_ini[389] = p[142];
sp_jac_ini[394] = p[142];
sp_jac_ini[395] = -p[140];
sp_jac_ini[412] = -1/p[151];
sp_jac_ini[415] = p[144];
sp_jac_ini[416] = p[153]/p[154];
sp_jac_ini[417] = -p[153]/p[154] + 1;
sp_jac_ini[425] = p[44]*p[42]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
sp_jac_ini[426] = p[74]*p[72]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
sp_jac_ini[427] = p[104]*p[102]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
sp_jac_ini[428] = p[134]*p[132]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
sp_jac_ini[430] = p[163];
sp_jac_ini[431] = -p[162];

}

void sp_jac_ini_num_eval(double *sp_jac_ini,double *x,double *y,double *u,double *p,double Dt){

sp_jac_ini[26] = -9.9999999999999995e-7;
sp_jac_ini[58] = -9.9999999999999995e-7;
sp_jac_ini[90] = -9.9999999999999995e-7;
sp_jac_ini[122] = -9.9999999999999995e-7;
sp_jac_ini[128] = -1;
sp_jac_ini[262] = -1;
sp_jac_ini[268] = -1;
sp_jac_ini[278] = -1;
sp_jac_ini[284] = -1;
sp_jac_ini[287] = -1;
sp_jac_ini[290] = 1;
sp_jac_ini[291] = -1;
sp_jac_ini[295] = -1;
sp_jac_ini[296] = 1;
sp_jac_ini[297] = -1;
sp_jac_ini[298] = -1;
sp_jac_ini[301] = -1;
sp_jac_ini[303] = -1;
sp_jac_ini[309] = -1;
sp_jac_ini[319] = -1;
sp_jac_ini[325] = -1;
sp_jac_ini[328] = -1;
sp_jac_ini[331] = 1;
sp_jac_ini[332] = -1;
sp_jac_ini[336] = -1;
sp_jac_ini[337] = 1;
sp_jac_ini[338] = -1;
sp_jac_ini[339] = -1;
sp_jac_ini[342] = -1;
sp_jac_ini[344] = -1;
sp_jac_ini[350] = -1;
sp_jac_ini[360] = -1;
sp_jac_ini[366] = -1;
sp_jac_ini[369] = -1;
sp_jac_ini[372] = 1;
sp_jac_ini[373] = -1;
sp_jac_ini[377] = -1;
sp_jac_ini[378] = 1;
sp_jac_ini[379] = -1;
sp_jac_ini[380] = -1;
sp_jac_ini[383] = -1;
sp_jac_ini[385] = -1;
sp_jac_ini[391] = -1;
sp_jac_ini[401] = -1;
sp_jac_ini[407] = -1;
sp_jac_ini[410] = -1;
sp_jac_ini[413] = 1;
sp_jac_ini[414] = -1;
sp_jac_ini[418] = -1;
sp_jac_ini[419] = 1;
sp_jac_ini[420] = -1;
sp_jac_ini[421] = -1;
sp_jac_ini[424] = -1;
sp_jac_ini[429] = -1;
sp_jac_ini[432] = -1;

}



/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // void()(double *, double *, double *, double *, double *, double)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 6), // double *
/*  2 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  3 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  4 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  5 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static void _cffi_d_jac_ini_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  jac_ini_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_jac_ini_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "jac_ini_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { jac_ini_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_jac_ini_num_eval _cffi_d_jac_ini_num_eval
#endif

static void _cffi_d_jac_ini_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  jac_ini_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_jac_ini_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "jac_ini_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { jac_ini_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_jac_ini_up_eval _cffi_d_jac_ini_up_eval
#endif

static void _cffi_d_jac_ini_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  jac_ini_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_jac_ini_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "jac_ini_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { jac_ini_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_jac_ini_xy_eval _cffi_d_jac_ini_xy_eval
#endif

static void _cffi_d_sp_jac_ini_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_num_eval _cffi_d_sp_jac_ini_num_eval
#endif

static void _cffi_d_sp_jac_ini_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_up_eval _cffi_d_sp_jac_ini_up_eval
#endif

static void _cffi_d_sp_jac_ini_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_xy_eval _cffi_d_sp_jac_ini_xy_eval
#endif

static const struct _cffi_global_s _cffi_globals[] = {
  { "jac_ini_num_eval", (void *)_cffi_f_jac_ini_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_jac_ini_num_eval },
  { "jac_ini_up_eval", (void *)_cffi_f_jac_ini_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_jac_ini_up_eval },
  { "jac_ini_xy_eval", (void *)_cffi_f_jac_ini_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_jac_ini_xy_eval },
  { "sp_jac_ini_num_eval", (void *)_cffi_f_sp_jac_ini_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_num_eval },
  { "sp_jac_ini_up_eval", (void *)_cffi_f_sp_jac_ini_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_up_eval },
  { "sp_jac_ini_xy_eval", (void *)_cffi_f_sp_jac_ini_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_xy_eval },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  NULL,  /* no struct_unions */
  NULL,  /* no enums */
  NULL,  /* no typenames */
  6,  /* num_globals */
  0,  /* num_struct_unions */
  0,  /* num_enums */
  0,  /* num_typenames */
  NULL,  /* no includes */
  9,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit_jacs2(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit_jacs2(void) { return NULL; }
#  else
     initjacs2(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit_jacs2(void)
{
  return _cffi_init("jacs2", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
initjacs2(void)
{
  _cffi_init("jacs2", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
