#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

void de_jac_ini_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[433] = (1.0/2.0)*(-y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]))/p[44];
out[478] = (1.0/2.0)*(-y[22]*sin(x[0] - y[1]) - y[23]*cos(x[0] - y[1]))/p[44];
out[479] = (1.0/2.0)*(y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]))/p[44];
out[500] = (1.0/2.0)*(-2*p[52]*y[22] - y[0]*sin(x[0] - y[1]))/p[44];
out[501] = (1.0/2.0)*(-2*p[52]*y[23] - y[0]*cos(x[0] - y[1]))/p[44];
out[5207] = (1.0/2.0)*(-y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]))/p[74];
out[5243] = (1.0/2.0)*(-y[31]*sin(x[11] - y[3]) - y[32]*cos(x[11] - y[3]))/p[74];
out[5244] = (1.0/2.0)*(y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]))/p[74];
out[5272] = (1.0/2.0)*(-2*p[82]*y[31] - y[2]*sin(x[11] - y[3]))/p[74];
out[5273] = (1.0/2.0)*(-2*p[82]*y[32] - y[2]*cos(x[11] - y[3]))/p[74];
out[9981] = (1.0/2.0)*(-y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]))/p[104];
out[10008] = (1.0/2.0)*(-y[40]*sin(x[22] - y[5]) - y[41]*cos(x[22] - y[5]))/p[104];
out[10009] = (1.0/2.0)*(y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]))/p[104];
out[10044] = (1.0/2.0)*(-2*p[112]*y[40] - y[4]*sin(x[22] - y[5]))/p[104];
out[10045] = (1.0/2.0)*(-2*p[112]*y[41] - y[4]*cos(x[22] - y[5]))/p[104];
out[14755] = (1.0/2.0)*(-y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]))/p[134];
out[14773] = (1.0/2.0)*(-y[49]*sin(x[33] - y[7]) - y[50]*cos(x[33] - y[7]))/p[134];
out[14774] = (1.0/2.0)*(y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]))/p[134];
out[14816] = (1.0/2.0)*(-2*p[142]*y[49] - y[6]*sin(x[33] - y[7]))/p[134];
out[14817] = (1.0/2.0)*(-2*p[142]*y[50] - y[6]*cos(x[33] - y[7]))/p[134];
out[19530] = 2*y[0]*p[1] + y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[19531] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[19538] = y[0]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[19539] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[19963] = 2*y[0]*(-p[2] - 1.0/2.0*p[3]) + y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[19964] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[19971] = y[0]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[19972] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
out[20398] = 2*y[2]*p[4] + y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[20399] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[20406] = y[2]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[20407] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[20831] = 2*y[2]*(-p[5] - 1.0/2.0*p[6]) + y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[20832] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[20839] = y[2]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[20840] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
out[21266] = y[20]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5])) + 2*y[4]*p[7];
out[21267] = y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[21282] = y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[21283] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[21699] = y[20]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5])) + 2*y[4]*(-p[8] - 1.0/2.0*p[9]);
out[21700] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[21715] = y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[21716] = y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
out[22134] = y[18]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + 2*y[6]*p[10];
out[22135] = y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[22146] = y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[22147] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
out[22567] = y[18]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + 2*y[6]*(-p[11] - 1.0/2.0*p[12]);
out[22568] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[22579] = y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
out[22580] = y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
out[22994] = y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[22995] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[23002] = y[0]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + 2*y[8]*(p[1] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[23003] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[23004] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[23005] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[23427] = y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[23428] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
out[23435] = y[0]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9])) + 2*y[8]*(-p[2] - p[14] - 1.0/2.0*p[3] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[23436] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[23437] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[23438] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[23862] = y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[23863] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[23868] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[23869] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[23870] = y[2]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[4] + p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[23871] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[23872] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[23873] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[24295] = y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[24296] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
out[24301] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[24302] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[24303] = y[2]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11])) + y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[5] - p[14] - p[17] - 1.0/2.0*p[6] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[24304] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[24305] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[24306] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[24736] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[24737] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[24738] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + 2*p[19]) + y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[24739] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[24740] = y[12]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[24741] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[25169] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[25170] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[25171] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - 2*p[20] - 1.0/2.0*p[18] - p[21]) + y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[25172] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[25173] = y[12]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[25174] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
out[25604] = y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[25605] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[25606] = y[12]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + 2*y[14]*(2*p[19] + 2*p[22]) + y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[25607] = y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[25608] = y[14]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[25609] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[26037] = y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[26038] = y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
out[26039] = y[12]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15])) + 2*y[14]*(-2*p[20] - 2*p[23] - p[21] - p[24]) + y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[26040] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[26041] = y[14]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[26042] = y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
out[26472] = y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[26473] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[26474] = y[18]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17])) + 2*y[16]*(2*p[22] + p[25]);
out[26475] = y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[26476] = y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[26477] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[26905] = y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[26906] = y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
out[26907] = y[18]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17])) + y[14]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17])) + 2*y[16]*(-2*p[23] - p[26] - p[24] - 1.0/2.0*p[27]);
out[26908] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[26909] = y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[26910] = y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
out[27330] = y[18]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[27331] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[27340] = y[18]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[27341] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[27342] = 2*y[18]*(p[28] + p[10] + p[25]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[27343] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[27344] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[27345] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[27763] = y[18]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[27764] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
out[27773] = y[18]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[27774] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
out[27775] = 2*y[18]*(-p[29] - p[11] - p[26] - 1.0/2.0*p[30] - 1.0/2.0*p[12] - 1.0/2.0*p[27]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7])) + y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[27776] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[27777] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[27778] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[28194] = y[20]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[28195] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[28208] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[28209] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[28210] = y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[7]) + y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[28211] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[28627] = y[20]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[28628] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
out[28641] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[28642] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[28643] = y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[8] - 1.0/2.0*p[30] - 1.0/2.0*p[9]) + y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[28644] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[29011] = -y[0]*sin(x[0] - y[1]);
out[29056] = cos(x[0] - y[1]);
out[29057] = y[0]*sin(x[0] - y[1]);
out[29444] = y[0]*cos(x[0] - y[1]);
out[29489] = sin(x[0] - y[1]);
out[29490] = -y[0]*cos(x[0] - y[1]);
out[29877] = y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]);
out[29922] = y[22]*sin(x[0] - y[1]) + y[23]*cos(x[0] - y[1]);
out[29923] = -y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]);
out[29944] = y[0]*sin(x[0] - y[1]);
out[29945] = y[0]*cos(x[0] - y[1]);
out[30310] = -y[0]*y[22]*sin(x[0] - y[1]) - y[0]*y[23]*cos(x[0] - y[1]);
out[30355] = y[22]*cos(x[0] - y[1]) - y[23]*sin(x[0] - y[1]);
out[30356] = y[0]*y[22]*sin(x[0] - y[1]) + y[0]*y[23]*cos(x[0] - y[1]);
out[30377] = y[0]*cos(x[0] - y[1]);
out[30378] = -y[0]*sin(x[0] - y[1]);
out[30747] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   -p[55]
));
out[30748] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   p[56]
));
out[30818] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   p[55]
));
out[32485] = ((p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) ? (
   0
)
: (
   p[70]*(-p[68]/p[69] + 1)
));
out[32549] = ((p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) ? (
   0
)
: (
   p[70]*p[68]/p[69]
));
out[32919] = -y[2]*sin(x[11] - y[3]);
out[32955] = cos(x[11] - y[3]);
out[32956] = y[2]*sin(x[11] - y[3]);
out[33352] = y[2]*cos(x[11] - y[3]);
out[33388] = sin(x[11] - y[3]);
out[33389] = -y[2]*cos(x[11] - y[3]);
out[33785] = y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]);
out[33821] = y[31]*sin(x[11] - y[3]) + y[32]*cos(x[11] - y[3]);
out[33822] = -y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]);
out[33850] = y[2]*sin(x[11] - y[3]);
out[33851] = y[2]*cos(x[11] - y[3]);
out[34218] = -y[2]*y[31]*sin(x[11] - y[3]) - y[2]*y[32]*cos(x[11] - y[3]);
out[34254] = y[31]*cos(x[11] - y[3]) - y[32]*sin(x[11] - y[3]);
out[34255] = y[2]*y[31]*sin(x[11] - y[3]) + y[2]*y[32]*cos(x[11] - y[3]);
out[34283] = y[2]*cos(x[11] - y[3]);
out[34284] = -y[2]*sin(x[11] - y[3]);
out[34655] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   -p[85]
));
out[34656] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   p[86]
));
out[34724] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   p[85]
));
out[36393] = ((p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) ? (
   0
)
: (
   p[100]*(-p[98]/p[99] + 1)
));
out[36455] = ((p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) ? (
   0
)
: (
   p[100]*p[98]/p[99]
));
out[36827] = -y[4]*sin(x[22] - y[5]);
out[36854] = cos(x[22] - y[5]);
out[36855] = y[4]*sin(x[22] - y[5]);
out[37260] = y[4]*cos(x[22] - y[5]);
out[37287] = sin(x[22] - y[5]);
out[37288] = -y[4]*cos(x[22] - y[5]);
out[37693] = y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]);
out[37720] = y[40]*sin(x[22] - y[5]) + y[41]*cos(x[22] - y[5]);
out[37721] = -y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]);
out[37756] = y[4]*sin(x[22] - y[5]);
out[37757] = y[4]*cos(x[22] - y[5]);
out[38126] = -y[4]*y[40]*sin(x[22] - y[5]) - y[4]*y[41]*cos(x[22] - y[5]);
out[38153] = y[40]*cos(x[22] - y[5]) - y[41]*sin(x[22] - y[5]);
out[38154] = y[4]*y[40]*sin(x[22] - y[5]) + y[4]*y[41]*cos(x[22] - y[5]);
out[38189] = y[4]*cos(x[22] - y[5]);
out[38190] = -y[4]*sin(x[22] - y[5]);
out[38563] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   -p[115]
));
out[38564] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   p[116]
));
out[38630] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   p[115]
));
out[40301] = ((p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) ? (
   0
)
: (
   p[130]*(-p[128]/p[129] + 1)
));
out[40361] = ((p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) ? (
   0
)
: (
   p[130]*p[128]/p[129]
));
out[40735] = -y[6]*sin(x[33] - y[7]);
out[40753] = cos(x[33] - y[7]);
out[40754] = y[6]*sin(x[33] - y[7]);
out[41168] = y[6]*cos(x[33] - y[7]);
out[41186] = sin(x[33] - y[7]);
out[41187] = -y[6]*cos(x[33] - y[7]);
out[41601] = y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]);
out[41619] = y[49]*sin(x[33] - y[7]) + y[50]*cos(x[33] - y[7]);
out[41620] = -y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]);
out[41662] = y[6]*sin(x[33] - y[7]);
out[41663] = y[6]*cos(x[33] - y[7]);
out[42034] = -y[6]*y[49]*sin(x[33] - y[7]) - y[6]*y[50]*cos(x[33] - y[7]);
out[42052] = y[49]*cos(x[33] - y[7]) - y[50]*sin(x[33] - y[7]);
out[42053] = y[6]*y[49]*sin(x[33] - y[7]) + y[6]*y[50]*cos(x[33] - y[7]);
out[42095] = y[6]*cos(x[33] - y[7]);
out[42096] = -y[6]*sin(x[33] - y[7]);
out[42471] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   -p[145]
));
out[42472] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   p[146]
));
out[42536] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   p[145]
));
out[44209] = ((p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) ? (
   0
)
: (
   p[160]*(-p[158]/p[159] + 1)
));
out[44267] = ((p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) ? (
   0
)
: (
   p[160]*p[158]/p[159]
));

}

void de_jac_ini_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[53];
out[1] = p[43];
out[103] = -p[43];
out[434] = -1.0/2.0*p[51]/p[44];
out[506] = (1.0/2.0)/p[44];
out[536] = (1.0/2.0)*p[51]/p[44];
out[868] = -1/p[45];
out[933] = (p[49] - p[47])/p[45];
out[937] = 1.0/p[45];
out[1302] = -1/p[46];
out[1367] = (-p[50] + p[48])/p[46];
out[1736] = -1/p[57];
out[1777] = 1.0/p[57];
out[2169] = p[55]*p[60] - 1;
out[2170] = -p[56]*p[60];
out[2236] = p[60];
out[2240] = -p[55]*p[60] + 1;
out[2604] = -1/p[62];
out[2670] = 1.0/p[62];
out[3037] = 1.0/p[64];
out[3038] = -1/p[64];
out[3533] = -p[65];
out[3898] = 1.0/p[67];
out[3906] = -1/p[67];
out[4340] = -1/p[69];
out[4404] = 1.0/p[69];
out[4774] = -p[83];
out[4775] = p[73];
out[4866] = -p[73];
out[5208] = -1.0/2.0*p[81]/p[74];
out[5278] = (1.0/2.0)/p[74];
out[5299] = (1.0/2.0)*p[81]/p[74];
out[5642] = -1/p[75];
out[5705] = (p[79] - p[77])/p[75];
out[5709] = 1.0/p[75];
out[6076] = -1/p[76];
out[6139] = (-p[80] + p[78])/p[76];
out[6510] = -1/p[87];
out[6542] = 1.0/p[87];
out[6943] = p[85]*p[90] - 1;
out[6944] = -p[86]*p[90];
out[7008] = p[90];
out[7012] = -p[85]*p[90] + 1;
out[7378] = -1/p[92];
out[7442] = 1.0/p[92];
out[7811] = 1.0/p[94];
out[7812] = -1/p[94];
out[8305] = -p[95];
out[8672] = 1.0/p[97];
out[8680] = -1/p[97];
out[9114] = -1/p[99];
out[9176] = 1.0/p[99];
out[9548] = -p[113];
out[9549] = p[103];
out[9629] = -p[103];
out[9982] = -1.0/2.0*p[111]/p[104];
out[10050] = (1.0/2.0)/p[104];
out[10062] = (1.0/2.0)*p[111]/p[104];
out[10416] = -1/p[105];
out[10477] = (p[109] - p[107])/p[105];
out[10481] = 1.0/p[105];
out[10850] = -1/p[106];
out[10911] = (-p[110] + p[108])/p[106];
out[11284] = -1/p[117];
out[11307] = 1.0/p[117];
out[11717] = p[115]*p[120] - 1;
out[11718] = -p[116]*p[120];
out[11780] = p[120];
out[11784] = -p[115]*p[120] + 1;
out[12152] = -1/p[122];
out[12214] = 1.0/p[122];
out[12585] = 1.0/p[124];
out[12586] = -1/p[124];
out[13077] = -p[125];
out[13446] = 1.0/p[127];
out[13454] = -1/p[127];
out[13888] = -1/p[129];
out[13948] = 1.0/p[129];
out[14322] = -p[143];
out[14323] = p[133];
out[14392] = -p[133];
out[14756] = -1.0/2.0*p[141]/p[134];
out[14822] = (1.0/2.0)/p[134];
out[14825] = (1.0/2.0)*p[141]/p[134];
out[15190] = -1/p[135];
out[15249] = (p[139] - p[137])/p[135];
out[15253] = 1.0/p[135];
out[15624] = -1/p[136];
out[15683] = (-p[140] + p[138])/p[136];
out[16058] = -1/p[147];
out[16072] = 1.0/p[147];
out[16491] = p[145]*p[150] - 1;
out[16492] = -p[146]*p[150];
out[16552] = p[150];
out[16556] = -p[145]*p[150] + 1;
out[16926] = -1/p[152];
out[16986] = 1.0/p[152];
out[17359] = 1.0/p[154];
out[17360] = -1/p[154];
out[17849] = -p[155];
out[18220] = 1.0/p[157];
out[18228] = -1/p[157];
out[18662] = -1/p[159];
out[18720] = 1.0/p[159];
out[19554] = -p[42]/p[0];
out[19988] = -p[42]/p[0];
out[20429] = -p[72]/p[0];
out[20863] = -p[72]/p[0];
out[21304] = -p[102]/p[0];
out[21738] = -p[102]/p[0];
out[22179] = -p[132]/p[0];
out[22613] = -p[132]/p[0];
out[29078] = p[49];
out[29079] = p[52];
out[29511] = p[52];
out[29512] = -p[50];
out[31177] = -1/p[61];
out[31280] = p[54];
out[31615] = p[63]/p[64];
out[31616] = -p[63]/p[64] + 1;
out[32984] = p[79];
out[32985] = p[82];
out[33417] = p[82];
out[33418] = -p[80];
out[35085] = -1/p[91];
out[35177] = p[84];
out[35523] = p[93]/p[94];
out[35524] = -p[93]/p[94] + 1;
out[36890] = p[109];
out[36891] = p[112];
out[37323] = p[112];
out[37324] = -p[110];
out[38993] = -1/p[121];
out[39074] = p[114];
out[39431] = p[123]/p[124];
out[39432] = -p[123]/p[124] + 1;
out[40796] = p[139];
out[40797] = p[142];
out[41229] = p[142];
out[41230] = -p[140];
out[42901] = -1/p[151];
out[42971] = p[144];
out[43339] = p[153]/p[154];
out[43340] = -p[153]/p[154] + 1;
out[44600] = p[44]*p[42]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[44611] = p[74]*p[72]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[44622] = p[104]*p[102]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[44633] = p[134]*p[132]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[45076] = p[163];
out[45135] = -p[162];

}

void de_jac_ini_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[3472] = -9.9999999999999995e-7;
out[8246] = -9.9999999999999995e-7;
out[13020] = -9.9999999999999995e-7;
out[17794] = -9.9999999999999995e-7;
out[19155] = -1;
out[29013] = -1;
out[29447] = -1;
out[29946] = -1;
out[30380] = -1;
out[30814] = -1;
out[31184] = 1;
out[31248] = -1;
out[31682] = -1;
out[32043] = 1;
out[32051] = -1;
out[32116] = -1;
out[32550] = -1;
out[32921] = -1;
out[33355] = -1;
out[33852] = -1;
out[34286] = -1;
out[34720] = -1;
out[35092] = 1;
out[35154] = -1;
out[35588] = -1;
out[35951] = 1;
out[35959] = -1;
out[36022] = -1;
out[36456] = -1;
out[36829] = -1;
out[37263] = -1;
out[37758] = -1;
out[38192] = -1;
out[38626] = -1;
out[39000] = 1;
out[39060] = -1;
out[39494] = -1;
out[39859] = 1;
out[39867] = -1;
out[39928] = -1;
out[40362] = -1;
out[40737] = -1;
out[41171] = -1;
out[41664] = -1;
out[42098] = -1;
out[42532] = -1;
out[42908] = 1;
out[42966] = -1;
out[43400] = -1;
out[43767] = 1;
out[43775] = -1;
out[43834] = -1;
out[44268] = -1;
out[44702] = -1;
out[45136] = -1;

}

void sp_jac_ini_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[3] = (1.0/2.0)*(-y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]))/p[44];
out[5] = (1.0/2.0)*(-y[22]*sin(x[0] - y[1]) - y[23]*cos(x[0] - y[1]))/p[44];
out[6] = (1.0/2.0)*(y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]))/p[44];
out[7] = (1.0/2.0)*(-2*p[52]*y[22] - y[0]*sin(x[0] - y[1]))/p[44];
out[8] = (1.0/2.0)*(-2*p[52]*y[23] - y[0]*cos(x[0] - y[1]))/p[44];
out[35] = (1.0/2.0)*(-y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]))/p[74];
out[37] = (1.0/2.0)*(-y[31]*sin(x[11] - y[3]) - y[32]*cos(x[11] - y[3]))/p[74];
out[38] = (1.0/2.0)*(y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]))/p[74];
out[39] = (1.0/2.0)*(-2*p[82]*y[31] - y[2]*sin(x[11] - y[3]))/p[74];
out[40] = (1.0/2.0)*(-2*p[82]*y[32] - y[2]*cos(x[11] - y[3]))/p[74];
out[67] = (1.0/2.0)*(-y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]))/p[104];
out[69] = (1.0/2.0)*(-y[40]*sin(x[22] - y[5]) - y[41]*cos(x[22] - y[5]))/p[104];
out[70] = (1.0/2.0)*(y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]))/p[104];
out[71] = (1.0/2.0)*(-2*p[112]*y[40] - y[4]*sin(x[22] - y[5]))/p[104];
out[72] = (1.0/2.0)*(-2*p[112]*y[41] - y[4]*cos(x[22] - y[5]))/p[104];
out[99] = (1.0/2.0)*(-y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]))/p[134];
out[101] = (1.0/2.0)*(-y[49]*sin(x[33] - y[7]) - y[50]*cos(x[33] - y[7]))/p[134];
out[102] = (1.0/2.0)*(y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]))/p[134];
out[103] = (1.0/2.0)*(-2*p[142]*y[49] - y[6]*sin(x[33] - y[7]))/p[134];
out[104] = (1.0/2.0)*(-2*p[142]*y[50] - y[6]*cos(x[33] - y[7]))/p[134];
out[129] = 2*y[0]*p[1] + y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[130] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[131] = y[0]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[132] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[134] = 2*y[0]*(-p[2] - 1.0/2.0*p[3]) + y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[135] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[136] = y[0]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[137] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
out[139] = 2*y[2]*p[4] + y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[140] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[141] = y[2]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[142] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[144] = 2*y[2]*(-p[5] - 1.0/2.0*p[6]) + y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[145] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[146] = y[2]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[147] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
out[149] = y[20]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5])) + 2*y[4]*p[7];
out[150] = y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[151] = y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[152] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[154] = y[20]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5])) + 2*y[4]*(-p[8] - 1.0/2.0*p[9]);
out[155] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[156] = y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[157] = y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
out[159] = y[18]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + 2*y[6]*p[10];
out[160] = y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[161] = y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[162] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
out[164] = y[18]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + 2*y[6]*(-p[11] - 1.0/2.0*p[12]);
out[165] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[166] = y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
out[167] = y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
out[169] = y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[170] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[171] = y[0]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + 2*y[8]*(p[1] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[172] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[173] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[174] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[175] = y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[176] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
out[177] = y[0]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9])) + 2*y[8]*(-p[2] - p[14] - 1.0/2.0*p[3] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[178] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[179] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[180] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[181] = y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[182] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[183] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[184] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[185] = y[2]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[4] + p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[186] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[187] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[188] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[189] = y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[190] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
out[191] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[192] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[193] = y[2]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11])) + y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[5] - p[14] - p[17] - 1.0/2.0*p[6] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[194] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[195] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[196] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[197] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[198] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[199] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + 2*p[19]) + y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[200] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[201] = y[12]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[202] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[203] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[204] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[205] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - 2*p[20] - 1.0/2.0*p[18] - p[21]) + y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[206] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[207] = y[12]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[208] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
out[209] = y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[210] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[211] = y[12]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + 2*y[14]*(2*p[19] + 2*p[22]) + y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[212] = y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[213] = y[14]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[214] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[215] = y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[216] = y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
out[217] = y[12]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15])) + 2*y[14]*(-2*p[20] - 2*p[23] - p[21] - p[24]) + y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[218] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[219] = y[14]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[220] = y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
out[221] = y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[222] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[223] = y[18]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17])) + 2*y[16]*(2*p[22] + p[25]);
out[224] = y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[225] = y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[226] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[227] = y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[228] = y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
out[229] = y[18]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17])) + y[14]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17])) + 2*y[16]*(-2*p[23] - p[26] - p[24] - 1.0/2.0*p[27]);
out[230] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[231] = y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[232] = y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
out[233] = y[18]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[234] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[235] = y[18]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[236] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[237] = 2*y[18]*(p[28] + p[10] + p[25]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[238] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[239] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[240] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[241] = y[18]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[242] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
out[243] = y[18]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[244] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
out[245] = 2*y[18]*(-p[29] - p[11] - p[26] - 1.0/2.0*p[30] - 1.0/2.0*p[12] - 1.0/2.0*p[27]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7])) + y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[246] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[247] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[248] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[249] = y[20]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[250] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[251] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[252] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[253] = y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[7]) + y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[254] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[255] = y[20]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[256] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
out[257] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[258] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[259] = y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[8] - 1.0/2.0*p[30] - 1.0/2.0*p[9]) + y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[260] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[261] = -y[0]*sin(x[0] - y[1]);
out[263] = cos(x[0] - y[1]);
out[264] = y[0]*sin(x[0] - y[1]);
out[267] = y[0]*cos(x[0] - y[1]);
out[269] = sin(x[0] - y[1]);
out[270] = -y[0]*cos(x[0] - y[1]);
out[273] = y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]);
out[274] = y[22]*sin(x[0] - y[1]) + y[23]*cos(x[0] - y[1]);
out[275] = -y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]);
out[276] = y[0]*sin(x[0] - y[1]);
out[277] = y[0]*cos(x[0] - y[1]);
out[279] = -y[0]*y[22]*sin(x[0] - y[1]) - y[0]*y[23]*cos(x[0] - y[1]);
out[280] = y[22]*cos(x[0] - y[1]) - y[23]*sin(x[0] - y[1]);
out[281] = y[0]*y[22]*sin(x[0] - y[1]) + y[0]*y[23]*cos(x[0] - y[1]);
out[282] = y[0]*cos(x[0] - y[1]);
out[283] = -y[0]*sin(x[0] - y[1]);
out[285] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   -p[55]
));
out[286] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   p[56]
));
out[288] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   p[55]
));
out[299] = ((p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) ? (
   0
)
: (
   p[70]*(-p[68]/p[69] + 1)
));
out[300] = ((p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) ? (
   0
)
: (
   p[70]*p[68]/p[69]
));
out[302] = -y[2]*sin(x[11] - y[3]);
out[304] = cos(x[11] - y[3]);
out[305] = y[2]*sin(x[11] - y[3]);
out[308] = y[2]*cos(x[11] - y[3]);
out[310] = sin(x[11] - y[3]);
out[311] = -y[2]*cos(x[11] - y[3]);
out[314] = y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]);
out[315] = y[31]*sin(x[11] - y[3]) + y[32]*cos(x[11] - y[3]);
out[316] = -y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]);
out[317] = y[2]*sin(x[11] - y[3]);
out[318] = y[2]*cos(x[11] - y[3]);
out[320] = -y[2]*y[31]*sin(x[11] - y[3]) - y[2]*y[32]*cos(x[11] - y[3]);
out[321] = y[31]*cos(x[11] - y[3]) - y[32]*sin(x[11] - y[3]);
out[322] = y[2]*y[31]*sin(x[11] - y[3]) + y[2]*y[32]*cos(x[11] - y[3]);
out[323] = y[2]*cos(x[11] - y[3]);
out[324] = -y[2]*sin(x[11] - y[3]);
out[326] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   -p[85]
));
out[327] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   p[86]
));
out[329] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   p[85]
));
out[340] = ((p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) ? (
   0
)
: (
   p[100]*(-p[98]/p[99] + 1)
));
out[341] = ((p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) ? (
   0
)
: (
   p[100]*p[98]/p[99]
));
out[343] = -y[4]*sin(x[22] - y[5]);
out[345] = cos(x[22] - y[5]);
out[346] = y[4]*sin(x[22] - y[5]);
out[349] = y[4]*cos(x[22] - y[5]);
out[351] = sin(x[22] - y[5]);
out[352] = -y[4]*cos(x[22] - y[5]);
out[355] = y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]);
out[356] = y[40]*sin(x[22] - y[5]) + y[41]*cos(x[22] - y[5]);
out[357] = -y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]);
out[358] = y[4]*sin(x[22] - y[5]);
out[359] = y[4]*cos(x[22] - y[5]);
out[361] = -y[4]*y[40]*sin(x[22] - y[5]) - y[4]*y[41]*cos(x[22] - y[5]);
out[362] = y[40]*cos(x[22] - y[5]) - y[41]*sin(x[22] - y[5]);
out[363] = y[4]*y[40]*sin(x[22] - y[5]) + y[4]*y[41]*cos(x[22] - y[5]);
out[364] = y[4]*cos(x[22] - y[5]);
out[365] = -y[4]*sin(x[22] - y[5]);
out[367] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   -p[115]
));
out[368] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   p[116]
));
out[370] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   p[115]
));
out[381] = ((p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) ? (
   0
)
: (
   p[130]*(-p[128]/p[129] + 1)
));
out[382] = ((p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) ? (
   0
)
: (
   p[130]*p[128]/p[129]
));
out[384] = -y[6]*sin(x[33] - y[7]);
out[386] = cos(x[33] - y[7]);
out[387] = y[6]*sin(x[33] - y[7]);
out[390] = y[6]*cos(x[33] - y[7]);
out[392] = sin(x[33] - y[7]);
out[393] = -y[6]*cos(x[33] - y[7]);
out[396] = y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]);
out[397] = y[49]*sin(x[33] - y[7]) + y[50]*cos(x[33] - y[7]);
out[398] = -y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]);
out[399] = y[6]*sin(x[33] - y[7]);
out[400] = y[6]*cos(x[33] - y[7]);
out[402] = -y[6]*y[49]*sin(x[33] - y[7]) - y[6]*y[50]*cos(x[33] - y[7]);
out[403] = y[49]*cos(x[33] - y[7]) - y[50]*sin(x[33] - y[7]);
out[404] = y[6]*y[49]*sin(x[33] - y[7]) + y[6]*y[50]*cos(x[33] - y[7]);
out[405] = y[6]*cos(x[33] - y[7]);
out[406] = -y[6]*sin(x[33] - y[7]);
out[408] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   -p[145]
));
out[409] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   p[146]
));
out[411] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   p[145]
));
out[422] = ((p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) ? (
   0
)
: (
   p[160]*(-p[158]/p[159] + 1)
));
out[423] = ((p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) ? (
   0
)
: (
   p[160]*p[158]/p[159]
));

}

void sp_jac_ini_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[53];
out[1] = p[43];
out[2] = -p[43];
out[4] = -1.0/2.0*p[51]/p[44];
out[9] = (1.0/2.0)/p[44];
out[10] = (1.0/2.0)*p[51]/p[44];
out[11] = -1/p[45];
out[12] = (p[49] - p[47])/p[45];
out[13] = 1.0/p[45];
out[14] = -1/p[46];
out[15] = (-p[50] + p[48])/p[46];
out[16] = -1/p[57];
out[17] = 1.0/p[57];
out[18] = p[55]*p[60] - 1;
out[19] = -p[56]*p[60];
out[20] = p[60];
out[21] = -p[55]*p[60] + 1;
out[22] = -1/p[62];
out[23] = 1.0/p[62];
out[24] = 1.0/p[64];
out[25] = -1/p[64];
out[27] = -p[65];
out[28] = 1.0/p[67];
out[29] = -1/p[67];
out[30] = -1/p[69];
out[31] = 1.0/p[69];
out[32] = -p[83];
out[33] = p[73];
out[34] = -p[73];
out[36] = -1.0/2.0*p[81]/p[74];
out[41] = (1.0/2.0)/p[74];
out[42] = (1.0/2.0)*p[81]/p[74];
out[43] = -1/p[75];
out[44] = (p[79] - p[77])/p[75];
out[45] = 1.0/p[75];
out[46] = -1/p[76];
out[47] = (-p[80] + p[78])/p[76];
out[48] = -1/p[87];
out[49] = 1.0/p[87];
out[50] = p[85]*p[90] - 1;
out[51] = -p[86]*p[90];
out[52] = p[90];
out[53] = -p[85]*p[90] + 1;
out[54] = -1/p[92];
out[55] = 1.0/p[92];
out[56] = 1.0/p[94];
out[57] = -1/p[94];
out[59] = -p[95];
out[60] = 1.0/p[97];
out[61] = -1/p[97];
out[62] = -1/p[99];
out[63] = 1.0/p[99];
out[64] = -p[113];
out[65] = p[103];
out[66] = -p[103];
out[68] = -1.0/2.0*p[111]/p[104];
out[73] = (1.0/2.0)/p[104];
out[74] = (1.0/2.0)*p[111]/p[104];
out[75] = -1/p[105];
out[76] = (p[109] - p[107])/p[105];
out[77] = 1.0/p[105];
out[78] = -1/p[106];
out[79] = (-p[110] + p[108])/p[106];
out[80] = -1/p[117];
out[81] = 1.0/p[117];
out[82] = p[115]*p[120] - 1;
out[83] = -p[116]*p[120];
out[84] = p[120];
out[85] = -p[115]*p[120] + 1;
out[86] = -1/p[122];
out[87] = 1.0/p[122];
out[88] = 1.0/p[124];
out[89] = -1/p[124];
out[91] = -p[125];
out[92] = 1.0/p[127];
out[93] = -1/p[127];
out[94] = -1/p[129];
out[95] = 1.0/p[129];
out[96] = -p[143];
out[97] = p[133];
out[98] = -p[133];
out[100] = -1.0/2.0*p[141]/p[134];
out[105] = (1.0/2.0)/p[134];
out[106] = (1.0/2.0)*p[141]/p[134];
out[107] = -1/p[135];
out[108] = (p[139] - p[137])/p[135];
out[109] = 1.0/p[135];
out[110] = -1/p[136];
out[111] = (-p[140] + p[138])/p[136];
out[112] = -1/p[147];
out[113] = 1.0/p[147];
out[114] = p[145]*p[150] - 1;
out[115] = -p[146]*p[150];
out[116] = p[150];
out[117] = -p[145]*p[150] + 1;
out[118] = -1/p[152];
out[119] = 1.0/p[152];
out[120] = 1.0/p[154];
out[121] = -1/p[154];
out[123] = -p[155];
out[124] = 1.0/p[157];
out[125] = -1/p[157];
out[126] = -1/p[159];
out[127] = 1.0/p[159];
out[133] = -p[42]/p[0];
out[138] = -p[42]/p[0];
out[143] = -p[72]/p[0];
out[148] = -p[72]/p[0];
out[153] = -p[102]/p[0];
out[158] = -p[102]/p[0];
out[163] = -p[132]/p[0];
out[168] = -p[132]/p[0];
out[265] = p[49];
out[266] = p[52];
out[271] = p[52];
out[272] = -p[50];
out[289] = -1/p[61];
out[292] = p[54];
out[293] = p[63]/p[64];
out[294] = -p[63]/p[64] + 1;
out[306] = p[79];
out[307] = p[82];
out[312] = p[82];
out[313] = -p[80];
out[330] = -1/p[91];
out[333] = p[84];
out[334] = p[93]/p[94];
out[335] = -p[93]/p[94] + 1;
out[347] = p[109];
out[348] = p[112];
out[353] = p[112];
out[354] = -p[110];
out[371] = -1/p[121];
out[374] = p[114];
out[375] = p[123]/p[124];
out[376] = -p[123]/p[124] + 1;
out[388] = p[139];
out[389] = p[142];
out[394] = p[142];
out[395] = -p[140];
out[412] = -1/p[151];
out[415] = p[144];
out[416] = p[153]/p[154];
out[417] = -p[153]/p[154] + 1;
out[425] = p[44]*p[42]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[426] = p[74]*p[72]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[427] = p[104]*p[102]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[428] = p[134]*p[132]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[430] = p[163];
out[431] = -p[162];

}

void sp_jac_ini_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[26] = -9.9999999999999995e-7;
out[58] = -9.9999999999999995e-7;
out[90] = -9.9999999999999995e-7;
out[122] = -9.9999999999999995e-7;
out[128] = -1;
out[262] = -1;
out[268] = -1;
out[278] = -1;
out[284] = -1;
out[287] = -1;
out[290] = 1;
out[291] = -1;
out[295] = -1;
out[296] = 1;
out[297] = -1;
out[298] = -1;
out[301] = -1;
out[303] = -1;
out[309] = -1;
out[319] = -1;
out[325] = -1;
out[328] = -1;
out[331] = 1;
out[332] = -1;
out[336] = -1;
out[337] = 1;
out[338] = -1;
out[339] = -1;
out[342] = -1;
out[344] = -1;
out[350] = -1;
out[360] = -1;
out[366] = -1;
out[369] = -1;
out[372] = 1;
out[373] = -1;
out[377] = -1;
out[378] = 1;
out[379] = -1;
out[380] = -1;
out[383] = -1;
out[385] = -1;
out[391] = -1;
out[401] = -1;
out[407] = -1;
out[410] = -1;
out[413] = 1;
out[414] = -1;
out[418] = -1;
out[419] = 1;
out[420] = -1;
out[421] = -1;
out[424] = -1;
out[429] = -1;
out[432] = -1;

}

void de_jac_trap_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[434] = -0.25*Dt*(-y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]))/p[44];
out[479] = -0.25*Dt*(-y[22]*sin(x[0] - y[1]) - y[23]*cos(x[0] - y[1]))/p[44];
out[480] = -0.25*Dt*(y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]))/p[44];
out[501] = -0.25*Dt*(-2*p[52]*y[22] - y[0]*sin(x[0] - y[1]))/p[44];
out[502] = -0.25*Dt*(-2*p[52]*y[23] - y[0]*cos(x[0] - y[1]))/p[44];
out[5219] = -0.25*Dt*(-y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]))/p[74];
out[5255] = -0.25*Dt*(-y[31]*sin(x[11] - y[3]) - y[32]*cos(x[11] - y[3]))/p[74];
out[5256] = -0.25*Dt*(y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]))/p[74];
out[5284] = -0.25*Dt*(-2*p[82]*y[31] - y[2]*sin(x[11] - y[3]))/p[74];
out[5285] = -0.25*Dt*(-2*p[82]*y[32] - y[2]*cos(x[11] - y[3]))/p[74];
out[10004] = -0.25*Dt*(-y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]))/p[104];
out[10031] = -0.25*Dt*(-y[40]*sin(x[22] - y[5]) - y[41]*cos(x[22] - y[5]))/p[104];
out[10032] = -0.25*Dt*(y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]))/p[104];
out[10067] = -0.25*Dt*(-2*p[112]*y[40] - y[4]*sin(x[22] - y[5]))/p[104];
out[10068] = -0.25*Dt*(-2*p[112]*y[41] - y[4]*cos(x[22] - y[5]))/p[104];
out[14789] = -0.25*Dt*(-y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]))/p[134];
out[14807] = -0.25*Dt*(-y[49]*sin(x[33] - y[7]) - y[50]*cos(x[33] - y[7]))/p[134];
out[14808] = -0.25*Dt*(y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]))/p[134];
out[14850] = -0.25*Dt*(-2*p[142]*y[49] - y[6]*sin(x[33] - y[7]))/p[134];
out[14851] = -0.25*Dt*(-2*p[142]*y[50] - y[6]*cos(x[33] - y[7]))/p[134];
out[19575] = 2*y[0]*p[1] + y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[19576] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[19583] = y[0]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[19584] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[20009] = 2*y[0]*(-p[2] - 1.0/2.0*p[3]) + y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[20010] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[20017] = y[0]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[20018] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
out[20445] = 2*y[2]*p[4] + y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[20446] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[20453] = y[2]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[20454] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[20879] = 2*y[2]*(-p[5] - 1.0/2.0*p[6]) + y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[20880] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[20887] = y[2]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[20888] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
out[21315] = y[20]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5])) + 2*y[4]*p[7];
out[21316] = y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[21331] = y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[21332] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[21749] = y[20]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5])) + 2*y[4]*(-p[8] - 1.0/2.0*p[9]);
out[21750] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[21765] = y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[21766] = y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
out[22185] = y[18]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + 2*y[6]*p[10];
out[22186] = y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[22197] = y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[22198] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
out[22619] = y[18]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + 2*y[6]*(-p[11] - 1.0/2.0*p[12]);
out[22620] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[22631] = y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
out[22632] = y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
out[23047] = y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[23048] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[23055] = y[0]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + 2*y[8]*(p[1] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[23056] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[23057] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[23058] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[23481] = y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[23482] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
out[23489] = y[0]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9])) + 2*y[8]*(-p[2] - p[14] - 1.0/2.0*p[3] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[23490] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[23491] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[23492] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[23917] = y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[23918] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[23923] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[23924] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[23925] = y[2]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[4] + p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[23926] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[23927] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[23928] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[24351] = y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[24352] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
out[24357] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[24358] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[24359] = y[2]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11])) + y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[5] - p[14] - p[17] - 1.0/2.0*p[6] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[24360] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[24361] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[24362] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[24793] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[24794] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[24795] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + 2*p[19]) + y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[24796] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[24797] = y[12]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[24798] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[25227] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[25228] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[25229] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - 2*p[20] - 1.0/2.0*p[18] - p[21]) + y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[25230] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[25231] = y[12]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[25232] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
out[25663] = y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[25664] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[25665] = y[12]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + 2*y[14]*(2*p[19] + 2*p[22]) + y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[25666] = y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[25667] = y[14]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[25668] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[26097] = y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[26098] = y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
out[26099] = y[12]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15])) + 2*y[14]*(-2*p[20] - 2*p[23] - p[21] - p[24]) + y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[26100] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[26101] = y[14]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[26102] = y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
out[26533] = y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[26534] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[26535] = y[18]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17])) + 2*y[16]*(2*p[22] + p[25]);
out[26536] = y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[26537] = y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[26538] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[26967] = y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[26968] = y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
out[26969] = y[18]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17])) + y[14]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17])) + 2*y[16]*(-2*p[23] - p[26] - p[24] - 1.0/2.0*p[27]);
out[26970] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[26971] = y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[26972] = y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
out[27393] = y[18]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[27394] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[27403] = y[18]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[27404] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[27405] = 2*y[18]*(p[28] + p[10] + p[25]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[27406] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[27407] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[27408] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[27827] = y[18]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[27828] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
out[27837] = y[18]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[27838] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
out[27839] = 2*y[18]*(-p[29] - p[11] - p[26] - 1.0/2.0*p[30] - 1.0/2.0*p[12] - 1.0/2.0*p[27]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7])) + y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[27840] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[27841] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[27842] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[28259] = y[20]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[28260] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[28273] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[28274] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[28275] = y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[7]) + y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[28276] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[28693] = y[20]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[28694] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
out[28707] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[28708] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[28709] = y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[8] - 1.0/2.0*p[30] - 1.0/2.0*p[9]) + y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[28710] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[29078] = -y[0]*sin(x[0] - y[1]);
out[29123] = cos(x[0] - y[1]);
out[29124] = y[0]*sin(x[0] - y[1]);
out[29512] = y[0]*cos(x[0] - y[1]);
out[29557] = sin(x[0] - y[1]);
out[29558] = -y[0]*cos(x[0] - y[1]);
out[29946] = y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]);
out[29991] = y[22]*sin(x[0] - y[1]) + y[23]*cos(x[0] - y[1]);
out[29992] = -y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]);
out[30013] = y[0]*sin(x[0] - y[1]);
out[30014] = y[0]*cos(x[0] - y[1]);
out[30380] = -y[0]*y[22]*sin(x[0] - y[1]) - y[0]*y[23]*cos(x[0] - y[1]);
out[30425] = y[22]*cos(x[0] - y[1]) - y[23]*sin(x[0] - y[1]);
out[30426] = y[0]*y[22]*sin(x[0] - y[1]) + y[0]*y[23]*cos(x[0] - y[1]);
out[30447] = y[0]*cos(x[0] - y[1]);
out[30448] = -y[0]*sin(x[0] - y[1]);
out[30818] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   -p[55]
));
out[30819] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   p[56]
));
out[30889] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   p[55]
));
out[32560] = ((p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) ? (
   0
)
: (
   p[70]*(-p[68]/p[69] + 1)
));
out[32624] = ((p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) ? (
   0
)
: (
   p[70]*p[68]/p[69]
));
out[32995] = -y[2]*sin(x[11] - y[3]);
out[33031] = cos(x[11] - y[3]);
out[33032] = y[2]*sin(x[11] - y[3]);
out[33429] = y[2]*cos(x[11] - y[3]);
out[33465] = sin(x[11] - y[3]);
out[33466] = -y[2]*cos(x[11] - y[3]);
out[33863] = y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]);
out[33899] = y[31]*sin(x[11] - y[3]) + y[32]*cos(x[11] - y[3]);
out[33900] = -y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]);
out[33928] = y[2]*sin(x[11] - y[3]);
out[33929] = y[2]*cos(x[11] - y[3]);
out[34297] = -y[2]*y[31]*sin(x[11] - y[3]) - y[2]*y[32]*cos(x[11] - y[3]);
out[34333] = y[31]*cos(x[11] - y[3]) - y[32]*sin(x[11] - y[3]);
out[34334] = y[2]*y[31]*sin(x[11] - y[3]) + y[2]*y[32]*cos(x[11] - y[3]);
out[34362] = y[2]*cos(x[11] - y[3]);
out[34363] = -y[2]*sin(x[11] - y[3]);
out[34735] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   -p[85]
));
out[34736] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   p[86]
));
out[34804] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   p[85]
));
out[36477] = ((p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) ? (
   0
)
: (
   p[100]*(-p[98]/p[99] + 1)
));
out[36539] = ((p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) ? (
   0
)
: (
   p[100]*p[98]/p[99]
));
out[36912] = -y[4]*sin(x[22] - y[5]);
out[36939] = cos(x[22] - y[5]);
out[36940] = y[4]*sin(x[22] - y[5]);
out[37346] = y[4]*cos(x[22] - y[5]);
out[37373] = sin(x[22] - y[5]);
out[37374] = -y[4]*cos(x[22] - y[5]);
out[37780] = y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]);
out[37807] = y[40]*sin(x[22] - y[5]) + y[41]*cos(x[22] - y[5]);
out[37808] = -y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]);
out[37843] = y[4]*sin(x[22] - y[5]);
out[37844] = y[4]*cos(x[22] - y[5]);
out[38214] = -y[4]*y[40]*sin(x[22] - y[5]) - y[4]*y[41]*cos(x[22] - y[5]);
out[38241] = y[40]*cos(x[22] - y[5]) - y[41]*sin(x[22] - y[5]);
out[38242] = y[4]*y[40]*sin(x[22] - y[5]) + y[4]*y[41]*cos(x[22] - y[5]);
out[38277] = y[4]*cos(x[22] - y[5]);
out[38278] = -y[4]*sin(x[22] - y[5]);
out[38652] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   -p[115]
));
out[38653] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   p[116]
));
out[38719] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   p[115]
));
out[40394] = ((p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) ? (
   0
)
: (
   p[130]*(-p[128]/p[129] + 1)
));
out[40454] = ((p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) ? (
   0
)
: (
   p[130]*p[128]/p[129]
));
out[40829] = -y[6]*sin(x[33] - y[7]);
out[40847] = cos(x[33] - y[7]);
out[40848] = y[6]*sin(x[33] - y[7]);
out[41263] = y[6]*cos(x[33] - y[7]);
out[41281] = sin(x[33] - y[7]);
out[41282] = -y[6]*cos(x[33] - y[7]);
out[41697] = y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]);
out[41715] = y[49]*sin(x[33] - y[7]) + y[50]*cos(x[33] - y[7]);
out[41716] = -y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]);
out[41758] = y[6]*sin(x[33] - y[7]);
out[41759] = y[6]*cos(x[33] - y[7]);
out[42131] = -y[6]*y[49]*sin(x[33] - y[7]) - y[6]*y[50]*cos(x[33] - y[7]);
out[42149] = y[49]*cos(x[33] - y[7]) - y[50]*sin(x[33] - y[7]);
out[42150] = y[6]*y[49]*sin(x[33] - y[7]) + y[6]*y[50]*cos(x[33] - y[7]);
out[42192] = y[6]*cos(x[33] - y[7]);
out[42193] = -y[6]*sin(x[33] - y[7]);
out[42569] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   -p[145]
));
out[42570] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   p[146]
));
out[42634] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   p[145]
));
out[44311] = ((p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) ? (
   0
)
: (
   p[160]*(-p[158]/p[159] + 1)
));
out[44369] = ((p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) ? (
   0
)
: (
   p[160]*p[158]/p[159]
));

}

void de_jac_trap_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = 0.5*Dt*p[53] + 1;
out[1] = -0.5*Dt*p[43];
out[103] = 0.5*Dt*p[43];
out[435] = 0.25*p[51]*Dt/p[44] + 1;
out[507] = -0.25*Dt/p[44];
out[537] = -0.25*p[51]*Dt/p[44];
out[870] = 0.5*Dt/p[45] + 1;
out[935] = -0.5*Dt*(p[49] - p[47])/p[45];
out[939] = -0.5*Dt/p[45];
out[1305] = 0.5*Dt/p[46] + 1;
out[1370] = -0.5*Dt*(-p[50] + p[48])/p[46];
out[1740] = 0.5*Dt/p[57] + 1;
out[1781] = -0.5*Dt/p[57];
out[2174] = -0.5*Dt*(p[55]*p[60] - 1);
out[2175] = 0.5*Dt*p[56]*p[60] + 1;
out[2241] = -0.5*Dt*p[60];
out[2245] = -0.5*Dt*(-p[55]*p[60] + 1);
out[2610] = 0.5*Dt/p[62] + 1;
out[2676] = -0.5*Dt/p[62];
out[3044] = -0.5*Dt/p[64];
out[3045] = 0.5*Dt/p[64] + 1;
out[3480] = 4.9999999999999998e-7*Dt + 1;
out[3541] = 0.5*Dt*p[65];
out[3907] = -0.5*Dt/p[67];
out[3915] = 0.5*Dt/p[67] + 1;
out[4350] = 0.5*Dt/p[69] + 1;
out[4414] = -0.5*Dt/p[69];
out[4785] = 0.5*Dt*p[83] + 1;
out[4786] = -0.5*Dt*p[73];
out[4877] = 0.5*Dt*p[73];
out[5220] = 0.25*p[81]*Dt/p[74] + 1;
out[5290] = -0.25*Dt/p[74];
out[5311] = -0.25*p[81]*Dt/p[74];
out[5655] = 0.5*Dt/p[75] + 1;
out[5718] = -0.5*Dt*(p[79] - p[77])/p[75];
out[5722] = -0.5*Dt/p[75];
out[6090] = 0.5*Dt/p[76] + 1;
out[6153] = -0.5*Dt*(-p[80] + p[78])/p[76];
out[6525] = 0.5*Dt/p[87] + 1;
out[6557] = -0.5*Dt/p[87];
out[6959] = -0.5*Dt*(p[85]*p[90] - 1);
out[6960] = 0.5*Dt*p[86]*p[90] + 1;
out[7024] = -0.5*Dt*p[90];
out[7028] = -0.5*Dt*(-p[85]*p[90] + 1);
out[7395] = 0.5*Dt/p[92] + 1;
out[7459] = -0.5*Dt/p[92];
out[7829] = -0.5*Dt/p[94];
out[7830] = 0.5*Dt/p[94] + 1;
out[8265] = 4.9999999999999998e-7*Dt + 1;
out[8324] = 0.5*Dt*p[95];
out[8692] = -0.5*Dt/p[97];
out[8700] = 0.5*Dt/p[97] + 1;
out[9135] = 0.5*Dt/p[99] + 1;
out[9197] = -0.5*Dt/p[99];
out[9570] = 0.5*Dt*p[113] + 1;
out[9571] = -0.5*Dt*p[103];
out[9651] = 0.5*Dt*p[103];
out[10005] = 0.25*p[111]*Dt/p[104] + 1;
out[10073] = -0.25*Dt/p[104];
out[10085] = -0.25*p[111]*Dt/p[104];
out[10440] = 0.5*Dt/p[105] + 1;
out[10501] = -0.5*Dt*(p[109] - p[107])/p[105];
out[10505] = -0.5*Dt/p[105];
out[10875] = 0.5*Dt/p[106] + 1;
out[10936] = -0.5*Dt*(-p[110] + p[108])/p[106];
out[11310] = 0.5*Dt/p[117] + 1;
out[11333] = -0.5*Dt/p[117];
out[11744] = -0.5*Dt*(p[115]*p[120] - 1);
out[11745] = 0.5*Dt*p[116]*p[120] + 1;
out[11807] = -0.5*Dt*p[120];
out[11811] = -0.5*Dt*(-p[115]*p[120] + 1);
out[12180] = 0.5*Dt/p[122] + 1;
out[12242] = -0.5*Dt/p[122];
out[12614] = -0.5*Dt/p[124];
out[12615] = 0.5*Dt/p[124] + 1;
out[13050] = 4.9999999999999998e-7*Dt + 1;
out[13107] = 0.5*Dt*p[125];
out[13477] = -0.5*Dt/p[127];
out[13485] = 0.5*Dt/p[127] + 1;
out[13920] = 0.5*Dt/p[129] + 1;
out[13980] = -0.5*Dt/p[129];
out[14355] = 0.5*Dt*p[143] + 1;
out[14356] = -0.5*Dt*p[133];
out[14425] = 0.5*Dt*p[133];
out[14790] = 0.25*p[141]*Dt/p[134] + 1;
out[14856] = -0.25*Dt/p[134];
out[14859] = -0.25*p[141]*Dt/p[134];
out[15225] = 0.5*Dt/p[135] + 1;
out[15284] = -0.5*Dt*(p[139] - p[137])/p[135];
out[15288] = -0.5*Dt/p[135];
out[15660] = 0.5*Dt/p[136] + 1;
out[15719] = -0.5*Dt*(-p[140] + p[138])/p[136];
out[16095] = 0.5*Dt/p[147] + 1;
out[16109] = -0.5*Dt/p[147];
out[16529] = -0.5*Dt*(p[145]*p[150] - 1);
out[16530] = 0.5*Dt*p[146]*p[150] + 1;
out[16590] = -0.5*Dt*p[150];
out[16594] = -0.5*Dt*(-p[145]*p[150] + 1);
out[16965] = 0.5*Dt/p[152] + 1;
out[17025] = -0.5*Dt/p[152];
out[17399] = -0.5*Dt/p[154];
out[17400] = 0.5*Dt/p[154] + 1;
out[17835] = 4.9999999999999998e-7*Dt + 1;
out[17890] = 0.5*Dt*p[155];
out[18262] = -0.5*Dt/p[157];
out[18270] = 0.5*Dt/p[157] + 1;
out[18705] = 0.5*Dt/p[159] + 1;
out[18763] = -0.5*Dt/p[159];
out[19199] = 0.5*Dt;
out[19599] = -p[42]/p[0];
out[20034] = -p[42]/p[0];
out[20476] = -p[72]/p[0];
out[20911] = -p[72]/p[0];
out[21353] = -p[102]/p[0];
out[21788] = -p[102]/p[0];
out[22230] = -p[132]/p[0];
out[22665] = -p[132]/p[0];
out[29145] = p[49];
out[29146] = p[52];
out[29579] = p[52];
out[29580] = -p[50];
out[31249] = -1/p[61];
out[31352] = p[54];
out[31688] = p[63]/p[64];
out[31689] = -p[63]/p[64] + 1;
out[33060] = p[79];
out[33061] = p[82];
out[33494] = p[82];
out[33495] = -p[80];
out[35166] = -1/p[91];
out[35258] = p[84];
out[35605] = p[93]/p[94];
out[35606] = -p[93]/p[94] + 1;
out[36975] = p[109];
out[36976] = p[112];
out[37409] = p[112];
out[37410] = -p[110];
out[39083] = -1/p[121];
out[39164] = p[114];
out[39522] = p[123]/p[124];
out[39523] = -p[123]/p[124] + 1;
out[40890] = p[139];
out[40891] = p[142];
out[41324] = p[142];
out[41325] = -p[140];
out[43000] = -1/p[151];
out[43070] = p[144];
out[43439] = p[153]/p[154];
out[43440] = -p[153]/p[154] + 1;
out[44703] = p[44]*p[42]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[44714] = p[74]*p[72]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[44725] = p[104]*p[102]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[44736] = p[134]*p[132]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[45180] = p[163];
out[45239] = -p[162];

}

void de_jac_trap_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[19140] = 1;
out[29080] = -1;
out[29515] = -1;
out[30015] = -1;
out[30450] = -1;
out[30885] = -1;
out[31256] = 1;
out[31320] = -1;
out[31755] = -1;
out[32117] = 1;
out[32125] = -1;
out[32190] = -1;
out[32625] = -1;
out[32997] = -1;
out[33432] = -1;
out[33930] = -1;
out[34365] = -1;
out[34800] = -1;
out[35173] = 1;
out[35235] = -1;
out[35670] = -1;
out[36034] = 1;
out[36042] = -1;
out[36105] = -1;
out[36540] = -1;
out[36914] = -1;
out[37349] = -1;
out[37845] = -1;
out[38280] = -1;
out[38715] = -1;
out[39090] = 1;
out[39150] = -1;
out[39585] = -1;
out[39951] = 1;
out[39959] = -1;
out[40020] = -1;
out[40455] = -1;
out[40831] = -1;
out[41266] = -1;
out[41760] = -1;
out[42195] = -1;
out[42630] = -1;
out[43007] = 1;
out[43065] = -1;
out[43500] = -1;
out[43868] = 1;
out[43876] = -1;
out[43935] = -1;
out[44370] = -1;
out[44805] = -1;
out[45240] = -1;

}

void sp_jac_trap_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[3] = -0.25*Dt*(-y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]))/p[44];
out[5] = -0.25*Dt*(-y[22]*sin(x[0] - y[1]) - y[23]*cos(x[0] - y[1]))/p[44];
out[6] = -0.25*Dt*(y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]))/p[44];
out[7] = -0.25*Dt*(-2*p[52]*y[22] - y[0]*sin(x[0] - y[1]))/p[44];
out[8] = -0.25*Dt*(-2*p[52]*y[23] - y[0]*cos(x[0] - y[1]))/p[44];
out[35] = -0.25*Dt*(-y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]))/p[74];
out[37] = -0.25*Dt*(-y[31]*sin(x[11] - y[3]) - y[32]*cos(x[11] - y[3]))/p[74];
out[38] = -0.25*Dt*(y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]))/p[74];
out[39] = -0.25*Dt*(-2*p[82]*y[31] - y[2]*sin(x[11] - y[3]))/p[74];
out[40] = -0.25*Dt*(-2*p[82]*y[32] - y[2]*cos(x[11] - y[3]))/p[74];
out[67] = -0.25*Dt*(-y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]))/p[104];
out[69] = -0.25*Dt*(-y[40]*sin(x[22] - y[5]) - y[41]*cos(x[22] - y[5]))/p[104];
out[70] = -0.25*Dt*(y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]))/p[104];
out[71] = -0.25*Dt*(-2*p[112]*y[40] - y[4]*sin(x[22] - y[5]))/p[104];
out[72] = -0.25*Dt*(-2*p[112]*y[41] - y[4]*cos(x[22] - y[5]))/p[104];
out[99] = -0.25*Dt*(-y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]))/p[134];
out[101] = -0.25*Dt*(-y[49]*sin(x[33] - y[7]) - y[50]*cos(x[33] - y[7]))/p[134];
out[102] = -0.25*Dt*(y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]))/p[134];
out[103] = -0.25*Dt*(-2*p[142]*y[49] - y[6]*sin(x[33] - y[7]))/p[134];
out[104] = -0.25*Dt*(-2*p[142]*y[50] - y[6]*cos(x[33] - y[7]))/p[134];
out[130] = 2*y[0]*p[1] + y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[131] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[132] = y[0]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[133] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[135] = 2*y[0]*(-p[2] - 1.0/2.0*p[3]) + y[8]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[136] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[137] = y[0]*(p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9]));
out[138] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
out[140] = 2*y[2]*p[4] + y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[141] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[142] = y[2]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[143] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[145] = 2*y[2]*(-p[5] - 1.0/2.0*p[6]) + y[10]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[146] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[147] = y[2]*(p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11]));
out[148] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
out[150] = y[20]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5])) + 2*y[4]*p[7];
out[151] = y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[152] = y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[153] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[155] = y[20]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5])) + 2*y[4]*(-p[8] - 1.0/2.0*p[9]);
out[156] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[157] = y[4]*(p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[158] = y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
out[160] = y[18]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + 2*y[6]*p[10];
out[161] = y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[162] = y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[163] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
out[165] = y[18]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + 2*y[6]*(-p[11] - 1.0/2.0*p[12]);
out[166] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[167] = y[6]*(p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7]));
out[168] = y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
out[170] = y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9]));
out[171] = y[0]*y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[172] = y[0]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + 2*y[8]*(p[1] + p[13]) + y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[173] = y[0]*y[8]*(-p[2]*cos(y[1] - y[9]) - p[1]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[174] = y[8]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[175] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[176] = y[8]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9]));
out[177] = y[0]*y[8]*(-p[2]*sin(y[1] - y[9]) + p[1]*cos(y[1] - y[9]));
out[178] = y[0]*(p[2]*cos(y[1] - y[9]) + p[1]*sin(y[1] - y[9])) + 2*y[8]*(-p[2] - p[14] - 1.0/2.0*p[3] - 1.0/2.0*p[15]) + y[10]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[179] = y[0]*y[8]*(p[2]*sin(y[1] - y[9]) - p[1]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[180] = y[8]*(p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11]));
out[181] = y[8]*y[10]*(p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[182] = y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11]));
out[183] = y[2]*y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[184] = y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11]));
out[185] = y[8]*y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[186] = y[2]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + 2*y[10]*(p[4] + p[13] + p[16]) + y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[187] = y[2]*y[10]*(-p[5]*cos(y[3] - y[11]) - p[4]*sin(y[3] - y[11])) + y[8]*y[10]*(-p[14]*cos(y[9] - y[11]) - p[13]*sin(y[9] - y[11])) + y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[188] = y[10]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[189] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[190] = y[10]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11]));
out[191] = y[2]*y[10]*(-p[5]*sin(y[3] - y[11]) + p[4]*cos(y[3] - y[11]));
out[192] = y[10]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11]));
out[193] = y[8]*y[10]*(-p[14]*sin(y[9] - y[11]) + p[13]*cos(y[9] - y[11]));
out[194] = y[2]*(p[5]*cos(y[3] - y[11]) + p[4]*sin(y[3] - y[11])) + y[8]*(p[14]*cos(y[9] - y[11]) + p[13]*sin(y[9] - y[11])) + 2*y[10]*(-p[5] - p[14] - p[17] - 1.0/2.0*p[6] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[12]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[195] = y[2]*y[10]*(p[5]*sin(y[3] - y[11]) - p[4]*cos(y[3] - y[11])) + y[8]*y[10]*(p[14]*sin(y[9] - y[11]) - p[13]*cos(y[9] - y[11])) + y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[196] = y[10]*(p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13]));
out[197] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[198] = y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13]));
out[199] = y[10]*y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[200] = y[10]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + 2*y[12]*(p[16] + 2*p[19]) + y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[201] = y[10]*y[12]*(-p[17]*cos(y[11] - y[13]) - p[16]*sin(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[202] = y[12]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[203] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[204] = y[12]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13]));
out[205] = y[10]*y[12]*(-p[17]*sin(y[11] - y[13]) + p[16]*cos(y[11] - y[13]));
out[206] = y[10]*(p[17]*cos(y[11] - y[13]) + p[16]*sin(y[11] - y[13])) + 2*y[12]*(-p[17] - 2*p[20] - 1.0/2.0*p[18] - p[21]) + y[14]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[207] = y[10]*y[12]*(p[17]*sin(y[11] - y[13]) - p[16]*cos(y[11] - y[13])) + y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[208] = y[12]*(2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15]));
out[209] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
out[210] = y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15]));
out[211] = y[12]*y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[212] = y[12]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + 2*y[14]*(2*p[19] + 2*p[22]) + y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[213] = y[12]*y[14]*(-2*p[20]*cos(y[13] - y[15]) - 2*p[19]*sin(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[214] = y[14]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[215] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[216] = y[14]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15]));
out[217] = y[12]*y[14]*(-2*p[20]*sin(y[13] - y[15]) + 2*p[19]*cos(y[13] - y[15]));
out[218] = y[12]*(2*p[20]*cos(y[13] - y[15]) + 2*p[19]*sin(y[13] - y[15])) + 2*y[14]*(-2*p[20] - 2*p[23] - p[21] - p[24]) + y[16]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[219] = y[12]*y[14]*(2*p[20]*sin(y[13] - y[15]) - 2*p[19]*cos(y[13] - y[15])) + y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[220] = y[14]*(2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[221] = y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
out[222] = y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[223] = y[14]*y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[224] = y[18]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17])) + 2*y[16]*(2*p[22] + p[25]);
out[225] = y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17])) + y[14]*y[16]*(-2*p[23]*cos(y[15] - y[17]) - 2*p[22]*sin(y[15] - y[17]));
out[226] = y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[227] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[228] = y[16]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17]));
out[229] = y[14]*y[16]*(-2*p[23]*sin(y[15] - y[17]) + 2*p[22]*cos(y[15] - y[17]));
out[230] = y[18]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17])) + y[14]*(2*p[23]*cos(y[15] - y[17]) + 2*p[22]*sin(y[15] - y[17])) + 2*y[16]*(-2*p[23] - p[26] - p[24] - 1.0/2.0*p[27]);
out[231] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17])) + y[14]*y[16]*(2*p[23]*sin(y[15] - y[17]) - 2*p[22]*cos(y[15] - y[17]));
out[232] = y[16]*(p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[233] = y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
out[234] = y[18]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7]));
out[235] = y[18]*y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[236] = y[18]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[237] = y[18]*y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[238] = 2*y[18]*(p[28] + p[10] + p[25]) + y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[239] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + y[18]*y[6]*(-p[11]*cos(y[19] - y[7]) + p[10]*sin(y[19] - y[7])) + y[18]*y[16]*(-p[26]*cos(y[19] - y[17]) + p[25]*sin(y[19] - y[17]));
out[240] = y[18]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[241] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[242] = y[18]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7]));
out[243] = y[18]*y[6]*(p[11]*sin(y[19] - y[7]) + p[10]*cos(y[19] - y[7]));
out[244] = y[18]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[245] = y[18]*y[16]*(p[26]*sin(y[19] - y[17]) + p[25]*cos(y[19] - y[17]));
out[246] = 2*y[18]*(-p[29] - p[11] - p[26] - 1.0/2.0*p[30] - 1.0/2.0*p[12] - 1.0/2.0*p[27]) + y[20]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[6]*(p[11]*cos(y[19] - y[7]) - p[10]*sin(y[19] - y[7])) + y[16]*(p[26]*cos(y[19] - y[17]) - p[25]*sin(y[19] - y[17]));
out[247] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[18]*y[6]*(-p[11]*sin(y[19] - y[7]) - p[10]*cos(y[19] - y[7])) + y[18]*y[16]*(-p[26]*sin(y[19] - y[17]) - p[25]*cos(y[19] - y[17]));
out[248] = y[18]*(p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21]));
out[249] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[250] = y[20]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[251] = y[20]*y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[252] = y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21]));
out[253] = y[18]*y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[254] = y[18]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + 2*y[20]*(p[28] + p[7]) + y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[255] = y[18]*y[20]*(-p[29]*cos(y[19] - y[21]) - p[28]*sin(y[19] - y[21])) + y[20]*y[4]*(-p[8]*cos(y[21] - y[5]) + p[7]*sin(y[21] - y[5]));
out[256] = y[20]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[257] = y[20]*y[4]*(p[8]*sin(y[21] - y[5]) + p[7]*cos(y[21] - y[5]));
out[258] = y[20]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21]));
out[259] = y[18]*y[20]*(-p[29]*sin(y[19] - y[21]) + p[28]*cos(y[19] - y[21]));
out[260] = y[18]*(p[29]*cos(y[19] - y[21]) + p[28]*sin(y[19] - y[21])) + 2*y[20]*(-p[29] - p[8] - 1.0/2.0*p[30] - 1.0/2.0*p[9]) + y[4]*(p[8]*cos(y[21] - y[5]) - p[7]*sin(y[21] - y[5]));
out[261] = y[18]*y[20]*(p[29]*sin(y[19] - y[21]) - p[28]*cos(y[19] - y[21])) + y[20]*y[4]*(-p[8]*sin(y[21] - y[5]) - p[7]*cos(y[21] - y[5]));
out[262] = -y[0]*sin(x[0] - y[1]);
out[264] = cos(x[0] - y[1]);
out[265] = y[0]*sin(x[0] - y[1]);
out[268] = y[0]*cos(x[0] - y[1]);
out[270] = sin(x[0] - y[1]);
out[271] = -y[0]*cos(x[0] - y[1]);
out[274] = y[0]*y[22]*cos(x[0] - y[1]) - y[0]*y[23]*sin(x[0] - y[1]);
out[275] = y[22]*sin(x[0] - y[1]) + y[23]*cos(x[0] - y[1]);
out[276] = -y[0]*y[22]*cos(x[0] - y[1]) + y[0]*y[23]*sin(x[0] - y[1]);
out[277] = y[0]*sin(x[0] - y[1]);
out[278] = y[0]*cos(x[0] - y[1]);
out[280] = -y[0]*y[22]*sin(x[0] - y[1]) - y[0]*y[23]*cos(x[0] - y[1]);
out[281] = y[22]*cos(x[0] - y[1]) - y[23]*sin(x[0] - y[1]);
out[282] = y[0]*y[22]*sin(x[0] - y[1]) + y[0]*y[23]*cos(x[0] - y[1]);
out[283] = y[0]*cos(x[0] - y[1]);
out[284] = -y[0]*sin(x[0] - y[1]);
out[286] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   -p[55]
));
out[287] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   p[56]
));
out[289] = ((p[58] > p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5] || p[59] < p[55]*(-x[4] + y[30] + u[22]) + p[56]*x[5]) ? (
   0
)
: (
   p[55]
));
out[300] = ((p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) ? (
   0
)
: (
   p[70]*(-p[68]/p[69] + 1)
));
out[301] = ((p[71] < -p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10]) || p[71] < p[70]*(p[68]*(-x[10] + y[29])/p[69] + x[10])) ? (
   0
)
: (
   p[70]*p[68]/p[69]
));
out[303] = -y[2]*sin(x[11] - y[3]);
out[305] = cos(x[11] - y[3]);
out[306] = y[2]*sin(x[11] - y[3]);
out[309] = y[2]*cos(x[11] - y[3]);
out[311] = sin(x[11] - y[3]);
out[312] = -y[2]*cos(x[11] - y[3]);
out[315] = y[2]*y[31]*cos(x[11] - y[3]) - y[2]*y[32]*sin(x[11] - y[3]);
out[316] = y[31]*sin(x[11] - y[3]) + y[32]*cos(x[11] - y[3]);
out[317] = -y[2]*y[31]*cos(x[11] - y[3]) + y[2]*y[32]*sin(x[11] - y[3]);
out[318] = y[2]*sin(x[11] - y[3]);
out[319] = y[2]*cos(x[11] - y[3]);
out[321] = -y[2]*y[31]*sin(x[11] - y[3]) - y[2]*y[32]*cos(x[11] - y[3]);
out[322] = y[31]*cos(x[11] - y[3]) - y[32]*sin(x[11] - y[3]);
out[323] = y[2]*y[31]*sin(x[11] - y[3]) + y[2]*y[32]*cos(x[11] - y[3]);
out[324] = y[2]*cos(x[11] - y[3]);
out[325] = -y[2]*sin(x[11] - y[3]);
out[327] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   -p[85]
));
out[328] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   p[86]
));
out[330] = ((p[88] > p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16] || p[89] < p[85]*(-x[15] + y[39] + u[26]) + p[86]*x[16]) ? (
   0
)
: (
   p[85]
));
out[341] = ((p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) ? (
   0
)
: (
   p[100]*(-p[98]/p[99] + 1)
));
out[342] = ((p[101] < -p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21]) || p[101] < p[100]*(p[98]*(-x[21] + y[38])/p[99] + x[21])) ? (
   0
)
: (
   p[100]*p[98]/p[99]
));
out[344] = -y[4]*sin(x[22] - y[5]);
out[346] = cos(x[22] - y[5]);
out[347] = y[4]*sin(x[22] - y[5]);
out[350] = y[4]*cos(x[22] - y[5]);
out[352] = sin(x[22] - y[5]);
out[353] = -y[4]*cos(x[22] - y[5]);
out[356] = y[4]*y[40]*cos(x[22] - y[5]) - y[4]*y[41]*sin(x[22] - y[5]);
out[357] = y[40]*sin(x[22] - y[5]) + y[41]*cos(x[22] - y[5]);
out[358] = -y[4]*y[40]*cos(x[22] - y[5]) + y[4]*y[41]*sin(x[22] - y[5]);
out[359] = y[4]*sin(x[22] - y[5]);
out[360] = y[4]*cos(x[22] - y[5]);
out[362] = -y[4]*y[40]*sin(x[22] - y[5]) - y[4]*y[41]*cos(x[22] - y[5]);
out[363] = y[40]*cos(x[22] - y[5]) - y[41]*sin(x[22] - y[5]);
out[364] = y[4]*y[40]*sin(x[22] - y[5]) + y[4]*y[41]*cos(x[22] - y[5]);
out[365] = y[4]*cos(x[22] - y[5]);
out[366] = -y[4]*sin(x[22] - y[5]);
out[368] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   -p[115]
));
out[369] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   p[116]
));
out[371] = ((p[118] > p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27] || p[119] < p[115]*(-x[26] + y[48] + u[30]) + p[116]*x[27]) ? (
   0
)
: (
   p[115]
));
out[382] = ((p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) ? (
   0
)
: (
   p[130]*(-p[128]/p[129] + 1)
));
out[383] = ((p[131] < -p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32]) || p[131] < p[130]*(p[128]*(-x[32] + y[47])/p[129] + x[32])) ? (
   0
)
: (
   p[130]*p[128]/p[129]
));
out[385] = -y[6]*sin(x[33] - y[7]);
out[387] = cos(x[33] - y[7]);
out[388] = y[6]*sin(x[33] - y[7]);
out[391] = y[6]*cos(x[33] - y[7]);
out[393] = sin(x[33] - y[7]);
out[394] = -y[6]*cos(x[33] - y[7]);
out[397] = y[6]*y[49]*cos(x[33] - y[7]) - y[6]*y[50]*sin(x[33] - y[7]);
out[398] = y[49]*sin(x[33] - y[7]) + y[50]*cos(x[33] - y[7]);
out[399] = -y[6]*y[49]*cos(x[33] - y[7]) + y[6]*y[50]*sin(x[33] - y[7]);
out[400] = y[6]*sin(x[33] - y[7]);
out[401] = y[6]*cos(x[33] - y[7]);
out[403] = -y[6]*y[49]*sin(x[33] - y[7]) - y[6]*y[50]*cos(x[33] - y[7]);
out[404] = y[49]*cos(x[33] - y[7]) - y[50]*sin(x[33] - y[7]);
out[405] = y[6]*y[49]*sin(x[33] - y[7]) + y[6]*y[50]*cos(x[33] - y[7]);
out[406] = y[6]*cos(x[33] - y[7]);
out[407] = -y[6]*sin(x[33] - y[7]);
out[409] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   -p[145]
));
out[410] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   p[146]
));
out[412] = ((p[148] > p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38] || p[149] < p[145]*(-x[37] + y[57] + u[34]) + p[146]*x[38]) ? (
   0
)
: (
   p[145]
));
out[423] = ((p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) ? (
   0
)
: (
   p[160]*(-p[158]/p[159] + 1)
));
out[424] = ((p[161] < -p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43]) || p[161] < p[160]*(p[158]*(-x[43] + y[56])/p[159] + x[43])) ? (
   0
)
: (
   p[160]*p[158]/p[159]
));

}

void sp_jac_trap_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = 0.5*Dt*p[53] + 1;
out[1] = -0.5*Dt*p[43];
out[2] = 0.5*Dt*p[43];
out[4] = 0.25*p[51]*Dt/p[44] + 1;
out[9] = -0.25*Dt/p[44];
out[10] = -0.25*p[51]*Dt/p[44];
out[11] = 0.5*Dt/p[45] + 1;
out[12] = -0.5*Dt*(p[49] - p[47])/p[45];
out[13] = -0.5*Dt/p[45];
out[14] = 0.5*Dt/p[46] + 1;
out[15] = -0.5*Dt*(-p[50] + p[48])/p[46];
out[16] = 0.5*Dt/p[57] + 1;
out[17] = -0.5*Dt/p[57];
out[18] = -0.5*Dt*(p[55]*p[60] - 1);
out[19] = 0.5*Dt*p[56]*p[60] + 1;
out[20] = -0.5*Dt*p[60];
out[21] = -0.5*Dt*(-p[55]*p[60] + 1);
out[22] = 0.5*Dt/p[62] + 1;
out[23] = -0.5*Dt/p[62];
out[24] = -0.5*Dt/p[64];
out[25] = 0.5*Dt/p[64] + 1;
out[26] = 4.9999999999999998e-7*Dt + 1;
out[27] = 0.5*Dt*p[65];
out[28] = -0.5*Dt/p[67];
out[29] = 0.5*Dt/p[67] + 1;
out[30] = 0.5*Dt/p[69] + 1;
out[31] = -0.5*Dt/p[69];
out[32] = 0.5*Dt*p[83] + 1;
out[33] = -0.5*Dt*p[73];
out[34] = 0.5*Dt*p[73];
out[36] = 0.25*p[81]*Dt/p[74] + 1;
out[41] = -0.25*Dt/p[74];
out[42] = -0.25*p[81]*Dt/p[74];
out[43] = 0.5*Dt/p[75] + 1;
out[44] = -0.5*Dt*(p[79] - p[77])/p[75];
out[45] = -0.5*Dt/p[75];
out[46] = 0.5*Dt/p[76] + 1;
out[47] = -0.5*Dt*(-p[80] + p[78])/p[76];
out[48] = 0.5*Dt/p[87] + 1;
out[49] = -0.5*Dt/p[87];
out[50] = -0.5*Dt*(p[85]*p[90] - 1);
out[51] = 0.5*Dt*p[86]*p[90] + 1;
out[52] = -0.5*Dt*p[90];
out[53] = -0.5*Dt*(-p[85]*p[90] + 1);
out[54] = 0.5*Dt/p[92] + 1;
out[55] = -0.5*Dt/p[92];
out[56] = -0.5*Dt/p[94];
out[57] = 0.5*Dt/p[94] + 1;
out[58] = 4.9999999999999998e-7*Dt + 1;
out[59] = 0.5*Dt*p[95];
out[60] = -0.5*Dt/p[97];
out[61] = 0.5*Dt/p[97] + 1;
out[62] = 0.5*Dt/p[99] + 1;
out[63] = -0.5*Dt/p[99];
out[64] = 0.5*Dt*p[113] + 1;
out[65] = -0.5*Dt*p[103];
out[66] = 0.5*Dt*p[103];
out[68] = 0.25*p[111]*Dt/p[104] + 1;
out[73] = -0.25*Dt/p[104];
out[74] = -0.25*p[111]*Dt/p[104];
out[75] = 0.5*Dt/p[105] + 1;
out[76] = -0.5*Dt*(p[109] - p[107])/p[105];
out[77] = -0.5*Dt/p[105];
out[78] = 0.5*Dt/p[106] + 1;
out[79] = -0.5*Dt*(-p[110] + p[108])/p[106];
out[80] = 0.5*Dt/p[117] + 1;
out[81] = -0.5*Dt/p[117];
out[82] = -0.5*Dt*(p[115]*p[120] - 1);
out[83] = 0.5*Dt*p[116]*p[120] + 1;
out[84] = -0.5*Dt*p[120];
out[85] = -0.5*Dt*(-p[115]*p[120] + 1);
out[86] = 0.5*Dt/p[122] + 1;
out[87] = -0.5*Dt/p[122];
out[88] = -0.5*Dt/p[124];
out[89] = 0.5*Dt/p[124] + 1;
out[90] = 4.9999999999999998e-7*Dt + 1;
out[91] = 0.5*Dt*p[125];
out[92] = -0.5*Dt/p[127];
out[93] = 0.5*Dt/p[127] + 1;
out[94] = 0.5*Dt/p[129] + 1;
out[95] = -0.5*Dt/p[129];
out[96] = 0.5*Dt*p[143] + 1;
out[97] = -0.5*Dt*p[133];
out[98] = 0.5*Dt*p[133];
out[100] = 0.25*p[141]*Dt/p[134] + 1;
out[105] = -0.25*Dt/p[134];
out[106] = -0.25*p[141]*Dt/p[134];
out[107] = 0.5*Dt/p[135] + 1;
out[108] = -0.5*Dt*(p[139] - p[137])/p[135];
out[109] = -0.5*Dt/p[135];
out[110] = 0.5*Dt/p[136] + 1;
out[111] = -0.5*Dt*(-p[140] + p[138])/p[136];
out[112] = 0.5*Dt/p[147] + 1;
out[113] = -0.5*Dt/p[147];
out[114] = -0.5*Dt*(p[145]*p[150] - 1);
out[115] = 0.5*Dt*p[146]*p[150] + 1;
out[116] = -0.5*Dt*p[150];
out[117] = -0.5*Dt*(-p[145]*p[150] + 1);
out[118] = 0.5*Dt/p[152] + 1;
out[119] = -0.5*Dt/p[152];
out[120] = -0.5*Dt/p[154];
out[121] = 0.5*Dt/p[154] + 1;
out[122] = 4.9999999999999998e-7*Dt + 1;
out[123] = 0.5*Dt*p[155];
out[124] = -0.5*Dt/p[157];
out[125] = 0.5*Dt/p[157] + 1;
out[126] = 0.5*Dt/p[159] + 1;
out[127] = -0.5*Dt/p[159];
out[129] = 0.5*Dt;
out[134] = -p[42]/p[0];
out[139] = -p[42]/p[0];
out[144] = -p[72]/p[0];
out[149] = -p[72]/p[0];
out[154] = -p[102]/p[0];
out[159] = -p[102]/p[0];
out[164] = -p[132]/p[0];
out[169] = -p[132]/p[0];
out[266] = p[49];
out[267] = p[52];
out[272] = p[52];
out[273] = -p[50];
out[290] = -1/p[61];
out[293] = p[54];
out[294] = p[63]/p[64];
out[295] = -p[63]/p[64] + 1;
out[307] = p[79];
out[308] = p[82];
out[313] = p[82];
out[314] = -p[80];
out[331] = -1/p[91];
out[334] = p[84];
out[335] = p[93]/p[94];
out[336] = -p[93]/p[94] + 1;
out[348] = p[109];
out[349] = p[112];
out[354] = p[112];
out[355] = -p[110];
out[372] = -1/p[121];
out[375] = p[114];
out[376] = p[123]/p[124];
out[377] = -p[123]/p[124] + 1;
out[389] = p[139];
out[390] = p[142];
out[395] = p[142];
out[396] = -p[140];
out[413] = -1/p[151];
out[416] = p[144];
out[417] = p[153]/p[154];
out[418] = -p[153]/p[154] + 1;
out[426] = p[44]*p[42]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[427] = p[74]*p[72]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[428] = p[104]*p[102]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[429] = p[134]*p[132]/(p[44]*p[42] + p[74]*p[72] + p[104]*p[102] + p[134]*p[132]);
out[431] = p[163];
out[432] = -p[162];

}

void sp_jac_trap_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[128] = 1;
out[263] = -1;
out[269] = -1;
out[279] = -1;
out[285] = -1;
out[288] = -1;
out[291] = 1;
out[292] = -1;
out[296] = -1;
out[297] = 1;
out[298] = -1;
out[299] = -1;
out[302] = -1;
out[304] = -1;
out[310] = -1;
out[320] = -1;
out[326] = -1;
out[329] = -1;
out[332] = 1;
out[333] = -1;
out[337] = -1;
out[338] = 1;
out[339] = -1;
out[340] = -1;
out[343] = -1;
out[345] = -1;
out[351] = -1;
out[361] = -1;
out[367] = -1;
out[370] = -1;
out[373] = 1;
out[374] = -1;
out[378] = -1;
out[379] = 1;
out[380] = -1;
out[381] = -1;
out[384] = -1;
out[386] = -1;
out[392] = -1;
out[402] = -1;
out[408] = -1;
out[411] = -1;
out[414] = 1;
out[415] = -1;
out[419] = -1;
out[420] = 1;
out[421] = -1;
out[422] = -1;
out[425] = -1;
out[430] = -1;
out[433] = -1;

}



/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // void()(double *, double *, double *, double *, double *, double)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 6), // double *
/*  2 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  3 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  4 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  5 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static void _cffi_d_de_jac_ini_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_ini_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_ini_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_ini_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_ini_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_ini_num_eval _cffi_d_de_jac_ini_num_eval
#endif

static void _cffi_d_de_jac_ini_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_ini_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_ini_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_ini_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_ini_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_ini_up_eval _cffi_d_de_jac_ini_up_eval
#endif

static void _cffi_d_de_jac_ini_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_ini_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_ini_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_ini_xy_eval _cffi_d_de_jac_ini_xy_eval
#endif

static void _cffi_d_de_jac_trap_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_trap_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_trap_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_trap_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_trap_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_trap_num_eval _cffi_d_de_jac_trap_num_eval
#endif

static void _cffi_d_de_jac_trap_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_trap_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_trap_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_trap_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_trap_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_trap_up_eval _cffi_d_de_jac_trap_up_eval
#endif

static void _cffi_d_de_jac_trap_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_trap_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_trap_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_trap_xy_eval _cffi_d_de_jac_trap_xy_eval
#endif

static void _cffi_d_sp_jac_ini_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_num_eval _cffi_d_sp_jac_ini_num_eval
#endif

static void _cffi_d_sp_jac_ini_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_up_eval _cffi_d_sp_jac_ini_up_eval
#endif

static void _cffi_d_sp_jac_ini_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_xy_eval _cffi_d_sp_jac_ini_xy_eval
#endif

static void _cffi_d_sp_jac_trap_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_trap_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_trap_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_trap_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_trap_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_trap_num_eval _cffi_d_sp_jac_trap_num_eval
#endif

static void _cffi_d_sp_jac_trap_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_trap_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_trap_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_trap_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_trap_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_trap_up_eval _cffi_d_sp_jac_trap_up_eval
#endif

static void _cffi_d_sp_jac_trap_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_trap_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_trap_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_trap_xy_eval _cffi_d_sp_jac_trap_xy_eval
#endif

static const struct _cffi_global_s _cffi_globals[] = {
  { "de_jac_ini_num_eval", (void *)_cffi_f_de_jac_ini_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_ini_num_eval },
  { "de_jac_ini_up_eval", (void *)_cffi_f_de_jac_ini_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_ini_up_eval },
  { "de_jac_ini_xy_eval", (void *)_cffi_f_de_jac_ini_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_ini_xy_eval },
  { "de_jac_trap_num_eval", (void *)_cffi_f_de_jac_trap_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_trap_num_eval },
  { "de_jac_trap_up_eval", (void *)_cffi_f_de_jac_trap_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_trap_up_eval },
  { "de_jac_trap_xy_eval", (void *)_cffi_f_de_jac_trap_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_trap_xy_eval },
  { "sp_jac_ini_num_eval", (void *)_cffi_f_sp_jac_ini_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_num_eval },
  { "sp_jac_ini_up_eval", (void *)_cffi_f_sp_jac_ini_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_up_eval },
  { "sp_jac_ini_xy_eval", (void *)_cffi_f_sp_jac_ini_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_xy_eval },
  { "sp_jac_trap_num_eval", (void *)_cffi_f_sp_jac_trap_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_trap_num_eval },
  { "sp_jac_trap_up_eval", (void *)_cffi_f_sp_jac_trap_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_trap_up_eval },
  { "sp_jac_trap_xy_eval", (void *)_cffi_f_sp_jac_trap_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_trap_xy_eval },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  NULL,  /* no struct_unions */
  NULL,  /* no enums */
  NULL,  /* no typenames */
  12,  /* num_globals */
  0,  /* num_struct_unions */
  0,  /* num_enums */
  0,  /* num_typenames */
  NULL,  /* no includes */
  9,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit_mod3(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit_mod3(void) { return NULL; }
#  else
     initmod3(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit_mod3(void)
{
  return _cffi_init("mod3", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
initmod3(void)
{
  _cffi_init("mod3", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
