#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

void f_ini_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[50]*x[0] + p[43]*(y[22] - y[28]);
out[1] = -y[23]*(p[49]*y[23] + y[20]*sin(x[0] - y[21])) - y[24]*(p[49]*y[24] + y[20]*cos(x[0] - y[21])) + y[27];
out[2] = (p[46]*(-y[26] + u[26]) - x[2] + u[22])/p[47];
out[3] = 1 - y[28];

}
void g_ini_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -u[0]/p[0] + pow(y[0], 2)*p[19] + y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[1] = -u[1]/p[0] + pow(y[0], 2)*(-p[20] - 1.0/2.0*p[21]) + y[0]*y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[2] = -u[2]/p[0] + pow(y[2], 2)*p[22] + y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[3] = -u[3]/p[0] + pow(y[2], 2)*(-p[23] - 1.0/2.0*p[24]) + y[2]*y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[4] = -u[4]/p[0] + pow(y[4], 2)*p[25] + y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[5] = -u[5]/p[0] + pow(y[4], 2)*(-p[26] - 1.0/2.0*p[27]) + y[4]*y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[6] = -u[6]/p[0] + pow(y[6], 2)*p[28] + y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[7] = -u[7]/p[0] + pow(y[6], 2)*(-p[29] - 1.0/2.0*p[30]) + y[6]*y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[8] = -u[8]/p[0] + y[0]*y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + pow(y[8], 2)*(p[19] + p[1]) + y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[9] = -u[9]/p[0] + y[0]*y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9])) + pow(y[8], 2)*(-p[20] - p[2] - 1.0/2.0*p[21] - 1.0/2.0*p[3]) + y[8]*y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[10] = -u[10]/p[0] + y[8]*y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + pow(y[10], 2)*(p[1] + p[22] + p[4]) + y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[11] = -u[11]/p[0] + y[8]*y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11])) + y[2]*y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11])) + pow(y[10], 2)*(-p[2] - p[23] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[24] - 1.0/2.0*p[6]) + y[10]*y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[12] = -u[12]/p[0] + y[14]*y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13])) + pow(y[12], 2)*(p[4] + p[7] + p[25]);
out[13] = -u[13]/p[0] + y[14]*y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13])) + y[10]*y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13])) + y[4]*y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13])) + pow(y[12], 2)*(-p[5] - p[8] - p[26] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[27]);
out[14] = -u[14]/p[0] + y[18]*y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + pow(y[14], 2)*(p[16] + p[10] + p[7]) + y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[15] = -u[15]/p[0] + y[18]*y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15])) + pow(y[14], 2)*(-p[17] - p[11] - p[8] - 1.0/2.0*p[18] - 1.0/2.0*p[12] - 1.0/2.0*p[9]) + y[14]*y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[14]*y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[16] = -u[16]/p[0] + y[14]*y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17])) + pow(y[16], 2)*(p[10] + p[28]);
out[17] = -u[17]/p[0] + y[14]*y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[6]*y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17])) + pow(y[16], 2)*(-p[11] - p[29] - 1.0/2.0*p[12] - 1.0/2.0*p[30]);
out[18] = -u[18]/p[0] + y[20]*y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + pow(y[18], 2)*(p[13] + p[16]) + y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[19] = -u[19]/p[0] + y[20]*y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19])) + pow(y[18], 2)*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[18]*y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[20] = -u[20]/p[0] + pow(y[20], 2)*p[13] + y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) - p[42]*y[25]/p[0];
out[21] = -u[21]/p[0] + pow(y[20], 2)*(-p[14] - 1.0/2.0*p[15]) + y[20]*y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19])) - p[42]*y[26]/p[0];
out[22] = p[44]*(-y[23]*(p[49]*y[23] + y[20]*sin(x[0] - y[21])) - y[24]*(p[49]*y[24] + y[20]*cos(x[0] - y[21])) + y[27] + x[1]/p[45]) - y[22] + 1;
out[23] = -p[49]*y[23] - y[20]*sin(x[0] - y[21]) + p[48]*y[24];
out[24] = -p[49]*y[24] - y[20]*cos(x[0] - y[21]) - p[48]*y[23] + x[2];
out[25] = y[20]*y[23]*sin(x[0] - y[21]) + y[20]*y[24]*cos(x[0] - y[21]) - y[25];
out[26] = y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]) - y[26];
out[27] = p[51]*y[29] + u[24] - y[27] - (y[22] - u[25])/p[52];
out[28] = y[22] - y[28];
out[29] = p[54]*x[3] + p[53]*(1 - y[28]) - y[29];

}
void f_run_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[50]*x[0] + p[43]*(y[22] - y[28]);
out[1] = -y[23]*(p[49]*y[23] + y[20]*sin(x[0] - y[21])) - y[24]*(p[49]*y[24] + y[20]*cos(x[0] - y[21])) + y[27];
out[2] = (p[46]*(-y[26] + u[26]) - x[2] + u[22])/p[47];
out[3] = 1 - y[28];

}
void h_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = y[0];
out[1] = y[2];
out[2] = y[4];
out[3] = y[6];
out[4] = y[8];
out[5] = y[10];
out[6] = y[12];
out[7] = y[14];
out[8] = y[16];
out[9] = y[18];
out[10] = y[20];
out[11] = y[23]*(p[49]*y[23] + y[20]*sin(x[0] - y[21])) + y[24]*(p[49]*y[24] + y[20]*cos(x[0] - y[21]));

}
void g_run_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -u[0]/p[0] + pow(y[0], 2)*p[19] + y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[1] = -u[1]/p[0] + pow(y[0], 2)*(-p[20] - 1.0/2.0*p[21]) + y[0]*y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[2] = -u[2]/p[0] + pow(y[2], 2)*p[22] + y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[3] = -u[3]/p[0] + pow(y[2], 2)*(-p[23] - 1.0/2.0*p[24]) + y[2]*y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[4] = -u[4]/p[0] + pow(y[4], 2)*p[25] + y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[5] = -u[5]/p[0] + pow(y[4], 2)*(-p[26] - 1.0/2.0*p[27]) + y[4]*y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[6] = -u[6]/p[0] + pow(y[6], 2)*p[28] + y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[7] = -u[7]/p[0] + pow(y[6], 2)*(-p[29] - 1.0/2.0*p[30]) + y[6]*y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[8] = -u[8]/p[0] + y[0]*y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + pow(y[8], 2)*(p[19] + p[1]) + y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[9] = -u[9]/p[0] + y[0]*y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9])) + pow(y[8], 2)*(-p[20] - p[2] - 1.0/2.0*p[21] - 1.0/2.0*p[3]) + y[8]*y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[10] = -u[10]/p[0] + y[8]*y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + pow(y[10], 2)*(p[1] + p[22] + p[4]) + y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[11] = -u[11]/p[0] + y[8]*y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11])) + y[2]*y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11])) + pow(y[10], 2)*(-p[2] - p[23] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[24] - 1.0/2.0*p[6]) + y[10]*y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[12] = -u[12]/p[0] + y[14]*y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13])) + pow(y[12], 2)*(p[4] + p[7] + p[25]);
out[13] = -u[13]/p[0] + y[14]*y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13])) + y[10]*y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13])) + y[4]*y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13])) + pow(y[12], 2)*(-p[5] - p[8] - p[26] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[27]);
out[14] = -u[14]/p[0] + y[18]*y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + pow(y[14], 2)*(p[16] + p[10] + p[7]) + y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[15] = -u[15]/p[0] + y[18]*y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15])) + pow(y[14], 2)*(-p[17] - p[11] - p[8] - 1.0/2.0*p[18] - 1.0/2.0*p[12] - 1.0/2.0*p[9]) + y[14]*y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[14]*y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[16] = -u[16]/p[0] + y[14]*y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17])) + pow(y[16], 2)*(p[10] + p[28]);
out[17] = -u[17]/p[0] + y[14]*y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[6]*y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17])) + pow(y[16], 2)*(-p[11] - p[29] - 1.0/2.0*p[12] - 1.0/2.0*p[30]);
out[18] = -u[18]/p[0] + y[20]*y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + pow(y[18], 2)*(p[13] + p[16]) + y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[19] = -u[19]/p[0] + y[20]*y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19])) + pow(y[18], 2)*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[18]*y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[20] = -u[20]/p[0] + pow(y[20], 2)*p[13] + y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) - p[42]*y[25]/p[0];
out[21] = -u[21]/p[0] + pow(y[20], 2)*(-p[14] - 1.0/2.0*p[15]) + y[20]*y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19])) - p[42]*y[26]/p[0];
out[22] = p[44]*(-y[23]*(p[49]*y[23] + y[20]*sin(x[0] - y[21])) - y[24]*(p[49]*y[24] + y[20]*cos(x[0] - y[21])) + y[27] + x[1]/p[45]) - y[22] + 1;
out[23] = -p[49]*y[23] - y[20]*sin(x[0] - y[21]) + p[48]*y[24];
out[24] = -p[49]*y[24] - y[20]*cos(x[0] - y[21]) - p[48]*y[23] + x[2];
out[25] = y[20]*y[23]*sin(x[0] - y[21]) + y[20]*y[24]*cos(x[0] - y[21]) - y[25];
out[26] = y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]) - y[26];
out[27] = p[51]*y[29] + u[24] - y[27] - (y[22] - u[25])/p[52];
out[28] = y[22] - y[28];
out[29] = p[54]*x[3] + p[53]*(1 - y[28]) - y[29];

}
void de_jac_ini_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[34] = -y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]);
out[58] = -y[23]*sin(x[0] - y[21]) - y[24]*cos(x[0] - y[21]);
out[59] = y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]);
out[61] = -2*p[49]*y[23] - y[20]*sin(x[0] - y[21]);
out[62] = -2*p[49]*y[24] - y[20]*cos(x[0] - y[21]);
out[140] = 2*y[0]*p[19] + y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[141] = y[0]*y[8]*(-p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[148] = y[0]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[149] = y[0]*y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[174] = 2*y[0]*(-p[20] - 1.0/2.0*p[21]) + y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[175] = y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[182] = y[0]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[183] = y[0]*y[8]*(p[20]*sin(y[1] - y[9]) + p[19]*cos(y[1] - y[9]));
out[210] = 2*y[2]*p[22] + y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[211] = y[2]*y[10]*(-p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[218] = y[2]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[219] = y[2]*y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[244] = 2*y[2]*(-p[23] - 1.0/2.0*p[24]) + y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[245] = y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[252] = y[2]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[253] = y[2]*y[10]*(p[23]*sin(y[3] - y[11]) + p[22]*cos(y[3] - y[11]));
out[280] = 2*y[4]*p[25] + y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[281] = y[4]*y[12]*(-p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[288] = y[4]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[289] = y[4]*y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[314] = 2*y[4]*(-p[26] - 1.0/2.0*p[27]) + y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[315] = y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[322] = y[4]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[323] = y[4]*y[12]*(p[26]*sin(y[5] - y[13]) + p[25]*cos(y[5] - y[13]));
out[350] = 2*y[6]*p[28] + y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[351] = y[6]*y[16]*(-p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[360] = y[6]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[361] = y[6]*y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[384] = 2*y[6]*(-p[29] - 1.0/2.0*p[30]) + y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[385] = y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[394] = y[6]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[395] = y[6]*y[16]*(p[29]*sin(y[7] - y[17]) + p[28]*cos(y[7] - y[17]));
out[412] = y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[413] = y[0]*y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[420] = y[0]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + 2*y[8]*(p[19] + p[1]) + y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[421] = y[0]*y[8]*(-p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[422] = y[8]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[423] = y[8]*y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[446] = y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[447] = y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) + p[19]*cos(y[1] - y[9]));
out[454] = y[0]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9])) + 2*y[8]*(-p[20] - p[2] - 1.0/2.0*p[21] - 1.0/2.0*p[3]) + y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[455] = y[0]*y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[456] = y[8]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[457] = y[8]*y[10]*(p[2]*sin(y[9] - y[11]) + p[1]*cos(y[9] - y[11]));
out[482] = y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[483] = y[2]*y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[488] = y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[489] = y[8]*y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[490] = y[8]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + 2*y[10]*(p[1] + p[22] + p[4]) + y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[491] = y[8]*y[10]*(-p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11])) + y[2]*y[10]*(-p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11])) + y[10]*y[12]*(-p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[492] = y[10]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[493] = y[10]*y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[516] = y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[517] = y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) + p[22]*cos(y[3] - y[11]));
out[522] = y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[523] = y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) + p[1]*cos(y[9] - y[11]));
out[524] = y[8]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11])) + y[2]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11])) + 2*y[10]*(-p[2] - p[23] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[24] - 1.0/2.0*p[6]) + y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[525] = y[8]*y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[526] = y[10]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[527] = y[10]*y[12]*(p[5]*sin(y[11] - y[13]) + p[4]*cos(y[11] - y[13]));
out[552] = y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[553] = y[4]*y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[558] = y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[559] = y[10]*y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[560] = y[14]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13])) + 2*y[12]*(p[4] + p[7] + p[25]);
out[561] = y[14]*y[12]*(-p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13])) + y[10]*y[12]*(-p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13])) + y[4]*y[12]*(-p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[562] = y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[563] = y[14]*y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[586] = y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[587] = y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) + p[25]*cos(y[5] - y[13]));
out[592] = y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[593] = y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) + p[4]*cos(y[11] - y[13]));
out[594] = y[14]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13])) + y[10]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13])) + y[4]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13])) + 2*y[12]*(-p[5] - p[8] - p[26] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[27]);
out[595] = y[14]*y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[596] = y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[597] = y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) + p[7]*cos(y[15] - y[13]));
out[628] = y[14]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[629] = y[14]*y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[630] = y[18]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + 2*y[14]*(p[16] + p[10] + p[7]) + y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[631] = y[18]*y[14]*(-p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15])) + y[14]*y[16]*(-p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[14]*y[12]*(-p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[632] = y[14]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17]));
out[633] = y[14]*y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17]));
out[634] = y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[635] = y[18]*y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[662] = y[14]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[663] = y[14]*y[12]*(p[8]*sin(y[15] - y[13]) + p[7]*cos(y[15] - y[13]));
out[664] = y[18]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15])) + 2*y[14]*(-p[17] - p[11] - p[8] - 1.0/2.0*p[18] - 1.0/2.0*p[12] - 1.0/2.0*p[9]) + y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[665] = y[18]*y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[666] = y[14]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17]));
out[667] = y[14]*y[16]*(p[11]*sin(y[15] - y[17]) + p[10]*cos(y[15] - y[17]));
out[668] = y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[669] = y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) + p[16]*cos(y[19] - y[15]));
out[690] = y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[691] = y[6]*y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[698] = y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17]));
out[699] = y[14]*y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17]));
out[700] = y[14]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17])) + 2*y[16]*(p[10] + p[28]);
out[701] = y[14]*y[16]*(-p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[6]*y[16]*(-p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[724] = y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[725] = y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) + p[28]*cos(y[7] - y[17]));
out[732] = y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17]));
out[733] = y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) + p[10]*cos(y[15] - y[17]));
out[734] = y[14]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[6]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17])) + 2*y[16]*(-p[11] - p[29] - 1.0/2.0*p[12] - 1.0/2.0*p[30]);
out[735] = y[14]*y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[766] = y[18]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[767] = y[18]*y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[770] = y[20]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + 2*y[18]*(p[13] + p[16]) + y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[771] = y[20]*y[18]*(-p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19])) + y[18]*y[14]*(-p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[772] = y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[773] = y[20]*y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[800] = y[18]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[801] = y[18]*y[14]*(p[17]*sin(y[19] - y[15]) + p[16]*cos(y[19] - y[15]));
out[804] = y[20]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19])) + 2*y[18]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[805] = y[20]*y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[806] = y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[807] = y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) + p[13]*cos(y[21] - y[19]));
out[838] = y[20]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[839] = y[20]*y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[840] = 2*y[20]*p[13] + y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[841] = y[20]*y[18]*(-p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[872] = y[20]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[873] = y[20]*y[18]*(p[14]*sin(y[21] - y[19]) + p[13]*cos(y[21] - y[19]));
out[874] = 2*y[20]*(-p[14] - 1.0/2.0*p[15]) + y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[875] = y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[884] = p[44]*(-y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]));
out[908] = p[44]*(-y[23]*sin(x[0] - y[21]) - y[24]*cos(x[0] - y[21]));
out[909] = p[44]*(y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]));
out[911] = p[44]*(-2*p[49]*y[23] - y[20]*sin(x[0] - y[21]));
out[912] = p[44]*(-2*p[49]*y[24] - y[20]*cos(x[0] - y[21]));
out[918] = -y[20]*cos(x[0] - y[21]);
out[942] = -sin(x[0] - y[21]);
out[943] = y[20]*cos(x[0] - y[21]);
out[952] = y[20]*sin(x[0] - y[21]);
out[976] = -cos(x[0] - y[21]);
out[977] = -y[20]*sin(x[0] - y[21]);
out[986] = y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]);
out[1010] = y[23]*sin(x[0] - y[21]) + y[24]*cos(x[0] - y[21]);
out[1011] = -y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]);
out[1013] = y[20]*sin(x[0] - y[21]);
out[1014] = y[20]*cos(x[0] - y[21]);
out[1020] = -y[20]*y[23]*sin(x[0] - y[21]) - y[20]*y[24]*cos(x[0] - y[21]);
out[1044] = y[23]*cos(x[0] - y[21]) - y[24]*sin(x[0] - y[21]);
out[1045] = y[20]*y[23]*sin(x[0] - y[21]) + y[20]*y[24]*cos(x[0] - y[21]);
out[1047] = y[20]*cos(x[0] - y[21]);
out[1048] = -y[20]*sin(x[0] - y[21]);

}

void de_jac_ini_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[50];
out[26] = p[43];
out[32] = -p[43];
out[70] = -1/p[47];
out[98] = -p[46]/p[47];
out[845] = -p[42]/p[0];
out[880] = -p[42]/p[0];
out[885] = p[44]/p[45];
out[915] = p[44];
out[945] = -p[49];
out[946] = p[48];
out[979] = -p[48];
out[980] = -p[49];
out[1080] = -1/p[52];
out[1087] = p[51];
out[1125] = p[54];
out[1154] = -p[53];

}

void de_jac_ini_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[65] = 1;
out[134] = -1;
out[910] = -1;
out[954] = 1;
out[1015] = -1;
out[1050] = -1;
out[1085] = -1;
out[1114] = 1;
out[1120] = -1;
out[1155] = -1;

}

void sp_jac_ini_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[3] = -y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]);
out[4] = -y[23]*sin(x[0] - y[21]) - y[24]*cos(x[0] - y[21]);
out[5] = y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]);
out[6] = -2*p[49]*y[23] - y[20]*sin(x[0] - y[21]);
out[7] = -2*p[49]*y[24] - y[20]*cos(x[0] - y[21]);
out[12] = 2*y[0]*p[19] + y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[13] = y[0]*y[8]*(-p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[14] = y[0]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[15] = y[0]*y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[16] = 2*y[0]*(-p[20] - 1.0/2.0*p[21]) + y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[17] = y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[18] = y[0]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[19] = y[0]*y[8]*(p[20]*sin(y[1] - y[9]) + p[19]*cos(y[1] - y[9]));
out[20] = 2*y[2]*p[22] + y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[21] = y[2]*y[10]*(-p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[22] = y[2]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[23] = y[2]*y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[24] = 2*y[2]*(-p[23] - 1.0/2.0*p[24]) + y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[25] = y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[26] = y[2]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[27] = y[2]*y[10]*(p[23]*sin(y[3] - y[11]) + p[22]*cos(y[3] - y[11]));
out[28] = 2*y[4]*p[25] + y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[29] = y[4]*y[12]*(-p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[30] = y[4]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[31] = y[4]*y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[32] = 2*y[4]*(-p[26] - 1.0/2.0*p[27]) + y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[33] = y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[34] = y[4]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[35] = y[4]*y[12]*(p[26]*sin(y[5] - y[13]) + p[25]*cos(y[5] - y[13]));
out[36] = 2*y[6]*p[28] + y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[37] = y[6]*y[16]*(-p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[38] = y[6]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[39] = y[6]*y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[40] = 2*y[6]*(-p[29] - 1.0/2.0*p[30]) + y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[41] = y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[42] = y[6]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[43] = y[6]*y[16]*(p[29]*sin(y[7] - y[17]) + p[28]*cos(y[7] - y[17]));
out[44] = y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[45] = y[0]*y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[46] = y[0]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + 2*y[8]*(p[19] + p[1]) + y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[47] = y[0]*y[8]*(-p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[48] = y[8]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[49] = y[8]*y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[50] = y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[51] = y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) + p[19]*cos(y[1] - y[9]));
out[52] = y[0]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9])) + 2*y[8]*(-p[20] - p[2] - 1.0/2.0*p[21] - 1.0/2.0*p[3]) + y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[53] = y[0]*y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[54] = y[8]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[55] = y[8]*y[10]*(p[2]*sin(y[9] - y[11]) + p[1]*cos(y[9] - y[11]));
out[56] = y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[57] = y[2]*y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[58] = y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[59] = y[8]*y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[60] = y[8]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + 2*y[10]*(p[1] + p[22] + p[4]) + y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[61] = y[8]*y[10]*(-p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11])) + y[2]*y[10]*(-p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11])) + y[10]*y[12]*(-p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[62] = y[10]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[63] = y[10]*y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[64] = y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[65] = y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) + p[22]*cos(y[3] - y[11]));
out[66] = y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[67] = y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) + p[1]*cos(y[9] - y[11]));
out[68] = y[8]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11])) + y[2]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11])) + 2*y[10]*(-p[2] - p[23] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[24] - 1.0/2.0*p[6]) + y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[69] = y[8]*y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[70] = y[10]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[71] = y[10]*y[12]*(p[5]*sin(y[11] - y[13]) + p[4]*cos(y[11] - y[13]));
out[72] = y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[73] = y[4]*y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[74] = y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[75] = y[10]*y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[76] = y[14]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13])) + 2*y[12]*(p[4] + p[7] + p[25]);
out[77] = y[14]*y[12]*(-p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13])) + y[10]*y[12]*(-p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13])) + y[4]*y[12]*(-p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[78] = y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[79] = y[14]*y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[80] = y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[81] = y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) + p[25]*cos(y[5] - y[13]));
out[82] = y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[83] = y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) + p[4]*cos(y[11] - y[13]));
out[84] = y[14]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13])) + y[10]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13])) + y[4]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13])) + 2*y[12]*(-p[5] - p[8] - p[26] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[27]);
out[85] = y[14]*y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[86] = y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[87] = y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) + p[7]*cos(y[15] - y[13]));
out[88] = y[14]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[89] = y[14]*y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[90] = y[18]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + 2*y[14]*(p[16] + p[10] + p[7]) + y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[91] = y[18]*y[14]*(-p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15])) + y[14]*y[16]*(-p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[14]*y[12]*(-p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[92] = y[14]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17]));
out[93] = y[14]*y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17]));
out[94] = y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[95] = y[18]*y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[96] = y[14]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[97] = y[14]*y[12]*(p[8]*sin(y[15] - y[13]) + p[7]*cos(y[15] - y[13]));
out[98] = y[18]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15])) + 2*y[14]*(-p[17] - p[11] - p[8] - 1.0/2.0*p[18] - 1.0/2.0*p[12] - 1.0/2.0*p[9]) + y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[99] = y[18]*y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[100] = y[14]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17]));
out[101] = y[14]*y[16]*(p[11]*sin(y[15] - y[17]) + p[10]*cos(y[15] - y[17]));
out[102] = y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[103] = y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) + p[16]*cos(y[19] - y[15]));
out[104] = y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[105] = y[6]*y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[106] = y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17]));
out[107] = y[14]*y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17]));
out[108] = y[14]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17])) + 2*y[16]*(p[10] + p[28]);
out[109] = y[14]*y[16]*(-p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[6]*y[16]*(-p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[110] = y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[111] = y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) + p[28]*cos(y[7] - y[17]));
out[112] = y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17]));
out[113] = y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) + p[10]*cos(y[15] - y[17]));
out[114] = y[14]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[6]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17])) + 2*y[16]*(-p[11] - p[29] - 1.0/2.0*p[12] - 1.0/2.0*p[30]);
out[115] = y[14]*y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[116] = y[18]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[117] = y[18]*y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[118] = y[20]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + 2*y[18]*(p[13] + p[16]) + y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[119] = y[20]*y[18]*(-p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19])) + y[18]*y[14]*(-p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[120] = y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[121] = y[20]*y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[122] = y[18]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[123] = y[18]*y[14]*(p[17]*sin(y[19] - y[15]) + p[16]*cos(y[19] - y[15]));
out[124] = y[20]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19])) + 2*y[18]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[125] = y[20]*y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[126] = y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[127] = y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) + p[13]*cos(y[21] - y[19]));
out[128] = y[20]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[129] = y[20]*y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[130] = 2*y[20]*p[13] + y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[131] = y[20]*y[18]*(-p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[133] = y[20]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[134] = y[20]*y[18]*(p[14]*sin(y[21] - y[19]) + p[13]*cos(y[21] - y[19]));
out[135] = 2*y[20]*(-p[14] - 1.0/2.0*p[15]) + y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[136] = y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[138] = p[44]*(-y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]));
out[140] = p[44]*(-y[23]*sin(x[0] - y[21]) - y[24]*cos(x[0] - y[21]));
out[141] = p[44]*(y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]));
out[143] = p[44]*(-2*p[49]*y[23] - y[20]*sin(x[0] - y[21]));
out[144] = p[44]*(-2*p[49]*y[24] - y[20]*cos(x[0] - y[21]));
out[146] = -y[20]*cos(x[0] - y[21]);
out[147] = -sin(x[0] - y[21]);
out[148] = y[20]*cos(x[0] - y[21]);
out[151] = y[20]*sin(x[0] - y[21]);
out[153] = -cos(x[0] - y[21]);
out[154] = -y[20]*sin(x[0] - y[21]);
out[157] = y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]);
out[158] = y[23]*sin(x[0] - y[21]) + y[24]*cos(x[0] - y[21]);
out[159] = -y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]);
out[160] = y[20]*sin(x[0] - y[21]);
out[161] = y[20]*cos(x[0] - y[21]);
out[163] = -y[20]*y[23]*sin(x[0] - y[21]) - y[20]*y[24]*cos(x[0] - y[21]);
out[164] = y[23]*cos(x[0] - y[21]) - y[24]*sin(x[0] - y[21]);
out[165] = y[20]*y[23]*sin(x[0] - y[21]) + y[20]*y[24]*cos(x[0] - y[21]);
out[166] = y[20]*cos(x[0] - y[21]);
out[167] = -y[20]*sin(x[0] - y[21]);

}

void sp_jac_ini_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = -p[50];
out[1] = p[43];
out[2] = -p[43];
out[9] = -1/p[47];
out[10] = -p[46]/p[47];
out[132] = -p[42]/p[0];
out[137] = -p[42]/p[0];
out[139] = p[44]/p[45];
out[145] = p[44];
out[149] = -p[49];
out[150] = p[48];
out[155] = -p[48];
out[156] = -p[49];
out[169] = -1/p[52];
out[171] = p[51];
out[174] = p[54];
out[175] = -p[53];

}

void sp_jac_ini_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[8] = 1;
out[11] = -1;
out[142] = -1;
out[152] = 1;
out[162] = -1;
out[168] = -1;
out[170] = -1;
out[172] = 1;
out[173] = -1;
out[176] = -1;

}

void de_jac_trap_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[34] = -0.5*Dt*(-y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]));
out[58] = -0.5*Dt*(-y[23]*sin(x[0] - y[21]) - y[24]*cos(x[0] - y[21]));
out[59] = -0.5*Dt*(y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]));
out[61] = -0.5*Dt*(-2*p[49]*y[23] - y[20]*sin(x[0] - y[21]));
out[62] = -0.5*Dt*(-2*p[49]*y[24] - y[20]*cos(x[0] - y[21]));
out[140] = 2*y[0]*p[19] + y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[141] = y[0]*y[8]*(-p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[148] = y[0]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[149] = y[0]*y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[174] = 2*y[0]*(-p[20] - 1.0/2.0*p[21]) + y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[175] = y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[182] = y[0]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[183] = y[0]*y[8]*(p[20]*sin(y[1] - y[9]) + p[19]*cos(y[1] - y[9]));
out[210] = 2*y[2]*p[22] + y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[211] = y[2]*y[10]*(-p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[218] = y[2]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[219] = y[2]*y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[244] = 2*y[2]*(-p[23] - 1.0/2.0*p[24]) + y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[245] = y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[252] = y[2]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[253] = y[2]*y[10]*(p[23]*sin(y[3] - y[11]) + p[22]*cos(y[3] - y[11]));
out[280] = 2*y[4]*p[25] + y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[281] = y[4]*y[12]*(-p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[288] = y[4]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[289] = y[4]*y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[314] = 2*y[4]*(-p[26] - 1.0/2.0*p[27]) + y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[315] = y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[322] = y[4]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[323] = y[4]*y[12]*(p[26]*sin(y[5] - y[13]) + p[25]*cos(y[5] - y[13]));
out[350] = 2*y[6]*p[28] + y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[351] = y[6]*y[16]*(-p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[360] = y[6]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[361] = y[6]*y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[384] = 2*y[6]*(-p[29] - 1.0/2.0*p[30]) + y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[385] = y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[394] = y[6]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[395] = y[6]*y[16]*(p[29]*sin(y[7] - y[17]) + p[28]*cos(y[7] - y[17]));
out[412] = y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[413] = y[0]*y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[420] = y[0]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + 2*y[8]*(p[19] + p[1]) + y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[421] = y[0]*y[8]*(-p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[422] = y[8]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[423] = y[8]*y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[446] = y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[447] = y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) + p[19]*cos(y[1] - y[9]));
out[454] = y[0]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9])) + 2*y[8]*(-p[20] - p[2] - 1.0/2.0*p[21] - 1.0/2.0*p[3]) + y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[455] = y[0]*y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[456] = y[8]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[457] = y[8]*y[10]*(p[2]*sin(y[9] - y[11]) + p[1]*cos(y[9] - y[11]));
out[482] = y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[483] = y[2]*y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[488] = y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[489] = y[8]*y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[490] = y[8]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + 2*y[10]*(p[1] + p[22] + p[4]) + y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[491] = y[8]*y[10]*(-p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11])) + y[2]*y[10]*(-p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11])) + y[10]*y[12]*(-p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[492] = y[10]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[493] = y[10]*y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[516] = y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[517] = y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) + p[22]*cos(y[3] - y[11]));
out[522] = y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[523] = y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) + p[1]*cos(y[9] - y[11]));
out[524] = y[8]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11])) + y[2]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11])) + 2*y[10]*(-p[2] - p[23] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[24] - 1.0/2.0*p[6]) + y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[525] = y[8]*y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[526] = y[10]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[527] = y[10]*y[12]*(p[5]*sin(y[11] - y[13]) + p[4]*cos(y[11] - y[13]));
out[552] = y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[553] = y[4]*y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[558] = y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[559] = y[10]*y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[560] = y[14]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13])) + 2*y[12]*(p[4] + p[7] + p[25]);
out[561] = y[14]*y[12]*(-p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13])) + y[10]*y[12]*(-p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13])) + y[4]*y[12]*(-p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[562] = y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[563] = y[14]*y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[586] = y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[587] = y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) + p[25]*cos(y[5] - y[13]));
out[592] = y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[593] = y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) + p[4]*cos(y[11] - y[13]));
out[594] = y[14]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13])) + y[10]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13])) + y[4]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13])) + 2*y[12]*(-p[5] - p[8] - p[26] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[27]);
out[595] = y[14]*y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[596] = y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[597] = y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) + p[7]*cos(y[15] - y[13]));
out[628] = y[14]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[629] = y[14]*y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[630] = y[18]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + 2*y[14]*(p[16] + p[10] + p[7]) + y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[631] = y[18]*y[14]*(-p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15])) + y[14]*y[16]*(-p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[14]*y[12]*(-p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[632] = y[14]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17]));
out[633] = y[14]*y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17]));
out[634] = y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[635] = y[18]*y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[662] = y[14]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[663] = y[14]*y[12]*(p[8]*sin(y[15] - y[13]) + p[7]*cos(y[15] - y[13]));
out[664] = y[18]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15])) + 2*y[14]*(-p[17] - p[11] - p[8] - 1.0/2.0*p[18] - 1.0/2.0*p[12] - 1.0/2.0*p[9]) + y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[665] = y[18]*y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[666] = y[14]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17]));
out[667] = y[14]*y[16]*(p[11]*sin(y[15] - y[17]) + p[10]*cos(y[15] - y[17]));
out[668] = y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[669] = y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) + p[16]*cos(y[19] - y[15]));
out[690] = y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[691] = y[6]*y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[698] = y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17]));
out[699] = y[14]*y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17]));
out[700] = y[14]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17])) + 2*y[16]*(p[10] + p[28]);
out[701] = y[14]*y[16]*(-p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[6]*y[16]*(-p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[724] = y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[725] = y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) + p[28]*cos(y[7] - y[17]));
out[732] = y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17]));
out[733] = y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) + p[10]*cos(y[15] - y[17]));
out[734] = y[14]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[6]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17])) + 2*y[16]*(-p[11] - p[29] - 1.0/2.0*p[12] - 1.0/2.0*p[30]);
out[735] = y[14]*y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[766] = y[18]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[767] = y[18]*y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[770] = y[20]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + 2*y[18]*(p[13] + p[16]) + y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[771] = y[20]*y[18]*(-p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19])) + y[18]*y[14]*(-p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[772] = y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[773] = y[20]*y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[800] = y[18]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[801] = y[18]*y[14]*(p[17]*sin(y[19] - y[15]) + p[16]*cos(y[19] - y[15]));
out[804] = y[20]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19])) + 2*y[18]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[805] = y[20]*y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[806] = y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[807] = y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) + p[13]*cos(y[21] - y[19]));
out[838] = y[20]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[839] = y[20]*y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[840] = 2*y[20]*p[13] + y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[841] = y[20]*y[18]*(-p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[872] = y[20]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[873] = y[20]*y[18]*(p[14]*sin(y[21] - y[19]) + p[13]*cos(y[21] - y[19]));
out[874] = 2*y[20]*(-p[14] - 1.0/2.0*p[15]) + y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[875] = y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[884] = p[44]*(-y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]));
out[908] = p[44]*(-y[23]*sin(x[0] - y[21]) - y[24]*cos(x[0] - y[21]));
out[909] = p[44]*(y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]));
out[911] = p[44]*(-2*p[49]*y[23] - y[20]*sin(x[0] - y[21]));
out[912] = p[44]*(-2*p[49]*y[24] - y[20]*cos(x[0] - y[21]));
out[918] = -y[20]*cos(x[0] - y[21]);
out[942] = -sin(x[0] - y[21]);
out[943] = y[20]*cos(x[0] - y[21]);
out[952] = y[20]*sin(x[0] - y[21]);
out[976] = -cos(x[0] - y[21]);
out[977] = -y[20]*sin(x[0] - y[21]);
out[986] = y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]);
out[1010] = y[23]*sin(x[0] - y[21]) + y[24]*cos(x[0] - y[21]);
out[1011] = -y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]);
out[1013] = y[20]*sin(x[0] - y[21]);
out[1014] = y[20]*cos(x[0] - y[21]);
out[1020] = -y[20]*y[23]*sin(x[0] - y[21]) - y[20]*y[24]*cos(x[0] - y[21]);
out[1044] = y[23]*cos(x[0] - y[21]) - y[24]*sin(x[0] - y[21]);
out[1045] = y[20]*y[23]*sin(x[0] - y[21]) + y[20]*y[24]*cos(x[0] - y[21]);
out[1047] = y[20]*cos(x[0] - y[21]);
out[1048] = -y[20]*sin(x[0] - y[21]);

}

void de_jac_trap_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = 0.5*Dt*p[50] + 1;
out[26] = -0.5*Dt*p[43];
out[32] = 0.5*Dt*p[43];
out[65] = -0.5*Dt;
out[70] = 0.5*Dt/p[47] + 1;
out[98] = 0.5*Dt*p[46]/p[47];
out[134] = 0.5*Dt;
out[845] = -p[42]/p[0];
out[880] = -p[42]/p[0];
out[885] = p[44]/p[45];
out[915] = p[44];
out[945] = -p[49];
out[946] = p[48];
out[979] = -p[48];
out[980] = -p[49];
out[1080] = -1/p[52];
out[1087] = p[51];
out[1125] = p[54];
out[1154] = -p[53];

}

void de_jac_trap_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[35] = 1;
out[105] = 1;
out[910] = -1;
out[954] = 1;
out[1015] = -1;
out[1050] = -1;
out[1085] = -1;
out[1114] = 1;
out[1120] = -1;
out[1155] = -1;

}

void sp_jac_trap_xy_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[3] = -0.5*Dt*(-y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]));
out[5] = -0.5*Dt*(-y[23]*sin(x[0] - y[21]) - y[24]*cos(x[0] - y[21]));
out[6] = -0.5*Dt*(y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]));
out[7] = -0.5*Dt*(-2*p[49]*y[23] - y[20]*sin(x[0] - y[21]));
out[8] = -0.5*Dt*(-2*p[49]*y[24] - y[20]*cos(x[0] - y[21]));
out[14] = 2*y[0]*p[19] + y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[15] = y[0]*y[8]*(-p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[16] = y[0]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[17] = y[0]*y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[18] = 2*y[0]*(-p[20] - 1.0/2.0*p[21]) + y[8]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[19] = y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[20] = y[0]*(p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9]));
out[21] = y[0]*y[8]*(p[20]*sin(y[1] - y[9]) + p[19]*cos(y[1] - y[9]));
out[22] = 2*y[2]*p[22] + y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[23] = y[2]*y[10]*(-p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[24] = y[2]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[25] = y[2]*y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[26] = 2*y[2]*(-p[23] - 1.0/2.0*p[24]) + y[10]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[27] = y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[28] = y[2]*(p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11]));
out[29] = y[2]*y[10]*(p[23]*sin(y[3] - y[11]) + p[22]*cos(y[3] - y[11]));
out[30] = 2*y[4]*p[25] + y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[31] = y[4]*y[12]*(-p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[32] = y[4]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[33] = y[4]*y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[34] = 2*y[4]*(-p[26] - 1.0/2.0*p[27]) + y[12]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[35] = y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[36] = y[4]*(p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[37] = y[4]*y[12]*(p[26]*sin(y[5] - y[13]) + p[25]*cos(y[5] - y[13]));
out[38] = 2*y[6]*p[28] + y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[39] = y[6]*y[16]*(-p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[40] = y[6]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[41] = y[6]*y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[42] = 2*y[6]*(-p[29] - 1.0/2.0*p[30]) + y[16]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[43] = y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[44] = y[6]*(p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[45] = y[6]*y[16]*(p[29]*sin(y[7] - y[17]) + p[28]*cos(y[7] - y[17]));
out[46] = y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9]));
out[47] = y[0]*y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[48] = y[0]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + 2*y[8]*(p[19] + p[1]) + y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[49] = y[0]*y[8]*(-p[20]*cos(y[1] - y[9]) - p[19]*sin(y[1] - y[9])) + y[8]*y[10]*(-p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[50] = y[8]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[51] = y[8]*y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[52] = y[8]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9]));
out[53] = y[0]*y[8]*(-p[20]*sin(y[1] - y[9]) + p[19]*cos(y[1] - y[9]));
out[54] = y[0]*(p[20]*cos(y[1] - y[9]) + p[19]*sin(y[1] - y[9])) + 2*y[8]*(-p[20] - p[2] - 1.0/2.0*p[21] - 1.0/2.0*p[3]) + y[10]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[55] = y[0]*y[8]*(p[20]*sin(y[1] - y[9]) - p[19]*cos(y[1] - y[9])) + y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[56] = y[8]*(p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11]));
out[57] = y[8]*y[10]*(p[2]*sin(y[9] - y[11]) + p[1]*cos(y[9] - y[11]));
out[58] = y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11]));
out[59] = y[2]*y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[60] = y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11]));
out[61] = y[8]*y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[62] = y[8]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + 2*y[10]*(p[1] + p[22] + p[4]) + y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[63] = y[8]*y[10]*(-p[2]*cos(y[9] - y[11]) - p[1]*sin(y[9] - y[11])) + y[2]*y[10]*(-p[23]*cos(y[3] - y[11]) - p[22]*sin(y[3] - y[11])) + y[10]*y[12]*(-p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[64] = y[10]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[65] = y[10]*y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[66] = y[10]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11]));
out[67] = y[2]*y[10]*(-p[23]*sin(y[3] - y[11]) + p[22]*cos(y[3] - y[11]));
out[68] = y[10]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11]));
out[69] = y[8]*y[10]*(-p[2]*sin(y[9] - y[11]) + p[1]*cos(y[9] - y[11]));
out[70] = y[8]*(p[2]*cos(y[9] - y[11]) + p[1]*sin(y[9] - y[11])) + y[2]*(p[23]*cos(y[3] - y[11]) + p[22]*sin(y[3] - y[11])) + 2*y[10]*(-p[2] - p[23] - p[5] - 1.0/2.0*p[3] - 1.0/2.0*p[24] - 1.0/2.0*p[6]) + y[12]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[71] = y[8]*y[10]*(p[2]*sin(y[9] - y[11]) - p[1]*cos(y[9] - y[11])) + y[2]*y[10]*(p[23]*sin(y[3] - y[11]) - p[22]*cos(y[3] - y[11])) + y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[72] = y[10]*(p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13]));
out[73] = y[10]*y[12]*(p[5]*sin(y[11] - y[13]) + p[4]*cos(y[11] - y[13]));
out[74] = y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[75] = y[4]*y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[76] = y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13]));
out[77] = y[10]*y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[78] = y[14]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13])) + 2*y[12]*(p[4] + p[7] + p[25]);
out[79] = y[14]*y[12]*(-p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13])) + y[10]*y[12]*(-p[5]*cos(y[11] - y[13]) - p[4]*sin(y[11] - y[13])) + y[4]*y[12]*(-p[26]*cos(y[5] - y[13]) - p[25]*sin(y[5] - y[13]));
out[80] = y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[81] = y[14]*y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[82] = y[12]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13]));
out[83] = y[4]*y[12]*(-p[26]*sin(y[5] - y[13]) + p[25]*cos(y[5] - y[13]));
out[84] = y[12]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13]));
out[85] = y[10]*y[12]*(-p[5]*sin(y[11] - y[13]) + p[4]*cos(y[11] - y[13]));
out[86] = y[14]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13])) + y[10]*(p[5]*cos(y[11] - y[13]) + p[4]*sin(y[11] - y[13])) + y[4]*(p[26]*cos(y[5] - y[13]) + p[25]*sin(y[5] - y[13])) + 2*y[12]*(-p[5] - p[8] - p[26] - 1.0/2.0*p[6] - 1.0/2.0*p[9] - 1.0/2.0*p[27]);
out[87] = y[14]*y[12]*(p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13])) + y[10]*y[12]*(p[5]*sin(y[11] - y[13]) - p[4]*cos(y[11] - y[13])) + y[4]*y[12]*(p[26]*sin(y[5] - y[13]) - p[25]*cos(y[5] - y[13]));
out[88] = y[12]*(p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[89] = y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) + p[7]*cos(y[15] - y[13]));
out[90] = y[14]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[91] = y[14]*y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[92] = y[18]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + 2*y[14]*(p[16] + p[10] + p[7]) + y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[93] = y[18]*y[14]*(-p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15])) + y[14]*y[16]*(-p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[14]*y[12]*(-p[8]*cos(y[15] - y[13]) + p[7]*sin(y[15] - y[13]));
out[94] = y[14]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17]));
out[95] = y[14]*y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17]));
out[96] = y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[97] = y[18]*y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[98] = y[14]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[99] = y[14]*y[12]*(p[8]*sin(y[15] - y[13]) + p[7]*cos(y[15] - y[13]));
out[100] = y[18]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15])) + 2*y[14]*(-p[17] - p[11] - p[8] - 1.0/2.0*p[18] - 1.0/2.0*p[12] - 1.0/2.0*p[9]) + y[16]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[12]*(p[8]*cos(y[15] - y[13]) - p[7]*sin(y[15] - y[13]));
out[101] = y[18]*y[14]*(p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15])) + y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[14]*y[12]*(-p[8]*sin(y[15] - y[13]) - p[7]*cos(y[15] - y[13]));
out[102] = y[14]*(p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17]));
out[103] = y[14]*y[16]*(p[11]*sin(y[15] - y[17]) + p[10]*cos(y[15] - y[17]));
out[104] = y[14]*(p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[105] = y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) + p[16]*cos(y[19] - y[15]));
out[106] = y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[107] = y[6]*y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[108] = y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17]));
out[109] = y[14]*y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17]));
out[110] = y[14]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17])) + 2*y[16]*(p[10] + p[28]);
out[111] = y[14]*y[16]*(-p[11]*cos(y[15] - y[17]) - p[10]*sin(y[15] - y[17])) + y[6]*y[16]*(-p[29]*cos(y[7] - y[17]) - p[28]*sin(y[7] - y[17]));
out[112] = y[16]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17]));
out[113] = y[6]*y[16]*(-p[29]*sin(y[7] - y[17]) + p[28]*cos(y[7] - y[17]));
out[114] = y[16]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17]));
out[115] = y[14]*y[16]*(-p[11]*sin(y[15] - y[17]) + p[10]*cos(y[15] - y[17]));
out[116] = y[14]*(p[11]*cos(y[15] - y[17]) + p[10]*sin(y[15] - y[17])) + y[6]*(p[29]*cos(y[7] - y[17]) + p[28]*sin(y[7] - y[17])) + 2*y[16]*(-p[11] - p[29] - 1.0/2.0*p[12] - 1.0/2.0*p[30]);
out[117] = y[14]*y[16]*(p[11]*sin(y[15] - y[17]) - p[10]*cos(y[15] - y[17])) + y[6]*y[16]*(p[29]*sin(y[7] - y[17]) - p[28]*cos(y[7] - y[17]));
out[118] = y[18]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[119] = y[18]*y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[120] = y[20]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + 2*y[18]*(p[13] + p[16]) + y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[121] = y[20]*y[18]*(-p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19])) + y[18]*y[14]*(-p[17]*cos(y[19] - y[15]) + p[16]*sin(y[19] - y[15]));
out[122] = y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[123] = y[20]*y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[124] = y[18]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[125] = y[18]*y[14]*(p[17]*sin(y[19] - y[15]) + p[16]*cos(y[19] - y[15]));
out[126] = y[20]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19])) + 2*y[18]*(-p[14] - p[17] - 1.0/2.0*p[15] - 1.0/2.0*p[18]) + y[14]*(p[17]*cos(y[19] - y[15]) - p[16]*sin(y[19] - y[15]));
out[127] = y[20]*y[18]*(p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19])) + y[18]*y[14]*(-p[17]*sin(y[19] - y[15]) - p[16]*cos(y[19] - y[15]));
out[128] = y[18]*(p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[129] = y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) + p[13]*cos(y[21] - y[19]));
out[130] = y[20]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[131] = y[20]*y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[132] = 2*y[20]*p[13] + y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[133] = y[20]*y[18]*(-p[14]*cos(y[21] - y[19]) + p[13]*sin(y[21] - y[19]));
out[135] = y[20]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[136] = y[20]*y[18]*(p[14]*sin(y[21] - y[19]) + p[13]*cos(y[21] - y[19]));
out[137] = 2*y[20]*(-p[14] - 1.0/2.0*p[15]) + y[18]*(p[14]*cos(y[21] - y[19]) - p[13]*sin(y[21] - y[19]));
out[138] = y[20]*y[18]*(-p[14]*sin(y[21] - y[19]) - p[13]*cos(y[21] - y[19]));
out[140] = p[44]*(-y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]));
out[142] = p[44]*(-y[23]*sin(x[0] - y[21]) - y[24]*cos(x[0] - y[21]));
out[143] = p[44]*(y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]));
out[145] = p[44]*(-2*p[49]*y[23] - y[20]*sin(x[0] - y[21]));
out[146] = p[44]*(-2*p[49]*y[24] - y[20]*cos(x[0] - y[21]));
out[148] = -y[20]*cos(x[0] - y[21]);
out[149] = -sin(x[0] - y[21]);
out[150] = y[20]*cos(x[0] - y[21]);
out[153] = y[20]*sin(x[0] - y[21]);
out[155] = -cos(x[0] - y[21]);
out[156] = -y[20]*sin(x[0] - y[21]);
out[159] = y[20]*y[23]*cos(x[0] - y[21]) - y[20]*y[24]*sin(x[0] - y[21]);
out[160] = y[23]*sin(x[0] - y[21]) + y[24]*cos(x[0] - y[21]);
out[161] = -y[20]*y[23]*cos(x[0] - y[21]) + y[20]*y[24]*sin(x[0] - y[21]);
out[162] = y[20]*sin(x[0] - y[21]);
out[163] = y[20]*cos(x[0] - y[21]);
out[165] = -y[20]*y[23]*sin(x[0] - y[21]) - y[20]*y[24]*cos(x[0] - y[21]);
out[166] = y[23]*cos(x[0] - y[21]) - y[24]*sin(x[0] - y[21]);
out[167] = y[20]*y[23]*sin(x[0] - y[21]) + y[20]*y[24]*cos(x[0] - y[21]);
out[168] = y[20]*cos(x[0] - y[21]);
out[169] = -y[20]*sin(x[0] - y[21]);

}

void sp_jac_trap_up_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[0] = 0.5*Dt*p[50] + 1;
out[1] = -0.5*Dt*p[43];
out[2] = 0.5*Dt*p[43];
out[9] = -0.5*Dt;
out[10] = 0.5*Dt/p[47] + 1;
out[11] = 0.5*Dt*p[46]/p[47];
out[13] = 0.5*Dt;
out[134] = -p[42]/p[0];
out[139] = -p[42]/p[0];
out[141] = p[44]/p[45];
out[147] = p[44];
out[151] = -p[49];
out[152] = p[48];
out[157] = -p[48];
out[158] = -p[49];
out[171] = -1/p[52];
out[173] = p[51];
out[176] = p[54];
out[177] = -p[53];

}

void sp_jac_trap_num_eval(double *out,double *x,double *y,double *u,double *p,double Dt){

out[4] = 1;
out[12] = 1;
out[144] = -1;
out[154] = 1;
out[164] = -1;
out[170] = -1;
out[172] = -1;
out[174] = 1;
out[175] = -1;
out[178] = -1;

}



/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // void()(double *, double *, double *, double *, double *, double)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 6), // double *
/*  2 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  3 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  4 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  5 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static void _cffi_d_de_jac_ini_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_ini_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_ini_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_ini_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_ini_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_ini_num_eval _cffi_d_de_jac_ini_num_eval
#endif

static void _cffi_d_de_jac_ini_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_ini_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_ini_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_ini_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_ini_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_ini_up_eval _cffi_d_de_jac_ini_up_eval
#endif

static void _cffi_d_de_jac_ini_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_ini_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_ini_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_ini_xy_eval _cffi_d_de_jac_ini_xy_eval
#endif

static void _cffi_d_de_jac_trap_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_trap_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_trap_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_trap_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_trap_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_trap_num_eval _cffi_d_de_jac_trap_num_eval
#endif

static void _cffi_d_de_jac_trap_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_trap_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_trap_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_trap_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_trap_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_trap_up_eval _cffi_d_de_jac_trap_up_eval
#endif

static void _cffi_d_de_jac_trap_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  de_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_de_jac_trap_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "de_jac_trap_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { de_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_de_jac_trap_xy_eval _cffi_d_de_jac_trap_xy_eval
#endif

static void _cffi_d_f_ini_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  f_ini_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_f_ini_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "f_ini_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { f_ini_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_f_ini_eval _cffi_d_f_ini_eval
#endif

static void _cffi_d_f_run_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  f_run_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_f_run_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "f_run_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { f_run_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_f_run_eval _cffi_d_f_run_eval
#endif

static void _cffi_d_g_ini_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  g_ini_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_ini_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "g_ini_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_ini_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_ini_eval _cffi_d_g_ini_eval
#endif

static void _cffi_d_g_run_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  g_run_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_run_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "g_run_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_run_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_run_eval _cffi_d_g_run_eval
#endif

static void _cffi_d_h_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  h_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_h_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "h_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { h_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_h_eval _cffi_d_h_eval
#endif

static void _cffi_d_sp_jac_ini_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_num_eval _cffi_d_sp_jac_ini_num_eval
#endif

static void _cffi_d_sp_jac_ini_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_up_eval _cffi_d_sp_jac_ini_up_eval
#endif

static void _cffi_d_sp_jac_ini_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_ini_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_ini_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_ini_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_ini_xy_eval _cffi_d_sp_jac_ini_xy_eval
#endif

static void _cffi_d_sp_jac_trap_num_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_trap_num_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_trap_num_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_trap_num_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_trap_num_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_trap_num_eval _cffi_d_sp_jac_trap_num_eval
#endif

static void _cffi_d_sp_jac_trap_up_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_trap_up_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_trap_up_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_trap_up_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_trap_up_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_trap_up_eval _cffi_d_sp_jac_trap_up_eval
#endif

static void _cffi_d_sp_jac_trap_xy_eval(double * x0, double * x1, double * x2, double * x3, double * x4, double x5)
{
  sp_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sp_jac_trap_xy_eval(PyObject *self, PyObject *args)
{
  double * x0;
  double * x1;
  double * x2;
  double * x3;
  double * x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "sp_jac_trap_xy_eval", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sp_jac_trap_xy_eval(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sp_jac_trap_xy_eval _cffi_d_sp_jac_trap_xy_eval
#endif

static const struct _cffi_global_s _cffi_globals[] = {
  { "de_jac_ini_num_eval", (void *)_cffi_f_de_jac_ini_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_ini_num_eval },
  { "de_jac_ini_up_eval", (void *)_cffi_f_de_jac_ini_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_ini_up_eval },
  { "de_jac_ini_xy_eval", (void *)_cffi_f_de_jac_ini_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_ini_xy_eval },
  { "de_jac_trap_num_eval", (void *)_cffi_f_de_jac_trap_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_trap_num_eval },
  { "de_jac_trap_up_eval", (void *)_cffi_f_de_jac_trap_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_trap_up_eval },
  { "de_jac_trap_xy_eval", (void *)_cffi_f_de_jac_trap_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_de_jac_trap_xy_eval },
  { "f_ini_eval", (void *)_cffi_f_f_ini_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_f_ini_eval },
  { "f_run_eval", (void *)_cffi_f_f_run_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_f_run_eval },
  { "g_ini_eval", (void *)_cffi_f_g_ini_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_g_ini_eval },
  { "g_run_eval", (void *)_cffi_f_g_run_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_g_run_eval },
  { "h_eval", (void *)_cffi_f_h_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_h_eval },
  { "sp_jac_ini_num_eval", (void *)_cffi_f_sp_jac_ini_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_num_eval },
  { "sp_jac_ini_up_eval", (void *)_cffi_f_sp_jac_ini_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_up_eval },
  { "sp_jac_ini_xy_eval", (void *)_cffi_f_sp_jac_ini_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_ini_xy_eval },
  { "sp_jac_trap_num_eval", (void *)_cffi_f_sp_jac_trap_num_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_trap_num_eval },
  { "sp_jac_trap_up_eval", (void *)_cffi_f_sp_jac_trap_up_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_trap_up_eval },
  { "sp_jac_trap_xy_eval", (void *)_cffi_f_sp_jac_trap_xy_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_sp_jac_trap_xy_eval },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  NULL,  /* no struct_unions */
  NULL,  /* no enums */
  NULL,  /* no typenames */
  17,  /* num_globals */
  0,  /* num_struct_unions */
  0,  /* num_enums */
  0,  /* num_typenames */
  NULL,  /* no includes */
  9,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit_wind_farm_cffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit_wind_farm_cffi(void) { return NULL; }
#  else
     initwind_farm_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit_wind_farm_cffi(void)
{
  return _cffi_init("wind_farm_cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
initwind_farm_cffi(void)
{
  _cffi_init("wind_farm_cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
