import numpy as np
import numba
import scipy.optimize as sopt
import json

sin = np.sin
cos = np.cos
atan2 = np.arctan2
sqrt = np.sqrt 
sign = np.sign 


class cigre_europe_residential_2w2w_class: 

    def __init__(self): 

        self.t_end = 10.000000 
        self.Dt = 0.0010000 
        self.decimation = 10.000000 
        self.itol = 1e-6 
        self.Dt_max = 0.001000 
        self.Dt_min = 0.001000 
        self.solvern = 5 
        self.imax = 100 
        self.N_x = 1
        self.N_y = 415 
        self.N_z = 123 
        self.N_store = 10000 
        self.params_list = ['a_R1', 'b_R1', 'c_R1', 'a_R10', 'b_R10', 'c_R10', 'coef_a_R10', 'coef_b_R10', 'coef_c_R10', 'a_R14', 'b_R14', 'c_R14', 'coef_a_R14', 'coef_b_R14', 'coef_c_R14'] 
        self.params_values_list  = [2.92, 0.45, 0.027, 2.92, 0.45, 0.027, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 2.92, 0.45, 0.027, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333] 
        self.inputs_ini_list = ['v_R0_a_r', 'v_R0_a_i', 'v_R0_b_r', 'v_R0_b_i', 'v_R0_c_r', 'v_R0_c_i', 'v_D1_a_r', 'v_D1_a_i', 'v_D1_b_r', 'v_D1_b_i', 'v_D1_c_r', 'v_D1_c_i', 'i_R1_n_r', 'i_R1_n_i', 'i_R2_a_r', 'i_R2_a_i', 'i_R2_b_r', 'i_R2_b_i', 'i_R2_c_r', 'i_R2_c_i', 'i_R2_n_r', 'i_R2_n_i', 'i_R3_a_r', 'i_R3_a_i', 'i_R3_b_r', 'i_R3_b_i', 'i_R3_c_r', 'i_R3_c_i', 'i_R3_n_r', 'i_R3_n_i', 'i_R4_a_r', 'i_R4_a_i', 'i_R4_b_r', 'i_R4_b_i', 'i_R4_c_r', 'i_R4_c_i', 'i_R4_n_r', 'i_R4_n_i', 'i_R5_a_r', 'i_R5_a_i', 'i_R5_b_r', 'i_R5_b_i', 'i_R5_c_r', 'i_R5_c_i', 'i_R5_n_r', 'i_R5_n_i', 'i_R6_a_r', 'i_R6_a_i', 'i_R6_b_r', 'i_R6_b_i', 'i_R6_c_r', 'i_R6_c_i', 'i_R6_n_r', 'i_R6_n_i', 'i_R7_a_r', 'i_R7_a_i', 'i_R7_b_r', 'i_R7_b_i', 'i_R7_c_r', 'i_R7_c_i', 'i_R7_n_r', 'i_R7_n_i', 'i_R8_a_r', 'i_R8_a_i', 'i_R8_b_r', 'i_R8_b_i', 'i_R8_c_r', 'i_R8_c_i', 'i_R8_n_r', 'i_R8_n_i', 'i_R9_a_r', 'i_R9_a_i', 'i_R9_b_r', 'i_R9_b_i', 'i_R9_c_r', 'i_R9_c_i', 'i_R9_n_r', 'i_R9_n_i', 'i_R10_a_r', 'i_R10_a_i', 'i_R10_b_r', 'i_R10_b_i', 'i_R10_c_r', 'i_R10_c_i', 'i_R10_n_r', 'i_R10_n_i', 'i_R11_b_r', 'i_R11_b_i', 'i_R11_c_r', 'i_R11_c_i', 'i_R12_a_r', 'i_R12_a_i', 'i_R12_b_r', 'i_R12_b_i', 'i_R12_c_r', 'i_R12_c_i', 'i_R12_n_r', 'i_R12_n_i', 'i_R13_a_r', 'i_R13_a_i', 'i_R13_b_r', 'i_R13_b_i', 'i_R13_c_r', 'i_R13_c_i', 'i_R13_n_r', 'i_R13_n_i', 'i_R14_a_r', 'i_R14_a_i', 'i_R14_b_r', 'i_R14_b_i', 'i_R14_c_r', 'i_R14_c_i', 'i_R14_n_r', 'i_R14_n_i', 'i_R15_b_r', 'i_R15_b_i', 'i_R15_c_r', 'i_R15_c_i', 'i_R16_b_r', 'i_R16_b_i', 'i_R16_c_r', 'i_R16_c_i', 'i_R17_b_r', 'i_R17_b_i', 'i_R17_c_r', 'i_R17_c_i', 'i_R18_b_r', 'i_R18_b_i', 'i_R18_c_r', 'i_R18_c_i', 'i_D1_n_r', 'i_D1_n_i', 'i_D3_a_r', 'i_D3_a_i', 'i_D3_b_r', 'i_D3_b_i', 'i_D3_c_r', 'i_D3_c_i', 'i_D3_n_r', 'i_D3_n_i', 'i_D4_a_r', 'i_D4_a_i', 'i_D4_b_r', 'i_D4_b_i', 'i_D4_c_r', 'i_D4_c_i', 'i_D4_n_r', 'i_D4_n_i', 'i_D6_a_r', 'i_D6_a_i', 'i_D6_b_r', 'i_D6_b_i', 'i_D6_c_r', 'i_D6_c_i', 'i_D6_n_r', 'i_D6_n_i', 'i_D9_a_r', 'i_D9_a_i', 'i_D9_b_r', 'i_D9_b_i', 'i_D9_c_r', 'i_D9_c_i', 'i_D9_n_r', 'i_D9_n_i', 'i_D10_a_i', 'i_D10_b_r', 'i_D10_b_i', 'i_D10_c_r', 'i_D10_c_i', 'i_D10_n_i', 'i_D11_b_r', 'i_D11_b_i', 'i_D11_c_r', 'i_D11_c_i', 'i_D16_b_r', 'i_D16_b_i', 'i_D16_c_r', 'i_D16_c_i', 'i_D17_b_r', 'i_D17_b_i', 'i_D17_c_r', 'i_D17_c_i', 'i_D18_b_r', 'i_D18_b_i', 'i_D18_c_r', 'i_D18_c_i', 'i_D14_a_i', 'i_D14_b_r', 'i_D14_b_i', 'i_D14_c_r', 'i_D14_c_i', 'i_D14_n_i', 'i_D15_b_r', 'i_D15_b_i', 'i_D15_c_r', 'i_D15_c_i', 'p_R1_a', 'q_R1_a', 'p_R1_b', 'q_R1_b', 'p_R1_c', 'q_R1_c', 'p_R11_1', 'q_R11_1', 'p_R15_1', 'q_R15_1', 'p_R16_1', 'q_R16_1', 'p_R17_1', 'q_R17_1', 'p_R18_1', 'q_R18_1', 'p_D15_1', 'q_D15_1', 'p_D11_1', 'q_D11_1', 'p_D16_1', 'q_D16_1', 'p_D17_1', 'q_D17_1', 'p_D18_1', 'q_D18_1', 'v_dc_D1', 'q_R1', 'p_R10', 'q_R10', 'p_R14', 'q_R14', 'u_dummy'] 
        self.inputs_ini_values_list  = [11547.0, 0.0, -5773.499999999997, -9999.995337498915, -5773.5000000000055, 9999.99533749891, 800.0, 0.0, 0.0, -0.0, -0.0, 0.0, -18.49976272668728, -18.378083261800555, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -58079.06784590579, -22452.930942522245, -63333.33333333353, -20816.659994662383, -63333.333333333336, -20816.659994661335, -11528.604616828328, -7449.2956432757255, 6728.651805158721, -54893.01762685182, -25505.401705905973, -42842.66347905425, -9336.351172818911, -29283.32675941138, -7212.369818499643, -41014.235969431895, 174505.2828211094, 0.0, 174505.2828211094, 0.0, 174505.28282110934, 0.0, 174505.28282110937, 0.0, 174505.28282110937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0] 
        self.inputs_run_list = ['v_R0_a_r', 'v_R0_a_i', 'v_R0_b_r', 'v_R0_b_i', 'v_R0_c_r', 'v_R0_c_i', 'v_D1_a_r', 'v_D1_a_i', 'v_D1_b_r', 'v_D1_b_i', 'v_D1_c_r', 'v_D1_c_i', 'i_R1_n_r', 'i_R1_n_i', 'i_R2_a_r', 'i_R2_a_i', 'i_R2_b_r', 'i_R2_b_i', 'i_R2_c_r', 'i_R2_c_i', 'i_R2_n_r', 'i_R2_n_i', 'i_R3_a_r', 'i_R3_a_i', 'i_R3_b_r', 'i_R3_b_i', 'i_R3_c_r', 'i_R3_c_i', 'i_R3_n_r', 'i_R3_n_i', 'i_R4_a_r', 'i_R4_a_i', 'i_R4_b_r', 'i_R4_b_i', 'i_R4_c_r', 'i_R4_c_i', 'i_R4_n_r', 'i_R4_n_i', 'i_R5_a_r', 'i_R5_a_i', 'i_R5_b_r', 'i_R5_b_i', 'i_R5_c_r', 'i_R5_c_i', 'i_R5_n_r', 'i_R5_n_i', 'i_R6_a_r', 'i_R6_a_i', 'i_R6_b_r', 'i_R6_b_i', 'i_R6_c_r', 'i_R6_c_i', 'i_R6_n_r', 'i_R6_n_i', 'i_R7_a_r', 'i_R7_a_i', 'i_R7_b_r', 'i_R7_b_i', 'i_R7_c_r', 'i_R7_c_i', 'i_R7_n_r', 'i_R7_n_i', 'i_R8_a_r', 'i_R8_a_i', 'i_R8_b_r', 'i_R8_b_i', 'i_R8_c_r', 'i_R8_c_i', 'i_R8_n_r', 'i_R8_n_i', 'i_R9_a_r', 'i_R9_a_i', 'i_R9_b_r', 'i_R9_b_i', 'i_R9_c_r', 'i_R9_c_i', 'i_R9_n_r', 'i_R9_n_i', 'i_R10_a_r', 'i_R10_a_i', 'i_R10_b_r', 'i_R10_b_i', 'i_R10_c_r', 'i_R10_c_i', 'i_R10_n_r', 'i_R10_n_i', 'i_R11_b_r', 'i_R11_b_i', 'i_R11_c_r', 'i_R11_c_i', 'i_R12_a_r', 'i_R12_a_i', 'i_R12_b_r', 'i_R12_b_i', 'i_R12_c_r', 'i_R12_c_i', 'i_R12_n_r', 'i_R12_n_i', 'i_R13_a_r', 'i_R13_a_i', 'i_R13_b_r', 'i_R13_b_i', 'i_R13_c_r', 'i_R13_c_i', 'i_R13_n_r', 'i_R13_n_i', 'i_R14_a_r', 'i_R14_a_i', 'i_R14_b_r', 'i_R14_b_i', 'i_R14_c_r', 'i_R14_c_i', 'i_R14_n_r', 'i_R14_n_i', 'i_R15_b_r', 'i_R15_b_i', 'i_R15_c_r', 'i_R15_c_i', 'i_R16_b_r', 'i_R16_b_i', 'i_R16_c_r', 'i_R16_c_i', 'i_R17_b_r', 'i_R17_b_i', 'i_R17_c_r', 'i_R17_c_i', 'i_R18_b_r', 'i_R18_b_i', 'i_R18_c_r', 'i_R18_c_i', 'i_D1_n_r', 'i_D1_n_i', 'i_D3_a_r', 'i_D3_a_i', 'i_D3_b_r', 'i_D3_b_i', 'i_D3_c_r', 'i_D3_c_i', 'i_D3_n_r', 'i_D3_n_i', 'i_D4_a_r', 'i_D4_a_i', 'i_D4_b_r', 'i_D4_b_i', 'i_D4_c_r', 'i_D4_c_i', 'i_D4_n_r', 'i_D4_n_i', 'i_D6_a_r', 'i_D6_a_i', 'i_D6_b_r', 'i_D6_b_i', 'i_D6_c_r', 'i_D6_c_i', 'i_D6_n_r', 'i_D6_n_i', 'i_D9_a_r', 'i_D9_a_i', 'i_D9_b_r', 'i_D9_b_i', 'i_D9_c_r', 'i_D9_c_i', 'i_D9_n_r', 'i_D9_n_i', 'i_D10_a_i', 'i_D10_b_r', 'i_D10_b_i', 'i_D10_c_r', 'i_D10_c_i', 'i_D10_n_i', 'i_D11_b_r', 'i_D11_b_i', 'i_D11_c_r', 'i_D11_c_i', 'i_D16_b_r', 'i_D16_b_i', 'i_D16_c_r', 'i_D16_c_i', 'i_D17_b_r', 'i_D17_b_i', 'i_D17_c_r', 'i_D17_c_i', 'i_D18_b_r', 'i_D18_b_i', 'i_D18_c_r', 'i_D18_c_i', 'i_D14_a_i', 'i_D14_b_r', 'i_D14_b_i', 'i_D14_c_r', 'i_D14_c_i', 'i_D14_n_i', 'i_D15_b_r', 'i_D15_b_i', 'i_D15_c_r', 'i_D15_c_i', 'p_R1_a', 'q_R1_a', 'p_R1_b', 'q_R1_b', 'p_R1_c', 'q_R1_c', 'p_R11_1', 'q_R11_1', 'p_R15_1', 'q_R15_1', 'p_R16_1', 'q_R16_1', 'p_R17_1', 'q_R17_1', 'p_R18_1', 'q_R18_1', 'p_D15_1', 'q_D15_1', 'p_D11_1', 'q_D11_1', 'p_D16_1', 'q_D16_1', 'p_D17_1', 'q_D17_1', 'p_D18_1', 'q_D18_1', 'v_dc_D1', 'q_R1', 'p_R10', 'q_R10', 'p_R14', 'q_R14', 'u_dummy'] 
        self.inputs_run_values_list = [11547.0, 0.0, -5773.499999999997, -9999.995337498915, -5773.5000000000055, 9999.99533749891, 800.0, 0.0, 0.0, -0.0, -0.0, 0.0, -18.49976272668728, -18.378083261800555, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -58079.06784590579, -22452.930942522245, -63333.33333333353, -20816.659994662383, -63333.333333333336, -20816.659994661335, -11528.604616828328, -7449.2956432757255, 6728.651805158721, -54893.01762685182, -25505.401705905973, -42842.66347905425, -9336.351172818911, -29283.32675941138, -7212.369818499643, -41014.235969431895, 174505.2828211094, 0.0, 174505.2828211094, 0.0, 174505.28282110934, 0.0, 174505.28282110937, 0.0, 174505.28282110937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0] 
        self.outputs_list = ['v_R0_a_m', 'v_R0_b_m', 'v_R0_c_m', 'v_D1_a_m', 'v_D1_b_m', 'v_D1_c_m', 'v_R1_a_m', 'v_R1_b_m', 'v_R1_c_m', 'v_R1_n_m', 'v_R11_a_m', 'v_R11_n_m', 'v_R15_a_m', 'v_R15_n_m', 'v_R16_a_m', 'v_R16_n_m', 'v_R17_a_m', 'v_R17_n_m', 'v_R18_a_m', 'v_R18_n_m', 'v_D15_a_m', 'v_D15_n_m', 'v_D11_a_m', 'v_D11_n_m', 'v_D16_a_m', 'v_D16_n_m', 'v_D17_a_m', 'v_D17_n_m', 'v_D18_a_m', 'v_D18_n_m', 'v_R2_a_m', 'v_R2_b_m', 'v_R2_c_m', 'v_R2_n_m', 'v_R3_a_m', 'v_R3_b_m', 'v_R3_c_m', 'v_R3_n_m', 'v_R4_a_m', 'v_R4_b_m', 'v_R4_c_m', 'v_R4_n_m', 'v_R5_a_m', 'v_R5_b_m', 'v_R5_c_m', 'v_R5_n_m', 'v_R6_a_m', 'v_R6_b_m', 'v_R6_c_m', 'v_R6_n_m', 'v_R7_a_m', 'v_R7_b_m', 'v_R7_c_m', 'v_R7_n_m', 'v_R8_a_m', 'v_R8_b_m', 'v_R8_c_m', 'v_R8_n_m', 'v_R9_a_m', 'v_R9_b_m', 'v_R9_c_m', 'v_R9_n_m', 'v_R10_a_m', 'v_R10_b_m', 'v_R10_c_m', 'v_R10_n_m', 'v_R11_b_m', 'v_R11_c_m', 'v_R12_a_m', 'v_R12_b_m', 'v_R12_c_m', 'v_R12_n_m', 'v_R13_a_m', 'v_R13_b_m', 'v_R13_c_m', 'v_R13_n_m', 'v_R14_a_m', 'v_R14_b_m', 'v_R14_c_m', 'v_R14_n_m', 'v_R15_b_m', 'v_R15_c_m', 'v_R16_b_m', 'v_R16_c_m', 'v_R17_b_m', 'v_R17_c_m', 'v_R18_b_m', 'v_R18_c_m', 'v_D1_n_m', 'v_D3_a_m', 'v_D3_b_m', 'v_D3_c_m', 'v_D3_n_m', 'v_D4_a_m', 'v_D4_b_m', 'v_D4_c_m', 'v_D4_n_m', 'v_D6_a_m', 'v_D6_b_m', 'v_D6_c_m', 'v_D6_n_m', 'v_D9_a_m', 'v_D9_b_m', 'v_D9_c_m', 'v_D9_n_m', 'v_D10_a_m', 'v_D10_b_m', 'v_D10_c_m', 'v_D10_n_m', 'v_D11_b_m', 'v_D11_c_m', 'v_D16_b_m', 'v_D16_c_m', 'v_D17_b_m', 'v_D17_c_m', 'v_D18_b_m', 'v_D18_c_m', 'v_D14_a_m', 'v_D14_b_m', 'v_D14_c_m', 'v_D14_n_m', 'v_D15_b_m', 'v_D15_c_m'] 
        self.x_list = ['x_dummy'] 
        self.y_run_list = ['v_R1_a_r', 'v_R1_a_i', 'v_R1_b_r', 'v_R1_b_i', 'v_R1_c_r', 'v_R1_c_i', 'v_R1_n_r', 'v_R1_n_i', 'v_R11_a_r', 'v_R11_a_i', 'v_R11_n_r', 'v_R11_n_i', 'v_R15_a_r', 'v_R15_a_i', 'v_R15_n_r', 'v_R15_n_i', 'v_R16_a_r', 'v_R16_a_i', 'v_R16_n_r', 'v_R16_n_i', 'v_R17_a_r', 'v_R17_a_i', 'v_R17_n_r', 'v_R17_n_i', 'v_R18_a_r', 'v_R18_a_i', 'v_R18_n_r', 'v_R18_n_i', 'v_D15_a_r', 'v_D15_a_i', 'v_D15_n_r', 'v_D15_n_i', 'v_D11_a_r', 'v_D11_a_i', 'v_D11_n_r', 'v_D11_n_i', 'v_D16_a_r', 'v_D16_a_i', 'v_D16_n_r', 'v_D16_n_i', 'v_D17_a_r', 'v_D17_a_i', 'v_D17_n_r', 'v_D17_n_i', 'v_D18_a_r', 'v_D18_a_i', 'v_D18_n_r', 'v_D18_n_i', 'v_R2_a_r', 'v_R2_a_i', 'v_R2_b_r', 'v_R2_b_i', 'v_R2_c_r', 'v_R2_c_i', 'v_R2_n_r', 'v_R2_n_i', 'v_R3_a_r', 'v_R3_a_i', 'v_R3_b_r', 'v_R3_b_i', 'v_R3_c_r', 'v_R3_c_i', 'v_R3_n_r', 'v_R3_n_i', 'v_R4_a_r', 'v_R4_a_i', 'v_R4_b_r', 'v_R4_b_i', 'v_R4_c_r', 'v_R4_c_i', 'v_R4_n_r', 'v_R4_n_i', 'v_R5_a_r', 'v_R5_a_i', 'v_R5_b_r', 'v_R5_b_i', 'v_R5_c_r', 'v_R5_c_i', 'v_R5_n_r', 'v_R5_n_i', 'v_R6_a_r', 'v_R6_a_i', 'v_R6_b_r', 'v_R6_b_i', 'v_R6_c_r', 'v_R6_c_i', 'v_R6_n_r', 'v_R6_n_i', 'v_R7_a_r', 'v_R7_a_i', 'v_R7_b_r', 'v_R7_b_i', 'v_R7_c_r', 'v_R7_c_i', 'v_R7_n_r', 'v_R7_n_i', 'v_R8_a_r', 'v_R8_a_i', 'v_R8_b_r', 'v_R8_b_i', 'v_R8_c_r', 'v_R8_c_i', 'v_R8_n_r', 'v_R8_n_i', 'v_R9_a_r', 'v_R9_a_i', 'v_R9_b_r', 'v_R9_b_i', 'v_R9_c_r', 'v_R9_c_i', 'v_R9_n_r', 'v_R9_n_i', 'v_R10_a_r', 'v_R10_a_i', 'v_R10_b_r', 'v_R10_b_i', 'v_R10_c_r', 'v_R10_c_i', 'v_R10_n_r', 'v_R10_n_i', 'v_R11_b_r', 'v_R11_b_i', 'v_R11_c_r', 'v_R11_c_i', 'v_R12_a_r', 'v_R12_a_i', 'v_R12_b_r', 'v_R12_b_i', 'v_R12_c_r', 'v_R12_c_i', 'v_R12_n_r', 'v_R12_n_i', 'v_R13_a_r', 'v_R13_a_i', 'v_R13_b_r', 'v_R13_b_i', 'v_R13_c_r', 'v_R13_c_i', 'v_R13_n_r', 'v_R13_n_i', 'v_R14_a_r', 'v_R14_a_i', 'v_R14_b_r', 'v_R14_b_i', 'v_R14_c_r', 'v_R14_c_i', 'v_R14_n_r', 'v_R14_n_i', 'v_R15_b_r', 'v_R15_b_i', 'v_R15_c_r', 'v_R15_c_i', 'v_R16_b_r', 'v_R16_b_i', 'v_R16_c_r', 'v_R16_c_i', 'v_R17_b_r', 'v_R17_b_i', 'v_R17_c_r', 'v_R17_c_i', 'v_R18_b_r', 'v_R18_b_i', 'v_R18_c_r', 'v_R18_c_i', 'v_D1_n_r', 'v_D1_n_i', 'v_D3_a_r', 'v_D3_a_i', 'v_D3_b_r', 'v_D3_b_i', 'v_D3_c_r', 'v_D3_c_i', 'v_D3_n_r', 'v_D3_n_i', 'v_D4_a_r', 'v_D4_a_i', 'v_D4_b_r', 'v_D4_b_i', 'v_D4_c_r', 'v_D4_c_i', 'v_D4_n_r', 'v_D4_n_i', 'v_D6_a_r', 'v_D6_a_i', 'v_D6_b_r', 'v_D6_b_i', 'v_D6_c_r', 'v_D6_c_i', 'v_D6_n_r', 'v_D6_n_i', 'v_D9_a_r', 'v_D9_a_i', 'v_D9_b_r', 'v_D9_b_i', 'v_D9_c_r', 'v_D9_c_i', 'v_D9_n_r', 'v_D9_n_i', 'v_D10_a_r', 'v_D10_a_i', 'v_D10_b_r', 'v_D10_b_i', 'v_D10_c_r', 'v_D10_c_i', 'v_D10_n_r', 'v_D10_n_i', 'v_D11_b_r', 'v_D11_b_i', 'v_D11_c_r', 'v_D11_c_i', 'v_D16_b_r', 'v_D16_b_i', 'v_D16_c_r', 'v_D16_c_i', 'v_D17_b_r', 'v_D17_b_i', 'v_D17_c_r', 'v_D17_c_i', 'v_D18_b_r', 'v_D18_b_i', 'v_D18_c_r', 'v_D18_c_i', 'v_D14_a_r', 'v_D14_a_i', 'v_D14_b_r', 'v_D14_b_i', 'v_D14_c_r', 'v_D14_c_i', 'v_D14_n_r', 'v_D14_n_i', 'v_D15_b_r', 'v_D15_b_i', 'v_D15_c_r', 'v_D15_c_i', 'i_t_R0_R1_a_r', 'i_t_R0_R1_a_i', 'i_t_R0_R1_b_r', 'i_t_R0_R1_b_i', 'i_t_R0_R1_c_r', 'i_t_R0_R1_c_i', 'i_l_R1_R2_a_r', 'i_l_R1_R2_a_i', 'i_l_R1_R2_b_r', 'i_l_R1_R2_b_i', 'i_l_R1_R2_c_r', 'i_l_R1_R2_c_i', 'i_l_R1_R2_n_r', 'i_l_R1_R2_n_i', 'i_l_D1_D3_a_r', 'i_l_D1_D3_a_i', 'i_l_D1_D3_b_r', 'i_l_D1_D3_b_i', 'i_l_D1_D3_c_r', 'i_l_D1_D3_c_i', 'i_l_D1_D3_n_r', 'i_l_D1_D3_n_i', 'i_l_D3_D4_a_r', 'i_l_D3_D4_a_i', 'i_l_D3_D4_b_r', 'i_l_D3_D4_b_i', 'i_l_D3_D4_c_r', 'i_l_D3_D4_c_i', 'i_l_D3_D4_n_r', 'i_l_D3_D4_n_i', 'i_l_D4_D6_a_r', 'i_l_D4_D6_a_i', 'i_l_D4_D6_b_r', 'i_l_D4_D6_b_i', 'i_l_D4_D6_c_r', 'i_l_D4_D6_c_i', 'i_l_D4_D6_n_r', 'i_l_D4_D6_n_i', 'i_l_D6_D9_a_r', 'i_l_D6_D9_a_i', 'i_l_D6_D9_b_r', 'i_l_D6_D9_b_i', 'i_l_D6_D9_c_r', 'i_l_D6_D9_c_i', 'i_l_D6_D9_n_r', 'i_l_D6_D9_n_i', 'i_l_D9_D10_a_r', 'i_l_D9_D10_a_i', 'i_l_D9_D10_b_r', 'i_l_D9_D10_b_i', 'i_l_D9_D10_c_r', 'i_l_D9_D10_c_i', 'i_l_D9_D10_n_r', 'i_l_D9_D10_n_i', 'i_l_D3_D11_a_r', 'i_l_D3_D11_a_i', 'i_l_D3_D11_b_r', 'i_l_D3_D11_b_i', 'i_l_D3_D11_c_r', 'i_l_D3_D11_c_i', 'i_l_D3_D11_n_r', 'i_l_D3_D11_n_i', 'i_l_D6_D16_a_r', 'i_l_D6_D16_a_i', 'i_l_D6_D16_b_r', 'i_l_D6_D16_b_i', 'i_l_D6_D16_c_r', 'i_l_D6_D16_c_i', 'i_l_D6_D16_n_r', 'i_l_D6_D16_n_i', 'i_l_D9_D17_a_r', 'i_l_D9_D17_a_i', 'i_l_D9_D17_b_r', 'i_l_D9_D17_b_i', 'i_l_D9_D17_c_r', 'i_l_D9_D17_c_i', 'i_l_D9_D17_n_r', 'i_l_D9_D17_n_i', 'i_l_D10_D18_a_r', 'i_l_D10_D18_a_i', 'i_l_D10_D18_b_r', 'i_l_D10_D18_b_i', 'i_l_D10_D18_c_r', 'i_l_D10_D18_c_i', 'i_l_D10_D18_n_r', 'i_l_D10_D18_n_i', 'i_l_D4_D14_a_r', 'i_l_D4_D14_a_i', 'i_l_D4_D14_b_r', 'i_l_D4_D14_b_i', 'i_l_D4_D14_c_r', 'i_l_D4_D14_c_i', 'i_l_D4_D14_n_r', 'i_l_D4_D14_n_i', 'i_l_D14_D15_a_r', 'i_l_D14_D15_a_i', 'i_l_D14_D15_b_r', 'i_l_D14_D15_b_i', 'i_l_D14_D15_c_r', 'i_l_D14_D15_c_i', 'i_l_D14_D15_n_r', 'i_l_D14_D15_n_i', 'i_load_R1_a_r', 'i_load_R1_a_i', 'i_load_R1_b_r', 'i_load_R1_b_i', 'i_load_R1_c_r', 'i_load_R1_c_i', 'i_load_R1_n_r', 'i_load_R1_n_i', 'i_load_R11_a_r', 'i_load_R11_a_i', 'i_load_R11_n_r', 'i_load_R11_n_i', 'i_load_R15_a_r', 'i_load_R15_a_i', 'i_load_R15_n_r', 'i_load_R15_n_i', 'i_load_R16_a_r', 'i_load_R16_a_i', 'i_load_R16_n_r', 'i_load_R16_n_i', 'i_load_R17_a_r', 'i_load_R17_a_i', 'i_load_R17_n_r', 'i_load_R17_n_i', 'i_load_R18_a_r', 'i_load_R18_a_i', 'i_load_R18_n_r', 'i_load_R18_n_i', 'i_load_D15_a_r', 'i_load_D15_a_i', 'i_load_D15_n_r', 'i_load_D15_n_i', 'i_load_D11_a_r', 'i_load_D11_a_i', 'i_load_D11_n_r', 'i_load_D11_n_i', 'i_load_D16_a_r', 'i_load_D16_a_i', 'i_load_D16_n_r', 'i_load_D16_n_i', 'i_load_D17_a_r', 'i_load_D17_a_i', 'i_load_D17_n_r', 'i_load_D17_n_i', 'i_load_D18_a_r', 'i_load_D18_a_i', 'i_load_D18_n_r', 'i_load_D18_n_i', 'i_vsc_R1_a_r', 'i_vsc_R1_a_i', 'i_vsc_R1_b_r', 'i_vsc_R1_b_i', 'i_vsc_R1_c_r', 'i_vsc_R1_c_i', 'p_R1', 'p_D1', 'p_loss_R1', 'i_vsc_R10_a_r', 'i_vsc_R10_a_i', 'i_vsc_R10_b_r', 'i_vsc_R10_b_i', 'i_vsc_R10_c_r', 'i_vsc_R10_c_i', 'i_vsc_R10_n_r', 'i_vsc_R10_n_i', 'i_vsc_D10_a_r', 'i_vsc_D10_n_r', 'p_D10', 'i_vsc_R14_a_r', 'i_vsc_R14_a_i', 'i_vsc_R14_b_r', 'i_vsc_R14_b_i', 'i_vsc_R14_c_r', 'i_vsc_R14_c_i', 'i_vsc_R14_n_r', 'i_vsc_R14_n_i', 'i_vsc_D14_a_r', 'i_vsc_D14_n_r', 'p_D14'] 
        self.xy_list = self.x_list + self.y_run_list 
        self.y_ini_list = ['v_R1_a_r', 'v_R1_a_i', 'v_R1_b_r', 'v_R1_b_i', 'v_R1_c_r', 'v_R1_c_i', 'v_R1_n_r', 'v_R1_n_i', 'v_R11_a_r', 'v_R11_a_i', 'v_R11_n_r', 'v_R11_n_i', 'v_R15_a_r', 'v_R15_a_i', 'v_R15_n_r', 'v_R15_n_i', 'v_R16_a_r', 'v_R16_a_i', 'v_R16_n_r', 'v_R16_n_i', 'v_R17_a_r', 'v_R17_a_i', 'v_R17_n_r', 'v_R17_n_i', 'v_R18_a_r', 'v_R18_a_i', 'v_R18_n_r', 'v_R18_n_i', 'v_D15_a_r', 'v_D15_a_i', 'v_D15_n_r', 'v_D15_n_i', 'v_D11_a_r', 'v_D11_a_i', 'v_D11_n_r', 'v_D11_n_i', 'v_D16_a_r', 'v_D16_a_i', 'v_D16_n_r', 'v_D16_n_i', 'v_D17_a_r', 'v_D17_a_i', 'v_D17_n_r', 'v_D17_n_i', 'v_D18_a_r', 'v_D18_a_i', 'v_D18_n_r', 'v_D18_n_i', 'v_R2_a_r', 'v_R2_a_i', 'v_R2_b_r', 'v_R2_b_i', 'v_R2_c_r', 'v_R2_c_i', 'v_R2_n_r', 'v_R2_n_i', 'v_R3_a_r', 'v_R3_a_i', 'v_R3_b_r', 'v_R3_b_i', 'v_R3_c_r', 'v_R3_c_i', 'v_R3_n_r', 'v_R3_n_i', 'v_R4_a_r', 'v_R4_a_i', 'v_R4_b_r', 'v_R4_b_i', 'v_R4_c_r', 'v_R4_c_i', 'v_R4_n_r', 'v_R4_n_i', 'v_R5_a_r', 'v_R5_a_i', 'v_R5_b_r', 'v_R5_b_i', 'v_R5_c_r', 'v_R5_c_i', 'v_R5_n_r', 'v_R5_n_i', 'v_R6_a_r', 'v_R6_a_i', 'v_R6_b_r', 'v_R6_b_i', 'v_R6_c_r', 'v_R6_c_i', 'v_R6_n_r', 'v_R6_n_i', 'v_R7_a_r', 'v_R7_a_i', 'v_R7_b_r', 'v_R7_b_i', 'v_R7_c_r', 'v_R7_c_i', 'v_R7_n_r', 'v_R7_n_i', 'v_R8_a_r', 'v_R8_a_i', 'v_R8_b_r', 'v_R8_b_i', 'v_R8_c_r', 'v_R8_c_i', 'v_R8_n_r', 'v_R8_n_i', 'v_R9_a_r', 'v_R9_a_i', 'v_R9_b_r', 'v_R9_b_i', 'v_R9_c_r', 'v_R9_c_i', 'v_R9_n_r', 'v_R9_n_i', 'v_R10_a_r', 'v_R10_a_i', 'v_R10_b_r', 'v_R10_b_i', 'v_R10_c_r', 'v_R10_c_i', 'v_R10_n_r', 'v_R10_n_i', 'v_R11_b_r', 'v_R11_b_i', 'v_R11_c_r', 'v_R11_c_i', 'v_R12_a_r', 'v_R12_a_i', 'v_R12_b_r', 'v_R12_b_i', 'v_R12_c_r', 'v_R12_c_i', 'v_R12_n_r', 'v_R12_n_i', 'v_R13_a_r', 'v_R13_a_i', 'v_R13_b_r', 'v_R13_b_i', 'v_R13_c_r', 'v_R13_c_i', 'v_R13_n_r', 'v_R13_n_i', 'v_R14_a_r', 'v_R14_a_i', 'v_R14_b_r', 'v_R14_b_i', 'v_R14_c_r', 'v_R14_c_i', 'v_R14_n_r', 'v_R14_n_i', 'v_R15_b_r', 'v_R15_b_i', 'v_R15_c_r', 'v_R15_c_i', 'v_R16_b_r', 'v_R16_b_i', 'v_R16_c_r', 'v_R16_c_i', 'v_R17_b_r', 'v_R17_b_i', 'v_R17_c_r', 'v_R17_c_i', 'v_R18_b_r', 'v_R18_b_i', 'v_R18_c_r', 'v_R18_c_i', 'v_D1_n_r', 'v_D1_n_i', 'v_D3_a_r', 'v_D3_a_i', 'v_D3_b_r', 'v_D3_b_i', 'v_D3_c_r', 'v_D3_c_i', 'v_D3_n_r', 'v_D3_n_i', 'v_D4_a_r', 'v_D4_a_i', 'v_D4_b_r', 'v_D4_b_i', 'v_D4_c_r', 'v_D4_c_i', 'v_D4_n_r', 'v_D4_n_i', 'v_D6_a_r', 'v_D6_a_i', 'v_D6_b_r', 'v_D6_b_i', 'v_D6_c_r', 'v_D6_c_i', 'v_D6_n_r', 'v_D6_n_i', 'v_D9_a_r', 'v_D9_a_i', 'v_D9_b_r', 'v_D9_b_i', 'v_D9_c_r', 'v_D9_c_i', 'v_D9_n_r', 'v_D9_n_i', 'v_D10_a_r', 'v_D10_a_i', 'v_D10_b_r', 'v_D10_b_i', 'v_D10_c_r', 'v_D10_c_i', 'v_D10_n_r', 'v_D10_n_i', 'v_D11_b_r', 'v_D11_b_i', 'v_D11_c_r', 'v_D11_c_i', 'v_D16_b_r', 'v_D16_b_i', 'v_D16_c_r', 'v_D16_c_i', 'v_D17_b_r', 'v_D17_b_i', 'v_D17_c_r', 'v_D17_c_i', 'v_D18_b_r', 'v_D18_b_i', 'v_D18_c_r', 'v_D18_c_i', 'v_D14_a_r', 'v_D14_a_i', 'v_D14_b_r', 'v_D14_b_i', 'v_D14_c_r', 'v_D14_c_i', 'v_D14_n_r', 'v_D14_n_i', 'v_D15_b_r', 'v_D15_b_i', 'v_D15_c_r', 'v_D15_c_i', 'i_t_R0_R1_a_r', 'i_t_R0_R1_a_i', 'i_t_R0_R1_b_r', 'i_t_R0_R1_b_i', 'i_t_R0_R1_c_r', 'i_t_R0_R1_c_i', 'i_l_R1_R2_a_r', 'i_l_R1_R2_a_i', 'i_l_R1_R2_b_r', 'i_l_R1_R2_b_i', 'i_l_R1_R2_c_r', 'i_l_R1_R2_c_i', 'i_l_R1_R2_n_r', 'i_l_R1_R2_n_i', 'i_l_D1_D3_a_r', 'i_l_D1_D3_a_i', 'i_l_D1_D3_b_r', 'i_l_D1_D3_b_i', 'i_l_D1_D3_c_r', 'i_l_D1_D3_c_i', 'i_l_D1_D3_n_r', 'i_l_D1_D3_n_i', 'i_l_D3_D4_a_r', 'i_l_D3_D4_a_i', 'i_l_D3_D4_b_r', 'i_l_D3_D4_b_i', 'i_l_D3_D4_c_r', 'i_l_D3_D4_c_i', 'i_l_D3_D4_n_r', 'i_l_D3_D4_n_i', 'i_l_D4_D6_a_r', 'i_l_D4_D6_a_i', 'i_l_D4_D6_b_r', 'i_l_D4_D6_b_i', 'i_l_D4_D6_c_r', 'i_l_D4_D6_c_i', 'i_l_D4_D6_n_r', 'i_l_D4_D6_n_i', 'i_l_D6_D9_a_r', 'i_l_D6_D9_a_i', 'i_l_D6_D9_b_r', 'i_l_D6_D9_b_i', 'i_l_D6_D9_c_r', 'i_l_D6_D9_c_i', 'i_l_D6_D9_n_r', 'i_l_D6_D9_n_i', 'i_l_D9_D10_a_r', 'i_l_D9_D10_a_i', 'i_l_D9_D10_b_r', 'i_l_D9_D10_b_i', 'i_l_D9_D10_c_r', 'i_l_D9_D10_c_i', 'i_l_D9_D10_n_r', 'i_l_D9_D10_n_i', 'i_l_D3_D11_a_r', 'i_l_D3_D11_a_i', 'i_l_D3_D11_b_r', 'i_l_D3_D11_b_i', 'i_l_D3_D11_c_r', 'i_l_D3_D11_c_i', 'i_l_D3_D11_n_r', 'i_l_D3_D11_n_i', 'i_l_D6_D16_a_r', 'i_l_D6_D16_a_i', 'i_l_D6_D16_b_r', 'i_l_D6_D16_b_i', 'i_l_D6_D16_c_r', 'i_l_D6_D16_c_i', 'i_l_D6_D16_n_r', 'i_l_D6_D16_n_i', 'i_l_D9_D17_a_r', 'i_l_D9_D17_a_i', 'i_l_D9_D17_b_r', 'i_l_D9_D17_b_i', 'i_l_D9_D17_c_r', 'i_l_D9_D17_c_i', 'i_l_D9_D17_n_r', 'i_l_D9_D17_n_i', 'i_l_D10_D18_a_r', 'i_l_D10_D18_a_i', 'i_l_D10_D18_b_r', 'i_l_D10_D18_b_i', 'i_l_D10_D18_c_r', 'i_l_D10_D18_c_i', 'i_l_D10_D18_n_r', 'i_l_D10_D18_n_i', 'i_l_D4_D14_a_r', 'i_l_D4_D14_a_i', 'i_l_D4_D14_b_r', 'i_l_D4_D14_b_i', 'i_l_D4_D14_c_r', 'i_l_D4_D14_c_i', 'i_l_D4_D14_n_r', 'i_l_D4_D14_n_i', 'i_l_D14_D15_a_r', 'i_l_D14_D15_a_i', 'i_l_D14_D15_b_r', 'i_l_D14_D15_b_i', 'i_l_D14_D15_c_r', 'i_l_D14_D15_c_i', 'i_l_D14_D15_n_r', 'i_l_D14_D15_n_i', 'i_load_R1_a_r', 'i_load_R1_a_i', 'i_load_R1_b_r', 'i_load_R1_b_i', 'i_load_R1_c_r', 'i_load_R1_c_i', 'i_load_R1_n_r', 'i_load_R1_n_i', 'i_load_R11_a_r', 'i_load_R11_a_i', 'i_load_R11_n_r', 'i_load_R11_n_i', 'i_load_R15_a_r', 'i_load_R15_a_i', 'i_load_R15_n_r', 'i_load_R15_n_i', 'i_load_R16_a_r', 'i_load_R16_a_i', 'i_load_R16_n_r', 'i_load_R16_n_i', 'i_load_R17_a_r', 'i_load_R17_a_i', 'i_load_R17_n_r', 'i_load_R17_n_i', 'i_load_R18_a_r', 'i_load_R18_a_i', 'i_load_R18_n_r', 'i_load_R18_n_i', 'i_load_D15_a_r', 'i_load_D15_a_i', 'i_load_D15_n_r', 'i_load_D15_n_i', 'i_load_D11_a_r', 'i_load_D11_a_i', 'i_load_D11_n_r', 'i_load_D11_n_i', 'i_load_D16_a_r', 'i_load_D16_a_i', 'i_load_D16_n_r', 'i_load_D16_n_i', 'i_load_D17_a_r', 'i_load_D17_a_i', 'i_load_D17_n_r', 'i_load_D17_n_i', 'i_load_D18_a_r', 'i_load_D18_a_i', 'i_load_D18_n_r', 'i_load_D18_n_i', 'i_vsc_R1_a_r', 'i_vsc_R1_a_i', 'i_vsc_R1_b_r', 'i_vsc_R1_b_i', 'i_vsc_R1_c_r', 'i_vsc_R1_c_i', 'p_R1', 'p_D1', 'p_loss_R1', 'i_vsc_R10_a_r', 'i_vsc_R10_a_i', 'i_vsc_R10_b_r', 'i_vsc_R10_b_i', 'i_vsc_R10_c_r', 'i_vsc_R10_c_i', 'i_vsc_R10_n_r', 'i_vsc_R10_n_i', 'i_vsc_D10_a_r', 'i_vsc_D10_n_r', 'p_D10', 'i_vsc_R14_a_r', 'i_vsc_R14_a_i', 'i_vsc_R14_b_r', 'i_vsc_R14_b_i', 'i_vsc_R14_c_r', 'i_vsc_R14_c_i', 'i_vsc_R14_n_r', 'i_vsc_R14_n_i', 'i_vsc_D14_a_r', 'i_vsc_D14_n_r', 'p_D14'] 
        self.xy_ini_list = self.x_list + self.y_ini_list 
        self.t = 0.0
        self.it = 0
        self.it_store = 0
        self.xy_prev = np.zeros((self.N_x+self.N_y,1))
        self.initialization_tol = 1e-6
        self.N_u = len(self.inputs_run_list) 
        self.sopt_root_method='hybr'
        self.sopt_root_jac=True
        self.u_ini_list = self.inputs_ini_list
        self.u_ini_values_list = self.inputs_ini_values_list
        self.u_run_list = self.inputs_run_list
        self.u_run_values_list = self.inputs_run_values_list
        self.N_u = len(self.u_run_list)
        Fx_ini_rows,Fx_ini_cols,Fy_ini_rows,Fy_ini_cols,Gx_ini_rows,Gx_ini_cols,Gy_ini_rows,Gy_ini_cols = nonzeros()

        self.Fx_ini_rows = np.array(Fx_ini_rows) 
        if len(Fx_ini_rows) == 1: 
            self.Fx_ini_rows = np.array([[Fx_ini_rows]]).reshape(1,) 
            self.Fx_ini_cols = np.array([[Fx_ini_cols]]).reshape(1,)  
            
        self.Fx_ini_cols = np.array(Fx_ini_cols)
        self.Fy_ini_rows = np.array(Fy_ini_rows)        
        self.Fy_ini_cols = np.array(Fy_ini_cols)
        self.Gx_ini_rows = np.array(Gx_ini_rows)        
        self.Gx_ini_cols = np.array(Gx_ini_cols)
        self.Gy_ini_rows = np.array(Gy_ini_rows)        
        self.Gy_ini_cols = np.array(Gy_ini_cols)
        
        
        self.yini2urun = list(set(self.inputs_run_list).intersection(set(self.y_ini_list)))
        self.uini2yrun = list(set(self.y_run_list).intersection(set(self.inputs_ini_list)))

        self.update() 
                
    def update(self): 

        self.N_steps = int(np.ceil(self.t_end/self.Dt)) 
        dt = [  
              ('t_end', np.float64),
              ('Dt', np.float64),
              ('decimation', np.float64),
              ('itol', np.float64),
              ('Dt_max', np.float64),
              ('Dt_min', np.float64),
              ('solvern', np.int64),
              ('imax', np.int64),
              ('N_steps', np.int64),
              ('N_store', np.int64),
              ('N_x', np.int64),
              ('N_y', np.int64),
              ('N_z', np.int64),
              ('t', np.float64),
              ('it', np.int64),
              ('it_store', np.int64),
              ('idx', np.int64),
              ('idy', np.int64),
              ('f', np.float64, (self.N_x,1)),
              ('x', np.float64, (self.N_x,1)),
              ('x_0', np.float64, (self.N_x,1)),
              ('g', np.float64, (self.N_y,1)),
              ('y_run', np.float64, (self.N_y,1)),
              ('y_ini', np.float64, (self.N_y,1)),
              ('u_run', np.float64, (self.N_u,1)),
              ('y_0', np.float64, (self.N_y,1)),
              ('h', np.float64, (self.N_z,1)),
              ('Fx', np.float64, (self.N_x,self.N_x)),
              ('Fy', np.float64, (self.N_x,self.N_y)),
              ('Gx', np.float64, (self.N_y,self.N_x)),
              ('Gy', np.float64, (self.N_y,self.N_y)),
              ('Fu', np.float64, (self.N_x,self.N_u)),
              ('Gu', np.float64, (self.N_y,self.N_u)),
              ('Hx', np.float64, (self.N_z,self.N_x)),
              ('Hy', np.float64, (self.N_z,self.N_y)),
              ('Hu', np.float64, (self.N_z,self.N_u)),
              ('Fx_ini', np.float64, (self.N_x,self.N_x)),
              ('Fy_ini', np.float64, (self.N_x,self.N_y)),
              ('Gx_ini', np.float64, (self.N_y,self.N_x)),
              ('Gy_ini', np.float64, (self.N_y,self.N_y)),
              ('T', np.float64, (self.N_store+1,1)),
              ('X', np.float64, (self.N_store+1,self.N_x)),
              ('Y', np.float64, (self.N_store+1,self.N_y)),
              ('Z', np.float64, (self.N_store+1,self.N_z)),
              ('iters', np.float64, (self.N_store+1,1)),
              ('store', np.int64),
              ('Fx_ini_rows', np.int64, self.Fx_ini_rows.shape),
              ('Fx_ini_cols', np.int64, self.Fx_ini_cols.shape),
              ('Fy_ini_rows', np.int64, self.Fy_ini_rows.shape),
              ('Fy_ini_cols', np.int64, self.Fy_ini_cols.shape),
              ('Gx_ini_rows', np.int64, self.Gx_ini_rows.shape),
              ('Gx_ini_cols', np.int64, self.Gx_ini_cols.shape),
              ('Gy_ini_rows', np.int64, self.Gy_ini_rows.shape),
              ('Gy_ini_cols', np.int64, self.Gy_ini_cols.shape),
              ('Ac_ini', np.float64, ((self.N_x+self.N_y,self.N_x+self.N_y))),   
              ('fg', np.float64, ((self.N_x+self.N_y,1))),  
             ]



        
        
        values = [
                self.t_end,                          
                self.Dt,
                self.decimation,
                self.itol,
                self.Dt_max,
                self.Dt_min,
                self.solvern,
                self.imax,
                self.N_steps,
                self.N_store,
                self.N_x,
                self.N_y,
                self.N_z,
                self.t,
                self.it,
                self.it_store,
                0,                                     # idx
                0,                                     # idy
                np.zeros((self.N_x,1)),                # f
                np.zeros((self.N_x,1)),                # x
                np.zeros((self.N_x,1)),                # x_0
                np.zeros((self.N_y,1)),                # g
                np.zeros((self.N_y,1)),                # y_run
                np.zeros((self.N_y,1)),                # y_ini
                np.zeros((self.N_u,1)),                # u_run
                np.zeros((self.N_y,1)),                # y_0
                np.zeros((self.N_z,1)),                # h
                np.zeros((self.N_x,self.N_x)),         # Fx   
                np.zeros((self.N_x,self.N_y)),         # Fy 
                np.zeros((self.N_y,self.N_x)),         # Gx 
                np.zeros((self.N_y,self.N_y)),         # Fy
                np.zeros((self.N_x,self.N_u)),         # Fu 
                np.zeros((self.N_y,self.N_u)),         # Gu 
                np.zeros((self.N_z,self.N_x)),         # Hx 
                np.zeros((self.N_z,self.N_y)),         # Hy 
                np.zeros((self.N_z,self.N_u)),         # Hu 
                np.zeros((self.N_x,self.N_x)),         # Fx_ini  
                np.zeros((self.N_x,self.N_y)),         # Fy_ini 
                np.zeros((self.N_y,self.N_x)),         # Gx_ini 
                np.zeros((self.N_y,self.N_y)),         # Fy_ini 
                np.zeros((self.N_store+1,1)),          # T
                np.zeros((self.N_store+1,self.N_x)),   # X
                np.zeros((self.N_store+1,self.N_y)),   # Y
                np.zeros((self.N_store+1,self.N_z)),   # Z
                np.zeros((self.N_store+1,1)),          # iters
                1,
                self.Fx_ini_rows,       
                self.Fx_ini_cols,
                self.Fy_ini_rows,       
                self.Fy_ini_cols,
                self.Gx_ini_rows,        
                self.Gx_ini_cols,
                self.Gy_ini_rows,       
                self.Gy_ini_cols,
                np.zeros((self.N_x+self.N_y,self.N_x+self.N_y)),  
                np.zeros((self.N_x+self.N_y,1)),
                ]  

        dt += [(item,np.float64) for item in self.params_list]
        values += [item for item in self.params_values_list]

        for item_id,item_val in zip(self.inputs_ini_list,self.inputs_ini_values_list):
            if item_id in self.inputs_run_list: continue
            dt += [(item_id,np.float64)]
            values += [item_val]

        dt += [(item,np.float64) for item in self.inputs_run_list]
        values += [item for item in self.inputs_run_values_list]

        self.struct = np.rec.array([tuple(values)], dtype=np.dtype(dt))
        
        xy0 = np.zeros((self.N_x+self.N_y,))
        self.ini_dae_jacobian_nn(xy0)
        self.run_dae_jacobian_nn(xy0)
        


    def load_params(self,data_input):

        if type(data_input) == str:
            json_file = data_input
            self.json_file = json_file
            self.json_data = open(json_file).read().replace("'",'"')
            data = json.loads(self.json_data)
        elif type(data_input) == dict:
            data = data_input

        self.data = data
        for item in self.data:
            self.struct[0][item] = self.data[item]
            self.params_values_list[self.params_list.index(item)] = self.data[item]



    def ini_problem(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_ini[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        if self.compile:
            ini(self.struct,2)
            ini(self.struct,3)       
        else:
            ini.py_func(self.struct,2)
            ini.py_func(self.struct,3)                   
        fg = np.vstack((self.struct[0].f,self.struct[0].g))[:,0]
        return fg

    def run_problem(self,x):
        t = self.struct[0].t
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_run[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        
        if self.compile:
            run(t,self.struct,2)
            run(t,self.struct,3)
            run(t,self.struct,10)
            run(t,self.struct,11)
            run(t,self.struct,12)
            run(t,self.struct,13)
        else:
            run.py_func(t,self.struct,2)
            run.py_func(t,self.struct,3)
            run.py_func(t,self.struct,10)
            run.py_func(t,self.struct,11)
            run.py_func(t,self.struct,12)
            run.py_func(t,self.struct,13)            
        
        fg = np.vstack((self.struct[0].f,self.struct[0].g))[:,0]
        return fg
    

    def run_dae_jacobian(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_run[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        run(0.0,self.struct,10)
        run(0.0,self.struct,11)     
        run(0.0,self.struct,12)
        run(0.0,self.struct,13)
        A_c = np.block([[self.struct[0].Fx,self.struct[0].Fy],
                        [self.struct[0].Gx,self.struct[0].Gy]])
        return A_c

    def run_dae_jacobian_nn(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_run[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        run_nn(0.0,self.struct,10)
        run_nn(0.0,self.struct,11)     
        run_nn(0.0,self.struct,12)
        run_nn(0.0,self.struct,13)
 

    
    def eval_jacobians(self):

        run(0.0,self.struct,10)
        run(0.0,self.struct,11)  
        run(0.0,self.struct,12) 

        return 1


    def ini_dae_jacobian(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_ini[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        if self.compile:
            ini(self.struct,10)
            ini(self.struct,11) 
        else:
            ini.py_func(self.struct,10)
            ini.py_func(self.struct,11)             
        A_c = np.block([[self.struct[0].Fx_ini,self.struct[0].Fy_ini],
                        [self.struct[0].Gx_ini,self.struct[0].Gy_ini]])
        return A_c

    def ini_dae_jacobian_nn(self,x):
        self.struct[0].x[:,0] = x[0:self.N_x]
        self.struct[0].y_ini[:,0] = x[self.N_x:(self.N_x+self.N_y)]
        ini_nn(self.struct,10)
        ini_nn(self.struct,11)       
 

    def f_ode(self,x):
        self.struct[0].x[:,0] = x
        run(self.struct,1)
        return self.struct[0].f[:,0]

    def f_odeint(self,x,t):
        self.struct[0].x[:,0] = x
        run(self.struct,1)
        return self.struct[0].f[:,0]

    def f_ivp(self,t,x):
        self.struct[0].x[:,0] = x
        run(self.struct,1)
        return self.struct[0].f[:,0]

    def Fx_ode(self,x):
        self.struct[0].x[:,0] = x
        run(self.struct,10)
        return self.struct[0].Fx

    def eval_A(self):
        
        Fx = self.struct[0].Fx
        Fy = self.struct[0].Fy
        Gx = self.struct[0].Gx
        Gy = self.struct[0].Gy
        
        A = Fx - Fy @ np.linalg.solve(Gy,Gx)
        
        self.A = A
        
        return A

    def eval_A_ini(self):
        
        Fx = self.struct[0].Fx_ini
        Fy = self.struct[0].Fy_ini
        Gx = self.struct[0].Gx_ini
        Gy = self.struct[0].Gy_ini
        
        A = Fx - Fy @ np.linalg.solve(Gy,Gx)
        
        
        return A
    
    def reset(self):
        for param,param_value in zip(self.params_list,self.params_values_list):
            self.struct[0][param] = param_value
        for input_name,input_value in zip(self.inputs_ini_list,self.inputs_ini_values_list):
            self.struct[0][input_name] = input_value   
        for input_name,input_value in zip(self.inputs_run_list,self.inputs_run_values_list):
            self.struct[0][input_name] = input_value  

    def simulate(self,events,xy0=0):
        
        # initialize both the ini and the run system
        self.initialize(events,xy0=xy0)
        
        # simulation run
        for event in events:  
            # make all the desired changes
            self.run([event]) 
            
        # post process
        T,X,Y,Z = self.post()
        
        return T,X,Y,Z
    

    
    def run(self,events):
        

        # simulation run
        for event in events:  
            # make all the desired changes
            for item in event:
                self.struct[0][item] = event[item]
            daesolver(self.struct)    # run until next event
            
        return 1
 
    def rtrun(self,events):
        

        # simulation run
        for event in events:  
            # make all the desired changes
            for item in event:
                self.struct[0][item] = event[item]
            self.struct[0].it_store = self.struct[0].N_store-1
            daesolver(self.struct)    # run until next event
            
            
        return 1
    
    def post(self):
        
        # post process result    
        T = self.struct[0]['T'][:self.struct[0].it_store]
        X = self.struct[0]['X'][:self.struct[0].it_store,:]
        Y = self.struct[0]['Y'][:self.struct[0].it_store,:]
        Z = self.struct[0]['Z'][:self.struct[0].it_store,:]
        iters = self.struct[0]['iters'][:self.struct[0].it_store,:]
    
        self.T = T
        self.X = X
        self.Y = Y
        self.Z = Z
        self.iters = iters
        
        return T,X,Y,Z
        
    def save_0(self,file_name = 'xy_0.json'):
        xy_0_dict = {}
        for item in self.x_list:
            xy_0_dict.update({item:self.get_value(item)})
        for item in self.y_ini_list:
            xy_0_dict.update({item:self.get_value(item)})
    
        xy_0_str = json.dumps(xy_0_dict, indent=4)
        with open(file_name,'w') as fobj:
            fobj.write(xy_0_str)

    def load_0(self,file_name = 'xy_0.json'):
        with open(file_name) as fobj:
            xy_0_str = fobj.read()
        xy_0_dict = json.loads(xy_0_str)
    
        for item in xy_0_dict:
            if item in self.x_list:
                self.xy_prev[self.x_list.index(item)] = xy_0_dict[item]
            if item in self.y_ini_list:
                self.xy_prev[self.y_ini_list.index(item)+self.N_x] = xy_0_dict[item]
                
            
    def initialize(self,events=[{}],xy0=0,compile=True):
        '''
        

        Parameters
        ----------
        events : dictionary 
            Dictionary with at least 't_end' and all inputs and parameters 
            that need to be changed.
        xy0 : float or string, optional
            0 means all states should be zero as initial guess. 
            If not zero all the states initial guess are the given input.
            If 'prev' it uses the last known initialization result as initial guess.

        Returns
        -------
        T : TYPE
            DESCRIPTION.
        X : TYPE
            DESCRIPTION.
        Y : TYPE
            DESCRIPTION.
        Z : TYPE
            DESCRIPTION.

        '''
        
        self.compile = compile
        
        # simulation parameters
        self.struct[0].it = 0       # set time step to zero
        self.struct[0].it_store = 0 # set storage to zero
        self.struct[0].t = 0.0      # set time to zero
                    
        # initialization
        it_event = 0
        event = events[it_event]
        for item in event:
            self.struct[0][item] = event[item]
            
        
        ## compute initial conditions using x and y_ini 
        if type(xy0) == str:
            if xy0 == 'prev':
                xy0 = self.xy_prev
            else:
                self.load_0(xy0)
                xy0 = self.xy_prev
        elif type(xy0) == dict:
            with open('xy_0.json','w') as fobj:
                fobj.write(json.dumps(xy0))
            self.load_0('xy_0.json')
            xy0 = self.xy_prev            
        else:
            if xy0 == 0:
                xy0 = np.zeros(self.N_x+self.N_y)
            elif xy0 == 1:
                xy0 = np.ones(self.N_x+self.N_y)
            else:
                xy0 = xy0*np.ones(self.N_x+self.N_y)

        #xy = sopt.fsolve(self.ini_problem,xy0, jac=self.ini_dae_jacobian )

        
        if self.sopt_root_jac:
            sol = sopt.root(self.ini_problem, xy0, 
                            jac=self.ini_dae_jacobian, 
                            method=self.sopt_root_method, tol=self.initialization_tol)
        else:
            sol = sopt.root(self.ini_problem, xy0, method=self.sopt_root_method)

        self.initialization_ok = True
        if sol.success == False:
            print('initialization not found!')
            self.initialization_ok = False

            T = self.struct[0]['T'][:self.struct[0].it_store]
            X = self.struct[0]['X'][:self.struct[0].it_store,:]
            Y = self.struct[0]['Y'][:self.struct[0].it_store,:]
            Z = self.struct[0]['Z'][:self.struct[0].it_store,:]
            iters = self.struct[0]['iters'][:self.struct[0].it_store,:]

        if self.initialization_ok:
            xy = sol.x
            self.xy_prev = xy
            self.struct[0].x[:,0] = xy[0:self.N_x]
            self.struct[0].y_run[:,0] = xy[self.N_x:]

            ## y_ini to u_run
            for item in self.inputs_run_list:
                if item in self.y_ini_list:
                    self.struct[0][item] = self.struct[0].y_ini[self.y_ini_list.index(item)]

            ## u_ini to y_run
            for item in self.inputs_ini_list:
                if item in self.y_run_list:
                    self.struct[0].y_run[self.y_run_list.index(item)] = self.struct[0][item]


            #xy = sopt.fsolve(self.ini_problem,xy0, jac=self.ini_dae_jacobian )
            if self.sopt_root_jac:
                sol = sopt.root(self.run_problem, xy0, 
                                jac=self.run_dae_jacobian, 
                                method=self.sopt_root_method, tol=self.initialization_tol)
            else:
                sol = sopt.root(self.run_problem, xy0, method=self.sopt_root_method)

            if self.compile:
                # evaluate f and g
                run(0.0,self.struct,2)
                run(0.0,self.struct,3)                
    
                # evaluate run jacobians 
                run(0.0,self.struct,10)
                run(0.0,self.struct,11)                
                run(0.0,self.struct,12) 
                run(0.0,self.struct,14) 
                
            else:
                # evaluate f and g
                run.py_func(0.0,self.struct,2)
                run.py_func(0.0,self.struct,3)                
    
                # evaluate run jacobians 
                run.py_func(0.0,self.struct,10)
                run.py_func(0.0,self.struct,11)                
                run.py_func(0.0,self.struct,12) 
                run.py_func(0.0,self.struct,14)                 
                
             
            # post process result    
            T = self.struct[0]['T'][:self.struct[0].it_store]
            X = self.struct[0]['X'][:self.struct[0].it_store,:]
            Y = self.struct[0]['Y'][:self.struct[0].it_store,:]
            Z = self.struct[0]['Z'][:self.struct[0].it_store,:]
            iters = self.struct[0]['iters'][:self.struct[0].it_store,:]
        
            self.T = T
            self.X = X
            self.Y = Y
            self.Z = Z
            self.iters = iters
            
        return self.initialization_ok
    
    
    def get_value(self,name):
        if name in self.inputs_run_list:
            value = self.struct[0][name]
        if name in self.x_list:
            idx = self.x_list.index(name)
            value = self.struct[0].x[idx,0]
        if name in self.y_run_list:
            idy = self.y_run_list.index(name)
            value = self.struct[0].y_run[idy,0]
        if name in self.params_list:
            value = self.struct[0][name]
        if name in self.outputs_list:
            value = self.struct[0].h[self.outputs_list.index(name),0] 

        return value
    
    def get_values(self,name):
        if name in self.x_list:
            values = self.X[:,self.x_list.index(name)]
        if name in self.y_run_list:
            values = self.Y[:,self.y_run_list.index(name)]
        if name in self.outputs_list:
            values = self.Z[:,self.outputs_list.index(name)]
                        
        return values

    def get_mvalue(self,names):
        '''

        Parameters
        ----------
        names : list
            list of variables names to return each value.

        Returns
        -------
        mvalue : TYPE
            list of value of each variable.

        '''
        mvalue = []
        for name in names:
            mvalue += [self.get_value(name)]
                        
        return mvalue
    
    def set_value(self,name_,value):
        if name_ in self.inputs_run_list:
            self.struct[0][name_] = value
            return
        elif name_ in self.params_list:
            self.struct[0][name_] = value
            return
        elif name_ in self.inputs_ini_list:
            self.struct[0][name_] = value
            return 
        else:
            print(f'Input or parameter {name_} not found.')

    def set_values(self,dictionary):
        
        for item in dictionary:
            self.set_value(item,dictionary[item])
            
            
    def report_x(self,value_format='5.2f'):
        for item in self.x_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')

    def report_y(self,value_format='5.2f'):
        for item in self.y_run_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')
            
    def report_u(self,value_format='5.2f'):
        for item in self.inputs_run_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')

    def report_z(self,value_format='5.2f'):
        for item in self.outputs_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')

    def report_params(self,value_format='5.2f'):
        for item in self.params_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')
            
    def get_x(self):
        return self.struct[0].x
    
    def ss(self):
        
        ssate(self.struct,self.xy_prev.reshape(len(self.xy_prev),1))
        
        ## y_ini to y_run
        self.struct[0].y_run = self.struct[0].y_ini
        
        ## y_ini to u_run
        for item in self.yini2urun:
            self.struct[0][item] = self.struct[0].y_ini[self.y_ini_list.index(item)]
                
        ## u_ini to y_run
        for item in self.uini2yrun:
            self.struct[0].y_run[self.y_run_list.index(item)] = self.struct[0][item]






@numba.njit(cache=True)
def ini(struct,mode):

    # Parameters:
    a_R1 = struct[0].a_R1
    b_R1 = struct[0].b_R1
    c_R1 = struct[0].c_R1
    a_R10 = struct[0].a_R10
    b_R10 = struct[0].b_R10
    c_R10 = struct[0].c_R10
    coef_a_R10 = struct[0].coef_a_R10
    coef_b_R10 = struct[0].coef_b_R10
    coef_c_R10 = struct[0].coef_c_R10
    a_R14 = struct[0].a_R14
    b_R14 = struct[0].b_R14
    c_R14 = struct[0].c_R14
    coef_a_R14 = struct[0].coef_a_R14
    coef_b_R14 = struct[0].coef_b_R14
    coef_c_R14 = struct[0].coef_c_R14
    
    # Inputs:
    v_R0_a_r = struct[0].v_R0_a_r
    v_R0_a_i = struct[0].v_R0_a_i
    v_R0_b_r = struct[0].v_R0_b_r
    v_R0_b_i = struct[0].v_R0_b_i
    v_R0_c_r = struct[0].v_R0_c_r
    v_R0_c_i = struct[0].v_R0_c_i
    v_D1_a_r = struct[0].v_D1_a_r
    v_D1_a_i = struct[0].v_D1_a_i
    v_D1_b_r = struct[0].v_D1_b_r
    v_D1_b_i = struct[0].v_D1_b_i
    v_D1_c_r = struct[0].v_D1_c_r
    v_D1_c_i = struct[0].v_D1_c_i
    i_R1_n_r = struct[0].i_R1_n_r
    i_R1_n_i = struct[0].i_R1_n_i
    i_R2_a_r = struct[0].i_R2_a_r
    i_R2_a_i = struct[0].i_R2_a_i
    i_R2_b_r = struct[0].i_R2_b_r
    i_R2_b_i = struct[0].i_R2_b_i
    i_R2_c_r = struct[0].i_R2_c_r
    i_R2_c_i = struct[0].i_R2_c_i
    i_R2_n_r = struct[0].i_R2_n_r
    i_R2_n_i = struct[0].i_R2_n_i
    i_R3_a_r = struct[0].i_R3_a_r
    i_R3_a_i = struct[0].i_R3_a_i
    i_R3_b_r = struct[0].i_R3_b_r
    i_R3_b_i = struct[0].i_R3_b_i
    i_R3_c_r = struct[0].i_R3_c_r
    i_R3_c_i = struct[0].i_R3_c_i
    i_R3_n_r = struct[0].i_R3_n_r
    i_R3_n_i = struct[0].i_R3_n_i
    i_R4_a_r = struct[0].i_R4_a_r
    i_R4_a_i = struct[0].i_R4_a_i
    i_R4_b_r = struct[0].i_R4_b_r
    i_R4_b_i = struct[0].i_R4_b_i
    i_R4_c_r = struct[0].i_R4_c_r
    i_R4_c_i = struct[0].i_R4_c_i
    i_R4_n_r = struct[0].i_R4_n_r
    i_R4_n_i = struct[0].i_R4_n_i
    i_R5_a_r = struct[0].i_R5_a_r
    i_R5_a_i = struct[0].i_R5_a_i
    i_R5_b_r = struct[0].i_R5_b_r
    i_R5_b_i = struct[0].i_R5_b_i
    i_R5_c_r = struct[0].i_R5_c_r
    i_R5_c_i = struct[0].i_R5_c_i
    i_R5_n_r = struct[0].i_R5_n_r
    i_R5_n_i = struct[0].i_R5_n_i
    i_R6_a_r = struct[0].i_R6_a_r
    i_R6_a_i = struct[0].i_R6_a_i
    i_R6_b_r = struct[0].i_R6_b_r
    i_R6_b_i = struct[0].i_R6_b_i
    i_R6_c_r = struct[0].i_R6_c_r
    i_R6_c_i = struct[0].i_R6_c_i
    i_R6_n_r = struct[0].i_R6_n_r
    i_R6_n_i = struct[0].i_R6_n_i
    i_R7_a_r = struct[0].i_R7_a_r
    i_R7_a_i = struct[0].i_R7_a_i
    i_R7_b_r = struct[0].i_R7_b_r
    i_R7_b_i = struct[0].i_R7_b_i
    i_R7_c_r = struct[0].i_R7_c_r
    i_R7_c_i = struct[0].i_R7_c_i
    i_R7_n_r = struct[0].i_R7_n_r
    i_R7_n_i = struct[0].i_R7_n_i
    i_R8_a_r = struct[0].i_R8_a_r
    i_R8_a_i = struct[0].i_R8_a_i
    i_R8_b_r = struct[0].i_R8_b_r
    i_R8_b_i = struct[0].i_R8_b_i
    i_R8_c_r = struct[0].i_R8_c_r
    i_R8_c_i = struct[0].i_R8_c_i
    i_R8_n_r = struct[0].i_R8_n_r
    i_R8_n_i = struct[0].i_R8_n_i
    i_R9_a_r = struct[0].i_R9_a_r
    i_R9_a_i = struct[0].i_R9_a_i
    i_R9_b_r = struct[0].i_R9_b_r
    i_R9_b_i = struct[0].i_R9_b_i
    i_R9_c_r = struct[0].i_R9_c_r
    i_R9_c_i = struct[0].i_R9_c_i
    i_R9_n_r = struct[0].i_R9_n_r
    i_R9_n_i = struct[0].i_R9_n_i
    i_R10_a_r = struct[0].i_R10_a_r
    i_R10_a_i = struct[0].i_R10_a_i
    i_R10_b_r = struct[0].i_R10_b_r
    i_R10_b_i = struct[0].i_R10_b_i
    i_R10_c_r = struct[0].i_R10_c_r
    i_R10_c_i = struct[0].i_R10_c_i
    i_R10_n_r = struct[0].i_R10_n_r
    i_R10_n_i = struct[0].i_R10_n_i
    i_R11_b_r = struct[0].i_R11_b_r
    i_R11_b_i = struct[0].i_R11_b_i
    i_R11_c_r = struct[0].i_R11_c_r
    i_R11_c_i = struct[0].i_R11_c_i
    i_R12_a_r = struct[0].i_R12_a_r
    i_R12_a_i = struct[0].i_R12_a_i
    i_R12_b_r = struct[0].i_R12_b_r
    i_R12_b_i = struct[0].i_R12_b_i
    i_R12_c_r = struct[0].i_R12_c_r
    i_R12_c_i = struct[0].i_R12_c_i
    i_R12_n_r = struct[0].i_R12_n_r
    i_R12_n_i = struct[0].i_R12_n_i
    i_R13_a_r = struct[0].i_R13_a_r
    i_R13_a_i = struct[0].i_R13_a_i
    i_R13_b_r = struct[0].i_R13_b_r
    i_R13_b_i = struct[0].i_R13_b_i
    i_R13_c_r = struct[0].i_R13_c_r
    i_R13_c_i = struct[0].i_R13_c_i
    i_R13_n_r = struct[0].i_R13_n_r
    i_R13_n_i = struct[0].i_R13_n_i
    i_R14_a_r = struct[0].i_R14_a_r
    i_R14_a_i = struct[0].i_R14_a_i
    i_R14_b_r = struct[0].i_R14_b_r
    i_R14_b_i = struct[0].i_R14_b_i
    i_R14_c_r = struct[0].i_R14_c_r
    i_R14_c_i = struct[0].i_R14_c_i
    i_R14_n_r = struct[0].i_R14_n_r
    i_R14_n_i = struct[0].i_R14_n_i
    i_R15_b_r = struct[0].i_R15_b_r
    i_R15_b_i = struct[0].i_R15_b_i
    i_R15_c_r = struct[0].i_R15_c_r
    i_R15_c_i = struct[0].i_R15_c_i
    i_R16_b_r = struct[0].i_R16_b_r
    i_R16_b_i = struct[0].i_R16_b_i
    i_R16_c_r = struct[0].i_R16_c_r
    i_R16_c_i = struct[0].i_R16_c_i
    i_R17_b_r = struct[0].i_R17_b_r
    i_R17_b_i = struct[0].i_R17_b_i
    i_R17_c_r = struct[0].i_R17_c_r
    i_R17_c_i = struct[0].i_R17_c_i
    i_R18_b_r = struct[0].i_R18_b_r
    i_R18_b_i = struct[0].i_R18_b_i
    i_R18_c_r = struct[0].i_R18_c_r
    i_R18_c_i = struct[0].i_R18_c_i
    i_D1_n_r = struct[0].i_D1_n_r
    i_D1_n_i = struct[0].i_D1_n_i
    i_D3_a_r = struct[0].i_D3_a_r
    i_D3_a_i = struct[0].i_D3_a_i
    i_D3_b_r = struct[0].i_D3_b_r
    i_D3_b_i = struct[0].i_D3_b_i
    i_D3_c_r = struct[0].i_D3_c_r
    i_D3_c_i = struct[0].i_D3_c_i
    i_D3_n_r = struct[0].i_D3_n_r
    i_D3_n_i = struct[0].i_D3_n_i
    i_D4_a_r = struct[0].i_D4_a_r
    i_D4_a_i = struct[0].i_D4_a_i
    i_D4_b_r = struct[0].i_D4_b_r
    i_D4_b_i = struct[0].i_D4_b_i
    i_D4_c_r = struct[0].i_D4_c_r
    i_D4_c_i = struct[0].i_D4_c_i
    i_D4_n_r = struct[0].i_D4_n_r
    i_D4_n_i = struct[0].i_D4_n_i
    i_D6_a_r = struct[0].i_D6_a_r
    i_D6_a_i = struct[0].i_D6_a_i
    i_D6_b_r = struct[0].i_D6_b_r
    i_D6_b_i = struct[0].i_D6_b_i
    i_D6_c_r = struct[0].i_D6_c_r
    i_D6_c_i = struct[0].i_D6_c_i
    i_D6_n_r = struct[0].i_D6_n_r
    i_D6_n_i = struct[0].i_D6_n_i
    i_D9_a_r = struct[0].i_D9_a_r
    i_D9_a_i = struct[0].i_D9_a_i
    i_D9_b_r = struct[0].i_D9_b_r
    i_D9_b_i = struct[0].i_D9_b_i
    i_D9_c_r = struct[0].i_D9_c_r
    i_D9_c_i = struct[0].i_D9_c_i
    i_D9_n_r = struct[0].i_D9_n_r
    i_D9_n_i = struct[0].i_D9_n_i
    i_D10_a_i = struct[0].i_D10_a_i
    i_D10_b_r = struct[0].i_D10_b_r
    i_D10_b_i = struct[0].i_D10_b_i
    i_D10_c_r = struct[0].i_D10_c_r
    i_D10_c_i = struct[0].i_D10_c_i
    i_D10_n_i = struct[0].i_D10_n_i
    i_D11_b_r = struct[0].i_D11_b_r
    i_D11_b_i = struct[0].i_D11_b_i
    i_D11_c_r = struct[0].i_D11_c_r
    i_D11_c_i = struct[0].i_D11_c_i
    i_D16_b_r = struct[0].i_D16_b_r
    i_D16_b_i = struct[0].i_D16_b_i
    i_D16_c_r = struct[0].i_D16_c_r
    i_D16_c_i = struct[0].i_D16_c_i
    i_D17_b_r = struct[0].i_D17_b_r
    i_D17_b_i = struct[0].i_D17_b_i
    i_D17_c_r = struct[0].i_D17_c_r
    i_D17_c_i = struct[0].i_D17_c_i
    i_D18_b_r = struct[0].i_D18_b_r
    i_D18_b_i = struct[0].i_D18_b_i
    i_D18_c_r = struct[0].i_D18_c_r
    i_D18_c_i = struct[0].i_D18_c_i
    i_D14_a_i = struct[0].i_D14_a_i
    i_D14_b_r = struct[0].i_D14_b_r
    i_D14_b_i = struct[0].i_D14_b_i
    i_D14_c_r = struct[0].i_D14_c_r
    i_D14_c_i = struct[0].i_D14_c_i
    i_D14_n_i = struct[0].i_D14_n_i
    i_D15_b_r = struct[0].i_D15_b_r
    i_D15_b_i = struct[0].i_D15_b_i
    i_D15_c_r = struct[0].i_D15_c_r
    i_D15_c_i = struct[0].i_D15_c_i
    p_R1_a = struct[0].p_R1_a
    q_R1_a = struct[0].q_R1_a
    p_R1_b = struct[0].p_R1_b
    q_R1_b = struct[0].q_R1_b
    p_R1_c = struct[0].p_R1_c
    q_R1_c = struct[0].q_R1_c
    p_R11_1 = struct[0].p_R11_1
    q_R11_1 = struct[0].q_R11_1
    p_R15_1 = struct[0].p_R15_1
    q_R15_1 = struct[0].q_R15_1
    p_R16_1 = struct[0].p_R16_1
    q_R16_1 = struct[0].q_R16_1
    p_R17_1 = struct[0].p_R17_1
    q_R17_1 = struct[0].q_R17_1
    p_R18_1 = struct[0].p_R18_1
    q_R18_1 = struct[0].q_R18_1
    p_D15_1 = struct[0].p_D15_1
    q_D15_1 = struct[0].q_D15_1
    p_D11_1 = struct[0].p_D11_1
    q_D11_1 = struct[0].q_D11_1
    p_D16_1 = struct[0].p_D16_1
    q_D16_1 = struct[0].q_D16_1
    p_D17_1 = struct[0].p_D17_1
    q_D17_1 = struct[0].q_D17_1
    p_D18_1 = struct[0].p_D18_1
    q_D18_1 = struct[0].q_D18_1
    v_dc_D1 = struct[0].v_dc_D1
    q_R1 = struct[0].q_R1
    p_R10 = struct[0].p_R10
    q_R10 = struct[0].q_R10
    p_R14 = struct[0].p_R14
    q_R14 = struct[0].q_R14
    u_dummy = struct[0].u_dummy
    
    # Dynamical states:
    x_dummy = struct[0].x[0,0]
    
    # Algebraic states:
    v_R1_a_r = struct[0].y_ini[0,0]
    v_R1_a_i = struct[0].y_ini[1,0]
    v_R1_b_r = struct[0].y_ini[2,0]
    v_R1_b_i = struct[0].y_ini[3,0]
    v_R1_c_r = struct[0].y_ini[4,0]
    v_R1_c_i = struct[0].y_ini[5,0]
    v_R1_n_r = struct[0].y_ini[6,0]
    v_R1_n_i = struct[0].y_ini[7,0]
    v_R11_a_r = struct[0].y_ini[8,0]
    v_R11_a_i = struct[0].y_ini[9,0]
    v_R11_n_r = struct[0].y_ini[10,0]
    v_R11_n_i = struct[0].y_ini[11,0]
    v_R15_a_r = struct[0].y_ini[12,0]
    v_R15_a_i = struct[0].y_ini[13,0]
    v_R15_n_r = struct[0].y_ini[14,0]
    v_R15_n_i = struct[0].y_ini[15,0]
    v_R16_a_r = struct[0].y_ini[16,0]
    v_R16_a_i = struct[0].y_ini[17,0]
    v_R16_n_r = struct[0].y_ini[18,0]
    v_R16_n_i = struct[0].y_ini[19,0]
    v_R17_a_r = struct[0].y_ini[20,0]
    v_R17_a_i = struct[0].y_ini[21,0]
    v_R17_n_r = struct[0].y_ini[22,0]
    v_R17_n_i = struct[0].y_ini[23,0]
    v_R18_a_r = struct[0].y_ini[24,0]
    v_R18_a_i = struct[0].y_ini[25,0]
    v_R18_n_r = struct[0].y_ini[26,0]
    v_R18_n_i = struct[0].y_ini[27,0]
    v_D15_a_r = struct[0].y_ini[28,0]
    v_D15_a_i = struct[0].y_ini[29,0]
    v_D15_n_r = struct[0].y_ini[30,0]
    v_D15_n_i = struct[0].y_ini[31,0]
    v_D11_a_r = struct[0].y_ini[32,0]
    v_D11_a_i = struct[0].y_ini[33,0]
    v_D11_n_r = struct[0].y_ini[34,0]
    v_D11_n_i = struct[0].y_ini[35,0]
    v_D16_a_r = struct[0].y_ini[36,0]
    v_D16_a_i = struct[0].y_ini[37,0]
    v_D16_n_r = struct[0].y_ini[38,0]
    v_D16_n_i = struct[0].y_ini[39,0]
    v_D17_a_r = struct[0].y_ini[40,0]
    v_D17_a_i = struct[0].y_ini[41,0]
    v_D17_n_r = struct[0].y_ini[42,0]
    v_D17_n_i = struct[0].y_ini[43,0]
    v_D18_a_r = struct[0].y_ini[44,0]
    v_D18_a_i = struct[0].y_ini[45,0]
    v_D18_n_r = struct[0].y_ini[46,0]
    v_D18_n_i = struct[0].y_ini[47,0]
    v_R2_a_r = struct[0].y_ini[48,0]
    v_R2_a_i = struct[0].y_ini[49,0]
    v_R2_b_r = struct[0].y_ini[50,0]
    v_R2_b_i = struct[0].y_ini[51,0]
    v_R2_c_r = struct[0].y_ini[52,0]
    v_R2_c_i = struct[0].y_ini[53,0]
    v_R2_n_r = struct[0].y_ini[54,0]
    v_R2_n_i = struct[0].y_ini[55,0]
    v_R3_a_r = struct[0].y_ini[56,0]
    v_R3_a_i = struct[0].y_ini[57,0]
    v_R3_b_r = struct[0].y_ini[58,0]
    v_R3_b_i = struct[0].y_ini[59,0]
    v_R3_c_r = struct[0].y_ini[60,0]
    v_R3_c_i = struct[0].y_ini[61,0]
    v_R3_n_r = struct[0].y_ini[62,0]
    v_R3_n_i = struct[0].y_ini[63,0]
    v_R4_a_r = struct[0].y_ini[64,0]
    v_R4_a_i = struct[0].y_ini[65,0]
    v_R4_b_r = struct[0].y_ini[66,0]
    v_R4_b_i = struct[0].y_ini[67,0]
    v_R4_c_r = struct[0].y_ini[68,0]
    v_R4_c_i = struct[0].y_ini[69,0]
    v_R4_n_r = struct[0].y_ini[70,0]
    v_R4_n_i = struct[0].y_ini[71,0]
    v_R5_a_r = struct[0].y_ini[72,0]
    v_R5_a_i = struct[0].y_ini[73,0]
    v_R5_b_r = struct[0].y_ini[74,0]
    v_R5_b_i = struct[0].y_ini[75,0]
    v_R5_c_r = struct[0].y_ini[76,0]
    v_R5_c_i = struct[0].y_ini[77,0]
    v_R5_n_r = struct[0].y_ini[78,0]
    v_R5_n_i = struct[0].y_ini[79,0]
    v_R6_a_r = struct[0].y_ini[80,0]
    v_R6_a_i = struct[0].y_ini[81,0]
    v_R6_b_r = struct[0].y_ini[82,0]
    v_R6_b_i = struct[0].y_ini[83,0]
    v_R6_c_r = struct[0].y_ini[84,0]
    v_R6_c_i = struct[0].y_ini[85,0]
    v_R6_n_r = struct[0].y_ini[86,0]
    v_R6_n_i = struct[0].y_ini[87,0]
    v_R7_a_r = struct[0].y_ini[88,0]
    v_R7_a_i = struct[0].y_ini[89,0]
    v_R7_b_r = struct[0].y_ini[90,0]
    v_R7_b_i = struct[0].y_ini[91,0]
    v_R7_c_r = struct[0].y_ini[92,0]
    v_R7_c_i = struct[0].y_ini[93,0]
    v_R7_n_r = struct[0].y_ini[94,0]
    v_R7_n_i = struct[0].y_ini[95,0]
    v_R8_a_r = struct[0].y_ini[96,0]
    v_R8_a_i = struct[0].y_ini[97,0]
    v_R8_b_r = struct[0].y_ini[98,0]
    v_R8_b_i = struct[0].y_ini[99,0]
    v_R8_c_r = struct[0].y_ini[100,0]
    v_R8_c_i = struct[0].y_ini[101,0]
    v_R8_n_r = struct[0].y_ini[102,0]
    v_R8_n_i = struct[0].y_ini[103,0]
    v_R9_a_r = struct[0].y_ini[104,0]
    v_R9_a_i = struct[0].y_ini[105,0]
    v_R9_b_r = struct[0].y_ini[106,0]
    v_R9_b_i = struct[0].y_ini[107,0]
    v_R9_c_r = struct[0].y_ini[108,0]
    v_R9_c_i = struct[0].y_ini[109,0]
    v_R9_n_r = struct[0].y_ini[110,0]
    v_R9_n_i = struct[0].y_ini[111,0]
    v_R10_a_r = struct[0].y_ini[112,0]
    v_R10_a_i = struct[0].y_ini[113,0]
    v_R10_b_r = struct[0].y_ini[114,0]
    v_R10_b_i = struct[0].y_ini[115,0]
    v_R10_c_r = struct[0].y_ini[116,0]
    v_R10_c_i = struct[0].y_ini[117,0]
    v_R10_n_r = struct[0].y_ini[118,0]
    v_R10_n_i = struct[0].y_ini[119,0]
    v_R11_b_r = struct[0].y_ini[120,0]
    v_R11_b_i = struct[0].y_ini[121,0]
    v_R11_c_r = struct[0].y_ini[122,0]
    v_R11_c_i = struct[0].y_ini[123,0]
    v_R12_a_r = struct[0].y_ini[124,0]
    v_R12_a_i = struct[0].y_ini[125,0]
    v_R12_b_r = struct[0].y_ini[126,0]
    v_R12_b_i = struct[0].y_ini[127,0]
    v_R12_c_r = struct[0].y_ini[128,0]
    v_R12_c_i = struct[0].y_ini[129,0]
    v_R12_n_r = struct[0].y_ini[130,0]
    v_R12_n_i = struct[0].y_ini[131,0]
    v_R13_a_r = struct[0].y_ini[132,0]
    v_R13_a_i = struct[0].y_ini[133,0]
    v_R13_b_r = struct[0].y_ini[134,0]
    v_R13_b_i = struct[0].y_ini[135,0]
    v_R13_c_r = struct[0].y_ini[136,0]
    v_R13_c_i = struct[0].y_ini[137,0]
    v_R13_n_r = struct[0].y_ini[138,0]
    v_R13_n_i = struct[0].y_ini[139,0]
    v_R14_a_r = struct[0].y_ini[140,0]
    v_R14_a_i = struct[0].y_ini[141,0]
    v_R14_b_r = struct[0].y_ini[142,0]
    v_R14_b_i = struct[0].y_ini[143,0]
    v_R14_c_r = struct[0].y_ini[144,0]
    v_R14_c_i = struct[0].y_ini[145,0]
    v_R14_n_r = struct[0].y_ini[146,0]
    v_R14_n_i = struct[0].y_ini[147,0]
    v_R15_b_r = struct[0].y_ini[148,0]
    v_R15_b_i = struct[0].y_ini[149,0]
    v_R15_c_r = struct[0].y_ini[150,0]
    v_R15_c_i = struct[0].y_ini[151,0]
    v_R16_b_r = struct[0].y_ini[152,0]
    v_R16_b_i = struct[0].y_ini[153,0]
    v_R16_c_r = struct[0].y_ini[154,0]
    v_R16_c_i = struct[0].y_ini[155,0]
    v_R17_b_r = struct[0].y_ini[156,0]
    v_R17_b_i = struct[0].y_ini[157,0]
    v_R17_c_r = struct[0].y_ini[158,0]
    v_R17_c_i = struct[0].y_ini[159,0]
    v_R18_b_r = struct[0].y_ini[160,0]
    v_R18_b_i = struct[0].y_ini[161,0]
    v_R18_c_r = struct[0].y_ini[162,0]
    v_R18_c_i = struct[0].y_ini[163,0]
    v_D1_n_r = struct[0].y_ini[164,0]
    v_D1_n_i = struct[0].y_ini[165,0]
    v_D3_a_r = struct[0].y_ini[166,0]
    v_D3_a_i = struct[0].y_ini[167,0]
    v_D3_b_r = struct[0].y_ini[168,0]
    v_D3_b_i = struct[0].y_ini[169,0]
    v_D3_c_r = struct[0].y_ini[170,0]
    v_D3_c_i = struct[0].y_ini[171,0]
    v_D3_n_r = struct[0].y_ini[172,0]
    v_D3_n_i = struct[0].y_ini[173,0]
    v_D4_a_r = struct[0].y_ini[174,0]
    v_D4_a_i = struct[0].y_ini[175,0]
    v_D4_b_r = struct[0].y_ini[176,0]
    v_D4_b_i = struct[0].y_ini[177,0]
    v_D4_c_r = struct[0].y_ini[178,0]
    v_D4_c_i = struct[0].y_ini[179,0]
    v_D4_n_r = struct[0].y_ini[180,0]
    v_D4_n_i = struct[0].y_ini[181,0]
    v_D6_a_r = struct[0].y_ini[182,0]
    v_D6_a_i = struct[0].y_ini[183,0]
    v_D6_b_r = struct[0].y_ini[184,0]
    v_D6_b_i = struct[0].y_ini[185,0]
    v_D6_c_r = struct[0].y_ini[186,0]
    v_D6_c_i = struct[0].y_ini[187,0]
    v_D6_n_r = struct[0].y_ini[188,0]
    v_D6_n_i = struct[0].y_ini[189,0]
    v_D9_a_r = struct[0].y_ini[190,0]
    v_D9_a_i = struct[0].y_ini[191,0]
    v_D9_b_r = struct[0].y_ini[192,0]
    v_D9_b_i = struct[0].y_ini[193,0]
    v_D9_c_r = struct[0].y_ini[194,0]
    v_D9_c_i = struct[0].y_ini[195,0]
    v_D9_n_r = struct[0].y_ini[196,0]
    v_D9_n_i = struct[0].y_ini[197,0]
    v_D10_a_r = struct[0].y_ini[198,0]
    v_D10_a_i = struct[0].y_ini[199,0]
    v_D10_b_r = struct[0].y_ini[200,0]
    v_D10_b_i = struct[0].y_ini[201,0]
    v_D10_c_r = struct[0].y_ini[202,0]
    v_D10_c_i = struct[0].y_ini[203,0]
    v_D10_n_r = struct[0].y_ini[204,0]
    v_D10_n_i = struct[0].y_ini[205,0]
    v_D11_b_r = struct[0].y_ini[206,0]
    v_D11_b_i = struct[0].y_ini[207,0]
    v_D11_c_r = struct[0].y_ini[208,0]
    v_D11_c_i = struct[0].y_ini[209,0]
    v_D16_b_r = struct[0].y_ini[210,0]
    v_D16_b_i = struct[0].y_ini[211,0]
    v_D16_c_r = struct[0].y_ini[212,0]
    v_D16_c_i = struct[0].y_ini[213,0]
    v_D17_b_r = struct[0].y_ini[214,0]
    v_D17_b_i = struct[0].y_ini[215,0]
    v_D17_c_r = struct[0].y_ini[216,0]
    v_D17_c_i = struct[0].y_ini[217,0]
    v_D18_b_r = struct[0].y_ini[218,0]
    v_D18_b_i = struct[0].y_ini[219,0]
    v_D18_c_r = struct[0].y_ini[220,0]
    v_D18_c_i = struct[0].y_ini[221,0]
    v_D14_a_r = struct[0].y_ini[222,0]
    v_D14_a_i = struct[0].y_ini[223,0]
    v_D14_b_r = struct[0].y_ini[224,0]
    v_D14_b_i = struct[0].y_ini[225,0]
    v_D14_c_r = struct[0].y_ini[226,0]
    v_D14_c_i = struct[0].y_ini[227,0]
    v_D14_n_r = struct[0].y_ini[228,0]
    v_D14_n_i = struct[0].y_ini[229,0]
    v_D15_b_r = struct[0].y_ini[230,0]
    v_D15_b_i = struct[0].y_ini[231,0]
    v_D15_c_r = struct[0].y_ini[232,0]
    v_D15_c_i = struct[0].y_ini[233,0]
    i_t_R0_R1_a_r = struct[0].y_ini[234,0]
    i_t_R0_R1_a_i = struct[0].y_ini[235,0]
    i_t_R0_R1_b_r = struct[0].y_ini[236,0]
    i_t_R0_R1_b_i = struct[0].y_ini[237,0]
    i_t_R0_R1_c_r = struct[0].y_ini[238,0]
    i_t_R0_R1_c_i = struct[0].y_ini[239,0]
    i_l_R1_R2_a_r = struct[0].y_ini[240,0]
    i_l_R1_R2_a_i = struct[0].y_ini[241,0]
    i_l_R1_R2_b_r = struct[0].y_ini[242,0]
    i_l_R1_R2_b_i = struct[0].y_ini[243,0]
    i_l_R1_R2_c_r = struct[0].y_ini[244,0]
    i_l_R1_R2_c_i = struct[0].y_ini[245,0]
    i_l_R1_R2_n_r = struct[0].y_ini[246,0]
    i_l_R1_R2_n_i = struct[0].y_ini[247,0]
    i_l_D1_D3_a_r = struct[0].y_ini[248,0]
    i_l_D1_D3_a_i = struct[0].y_ini[249,0]
    i_l_D1_D3_b_r = struct[0].y_ini[250,0]
    i_l_D1_D3_b_i = struct[0].y_ini[251,0]
    i_l_D1_D3_c_r = struct[0].y_ini[252,0]
    i_l_D1_D3_c_i = struct[0].y_ini[253,0]
    i_l_D1_D3_n_r = struct[0].y_ini[254,0]
    i_l_D1_D3_n_i = struct[0].y_ini[255,0]
    i_l_D3_D4_a_r = struct[0].y_ini[256,0]
    i_l_D3_D4_a_i = struct[0].y_ini[257,0]
    i_l_D3_D4_b_r = struct[0].y_ini[258,0]
    i_l_D3_D4_b_i = struct[0].y_ini[259,0]
    i_l_D3_D4_c_r = struct[0].y_ini[260,0]
    i_l_D3_D4_c_i = struct[0].y_ini[261,0]
    i_l_D3_D4_n_r = struct[0].y_ini[262,0]
    i_l_D3_D4_n_i = struct[0].y_ini[263,0]
    i_l_D4_D6_a_r = struct[0].y_ini[264,0]
    i_l_D4_D6_a_i = struct[0].y_ini[265,0]
    i_l_D4_D6_b_r = struct[0].y_ini[266,0]
    i_l_D4_D6_b_i = struct[0].y_ini[267,0]
    i_l_D4_D6_c_r = struct[0].y_ini[268,0]
    i_l_D4_D6_c_i = struct[0].y_ini[269,0]
    i_l_D4_D6_n_r = struct[0].y_ini[270,0]
    i_l_D4_D6_n_i = struct[0].y_ini[271,0]
    i_l_D6_D9_a_r = struct[0].y_ini[272,0]
    i_l_D6_D9_a_i = struct[0].y_ini[273,0]
    i_l_D6_D9_b_r = struct[0].y_ini[274,0]
    i_l_D6_D9_b_i = struct[0].y_ini[275,0]
    i_l_D6_D9_c_r = struct[0].y_ini[276,0]
    i_l_D6_D9_c_i = struct[0].y_ini[277,0]
    i_l_D6_D9_n_r = struct[0].y_ini[278,0]
    i_l_D6_D9_n_i = struct[0].y_ini[279,0]
    i_l_D9_D10_a_r = struct[0].y_ini[280,0]
    i_l_D9_D10_a_i = struct[0].y_ini[281,0]
    i_l_D9_D10_b_r = struct[0].y_ini[282,0]
    i_l_D9_D10_b_i = struct[0].y_ini[283,0]
    i_l_D9_D10_c_r = struct[0].y_ini[284,0]
    i_l_D9_D10_c_i = struct[0].y_ini[285,0]
    i_l_D9_D10_n_r = struct[0].y_ini[286,0]
    i_l_D9_D10_n_i = struct[0].y_ini[287,0]
    i_l_D3_D11_a_r = struct[0].y_ini[288,0]
    i_l_D3_D11_a_i = struct[0].y_ini[289,0]
    i_l_D3_D11_b_r = struct[0].y_ini[290,0]
    i_l_D3_D11_b_i = struct[0].y_ini[291,0]
    i_l_D3_D11_c_r = struct[0].y_ini[292,0]
    i_l_D3_D11_c_i = struct[0].y_ini[293,0]
    i_l_D3_D11_n_r = struct[0].y_ini[294,0]
    i_l_D3_D11_n_i = struct[0].y_ini[295,0]
    i_l_D6_D16_a_r = struct[0].y_ini[296,0]
    i_l_D6_D16_a_i = struct[0].y_ini[297,0]
    i_l_D6_D16_b_r = struct[0].y_ini[298,0]
    i_l_D6_D16_b_i = struct[0].y_ini[299,0]
    i_l_D6_D16_c_r = struct[0].y_ini[300,0]
    i_l_D6_D16_c_i = struct[0].y_ini[301,0]
    i_l_D6_D16_n_r = struct[0].y_ini[302,0]
    i_l_D6_D16_n_i = struct[0].y_ini[303,0]
    i_l_D9_D17_a_r = struct[0].y_ini[304,0]
    i_l_D9_D17_a_i = struct[0].y_ini[305,0]
    i_l_D9_D17_b_r = struct[0].y_ini[306,0]
    i_l_D9_D17_b_i = struct[0].y_ini[307,0]
    i_l_D9_D17_c_r = struct[0].y_ini[308,0]
    i_l_D9_D17_c_i = struct[0].y_ini[309,0]
    i_l_D9_D17_n_r = struct[0].y_ini[310,0]
    i_l_D9_D17_n_i = struct[0].y_ini[311,0]
    i_l_D10_D18_a_r = struct[0].y_ini[312,0]
    i_l_D10_D18_a_i = struct[0].y_ini[313,0]
    i_l_D10_D18_b_r = struct[0].y_ini[314,0]
    i_l_D10_D18_b_i = struct[0].y_ini[315,0]
    i_l_D10_D18_c_r = struct[0].y_ini[316,0]
    i_l_D10_D18_c_i = struct[0].y_ini[317,0]
    i_l_D10_D18_n_r = struct[0].y_ini[318,0]
    i_l_D10_D18_n_i = struct[0].y_ini[319,0]
    i_l_D4_D14_a_r = struct[0].y_ini[320,0]
    i_l_D4_D14_a_i = struct[0].y_ini[321,0]
    i_l_D4_D14_b_r = struct[0].y_ini[322,0]
    i_l_D4_D14_b_i = struct[0].y_ini[323,0]
    i_l_D4_D14_c_r = struct[0].y_ini[324,0]
    i_l_D4_D14_c_i = struct[0].y_ini[325,0]
    i_l_D4_D14_n_r = struct[0].y_ini[326,0]
    i_l_D4_D14_n_i = struct[0].y_ini[327,0]
    i_l_D14_D15_a_r = struct[0].y_ini[328,0]
    i_l_D14_D15_a_i = struct[0].y_ini[329,0]
    i_l_D14_D15_b_r = struct[0].y_ini[330,0]
    i_l_D14_D15_b_i = struct[0].y_ini[331,0]
    i_l_D14_D15_c_r = struct[0].y_ini[332,0]
    i_l_D14_D15_c_i = struct[0].y_ini[333,0]
    i_l_D14_D15_n_r = struct[0].y_ini[334,0]
    i_l_D14_D15_n_i = struct[0].y_ini[335,0]
    i_load_R1_a_r = struct[0].y_ini[336,0]
    i_load_R1_a_i = struct[0].y_ini[337,0]
    i_load_R1_b_r = struct[0].y_ini[338,0]
    i_load_R1_b_i = struct[0].y_ini[339,0]
    i_load_R1_c_r = struct[0].y_ini[340,0]
    i_load_R1_c_i = struct[0].y_ini[341,0]
    i_load_R1_n_r = struct[0].y_ini[342,0]
    i_load_R1_n_i = struct[0].y_ini[343,0]
    i_load_R11_a_r = struct[0].y_ini[344,0]
    i_load_R11_a_i = struct[0].y_ini[345,0]
    i_load_R11_n_r = struct[0].y_ini[346,0]
    i_load_R11_n_i = struct[0].y_ini[347,0]
    i_load_R15_a_r = struct[0].y_ini[348,0]
    i_load_R15_a_i = struct[0].y_ini[349,0]
    i_load_R15_n_r = struct[0].y_ini[350,0]
    i_load_R15_n_i = struct[0].y_ini[351,0]
    i_load_R16_a_r = struct[0].y_ini[352,0]
    i_load_R16_a_i = struct[0].y_ini[353,0]
    i_load_R16_n_r = struct[0].y_ini[354,0]
    i_load_R16_n_i = struct[0].y_ini[355,0]
    i_load_R17_a_r = struct[0].y_ini[356,0]
    i_load_R17_a_i = struct[0].y_ini[357,0]
    i_load_R17_n_r = struct[0].y_ini[358,0]
    i_load_R17_n_i = struct[0].y_ini[359,0]
    i_load_R18_a_r = struct[0].y_ini[360,0]
    i_load_R18_a_i = struct[0].y_ini[361,0]
    i_load_R18_n_r = struct[0].y_ini[362,0]
    i_load_R18_n_i = struct[0].y_ini[363,0]
    i_load_D15_a_r = struct[0].y_ini[364,0]
    i_load_D15_a_i = struct[0].y_ini[365,0]
    i_load_D15_n_r = struct[0].y_ini[366,0]
    i_load_D15_n_i = struct[0].y_ini[367,0]
    i_load_D11_a_r = struct[0].y_ini[368,0]
    i_load_D11_a_i = struct[0].y_ini[369,0]
    i_load_D11_n_r = struct[0].y_ini[370,0]
    i_load_D11_n_i = struct[0].y_ini[371,0]
    i_load_D16_a_r = struct[0].y_ini[372,0]
    i_load_D16_a_i = struct[0].y_ini[373,0]
    i_load_D16_n_r = struct[0].y_ini[374,0]
    i_load_D16_n_i = struct[0].y_ini[375,0]
    i_load_D17_a_r = struct[0].y_ini[376,0]
    i_load_D17_a_i = struct[0].y_ini[377,0]
    i_load_D17_n_r = struct[0].y_ini[378,0]
    i_load_D17_n_i = struct[0].y_ini[379,0]
    i_load_D18_a_r = struct[0].y_ini[380,0]
    i_load_D18_a_i = struct[0].y_ini[381,0]
    i_load_D18_n_r = struct[0].y_ini[382,0]
    i_load_D18_n_i = struct[0].y_ini[383,0]
    i_vsc_R1_a_r = struct[0].y_ini[384,0]
    i_vsc_R1_a_i = struct[0].y_ini[385,0]
    i_vsc_R1_b_r = struct[0].y_ini[386,0]
    i_vsc_R1_b_i = struct[0].y_ini[387,0]
    i_vsc_R1_c_r = struct[0].y_ini[388,0]
    i_vsc_R1_c_i = struct[0].y_ini[389,0]
    p_R1 = struct[0].y_ini[390,0]
    p_D1 = struct[0].y_ini[391,0]
    p_loss_R1 = struct[0].y_ini[392,0]
    i_vsc_R10_a_r = struct[0].y_ini[393,0]
    i_vsc_R10_a_i = struct[0].y_ini[394,0]
    i_vsc_R10_b_r = struct[0].y_ini[395,0]
    i_vsc_R10_b_i = struct[0].y_ini[396,0]
    i_vsc_R10_c_r = struct[0].y_ini[397,0]
    i_vsc_R10_c_i = struct[0].y_ini[398,0]
    i_vsc_R10_n_r = struct[0].y_ini[399,0]
    i_vsc_R10_n_i = struct[0].y_ini[400,0]
    i_vsc_D10_a_r = struct[0].y_ini[401,0]
    i_vsc_D10_n_r = struct[0].y_ini[402,0]
    p_D10 = struct[0].y_ini[403,0]
    i_vsc_R14_a_r = struct[0].y_ini[404,0]
    i_vsc_R14_a_i = struct[0].y_ini[405,0]
    i_vsc_R14_b_r = struct[0].y_ini[406,0]
    i_vsc_R14_b_i = struct[0].y_ini[407,0]
    i_vsc_R14_c_r = struct[0].y_ini[408,0]
    i_vsc_R14_c_i = struct[0].y_ini[409,0]
    i_vsc_R14_n_r = struct[0].y_ini[410,0]
    i_vsc_R14_n_i = struct[0].y_ini[411,0]
    i_vsc_D14_a_r = struct[0].y_ini[412,0]
    i_vsc_D14_n_r = struct[0].y_ini[413,0]
    p_D14 = struct[0].y_ini[414,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = u_dummy - x_dummy
    
    # Algebraic equations:
    if mode == 3:

        struct[0].g[:,:] = np.ascontiguousarray(struct[0].Gy_ini) @ np.ascontiguousarray(struct[0].y_ini)

        struct[0].g[0,0] = i_load_R1_a_r + i_vsc_R1_a_r + 0.849044513514155*v_R0_a_i + 0.212261128378539*v_R0_a_r - 0.849044513514155*v_R0_c_i - 0.212261128378539*v_R0_c_r - 127.595184532966*v_R1_a_i - 123.954122254357*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r + 23.284964480954*v_R1_c_i + 24.9575997948692*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r
        struct[0].g[1,0] = i_load_R1_a_i + i_vsc_R1_a_i + 0.212261128378539*v_R0_a_i - 0.849044513514155*v_R0_a_r - 0.212261128378539*v_R0_c_i + 0.849044513514155*v_R0_c_r - 123.954122254357*v_R1_a_i + 127.595184532966*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r + 24.9575997948692*v_R1_c_i - 23.284964480954*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r
        struct[0].g[2,0] = i_load_R1_b_r + i_vsc_R1_b_r - 0.849044513514155*v_R0_a_i - 0.212261128378539*v_R0_a_r + 0.849044513514155*v_R0_b_i + 0.212261128378539*v_R0_b_r + 10.2713736253513*v_R1_a_i + 39.6392229058202*v_R1_a_r - 127.595184532966*v_R1_b_i - 123.954122254357*v_R1_b_r + 10.2713736253513*v_R1_c_i + 39.6392229058201*v_R1_c_r + 96.8143762456598*v_R1_n_i + 43.3399527360457*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r
        struct[0].g[3,0] = i_load_R1_b_i + i_vsc_R1_b_i - 0.212261128378539*v_R0_a_i + 0.849044513514155*v_R0_a_r + 0.212261128378539*v_R0_b_i - 0.849044513514155*v_R0_b_r + 39.6392229058202*v_R1_a_i - 10.2713736253513*v_R1_a_r - 123.954122254357*v_R1_b_i + 127.595184532966*v_R1_b_r + 39.6392229058201*v_R1_c_i - 10.2713736253513*v_R1_c_r + 43.3399527360457*v_R1_n_i - 96.8143762456598*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r
        struct[0].g[4,0] = i_load_R1_c_r + i_vsc_R1_c_r - 0.849044513514155*v_R0_b_i - 0.212261128378539*v_R0_b_r + 0.849044513514155*v_R0_c_i + 0.212261128378539*v_R0_c_r + 23.284964480954*v_R1_a_i + 24.9575997948692*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r - 127.595184532966*v_R1_c_i - 123.954122254357*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r
        struct[0].g[5,0] = i_load_R1_c_i + i_vsc_R1_c_i - 0.212261128378539*v_R0_b_i + 0.849044513514155*v_R0_b_r + 0.212261128378539*v_R0_c_i - 0.849044513514155*v_R0_c_r + 24.9575997948692*v_R1_a_i - 23.284964480954*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r - 123.954122254357*v_R1_c_i + 127.595184532966*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r
        struct[0].g[166,0] = 157.977883096366*v_D11_a_r + 67.7048070412999*v_D1_a_r - 361.092304220266*v_D3_a_r + 135.4096140826*v_D4_a_r
        struct[0].g[167,0] = 157.977883096366*v_D11_a_i + 67.7048070412999*v_D1_a_i - 361.092304220266*v_D3_a_i + 135.4096140826*v_D4_a_i
        struct[0].g[168,0] = 157.977883096366*v_D11_b_r + 67.7048070412999*v_D1_b_r - 361.092304220266*v_D3_b_r + 135.4096140826*v_D4_b_r
        struct[0].g[169,0] = 157.977883096366*v_D11_b_i + 67.7048070412999*v_D1_b_i - 361.092304220266*v_D3_b_i + 135.4096140826*v_D4_b_i
        struct[0].g[170,0] = 157.977883096366*v_D11_c_r + 67.7048070412999*v_D1_c_r - 361.092304220266*v_D3_c_r + 135.4096140826*v_D4_c_r
        struct[0].g[171,0] = 157.977883096366*v_D11_c_i + 67.7048070412999*v_D1_c_i - 361.092304220266*v_D3_c_i + 135.4096140826*v_D4_c_i
        struct[0].g[234,0] = -i_t_R0_R1_a_r + 0.0196078431372549*v_R0_a_i + 0.00490196078431373*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_a_i - 0.212261128378539*v_R1_a_r + 0.849044513514155*v_R1_b_i + 0.212261128378539*v_R1_b_r
        struct[0].g[235,0] = -i_t_R0_R1_a_i + 0.00490196078431373*v_R0_a_i - 0.0196078431372549*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_a_i + 0.849044513514155*v_R1_a_r + 0.212261128378539*v_R1_b_i - 0.849044513514155*v_R1_b_r
        struct[0].g[236,0] = -i_t_R0_R1_b_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r + 0.0196078431372549*v_R0_b_i + 0.00490196078431373*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_b_i - 0.212261128378539*v_R1_b_r + 0.849044513514155*v_R1_c_i + 0.212261128378539*v_R1_c_r
        struct[0].g[237,0] = -i_t_R0_R1_b_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r + 0.00490196078431373*v_R0_b_i - 0.0196078431372549*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_b_i + 0.849044513514155*v_R1_b_r + 0.212261128378539*v_R1_c_i - 0.849044513514155*v_R1_c_r
        struct[0].g[238,0] = -i_t_R0_R1_c_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r + 0.0196078431372549*v_R0_c_i + 0.00490196078431373*v_R0_c_r + 0.849044513514155*v_R1_a_i + 0.212261128378539*v_R1_a_r - 0.849044513514155*v_R1_c_i - 0.212261128378539*v_R1_c_r
        struct[0].g[239,0] = -i_t_R0_R1_c_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r + 0.00490196078431373*v_R0_c_i - 0.0196078431372549*v_R0_c_r + 0.212261128378539*v_R1_a_i - 0.849044513514155*v_R1_a_r - 0.212261128378539*v_R1_c_i + 0.849044513514155*v_R1_c_r
        struct[0].g[248,0] = -i_l_D1_D3_a_r + 67.7048070412999*v_D1_a_r - 67.7048070412999*v_D3_a_r
        struct[0].g[249,0] = -i_l_D1_D3_a_i + 67.7048070412999*v_D1_a_i - 67.7048070412999*v_D3_a_i
        struct[0].g[250,0] = -i_l_D1_D3_b_r + 67.7048070412999*v_D1_b_r - 67.7048070412999*v_D3_b_r
        struct[0].g[251,0] = -i_l_D1_D3_b_i + 67.7048070412999*v_D1_b_i - 67.7048070412999*v_D3_b_i
        struct[0].g[252,0] = -i_l_D1_D3_c_r + 67.7048070412999*v_D1_c_r - 67.7048070412999*v_D3_c_r
        struct[0].g[253,0] = -i_l_D1_D3_c_i + 67.7048070412999*v_D1_c_i - 67.7048070412999*v_D3_c_i
        struct[0].g[336,0] = i_load_R1_a_i*v_R1_a_i - i_load_R1_a_i*v_R1_n_i + i_load_R1_a_r*v_R1_a_r - i_load_R1_a_r*v_R1_n_r - p_R1_a
        struct[0].g[337,0] = i_load_R1_b_i*v_R1_b_i - i_load_R1_b_i*v_R1_n_i + i_load_R1_b_r*v_R1_b_r - i_load_R1_b_r*v_R1_n_r - p_R1_b
        struct[0].g[338,0] = i_load_R1_c_i*v_R1_c_i - i_load_R1_c_i*v_R1_n_i + i_load_R1_c_r*v_R1_c_r - i_load_R1_c_r*v_R1_n_r - p_R1_c
        struct[0].g[339,0] = -i_load_R1_a_i*v_R1_a_r + i_load_R1_a_i*v_R1_n_r + i_load_R1_a_r*v_R1_a_i - i_load_R1_a_r*v_R1_n_i - q_R1_a
        struct[0].g[340,0] = -i_load_R1_b_i*v_R1_b_r + i_load_R1_b_i*v_R1_n_r + i_load_R1_b_r*v_R1_b_i - i_load_R1_b_r*v_R1_n_i - q_R1_b
        struct[0].g[341,0] = -i_load_R1_c_i*v_R1_c_r + i_load_R1_c_i*v_R1_n_r + i_load_R1_c_r*v_R1_c_i - i_load_R1_c_r*v_R1_n_i - q_R1_c
        struct[0].g[344,0] = 1.0*i_load_R11_a_i*v_R11_a_i - 1.0*i_load_R11_a_i*v_R11_n_i + i_load_R11_a_r*v_R11_a_r - i_load_R11_a_r*v_R11_n_r - p_R11_1
        struct[0].g[345,0] = -1.0*i_load_R11_a_i*v_R11_a_r + 1.0*i_load_R11_a_i*v_R11_n_r + 1.0*i_load_R11_a_r*v_R11_a_i - 1.0*i_load_R11_a_r*v_R11_n_i - q_R11_1
        struct[0].g[348,0] = 1.0*i_load_R15_a_i*v_R15_a_i - 1.0*i_load_R15_a_i*v_R15_n_i + i_load_R15_a_r*v_R15_a_r - i_load_R15_a_r*v_R15_n_r - p_R15_1
        struct[0].g[349,0] = -1.0*i_load_R15_a_i*v_R15_a_r + 1.0*i_load_R15_a_i*v_R15_n_r + 1.0*i_load_R15_a_r*v_R15_a_i - 1.0*i_load_R15_a_r*v_R15_n_i - q_R15_1
        struct[0].g[352,0] = 1.0*i_load_R16_a_i*v_R16_a_i - 1.0*i_load_R16_a_i*v_R16_n_i + i_load_R16_a_r*v_R16_a_r - i_load_R16_a_r*v_R16_n_r - p_R16_1
        struct[0].g[353,0] = -1.0*i_load_R16_a_i*v_R16_a_r + 1.0*i_load_R16_a_i*v_R16_n_r + 1.0*i_load_R16_a_r*v_R16_a_i - 1.0*i_load_R16_a_r*v_R16_n_i - q_R16_1
        struct[0].g[356,0] = 1.0*i_load_R17_a_i*v_R17_a_i - 1.0*i_load_R17_a_i*v_R17_n_i + i_load_R17_a_r*v_R17_a_r - i_load_R17_a_r*v_R17_n_r - p_R17_1
        struct[0].g[357,0] = -1.0*i_load_R17_a_i*v_R17_a_r + 1.0*i_load_R17_a_i*v_R17_n_r + 1.0*i_load_R17_a_r*v_R17_a_i - 1.0*i_load_R17_a_r*v_R17_n_i - q_R17_1
        struct[0].g[360,0] = 1.0*i_load_R18_a_i*v_R18_a_i - 1.0*i_load_R18_a_i*v_R18_n_i + i_load_R18_a_r*v_R18_a_r - i_load_R18_a_r*v_R18_n_r - p_R18_1
        struct[0].g[361,0] = -1.0*i_load_R18_a_i*v_R18_a_r + 1.0*i_load_R18_a_i*v_R18_n_r + 1.0*i_load_R18_a_r*v_R18_a_i - 1.0*i_load_R18_a_r*v_R18_n_i - q_R18_1
        struct[0].g[364,0] = 1.0*i_load_D15_a_i*v_D15_a_i - 1.0*i_load_D15_a_i*v_D15_n_i + i_load_D15_a_r*v_D15_a_r - i_load_D15_a_r*v_D15_n_r - p_D15_1
        struct[0].g[365,0] = -1.0*i_load_D15_a_i*v_D15_a_r + 1.0*i_load_D15_a_i*v_D15_n_r + 1.0*i_load_D15_a_r*v_D15_a_i - 1.0*i_load_D15_a_r*v_D15_n_i - q_D15_1
        struct[0].g[368,0] = 1.0*i_load_D11_a_i*v_D11_a_i - 1.0*i_load_D11_a_i*v_D11_n_i + i_load_D11_a_r*v_D11_a_r - i_load_D11_a_r*v_D11_n_r - p_D11_1
        struct[0].g[369,0] = -1.0*i_load_D11_a_i*v_D11_a_r + 1.0*i_load_D11_a_i*v_D11_n_r + 1.0*i_load_D11_a_r*v_D11_a_i - 1.0*i_load_D11_a_r*v_D11_n_i - q_D11_1
        struct[0].g[372,0] = 1.0*i_load_D16_a_i*v_D16_a_i - 1.0*i_load_D16_a_i*v_D16_n_i + i_load_D16_a_r*v_D16_a_r - i_load_D16_a_r*v_D16_n_r - p_D16_1
        struct[0].g[373,0] = -1.0*i_load_D16_a_i*v_D16_a_r + 1.0*i_load_D16_a_i*v_D16_n_r + 1.0*i_load_D16_a_r*v_D16_a_i - 1.0*i_load_D16_a_r*v_D16_n_i - q_D16_1
        struct[0].g[376,0] = 1.0*i_load_D17_a_i*v_D17_a_i - 1.0*i_load_D17_a_i*v_D17_n_i + i_load_D17_a_r*v_D17_a_r - i_load_D17_a_r*v_D17_n_r - p_D17_1
        struct[0].g[377,0] = -1.0*i_load_D17_a_i*v_D17_a_r + 1.0*i_load_D17_a_i*v_D17_n_r + 1.0*i_load_D17_a_r*v_D17_a_i - 1.0*i_load_D17_a_r*v_D17_n_i - q_D17_1
        struct[0].g[380,0] = 1.0*i_load_D18_a_i*v_D18_a_i - 1.0*i_load_D18_a_i*v_D18_n_i + i_load_D18_a_r*v_D18_a_r - i_load_D18_a_r*v_D18_n_r - p_D18_1
        struct[0].g[381,0] = -1.0*i_load_D18_a_i*v_D18_a_r + 1.0*i_load_D18_a_i*v_D18_n_r + 1.0*i_load_D18_a_r*v_D18_a_i - 1.0*i_load_D18_a_r*v_D18_n_i - q_D18_1
        struct[0].g[384,0] = 1.0*i_vsc_R1_a_i*v_R1_a_i - 1.0*i_vsc_R1_a_i*v_R1_n_i + i_vsc_R1_a_r*v_R1_a_r - i_vsc_R1_a_r*v_R1_n_r - p_R1/3
        struct[0].g[385,0] = -1.0*i_vsc_R1_a_i*v_R1_a_r + 1.0*i_vsc_R1_a_i*v_R1_n_r + 1.0*i_vsc_R1_a_r*v_R1_a_i - 1.0*i_vsc_R1_a_r*v_R1_n_i - q_R1/3
        struct[0].g[386,0] = 1.0*i_vsc_R1_b_i*v_R1_b_i - 1.0*i_vsc_R1_b_i*v_R1_n_i + i_vsc_R1_b_r*v_R1_b_r - i_vsc_R1_b_r*v_R1_n_r - p_R1/3
        struct[0].g[387,0] = -1.0*i_vsc_R1_b_i*v_R1_b_r + 1.0*i_vsc_R1_b_i*v_R1_n_r + 1.0*i_vsc_R1_b_r*v_R1_b_i - 1.0*i_vsc_R1_b_r*v_R1_n_i - q_R1/3
        struct[0].g[388,0] = 1.0*i_vsc_R1_c_i*v_R1_c_i - 1.0*i_vsc_R1_c_i*v_R1_n_i + i_vsc_R1_c_r*v_R1_c_r - i_vsc_R1_c_r*v_R1_n_r - p_R1/3
        struct[0].g[389,0] = -1.0*i_vsc_R1_c_i*v_R1_c_r + 1.0*i_vsc_R1_c_i*v_R1_n_r + 1.0*i_vsc_R1_c_r*v_R1_c_i - 1.0*i_vsc_R1_c_r*v_R1_n_i - q_R1/3
        struct[0].g[390,0] = p_D1 + p_R1 + Piecewise(np.array([(-p_loss_R1, p_D1 < 0), (p_loss_R1, True)]))
        struct[0].g[392,0] = -a_R1 - b_R1*sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - c_R1*(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) + p_loss_R1
        struct[0].g[393,0] = -coef_a_R10*p_R10 + 1.0*i_vsc_R10_a_i*v_R10_a_i - 1.0*i_vsc_R10_a_i*v_R10_n_i + i_vsc_R10_a_r*v_R10_a_r - i_vsc_R10_a_r*v_R10_n_r
        struct[0].g[394,0] = -coef_a_R10*q_R10 - 1.0*i_vsc_R10_a_i*v_R10_a_r + 1.0*i_vsc_R10_a_i*v_R10_n_r + 1.0*i_vsc_R10_a_r*v_R10_a_i - 1.0*i_vsc_R10_a_r*v_R10_n_i
        struct[0].g[395,0] = -coef_b_R10*p_R10 + 1.0*i_vsc_R10_b_i*v_R10_b_i - 1.0*i_vsc_R10_b_i*v_R10_n_i + i_vsc_R10_b_r*v_R10_b_r - i_vsc_R10_b_r*v_R10_n_r
        struct[0].g[396,0] = -coef_b_R10*q_R10 - 1.0*i_vsc_R10_b_i*v_R10_b_r + 1.0*i_vsc_R10_b_i*v_R10_n_r + 1.0*i_vsc_R10_b_r*v_R10_b_i - 1.0*i_vsc_R10_b_r*v_R10_n_i
        struct[0].g[397,0] = -coef_c_R10*p_R10 + 1.0*i_vsc_R10_c_i*v_R10_c_i - 1.0*i_vsc_R10_c_i*v_R10_n_i + i_vsc_R10_c_r*v_R10_c_r - i_vsc_R10_c_r*v_R10_n_r
        struct[0].g[398,0] = -coef_c_R10*q_R10 - 1.0*i_vsc_R10_c_i*v_R10_c_r + 1.0*i_vsc_R10_c_i*v_R10_n_r + 1.0*i_vsc_R10_c_r*v_R10_c_i - 1.0*i_vsc_R10_c_r*v_R10_n_i
        struct[0].g[401,0] = i_vsc_D10_a_r + p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].g[402,0] = i_vsc_D10_n_r + p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].g[403,0] = p_D10 - p_R10 + Piecewise(np.array([(a_R10 + b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), p_D10 < 0), (-a_R10 - b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), p_D10 > 0), (a_R10 + b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), True)]))
        struct[0].g[404,0] = -coef_a_R14*p_R14 + 1.0*i_vsc_R14_a_i*v_R14_a_i - 1.0*i_vsc_R14_a_i*v_R14_n_i + i_vsc_R14_a_r*v_R14_a_r - i_vsc_R14_a_r*v_R14_n_r
        struct[0].g[405,0] = -coef_a_R14*q_R14 - 1.0*i_vsc_R14_a_i*v_R14_a_r + 1.0*i_vsc_R14_a_i*v_R14_n_r + 1.0*i_vsc_R14_a_r*v_R14_a_i - 1.0*i_vsc_R14_a_r*v_R14_n_i
        struct[0].g[406,0] = -coef_b_R14*p_R14 + 1.0*i_vsc_R14_b_i*v_R14_b_i - 1.0*i_vsc_R14_b_i*v_R14_n_i + i_vsc_R14_b_r*v_R14_b_r - i_vsc_R14_b_r*v_R14_n_r
        struct[0].g[407,0] = -coef_b_R14*q_R14 - 1.0*i_vsc_R14_b_i*v_R14_b_r + 1.0*i_vsc_R14_b_i*v_R14_n_r + 1.0*i_vsc_R14_b_r*v_R14_b_i - 1.0*i_vsc_R14_b_r*v_R14_n_i
        struct[0].g[408,0] = -coef_c_R14*p_R14 + 1.0*i_vsc_R14_c_i*v_R14_c_i - 1.0*i_vsc_R14_c_i*v_R14_n_i + i_vsc_R14_c_r*v_R14_c_r - i_vsc_R14_c_r*v_R14_n_r
        struct[0].g[409,0] = -coef_c_R14*q_R14 - 1.0*i_vsc_R14_c_i*v_R14_c_r + 1.0*i_vsc_R14_c_i*v_R14_n_r + 1.0*i_vsc_R14_c_r*v_R14_c_i - 1.0*i_vsc_R14_c_r*v_R14_n_i
        struct[0].g[412,0] = i_vsc_D14_a_r + p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].g[413,0] = i_vsc_D14_n_r + p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].g[414,0] = p_D14 - p_R14 + Piecewise(np.array([(a_R14 + b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), p_D14 < 0), (-a_R14 - b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), p_D14 > 0), (a_R14 + b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), True)]))
    
    # Outputs:
    if mode == 3:

        struct[0].h[0,0] = (v_R0_a_i**2 + v_R0_a_r**2)**0.5
        struct[0].h[1,0] = (v_R0_b_i**2 + v_R0_b_r**2)**0.5
        struct[0].h[2,0] = (v_R0_c_i**2 + v_R0_c_r**2)**0.5
        struct[0].h[3,0] = (v_D1_a_i**2 + v_D1_a_r**2)**0.5
        struct[0].h[4,0] = (v_D1_b_i**2 + v_D1_b_r**2)**0.5
        struct[0].h[5,0] = (v_D1_c_i**2 + v_D1_c_r**2)**0.5
        struct[0].h[6,0] = (v_R1_a_i**2 + v_R1_a_r**2)**0.5
        struct[0].h[7,0] = (v_R1_b_i**2 + v_R1_b_r**2)**0.5
        struct[0].h[8,0] = (v_R1_c_i**2 + v_R1_c_r**2)**0.5
        struct[0].h[9,0] = (v_R1_n_i**2 + v_R1_n_r**2)**0.5
        struct[0].h[10,0] = (v_R11_a_i**2 + v_R11_a_r**2)**0.5
        struct[0].h[11,0] = (v_R11_n_i**2 + v_R11_n_r**2)**0.5
        struct[0].h[12,0] = (v_R15_a_i**2 + v_R15_a_r**2)**0.5
        struct[0].h[13,0] = (v_R15_n_i**2 + v_R15_n_r**2)**0.5
        struct[0].h[14,0] = (v_R16_a_i**2 + v_R16_a_r**2)**0.5
        struct[0].h[15,0] = (v_R16_n_i**2 + v_R16_n_r**2)**0.5
        struct[0].h[16,0] = (v_R17_a_i**2 + v_R17_a_r**2)**0.5
        struct[0].h[17,0] = (v_R17_n_i**2 + v_R17_n_r**2)**0.5
        struct[0].h[18,0] = (v_R18_a_i**2 + v_R18_a_r**2)**0.5
        struct[0].h[19,0] = (v_R18_n_i**2 + v_R18_n_r**2)**0.5
        struct[0].h[20,0] = (v_D15_a_i**2 + v_D15_a_r**2)**0.5
        struct[0].h[21,0] = (v_D15_n_i**2 + v_D15_n_r**2)**0.5
        struct[0].h[22,0] = (v_D11_a_i**2 + v_D11_a_r**2)**0.5
        struct[0].h[23,0] = (v_D11_n_i**2 + v_D11_n_r**2)**0.5
        struct[0].h[24,0] = (v_D16_a_i**2 + v_D16_a_r**2)**0.5
        struct[0].h[25,0] = (v_D16_n_i**2 + v_D16_n_r**2)**0.5
        struct[0].h[26,0] = (v_D17_a_i**2 + v_D17_a_r**2)**0.5
        struct[0].h[27,0] = (v_D17_n_i**2 + v_D17_n_r**2)**0.5
        struct[0].h[28,0] = (v_D18_a_i**2 + v_D18_a_r**2)**0.5
        struct[0].h[29,0] = (v_D18_n_i**2 + v_D18_n_r**2)**0.5
        struct[0].h[30,0] = (v_R2_a_i**2 + v_R2_a_r**2)**0.5
        struct[0].h[31,0] = (v_R2_b_i**2 + v_R2_b_r**2)**0.5
        struct[0].h[32,0] = (v_R2_c_i**2 + v_R2_c_r**2)**0.5
        struct[0].h[33,0] = (v_R2_n_i**2 + v_R2_n_r**2)**0.5
        struct[0].h[34,0] = (v_R3_a_i**2 + v_R3_a_r**2)**0.5
        struct[0].h[35,0] = (v_R3_b_i**2 + v_R3_b_r**2)**0.5
        struct[0].h[36,0] = (v_R3_c_i**2 + v_R3_c_r**2)**0.5
        struct[0].h[37,0] = (v_R3_n_i**2 + v_R3_n_r**2)**0.5
        struct[0].h[38,0] = (v_R4_a_i**2 + v_R4_a_r**2)**0.5
        struct[0].h[39,0] = (v_R4_b_i**2 + v_R4_b_r**2)**0.5
        struct[0].h[40,0] = (v_R4_c_i**2 + v_R4_c_r**2)**0.5
        struct[0].h[41,0] = (v_R4_n_i**2 + v_R4_n_r**2)**0.5
        struct[0].h[42,0] = (v_R5_a_i**2 + v_R5_a_r**2)**0.5
        struct[0].h[43,0] = (v_R5_b_i**2 + v_R5_b_r**2)**0.5
        struct[0].h[44,0] = (v_R5_c_i**2 + v_R5_c_r**2)**0.5
        struct[0].h[45,0] = (v_R5_n_i**2 + v_R5_n_r**2)**0.5
        struct[0].h[46,0] = (v_R6_a_i**2 + v_R6_a_r**2)**0.5
        struct[0].h[47,0] = (v_R6_b_i**2 + v_R6_b_r**2)**0.5
        struct[0].h[48,0] = (v_R6_c_i**2 + v_R6_c_r**2)**0.5
        struct[0].h[49,0] = (v_R6_n_i**2 + v_R6_n_r**2)**0.5
        struct[0].h[50,0] = (v_R7_a_i**2 + v_R7_a_r**2)**0.5
        struct[0].h[51,0] = (v_R7_b_i**2 + v_R7_b_r**2)**0.5
        struct[0].h[52,0] = (v_R7_c_i**2 + v_R7_c_r**2)**0.5
        struct[0].h[53,0] = (v_R7_n_i**2 + v_R7_n_r**2)**0.5
        struct[0].h[54,0] = (v_R8_a_i**2 + v_R8_a_r**2)**0.5
        struct[0].h[55,0] = (v_R8_b_i**2 + v_R8_b_r**2)**0.5
        struct[0].h[56,0] = (v_R8_c_i**2 + v_R8_c_r**2)**0.5
        struct[0].h[57,0] = (v_R8_n_i**2 + v_R8_n_r**2)**0.5
        struct[0].h[58,0] = (v_R9_a_i**2 + v_R9_a_r**2)**0.5
        struct[0].h[59,0] = (v_R9_b_i**2 + v_R9_b_r**2)**0.5
        struct[0].h[60,0] = (v_R9_c_i**2 + v_R9_c_r**2)**0.5
        struct[0].h[61,0] = (v_R9_n_i**2 + v_R9_n_r**2)**0.5
        struct[0].h[62,0] = (v_R10_a_i**2 + v_R10_a_r**2)**0.5
        struct[0].h[63,0] = (v_R10_b_i**2 + v_R10_b_r**2)**0.5
        struct[0].h[64,0] = (v_R10_c_i**2 + v_R10_c_r**2)**0.5
        struct[0].h[65,0] = (v_R10_n_i**2 + v_R10_n_r**2)**0.5
        struct[0].h[66,0] = (v_R11_b_i**2 + v_R11_b_r**2)**0.5
        struct[0].h[67,0] = (v_R11_c_i**2 + v_R11_c_r**2)**0.5
        struct[0].h[68,0] = (v_R12_a_i**2 + v_R12_a_r**2)**0.5
        struct[0].h[69,0] = (v_R12_b_i**2 + v_R12_b_r**2)**0.5
        struct[0].h[70,0] = (v_R12_c_i**2 + v_R12_c_r**2)**0.5
        struct[0].h[71,0] = (v_R12_n_i**2 + v_R12_n_r**2)**0.5
        struct[0].h[72,0] = (v_R13_a_i**2 + v_R13_a_r**2)**0.5
        struct[0].h[73,0] = (v_R13_b_i**2 + v_R13_b_r**2)**0.5
        struct[0].h[74,0] = (v_R13_c_i**2 + v_R13_c_r**2)**0.5
        struct[0].h[75,0] = (v_R13_n_i**2 + v_R13_n_r**2)**0.5
        struct[0].h[76,0] = (v_R14_a_i**2 + v_R14_a_r**2)**0.5
        struct[0].h[77,0] = (v_R14_b_i**2 + v_R14_b_r**2)**0.5
        struct[0].h[78,0] = (v_R14_c_i**2 + v_R14_c_r**2)**0.5
        struct[0].h[79,0] = (v_R14_n_i**2 + v_R14_n_r**2)**0.5
        struct[0].h[80,0] = (v_R15_b_i**2 + v_R15_b_r**2)**0.5
        struct[0].h[81,0] = (v_R15_c_i**2 + v_R15_c_r**2)**0.5
        struct[0].h[82,0] = (v_R16_b_i**2 + v_R16_b_r**2)**0.5
        struct[0].h[83,0] = (v_R16_c_i**2 + v_R16_c_r**2)**0.5
        struct[0].h[84,0] = (v_R17_b_i**2 + v_R17_b_r**2)**0.5
        struct[0].h[85,0] = (v_R17_c_i**2 + v_R17_c_r**2)**0.5
        struct[0].h[86,0] = (v_R18_b_i**2 + v_R18_b_r**2)**0.5
        struct[0].h[87,0] = (v_R18_c_i**2 + v_R18_c_r**2)**0.5
        struct[0].h[88,0] = (v_D1_n_i**2 + v_D1_n_r**2)**0.5
        struct[0].h[89,0] = (v_D3_a_i**2 + v_D3_a_r**2)**0.5
        struct[0].h[90,0] = (v_D3_b_i**2 + v_D3_b_r**2)**0.5
        struct[0].h[91,0] = (v_D3_c_i**2 + v_D3_c_r**2)**0.5
        struct[0].h[92,0] = (v_D3_n_i**2 + v_D3_n_r**2)**0.5
        struct[0].h[93,0] = (v_D4_a_i**2 + v_D4_a_r**2)**0.5
        struct[0].h[94,0] = (v_D4_b_i**2 + v_D4_b_r**2)**0.5
        struct[0].h[95,0] = (v_D4_c_i**2 + v_D4_c_r**2)**0.5
        struct[0].h[96,0] = (v_D4_n_i**2 + v_D4_n_r**2)**0.5
        struct[0].h[97,0] = (v_D6_a_i**2 + v_D6_a_r**2)**0.5
        struct[0].h[98,0] = (v_D6_b_i**2 + v_D6_b_r**2)**0.5
        struct[0].h[99,0] = (v_D6_c_i**2 + v_D6_c_r**2)**0.5
        struct[0].h[100,0] = (v_D6_n_i**2 + v_D6_n_r**2)**0.5
        struct[0].h[101,0] = (v_D9_a_i**2 + v_D9_a_r**2)**0.5
        struct[0].h[102,0] = (v_D9_b_i**2 + v_D9_b_r**2)**0.5
        struct[0].h[103,0] = (v_D9_c_i**2 + v_D9_c_r**2)**0.5
        struct[0].h[104,0] = (v_D9_n_i**2 + v_D9_n_r**2)**0.5
        struct[0].h[105,0] = (v_D10_a_i**2 + v_D10_a_r**2)**0.5
        struct[0].h[106,0] = (v_D10_b_i**2 + v_D10_b_r**2)**0.5
        struct[0].h[107,0] = (v_D10_c_i**2 + v_D10_c_r**2)**0.5
        struct[0].h[108,0] = (v_D10_n_i**2 + v_D10_n_r**2)**0.5
        struct[0].h[109,0] = (v_D11_b_i**2 + v_D11_b_r**2)**0.5
        struct[0].h[110,0] = (v_D11_c_i**2 + v_D11_c_r**2)**0.5
        struct[0].h[111,0] = (v_D16_b_i**2 + v_D16_b_r**2)**0.5
        struct[0].h[112,0] = (v_D16_c_i**2 + v_D16_c_r**2)**0.5
        struct[0].h[113,0] = (v_D17_b_i**2 + v_D17_b_r**2)**0.5
        struct[0].h[114,0] = (v_D17_c_i**2 + v_D17_c_r**2)**0.5
        struct[0].h[115,0] = (v_D18_b_i**2 + v_D18_b_r**2)**0.5
        struct[0].h[116,0] = (v_D18_c_i**2 + v_D18_c_r**2)**0.5
        struct[0].h[117,0] = (v_D14_a_i**2 + v_D14_a_r**2)**0.5
        struct[0].h[118,0] = (v_D14_b_i**2 + v_D14_b_r**2)**0.5
        struct[0].h[119,0] = (v_D14_c_i**2 + v_D14_c_r**2)**0.5
        struct[0].h[120,0] = (v_D14_n_i**2 + v_D14_n_r**2)**0.5
        struct[0].h[121,0] = (v_D15_b_i**2 + v_D15_b_r**2)**0.5
        struct[0].h[122,0] = (v_D15_c_i**2 + v_D15_c_r**2)**0.5
    

    if mode == 10:

        pass

    if mode == 11:



        struct[0].Gy_ini[336,0] = i_load_R1_a_r
        struct[0].Gy_ini[336,1] = i_load_R1_a_i
        struct[0].Gy_ini[336,6] = -i_load_R1_a_r
        struct[0].Gy_ini[336,7] = -i_load_R1_a_i
        struct[0].Gy_ini[336,336] = v_R1_a_r - v_R1_n_r
        struct[0].Gy_ini[336,337] = v_R1_a_i - v_R1_n_i
        struct[0].Gy_ini[337,2] = i_load_R1_b_r
        struct[0].Gy_ini[337,3] = i_load_R1_b_i
        struct[0].Gy_ini[337,6] = -i_load_R1_b_r
        struct[0].Gy_ini[337,7] = -i_load_R1_b_i
        struct[0].Gy_ini[337,338] = v_R1_b_r - v_R1_n_r
        struct[0].Gy_ini[337,339] = v_R1_b_i - v_R1_n_i
        struct[0].Gy_ini[338,4] = i_load_R1_c_r
        struct[0].Gy_ini[338,5] = i_load_R1_c_i
        struct[0].Gy_ini[338,6] = -i_load_R1_c_r
        struct[0].Gy_ini[338,7] = -i_load_R1_c_i
        struct[0].Gy_ini[338,340] = v_R1_c_r - v_R1_n_r
        struct[0].Gy_ini[338,341] = v_R1_c_i - v_R1_n_i
        struct[0].Gy_ini[339,0] = -i_load_R1_a_i
        struct[0].Gy_ini[339,1] = i_load_R1_a_r
        struct[0].Gy_ini[339,6] = i_load_R1_a_i
        struct[0].Gy_ini[339,7] = -i_load_R1_a_r
        struct[0].Gy_ini[339,336] = v_R1_a_i - v_R1_n_i
        struct[0].Gy_ini[339,337] = -v_R1_a_r + v_R1_n_r
        struct[0].Gy_ini[340,2] = -i_load_R1_b_i
        struct[0].Gy_ini[340,3] = i_load_R1_b_r
        struct[0].Gy_ini[340,6] = i_load_R1_b_i
        struct[0].Gy_ini[340,7] = -i_load_R1_b_r
        struct[0].Gy_ini[340,338] = v_R1_b_i - v_R1_n_i
        struct[0].Gy_ini[340,339] = -v_R1_b_r + v_R1_n_r
        struct[0].Gy_ini[341,4] = -i_load_R1_c_i
        struct[0].Gy_ini[341,5] = i_load_R1_c_r
        struct[0].Gy_ini[341,6] = i_load_R1_c_i
        struct[0].Gy_ini[341,7] = -i_load_R1_c_r
        struct[0].Gy_ini[341,340] = v_R1_c_i - v_R1_n_i
        struct[0].Gy_ini[341,341] = -v_R1_c_r + v_R1_n_r
        struct[0].Gy_ini[344,8] = i_load_R11_a_r
        struct[0].Gy_ini[344,9] = 1.0*i_load_R11_a_i
        struct[0].Gy_ini[344,10] = -i_load_R11_a_r
        struct[0].Gy_ini[344,11] = -1.0*i_load_R11_a_i
        struct[0].Gy_ini[344,344] = v_R11_a_r - v_R11_n_r
        struct[0].Gy_ini[344,345] = 1.0*v_R11_a_i - 1.0*v_R11_n_i
        struct[0].Gy_ini[345,8] = -1.0*i_load_R11_a_i
        struct[0].Gy_ini[345,9] = 1.0*i_load_R11_a_r
        struct[0].Gy_ini[345,10] = 1.0*i_load_R11_a_i
        struct[0].Gy_ini[345,11] = -1.0*i_load_R11_a_r
        struct[0].Gy_ini[345,344] = 1.0*v_R11_a_i - 1.0*v_R11_n_i
        struct[0].Gy_ini[345,345] = -1.0*v_R11_a_r + 1.0*v_R11_n_r
        struct[0].Gy_ini[348,12] = i_load_R15_a_r
        struct[0].Gy_ini[348,13] = 1.0*i_load_R15_a_i
        struct[0].Gy_ini[348,14] = -i_load_R15_a_r
        struct[0].Gy_ini[348,15] = -1.0*i_load_R15_a_i
        struct[0].Gy_ini[348,348] = v_R15_a_r - v_R15_n_r
        struct[0].Gy_ini[348,349] = 1.0*v_R15_a_i - 1.0*v_R15_n_i
        struct[0].Gy_ini[349,12] = -1.0*i_load_R15_a_i
        struct[0].Gy_ini[349,13] = 1.0*i_load_R15_a_r
        struct[0].Gy_ini[349,14] = 1.0*i_load_R15_a_i
        struct[0].Gy_ini[349,15] = -1.0*i_load_R15_a_r
        struct[0].Gy_ini[349,348] = 1.0*v_R15_a_i - 1.0*v_R15_n_i
        struct[0].Gy_ini[349,349] = -1.0*v_R15_a_r + 1.0*v_R15_n_r
        struct[0].Gy_ini[352,16] = i_load_R16_a_r
        struct[0].Gy_ini[352,17] = 1.0*i_load_R16_a_i
        struct[0].Gy_ini[352,18] = -i_load_R16_a_r
        struct[0].Gy_ini[352,19] = -1.0*i_load_R16_a_i
        struct[0].Gy_ini[352,352] = v_R16_a_r - v_R16_n_r
        struct[0].Gy_ini[352,353] = 1.0*v_R16_a_i - 1.0*v_R16_n_i
        struct[0].Gy_ini[353,16] = -1.0*i_load_R16_a_i
        struct[0].Gy_ini[353,17] = 1.0*i_load_R16_a_r
        struct[0].Gy_ini[353,18] = 1.0*i_load_R16_a_i
        struct[0].Gy_ini[353,19] = -1.0*i_load_R16_a_r
        struct[0].Gy_ini[353,352] = 1.0*v_R16_a_i - 1.0*v_R16_n_i
        struct[0].Gy_ini[353,353] = -1.0*v_R16_a_r + 1.0*v_R16_n_r
        struct[0].Gy_ini[356,20] = i_load_R17_a_r
        struct[0].Gy_ini[356,21] = 1.0*i_load_R17_a_i
        struct[0].Gy_ini[356,22] = -i_load_R17_a_r
        struct[0].Gy_ini[356,23] = -1.0*i_load_R17_a_i
        struct[0].Gy_ini[356,356] = v_R17_a_r - v_R17_n_r
        struct[0].Gy_ini[356,357] = 1.0*v_R17_a_i - 1.0*v_R17_n_i
        struct[0].Gy_ini[357,20] = -1.0*i_load_R17_a_i
        struct[0].Gy_ini[357,21] = 1.0*i_load_R17_a_r
        struct[0].Gy_ini[357,22] = 1.0*i_load_R17_a_i
        struct[0].Gy_ini[357,23] = -1.0*i_load_R17_a_r
        struct[0].Gy_ini[357,356] = 1.0*v_R17_a_i - 1.0*v_R17_n_i
        struct[0].Gy_ini[357,357] = -1.0*v_R17_a_r + 1.0*v_R17_n_r
        struct[0].Gy_ini[360,24] = i_load_R18_a_r
        struct[0].Gy_ini[360,25] = 1.0*i_load_R18_a_i
        struct[0].Gy_ini[360,26] = -i_load_R18_a_r
        struct[0].Gy_ini[360,27] = -1.0*i_load_R18_a_i
        struct[0].Gy_ini[360,360] = v_R18_a_r - v_R18_n_r
        struct[0].Gy_ini[360,361] = 1.0*v_R18_a_i - 1.0*v_R18_n_i
        struct[0].Gy_ini[361,24] = -1.0*i_load_R18_a_i
        struct[0].Gy_ini[361,25] = 1.0*i_load_R18_a_r
        struct[0].Gy_ini[361,26] = 1.0*i_load_R18_a_i
        struct[0].Gy_ini[361,27] = -1.0*i_load_R18_a_r
        struct[0].Gy_ini[361,360] = 1.0*v_R18_a_i - 1.0*v_R18_n_i
        struct[0].Gy_ini[361,361] = -1.0*v_R18_a_r + 1.0*v_R18_n_r
        struct[0].Gy_ini[364,28] = i_load_D15_a_r
        struct[0].Gy_ini[364,29] = 1.0*i_load_D15_a_i
        struct[0].Gy_ini[364,30] = -i_load_D15_a_r
        struct[0].Gy_ini[364,31] = -1.0*i_load_D15_a_i
        struct[0].Gy_ini[364,364] = v_D15_a_r - v_D15_n_r
        struct[0].Gy_ini[364,365] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy_ini[365,28] = -1.0*i_load_D15_a_i
        struct[0].Gy_ini[365,29] = 1.0*i_load_D15_a_r
        struct[0].Gy_ini[365,30] = 1.0*i_load_D15_a_i
        struct[0].Gy_ini[365,31] = -1.0*i_load_D15_a_r
        struct[0].Gy_ini[365,364] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy_ini[365,365] = -1.0*v_D15_a_r + 1.0*v_D15_n_r
        struct[0].Gy_ini[368,32] = i_load_D11_a_r
        struct[0].Gy_ini[368,33] = 1.0*i_load_D11_a_i
        struct[0].Gy_ini[368,34] = -i_load_D11_a_r
        struct[0].Gy_ini[368,35] = -1.0*i_load_D11_a_i
        struct[0].Gy_ini[368,368] = v_D11_a_r - v_D11_n_r
        struct[0].Gy_ini[368,369] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy_ini[369,32] = -1.0*i_load_D11_a_i
        struct[0].Gy_ini[369,33] = 1.0*i_load_D11_a_r
        struct[0].Gy_ini[369,34] = 1.0*i_load_D11_a_i
        struct[0].Gy_ini[369,35] = -1.0*i_load_D11_a_r
        struct[0].Gy_ini[369,368] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy_ini[369,369] = -1.0*v_D11_a_r + 1.0*v_D11_n_r
        struct[0].Gy_ini[372,36] = i_load_D16_a_r
        struct[0].Gy_ini[372,37] = 1.0*i_load_D16_a_i
        struct[0].Gy_ini[372,38] = -i_load_D16_a_r
        struct[0].Gy_ini[372,39] = -1.0*i_load_D16_a_i
        struct[0].Gy_ini[372,372] = v_D16_a_r - v_D16_n_r
        struct[0].Gy_ini[372,373] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy_ini[373,36] = -1.0*i_load_D16_a_i
        struct[0].Gy_ini[373,37] = 1.0*i_load_D16_a_r
        struct[0].Gy_ini[373,38] = 1.0*i_load_D16_a_i
        struct[0].Gy_ini[373,39] = -1.0*i_load_D16_a_r
        struct[0].Gy_ini[373,372] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy_ini[373,373] = -1.0*v_D16_a_r + 1.0*v_D16_n_r
        struct[0].Gy_ini[376,40] = i_load_D17_a_r
        struct[0].Gy_ini[376,41] = 1.0*i_load_D17_a_i
        struct[0].Gy_ini[376,42] = -i_load_D17_a_r
        struct[0].Gy_ini[376,43] = -1.0*i_load_D17_a_i
        struct[0].Gy_ini[376,376] = v_D17_a_r - v_D17_n_r
        struct[0].Gy_ini[376,377] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy_ini[377,40] = -1.0*i_load_D17_a_i
        struct[0].Gy_ini[377,41] = 1.0*i_load_D17_a_r
        struct[0].Gy_ini[377,42] = 1.0*i_load_D17_a_i
        struct[0].Gy_ini[377,43] = -1.0*i_load_D17_a_r
        struct[0].Gy_ini[377,376] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy_ini[377,377] = -1.0*v_D17_a_r + 1.0*v_D17_n_r
        struct[0].Gy_ini[380,44] = i_load_D18_a_r
        struct[0].Gy_ini[380,45] = 1.0*i_load_D18_a_i
        struct[0].Gy_ini[380,46] = -i_load_D18_a_r
        struct[0].Gy_ini[380,47] = -1.0*i_load_D18_a_i
        struct[0].Gy_ini[380,380] = v_D18_a_r - v_D18_n_r
        struct[0].Gy_ini[380,381] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy_ini[381,44] = -1.0*i_load_D18_a_i
        struct[0].Gy_ini[381,45] = 1.0*i_load_D18_a_r
        struct[0].Gy_ini[381,46] = 1.0*i_load_D18_a_i
        struct[0].Gy_ini[381,47] = -1.0*i_load_D18_a_r
        struct[0].Gy_ini[381,380] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy_ini[381,381] = -1.0*v_D18_a_r + 1.0*v_D18_n_r
        struct[0].Gy_ini[384,0] = i_vsc_R1_a_r
        struct[0].Gy_ini[384,1] = 1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[384,6] = -i_vsc_R1_a_r
        struct[0].Gy_ini[384,7] = -1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[384,384] = v_R1_a_r - v_R1_n_r
        struct[0].Gy_ini[384,385] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[385,0] = -1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[385,1] = 1.0*i_vsc_R1_a_r
        struct[0].Gy_ini[385,6] = 1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[385,7] = -1.0*i_vsc_R1_a_r
        struct[0].Gy_ini[385,384] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[385,385] = -1.0*v_R1_a_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[386,2] = i_vsc_R1_b_r
        struct[0].Gy_ini[386,3] = 1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[386,6] = -i_vsc_R1_b_r
        struct[0].Gy_ini[386,7] = -1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[386,386] = v_R1_b_r - v_R1_n_r
        struct[0].Gy_ini[386,387] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[387,2] = -1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[387,3] = 1.0*i_vsc_R1_b_r
        struct[0].Gy_ini[387,6] = 1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[387,7] = -1.0*i_vsc_R1_b_r
        struct[0].Gy_ini[387,386] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[387,387] = -1.0*v_R1_b_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[388,4] = i_vsc_R1_c_r
        struct[0].Gy_ini[388,5] = 1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[388,6] = -i_vsc_R1_c_r
        struct[0].Gy_ini[388,7] = -1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[388,388] = v_R1_c_r - v_R1_n_r
        struct[0].Gy_ini[388,389] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[389,4] = -1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[389,5] = 1.0*i_vsc_R1_c_r
        struct[0].Gy_ini[389,6] = 1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[389,7] = -1.0*i_vsc_R1_c_r
        struct[0].Gy_ini[389,388] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[389,389] = -1.0*v_R1_c_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[390,392] = Piecewise(np.array([(-1, p_D1 < 0), (1, True)]))
        struct[0].Gy_ini[391,248] = v_D1_a_r
        struct[0].Gy_ini[391,254] = v_D1_n_r
        struct[0].Gy_ini[392,384] = -b_R1*i_vsc_R1_a_r/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_r
        struct[0].Gy_ini[392,385] = -b_R1*i_vsc_R1_a_i/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_i
        struct[0].Gy_ini[393,112] = i_vsc_R10_a_r
        struct[0].Gy_ini[393,113] = 1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[393,118] = -i_vsc_R10_a_r
        struct[0].Gy_ini[393,119] = -1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[393,393] = v_R10_a_r - v_R10_n_r
        struct[0].Gy_ini[393,394] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[394,112] = -1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[394,113] = 1.0*i_vsc_R10_a_r
        struct[0].Gy_ini[394,118] = 1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[394,119] = -1.0*i_vsc_R10_a_r
        struct[0].Gy_ini[394,393] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[394,394] = -1.0*v_R10_a_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[395,114] = i_vsc_R10_b_r
        struct[0].Gy_ini[395,115] = 1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[395,118] = -i_vsc_R10_b_r
        struct[0].Gy_ini[395,119] = -1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[395,395] = v_R10_b_r - v_R10_n_r
        struct[0].Gy_ini[395,396] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[396,114] = -1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[396,115] = 1.0*i_vsc_R10_b_r
        struct[0].Gy_ini[396,118] = 1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[396,119] = -1.0*i_vsc_R10_b_r
        struct[0].Gy_ini[396,395] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[396,396] = -1.0*v_R10_b_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[397,116] = i_vsc_R10_c_r
        struct[0].Gy_ini[397,117] = 1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[397,118] = -i_vsc_R10_c_r
        struct[0].Gy_ini[397,119] = -1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[397,397] = v_R10_c_r - v_R10_n_r
        struct[0].Gy_ini[397,398] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[398,116] = -1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[398,117] = 1.0*i_vsc_R10_c_r
        struct[0].Gy_ini[398,118] = 1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[398,119] = -1.0*i_vsc_R10_c_r
        struct[0].Gy_ini[398,397] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[398,398] = -1.0*v_R10_c_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[401,198] = -p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[401,204] = p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[401,403] = 1/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].Gy_ini[402,198] = p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[402,204] = -p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[402,403] = 1/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].Gy_ini[403,393] = Piecewise(np.array([(b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_r, p_D10 < 0), (-b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_r, p_D10 > 0), (b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_r, True)]))
        struct[0].Gy_ini[403,394] = Piecewise(np.array([(b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_i, p_D10 < 0), (-b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_i, p_D10 > 0), (b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_i, True)]))
        struct[0].Gy_ini[404,140] = i_vsc_R14_a_r
        struct[0].Gy_ini[404,141] = 1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[404,146] = -i_vsc_R14_a_r
        struct[0].Gy_ini[404,147] = -1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[404,404] = v_R14_a_r - v_R14_n_r
        struct[0].Gy_ini[404,405] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[405,140] = -1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[405,141] = 1.0*i_vsc_R14_a_r
        struct[0].Gy_ini[405,146] = 1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[405,147] = -1.0*i_vsc_R14_a_r
        struct[0].Gy_ini[405,404] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[405,405] = -1.0*v_R14_a_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[406,142] = i_vsc_R14_b_r
        struct[0].Gy_ini[406,143] = 1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[406,146] = -i_vsc_R14_b_r
        struct[0].Gy_ini[406,147] = -1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[406,406] = v_R14_b_r - v_R14_n_r
        struct[0].Gy_ini[406,407] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[407,142] = -1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[407,143] = 1.0*i_vsc_R14_b_r
        struct[0].Gy_ini[407,146] = 1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[407,147] = -1.0*i_vsc_R14_b_r
        struct[0].Gy_ini[407,406] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[407,407] = -1.0*v_R14_b_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[408,144] = i_vsc_R14_c_r
        struct[0].Gy_ini[408,145] = 1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[408,146] = -i_vsc_R14_c_r
        struct[0].Gy_ini[408,147] = -1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[408,408] = v_R14_c_r - v_R14_n_r
        struct[0].Gy_ini[408,409] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[409,144] = -1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[409,145] = 1.0*i_vsc_R14_c_r
        struct[0].Gy_ini[409,146] = 1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[409,147] = -1.0*i_vsc_R14_c_r
        struct[0].Gy_ini[409,408] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[409,409] = -1.0*v_R14_c_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[412,222] = -p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[412,228] = p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[412,414] = 1/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].Gy_ini[413,222] = p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[413,228] = -p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[413,414] = 1/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].Gy_ini[414,404] = Piecewise(np.array([(b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_r, p_D14 < 0), (-b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_r, p_D14 > 0), (b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_r, True)]))
        struct[0].Gy_ini[414,405] = Piecewise(np.array([(b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_i, p_D14 < 0), (-b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_i, p_D14 > 0), (b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_i, True)]))



@numba.njit(cache=True)
def run(t,struct,mode):

    # Parameters:
    a_R1 = struct[0].a_R1
    b_R1 = struct[0].b_R1
    c_R1 = struct[0].c_R1
    a_R10 = struct[0].a_R10
    b_R10 = struct[0].b_R10
    c_R10 = struct[0].c_R10
    coef_a_R10 = struct[0].coef_a_R10
    coef_b_R10 = struct[0].coef_b_R10
    coef_c_R10 = struct[0].coef_c_R10
    a_R14 = struct[0].a_R14
    b_R14 = struct[0].b_R14
    c_R14 = struct[0].c_R14
    coef_a_R14 = struct[0].coef_a_R14
    coef_b_R14 = struct[0].coef_b_R14
    coef_c_R14 = struct[0].coef_c_R14
    
    # Inputs:
    v_R0_a_r = struct[0].v_R0_a_r
    v_R0_a_i = struct[0].v_R0_a_i
    v_R0_b_r = struct[0].v_R0_b_r
    v_R0_b_i = struct[0].v_R0_b_i
    v_R0_c_r = struct[0].v_R0_c_r
    v_R0_c_i = struct[0].v_R0_c_i
    v_D1_a_r = struct[0].v_D1_a_r
    v_D1_a_i = struct[0].v_D1_a_i
    v_D1_b_r = struct[0].v_D1_b_r
    v_D1_b_i = struct[0].v_D1_b_i
    v_D1_c_r = struct[0].v_D1_c_r
    v_D1_c_i = struct[0].v_D1_c_i
    i_R1_n_r = struct[0].i_R1_n_r
    i_R1_n_i = struct[0].i_R1_n_i
    i_R2_a_r = struct[0].i_R2_a_r
    i_R2_a_i = struct[0].i_R2_a_i
    i_R2_b_r = struct[0].i_R2_b_r
    i_R2_b_i = struct[0].i_R2_b_i
    i_R2_c_r = struct[0].i_R2_c_r
    i_R2_c_i = struct[0].i_R2_c_i
    i_R2_n_r = struct[0].i_R2_n_r
    i_R2_n_i = struct[0].i_R2_n_i
    i_R3_a_r = struct[0].i_R3_a_r
    i_R3_a_i = struct[0].i_R3_a_i
    i_R3_b_r = struct[0].i_R3_b_r
    i_R3_b_i = struct[0].i_R3_b_i
    i_R3_c_r = struct[0].i_R3_c_r
    i_R3_c_i = struct[0].i_R3_c_i
    i_R3_n_r = struct[0].i_R3_n_r
    i_R3_n_i = struct[0].i_R3_n_i
    i_R4_a_r = struct[0].i_R4_a_r
    i_R4_a_i = struct[0].i_R4_a_i
    i_R4_b_r = struct[0].i_R4_b_r
    i_R4_b_i = struct[0].i_R4_b_i
    i_R4_c_r = struct[0].i_R4_c_r
    i_R4_c_i = struct[0].i_R4_c_i
    i_R4_n_r = struct[0].i_R4_n_r
    i_R4_n_i = struct[0].i_R4_n_i
    i_R5_a_r = struct[0].i_R5_a_r
    i_R5_a_i = struct[0].i_R5_a_i
    i_R5_b_r = struct[0].i_R5_b_r
    i_R5_b_i = struct[0].i_R5_b_i
    i_R5_c_r = struct[0].i_R5_c_r
    i_R5_c_i = struct[0].i_R5_c_i
    i_R5_n_r = struct[0].i_R5_n_r
    i_R5_n_i = struct[0].i_R5_n_i
    i_R6_a_r = struct[0].i_R6_a_r
    i_R6_a_i = struct[0].i_R6_a_i
    i_R6_b_r = struct[0].i_R6_b_r
    i_R6_b_i = struct[0].i_R6_b_i
    i_R6_c_r = struct[0].i_R6_c_r
    i_R6_c_i = struct[0].i_R6_c_i
    i_R6_n_r = struct[0].i_R6_n_r
    i_R6_n_i = struct[0].i_R6_n_i
    i_R7_a_r = struct[0].i_R7_a_r
    i_R7_a_i = struct[0].i_R7_a_i
    i_R7_b_r = struct[0].i_R7_b_r
    i_R7_b_i = struct[0].i_R7_b_i
    i_R7_c_r = struct[0].i_R7_c_r
    i_R7_c_i = struct[0].i_R7_c_i
    i_R7_n_r = struct[0].i_R7_n_r
    i_R7_n_i = struct[0].i_R7_n_i
    i_R8_a_r = struct[0].i_R8_a_r
    i_R8_a_i = struct[0].i_R8_a_i
    i_R8_b_r = struct[0].i_R8_b_r
    i_R8_b_i = struct[0].i_R8_b_i
    i_R8_c_r = struct[0].i_R8_c_r
    i_R8_c_i = struct[0].i_R8_c_i
    i_R8_n_r = struct[0].i_R8_n_r
    i_R8_n_i = struct[0].i_R8_n_i
    i_R9_a_r = struct[0].i_R9_a_r
    i_R9_a_i = struct[0].i_R9_a_i
    i_R9_b_r = struct[0].i_R9_b_r
    i_R9_b_i = struct[0].i_R9_b_i
    i_R9_c_r = struct[0].i_R9_c_r
    i_R9_c_i = struct[0].i_R9_c_i
    i_R9_n_r = struct[0].i_R9_n_r
    i_R9_n_i = struct[0].i_R9_n_i
    i_R10_a_r = struct[0].i_R10_a_r
    i_R10_a_i = struct[0].i_R10_a_i
    i_R10_b_r = struct[0].i_R10_b_r
    i_R10_b_i = struct[0].i_R10_b_i
    i_R10_c_r = struct[0].i_R10_c_r
    i_R10_c_i = struct[0].i_R10_c_i
    i_R10_n_r = struct[0].i_R10_n_r
    i_R10_n_i = struct[0].i_R10_n_i
    i_R11_b_r = struct[0].i_R11_b_r
    i_R11_b_i = struct[0].i_R11_b_i
    i_R11_c_r = struct[0].i_R11_c_r
    i_R11_c_i = struct[0].i_R11_c_i
    i_R12_a_r = struct[0].i_R12_a_r
    i_R12_a_i = struct[0].i_R12_a_i
    i_R12_b_r = struct[0].i_R12_b_r
    i_R12_b_i = struct[0].i_R12_b_i
    i_R12_c_r = struct[0].i_R12_c_r
    i_R12_c_i = struct[0].i_R12_c_i
    i_R12_n_r = struct[0].i_R12_n_r
    i_R12_n_i = struct[0].i_R12_n_i
    i_R13_a_r = struct[0].i_R13_a_r
    i_R13_a_i = struct[0].i_R13_a_i
    i_R13_b_r = struct[0].i_R13_b_r
    i_R13_b_i = struct[0].i_R13_b_i
    i_R13_c_r = struct[0].i_R13_c_r
    i_R13_c_i = struct[0].i_R13_c_i
    i_R13_n_r = struct[0].i_R13_n_r
    i_R13_n_i = struct[0].i_R13_n_i
    i_R14_a_r = struct[0].i_R14_a_r
    i_R14_a_i = struct[0].i_R14_a_i
    i_R14_b_r = struct[0].i_R14_b_r
    i_R14_b_i = struct[0].i_R14_b_i
    i_R14_c_r = struct[0].i_R14_c_r
    i_R14_c_i = struct[0].i_R14_c_i
    i_R14_n_r = struct[0].i_R14_n_r
    i_R14_n_i = struct[0].i_R14_n_i
    i_R15_b_r = struct[0].i_R15_b_r
    i_R15_b_i = struct[0].i_R15_b_i
    i_R15_c_r = struct[0].i_R15_c_r
    i_R15_c_i = struct[0].i_R15_c_i
    i_R16_b_r = struct[0].i_R16_b_r
    i_R16_b_i = struct[0].i_R16_b_i
    i_R16_c_r = struct[0].i_R16_c_r
    i_R16_c_i = struct[0].i_R16_c_i
    i_R17_b_r = struct[0].i_R17_b_r
    i_R17_b_i = struct[0].i_R17_b_i
    i_R17_c_r = struct[0].i_R17_c_r
    i_R17_c_i = struct[0].i_R17_c_i
    i_R18_b_r = struct[0].i_R18_b_r
    i_R18_b_i = struct[0].i_R18_b_i
    i_R18_c_r = struct[0].i_R18_c_r
    i_R18_c_i = struct[0].i_R18_c_i
    i_D1_n_r = struct[0].i_D1_n_r
    i_D1_n_i = struct[0].i_D1_n_i
    i_D3_a_r = struct[0].i_D3_a_r
    i_D3_a_i = struct[0].i_D3_a_i
    i_D3_b_r = struct[0].i_D3_b_r
    i_D3_b_i = struct[0].i_D3_b_i
    i_D3_c_r = struct[0].i_D3_c_r
    i_D3_c_i = struct[0].i_D3_c_i
    i_D3_n_r = struct[0].i_D3_n_r
    i_D3_n_i = struct[0].i_D3_n_i
    i_D4_a_r = struct[0].i_D4_a_r
    i_D4_a_i = struct[0].i_D4_a_i
    i_D4_b_r = struct[0].i_D4_b_r
    i_D4_b_i = struct[0].i_D4_b_i
    i_D4_c_r = struct[0].i_D4_c_r
    i_D4_c_i = struct[0].i_D4_c_i
    i_D4_n_r = struct[0].i_D4_n_r
    i_D4_n_i = struct[0].i_D4_n_i
    i_D6_a_r = struct[0].i_D6_a_r
    i_D6_a_i = struct[0].i_D6_a_i
    i_D6_b_r = struct[0].i_D6_b_r
    i_D6_b_i = struct[0].i_D6_b_i
    i_D6_c_r = struct[0].i_D6_c_r
    i_D6_c_i = struct[0].i_D6_c_i
    i_D6_n_r = struct[0].i_D6_n_r
    i_D6_n_i = struct[0].i_D6_n_i
    i_D9_a_r = struct[0].i_D9_a_r
    i_D9_a_i = struct[0].i_D9_a_i
    i_D9_b_r = struct[0].i_D9_b_r
    i_D9_b_i = struct[0].i_D9_b_i
    i_D9_c_r = struct[0].i_D9_c_r
    i_D9_c_i = struct[0].i_D9_c_i
    i_D9_n_r = struct[0].i_D9_n_r
    i_D9_n_i = struct[0].i_D9_n_i
    i_D10_a_i = struct[0].i_D10_a_i
    i_D10_b_r = struct[0].i_D10_b_r
    i_D10_b_i = struct[0].i_D10_b_i
    i_D10_c_r = struct[0].i_D10_c_r
    i_D10_c_i = struct[0].i_D10_c_i
    i_D10_n_i = struct[0].i_D10_n_i
    i_D11_b_r = struct[0].i_D11_b_r
    i_D11_b_i = struct[0].i_D11_b_i
    i_D11_c_r = struct[0].i_D11_c_r
    i_D11_c_i = struct[0].i_D11_c_i
    i_D16_b_r = struct[0].i_D16_b_r
    i_D16_b_i = struct[0].i_D16_b_i
    i_D16_c_r = struct[0].i_D16_c_r
    i_D16_c_i = struct[0].i_D16_c_i
    i_D17_b_r = struct[0].i_D17_b_r
    i_D17_b_i = struct[0].i_D17_b_i
    i_D17_c_r = struct[0].i_D17_c_r
    i_D17_c_i = struct[0].i_D17_c_i
    i_D18_b_r = struct[0].i_D18_b_r
    i_D18_b_i = struct[0].i_D18_b_i
    i_D18_c_r = struct[0].i_D18_c_r
    i_D18_c_i = struct[0].i_D18_c_i
    i_D14_a_i = struct[0].i_D14_a_i
    i_D14_b_r = struct[0].i_D14_b_r
    i_D14_b_i = struct[0].i_D14_b_i
    i_D14_c_r = struct[0].i_D14_c_r
    i_D14_c_i = struct[0].i_D14_c_i
    i_D14_n_i = struct[0].i_D14_n_i
    i_D15_b_r = struct[0].i_D15_b_r
    i_D15_b_i = struct[0].i_D15_b_i
    i_D15_c_r = struct[0].i_D15_c_r
    i_D15_c_i = struct[0].i_D15_c_i
    p_R1_a = struct[0].p_R1_a
    q_R1_a = struct[0].q_R1_a
    p_R1_b = struct[0].p_R1_b
    q_R1_b = struct[0].q_R1_b
    p_R1_c = struct[0].p_R1_c
    q_R1_c = struct[0].q_R1_c
    p_R11_1 = struct[0].p_R11_1
    q_R11_1 = struct[0].q_R11_1
    p_R15_1 = struct[0].p_R15_1
    q_R15_1 = struct[0].q_R15_1
    p_R16_1 = struct[0].p_R16_1
    q_R16_1 = struct[0].q_R16_1
    p_R17_1 = struct[0].p_R17_1
    q_R17_1 = struct[0].q_R17_1
    p_R18_1 = struct[0].p_R18_1
    q_R18_1 = struct[0].q_R18_1
    p_D15_1 = struct[0].p_D15_1
    q_D15_1 = struct[0].q_D15_1
    p_D11_1 = struct[0].p_D11_1
    q_D11_1 = struct[0].q_D11_1
    p_D16_1 = struct[0].p_D16_1
    q_D16_1 = struct[0].q_D16_1
    p_D17_1 = struct[0].p_D17_1
    q_D17_1 = struct[0].q_D17_1
    p_D18_1 = struct[0].p_D18_1
    q_D18_1 = struct[0].q_D18_1
    v_dc_D1 = struct[0].v_dc_D1
    q_R1 = struct[0].q_R1
    p_R10 = struct[0].p_R10
    q_R10 = struct[0].q_R10
    p_R14 = struct[0].p_R14
    q_R14 = struct[0].q_R14
    u_dummy = struct[0].u_dummy
    
    # Dynamical states:
    x_dummy = struct[0].x[0,0]
    
    # Algebraic states:
    v_R1_a_r = struct[0].y_run[0,0]
    v_R1_a_i = struct[0].y_run[1,0]
    v_R1_b_r = struct[0].y_run[2,0]
    v_R1_b_i = struct[0].y_run[3,0]
    v_R1_c_r = struct[0].y_run[4,0]
    v_R1_c_i = struct[0].y_run[5,0]
    v_R1_n_r = struct[0].y_run[6,0]
    v_R1_n_i = struct[0].y_run[7,0]
    v_R11_a_r = struct[0].y_run[8,0]
    v_R11_a_i = struct[0].y_run[9,0]
    v_R11_n_r = struct[0].y_run[10,0]
    v_R11_n_i = struct[0].y_run[11,0]
    v_R15_a_r = struct[0].y_run[12,0]
    v_R15_a_i = struct[0].y_run[13,0]
    v_R15_n_r = struct[0].y_run[14,0]
    v_R15_n_i = struct[0].y_run[15,0]
    v_R16_a_r = struct[0].y_run[16,0]
    v_R16_a_i = struct[0].y_run[17,0]
    v_R16_n_r = struct[0].y_run[18,0]
    v_R16_n_i = struct[0].y_run[19,0]
    v_R17_a_r = struct[0].y_run[20,0]
    v_R17_a_i = struct[0].y_run[21,0]
    v_R17_n_r = struct[0].y_run[22,0]
    v_R17_n_i = struct[0].y_run[23,0]
    v_R18_a_r = struct[0].y_run[24,0]
    v_R18_a_i = struct[0].y_run[25,0]
    v_R18_n_r = struct[0].y_run[26,0]
    v_R18_n_i = struct[0].y_run[27,0]
    v_D15_a_r = struct[0].y_run[28,0]
    v_D15_a_i = struct[0].y_run[29,0]
    v_D15_n_r = struct[0].y_run[30,0]
    v_D15_n_i = struct[0].y_run[31,0]
    v_D11_a_r = struct[0].y_run[32,0]
    v_D11_a_i = struct[0].y_run[33,0]
    v_D11_n_r = struct[0].y_run[34,0]
    v_D11_n_i = struct[0].y_run[35,0]
    v_D16_a_r = struct[0].y_run[36,0]
    v_D16_a_i = struct[0].y_run[37,0]
    v_D16_n_r = struct[0].y_run[38,0]
    v_D16_n_i = struct[0].y_run[39,0]
    v_D17_a_r = struct[0].y_run[40,0]
    v_D17_a_i = struct[0].y_run[41,0]
    v_D17_n_r = struct[0].y_run[42,0]
    v_D17_n_i = struct[0].y_run[43,0]
    v_D18_a_r = struct[0].y_run[44,0]
    v_D18_a_i = struct[0].y_run[45,0]
    v_D18_n_r = struct[0].y_run[46,0]
    v_D18_n_i = struct[0].y_run[47,0]
    v_R2_a_r = struct[0].y_run[48,0]
    v_R2_a_i = struct[0].y_run[49,0]
    v_R2_b_r = struct[0].y_run[50,0]
    v_R2_b_i = struct[0].y_run[51,0]
    v_R2_c_r = struct[0].y_run[52,0]
    v_R2_c_i = struct[0].y_run[53,0]
    v_R2_n_r = struct[0].y_run[54,0]
    v_R2_n_i = struct[0].y_run[55,0]
    v_R3_a_r = struct[0].y_run[56,0]
    v_R3_a_i = struct[0].y_run[57,0]
    v_R3_b_r = struct[0].y_run[58,0]
    v_R3_b_i = struct[0].y_run[59,0]
    v_R3_c_r = struct[0].y_run[60,0]
    v_R3_c_i = struct[0].y_run[61,0]
    v_R3_n_r = struct[0].y_run[62,0]
    v_R3_n_i = struct[0].y_run[63,0]
    v_R4_a_r = struct[0].y_run[64,0]
    v_R4_a_i = struct[0].y_run[65,0]
    v_R4_b_r = struct[0].y_run[66,0]
    v_R4_b_i = struct[0].y_run[67,0]
    v_R4_c_r = struct[0].y_run[68,0]
    v_R4_c_i = struct[0].y_run[69,0]
    v_R4_n_r = struct[0].y_run[70,0]
    v_R4_n_i = struct[0].y_run[71,0]
    v_R5_a_r = struct[0].y_run[72,0]
    v_R5_a_i = struct[0].y_run[73,0]
    v_R5_b_r = struct[0].y_run[74,0]
    v_R5_b_i = struct[0].y_run[75,0]
    v_R5_c_r = struct[0].y_run[76,0]
    v_R5_c_i = struct[0].y_run[77,0]
    v_R5_n_r = struct[0].y_run[78,0]
    v_R5_n_i = struct[0].y_run[79,0]
    v_R6_a_r = struct[0].y_run[80,0]
    v_R6_a_i = struct[0].y_run[81,0]
    v_R6_b_r = struct[0].y_run[82,0]
    v_R6_b_i = struct[0].y_run[83,0]
    v_R6_c_r = struct[0].y_run[84,0]
    v_R6_c_i = struct[0].y_run[85,0]
    v_R6_n_r = struct[0].y_run[86,0]
    v_R6_n_i = struct[0].y_run[87,0]
    v_R7_a_r = struct[0].y_run[88,0]
    v_R7_a_i = struct[0].y_run[89,0]
    v_R7_b_r = struct[0].y_run[90,0]
    v_R7_b_i = struct[0].y_run[91,0]
    v_R7_c_r = struct[0].y_run[92,0]
    v_R7_c_i = struct[0].y_run[93,0]
    v_R7_n_r = struct[0].y_run[94,0]
    v_R7_n_i = struct[0].y_run[95,0]
    v_R8_a_r = struct[0].y_run[96,0]
    v_R8_a_i = struct[0].y_run[97,0]
    v_R8_b_r = struct[0].y_run[98,0]
    v_R8_b_i = struct[0].y_run[99,0]
    v_R8_c_r = struct[0].y_run[100,0]
    v_R8_c_i = struct[0].y_run[101,0]
    v_R8_n_r = struct[0].y_run[102,0]
    v_R8_n_i = struct[0].y_run[103,0]
    v_R9_a_r = struct[0].y_run[104,0]
    v_R9_a_i = struct[0].y_run[105,0]
    v_R9_b_r = struct[0].y_run[106,0]
    v_R9_b_i = struct[0].y_run[107,0]
    v_R9_c_r = struct[0].y_run[108,0]
    v_R9_c_i = struct[0].y_run[109,0]
    v_R9_n_r = struct[0].y_run[110,0]
    v_R9_n_i = struct[0].y_run[111,0]
    v_R10_a_r = struct[0].y_run[112,0]
    v_R10_a_i = struct[0].y_run[113,0]
    v_R10_b_r = struct[0].y_run[114,0]
    v_R10_b_i = struct[0].y_run[115,0]
    v_R10_c_r = struct[0].y_run[116,0]
    v_R10_c_i = struct[0].y_run[117,0]
    v_R10_n_r = struct[0].y_run[118,0]
    v_R10_n_i = struct[0].y_run[119,0]
    v_R11_b_r = struct[0].y_run[120,0]
    v_R11_b_i = struct[0].y_run[121,0]
    v_R11_c_r = struct[0].y_run[122,0]
    v_R11_c_i = struct[0].y_run[123,0]
    v_R12_a_r = struct[0].y_run[124,0]
    v_R12_a_i = struct[0].y_run[125,0]
    v_R12_b_r = struct[0].y_run[126,0]
    v_R12_b_i = struct[0].y_run[127,0]
    v_R12_c_r = struct[0].y_run[128,0]
    v_R12_c_i = struct[0].y_run[129,0]
    v_R12_n_r = struct[0].y_run[130,0]
    v_R12_n_i = struct[0].y_run[131,0]
    v_R13_a_r = struct[0].y_run[132,0]
    v_R13_a_i = struct[0].y_run[133,0]
    v_R13_b_r = struct[0].y_run[134,0]
    v_R13_b_i = struct[0].y_run[135,0]
    v_R13_c_r = struct[0].y_run[136,0]
    v_R13_c_i = struct[0].y_run[137,0]
    v_R13_n_r = struct[0].y_run[138,0]
    v_R13_n_i = struct[0].y_run[139,0]
    v_R14_a_r = struct[0].y_run[140,0]
    v_R14_a_i = struct[0].y_run[141,0]
    v_R14_b_r = struct[0].y_run[142,0]
    v_R14_b_i = struct[0].y_run[143,0]
    v_R14_c_r = struct[0].y_run[144,0]
    v_R14_c_i = struct[0].y_run[145,0]
    v_R14_n_r = struct[0].y_run[146,0]
    v_R14_n_i = struct[0].y_run[147,0]
    v_R15_b_r = struct[0].y_run[148,0]
    v_R15_b_i = struct[0].y_run[149,0]
    v_R15_c_r = struct[0].y_run[150,0]
    v_R15_c_i = struct[0].y_run[151,0]
    v_R16_b_r = struct[0].y_run[152,0]
    v_R16_b_i = struct[0].y_run[153,0]
    v_R16_c_r = struct[0].y_run[154,0]
    v_R16_c_i = struct[0].y_run[155,0]
    v_R17_b_r = struct[0].y_run[156,0]
    v_R17_b_i = struct[0].y_run[157,0]
    v_R17_c_r = struct[0].y_run[158,0]
    v_R17_c_i = struct[0].y_run[159,0]
    v_R18_b_r = struct[0].y_run[160,0]
    v_R18_b_i = struct[0].y_run[161,0]
    v_R18_c_r = struct[0].y_run[162,0]
    v_R18_c_i = struct[0].y_run[163,0]
    v_D1_n_r = struct[0].y_run[164,0]
    v_D1_n_i = struct[0].y_run[165,0]
    v_D3_a_r = struct[0].y_run[166,0]
    v_D3_a_i = struct[0].y_run[167,0]
    v_D3_b_r = struct[0].y_run[168,0]
    v_D3_b_i = struct[0].y_run[169,0]
    v_D3_c_r = struct[0].y_run[170,0]
    v_D3_c_i = struct[0].y_run[171,0]
    v_D3_n_r = struct[0].y_run[172,0]
    v_D3_n_i = struct[0].y_run[173,0]
    v_D4_a_r = struct[0].y_run[174,0]
    v_D4_a_i = struct[0].y_run[175,0]
    v_D4_b_r = struct[0].y_run[176,0]
    v_D4_b_i = struct[0].y_run[177,0]
    v_D4_c_r = struct[0].y_run[178,0]
    v_D4_c_i = struct[0].y_run[179,0]
    v_D4_n_r = struct[0].y_run[180,0]
    v_D4_n_i = struct[0].y_run[181,0]
    v_D6_a_r = struct[0].y_run[182,0]
    v_D6_a_i = struct[0].y_run[183,0]
    v_D6_b_r = struct[0].y_run[184,0]
    v_D6_b_i = struct[0].y_run[185,0]
    v_D6_c_r = struct[0].y_run[186,0]
    v_D6_c_i = struct[0].y_run[187,0]
    v_D6_n_r = struct[0].y_run[188,0]
    v_D6_n_i = struct[0].y_run[189,0]
    v_D9_a_r = struct[0].y_run[190,0]
    v_D9_a_i = struct[0].y_run[191,0]
    v_D9_b_r = struct[0].y_run[192,0]
    v_D9_b_i = struct[0].y_run[193,0]
    v_D9_c_r = struct[0].y_run[194,0]
    v_D9_c_i = struct[0].y_run[195,0]
    v_D9_n_r = struct[0].y_run[196,0]
    v_D9_n_i = struct[0].y_run[197,0]
    v_D10_a_r = struct[0].y_run[198,0]
    v_D10_a_i = struct[0].y_run[199,0]
    v_D10_b_r = struct[0].y_run[200,0]
    v_D10_b_i = struct[0].y_run[201,0]
    v_D10_c_r = struct[0].y_run[202,0]
    v_D10_c_i = struct[0].y_run[203,0]
    v_D10_n_r = struct[0].y_run[204,0]
    v_D10_n_i = struct[0].y_run[205,0]
    v_D11_b_r = struct[0].y_run[206,0]
    v_D11_b_i = struct[0].y_run[207,0]
    v_D11_c_r = struct[0].y_run[208,0]
    v_D11_c_i = struct[0].y_run[209,0]
    v_D16_b_r = struct[0].y_run[210,0]
    v_D16_b_i = struct[0].y_run[211,0]
    v_D16_c_r = struct[0].y_run[212,0]
    v_D16_c_i = struct[0].y_run[213,0]
    v_D17_b_r = struct[0].y_run[214,0]
    v_D17_b_i = struct[0].y_run[215,0]
    v_D17_c_r = struct[0].y_run[216,0]
    v_D17_c_i = struct[0].y_run[217,0]
    v_D18_b_r = struct[0].y_run[218,0]
    v_D18_b_i = struct[0].y_run[219,0]
    v_D18_c_r = struct[0].y_run[220,0]
    v_D18_c_i = struct[0].y_run[221,0]
    v_D14_a_r = struct[0].y_run[222,0]
    v_D14_a_i = struct[0].y_run[223,0]
    v_D14_b_r = struct[0].y_run[224,0]
    v_D14_b_i = struct[0].y_run[225,0]
    v_D14_c_r = struct[0].y_run[226,0]
    v_D14_c_i = struct[0].y_run[227,0]
    v_D14_n_r = struct[0].y_run[228,0]
    v_D14_n_i = struct[0].y_run[229,0]
    v_D15_b_r = struct[0].y_run[230,0]
    v_D15_b_i = struct[0].y_run[231,0]
    v_D15_c_r = struct[0].y_run[232,0]
    v_D15_c_i = struct[0].y_run[233,0]
    i_t_R0_R1_a_r = struct[0].y_run[234,0]
    i_t_R0_R1_a_i = struct[0].y_run[235,0]
    i_t_R0_R1_b_r = struct[0].y_run[236,0]
    i_t_R0_R1_b_i = struct[0].y_run[237,0]
    i_t_R0_R1_c_r = struct[0].y_run[238,0]
    i_t_R0_R1_c_i = struct[0].y_run[239,0]
    i_l_R1_R2_a_r = struct[0].y_run[240,0]
    i_l_R1_R2_a_i = struct[0].y_run[241,0]
    i_l_R1_R2_b_r = struct[0].y_run[242,0]
    i_l_R1_R2_b_i = struct[0].y_run[243,0]
    i_l_R1_R2_c_r = struct[0].y_run[244,0]
    i_l_R1_R2_c_i = struct[0].y_run[245,0]
    i_l_R1_R2_n_r = struct[0].y_run[246,0]
    i_l_R1_R2_n_i = struct[0].y_run[247,0]
    i_l_D1_D3_a_r = struct[0].y_run[248,0]
    i_l_D1_D3_a_i = struct[0].y_run[249,0]
    i_l_D1_D3_b_r = struct[0].y_run[250,0]
    i_l_D1_D3_b_i = struct[0].y_run[251,0]
    i_l_D1_D3_c_r = struct[0].y_run[252,0]
    i_l_D1_D3_c_i = struct[0].y_run[253,0]
    i_l_D1_D3_n_r = struct[0].y_run[254,0]
    i_l_D1_D3_n_i = struct[0].y_run[255,0]
    i_l_D3_D4_a_r = struct[0].y_run[256,0]
    i_l_D3_D4_a_i = struct[0].y_run[257,0]
    i_l_D3_D4_b_r = struct[0].y_run[258,0]
    i_l_D3_D4_b_i = struct[0].y_run[259,0]
    i_l_D3_D4_c_r = struct[0].y_run[260,0]
    i_l_D3_D4_c_i = struct[0].y_run[261,0]
    i_l_D3_D4_n_r = struct[0].y_run[262,0]
    i_l_D3_D4_n_i = struct[0].y_run[263,0]
    i_l_D4_D6_a_r = struct[0].y_run[264,0]
    i_l_D4_D6_a_i = struct[0].y_run[265,0]
    i_l_D4_D6_b_r = struct[0].y_run[266,0]
    i_l_D4_D6_b_i = struct[0].y_run[267,0]
    i_l_D4_D6_c_r = struct[0].y_run[268,0]
    i_l_D4_D6_c_i = struct[0].y_run[269,0]
    i_l_D4_D6_n_r = struct[0].y_run[270,0]
    i_l_D4_D6_n_i = struct[0].y_run[271,0]
    i_l_D6_D9_a_r = struct[0].y_run[272,0]
    i_l_D6_D9_a_i = struct[0].y_run[273,0]
    i_l_D6_D9_b_r = struct[0].y_run[274,0]
    i_l_D6_D9_b_i = struct[0].y_run[275,0]
    i_l_D6_D9_c_r = struct[0].y_run[276,0]
    i_l_D6_D9_c_i = struct[0].y_run[277,0]
    i_l_D6_D9_n_r = struct[0].y_run[278,0]
    i_l_D6_D9_n_i = struct[0].y_run[279,0]
    i_l_D9_D10_a_r = struct[0].y_run[280,0]
    i_l_D9_D10_a_i = struct[0].y_run[281,0]
    i_l_D9_D10_b_r = struct[0].y_run[282,0]
    i_l_D9_D10_b_i = struct[0].y_run[283,0]
    i_l_D9_D10_c_r = struct[0].y_run[284,0]
    i_l_D9_D10_c_i = struct[0].y_run[285,0]
    i_l_D9_D10_n_r = struct[0].y_run[286,0]
    i_l_D9_D10_n_i = struct[0].y_run[287,0]
    i_l_D3_D11_a_r = struct[0].y_run[288,0]
    i_l_D3_D11_a_i = struct[0].y_run[289,0]
    i_l_D3_D11_b_r = struct[0].y_run[290,0]
    i_l_D3_D11_b_i = struct[0].y_run[291,0]
    i_l_D3_D11_c_r = struct[0].y_run[292,0]
    i_l_D3_D11_c_i = struct[0].y_run[293,0]
    i_l_D3_D11_n_r = struct[0].y_run[294,0]
    i_l_D3_D11_n_i = struct[0].y_run[295,0]
    i_l_D6_D16_a_r = struct[0].y_run[296,0]
    i_l_D6_D16_a_i = struct[0].y_run[297,0]
    i_l_D6_D16_b_r = struct[0].y_run[298,0]
    i_l_D6_D16_b_i = struct[0].y_run[299,0]
    i_l_D6_D16_c_r = struct[0].y_run[300,0]
    i_l_D6_D16_c_i = struct[0].y_run[301,0]
    i_l_D6_D16_n_r = struct[0].y_run[302,0]
    i_l_D6_D16_n_i = struct[0].y_run[303,0]
    i_l_D9_D17_a_r = struct[0].y_run[304,0]
    i_l_D9_D17_a_i = struct[0].y_run[305,0]
    i_l_D9_D17_b_r = struct[0].y_run[306,0]
    i_l_D9_D17_b_i = struct[0].y_run[307,0]
    i_l_D9_D17_c_r = struct[0].y_run[308,0]
    i_l_D9_D17_c_i = struct[0].y_run[309,0]
    i_l_D9_D17_n_r = struct[0].y_run[310,0]
    i_l_D9_D17_n_i = struct[0].y_run[311,0]
    i_l_D10_D18_a_r = struct[0].y_run[312,0]
    i_l_D10_D18_a_i = struct[0].y_run[313,0]
    i_l_D10_D18_b_r = struct[0].y_run[314,0]
    i_l_D10_D18_b_i = struct[0].y_run[315,0]
    i_l_D10_D18_c_r = struct[0].y_run[316,0]
    i_l_D10_D18_c_i = struct[0].y_run[317,0]
    i_l_D10_D18_n_r = struct[0].y_run[318,0]
    i_l_D10_D18_n_i = struct[0].y_run[319,0]
    i_l_D4_D14_a_r = struct[0].y_run[320,0]
    i_l_D4_D14_a_i = struct[0].y_run[321,0]
    i_l_D4_D14_b_r = struct[0].y_run[322,0]
    i_l_D4_D14_b_i = struct[0].y_run[323,0]
    i_l_D4_D14_c_r = struct[0].y_run[324,0]
    i_l_D4_D14_c_i = struct[0].y_run[325,0]
    i_l_D4_D14_n_r = struct[0].y_run[326,0]
    i_l_D4_D14_n_i = struct[0].y_run[327,0]
    i_l_D14_D15_a_r = struct[0].y_run[328,0]
    i_l_D14_D15_a_i = struct[0].y_run[329,0]
    i_l_D14_D15_b_r = struct[0].y_run[330,0]
    i_l_D14_D15_b_i = struct[0].y_run[331,0]
    i_l_D14_D15_c_r = struct[0].y_run[332,0]
    i_l_D14_D15_c_i = struct[0].y_run[333,0]
    i_l_D14_D15_n_r = struct[0].y_run[334,0]
    i_l_D14_D15_n_i = struct[0].y_run[335,0]
    i_load_R1_a_r = struct[0].y_run[336,0]
    i_load_R1_a_i = struct[0].y_run[337,0]
    i_load_R1_b_r = struct[0].y_run[338,0]
    i_load_R1_b_i = struct[0].y_run[339,0]
    i_load_R1_c_r = struct[0].y_run[340,0]
    i_load_R1_c_i = struct[0].y_run[341,0]
    i_load_R1_n_r = struct[0].y_run[342,0]
    i_load_R1_n_i = struct[0].y_run[343,0]
    i_load_R11_a_r = struct[0].y_run[344,0]
    i_load_R11_a_i = struct[0].y_run[345,0]
    i_load_R11_n_r = struct[0].y_run[346,0]
    i_load_R11_n_i = struct[0].y_run[347,0]
    i_load_R15_a_r = struct[0].y_run[348,0]
    i_load_R15_a_i = struct[0].y_run[349,0]
    i_load_R15_n_r = struct[0].y_run[350,0]
    i_load_R15_n_i = struct[0].y_run[351,0]
    i_load_R16_a_r = struct[0].y_run[352,0]
    i_load_R16_a_i = struct[0].y_run[353,0]
    i_load_R16_n_r = struct[0].y_run[354,0]
    i_load_R16_n_i = struct[0].y_run[355,0]
    i_load_R17_a_r = struct[0].y_run[356,0]
    i_load_R17_a_i = struct[0].y_run[357,0]
    i_load_R17_n_r = struct[0].y_run[358,0]
    i_load_R17_n_i = struct[0].y_run[359,0]
    i_load_R18_a_r = struct[0].y_run[360,0]
    i_load_R18_a_i = struct[0].y_run[361,0]
    i_load_R18_n_r = struct[0].y_run[362,0]
    i_load_R18_n_i = struct[0].y_run[363,0]
    i_load_D15_a_r = struct[0].y_run[364,0]
    i_load_D15_a_i = struct[0].y_run[365,0]
    i_load_D15_n_r = struct[0].y_run[366,0]
    i_load_D15_n_i = struct[0].y_run[367,0]
    i_load_D11_a_r = struct[0].y_run[368,0]
    i_load_D11_a_i = struct[0].y_run[369,0]
    i_load_D11_n_r = struct[0].y_run[370,0]
    i_load_D11_n_i = struct[0].y_run[371,0]
    i_load_D16_a_r = struct[0].y_run[372,0]
    i_load_D16_a_i = struct[0].y_run[373,0]
    i_load_D16_n_r = struct[0].y_run[374,0]
    i_load_D16_n_i = struct[0].y_run[375,0]
    i_load_D17_a_r = struct[0].y_run[376,0]
    i_load_D17_a_i = struct[0].y_run[377,0]
    i_load_D17_n_r = struct[0].y_run[378,0]
    i_load_D17_n_i = struct[0].y_run[379,0]
    i_load_D18_a_r = struct[0].y_run[380,0]
    i_load_D18_a_i = struct[0].y_run[381,0]
    i_load_D18_n_r = struct[0].y_run[382,0]
    i_load_D18_n_i = struct[0].y_run[383,0]
    i_vsc_R1_a_r = struct[0].y_run[384,0]
    i_vsc_R1_a_i = struct[0].y_run[385,0]
    i_vsc_R1_b_r = struct[0].y_run[386,0]
    i_vsc_R1_b_i = struct[0].y_run[387,0]
    i_vsc_R1_c_r = struct[0].y_run[388,0]
    i_vsc_R1_c_i = struct[0].y_run[389,0]
    p_R1 = struct[0].y_run[390,0]
    p_D1 = struct[0].y_run[391,0]
    p_loss_R1 = struct[0].y_run[392,0]
    i_vsc_R10_a_r = struct[0].y_run[393,0]
    i_vsc_R10_a_i = struct[0].y_run[394,0]
    i_vsc_R10_b_r = struct[0].y_run[395,0]
    i_vsc_R10_b_i = struct[0].y_run[396,0]
    i_vsc_R10_c_r = struct[0].y_run[397,0]
    i_vsc_R10_c_i = struct[0].y_run[398,0]
    i_vsc_R10_n_r = struct[0].y_run[399,0]
    i_vsc_R10_n_i = struct[0].y_run[400,0]
    i_vsc_D10_a_r = struct[0].y_run[401,0]
    i_vsc_D10_n_r = struct[0].y_run[402,0]
    p_D10 = struct[0].y_run[403,0]
    i_vsc_R14_a_r = struct[0].y_run[404,0]
    i_vsc_R14_a_i = struct[0].y_run[405,0]
    i_vsc_R14_b_r = struct[0].y_run[406,0]
    i_vsc_R14_b_i = struct[0].y_run[407,0]
    i_vsc_R14_c_r = struct[0].y_run[408,0]
    i_vsc_R14_c_i = struct[0].y_run[409,0]
    i_vsc_R14_n_r = struct[0].y_run[410,0]
    i_vsc_R14_n_i = struct[0].y_run[411,0]
    i_vsc_D14_a_r = struct[0].y_run[412,0]
    i_vsc_D14_n_r = struct[0].y_run[413,0]
    p_D14 = struct[0].y_run[414,0]
    
    struct[0].u_run[0,0] = v_R0_a_r
    struct[0].u_run[1,0] = v_R0_a_i
    struct[0].u_run[2,0] = v_R0_b_r
    struct[0].u_run[3,0] = v_R0_b_i
    struct[0].u_run[4,0] = v_R0_c_r
    struct[0].u_run[5,0] = v_R0_c_i
    struct[0].u_run[6,0] = v_D1_a_r
    struct[0].u_run[7,0] = v_D1_a_i
    struct[0].u_run[8,0] = v_D1_b_r
    struct[0].u_run[9,0] = v_D1_b_i
    struct[0].u_run[10,0] = v_D1_c_r
    struct[0].u_run[11,0] = v_D1_c_i
    struct[0].u_run[12,0] = i_R1_n_r
    struct[0].u_run[13,0] = i_R1_n_i
    struct[0].u_run[14,0] = i_R2_a_r
    struct[0].u_run[15,0] = i_R2_a_i
    struct[0].u_run[16,0] = i_R2_b_r
    struct[0].u_run[17,0] = i_R2_b_i
    struct[0].u_run[18,0] = i_R2_c_r
    struct[0].u_run[19,0] = i_R2_c_i
    struct[0].u_run[20,0] = i_R2_n_r
    struct[0].u_run[21,0] = i_R2_n_i
    struct[0].u_run[22,0] = i_R3_a_r
    struct[0].u_run[23,0] = i_R3_a_i
    struct[0].u_run[24,0] = i_R3_b_r
    struct[0].u_run[25,0] = i_R3_b_i
    struct[0].u_run[26,0] = i_R3_c_r
    struct[0].u_run[27,0] = i_R3_c_i
    struct[0].u_run[28,0] = i_R3_n_r
    struct[0].u_run[29,0] = i_R3_n_i
    struct[0].u_run[30,0] = i_R4_a_r
    struct[0].u_run[31,0] = i_R4_a_i
    struct[0].u_run[32,0] = i_R4_b_r
    struct[0].u_run[33,0] = i_R4_b_i
    struct[0].u_run[34,0] = i_R4_c_r
    struct[0].u_run[35,0] = i_R4_c_i
    struct[0].u_run[36,0] = i_R4_n_r
    struct[0].u_run[37,0] = i_R4_n_i
    struct[0].u_run[38,0] = i_R5_a_r
    struct[0].u_run[39,0] = i_R5_a_i
    struct[0].u_run[40,0] = i_R5_b_r
    struct[0].u_run[41,0] = i_R5_b_i
    struct[0].u_run[42,0] = i_R5_c_r
    struct[0].u_run[43,0] = i_R5_c_i
    struct[0].u_run[44,0] = i_R5_n_r
    struct[0].u_run[45,0] = i_R5_n_i
    struct[0].u_run[46,0] = i_R6_a_r
    struct[0].u_run[47,0] = i_R6_a_i
    struct[0].u_run[48,0] = i_R6_b_r
    struct[0].u_run[49,0] = i_R6_b_i
    struct[0].u_run[50,0] = i_R6_c_r
    struct[0].u_run[51,0] = i_R6_c_i
    struct[0].u_run[52,0] = i_R6_n_r
    struct[0].u_run[53,0] = i_R6_n_i
    struct[0].u_run[54,0] = i_R7_a_r
    struct[0].u_run[55,0] = i_R7_a_i
    struct[0].u_run[56,0] = i_R7_b_r
    struct[0].u_run[57,0] = i_R7_b_i
    struct[0].u_run[58,0] = i_R7_c_r
    struct[0].u_run[59,0] = i_R7_c_i
    struct[0].u_run[60,0] = i_R7_n_r
    struct[0].u_run[61,0] = i_R7_n_i
    struct[0].u_run[62,0] = i_R8_a_r
    struct[0].u_run[63,0] = i_R8_a_i
    struct[0].u_run[64,0] = i_R8_b_r
    struct[0].u_run[65,0] = i_R8_b_i
    struct[0].u_run[66,0] = i_R8_c_r
    struct[0].u_run[67,0] = i_R8_c_i
    struct[0].u_run[68,0] = i_R8_n_r
    struct[0].u_run[69,0] = i_R8_n_i
    struct[0].u_run[70,0] = i_R9_a_r
    struct[0].u_run[71,0] = i_R9_a_i
    struct[0].u_run[72,0] = i_R9_b_r
    struct[0].u_run[73,0] = i_R9_b_i
    struct[0].u_run[74,0] = i_R9_c_r
    struct[0].u_run[75,0] = i_R9_c_i
    struct[0].u_run[76,0] = i_R9_n_r
    struct[0].u_run[77,0] = i_R9_n_i
    struct[0].u_run[78,0] = i_R10_a_r
    struct[0].u_run[79,0] = i_R10_a_i
    struct[0].u_run[80,0] = i_R10_b_r
    struct[0].u_run[81,0] = i_R10_b_i
    struct[0].u_run[82,0] = i_R10_c_r
    struct[0].u_run[83,0] = i_R10_c_i
    struct[0].u_run[84,0] = i_R10_n_r
    struct[0].u_run[85,0] = i_R10_n_i
    struct[0].u_run[86,0] = i_R11_b_r
    struct[0].u_run[87,0] = i_R11_b_i
    struct[0].u_run[88,0] = i_R11_c_r
    struct[0].u_run[89,0] = i_R11_c_i
    struct[0].u_run[90,0] = i_R12_a_r
    struct[0].u_run[91,0] = i_R12_a_i
    struct[0].u_run[92,0] = i_R12_b_r
    struct[0].u_run[93,0] = i_R12_b_i
    struct[0].u_run[94,0] = i_R12_c_r
    struct[0].u_run[95,0] = i_R12_c_i
    struct[0].u_run[96,0] = i_R12_n_r
    struct[0].u_run[97,0] = i_R12_n_i
    struct[0].u_run[98,0] = i_R13_a_r
    struct[0].u_run[99,0] = i_R13_a_i
    struct[0].u_run[100,0] = i_R13_b_r
    struct[0].u_run[101,0] = i_R13_b_i
    struct[0].u_run[102,0] = i_R13_c_r
    struct[0].u_run[103,0] = i_R13_c_i
    struct[0].u_run[104,0] = i_R13_n_r
    struct[0].u_run[105,0] = i_R13_n_i
    struct[0].u_run[106,0] = i_R14_a_r
    struct[0].u_run[107,0] = i_R14_a_i
    struct[0].u_run[108,0] = i_R14_b_r
    struct[0].u_run[109,0] = i_R14_b_i
    struct[0].u_run[110,0] = i_R14_c_r
    struct[0].u_run[111,0] = i_R14_c_i
    struct[0].u_run[112,0] = i_R14_n_r
    struct[0].u_run[113,0] = i_R14_n_i
    struct[0].u_run[114,0] = i_R15_b_r
    struct[0].u_run[115,0] = i_R15_b_i
    struct[0].u_run[116,0] = i_R15_c_r
    struct[0].u_run[117,0] = i_R15_c_i
    struct[0].u_run[118,0] = i_R16_b_r
    struct[0].u_run[119,0] = i_R16_b_i
    struct[0].u_run[120,0] = i_R16_c_r
    struct[0].u_run[121,0] = i_R16_c_i
    struct[0].u_run[122,0] = i_R17_b_r
    struct[0].u_run[123,0] = i_R17_b_i
    struct[0].u_run[124,0] = i_R17_c_r
    struct[0].u_run[125,0] = i_R17_c_i
    struct[0].u_run[126,0] = i_R18_b_r
    struct[0].u_run[127,0] = i_R18_b_i
    struct[0].u_run[128,0] = i_R18_c_r
    struct[0].u_run[129,0] = i_R18_c_i
    struct[0].u_run[130,0] = i_D1_n_r
    struct[0].u_run[131,0] = i_D1_n_i
    struct[0].u_run[132,0] = i_D3_a_r
    struct[0].u_run[133,0] = i_D3_a_i
    struct[0].u_run[134,0] = i_D3_b_r
    struct[0].u_run[135,0] = i_D3_b_i
    struct[0].u_run[136,0] = i_D3_c_r
    struct[0].u_run[137,0] = i_D3_c_i
    struct[0].u_run[138,0] = i_D3_n_r
    struct[0].u_run[139,0] = i_D3_n_i
    struct[0].u_run[140,0] = i_D4_a_r
    struct[0].u_run[141,0] = i_D4_a_i
    struct[0].u_run[142,0] = i_D4_b_r
    struct[0].u_run[143,0] = i_D4_b_i
    struct[0].u_run[144,0] = i_D4_c_r
    struct[0].u_run[145,0] = i_D4_c_i
    struct[0].u_run[146,0] = i_D4_n_r
    struct[0].u_run[147,0] = i_D4_n_i
    struct[0].u_run[148,0] = i_D6_a_r
    struct[0].u_run[149,0] = i_D6_a_i
    struct[0].u_run[150,0] = i_D6_b_r
    struct[0].u_run[151,0] = i_D6_b_i
    struct[0].u_run[152,0] = i_D6_c_r
    struct[0].u_run[153,0] = i_D6_c_i
    struct[0].u_run[154,0] = i_D6_n_r
    struct[0].u_run[155,0] = i_D6_n_i
    struct[0].u_run[156,0] = i_D9_a_r
    struct[0].u_run[157,0] = i_D9_a_i
    struct[0].u_run[158,0] = i_D9_b_r
    struct[0].u_run[159,0] = i_D9_b_i
    struct[0].u_run[160,0] = i_D9_c_r
    struct[0].u_run[161,0] = i_D9_c_i
    struct[0].u_run[162,0] = i_D9_n_r
    struct[0].u_run[163,0] = i_D9_n_i
    struct[0].u_run[164,0] = i_D10_a_i
    struct[0].u_run[165,0] = i_D10_b_r
    struct[0].u_run[166,0] = i_D10_b_i
    struct[0].u_run[167,0] = i_D10_c_r
    struct[0].u_run[168,0] = i_D10_c_i
    struct[0].u_run[169,0] = i_D10_n_i
    struct[0].u_run[170,0] = i_D11_b_r
    struct[0].u_run[171,0] = i_D11_b_i
    struct[0].u_run[172,0] = i_D11_c_r
    struct[0].u_run[173,0] = i_D11_c_i
    struct[0].u_run[174,0] = i_D16_b_r
    struct[0].u_run[175,0] = i_D16_b_i
    struct[0].u_run[176,0] = i_D16_c_r
    struct[0].u_run[177,0] = i_D16_c_i
    struct[0].u_run[178,0] = i_D17_b_r
    struct[0].u_run[179,0] = i_D17_b_i
    struct[0].u_run[180,0] = i_D17_c_r
    struct[0].u_run[181,0] = i_D17_c_i
    struct[0].u_run[182,0] = i_D18_b_r
    struct[0].u_run[183,0] = i_D18_b_i
    struct[0].u_run[184,0] = i_D18_c_r
    struct[0].u_run[185,0] = i_D18_c_i
    struct[0].u_run[186,0] = i_D14_a_i
    struct[0].u_run[187,0] = i_D14_b_r
    struct[0].u_run[188,0] = i_D14_b_i
    struct[0].u_run[189,0] = i_D14_c_r
    struct[0].u_run[190,0] = i_D14_c_i
    struct[0].u_run[191,0] = i_D14_n_i
    struct[0].u_run[192,0] = i_D15_b_r
    struct[0].u_run[193,0] = i_D15_b_i
    struct[0].u_run[194,0] = i_D15_c_r
    struct[0].u_run[195,0] = i_D15_c_i
    struct[0].u_run[196,0] = p_R1_a
    struct[0].u_run[197,0] = q_R1_a
    struct[0].u_run[198,0] = p_R1_b
    struct[0].u_run[199,0] = q_R1_b
    struct[0].u_run[200,0] = p_R1_c
    struct[0].u_run[201,0] = q_R1_c
    struct[0].u_run[202,0] = p_R11_1
    struct[0].u_run[203,0] = q_R11_1
    struct[0].u_run[204,0] = p_R15_1
    struct[0].u_run[205,0] = q_R15_1
    struct[0].u_run[206,0] = p_R16_1
    struct[0].u_run[207,0] = q_R16_1
    struct[0].u_run[208,0] = p_R17_1
    struct[0].u_run[209,0] = q_R17_1
    struct[0].u_run[210,0] = p_R18_1
    struct[0].u_run[211,0] = q_R18_1
    struct[0].u_run[212,0] = p_D15_1
    struct[0].u_run[213,0] = q_D15_1
    struct[0].u_run[214,0] = p_D11_1
    struct[0].u_run[215,0] = q_D11_1
    struct[0].u_run[216,0] = p_D16_1
    struct[0].u_run[217,0] = q_D16_1
    struct[0].u_run[218,0] = p_D17_1
    struct[0].u_run[219,0] = q_D17_1
    struct[0].u_run[220,0] = p_D18_1
    struct[0].u_run[221,0] = q_D18_1
    struct[0].u_run[222,0] = v_dc_D1
    struct[0].u_run[223,0] = q_R1
    struct[0].u_run[224,0] = p_R10
    struct[0].u_run[225,0] = q_R10
    struct[0].u_run[226,0] = p_R14
    struct[0].u_run[227,0] = q_R14
    struct[0].u_run[228,0] = u_dummy
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = u_dummy - x_dummy
    
    # Algebraic equations:
    if mode == 3:

        struct[0].g[:,:] = np.ascontiguousarray(struct[0].Gy) @ np.ascontiguousarray(struct[0].y_run) + np.ascontiguousarray(struct[0].Gu) @ np.ascontiguousarray(struct[0].u_run)

        struct[0].g[336,0] = i_load_R1_a_i*v_R1_a_i - i_load_R1_a_i*v_R1_n_i + i_load_R1_a_r*v_R1_a_r - i_load_R1_a_r*v_R1_n_r - p_R1_a
        struct[0].g[337,0] = i_load_R1_b_i*v_R1_b_i - i_load_R1_b_i*v_R1_n_i + i_load_R1_b_r*v_R1_b_r - i_load_R1_b_r*v_R1_n_r - p_R1_b
        struct[0].g[338,0] = i_load_R1_c_i*v_R1_c_i - i_load_R1_c_i*v_R1_n_i + i_load_R1_c_r*v_R1_c_r - i_load_R1_c_r*v_R1_n_r - p_R1_c
        struct[0].g[339,0] = -i_load_R1_a_i*v_R1_a_r + i_load_R1_a_i*v_R1_n_r + i_load_R1_a_r*v_R1_a_i - i_load_R1_a_r*v_R1_n_i - q_R1_a
        struct[0].g[340,0] = -i_load_R1_b_i*v_R1_b_r + i_load_R1_b_i*v_R1_n_r + i_load_R1_b_r*v_R1_b_i - i_load_R1_b_r*v_R1_n_i - q_R1_b
        struct[0].g[341,0] = -i_load_R1_c_i*v_R1_c_r + i_load_R1_c_i*v_R1_n_r + i_load_R1_c_r*v_R1_c_i - i_load_R1_c_r*v_R1_n_i - q_R1_c
        struct[0].g[344,0] = 1.0*i_load_R11_a_i*v_R11_a_i - 1.0*i_load_R11_a_i*v_R11_n_i + i_load_R11_a_r*v_R11_a_r - i_load_R11_a_r*v_R11_n_r - p_R11_1
        struct[0].g[345,0] = -1.0*i_load_R11_a_i*v_R11_a_r + 1.0*i_load_R11_a_i*v_R11_n_r + 1.0*i_load_R11_a_r*v_R11_a_i - 1.0*i_load_R11_a_r*v_R11_n_i - q_R11_1
        struct[0].g[348,0] = 1.0*i_load_R15_a_i*v_R15_a_i - 1.0*i_load_R15_a_i*v_R15_n_i + i_load_R15_a_r*v_R15_a_r - i_load_R15_a_r*v_R15_n_r - p_R15_1
        struct[0].g[349,0] = -1.0*i_load_R15_a_i*v_R15_a_r + 1.0*i_load_R15_a_i*v_R15_n_r + 1.0*i_load_R15_a_r*v_R15_a_i - 1.0*i_load_R15_a_r*v_R15_n_i - q_R15_1
        struct[0].g[352,0] = 1.0*i_load_R16_a_i*v_R16_a_i - 1.0*i_load_R16_a_i*v_R16_n_i + i_load_R16_a_r*v_R16_a_r - i_load_R16_a_r*v_R16_n_r - p_R16_1
        struct[0].g[353,0] = -1.0*i_load_R16_a_i*v_R16_a_r + 1.0*i_load_R16_a_i*v_R16_n_r + 1.0*i_load_R16_a_r*v_R16_a_i - 1.0*i_load_R16_a_r*v_R16_n_i - q_R16_1
        struct[0].g[356,0] = 1.0*i_load_R17_a_i*v_R17_a_i - 1.0*i_load_R17_a_i*v_R17_n_i + i_load_R17_a_r*v_R17_a_r - i_load_R17_a_r*v_R17_n_r - p_R17_1
        struct[0].g[357,0] = -1.0*i_load_R17_a_i*v_R17_a_r + 1.0*i_load_R17_a_i*v_R17_n_r + 1.0*i_load_R17_a_r*v_R17_a_i - 1.0*i_load_R17_a_r*v_R17_n_i - q_R17_1
        struct[0].g[360,0] = 1.0*i_load_R18_a_i*v_R18_a_i - 1.0*i_load_R18_a_i*v_R18_n_i + i_load_R18_a_r*v_R18_a_r - i_load_R18_a_r*v_R18_n_r - p_R18_1
        struct[0].g[361,0] = -1.0*i_load_R18_a_i*v_R18_a_r + 1.0*i_load_R18_a_i*v_R18_n_r + 1.0*i_load_R18_a_r*v_R18_a_i - 1.0*i_load_R18_a_r*v_R18_n_i - q_R18_1
        struct[0].g[364,0] = 1.0*i_load_D15_a_i*v_D15_a_i - 1.0*i_load_D15_a_i*v_D15_n_i + i_load_D15_a_r*v_D15_a_r - i_load_D15_a_r*v_D15_n_r - p_D15_1
        struct[0].g[365,0] = -1.0*i_load_D15_a_i*v_D15_a_r + 1.0*i_load_D15_a_i*v_D15_n_r + 1.0*i_load_D15_a_r*v_D15_a_i - 1.0*i_load_D15_a_r*v_D15_n_i - q_D15_1
        struct[0].g[368,0] = 1.0*i_load_D11_a_i*v_D11_a_i - 1.0*i_load_D11_a_i*v_D11_n_i + i_load_D11_a_r*v_D11_a_r - i_load_D11_a_r*v_D11_n_r - p_D11_1
        struct[0].g[369,0] = -1.0*i_load_D11_a_i*v_D11_a_r + 1.0*i_load_D11_a_i*v_D11_n_r + 1.0*i_load_D11_a_r*v_D11_a_i - 1.0*i_load_D11_a_r*v_D11_n_i - q_D11_1
        struct[0].g[372,0] = 1.0*i_load_D16_a_i*v_D16_a_i - 1.0*i_load_D16_a_i*v_D16_n_i + i_load_D16_a_r*v_D16_a_r - i_load_D16_a_r*v_D16_n_r - p_D16_1
        struct[0].g[373,0] = -1.0*i_load_D16_a_i*v_D16_a_r + 1.0*i_load_D16_a_i*v_D16_n_r + 1.0*i_load_D16_a_r*v_D16_a_i - 1.0*i_load_D16_a_r*v_D16_n_i - q_D16_1
        struct[0].g[376,0] = 1.0*i_load_D17_a_i*v_D17_a_i - 1.0*i_load_D17_a_i*v_D17_n_i + i_load_D17_a_r*v_D17_a_r - i_load_D17_a_r*v_D17_n_r - p_D17_1
        struct[0].g[377,0] = -1.0*i_load_D17_a_i*v_D17_a_r + 1.0*i_load_D17_a_i*v_D17_n_r + 1.0*i_load_D17_a_r*v_D17_a_i - 1.0*i_load_D17_a_r*v_D17_n_i - q_D17_1
        struct[0].g[380,0] = 1.0*i_load_D18_a_i*v_D18_a_i - 1.0*i_load_D18_a_i*v_D18_n_i + i_load_D18_a_r*v_D18_a_r - i_load_D18_a_r*v_D18_n_r - p_D18_1
        struct[0].g[381,0] = -1.0*i_load_D18_a_i*v_D18_a_r + 1.0*i_load_D18_a_i*v_D18_n_r + 1.0*i_load_D18_a_r*v_D18_a_i - 1.0*i_load_D18_a_r*v_D18_n_i - q_D18_1
        struct[0].g[384,0] = 1.0*i_vsc_R1_a_i*v_R1_a_i - 1.0*i_vsc_R1_a_i*v_R1_n_i + i_vsc_R1_a_r*v_R1_a_r - i_vsc_R1_a_r*v_R1_n_r - p_R1/3
        struct[0].g[385,0] = -1.0*i_vsc_R1_a_i*v_R1_a_r + 1.0*i_vsc_R1_a_i*v_R1_n_r + 1.0*i_vsc_R1_a_r*v_R1_a_i - 1.0*i_vsc_R1_a_r*v_R1_n_i - q_R1/3
        struct[0].g[386,0] = 1.0*i_vsc_R1_b_i*v_R1_b_i - 1.0*i_vsc_R1_b_i*v_R1_n_i + i_vsc_R1_b_r*v_R1_b_r - i_vsc_R1_b_r*v_R1_n_r - p_R1/3
        struct[0].g[387,0] = -1.0*i_vsc_R1_b_i*v_R1_b_r + 1.0*i_vsc_R1_b_i*v_R1_n_r + 1.0*i_vsc_R1_b_r*v_R1_b_i - 1.0*i_vsc_R1_b_r*v_R1_n_i - q_R1/3
        struct[0].g[388,0] = 1.0*i_vsc_R1_c_i*v_R1_c_i - 1.0*i_vsc_R1_c_i*v_R1_n_i + i_vsc_R1_c_r*v_R1_c_r - i_vsc_R1_c_r*v_R1_n_r - p_R1/3
        struct[0].g[389,0] = -1.0*i_vsc_R1_c_i*v_R1_c_r + 1.0*i_vsc_R1_c_i*v_R1_n_r + 1.0*i_vsc_R1_c_r*v_R1_c_i - 1.0*i_vsc_R1_c_r*v_R1_n_i - q_R1/3
        struct[0].g[390,0] = p_D1 + p_R1 + Piecewise(np.array([(-p_loss_R1, p_D1 < 0), (p_loss_R1, True)]))
        struct[0].g[392,0] = -a_R1 - b_R1*sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - c_R1*(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) + p_loss_R1
        struct[0].g[393,0] = -coef_a_R10*p_R10 + 1.0*i_vsc_R10_a_i*v_R10_a_i - 1.0*i_vsc_R10_a_i*v_R10_n_i + i_vsc_R10_a_r*v_R10_a_r - i_vsc_R10_a_r*v_R10_n_r
        struct[0].g[394,0] = -coef_a_R10*q_R10 - 1.0*i_vsc_R10_a_i*v_R10_a_r + 1.0*i_vsc_R10_a_i*v_R10_n_r + 1.0*i_vsc_R10_a_r*v_R10_a_i - 1.0*i_vsc_R10_a_r*v_R10_n_i
        struct[0].g[395,0] = -coef_b_R10*p_R10 + 1.0*i_vsc_R10_b_i*v_R10_b_i - 1.0*i_vsc_R10_b_i*v_R10_n_i + i_vsc_R10_b_r*v_R10_b_r - i_vsc_R10_b_r*v_R10_n_r
        struct[0].g[396,0] = -coef_b_R10*q_R10 - 1.0*i_vsc_R10_b_i*v_R10_b_r + 1.0*i_vsc_R10_b_i*v_R10_n_r + 1.0*i_vsc_R10_b_r*v_R10_b_i - 1.0*i_vsc_R10_b_r*v_R10_n_i
        struct[0].g[397,0] = -coef_c_R10*p_R10 + 1.0*i_vsc_R10_c_i*v_R10_c_i - 1.0*i_vsc_R10_c_i*v_R10_n_i + i_vsc_R10_c_r*v_R10_c_r - i_vsc_R10_c_r*v_R10_n_r
        struct[0].g[398,0] = -coef_c_R10*q_R10 - 1.0*i_vsc_R10_c_i*v_R10_c_r + 1.0*i_vsc_R10_c_i*v_R10_n_r + 1.0*i_vsc_R10_c_r*v_R10_c_i - 1.0*i_vsc_R10_c_r*v_R10_n_i
        struct[0].g[401,0] = i_vsc_D10_a_r + p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].g[402,0] = i_vsc_D10_n_r + p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].g[403,0] = p_D10 - p_R10 + Piecewise(np.array([(a_R10 + b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), p_D10 < 0), (-a_R10 - b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), p_D10 > 0), (a_R10 + b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), True)]))
        struct[0].g[404,0] = -coef_a_R14*p_R14 + 1.0*i_vsc_R14_a_i*v_R14_a_i - 1.0*i_vsc_R14_a_i*v_R14_n_i + i_vsc_R14_a_r*v_R14_a_r - i_vsc_R14_a_r*v_R14_n_r
        struct[0].g[405,0] = -coef_a_R14*q_R14 - 1.0*i_vsc_R14_a_i*v_R14_a_r + 1.0*i_vsc_R14_a_i*v_R14_n_r + 1.0*i_vsc_R14_a_r*v_R14_a_i - 1.0*i_vsc_R14_a_r*v_R14_n_i
        struct[0].g[406,0] = -coef_b_R14*p_R14 + 1.0*i_vsc_R14_b_i*v_R14_b_i - 1.0*i_vsc_R14_b_i*v_R14_n_i + i_vsc_R14_b_r*v_R14_b_r - i_vsc_R14_b_r*v_R14_n_r
        struct[0].g[407,0] = -coef_b_R14*q_R14 - 1.0*i_vsc_R14_b_i*v_R14_b_r + 1.0*i_vsc_R14_b_i*v_R14_n_r + 1.0*i_vsc_R14_b_r*v_R14_b_i - 1.0*i_vsc_R14_b_r*v_R14_n_i
        struct[0].g[408,0] = -coef_c_R14*p_R14 + 1.0*i_vsc_R14_c_i*v_R14_c_i - 1.0*i_vsc_R14_c_i*v_R14_n_i + i_vsc_R14_c_r*v_R14_c_r - i_vsc_R14_c_r*v_R14_n_r
        struct[0].g[409,0] = -coef_c_R14*q_R14 - 1.0*i_vsc_R14_c_i*v_R14_c_r + 1.0*i_vsc_R14_c_i*v_R14_n_r + 1.0*i_vsc_R14_c_r*v_R14_c_i - 1.0*i_vsc_R14_c_r*v_R14_n_i
        struct[0].g[412,0] = i_vsc_D14_a_r + p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].g[413,0] = i_vsc_D14_n_r + p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].g[414,0] = p_D14 - p_R14 + Piecewise(np.array([(a_R14 + b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), p_D14 < 0), (-a_R14 - b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), p_D14 > 0), (a_R14 + b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), True)]))
    
    # Outputs:
    if mode == 3:

        struct[0].h[0,0] = (v_R0_a_i**2 + v_R0_a_r**2)**0.5
        struct[0].h[1,0] = (v_R0_b_i**2 + v_R0_b_r**2)**0.5
        struct[0].h[2,0] = (v_R0_c_i**2 + v_R0_c_r**2)**0.5
        struct[0].h[3,0] = (v_D1_a_i**2 + v_D1_a_r**2)**0.5
        struct[0].h[4,0] = (v_D1_b_i**2 + v_D1_b_r**2)**0.5
        struct[0].h[5,0] = (v_D1_c_i**2 + v_D1_c_r**2)**0.5
        struct[0].h[6,0] = (v_R1_a_i**2 + v_R1_a_r**2)**0.5
        struct[0].h[7,0] = (v_R1_b_i**2 + v_R1_b_r**2)**0.5
        struct[0].h[8,0] = (v_R1_c_i**2 + v_R1_c_r**2)**0.5
        struct[0].h[9,0] = (v_R1_n_i**2 + v_R1_n_r**2)**0.5
        struct[0].h[10,0] = (v_R11_a_i**2 + v_R11_a_r**2)**0.5
        struct[0].h[11,0] = (v_R11_n_i**2 + v_R11_n_r**2)**0.5
        struct[0].h[12,0] = (v_R15_a_i**2 + v_R15_a_r**2)**0.5
        struct[0].h[13,0] = (v_R15_n_i**2 + v_R15_n_r**2)**0.5
        struct[0].h[14,0] = (v_R16_a_i**2 + v_R16_a_r**2)**0.5
        struct[0].h[15,0] = (v_R16_n_i**2 + v_R16_n_r**2)**0.5
        struct[0].h[16,0] = (v_R17_a_i**2 + v_R17_a_r**2)**0.5
        struct[0].h[17,0] = (v_R17_n_i**2 + v_R17_n_r**2)**0.5
        struct[0].h[18,0] = (v_R18_a_i**2 + v_R18_a_r**2)**0.5
        struct[0].h[19,0] = (v_R18_n_i**2 + v_R18_n_r**2)**0.5
        struct[0].h[20,0] = (v_D15_a_i**2 + v_D15_a_r**2)**0.5
        struct[0].h[21,0] = (v_D15_n_i**2 + v_D15_n_r**2)**0.5
        struct[0].h[22,0] = (v_D11_a_i**2 + v_D11_a_r**2)**0.5
        struct[0].h[23,0] = (v_D11_n_i**2 + v_D11_n_r**2)**0.5
        struct[0].h[24,0] = (v_D16_a_i**2 + v_D16_a_r**2)**0.5
        struct[0].h[25,0] = (v_D16_n_i**2 + v_D16_n_r**2)**0.5
        struct[0].h[26,0] = (v_D17_a_i**2 + v_D17_a_r**2)**0.5
        struct[0].h[27,0] = (v_D17_n_i**2 + v_D17_n_r**2)**0.5
        struct[0].h[28,0] = (v_D18_a_i**2 + v_D18_a_r**2)**0.5
        struct[0].h[29,0] = (v_D18_n_i**2 + v_D18_n_r**2)**0.5
        struct[0].h[30,0] = (v_R2_a_i**2 + v_R2_a_r**2)**0.5
        struct[0].h[31,0] = (v_R2_b_i**2 + v_R2_b_r**2)**0.5
        struct[0].h[32,0] = (v_R2_c_i**2 + v_R2_c_r**2)**0.5
        struct[0].h[33,0] = (v_R2_n_i**2 + v_R2_n_r**2)**0.5
        struct[0].h[34,0] = (v_R3_a_i**2 + v_R3_a_r**2)**0.5
        struct[0].h[35,0] = (v_R3_b_i**2 + v_R3_b_r**2)**0.5
        struct[0].h[36,0] = (v_R3_c_i**2 + v_R3_c_r**2)**0.5
        struct[0].h[37,0] = (v_R3_n_i**2 + v_R3_n_r**2)**0.5
        struct[0].h[38,0] = (v_R4_a_i**2 + v_R4_a_r**2)**0.5
        struct[0].h[39,0] = (v_R4_b_i**2 + v_R4_b_r**2)**0.5
        struct[0].h[40,0] = (v_R4_c_i**2 + v_R4_c_r**2)**0.5
        struct[0].h[41,0] = (v_R4_n_i**2 + v_R4_n_r**2)**0.5
        struct[0].h[42,0] = (v_R5_a_i**2 + v_R5_a_r**2)**0.5
        struct[0].h[43,0] = (v_R5_b_i**2 + v_R5_b_r**2)**0.5
        struct[0].h[44,0] = (v_R5_c_i**2 + v_R5_c_r**2)**0.5
        struct[0].h[45,0] = (v_R5_n_i**2 + v_R5_n_r**2)**0.5
        struct[0].h[46,0] = (v_R6_a_i**2 + v_R6_a_r**2)**0.5
        struct[0].h[47,0] = (v_R6_b_i**2 + v_R6_b_r**2)**0.5
        struct[0].h[48,0] = (v_R6_c_i**2 + v_R6_c_r**2)**0.5
        struct[0].h[49,0] = (v_R6_n_i**2 + v_R6_n_r**2)**0.5
        struct[0].h[50,0] = (v_R7_a_i**2 + v_R7_a_r**2)**0.5
        struct[0].h[51,0] = (v_R7_b_i**2 + v_R7_b_r**2)**0.5
        struct[0].h[52,0] = (v_R7_c_i**2 + v_R7_c_r**2)**0.5
        struct[0].h[53,0] = (v_R7_n_i**2 + v_R7_n_r**2)**0.5
        struct[0].h[54,0] = (v_R8_a_i**2 + v_R8_a_r**2)**0.5
        struct[0].h[55,0] = (v_R8_b_i**2 + v_R8_b_r**2)**0.5
        struct[0].h[56,0] = (v_R8_c_i**2 + v_R8_c_r**2)**0.5
        struct[0].h[57,0] = (v_R8_n_i**2 + v_R8_n_r**2)**0.5
        struct[0].h[58,0] = (v_R9_a_i**2 + v_R9_a_r**2)**0.5
        struct[0].h[59,0] = (v_R9_b_i**2 + v_R9_b_r**2)**0.5
        struct[0].h[60,0] = (v_R9_c_i**2 + v_R9_c_r**2)**0.5
        struct[0].h[61,0] = (v_R9_n_i**2 + v_R9_n_r**2)**0.5
        struct[0].h[62,0] = (v_R10_a_i**2 + v_R10_a_r**2)**0.5
        struct[0].h[63,0] = (v_R10_b_i**2 + v_R10_b_r**2)**0.5
        struct[0].h[64,0] = (v_R10_c_i**2 + v_R10_c_r**2)**0.5
        struct[0].h[65,0] = (v_R10_n_i**2 + v_R10_n_r**2)**0.5
        struct[0].h[66,0] = (v_R11_b_i**2 + v_R11_b_r**2)**0.5
        struct[0].h[67,0] = (v_R11_c_i**2 + v_R11_c_r**2)**0.5
        struct[0].h[68,0] = (v_R12_a_i**2 + v_R12_a_r**2)**0.5
        struct[0].h[69,0] = (v_R12_b_i**2 + v_R12_b_r**2)**0.5
        struct[0].h[70,0] = (v_R12_c_i**2 + v_R12_c_r**2)**0.5
        struct[0].h[71,0] = (v_R12_n_i**2 + v_R12_n_r**2)**0.5
        struct[0].h[72,0] = (v_R13_a_i**2 + v_R13_a_r**2)**0.5
        struct[0].h[73,0] = (v_R13_b_i**2 + v_R13_b_r**2)**0.5
        struct[0].h[74,0] = (v_R13_c_i**2 + v_R13_c_r**2)**0.5
        struct[0].h[75,0] = (v_R13_n_i**2 + v_R13_n_r**2)**0.5
        struct[0].h[76,0] = (v_R14_a_i**2 + v_R14_a_r**2)**0.5
        struct[0].h[77,0] = (v_R14_b_i**2 + v_R14_b_r**2)**0.5
        struct[0].h[78,0] = (v_R14_c_i**2 + v_R14_c_r**2)**0.5
        struct[0].h[79,0] = (v_R14_n_i**2 + v_R14_n_r**2)**0.5
        struct[0].h[80,0] = (v_R15_b_i**2 + v_R15_b_r**2)**0.5
        struct[0].h[81,0] = (v_R15_c_i**2 + v_R15_c_r**2)**0.5
        struct[0].h[82,0] = (v_R16_b_i**2 + v_R16_b_r**2)**0.5
        struct[0].h[83,0] = (v_R16_c_i**2 + v_R16_c_r**2)**0.5
        struct[0].h[84,0] = (v_R17_b_i**2 + v_R17_b_r**2)**0.5
        struct[0].h[85,0] = (v_R17_c_i**2 + v_R17_c_r**2)**0.5
        struct[0].h[86,0] = (v_R18_b_i**2 + v_R18_b_r**2)**0.5
        struct[0].h[87,0] = (v_R18_c_i**2 + v_R18_c_r**2)**0.5
        struct[0].h[88,0] = (v_D1_n_i**2 + v_D1_n_r**2)**0.5
        struct[0].h[89,0] = (v_D3_a_i**2 + v_D3_a_r**2)**0.5
        struct[0].h[90,0] = (v_D3_b_i**2 + v_D3_b_r**2)**0.5
        struct[0].h[91,0] = (v_D3_c_i**2 + v_D3_c_r**2)**0.5
        struct[0].h[92,0] = (v_D3_n_i**2 + v_D3_n_r**2)**0.5
        struct[0].h[93,0] = (v_D4_a_i**2 + v_D4_a_r**2)**0.5
        struct[0].h[94,0] = (v_D4_b_i**2 + v_D4_b_r**2)**0.5
        struct[0].h[95,0] = (v_D4_c_i**2 + v_D4_c_r**2)**0.5
        struct[0].h[96,0] = (v_D4_n_i**2 + v_D4_n_r**2)**0.5
        struct[0].h[97,0] = (v_D6_a_i**2 + v_D6_a_r**2)**0.5
        struct[0].h[98,0] = (v_D6_b_i**2 + v_D6_b_r**2)**0.5
        struct[0].h[99,0] = (v_D6_c_i**2 + v_D6_c_r**2)**0.5
        struct[0].h[100,0] = (v_D6_n_i**2 + v_D6_n_r**2)**0.5
        struct[0].h[101,0] = (v_D9_a_i**2 + v_D9_a_r**2)**0.5
        struct[0].h[102,0] = (v_D9_b_i**2 + v_D9_b_r**2)**0.5
        struct[0].h[103,0] = (v_D9_c_i**2 + v_D9_c_r**2)**0.5
        struct[0].h[104,0] = (v_D9_n_i**2 + v_D9_n_r**2)**0.5
        struct[0].h[105,0] = (v_D10_a_i**2 + v_D10_a_r**2)**0.5
        struct[0].h[106,0] = (v_D10_b_i**2 + v_D10_b_r**2)**0.5
        struct[0].h[107,0] = (v_D10_c_i**2 + v_D10_c_r**2)**0.5
        struct[0].h[108,0] = (v_D10_n_i**2 + v_D10_n_r**2)**0.5
        struct[0].h[109,0] = (v_D11_b_i**2 + v_D11_b_r**2)**0.5
        struct[0].h[110,0] = (v_D11_c_i**2 + v_D11_c_r**2)**0.5
        struct[0].h[111,0] = (v_D16_b_i**2 + v_D16_b_r**2)**0.5
        struct[0].h[112,0] = (v_D16_c_i**2 + v_D16_c_r**2)**0.5
        struct[0].h[113,0] = (v_D17_b_i**2 + v_D17_b_r**2)**0.5
        struct[0].h[114,0] = (v_D17_c_i**2 + v_D17_c_r**2)**0.5
        struct[0].h[115,0] = (v_D18_b_i**2 + v_D18_b_r**2)**0.5
        struct[0].h[116,0] = (v_D18_c_i**2 + v_D18_c_r**2)**0.5
        struct[0].h[117,0] = (v_D14_a_i**2 + v_D14_a_r**2)**0.5
        struct[0].h[118,0] = (v_D14_b_i**2 + v_D14_b_r**2)**0.5
        struct[0].h[119,0] = (v_D14_c_i**2 + v_D14_c_r**2)**0.5
        struct[0].h[120,0] = (v_D14_n_i**2 + v_D14_n_r**2)**0.5
        struct[0].h[121,0] = (v_D15_b_i**2 + v_D15_b_r**2)**0.5
        struct[0].h[122,0] = (v_D15_c_i**2 + v_D15_c_r**2)**0.5
    

    if mode == 10:

        pass

    if mode == 11:



        struct[0].Gy[336,0] = i_load_R1_a_r
        struct[0].Gy[336,1] = i_load_R1_a_i
        struct[0].Gy[336,6] = -i_load_R1_a_r
        struct[0].Gy[336,7] = -i_load_R1_a_i
        struct[0].Gy[336,336] = v_R1_a_r - v_R1_n_r
        struct[0].Gy[336,337] = v_R1_a_i - v_R1_n_i
        struct[0].Gy[337,2] = i_load_R1_b_r
        struct[0].Gy[337,3] = i_load_R1_b_i
        struct[0].Gy[337,6] = -i_load_R1_b_r
        struct[0].Gy[337,7] = -i_load_R1_b_i
        struct[0].Gy[337,338] = v_R1_b_r - v_R1_n_r
        struct[0].Gy[337,339] = v_R1_b_i - v_R1_n_i
        struct[0].Gy[338,4] = i_load_R1_c_r
        struct[0].Gy[338,5] = i_load_R1_c_i
        struct[0].Gy[338,6] = -i_load_R1_c_r
        struct[0].Gy[338,7] = -i_load_R1_c_i
        struct[0].Gy[338,340] = v_R1_c_r - v_R1_n_r
        struct[0].Gy[338,341] = v_R1_c_i - v_R1_n_i
        struct[0].Gy[339,0] = -i_load_R1_a_i
        struct[0].Gy[339,1] = i_load_R1_a_r
        struct[0].Gy[339,6] = i_load_R1_a_i
        struct[0].Gy[339,7] = -i_load_R1_a_r
        struct[0].Gy[339,336] = v_R1_a_i - v_R1_n_i
        struct[0].Gy[339,337] = -v_R1_a_r + v_R1_n_r
        struct[0].Gy[340,2] = -i_load_R1_b_i
        struct[0].Gy[340,3] = i_load_R1_b_r
        struct[0].Gy[340,6] = i_load_R1_b_i
        struct[0].Gy[340,7] = -i_load_R1_b_r
        struct[0].Gy[340,338] = v_R1_b_i - v_R1_n_i
        struct[0].Gy[340,339] = -v_R1_b_r + v_R1_n_r
        struct[0].Gy[341,4] = -i_load_R1_c_i
        struct[0].Gy[341,5] = i_load_R1_c_r
        struct[0].Gy[341,6] = i_load_R1_c_i
        struct[0].Gy[341,7] = -i_load_R1_c_r
        struct[0].Gy[341,340] = v_R1_c_i - v_R1_n_i
        struct[0].Gy[341,341] = -v_R1_c_r + v_R1_n_r
        struct[0].Gy[344,8] = i_load_R11_a_r
        struct[0].Gy[344,9] = 1.0*i_load_R11_a_i
        struct[0].Gy[344,10] = -i_load_R11_a_r
        struct[0].Gy[344,11] = -1.0*i_load_R11_a_i
        struct[0].Gy[344,344] = v_R11_a_r - v_R11_n_r
        struct[0].Gy[344,345] = 1.0*v_R11_a_i - 1.0*v_R11_n_i
        struct[0].Gy[345,8] = -1.0*i_load_R11_a_i
        struct[0].Gy[345,9] = 1.0*i_load_R11_a_r
        struct[0].Gy[345,10] = 1.0*i_load_R11_a_i
        struct[0].Gy[345,11] = -1.0*i_load_R11_a_r
        struct[0].Gy[345,344] = 1.0*v_R11_a_i - 1.0*v_R11_n_i
        struct[0].Gy[345,345] = -1.0*v_R11_a_r + 1.0*v_R11_n_r
        struct[0].Gy[348,12] = i_load_R15_a_r
        struct[0].Gy[348,13] = 1.0*i_load_R15_a_i
        struct[0].Gy[348,14] = -i_load_R15_a_r
        struct[0].Gy[348,15] = -1.0*i_load_R15_a_i
        struct[0].Gy[348,348] = v_R15_a_r - v_R15_n_r
        struct[0].Gy[348,349] = 1.0*v_R15_a_i - 1.0*v_R15_n_i
        struct[0].Gy[349,12] = -1.0*i_load_R15_a_i
        struct[0].Gy[349,13] = 1.0*i_load_R15_a_r
        struct[0].Gy[349,14] = 1.0*i_load_R15_a_i
        struct[0].Gy[349,15] = -1.0*i_load_R15_a_r
        struct[0].Gy[349,348] = 1.0*v_R15_a_i - 1.0*v_R15_n_i
        struct[0].Gy[349,349] = -1.0*v_R15_a_r + 1.0*v_R15_n_r
        struct[0].Gy[352,16] = i_load_R16_a_r
        struct[0].Gy[352,17] = 1.0*i_load_R16_a_i
        struct[0].Gy[352,18] = -i_load_R16_a_r
        struct[0].Gy[352,19] = -1.0*i_load_R16_a_i
        struct[0].Gy[352,352] = v_R16_a_r - v_R16_n_r
        struct[0].Gy[352,353] = 1.0*v_R16_a_i - 1.0*v_R16_n_i
        struct[0].Gy[353,16] = -1.0*i_load_R16_a_i
        struct[0].Gy[353,17] = 1.0*i_load_R16_a_r
        struct[0].Gy[353,18] = 1.0*i_load_R16_a_i
        struct[0].Gy[353,19] = -1.0*i_load_R16_a_r
        struct[0].Gy[353,352] = 1.0*v_R16_a_i - 1.0*v_R16_n_i
        struct[0].Gy[353,353] = -1.0*v_R16_a_r + 1.0*v_R16_n_r
        struct[0].Gy[356,20] = i_load_R17_a_r
        struct[0].Gy[356,21] = 1.0*i_load_R17_a_i
        struct[0].Gy[356,22] = -i_load_R17_a_r
        struct[0].Gy[356,23] = -1.0*i_load_R17_a_i
        struct[0].Gy[356,356] = v_R17_a_r - v_R17_n_r
        struct[0].Gy[356,357] = 1.0*v_R17_a_i - 1.0*v_R17_n_i
        struct[0].Gy[357,20] = -1.0*i_load_R17_a_i
        struct[0].Gy[357,21] = 1.0*i_load_R17_a_r
        struct[0].Gy[357,22] = 1.0*i_load_R17_a_i
        struct[0].Gy[357,23] = -1.0*i_load_R17_a_r
        struct[0].Gy[357,356] = 1.0*v_R17_a_i - 1.0*v_R17_n_i
        struct[0].Gy[357,357] = -1.0*v_R17_a_r + 1.0*v_R17_n_r
        struct[0].Gy[360,24] = i_load_R18_a_r
        struct[0].Gy[360,25] = 1.0*i_load_R18_a_i
        struct[0].Gy[360,26] = -i_load_R18_a_r
        struct[0].Gy[360,27] = -1.0*i_load_R18_a_i
        struct[0].Gy[360,360] = v_R18_a_r - v_R18_n_r
        struct[0].Gy[360,361] = 1.0*v_R18_a_i - 1.0*v_R18_n_i
        struct[0].Gy[361,24] = -1.0*i_load_R18_a_i
        struct[0].Gy[361,25] = 1.0*i_load_R18_a_r
        struct[0].Gy[361,26] = 1.0*i_load_R18_a_i
        struct[0].Gy[361,27] = -1.0*i_load_R18_a_r
        struct[0].Gy[361,360] = 1.0*v_R18_a_i - 1.0*v_R18_n_i
        struct[0].Gy[361,361] = -1.0*v_R18_a_r + 1.0*v_R18_n_r
        struct[0].Gy[364,28] = i_load_D15_a_r
        struct[0].Gy[364,29] = 1.0*i_load_D15_a_i
        struct[0].Gy[364,30] = -i_load_D15_a_r
        struct[0].Gy[364,31] = -1.0*i_load_D15_a_i
        struct[0].Gy[364,364] = v_D15_a_r - v_D15_n_r
        struct[0].Gy[364,365] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy[365,28] = -1.0*i_load_D15_a_i
        struct[0].Gy[365,29] = 1.0*i_load_D15_a_r
        struct[0].Gy[365,30] = 1.0*i_load_D15_a_i
        struct[0].Gy[365,31] = -1.0*i_load_D15_a_r
        struct[0].Gy[365,364] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy[365,365] = -1.0*v_D15_a_r + 1.0*v_D15_n_r
        struct[0].Gy[368,32] = i_load_D11_a_r
        struct[0].Gy[368,33] = 1.0*i_load_D11_a_i
        struct[0].Gy[368,34] = -i_load_D11_a_r
        struct[0].Gy[368,35] = -1.0*i_load_D11_a_i
        struct[0].Gy[368,368] = v_D11_a_r - v_D11_n_r
        struct[0].Gy[368,369] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy[369,32] = -1.0*i_load_D11_a_i
        struct[0].Gy[369,33] = 1.0*i_load_D11_a_r
        struct[0].Gy[369,34] = 1.0*i_load_D11_a_i
        struct[0].Gy[369,35] = -1.0*i_load_D11_a_r
        struct[0].Gy[369,368] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy[369,369] = -1.0*v_D11_a_r + 1.0*v_D11_n_r
        struct[0].Gy[372,36] = i_load_D16_a_r
        struct[0].Gy[372,37] = 1.0*i_load_D16_a_i
        struct[0].Gy[372,38] = -i_load_D16_a_r
        struct[0].Gy[372,39] = -1.0*i_load_D16_a_i
        struct[0].Gy[372,372] = v_D16_a_r - v_D16_n_r
        struct[0].Gy[372,373] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy[373,36] = -1.0*i_load_D16_a_i
        struct[0].Gy[373,37] = 1.0*i_load_D16_a_r
        struct[0].Gy[373,38] = 1.0*i_load_D16_a_i
        struct[0].Gy[373,39] = -1.0*i_load_D16_a_r
        struct[0].Gy[373,372] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy[373,373] = -1.0*v_D16_a_r + 1.0*v_D16_n_r
        struct[0].Gy[376,40] = i_load_D17_a_r
        struct[0].Gy[376,41] = 1.0*i_load_D17_a_i
        struct[0].Gy[376,42] = -i_load_D17_a_r
        struct[0].Gy[376,43] = -1.0*i_load_D17_a_i
        struct[0].Gy[376,376] = v_D17_a_r - v_D17_n_r
        struct[0].Gy[376,377] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy[377,40] = -1.0*i_load_D17_a_i
        struct[0].Gy[377,41] = 1.0*i_load_D17_a_r
        struct[0].Gy[377,42] = 1.0*i_load_D17_a_i
        struct[0].Gy[377,43] = -1.0*i_load_D17_a_r
        struct[0].Gy[377,376] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy[377,377] = -1.0*v_D17_a_r + 1.0*v_D17_n_r
        struct[0].Gy[380,44] = i_load_D18_a_r
        struct[0].Gy[380,45] = 1.0*i_load_D18_a_i
        struct[0].Gy[380,46] = -i_load_D18_a_r
        struct[0].Gy[380,47] = -1.0*i_load_D18_a_i
        struct[0].Gy[380,380] = v_D18_a_r - v_D18_n_r
        struct[0].Gy[380,381] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy[381,44] = -1.0*i_load_D18_a_i
        struct[0].Gy[381,45] = 1.0*i_load_D18_a_r
        struct[0].Gy[381,46] = 1.0*i_load_D18_a_i
        struct[0].Gy[381,47] = -1.0*i_load_D18_a_r
        struct[0].Gy[381,380] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy[381,381] = -1.0*v_D18_a_r + 1.0*v_D18_n_r
        struct[0].Gy[384,0] = i_vsc_R1_a_r
        struct[0].Gy[384,1] = 1.0*i_vsc_R1_a_i
        struct[0].Gy[384,6] = -i_vsc_R1_a_r
        struct[0].Gy[384,7] = -1.0*i_vsc_R1_a_i
        struct[0].Gy[384,384] = v_R1_a_r - v_R1_n_r
        struct[0].Gy[384,385] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy[385,0] = -1.0*i_vsc_R1_a_i
        struct[0].Gy[385,1] = 1.0*i_vsc_R1_a_r
        struct[0].Gy[385,6] = 1.0*i_vsc_R1_a_i
        struct[0].Gy[385,7] = -1.0*i_vsc_R1_a_r
        struct[0].Gy[385,384] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy[385,385] = -1.0*v_R1_a_r + 1.0*v_R1_n_r
        struct[0].Gy[386,2] = i_vsc_R1_b_r
        struct[0].Gy[386,3] = 1.0*i_vsc_R1_b_i
        struct[0].Gy[386,6] = -i_vsc_R1_b_r
        struct[0].Gy[386,7] = -1.0*i_vsc_R1_b_i
        struct[0].Gy[386,386] = v_R1_b_r - v_R1_n_r
        struct[0].Gy[386,387] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy[387,2] = -1.0*i_vsc_R1_b_i
        struct[0].Gy[387,3] = 1.0*i_vsc_R1_b_r
        struct[0].Gy[387,6] = 1.0*i_vsc_R1_b_i
        struct[0].Gy[387,7] = -1.0*i_vsc_R1_b_r
        struct[0].Gy[387,386] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy[387,387] = -1.0*v_R1_b_r + 1.0*v_R1_n_r
        struct[0].Gy[388,4] = i_vsc_R1_c_r
        struct[0].Gy[388,5] = 1.0*i_vsc_R1_c_i
        struct[0].Gy[388,6] = -i_vsc_R1_c_r
        struct[0].Gy[388,7] = -1.0*i_vsc_R1_c_i
        struct[0].Gy[388,388] = v_R1_c_r - v_R1_n_r
        struct[0].Gy[388,389] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy[389,4] = -1.0*i_vsc_R1_c_i
        struct[0].Gy[389,5] = 1.0*i_vsc_R1_c_r
        struct[0].Gy[389,6] = 1.0*i_vsc_R1_c_i
        struct[0].Gy[389,7] = -1.0*i_vsc_R1_c_r
        struct[0].Gy[389,388] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy[389,389] = -1.0*v_R1_c_r + 1.0*v_R1_n_r
        struct[0].Gy[390,392] = Piecewise(np.array([(-1, p_D1 < 0), (1, True)]))
        struct[0].Gy[391,248] = v_D1_a_r
        struct[0].Gy[391,254] = v_D1_n_r
        struct[0].Gy[392,384] = -b_R1*i_vsc_R1_a_r/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_r
        struct[0].Gy[392,385] = -b_R1*i_vsc_R1_a_i/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_i
        struct[0].Gy[393,112] = i_vsc_R10_a_r
        struct[0].Gy[393,113] = 1.0*i_vsc_R10_a_i
        struct[0].Gy[393,118] = -i_vsc_R10_a_r
        struct[0].Gy[393,119] = -1.0*i_vsc_R10_a_i
        struct[0].Gy[393,393] = v_R10_a_r - v_R10_n_r
        struct[0].Gy[393,394] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy[394,112] = -1.0*i_vsc_R10_a_i
        struct[0].Gy[394,113] = 1.0*i_vsc_R10_a_r
        struct[0].Gy[394,118] = 1.0*i_vsc_R10_a_i
        struct[0].Gy[394,119] = -1.0*i_vsc_R10_a_r
        struct[0].Gy[394,393] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy[394,394] = -1.0*v_R10_a_r + 1.0*v_R10_n_r
        struct[0].Gy[395,114] = i_vsc_R10_b_r
        struct[0].Gy[395,115] = 1.0*i_vsc_R10_b_i
        struct[0].Gy[395,118] = -i_vsc_R10_b_r
        struct[0].Gy[395,119] = -1.0*i_vsc_R10_b_i
        struct[0].Gy[395,395] = v_R10_b_r - v_R10_n_r
        struct[0].Gy[395,396] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy[396,114] = -1.0*i_vsc_R10_b_i
        struct[0].Gy[396,115] = 1.0*i_vsc_R10_b_r
        struct[0].Gy[396,118] = 1.0*i_vsc_R10_b_i
        struct[0].Gy[396,119] = -1.0*i_vsc_R10_b_r
        struct[0].Gy[396,395] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy[396,396] = -1.0*v_R10_b_r + 1.0*v_R10_n_r
        struct[0].Gy[397,116] = i_vsc_R10_c_r
        struct[0].Gy[397,117] = 1.0*i_vsc_R10_c_i
        struct[0].Gy[397,118] = -i_vsc_R10_c_r
        struct[0].Gy[397,119] = -1.0*i_vsc_R10_c_i
        struct[0].Gy[397,397] = v_R10_c_r - v_R10_n_r
        struct[0].Gy[397,398] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy[398,116] = -1.0*i_vsc_R10_c_i
        struct[0].Gy[398,117] = 1.0*i_vsc_R10_c_r
        struct[0].Gy[398,118] = 1.0*i_vsc_R10_c_i
        struct[0].Gy[398,119] = -1.0*i_vsc_R10_c_r
        struct[0].Gy[398,397] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy[398,398] = -1.0*v_R10_c_r + 1.0*v_R10_n_r
        struct[0].Gy[401,198] = -p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[401,204] = p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[401,403] = 1/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].Gy[402,198] = p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[402,204] = -p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[402,403] = 1/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].Gy[403,393] = Piecewise(np.array([(b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_r, p_D10 < 0), (-b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_r, p_D10 > 0), (b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_r, True)]))
        struct[0].Gy[403,394] = Piecewise(np.array([(b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_i, p_D10 < 0), (-b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_i, p_D10 > 0), (b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_i, True)]))
        struct[0].Gy[404,140] = i_vsc_R14_a_r
        struct[0].Gy[404,141] = 1.0*i_vsc_R14_a_i
        struct[0].Gy[404,146] = -i_vsc_R14_a_r
        struct[0].Gy[404,147] = -1.0*i_vsc_R14_a_i
        struct[0].Gy[404,404] = v_R14_a_r - v_R14_n_r
        struct[0].Gy[404,405] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy[405,140] = -1.0*i_vsc_R14_a_i
        struct[0].Gy[405,141] = 1.0*i_vsc_R14_a_r
        struct[0].Gy[405,146] = 1.0*i_vsc_R14_a_i
        struct[0].Gy[405,147] = -1.0*i_vsc_R14_a_r
        struct[0].Gy[405,404] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy[405,405] = -1.0*v_R14_a_r + 1.0*v_R14_n_r
        struct[0].Gy[406,142] = i_vsc_R14_b_r
        struct[0].Gy[406,143] = 1.0*i_vsc_R14_b_i
        struct[0].Gy[406,146] = -i_vsc_R14_b_r
        struct[0].Gy[406,147] = -1.0*i_vsc_R14_b_i
        struct[0].Gy[406,406] = v_R14_b_r - v_R14_n_r
        struct[0].Gy[406,407] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy[407,142] = -1.0*i_vsc_R14_b_i
        struct[0].Gy[407,143] = 1.0*i_vsc_R14_b_r
        struct[0].Gy[407,146] = 1.0*i_vsc_R14_b_i
        struct[0].Gy[407,147] = -1.0*i_vsc_R14_b_r
        struct[0].Gy[407,406] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy[407,407] = -1.0*v_R14_b_r + 1.0*v_R14_n_r
        struct[0].Gy[408,144] = i_vsc_R14_c_r
        struct[0].Gy[408,145] = 1.0*i_vsc_R14_c_i
        struct[0].Gy[408,146] = -i_vsc_R14_c_r
        struct[0].Gy[408,147] = -1.0*i_vsc_R14_c_i
        struct[0].Gy[408,408] = v_R14_c_r - v_R14_n_r
        struct[0].Gy[408,409] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy[409,144] = -1.0*i_vsc_R14_c_i
        struct[0].Gy[409,145] = 1.0*i_vsc_R14_c_r
        struct[0].Gy[409,146] = 1.0*i_vsc_R14_c_i
        struct[0].Gy[409,147] = -1.0*i_vsc_R14_c_r
        struct[0].Gy[409,408] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy[409,409] = -1.0*v_R14_c_r + 1.0*v_R14_n_r
        struct[0].Gy[412,222] = -p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[412,228] = p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[412,414] = 1/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].Gy[413,222] = p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[413,228] = -p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[413,414] = 1/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].Gy[414,404] = Piecewise(np.array([(b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_r, p_D14 < 0), (-b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_r, p_D14 > 0), (b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_r, True)]))
        struct[0].Gy[414,405] = Piecewise(np.array([(b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_i, p_D14 < 0), (-b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_i, p_D14 > 0), (b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_i, True)]))

    if mode > 12:


        struct[0].Gu[393,224] = -coef_a_R10
        struct[0].Gu[394,225] = -coef_a_R10
        struct[0].Gu[395,224] = -coef_b_R10
        struct[0].Gu[396,225] = -coef_b_R10
        struct[0].Gu[397,224] = -coef_c_R10
        struct[0].Gu[398,225] = -coef_c_R10
        struct[0].Gu[404,226] = -coef_a_R14
        struct[0].Gu[405,227] = -coef_a_R14
        struct[0].Gu[406,226] = -coef_b_R14
        struct[0].Gu[407,227] = -coef_b_R14
        struct[0].Gu[408,226] = -coef_c_R14
        struct[0].Gu[409,227] = -coef_c_R14


        struct[0].Hy[6,0] = 1.0*v_R1_a_r*(v_R1_a_i**2 + v_R1_a_r**2)**(-0.5)
        struct[0].Hy[6,1] = 1.0*v_R1_a_i*(v_R1_a_i**2 + v_R1_a_r**2)**(-0.5)
        struct[0].Hy[7,2] = 1.0*v_R1_b_r*(v_R1_b_i**2 + v_R1_b_r**2)**(-0.5)
        struct[0].Hy[7,3] = 1.0*v_R1_b_i*(v_R1_b_i**2 + v_R1_b_r**2)**(-0.5)
        struct[0].Hy[8,4] = 1.0*v_R1_c_r*(v_R1_c_i**2 + v_R1_c_r**2)**(-0.5)
        struct[0].Hy[8,5] = 1.0*v_R1_c_i*(v_R1_c_i**2 + v_R1_c_r**2)**(-0.5)
        struct[0].Hy[9,6] = 1.0*v_R1_n_r*(v_R1_n_i**2 + v_R1_n_r**2)**(-0.5)
        struct[0].Hy[9,7] = 1.0*v_R1_n_i*(v_R1_n_i**2 + v_R1_n_r**2)**(-0.5)
        struct[0].Hy[10,8] = 1.0*v_R11_a_r*(v_R11_a_i**2 + v_R11_a_r**2)**(-0.5)
        struct[0].Hy[10,9] = 1.0*v_R11_a_i*(v_R11_a_i**2 + v_R11_a_r**2)**(-0.5)
        struct[0].Hy[11,10] = 1.0*v_R11_n_r*(v_R11_n_i**2 + v_R11_n_r**2)**(-0.5)
        struct[0].Hy[11,11] = 1.0*v_R11_n_i*(v_R11_n_i**2 + v_R11_n_r**2)**(-0.5)
        struct[0].Hy[12,12] = 1.0*v_R15_a_r*(v_R15_a_i**2 + v_R15_a_r**2)**(-0.5)
        struct[0].Hy[12,13] = 1.0*v_R15_a_i*(v_R15_a_i**2 + v_R15_a_r**2)**(-0.5)
        struct[0].Hy[13,14] = 1.0*v_R15_n_r*(v_R15_n_i**2 + v_R15_n_r**2)**(-0.5)
        struct[0].Hy[13,15] = 1.0*v_R15_n_i*(v_R15_n_i**2 + v_R15_n_r**2)**(-0.5)
        struct[0].Hy[14,16] = 1.0*v_R16_a_r*(v_R16_a_i**2 + v_R16_a_r**2)**(-0.5)
        struct[0].Hy[14,17] = 1.0*v_R16_a_i*(v_R16_a_i**2 + v_R16_a_r**2)**(-0.5)
        struct[0].Hy[15,18] = 1.0*v_R16_n_r*(v_R16_n_i**2 + v_R16_n_r**2)**(-0.5)
        struct[0].Hy[15,19] = 1.0*v_R16_n_i*(v_R16_n_i**2 + v_R16_n_r**2)**(-0.5)
        struct[0].Hy[16,20] = 1.0*v_R17_a_r*(v_R17_a_i**2 + v_R17_a_r**2)**(-0.5)
        struct[0].Hy[16,21] = 1.0*v_R17_a_i*(v_R17_a_i**2 + v_R17_a_r**2)**(-0.5)
        struct[0].Hy[17,22] = 1.0*v_R17_n_r*(v_R17_n_i**2 + v_R17_n_r**2)**(-0.5)
        struct[0].Hy[17,23] = 1.0*v_R17_n_i*(v_R17_n_i**2 + v_R17_n_r**2)**(-0.5)
        struct[0].Hy[18,24] = 1.0*v_R18_a_r*(v_R18_a_i**2 + v_R18_a_r**2)**(-0.5)
        struct[0].Hy[18,25] = 1.0*v_R18_a_i*(v_R18_a_i**2 + v_R18_a_r**2)**(-0.5)
        struct[0].Hy[19,26] = 1.0*v_R18_n_r*(v_R18_n_i**2 + v_R18_n_r**2)**(-0.5)
        struct[0].Hy[19,27] = 1.0*v_R18_n_i*(v_R18_n_i**2 + v_R18_n_r**2)**(-0.5)
        struct[0].Hy[20,28] = 1.0*v_D15_a_r*(v_D15_a_i**2 + v_D15_a_r**2)**(-0.5)
        struct[0].Hy[20,29] = 1.0*v_D15_a_i*(v_D15_a_i**2 + v_D15_a_r**2)**(-0.5)
        struct[0].Hy[21,30] = 1.0*v_D15_n_r*(v_D15_n_i**2 + v_D15_n_r**2)**(-0.5)
        struct[0].Hy[21,31] = 1.0*v_D15_n_i*(v_D15_n_i**2 + v_D15_n_r**2)**(-0.5)
        struct[0].Hy[22,32] = 1.0*v_D11_a_r*(v_D11_a_i**2 + v_D11_a_r**2)**(-0.5)
        struct[0].Hy[22,33] = 1.0*v_D11_a_i*(v_D11_a_i**2 + v_D11_a_r**2)**(-0.5)
        struct[0].Hy[23,34] = 1.0*v_D11_n_r*(v_D11_n_i**2 + v_D11_n_r**2)**(-0.5)
        struct[0].Hy[23,35] = 1.0*v_D11_n_i*(v_D11_n_i**2 + v_D11_n_r**2)**(-0.5)
        struct[0].Hy[24,36] = 1.0*v_D16_a_r*(v_D16_a_i**2 + v_D16_a_r**2)**(-0.5)
        struct[0].Hy[24,37] = 1.0*v_D16_a_i*(v_D16_a_i**2 + v_D16_a_r**2)**(-0.5)
        struct[0].Hy[25,38] = 1.0*v_D16_n_r*(v_D16_n_i**2 + v_D16_n_r**2)**(-0.5)
        struct[0].Hy[25,39] = 1.0*v_D16_n_i*(v_D16_n_i**2 + v_D16_n_r**2)**(-0.5)
        struct[0].Hy[26,40] = 1.0*v_D17_a_r*(v_D17_a_i**2 + v_D17_a_r**2)**(-0.5)
        struct[0].Hy[26,41] = 1.0*v_D17_a_i*(v_D17_a_i**2 + v_D17_a_r**2)**(-0.5)
        struct[0].Hy[27,42] = 1.0*v_D17_n_r*(v_D17_n_i**2 + v_D17_n_r**2)**(-0.5)
        struct[0].Hy[27,43] = 1.0*v_D17_n_i*(v_D17_n_i**2 + v_D17_n_r**2)**(-0.5)
        struct[0].Hy[28,44] = 1.0*v_D18_a_r*(v_D18_a_i**2 + v_D18_a_r**2)**(-0.5)
        struct[0].Hy[28,45] = 1.0*v_D18_a_i*(v_D18_a_i**2 + v_D18_a_r**2)**(-0.5)
        struct[0].Hy[29,46] = 1.0*v_D18_n_r*(v_D18_n_i**2 + v_D18_n_r**2)**(-0.5)
        struct[0].Hy[29,47] = 1.0*v_D18_n_i*(v_D18_n_i**2 + v_D18_n_r**2)**(-0.5)
        struct[0].Hy[30,48] = 1.0*v_R2_a_r*(v_R2_a_i**2 + v_R2_a_r**2)**(-0.5)
        struct[0].Hy[30,49] = 1.0*v_R2_a_i*(v_R2_a_i**2 + v_R2_a_r**2)**(-0.5)
        struct[0].Hy[31,50] = 1.0*v_R2_b_r*(v_R2_b_i**2 + v_R2_b_r**2)**(-0.5)
        struct[0].Hy[31,51] = 1.0*v_R2_b_i*(v_R2_b_i**2 + v_R2_b_r**2)**(-0.5)
        struct[0].Hy[32,52] = 1.0*v_R2_c_r*(v_R2_c_i**2 + v_R2_c_r**2)**(-0.5)
        struct[0].Hy[32,53] = 1.0*v_R2_c_i*(v_R2_c_i**2 + v_R2_c_r**2)**(-0.5)
        struct[0].Hy[33,54] = 1.0*v_R2_n_r*(v_R2_n_i**2 + v_R2_n_r**2)**(-0.5)
        struct[0].Hy[33,55] = 1.0*v_R2_n_i*(v_R2_n_i**2 + v_R2_n_r**2)**(-0.5)
        struct[0].Hy[34,56] = 1.0*v_R3_a_r*(v_R3_a_i**2 + v_R3_a_r**2)**(-0.5)
        struct[0].Hy[34,57] = 1.0*v_R3_a_i*(v_R3_a_i**2 + v_R3_a_r**2)**(-0.5)
        struct[0].Hy[35,58] = 1.0*v_R3_b_r*(v_R3_b_i**2 + v_R3_b_r**2)**(-0.5)
        struct[0].Hy[35,59] = 1.0*v_R3_b_i*(v_R3_b_i**2 + v_R3_b_r**2)**(-0.5)
        struct[0].Hy[36,60] = 1.0*v_R3_c_r*(v_R3_c_i**2 + v_R3_c_r**2)**(-0.5)
        struct[0].Hy[36,61] = 1.0*v_R3_c_i*(v_R3_c_i**2 + v_R3_c_r**2)**(-0.5)
        struct[0].Hy[37,62] = 1.0*v_R3_n_r*(v_R3_n_i**2 + v_R3_n_r**2)**(-0.5)
        struct[0].Hy[37,63] = 1.0*v_R3_n_i*(v_R3_n_i**2 + v_R3_n_r**2)**(-0.5)
        struct[0].Hy[38,64] = 1.0*v_R4_a_r*(v_R4_a_i**2 + v_R4_a_r**2)**(-0.5)
        struct[0].Hy[38,65] = 1.0*v_R4_a_i*(v_R4_a_i**2 + v_R4_a_r**2)**(-0.5)
        struct[0].Hy[39,66] = 1.0*v_R4_b_r*(v_R4_b_i**2 + v_R4_b_r**2)**(-0.5)
        struct[0].Hy[39,67] = 1.0*v_R4_b_i*(v_R4_b_i**2 + v_R4_b_r**2)**(-0.5)
        struct[0].Hy[40,68] = 1.0*v_R4_c_r*(v_R4_c_i**2 + v_R4_c_r**2)**(-0.5)
        struct[0].Hy[40,69] = 1.0*v_R4_c_i*(v_R4_c_i**2 + v_R4_c_r**2)**(-0.5)
        struct[0].Hy[41,70] = 1.0*v_R4_n_r*(v_R4_n_i**2 + v_R4_n_r**2)**(-0.5)
        struct[0].Hy[41,71] = 1.0*v_R4_n_i*(v_R4_n_i**2 + v_R4_n_r**2)**(-0.5)
        struct[0].Hy[42,72] = 1.0*v_R5_a_r*(v_R5_a_i**2 + v_R5_a_r**2)**(-0.5)
        struct[0].Hy[42,73] = 1.0*v_R5_a_i*(v_R5_a_i**2 + v_R5_a_r**2)**(-0.5)
        struct[0].Hy[43,74] = 1.0*v_R5_b_r*(v_R5_b_i**2 + v_R5_b_r**2)**(-0.5)
        struct[0].Hy[43,75] = 1.0*v_R5_b_i*(v_R5_b_i**2 + v_R5_b_r**2)**(-0.5)
        struct[0].Hy[44,76] = 1.0*v_R5_c_r*(v_R5_c_i**2 + v_R5_c_r**2)**(-0.5)
        struct[0].Hy[44,77] = 1.0*v_R5_c_i*(v_R5_c_i**2 + v_R5_c_r**2)**(-0.5)
        struct[0].Hy[45,78] = 1.0*v_R5_n_r*(v_R5_n_i**2 + v_R5_n_r**2)**(-0.5)
        struct[0].Hy[45,79] = 1.0*v_R5_n_i*(v_R5_n_i**2 + v_R5_n_r**2)**(-0.5)
        struct[0].Hy[46,80] = 1.0*v_R6_a_r*(v_R6_a_i**2 + v_R6_a_r**2)**(-0.5)
        struct[0].Hy[46,81] = 1.0*v_R6_a_i*(v_R6_a_i**2 + v_R6_a_r**2)**(-0.5)
        struct[0].Hy[47,82] = 1.0*v_R6_b_r*(v_R6_b_i**2 + v_R6_b_r**2)**(-0.5)
        struct[0].Hy[47,83] = 1.0*v_R6_b_i*(v_R6_b_i**2 + v_R6_b_r**2)**(-0.5)
        struct[0].Hy[48,84] = 1.0*v_R6_c_r*(v_R6_c_i**2 + v_R6_c_r**2)**(-0.5)
        struct[0].Hy[48,85] = 1.0*v_R6_c_i*(v_R6_c_i**2 + v_R6_c_r**2)**(-0.5)
        struct[0].Hy[49,86] = 1.0*v_R6_n_r*(v_R6_n_i**2 + v_R6_n_r**2)**(-0.5)
        struct[0].Hy[49,87] = 1.0*v_R6_n_i*(v_R6_n_i**2 + v_R6_n_r**2)**(-0.5)
        struct[0].Hy[50,88] = 1.0*v_R7_a_r*(v_R7_a_i**2 + v_R7_a_r**2)**(-0.5)
        struct[0].Hy[50,89] = 1.0*v_R7_a_i*(v_R7_a_i**2 + v_R7_a_r**2)**(-0.5)
        struct[0].Hy[51,90] = 1.0*v_R7_b_r*(v_R7_b_i**2 + v_R7_b_r**2)**(-0.5)
        struct[0].Hy[51,91] = 1.0*v_R7_b_i*(v_R7_b_i**2 + v_R7_b_r**2)**(-0.5)
        struct[0].Hy[52,92] = 1.0*v_R7_c_r*(v_R7_c_i**2 + v_R7_c_r**2)**(-0.5)
        struct[0].Hy[52,93] = 1.0*v_R7_c_i*(v_R7_c_i**2 + v_R7_c_r**2)**(-0.5)
        struct[0].Hy[53,94] = 1.0*v_R7_n_r*(v_R7_n_i**2 + v_R7_n_r**2)**(-0.5)
        struct[0].Hy[53,95] = 1.0*v_R7_n_i*(v_R7_n_i**2 + v_R7_n_r**2)**(-0.5)
        struct[0].Hy[54,96] = 1.0*v_R8_a_r*(v_R8_a_i**2 + v_R8_a_r**2)**(-0.5)
        struct[0].Hy[54,97] = 1.0*v_R8_a_i*(v_R8_a_i**2 + v_R8_a_r**2)**(-0.5)
        struct[0].Hy[55,98] = 1.0*v_R8_b_r*(v_R8_b_i**2 + v_R8_b_r**2)**(-0.5)
        struct[0].Hy[55,99] = 1.0*v_R8_b_i*(v_R8_b_i**2 + v_R8_b_r**2)**(-0.5)
        struct[0].Hy[56,100] = 1.0*v_R8_c_r*(v_R8_c_i**2 + v_R8_c_r**2)**(-0.5)
        struct[0].Hy[56,101] = 1.0*v_R8_c_i*(v_R8_c_i**2 + v_R8_c_r**2)**(-0.5)
        struct[0].Hy[57,102] = 1.0*v_R8_n_r*(v_R8_n_i**2 + v_R8_n_r**2)**(-0.5)
        struct[0].Hy[57,103] = 1.0*v_R8_n_i*(v_R8_n_i**2 + v_R8_n_r**2)**(-0.5)
        struct[0].Hy[58,104] = 1.0*v_R9_a_r*(v_R9_a_i**2 + v_R9_a_r**2)**(-0.5)
        struct[0].Hy[58,105] = 1.0*v_R9_a_i*(v_R9_a_i**2 + v_R9_a_r**2)**(-0.5)
        struct[0].Hy[59,106] = 1.0*v_R9_b_r*(v_R9_b_i**2 + v_R9_b_r**2)**(-0.5)
        struct[0].Hy[59,107] = 1.0*v_R9_b_i*(v_R9_b_i**2 + v_R9_b_r**2)**(-0.5)
        struct[0].Hy[60,108] = 1.0*v_R9_c_r*(v_R9_c_i**2 + v_R9_c_r**2)**(-0.5)
        struct[0].Hy[60,109] = 1.0*v_R9_c_i*(v_R9_c_i**2 + v_R9_c_r**2)**(-0.5)
        struct[0].Hy[61,110] = 1.0*v_R9_n_r*(v_R9_n_i**2 + v_R9_n_r**2)**(-0.5)
        struct[0].Hy[61,111] = 1.0*v_R9_n_i*(v_R9_n_i**2 + v_R9_n_r**2)**(-0.5)
        struct[0].Hy[62,112] = 1.0*v_R10_a_r*(v_R10_a_i**2 + v_R10_a_r**2)**(-0.5)
        struct[0].Hy[62,113] = 1.0*v_R10_a_i*(v_R10_a_i**2 + v_R10_a_r**2)**(-0.5)
        struct[0].Hy[63,114] = 1.0*v_R10_b_r*(v_R10_b_i**2 + v_R10_b_r**2)**(-0.5)
        struct[0].Hy[63,115] = 1.0*v_R10_b_i*(v_R10_b_i**2 + v_R10_b_r**2)**(-0.5)
        struct[0].Hy[64,116] = 1.0*v_R10_c_r*(v_R10_c_i**2 + v_R10_c_r**2)**(-0.5)
        struct[0].Hy[64,117] = 1.0*v_R10_c_i*(v_R10_c_i**2 + v_R10_c_r**2)**(-0.5)
        struct[0].Hy[65,118] = 1.0*v_R10_n_r*(v_R10_n_i**2 + v_R10_n_r**2)**(-0.5)
        struct[0].Hy[65,119] = 1.0*v_R10_n_i*(v_R10_n_i**2 + v_R10_n_r**2)**(-0.5)
        struct[0].Hy[66,120] = 1.0*v_R11_b_r*(v_R11_b_i**2 + v_R11_b_r**2)**(-0.5)
        struct[0].Hy[66,121] = 1.0*v_R11_b_i*(v_R11_b_i**2 + v_R11_b_r**2)**(-0.5)
        struct[0].Hy[67,122] = 1.0*v_R11_c_r*(v_R11_c_i**2 + v_R11_c_r**2)**(-0.5)
        struct[0].Hy[67,123] = 1.0*v_R11_c_i*(v_R11_c_i**2 + v_R11_c_r**2)**(-0.5)
        struct[0].Hy[68,124] = 1.0*v_R12_a_r*(v_R12_a_i**2 + v_R12_a_r**2)**(-0.5)
        struct[0].Hy[68,125] = 1.0*v_R12_a_i*(v_R12_a_i**2 + v_R12_a_r**2)**(-0.5)
        struct[0].Hy[69,126] = 1.0*v_R12_b_r*(v_R12_b_i**2 + v_R12_b_r**2)**(-0.5)
        struct[0].Hy[69,127] = 1.0*v_R12_b_i*(v_R12_b_i**2 + v_R12_b_r**2)**(-0.5)
        struct[0].Hy[70,128] = 1.0*v_R12_c_r*(v_R12_c_i**2 + v_R12_c_r**2)**(-0.5)
        struct[0].Hy[70,129] = 1.0*v_R12_c_i*(v_R12_c_i**2 + v_R12_c_r**2)**(-0.5)
        struct[0].Hy[71,130] = 1.0*v_R12_n_r*(v_R12_n_i**2 + v_R12_n_r**2)**(-0.5)
        struct[0].Hy[71,131] = 1.0*v_R12_n_i*(v_R12_n_i**2 + v_R12_n_r**2)**(-0.5)
        struct[0].Hy[72,132] = 1.0*v_R13_a_r*(v_R13_a_i**2 + v_R13_a_r**2)**(-0.5)
        struct[0].Hy[72,133] = 1.0*v_R13_a_i*(v_R13_a_i**2 + v_R13_a_r**2)**(-0.5)
        struct[0].Hy[73,134] = 1.0*v_R13_b_r*(v_R13_b_i**2 + v_R13_b_r**2)**(-0.5)
        struct[0].Hy[73,135] = 1.0*v_R13_b_i*(v_R13_b_i**2 + v_R13_b_r**2)**(-0.5)
        struct[0].Hy[74,136] = 1.0*v_R13_c_r*(v_R13_c_i**2 + v_R13_c_r**2)**(-0.5)
        struct[0].Hy[74,137] = 1.0*v_R13_c_i*(v_R13_c_i**2 + v_R13_c_r**2)**(-0.5)
        struct[0].Hy[75,138] = 1.0*v_R13_n_r*(v_R13_n_i**2 + v_R13_n_r**2)**(-0.5)
        struct[0].Hy[75,139] = 1.0*v_R13_n_i*(v_R13_n_i**2 + v_R13_n_r**2)**(-0.5)
        struct[0].Hy[76,140] = 1.0*v_R14_a_r*(v_R14_a_i**2 + v_R14_a_r**2)**(-0.5)
        struct[0].Hy[76,141] = 1.0*v_R14_a_i*(v_R14_a_i**2 + v_R14_a_r**2)**(-0.5)
        struct[0].Hy[77,142] = 1.0*v_R14_b_r*(v_R14_b_i**2 + v_R14_b_r**2)**(-0.5)
        struct[0].Hy[77,143] = 1.0*v_R14_b_i*(v_R14_b_i**2 + v_R14_b_r**2)**(-0.5)
        struct[0].Hy[78,144] = 1.0*v_R14_c_r*(v_R14_c_i**2 + v_R14_c_r**2)**(-0.5)
        struct[0].Hy[78,145] = 1.0*v_R14_c_i*(v_R14_c_i**2 + v_R14_c_r**2)**(-0.5)
        struct[0].Hy[79,146] = 1.0*v_R14_n_r*(v_R14_n_i**2 + v_R14_n_r**2)**(-0.5)
        struct[0].Hy[79,147] = 1.0*v_R14_n_i*(v_R14_n_i**2 + v_R14_n_r**2)**(-0.5)
        struct[0].Hy[80,148] = 1.0*v_R15_b_r*(v_R15_b_i**2 + v_R15_b_r**2)**(-0.5)
        struct[0].Hy[80,149] = 1.0*v_R15_b_i*(v_R15_b_i**2 + v_R15_b_r**2)**(-0.5)
        struct[0].Hy[81,150] = 1.0*v_R15_c_r*(v_R15_c_i**2 + v_R15_c_r**2)**(-0.5)
        struct[0].Hy[81,151] = 1.0*v_R15_c_i*(v_R15_c_i**2 + v_R15_c_r**2)**(-0.5)
        struct[0].Hy[82,152] = 1.0*v_R16_b_r*(v_R16_b_i**2 + v_R16_b_r**2)**(-0.5)
        struct[0].Hy[82,153] = 1.0*v_R16_b_i*(v_R16_b_i**2 + v_R16_b_r**2)**(-0.5)
        struct[0].Hy[83,154] = 1.0*v_R16_c_r*(v_R16_c_i**2 + v_R16_c_r**2)**(-0.5)
        struct[0].Hy[83,155] = 1.0*v_R16_c_i*(v_R16_c_i**2 + v_R16_c_r**2)**(-0.5)
        struct[0].Hy[84,156] = 1.0*v_R17_b_r*(v_R17_b_i**2 + v_R17_b_r**2)**(-0.5)
        struct[0].Hy[84,157] = 1.0*v_R17_b_i*(v_R17_b_i**2 + v_R17_b_r**2)**(-0.5)
        struct[0].Hy[85,158] = 1.0*v_R17_c_r*(v_R17_c_i**2 + v_R17_c_r**2)**(-0.5)
        struct[0].Hy[85,159] = 1.0*v_R17_c_i*(v_R17_c_i**2 + v_R17_c_r**2)**(-0.5)
        struct[0].Hy[86,160] = 1.0*v_R18_b_r*(v_R18_b_i**2 + v_R18_b_r**2)**(-0.5)
        struct[0].Hy[86,161] = 1.0*v_R18_b_i*(v_R18_b_i**2 + v_R18_b_r**2)**(-0.5)
        struct[0].Hy[87,162] = 1.0*v_R18_c_r*(v_R18_c_i**2 + v_R18_c_r**2)**(-0.5)
        struct[0].Hy[87,163] = 1.0*v_R18_c_i*(v_R18_c_i**2 + v_R18_c_r**2)**(-0.5)
        struct[0].Hy[88,164] = 1.0*v_D1_n_r*(v_D1_n_i**2 + v_D1_n_r**2)**(-0.5)
        struct[0].Hy[88,165] = 1.0*v_D1_n_i*(v_D1_n_i**2 + v_D1_n_r**2)**(-0.5)
        struct[0].Hy[89,166] = 1.0*v_D3_a_r*(v_D3_a_i**2 + v_D3_a_r**2)**(-0.5)
        struct[0].Hy[89,167] = 1.0*v_D3_a_i*(v_D3_a_i**2 + v_D3_a_r**2)**(-0.5)
        struct[0].Hy[90,168] = 1.0*v_D3_b_r*(v_D3_b_i**2 + v_D3_b_r**2)**(-0.5)
        struct[0].Hy[90,169] = 1.0*v_D3_b_i*(v_D3_b_i**2 + v_D3_b_r**2)**(-0.5)
        struct[0].Hy[91,170] = 1.0*v_D3_c_r*(v_D3_c_i**2 + v_D3_c_r**2)**(-0.5)
        struct[0].Hy[91,171] = 1.0*v_D3_c_i*(v_D3_c_i**2 + v_D3_c_r**2)**(-0.5)
        struct[0].Hy[92,172] = 1.0*v_D3_n_r*(v_D3_n_i**2 + v_D3_n_r**2)**(-0.5)
        struct[0].Hy[92,173] = 1.0*v_D3_n_i*(v_D3_n_i**2 + v_D3_n_r**2)**(-0.5)
        struct[0].Hy[93,174] = 1.0*v_D4_a_r*(v_D4_a_i**2 + v_D4_a_r**2)**(-0.5)
        struct[0].Hy[93,175] = 1.0*v_D4_a_i*(v_D4_a_i**2 + v_D4_a_r**2)**(-0.5)
        struct[0].Hy[94,176] = 1.0*v_D4_b_r*(v_D4_b_i**2 + v_D4_b_r**2)**(-0.5)
        struct[0].Hy[94,177] = 1.0*v_D4_b_i*(v_D4_b_i**2 + v_D4_b_r**2)**(-0.5)
        struct[0].Hy[95,178] = 1.0*v_D4_c_r*(v_D4_c_i**2 + v_D4_c_r**2)**(-0.5)
        struct[0].Hy[95,179] = 1.0*v_D4_c_i*(v_D4_c_i**2 + v_D4_c_r**2)**(-0.5)
        struct[0].Hy[96,180] = 1.0*v_D4_n_r*(v_D4_n_i**2 + v_D4_n_r**2)**(-0.5)
        struct[0].Hy[96,181] = 1.0*v_D4_n_i*(v_D4_n_i**2 + v_D4_n_r**2)**(-0.5)
        struct[0].Hy[97,182] = 1.0*v_D6_a_r*(v_D6_a_i**2 + v_D6_a_r**2)**(-0.5)
        struct[0].Hy[97,183] = 1.0*v_D6_a_i*(v_D6_a_i**2 + v_D6_a_r**2)**(-0.5)
        struct[0].Hy[98,184] = 1.0*v_D6_b_r*(v_D6_b_i**2 + v_D6_b_r**2)**(-0.5)
        struct[0].Hy[98,185] = 1.0*v_D6_b_i*(v_D6_b_i**2 + v_D6_b_r**2)**(-0.5)
        struct[0].Hy[99,186] = 1.0*v_D6_c_r*(v_D6_c_i**2 + v_D6_c_r**2)**(-0.5)
        struct[0].Hy[99,187] = 1.0*v_D6_c_i*(v_D6_c_i**2 + v_D6_c_r**2)**(-0.5)
        struct[0].Hy[100,188] = 1.0*v_D6_n_r*(v_D6_n_i**2 + v_D6_n_r**2)**(-0.5)
        struct[0].Hy[100,189] = 1.0*v_D6_n_i*(v_D6_n_i**2 + v_D6_n_r**2)**(-0.5)
        struct[0].Hy[101,190] = 1.0*v_D9_a_r*(v_D9_a_i**2 + v_D9_a_r**2)**(-0.5)
        struct[0].Hy[101,191] = 1.0*v_D9_a_i*(v_D9_a_i**2 + v_D9_a_r**2)**(-0.5)
        struct[0].Hy[102,192] = 1.0*v_D9_b_r*(v_D9_b_i**2 + v_D9_b_r**2)**(-0.5)
        struct[0].Hy[102,193] = 1.0*v_D9_b_i*(v_D9_b_i**2 + v_D9_b_r**2)**(-0.5)
        struct[0].Hy[103,194] = 1.0*v_D9_c_r*(v_D9_c_i**2 + v_D9_c_r**2)**(-0.5)
        struct[0].Hy[103,195] = 1.0*v_D9_c_i*(v_D9_c_i**2 + v_D9_c_r**2)**(-0.5)
        struct[0].Hy[104,196] = 1.0*v_D9_n_r*(v_D9_n_i**2 + v_D9_n_r**2)**(-0.5)
        struct[0].Hy[104,197] = 1.0*v_D9_n_i*(v_D9_n_i**2 + v_D9_n_r**2)**(-0.5)
        struct[0].Hy[105,198] = 1.0*v_D10_a_r*(v_D10_a_i**2 + v_D10_a_r**2)**(-0.5)
        struct[0].Hy[105,199] = 1.0*v_D10_a_i*(v_D10_a_i**2 + v_D10_a_r**2)**(-0.5)
        struct[0].Hy[106,200] = 1.0*v_D10_b_r*(v_D10_b_i**2 + v_D10_b_r**2)**(-0.5)
        struct[0].Hy[106,201] = 1.0*v_D10_b_i*(v_D10_b_i**2 + v_D10_b_r**2)**(-0.5)
        struct[0].Hy[107,202] = 1.0*v_D10_c_r*(v_D10_c_i**2 + v_D10_c_r**2)**(-0.5)
        struct[0].Hy[107,203] = 1.0*v_D10_c_i*(v_D10_c_i**2 + v_D10_c_r**2)**(-0.5)
        struct[0].Hy[108,204] = 1.0*v_D10_n_r*(v_D10_n_i**2 + v_D10_n_r**2)**(-0.5)
        struct[0].Hy[108,205] = 1.0*v_D10_n_i*(v_D10_n_i**2 + v_D10_n_r**2)**(-0.5)
        struct[0].Hy[109,206] = 1.0*v_D11_b_r*(v_D11_b_i**2 + v_D11_b_r**2)**(-0.5)
        struct[0].Hy[109,207] = 1.0*v_D11_b_i*(v_D11_b_i**2 + v_D11_b_r**2)**(-0.5)
        struct[0].Hy[110,208] = 1.0*v_D11_c_r*(v_D11_c_i**2 + v_D11_c_r**2)**(-0.5)
        struct[0].Hy[110,209] = 1.0*v_D11_c_i*(v_D11_c_i**2 + v_D11_c_r**2)**(-0.5)
        struct[0].Hy[111,210] = 1.0*v_D16_b_r*(v_D16_b_i**2 + v_D16_b_r**2)**(-0.5)
        struct[0].Hy[111,211] = 1.0*v_D16_b_i*(v_D16_b_i**2 + v_D16_b_r**2)**(-0.5)
        struct[0].Hy[112,212] = 1.0*v_D16_c_r*(v_D16_c_i**2 + v_D16_c_r**2)**(-0.5)
        struct[0].Hy[112,213] = 1.0*v_D16_c_i*(v_D16_c_i**2 + v_D16_c_r**2)**(-0.5)
        struct[0].Hy[113,214] = 1.0*v_D17_b_r*(v_D17_b_i**2 + v_D17_b_r**2)**(-0.5)
        struct[0].Hy[113,215] = 1.0*v_D17_b_i*(v_D17_b_i**2 + v_D17_b_r**2)**(-0.5)
        struct[0].Hy[114,216] = 1.0*v_D17_c_r*(v_D17_c_i**2 + v_D17_c_r**2)**(-0.5)
        struct[0].Hy[114,217] = 1.0*v_D17_c_i*(v_D17_c_i**2 + v_D17_c_r**2)**(-0.5)
        struct[0].Hy[115,218] = 1.0*v_D18_b_r*(v_D18_b_i**2 + v_D18_b_r**2)**(-0.5)
        struct[0].Hy[115,219] = 1.0*v_D18_b_i*(v_D18_b_i**2 + v_D18_b_r**2)**(-0.5)
        struct[0].Hy[116,220] = 1.0*v_D18_c_r*(v_D18_c_i**2 + v_D18_c_r**2)**(-0.5)
        struct[0].Hy[116,221] = 1.0*v_D18_c_i*(v_D18_c_i**2 + v_D18_c_r**2)**(-0.5)
        struct[0].Hy[117,222] = 1.0*v_D14_a_r*(v_D14_a_i**2 + v_D14_a_r**2)**(-0.5)
        struct[0].Hy[117,223] = 1.0*v_D14_a_i*(v_D14_a_i**2 + v_D14_a_r**2)**(-0.5)
        struct[0].Hy[118,224] = 1.0*v_D14_b_r*(v_D14_b_i**2 + v_D14_b_r**2)**(-0.5)
        struct[0].Hy[118,225] = 1.0*v_D14_b_i*(v_D14_b_i**2 + v_D14_b_r**2)**(-0.5)
        struct[0].Hy[119,226] = 1.0*v_D14_c_r*(v_D14_c_i**2 + v_D14_c_r**2)**(-0.5)
        struct[0].Hy[119,227] = 1.0*v_D14_c_i*(v_D14_c_i**2 + v_D14_c_r**2)**(-0.5)
        struct[0].Hy[120,228] = 1.0*v_D14_n_r*(v_D14_n_i**2 + v_D14_n_r**2)**(-0.5)
        struct[0].Hy[120,229] = 1.0*v_D14_n_i*(v_D14_n_i**2 + v_D14_n_r**2)**(-0.5)
        struct[0].Hy[121,230] = 1.0*v_D15_b_r*(v_D15_b_i**2 + v_D15_b_r**2)**(-0.5)
        struct[0].Hy[121,231] = 1.0*v_D15_b_i*(v_D15_b_i**2 + v_D15_b_r**2)**(-0.5)
        struct[0].Hy[122,232] = 1.0*v_D15_c_r*(v_D15_c_i**2 + v_D15_c_r**2)**(-0.5)
        struct[0].Hy[122,233] = 1.0*v_D15_c_i*(v_D15_c_i**2 + v_D15_c_r**2)**(-0.5)

        struct[0].Hu[0,0] = 1.0*v_R0_a_r*(v_R0_a_i**2 + v_R0_a_r**2)**(-0.5)
        struct[0].Hu[0,1] = 1.0*v_R0_a_i*(v_R0_a_i**2 + v_R0_a_r**2)**(-0.5)
        struct[0].Hu[1,2] = 1.0*v_R0_b_r*(v_R0_b_i**2 + v_R0_b_r**2)**(-0.5)
        struct[0].Hu[1,3] = 1.0*v_R0_b_i*(v_R0_b_i**2 + v_R0_b_r**2)**(-0.5)
        struct[0].Hu[2,4] = 1.0*v_R0_c_r*(v_R0_c_i**2 + v_R0_c_r**2)**(-0.5)
        struct[0].Hu[2,5] = 1.0*v_R0_c_i*(v_R0_c_i**2 + v_R0_c_r**2)**(-0.5)
        struct[0].Hu[3,6] = 1.0*v_D1_a_r*(v_D1_a_i**2 + v_D1_a_r**2)**(-0.5)
        struct[0].Hu[3,7] = 1.0*v_D1_a_i*(v_D1_a_i**2 + v_D1_a_r**2)**(-0.5)
        struct[0].Hu[4,8] = 1.0*v_D1_b_r*(v_D1_b_i**2 + v_D1_b_r**2)**(-0.5)
        struct[0].Hu[4,9] = 1.0*v_D1_b_i*(v_D1_b_i**2 + v_D1_b_r**2)**(-0.5)
        struct[0].Hu[5,10] = 1.0*v_D1_c_r*(v_D1_c_i**2 + v_D1_c_r**2)**(-0.5)
        struct[0].Hu[5,11] = 1.0*v_D1_c_i*(v_D1_c_i**2 + v_D1_c_r**2)**(-0.5)



def ini_nn(struct,mode):

    # Parameters:
    a_R1 = struct[0].a_R1
    b_R1 = struct[0].b_R1
    c_R1 = struct[0].c_R1
    a_R10 = struct[0].a_R10
    b_R10 = struct[0].b_R10
    c_R10 = struct[0].c_R10
    coef_a_R10 = struct[0].coef_a_R10
    coef_b_R10 = struct[0].coef_b_R10
    coef_c_R10 = struct[0].coef_c_R10
    a_R14 = struct[0].a_R14
    b_R14 = struct[0].b_R14
    c_R14 = struct[0].c_R14
    coef_a_R14 = struct[0].coef_a_R14
    coef_b_R14 = struct[0].coef_b_R14
    coef_c_R14 = struct[0].coef_c_R14
    
    # Inputs:
    v_R0_a_r = struct[0].v_R0_a_r
    v_R0_a_i = struct[0].v_R0_a_i
    v_R0_b_r = struct[0].v_R0_b_r
    v_R0_b_i = struct[0].v_R0_b_i
    v_R0_c_r = struct[0].v_R0_c_r
    v_R0_c_i = struct[0].v_R0_c_i
    v_D1_a_r = struct[0].v_D1_a_r
    v_D1_a_i = struct[0].v_D1_a_i
    v_D1_b_r = struct[0].v_D1_b_r
    v_D1_b_i = struct[0].v_D1_b_i
    v_D1_c_r = struct[0].v_D1_c_r
    v_D1_c_i = struct[0].v_D1_c_i
    i_R1_n_r = struct[0].i_R1_n_r
    i_R1_n_i = struct[0].i_R1_n_i
    i_R2_a_r = struct[0].i_R2_a_r
    i_R2_a_i = struct[0].i_R2_a_i
    i_R2_b_r = struct[0].i_R2_b_r
    i_R2_b_i = struct[0].i_R2_b_i
    i_R2_c_r = struct[0].i_R2_c_r
    i_R2_c_i = struct[0].i_R2_c_i
    i_R2_n_r = struct[0].i_R2_n_r
    i_R2_n_i = struct[0].i_R2_n_i
    i_R3_a_r = struct[0].i_R3_a_r
    i_R3_a_i = struct[0].i_R3_a_i
    i_R3_b_r = struct[0].i_R3_b_r
    i_R3_b_i = struct[0].i_R3_b_i
    i_R3_c_r = struct[0].i_R3_c_r
    i_R3_c_i = struct[0].i_R3_c_i
    i_R3_n_r = struct[0].i_R3_n_r
    i_R3_n_i = struct[0].i_R3_n_i
    i_R4_a_r = struct[0].i_R4_a_r
    i_R4_a_i = struct[0].i_R4_a_i
    i_R4_b_r = struct[0].i_R4_b_r
    i_R4_b_i = struct[0].i_R4_b_i
    i_R4_c_r = struct[0].i_R4_c_r
    i_R4_c_i = struct[0].i_R4_c_i
    i_R4_n_r = struct[0].i_R4_n_r
    i_R4_n_i = struct[0].i_R4_n_i
    i_R5_a_r = struct[0].i_R5_a_r
    i_R5_a_i = struct[0].i_R5_a_i
    i_R5_b_r = struct[0].i_R5_b_r
    i_R5_b_i = struct[0].i_R5_b_i
    i_R5_c_r = struct[0].i_R5_c_r
    i_R5_c_i = struct[0].i_R5_c_i
    i_R5_n_r = struct[0].i_R5_n_r
    i_R5_n_i = struct[0].i_R5_n_i
    i_R6_a_r = struct[0].i_R6_a_r
    i_R6_a_i = struct[0].i_R6_a_i
    i_R6_b_r = struct[0].i_R6_b_r
    i_R6_b_i = struct[0].i_R6_b_i
    i_R6_c_r = struct[0].i_R6_c_r
    i_R6_c_i = struct[0].i_R6_c_i
    i_R6_n_r = struct[0].i_R6_n_r
    i_R6_n_i = struct[0].i_R6_n_i
    i_R7_a_r = struct[0].i_R7_a_r
    i_R7_a_i = struct[0].i_R7_a_i
    i_R7_b_r = struct[0].i_R7_b_r
    i_R7_b_i = struct[0].i_R7_b_i
    i_R7_c_r = struct[0].i_R7_c_r
    i_R7_c_i = struct[0].i_R7_c_i
    i_R7_n_r = struct[0].i_R7_n_r
    i_R7_n_i = struct[0].i_R7_n_i
    i_R8_a_r = struct[0].i_R8_a_r
    i_R8_a_i = struct[0].i_R8_a_i
    i_R8_b_r = struct[0].i_R8_b_r
    i_R8_b_i = struct[0].i_R8_b_i
    i_R8_c_r = struct[0].i_R8_c_r
    i_R8_c_i = struct[0].i_R8_c_i
    i_R8_n_r = struct[0].i_R8_n_r
    i_R8_n_i = struct[0].i_R8_n_i
    i_R9_a_r = struct[0].i_R9_a_r
    i_R9_a_i = struct[0].i_R9_a_i
    i_R9_b_r = struct[0].i_R9_b_r
    i_R9_b_i = struct[0].i_R9_b_i
    i_R9_c_r = struct[0].i_R9_c_r
    i_R9_c_i = struct[0].i_R9_c_i
    i_R9_n_r = struct[0].i_R9_n_r
    i_R9_n_i = struct[0].i_R9_n_i
    i_R10_a_r = struct[0].i_R10_a_r
    i_R10_a_i = struct[0].i_R10_a_i
    i_R10_b_r = struct[0].i_R10_b_r
    i_R10_b_i = struct[0].i_R10_b_i
    i_R10_c_r = struct[0].i_R10_c_r
    i_R10_c_i = struct[0].i_R10_c_i
    i_R10_n_r = struct[0].i_R10_n_r
    i_R10_n_i = struct[0].i_R10_n_i
    i_R11_b_r = struct[0].i_R11_b_r
    i_R11_b_i = struct[0].i_R11_b_i
    i_R11_c_r = struct[0].i_R11_c_r
    i_R11_c_i = struct[0].i_R11_c_i
    i_R12_a_r = struct[0].i_R12_a_r
    i_R12_a_i = struct[0].i_R12_a_i
    i_R12_b_r = struct[0].i_R12_b_r
    i_R12_b_i = struct[0].i_R12_b_i
    i_R12_c_r = struct[0].i_R12_c_r
    i_R12_c_i = struct[0].i_R12_c_i
    i_R12_n_r = struct[0].i_R12_n_r
    i_R12_n_i = struct[0].i_R12_n_i
    i_R13_a_r = struct[0].i_R13_a_r
    i_R13_a_i = struct[0].i_R13_a_i
    i_R13_b_r = struct[0].i_R13_b_r
    i_R13_b_i = struct[0].i_R13_b_i
    i_R13_c_r = struct[0].i_R13_c_r
    i_R13_c_i = struct[0].i_R13_c_i
    i_R13_n_r = struct[0].i_R13_n_r
    i_R13_n_i = struct[0].i_R13_n_i
    i_R14_a_r = struct[0].i_R14_a_r
    i_R14_a_i = struct[0].i_R14_a_i
    i_R14_b_r = struct[0].i_R14_b_r
    i_R14_b_i = struct[0].i_R14_b_i
    i_R14_c_r = struct[0].i_R14_c_r
    i_R14_c_i = struct[0].i_R14_c_i
    i_R14_n_r = struct[0].i_R14_n_r
    i_R14_n_i = struct[0].i_R14_n_i
    i_R15_b_r = struct[0].i_R15_b_r
    i_R15_b_i = struct[0].i_R15_b_i
    i_R15_c_r = struct[0].i_R15_c_r
    i_R15_c_i = struct[0].i_R15_c_i
    i_R16_b_r = struct[0].i_R16_b_r
    i_R16_b_i = struct[0].i_R16_b_i
    i_R16_c_r = struct[0].i_R16_c_r
    i_R16_c_i = struct[0].i_R16_c_i
    i_R17_b_r = struct[0].i_R17_b_r
    i_R17_b_i = struct[0].i_R17_b_i
    i_R17_c_r = struct[0].i_R17_c_r
    i_R17_c_i = struct[0].i_R17_c_i
    i_R18_b_r = struct[0].i_R18_b_r
    i_R18_b_i = struct[0].i_R18_b_i
    i_R18_c_r = struct[0].i_R18_c_r
    i_R18_c_i = struct[0].i_R18_c_i
    i_D1_n_r = struct[0].i_D1_n_r
    i_D1_n_i = struct[0].i_D1_n_i
    i_D3_a_r = struct[0].i_D3_a_r
    i_D3_a_i = struct[0].i_D3_a_i
    i_D3_b_r = struct[0].i_D3_b_r
    i_D3_b_i = struct[0].i_D3_b_i
    i_D3_c_r = struct[0].i_D3_c_r
    i_D3_c_i = struct[0].i_D3_c_i
    i_D3_n_r = struct[0].i_D3_n_r
    i_D3_n_i = struct[0].i_D3_n_i
    i_D4_a_r = struct[0].i_D4_a_r
    i_D4_a_i = struct[0].i_D4_a_i
    i_D4_b_r = struct[0].i_D4_b_r
    i_D4_b_i = struct[0].i_D4_b_i
    i_D4_c_r = struct[0].i_D4_c_r
    i_D4_c_i = struct[0].i_D4_c_i
    i_D4_n_r = struct[0].i_D4_n_r
    i_D4_n_i = struct[0].i_D4_n_i
    i_D6_a_r = struct[0].i_D6_a_r
    i_D6_a_i = struct[0].i_D6_a_i
    i_D6_b_r = struct[0].i_D6_b_r
    i_D6_b_i = struct[0].i_D6_b_i
    i_D6_c_r = struct[0].i_D6_c_r
    i_D6_c_i = struct[0].i_D6_c_i
    i_D6_n_r = struct[0].i_D6_n_r
    i_D6_n_i = struct[0].i_D6_n_i
    i_D9_a_r = struct[0].i_D9_a_r
    i_D9_a_i = struct[0].i_D9_a_i
    i_D9_b_r = struct[0].i_D9_b_r
    i_D9_b_i = struct[0].i_D9_b_i
    i_D9_c_r = struct[0].i_D9_c_r
    i_D9_c_i = struct[0].i_D9_c_i
    i_D9_n_r = struct[0].i_D9_n_r
    i_D9_n_i = struct[0].i_D9_n_i
    i_D10_a_i = struct[0].i_D10_a_i
    i_D10_b_r = struct[0].i_D10_b_r
    i_D10_b_i = struct[0].i_D10_b_i
    i_D10_c_r = struct[0].i_D10_c_r
    i_D10_c_i = struct[0].i_D10_c_i
    i_D10_n_i = struct[0].i_D10_n_i
    i_D11_b_r = struct[0].i_D11_b_r
    i_D11_b_i = struct[0].i_D11_b_i
    i_D11_c_r = struct[0].i_D11_c_r
    i_D11_c_i = struct[0].i_D11_c_i
    i_D16_b_r = struct[0].i_D16_b_r
    i_D16_b_i = struct[0].i_D16_b_i
    i_D16_c_r = struct[0].i_D16_c_r
    i_D16_c_i = struct[0].i_D16_c_i
    i_D17_b_r = struct[0].i_D17_b_r
    i_D17_b_i = struct[0].i_D17_b_i
    i_D17_c_r = struct[0].i_D17_c_r
    i_D17_c_i = struct[0].i_D17_c_i
    i_D18_b_r = struct[0].i_D18_b_r
    i_D18_b_i = struct[0].i_D18_b_i
    i_D18_c_r = struct[0].i_D18_c_r
    i_D18_c_i = struct[0].i_D18_c_i
    i_D14_a_i = struct[0].i_D14_a_i
    i_D14_b_r = struct[0].i_D14_b_r
    i_D14_b_i = struct[0].i_D14_b_i
    i_D14_c_r = struct[0].i_D14_c_r
    i_D14_c_i = struct[0].i_D14_c_i
    i_D14_n_i = struct[0].i_D14_n_i
    i_D15_b_r = struct[0].i_D15_b_r
    i_D15_b_i = struct[0].i_D15_b_i
    i_D15_c_r = struct[0].i_D15_c_r
    i_D15_c_i = struct[0].i_D15_c_i
    p_R1_a = struct[0].p_R1_a
    q_R1_a = struct[0].q_R1_a
    p_R1_b = struct[0].p_R1_b
    q_R1_b = struct[0].q_R1_b
    p_R1_c = struct[0].p_R1_c
    q_R1_c = struct[0].q_R1_c
    p_R11_1 = struct[0].p_R11_1
    q_R11_1 = struct[0].q_R11_1
    p_R15_1 = struct[0].p_R15_1
    q_R15_1 = struct[0].q_R15_1
    p_R16_1 = struct[0].p_R16_1
    q_R16_1 = struct[0].q_R16_1
    p_R17_1 = struct[0].p_R17_1
    q_R17_1 = struct[0].q_R17_1
    p_R18_1 = struct[0].p_R18_1
    q_R18_1 = struct[0].q_R18_1
    p_D15_1 = struct[0].p_D15_1
    q_D15_1 = struct[0].q_D15_1
    p_D11_1 = struct[0].p_D11_1
    q_D11_1 = struct[0].q_D11_1
    p_D16_1 = struct[0].p_D16_1
    q_D16_1 = struct[0].q_D16_1
    p_D17_1 = struct[0].p_D17_1
    q_D17_1 = struct[0].q_D17_1
    p_D18_1 = struct[0].p_D18_1
    q_D18_1 = struct[0].q_D18_1
    v_dc_D1 = struct[0].v_dc_D1
    q_R1 = struct[0].q_R1
    p_R10 = struct[0].p_R10
    q_R10 = struct[0].q_R10
    p_R14 = struct[0].p_R14
    q_R14 = struct[0].q_R14
    u_dummy = struct[0].u_dummy
    
    # Dynamical states:
    x_dummy = struct[0].x[0,0]
    
    # Algebraic states:
    v_R1_a_r = struct[0].y_ini[0,0]
    v_R1_a_i = struct[0].y_ini[1,0]
    v_R1_b_r = struct[0].y_ini[2,0]
    v_R1_b_i = struct[0].y_ini[3,0]
    v_R1_c_r = struct[0].y_ini[4,0]
    v_R1_c_i = struct[0].y_ini[5,0]
    v_R1_n_r = struct[0].y_ini[6,0]
    v_R1_n_i = struct[0].y_ini[7,0]
    v_R11_a_r = struct[0].y_ini[8,0]
    v_R11_a_i = struct[0].y_ini[9,0]
    v_R11_n_r = struct[0].y_ini[10,0]
    v_R11_n_i = struct[0].y_ini[11,0]
    v_R15_a_r = struct[0].y_ini[12,0]
    v_R15_a_i = struct[0].y_ini[13,0]
    v_R15_n_r = struct[0].y_ini[14,0]
    v_R15_n_i = struct[0].y_ini[15,0]
    v_R16_a_r = struct[0].y_ini[16,0]
    v_R16_a_i = struct[0].y_ini[17,0]
    v_R16_n_r = struct[0].y_ini[18,0]
    v_R16_n_i = struct[0].y_ini[19,0]
    v_R17_a_r = struct[0].y_ini[20,0]
    v_R17_a_i = struct[0].y_ini[21,0]
    v_R17_n_r = struct[0].y_ini[22,0]
    v_R17_n_i = struct[0].y_ini[23,0]
    v_R18_a_r = struct[0].y_ini[24,0]
    v_R18_a_i = struct[0].y_ini[25,0]
    v_R18_n_r = struct[0].y_ini[26,0]
    v_R18_n_i = struct[0].y_ini[27,0]
    v_D15_a_r = struct[0].y_ini[28,0]
    v_D15_a_i = struct[0].y_ini[29,0]
    v_D15_n_r = struct[0].y_ini[30,0]
    v_D15_n_i = struct[0].y_ini[31,0]
    v_D11_a_r = struct[0].y_ini[32,0]
    v_D11_a_i = struct[0].y_ini[33,0]
    v_D11_n_r = struct[0].y_ini[34,0]
    v_D11_n_i = struct[0].y_ini[35,0]
    v_D16_a_r = struct[0].y_ini[36,0]
    v_D16_a_i = struct[0].y_ini[37,0]
    v_D16_n_r = struct[0].y_ini[38,0]
    v_D16_n_i = struct[0].y_ini[39,0]
    v_D17_a_r = struct[0].y_ini[40,0]
    v_D17_a_i = struct[0].y_ini[41,0]
    v_D17_n_r = struct[0].y_ini[42,0]
    v_D17_n_i = struct[0].y_ini[43,0]
    v_D18_a_r = struct[0].y_ini[44,0]
    v_D18_a_i = struct[0].y_ini[45,0]
    v_D18_n_r = struct[0].y_ini[46,0]
    v_D18_n_i = struct[0].y_ini[47,0]
    v_R2_a_r = struct[0].y_ini[48,0]
    v_R2_a_i = struct[0].y_ini[49,0]
    v_R2_b_r = struct[0].y_ini[50,0]
    v_R2_b_i = struct[0].y_ini[51,0]
    v_R2_c_r = struct[0].y_ini[52,0]
    v_R2_c_i = struct[0].y_ini[53,0]
    v_R2_n_r = struct[0].y_ini[54,0]
    v_R2_n_i = struct[0].y_ini[55,0]
    v_R3_a_r = struct[0].y_ini[56,0]
    v_R3_a_i = struct[0].y_ini[57,0]
    v_R3_b_r = struct[0].y_ini[58,0]
    v_R3_b_i = struct[0].y_ini[59,0]
    v_R3_c_r = struct[0].y_ini[60,0]
    v_R3_c_i = struct[0].y_ini[61,0]
    v_R3_n_r = struct[0].y_ini[62,0]
    v_R3_n_i = struct[0].y_ini[63,0]
    v_R4_a_r = struct[0].y_ini[64,0]
    v_R4_a_i = struct[0].y_ini[65,0]
    v_R4_b_r = struct[0].y_ini[66,0]
    v_R4_b_i = struct[0].y_ini[67,0]
    v_R4_c_r = struct[0].y_ini[68,0]
    v_R4_c_i = struct[0].y_ini[69,0]
    v_R4_n_r = struct[0].y_ini[70,0]
    v_R4_n_i = struct[0].y_ini[71,0]
    v_R5_a_r = struct[0].y_ini[72,0]
    v_R5_a_i = struct[0].y_ini[73,0]
    v_R5_b_r = struct[0].y_ini[74,0]
    v_R5_b_i = struct[0].y_ini[75,0]
    v_R5_c_r = struct[0].y_ini[76,0]
    v_R5_c_i = struct[0].y_ini[77,0]
    v_R5_n_r = struct[0].y_ini[78,0]
    v_R5_n_i = struct[0].y_ini[79,0]
    v_R6_a_r = struct[0].y_ini[80,0]
    v_R6_a_i = struct[0].y_ini[81,0]
    v_R6_b_r = struct[0].y_ini[82,0]
    v_R6_b_i = struct[0].y_ini[83,0]
    v_R6_c_r = struct[0].y_ini[84,0]
    v_R6_c_i = struct[0].y_ini[85,0]
    v_R6_n_r = struct[0].y_ini[86,0]
    v_R6_n_i = struct[0].y_ini[87,0]
    v_R7_a_r = struct[0].y_ini[88,0]
    v_R7_a_i = struct[0].y_ini[89,0]
    v_R7_b_r = struct[0].y_ini[90,0]
    v_R7_b_i = struct[0].y_ini[91,0]
    v_R7_c_r = struct[0].y_ini[92,0]
    v_R7_c_i = struct[0].y_ini[93,0]
    v_R7_n_r = struct[0].y_ini[94,0]
    v_R7_n_i = struct[0].y_ini[95,0]
    v_R8_a_r = struct[0].y_ini[96,0]
    v_R8_a_i = struct[0].y_ini[97,0]
    v_R8_b_r = struct[0].y_ini[98,0]
    v_R8_b_i = struct[0].y_ini[99,0]
    v_R8_c_r = struct[0].y_ini[100,0]
    v_R8_c_i = struct[0].y_ini[101,0]
    v_R8_n_r = struct[0].y_ini[102,0]
    v_R8_n_i = struct[0].y_ini[103,0]
    v_R9_a_r = struct[0].y_ini[104,0]
    v_R9_a_i = struct[0].y_ini[105,0]
    v_R9_b_r = struct[0].y_ini[106,0]
    v_R9_b_i = struct[0].y_ini[107,0]
    v_R9_c_r = struct[0].y_ini[108,0]
    v_R9_c_i = struct[0].y_ini[109,0]
    v_R9_n_r = struct[0].y_ini[110,0]
    v_R9_n_i = struct[0].y_ini[111,0]
    v_R10_a_r = struct[0].y_ini[112,0]
    v_R10_a_i = struct[0].y_ini[113,0]
    v_R10_b_r = struct[0].y_ini[114,0]
    v_R10_b_i = struct[0].y_ini[115,0]
    v_R10_c_r = struct[0].y_ini[116,0]
    v_R10_c_i = struct[0].y_ini[117,0]
    v_R10_n_r = struct[0].y_ini[118,0]
    v_R10_n_i = struct[0].y_ini[119,0]
    v_R11_b_r = struct[0].y_ini[120,0]
    v_R11_b_i = struct[0].y_ini[121,0]
    v_R11_c_r = struct[0].y_ini[122,0]
    v_R11_c_i = struct[0].y_ini[123,0]
    v_R12_a_r = struct[0].y_ini[124,0]
    v_R12_a_i = struct[0].y_ini[125,0]
    v_R12_b_r = struct[0].y_ini[126,0]
    v_R12_b_i = struct[0].y_ini[127,0]
    v_R12_c_r = struct[0].y_ini[128,0]
    v_R12_c_i = struct[0].y_ini[129,0]
    v_R12_n_r = struct[0].y_ini[130,0]
    v_R12_n_i = struct[0].y_ini[131,0]
    v_R13_a_r = struct[0].y_ini[132,0]
    v_R13_a_i = struct[0].y_ini[133,0]
    v_R13_b_r = struct[0].y_ini[134,0]
    v_R13_b_i = struct[0].y_ini[135,0]
    v_R13_c_r = struct[0].y_ini[136,0]
    v_R13_c_i = struct[0].y_ini[137,0]
    v_R13_n_r = struct[0].y_ini[138,0]
    v_R13_n_i = struct[0].y_ini[139,0]
    v_R14_a_r = struct[0].y_ini[140,0]
    v_R14_a_i = struct[0].y_ini[141,0]
    v_R14_b_r = struct[0].y_ini[142,0]
    v_R14_b_i = struct[0].y_ini[143,0]
    v_R14_c_r = struct[0].y_ini[144,0]
    v_R14_c_i = struct[0].y_ini[145,0]
    v_R14_n_r = struct[0].y_ini[146,0]
    v_R14_n_i = struct[0].y_ini[147,0]
    v_R15_b_r = struct[0].y_ini[148,0]
    v_R15_b_i = struct[0].y_ini[149,0]
    v_R15_c_r = struct[0].y_ini[150,0]
    v_R15_c_i = struct[0].y_ini[151,0]
    v_R16_b_r = struct[0].y_ini[152,0]
    v_R16_b_i = struct[0].y_ini[153,0]
    v_R16_c_r = struct[0].y_ini[154,0]
    v_R16_c_i = struct[0].y_ini[155,0]
    v_R17_b_r = struct[0].y_ini[156,0]
    v_R17_b_i = struct[0].y_ini[157,0]
    v_R17_c_r = struct[0].y_ini[158,0]
    v_R17_c_i = struct[0].y_ini[159,0]
    v_R18_b_r = struct[0].y_ini[160,0]
    v_R18_b_i = struct[0].y_ini[161,0]
    v_R18_c_r = struct[0].y_ini[162,0]
    v_R18_c_i = struct[0].y_ini[163,0]
    v_D1_n_r = struct[0].y_ini[164,0]
    v_D1_n_i = struct[0].y_ini[165,0]
    v_D3_a_r = struct[0].y_ini[166,0]
    v_D3_a_i = struct[0].y_ini[167,0]
    v_D3_b_r = struct[0].y_ini[168,0]
    v_D3_b_i = struct[0].y_ini[169,0]
    v_D3_c_r = struct[0].y_ini[170,0]
    v_D3_c_i = struct[0].y_ini[171,0]
    v_D3_n_r = struct[0].y_ini[172,0]
    v_D3_n_i = struct[0].y_ini[173,0]
    v_D4_a_r = struct[0].y_ini[174,0]
    v_D4_a_i = struct[0].y_ini[175,0]
    v_D4_b_r = struct[0].y_ini[176,0]
    v_D4_b_i = struct[0].y_ini[177,0]
    v_D4_c_r = struct[0].y_ini[178,0]
    v_D4_c_i = struct[0].y_ini[179,0]
    v_D4_n_r = struct[0].y_ini[180,0]
    v_D4_n_i = struct[0].y_ini[181,0]
    v_D6_a_r = struct[0].y_ini[182,0]
    v_D6_a_i = struct[0].y_ini[183,0]
    v_D6_b_r = struct[0].y_ini[184,0]
    v_D6_b_i = struct[0].y_ini[185,0]
    v_D6_c_r = struct[0].y_ini[186,0]
    v_D6_c_i = struct[0].y_ini[187,0]
    v_D6_n_r = struct[0].y_ini[188,0]
    v_D6_n_i = struct[0].y_ini[189,0]
    v_D9_a_r = struct[0].y_ini[190,0]
    v_D9_a_i = struct[0].y_ini[191,0]
    v_D9_b_r = struct[0].y_ini[192,0]
    v_D9_b_i = struct[0].y_ini[193,0]
    v_D9_c_r = struct[0].y_ini[194,0]
    v_D9_c_i = struct[0].y_ini[195,0]
    v_D9_n_r = struct[0].y_ini[196,0]
    v_D9_n_i = struct[0].y_ini[197,0]
    v_D10_a_r = struct[0].y_ini[198,0]
    v_D10_a_i = struct[0].y_ini[199,0]
    v_D10_b_r = struct[0].y_ini[200,0]
    v_D10_b_i = struct[0].y_ini[201,0]
    v_D10_c_r = struct[0].y_ini[202,0]
    v_D10_c_i = struct[0].y_ini[203,0]
    v_D10_n_r = struct[0].y_ini[204,0]
    v_D10_n_i = struct[0].y_ini[205,0]
    v_D11_b_r = struct[0].y_ini[206,0]
    v_D11_b_i = struct[0].y_ini[207,0]
    v_D11_c_r = struct[0].y_ini[208,0]
    v_D11_c_i = struct[0].y_ini[209,0]
    v_D16_b_r = struct[0].y_ini[210,0]
    v_D16_b_i = struct[0].y_ini[211,0]
    v_D16_c_r = struct[0].y_ini[212,0]
    v_D16_c_i = struct[0].y_ini[213,0]
    v_D17_b_r = struct[0].y_ini[214,0]
    v_D17_b_i = struct[0].y_ini[215,0]
    v_D17_c_r = struct[0].y_ini[216,0]
    v_D17_c_i = struct[0].y_ini[217,0]
    v_D18_b_r = struct[0].y_ini[218,0]
    v_D18_b_i = struct[0].y_ini[219,0]
    v_D18_c_r = struct[0].y_ini[220,0]
    v_D18_c_i = struct[0].y_ini[221,0]
    v_D14_a_r = struct[0].y_ini[222,0]
    v_D14_a_i = struct[0].y_ini[223,0]
    v_D14_b_r = struct[0].y_ini[224,0]
    v_D14_b_i = struct[0].y_ini[225,0]
    v_D14_c_r = struct[0].y_ini[226,0]
    v_D14_c_i = struct[0].y_ini[227,0]
    v_D14_n_r = struct[0].y_ini[228,0]
    v_D14_n_i = struct[0].y_ini[229,0]
    v_D15_b_r = struct[0].y_ini[230,0]
    v_D15_b_i = struct[0].y_ini[231,0]
    v_D15_c_r = struct[0].y_ini[232,0]
    v_D15_c_i = struct[0].y_ini[233,0]
    i_t_R0_R1_a_r = struct[0].y_ini[234,0]
    i_t_R0_R1_a_i = struct[0].y_ini[235,0]
    i_t_R0_R1_b_r = struct[0].y_ini[236,0]
    i_t_R0_R1_b_i = struct[0].y_ini[237,0]
    i_t_R0_R1_c_r = struct[0].y_ini[238,0]
    i_t_R0_R1_c_i = struct[0].y_ini[239,0]
    i_l_R1_R2_a_r = struct[0].y_ini[240,0]
    i_l_R1_R2_a_i = struct[0].y_ini[241,0]
    i_l_R1_R2_b_r = struct[0].y_ini[242,0]
    i_l_R1_R2_b_i = struct[0].y_ini[243,0]
    i_l_R1_R2_c_r = struct[0].y_ini[244,0]
    i_l_R1_R2_c_i = struct[0].y_ini[245,0]
    i_l_R1_R2_n_r = struct[0].y_ini[246,0]
    i_l_R1_R2_n_i = struct[0].y_ini[247,0]
    i_l_D1_D3_a_r = struct[0].y_ini[248,0]
    i_l_D1_D3_a_i = struct[0].y_ini[249,0]
    i_l_D1_D3_b_r = struct[0].y_ini[250,0]
    i_l_D1_D3_b_i = struct[0].y_ini[251,0]
    i_l_D1_D3_c_r = struct[0].y_ini[252,0]
    i_l_D1_D3_c_i = struct[0].y_ini[253,0]
    i_l_D1_D3_n_r = struct[0].y_ini[254,0]
    i_l_D1_D3_n_i = struct[0].y_ini[255,0]
    i_l_D3_D4_a_r = struct[0].y_ini[256,0]
    i_l_D3_D4_a_i = struct[0].y_ini[257,0]
    i_l_D3_D4_b_r = struct[0].y_ini[258,0]
    i_l_D3_D4_b_i = struct[0].y_ini[259,0]
    i_l_D3_D4_c_r = struct[0].y_ini[260,0]
    i_l_D3_D4_c_i = struct[0].y_ini[261,0]
    i_l_D3_D4_n_r = struct[0].y_ini[262,0]
    i_l_D3_D4_n_i = struct[0].y_ini[263,0]
    i_l_D4_D6_a_r = struct[0].y_ini[264,0]
    i_l_D4_D6_a_i = struct[0].y_ini[265,0]
    i_l_D4_D6_b_r = struct[0].y_ini[266,0]
    i_l_D4_D6_b_i = struct[0].y_ini[267,0]
    i_l_D4_D6_c_r = struct[0].y_ini[268,0]
    i_l_D4_D6_c_i = struct[0].y_ini[269,0]
    i_l_D4_D6_n_r = struct[0].y_ini[270,0]
    i_l_D4_D6_n_i = struct[0].y_ini[271,0]
    i_l_D6_D9_a_r = struct[0].y_ini[272,0]
    i_l_D6_D9_a_i = struct[0].y_ini[273,0]
    i_l_D6_D9_b_r = struct[0].y_ini[274,0]
    i_l_D6_D9_b_i = struct[0].y_ini[275,0]
    i_l_D6_D9_c_r = struct[0].y_ini[276,0]
    i_l_D6_D9_c_i = struct[0].y_ini[277,0]
    i_l_D6_D9_n_r = struct[0].y_ini[278,0]
    i_l_D6_D9_n_i = struct[0].y_ini[279,0]
    i_l_D9_D10_a_r = struct[0].y_ini[280,0]
    i_l_D9_D10_a_i = struct[0].y_ini[281,0]
    i_l_D9_D10_b_r = struct[0].y_ini[282,0]
    i_l_D9_D10_b_i = struct[0].y_ini[283,0]
    i_l_D9_D10_c_r = struct[0].y_ini[284,0]
    i_l_D9_D10_c_i = struct[0].y_ini[285,0]
    i_l_D9_D10_n_r = struct[0].y_ini[286,0]
    i_l_D9_D10_n_i = struct[0].y_ini[287,0]
    i_l_D3_D11_a_r = struct[0].y_ini[288,0]
    i_l_D3_D11_a_i = struct[0].y_ini[289,0]
    i_l_D3_D11_b_r = struct[0].y_ini[290,0]
    i_l_D3_D11_b_i = struct[0].y_ini[291,0]
    i_l_D3_D11_c_r = struct[0].y_ini[292,0]
    i_l_D3_D11_c_i = struct[0].y_ini[293,0]
    i_l_D3_D11_n_r = struct[0].y_ini[294,0]
    i_l_D3_D11_n_i = struct[0].y_ini[295,0]
    i_l_D6_D16_a_r = struct[0].y_ini[296,0]
    i_l_D6_D16_a_i = struct[0].y_ini[297,0]
    i_l_D6_D16_b_r = struct[0].y_ini[298,0]
    i_l_D6_D16_b_i = struct[0].y_ini[299,0]
    i_l_D6_D16_c_r = struct[0].y_ini[300,0]
    i_l_D6_D16_c_i = struct[0].y_ini[301,0]
    i_l_D6_D16_n_r = struct[0].y_ini[302,0]
    i_l_D6_D16_n_i = struct[0].y_ini[303,0]
    i_l_D9_D17_a_r = struct[0].y_ini[304,0]
    i_l_D9_D17_a_i = struct[0].y_ini[305,0]
    i_l_D9_D17_b_r = struct[0].y_ini[306,0]
    i_l_D9_D17_b_i = struct[0].y_ini[307,0]
    i_l_D9_D17_c_r = struct[0].y_ini[308,0]
    i_l_D9_D17_c_i = struct[0].y_ini[309,0]
    i_l_D9_D17_n_r = struct[0].y_ini[310,0]
    i_l_D9_D17_n_i = struct[0].y_ini[311,0]
    i_l_D10_D18_a_r = struct[0].y_ini[312,0]
    i_l_D10_D18_a_i = struct[0].y_ini[313,0]
    i_l_D10_D18_b_r = struct[0].y_ini[314,0]
    i_l_D10_D18_b_i = struct[0].y_ini[315,0]
    i_l_D10_D18_c_r = struct[0].y_ini[316,0]
    i_l_D10_D18_c_i = struct[0].y_ini[317,0]
    i_l_D10_D18_n_r = struct[0].y_ini[318,0]
    i_l_D10_D18_n_i = struct[0].y_ini[319,0]
    i_l_D4_D14_a_r = struct[0].y_ini[320,0]
    i_l_D4_D14_a_i = struct[0].y_ini[321,0]
    i_l_D4_D14_b_r = struct[0].y_ini[322,0]
    i_l_D4_D14_b_i = struct[0].y_ini[323,0]
    i_l_D4_D14_c_r = struct[0].y_ini[324,0]
    i_l_D4_D14_c_i = struct[0].y_ini[325,0]
    i_l_D4_D14_n_r = struct[0].y_ini[326,0]
    i_l_D4_D14_n_i = struct[0].y_ini[327,0]
    i_l_D14_D15_a_r = struct[0].y_ini[328,0]
    i_l_D14_D15_a_i = struct[0].y_ini[329,0]
    i_l_D14_D15_b_r = struct[0].y_ini[330,0]
    i_l_D14_D15_b_i = struct[0].y_ini[331,0]
    i_l_D14_D15_c_r = struct[0].y_ini[332,0]
    i_l_D14_D15_c_i = struct[0].y_ini[333,0]
    i_l_D14_D15_n_r = struct[0].y_ini[334,0]
    i_l_D14_D15_n_i = struct[0].y_ini[335,0]
    i_load_R1_a_r = struct[0].y_ini[336,0]
    i_load_R1_a_i = struct[0].y_ini[337,0]
    i_load_R1_b_r = struct[0].y_ini[338,0]
    i_load_R1_b_i = struct[0].y_ini[339,0]
    i_load_R1_c_r = struct[0].y_ini[340,0]
    i_load_R1_c_i = struct[0].y_ini[341,0]
    i_load_R1_n_r = struct[0].y_ini[342,0]
    i_load_R1_n_i = struct[0].y_ini[343,0]
    i_load_R11_a_r = struct[0].y_ini[344,0]
    i_load_R11_a_i = struct[0].y_ini[345,0]
    i_load_R11_n_r = struct[0].y_ini[346,0]
    i_load_R11_n_i = struct[0].y_ini[347,0]
    i_load_R15_a_r = struct[0].y_ini[348,0]
    i_load_R15_a_i = struct[0].y_ini[349,0]
    i_load_R15_n_r = struct[0].y_ini[350,0]
    i_load_R15_n_i = struct[0].y_ini[351,0]
    i_load_R16_a_r = struct[0].y_ini[352,0]
    i_load_R16_a_i = struct[0].y_ini[353,0]
    i_load_R16_n_r = struct[0].y_ini[354,0]
    i_load_R16_n_i = struct[0].y_ini[355,0]
    i_load_R17_a_r = struct[0].y_ini[356,0]
    i_load_R17_a_i = struct[0].y_ini[357,0]
    i_load_R17_n_r = struct[0].y_ini[358,0]
    i_load_R17_n_i = struct[0].y_ini[359,0]
    i_load_R18_a_r = struct[0].y_ini[360,0]
    i_load_R18_a_i = struct[0].y_ini[361,0]
    i_load_R18_n_r = struct[0].y_ini[362,0]
    i_load_R18_n_i = struct[0].y_ini[363,0]
    i_load_D15_a_r = struct[0].y_ini[364,0]
    i_load_D15_a_i = struct[0].y_ini[365,0]
    i_load_D15_n_r = struct[0].y_ini[366,0]
    i_load_D15_n_i = struct[0].y_ini[367,0]
    i_load_D11_a_r = struct[0].y_ini[368,0]
    i_load_D11_a_i = struct[0].y_ini[369,0]
    i_load_D11_n_r = struct[0].y_ini[370,0]
    i_load_D11_n_i = struct[0].y_ini[371,0]
    i_load_D16_a_r = struct[0].y_ini[372,0]
    i_load_D16_a_i = struct[0].y_ini[373,0]
    i_load_D16_n_r = struct[0].y_ini[374,0]
    i_load_D16_n_i = struct[0].y_ini[375,0]
    i_load_D17_a_r = struct[0].y_ini[376,0]
    i_load_D17_a_i = struct[0].y_ini[377,0]
    i_load_D17_n_r = struct[0].y_ini[378,0]
    i_load_D17_n_i = struct[0].y_ini[379,0]
    i_load_D18_a_r = struct[0].y_ini[380,0]
    i_load_D18_a_i = struct[0].y_ini[381,0]
    i_load_D18_n_r = struct[0].y_ini[382,0]
    i_load_D18_n_i = struct[0].y_ini[383,0]
    i_vsc_R1_a_r = struct[0].y_ini[384,0]
    i_vsc_R1_a_i = struct[0].y_ini[385,0]
    i_vsc_R1_b_r = struct[0].y_ini[386,0]
    i_vsc_R1_b_i = struct[0].y_ini[387,0]
    i_vsc_R1_c_r = struct[0].y_ini[388,0]
    i_vsc_R1_c_i = struct[0].y_ini[389,0]
    p_R1 = struct[0].y_ini[390,0]
    p_D1 = struct[0].y_ini[391,0]
    p_loss_R1 = struct[0].y_ini[392,0]
    i_vsc_R10_a_r = struct[0].y_ini[393,0]
    i_vsc_R10_a_i = struct[0].y_ini[394,0]
    i_vsc_R10_b_r = struct[0].y_ini[395,0]
    i_vsc_R10_b_i = struct[0].y_ini[396,0]
    i_vsc_R10_c_r = struct[0].y_ini[397,0]
    i_vsc_R10_c_i = struct[0].y_ini[398,0]
    i_vsc_R10_n_r = struct[0].y_ini[399,0]
    i_vsc_R10_n_i = struct[0].y_ini[400,0]
    i_vsc_D10_a_r = struct[0].y_ini[401,0]
    i_vsc_D10_n_r = struct[0].y_ini[402,0]
    p_D10 = struct[0].y_ini[403,0]
    i_vsc_R14_a_r = struct[0].y_ini[404,0]
    i_vsc_R14_a_i = struct[0].y_ini[405,0]
    i_vsc_R14_b_r = struct[0].y_ini[406,0]
    i_vsc_R14_b_i = struct[0].y_ini[407,0]
    i_vsc_R14_c_r = struct[0].y_ini[408,0]
    i_vsc_R14_c_i = struct[0].y_ini[409,0]
    i_vsc_R14_n_r = struct[0].y_ini[410,0]
    i_vsc_R14_n_i = struct[0].y_ini[411,0]
    i_vsc_D14_a_r = struct[0].y_ini[412,0]
    i_vsc_D14_n_r = struct[0].y_ini[413,0]
    p_D14 = struct[0].y_ini[414,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = u_dummy - x_dummy
    
    # Algebraic equations:
    if mode == 3:


        struct[0].g[0,0] = i_load_R1_a_r + i_vsc_R1_a_r + 0.849044513514155*v_R0_a_i + 0.212261128378539*v_R0_a_r - 0.849044513514155*v_R0_c_i - 0.212261128378539*v_R0_c_r - 127.595184532966*v_R1_a_i - 123.954122254357*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r + 23.284964480954*v_R1_c_i + 24.9575997948692*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r
        struct[0].g[1,0] = i_load_R1_a_i + i_vsc_R1_a_i + 0.212261128378539*v_R0_a_i - 0.849044513514155*v_R0_a_r - 0.212261128378539*v_R0_c_i + 0.849044513514155*v_R0_c_r - 123.954122254357*v_R1_a_i + 127.595184532966*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r + 24.9575997948692*v_R1_c_i - 23.284964480954*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r
        struct[0].g[2,0] = i_load_R1_b_r + i_vsc_R1_b_r - 0.849044513514155*v_R0_a_i - 0.212261128378539*v_R0_a_r + 0.849044513514155*v_R0_b_i + 0.212261128378539*v_R0_b_r + 10.2713736253513*v_R1_a_i + 39.6392229058202*v_R1_a_r - 127.595184532966*v_R1_b_i - 123.954122254357*v_R1_b_r + 10.2713736253513*v_R1_c_i + 39.6392229058201*v_R1_c_r + 96.8143762456598*v_R1_n_i + 43.3399527360457*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r
        struct[0].g[3,0] = i_load_R1_b_i + i_vsc_R1_b_i - 0.212261128378539*v_R0_a_i + 0.849044513514155*v_R0_a_r + 0.212261128378539*v_R0_b_i - 0.849044513514155*v_R0_b_r + 39.6392229058202*v_R1_a_i - 10.2713736253513*v_R1_a_r - 123.954122254357*v_R1_b_i + 127.595184532966*v_R1_b_r + 39.6392229058201*v_R1_c_i - 10.2713736253513*v_R1_c_r + 43.3399527360457*v_R1_n_i - 96.8143762456598*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r
        struct[0].g[4,0] = i_load_R1_c_r + i_vsc_R1_c_r - 0.849044513514155*v_R0_b_i - 0.212261128378539*v_R0_b_r + 0.849044513514155*v_R0_c_i + 0.212261128378539*v_R0_c_r + 23.284964480954*v_R1_a_i + 24.9575997948692*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r - 127.595184532966*v_R1_c_i - 123.954122254357*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r
        struct[0].g[5,0] = i_load_R1_c_i + i_vsc_R1_c_i - 0.212261128378539*v_R0_b_i + 0.849044513514155*v_R0_b_r + 0.212261128378539*v_R0_c_i - 0.849044513514155*v_R0_c_r + 24.9575997948692*v_R1_a_i - 23.284964480954*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r - 123.954122254357*v_R1_c_i + 127.595184532966*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r
        struct[0].g[6,0] = 83.8007853900572*v_R1_a_i + 58.0215758469966*v_R1_a_r + 96.8143762456598*v_R1_b_i + 43.3399527360457*v_R1_b_r + 83.8007853900572*v_R1_c_i + 58.0215758469966*v_R1_c_r - 274.654008062378*v_R1_n_i - 161.052161470043*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r - 23.284964480954*v_R2_b_i - 24.9575997948692*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058202*v_R2_c_r + 54.0657727682604*v_R2_n_i + 105.57176931318*v_R2_n_r
        struct[0].g[7,0] = 58.0215758469966*v_R1_a_i - 83.8007853900572*v_R1_a_r + 43.3399527360457*v_R1_b_i - 96.8143762456598*v_R1_b_r + 58.0215758469966*v_R1_c_i - 83.8007853900572*v_R1_c_r - 161.052161470043*v_R1_n_i + 274.654008062378*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r - 24.9575997948692*v_R2_b_i + 23.284964480954*v_R2_b_r - 39.6392229058202*v_R2_c_i + 10.2713736253513*v_R2_c_r + 105.57176931318*v_R2_n_i - 54.0657727682604*v_R2_n_r
        struct[0].g[8,0] = i_load_R11_a_r - 4.84676915585801*v_R11_a_i - 26.5300693004806*v_R11_a_r - 1.58482814504483*v_R11_b_i + 7.8946133751477*v_R11_b_r - 0.67991845328531*v_R11_c_i + 7.72144347466701*v_R11_c_r - 1.58482814504483*v_R11_n_i + 7.89461337514771*v_R11_n_r + 4.84676915585801*v_R3_a_i + 26.5300693004806*v_R3_a_r + 1.58482814504483*v_R3_b_i - 7.8946133751477*v_R3_b_r + 0.67991845328531*v_R3_c_i - 7.72144347466701*v_R3_c_r + 1.58482814504483*v_R3_n_i - 7.89461337514771*v_R3_n_r
        struct[0].g[9,0] = i_load_R11_a_i - 26.5300693004806*v_R11_a_i + 4.84676915585801*v_R11_a_r + 7.8946133751477*v_R11_b_i + 1.58482814504483*v_R11_b_r + 7.72144347466701*v_R11_c_i + 0.67991845328531*v_R11_c_r + 7.89461337514771*v_R11_n_i + 1.58482814504483*v_R11_n_r + 26.5300693004806*v_R3_a_i - 4.84676915585801*v_R3_a_r - 7.8946133751477*v_R3_b_i - 1.58482814504483*v_R3_b_r - 7.72144347466701*v_R3_c_i - 0.67991845328531*v_R3_c_r - 7.89461337514771*v_R3_n_i - 1.58482814504483*v_R3_n_r
        struct[0].g[10,0] = i_load_R11_n_r - 1.58482814504483*v_R11_a_i + 7.89461337514771*v_R11_a_r - 0.679918453285308*v_R11_b_i + 7.72144347466701*v_R11_b_r - 1.58482814504483*v_R11_c_i + 7.89461337514771*v_R11_c_r - 4.84676915585801*v_R11_n_i - 26.5550693004806*v_R11_n_r + 1.58482814504483*v_R3_a_i - 7.89461337514771*v_R3_a_r + 0.679918453285308*v_R3_b_i - 7.72144347466701*v_R3_b_r + 1.58482814504483*v_R3_c_i - 7.89461337514771*v_R3_c_r + 4.84676915585801*v_R3_n_i + 26.5300693004806*v_R3_n_r
        struct[0].g[11,0] = i_load_R11_n_i + 7.89461337514771*v_R11_a_i + 1.58482814504483*v_R11_a_r + 7.72144347466701*v_R11_b_i + 0.679918453285308*v_R11_b_r + 7.89461337514771*v_R11_c_i + 1.58482814504483*v_R11_c_r - 26.5550693004806*v_R11_n_i + 4.84676915585801*v_R11_n_r - 7.89461337514771*v_R3_a_i - 1.58482814504483*v_R3_a_r - 7.72144347466701*v_R3_b_i - 0.679918453285308*v_R3_b_r - 7.89461337514771*v_R3_c_i - 1.58482814504483*v_R3_c_r + 26.5300693004806*v_R3_n_i - 4.84676915585801*v_R3_n_r
        struct[0].g[12,0] = i_load_R15_a_r + 4.84676915585801*v_R14_a_i + 26.5300693004806*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 0.67991845328531*v_R14_c_i - 7.72144347466701*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r - 4.84676915585801*v_R15_a_i - 26.5300693004806*v_R15_a_r - 1.58482814504483*v_R15_b_i + 7.8946133751477*v_R15_b_r - 0.67991845328531*v_R15_c_i + 7.72144347466701*v_R15_c_r - 1.58482814504483*v_R15_n_i + 7.89461337514771*v_R15_n_r
        struct[0].g[13,0] = i_load_R15_a_i + 26.5300693004806*v_R14_a_i - 4.84676915585801*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r - 7.72144347466701*v_R14_c_i - 0.67991845328531*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r - 26.5300693004806*v_R15_a_i + 4.84676915585801*v_R15_a_r + 7.8946133751477*v_R15_b_i + 1.58482814504483*v_R15_b_r + 7.72144347466701*v_R15_c_i + 0.67991845328531*v_R15_c_r + 7.89461337514771*v_R15_n_i + 1.58482814504483*v_R15_n_r
        struct[0].g[14,0] = i_load_R15_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 0.679918453285308*v_R14_b_i - 7.72144347466701*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 4.84676915585801*v_R14_n_i + 26.5300693004806*v_R14_n_r - 1.58482814504483*v_R15_a_i + 7.89461337514771*v_R15_a_r - 0.679918453285308*v_R15_b_i + 7.72144347466701*v_R15_b_r - 1.58482814504483*v_R15_c_i + 7.89461337514771*v_R15_c_r - 4.84676915585801*v_R15_n_i - 26.5550693004806*v_R15_n_r
        struct[0].g[15,0] = i_load_R15_n_i - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r - 7.72144347466701*v_R14_b_i - 0.679918453285308*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r + 26.5300693004806*v_R14_n_i - 4.84676915585801*v_R14_n_r + 7.89461337514771*v_R15_a_i + 1.58482814504483*v_R15_a_r + 7.72144347466701*v_R15_b_i + 0.679918453285308*v_R15_b_r + 7.89461337514771*v_R15_c_i + 1.58482814504483*v_R15_c_r - 26.5550693004806*v_R15_n_i + 4.84676915585801*v_R15_n_r
        struct[0].g[16,0] = i_load_R16_a_r - 5.65456401516768*v_R16_a_i - 30.9517475172273*v_R16_a_r - 1.84896616921897*v_R16_b_i + 9.21038227100566*v_R16_b_r - 0.793238195499529*v_R16_c_i + 9.00835072044485*v_R16_c_r - 1.84896616921897*v_R16_n_i + 9.21038227100566*v_R16_n_r + 5.65456401516768*v_R6_a_i + 30.9517475172273*v_R6_a_r + 1.84896616921897*v_R6_b_i - 9.21038227100566*v_R6_b_r + 0.793238195499529*v_R6_c_i - 9.00835072044485*v_R6_c_r + 1.84896616921897*v_R6_n_i - 9.21038227100566*v_R6_n_r
        struct[0].g[17,0] = i_load_R16_a_i - 30.9517475172273*v_R16_a_i + 5.65456401516768*v_R16_a_r + 9.21038227100566*v_R16_b_i + 1.84896616921897*v_R16_b_r + 9.00835072044485*v_R16_c_i + 0.793238195499529*v_R16_c_r + 9.21038227100566*v_R16_n_i + 1.84896616921897*v_R16_n_r + 30.9517475172273*v_R6_a_i - 5.65456401516768*v_R6_a_r - 9.21038227100566*v_R6_b_i - 1.84896616921897*v_R6_b_r - 9.00835072044485*v_R6_c_i - 0.793238195499529*v_R6_c_r - 9.21038227100566*v_R6_n_i - 1.84896616921897*v_R6_n_r
        struct[0].g[18,0] = i_load_R16_n_r - 1.84896616921897*v_R16_a_i + 9.21038227100566*v_R16_a_r - 0.793238195499527*v_R16_b_i + 9.00835072044485*v_R16_b_r - 1.84896616921897*v_R16_c_i + 9.21038227100566*v_R16_c_r - 5.65456401516768*v_R16_n_i - 30.9767475172273*v_R16_n_r + 1.84896616921897*v_R6_a_i - 9.21038227100566*v_R6_a_r + 0.793238195499527*v_R6_b_i - 9.00835072044485*v_R6_b_r + 1.84896616921897*v_R6_c_i - 9.21038227100566*v_R6_c_r + 5.65456401516768*v_R6_n_i + 30.9517475172273*v_R6_n_r
        struct[0].g[19,0] = i_load_R16_n_i + 9.21038227100566*v_R16_a_i + 1.84896616921897*v_R16_a_r + 9.00835072044485*v_R16_b_i + 0.793238195499527*v_R16_b_r + 9.21038227100566*v_R16_c_i + 1.84896616921897*v_R16_c_r - 30.9767475172273*v_R16_n_i + 5.65456401516768*v_R16_n_r - 9.21038227100566*v_R6_a_i - 1.84896616921897*v_R6_a_r - 9.00835072044485*v_R6_b_i - 0.793238195499527*v_R6_b_r - 9.21038227100566*v_R6_c_i - 1.84896616921897*v_R6_c_r + 30.9517475172273*v_R6_n_i - 5.65456401516768*v_R6_n_r
        struct[0].g[20,0] = i_load_R17_a_r - 5.65456401516768*v_R17_a_i - 30.9517475172273*v_R17_a_r - 1.84896616921897*v_R17_b_i + 9.21038227100566*v_R17_b_r - 0.793238195499529*v_R17_c_i + 9.00835072044485*v_R17_c_r - 1.84896616921897*v_R17_n_i + 9.21038227100566*v_R17_n_r + 5.65456401516768*v_R9_a_i + 30.9517475172273*v_R9_a_r + 1.84896616921897*v_R9_b_i - 9.21038227100566*v_R9_b_r + 0.793238195499529*v_R9_c_i - 9.00835072044485*v_R9_c_r + 1.84896616921897*v_R9_n_i - 9.21038227100566*v_R9_n_r
        struct[0].g[21,0] = i_load_R17_a_i - 30.9517475172273*v_R17_a_i + 5.65456401516768*v_R17_a_r + 9.21038227100566*v_R17_b_i + 1.84896616921897*v_R17_b_r + 9.00835072044485*v_R17_c_i + 0.793238195499529*v_R17_c_r + 9.21038227100566*v_R17_n_i + 1.84896616921897*v_R17_n_r + 30.9517475172273*v_R9_a_i - 5.65456401516768*v_R9_a_r - 9.21038227100566*v_R9_b_i - 1.84896616921897*v_R9_b_r - 9.00835072044485*v_R9_c_i - 0.793238195499529*v_R9_c_r - 9.21038227100566*v_R9_n_i - 1.84896616921897*v_R9_n_r
        struct[0].g[22,0] = i_load_R17_n_r - 1.84896616921897*v_R17_a_i + 9.21038227100566*v_R17_a_r - 0.793238195499527*v_R17_b_i + 9.00835072044485*v_R17_b_r - 1.84896616921897*v_R17_c_i + 9.21038227100566*v_R17_c_r - 5.65456401516768*v_R17_n_i - 30.9767475172273*v_R17_n_r + 1.84896616921897*v_R9_a_i - 9.21038227100566*v_R9_a_r + 0.793238195499527*v_R9_b_i - 9.00835072044485*v_R9_b_r + 1.84896616921897*v_R9_c_i - 9.21038227100566*v_R9_c_r + 5.65456401516768*v_R9_n_i + 30.9517475172273*v_R9_n_r
        struct[0].g[23,0] = i_load_R17_n_i + 9.21038227100566*v_R17_a_i + 1.84896616921897*v_R17_a_r + 9.00835072044485*v_R17_b_i + 0.793238195499527*v_R17_b_r + 9.21038227100566*v_R17_c_i + 1.84896616921897*v_R17_c_r - 30.9767475172273*v_R17_n_i + 5.65456401516768*v_R17_n_r - 9.21038227100566*v_R9_a_i - 1.84896616921897*v_R9_a_r - 9.00835072044485*v_R9_b_i - 0.793238195499527*v_R9_b_r - 9.21038227100566*v_R9_c_i - 1.84896616921897*v_R9_c_r + 30.9517475172273*v_R9_n_i - 5.65456401516768*v_R9_n_r
        struct[0].g[24,0] = i_load_R18_a_r + 5.65456401516768*v_R10_a_i + 30.9517475172273*v_R10_a_r + 1.84896616921897*v_R10_b_i - 9.21038227100566*v_R10_b_r + 0.793238195499529*v_R10_c_i - 9.00835072044485*v_R10_c_r + 1.84896616921897*v_R10_n_i - 9.21038227100566*v_R10_n_r - 5.65456401516768*v_R18_a_i - 30.9517475172273*v_R18_a_r - 1.84896616921897*v_R18_b_i + 9.21038227100566*v_R18_b_r - 0.793238195499529*v_R18_c_i + 9.00835072044485*v_R18_c_r - 1.84896616921897*v_R18_n_i + 9.21038227100566*v_R18_n_r
        struct[0].g[25,0] = i_load_R18_a_i + 30.9517475172273*v_R10_a_i - 5.65456401516768*v_R10_a_r - 9.21038227100566*v_R10_b_i - 1.84896616921897*v_R10_b_r - 9.00835072044485*v_R10_c_i - 0.793238195499529*v_R10_c_r - 9.21038227100566*v_R10_n_i - 1.84896616921897*v_R10_n_r - 30.9517475172273*v_R18_a_i + 5.65456401516768*v_R18_a_r + 9.21038227100566*v_R18_b_i + 1.84896616921897*v_R18_b_r + 9.00835072044485*v_R18_c_i + 0.793238195499529*v_R18_c_r + 9.21038227100566*v_R18_n_i + 1.84896616921897*v_R18_n_r
        struct[0].g[26,0] = i_load_R18_n_r + 1.84896616921897*v_R10_a_i - 9.21038227100566*v_R10_a_r + 0.793238195499527*v_R10_b_i - 9.00835072044485*v_R10_b_r + 1.84896616921897*v_R10_c_i - 9.21038227100566*v_R10_c_r + 5.65456401516768*v_R10_n_i + 30.9517475172273*v_R10_n_r - 1.84896616921897*v_R18_a_i + 9.21038227100566*v_R18_a_r - 0.793238195499527*v_R18_b_i + 9.00835072044485*v_R18_b_r - 1.84896616921897*v_R18_c_i + 9.21038227100566*v_R18_c_r - 5.65456401516768*v_R18_n_i - 30.9767475172273*v_R18_n_r
        struct[0].g[27,0] = i_load_R18_n_i - 9.21038227100566*v_R10_a_i - 1.84896616921897*v_R10_a_r - 9.00835072044485*v_R10_b_i - 0.793238195499527*v_R10_b_r - 9.21038227100566*v_R10_c_i - 1.84896616921897*v_R10_c_r + 30.9517475172273*v_R10_n_i - 5.65456401516768*v_R10_n_r + 9.21038227100566*v_R18_a_i + 1.84896616921897*v_R18_a_r + 9.00835072044485*v_R18_b_i + 0.793238195499527*v_R18_b_r + 9.21038227100566*v_R18_c_i + 1.84896616921897*v_R18_c_r - 30.9767475172273*v_R18_n_i + 5.65456401516768*v_R18_n_r
        struct[0].g[28,0] = i_load_D15_a_r + 135.4096140826*v_D14_a_r - 135.4096140826*v_D15_a_r
        struct[0].g[29,0] = i_load_D15_a_i + 135.4096140826*v_D14_a_i - 135.4096140826*v_D15_a_i
        struct[0].g[30,0] = i_load_D15_n_r + 135.4096140826*v_D14_n_r - 135.4096140826*v_D15_n_r
        struct[0].g[31,0] = i_load_D15_n_i + 135.4096140826*v_D14_n_i - 135.4096140826*v_D15_n_i
        struct[0].g[32,0] = i_load_D11_a_r - 157.977883096366*v_D11_a_r + 157.977883096366*v_D3_a_r
        struct[0].g[33,0] = i_load_D11_a_i - 157.977883096366*v_D11_a_i + 157.977883096366*v_D3_a_i
        struct[0].g[34,0] = i_load_D11_n_r - 157.977883096366*v_D11_n_r + 157.977883096366*v_D3_n_r
        struct[0].g[35,0] = i_load_D11_n_i - 157.977883096366*v_D11_n_i + 157.977883096366*v_D3_n_i
        struct[0].g[36,0] = i_load_D16_a_r - 157.977883096366*v_D16_a_r + 157.977883096366*v_D6_a_r
        struct[0].g[37,0] = i_load_D16_a_i - 157.977883096366*v_D16_a_i + 157.977883096366*v_D6_a_i
        struct[0].g[38,0] = i_load_D16_n_r - 157.977883096366*v_D16_n_r + 157.977883096366*v_D6_n_r
        struct[0].g[39,0] = i_load_D16_n_i - 157.977883096366*v_D16_n_i + 157.977883096366*v_D6_n_i
        struct[0].g[40,0] = i_load_D17_a_r - 157.977883096366*v_D17_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[41,0] = i_load_D17_a_i - 157.977883096366*v_D17_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[42,0] = i_load_D17_n_r - 157.977883096366*v_D17_n_r + 157.977883096366*v_D9_n_r
        struct[0].g[43,0] = i_load_D17_n_i - 157.977883096366*v_D17_n_i + 157.977883096366*v_D9_n_i
        struct[0].g[44,0] = i_load_D18_a_r + 157.977883096366*v_D10_a_r - 157.977883096366*v_D18_a_r
        struct[0].g[45,0] = i_load_D18_a_i + 157.977883096366*v_D10_a_i - 157.977883096366*v_D18_a_i
        struct[0].g[46,0] = i_load_D18_n_r + 157.977883096366*v_D10_n_r - 157.977883096366*v_D18_n_r
        struct[0].g[47,0] = i_load_D18_n_i + 157.977883096366*v_D10_n_i - 157.977883096366*v_D18_n_i
        struct[0].g[48,0] = 54.0657727682604*v_R1_a_i + 105.57176931318*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r - 23.284964480954*v_R1_c_i - 24.9575997948692*v_R1_c_r - 10.2713736253513*v_R1_n_i - 39.6392229058202*v_R1_n_r - 108.131545536521*v_R2_a_i - 211.14353862636*v_R2_a_r + 20.5427472507027*v_R2_b_i + 79.2784458116403*v_R2_b_r + 46.569928961908*v_R2_c_i + 49.9151995897384*v_R2_c_r + 20.5427472507027*v_R2_n_i + 79.2784458116403*v_R2_n_r + 54.0657727682604*v_R3_a_i + 105.57176931318*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r - 23.284964480954*v_R3_c_i - 24.9575997948692*v_R3_c_r - 10.2713736253513*v_R3_n_i - 39.6392229058202*v_R3_n_r
        struct[0].g[49,0] = 105.57176931318*v_R1_a_i - 54.0657727682604*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r - 24.9575997948692*v_R1_c_i + 23.284964480954*v_R1_c_r - 39.6392229058202*v_R1_n_i + 10.2713736253513*v_R1_n_r - 211.14353862636*v_R2_a_i + 108.131545536521*v_R2_a_r + 79.2784458116403*v_R2_b_i - 20.5427472507027*v_R2_b_r + 49.9151995897384*v_R2_c_i - 46.569928961908*v_R2_c_r + 79.2784458116403*v_R2_n_i - 20.5427472507027*v_R2_n_r + 105.57176931318*v_R3_a_i - 54.0657727682604*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r - 24.9575997948692*v_R3_c_i + 23.284964480954*v_R3_c_r - 39.6392229058202*v_R3_n_i + 10.2713736253513*v_R3_n_r
        struct[0].g[50,0] = -10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r + 54.0657727682604*v_R1_b_i + 105.57176931318*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058201*v_R1_c_r - 23.284964480954*v_R1_n_i - 24.9575997948692*v_R1_n_r + 20.5427472507027*v_R2_a_i + 79.2784458116403*v_R2_a_r - 108.131545536521*v_R2_b_i - 211.14353862636*v_R2_b_r + 20.5427472507027*v_R2_c_i + 79.2784458116403*v_R2_c_r + 46.569928961908*v_R2_n_i + 49.9151995897384*v_R2_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r + 54.0657727682604*v_R3_b_i + 105.57176931318*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058201*v_R3_c_r - 23.284964480954*v_R3_n_i - 24.9575997948692*v_R3_n_r
        struct[0].g[51,0] = -39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r + 105.57176931318*v_R1_b_i - 54.0657727682604*v_R1_b_r - 39.6392229058201*v_R1_c_i + 10.2713736253513*v_R1_c_r - 24.9575997948692*v_R1_n_i + 23.284964480954*v_R1_n_r + 79.2784458116403*v_R2_a_i - 20.5427472507027*v_R2_a_r - 211.14353862636*v_R2_b_i + 108.131545536521*v_R2_b_r + 79.2784458116403*v_R2_c_i - 20.5427472507027*v_R2_c_r + 49.9151995897384*v_R2_n_i - 46.569928961908*v_R2_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r + 105.57176931318*v_R3_b_i - 54.0657727682604*v_R3_b_r - 39.6392229058201*v_R3_c_i + 10.2713736253513*v_R3_c_r - 24.9575997948692*v_R3_n_i + 23.284964480954*v_R3_n_r
        struct[0].g[52,0] = -23.284964480954*v_R1_a_i - 24.9575997948692*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r + 54.0657727682604*v_R1_c_i + 105.57176931318*v_R1_c_r - 10.2713736253514*v_R1_n_i - 39.6392229058201*v_R1_n_r + 46.569928961908*v_R2_a_i + 49.9151995897384*v_R2_a_r + 20.5427472507027*v_R2_b_i + 79.2784458116404*v_R2_b_r - 108.131545536521*v_R2_c_i - 211.14353862636*v_R2_c_r + 20.5427472507027*v_R2_n_i + 79.2784458116403*v_R2_n_r - 23.284964480954*v_R3_a_i - 24.9575997948692*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r + 54.0657727682604*v_R3_c_i + 105.57176931318*v_R3_c_r - 10.2713736253514*v_R3_n_i - 39.6392229058201*v_R3_n_r
        struct[0].g[53,0] = -24.9575997948692*v_R1_a_i + 23.284964480954*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r + 105.57176931318*v_R1_c_i - 54.0657727682604*v_R1_c_r - 39.6392229058201*v_R1_n_i + 10.2713736253514*v_R1_n_r + 49.9151995897384*v_R2_a_i - 46.569928961908*v_R2_a_r + 79.2784458116404*v_R2_b_i - 20.5427472507027*v_R2_b_r - 211.14353862636*v_R2_c_i + 108.131545536521*v_R2_c_r + 79.2784458116403*v_R2_n_i - 20.5427472507027*v_R2_n_r - 24.9575997948692*v_R3_a_i + 23.284964480954*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r + 105.57176931318*v_R3_c_i - 54.0657727682604*v_R3_c_r - 39.6392229058201*v_R3_n_i + 10.2713736253514*v_R3_n_r
        struct[0].g[54,0] = -10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r - 23.284964480954*v_R1_b_i - 24.9575997948692*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058202*v_R1_c_r + 54.0657727682604*v_R1_n_i + 105.57176931318*v_R1_n_r + 20.5427472507027*v_R2_a_i + 79.2784458116403*v_R2_a_r + 46.569928961908*v_R2_b_i + 49.9151995897384*v_R2_b_r + 20.5427472507027*v_R2_c_i + 79.2784458116403*v_R2_c_r - 108.131545536521*v_R2_n_i - 211.16853862636*v_R2_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r - 23.284964480954*v_R3_b_i - 24.9575997948692*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058202*v_R3_c_r + 54.0657727682604*v_R3_n_i + 105.57176931318*v_R3_n_r
        struct[0].g[55,0] = -39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r - 24.9575997948692*v_R1_b_i + 23.284964480954*v_R1_b_r - 39.6392229058202*v_R1_c_i + 10.2713736253513*v_R1_c_r + 105.57176931318*v_R1_n_i - 54.0657727682604*v_R1_n_r + 79.2784458116403*v_R2_a_i - 20.5427472507027*v_R2_a_r + 49.9151995897384*v_R2_b_i - 46.569928961908*v_R2_b_r + 79.2784458116403*v_R2_c_i - 20.5427472507027*v_R2_c_r - 211.16853862636*v_R2_n_i + 108.131545536521*v_R2_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r - 24.9575997948692*v_R3_b_i + 23.284964480954*v_R3_b_r - 39.6392229058202*v_R3_c_i + 10.2713736253513*v_R3_c_r + 105.57176931318*v_R3_n_i - 54.0657727682604*v_R3_n_r
        struct[0].g[56,0] = 4.84676915585801*v_R11_a_i + 26.5300693004806*v_R11_a_r + 1.58482814504483*v_R11_b_i - 7.8946133751477*v_R11_b_r + 0.67991845328531*v_R11_c_i - 7.72144347466701*v_R11_c_r + 1.58482814504483*v_R11_n_i - 7.89461337514771*v_R11_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r - 112.978314692379*v_R3_a_i - 237.673607926841*v_R3_a_r + 18.9579191056578*v_R3_b_i + 87.173059186788*v_R3_b_r + 45.8900105086227*v_R3_c_i + 57.6366430644055*v_R3_c_r + 18.9579191056579*v_R3_n_i + 87.173059186788*v_R3_n_r + 54.0657727682604*v_R4_a_i + 105.57176931318*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r - 23.284964480954*v_R4_c_i - 24.9575997948692*v_R4_c_r - 10.2713736253513*v_R4_n_i - 39.6392229058202*v_R4_n_r
        struct[0].g[57,0] = 26.5300693004806*v_R11_a_i - 4.84676915585801*v_R11_a_r - 7.8946133751477*v_R11_b_i - 1.58482814504483*v_R11_b_r - 7.72144347466701*v_R11_c_i - 0.67991845328531*v_R11_c_r - 7.89461337514771*v_R11_n_i - 1.58482814504483*v_R11_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r - 237.673607926841*v_R3_a_i + 112.978314692379*v_R3_a_r + 87.173059186788*v_R3_b_i - 18.9579191056578*v_R3_b_r + 57.6366430644055*v_R3_c_i - 45.8900105086227*v_R3_c_r + 87.173059186788*v_R3_n_i - 18.9579191056579*v_R3_n_r + 105.57176931318*v_R4_a_i - 54.0657727682604*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r - 24.9575997948692*v_R4_c_i + 23.284964480954*v_R4_c_r - 39.6392229058202*v_R4_n_i + 10.2713736253513*v_R4_n_r
        struct[0].g[58,0] = 1.58482814504483*v_R11_a_i - 7.89461337514771*v_R11_a_r + 4.84676915585801*v_R11_b_i + 26.5300693004806*v_R11_b_r + 1.58482814504483*v_R11_c_i - 7.89461337514771*v_R11_c_r + 0.679918453285308*v_R11_n_i - 7.72144347466701*v_R11_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r + 18.9579191056579*v_R3_a_i + 87.173059186788*v_R3_a_r - 112.978314692379*v_R3_b_i - 237.673607926841*v_R3_b_r + 18.9579191056579*v_R3_c_i + 87.173059186788*v_R3_c_r + 45.8900105086227*v_R3_n_i + 57.6366430644054*v_R3_n_r - 10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r + 54.0657727682604*v_R4_b_i + 105.57176931318*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058201*v_R4_c_r - 23.284964480954*v_R4_n_i - 24.9575997948692*v_R4_n_r
        struct[0].g[59,0] = -7.89461337514771*v_R11_a_i - 1.58482814504483*v_R11_a_r + 26.5300693004806*v_R11_b_i - 4.84676915585801*v_R11_b_r - 7.89461337514771*v_R11_c_i - 1.58482814504483*v_R11_c_r - 7.72144347466701*v_R11_n_i - 0.679918453285308*v_R11_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r + 87.173059186788*v_R3_a_i - 18.9579191056579*v_R3_a_r - 237.673607926841*v_R3_b_i + 112.978314692379*v_R3_b_r + 87.173059186788*v_R3_c_i - 18.9579191056579*v_R3_c_r + 57.6366430644054*v_R3_n_i - 45.8900105086227*v_R3_n_r - 39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r + 105.57176931318*v_R4_b_i - 54.0657727682604*v_R4_b_r - 39.6392229058201*v_R4_c_i + 10.2713736253513*v_R4_c_r - 24.9575997948692*v_R4_n_i + 23.284964480954*v_R4_n_r
        struct[0].g[60,0] = 0.67991845328531*v_R11_a_i - 7.72144347466701*v_R11_a_r + 1.58482814504483*v_R11_b_i - 7.8946133751477*v_R11_b_r + 4.84676915585801*v_R11_c_i + 26.5300693004806*v_R11_c_r + 1.58482814504483*v_R11_n_i - 7.89461337514771*v_R11_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r + 45.8900105086227*v_R3_a_i + 57.6366430644054*v_R3_a_r + 18.9579191056578*v_R3_b_i + 87.1730591867881*v_R3_b_r - 112.978314692379*v_R3_c_i - 237.673607926841*v_R3_c_r + 18.9579191056579*v_R3_n_i + 87.173059186788*v_R3_n_r - 23.284964480954*v_R4_a_i - 24.9575997948692*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r + 54.0657727682604*v_R4_c_i + 105.57176931318*v_R4_c_r - 10.2713736253514*v_R4_n_i - 39.6392229058201*v_R4_n_r
        struct[0].g[61,0] = -7.72144347466701*v_R11_a_i - 0.67991845328531*v_R11_a_r - 7.8946133751477*v_R11_b_i - 1.58482814504483*v_R11_b_r + 26.5300693004806*v_R11_c_i - 4.84676915585801*v_R11_c_r - 7.89461337514771*v_R11_n_i - 1.58482814504483*v_R11_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r + 57.6366430644054*v_R3_a_i - 45.8900105086227*v_R3_a_r + 87.1730591867881*v_R3_b_i - 18.9579191056578*v_R3_b_r - 237.673607926841*v_R3_c_i + 112.978314692379*v_R3_c_r + 87.173059186788*v_R3_n_i - 18.9579191056579*v_R3_n_r - 24.9575997948692*v_R4_a_i + 23.284964480954*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r + 105.57176931318*v_R4_c_i - 54.0657727682604*v_R4_c_r - 39.6392229058201*v_R4_n_i + 10.2713736253514*v_R4_n_r
        struct[0].g[62,0] = 1.58482814504483*v_R11_a_i - 7.89461337514771*v_R11_a_r + 0.679918453285308*v_R11_b_i - 7.72144347466701*v_R11_b_r + 1.58482814504483*v_R11_c_i - 7.89461337514771*v_R11_c_r + 4.84676915585801*v_R11_n_i + 26.5300693004806*v_R11_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r - 23.284964480954*v_R2_b_i - 24.9575997948692*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058202*v_R2_c_r + 54.0657727682604*v_R2_n_i + 105.57176931318*v_R2_n_r + 18.9579191056578*v_R3_a_i + 87.173059186788*v_R3_a_r + 45.8900105086227*v_R3_b_i + 57.6366430644054*v_R3_b_r + 18.9579191056579*v_R3_c_i + 87.173059186788*v_R3_c_r - 112.978314692379*v_R3_n_i - 237.673607926841*v_R3_n_r - 10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r - 23.284964480954*v_R4_b_i - 24.9575997948692*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058202*v_R4_c_r + 54.0657727682604*v_R4_n_i + 105.57176931318*v_R4_n_r
        struct[0].g[63,0] = -7.89461337514771*v_R11_a_i - 1.58482814504483*v_R11_a_r - 7.72144347466701*v_R11_b_i - 0.679918453285308*v_R11_b_r - 7.89461337514771*v_R11_c_i - 1.58482814504483*v_R11_c_r + 26.5300693004806*v_R11_n_i - 4.84676915585801*v_R11_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r - 24.9575997948692*v_R2_b_i + 23.284964480954*v_R2_b_r - 39.6392229058202*v_R2_c_i + 10.2713736253513*v_R2_c_r + 105.57176931318*v_R2_n_i - 54.0657727682604*v_R2_n_r + 87.173059186788*v_R3_a_i - 18.9579191056578*v_R3_a_r + 57.6366430644054*v_R3_b_i - 45.8900105086227*v_R3_b_r + 87.173059186788*v_R3_c_i - 18.9579191056579*v_R3_c_r - 237.673607926841*v_R3_n_i + 112.978314692379*v_R3_n_r - 39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r - 24.9575997948692*v_R4_b_i + 23.284964480954*v_R4_b_r - 39.6392229058202*v_R4_c_i + 10.2713736253513*v_R4_c_r + 105.57176931318*v_R4_n_i - 54.0657727682604*v_R4_n_r
        struct[0].g[64,0] = 4.84676915585801*v_R12_a_i + 26.5300693004806*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 0.67991845328531*v_R12_c_i - 7.72144347466701*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r + 54.0657727682604*v_R3_a_i + 105.57176931318*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r - 23.284964480954*v_R3_c_i - 24.9575997948692*v_R3_c_r - 10.2713736253513*v_R3_n_i - 39.6392229058202*v_R3_n_r - 112.978314692379*v_R4_a_i - 237.673607926841*v_R4_a_r + 18.9579191056578*v_R4_b_i + 87.173059186788*v_R4_b_r + 45.8900105086227*v_R4_c_i + 57.6366430644055*v_R4_c_r + 18.9579191056579*v_R4_n_i + 87.173059186788*v_R4_n_r + 54.0657727682604*v_R5_a_i + 105.57176931318*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r - 23.284964480954*v_R5_c_i - 24.9575997948692*v_R5_c_r - 10.2713736253513*v_R5_n_i - 39.6392229058202*v_R5_n_r
        struct[0].g[65,0] = 26.5300693004806*v_R12_a_i - 4.84676915585801*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r - 7.72144347466701*v_R12_c_i - 0.67991845328531*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r + 105.57176931318*v_R3_a_i - 54.0657727682604*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r - 24.9575997948692*v_R3_c_i + 23.284964480954*v_R3_c_r - 39.6392229058202*v_R3_n_i + 10.2713736253513*v_R3_n_r - 237.673607926841*v_R4_a_i + 112.978314692379*v_R4_a_r + 87.173059186788*v_R4_b_i - 18.9579191056578*v_R4_b_r + 57.6366430644055*v_R4_c_i - 45.8900105086227*v_R4_c_r + 87.173059186788*v_R4_n_i - 18.9579191056579*v_R4_n_r + 105.57176931318*v_R5_a_i - 54.0657727682604*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r - 24.9575997948692*v_R5_c_i + 23.284964480954*v_R5_c_r - 39.6392229058202*v_R5_n_i + 10.2713736253513*v_R5_n_r
        struct[0].g[66,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 4.84676915585801*v_R12_b_i + 26.5300693004806*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 0.679918453285308*v_R12_n_i - 7.72144347466701*v_R12_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r + 54.0657727682604*v_R3_b_i + 105.57176931318*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058201*v_R3_c_r - 23.284964480954*v_R3_n_i - 24.9575997948692*v_R3_n_r + 18.9579191056579*v_R4_a_i + 87.173059186788*v_R4_a_r - 112.978314692379*v_R4_b_i - 237.673607926841*v_R4_b_r + 18.9579191056579*v_R4_c_i + 87.173059186788*v_R4_c_r + 45.8900105086227*v_R4_n_i + 57.6366430644054*v_R4_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r + 54.0657727682604*v_R5_b_i + 105.57176931318*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058201*v_R5_c_r - 23.284964480954*v_R5_n_i - 24.9575997948692*v_R5_n_r
        struct[0].g[67,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r + 26.5300693004806*v_R12_b_i - 4.84676915585801*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r - 7.72144347466701*v_R12_n_i - 0.679918453285308*v_R12_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r + 105.57176931318*v_R3_b_i - 54.0657727682604*v_R3_b_r - 39.6392229058201*v_R3_c_i + 10.2713736253513*v_R3_c_r - 24.9575997948692*v_R3_n_i + 23.284964480954*v_R3_n_r + 87.173059186788*v_R4_a_i - 18.9579191056579*v_R4_a_r - 237.673607926841*v_R4_b_i + 112.978314692379*v_R4_b_r + 87.173059186788*v_R4_c_i - 18.9579191056579*v_R4_c_r + 57.6366430644054*v_R4_n_i - 45.8900105086227*v_R4_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r + 105.57176931318*v_R5_b_i - 54.0657727682604*v_R5_b_r - 39.6392229058201*v_R5_c_i + 10.2713736253513*v_R5_c_r - 24.9575997948692*v_R5_n_i + 23.284964480954*v_R5_n_r
        struct[0].g[68,0] = 0.67991845328531*v_R12_a_i - 7.72144347466701*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 4.84676915585801*v_R12_c_i + 26.5300693004806*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 23.284964480954*v_R3_a_i - 24.9575997948692*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r + 54.0657727682604*v_R3_c_i + 105.57176931318*v_R3_c_r - 10.2713736253514*v_R3_n_i - 39.6392229058201*v_R3_n_r + 45.8900105086227*v_R4_a_i + 57.6366430644054*v_R4_a_r + 18.9579191056578*v_R4_b_i + 87.1730591867881*v_R4_b_r - 112.978314692379*v_R4_c_i - 237.673607926841*v_R4_c_r + 18.9579191056579*v_R4_n_i + 87.173059186788*v_R4_n_r - 23.284964480954*v_R5_a_i - 24.9575997948692*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r + 54.0657727682604*v_R5_c_i + 105.57176931318*v_R5_c_r - 10.2713736253514*v_R5_n_i - 39.6392229058201*v_R5_n_r
        struct[0].g[69,0] = -7.72144347466701*v_R12_a_i - 0.67991845328531*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r + 26.5300693004806*v_R12_c_i - 4.84676915585801*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r - 24.9575997948692*v_R3_a_i + 23.284964480954*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r + 105.57176931318*v_R3_c_i - 54.0657727682604*v_R3_c_r - 39.6392229058201*v_R3_n_i + 10.2713736253514*v_R3_n_r + 57.6366430644054*v_R4_a_i - 45.8900105086227*v_R4_a_r + 87.1730591867881*v_R4_b_i - 18.9579191056578*v_R4_b_r - 237.673607926841*v_R4_c_i + 112.978314692379*v_R4_c_r + 87.173059186788*v_R4_n_i - 18.9579191056579*v_R4_n_r - 24.9575997948692*v_R5_a_i + 23.284964480954*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r + 105.57176931318*v_R5_c_i - 54.0657727682604*v_R5_c_r - 39.6392229058201*v_R5_n_i + 10.2713736253514*v_R5_n_r
        struct[0].g[70,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 0.679918453285308*v_R12_b_i - 7.72144347466701*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 4.84676915585801*v_R12_n_i + 26.5300693004806*v_R12_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r - 23.284964480954*v_R3_b_i - 24.9575997948692*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058202*v_R3_c_r + 54.0657727682604*v_R3_n_i + 105.57176931318*v_R3_n_r + 18.9579191056578*v_R4_a_i + 87.173059186788*v_R4_a_r + 45.8900105086227*v_R4_b_i + 57.6366430644054*v_R4_b_r + 18.9579191056579*v_R4_c_i + 87.173059186788*v_R4_c_r - 112.978314692379*v_R4_n_i - 237.698607926841*v_R4_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r - 23.284964480954*v_R5_b_i - 24.9575997948692*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058202*v_R5_c_r + 54.0657727682604*v_R5_n_i + 105.57176931318*v_R5_n_r
        struct[0].g[71,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r - 7.72144347466701*v_R12_b_i - 0.679918453285308*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r + 26.5300693004806*v_R12_n_i - 4.84676915585801*v_R12_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r - 24.9575997948692*v_R3_b_i + 23.284964480954*v_R3_b_r - 39.6392229058202*v_R3_c_i + 10.2713736253513*v_R3_c_r + 105.57176931318*v_R3_n_i - 54.0657727682604*v_R3_n_r + 87.173059186788*v_R4_a_i - 18.9579191056578*v_R4_a_r + 57.6366430644054*v_R4_b_i - 45.8900105086227*v_R4_b_r + 87.173059186788*v_R4_c_i - 18.9579191056579*v_R4_c_r - 237.698607926841*v_R4_n_i + 112.978314692379*v_R4_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r - 24.9575997948692*v_R5_b_i + 23.284964480954*v_R5_b_r - 39.6392229058202*v_R5_c_i + 10.2713736253513*v_R5_c_r + 105.57176931318*v_R5_n_i - 54.0657727682604*v_R5_n_r
        struct[0].g[72,0] = 54.0657727682604*v_R4_a_i + 105.57176931318*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r - 23.284964480954*v_R4_c_i - 24.9575997948692*v_R4_c_r - 10.2713736253513*v_R4_n_i - 39.6392229058202*v_R4_n_r - 108.131545536521*v_R5_a_i - 211.14353862636*v_R5_a_r + 20.5427472507027*v_R5_b_i + 79.2784458116403*v_R5_b_r + 46.569928961908*v_R5_c_i + 49.9151995897384*v_R5_c_r + 20.5427472507027*v_R5_n_i + 79.2784458116403*v_R5_n_r + 54.0657727682604*v_R6_a_i + 105.57176931318*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r - 23.284964480954*v_R6_c_i - 24.9575997948692*v_R6_c_r - 10.2713736253513*v_R6_n_i - 39.6392229058202*v_R6_n_r
        struct[0].g[73,0] = 105.57176931318*v_R4_a_i - 54.0657727682604*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r - 24.9575997948692*v_R4_c_i + 23.284964480954*v_R4_c_r - 39.6392229058202*v_R4_n_i + 10.2713736253513*v_R4_n_r - 211.14353862636*v_R5_a_i + 108.131545536521*v_R5_a_r + 79.2784458116403*v_R5_b_i - 20.5427472507027*v_R5_b_r + 49.9151995897384*v_R5_c_i - 46.569928961908*v_R5_c_r + 79.2784458116403*v_R5_n_i - 20.5427472507027*v_R5_n_r + 105.57176931318*v_R6_a_i - 54.0657727682604*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r - 24.9575997948692*v_R6_c_i + 23.284964480954*v_R6_c_r - 39.6392229058202*v_R6_n_i + 10.2713736253513*v_R6_n_r
        struct[0].g[74,0] = -10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r + 54.0657727682604*v_R4_b_i + 105.57176931318*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058201*v_R4_c_r - 23.284964480954*v_R4_n_i - 24.9575997948692*v_R4_n_r + 20.5427472507027*v_R5_a_i + 79.2784458116403*v_R5_a_r - 108.131545536521*v_R5_b_i - 211.14353862636*v_R5_b_r + 20.5427472507027*v_R5_c_i + 79.2784458116403*v_R5_c_r + 46.569928961908*v_R5_n_i + 49.9151995897384*v_R5_n_r - 10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r + 54.0657727682604*v_R6_b_i + 105.57176931318*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058201*v_R6_c_r - 23.284964480954*v_R6_n_i - 24.9575997948692*v_R6_n_r
        struct[0].g[75,0] = -39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r + 105.57176931318*v_R4_b_i - 54.0657727682604*v_R4_b_r - 39.6392229058201*v_R4_c_i + 10.2713736253513*v_R4_c_r - 24.9575997948692*v_R4_n_i + 23.284964480954*v_R4_n_r + 79.2784458116403*v_R5_a_i - 20.5427472507027*v_R5_a_r - 211.14353862636*v_R5_b_i + 108.131545536521*v_R5_b_r + 79.2784458116403*v_R5_c_i - 20.5427472507027*v_R5_c_r + 49.9151995897384*v_R5_n_i - 46.569928961908*v_R5_n_r - 39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r + 105.57176931318*v_R6_b_i - 54.0657727682604*v_R6_b_r - 39.6392229058201*v_R6_c_i + 10.2713736253513*v_R6_c_r - 24.9575997948692*v_R6_n_i + 23.284964480954*v_R6_n_r
        struct[0].g[76,0] = -23.284964480954*v_R4_a_i - 24.9575997948692*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r + 54.0657727682604*v_R4_c_i + 105.57176931318*v_R4_c_r - 10.2713736253514*v_R4_n_i - 39.6392229058201*v_R4_n_r + 46.569928961908*v_R5_a_i + 49.9151995897384*v_R5_a_r + 20.5427472507027*v_R5_b_i + 79.2784458116404*v_R5_b_r - 108.131545536521*v_R5_c_i - 211.14353862636*v_R5_c_r + 20.5427472507027*v_R5_n_i + 79.2784458116403*v_R5_n_r - 23.284964480954*v_R6_a_i - 24.9575997948692*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r + 54.0657727682604*v_R6_c_i + 105.57176931318*v_R6_c_r - 10.2713736253514*v_R6_n_i - 39.6392229058201*v_R6_n_r
        struct[0].g[77,0] = -24.9575997948692*v_R4_a_i + 23.284964480954*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r + 105.57176931318*v_R4_c_i - 54.0657727682604*v_R4_c_r - 39.6392229058201*v_R4_n_i + 10.2713736253514*v_R4_n_r + 49.9151995897384*v_R5_a_i - 46.569928961908*v_R5_a_r + 79.2784458116404*v_R5_b_i - 20.5427472507027*v_R5_b_r - 211.14353862636*v_R5_c_i + 108.131545536521*v_R5_c_r + 79.2784458116403*v_R5_n_i - 20.5427472507027*v_R5_n_r - 24.9575997948692*v_R6_a_i + 23.284964480954*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r + 105.57176931318*v_R6_c_i - 54.0657727682604*v_R6_c_r - 39.6392229058201*v_R6_n_i + 10.2713736253514*v_R6_n_r
        struct[0].g[78,0] = -10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r - 23.284964480954*v_R4_b_i - 24.9575997948692*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058202*v_R4_c_r + 54.0657727682604*v_R4_n_i + 105.57176931318*v_R4_n_r + 20.5427472507027*v_R5_a_i + 79.2784458116403*v_R5_a_r + 46.569928961908*v_R5_b_i + 49.9151995897384*v_R5_b_r + 20.5427472507027*v_R5_c_i + 79.2784458116403*v_R5_c_r - 108.131545536521*v_R5_n_i - 211.14353862636*v_R5_n_r - 10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r - 23.284964480954*v_R6_b_i - 24.9575997948692*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058202*v_R6_c_r + 54.0657727682604*v_R6_n_i + 105.57176931318*v_R6_n_r
        struct[0].g[79,0] = -39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r - 24.9575997948692*v_R4_b_i + 23.284964480954*v_R4_b_r - 39.6392229058202*v_R4_c_i + 10.2713736253513*v_R4_c_r + 105.57176931318*v_R4_n_i - 54.0657727682604*v_R4_n_r + 79.2784458116403*v_R5_a_i - 20.5427472507027*v_R5_a_r + 49.9151995897384*v_R5_b_i - 46.569928961908*v_R5_b_r + 79.2784458116403*v_R5_c_i - 20.5427472507027*v_R5_c_r - 211.14353862636*v_R5_n_i + 108.131545536521*v_R5_n_r - 39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r - 24.9575997948692*v_R6_b_i + 23.284964480954*v_R6_b_r - 39.6392229058202*v_R6_c_i + 10.2713736253513*v_R6_c_r + 105.57176931318*v_R6_n_i - 54.0657727682604*v_R6_n_r
        struct[0].g[80,0] = 5.65456401516768*v_R16_a_i + 30.9517475172273*v_R16_a_r + 1.84896616921897*v_R16_b_i - 9.21038227100566*v_R16_b_r + 0.793238195499529*v_R16_c_i - 9.00835072044485*v_R16_c_r + 1.84896616921897*v_R16_n_i - 9.21038227100566*v_R16_n_r + 54.0657727682604*v_R5_a_i + 105.57176931318*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r - 23.284964480954*v_R5_c_i - 24.9575997948692*v_R5_c_r - 10.2713736253513*v_R5_n_i - 39.6392229058202*v_R5_n_r - 113.786109551688*v_R6_a_i - 242.095286143588*v_R6_a_r + 18.6937810814837*v_R6_b_i + 88.488828082646*v_R6_b_r + 45.7766907664085*v_R6_c_i + 58.9235503101833*v_R6_c_r + 18.6937810814837*v_R6_n_i + 88.488828082646*v_R6_n_r + 54.0657727682604*v_R7_a_i + 105.57176931318*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r - 23.284964480954*v_R7_c_i - 24.9575997948692*v_R7_c_r - 10.2713736253513*v_R7_n_i - 39.6392229058202*v_R7_n_r
        struct[0].g[81,0] = 30.9517475172273*v_R16_a_i - 5.65456401516768*v_R16_a_r - 9.21038227100566*v_R16_b_i - 1.84896616921897*v_R16_b_r - 9.00835072044485*v_R16_c_i - 0.793238195499529*v_R16_c_r - 9.21038227100566*v_R16_n_i - 1.84896616921897*v_R16_n_r + 105.57176931318*v_R5_a_i - 54.0657727682604*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r - 24.9575997948692*v_R5_c_i + 23.284964480954*v_R5_c_r - 39.6392229058202*v_R5_n_i + 10.2713736253513*v_R5_n_r - 242.095286143588*v_R6_a_i + 113.786109551688*v_R6_a_r + 88.488828082646*v_R6_b_i - 18.6937810814837*v_R6_b_r + 58.9235503101833*v_R6_c_i - 45.7766907664085*v_R6_c_r + 88.488828082646*v_R6_n_i - 18.6937810814837*v_R6_n_r + 105.57176931318*v_R7_a_i - 54.0657727682604*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r - 24.9575997948692*v_R7_c_i + 23.284964480954*v_R7_c_r - 39.6392229058202*v_R7_n_i + 10.2713736253513*v_R7_n_r
        struct[0].g[82,0] = 1.84896616921897*v_R16_a_i - 9.21038227100566*v_R16_a_r + 5.65456401516768*v_R16_b_i + 30.9517475172273*v_R16_b_r + 1.84896616921897*v_R16_c_i - 9.21038227100566*v_R16_c_r + 0.793238195499528*v_R16_n_i - 9.00835072044485*v_R16_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r + 54.0657727682604*v_R5_b_i + 105.57176931318*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058201*v_R5_c_r - 23.284964480954*v_R5_n_i - 24.9575997948692*v_R5_n_r + 18.6937810814837*v_R6_a_i + 88.488828082646*v_R6_a_r - 113.786109551688*v_R6_b_i - 242.095286143588*v_R6_b_r + 18.6937810814837*v_R6_c_i + 88.488828082646*v_R6_c_r + 45.7766907664085*v_R6_n_i + 58.9235503101833*v_R6_n_r - 10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r + 54.0657727682604*v_R7_b_i + 105.57176931318*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058201*v_R7_c_r - 23.284964480954*v_R7_n_i - 24.9575997948692*v_R7_n_r
        struct[0].g[83,0] = -9.21038227100566*v_R16_a_i - 1.84896616921897*v_R16_a_r + 30.9517475172273*v_R16_b_i - 5.65456401516768*v_R16_b_r - 9.21038227100566*v_R16_c_i - 1.84896616921897*v_R16_c_r - 9.00835072044485*v_R16_n_i - 0.793238195499528*v_R16_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r + 105.57176931318*v_R5_b_i - 54.0657727682604*v_R5_b_r - 39.6392229058201*v_R5_c_i + 10.2713736253513*v_R5_c_r - 24.9575997948692*v_R5_n_i + 23.284964480954*v_R5_n_r + 88.488828082646*v_R6_a_i - 18.6937810814837*v_R6_a_r - 242.095286143588*v_R6_b_i + 113.786109551688*v_R6_b_r + 88.488828082646*v_R6_c_i - 18.6937810814837*v_R6_c_r + 58.9235503101833*v_R6_n_i - 45.7766907664085*v_R6_n_r - 39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r + 105.57176931318*v_R7_b_i - 54.0657727682604*v_R7_b_r - 39.6392229058201*v_R7_c_i + 10.2713736253513*v_R7_c_r - 24.9575997948692*v_R7_n_i + 23.284964480954*v_R7_n_r
        struct[0].g[84,0] = 0.793238195499527*v_R16_a_i - 9.00835072044484*v_R16_a_r + 1.84896616921897*v_R16_b_i - 9.21038227100566*v_R16_b_r + 5.65456401516768*v_R16_c_i + 30.9517475172273*v_R16_c_r + 1.84896616921897*v_R16_n_i - 9.21038227100566*v_R16_n_r - 23.284964480954*v_R5_a_i - 24.9575997948692*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r + 54.0657727682604*v_R5_c_i + 105.57176931318*v_R5_c_r - 10.2713736253514*v_R5_n_i - 39.6392229058201*v_R5_n_r + 45.7766907664085*v_R6_a_i + 58.9235503101833*v_R6_a_r + 18.6937810814837*v_R6_b_i + 88.4888280826461*v_R6_b_r - 113.786109551688*v_R6_c_i - 242.095286143588*v_R6_c_r + 18.6937810814837*v_R6_n_i + 88.4888280826459*v_R6_n_r - 23.284964480954*v_R7_a_i - 24.9575997948692*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r + 54.0657727682604*v_R7_c_i + 105.57176931318*v_R7_c_r - 10.2713736253514*v_R7_n_i - 39.6392229058201*v_R7_n_r
        struct[0].g[85,0] = -9.00835072044484*v_R16_a_i - 0.793238195499527*v_R16_a_r - 9.21038227100566*v_R16_b_i - 1.84896616921897*v_R16_b_r + 30.9517475172273*v_R16_c_i - 5.65456401516768*v_R16_c_r - 9.21038227100566*v_R16_n_i - 1.84896616921897*v_R16_n_r - 24.9575997948692*v_R5_a_i + 23.284964480954*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r + 105.57176931318*v_R5_c_i - 54.0657727682604*v_R5_c_r - 39.6392229058201*v_R5_n_i + 10.2713736253514*v_R5_n_r + 58.9235503101833*v_R6_a_i - 45.7766907664085*v_R6_a_r + 88.4888280826461*v_R6_b_i - 18.6937810814837*v_R6_b_r - 242.095286143588*v_R6_c_i + 113.786109551688*v_R6_c_r + 88.4888280826459*v_R6_n_i - 18.6937810814837*v_R6_n_r - 24.9575997948692*v_R7_a_i + 23.284964480954*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r + 105.57176931318*v_R7_c_i - 54.0657727682604*v_R7_c_r - 39.6392229058201*v_R7_n_i + 10.2713736253514*v_R7_n_r
        struct[0].g[86,0] = 1.84896616921897*v_R16_a_i - 9.21038227100566*v_R16_a_r + 0.793238195499527*v_R16_b_i - 9.00835072044485*v_R16_b_r + 1.84896616921897*v_R16_c_i - 9.21038227100566*v_R16_c_r + 5.65456401516768*v_R16_n_i + 30.9517475172273*v_R16_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r - 23.284964480954*v_R5_b_i - 24.9575997948692*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058202*v_R5_c_r + 54.0657727682604*v_R5_n_i + 105.57176931318*v_R5_n_r + 18.6937810814837*v_R6_a_i + 88.488828082646*v_R6_a_r + 45.7766907664085*v_R6_b_i + 58.9235503101832*v_R6_b_r + 18.6937810814837*v_R6_c_i + 88.488828082646*v_R6_c_r - 113.786109551688*v_R6_n_i - 242.120286143588*v_R6_n_r - 10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r - 23.284964480954*v_R7_b_i - 24.9575997948692*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058202*v_R7_c_r + 54.0657727682604*v_R7_n_i + 105.57176931318*v_R7_n_r
        struct[0].g[87,0] = -9.21038227100566*v_R16_a_i - 1.84896616921897*v_R16_a_r - 9.00835072044485*v_R16_b_i - 0.793238195499527*v_R16_b_r - 9.21038227100566*v_R16_c_i - 1.84896616921897*v_R16_c_r + 30.9517475172273*v_R16_n_i - 5.65456401516768*v_R16_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r - 24.9575997948692*v_R5_b_i + 23.284964480954*v_R5_b_r - 39.6392229058202*v_R5_c_i + 10.2713736253513*v_R5_c_r + 105.57176931318*v_R5_n_i - 54.0657727682604*v_R5_n_r + 88.488828082646*v_R6_a_i - 18.6937810814837*v_R6_a_r + 58.9235503101832*v_R6_b_i - 45.7766907664085*v_R6_b_r + 88.488828082646*v_R6_c_i - 18.6937810814837*v_R6_c_r - 242.120286143588*v_R6_n_i + 113.786109551688*v_R6_n_r - 39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r - 24.9575997948692*v_R7_b_i + 23.284964480954*v_R7_b_r - 39.6392229058202*v_R7_c_i + 10.2713736253513*v_R7_c_r + 105.57176931318*v_R7_n_i - 54.0657727682604*v_R7_n_r
        struct[0].g[88,0] = 54.0657727682604*v_R6_a_i + 105.57176931318*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r - 23.284964480954*v_R6_c_i - 24.9575997948692*v_R6_c_r - 10.2713736253513*v_R6_n_i - 39.6392229058202*v_R6_n_r - 108.131545536521*v_R7_a_i - 211.14353862636*v_R7_a_r + 20.5427472507027*v_R7_b_i + 79.2784458116403*v_R7_b_r + 46.569928961908*v_R7_c_i + 49.9151995897384*v_R7_c_r + 20.5427472507027*v_R7_n_i + 79.2784458116403*v_R7_n_r + 54.0657727682604*v_R8_a_i + 105.57176931318*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r - 23.284964480954*v_R8_c_i - 24.9575997948692*v_R8_c_r - 10.2713736253513*v_R8_n_i - 39.6392229058202*v_R8_n_r
        struct[0].g[89,0] = 105.57176931318*v_R6_a_i - 54.0657727682604*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r - 24.9575997948692*v_R6_c_i + 23.284964480954*v_R6_c_r - 39.6392229058202*v_R6_n_i + 10.2713736253513*v_R6_n_r - 211.14353862636*v_R7_a_i + 108.131545536521*v_R7_a_r + 79.2784458116403*v_R7_b_i - 20.5427472507027*v_R7_b_r + 49.9151995897384*v_R7_c_i - 46.569928961908*v_R7_c_r + 79.2784458116403*v_R7_n_i - 20.5427472507027*v_R7_n_r + 105.57176931318*v_R8_a_i - 54.0657727682604*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r - 24.9575997948692*v_R8_c_i + 23.284964480954*v_R8_c_r - 39.6392229058202*v_R8_n_i + 10.2713736253513*v_R8_n_r
        struct[0].g[90,0] = -10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r + 54.0657727682604*v_R6_b_i + 105.57176931318*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058201*v_R6_c_r - 23.284964480954*v_R6_n_i - 24.9575997948692*v_R6_n_r + 20.5427472507027*v_R7_a_i + 79.2784458116403*v_R7_a_r - 108.131545536521*v_R7_b_i - 211.14353862636*v_R7_b_r + 20.5427472507027*v_R7_c_i + 79.2784458116403*v_R7_c_r + 46.569928961908*v_R7_n_i + 49.9151995897384*v_R7_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r + 54.0657727682604*v_R8_b_i + 105.57176931318*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058201*v_R8_c_r - 23.284964480954*v_R8_n_i - 24.9575997948692*v_R8_n_r
        struct[0].g[91,0] = -39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r + 105.57176931318*v_R6_b_i - 54.0657727682604*v_R6_b_r - 39.6392229058201*v_R6_c_i + 10.2713736253513*v_R6_c_r - 24.9575997948692*v_R6_n_i + 23.284964480954*v_R6_n_r + 79.2784458116403*v_R7_a_i - 20.5427472507027*v_R7_a_r - 211.14353862636*v_R7_b_i + 108.131545536521*v_R7_b_r + 79.2784458116403*v_R7_c_i - 20.5427472507027*v_R7_c_r + 49.9151995897384*v_R7_n_i - 46.569928961908*v_R7_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r + 105.57176931318*v_R8_b_i - 54.0657727682604*v_R8_b_r - 39.6392229058201*v_R8_c_i + 10.2713736253513*v_R8_c_r - 24.9575997948692*v_R8_n_i + 23.284964480954*v_R8_n_r
        struct[0].g[92,0] = -23.284964480954*v_R6_a_i - 24.9575997948692*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r + 54.0657727682604*v_R6_c_i + 105.57176931318*v_R6_c_r - 10.2713736253514*v_R6_n_i - 39.6392229058201*v_R6_n_r + 46.569928961908*v_R7_a_i + 49.9151995897384*v_R7_a_r + 20.5427472507027*v_R7_b_i + 79.2784458116404*v_R7_b_r - 108.131545536521*v_R7_c_i - 211.14353862636*v_R7_c_r + 20.5427472507027*v_R7_n_i + 79.2784458116403*v_R7_n_r - 23.284964480954*v_R8_a_i - 24.9575997948692*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r + 54.0657727682604*v_R8_c_i + 105.57176931318*v_R8_c_r - 10.2713736253514*v_R8_n_i - 39.6392229058201*v_R8_n_r
        struct[0].g[93,0] = -24.9575997948692*v_R6_a_i + 23.284964480954*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r + 105.57176931318*v_R6_c_i - 54.0657727682604*v_R6_c_r - 39.6392229058201*v_R6_n_i + 10.2713736253514*v_R6_n_r + 49.9151995897384*v_R7_a_i - 46.569928961908*v_R7_a_r + 79.2784458116404*v_R7_b_i - 20.5427472507027*v_R7_b_r - 211.14353862636*v_R7_c_i + 108.131545536521*v_R7_c_r + 79.2784458116403*v_R7_n_i - 20.5427472507027*v_R7_n_r - 24.9575997948692*v_R8_a_i + 23.284964480954*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r + 105.57176931318*v_R8_c_i - 54.0657727682604*v_R8_c_r - 39.6392229058201*v_R8_n_i + 10.2713736253514*v_R8_n_r
        struct[0].g[94,0] = -10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r - 23.284964480954*v_R6_b_i - 24.9575997948692*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058202*v_R6_c_r + 54.0657727682604*v_R6_n_i + 105.57176931318*v_R6_n_r + 20.5427472507027*v_R7_a_i + 79.2784458116403*v_R7_a_r + 46.569928961908*v_R7_b_i + 49.9151995897384*v_R7_b_r + 20.5427472507027*v_R7_c_i + 79.2784458116403*v_R7_c_r - 108.131545536521*v_R7_n_i - 211.14353862636*v_R7_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r - 23.284964480954*v_R8_b_i - 24.9575997948692*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058202*v_R8_c_r + 54.0657727682604*v_R8_n_i + 105.57176931318*v_R8_n_r
        struct[0].g[95,0] = -39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r - 24.9575997948692*v_R6_b_i + 23.284964480954*v_R6_b_r - 39.6392229058202*v_R6_c_i + 10.2713736253513*v_R6_c_r + 105.57176931318*v_R6_n_i - 54.0657727682604*v_R6_n_r + 79.2784458116403*v_R7_a_i - 20.5427472507027*v_R7_a_r + 49.9151995897384*v_R7_b_i - 46.569928961908*v_R7_b_r + 79.2784458116403*v_R7_c_i - 20.5427472507027*v_R7_c_r - 211.14353862636*v_R7_n_i + 108.131545536521*v_R7_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r - 24.9575997948692*v_R8_b_i + 23.284964480954*v_R8_b_r - 39.6392229058202*v_R8_c_i + 10.2713736253513*v_R8_c_r + 105.57176931318*v_R8_n_i - 54.0657727682604*v_R8_n_r
        struct[0].g[96,0] = 54.0657727682604*v_R7_a_i + 105.57176931318*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r - 23.284964480954*v_R7_c_i - 24.9575997948692*v_R7_c_r - 10.2713736253513*v_R7_n_i - 39.6392229058202*v_R7_n_r - 108.131545536521*v_R8_a_i - 211.14353862636*v_R8_a_r + 20.5427472507027*v_R8_b_i + 79.2784458116403*v_R8_b_r + 46.569928961908*v_R8_c_i + 49.9151995897384*v_R8_c_r + 20.5427472507027*v_R8_n_i + 79.2784458116403*v_R8_n_r + 54.0657727682604*v_R9_a_i + 105.57176931318*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r - 23.284964480954*v_R9_c_i - 24.9575997948692*v_R9_c_r - 10.2713736253513*v_R9_n_i - 39.6392229058202*v_R9_n_r
        struct[0].g[97,0] = 105.57176931318*v_R7_a_i - 54.0657727682604*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r - 24.9575997948692*v_R7_c_i + 23.284964480954*v_R7_c_r - 39.6392229058202*v_R7_n_i + 10.2713736253513*v_R7_n_r - 211.14353862636*v_R8_a_i + 108.131545536521*v_R8_a_r + 79.2784458116403*v_R8_b_i - 20.5427472507027*v_R8_b_r + 49.9151995897384*v_R8_c_i - 46.569928961908*v_R8_c_r + 79.2784458116403*v_R8_n_i - 20.5427472507027*v_R8_n_r + 105.57176931318*v_R9_a_i - 54.0657727682604*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r - 24.9575997948692*v_R9_c_i + 23.284964480954*v_R9_c_r - 39.6392229058202*v_R9_n_i + 10.2713736253513*v_R9_n_r
        struct[0].g[98,0] = -10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r + 54.0657727682604*v_R7_b_i + 105.57176931318*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058201*v_R7_c_r - 23.284964480954*v_R7_n_i - 24.9575997948692*v_R7_n_r + 20.5427472507027*v_R8_a_i + 79.2784458116403*v_R8_a_r - 108.131545536521*v_R8_b_i - 211.14353862636*v_R8_b_r + 20.5427472507027*v_R8_c_i + 79.2784458116403*v_R8_c_r + 46.569928961908*v_R8_n_i + 49.9151995897384*v_R8_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r + 54.0657727682604*v_R9_b_i + 105.57176931318*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058201*v_R9_c_r - 23.284964480954*v_R9_n_i - 24.9575997948692*v_R9_n_r
        struct[0].g[99,0] = -39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r + 105.57176931318*v_R7_b_i - 54.0657727682604*v_R7_b_r - 39.6392229058201*v_R7_c_i + 10.2713736253513*v_R7_c_r - 24.9575997948692*v_R7_n_i + 23.284964480954*v_R7_n_r + 79.2784458116403*v_R8_a_i - 20.5427472507027*v_R8_a_r - 211.14353862636*v_R8_b_i + 108.131545536521*v_R8_b_r + 79.2784458116403*v_R8_c_i - 20.5427472507027*v_R8_c_r + 49.9151995897384*v_R8_n_i - 46.569928961908*v_R8_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r + 105.57176931318*v_R9_b_i - 54.0657727682604*v_R9_b_r - 39.6392229058201*v_R9_c_i + 10.2713736253513*v_R9_c_r - 24.9575997948692*v_R9_n_i + 23.284964480954*v_R9_n_r
        struct[0].g[100,0] = -23.284964480954*v_R7_a_i - 24.9575997948692*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r + 54.0657727682604*v_R7_c_i + 105.57176931318*v_R7_c_r - 10.2713736253514*v_R7_n_i - 39.6392229058201*v_R7_n_r + 46.569928961908*v_R8_a_i + 49.9151995897384*v_R8_a_r + 20.5427472507027*v_R8_b_i + 79.2784458116404*v_R8_b_r - 108.131545536521*v_R8_c_i - 211.14353862636*v_R8_c_r + 20.5427472507027*v_R8_n_i + 79.2784458116403*v_R8_n_r - 23.284964480954*v_R9_a_i - 24.9575997948692*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r + 54.0657727682604*v_R9_c_i + 105.57176931318*v_R9_c_r - 10.2713736253514*v_R9_n_i - 39.6392229058201*v_R9_n_r
        struct[0].g[101,0] = -24.9575997948692*v_R7_a_i + 23.284964480954*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r + 105.57176931318*v_R7_c_i - 54.0657727682604*v_R7_c_r - 39.6392229058201*v_R7_n_i + 10.2713736253514*v_R7_n_r + 49.9151995897384*v_R8_a_i - 46.569928961908*v_R8_a_r + 79.2784458116404*v_R8_b_i - 20.5427472507027*v_R8_b_r - 211.14353862636*v_R8_c_i + 108.131545536521*v_R8_c_r + 79.2784458116403*v_R8_n_i - 20.5427472507027*v_R8_n_r - 24.9575997948692*v_R9_a_i + 23.284964480954*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r + 105.57176931318*v_R9_c_i - 54.0657727682604*v_R9_c_r - 39.6392229058201*v_R9_n_i + 10.2713736253514*v_R9_n_r
        struct[0].g[102,0] = -10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r - 23.284964480954*v_R7_b_i - 24.9575997948692*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058202*v_R7_c_r + 54.0657727682604*v_R7_n_i + 105.57176931318*v_R7_n_r + 20.5427472507027*v_R8_a_i + 79.2784458116403*v_R8_a_r + 46.569928961908*v_R8_b_i + 49.9151995897384*v_R8_b_r + 20.5427472507027*v_R8_c_i + 79.2784458116403*v_R8_c_r - 108.131545536521*v_R8_n_i - 211.16853862636*v_R8_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r - 23.284964480954*v_R9_b_i - 24.9575997948692*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058202*v_R9_c_r + 54.0657727682604*v_R9_n_i + 105.57176931318*v_R9_n_r
        struct[0].g[103,0] = -39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r - 24.9575997948692*v_R7_b_i + 23.284964480954*v_R7_b_r - 39.6392229058202*v_R7_c_i + 10.2713736253513*v_R7_c_r + 105.57176931318*v_R7_n_i - 54.0657727682604*v_R7_n_r + 79.2784458116403*v_R8_a_i - 20.5427472507027*v_R8_a_r + 49.9151995897384*v_R8_b_i - 46.569928961908*v_R8_b_r + 79.2784458116403*v_R8_c_i - 20.5427472507027*v_R8_c_r - 211.16853862636*v_R8_n_i + 108.131545536521*v_R8_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r - 24.9575997948692*v_R9_b_i + 23.284964480954*v_R9_b_r - 39.6392229058202*v_R9_c_i + 10.2713736253513*v_R9_c_r + 105.57176931318*v_R9_n_i - 54.0657727682604*v_R9_n_r
        struct[0].g[104,0] = 54.0657727682604*v_R10_a_i + 105.57176931318*v_R10_a_r - 10.2713736253513*v_R10_b_i - 39.6392229058202*v_R10_b_r - 23.284964480954*v_R10_c_i - 24.9575997948692*v_R10_c_r - 10.2713736253513*v_R10_n_i - 39.6392229058202*v_R10_n_r + 5.65456401516768*v_R17_a_i + 30.9517475172273*v_R17_a_r + 1.84896616921897*v_R17_b_i - 9.21038227100566*v_R17_b_r + 0.793238195499529*v_R17_c_i - 9.00835072044485*v_R17_c_r + 1.84896616921897*v_R17_n_i - 9.21038227100566*v_R17_n_r + 54.0657727682604*v_R8_a_i + 105.57176931318*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r - 23.284964480954*v_R8_c_i - 24.9575997948692*v_R8_c_r - 10.2713736253513*v_R8_n_i - 39.6392229058202*v_R8_n_r - 113.786109551688*v_R9_a_i - 242.095286143588*v_R9_a_r + 18.6937810814837*v_R9_b_i + 88.488828082646*v_R9_b_r + 45.7766907664085*v_R9_c_i + 58.9235503101833*v_R9_c_r + 18.6937810814837*v_R9_n_i + 88.488828082646*v_R9_n_r
        struct[0].g[105,0] = 105.57176931318*v_R10_a_i - 54.0657727682604*v_R10_a_r - 39.6392229058202*v_R10_b_i + 10.2713736253513*v_R10_b_r - 24.9575997948692*v_R10_c_i + 23.284964480954*v_R10_c_r - 39.6392229058202*v_R10_n_i + 10.2713736253513*v_R10_n_r + 30.9517475172273*v_R17_a_i - 5.65456401516768*v_R17_a_r - 9.21038227100566*v_R17_b_i - 1.84896616921897*v_R17_b_r - 9.00835072044485*v_R17_c_i - 0.793238195499529*v_R17_c_r - 9.21038227100566*v_R17_n_i - 1.84896616921897*v_R17_n_r + 105.57176931318*v_R8_a_i - 54.0657727682604*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r - 24.9575997948692*v_R8_c_i + 23.284964480954*v_R8_c_r - 39.6392229058202*v_R8_n_i + 10.2713736253513*v_R8_n_r - 242.095286143588*v_R9_a_i + 113.786109551688*v_R9_a_r + 88.488828082646*v_R9_b_i - 18.6937810814837*v_R9_b_r + 58.9235503101833*v_R9_c_i - 45.7766907664085*v_R9_c_r + 88.488828082646*v_R9_n_i - 18.6937810814837*v_R9_n_r
        struct[0].g[106,0] = -10.2713736253513*v_R10_a_i - 39.6392229058202*v_R10_a_r + 54.0657727682604*v_R10_b_i + 105.57176931318*v_R10_b_r - 10.2713736253513*v_R10_c_i - 39.6392229058201*v_R10_c_r - 23.284964480954*v_R10_n_i - 24.9575997948692*v_R10_n_r + 1.84896616921897*v_R17_a_i - 9.21038227100566*v_R17_a_r + 5.65456401516768*v_R17_b_i + 30.9517475172273*v_R17_b_r + 1.84896616921897*v_R17_c_i - 9.21038227100566*v_R17_c_r + 0.793238195499528*v_R17_n_i - 9.00835072044485*v_R17_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r + 54.0657727682604*v_R8_b_i + 105.57176931318*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058201*v_R8_c_r - 23.284964480954*v_R8_n_i - 24.9575997948692*v_R8_n_r + 18.6937810814837*v_R9_a_i + 88.488828082646*v_R9_a_r - 113.786109551688*v_R9_b_i - 242.095286143588*v_R9_b_r + 18.6937810814837*v_R9_c_i + 88.488828082646*v_R9_c_r + 45.7766907664085*v_R9_n_i + 58.9235503101833*v_R9_n_r
        struct[0].g[107,0] = -39.6392229058202*v_R10_a_i + 10.2713736253513*v_R10_a_r + 105.57176931318*v_R10_b_i - 54.0657727682604*v_R10_b_r - 39.6392229058201*v_R10_c_i + 10.2713736253513*v_R10_c_r - 24.9575997948692*v_R10_n_i + 23.284964480954*v_R10_n_r - 9.21038227100566*v_R17_a_i - 1.84896616921897*v_R17_a_r + 30.9517475172273*v_R17_b_i - 5.65456401516768*v_R17_b_r - 9.21038227100566*v_R17_c_i - 1.84896616921897*v_R17_c_r - 9.00835072044485*v_R17_n_i - 0.793238195499528*v_R17_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r + 105.57176931318*v_R8_b_i - 54.0657727682604*v_R8_b_r - 39.6392229058201*v_R8_c_i + 10.2713736253513*v_R8_c_r - 24.9575997948692*v_R8_n_i + 23.284964480954*v_R8_n_r + 88.488828082646*v_R9_a_i - 18.6937810814837*v_R9_a_r - 242.095286143588*v_R9_b_i + 113.786109551688*v_R9_b_r + 88.488828082646*v_R9_c_i - 18.6937810814837*v_R9_c_r + 58.9235503101833*v_R9_n_i - 45.7766907664085*v_R9_n_r
        struct[0].g[108,0] = -23.284964480954*v_R10_a_i - 24.9575997948692*v_R10_a_r - 10.2713736253513*v_R10_b_i - 39.6392229058202*v_R10_b_r + 54.0657727682604*v_R10_c_i + 105.57176931318*v_R10_c_r - 10.2713736253514*v_R10_n_i - 39.6392229058201*v_R10_n_r + 0.793238195499527*v_R17_a_i - 9.00835072044484*v_R17_a_r + 1.84896616921897*v_R17_b_i - 9.21038227100566*v_R17_b_r + 5.65456401516768*v_R17_c_i + 30.9517475172273*v_R17_c_r + 1.84896616921897*v_R17_n_i - 9.21038227100566*v_R17_n_r - 23.284964480954*v_R8_a_i - 24.9575997948692*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r + 54.0657727682604*v_R8_c_i + 105.57176931318*v_R8_c_r - 10.2713736253514*v_R8_n_i - 39.6392229058201*v_R8_n_r + 45.7766907664085*v_R9_a_i + 58.9235503101833*v_R9_a_r + 18.6937810814837*v_R9_b_i + 88.4888280826461*v_R9_b_r - 113.786109551688*v_R9_c_i - 242.095286143588*v_R9_c_r + 18.6937810814837*v_R9_n_i + 88.4888280826459*v_R9_n_r
        struct[0].g[109,0] = -24.9575997948692*v_R10_a_i + 23.284964480954*v_R10_a_r - 39.6392229058202*v_R10_b_i + 10.2713736253513*v_R10_b_r + 105.57176931318*v_R10_c_i - 54.0657727682604*v_R10_c_r - 39.6392229058201*v_R10_n_i + 10.2713736253514*v_R10_n_r - 9.00835072044484*v_R17_a_i - 0.793238195499527*v_R17_a_r - 9.21038227100566*v_R17_b_i - 1.84896616921897*v_R17_b_r + 30.9517475172273*v_R17_c_i - 5.65456401516768*v_R17_c_r - 9.21038227100566*v_R17_n_i - 1.84896616921897*v_R17_n_r - 24.9575997948692*v_R8_a_i + 23.284964480954*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r + 105.57176931318*v_R8_c_i - 54.0657727682604*v_R8_c_r - 39.6392229058201*v_R8_n_i + 10.2713736253514*v_R8_n_r + 58.9235503101833*v_R9_a_i - 45.7766907664085*v_R9_a_r + 88.4888280826461*v_R9_b_i - 18.6937810814837*v_R9_b_r - 242.095286143588*v_R9_c_i + 113.786109551688*v_R9_c_r + 88.4888280826459*v_R9_n_i - 18.6937810814837*v_R9_n_r
        struct[0].g[110,0] = -10.2713736253513*v_R10_a_i - 39.6392229058202*v_R10_a_r - 23.284964480954*v_R10_b_i - 24.9575997948692*v_R10_b_r - 10.2713736253513*v_R10_c_i - 39.6392229058202*v_R10_c_r + 54.0657727682604*v_R10_n_i + 105.57176931318*v_R10_n_r + 1.84896616921897*v_R17_a_i - 9.21038227100566*v_R17_a_r + 0.793238195499527*v_R17_b_i - 9.00835072044485*v_R17_b_r + 1.84896616921897*v_R17_c_i - 9.21038227100566*v_R17_c_r + 5.65456401516768*v_R17_n_i + 30.9517475172273*v_R17_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r - 23.284964480954*v_R8_b_i - 24.9575997948692*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058202*v_R8_c_r + 54.0657727682604*v_R8_n_i + 105.57176931318*v_R8_n_r + 18.6937810814837*v_R9_a_i + 88.488828082646*v_R9_a_r + 45.7766907664085*v_R9_b_i + 58.9235503101832*v_R9_b_r + 18.6937810814837*v_R9_c_i + 88.488828082646*v_R9_c_r - 113.786109551688*v_R9_n_i - 242.095286143588*v_R9_n_r
        struct[0].g[111,0] = -39.6392229058202*v_R10_a_i + 10.2713736253513*v_R10_a_r - 24.9575997948692*v_R10_b_i + 23.284964480954*v_R10_b_r - 39.6392229058202*v_R10_c_i + 10.2713736253513*v_R10_c_r + 105.57176931318*v_R10_n_i - 54.0657727682604*v_R10_n_r - 9.21038227100566*v_R17_a_i - 1.84896616921897*v_R17_a_r - 9.00835072044485*v_R17_b_i - 0.793238195499527*v_R17_b_r - 9.21038227100566*v_R17_c_i - 1.84896616921897*v_R17_c_r + 30.9517475172273*v_R17_n_i - 5.65456401516768*v_R17_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r - 24.9575997948692*v_R8_b_i + 23.284964480954*v_R8_b_r - 39.6392229058202*v_R8_c_i + 10.2713736253513*v_R8_c_r + 105.57176931318*v_R8_n_i - 54.0657727682604*v_R8_n_r + 88.488828082646*v_R9_a_i - 18.6937810814837*v_R9_a_r + 58.9235503101832*v_R9_b_i - 45.7766907664085*v_R9_b_r + 88.488828082646*v_R9_c_i - 18.6937810814837*v_R9_c_r - 242.095286143588*v_R9_n_i + 113.786109551688*v_R9_n_r
        struct[0].g[112,0] = i_vsc_R10_a_r - 59.7203367834281*v_R10_a_i - 136.523516830407*v_R10_a_r + 8.42240745613237*v_R10_b_i + 48.8496051768258*v_R10_b_r + 22.4917262854545*v_R10_c_i + 33.9659505153141*v_R10_c_r + 8.42240745613237*v_R10_n_i + 48.8496051768258*v_R10_n_r + 5.65456401516768*v_R18_a_i + 30.9517475172273*v_R18_a_r + 1.84896616921897*v_R18_b_i - 9.21038227100566*v_R18_b_r + 0.793238195499529*v_R18_c_i - 9.00835072044485*v_R18_c_r + 1.84896616921897*v_R18_n_i - 9.21038227100566*v_R18_n_r + 54.0657727682604*v_R9_a_i + 105.57176931318*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r - 23.284964480954*v_R9_c_i - 24.9575997948692*v_R9_c_r - 10.2713736253513*v_R9_n_i - 39.6392229058202*v_R9_n_r
        struct[0].g[113,0] = i_vsc_R10_a_i - 136.523516830407*v_R10_a_i + 59.7203367834281*v_R10_a_r + 48.8496051768258*v_R10_b_i - 8.42240745613237*v_R10_b_r + 33.9659505153141*v_R10_c_i - 22.4917262854545*v_R10_c_r + 48.8496051768258*v_R10_n_i - 8.42240745613237*v_R10_n_r + 30.9517475172273*v_R18_a_i - 5.65456401516768*v_R18_a_r - 9.21038227100566*v_R18_b_i - 1.84896616921897*v_R18_b_r - 9.00835072044485*v_R18_c_i - 0.793238195499529*v_R18_c_r - 9.21038227100566*v_R18_n_i - 1.84896616921897*v_R18_n_r + 105.57176931318*v_R9_a_i - 54.0657727682604*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r - 24.9575997948692*v_R9_c_i + 23.284964480954*v_R9_c_r - 39.6392229058202*v_R9_n_i + 10.2713736253513*v_R9_n_r
        struct[0].g[114,0] = i_vsc_R10_b_r + 8.42240745613237*v_R10_a_i + 48.8496051768258*v_R10_a_r - 59.720336783428*v_R10_b_i - 136.523516830407*v_R10_b_r + 8.42240745613238*v_R10_c_i + 48.8496051768258*v_R10_c_r + 22.4917262854545*v_R10_n_i + 33.9659505153141*v_R10_n_r + 1.84896616921897*v_R18_a_i - 9.21038227100566*v_R18_a_r + 5.65456401516768*v_R18_b_i + 30.9517475172273*v_R18_b_r + 1.84896616921897*v_R18_c_i - 9.21038227100566*v_R18_c_r + 0.793238195499528*v_R18_n_i - 9.00835072044485*v_R18_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r + 54.0657727682604*v_R9_b_i + 105.57176931318*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058201*v_R9_c_r - 23.284964480954*v_R9_n_i - 24.9575997948692*v_R9_n_r
        struct[0].g[115,0] = i_vsc_R10_b_i + 48.8496051768258*v_R10_a_i - 8.42240745613237*v_R10_a_r - 136.523516830407*v_R10_b_i + 59.720336783428*v_R10_b_r + 48.8496051768258*v_R10_c_i - 8.42240745613238*v_R10_c_r + 33.9659505153141*v_R10_n_i - 22.4917262854545*v_R10_n_r - 9.21038227100566*v_R18_a_i - 1.84896616921897*v_R18_a_r + 30.9517475172273*v_R18_b_i - 5.65456401516768*v_R18_b_r - 9.21038227100566*v_R18_c_i - 1.84896616921897*v_R18_c_r - 9.00835072044485*v_R18_n_i - 0.793238195499528*v_R18_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r + 105.57176931318*v_R9_b_i - 54.0657727682604*v_R9_b_r - 39.6392229058201*v_R9_c_i + 10.2713736253513*v_R9_c_r - 24.9575997948692*v_R9_n_i + 23.284964480954*v_R9_n_r
        struct[0].g[116,0] = i_vsc_R10_c_r + 22.4917262854545*v_R10_a_i + 33.9659505153141*v_R10_a_r + 8.42240745613236*v_R10_b_i + 48.8496051768259*v_R10_b_r - 59.7203367834281*v_R10_c_i - 136.523516830407*v_R10_c_r + 8.42240745613239*v_R10_n_i + 48.8496051768258*v_R10_n_r + 0.793238195499527*v_R18_a_i - 9.00835072044484*v_R18_a_r + 1.84896616921897*v_R18_b_i - 9.21038227100566*v_R18_b_r + 5.65456401516768*v_R18_c_i + 30.9517475172273*v_R18_c_r + 1.84896616921897*v_R18_n_i - 9.21038227100566*v_R18_n_r - 23.284964480954*v_R9_a_i - 24.9575997948692*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r + 54.0657727682604*v_R9_c_i + 105.57176931318*v_R9_c_r - 10.2713736253514*v_R9_n_i - 39.6392229058201*v_R9_n_r
        struct[0].g[117,0] = i_vsc_R10_c_i + 33.9659505153141*v_R10_a_i - 22.4917262854545*v_R10_a_r + 48.8496051768259*v_R10_b_i - 8.42240745613236*v_R10_b_r - 136.523516830407*v_R10_c_i + 59.7203367834281*v_R10_c_r + 48.8496051768258*v_R10_n_i - 8.42240745613239*v_R10_n_r - 9.00835072044484*v_R18_a_i - 0.793238195499527*v_R18_a_r - 9.21038227100566*v_R18_b_i - 1.84896616921897*v_R18_b_r + 30.9517475172273*v_R18_c_i - 5.65456401516768*v_R18_c_r - 9.21038227100566*v_R18_n_i - 1.84896616921897*v_R18_n_r - 24.9575997948692*v_R9_a_i + 23.284964480954*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r + 105.57176931318*v_R9_c_i - 54.0657727682604*v_R9_c_r - 39.6392229058201*v_R9_n_i + 10.2713736253514*v_R9_n_r
        struct[0].g[118,0] = i_vsc_R10_n_r + 8.42240745613237*v_R10_a_i + 48.8496051768258*v_R10_a_r + 22.4917262854545*v_R10_b_i + 33.965950515314*v_R10_b_r + 8.42240745613237*v_R10_c_i + 48.8496051768258*v_R10_c_r - 59.7203367834281*v_R10_n_i - 136.548516830407*v_R10_n_r + 1.84896616921897*v_R18_a_i - 9.21038227100566*v_R18_a_r + 0.793238195499527*v_R18_b_i - 9.00835072044485*v_R18_b_r + 1.84896616921897*v_R18_c_i - 9.21038227100566*v_R18_c_r + 5.65456401516768*v_R18_n_i + 30.9517475172273*v_R18_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r - 23.284964480954*v_R9_b_i - 24.9575997948692*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058202*v_R9_c_r + 54.0657727682604*v_R9_n_i + 105.57176931318*v_R9_n_r
        struct[0].g[119,0] = i_vsc_R10_n_i + 48.8496051768258*v_R10_a_i - 8.42240745613237*v_R10_a_r + 33.965950515314*v_R10_b_i - 22.4917262854545*v_R10_b_r + 48.8496051768258*v_R10_c_i - 8.42240745613237*v_R10_c_r - 136.548516830407*v_R10_n_i + 59.7203367834281*v_R10_n_r - 9.21038227100566*v_R18_a_i - 1.84896616921897*v_R18_a_r - 9.00835072044485*v_R18_b_i - 0.793238195499527*v_R18_b_r - 9.21038227100566*v_R18_c_i - 1.84896616921897*v_R18_c_r + 30.9517475172273*v_R18_n_i - 5.65456401516768*v_R18_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r - 24.9575997948692*v_R9_b_i + 23.284964480954*v_R9_b_r - 39.6392229058202*v_R9_c_i + 10.2713736253513*v_R9_c_r + 105.57176931318*v_R9_n_i - 54.0657727682604*v_R9_n_r
        struct[0].g[120,0] = -1.58482814504483*v_R11_a_i + 7.89461337514771*v_R11_a_r - 4.84676915585801*v_R11_b_i - 26.5300693004806*v_R11_b_r - 1.58482814504483*v_R11_c_i + 7.89461337514771*v_R11_c_r - 0.679918453285308*v_R11_n_i + 7.72144347466701*v_R11_n_r + 1.58482814504483*v_R3_a_i - 7.89461337514771*v_R3_a_r + 4.84676915585801*v_R3_b_i + 26.5300693004806*v_R3_b_r + 1.58482814504483*v_R3_c_i - 7.89461337514771*v_R3_c_r + 0.679918453285308*v_R3_n_i - 7.72144347466701*v_R3_n_r
        struct[0].g[121,0] = 7.89461337514771*v_R11_a_i + 1.58482814504483*v_R11_a_r - 26.5300693004806*v_R11_b_i + 4.84676915585801*v_R11_b_r + 7.89461337514771*v_R11_c_i + 1.58482814504483*v_R11_c_r + 7.72144347466701*v_R11_n_i + 0.679918453285308*v_R11_n_r - 7.89461337514771*v_R3_a_i - 1.58482814504483*v_R3_a_r + 26.5300693004806*v_R3_b_i - 4.84676915585801*v_R3_b_r - 7.89461337514771*v_R3_c_i - 1.58482814504483*v_R3_c_r - 7.72144347466701*v_R3_n_i - 0.679918453285308*v_R3_n_r
        struct[0].g[122,0] = -0.67991845328531*v_R11_a_i + 7.72144347466701*v_R11_a_r - 1.58482814504483*v_R11_b_i + 7.8946133751477*v_R11_b_r - 4.84676915585801*v_R11_c_i - 26.5300693004806*v_R11_c_r - 1.58482814504483*v_R11_n_i + 7.89461337514771*v_R11_n_r + 0.67991845328531*v_R3_a_i - 7.72144347466701*v_R3_a_r + 1.58482814504483*v_R3_b_i - 7.8946133751477*v_R3_b_r + 4.84676915585801*v_R3_c_i + 26.5300693004806*v_R3_c_r + 1.58482814504483*v_R3_n_i - 7.89461337514771*v_R3_n_r
        struct[0].g[123,0] = 7.72144347466701*v_R11_a_i + 0.67991845328531*v_R11_a_r + 7.8946133751477*v_R11_b_i + 1.58482814504483*v_R11_b_r - 26.5300693004806*v_R11_c_i + 4.84676915585801*v_R11_c_r + 7.89461337514771*v_R11_n_i + 1.58482814504483*v_R11_n_r - 7.72144347466701*v_R3_a_i - 0.67991845328531*v_R3_a_r - 7.8946133751477*v_R3_b_i - 1.58482814504483*v_R3_b_r + 26.5300693004806*v_R3_c_i - 4.84676915585801*v_R3_c_r - 7.89461337514771*v_R3_n_i - 1.58482814504483*v_R3_n_r
        struct[0].g[124,0] = -9.69353831171601*v_R12_a_i - 53.0601386009611*v_R12_a_r - 3.16965629008966*v_R12_b_i + 15.7892267502954*v_R12_b_r - 1.35983690657062*v_R12_c_i + 15.442886949334*v_R12_c_r - 3.16965629008966*v_R12_n_i + 15.7892267502954*v_R12_n_r + 4.84676915585801*v_R13_a_i + 26.5300693004806*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 0.67991845328531*v_R13_c_i - 7.72144347466701*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r + 4.84676915585801*v_R4_a_i + 26.5300693004806*v_R4_a_r + 1.58482814504483*v_R4_b_i - 7.8946133751477*v_R4_b_r + 0.67991845328531*v_R4_c_i - 7.72144347466701*v_R4_c_r + 1.58482814504483*v_R4_n_i - 7.89461337514771*v_R4_n_r
        struct[0].g[125,0] = -53.0601386009611*v_R12_a_i + 9.69353831171601*v_R12_a_r + 15.7892267502954*v_R12_b_i + 3.16965629008966*v_R12_b_r + 15.442886949334*v_R12_c_i + 1.35983690657062*v_R12_c_r + 15.7892267502954*v_R12_n_i + 3.16965629008966*v_R12_n_r + 26.5300693004806*v_R13_a_i - 4.84676915585801*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r - 7.72144347466701*v_R13_c_i - 0.67991845328531*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r + 26.5300693004806*v_R4_a_i - 4.84676915585801*v_R4_a_r - 7.8946133751477*v_R4_b_i - 1.58482814504483*v_R4_b_r - 7.72144347466701*v_R4_c_i - 0.67991845328531*v_R4_c_r - 7.89461337514771*v_R4_n_i - 1.58482814504483*v_R4_n_r
        struct[0].g[126,0] = -3.16965629008966*v_R12_a_i + 15.7892267502954*v_R12_a_r - 9.69353831171602*v_R12_b_i - 53.0601386009611*v_R12_b_r - 3.16965629008967*v_R12_c_i + 15.7892267502954*v_R12_c_r - 1.35983690657062*v_R12_n_i + 15.442886949334*v_R12_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 4.84676915585801*v_R13_b_i + 26.5300693004806*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 0.679918453285308*v_R13_n_i - 7.72144347466701*v_R13_n_r + 1.58482814504483*v_R4_a_i - 7.89461337514771*v_R4_a_r + 4.84676915585801*v_R4_b_i + 26.5300693004806*v_R4_b_r + 1.58482814504483*v_R4_c_i - 7.89461337514771*v_R4_c_r + 0.679918453285308*v_R4_n_i - 7.72144347466701*v_R4_n_r
        struct[0].g[127,0] = 15.7892267502954*v_R12_a_i + 3.16965629008966*v_R12_a_r - 53.0601386009611*v_R12_b_i + 9.69353831171602*v_R12_b_r + 15.7892267502954*v_R12_c_i + 3.16965629008967*v_R12_c_r + 15.442886949334*v_R12_n_i + 1.35983690657062*v_R12_n_r - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r + 26.5300693004806*v_R13_b_i - 4.84676915585801*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r - 7.72144347466701*v_R13_n_i - 0.679918453285308*v_R13_n_r - 7.89461337514771*v_R4_a_i - 1.58482814504483*v_R4_a_r + 26.5300693004806*v_R4_b_i - 4.84676915585801*v_R4_b_r - 7.89461337514771*v_R4_c_i - 1.58482814504483*v_R4_c_r - 7.72144347466701*v_R4_n_i - 0.679918453285308*v_R4_n_r
        struct[0].g[128,0] = -1.35983690657062*v_R12_a_i + 15.442886949334*v_R12_a_r - 3.16965629008966*v_R12_b_i + 15.7892267502954*v_R12_b_r - 9.69353831171602*v_R12_c_i - 53.0601386009611*v_R12_c_r - 3.16965629008967*v_R12_n_i + 15.7892267502954*v_R12_n_r + 0.67991845328531*v_R13_a_i - 7.72144347466701*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 4.84676915585801*v_R13_c_i + 26.5300693004806*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r + 0.67991845328531*v_R4_a_i - 7.72144347466701*v_R4_a_r + 1.58482814504483*v_R4_b_i - 7.8946133751477*v_R4_b_r + 4.84676915585801*v_R4_c_i + 26.5300693004806*v_R4_c_r + 1.58482814504483*v_R4_n_i - 7.89461337514771*v_R4_n_r
        struct[0].g[129,0] = 15.442886949334*v_R12_a_i + 1.35983690657062*v_R12_a_r + 15.7892267502954*v_R12_b_i + 3.16965629008966*v_R12_b_r - 53.0601386009611*v_R12_c_i + 9.69353831171602*v_R12_c_r + 15.7892267502954*v_R12_n_i + 3.16965629008967*v_R12_n_r - 7.72144347466701*v_R13_a_i - 0.67991845328531*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r + 26.5300693004806*v_R13_c_i - 4.84676915585801*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r - 7.72144347466701*v_R4_a_i - 0.67991845328531*v_R4_a_r - 7.8946133751477*v_R4_b_i - 1.58482814504483*v_R4_b_r + 26.5300693004806*v_R4_c_i - 4.84676915585801*v_R4_c_r - 7.89461337514771*v_R4_n_i - 1.58482814504483*v_R4_n_r
        struct[0].g[130,0] = -3.16965629008966*v_R12_a_i + 15.7892267502954*v_R12_a_r - 1.35983690657062*v_R12_b_i + 15.442886949334*v_R12_b_r - 3.16965629008966*v_R12_c_i + 15.7892267502954*v_R12_c_r - 9.69353831171602*v_R12_n_i - 53.0601386009611*v_R12_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 0.679918453285308*v_R13_b_i - 7.72144347466701*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 4.84676915585801*v_R13_n_i + 26.5300693004806*v_R13_n_r + 1.58482814504483*v_R4_a_i - 7.89461337514771*v_R4_a_r + 0.679918453285308*v_R4_b_i - 7.72144347466701*v_R4_b_r + 1.58482814504483*v_R4_c_i - 7.89461337514771*v_R4_c_r + 4.84676915585801*v_R4_n_i + 26.5300693004806*v_R4_n_r
        struct[0].g[131,0] = 15.7892267502954*v_R12_a_i + 3.16965629008966*v_R12_a_r + 15.442886949334*v_R12_b_i + 1.35983690657062*v_R12_b_r + 15.7892267502954*v_R12_c_i + 3.16965629008966*v_R12_c_r - 53.0601386009611*v_R12_n_i + 9.69353831171602*v_R12_n_r - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r - 7.72144347466701*v_R13_b_i - 0.679918453285308*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r + 26.5300693004806*v_R13_n_i - 4.84676915585801*v_R13_n_r - 7.89461337514771*v_R4_a_i - 1.58482814504483*v_R4_a_r - 7.72144347466701*v_R4_b_i - 0.679918453285308*v_R4_b_r - 7.89461337514771*v_R4_c_i - 1.58482814504483*v_R4_c_r + 26.5300693004806*v_R4_n_i - 4.84676915585801*v_R4_n_r
        struct[0].g[132,0] = 4.84676915585801*v_R12_a_i + 26.5300693004806*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 0.67991845328531*v_R12_c_i - 7.72144347466701*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 9.69353831171601*v_R13_a_i - 53.0601386009611*v_R13_a_r - 3.16965629008966*v_R13_b_i + 15.7892267502954*v_R13_b_r - 1.35983690657062*v_R13_c_i + 15.442886949334*v_R13_c_r - 3.16965629008966*v_R13_n_i + 15.7892267502954*v_R13_n_r + 4.84676915585801*v_R14_a_i + 26.5300693004806*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 0.67991845328531*v_R14_c_i - 7.72144347466701*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r
        struct[0].g[133,0] = 26.5300693004806*v_R12_a_i - 4.84676915585801*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r - 7.72144347466701*v_R12_c_i - 0.67991845328531*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r - 53.0601386009611*v_R13_a_i + 9.69353831171601*v_R13_a_r + 15.7892267502954*v_R13_b_i + 3.16965629008966*v_R13_b_r + 15.442886949334*v_R13_c_i + 1.35983690657062*v_R13_c_r + 15.7892267502954*v_R13_n_i + 3.16965629008966*v_R13_n_r + 26.5300693004806*v_R14_a_i - 4.84676915585801*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r - 7.72144347466701*v_R14_c_i - 0.67991845328531*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r
        struct[0].g[134,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 4.84676915585801*v_R12_b_i + 26.5300693004806*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 0.679918453285308*v_R12_n_i - 7.72144347466701*v_R12_n_r - 3.16965629008966*v_R13_a_i + 15.7892267502954*v_R13_a_r - 9.69353831171602*v_R13_b_i - 53.0601386009611*v_R13_b_r - 3.16965629008967*v_R13_c_i + 15.7892267502954*v_R13_c_r - 1.35983690657062*v_R13_n_i + 15.442886949334*v_R13_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 4.84676915585801*v_R14_b_i + 26.5300693004806*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 0.679918453285308*v_R14_n_i - 7.72144347466701*v_R14_n_r
        struct[0].g[135,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r + 26.5300693004806*v_R12_b_i - 4.84676915585801*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r - 7.72144347466701*v_R12_n_i - 0.679918453285308*v_R12_n_r + 15.7892267502954*v_R13_a_i + 3.16965629008966*v_R13_a_r - 53.0601386009611*v_R13_b_i + 9.69353831171602*v_R13_b_r + 15.7892267502954*v_R13_c_i + 3.16965629008967*v_R13_c_r + 15.442886949334*v_R13_n_i + 1.35983690657062*v_R13_n_r - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r + 26.5300693004806*v_R14_b_i - 4.84676915585801*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r - 7.72144347466701*v_R14_n_i - 0.679918453285308*v_R14_n_r
        struct[0].g[136,0] = 0.67991845328531*v_R12_a_i - 7.72144347466701*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 4.84676915585801*v_R12_c_i + 26.5300693004806*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 1.35983690657062*v_R13_a_i + 15.442886949334*v_R13_a_r - 3.16965629008966*v_R13_b_i + 15.7892267502954*v_R13_b_r - 9.69353831171602*v_R13_c_i - 53.0601386009611*v_R13_c_r - 3.16965629008967*v_R13_n_i + 15.7892267502954*v_R13_n_r + 0.67991845328531*v_R14_a_i - 7.72144347466701*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 4.84676915585801*v_R14_c_i + 26.5300693004806*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r
        struct[0].g[137,0] = -7.72144347466701*v_R12_a_i - 0.67991845328531*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r + 26.5300693004806*v_R12_c_i - 4.84676915585801*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r + 15.442886949334*v_R13_a_i + 1.35983690657062*v_R13_a_r + 15.7892267502954*v_R13_b_i + 3.16965629008966*v_R13_b_r - 53.0601386009611*v_R13_c_i + 9.69353831171602*v_R13_c_r + 15.7892267502954*v_R13_n_i + 3.16965629008967*v_R13_n_r - 7.72144347466701*v_R14_a_i - 0.67991845328531*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r + 26.5300693004806*v_R14_c_i - 4.84676915585801*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r
        struct[0].g[138,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 0.679918453285308*v_R12_b_i - 7.72144347466701*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 4.84676915585801*v_R12_n_i + 26.5300693004806*v_R12_n_r - 3.16965629008966*v_R13_a_i + 15.7892267502954*v_R13_a_r - 1.35983690657062*v_R13_b_i + 15.442886949334*v_R13_b_r - 3.16965629008966*v_R13_c_i + 15.7892267502954*v_R13_c_r - 9.69353831171602*v_R13_n_i - 53.0851386009611*v_R13_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 0.679918453285308*v_R14_b_i - 7.72144347466701*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 4.84676915585801*v_R14_n_i + 26.5300693004806*v_R14_n_r
        struct[0].g[139,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r - 7.72144347466701*v_R12_b_i - 0.679918453285308*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r + 26.5300693004806*v_R12_n_i - 4.84676915585801*v_R12_n_r + 15.7892267502954*v_R13_a_i + 3.16965629008966*v_R13_a_r + 15.442886949334*v_R13_b_i + 1.35983690657062*v_R13_b_r + 15.7892267502954*v_R13_c_i + 3.16965629008966*v_R13_c_r - 53.0851386009611*v_R13_n_i + 9.69353831171602*v_R13_n_r - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r - 7.72144347466701*v_R14_b_i - 0.679918453285308*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r + 26.5300693004806*v_R14_n_i - 4.84676915585801*v_R14_n_r
        struct[0].g[140,0] = i_vsc_R14_a_r + 4.84676915585801*v_R13_a_i + 26.5300693004806*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 0.67991845328531*v_R13_c_i - 7.72144347466701*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r - 9.69353831171601*v_R14_a_i - 53.0601386009611*v_R14_a_r - 3.16965629008966*v_R14_b_i + 15.7892267502954*v_R14_b_r - 1.35983690657062*v_R14_c_i + 15.442886949334*v_R14_c_r - 3.16965629008966*v_R14_n_i + 15.7892267502954*v_R14_n_r + 4.84676915585801*v_R15_a_i + 26.5300693004806*v_R15_a_r + 1.58482814504483*v_R15_b_i - 7.8946133751477*v_R15_b_r + 0.67991845328531*v_R15_c_i - 7.72144347466701*v_R15_c_r + 1.58482814504483*v_R15_n_i - 7.89461337514771*v_R15_n_r
        struct[0].g[141,0] = i_vsc_R14_a_i + 26.5300693004806*v_R13_a_i - 4.84676915585801*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r - 7.72144347466701*v_R13_c_i - 0.67991845328531*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r - 53.0601386009611*v_R14_a_i + 9.69353831171601*v_R14_a_r + 15.7892267502954*v_R14_b_i + 3.16965629008966*v_R14_b_r + 15.442886949334*v_R14_c_i + 1.35983690657062*v_R14_c_r + 15.7892267502954*v_R14_n_i + 3.16965629008966*v_R14_n_r + 26.5300693004806*v_R15_a_i - 4.84676915585801*v_R15_a_r - 7.8946133751477*v_R15_b_i - 1.58482814504483*v_R15_b_r - 7.72144347466701*v_R15_c_i - 0.67991845328531*v_R15_c_r - 7.89461337514771*v_R15_n_i - 1.58482814504483*v_R15_n_r
        struct[0].g[142,0] = i_vsc_R14_b_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 4.84676915585801*v_R13_b_i + 26.5300693004806*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 0.679918453285308*v_R13_n_i - 7.72144347466701*v_R13_n_r - 3.16965629008966*v_R14_a_i + 15.7892267502954*v_R14_a_r - 9.69353831171602*v_R14_b_i - 53.0601386009611*v_R14_b_r - 3.16965629008967*v_R14_c_i + 15.7892267502954*v_R14_c_r - 1.35983690657062*v_R14_n_i + 15.442886949334*v_R14_n_r + 1.58482814504483*v_R15_a_i - 7.89461337514771*v_R15_a_r + 4.84676915585801*v_R15_b_i + 26.5300693004806*v_R15_b_r + 1.58482814504483*v_R15_c_i - 7.89461337514771*v_R15_c_r + 0.679918453285308*v_R15_n_i - 7.72144347466701*v_R15_n_r
        struct[0].g[143,0] = i_vsc_R14_b_i - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r + 26.5300693004806*v_R13_b_i - 4.84676915585801*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r - 7.72144347466701*v_R13_n_i - 0.679918453285308*v_R13_n_r + 15.7892267502954*v_R14_a_i + 3.16965629008966*v_R14_a_r - 53.0601386009611*v_R14_b_i + 9.69353831171602*v_R14_b_r + 15.7892267502954*v_R14_c_i + 3.16965629008967*v_R14_c_r + 15.442886949334*v_R14_n_i + 1.35983690657062*v_R14_n_r - 7.89461337514771*v_R15_a_i - 1.58482814504483*v_R15_a_r + 26.5300693004806*v_R15_b_i - 4.84676915585801*v_R15_b_r - 7.89461337514771*v_R15_c_i - 1.58482814504483*v_R15_c_r - 7.72144347466701*v_R15_n_i - 0.679918453285308*v_R15_n_r
        struct[0].g[144,0] = i_vsc_R14_c_r + 0.67991845328531*v_R13_a_i - 7.72144347466701*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 4.84676915585801*v_R13_c_i + 26.5300693004806*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r - 1.35983690657062*v_R14_a_i + 15.442886949334*v_R14_a_r - 3.16965629008966*v_R14_b_i + 15.7892267502954*v_R14_b_r - 9.69353831171602*v_R14_c_i - 53.0601386009611*v_R14_c_r - 3.16965629008967*v_R14_n_i + 15.7892267502954*v_R14_n_r + 0.67991845328531*v_R15_a_i - 7.72144347466701*v_R15_a_r + 1.58482814504483*v_R15_b_i - 7.8946133751477*v_R15_b_r + 4.84676915585801*v_R15_c_i + 26.5300693004806*v_R15_c_r + 1.58482814504483*v_R15_n_i - 7.89461337514771*v_R15_n_r
        struct[0].g[145,0] = i_vsc_R14_c_i - 7.72144347466701*v_R13_a_i - 0.67991845328531*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r + 26.5300693004806*v_R13_c_i - 4.84676915585801*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r + 15.442886949334*v_R14_a_i + 1.35983690657062*v_R14_a_r + 15.7892267502954*v_R14_b_i + 3.16965629008966*v_R14_b_r - 53.0601386009611*v_R14_c_i + 9.69353831171602*v_R14_c_r + 15.7892267502954*v_R14_n_i + 3.16965629008967*v_R14_n_r - 7.72144347466701*v_R15_a_i - 0.67991845328531*v_R15_a_r - 7.8946133751477*v_R15_b_i - 1.58482814504483*v_R15_b_r + 26.5300693004806*v_R15_c_i - 4.84676915585801*v_R15_c_r - 7.89461337514771*v_R15_n_i - 1.58482814504483*v_R15_n_r
        struct[0].g[146,0] = i_vsc_R14_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 0.679918453285308*v_R13_b_i - 7.72144347466701*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 4.84676915585801*v_R13_n_i + 26.5300693004806*v_R13_n_r - 3.16965629008966*v_R14_a_i + 15.7892267502954*v_R14_a_r - 1.35983690657062*v_R14_b_i + 15.442886949334*v_R14_b_r - 3.16965629008966*v_R14_c_i + 15.7892267502954*v_R14_c_r - 9.69353831171602*v_R14_n_i - 53.0601386009611*v_R14_n_r + 1.58482814504483*v_R15_a_i - 7.89461337514771*v_R15_a_r + 0.679918453285308*v_R15_b_i - 7.72144347466701*v_R15_b_r + 1.58482814504483*v_R15_c_i - 7.89461337514771*v_R15_c_r + 4.84676915585801*v_R15_n_i + 26.5300693004806*v_R15_n_r
        struct[0].g[147,0] = i_vsc_R14_n_i - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r - 7.72144347466701*v_R13_b_i - 0.679918453285308*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r + 26.5300693004806*v_R13_n_i - 4.84676915585801*v_R13_n_r + 15.7892267502954*v_R14_a_i + 3.16965629008966*v_R14_a_r + 15.442886949334*v_R14_b_i + 1.35983690657062*v_R14_b_r + 15.7892267502954*v_R14_c_i + 3.16965629008966*v_R14_c_r - 53.0601386009611*v_R14_n_i + 9.69353831171602*v_R14_n_r - 7.89461337514771*v_R15_a_i - 1.58482814504483*v_R15_a_r - 7.72144347466701*v_R15_b_i - 0.679918453285308*v_R15_b_r - 7.89461337514771*v_R15_c_i - 1.58482814504483*v_R15_c_r + 26.5300693004806*v_R15_n_i - 4.84676915585801*v_R15_n_r
        struct[0].g[148,0] = 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 4.84676915585801*v_R14_b_i + 26.5300693004806*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 0.679918453285308*v_R14_n_i - 7.72144347466701*v_R14_n_r - 1.58482814504483*v_R15_a_i + 7.89461337514771*v_R15_a_r - 4.84676915585801*v_R15_b_i - 26.5300693004806*v_R15_b_r - 1.58482814504483*v_R15_c_i + 7.89461337514771*v_R15_c_r - 0.679918453285308*v_R15_n_i + 7.72144347466701*v_R15_n_r
        struct[0].g[149,0] = -7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r + 26.5300693004806*v_R14_b_i - 4.84676915585801*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r - 7.72144347466701*v_R14_n_i - 0.679918453285308*v_R14_n_r + 7.89461337514771*v_R15_a_i + 1.58482814504483*v_R15_a_r - 26.5300693004806*v_R15_b_i + 4.84676915585801*v_R15_b_r + 7.89461337514771*v_R15_c_i + 1.58482814504483*v_R15_c_r + 7.72144347466701*v_R15_n_i + 0.679918453285308*v_R15_n_r
        struct[0].g[150,0] = 0.67991845328531*v_R14_a_i - 7.72144347466701*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 4.84676915585801*v_R14_c_i + 26.5300693004806*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r - 0.67991845328531*v_R15_a_i + 7.72144347466701*v_R15_a_r - 1.58482814504483*v_R15_b_i + 7.8946133751477*v_R15_b_r - 4.84676915585801*v_R15_c_i - 26.5300693004806*v_R15_c_r - 1.58482814504483*v_R15_n_i + 7.89461337514771*v_R15_n_r
        struct[0].g[151,0] = -7.72144347466701*v_R14_a_i - 0.67991845328531*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r + 26.5300693004806*v_R14_c_i - 4.84676915585801*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r + 7.72144347466701*v_R15_a_i + 0.67991845328531*v_R15_a_r + 7.8946133751477*v_R15_b_i + 1.58482814504483*v_R15_b_r - 26.5300693004806*v_R15_c_i + 4.84676915585801*v_R15_c_r + 7.89461337514771*v_R15_n_i + 1.58482814504483*v_R15_n_r
        struct[0].g[152,0] = -1.84896616921897*v_R16_a_i + 9.21038227100566*v_R16_a_r - 5.65456401516768*v_R16_b_i - 30.9517475172273*v_R16_b_r - 1.84896616921897*v_R16_c_i + 9.21038227100566*v_R16_c_r - 0.793238195499528*v_R16_n_i + 9.00835072044485*v_R16_n_r + 1.84896616921897*v_R6_a_i - 9.21038227100566*v_R6_a_r + 5.65456401516768*v_R6_b_i + 30.9517475172273*v_R6_b_r + 1.84896616921897*v_R6_c_i - 9.21038227100566*v_R6_c_r + 0.793238195499528*v_R6_n_i - 9.00835072044485*v_R6_n_r
        struct[0].g[153,0] = 9.21038227100566*v_R16_a_i + 1.84896616921897*v_R16_a_r - 30.9517475172273*v_R16_b_i + 5.65456401516768*v_R16_b_r + 9.21038227100566*v_R16_c_i + 1.84896616921897*v_R16_c_r + 9.00835072044485*v_R16_n_i + 0.793238195499528*v_R16_n_r - 9.21038227100566*v_R6_a_i - 1.84896616921897*v_R6_a_r + 30.9517475172273*v_R6_b_i - 5.65456401516768*v_R6_b_r - 9.21038227100566*v_R6_c_i - 1.84896616921897*v_R6_c_r - 9.00835072044485*v_R6_n_i - 0.793238195499528*v_R6_n_r
        struct[0].g[154,0] = -0.793238195499527*v_R16_a_i + 9.00835072044484*v_R16_a_r - 1.84896616921897*v_R16_b_i + 9.21038227100566*v_R16_b_r - 5.65456401516768*v_R16_c_i - 30.9517475172273*v_R16_c_r - 1.84896616921897*v_R16_n_i + 9.21038227100566*v_R16_n_r + 0.793238195499527*v_R6_a_i - 9.00835072044484*v_R6_a_r + 1.84896616921897*v_R6_b_i - 9.21038227100566*v_R6_b_r + 5.65456401516768*v_R6_c_i + 30.9517475172273*v_R6_c_r + 1.84896616921897*v_R6_n_i - 9.21038227100566*v_R6_n_r
        struct[0].g[155,0] = 9.00835072044484*v_R16_a_i + 0.793238195499527*v_R16_a_r + 9.21038227100566*v_R16_b_i + 1.84896616921897*v_R16_b_r - 30.9517475172273*v_R16_c_i + 5.65456401516768*v_R16_c_r + 9.21038227100566*v_R16_n_i + 1.84896616921897*v_R16_n_r - 9.00835072044484*v_R6_a_i - 0.793238195499527*v_R6_a_r - 9.21038227100566*v_R6_b_i - 1.84896616921897*v_R6_b_r + 30.9517475172273*v_R6_c_i - 5.65456401516768*v_R6_c_r - 9.21038227100566*v_R6_n_i - 1.84896616921897*v_R6_n_r
        struct[0].g[156,0] = -1.84896616921897*v_R17_a_i + 9.21038227100566*v_R17_a_r - 5.65456401516768*v_R17_b_i - 30.9517475172273*v_R17_b_r - 1.84896616921897*v_R17_c_i + 9.21038227100566*v_R17_c_r - 0.793238195499528*v_R17_n_i + 9.00835072044485*v_R17_n_r + 1.84896616921897*v_R9_a_i - 9.21038227100566*v_R9_a_r + 5.65456401516768*v_R9_b_i + 30.9517475172273*v_R9_b_r + 1.84896616921897*v_R9_c_i - 9.21038227100566*v_R9_c_r + 0.793238195499528*v_R9_n_i - 9.00835072044485*v_R9_n_r
        struct[0].g[157,0] = 9.21038227100566*v_R17_a_i + 1.84896616921897*v_R17_a_r - 30.9517475172273*v_R17_b_i + 5.65456401516768*v_R17_b_r + 9.21038227100566*v_R17_c_i + 1.84896616921897*v_R17_c_r + 9.00835072044485*v_R17_n_i + 0.793238195499528*v_R17_n_r - 9.21038227100566*v_R9_a_i - 1.84896616921897*v_R9_a_r + 30.9517475172273*v_R9_b_i - 5.65456401516768*v_R9_b_r - 9.21038227100566*v_R9_c_i - 1.84896616921897*v_R9_c_r - 9.00835072044485*v_R9_n_i - 0.793238195499528*v_R9_n_r
        struct[0].g[158,0] = -0.793238195499527*v_R17_a_i + 9.00835072044484*v_R17_a_r - 1.84896616921897*v_R17_b_i + 9.21038227100566*v_R17_b_r - 5.65456401516768*v_R17_c_i - 30.9517475172273*v_R17_c_r - 1.84896616921897*v_R17_n_i + 9.21038227100566*v_R17_n_r + 0.793238195499527*v_R9_a_i - 9.00835072044484*v_R9_a_r + 1.84896616921897*v_R9_b_i - 9.21038227100566*v_R9_b_r + 5.65456401516768*v_R9_c_i + 30.9517475172273*v_R9_c_r + 1.84896616921897*v_R9_n_i - 9.21038227100566*v_R9_n_r
        struct[0].g[159,0] = 9.00835072044484*v_R17_a_i + 0.793238195499527*v_R17_a_r + 9.21038227100566*v_R17_b_i + 1.84896616921897*v_R17_b_r - 30.9517475172273*v_R17_c_i + 5.65456401516768*v_R17_c_r + 9.21038227100566*v_R17_n_i + 1.84896616921897*v_R17_n_r - 9.00835072044484*v_R9_a_i - 0.793238195499527*v_R9_a_r - 9.21038227100566*v_R9_b_i - 1.84896616921897*v_R9_b_r + 30.9517475172273*v_R9_c_i - 5.65456401516768*v_R9_c_r - 9.21038227100566*v_R9_n_i - 1.84896616921897*v_R9_n_r
        struct[0].g[160,0] = 1.84896616921897*v_R10_a_i - 9.21038227100566*v_R10_a_r + 5.65456401516768*v_R10_b_i + 30.9517475172273*v_R10_b_r + 1.84896616921897*v_R10_c_i - 9.21038227100566*v_R10_c_r + 0.793238195499528*v_R10_n_i - 9.00835072044485*v_R10_n_r - 1.84896616921897*v_R18_a_i + 9.21038227100566*v_R18_a_r - 5.65456401516768*v_R18_b_i - 30.9517475172273*v_R18_b_r - 1.84896616921897*v_R18_c_i + 9.21038227100566*v_R18_c_r - 0.793238195499528*v_R18_n_i + 9.00835072044485*v_R18_n_r
        struct[0].g[161,0] = -9.21038227100566*v_R10_a_i - 1.84896616921897*v_R10_a_r + 30.9517475172273*v_R10_b_i - 5.65456401516768*v_R10_b_r - 9.21038227100566*v_R10_c_i - 1.84896616921897*v_R10_c_r - 9.00835072044485*v_R10_n_i - 0.793238195499528*v_R10_n_r + 9.21038227100566*v_R18_a_i + 1.84896616921897*v_R18_a_r - 30.9517475172273*v_R18_b_i + 5.65456401516768*v_R18_b_r + 9.21038227100566*v_R18_c_i + 1.84896616921897*v_R18_c_r + 9.00835072044485*v_R18_n_i + 0.793238195499528*v_R18_n_r
        struct[0].g[162,0] = 0.793238195499527*v_R10_a_i - 9.00835072044484*v_R10_a_r + 1.84896616921897*v_R10_b_i - 9.21038227100566*v_R10_b_r + 5.65456401516768*v_R10_c_i + 30.9517475172273*v_R10_c_r + 1.84896616921897*v_R10_n_i - 9.21038227100566*v_R10_n_r - 0.793238195499527*v_R18_a_i + 9.00835072044484*v_R18_a_r - 1.84896616921897*v_R18_b_i + 9.21038227100566*v_R18_b_r - 5.65456401516768*v_R18_c_i - 30.9517475172273*v_R18_c_r - 1.84896616921897*v_R18_n_i + 9.21038227100566*v_R18_n_r
        struct[0].g[163,0] = -9.00835072044484*v_R10_a_i - 0.793238195499527*v_R10_a_r - 9.21038227100566*v_R10_b_i - 1.84896616921897*v_R10_b_r + 30.9517475172273*v_R10_c_i - 5.65456401516768*v_R10_c_r - 9.21038227100566*v_R10_n_i - 1.84896616921897*v_R10_n_r + 9.00835072044484*v_R18_a_i + 0.793238195499527*v_R18_a_r + 9.21038227100566*v_R18_b_i + 1.84896616921897*v_R18_b_r - 30.9517475172273*v_R18_c_i + 5.65456401516768*v_R18_c_r + 9.21038227100566*v_R18_n_i + 1.84896616921897*v_R18_n_r
        struct[0].g[164,0] = -1067.7048070413*v_D1_n_r + 67.7048070412999*v_D3_n_r
        struct[0].g[165,0] = -1067.7048070413*v_D1_n_i + 67.7048070412999*v_D3_n_i
        struct[0].g[166,0] = 157.977883096366*v_D11_a_r + 67.7048070412999*v_D1_a_r - 361.092304220266*v_D3_a_r + 135.4096140826*v_D4_a_r
        struct[0].g[167,0] = 157.977883096366*v_D11_a_i + 67.7048070412999*v_D1_a_i - 361.092304220266*v_D3_a_i + 135.4096140826*v_D4_a_i
        struct[0].g[168,0] = 157.977883096366*v_D11_b_r + 67.7048070412999*v_D1_b_r - 361.092304220266*v_D3_b_r + 135.4096140826*v_D4_b_r
        struct[0].g[169,0] = 157.977883096366*v_D11_b_i + 67.7048070412999*v_D1_b_i - 361.092304220266*v_D3_b_i + 135.4096140826*v_D4_b_i
        struct[0].g[170,0] = 157.977883096366*v_D11_c_r + 67.7048070412999*v_D1_c_r - 361.092304220266*v_D3_c_r + 135.4096140826*v_D4_c_r
        struct[0].g[171,0] = 157.977883096366*v_D11_c_i + 67.7048070412999*v_D1_c_i - 361.092304220266*v_D3_c_i + 135.4096140826*v_D4_c_i
        struct[0].g[172,0] = 157.977883096366*v_D11_n_r + 67.7048070412999*v_D1_n_r - 361.092304220266*v_D3_n_r + 135.4096140826*v_D4_n_r
        struct[0].g[173,0] = 157.977883096366*v_D11_n_i + 67.7048070412999*v_D1_n_i - 361.092304220266*v_D3_n_i + 135.4096140826*v_D4_n_i
        struct[0].g[174,0] = 45.1365380275333*v_D14_a_r + 135.4096140826*v_D3_a_r - 248.250959151433*v_D4_a_r + 67.7048070412999*v_D6_a_r
        struct[0].g[175,0] = 45.1365380275333*v_D14_a_i + 135.4096140826*v_D3_a_i - 248.250959151433*v_D4_a_i + 67.7048070412999*v_D6_a_i
        struct[0].g[176,0] = 45.1365380275333*v_D14_b_r + 135.4096140826*v_D3_b_r - 248.250959151433*v_D4_b_r + 67.7048070412999*v_D6_b_r
        struct[0].g[177,0] = 45.1365380275333*v_D14_b_i + 135.4096140826*v_D3_b_i - 248.250959151433*v_D4_b_i + 67.7048070412999*v_D6_b_i
        struct[0].g[178,0] = 45.1365380275333*v_D14_c_r + 135.4096140826*v_D3_c_r - 248.250959151433*v_D4_c_r + 67.7048070412999*v_D6_c_r
        struct[0].g[179,0] = 45.1365380275333*v_D14_c_i + 135.4096140826*v_D3_c_i - 248.250959151433*v_D4_c_i + 67.7048070412999*v_D6_c_i
        struct[0].g[180,0] = 45.1365380275333*v_D14_n_r + 135.4096140826*v_D3_n_r - 248.250959151433*v_D4_n_r + 67.7048070412999*v_D6_n_r
        struct[0].g[181,0] = 45.1365380275333*v_D14_n_i + 135.4096140826*v_D3_n_i - 248.250959151433*v_D4_n_i + 67.7048070412999*v_D6_n_i
        struct[0].g[182,0] = 157.977883096366*v_D16_a_r + 67.7048070412999*v_D4_a_r - 270.8192281652*v_D6_a_r + 45.1365380275333*v_D9_a_r
        struct[0].g[183,0] = 157.977883096366*v_D16_a_i + 67.7048070412999*v_D4_a_i - 270.8192281652*v_D6_a_i + 45.1365380275333*v_D9_a_i
        struct[0].g[184,0] = 157.977883096366*v_D16_b_r + 67.7048070412999*v_D4_b_r - 270.8192281652*v_D6_b_r + 45.1365380275333*v_D9_b_r
        struct[0].g[185,0] = 157.977883096366*v_D16_b_i + 67.7048070412999*v_D4_b_i - 270.8192281652*v_D6_b_i + 45.1365380275333*v_D9_b_i
        struct[0].g[186,0] = 157.977883096366*v_D16_c_r + 67.7048070412999*v_D4_c_r - 270.8192281652*v_D6_c_r + 45.1365380275333*v_D9_c_r
        struct[0].g[187,0] = 157.977883096366*v_D16_c_i + 67.7048070412999*v_D4_c_i - 270.8192281652*v_D6_c_i + 45.1365380275333*v_D9_c_i
        struct[0].g[188,0] = 157.977883096366*v_D16_n_r + 67.7048070412999*v_D4_n_r - 270.8192281652*v_D6_n_r + 45.1365380275333*v_D9_n_r
        struct[0].g[189,0] = 157.977883096366*v_D16_n_i + 67.7048070412999*v_D4_n_i - 270.8192281652*v_D6_n_i + 45.1365380275333*v_D9_n_i
        struct[0].g[190,0] = 157.977883096366*v_D10_a_r + 157.977883096366*v_D17_a_r + 45.1365380275333*v_D6_a_r - 361.092304220266*v_D9_a_r
        struct[0].g[191,0] = 157.977883096366*v_D10_a_i + 157.977883096366*v_D17_a_i + 45.1365380275333*v_D6_a_i - 361.092304220266*v_D9_a_i
        struct[0].g[192,0] = 157.977883096366*v_D10_b_r + 157.977883096366*v_D17_b_r + 45.1365380275333*v_D6_b_r - 361.092304220266*v_D9_b_r
        struct[0].g[193,0] = 157.977883096366*v_D10_b_i + 157.977883096366*v_D17_b_i + 45.1365380275333*v_D6_b_i - 361.092304220266*v_D9_b_i
        struct[0].g[194,0] = 157.977883096366*v_D10_c_r + 157.977883096366*v_D17_c_r + 45.1365380275333*v_D6_c_r - 361.092304220266*v_D9_c_r
        struct[0].g[195,0] = 157.977883096366*v_D10_c_i + 157.977883096366*v_D17_c_i + 45.1365380275333*v_D6_c_i - 361.092304220266*v_D9_c_i
        struct[0].g[196,0] = 157.977883096366*v_D10_n_r + 157.977883096366*v_D17_n_r + 45.1365380275333*v_D6_n_r - 361.092304220266*v_D9_n_r
        struct[0].g[197,0] = 157.977883096366*v_D10_n_i + 157.977883096366*v_D17_n_i + 45.1365380275333*v_D6_n_i - 361.092304220266*v_D9_n_i
        struct[0].g[198,0] = i_vsc_D10_a_r - 315.955766192733*v_D10_a_r + 157.977883096366*v_D18_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[199,0] = -315.955766192733*v_D10_a_i + 157.977883096366*v_D18_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[200,0] = -315.955766192733*v_D10_b_r + 157.977883096366*v_D18_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[201,0] = -315.955766192733*v_D10_b_i + 157.977883096366*v_D18_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[202,0] = -315.955766192733*v_D10_c_r + 157.977883096366*v_D18_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[203,0] = -315.955766192733*v_D10_c_i + 157.977883096366*v_D18_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[204,0] = i_vsc_D10_n_r - 315.955766192733*v_D10_n_r + 157.977883096366*v_D18_n_r + 157.977883096366*v_D9_n_r
        struct[0].g[205,0] = -315.955766192733*v_D10_n_i + 157.977883096366*v_D18_n_i + 157.977883096366*v_D9_n_i
        struct[0].g[206,0] = -157.977883096366*v_D11_b_r + 157.977883096366*v_D3_b_r
        struct[0].g[207,0] = -157.977883096366*v_D11_b_i + 157.977883096366*v_D3_b_i
        struct[0].g[208,0] = -157.977883096366*v_D11_c_r + 157.977883096366*v_D3_c_r
        struct[0].g[209,0] = -157.977883096366*v_D11_c_i + 157.977883096366*v_D3_c_i
        struct[0].g[210,0] = -157.977883096366*v_D16_b_r + 157.977883096366*v_D6_b_r
        struct[0].g[211,0] = -157.977883096366*v_D16_b_i + 157.977883096366*v_D6_b_i
        struct[0].g[212,0] = -157.977883096366*v_D16_c_r + 157.977883096366*v_D6_c_r
        struct[0].g[213,0] = -157.977883096366*v_D16_c_i + 157.977883096366*v_D6_c_i
        struct[0].g[214,0] = -157.977883096366*v_D17_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[215,0] = -157.977883096366*v_D17_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[216,0] = -157.977883096366*v_D17_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[217,0] = -157.977883096366*v_D17_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[218,0] = 157.977883096366*v_D10_b_r - 157.977883096366*v_D18_b_r
        struct[0].g[219,0] = 157.977883096366*v_D10_b_i - 157.977883096366*v_D18_b_i
        struct[0].g[220,0] = 157.977883096366*v_D10_c_r - 157.977883096366*v_D18_c_r
        struct[0].g[221,0] = 157.977883096366*v_D10_c_i - 157.977883096366*v_D18_c_i
        struct[0].g[222,0] = i_vsc_D14_a_r - 180.546152110133*v_D14_a_r + 135.4096140826*v_D15_a_r + 45.1365380275333*v_D4_a_r
        struct[0].g[223,0] = -180.546152110133*v_D14_a_i + 135.4096140826*v_D15_a_i + 45.1365380275333*v_D4_a_i
        struct[0].g[224,0] = -180.546152110133*v_D14_b_r + 135.4096140826*v_D15_b_r + 45.1365380275333*v_D4_b_r
        struct[0].g[225,0] = -180.546152110133*v_D14_b_i + 135.4096140826*v_D15_b_i + 45.1365380275333*v_D4_b_i
        struct[0].g[226,0] = -180.546152110133*v_D14_c_r + 135.4096140826*v_D15_c_r + 45.1365380275333*v_D4_c_r
        struct[0].g[227,0] = -180.546152110133*v_D14_c_i + 135.4096140826*v_D15_c_i + 45.1365380275333*v_D4_c_i
        struct[0].g[228,0] = i_vsc_D14_n_r - 180.546152110133*v_D14_n_r + 135.4096140826*v_D15_n_r + 45.1365380275333*v_D4_n_r
        struct[0].g[229,0] = -180.546152110133*v_D14_n_i + 135.4096140826*v_D15_n_i + 45.1365380275333*v_D4_n_i
        struct[0].g[230,0] = 135.4096140826*v_D14_b_r - 135.4096140826*v_D15_b_r
        struct[0].g[231,0] = 135.4096140826*v_D14_b_i - 135.4096140826*v_D15_b_i
        struct[0].g[232,0] = 135.4096140826*v_D14_c_r - 135.4096140826*v_D15_c_r
        struct[0].g[233,0] = 135.4096140826*v_D14_c_i - 135.4096140826*v_D15_c_i
        struct[0].g[234,0] = -i_t_R0_R1_a_r + 0.0196078431372549*v_R0_a_i + 0.00490196078431373*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_a_i - 0.212261128378539*v_R1_a_r + 0.849044513514155*v_R1_b_i + 0.212261128378539*v_R1_b_r
        struct[0].g[235,0] = -i_t_R0_R1_a_i + 0.00490196078431373*v_R0_a_i - 0.0196078431372549*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_a_i + 0.849044513514155*v_R1_a_r + 0.212261128378539*v_R1_b_i - 0.849044513514155*v_R1_b_r
        struct[0].g[236,0] = -i_t_R0_R1_b_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r + 0.0196078431372549*v_R0_b_i + 0.00490196078431373*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_b_i - 0.212261128378539*v_R1_b_r + 0.849044513514155*v_R1_c_i + 0.212261128378539*v_R1_c_r
        struct[0].g[237,0] = -i_t_R0_R1_b_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r + 0.00490196078431373*v_R0_b_i - 0.0196078431372549*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_b_i + 0.849044513514155*v_R1_b_r + 0.212261128378539*v_R1_c_i - 0.849044513514155*v_R1_c_r
        struct[0].g[238,0] = -i_t_R0_R1_c_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r + 0.0196078431372549*v_R0_c_i + 0.00490196078431373*v_R0_c_r + 0.849044513514155*v_R1_a_i + 0.212261128378539*v_R1_a_r - 0.849044513514155*v_R1_c_i - 0.212261128378539*v_R1_c_r
        struct[0].g[239,0] = -i_t_R0_R1_c_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r + 0.00490196078431373*v_R0_c_i - 0.0196078431372549*v_R0_c_r + 0.212261128378539*v_R1_a_i - 0.849044513514155*v_R1_a_r - 0.212261128378539*v_R1_c_i + 0.849044513514155*v_R1_c_r
        struct[0].g[240,0] = -i_l_R1_R2_a_r + 54.0657727682604*v_R1_a_i + 105.57176931318*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r - 23.284964480954*v_R1_c_i - 24.9575997948692*v_R1_c_r - 10.2713736253513*v_R1_n_i - 39.6392229058202*v_R1_n_r - 54.0657727682604*v_R2_a_i - 105.57176931318*v_R2_a_r + 10.2713736253513*v_R2_b_i + 39.6392229058202*v_R2_b_r + 23.284964480954*v_R2_c_i + 24.9575997948692*v_R2_c_r + 10.2713736253513*v_R2_n_i + 39.6392229058202*v_R2_n_r
        struct[0].g[241,0] = -i_l_R1_R2_a_i + 105.57176931318*v_R1_a_i - 54.0657727682604*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r - 24.9575997948692*v_R1_c_i + 23.284964480954*v_R1_c_r - 39.6392229058202*v_R1_n_i + 10.2713736253513*v_R1_n_r - 105.57176931318*v_R2_a_i + 54.0657727682604*v_R2_a_r + 39.6392229058202*v_R2_b_i - 10.2713736253513*v_R2_b_r + 24.9575997948692*v_R2_c_i - 23.284964480954*v_R2_c_r + 39.6392229058202*v_R2_n_i - 10.2713736253513*v_R2_n_r
        struct[0].g[242,0] = -i_l_R1_R2_b_r - 10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r + 54.0657727682604*v_R1_b_i + 105.57176931318*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058201*v_R1_c_r - 23.284964480954*v_R1_n_i - 24.9575997948692*v_R1_n_r + 10.2713736253513*v_R2_a_i + 39.6392229058202*v_R2_a_r - 54.0657727682604*v_R2_b_i - 105.57176931318*v_R2_b_r + 10.2713736253513*v_R2_c_i + 39.6392229058201*v_R2_c_r + 23.284964480954*v_R2_n_i + 24.9575997948692*v_R2_n_r
        struct[0].g[243,0] = -i_l_R1_R2_b_i - 39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r + 105.57176931318*v_R1_b_i - 54.0657727682604*v_R1_b_r - 39.6392229058201*v_R1_c_i + 10.2713736253513*v_R1_c_r - 24.9575997948692*v_R1_n_i + 23.284964480954*v_R1_n_r + 39.6392229058202*v_R2_a_i - 10.2713736253513*v_R2_a_r - 105.57176931318*v_R2_b_i + 54.0657727682604*v_R2_b_r + 39.6392229058201*v_R2_c_i - 10.2713736253513*v_R2_c_r + 24.9575997948692*v_R2_n_i - 23.284964480954*v_R2_n_r
        struct[0].g[244,0] = -i_l_R1_R2_c_r - 23.284964480954*v_R1_a_i - 24.9575997948692*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r + 54.0657727682604*v_R1_c_i + 105.57176931318*v_R1_c_r - 10.2713736253514*v_R1_n_i - 39.6392229058201*v_R1_n_r + 23.284964480954*v_R2_a_i + 24.9575997948692*v_R2_a_r + 10.2713736253513*v_R2_b_i + 39.6392229058202*v_R2_b_r - 54.0657727682604*v_R2_c_i - 105.57176931318*v_R2_c_r + 10.2713736253514*v_R2_n_i + 39.6392229058201*v_R2_n_r
        struct[0].g[245,0] = -i_l_R1_R2_c_i - 24.9575997948692*v_R1_a_i + 23.284964480954*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r + 105.57176931318*v_R1_c_i - 54.0657727682604*v_R1_c_r - 39.6392229058201*v_R1_n_i + 10.2713736253514*v_R1_n_r + 24.9575997948692*v_R2_a_i - 23.284964480954*v_R2_a_r + 39.6392229058202*v_R2_b_i - 10.2713736253513*v_R2_b_r - 105.57176931318*v_R2_c_i + 54.0657727682604*v_R2_c_r + 39.6392229058201*v_R2_n_i - 10.2713736253514*v_R2_n_r
        struct[0].g[246,0] = i_l_R1_R2_a_r + i_l_R1_R2_b_r + i_l_R1_R2_c_r - i_l_R1_R2_n_r
        struct[0].g[247,0] = i_l_R1_R2_a_i + i_l_R1_R2_b_i + i_l_R1_R2_c_i - i_l_R1_R2_n_i
        struct[0].g[248,0] = -i_l_D1_D3_a_r + 67.7048070412999*v_D1_a_r - 67.7048070412999*v_D3_a_r
        struct[0].g[249,0] = -i_l_D1_D3_a_i + 67.7048070412999*v_D1_a_i - 67.7048070412999*v_D3_a_i
        struct[0].g[250,0] = -i_l_D1_D3_b_r + 67.7048070412999*v_D1_b_r - 67.7048070412999*v_D3_b_r
        struct[0].g[251,0] = -i_l_D1_D3_b_i + 67.7048070412999*v_D1_b_i - 67.7048070412999*v_D3_b_i
        struct[0].g[252,0] = -i_l_D1_D3_c_r + 67.7048070412999*v_D1_c_r - 67.7048070412999*v_D3_c_r
        struct[0].g[253,0] = -i_l_D1_D3_c_i + 67.7048070412999*v_D1_c_i - 67.7048070412999*v_D3_c_i
        struct[0].g[254,0] = i_l_D1_D3_a_r + i_l_D1_D3_b_r + i_l_D1_D3_c_r - i_l_D1_D3_n_r
        struct[0].g[255,0] = i_l_D1_D3_a_i + i_l_D1_D3_b_i + i_l_D1_D3_c_i - i_l_D1_D3_n_i
        struct[0].g[256,0] = -i_l_D3_D4_a_r + 135.4096140826*v_D3_a_r - 135.4096140826*v_D4_a_r
        struct[0].g[257,0] = -i_l_D3_D4_a_i + 135.4096140826*v_D3_a_i - 135.4096140826*v_D4_a_i
        struct[0].g[258,0] = -i_l_D3_D4_b_r + 135.4096140826*v_D3_b_r - 135.4096140826*v_D4_b_r
        struct[0].g[259,0] = -i_l_D3_D4_b_i + 135.4096140826*v_D3_b_i - 135.4096140826*v_D4_b_i
        struct[0].g[260,0] = -i_l_D3_D4_c_r + 135.4096140826*v_D3_c_r - 135.4096140826*v_D4_c_r
        struct[0].g[261,0] = -i_l_D3_D4_c_i + 135.4096140826*v_D3_c_i - 135.4096140826*v_D4_c_i
        struct[0].g[262,0] = i_l_D3_D4_a_r + i_l_D3_D4_b_r + i_l_D3_D4_c_r - i_l_D3_D4_n_r
        struct[0].g[263,0] = i_l_D3_D4_a_i + i_l_D3_D4_b_i + i_l_D3_D4_c_i - i_l_D3_D4_n_i
        struct[0].g[264,0] = -i_l_D4_D6_a_r + 67.7048070412999*v_D4_a_r - 67.7048070412999*v_D6_a_r
        struct[0].g[265,0] = -i_l_D4_D6_a_i + 67.7048070412999*v_D4_a_i - 67.7048070412999*v_D6_a_i
        struct[0].g[266,0] = -i_l_D4_D6_b_r + 67.7048070412999*v_D4_b_r - 67.7048070412999*v_D6_b_r
        struct[0].g[267,0] = -i_l_D4_D6_b_i + 67.7048070412999*v_D4_b_i - 67.7048070412999*v_D6_b_i
        struct[0].g[268,0] = -i_l_D4_D6_c_r + 67.7048070412999*v_D4_c_r - 67.7048070412999*v_D6_c_r
        struct[0].g[269,0] = -i_l_D4_D6_c_i + 67.7048070412999*v_D4_c_i - 67.7048070412999*v_D6_c_i
        struct[0].g[270,0] = i_l_D4_D6_a_r + i_l_D4_D6_b_r + i_l_D4_D6_c_r - i_l_D4_D6_n_r
        struct[0].g[271,0] = i_l_D4_D6_a_i + i_l_D4_D6_b_i + i_l_D4_D6_c_i - i_l_D4_D6_n_i
        struct[0].g[272,0] = -i_l_D6_D9_a_r + 45.1365380275333*v_D6_a_r - 45.1365380275333*v_D9_a_r
        struct[0].g[273,0] = -i_l_D6_D9_a_i + 45.1365380275333*v_D6_a_i - 45.1365380275333*v_D9_a_i
        struct[0].g[274,0] = -i_l_D6_D9_b_r + 45.1365380275333*v_D6_b_r - 45.1365380275333*v_D9_b_r
        struct[0].g[275,0] = -i_l_D6_D9_b_i + 45.1365380275333*v_D6_b_i - 45.1365380275333*v_D9_b_i
        struct[0].g[276,0] = -i_l_D6_D9_c_r + 45.1365380275333*v_D6_c_r - 45.1365380275333*v_D9_c_r
        struct[0].g[277,0] = -i_l_D6_D9_c_i + 45.1365380275333*v_D6_c_i - 45.1365380275333*v_D9_c_i
        struct[0].g[278,0] = i_l_D6_D9_a_r + i_l_D6_D9_b_r + i_l_D6_D9_c_r - i_l_D6_D9_n_r
        struct[0].g[279,0] = i_l_D6_D9_a_i + i_l_D6_D9_b_i + i_l_D6_D9_c_i - i_l_D6_D9_n_i
        struct[0].g[280,0] = -i_l_D9_D10_a_r - 157.977883096366*v_D10_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[281,0] = -i_l_D9_D10_a_i - 157.977883096366*v_D10_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[282,0] = -i_l_D9_D10_b_r - 157.977883096366*v_D10_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[283,0] = -i_l_D9_D10_b_i - 157.977883096366*v_D10_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[284,0] = -i_l_D9_D10_c_r - 157.977883096366*v_D10_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[285,0] = -i_l_D9_D10_c_i - 157.977883096366*v_D10_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[286,0] = i_l_D9_D10_a_r + i_l_D9_D10_b_r + i_l_D9_D10_c_r - i_l_D9_D10_n_r
        struct[0].g[287,0] = i_l_D9_D10_a_i + i_l_D9_D10_b_i + i_l_D9_D10_c_i - i_l_D9_D10_n_i
        struct[0].g[288,0] = -i_l_D3_D11_a_r - 157.977883096366*v_D11_a_r + 157.977883096366*v_D3_a_r
        struct[0].g[289,0] = -i_l_D3_D11_a_i - 157.977883096366*v_D11_a_i + 157.977883096366*v_D3_a_i
        struct[0].g[290,0] = -i_l_D3_D11_b_r - 157.977883096366*v_D11_b_r + 157.977883096366*v_D3_b_r
        struct[0].g[291,0] = -i_l_D3_D11_b_i - 157.977883096366*v_D11_b_i + 157.977883096366*v_D3_b_i
        struct[0].g[292,0] = -i_l_D3_D11_c_r - 157.977883096366*v_D11_c_r + 157.977883096366*v_D3_c_r
        struct[0].g[293,0] = -i_l_D3_D11_c_i - 157.977883096366*v_D11_c_i + 157.977883096366*v_D3_c_i
        struct[0].g[294,0] = i_l_D3_D11_a_r + i_l_D3_D11_b_r + i_l_D3_D11_c_r - i_l_D3_D11_n_r
        struct[0].g[295,0] = i_l_D3_D11_a_i + i_l_D3_D11_b_i + i_l_D3_D11_c_i - i_l_D3_D11_n_i
        struct[0].g[296,0] = -i_l_D6_D16_a_r - 157.977883096366*v_D16_a_r + 157.977883096366*v_D6_a_r
        struct[0].g[297,0] = -i_l_D6_D16_a_i - 157.977883096366*v_D16_a_i + 157.977883096366*v_D6_a_i
        struct[0].g[298,0] = -i_l_D6_D16_b_r - 157.977883096366*v_D16_b_r + 157.977883096366*v_D6_b_r
        struct[0].g[299,0] = -i_l_D6_D16_b_i - 157.977883096366*v_D16_b_i + 157.977883096366*v_D6_b_i
        struct[0].g[300,0] = -i_l_D6_D16_c_r - 157.977883096366*v_D16_c_r + 157.977883096366*v_D6_c_r
        struct[0].g[301,0] = -i_l_D6_D16_c_i - 157.977883096366*v_D16_c_i + 157.977883096366*v_D6_c_i
        struct[0].g[302,0] = i_l_D6_D16_a_r + i_l_D6_D16_b_r + i_l_D6_D16_c_r - i_l_D6_D16_n_r
        struct[0].g[303,0] = i_l_D6_D16_a_i + i_l_D6_D16_b_i + i_l_D6_D16_c_i - i_l_D6_D16_n_i
        struct[0].g[304,0] = -i_l_D9_D17_a_r - 157.977883096366*v_D17_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[305,0] = -i_l_D9_D17_a_i - 157.977883096366*v_D17_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[306,0] = -i_l_D9_D17_b_r - 157.977883096366*v_D17_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[307,0] = -i_l_D9_D17_b_i - 157.977883096366*v_D17_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[308,0] = -i_l_D9_D17_c_r - 157.977883096366*v_D17_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[309,0] = -i_l_D9_D17_c_i - 157.977883096366*v_D17_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[310,0] = i_l_D9_D17_a_r + i_l_D9_D17_b_r + i_l_D9_D17_c_r - i_l_D9_D17_n_r
        struct[0].g[311,0] = i_l_D9_D17_a_i + i_l_D9_D17_b_i + i_l_D9_D17_c_i - i_l_D9_D17_n_i
        struct[0].g[312,0] = -i_l_D10_D18_a_r + 157.977883096366*v_D10_a_r - 157.977883096366*v_D18_a_r
        struct[0].g[313,0] = -i_l_D10_D18_a_i + 157.977883096366*v_D10_a_i - 157.977883096366*v_D18_a_i
        struct[0].g[314,0] = -i_l_D10_D18_b_r + 157.977883096366*v_D10_b_r - 157.977883096366*v_D18_b_r
        struct[0].g[315,0] = -i_l_D10_D18_b_i + 157.977883096366*v_D10_b_i - 157.977883096366*v_D18_b_i
        struct[0].g[316,0] = -i_l_D10_D18_c_r + 157.977883096366*v_D10_c_r - 157.977883096366*v_D18_c_r
        struct[0].g[317,0] = -i_l_D10_D18_c_i + 157.977883096366*v_D10_c_i - 157.977883096366*v_D18_c_i
        struct[0].g[318,0] = i_l_D10_D18_a_r + i_l_D10_D18_b_r + i_l_D10_D18_c_r - i_l_D10_D18_n_r
        struct[0].g[319,0] = i_l_D10_D18_a_i + i_l_D10_D18_b_i + i_l_D10_D18_c_i - i_l_D10_D18_n_i
        struct[0].g[320,0] = -i_l_D4_D14_a_r - 45.1365380275333*v_D14_a_r + 45.1365380275333*v_D4_a_r
        struct[0].g[321,0] = -i_l_D4_D14_a_i - 45.1365380275333*v_D14_a_i + 45.1365380275333*v_D4_a_i
        struct[0].g[322,0] = -i_l_D4_D14_b_r - 45.1365380275333*v_D14_b_r + 45.1365380275333*v_D4_b_r
        struct[0].g[323,0] = -i_l_D4_D14_b_i - 45.1365380275333*v_D14_b_i + 45.1365380275333*v_D4_b_i
        struct[0].g[324,0] = -i_l_D4_D14_c_r - 45.1365380275333*v_D14_c_r + 45.1365380275333*v_D4_c_r
        struct[0].g[325,0] = -i_l_D4_D14_c_i - 45.1365380275333*v_D14_c_i + 45.1365380275333*v_D4_c_i
        struct[0].g[326,0] = i_l_D4_D14_a_r + i_l_D4_D14_b_r + i_l_D4_D14_c_r - i_l_D4_D14_n_r
        struct[0].g[327,0] = i_l_D4_D14_a_i + i_l_D4_D14_b_i + i_l_D4_D14_c_i - i_l_D4_D14_n_i
        struct[0].g[328,0] = -i_l_D14_D15_a_r + 135.4096140826*v_D14_a_r - 135.4096140826*v_D15_a_r
        struct[0].g[329,0] = -i_l_D14_D15_a_i + 135.4096140826*v_D14_a_i - 135.4096140826*v_D15_a_i
        struct[0].g[330,0] = -i_l_D14_D15_b_r + 135.4096140826*v_D14_b_r - 135.4096140826*v_D15_b_r
        struct[0].g[331,0] = -i_l_D14_D15_b_i + 135.4096140826*v_D14_b_i - 135.4096140826*v_D15_b_i
        struct[0].g[332,0] = -i_l_D14_D15_c_r + 135.4096140826*v_D14_c_r - 135.4096140826*v_D15_c_r
        struct[0].g[333,0] = -i_l_D14_D15_c_i + 135.4096140826*v_D14_c_i - 135.4096140826*v_D15_c_i
        struct[0].g[334,0] = i_l_D14_D15_a_r + i_l_D14_D15_b_r + i_l_D14_D15_c_r - i_l_D14_D15_n_r
        struct[0].g[335,0] = i_l_D14_D15_a_i + i_l_D14_D15_b_i + i_l_D14_D15_c_i - i_l_D14_D15_n_i
        struct[0].g[336,0] = i_load_R1_a_i*v_R1_a_i - i_load_R1_a_i*v_R1_n_i + i_load_R1_a_r*v_R1_a_r - i_load_R1_a_r*v_R1_n_r - p_R1_a
        struct[0].g[337,0] = i_load_R1_b_i*v_R1_b_i - i_load_R1_b_i*v_R1_n_i + i_load_R1_b_r*v_R1_b_r - i_load_R1_b_r*v_R1_n_r - p_R1_b
        struct[0].g[338,0] = i_load_R1_c_i*v_R1_c_i - i_load_R1_c_i*v_R1_n_i + i_load_R1_c_r*v_R1_c_r - i_load_R1_c_r*v_R1_n_r - p_R1_c
        struct[0].g[339,0] = -i_load_R1_a_i*v_R1_a_r + i_load_R1_a_i*v_R1_n_r + i_load_R1_a_r*v_R1_a_i - i_load_R1_a_r*v_R1_n_i - q_R1_a
        struct[0].g[340,0] = -i_load_R1_b_i*v_R1_b_r + i_load_R1_b_i*v_R1_n_r + i_load_R1_b_r*v_R1_b_i - i_load_R1_b_r*v_R1_n_i - q_R1_b
        struct[0].g[341,0] = -i_load_R1_c_i*v_R1_c_r + i_load_R1_c_i*v_R1_n_r + i_load_R1_c_r*v_R1_c_i - i_load_R1_c_r*v_R1_n_i - q_R1_c
        struct[0].g[342,0] = i_load_R1_a_r + i_load_R1_b_r + i_load_R1_c_r + i_load_R1_n_r
        struct[0].g[343,0] = i_load_R1_a_i + i_load_R1_b_i + i_load_R1_c_i + i_load_R1_n_i
        struct[0].g[344,0] = 1.0*i_load_R11_a_i*v_R11_a_i - 1.0*i_load_R11_a_i*v_R11_n_i + i_load_R11_a_r*v_R11_a_r - i_load_R11_a_r*v_R11_n_r - p_R11_1
        struct[0].g[345,0] = -1.0*i_load_R11_a_i*v_R11_a_r + 1.0*i_load_R11_a_i*v_R11_n_r + 1.0*i_load_R11_a_r*v_R11_a_i - 1.0*i_load_R11_a_r*v_R11_n_i - q_R11_1
        struct[0].g[346,0] = i_load_R11_a_r + i_load_R11_n_r
        struct[0].g[347,0] = 1.0*i_load_R11_a_i + 1.0*i_load_R11_n_i
        struct[0].g[348,0] = 1.0*i_load_R15_a_i*v_R15_a_i - 1.0*i_load_R15_a_i*v_R15_n_i + i_load_R15_a_r*v_R15_a_r - i_load_R15_a_r*v_R15_n_r - p_R15_1
        struct[0].g[349,0] = -1.0*i_load_R15_a_i*v_R15_a_r + 1.0*i_load_R15_a_i*v_R15_n_r + 1.0*i_load_R15_a_r*v_R15_a_i - 1.0*i_load_R15_a_r*v_R15_n_i - q_R15_1
        struct[0].g[350,0] = i_load_R15_a_r + i_load_R15_n_r
        struct[0].g[351,0] = 1.0*i_load_R15_a_i + 1.0*i_load_R15_n_i
        struct[0].g[352,0] = 1.0*i_load_R16_a_i*v_R16_a_i - 1.0*i_load_R16_a_i*v_R16_n_i + i_load_R16_a_r*v_R16_a_r - i_load_R16_a_r*v_R16_n_r - p_R16_1
        struct[0].g[353,0] = -1.0*i_load_R16_a_i*v_R16_a_r + 1.0*i_load_R16_a_i*v_R16_n_r + 1.0*i_load_R16_a_r*v_R16_a_i - 1.0*i_load_R16_a_r*v_R16_n_i - q_R16_1
        struct[0].g[354,0] = i_load_R16_a_r + i_load_R16_n_r
        struct[0].g[355,0] = 1.0*i_load_R16_a_i + 1.0*i_load_R16_n_i
        struct[0].g[356,0] = 1.0*i_load_R17_a_i*v_R17_a_i - 1.0*i_load_R17_a_i*v_R17_n_i + i_load_R17_a_r*v_R17_a_r - i_load_R17_a_r*v_R17_n_r - p_R17_1
        struct[0].g[357,0] = -1.0*i_load_R17_a_i*v_R17_a_r + 1.0*i_load_R17_a_i*v_R17_n_r + 1.0*i_load_R17_a_r*v_R17_a_i - 1.0*i_load_R17_a_r*v_R17_n_i - q_R17_1
        struct[0].g[358,0] = i_load_R17_a_r + i_load_R17_n_r
        struct[0].g[359,0] = 1.0*i_load_R17_a_i + 1.0*i_load_R17_n_i
        struct[0].g[360,0] = 1.0*i_load_R18_a_i*v_R18_a_i - 1.0*i_load_R18_a_i*v_R18_n_i + i_load_R18_a_r*v_R18_a_r - i_load_R18_a_r*v_R18_n_r - p_R18_1
        struct[0].g[361,0] = -1.0*i_load_R18_a_i*v_R18_a_r + 1.0*i_load_R18_a_i*v_R18_n_r + 1.0*i_load_R18_a_r*v_R18_a_i - 1.0*i_load_R18_a_r*v_R18_n_i - q_R18_1
        struct[0].g[362,0] = i_load_R18_a_r + i_load_R18_n_r
        struct[0].g[363,0] = 1.0*i_load_R18_a_i + 1.0*i_load_R18_n_i
        struct[0].g[364,0] = 1.0*i_load_D15_a_i*v_D15_a_i - 1.0*i_load_D15_a_i*v_D15_n_i + i_load_D15_a_r*v_D15_a_r - i_load_D15_a_r*v_D15_n_r - p_D15_1
        struct[0].g[365,0] = -1.0*i_load_D15_a_i*v_D15_a_r + 1.0*i_load_D15_a_i*v_D15_n_r + 1.0*i_load_D15_a_r*v_D15_a_i - 1.0*i_load_D15_a_r*v_D15_n_i - q_D15_1
        struct[0].g[366,0] = i_load_D15_a_r + i_load_D15_n_r
        struct[0].g[367,0] = 1.0*i_load_D15_a_i + 1.0*i_load_D15_n_i
        struct[0].g[368,0] = 1.0*i_load_D11_a_i*v_D11_a_i - 1.0*i_load_D11_a_i*v_D11_n_i + i_load_D11_a_r*v_D11_a_r - i_load_D11_a_r*v_D11_n_r - p_D11_1
        struct[0].g[369,0] = -1.0*i_load_D11_a_i*v_D11_a_r + 1.0*i_load_D11_a_i*v_D11_n_r + 1.0*i_load_D11_a_r*v_D11_a_i - 1.0*i_load_D11_a_r*v_D11_n_i - q_D11_1
        struct[0].g[370,0] = i_load_D11_a_r + i_load_D11_n_r
        struct[0].g[371,0] = 1.0*i_load_D11_a_i + 1.0*i_load_D11_n_i
        struct[0].g[372,0] = 1.0*i_load_D16_a_i*v_D16_a_i - 1.0*i_load_D16_a_i*v_D16_n_i + i_load_D16_a_r*v_D16_a_r - i_load_D16_a_r*v_D16_n_r - p_D16_1
        struct[0].g[373,0] = -1.0*i_load_D16_a_i*v_D16_a_r + 1.0*i_load_D16_a_i*v_D16_n_r + 1.0*i_load_D16_a_r*v_D16_a_i - 1.0*i_load_D16_a_r*v_D16_n_i - q_D16_1
        struct[0].g[374,0] = i_load_D16_a_r + i_load_D16_n_r
        struct[0].g[375,0] = 1.0*i_load_D16_a_i + 1.0*i_load_D16_n_i
        struct[0].g[376,0] = 1.0*i_load_D17_a_i*v_D17_a_i - 1.0*i_load_D17_a_i*v_D17_n_i + i_load_D17_a_r*v_D17_a_r - i_load_D17_a_r*v_D17_n_r - p_D17_1
        struct[0].g[377,0] = -1.0*i_load_D17_a_i*v_D17_a_r + 1.0*i_load_D17_a_i*v_D17_n_r + 1.0*i_load_D17_a_r*v_D17_a_i - 1.0*i_load_D17_a_r*v_D17_n_i - q_D17_1
        struct[0].g[378,0] = i_load_D17_a_r + i_load_D17_n_r
        struct[0].g[379,0] = 1.0*i_load_D17_a_i + 1.0*i_load_D17_n_i
        struct[0].g[380,0] = 1.0*i_load_D18_a_i*v_D18_a_i - 1.0*i_load_D18_a_i*v_D18_n_i + i_load_D18_a_r*v_D18_a_r - i_load_D18_a_r*v_D18_n_r - p_D18_1
        struct[0].g[381,0] = -1.0*i_load_D18_a_i*v_D18_a_r + 1.0*i_load_D18_a_i*v_D18_n_r + 1.0*i_load_D18_a_r*v_D18_a_i - 1.0*i_load_D18_a_r*v_D18_n_i - q_D18_1
        struct[0].g[382,0] = i_load_D18_a_r + i_load_D18_n_r
        struct[0].g[383,0] = 1.0*i_load_D18_a_i + 1.0*i_load_D18_n_i
        struct[0].g[384,0] = 1.0*i_vsc_R1_a_i*v_R1_a_i - 1.0*i_vsc_R1_a_i*v_R1_n_i + i_vsc_R1_a_r*v_R1_a_r - i_vsc_R1_a_r*v_R1_n_r - p_R1/3
        struct[0].g[385,0] = -1.0*i_vsc_R1_a_i*v_R1_a_r + 1.0*i_vsc_R1_a_i*v_R1_n_r + 1.0*i_vsc_R1_a_r*v_R1_a_i - 1.0*i_vsc_R1_a_r*v_R1_n_i - q_R1/3
        struct[0].g[386,0] = 1.0*i_vsc_R1_b_i*v_R1_b_i - 1.0*i_vsc_R1_b_i*v_R1_n_i + i_vsc_R1_b_r*v_R1_b_r - i_vsc_R1_b_r*v_R1_n_r - p_R1/3
        struct[0].g[387,0] = -1.0*i_vsc_R1_b_i*v_R1_b_r + 1.0*i_vsc_R1_b_i*v_R1_n_r + 1.0*i_vsc_R1_b_r*v_R1_b_i - 1.0*i_vsc_R1_b_r*v_R1_n_i - q_R1/3
        struct[0].g[388,0] = 1.0*i_vsc_R1_c_i*v_R1_c_i - 1.0*i_vsc_R1_c_i*v_R1_n_i + i_vsc_R1_c_r*v_R1_c_r - i_vsc_R1_c_r*v_R1_n_r - p_R1/3
        struct[0].g[389,0] = -1.0*i_vsc_R1_c_i*v_R1_c_r + 1.0*i_vsc_R1_c_i*v_R1_n_r + 1.0*i_vsc_R1_c_r*v_R1_c_i - 1.0*i_vsc_R1_c_r*v_R1_n_i - q_R1/3
        struct[0].g[390,0] = p_D1 + p_R1 + Piecewise(np.array([(-p_loss_R1, p_D1 < 0), (p_loss_R1, True)]))
        struct[0].g[391,0] = i_l_D1_D3_a_r*v_D1_a_r + i_l_D1_D3_n_r*v_D1_n_r - p_D1
        struct[0].g[392,0] = -a_R1 - b_R1*sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - c_R1*(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) + p_loss_R1
        struct[0].g[393,0] = -coef_a_R10*p_R10 + 1.0*i_vsc_R10_a_i*v_R10_a_i - 1.0*i_vsc_R10_a_i*v_R10_n_i + i_vsc_R10_a_r*v_R10_a_r - i_vsc_R10_a_r*v_R10_n_r
        struct[0].g[394,0] = -coef_a_R10*q_R10 - 1.0*i_vsc_R10_a_i*v_R10_a_r + 1.0*i_vsc_R10_a_i*v_R10_n_r + 1.0*i_vsc_R10_a_r*v_R10_a_i - 1.0*i_vsc_R10_a_r*v_R10_n_i
        struct[0].g[395,0] = -coef_b_R10*p_R10 + 1.0*i_vsc_R10_b_i*v_R10_b_i - 1.0*i_vsc_R10_b_i*v_R10_n_i + i_vsc_R10_b_r*v_R10_b_r - i_vsc_R10_b_r*v_R10_n_r
        struct[0].g[396,0] = -coef_b_R10*q_R10 - 1.0*i_vsc_R10_b_i*v_R10_b_r + 1.0*i_vsc_R10_b_i*v_R10_n_r + 1.0*i_vsc_R10_b_r*v_R10_b_i - 1.0*i_vsc_R10_b_r*v_R10_n_i
        struct[0].g[397,0] = -coef_c_R10*p_R10 + 1.0*i_vsc_R10_c_i*v_R10_c_i - 1.0*i_vsc_R10_c_i*v_R10_n_i + i_vsc_R10_c_r*v_R10_c_r - i_vsc_R10_c_r*v_R10_n_r
        struct[0].g[398,0] = -coef_c_R10*q_R10 - 1.0*i_vsc_R10_c_i*v_R10_c_r + 1.0*i_vsc_R10_c_i*v_R10_n_r + 1.0*i_vsc_R10_c_r*v_R10_c_i - 1.0*i_vsc_R10_c_r*v_R10_n_i
        struct[0].g[399,0] = i_vsc_R10_a_r + i_vsc_R10_b_r + i_vsc_R10_c_r + i_vsc_R10_n_r
        struct[0].g[400,0] = i_vsc_R10_a_i + i_vsc_R10_b_i + i_vsc_R10_c_i + i_vsc_R10_n_i
        struct[0].g[401,0] = i_vsc_D10_a_r + p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].g[402,0] = i_vsc_D10_n_r + p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].g[403,0] = p_D10 - p_R10 + Piecewise(np.array([(a_R10 + b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), p_D10 < 0), (-a_R10 - b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), p_D10 > 0), (a_R10 + b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), True)]))
        struct[0].g[404,0] = -coef_a_R14*p_R14 + 1.0*i_vsc_R14_a_i*v_R14_a_i - 1.0*i_vsc_R14_a_i*v_R14_n_i + i_vsc_R14_a_r*v_R14_a_r - i_vsc_R14_a_r*v_R14_n_r
        struct[0].g[405,0] = -coef_a_R14*q_R14 - 1.0*i_vsc_R14_a_i*v_R14_a_r + 1.0*i_vsc_R14_a_i*v_R14_n_r + 1.0*i_vsc_R14_a_r*v_R14_a_i - 1.0*i_vsc_R14_a_r*v_R14_n_i
        struct[0].g[406,0] = -coef_b_R14*p_R14 + 1.0*i_vsc_R14_b_i*v_R14_b_i - 1.0*i_vsc_R14_b_i*v_R14_n_i + i_vsc_R14_b_r*v_R14_b_r - i_vsc_R14_b_r*v_R14_n_r
        struct[0].g[407,0] = -coef_b_R14*q_R14 - 1.0*i_vsc_R14_b_i*v_R14_b_r + 1.0*i_vsc_R14_b_i*v_R14_n_r + 1.0*i_vsc_R14_b_r*v_R14_b_i - 1.0*i_vsc_R14_b_r*v_R14_n_i
        struct[0].g[408,0] = -coef_c_R14*p_R14 + 1.0*i_vsc_R14_c_i*v_R14_c_i - 1.0*i_vsc_R14_c_i*v_R14_n_i + i_vsc_R14_c_r*v_R14_c_r - i_vsc_R14_c_r*v_R14_n_r
        struct[0].g[409,0] = -coef_c_R14*q_R14 - 1.0*i_vsc_R14_c_i*v_R14_c_r + 1.0*i_vsc_R14_c_i*v_R14_n_r + 1.0*i_vsc_R14_c_r*v_R14_c_i - 1.0*i_vsc_R14_c_r*v_R14_n_i
        struct[0].g[410,0] = i_vsc_R14_a_r + i_vsc_R14_b_r + i_vsc_R14_c_r + i_vsc_R14_n_r
        struct[0].g[411,0] = i_vsc_R14_a_i + i_vsc_R14_b_i + i_vsc_R14_c_i + i_vsc_R14_n_i
        struct[0].g[412,0] = i_vsc_D14_a_r + p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].g[413,0] = i_vsc_D14_n_r + p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].g[414,0] = p_D14 - p_R14 + Piecewise(np.array([(a_R14 + b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), p_D14 < 0), (-a_R14 - b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), p_D14 > 0), (a_R14 + b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), True)]))
    
    # Outputs:
    if mode == 3:

        struct[0].h[0,0] = (v_R0_a_i**2 + v_R0_a_r**2)**0.5
        struct[0].h[1,0] = (v_R0_b_i**2 + v_R0_b_r**2)**0.5
        struct[0].h[2,0] = (v_R0_c_i**2 + v_R0_c_r**2)**0.5
        struct[0].h[3,0] = (v_D1_a_i**2 + v_D1_a_r**2)**0.5
        struct[0].h[4,0] = (v_D1_b_i**2 + v_D1_b_r**2)**0.5
        struct[0].h[5,0] = (v_D1_c_i**2 + v_D1_c_r**2)**0.5
        struct[0].h[6,0] = (v_R1_a_i**2 + v_R1_a_r**2)**0.5
        struct[0].h[7,0] = (v_R1_b_i**2 + v_R1_b_r**2)**0.5
        struct[0].h[8,0] = (v_R1_c_i**2 + v_R1_c_r**2)**0.5
        struct[0].h[9,0] = (v_R1_n_i**2 + v_R1_n_r**2)**0.5
        struct[0].h[10,0] = (v_R11_a_i**2 + v_R11_a_r**2)**0.5
        struct[0].h[11,0] = (v_R11_n_i**2 + v_R11_n_r**2)**0.5
        struct[0].h[12,0] = (v_R15_a_i**2 + v_R15_a_r**2)**0.5
        struct[0].h[13,0] = (v_R15_n_i**2 + v_R15_n_r**2)**0.5
        struct[0].h[14,0] = (v_R16_a_i**2 + v_R16_a_r**2)**0.5
        struct[0].h[15,0] = (v_R16_n_i**2 + v_R16_n_r**2)**0.5
        struct[0].h[16,0] = (v_R17_a_i**2 + v_R17_a_r**2)**0.5
        struct[0].h[17,0] = (v_R17_n_i**2 + v_R17_n_r**2)**0.5
        struct[0].h[18,0] = (v_R18_a_i**2 + v_R18_a_r**2)**0.5
        struct[0].h[19,0] = (v_R18_n_i**2 + v_R18_n_r**2)**0.5
        struct[0].h[20,0] = (v_D15_a_i**2 + v_D15_a_r**2)**0.5
        struct[0].h[21,0] = (v_D15_n_i**2 + v_D15_n_r**2)**0.5
        struct[0].h[22,0] = (v_D11_a_i**2 + v_D11_a_r**2)**0.5
        struct[0].h[23,0] = (v_D11_n_i**2 + v_D11_n_r**2)**0.5
        struct[0].h[24,0] = (v_D16_a_i**2 + v_D16_a_r**2)**0.5
        struct[0].h[25,0] = (v_D16_n_i**2 + v_D16_n_r**2)**0.5
        struct[0].h[26,0] = (v_D17_a_i**2 + v_D17_a_r**2)**0.5
        struct[0].h[27,0] = (v_D17_n_i**2 + v_D17_n_r**2)**0.5
        struct[0].h[28,0] = (v_D18_a_i**2 + v_D18_a_r**2)**0.5
        struct[0].h[29,0] = (v_D18_n_i**2 + v_D18_n_r**2)**0.5
        struct[0].h[30,0] = (v_R2_a_i**2 + v_R2_a_r**2)**0.5
        struct[0].h[31,0] = (v_R2_b_i**2 + v_R2_b_r**2)**0.5
        struct[0].h[32,0] = (v_R2_c_i**2 + v_R2_c_r**2)**0.5
        struct[0].h[33,0] = (v_R2_n_i**2 + v_R2_n_r**2)**0.5
        struct[0].h[34,0] = (v_R3_a_i**2 + v_R3_a_r**2)**0.5
        struct[0].h[35,0] = (v_R3_b_i**2 + v_R3_b_r**2)**0.5
        struct[0].h[36,0] = (v_R3_c_i**2 + v_R3_c_r**2)**0.5
        struct[0].h[37,0] = (v_R3_n_i**2 + v_R3_n_r**2)**0.5
        struct[0].h[38,0] = (v_R4_a_i**2 + v_R4_a_r**2)**0.5
        struct[0].h[39,0] = (v_R4_b_i**2 + v_R4_b_r**2)**0.5
        struct[0].h[40,0] = (v_R4_c_i**2 + v_R4_c_r**2)**0.5
        struct[0].h[41,0] = (v_R4_n_i**2 + v_R4_n_r**2)**0.5
        struct[0].h[42,0] = (v_R5_a_i**2 + v_R5_a_r**2)**0.5
        struct[0].h[43,0] = (v_R5_b_i**2 + v_R5_b_r**2)**0.5
        struct[0].h[44,0] = (v_R5_c_i**2 + v_R5_c_r**2)**0.5
        struct[0].h[45,0] = (v_R5_n_i**2 + v_R5_n_r**2)**0.5
        struct[0].h[46,0] = (v_R6_a_i**2 + v_R6_a_r**2)**0.5
        struct[0].h[47,0] = (v_R6_b_i**2 + v_R6_b_r**2)**0.5
        struct[0].h[48,0] = (v_R6_c_i**2 + v_R6_c_r**2)**0.5
        struct[0].h[49,0] = (v_R6_n_i**2 + v_R6_n_r**2)**0.5
        struct[0].h[50,0] = (v_R7_a_i**2 + v_R7_a_r**2)**0.5
        struct[0].h[51,0] = (v_R7_b_i**2 + v_R7_b_r**2)**0.5
        struct[0].h[52,0] = (v_R7_c_i**2 + v_R7_c_r**2)**0.5
        struct[0].h[53,0] = (v_R7_n_i**2 + v_R7_n_r**2)**0.5
        struct[0].h[54,0] = (v_R8_a_i**2 + v_R8_a_r**2)**0.5
        struct[0].h[55,0] = (v_R8_b_i**2 + v_R8_b_r**2)**0.5
        struct[0].h[56,0] = (v_R8_c_i**2 + v_R8_c_r**2)**0.5
        struct[0].h[57,0] = (v_R8_n_i**2 + v_R8_n_r**2)**0.5
        struct[0].h[58,0] = (v_R9_a_i**2 + v_R9_a_r**2)**0.5
        struct[0].h[59,0] = (v_R9_b_i**2 + v_R9_b_r**2)**0.5
        struct[0].h[60,0] = (v_R9_c_i**2 + v_R9_c_r**2)**0.5
        struct[0].h[61,0] = (v_R9_n_i**2 + v_R9_n_r**2)**0.5
        struct[0].h[62,0] = (v_R10_a_i**2 + v_R10_a_r**2)**0.5
        struct[0].h[63,0] = (v_R10_b_i**2 + v_R10_b_r**2)**0.5
        struct[0].h[64,0] = (v_R10_c_i**2 + v_R10_c_r**2)**0.5
        struct[0].h[65,0] = (v_R10_n_i**2 + v_R10_n_r**2)**0.5
        struct[0].h[66,0] = (v_R11_b_i**2 + v_R11_b_r**2)**0.5
        struct[0].h[67,0] = (v_R11_c_i**2 + v_R11_c_r**2)**0.5
        struct[0].h[68,0] = (v_R12_a_i**2 + v_R12_a_r**2)**0.5
        struct[0].h[69,0] = (v_R12_b_i**2 + v_R12_b_r**2)**0.5
        struct[0].h[70,0] = (v_R12_c_i**2 + v_R12_c_r**2)**0.5
        struct[0].h[71,0] = (v_R12_n_i**2 + v_R12_n_r**2)**0.5
        struct[0].h[72,0] = (v_R13_a_i**2 + v_R13_a_r**2)**0.5
        struct[0].h[73,0] = (v_R13_b_i**2 + v_R13_b_r**2)**0.5
        struct[0].h[74,0] = (v_R13_c_i**2 + v_R13_c_r**2)**0.5
        struct[0].h[75,0] = (v_R13_n_i**2 + v_R13_n_r**2)**0.5
        struct[0].h[76,0] = (v_R14_a_i**2 + v_R14_a_r**2)**0.5
        struct[0].h[77,0] = (v_R14_b_i**2 + v_R14_b_r**2)**0.5
        struct[0].h[78,0] = (v_R14_c_i**2 + v_R14_c_r**2)**0.5
        struct[0].h[79,0] = (v_R14_n_i**2 + v_R14_n_r**2)**0.5
        struct[0].h[80,0] = (v_R15_b_i**2 + v_R15_b_r**2)**0.5
        struct[0].h[81,0] = (v_R15_c_i**2 + v_R15_c_r**2)**0.5
        struct[0].h[82,0] = (v_R16_b_i**2 + v_R16_b_r**2)**0.5
        struct[0].h[83,0] = (v_R16_c_i**2 + v_R16_c_r**2)**0.5
        struct[0].h[84,0] = (v_R17_b_i**2 + v_R17_b_r**2)**0.5
        struct[0].h[85,0] = (v_R17_c_i**2 + v_R17_c_r**2)**0.5
        struct[0].h[86,0] = (v_R18_b_i**2 + v_R18_b_r**2)**0.5
        struct[0].h[87,0] = (v_R18_c_i**2 + v_R18_c_r**2)**0.5
        struct[0].h[88,0] = (v_D1_n_i**2 + v_D1_n_r**2)**0.5
        struct[0].h[89,0] = (v_D3_a_i**2 + v_D3_a_r**2)**0.5
        struct[0].h[90,0] = (v_D3_b_i**2 + v_D3_b_r**2)**0.5
        struct[0].h[91,0] = (v_D3_c_i**2 + v_D3_c_r**2)**0.5
        struct[0].h[92,0] = (v_D3_n_i**2 + v_D3_n_r**2)**0.5
        struct[0].h[93,0] = (v_D4_a_i**2 + v_D4_a_r**2)**0.5
        struct[0].h[94,0] = (v_D4_b_i**2 + v_D4_b_r**2)**0.5
        struct[0].h[95,0] = (v_D4_c_i**2 + v_D4_c_r**2)**0.5
        struct[0].h[96,0] = (v_D4_n_i**2 + v_D4_n_r**2)**0.5
        struct[0].h[97,0] = (v_D6_a_i**2 + v_D6_a_r**2)**0.5
        struct[0].h[98,0] = (v_D6_b_i**2 + v_D6_b_r**2)**0.5
        struct[0].h[99,0] = (v_D6_c_i**2 + v_D6_c_r**2)**0.5
        struct[0].h[100,0] = (v_D6_n_i**2 + v_D6_n_r**2)**0.5
        struct[0].h[101,0] = (v_D9_a_i**2 + v_D9_a_r**2)**0.5
        struct[0].h[102,0] = (v_D9_b_i**2 + v_D9_b_r**2)**0.5
        struct[0].h[103,0] = (v_D9_c_i**2 + v_D9_c_r**2)**0.5
        struct[0].h[104,0] = (v_D9_n_i**2 + v_D9_n_r**2)**0.5
        struct[0].h[105,0] = (v_D10_a_i**2 + v_D10_a_r**2)**0.5
        struct[0].h[106,0] = (v_D10_b_i**2 + v_D10_b_r**2)**0.5
        struct[0].h[107,0] = (v_D10_c_i**2 + v_D10_c_r**2)**0.5
        struct[0].h[108,0] = (v_D10_n_i**2 + v_D10_n_r**2)**0.5
        struct[0].h[109,0] = (v_D11_b_i**2 + v_D11_b_r**2)**0.5
        struct[0].h[110,0] = (v_D11_c_i**2 + v_D11_c_r**2)**0.5
        struct[0].h[111,0] = (v_D16_b_i**2 + v_D16_b_r**2)**0.5
        struct[0].h[112,0] = (v_D16_c_i**2 + v_D16_c_r**2)**0.5
        struct[0].h[113,0] = (v_D17_b_i**2 + v_D17_b_r**2)**0.5
        struct[0].h[114,0] = (v_D17_c_i**2 + v_D17_c_r**2)**0.5
        struct[0].h[115,0] = (v_D18_b_i**2 + v_D18_b_r**2)**0.5
        struct[0].h[116,0] = (v_D18_c_i**2 + v_D18_c_r**2)**0.5
        struct[0].h[117,0] = (v_D14_a_i**2 + v_D14_a_r**2)**0.5
        struct[0].h[118,0] = (v_D14_b_i**2 + v_D14_b_r**2)**0.5
        struct[0].h[119,0] = (v_D14_c_i**2 + v_D14_c_r**2)**0.5
        struct[0].h[120,0] = (v_D14_n_i**2 + v_D14_n_r**2)**0.5
        struct[0].h[121,0] = (v_D15_b_i**2 + v_D15_b_r**2)**0.5
        struct[0].h[122,0] = (v_D15_c_i**2 + v_D15_c_r**2)**0.5
    

    if mode == 10:

        struct[0].Fx_ini[0,0] = -1

    if mode == 11:


        struct[0].Gy_ini[0,0] = -123.954122254357
        struct[0].Gy_ini[0,1] = -127.595184532966
        struct[0].Gy_ini[0,2] = 39.6392229058202
        struct[0].Gy_ini[0,3] = 10.2713736253513
        struct[0].Gy_ini[0,4] = 24.9575997948692
        struct[0].Gy_ini[0,5] = 23.2849644809540
        struct[0].Gy_ini[0,6] = 58.0215758469966
        struct[0].Gy_ini[0,7] = 83.8007853900572
        struct[0].Gy_ini[0,48] = 105.571769313180
        struct[0].Gy_ini[0,49] = 54.0657727682604
        struct[0].Gy_ini[0,50] = -39.6392229058202
        struct[0].Gy_ini[0,51] = -10.2713736253513
        struct[0].Gy_ini[0,52] = -24.9575997948692
        struct[0].Gy_ini[0,53] = -23.2849644809540
        struct[0].Gy_ini[0,54] = -39.6392229058202
        struct[0].Gy_ini[0,55] = -10.2713736253513
        struct[0].Gy_ini[0,336] = 1
        struct[0].Gy_ini[0,384] = 1
        struct[0].Gy_ini[1,0] = 127.595184532966
        struct[0].Gy_ini[1,1] = -123.954122254357
        struct[0].Gy_ini[1,2] = -10.2713736253513
        struct[0].Gy_ini[1,3] = 39.6392229058202
        struct[0].Gy_ini[1,4] = -23.2849644809540
        struct[0].Gy_ini[1,5] = 24.9575997948692
        struct[0].Gy_ini[1,6] = -83.8007853900572
        struct[0].Gy_ini[1,7] = 58.0215758469966
        struct[0].Gy_ini[1,48] = -54.0657727682604
        struct[0].Gy_ini[1,49] = 105.571769313180
        struct[0].Gy_ini[1,50] = 10.2713736253513
        struct[0].Gy_ini[1,51] = -39.6392229058202
        struct[0].Gy_ini[1,52] = 23.2849644809540
        struct[0].Gy_ini[1,53] = -24.9575997948692
        struct[0].Gy_ini[1,54] = 10.2713736253513
        struct[0].Gy_ini[1,55] = -39.6392229058202
        struct[0].Gy_ini[1,337] = 1
        struct[0].Gy_ini[1,385] = 1
        struct[0].Gy_ini[2,0] = 39.6392229058202
        struct[0].Gy_ini[2,1] = 10.2713736253513
        struct[0].Gy_ini[2,2] = -123.954122254357
        struct[0].Gy_ini[2,3] = -127.595184532966
        struct[0].Gy_ini[2,4] = 39.6392229058201
        struct[0].Gy_ini[2,5] = 10.2713736253513
        struct[0].Gy_ini[2,6] = 43.3399527360457
        struct[0].Gy_ini[2,7] = 96.8143762456598
        struct[0].Gy_ini[2,48] = -39.6392229058202
        struct[0].Gy_ini[2,49] = -10.2713736253513
        struct[0].Gy_ini[2,50] = 105.571769313180
        struct[0].Gy_ini[2,51] = 54.0657727682604
        struct[0].Gy_ini[2,52] = -39.6392229058201
        struct[0].Gy_ini[2,53] = -10.2713736253513
        struct[0].Gy_ini[2,54] = -24.9575997948692
        struct[0].Gy_ini[2,55] = -23.2849644809540
        struct[0].Gy_ini[2,338] = 1
        struct[0].Gy_ini[2,386] = 1
        struct[0].Gy_ini[3,0] = -10.2713736253513
        struct[0].Gy_ini[3,1] = 39.6392229058202
        struct[0].Gy_ini[3,2] = 127.595184532966
        struct[0].Gy_ini[3,3] = -123.954122254357
        struct[0].Gy_ini[3,4] = -10.2713736253513
        struct[0].Gy_ini[3,5] = 39.6392229058201
        struct[0].Gy_ini[3,6] = -96.8143762456598
        struct[0].Gy_ini[3,7] = 43.3399527360457
        struct[0].Gy_ini[3,48] = 10.2713736253513
        struct[0].Gy_ini[3,49] = -39.6392229058202
        struct[0].Gy_ini[3,50] = -54.0657727682604
        struct[0].Gy_ini[3,51] = 105.571769313180
        struct[0].Gy_ini[3,52] = 10.2713736253513
        struct[0].Gy_ini[3,53] = -39.6392229058201
        struct[0].Gy_ini[3,54] = 23.2849644809540
        struct[0].Gy_ini[3,55] = -24.9575997948692
        struct[0].Gy_ini[3,339] = 1
        struct[0].Gy_ini[3,387] = 1
        struct[0].Gy_ini[4,0] = 24.9575997948692
        struct[0].Gy_ini[4,1] = 23.2849644809540
        struct[0].Gy_ini[4,2] = 39.6392229058202
        struct[0].Gy_ini[4,3] = 10.2713736253513
        struct[0].Gy_ini[4,4] = -123.954122254357
        struct[0].Gy_ini[4,5] = -127.595184532966
        struct[0].Gy_ini[4,6] = 58.0215758469966
        struct[0].Gy_ini[4,7] = 83.8007853900572
        struct[0].Gy_ini[4,48] = -24.9575997948692
        struct[0].Gy_ini[4,49] = -23.2849644809540
        struct[0].Gy_ini[4,50] = -39.6392229058202
        struct[0].Gy_ini[4,51] = -10.2713736253513
        struct[0].Gy_ini[4,52] = 105.571769313180
        struct[0].Gy_ini[4,53] = 54.0657727682604
        struct[0].Gy_ini[4,54] = -39.6392229058201
        struct[0].Gy_ini[4,55] = -10.2713736253514
        struct[0].Gy_ini[4,340] = 1
        struct[0].Gy_ini[4,388] = 1
        struct[0].Gy_ini[5,0] = -23.2849644809540
        struct[0].Gy_ini[5,1] = 24.9575997948692
        struct[0].Gy_ini[5,2] = -10.2713736253513
        struct[0].Gy_ini[5,3] = 39.6392229058202
        struct[0].Gy_ini[5,4] = 127.595184532966
        struct[0].Gy_ini[5,5] = -123.954122254357
        struct[0].Gy_ini[5,6] = -83.8007853900572
        struct[0].Gy_ini[5,7] = 58.0215758469966
        struct[0].Gy_ini[5,48] = 23.2849644809540
        struct[0].Gy_ini[5,49] = -24.9575997948692
        struct[0].Gy_ini[5,50] = 10.2713736253513
        struct[0].Gy_ini[5,51] = -39.6392229058202
        struct[0].Gy_ini[5,52] = -54.0657727682604
        struct[0].Gy_ini[5,53] = 105.571769313180
        struct[0].Gy_ini[5,54] = 10.2713736253514
        struct[0].Gy_ini[5,55] = -39.6392229058201
        struct[0].Gy_ini[5,341] = 1
        struct[0].Gy_ini[5,389] = 1
        struct[0].Gy_ini[6,0] = 58.0215758469966
        struct[0].Gy_ini[6,1] = 83.8007853900572
        struct[0].Gy_ini[6,2] = 43.3399527360457
        struct[0].Gy_ini[6,3] = 96.8143762456598
        struct[0].Gy_ini[6,4] = 58.0215758469966
        struct[0].Gy_ini[6,5] = 83.8007853900572
        struct[0].Gy_ini[6,6] = -161.052161470043
        struct[0].Gy_ini[6,7] = -274.654008062378
        struct[0].Gy_ini[6,48] = -39.6392229058202
        struct[0].Gy_ini[6,49] = -10.2713736253513
        struct[0].Gy_ini[6,50] = -24.9575997948692
        struct[0].Gy_ini[6,51] = -23.2849644809540
        struct[0].Gy_ini[6,52] = -39.6392229058202
        struct[0].Gy_ini[6,53] = -10.2713736253513
        struct[0].Gy_ini[6,54] = 105.571769313180
        struct[0].Gy_ini[6,55] = 54.0657727682604
        struct[0].Gy_ini[7,0] = -83.8007853900572
        struct[0].Gy_ini[7,1] = 58.0215758469966
        struct[0].Gy_ini[7,2] = -96.8143762456598
        struct[0].Gy_ini[7,3] = 43.3399527360457
        struct[0].Gy_ini[7,4] = -83.8007853900572
        struct[0].Gy_ini[7,5] = 58.0215758469966
        struct[0].Gy_ini[7,6] = 274.654008062378
        struct[0].Gy_ini[7,7] = -161.052161470043
        struct[0].Gy_ini[7,48] = 10.2713736253513
        struct[0].Gy_ini[7,49] = -39.6392229058202
        struct[0].Gy_ini[7,50] = 23.2849644809540
        struct[0].Gy_ini[7,51] = -24.9575997948692
        struct[0].Gy_ini[7,52] = 10.2713736253513
        struct[0].Gy_ini[7,53] = -39.6392229058202
        struct[0].Gy_ini[7,54] = -54.0657727682604
        struct[0].Gy_ini[7,55] = 105.571769313180
        struct[0].Gy_ini[8,8] = -26.5300693004806
        struct[0].Gy_ini[8,9] = -4.84676915585801
        struct[0].Gy_ini[8,10] = 7.89461337514771
        struct[0].Gy_ini[8,11] = -1.58482814504483
        struct[0].Gy_ini[8,56] = 26.5300693004806
        struct[0].Gy_ini[8,57] = 4.84676915585801
        struct[0].Gy_ini[8,58] = -7.89461337514770
        struct[0].Gy_ini[8,59] = 1.58482814504483
        struct[0].Gy_ini[8,60] = -7.72144347466701
        struct[0].Gy_ini[8,61] = 0.679918453285310
        struct[0].Gy_ini[8,62] = -7.89461337514771
        struct[0].Gy_ini[8,63] = 1.58482814504483
        struct[0].Gy_ini[8,120] = 7.89461337514770
        struct[0].Gy_ini[8,121] = -1.58482814504483
        struct[0].Gy_ini[8,122] = 7.72144347466701
        struct[0].Gy_ini[8,123] = -0.679918453285310
        struct[0].Gy_ini[8,344] = 1
        struct[0].Gy_ini[9,8] = 4.84676915585801
        struct[0].Gy_ini[9,9] = -26.5300693004806
        struct[0].Gy_ini[9,10] = 1.58482814504483
        struct[0].Gy_ini[9,11] = 7.89461337514771
        struct[0].Gy_ini[9,56] = -4.84676915585801
        struct[0].Gy_ini[9,57] = 26.5300693004806
        struct[0].Gy_ini[9,58] = -1.58482814504483
        struct[0].Gy_ini[9,59] = -7.89461337514770
        struct[0].Gy_ini[9,60] = -0.679918453285310
        struct[0].Gy_ini[9,61] = -7.72144347466701
        struct[0].Gy_ini[9,62] = -1.58482814504483
        struct[0].Gy_ini[9,63] = -7.89461337514771
        struct[0].Gy_ini[9,120] = 1.58482814504483
        struct[0].Gy_ini[9,121] = 7.89461337514770
        struct[0].Gy_ini[9,122] = 0.679918453285310
        struct[0].Gy_ini[9,123] = 7.72144347466701
        struct[0].Gy_ini[9,345] = 1
        struct[0].Gy_ini[10,8] = 7.89461337514771
        struct[0].Gy_ini[10,9] = -1.58482814504483
        struct[0].Gy_ini[10,10] = -26.5550693004806
        struct[0].Gy_ini[10,11] = -4.84676915585801
        struct[0].Gy_ini[10,56] = -7.89461337514771
        struct[0].Gy_ini[10,57] = 1.58482814504483
        struct[0].Gy_ini[10,58] = -7.72144347466701
        struct[0].Gy_ini[10,59] = 0.679918453285308
        struct[0].Gy_ini[10,60] = -7.89461337514771
        struct[0].Gy_ini[10,61] = 1.58482814504483
        struct[0].Gy_ini[10,62] = 26.5300693004806
        struct[0].Gy_ini[10,63] = 4.84676915585801
        struct[0].Gy_ini[10,120] = 7.72144347466701
        struct[0].Gy_ini[10,121] = -0.679918453285308
        struct[0].Gy_ini[10,122] = 7.89461337514771
        struct[0].Gy_ini[10,123] = -1.58482814504483
        struct[0].Gy_ini[10,346] = 1
        struct[0].Gy_ini[11,8] = 1.58482814504483
        struct[0].Gy_ini[11,9] = 7.89461337514771
        struct[0].Gy_ini[11,10] = 4.84676915585801
        struct[0].Gy_ini[11,11] = -26.5550693004806
        struct[0].Gy_ini[11,56] = -1.58482814504483
        struct[0].Gy_ini[11,57] = -7.89461337514771
        struct[0].Gy_ini[11,58] = -0.679918453285308
        struct[0].Gy_ini[11,59] = -7.72144347466701
        struct[0].Gy_ini[11,60] = -1.58482814504483
        struct[0].Gy_ini[11,61] = -7.89461337514771
        struct[0].Gy_ini[11,62] = -4.84676915585801
        struct[0].Gy_ini[11,63] = 26.5300693004806
        struct[0].Gy_ini[11,120] = 0.679918453285308
        struct[0].Gy_ini[11,121] = 7.72144347466701
        struct[0].Gy_ini[11,122] = 1.58482814504483
        struct[0].Gy_ini[11,123] = 7.89461337514771
        struct[0].Gy_ini[11,347] = 1
        struct[0].Gy_ini[12,12] = -26.5300693004806
        struct[0].Gy_ini[12,13] = -4.84676915585801
        struct[0].Gy_ini[12,14] = 7.89461337514771
        struct[0].Gy_ini[12,15] = -1.58482814504483
        struct[0].Gy_ini[12,140] = 26.5300693004806
        struct[0].Gy_ini[12,141] = 4.84676915585801
        struct[0].Gy_ini[12,142] = -7.89461337514770
        struct[0].Gy_ini[12,143] = 1.58482814504483
        struct[0].Gy_ini[12,144] = -7.72144347466701
        struct[0].Gy_ini[12,145] = 0.679918453285310
        struct[0].Gy_ini[12,146] = -7.89461337514771
        struct[0].Gy_ini[12,147] = 1.58482814504483
        struct[0].Gy_ini[12,148] = 7.89461337514770
        struct[0].Gy_ini[12,149] = -1.58482814504483
        struct[0].Gy_ini[12,150] = 7.72144347466701
        struct[0].Gy_ini[12,151] = -0.679918453285310
        struct[0].Gy_ini[12,348] = 1
        struct[0].Gy_ini[13,12] = 4.84676915585801
        struct[0].Gy_ini[13,13] = -26.5300693004806
        struct[0].Gy_ini[13,14] = 1.58482814504483
        struct[0].Gy_ini[13,15] = 7.89461337514771
        struct[0].Gy_ini[13,140] = -4.84676915585801
        struct[0].Gy_ini[13,141] = 26.5300693004806
        struct[0].Gy_ini[13,142] = -1.58482814504483
        struct[0].Gy_ini[13,143] = -7.89461337514770
        struct[0].Gy_ini[13,144] = -0.679918453285310
        struct[0].Gy_ini[13,145] = -7.72144347466701
        struct[0].Gy_ini[13,146] = -1.58482814504483
        struct[0].Gy_ini[13,147] = -7.89461337514771
        struct[0].Gy_ini[13,148] = 1.58482814504483
        struct[0].Gy_ini[13,149] = 7.89461337514770
        struct[0].Gy_ini[13,150] = 0.679918453285310
        struct[0].Gy_ini[13,151] = 7.72144347466701
        struct[0].Gy_ini[13,349] = 1
        struct[0].Gy_ini[14,12] = 7.89461337514771
        struct[0].Gy_ini[14,13] = -1.58482814504483
        struct[0].Gy_ini[14,14] = -26.5550693004806
        struct[0].Gy_ini[14,15] = -4.84676915585801
        struct[0].Gy_ini[14,140] = -7.89461337514771
        struct[0].Gy_ini[14,141] = 1.58482814504483
        struct[0].Gy_ini[14,142] = -7.72144347466701
        struct[0].Gy_ini[14,143] = 0.679918453285308
        struct[0].Gy_ini[14,144] = -7.89461337514771
        struct[0].Gy_ini[14,145] = 1.58482814504483
        struct[0].Gy_ini[14,146] = 26.5300693004806
        struct[0].Gy_ini[14,147] = 4.84676915585801
        struct[0].Gy_ini[14,148] = 7.72144347466701
        struct[0].Gy_ini[14,149] = -0.679918453285308
        struct[0].Gy_ini[14,150] = 7.89461337514771
        struct[0].Gy_ini[14,151] = -1.58482814504483
        struct[0].Gy_ini[14,350] = 1
        struct[0].Gy_ini[15,12] = 1.58482814504483
        struct[0].Gy_ini[15,13] = 7.89461337514771
        struct[0].Gy_ini[15,14] = 4.84676915585801
        struct[0].Gy_ini[15,15] = -26.5550693004806
        struct[0].Gy_ini[15,140] = -1.58482814504483
        struct[0].Gy_ini[15,141] = -7.89461337514771
        struct[0].Gy_ini[15,142] = -0.679918453285308
        struct[0].Gy_ini[15,143] = -7.72144347466701
        struct[0].Gy_ini[15,144] = -1.58482814504483
        struct[0].Gy_ini[15,145] = -7.89461337514771
        struct[0].Gy_ini[15,146] = -4.84676915585801
        struct[0].Gy_ini[15,147] = 26.5300693004806
        struct[0].Gy_ini[15,148] = 0.679918453285308
        struct[0].Gy_ini[15,149] = 7.72144347466701
        struct[0].Gy_ini[15,150] = 1.58482814504483
        struct[0].Gy_ini[15,151] = 7.89461337514771
        struct[0].Gy_ini[15,351] = 1
        struct[0].Gy_ini[16,16] = -30.9517475172273
        struct[0].Gy_ini[16,17] = -5.65456401516768
        struct[0].Gy_ini[16,18] = 9.21038227100566
        struct[0].Gy_ini[16,19] = -1.84896616921897
        struct[0].Gy_ini[16,80] = 30.9517475172273
        struct[0].Gy_ini[16,81] = 5.65456401516768
        struct[0].Gy_ini[16,82] = -9.21038227100566
        struct[0].Gy_ini[16,83] = 1.84896616921897
        struct[0].Gy_ini[16,84] = -9.00835072044485
        struct[0].Gy_ini[16,85] = 0.793238195499529
        struct[0].Gy_ini[16,86] = -9.21038227100566
        struct[0].Gy_ini[16,87] = 1.84896616921897
        struct[0].Gy_ini[16,152] = 9.21038227100566
        struct[0].Gy_ini[16,153] = -1.84896616921897
        struct[0].Gy_ini[16,154] = 9.00835072044485
        struct[0].Gy_ini[16,155] = -0.793238195499529
        struct[0].Gy_ini[16,352] = 1
        struct[0].Gy_ini[17,16] = 5.65456401516768
        struct[0].Gy_ini[17,17] = -30.9517475172273
        struct[0].Gy_ini[17,18] = 1.84896616921897
        struct[0].Gy_ini[17,19] = 9.21038227100566
        struct[0].Gy_ini[17,80] = -5.65456401516768
        struct[0].Gy_ini[17,81] = 30.9517475172273
        struct[0].Gy_ini[17,82] = -1.84896616921897
        struct[0].Gy_ini[17,83] = -9.21038227100566
        struct[0].Gy_ini[17,84] = -0.793238195499529
        struct[0].Gy_ini[17,85] = -9.00835072044485
        struct[0].Gy_ini[17,86] = -1.84896616921897
        struct[0].Gy_ini[17,87] = -9.21038227100566
        struct[0].Gy_ini[17,152] = 1.84896616921897
        struct[0].Gy_ini[17,153] = 9.21038227100566
        struct[0].Gy_ini[17,154] = 0.793238195499529
        struct[0].Gy_ini[17,155] = 9.00835072044485
        struct[0].Gy_ini[17,353] = 1
        struct[0].Gy_ini[18,16] = 9.21038227100566
        struct[0].Gy_ini[18,17] = -1.84896616921897
        struct[0].Gy_ini[18,18] = -30.9767475172273
        struct[0].Gy_ini[18,19] = -5.65456401516768
        struct[0].Gy_ini[18,80] = -9.21038227100566
        struct[0].Gy_ini[18,81] = 1.84896616921897
        struct[0].Gy_ini[18,82] = -9.00835072044485
        struct[0].Gy_ini[18,83] = 0.793238195499527
        struct[0].Gy_ini[18,84] = -9.21038227100566
        struct[0].Gy_ini[18,85] = 1.84896616921897
        struct[0].Gy_ini[18,86] = 30.9517475172273
        struct[0].Gy_ini[18,87] = 5.65456401516768
        struct[0].Gy_ini[18,152] = 9.00835072044485
        struct[0].Gy_ini[18,153] = -0.793238195499527
        struct[0].Gy_ini[18,154] = 9.21038227100566
        struct[0].Gy_ini[18,155] = -1.84896616921897
        struct[0].Gy_ini[18,354] = 1
        struct[0].Gy_ini[19,16] = 1.84896616921897
        struct[0].Gy_ini[19,17] = 9.21038227100566
        struct[0].Gy_ini[19,18] = 5.65456401516768
        struct[0].Gy_ini[19,19] = -30.9767475172273
        struct[0].Gy_ini[19,80] = -1.84896616921897
        struct[0].Gy_ini[19,81] = -9.21038227100566
        struct[0].Gy_ini[19,82] = -0.793238195499527
        struct[0].Gy_ini[19,83] = -9.00835072044485
        struct[0].Gy_ini[19,84] = -1.84896616921897
        struct[0].Gy_ini[19,85] = -9.21038227100566
        struct[0].Gy_ini[19,86] = -5.65456401516768
        struct[0].Gy_ini[19,87] = 30.9517475172273
        struct[0].Gy_ini[19,152] = 0.793238195499527
        struct[0].Gy_ini[19,153] = 9.00835072044485
        struct[0].Gy_ini[19,154] = 1.84896616921897
        struct[0].Gy_ini[19,155] = 9.21038227100566
        struct[0].Gy_ini[19,355] = 1
        struct[0].Gy_ini[20,20] = -30.9517475172273
        struct[0].Gy_ini[20,21] = -5.65456401516768
        struct[0].Gy_ini[20,22] = 9.21038227100566
        struct[0].Gy_ini[20,23] = -1.84896616921897
        struct[0].Gy_ini[20,104] = 30.9517475172273
        struct[0].Gy_ini[20,105] = 5.65456401516768
        struct[0].Gy_ini[20,106] = -9.21038227100566
        struct[0].Gy_ini[20,107] = 1.84896616921897
        struct[0].Gy_ini[20,108] = -9.00835072044485
        struct[0].Gy_ini[20,109] = 0.793238195499529
        struct[0].Gy_ini[20,110] = -9.21038227100566
        struct[0].Gy_ini[20,111] = 1.84896616921897
        struct[0].Gy_ini[20,156] = 9.21038227100566
        struct[0].Gy_ini[20,157] = -1.84896616921897
        struct[0].Gy_ini[20,158] = 9.00835072044485
        struct[0].Gy_ini[20,159] = -0.793238195499529
        struct[0].Gy_ini[20,356] = 1
        struct[0].Gy_ini[21,20] = 5.65456401516768
        struct[0].Gy_ini[21,21] = -30.9517475172273
        struct[0].Gy_ini[21,22] = 1.84896616921897
        struct[0].Gy_ini[21,23] = 9.21038227100566
        struct[0].Gy_ini[21,104] = -5.65456401516768
        struct[0].Gy_ini[21,105] = 30.9517475172273
        struct[0].Gy_ini[21,106] = -1.84896616921897
        struct[0].Gy_ini[21,107] = -9.21038227100566
        struct[0].Gy_ini[21,108] = -0.793238195499529
        struct[0].Gy_ini[21,109] = -9.00835072044485
        struct[0].Gy_ini[21,110] = -1.84896616921897
        struct[0].Gy_ini[21,111] = -9.21038227100566
        struct[0].Gy_ini[21,156] = 1.84896616921897
        struct[0].Gy_ini[21,157] = 9.21038227100566
        struct[0].Gy_ini[21,158] = 0.793238195499529
        struct[0].Gy_ini[21,159] = 9.00835072044485
        struct[0].Gy_ini[21,357] = 1
        struct[0].Gy_ini[22,20] = 9.21038227100566
        struct[0].Gy_ini[22,21] = -1.84896616921897
        struct[0].Gy_ini[22,22] = -30.9767475172273
        struct[0].Gy_ini[22,23] = -5.65456401516768
        struct[0].Gy_ini[22,104] = -9.21038227100566
        struct[0].Gy_ini[22,105] = 1.84896616921897
        struct[0].Gy_ini[22,106] = -9.00835072044485
        struct[0].Gy_ini[22,107] = 0.793238195499527
        struct[0].Gy_ini[22,108] = -9.21038227100566
        struct[0].Gy_ini[22,109] = 1.84896616921897
        struct[0].Gy_ini[22,110] = 30.9517475172273
        struct[0].Gy_ini[22,111] = 5.65456401516768
        struct[0].Gy_ini[22,156] = 9.00835072044485
        struct[0].Gy_ini[22,157] = -0.793238195499527
        struct[0].Gy_ini[22,158] = 9.21038227100566
        struct[0].Gy_ini[22,159] = -1.84896616921897
        struct[0].Gy_ini[22,358] = 1
        struct[0].Gy_ini[23,20] = 1.84896616921897
        struct[0].Gy_ini[23,21] = 9.21038227100566
        struct[0].Gy_ini[23,22] = 5.65456401516768
        struct[0].Gy_ini[23,23] = -30.9767475172273
        struct[0].Gy_ini[23,104] = -1.84896616921897
        struct[0].Gy_ini[23,105] = -9.21038227100566
        struct[0].Gy_ini[23,106] = -0.793238195499527
        struct[0].Gy_ini[23,107] = -9.00835072044485
        struct[0].Gy_ini[23,108] = -1.84896616921897
        struct[0].Gy_ini[23,109] = -9.21038227100566
        struct[0].Gy_ini[23,110] = -5.65456401516768
        struct[0].Gy_ini[23,111] = 30.9517475172273
        struct[0].Gy_ini[23,156] = 0.793238195499527
        struct[0].Gy_ini[23,157] = 9.00835072044485
        struct[0].Gy_ini[23,158] = 1.84896616921897
        struct[0].Gy_ini[23,159] = 9.21038227100566
        struct[0].Gy_ini[23,359] = 1
        struct[0].Gy_ini[24,24] = -30.9517475172273
        struct[0].Gy_ini[24,25] = -5.65456401516768
        struct[0].Gy_ini[24,26] = 9.21038227100566
        struct[0].Gy_ini[24,27] = -1.84896616921897
        struct[0].Gy_ini[24,112] = 30.9517475172273
        struct[0].Gy_ini[24,113] = 5.65456401516768
        struct[0].Gy_ini[24,114] = -9.21038227100566
        struct[0].Gy_ini[24,115] = 1.84896616921897
        struct[0].Gy_ini[24,116] = -9.00835072044485
        struct[0].Gy_ini[24,117] = 0.793238195499529
        struct[0].Gy_ini[24,118] = -9.21038227100566
        struct[0].Gy_ini[24,119] = 1.84896616921897
        struct[0].Gy_ini[24,160] = 9.21038227100566
        struct[0].Gy_ini[24,161] = -1.84896616921897
        struct[0].Gy_ini[24,162] = 9.00835072044485
        struct[0].Gy_ini[24,163] = -0.793238195499529
        struct[0].Gy_ini[24,360] = 1
        struct[0].Gy_ini[25,24] = 5.65456401516768
        struct[0].Gy_ini[25,25] = -30.9517475172273
        struct[0].Gy_ini[25,26] = 1.84896616921897
        struct[0].Gy_ini[25,27] = 9.21038227100566
        struct[0].Gy_ini[25,112] = -5.65456401516768
        struct[0].Gy_ini[25,113] = 30.9517475172273
        struct[0].Gy_ini[25,114] = -1.84896616921897
        struct[0].Gy_ini[25,115] = -9.21038227100566
        struct[0].Gy_ini[25,116] = -0.793238195499529
        struct[0].Gy_ini[25,117] = -9.00835072044485
        struct[0].Gy_ini[25,118] = -1.84896616921897
        struct[0].Gy_ini[25,119] = -9.21038227100566
        struct[0].Gy_ini[25,160] = 1.84896616921897
        struct[0].Gy_ini[25,161] = 9.21038227100566
        struct[0].Gy_ini[25,162] = 0.793238195499529
        struct[0].Gy_ini[25,163] = 9.00835072044485
        struct[0].Gy_ini[25,361] = 1
        struct[0].Gy_ini[26,24] = 9.21038227100566
        struct[0].Gy_ini[26,25] = -1.84896616921897
        struct[0].Gy_ini[26,26] = -30.9767475172273
        struct[0].Gy_ini[26,27] = -5.65456401516768
        struct[0].Gy_ini[26,112] = -9.21038227100566
        struct[0].Gy_ini[26,113] = 1.84896616921897
        struct[0].Gy_ini[26,114] = -9.00835072044485
        struct[0].Gy_ini[26,115] = 0.793238195499527
        struct[0].Gy_ini[26,116] = -9.21038227100566
        struct[0].Gy_ini[26,117] = 1.84896616921897
        struct[0].Gy_ini[26,118] = 30.9517475172273
        struct[0].Gy_ini[26,119] = 5.65456401516768
        struct[0].Gy_ini[26,160] = 9.00835072044485
        struct[0].Gy_ini[26,161] = -0.793238195499527
        struct[0].Gy_ini[26,162] = 9.21038227100566
        struct[0].Gy_ini[26,163] = -1.84896616921897
        struct[0].Gy_ini[26,362] = 1
        struct[0].Gy_ini[27,24] = 1.84896616921897
        struct[0].Gy_ini[27,25] = 9.21038227100566
        struct[0].Gy_ini[27,26] = 5.65456401516768
        struct[0].Gy_ini[27,27] = -30.9767475172273
        struct[0].Gy_ini[27,112] = -1.84896616921897
        struct[0].Gy_ini[27,113] = -9.21038227100566
        struct[0].Gy_ini[27,114] = -0.793238195499527
        struct[0].Gy_ini[27,115] = -9.00835072044485
        struct[0].Gy_ini[27,116] = -1.84896616921897
        struct[0].Gy_ini[27,117] = -9.21038227100566
        struct[0].Gy_ini[27,118] = -5.65456401516768
        struct[0].Gy_ini[27,119] = 30.9517475172273
        struct[0].Gy_ini[27,160] = 0.793238195499527
        struct[0].Gy_ini[27,161] = 9.00835072044485
        struct[0].Gy_ini[27,162] = 1.84896616921897
        struct[0].Gy_ini[27,163] = 9.21038227100566
        struct[0].Gy_ini[27,363] = 1
        struct[0].Gy_ini[28,28] = -135.409614082600
        struct[0].Gy_ini[28,222] = 135.409614082600
        struct[0].Gy_ini[28,364] = 1
        struct[0].Gy_ini[29,29] = -135.409614082600
        struct[0].Gy_ini[29,223] = 135.409614082600
        struct[0].Gy_ini[29,365] = 1
        struct[0].Gy_ini[30,30] = -135.409614082600
        struct[0].Gy_ini[30,228] = 135.409614082600
        struct[0].Gy_ini[30,366] = 1
        struct[0].Gy_ini[31,31] = -135.409614082600
        struct[0].Gy_ini[31,229] = 135.409614082600
        struct[0].Gy_ini[31,367] = 1
        struct[0].Gy_ini[32,32] = -157.977883096366
        struct[0].Gy_ini[32,166] = 157.977883096366
        struct[0].Gy_ini[32,368] = 1
        struct[0].Gy_ini[33,33] = -157.977883096366
        struct[0].Gy_ini[33,167] = 157.977883096366
        struct[0].Gy_ini[33,369] = 1
        struct[0].Gy_ini[34,34] = -157.977883096366
        struct[0].Gy_ini[34,172] = 157.977883096366
        struct[0].Gy_ini[34,370] = 1
        struct[0].Gy_ini[35,35] = -157.977883096366
        struct[0].Gy_ini[35,173] = 157.977883096366
        struct[0].Gy_ini[35,371] = 1
        struct[0].Gy_ini[36,36] = -157.977883096366
        struct[0].Gy_ini[36,182] = 157.977883096366
        struct[0].Gy_ini[36,372] = 1
        struct[0].Gy_ini[37,37] = -157.977883096366
        struct[0].Gy_ini[37,183] = 157.977883096366
        struct[0].Gy_ini[37,373] = 1
        struct[0].Gy_ini[38,38] = -157.977883096366
        struct[0].Gy_ini[38,188] = 157.977883096366
        struct[0].Gy_ini[38,374] = 1
        struct[0].Gy_ini[39,39] = -157.977883096366
        struct[0].Gy_ini[39,189] = 157.977883096366
        struct[0].Gy_ini[39,375] = 1
        struct[0].Gy_ini[40,40] = -157.977883096366
        struct[0].Gy_ini[40,190] = 157.977883096366
        struct[0].Gy_ini[40,376] = 1
        struct[0].Gy_ini[41,41] = -157.977883096366
        struct[0].Gy_ini[41,191] = 157.977883096366
        struct[0].Gy_ini[41,377] = 1
        struct[0].Gy_ini[42,42] = -157.977883096366
        struct[0].Gy_ini[42,196] = 157.977883096366
        struct[0].Gy_ini[42,378] = 1
        struct[0].Gy_ini[43,43] = -157.977883096366
        struct[0].Gy_ini[43,197] = 157.977883096366
        struct[0].Gy_ini[43,379] = 1
        struct[0].Gy_ini[44,44] = -157.977883096366
        struct[0].Gy_ini[44,198] = 157.977883096366
        struct[0].Gy_ini[44,380] = 1
        struct[0].Gy_ini[45,45] = -157.977883096366
        struct[0].Gy_ini[45,199] = 157.977883096366
        struct[0].Gy_ini[45,381] = 1
        struct[0].Gy_ini[46,46] = -157.977883096366
        struct[0].Gy_ini[46,204] = 157.977883096366
        struct[0].Gy_ini[46,382] = 1
        struct[0].Gy_ini[47,47] = -157.977883096366
        struct[0].Gy_ini[47,205] = 157.977883096366
        struct[0].Gy_ini[47,383] = 1
        struct[0].Gy_ini[48,0] = 105.571769313180
        struct[0].Gy_ini[48,1] = 54.0657727682604
        struct[0].Gy_ini[48,2] = -39.6392229058202
        struct[0].Gy_ini[48,3] = -10.2713736253513
        struct[0].Gy_ini[48,4] = -24.9575997948692
        struct[0].Gy_ini[48,5] = -23.2849644809540
        struct[0].Gy_ini[48,6] = -39.6392229058202
        struct[0].Gy_ini[48,7] = -10.2713736253513
        struct[0].Gy_ini[48,48] = -211.143538626360
        struct[0].Gy_ini[48,49] = -108.131545536521
        struct[0].Gy_ini[48,50] = 79.2784458116403
        struct[0].Gy_ini[48,51] = 20.5427472507027
        struct[0].Gy_ini[48,52] = 49.9151995897384
        struct[0].Gy_ini[48,53] = 46.5699289619080
        struct[0].Gy_ini[48,54] = 79.2784458116403
        struct[0].Gy_ini[48,55] = 20.5427472507027
        struct[0].Gy_ini[48,56] = 105.571769313180
        struct[0].Gy_ini[48,57] = 54.0657727682604
        struct[0].Gy_ini[48,58] = -39.6392229058202
        struct[0].Gy_ini[48,59] = -10.2713736253513
        struct[0].Gy_ini[48,60] = -24.9575997948692
        struct[0].Gy_ini[48,61] = -23.2849644809540
        struct[0].Gy_ini[48,62] = -39.6392229058202
        struct[0].Gy_ini[48,63] = -10.2713736253513
        struct[0].Gy_ini[49,0] = -54.0657727682604
        struct[0].Gy_ini[49,1] = 105.571769313180
        struct[0].Gy_ini[49,2] = 10.2713736253513
        struct[0].Gy_ini[49,3] = -39.6392229058202
        struct[0].Gy_ini[49,4] = 23.2849644809540
        struct[0].Gy_ini[49,5] = -24.9575997948692
        struct[0].Gy_ini[49,6] = 10.2713736253513
        struct[0].Gy_ini[49,7] = -39.6392229058202
        struct[0].Gy_ini[49,48] = 108.131545536521
        struct[0].Gy_ini[49,49] = -211.143538626360
        struct[0].Gy_ini[49,50] = -20.5427472507027
        struct[0].Gy_ini[49,51] = 79.2784458116403
        struct[0].Gy_ini[49,52] = -46.5699289619080
        struct[0].Gy_ini[49,53] = 49.9151995897384
        struct[0].Gy_ini[49,54] = -20.5427472507027
        struct[0].Gy_ini[49,55] = 79.2784458116403
        struct[0].Gy_ini[49,56] = -54.0657727682604
        struct[0].Gy_ini[49,57] = 105.571769313180
        struct[0].Gy_ini[49,58] = 10.2713736253513
        struct[0].Gy_ini[49,59] = -39.6392229058202
        struct[0].Gy_ini[49,60] = 23.2849644809540
        struct[0].Gy_ini[49,61] = -24.9575997948692
        struct[0].Gy_ini[49,62] = 10.2713736253513
        struct[0].Gy_ini[49,63] = -39.6392229058202
        struct[0].Gy_ini[50,0] = -39.6392229058202
        struct[0].Gy_ini[50,1] = -10.2713736253513
        struct[0].Gy_ini[50,2] = 105.571769313180
        struct[0].Gy_ini[50,3] = 54.0657727682604
        struct[0].Gy_ini[50,4] = -39.6392229058201
        struct[0].Gy_ini[50,5] = -10.2713736253513
        struct[0].Gy_ini[50,6] = -24.9575997948692
        struct[0].Gy_ini[50,7] = -23.2849644809540
        struct[0].Gy_ini[50,48] = 79.2784458116403
        struct[0].Gy_ini[50,49] = 20.5427472507027
        struct[0].Gy_ini[50,50] = -211.143538626360
        struct[0].Gy_ini[50,51] = -108.131545536521
        struct[0].Gy_ini[50,52] = 79.2784458116403
        struct[0].Gy_ini[50,53] = 20.5427472507027
        struct[0].Gy_ini[50,54] = 49.9151995897384
        struct[0].Gy_ini[50,55] = 46.5699289619080
        struct[0].Gy_ini[50,56] = -39.6392229058202
        struct[0].Gy_ini[50,57] = -10.2713736253513
        struct[0].Gy_ini[50,58] = 105.571769313180
        struct[0].Gy_ini[50,59] = 54.0657727682604
        struct[0].Gy_ini[50,60] = -39.6392229058201
        struct[0].Gy_ini[50,61] = -10.2713736253513
        struct[0].Gy_ini[50,62] = -24.9575997948692
        struct[0].Gy_ini[50,63] = -23.2849644809540
        struct[0].Gy_ini[51,0] = 10.2713736253513
        struct[0].Gy_ini[51,1] = -39.6392229058202
        struct[0].Gy_ini[51,2] = -54.0657727682604
        struct[0].Gy_ini[51,3] = 105.571769313180
        struct[0].Gy_ini[51,4] = 10.2713736253513
        struct[0].Gy_ini[51,5] = -39.6392229058201
        struct[0].Gy_ini[51,6] = 23.2849644809540
        struct[0].Gy_ini[51,7] = -24.9575997948692
        struct[0].Gy_ini[51,48] = -20.5427472507027
        struct[0].Gy_ini[51,49] = 79.2784458116403
        struct[0].Gy_ini[51,50] = 108.131545536521
        struct[0].Gy_ini[51,51] = -211.143538626360
        struct[0].Gy_ini[51,52] = -20.5427472507027
        struct[0].Gy_ini[51,53] = 79.2784458116403
        struct[0].Gy_ini[51,54] = -46.5699289619080
        struct[0].Gy_ini[51,55] = 49.9151995897384
        struct[0].Gy_ini[51,56] = 10.2713736253513
        struct[0].Gy_ini[51,57] = -39.6392229058202
        struct[0].Gy_ini[51,58] = -54.0657727682604
        struct[0].Gy_ini[51,59] = 105.571769313180
        struct[0].Gy_ini[51,60] = 10.2713736253513
        struct[0].Gy_ini[51,61] = -39.6392229058201
        struct[0].Gy_ini[51,62] = 23.2849644809540
        struct[0].Gy_ini[51,63] = -24.9575997948692
        struct[0].Gy_ini[52,0] = -24.9575997948692
        struct[0].Gy_ini[52,1] = -23.2849644809540
        struct[0].Gy_ini[52,2] = -39.6392229058202
        struct[0].Gy_ini[52,3] = -10.2713736253513
        struct[0].Gy_ini[52,4] = 105.571769313180
        struct[0].Gy_ini[52,5] = 54.0657727682604
        struct[0].Gy_ini[52,6] = -39.6392229058201
        struct[0].Gy_ini[52,7] = -10.2713736253514
        struct[0].Gy_ini[52,48] = 49.9151995897384
        struct[0].Gy_ini[52,49] = 46.5699289619080
        struct[0].Gy_ini[52,50] = 79.2784458116404
        struct[0].Gy_ini[52,51] = 20.5427472507027
        struct[0].Gy_ini[52,52] = -211.143538626360
        struct[0].Gy_ini[52,53] = -108.131545536521
        struct[0].Gy_ini[52,54] = 79.2784458116403
        struct[0].Gy_ini[52,55] = 20.5427472507027
        struct[0].Gy_ini[52,56] = -24.9575997948692
        struct[0].Gy_ini[52,57] = -23.2849644809540
        struct[0].Gy_ini[52,58] = -39.6392229058202
        struct[0].Gy_ini[52,59] = -10.2713736253513
        struct[0].Gy_ini[52,60] = 105.571769313180
        struct[0].Gy_ini[52,61] = 54.0657727682604
        struct[0].Gy_ini[52,62] = -39.6392229058201
        struct[0].Gy_ini[52,63] = -10.2713736253514
        struct[0].Gy_ini[53,0] = 23.2849644809540
        struct[0].Gy_ini[53,1] = -24.9575997948692
        struct[0].Gy_ini[53,2] = 10.2713736253513
        struct[0].Gy_ini[53,3] = -39.6392229058202
        struct[0].Gy_ini[53,4] = -54.0657727682604
        struct[0].Gy_ini[53,5] = 105.571769313180
        struct[0].Gy_ini[53,6] = 10.2713736253514
        struct[0].Gy_ini[53,7] = -39.6392229058201
        struct[0].Gy_ini[53,48] = -46.5699289619080
        struct[0].Gy_ini[53,49] = 49.9151995897384
        struct[0].Gy_ini[53,50] = -20.5427472507027
        struct[0].Gy_ini[53,51] = 79.2784458116404
        struct[0].Gy_ini[53,52] = 108.131545536521
        struct[0].Gy_ini[53,53] = -211.143538626360
        struct[0].Gy_ini[53,54] = -20.5427472507027
        struct[0].Gy_ini[53,55] = 79.2784458116403
        struct[0].Gy_ini[53,56] = 23.2849644809540
        struct[0].Gy_ini[53,57] = -24.9575997948692
        struct[0].Gy_ini[53,58] = 10.2713736253513
        struct[0].Gy_ini[53,59] = -39.6392229058202
        struct[0].Gy_ini[53,60] = -54.0657727682604
        struct[0].Gy_ini[53,61] = 105.571769313180
        struct[0].Gy_ini[53,62] = 10.2713736253514
        struct[0].Gy_ini[53,63] = -39.6392229058201
        struct[0].Gy_ini[54,0] = -39.6392229058202
        struct[0].Gy_ini[54,1] = -10.2713736253513
        struct[0].Gy_ini[54,2] = -24.9575997948692
        struct[0].Gy_ini[54,3] = -23.2849644809540
        struct[0].Gy_ini[54,4] = -39.6392229058202
        struct[0].Gy_ini[54,5] = -10.2713736253513
        struct[0].Gy_ini[54,6] = 105.571769313180
        struct[0].Gy_ini[54,7] = 54.0657727682604
        struct[0].Gy_ini[54,48] = 79.2784458116403
        struct[0].Gy_ini[54,49] = 20.5427472507027
        struct[0].Gy_ini[54,50] = 49.9151995897384
        struct[0].Gy_ini[54,51] = 46.5699289619080
        struct[0].Gy_ini[54,52] = 79.2784458116403
        struct[0].Gy_ini[54,53] = 20.5427472507027
        struct[0].Gy_ini[54,54] = -211.168538626360
        struct[0].Gy_ini[54,55] = -108.131545536521
        struct[0].Gy_ini[54,56] = -39.6392229058202
        struct[0].Gy_ini[54,57] = -10.2713736253513
        struct[0].Gy_ini[54,58] = -24.9575997948692
        struct[0].Gy_ini[54,59] = -23.2849644809540
        struct[0].Gy_ini[54,60] = -39.6392229058202
        struct[0].Gy_ini[54,61] = -10.2713736253513
        struct[0].Gy_ini[54,62] = 105.571769313180
        struct[0].Gy_ini[54,63] = 54.0657727682604
        struct[0].Gy_ini[55,0] = 10.2713736253513
        struct[0].Gy_ini[55,1] = -39.6392229058202
        struct[0].Gy_ini[55,2] = 23.2849644809540
        struct[0].Gy_ini[55,3] = -24.9575997948692
        struct[0].Gy_ini[55,4] = 10.2713736253513
        struct[0].Gy_ini[55,5] = -39.6392229058202
        struct[0].Gy_ini[55,6] = -54.0657727682604
        struct[0].Gy_ini[55,7] = 105.571769313180
        struct[0].Gy_ini[55,48] = -20.5427472507027
        struct[0].Gy_ini[55,49] = 79.2784458116403
        struct[0].Gy_ini[55,50] = -46.5699289619080
        struct[0].Gy_ini[55,51] = 49.9151995897384
        struct[0].Gy_ini[55,52] = -20.5427472507027
        struct[0].Gy_ini[55,53] = 79.2784458116403
        struct[0].Gy_ini[55,54] = 108.131545536521
        struct[0].Gy_ini[55,55] = -211.168538626360
        struct[0].Gy_ini[55,56] = 10.2713736253513
        struct[0].Gy_ini[55,57] = -39.6392229058202
        struct[0].Gy_ini[55,58] = 23.2849644809540
        struct[0].Gy_ini[55,59] = -24.9575997948692
        struct[0].Gy_ini[55,60] = 10.2713736253513
        struct[0].Gy_ini[55,61] = -39.6392229058202
        struct[0].Gy_ini[55,62] = -54.0657727682604
        struct[0].Gy_ini[55,63] = 105.571769313180
        struct[0].Gy_ini[56,8] = 26.5300693004806
        struct[0].Gy_ini[56,9] = 4.84676915585801
        struct[0].Gy_ini[56,10] = -7.89461337514771
        struct[0].Gy_ini[56,11] = 1.58482814504483
        struct[0].Gy_ini[56,48] = 105.571769313180
        struct[0].Gy_ini[56,49] = 54.0657727682604
        struct[0].Gy_ini[56,50] = -39.6392229058202
        struct[0].Gy_ini[56,51] = -10.2713736253513
        struct[0].Gy_ini[56,52] = -24.9575997948692
        struct[0].Gy_ini[56,53] = -23.2849644809540
        struct[0].Gy_ini[56,54] = -39.6392229058202
        struct[0].Gy_ini[56,55] = -10.2713736253513
        struct[0].Gy_ini[56,56] = -237.673607926841
        struct[0].Gy_ini[56,57] = -112.978314692379
        struct[0].Gy_ini[56,58] = 87.1730591867880
        struct[0].Gy_ini[56,59] = 18.9579191056578
        struct[0].Gy_ini[56,60] = 57.6366430644055
        struct[0].Gy_ini[56,61] = 45.8900105086227
        struct[0].Gy_ini[56,62] = 87.1730591867880
        struct[0].Gy_ini[56,63] = 18.9579191056579
        struct[0].Gy_ini[56,64] = 105.571769313180
        struct[0].Gy_ini[56,65] = 54.0657727682604
        struct[0].Gy_ini[56,66] = -39.6392229058202
        struct[0].Gy_ini[56,67] = -10.2713736253513
        struct[0].Gy_ini[56,68] = -24.9575997948692
        struct[0].Gy_ini[56,69] = -23.2849644809540
        struct[0].Gy_ini[56,70] = -39.6392229058202
        struct[0].Gy_ini[56,71] = -10.2713736253513
        struct[0].Gy_ini[56,120] = -7.89461337514770
        struct[0].Gy_ini[56,121] = 1.58482814504483
        struct[0].Gy_ini[56,122] = -7.72144347466701
        struct[0].Gy_ini[56,123] = 0.679918453285310
        struct[0].Gy_ini[57,8] = -4.84676915585801
        struct[0].Gy_ini[57,9] = 26.5300693004806
        struct[0].Gy_ini[57,10] = -1.58482814504483
        struct[0].Gy_ini[57,11] = -7.89461337514771
        struct[0].Gy_ini[57,48] = -54.0657727682604
        struct[0].Gy_ini[57,49] = 105.571769313180
        struct[0].Gy_ini[57,50] = 10.2713736253513
        struct[0].Gy_ini[57,51] = -39.6392229058202
        struct[0].Gy_ini[57,52] = 23.2849644809540
        struct[0].Gy_ini[57,53] = -24.9575997948692
        struct[0].Gy_ini[57,54] = 10.2713736253513
        struct[0].Gy_ini[57,55] = -39.6392229058202
        struct[0].Gy_ini[57,56] = 112.978314692379
        struct[0].Gy_ini[57,57] = -237.673607926841
        struct[0].Gy_ini[57,58] = -18.9579191056578
        struct[0].Gy_ini[57,59] = 87.1730591867880
        struct[0].Gy_ini[57,60] = -45.8900105086227
        struct[0].Gy_ini[57,61] = 57.6366430644055
        struct[0].Gy_ini[57,62] = -18.9579191056579
        struct[0].Gy_ini[57,63] = 87.1730591867880
        struct[0].Gy_ini[57,64] = -54.0657727682604
        struct[0].Gy_ini[57,65] = 105.571769313180
        struct[0].Gy_ini[57,66] = 10.2713736253513
        struct[0].Gy_ini[57,67] = -39.6392229058202
        struct[0].Gy_ini[57,68] = 23.2849644809540
        struct[0].Gy_ini[57,69] = -24.9575997948692
        struct[0].Gy_ini[57,70] = 10.2713736253513
        struct[0].Gy_ini[57,71] = -39.6392229058202
        struct[0].Gy_ini[57,120] = -1.58482814504483
        struct[0].Gy_ini[57,121] = -7.89461337514770
        struct[0].Gy_ini[57,122] = -0.679918453285310
        struct[0].Gy_ini[57,123] = -7.72144347466701
        struct[0].Gy_ini[58,8] = -7.89461337514771
        struct[0].Gy_ini[58,9] = 1.58482814504483
        struct[0].Gy_ini[58,10] = -7.72144347466701
        struct[0].Gy_ini[58,11] = 0.679918453285308
        struct[0].Gy_ini[58,48] = -39.6392229058202
        struct[0].Gy_ini[58,49] = -10.2713736253513
        struct[0].Gy_ini[58,50] = 105.571769313180
        struct[0].Gy_ini[58,51] = 54.0657727682604
        struct[0].Gy_ini[58,52] = -39.6392229058201
        struct[0].Gy_ini[58,53] = -10.2713736253513
        struct[0].Gy_ini[58,54] = -24.9575997948692
        struct[0].Gy_ini[58,55] = -23.2849644809540
        struct[0].Gy_ini[58,56] = 87.1730591867880
        struct[0].Gy_ini[58,57] = 18.9579191056579
        struct[0].Gy_ini[58,58] = -237.673607926841
        struct[0].Gy_ini[58,59] = -112.978314692379
        struct[0].Gy_ini[58,60] = 87.1730591867880
        struct[0].Gy_ini[58,61] = 18.9579191056579
        struct[0].Gy_ini[58,62] = 57.6366430644054
        struct[0].Gy_ini[58,63] = 45.8900105086227
        struct[0].Gy_ini[58,64] = -39.6392229058202
        struct[0].Gy_ini[58,65] = -10.2713736253513
        struct[0].Gy_ini[58,66] = 105.571769313180
        struct[0].Gy_ini[58,67] = 54.0657727682604
        struct[0].Gy_ini[58,68] = -39.6392229058201
        struct[0].Gy_ini[58,69] = -10.2713736253513
        struct[0].Gy_ini[58,70] = -24.9575997948692
        struct[0].Gy_ini[58,71] = -23.2849644809540
        struct[0].Gy_ini[58,120] = 26.5300693004806
        struct[0].Gy_ini[58,121] = 4.84676915585801
        struct[0].Gy_ini[58,122] = -7.89461337514771
        struct[0].Gy_ini[58,123] = 1.58482814504483
        struct[0].Gy_ini[59,8] = -1.58482814504483
        struct[0].Gy_ini[59,9] = -7.89461337514771
        struct[0].Gy_ini[59,10] = -0.679918453285308
        struct[0].Gy_ini[59,11] = -7.72144347466701
        struct[0].Gy_ini[59,48] = 10.2713736253513
        struct[0].Gy_ini[59,49] = -39.6392229058202
        struct[0].Gy_ini[59,50] = -54.0657727682604
        struct[0].Gy_ini[59,51] = 105.571769313180
        struct[0].Gy_ini[59,52] = 10.2713736253513
        struct[0].Gy_ini[59,53] = -39.6392229058201
        struct[0].Gy_ini[59,54] = 23.2849644809540
        struct[0].Gy_ini[59,55] = -24.9575997948692
        struct[0].Gy_ini[59,56] = -18.9579191056579
        struct[0].Gy_ini[59,57] = 87.1730591867880
        struct[0].Gy_ini[59,58] = 112.978314692379
        struct[0].Gy_ini[59,59] = -237.673607926841
        struct[0].Gy_ini[59,60] = -18.9579191056579
        struct[0].Gy_ini[59,61] = 87.1730591867880
        struct[0].Gy_ini[59,62] = -45.8900105086227
        struct[0].Gy_ini[59,63] = 57.6366430644054
        struct[0].Gy_ini[59,64] = 10.2713736253513
        struct[0].Gy_ini[59,65] = -39.6392229058202
        struct[0].Gy_ini[59,66] = -54.0657727682604
        struct[0].Gy_ini[59,67] = 105.571769313180
        struct[0].Gy_ini[59,68] = 10.2713736253513
        struct[0].Gy_ini[59,69] = -39.6392229058201
        struct[0].Gy_ini[59,70] = 23.2849644809540
        struct[0].Gy_ini[59,71] = -24.9575997948692
        struct[0].Gy_ini[59,120] = -4.84676915585801
        struct[0].Gy_ini[59,121] = 26.5300693004806
        struct[0].Gy_ini[59,122] = -1.58482814504483
        struct[0].Gy_ini[59,123] = -7.89461337514771
        struct[0].Gy_ini[60,8] = -7.72144347466701
        struct[0].Gy_ini[60,9] = 0.679918453285310
        struct[0].Gy_ini[60,10] = -7.89461337514771
        struct[0].Gy_ini[60,11] = 1.58482814504483
        struct[0].Gy_ini[60,48] = -24.9575997948692
        struct[0].Gy_ini[60,49] = -23.2849644809540
        struct[0].Gy_ini[60,50] = -39.6392229058202
        struct[0].Gy_ini[60,51] = -10.2713736253513
        struct[0].Gy_ini[60,52] = 105.571769313180
        struct[0].Gy_ini[60,53] = 54.0657727682604
        struct[0].Gy_ini[60,54] = -39.6392229058201
        struct[0].Gy_ini[60,55] = -10.2713736253514
        struct[0].Gy_ini[60,56] = 57.6366430644054
        struct[0].Gy_ini[60,57] = 45.8900105086227
        struct[0].Gy_ini[60,58] = 87.1730591867881
        struct[0].Gy_ini[60,59] = 18.9579191056578
        struct[0].Gy_ini[60,60] = -237.673607926841
        struct[0].Gy_ini[60,61] = -112.978314692379
        struct[0].Gy_ini[60,62] = 87.1730591867880
        struct[0].Gy_ini[60,63] = 18.9579191056579
        struct[0].Gy_ini[60,64] = -24.9575997948692
        struct[0].Gy_ini[60,65] = -23.2849644809540
        struct[0].Gy_ini[60,66] = -39.6392229058202
        struct[0].Gy_ini[60,67] = -10.2713736253513
        struct[0].Gy_ini[60,68] = 105.571769313180
        struct[0].Gy_ini[60,69] = 54.0657727682604
        struct[0].Gy_ini[60,70] = -39.6392229058201
        struct[0].Gy_ini[60,71] = -10.2713736253514
        struct[0].Gy_ini[60,120] = -7.89461337514770
        struct[0].Gy_ini[60,121] = 1.58482814504483
        struct[0].Gy_ini[60,122] = 26.5300693004806
        struct[0].Gy_ini[60,123] = 4.84676915585801
        struct[0].Gy_ini[61,8] = -0.679918453285310
        struct[0].Gy_ini[61,9] = -7.72144347466701
        struct[0].Gy_ini[61,10] = -1.58482814504483
        struct[0].Gy_ini[61,11] = -7.89461337514771
        struct[0].Gy_ini[61,48] = 23.2849644809540
        struct[0].Gy_ini[61,49] = -24.9575997948692
        struct[0].Gy_ini[61,50] = 10.2713736253513
        struct[0].Gy_ini[61,51] = -39.6392229058202
        struct[0].Gy_ini[61,52] = -54.0657727682604
        struct[0].Gy_ini[61,53] = 105.571769313180
        struct[0].Gy_ini[61,54] = 10.2713736253514
        struct[0].Gy_ini[61,55] = -39.6392229058201
        struct[0].Gy_ini[61,56] = -45.8900105086227
        struct[0].Gy_ini[61,57] = 57.6366430644054
        struct[0].Gy_ini[61,58] = -18.9579191056578
        struct[0].Gy_ini[61,59] = 87.1730591867881
        struct[0].Gy_ini[61,60] = 112.978314692379
        struct[0].Gy_ini[61,61] = -237.673607926841
        struct[0].Gy_ini[61,62] = -18.9579191056579
        struct[0].Gy_ini[61,63] = 87.1730591867880
        struct[0].Gy_ini[61,64] = 23.2849644809540
        struct[0].Gy_ini[61,65] = -24.9575997948692
        struct[0].Gy_ini[61,66] = 10.2713736253513
        struct[0].Gy_ini[61,67] = -39.6392229058202
        struct[0].Gy_ini[61,68] = -54.0657727682604
        struct[0].Gy_ini[61,69] = 105.571769313180
        struct[0].Gy_ini[61,70] = 10.2713736253514
        struct[0].Gy_ini[61,71] = -39.6392229058201
        struct[0].Gy_ini[61,120] = -1.58482814504483
        struct[0].Gy_ini[61,121] = -7.89461337514770
        struct[0].Gy_ini[61,122] = -4.84676915585801
        struct[0].Gy_ini[61,123] = 26.5300693004806
        struct[0].Gy_ini[62,8] = -7.89461337514771
        struct[0].Gy_ini[62,9] = 1.58482814504483
        struct[0].Gy_ini[62,10] = 26.5300693004806
        struct[0].Gy_ini[62,11] = 4.84676915585801
        struct[0].Gy_ini[62,48] = -39.6392229058202
        struct[0].Gy_ini[62,49] = -10.2713736253513
        struct[0].Gy_ini[62,50] = -24.9575997948692
        struct[0].Gy_ini[62,51] = -23.2849644809540
        struct[0].Gy_ini[62,52] = -39.6392229058202
        struct[0].Gy_ini[62,53] = -10.2713736253513
        struct[0].Gy_ini[62,54] = 105.571769313180
        struct[0].Gy_ini[62,55] = 54.0657727682604
        struct[0].Gy_ini[62,56] = 87.1730591867880
        struct[0].Gy_ini[62,57] = 18.9579191056578
        struct[0].Gy_ini[62,58] = 57.6366430644054
        struct[0].Gy_ini[62,59] = 45.8900105086227
        struct[0].Gy_ini[62,60] = 87.1730591867880
        struct[0].Gy_ini[62,61] = 18.9579191056579
        struct[0].Gy_ini[62,62] = -237.673607926841
        struct[0].Gy_ini[62,63] = -112.978314692379
        struct[0].Gy_ini[62,64] = -39.6392229058202
        struct[0].Gy_ini[62,65] = -10.2713736253513
        struct[0].Gy_ini[62,66] = -24.9575997948692
        struct[0].Gy_ini[62,67] = -23.2849644809540
        struct[0].Gy_ini[62,68] = -39.6392229058202
        struct[0].Gy_ini[62,69] = -10.2713736253513
        struct[0].Gy_ini[62,70] = 105.571769313180
        struct[0].Gy_ini[62,71] = 54.0657727682604
        struct[0].Gy_ini[62,120] = -7.72144347466701
        struct[0].Gy_ini[62,121] = 0.679918453285308
        struct[0].Gy_ini[62,122] = -7.89461337514771
        struct[0].Gy_ini[62,123] = 1.58482814504483
        struct[0].Gy_ini[63,8] = -1.58482814504483
        struct[0].Gy_ini[63,9] = -7.89461337514771
        struct[0].Gy_ini[63,10] = -4.84676915585801
        struct[0].Gy_ini[63,11] = 26.5300693004806
        struct[0].Gy_ini[63,48] = 10.2713736253513
        struct[0].Gy_ini[63,49] = -39.6392229058202
        struct[0].Gy_ini[63,50] = 23.2849644809540
        struct[0].Gy_ini[63,51] = -24.9575997948692
        struct[0].Gy_ini[63,52] = 10.2713736253513
        struct[0].Gy_ini[63,53] = -39.6392229058202
        struct[0].Gy_ini[63,54] = -54.0657727682604
        struct[0].Gy_ini[63,55] = 105.571769313180
        struct[0].Gy_ini[63,56] = -18.9579191056578
        struct[0].Gy_ini[63,57] = 87.1730591867880
        struct[0].Gy_ini[63,58] = -45.8900105086227
        struct[0].Gy_ini[63,59] = 57.6366430644054
        struct[0].Gy_ini[63,60] = -18.9579191056579
        struct[0].Gy_ini[63,61] = 87.1730591867880
        struct[0].Gy_ini[63,62] = 112.978314692379
        struct[0].Gy_ini[63,63] = -237.673607926841
        struct[0].Gy_ini[63,64] = 10.2713736253513
        struct[0].Gy_ini[63,65] = -39.6392229058202
        struct[0].Gy_ini[63,66] = 23.2849644809540
        struct[0].Gy_ini[63,67] = -24.9575997948692
        struct[0].Gy_ini[63,68] = 10.2713736253513
        struct[0].Gy_ini[63,69] = -39.6392229058202
        struct[0].Gy_ini[63,70] = -54.0657727682604
        struct[0].Gy_ini[63,71] = 105.571769313180
        struct[0].Gy_ini[63,120] = -0.679918453285308
        struct[0].Gy_ini[63,121] = -7.72144347466701
        struct[0].Gy_ini[63,122] = -1.58482814504483
        struct[0].Gy_ini[63,123] = -7.89461337514771
        struct[0].Gy_ini[64,56] = 105.571769313180
        struct[0].Gy_ini[64,57] = 54.0657727682604
        struct[0].Gy_ini[64,58] = -39.6392229058202
        struct[0].Gy_ini[64,59] = -10.2713736253513
        struct[0].Gy_ini[64,60] = -24.9575997948692
        struct[0].Gy_ini[64,61] = -23.2849644809540
        struct[0].Gy_ini[64,62] = -39.6392229058202
        struct[0].Gy_ini[64,63] = -10.2713736253513
        struct[0].Gy_ini[64,64] = -237.673607926841
        struct[0].Gy_ini[64,65] = -112.978314692379
        struct[0].Gy_ini[64,66] = 87.1730591867880
        struct[0].Gy_ini[64,67] = 18.9579191056578
        struct[0].Gy_ini[64,68] = 57.6366430644055
        struct[0].Gy_ini[64,69] = 45.8900105086227
        struct[0].Gy_ini[64,70] = 87.1730591867880
        struct[0].Gy_ini[64,71] = 18.9579191056579
        struct[0].Gy_ini[64,72] = 105.571769313180
        struct[0].Gy_ini[64,73] = 54.0657727682604
        struct[0].Gy_ini[64,74] = -39.6392229058202
        struct[0].Gy_ini[64,75] = -10.2713736253513
        struct[0].Gy_ini[64,76] = -24.9575997948692
        struct[0].Gy_ini[64,77] = -23.2849644809540
        struct[0].Gy_ini[64,78] = -39.6392229058202
        struct[0].Gy_ini[64,79] = -10.2713736253513
        struct[0].Gy_ini[64,124] = 26.5300693004806
        struct[0].Gy_ini[64,125] = 4.84676915585801
        struct[0].Gy_ini[64,126] = -7.89461337514770
        struct[0].Gy_ini[64,127] = 1.58482814504483
        struct[0].Gy_ini[64,128] = -7.72144347466701
        struct[0].Gy_ini[64,129] = 0.679918453285310
        struct[0].Gy_ini[64,130] = -7.89461337514771
        struct[0].Gy_ini[64,131] = 1.58482814504483
        struct[0].Gy_ini[65,56] = -54.0657727682604
        struct[0].Gy_ini[65,57] = 105.571769313180
        struct[0].Gy_ini[65,58] = 10.2713736253513
        struct[0].Gy_ini[65,59] = -39.6392229058202
        struct[0].Gy_ini[65,60] = 23.2849644809540
        struct[0].Gy_ini[65,61] = -24.9575997948692
        struct[0].Gy_ini[65,62] = 10.2713736253513
        struct[0].Gy_ini[65,63] = -39.6392229058202
        struct[0].Gy_ini[65,64] = 112.978314692379
        struct[0].Gy_ini[65,65] = -237.673607926841
        struct[0].Gy_ini[65,66] = -18.9579191056578
        struct[0].Gy_ini[65,67] = 87.1730591867880
        struct[0].Gy_ini[65,68] = -45.8900105086227
        struct[0].Gy_ini[65,69] = 57.6366430644055
        struct[0].Gy_ini[65,70] = -18.9579191056579
        struct[0].Gy_ini[65,71] = 87.1730591867880
        struct[0].Gy_ini[65,72] = -54.0657727682604
        struct[0].Gy_ini[65,73] = 105.571769313180
        struct[0].Gy_ini[65,74] = 10.2713736253513
        struct[0].Gy_ini[65,75] = -39.6392229058202
        struct[0].Gy_ini[65,76] = 23.2849644809540
        struct[0].Gy_ini[65,77] = -24.9575997948692
        struct[0].Gy_ini[65,78] = 10.2713736253513
        struct[0].Gy_ini[65,79] = -39.6392229058202
        struct[0].Gy_ini[65,124] = -4.84676915585801
        struct[0].Gy_ini[65,125] = 26.5300693004806
        struct[0].Gy_ini[65,126] = -1.58482814504483
        struct[0].Gy_ini[65,127] = -7.89461337514770
        struct[0].Gy_ini[65,128] = -0.679918453285310
        struct[0].Gy_ini[65,129] = -7.72144347466701
        struct[0].Gy_ini[65,130] = -1.58482814504483
        struct[0].Gy_ini[65,131] = -7.89461337514771
        struct[0].Gy_ini[66,56] = -39.6392229058202
        struct[0].Gy_ini[66,57] = -10.2713736253513
        struct[0].Gy_ini[66,58] = 105.571769313180
        struct[0].Gy_ini[66,59] = 54.0657727682604
        struct[0].Gy_ini[66,60] = -39.6392229058201
        struct[0].Gy_ini[66,61] = -10.2713736253513
        struct[0].Gy_ini[66,62] = -24.9575997948692
        struct[0].Gy_ini[66,63] = -23.2849644809540
        struct[0].Gy_ini[66,64] = 87.1730591867880
        struct[0].Gy_ini[66,65] = 18.9579191056579
        struct[0].Gy_ini[66,66] = -237.673607926841
        struct[0].Gy_ini[66,67] = -112.978314692379
        struct[0].Gy_ini[66,68] = 87.1730591867880
        struct[0].Gy_ini[66,69] = 18.9579191056579
        struct[0].Gy_ini[66,70] = 57.6366430644054
        struct[0].Gy_ini[66,71] = 45.8900105086227
        struct[0].Gy_ini[66,72] = -39.6392229058202
        struct[0].Gy_ini[66,73] = -10.2713736253513
        struct[0].Gy_ini[66,74] = 105.571769313180
        struct[0].Gy_ini[66,75] = 54.0657727682604
        struct[0].Gy_ini[66,76] = -39.6392229058201
        struct[0].Gy_ini[66,77] = -10.2713736253513
        struct[0].Gy_ini[66,78] = -24.9575997948692
        struct[0].Gy_ini[66,79] = -23.2849644809540
        struct[0].Gy_ini[66,124] = -7.89461337514771
        struct[0].Gy_ini[66,125] = 1.58482814504483
        struct[0].Gy_ini[66,126] = 26.5300693004806
        struct[0].Gy_ini[66,127] = 4.84676915585801
        struct[0].Gy_ini[66,128] = -7.89461337514771
        struct[0].Gy_ini[66,129] = 1.58482814504483
        struct[0].Gy_ini[66,130] = -7.72144347466701
        struct[0].Gy_ini[66,131] = 0.679918453285308
        struct[0].Gy_ini[67,56] = 10.2713736253513
        struct[0].Gy_ini[67,57] = -39.6392229058202
        struct[0].Gy_ini[67,58] = -54.0657727682604
        struct[0].Gy_ini[67,59] = 105.571769313180
        struct[0].Gy_ini[67,60] = 10.2713736253513
        struct[0].Gy_ini[67,61] = -39.6392229058201
        struct[0].Gy_ini[67,62] = 23.2849644809540
        struct[0].Gy_ini[67,63] = -24.9575997948692
        struct[0].Gy_ini[67,64] = -18.9579191056579
        struct[0].Gy_ini[67,65] = 87.1730591867880
        struct[0].Gy_ini[67,66] = 112.978314692379
        struct[0].Gy_ini[67,67] = -237.673607926841
        struct[0].Gy_ini[67,68] = -18.9579191056579
        struct[0].Gy_ini[67,69] = 87.1730591867880
        struct[0].Gy_ini[67,70] = -45.8900105086227
        struct[0].Gy_ini[67,71] = 57.6366430644054
        struct[0].Gy_ini[67,72] = 10.2713736253513
        struct[0].Gy_ini[67,73] = -39.6392229058202
        struct[0].Gy_ini[67,74] = -54.0657727682604
        struct[0].Gy_ini[67,75] = 105.571769313180
        struct[0].Gy_ini[67,76] = 10.2713736253513
        struct[0].Gy_ini[67,77] = -39.6392229058201
        struct[0].Gy_ini[67,78] = 23.2849644809540
        struct[0].Gy_ini[67,79] = -24.9575997948692
        struct[0].Gy_ini[67,124] = -1.58482814504483
        struct[0].Gy_ini[67,125] = -7.89461337514771
        struct[0].Gy_ini[67,126] = -4.84676915585801
        struct[0].Gy_ini[67,127] = 26.5300693004806
        struct[0].Gy_ini[67,128] = -1.58482814504483
        struct[0].Gy_ini[67,129] = -7.89461337514771
        struct[0].Gy_ini[67,130] = -0.679918453285308
        struct[0].Gy_ini[67,131] = -7.72144347466701
        struct[0].Gy_ini[68,56] = -24.9575997948692
        struct[0].Gy_ini[68,57] = -23.2849644809540
        struct[0].Gy_ini[68,58] = -39.6392229058202
        struct[0].Gy_ini[68,59] = -10.2713736253513
        struct[0].Gy_ini[68,60] = 105.571769313180
        struct[0].Gy_ini[68,61] = 54.0657727682604
        struct[0].Gy_ini[68,62] = -39.6392229058201
        struct[0].Gy_ini[68,63] = -10.2713736253514
        struct[0].Gy_ini[68,64] = 57.6366430644054
        struct[0].Gy_ini[68,65] = 45.8900105086227
        struct[0].Gy_ini[68,66] = 87.1730591867881
        struct[0].Gy_ini[68,67] = 18.9579191056578
        struct[0].Gy_ini[68,68] = -237.673607926841
        struct[0].Gy_ini[68,69] = -112.978314692379
        struct[0].Gy_ini[68,70] = 87.1730591867880
        struct[0].Gy_ini[68,71] = 18.9579191056579
        struct[0].Gy_ini[68,72] = -24.9575997948692
        struct[0].Gy_ini[68,73] = -23.2849644809540
        struct[0].Gy_ini[68,74] = -39.6392229058202
        struct[0].Gy_ini[68,75] = -10.2713736253513
        struct[0].Gy_ini[68,76] = 105.571769313180
        struct[0].Gy_ini[68,77] = 54.0657727682604
        struct[0].Gy_ini[68,78] = -39.6392229058201
        struct[0].Gy_ini[68,79] = -10.2713736253514
        struct[0].Gy_ini[68,124] = -7.72144347466701
        struct[0].Gy_ini[68,125] = 0.679918453285310
        struct[0].Gy_ini[68,126] = -7.89461337514770
        struct[0].Gy_ini[68,127] = 1.58482814504483
        struct[0].Gy_ini[68,128] = 26.5300693004806
        struct[0].Gy_ini[68,129] = 4.84676915585801
        struct[0].Gy_ini[68,130] = -7.89461337514771
        struct[0].Gy_ini[68,131] = 1.58482814504483
        struct[0].Gy_ini[69,56] = 23.2849644809540
        struct[0].Gy_ini[69,57] = -24.9575997948692
        struct[0].Gy_ini[69,58] = 10.2713736253513
        struct[0].Gy_ini[69,59] = -39.6392229058202
        struct[0].Gy_ini[69,60] = -54.0657727682604
        struct[0].Gy_ini[69,61] = 105.571769313180
        struct[0].Gy_ini[69,62] = 10.2713736253514
        struct[0].Gy_ini[69,63] = -39.6392229058201
        struct[0].Gy_ini[69,64] = -45.8900105086227
        struct[0].Gy_ini[69,65] = 57.6366430644054
        struct[0].Gy_ini[69,66] = -18.9579191056578
        struct[0].Gy_ini[69,67] = 87.1730591867881
        struct[0].Gy_ini[69,68] = 112.978314692379
        struct[0].Gy_ini[69,69] = -237.673607926841
        struct[0].Gy_ini[69,70] = -18.9579191056579
        struct[0].Gy_ini[69,71] = 87.1730591867880
        struct[0].Gy_ini[69,72] = 23.2849644809540
        struct[0].Gy_ini[69,73] = -24.9575997948692
        struct[0].Gy_ini[69,74] = 10.2713736253513
        struct[0].Gy_ini[69,75] = -39.6392229058202
        struct[0].Gy_ini[69,76] = -54.0657727682604
        struct[0].Gy_ini[69,77] = 105.571769313180
        struct[0].Gy_ini[69,78] = 10.2713736253514
        struct[0].Gy_ini[69,79] = -39.6392229058201
        struct[0].Gy_ini[69,124] = -0.679918453285310
        struct[0].Gy_ini[69,125] = -7.72144347466701
        struct[0].Gy_ini[69,126] = -1.58482814504483
        struct[0].Gy_ini[69,127] = -7.89461337514770
        struct[0].Gy_ini[69,128] = -4.84676915585801
        struct[0].Gy_ini[69,129] = 26.5300693004806
        struct[0].Gy_ini[69,130] = -1.58482814504483
        struct[0].Gy_ini[69,131] = -7.89461337514771
        struct[0].Gy_ini[70,56] = -39.6392229058202
        struct[0].Gy_ini[70,57] = -10.2713736253513
        struct[0].Gy_ini[70,58] = -24.9575997948692
        struct[0].Gy_ini[70,59] = -23.2849644809540
        struct[0].Gy_ini[70,60] = -39.6392229058202
        struct[0].Gy_ini[70,61] = -10.2713736253513
        struct[0].Gy_ini[70,62] = 105.571769313180
        struct[0].Gy_ini[70,63] = 54.0657727682604
        struct[0].Gy_ini[70,64] = 87.1730591867880
        struct[0].Gy_ini[70,65] = 18.9579191056578
        struct[0].Gy_ini[70,66] = 57.6366430644054
        struct[0].Gy_ini[70,67] = 45.8900105086227
        struct[0].Gy_ini[70,68] = 87.1730591867880
        struct[0].Gy_ini[70,69] = 18.9579191056579
        struct[0].Gy_ini[70,70] = -237.698607926841
        struct[0].Gy_ini[70,71] = -112.978314692379
        struct[0].Gy_ini[70,72] = -39.6392229058202
        struct[0].Gy_ini[70,73] = -10.2713736253513
        struct[0].Gy_ini[70,74] = -24.9575997948692
        struct[0].Gy_ini[70,75] = -23.2849644809540
        struct[0].Gy_ini[70,76] = -39.6392229058202
        struct[0].Gy_ini[70,77] = -10.2713736253513
        struct[0].Gy_ini[70,78] = 105.571769313180
        struct[0].Gy_ini[70,79] = 54.0657727682604
        struct[0].Gy_ini[70,124] = -7.89461337514771
        struct[0].Gy_ini[70,125] = 1.58482814504483
        struct[0].Gy_ini[70,126] = -7.72144347466701
        struct[0].Gy_ini[70,127] = 0.679918453285308
        struct[0].Gy_ini[70,128] = -7.89461337514771
        struct[0].Gy_ini[70,129] = 1.58482814504483
        struct[0].Gy_ini[70,130] = 26.5300693004806
        struct[0].Gy_ini[70,131] = 4.84676915585801
        struct[0].Gy_ini[71,56] = 10.2713736253513
        struct[0].Gy_ini[71,57] = -39.6392229058202
        struct[0].Gy_ini[71,58] = 23.2849644809540
        struct[0].Gy_ini[71,59] = -24.9575997948692
        struct[0].Gy_ini[71,60] = 10.2713736253513
        struct[0].Gy_ini[71,61] = -39.6392229058202
        struct[0].Gy_ini[71,62] = -54.0657727682604
        struct[0].Gy_ini[71,63] = 105.571769313180
        struct[0].Gy_ini[71,64] = -18.9579191056578
        struct[0].Gy_ini[71,65] = 87.1730591867880
        struct[0].Gy_ini[71,66] = -45.8900105086227
        struct[0].Gy_ini[71,67] = 57.6366430644054
        struct[0].Gy_ini[71,68] = -18.9579191056579
        struct[0].Gy_ini[71,69] = 87.1730591867880
        struct[0].Gy_ini[71,70] = 112.978314692379
        struct[0].Gy_ini[71,71] = -237.698607926841
        struct[0].Gy_ini[71,72] = 10.2713736253513
        struct[0].Gy_ini[71,73] = -39.6392229058202
        struct[0].Gy_ini[71,74] = 23.2849644809540
        struct[0].Gy_ini[71,75] = -24.9575997948692
        struct[0].Gy_ini[71,76] = 10.2713736253513
        struct[0].Gy_ini[71,77] = -39.6392229058202
        struct[0].Gy_ini[71,78] = -54.0657727682604
        struct[0].Gy_ini[71,79] = 105.571769313180
        struct[0].Gy_ini[71,124] = -1.58482814504483
        struct[0].Gy_ini[71,125] = -7.89461337514771
        struct[0].Gy_ini[71,126] = -0.679918453285308
        struct[0].Gy_ini[71,127] = -7.72144347466701
        struct[0].Gy_ini[71,128] = -1.58482814504483
        struct[0].Gy_ini[71,129] = -7.89461337514771
        struct[0].Gy_ini[71,130] = -4.84676915585801
        struct[0].Gy_ini[71,131] = 26.5300693004806
        struct[0].Gy_ini[72,64] = 105.571769313180
        struct[0].Gy_ini[72,65] = 54.0657727682604
        struct[0].Gy_ini[72,66] = -39.6392229058202
        struct[0].Gy_ini[72,67] = -10.2713736253513
        struct[0].Gy_ini[72,68] = -24.9575997948692
        struct[0].Gy_ini[72,69] = -23.2849644809540
        struct[0].Gy_ini[72,70] = -39.6392229058202
        struct[0].Gy_ini[72,71] = -10.2713736253513
        struct[0].Gy_ini[72,72] = -211.143538626360
        struct[0].Gy_ini[72,73] = -108.131545536521
        struct[0].Gy_ini[72,74] = 79.2784458116403
        struct[0].Gy_ini[72,75] = 20.5427472507027
        struct[0].Gy_ini[72,76] = 49.9151995897384
        struct[0].Gy_ini[72,77] = 46.5699289619080
        struct[0].Gy_ini[72,78] = 79.2784458116403
        struct[0].Gy_ini[72,79] = 20.5427472507027
        struct[0].Gy_ini[72,80] = 105.571769313180
        struct[0].Gy_ini[72,81] = 54.0657727682604
        struct[0].Gy_ini[72,82] = -39.6392229058202
        struct[0].Gy_ini[72,83] = -10.2713736253513
        struct[0].Gy_ini[72,84] = -24.9575997948692
        struct[0].Gy_ini[72,85] = -23.2849644809540
        struct[0].Gy_ini[72,86] = -39.6392229058202
        struct[0].Gy_ini[72,87] = -10.2713736253513
        struct[0].Gy_ini[73,64] = -54.0657727682604
        struct[0].Gy_ini[73,65] = 105.571769313180
        struct[0].Gy_ini[73,66] = 10.2713736253513
        struct[0].Gy_ini[73,67] = -39.6392229058202
        struct[0].Gy_ini[73,68] = 23.2849644809540
        struct[0].Gy_ini[73,69] = -24.9575997948692
        struct[0].Gy_ini[73,70] = 10.2713736253513
        struct[0].Gy_ini[73,71] = -39.6392229058202
        struct[0].Gy_ini[73,72] = 108.131545536521
        struct[0].Gy_ini[73,73] = -211.143538626360
        struct[0].Gy_ini[73,74] = -20.5427472507027
        struct[0].Gy_ini[73,75] = 79.2784458116403
        struct[0].Gy_ini[73,76] = -46.5699289619080
        struct[0].Gy_ini[73,77] = 49.9151995897384
        struct[0].Gy_ini[73,78] = -20.5427472507027
        struct[0].Gy_ini[73,79] = 79.2784458116403
        struct[0].Gy_ini[73,80] = -54.0657727682604
        struct[0].Gy_ini[73,81] = 105.571769313180
        struct[0].Gy_ini[73,82] = 10.2713736253513
        struct[0].Gy_ini[73,83] = -39.6392229058202
        struct[0].Gy_ini[73,84] = 23.2849644809540
        struct[0].Gy_ini[73,85] = -24.9575997948692
        struct[0].Gy_ini[73,86] = 10.2713736253513
        struct[0].Gy_ini[73,87] = -39.6392229058202
        struct[0].Gy_ini[74,64] = -39.6392229058202
        struct[0].Gy_ini[74,65] = -10.2713736253513
        struct[0].Gy_ini[74,66] = 105.571769313180
        struct[0].Gy_ini[74,67] = 54.0657727682604
        struct[0].Gy_ini[74,68] = -39.6392229058201
        struct[0].Gy_ini[74,69] = -10.2713736253513
        struct[0].Gy_ini[74,70] = -24.9575997948692
        struct[0].Gy_ini[74,71] = -23.2849644809540
        struct[0].Gy_ini[74,72] = 79.2784458116403
        struct[0].Gy_ini[74,73] = 20.5427472507027
        struct[0].Gy_ini[74,74] = -211.143538626360
        struct[0].Gy_ini[74,75] = -108.131545536521
        struct[0].Gy_ini[74,76] = 79.2784458116403
        struct[0].Gy_ini[74,77] = 20.5427472507027
        struct[0].Gy_ini[74,78] = 49.9151995897384
        struct[0].Gy_ini[74,79] = 46.5699289619080
        struct[0].Gy_ini[74,80] = -39.6392229058202
        struct[0].Gy_ini[74,81] = -10.2713736253513
        struct[0].Gy_ini[74,82] = 105.571769313180
        struct[0].Gy_ini[74,83] = 54.0657727682604
        struct[0].Gy_ini[74,84] = -39.6392229058201
        struct[0].Gy_ini[74,85] = -10.2713736253513
        struct[0].Gy_ini[74,86] = -24.9575997948692
        struct[0].Gy_ini[74,87] = -23.2849644809540
        struct[0].Gy_ini[75,64] = 10.2713736253513
        struct[0].Gy_ini[75,65] = -39.6392229058202
        struct[0].Gy_ini[75,66] = -54.0657727682604
        struct[0].Gy_ini[75,67] = 105.571769313180
        struct[0].Gy_ini[75,68] = 10.2713736253513
        struct[0].Gy_ini[75,69] = -39.6392229058201
        struct[0].Gy_ini[75,70] = 23.2849644809540
        struct[0].Gy_ini[75,71] = -24.9575997948692
        struct[0].Gy_ini[75,72] = -20.5427472507027
        struct[0].Gy_ini[75,73] = 79.2784458116403
        struct[0].Gy_ini[75,74] = 108.131545536521
        struct[0].Gy_ini[75,75] = -211.143538626360
        struct[0].Gy_ini[75,76] = -20.5427472507027
        struct[0].Gy_ini[75,77] = 79.2784458116403
        struct[0].Gy_ini[75,78] = -46.5699289619080
        struct[0].Gy_ini[75,79] = 49.9151995897384
        struct[0].Gy_ini[75,80] = 10.2713736253513
        struct[0].Gy_ini[75,81] = -39.6392229058202
        struct[0].Gy_ini[75,82] = -54.0657727682604
        struct[0].Gy_ini[75,83] = 105.571769313180
        struct[0].Gy_ini[75,84] = 10.2713736253513
        struct[0].Gy_ini[75,85] = -39.6392229058201
        struct[0].Gy_ini[75,86] = 23.2849644809540
        struct[0].Gy_ini[75,87] = -24.9575997948692
        struct[0].Gy_ini[76,64] = -24.9575997948692
        struct[0].Gy_ini[76,65] = -23.2849644809540
        struct[0].Gy_ini[76,66] = -39.6392229058202
        struct[0].Gy_ini[76,67] = -10.2713736253513
        struct[0].Gy_ini[76,68] = 105.571769313180
        struct[0].Gy_ini[76,69] = 54.0657727682604
        struct[0].Gy_ini[76,70] = -39.6392229058201
        struct[0].Gy_ini[76,71] = -10.2713736253514
        struct[0].Gy_ini[76,72] = 49.9151995897384
        struct[0].Gy_ini[76,73] = 46.5699289619080
        struct[0].Gy_ini[76,74] = 79.2784458116404
        struct[0].Gy_ini[76,75] = 20.5427472507027
        struct[0].Gy_ini[76,76] = -211.143538626360
        struct[0].Gy_ini[76,77] = -108.131545536521
        struct[0].Gy_ini[76,78] = 79.2784458116403
        struct[0].Gy_ini[76,79] = 20.5427472507027
        struct[0].Gy_ini[76,80] = -24.9575997948692
        struct[0].Gy_ini[76,81] = -23.2849644809540
        struct[0].Gy_ini[76,82] = -39.6392229058202
        struct[0].Gy_ini[76,83] = -10.2713736253513
        struct[0].Gy_ini[76,84] = 105.571769313180
        struct[0].Gy_ini[76,85] = 54.0657727682604
        struct[0].Gy_ini[76,86] = -39.6392229058201
        struct[0].Gy_ini[76,87] = -10.2713736253514
        struct[0].Gy_ini[77,64] = 23.2849644809540
        struct[0].Gy_ini[77,65] = -24.9575997948692
        struct[0].Gy_ini[77,66] = 10.2713736253513
        struct[0].Gy_ini[77,67] = -39.6392229058202
        struct[0].Gy_ini[77,68] = -54.0657727682604
        struct[0].Gy_ini[77,69] = 105.571769313180
        struct[0].Gy_ini[77,70] = 10.2713736253514
        struct[0].Gy_ini[77,71] = -39.6392229058201
        struct[0].Gy_ini[77,72] = -46.5699289619080
        struct[0].Gy_ini[77,73] = 49.9151995897384
        struct[0].Gy_ini[77,74] = -20.5427472507027
        struct[0].Gy_ini[77,75] = 79.2784458116404
        struct[0].Gy_ini[77,76] = 108.131545536521
        struct[0].Gy_ini[77,77] = -211.143538626360
        struct[0].Gy_ini[77,78] = -20.5427472507027
        struct[0].Gy_ini[77,79] = 79.2784458116403
        struct[0].Gy_ini[77,80] = 23.2849644809540
        struct[0].Gy_ini[77,81] = -24.9575997948692
        struct[0].Gy_ini[77,82] = 10.2713736253513
        struct[0].Gy_ini[77,83] = -39.6392229058202
        struct[0].Gy_ini[77,84] = -54.0657727682604
        struct[0].Gy_ini[77,85] = 105.571769313180
        struct[0].Gy_ini[77,86] = 10.2713736253514
        struct[0].Gy_ini[77,87] = -39.6392229058201
        struct[0].Gy_ini[78,64] = -39.6392229058202
        struct[0].Gy_ini[78,65] = -10.2713736253513
        struct[0].Gy_ini[78,66] = -24.9575997948692
        struct[0].Gy_ini[78,67] = -23.2849644809540
        struct[0].Gy_ini[78,68] = -39.6392229058202
        struct[0].Gy_ini[78,69] = -10.2713736253513
        struct[0].Gy_ini[78,70] = 105.571769313180
        struct[0].Gy_ini[78,71] = 54.0657727682604
        struct[0].Gy_ini[78,72] = 79.2784458116403
        struct[0].Gy_ini[78,73] = 20.5427472507027
        struct[0].Gy_ini[78,74] = 49.9151995897384
        struct[0].Gy_ini[78,75] = 46.5699289619080
        struct[0].Gy_ini[78,76] = 79.2784458116403
        struct[0].Gy_ini[78,77] = 20.5427472507027
        struct[0].Gy_ini[78,78] = -211.143538626360
        struct[0].Gy_ini[78,79] = -108.131545536521
        struct[0].Gy_ini[78,80] = -39.6392229058202
        struct[0].Gy_ini[78,81] = -10.2713736253513
        struct[0].Gy_ini[78,82] = -24.9575997948692
        struct[0].Gy_ini[78,83] = -23.2849644809540
        struct[0].Gy_ini[78,84] = -39.6392229058202
        struct[0].Gy_ini[78,85] = -10.2713736253513
        struct[0].Gy_ini[78,86] = 105.571769313180
        struct[0].Gy_ini[78,87] = 54.0657727682604
        struct[0].Gy_ini[79,64] = 10.2713736253513
        struct[0].Gy_ini[79,65] = -39.6392229058202
        struct[0].Gy_ini[79,66] = 23.2849644809540
        struct[0].Gy_ini[79,67] = -24.9575997948692
        struct[0].Gy_ini[79,68] = 10.2713736253513
        struct[0].Gy_ini[79,69] = -39.6392229058202
        struct[0].Gy_ini[79,70] = -54.0657727682604
        struct[0].Gy_ini[79,71] = 105.571769313180
        struct[0].Gy_ini[79,72] = -20.5427472507027
        struct[0].Gy_ini[79,73] = 79.2784458116403
        struct[0].Gy_ini[79,74] = -46.5699289619080
        struct[0].Gy_ini[79,75] = 49.9151995897384
        struct[0].Gy_ini[79,76] = -20.5427472507027
        struct[0].Gy_ini[79,77] = 79.2784458116403
        struct[0].Gy_ini[79,78] = 108.131545536521
        struct[0].Gy_ini[79,79] = -211.143538626360
        struct[0].Gy_ini[79,80] = 10.2713736253513
        struct[0].Gy_ini[79,81] = -39.6392229058202
        struct[0].Gy_ini[79,82] = 23.2849644809540
        struct[0].Gy_ini[79,83] = -24.9575997948692
        struct[0].Gy_ini[79,84] = 10.2713736253513
        struct[0].Gy_ini[79,85] = -39.6392229058202
        struct[0].Gy_ini[79,86] = -54.0657727682604
        struct[0].Gy_ini[79,87] = 105.571769313180
        struct[0].Gy_ini[80,16] = 30.9517475172273
        struct[0].Gy_ini[80,17] = 5.65456401516768
        struct[0].Gy_ini[80,18] = -9.21038227100566
        struct[0].Gy_ini[80,19] = 1.84896616921897
        struct[0].Gy_ini[80,72] = 105.571769313180
        struct[0].Gy_ini[80,73] = 54.0657727682604
        struct[0].Gy_ini[80,74] = -39.6392229058202
        struct[0].Gy_ini[80,75] = -10.2713736253513
        struct[0].Gy_ini[80,76] = -24.9575997948692
        struct[0].Gy_ini[80,77] = -23.2849644809540
        struct[0].Gy_ini[80,78] = -39.6392229058202
        struct[0].Gy_ini[80,79] = -10.2713736253513
        struct[0].Gy_ini[80,80] = -242.095286143588
        struct[0].Gy_ini[80,81] = -113.786109551688
        struct[0].Gy_ini[80,82] = 88.4888280826460
        struct[0].Gy_ini[80,83] = 18.6937810814837
        struct[0].Gy_ini[80,84] = 58.9235503101833
        struct[0].Gy_ini[80,85] = 45.7766907664085
        struct[0].Gy_ini[80,86] = 88.4888280826460
        struct[0].Gy_ini[80,87] = 18.6937810814837
        struct[0].Gy_ini[80,88] = 105.571769313180
        struct[0].Gy_ini[80,89] = 54.0657727682604
        struct[0].Gy_ini[80,90] = -39.6392229058202
        struct[0].Gy_ini[80,91] = -10.2713736253513
        struct[0].Gy_ini[80,92] = -24.9575997948692
        struct[0].Gy_ini[80,93] = -23.2849644809540
        struct[0].Gy_ini[80,94] = -39.6392229058202
        struct[0].Gy_ini[80,95] = -10.2713736253513
        struct[0].Gy_ini[80,152] = -9.21038227100566
        struct[0].Gy_ini[80,153] = 1.84896616921897
        struct[0].Gy_ini[80,154] = -9.00835072044485
        struct[0].Gy_ini[80,155] = 0.793238195499529
        struct[0].Gy_ini[81,16] = -5.65456401516768
        struct[0].Gy_ini[81,17] = 30.9517475172273
        struct[0].Gy_ini[81,18] = -1.84896616921897
        struct[0].Gy_ini[81,19] = -9.21038227100566
        struct[0].Gy_ini[81,72] = -54.0657727682604
        struct[0].Gy_ini[81,73] = 105.571769313180
        struct[0].Gy_ini[81,74] = 10.2713736253513
        struct[0].Gy_ini[81,75] = -39.6392229058202
        struct[0].Gy_ini[81,76] = 23.2849644809540
        struct[0].Gy_ini[81,77] = -24.9575997948692
        struct[0].Gy_ini[81,78] = 10.2713736253513
        struct[0].Gy_ini[81,79] = -39.6392229058202
        struct[0].Gy_ini[81,80] = 113.786109551688
        struct[0].Gy_ini[81,81] = -242.095286143588
        struct[0].Gy_ini[81,82] = -18.6937810814837
        struct[0].Gy_ini[81,83] = 88.4888280826460
        struct[0].Gy_ini[81,84] = -45.7766907664085
        struct[0].Gy_ini[81,85] = 58.9235503101833
        struct[0].Gy_ini[81,86] = -18.6937810814837
        struct[0].Gy_ini[81,87] = 88.4888280826460
        struct[0].Gy_ini[81,88] = -54.0657727682604
        struct[0].Gy_ini[81,89] = 105.571769313180
        struct[0].Gy_ini[81,90] = 10.2713736253513
        struct[0].Gy_ini[81,91] = -39.6392229058202
        struct[0].Gy_ini[81,92] = 23.2849644809540
        struct[0].Gy_ini[81,93] = -24.9575997948692
        struct[0].Gy_ini[81,94] = 10.2713736253513
        struct[0].Gy_ini[81,95] = -39.6392229058202
        struct[0].Gy_ini[81,152] = -1.84896616921897
        struct[0].Gy_ini[81,153] = -9.21038227100566
        struct[0].Gy_ini[81,154] = -0.793238195499529
        struct[0].Gy_ini[81,155] = -9.00835072044485
        struct[0].Gy_ini[82,16] = -9.21038227100566
        struct[0].Gy_ini[82,17] = 1.84896616921897
        struct[0].Gy_ini[82,18] = -9.00835072044485
        struct[0].Gy_ini[82,19] = 0.793238195499528
        struct[0].Gy_ini[82,72] = -39.6392229058202
        struct[0].Gy_ini[82,73] = -10.2713736253513
        struct[0].Gy_ini[82,74] = 105.571769313180
        struct[0].Gy_ini[82,75] = 54.0657727682604
        struct[0].Gy_ini[82,76] = -39.6392229058201
        struct[0].Gy_ini[82,77] = -10.2713736253513
        struct[0].Gy_ini[82,78] = -24.9575997948692
        struct[0].Gy_ini[82,79] = -23.2849644809540
        struct[0].Gy_ini[82,80] = 88.4888280826460
        struct[0].Gy_ini[82,81] = 18.6937810814837
        struct[0].Gy_ini[82,82] = -242.095286143588
        struct[0].Gy_ini[82,83] = -113.786109551688
        struct[0].Gy_ini[82,84] = 88.4888280826460
        struct[0].Gy_ini[82,85] = 18.6937810814837
        struct[0].Gy_ini[82,86] = 58.9235503101833
        struct[0].Gy_ini[82,87] = 45.7766907664085
        struct[0].Gy_ini[82,88] = -39.6392229058202
        struct[0].Gy_ini[82,89] = -10.2713736253513
        struct[0].Gy_ini[82,90] = 105.571769313180
        struct[0].Gy_ini[82,91] = 54.0657727682604
        struct[0].Gy_ini[82,92] = -39.6392229058201
        struct[0].Gy_ini[82,93] = -10.2713736253513
        struct[0].Gy_ini[82,94] = -24.9575997948692
        struct[0].Gy_ini[82,95] = -23.2849644809540
        struct[0].Gy_ini[82,152] = 30.9517475172273
        struct[0].Gy_ini[82,153] = 5.65456401516768
        struct[0].Gy_ini[82,154] = -9.21038227100566
        struct[0].Gy_ini[82,155] = 1.84896616921897
        struct[0].Gy_ini[83,16] = -1.84896616921897
        struct[0].Gy_ini[83,17] = -9.21038227100566
        struct[0].Gy_ini[83,18] = -0.793238195499528
        struct[0].Gy_ini[83,19] = -9.00835072044485
        struct[0].Gy_ini[83,72] = 10.2713736253513
        struct[0].Gy_ini[83,73] = -39.6392229058202
        struct[0].Gy_ini[83,74] = -54.0657727682604
        struct[0].Gy_ini[83,75] = 105.571769313180
        struct[0].Gy_ini[83,76] = 10.2713736253513
        struct[0].Gy_ini[83,77] = -39.6392229058201
        struct[0].Gy_ini[83,78] = 23.2849644809540
        struct[0].Gy_ini[83,79] = -24.9575997948692
        struct[0].Gy_ini[83,80] = -18.6937810814837
        struct[0].Gy_ini[83,81] = 88.4888280826460
        struct[0].Gy_ini[83,82] = 113.786109551688
        struct[0].Gy_ini[83,83] = -242.095286143588
        struct[0].Gy_ini[83,84] = -18.6937810814837
        struct[0].Gy_ini[83,85] = 88.4888280826460
        struct[0].Gy_ini[83,86] = -45.7766907664085
        struct[0].Gy_ini[83,87] = 58.9235503101833
        struct[0].Gy_ini[83,88] = 10.2713736253513
        struct[0].Gy_ini[83,89] = -39.6392229058202
        struct[0].Gy_ini[83,90] = -54.0657727682604
        struct[0].Gy_ini[83,91] = 105.571769313180
        struct[0].Gy_ini[83,92] = 10.2713736253513
        struct[0].Gy_ini[83,93] = -39.6392229058201
        struct[0].Gy_ini[83,94] = 23.2849644809540
        struct[0].Gy_ini[83,95] = -24.9575997948692
        struct[0].Gy_ini[83,152] = -5.65456401516768
        struct[0].Gy_ini[83,153] = 30.9517475172273
        struct[0].Gy_ini[83,154] = -1.84896616921897
        struct[0].Gy_ini[83,155] = -9.21038227100566
        struct[0].Gy_ini[84,16] = -9.00835072044484
        struct[0].Gy_ini[84,17] = 0.793238195499527
        struct[0].Gy_ini[84,18] = -9.21038227100566
        struct[0].Gy_ini[84,19] = 1.84896616921897
        struct[0].Gy_ini[84,72] = -24.9575997948692
        struct[0].Gy_ini[84,73] = -23.2849644809540
        struct[0].Gy_ini[84,74] = -39.6392229058202
        struct[0].Gy_ini[84,75] = -10.2713736253513
        struct[0].Gy_ini[84,76] = 105.571769313180
        struct[0].Gy_ini[84,77] = 54.0657727682604
        struct[0].Gy_ini[84,78] = -39.6392229058201
        struct[0].Gy_ini[84,79] = -10.2713736253514
        struct[0].Gy_ini[84,80] = 58.9235503101833
        struct[0].Gy_ini[84,81] = 45.7766907664085
        struct[0].Gy_ini[84,82] = 88.4888280826461
        struct[0].Gy_ini[84,83] = 18.6937810814837
        struct[0].Gy_ini[84,84] = -242.095286143588
        struct[0].Gy_ini[84,85] = -113.786109551688
        struct[0].Gy_ini[84,86] = 88.4888280826459
        struct[0].Gy_ini[84,87] = 18.6937810814837
        struct[0].Gy_ini[84,88] = -24.9575997948692
        struct[0].Gy_ini[84,89] = -23.2849644809540
        struct[0].Gy_ini[84,90] = -39.6392229058202
        struct[0].Gy_ini[84,91] = -10.2713736253513
        struct[0].Gy_ini[84,92] = 105.571769313180
        struct[0].Gy_ini[84,93] = 54.0657727682604
        struct[0].Gy_ini[84,94] = -39.6392229058201
        struct[0].Gy_ini[84,95] = -10.2713736253514
        struct[0].Gy_ini[84,152] = -9.21038227100566
        struct[0].Gy_ini[84,153] = 1.84896616921897
        struct[0].Gy_ini[84,154] = 30.9517475172273
        struct[0].Gy_ini[84,155] = 5.65456401516768
        struct[0].Gy_ini[85,16] = -0.793238195499527
        struct[0].Gy_ini[85,17] = -9.00835072044484
        struct[0].Gy_ini[85,18] = -1.84896616921897
        struct[0].Gy_ini[85,19] = -9.21038227100566
        struct[0].Gy_ini[85,72] = 23.2849644809540
        struct[0].Gy_ini[85,73] = -24.9575997948692
        struct[0].Gy_ini[85,74] = 10.2713736253513
        struct[0].Gy_ini[85,75] = -39.6392229058202
        struct[0].Gy_ini[85,76] = -54.0657727682604
        struct[0].Gy_ini[85,77] = 105.571769313180
        struct[0].Gy_ini[85,78] = 10.2713736253514
        struct[0].Gy_ini[85,79] = -39.6392229058201
        struct[0].Gy_ini[85,80] = -45.7766907664085
        struct[0].Gy_ini[85,81] = 58.9235503101833
        struct[0].Gy_ini[85,82] = -18.6937810814837
        struct[0].Gy_ini[85,83] = 88.4888280826461
        struct[0].Gy_ini[85,84] = 113.786109551688
        struct[0].Gy_ini[85,85] = -242.095286143588
        struct[0].Gy_ini[85,86] = -18.6937810814837
        struct[0].Gy_ini[85,87] = 88.4888280826459
        struct[0].Gy_ini[85,88] = 23.2849644809540
        struct[0].Gy_ini[85,89] = -24.9575997948692
        struct[0].Gy_ini[85,90] = 10.2713736253513
        struct[0].Gy_ini[85,91] = -39.6392229058202
        struct[0].Gy_ini[85,92] = -54.0657727682604
        struct[0].Gy_ini[85,93] = 105.571769313180
        struct[0].Gy_ini[85,94] = 10.2713736253514
        struct[0].Gy_ini[85,95] = -39.6392229058201
        struct[0].Gy_ini[85,152] = -1.84896616921897
        struct[0].Gy_ini[85,153] = -9.21038227100566
        struct[0].Gy_ini[85,154] = -5.65456401516768
        struct[0].Gy_ini[85,155] = 30.9517475172273
        struct[0].Gy_ini[86,16] = -9.21038227100566
        struct[0].Gy_ini[86,17] = 1.84896616921897
        struct[0].Gy_ini[86,18] = 30.9517475172273
        struct[0].Gy_ini[86,19] = 5.65456401516768
        struct[0].Gy_ini[86,72] = -39.6392229058202
        struct[0].Gy_ini[86,73] = -10.2713736253513
        struct[0].Gy_ini[86,74] = -24.9575997948692
        struct[0].Gy_ini[86,75] = -23.2849644809540
        struct[0].Gy_ini[86,76] = -39.6392229058202
        struct[0].Gy_ini[86,77] = -10.2713736253513
        struct[0].Gy_ini[86,78] = 105.571769313180
        struct[0].Gy_ini[86,79] = 54.0657727682604
        struct[0].Gy_ini[86,80] = 88.4888280826460
        struct[0].Gy_ini[86,81] = 18.6937810814837
        struct[0].Gy_ini[86,82] = 58.9235503101832
        struct[0].Gy_ini[86,83] = 45.7766907664085
        struct[0].Gy_ini[86,84] = 88.4888280826460
        struct[0].Gy_ini[86,85] = 18.6937810814837
        struct[0].Gy_ini[86,86] = -242.120286143588
        struct[0].Gy_ini[86,87] = -113.786109551688
        struct[0].Gy_ini[86,88] = -39.6392229058202
        struct[0].Gy_ini[86,89] = -10.2713736253513
        struct[0].Gy_ini[86,90] = -24.9575997948692
        struct[0].Gy_ini[86,91] = -23.2849644809540
        struct[0].Gy_ini[86,92] = -39.6392229058202
        struct[0].Gy_ini[86,93] = -10.2713736253513
        struct[0].Gy_ini[86,94] = 105.571769313180
        struct[0].Gy_ini[86,95] = 54.0657727682604
        struct[0].Gy_ini[86,152] = -9.00835072044485
        struct[0].Gy_ini[86,153] = 0.793238195499527
        struct[0].Gy_ini[86,154] = -9.21038227100566
        struct[0].Gy_ini[86,155] = 1.84896616921897
        struct[0].Gy_ini[87,16] = -1.84896616921897
        struct[0].Gy_ini[87,17] = -9.21038227100566
        struct[0].Gy_ini[87,18] = -5.65456401516768
        struct[0].Gy_ini[87,19] = 30.9517475172273
        struct[0].Gy_ini[87,72] = 10.2713736253513
        struct[0].Gy_ini[87,73] = -39.6392229058202
        struct[0].Gy_ini[87,74] = 23.2849644809540
        struct[0].Gy_ini[87,75] = -24.9575997948692
        struct[0].Gy_ini[87,76] = 10.2713736253513
        struct[0].Gy_ini[87,77] = -39.6392229058202
        struct[0].Gy_ini[87,78] = -54.0657727682604
        struct[0].Gy_ini[87,79] = 105.571769313180
        struct[0].Gy_ini[87,80] = -18.6937810814837
        struct[0].Gy_ini[87,81] = 88.4888280826460
        struct[0].Gy_ini[87,82] = -45.7766907664085
        struct[0].Gy_ini[87,83] = 58.9235503101832
        struct[0].Gy_ini[87,84] = -18.6937810814837
        struct[0].Gy_ini[87,85] = 88.4888280826460
        struct[0].Gy_ini[87,86] = 113.786109551688
        struct[0].Gy_ini[87,87] = -242.120286143588
        struct[0].Gy_ini[87,88] = 10.2713736253513
        struct[0].Gy_ini[87,89] = -39.6392229058202
        struct[0].Gy_ini[87,90] = 23.2849644809540
        struct[0].Gy_ini[87,91] = -24.9575997948692
        struct[0].Gy_ini[87,92] = 10.2713736253513
        struct[0].Gy_ini[87,93] = -39.6392229058202
        struct[0].Gy_ini[87,94] = -54.0657727682604
        struct[0].Gy_ini[87,95] = 105.571769313180
        struct[0].Gy_ini[87,152] = -0.793238195499527
        struct[0].Gy_ini[87,153] = -9.00835072044485
        struct[0].Gy_ini[87,154] = -1.84896616921897
        struct[0].Gy_ini[87,155] = -9.21038227100566
        struct[0].Gy_ini[88,80] = 105.571769313180
        struct[0].Gy_ini[88,81] = 54.0657727682604
        struct[0].Gy_ini[88,82] = -39.6392229058202
        struct[0].Gy_ini[88,83] = -10.2713736253513
        struct[0].Gy_ini[88,84] = -24.9575997948692
        struct[0].Gy_ini[88,85] = -23.2849644809540
        struct[0].Gy_ini[88,86] = -39.6392229058202
        struct[0].Gy_ini[88,87] = -10.2713736253513
        struct[0].Gy_ini[88,88] = -211.143538626360
        struct[0].Gy_ini[88,89] = -108.131545536521
        struct[0].Gy_ini[88,90] = 79.2784458116403
        struct[0].Gy_ini[88,91] = 20.5427472507027
        struct[0].Gy_ini[88,92] = 49.9151995897384
        struct[0].Gy_ini[88,93] = 46.5699289619080
        struct[0].Gy_ini[88,94] = 79.2784458116403
        struct[0].Gy_ini[88,95] = 20.5427472507027
        struct[0].Gy_ini[88,96] = 105.571769313180
        struct[0].Gy_ini[88,97] = 54.0657727682604
        struct[0].Gy_ini[88,98] = -39.6392229058202
        struct[0].Gy_ini[88,99] = -10.2713736253513
        struct[0].Gy_ini[88,100] = -24.9575997948692
        struct[0].Gy_ini[88,101] = -23.2849644809540
        struct[0].Gy_ini[88,102] = -39.6392229058202
        struct[0].Gy_ini[88,103] = -10.2713736253513
        struct[0].Gy_ini[89,80] = -54.0657727682604
        struct[0].Gy_ini[89,81] = 105.571769313180
        struct[0].Gy_ini[89,82] = 10.2713736253513
        struct[0].Gy_ini[89,83] = -39.6392229058202
        struct[0].Gy_ini[89,84] = 23.2849644809540
        struct[0].Gy_ini[89,85] = -24.9575997948692
        struct[0].Gy_ini[89,86] = 10.2713736253513
        struct[0].Gy_ini[89,87] = -39.6392229058202
        struct[0].Gy_ini[89,88] = 108.131545536521
        struct[0].Gy_ini[89,89] = -211.143538626360
        struct[0].Gy_ini[89,90] = -20.5427472507027
        struct[0].Gy_ini[89,91] = 79.2784458116403
        struct[0].Gy_ini[89,92] = -46.5699289619080
        struct[0].Gy_ini[89,93] = 49.9151995897384
        struct[0].Gy_ini[89,94] = -20.5427472507027
        struct[0].Gy_ini[89,95] = 79.2784458116403
        struct[0].Gy_ini[89,96] = -54.0657727682604
        struct[0].Gy_ini[89,97] = 105.571769313180
        struct[0].Gy_ini[89,98] = 10.2713736253513
        struct[0].Gy_ini[89,99] = -39.6392229058202
        struct[0].Gy_ini[89,100] = 23.2849644809540
        struct[0].Gy_ini[89,101] = -24.9575997948692
        struct[0].Gy_ini[89,102] = 10.2713736253513
        struct[0].Gy_ini[89,103] = -39.6392229058202
        struct[0].Gy_ini[90,80] = -39.6392229058202
        struct[0].Gy_ini[90,81] = -10.2713736253513
        struct[0].Gy_ini[90,82] = 105.571769313180
        struct[0].Gy_ini[90,83] = 54.0657727682604
        struct[0].Gy_ini[90,84] = -39.6392229058201
        struct[0].Gy_ini[90,85] = -10.2713736253513
        struct[0].Gy_ini[90,86] = -24.9575997948692
        struct[0].Gy_ini[90,87] = -23.2849644809540
        struct[0].Gy_ini[90,88] = 79.2784458116403
        struct[0].Gy_ini[90,89] = 20.5427472507027
        struct[0].Gy_ini[90,90] = -211.143538626360
        struct[0].Gy_ini[90,91] = -108.131545536521
        struct[0].Gy_ini[90,92] = 79.2784458116403
        struct[0].Gy_ini[90,93] = 20.5427472507027
        struct[0].Gy_ini[90,94] = 49.9151995897384
        struct[0].Gy_ini[90,95] = 46.5699289619080
        struct[0].Gy_ini[90,96] = -39.6392229058202
        struct[0].Gy_ini[90,97] = -10.2713736253513
        struct[0].Gy_ini[90,98] = 105.571769313180
        struct[0].Gy_ini[90,99] = 54.0657727682604
        struct[0].Gy_ini[90,100] = -39.6392229058201
        struct[0].Gy_ini[90,101] = -10.2713736253513
        struct[0].Gy_ini[90,102] = -24.9575997948692
        struct[0].Gy_ini[90,103] = -23.2849644809540
        struct[0].Gy_ini[91,80] = 10.2713736253513
        struct[0].Gy_ini[91,81] = -39.6392229058202
        struct[0].Gy_ini[91,82] = -54.0657727682604
        struct[0].Gy_ini[91,83] = 105.571769313180
        struct[0].Gy_ini[91,84] = 10.2713736253513
        struct[0].Gy_ini[91,85] = -39.6392229058201
        struct[0].Gy_ini[91,86] = 23.2849644809540
        struct[0].Gy_ini[91,87] = -24.9575997948692
        struct[0].Gy_ini[91,88] = -20.5427472507027
        struct[0].Gy_ini[91,89] = 79.2784458116403
        struct[0].Gy_ini[91,90] = 108.131545536521
        struct[0].Gy_ini[91,91] = -211.143538626360
        struct[0].Gy_ini[91,92] = -20.5427472507027
        struct[0].Gy_ini[91,93] = 79.2784458116403
        struct[0].Gy_ini[91,94] = -46.5699289619080
        struct[0].Gy_ini[91,95] = 49.9151995897384
        struct[0].Gy_ini[91,96] = 10.2713736253513
        struct[0].Gy_ini[91,97] = -39.6392229058202
        struct[0].Gy_ini[91,98] = -54.0657727682604
        struct[0].Gy_ini[91,99] = 105.571769313180
        struct[0].Gy_ini[91,100] = 10.2713736253513
        struct[0].Gy_ini[91,101] = -39.6392229058201
        struct[0].Gy_ini[91,102] = 23.2849644809540
        struct[0].Gy_ini[91,103] = -24.9575997948692
        struct[0].Gy_ini[92,80] = -24.9575997948692
        struct[0].Gy_ini[92,81] = -23.2849644809540
        struct[0].Gy_ini[92,82] = -39.6392229058202
        struct[0].Gy_ini[92,83] = -10.2713736253513
        struct[0].Gy_ini[92,84] = 105.571769313180
        struct[0].Gy_ini[92,85] = 54.0657727682604
        struct[0].Gy_ini[92,86] = -39.6392229058201
        struct[0].Gy_ini[92,87] = -10.2713736253514
        struct[0].Gy_ini[92,88] = 49.9151995897384
        struct[0].Gy_ini[92,89] = 46.5699289619080
        struct[0].Gy_ini[92,90] = 79.2784458116404
        struct[0].Gy_ini[92,91] = 20.5427472507027
        struct[0].Gy_ini[92,92] = -211.143538626360
        struct[0].Gy_ini[92,93] = -108.131545536521
        struct[0].Gy_ini[92,94] = 79.2784458116403
        struct[0].Gy_ini[92,95] = 20.5427472507027
        struct[0].Gy_ini[92,96] = -24.9575997948692
        struct[0].Gy_ini[92,97] = -23.2849644809540
        struct[0].Gy_ini[92,98] = -39.6392229058202
        struct[0].Gy_ini[92,99] = -10.2713736253513
        struct[0].Gy_ini[92,100] = 105.571769313180
        struct[0].Gy_ini[92,101] = 54.0657727682604
        struct[0].Gy_ini[92,102] = -39.6392229058201
        struct[0].Gy_ini[92,103] = -10.2713736253514
        struct[0].Gy_ini[93,80] = 23.2849644809540
        struct[0].Gy_ini[93,81] = -24.9575997948692
        struct[0].Gy_ini[93,82] = 10.2713736253513
        struct[0].Gy_ini[93,83] = -39.6392229058202
        struct[0].Gy_ini[93,84] = -54.0657727682604
        struct[0].Gy_ini[93,85] = 105.571769313180
        struct[0].Gy_ini[93,86] = 10.2713736253514
        struct[0].Gy_ini[93,87] = -39.6392229058201
        struct[0].Gy_ini[93,88] = -46.5699289619080
        struct[0].Gy_ini[93,89] = 49.9151995897384
        struct[0].Gy_ini[93,90] = -20.5427472507027
        struct[0].Gy_ini[93,91] = 79.2784458116404
        struct[0].Gy_ini[93,92] = 108.131545536521
        struct[0].Gy_ini[93,93] = -211.143538626360
        struct[0].Gy_ini[93,94] = -20.5427472507027
        struct[0].Gy_ini[93,95] = 79.2784458116403
        struct[0].Gy_ini[93,96] = 23.2849644809540
        struct[0].Gy_ini[93,97] = -24.9575997948692
        struct[0].Gy_ini[93,98] = 10.2713736253513
        struct[0].Gy_ini[93,99] = -39.6392229058202
        struct[0].Gy_ini[93,100] = -54.0657727682604
        struct[0].Gy_ini[93,101] = 105.571769313180
        struct[0].Gy_ini[93,102] = 10.2713736253514
        struct[0].Gy_ini[93,103] = -39.6392229058201
        struct[0].Gy_ini[94,80] = -39.6392229058202
        struct[0].Gy_ini[94,81] = -10.2713736253513
        struct[0].Gy_ini[94,82] = -24.9575997948692
        struct[0].Gy_ini[94,83] = -23.2849644809540
        struct[0].Gy_ini[94,84] = -39.6392229058202
        struct[0].Gy_ini[94,85] = -10.2713736253513
        struct[0].Gy_ini[94,86] = 105.571769313180
        struct[0].Gy_ini[94,87] = 54.0657727682604
        struct[0].Gy_ini[94,88] = 79.2784458116403
        struct[0].Gy_ini[94,89] = 20.5427472507027
        struct[0].Gy_ini[94,90] = 49.9151995897384
        struct[0].Gy_ini[94,91] = 46.5699289619080
        struct[0].Gy_ini[94,92] = 79.2784458116403
        struct[0].Gy_ini[94,93] = 20.5427472507027
        struct[0].Gy_ini[94,94] = -211.143538626360
        struct[0].Gy_ini[94,95] = -108.131545536521
        struct[0].Gy_ini[94,96] = -39.6392229058202
        struct[0].Gy_ini[94,97] = -10.2713736253513
        struct[0].Gy_ini[94,98] = -24.9575997948692
        struct[0].Gy_ini[94,99] = -23.2849644809540
        struct[0].Gy_ini[94,100] = -39.6392229058202
        struct[0].Gy_ini[94,101] = -10.2713736253513
        struct[0].Gy_ini[94,102] = 105.571769313180
        struct[0].Gy_ini[94,103] = 54.0657727682604
        struct[0].Gy_ini[95,80] = 10.2713736253513
        struct[0].Gy_ini[95,81] = -39.6392229058202
        struct[0].Gy_ini[95,82] = 23.2849644809540
        struct[0].Gy_ini[95,83] = -24.9575997948692
        struct[0].Gy_ini[95,84] = 10.2713736253513
        struct[0].Gy_ini[95,85] = -39.6392229058202
        struct[0].Gy_ini[95,86] = -54.0657727682604
        struct[0].Gy_ini[95,87] = 105.571769313180
        struct[0].Gy_ini[95,88] = -20.5427472507027
        struct[0].Gy_ini[95,89] = 79.2784458116403
        struct[0].Gy_ini[95,90] = -46.5699289619080
        struct[0].Gy_ini[95,91] = 49.9151995897384
        struct[0].Gy_ini[95,92] = -20.5427472507027
        struct[0].Gy_ini[95,93] = 79.2784458116403
        struct[0].Gy_ini[95,94] = 108.131545536521
        struct[0].Gy_ini[95,95] = -211.143538626360
        struct[0].Gy_ini[95,96] = 10.2713736253513
        struct[0].Gy_ini[95,97] = -39.6392229058202
        struct[0].Gy_ini[95,98] = 23.2849644809540
        struct[0].Gy_ini[95,99] = -24.9575997948692
        struct[0].Gy_ini[95,100] = 10.2713736253513
        struct[0].Gy_ini[95,101] = -39.6392229058202
        struct[0].Gy_ini[95,102] = -54.0657727682604
        struct[0].Gy_ini[95,103] = 105.571769313180
        struct[0].Gy_ini[96,88] = 105.571769313180
        struct[0].Gy_ini[96,89] = 54.0657727682604
        struct[0].Gy_ini[96,90] = -39.6392229058202
        struct[0].Gy_ini[96,91] = -10.2713736253513
        struct[0].Gy_ini[96,92] = -24.9575997948692
        struct[0].Gy_ini[96,93] = -23.2849644809540
        struct[0].Gy_ini[96,94] = -39.6392229058202
        struct[0].Gy_ini[96,95] = -10.2713736253513
        struct[0].Gy_ini[96,96] = -211.143538626360
        struct[0].Gy_ini[96,97] = -108.131545536521
        struct[0].Gy_ini[96,98] = 79.2784458116403
        struct[0].Gy_ini[96,99] = 20.5427472507027
        struct[0].Gy_ini[96,100] = 49.9151995897384
        struct[0].Gy_ini[96,101] = 46.5699289619080
        struct[0].Gy_ini[96,102] = 79.2784458116403
        struct[0].Gy_ini[96,103] = 20.5427472507027
        struct[0].Gy_ini[96,104] = 105.571769313180
        struct[0].Gy_ini[96,105] = 54.0657727682604
        struct[0].Gy_ini[96,106] = -39.6392229058202
        struct[0].Gy_ini[96,107] = -10.2713736253513
        struct[0].Gy_ini[96,108] = -24.9575997948692
        struct[0].Gy_ini[96,109] = -23.2849644809540
        struct[0].Gy_ini[96,110] = -39.6392229058202
        struct[0].Gy_ini[96,111] = -10.2713736253513
        struct[0].Gy_ini[97,88] = -54.0657727682604
        struct[0].Gy_ini[97,89] = 105.571769313180
        struct[0].Gy_ini[97,90] = 10.2713736253513
        struct[0].Gy_ini[97,91] = -39.6392229058202
        struct[0].Gy_ini[97,92] = 23.2849644809540
        struct[0].Gy_ini[97,93] = -24.9575997948692
        struct[0].Gy_ini[97,94] = 10.2713736253513
        struct[0].Gy_ini[97,95] = -39.6392229058202
        struct[0].Gy_ini[97,96] = 108.131545536521
        struct[0].Gy_ini[97,97] = -211.143538626360
        struct[0].Gy_ini[97,98] = -20.5427472507027
        struct[0].Gy_ini[97,99] = 79.2784458116403
        struct[0].Gy_ini[97,100] = -46.5699289619080
        struct[0].Gy_ini[97,101] = 49.9151995897384
        struct[0].Gy_ini[97,102] = -20.5427472507027
        struct[0].Gy_ini[97,103] = 79.2784458116403
        struct[0].Gy_ini[97,104] = -54.0657727682604
        struct[0].Gy_ini[97,105] = 105.571769313180
        struct[0].Gy_ini[97,106] = 10.2713736253513
        struct[0].Gy_ini[97,107] = -39.6392229058202
        struct[0].Gy_ini[97,108] = 23.2849644809540
        struct[0].Gy_ini[97,109] = -24.9575997948692
        struct[0].Gy_ini[97,110] = 10.2713736253513
        struct[0].Gy_ini[97,111] = -39.6392229058202
        struct[0].Gy_ini[98,88] = -39.6392229058202
        struct[0].Gy_ini[98,89] = -10.2713736253513
        struct[0].Gy_ini[98,90] = 105.571769313180
        struct[0].Gy_ini[98,91] = 54.0657727682604
        struct[0].Gy_ini[98,92] = -39.6392229058201
        struct[0].Gy_ini[98,93] = -10.2713736253513
        struct[0].Gy_ini[98,94] = -24.9575997948692
        struct[0].Gy_ini[98,95] = -23.2849644809540
        struct[0].Gy_ini[98,96] = 79.2784458116403
        struct[0].Gy_ini[98,97] = 20.5427472507027
        struct[0].Gy_ini[98,98] = -211.143538626360
        struct[0].Gy_ini[98,99] = -108.131545536521
        struct[0].Gy_ini[98,100] = 79.2784458116403
        struct[0].Gy_ini[98,101] = 20.5427472507027
        struct[0].Gy_ini[98,102] = 49.9151995897384
        struct[0].Gy_ini[98,103] = 46.5699289619080
        struct[0].Gy_ini[98,104] = -39.6392229058202
        struct[0].Gy_ini[98,105] = -10.2713736253513
        struct[0].Gy_ini[98,106] = 105.571769313180
        struct[0].Gy_ini[98,107] = 54.0657727682604
        struct[0].Gy_ini[98,108] = -39.6392229058201
        struct[0].Gy_ini[98,109] = -10.2713736253513
        struct[0].Gy_ini[98,110] = -24.9575997948692
        struct[0].Gy_ini[98,111] = -23.2849644809540
        struct[0].Gy_ini[99,88] = 10.2713736253513
        struct[0].Gy_ini[99,89] = -39.6392229058202
        struct[0].Gy_ini[99,90] = -54.0657727682604
        struct[0].Gy_ini[99,91] = 105.571769313180
        struct[0].Gy_ini[99,92] = 10.2713736253513
        struct[0].Gy_ini[99,93] = -39.6392229058201
        struct[0].Gy_ini[99,94] = 23.2849644809540
        struct[0].Gy_ini[99,95] = -24.9575997948692
        struct[0].Gy_ini[99,96] = -20.5427472507027
        struct[0].Gy_ini[99,97] = 79.2784458116403
        struct[0].Gy_ini[99,98] = 108.131545536521
        struct[0].Gy_ini[99,99] = -211.143538626360
        struct[0].Gy_ini[99,100] = -20.5427472507027
        struct[0].Gy_ini[99,101] = 79.2784458116403
        struct[0].Gy_ini[99,102] = -46.5699289619080
        struct[0].Gy_ini[99,103] = 49.9151995897384
        struct[0].Gy_ini[99,104] = 10.2713736253513
        struct[0].Gy_ini[99,105] = -39.6392229058202
        struct[0].Gy_ini[99,106] = -54.0657727682604
        struct[0].Gy_ini[99,107] = 105.571769313180
        struct[0].Gy_ini[99,108] = 10.2713736253513
        struct[0].Gy_ini[99,109] = -39.6392229058201
        struct[0].Gy_ini[99,110] = 23.2849644809540
        struct[0].Gy_ini[99,111] = -24.9575997948692
        struct[0].Gy_ini[100,88] = -24.9575997948692
        struct[0].Gy_ini[100,89] = -23.2849644809540
        struct[0].Gy_ini[100,90] = -39.6392229058202
        struct[0].Gy_ini[100,91] = -10.2713736253513
        struct[0].Gy_ini[100,92] = 105.571769313180
        struct[0].Gy_ini[100,93] = 54.0657727682604
        struct[0].Gy_ini[100,94] = -39.6392229058201
        struct[0].Gy_ini[100,95] = -10.2713736253514
        struct[0].Gy_ini[100,96] = 49.9151995897384
        struct[0].Gy_ini[100,97] = 46.5699289619080
        struct[0].Gy_ini[100,98] = 79.2784458116404
        struct[0].Gy_ini[100,99] = 20.5427472507027
        struct[0].Gy_ini[100,100] = -211.143538626360
        struct[0].Gy_ini[100,101] = -108.131545536521
        struct[0].Gy_ini[100,102] = 79.2784458116403
        struct[0].Gy_ini[100,103] = 20.5427472507027
        struct[0].Gy_ini[100,104] = -24.9575997948692
        struct[0].Gy_ini[100,105] = -23.2849644809540
        struct[0].Gy_ini[100,106] = -39.6392229058202
        struct[0].Gy_ini[100,107] = -10.2713736253513
        struct[0].Gy_ini[100,108] = 105.571769313180
        struct[0].Gy_ini[100,109] = 54.0657727682604
        struct[0].Gy_ini[100,110] = -39.6392229058201
        struct[0].Gy_ini[100,111] = -10.2713736253514
        struct[0].Gy_ini[101,88] = 23.2849644809540
        struct[0].Gy_ini[101,89] = -24.9575997948692
        struct[0].Gy_ini[101,90] = 10.2713736253513
        struct[0].Gy_ini[101,91] = -39.6392229058202
        struct[0].Gy_ini[101,92] = -54.0657727682604
        struct[0].Gy_ini[101,93] = 105.571769313180
        struct[0].Gy_ini[101,94] = 10.2713736253514
        struct[0].Gy_ini[101,95] = -39.6392229058201
        struct[0].Gy_ini[101,96] = -46.5699289619080
        struct[0].Gy_ini[101,97] = 49.9151995897384
        struct[0].Gy_ini[101,98] = -20.5427472507027
        struct[0].Gy_ini[101,99] = 79.2784458116404
        struct[0].Gy_ini[101,100] = 108.131545536521
        struct[0].Gy_ini[101,101] = -211.143538626360
        struct[0].Gy_ini[101,102] = -20.5427472507027
        struct[0].Gy_ini[101,103] = 79.2784458116403
        struct[0].Gy_ini[101,104] = 23.2849644809540
        struct[0].Gy_ini[101,105] = -24.9575997948692
        struct[0].Gy_ini[101,106] = 10.2713736253513
        struct[0].Gy_ini[101,107] = -39.6392229058202
        struct[0].Gy_ini[101,108] = -54.0657727682604
        struct[0].Gy_ini[101,109] = 105.571769313180
        struct[0].Gy_ini[101,110] = 10.2713736253514
        struct[0].Gy_ini[101,111] = -39.6392229058201
        struct[0].Gy_ini[102,88] = -39.6392229058202
        struct[0].Gy_ini[102,89] = -10.2713736253513
        struct[0].Gy_ini[102,90] = -24.9575997948692
        struct[0].Gy_ini[102,91] = -23.2849644809540
        struct[0].Gy_ini[102,92] = -39.6392229058202
        struct[0].Gy_ini[102,93] = -10.2713736253513
        struct[0].Gy_ini[102,94] = 105.571769313180
        struct[0].Gy_ini[102,95] = 54.0657727682604
        struct[0].Gy_ini[102,96] = 79.2784458116403
        struct[0].Gy_ini[102,97] = 20.5427472507027
        struct[0].Gy_ini[102,98] = 49.9151995897384
        struct[0].Gy_ini[102,99] = 46.5699289619080
        struct[0].Gy_ini[102,100] = 79.2784458116403
        struct[0].Gy_ini[102,101] = 20.5427472507027
        struct[0].Gy_ini[102,102] = -211.168538626360
        struct[0].Gy_ini[102,103] = -108.131545536521
        struct[0].Gy_ini[102,104] = -39.6392229058202
        struct[0].Gy_ini[102,105] = -10.2713736253513
        struct[0].Gy_ini[102,106] = -24.9575997948692
        struct[0].Gy_ini[102,107] = -23.2849644809540
        struct[0].Gy_ini[102,108] = -39.6392229058202
        struct[0].Gy_ini[102,109] = -10.2713736253513
        struct[0].Gy_ini[102,110] = 105.571769313180
        struct[0].Gy_ini[102,111] = 54.0657727682604
        struct[0].Gy_ini[103,88] = 10.2713736253513
        struct[0].Gy_ini[103,89] = -39.6392229058202
        struct[0].Gy_ini[103,90] = 23.2849644809540
        struct[0].Gy_ini[103,91] = -24.9575997948692
        struct[0].Gy_ini[103,92] = 10.2713736253513
        struct[0].Gy_ini[103,93] = -39.6392229058202
        struct[0].Gy_ini[103,94] = -54.0657727682604
        struct[0].Gy_ini[103,95] = 105.571769313180
        struct[0].Gy_ini[103,96] = -20.5427472507027
        struct[0].Gy_ini[103,97] = 79.2784458116403
        struct[0].Gy_ini[103,98] = -46.5699289619080
        struct[0].Gy_ini[103,99] = 49.9151995897384
        struct[0].Gy_ini[103,100] = -20.5427472507027
        struct[0].Gy_ini[103,101] = 79.2784458116403
        struct[0].Gy_ini[103,102] = 108.131545536521
        struct[0].Gy_ini[103,103] = -211.168538626360
        struct[0].Gy_ini[103,104] = 10.2713736253513
        struct[0].Gy_ini[103,105] = -39.6392229058202
        struct[0].Gy_ini[103,106] = 23.2849644809540
        struct[0].Gy_ini[103,107] = -24.9575997948692
        struct[0].Gy_ini[103,108] = 10.2713736253513
        struct[0].Gy_ini[103,109] = -39.6392229058202
        struct[0].Gy_ini[103,110] = -54.0657727682604
        struct[0].Gy_ini[103,111] = 105.571769313180
        struct[0].Gy_ini[104,20] = 30.9517475172273
        struct[0].Gy_ini[104,21] = 5.65456401516768
        struct[0].Gy_ini[104,22] = -9.21038227100566
        struct[0].Gy_ini[104,23] = 1.84896616921897
        struct[0].Gy_ini[104,96] = 105.571769313180
        struct[0].Gy_ini[104,97] = 54.0657727682604
        struct[0].Gy_ini[104,98] = -39.6392229058202
        struct[0].Gy_ini[104,99] = -10.2713736253513
        struct[0].Gy_ini[104,100] = -24.9575997948692
        struct[0].Gy_ini[104,101] = -23.2849644809540
        struct[0].Gy_ini[104,102] = -39.6392229058202
        struct[0].Gy_ini[104,103] = -10.2713736253513
        struct[0].Gy_ini[104,104] = -242.095286143588
        struct[0].Gy_ini[104,105] = -113.786109551688
        struct[0].Gy_ini[104,106] = 88.4888280826460
        struct[0].Gy_ini[104,107] = 18.6937810814837
        struct[0].Gy_ini[104,108] = 58.9235503101833
        struct[0].Gy_ini[104,109] = 45.7766907664085
        struct[0].Gy_ini[104,110] = 88.4888280826460
        struct[0].Gy_ini[104,111] = 18.6937810814837
        struct[0].Gy_ini[104,112] = 105.571769313180
        struct[0].Gy_ini[104,113] = 54.0657727682604
        struct[0].Gy_ini[104,114] = -39.6392229058202
        struct[0].Gy_ini[104,115] = -10.2713736253513
        struct[0].Gy_ini[104,116] = -24.9575997948692
        struct[0].Gy_ini[104,117] = -23.2849644809540
        struct[0].Gy_ini[104,118] = -39.6392229058202
        struct[0].Gy_ini[104,119] = -10.2713736253513
        struct[0].Gy_ini[104,156] = -9.21038227100566
        struct[0].Gy_ini[104,157] = 1.84896616921897
        struct[0].Gy_ini[104,158] = -9.00835072044485
        struct[0].Gy_ini[104,159] = 0.793238195499529
        struct[0].Gy_ini[105,20] = -5.65456401516768
        struct[0].Gy_ini[105,21] = 30.9517475172273
        struct[0].Gy_ini[105,22] = -1.84896616921897
        struct[0].Gy_ini[105,23] = -9.21038227100566
        struct[0].Gy_ini[105,96] = -54.0657727682604
        struct[0].Gy_ini[105,97] = 105.571769313180
        struct[0].Gy_ini[105,98] = 10.2713736253513
        struct[0].Gy_ini[105,99] = -39.6392229058202
        struct[0].Gy_ini[105,100] = 23.2849644809540
        struct[0].Gy_ini[105,101] = -24.9575997948692
        struct[0].Gy_ini[105,102] = 10.2713736253513
        struct[0].Gy_ini[105,103] = -39.6392229058202
        struct[0].Gy_ini[105,104] = 113.786109551688
        struct[0].Gy_ini[105,105] = -242.095286143588
        struct[0].Gy_ini[105,106] = -18.6937810814837
        struct[0].Gy_ini[105,107] = 88.4888280826460
        struct[0].Gy_ini[105,108] = -45.7766907664085
        struct[0].Gy_ini[105,109] = 58.9235503101833
        struct[0].Gy_ini[105,110] = -18.6937810814837
        struct[0].Gy_ini[105,111] = 88.4888280826460
        struct[0].Gy_ini[105,112] = -54.0657727682604
        struct[0].Gy_ini[105,113] = 105.571769313180
        struct[0].Gy_ini[105,114] = 10.2713736253513
        struct[0].Gy_ini[105,115] = -39.6392229058202
        struct[0].Gy_ini[105,116] = 23.2849644809540
        struct[0].Gy_ini[105,117] = -24.9575997948692
        struct[0].Gy_ini[105,118] = 10.2713736253513
        struct[0].Gy_ini[105,119] = -39.6392229058202
        struct[0].Gy_ini[105,156] = -1.84896616921897
        struct[0].Gy_ini[105,157] = -9.21038227100566
        struct[0].Gy_ini[105,158] = -0.793238195499529
        struct[0].Gy_ini[105,159] = -9.00835072044485
        struct[0].Gy_ini[106,20] = -9.21038227100566
        struct[0].Gy_ini[106,21] = 1.84896616921897
        struct[0].Gy_ini[106,22] = -9.00835072044485
        struct[0].Gy_ini[106,23] = 0.793238195499528
        struct[0].Gy_ini[106,96] = -39.6392229058202
        struct[0].Gy_ini[106,97] = -10.2713736253513
        struct[0].Gy_ini[106,98] = 105.571769313180
        struct[0].Gy_ini[106,99] = 54.0657727682604
        struct[0].Gy_ini[106,100] = -39.6392229058201
        struct[0].Gy_ini[106,101] = -10.2713736253513
        struct[0].Gy_ini[106,102] = -24.9575997948692
        struct[0].Gy_ini[106,103] = -23.2849644809540
        struct[0].Gy_ini[106,104] = 88.4888280826460
        struct[0].Gy_ini[106,105] = 18.6937810814837
        struct[0].Gy_ini[106,106] = -242.095286143588
        struct[0].Gy_ini[106,107] = -113.786109551688
        struct[0].Gy_ini[106,108] = 88.4888280826460
        struct[0].Gy_ini[106,109] = 18.6937810814837
        struct[0].Gy_ini[106,110] = 58.9235503101833
        struct[0].Gy_ini[106,111] = 45.7766907664085
        struct[0].Gy_ini[106,112] = -39.6392229058202
        struct[0].Gy_ini[106,113] = -10.2713736253513
        struct[0].Gy_ini[106,114] = 105.571769313180
        struct[0].Gy_ini[106,115] = 54.0657727682604
        struct[0].Gy_ini[106,116] = -39.6392229058201
        struct[0].Gy_ini[106,117] = -10.2713736253513
        struct[0].Gy_ini[106,118] = -24.9575997948692
        struct[0].Gy_ini[106,119] = -23.2849644809540
        struct[0].Gy_ini[106,156] = 30.9517475172273
        struct[0].Gy_ini[106,157] = 5.65456401516768
        struct[0].Gy_ini[106,158] = -9.21038227100566
        struct[0].Gy_ini[106,159] = 1.84896616921897
        struct[0].Gy_ini[107,20] = -1.84896616921897
        struct[0].Gy_ini[107,21] = -9.21038227100566
        struct[0].Gy_ini[107,22] = -0.793238195499528
        struct[0].Gy_ini[107,23] = -9.00835072044485
        struct[0].Gy_ini[107,96] = 10.2713736253513
        struct[0].Gy_ini[107,97] = -39.6392229058202
        struct[0].Gy_ini[107,98] = -54.0657727682604
        struct[0].Gy_ini[107,99] = 105.571769313180
        struct[0].Gy_ini[107,100] = 10.2713736253513
        struct[0].Gy_ini[107,101] = -39.6392229058201
        struct[0].Gy_ini[107,102] = 23.2849644809540
        struct[0].Gy_ini[107,103] = -24.9575997948692
        struct[0].Gy_ini[107,104] = -18.6937810814837
        struct[0].Gy_ini[107,105] = 88.4888280826460
        struct[0].Gy_ini[107,106] = 113.786109551688
        struct[0].Gy_ini[107,107] = -242.095286143588
        struct[0].Gy_ini[107,108] = -18.6937810814837
        struct[0].Gy_ini[107,109] = 88.4888280826460
        struct[0].Gy_ini[107,110] = -45.7766907664085
        struct[0].Gy_ini[107,111] = 58.9235503101833
        struct[0].Gy_ini[107,112] = 10.2713736253513
        struct[0].Gy_ini[107,113] = -39.6392229058202
        struct[0].Gy_ini[107,114] = -54.0657727682604
        struct[0].Gy_ini[107,115] = 105.571769313180
        struct[0].Gy_ini[107,116] = 10.2713736253513
        struct[0].Gy_ini[107,117] = -39.6392229058201
        struct[0].Gy_ini[107,118] = 23.2849644809540
        struct[0].Gy_ini[107,119] = -24.9575997948692
        struct[0].Gy_ini[107,156] = -5.65456401516768
        struct[0].Gy_ini[107,157] = 30.9517475172273
        struct[0].Gy_ini[107,158] = -1.84896616921897
        struct[0].Gy_ini[107,159] = -9.21038227100566
        struct[0].Gy_ini[108,20] = -9.00835072044484
        struct[0].Gy_ini[108,21] = 0.793238195499527
        struct[0].Gy_ini[108,22] = -9.21038227100566
        struct[0].Gy_ini[108,23] = 1.84896616921897
        struct[0].Gy_ini[108,96] = -24.9575997948692
        struct[0].Gy_ini[108,97] = -23.2849644809540
        struct[0].Gy_ini[108,98] = -39.6392229058202
        struct[0].Gy_ini[108,99] = -10.2713736253513
        struct[0].Gy_ini[108,100] = 105.571769313180
        struct[0].Gy_ini[108,101] = 54.0657727682604
        struct[0].Gy_ini[108,102] = -39.6392229058201
        struct[0].Gy_ini[108,103] = -10.2713736253514
        struct[0].Gy_ini[108,104] = 58.9235503101833
        struct[0].Gy_ini[108,105] = 45.7766907664085
        struct[0].Gy_ini[108,106] = 88.4888280826461
        struct[0].Gy_ini[108,107] = 18.6937810814837
        struct[0].Gy_ini[108,108] = -242.095286143588
        struct[0].Gy_ini[108,109] = -113.786109551688
        struct[0].Gy_ini[108,110] = 88.4888280826459
        struct[0].Gy_ini[108,111] = 18.6937810814837
        struct[0].Gy_ini[108,112] = -24.9575997948692
        struct[0].Gy_ini[108,113] = -23.2849644809540
        struct[0].Gy_ini[108,114] = -39.6392229058202
        struct[0].Gy_ini[108,115] = -10.2713736253513
        struct[0].Gy_ini[108,116] = 105.571769313180
        struct[0].Gy_ini[108,117] = 54.0657727682604
        struct[0].Gy_ini[108,118] = -39.6392229058201
        struct[0].Gy_ini[108,119] = -10.2713736253514
        struct[0].Gy_ini[108,156] = -9.21038227100566
        struct[0].Gy_ini[108,157] = 1.84896616921897
        struct[0].Gy_ini[108,158] = 30.9517475172273
        struct[0].Gy_ini[108,159] = 5.65456401516768
        struct[0].Gy_ini[109,20] = -0.793238195499527
        struct[0].Gy_ini[109,21] = -9.00835072044484
        struct[0].Gy_ini[109,22] = -1.84896616921897
        struct[0].Gy_ini[109,23] = -9.21038227100566
        struct[0].Gy_ini[109,96] = 23.2849644809540
        struct[0].Gy_ini[109,97] = -24.9575997948692
        struct[0].Gy_ini[109,98] = 10.2713736253513
        struct[0].Gy_ini[109,99] = -39.6392229058202
        struct[0].Gy_ini[109,100] = -54.0657727682604
        struct[0].Gy_ini[109,101] = 105.571769313180
        struct[0].Gy_ini[109,102] = 10.2713736253514
        struct[0].Gy_ini[109,103] = -39.6392229058201
        struct[0].Gy_ini[109,104] = -45.7766907664085
        struct[0].Gy_ini[109,105] = 58.9235503101833
        struct[0].Gy_ini[109,106] = -18.6937810814837
        struct[0].Gy_ini[109,107] = 88.4888280826461
        struct[0].Gy_ini[109,108] = 113.786109551688
        struct[0].Gy_ini[109,109] = -242.095286143588
        struct[0].Gy_ini[109,110] = -18.6937810814837
        struct[0].Gy_ini[109,111] = 88.4888280826459
        struct[0].Gy_ini[109,112] = 23.2849644809540
        struct[0].Gy_ini[109,113] = -24.9575997948692
        struct[0].Gy_ini[109,114] = 10.2713736253513
        struct[0].Gy_ini[109,115] = -39.6392229058202
        struct[0].Gy_ini[109,116] = -54.0657727682604
        struct[0].Gy_ini[109,117] = 105.571769313180
        struct[0].Gy_ini[109,118] = 10.2713736253514
        struct[0].Gy_ini[109,119] = -39.6392229058201
        struct[0].Gy_ini[109,156] = -1.84896616921897
        struct[0].Gy_ini[109,157] = -9.21038227100566
        struct[0].Gy_ini[109,158] = -5.65456401516768
        struct[0].Gy_ini[109,159] = 30.9517475172273
        struct[0].Gy_ini[110,20] = -9.21038227100566
        struct[0].Gy_ini[110,21] = 1.84896616921897
        struct[0].Gy_ini[110,22] = 30.9517475172273
        struct[0].Gy_ini[110,23] = 5.65456401516768
        struct[0].Gy_ini[110,96] = -39.6392229058202
        struct[0].Gy_ini[110,97] = -10.2713736253513
        struct[0].Gy_ini[110,98] = -24.9575997948692
        struct[0].Gy_ini[110,99] = -23.2849644809540
        struct[0].Gy_ini[110,100] = -39.6392229058202
        struct[0].Gy_ini[110,101] = -10.2713736253513
        struct[0].Gy_ini[110,102] = 105.571769313180
        struct[0].Gy_ini[110,103] = 54.0657727682604
        struct[0].Gy_ini[110,104] = 88.4888280826460
        struct[0].Gy_ini[110,105] = 18.6937810814837
        struct[0].Gy_ini[110,106] = 58.9235503101832
        struct[0].Gy_ini[110,107] = 45.7766907664085
        struct[0].Gy_ini[110,108] = 88.4888280826460
        struct[0].Gy_ini[110,109] = 18.6937810814837
        struct[0].Gy_ini[110,110] = -242.095286143588
        struct[0].Gy_ini[110,111] = -113.786109551688
        struct[0].Gy_ini[110,112] = -39.6392229058202
        struct[0].Gy_ini[110,113] = -10.2713736253513
        struct[0].Gy_ini[110,114] = -24.9575997948692
        struct[0].Gy_ini[110,115] = -23.2849644809540
        struct[0].Gy_ini[110,116] = -39.6392229058202
        struct[0].Gy_ini[110,117] = -10.2713736253513
        struct[0].Gy_ini[110,118] = 105.571769313180
        struct[0].Gy_ini[110,119] = 54.0657727682604
        struct[0].Gy_ini[110,156] = -9.00835072044485
        struct[0].Gy_ini[110,157] = 0.793238195499527
        struct[0].Gy_ini[110,158] = -9.21038227100566
        struct[0].Gy_ini[110,159] = 1.84896616921897
        struct[0].Gy_ini[111,20] = -1.84896616921897
        struct[0].Gy_ini[111,21] = -9.21038227100566
        struct[0].Gy_ini[111,22] = -5.65456401516768
        struct[0].Gy_ini[111,23] = 30.9517475172273
        struct[0].Gy_ini[111,96] = 10.2713736253513
        struct[0].Gy_ini[111,97] = -39.6392229058202
        struct[0].Gy_ini[111,98] = 23.2849644809540
        struct[0].Gy_ini[111,99] = -24.9575997948692
        struct[0].Gy_ini[111,100] = 10.2713736253513
        struct[0].Gy_ini[111,101] = -39.6392229058202
        struct[0].Gy_ini[111,102] = -54.0657727682604
        struct[0].Gy_ini[111,103] = 105.571769313180
        struct[0].Gy_ini[111,104] = -18.6937810814837
        struct[0].Gy_ini[111,105] = 88.4888280826460
        struct[0].Gy_ini[111,106] = -45.7766907664085
        struct[0].Gy_ini[111,107] = 58.9235503101832
        struct[0].Gy_ini[111,108] = -18.6937810814837
        struct[0].Gy_ini[111,109] = 88.4888280826460
        struct[0].Gy_ini[111,110] = 113.786109551688
        struct[0].Gy_ini[111,111] = -242.095286143588
        struct[0].Gy_ini[111,112] = 10.2713736253513
        struct[0].Gy_ini[111,113] = -39.6392229058202
        struct[0].Gy_ini[111,114] = 23.2849644809540
        struct[0].Gy_ini[111,115] = -24.9575997948692
        struct[0].Gy_ini[111,116] = 10.2713736253513
        struct[0].Gy_ini[111,117] = -39.6392229058202
        struct[0].Gy_ini[111,118] = -54.0657727682604
        struct[0].Gy_ini[111,119] = 105.571769313180
        struct[0].Gy_ini[111,156] = -0.793238195499527
        struct[0].Gy_ini[111,157] = -9.00835072044485
        struct[0].Gy_ini[111,158] = -1.84896616921897
        struct[0].Gy_ini[111,159] = -9.21038227100566
        struct[0].Gy_ini[112,24] = 30.9517475172273
        struct[0].Gy_ini[112,25] = 5.65456401516768
        struct[0].Gy_ini[112,26] = -9.21038227100566
        struct[0].Gy_ini[112,27] = 1.84896616921897
        struct[0].Gy_ini[112,104] = 105.571769313180
        struct[0].Gy_ini[112,105] = 54.0657727682604
        struct[0].Gy_ini[112,106] = -39.6392229058202
        struct[0].Gy_ini[112,107] = -10.2713736253513
        struct[0].Gy_ini[112,108] = -24.9575997948692
        struct[0].Gy_ini[112,109] = -23.2849644809540
        struct[0].Gy_ini[112,110] = -39.6392229058202
        struct[0].Gy_ini[112,111] = -10.2713736253513
        struct[0].Gy_ini[112,112] = -136.523516830407
        struct[0].Gy_ini[112,113] = -59.7203367834281
        struct[0].Gy_ini[112,114] = 48.8496051768258
        struct[0].Gy_ini[112,115] = 8.42240745613237
        struct[0].Gy_ini[112,116] = 33.9659505153141
        struct[0].Gy_ini[112,117] = 22.4917262854545
        struct[0].Gy_ini[112,118] = 48.8496051768258
        struct[0].Gy_ini[112,119] = 8.42240745613237
        struct[0].Gy_ini[112,160] = -9.21038227100566
        struct[0].Gy_ini[112,161] = 1.84896616921897
        struct[0].Gy_ini[112,162] = -9.00835072044485
        struct[0].Gy_ini[112,163] = 0.793238195499529
        struct[0].Gy_ini[112,393] = 1
        struct[0].Gy_ini[113,24] = -5.65456401516768
        struct[0].Gy_ini[113,25] = 30.9517475172273
        struct[0].Gy_ini[113,26] = -1.84896616921897
        struct[0].Gy_ini[113,27] = -9.21038227100566
        struct[0].Gy_ini[113,104] = -54.0657727682604
        struct[0].Gy_ini[113,105] = 105.571769313180
        struct[0].Gy_ini[113,106] = 10.2713736253513
        struct[0].Gy_ini[113,107] = -39.6392229058202
        struct[0].Gy_ini[113,108] = 23.2849644809540
        struct[0].Gy_ini[113,109] = -24.9575997948692
        struct[0].Gy_ini[113,110] = 10.2713736253513
        struct[0].Gy_ini[113,111] = -39.6392229058202
        struct[0].Gy_ini[113,112] = 59.7203367834281
        struct[0].Gy_ini[113,113] = -136.523516830407
        struct[0].Gy_ini[113,114] = -8.42240745613237
        struct[0].Gy_ini[113,115] = 48.8496051768258
        struct[0].Gy_ini[113,116] = -22.4917262854545
        struct[0].Gy_ini[113,117] = 33.9659505153141
        struct[0].Gy_ini[113,118] = -8.42240745613237
        struct[0].Gy_ini[113,119] = 48.8496051768258
        struct[0].Gy_ini[113,160] = -1.84896616921897
        struct[0].Gy_ini[113,161] = -9.21038227100566
        struct[0].Gy_ini[113,162] = -0.793238195499529
        struct[0].Gy_ini[113,163] = -9.00835072044485
        struct[0].Gy_ini[113,394] = 1
        struct[0].Gy_ini[114,24] = -9.21038227100566
        struct[0].Gy_ini[114,25] = 1.84896616921897
        struct[0].Gy_ini[114,26] = -9.00835072044485
        struct[0].Gy_ini[114,27] = 0.793238195499528
        struct[0].Gy_ini[114,104] = -39.6392229058202
        struct[0].Gy_ini[114,105] = -10.2713736253513
        struct[0].Gy_ini[114,106] = 105.571769313180
        struct[0].Gy_ini[114,107] = 54.0657727682604
        struct[0].Gy_ini[114,108] = -39.6392229058201
        struct[0].Gy_ini[114,109] = -10.2713736253513
        struct[0].Gy_ini[114,110] = -24.9575997948692
        struct[0].Gy_ini[114,111] = -23.2849644809540
        struct[0].Gy_ini[114,112] = 48.8496051768258
        struct[0].Gy_ini[114,113] = 8.42240745613237
        struct[0].Gy_ini[114,114] = -136.523516830407
        struct[0].Gy_ini[114,115] = -59.7203367834280
        struct[0].Gy_ini[114,116] = 48.8496051768258
        struct[0].Gy_ini[114,117] = 8.42240745613238
        struct[0].Gy_ini[114,118] = 33.9659505153141
        struct[0].Gy_ini[114,119] = 22.4917262854545
        struct[0].Gy_ini[114,160] = 30.9517475172273
        struct[0].Gy_ini[114,161] = 5.65456401516768
        struct[0].Gy_ini[114,162] = -9.21038227100566
        struct[0].Gy_ini[114,163] = 1.84896616921897
        struct[0].Gy_ini[114,395] = 1
        struct[0].Gy_ini[115,24] = -1.84896616921897
        struct[0].Gy_ini[115,25] = -9.21038227100566
        struct[0].Gy_ini[115,26] = -0.793238195499528
        struct[0].Gy_ini[115,27] = -9.00835072044485
        struct[0].Gy_ini[115,104] = 10.2713736253513
        struct[0].Gy_ini[115,105] = -39.6392229058202
        struct[0].Gy_ini[115,106] = -54.0657727682604
        struct[0].Gy_ini[115,107] = 105.571769313180
        struct[0].Gy_ini[115,108] = 10.2713736253513
        struct[0].Gy_ini[115,109] = -39.6392229058201
        struct[0].Gy_ini[115,110] = 23.2849644809540
        struct[0].Gy_ini[115,111] = -24.9575997948692
        struct[0].Gy_ini[115,112] = -8.42240745613237
        struct[0].Gy_ini[115,113] = 48.8496051768258
        struct[0].Gy_ini[115,114] = 59.7203367834280
        struct[0].Gy_ini[115,115] = -136.523516830407
        struct[0].Gy_ini[115,116] = -8.42240745613238
        struct[0].Gy_ini[115,117] = 48.8496051768258
        struct[0].Gy_ini[115,118] = -22.4917262854545
        struct[0].Gy_ini[115,119] = 33.9659505153141
        struct[0].Gy_ini[115,160] = -5.65456401516768
        struct[0].Gy_ini[115,161] = 30.9517475172273
        struct[0].Gy_ini[115,162] = -1.84896616921897
        struct[0].Gy_ini[115,163] = -9.21038227100566
        struct[0].Gy_ini[115,396] = 1
        struct[0].Gy_ini[116,24] = -9.00835072044484
        struct[0].Gy_ini[116,25] = 0.793238195499527
        struct[0].Gy_ini[116,26] = -9.21038227100566
        struct[0].Gy_ini[116,27] = 1.84896616921897
        struct[0].Gy_ini[116,104] = -24.9575997948692
        struct[0].Gy_ini[116,105] = -23.2849644809540
        struct[0].Gy_ini[116,106] = -39.6392229058202
        struct[0].Gy_ini[116,107] = -10.2713736253513
        struct[0].Gy_ini[116,108] = 105.571769313180
        struct[0].Gy_ini[116,109] = 54.0657727682604
        struct[0].Gy_ini[116,110] = -39.6392229058201
        struct[0].Gy_ini[116,111] = -10.2713736253514
        struct[0].Gy_ini[116,112] = 33.9659505153141
        struct[0].Gy_ini[116,113] = 22.4917262854545
        struct[0].Gy_ini[116,114] = 48.8496051768259
        struct[0].Gy_ini[116,115] = 8.42240745613236
        struct[0].Gy_ini[116,116] = -136.523516830407
        struct[0].Gy_ini[116,117] = -59.7203367834281
        struct[0].Gy_ini[116,118] = 48.8496051768258
        struct[0].Gy_ini[116,119] = 8.42240745613239
        struct[0].Gy_ini[116,160] = -9.21038227100566
        struct[0].Gy_ini[116,161] = 1.84896616921897
        struct[0].Gy_ini[116,162] = 30.9517475172273
        struct[0].Gy_ini[116,163] = 5.65456401516768
        struct[0].Gy_ini[116,397] = 1
        struct[0].Gy_ini[117,24] = -0.793238195499527
        struct[0].Gy_ini[117,25] = -9.00835072044484
        struct[0].Gy_ini[117,26] = -1.84896616921897
        struct[0].Gy_ini[117,27] = -9.21038227100566
        struct[0].Gy_ini[117,104] = 23.2849644809540
        struct[0].Gy_ini[117,105] = -24.9575997948692
        struct[0].Gy_ini[117,106] = 10.2713736253513
        struct[0].Gy_ini[117,107] = -39.6392229058202
        struct[0].Gy_ini[117,108] = -54.0657727682604
        struct[0].Gy_ini[117,109] = 105.571769313180
        struct[0].Gy_ini[117,110] = 10.2713736253514
        struct[0].Gy_ini[117,111] = -39.6392229058201
        struct[0].Gy_ini[117,112] = -22.4917262854545
        struct[0].Gy_ini[117,113] = 33.9659505153141
        struct[0].Gy_ini[117,114] = -8.42240745613236
        struct[0].Gy_ini[117,115] = 48.8496051768259
        struct[0].Gy_ini[117,116] = 59.7203367834281
        struct[0].Gy_ini[117,117] = -136.523516830407
        struct[0].Gy_ini[117,118] = -8.42240745613239
        struct[0].Gy_ini[117,119] = 48.8496051768258
        struct[0].Gy_ini[117,160] = -1.84896616921897
        struct[0].Gy_ini[117,161] = -9.21038227100566
        struct[0].Gy_ini[117,162] = -5.65456401516768
        struct[0].Gy_ini[117,163] = 30.9517475172273
        struct[0].Gy_ini[117,398] = 1
        struct[0].Gy_ini[118,24] = -9.21038227100566
        struct[0].Gy_ini[118,25] = 1.84896616921897
        struct[0].Gy_ini[118,26] = 30.9517475172273
        struct[0].Gy_ini[118,27] = 5.65456401516768
        struct[0].Gy_ini[118,104] = -39.6392229058202
        struct[0].Gy_ini[118,105] = -10.2713736253513
        struct[0].Gy_ini[118,106] = -24.9575997948692
        struct[0].Gy_ini[118,107] = -23.2849644809540
        struct[0].Gy_ini[118,108] = -39.6392229058202
        struct[0].Gy_ini[118,109] = -10.2713736253513
        struct[0].Gy_ini[118,110] = 105.571769313180
        struct[0].Gy_ini[118,111] = 54.0657727682604
        struct[0].Gy_ini[118,112] = 48.8496051768258
        struct[0].Gy_ini[118,113] = 8.42240745613237
        struct[0].Gy_ini[118,114] = 33.9659505153140
        struct[0].Gy_ini[118,115] = 22.4917262854545
        struct[0].Gy_ini[118,116] = 48.8496051768258
        struct[0].Gy_ini[118,117] = 8.42240745613237
        struct[0].Gy_ini[118,118] = -136.548516830407
        struct[0].Gy_ini[118,119] = -59.7203367834281
        struct[0].Gy_ini[118,160] = -9.00835072044485
        struct[0].Gy_ini[118,161] = 0.793238195499527
        struct[0].Gy_ini[118,162] = -9.21038227100566
        struct[0].Gy_ini[118,163] = 1.84896616921897
        struct[0].Gy_ini[118,399] = 1
        struct[0].Gy_ini[119,24] = -1.84896616921897
        struct[0].Gy_ini[119,25] = -9.21038227100566
        struct[0].Gy_ini[119,26] = -5.65456401516768
        struct[0].Gy_ini[119,27] = 30.9517475172273
        struct[0].Gy_ini[119,104] = 10.2713736253513
        struct[0].Gy_ini[119,105] = -39.6392229058202
        struct[0].Gy_ini[119,106] = 23.2849644809540
        struct[0].Gy_ini[119,107] = -24.9575997948692
        struct[0].Gy_ini[119,108] = 10.2713736253513
        struct[0].Gy_ini[119,109] = -39.6392229058202
        struct[0].Gy_ini[119,110] = -54.0657727682604
        struct[0].Gy_ini[119,111] = 105.571769313180
        struct[0].Gy_ini[119,112] = -8.42240745613237
        struct[0].Gy_ini[119,113] = 48.8496051768258
        struct[0].Gy_ini[119,114] = -22.4917262854545
        struct[0].Gy_ini[119,115] = 33.9659505153140
        struct[0].Gy_ini[119,116] = -8.42240745613237
        struct[0].Gy_ini[119,117] = 48.8496051768258
        struct[0].Gy_ini[119,118] = 59.7203367834281
        struct[0].Gy_ini[119,119] = -136.548516830407
        struct[0].Gy_ini[119,160] = -0.793238195499527
        struct[0].Gy_ini[119,161] = -9.00835072044485
        struct[0].Gy_ini[119,162] = -1.84896616921897
        struct[0].Gy_ini[119,163] = -9.21038227100566
        struct[0].Gy_ini[119,400] = 1
        struct[0].Gy_ini[120,8] = 7.89461337514771
        struct[0].Gy_ini[120,9] = -1.58482814504483
        struct[0].Gy_ini[120,10] = 7.72144347466701
        struct[0].Gy_ini[120,11] = -0.679918453285308
        struct[0].Gy_ini[120,56] = -7.89461337514771
        struct[0].Gy_ini[120,57] = 1.58482814504483
        struct[0].Gy_ini[120,58] = 26.5300693004806
        struct[0].Gy_ini[120,59] = 4.84676915585801
        struct[0].Gy_ini[120,60] = -7.89461337514771
        struct[0].Gy_ini[120,61] = 1.58482814504483
        struct[0].Gy_ini[120,62] = -7.72144347466701
        struct[0].Gy_ini[120,63] = 0.679918453285308
        struct[0].Gy_ini[120,120] = -26.5300693004806
        struct[0].Gy_ini[120,121] = -4.84676915585801
        struct[0].Gy_ini[120,122] = 7.89461337514771
        struct[0].Gy_ini[120,123] = -1.58482814504483
        struct[0].Gy_ini[121,8] = 1.58482814504483
        struct[0].Gy_ini[121,9] = 7.89461337514771
        struct[0].Gy_ini[121,10] = 0.679918453285308
        struct[0].Gy_ini[121,11] = 7.72144347466701
        struct[0].Gy_ini[121,56] = -1.58482814504483
        struct[0].Gy_ini[121,57] = -7.89461337514771
        struct[0].Gy_ini[121,58] = -4.84676915585801
        struct[0].Gy_ini[121,59] = 26.5300693004806
        struct[0].Gy_ini[121,60] = -1.58482814504483
        struct[0].Gy_ini[121,61] = -7.89461337514771
        struct[0].Gy_ini[121,62] = -0.679918453285308
        struct[0].Gy_ini[121,63] = -7.72144347466701
        struct[0].Gy_ini[121,120] = 4.84676915585801
        struct[0].Gy_ini[121,121] = -26.5300693004806
        struct[0].Gy_ini[121,122] = 1.58482814504483
        struct[0].Gy_ini[121,123] = 7.89461337514771
        struct[0].Gy_ini[122,8] = 7.72144347466701
        struct[0].Gy_ini[122,9] = -0.679918453285310
        struct[0].Gy_ini[122,10] = 7.89461337514771
        struct[0].Gy_ini[122,11] = -1.58482814504483
        struct[0].Gy_ini[122,56] = -7.72144347466701
        struct[0].Gy_ini[122,57] = 0.679918453285310
        struct[0].Gy_ini[122,58] = -7.89461337514770
        struct[0].Gy_ini[122,59] = 1.58482814504483
        struct[0].Gy_ini[122,60] = 26.5300693004806
        struct[0].Gy_ini[122,61] = 4.84676915585801
        struct[0].Gy_ini[122,62] = -7.89461337514771
        struct[0].Gy_ini[122,63] = 1.58482814504483
        struct[0].Gy_ini[122,120] = 7.89461337514770
        struct[0].Gy_ini[122,121] = -1.58482814504483
        struct[0].Gy_ini[122,122] = -26.5300693004806
        struct[0].Gy_ini[122,123] = -4.84676915585801
        struct[0].Gy_ini[123,8] = 0.679918453285310
        struct[0].Gy_ini[123,9] = 7.72144347466701
        struct[0].Gy_ini[123,10] = 1.58482814504483
        struct[0].Gy_ini[123,11] = 7.89461337514771
        struct[0].Gy_ini[123,56] = -0.679918453285310
        struct[0].Gy_ini[123,57] = -7.72144347466701
        struct[0].Gy_ini[123,58] = -1.58482814504483
        struct[0].Gy_ini[123,59] = -7.89461337514770
        struct[0].Gy_ini[123,60] = -4.84676915585801
        struct[0].Gy_ini[123,61] = 26.5300693004806
        struct[0].Gy_ini[123,62] = -1.58482814504483
        struct[0].Gy_ini[123,63] = -7.89461337514771
        struct[0].Gy_ini[123,120] = 1.58482814504483
        struct[0].Gy_ini[123,121] = 7.89461337514770
        struct[0].Gy_ini[123,122] = 4.84676915585801
        struct[0].Gy_ini[123,123] = -26.5300693004806
        struct[0].Gy_ini[124,64] = 26.5300693004806
        struct[0].Gy_ini[124,65] = 4.84676915585801
        struct[0].Gy_ini[124,66] = -7.89461337514770
        struct[0].Gy_ini[124,67] = 1.58482814504483
        struct[0].Gy_ini[124,68] = -7.72144347466701
        struct[0].Gy_ini[124,69] = 0.679918453285310
        struct[0].Gy_ini[124,70] = -7.89461337514771
        struct[0].Gy_ini[124,71] = 1.58482814504483
        struct[0].Gy_ini[124,124] = -53.0601386009611
        struct[0].Gy_ini[124,125] = -9.69353831171601
        struct[0].Gy_ini[124,126] = 15.7892267502954
        struct[0].Gy_ini[124,127] = -3.16965629008966
        struct[0].Gy_ini[124,128] = 15.4428869493340
        struct[0].Gy_ini[124,129] = -1.35983690657062
        struct[0].Gy_ini[124,130] = 15.7892267502954
        struct[0].Gy_ini[124,131] = -3.16965629008966
        struct[0].Gy_ini[124,132] = 26.5300693004806
        struct[0].Gy_ini[124,133] = 4.84676915585801
        struct[0].Gy_ini[124,134] = -7.89461337514770
        struct[0].Gy_ini[124,135] = 1.58482814504483
        struct[0].Gy_ini[124,136] = -7.72144347466701
        struct[0].Gy_ini[124,137] = 0.679918453285310
        struct[0].Gy_ini[124,138] = -7.89461337514771
        struct[0].Gy_ini[124,139] = 1.58482814504483
        struct[0].Gy_ini[125,64] = -4.84676915585801
        struct[0].Gy_ini[125,65] = 26.5300693004806
        struct[0].Gy_ini[125,66] = -1.58482814504483
        struct[0].Gy_ini[125,67] = -7.89461337514770
        struct[0].Gy_ini[125,68] = -0.679918453285310
        struct[0].Gy_ini[125,69] = -7.72144347466701
        struct[0].Gy_ini[125,70] = -1.58482814504483
        struct[0].Gy_ini[125,71] = -7.89461337514771
        struct[0].Gy_ini[125,124] = 9.69353831171601
        struct[0].Gy_ini[125,125] = -53.0601386009611
        struct[0].Gy_ini[125,126] = 3.16965629008966
        struct[0].Gy_ini[125,127] = 15.7892267502954
        struct[0].Gy_ini[125,128] = 1.35983690657062
        struct[0].Gy_ini[125,129] = 15.4428869493340
        struct[0].Gy_ini[125,130] = 3.16965629008966
        struct[0].Gy_ini[125,131] = 15.7892267502954
        struct[0].Gy_ini[125,132] = -4.84676915585801
        struct[0].Gy_ini[125,133] = 26.5300693004806
        struct[0].Gy_ini[125,134] = -1.58482814504483
        struct[0].Gy_ini[125,135] = -7.89461337514770
        struct[0].Gy_ini[125,136] = -0.679918453285310
        struct[0].Gy_ini[125,137] = -7.72144347466701
        struct[0].Gy_ini[125,138] = -1.58482814504483
        struct[0].Gy_ini[125,139] = -7.89461337514771
        struct[0].Gy_ini[126,64] = -7.89461337514771
        struct[0].Gy_ini[126,65] = 1.58482814504483
        struct[0].Gy_ini[126,66] = 26.5300693004806
        struct[0].Gy_ini[126,67] = 4.84676915585801
        struct[0].Gy_ini[126,68] = -7.89461337514771
        struct[0].Gy_ini[126,69] = 1.58482814504483
        struct[0].Gy_ini[126,70] = -7.72144347466701
        struct[0].Gy_ini[126,71] = 0.679918453285308
        struct[0].Gy_ini[126,124] = 15.7892267502954
        struct[0].Gy_ini[126,125] = -3.16965629008966
        struct[0].Gy_ini[126,126] = -53.0601386009611
        struct[0].Gy_ini[126,127] = -9.69353831171602
        struct[0].Gy_ini[126,128] = 15.7892267502954
        struct[0].Gy_ini[126,129] = -3.16965629008967
        struct[0].Gy_ini[126,130] = 15.4428869493340
        struct[0].Gy_ini[126,131] = -1.35983690657062
        struct[0].Gy_ini[126,132] = -7.89461337514771
        struct[0].Gy_ini[126,133] = 1.58482814504483
        struct[0].Gy_ini[126,134] = 26.5300693004806
        struct[0].Gy_ini[126,135] = 4.84676915585801
        struct[0].Gy_ini[126,136] = -7.89461337514771
        struct[0].Gy_ini[126,137] = 1.58482814504483
        struct[0].Gy_ini[126,138] = -7.72144347466701
        struct[0].Gy_ini[126,139] = 0.679918453285308
        struct[0].Gy_ini[127,64] = -1.58482814504483
        struct[0].Gy_ini[127,65] = -7.89461337514771
        struct[0].Gy_ini[127,66] = -4.84676915585801
        struct[0].Gy_ini[127,67] = 26.5300693004806
        struct[0].Gy_ini[127,68] = -1.58482814504483
        struct[0].Gy_ini[127,69] = -7.89461337514771
        struct[0].Gy_ini[127,70] = -0.679918453285308
        struct[0].Gy_ini[127,71] = -7.72144347466701
        struct[0].Gy_ini[127,124] = 3.16965629008966
        struct[0].Gy_ini[127,125] = 15.7892267502954
        struct[0].Gy_ini[127,126] = 9.69353831171602
        struct[0].Gy_ini[127,127] = -53.0601386009611
        struct[0].Gy_ini[127,128] = 3.16965629008967
        struct[0].Gy_ini[127,129] = 15.7892267502954
        struct[0].Gy_ini[127,130] = 1.35983690657062
        struct[0].Gy_ini[127,131] = 15.4428869493340
        struct[0].Gy_ini[127,132] = -1.58482814504483
        struct[0].Gy_ini[127,133] = -7.89461337514771
        struct[0].Gy_ini[127,134] = -4.84676915585801
        struct[0].Gy_ini[127,135] = 26.5300693004806
        struct[0].Gy_ini[127,136] = -1.58482814504483
        struct[0].Gy_ini[127,137] = -7.89461337514771
        struct[0].Gy_ini[127,138] = -0.679918453285308
        struct[0].Gy_ini[127,139] = -7.72144347466701
        struct[0].Gy_ini[128,64] = -7.72144347466701
        struct[0].Gy_ini[128,65] = 0.679918453285310
        struct[0].Gy_ini[128,66] = -7.89461337514770
        struct[0].Gy_ini[128,67] = 1.58482814504483
        struct[0].Gy_ini[128,68] = 26.5300693004806
        struct[0].Gy_ini[128,69] = 4.84676915585801
        struct[0].Gy_ini[128,70] = -7.89461337514771
        struct[0].Gy_ini[128,71] = 1.58482814504483
        struct[0].Gy_ini[128,124] = 15.4428869493340
        struct[0].Gy_ini[128,125] = -1.35983690657062
        struct[0].Gy_ini[128,126] = 15.7892267502954
        struct[0].Gy_ini[128,127] = -3.16965629008966
        struct[0].Gy_ini[128,128] = -53.0601386009611
        struct[0].Gy_ini[128,129] = -9.69353831171602
        struct[0].Gy_ini[128,130] = 15.7892267502954
        struct[0].Gy_ini[128,131] = -3.16965629008967
        struct[0].Gy_ini[128,132] = -7.72144347466701
        struct[0].Gy_ini[128,133] = 0.679918453285310
        struct[0].Gy_ini[128,134] = -7.89461337514770
        struct[0].Gy_ini[128,135] = 1.58482814504483
        struct[0].Gy_ini[128,136] = 26.5300693004806
        struct[0].Gy_ini[128,137] = 4.84676915585801
        struct[0].Gy_ini[128,138] = -7.89461337514771
        struct[0].Gy_ini[128,139] = 1.58482814504483
        struct[0].Gy_ini[129,64] = -0.679918453285310
        struct[0].Gy_ini[129,65] = -7.72144347466701
        struct[0].Gy_ini[129,66] = -1.58482814504483
        struct[0].Gy_ini[129,67] = -7.89461337514770
        struct[0].Gy_ini[129,68] = -4.84676915585801
        struct[0].Gy_ini[129,69] = 26.5300693004806
        struct[0].Gy_ini[129,70] = -1.58482814504483
        struct[0].Gy_ini[129,71] = -7.89461337514771
        struct[0].Gy_ini[129,124] = 1.35983690657062
        struct[0].Gy_ini[129,125] = 15.4428869493340
        struct[0].Gy_ini[129,126] = 3.16965629008966
        struct[0].Gy_ini[129,127] = 15.7892267502954
        struct[0].Gy_ini[129,128] = 9.69353831171602
        struct[0].Gy_ini[129,129] = -53.0601386009611
        struct[0].Gy_ini[129,130] = 3.16965629008967
        struct[0].Gy_ini[129,131] = 15.7892267502954
        struct[0].Gy_ini[129,132] = -0.679918453285310
        struct[0].Gy_ini[129,133] = -7.72144347466701
        struct[0].Gy_ini[129,134] = -1.58482814504483
        struct[0].Gy_ini[129,135] = -7.89461337514770
        struct[0].Gy_ini[129,136] = -4.84676915585801
        struct[0].Gy_ini[129,137] = 26.5300693004806
        struct[0].Gy_ini[129,138] = -1.58482814504483
        struct[0].Gy_ini[129,139] = -7.89461337514771
        struct[0].Gy_ini[130,64] = -7.89461337514771
        struct[0].Gy_ini[130,65] = 1.58482814504483
        struct[0].Gy_ini[130,66] = -7.72144347466701
        struct[0].Gy_ini[130,67] = 0.679918453285308
        struct[0].Gy_ini[130,68] = -7.89461337514771
        struct[0].Gy_ini[130,69] = 1.58482814504483
        struct[0].Gy_ini[130,70] = 26.5300693004806
        struct[0].Gy_ini[130,71] = 4.84676915585801
        struct[0].Gy_ini[130,124] = 15.7892267502954
        struct[0].Gy_ini[130,125] = -3.16965629008966
        struct[0].Gy_ini[130,126] = 15.4428869493340
        struct[0].Gy_ini[130,127] = -1.35983690657062
        struct[0].Gy_ini[130,128] = 15.7892267502954
        struct[0].Gy_ini[130,129] = -3.16965629008966
        struct[0].Gy_ini[130,130] = -53.0601386009611
        struct[0].Gy_ini[130,131] = -9.69353831171602
        struct[0].Gy_ini[130,132] = -7.89461337514771
        struct[0].Gy_ini[130,133] = 1.58482814504483
        struct[0].Gy_ini[130,134] = -7.72144347466701
        struct[0].Gy_ini[130,135] = 0.679918453285308
        struct[0].Gy_ini[130,136] = -7.89461337514771
        struct[0].Gy_ini[130,137] = 1.58482814504483
        struct[0].Gy_ini[130,138] = 26.5300693004806
        struct[0].Gy_ini[130,139] = 4.84676915585801
        struct[0].Gy_ini[131,64] = -1.58482814504483
        struct[0].Gy_ini[131,65] = -7.89461337514771
        struct[0].Gy_ini[131,66] = -0.679918453285308
        struct[0].Gy_ini[131,67] = -7.72144347466701
        struct[0].Gy_ini[131,68] = -1.58482814504483
        struct[0].Gy_ini[131,69] = -7.89461337514771
        struct[0].Gy_ini[131,70] = -4.84676915585801
        struct[0].Gy_ini[131,71] = 26.5300693004806
        struct[0].Gy_ini[131,124] = 3.16965629008966
        struct[0].Gy_ini[131,125] = 15.7892267502954
        struct[0].Gy_ini[131,126] = 1.35983690657062
        struct[0].Gy_ini[131,127] = 15.4428869493340
        struct[0].Gy_ini[131,128] = 3.16965629008966
        struct[0].Gy_ini[131,129] = 15.7892267502954
        struct[0].Gy_ini[131,130] = 9.69353831171602
        struct[0].Gy_ini[131,131] = -53.0601386009611
        struct[0].Gy_ini[131,132] = -1.58482814504483
        struct[0].Gy_ini[131,133] = -7.89461337514771
        struct[0].Gy_ini[131,134] = -0.679918453285308
        struct[0].Gy_ini[131,135] = -7.72144347466701
        struct[0].Gy_ini[131,136] = -1.58482814504483
        struct[0].Gy_ini[131,137] = -7.89461337514771
        struct[0].Gy_ini[131,138] = -4.84676915585801
        struct[0].Gy_ini[131,139] = 26.5300693004806
        struct[0].Gy_ini[132,124] = 26.5300693004806
        struct[0].Gy_ini[132,125] = 4.84676915585801
        struct[0].Gy_ini[132,126] = -7.89461337514770
        struct[0].Gy_ini[132,127] = 1.58482814504483
        struct[0].Gy_ini[132,128] = -7.72144347466701
        struct[0].Gy_ini[132,129] = 0.679918453285310
        struct[0].Gy_ini[132,130] = -7.89461337514771
        struct[0].Gy_ini[132,131] = 1.58482814504483
        struct[0].Gy_ini[132,132] = -53.0601386009611
        struct[0].Gy_ini[132,133] = -9.69353831171601
        struct[0].Gy_ini[132,134] = 15.7892267502954
        struct[0].Gy_ini[132,135] = -3.16965629008966
        struct[0].Gy_ini[132,136] = 15.4428869493340
        struct[0].Gy_ini[132,137] = -1.35983690657062
        struct[0].Gy_ini[132,138] = 15.7892267502954
        struct[0].Gy_ini[132,139] = -3.16965629008966
        struct[0].Gy_ini[132,140] = 26.5300693004806
        struct[0].Gy_ini[132,141] = 4.84676915585801
        struct[0].Gy_ini[132,142] = -7.89461337514770
        struct[0].Gy_ini[132,143] = 1.58482814504483
        struct[0].Gy_ini[132,144] = -7.72144347466701
        struct[0].Gy_ini[132,145] = 0.679918453285310
        struct[0].Gy_ini[132,146] = -7.89461337514771
        struct[0].Gy_ini[132,147] = 1.58482814504483
        struct[0].Gy_ini[133,124] = -4.84676915585801
        struct[0].Gy_ini[133,125] = 26.5300693004806
        struct[0].Gy_ini[133,126] = -1.58482814504483
        struct[0].Gy_ini[133,127] = -7.89461337514770
        struct[0].Gy_ini[133,128] = -0.679918453285310
        struct[0].Gy_ini[133,129] = -7.72144347466701
        struct[0].Gy_ini[133,130] = -1.58482814504483
        struct[0].Gy_ini[133,131] = -7.89461337514771
        struct[0].Gy_ini[133,132] = 9.69353831171601
        struct[0].Gy_ini[133,133] = -53.0601386009611
        struct[0].Gy_ini[133,134] = 3.16965629008966
        struct[0].Gy_ini[133,135] = 15.7892267502954
        struct[0].Gy_ini[133,136] = 1.35983690657062
        struct[0].Gy_ini[133,137] = 15.4428869493340
        struct[0].Gy_ini[133,138] = 3.16965629008966
        struct[0].Gy_ini[133,139] = 15.7892267502954
        struct[0].Gy_ini[133,140] = -4.84676915585801
        struct[0].Gy_ini[133,141] = 26.5300693004806
        struct[0].Gy_ini[133,142] = -1.58482814504483
        struct[0].Gy_ini[133,143] = -7.89461337514770
        struct[0].Gy_ini[133,144] = -0.679918453285310
        struct[0].Gy_ini[133,145] = -7.72144347466701
        struct[0].Gy_ini[133,146] = -1.58482814504483
        struct[0].Gy_ini[133,147] = -7.89461337514771
        struct[0].Gy_ini[134,124] = -7.89461337514771
        struct[0].Gy_ini[134,125] = 1.58482814504483
        struct[0].Gy_ini[134,126] = 26.5300693004806
        struct[0].Gy_ini[134,127] = 4.84676915585801
        struct[0].Gy_ini[134,128] = -7.89461337514771
        struct[0].Gy_ini[134,129] = 1.58482814504483
        struct[0].Gy_ini[134,130] = -7.72144347466701
        struct[0].Gy_ini[134,131] = 0.679918453285308
        struct[0].Gy_ini[134,132] = 15.7892267502954
        struct[0].Gy_ini[134,133] = -3.16965629008966
        struct[0].Gy_ini[134,134] = -53.0601386009611
        struct[0].Gy_ini[134,135] = -9.69353831171602
        struct[0].Gy_ini[134,136] = 15.7892267502954
        struct[0].Gy_ini[134,137] = -3.16965629008967
        struct[0].Gy_ini[134,138] = 15.4428869493340
        struct[0].Gy_ini[134,139] = -1.35983690657062
        struct[0].Gy_ini[134,140] = -7.89461337514771
        struct[0].Gy_ini[134,141] = 1.58482814504483
        struct[0].Gy_ini[134,142] = 26.5300693004806
        struct[0].Gy_ini[134,143] = 4.84676915585801
        struct[0].Gy_ini[134,144] = -7.89461337514771
        struct[0].Gy_ini[134,145] = 1.58482814504483
        struct[0].Gy_ini[134,146] = -7.72144347466701
        struct[0].Gy_ini[134,147] = 0.679918453285308
        struct[0].Gy_ini[135,124] = -1.58482814504483
        struct[0].Gy_ini[135,125] = -7.89461337514771
        struct[0].Gy_ini[135,126] = -4.84676915585801
        struct[0].Gy_ini[135,127] = 26.5300693004806
        struct[0].Gy_ini[135,128] = -1.58482814504483
        struct[0].Gy_ini[135,129] = -7.89461337514771
        struct[0].Gy_ini[135,130] = -0.679918453285308
        struct[0].Gy_ini[135,131] = -7.72144347466701
        struct[0].Gy_ini[135,132] = 3.16965629008966
        struct[0].Gy_ini[135,133] = 15.7892267502954
        struct[0].Gy_ini[135,134] = 9.69353831171602
        struct[0].Gy_ini[135,135] = -53.0601386009611
        struct[0].Gy_ini[135,136] = 3.16965629008967
        struct[0].Gy_ini[135,137] = 15.7892267502954
        struct[0].Gy_ini[135,138] = 1.35983690657062
        struct[0].Gy_ini[135,139] = 15.4428869493340
        struct[0].Gy_ini[135,140] = -1.58482814504483
        struct[0].Gy_ini[135,141] = -7.89461337514771
        struct[0].Gy_ini[135,142] = -4.84676915585801
        struct[0].Gy_ini[135,143] = 26.5300693004806
        struct[0].Gy_ini[135,144] = -1.58482814504483
        struct[0].Gy_ini[135,145] = -7.89461337514771
        struct[0].Gy_ini[135,146] = -0.679918453285308
        struct[0].Gy_ini[135,147] = -7.72144347466701
        struct[0].Gy_ini[136,124] = -7.72144347466701
        struct[0].Gy_ini[136,125] = 0.679918453285310
        struct[0].Gy_ini[136,126] = -7.89461337514770
        struct[0].Gy_ini[136,127] = 1.58482814504483
        struct[0].Gy_ini[136,128] = 26.5300693004806
        struct[0].Gy_ini[136,129] = 4.84676915585801
        struct[0].Gy_ini[136,130] = -7.89461337514771
        struct[0].Gy_ini[136,131] = 1.58482814504483
        struct[0].Gy_ini[136,132] = 15.4428869493340
        struct[0].Gy_ini[136,133] = -1.35983690657062
        struct[0].Gy_ini[136,134] = 15.7892267502954
        struct[0].Gy_ini[136,135] = -3.16965629008966
        struct[0].Gy_ini[136,136] = -53.0601386009611
        struct[0].Gy_ini[136,137] = -9.69353831171602
        struct[0].Gy_ini[136,138] = 15.7892267502954
        struct[0].Gy_ini[136,139] = -3.16965629008967
        struct[0].Gy_ini[136,140] = -7.72144347466701
        struct[0].Gy_ini[136,141] = 0.679918453285310
        struct[0].Gy_ini[136,142] = -7.89461337514770
        struct[0].Gy_ini[136,143] = 1.58482814504483
        struct[0].Gy_ini[136,144] = 26.5300693004806
        struct[0].Gy_ini[136,145] = 4.84676915585801
        struct[0].Gy_ini[136,146] = -7.89461337514771
        struct[0].Gy_ini[136,147] = 1.58482814504483
        struct[0].Gy_ini[137,124] = -0.679918453285310
        struct[0].Gy_ini[137,125] = -7.72144347466701
        struct[0].Gy_ini[137,126] = -1.58482814504483
        struct[0].Gy_ini[137,127] = -7.89461337514770
        struct[0].Gy_ini[137,128] = -4.84676915585801
        struct[0].Gy_ini[137,129] = 26.5300693004806
        struct[0].Gy_ini[137,130] = -1.58482814504483
        struct[0].Gy_ini[137,131] = -7.89461337514771
        struct[0].Gy_ini[137,132] = 1.35983690657062
        struct[0].Gy_ini[137,133] = 15.4428869493340
        struct[0].Gy_ini[137,134] = 3.16965629008966
        struct[0].Gy_ini[137,135] = 15.7892267502954
        struct[0].Gy_ini[137,136] = 9.69353831171602
        struct[0].Gy_ini[137,137] = -53.0601386009611
        struct[0].Gy_ini[137,138] = 3.16965629008967
        struct[0].Gy_ini[137,139] = 15.7892267502954
        struct[0].Gy_ini[137,140] = -0.679918453285310
        struct[0].Gy_ini[137,141] = -7.72144347466701
        struct[0].Gy_ini[137,142] = -1.58482814504483
        struct[0].Gy_ini[137,143] = -7.89461337514770
        struct[0].Gy_ini[137,144] = -4.84676915585801
        struct[0].Gy_ini[137,145] = 26.5300693004806
        struct[0].Gy_ini[137,146] = -1.58482814504483
        struct[0].Gy_ini[137,147] = -7.89461337514771
        struct[0].Gy_ini[138,124] = -7.89461337514771
        struct[0].Gy_ini[138,125] = 1.58482814504483
        struct[0].Gy_ini[138,126] = -7.72144347466701
        struct[0].Gy_ini[138,127] = 0.679918453285308
        struct[0].Gy_ini[138,128] = -7.89461337514771
        struct[0].Gy_ini[138,129] = 1.58482814504483
        struct[0].Gy_ini[138,130] = 26.5300693004806
        struct[0].Gy_ini[138,131] = 4.84676915585801
        struct[0].Gy_ini[138,132] = 15.7892267502954
        struct[0].Gy_ini[138,133] = -3.16965629008966
        struct[0].Gy_ini[138,134] = 15.4428869493340
        struct[0].Gy_ini[138,135] = -1.35983690657062
        struct[0].Gy_ini[138,136] = 15.7892267502954
        struct[0].Gy_ini[138,137] = -3.16965629008966
        struct[0].Gy_ini[138,138] = -53.0851386009611
        struct[0].Gy_ini[138,139] = -9.69353831171602
        struct[0].Gy_ini[138,140] = -7.89461337514771
        struct[0].Gy_ini[138,141] = 1.58482814504483
        struct[0].Gy_ini[138,142] = -7.72144347466701
        struct[0].Gy_ini[138,143] = 0.679918453285308
        struct[0].Gy_ini[138,144] = -7.89461337514771
        struct[0].Gy_ini[138,145] = 1.58482814504483
        struct[0].Gy_ini[138,146] = 26.5300693004806
        struct[0].Gy_ini[138,147] = 4.84676915585801
        struct[0].Gy_ini[139,124] = -1.58482814504483
        struct[0].Gy_ini[139,125] = -7.89461337514771
        struct[0].Gy_ini[139,126] = -0.679918453285308
        struct[0].Gy_ini[139,127] = -7.72144347466701
        struct[0].Gy_ini[139,128] = -1.58482814504483
        struct[0].Gy_ini[139,129] = -7.89461337514771
        struct[0].Gy_ini[139,130] = -4.84676915585801
        struct[0].Gy_ini[139,131] = 26.5300693004806
        struct[0].Gy_ini[139,132] = 3.16965629008966
        struct[0].Gy_ini[139,133] = 15.7892267502954
        struct[0].Gy_ini[139,134] = 1.35983690657062
        struct[0].Gy_ini[139,135] = 15.4428869493340
        struct[0].Gy_ini[139,136] = 3.16965629008966
        struct[0].Gy_ini[139,137] = 15.7892267502954
        struct[0].Gy_ini[139,138] = 9.69353831171602
        struct[0].Gy_ini[139,139] = -53.0851386009611
        struct[0].Gy_ini[139,140] = -1.58482814504483
        struct[0].Gy_ini[139,141] = -7.89461337514771
        struct[0].Gy_ini[139,142] = -0.679918453285308
        struct[0].Gy_ini[139,143] = -7.72144347466701
        struct[0].Gy_ini[139,144] = -1.58482814504483
        struct[0].Gy_ini[139,145] = -7.89461337514771
        struct[0].Gy_ini[139,146] = -4.84676915585801
        struct[0].Gy_ini[139,147] = 26.5300693004806
        struct[0].Gy_ini[140,12] = 26.5300693004806
        struct[0].Gy_ini[140,13] = 4.84676915585801
        struct[0].Gy_ini[140,14] = -7.89461337514771
        struct[0].Gy_ini[140,15] = 1.58482814504483
        struct[0].Gy_ini[140,132] = 26.5300693004806
        struct[0].Gy_ini[140,133] = 4.84676915585801
        struct[0].Gy_ini[140,134] = -7.89461337514770
        struct[0].Gy_ini[140,135] = 1.58482814504483
        struct[0].Gy_ini[140,136] = -7.72144347466701
        struct[0].Gy_ini[140,137] = 0.679918453285310
        struct[0].Gy_ini[140,138] = -7.89461337514771
        struct[0].Gy_ini[140,139] = 1.58482814504483
        struct[0].Gy_ini[140,140] = -53.0601386009611
        struct[0].Gy_ini[140,141] = -9.69353831171601
        struct[0].Gy_ini[140,142] = 15.7892267502954
        struct[0].Gy_ini[140,143] = -3.16965629008966
        struct[0].Gy_ini[140,144] = 15.4428869493340
        struct[0].Gy_ini[140,145] = -1.35983690657062
        struct[0].Gy_ini[140,146] = 15.7892267502954
        struct[0].Gy_ini[140,147] = -3.16965629008966
        struct[0].Gy_ini[140,148] = -7.89461337514770
        struct[0].Gy_ini[140,149] = 1.58482814504483
        struct[0].Gy_ini[140,150] = -7.72144347466701
        struct[0].Gy_ini[140,151] = 0.679918453285310
        struct[0].Gy_ini[140,404] = 1
        struct[0].Gy_ini[141,12] = -4.84676915585801
        struct[0].Gy_ini[141,13] = 26.5300693004806
        struct[0].Gy_ini[141,14] = -1.58482814504483
        struct[0].Gy_ini[141,15] = -7.89461337514771
        struct[0].Gy_ini[141,132] = -4.84676915585801
        struct[0].Gy_ini[141,133] = 26.5300693004806
        struct[0].Gy_ini[141,134] = -1.58482814504483
        struct[0].Gy_ini[141,135] = -7.89461337514770
        struct[0].Gy_ini[141,136] = -0.679918453285310
        struct[0].Gy_ini[141,137] = -7.72144347466701
        struct[0].Gy_ini[141,138] = -1.58482814504483
        struct[0].Gy_ini[141,139] = -7.89461337514771
        struct[0].Gy_ini[141,140] = 9.69353831171601
        struct[0].Gy_ini[141,141] = -53.0601386009611
        struct[0].Gy_ini[141,142] = 3.16965629008966
        struct[0].Gy_ini[141,143] = 15.7892267502954
        struct[0].Gy_ini[141,144] = 1.35983690657062
        struct[0].Gy_ini[141,145] = 15.4428869493340
        struct[0].Gy_ini[141,146] = 3.16965629008966
        struct[0].Gy_ini[141,147] = 15.7892267502954
        struct[0].Gy_ini[141,148] = -1.58482814504483
        struct[0].Gy_ini[141,149] = -7.89461337514770
        struct[0].Gy_ini[141,150] = -0.679918453285310
        struct[0].Gy_ini[141,151] = -7.72144347466701
        struct[0].Gy_ini[141,405] = 1
        struct[0].Gy_ini[142,12] = -7.89461337514771
        struct[0].Gy_ini[142,13] = 1.58482814504483
        struct[0].Gy_ini[142,14] = -7.72144347466701
        struct[0].Gy_ini[142,15] = 0.679918453285308
        struct[0].Gy_ini[142,132] = -7.89461337514771
        struct[0].Gy_ini[142,133] = 1.58482814504483
        struct[0].Gy_ini[142,134] = 26.5300693004806
        struct[0].Gy_ini[142,135] = 4.84676915585801
        struct[0].Gy_ini[142,136] = -7.89461337514771
        struct[0].Gy_ini[142,137] = 1.58482814504483
        struct[0].Gy_ini[142,138] = -7.72144347466701
        struct[0].Gy_ini[142,139] = 0.679918453285308
        struct[0].Gy_ini[142,140] = 15.7892267502954
        struct[0].Gy_ini[142,141] = -3.16965629008966
        struct[0].Gy_ini[142,142] = -53.0601386009611
        struct[0].Gy_ini[142,143] = -9.69353831171602
        struct[0].Gy_ini[142,144] = 15.7892267502954
        struct[0].Gy_ini[142,145] = -3.16965629008967
        struct[0].Gy_ini[142,146] = 15.4428869493340
        struct[0].Gy_ini[142,147] = -1.35983690657062
        struct[0].Gy_ini[142,148] = 26.5300693004806
        struct[0].Gy_ini[142,149] = 4.84676915585801
        struct[0].Gy_ini[142,150] = -7.89461337514771
        struct[0].Gy_ini[142,151] = 1.58482814504483
        struct[0].Gy_ini[142,406] = 1
        struct[0].Gy_ini[143,12] = -1.58482814504483
        struct[0].Gy_ini[143,13] = -7.89461337514771
        struct[0].Gy_ini[143,14] = -0.679918453285308
        struct[0].Gy_ini[143,15] = -7.72144347466701
        struct[0].Gy_ini[143,132] = -1.58482814504483
        struct[0].Gy_ini[143,133] = -7.89461337514771
        struct[0].Gy_ini[143,134] = -4.84676915585801
        struct[0].Gy_ini[143,135] = 26.5300693004806
        struct[0].Gy_ini[143,136] = -1.58482814504483
        struct[0].Gy_ini[143,137] = -7.89461337514771
        struct[0].Gy_ini[143,138] = -0.679918453285308
        struct[0].Gy_ini[143,139] = -7.72144347466701
        struct[0].Gy_ini[143,140] = 3.16965629008966
        struct[0].Gy_ini[143,141] = 15.7892267502954
        struct[0].Gy_ini[143,142] = 9.69353831171602
        struct[0].Gy_ini[143,143] = -53.0601386009611
        struct[0].Gy_ini[143,144] = 3.16965629008967
        struct[0].Gy_ini[143,145] = 15.7892267502954
        struct[0].Gy_ini[143,146] = 1.35983690657062
        struct[0].Gy_ini[143,147] = 15.4428869493340
        struct[0].Gy_ini[143,148] = -4.84676915585801
        struct[0].Gy_ini[143,149] = 26.5300693004806
        struct[0].Gy_ini[143,150] = -1.58482814504483
        struct[0].Gy_ini[143,151] = -7.89461337514771
        struct[0].Gy_ini[143,407] = 1
        struct[0].Gy_ini[144,12] = -7.72144347466701
        struct[0].Gy_ini[144,13] = 0.679918453285310
        struct[0].Gy_ini[144,14] = -7.89461337514771
        struct[0].Gy_ini[144,15] = 1.58482814504483
        struct[0].Gy_ini[144,132] = -7.72144347466701
        struct[0].Gy_ini[144,133] = 0.679918453285310
        struct[0].Gy_ini[144,134] = -7.89461337514770
        struct[0].Gy_ini[144,135] = 1.58482814504483
        struct[0].Gy_ini[144,136] = 26.5300693004806
        struct[0].Gy_ini[144,137] = 4.84676915585801
        struct[0].Gy_ini[144,138] = -7.89461337514771
        struct[0].Gy_ini[144,139] = 1.58482814504483
        struct[0].Gy_ini[144,140] = 15.4428869493340
        struct[0].Gy_ini[144,141] = -1.35983690657062
        struct[0].Gy_ini[144,142] = 15.7892267502954
        struct[0].Gy_ini[144,143] = -3.16965629008966
        struct[0].Gy_ini[144,144] = -53.0601386009611
        struct[0].Gy_ini[144,145] = -9.69353831171602
        struct[0].Gy_ini[144,146] = 15.7892267502954
        struct[0].Gy_ini[144,147] = -3.16965629008967
        struct[0].Gy_ini[144,148] = -7.89461337514770
        struct[0].Gy_ini[144,149] = 1.58482814504483
        struct[0].Gy_ini[144,150] = 26.5300693004806
        struct[0].Gy_ini[144,151] = 4.84676915585801
        struct[0].Gy_ini[144,408] = 1
        struct[0].Gy_ini[145,12] = -0.679918453285310
        struct[0].Gy_ini[145,13] = -7.72144347466701
        struct[0].Gy_ini[145,14] = -1.58482814504483
        struct[0].Gy_ini[145,15] = -7.89461337514771
        struct[0].Gy_ini[145,132] = -0.679918453285310
        struct[0].Gy_ini[145,133] = -7.72144347466701
        struct[0].Gy_ini[145,134] = -1.58482814504483
        struct[0].Gy_ini[145,135] = -7.89461337514770
        struct[0].Gy_ini[145,136] = -4.84676915585801
        struct[0].Gy_ini[145,137] = 26.5300693004806
        struct[0].Gy_ini[145,138] = -1.58482814504483
        struct[0].Gy_ini[145,139] = -7.89461337514771
        struct[0].Gy_ini[145,140] = 1.35983690657062
        struct[0].Gy_ini[145,141] = 15.4428869493340
        struct[0].Gy_ini[145,142] = 3.16965629008966
        struct[0].Gy_ini[145,143] = 15.7892267502954
        struct[0].Gy_ini[145,144] = 9.69353831171602
        struct[0].Gy_ini[145,145] = -53.0601386009611
        struct[0].Gy_ini[145,146] = 3.16965629008967
        struct[0].Gy_ini[145,147] = 15.7892267502954
        struct[0].Gy_ini[145,148] = -1.58482814504483
        struct[0].Gy_ini[145,149] = -7.89461337514770
        struct[0].Gy_ini[145,150] = -4.84676915585801
        struct[0].Gy_ini[145,151] = 26.5300693004806
        struct[0].Gy_ini[145,409] = 1
        struct[0].Gy_ini[146,12] = -7.89461337514771
        struct[0].Gy_ini[146,13] = 1.58482814504483
        struct[0].Gy_ini[146,14] = 26.5300693004806
        struct[0].Gy_ini[146,15] = 4.84676915585801
        struct[0].Gy_ini[146,132] = -7.89461337514771
        struct[0].Gy_ini[146,133] = 1.58482814504483
        struct[0].Gy_ini[146,134] = -7.72144347466701
        struct[0].Gy_ini[146,135] = 0.679918453285308
        struct[0].Gy_ini[146,136] = -7.89461337514771
        struct[0].Gy_ini[146,137] = 1.58482814504483
        struct[0].Gy_ini[146,138] = 26.5300693004806
        struct[0].Gy_ini[146,139] = 4.84676915585801
        struct[0].Gy_ini[146,140] = 15.7892267502954
        struct[0].Gy_ini[146,141] = -3.16965629008966
        struct[0].Gy_ini[146,142] = 15.4428869493340
        struct[0].Gy_ini[146,143] = -1.35983690657062
        struct[0].Gy_ini[146,144] = 15.7892267502954
        struct[0].Gy_ini[146,145] = -3.16965629008966
        struct[0].Gy_ini[146,146] = -53.0601386009611
        struct[0].Gy_ini[146,147] = -9.69353831171602
        struct[0].Gy_ini[146,148] = -7.72144347466701
        struct[0].Gy_ini[146,149] = 0.679918453285308
        struct[0].Gy_ini[146,150] = -7.89461337514771
        struct[0].Gy_ini[146,151] = 1.58482814504483
        struct[0].Gy_ini[146,410] = 1
        struct[0].Gy_ini[147,12] = -1.58482814504483
        struct[0].Gy_ini[147,13] = -7.89461337514771
        struct[0].Gy_ini[147,14] = -4.84676915585801
        struct[0].Gy_ini[147,15] = 26.5300693004806
        struct[0].Gy_ini[147,132] = -1.58482814504483
        struct[0].Gy_ini[147,133] = -7.89461337514771
        struct[0].Gy_ini[147,134] = -0.679918453285308
        struct[0].Gy_ini[147,135] = -7.72144347466701
        struct[0].Gy_ini[147,136] = -1.58482814504483
        struct[0].Gy_ini[147,137] = -7.89461337514771
        struct[0].Gy_ini[147,138] = -4.84676915585801
        struct[0].Gy_ini[147,139] = 26.5300693004806
        struct[0].Gy_ini[147,140] = 3.16965629008966
        struct[0].Gy_ini[147,141] = 15.7892267502954
        struct[0].Gy_ini[147,142] = 1.35983690657062
        struct[0].Gy_ini[147,143] = 15.4428869493340
        struct[0].Gy_ini[147,144] = 3.16965629008966
        struct[0].Gy_ini[147,145] = 15.7892267502954
        struct[0].Gy_ini[147,146] = 9.69353831171602
        struct[0].Gy_ini[147,147] = -53.0601386009611
        struct[0].Gy_ini[147,148] = -0.679918453285308
        struct[0].Gy_ini[147,149] = -7.72144347466701
        struct[0].Gy_ini[147,150] = -1.58482814504483
        struct[0].Gy_ini[147,151] = -7.89461337514771
        struct[0].Gy_ini[147,411] = 1
        struct[0].Gy_ini[148,12] = 7.89461337514771
        struct[0].Gy_ini[148,13] = -1.58482814504483
        struct[0].Gy_ini[148,14] = 7.72144347466701
        struct[0].Gy_ini[148,15] = -0.679918453285308
        struct[0].Gy_ini[148,140] = -7.89461337514771
        struct[0].Gy_ini[148,141] = 1.58482814504483
        struct[0].Gy_ini[148,142] = 26.5300693004806
        struct[0].Gy_ini[148,143] = 4.84676915585801
        struct[0].Gy_ini[148,144] = -7.89461337514771
        struct[0].Gy_ini[148,145] = 1.58482814504483
        struct[0].Gy_ini[148,146] = -7.72144347466701
        struct[0].Gy_ini[148,147] = 0.679918453285308
        struct[0].Gy_ini[148,148] = -26.5300693004806
        struct[0].Gy_ini[148,149] = -4.84676915585801
        struct[0].Gy_ini[148,150] = 7.89461337514771
        struct[0].Gy_ini[148,151] = -1.58482814504483
        struct[0].Gy_ini[149,12] = 1.58482814504483
        struct[0].Gy_ini[149,13] = 7.89461337514771
        struct[0].Gy_ini[149,14] = 0.679918453285308
        struct[0].Gy_ini[149,15] = 7.72144347466701
        struct[0].Gy_ini[149,140] = -1.58482814504483
        struct[0].Gy_ini[149,141] = -7.89461337514771
        struct[0].Gy_ini[149,142] = -4.84676915585801
        struct[0].Gy_ini[149,143] = 26.5300693004806
        struct[0].Gy_ini[149,144] = -1.58482814504483
        struct[0].Gy_ini[149,145] = -7.89461337514771
        struct[0].Gy_ini[149,146] = -0.679918453285308
        struct[0].Gy_ini[149,147] = -7.72144347466701
        struct[0].Gy_ini[149,148] = 4.84676915585801
        struct[0].Gy_ini[149,149] = -26.5300693004806
        struct[0].Gy_ini[149,150] = 1.58482814504483
        struct[0].Gy_ini[149,151] = 7.89461337514771
        struct[0].Gy_ini[150,12] = 7.72144347466701
        struct[0].Gy_ini[150,13] = -0.679918453285310
        struct[0].Gy_ini[150,14] = 7.89461337514771
        struct[0].Gy_ini[150,15] = -1.58482814504483
        struct[0].Gy_ini[150,140] = -7.72144347466701
        struct[0].Gy_ini[150,141] = 0.679918453285310
        struct[0].Gy_ini[150,142] = -7.89461337514770
        struct[0].Gy_ini[150,143] = 1.58482814504483
        struct[0].Gy_ini[150,144] = 26.5300693004806
        struct[0].Gy_ini[150,145] = 4.84676915585801
        struct[0].Gy_ini[150,146] = -7.89461337514771
        struct[0].Gy_ini[150,147] = 1.58482814504483
        struct[0].Gy_ini[150,148] = 7.89461337514770
        struct[0].Gy_ini[150,149] = -1.58482814504483
        struct[0].Gy_ini[150,150] = -26.5300693004806
        struct[0].Gy_ini[150,151] = -4.84676915585801
        struct[0].Gy_ini[151,12] = 0.679918453285310
        struct[0].Gy_ini[151,13] = 7.72144347466701
        struct[0].Gy_ini[151,14] = 1.58482814504483
        struct[0].Gy_ini[151,15] = 7.89461337514771
        struct[0].Gy_ini[151,140] = -0.679918453285310
        struct[0].Gy_ini[151,141] = -7.72144347466701
        struct[0].Gy_ini[151,142] = -1.58482814504483
        struct[0].Gy_ini[151,143] = -7.89461337514770
        struct[0].Gy_ini[151,144] = -4.84676915585801
        struct[0].Gy_ini[151,145] = 26.5300693004806
        struct[0].Gy_ini[151,146] = -1.58482814504483
        struct[0].Gy_ini[151,147] = -7.89461337514771
        struct[0].Gy_ini[151,148] = 1.58482814504483
        struct[0].Gy_ini[151,149] = 7.89461337514770
        struct[0].Gy_ini[151,150] = 4.84676915585801
        struct[0].Gy_ini[151,151] = -26.5300693004806
        struct[0].Gy_ini[152,16] = 9.21038227100566
        struct[0].Gy_ini[152,17] = -1.84896616921897
        struct[0].Gy_ini[152,18] = 9.00835072044485
        struct[0].Gy_ini[152,19] = -0.793238195499528
        struct[0].Gy_ini[152,80] = -9.21038227100566
        struct[0].Gy_ini[152,81] = 1.84896616921897
        struct[0].Gy_ini[152,82] = 30.9517475172273
        struct[0].Gy_ini[152,83] = 5.65456401516768
        struct[0].Gy_ini[152,84] = -9.21038227100566
        struct[0].Gy_ini[152,85] = 1.84896616921897
        struct[0].Gy_ini[152,86] = -9.00835072044485
        struct[0].Gy_ini[152,87] = 0.793238195499528
        struct[0].Gy_ini[152,152] = -30.9517475172273
        struct[0].Gy_ini[152,153] = -5.65456401516768
        struct[0].Gy_ini[152,154] = 9.21038227100566
        struct[0].Gy_ini[152,155] = -1.84896616921897
        struct[0].Gy_ini[153,16] = 1.84896616921897
        struct[0].Gy_ini[153,17] = 9.21038227100566
        struct[0].Gy_ini[153,18] = 0.793238195499528
        struct[0].Gy_ini[153,19] = 9.00835072044485
        struct[0].Gy_ini[153,80] = -1.84896616921897
        struct[0].Gy_ini[153,81] = -9.21038227100566
        struct[0].Gy_ini[153,82] = -5.65456401516768
        struct[0].Gy_ini[153,83] = 30.9517475172273
        struct[0].Gy_ini[153,84] = -1.84896616921897
        struct[0].Gy_ini[153,85] = -9.21038227100566
        struct[0].Gy_ini[153,86] = -0.793238195499528
        struct[0].Gy_ini[153,87] = -9.00835072044485
        struct[0].Gy_ini[153,152] = 5.65456401516768
        struct[0].Gy_ini[153,153] = -30.9517475172273
        struct[0].Gy_ini[153,154] = 1.84896616921897
        struct[0].Gy_ini[153,155] = 9.21038227100566
        struct[0].Gy_ini[154,16] = 9.00835072044484
        struct[0].Gy_ini[154,17] = -0.793238195499527
        struct[0].Gy_ini[154,18] = 9.21038227100566
        struct[0].Gy_ini[154,19] = -1.84896616921897
        struct[0].Gy_ini[154,80] = -9.00835072044484
        struct[0].Gy_ini[154,81] = 0.793238195499527
        struct[0].Gy_ini[154,82] = -9.21038227100566
        struct[0].Gy_ini[154,83] = 1.84896616921897
        struct[0].Gy_ini[154,84] = 30.9517475172273
        struct[0].Gy_ini[154,85] = 5.65456401516768
        struct[0].Gy_ini[154,86] = -9.21038227100566
        struct[0].Gy_ini[154,87] = 1.84896616921897
        struct[0].Gy_ini[154,152] = 9.21038227100566
        struct[0].Gy_ini[154,153] = -1.84896616921897
        struct[0].Gy_ini[154,154] = -30.9517475172273
        struct[0].Gy_ini[154,155] = -5.65456401516768
        struct[0].Gy_ini[155,16] = 0.793238195499527
        struct[0].Gy_ini[155,17] = 9.00835072044484
        struct[0].Gy_ini[155,18] = 1.84896616921897
        struct[0].Gy_ini[155,19] = 9.21038227100566
        struct[0].Gy_ini[155,80] = -0.793238195499527
        struct[0].Gy_ini[155,81] = -9.00835072044484
        struct[0].Gy_ini[155,82] = -1.84896616921897
        struct[0].Gy_ini[155,83] = -9.21038227100566
        struct[0].Gy_ini[155,84] = -5.65456401516768
        struct[0].Gy_ini[155,85] = 30.9517475172273
        struct[0].Gy_ini[155,86] = -1.84896616921897
        struct[0].Gy_ini[155,87] = -9.21038227100566
        struct[0].Gy_ini[155,152] = 1.84896616921897
        struct[0].Gy_ini[155,153] = 9.21038227100566
        struct[0].Gy_ini[155,154] = 5.65456401516768
        struct[0].Gy_ini[155,155] = -30.9517475172273
        struct[0].Gy_ini[156,20] = 9.21038227100566
        struct[0].Gy_ini[156,21] = -1.84896616921897
        struct[0].Gy_ini[156,22] = 9.00835072044485
        struct[0].Gy_ini[156,23] = -0.793238195499528
        struct[0].Gy_ini[156,104] = -9.21038227100566
        struct[0].Gy_ini[156,105] = 1.84896616921897
        struct[0].Gy_ini[156,106] = 30.9517475172273
        struct[0].Gy_ini[156,107] = 5.65456401516768
        struct[0].Gy_ini[156,108] = -9.21038227100566
        struct[0].Gy_ini[156,109] = 1.84896616921897
        struct[0].Gy_ini[156,110] = -9.00835072044485
        struct[0].Gy_ini[156,111] = 0.793238195499528
        struct[0].Gy_ini[156,156] = -30.9517475172273
        struct[0].Gy_ini[156,157] = -5.65456401516768
        struct[0].Gy_ini[156,158] = 9.21038227100566
        struct[0].Gy_ini[156,159] = -1.84896616921897
        struct[0].Gy_ini[157,20] = 1.84896616921897
        struct[0].Gy_ini[157,21] = 9.21038227100566
        struct[0].Gy_ini[157,22] = 0.793238195499528
        struct[0].Gy_ini[157,23] = 9.00835072044485
        struct[0].Gy_ini[157,104] = -1.84896616921897
        struct[0].Gy_ini[157,105] = -9.21038227100566
        struct[0].Gy_ini[157,106] = -5.65456401516768
        struct[0].Gy_ini[157,107] = 30.9517475172273
        struct[0].Gy_ini[157,108] = -1.84896616921897
        struct[0].Gy_ini[157,109] = -9.21038227100566
        struct[0].Gy_ini[157,110] = -0.793238195499528
        struct[0].Gy_ini[157,111] = -9.00835072044485
        struct[0].Gy_ini[157,156] = 5.65456401516768
        struct[0].Gy_ini[157,157] = -30.9517475172273
        struct[0].Gy_ini[157,158] = 1.84896616921897
        struct[0].Gy_ini[157,159] = 9.21038227100566
        struct[0].Gy_ini[158,20] = 9.00835072044484
        struct[0].Gy_ini[158,21] = -0.793238195499527
        struct[0].Gy_ini[158,22] = 9.21038227100566
        struct[0].Gy_ini[158,23] = -1.84896616921897
        struct[0].Gy_ini[158,104] = -9.00835072044484
        struct[0].Gy_ini[158,105] = 0.793238195499527
        struct[0].Gy_ini[158,106] = -9.21038227100566
        struct[0].Gy_ini[158,107] = 1.84896616921897
        struct[0].Gy_ini[158,108] = 30.9517475172273
        struct[0].Gy_ini[158,109] = 5.65456401516768
        struct[0].Gy_ini[158,110] = -9.21038227100566
        struct[0].Gy_ini[158,111] = 1.84896616921897
        struct[0].Gy_ini[158,156] = 9.21038227100566
        struct[0].Gy_ini[158,157] = -1.84896616921897
        struct[0].Gy_ini[158,158] = -30.9517475172273
        struct[0].Gy_ini[158,159] = -5.65456401516768
        struct[0].Gy_ini[159,20] = 0.793238195499527
        struct[0].Gy_ini[159,21] = 9.00835072044484
        struct[0].Gy_ini[159,22] = 1.84896616921897
        struct[0].Gy_ini[159,23] = 9.21038227100566
        struct[0].Gy_ini[159,104] = -0.793238195499527
        struct[0].Gy_ini[159,105] = -9.00835072044484
        struct[0].Gy_ini[159,106] = -1.84896616921897
        struct[0].Gy_ini[159,107] = -9.21038227100566
        struct[0].Gy_ini[159,108] = -5.65456401516768
        struct[0].Gy_ini[159,109] = 30.9517475172273
        struct[0].Gy_ini[159,110] = -1.84896616921897
        struct[0].Gy_ini[159,111] = -9.21038227100566
        struct[0].Gy_ini[159,156] = 1.84896616921897
        struct[0].Gy_ini[159,157] = 9.21038227100566
        struct[0].Gy_ini[159,158] = 5.65456401516768
        struct[0].Gy_ini[159,159] = -30.9517475172273
        struct[0].Gy_ini[160,24] = 9.21038227100566
        struct[0].Gy_ini[160,25] = -1.84896616921897
        struct[0].Gy_ini[160,26] = 9.00835072044485
        struct[0].Gy_ini[160,27] = -0.793238195499528
        struct[0].Gy_ini[160,112] = -9.21038227100566
        struct[0].Gy_ini[160,113] = 1.84896616921897
        struct[0].Gy_ini[160,114] = 30.9517475172273
        struct[0].Gy_ini[160,115] = 5.65456401516768
        struct[0].Gy_ini[160,116] = -9.21038227100566
        struct[0].Gy_ini[160,117] = 1.84896616921897
        struct[0].Gy_ini[160,118] = -9.00835072044485
        struct[0].Gy_ini[160,119] = 0.793238195499528
        struct[0].Gy_ini[160,160] = -30.9517475172273
        struct[0].Gy_ini[160,161] = -5.65456401516768
        struct[0].Gy_ini[160,162] = 9.21038227100566
        struct[0].Gy_ini[160,163] = -1.84896616921897
        struct[0].Gy_ini[161,24] = 1.84896616921897
        struct[0].Gy_ini[161,25] = 9.21038227100566
        struct[0].Gy_ini[161,26] = 0.793238195499528
        struct[0].Gy_ini[161,27] = 9.00835072044485
        struct[0].Gy_ini[161,112] = -1.84896616921897
        struct[0].Gy_ini[161,113] = -9.21038227100566
        struct[0].Gy_ini[161,114] = -5.65456401516768
        struct[0].Gy_ini[161,115] = 30.9517475172273
        struct[0].Gy_ini[161,116] = -1.84896616921897
        struct[0].Gy_ini[161,117] = -9.21038227100566
        struct[0].Gy_ini[161,118] = -0.793238195499528
        struct[0].Gy_ini[161,119] = -9.00835072044485
        struct[0].Gy_ini[161,160] = 5.65456401516768
        struct[0].Gy_ini[161,161] = -30.9517475172273
        struct[0].Gy_ini[161,162] = 1.84896616921897
        struct[0].Gy_ini[161,163] = 9.21038227100566
        struct[0].Gy_ini[162,24] = 9.00835072044484
        struct[0].Gy_ini[162,25] = -0.793238195499527
        struct[0].Gy_ini[162,26] = 9.21038227100566
        struct[0].Gy_ini[162,27] = -1.84896616921897
        struct[0].Gy_ini[162,112] = -9.00835072044484
        struct[0].Gy_ini[162,113] = 0.793238195499527
        struct[0].Gy_ini[162,114] = -9.21038227100566
        struct[0].Gy_ini[162,115] = 1.84896616921897
        struct[0].Gy_ini[162,116] = 30.9517475172273
        struct[0].Gy_ini[162,117] = 5.65456401516768
        struct[0].Gy_ini[162,118] = -9.21038227100566
        struct[0].Gy_ini[162,119] = 1.84896616921897
        struct[0].Gy_ini[162,160] = 9.21038227100566
        struct[0].Gy_ini[162,161] = -1.84896616921897
        struct[0].Gy_ini[162,162] = -30.9517475172273
        struct[0].Gy_ini[162,163] = -5.65456401516768
        struct[0].Gy_ini[163,24] = 0.793238195499527
        struct[0].Gy_ini[163,25] = 9.00835072044484
        struct[0].Gy_ini[163,26] = 1.84896616921897
        struct[0].Gy_ini[163,27] = 9.21038227100566
        struct[0].Gy_ini[163,112] = -0.793238195499527
        struct[0].Gy_ini[163,113] = -9.00835072044484
        struct[0].Gy_ini[163,114] = -1.84896616921897
        struct[0].Gy_ini[163,115] = -9.21038227100566
        struct[0].Gy_ini[163,116] = -5.65456401516768
        struct[0].Gy_ini[163,117] = 30.9517475172273
        struct[0].Gy_ini[163,118] = -1.84896616921897
        struct[0].Gy_ini[163,119] = -9.21038227100566
        struct[0].Gy_ini[163,160] = 1.84896616921897
        struct[0].Gy_ini[163,161] = 9.21038227100566
        struct[0].Gy_ini[163,162] = 5.65456401516768
        struct[0].Gy_ini[163,163] = -30.9517475172273
        struct[0].Gy_ini[164,164] = -1067.70480704130
        struct[0].Gy_ini[164,172] = 67.7048070412999
        struct[0].Gy_ini[165,165] = -1067.70480704130
        struct[0].Gy_ini[165,173] = 67.7048070412999
        struct[0].Gy_ini[166,32] = 157.977883096366
        struct[0].Gy_ini[166,166] = -361.092304220266
        struct[0].Gy_ini[166,174] = 135.409614082600
        struct[0].Gy_ini[167,33] = 157.977883096366
        struct[0].Gy_ini[167,167] = -361.092304220266
        struct[0].Gy_ini[167,175] = 135.409614082600
        struct[0].Gy_ini[168,168] = -361.092304220266
        struct[0].Gy_ini[168,176] = 135.409614082600
        struct[0].Gy_ini[168,206] = 157.977883096366
        struct[0].Gy_ini[169,169] = -361.092304220266
        struct[0].Gy_ini[169,177] = 135.409614082600
        struct[0].Gy_ini[169,207] = 157.977883096366
        struct[0].Gy_ini[170,170] = -361.092304220266
        struct[0].Gy_ini[170,178] = 135.409614082600
        struct[0].Gy_ini[170,208] = 157.977883096366
        struct[0].Gy_ini[171,171] = -361.092304220266
        struct[0].Gy_ini[171,179] = 135.409614082600
        struct[0].Gy_ini[171,209] = 157.977883096366
        struct[0].Gy_ini[172,34] = 157.977883096366
        struct[0].Gy_ini[172,164] = 67.7048070412999
        struct[0].Gy_ini[172,172] = -361.092304220266
        struct[0].Gy_ini[172,180] = 135.409614082600
        struct[0].Gy_ini[173,35] = 157.977883096366
        struct[0].Gy_ini[173,165] = 67.7048070412999
        struct[0].Gy_ini[173,173] = -361.092304220266
        struct[0].Gy_ini[173,181] = 135.409614082600
        struct[0].Gy_ini[174,166] = 135.409614082600
        struct[0].Gy_ini[174,174] = -248.250959151433
        struct[0].Gy_ini[174,182] = 67.7048070412999
        struct[0].Gy_ini[174,222] = 45.1365380275333
        struct[0].Gy_ini[175,167] = 135.409614082600
        struct[0].Gy_ini[175,175] = -248.250959151433
        struct[0].Gy_ini[175,183] = 67.7048070412999
        struct[0].Gy_ini[175,223] = 45.1365380275333
        struct[0].Gy_ini[176,168] = 135.409614082600
        struct[0].Gy_ini[176,176] = -248.250959151433
        struct[0].Gy_ini[176,184] = 67.7048070412999
        struct[0].Gy_ini[176,224] = 45.1365380275333
        struct[0].Gy_ini[177,169] = 135.409614082600
        struct[0].Gy_ini[177,177] = -248.250959151433
        struct[0].Gy_ini[177,185] = 67.7048070412999
        struct[0].Gy_ini[177,225] = 45.1365380275333
        struct[0].Gy_ini[178,170] = 135.409614082600
        struct[0].Gy_ini[178,178] = -248.250959151433
        struct[0].Gy_ini[178,186] = 67.7048070412999
        struct[0].Gy_ini[178,226] = 45.1365380275333
        struct[0].Gy_ini[179,171] = 135.409614082600
        struct[0].Gy_ini[179,179] = -248.250959151433
        struct[0].Gy_ini[179,187] = 67.7048070412999
        struct[0].Gy_ini[179,227] = 45.1365380275333
        struct[0].Gy_ini[180,172] = 135.409614082600
        struct[0].Gy_ini[180,180] = -248.250959151433
        struct[0].Gy_ini[180,188] = 67.7048070412999
        struct[0].Gy_ini[180,228] = 45.1365380275333
        struct[0].Gy_ini[181,173] = 135.409614082600
        struct[0].Gy_ini[181,181] = -248.250959151433
        struct[0].Gy_ini[181,189] = 67.7048070412999
        struct[0].Gy_ini[181,229] = 45.1365380275333
        struct[0].Gy_ini[182,36] = 157.977883096366
        struct[0].Gy_ini[182,174] = 67.7048070412999
        struct[0].Gy_ini[182,182] = -270.819228165200
        struct[0].Gy_ini[182,190] = 45.1365380275333
        struct[0].Gy_ini[183,37] = 157.977883096366
        struct[0].Gy_ini[183,175] = 67.7048070412999
        struct[0].Gy_ini[183,183] = -270.819228165200
        struct[0].Gy_ini[183,191] = 45.1365380275333
        struct[0].Gy_ini[184,176] = 67.7048070412999
        struct[0].Gy_ini[184,184] = -270.819228165200
        struct[0].Gy_ini[184,192] = 45.1365380275333
        struct[0].Gy_ini[184,210] = 157.977883096366
        struct[0].Gy_ini[185,177] = 67.7048070412999
        struct[0].Gy_ini[185,185] = -270.819228165200
        struct[0].Gy_ini[185,193] = 45.1365380275333
        struct[0].Gy_ini[185,211] = 157.977883096366
        struct[0].Gy_ini[186,178] = 67.7048070412999
        struct[0].Gy_ini[186,186] = -270.819228165200
        struct[0].Gy_ini[186,194] = 45.1365380275333
        struct[0].Gy_ini[186,212] = 157.977883096366
        struct[0].Gy_ini[187,179] = 67.7048070412999
        struct[0].Gy_ini[187,187] = -270.819228165200
        struct[0].Gy_ini[187,195] = 45.1365380275333
        struct[0].Gy_ini[187,213] = 157.977883096366
        struct[0].Gy_ini[188,38] = 157.977883096366
        struct[0].Gy_ini[188,180] = 67.7048070412999
        struct[0].Gy_ini[188,188] = -270.819228165200
        struct[0].Gy_ini[188,196] = 45.1365380275333
        struct[0].Gy_ini[189,39] = 157.977883096366
        struct[0].Gy_ini[189,181] = 67.7048070412999
        struct[0].Gy_ini[189,189] = -270.819228165200
        struct[0].Gy_ini[189,197] = 45.1365380275333
        struct[0].Gy_ini[190,40] = 157.977883096366
        struct[0].Gy_ini[190,182] = 45.1365380275333
        struct[0].Gy_ini[190,190] = -361.092304220266
        struct[0].Gy_ini[190,198] = 157.977883096366
        struct[0].Gy_ini[191,41] = 157.977883096366
        struct[0].Gy_ini[191,183] = 45.1365380275333
        struct[0].Gy_ini[191,191] = -361.092304220266
        struct[0].Gy_ini[191,199] = 157.977883096366
        struct[0].Gy_ini[192,184] = 45.1365380275333
        struct[0].Gy_ini[192,192] = -361.092304220266
        struct[0].Gy_ini[192,200] = 157.977883096366
        struct[0].Gy_ini[192,214] = 157.977883096366
        struct[0].Gy_ini[193,185] = 45.1365380275333
        struct[0].Gy_ini[193,193] = -361.092304220266
        struct[0].Gy_ini[193,201] = 157.977883096366
        struct[0].Gy_ini[193,215] = 157.977883096366
        struct[0].Gy_ini[194,186] = 45.1365380275333
        struct[0].Gy_ini[194,194] = -361.092304220266
        struct[0].Gy_ini[194,202] = 157.977883096366
        struct[0].Gy_ini[194,216] = 157.977883096366
        struct[0].Gy_ini[195,187] = 45.1365380275333
        struct[0].Gy_ini[195,195] = -361.092304220266
        struct[0].Gy_ini[195,203] = 157.977883096366
        struct[0].Gy_ini[195,217] = 157.977883096366
        struct[0].Gy_ini[196,42] = 157.977883096366
        struct[0].Gy_ini[196,188] = 45.1365380275333
        struct[0].Gy_ini[196,196] = -361.092304220266
        struct[0].Gy_ini[196,204] = 157.977883096366
        struct[0].Gy_ini[197,43] = 157.977883096366
        struct[0].Gy_ini[197,189] = 45.1365380275333
        struct[0].Gy_ini[197,197] = -361.092304220266
        struct[0].Gy_ini[197,205] = 157.977883096366
        struct[0].Gy_ini[198,44] = 157.977883096366
        struct[0].Gy_ini[198,190] = 157.977883096366
        struct[0].Gy_ini[198,198] = -315.955766192733
        struct[0].Gy_ini[198,401] = 1
        struct[0].Gy_ini[199,45] = 157.977883096366
        struct[0].Gy_ini[199,191] = 157.977883096366
        struct[0].Gy_ini[199,199] = -315.955766192733
        struct[0].Gy_ini[200,192] = 157.977883096366
        struct[0].Gy_ini[200,200] = -315.955766192733
        struct[0].Gy_ini[200,218] = 157.977883096366
        struct[0].Gy_ini[201,193] = 157.977883096366
        struct[0].Gy_ini[201,201] = -315.955766192733
        struct[0].Gy_ini[201,219] = 157.977883096366
        struct[0].Gy_ini[202,194] = 157.977883096366
        struct[0].Gy_ini[202,202] = -315.955766192733
        struct[0].Gy_ini[202,220] = 157.977883096366
        struct[0].Gy_ini[203,195] = 157.977883096366
        struct[0].Gy_ini[203,203] = -315.955766192733
        struct[0].Gy_ini[203,221] = 157.977883096366
        struct[0].Gy_ini[204,46] = 157.977883096366
        struct[0].Gy_ini[204,196] = 157.977883096366
        struct[0].Gy_ini[204,204] = -315.955766192733
        struct[0].Gy_ini[204,402] = 1
        struct[0].Gy_ini[205,47] = 157.977883096366
        struct[0].Gy_ini[205,197] = 157.977883096366
        struct[0].Gy_ini[205,205] = -315.955766192733
        struct[0].Gy_ini[206,168] = 157.977883096366
        struct[0].Gy_ini[206,206] = -157.977883096366
        struct[0].Gy_ini[207,169] = 157.977883096366
        struct[0].Gy_ini[207,207] = -157.977883096366
        struct[0].Gy_ini[208,170] = 157.977883096366
        struct[0].Gy_ini[208,208] = -157.977883096366
        struct[0].Gy_ini[209,171] = 157.977883096366
        struct[0].Gy_ini[209,209] = -157.977883096366
        struct[0].Gy_ini[210,184] = 157.977883096366
        struct[0].Gy_ini[210,210] = -157.977883096366
        struct[0].Gy_ini[211,185] = 157.977883096366
        struct[0].Gy_ini[211,211] = -157.977883096366
        struct[0].Gy_ini[212,186] = 157.977883096366
        struct[0].Gy_ini[212,212] = -157.977883096366
        struct[0].Gy_ini[213,187] = 157.977883096366
        struct[0].Gy_ini[213,213] = -157.977883096366
        struct[0].Gy_ini[214,192] = 157.977883096366
        struct[0].Gy_ini[214,214] = -157.977883096366
        struct[0].Gy_ini[215,193] = 157.977883096366
        struct[0].Gy_ini[215,215] = -157.977883096366
        struct[0].Gy_ini[216,194] = 157.977883096366
        struct[0].Gy_ini[216,216] = -157.977883096366
        struct[0].Gy_ini[217,195] = 157.977883096366
        struct[0].Gy_ini[217,217] = -157.977883096366
        struct[0].Gy_ini[218,200] = 157.977883096366
        struct[0].Gy_ini[218,218] = -157.977883096366
        struct[0].Gy_ini[219,201] = 157.977883096366
        struct[0].Gy_ini[219,219] = -157.977883096366
        struct[0].Gy_ini[220,202] = 157.977883096366
        struct[0].Gy_ini[220,220] = -157.977883096366
        struct[0].Gy_ini[221,203] = 157.977883096366
        struct[0].Gy_ini[221,221] = -157.977883096366
        struct[0].Gy_ini[222,28] = 135.409614082600
        struct[0].Gy_ini[222,174] = 45.1365380275333
        struct[0].Gy_ini[222,222] = -180.546152110133
        struct[0].Gy_ini[222,412] = 1
        struct[0].Gy_ini[223,29] = 135.409614082600
        struct[0].Gy_ini[223,175] = 45.1365380275333
        struct[0].Gy_ini[223,223] = -180.546152110133
        struct[0].Gy_ini[224,176] = 45.1365380275333
        struct[0].Gy_ini[224,224] = -180.546152110133
        struct[0].Gy_ini[224,230] = 135.409614082600
        struct[0].Gy_ini[225,177] = 45.1365380275333
        struct[0].Gy_ini[225,225] = -180.546152110133
        struct[0].Gy_ini[225,231] = 135.409614082600
        struct[0].Gy_ini[226,178] = 45.1365380275333
        struct[0].Gy_ini[226,226] = -180.546152110133
        struct[0].Gy_ini[226,232] = 135.409614082600
        struct[0].Gy_ini[227,179] = 45.1365380275333
        struct[0].Gy_ini[227,227] = -180.546152110133
        struct[0].Gy_ini[227,233] = 135.409614082600
        struct[0].Gy_ini[228,30] = 135.409614082600
        struct[0].Gy_ini[228,180] = 45.1365380275333
        struct[0].Gy_ini[228,228] = -180.546152110133
        struct[0].Gy_ini[228,413] = 1
        struct[0].Gy_ini[229,31] = 135.409614082600
        struct[0].Gy_ini[229,181] = 45.1365380275333
        struct[0].Gy_ini[229,229] = -180.546152110133
        struct[0].Gy_ini[230,224] = 135.409614082600
        struct[0].Gy_ini[230,230] = -135.409614082600
        struct[0].Gy_ini[231,225] = 135.409614082600
        struct[0].Gy_ini[231,231] = -135.409614082600
        struct[0].Gy_ini[232,226] = 135.409614082600
        struct[0].Gy_ini[232,232] = -135.409614082600
        struct[0].Gy_ini[233,227] = 135.409614082600
        struct[0].Gy_ini[233,233] = -135.409614082600
        struct[0].Gy_ini[234,0] = -0.212261128378539
        struct[0].Gy_ini[234,1] = -0.849044513514155
        struct[0].Gy_ini[234,2] = 0.212261128378539
        struct[0].Gy_ini[234,3] = 0.849044513514155
        struct[0].Gy_ini[234,234] = -1
        struct[0].Gy_ini[235,0] = 0.849044513514155
        struct[0].Gy_ini[235,1] = -0.212261128378539
        struct[0].Gy_ini[235,2] = -0.849044513514155
        struct[0].Gy_ini[235,3] = 0.212261128378539
        struct[0].Gy_ini[235,235] = -1
        struct[0].Gy_ini[236,2] = -0.212261128378539
        struct[0].Gy_ini[236,3] = -0.849044513514155
        struct[0].Gy_ini[236,4] = 0.212261128378539
        struct[0].Gy_ini[236,5] = 0.849044513514155
        struct[0].Gy_ini[236,236] = -1
        struct[0].Gy_ini[237,2] = 0.849044513514155
        struct[0].Gy_ini[237,3] = -0.212261128378539
        struct[0].Gy_ini[237,4] = -0.849044513514155
        struct[0].Gy_ini[237,5] = 0.212261128378539
        struct[0].Gy_ini[237,237] = -1
        struct[0].Gy_ini[238,0] = 0.212261128378539
        struct[0].Gy_ini[238,1] = 0.849044513514155
        struct[0].Gy_ini[238,4] = -0.212261128378539
        struct[0].Gy_ini[238,5] = -0.849044513514155
        struct[0].Gy_ini[238,238] = -1
        struct[0].Gy_ini[239,0] = -0.849044513514155
        struct[0].Gy_ini[239,1] = 0.212261128378539
        struct[0].Gy_ini[239,4] = 0.849044513514155
        struct[0].Gy_ini[239,5] = -0.212261128378539
        struct[0].Gy_ini[239,239] = -1
        struct[0].Gy_ini[240,0] = 105.571769313180
        struct[0].Gy_ini[240,1] = 54.0657727682604
        struct[0].Gy_ini[240,2] = -39.6392229058202
        struct[0].Gy_ini[240,3] = -10.2713736253513
        struct[0].Gy_ini[240,4] = -24.9575997948692
        struct[0].Gy_ini[240,5] = -23.2849644809540
        struct[0].Gy_ini[240,6] = -39.6392229058202
        struct[0].Gy_ini[240,7] = -10.2713736253513
        struct[0].Gy_ini[240,48] = -105.571769313180
        struct[0].Gy_ini[240,49] = -54.0657727682604
        struct[0].Gy_ini[240,50] = 39.6392229058202
        struct[0].Gy_ini[240,51] = 10.2713736253513
        struct[0].Gy_ini[240,52] = 24.9575997948692
        struct[0].Gy_ini[240,53] = 23.2849644809540
        struct[0].Gy_ini[240,54] = 39.6392229058202
        struct[0].Gy_ini[240,55] = 10.2713736253513
        struct[0].Gy_ini[240,240] = -1
        struct[0].Gy_ini[241,0] = -54.0657727682604
        struct[0].Gy_ini[241,1] = 105.571769313180
        struct[0].Gy_ini[241,2] = 10.2713736253513
        struct[0].Gy_ini[241,3] = -39.6392229058202
        struct[0].Gy_ini[241,4] = 23.2849644809540
        struct[0].Gy_ini[241,5] = -24.9575997948692
        struct[0].Gy_ini[241,6] = 10.2713736253513
        struct[0].Gy_ini[241,7] = -39.6392229058202
        struct[0].Gy_ini[241,48] = 54.0657727682604
        struct[0].Gy_ini[241,49] = -105.571769313180
        struct[0].Gy_ini[241,50] = -10.2713736253513
        struct[0].Gy_ini[241,51] = 39.6392229058202
        struct[0].Gy_ini[241,52] = -23.2849644809540
        struct[0].Gy_ini[241,53] = 24.9575997948692
        struct[0].Gy_ini[241,54] = -10.2713736253513
        struct[0].Gy_ini[241,55] = 39.6392229058202
        struct[0].Gy_ini[241,241] = -1
        struct[0].Gy_ini[242,0] = -39.6392229058202
        struct[0].Gy_ini[242,1] = -10.2713736253513
        struct[0].Gy_ini[242,2] = 105.571769313180
        struct[0].Gy_ini[242,3] = 54.0657727682604
        struct[0].Gy_ini[242,4] = -39.6392229058201
        struct[0].Gy_ini[242,5] = -10.2713736253513
        struct[0].Gy_ini[242,6] = -24.9575997948692
        struct[0].Gy_ini[242,7] = -23.2849644809540
        struct[0].Gy_ini[242,48] = 39.6392229058202
        struct[0].Gy_ini[242,49] = 10.2713736253513
        struct[0].Gy_ini[242,50] = -105.571769313180
        struct[0].Gy_ini[242,51] = -54.0657727682604
        struct[0].Gy_ini[242,52] = 39.6392229058201
        struct[0].Gy_ini[242,53] = 10.2713736253513
        struct[0].Gy_ini[242,54] = 24.9575997948692
        struct[0].Gy_ini[242,55] = 23.2849644809540
        struct[0].Gy_ini[242,242] = -1
        struct[0].Gy_ini[243,0] = 10.2713736253513
        struct[0].Gy_ini[243,1] = -39.6392229058202
        struct[0].Gy_ini[243,2] = -54.0657727682604
        struct[0].Gy_ini[243,3] = 105.571769313180
        struct[0].Gy_ini[243,4] = 10.2713736253513
        struct[0].Gy_ini[243,5] = -39.6392229058201
        struct[0].Gy_ini[243,6] = 23.2849644809540
        struct[0].Gy_ini[243,7] = -24.9575997948692
        struct[0].Gy_ini[243,48] = -10.2713736253513
        struct[0].Gy_ini[243,49] = 39.6392229058202
        struct[0].Gy_ini[243,50] = 54.0657727682604
        struct[0].Gy_ini[243,51] = -105.571769313180
        struct[0].Gy_ini[243,52] = -10.2713736253513
        struct[0].Gy_ini[243,53] = 39.6392229058201
        struct[0].Gy_ini[243,54] = -23.2849644809540
        struct[0].Gy_ini[243,55] = 24.9575997948692
        struct[0].Gy_ini[243,243] = -1
        struct[0].Gy_ini[244,0] = -24.9575997948692
        struct[0].Gy_ini[244,1] = -23.2849644809540
        struct[0].Gy_ini[244,2] = -39.6392229058202
        struct[0].Gy_ini[244,3] = -10.2713736253513
        struct[0].Gy_ini[244,4] = 105.571769313180
        struct[0].Gy_ini[244,5] = 54.0657727682604
        struct[0].Gy_ini[244,6] = -39.6392229058201
        struct[0].Gy_ini[244,7] = -10.2713736253514
        struct[0].Gy_ini[244,48] = 24.9575997948692
        struct[0].Gy_ini[244,49] = 23.2849644809540
        struct[0].Gy_ini[244,50] = 39.6392229058202
        struct[0].Gy_ini[244,51] = 10.2713736253513
        struct[0].Gy_ini[244,52] = -105.571769313180
        struct[0].Gy_ini[244,53] = -54.0657727682604
        struct[0].Gy_ini[244,54] = 39.6392229058201
        struct[0].Gy_ini[244,55] = 10.2713736253514
        struct[0].Gy_ini[244,244] = -1
        struct[0].Gy_ini[245,0] = 23.2849644809540
        struct[0].Gy_ini[245,1] = -24.9575997948692
        struct[0].Gy_ini[245,2] = 10.2713736253513
        struct[0].Gy_ini[245,3] = -39.6392229058202
        struct[0].Gy_ini[245,4] = -54.0657727682604
        struct[0].Gy_ini[245,5] = 105.571769313180
        struct[0].Gy_ini[245,6] = 10.2713736253514
        struct[0].Gy_ini[245,7] = -39.6392229058201
        struct[0].Gy_ini[245,48] = -23.2849644809540
        struct[0].Gy_ini[245,49] = 24.9575997948692
        struct[0].Gy_ini[245,50] = -10.2713736253513
        struct[0].Gy_ini[245,51] = 39.6392229058202
        struct[0].Gy_ini[245,52] = 54.0657727682604
        struct[0].Gy_ini[245,53] = -105.571769313180
        struct[0].Gy_ini[245,54] = -10.2713736253514
        struct[0].Gy_ini[245,55] = 39.6392229058201
        struct[0].Gy_ini[245,245] = -1
        struct[0].Gy_ini[246,240] = 1
        struct[0].Gy_ini[246,242] = 1
        struct[0].Gy_ini[246,244] = 1
        struct[0].Gy_ini[246,246] = -1
        struct[0].Gy_ini[247,241] = 1
        struct[0].Gy_ini[247,243] = 1
        struct[0].Gy_ini[247,245] = 1
        struct[0].Gy_ini[247,247] = -1
        struct[0].Gy_ini[248,166] = -67.7048070412999
        struct[0].Gy_ini[248,248] = -1
        struct[0].Gy_ini[249,167] = -67.7048070412999
        struct[0].Gy_ini[249,249] = -1
        struct[0].Gy_ini[250,168] = -67.7048070412999
        struct[0].Gy_ini[250,250] = -1
        struct[0].Gy_ini[251,169] = -67.7048070412999
        struct[0].Gy_ini[251,251] = -1
        struct[0].Gy_ini[252,170] = -67.7048070412999
        struct[0].Gy_ini[252,252] = -1
        struct[0].Gy_ini[253,171] = -67.7048070412999
        struct[0].Gy_ini[253,253] = -1
        struct[0].Gy_ini[254,248] = 1
        struct[0].Gy_ini[254,250] = 1
        struct[0].Gy_ini[254,252] = 1
        struct[0].Gy_ini[254,254] = -1
        struct[0].Gy_ini[255,249] = 1
        struct[0].Gy_ini[255,251] = 1
        struct[0].Gy_ini[255,253] = 1
        struct[0].Gy_ini[255,255] = -1
        struct[0].Gy_ini[256,166] = 135.409614082600
        struct[0].Gy_ini[256,174] = -135.409614082600
        struct[0].Gy_ini[256,256] = -1
        struct[0].Gy_ini[257,167] = 135.409614082600
        struct[0].Gy_ini[257,175] = -135.409614082600
        struct[0].Gy_ini[257,257] = -1
        struct[0].Gy_ini[258,168] = 135.409614082600
        struct[0].Gy_ini[258,176] = -135.409614082600
        struct[0].Gy_ini[258,258] = -1
        struct[0].Gy_ini[259,169] = 135.409614082600
        struct[0].Gy_ini[259,177] = -135.409614082600
        struct[0].Gy_ini[259,259] = -1
        struct[0].Gy_ini[260,170] = 135.409614082600
        struct[0].Gy_ini[260,178] = -135.409614082600
        struct[0].Gy_ini[260,260] = -1
        struct[0].Gy_ini[261,171] = 135.409614082600
        struct[0].Gy_ini[261,179] = -135.409614082600
        struct[0].Gy_ini[261,261] = -1
        struct[0].Gy_ini[262,256] = 1
        struct[0].Gy_ini[262,258] = 1
        struct[0].Gy_ini[262,260] = 1
        struct[0].Gy_ini[262,262] = -1
        struct[0].Gy_ini[263,257] = 1
        struct[0].Gy_ini[263,259] = 1
        struct[0].Gy_ini[263,261] = 1
        struct[0].Gy_ini[263,263] = -1
        struct[0].Gy_ini[264,174] = 67.7048070412999
        struct[0].Gy_ini[264,182] = -67.7048070412999
        struct[0].Gy_ini[264,264] = -1
        struct[0].Gy_ini[265,175] = 67.7048070412999
        struct[0].Gy_ini[265,183] = -67.7048070412999
        struct[0].Gy_ini[265,265] = -1
        struct[0].Gy_ini[266,176] = 67.7048070412999
        struct[0].Gy_ini[266,184] = -67.7048070412999
        struct[0].Gy_ini[266,266] = -1
        struct[0].Gy_ini[267,177] = 67.7048070412999
        struct[0].Gy_ini[267,185] = -67.7048070412999
        struct[0].Gy_ini[267,267] = -1
        struct[0].Gy_ini[268,178] = 67.7048070412999
        struct[0].Gy_ini[268,186] = -67.7048070412999
        struct[0].Gy_ini[268,268] = -1
        struct[0].Gy_ini[269,179] = 67.7048070412999
        struct[0].Gy_ini[269,187] = -67.7048070412999
        struct[0].Gy_ini[269,269] = -1
        struct[0].Gy_ini[270,264] = 1
        struct[0].Gy_ini[270,266] = 1
        struct[0].Gy_ini[270,268] = 1
        struct[0].Gy_ini[270,270] = -1
        struct[0].Gy_ini[271,265] = 1
        struct[0].Gy_ini[271,267] = 1
        struct[0].Gy_ini[271,269] = 1
        struct[0].Gy_ini[271,271] = -1
        struct[0].Gy_ini[272,182] = 45.1365380275333
        struct[0].Gy_ini[272,190] = -45.1365380275333
        struct[0].Gy_ini[272,272] = -1
        struct[0].Gy_ini[273,183] = 45.1365380275333
        struct[0].Gy_ini[273,191] = -45.1365380275333
        struct[0].Gy_ini[273,273] = -1
        struct[0].Gy_ini[274,184] = 45.1365380275333
        struct[0].Gy_ini[274,192] = -45.1365380275333
        struct[0].Gy_ini[274,274] = -1
        struct[0].Gy_ini[275,185] = 45.1365380275333
        struct[0].Gy_ini[275,193] = -45.1365380275333
        struct[0].Gy_ini[275,275] = -1
        struct[0].Gy_ini[276,186] = 45.1365380275333
        struct[0].Gy_ini[276,194] = -45.1365380275333
        struct[0].Gy_ini[276,276] = -1
        struct[0].Gy_ini[277,187] = 45.1365380275333
        struct[0].Gy_ini[277,195] = -45.1365380275333
        struct[0].Gy_ini[277,277] = -1
        struct[0].Gy_ini[278,272] = 1
        struct[0].Gy_ini[278,274] = 1
        struct[0].Gy_ini[278,276] = 1
        struct[0].Gy_ini[278,278] = -1
        struct[0].Gy_ini[279,273] = 1
        struct[0].Gy_ini[279,275] = 1
        struct[0].Gy_ini[279,277] = 1
        struct[0].Gy_ini[279,279] = -1
        struct[0].Gy_ini[280,190] = 157.977883096366
        struct[0].Gy_ini[280,198] = -157.977883096366
        struct[0].Gy_ini[280,280] = -1
        struct[0].Gy_ini[281,191] = 157.977883096366
        struct[0].Gy_ini[281,199] = -157.977883096366
        struct[0].Gy_ini[281,281] = -1
        struct[0].Gy_ini[282,192] = 157.977883096366
        struct[0].Gy_ini[282,200] = -157.977883096366
        struct[0].Gy_ini[282,282] = -1
        struct[0].Gy_ini[283,193] = 157.977883096366
        struct[0].Gy_ini[283,201] = -157.977883096366
        struct[0].Gy_ini[283,283] = -1
        struct[0].Gy_ini[284,194] = 157.977883096366
        struct[0].Gy_ini[284,202] = -157.977883096366
        struct[0].Gy_ini[284,284] = -1
        struct[0].Gy_ini[285,195] = 157.977883096366
        struct[0].Gy_ini[285,203] = -157.977883096366
        struct[0].Gy_ini[285,285] = -1
        struct[0].Gy_ini[286,280] = 1
        struct[0].Gy_ini[286,282] = 1
        struct[0].Gy_ini[286,284] = 1
        struct[0].Gy_ini[286,286] = -1
        struct[0].Gy_ini[287,281] = 1
        struct[0].Gy_ini[287,283] = 1
        struct[0].Gy_ini[287,285] = 1
        struct[0].Gy_ini[287,287] = -1
        struct[0].Gy_ini[288,32] = -157.977883096366
        struct[0].Gy_ini[288,166] = 157.977883096366
        struct[0].Gy_ini[288,288] = -1
        struct[0].Gy_ini[289,33] = -157.977883096366
        struct[0].Gy_ini[289,167] = 157.977883096366
        struct[0].Gy_ini[289,289] = -1
        struct[0].Gy_ini[290,168] = 157.977883096366
        struct[0].Gy_ini[290,206] = -157.977883096366
        struct[0].Gy_ini[290,290] = -1
        struct[0].Gy_ini[291,169] = 157.977883096366
        struct[0].Gy_ini[291,207] = -157.977883096366
        struct[0].Gy_ini[291,291] = -1
        struct[0].Gy_ini[292,170] = 157.977883096366
        struct[0].Gy_ini[292,208] = -157.977883096366
        struct[0].Gy_ini[292,292] = -1
        struct[0].Gy_ini[293,171] = 157.977883096366
        struct[0].Gy_ini[293,209] = -157.977883096366
        struct[0].Gy_ini[293,293] = -1
        struct[0].Gy_ini[294,288] = 1
        struct[0].Gy_ini[294,290] = 1
        struct[0].Gy_ini[294,292] = 1
        struct[0].Gy_ini[294,294] = -1
        struct[0].Gy_ini[295,289] = 1
        struct[0].Gy_ini[295,291] = 1
        struct[0].Gy_ini[295,293] = 1
        struct[0].Gy_ini[295,295] = -1
        struct[0].Gy_ini[296,36] = -157.977883096366
        struct[0].Gy_ini[296,182] = 157.977883096366
        struct[0].Gy_ini[296,296] = -1
        struct[0].Gy_ini[297,37] = -157.977883096366
        struct[0].Gy_ini[297,183] = 157.977883096366
        struct[0].Gy_ini[297,297] = -1
        struct[0].Gy_ini[298,184] = 157.977883096366
        struct[0].Gy_ini[298,210] = -157.977883096366
        struct[0].Gy_ini[298,298] = -1
        struct[0].Gy_ini[299,185] = 157.977883096366
        struct[0].Gy_ini[299,211] = -157.977883096366
        struct[0].Gy_ini[299,299] = -1
        struct[0].Gy_ini[300,186] = 157.977883096366
        struct[0].Gy_ini[300,212] = -157.977883096366
        struct[0].Gy_ini[300,300] = -1
        struct[0].Gy_ini[301,187] = 157.977883096366
        struct[0].Gy_ini[301,213] = -157.977883096366
        struct[0].Gy_ini[301,301] = -1
        struct[0].Gy_ini[302,296] = 1
        struct[0].Gy_ini[302,298] = 1
        struct[0].Gy_ini[302,300] = 1
        struct[0].Gy_ini[302,302] = -1
        struct[0].Gy_ini[303,297] = 1
        struct[0].Gy_ini[303,299] = 1
        struct[0].Gy_ini[303,301] = 1
        struct[0].Gy_ini[303,303] = -1
        struct[0].Gy_ini[304,40] = -157.977883096366
        struct[0].Gy_ini[304,190] = 157.977883096366
        struct[0].Gy_ini[304,304] = -1
        struct[0].Gy_ini[305,41] = -157.977883096366
        struct[0].Gy_ini[305,191] = 157.977883096366
        struct[0].Gy_ini[305,305] = -1
        struct[0].Gy_ini[306,192] = 157.977883096366
        struct[0].Gy_ini[306,214] = -157.977883096366
        struct[0].Gy_ini[306,306] = -1
        struct[0].Gy_ini[307,193] = 157.977883096366
        struct[0].Gy_ini[307,215] = -157.977883096366
        struct[0].Gy_ini[307,307] = -1
        struct[0].Gy_ini[308,194] = 157.977883096366
        struct[0].Gy_ini[308,216] = -157.977883096366
        struct[0].Gy_ini[308,308] = -1
        struct[0].Gy_ini[309,195] = 157.977883096366
        struct[0].Gy_ini[309,217] = -157.977883096366
        struct[0].Gy_ini[309,309] = -1
        struct[0].Gy_ini[310,304] = 1
        struct[0].Gy_ini[310,306] = 1
        struct[0].Gy_ini[310,308] = 1
        struct[0].Gy_ini[310,310] = -1
        struct[0].Gy_ini[311,305] = 1
        struct[0].Gy_ini[311,307] = 1
        struct[0].Gy_ini[311,309] = 1
        struct[0].Gy_ini[311,311] = -1
        struct[0].Gy_ini[312,44] = -157.977883096366
        struct[0].Gy_ini[312,198] = 157.977883096366
        struct[0].Gy_ini[312,312] = -1
        struct[0].Gy_ini[313,45] = -157.977883096366
        struct[0].Gy_ini[313,199] = 157.977883096366
        struct[0].Gy_ini[313,313] = -1
        struct[0].Gy_ini[314,200] = 157.977883096366
        struct[0].Gy_ini[314,218] = -157.977883096366
        struct[0].Gy_ini[314,314] = -1
        struct[0].Gy_ini[315,201] = 157.977883096366
        struct[0].Gy_ini[315,219] = -157.977883096366
        struct[0].Gy_ini[315,315] = -1
        struct[0].Gy_ini[316,202] = 157.977883096366
        struct[0].Gy_ini[316,220] = -157.977883096366
        struct[0].Gy_ini[316,316] = -1
        struct[0].Gy_ini[317,203] = 157.977883096366
        struct[0].Gy_ini[317,221] = -157.977883096366
        struct[0].Gy_ini[317,317] = -1
        struct[0].Gy_ini[318,312] = 1
        struct[0].Gy_ini[318,314] = 1
        struct[0].Gy_ini[318,316] = 1
        struct[0].Gy_ini[318,318] = -1
        struct[0].Gy_ini[319,313] = 1
        struct[0].Gy_ini[319,315] = 1
        struct[0].Gy_ini[319,317] = 1
        struct[0].Gy_ini[319,319] = -1
        struct[0].Gy_ini[320,174] = 45.1365380275333
        struct[0].Gy_ini[320,222] = -45.1365380275333
        struct[0].Gy_ini[320,320] = -1
        struct[0].Gy_ini[321,175] = 45.1365380275333
        struct[0].Gy_ini[321,223] = -45.1365380275333
        struct[0].Gy_ini[321,321] = -1
        struct[0].Gy_ini[322,176] = 45.1365380275333
        struct[0].Gy_ini[322,224] = -45.1365380275333
        struct[0].Gy_ini[322,322] = -1
        struct[0].Gy_ini[323,177] = 45.1365380275333
        struct[0].Gy_ini[323,225] = -45.1365380275333
        struct[0].Gy_ini[323,323] = -1
        struct[0].Gy_ini[324,178] = 45.1365380275333
        struct[0].Gy_ini[324,226] = -45.1365380275333
        struct[0].Gy_ini[324,324] = -1
        struct[0].Gy_ini[325,179] = 45.1365380275333
        struct[0].Gy_ini[325,227] = -45.1365380275333
        struct[0].Gy_ini[325,325] = -1
        struct[0].Gy_ini[326,320] = 1
        struct[0].Gy_ini[326,322] = 1
        struct[0].Gy_ini[326,324] = 1
        struct[0].Gy_ini[326,326] = -1
        struct[0].Gy_ini[327,321] = 1
        struct[0].Gy_ini[327,323] = 1
        struct[0].Gy_ini[327,325] = 1
        struct[0].Gy_ini[327,327] = -1
        struct[0].Gy_ini[328,28] = -135.409614082600
        struct[0].Gy_ini[328,222] = 135.409614082600
        struct[0].Gy_ini[328,328] = -1
        struct[0].Gy_ini[329,29] = -135.409614082600
        struct[0].Gy_ini[329,223] = 135.409614082600
        struct[0].Gy_ini[329,329] = -1
        struct[0].Gy_ini[330,224] = 135.409614082600
        struct[0].Gy_ini[330,230] = -135.409614082600
        struct[0].Gy_ini[330,330] = -1
        struct[0].Gy_ini[331,225] = 135.409614082600
        struct[0].Gy_ini[331,231] = -135.409614082600
        struct[0].Gy_ini[331,331] = -1
        struct[0].Gy_ini[332,226] = 135.409614082600
        struct[0].Gy_ini[332,232] = -135.409614082600
        struct[0].Gy_ini[332,332] = -1
        struct[0].Gy_ini[333,227] = 135.409614082600
        struct[0].Gy_ini[333,233] = -135.409614082600
        struct[0].Gy_ini[333,333] = -1
        struct[0].Gy_ini[334,328] = 1
        struct[0].Gy_ini[334,330] = 1
        struct[0].Gy_ini[334,332] = 1
        struct[0].Gy_ini[334,334] = -1
        struct[0].Gy_ini[335,329] = 1
        struct[0].Gy_ini[335,331] = 1
        struct[0].Gy_ini[335,333] = 1
        struct[0].Gy_ini[335,335] = -1
        struct[0].Gy_ini[336,0] = i_load_R1_a_r
        struct[0].Gy_ini[336,1] = i_load_R1_a_i
        struct[0].Gy_ini[336,6] = -i_load_R1_a_r
        struct[0].Gy_ini[336,7] = -i_load_R1_a_i
        struct[0].Gy_ini[336,336] = v_R1_a_r - v_R1_n_r
        struct[0].Gy_ini[336,337] = v_R1_a_i - v_R1_n_i
        struct[0].Gy_ini[337,2] = i_load_R1_b_r
        struct[0].Gy_ini[337,3] = i_load_R1_b_i
        struct[0].Gy_ini[337,6] = -i_load_R1_b_r
        struct[0].Gy_ini[337,7] = -i_load_R1_b_i
        struct[0].Gy_ini[337,338] = v_R1_b_r - v_R1_n_r
        struct[0].Gy_ini[337,339] = v_R1_b_i - v_R1_n_i
        struct[0].Gy_ini[338,4] = i_load_R1_c_r
        struct[0].Gy_ini[338,5] = i_load_R1_c_i
        struct[0].Gy_ini[338,6] = -i_load_R1_c_r
        struct[0].Gy_ini[338,7] = -i_load_R1_c_i
        struct[0].Gy_ini[338,340] = v_R1_c_r - v_R1_n_r
        struct[0].Gy_ini[338,341] = v_R1_c_i - v_R1_n_i
        struct[0].Gy_ini[339,0] = -i_load_R1_a_i
        struct[0].Gy_ini[339,1] = i_load_R1_a_r
        struct[0].Gy_ini[339,6] = i_load_R1_a_i
        struct[0].Gy_ini[339,7] = -i_load_R1_a_r
        struct[0].Gy_ini[339,336] = v_R1_a_i - v_R1_n_i
        struct[0].Gy_ini[339,337] = -v_R1_a_r + v_R1_n_r
        struct[0].Gy_ini[340,2] = -i_load_R1_b_i
        struct[0].Gy_ini[340,3] = i_load_R1_b_r
        struct[0].Gy_ini[340,6] = i_load_R1_b_i
        struct[0].Gy_ini[340,7] = -i_load_R1_b_r
        struct[0].Gy_ini[340,338] = v_R1_b_i - v_R1_n_i
        struct[0].Gy_ini[340,339] = -v_R1_b_r + v_R1_n_r
        struct[0].Gy_ini[341,4] = -i_load_R1_c_i
        struct[0].Gy_ini[341,5] = i_load_R1_c_r
        struct[0].Gy_ini[341,6] = i_load_R1_c_i
        struct[0].Gy_ini[341,7] = -i_load_R1_c_r
        struct[0].Gy_ini[341,340] = v_R1_c_i - v_R1_n_i
        struct[0].Gy_ini[341,341] = -v_R1_c_r + v_R1_n_r
        struct[0].Gy_ini[342,336] = 1
        struct[0].Gy_ini[342,338] = 1
        struct[0].Gy_ini[342,340] = 1
        struct[0].Gy_ini[342,342] = 1
        struct[0].Gy_ini[343,337] = 1
        struct[0].Gy_ini[343,339] = 1
        struct[0].Gy_ini[343,341] = 1
        struct[0].Gy_ini[343,343] = 1
        struct[0].Gy_ini[344,8] = i_load_R11_a_r
        struct[0].Gy_ini[344,9] = 1.0*i_load_R11_a_i
        struct[0].Gy_ini[344,10] = -i_load_R11_a_r
        struct[0].Gy_ini[344,11] = -1.0*i_load_R11_a_i
        struct[0].Gy_ini[344,344] = v_R11_a_r - v_R11_n_r
        struct[0].Gy_ini[344,345] = 1.0*v_R11_a_i - 1.0*v_R11_n_i
        struct[0].Gy_ini[345,8] = -1.0*i_load_R11_a_i
        struct[0].Gy_ini[345,9] = 1.0*i_load_R11_a_r
        struct[0].Gy_ini[345,10] = 1.0*i_load_R11_a_i
        struct[0].Gy_ini[345,11] = -1.0*i_load_R11_a_r
        struct[0].Gy_ini[345,344] = 1.0*v_R11_a_i - 1.0*v_R11_n_i
        struct[0].Gy_ini[345,345] = -1.0*v_R11_a_r + 1.0*v_R11_n_r
        struct[0].Gy_ini[346,344] = 1
        struct[0].Gy_ini[346,346] = 1
        struct[0].Gy_ini[347,345] = 1.00000000000000
        struct[0].Gy_ini[347,347] = 1.00000000000000
        struct[0].Gy_ini[348,12] = i_load_R15_a_r
        struct[0].Gy_ini[348,13] = 1.0*i_load_R15_a_i
        struct[0].Gy_ini[348,14] = -i_load_R15_a_r
        struct[0].Gy_ini[348,15] = -1.0*i_load_R15_a_i
        struct[0].Gy_ini[348,348] = v_R15_a_r - v_R15_n_r
        struct[0].Gy_ini[348,349] = 1.0*v_R15_a_i - 1.0*v_R15_n_i
        struct[0].Gy_ini[349,12] = -1.0*i_load_R15_a_i
        struct[0].Gy_ini[349,13] = 1.0*i_load_R15_a_r
        struct[0].Gy_ini[349,14] = 1.0*i_load_R15_a_i
        struct[0].Gy_ini[349,15] = -1.0*i_load_R15_a_r
        struct[0].Gy_ini[349,348] = 1.0*v_R15_a_i - 1.0*v_R15_n_i
        struct[0].Gy_ini[349,349] = -1.0*v_R15_a_r + 1.0*v_R15_n_r
        struct[0].Gy_ini[350,348] = 1
        struct[0].Gy_ini[350,350] = 1
        struct[0].Gy_ini[351,349] = 1.00000000000000
        struct[0].Gy_ini[351,351] = 1.00000000000000
        struct[0].Gy_ini[352,16] = i_load_R16_a_r
        struct[0].Gy_ini[352,17] = 1.0*i_load_R16_a_i
        struct[0].Gy_ini[352,18] = -i_load_R16_a_r
        struct[0].Gy_ini[352,19] = -1.0*i_load_R16_a_i
        struct[0].Gy_ini[352,352] = v_R16_a_r - v_R16_n_r
        struct[0].Gy_ini[352,353] = 1.0*v_R16_a_i - 1.0*v_R16_n_i
        struct[0].Gy_ini[353,16] = -1.0*i_load_R16_a_i
        struct[0].Gy_ini[353,17] = 1.0*i_load_R16_a_r
        struct[0].Gy_ini[353,18] = 1.0*i_load_R16_a_i
        struct[0].Gy_ini[353,19] = -1.0*i_load_R16_a_r
        struct[0].Gy_ini[353,352] = 1.0*v_R16_a_i - 1.0*v_R16_n_i
        struct[0].Gy_ini[353,353] = -1.0*v_R16_a_r + 1.0*v_R16_n_r
        struct[0].Gy_ini[354,352] = 1
        struct[0].Gy_ini[354,354] = 1
        struct[0].Gy_ini[355,353] = 1.00000000000000
        struct[0].Gy_ini[355,355] = 1.00000000000000
        struct[0].Gy_ini[356,20] = i_load_R17_a_r
        struct[0].Gy_ini[356,21] = 1.0*i_load_R17_a_i
        struct[0].Gy_ini[356,22] = -i_load_R17_a_r
        struct[0].Gy_ini[356,23] = -1.0*i_load_R17_a_i
        struct[0].Gy_ini[356,356] = v_R17_a_r - v_R17_n_r
        struct[0].Gy_ini[356,357] = 1.0*v_R17_a_i - 1.0*v_R17_n_i
        struct[0].Gy_ini[357,20] = -1.0*i_load_R17_a_i
        struct[0].Gy_ini[357,21] = 1.0*i_load_R17_a_r
        struct[0].Gy_ini[357,22] = 1.0*i_load_R17_a_i
        struct[0].Gy_ini[357,23] = -1.0*i_load_R17_a_r
        struct[0].Gy_ini[357,356] = 1.0*v_R17_a_i - 1.0*v_R17_n_i
        struct[0].Gy_ini[357,357] = -1.0*v_R17_a_r + 1.0*v_R17_n_r
        struct[0].Gy_ini[358,356] = 1
        struct[0].Gy_ini[358,358] = 1
        struct[0].Gy_ini[359,357] = 1.00000000000000
        struct[0].Gy_ini[359,359] = 1.00000000000000
        struct[0].Gy_ini[360,24] = i_load_R18_a_r
        struct[0].Gy_ini[360,25] = 1.0*i_load_R18_a_i
        struct[0].Gy_ini[360,26] = -i_load_R18_a_r
        struct[0].Gy_ini[360,27] = -1.0*i_load_R18_a_i
        struct[0].Gy_ini[360,360] = v_R18_a_r - v_R18_n_r
        struct[0].Gy_ini[360,361] = 1.0*v_R18_a_i - 1.0*v_R18_n_i
        struct[0].Gy_ini[361,24] = -1.0*i_load_R18_a_i
        struct[0].Gy_ini[361,25] = 1.0*i_load_R18_a_r
        struct[0].Gy_ini[361,26] = 1.0*i_load_R18_a_i
        struct[0].Gy_ini[361,27] = -1.0*i_load_R18_a_r
        struct[0].Gy_ini[361,360] = 1.0*v_R18_a_i - 1.0*v_R18_n_i
        struct[0].Gy_ini[361,361] = -1.0*v_R18_a_r + 1.0*v_R18_n_r
        struct[0].Gy_ini[362,360] = 1
        struct[0].Gy_ini[362,362] = 1
        struct[0].Gy_ini[363,361] = 1.00000000000000
        struct[0].Gy_ini[363,363] = 1.00000000000000
        struct[0].Gy_ini[364,28] = i_load_D15_a_r
        struct[0].Gy_ini[364,29] = 1.0*i_load_D15_a_i
        struct[0].Gy_ini[364,30] = -i_load_D15_a_r
        struct[0].Gy_ini[364,31] = -1.0*i_load_D15_a_i
        struct[0].Gy_ini[364,364] = v_D15_a_r - v_D15_n_r
        struct[0].Gy_ini[364,365] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy_ini[365,28] = -1.0*i_load_D15_a_i
        struct[0].Gy_ini[365,29] = 1.0*i_load_D15_a_r
        struct[0].Gy_ini[365,30] = 1.0*i_load_D15_a_i
        struct[0].Gy_ini[365,31] = -1.0*i_load_D15_a_r
        struct[0].Gy_ini[365,364] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy_ini[365,365] = -1.0*v_D15_a_r + 1.0*v_D15_n_r
        struct[0].Gy_ini[366,364] = 1
        struct[0].Gy_ini[366,366] = 1
        struct[0].Gy_ini[367,365] = 1.00000000000000
        struct[0].Gy_ini[367,367] = 1.00000000000000
        struct[0].Gy_ini[368,32] = i_load_D11_a_r
        struct[0].Gy_ini[368,33] = 1.0*i_load_D11_a_i
        struct[0].Gy_ini[368,34] = -i_load_D11_a_r
        struct[0].Gy_ini[368,35] = -1.0*i_load_D11_a_i
        struct[0].Gy_ini[368,368] = v_D11_a_r - v_D11_n_r
        struct[0].Gy_ini[368,369] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy_ini[369,32] = -1.0*i_load_D11_a_i
        struct[0].Gy_ini[369,33] = 1.0*i_load_D11_a_r
        struct[0].Gy_ini[369,34] = 1.0*i_load_D11_a_i
        struct[0].Gy_ini[369,35] = -1.0*i_load_D11_a_r
        struct[0].Gy_ini[369,368] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy_ini[369,369] = -1.0*v_D11_a_r + 1.0*v_D11_n_r
        struct[0].Gy_ini[370,368] = 1
        struct[0].Gy_ini[370,370] = 1
        struct[0].Gy_ini[371,369] = 1.00000000000000
        struct[0].Gy_ini[371,371] = 1.00000000000000
        struct[0].Gy_ini[372,36] = i_load_D16_a_r
        struct[0].Gy_ini[372,37] = 1.0*i_load_D16_a_i
        struct[0].Gy_ini[372,38] = -i_load_D16_a_r
        struct[0].Gy_ini[372,39] = -1.0*i_load_D16_a_i
        struct[0].Gy_ini[372,372] = v_D16_a_r - v_D16_n_r
        struct[0].Gy_ini[372,373] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy_ini[373,36] = -1.0*i_load_D16_a_i
        struct[0].Gy_ini[373,37] = 1.0*i_load_D16_a_r
        struct[0].Gy_ini[373,38] = 1.0*i_load_D16_a_i
        struct[0].Gy_ini[373,39] = -1.0*i_load_D16_a_r
        struct[0].Gy_ini[373,372] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy_ini[373,373] = -1.0*v_D16_a_r + 1.0*v_D16_n_r
        struct[0].Gy_ini[374,372] = 1
        struct[0].Gy_ini[374,374] = 1
        struct[0].Gy_ini[375,373] = 1.00000000000000
        struct[0].Gy_ini[375,375] = 1.00000000000000
        struct[0].Gy_ini[376,40] = i_load_D17_a_r
        struct[0].Gy_ini[376,41] = 1.0*i_load_D17_a_i
        struct[0].Gy_ini[376,42] = -i_load_D17_a_r
        struct[0].Gy_ini[376,43] = -1.0*i_load_D17_a_i
        struct[0].Gy_ini[376,376] = v_D17_a_r - v_D17_n_r
        struct[0].Gy_ini[376,377] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy_ini[377,40] = -1.0*i_load_D17_a_i
        struct[0].Gy_ini[377,41] = 1.0*i_load_D17_a_r
        struct[0].Gy_ini[377,42] = 1.0*i_load_D17_a_i
        struct[0].Gy_ini[377,43] = -1.0*i_load_D17_a_r
        struct[0].Gy_ini[377,376] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy_ini[377,377] = -1.0*v_D17_a_r + 1.0*v_D17_n_r
        struct[0].Gy_ini[378,376] = 1
        struct[0].Gy_ini[378,378] = 1
        struct[0].Gy_ini[379,377] = 1.00000000000000
        struct[0].Gy_ini[379,379] = 1.00000000000000
        struct[0].Gy_ini[380,44] = i_load_D18_a_r
        struct[0].Gy_ini[380,45] = 1.0*i_load_D18_a_i
        struct[0].Gy_ini[380,46] = -i_load_D18_a_r
        struct[0].Gy_ini[380,47] = -1.0*i_load_D18_a_i
        struct[0].Gy_ini[380,380] = v_D18_a_r - v_D18_n_r
        struct[0].Gy_ini[380,381] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy_ini[381,44] = -1.0*i_load_D18_a_i
        struct[0].Gy_ini[381,45] = 1.0*i_load_D18_a_r
        struct[0].Gy_ini[381,46] = 1.0*i_load_D18_a_i
        struct[0].Gy_ini[381,47] = -1.0*i_load_D18_a_r
        struct[0].Gy_ini[381,380] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy_ini[381,381] = -1.0*v_D18_a_r + 1.0*v_D18_n_r
        struct[0].Gy_ini[382,380] = 1
        struct[0].Gy_ini[382,382] = 1
        struct[0].Gy_ini[383,381] = 1.00000000000000
        struct[0].Gy_ini[383,383] = 1.00000000000000
        struct[0].Gy_ini[384,0] = i_vsc_R1_a_r
        struct[0].Gy_ini[384,1] = 1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[384,6] = -i_vsc_R1_a_r
        struct[0].Gy_ini[384,7] = -1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[384,384] = v_R1_a_r - v_R1_n_r
        struct[0].Gy_ini[384,385] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[384,390] = -1/3
        struct[0].Gy_ini[385,0] = -1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[385,1] = 1.0*i_vsc_R1_a_r
        struct[0].Gy_ini[385,6] = 1.0*i_vsc_R1_a_i
        struct[0].Gy_ini[385,7] = -1.0*i_vsc_R1_a_r
        struct[0].Gy_ini[385,384] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[385,385] = -1.0*v_R1_a_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[386,2] = i_vsc_R1_b_r
        struct[0].Gy_ini[386,3] = 1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[386,6] = -i_vsc_R1_b_r
        struct[0].Gy_ini[386,7] = -1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[386,386] = v_R1_b_r - v_R1_n_r
        struct[0].Gy_ini[386,387] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[386,390] = -1/3
        struct[0].Gy_ini[387,2] = -1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[387,3] = 1.0*i_vsc_R1_b_r
        struct[0].Gy_ini[387,6] = 1.0*i_vsc_R1_b_i
        struct[0].Gy_ini[387,7] = -1.0*i_vsc_R1_b_r
        struct[0].Gy_ini[387,386] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[387,387] = -1.0*v_R1_b_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[388,4] = i_vsc_R1_c_r
        struct[0].Gy_ini[388,5] = 1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[388,6] = -i_vsc_R1_c_r
        struct[0].Gy_ini[388,7] = -1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[388,388] = v_R1_c_r - v_R1_n_r
        struct[0].Gy_ini[388,389] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[388,390] = -1/3
        struct[0].Gy_ini[389,4] = -1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[389,5] = 1.0*i_vsc_R1_c_r
        struct[0].Gy_ini[389,6] = 1.0*i_vsc_R1_c_i
        struct[0].Gy_ini[389,7] = -1.0*i_vsc_R1_c_r
        struct[0].Gy_ini[389,388] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy_ini[389,389] = -1.0*v_R1_c_r + 1.0*v_R1_n_r
        struct[0].Gy_ini[390,390] = 1
        struct[0].Gy_ini[390,391] = 1
        struct[0].Gy_ini[390,392] = Piecewise(np.array([(-1, p_D1 < 0), (1, True)]))
        struct[0].Gy_ini[391,248] = v_D1_a_r
        struct[0].Gy_ini[391,254] = v_D1_n_r
        struct[0].Gy_ini[391,391] = -1
        struct[0].Gy_ini[392,384] = -b_R1*i_vsc_R1_a_r/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_r
        struct[0].Gy_ini[392,385] = -b_R1*i_vsc_R1_a_i/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_i
        struct[0].Gy_ini[392,392] = 1
        struct[0].Gy_ini[393,112] = i_vsc_R10_a_r
        struct[0].Gy_ini[393,113] = 1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[393,118] = -i_vsc_R10_a_r
        struct[0].Gy_ini[393,119] = -1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[393,393] = v_R10_a_r - v_R10_n_r
        struct[0].Gy_ini[393,394] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[394,112] = -1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[394,113] = 1.0*i_vsc_R10_a_r
        struct[0].Gy_ini[394,118] = 1.0*i_vsc_R10_a_i
        struct[0].Gy_ini[394,119] = -1.0*i_vsc_R10_a_r
        struct[0].Gy_ini[394,393] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[394,394] = -1.0*v_R10_a_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[395,114] = i_vsc_R10_b_r
        struct[0].Gy_ini[395,115] = 1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[395,118] = -i_vsc_R10_b_r
        struct[0].Gy_ini[395,119] = -1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[395,395] = v_R10_b_r - v_R10_n_r
        struct[0].Gy_ini[395,396] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[396,114] = -1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[396,115] = 1.0*i_vsc_R10_b_r
        struct[0].Gy_ini[396,118] = 1.0*i_vsc_R10_b_i
        struct[0].Gy_ini[396,119] = -1.0*i_vsc_R10_b_r
        struct[0].Gy_ini[396,395] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[396,396] = -1.0*v_R10_b_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[397,116] = i_vsc_R10_c_r
        struct[0].Gy_ini[397,117] = 1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[397,118] = -i_vsc_R10_c_r
        struct[0].Gy_ini[397,119] = -1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[397,397] = v_R10_c_r - v_R10_n_r
        struct[0].Gy_ini[397,398] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[398,116] = -1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[398,117] = 1.0*i_vsc_R10_c_r
        struct[0].Gy_ini[398,118] = 1.0*i_vsc_R10_c_i
        struct[0].Gy_ini[398,119] = -1.0*i_vsc_R10_c_r
        struct[0].Gy_ini[398,397] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy_ini[398,398] = -1.0*v_R10_c_r + 1.0*v_R10_n_r
        struct[0].Gy_ini[399,393] = 1
        struct[0].Gy_ini[399,395] = 1
        struct[0].Gy_ini[399,397] = 1
        struct[0].Gy_ini[399,399] = 1
        struct[0].Gy_ini[400,394] = 1
        struct[0].Gy_ini[400,396] = 1
        struct[0].Gy_ini[400,398] = 1
        struct[0].Gy_ini[400,400] = 1
        struct[0].Gy_ini[401,198] = -p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[401,204] = p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[401,401] = 1
        struct[0].Gy_ini[401,403] = 1/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].Gy_ini[402,198] = p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[402,204] = -p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy_ini[402,402] = 1
        struct[0].Gy_ini[402,403] = 1/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].Gy_ini[403,393] = Piecewise(np.array([(b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_r, p_D10 < 0), (-b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_r, p_D10 > 0), (b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_r, True)]))
        struct[0].Gy_ini[403,394] = Piecewise(np.array([(b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_i, p_D10 < 0), (-b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_i, p_D10 > 0), (b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_i, True)]))
        struct[0].Gy_ini[403,403] = 1
        struct[0].Gy_ini[404,140] = i_vsc_R14_a_r
        struct[0].Gy_ini[404,141] = 1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[404,146] = -i_vsc_R14_a_r
        struct[0].Gy_ini[404,147] = -1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[404,404] = v_R14_a_r - v_R14_n_r
        struct[0].Gy_ini[404,405] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[405,140] = -1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[405,141] = 1.0*i_vsc_R14_a_r
        struct[0].Gy_ini[405,146] = 1.0*i_vsc_R14_a_i
        struct[0].Gy_ini[405,147] = -1.0*i_vsc_R14_a_r
        struct[0].Gy_ini[405,404] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[405,405] = -1.0*v_R14_a_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[406,142] = i_vsc_R14_b_r
        struct[0].Gy_ini[406,143] = 1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[406,146] = -i_vsc_R14_b_r
        struct[0].Gy_ini[406,147] = -1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[406,406] = v_R14_b_r - v_R14_n_r
        struct[0].Gy_ini[406,407] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[407,142] = -1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[407,143] = 1.0*i_vsc_R14_b_r
        struct[0].Gy_ini[407,146] = 1.0*i_vsc_R14_b_i
        struct[0].Gy_ini[407,147] = -1.0*i_vsc_R14_b_r
        struct[0].Gy_ini[407,406] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[407,407] = -1.0*v_R14_b_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[408,144] = i_vsc_R14_c_r
        struct[0].Gy_ini[408,145] = 1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[408,146] = -i_vsc_R14_c_r
        struct[0].Gy_ini[408,147] = -1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[408,408] = v_R14_c_r - v_R14_n_r
        struct[0].Gy_ini[408,409] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[409,144] = -1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[409,145] = 1.0*i_vsc_R14_c_r
        struct[0].Gy_ini[409,146] = 1.0*i_vsc_R14_c_i
        struct[0].Gy_ini[409,147] = -1.0*i_vsc_R14_c_r
        struct[0].Gy_ini[409,408] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy_ini[409,409] = -1.0*v_R14_c_r + 1.0*v_R14_n_r
        struct[0].Gy_ini[410,404] = 1
        struct[0].Gy_ini[410,406] = 1
        struct[0].Gy_ini[410,408] = 1
        struct[0].Gy_ini[410,410] = 1
        struct[0].Gy_ini[411,405] = 1
        struct[0].Gy_ini[411,407] = 1
        struct[0].Gy_ini[411,409] = 1
        struct[0].Gy_ini[411,411] = 1
        struct[0].Gy_ini[412,222] = -p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[412,228] = p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[412,412] = 1
        struct[0].Gy_ini[412,414] = 1/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].Gy_ini[413,222] = p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[413,228] = -p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy_ini[413,413] = 1
        struct[0].Gy_ini[413,414] = 1/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].Gy_ini[414,404] = Piecewise(np.array([(b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_r, p_D14 < 0), (-b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_r, p_D14 > 0), (b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_r, True)]))
        struct[0].Gy_ini[414,405] = Piecewise(np.array([(b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_i, p_D14 < 0), (-b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_i, p_D14 > 0), (b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_i, True)]))
        struct[0].Gy_ini[414,414] = 1



def run_nn(t,struct,mode):

    # Parameters:
    a_R1 = struct[0].a_R1
    b_R1 = struct[0].b_R1
    c_R1 = struct[0].c_R1
    a_R10 = struct[0].a_R10
    b_R10 = struct[0].b_R10
    c_R10 = struct[0].c_R10
    coef_a_R10 = struct[0].coef_a_R10
    coef_b_R10 = struct[0].coef_b_R10
    coef_c_R10 = struct[0].coef_c_R10
    a_R14 = struct[0].a_R14
    b_R14 = struct[0].b_R14
    c_R14 = struct[0].c_R14
    coef_a_R14 = struct[0].coef_a_R14
    coef_b_R14 = struct[0].coef_b_R14
    coef_c_R14 = struct[0].coef_c_R14
    
    # Inputs:
    v_R0_a_r = struct[0].v_R0_a_r
    v_R0_a_i = struct[0].v_R0_a_i
    v_R0_b_r = struct[0].v_R0_b_r
    v_R0_b_i = struct[0].v_R0_b_i
    v_R0_c_r = struct[0].v_R0_c_r
    v_R0_c_i = struct[0].v_R0_c_i
    v_D1_a_r = struct[0].v_D1_a_r
    v_D1_a_i = struct[0].v_D1_a_i
    v_D1_b_r = struct[0].v_D1_b_r
    v_D1_b_i = struct[0].v_D1_b_i
    v_D1_c_r = struct[0].v_D1_c_r
    v_D1_c_i = struct[0].v_D1_c_i
    i_R1_n_r = struct[0].i_R1_n_r
    i_R1_n_i = struct[0].i_R1_n_i
    i_R2_a_r = struct[0].i_R2_a_r
    i_R2_a_i = struct[0].i_R2_a_i
    i_R2_b_r = struct[0].i_R2_b_r
    i_R2_b_i = struct[0].i_R2_b_i
    i_R2_c_r = struct[0].i_R2_c_r
    i_R2_c_i = struct[0].i_R2_c_i
    i_R2_n_r = struct[0].i_R2_n_r
    i_R2_n_i = struct[0].i_R2_n_i
    i_R3_a_r = struct[0].i_R3_a_r
    i_R3_a_i = struct[0].i_R3_a_i
    i_R3_b_r = struct[0].i_R3_b_r
    i_R3_b_i = struct[0].i_R3_b_i
    i_R3_c_r = struct[0].i_R3_c_r
    i_R3_c_i = struct[0].i_R3_c_i
    i_R3_n_r = struct[0].i_R3_n_r
    i_R3_n_i = struct[0].i_R3_n_i
    i_R4_a_r = struct[0].i_R4_a_r
    i_R4_a_i = struct[0].i_R4_a_i
    i_R4_b_r = struct[0].i_R4_b_r
    i_R4_b_i = struct[0].i_R4_b_i
    i_R4_c_r = struct[0].i_R4_c_r
    i_R4_c_i = struct[0].i_R4_c_i
    i_R4_n_r = struct[0].i_R4_n_r
    i_R4_n_i = struct[0].i_R4_n_i
    i_R5_a_r = struct[0].i_R5_a_r
    i_R5_a_i = struct[0].i_R5_a_i
    i_R5_b_r = struct[0].i_R5_b_r
    i_R5_b_i = struct[0].i_R5_b_i
    i_R5_c_r = struct[0].i_R5_c_r
    i_R5_c_i = struct[0].i_R5_c_i
    i_R5_n_r = struct[0].i_R5_n_r
    i_R5_n_i = struct[0].i_R5_n_i
    i_R6_a_r = struct[0].i_R6_a_r
    i_R6_a_i = struct[0].i_R6_a_i
    i_R6_b_r = struct[0].i_R6_b_r
    i_R6_b_i = struct[0].i_R6_b_i
    i_R6_c_r = struct[0].i_R6_c_r
    i_R6_c_i = struct[0].i_R6_c_i
    i_R6_n_r = struct[0].i_R6_n_r
    i_R6_n_i = struct[0].i_R6_n_i
    i_R7_a_r = struct[0].i_R7_a_r
    i_R7_a_i = struct[0].i_R7_a_i
    i_R7_b_r = struct[0].i_R7_b_r
    i_R7_b_i = struct[0].i_R7_b_i
    i_R7_c_r = struct[0].i_R7_c_r
    i_R7_c_i = struct[0].i_R7_c_i
    i_R7_n_r = struct[0].i_R7_n_r
    i_R7_n_i = struct[0].i_R7_n_i
    i_R8_a_r = struct[0].i_R8_a_r
    i_R8_a_i = struct[0].i_R8_a_i
    i_R8_b_r = struct[0].i_R8_b_r
    i_R8_b_i = struct[0].i_R8_b_i
    i_R8_c_r = struct[0].i_R8_c_r
    i_R8_c_i = struct[0].i_R8_c_i
    i_R8_n_r = struct[0].i_R8_n_r
    i_R8_n_i = struct[0].i_R8_n_i
    i_R9_a_r = struct[0].i_R9_a_r
    i_R9_a_i = struct[0].i_R9_a_i
    i_R9_b_r = struct[0].i_R9_b_r
    i_R9_b_i = struct[0].i_R9_b_i
    i_R9_c_r = struct[0].i_R9_c_r
    i_R9_c_i = struct[0].i_R9_c_i
    i_R9_n_r = struct[0].i_R9_n_r
    i_R9_n_i = struct[0].i_R9_n_i
    i_R10_a_r = struct[0].i_R10_a_r
    i_R10_a_i = struct[0].i_R10_a_i
    i_R10_b_r = struct[0].i_R10_b_r
    i_R10_b_i = struct[0].i_R10_b_i
    i_R10_c_r = struct[0].i_R10_c_r
    i_R10_c_i = struct[0].i_R10_c_i
    i_R10_n_r = struct[0].i_R10_n_r
    i_R10_n_i = struct[0].i_R10_n_i
    i_R11_b_r = struct[0].i_R11_b_r
    i_R11_b_i = struct[0].i_R11_b_i
    i_R11_c_r = struct[0].i_R11_c_r
    i_R11_c_i = struct[0].i_R11_c_i
    i_R12_a_r = struct[0].i_R12_a_r
    i_R12_a_i = struct[0].i_R12_a_i
    i_R12_b_r = struct[0].i_R12_b_r
    i_R12_b_i = struct[0].i_R12_b_i
    i_R12_c_r = struct[0].i_R12_c_r
    i_R12_c_i = struct[0].i_R12_c_i
    i_R12_n_r = struct[0].i_R12_n_r
    i_R12_n_i = struct[0].i_R12_n_i
    i_R13_a_r = struct[0].i_R13_a_r
    i_R13_a_i = struct[0].i_R13_a_i
    i_R13_b_r = struct[0].i_R13_b_r
    i_R13_b_i = struct[0].i_R13_b_i
    i_R13_c_r = struct[0].i_R13_c_r
    i_R13_c_i = struct[0].i_R13_c_i
    i_R13_n_r = struct[0].i_R13_n_r
    i_R13_n_i = struct[0].i_R13_n_i
    i_R14_a_r = struct[0].i_R14_a_r
    i_R14_a_i = struct[0].i_R14_a_i
    i_R14_b_r = struct[0].i_R14_b_r
    i_R14_b_i = struct[0].i_R14_b_i
    i_R14_c_r = struct[0].i_R14_c_r
    i_R14_c_i = struct[0].i_R14_c_i
    i_R14_n_r = struct[0].i_R14_n_r
    i_R14_n_i = struct[0].i_R14_n_i
    i_R15_b_r = struct[0].i_R15_b_r
    i_R15_b_i = struct[0].i_R15_b_i
    i_R15_c_r = struct[0].i_R15_c_r
    i_R15_c_i = struct[0].i_R15_c_i
    i_R16_b_r = struct[0].i_R16_b_r
    i_R16_b_i = struct[0].i_R16_b_i
    i_R16_c_r = struct[0].i_R16_c_r
    i_R16_c_i = struct[0].i_R16_c_i
    i_R17_b_r = struct[0].i_R17_b_r
    i_R17_b_i = struct[0].i_R17_b_i
    i_R17_c_r = struct[0].i_R17_c_r
    i_R17_c_i = struct[0].i_R17_c_i
    i_R18_b_r = struct[0].i_R18_b_r
    i_R18_b_i = struct[0].i_R18_b_i
    i_R18_c_r = struct[0].i_R18_c_r
    i_R18_c_i = struct[0].i_R18_c_i
    i_D1_n_r = struct[0].i_D1_n_r
    i_D1_n_i = struct[0].i_D1_n_i
    i_D3_a_r = struct[0].i_D3_a_r
    i_D3_a_i = struct[0].i_D3_a_i
    i_D3_b_r = struct[0].i_D3_b_r
    i_D3_b_i = struct[0].i_D3_b_i
    i_D3_c_r = struct[0].i_D3_c_r
    i_D3_c_i = struct[0].i_D3_c_i
    i_D3_n_r = struct[0].i_D3_n_r
    i_D3_n_i = struct[0].i_D3_n_i
    i_D4_a_r = struct[0].i_D4_a_r
    i_D4_a_i = struct[0].i_D4_a_i
    i_D4_b_r = struct[0].i_D4_b_r
    i_D4_b_i = struct[0].i_D4_b_i
    i_D4_c_r = struct[0].i_D4_c_r
    i_D4_c_i = struct[0].i_D4_c_i
    i_D4_n_r = struct[0].i_D4_n_r
    i_D4_n_i = struct[0].i_D4_n_i
    i_D6_a_r = struct[0].i_D6_a_r
    i_D6_a_i = struct[0].i_D6_a_i
    i_D6_b_r = struct[0].i_D6_b_r
    i_D6_b_i = struct[0].i_D6_b_i
    i_D6_c_r = struct[0].i_D6_c_r
    i_D6_c_i = struct[0].i_D6_c_i
    i_D6_n_r = struct[0].i_D6_n_r
    i_D6_n_i = struct[0].i_D6_n_i
    i_D9_a_r = struct[0].i_D9_a_r
    i_D9_a_i = struct[0].i_D9_a_i
    i_D9_b_r = struct[0].i_D9_b_r
    i_D9_b_i = struct[0].i_D9_b_i
    i_D9_c_r = struct[0].i_D9_c_r
    i_D9_c_i = struct[0].i_D9_c_i
    i_D9_n_r = struct[0].i_D9_n_r
    i_D9_n_i = struct[0].i_D9_n_i
    i_D10_a_i = struct[0].i_D10_a_i
    i_D10_b_r = struct[0].i_D10_b_r
    i_D10_b_i = struct[0].i_D10_b_i
    i_D10_c_r = struct[0].i_D10_c_r
    i_D10_c_i = struct[0].i_D10_c_i
    i_D10_n_i = struct[0].i_D10_n_i
    i_D11_b_r = struct[0].i_D11_b_r
    i_D11_b_i = struct[0].i_D11_b_i
    i_D11_c_r = struct[0].i_D11_c_r
    i_D11_c_i = struct[0].i_D11_c_i
    i_D16_b_r = struct[0].i_D16_b_r
    i_D16_b_i = struct[0].i_D16_b_i
    i_D16_c_r = struct[0].i_D16_c_r
    i_D16_c_i = struct[0].i_D16_c_i
    i_D17_b_r = struct[0].i_D17_b_r
    i_D17_b_i = struct[0].i_D17_b_i
    i_D17_c_r = struct[0].i_D17_c_r
    i_D17_c_i = struct[0].i_D17_c_i
    i_D18_b_r = struct[0].i_D18_b_r
    i_D18_b_i = struct[0].i_D18_b_i
    i_D18_c_r = struct[0].i_D18_c_r
    i_D18_c_i = struct[0].i_D18_c_i
    i_D14_a_i = struct[0].i_D14_a_i
    i_D14_b_r = struct[0].i_D14_b_r
    i_D14_b_i = struct[0].i_D14_b_i
    i_D14_c_r = struct[0].i_D14_c_r
    i_D14_c_i = struct[0].i_D14_c_i
    i_D14_n_i = struct[0].i_D14_n_i
    i_D15_b_r = struct[0].i_D15_b_r
    i_D15_b_i = struct[0].i_D15_b_i
    i_D15_c_r = struct[0].i_D15_c_r
    i_D15_c_i = struct[0].i_D15_c_i
    p_R1_a = struct[0].p_R1_a
    q_R1_a = struct[0].q_R1_a
    p_R1_b = struct[0].p_R1_b
    q_R1_b = struct[0].q_R1_b
    p_R1_c = struct[0].p_R1_c
    q_R1_c = struct[0].q_R1_c
    p_R11_1 = struct[0].p_R11_1
    q_R11_1 = struct[0].q_R11_1
    p_R15_1 = struct[0].p_R15_1
    q_R15_1 = struct[0].q_R15_1
    p_R16_1 = struct[0].p_R16_1
    q_R16_1 = struct[0].q_R16_1
    p_R17_1 = struct[0].p_R17_1
    q_R17_1 = struct[0].q_R17_1
    p_R18_1 = struct[0].p_R18_1
    q_R18_1 = struct[0].q_R18_1
    p_D15_1 = struct[0].p_D15_1
    q_D15_1 = struct[0].q_D15_1
    p_D11_1 = struct[0].p_D11_1
    q_D11_1 = struct[0].q_D11_1
    p_D16_1 = struct[0].p_D16_1
    q_D16_1 = struct[0].q_D16_1
    p_D17_1 = struct[0].p_D17_1
    q_D17_1 = struct[0].q_D17_1
    p_D18_1 = struct[0].p_D18_1
    q_D18_1 = struct[0].q_D18_1
    v_dc_D1 = struct[0].v_dc_D1
    q_R1 = struct[0].q_R1
    p_R10 = struct[0].p_R10
    q_R10 = struct[0].q_R10
    p_R14 = struct[0].p_R14
    q_R14 = struct[0].q_R14
    u_dummy = struct[0].u_dummy
    
    # Dynamical states:
    x_dummy = struct[0].x[0,0]
    
    # Algebraic states:
    v_R1_a_r = struct[0].y_run[0,0]
    v_R1_a_i = struct[0].y_run[1,0]
    v_R1_b_r = struct[0].y_run[2,0]
    v_R1_b_i = struct[0].y_run[3,0]
    v_R1_c_r = struct[0].y_run[4,0]
    v_R1_c_i = struct[0].y_run[5,0]
    v_R1_n_r = struct[0].y_run[6,0]
    v_R1_n_i = struct[0].y_run[7,0]
    v_R11_a_r = struct[0].y_run[8,0]
    v_R11_a_i = struct[0].y_run[9,0]
    v_R11_n_r = struct[0].y_run[10,0]
    v_R11_n_i = struct[0].y_run[11,0]
    v_R15_a_r = struct[0].y_run[12,0]
    v_R15_a_i = struct[0].y_run[13,0]
    v_R15_n_r = struct[0].y_run[14,0]
    v_R15_n_i = struct[0].y_run[15,0]
    v_R16_a_r = struct[0].y_run[16,0]
    v_R16_a_i = struct[0].y_run[17,0]
    v_R16_n_r = struct[0].y_run[18,0]
    v_R16_n_i = struct[0].y_run[19,0]
    v_R17_a_r = struct[0].y_run[20,0]
    v_R17_a_i = struct[0].y_run[21,0]
    v_R17_n_r = struct[0].y_run[22,0]
    v_R17_n_i = struct[0].y_run[23,0]
    v_R18_a_r = struct[0].y_run[24,0]
    v_R18_a_i = struct[0].y_run[25,0]
    v_R18_n_r = struct[0].y_run[26,0]
    v_R18_n_i = struct[0].y_run[27,0]
    v_D15_a_r = struct[0].y_run[28,0]
    v_D15_a_i = struct[0].y_run[29,0]
    v_D15_n_r = struct[0].y_run[30,0]
    v_D15_n_i = struct[0].y_run[31,0]
    v_D11_a_r = struct[0].y_run[32,0]
    v_D11_a_i = struct[0].y_run[33,0]
    v_D11_n_r = struct[0].y_run[34,0]
    v_D11_n_i = struct[0].y_run[35,0]
    v_D16_a_r = struct[0].y_run[36,0]
    v_D16_a_i = struct[0].y_run[37,0]
    v_D16_n_r = struct[0].y_run[38,0]
    v_D16_n_i = struct[0].y_run[39,0]
    v_D17_a_r = struct[0].y_run[40,0]
    v_D17_a_i = struct[0].y_run[41,0]
    v_D17_n_r = struct[0].y_run[42,0]
    v_D17_n_i = struct[0].y_run[43,0]
    v_D18_a_r = struct[0].y_run[44,0]
    v_D18_a_i = struct[0].y_run[45,0]
    v_D18_n_r = struct[0].y_run[46,0]
    v_D18_n_i = struct[0].y_run[47,0]
    v_R2_a_r = struct[0].y_run[48,0]
    v_R2_a_i = struct[0].y_run[49,0]
    v_R2_b_r = struct[0].y_run[50,0]
    v_R2_b_i = struct[0].y_run[51,0]
    v_R2_c_r = struct[0].y_run[52,0]
    v_R2_c_i = struct[0].y_run[53,0]
    v_R2_n_r = struct[0].y_run[54,0]
    v_R2_n_i = struct[0].y_run[55,0]
    v_R3_a_r = struct[0].y_run[56,0]
    v_R3_a_i = struct[0].y_run[57,0]
    v_R3_b_r = struct[0].y_run[58,0]
    v_R3_b_i = struct[0].y_run[59,0]
    v_R3_c_r = struct[0].y_run[60,0]
    v_R3_c_i = struct[0].y_run[61,0]
    v_R3_n_r = struct[0].y_run[62,0]
    v_R3_n_i = struct[0].y_run[63,0]
    v_R4_a_r = struct[0].y_run[64,0]
    v_R4_a_i = struct[0].y_run[65,0]
    v_R4_b_r = struct[0].y_run[66,0]
    v_R4_b_i = struct[0].y_run[67,0]
    v_R4_c_r = struct[0].y_run[68,0]
    v_R4_c_i = struct[0].y_run[69,0]
    v_R4_n_r = struct[0].y_run[70,0]
    v_R4_n_i = struct[0].y_run[71,0]
    v_R5_a_r = struct[0].y_run[72,0]
    v_R5_a_i = struct[0].y_run[73,0]
    v_R5_b_r = struct[0].y_run[74,0]
    v_R5_b_i = struct[0].y_run[75,0]
    v_R5_c_r = struct[0].y_run[76,0]
    v_R5_c_i = struct[0].y_run[77,0]
    v_R5_n_r = struct[0].y_run[78,0]
    v_R5_n_i = struct[0].y_run[79,0]
    v_R6_a_r = struct[0].y_run[80,0]
    v_R6_a_i = struct[0].y_run[81,0]
    v_R6_b_r = struct[0].y_run[82,0]
    v_R6_b_i = struct[0].y_run[83,0]
    v_R6_c_r = struct[0].y_run[84,0]
    v_R6_c_i = struct[0].y_run[85,0]
    v_R6_n_r = struct[0].y_run[86,0]
    v_R6_n_i = struct[0].y_run[87,0]
    v_R7_a_r = struct[0].y_run[88,0]
    v_R7_a_i = struct[0].y_run[89,0]
    v_R7_b_r = struct[0].y_run[90,0]
    v_R7_b_i = struct[0].y_run[91,0]
    v_R7_c_r = struct[0].y_run[92,0]
    v_R7_c_i = struct[0].y_run[93,0]
    v_R7_n_r = struct[0].y_run[94,0]
    v_R7_n_i = struct[0].y_run[95,0]
    v_R8_a_r = struct[0].y_run[96,0]
    v_R8_a_i = struct[0].y_run[97,0]
    v_R8_b_r = struct[0].y_run[98,0]
    v_R8_b_i = struct[0].y_run[99,0]
    v_R8_c_r = struct[0].y_run[100,0]
    v_R8_c_i = struct[0].y_run[101,0]
    v_R8_n_r = struct[0].y_run[102,0]
    v_R8_n_i = struct[0].y_run[103,0]
    v_R9_a_r = struct[0].y_run[104,0]
    v_R9_a_i = struct[0].y_run[105,0]
    v_R9_b_r = struct[0].y_run[106,0]
    v_R9_b_i = struct[0].y_run[107,0]
    v_R9_c_r = struct[0].y_run[108,0]
    v_R9_c_i = struct[0].y_run[109,0]
    v_R9_n_r = struct[0].y_run[110,0]
    v_R9_n_i = struct[0].y_run[111,0]
    v_R10_a_r = struct[0].y_run[112,0]
    v_R10_a_i = struct[0].y_run[113,0]
    v_R10_b_r = struct[0].y_run[114,0]
    v_R10_b_i = struct[0].y_run[115,0]
    v_R10_c_r = struct[0].y_run[116,0]
    v_R10_c_i = struct[0].y_run[117,0]
    v_R10_n_r = struct[0].y_run[118,0]
    v_R10_n_i = struct[0].y_run[119,0]
    v_R11_b_r = struct[0].y_run[120,0]
    v_R11_b_i = struct[0].y_run[121,0]
    v_R11_c_r = struct[0].y_run[122,0]
    v_R11_c_i = struct[0].y_run[123,0]
    v_R12_a_r = struct[0].y_run[124,0]
    v_R12_a_i = struct[0].y_run[125,0]
    v_R12_b_r = struct[0].y_run[126,0]
    v_R12_b_i = struct[0].y_run[127,0]
    v_R12_c_r = struct[0].y_run[128,0]
    v_R12_c_i = struct[0].y_run[129,0]
    v_R12_n_r = struct[0].y_run[130,0]
    v_R12_n_i = struct[0].y_run[131,0]
    v_R13_a_r = struct[0].y_run[132,0]
    v_R13_a_i = struct[0].y_run[133,0]
    v_R13_b_r = struct[0].y_run[134,0]
    v_R13_b_i = struct[0].y_run[135,0]
    v_R13_c_r = struct[0].y_run[136,0]
    v_R13_c_i = struct[0].y_run[137,0]
    v_R13_n_r = struct[0].y_run[138,0]
    v_R13_n_i = struct[0].y_run[139,0]
    v_R14_a_r = struct[0].y_run[140,0]
    v_R14_a_i = struct[0].y_run[141,0]
    v_R14_b_r = struct[0].y_run[142,0]
    v_R14_b_i = struct[0].y_run[143,0]
    v_R14_c_r = struct[0].y_run[144,0]
    v_R14_c_i = struct[0].y_run[145,0]
    v_R14_n_r = struct[0].y_run[146,0]
    v_R14_n_i = struct[0].y_run[147,0]
    v_R15_b_r = struct[0].y_run[148,0]
    v_R15_b_i = struct[0].y_run[149,0]
    v_R15_c_r = struct[0].y_run[150,0]
    v_R15_c_i = struct[0].y_run[151,0]
    v_R16_b_r = struct[0].y_run[152,0]
    v_R16_b_i = struct[0].y_run[153,0]
    v_R16_c_r = struct[0].y_run[154,0]
    v_R16_c_i = struct[0].y_run[155,0]
    v_R17_b_r = struct[0].y_run[156,0]
    v_R17_b_i = struct[0].y_run[157,0]
    v_R17_c_r = struct[0].y_run[158,0]
    v_R17_c_i = struct[0].y_run[159,0]
    v_R18_b_r = struct[0].y_run[160,0]
    v_R18_b_i = struct[0].y_run[161,0]
    v_R18_c_r = struct[0].y_run[162,0]
    v_R18_c_i = struct[0].y_run[163,0]
    v_D1_n_r = struct[0].y_run[164,0]
    v_D1_n_i = struct[0].y_run[165,0]
    v_D3_a_r = struct[0].y_run[166,0]
    v_D3_a_i = struct[0].y_run[167,0]
    v_D3_b_r = struct[0].y_run[168,0]
    v_D3_b_i = struct[0].y_run[169,0]
    v_D3_c_r = struct[0].y_run[170,0]
    v_D3_c_i = struct[0].y_run[171,0]
    v_D3_n_r = struct[0].y_run[172,0]
    v_D3_n_i = struct[0].y_run[173,0]
    v_D4_a_r = struct[0].y_run[174,0]
    v_D4_a_i = struct[0].y_run[175,0]
    v_D4_b_r = struct[0].y_run[176,0]
    v_D4_b_i = struct[0].y_run[177,0]
    v_D4_c_r = struct[0].y_run[178,0]
    v_D4_c_i = struct[0].y_run[179,0]
    v_D4_n_r = struct[0].y_run[180,0]
    v_D4_n_i = struct[0].y_run[181,0]
    v_D6_a_r = struct[0].y_run[182,0]
    v_D6_a_i = struct[0].y_run[183,0]
    v_D6_b_r = struct[0].y_run[184,0]
    v_D6_b_i = struct[0].y_run[185,0]
    v_D6_c_r = struct[0].y_run[186,0]
    v_D6_c_i = struct[0].y_run[187,0]
    v_D6_n_r = struct[0].y_run[188,0]
    v_D6_n_i = struct[0].y_run[189,0]
    v_D9_a_r = struct[0].y_run[190,0]
    v_D9_a_i = struct[0].y_run[191,0]
    v_D9_b_r = struct[0].y_run[192,0]
    v_D9_b_i = struct[0].y_run[193,0]
    v_D9_c_r = struct[0].y_run[194,0]
    v_D9_c_i = struct[0].y_run[195,0]
    v_D9_n_r = struct[0].y_run[196,0]
    v_D9_n_i = struct[0].y_run[197,0]
    v_D10_a_r = struct[0].y_run[198,0]
    v_D10_a_i = struct[0].y_run[199,0]
    v_D10_b_r = struct[0].y_run[200,0]
    v_D10_b_i = struct[0].y_run[201,0]
    v_D10_c_r = struct[0].y_run[202,0]
    v_D10_c_i = struct[0].y_run[203,0]
    v_D10_n_r = struct[0].y_run[204,0]
    v_D10_n_i = struct[0].y_run[205,0]
    v_D11_b_r = struct[0].y_run[206,0]
    v_D11_b_i = struct[0].y_run[207,0]
    v_D11_c_r = struct[0].y_run[208,0]
    v_D11_c_i = struct[0].y_run[209,0]
    v_D16_b_r = struct[0].y_run[210,0]
    v_D16_b_i = struct[0].y_run[211,0]
    v_D16_c_r = struct[0].y_run[212,0]
    v_D16_c_i = struct[0].y_run[213,0]
    v_D17_b_r = struct[0].y_run[214,0]
    v_D17_b_i = struct[0].y_run[215,0]
    v_D17_c_r = struct[0].y_run[216,0]
    v_D17_c_i = struct[0].y_run[217,0]
    v_D18_b_r = struct[0].y_run[218,0]
    v_D18_b_i = struct[0].y_run[219,0]
    v_D18_c_r = struct[0].y_run[220,0]
    v_D18_c_i = struct[0].y_run[221,0]
    v_D14_a_r = struct[0].y_run[222,0]
    v_D14_a_i = struct[0].y_run[223,0]
    v_D14_b_r = struct[0].y_run[224,0]
    v_D14_b_i = struct[0].y_run[225,0]
    v_D14_c_r = struct[0].y_run[226,0]
    v_D14_c_i = struct[0].y_run[227,0]
    v_D14_n_r = struct[0].y_run[228,0]
    v_D14_n_i = struct[0].y_run[229,0]
    v_D15_b_r = struct[0].y_run[230,0]
    v_D15_b_i = struct[0].y_run[231,0]
    v_D15_c_r = struct[0].y_run[232,0]
    v_D15_c_i = struct[0].y_run[233,0]
    i_t_R0_R1_a_r = struct[0].y_run[234,0]
    i_t_R0_R1_a_i = struct[0].y_run[235,0]
    i_t_R0_R1_b_r = struct[0].y_run[236,0]
    i_t_R0_R1_b_i = struct[0].y_run[237,0]
    i_t_R0_R1_c_r = struct[0].y_run[238,0]
    i_t_R0_R1_c_i = struct[0].y_run[239,0]
    i_l_R1_R2_a_r = struct[0].y_run[240,0]
    i_l_R1_R2_a_i = struct[0].y_run[241,0]
    i_l_R1_R2_b_r = struct[0].y_run[242,0]
    i_l_R1_R2_b_i = struct[0].y_run[243,0]
    i_l_R1_R2_c_r = struct[0].y_run[244,0]
    i_l_R1_R2_c_i = struct[0].y_run[245,0]
    i_l_R1_R2_n_r = struct[0].y_run[246,0]
    i_l_R1_R2_n_i = struct[0].y_run[247,0]
    i_l_D1_D3_a_r = struct[0].y_run[248,0]
    i_l_D1_D3_a_i = struct[0].y_run[249,0]
    i_l_D1_D3_b_r = struct[0].y_run[250,0]
    i_l_D1_D3_b_i = struct[0].y_run[251,0]
    i_l_D1_D3_c_r = struct[0].y_run[252,0]
    i_l_D1_D3_c_i = struct[0].y_run[253,0]
    i_l_D1_D3_n_r = struct[0].y_run[254,0]
    i_l_D1_D3_n_i = struct[0].y_run[255,0]
    i_l_D3_D4_a_r = struct[0].y_run[256,0]
    i_l_D3_D4_a_i = struct[0].y_run[257,0]
    i_l_D3_D4_b_r = struct[0].y_run[258,0]
    i_l_D3_D4_b_i = struct[0].y_run[259,0]
    i_l_D3_D4_c_r = struct[0].y_run[260,0]
    i_l_D3_D4_c_i = struct[0].y_run[261,0]
    i_l_D3_D4_n_r = struct[0].y_run[262,0]
    i_l_D3_D4_n_i = struct[0].y_run[263,0]
    i_l_D4_D6_a_r = struct[0].y_run[264,0]
    i_l_D4_D6_a_i = struct[0].y_run[265,0]
    i_l_D4_D6_b_r = struct[0].y_run[266,0]
    i_l_D4_D6_b_i = struct[0].y_run[267,0]
    i_l_D4_D6_c_r = struct[0].y_run[268,0]
    i_l_D4_D6_c_i = struct[0].y_run[269,0]
    i_l_D4_D6_n_r = struct[0].y_run[270,0]
    i_l_D4_D6_n_i = struct[0].y_run[271,0]
    i_l_D6_D9_a_r = struct[0].y_run[272,0]
    i_l_D6_D9_a_i = struct[0].y_run[273,0]
    i_l_D6_D9_b_r = struct[0].y_run[274,0]
    i_l_D6_D9_b_i = struct[0].y_run[275,0]
    i_l_D6_D9_c_r = struct[0].y_run[276,0]
    i_l_D6_D9_c_i = struct[0].y_run[277,0]
    i_l_D6_D9_n_r = struct[0].y_run[278,0]
    i_l_D6_D9_n_i = struct[0].y_run[279,0]
    i_l_D9_D10_a_r = struct[0].y_run[280,0]
    i_l_D9_D10_a_i = struct[0].y_run[281,0]
    i_l_D9_D10_b_r = struct[0].y_run[282,0]
    i_l_D9_D10_b_i = struct[0].y_run[283,0]
    i_l_D9_D10_c_r = struct[0].y_run[284,0]
    i_l_D9_D10_c_i = struct[0].y_run[285,0]
    i_l_D9_D10_n_r = struct[0].y_run[286,0]
    i_l_D9_D10_n_i = struct[0].y_run[287,0]
    i_l_D3_D11_a_r = struct[0].y_run[288,0]
    i_l_D3_D11_a_i = struct[0].y_run[289,0]
    i_l_D3_D11_b_r = struct[0].y_run[290,0]
    i_l_D3_D11_b_i = struct[0].y_run[291,0]
    i_l_D3_D11_c_r = struct[0].y_run[292,0]
    i_l_D3_D11_c_i = struct[0].y_run[293,0]
    i_l_D3_D11_n_r = struct[0].y_run[294,0]
    i_l_D3_D11_n_i = struct[0].y_run[295,0]
    i_l_D6_D16_a_r = struct[0].y_run[296,0]
    i_l_D6_D16_a_i = struct[0].y_run[297,0]
    i_l_D6_D16_b_r = struct[0].y_run[298,0]
    i_l_D6_D16_b_i = struct[0].y_run[299,0]
    i_l_D6_D16_c_r = struct[0].y_run[300,0]
    i_l_D6_D16_c_i = struct[0].y_run[301,0]
    i_l_D6_D16_n_r = struct[0].y_run[302,0]
    i_l_D6_D16_n_i = struct[0].y_run[303,0]
    i_l_D9_D17_a_r = struct[0].y_run[304,0]
    i_l_D9_D17_a_i = struct[0].y_run[305,0]
    i_l_D9_D17_b_r = struct[0].y_run[306,0]
    i_l_D9_D17_b_i = struct[0].y_run[307,0]
    i_l_D9_D17_c_r = struct[0].y_run[308,0]
    i_l_D9_D17_c_i = struct[0].y_run[309,0]
    i_l_D9_D17_n_r = struct[0].y_run[310,0]
    i_l_D9_D17_n_i = struct[0].y_run[311,0]
    i_l_D10_D18_a_r = struct[0].y_run[312,0]
    i_l_D10_D18_a_i = struct[0].y_run[313,0]
    i_l_D10_D18_b_r = struct[0].y_run[314,0]
    i_l_D10_D18_b_i = struct[0].y_run[315,0]
    i_l_D10_D18_c_r = struct[0].y_run[316,0]
    i_l_D10_D18_c_i = struct[0].y_run[317,0]
    i_l_D10_D18_n_r = struct[0].y_run[318,0]
    i_l_D10_D18_n_i = struct[0].y_run[319,0]
    i_l_D4_D14_a_r = struct[0].y_run[320,0]
    i_l_D4_D14_a_i = struct[0].y_run[321,0]
    i_l_D4_D14_b_r = struct[0].y_run[322,0]
    i_l_D4_D14_b_i = struct[0].y_run[323,0]
    i_l_D4_D14_c_r = struct[0].y_run[324,0]
    i_l_D4_D14_c_i = struct[0].y_run[325,0]
    i_l_D4_D14_n_r = struct[0].y_run[326,0]
    i_l_D4_D14_n_i = struct[0].y_run[327,0]
    i_l_D14_D15_a_r = struct[0].y_run[328,0]
    i_l_D14_D15_a_i = struct[0].y_run[329,0]
    i_l_D14_D15_b_r = struct[0].y_run[330,0]
    i_l_D14_D15_b_i = struct[0].y_run[331,0]
    i_l_D14_D15_c_r = struct[0].y_run[332,0]
    i_l_D14_D15_c_i = struct[0].y_run[333,0]
    i_l_D14_D15_n_r = struct[0].y_run[334,0]
    i_l_D14_D15_n_i = struct[0].y_run[335,0]
    i_load_R1_a_r = struct[0].y_run[336,0]
    i_load_R1_a_i = struct[0].y_run[337,0]
    i_load_R1_b_r = struct[0].y_run[338,0]
    i_load_R1_b_i = struct[0].y_run[339,0]
    i_load_R1_c_r = struct[0].y_run[340,0]
    i_load_R1_c_i = struct[0].y_run[341,0]
    i_load_R1_n_r = struct[0].y_run[342,0]
    i_load_R1_n_i = struct[0].y_run[343,0]
    i_load_R11_a_r = struct[0].y_run[344,0]
    i_load_R11_a_i = struct[0].y_run[345,0]
    i_load_R11_n_r = struct[0].y_run[346,0]
    i_load_R11_n_i = struct[0].y_run[347,0]
    i_load_R15_a_r = struct[0].y_run[348,0]
    i_load_R15_a_i = struct[0].y_run[349,0]
    i_load_R15_n_r = struct[0].y_run[350,0]
    i_load_R15_n_i = struct[0].y_run[351,0]
    i_load_R16_a_r = struct[0].y_run[352,0]
    i_load_R16_a_i = struct[0].y_run[353,0]
    i_load_R16_n_r = struct[0].y_run[354,0]
    i_load_R16_n_i = struct[0].y_run[355,0]
    i_load_R17_a_r = struct[0].y_run[356,0]
    i_load_R17_a_i = struct[0].y_run[357,0]
    i_load_R17_n_r = struct[0].y_run[358,0]
    i_load_R17_n_i = struct[0].y_run[359,0]
    i_load_R18_a_r = struct[0].y_run[360,0]
    i_load_R18_a_i = struct[0].y_run[361,0]
    i_load_R18_n_r = struct[0].y_run[362,0]
    i_load_R18_n_i = struct[0].y_run[363,0]
    i_load_D15_a_r = struct[0].y_run[364,0]
    i_load_D15_a_i = struct[0].y_run[365,0]
    i_load_D15_n_r = struct[0].y_run[366,0]
    i_load_D15_n_i = struct[0].y_run[367,0]
    i_load_D11_a_r = struct[0].y_run[368,0]
    i_load_D11_a_i = struct[0].y_run[369,0]
    i_load_D11_n_r = struct[0].y_run[370,0]
    i_load_D11_n_i = struct[0].y_run[371,0]
    i_load_D16_a_r = struct[0].y_run[372,0]
    i_load_D16_a_i = struct[0].y_run[373,0]
    i_load_D16_n_r = struct[0].y_run[374,0]
    i_load_D16_n_i = struct[0].y_run[375,0]
    i_load_D17_a_r = struct[0].y_run[376,0]
    i_load_D17_a_i = struct[0].y_run[377,0]
    i_load_D17_n_r = struct[0].y_run[378,0]
    i_load_D17_n_i = struct[0].y_run[379,0]
    i_load_D18_a_r = struct[0].y_run[380,0]
    i_load_D18_a_i = struct[0].y_run[381,0]
    i_load_D18_n_r = struct[0].y_run[382,0]
    i_load_D18_n_i = struct[0].y_run[383,0]
    i_vsc_R1_a_r = struct[0].y_run[384,0]
    i_vsc_R1_a_i = struct[0].y_run[385,0]
    i_vsc_R1_b_r = struct[0].y_run[386,0]
    i_vsc_R1_b_i = struct[0].y_run[387,0]
    i_vsc_R1_c_r = struct[0].y_run[388,0]
    i_vsc_R1_c_i = struct[0].y_run[389,0]
    p_R1 = struct[0].y_run[390,0]
    p_D1 = struct[0].y_run[391,0]
    p_loss_R1 = struct[0].y_run[392,0]
    i_vsc_R10_a_r = struct[0].y_run[393,0]
    i_vsc_R10_a_i = struct[0].y_run[394,0]
    i_vsc_R10_b_r = struct[0].y_run[395,0]
    i_vsc_R10_b_i = struct[0].y_run[396,0]
    i_vsc_R10_c_r = struct[0].y_run[397,0]
    i_vsc_R10_c_i = struct[0].y_run[398,0]
    i_vsc_R10_n_r = struct[0].y_run[399,0]
    i_vsc_R10_n_i = struct[0].y_run[400,0]
    i_vsc_D10_a_r = struct[0].y_run[401,0]
    i_vsc_D10_n_r = struct[0].y_run[402,0]
    p_D10 = struct[0].y_run[403,0]
    i_vsc_R14_a_r = struct[0].y_run[404,0]
    i_vsc_R14_a_i = struct[0].y_run[405,0]
    i_vsc_R14_b_r = struct[0].y_run[406,0]
    i_vsc_R14_b_i = struct[0].y_run[407,0]
    i_vsc_R14_c_r = struct[0].y_run[408,0]
    i_vsc_R14_c_i = struct[0].y_run[409,0]
    i_vsc_R14_n_r = struct[0].y_run[410,0]
    i_vsc_R14_n_i = struct[0].y_run[411,0]
    i_vsc_D14_a_r = struct[0].y_run[412,0]
    i_vsc_D14_n_r = struct[0].y_run[413,0]
    p_D14 = struct[0].y_run[414,0]
    
    # Differential equations:
    if mode == 2:


        struct[0].f[0,0] = u_dummy - x_dummy
    
    # Algebraic equations:
    if mode == 3:


        struct[0].g[0,0] = i_load_R1_a_r + i_vsc_R1_a_r + 0.849044513514155*v_R0_a_i + 0.212261128378539*v_R0_a_r - 0.849044513514155*v_R0_c_i - 0.212261128378539*v_R0_c_r - 127.595184532966*v_R1_a_i - 123.954122254357*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r + 23.284964480954*v_R1_c_i + 24.9575997948692*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r
        struct[0].g[1,0] = i_load_R1_a_i + i_vsc_R1_a_i + 0.212261128378539*v_R0_a_i - 0.849044513514155*v_R0_a_r - 0.212261128378539*v_R0_c_i + 0.849044513514155*v_R0_c_r - 123.954122254357*v_R1_a_i + 127.595184532966*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r + 24.9575997948692*v_R1_c_i - 23.284964480954*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r
        struct[0].g[2,0] = i_load_R1_b_r + i_vsc_R1_b_r - 0.849044513514155*v_R0_a_i - 0.212261128378539*v_R0_a_r + 0.849044513514155*v_R0_b_i + 0.212261128378539*v_R0_b_r + 10.2713736253513*v_R1_a_i + 39.6392229058202*v_R1_a_r - 127.595184532966*v_R1_b_i - 123.954122254357*v_R1_b_r + 10.2713736253513*v_R1_c_i + 39.6392229058201*v_R1_c_r + 96.8143762456598*v_R1_n_i + 43.3399527360457*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r
        struct[0].g[3,0] = i_load_R1_b_i + i_vsc_R1_b_i - 0.212261128378539*v_R0_a_i + 0.849044513514155*v_R0_a_r + 0.212261128378539*v_R0_b_i - 0.849044513514155*v_R0_b_r + 39.6392229058202*v_R1_a_i - 10.2713736253513*v_R1_a_r - 123.954122254357*v_R1_b_i + 127.595184532966*v_R1_b_r + 39.6392229058201*v_R1_c_i - 10.2713736253513*v_R1_c_r + 43.3399527360457*v_R1_n_i - 96.8143762456598*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r
        struct[0].g[4,0] = i_load_R1_c_r + i_vsc_R1_c_r - 0.849044513514155*v_R0_b_i - 0.212261128378539*v_R0_b_r + 0.849044513514155*v_R0_c_i + 0.212261128378539*v_R0_c_r + 23.284964480954*v_R1_a_i + 24.9575997948692*v_R1_a_r + 10.2713736253513*v_R1_b_i + 39.6392229058202*v_R1_b_r - 127.595184532966*v_R1_c_i - 123.954122254357*v_R1_c_r + 83.8007853900572*v_R1_n_i + 58.0215758469966*v_R1_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r
        struct[0].g[5,0] = i_load_R1_c_i + i_vsc_R1_c_i - 0.212261128378539*v_R0_b_i + 0.849044513514155*v_R0_b_r + 0.212261128378539*v_R0_c_i - 0.849044513514155*v_R0_c_r + 24.9575997948692*v_R1_a_i - 23.284964480954*v_R1_a_r + 39.6392229058202*v_R1_b_i - 10.2713736253513*v_R1_b_r - 123.954122254357*v_R1_c_i + 127.595184532966*v_R1_c_r + 58.0215758469966*v_R1_n_i - 83.8007853900572*v_R1_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r
        struct[0].g[6,0] = 83.8007853900572*v_R1_a_i + 58.0215758469966*v_R1_a_r + 96.8143762456598*v_R1_b_i + 43.3399527360457*v_R1_b_r + 83.8007853900572*v_R1_c_i + 58.0215758469966*v_R1_c_r - 274.654008062378*v_R1_n_i - 161.052161470043*v_R1_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r - 23.284964480954*v_R2_b_i - 24.9575997948692*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058202*v_R2_c_r + 54.0657727682604*v_R2_n_i + 105.57176931318*v_R2_n_r
        struct[0].g[7,0] = 58.0215758469966*v_R1_a_i - 83.8007853900572*v_R1_a_r + 43.3399527360457*v_R1_b_i - 96.8143762456598*v_R1_b_r + 58.0215758469966*v_R1_c_i - 83.8007853900572*v_R1_c_r - 161.052161470043*v_R1_n_i + 274.654008062378*v_R1_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r - 24.9575997948692*v_R2_b_i + 23.284964480954*v_R2_b_r - 39.6392229058202*v_R2_c_i + 10.2713736253513*v_R2_c_r + 105.57176931318*v_R2_n_i - 54.0657727682604*v_R2_n_r
        struct[0].g[8,0] = i_load_R11_a_r - 4.84676915585801*v_R11_a_i - 26.5300693004806*v_R11_a_r - 1.58482814504483*v_R11_b_i + 7.8946133751477*v_R11_b_r - 0.67991845328531*v_R11_c_i + 7.72144347466701*v_R11_c_r - 1.58482814504483*v_R11_n_i + 7.89461337514771*v_R11_n_r + 4.84676915585801*v_R3_a_i + 26.5300693004806*v_R3_a_r + 1.58482814504483*v_R3_b_i - 7.8946133751477*v_R3_b_r + 0.67991845328531*v_R3_c_i - 7.72144347466701*v_R3_c_r + 1.58482814504483*v_R3_n_i - 7.89461337514771*v_R3_n_r
        struct[0].g[9,0] = i_load_R11_a_i - 26.5300693004806*v_R11_a_i + 4.84676915585801*v_R11_a_r + 7.8946133751477*v_R11_b_i + 1.58482814504483*v_R11_b_r + 7.72144347466701*v_R11_c_i + 0.67991845328531*v_R11_c_r + 7.89461337514771*v_R11_n_i + 1.58482814504483*v_R11_n_r + 26.5300693004806*v_R3_a_i - 4.84676915585801*v_R3_a_r - 7.8946133751477*v_R3_b_i - 1.58482814504483*v_R3_b_r - 7.72144347466701*v_R3_c_i - 0.67991845328531*v_R3_c_r - 7.89461337514771*v_R3_n_i - 1.58482814504483*v_R3_n_r
        struct[0].g[10,0] = i_load_R11_n_r - 1.58482814504483*v_R11_a_i + 7.89461337514771*v_R11_a_r - 0.679918453285308*v_R11_b_i + 7.72144347466701*v_R11_b_r - 1.58482814504483*v_R11_c_i + 7.89461337514771*v_R11_c_r - 4.84676915585801*v_R11_n_i - 26.5550693004806*v_R11_n_r + 1.58482814504483*v_R3_a_i - 7.89461337514771*v_R3_a_r + 0.679918453285308*v_R3_b_i - 7.72144347466701*v_R3_b_r + 1.58482814504483*v_R3_c_i - 7.89461337514771*v_R3_c_r + 4.84676915585801*v_R3_n_i + 26.5300693004806*v_R3_n_r
        struct[0].g[11,0] = i_load_R11_n_i + 7.89461337514771*v_R11_a_i + 1.58482814504483*v_R11_a_r + 7.72144347466701*v_R11_b_i + 0.679918453285308*v_R11_b_r + 7.89461337514771*v_R11_c_i + 1.58482814504483*v_R11_c_r - 26.5550693004806*v_R11_n_i + 4.84676915585801*v_R11_n_r - 7.89461337514771*v_R3_a_i - 1.58482814504483*v_R3_a_r - 7.72144347466701*v_R3_b_i - 0.679918453285308*v_R3_b_r - 7.89461337514771*v_R3_c_i - 1.58482814504483*v_R3_c_r + 26.5300693004806*v_R3_n_i - 4.84676915585801*v_R3_n_r
        struct[0].g[12,0] = i_load_R15_a_r + 4.84676915585801*v_R14_a_i + 26.5300693004806*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 0.67991845328531*v_R14_c_i - 7.72144347466701*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r - 4.84676915585801*v_R15_a_i - 26.5300693004806*v_R15_a_r - 1.58482814504483*v_R15_b_i + 7.8946133751477*v_R15_b_r - 0.67991845328531*v_R15_c_i + 7.72144347466701*v_R15_c_r - 1.58482814504483*v_R15_n_i + 7.89461337514771*v_R15_n_r
        struct[0].g[13,0] = i_load_R15_a_i + 26.5300693004806*v_R14_a_i - 4.84676915585801*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r - 7.72144347466701*v_R14_c_i - 0.67991845328531*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r - 26.5300693004806*v_R15_a_i + 4.84676915585801*v_R15_a_r + 7.8946133751477*v_R15_b_i + 1.58482814504483*v_R15_b_r + 7.72144347466701*v_R15_c_i + 0.67991845328531*v_R15_c_r + 7.89461337514771*v_R15_n_i + 1.58482814504483*v_R15_n_r
        struct[0].g[14,0] = i_load_R15_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 0.679918453285308*v_R14_b_i - 7.72144347466701*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 4.84676915585801*v_R14_n_i + 26.5300693004806*v_R14_n_r - 1.58482814504483*v_R15_a_i + 7.89461337514771*v_R15_a_r - 0.679918453285308*v_R15_b_i + 7.72144347466701*v_R15_b_r - 1.58482814504483*v_R15_c_i + 7.89461337514771*v_R15_c_r - 4.84676915585801*v_R15_n_i - 26.5550693004806*v_R15_n_r
        struct[0].g[15,0] = i_load_R15_n_i - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r - 7.72144347466701*v_R14_b_i - 0.679918453285308*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r + 26.5300693004806*v_R14_n_i - 4.84676915585801*v_R14_n_r + 7.89461337514771*v_R15_a_i + 1.58482814504483*v_R15_a_r + 7.72144347466701*v_R15_b_i + 0.679918453285308*v_R15_b_r + 7.89461337514771*v_R15_c_i + 1.58482814504483*v_R15_c_r - 26.5550693004806*v_R15_n_i + 4.84676915585801*v_R15_n_r
        struct[0].g[16,0] = i_load_R16_a_r - 5.65456401516768*v_R16_a_i - 30.9517475172273*v_R16_a_r - 1.84896616921897*v_R16_b_i + 9.21038227100566*v_R16_b_r - 0.793238195499529*v_R16_c_i + 9.00835072044485*v_R16_c_r - 1.84896616921897*v_R16_n_i + 9.21038227100566*v_R16_n_r + 5.65456401516768*v_R6_a_i + 30.9517475172273*v_R6_a_r + 1.84896616921897*v_R6_b_i - 9.21038227100566*v_R6_b_r + 0.793238195499529*v_R6_c_i - 9.00835072044485*v_R6_c_r + 1.84896616921897*v_R6_n_i - 9.21038227100566*v_R6_n_r
        struct[0].g[17,0] = i_load_R16_a_i - 30.9517475172273*v_R16_a_i + 5.65456401516768*v_R16_a_r + 9.21038227100566*v_R16_b_i + 1.84896616921897*v_R16_b_r + 9.00835072044485*v_R16_c_i + 0.793238195499529*v_R16_c_r + 9.21038227100566*v_R16_n_i + 1.84896616921897*v_R16_n_r + 30.9517475172273*v_R6_a_i - 5.65456401516768*v_R6_a_r - 9.21038227100566*v_R6_b_i - 1.84896616921897*v_R6_b_r - 9.00835072044485*v_R6_c_i - 0.793238195499529*v_R6_c_r - 9.21038227100566*v_R6_n_i - 1.84896616921897*v_R6_n_r
        struct[0].g[18,0] = i_load_R16_n_r - 1.84896616921897*v_R16_a_i + 9.21038227100566*v_R16_a_r - 0.793238195499527*v_R16_b_i + 9.00835072044485*v_R16_b_r - 1.84896616921897*v_R16_c_i + 9.21038227100566*v_R16_c_r - 5.65456401516768*v_R16_n_i - 30.9767475172273*v_R16_n_r + 1.84896616921897*v_R6_a_i - 9.21038227100566*v_R6_a_r + 0.793238195499527*v_R6_b_i - 9.00835072044485*v_R6_b_r + 1.84896616921897*v_R6_c_i - 9.21038227100566*v_R6_c_r + 5.65456401516768*v_R6_n_i + 30.9517475172273*v_R6_n_r
        struct[0].g[19,0] = i_load_R16_n_i + 9.21038227100566*v_R16_a_i + 1.84896616921897*v_R16_a_r + 9.00835072044485*v_R16_b_i + 0.793238195499527*v_R16_b_r + 9.21038227100566*v_R16_c_i + 1.84896616921897*v_R16_c_r - 30.9767475172273*v_R16_n_i + 5.65456401516768*v_R16_n_r - 9.21038227100566*v_R6_a_i - 1.84896616921897*v_R6_a_r - 9.00835072044485*v_R6_b_i - 0.793238195499527*v_R6_b_r - 9.21038227100566*v_R6_c_i - 1.84896616921897*v_R6_c_r + 30.9517475172273*v_R6_n_i - 5.65456401516768*v_R6_n_r
        struct[0].g[20,0] = i_load_R17_a_r - 5.65456401516768*v_R17_a_i - 30.9517475172273*v_R17_a_r - 1.84896616921897*v_R17_b_i + 9.21038227100566*v_R17_b_r - 0.793238195499529*v_R17_c_i + 9.00835072044485*v_R17_c_r - 1.84896616921897*v_R17_n_i + 9.21038227100566*v_R17_n_r + 5.65456401516768*v_R9_a_i + 30.9517475172273*v_R9_a_r + 1.84896616921897*v_R9_b_i - 9.21038227100566*v_R9_b_r + 0.793238195499529*v_R9_c_i - 9.00835072044485*v_R9_c_r + 1.84896616921897*v_R9_n_i - 9.21038227100566*v_R9_n_r
        struct[0].g[21,0] = i_load_R17_a_i - 30.9517475172273*v_R17_a_i + 5.65456401516768*v_R17_a_r + 9.21038227100566*v_R17_b_i + 1.84896616921897*v_R17_b_r + 9.00835072044485*v_R17_c_i + 0.793238195499529*v_R17_c_r + 9.21038227100566*v_R17_n_i + 1.84896616921897*v_R17_n_r + 30.9517475172273*v_R9_a_i - 5.65456401516768*v_R9_a_r - 9.21038227100566*v_R9_b_i - 1.84896616921897*v_R9_b_r - 9.00835072044485*v_R9_c_i - 0.793238195499529*v_R9_c_r - 9.21038227100566*v_R9_n_i - 1.84896616921897*v_R9_n_r
        struct[0].g[22,0] = i_load_R17_n_r - 1.84896616921897*v_R17_a_i + 9.21038227100566*v_R17_a_r - 0.793238195499527*v_R17_b_i + 9.00835072044485*v_R17_b_r - 1.84896616921897*v_R17_c_i + 9.21038227100566*v_R17_c_r - 5.65456401516768*v_R17_n_i - 30.9767475172273*v_R17_n_r + 1.84896616921897*v_R9_a_i - 9.21038227100566*v_R9_a_r + 0.793238195499527*v_R9_b_i - 9.00835072044485*v_R9_b_r + 1.84896616921897*v_R9_c_i - 9.21038227100566*v_R9_c_r + 5.65456401516768*v_R9_n_i + 30.9517475172273*v_R9_n_r
        struct[0].g[23,0] = i_load_R17_n_i + 9.21038227100566*v_R17_a_i + 1.84896616921897*v_R17_a_r + 9.00835072044485*v_R17_b_i + 0.793238195499527*v_R17_b_r + 9.21038227100566*v_R17_c_i + 1.84896616921897*v_R17_c_r - 30.9767475172273*v_R17_n_i + 5.65456401516768*v_R17_n_r - 9.21038227100566*v_R9_a_i - 1.84896616921897*v_R9_a_r - 9.00835072044485*v_R9_b_i - 0.793238195499527*v_R9_b_r - 9.21038227100566*v_R9_c_i - 1.84896616921897*v_R9_c_r + 30.9517475172273*v_R9_n_i - 5.65456401516768*v_R9_n_r
        struct[0].g[24,0] = i_load_R18_a_r + 5.65456401516768*v_R10_a_i + 30.9517475172273*v_R10_a_r + 1.84896616921897*v_R10_b_i - 9.21038227100566*v_R10_b_r + 0.793238195499529*v_R10_c_i - 9.00835072044485*v_R10_c_r + 1.84896616921897*v_R10_n_i - 9.21038227100566*v_R10_n_r - 5.65456401516768*v_R18_a_i - 30.9517475172273*v_R18_a_r - 1.84896616921897*v_R18_b_i + 9.21038227100566*v_R18_b_r - 0.793238195499529*v_R18_c_i + 9.00835072044485*v_R18_c_r - 1.84896616921897*v_R18_n_i + 9.21038227100566*v_R18_n_r
        struct[0].g[25,0] = i_load_R18_a_i + 30.9517475172273*v_R10_a_i - 5.65456401516768*v_R10_a_r - 9.21038227100566*v_R10_b_i - 1.84896616921897*v_R10_b_r - 9.00835072044485*v_R10_c_i - 0.793238195499529*v_R10_c_r - 9.21038227100566*v_R10_n_i - 1.84896616921897*v_R10_n_r - 30.9517475172273*v_R18_a_i + 5.65456401516768*v_R18_a_r + 9.21038227100566*v_R18_b_i + 1.84896616921897*v_R18_b_r + 9.00835072044485*v_R18_c_i + 0.793238195499529*v_R18_c_r + 9.21038227100566*v_R18_n_i + 1.84896616921897*v_R18_n_r
        struct[0].g[26,0] = i_load_R18_n_r + 1.84896616921897*v_R10_a_i - 9.21038227100566*v_R10_a_r + 0.793238195499527*v_R10_b_i - 9.00835072044485*v_R10_b_r + 1.84896616921897*v_R10_c_i - 9.21038227100566*v_R10_c_r + 5.65456401516768*v_R10_n_i + 30.9517475172273*v_R10_n_r - 1.84896616921897*v_R18_a_i + 9.21038227100566*v_R18_a_r - 0.793238195499527*v_R18_b_i + 9.00835072044485*v_R18_b_r - 1.84896616921897*v_R18_c_i + 9.21038227100566*v_R18_c_r - 5.65456401516768*v_R18_n_i - 30.9767475172273*v_R18_n_r
        struct[0].g[27,0] = i_load_R18_n_i - 9.21038227100566*v_R10_a_i - 1.84896616921897*v_R10_a_r - 9.00835072044485*v_R10_b_i - 0.793238195499527*v_R10_b_r - 9.21038227100566*v_R10_c_i - 1.84896616921897*v_R10_c_r + 30.9517475172273*v_R10_n_i - 5.65456401516768*v_R10_n_r + 9.21038227100566*v_R18_a_i + 1.84896616921897*v_R18_a_r + 9.00835072044485*v_R18_b_i + 0.793238195499527*v_R18_b_r + 9.21038227100566*v_R18_c_i + 1.84896616921897*v_R18_c_r - 30.9767475172273*v_R18_n_i + 5.65456401516768*v_R18_n_r
        struct[0].g[28,0] = i_load_D15_a_r + 135.4096140826*v_D14_a_r - 135.4096140826*v_D15_a_r
        struct[0].g[29,0] = i_load_D15_a_i + 135.4096140826*v_D14_a_i - 135.4096140826*v_D15_a_i
        struct[0].g[30,0] = i_load_D15_n_r + 135.4096140826*v_D14_n_r - 135.4096140826*v_D15_n_r
        struct[0].g[31,0] = i_load_D15_n_i + 135.4096140826*v_D14_n_i - 135.4096140826*v_D15_n_i
        struct[0].g[32,0] = i_load_D11_a_r - 157.977883096366*v_D11_a_r + 157.977883096366*v_D3_a_r
        struct[0].g[33,0] = i_load_D11_a_i - 157.977883096366*v_D11_a_i + 157.977883096366*v_D3_a_i
        struct[0].g[34,0] = i_load_D11_n_r - 157.977883096366*v_D11_n_r + 157.977883096366*v_D3_n_r
        struct[0].g[35,0] = i_load_D11_n_i - 157.977883096366*v_D11_n_i + 157.977883096366*v_D3_n_i
        struct[0].g[36,0] = i_load_D16_a_r - 157.977883096366*v_D16_a_r + 157.977883096366*v_D6_a_r
        struct[0].g[37,0] = i_load_D16_a_i - 157.977883096366*v_D16_a_i + 157.977883096366*v_D6_a_i
        struct[0].g[38,0] = i_load_D16_n_r - 157.977883096366*v_D16_n_r + 157.977883096366*v_D6_n_r
        struct[0].g[39,0] = i_load_D16_n_i - 157.977883096366*v_D16_n_i + 157.977883096366*v_D6_n_i
        struct[0].g[40,0] = i_load_D17_a_r - 157.977883096366*v_D17_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[41,0] = i_load_D17_a_i - 157.977883096366*v_D17_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[42,0] = i_load_D17_n_r - 157.977883096366*v_D17_n_r + 157.977883096366*v_D9_n_r
        struct[0].g[43,0] = i_load_D17_n_i - 157.977883096366*v_D17_n_i + 157.977883096366*v_D9_n_i
        struct[0].g[44,0] = i_load_D18_a_r + 157.977883096366*v_D10_a_r - 157.977883096366*v_D18_a_r
        struct[0].g[45,0] = i_load_D18_a_i + 157.977883096366*v_D10_a_i - 157.977883096366*v_D18_a_i
        struct[0].g[46,0] = i_load_D18_n_r + 157.977883096366*v_D10_n_r - 157.977883096366*v_D18_n_r
        struct[0].g[47,0] = i_load_D18_n_i + 157.977883096366*v_D10_n_i - 157.977883096366*v_D18_n_i
        struct[0].g[48,0] = 54.0657727682604*v_R1_a_i + 105.57176931318*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r - 23.284964480954*v_R1_c_i - 24.9575997948692*v_R1_c_r - 10.2713736253513*v_R1_n_i - 39.6392229058202*v_R1_n_r - 108.131545536521*v_R2_a_i - 211.14353862636*v_R2_a_r + 20.5427472507027*v_R2_b_i + 79.2784458116403*v_R2_b_r + 46.569928961908*v_R2_c_i + 49.9151995897384*v_R2_c_r + 20.5427472507027*v_R2_n_i + 79.2784458116403*v_R2_n_r + 54.0657727682604*v_R3_a_i + 105.57176931318*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r - 23.284964480954*v_R3_c_i - 24.9575997948692*v_R3_c_r - 10.2713736253513*v_R3_n_i - 39.6392229058202*v_R3_n_r
        struct[0].g[49,0] = 105.57176931318*v_R1_a_i - 54.0657727682604*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r - 24.9575997948692*v_R1_c_i + 23.284964480954*v_R1_c_r - 39.6392229058202*v_R1_n_i + 10.2713736253513*v_R1_n_r - 211.14353862636*v_R2_a_i + 108.131545536521*v_R2_a_r + 79.2784458116403*v_R2_b_i - 20.5427472507027*v_R2_b_r + 49.9151995897384*v_R2_c_i - 46.569928961908*v_R2_c_r + 79.2784458116403*v_R2_n_i - 20.5427472507027*v_R2_n_r + 105.57176931318*v_R3_a_i - 54.0657727682604*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r - 24.9575997948692*v_R3_c_i + 23.284964480954*v_R3_c_r - 39.6392229058202*v_R3_n_i + 10.2713736253513*v_R3_n_r
        struct[0].g[50,0] = -10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r + 54.0657727682604*v_R1_b_i + 105.57176931318*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058201*v_R1_c_r - 23.284964480954*v_R1_n_i - 24.9575997948692*v_R1_n_r + 20.5427472507027*v_R2_a_i + 79.2784458116403*v_R2_a_r - 108.131545536521*v_R2_b_i - 211.14353862636*v_R2_b_r + 20.5427472507027*v_R2_c_i + 79.2784458116403*v_R2_c_r + 46.569928961908*v_R2_n_i + 49.9151995897384*v_R2_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r + 54.0657727682604*v_R3_b_i + 105.57176931318*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058201*v_R3_c_r - 23.284964480954*v_R3_n_i - 24.9575997948692*v_R3_n_r
        struct[0].g[51,0] = -39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r + 105.57176931318*v_R1_b_i - 54.0657727682604*v_R1_b_r - 39.6392229058201*v_R1_c_i + 10.2713736253513*v_R1_c_r - 24.9575997948692*v_R1_n_i + 23.284964480954*v_R1_n_r + 79.2784458116403*v_R2_a_i - 20.5427472507027*v_R2_a_r - 211.14353862636*v_R2_b_i + 108.131545536521*v_R2_b_r + 79.2784458116403*v_R2_c_i - 20.5427472507027*v_R2_c_r + 49.9151995897384*v_R2_n_i - 46.569928961908*v_R2_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r + 105.57176931318*v_R3_b_i - 54.0657727682604*v_R3_b_r - 39.6392229058201*v_R3_c_i + 10.2713736253513*v_R3_c_r - 24.9575997948692*v_R3_n_i + 23.284964480954*v_R3_n_r
        struct[0].g[52,0] = -23.284964480954*v_R1_a_i - 24.9575997948692*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r + 54.0657727682604*v_R1_c_i + 105.57176931318*v_R1_c_r - 10.2713736253514*v_R1_n_i - 39.6392229058201*v_R1_n_r + 46.569928961908*v_R2_a_i + 49.9151995897384*v_R2_a_r + 20.5427472507027*v_R2_b_i + 79.2784458116404*v_R2_b_r - 108.131545536521*v_R2_c_i - 211.14353862636*v_R2_c_r + 20.5427472507027*v_R2_n_i + 79.2784458116403*v_R2_n_r - 23.284964480954*v_R3_a_i - 24.9575997948692*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r + 54.0657727682604*v_R3_c_i + 105.57176931318*v_R3_c_r - 10.2713736253514*v_R3_n_i - 39.6392229058201*v_R3_n_r
        struct[0].g[53,0] = -24.9575997948692*v_R1_a_i + 23.284964480954*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r + 105.57176931318*v_R1_c_i - 54.0657727682604*v_R1_c_r - 39.6392229058201*v_R1_n_i + 10.2713736253514*v_R1_n_r + 49.9151995897384*v_R2_a_i - 46.569928961908*v_R2_a_r + 79.2784458116404*v_R2_b_i - 20.5427472507027*v_R2_b_r - 211.14353862636*v_R2_c_i + 108.131545536521*v_R2_c_r + 79.2784458116403*v_R2_n_i - 20.5427472507027*v_R2_n_r - 24.9575997948692*v_R3_a_i + 23.284964480954*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r + 105.57176931318*v_R3_c_i - 54.0657727682604*v_R3_c_r - 39.6392229058201*v_R3_n_i + 10.2713736253514*v_R3_n_r
        struct[0].g[54,0] = -10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r - 23.284964480954*v_R1_b_i - 24.9575997948692*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058202*v_R1_c_r + 54.0657727682604*v_R1_n_i + 105.57176931318*v_R1_n_r + 20.5427472507027*v_R2_a_i + 79.2784458116403*v_R2_a_r + 46.569928961908*v_R2_b_i + 49.9151995897384*v_R2_b_r + 20.5427472507027*v_R2_c_i + 79.2784458116403*v_R2_c_r - 108.131545536521*v_R2_n_i - 211.16853862636*v_R2_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r - 23.284964480954*v_R3_b_i - 24.9575997948692*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058202*v_R3_c_r + 54.0657727682604*v_R3_n_i + 105.57176931318*v_R3_n_r
        struct[0].g[55,0] = -39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r - 24.9575997948692*v_R1_b_i + 23.284964480954*v_R1_b_r - 39.6392229058202*v_R1_c_i + 10.2713736253513*v_R1_c_r + 105.57176931318*v_R1_n_i - 54.0657727682604*v_R1_n_r + 79.2784458116403*v_R2_a_i - 20.5427472507027*v_R2_a_r + 49.9151995897384*v_R2_b_i - 46.569928961908*v_R2_b_r + 79.2784458116403*v_R2_c_i - 20.5427472507027*v_R2_c_r - 211.16853862636*v_R2_n_i + 108.131545536521*v_R2_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r - 24.9575997948692*v_R3_b_i + 23.284964480954*v_R3_b_r - 39.6392229058202*v_R3_c_i + 10.2713736253513*v_R3_c_r + 105.57176931318*v_R3_n_i - 54.0657727682604*v_R3_n_r
        struct[0].g[56,0] = 4.84676915585801*v_R11_a_i + 26.5300693004806*v_R11_a_r + 1.58482814504483*v_R11_b_i - 7.8946133751477*v_R11_b_r + 0.67991845328531*v_R11_c_i - 7.72144347466701*v_R11_c_r + 1.58482814504483*v_R11_n_i - 7.89461337514771*v_R11_n_r + 54.0657727682604*v_R2_a_i + 105.57176931318*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r - 23.284964480954*v_R2_c_i - 24.9575997948692*v_R2_c_r - 10.2713736253513*v_R2_n_i - 39.6392229058202*v_R2_n_r - 112.978314692379*v_R3_a_i - 237.673607926841*v_R3_a_r + 18.9579191056578*v_R3_b_i + 87.173059186788*v_R3_b_r + 45.8900105086227*v_R3_c_i + 57.6366430644055*v_R3_c_r + 18.9579191056579*v_R3_n_i + 87.173059186788*v_R3_n_r + 54.0657727682604*v_R4_a_i + 105.57176931318*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r - 23.284964480954*v_R4_c_i - 24.9575997948692*v_R4_c_r - 10.2713736253513*v_R4_n_i - 39.6392229058202*v_R4_n_r
        struct[0].g[57,0] = 26.5300693004806*v_R11_a_i - 4.84676915585801*v_R11_a_r - 7.8946133751477*v_R11_b_i - 1.58482814504483*v_R11_b_r - 7.72144347466701*v_R11_c_i - 0.67991845328531*v_R11_c_r - 7.89461337514771*v_R11_n_i - 1.58482814504483*v_R11_n_r + 105.57176931318*v_R2_a_i - 54.0657727682604*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r - 24.9575997948692*v_R2_c_i + 23.284964480954*v_R2_c_r - 39.6392229058202*v_R2_n_i + 10.2713736253513*v_R2_n_r - 237.673607926841*v_R3_a_i + 112.978314692379*v_R3_a_r + 87.173059186788*v_R3_b_i - 18.9579191056578*v_R3_b_r + 57.6366430644055*v_R3_c_i - 45.8900105086227*v_R3_c_r + 87.173059186788*v_R3_n_i - 18.9579191056579*v_R3_n_r + 105.57176931318*v_R4_a_i - 54.0657727682604*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r - 24.9575997948692*v_R4_c_i + 23.284964480954*v_R4_c_r - 39.6392229058202*v_R4_n_i + 10.2713736253513*v_R4_n_r
        struct[0].g[58,0] = 1.58482814504483*v_R11_a_i - 7.89461337514771*v_R11_a_r + 4.84676915585801*v_R11_b_i + 26.5300693004806*v_R11_b_r + 1.58482814504483*v_R11_c_i - 7.89461337514771*v_R11_c_r + 0.679918453285308*v_R11_n_i - 7.72144347466701*v_R11_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r + 54.0657727682604*v_R2_b_i + 105.57176931318*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058201*v_R2_c_r - 23.284964480954*v_R2_n_i - 24.9575997948692*v_R2_n_r + 18.9579191056579*v_R3_a_i + 87.173059186788*v_R3_a_r - 112.978314692379*v_R3_b_i - 237.673607926841*v_R3_b_r + 18.9579191056579*v_R3_c_i + 87.173059186788*v_R3_c_r + 45.8900105086227*v_R3_n_i + 57.6366430644054*v_R3_n_r - 10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r + 54.0657727682604*v_R4_b_i + 105.57176931318*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058201*v_R4_c_r - 23.284964480954*v_R4_n_i - 24.9575997948692*v_R4_n_r
        struct[0].g[59,0] = -7.89461337514771*v_R11_a_i - 1.58482814504483*v_R11_a_r + 26.5300693004806*v_R11_b_i - 4.84676915585801*v_R11_b_r - 7.89461337514771*v_R11_c_i - 1.58482814504483*v_R11_c_r - 7.72144347466701*v_R11_n_i - 0.679918453285308*v_R11_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r + 105.57176931318*v_R2_b_i - 54.0657727682604*v_R2_b_r - 39.6392229058201*v_R2_c_i + 10.2713736253513*v_R2_c_r - 24.9575997948692*v_R2_n_i + 23.284964480954*v_R2_n_r + 87.173059186788*v_R3_a_i - 18.9579191056579*v_R3_a_r - 237.673607926841*v_R3_b_i + 112.978314692379*v_R3_b_r + 87.173059186788*v_R3_c_i - 18.9579191056579*v_R3_c_r + 57.6366430644054*v_R3_n_i - 45.8900105086227*v_R3_n_r - 39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r + 105.57176931318*v_R4_b_i - 54.0657727682604*v_R4_b_r - 39.6392229058201*v_R4_c_i + 10.2713736253513*v_R4_c_r - 24.9575997948692*v_R4_n_i + 23.284964480954*v_R4_n_r
        struct[0].g[60,0] = 0.67991845328531*v_R11_a_i - 7.72144347466701*v_R11_a_r + 1.58482814504483*v_R11_b_i - 7.8946133751477*v_R11_b_r + 4.84676915585801*v_R11_c_i + 26.5300693004806*v_R11_c_r + 1.58482814504483*v_R11_n_i - 7.89461337514771*v_R11_n_r - 23.284964480954*v_R2_a_i - 24.9575997948692*v_R2_a_r - 10.2713736253513*v_R2_b_i - 39.6392229058202*v_R2_b_r + 54.0657727682604*v_R2_c_i + 105.57176931318*v_R2_c_r - 10.2713736253514*v_R2_n_i - 39.6392229058201*v_R2_n_r + 45.8900105086227*v_R3_a_i + 57.6366430644054*v_R3_a_r + 18.9579191056578*v_R3_b_i + 87.1730591867881*v_R3_b_r - 112.978314692379*v_R3_c_i - 237.673607926841*v_R3_c_r + 18.9579191056579*v_R3_n_i + 87.173059186788*v_R3_n_r - 23.284964480954*v_R4_a_i - 24.9575997948692*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r + 54.0657727682604*v_R4_c_i + 105.57176931318*v_R4_c_r - 10.2713736253514*v_R4_n_i - 39.6392229058201*v_R4_n_r
        struct[0].g[61,0] = -7.72144347466701*v_R11_a_i - 0.67991845328531*v_R11_a_r - 7.8946133751477*v_R11_b_i - 1.58482814504483*v_R11_b_r + 26.5300693004806*v_R11_c_i - 4.84676915585801*v_R11_c_r - 7.89461337514771*v_R11_n_i - 1.58482814504483*v_R11_n_r - 24.9575997948692*v_R2_a_i + 23.284964480954*v_R2_a_r - 39.6392229058202*v_R2_b_i + 10.2713736253513*v_R2_b_r + 105.57176931318*v_R2_c_i - 54.0657727682604*v_R2_c_r - 39.6392229058201*v_R2_n_i + 10.2713736253514*v_R2_n_r + 57.6366430644054*v_R3_a_i - 45.8900105086227*v_R3_a_r + 87.1730591867881*v_R3_b_i - 18.9579191056578*v_R3_b_r - 237.673607926841*v_R3_c_i + 112.978314692379*v_R3_c_r + 87.173059186788*v_R3_n_i - 18.9579191056579*v_R3_n_r - 24.9575997948692*v_R4_a_i + 23.284964480954*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r + 105.57176931318*v_R4_c_i - 54.0657727682604*v_R4_c_r - 39.6392229058201*v_R4_n_i + 10.2713736253514*v_R4_n_r
        struct[0].g[62,0] = 1.58482814504483*v_R11_a_i - 7.89461337514771*v_R11_a_r + 0.679918453285308*v_R11_b_i - 7.72144347466701*v_R11_b_r + 1.58482814504483*v_R11_c_i - 7.89461337514771*v_R11_c_r + 4.84676915585801*v_R11_n_i + 26.5300693004806*v_R11_n_r - 10.2713736253513*v_R2_a_i - 39.6392229058202*v_R2_a_r - 23.284964480954*v_R2_b_i - 24.9575997948692*v_R2_b_r - 10.2713736253513*v_R2_c_i - 39.6392229058202*v_R2_c_r + 54.0657727682604*v_R2_n_i + 105.57176931318*v_R2_n_r + 18.9579191056578*v_R3_a_i + 87.173059186788*v_R3_a_r + 45.8900105086227*v_R3_b_i + 57.6366430644054*v_R3_b_r + 18.9579191056579*v_R3_c_i + 87.173059186788*v_R3_c_r - 112.978314692379*v_R3_n_i - 237.673607926841*v_R3_n_r - 10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r - 23.284964480954*v_R4_b_i - 24.9575997948692*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058202*v_R4_c_r + 54.0657727682604*v_R4_n_i + 105.57176931318*v_R4_n_r
        struct[0].g[63,0] = -7.89461337514771*v_R11_a_i - 1.58482814504483*v_R11_a_r - 7.72144347466701*v_R11_b_i - 0.679918453285308*v_R11_b_r - 7.89461337514771*v_R11_c_i - 1.58482814504483*v_R11_c_r + 26.5300693004806*v_R11_n_i - 4.84676915585801*v_R11_n_r - 39.6392229058202*v_R2_a_i + 10.2713736253513*v_R2_a_r - 24.9575997948692*v_R2_b_i + 23.284964480954*v_R2_b_r - 39.6392229058202*v_R2_c_i + 10.2713736253513*v_R2_c_r + 105.57176931318*v_R2_n_i - 54.0657727682604*v_R2_n_r + 87.173059186788*v_R3_a_i - 18.9579191056578*v_R3_a_r + 57.6366430644054*v_R3_b_i - 45.8900105086227*v_R3_b_r + 87.173059186788*v_R3_c_i - 18.9579191056579*v_R3_c_r - 237.673607926841*v_R3_n_i + 112.978314692379*v_R3_n_r - 39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r - 24.9575997948692*v_R4_b_i + 23.284964480954*v_R4_b_r - 39.6392229058202*v_R4_c_i + 10.2713736253513*v_R4_c_r + 105.57176931318*v_R4_n_i - 54.0657727682604*v_R4_n_r
        struct[0].g[64,0] = 4.84676915585801*v_R12_a_i + 26.5300693004806*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 0.67991845328531*v_R12_c_i - 7.72144347466701*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r + 54.0657727682604*v_R3_a_i + 105.57176931318*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r - 23.284964480954*v_R3_c_i - 24.9575997948692*v_R3_c_r - 10.2713736253513*v_R3_n_i - 39.6392229058202*v_R3_n_r - 112.978314692379*v_R4_a_i - 237.673607926841*v_R4_a_r + 18.9579191056578*v_R4_b_i + 87.173059186788*v_R4_b_r + 45.8900105086227*v_R4_c_i + 57.6366430644055*v_R4_c_r + 18.9579191056579*v_R4_n_i + 87.173059186788*v_R4_n_r + 54.0657727682604*v_R5_a_i + 105.57176931318*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r - 23.284964480954*v_R5_c_i - 24.9575997948692*v_R5_c_r - 10.2713736253513*v_R5_n_i - 39.6392229058202*v_R5_n_r
        struct[0].g[65,0] = 26.5300693004806*v_R12_a_i - 4.84676915585801*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r - 7.72144347466701*v_R12_c_i - 0.67991845328531*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r + 105.57176931318*v_R3_a_i - 54.0657727682604*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r - 24.9575997948692*v_R3_c_i + 23.284964480954*v_R3_c_r - 39.6392229058202*v_R3_n_i + 10.2713736253513*v_R3_n_r - 237.673607926841*v_R4_a_i + 112.978314692379*v_R4_a_r + 87.173059186788*v_R4_b_i - 18.9579191056578*v_R4_b_r + 57.6366430644055*v_R4_c_i - 45.8900105086227*v_R4_c_r + 87.173059186788*v_R4_n_i - 18.9579191056579*v_R4_n_r + 105.57176931318*v_R5_a_i - 54.0657727682604*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r - 24.9575997948692*v_R5_c_i + 23.284964480954*v_R5_c_r - 39.6392229058202*v_R5_n_i + 10.2713736253513*v_R5_n_r
        struct[0].g[66,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 4.84676915585801*v_R12_b_i + 26.5300693004806*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 0.679918453285308*v_R12_n_i - 7.72144347466701*v_R12_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r + 54.0657727682604*v_R3_b_i + 105.57176931318*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058201*v_R3_c_r - 23.284964480954*v_R3_n_i - 24.9575997948692*v_R3_n_r + 18.9579191056579*v_R4_a_i + 87.173059186788*v_R4_a_r - 112.978314692379*v_R4_b_i - 237.673607926841*v_R4_b_r + 18.9579191056579*v_R4_c_i + 87.173059186788*v_R4_c_r + 45.8900105086227*v_R4_n_i + 57.6366430644054*v_R4_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r + 54.0657727682604*v_R5_b_i + 105.57176931318*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058201*v_R5_c_r - 23.284964480954*v_R5_n_i - 24.9575997948692*v_R5_n_r
        struct[0].g[67,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r + 26.5300693004806*v_R12_b_i - 4.84676915585801*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r - 7.72144347466701*v_R12_n_i - 0.679918453285308*v_R12_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r + 105.57176931318*v_R3_b_i - 54.0657727682604*v_R3_b_r - 39.6392229058201*v_R3_c_i + 10.2713736253513*v_R3_c_r - 24.9575997948692*v_R3_n_i + 23.284964480954*v_R3_n_r + 87.173059186788*v_R4_a_i - 18.9579191056579*v_R4_a_r - 237.673607926841*v_R4_b_i + 112.978314692379*v_R4_b_r + 87.173059186788*v_R4_c_i - 18.9579191056579*v_R4_c_r + 57.6366430644054*v_R4_n_i - 45.8900105086227*v_R4_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r + 105.57176931318*v_R5_b_i - 54.0657727682604*v_R5_b_r - 39.6392229058201*v_R5_c_i + 10.2713736253513*v_R5_c_r - 24.9575997948692*v_R5_n_i + 23.284964480954*v_R5_n_r
        struct[0].g[68,0] = 0.67991845328531*v_R12_a_i - 7.72144347466701*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 4.84676915585801*v_R12_c_i + 26.5300693004806*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 23.284964480954*v_R3_a_i - 24.9575997948692*v_R3_a_r - 10.2713736253513*v_R3_b_i - 39.6392229058202*v_R3_b_r + 54.0657727682604*v_R3_c_i + 105.57176931318*v_R3_c_r - 10.2713736253514*v_R3_n_i - 39.6392229058201*v_R3_n_r + 45.8900105086227*v_R4_a_i + 57.6366430644054*v_R4_a_r + 18.9579191056578*v_R4_b_i + 87.1730591867881*v_R4_b_r - 112.978314692379*v_R4_c_i - 237.673607926841*v_R4_c_r + 18.9579191056579*v_R4_n_i + 87.173059186788*v_R4_n_r - 23.284964480954*v_R5_a_i - 24.9575997948692*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r + 54.0657727682604*v_R5_c_i + 105.57176931318*v_R5_c_r - 10.2713736253514*v_R5_n_i - 39.6392229058201*v_R5_n_r
        struct[0].g[69,0] = -7.72144347466701*v_R12_a_i - 0.67991845328531*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r + 26.5300693004806*v_R12_c_i - 4.84676915585801*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r - 24.9575997948692*v_R3_a_i + 23.284964480954*v_R3_a_r - 39.6392229058202*v_R3_b_i + 10.2713736253513*v_R3_b_r + 105.57176931318*v_R3_c_i - 54.0657727682604*v_R3_c_r - 39.6392229058201*v_R3_n_i + 10.2713736253514*v_R3_n_r + 57.6366430644054*v_R4_a_i - 45.8900105086227*v_R4_a_r + 87.1730591867881*v_R4_b_i - 18.9579191056578*v_R4_b_r - 237.673607926841*v_R4_c_i + 112.978314692379*v_R4_c_r + 87.173059186788*v_R4_n_i - 18.9579191056579*v_R4_n_r - 24.9575997948692*v_R5_a_i + 23.284964480954*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r + 105.57176931318*v_R5_c_i - 54.0657727682604*v_R5_c_r - 39.6392229058201*v_R5_n_i + 10.2713736253514*v_R5_n_r
        struct[0].g[70,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 0.679918453285308*v_R12_b_i - 7.72144347466701*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 4.84676915585801*v_R12_n_i + 26.5300693004806*v_R12_n_r - 10.2713736253513*v_R3_a_i - 39.6392229058202*v_R3_a_r - 23.284964480954*v_R3_b_i - 24.9575997948692*v_R3_b_r - 10.2713736253513*v_R3_c_i - 39.6392229058202*v_R3_c_r + 54.0657727682604*v_R3_n_i + 105.57176931318*v_R3_n_r + 18.9579191056578*v_R4_a_i + 87.173059186788*v_R4_a_r + 45.8900105086227*v_R4_b_i + 57.6366430644054*v_R4_b_r + 18.9579191056579*v_R4_c_i + 87.173059186788*v_R4_c_r - 112.978314692379*v_R4_n_i - 237.698607926841*v_R4_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r - 23.284964480954*v_R5_b_i - 24.9575997948692*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058202*v_R5_c_r + 54.0657727682604*v_R5_n_i + 105.57176931318*v_R5_n_r
        struct[0].g[71,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r - 7.72144347466701*v_R12_b_i - 0.679918453285308*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r + 26.5300693004806*v_R12_n_i - 4.84676915585801*v_R12_n_r - 39.6392229058202*v_R3_a_i + 10.2713736253513*v_R3_a_r - 24.9575997948692*v_R3_b_i + 23.284964480954*v_R3_b_r - 39.6392229058202*v_R3_c_i + 10.2713736253513*v_R3_c_r + 105.57176931318*v_R3_n_i - 54.0657727682604*v_R3_n_r + 87.173059186788*v_R4_a_i - 18.9579191056578*v_R4_a_r + 57.6366430644054*v_R4_b_i - 45.8900105086227*v_R4_b_r + 87.173059186788*v_R4_c_i - 18.9579191056579*v_R4_c_r - 237.698607926841*v_R4_n_i + 112.978314692379*v_R4_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r - 24.9575997948692*v_R5_b_i + 23.284964480954*v_R5_b_r - 39.6392229058202*v_R5_c_i + 10.2713736253513*v_R5_c_r + 105.57176931318*v_R5_n_i - 54.0657727682604*v_R5_n_r
        struct[0].g[72,0] = 54.0657727682604*v_R4_a_i + 105.57176931318*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r - 23.284964480954*v_R4_c_i - 24.9575997948692*v_R4_c_r - 10.2713736253513*v_R4_n_i - 39.6392229058202*v_R4_n_r - 108.131545536521*v_R5_a_i - 211.14353862636*v_R5_a_r + 20.5427472507027*v_R5_b_i + 79.2784458116403*v_R5_b_r + 46.569928961908*v_R5_c_i + 49.9151995897384*v_R5_c_r + 20.5427472507027*v_R5_n_i + 79.2784458116403*v_R5_n_r + 54.0657727682604*v_R6_a_i + 105.57176931318*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r - 23.284964480954*v_R6_c_i - 24.9575997948692*v_R6_c_r - 10.2713736253513*v_R6_n_i - 39.6392229058202*v_R6_n_r
        struct[0].g[73,0] = 105.57176931318*v_R4_a_i - 54.0657727682604*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r - 24.9575997948692*v_R4_c_i + 23.284964480954*v_R4_c_r - 39.6392229058202*v_R4_n_i + 10.2713736253513*v_R4_n_r - 211.14353862636*v_R5_a_i + 108.131545536521*v_R5_a_r + 79.2784458116403*v_R5_b_i - 20.5427472507027*v_R5_b_r + 49.9151995897384*v_R5_c_i - 46.569928961908*v_R5_c_r + 79.2784458116403*v_R5_n_i - 20.5427472507027*v_R5_n_r + 105.57176931318*v_R6_a_i - 54.0657727682604*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r - 24.9575997948692*v_R6_c_i + 23.284964480954*v_R6_c_r - 39.6392229058202*v_R6_n_i + 10.2713736253513*v_R6_n_r
        struct[0].g[74,0] = -10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r + 54.0657727682604*v_R4_b_i + 105.57176931318*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058201*v_R4_c_r - 23.284964480954*v_R4_n_i - 24.9575997948692*v_R4_n_r + 20.5427472507027*v_R5_a_i + 79.2784458116403*v_R5_a_r - 108.131545536521*v_R5_b_i - 211.14353862636*v_R5_b_r + 20.5427472507027*v_R5_c_i + 79.2784458116403*v_R5_c_r + 46.569928961908*v_R5_n_i + 49.9151995897384*v_R5_n_r - 10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r + 54.0657727682604*v_R6_b_i + 105.57176931318*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058201*v_R6_c_r - 23.284964480954*v_R6_n_i - 24.9575997948692*v_R6_n_r
        struct[0].g[75,0] = -39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r + 105.57176931318*v_R4_b_i - 54.0657727682604*v_R4_b_r - 39.6392229058201*v_R4_c_i + 10.2713736253513*v_R4_c_r - 24.9575997948692*v_R4_n_i + 23.284964480954*v_R4_n_r + 79.2784458116403*v_R5_a_i - 20.5427472507027*v_R5_a_r - 211.14353862636*v_R5_b_i + 108.131545536521*v_R5_b_r + 79.2784458116403*v_R5_c_i - 20.5427472507027*v_R5_c_r + 49.9151995897384*v_R5_n_i - 46.569928961908*v_R5_n_r - 39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r + 105.57176931318*v_R6_b_i - 54.0657727682604*v_R6_b_r - 39.6392229058201*v_R6_c_i + 10.2713736253513*v_R6_c_r - 24.9575997948692*v_R6_n_i + 23.284964480954*v_R6_n_r
        struct[0].g[76,0] = -23.284964480954*v_R4_a_i - 24.9575997948692*v_R4_a_r - 10.2713736253513*v_R4_b_i - 39.6392229058202*v_R4_b_r + 54.0657727682604*v_R4_c_i + 105.57176931318*v_R4_c_r - 10.2713736253514*v_R4_n_i - 39.6392229058201*v_R4_n_r + 46.569928961908*v_R5_a_i + 49.9151995897384*v_R5_a_r + 20.5427472507027*v_R5_b_i + 79.2784458116404*v_R5_b_r - 108.131545536521*v_R5_c_i - 211.14353862636*v_R5_c_r + 20.5427472507027*v_R5_n_i + 79.2784458116403*v_R5_n_r - 23.284964480954*v_R6_a_i - 24.9575997948692*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r + 54.0657727682604*v_R6_c_i + 105.57176931318*v_R6_c_r - 10.2713736253514*v_R6_n_i - 39.6392229058201*v_R6_n_r
        struct[0].g[77,0] = -24.9575997948692*v_R4_a_i + 23.284964480954*v_R4_a_r - 39.6392229058202*v_R4_b_i + 10.2713736253513*v_R4_b_r + 105.57176931318*v_R4_c_i - 54.0657727682604*v_R4_c_r - 39.6392229058201*v_R4_n_i + 10.2713736253514*v_R4_n_r + 49.9151995897384*v_R5_a_i - 46.569928961908*v_R5_a_r + 79.2784458116404*v_R5_b_i - 20.5427472507027*v_R5_b_r - 211.14353862636*v_R5_c_i + 108.131545536521*v_R5_c_r + 79.2784458116403*v_R5_n_i - 20.5427472507027*v_R5_n_r - 24.9575997948692*v_R6_a_i + 23.284964480954*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r + 105.57176931318*v_R6_c_i - 54.0657727682604*v_R6_c_r - 39.6392229058201*v_R6_n_i + 10.2713736253514*v_R6_n_r
        struct[0].g[78,0] = -10.2713736253513*v_R4_a_i - 39.6392229058202*v_R4_a_r - 23.284964480954*v_R4_b_i - 24.9575997948692*v_R4_b_r - 10.2713736253513*v_R4_c_i - 39.6392229058202*v_R4_c_r + 54.0657727682604*v_R4_n_i + 105.57176931318*v_R4_n_r + 20.5427472507027*v_R5_a_i + 79.2784458116403*v_R5_a_r + 46.569928961908*v_R5_b_i + 49.9151995897384*v_R5_b_r + 20.5427472507027*v_R5_c_i + 79.2784458116403*v_R5_c_r - 108.131545536521*v_R5_n_i - 211.14353862636*v_R5_n_r - 10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r - 23.284964480954*v_R6_b_i - 24.9575997948692*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058202*v_R6_c_r + 54.0657727682604*v_R6_n_i + 105.57176931318*v_R6_n_r
        struct[0].g[79,0] = -39.6392229058202*v_R4_a_i + 10.2713736253513*v_R4_a_r - 24.9575997948692*v_R4_b_i + 23.284964480954*v_R4_b_r - 39.6392229058202*v_R4_c_i + 10.2713736253513*v_R4_c_r + 105.57176931318*v_R4_n_i - 54.0657727682604*v_R4_n_r + 79.2784458116403*v_R5_a_i - 20.5427472507027*v_R5_a_r + 49.9151995897384*v_R5_b_i - 46.569928961908*v_R5_b_r + 79.2784458116403*v_R5_c_i - 20.5427472507027*v_R5_c_r - 211.14353862636*v_R5_n_i + 108.131545536521*v_R5_n_r - 39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r - 24.9575997948692*v_R6_b_i + 23.284964480954*v_R6_b_r - 39.6392229058202*v_R6_c_i + 10.2713736253513*v_R6_c_r + 105.57176931318*v_R6_n_i - 54.0657727682604*v_R6_n_r
        struct[0].g[80,0] = 5.65456401516768*v_R16_a_i + 30.9517475172273*v_R16_a_r + 1.84896616921897*v_R16_b_i - 9.21038227100566*v_R16_b_r + 0.793238195499529*v_R16_c_i - 9.00835072044485*v_R16_c_r + 1.84896616921897*v_R16_n_i - 9.21038227100566*v_R16_n_r + 54.0657727682604*v_R5_a_i + 105.57176931318*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r - 23.284964480954*v_R5_c_i - 24.9575997948692*v_R5_c_r - 10.2713736253513*v_R5_n_i - 39.6392229058202*v_R5_n_r - 113.786109551688*v_R6_a_i - 242.095286143588*v_R6_a_r + 18.6937810814837*v_R6_b_i + 88.488828082646*v_R6_b_r + 45.7766907664085*v_R6_c_i + 58.9235503101833*v_R6_c_r + 18.6937810814837*v_R6_n_i + 88.488828082646*v_R6_n_r + 54.0657727682604*v_R7_a_i + 105.57176931318*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r - 23.284964480954*v_R7_c_i - 24.9575997948692*v_R7_c_r - 10.2713736253513*v_R7_n_i - 39.6392229058202*v_R7_n_r
        struct[0].g[81,0] = 30.9517475172273*v_R16_a_i - 5.65456401516768*v_R16_a_r - 9.21038227100566*v_R16_b_i - 1.84896616921897*v_R16_b_r - 9.00835072044485*v_R16_c_i - 0.793238195499529*v_R16_c_r - 9.21038227100566*v_R16_n_i - 1.84896616921897*v_R16_n_r + 105.57176931318*v_R5_a_i - 54.0657727682604*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r - 24.9575997948692*v_R5_c_i + 23.284964480954*v_R5_c_r - 39.6392229058202*v_R5_n_i + 10.2713736253513*v_R5_n_r - 242.095286143588*v_R6_a_i + 113.786109551688*v_R6_a_r + 88.488828082646*v_R6_b_i - 18.6937810814837*v_R6_b_r + 58.9235503101833*v_R6_c_i - 45.7766907664085*v_R6_c_r + 88.488828082646*v_R6_n_i - 18.6937810814837*v_R6_n_r + 105.57176931318*v_R7_a_i - 54.0657727682604*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r - 24.9575997948692*v_R7_c_i + 23.284964480954*v_R7_c_r - 39.6392229058202*v_R7_n_i + 10.2713736253513*v_R7_n_r
        struct[0].g[82,0] = 1.84896616921897*v_R16_a_i - 9.21038227100566*v_R16_a_r + 5.65456401516768*v_R16_b_i + 30.9517475172273*v_R16_b_r + 1.84896616921897*v_R16_c_i - 9.21038227100566*v_R16_c_r + 0.793238195499528*v_R16_n_i - 9.00835072044485*v_R16_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r + 54.0657727682604*v_R5_b_i + 105.57176931318*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058201*v_R5_c_r - 23.284964480954*v_R5_n_i - 24.9575997948692*v_R5_n_r + 18.6937810814837*v_R6_a_i + 88.488828082646*v_R6_a_r - 113.786109551688*v_R6_b_i - 242.095286143588*v_R6_b_r + 18.6937810814837*v_R6_c_i + 88.488828082646*v_R6_c_r + 45.7766907664085*v_R6_n_i + 58.9235503101833*v_R6_n_r - 10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r + 54.0657727682604*v_R7_b_i + 105.57176931318*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058201*v_R7_c_r - 23.284964480954*v_R7_n_i - 24.9575997948692*v_R7_n_r
        struct[0].g[83,0] = -9.21038227100566*v_R16_a_i - 1.84896616921897*v_R16_a_r + 30.9517475172273*v_R16_b_i - 5.65456401516768*v_R16_b_r - 9.21038227100566*v_R16_c_i - 1.84896616921897*v_R16_c_r - 9.00835072044485*v_R16_n_i - 0.793238195499528*v_R16_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r + 105.57176931318*v_R5_b_i - 54.0657727682604*v_R5_b_r - 39.6392229058201*v_R5_c_i + 10.2713736253513*v_R5_c_r - 24.9575997948692*v_R5_n_i + 23.284964480954*v_R5_n_r + 88.488828082646*v_R6_a_i - 18.6937810814837*v_R6_a_r - 242.095286143588*v_R6_b_i + 113.786109551688*v_R6_b_r + 88.488828082646*v_R6_c_i - 18.6937810814837*v_R6_c_r + 58.9235503101833*v_R6_n_i - 45.7766907664085*v_R6_n_r - 39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r + 105.57176931318*v_R7_b_i - 54.0657727682604*v_R7_b_r - 39.6392229058201*v_R7_c_i + 10.2713736253513*v_R7_c_r - 24.9575997948692*v_R7_n_i + 23.284964480954*v_R7_n_r
        struct[0].g[84,0] = 0.793238195499527*v_R16_a_i - 9.00835072044484*v_R16_a_r + 1.84896616921897*v_R16_b_i - 9.21038227100566*v_R16_b_r + 5.65456401516768*v_R16_c_i + 30.9517475172273*v_R16_c_r + 1.84896616921897*v_R16_n_i - 9.21038227100566*v_R16_n_r - 23.284964480954*v_R5_a_i - 24.9575997948692*v_R5_a_r - 10.2713736253513*v_R5_b_i - 39.6392229058202*v_R5_b_r + 54.0657727682604*v_R5_c_i + 105.57176931318*v_R5_c_r - 10.2713736253514*v_R5_n_i - 39.6392229058201*v_R5_n_r + 45.7766907664085*v_R6_a_i + 58.9235503101833*v_R6_a_r + 18.6937810814837*v_R6_b_i + 88.4888280826461*v_R6_b_r - 113.786109551688*v_R6_c_i - 242.095286143588*v_R6_c_r + 18.6937810814837*v_R6_n_i + 88.4888280826459*v_R6_n_r - 23.284964480954*v_R7_a_i - 24.9575997948692*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r + 54.0657727682604*v_R7_c_i + 105.57176931318*v_R7_c_r - 10.2713736253514*v_R7_n_i - 39.6392229058201*v_R7_n_r
        struct[0].g[85,0] = -9.00835072044484*v_R16_a_i - 0.793238195499527*v_R16_a_r - 9.21038227100566*v_R16_b_i - 1.84896616921897*v_R16_b_r + 30.9517475172273*v_R16_c_i - 5.65456401516768*v_R16_c_r - 9.21038227100566*v_R16_n_i - 1.84896616921897*v_R16_n_r - 24.9575997948692*v_R5_a_i + 23.284964480954*v_R5_a_r - 39.6392229058202*v_R5_b_i + 10.2713736253513*v_R5_b_r + 105.57176931318*v_R5_c_i - 54.0657727682604*v_R5_c_r - 39.6392229058201*v_R5_n_i + 10.2713736253514*v_R5_n_r + 58.9235503101833*v_R6_a_i - 45.7766907664085*v_R6_a_r + 88.4888280826461*v_R6_b_i - 18.6937810814837*v_R6_b_r - 242.095286143588*v_R6_c_i + 113.786109551688*v_R6_c_r + 88.4888280826459*v_R6_n_i - 18.6937810814837*v_R6_n_r - 24.9575997948692*v_R7_a_i + 23.284964480954*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r + 105.57176931318*v_R7_c_i - 54.0657727682604*v_R7_c_r - 39.6392229058201*v_R7_n_i + 10.2713736253514*v_R7_n_r
        struct[0].g[86,0] = 1.84896616921897*v_R16_a_i - 9.21038227100566*v_R16_a_r + 0.793238195499527*v_R16_b_i - 9.00835072044485*v_R16_b_r + 1.84896616921897*v_R16_c_i - 9.21038227100566*v_R16_c_r + 5.65456401516768*v_R16_n_i + 30.9517475172273*v_R16_n_r - 10.2713736253513*v_R5_a_i - 39.6392229058202*v_R5_a_r - 23.284964480954*v_R5_b_i - 24.9575997948692*v_R5_b_r - 10.2713736253513*v_R5_c_i - 39.6392229058202*v_R5_c_r + 54.0657727682604*v_R5_n_i + 105.57176931318*v_R5_n_r + 18.6937810814837*v_R6_a_i + 88.488828082646*v_R6_a_r + 45.7766907664085*v_R6_b_i + 58.9235503101832*v_R6_b_r + 18.6937810814837*v_R6_c_i + 88.488828082646*v_R6_c_r - 113.786109551688*v_R6_n_i - 242.120286143588*v_R6_n_r - 10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r - 23.284964480954*v_R7_b_i - 24.9575997948692*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058202*v_R7_c_r + 54.0657727682604*v_R7_n_i + 105.57176931318*v_R7_n_r
        struct[0].g[87,0] = -9.21038227100566*v_R16_a_i - 1.84896616921897*v_R16_a_r - 9.00835072044485*v_R16_b_i - 0.793238195499527*v_R16_b_r - 9.21038227100566*v_R16_c_i - 1.84896616921897*v_R16_c_r + 30.9517475172273*v_R16_n_i - 5.65456401516768*v_R16_n_r - 39.6392229058202*v_R5_a_i + 10.2713736253513*v_R5_a_r - 24.9575997948692*v_R5_b_i + 23.284964480954*v_R5_b_r - 39.6392229058202*v_R5_c_i + 10.2713736253513*v_R5_c_r + 105.57176931318*v_R5_n_i - 54.0657727682604*v_R5_n_r + 88.488828082646*v_R6_a_i - 18.6937810814837*v_R6_a_r + 58.9235503101832*v_R6_b_i - 45.7766907664085*v_R6_b_r + 88.488828082646*v_R6_c_i - 18.6937810814837*v_R6_c_r - 242.120286143588*v_R6_n_i + 113.786109551688*v_R6_n_r - 39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r - 24.9575997948692*v_R7_b_i + 23.284964480954*v_R7_b_r - 39.6392229058202*v_R7_c_i + 10.2713736253513*v_R7_c_r + 105.57176931318*v_R7_n_i - 54.0657727682604*v_R7_n_r
        struct[0].g[88,0] = 54.0657727682604*v_R6_a_i + 105.57176931318*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r - 23.284964480954*v_R6_c_i - 24.9575997948692*v_R6_c_r - 10.2713736253513*v_R6_n_i - 39.6392229058202*v_R6_n_r - 108.131545536521*v_R7_a_i - 211.14353862636*v_R7_a_r + 20.5427472507027*v_R7_b_i + 79.2784458116403*v_R7_b_r + 46.569928961908*v_R7_c_i + 49.9151995897384*v_R7_c_r + 20.5427472507027*v_R7_n_i + 79.2784458116403*v_R7_n_r + 54.0657727682604*v_R8_a_i + 105.57176931318*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r - 23.284964480954*v_R8_c_i - 24.9575997948692*v_R8_c_r - 10.2713736253513*v_R8_n_i - 39.6392229058202*v_R8_n_r
        struct[0].g[89,0] = 105.57176931318*v_R6_a_i - 54.0657727682604*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r - 24.9575997948692*v_R6_c_i + 23.284964480954*v_R6_c_r - 39.6392229058202*v_R6_n_i + 10.2713736253513*v_R6_n_r - 211.14353862636*v_R7_a_i + 108.131545536521*v_R7_a_r + 79.2784458116403*v_R7_b_i - 20.5427472507027*v_R7_b_r + 49.9151995897384*v_R7_c_i - 46.569928961908*v_R7_c_r + 79.2784458116403*v_R7_n_i - 20.5427472507027*v_R7_n_r + 105.57176931318*v_R8_a_i - 54.0657727682604*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r - 24.9575997948692*v_R8_c_i + 23.284964480954*v_R8_c_r - 39.6392229058202*v_R8_n_i + 10.2713736253513*v_R8_n_r
        struct[0].g[90,0] = -10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r + 54.0657727682604*v_R6_b_i + 105.57176931318*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058201*v_R6_c_r - 23.284964480954*v_R6_n_i - 24.9575997948692*v_R6_n_r + 20.5427472507027*v_R7_a_i + 79.2784458116403*v_R7_a_r - 108.131545536521*v_R7_b_i - 211.14353862636*v_R7_b_r + 20.5427472507027*v_R7_c_i + 79.2784458116403*v_R7_c_r + 46.569928961908*v_R7_n_i + 49.9151995897384*v_R7_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r + 54.0657727682604*v_R8_b_i + 105.57176931318*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058201*v_R8_c_r - 23.284964480954*v_R8_n_i - 24.9575997948692*v_R8_n_r
        struct[0].g[91,0] = -39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r + 105.57176931318*v_R6_b_i - 54.0657727682604*v_R6_b_r - 39.6392229058201*v_R6_c_i + 10.2713736253513*v_R6_c_r - 24.9575997948692*v_R6_n_i + 23.284964480954*v_R6_n_r + 79.2784458116403*v_R7_a_i - 20.5427472507027*v_R7_a_r - 211.14353862636*v_R7_b_i + 108.131545536521*v_R7_b_r + 79.2784458116403*v_R7_c_i - 20.5427472507027*v_R7_c_r + 49.9151995897384*v_R7_n_i - 46.569928961908*v_R7_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r + 105.57176931318*v_R8_b_i - 54.0657727682604*v_R8_b_r - 39.6392229058201*v_R8_c_i + 10.2713736253513*v_R8_c_r - 24.9575997948692*v_R8_n_i + 23.284964480954*v_R8_n_r
        struct[0].g[92,0] = -23.284964480954*v_R6_a_i - 24.9575997948692*v_R6_a_r - 10.2713736253513*v_R6_b_i - 39.6392229058202*v_R6_b_r + 54.0657727682604*v_R6_c_i + 105.57176931318*v_R6_c_r - 10.2713736253514*v_R6_n_i - 39.6392229058201*v_R6_n_r + 46.569928961908*v_R7_a_i + 49.9151995897384*v_R7_a_r + 20.5427472507027*v_R7_b_i + 79.2784458116404*v_R7_b_r - 108.131545536521*v_R7_c_i - 211.14353862636*v_R7_c_r + 20.5427472507027*v_R7_n_i + 79.2784458116403*v_R7_n_r - 23.284964480954*v_R8_a_i - 24.9575997948692*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r + 54.0657727682604*v_R8_c_i + 105.57176931318*v_R8_c_r - 10.2713736253514*v_R8_n_i - 39.6392229058201*v_R8_n_r
        struct[0].g[93,0] = -24.9575997948692*v_R6_a_i + 23.284964480954*v_R6_a_r - 39.6392229058202*v_R6_b_i + 10.2713736253513*v_R6_b_r + 105.57176931318*v_R6_c_i - 54.0657727682604*v_R6_c_r - 39.6392229058201*v_R6_n_i + 10.2713736253514*v_R6_n_r + 49.9151995897384*v_R7_a_i - 46.569928961908*v_R7_a_r + 79.2784458116404*v_R7_b_i - 20.5427472507027*v_R7_b_r - 211.14353862636*v_R7_c_i + 108.131545536521*v_R7_c_r + 79.2784458116403*v_R7_n_i - 20.5427472507027*v_R7_n_r - 24.9575997948692*v_R8_a_i + 23.284964480954*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r + 105.57176931318*v_R8_c_i - 54.0657727682604*v_R8_c_r - 39.6392229058201*v_R8_n_i + 10.2713736253514*v_R8_n_r
        struct[0].g[94,0] = -10.2713736253513*v_R6_a_i - 39.6392229058202*v_R6_a_r - 23.284964480954*v_R6_b_i - 24.9575997948692*v_R6_b_r - 10.2713736253513*v_R6_c_i - 39.6392229058202*v_R6_c_r + 54.0657727682604*v_R6_n_i + 105.57176931318*v_R6_n_r + 20.5427472507027*v_R7_a_i + 79.2784458116403*v_R7_a_r + 46.569928961908*v_R7_b_i + 49.9151995897384*v_R7_b_r + 20.5427472507027*v_R7_c_i + 79.2784458116403*v_R7_c_r - 108.131545536521*v_R7_n_i - 211.14353862636*v_R7_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r - 23.284964480954*v_R8_b_i - 24.9575997948692*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058202*v_R8_c_r + 54.0657727682604*v_R8_n_i + 105.57176931318*v_R8_n_r
        struct[0].g[95,0] = -39.6392229058202*v_R6_a_i + 10.2713736253513*v_R6_a_r - 24.9575997948692*v_R6_b_i + 23.284964480954*v_R6_b_r - 39.6392229058202*v_R6_c_i + 10.2713736253513*v_R6_c_r + 105.57176931318*v_R6_n_i - 54.0657727682604*v_R6_n_r + 79.2784458116403*v_R7_a_i - 20.5427472507027*v_R7_a_r + 49.9151995897384*v_R7_b_i - 46.569928961908*v_R7_b_r + 79.2784458116403*v_R7_c_i - 20.5427472507027*v_R7_c_r - 211.14353862636*v_R7_n_i + 108.131545536521*v_R7_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r - 24.9575997948692*v_R8_b_i + 23.284964480954*v_R8_b_r - 39.6392229058202*v_R8_c_i + 10.2713736253513*v_R8_c_r + 105.57176931318*v_R8_n_i - 54.0657727682604*v_R8_n_r
        struct[0].g[96,0] = 54.0657727682604*v_R7_a_i + 105.57176931318*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r - 23.284964480954*v_R7_c_i - 24.9575997948692*v_R7_c_r - 10.2713736253513*v_R7_n_i - 39.6392229058202*v_R7_n_r - 108.131545536521*v_R8_a_i - 211.14353862636*v_R8_a_r + 20.5427472507027*v_R8_b_i + 79.2784458116403*v_R8_b_r + 46.569928961908*v_R8_c_i + 49.9151995897384*v_R8_c_r + 20.5427472507027*v_R8_n_i + 79.2784458116403*v_R8_n_r + 54.0657727682604*v_R9_a_i + 105.57176931318*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r - 23.284964480954*v_R9_c_i - 24.9575997948692*v_R9_c_r - 10.2713736253513*v_R9_n_i - 39.6392229058202*v_R9_n_r
        struct[0].g[97,0] = 105.57176931318*v_R7_a_i - 54.0657727682604*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r - 24.9575997948692*v_R7_c_i + 23.284964480954*v_R7_c_r - 39.6392229058202*v_R7_n_i + 10.2713736253513*v_R7_n_r - 211.14353862636*v_R8_a_i + 108.131545536521*v_R8_a_r + 79.2784458116403*v_R8_b_i - 20.5427472507027*v_R8_b_r + 49.9151995897384*v_R8_c_i - 46.569928961908*v_R8_c_r + 79.2784458116403*v_R8_n_i - 20.5427472507027*v_R8_n_r + 105.57176931318*v_R9_a_i - 54.0657727682604*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r - 24.9575997948692*v_R9_c_i + 23.284964480954*v_R9_c_r - 39.6392229058202*v_R9_n_i + 10.2713736253513*v_R9_n_r
        struct[0].g[98,0] = -10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r + 54.0657727682604*v_R7_b_i + 105.57176931318*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058201*v_R7_c_r - 23.284964480954*v_R7_n_i - 24.9575997948692*v_R7_n_r + 20.5427472507027*v_R8_a_i + 79.2784458116403*v_R8_a_r - 108.131545536521*v_R8_b_i - 211.14353862636*v_R8_b_r + 20.5427472507027*v_R8_c_i + 79.2784458116403*v_R8_c_r + 46.569928961908*v_R8_n_i + 49.9151995897384*v_R8_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r + 54.0657727682604*v_R9_b_i + 105.57176931318*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058201*v_R9_c_r - 23.284964480954*v_R9_n_i - 24.9575997948692*v_R9_n_r
        struct[0].g[99,0] = -39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r + 105.57176931318*v_R7_b_i - 54.0657727682604*v_R7_b_r - 39.6392229058201*v_R7_c_i + 10.2713736253513*v_R7_c_r - 24.9575997948692*v_R7_n_i + 23.284964480954*v_R7_n_r + 79.2784458116403*v_R8_a_i - 20.5427472507027*v_R8_a_r - 211.14353862636*v_R8_b_i + 108.131545536521*v_R8_b_r + 79.2784458116403*v_R8_c_i - 20.5427472507027*v_R8_c_r + 49.9151995897384*v_R8_n_i - 46.569928961908*v_R8_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r + 105.57176931318*v_R9_b_i - 54.0657727682604*v_R9_b_r - 39.6392229058201*v_R9_c_i + 10.2713736253513*v_R9_c_r - 24.9575997948692*v_R9_n_i + 23.284964480954*v_R9_n_r
        struct[0].g[100,0] = -23.284964480954*v_R7_a_i - 24.9575997948692*v_R7_a_r - 10.2713736253513*v_R7_b_i - 39.6392229058202*v_R7_b_r + 54.0657727682604*v_R7_c_i + 105.57176931318*v_R7_c_r - 10.2713736253514*v_R7_n_i - 39.6392229058201*v_R7_n_r + 46.569928961908*v_R8_a_i + 49.9151995897384*v_R8_a_r + 20.5427472507027*v_R8_b_i + 79.2784458116404*v_R8_b_r - 108.131545536521*v_R8_c_i - 211.14353862636*v_R8_c_r + 20.5427472507027*v_R8_n_i + 79.2784458116403*v_R8_n_r - 23.284964480954*v_R9_a_i - 24.9575997948692*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r + 54.0657727682604*v_R9_c_i + 105.57176931318*v_R9_c_r - 10.2713736253514*v_R9_n_i - 39.6392229058201*v_R9_n_r
        struct[0].g[101,0] = -24.9575997948692*v_R7_a_i + 23.284964480954*v_R7_a_r - 39.6392229058202*v_R7_b_i + 10.2713736253513*v_R7_b_r + 105.57176931318*v_R7_c_i - 54.0657727682604*v_R7_c_r - 39.6392229058201*v_R7_n_i + 10.2713736253514*v_R7_n_r + 49.9151995897384*v_R8_a_i - 46.569928961908*v_R8_a_r + 79.2784458116404*v_R8_b_i - 20.5427472507027*v_R8_b_r - 211.14353862636*v_R8_c_i + 108.131545536521*v_R8_c_r + 79.2784458116403*v_R8_n_i - 20.5427472507027*v_R8_n_r - 24.9575997948692*v_R9_a_i + 23.284964480954*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r + 105.57176931318*v_R9_c_i - 54.0657727682604*v_R9_c_r - 39.6392229058201*v_R9_n_i + 10.2713736253514*v_R9_n_r
        struct[0].g[102,0] = -10.2713736253513*v_R7_a_i - 39.6392229058202*v_R7_a_r - 23.284964480954*v_R7_b_i - 24.9575997948692*v_R7_b_r - 10.2713736253513*v_R7_c_i - 39.6392229058202*v_R7_c_r + 54.0657727682604*v_R7_n_i + 105.57176931318*v_R7_n_r + 20.5427472507027*v_R8_a_i + 79.2784458116403*v_R8_a_r + 46.569928961908*v_R8_b_i + 49.9151995897384*v_R8_b_r + 20.5427472507027*v_R8_c_i + 79.2784458116403*v_R8_c_r - 108.131545536521*v_R8_n_i - 211.16853862636*v_R8_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r - 23.284964480954*v_R9_b_i - 24.9575997948692*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058202*v_R9_c_r + 54.0657727682604*v_R9_n_i + 105.57176931318*v_R9_n_r
        struct[0].g[103,0] = -39.6392229058202*v_R7_a_i + 10.2713736253513*v_R7_a_r - 24.9575997948692*v_R7_b_i + 23.284964480954*v_R7_b_r - 39.6392229058202*v_R7_c_i + 10.2713736253513*v_R7_c_r + 105.57176931318*v_R7_n_i - 54.0657727682604*v_R7_n_r + 79.2784458116403*v_R8_a_i - 20.5427472507027*v_R8_a_r + 49.9151995897384*v_R8_b_i - 46.569928961908*v_R8_b_r + 79.2784458116403*v_R8_c_i - 20.5427472507027*v_R8_c_r - 211.16853862636*v_R8_n_i + 108.131545536521*v_R8_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r - 24.9575997948692*v_R9_b_i + 23.284964480954*v_R9_b_r - 39.6392229058202*v_R9_c_i + 10.2713736253513*v_R9_c_r + 105.57176931318*v_R9_n_i - 54.0657727682604*v_R9_n_r
        struct[0].g[104,0] = 54.0657727682604*v_R10_a_i + 105.57176931318*v_R10_a_r - 10.2713736253513*v_R10_b_i - 39.6392229058202*v_R10_b_r - 23.284964480954*v_R10_c_i - 24.9575997948692*v_R10_c_r - 10.2713736253513*v_R10_n_i - 39.6392229058202*v_R10_n_r + 5.65456401516768*v_R17_a_i + 30.9517475172273*v_R17_a_r + 1.84896616921897*v_R17_b_i - 9.21038227100566*v_R17_b_r + 0.793238195499529*v_R17_c_i - 9.00835072044485*v_R17_c_r + 1.84896616921897*v_R17_n_i - 9.21038227100566*v_R17_n_r + 54.0657727682604*v_R8_a_i + 105.57176931318*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r - 23.284964480954*v_R8_c_i - 24.9575997948692*v_R8_c_r - 10.2713736253513*v_R8_n_i - 39.6392229058202*v_R8_n_r - 113.786109551688*v_R9_a_i - 242.095286143588*v_R9_a_r + 18.6937810814837*v_R9_b_i + 88.488828082646*v_R9_b_r + 45.7766907664085*v_R9_c_i + 58.9235503101833*v_R9_c_r + 18.6937810814837*v_R9_n_i + 88.488828082646*v_R9_n_r
        struct[0].g[105,0] = 105.57176931318*v_R10_a_i - 54.0657727682604*v_R10_a_r - 39.6392229058202*v_R10_b_i + 10.2713736253513*v_R10_b_r - 24.9575997948692*v_R10_c_i + 23.284964480954*v_R10_c_r - 39.6392229058202*v_R10_n_i + 10.2713736253513*v_R10_n_r + 30.9517475172273*v_R17_a_i - 5.65456401516768*v_R17_a_r - 9.21038227100566*v_R17_b_i - 1.84896616921897*v_R17_b_r - 9.00835072044485*v_R17_c_i - 0.793238195499529*v_R17_c_r - 9.21038227100566*v_R17_n_i - 1.84896616921897*v_R17_n_r + 105.57176931318*v_R8_a_i - 54.0657727682604*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r - 24.9575997948692*v_R8_c_i + 23.284964480954*v_R8_c_r - 39.6392229058202*v_R8_n_i + 10.2713736253513*v_R8_n_r - 242.095286143588*v_R9_a_i + 113.786109551688*v_R9_a_r + 88.488828082646*v_R9_b_i - 18.6937810814837*v_R9_b_r + 58.9235503101833*v_R9_c_i - 45.7766907664085*v_R9_c_r + 88.488828082646*v_R9_n_i - 18.6937810814837*v_R9_n_r
        struct[0].g[106,0] = -10.2713736253513*v_R10_a_i - 39.6392229058202*v_R10_a_r + 54.0657727682604*v_R10_b_i + 105.57176931318*v_R10_b_r - 10.2713736253513*v_R10_c_i - 39.6392229058201*v_R10_c_r - 23.284964480954*v_R10_n_i - 24.9575997948692*v_R10_n_r + 1.84896616921897*v_R17_a_i - 9.21038227100566*v_R17_a_r + 5.65456401516768*v_R17_b_i + 30.9517475172273*v_R17_b_r + 1.84896616921897*v_R17_c_i - 9.21038227100566*v_R17_c_r + 0.793238195499528*v_R17_n_i - 9.00835072044485*v_R17_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r + 54.0657727682604*v_R8_b_i + 105.57176931318*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058201*v_R8_c_r - 23.284964480954*v_R8_n_i - 24.9575997948692*v_R8_n_r + 18.6937810814837*v_R9_a_i + 88.488828082646*v_R9_a_r - 113.786109551688*v_R9_b_i - 242.095286143588*v_R9_b_r + 18.6937810814837*v_R9_c_i + 88.488828082646*v_R9_c_r + 45.7766907664085*v_R9_n_i + 58.9235503101833*v_R9_n_r
        struct[0].g[107,0] = -39.6392229058202*v_R10_a_i + 10.2713736253513*v_R10_a_r + 105.57176931318*v_R10_b_i - 54.0657727682604*v_R10_b_r - 39.6392229058201*v_R10_c_i + 10.2713736253513*v_R10_c_r - 24.9575997948692*v_R10_n_i + 23.284964480954*v_R10_n_r - 9.21038227100566*v_R17_a_i - 1.84896616921897*v_R17_a_r + 30.9517475172273*v_R17_b_i - 5.65456401516768*v_R17_b_r - 9.21038227100566*v_R17_c_i - 1.84896616921897*v_R17_c_r - 9.00835072044485*v_R17_n_i - 0.793238195499528*v_R17_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r + 105.57176931318*v_R8_b_i - 54.0657727682604*v_R8_b_r - 39.6392229058201*v_R8_c_i + 10.2713736253513*v_R8_c_r - 24.9575997948692*v_R8_n_i + 23.284964480954*v_R8_n_r + 88.488828082646*v_R9_a_i - 18.6937810814837*v_R9_a_r - 242.095286143588*v_R9_b_i + 113.786109551688*v_R9_b_r + 88.488828082646*v_R9_c_i - 18.6937810814837*v_R9_c_r + 58.9235503101833*v_R9_n_i - 45.7766907664085*v_R9_n_r
        struct[0].g[108,0] = -23.284964480954*v_R10_a_i - 24.9575997948692*v_R10_a_r - 10.2713736253513*v_R10_b_i - 39.6392229058202*v_R10_b_r + 54.0657727682604*v_R10_c_i + 105.57176931318*v_R10_c_r - 10.2713736253514*v_R10_n_i - 39.6392229058201*v_R10_n_r + 0.793238195499527*v_R17_a_i - 9.00835072044484*v_R17_a_r + 1.84896616921897*v_R17_b_i - 9.21038227100566*v_R17_b_r + 5.65456401516768*v_R17_c_i + 30.9517475172273*v_R17_c_r + 1.84896616921897*v_R17_n_i - 9.21038227100566*v_R17_n_r - 23.284964480954*v_R8_a_i - 24.9575997948692*v_R8_a_r - 10.2713736253513*v_R8_b_i - 39.6392229058202*v_R8_b_r + 54.0657727682604*v_R8_c_i + 105.57176931318*v_R8_c_r - 10.2713736253514*v_R8_n_i - 39.6392229058201*v_R8_n_r + 45.7766907664085*v_R9_a_i + 58.9235503101833*v_R9_a_r + 18.6937810814837*v_R9_b_i + 88.4888280826461*v_R9_b_r - 113.786109551688*v_R9_c_i - 242.095286143588*v_R9_c_r + 18.6937810814837*v_R9_n_i + 88.4888280826459*v_R9_n_r
        struct[0].g[109,0] = -24.9575997948692*v_R10_a_i + 23.284964480954*v_R10_a_r - 39.6392229058202*v_R10_b_i + 10.2713736253513*v_R10_b_r + 105.57176931318*v_R10_c_i - 54.0657727682604*v_R10_c_r - 39.6392229058201*v_R10_n_i + 10.2713736253514*v_R10_n_r - 9.00835072044484*v_R17_a_i - 0.793238195499527*v_R17_a_r - 9.21038227100566*v_R17_b_i - 1.84896616921897*v_R17_b_r + 30.9517475172273*v_R17_c_i - 5.65456401516768*v_R17_c_r - 9.21038227100566*v_R17_n_i - 1.84896616921897*v_R17_n_r - 24.9575997948692*v_R8_a_i + 23.284964480954*v_R8_a_r - 39.6392229058202*v_R8_b_i + 10.2713736253513*v_R8_b_r + 105.57176931318*v_R8_c_i - 54.0657727682604*v_R8_c_r - 39.6392229058201*v_R8_n_i + 10.2713736253514*v_R8_n_r + 58.9235503101833*v_R9_a_i - 45.7766907664085*v_R9_a_r + 88.4888280826461*v_R9_b_i - 18.6937810814837*v_R9_b_r - 242.095286143588*v_R9_c_i + 113.786109551688*v_R9_c_r + 88.4888280826459*v_R9_n_i - 18.6937810814837*v_R9_n_r
        struct[0].g[110,0] = -10.2713736253513*v_R10_a_i - 39.6392229058202*v_R10_a_r - 23.284964480954*v_R10_b_i - 24.9575997948692*v_R10_b_r - 10.2713736253513*v_R10_c_i - 39.6392229058202*v_R10_c_r + 54.0657727682604*v_R10_n_i + 105.57176931318*v_R10_n_r + 1.84896616921897*v_R17_a_i - 9.21038227100566*v_R17_a_r + 0.793238195499527*v_R17_b_i - 9.00835072044485*v_R17_b_r + 1.84896616921897*v_R17_c_i - 9.21038227100566*v_R17_c_r + 5.65456401516768*v_R17_n_i + 30.9517475172273*v_R17_n_r - 10.2713736253513*v_R8_a_i - 39.6392229058202*v_R8_a_r - 23.284964480954*v_R8_b_i - 24.9575997948692*v_R8_b_r - 10.2713736253513*v_R8_c_i - 39.6392229058202*v_R8_c_r + 54.0657727682604*v_R8_n_i + 105.57176931318*v_R8_n_r + 18.6937810814837*v_R9_a_i + 88.488828082646*v_R9_a_r + 45.7766907664085*v_R9_b_i + 58.9235503101832*v_R9_b_r + 18.6937810814837*v_R9_c_i + 88.488828082646*v_R9_c_r - 113.786109551688*v_R9_n_i - 242.095286143588*v_R9_n_r
        struct[0].g[111,0] = -39.6392229058202*v_R10_a_i + 10.2713736253513*v_R10_a_r - 24.9575997948692*v_R10_b_i + 23.284964480954*v_R10_b_r - 39.6392229058202*v_R10_c_i + 10.2713736253513*v_R10_c_r + 105.57176931318*v_R10_n_i - 54.0657727682604*v_R10_n_r - 9.21038227100566*v_R17_a_i - 1.84896616921897*v_R17_a_r - 9.00835072044485*v_R17_b_i - 0.793238195499527*v_R17_b_r - 9.21038227100566*v_R17_c_i - 1.84896616921897*v_R17_c_r + 30.9517475172273*v_R17_n_i - 5.65456401516768*v_R17_n_r - 39.6392229058202*v_R8_a_i + 10.2713736253513*v_R8_a_r - 24.9575997948692*v_R8_b_i + 23.284964480954*v_R8_b_r - 39.6392229058202*v_R8_c_i + 10.2713736253513*v_R8_c_r + 105.57176931318*v_R8_n_i - 54.0657727682604*v_R8_n_r + 88.488828082646*v_R9_a_i - 18.6937810814837*v_R9_a_r + 58.9235503101832*v_R9_b_i - 45.7766907664085*v_R9_b_r + 88.488828082646*v_R9_c_i - 18.6937810814837*v_R9_c_r - 242.095286143588*v_R9_n_i + 113.786109551688*v_R9_n_r
        struct[0].g[112,0] = i_vsc_R10_a_r - 59.7203367834281*v_R10_a_i - 136.523516830407*v_R10_a_r + 8.42240745613237*v_R10_b_i + 48.8496051768258*v_R10_b_r + 22.4917262854545*v_R10_c_i + 33.9659505153141*v_R10_c_r + 8.42240745613237*v_R10_n_i + 48.8496051768258*v_R10_n_r + 5.65456401516768*v_R18_a_i + 30.9517475172273*v_R18_a_r + 1.84896616921897*v_R18_b_i - 9.21038227100566*v_R18_b_r + 0.793238195499529*v_R18_c_i - 9.00835072044485*v_R18_c_r + 1.84896616921897*v_R18_n_i - 9.21038227100566*v_R18_n_r + 54.0657727682604*v_R9_a_i + 105.57176931318*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r - 23.284964480954*v_R9_c_i - 24.9575997948692*v_R9_c_r - 10.2713736253513*v_R9_n_i - 39.6392229058202*v_R9_n_r
        struct[0].g[113,0] = i_vsc_R10_a_i - 136.523516830407*v_R10_a_i + 59.7203367834281*v_R10_a_r + 48.8496051768258*v_R10_b_i - 8.42240745613237*v_R10_b_r + 33.9659505153141*v_R10_c_i - 22.4917262854545*v_R10_c_r + 48.8496051768258*v_R10_n_i - 8.42240745613237*v_R10_n_r + 30.9517475172273*v_R18_a_i - 5.65456401516768*v_R18_a_r - 9.21038227100566*v_R18_b_i - 1.84896616921897*v_R18_b_r - 9.00835072044485*v_R18_c_i - 0.793238195499529*v_R18_c_r - 9.21038227100566*v_R18_n_i - 1.84896616921897*v_R18_n_r + 105.57176931318*v_R9_a_i - 54.0657727682604*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r - 24.9575997948692*v_R9_c_i + 23.284964480954*v_R9_c_r - 39.6392229058202*v_R9_n_i + 10.2713736253513*v_R9_n_r
        struct[0].g[114,0] = i_vsc_R10_b_r + 8.42240745613237*v_R10_a_i + 48.8496051768258*v_R10_a_r - 59.720336783428*v_R10_b_i - 136.523516830407*v_R10_b_r + 8.42240745613238*v_R10_c_i + 48.8496051768258*v_R10_c_r + 22.4917262854545*v_R10_n_i + 33.9659505153141*v_R10_n_r + 1.84896616921897*v_R18_a_i - 9.21038227100566*v_R18_a_r + 5.65456401516768*v_R18_b_i + 30.9517475172273*v_R18_b_r + 1.84896616921897*v_R18_c_i - 9.21038227100566*v_R18_c_r + 0.793238195499528*v_R18_n_i - 9.00835072044485*v_R18_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r + 54.0657727682604*v_R9_b_i + 105.57176931318*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058201*v_R9_c_r - 23.284964480954*v_R9_n_i - 24.9575997948692*v_R9_n_r
        struct[0].g[115,0] = i_vsc_R10_b_i + 48.8496051768258*v_R10_a_i - 8.42240745613237*v_R10_a_r - 136.523516830407*v_R10_b_i + 59.720336783428*v_R10_b_r + 48.8496051768258*v_R10_c_i - 8.42240745613238*v_R10_c_r + 33.9659505153141*v_R10_n_i - 22.4917262854545*v_R10_n_r - 9.21038227100566*v_R18_a_i - 1.84896616921897*v_R18_a_r + 30.9517475172273*v_R18_b_i - 5.65456401516768*v_R18_b_r - 9.21038227100566*v_R18_c_i - 1.84896616921897*v_R18_c_r - 9.00835072044485*v_R18_n_i - 0.793238195499528*v_R18_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r + 105.57176931318*v_R9_b_i - 54.0657727682604*v_R9_b_r - 39.6392229058201*v_R9_c_i + 10.2713736253513*v_R9_c_r - 24.9575997948692*v_R9_n_i + 23.284964480954*v_R9_n_r
        struct[0].g[116,0] = i_vsc_R10_c_r + 22.4917262854545*v_R10_a_i + 33.9659505153141*v_R10_a_r + 8.42240745613236*v_R10_b_i + 48.8496051768259*v_R10_b_r - 59.7203367834281*v_R10_c_i - 136.523516830407*v_R10_c_r + 8.42240745613239*v_R10_n_i + 48.8496051768258*v_R10_n_r + 0.793238195499527*v_R18_a_i - 9.00835072044484*v_R18_a_r + 1.84896616921897*v_R18_b_i - 9.21038227100566*v_R18_b_r + 5.65456401516768*v_R18_c_i + 30.9517475172273*v_R18_c_r + 1.84896616921897*v_R18_n_i - 9.21038227100566*v_R18_n_r - 23.284964480954*v_R9_a_i - 24.9575997948692*v_R9_a_r - 10.2713736253513*v_R9_b_i - 39.6392229058202*v_R9_b_r + 54.0657727682604*v_R9_c_i + 105.57176931318*v_R9_c_r - 10.2713736253514*v_R9_n_i - 39.6392229058201*v_R9_n_r
        struct[0].g[117,0] = i_vsc_R10_c_i + 33.9659505153141*v_R10_a_i - 22.4917262854545*v_R10_a_r + 48.8496051768259*v_R10_b_i - 8.42240745613236*v_R10_b_r - 136.523516830407*v_R10_c_i + 59.7203367834281*v_R10_c_r + 48.8496051768258*v_R10_n_i - 8.42240745613239*v_R10_n_r - 9.00835072044484*v_R18_a_i - 0.793238195499527*v_R18_a_r - 9.21038227100566*v_R18_b_i - 1.84896616921897*v_R18_b_r + 30.9517475172273*v_R18_c_i - 5.65456401516768*v_R18_c_r - 9.21038227100566*v_R18_n_i - 1.84896616921897*v_R18_n_r - 24.9575997948692*v_R9_a_i + 23.284964480954*v_R9_a_r - 39.6392229058202*v_R9_b_i + 10.2713736253513*v_R9_b_r + 105.57176931318*v_R9_c_i - 54.0657727682604*v_R9_c_r - 39.6392229058201*v_R9_n_i + 10.2713736253514*v_R9_n_r
        struct[0].g[118,0] = i_vsc_R10_n_r + 8.42240745613237*v_R10_a_i + 48.8496051768258*v_R10_a_r + 22.4917262854545*v_R10_b_i + 33.965950515314*v_R10_b_r + 8.42240745613237*v_R10_c_i + 48.8496051768258*v_R10_c_r - 59.7203367834281*v_R10_n_i - 136.548516830407*v_R10_n_r + 1.84896616921897*v_R18_a_i - 9.21038227100566*v_R18_a_r + 0.793238195499527*v_R18_b_i - 9.00835072044485*v_R18_b_r + 1.84896616921897*v_R18_c_i - 9.21038227100566*v_R18_c_r + 5.65456401516768*v_R18_n_i + 30.9517475172273*v_R18_n_r - 10.2713736253513*v_R9_a_i - 39.6392229058202*v_R9_a_r - 23.284964480954*v_R9_b_i - 24.9575997948692*v_R9_b_r - 10.2713736253513*v_R9_c_i - 39.6392229058202*v_R9_c_r + 54.0657727682604*v_R9_n_i + 105.57176931318*v_R9_n_r
        struct[0].g[119,0] = i_vsc_R10_n_i + 48.8496051768258*v_R10_a_i - 8.42240745613237*v_R10_a_r + 33.965950515314*v_R10_b_i - 22.4917262854545*v_R10_b_r + 48.8496051768258*v_R10_c_i - 8.42240745613237*v_R10_c_r - 136.548516830407*v_R10_n_i + 59.7203367834281*v_R10_n_r - 9.21038227100566*v_R18_a_i - 1.84896616921897*v_R18_a_r - 9.00835072044485*v_R18_b_i - 0.793238195499527*v_R18_b_r - 9.21038227100566*v_R18_c_i - 1.84896616921897*v_R18_c_r + 30.9517475172273*v_R18_n_i - 5.65456401516768*v_R18_n_r - 39.6392229058202*v_R9_a_i + 10.2713736253513*v_R9_a_r - 24.9575997948692*v_R9_b_i + 23.284964480954*v_R9_b_r - 39.6392229058202*v_R9_c_i + 10.2713736253513*v_R9_c_r + 105.57176931318*v_R9_n_i - 54.0657727682604*v_R9_n_r
        struct[0].g[120,0] = -1.58482814504483*v_R11_a_i + 7.89461337514771*v_R11_a_r - 4.84676915585801*v_R11_b_i - 26.5300693004806*v_R11_b_r - 1.58482814504483*v_R11_c_i + 7.89461337514771*v_R11_c_r - 0.679918453285308*v_R11_n_i + 7.72144347466701*v_R11_n_r + 1.58482814504483*v_R3_a_i - 7.89461337514771*v_R3_a_r + 4.84676915585801*v_R3_b_i + 26.5300693004806*v_R3_b_r + 1.58482814504483*v_R3_c_i - 7.89461337514771*v_R3_c_r + 0.679918453285308*v_R3_n_i - 7.72144347466701*v_R3_n_r
        struct[0].g[121,0] = 7.89461337514771*v_R11_a_i + 1.58482814504483*v_R11_a_r - 26.5300693004806*v_R11_b_i + 4.84676915585801*v_R11_b_r + 7.89461337514771*v_R11_c_i + 1.58482814504483*v_R11_c_r + 7.72144347466701*v_R11_n_i + 0.679918453285308*v_R11_n_r - 7.89461337514771*v_R3_a_i - 1.58482814504483*v_R3_a_r + 26.5300693004806*v_R3_b_i - 4.84676915585801*v_R3_b_r - 7.89461337514771*v_R3_c_i - 1.58482814504483*v_R3_c_r - 7.72144347466701*v_R3_n_i - 0.679918453285308*v_R3_n_r
        struct[0].g[122,0] = -0.67991845328531*v_R11_a_i + 7.72144347466701*v_R11_a_r - 1.58482814504483*v_R11_b_i + 7.8946133751477*v_R11_b_r - 4.84676915585801*v_R11_c_i - 26.5300693004806*v_R11_c_r - 1.58482814504483*v_R11_n_i + 7.89461337514771*v_R11_n_r + 0.67991845328531*v_R3_a_i - 7.72144347466701*v_R3_a_r + 1.58482814504483*v_R3_b_i - 7.8946133751477*v_R3_b_r + 4.84676915585801*v_R3_c_i + 26.5300693004806*v_R3_c_r + 1.58482814504483*v_R3_n_i - 7.89461337514771*v_R3_n_r
        struct[0].g[123,0] = 7.72144347466701*v_R11_a_i + 0.67991845328531*v_R11_a_r + 7.8946133751477*v_R11_b_i + 1.58482814504483*v_R11_b_r - 26.5300693004806*v_R11_c_i + 4.84676915585801*v_R11_c_r + 7.89461337514771*v_R11_n_i + 1.58482814504483*v_R11_n_r - 7.72144347466701*v_R3_a_i - 0.67991845328531*v_R3_a_r - 7.8946133751477*v_R3_b_i - 1.58482814504483*v_R3_b_r + 26.5300693004806*v_R3_c_i - 4.84676915585801*v_R3_c_r - 7.89461337514771*v_R3_n_i - 1.58482814504483*v_R3_n_r
        struct[0].g[124,0] = -9.69353831171601*v_R12_a_i - 53.0601386009611*v_R12_a_r - 3.16965629008966*v_R12_b_i + 15.7892267502954*v_R12_b_r - 1.35983690657062*v_R12_c_i + 15.442886949334*v_R12_c_r - 3.16965629008966*v_R12_n_i + 15.7892267502954*v_R12_n_r + 4.84676915585801*v_R13_a_i + 26.5300693004806*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 0.67991845328531*v_R13_c_i - 7.72144347466701*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r + 4.84676915585801*v_R4_a_i + 26.5300693004806*v_R4_a_r + 1.58482814504483*v_R4_b_i - 7.8946133751477*v_R4_b_r + 0.67991845328531*v_R4_c_i - 7.72144347466701*v_R4_c_r + 1.58482814504483*v_R4_n_i - 7.89461337514771*v_R4_n_r
        struct[0].g[125,0] = -53.0601386009611*v_R12_a_i + 9.69353831171601*v_R12_a_r + 15.7892267502954*v_R12_b_i + 3.16965629008966*v_R12_b_r + 15.442886949334*v_R12_c_i + 1.35983690657062*v_R12_c_r + 15.7892267502954*v_R12_n_i + 3.16965629008966*v_R12_n_r + 26.5300693004806*v_R13_a_i - 4.84676915585801*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r - 7.72144347466701*v_R13_c_i - 0.67991845328531*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r + 26.5300693004806*v_R4_a_i - 4.84676915585801*v_R4_a_r - 7.8946133751477*v_R4_b_i - 1.58482814504483*v_R4_b_r - 7.72144347466701*v_R4_c_i - 0.67991845328531*v_R4_c_r - 7.89461337514771*v_R4_n_i - 1.58482814504483*v_R4_n_r
        struct[0].g[126,0] = -3.16965629008966*v_R12_a_i + 15.7892267502954*v_R12_a_r - 9.69353831171602*v_R12_b_i - 53.0601386009611*v_R12_b_r - 3.16965629008967*v_R12_c_i + 15.7892267502954*v_R12_c_r - 1.35983690657062*v_R12_n_i + 15.442886949334*v_R12_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 4.84676915585801*v_R13_b_i + 26.5300693004806*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 0.679918453285308*v_R13_n_i - 7.72144347466701*v_R13_n_r + 1.58482814504483*v_R4_a_i - 7.89461337514771*v_R4_a_r + 4.84676915585801*v_R4_b_i + 26.5300693004806*v_R4_b_r + 1.58482814504483*v_R4_c_i - 7.89461337514771*v_R4_c_r + 0.679918453285308*v_R4_n_i - 7.72144347466701*v_R4_n_r
        struct[0].g[127,0] = 15.7892267502954*v_R12_a_i + 3.16965629008966*v_R12_a_r - 53.0601386009611*v_R12_b_i + 9.69353831171602*v_R12_b_r + 15.7892267502954*v_R12_c_i + 3.16965629008967*v_R12_c_r + 15.442886949334*v_R12_n_i + 1.35983690657062*v_R12_n_r - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r + 26.5300693004806*v_R13_b_i - 4.84676915585801*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r - 7.72144347466701*v_R13_n_i - 0.679918453285308*v_R13_n_r - 7.89461337514771*v_R4_a_i - 1.58482814504483*v_R4_a_r + 26.5300693004806*v_R4_b_i - 4.84676915585801*v_R4_b_r - 7.89461337514771*v_R4_c_i - 1.58482814504483*v_R4_c_r - 7.72144347466701*v_R4_n_i - 0.679918453285308*v_R4_n_r
        struct[0].g[128,0] = -1.35983690657062*v_R12_a_i + 15.442886949334*v_R12_a_r - 3.16965629008966*v_R12_b_i + 15.7892267502954*v_R12_b_r - 9.69353831171602*v_R12_c_i - 53.0601386009611*v_R12_c_r - 3.16965629008967*v_R12_n_i + 15.7892267502954*v_R12_n_r + 0.67991845328531*v_R13_a_i - 7.72144347466701*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 4.84676915585801*v_R13_c_i + 26.5300693004806*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r + 0.67991845328531*v_R4_a_i - 7.72144347466701*v_R4_a_r + 1.58482814504483*v_R4_b_i - 7.8946133751477*v_R4_b_r + 4.84676915585801*v_R4_c_i + 26.5300693004806*v_R4_c_r + 1.58482814504483*v_R4_n_i - 7.89461337514771*v_R4_n_r
        struct[0].g[129,0] = 15.442886949334*v_R12_a_i + 1.35983690657062*v_R12_a_r + 15.7892267502954*v_R12_b_i + 3.16965629008966*v_R12_b_r - 53.0601386009611*v_R12_c_i + 9.69353831171602*v_R12_c_r + 15.7892267502954*v_R12_n_i + 3.16965629008967*v_R12_n_r - 7.72144347466701*v_R13_a_i - 0.67991845328531*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r + 26.5300693004806*v_R13_c_i - 4.84676915585801*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r - 7.72144347466701*v_R4_a_i - 0.67991845328531*v_R4_a_r - 7.8946133751477*v_R4_b_i - 1.58482814504483*v_R4_b_r + 26.5300693004806*v_R4_c_i - 4.84676915585801*v_R4_c_r - 7.89461337514771*v_R4_n_i - 1.58482814504483*v_R4_n_r
        struct[0].g[130,0] = -3.16965629008966*v_R12_a_i + 15.7892267502954*v_R12_a_r - 1.35983690657062*v_R12_b_i + 15.442886949334*v_R12_b_r - 3.16965629008966*v_R12_c_i + 15.7892267502954*v_R12_c_r - 9.69353831171602*v_R12_n_i - 53.0601386009611*v_R12_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 0.679918453285308*v_R13_b_i - 7.72144347466701*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 4.84676915585801*v_R13_n_i + 26.5300693004806*v_R13_n_r + 1.58482814504483*v_R4_a_i - 7.89461337514771*v_R4_a_r + 0.679918453285308*v_R4_b_i - 7.72144347466701*v_R4_b_r + 1.58482814504483*v_R4_c_i - 7.89461337514771*v_R4_c_r + 4.84676915585801*v_R4_n_i + 26.5300693004806*v_R4_n_r
        struct[0].g[131,0] = 15.7892267502954*v_R12_a_i + 3.16965629008966*v_R12_a_r + 15.442886949334*v_R12_b_i + 1.35983690657062*v_R12_b_r + 15.7892267502954*v_R12_c_i + 3.16965629008966*v_R12_c_r - 53.0601386009611*v_R12_n_i + 9.69353831171602*v_R12_n_r - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r - 7.72144347466701*v_R13_b_i - 0.679918453285308*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r + 26.5300693004806*v_R13_n_i - 4.84676915585801*v_R13_n_r - 7.89461337514771*v_R4_a_i - 1.58482814504483*v_R4_a_r - 7.72144347466701*v_R4_b_i - 0.679918453285308*v_R4_b_r - 7.89461337514771*v_R4_c_i - 1.58482814504483*v_R4_c_r + 26.5300693004806*v_R4_n_i - 4.84676915585801*v_R4_n_r
        struct[0].g[132,0] = 4.84676915585801*v_R12_a_i + 26.5300693004806*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 0.67991845328531*v_R12_c_i - 7.72144347466701*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 9.69353831171601*v_R13_a_i - 53.0601386009611*v_R13_a_r - 3.16965629008966*v_R13_b_i + 15.7892267502954*v_R13_b_r - 1.35983690657062*v_R13_c_i + 15.442886949334*v_R13_c_r - 3.16965629008966*v_R13_n_i + 15.7892267502954*v_R13_n_r + 4.84676915585801*v_R14_a_i + 26.5300693004806*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 0.67991845328531*v_R14_c_i - 7.72144347466701*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r
        struct[0].g[133,0] = 26.5300693004806*v_R12_a_i - 4.84676915585801*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r - 7.72144347466701*v_R12_c_i - 0.67991845328531*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r - 53.0601386009611*v_R13_a_i + 9.69353831171601*v_R13_a_r + 15.7892267502954*v_R13_b_i + 3.16965629008966*v_R13_b_r + 15.442886949334*v_R13_c_i + 1.35983690657062*v_R13_c_r + 15.7892267502954*v_R13_n_i + 3.16965629008966*v_R13_n_r + 26.5300693004806*v_R14_a_i - 4.84676915585801*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r - 7.72144347466701*v_R14_c_i - 0.67991845328531*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r
        struct[0].g[134,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 4.84676915585801*v_R12_b_i + 26.5300693004806*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 0.679918453285308*v_R12_n_i - 7.72144347466701*v_R12_n_r - 3.16965629008966*v_R13_a_i + 15.7892267502954*v_R13_a_r - 9.69353831171602*v_R13_b_i - 53.0601386009611*v_R13_b_r - 3.16965629008967*v_R13_c_i + 15.7892267502954*v_R13_c_r - 1.35983690657062*v_R13_n_i + 15.442886949334*v_R13_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 4.84676915585801*v_R14_b_i + 26.5300693004806*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 0.679918453285308*v_R14_n_i - 7.72144347466701*v_R14_n_r
        struct[0].g[135,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r + 26.5300693004806*v_R12_b_i - 4.84676915585801*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r - 7.72144347466701*v_R12_n_i - 0.679918453285308*v_R12_n_r + 15.7892267502954*v_R13_a_i + 3.16965629008966*v_R13_a_r - 53.0601386009611*v_R13_b_i + 9.69353831171602*v_R13_b_r + 15.7892267502954*v_R13_c_i + 3.16965629008967*v_R13_c_r + 15.442886949334*v_R13_n_i + 1.35983690657062*v_R13_n_r - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r + 26.5300693004806*v_R14_b_i - 4.84676915585801*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r - 7.72144347466701*v_R14_n_i - 0.679918453285308*v_R14_n_r
        struct[0].g[136,0] = 0.67991845328531*v_R12_a_i - 7.72144347466701*v_R12_a_r + 1.58482814504483*v_R12_b_i - 7.8946133751477*v_R12_b_r + 4.84676915585801*v_R12_c_i + 26.5300693004806*v_R12_c_r + 1.58482814504483*v_R12_n_i - 7.89461337514771*v_R12_n_r - 1.35983690657062*v_R13_a_i + 15.442886949334*v_R13_a_r - 3.16965629008966*v_R13_b_i + 15.7892267502954*v_R13_b_r - 9.69353831171602*v_R13_c_i - 53.0601386009611*v_R13_c_r - 3.16965629008967*v_R13_n_i + 15.7892267502954*v_R13_n_r + 0.67991845328531*v_R14_a_i - 7.72144347466701*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 4.84676915585801*v_R14_c_i + 26.5300693004806*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r
        struct[0].g[137,0] = -7.72144347466701*v_R12_a_i - 0.67991845328531*v_R12_a_r - 7.8946133751477*v_R12_b_i - 1.58482814504483*v_R12_b_r + 26.5300693004806*v_R12_c_i - 4.84676915585801*v_R12_c_r - 7.89461337514771*v_R12_n_i - 1.58482814504483*v_R12_n_r + 15.442886949334*v_R13_a_i + 1.35983690657062*v_R13_a_r + 15.7892267502954*v_R13_b_i + 3.16965629008966*v_R13_b_r - 53.0601386009611*v_R13_c_i + 9.69353831171602*v_R13_c_r + 15.7892267502954*v_R13_n_i + 3.16965629008967*v_R13_n_r - 7.72144347466701*v_R14_a_i - 0.67991845328531*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r + 26.5300693004806*v_R14_c_i - 4.84676915585801*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r
        struct[0].g[138,0] = 1.58482814504483*v_R12_a_i - 7.89461337514771*v_R12_a_r + 0.679918453285308*v_R12_b_i - 7.72144347466701*v_R12_b_r + 1.58482814504483*v_R12_c_i - 7.89461337514771*v_R12_c_r + 4.84676915585801*v_R12_n_i + 26.5300693004806*v_R12_n_r - 3.16965629008966*v_R13_a_i + 15.7892267502954*v_R13_a_r - 1.35983690657062*v_R13_b_i + 15.442886949334*v_R13_b_r - 3.16965629008966*v_R13_c_i + 15.7892267502954*v_R13_c_r - 9.69353831171602*v_R13_n_i - 53.0851386009611*v_R13_n_r + 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 0.679918453285308*v_R14_b_i - 7.72144347466701*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 4.84676915585801*v_R14_n_i + 26.5300693004806*v_R14_n_r
        struct[0].g[139,0] = -7.89461337514771*v_R12_a_i - 1.58482814504483*v_R12_a_r - 7.72144347466701*v_R12_b_i - 0.679918453285308*v_R12_b_r - 7.89461337514771*v_R12_c_i - 1.58482814504483*v_R12_c_r + 26.5300693004806*v_R12_n_i - 4.84676915585801*v_R12_n_r + 15.7892267502954*v_R13_a_i + 3.16965629008966*v_R13_a_r + 15.442886949334*v_R13_b_i + 1.35983690657062*v_R13_b_r + 15.7892267502954*v_R13_c_i + 3.16965629008966*v_R13_c_r - 53.0851386009611*v_R13_n_i + 9.69353831171602*v_R13_n_r - 7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r - 7.72144347466701*v_R14_b_i - 0.679918453285308*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r + 26.5300693004806*v_R14_n_i - 4.84676915585801*v_R14_n_r
        struct[0].g[140,0] = i_vsc_R14_a_r + 4.84676915585801*v_R13_a_i + 26.5300693004806*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 0.67991845328531*v_R13_c_i - 7.72144347466701*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r - 9.69353831171601*v_R14_a_i - 53.0601386009611*v_R14_a_r - 3.16965629008966*v_R14_b_i + 15.7892267502954*v_R14_b_r - 1.35983690657062*v_R14_c_i + 15.442886949334*v_R14_c_r - 3.16965629008966*v_R14_n_i + 15.7892267502954*v_R14_n_r + 4.84676915585801*v_R15_a_i + 26.5300693004806*v_R15_a_r + 1.58482814504483*v_R15_b_i - 7.8946133751477*v_R15_b_r + 0.67991845328531*v_R15_c_i - 7.72144347466701*v_R15_c_r + 1.58482814504483*v_R15_n_i - 7.89461337514771*v_R15_n_r
        struct[0].g[141,0] = i_vsc_R14_a_i + 26.5300693004806*v_R13_a_i - 4.84676915585801*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r - 7.72144347466701*v_R13_c_i - 0.67991845328531*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r - 53.0601386009611*v_R14_a_i + 9.69353831171601*v_R14_a_r + 15.7892267502954*v_R14_b_i + 3.16965629008966*v_R14_b_r + 15.442886949334*v_R14_c_i + 1.35983690657062*v_R14_c_r + 15.7892267502954*v_R14_n_i + 3.16965629008966*v_R14_n_r + 26.5300693004806*v_R15_a_i - 4.84676915585801*v_R15_a_r - 7.8946133751477*v_R15_b_i - 1.58482814504483*v_R15_b_r - 7.72144347466701*v_R15_c_i - 0.67991845328531*v_R15_c_r - 7.89461337514771*v_R15_n_i - 1.58482814504483*v_R15_n_r
        struct[0].g[142,0] = i_vsc_R14_b_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 4.84676915585801*v_R13_b_i + 26.5300693004806*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 0.679918453285308*v_R13_n_i - 7.72144347466701*v_R13_n_r - 3.16965629008966*v_R14_a_i + 15.7892267502954*v_R14_a_r - 9.69353831171602*v_R14_b_i - 53.0601386009611*v_R14_b_r - 3.16965629008967*v_R14_c_i + 15.7892267502954*v_R14_c_r - 1.35983690657062*v_R14_n_i + 15.442886949334*v_R14_n_r + 1.58482814504483*v_R15_a_i - 7.89461337514771*v_R15_a_r + 4.84676915585801*v_R15_b_i + 26.5300693004806*v_R15_b_r + 1.58482814504483*v_R15_c_i - 7.89461337514771*v_R15_c_r + 0.679918453285308*v_R15_n_i - 7.72144347466701*v_R15_n_r
        struct[0].g[143,0] = i_vsc_R14_b_i - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r + 26.5300693004806*v_R13_b_i - 4.84676915585801*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r - 7.72144347466701*v_R13_n_i - 0.679918453285308*v_R13_n_r + 15.7892267502954*v_R14_a_i + 3.16965629008966*v_R14_a_r - 53.0601386009611*v_R14_b_i + 9.69353831171602*v_R14_b_r + 15.7892267502954*v_R14_c_i + 3.16965629008967*v_R14_c_r + 15.442886949334*v_R14_n_i + 1.35983690657062*v_R14_n_r - 7.89461337514771*v_R15_a_i - 1.58482814504483*v_R15_a_r + 26.5300693004806*v_R15_b_i - 4.84676915585801*v_R15_b_r - 7.89461337514771*v_R15_c_i - 1.58482814504483*v_R15_c_r - 7.72144347466701*v_R15_n_i - 0.679918453285308*v_R15_n_r
        struct[0].g[144,0] = i_vsc_R14_c_r + 0.67991845328531*v_R13_a_i - 7.72144347466701*v_R13_a_r + 1.58482814504483*v_R13_b_i - 7.8946133751477*v_R13_b_r + 4.84676915585801*v_R13_c_i + 26.5300693004806*v_R13_c_r + 1.58482814504483*v_R13_n_i - 7.89461337514771*v_R13_n_r - 1.35983690657062*v_R14_a_i + 15.442886949334*v_R14_a_r - 3.16965629008966*v_R14_b_i + 15.7892267502954*v_R14_b_r - 9.69353831171602*v_R14_c_i - 53.0601386009611*v_R14_c_r - 3.16965629008967*v_R14_n_i + 15.7892267502954*v_R14_n_r + 0.67991845328531*v_R15_a_i - 7.72144347466701*v_R15_a_r + 1.58482814504483*v_R15_b_i - 7.8946133751477*v_R15_b_r + 4.84676915585801*v_R15_c_i + 26.5300693004806*v_R15_c_r + 1.58482814504483*v_R15_n_i - 7.89461337514771*v_R15_n_r
        struct[0].g[145,0] = i_vsc_R14_c_i - 7.72144347466701*v_R13_a_i - 0.67991845328531*v_R13_a_r - 7.8946133751477*v_R13_b_i - 1.58482814504483*v_R13_b_r + 26.5300693004806*v_R13_c_i - 4.84676915585801*v_R13_c_r - 7.89461337514771*v_R13_n_i - 1.58482814504483*v_R13_n_r + 15.442886949334*v_R14_a_i + 1.35983690657062*v_R14_a_r + 15.7892267502954*v_R14_b_i + 3.16965629008966*v_R14_b_r - 53.0601386009611*v_R14_c_i + 9.69353831171602*v_R14_c_r + 15.7892267502954*v_R14_n_i + 3.16965629008967*v_R14_n_r - 7.72144347466701*v_R15_a_i - 0.67991845328531*v_R15_a_r - 7.8946133751477*v_R15_b_i - 1.58482814504483*v_R15_b_r + 26.5300693004806*v_R15_c_i - 4.84676915585801*v_R15_c_r - 7.89461337514771*v_R15_n_i - 1.58482814504483*v_R15_n_r
        struct[0].g[146,0] = i_vsc_R14_n_r + 1.58482814504483*v_R13_a_i - 7.89461337514771*v_R13_a_r + 0.679918453285308*v_R13_b_i - 7.72144347466701*v_R13_b_r + 1.58482814504483*v_R13_c_i - 7.89461337514771*v_R13_c_r + 4.84676915585801*v_R13_n_i + 26.5300693004806*v_R13_n_r - 3.16965629008966*v_R14_a_i + 15.7892267502954*v_R14_a_r - 1.35983690657062*v_R14_b_i + 15.442886949334*v_R14_b_r - 3.16965629008966*v_R14_c_i + 15.7892267502954*v_R14_c_r - 9.69353831171602*v_R14_n_i - 53.0601386009611*v_R14_n_r + 1.58482814504483*v_R15_a_i - 7.89461337514771*v_R15_a_r + 0.679918453285308*v_R15_b_i - 7.72144347466701*v_R15_b_r + 1.58482814504483*v_R15_c_i - 7.89461337514771*v_R15_c_r + 4.84676915585801*v_R15_n_i + 26.5300693004806*v_R15_n_r
        struct[0].g[147,0] = i_vsc_R14_n_i - 7.89461337514771*v_R13_a_i - 1.58482814504483*v_R13_a_r - 7.72144347466701*v_R13_b_i - 0.679918453285308*v_R13_b_r - 7.89461337514771*v_R13_c_i - 1.58482814504483*v_R13_c_r + 26.5300693004806*v_R13_n_i - 4.84676915585801*v_R13_n_r + 15.7892267502954*v_R14_a_i + 3.16965629008966*v_R14_a_r + 15.442886949334*v_R14_b_i + 1.35983690657062*v_R14_b_r + 15.7892267502954*v_R14_c_i + 3.16965629008966*v_R14_c_r - 53.0601386009611*v_R14_n_i + 9.69353831171602*v_R14_n_r - 7.89461337514771*v_R15_a_i - 1.58482814504483*v_R15_a_r - 7.72144347466701*v_R15_b_i - 0.679918453285308*v_R15_b_r - 7.89461337514771*v_R15_c_i - 1.58482814504483*v_R15_c_r + 26.5300693004806*v_R15_n_i - 4.84676915585801*v_R15_n_r
        struct[0].g[148,0] = 1.58482814504483*v_R14_a_i - 7.89461337514771*v_R14_a_r + 4.84676915585801*v_R14_b_i + 26.5300693004806*v_R14_b_r + 1.58482814504483*v_R14_c_i - 7.89461337514771*v_R14_c_r + 0.679918453285308*v_R14_n_i - 7.72144347466701*v_R14_n_r - 1.58482814504483*v_R15_a_i + 7.89461337514771*v_R15_a_r - 4.84676915585801*v_R15_b_i - 26.5300693004806*v_R15_b_r - 1.58482814504483*v_R15_c_i + 7.89461337514771*v_R15_c_r - 0.679918453285308*v_R15_n_i + 7.72144347466701*v_R15_n_r
        struct[0].g[149,0] = -7.89461337514771*v_R14_a_i - 1.58482814504483*v_R14_a_r + 26.5300693004806*v_R14_b_i - 4.84676915585801*v_R14_b_r - 7.89461337514771*v_R14_c_i - 1.58482814504483*v_R14_c_r - 7.72144347466701*v_R14_n_i - 0.679918453285308*v_R14_n_r + 7.89461337514771*v_R15_a_i + 1.58482814504483*v_R15_a_r - 26.5300693004806*v_R15_b_i + 4.84676915585801*v_R15_b_r + 7.89461337514771*v_R15_c_i + 1.58482814504483*v_R15_c_r + 7.72144347466701*v_R15_n_i + 0.679918453285308*v_R15_n_r
        struct[0].g[150,0] = 0.67991845328531*v_R14_a_i - 7.72144347466701*v_R14_a_r + 1.58482814504483*v_R14_b_i - 7.8946133751477*v_R14_b_r + 4.84676915585801*v_R14_c_i + 26.5300693004806*v_R14_c_r + 1.58482814504483*v_R14_n_i - 7.89461337514771*v_R14_n_r - 0.67991845328531*v_R15_a_i + 7.72144347466701*v_R15_a_r - 1.58482814504483*v_R15_b_i + 7.8946133751477*v_R15_b_r - 4.84676915585801*v_R15_c_i - 26.5300693004806*v_R15_c_r - 1.58482814504483*v_R15_n_i + 7.89461337514771*v_R15_n_r
        struct[0].g[151,0] = -7.72144347466701*v_R14_a_i - 0.67991845328531*v_R14_a_r - 7.8946133751477*v_R14_b_i - 1.58482814504483*v_R14_b_r + 26.5300693004806*v_R14_c_i - 4.84676915585801*v_R14_c_r - 7.89461337514771*v_R14_n_i - 1.58482814504483*v_R14_n_r + 7.72144347466701*v_R15_a_i + 0.67991845328531*v_R15_a_r + 7.8946133751477*v_R15_b_i + 1.58482814504483*v_R15_b_r - 26.5300693004806*v_R15_c_i + 4.84676915585801*v_R15_c_r + 7.89461337514771*v_R15_n_i + 1.58482814504483*v_R15_n_r
        struct[0].g[152,0] = -1.84896616921897*v_R16_a_i + 9.21038227100566*v_R16_a_r - 5.65456401516768*v_R16_b_i - 30.9517475172273*v_R16_b_r - 1.84896616921897*v_R16_c_i + 9.21038227100566*v_R16_c_r - 0.793238195499528*v_R16_n_i + 9.00835072044485*v_R16_n_r + 1.84896616921897*v_R6_a_i - 9.21038227100566*v_R6_a_r + 5.65456401516768*v_R6_b_i + 30.9517475172273*v_R6_b_r + 1.84896616921897*v_R6_c_i - 9.21038227100566*v_R6_c_r + 0.793238195499528*v_R6_n_i - 9.00835072044485*v_R6_n_r
        struct[0].g[153,0] = 9.21038227100566*v_R16_a_i + 1.84896616921897*v_R16_a_r - 30.9517475172273*v_R16_b_i + 5.65456401516768*v_R16_b_r + 9.21038227100566*v_R16_c_i + 1.84896616921897*v_R16_c_r + 9.00835072044485*v_R16_n_i + 0.793238195499528*v_R16_n_r - 9.21038227100566*v_R6_a_i - 1.84896616921897*v_R6_a_r + 30.9517475172273*v_R6_b_i - 5.65456401516768*v_R6_b_r - 9.21038227100566*v_R6_c_i - 1.84896616921897*v_R6_c_r - 9.00835072044485*v_R6_n_i - 0.793238195499528*v_R6_n_r
        struct[0].g[154,0] = -0.793238195499527*v_R16_a_i + 9.00835072044484*v_R16_a_r - 1.84896616921897*v_R16_b_i + 9.21038227100566*v_R16_b_r - 5.65456401516768*v_R16_c_i - 30.9517475172273*v_R16_c_r - 1.84896616921897*v_R16_n_i + 9.21038227100566*v_R16_n_r + 0.793238195499527*v_R6_a_i - 9.00835072044484*v_R6_a_r + 1.84896616921897*v_R6_b_i - 9.21038227100566*v_R6_b_r + 5.65456401516768*v_R6_c_i + 30.9517475172273*v_R6_c_r + 1.84896616921897*v_R6_n_i - 9.21038227100566*v_R6_n_r
        struct[0].g[155,0] = 9.00835072044484*v_R16_a_i + 0.793238195499527*v_R16_a_r + 9.21038227100566*v_R16_b_i + 1.84896616921897*v_R16_b_r - 30.9517475172273*v_R16_c_i + 5.65456401516768*v_R16_c_r + 9.21038227100566*v_R16_n_i + 1.84896616921897*v_R16_n_r - 9.00835072044484*v_R6_a_i - 0.793238195499527*v_R6_a_r - 9.21038227100566*v_R6_b_i - 1.84896616921897*v_R6_b_r + 30.9517475172273*v_R6_c_i - 5.65456401516768*v_R6_c_r - 9.21038227100566*v_R6_n_i - 1.84896616921897*v_R6_n_r
        struct[0].g[156,0] = -1.84896616921897*v_R17_a_i + 9.21038227100566*v_R17_a_r - 5.65456401516768*v_R17_b_i - 30.9517475172273*v_R17_b_r - 1.84896616921897*v_R17_c_i + 9.21038227100566*v_R17_c_r - 0.793238195499528*v_R17_n_i + 9.00835072044485*v_R17_n_r + 1.84896616921897*v_R9_a_i - 9.21038227100566*v_R9_a_r + 5.65456401516768*v_R9_b_i + 30.9517475172273*v_R9_b_r + 1.84896616921897*v_R9_c_i - 9.21038227100566*v_R9_c_r + 0.793238195499528*v_R9_n_i - 9.00835072044485*v_R9_n_r
        struct[0].g[157,0] = 9.21038227100566*v_R17_a_i + 1.84896616921897*v_R17_a_r - 30.9517475172273*v_R17_b_i + 5.65456401516768*v_R17_b_r + 9.21038227100566*v_R17_c_i + 1.84896616921897*v_R17_c_r + 9.00835072044485*v_R17_n_i + 0.793238195499528*v_R17_n_r - 9.21038227100566*v_R9_a_i - 1.84896616921897*v_R9_a_r + 30.9517475172273*v_R9_b_i - 5.65456401516768*v_R9_b_r - 9.21038227100566*v_R9_c_i - 1.84896616921897*v_R9_c_r - 9.00835072044485*v_R9_n_i - 0.793238195499528*v_R9_n_r
        struct[0].g[158,0] = -0.793238195499527*v_R17_a_i + 9.00835072044484*v_R17_a_r - 1.84896616921897*v_R17_b_i + 9.21038227100566*v_R17_b_r - 5.65456401516768*v_R17_c_i - 30.9517475172273*v_R17_c_r - 1.84896616921897*v_R17_n_i + 9.21038227100566*v_R17_n_r + 0.793238195499527*v_R9_a_i - 9.00835072044484*v_R9_a_r + 1.84896616921897*v_R9_b_i - 9.21038227100566*v_R9_b_r + 5.65456401516768*v_R9_c_i + 30.9517475172273*v_R9_c_r + 1.84896616921897*v_R9_n_i - 9.21038227100566*v_R9_n_r
        struct[0].g[159,0] = 9.00835072044484*v_R17_a_i + 0.793238195499527*v_R17_a_r + 9.21038227100566*v_R17_b_i + 1.84896616921897*v_R17_b_r - 30.9517475172273*v_R17_c_i + 5.65456401516768*v_R17_c_r + 9.21038227100566*v_R17_n_i + 1.84896616921897*v_R17_n_r - 9.00835072044484*v_R9_a_i - 0.793238195499527*v_R9_a_r - 9.21038227100566*v_R9_b_i - 1.84896616921897*v_R9_b_r + 30.9517475172273*v_R9_c_i - 5.65456401516768*v_R9_c_r - 9.21038227100566*v_R9_n_i - 1.84896616921897*v_R9_n_r
        struct[0].g[160,0] = 1.84896616921897*v_R10_a_i - 9.21038227100566*v_R10_a_r + 5.65456401516768*v_R10_b_i + 30.9517475172273*v_R10_b_r + 1.84896616921897*v_R10_c_i - 9.21038227100566*v_R10_c_r + 0.793238195499528*v_R10_n_i - 9.00835072044485*v_R10_n_r - 1.84896616921897*v_R18_a_i + 9.21038227100566*v_R18_a_r - 5.65456401516768*v_R18_b_i - 30.9517475172273*v_R18_b_r - 1.84896616921897*v_R18_c_i + 9.21038227100566*v_R18_c_r - 0.793238195499528*v_R18_n_i + 9.00835072044485*v_R18_n_r
        struct[0].g[161,0] = -9.21038227100566*v_R10_a_i - 1.84896616921897*v_R10_a_r + 30.9517475172273*v_R10_b_i - 5.65456401516768*v_R10_b_r - 9.21038227100566*v_R10_c_i - 1.84896616921897*v_R10_c_r - 9.00835072044485*v_R10_n_i - 0.793238195499528*v_R10_n_r + 9.21038227100566*v_R18_a_i + 1.84896616921897*v_R18_a_r - 30.9517475172273*v_R18_b_i + 5.65456401516768*v_R18_b_r + 9.21038227100566*v_R18_c_i + 1.84896616921897*v_R18_c_r + 9.00835072044485*v_R18_n_i + 0.793238195499528*v_R18_n_r
        struct[0].g[162,0] = 0.793238195499527*v_R10_a_i - 9.00835072044484*v_R10_a_r + 1.84896616921897*v_R10_b_i - 9.21038227100566*v_R10_b_r + 5.65456401516768*v_R10_c_i + 30.9517475172273*v_R10_c_r + 1.84896616921897*v_R10_n_i - 9.21038227100566*v_R10_n_r - 0.793238195499527*v_R18_a_i + 9.00835072044484*v_R18_a_r - 1.84896616921897*v_R18_b_i + 9.21038227100566*v_R18_b_r - 5.65456401516768*v_R18_c_i - 30.9517475172273*v_R18_c_r - 1.84896616921897*v_R18_n_i + 9.21038227100566*v_R18_n_r
        struct[0].g[163,0] = -9.00835072044484*v_R10_a_i - 0.793238195499527*v_R10_a_r - 9.21038227100566*v_R10_b_i - 1.84896616921897*v_R10_b_r + 30.9517475172273*v_R10_c_i - 5.65456401516768*v_R10_c_r - 9.21038227100566*v_R10_n_i - 1.84896616921897*v_R10_n_r + 9.00835072044484*v_R18_a_i + 0.793238195499527*v_R18_a_r + 9.21038227100566*v_R18_b_i + 1.84896616921897*v_R18_b_r - 30.9517475172273*v_R18_c_i + 5.65456401516768*v_R18_c_r + 9.21038227100566*v_R18_n_i + 1.84896616921897*v_R18_n_r
        struct[0].g[164,0] = -1067.7048070413*v_D1_n_r + 67.7048070412999*v_D3_n_r
        struct[0].g[165,0] = -1067.7048070413*v_D1_n_i + 67.7048070412999*v_D3_n_i
        struct[0].g[166,0] = 157.977883096366*v_D11_a_r + 67.7048070412999*v_D1_a_r - 361.092304220266*v_D3_a_r + 135.4096140826*v_D4_a_r
        struct[0].g[167,0] = 157.977883096366*v_D11_a_i + 67.7048070412999*v_D1_a_i - 361.092304220266*v_D3_a_i + 135.4096140826*v_D4_a_i
        struct[0].g[168,0] = 157.977883096366*v_D11_b_r + 67.7048070412999*v_D1_b_r - 361.092304220266*v_D3_b_r + 135.4096140826*v_D4_b_r
        struct[0].g[169,0] = 157.977883096366*v_D11_b_i + 67.7048070412999*v_D1_b_i - 361.092304220266*v_D3_b_i + 135.4096140826*v_D4_b_i
        struct[0].g[170,0] = 157.977883096366*v_D11_c_r + 67.7048070412999*v_D1_c_r - 361.092304220266*v_D3_c_r + 135.4096140826*v_D4_c_r
        struct[0].g[171,0] = 157.977883096366*v_D11_c_i + 67.7048070412999*v_D1_c_i - 361.092304220266*v_D3_c_i + 135.4096140826*v_D4_c_i
        struct[0].g[172,0] = 157.977883096366*v_D11_n_r + 67.7048070412999*v_D1_n_r - 361.092304220266*v_D3_n_r + 135.4096140826*v_D4_n_r
        struct[0].g[173,0] = 157.977883096366*v_D11_n_i + 67.7048070412999*v_D1_n_i - 361.092304220266*v_D3_n_i + 135.4096140826*v_D4_n_i
        struct[0].g[174,0] = 45.1365380275333*v_D14_a_r + 135.4096140826*v_D3_a_r - 248.250959151433*v_D4_a_r + 67.7048070412999*v_D6_a_r
        struct[0].g[175,0] = 45.1365380275333*v_D14_a_i + 135.4096140826*v_D3_a_i - 248.250959151433*v_D4_a_i + 67.7048070412999*v_D6_a_i
        struct[0].g[176,0] = 45.1365380275333*v_D14_b_r + 135.4096140826*v_D3_b_r - 248.250959151433*v_D4_b_r + 67.7048070412999*v_D6_b_r
        struct[0].g[177,0] = 45.1365380275333*v_D14_b_i + 135.4096140826*v_D3_b_i - 248.250959151433*v_D4_b_i + 67.7048070412999*v_D6_b_i
        struct[0].g[178,0] = 45.1365380275333*v_D14_c_r + 135.4096140826*v_D3_c_r - 248.250959151433*v_D4_c_r + 67.7048070412999*v_D6_c_r
        struct[0].g[179,0] = 45.1365380275333*v_D14_c_i + 135.4096140826*v_D3_c_i - 248.250959151433*v_D4_c_i + 67.7048070412999*v_D6_c_i
        struct[0].g[180,0] = 45.1365380275333*v_D14_n_r + 135.4096140826*v_D3_n_r - 248.250959151433*v_D4_n_r + 67.7048070412999*v_D6_n_r
        struct[0].g[181,0] = 45.1365380275333*v_D14_n_i + 135.4096140826*v_D3_n_i - 248.250959151433*v_D4_n_i + 67.7048070412999*v_D6_n_i
        struct[0].g[182,0] = 157.977883096366*v_D16_a_r + 67.7048070412999*v_D4_a_r - 270.8192281652*v_D6_a_r + 45.1365380275333*v_D9_a_r
        struct[0].g[183,0] = 157.977883096366*v_D16_a_i + 67.7048070412999*v_D4_a_i - 270.8192281652*v_D6_a_i + 45.1365380275333*v_D9_a_i
        struct[0].g[184,0] = 157.977883096366*v_D16_b_r + 67.7048070412999*v_D4_b_r - 270.8192281652*v_D6_b_r + 45.1365380275333*v_D9_b_r
        struct[0].g[185,0] = 157.977883096366*v_D16_b_i + 67.7048070412999*v_D4_b_i - 270.8192281652*v_D6_b_i + 45.1365380275333*v_D9_b_i
        struct[0].g[186,0] = 157.977883096366*v_D16_c_r + 67.7048070412999*v_D4_c_r - 270.8192281652*v_D6_c_r + 45.1365380275333*v_D9_c_r
        struct[0].g[187,0] = 157.977883096366*v_D16_c_i + 67.7048070412999*v_D4_c_i - 270.8192281652*v_D6_c_i + 45.1365380275333*v_D9_c_i
        struct[0].g[188,0] = 157.977883096366*v_D16_n_r + 67.7048070412999*v_D4_n_r - 270.8192281652*v_D6_n_r + 45.1365380275333*v_D9_n_r
        struct[0].g[189,0] = 157.977883096366*v_D16_n_i + 67.7048070412999*v_D4_n_i - 270.8192281652*v_D6_n_i + 45.1365380275333*v_D9_n_i
        struct[0].g[190,0] = 157.977883096366*v_D10_a_r + 157.977883096366*v_D17_a_r + 45.1365380275333*v_D6_a_r - 361.092304220266*v_D9_a_r
        struct[0].g[191,0] = 157.977883096366*v_D10_a_i + 157.977883096366*v_D17_a_i + 45.1365380275333*v_D6_a_i - 361.092304220266*v_D9_a_i
        struct[0].g[192,0] = 157.977883096366*v_D10_b_r + 157.977883096366*v_D17_b_r + 45.1365380275333*v_D6_b_r - 361.092304220266*v_D9_b_r
        struct[0].g[193,0] = 157.977883096366*v_D10_b_i + 157.977883096366*v_D17_b_i + 45.1365380275333*v_D6_b_i - 361.092304220266*v_D9_b_i
        struct[0].g[194,0] = 157.977883096366*v_D10_c_r + 157.977883096366*v_D17_c_r + 45.1365380275333*v_D6_c_r - 361.092304220266*v_D9_c_r
        struct[0].g[195,0] = 157.977883096366*v_D10_c_i + 157.977883096366*v_D17_c_i + 45.1365380275333*v_D6_c_i - 361.092304220266*v_D9_c_i
        struct[0].g[196,0] = 157.977883096366*v_D10_n_r + 157.977883096366*v_D17_n_r + 45.1365380275333*v_D6_n_r - 361.092304220266*v_D9_n_r
        struct[0].g[197,0] = 157.977883096366*v_D10_n_i + 157.977883096366*v_D17_n_i + 45.1365380275333*v_D6_n_i - 361.092304220266*v_D9_n_i
        struct[0].g[198,0] = i_vsc_D10_a_r - 315.955766192733*v_D10_a_r + 157.977883096366*v_D18_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[199,0] = -315.955766192733*v_D10_a_i + 157.977883096366*v_D18_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[200,0] = -315.955766192733*v_D10_b_r + 157.977883096366*v_D18_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[201,0] = -315.955766192733*v_D10_b_i + 157.977883096366*v_D18_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[202,0] = -315.955766192733*v_D10_c_r + 157.977883096366*v_D18_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[203,0] = -315.955766192733*v_D10_c_i + 157.977883096366*v_D18_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[204,0] = i_vsc_D10_n_r - 315.955766192733*v_D10_n_r + 157.977883096366*v_D18_n_r + 157.977883096366*v_D9_n_r
        struct[0].g[205,0] = -315.955766192733*v_D10_n_i + 157.977883096366*v_D18_n_i + 157.977883096366*v_D9_n_i
        struct[0].g[206,0] = -157.977883096366*v_D11_b_r + 157.977883096366*v_D3_b_r
        struct[0].g[207,0] = -157.977883096366*v_D11_b_i + 157.977883096366*v_D3_b_i
        struct[0].g[208,0] = -157.977883096366*v_D11_c_r + 157.977883096366*v_D3_c_r
        struct[0].g[209,0] = -157.977883096366*v_D11_c_i + 157.977883096366*v_D3_c_i
        struct[0].g[210,0] = -157.977883096366*v_D16_b_r + 157.977883096366*v_D6_b_r
        struct[0].g[211,0] = -157.977883096366*v_D16_b_i + 157.977883096366*v_D6_b_i
        struct[0].g[212,0] = -157.977883096366*v_D16_c_r + 157.977883096366*v_D6_c_r
        struct[0].g[213,0] = -157.977883096366*v_D16_c_i + 157.977883096366*v_D6_c_i
        struct[0].g[214,0] = -157.977883096366*v_D17_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[215,0] = -157.977883096366*v_D17_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[216,0] = -157.977883096366*v_D17_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[217,0] = -157.977883096366*v_D17_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[218,0] = 157.977883096366*v_D10_b_r - 157.977883096366*v_D18_b_r
        struct[0].g[219,0] = 157.977883096366*v_D10_b_i - 157.977883096366*v_D18_b_i
        struct[0].g[220,0] = 157.977883096366*v_D10_c_r - 157.977883096366*v_D18_c_r
        struct[0].g[221,0] = 157.977883096366*v_D10_c_i - 157.977883096366*v_D18_c_i
        struct[0].g[222,0] = i_vsc_D14_a_r - 180.546152110133*v_D14_a_r + 135.4096140826*v_D15_a_r + 45.1365380275333*v_D4_a_r
        struct[0].g[223,0] = -180.546152110133*v_D14_a_i + 135.4096140826*v_D15_a_i + 45.1365380275333*v_D4_a_i
        struct[0].g[224,0] = -180.546152110133*v_D14_b_r + 135.4096140826*v_D15_b_r + 45.1365380275333*v_D4_b_r
        struct[0].g[225,0] = -180.546152110133*v_D14_b_i + 135.4096140826*v_D15_b_i + 45.1365380275333*v_D4_b_i
        struct[0].g[226,0] = -180.546152110133*v_D14_c_r + 135.4096140826*v_D15_c_r + 45.1365380275333*v_D4_c_r
        struct[0].g[227,0] = -180.546152110133*v_D14_c_i + 135.4096140826*v_D15_c_i + 45.1365380275333*v_D4_c_i
        struct[0].g[228,0] = i_vsc_D14_n_r - 180.546152110133*v_D14_n_r + 135.4096140826*v_D15_n_r + 45.1365380275333*v_D4_n_r
        struct[0].g[229,0] = -180.546152110133*v_D14_n_i + 135.4096140826*v_D15_n_i + 45.1365380275333*v_D4_n_i
        struct[0].g[230,0] = 135.4096140826*v_D14_b_r - 135.4096140826*v_D15_b_r
        struct[0].g[231,0] = 135.4096140826*v_D14_b_i - 135.4096140826*v_D15_b_i
        struct[0].g[232,0] = 135.4096140826*v_D14_c_r - 135.4096140826*v_D15_c_r
        struct[0].g[233,0] = 135.4096140826*v_D14_c_i - 135.4096140826*v_D15_c_i
        struct[0].g[234,0] = -i_t_R0_R1_a_r + 0.0196078431372549*v_R0_a_i + 0.00490196078431373*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_a_i - 0.212261128378539*v_R1_a_r + 0.849044513514155*v_R1_b_i + 0.212261128378539*v_R1_b_r
        struct[0].g[235,0] = -i_t_R0_R1_a_i + 0.00490196078431373*v_R0_a_i - 0.0196078431372549*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_a_i + 0.849044513514155*v_R1_a_r + 0.212261128378539*v_R1_b_i - 0.849044513514155*v_R1_b_r
        struct[0].g[236,0] = -i_t_R0_R1_b_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r + 0.0196078431372549*v_R0_b_i + 0.00490196078431373*v_R0_b_r - 0.00980392156862745*v_R0_c_i - 0.00245098039215686*v_R0_c_r - 0.849044513514155*v_R1_b_i - 0.212261128378539*v_R1_b_r + 0.849044513514155*v_R1_c_i + 0.212261128378539*v_R1_c_r
        struct[0].g[237,0] = -i_t_R0_R1_b_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r + 0.00490196078431373*v_R0_b_i - 0.0196078431372549*v_R0_b_r - 0.00245098039215686*v_R0_c_i + 0.00980392156862745*v_R0_c_r - 0.212261128378539*v_R1_b_i + 0.849044513514155*v_R1_b_r + 0.212261128378539*v_R1_c_i - 0.849044513514155*v_R1_c_r
        struct[0].g[238,0] = -i_t_R0_R1_c_r - 0.00980392156862745*v_R0_a_i - 0.00245098039215686*v_R0_a_r - 0.00980392156862745*v_R0_b_i - 0.00245098039215686*v_R0_b_r + 0.0196078431372549*v_R0_c_i + 0.00490196078431373*v_R0_c_r + 0.849044513514155*v_R1_a_i + 0.212261128378539*v_R1_a_r - 0.849044513514155*v_R1_c_i - 0.212261128378539*v_R1_c_r
        struct[0].g[239,0] = -i_t_R0_R1_c_i - 0.00245098039215686*v_R0_a_i + 0.00980392156862745*v_R0_a_r - 0.00245098039215686*v_R0_b_i + 0.00980392156862745*v_R0_b_r + 0.00490196078431373*v_R0_c_i - 0.0196078431372549*v_R0_c_r + 0.212261128378539*v_R1_a_i - 0.849044513514155*v_R1_a_r - 0.212261128378539*v_R1_c_i + 0.849044513514155*v_R1_c_r
        struct[0].g[240,0] = -i_l_R1_R2_a_r + 54.0657727682604*v_R1_a_i + 105.57176931318*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r - 23.284964480954*v_R1_c_i - 24.9575997948692*v_R1_c_r - 10.2713736253513*v_R1_n_i - 39.6392229058202*v_R1_n_r - 54.0657727682604*v_R2_a_i - 105.57176931318*v_R2_a_r + 10.2713736253513*v_R2_b_i + 39.6392229058202*v_R2_b_r + 23.284964480954*v_R2_c_i + 24.9575997948692*v_R2_c_r + 10.2713736253513*v_R2_n_i + 39.6392229058202*v_R2_n_r
        struct[0].g[241,0] = -i_l_R1_R2_a_i + 105.57176931318*v_R1_a_i - 54.0657727682604*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r - 24.9575997948692*v_R1_c_i + 23.284964480954*v_R1_c_r - 39.6392229058202*v_R1_n_i + 10.2713736253513*v_R1_n_r - 105.57176931318*v_R2_a_i + 54.0657727682604*v_R2_a_r + 39.6392229058202*v_R2_b_i - 10.2713736253513*v_R2_b_r + 24.9575997948692*v_R2_c_i - 23.284964480954*v_R2_c_r + 39.6392229058202*v_R2_n_i - 10.2713736253513*v_R2_n_r
        struct[0].g[242,0] = -i_l_R1_R2_b_r - 10.2713736253513*v_R1_a_i - 39.6392229058202*v_R1_a_r + 54.0657727682604*v_R1_b_i + 105.57176931318*v_R1_b_r - 10.2713736253513*v_R1_c_i - 39.6392229058201*v_R1_c_r - 23.284964480954*v_R1_n_i - 24.9575997948692*v_R1_n_r + 10.2713736253513*v_R2_a_i + 39.6392229058202*v_R2_a_r - 54.0657727682604*v_R2_b_i - 105.57176931318*v_R2_b_r + 10.2713736253513*v_R2_c_i + 39.6392229058201*v_R2_c_r + 23.284964480954*v_R2_n_i + 24.9575997948692*v_R2_n_r
        struct[0].g[243,0] = -i_l_R1_R2_b_i - 39.6392229058202*v_R1_a_i + 10.2713736253513*v_R1_a_r + 105.57176931318*v_R1_b_i - 54.0657727682604*v_R1_b_r - 39.6392229058201*v_R1_c_i + 10.2713736253513*v_R1_c_r - 24.9575997948692*v_R1_n_i + 23.284964480954*v_R1_n_r + 39.6392229058202*v_R2_a_i - 10.2713736253513*v_R2_a_r - 105.57176931318*v_R2_b_i + 54.0657727682604*v_R2_b_r + 39.6392229058201*v_R2_c_i - 10.2713736253513*v_R2_c_r + 24.9575997948692*v_R2_n_i - 23.284964480954*v_R2_n_r
        struct[0].g[244,0] = -i_l_R1_R2_c_r - 23.284964480954*v_R1_a_i - 24.9575997948692*v_R1_a_r - 10.2713736253513*v_R1_b_i - 39.6392229058202*v_R1_b_r + 54.0657727682604*v_R1_c_i + 105.57176931318*v_R1_c_r - 10.2713736253514*v_R1_n_i - 39.6392229058201*v_R1_n_r + 23.284964480954*v_R2_a_i + 24.9575997948692*v_R2_a_r + 10.2713736253513*v_R2_b_i + 39.6392229058202*v_R2_b_r - 54.0657727682604*v_R2_c_i - 105.57176931318*v_R2_c_r + 10.2713736253514*v_R2_n_i + 39.6392229058201*v_R2_n_r
        struct[0].g[245,0] = -i_l_R1_R2_c_i - 24.9575997948692*v_R1_a_i + 23.284964480954*v_R1_a_r - 39.6392229058202*v_R1_b_i + 10.2713736253513*v_R1_b_r + 105.57176931318*v_R1_c_i - 54.0657727682604*v_R1_c_r - 39.6392229058201*v_R1_n_i + 10.2713736253514*v_R1_n_r + 24.9575997948692*v_R2_a_i - 23.284964480954*v_R2_a_r + 39.6392229058202*v_R2_b_i - 10.2713736253513*v_R2_b_r - 105.57176931318*v_R2_c_i + 54.0657727682604*v_R2_c_r + 39.6392229058201*v_R2_n_i - 10.2713736253514*v_R2_n_r
        struct[0].g[246,0] = i_l_R1_R2_a_r + i_l_R1_R2_b_r + i_l_R1_R2_c_r - i_l_R1_R2_n_r
        struct[0].g[247,0] = i_l_R1_R2_a_i + i_l_R1_R2_b_i + i_l_R1_R2_c_i - i_l_R1_R2_n_i
        struct[0].g[248,0] = -i_l_D1_D3_a_r + 67.7048070412999*v_D1_a_r - 67.7048070412999*v_D3_a_r
        struct[0].g[249,0] = -i_l_D1_D3_a_i + 67.7048070412999*v_D1_a_i - 67.7048070412999*v_D3_a_i
        struct[0].g[250,0] = -i_l_D1_D3_b_r + 67.7048070412999*v_D1_b_r - 67.7048070412999*v_D3_b_r
        struct[0].g[251,0] = -i_l_D1_D3_b_i + 67.7048070412999*v_D1_b_i - 67.7048070412999*v_D3_b_i
        struct[0].g[252,0] = -i_l_D1_D3_c_r + 67.7048070412999*v_D1_c_r - 67.7048070412999*v_D3_c_r
        struct[0].g[253,0] = -i_l_D1_D3_c_i + 67.7048070412999*v_D1_c_i - 67.7048070412999*v_D3_c_i
        struct[0].g[254,0] = i_l_D1_D3_a_r + i_l_D1_D3_b_r + i_l_D1_D3_c_r - i_l_D1_D3_n_r
        struct[0].g[255,0] = i_l_D1_D3_a_i + i_l_D1_D3_b_i + i_l_D1_D3_c_i - i_l_D1_D3_n_i
        struct[0].g[256,0] = -i_l_D3_D4_a_r + 135.4096140826*v_D3_a_r - 135.4096140826*v_D4_a_r
        struct[0].g[257,0] = -i_l_D3_D4_a_i + 135.4096140826*v_D3_a_i - 135.4096140826*v_D4_a_i
        struct[0].g[258,0] = -i_l_D3_D4_b_r + 135.4096140826*v_D3_b_r - 135.4096140826*v_D4_b_r
        struct[0].g[259,0] = -i_l_D3_D4_b_i + 135.4096140826*v_D3_b_i - 135.4096140826*v_D4_b_i
        struct[0].g[260,0] = -i_l_D3_D4_c_r + 135.4096140826*v_D3_c_r - 135.4096140826*v_D4_c_r
        struct[0].g[261,0] = -i_l_D3_D4_c_i + 135.4096140826*v_D3_c_i - 135.4096140826*v_D4_c_i
        struct[0].g[262,0] = i_l_D3_D4_a_r + i_l_D3_D4_b_r + i_l_D3_D4_c_r - i_l_D3_D4_n_r
        struct[0].g[263,0] = i_l_D3_D4_a_i + i_l_D3_D4_b_i + i_l_D3_D4_c_i - i_l_D3_D4_n_i
        struct[0].g[264,0] = -i_l_D4_D6_a_r + 67.7048070412999*v_D4_a_r - 67.7048070412999*v_D6_a_r
        struct[0].g[265,0] = -i_l_D4_D6_a_i + 67.7048070412999*v_D4_a_i - 67.7048070412999*v_D6_a_i
        struct[0].g[266,0] = -i_l_D4_D6_b_r + 67.7048070412999*v_D4_b_r - 67.7048070412999*v_D6_b_r
        struct[0].g[267,0] = -i_l_D4_D6_b_i + 67.7048070412999*v_D4_b_i - 67.7048070412999*v_D6_b_i
        struct[0].g[268,0] = -i_l_D4_D6_c_r + 67.7048070412999*v_D4_c_r - 67.7048070412999*v_D6_c_r
        struct[0].g[269,0] = -i_l_D4_D6_c_i + 67.7048070412999*v_D4_c_i - 67.7048070412999*v_D6_c_i
        struct[0].g[270,0] = i_l_D4_D6_a_r + i_l_D4_D6_b_r + i_l_D4_D6_c_r - i_l_D4_D6_n_r
        struct[0].g[271,0] = i_l_D4_D6_a_i + i_l_D4_D6_b_i + i_l_D4_D6_c_i - i_l_D4_D6_n_i
        struct[0].g[272,0] = -i_l_D6_D9_a_r + 45.1365380275333*v_D6_a_r - 45.1365380275333*v_D9_a_r
        struct[0].g[273,0] = -i_l_D6_D9_a_i + 45.1365380275333*v_D6_a_i - 45.1365380275333*v_D9_a_i
        struct[0].g[274,0] = -i_l_D6_D9_b_r + 45.1365380275333*v_D6_b_r - 45.1365380275333*v_D9_b_r
        struct[0].g[275,0] = -i_l_D6_D9_b_i + 45.1365380275333*v_D6_b_i - 45.1365380275333*v_D9_b_i
        struct[0].g[276,0] = -i_l_D6_D9_c_r + 45.1365380275333*v_D6_c_r - 45.1365380275333*v_D9_c_r
        struct[0].g[277,0] = -i_l_D6_D9_c_i + 45.1365380275333*v_D6_c_i - 45.1365380275333*v_D9_c_i
        struct[0].g[278,0] = i_l_D6_D9_a_r + i_l_D6_D9_b_r + i_l_D6_D9_c_r - i_l_D6_D9_n_r
        struct[0].g[279,0] = i_l_D6_D9_a_i + i_l_D6_D9_b_i + i_l_D6_D9_c_i - i_l_D6_D9_n_i
        struct[0].g[280,0] = -i_l_D9_D10_a_r - 157.977883096366*v_D10_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[281,0] = -i_l_D9_D10_a_i - 157.977883096366*v_D10_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[282,0] = -i_l_D9_D10_b_r - 157.977883096366*v_D10_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[283,0] = -i_l_D9_D10_b_i - 157.977883096366*v_D10_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[284,0] = -i_l_D9_D10_c_r - 157.977883096366*v_D10_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[285,0] = -i_l_D9_D10_c_i - 157.977883096366*v_D10_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[286,0] = i_l_D9_D10_a_r + i_l_D9_D10_b_r + i_l_D9_D10_c_r - i_l_D9_D10_n_r
        struct[0].g[287,0] = i_l_D9_D10_a_i + i_l_D9_D10_b_i + i_l_D9_D10_c_i - i_l_D9_D10_n_i
        struct[0].g[288,0] = -i_l_D3_D11_a_r - 157.977883096366*v_D11_a_r + 157.977883096366*v_D3_a_r
        struct[0].g[289,0] = -i_l_D3_D11_a_i - 157.977883096366*v_D11_a_i + 157.977883096366*v_D3_a_i
        struct[0].g[290,0] = -i_l_D3_D11_b_r - 157.977883096366*v_D11_b_r + 157.977883096366*v_D3_b_r
        struct[0].g[291,0] = -i_l_D3_D11_b_i - 157.977883096366*v_D11_b_i + 157.977883096366*v_D3_b_i
        struct[0].g[292,0] = -i_l_D3_D11_c_r - 157.977883096366*v_D11_c_r + 157.977883096366*v_D3_c_r
        struct[0].g[293,0] = -i_l_D3_D11_c_i - 157.977883096366*v_D11_c_i + 157.977883096366*v_D3_c_i
        struct[0].g[294,0] = i_l_D3_D11_a_r + i_l_D3_D11_b_r + i_l_D3_D11_c_r - i_l_D3_D11_n_r
        struct[0].g[295,0] = i_l_D3_D11_a_i + i_l_D3_D11_b_i + i_l_D3_D11_c_i - i_l_D3_D11_n_i
        struct[0].g[296,0] = -i_l_D6_D16_a_r - 157.977883096366*v_D16_a_r + 157.977883096366*v_D6_a_r
        struct[0].g[297,0] = -i_l_D6_D16_a_i - 157.977883096366*v_D16_a_i + 157.977883096366*v_D6_a_i
        struct[0].g[298,0] = -i_l_D6_D16_b_r - 157.977883096366*v_D16_b_r + 157.977883096366*v_D6_b_r
        struct[0].g[299,0] = -i_l_D6_D16_b_i - 157.977883096366*v_D16_b_i + 157.977883096366*v_D6_b_i
        struct[0].g[300,0] = -i_l_D6_D16_c_r - 157.977883096366*v_D16_c_r + 157.977883096366*v_D6_c_r
        struct[0].g[301,0] = -i_l_D6_D16_c_i - 157.977883096366*v_D16_c_i + 157.977883096366*v_D6_c_i
        struct[0].g[302,0] = i_l_D6_D16_a_r + i_l_D6_D16_b_r + i_l_D6_D16_c_r - i_l_D6_D16_n_r
        struct[0].g[303,0] = i_l_D6_D16_a_i + i_l_D6_D16_b_i + i_l_D6_D16_c_i - i_l_D6_D16_n_i
        struct[0].g[304,0] = -i_l_D9_D17_a_r - 157.977883096366*v_D17_a_r + 157.977883096366*v_D9_a_r
        struct[0].g[305,0] = -i_l_D9_D17_a_i - 157.977883096366*v_D17_a_i + 157.977883096366*v_D9_a_i
        struct[0].g[306,0] = -i_l_D9_D17_b_r - 157.977883096366*v_D17_b_r + 157.977883096366*v_D9_b_r
        struct[0].g[307,0] = -i_l_D9_D17_b_i - 157.977883096366*v_D17_b_i + 157.977883096366*v_D9_b_i
        struct[0].g[308,0] = -i_l_D9_D17_c_r - 157.977883096366*v_D17_c_r + 157.977883096366*v_D9_c_r
        struct[0].g[309,0] = -i_l_D9_D17_c_i - 157.977883096366*v_D17_c_i + 157.977883096366*v_D9_c_i
        struct[0].g[310,0] = i_l_D9_D17_a_r + i_l_D9_D17_b_r + i_l_D9_D17_c_r - i_l_D9_D17_n_r
        struct[0].g[311,0] = i_l_D9_D17_a_i + i_l_D9_D17_b_i + i_l_D9_D17_c_i - i_l_D9_D17_n_i
        struct[0].g[312,0] = -i_l_D10_D18_a_r + 157.977883096366*v_D10_a_r - 157.977883096366*v_D18_a_r
        struct[0].g[313,0] = -i_l_D10_D18_a_i + 157.977883096366*v_D10_a_i - 157.977883096366*v_D18_a_i
        struct[0].g[314,0] = -i_l_D10_D18_b_r + 157.977883096366*v_D10_b_r - 157.977883096366*v_D18_b_r
        struct[0].g[315,0] = -i_l_D10_D18_b_i + 157.977883096366*v_D10_b_i - 157.977883096366*v_D18_b_i
        struct[0].g[316,0] = -i_l_D10_D18_c_r + 157.977883096366*v_D10_c_r - 157.977883096366*v_D18_c_r
        struct[0].g[317,0] = -i_l_D10_D18_c_i + 157.977883096366*v_D10_c_i - 157.977883096366*v_D18_c_i
        struct[0].g[318,0] = i_l_D10_D18_a_r + i_l_D10_D18_b_r + i_l_D10_D18_c_r - i_l_D10_D18_n_r
        struct[0].g[319,0] = i_l_D10_D18_a_i + i_l_D10_D18_b_i + i_l_D10_D18_c_i - i_l_D10_D18_n_i
        struct[0].g[320,0] = -i_l_D4_D14_a_r - 45.1365380275333*v_D14_a_r + 45.1365380275333*v_D4_a_r
        struct[0].g[321,0] = -i_l_D4_D14_a_i - 45.1365380275333*v_D14_a_i + 45.1365380275333*v_D4_a_i
        struct[0].g[322,0] = -i_l_D4_D14_b_r - 45.1365380275333*v_D14_b_r + 45.1365380275333*v_D4_b_r
        struct[0].g[323,0] = -i_l_D4_D14_b_i - 45.1365380275333*v_D14_b_i + 45.1365380275333*v_D4_b_i
        struct[0].g[324,0] = -i_l_D4_D14_c_r - 45.1365380275333*v_D14_c_r + 45.1365380275333*v_D4_c_r
        struct[0].g[325,0] = -i_l_D4_D14_c_i - 45.1365380275333*v_D14_c_i + 45.1365380275333*v_D4_c_i
        struct[0].g[326,0] = i_l_D4_D14_a_r + i_l_D4_D14_b_r + i_l_D4_D14_c_r - i_l_D4_D14_n_r
        struct[0].g[327,0] = i_l_D4_D14_a_i + i_l_D4_D14_b_i + i_l_D4_D14_c_i - i_l_D4_D14_n_i
        struct[0].g[328,0] = -i_l_D14_D15_a_r + 135.4096140826*v_D14_a_r - 135.4096140826*v_D15_a_r
        struct[0].g[329,0] = -i_l_D14_D15_a_i + 135.4096140826*v_D14_a_i - 135.4096140826*v_D15_a_i
        struct[0].g[330,0] = -i_l_D14_D15_b_r + 135.4096140826*v_D14_b_r - 135.4096140826*v_D15_b_r
        struct[0].g[331,0] = -i_l_D14_D15_b_i + 135.4096140826*v_D14_b_i - 135.4096140826*v_D15_b_i
        struct[0].g[332,0] = -i_l_D14_D15_c_r + 135.4096140826*v_D14_c_r - 135.4096140826*v_D15_c_r
        struct[0].g[333,0] = -i_l_D14_D15_c_i + 135.4096140826*v_D14_c_i - 135.4096140826*v_D15_c_i
        struct[0].g[334,0] = i_l_D14_D15_a_r + i_l_D14_D15_b_r + i_l_D14_D15_c_r - i_l_D14_D15_n_r
        struct[0].g[335,0] = i_l_D14_D15_a_i + i_l_D14_D15_b_i + i_l_D14_D15_c_i - i_l_D14_D15_n_i
        struct[0].g[336,0] = i_load_R1_a_i*v_R1_a_i - i_load_R1_a_i*v_R1_n_i + i_load_R1_a_r*v_R1_a_r - i_load_R1_a_r*v_R1_n_r - p_R1_a
        struct[0].g[337,0] = i_load_R1_b_i*v_R1_b_i - i_load_R1_b_i*v_R1_n_i + i_load_R1_b_r*v_R1_b_r - i_load_R1_b_r*v_R1_n_r - p_R1_b
        struct[0].g[338,0] = i_load_R1_c_i*v_R1_c_i - i_load_R1_c_i*v_R1_n_i + i_load_R1_c_r*v_R1_c_r - i_load_R1_c_r*v_R1_n_r - p_R1_c
        struct[0].g[339,0] = -i_load_R1_a_i*v_R1_a_r + i_load_R1_a_i*v_R1_n_r + i_load_R1_a_r*v_R1_a_i - i_load_R1_a_r*v_R1_n_i - q_R1_a
        struct[0].g[340,0] = -i_load_R1_b_i*v_R1_b_r + i_load_R1_b_i*v_R1_n_r + i_load_R1_b_r*v_R1_b_i - i_load_R1_b_r*v_R1_n_i - q_R1_b
        struct[0].g[341,0] = -i_load_R1_c_i*v_R1_c_r + i_load_R1_c_i*v_R1_n_r + i_load_R1_c_r*v_R1_c_i - i_load_R1_c_r*v_R1_n_i - q_R1_c
        struct[0].g[342,0] = i_load_R1_a_r + i_load_R1_b_r + i_load_R1_c_r + i_load_R1_n_r
        struct[0].g[343,0] = i_load_R1_a_i + i_load_R1_b_i + i_load_R1_c_i + i_load_R1_n_i
        struct[0].g[344,0] = 1.0*i_load_R11_a_i*v_R11_a_i - 1.0*i_load_R11_a_i*v_R11_n_i + i_load_R11_a_r*v_R11_a_r - i_load_R11_a_r*v_R11_n_r - p_R11_1
        struct[0].g[345,0] = -1.0*i_load_R11_a_i*v_R11_a_r + 1.0*i_load_R11_a_i*v_R11_n_r + 1.0*i_load_R11_a_r*v_R11_a_i - 1.0*i_load_R11_a_r*v_R11_n_i - q_R11_1
        struct[0].g[346,0] = i_load_R11_a_r + i_load_R11_n_r
        struct[0].g[347,0] = 1.0*i_load_R11_a_i + 1.0*i_load_R11_n_i
        struct[0].g[348,0] = 1.0*i_load_R15_a_i*v_R15_a_i - 1.0*i_load_R15_a_i*v_R15_n_i + i_load_R15_a_r*v_R15_a_r - i_load_R15_a_r*v_R15_n_r - p_R15_1
        struct[0].g[349,0] = -1.0*i_load_R15_a_i*v_R15_a_r + 1.0*i_load_R15_a_i*v_R15_n_r + 1.0*i_load_R15_a_r*v_R15_a_i - 1.0*i_load_R15_a_r*v_R15_n_i - q_R15_1
        struct[0].g[350,0] = i_load_R15_a_r + i_load_R15_n_r
        struct[0].g[351,0] = 1.0*i_load_R15_a_i + 1.0*i_load_R15_n_i
        struct[0].g[352,0] = 1.0*i_load_R16_a_i*v_R16_a_i - 1.0*i_load_R16_a_i*v_R16_n_i + i_load_R16_a_r*v_R16_a_r - i_load_R16_a_r*v_R16_n_r - p_R16_1
        struct[0].g[353,0] = -1.0*i_load_R16_a_i*v_R16_a_r + 1.0*i_load_R16_a_i*v_R16_n_r + 1.0*i_load_R16_a_r*v_R16_a_i - 1.0*i_load_R16_a_r*v_R16_n_i - q_R16_1
        struct[0].g[354,0] = i_load_R16_a_r + i_load_R16_n_r
        struct[0].g[355,0] = 1.0*i_load_R16_a_i + 1.0*i_load_R16_n_i
        struct[0].g[356,0] = 1.0*i_load_R17_a_i*v_R17_a_i - 1.0*i_load_R17_a_i*v_R17_n_i + i_load_R17_a_r*v_R17_a_r - i_load_R17_a_r*v_R17_n_r - p_R17_1
        struct[0].g[357,0] = -1.0*i_load_R17_a_i*v_R17_a_r + 1.0*i_load_R17_a_i*v_R17_n_r + 1.0*i_load_R17_a_r*v_R17_a_i - 1.0*i_load_R17_a_r*v_R17_n_i - q_R17_1
        struct[0].g[358,0] = i_load_R17_a_r + i_load_R17_n_r
        struct[0].g[359,0] = 1.0*i_load_R17_a_i + 1.0*i_load_R17_n_i
        struct[0].g[360,0] = 1.0*i_load_R18_a_i*v_R18_a_i - 1.0*i_load_R18_a_i*v_R18_n_i + i_load_R18_a_r*v_R18_a_r - i_load_R18_a_r*v_R18_n_r - p_R18_1
        struct[0].g[361,0] = -1.0*i_load_R18_a_i*v_R18_a_r + 1.0*i_load_R18_a_i*v_R18_n_r + 1.0*i_load_R18_a_r*v_R18_a_i - 1.0*i_load_R18_a_r*v_R18_n_i - q_R18_1
        struct[0].g[362,0] = i_load_R18_a_r + i_load_R18_n_r
        struct[0].g[363,0] = 1.0*i_load_R18_a_i + 1.0*i_load_R18_n_i
        struct[0].g[364,0] = 1.0*i_load_D15_a_i*v_D15_a_i - 1.0*i_load_D15_a_i*v_D15_n_i + i_load_D15_a_r*v_D15_a_r - i_load_D15_a_r*v_D15_n_r - p_D15_1
        struct[0].g[365,0] = -1.0*i_load_D15_a_i*v_D15_a_r + 1.0*i_load_D15_a_i*v_D15_n_r + 1.0*i_load_D15_a_r*v_D15_a_i - 1.0*i_load_D15_a_r*v_D15_n_i - q_D15_1
        struct[0].g[366,0] = i_load_D15_a_r + i_load_D15_n_r
        struct[0].g[367,0] = 1.0*i_load_D15_a_i + 1.0*i_load_D15_n_i
        struct[0].g[368,0] = 1.0*i_load_D11_a_i*v_D11_a_i - 1.0*i_load_D11_a_i*v_D11_n_i + i_load_D11_a_r*v_D11_a_r - i_load_D11_a_r*v_D11_n_r - p_D11_1
        struct[0].g[369,0] = -1.0*i_load_D11_a_i*v_D11_a_r + 1.0*i_load_D11_a_i*v_D11_n_r + 1.0*i_load_D11_a_r*v_D11_a_i - 1.0*i_load_D11_a_r*v_D11_n_i - q_D11_1
        struct[0].g[370,0] = i_load_D11_a_r + i_load_D11_n_r
        struct[0].g[371,0] = 1.0*i_load_D11_a_i + 1.0*i_load_D11_n_i
        struct[0].g[372,0] = 1.0*i_load_D16_a_i*v_D16_a_i - 1.0*i_load_D16_a_i*v_D16_n_i + i_load_D16_a_r*v_D16_a_r - i_load_D16_a_r*v_D16_n_r - p_D16_1
        struct[0].g[373,0] = -1.0*i_load_D16_a_i*v_D16_a_r + 1.0*i_load_D16_a_i*v_D16_n_r + 1.0*i_load_D16_a_r*v_D16_a_i - 1.0*i_load_D16_a_r*v_D16_n_i - q_D16_1
        struct[0].g[374,0] = i_load_D16_a_r + i_load_D16_n_r
        struct[0].g[375,0] = 1.0*i_load_D16_a_i + 1.0*i_load_D16_n_i
        struct[0].g[376,0] = 1.0*i_load_D17_a_i*v_D17_a_i - 1.0*i_load_D17_a_i*v_D17_n_i + i_load_D17_a_r*v_D17_a_r - i_load_D17_a_r*v_D17_n_r - p_D17_1
        struct[0].g[377,0] = -1.0*i_load_D17_a_i*v_D17_a_r + 1.0*i_load_D17_a_i*v_D17_n_r + 1.0*i_load_D17_a_r*v_D17_a_i - 1.0*i_load_D17_a_r*v_D17_n_i - q_D17_1
        struct[0].g[378,0] = i_load_D17_a_r + i_load_D17_n_r
        struct[0].g[379,0] = 1.0*i_load_D17_a_i + 1.0*i_load_D17_n_i
        struct[0].g[380,0] = 1.0*i_load_D18_a_i*v_D18_a_i - 1.0*i_load_D18_a_i*v_D18_n_i + i_load_D18_a_r*v_D18_a_r - i_load_D18_a_r*v_D18_n_r - p_D18_1
        struct[0].g[381,0] = -1.0*i_load_D18_a_i*v_D18_a_r + 1.0*i_load_D18_a_i*v_D18_n_r + 1.0*i_load_D18_a_r*v_D18_a_i - 1.0*i_load_D18_a_r*v_D18_n_i - q_D18_1
        struct[0].g[382,0] = i_load_D18_a_r + i_load_D18_n_r
        struct[0].g[383,0] = 1.0*i_load_D18_a_i + 1.0*i_load_D18_n_i
        struct[0].g[384,0] = 1.0*i_vsc_R1_a_i*v_R1_a_i - 1.0*i_vsc_R1_a_i*v_R1_n_i + i_vsc_R1_a_r*v_R1_a_r - i_vsc_R1_a_r*v_R1_n_r - p_R1/3
        struct[0].g[385,0] = -1.0*i_vsc_R1_a_i*v_R1_a_r + 1.0*i_vsc_R1_a_i*v_R1_n_r + 1.0*i_vsc_R1_a_r*v_R1_a_i - 1.0*i_vsc_R1_a_r*v_R1_n_i - q_R1/3
        struct[0].g[386,0] = 1.0*i_vsc_R1_b_i*v_R1_b_i - 1.0*i_vsc_R1_b_i*v_R1_n_i + i_vsc_R1_b_r*v_R1_b_r - i_vsc_R1_b_r*v_R1_n_r - p_R1/3
        struct[0].g[387,0] = -1.0*i_vsc_R1_b_i*v_R1_b_r + 1.0*i_vsc_R1_b_i*v_R1_n_r + 1.0*i_vsc_R1_b_r*v_R1_b_i - 1.0*i_vsc_R1_b_r*v_R1_n_i - q_R1/3
        struct[0].g[388,0] = 1.0*i_vsc_R1_c_i*v_R1_c_i - 1.0*i_vsc_R1_c_i*v_R1_n_i + i_vsc_R1_c_r*v_R1_c_r - i_vsc_R1_c_r*v_R1_n_r - p_R1/3
        struct[0].g[389,0] = -1.0*i_vsc_R1_c_i*v_R1_c_r + 1.0*i_vsc_R1_c_i*v_R1_n_r + 1.0*i_vsc_R1_c_r*v_R1_c_i - 1.0*i_vsc_R1_c_r*v_R1_n_i - q_R1/3
        struct[0].g[390,0] = p_D1 + p_R1 + Piecewise(np.array([(-p_loss_R1, p_D1 < 0), (p_loss_R1, True)]))
        struct[0].g[391,0] = i_l_D1_D3_a_r*v_D1_a_r + i_l_D1_D3_n_r*v_D1_n_r - p_D1
        struct[0].g[392,0] = -a_R1 - b_R1*sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - c_R1*(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) + p_loss_R1
        struct[0].g[393,0] = -coef_a_R10*p_R10 + 1.0*i_vsc_R10_a_i*v_R10_a_i - 1.0*i_vsc_R10_a_i*v_R10_n_i + i_vsc_R10_a_r*v_R10_a_r - i_vsc_R10_a_r*v_R10_n_r
        struct[0].g[394,0] = -coef_a_R10*q_R10 - 1.0*i_vsc_R10_a_i*v_R10_a_r + 1.0*i_vsc_R10_a_i*v_R10_n_r + 1.0*i_vsc_R10_a_r*v_R10_a_i - 1.0*i_vsc_R10_a_r*v_R10_n_i
        struct[0].g[395,0] = -coef_b_R10*p_R10 + 1.0*i_vsc_R10_b_i*v_R10_b_i - 1.0*i_vsc_R10_b_i*v_R10_n_i + i_vsc_R10_b_r*v_R10_b_r - i_vsc_R10_b_r*v_R10_n_r
        struct[0].g[396,0] = -coef_b_R10*q_R10 - 1.0*i_vsc_R10_b_i*v_R10_b_r + 1.0*i_vsc_R10_b_i*v_R10_n_r + 1.0*i_vsc_R10_b_r*v_R10_b_i - 1.0*i_vsc_R10_b_r*v_R10_n_i
        struct[0].g[397,0] = -coef_c_R10*p_R10 + 1.0*i_vsc_R10_c_i*v_R10_c_i - 1.0*i_vsc_R10_c_i*v_R10_n_i + i_vsc_R10_c_r*v_R10_c_r - i_vsc_R10_c_r*v_R10_n_r
        struct[0].g[398,0] = -coef_c_R10*q_R10 - 1.0*i_vsc_R10_c_i*v_R10_c_r + 1.0*i_vsc_R10_c_i*v_R10_n_r + 1.0*i_vsc_R10_c_r*v_R10_c_i - 1.0*i_vsc_R10_c_r*v_R10_n_i
        struct[0].g[399,0] = i_vsc_R10_a_r + i_vsc_R10_b_r + i_vsc_R10_c_r + i_vsc_R10_n_r
        struct[0].g[400,0] = i_vsc_R10_a_i + i_vsc_R10_b_i + i_vsc_R10_c_i + i_vsc_R10_n_i
        struct[0].g[401,0] = i_vsc_D10_a_r + p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].g[402,0] = i_vsc_D10_n_r + p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].g[403,0] = p_D10 - p_R10 + Piecewise(np.array([(a_R10 + b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), p_D10 < 0), (-a_R10 - b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), p_D10 > 0), (a_R10 + b_R10*sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + c_R10*(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1), True)]))
        struct[0].g[404,0] = -coef_a_R14*p_R14 + 1.0*i_vsc_R14_a_i*v_R14_a_i - 1.0*i_vsc_R14_a_i*v_R14_n_i + i_vsc_R14_a_r*v_R14_a_r - i_vsc_R14_a_r*v_R14_n_r
        struct[0].g[405,0] = -coef_a_R14*q_R14 - 1.0*i_vsc_R14_a_i*v_R14_a_r + 1.0*i_vsc_R14_a_i*v_R14_n_r + 1.0*i_vsc_R14_a_r*v_R14_a_i - 1.0*i_vsc_R14_a_r*v_R14_n_i
        struct[0].g[406,0] = -coef_b_R14*p_R14 + 1.0*i_vsc_R14_b_i*v_R14_b_i - 1.0*i_vsc_R14_b_i*v_R14_n_i + i_vsc_R14_b_r*v_R14_b_r - i_vsc_R14_b_r*v_R14_n_r
        struct[0].g[407,0] = -coef_b_R14*q_R14 - 1.0*i_vsc_R14_b_i*v_R14_b_r + 1.0*i_vsc_R14_b_i*v_R14_n_r + 1.0*i_vsc_R14_b_r*v_R14_b_i - 1.0*i_vsc_R14_b_r*v_R14_n_i
        struct[0].g[408,0] = -coef_c_R14*p_R14 + 1.0*i_vsc_R14_c_i*v_R14_c_i - 1.0*i_vsc_R14_c_i*v_R14_n_i + i_vsc_R14_c_r*v_R14_c_r - i_vsc_R14_c_r*v_R14_n_r
        struct[0].g[409,0] = -coef_c_R14*q_R14 - 1.0*i_vsc_R14_c_i*v_R14_c_r + 1.0*i_vsc_R14_c_i*v_R14_n_r + 1.0*i_vsc_R14_c_r*v_R14_c_i - 1.0*i_vsc_R14_c_r*v_R14_n_i
        struct[0].g[410,0] = i_vsc_R14_a_r + i_vsc_R14_b_r + i_vsc_R14_c_r + i_vsc_R14_n_r
        struct[0].g[411,0] = i_vsc_R14_a_i + i_vsc_R14_b_i + i_vsc_R14_c_i + i_vsc_R14_n_i
        struct[0].g[412,0] = i_vsc_D14_a_r + p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].g[413,0] = i_vsc_D14_n_r + p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].g[414,0] = p_D14 - p_R14 + Piecewise(np.array([(a_R14 + b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), p_D14 < 0), (-a_R14 - b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), p_D14 > 0), (a_R14 + b_R14*sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + c_R14*(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1), True)]))
    
    # Outputs:
    if mode == 3:

        struct[0].h[0,0] = (v_R0_a_i**2 + v_R0_a_r**2)**0.5
        struct[0].h[1,0] = (v_R0_b_i**2 + v_R0_b_r**2)**0.5
        struct[0].h[2,0] = (v_R0_c_i**2 + v_R0_c_r**2)**0.5
        struct[0].h[3,0] = (v_D1_a_i**2 + v_D1_a_r**2)**0.5
        struct[0].h[4,0] = (v_D1_b_i**2 + v_D1_b_r**2)**0.5
        struct[0].h[5,0] = (v_D1_c_i**2 + v_D1_c_r**2)**0.5
        struct[0].h[6,0] = (v_R1_a_i**2 + v_R1_a_r**2)**0.5
        struct[0].h[7,0] = (v_R1_b_i**2 + v_R1_b_r**2)**0.5
        struct[0].h[8,0] = (v_R1_c_i**2 + v_R1_c_r**2)**0.5
        struct[0].h[9,0] = (v_R1_n_i**2 + v_R1_n_r**2)**0.5
        struct[0].h[10,0] = (v_R11_a_i**2 + v_R11_a_r**2)**0.5
        struct[0].h[11,0] = (v_R11_n_i**2 + v_R11_n_r**2)**0.5
        struct[0].h[12,0] = (v_R15_a_i**2 + v_R15_a_r**2)**0.5
        struct[0].h[13,0] = (v_R15_n_i**2 + v_R15_n_r**2)**0.5
        struct[0].h[14,0] = (v_R16_a_i**2 + v_R16_a_r**2)**0.5
        struct[0].h[15,0] = (v_R16_n_i**2 + v_R16_n_r**2)**0.5
        struct[0].h[16,0] = (v_R17_a_i**2 + v_R17_a_r**2)**0.5
        struct[0].h[17,0] = (v_R17_n_i**2 + v_R17_n_r**2)**0.5
        struct[0].h[18,0] = (v_R18_a_i**2 + v_R18_a_r**2)**0.5
        struct[0].h[19,0] = (v_R18_n_i**2 + v_R18_n_r**2)**0.5
        struct[0].h[20,0] = (v_D15_a_i**2 + v_D15_a_r**2)**0.5
        struct[0].h[21,0] = (v_D15_n_i**2 + v_D15_n_r**2)**0.5
        struct[0].h[22,0] = (v_D11_a_i**2 + v_D11_a_r**2)**0.5
        struct[0].h[23,0] = (v_D11_n_i**2 + v_D11_n_r**2)**0.5
        struct[0].h[24,0] = (v_D16_a_i**2 + v_D16_a_r**2)**0.5
        struct[0].h[25,0] = (v_D16_n_i**2 + v_D16_n_r**2)**0.5
        struct[0].h[26,0] = (v_D17_a_i**2 + v_D17_a_r**2)**0.5
        struct[0].h[27,0] = (v_D17_n_i**2 + v_D17_n_r**2)**0.5
        struct[0].h[28,0] = (v_D18_a_i**2 + v_D18_a_r**2)**0.5
        struct[0].h[29,0] = (v_D18_n_i**2 + v_D18_n_r**2)**0.5
        struct[0].h[30,0] = (v_R2_a_i**2 + v_R2_a_r**2)**0.5
        struct[0].h[31,0] = (v_R2_b_i**2 + v_R2_b_r**2)**0.5
        struct[0].h[32,0] = (v_R2_c_i**2 + v_R2_c_r**2)**0.5
        struct[0].h[33,0] = (v_R2_n_i**2 + v_R2_n_r**2)**0.5
        struct[0].h[34,0] = (v_R3_a_i**2 + v_R3_a_r**2)**0.5
        struct[0].h[35,0] = (v_R3_b_i**2 + v_R3_b_r**2)**0.5
        struct[0].h[36,0] = (v_R3_c_i**2 + v_R3_c_r**2)**0.5
        struct[0].h[37,0] = (v_R3_n_i**2 + v_R3_n_r**2)**0.5
        struct[0].h[38,0] = (v_R4_a_i**2 + v_R4_a_r**2)**0.5
        struct[0].h[39,0] = (v_R4_b_i**2 + v_R4_b_r**2)**0.5
        struct[0].h[40,0] = (v_R4_c_i**2 + v_R4_c_r**2)**0.5
        struct[0].h[41,0] = (v_R4_n_i**2 + v_R4_n_r**2)**0.5
        struct[0].h[42,0] = (v_R5_a_i**2 + v_R5_a_r**2)**0.5
        struct[0].h[43,0] = (v_R5_b_i**2 + v_R5_b_r**2)**0.5
        struct[0].h[44,0] = (v_R5_c_i**2 + v_R5_c_r**2)**0.5
        struct[0].h[45,0] = (v_R5_n_i**2 + v_R5_n_r**2)**0.5
        struct[0].h[46,0] = (v_R6_a_i**2 + v_R6_a_r**2)**0.5
        struct[0].h[47,0] = (v_R6_b_i**2 + v_R6_b_r**2)**0.5
        struct[0].h[48,0] = (v_R6_c_i**2 + v_R6_c_r**2)**0.5
        struct[0].h[49,0] = (v_R6_n_i**2 + v_R6_n_r**2)**0.5
        struct[0].h[50,0] = (v_R7_a_i**2 + v_R7_a_r**2)**0.5
        struct[0].h[51,0] = (v_R7_b_i**2 + v_R7_b_r**2)**0.5
        struct[0].h[52,0] = (v_R7_c_i**2 + v_R7_c_r**2)**0.5
        struct[0].h[53,0] = (v_R7_n_i**2 + v_R7_n_r**2)**0.5
        struct[0].h[54,0] = (v_R8_a_i**2 + v_R8_a_r**2)**0.5
        struct[0].h[55,0] = (v_R8_b_i**2 + v_R8_b_r**2)**0.5
        struct[0].h[56,0] = (v_R8_c_i**2 + v_R8_c_r**2)**0.5
        struct[0].h[57,0] = (v_R8_n_i**2 + v_R8_n_r**2)**0.5
        struct[0].h[58,0] = (v_R9_a_i**2 + v_R9_a_r**2)**0.5
        struct[0].h[59,0] = (v_R9_b_i**2 + v_R9_b_r**2)**0.5
        struct[0].h[60,0] = (v_R9_c_i**2 + v_R9_c_r**2)**0.5
        struct[0].h[61,0] = (v_R9_n_i**2 + v_R9_n_r**2)**0.5
        struct[0].h[62,0] = (v_R10_a_i**2 + v_R10_a_r**2)**0.5
        struct[0].h[63,0] = (v_R10_b_i**2 + v_R10_b_r**2)**0.5
        struct[0].h[64,0] = (v_R10_c_i**2 + v_R10_c_r**2)**0.5
        struct[0].h[65,0] = (v_R10_n_i**2 + v_R10_n_r**2)**0.5
        struct[0].h[66,0] = (v_R11_b_i**2 + v_R11_b_r**2)**0.5
        struct[0].h[67,0] = (v_R11_c_i**2 + v_R11_c_r**2)**0.5
        struct[0].h[68,0] = (v_R12_a_i**2 + v_R12_a_r**2)**0.5
        struct[0].h[69,0] = (v_R12_b_i**2 + v_R12_b_r**2)**0.5
        struct[0].h[70,0] = (v_R12_c_i**2 + v_R12_c_r**2)**0.5
        struct[0].h[71,0] = (v_R12_n_i**2 + v_R12_n_r**2)**0.5
        struct[0].h[72,0] = (v_R13_a_i**2 + v_R13_a_r**2)**0.5
        struct[0].h[73,0] = (v_R13_b_i**2 + v_R13_b_r**2)**0.5
        struct[0].h[74,0] = (v_R13_c_i**2 + v_R13_c_r**2)**0.5
        struct[0].h[75,0] = (v_R13_n_i**2 + v_R13_n_r**2)**0.5
        struct[0].h[76,0] = (v_R14_a_i**2 + v_R14_a_r**2)**0.5
        struct[0].h[77,0] = (v_R14_b_i**2 + v_R14_b_r**2)**0.5
        struct[0].h[78,0] = (v_R14_c_i**2 + v_R14_c_r**2)**0.5
        struct[0].h[79,0] = (v_R14_n_i**2 + v_R14_n_r**2)**0.5
        struct[0].h[80,0] = (v_R15_b_i**2 + v_R15_b_r**2)**0.5
        struct[0].h[81,0] = (v_R15_c_i**2 + v_R15_c_r**2)**0.5
        struct[0].h[82,0] = (v_R16_b_i**2 + v_R16_b_r**2)**0.5
        struct[0].h[83,0] = (v_R16_c_i**2 + v_R16_c_r**2)**0.5
        struct[0].h[84,0] = (v_R17_b_i**2 + v_R17_b_r**2)**0.5
        struct[0].h[85,0] = (v_R17_c_i**2 + v_R17_c_r**2)**0.5
        struct[0].h[86,0] = (v_R18_b_i**2 + v_R18_b_r**2)**0.5
        struct[0].h[87,0] = (v_R18_c_i**2 + v_R18_c_r**2)**0.5
        struct[0].h[88,0] = (v_D1_n_i**2 + v_D1_n_r**2)**0.5
        struct[0].h[89,0] = (v_D3_a_i**2 + v_D3_a_r**2)**0.5
        struct[0].h[90,0] = (v_D3_b_i**2 + v_D3_b_r**2)**0.5
        struct[0].h[91,0] = (v_D3_c_i**2 + v_D3_c_r**2)**0.5
        struct[0].h[92,0] = (v_D3_n_i**2 + v_D3_n_r**2)**0.5
        struct[0].h[93,0] = (v_D4_a_i**2 + v_D4_a_r**2)**0.5
        struct[0].h[94,0] = (v_D4_b_i**2 + v_D4_b_r**2)**0.5
        struct[0].h[95,0] = (v_D4_c_i**2 + v_D4_c_r**2)**0.5
        struct[0].h[96,0] = (v_D4_n_i**2 + v_D4_n_r**2)**0.5
        struct[0].h[97,0] = (v_D6_a_i**2 + v_D6_a_r**2)**0.5
        struct[0].h[98,0] = (v_D6_b_i**2 + v_D6_b_r**2)**0.5
        struct[0].h[99,0] = (v_D6_c_i**2 + v_D6_c_r**2)**0.5
        struct[0].h[100,0] = (v_D6_n_i**2 + v_D6_n_r**2)**0.5
        struct[0].h[101,0] = (v_D9_a_i**2 + v_D9_a_r**2)**0.5
        struct[0].h[102,0] = (v_D9_b_i**2 + v_D9_b_r**2)**0.5
        struct[0].h[103,0] = (v_D9_c_i**2 + v_D9_c_r**2)**0.5
        struct[0].h[104,0] = (v_D9_n_i**2 + v_D9_n_r**2)**0.5
        struct[0].h[105,0] = (v_D10_a_i**2 + v_D10_a_r**2)**0.5
        struct[0].h[106,0] = (v_D10_b_i**2 + v_D10_b_r**2)**0.5
        struct[0].h[107,0] = (v_D10_c_i**2 + v_D10_c_r**2)**0.5
        struct[0].h[108,0] = (v_D10_n_i**2 + v_D10_n_r**2)**0.5
        struct[0].h[109,0] = (v_D11_b_i**2 + v_D11_b_r**2)**0.5
        struct[0].h[110,0] = (v_D11_c_i**2 + v_D11_c_r**2)**0.5
        struct[0].h[111,0] = (v_D16_b_i**2 + v_D16_b_r**2)**0.5
        struct[0].h[112,0] = (v_D16_c_i**2 + v_D16_c_r**2)**0.5
        struct[0].h[113,0] = (v_D17_b_i**2 + v_D17_b_r**2)**0.5
        struct[0].h[114,0] = (v_D17_c_i**2 + v_D17_c_r**2)**0.5
        struct[0].h[115,0] = (v_D18_b_i**2 + v_D18_b_r**2)**0.5
        struct[0].h[116,0] = (v_D18_c_i**2 + v_D18_c_r**2)**0.5
        struct[0].h[117,0] = (v_D14_a_i**2 + v_D14_a_r**2)**0.5
        struct[0].h[118,0] = (v_D14_b_i**2 + v_D14_b_r**2)**0.5
        struct[0].h[119,0] = (v_D14_c_i**2 + v_D14_c_r**2)**0.5
        struct[0].h[120,0] = (v_D14_n_i**2 + v_D14_n_r**2)**0.5
        struct[0].h[121,0] = (v_D15_b_i**2 + v_D15_b_r**2)**0.5
        struct[0].h[122,0] = (v_D15_c_i**2 + v_D15_c_r**2)**0.5
    

    if mode == 10:

        struct[0].Fx[0,0] = -1

    if mode == 11:


        struct[0].Gy[0,0] = -123.954122254357
        struct[0].Gy[0,1] = -127.595184532966
        struct[0].Gy[0,2] = 39.6392229058202
        struct[0].Gy[0,3] = 10.2713736253513
        struct[0].Gy[0,4] = 24.9575997948692
        struct[0].Gy[0,5] = 23.2849644809540
        struct[0].Gy[0,6] = 58.0215758469966
        struct[0].Gy[0,7] = 83.8007853900572
        struct[0].Gy[0,48] = 105.571769313180
        struct[0].Gy[0,49] = 54.0657727682604
        struct[0].Gy[0,50] = -39.6392229058202
        struct[0].Gy[0,51] = -10.2713736253513
        struct[0].Gy[0,52] = -24.9575997948692
        struct[0].Gy[0,53] = -23.2849644809540
        struct[0].Gy[0,54] = -39.6392229058202
        struct[0].Gy[0,55] = -10.2713736253513
        struct[0].Gy[0,336] = 1
        struct[0].Gy[0,384] = 1
        struct[0].Gy[1,0] = 127.595184532966
        struct[0].Gy[1,1] = -123.954122254357
        struct[0].Gy[1,2] = -10.2713736253513
        struct[0].Gy[1,3] = 39.6392229058202
        struct[0].Gy[1,4] = -23.2849644809540
        struct[0].Gy[1,5] = 24.9575997948692
        struct[0].Gy[1,6] = -83.8007853900572
        struct[0].Gy[1,7] = 58.0215758469966
        struct[0].Gy[1,48] = -54.0657727682604
        struct[0].Gy[1,49] = 105.571769313180
        struct[0].Gy[1,50] = 10.2713736253513
        struct[0].Gy[1,51] = -39.6392229058202
        struct[0].Gy[1,52] = 23.2849644809540
        struct[0].Gy[1,53] = -24.9575997948692
        struct[0].Gy[1,54] = 10.2713736253513
        struct[0].Gy[1,55] = -39.6392229058202
        struct[0].Gy[1,337] = 1
        struct[0].Gy[1,385] = 1
        struct[0].Gy[2,0] = 39.6392229058202
        struct[0].Gy[2,1] = 10.2713736253513
        struct[0].Gy[2,2] = -123.954122254357
        struct[0].Gy[2,3] = -127.595184532966
        struct[0].Gy[2,4] = 39.6392229058201
        struct[0].Gy[2,5] = 10.2713736253513
        struct[0].Gy[2,6] = 43.3399527360457
        struct[0].Gy[2,7] = 96.8143762456598
        struct[0].Gy[2,48] = -39.6392229058202
        struct[0].Gy[2,49] = -10.2713736253513
        struct[0].Gy[2,50] = 105.571769313180
        struct[0].Gy[2,51] = 54.0657727682604
        struct[0].Gy[2,52] = -39.6392229058201
        struct[0].Gy[2,53] = -10.2713736253513
        struct[0].Gy[2,54] = -24.9575997948692
        struct[0].Gy[2,55] = -23.2849644809540
        struct[0].Gy[2,338] = 1
        struct[0].Gy[2,386] = 1
        struct[0].Gy[3,0] = -10.2713736253513
        struct[0].Gy[3,1] = 39.6392229058202
        struct[0].Gy[3,2] = 127.595184532966
        struct[0].Gy[3,3] = -123.954122254357
        struct[0].Gy[3,4] = -10.2713736253513
        struct[0].Gy[3,5] = 39.6392229058201
        struct[0].Gy[3,6] = -96.8143762456598
        struct[0].Gy[3,7] = 43.3399527360457
        struct[0].Gy[3,48] = 10.2713736253513
        struct[0].Gy[3,49] = -39.6392229058202
        struct[0].Gy[3,50] = -54.0657727682604
        struct[0].Gy[3,51] = 105.571769313180
        struct[0].Gy[3,52] = 10.2713736253513
        struct[0].Gy[3,53] = -39.6392229058201
        struct[0].Gy[3,54] = 23.2849644809540
        struct[0].Gy[3,55] = -24.9575997948692
        struct[0].Gy[3,339] = 1
        struct[0].Gy[3,387] = 1
        struct[0].Gy[4,0] = 24.9575997948692
        struct[0].Gy[4,1] = 23.2849644809540
        struct[0].Gy[4,2] = 39.6392229058202
        struct[0].Gy[4,3] = 10.2713736253513
        struct[0].Gy[4,4] = -123.954122254357
        struct[0].Gy[4,5] = -127.595184532966
        struct[0].Gy[4,6] = 58.0215758469966
        struct[0].Gy[4,7] = 83.8007853900572
        struct[0].Gy[4,48] = -24.9575997948692
        struct[0].Gy[4,49] = -23.2849644809540
        struct[0].Gy[4,50] = -39.6392229058202
        struct[0].Gy[4,51] = -10.2713736253513
        struct[0].Gy[4,52] = 105.571769313180
        struct[0].Gy[4,53] = 54.0657727682604
        struct[0].Gy[4,54] = -39.6392229058201
        struct[0].Gy[4,55] = -10.2713736253514
        struct[0].Gy[4,340] = 1
        struct[0].Gy[4,388] = 1
        struct[0].Gy[5,0] = -23.2849644809540
        struct[0].Gy[5,1] = 24.9575997948692
        struct[0].Gy[5,2] = -10.2713736253513
        struct[0].Gy[5,3] = 39.6392229058202
        struct[0].Gy[5,4] = 127.595184532966
        struct[0].Gy[5,5] = -123.954122254357
        struct[0].Gy[5,6] = -83.8007853900572
        struct[0].Gy[5,7] = 58.0215758469966
        struct[0].Gy[5,48] = 23.2849644809540
        struct[0].Gy[5,49] = -24.9575997948692
        struct[0].Gy[5,50] = 10.2713736253513
        struct[0].Gy[5,51] = -39.6392229058202
        struct[0].Gy[5,52] = -54.0657727682604
        struct[0].Gy[5,53] = 105.571769313180
        struct[0].Gy[5,54] = 10.2713736253514
        struct[0].Gy[5,55] = -39.6392229058201
        struct[0].Gy[5,341] = 1
        struct[0].Gy[5,389] = 1
        struct[0].Gy[6,0] = 58.0215758469966
        struct[0].Gy[6,1] = 83.8007853900572
        struct[0].Gy[6,2] = 43.3399527360457
        struct[0].Gy[6,3] = 96.8143762456598
        struct[0].Gy[6,4] = 58.0215758469966
        struct[0].Gy[6,5] = 83.8007853900572
        struct[0].Gy[6,6] = -161.052161470043
        struct[0].Gy[6,7] = -274.654008062378
        struct[0].Gy[6,48] = -39.6392229058202
        struct[0].Gy[6,49] = -10.2713736253513
        struct[0].Gy[6,50] = -24.9575997948692
        struct[0].Gy[6,51] = -23.2849644809540
        struct[0].Gy[6,52] = -39.6392229058202
        struct[0].Gy[6,53] = -10.2713736253513
        struct[0].Gy[6,54] = 105.571769313180
        struct[0].Gy[6,55] = 54.0657727682604
        struct[0].Gy[7,0] = -83.8007853900572
        struct[0].Gy[7,1] = 58.0215758469966
        struct[0].Gy[7,2] = -96.8143762456598
        struct[0].Gy[7,3] = 43.3399527360457
        struct[0].Gy[7,4] = -83.8007853900572
        struct[0].Gy[7,5] = 58.0215758469966
        struct[0].Gy[7,6] = 274.654008062378
        struct[0].Gy[7,7] = -161.052161470043
        struct[0].Gy[7,48] = 10.2713736253513
        struct[0].Gy[7,49] = -39.6392229058202
        struct[0].Gy[7,50] = 23.2849644809540
        struct[0].Gy[7,51] = -24.9575997948692
        struct[0].Gy[7,52] = 10.2713736253513
        struct[0].Gy[7,53] = -39.6392229058202
        struct[0].Gy[7,54] = -54.0657727682604
        struct[0].Gy[7,55] = 105.571769313180
        struct[0].Gy[8,8] = -26.5300693004806
        struct[0].Gy[8,9] = -4.84676915585801
        struct[0].Gy[8,10] = 7.89461337514771
        struct[0].Gy[8,11] = -1.58482814504483
        struct[0].Gy[8,56] = 26.5300693004806
        struct[0].Gy[8,57] = 4.84676915585801
        struct[0].Gy[8,58] = -7.89461337514770
        struct[0].Gy[8,59] = 1.58482814504483
        struct[0].Gy[8,60] = -7.72144347466701
        struct[0].Gy[8,61] = 0.679918453285310
        struct[0].Gy[8,62] = -7.89461337514771
        struct[0].Gy[8,63] = 1.58482814504483
        struct[0].Gy[8,120] = 7.89461337514770
        struct[0].Gy[8,121] = -1.58482814504483
        struct[0].Gy[8,122] = 7.72144347466701
        struct[0].Gy[8,123] = -0.679918453285310
        struct[0].Gy[8,344] = 1
        struct[0].Gy[9,8] = 4.84676915585801
        struct[0].Gy[9,9] = -26.5300693004806
        struct[0].Gy[9,10] = 1.58482814504483
        struct[0].Gy[9,11] = 7.89461337514771
        struct[0].Gy[9,56] = -4.84676915585801
        struct[0].Gy[9,57] = 26.5300693004806
        struct[0].Gy[9,58] = -1.58482814504483
        struct[0].Gy[9,59] = -7.89461337514770
        struct[0].Gy[9,60] = -0.679918453285310
        struct[0].Gy[9,61] = -7.72144347466701
        struct[0].Gy[9,62] = -1.58482814504483
        struct[0].Gy[9,63] = -7.89461337514771
        struct[0].Gy[9,120] = 1.58482814504483
        struct[0].Gy[9,121] = 7.89461337514770
        struct[0].Gy[9,122] = 0.679918453285310
        struct[0].Gy[9,123] = 7.72144347466701
        struct[0].Gy[9,345] = 1
        struct[0].Gy[10,8] = 7.89461337514771
        struct[0].Gy[10,9] = -1.58482814504483
        struct[0].Gy[10,10] = -26.5550693004806
        struct[0].Gy[10,11] = -4.84676915585801
        struct[0].Gy[10,56] = -7.89461337514771
        struct[0].Gy[10,57] = 1.58482814504483
        struct[0].Gy[10,58] = -7.72144347466701
        struct[0].Gy[10,59] = 0.679918453285308
        struct[0].Gy[10,60] = -7.89461337514771
        struct[0].Gy[10,61] = 1.58482814504483
        struct[0].Gy[10,62] = 26.5300693004806
        struct[0].Gy[10,63] = 4.84676915585801
        struct[0].Gy[10,120] = 7.72144347466701
        struct[0].Gy[10,121] = -0.679918453285308
        struct[0].Gy[10,122] = 7.89461337514771
        struct[0].Gy[10,123] = -1.58482814504483
        struct[0].Gy[10,346] = 1
        struct[0].Gy[11,8] = 1.58482814504483
        struct[0].Gy[11,9] = 7.89461337514771
        struct[0].Gy[11,10] = 4.84676915585801
        struct[0].Gy[11,11] = -26.5550693004806
        struct[0].Gy[11,56] = -1.58482814504483
        struct[0].Gy[11,57] = -7.89461337514771
        struct[0].Gy[11,58] = -0.679918453285308
        struct[0].Gy[11,59] = -7.72144347466701
        struct[0].Gy[11,60] = -1.58482814504483
        struct[0].Gy[11,61] = -7.89461337514771
        struct[0].Gy[11,62] = -4.84676915585801
        struct[0].Gy[11,63] = 26.5300693004806
        struct[0].Gy[11,120] = 0.679918453285308
        struct[0].Gy[11,121] = 7.72144347466701
        struct[0].Gy[11,122] = 1.58482814504483
        struct[0].Gy[11,123] = 7.89461337514771
        struct[0].Gy[11,347] = 1
        struct[0].Gy[12,12] = -26.5300693004806
        struct[0].Gy[12,13] = -4.84676915585801
        struct[0].Gy[12,14] = 7.89461337514771
        struct[0].Gy[12,15] = -1.58482814504483
        struct[0].Gy[12,140] = 26.5300693004806
        struct[0].Gy[12,141] = 4.84676915585801
        struct[0].Gy[12,142] = -7.89461337514770
        struct[0].Gy[12,143] = 1.58482814504483
        struct[0].Gy[12,144] = -7.72144347466701
        struct[0].Gy[12,145] = 0.679918453285310
        struct[0].Gy[12,146] = -7.89461337514771
        struct[0].Gy[12,147] = 1.58482814504483
        struct[0].Gy[12,148] = 7.89461337514770
        struct[0].Gy[12,149] = -1.58482814504483
        struct[0].Gy[12,150] = 7.72144347466701
        struct[0].Gy[12,151] = -0.679918453285310
        struct[0].Gy[12,348] = 1
        struct[0].Gy[13,12] = 4.84676915585801
        struct[0].Gy[13,13] = -26.5300693004806
        struct[0].Gy[13,14] = 1.58482814504483
        struct[0].Gy[13,15] = 7.89461337514771
        struct[0].Gy[13,140] = -4.84676915585801
        struct[0].Gy[13,141] = 26.5300693004806
        struct[0].Gy[13,142] = -1.58482814504483
        struct[0].Gy[13,143] = -7.89461337514770
        struct[0].Gy[13,144] = -0.679918453285310
        struct[0].Gy[13,145] = -7.72144347466701
        struct[0].Gy[13,146] = -1.58482814504483
        struct[0].Gy[13,147] = -7.89461337514771
        struct[0].Gy[13,148] = 1.58482814504483
        struct[0].Gy[13,149] = 7.89461337514770
        struct[0].Gy[13,150] = 0.679918453285310
        struct[0].Gy[13,151] = 7.72144347466701
        struct[0].Gy[13,349] = 1
        struct[0].Gy[14,12] = 7.89461337514771
        struct[0].Gy[14,13] = -1.58482814504483
        struct[0].Gy[14,14] = -26.5550693004806
        struct[0].Gy[14,15] = -4.84676915585801
        struct[0].Gy[14,140] = -7.89461337514771
        struct[0].Gy[14,141] = 1.58482814504483
        struct[0].Gy[14,142] = -7.72144347466701
        struct[0].Gy[14,143] = 0.679918453285308
        struct[0].Gy[14,144] = -7.89461337514771
        struct[0].Gy[14,145] = 1.58482814504483
        struct[0].Gy[14,146] = 26.5300693004806
        struct[0].Gy[14,147] = 4.84676915585801
        struct[0].Gy[14,148] = 7.72144347466701
        struct[0].Gy[14,149] = -0.679918453285308
        struct[0].Gy[14,150] = 7.89461337514771
        struct[0].Gy[14,151] = -1.58482814504483
        struct[0].Gy[14,350] = 1
        struct[0].Gy[15,12] = 1.58482814504483
        struct[0].Gy[15,13] = 7.89461337514771
        struct[0].Gy[15,14] = 4.84676915585801
        struct[0].Gy[15,15] = -26.5550693004806
        struct[0].Gy[15,140] = -1.58482814504483
        struct[0].Gy[15,141] = -7.89461337514771
        struct[0].Gy[15,142] = -0.679918453285308
        struct[0].Gy[15,143] = -7.72144347466701
        struct[0].Gy[15,144] = -1.58482814504483
        struct[0].Gy[15,145] = -7.89461337514771
        struct[0].Gy[15,146] = -4.84676915585801
        struct[0].Gy[15,147] = 26.5300693004806
        struct[0].Gy[15,148] = 0.679918453285308
        struct[0].Gy[15,149] = 7.72144347466701
        struct[0].Gy[15,150] = 1.58482814504483
        struct[0].Gy[15,151] = 7.89461337514771
        struct[0].Gy[15,351] = 1
        struct[0].Gy[16,16] = -30.9517475172273
        struct[0].Gy[16,17] = -5.65456401516768
        struct[0].Gy[16,18] = 9.21038227100566
        struct[0].Gy[16,19] = -1.84896616921897
        struct[0].Gy[16,80] = 30.9517475172273
        struct[0].Gy[16,81] = 5.65456401516768
        struct[0].Gy[16,82] = -9.21038227100566
        struct[0].Gy[16,83] = 1.84896616921897
        struct[0].Gy[16,84] = -9.00835072044485
        struct[0].Gy[16,85] = 0.793238195499529
        struct[0].Gy[16,86] = -9.21038227100566
        struct[0].Gy[16,87] = 1.84896616921897
        struct[0].Gy[16,152] = 9.21038227100566
        struct[0].Gy[16,153] = -1.84896616921897
        struct[0].Gy[16,154] = 9.00835072044485
        struct[0].Gy[16,155] = -0.793238195499529
        struct[0].Gy[16,352] = 1
        struct[0].Gy[17,16] = 5.65456401516768
        struct[0].Gy[17,17] = -30.9517475172273
        struct[0].Gy[17,18] = 1.84896616921897
        struct[0].Gy[17,19] = 9.21038227100566
        struct[0].Gy[17,80] = -5.65456401516768
        struct[0].Gy[17,81] = 30.9517475172273
        struct[0].Gy[17,82] = -1.84896616921897
        struct[0].Gy[17,83] = -9.21038227100566
        struct[0].Gy[17,84] = -0.793238195499529
        struct[0].Gy[17,85] = -9.00835072044485
        struct[0].Gy[17,86] = -1.84896616921897
        struct[0].Gy[17,87] = -9.21038227100566
        struct[0].Gy[17,152] = 1.84896616921897
        struct[0].Gy[17,153] = 9.21038227100566
        struct[0].Gy[17,154] = 0.793238195499529
        struct[0].Gy[17,155] = 9.00835072044485
        struct[0].Gy[17,353] = 1
        struct[0].Gy[18,16] = 9.21038227100566
        struct[0].Gy[18,17] = -1.84896616921897
        struct[0].Gy[18,18] = -30.9767475172273
        struct[0].Gy[18,19] = -5.65456401516768
        struct[0].Gy[18,80] = -9.21038227100566
        struct[0].Gy[18,81] = 1.84896616921897
        struct[0].Gy[18,82] = -9.00835072044485
        struct[0].Gy[18,83] = 0.793238195499527
        struct[0].Gy[18,84] = -9.21038227100566
        struct[0].Gy[18,85] = 1.84896616921897
        struct[0].Gy[18,86] = 30.9517475172273
        struct[0].Gy[18,87] = 5.65456401516768
        struct[0].Gy[18,152] = 9.00835072044485
        struct[0].Gy[18,153] = -0.793238195499527
        struct[0].Gy[18,154] = 9.21038227100566
        struct[0].Gy[18,155] = -1.84896616921897
        struct[0].Gy[18,354] = 1
        struct[0].Gy[19,16] = 1.84896616921897
        struct[0].Gy[19,17] = 9.21038227100566
        struct[0].Gy[19,18] = 5.65456401516768
        struct[0].Gy[19,19] = -30.9767475172273
        struct[0].Gy[19,80] = -1.84896616921897
        struct[0].Gy[19,81] = -9.21038227100566
        struct[0].Gy[19,82] = -0.793238195499527
        struct[0].Gy[19,83] = -9.00835072044485
        struct[0].Gy[19,84] = -1.84896616921897
        struct[0].Gy[19,85] = -9.21038227100566
        struct[0].Gy[19,86] = -5.65456401516768
        struct[0].Gy[19,87] = 30.9517475172273
        struct[0].Gy[19,152] = 0.793238195499527
        struct[0].Gy[19,153] = 9.00835072044485
        struct[0].Gy[19,154] = 1.84896616921897
        struct[0].Gy[19,155] = 9.21038227100566
        struct[0].Gy[19,355] = 1
        struct[0].Gy[20,20] = -30.9517475172273
        struct[0].Gy[20,21] = -5.65456401516768
        struct[0].Gy[20,22] = 9.21038227100566
        struct[0].Gy[20,23] = -1.84896616921897
        struct[0].Gy[20,104] = 30.9517475172273
        struct[0].Gy[20,105] = 5.65456401516768
        struct[0].Gy[20,106] = -9.21038227100566
        struct[0].Gy[20,107] = 1.84896616921897
        struct[0].Gy[20,108] = -9.00835072044485
        struct[0].Gy[20,109] = 0.793238195499529
        struct[0].Gy[20,110] = -9.21038227100566
        struct[0].Gy[20,111] = 1.84896616921897
        struct[0].Gy[20,156] = 9.21038227100566
        struct[0].Gy[20,157] = -1.84896616921897
        struct[0].Gy[20,158] = 9.00835072044485
        struct[0].Gy[20,159] = -0.793238195499529
        struct[0].Gy[20,356] = 1
        struct[0].Gy[21,20] = 5.65456401516768
        struct[0].Gy[21,21] = -30.9517475172273
        struct[0].Gy[21,22] = 1.84896616921897
        struct[0].Gy[21,23] = 9.21038227100566
        struct[0].Gy[21,104] = -5.65456401516768
        struct[0].Gy[21,105] = 30.9517475172273
        struct[0].Gy[21,106] = -1.84896616921897
        struct[0].Gy[21,107] = -9.21038227100566
        struct[0].Gy[21,108] = -0.793238195499529
        struct[0].Gy[21,109] = -9.00835072044485
        struct[0].Gy[21,110] = -1.84896616921897
        struct[0].Gy[21,111] = -9.21038227100566
        struct[0].Gy[21,156] = 1.84896616921897
        struct[0].Gy[21,157] = 9.21038227100566
        struct[0].Gy[21,158] = 0.793238195499529
        struct[0].Gy[21,159] = 9.00835072044485
        struct[0].Gy[21,357] = 1
        struct[0].Gy[22,20] = 9.21038227100566
        struct[0].Gy[22,21] = -1.84896616921897
        struct[0].Gy[22,22] = -30.9767475172273
        struct[0].Gy[22,23] = -5.65456401516768
        struct[0].Gy[22,104] = -9.21038227100566
        struct[0].Gy[22,105] = 1.84896616921897
        struct[0].Gy[22,106] = -9.00835072044485
        struct[0].Gy[22,107] = 0.793238195499527
        struct[0].Gy[22,108] = -9.21038227100566
        struct[0].Gy[22,109] = 1.84896616921897
        struct[0].Gy[22,110] = 30.9517475172273
        struct[0].Gy[22,111] = 5.65456401516768
        struct[0].Gy[22,156] = 9.00835072044485
        struct[0].Gy[22,157] = -0.793238195499527
        struct[0].Gy[22,158] = 9.21038227100566
        struct[0].Gy[22,159] = -1.84896616921897
        struct[0].Gy[22,358] = 1
        struct[0].Gy[23,20] = 1.84896616921897
        struct[0].Gy[23,21] = 9.21038227100566
        struct[0].Gy[23,22] = 5.65456401516768
        struct[0].Gy[23,23] = -30.9767475172273
        struct[0].Gy[23,104] = -1.84896616921897
        struct[0].Gy[23,105] = -9.21038227100566
        struct[0].Gy[23,106] = -0.793238195499527
        struct[0].Gy[23,107] = -9.00835072044485
        struct[0].Gy[23,108] = -1.84896616921897
        struct[0].Gy[23,109] = -9.21038227100566
        struct[0].Gy[23,110] = -5.65456401516768
        struct[0].Gy[23,111] = 30.9517475172273
        struct[0].Gy[23,156] = 0.793238195499527
        struct[0].Gy[23,157] = 9.00835072044485
        struct[0].Gy[23,158] = 1.84896616921897
        struct[0].Gy[23,159] = 9.21038227100566
        struct[0].Gy[23,359] = 1
        struct[0].Gy[24,24] = -30.9517475172273
        struct[0].Gy[24,25] = -5.65456401516768
        struct[0].Gy[24,26] = 9.21038227100566
        struct[0].Gy[24,27] = -1.84896616921897
        struct[0].Gy[24,112] = 30.9517475172273
        struct[0].Gy[24,113] = 5.65456401516768
        struct[0].Gy[24,114] = -9.21038227100566
        struct[0].Gy[24,115] = 1.84896616921897
        struct[0].Gy[24,116] = -9.00835072044485
        struct[0].Gy[24,117] = 0.793238195499529
        struct[0].Gy[24,118] = -9.21038227100566
        struct[0].Gy[24,119] = 1.84896616921897
        struct[0].Gy[24,160] = 9.21038227100566
        struct[0].Gy[24,161] = -1.84896616921897
        struct[0].Gy[24,162] = 9.00835072044485
        struct[0].Gy[24,163] = -0.793238195499529
        struct[0].Gy[24,360] = 1
        struct[0].Gy[25,24] = 5.65456401516768
        struct[0].Gy[25,25] = -30.9517475172273
        struct[0].Gy[25,26] = 1.84896616921897
        struct[0].Gy[25,27] = 9.21038227100566
        struct[0].Gy[25,112] = -5.65456401516768
        struct[0].Gy[25,113] = 30.9517475172273
        struct[0].Gy[25,114] = -1.84896616921897
        struct[0].Gy[25,115] = -9.21038227100566
        struct[0].Gy[25,116] = -0.793238195499529
        struct[0].Gy[25,117] = -9.00835072044485
        struct[0].Gy[25,118] = -1.84896616921897
        struct[0].Gy[25,119] = -9.21038227100566
        struct[0].Gy[25,160] = 1.84896616921897
        struct[0].Gy[25,161] = 9.21038227100566
        struct[0].Gy[25,162] = 0.793238195499529
        struct[0].Gy[25,163] = 9.00835072044485
        struct[0].Gy[25,361] = 1
        struct[0].Gy[26,24] = 9.21038227100566
        struct[0].Gy[26,25] = -1.84896616921897
        struct[0].Gy[26,26] = -30.9767475172273
        struct[0].Gy[26,27] = -5.65456401516768
        struct[0].Gy[26,112] = -9.21038227100566
        struct[0].Gy[26,113] = 1.84896616921897
        struct[0].Gy[26,114] = -9.00835072044485
        struct[0].Gy[26,115] = 0.793238195499527
        struct[0].Gy[26,116] = -9.21038227100566
        struct[0].Gy[26,117] = 1.84896616921897
        struct[0].Gy[26,118] = 30.9517475172273
        struct[0].Gy[26,119] = 5.65456401516768
        struct[0].Gy[26,160] = 9.00835072044485
        struct[0].Gy[26,161] = -0.793238195499527
        struct[0].Gy[26,162] = 9.21038227100566
        struct[0].Gy[26,163] = -1.84896616921897
        struct[0].Gy[26,362] = 1
        struct[0].Gy[27,24] = 1.84896616921897
        struct[0].Gy[27,25] = 9.21038227100566
        struct[0].Gy[27,26] = 5.65456401516768
        struct[0].Gy[27,27] = -30.9767475172273
        struct[0].Gy[27,112] = -1.84896616921897
        struct[0].Gy[27,113] = -9.21038227100566
        struct[0].Gy[27,114] = -0.793238195499527
        struct[0].Gy[27,115] = -9.00835072044485
        struct[0].Gy[27,116] = -1.84896616921897
        struct[0].Gy[27,117] = -9.21038227100566
        struct[0].Gy[27,118] = -5.65456401516768
        struct[0].Gy[27,119] = 30.9517475172273
        struct[0].Gy[27,160] = 0.793238195499527
        struct[0].Gy[27,161] = 9.00835072044485
        struct[0].Gy[27,162] = 1.84896616921897
        struct[0].Gy[27,163] = 9.21038227100566
        struct[0].Gy[27,363] = 1
        struct[0].Gy[28,28] = -135.409614082600
        struct[0].Gy[28,222] = 135.409614082600
        struct[0].Gy[28,364] = 1
        struct[0].Gy[29,29] = -135.409614082600
        struct[0].Gy[29,223] = 135.409614082600
        struct[0].Gy[29,365] = 1
        struct[0].Gy[30,30] = -135.409614082600
        struct[0].Gy[30,228] = 135.409614082600
        struct[0].Gy[30,366] = 1
        struct[0].Gy[31,31] = -135.409614082600
        struct[0].Gy[31,229] = 135.409614082600
        struct[0].Gy[31,367] = 1
        struct[0].Gy[32,32] = -157.977883096366
        struct[0].Gy[32,166] = 157.977883096366
        struct[0].Gy[32,368] = 1
        struct[0].Gy[33,33] = -157.977883096366
        struct[0].Gy[33,167] = 157.977883096366
        struct[0].Gy[33,369] = 1
        struct[0].Gy[34,34] = -157.977883096366
        struct[0].Gy[34,172] = 157.977883096366
        struct[0].Gy[34,370] = 1
        struct[0].Gy[35,35] = -157.977883096366
        struct[0].Gy[35,173] = 157.977883096366
        struct[0].Gy[35,371] = 1
        struct[0].Gy[36,36] = -157.977883096366
        struct[0].Gy[36,182] = 157.977883096366
        struct[0].Gy[36,372] = 1
        struct[0].Gy[37,37] = -157.977883096366
        struct[0].Gy[37,183] = 157.977883096366
        struct[0].Gy[37,373] = 1
        struct[0].Gy[38,38] = -157.977883096366
        struct[0].Gy[38,188] = 157.977883096366
        struct[0].Gy[38,374] = 1
        struct[0].Gy[39,39] = -157.977883096366
        struct[0].Gy[39,189] = 157.977883096366
        struct[0].Gy[39,375] = 1
        struct[0].Gy[40,40] = -157.977883096366
        struct[0].Gy[40,190] = 157.977883096366
        struct[0].Gy[40,376] = 1
        struct[0].Gy[41,41] = -157.977883096366
        struct[0].Gy[41,191] = 157.977883096366
        struct[0].Gy[41,377] = 1
        struct[0].Gy[42,42] = -157.977883096366
        struct[0].Gy[42,196] = 157.977883096366
        struct[0].Gy[42,378] = 1
        struct[0].Gy[43,43] = -157.977883096366
        struct[0].Gy[43,197] = 157.977883096366
        struct[0].Gy[43,379] = 1
        struct[0].Gy[44,44] = -157.977883096366
        struct[0].Gy[44,198] = 157.977883096366
        struct[0].Gy[44,380] = 1
        struct[0].Gy[45,45] = -157.977883096366
        struct[0].Gy[45,199] = 157.977883096366
        struct[0].Gy[45,381] = 1
        struct[0].Gy[46,46] = -157.977883096366
        struct[0].Gy[46,204] = 157.977883096366
        struct[0].Gy[46,382] = 1
        struct[0].Gy[47,47] = -157.977883096366
        struct[0].Gy[47,205] = 157.977883096366
        struct[0].Gy[47,383] = 1
        struct[0].Gy[48,0] = 105.571769313180
        struct[0].Gy[48,1] = 54.0657727682604
        struct[0].Gy[48,2] = -39.6392229058202
        struct[0].Gy[48,3] = -10.2713736253513
        struct[0].Gy[48,4] = -24.9575997948692
        struct[0].Gy[48,5] = -23.2849644809540
        struct[0].Gy[48,6] = -39.6392229058202
        struct[0].Gy[48,7] = -10.2713736253513
        struct[0].Gy[48,48] = -211.143538626360
        struct[0].Gy[48,49] = -108.131545536521
        struct[0].Gy[48,50] = 79.2784458116403
        struct[0].Gy[48,51] = 20.5427472507027
        struct[0].Gy[48,52] = 49.9151995897384
        struct[0].Gy[48,53] = 46.5699289619080
        struct[0].Gy[48,54] = 79.2784458116403
        struct[0].Gy[48,55] = 20.5427472507027
        struct[0].Gy[48,56] = 105.571769313180
        struct[0].Gy[48,57] = 54.0657727682604
        struct[0].Gy[48,58] = -39.6392229058202
        struct[0].Gy[48,59] = -10.2713736253513
        struct[0].Gy[48,60] = -24.9575997948692
        struct[0].Gy[48,61] = -23.2849644809540
        struct[0].Gy[48,62] = -39.6392229058202
        struct[0].Gy[48,63] = -10.2713736253513
        struct[0].Gy[49,0] = -54.0657727682604
        struct[0].Gy[49,1] = 105.571769313180
        struct[0].Gy[49,2] = 10.2713736253513
        struct[0].Gy[49,3] = -39.6392229058202
        struct[0].Gy[49,4] = 23.2849644809540
        struct[0].Gy[49,5] = -24.9575997948692
        struct[0].Gy[49,6] = 10.2713736253513
        struct[0].Gy[49,7] = -39.6392229058202
        struct[0].Gy[49,48] = 108.131545536521
        struct[0].Gy[49,49] = -211.143538626360
        struct[0].Gy[49,50] = -20.5427472507027
        struct[0].Gy[49,51] = 79.2784458116403
        struct[0].Gy[49,52] = -46.5699289619080
        struct[0].Gy[49,53] = 49.9151995897384
        struct[0].Gy[49,54] = -20.5427472507027
        struct[0].Gy[49,55] = 79.2784458116403
        struct[0].Gy[49,56] = -54.0657727682604
        struct[0].Gy[49,57] = 105.571769313180
        struct[0].Gy[49,58] = 10.2713736253513
        struct[0].Gy[49,59] = -39.6392229058202
        struct[0].Gy[49,60] = 23.2849644809540
        struct[0].Gy[49,61] = -24.9575997948692
        struct[0].Gy[49,62] = 10.2713736253513
        struct[0].Gy[49,63] = -39.6392229058202
        struct[0].Gy[50,0] = -39.6392229058202
        struct[0].Gy[50,1] = -10.2713736253513
        struct[0].Gy[50,2] = 105.571769313180
        struct[0].Gy[50,3] = 54.0657727682604
        struct[0].Gy[50,4] = -39.6392229058201
        struct[0].Gy[50,5] = -10.2713736253513
        struct[0].Gy[50,6] = -24.9575997948692
        struct[0].Gy[50,7] = -23.2849644809540
        struct[0].Gy[50,48] = 79.2784458116403
        struct[0].Gy[50,49] = 20.5427472507027
        struct[0].Gy[50,50] = -211.143538626360
        struct[0].Gy[50,51] = -108.131545536521
        struct[0].Gy[50,52] = 79.2784458116403
        struct[0].Gy[50,53] = 20.5427472507027
        struct[0].Gy[50,54] = 49.9151995897384
        struct[0].Gy[50,55] = 46.5699289619080
        struct[0].Gy[50,56] = -39.6392229058202
        struct[0].Gy[50,57] = -10.2713736253513
        struct[0].Gy[50,58] = 105.571769313180
        struct[0].Gy[50,59] = 54.0657727682604
        struct[0].Gy[50,60] = -39.6392229058201
        struct[0].Gy[50,61] = -10.2713736253513
        struct[0].Gy[50,62] = -24.9575997948692
        struct[0].Gy[50,63] = -23.2849644809540
        struct[0].Gy[51,0] = 10.2713736253513
        struct[0].Gy[51,1] = -39.6392229058202
        struct[0].Gy[51,2] = -54.0657727682604
        struct[0].Gy[51,3] = 105.571769313180
        struct[0].Gy[51,4] = 10.2713736253513
        struct[0].Gy[51,5] = -39.6392229058201
        struct[0].Gy[51,6] = 23.2849644809540
        struct[0].Gy[51,7] = -24.9575997948692
        struct[0].Gy[51,48] = -20.5427472507027
        struct[0].Gy[51,49] = 79.2784458116403
        struct[0].Gy[51,50] = 108.131545536521
        struct[0].Gy[51,51] = -211.143538626360
        struct[0].Gy[51,52] = -20.5427472507027
        struct[0].Gy[51,53] = 79.2784458116403
        struct[0].Gy[51,54] = -46.5699289619080
        struct[0].Gy[51,55] = 49.9151995897384
        struct[0].Gy[51,56] = 10.2713736253513
        struct[0].Gy[51,57] = -39.6392229058202
        struct[0].Gy[51,58] = -54.0657727682604
        struct[0].Gy[51,59] = 105.571769313180
        struct[0].Gy[51,60] = 10.2713736253513
        struct[0].Gy[51,61] = -39.6392229058201
        struct[0].Gy[51,62] = 23.2849644809540
        struct[0].Gy[51,63] = -24.9575997948692
        struct[0].Gy[52,0] = -24.9575997948692
        struct[0].Gy[52,1] = -23.2849644809540
        struct[0].Gy[52,2] = -39.6392229058202
        struct[0].Gy[52,3] = -10.2713736253513
        struct[0].Gy[52,4] = 105.571769313180
        struct[0].Gy[52,5] = 54.0657727682604
        struct[0].Gy[52,6] = -39.6392229058201
        struct[0].Gy[52,7] = -10.2713736253514
        struct[0].Gy[52,48] = 49.9151995897384
        struct[0].Gy[52,49] = 46.5699289619080
        struct[0].Gy[52,50] = 79.2784458116404
        struct[0].Gy[52,51] = 20.5427472507027
        struct[0].Gy[52,52] = -211.143538626360
        struct[0].Gy[52,53] = -108.131545536521
        struct[0].Gy[52,54] = 79.2784458116403
        struct[0].Gy[52,55] = 20.5427472507027
        struct[0].Gy[52,56] = -24.9575997948692
        struct[0].Gy[52,57] = -23.2849644809540
        struct[0].Gy[52,58] = -39.6392229058202
        struct[0].Gy[52,59] = -10.2713736253513
        struct[0].Gy[52,60] = 105.571769313180
        struct[0].Gy[52,61] = 54.0657727682604
        struct[0].Gy[52,62] = -39.6392229058201
        struct[0].Gy[52,63] = -10.2713736253514
        struct[0].Gy[53,0] = 23.2849644809540
        struct[0].Gy[53,1] = -24.9575997948692
        struct[0].Gy[53,2] = 10.2713736253513
        struct[0].Gy[53,3] = -39.6392229058202
        struct[0].Gy[53,4] = -54.0657727682604
        struct[0].Gy[53,5] = 105.571769313180
        struct[0].Gy[53,6] = 10.2713736253514
        struct[0].Gy[53,7] = -39.6392229058201
        struct[0].Gy[53,48] = -46.5699289619080
        struct[0].Gy[53,49] = 49.9151995897384
        struct[0].Gy[53,50] = -20.5427472507027
        struct[0].Gy[53,51] = 79.2784458116404
        struct[0].Gy[53,52] = 108.131545536521
        struct[0].Gy[53,53] = -211.143538626360
        struct[0].Gy[53,54] = -20.5427472507027
        struct[0].Gy[53,55] = 79.2784458116403
        struct[0].Gy[53,56] = 23.2849644809540
        struct[0].Gy[53,57] = -24.9575997948692
        struct[0].Gy[53,58] = 10.2713736253513
        struct[0].Gy[53,59] = -39.6392229058202
        struct[0].Gy[53,60] = -54.0657727682604
        struct[0].Gy[53,61] = 105.571769313180
        struct[0].Gy[53,62] = 10.2713736253514
        struct[0].Gy[53,63] = -39.6392229058201
        struct[0].Gy[54,0] = -39.6392229058202
        struct[0].Gy[54,1] = -10.2713736253513
        struct[0].Gy[54,2] = -24.9575997948692
        struct[0].Gy[54,3] = -23.2849644809540
        struct[0].Gy[54,4] = -39.6392229058202
        struct[0].Gy[54,5] = -10.2713736253513
        struct[0].Gy[54,6] = 105.571769313180
        struct[0].Gy[54,7] = 54.0657727682604
        struct[0].Gy[54,48] = 79.2784458116403
        struct[0].Gy[54,49] = 20.5427472507027
        struct[0].Gy[54,50] = 49.9151995897384
        struct[0].Gy[54,51] = 46.5699289619080
        struct[0].Gy[54,52] = 79.2784458116403
        struct[0].Gy[54,53] = 20.5427472507027
        struct[0].Gy[54,54] = -211.168538626360
        struct[0].Gy[54,55] = -108.131545536521
        struct[0].Gy[54,56] = -39.6392229058202
        struct[0].Gy[54,57] = -10.2713736253513
        struct[0].Gy[54,58] = -24.9575997948692
        struct[0].Gy[54,59] = -23.2849644809540
        struct[0].Gy[54,60] = -39.6392229058202
        struct[0].Gy[54,61] = -10.2713736253513
        struct[0].Gy[54,62] = 105.571769313180
        struct[0].Gy[54,63] = 54.0657727682604
        struct[0].Gy[55,0] = 10.2713736253513
        struct[0].Gy[55,1] = -39.6392229058202
        struct[0].Gy[55,2] = 23.2849644809540
        struct[0].Gy[55,3] = -24.9575997948692
        struct[0].Gy[55,4] = 10.2713736253513
        struct[0].Gy[55,5] = -39.6392229058202
        struct[0].Gy[55,6] = -54.0657727682604
        struct[0].Gy[55,7] = 105.571769313180
        struct[0].Gy[55,48] = -20.5427472507027
        struct[0].Gy[55,49] = 79.2784458116403
        struct[0].Gy[55,50] = -46.5699289619080
        struct[0].Gy[55,51] = 49.9151995897384
        struct[0].Gy[55,52] = -20.5427472507027
        struct[0].Gy[55,53] = 79.2784458116403
        struct[0].Gy[55,54] = 108.131545536521
        struct[0].Gy[55,55] = -211.168538626360
        struct[0].Gy[55,56] = 10.2713736253513
        struct[0].Gy[55,57] = -39.6392229058202
        struct[0].Gy[55,58] = 23.2849644809540
        struct[0].Gy[55,59] = -24.9575997948692
        struct[0].Gy[55,60] = 10.2713736253513
        struct[0].Gy[55,61] = -39.6392229058202
        struct[0].Gy[55,62] = -54.0657727682604
        struct[0].Gy[55,63] = 105.571769313180
        struct[0].Gy[56,8] = 26.5300693004806
        struct[0].Gy[56,9] = 4.84676915585801
        struct[0].Gy[56,10] = -7.89461337514771
        struct[0].Gy[56,11] = 1.58482814504483
        struct[0].Gy[56,48] = 105.571769313180
        struct[0].Gy[56,49] = 54.0657727682604
        struct[0].Gy[56,50] = -39.6392229058202
        struct[0].Gy[56,51] = -10.2713736253513
        struct[0].Gy[56,52] = -24.9575997948692
        struct[0].Gy[56,53] = -23.2849644809540
        struct[0].Gy[56,54] = -39.6392229058202
        struct[0].Gy[56,55] = -10.2713736253513
        struct[0].Gy[56,56] = -237.673607926841
        struct[0].Gy[56,57] = -112.978314692379
        struct[0].Gy[56,58] = 87.1730591867880
        struct[0].Gy[56,59] = 18.9579191056578
        struct[0].Gy[56,60] = 57.6366430644055
        struct[0].Gy[56,61] = 45.8900105086227
        struct[0].Gy[56,62] = 87.1730591867880
        struct[0].Gy[56,63] = 18.9579191056579
        struct[0].Gy[56,64] = 105.571769313180
        struct[0].Gy[56,65] = 54.0657727682604
        struct[0].Gy[56,66] = -39.6392229058202
        struct[0].Gy[56,67] = -10.2713736253513
        struct[0].Gy[56,68] = -24.9575997948692
        struct[0].Gy[56,69] = -23.2849644809540
        struct[0].Gy[56,70] = -39.6392229058202
        struct[0].Gy[56,71] = -10.2713736253513
        struct[0].Gy[56,120] = -7.89461337514770
        struct[0].Gy[56,121] = 1.58482814504483
        struct[0].Gy[56,122] = -7.72144347466701
        struct[0].Gy[56,123] = 0.679918453285310
        struct[0].Gy[57,8] = -4.84676915585801
        struct[0].Gy[57,9] = 26.5300693004806
        struct[0].Gy[57,10] = -1.58482814504483
        struct[0].Gy[57,11] = -7.89461337514771
        struct[0].Gy[57,48] = -54.0657727682604
        struct[0].Gy[57,49] = 105.571769313180
        struct[0].Gy[57,50] = 10.2713736253513
        struct[0].Gy[57,51] = -39.6392229058202
        struct[0].Gy[57,52] = 23.2849644809540
        struct[0].Gy[57,53] = -24.9575997948692
        struct[0].Gy[57,54] = 10.2713736253513
        struct[0].Gy[57,55] = -39.6392229058202
        struct[0].Gy[57,56] = 112.978314692379
        struct[0].Gy[57,57] = -237.673607926841
        struct[0].Gy[57,58] = -18.9579191056578
        struct[0].Gy[57,59] = 87.1730591867880
        struct[0].Gy[57,60] = -45.8900105086227
        struct[0].Gy[57,61] = 57.6366430644055
        struct[0].Gy[57,62] = -18.9579191056579
        struct[0].Gy[57,63] = 87.1730591867880
        struct[0].Gy[57,64] = -54.0657727682604
        struct[0].Gy[57,65] = 105.571769313180
        struct[0].Gy[57,66] = 10.2713736253513
        struct[0].Gy[57,67] = -39.6392229058202
        struct[0].Gy[57,68] = 23.2849644809540
        struct[0].Gy[57,69] = -24.9575997948692
        struct[0].Gy[57,70] = 10.2713736253513
        struct[0].Gy[57,71] = -39.6392229058202
        struct[0].Gy[57,120] = -1.58482814504483
        struct[0].Gy[57,121] = -7.89461337514770
        struct[0].Gy[57,122] = -0.679918453285310
        struct[0].Gy[57,123] = -7.72144347466701
        struct[0].Gy[58,8] = -7.89461337514771
        struct[0].Gy[58,9] = 1.58482814504483
        struct[0].Gy[58,10] = -7.72144347466701
        struct[0].Gy[58,11] = 0.679918453285308
        struct[0].Gy[58,48] = -39.6392229058202
        struct[0].Gy[58,49] = -10.2713736253513
        struct[0].Gy[58,50] = 105.571769313180
        struct[0].Gy[58,51] = 54.0657727682604
        struct[0].Gy[58,52] = -39.6392229058201
        struct[0].Gy[58,53] = -10.2713736253513
        struct[0].Gy[58,54] = -24.9575997948692
        struct[0].Gy[58,55] = -23.2849644809540
        struct[0].Gy[58,56] = 87.1730591867880
        struct[0].Gy[58,57] = 18.9579191056579
        struct[0].Gy[58,58] = -237.673607926841
        struct[0].Gy[58,59] = -112.978314692379
        struct[0].Gy[58,60] = 87.1730591867880
        struct[0].Gy[58,61] = 18.9579191056579
        struct[0].Gy[58,62] = 57.6366430644054
        struct[0].Gy[58,63] = 45.8900105086227
        struct[0].Gy[58,64] = -39.6392229058202
        struct[0].Gy[58,65] = -10.2713736253513
        struct[0].Gy[58,66] = 105.571769313180
        struct[0].Gy[58,67] = 54.0657727682604
        struct[0].Gy[58,68] = -39.6392229058201
        struct[0].Gy[58,69] = -10.2713736253513
        struct[0].Gy[58,70] = -24.9575997948692
        struct[0].Gy[58,71] = -23.2849644809540
        struct[0].Gy[58,120] = 26.5300693004806
        struct[0].Gy[58,121] = 4.84676915585801
        struct[0].Gy[58,122] = -7.89461337514771
        struct[0].Gy[58,123] = 1.58482814504483
        struct[0].Gy[59,8] = -1.58482814504483
        struct[0].Gy[59,9] = -7.89461337514771
        struct[0].Gy[59,10] = -0.679918453285308
        struct[0].Gy[59,11] = -7.72144347466701
        struct[0].Gy[59,48] = 10.2713736253513
        struct[0].Gy[59,49] = -39.6392229058202
        struct[0].Gy[59,50] = -54.0657727682604
        struct[0].Gy[59,51] = 105.571769313180
        struct[0].Gy[59,52] = 10.2713736253513
        struct[0].Gy[59,53] = -39.6392229058201
        struct[0].Gy[59,54] = 23.2849644809540
        struct[0].Gy[59,55] = -24.9575997948692
        struct[0].Gy[59,56] = -18.9579191056579
        struct[0].Gy[59,57] = 87.1730591867880
        struct[0].Gy[59,58] = 112.978314692379
        struct[0].Gy[59,59] = -237.673607926841
        struct[0].Gy[59,60] = -18.9579191056579
        struct[0].Gy[59,61] = 87.1730591867880
        struct[0].Gy[59,62] = -45.8900105086227
        struct[0].Gy[59,63] = 57.6366430644054
        struct[0].Gy[59,64] = 10.2713736253513
        struct[0].Gy[59,65] = -39.6392229058202
        struct[0].Gy[59,66] = -54.0657727682604
        struct[0].Gy[59,67] = 105.571769313180
        struct[0].Gy[59,68] = 10.2713736253513
        struct[0].Gy[59,69] = -39.6392229058201
        struct[0].Gy[59,70] = 23.2849644809540
        struct[0].Gy[59,71] = -24.9575997948692
        struct[0].Gy[59,120] = -4.84676915585801
        struct[0].Gy[59,121] = 26.5300693004806
        struct[0].Gy[59,122] = -1.58482814504483
        struct[0].Gy[59,123] = -7.89461337514771
        struct[0].Gy[60,8] = -7.72144347466701
        struct[0].Gy[60,9] = 0.679918453285310
        struct[0].Gy[60,10] = -7.89461337514771
        struct[0].Gy[60,11] = 1.58482814504483
        struct[0].Gy[60,48] = -24.9575997948692
        struct[0].Gy[60,49] = -23.2849644809540
        struct[0].Gy[60,50] = -39.6392229058202
        struct[0].Gy[60,51] = -10.2713736253513
        struct[0].Gy[60,52] = 105.571769313180
        struct[0].Gy[60,53] = 54.0657727682604
        struct[0].Gy[60,54] = -39.6392229058201
        struct[0].Gy[60,55] = -10.2713736253514
        struct[0].Gy[60,56] = 57.6366430644054
        struct[0].Gy[60,57] = 45.8900105086227
        struct[0].Gy[60,58] = 87.1730591867881
        struct[0].Gy[60,59] = 18.9579191056578
        struct[0].Gy[60,60] = -237.673607926841
        struct[0].Gy[60,61] = -112.978314692379
        struct[0].Gy[60,62] = 87.1730591867880
        struct[0].Gy[60,63] = 18.9579191056579
        struct[0].Gy[60,64] = -24.9575997948692
        struct[0].Gy[60,65] = -23.2849644809540
        struct[0].Gy[60,66] = -39.6392229058202
        struct[0].Gy[60,67] = -10.2713736253513
        struct[0].Gy[60,68] = 105.571769313180
        struct[0].Gy[60,69] = 54.0657727682604
        struct[0].Gy[60,70] = -39.6392229058201
        struct[0].Gy[60,71] = -10.2713736253514
        struct[0].Gy[60,120] = -7.89461337514770
        struct[0].Gy[60,121] = 1.58482814504483
        struct[0].Gy[60,122] = 26.5300693004806
        struct[0].Gy[60,123] = 4.84676915585801
        struct[0].Gy[61,8] = -0.679918453285310
        struct[0].Gy[61,9] = -7.72144347466701
        struct[0].Gy[61,10] = -1.58482814504483
        struct[0].Gy[61,11] = -7.89461337514771
        struct[0].Gy[61,48] = 23.2849644809540
        struct[0].Gy[61,49] = -24.9575997948692
        struct[0].Gy[61,50] = 10.2713736253513
        struct[0].Gy[61,51] = -39.6392229058202
        struct[0].Gy[61,52] = -54.0657727682604
        struct[0].Gy[61,53] = 105.571769313180
        struct[0].Gy[61,54] = 10.2713736253514
        struct[0].Gy[61,55] = -39.6392229058201
        struct[0].Gy[61,56] = -45.8900105086227
        struct[0].Gy[61,57] = 57.6366430644054
        struct[0].Gy[61,58] = -18.9579191056578
        struct[0].Gy[61,59] = 87.1730591867881
        struct[0].Gy[61,60] = 112.978314692379
        struct[0].Gy[61,61] = -237.673607926841
        struct[0].Gy[61,62] = -18.9579191056579
        struct[0].Gy[61,63] = 87.1730591867880
        struct[0].Gy[61,64] = 23.2849644809540
        struct[0].Gy[61,65] = -24.9575997948692
        struct[0].Gy[61,66] = 10.2713736253513
        struct[0].Gy[61,67] = -39.6392229058202
        struct[0].Gy[61,68] = -54.0657727682604
        struct[0].Gy[61,69] = 105.571769313180
        struct[0].Gy[61,70] = 10.2713736253514
        struct[0].Gy[61,71] = -39.6392229058201
        struct[0].Gy[61,120] = -1.58482814504483
        struct[0].Gy[61,121] = -7.89461337514770
        struct[0].Gy[61,122] = -4.84676915585801
        struct[0].Gy[61,123] = 26.5300693004806
        struct[0].Gy[62,8] = -7.89461337514771
        struct[0].Gy[62,9] = 1.58482814504483
        struct[0].Gy[62,10] = 26.5300693004806
        struct[0].Gy[62,11] = 4.84676915585801
        struct[0].Gy[62,48] = -39.6392229058202
        struct[0].Gy[62,49] = -10.2713736253513
        struct[0].Gy[62,50] = -24.9575997948692
        struct[0].Gy[62,51] = -23.2849644809540
        struct[0].Gy[62,52] = -39.6392229058202
        struct[0].Gy[62,53] = -10.2713736253513
        struct[0].Gy[62,54] = 105.571769313180
        struct[0].Gy[62,55] = 54.0657727682604
        struct[0].Gy[62,56] = 87.1730591867880
        struct[0].Gy[62,57] = 18.9579191056578
        struct[0].Gy[62,58] = 57.6366430644054
        struct[0].Gy[62,59] = 45.8900105086227
        struct[0].Gy[62,60] = 87.1730591867880
        struct[0].Gy[62,61] = 18.9579191056579
        struct[0].Gy[62,62] = -237.673607926841
        struct[0].Gy[62,63] = -112.978314692379
        struct[0].Gy[62,64] = -39.6392229058202
        struct[0].Gy[62,65] = -10.2713736253513
        struct[0].Gy[62,66] = -24.9575997948692
        struct[0].Gy[62,67] = -23.2849644809540
        struct[0].Gy[62,68] = -39.6392229058202
        struct[0].Gy[62,69] = -10.2713736253513
        struct[0].Gy[62,70] = 105.571769313180
        struct[0].Gy[62,71] = 54.0657727682604
        struct[0].Gy[62,120] = -7.72144347466701
        struct[0].Gy[62,121] = 0.679918453285308
        struct[0].Gy[62,122] = -7.89461337514771
        struct[0].Gy[62,123] = 1.58482814504483
        struct[0].Gy[63,8] = -1.58482814504483
        struct[0].Gy[63,9] = -7.89461337514771
        struct[0].Gy[63,10] = -4.84676915585801
        struct[0].Gy[63,11] = 26.5300693004806
        struct[0].Gy[63,48] = 10.2713736253513
        struct[0].Gy[63,49] = -39.6392229058202
        struct[0].Gy[63,50] = 23.2849644809540
        struct[0].Gy[63,51] = -24.9575997948692
        struct[0].Gy[63,52] = 10.2713736253513
        struct[0].Gy[63,53] = -39.6392229058202
        struct[0].Gy[63,54] = -54.0657727682604
        struct[0].Gy[63,55] = 105.571769313180
        struct[0].Gy[63,56] = -18.9579191056578
        struct[0].Gy[63,57] = 87.1730591867880
        struct[0].Gy[63,58] = -45.8900105086227
        struct[0].Gy[63,59] = 57.6366430644054
        struct[0].Gy[63,60] = -18.9579191056579
        struct[0].Gy[63,61] = 87.1730591867880
        struct[0].Gy[63,62] = 112.978314692379
        struct[0].Gy[63,63] = -237.673607926841
        struct[0].Gy[63,64] = 10.2713736253513
        struct[0].Gy[63,65] = -39.6392229058202
        struct[0].Gy[63,66] = 23.2849644809540
        struct[0].Gy[63,67] = -24.9575997948692
        struct[0].Gy[63,68] = 10.2713736253513
        struct[0].Gy[63,69] = -39.6392229058202
        struct[0].Gy[63,70] = -54.0657727682604
        struct[0].Gy[63,71] = 105.571769313180
        struct[0].Gy[63,120] = -0.679918453285308
        struct[0].Gy[63,121] = -7.72144347466701
        struct[0].Gy[63,122] = -1.58482814504483
        struct[0].Gy[63,123] = -7.89461337514771
        struct[0].Gy[64,56] = 105.571769313180
        struct[0].Gy[64,57] = 54.0657727682604
        struct[0].Gy[64,58] = -39.6392229058202
        struct[0].Gy[64,59] = -10.2713736253513
        struct[0].Gy[64,60] = -24.9575997948692
        struct[0].Gy[64,61] = -23.2849644809540
        struct[0].Gy[64,62] = -39.6392229058202
        struct[0].Gy[64,63] = -10.2713736253513
        struct[0].Gy[64,64] = -237.673607926841
        struct[0].Gy[64,65] = -112.978314692379
        struct[0].Gy[64,66] = 87.1730591867880
        struct[0].Gy[64,67] = 18.9579191056578
        struct[0].Gy[64,68] = 57.6366430644055
        struct[0].Gy[64,69] = 45.8900105086227
        struct[0].Gy[64,70] = 87.1730591867880
        struct[0].Gy[64,71] = 18.9579191056579
        struct[0].Gy[64,72] = 105.571769313180
        struct[0].Gy[64,73] = 54.0657727682604
        struct[0].Gy[64,74] = -39.6392229058202
        struct[0].Gy[64,75] = -10.2713736253513
        struct[0].Gy[64,76] = -24.9575997948692
        struct[0].Gy[64,77] = -23.2849644809540
        struct[0].Gy[64,78] = -39.6392229058202
        struct[0].Gy[64,79] = -10.2713736253513
        struct[0].Gy[64,124] = 26.5300693004806
        struct[0].Gy[64,125] = 4.84676915585801
        struct[0].Gy[64,126] = -7.89461337514770
        struct[0].Gy[64,127] = 1.58482814504483
        struct[0].Gy[64,128] = -7.72144347466701
        struct[0].Gy[64,129] = 0.679918453285310
        struct[0].Gy[64,130] = -7.89461337514771
        struct[0].Gy[64,131] = 1.58482814504483
        struct[0].Gy[65,56] = -54.0657727682604
        struct[0].Gy[65,57] = 105.571769313180
        struct[0].Gy[65,58] = 10.2713736253513
        struct[0].Gy[65,59] = -39.6392229058202
        struct[0].Gy[65,60] = 23.2849644809540
        struct[0].Gy[65,61] = -24.9575997948692
        struct[0].Gy[65,62] = 10.2713736253513
        struct[0].Gy[65,63] = -39.6392229058202
        struct[0].Gy[65,64] = 112.978314692379
        struct[0].Gy[65,65] = -237.673607926841
        struct[0].Gy[65,66] = -18.9579191056578
        struct[0].Gy[65,67] = 87.1730591867880
        struct[0].Gy[65,68] = -45.8900105086227
        struct[0].Gy[65,69] = 57.6366430644055
        struct[0].Gy[65,70] = -18.9579191056579
        struct[0].Gy[65,71] = 87.1730591867880
        struct[0].Gy[65,72] = -54.0657727682604
        struct[0].Gy[65,73] = 105.571769313180
        struct[0].Gy[65,74] = 10.2713736253513
        struct[0].Gy[65,75] = -39.6392229058202
        struct[0].Gy[65,76] = 23.2849644809540
        struct[0].Gy[65,77] = -24.9575997948692
        struct[0].Gy[65,78] = 10.2713736253513
        struct[0].Gy[65,79] = -39.6392229058202
        struct[0].Gy[65,124] = -4.84676915585801
        struct[0].Gy[65,125] = 26.5300693004806
        struct[0].Gy[65,126] = -1.58482814504483
        struct[0].Gy[65,127] = -7.89461337514770
        struct[0].Gy[65,128] = -0.679918453285310
        struct[0].Gy[65,129] = -7.72144347466701
        struct[0].Gy[65,130] = -1.58482814504483
        struct[0].Gy[65,131] = -7.89461337514771
        struct[0].Gy[66,56] = -39.6392229058202
        struct[0].Gy[66,57] = -10.2713736253513
        struct[0].Gy[66,58] = 105.571769313180
        struct[0].Gy[66,59] = 54.0657727682604
        struct[0].Gy[66,60] = -39.6392229058201
        struct[0].Gy[66,61] = -10.2713736253513
        struct[0].Gy[66,62] = -24.9575997948692
        struct[0].Gy[66,63] = -23.2849644809540
        struct[0].Gy[66,64] = 87.1730591867880
        struct[0].Gy[66,65] = 18.9579191056579
        struct[0].Gy[66,66] = -237.673607926841
        struct[0].Gy[66,67] = -112.978314692379
        struct[0].Gy[66,68] = 87.1730591867880
        struct[0].Gy[66,69] = 18.9579191056579
        struct[0].Gy[66,70] = 57.6366430644054
        struct[0].Gy[66,71] = 45.8900105086227
        struct[0].Gy[66,72] = -39.6392229058202
        struct[0].Gy[66,73] = -10.2713736253513
        struct[0].Gy[66,74] = 105.571769313180
        struct[0].Gy[66,75] = 54.0657727682604
        struct[0].Gy[66,76] = -39.6392229058201
        struct[0].Gy[66,77] = -10.2713736253513
        struct[0].Gy[66,78] = -24.9575997948692
        struct[0].Gy[66,79] = -23.2849644809540
        struct[0].Gy[66,124] = -7.89461337514771
        struct[0].Gy[66,125] = 1.58482814504483
        struct[0].Gy[66,126] = 26.5300693004806
        struct[0].Gy[66,127] = 4.84676915585801
        struct[0].Gy[66,128] = -7.89461337514771
        struct[0].Gy[66,129] = 1.58482814504483
        struct[0].Gy[66,130] = -7.72144347466701
        struct[0].Gy[66,131] = 0.679918453285308
        struct[0].Gy[67,56] = 10.2713736253513
        struct[0].Gy[67,57] = -39.6392229058202
        struct[0].Gy[67,58] = -54.0657727682604
        struct[0].Gy[67,59] = 105.571769313180
        struct[0].Gy[67,60] = 10.2713736253513
        struct[0].Gy[67,61] = -39.6392229058201
        struct[0].Gy[67,62] = 23.2849644809540
        struct[0].Gy[67,63] = -24.9575997948692
        struct[0].Gy[67,64] = -18.9579191056579
        struct[0].Gy[67,65] = 87.1730591867880
        struct[0].Gy[67,66] = 112.978314692379
        struct[0].Gy[67,67] = -237.673607926841
        struct[0].Gy[67,68] = -18.9579191056579
        struct[0].Gy[67,69] = 87.1730591867880
        struct[0].Gy[67,70] = -45.8900105086227
        struct[0].Gy[67,71] = 57.6366430644054
        struct[0].Gy[67,72] = 10.2713736253513
        struct[0].Gy[67,73] = -39.6392229058202
        struct[0].Gy[67,74] = -54.0657727682604
        struct[0].Gy[67,75] = 105.571769313180
        struct[0].Gy[67,76] = 10.2713736253513
        struct[0].Gy[67,77] = -39.6392229058201
        struct[0].Gy[67,78] = 23.2849644809540
        struct[0].Gy[67,79] = -24.9575997948692
        struct[0].Gy[67,124] = -1.58482814504483
        struct[0].Gy[67,125] = -7.89461337514771
        struct[0].Gy[67,126] = -4.84676915585801
        struct[0].Gy[67,127] = 26.5300693004806
        struct[0].Gy[67,128] = -1.58482814504483
        struct[0].Gy[67,129] = -7.89461337514771
        struct[0].Gy[67,130] = -0.679918453285308
        struct[0].Gy[67,131] = -7.72144347466701
        struct[0].Gy[68,56] = -24.9575997948692
        struct[0].Gy[68,57] = -23.2849644809540
        struct[0].Gy[68,58] = -39.6392229058202
        struct[0].Gy[68,59] = -10.2713736253513
        struct[0].Gy[68,60] = 105.571769313180
        struct[0].Gy[68,61] = 54.0657727682604
        struct[0].Gy[68,62] = -39.6392229058201
        struct[0].Gy[68,63] = -10.2713736253514
        struct[0].Gy[68,64] = 57.6366430644054
        struct[0].Gy[68,65] = 45.8900105086227
        struct[0].Gy[68,66] = 87.1730591867881
        struct[0].Gy[68,67] = 18.9579191056578
        struct[0].Gy[68,68] = -237.673607926841
        struct[0].Gy[68,69] = -112.978314692379
        struct[0].Gy[68,70] = 87.1730591867880
        struct[0].Gy[68,71] = 18.9579191056579
        struct[0].Gy[68,72] = -24.9575997948692
        struct[0].Gy[68,73] = -23.2849644809540
        struct[0].Gy[68,74] = -39.6392229058202
        struct[0].Gy[68,75] = -10.2713736253513
        struct[0].Gy[68,76] = 105.571769313180
        struct[0].Gy[68,77] = 54.0657727682604
        struct[0].Gy[68,78] = -39.6392229058201
        struct[0].Gy[68,79] = -10.2713736253514
        struct[0].Gy[68,124] = -7.72144347466701
        struct[0].Gy[68,125] = 0.679918453285310
        struct[0].Gy[68,126] = -7.89461337514770
        struct[0].Gy[68,127] = 1.58482814504483
        struct[0].Gy[68,128] = 26.5300693004806
        struct[0].Gy[68,129] = 4.84676915585801
        struct[0].Gy[68,130] = -7.89461337514771
        struct[0].Gy[68,131] = 1.58482814504483
        struct[0].Gy[69,56] = 23.2849644809540
        struct[0].Gy[69,57] = -24.9575997948692
        struct[0].Gy[69,58] = 10.2713736253513
        struct[0].Gy[69,59] = -39.6392229058202
        struct[0].Gy[69,60] = -54.0657727682604
        struct[0].Gy[69,61] = 105.571769313180
        struct[0].Gy[69,62] = 10.2713736253514
        struct[0].Gy[69,63] = -39.6392229058201
        struct[0].Gy[69,64] = -45.8900105086227
        struct[0].Gy[69,65] = 57.6366430644054
        struct[0].Gy[69,66] = -18.9579191056578
        struct[0].Gy[69,67] = 87.1730591867881
        struct[0].Gy[69,68] = 112.978314692379
        struct[0].Gy[69,69] = -237.673607926841
        struct[0].Gy[69,70] = -18.9579191056579
        struct[0].Gy[69,71] = 87.1730591867880
        struct[0].Gy[69,72] = 23.2849644809540
        struct[0].Gy[69,73] = -24.9575997948692
        struct[0].Gy[69,74] = 10.2713736253513
        struct[0].Gy[69,75] = -39.6392229058202
        struct[0].Gy[69,76] = -54.0657727682604
        struct[0].Gy[69,77] = 105.571769313180
        struct[0].Gy[69,78] = 10.2713736253514
        struct[0].Gy[69,79] = -39.6392229058201
        struct[0].Gy[69,124] = -0.679918453285310
        struct[0].Gy[69,125] = -7.72144347466701
        struct[0].Gy[69,126] = -1.58482814504483
        struct[0].Gy[69,127] = -7.89461337514770
        struct[0].Gy[69,128] = -4.84676915585801
        struct[0].Gy[69,129] = 26.5300693004806
        struct[0].Gy[69,130] = -1.58482814504483
        struct[0].Gy[69,131] = -7.89461337514771
        struct[0].Gy[70,56] = -39.6392229058202
        struct[0].Gy[70,57] = -10.2713736253513
        struct[0].Gy[70,58] = -24.9575997948692
        struct[0].Gy[70,59] = -23.2849644809540
        struct[0].Gy[70,60] = -39.6392229058202
        struct[0].Gy[70,61] = -10.2713736253513
        struct[0].Gy[70,62] = 105.571769313180
        struct[0].Gy[70,63] = 54.0657727682604
        struct[0].Gy[70,64] = 87.1730591867880
        struct[0].Gy[70,65] = 18.9579191056578
        struct[0].Gy[70,66] = 57.6366430644054
        struct[0].Gy[70,67] = 45.8900105086227
        struct[0].Gy[70,68] = 87.1730591867880
        struct[0].Gy[70,69] = 18.9579191056579
        struct[0].Gy[70,70] = -237.698607926841
        struct[0].Gy[70,71] = -112.978314692379
        struct[0].Gy[70,72] = -39.6392229058202
        struct[0].Gy[70,73] = -10.2713736253513
        struct[0].Gy[70,74] = -24.9575997948692
        struct[0].Gy[70,75] = -23.2849644809540
        struct[0].Gy[70,76] = -39.6392229058202
        struct[0].Gy[70,77] = -10.2713736253513
        struct[0].Gy[70,78] = 105.571769313180
        struct[0].Gy[70,79] = 54.0657727682604
        struct[0].Gy[70,124] = -7.89461337514771
        struct[0].Gy[70,125] = 1.58482814504483
        struct[0].Gy[70,126] = -7.72144347466701
        struct[0].Gy[70,127] = 0.679918453285308
        struct[0].Gy[70,128] = -7.89461337514771
        struct[0].Gy[70,129] = 1.58482814504483
        struct[0].Gy[70,130] = 26.5300693004806
        struct[0].Gy[70,131] = 4.84676915585801
        struct[0].Gy[71,56] = 10.2713736253513
        struct[0].Gy[71,57] = -39.6392229058202
        struct[0].Gy[71,58] = 23.2849644809540
        struct[0].Gy[71,59] = -24.9575997948692
        struct[0].Gy[71,60] = 10.2713736253513
        struct[0].Gy[71,61] = -39.6392229058202
        struct[0].Gy[71,62] = -54.0657727682604
        struct[0].Gy[71,63] = 105.571769313180
        struct[0].Gy[71,64] = -18.9579191056578
        struct[0].Gy[71,65] = 87.1730591867880
        struct[0].Gy[71,66] = -45.8900105086227
        struct[0].Gy[71,67] = 57.6366430644054
        struct[0].Gy[71,68] = -18.9579191056579
        struct[0].Gy[71,69] = 87.1730591867880
        struct[0].Gy[71,70] = 112.978314692379
        struct[0].Gy[71,71] = -237.698607926841
        struct[0].Gy[71,72] = 10.2713736253513
        struct[0].Gy[71,73] = -39.6392229058202
        struct[0].Gy[71,74] = 23.2849644809540
        struct[0].Gy[71,75] = -24.9575997948692
        struct[0].Gy[71,76] = 10.2713736253513
        struct[0].Gy[71,77] = -39.6392229058202
        struct[0].Gy[71,78] = -54.0657727682604
        struct[0].Gy[71,79] = 105.571769313180
        struct[0].Gy[71,124] = -1.58482814504483
        struct[0].Gy[71,125] = -7.89461337514771
        struct[0].Gy[71,126] = -0.679918453285308
        struct[0].Gy[71,127] = -7.72144347466701
        struct[0].Gy[71,128] = -1.58482814504483
        struct[0].Gy[71,129] = -7.89461337514771
        struct[0].Gy[71,130] = -4.84676915585801
        struct[0].Gy[71,131] = 26.5300693004806
        struct[0].Gy[72,64] = 105.571769313180
        struct[0].Gy[72,65] = 54.0657727682604
        struct[0].Gy[72,66] = -39.6392229058202
        struct[0].Gy[72,67] = -10.2713736253513
        struct[0].Gy[72,68] = -24.9575997948692
        struct[0].Gy[72,69] = -23.2849644809540
        struct[0].Gy[72,70] = -39.6392229058202
        struct[0].Gy[72,71] = -10.2713736253513
        struct[0].Gy[72,72] = -211.143538626360
        struct[0].Gy[72,73] = -108.131545536521
        struct[0].Gy[72,74] = 79.2784458116403
        struct[0].Gy[72,75] = 20.5427472507027
        struct[0].Gy[72,76] = 49.9151995897384
        struct[0].Gy[72,77] = 46.5699289619080
        struct[0].Gy[72,78] = 79.2784458116403
        struct[0].Gy[72,79] = 20.5427472507027
        struct[0].Gy[72,80] = 105.571769313180
        struct[0].Gy[72,81] = 54.0657727682604
        struct[0].Gy[72,82] = -39.6392229058202
        struct[0].Gy[72,83] = -10.2713736253513
        struct[0].Gy[72,84] = -24.9575997948692
        struct[0].Gy[72,85] = -23.2849644809540
        struct[0].Gy[72,86] = -39.6392229058202
        struct[0].Gy[72,87] = -10.2713736253513
        struct[0].Gy[73,64] = -54.0657727682604
        struct[0].Gy[73,65] = 105.571769313180
        struct[0].Gy[73,66] = 10.2713736253513
        struct[0].Gy[73,67] = -39.6392229058202
        struct[0].Gy[73,68] = 23.2849644809540
        struct[0].Gy[73,69] = -24.9575997948692
        struct[0].Gy[73,70] = 10.2713736253513
        struct[0].Gy[73,71] = -39.6392229058202
        struct[0].Gy[73,72] = 108.131545536521
        struct[0].Gy[73,73] = -211.143538626360
        struct[0].Gy[73,74] = -20.5427472507027
        struct[0].Gy[73,75] = 79.2784458116403
        struct[0].Gy[73,76] = -46.5699289619080
        struct[0].Gy[73,77] = 49.9151995897384
        struct[0].Gy[73,78] = -20.5427472507027
        struct[0].Gy[73,79] = 79.2784458116403
        struct[0].Gy[73,80] = -54.0657727682604
        struct[0].Gy[73,81] = 105.571769313180
        struct[0].Gy[73,82] = 10.2713736253513
        struct[0].Gy[73,83] = -39.6392229058202
        struct[0].Gy[73,84] = 23.2849644809540
        struct[0].Gy[73,85] = -24.9575997948692
        struct[0].Gy[73,86] = 10.2713736253513
        struct[0].Gy[73,87] = -39.6392229058202
        struct[0].Gy[74,64] = -39.6392229058202
        struct[0].Gy[74,65] = -10.2713736253513
        struct[0].Gy[74,66] = 105.571769313180
        struct[0].Gy[74,67] = 54.0657727682604
        struct[0].Gy[74,68] = -39.6392229058201
        struct[0].Gy[74,69] = -10.2713736253513
        struct[0].Gy[74,70] = -24.9575997948692
        struct[0].Gy[74,71] = -23.2849644809540
        struct[0].Gy[74,72] = 79.2784458116403
        struct[0].Gy[74,73] = 20.5427472507027
        struct[0].Gy[74,74] = -211.143538626360
        struct[0].Gy[74,75] = -108.131545536521
        struct[0].Gy[74,76] = 79.2784458116403
        struct[0].Gy[74,77] = 20.5427472507027
        struct[0].Gy[74,78] = 49.9151995897384
        struct[0].Gy[74,79] = 46.5699289619080
        struct[0].Gy[74,80] = -39.6392229058202
        struct[0].Gy[74,81] = -10.2713736253513
        struct[0].Gy[74,82] = 105.571769313180
        struct[0].Gy[74,83] = 54.0657727682604
        struct[0].Gy[74,84] = -39.6392229058201
        struct[0].Gy[74,85] = -10.2713736253513
        struct[0].Gy[74,86] = -24.9575997948692
        struct[0].Gy[74,87] = -23.2849644809540
        struct[0].Gy[75,64] = 10.2713736253513
        struct[0].Gy[75,65] = -39.6392229058202
        struct[0].Gy[75,66] = -54.0657727682604
        struct[0].Gy[75,67] = 105.571769313180
        struct[0].Gy[75,68] = 10.2713736253513
        struct[0].Gy[75,69] = -39.6392229058201
        struct[0].Gy[75,70] = 23.2849644809540
        struct[0].Gy[75,71] = -24.9575997948692
        struct[0].Gy[75,72] = -20.5427472507027
        struct[0].Gy[75,73] = 79.2784458116403
        struct[0].Gy[75,74] = 108.131545536521
        struct[0].Gy[75,75] = -211.143538626360
        struct[0].Gy[75,76] = -20.5427472507027
        struct[0].Gy[75,77] = 79.2784458116403
        struct[0].Gy[75,78] = -46.5699289619080
        struct[0].Gy[75,79] = 49.9151995897384
        struct[0].Gy[75,80] = 10.2713736253513
        struct[0].Gy[75,81] = -39.6392229058202
        struct[0].Gy[75,82] = -54.0657727682604
        struct[0].Gy[75,83] = 105.571769313180
        struct[0].Gy[75,84] = 10.2713736253513
        struct[0].Gy[75,85] = -39.6392229058201
        struct[0].Gy[75,86] = 23.2849644809540
        struct[0].Gy[75,87] = -24.9575997948692
        struct[0].Gy[76,64] = -24.9575997948692
        struct[0].Gy[76,65] = -23.2849644809540
        struct[0].Gy[76,66] = -39.6392229058202
        struct[0].Gy[76,67] = -10.2713736253513
        struct[0].Gy[76,68] = 105.571769313180
        struct[0].Gy[76,69] = 54.0657727682604
        struct[0].Gy[76,70] = -39.6392229058201
        struct[0].Gy[76,71] = -10.2713736253514
        struct[0].Gy[76,72] = 49.9151995897384
        struct[0].Gy[76,73] = 46.5699289619080
        struct[0].Gy[76,74] = 79.2784458116404
        struct[0].Gy[76,75] = 20.5427472507027
        struct[0].Gy[76,76] = -211.143538626360
        struct[0].Gy[76,77] = -108.131545536521
        struct[0].Gy[76,78] = 79.2784458116403
        struct[0].Gy[76,79] = 20.5427472507027
        struct[0].Gy[76,80] = -24.9575997948692
        struct[0].Gy[76,81] = -23.2849644809540
        struct[0].Gy[76,82] = -39.6392229058202
        struct[0].Gy[76,83] = -10.2713736253513
        struct[0].Gy[76,84] = 105.571769313180
        struct[0].Gy[76,85] = 54.0657727682604
        struct[0].Gy[76,86] = -39.6392229058201
        struct[0].Gy[76,87] = -10.2713736253514
        struct[0].Gy[77,64] = 23.2849644809540
        struct[0].Gy[77,65] = -24.9575997948692
        struct[0].Gy[77,66] = 10.2713736253513
        struct[0].Gy[77,67] = -39.6392229058202
        struct[0].Gy[77,68] = -54.0657727682604
        struct[0].Gy[77,69] = 105.571769313180
        struct[0].Gy[77,70] = 10.2713736253514
        struct[0].Gy[77,71] = -39.6392229058201
        struct[0].Gy[77,72] = -46.5699289619080
        struct[0].Gy[77,73] = 49.9151995897384
        struct[0].Gy[77,74] = -20.5427472507027
        struct[0].Gy[77,75] = 79.2784458116404
        struct[0].Gy[77,76] = 108.131545536521
        struct[0].Gy[77,77] = -211.143538626360
        struct[0].Gy[77,78] = -20.5427472507027
        struct[0].Gy[77,79] = 79.2784458116403
        struct[0].Gy[77,80] = 23.2849644809540
        struct[0].Gy[77,81] = -24.9575997948692
        struct[0].Gy[77,82] = 10.2713736253513
        struct[0].Gy[77,83] = -39.6392229058202
        struct[0].Gy[77,84] = -54.0657727682604
        struct[0].Gy[77,85] = 105.571769313180
        struct[0].Gy[77,86] = 10.2713736253514
        struct[0].Gy[77,87] = -39.6392229058201
        struct[0].Gy[78,64] = -39.6392229058202
        struct[0].Gy[78,65] = -10.2713736253513
        struct[0].Gy[78,66] = -24.9575997948692
        struct[0].Gy[78,67] = -23.2849644809540
        struct[0].Gy[78,68] = -39.6392229058202
        struct[0].Gy[78,69] = -10.2713736253513
        struct[0].Gy[78,70] = 105.571769313180
        struct[0].Gy[78,71] = 54.0657727682604
        struct[0].Gy[78,72] = 79.2784458116403
        struct[0].Gy[78,73] = 20.5427472507027
        struct[0].Gy[78,74] = 49.9151995897384
        struct[0].Gy[78,75] = 46.5699289619080
        struct[0].Gy[78,76] = 79.2784458116403
        struct[0].Gy[78,77] = 20.5427472507027
        struct[0].Gy[78,78] = -211.143538626360
        struct[0].Gy[78,79] = -108.131545536521
        struct[0].Gy[78,80] = -39.6392229058202
        struct[0].Gy[78,81] = -10.2713736253513
        struct[0].Gy[78,82] = -24.9575997948692
        struct[0].Gy[78,83] = -23.2849644809540
        struct[0].Gy[78,84] = -39.6392229058202
        struct[0].Gy[78,85] = -10.2713736253513
        struct[0].Gy[78,86] = 105.571769313180
        struct[0].Gy[78,87] = 54.0657727682604
        struct[0].Gy[79,64] = 10.2713736253513
        struct[0].Gy[79,65] = -39.6392229058202
        struct[0].Gy[79,66] = 23.2849644809540
        struct[0].Gy[79,67] = -24.9575997948692
        struct[0].Gy[79,68] = 10.2713736253513
        struct[0].Gy[79,69] = -39.6392229058202
        struct[0].Gy[79,70] = -54.0657727682604
        struct[0].Gy[79,71] = 105.571769313180
        struct[0].Gy[79,72] = -20.5427472507027
        struct[0].Gy[79,73] = 79.2784458116403
        struct[0].Gy[79,74] = -46.5699289619080
        struct[0].Gy[79,75] = 49.9151995897384
        struct[0].Gy[79,76] = -20.5427472507027
        struct[0].Gy[79,77] = 79.2784458116403
        struct[0].Gy[79,78] = 108.131545536521
        struct[0].Gy[79,79] = -211.143538626360
        struct[0].Gy[79,80] = 10.2713736253513
        struct[0].Gy[79,81] = -39.6392229058202
        struct[0].Gy[79,82] = 23.2849644809540
        struct[0].Gy[79,83] = -24.9575997948692
        struct[0].Gy[79,84] = 10.2713736253513
        struct[0].Gy[79,85] = -39.6392229058202
        struct[0].Gy[79,86] = -54.0657727682604
        struct[0].Gy[79,87] = 105.571769313180
        struct[0].Gy[80,16] = 30.9517475172273
        struct[0].Gy[80,17] = 5.65456401516768
        struct[0].Gy[80,18] = -9.21038227100566
        struct[0].Gy[80,19] = 1.84896616921897
        struct[0].Gy[80,72] = 105.571769313180
        struct[0].Gy[80,73] = 54.0657727682604
        struct[0].Gy[80,74] = -39.6392229058202
        struct[0].Gy[80,75] = -10.2713736253513
        struct[0].Gy[80,76] = -24.9575997948692
        struct[0].Gy[80,77] = -23.2849644809540
        struct[0].Gy[80,78] = -39.6392229058202
        struct[0].Gy[80,79] = -10.2713736253513
        struct[0].Gy[80,80] = -242.095286143588
        struct[0].Gy[80,81] = -113.786109551688
        struct[0].Gy[80,82] = 88.4888280826460
        struct[0].Gy[80,83] = 18.6937810814837
        struct[0].Gy[80,84] = 58.9235503101833
        struct[0].Gy[80,85] = 45.7766907664085
        struct[0].Gy[80,86] = 88.4888280826460
        struct[0].Gy[80,87] = 18.6937810814837
        struct[0].Gy[80,88] = 105.571769313180
        struct[0].Gy[80,89] = 54.0657727682604
        struct[0].Gy[80,90] = -39.6392229058202
        struct[0].Gy[80,91] = -10.2713736253513
        struct[0].Gy[80,92] = -24.9575997948692
        struct[0].Gy[80,93] = -23.2849644809540
        struct[0].Gy[80,94] = -39.6392229058202
        struct[0].Gy[80,95] = -10.2713736253513
        struct[0].Gy[80,152] = -9.21038227100566
        struct[0].Gy[80,153] = 1.84896616921897
        struct[0].Gy[80,154] = -9.00835072044485
        struct[0].Gy[80,155] = 0.793238195499529
        struct[0].Gy[81,16] = -5.65456401516768
        struct[0].Gy[81,17] = 30.9517475172273
        struct[0].Gy[81,18] = -1.84896616921897
        struct[0].Gy[81,19] = -9.21038227100566
        struct[0].Gy[81,72] = -54.0657727682604
        struct[0].Gy[81,73] = 105.571769313180
        struct[0].Gy[81,74] = 10.2713736253513
        struct[0].Gy[81,75] = -39.6392229058202
        struct[0].Gy[81,76] = 23.2849644809540
        struct[0].Gy[81,77] = -24.9575997948692
        struct[0].Gy[81,78] = 10.2713736253513
        struct[0].Gy[81,79] = -39.6392229058202
        struct[0].Gy[81,80] = 113.786109551688
        struct[0].Gy[81,81] = -242.095286143588
        struct[0].Gy[81,82] = -18.6937810814837
        struct[0].Gy[81,83] = 88.4888280826460
        struct[0].Gy[81,84] = -45.7766907664085
        struct[0].Gy[81,85] = 58.9235503101833
        struct[0].Gy[81,86] = -18.6937810814837
        struct[0].Gy[81,87] = 88.4888280826460
        struct[0].Gy[81,88] = -54.0657727682604
        struct[0].Gy[81,89] = 105.571769313180
        struct[0].Gy[81,90] = 10.2713736253513
        struct[0].Gy[81,91] = -39.6392229058202
        struct[0].Gy[81,92] = 23.2849644809540
        struct[0].Gy[81,93] = -24.9575997948692
        struct[0].Gy[81,94] = 10.2713736253513
        struct[0].Gy[81,95] = -39.6392229058202
        struct[0].Gy[81,152] = -1.84896616921897
        struct[0].Gy[81,153] = -9.21038227100566
        struct[0].Gy[81,154] = -0.793238195499529
        struct[0].Gy[81,155] = -9.00835072044485
        struct[0].Gy[82,16] = -9.21038227100566
        struct[0].Gy[82,17] = 1.84896616921897
        struct[0].Gy[82,18] = -9.00835072044485
        struct[0].Gy[82,19] = 0.793238195499528
        struct[0].Gy[82,72] = -39.6392229058202
        struct[0].Gy[82,73] = -10.2713736253513
        struct[0].Gy[82,74] = 105.571769313180
        struct[0].Gy[82,75] = 54.0657727682604
        struct[0].Gy[82,76] = -39.6392229058201
        struct[0].Gy[82,77] = -10.2713736253513
        struct[0].Gy[82,78] = -24.9575997948692
        struct[0].Gy[82,79] = -23.2849644809540
        struct[0].Gy[82,80] = 88.4888280826460
        struct[0].Gy[82,81] = 18.6937810814837
        struct[0].Gy[82,82] = -242.095286143588
        struct[0].Gy[82,83] = -113.786109551688
        struct[0].Gy[82,84] = 88.4888280826460
        struct[0].Gy[82,85] = 18.6937810814837
        struct[0].Gy[82,86] = 58.9235503101833
        struct[0].Gy[82,87] = 45.7766907664085
        struct[0].Gy[82,88] = -39.6392229058202
        struct[0].Gy[82,89] = -10.2713736253513
        struct[0].Gy[82,90] = 105.571769313180
        struct[0].Gy[82,91] = 54.0657727682604
        struct[0].Gy[82,92] = -39.6392229058201
        struct[0].Gy[82,93] = -10.2713736253513
        struct[0].Gy[82,94] = -24.9575997948692
        struct[0].Gy[82,95] = -23.2849644809540
        struct[0].Gy[82,152] = 30.9517475172273
        struct[0].Gy[82,153] = 5.65456401516768
        struct[0].Gy[82,154] = -9.21038227100566
        struct[0].Gy[82,155] = 1.84896616921897
        struct[0].Gy[83,16] = -1.84896616921897
        struct[0].Gy[83,17] = -9.21038227100566
        struct[0].Gy[83,18] = -0.793238195499528
        struct[0].Gy[83,19] = -9.00835072044485
        struct[0].Gy[83,72] = 10.2713736253513
        struct[0].Gy[83,73] = -39.6392229058202
        struct[0].Gy[83,74] = -54.0657727682604
        struct[0].Gy[83,75] = 105.571769313180
        struct[0].Gy[83,76] = 10.2713736253513
        struct[0].Gy[83,77] = -39.6392229058201
        struct[0].Gy[83,78] = 23.2849644809540
        struct[0].Gy[83,79] = -24.9575997948692
        struct[0].Gy[83,80] = -18.6937810814837
        struct[0].Gy[83,81] = 88.4888280826460
        struct[0].Gy[83,82] = 113.786109551688
        struct[0].Gy[83,83] = -242.095286143588
        struct[0].Gy[83,84] = -18.6937810814837
        struct[0].Gy[83,85] = 88.4888280826460
        struct[0].Gy[83,86] = -45.7766907664085
        struct[0].Gy[83,87] = 58.9235503101833
        struct[0].Gy[83,88] = 10.2713736253513
        struct[0].Gy[83,89] = -39.6392229058202
        struct[0].Gy[83,90] = -54.0657727682604
        struct[0].Gy[83,91] = 105.571769313180
        struct[0].Gy[83,92] = 10.2713736253513
        struct[0].Gy[83,93] = -39.6392229058201
        struct[0].Gy[83,94] = 23.2849644809540
        struct[0].Gy[83,95] = -24.9575997948692
        struct[0].Gy[83,152] = -5.65456401516768
        struct[0].Gy[83,153] = 30.9517475172273
        struct[0].Gy[83,154] = -1.84896616921897
        struct[0].Gy[83,155] = -9.21038227100566
        struct[0].Gy[84,16] = -9.00835072044484
        struct[0].Gy[84,17] = 0.793238195499527
        struct[0].Gy[84,18] = -9.21038227100566
        struct[0].Gy[84,19] = 1.84896616921897
        struct[0].Gy[84,72] = -24.9575997948692
        struct[0].Gy[84,73] = -23.2849644809540
        struct[0].Gy[84,74] = -39.6392229058202
        struct[0].Gy[84,75] = -10.2713736253513
        struct[0].Gy[84,76] = 105.571769313180
        struct[0].Gy[84,77] = 54.0657727682604
        struct[0].Gy[84,78] = -39.6392229058201
        struct[0].Gy[84,79] = -10.2713736253514
        struct[0].Gy[84,80] = 58.9235503101833
        struct[0].Gy[84,81] = 45.7766907664085
        struct[0].Gy[84,82] = 88.4888280826461
        struct[0].Gy[84,83] = 18.6937810814837
        struct[0].Gy[84,84] = -242.095286143588
        struct[0].Gy[84,85] = -113.786109551688
        struct[0].Gy[84,86] = 88.4888280826459
        struct[0].Gy[84,87] = 18.6937810814837
        struct[0].Gy[84,88] = -24.9575997948692
        struct[0].Gy[84,89] = -23.2849644809540
        struct[0].Gy[84,90] = -39.6392229058202
        struct[0].Gy[84,91] = -10.2713736253513
        struct[0].Gy[84,92] = 105.571769313180
        struct[0].Gy[84,93] = 54.0657727682604
        struct[0].Gy[84,94] = -39.6392229058201
        struct[0].Gy[84,95] = -10.2713736253514
        struct[0].Gy[84,152] = -9.21038227100566
        struct[0].Gy[84,153] = 1.84896616921897
        struct[0].Gy[84,154] = 30.9517475172273
        struct[0].Gy[84,155] = 5.65456401516768
        struct[0].Gy[85,16] = -0.793238195499527
        struct[0].Gy[85,17] = -9.00835072044484
        struct[0].Gy[85,18] = -1.84896616921897
        struct[0].Gy[85,19] = -9.21038227100566
        struct[0].Gy[85,72] = 23.2849644809540
        struct[0].Gy[85,73] = -24.9575997948692
        struct[0].Gy[85,74] = 10.2713736253513
        struct[0].Gy[85,75] = -39.6392229058202
        struct[0].Gy[85,76] = -54.0657727682604
        struct[0].Gy[85,77] = 105.571769313180
        struct[0].Gy[85,78] = 10.2713736253514
        struct[0].Gy[85,79] = -39.6392229058201
        struct[0].Gy[85,80] = -45.7766907664085
        struct[0].Gy[85,81] = 58.9235503101833
        struct[0].Gy[85,82] = -18.6937810814837
        struct[0].Gy[85,83] = 88.4888280826461
        struct[0].Gy[85,84] = 113.786109551688
        struct[0].Gy[85,85] = -242.095286143588
        struct[0].Gy[85,86] = -18.6937810814837
        struct[0].Gy[85,87] = 88.4888280826459
        struct[0].Gy[85,88] = 23.2849644809540
        struct[0].Gy[85,89] = -24.9575997948692
        struct[0].Gy[85,90] = 10.2713736253513
        struct[0].Gy[85,91] = -39.6392229058202
        struct[0].Gy[85,92] = -54.0657727682604
        struct[0].Gy[85,93] = 105.571769313180
        struct[0].Gy[85,94] = 10.2713736253514
        struct[0].Gy[85,95] = -39.6392229058201
        struct[0].Gy[85,152] = -1.84896616921897
        struct[0].Gy[85,153] = -9.21038227100566
        struct[0].Gy[85,154] = -5.65456401516768
        struct[0].Gy[85,155] = 30.9517475172273
        struct[0].Gy[86,16] = -9.21038227100566
        struct[0].Gy[86,17] = 1.84896616921897
        struct[0].Gy[86,18] = 30.9517475172273
        struct[0].Gy[86,19] = 5.65456401516768
        struct[0].Gy[86,72] = -39.6392229058202
        struct[0].Gy[86,73] = -10.2713736253513
        struct[0].Gy[86,74] = -24.9575997948692
        struct[0].Gy[86,75] = -23.2849644809540
        struct[0].Gy[86,76] = -39.6392229058202
        struct[0].Gy[86,77] = -10.2713736253513
        struct[0].Gy[86,78] = 105.571769313180
        struct[0].Gy[86,79] = 54.0657727682604
        struct[0].Gy[86,80] = 88.4888280826460
        struct[0].Gy[86,81] = 18.6937810814837
        struct[0].Gy[86,82] = 58.9235503101832
        struct[0].Gy[86,83] = 45.7766907664085
        struct[0].Gy[86,84] = 88.4888280826460
        struct[0].Gy[86,85] = 18.6937810814837
        struct[0].Gy[86,86] = -242.120286143588
        struct[0].Gy[86,87] = -113.786109551688
        struct[0].Gy[86,88] = -39.6392229058202
        struct[0].Gy[86,89] = -10.2713736253513
        struct[0].Gy[86,90] = -24.9575997948692
        struct[0].Gy[86,91] = -23.2849644809540
        struct[0].Gy[86,92] = -39.6392229058202
        struct[0].Gy[86,93] = -10.2713736253513
        struct[0].Gy[86,94] = 105.571769313180
        struct[0].Gy[86,95] = 54.0657727682604
        struct[0].Gy[86,152] = -9.00835072044485
        struct[0].Gy[86,153] = 0.793238195499527
        struct[0].Gy[86,154] = -9.21038227100566
        struct[0].Gy[86,155] = 1.84896616921897
        struct[0].Gy[87,16] = -1.84896616921897
        struct[0].Gy[87,17] = -9.21038227100566
        struct[0].Gy[87,18] = -5.65456401516768
        struct[0].Gy[87,19] = 30.9517475172273
        struct[0].Gy[87,72] = 10.2713736253513
        struct[0].Gy[87,73] = -39.6392229058202
        struct[0].Gy[87,74] = 23.2849644809540
        struct[0].Gy[87,75] = -24.9575997948692
        struct[0].Gy[87,76] = 10.2713736253513
        struct[0].Gy[87,77] = -39.6392229058202
        struct[0].Gy[87,78] = -54.0657727682604
        struct[0].Gy[87,79] = 105.571769313180
        struct[0].Gy[87,80] = -18.6937810814837
        struct[0].Gy[87,81] = 88.4888280826460
        struct[0].Gy[87,82] = -45.7766907664085
        struct[0].Gy[87,83] = 58.9235503101832
        struct[0].Gy[87,84] = -18.6937810814837
        struct[0].Gy[87,85] = 88.4888280826460
        struct[0].Gy[87,86] = 113.786109551688
        struct[0].Gy[87,87] = -242.120286143588
        struct[0].Gy[87,88] = 10.2713736253513
        struct[0].Gy[87,89] = -39.6392229058202
        struct[0].Gy[87,90] = 23.2849644809540
        struct[0].Gy[87,91] = -24.9575997948692
        struct[0].Gy[87,92] = 10.2713736253513
        struct[0].Gy[87,93] = -39.6392229058202
        struct[0].Gy[87,94] = -54.0657727682604
        struct[0].Gy[87,95] = 105.571769313180
        struct[0].Gy[87,152] = -0.793238195499527
        struct[0].Gy[87,153] = -9.00835072044485
        struct[0].Gy[87,154] = -1.84896616921897
        struct[0].Gy[87,155] = -9.21038227100566
        struct[0].Gy[88,80] = 105.571769313180
        struct[0].Gy[88,81] = 54.0657727682604
        struct[0].Gy[88,82] = -39.6392229058202
        struct[0].Gy[88,83] = -10.2713736253513
        struct[0].Gy[88,84] = -24.9575997948692
        struct[0].Gy[88,85] = -23.2849644809540
        struct[0].Gy[88,86] = -39.6392229058202
        struct[0].Gy[88,87] = -10.2713736253513
        struct[0].Gy[88,88] = -211.143538626360
        struct[0].Gy[88,89] = -108.131545536521
        struct[0].Gy[88,90] = 79.2784458116403
        struct[0].Gy[88,91] = 20.5427472507027
        struct[0].Gy[88,92] = 49.9151995897384
        struct[0].Gy[88,93] = 46.5699289619080
        struct[0].Gy[88,94] = 79.2784458116403
        struct[0].Gy[88,95] = 20.5427472507027
        struct[0].Gy[88,96] = 105.571769313180
        struct[0].Gy[88,97] = 54.0657727682604
        struct[0].Gy[88,98] = -39.6392229058202
        struct[0].Gy[88,99] = -10.2713736253513
        struct[0].Gy[88,100] = -24.9575997948692
        struct[0].Gy[88,101] = -23.2849644809540
        struct[0].Gy[88,102] = -39.6392229058202
        struct[0].Gy[88,103] = -10.2713736253513
        struct[0].Gy[89,80] = -54.0657727682604
        struct[0].Gy[89,81] = 105.571769313180
        struct[0].Gy[89,82] = 10.2713736253513
        struct[0].Gy[89,83] = -39.6392229058202
        struct[0].Gy[89,84] = 23.2849644809540
        struct[0].Gy[89,85] = -24.9575997948692
        struct[0].Gy[89,86] = 10.2713736253513
        struct[0].Gy[89,87] = -39.6392229058202
        struct[0].Gy[89,88] = 108.131545536521
        struct[0].Gy[89,89] = -211.143538626360
        struct[0].Gy[89,90] = -20.5427472507027
        struct[0].Gy[89,91] = 79.2784458116403
        struct[0].Gy[89,92] = -46.5699289619080
        struct[0].Gy[89,93] = 49.9151995897384
        struct[0].Gy[89,94] = -20.5427472507027
        struct[0].Gy[89,95] = 79.2784458116403
        struct[0].Gy[89,96] = -54.0657727682604
        struct[0].Gy[89,97] = 105.571769313180
        struct[0].Gy[89,98] = 10.2713736253513
        struct[0].Gy[89,99] = -39.6392229058202
        struct[0].Gy[89,100] = 23.2849644809540
        struct[0].Gy[89,101] = -24.9575997948692
        struct[0].Gy[89,102] = 10.2713736253513
        struct[0].Gy[89,103] = -39.6392229058202
        struct[0].Gy[90,80] = -39.6392229058202
        struct[0].Gy[90,81] = -10.2713736253513
        struct[0].Gy[90,82] = 105.571769313180
        struct[0].Gy[90,83] = 54.0657727682604
        struct[0].Gy[90,84] = -39.6392229058201
        struct[0].Gy[90,85] = -10.2713736253513
        struct[0].Gy[90,86] = -24.9575997948692
        struct[0].Gy[90,87] = -23.2849644809540
        struct[0].Gy[90,88] = 79.2784458116403
        struct[0].Gy[90,89] = 20.5427472507027
        struct[0].Gy[90,90] = -211.143538626360
        struct[0].Gy[90,91] = -108.131545536521
        struct[0].Gy[90,92] = 79.2784458116403
        struct[0].Gy[90,93] = 20.5427472507027
        struct[0].Gy[90,94] = 49.9151995897384
        struct[0].Gy[90,95] = 46.5699289619080
        struct[0].Gy[90,96] = -39.6392229058202
        struct[0].Gy[90,97] = -10.2713736253513
        struct[0].Gy[90,98] = 105.571769313180
        struct[0].Gy[90,99] = 54.0657727682604
        struct[0].Gy[90,100] = -39.6392229058201
        struct[0].Gy[90,101] = -10.2713736253513
        struct[0].Gy[90,102] = -24.9575997948692
        struct[0].Gy[90,103] = -23.2849644809540
        struct[0].Gy[91,80] = 10.2713736253513
        struct[0].Gy[91,81] = -39.6392229058202
        struct[0].Gy[91,82] = -54.0657727682604
        struct[0].Gy[91,83] = 105.571769313180
        struct[0].Gy[91,84] = 10.2713736253513
        struct[0].Gy[91,85] = -39.6392229058201
        struct[0].Gy[91,86] = 23.2849644809540
        struct[0].Gy[91,87] = -24.9575997948692
        struct[0].Gy[91,88] = -20.5427472507027
        struct[0].Gy[91,89] = 79.2784458116403
        struct[0].Gy[91,90] = 108.131545536521
        struct[0].Gy[91,91] = -211.143538626360
        struct[0].Gy[91,92] = -20.5427472507027
        struct[0].Gy[91,93] = 79.2784458116403
        struct[0].Gy[91,94] = -46.5699289619080
        struct[0].Gy[91,95] = 49.9151995897384
        struct[0].Gy[91,96] = 10.2713736253513
        struct[0].Gy[91,97] = -39.6392229058202
        struct[0].Gy[91,98] = -54.0657727682604
        struct[0].Gy[91,99] = 105.571769313180
        struct[0].Gy[91,100] = 10.2713736253513
        struct[0].Gy[91,101] = -39.6392229058201
        struct[0].Gy[91,102] = 23.2849644809540
        struct[0].Gy[91,103] = -24.9575997948692
        struct[0].Gy[92,80] = -24.9575997948692
        struct[0].Gy[92,81] = -23.2849644809540
        struct[0].Gy[92,82] = -39.6392229058202
        struct[0].Gy[92,83] = -10.2713736253513
        struct[0].Gy[92,84] = 105.571769313180
        struct[0].Gy[92,85] = 54.0657727682604
        struct[0].Gy[92,86] = -39.6392229058201
        struct[0].Gy[92,87] = -10.2713736253514
        struct[0].Gy[92,88] = 49.9151995897384
        struct[0].Gy[92,89] = 46.5699289619080
        struct[0].Gy[92,90] = 79.2784458116404
        struct[0].Gy[92,91] = 20.5427472507027
        struct[0].Gy[92,92] = -211.143538626360
        struct[0].Gy[92,93] = -108.131545536521
        struct[0].Gy[92,94] = 79.2784458116403
        struct[0].Gy[92,95] = 20.5427472507027
        struct[0].Gy[92,96] = -24.9575997948692
        struct[0].Gy[92,97] = -23.2849644809540
        struct[0].Gy[92,98] = -39.6392229058202
        struct[0].Gy[92,99] = -10.2713736253513
        struct[0].Gy[92,100] = 105.571769313180
        struct[0].Gy[92,101] = 54.0657727682604
        struct[0].Gy[92,102] = -39.6392229058201
        struct[0].Gy[92,103] = -10.2713736253514
        struct[0].Gy[93,80] = 23.2849644809540
        struct[0].Gy[93,81] = -24.9575997948692
        struct[0].Gy[93,82] = 10.2713736253513
        struct[0].Gy[93,83] = -39.6392229058202
        struct[0].Gy[93,84] = -54.0657727682604
        struct[0].Gy[93,85] = 105.571769313180
        struct[0].Gy[93,86] = 10.2713736253514
        struct[0].Gy[93,87] = -39.6392229058201
        struct[0].Gy[93,88] = -46.5699289619080
        struct[0].Gy[93,89] = 49.9151995897384
        struct[0].Gy[93,90] = -20.5427472507027
        struct[0].Gy[93,91] = 79.2784458116404
        struct[0].Gy[93,92] = 108.131545536521
        struct[0].Gy[93,93] = -211.143538626360
        struct[0].Gy[93,94] = -20.5427472507027
        struct[0].Gy[93,95] = 79.2784458116403
        struct[0].Gy[93,96] = 23.2849644809540
        struct[0].Gy[93,97] = -24.9575997948692
        struct[0].Gy[93,98] = 10.2713736253513
        struct[0].Gy[93,99] = -39.6392229058202
        struct[0].Gy[93,100] = -54.0657727682604
        struct[0].Gy[93,101] = 105.571769313180
        struct[0].Gy[93,102] = 10.2713736253514
        struct[0].Gy[93,103] = -39.6392229058201
        struct[0].Gy[94,80] = -39.6392229058202
        struct[0].Gy[94,81] = -10.2713736253513
        struct[0].Gy[94,82] = -24.9575997948692
        struct[0].Gy[94,83] = -23.2849644809540
        struct[0].Gy[94,84] = -39.6392229058202
        struct[0].Gy[94,85] = -10.2713736253513
        struct[0].Gy[94,86] = 105.571769313180
        struct[0].Gy[94,87] = 54.0657727682604
        struct[0].Gy[94,88] = 79.2784458116403
        struct[0].Gy[94,89] = 20.5427472507027
        struct[0].Gy[94,90] = 49.9151995897384
        struct[0].Gy[94,91] = 46.5699289619080
        struct[0].Gy[94,92] = 79.2784458116403
        struct[0].Gy[94,93] = 20.5427472507027
        struct[0].Gy[94,94] = -211.143538626360
        struct[0].Gy[94,95] = -108.131545536521
        struct[0].Gy[94,96] = -39.6392229058202
        struct[0].Gy[94,97] = -10.2713736253513
        struct[0].Gy[94,98] = -24.9575997948692
        struct[0].Gy[94,99] = -23.2849644809540
        struct[0].Gy[94,100] = -39.6392229058202
        struct[0].Gy[94,101] = -10.2713736253513
        struct[0].Gy[94,102] = 105.571769313180
        struct[0].Gy[94,103] = 54.0657727682604
        struct[0].Gy[95,80] = 10.2713736253513
        struct[0].Gy[95,81] = -39.6392229058202
        struct[0].Gy[95,82] = 23.2849644809540
        struct[0].Gy[95,83] = -24.9575997948692
        struct[0].Gy[95,84] = 10.2713736253513
        struct[0].Gy[95,85] = -39.6392229058202
        struct[0].Gy[95,86] = -54.0657727682604
        struct[0].Gy[95,87] = 105.571769313180
        struct[0].Gy[95,88] = -20.5427472507027
        struct[0].Gy[95,89] = 79.2784458116403
        struct[0].Gy[95,90] = -46.5699289619080
        struct[0].Gy[95,91] = 49.9151995897384
        struct[0].Gy[95,92] = -20.5427472507027
        struct[0].Gy[95,93] = 79.2784458116403
        struct[0].Gy[95,94] = 108.131545536521
        struct[0].Gy[95,95] = -211.143538626360
        struct[0].Gy[95,96] = 10.2713736253513
        struct[0].Gy[95,97] = -39.6392229058202
        struct[0].Gy[95,98] = 23.2849644809540
        struct[0].Gy[95,99] = -24.9575997948692
        struct[0].Gy[95,100] = 10.2713736253513
        struct[0].Gy[95,101] = -39.6392229058202
        struct[0].Gy[95,102] = -54.0657727682604
        struct[0].Gy[95,103] = 105.571769313180
        struct[0].Gy[96,88] = 105.571769313180
        struct[0].Gy[96,89] = 54.0657727682604
        struct[0].Gy[96,90] = -39.6392229058202
        struct[0].Gy[96,91] = -10.2713736253513
        struct[0].Gy[96,92] = -24.9575997948692
        struct[0].Gy[96,93] = -23.2849644809540
        struct[0].Gy[96,94] = -39.6392229058202
        struct[0].Gy[96,95] = -10.2713736253513
        struct[0].Gy[96,96] = -211.143538626360
        struct[0].Gy[96,97] = -108.131545536521
        struct[0].Gy[96,98] = 79.2784458116403
        struct[0].Gy[96,99] = 20.5427472507027
        struct[0].Gy[96,100] = 49.9151995897384
        struct[0].Gy[96,101] = 46.5699289619080
        struct[0].Gy[96,102] = 79.2784458116403
        struct[0].Gy[96,103] = 20.5427472507027
        struct[0].Gy[96,104] = 105.571769313180
        struct[0].Gy[96,105] = 54.0657727682604
        struct[0].Gy[96,106] = -39.6392229058202
        struct[0].Gy[96,107] = -10.2713736253513
        struct[0].Gy[96,108] = -24.9575997948692
        struct[0].Gy[96,109] = -23.2849644809540
        struct[0].Gy[96,110] = -39.6392229058202
        struct[0].Gy[96,111] = -10.2713736253513
        struct[0].Gy[97,88] = -54.0657727682604
        struct[0].Gy[97,89] = 105.571769313180
        struct[0].Gy[97,90] = 10.2713736253513
        struct[0].Gy[97,91] = -39.6392229058202
        struct[0].Gy[97,92] = 23.2849644809540
        struct[0].Gy[97,93] = -24.9575997948692
        struct[0].Gy[97,94] = 10.2713736253513
        struct[0].Gy[97,95] = -39.6392229058202
        struct[0].Gy[97,96] = 108.131545536521
        struct[0].Gy[97,97] = -211.143538626360
        struct[0].Gy[97,98] = -20.5427472507027
        struct[0].Gy[97,99] = 79.2784458116403
        struct[0].Gy[97,100] = -46.5699289619080
        struct[0].Gy[97,101] = 49.9151995897384
        struct[0].Gy[97,102] = -20.5427472507027
        struct[0].Gy[97,103] = 79.2784458116403
        struct[0].Gy[97,104] = -54.0657727682604
        struct[0].Gy[97,105] = 105.571769313180
        struct[0].Gy[97,106] = 10.2713736253513
        struct[0].Gy[97,107] = -39.6392229058202
        struct[0].Gy[97,108] = 23.2849644809540
        struct[0].Gy[97,109] = -24.9575997948692
        struct[0].Gy[97,110] = 10.2713736253513
        struct[0].Gy[97,111] = -39.6392229058202
        struct[0].Gy[98,88] = -39.6392229058202
        struct[0].Gy[98,89] = -10.2713736253513
        struct[0].Gy[98,90] = 105.571769313180
        struct[0].Gy[98,91] = 54.0657727682604
        struct[0].Gy[98,92] = -39.6392229058201
        struct[0].Gy[98,93] = -10.2713736253513
        struct[0].Gy[98,94] = -24.9575997948692
        struct[0].Gy[98,95] = -23.2849644809540
        struct[0].Gy[98,96] = 79.2784458116403
        struct[0].Gy[98,97] = 20.5427472507027
        struct[0].Gy[98,98] = -211.143538626360
        struct[0].Gy[98,99] = -108.131545536521
        struct[0].Gy[98,100] = 79.2784458116403
        struct[0].Gy[98,101] = 20.5427472507027
        struct[0].Gy[98,102] = 49.9151995897384
        struct[0].Gy[98,103] = 46.5699289619080
        struct[0].Gy[98,104] = -39.6392229058202
        struct[0].Gy[98,105] = -10.2713736253513
        struct[0].Gy[98,106] = 105.571769313180
        struct[0].Gy[98,107] = 54.0657727682604
        struct[0].Gy[98,108] = -39.6392229058201
        struct[0].Gy[98,109] = -10.2713736253513
        struct[0].Gy[98,110] = -24.9575997948692
        struct[0].Gy[98,111] = -23.2849644809540
        struct[0].Gy[99,88] = 10.2713736253513
        struct[0].Gy[99,89] = -39.6392229058202
        struct[0].Gy[99,90] = -54.0657727682604
        struct[0].Gy[99,91] = 105.571769313180
        struct[0].Gy[99,92] = 10.2713736253513
        struct[0].Gy[99,93] = -39.6392229058201
        struct[0].Gy[99,94] = 23.2849644809540
        struct[0].Gy[99,95] = -24.9575997948692
        struct[0].Gy[99,96] = -20.5427472507027
        struct[0].Gy[99,97] = 79.2784458116403
        struct[0].Gy[99,98] = 108.131545536521
        struct[0].Gy[99,99] = -211.143538626360
        struct[0].Gy[99,100] = -20.5427472507027
        struct[0].Gy[99,101] = 79.2784458116403
        struct[0].Gy[99,102] = -46.5699289619080
        struct[0].Gy[99,103] = 49.9151995897384
        struct[0].Gy[99,104] = 10.2713736253513
        struct[0].Gy[99,105] = -39.6392229058202
        struct[0].Gy[99,106] = -54.0657727682604
        struct[0].Gy[99,107] = 105.571769313180
        struct[0].Gy[99,108] = 10.2713736253513
        struct[0].Gy[99,109] = -39.6392229058201
        struct[0].Gy[99,110] = 23.2849644809540
        struct[0].Gy[99,111] = -24.9575997948692
        struct[0].Gy[100,88] = -24.9575997948692
        struct[0].Gy[100,89] = -23.2849644809540
        struct[0].Gy[100,90] = -39.6392229058202
        struct[0].Gy[100,91] = -10.2713736253513
        struct[0].Gy[100,92] = 105.571769313180
        struct[0].Gy[100,93] = 54.0657727682604
        struct[0].Gy[100,94] = -39.6392229058201
        struct[0].Gy[100,95] = -10.2713736253514
        struct[0].Gy[100,96] = 49.9151995897384
        struct[0].Gy[100,97] = 46.5699289619080
        struct[0].Gy[100,98] = 79.2784458116404
        struct[0].Gy[100,99] = 20.5427472507027
        struct[0].Gy[100,100] = -211.143538626360
        struct[0].Gy[100,101] = -108.131545536521
        struct[0].Gy[100,102] = 79.2784458116403
        struct[0].Gy[100,103] = 20.5427472507027
        struct[0].Gy[100,104] = -24.9575997948692
        struct[0].Gy[100,105] = -23.2849644809540
        struct[0].Gy[100,106] = -39.6392229058202
        struct[0].Gy[100,107] = -10.2713736253513
        struct[0].Gy[100,108] = 105.571769313180
        struct[0].Gy[100,109] = 54.0657727682604
        struct[0].Gy[100,110] = -39.6392229058201
        struct[0].Gy[100,111] = -10.2713736253514
        struct[0].Gy[101,88] = 23.2849644809540
        struct[0].Gy[101,89] = -24.9575997948692
        struct[0].Gy[101,90] = 10.2713736253513
        struct[0].Gy[101,91] = -39.6392229058202
        struct[0].Gy[101,92] = -54.0657727682604
        struct[0].Gy[101,93] = 105.571769313180
        struct[0].Gy[101,94] = 10.2713736253514
        struct[0].Gy[101,95] = -39.6392229058201
        struct[0].Gy[101,96] = -46.5699289619080
        struct[0].Gy[101,97] = 49.9151995897384
        struct[0].Gy[101,98] = -20.5427472507027
        struct[0].Gy[101,99] = 79.2784458116404
        struct[0].Gy[101,100] = 108.131545536521
        struct[0].Gy[101,101] = -211.143538626360
        struct[0].Gy[101,102] = -20.5427472507027
        struct[0].Gy[101,103] = 79.2784458116403
        struct[0].Gy[101,104] = 23.2849644809540
        struct[0].Gy[101,105] = -24.9575997948692
        struct[0].Gy[101,106] = 10.2713736253513
        struct[0].Gy[101,107] = -39.6392229058202
        struct[0].Gy[101,108] = -54.0657727682604
        struct[0].Gy[101,109] = 105.571769313180
        struct[0].Gy[101,110] = 10.2713736253514
        struct[0].Gy[101,111] = -39.6392229058201
        struct[0].Gy[102,88] = -39.6392229058202
        struct[0].Gy[102,89] = -10.2713736253513
        struct[0].Gy[102,90] = -24.9575997948692
        struct[0].Gy[102,91] = -23.2849644809540
        struct[0].Gy[102,92] = -39.6392229058202
        struct[0].Gy[102,93] = -10.2713736253513
        struct[0].Gy[102,94] = 105.571769313180
        struct[0].Gy[102,95] = 54.0657727682604
        struct[0].Gy[102,96] = 79.2784458116403
        struct[0].Gy[102,97] = 20.5427472507027
        struct[0].Gy[102,98] = 49.9151995897384
        struct[0].Gy[102,99] = 46.5699289619080
        struct[0].Gy[102,100] = 79.2784458116403
        struct[0].Gy[102,101] = 20.5427472507027
        struct[0].Gy[102,102] = -211.168538626360
        struct[0].Gy[102,103] = -108.131545536521
        struct[0].Gy[102,104] = -39.6392229058202
        struct[0].Gy[102,105] = -10.2713736253513
        struct[0].Gy[102,106] = -24.9575997948692
        struct[0].Gy[102,107] = -23.2849644809540
        struct[0].Gy[102,108] = -39.6392229058202
        struct[0].Gy[102,109] = -10.2713736253513
        struct[0].Gy[102,110] = 105.571769313180
        struct[0].Gy[102,111] = 54.0657727682604
        struct[0].Gy[103,88] = 10.2713736253513
        struct[0].Gy[103,89] = -39.6392229058202
        struct[0].Gy[103,90] = 23.2849644809540
        struct[0].Gy[103,91] = -24.9575997948692
        struct[0].Gy[103,92] = 10.2713736253513
        struct[0].Gy[103,93] = -39.6392229058202
        struct[0].Gy[103,94] = -54.0657727682604
        struct[0].Gy[103,95] = 105.571769313180
        struct[0].Gy[103,96] = -20.5427472507027
        struct[0].Gy[103,97] = 79.2784458116403
        struct[0].Gy[103,98] = -46.5699289619080
        struct[0].Gy[103,99] = 49.9151995897384
        struct[0].Gy[103,100] = -20.5427472507027
        struct[0].Gy[103,101] = 79.2784458116403
        struct[0].Gy[103,102] = 108.131545536521
        struct[0].Gy[103,103] = -211.168538626360
        struct[0].Gy[103,104] = 10.2713736253513
        struct[0].Gy[103,105] = -39.6392229058202
        struct[0].Gy[103,106] = 23.2849644809540
        struct[0].Gy[103,107] = -24.9575997948692
        struct[0].Gy[103,108] = 10.2713736253513
        struct[0].Gy[103,109] = -39.6392229058202
        struct[0].Gy[103,110] = -54.0657727682604
        struct[0].Gy[103,111] = 105.571769313180
        struct[0].Gy[104,20] = 30.9517475172273
        struct[0].Gy[104,21] = 5.65456401516768
        struct[0].Gy[104,22] = -9.21038227100566
        struct[0].Gy[104,23] = 1.84896616921897
        struct[0].Gy[104,96] = 105.571769313180
        struct[0].Gy[104,97] = 54.0657727682604
        struct[0].Gy[104,98] = -39.6392229058202
        struct[0].Gy[104,99] = -10.2713736253513
        struct[0].Gy[104,100] = -24.9575997948692
        struct[0].Gy[104,101] = -23.2849644809540
        struct[0].Gy[104,102] = -39.6392229058202
        struct[0].Gy[104,103] = -10.2713736253513
        struct[0].Gy[104,104] = -242.095286143588
        struct[0].Gy[104,105] = -113.786109551688
        struct[0].Gy[104,106] = 88.4888280826460
        struct[0].Gy[104,107] = 18.6937810814837
        struct[0].Gy[104,108] = 58.9235503101833
        struct[0].Gy[104,109] = 45.7766907664085
        struct[0].Gy[104,110] = 88.4888280826460
        struct[0].Gy[104,111] = 18.6937810814837
        struct[0].Gy[104,112] = 105.571769313180
        struct[0].Gy[104,113] = 54.0657727682604
        struct[0].Gy[104,114] = -39.6392229058202
        struct[0].Gy[104,115] = -10.2713736253513
        struct[0].Gy[104,116] = -24.9575997948692
        struct[0].Gy[104,117] = -23.2849644809540
        struct[0].Gy[104,118] = -39.6392229058202
        struct[0].Gy[104,119] = -10.2713736253513
        struct[0].Gy[104,156] = -9.21038227100566
        struct[0].Gy[104,157] = 1.84896616921897
        struct[0].Gy[104,158] = -9.00835072044485
        struct[0].Gy[104,159] = 0.793238195499529
        struct[0].Gy[105,20] = -5.65456401516768
        struct[0].Gy[105,21] = 30.9517475172273
        struct[0].Gy[105,22] = -1.84896616921897
        struct[0].Gy[105,23] = -9.21038227100566
        struct[0].Gy[105,96] = -54.0657727682604
        struct[0].Gy[105,97] = 105.571769313180
        struct[0].Gy[105,98] = 10.2713736253513
        struct[0].Gy[105,99] = -39.6392229058202
        struct[0].Gy[105,100] = 23.2849644809540
        struct[0].Gy[105,101] = -24.9575997948692
        struct[0].Gy[105,102] = 10.2713736253513
        struct[0].Gy[105,103] = -39.6392229058202
        struct[0].Gy[105,104] = 113.786109551688
        struct[0].Gy[105,105] = -242.095286143588
        struct[0].Gy[105,106] = -18.6937810814837
        struct[0].Gy[105,107] = 88.4888280826460
        struct[0].Gy[105,108] = -45.7766907664085
        struct[0].Gy[105,109] = 58.9235503101833
        struct[0].Gy[105,110] = -18.6937810814837
        struct[0].Gy[105,111] = 88.4888280826460
        struct[0].Gy[105,112] = -54.0657727682604
        struct[0].Gy[105,113] = 105.571769313180
        struct[0].Gy[105,114] = 10.2713736253513
        struct[0].Gy[105,115] = -39.6392229058202
        struct[0].Gy[105,116] = 23.2849644809540
        struct[0].Gy[105,117] = -24.9575997948692
        struct[0].Gy[105,118] = 10.2713736253513
        struct[0].Gy[105,119] = -39.6392229058202
        struct[0].Gy[105,156] = -1.84896616921897
        struct[0].Gy[105,157] = -9.21038227100566
        struct[0].Gy[105,158] = -0.793238195499529
        struct[0].Gy[105,159] = -9.00835072044485
        struct[0].Gy[106,20] = -9.21038227100566
        struct[0].Gy[106,21] = 1.84896616921897
        struct[0].Gy[106,22] = -9.00835072044485
        struct[0].Gy[106,23] = 0.793238195499528
        struct[0].Gy[106,96] = -39.6392229058202
        struct[0].Gy[106,97] = -10.2713736253513
        struct[0].Gy[106,98] = 105.571769313180
        struct[0].Gy[106,99] = 54.0657727682604
        struct[0].Gy[106,100] = -39.6392229058201
        struct[0].Gy[106,101] = -10.2713736253513
        struct[0].Gy[106,102] = -24.9575997948692
        struct[0].Gy[106,103] = -23.2849644809540
        struct[0].Gy[106,104] = 88.4888280826460
        struct[0].Gy[106,105] = 18.6937810814837
        struct[0].Gy[106,106] = -242.095286143588
        struct[0].Gy[106,107] = -113.786109551688
        struct[0].Gy[106,108] = 88.4888280826460
        struct[0].Gy[106,109] = 18.6937810814837
        struct[0].Gy[106,110] = 58.9235503101833
        struct[0].Gy[106,111] = 45.7766907664085
        struct[0].Gy[106,112] = -39.6392229058202
        struct[0].Gy[106,113] = -10.2713736253513
        struct[0].Gy[106,114] = 105.571769313180
        struct[0].Gy[106,115] = 54.0657727682604
        struct[0].Gy[106,116] = -39.6392229058201
        struct[0].Gy[106,117] = -10.2713736253513
        struct[0].Gy[106,118] = -24.9575997948692
        struct[0].Gy[106,119] = -23.2849644809540
        struct[0].Gy[106,156] = 30.9517475172273
        struct[0].Gy[106,157] = 5.65456401516768
        struct[0].Gy[106,158] = -9.21038227100566
        struct[0].Gy[106,159] = 1.84896616921897
        struct[0].Gy[107,20] = -1.84896616921897
        struct[0].Gy[107,21] = -9.21038227100566
        struct[0].Gy[107,22] = -0.793238195499528
        struct[0].Gy[107,23] = -9.00835072044485
        struct[0].Gy[107,96] = 10.2713736253513
        struct[0].Gy[107,97] = -39.6392229058202
        struct[0].Gy[107,98] = -54.0657727682604
        struct[0].Gy[107,99] = 105.571769313180
        struct[0].Gy[107,100] = 10.2713736253513
        struct[0].Gy[107,101] = -39.6392229058201
        struct[0].Gy[107,102] = 23.2849644809540
        struct[0].Gy[107,103] = -24.9575997948692
        struct[0].Gy[107,104] = -18.6937810814837
        struct[0].Gy[107,105] = 88.4888280826460
        struct[0].Gy[107,106] = 113.786109551688
        struct[0].Gy[107,107] = -242.095286143588
        struct[0].Gy[107,108] = -18.6937810814837
        struct[0].Gy[107,109] = 88.4888280826460
        struct[0].Gy[107,110] = -45.7766907664085
        struct[0].Gy[107,111] = 58.9235503101833
        struct[0].Gy[107,112] = 10.2713736253513
        struct[0].Gy[107,113] = -39.6392229058202
        struct[0].Gy[107,114] = -54.0657727682604
        struct[0].Gy[107,115] = 105.571769313180
        struct[0].Gy[107,116] = 10.2713736253513
        struct[0].Gy[107,117] = -39.6392229058201
        struct[0].Gy[107,118] = 23.2849644809540
        struct[0].Gy[107,119] = -24.9575997948692
        struct[0].Gy[107,156] = -5.65456401516768
        struct[0].Gy[107,157] = 30.9517475172273
        struct[0].Gy[107,158] = -1.84896616921897
        struct[0].Gy[107,159] = -9.21038227100566
        struct[0].Gy[108,20] = -9.00835072044484
        struct[0].Gy[108,21] = 0.793238195499527
        struct[0].Gy[108,22] = -9.21038227100566
        struct[0].Gy[108,23] = 1.84896616921897
        struct[0].Gy[108,96] = -24.9575997948692
        struct[0].Gy[108,97] = -23.2849644809540
        struct[0].Gy[108,98] = -39.6392229058202
        struct[0].Gy[108,99] = -10.2713736253513
        struct[0].Gy[108,100] = 105.571769313180
        struct[0].Gy[108,101] = 54.0657727682604
        struct[0].Gy[108,102] = -39.6392229058201
        struct[0].Gy[108,103] = -10.2713736253514
        struct[0].Gy[108,104] = 58.9235503101833
        struct[0].Gy[108,105] = 45.7766907664085
        struct[0].Gy[108,106] = 88.4888280826461
        struct[0].Gy[108,107] = 18.6937810814837
        struct[0].Gy[108,108] = -242.095286143588
        struct[0].Gy[108,109] = -113.786109551688
        struct[0].Gy[108,110] = 88.4888280826459
        struct[0].Gy[108,111] = 18.6937810814837
        struct[0].Gy[108,112] = -24.9575997948692
        struct[0].Gy[108,113] = -23.2849644809540
        struct[0].Gy[108,114] = -39.6392229058202
        struct[0].Gy[108,115] = -10.2713736253513
        struct[0].Gy[108,116] = 105.571769313180
        struct[0].Gy[108,117] = 54.0657727682604
        struct[0].Gy[108,118] = -39.6392229058201
        struct[0].Gy[108,119] = -10.2713736253514
        struct[0].Gy[108,156] = -9.21038227100566
        struct[0].Gy[108,157] = 1.84896616921897
        struct[0].Gy[108,158] = 30.9517475172273
        struct[0].Gy[108,159] = 5.65456401516768
        struct[0].Gy[109,20] = -0.793238195499527
        struct[0].Gy[109,21] = -9.00835072044484
        struct[0].Gy[109,22] = -1.84896616921897
        struct[0].Gy[109,23] = -9.21038227100566
        struct[0].Gy[109,96] = 23.2849644809540
        struct[0].Gy[109,97] = -24.9575997948692
        struct[0].Gy[109,98] = 10.2713736253513
        struct[0].Gy[109,99] = -39.6392229058202
        struct[0].Gy[109,100] = -54.0657727682604
        struct[0].Gy[109,101] = 105.571769313180
        struct[0].Gy[109,102] = 10.2713736253514
        struct[0].Gy[109,103] = -39.6392229058201
        struct[0].Gy[109,104] = -45.7766907664085
        struct[0].Gy[109,105] = 58.9235503101833
        struct[0].Gy[109,106] = -18.6937810814837
        struct[0].Gy[109,107] = 88.4888280826461
        struct[0].Gy[109,108] = 113.786109551688
        struct[0].Gy[109,109] = -242.095286143588
        struct[0].Gy[109,110] = -18.6937810814837
        struct[0].Gy[109,111] = 88.4888280826459
        struct[0].Gy[109,112] = 23.2849644809540
        struct[0].Gy[109,113] = -24.9575997948692
        struct[0].Gy[109,114] = 10.2713736253513
        struct[0].Gy[109,115] = -39.6392229058202
        struct[0].Gy[109,116] = -54.0657727682604
        struct[0].Gy[109,117] = 105.571769313180
        struct[0].Gy[109,118] = 10.2713736253514
        struct[0].Gy[109,119] = -39.6392229058201
        struct[0].Gy[109,156] = -1.84896616921897
        struct[0].Gy[109,157] = -9.21038227100566
        struct[0].Gy[109,158] = -5.65456401516768
        struct[0].Gy[109,159] = 30.9517475172273
        struct[0].Gy[110,20] = -9.21038227100566
        struct[0].Gy[110,21] = 1.84896616921897
        struct[0].Gy[110,22] = 30.9517475172273
        struct[0].Gy[110,23] = 5.65456401516768
        struct[0].Gy[110,96] = -39.6392229058202
        struct[0].Gy[110,97] = -10.2713736253513
        struct[0].Gy[110,98] = -24.9575997948692
        struct[0].Gy[110,99] = -23.2849644809540
        struct[0].Gy[110,100] = -39.6392229058202
        struct[0].Gy[110,101] = -10.2713736253513
        struct[0].Gy[110,102] = 105.571769313180
        struct[0].Gy[110,103] = 54.0657727682604
        struct[0].Gy[110,104] = 88.4888280826460
        struct[0].Gy[110,105] = 18.6937810814837
        struct[0].Gy[110,106] = 58.9235503101832
        struct[0].Gy[110,107] = 45.7766907664085
        struct[0].Gy[110,108] = 88.4888280826460
        struct[0].Gy[110,109] = 18.6937810814837
        struct[0].Gy[110,110] = -242.095286143588
        struct[0].Gy[110,111] = -113.786109551688
        struct[0].Gy[110,112] = -39.6392229058202
        struct[0].Gy[110,113] = -10.2713736253513
        struct[0].Gy[110,114] = -24.9575997948692
        struct[0].Gy[110,115] = -23.2849644809540
        struct[0].Gy[110,116] = -39.6392229058202
        struct[0].Gy[110,117] = -10.2713736253513
        struct[0].Gy[110,118] = 105.571769313180
        struct[0].Gy[110,119] = 54.0657727682604
        struct[0].Gy[110,156] = -9.00835072044485
        struct[0].Gy[110,157] = 0.793238195499527
        struct[0].Gy[110,158] = -9.21038227100566
        struct[0].Gy[110,159] = 1.84896616921897
        struct[0].Gy[111,20] = -1.84896616921897
        struct[0].Gy[111,21] = -9.21038227100566
        struct[0].Gy[111,22] = -5.65456401516768
        struct[0].Gy[111,23] = 30.9517475172273
        struct[0].Gy[111,96] = 10.2713736253513
        struct[0].Gy[111,97] = -39.6392229058202
        struct[0].Gy[111,98] = 23.2849644809540
        struct[0].Gy[111,99] = -24.9575997948692
        struct[0].Gy[111,100] = 10.2713736253513
        struct[0].Gy[111,101] = -39.6392229058202
        struct[0].Gy[111,102] = -54.0657727682604
        struct[0].Gy[111,103] = 105.571769313180
        struct[0].Gy[111,104] = -18.6937810814837
        struct[0].Gy[111,105] = 88.4888280826460
        struct[0].Gy[111,106] = -45.7766907664085
        struct[0].Gy[111,107] = 58.9235503101832
        struct[0].Gy[111,108] = -18.6937810814837
        struct[0].Gy[111,109] = 88.4888280826460
        struct[0].Gy[111,110] = 113.786109551688
        struct[0].Gy[111,111] = -242.095286143588
        struct[0].Gy[111,112] = 10.2713736253513
        struct[0].Gy[111,113] = -39.6392229058202
        struct[0].Gy[111,114] = 23.2849644809540
        struct[0].Gy[111,115] = -24.9575997948692
        struct[0].Gy[111,116] = 10.2713736253513
        struct[0].Gy[111,117] = -39.6392229058202
        struct[0].Gy[111,118] = -54.0657727682604
        struct[0].Gy[111,119] = 105.571769313180
        struct[0].Gy[111,156] = -0.793238195499527
        struct[0].Gy[111,157] = -9.00835072044485
        struct[0].Gy[111,158] = -1.84896616921897
        struct[0].Gy[111,159] = -9.21038227100566
        struct[0].Gy[112,24] = 30.9517475172273
        struct[0].Gy[112,25] = 5.65456401516768
        struct[0].Gy[112,26] = -9.21038227100566
        struct[0].Gy[112,27] = 1.84896616921897
        struct[0].Gy[112,104] = 105.571769313180
        struct[0].Gy[112,105] = 54.0657727682604
        struct[0].Gy[112,106] = -39.6392229058202
        struct[0].Gy[112,107] = -10.2713736253513
        struct[0].Gy[112,108] = -24.9575997948692
        struct[0].Gy[112,109] = -23.2849644809540
        struct[0].Gy[112,110] = -39.6392229058202
        struct[0].Gy[112,111] = -10.2713736253513
        struct[0].Gy[112,112] = -136.523516830407
        struct[0].Gy[112,113] = -59.7203367834281
        struct[0].Gy[112,114] = 48.8496051768258
        struct[0].Gy[112,115] = 8.42240745613237
        struct[0].Gy[112,116] = 33.9659505153141
        struct[0].Gy[112,117] = 22.4917262854545
        struct[0].Gy[112,118] = 48.8496051768258
        struct[0].Gy[112,119] = 8.42240745613237
        struct[0].Gy[112,160] = -9.21038227100566
        struct[0].Gy[112,161] = 1.84896616921897
        struct[0].Gy[112,162] = -9.00835072044485
        struct[0].Gy[112,163] = 0.793238195499529
        struct[0].Gy[112,393] = 1
        struct[0].Gy[113,24] = -5.65456401516768
        struct[0].Gy[113,25] = 30.9517475172273
        struct[0].Gy[113,26] = -1.84896616921897
        struct[0].Gy[113,27] = -9.21038227100566
        struct[0].Gy[113,104] = -54.0657727682604
        struct[0].Gy[113,105] = 105.571769313180
        struct[0].Gy[113,106] = 10.2713736253513
        struct[0].Gy[113,107] = -39.6392229058202
        struct[0].Gy[113,108] = 23.2849644809540
        struct[0].Gy[113,109] = -24.9575997948692
        struct[0].Gy[113,110] = 10.2713736253513
        struct[0].Gy[113,111] = -39.6392229058202
        struct[0].Gy[113,112] = 59.7203367834281
        struct[0].Gy[113,113] = -136.523516830407
        struct[0].Gy[113,114] = -8.42240745613237
        struct[0].Gy[113,115] = 48.8496051768258
        struct[0].Gy[113,116] = -22.4917262854545
        struct[0].Gy[113,117] = 33.9659505153141
        struct[0].Gy[113,118] = -8.42240745613237
        struct[0].Gy[113,119] = 48.8496051768258
        struct[0].Gy[113,160] = -1.84896616921897
        struct[0].Gy[113,161] = -9.21038227100566
        struct[0].Gy[113,162] = -0.793238195499529
        struct[0].Gy[113,163] = -9.00835072044485
        struct[0].Gy[113,394] = 1
        struct[0].Gy[114,24] = -9.21038227100566
        struct[0].Gy[114,25] = 1.84896616921897
        struct[0].Gy[114,26] = -9.00835072044485
        struct[0].Gy[114,27] = 0.793238195499528
        struct[0].Gy[114,104] = -39.6392229058202
        struct[0].Gy[114,105] = -10.2713736253513
        struct[0].Gy[114,106] = 105.571769313180
        struct[0].Gy[114,107] = 54.0657727682604
        struct[0].Gy[114,108] = -39.6392229058201
        struct[0].Gy[114,109] = -10.2713736253513
        struct[0].Gy[114,110] = -24.9575997948692
        struct[0].Gy[114,111] = -23.2849644809540
        struct[0].Gy[114,112] = 48.8496051768258
        struct[0].Gy[114,113] = 8.42240745613237
        struct[0].Gy[114,114] = -136.523516830407
        struct[0].Gy[114,115] = -59.7203367834280
        struct[0].Gy[114,116] = 48.8496051768258
        struct[0].Gy[114,117] = 8.42240745613238
        struct[0].Gy[114,118] = 33.9659505153141
        struct[0].Gy[114,119] = 22.4917262854545
        struct[0].Gy[114,160] = 30.9517475172273
        struct[0].Gy[114,161] = 5.65456401516768
        struct[0].Gy[114,162] = -9.21038227100566
        struct[0].Gy[114,163] = 1.84896616921897
        struct[0].Gy[114,395] = 1
        struct[0].Gy[115,24] = -1.84896616921897
        struct[0].Gy[115,25] = -9.21038227100566
        struct[0].Gy[115,26] = -0.793238195499528
        struct[0].Gy[115,27] = -9.00835072044485
        struct[0].Gy[115,104] = 10.2713736253513
        struct[0].Gy[115,105] = -39.6392229058202
        struct[0].Gy[115,106] = -54.0657727682604
        struct[0].Gy[115,107] = 105.571769313180
        struct[0].Gy[115,108] = 10.2713736253513
        struct[0].Gy[115,109] = -39.6392229058201
        struct[0].Gy[115,110] = 23.2849644809540
        struct[0].Gy[115,111] = -24.9575997948692
        struct[0].Gy[115,112] = -8.42240745613237
        struct[0].Gy[115,113] = 48.8496051768258
        struct[0].Gy[115,114] = 59.7203367834280
        struct[0].Gy[115,115] = -136.523516830407
        struct[0].Gy[115,116] = -8.42240745613238
        struct[0].Gy[115,117] = 48.8496051768258
        struct[0].Gy[115,118] = -22.4917262854545
        struct[0].Gy[115,119] = 33.9659505153141
        struct[0].Gy[115,160] = -5.65456401516768
        struct[0].Gy[115,161] = 30.9517475172273
        struct[0].Gy[115,162] = -1.84896616921897
        struct[0].Gy[115,163] = -9.21038227100566
        struct[0].Gy[115,396] = 1
        struct[0].Gy[116,24] = -9.00835072044484
        struct[0].Gy[116,25] = 0.793238195499527
        struct[0].Gy[116,26] = -9.21038227100566
        struct[0].Gy[116,27] = 1.84896616921897
        struct[0].Gy[116,104] = -24.9575997948692
        struct[0].Gy[116,105] = -23.2849644809540
        struct[0].Gy[116,106] = -39.6392229058202
        struct[0].Gy[116,107] = -10.2713736253513
        struct[0].Gy[116,108] = 105.571769313180
        struct[0].Gy[116,109] = 54.0657727682604
        struct[0].Gy[116,110] = -39.6392229058201
        struct[0].Gy[116,111] = -10.2713736253514
        struct[0].Gy[116,112] = 33.9659505153141
        struct[0].Gy[116,113] = 22.4917262854545
        struct[0].Gy[116,114] = 48.8496051768259
        struct[0].Gy[116,115] = 8.42240745613236
        struct[0].Gy[116,116] = -136.523516830407
        struct[0].Gy[116,117] = -59.7203367834281
        struct[0].Gy[116,118] = 48.8496051768258
        struct[0].Gy[116,119] = 8.42240745613239
        struct[0].Gy[116,160] = -9.21038227100566
        struct[0].Gy[116,161] = 1.84896616921897
        struct[0].Gy[116,162] = 30.9517475172273
        struct[0].Gy[116,163] = 5.65456401516768
        struct[0].Gy[116,397] = 1
        struct[0].Gy[117,24] = -0.793238195499527
        struct[0].Gy[117,25] = -9.00835072044484
        struct[0].Gy[117,26] = -1.84896616921897
        struct[0].Gy[117,27] = -9.21038227100566
        struct[0].Gy[117,104] = 23.2849644809540
        struct[0].Gy[117,105] = -24.9575997948692
        struct[0].Gy[117,106] = 10.2713736253513
        struct[0].Gy[117,107] = -39.6392229058202
        struct[0].Gy[117,108] = -54.0657727682604
        struct[0].Gy[117,109] = 105.571769313180
        struct[0].Gy[117,110] = 10.2713736253514
        struct[0].Gy[117,111] = -39.6392229058201
        struct[0].Gy[117,112] = -22.4917262854545
        struct[0].Gy[117,113] = 33.9659505153141
        struct[0].Gy[117,114] = -8.42240745613236
        struct[0].Gy[117,115] = 48.8496051768259
        struct[0].Gy[117,116] = 59.7203367834281
        struct[0].Gy[117,117] = -136.523516830407
        struct[0].Gy[117,118] = -8.42240745613239
        struct[0].Gy[117,119] = 48.8496051768258
        struct[0].Gy[117,160] = -1.84896616921897
        struct[0].Gy[117,161] = -9.21038227100566
        struct[0].Gy[117,162] = -5.65456401516768
        struct[0].Gy[117,163] = 30.9517475172273
        struct[0].Gy[117,398] = 1
        struct[0].Gy[118,24] = -9.21038227100566
        struct[0].Gy[118,25] = 1.84896616921897
        struct[0].Gy[118,26] = 30.9517475172273
        struct[0].Gy[118,27] = 5.65456401516768
        struct[0].Gy[118,104] = -39.6392229058202
        struct[0].Gy[118,105] = -10.2713736253513
        struct[0].Gy[118,106] = -24.9575997948692
        struct[0].Gy[118,107] = -23.2849644809540
        struct[0].Gy[118,108] = -39.6392229058202
        struct[0].Gy[118,109] = -10.2713736253513
        struct[0].Gy[118,110] = 105.571769313180
        struct[0].Gy[118,111] = 54.0657727682604
        struct[0].Gy[118,112] = 48.8496051768258
        struct[0].Gy[118,113] = 8.42240745613237
        struct[0].Gy[118,114] = 33.9659505153140
        struct[0].Gy[118,115] = 22.4917262854545
        struct[0].Gy[118,116] = 48.8496051768258
        struct[0].Gy[118,117] = 8.42240745613237
        struct[0].Gy[118,118] = -136.548516830407
        struct[0].Gy[118,119] = -59.7203367834281
        struct[0].Gy[118,160] = -9.00835072044485
        struct[0].Gy[118,161] = 0.793238195499527
        struct[0].Gy[118,162] = -9.21038227100566
        struct[0].Gy[118,163] = 1.84896616921897
        struct[0].Gy[118,399] = 1
        struct[0].Gy[119,24] = -1.84896616921897
        struct[0].Gy[119,25] = -9.21038227100566
        struct[0].Gy[119,26] = -5.65456401516768
        struct[0].Gy[119,27] = 30.9517475172273
        struct[0].Gy[119,104] = 10.2713736253513
        struct[0].Gy[119,105] = -39.6392229058202
        struct[0].Gy[119,106] = 23.2849644809540
        struct[0].Gy[119,107] = -24.9575997948692
        struct[0].Gy[119,108] = 10.2713736253513
        struct[0].Gy[119,109] = -39.6392229058202
        struct[0].Gy[119,110] = -54.0657727682604
        struct[0].Gy[119,111] = 105.571769313180
        struct[0].Gy[119,112] = -8.42240745613237
        struct[0].Gy[119,113] = 48.8496051768258
        struct[0].Gy[119,114] = -22.4917262854545
        struct[0].Gy[119,115] = 33.9659505153140
        struct[0].Gy[119,116] = -8.42240745613237
        struct[0].Gy[119,117] = 48.8496051768258
        struct[0].Gy[119,118] = 59.7203367834281
        struct[0].Gy[119,119] = -136.548516830407
        struct[0].Gy[119,160] = -0.793238195499527
        struct[0].Gy[119,161] = -9.00835072044485
        struct[0].Gy[119,162] = -1.84896616921897
        struct[0].Gy[119,163] = -9.21038227100566
        struct[0].Gy[119,400] = 1
        struct[0].Gy[120,8] = 7.89461337514771
        struct[0].Gy[120,9] = -1.58482814504483
        struct[0].Gy[120,10] = 7.72144347466701
        struct[0].Gy[120,11] = -0.679918453285308
        struct[0].Gy[120,56] = -7.89461337514771
        struct[0].Gy[120,57] = 1.58482814504483
        struct[0].Gy[120,58] = 26.5300693004806
        struct[0].Gy[120,59] = 4.84676915585801
        struct[0].Gy[120,60] = -7.89461337514771
        struct[0].Gy[120,61] = 1.58482814504483
        struct[0].Gy[120,62] = -7.72144347466701
        struct[0].Gy[120,63] = 0.679918453285308
        struct[0].Gy[120,120] = -26.5300693004806
        struct[0].Gy[120,121] = -4.84676915585801
        struct[0].Gy[120,122] = 7.89461337514771
        struct[0].Gy[120,123] = -1.58482814504483
        struct[0].Gy[121,8] = 1.58482814504483
        struct[0].Gy[121,9] = 7.89461337514771
        struct[0].Gy[121,10] = 0.679918453285308
        struct[0].Gy[121,11] = 7.72144347466701
        struct[0].Gy[121,56] = -1.58482814504483
        struct[0].Gy[121,57] = -7.89461337514771
        struct[0].Gy[121,58] = -4.84676915585801
        struct[0].Gy[121,59] = 26.5300693004806
        struct[0].Gy[121,60] = -1.58482814504483
        struct[0].Gy[121,61] = -7.89461337514771
        struct[0].Gy[121,62] = -0.679918453285308
        struct[0].Gy[121,63] = -7.72144347466701
        struct[0].Gy[121,120] = 4.84676915585801
        struct[0].Gy[121,121] = -26.5300693004806
        struct[0].Gy[121,122] = 1.58482814504483
        struct[0].Gy[121,123] = 7.89461337514771
        struct[0].Gy[122,8] = 7.72144347466701
        struct[0].Gy[122,9] = -0.679918453285310
        struct[0].Gy[122,10] = 7.89461337514771
        struct[0].Gy[122,11] = -1.58482814504483
        struct[0].Gy[122,56] = -7.72144347466701
        struct[0].Gy[122,57] = 0.679918453285310
        struct[0].Gy[122,58] = -7.89461337514770
        struct[0].Gy[122,59] = 1.58482814504483
        struct[0].Gy[122,60] = 26.5300693004806
        struct[0].Gy[122,61] = 4.84676915585801
        struct[0].Gy[122,62] = -7.89461337514771
        struct[0].Gy[122,63] = 1.58482814504483
        struct[0].Gy[122,120] = 7.89461337514770
        struct[0].Gy[122,121] = -1.58482814504483
        struct[0].Gy[122,122] = -26.5300693004806
        struct[0].Gy[122,123] = -4.84676915585801
        struct[0].Gy[123,8] = 0.679918453285310
        struct[0].Gy[123,9] = 7.72144347466701
        struct[0].Gy[123,10] = 1.58482814504483
        struct[0].Gy[123,11] = 7.89461337514771
        struct[0].Gy[123,56] = -0.679918453285310
        struct[0].Gy[123,57] = -7.72144347466701
        struct[0].Gy[123,58] = -1.58482814504483
        struct[0].Gy[123,59] = -7.89461337514770
        struct[0].Gy[123,60] = -4.84676915585801
        struct[0].Gy[123,61] = 26.5300693004806
        struct[0].Gy[123,62] = -1.58482814504483
        struct[0].Gy[123,63] = -7.89461337514771
        struct[0].Gy[123,120] = 1.58482814504483
        struct[0].Gy[123,121] = 7.89461337514770
        struct[0].Gy[123,122] = 4.84676915585801
        struct[0].Gy[123,123] = -26.5300693004806
        struct[0].Gy[124,64] = 26.5300693004806
        struct[0].Gy[124,65] = 4.84676915585801
        struct[0].Gy[124,66] = -7.89461337514770
        struct[0].Gy[124,67] = 1.58482814504483
        struct[0].Gy[124,68] = -7.72144347466701
        struct[0].Gy[124,69] = 0.679918453285310
        struct[0].Gy[124,70] = -7.89461337514771
        struct[0].Gy[124,71] = 1.58482814504483
        struct[0].Gy[124,124] = -53.0601386009611
        struct[0].Gy[124,125] = -9.69353831171601
        struct[0].Gy[124,126] = 15.7892267502954
        struct[0].Gy[124,127] = -3.16965629008966
        struct[0].Gy[124,128] = 15.4428869493340
        struct[0].Gy[124,129] = -1.35983690657062
        struct[0].Gy[124,130] = 15.7892267502954
        struct[0].Gy[124,131] = -3.16965629008966
        struct[0].Gy[124,132] = 26.5300693004806
        struct[0].Gy[124,133] = 4.84676915585801
        struct[0].Gy[124,134] = -7.89461337514770
        struct[0].Gy[124,135] = 1.58482814504483
        struct[0].Gy[124,136] = -7.72144347466701
        struct[0].Gy[124,137] = 0.679918453285310
        struct[0].Gy[124,138] = -7.89461337514771
        struct[0].Gy[124,139] = 1.58482814504483
        struct[0].Gy[125,64] = -4.84676915585801
        struct[0].Gy[125,65] = 26.5300693004806
        struct[0].Gy[125,66] = -1.58482814504483
        struct[0].Gy[125,67] = -7.89461337514770
        struct[0].Gy[125,68] = -0.679918453285310
        struct[0].Gy[125,69] = -7.72144347466701
        struct[0].Gy[125,70] = -1.58482814504483
        struct[0].Gy[125,71] = -7.89461337514771
        struct[0].Gy[125,124] = 9.69353831171601
        struct[0].Gy[125,125] = -53.0601386009611
        struct[0].Gy[125,126] = 3.16965629008966
        struct[0].Gy[125,127] = 15.7892267502954
        struct[0].Gy[125,128] = 1.35983690657062
        struct[0].Gy[125,129] = 15.4428869493340
        struct[0].Gy[125,130] = 3.16965629008966
        struct[0].Gy[125,131] = 15.7892267502954
        struct[0].Gy[125,132] = -4.84676915585801
        struct[0].Gy[125,133] = 26.5300693004806
        struct[0].Gy[125,134] = -1.58482814504483
        struct[0].Gy[125,135] = -7.89461337514770
        struct[0].Gy[125,136] = -0.679918453285310
        struct[0].Gy[125,137] = -7.72144347466701
        struct[0].Gy[125,138] = -1.58482814504483
        struct[0].Gy[125,139] = -7.89461337514771
        struct[0].Gy[126,64] = -7.89461337514771
        struct[0].Gy[126,65] = 1.58482814504483
        struct[0].Gy[126,66] = 26.5300693004806
        struct[0].Gy[126,67] = 4.84676915585801
        struct[0].Gy[126,68] = -7.89461337514771
        struct[0].Gy[126,69] = 1.58482814504483
        struct[0].Gy[126,70] = -7.72144347466701
        struct[0].Gy[126,71] = 0.679918453285308
        struct[0].Gy[126,124] = 15.7892267502954
        struct[0].Gy[126,125] = -3.16965629008966
        struct[0].Gy[126,126] = -53.0601386009611
        struct[0].Gy[126,127] = -9.69353831171602
        struct[0].Gy[126,128] = 15.7892267502954
        struct[0].Gy[126,129] = -3.16965629008967
        struct[0].Gy[126,130] = 15.4428869493340
        struct[0].Gy[126,131] = -1.35983690657062
        struct[0].Gy[126,132] = -7.89461337514771
        struct[0].Gy[126,133] = 1.58482814504483
        struct[0].Gy[126,134] = 26.5300693004806
        struct[0].Gy[126,135] = 4.84676915585801
        struct[0].Gy[126,136] = -7.89461337514771
        struct[0].Gy[126,137] = 1.58482814504483
        struct[0].Gy[126,138] = -7.72144347466701
        struct[0].Gy[126,139] = 0.679918453285308
        struct[0].Gy[127,64] = -1.58482814504483
        struct[0].Gy[127,65] = -7.89461337514771
        struct[0].Gy[127,66] = -4.84676915585801
        struct[0].Gy[127,67] = 26.5300693004806
        struct[0].Gy[127,68] = -1.58482814504483
        struct[0].Gy[127,69] = -7.89461337514771
        struct[0].Gy[127,70] = -0.679918453285308
        struct[0].Gy[127,71] = -7.72144347466701
        struct[0].Gy[127,124] = 3.16965629008966
        struct[0].Gy[127,125] = 15.7892267502954
        struct[0].Gy[127,126] = 9.69353831171602
        struct[0].Gy[127,127] = -53.0601386009611
        struct[0].Gy[127,128] = 3.16965629008967
        struct[0].Gy[127,129] = 15.7892267502954
        struct[0].Gy[127,130] = 1.35983690657062
        struct[0].Gy[127,131] = 15.4428869493340
        struct[0].Gy[127,132] = -1.58482814504483
        struct[0].Gy[127,133] = -7.89461337514771
        struct[0].Gy[127,134] = -4.84676915585801
        struct[0].Gy[127,135] = 26.5300693004806
        struct[0].Gy[127,136] = -1.58482814504483
        struct[0].Gy[127,137] = -7.89461337514771
        struct[0].Gy[127,138] = -0.679918453285308
        struct[0].Gy[127,139] = -7.72144347466701
        struct[0].Gy[128,64] = -7.72144347466701
        struct[0].Gy[128,65] = 0.679918453285310
        struct[0].Gy[128,66] = -7.89461337514770
        struct[0].Gy[128,67] = 1.58482814504483
        struct[0].Gy[128,68] = 26.5300693004806
        struct[0].Gy[128,69] = 4.84676915585801
        struct[0].Gy[128,70] = -7.89461337514771
        struct[0].Gy[128,71] = 1.58482814504483
        struct[0].Gy[128,124] = 15.4428869493340
        struct[0].Gy[128,125] = -1.35983690657062
        struct[0].Gy[128,126] = 15.7892267502954
        struct[0].Gy[128,127] = -3.16965629008966
        struct[0].Gy[128,128] = -53.0601386009611
        struct[0].Gy[128,129] = -9.69353831171602
        struct[0].Gy[128,130] = 15.7892267502954
        struct[0].Gy[128,131] = -3.16965629008967
        struct[0].Gy[128,132] = -7.72144347466701
        struct[0].Gy[128,133] = 0.679918453285310
        struct[0].Gy[128,134] = -7.89461337514770
        struct[0].Gy[128,135] = 1.58482814504483
        struct[0].Gy[128,136] = 26.5300693004806
        struct[0].Gy[128,137] = 4.84676915585801
        struct[0].Gy[128,138] = -7.89461337514771
        struct[0].Gy[128,139] = 1.58482814504483
        struct[0].Gy[129,64] = -0.679918453285310
        struct[0].Gy[129,65] = -7.72144347466701
        struct[0].Gy[129,66] = -1.58482814504483
        struct[0].Gy[129,67] = -7.89461337514770
        struct[0].Gy[129,68] = -4.84676915585801
        struct[0].Gy[129,69] = 26.5300693004806
        struct[0].Gy[129,70] = -1.58482814504483
        struct[0].Gy[129,71] = -7.89461337514771
        struct[0].Gy[129,124] = 1.35983690657062
        struct[0].Gy[129,125] = 15.4428869493340
        struct[0].Gy[129,126] = 3.16965629008966
        struct[0].Gy[129,127] = 15.7892267502954
        struct[0].Gy[129,128] = 9.69353831171602
        struct[0].Gy[129,129] = -53.0601386009611
        struct[0].Gy[129,130] = 3.16965629008967
        struct[0].Gy[129,131] = 15.7892267502954
        struct[0].Gy[129,132] = -0.679918453285310
        struct[0].Gy[129,133] = -7.72144347466701
        struct[0].Gy[129,134] = -1.58482814504483
        struct[0].Gy[129,135] = -7.89461337514770
        struct[0].Gy[129,136] = -4.84676915585801
        struct[0].Gy[129,137] = 26.5300693004806
        struct[0].Gy[129,138] = -1.58482814504483
        struct[0].Gy[129,139] = -7.89461337514771
        struct[0].Gy[130,64] = -7.89461337514771
        struct[0].Gy[130,65] = 1.58482814504483
        struct[0].Gy[130,66] = -7.72144347466701
        struct[0].Gy[130,67] = 0.679918453285308
        struct[0].Gy[130,68] = -7.89461337514771
        struct[0].Gy[130,69] = 1.58482814504483
        struct[0].Gy[130,70] = 26.5300693004806
        struct[0].Gy[130,71] = 4.84676915585801
        struct[0].Gy[130,124] = 15.7892267502954
        struct[0].Gy[130,125] = -3.16965629008966
        struct[0].Gy[130,126] = 15.4428869493340
        struct[0].Gy[130,127] = -1.35983690657062
        struct[0].Gy[130,128] = 15.7892267502954
        struct[0].Gy[130,129] = -3.16965629008966
        struct[0].Gy[130,130] = -53.0601386009611
        struct[0].Gy[130,131] = -9.69353831171602
        struct[0].Gy[130,132] = -7.89461337514771
        struct[0].Gy[130,133] = 1.58482814504483
        struct[0].Gy[130,134] = -7.72144347466701
        struct[0].Gy[130,135] = 0.679918453285308
        struct[0].Gy[130,136] = -7.89461337514771
        struct[0].Gy[130,137] = 1.58482814504483
        struct[0].Gy[130,138] = 26.5300693004806
        struct[0].Gy[130,139] = 4.84676915585801
        struct[0].Gy[131,64] = -1.58482814504483
        struct[0].Gy[131,65] = -7.89461337514771
        struct[0].Gy[131,66] = -0.679918453285308
        struct[0].Gy[131,67] = -7.72144347466701
        struct[0].Gy[131,68] = -1.58482814504483
        struct[0].Gy[131,69] = -7.89461337514771
        struct[0].Gy[131,70] = -4.84676915585801
        struct[0].Gy[131,71] = 26.5300693004806
        struct[0].Gy[131,124] = 3.16965629008966
        struct[0].Gy[131,125] = 15.7892267502954
        struct[0].Gy[131,126] = 1.35983690657062
        struct[0].Gy[131,127] = 15.4428869493340
        struct[0].Gy[131,128] = 3.16965629008966
        struct[0].Gy[131,129] = 15.7892267502954
        struct[0].Gy[131,130] = 9.69353831171602
        struct[0].Gy[131,131] = -53.0601386009611
        struct[0].Gy[131,132] = -1.58482814504483
        struct[0].Gy[131,133] = -7.89461337514771
        struct[0].Gy[131,134] = -0.679918453285308
        struct[0].Gy[131,135] = -7.72144347466701
        struct[0].Gy[131,136] = -1.58482814504483
        struct[0].Gy[131,137] = -7.89461337514771
        struct[0].Gy[131,138] = -4.84676915585801
        struct[0].Gy[131,139] = 26.5300693004806
        struct[0].Gy[132,124] = 26.5300693004806
        struct[0].Gy[132,125] = 4.84676915585801
        struct[0].Gy[132,126] = -7.89461337514770
        struct[0].Gy[132,127] = 1.58482814504483
        struct[0].Gy[132,128] = -7.72144347466701
        struct[0].Gy[132,129] = 0.679918453285310
        struct[0].Gy[132,130] = -7.89461337514771
        struct[0].Gy[132,131] = 1.58482814504483
        struct[0].Gy[132,132] = -53.0601386009611
        struct[0].Gy[132,133] = -9.69353831171601
        struct[0].Gy[132,134] = 15.7892267502954
        struct[0].Gy[132,135] = -3.16965629008966
        struct[0].Gy[132,136] = 15.4428869493340
        struct[0].Gy[132,137] = -1.35983690657062
        struct[0].Gy[132,138] = 15.7892267502954
        struct[0].Gy[132,139] = -3.16965629008966
        struct[0].Gy[132,140] = 26.5300693004806
        struct[0].Gy[132,141] = 4.84676915585801
        struct[0].Gy[132,142] = -7.89461337514770
        struct[0].Gy[132,143] = 1.58482814504483
        struct[0].Gy[132,144] = -7.72144347466701
        struct[0].Gy[132,145] = 0.679918453285310
        struct[0].Gy[132,146] = -7.89461337514771
        struct[0].Gy[132,147] = 1.58482814504483
        struct[0].Gy[133,124] = -4.84676915585801
        struct[0].Gy[133,125] = 26.5300693004806
        struct[0].Gy[133,126] = -1.58482814504483
        struct[0].Gy[133,127] = -7.89461337514770
        struct[0].Gy[133,128] = -0.679918453285310
        struct[0].Gy[133,129] = -7.72144347466701
        struct[0].Gy[133,130] = -1.58482814504483
        struct[0].Gy[133,131] = -7.89461337514771
        struct[0].Gy[133,132] = 9.69353831171601
        struct[0].Gy[133,133] = -53.0601386009611
        struct[0].Gy[133,134] = 3.16965629008966
        struct[0].Gy[133,135] = 15.7892267502954
        struct[0].Gy[133,136] = 1.35983690657062
        struct[0].Gy[133,137] = 15.4428869493340
        struct[0].Gy[133,138] = 3.16965629008966
        struct[0].Gy[133,139] = 15.7892267502954
        struct[0].Gy[133,140] = -4.84676915585801
        struct[0].Gy[133,141] = 26.5300693004806
        struct[0].Gy[133,142] = -1.58482814504483
        struct[0].Gy[133,143] = -7.89461337514770
        struct[0].Gy[133,144] = -0.679918453285310
        struct[0].Gy[133,145] = -7.72144347466701
        struct[0].Gy[133,146] = -1.58482814504483
        struct[0].Gy[133,147] = -7.89461337514771
        struct[0].Gy[134,124] = -7.89461337514771
        struct[0].Gy[134,125] = 1.58482814504483
        struct[0].Gy[134,126] = 26.5300693004806
        struct[0].Gy[134,127] = 4.84676915585801
        struct[0].Gy[134,128] = -7.89461337514771
        struct[0].Gy[134,129] = 1.58482814504483
        struct[0].Gy[134,130] = -7.72144347466701
        struct[0].Gy[134,131] = 0.679918453285308
        struct[0].Gy[134,132] = 15.7892267502954
        struct[0].Gy[134,133] = -3.16965629008966
        struct[0].Gy[134,134] = -53.0601386009611
        struct[0].Gy[134,135] = -9.69353831171602
        struct[0].Gy[134,136] = 15.7892267502954
        struct[0].Gy[134,137] = -3.16965629008967
        struct[0].Gy[134,138] = 15.4428869493340
        struct[0].Gy[134,139] = -1.35983690657062
        struct[0].Gy[134,140] = -7.89461337514771
        struct[0].Gy[134,141] = 1.58482814504483
        struct[0].Gy[134,142] = 26.5300693004806
        struct[0].Gy[134,143] = 4.84676915585801
        struct[0].Gy[134,144] = -7.89461337514771
        struct[0].Gy[134,145] = 1.58482814504483
        struct[0].Gy[134,146] = -7.72144347466701
        struct[0].Gy[134,147] = 0.679918453285308
        struct[0].Gy[135,124] = -1.58482814504483
        struct[0].Gy[135,125] = -7.89461337514771
        struct[0].Gy[135,126] = -4.84676915585801
        struct[0].Gy[135,127] = 26.5300693004806
        struct[0].Gy[135,128] = -1.58482814504483
        struct[0].Gy[135,129] = -7.89461337514771
        struct[0].Gy[135,130] = -0.679918453285308
        struct[0].Gy[135,131] = -7.72144347466701
        struct[0].Gy[135,132] = 3.16965629008966
        struct[0].Gy[135,133] = 15.7892267502954
        struct[0].Gy[135,134] = 9.69353831171602
        struct[0].Gy[135,135] = -53.0601386009611
        struct[0].Gy[135,136] = 3.16965629008967
        struct[0].Gy[135,137] = 15.7892267502954
        struct[0].Gy[135,138] = 1.35983690657062
        struct[0].Gy[135,139] = 15.4428869493340
        struct[0].Gy[135,140] = -1.58482814504483
        struct[0].Gy[135,141] = -7.89461337514771
        struct[0].Gy[135,142] = -4.84676915585801
        struct[0].Gy[135,143] = 26.5300693004806
        struct[0].Gy[135,144] = -1.58482814504483
        struct[0].Gy[135,145] = -7.89461337514771
        struct[0].Gy[135,146] = -0.679918453285308
        struct[0].Gy[135,147] = -7.72144347466701
        struct[0].Gy[136,124] = -7.72144347466701
        struct[0].Gy[136,125] = 0.679918453285310
        struct[0].Gy[136,126] = -7.89461337514770
        struct[0].Gy[136,127] = 1.58482814504483
        struct[0].Gy[136,128] = 26.5300693004806
        struct[0].Gy[136,129] = 4.84676915585801
        struct[0].Gy[136,130] = -7.89461337514771
        struct[0].Gy[136,131] = 1.58482814504483
        struct[0].Gy[136,132] = 15.4428869493340
        struct[0].Gy[136,133] = -1.35983690657062
        struct[0].Gy[136,134] = 15.7892267502954
        struct[0].Gy[136,135] = -3.16965629008966
        struct[0].Gy[136,136] = -53.0601386009611
        struct[0].Gy[136,137] = -9.69353831171602
        struct[0].Gy[136,138] = 15.7892267502954
        struct[0].Gy[136,139] = -3.16965629008967
        struct[0].Gy[136,140] = -7.72144347466701
        struct[0].Gy[136,141] = 0.679918453285310
        struct[0].Gy[136,142] = -7.89461337514770
        struct[0].Gy[136,143] = 1.58482814504483
        struct[0].Gy[136,144] = 26.5300693004806
        struct[0].Gy[136,145] = 4.84676915585801
        struct[0].Gy[136,146] = -7.89461337514771
        struct[0].Gy[136,147] = 1.58482814504483
        struct[0].Gy[137,124] = -0.679918453285310
        struct[0].Gy[137,125] = -7.72144347466701
        struct[0].Gy[137,126] = -1.58482814504483
        struct[0].Gy[137,127] = -7.89461337514770
        struct[0].Gy[137,128] = -4.84676915585801
        struct[0].Gy[137,129] = 26.5300693004806
        struct[0].Gy[137,130] = -1.58482814504483
        struct[0].Gy[137,131] = -7.89461337514771
        struct[0].Gy[137,132] = 1.35983690657062
        struct[0].Gy[137,133] = 15.4428869493340
        struct[0].Gy[137,134] = 3.16965629008966
        struct[0].Gy[137,135] = 15.7892267502954
        struct[0].Gy[137,136] = 9.69353831171602
        struct[0].Gy[137,137] = -53.0601386009611
        struct[0].Gy[137,138] = 3.16965629008967
        struct[0].Gy[137,139] = 15.7892267502954
        struct[0].Gy[137,140] = -0.679918453285310
        struct[0].Gy[137,141] = -7.72144347466701
        struct[0].Gy[137,142] = -1.58482814504483
        struct[0].Gy[137,143] = -7.89461337514770
        struct[0].Gy[137,144] = -4.84676915585801
        struct[0].Gy[137,145] = 26.5300693004806
        struct[0].Gy[137,146] = -1.58482814504483
        struct[0].Gy[137,147] = -7.89461337514771
        struct[0].Gy[138,124] = -7.89461337514771
        struct[0].Gy[138,125] = 1.58482814504483
        struct[0].Gy[138,126] = -7.72144347466701
        struct[0].Gy[138,127] = 0.679918453285308
        struct[0].Gy[138,128] = -7.89461337514771
        struct[0].Gy[138,129] = 1.58482814504483
        struct[0].Gy[138,130] = 26.5300693004806
        struct[0].Gy[138,131] = 4.84676915585801
        struct[0].Gy[138,132] = 15.7892267502954
        struct[0].Gy[138,133] = -3.16965629008966
        struct[0].Gy[138,134] = 15.4428869493340
        struct[0].Gy[138,135] = -1.35983690657062
        struct[0].Gy[138,136] = 15.7892267502954
        struct[0].Gy[138,137] = -3.16965629008966
        struct[0].Gy[138,138] = -53.0851386009611
        struct[0].Gy[138,139] = -9.69353831171602
        struct[0].Gy[138,140] = -7.89461337514771
        struct[0].Gy[138,141] = 1.58482814504483
        struct[0].Gy[138,142] = -7.72144347466701
        struct[0].Gy[138,143] = 0.679918453285308
        struct[0].Gy[138,144] = -7.89461337514771
        struct[0].Gy[138,145] = 1.58482814504483
        struct[0].Gy[138,146] = 26.5300693004806
        struct[0].Gy[138,147] = 4.84676915585801
        struct[0].Gy[139,124] = -1.58482814504483
        struct[0].Gy[139,125] = -7.89461337514771
        struct[0].Gy[139,126] = -0.679918453285308
        struct[0].Gy[139,127] = -7.72144347466701
        struct[0].Gy[139,128] = -1.58482814504483
        struct[0].Gy[139,129] = -7.89461337514771
        struct[0].Gy[139,130] = -4.84676915585801
        struct[0].Gy[139,131] = 26.5300693004806
        struct[0].Gy[139,132] = 3.16965629008966
        struct[0].Gy[139,133] = 15.7892267502954
        struct[0].Gy[139,134] = 1.35983690657062
        struct[0].Gy[139,135] = 15.4428869493340
        struct[0].Gy[139,136] = 3.16965629008966
        struct[0].Gy[139,137] = 15.7892267502954
        struct[0].Gy[139,138] = 9.69353831171602
        struct[0].Gy[139,139] = -53.0851386009611
        struct[0].Gy[139,140] = -1.58482814504483
        struct[0].Gy[139,141] = -7.89461337514771
        struct[0].Gy[139,142] = -0.679918453285308
        struct[0].Gy[139,143] = -7.72144347466701
        struct[0].Gy[139,144] = -1.58482814504483
        struct[0].Gy[139,145] = -7.89461337514771
        struct[0].Gy[139,146] = -4.84676915585801
        struct[0].Gy[139,147] = 26.5300693004806
        struct[0].Gy[140,12] = 26.5300693004806
        struct[0].Gy[140,13] = 4.84676915585801
        struct[0].Gy[140,14] = -7.89461337514771
        struct[0].Gy[140,15] = 1.58482814504483
        struct[0].Gy[140,132] = 26.5300693004806
        struct[0].Gy[140,133] = 4.84676915585801
        struct[0].Gy[140,134] = -7.89461337514770
        struct[0].Gy[140,135] = 1.58482814504483
        struct[0].Gy[140,136] = -7.72144347466701
        struct[0].Gy[140,137] = 0.679918453285310
        struct[0].Gy[140,138] = -7.89461337514771
        struct[0].Gy[140,139] = 1.58482814504483
        struct[0].Gy[140,140] = -53.0601386009611
        struct[0].Gy[140,141] = -9.69353831171601
        struct[0].Gy[140,142] = 15.7892267502954
        struct[0].Gy[140,143] = -3.16965629008966
        struct[0].Gy[140,144] = 15.4428869493340
        struct[0].Gy[140,145] = -1.35983690657062
        struct[0].Gy[140,146] = 15.7892267502954
        struct[0].Gy[140,147] = -3.16965629008966
        struct[0].Gy[140,148] = -7.89461337514770
        struct[0].Gy[140,149] = 1.58482814504483
        struct[0].Gy[140,150] = -7.72144347466701
        struct[0].Gy[140,151] = 0.679918453285310
        struct[0].Gy[140,404] = 1
        struct[0].Gy[141,12] = -4.84676915585801
        struct[0].Gy[141,13] = 26.5300693004806
        struct[0].Gy[141,14] = -1.58482814504483
        struct[0].Gy[141,15] = -7.89461337514771
        struct[0].Gy[141,132] = -4.84676915585801
        struct[0].Gy[141,133] = 26.5300693004806
        struct[0].Gy[141,134] = -1.58482814504483
        struct[0].Gy[141,135] = -7.89461337514770
        struct[0].Gy[141,136] = -0.679918453285310
        struct[0].Gy[141,137] = -7.72144347466701
        struct[0].Gy[141,138] = -1.58482814504483
        struct[0].Gy[141,139] = -7.89461337514771
        struct[0].Gy[141,140] = 9.69353831171601
        struct[0].Gy[141,141] = -53.0601386009611
        struct[0].Gy[141,142] = 3.16965629008966
        struct[0].Gy[141,143] = 15.7892267502954
        struct[0].Gy[141,144] = 1.35983690657062
        struct[0].Gy[141,145] = 15.4428869493340
        struct[0].Gy[141,146] = 3.16965629008966
        struct[0].Gy[141,147] = 15.7892267502954
        struct[0].Gy[141,148] = -1.58482814504483
        struct[0].Gy[141,149] = -7.89461337514770
        struct[0].Gy[141,150] = -0.679918453285310
        struct[0].Gy[141,151] = -7.72144347466701
        struct[0].Gy[141,405] = 1
        struct[0].Gy[142,12] = -7.89461337514771
        struct[0].Gy[142,13] = 1.58482814504483
        struct[0].Gy[142,14] = -7.72144347466701
        struct[0].Gy[142,15] = 0.679918453285308
        struct[0].Gy[142,132] = -7.89461337514771
        struct[0].Gy[142,133] = 1.58482814504483
        struct[0].Gy[142,134] = 26.5300693004806
        struct[0].Gy[142,135] = 4.84676915585801
        struct[0].Gy[142,136] = -7.89461337514771
        struct[0].Gy[142,137] = 1.58482814504483
        struct[0].Gy[142,138] = -7.72144347466701
        struct[0].Gy[142,139] = 0.679918453285308
        struct[0].Gy[142,140] = 15.7892267502954
        struct[0].Gy[142,141] = -3.16965629008966
        struct[0].Gy[142,142] = -53.0601386009611
        struct[0].Gy[142,143] = -9.69353831171602
        struct[0].Gy[142,144] = 15.7892267502954
        struct[0].Gy[142,145] = -3.16965629008967
        struct[0].Gy[142,146] = 15.4428869493340
        struct[0].Gy[142,147] = -1.35983690657062
        struct[0].Gy[142,148] = 26.5300693004806
        struct[0].Gy[142,149] = 4.84676915585801
        struct[0].Gy[142,150] = -7.89461337514771
        struct[0].Gy[142,151] = 1.58482814504483
        struct[0].Gy[142,406] = 1
        struct[0].Gy[143,12] = -1.58482814504483
        struct[0].Gy[143,13] = -7.89461337514771
        struct[0].Gy[143,14] = -0.679918453285308
        struct[0].Gy[143,15] = -7.72144347466701
        struct[0].Gy[143,132] = -1.58482814504483
        struct[0].Gy[143,133] = -7.89461337514771
        struct[0].Gy[143,134] = -4.84676915585801
        struct[0].Gy[143,135] = 26.5300693004806
        struct[0].Gy[143,136] = -1.58482814504483
        struct[0].Gy[143,137] = -7.89461337514771
        struct[0].Gy[143,138] = -0.679918453285308
        struct[0].Gy[143,139] = -7.72144347466701
        struct[0].Gy[143,140] = 3.16965629008966
        struct[0].Gy[143,141] = 15.7892267502954
        struct[0].Gy[143,142] = 9.69353831171602
        struct[0].Gy[143,143] = -53.0601386009611
        struct[0].Gy[143,144] = 3.16965629008967
        struct[0].Gy[143,145] = 15.7892267502954
        struct[0].Gy[143,146] = 1.35983690657062
        struct[0].Gy[143,147] = 15.4428869493340
        struct[0].Gy[143,148] = -4.84676915585801
        struct[0].Gy[143,149] = 26.5300693004806
        struct[0].Gy[143,150] = -1.58482814504483
        struct[0].Gy[143,151] = -7.89461337514771
        struct[0].Gy[143,407] = 1
        struct[0].Gy[144,12] = -7.72144347466701
        struct[0].Gy[144,13] = 0.679918453285310
        struct[0].Gy[144,14] = -7.89461337514771
        struct[0].Gy[144,15] = 1.58482814504483
        struct[0].Gy[144,132] = -7.72144347466701
        struct[0].Gy[144,133] = 0.679918453285310
        struct[0].Gy[144,134] = -7.89461337514770
        struct[0].Gy[144,135] = 1.58482814504483
        struct[0].Gy[144,136] = 26.5300693004806
        struct[0].Gy[144,137] = 4.84676915585801
        struct[0].Gy[144,138] = -7.89461337514771
        struct[0].Gy[144,139] = 1.58482814504483
        struct[0].Gy[144,140] = 15.4428869493340
        struct[0].Gy[144,141] = -1.35983690657062
        struct[0].Gy[144,142] = 15.7892267502954
        struct[0].Gy[144,143] = -3.16965629008966
        struct[0].Gy[144,144] = -53.0601386009611
        struct[0].Gy[144,145] = -9.69353831171602
        struct[0].Gy[144,146] = 15.7892267502954
        struct[0].Gy[144,147] = -3.16965629008967
        struct[0].Gy[144,148] = -7.89461337514770
        struct[0].Gy[144,149] = 1.58482814504483
        struct[0].Gy[144,150] = 26.5300693004806
        struct[0].Gy[144,151] = 4.84676915585801
        struct[0].Gy[144,408] = 1
        struct[0].Gy[145,12] = -0.679918453285310
        struct[0].Gy[145,13] = -7.72144347466701
        struct[0].Gy[145,14] = -1.58482814504483
        struct[0].Gy[145,15] = -7.89461337514771
        struct[0].Gy[145,132] = -0.679918453285310
        struct[0].Gy[145,133] = -7.72144347466701
        struct[0].Gy[145,134] = -1.58482814504483
        struct[0].Gy[145,135] = -7.89461337514770
        struct[0].Gy[145,136] = -4.84676915585801
        struct[0].Gy[145,137] = 26.5300693004806
        struct[0].Gy[145,138] = -1.58482814504483
        struct[0].Gy[145,139] = -7.89461337514771
        struct[0].Gy[145,140] = 1.35983690657062
        struct[0].Gy[145,141] = 15.4428869493340
        struct[0].Gy[145,142] = 3.16965629008966
        struct[0].Gy[145,143] = 15.7892267502954
        struct[0].Gy[145,144] = 9.69353831171602
        struct[0].Gy[145,145] = -53.0601386009611
        struct[0].Gy[145,146] = 3.16965629008967
        struct[0].Gy[145,147] = 15.7892267502954
        struct[0].Gy[145,148] = -1.58482814504483
        struct[0].Gy[145,149] = -7.89461337514770
        struct[0].Gy[145,150] = -4.84676915585801
        struct[0].Gy[145,151] = 26.5300693004806
        struct[0].Gy[145,409] = 1
        struct[0].Gy[146,12] = -7.89461337514771
        struct[0].Gy[146,13] = 1.58482814504483
        struct[0].Gy[146,14] = 26.5300693004806
        struct[0].Gy[146,15] = 4.84676915585801
        struct[0].Gy[146,132] = -7.89461337514771
        struct[0].Gy[146,133] = 1.58482814504483
        struct[0].Gy[146,134] = -7.72144347466701
        struct[0].Gy[146,135] = 0.679918453285308
        struct[0].Gy[146,136] = -7.89461337514771
        struct[0].Gy[146,137] = 1.58482814504483
        struct[0].Gy[146,138] = 26.5300693004806
        struct[0].Gy[146,139] = 4.84676915585801
        struct[0].Gy[146,140] = 15.7892267502954
        struct[0].Gy[146,141] = -3.16965629008966
        struct[0].Gy[146,142] = 15.4428869493340
        struct[0].Gy[146,143] = -1.35983690657062
        struct[0].Gy[146,144] = 15.7892267502954
        struct[0].Gy[146,145] = -3.16965629008966
        struct[0].Gy[146,146] = -53.0601386009611
        struct[0].Gy[146,147] = -9.69353831171602
        struct[0].Gy[146,148] = -7.72144347466701
        struct[0].Gy[146,149] = 0.679918453285308
        struct[0].Gy[146,150] = -7.89461337514771
        struct[0].Gy[146,151] = 1.58482814504483
        struct[0].Gy[146,410] = 1
        struct[0].Gy[147,12] = -1.58482814504483
        struct[0].Gy[147,13] = -7.89461337514771
        struct[0].Gy[147,14] = -4.84676915585801
        struct[0].Gy[147,15] = 26.5300693004806
        struct[0].Gy[147,132] = -1.58482814504483
        struct[0].Gy[147,133] = -7.89461337514771
        struct[0].Gy[147,134] = -0.679918453285308
        struct[0].Gy[147,135] = -7.72144347466701
        struct[0].Gy[147,136] = -1.58482814504483
        struct[0].Gy[147,137] = -7.89461337514771
        struct[0].Gy[147,138] = -4.84676915585801
        struct[0].Gy[147,139] = 26.5300693004806
        struct[0].Gy[147,140] = 3.16965629008966
        struct[0].Gy[147,141] = 15.7892267502954
        struct[0].Gy[147,142] = 1.35983690657062
        struct[0].Gy[147,143] = 15.4428869493340
        struct[0].Gy[147,144] = 3.16965629008966
        struct[0].Gy[147,145] = 15.7892267502954
        struct[0].Gy[147,146] = 9.69353831171602
        struct[0].Gy[147,147] = -53.0601386009611
        struct[0].Gy[147,148] = -0.679918453285308
        struct[0].Gy[147,149] = -7.72144347466701
        struct[0].Gy[147,150] = -1.58482814504483
        struct[0].Gy[147,151] = -7.89461337514771
        struct[0].Gy[147,411] = 1
        struct[0].Gy[148,12] = 7.89461337514771
        struct[0].Gy[148,13] = -1.58482814504483
        struct[0].Gy[148,14] = 7.72144347466701
        struct[0].Gy[148,15] = -0.679918453285308
        struct[0].Gy[148,140] = -7.89461337514771
        struct[0].Gy[148,141] = 1.58482814504483
        struct[0].Gy[148,142] = 26.5300693004806
        struct[0].Gy[148,143] = 4.84676915585801
        struct[0].Gy[148,144] = -7.89461337514771
        struct[0].Gy[148,145] = 1.58482814504483
        struct[0].Gy[148,146] = -7.72144347466701
        struct[0].Gy[148,147] = 0.679918453285308
        struct[0].Gy[148,148] = -26.5300693004806
        struct[0].Gy[148,149] = -4.84676915585801
        struct[0].Gy[148,150] = 7.89461337514771
        struct[0].Gy[148,151] = -1.58482814504483
        struct[0].Gy[149,12] = 1.58482814504483
        struct[0].Gy[149,13] = 7.89461337514771
        struct[0].Gy[149,14] = 0.679918453285308
        struct[0].Gy[149,15] = 7.72144347466701
        struct[0].Gy[149,140] = -1.58482814504483
        struct[0].Gy[149,141] = -7.89461337514771
        struct[0].Gy[149,142] = -4.84676915585801
        struct[0].Gy[149,143] = 26.5300693004806
        struct[0].Gy[149,144] = -1.58482814504483
        struct[0].Gy[149,145] = -7.89461337514771
        struct[0].Gy[149,146] = -0.679918453285308
        struct[0].Gy[149,147] = -7.72144347466701
        struct[0].Gy[149,148] = 4.84676915585801
        struct[0].Gy[149,149] = -26.5300693004806
        struct[0].Gy[149,150] = 1.58482814504483
        struct[0].Gy[149,151] = 7.89461337514771
        struct[0].Gy[150,12] = 7.72144347466701
        struct[0].Gy[150,13] = -0.679918453285310
        struct[0].Gy[150,14] = 7.89461337514771
        struct[0].Gy[150,15] = -1.58482814504483
        struct[0].Gy[150,140] = -7.72144347466701
        struct[0].Gy[150,141] = 0.679918453285310
        struct[0].Gy[150,142] = -7.89461337514770
        struct[0].Gy[150,143] = 1.58482814504483
        struct[0].Gy[150,144] = 26.5300693004806
        struct[0].Gy[150,145] = 4.84676915585801
        struct[0].Gy[150,146] = -7.89461337514771
        struct[0].Gy[150,147] = 1.58482814504483
        struct[0].Gy[150,148] = 7.89461337514770
        struct[0].Gy[150,149] = -1.58482814504483
        struct[0].Gy[150,150] = -26.5300693004806
        struct[0].Gy[150,151] = -4.84676915585801
        struct[0].Gy[151,12] = 0.679918453285310
        struct[0].Gy[151,13] = 7.72144347466701
        struct[0].Gy[151,14] = 1.58482814504483
        struct[0].Gy[151,15] = 7.89461337514771
        struct[0].Gy[151,140] = -0.679918453285310
        struct[0].Gy[151,141] = -7.72144347466701
        struct[0].Gy[151,142] = -1.58482814504483
        struct[0].Gy[151,143] = -7.89461337514770
        struct[0].Gy[151,144] = -4.84676915585801
        struct[0].Gy[151,145] = 26.5300693004806
        struct[0].Gy[151,146] = -1.58482814504483
        struct[0].Gy[151,147] = -7.89461337514771
        struct[0].Gy[151,148] = 1.58482814504483
        struct[0].Gy[151,149] = 7.89461337514770
        struct[0].Gy[151,150] = 4.84676915585801
        struct[0].Gy[151,151] = -26.5300693004806
        struct[0].Gy[152,16] = 9.21038227100566
        struct[0].Gy[152,17] = -1.84896616921897
        struct[0].Gy[152,18] = 9.00835072044485
        struct[0].Gy[152,19] = -0.793238195499528
        struct[0].Gy[152,80] = -9.21038227100566
        struct[0].Gy[152,81] = 1.84896616921897
        struct[0].Gy[152,82] = 30.9517475172273
        struct[0].Gy[152,83] = 5.65456401516768
        struct[0].Gy[152,84] = -9.21038227100566
        struct[0].Gy[152,85] = 1.84896616921897
        struct[0].Gy[152,86] = -9.00835072044485
        struct[0].Gy[152,87] = 0.793238195499528
        struct[0].Gy[152,152] = -30.9517475172273
        struct[0].Gy[152,153] = -5.65456401516768
        struct[0].Gy[152,154] = 9.21038227100566
        struct[0].Gy[152,155] = -1.84896616921897
        struct[0].Gy[153,16] = 1.84896616921897
        struct[0].Gy[153,17] = 9.21038227100566
        struct[0].Gy[153,18] = 0.793238195499528
        struct[0].Gy[153,19] = 9.00835072044485
        struct[0].Gy[153,80] = -1.84896616921897
        struct[0].Gy[153,81] = -9.21038227100566
        struct[0].Gy[153,82] = -5.65456401516768
        struct[0].Gy[153,83] = 30.9517475172273
        struct[0].Gy[153,84] = -1.84896616921897
        struct[0].Gy[153,85] = -9.21038227100566
        struct[0].Gy[153,86] = -0.793238195499528
        struct[0].Gy[153,87] = -9.00835072044485
        struct[0].Gy[153,152] = 5.65456401516768
        struct[0].Gy[153,153] = -30.9517475172273
        struct[0].Gy[153,154] = 1.84896616921897
        struct[0].Gy[153,155] = 9.21038227100566
        struct[0].Gy[154,16] = 9.00835072044484
        struct[0].Gy[154,17] = -0.793238195499527
        struct[0].Gy[154,18] = 9.21038227100566
        struct[0].Gy[154,19] = -1.84896616921897
        struct[0].Gy[154,80] = -9.00835072044484
        struct[0].Gy[154,81] = 0.793238195499527
        struct[0].Gy[154,82] = -9.21038227100566
        struct[0].Gy[154,83] = 1.84896616921897
        struct[0].Gy[154,84] = 30.9517475172273
        struct[0].Gy[154,85] = 5.65456401516768
        struct[0].Gy[154,86] = -9.21038227100566
        struct[0].Gy[154,87] = 1.84896616921897
        struct[0].Gy[154,152] = 9.21038227100566
        struct[0].Gy[154,153] = -1.84896616921897
        struct[0].Gy[154,154] = -30.9517475172273
        struct[0].Gy[154,155] = -5.65456401516768
        struct[0].Gy[155,16] = 0.793238195499527
        struct[0].Gy[155,17] = 9.00835072044484
        struct[0].Gy[155,18] = 1.84896616921897
        struct[0].Gy[155,19] = 9.21038227100566
        struct[0].Gy[155,80] = -0.793238195499527
        struct[0].Gy[155,81] = -9.00835072044484
        struct[0].Gy[155,82] = -1.84896616921897
        struct[0].Gy[155,83] = -9.21038227100566
        struct[0].Gy[155,84] = -5.65456401516768
        struct[0].Gy[155,85] = 30.9517475172273
        struct[0].Gy[155,86] = -1.84896616921897
        struct[0].Gy[155,87] = -9.21038227100566
        struct[0].Gy[155,152] = 1.84896616921897
        struct[0].Gy[155,153] = 9.21038227100566
        struct[0].Gy[155,154] = 5.65456401516768
        struct[0].Gy[155,155] = -30.9517475172273
        struct[0].Gy[156,20] = 9.21038227100566
        struct[0].Gy[156,21] = -1.84896616921897
        struct[0].Gy[156,22] = 9.00835072044485
        struct[0].Gy[156,23] = -0.793238195499528
        struct[0].Gy[156,104] = -9.21038227100566
        struct[0].Gy[156,105] = 1.84896616921897
        struct[0].Gy[156,106] = 30.9517475172273
        struct[0].Gy[156,107] = 5.65456401516768
        struct[0].Gy[156,108] = -9.21038227100566
        struct[0].Gy[156,109] = 1.84896616921897
        struct[0].Gy[156,110] = -9.00835072044485
        struct[0].Gy[156,111] = 0.793238195499528
        struct[0].Gy[156,156] = -30.9517475172273
        struct[0].Gy[156,157] = -5.65456401516768
        struct[0].Gy[156,158] = 9.21038227100566
        struct[0].Gy[156,159] = -1.84896616921897
        struct[0].Gy[157,20] = 1.84896616921897
        struct[0].Gy[157,21] = 9.21038227100566
        struct[0].Gy[157,22] = 0.793238195499528
        struct[0].Gy[157,23] = 9.00835072044485
        struct[0].Gy[157,104] = -1.84896616921897
        struct[0].Gy[157,105] = -9.21038227100566
        struct[0].Gy[157,106] = -5.65456401516768
        struct[0].Gy[157,107] = 30.9517475172273
        struct[0].Gy[157,108] = -1.84896616921897
        struct[0].Gy[157,109] = -9.21038227100566
        struct[0].Gy[157,110] = -0.793238195499528
        struct[0].Gy[157,111] = -9.00835072044485
        struct[0].Gy[157,156] = 5.65456401516768
        struct[0].Gy[157,157] = -30.9517475172273
        struct[0].Gy[157,158] = 1.84896616921897
        struct[0].Gy[157,159] = 9.21038227100566
        struct[0].Gy[158,20] = 9.00835072044484
        struct[0].Gy[158,21] = -0.793238195499527
        struct[0].Gy[158,22] = 9.21038227100566
        struct[0].Gy[158,23] = -1.84896616921897
        struct[0].Gy[158,104] = -9.00835072044484
        struct[0].Gy[158,105] = 0.793238195499527
        struct[0].Gy[158,106] = -9.21038227100566
        struct[0].Gy[158,107] = 1.84896616921897
        struct[0].Gy[158,108] = 30.9517475172273
        struct[0].Gy[158,109] = 5.65456401516768
        struct[0].Gy[158,110] = -9.21038227100566
        struct[0].Gy[158,111] = 1.84896616921897
        struct[0].Gy[158,156] = 9.21038227100566
        struct[0].Gy[158,157] = -1.84896616921897
        struct[0].Gy[158,158] = -30.9517475172273
        struct[0].Gy[158,159] = -5.65456401516768
        struct[0].Gy[159,20] = 0.793238195499527
        struct[0].Gy[159,21] = 9.00835072044484
        struct[0].Gy[159,22] = 1.84896616921897
        struct[0].Gy[159,23] = 9.21038227100566
        struct[0].Gy[159,104] = -0.793238195499527
        struct[0].Gy[159,105] = -9.00835072044484
        struct[0].Gy[159,106] = -1.84896616921897
        struct[0].Gy[159,107] = -9.21038227100566
        struct[0].Gy[159,108] = -5.65456401516768
        struct[0].Gy[159,109] = 30.9517475172273
        struct[0].Gy[159,110] = -1.84896616921897
        struct[0].Gy[159,111] = -9.21038227100566
        struct[0].Gy[159,156] = 1.84896616921897
        struct[0].Gy[159,157] = 9.21038227100566
        struct[0].Gy[159,158] = 5.65456401516768
        struct[0].Gy[159,159] = -30.9517475172273
        struct[0].Gy[160,24] = 9.21038227100566
        struct[0].Gy[160,25] = -1.84896616921897
        struct[0].Gy[160,26] = 9.00835072044485
        struct[0].Gy[160,27] = -0.793238195499528
        struct[0].Gy[160,112] = -9.21038227100566
        struct[0].Gy[160,113] = 1.84896616921897
        struct[0].Gy[160,114] = 30.9517475172273
        struct[0].Gy[160,115] = 5.65456401516768
        struct[0].Gy[160,116] = -9.21038227100566
        struct[0].Gy[160,117] = 1.84896616921897
        struct[0].Gy[160,118] = -9.00835072044485
        struct[0].Gy[160,119] = 0.793238195499528
        struct[0].Gy[160,160] = -30.9517475172273
        struct[0].Gy[160,161] = -5.65456401516768
        struct[0].Gy[160,162] = 9.21038227100566
        struct[0].Gy[160,163] = -1.84896616921897
        struct[0].Gy[161,24] = 1.84896616921897
        struct[0].Gy[161,25] = 9.21038227100566
        struct[0].Gy[161,26] = 0.793238195499528
        struct[0].Gy[161,27] = 9.00835072044485
        struct[0].Gy[161,112] = -1.84896616921897
        struct[0].Gy[161,113] = -9.21038227100566
        struct[0].Gy[161,114] = -5.65456401516768
        struct[0].Gy[161,115] = 30.9517475172273
        struct[0].Gy[161,116] = -1.84896616921897
        struct[0].Gy[161,117] = -9.21038227100566
        struct[0].Gy[161,118] = -0.793238195499528
        struct[0].Gy[161,119] = -9.00835072044485
        struct[0].Gy[161,160] = 5.65456401516768
        struct[0].Gy[161,161] = -30.9517475172273
        struct[0].Gy[161,162] = 1.84896616921897
        struct[0].Gy[161,163] = 9.21038227100566
        struct[0].Gy[162,24] = 9.00835072044484
        struct[0].Gy[162,25] = -0.793238195499527
        struct[0].Gy[162,26] = 9.21038227100566
        struct[0].Gy[162,27] = -1.84896616921897
        struct[0].Gy[162,112] = -9.00835072044484
        struct[0].Gy[162,113] = 0.793238195499527
        struct[0].Gy[162,114] = -9.21038227100566
        struct[0].Gy[162,115] = 1.84896616921897
        struct[0].Gy[162,116] = 30.9517475172273
        struct[0].Gy[162,117] = 5.65456401516768
        struct[0].Gy[162,118] = -9.21038227100566
        struct[0].Gy[162,119] = 1.84896616921897
        struct[0].Gy[162,160] = 9.21038227100566
        struct[0].Gy[162,161] = -1.84896616921897
        struct[0].Gy[162,162] = -30.9517475172273
        struct[0].Gy[162,163] = -5.65456401516768
        struct[0].Gy[163,24] = 0.793238195499527
        struct[0].Gy[163,25] = 9.00835072044484
        struct[0].Gy[163,26] = 1.84896616921897
        struct[0].Gy[163,27] = 9.21038227100566
        struct[0].Gy[163,112] = -0.793238195499527
        struct[0].Gy[163,113] = -9.00835072044484
        struct[0].Gy[163,114] = -1.84896616921897
        struct[0].Gy[163,115] = -9.21038227100566
        struct[0].Gy[163,116] = -5.65456401516768
        struct[0].Gy[163,117] = 30.9517475172273
        struct[0].Gy[163,118] = -1.84896616921897
        struct[0].Gy[163,119] = -9.21038227100566
        struct[0].Gy[163,160] = 1.84896616921897
        struct[0].Gy[163,161] = 9.21038227100566
        struct[0].Gy[163,162] = 5.65456401516768
        struct[0].Gy[163,163] = -30.9517475172273
        struct[0].Gy[164,164] = -1067.70480704130
        struct[0].Gy[164,172] = 67.7048070412999
        struct[0].Gy[165,165] = -1067.70480704130
        struct[0].Gy[165,173] = 67.7048070412999
        struct[0].Gy[166,32] = 157.977883096366
        struct[0].Gy[166,166] = -361.092304220266
        struct[0].Gy[166,174] = 135.409614082600
        struct[0].Gy[167,33] = 157.977883096366
        struct[0].Gy[167,167] = -361.092304220266
        struct[0].Gy[167,175] = 135.409614082600
        struct[0].Gy[168,168] = -361.092304220266
        struct[0].Gy[168,176] = 135.409614082600
        struct[0].Gy[168,206] = 157.977883096366
        struct[0].Gy[169,169] = -361.092304220266
        struct[0].Gy[169,177] = 135.409614082600
        struct[0].Gy[169,207] = 157.977883096366
        struct[0].Gy[170,170] = -361.092304220266
        struct[0].Gy[170,178] = 135.409614082600
        struct[0].Gy[170,208] = 157.977883096366
        struct[0].Gy[171,171] = -361.092304220266
        struct[0].Gy[171,179] = 135.409614082600
        struct[0].Gy[171,209] = 157.977883096366
        struct[0].Gy[172,34] = 157.977883096366
        struct[0].Gy[172,164] = 67.7048070412999
        struct[0].Gy[172,172] = -361.092304220266
        struct[0].Gy[172,180] = 135.409614082600
        struct[0].Gy[173,35] = 157.977883096366
        struct[0].Gy[173,165] = 67.7048070412999
        struct[0].Gy[173,173] = -361.092304220266
        struct[0].Gy[173,181] = 135.409614082600
        struct[0].Gy[174,166] = 135.409614082600
        struct[0].Gy[174,174] = -248.250959151433
        struct[0].Gy[174,182] = 67.7048070412999
        struct[0].Gy[174,222] = 45.1365380275333
        struct[0].Gy[175,167] = 135.409614082600
        struct[0].Gy[175,175] = -248.250959151433
        struct[0].Gy[175,183] = 67.7048070412999
        struct[0].Gy[175,223] = 45.1365380275333
        struct[0].Gy[176,168] = 135.409614082600
        struct[0].Gy[176,176] = -248.250959151433
        struct[0].Gy[176,184] = 67.7048070412999
        struct[0].Gy[176,224] = 45.1365380275333
        struct[0].Gy[177,169] = 135.409614082600
        struct[0].Gy[177,177] = -248.250959151433
        struct[0].Gy[177,185] = 67.7048070412999
        struct[0].Gy[177,225] = 45.1365380275333
        struct[0].Gy[178,170] = 135.409614082600
        struct[0].Gy[178,178] = -248.250959151433
        struct[0].Gy[178,186] = 67.7048070412999
        struct[0].Gy[178,226] = 45.1365380275333
        struct[0].Gy[179,171] = 135.409614082600
        struct[0].Gy[179,179] = -248.250959151433
        struct[0].Gy[179,187] = 67.7048070412999
        struct[0].Gy[179,227] = 45.1365380275333
        struct[0].Gy[180,172] = 135.409614082600
        struct[0].Gy[180,180] = -248.250959151433
        struct[0].Gy[180,188] = 67.7048070412999
        struct[0].Gy[180,228] = 45.1365380275333
        struct[0].Gy[181,173] = 135.409614082600
        struct[0].Gy[181,181] = -248.250959151433
        struct[0].Gy[181,189] = 67.7048070412999
        struct[0].Gy[181,229] = 45.1365380275333
        struct[0].Gy[182,36] = 157.977883096366
        struct[0].Gy[182,174] = 67.7048070412999
        struct[0].Gy[182,182] = -270.819228165200
        struct[0].Gy[182,190] = 45.1365380275333
        struct[0].Gy[183,37] = 157.977883096366
        struct[0].Gy[183,175] = 67.7048070412999
        struct[0].Gy[183,183] = -270.819228165200
        struct[0].Gy[183,191] = 45.1365380275333
        struct[0].Gy[184,176] = 67.7048070412999
        struct[0].Gy[184,184] = -270.819228165200
        struct[0].Gy[184,192] = 45.1365380275333
        struct[0].Gy[184,210] = 157.977883096366
        struct[0].Gy[185,177] = 67.7048070412999
        struct[0].Gy[185,185] = -270.819228165200
        struct[0].Gy[185,193] = 45.1365380275333
        struct[0].Gy[185,211] = 157.977883096366
        struct[0].Gy[186,178] = 67.7048070412999
        struct[0].Gy[186,186] = -270.819228165200
        struct[0].Gy[186,194] = 45.1365380275333
        struct[0].Gy[186,212] = 157.977883096366
        struct[0].Gy[187,179] = 67.7048070412999
        struct[0].Gy[187,187] = -270.819228165200
        struct[0].Gy[187,195] = 45.1365380275333
        struct[0].Gy[187,213] = 157.977883096366
        struct[0].Gy[188,38] = 157.977883096366
        struct[0].Gy[188,180] = 67.7048070412999
        struct[0].Gy[188,188] = -270.819228165200
        struct[0].Gy[188,196] = 45.1365380275333
        struct[0].Gy[189,39] = 157.977883096366
        struct[0].Gy[189,181] = 67.7048070412999
        struct[0].Gy[189,189] = -270.819228165200
        struct[0].Gy[189,197] = 45.1365380275333
        struct[0].Gy[190,40] = 157.977883096366
        struct[0].Gy[190,182] = 45.1365380275333
        struct[0].Gy[190,190] = -361.092304220266
        struct[0].Gy[190,198] = 157.977883096366
        struct[0].Gy[191,41] = 157.977883096366
        struct[0].Gy[191,183] = 45.1365380275333
        struct[0].Gy[191,191] = -361.092304220266
        struct[0].Gy[191,199] = 157.977883096366
        struct[0].Gy[192,184] = 45.1365380275333
        struct[0].Gy[192,192] = -361.092304220266
        struct[0].Gy[192,200] = 157.977883096366
        struct[0].Gy[192,214] = 157.977883096366
        struct[0].Gy[193,185] = 45.1365380275333
        struct[0].Gy[193,193] = -361.092304220266
        struct[0].Gy[193,201] = 157.977883096366
        struct[0].Gy[193,215] = 157.977883096366
        struct[0].Gy[194,186] = 45.1365380275333
        struct[0].Gy[194,194] = -361.092304220266
        struct[0].Gy[194,202] = 157.977883096366
        struct[0].Gy[194,216] = 157.977883096366
        struct[0].Gy[195,187] = 45.1365380275333
        struct[0].Gy[195,195] = -361.092304220266
        struct[0].Gy[195,203] = 157.977883096366
        struct[0].Gy[195,217] = 157.977883096366
        struct[0].Gy[196,42] = 157.977883096366
        struct[0].Gy[196,188] = 45.1365380275333
        struct[0].Gy[196,196] = -361.092304220266
        struct[0].Gy[196,204] = 157.977883096366
        struct[0].Gy[197,43] = 157.977883096366
        struct[0].Gy[197,189] = 45.1365380275333
        struct[0].Gy[197,197] = -361.092304220266
        struct[0].Gy[197,205] = 157.977883096366
        struct[0].Gy[198,44] = 157.977883096366
        struct[0].Gy[198,190] = 157.977883096366
        struct[0].Gy[198,198] = -315.955766192733
        struct[0].Gy[198,401] = 1
        struct[0].Gy[199,45] = 157.977883096366
        struct[0].Gy[199,191] = 157.977883096366
        struct[0].Gy[199,199] = -315.955766192733
        struct[0].Gy[200,192] = 157.977883096366
        struct[0].Gy[200,200] = -315.955766192733
        struct[0].Gy[200,218] = 157.977883096366
        struct[0].Gy[201,193] = 157.977883096366
        struct[0].Gy[201,201] = -315.955766192733
        struct[0].Gy[201,219] = 157.977883096366
        struct[0].Gy[202,194] = 157.977883096366
        struct[0].Gy[202,202] = -315.955766192733
        struct[0].Gy[202,220] = 157.977883096366
        struct[0].Gy[203,195] = 157.977883096366
        struct[0].Gy[203,203] = -315.955766192733
        struct[0].Gy[203,221] = 157.977883096366
        struct[0].Gy[204,46] = 157.977883096366
        struct[0].Gy[204,196] = 157.977883096366
        struct[0].Gy[204,204] = -315.955766192733
        struct[0].Gy[204,402] = 1
        struct[0].Gy[205,47] = 157.977883096366
        struct[0].Gy[205,197] = 157.977883096366
        struct[0].Gy[205,205] = -315.955766192733
        struct[0].Gy[206,168] = 157.977883096366
        struct[0].Gy[206,206] = -157.977883096366
        struct[0].Gy[207,169] = 157.977883096366
        struct[0].Gy[207,207] = -157.977883096366
        struct[0].Gy[208,170] = 157.977883096366
        struct[0].Gy[208,208] = -157.977883096366
        struct[0].Gy[209,171] = 157.977883096366
        struct[0].Gy[209,209] = -157.977883096366
        struct[0].Gy[210,184] = 157.977883096366
        struct[0].Gy[210,210] = -157.977883096366
        struct[0].Gy[211,185] = 157.977883096366
        struct[0].Gy[211,211] = -157.977883096366
        struct[0].Gy[212,186] = 157.977883096366
        struct[0].Gy[212,212] = -157.977883096366
        struct[0].Gy[213,187] = 157.977883096366
        struct[0].Gy[213,213] = -157.977883096366
        struct[0].Gy[214,192] = 157.977883096366
        struct[0].Gy[214,214] = -157.977883096366
        struct[0].Gy[215,193] = 157.977883096366
        struct[0].Gy[215,215] = -157.977883096366
        struct[0].Gy[216,194] = 157.977883096366
        struct[0].Gy[216,216] = -157.977883096366
        struct[0].Gy[217,195] = 157.977883096366
        struct[0].Gy[217,217] = -157.977883096366
        struct[0].Gy[218,200] = 157.977883096366
        struct[0].Gy[218,218] = -157.977883096366
        struct[0].Gy[219,201] = 157.977883096366
        struct[0].Gy[219,219] = -157.977883096366
        struct[0].Gy[220,202] = 157.977883096366
        struct[0].Gy[220,220] = -157.977883096366
        struct[0].Gy[221,203] = 157.977883096366
        struct[0].Gy[221,221] = -157.977883096366
        struct[0].Gy[222,28] = 135.409614082600
        struct[0].Gy[222,174] = 45.1365380275333
        struct[0].Gy[222,222] = -180.546152110133
        struct[0].Gy[222,412] = 1
        struct[0].Gy[223,29] = 135.409614082600
        struct[0].Gy[223,175] = 45.1365380275333
        struct[0].Gy[223,223] = -180.546152110133
        struct[0].Gy[224,176] = 45.1365380275333
        struct[0].Gy[224,224] = -180.546152110133
        struct[0].Gy[224,230] = 135.409614082600
        struct[0].Gy[225,177] = 45.1365380275333
        struct[0].Gy[225,225] = -180.546152110133
        struct[0].Gy[225,231] = 135.409614082600
        struct[0].Gy[226,178] = 45.1365380275333
        struct[0].Gy[226,226] = -180.546152110133
        struct[0].Gy[226,232] = 135.409614082600
        struct[0].Gy[227,179] = 45.1365380275333
        struct[0].Gy[227,227] = -180.546152110133
        struct[0].Gy[227,233] = 135.409614082600
        struct[0].Gy[228,30] = 135.409614082600
        struct[0].Gy[228,180] = 45.1365380275333
        struct[0].Gy[228,228] = -180.546152110133
        struct[0].Gy[228,413] = 1
        struct[0].Gy[229,31] = 135.409614082600
        struct[0].Gy[229,181] = 45.1365380275333
        struct[0].Gy[229,229] = -180.546152110133
        struct[0].Gy[230,224] = 135.409614082600
        struct[0].Gy[230,230] = -135.409614082600
        struct[0].Gy[231,225] = 135.409614082600
        struct[0].Gy[231,231] = -135.409614082600
        struct[0].Gy[232,226] = 135.409614082600
        struct[0].Gy[232,232] = -135.409614082600
        struct[0].Gy[233,227] = 135.409614082600
        struct[0].Gy[233,233] = -135.409614082600
        struct[0].Gy[234,0] = -0.212261128378539
        struct[0].Gy[234,1] = -0.849044513514155
        struct[0].Gy[234,2] = 0.212261128378539
        struct[0].Gy[234,3] = 0.849044513514155
        struct[0].Gy[234,234] = -1
        struct[0].Gy[235,0] = 0.849044513514155
        struct[0].Gy[235,1] = -0.212261128378539
        struct[0].Gy[235,2] = -0.849044513514155
        struct[0].Gy[235,3] = 0.212261128378539
        struct[0].Gy[235,235] = -1
        struct[0].Gy[236,2] = -0.212261128378539
        struct[0].Gy[236,3] = -0.849044513514155
        struct[0].Gy[236,4] = 0.212261128378539
        struct[0].Gy[236,5] = 0.849044513514155
        struct[0].Gy[236,236] = -1
        struct[0].Gy[237,2] = 0.849044513514155
        struct[0].Gy[237,3] = -0.212261128378539
        struct[0].Gy[237,4] = -0.849044513514155
        struct[0].Gy[237,5] = 0.212261128378539
        struct[0].Gy[237,237] = -1
        struct[0].Gy[238,0] = 0.212261128378539
        struct[0].Gy[238,1] = 0.849044513514155
        struct[0].Gy[238,4] = -0.212261128378539
        struct[0].Gy[238,5] = -0.849044513514155
        struct[0].Gy[238,238] = -1
        struct[0].Gy[239,0] = -0.849044513514155
        struct[0].Gy[239,1] = 0.212261128378539
        struct[0].Gy[239,4] = 0.849044513514155
        struct[0].Gy[239,5] = -0.212261128378539
        struct[0].Gy[239,239] = -1
        struct[0].Gy[240,0] = 105.571769313180
        struct[0].Gy[240,1] = 54.0657727682604
        struct[0].Gy[240,2] = -39.6392229058202
        struct[0].Gy[240,3] = -10.2713736253513
        struct[0].Gy[240,4] = -24.9575997948692
        struct[0].Gy[240,5] = -23.2849644809540
        struct[0].Gy[240,6] = -39.6392229058202
        struct[0].Gy[240,7] = -10.2713736253513
        struct[0].Gy[240,48] = -105.571769313180
        struct[0].Gy[240,49] = -54.0657727682604
        struct[0].Gy[240,50] = 39.6392229058202
        struct[0].Gy[240,51] = 10.2713736253513
        struct[0].Gy[240,52] = 24.9575997948692
        struct[0].Gy[240,53] = 23.2849644809540
        struct[0].Gy[240,54] = 39.6392229058202
        struct[0].Gy[240,55] = 10.2713736253513
        struct[0].Gy[240,240] = -1
        struct[0].Gy[241,0] = -54.0657727682604
        struct[0].Gy[241,1] = 105.571769313180
        struct[0].Gy[241,2] = 10.2713736253513
        struct[0].Gy[241,3] = -39.6392229058202
        struct[0].Gy[241,4] = 23.2849644809540
        struct[0].Gy[241,5] = -24.9575997948692
        struct[0].Gy[241,6] = 10.2713736253513
        struct[0].Gy[241,7] = -39.6392229058202
        struct[0].Gy[241,48] = 54.0657727682604
        struct[0].Gy[241,49] = -105.571769313180
        struct[0].Gy[241,50] = -10.2713736253513
        struct[0].Gy[241,51] = 39.6392229058202
        struct[0].Gy[241,52] = -23.2849644809540
        struct[0].Gy[241,53] = 24.9575997948692
        struct[0].Gy[241,54] = -10.2713736253513
        struct[0].Gy[241,55] = 39.6392229058202
        struct[0].Gy[241,241] = -1
        struct[0].Gy[242,0] = -39.6392229058202
        struct[0].Gy[242,1] = -10.2713736253513
        struct[0].Gy[242,2] = 105.571769313180
        struct[0].Gy[242,3] = 54.0657727682604
        struct[0].Gy[242,4] = -39.6392229058201
        struct[0].Gy[242,5] = -10.2713736253513
        struct[0].Gy[242,6] = -24.9575997948692
        struct[0].Gy[242,7] = -23.2849644809540
        struct[0].Gy[242,48] = 39.6392229058202
        struct[0].Gy[242,49] = 10.2713736253513
        struct[0].Gy[242,50] = -105.571769313180
        struct[0].Gy[242,51] = -54.0657727682604
        struct[0].Gy[242,52] = 39.6392229058201
        struct[0].Gy[242,53] = 10.2713736253513
        struct[0].Gy[242,54] = 24.9575997948692
        struct[0].Gy[242,55] = 23.2849644809540
        struct[0].Gy[242,242] = -1
        struct[0].Gy[243,0] = 10.2713736253513
        struct[0].Gy[243,1] = -39.6392229058202
        struct[0].Gy[243,2] = -54.0657727682604
        struct[0].Gy[243,3] = 105.571769313180
        struct[0].Gy[243,4] = 10.2713736253513
        struct[0].Gy[243,5] = -39.6392229058201
        struct[0].Gy[243,6] = 23.2849644809540
        struct[0].Gy[243,7] = -24.9575997948692
        struct[0].Gy[243,48] = -10.2713736253513
        struct[0].Gy[243,49] = 39.6392229058202
        struct[0].Gy[243,50] = 54.0657727682604
        struct[0].Gy[243,51] = -105.571769313180
        struct[0].Gy[243,52] = -10.2713736253513
        struct[0].Gy[243,53] = 39.6392229058201
        struct[0].Gy[243,54] = -23.2849644809540
        struct[0].Gy[243,55] = 24.9575997948692
        struct[0].Gy[243,243] = -1
        struct[0].Gy[244,0] = -24.9575997948692
        struct[0].Gy[244,1] = -23.2849644809540
        struct[0].Gy[244,2] = -39.6392229058202
        struct[0].Gy[244,3] = -10.2713736253513
        struct[0].Gy[244,4] = 105.571769313180
        struct[0].Gy[244,5] = 54.0657727682604
        struct[0].Gy[244,6] = -39.6392229058201
        struct[0].Gy[244,7] = -10.2713736253514
        struct[0].Gy[244,48] = 24.9575997948692
        struct[0].Gy[244,49] = 23.2849644809540
        struct[0].Gy[244,50] = 39.6392229058202
        struct[0].Gy[244,51] = 10.2713736253513
        struct[0].Gy[244,52] = -105.571769313180
        struct[0].Gy[244,53] = -54.0657727682604
        struct[0].Gy[244,54] = 39.6392229058201
        struct[0].Gy[244,55] = 10.2713736253514
        struct[0].Gy[244,244] = -1
        struct[0].Gy[245,0] = 23.2849644809540
        struct[0].Gy[245,1] = -24.9575997948692
        struct[0].Gy[245,2] = 10.2713736253513
        struct[0].Gy[245,3] = -39.6392229058202
        struct[0].Gy[245,4] = -54.0657727682604
        struct[0].Gy[245,5] = 105.571769313180
        struct[0].Gy[245,6] = 10.2713736253514
        struct[0].Gy[245,7] = -39.6392229058201
        struct[0].Gy[245,48] = -23.2849644809540
        struct[0].Gy[245,49] = 24.9575997948692
        struct[0].Gy[245,50] = -10.2713736253513
        struct[0].Gy[245,51] = 39.6392229058202
        struct[0].Gy[245,52] = 54.0657727682604
        struct[0].Gy[245,53] = -105.571769313180
        struct[0].Gy[245,54] = -10.2713736253514
        struct[0].Gy[245,55] = 39.6392229058201
        struct[0].Gy[245,245] = -1
        struct[0].Gy[246,240] = 1
        struct[0].Gy[246,242] = 1
        struct[0].Gy[246,244] = 1
        struct[0].Gy[246,246] = -1
        struct[0].Gy[247,241] = 1
        struct[0].Gy[247,243] = 1
        struct[0].Gy[247,245] = 1
        struct[0].Gy[247,247] = -1
        struct[0].Gy[248,166] = -67.7048070412999
        struct[0].Gy[248,248] = -1
        struct[0].Gy[249,167] = -67.7048070412999
        struct[0].Gy[249,249] = -1
        struct[0].Gy[250,168] = -67.7048070412999
        struct[0].Gy[250,250] = -1
        struct[0].Gy[251,169] = -67.7048070412999
        struct[0].Gy[251,251] = -1
        struct[0].Gy[252,170] = -67.7048070412999
        struct[0].Gy[252,252] = -1
        struct[0].Gy[253,171] = -67.7048070412999
        struct[0].Gy[253,253] = -1
        struct[0].Gy[254,248] = 1
        struct[0].Gy[254,250] = 1
        struct[0].Gy[254,252] = 1
        struct[0].Gy[254,254] = -1
        struct[0].Gy[255,249] = 1
        struct[0].Gy[255,251] = 1
        struct[0].Gy[255,253] = 1
        struct[0].Gy[255,255] = -1
        struct[0].Gy[256,166] = 135.409614082600
        struct[0].Gy[256,174] = -135.409614082600
        struct[0].Gy[256,256] = -1
        struct[0].Gy[257,167] = 135.409614082600
        struct[0].Gy[257,175] = -135.409614082600
        struct[0].Gy[257,257] = -1
        struct[0].Gy[258,168] = 135.409614082600
        struct[0].Gy[258,176] = -135.409614082600
        struct[0].Gy[258,258] = -1
        struct[0].Gy[259,169] = 135.409614082600
        struct[0].Gy[259,177] = -135.409614082600
        struct[0].Gy[259,259] = -1
        struct[0].Gy[260,170] = 135.409614082600
        struct[0].Gy[260,178] = -135.409614082600
        struct[0].Gy[260,260] = -1
        struct[0].Gy[261,171] = 135.409614082600
        struct[0].Gy[261,179] = -135.409614082600
        struct[0].Gy[261,261] = -1
        struct[0].Gy[262,256] = 1
        struct[0].Gy[262,258] = 1
        struct[0].Gy[262,260] = 1
        struct[0].Gy[262,262] = -1
        struct[0].Gy[263,257] = 1
        struct[0].Gy[263,259] = 1
        struct[0].Gy[263,261] = 1
        struct[0].Gy[263,263] = -1
        struct[0].Gy[264,174] = 67.7048070412999
        struct[0].Gy[264,182] = -67.7048070412999
        struct[0].Gy[264,264] = -1
        struct[0].Gy[265,175] = 67.7048070412999
        struct[0].Gy[265,183] = -67.7048070412999
        struct[0].Gy[265,265] = -1
        struct[0].Gy[266,176] = 67.7048070412999
        struct[0].Gy[266,184] = -67.7048070412999
        struct[0].Gy[266,266] = -1
        struct[0].Gy[267,177] = 67.7048070412999
        struct[0].Gy[267,185] = -67.7048070412999
        struct[0].Gy[267,267] = -1
        struct[0].Gy[268,178] = 67.7048070412999
        struct[0].Gy[268,186] = -67.7048070412999
        struct[0].Gy[268,268] = -1
        struct[0].Gy[269,179] = 67.7048070412999
        struct[0].Gy[269,187] = -67.7048070412999
        struct[0].Gy[269,269] = -1
        struct[0].Gy[270,264] = 1
        struct[0].Gy[270,266] = 1
        struct[0].Gy[270,268] = 1
        struct[0].Gy[270,270] = -1
        struct[0].Gy[271,265] = 1
        struct[0].Gy[271,267] = 1
        struct[0].Gy[271,269] = 1
        struct[0].Gy[271,271] = -1
        struct[0].Gy[272,182] = 45.1365380275333
        struct[0].Gy[272,190] = -45.1365380275333
        struct[0].Gy[272,272] = -1
        struct[0].Gy[273,183] = 45.1365380275333
        struct[0].Gy[273,191] = -45.1365380275333
        struct[0].Gy[273,273] = -1
        struct[0].Gy[274,184] = 45.1365380275333
        struct[0].Gy[274,192] = -45.1365380275333
        struct[0].Gy[274,274] = -1
        struct[0].Gy[275,185] = 45.1365380275333
        struct[0].Gy[275,193] = -45.1365380275333
        struct[0].Gy[275,275] = -1
        struct[0].Gy[276,186] = 45.1365380275333
        struct[0].Gy[276,194] = -45.1365380275333
        struct[0].Gy[276,276] = -1
        struct[0].Gy[277,187] = 45.1365380275333
        struct[0].Gy[277,195] = -45.1365380275333
        struct[0].Gy[277,277] = -1
        struct[0].Gy[278,272] = 1
        struct[0].Gy[278,274] = 1
        struct[0].Gy[278,276] = 1
        struct[0].Gy[278,278] = -1
        struct[0].Gy[279,273] = 1
        struct[0].Gy[279,275] = 1
        struct[0].Gy[279,277] = 1
        struct[0].Gy[279,279] = -1
        struct[0].Gy[280,190] = 157.977883096366
        struct[0].Gy[280,198] = -157.977883096366
        struct[0].Gy[280,280] = -1
        struct[0].Gy[281,191] = 157.977883096366
        struct[0].Gy[281,199] = -157.977883096366
        struct[0].Gy[281,281] = -1
        struct[0].Gy[282,192] = 157.977883096366
        struct[0].Gy[282,200] = -157.977883096366
        struct[0].Gy[282,282] = -1
        struct[0].Gy[283,193] = 157.977883096366
        struct[0].Gy[283,201] = -157.977883096366
        struct[0].Gy[283,283] = -1
        struct[0].Gy[284,194] = 157.977883096366
        struct[0].Gy[284,202] = -157.977883096366
        struct[0].Gy[284,284] = -1
        struct[0].Gy[285,195] = 157.977883096366
        struct[0].Gy[285,203] = -157.977883096366
        struct[0].Gy[285,285] = -1
        struct[0].Gy[286,280] = 1
        struct[0].Gy[286,282] = 1
        struct[0].Gy[286,284] = 1
        struct[0].Gy[286,286] = -1
        struct[0].Gy[287,281] = 1
        struct[0].Gy[287,283] = 1
        struct[0].Gy[287,285] = 1
        struct[0].Gy[287,287] = -1
        struct[0].Gy[288,32] = -157.977883096366
        struct[0].Gy[288,166] = 157.977883096366
        struct[0].Gy[288,288] = -1
        struct[0].Gy[289,33] = -157.977883096366
        struct[0].Gy[289,167] = 157.977883096366
        struct[0].Gy[289,289] = -1
        struct[0].Gy[290,168] = 157.977883096366
        struct[0].Gy[290,206] = -157.977883096366
        struct[0].Gy[290,290] = -1
        struct[0].Gy[291,169] = 157.977883096366
        struct[0].Gy[291,207] = -157.977883096366
        struct[0].Gy[291,291] = -1
        struct[0].Gy[292,170] = 157.977883096366
        struct[0].Gy[292,208] = -157.977883096366
        struct[0].Gy[292,292] = -1
        struct[0].Gy[293,171] = 157.977883096366
        struct[0].Gy[293,209] = -157.977883096366
        struct[0].Gy[293,293] = -1
        struct[0].Gy[294,288] = 1
        struct[0].Gy[294,290] = 1
        struct[0].Gy[294,292] = 1
        struct[0].Gy[294,294] = -1
        struct[0].Gy[295,289] = 1
        struct[0].Gy[295,291] = 1
        struct[0].Gy[295,293] = 1
        struct[0].Gy[295,295] = -1
        struct[0].Gy[296,36] = -157.977883096366
        struct[0].Gy[296,182] = 157.977883096366
        struct[0].Gy[296,296] = -1
        struct[0].Gy[297,37] = -157.977883096366
        struct[0].Gy[297,183] = 157.977883096366
        struct[0].Gy[297,297] = -1
        struct[0].Gy[298,184] = 157.977883096366
        struct[0].Gy[298,210] = -157.977883096366
        struct[0].Gy[298,298] = -1
        struct[0].Gy[299,185] = 157.977883096366
        struct[0].Gy[299,211] = -157.977883096366
        struct[0].Gy[299,299] = -1
        struct[0].Gy[300,186] = 157.977883096366
        struct[0].Gy[300,212] = -157.977883096366
        struct[0].Gy[300,300] = -1
        struct[0].Gy[301,187] = 157.977883096366
        struct[0].Gy[301,213] = -157.977883096366
        struct[0].Gy[301,301] = -1
        struct[0].Gy[302,296] = 1
        struct[0].Gy[302,298] = 1
        struct[0].Gy[302,300] = 1
        struct[0].Gy[302,302] = -1
        struct[0].Gy[303,297] = 1
        struct[0].Gy[303,299] = 1
        struct[0].Gy[303,301] = 1
        struct[0].Gy[303,303] = -1
        struct[0].Gy[304,40] = -157.977883096366
        struct[0].Gy[304,190] = 157.977883096366
        struct[0].Gy[304,304] = -1
        struct[0].Gy[305,41] = -157.977883096366
        struct[0].Gy[305,191] = 157.977883096366
        struct[0].Gy[305,305] = -1
        struct[0].Gy[306,192] = 157.977883096366
        struct[0].Gy[306,214] = -157.977883096366
        struct[0].Gy[306,306] = -1
        struct[0].Gy[307,193] = 157.977883096366
        struct[0].Gy[307,215] = -157.977883096366
        struct[0].Gy[307,307] = -1
        struct[0].Gy[308,194] = 157.977883096366
        struct[0].Gy[308,216] = -157.977883096366
        struct[0].Gy[308,308] = -1
        struct[0].Gy[309,195] = 157.977883096366
        struct[0].Gy[309,217] = -157.977883096366
        struct[0].Gy[309,309] = -1
        struct[0].Gy[310,304] = 1
        struct[0].Gy[310,306] = 1
        struct[0].Gy[310,308] = 1
        struct[0].Gy[310,310] = -1
        struct[0].Gy[311,305] = 1
        struct[0].Gy[311,307] = 1
        struct[0].Gy[311,309] = 1
        struct[0].Gy[311,311] = -1
        struct[0].Gy[312,44] = -157.977883096366
        struct[0].Gy[312,198] = 157.977883096366
        struct[0].Gy[312,312] = -1
        struct[0].Gy[313,45] = -157.977883096366
        struct[0].Gy[313,199] = 157.977883096366
        struct[0].Gy[313,313] = -1
        struct[0].Gy[314,200] = 157.977883096366
        struct[0].Gy[314,218] = -157.977883096366
        struct[0].Gy[314,314] = -1
        struct[0].Gy[315,201] = 157.977883096366
        struct[0].Gy[315,219] = -157.977883096366
        struct[0].Gy[315,315] = -1
        struct[0].Gy[316,202] = 157.977883096366
        struct[0].Gy[316,220] = -157.977883096366
        struct[0].Gy[316,316] = -1
        struct[0].Gy[317,203] = 157.977883096366
        struct[0].Gy[317,221] = -157.977883096366
        struct[0].Gy[317,317] = -1
        struct[0].Gy[318,312] = 1
        struct[0].Gy[318,314] = 1
        struct[0].Gy[318,316] = 1
        struct[0].Gy[318,318] = -1
        struct[0].Gy[319,313] = 1
        struct[0].Gy[319,315] = 1
        struct[0].Gy[319,317] = 1
        struct[0].Gy[319,319] = -1
        struct[0].Gy[320,174] = 45.1365380275333
        struct[0].Gy[320,222] = -45.1365380275333
        struct[0].Gy[320,320] = -1
        struct[0].Gy[321,175] = 45.1365380275333
        struct[0].Gy[321,223] = -45.1365380275333
        struct[0].Gy[321,321] = -1
        struct[0].Gy[322,176] = 45.1365380275333
        struct[0].Gy[322,224] = -45.1365380275333
        struct[0].Gy[322,322] = -1
        struct[0].Gy[323,177] = 45.1365380275333
        struct[0].Gy[323,225] = -45.1365380275333
        struct[0].Gy[323,323] = -1
        struct[0].Gy[324,178] = 45.1365380275333
        struct[0].Gy[324,226] = -45.1365380275333
        struct[0].Gy[324,324] = -1
        struct[0].Gy[325,179] = 45.1365380275333
        struct[0].Gy[325,227] = -45.1365380275333
        struct[0].Gy[325,325] = -1
        struct[0].Gy[326,320] = 1
        struct[0].Gy[326,322] = 1
        struct[0].Gy[326,324] = 1
        struct[0].Gy[326,326] = -1
        struct[0].Gy[327,321] = 1
        struct[0].Gy[327,323] = 1
        struct[0].Gy[327,325] = 1
        struct[0].Gy[327,327] = -1
        struct[0].Gy[328,28] = -135.409614082600
        struct[0].Gy[328,222] = 135.409614082600
        struct[0].Gy[328,328] = -1
        struct[0].Gy[329,29] = -135.409614082600
        struct[0].Gy[329,223] = 135.409614082600
        struct[0].Gy[329,329] = -1
        struct[0].Gy[330,224] = 135.409614082600
        struct[0].Gy[330,230] = -135.409614082600
        struct[0].Gy[330,330] = -1
        struct[0].Gy[331,225] = 135.409614082600
        struct[0].Gy[331,231] = -135.409614082600
        struct[0].Gy[331,331] = -1
        struct[0].Gy[332,226] = 135.409614082600
        struct[0].Gy[332,232] = -135.409614082600
        struct[0].Gy[332,332] = -1
        struct[0].Gy[333,227] = 135.409614082600
        struct[0].Gy[333,233] = -135.409614082600
        struct[0].Gy[333,333] = -1
        struct[0].Gy[334,328] = 1
        struct[0].Gy[334,330] = 1
        struct[0].Gy[334,332] = 1
        struct[0].Gy[334,334] = -1
        struct[0].Gy[335,329] = 1
        struct[0].Gy[335,331] = 1
        struct[0].Gy[335,333] = 1
        struct[0].Gy[335,335] = -1
        struct[0].Gy[336,0] = i_load_R1_a_r
        struct[0].Gy[336,1] = i_load_R1_a_i
        struct[0].Gy[336,6] = -i_load_R1_a_r
        struct[0].Gy[336,7] = -i_load_R1_a_i
        struct[0].Gy[336,336] = v_R1_a_r - v_R1_n_r
        struct[0].Gy[336,337] = v_R1_a_i - v_R1_n_i
        struct[0].Gy[337,2] = i_load_R1_b_r
        struct[0].Gy[337,3] = i_load_R1_b_i
        struct[0].Gy[337,6] = -i_load_R1_b_r
        struct[0].Gy[337,7] = -i_load_R1_b_i
        struct[0].Gy[337,338] = v_R1_b_r - v_R1_n_r
        struct[0].Gy[337,339] = v_R1_b_i - v_R1_n_i
        struct[0].Gy[338,4] = i_load_R1_c_r
        struct[0].Gy[338,5] = i_load_R1_c_i
        struct[0].Gy[338,6] = -i_load_R1_c_r
        struct[0].Gy[338,7] = -i_load_R1_c_i
        struct[0].Gy[338,340] = v_R1_c_r - v_R1_n_r
        struct[0].Gy[338,341] = v_R1_c_i - v_R1_n_i
        struct[0].Gy[339,0] = -i_load_R1_a_i
        struct[0].Gy[339,1] = i_load_R1_a_r
        struct[0].Gy[339,6] = i_load_R1_a_i
        struct[0].Gy[339,7] = -i_load_R1_a_r
        struct[0].Gy[339,336] = v_R1_a_i - v_R1_n_i
        struct[0].Gy[339,337] = -v_R1_a_r + v_R1_n_r
        struct[0].Gy[340,2] = -i_load_R1_b_i
        struct[0].Gy[340,3] = i_load_R1_b_r
        struct[0].Gy[340,6] = i_load_R1_b_i
        struct[0].Gy[340,7] = -i_load_R1_b_r
        struct[0].Gy[340,338] = v_R1_b_i - v_R1_n_i
        struct[0].Gy[340,339] = -v_R1_b_r + v_R1_n_r
        struct[0].Gy[341,4] = -i_load_R1_c_i
        struct[0].Gy[341,5] = i_load_R1_c_r
        struct[0].Gy[341,6] = i_load_R1_c_i
        struct[0].Gy[341,7] = -i_load_R1_c_r
        struct[0].Gy[341,340] = v_R1_c_i - v_R1_n_i
        struct[0].Gy[341,341] = -v_R1_c_r + v_R1_n_r
        struct[0].Gy[342,336] = 1
        struct[0].Gy[342,338] = 1
        struct[0].Gy[342,340] = 1
        struct[0].Gy[342,342] = 1
        struct[0].Gy[343,337] = 1
        struct[0].Gy[343,339] = 1
        struct[0].Gy[343,341] = 1
        struct[0].Gy[343,343] = 1
        struct[0].Gy[344,8] = i_load_R11_a_r
        struct[0].Gy[344,9] = 1.0*i_load_R11_a_i
        struct[0].Gy[344,10] = -i_load_R11_a_r
        struct[0].Gy[344,11] = -1.0*i_load_R11_a_i
        struct[0].Gy[344,344] = v_R11_a_r - v_R11_n_r
        struct[0].Gy[344,345] = 1.0*v_R11_a_i - 1.0*v_R11_n_i
        struct[0].Gy[345,8] = -1.0*i_load_R11_a_i
        struct[0].Gy[345,9] = 1.0*i_load_R11_a_r
        struct[0].Gy[345,10] = 1.0*i_load_R11_a_i
        struct[0].Gy[345,11] = -1.0*i_load_R11_a_r
        struct[0].Gy[345,344] = 1.0*v_R11_a_i - 1.0*v_R11_n_i
        struct[0].Gy[345,345] = -1.0*v_R11_a_r + 1.0*v_R11_n_r
        struct[0].Gy[346,344] = 1
        struct[0].Gy[346,346] = 1
        struct[0].Gy[347,345] = 1.00000000000000
        struct[0].Gy[347,347] = 1.00000000000000
        struct[0].Gy[348,12] = i_load_R15_a_r
        struct[0].Gy[348,13] = 1.0*i_load_R15_a_i
        struct[0].Gy[348,14] = -i_load_R15_a_r
        struct[0].Gy[348,15] = -1.0*i_load_R15_a_i
        struct[0].Gy[348,348] = v_R15_a_r - v_R15_n_r
        struct[0].Gy[348,349] = 1.0*v_R15_a_i - 1.0*v_R15_n_i
        struct[0].Gy[349,12] = -1.0*i_load_R15_a_i
        struct[0].Gy[349,13] = 1.0*i_load_R15_a_r
        struct[0].Gy[349,14] = 1.0*i_load_R15_a_i
        struct[0].Gy[349,15] = -1.0*i_load_R15_a_r
        struct[0].Gy[349,348] = 1.0*v_R15_a_i - 1.0*v_R15_n_i
        struct[0].Gy[349,349] = -1.0*v_R15_a_r + 1.0*v_R15_n_r
        struct[0].Gy[350,348] = 1
        struct[0].Gy[350,350] = 1
        struct[0].Gy[351,349] = 1.00000000000000
        struct[0].Gy[351,351] = 1.00000000000000
        struct[0].Gy[352,16] = i_load_R16_a_r
        struct[0].Gy[352,17] = 1.0*i_load_R16_a_i
        struct[0].Gy[352,18] = -i_load_R16_a_r
        struct[0].Gy[352,19] = -1.0*i_load_R16_a_i
        struct[0].Gy[352,352] = v_R16_a_r - v_R16_n_r
        struct[0].Gy[352,353] = 1.0*v_R16_a_i - 1.0*v_R16_n_i
        struct[0].Gy[353,16] = -1.0*i_load_R16_a_i
        struct[0].Gy[353,17] = 1.0*i_load_R16_a_r
        struct[0].Gy[353,18] = 1.0*i_load_R16_a_i
        struct[0].Gy[353,19] = -1.0*i_load_R16_a_r
        struct[0].Gy[353,352] = 1.0*v_R16_a_i - 1.0*v_R16_n_i
        struct[0].Gy[353,353] = -1.0*v_R16_a_r + 1.0*v_R16_n_r
        struct[0].Gy[354,352] = 1
        struct[0].Gy[354,354] = 1
        struct[0].Gy[355,353] = 1.00000000000000
        struct[0].Gy[355,355] = 1.00000000000000
        struct[0].Gy[356,20] = i_load_R17_a_r
        struct[0].Gy[356,21] = 1.0*i_load_R17_a_i
        struct[0].Gy[356,22] = -i_load_R17_a_r
        struct[0].Gy[356,23] = -1.0*i_load_R17_a_i
        struct[0].Gy[356,356] = v_R17_a_r - v_R17_n_r
        struct[0].Gy[356,357] = 1.0*v_R17_a_i - 1.0*v_R17_n_i
        struct[0].Gy[357,20] = -1.0*i_load_R17_a_i
        struct[0].Gy[357,21] = 1.0*i_load_R17_a_r
        struct[0].Gy[357,22] = 1.0*i_load_R17_a_i
        struct[0].Gy[357,23] = -1.0*i_load_R17_a_r
        struct[0].Gy[357,356] = 1.0*v_R17_a_i - 1.0*v_R17_n_i
        struct[0].Gy[357,357] = -1.0*v_R17_a_r + 1.0*v_R17_n_r
        struct[0].Gy[358,356] = 1
        struct[0].Gy[358,358] = 1
        struct[0].Gy[359,357] = 1.00000000000000
        struct[0].Gy[359,359] = 1.00000000000000
        struct[0].Gy[360,24] = i_load_R18_a_r
        struct[0].Gy[360,25] = 1.0*i_load_R18_a_i
        struct[0].Gy[360,26] = -i_load_R18_a_r
        struct[0].Gy[360,27] = -1.0*i_load_R18_a_i
        struct[0].Gy[360,360] = v_R18_a_r - v_R18_n_r
        struct[0].Gy[360,361] = 1.0*v_R18_a_i - 1.0*v_R18_n_i
        struct[0].Gy[361,24] = -1.0*i_load_R18_a_i
        struct[0].Gy[361,25] = 1.0*i_load_R18_a_r
        struct[0].Gy[361,26] = 1.0*i_load_R18_a_i
        struct[0].Gy[361,27] = -1.0*i_load_R18_a_r
        struct[0].Gy[361,360] = 1.0*v_R18_a_i - 1.0*v_R18_n_i
        struct[0].Gy[361,361] = -1.0*v_R18_a_r + 1.0*v_R18_n_r
        struct[0].Gy[362,360] = 1
        struct[0].Gy[362,362] = 1
        struct[0].Gy[363,361] = 1.00000000000000
        struct[0].Gy[363,363] = 1.00000000000000
        struct[0].Gy[364,28] = i_load_D15_a_r
        struct[0].Gy[364,29] = 1.0*i_load_D15_a_i
        struct[0].Gy[364,30] = -i_load_D15_a_r
        struct[0].Gy[364,31] = -1.0*i_load_D15_a_i
        struct[0].Gy[364,364] = v_D15_a_r - v_D15_n_r
        struct[0].Gy[364,365] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy[365,28] = -1.0*i_load_D15_a_i
        struct[0].Gy[365,29] = 1.0*i_load_D15_a_r
        struct[0].Gy[365,30] = 1.0*i_load_D15_a_i
        struct[0].Gy[365,31] = -1.0*i_load_D15_a_r
        struct[0].Gy[365,364] = 1.0*v_D15_a_i - 1.0*v_D15_n_i
        struct[0].Gy[365,365] = -1.0*v_D15_a_r + 1.0*v_D15_n_r
        struct[0].Gy[366,364] = 1
        struct[0].Gy[366,366] = 1
        struct[0].Gy[367,365] = 1.00000000000000
        struct[0].Gy[367,367] = 1.00000000000000
        struct[0].Gy[368,32] = i_load_D11_a_r
        struct[0].Gy[368,33] = 1.0*i_load_D11_a_i
        struct[0].Gy[368,34] = -i_load_D11_a_r
        struct[0].Gy[368,35] = -1.0*i_load_D11_a_i
        struct[0].Gy[368,368] = v_D11_a_r - v_D11_n_r
        struct[0].Gy[368,369] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy[369,32] = -1.0*i_load_D11_a_i
        struct[0].Gy[369,33] = 1.0*i_load_D11_a_r
        struct[0].Gy[369,34] = 1.0*i_load_D11_a_i
        struct[0].Gy[369,35] = -1.0*i_load_D11_a_r
        struct[0].Gy[369,368] = 1.0*v_D11_a_i - 1.0*v_D11_n_i
        struct[0].Gy[369,369] = -1.0*v_D11_a_r + 1.0*v_D11_n_r
        struct[0].Gy[370,368] = 1
        struct[0].Gy[370,370] = 1
        struct[0].Gy[371,369] = 1.00000000000000
        struct[0].Gy[371,371] = 1.00000000000000
        struct[0].Gy[372,36] = i_load_D16_a_r
        struct[0].Gy[372,37] = 1.0*i_load_D16_a_i
        struct[0].Gy[372,38] = -i_load_D16_a_r
        struct[0].Gy[372,39] = -1.0*i_load_D16_a_i
        struct[0].Gy[372,372] = v_D16_a_r - v_D16_n_r
        struct[0].Gy[372,373] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy[373,36] = -1.0*i_load_D16_a_i
        struct[0].Gy[373,37] = 1.0*i_load_D16_a_r
        struct[0].Gy[373,38] = 1.0*i_load_D16_a_i
        struct[0].Gy[373,39] = -1.0*i_load_D16_a_r
        struct[0].Gy[373,372] = 1.0*v_D16_a_i - 1.0*v_D16_n_i
        struct[0].Gy[373,373] = -1.0*v_D16_a_r + 1.0*v_D16_n_r
        struct[0].Gy[374,372] = 1
        struct[0].Gy[374,374] = 1
        struct[0].Gy[375,373] = 1.00000000000000
        struct[0].Gy[375,375] = 1.00000000000000
        struct[0].Gy[376,40] = i_load_D17_a_r
        struct[0].Gy[376,41] = 1.0*i_load_D17_a_i
        struct[0].Gy[376,42] = -i_load_D17_a_r
        struct[0].Gy[376,43] = -1.0*i_load_D17_a_i
        struct[0].Gy[376,376] = v_D17_a_r - v_D17_n_r
        struct[0].Gy[376,377] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy[377,40] = -1.0*i_load_D17_a_i
        struct[0].Gy[377,41] = 1.0*i_load_D17_a_r
        struct[0].Gy[377,42] = 1.0*i_load_D17_a_i
        struct[0].Gy[377,43] = -1.0*i_load_D17_a_r
        struct[0].Gy[377,376] = 1.0*v_D17_a_i - 1.0*v_D17_n_i
        struct[0].Gy[377,377] = -1.0*v_D17_a_r + 1.0*v_D17_n_r
        struct[0].Gy[378,376] = 1
        struct[0].Gy[378,378] = 1
        struct[0].Gy[379,377] = 1.00000000000000
        struct[0].Gy[379,379] = 1.00000000000000
        struct[0].Gy[380,44] = i_load_D18_a_r
        struct[0].Gy[380,45] = 1.0*i_load_D18_a_i
        struct[0].Gy[380,46] = -i_load_D18_a_r
        struct[0].Gy[380,47] = -1.0*i_load_D18_a_i
        struct[0].Gy[380,380] = v_D18_a_r - v_D18_n_r
        struct[0].Gy[380,381] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy[381,44] = -1.0*i_load_D18_a_i
        struct[0].Gy[381,45] = 1.0*i_load_D18_a_r
        struct[0].Gy[381,46] = 1.0*i_load_D18_a_i
        struct[0].Gy[381,47] = -1.0*i_load_D18_a_r
        struct[0].Gy[381,380] = 1.0*v_D18_a_i - 1.0*v_D18_n_i
        struct[0].Gy[381,381] = -1.0*v_D18_a_r + 1.0*v_D18_n_r
        struct[0].Gy[382,380] = 1
        struct[0].Gy[382,382] = 1
        struct[0].Gy[383,381] = 1.00000000000000
        struct[0].Gy[383,383] = 1.00000000000000
        struct[0].Gy[384,0] = i_vsc_R1_a_r
        struct[0].Gy[384,1] = 1.0*i_vsc_R1_a_i
        struct[0].Gy[384,6] = -i_vsc_R1_a_r
        struct[0].Gy[384,7] = -1.0*i_vsc_R1_a_i
        struct[0].Gy[384,384] = v_R1_a_r - v_R1_n_r
        struct[0].Gy[384,385] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy[384,390] = -1/3
        struct[0].Gy[385,0] = -1.0*i_vsc_R1_a_i
        struct[0].Gy[385,1] = 1.0*i_vsc_R1_a_r
        struct[0].Gy[385,6] = 1.0*i_vsc_R1_a_i
        struct[0].Gy[385,7] = -1.0*i_vsc_R1_a_r
        struct[0].Gy[385,384] = 1.0*v_R1_a_i - 1.0*v_R1_n_i
        struct[0].Gy[385,385] = -1.0*v_R1_a_r + 1.0*v_R1_n_r
        struct[0].Gy[386,2] = i_vsc_R1_b_r
        struct[0].Gy[386,3] = 1.0*i_vsc_R1_b_i
        struct[0].Gy[386,6] = -i_vsc_R1_b_r
        struct[0].Gy[386,7] = -1.0*i_vsc_R1_b_i
        struct[0].Gy[386,386] = v_R1_b_r - v_R1_n_r
        struct[0].Gy[386,387] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy[386,390] = -1/3
        struct[0].Gy[387,2] = -1.0*i_vsc_R1_b_i
        struct[0].Gy[387,3] = 1.0*i_vsc_R1_b_r
        struct[0].Gy[387,6] = 1.0*i_vsc_R1_b_i
        struct[0].Gy[387,7] = -1.0*i_vsc_R1_b_r
        struct[0].Gy[387,386] = 1.0*v_R1_b_i - 1.0*v_R1_n_i
        struct[0].Gy[387,387] = -1.0*v_R1_b_r + 1.0*v_R1_n_r
        struct[0].Gy[388,4] = i_vsc_R1_c_r
        struct[0].Gy[388,5] = 1.0*i_vsc_R1_c_i
        struct[0].Gy[388,6] = -i_vsc_R1_c_r
        struct[0].Gy[388,7] = -1.0*i_vsc_R1_c_i
        struct[0].Gy[388,388] = v_R1_c_r - v_R1_n_r
        struct[0].Gy[388,389] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy[388,390] = -1/3
        struct[0].Gy[389,4] = -1.0*i_vsc_R1_c_i
        struct[0].Gy[389,5] = 1.0*i_vsc_R1_c_r
        struct[0].Gy[389,6] = 1.0*i_vsc_R1_c_i
        struct[0].Gy[389,7] = -1.0*i_vsc_R1_c_r
        struct[0].Gy[389,388] = 1.0*v_R1_c_i - 1.0*v_R1_n_i
        struct[0].Gy[389,389] = -1.0*v_R1_c_r + 1.0*v_R1_n_r
        struct[0].Gy[390,390] = 1
        struct[0].Gy[390,391] = 1
        struct[0].Gy[390,392] = Piecewise(np.array([(-1, p_D1 < 0), (1, True)]))
        struct[0].Gy[391,248] = v_D1_a_r
        struct[0].Gy[391,254] = v_D1_n_r
        struct[0].Gy[391,391] = -1
        struct[0].Gy[392,384] = -b_R1*i_vsc_R1_a_r/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_r
        struct[0].Gy[392,385] = -b_R1*i_vsc_R1_a_i/sqrt(i_vsc_R1_a_i**2 + i_vsc_R1_a_r**2 + 0.1) - 2*c_R1*i_vsc_R1_a_i
        struct[0].Gy[392,392] = 1
        struct[0].Gy[393,112] = i_vsc_R10_a_r
        struct[0].Gy[393,113] = 1.0*i_vsc_R10_a_i
        struct[0].Gy[393,118] = -i_vsc_R10_a_r
        struct[0].Gy[393,119] = -1.0*i_vsc_R10_a_i
        struct[0].Gy[393,393] = v_R10_a_r - v_R10_n_r
        struct[0].Gy[393,394] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy[394,112] = -1.0*i_vsc_R10_a_i
        struct[0].Gy[394,113] = 1.0*i_vsc_R10_a_r
        struct[0].Gy[394,118] = 1.0*i_vsc_R10_a_i
        struct[0].Gy[394,119] = -1.0*i_vsc_R10_a_r
        struct[0].Gy[394,393] = 1.0*v_R10_a_i - 1.0*v_R10_n_i
        struct[0].Gy[394,394] = -1.0*v_R10_a_r + 1.0*v_R10_n_r
        struct[0].Gy[395,114] = i_vsc_R10_b_r
        struct[0].Gy[395,115] = 1.0*i_vsc_R10_b_i
        struct[0].Gy[395,118] = -i_vsc_R10_b_r
        struct[0].Gy[395,119] = -1.0*i_vsc_R10_b_i
        struct[0].Gy[395,395] = v_R10_b_r - v_R10_n_r
        struct[0].Gy[395,396] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy[396,114] = -1.0*i_vsc_R10_b_i
        struct[0].Gy[396,115] = 1.0*i_vsc_R10_b_r
        struct[0].Gy[396,118] = 1.0*i_vsc_R10_b_i
        struct[0].Gy[396,119] = -1.0*i_vsc_R10_b_r
        struct[0].Gy[396,395] = 1.0*v_R10_b_i - 1.0*v_R10_n_i
        struct[0].Gy[396,396] = -1.0*v_R10_b_r + 1.0*v_R10_n_r
        struct[0].Gy[397,116] = i_vsc_R10_c_r
        struct[0].Gy[397,117] = 1.0*i_vsc_R10_c_i
        struct[0].Gy[397,118] = -i_vsc_R10_c_r
        struct[0].Gy[397,119] = -1.0*i_vsc_R10_c_i
        struct[0].Gy[397,397] = v_R10_c_r - v_R10_n_r
        struct[0].Gy[397,398] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy[398,116] = -1.0*i_vsc_R10_c_i
        struct[0].Gy[398,117] = 1.0*i_vsc_R10_c_r
        struct[0].Gy[398,118] = 1.0*i_vsc_R10_c_i
        struct[0].Gy[398,119] = -1.0*i_vsc_R10_c_r
        struct[0].Gy[398,397] = 1.0*v_R10_c_i - 1.0*v_R10_n_i
        struct[0].Gy[398,398] = -1.0*v_R10_c_r + 1.0*v_R10_n_r
        struct[0].Gy[399,393] = 1
        struct[0].Gy[399,395] = 1
        struct[0].Gy[399,397] = 1
        struct[0].Gy[399,399] = 1
        struct[0].Gy[400,394] = 1
        struct[0].Gy[400,396] = 1
        struct[0].Gy[400,398] = 1
        struct[0].Gy[400,400] = 1
        struct[0].Gy[401,198] = -p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[401,204] = p_D10/(v_D10_a_r - v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[401,401] = 1
        struct[0].Gy[401,403] = 1/(v_D10_a_r - v_D10_n_r + 1.0e-8)
        struct[0].Gy[402,198] = p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[402,204] = -p_D10/(-v_D10_a_r + v_D10_n_r + 1.0e-8)**2
        struct[0].Gy[402,402] = 1
        struct[0].Gy[402,403] = 1/(-v_D10_a_r + v_D10_n_r + 1.0e-8)
        struct[0].Gy[403,393] = Piecewise(np.array([(b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_r, p_D10 < 0), (-b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_r, p_D10 > 0), (b_R10*i_vsc_R10_a_r/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_r, True)]))
        struct[0].Gy[403,394] = Piecewise(np.array([(b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_i, p_D10 < 0), (-b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) - 2*c_R10*i_vsc_R10_a_i, p_D10 > 0), (b_R10*i_vsc_R10_a_i/sqrt(i_vsc_R10_a_i**2 + i_vsc_R10_a_r**2 + 0.1) + 2*c_R10*i_vsc_R10_a_i, True)]))
        struct[0].Gy[403,403] = 1
        struct[0].Gy[404,140] = i_vsc_R14_a_r
        struct[0].Gy[404,141] = 1.0*i_vsc_R14_a_i
        struct[0].Gy[404,146] = -i_vsc_R14_a_r
        struct[0].Gy[404,147] = -1.0*i_vsc_R14_a_i
        struct[0].Gy[404,404] = v_R14_a_r - v_R14_n_r
        struct[0].Gy[404,405] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy[405,140] = -1.0*i_vsc_R14_a_i
        struct[0].Gy[405,141] = 1.0*i_vsc_R14_a_r
        struct[0].Gy[405,146] = 1.0*i_vsc_R14_a_i
        struct[0].Gy[405,147] = -1.0*i_vsc_R14_a_r
        struct[0].Gy[405,404] = 1.0*v_R14_a_i - 1.0*v_R14_n_i
        struct[0].Gy[405,405] = -1.0*v_R14_a_r + 1.0*v_R14_n_r
        struct[0].Gy[406,142] = i_vsc_R14_b_r
        struct[0].Gy[406,143] = 1.0*i_vsc_R14_b_i
        struct[0].Gy[406,146] = -i_vsc_R14_b_r
        struct[0].Gy[406,147] = -1.0*i_vsc_R14_b_i
        struct[0].Gy[406,406] = v_R14_b_r - v_R14_n_r
        struct[0].Gy[406,407] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy[407,142] = -1.0*i_vsc_R14_b_i
        struct[0].Gy[407,143] = 1.0*i_vsc_R14_b_r
        struct[0].Gy[407,146] = 1.0*i_vsc_R14_b_i
        struct[0].Gy[407,147] = -1.0*i_vsc_R14_b_r
        struct[0].Gy[407,406] = 1.0*v_R14_b_i - 1.0*v_R14_n_i
        struct[0].Gy[407,407] = -1.0*v_R14_b_r + 1.0*v_R14_n_r
        struct[0].Gy[408,144] = i_vsc_R14_c_r
        struct[0].Gy[408,145] = 1.0*i_vsc_R14_c_i
        struct[0].Gy[408,146] = -i_vsc_R14_c_r
        struct[0].Gy[408,147] = -1.0*i_vsc_R14_c_i
        struct[0].Gy[408,408] = v_R14_c_r - v_R14_n_r
        struct[0].Gy[408,409] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy[409,144] = -1.0*i_vsc_R14_c_i
        struct[0].Gy[409,145] = 1.0*i_vsc_R14_c_r
        struct[0].Gy[409,146] = 1.0*i_vsc_R14_c_i
        struct[0].Gy[409,147] = -1.0*i_vsc_R14_c_r
        struct[0].Gy[409,408] = 1.0*v_R14_c_i - 1.0*v_R14_n_i
        struct[0].Gy[409,409] = -1.0*v_R14_c_r + 1.0*v_R14_n_r
        struct[0].Gy[410,404] = 1
        struct[0].Gy[410,406] = 1
        struct[0].Gy[410,408] = 1
        struct[0].Gy[410,410] = 1
        struct[0].Gy[411,405] = 1
        struct[0].Gy[411,407] = 1
        struct[0].Gy[411,409] = 1
        struct[0].Gy[411,411] = 1
        struct[0].Gy[412,222] = -p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[412,228] = p_D14/(v_D14_a_r - v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[412,412] = 1
        struct[0].Gy[412,414] = 1/(v_D14_a_r - v_D14_n_r + 1.0e-8)
        struct[0].Gy[413,222] = p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[413,228] = -p_D14/(-v_D14_a_r + v_D14_n_r + 1.0e-8)**2
        struct[0].Gy[413,413] = 1
        struct[0].Gy[413,414] = 1/(-v_D14_a_r + v_D14_n_r + 1.0e-8)
        struct[0].Gy[414,404] = Piecewise(np.array([(b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_r, p_D14 < 0), (-b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_r, p_D14 > 0), (b_R14*i_vsc_R14_a_r/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_r, True)]))
        struct[0].Gy[414,405] = Piecewise(np.array([(b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_i, p_D14 < 0), (-b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) - 2*c_R14*i_vsc_R14_a_i, p_D14 > 0), (b_R14*i_vsc_R14_a_i/sqrt(i_vsc_R14_a_i**2 + i_vsc_R14_a_r**2 + 0.1) + 2*c_R14*i_vsc_R14_a_i, True)]))
        struct[0].Gy[414,414] = 1

        struct[0].Gu[0,0] = 0.212261128378539
        struct[0].Gu[0,1] = 0.849044513514155
        struct[0].Gu[0,4] = -0.212261128378539
        struct[0].Gu[0,5] = -0.849044513514155
        struct[0].Gu[1,0] = -0.849044513514155
        struct[0].Gu[1,1] = 0.212261128378539
        struct[0].Gu[1,4] = 0.849044513514155
        struct[0].Gu[1,5] = -0.212261128378539
        struct[0].Gu[2,0] = -0.212261128378539
        struct[0].Gu[2,1] = -0.849044513514155
        struct[0].Gu[2,2] = 0.212261128378539
        struct[0].Gu[2,3] = 0.849044513514155
        struct[0].Gu[3,0] = 0.849044513514155
        struct[0].Gu[3,1] = -0.212261128378539
        struct[0].Gu[3,2] = -0.849044513514155
        struct[0].Gu[3,3] = 0.212261128378539
        struct[0].Gu[4,2] = -0.212261128378539
        struct[0].Gu[4,3] = -0.849044513514155
        struct[0].Gu[4,4] = 0.212261128378539
        struct[0].Gu[4,5] = 0.849044513514155
        struct[0].Gu[5,2] = 0.849044513514155
        struct[0].Gu[5,3] = -0.212261128378539
        struct[0].Gu[5,4] = -0.849044513514155
        struct[0].Gu[5,5] = 0.212261128378539
        struct[0].Gu[166,6] = 67.7048070412999
        struct[0].Gu[167,7] = 67.7048070412999
        struct[0].Gu[168,8] = 67.7048070412999
        struct[0].Gu[169,9] = 67.7048070412999
        struct[0].Gu[170,10] = 67.7048070412999
        struct[0].Gu[171,11] = 67.7048070412999
        struct[0].Gu[234,0] = 0.00490196078431373
        struct[0].Gu[234,1] = 0.0196078431372549
        struct[0].Gu[234,2] = -0.00245098039215686
        struct[0].Gu[234,3] = -0.00980392156862745
        struct[0].Gu[234,4] = -0.00245098039215686
        struct[0].Gu[234,5] = -0.00980392156862745
        struct[0].Gu[235,0] = -0.0196078431372549
        struct[0].Gu[235,1] = 0.00490196078431373
        struct[0].Gu[235,2] = 0.00980392156862745
        struct[0].Gu[235,3] = -0.00245098039215686
        struct[0].Gu[235,4] = 0.00980392156862745
        struct[0].Gu[235,5] = -0.00245098039215686
        struct[0].Gu[236,0] = -0.00245098039215686
        struct[0].Gu[236,1] = -0.00980392156862745
        struct[0].Gu[236,2] = 0.00490196078431373
        struct[0].Gu[236,3] = 0.0196078431372549
        struct[0].Gu[236,4] = -0.00245098039215686
        struct[0].Gu[236,5] = -0.00980392156862745
        struct[0].Gu[237,0] = 0.00980392156862745
        struct[0].Gu[237,1] = -0.00245098039215686
        struct[0].Gu[237,2] = -0.0196078431372549
        struct[0].Gu[237,3] = 0.00490196078431373
        struct[0].Gu[237,4] = 0.00980392156862745
        struct[0].Gu[237,5] = -0.00245098039215686
        struct[0].Gu[238,0] = -0.00245098039215686
        struct[0].Gu[238,1] = -0.00980392156862745
        struct[0].Gu[238,2] = -0.00245098039215686
        struct[0].Gu[238,3] = -0.00980392156862745
        struct[0].Gu[238,4] = 0.00490196078431373
        struct[0].Gu[238,5] = 0.0196078431372549
        struct[0].Gu[239,0] = 0.00980392156862745
        struct[0].Gu[239,1] = -0.00245098039215686
        struct[0].Gu[239,2] = 0.00980392156862745
        struct[0].Gu[239,3] = -0.00245098039215686
        struct[0].Gu[239,4] = -0.0196078431372549
        struct[0].Gu[239,5] = 0.00490196078431373
        struct[0].Gu[248,6] = 67.7048070412999
        struct[0].Gu[249,7] = 67.7048070412999
        struct[0].Gu[250,8] = 67.7048070412999
        struct[0].Gu[251,9] = 67.7048070412999
        struct[0].Gu[252,10] = 67.7048070412999
        struct[0].Gu[253,11] = 67.7048070412999
        struct[0].Gu[336,196] = -1
        struct[0].Gu[337,198] = -1
        struct[0].Gu[338,200] = -1
        struct[0].Gu[339,197] = -1
        struct[0].Gu[340,199] = -1
        struct[0].Gu[341,201] = -1
        struct[0].Gu[344,202] = -1
        struct[0].Gu[345,203] = -1
        struct[0].Gu[348,204] = -1
        struct[0].Gu[349,205] = -1
        struct[0].Gu[352,206] = -1
        struct[0].Gu[353,207] = -1
        struct[0].Gu[356,208] = -1
        struct[0].Gu[357,209] = -1
        struct[0].Gu[360,210] = -1
        struct[0].Gu[361,211] = -1
        struct[0].Gu[364,212] = -1
        struct[0].Gu[365,213] = -1
        struct[0].Gu[368,214] = -1
        struct[0].Gu[369,215] = -1
        struct[0].Gu[372,216] = -1
        struct[0].Gu[373,217] = -1
        struct[0].Gu[376,218] = -1
        struct[0].Gu[377,219] = -1
        struct[0].Gu[380,220] = -1
        struct[0].Gu[381,221] = -1
        struct[0].Gu[385,223] = -1/3
        struct[0].Gu[387,223] = -1/3
        struct[0].Gu[389,223] = -1/3
        struct[0].Gu[393,224] = -coef_a_R10
        struct[0].Gu[394,225] = -coef_a_R10
        struct[0].Gu[395,224] = -coef_b_R10
        struct[0].Gu[396,225] = -coef_b_R10
        struct[0].Gu[397,224] = -coef_c_R10
        struct[0].Gu[398,225] = -coef_c_R10
        struct[0].Gu[403,224] = -1
        struct[0].Gu[404,226] = -coef_a_R14
        struct[0].Gu[405,227] = -coef_a_R14
        struct[0].Gu[406,226] = -coef_b_R14
        struct[0].Gu[407,227] = -coef_b_R14
        struct[0].Gu[408,226] = -coef_c_R14
        struct[0].Gu[409,227] = -coef_c_R14
        struct[0].Gu[414,226] = -1





@numba.njit(cache=True)
def Piecewise(arg):
    out = arg[0][1]
    N = len(arg)
    for it in range(N-1,-1,-1):
        if arg[it][1]: out = arg[it][0]
    return out

@numba.njit(cache=True)
def ITE(arg):
    out = arg[0][1]
    N = len(arg)
    for it in range(N-1,-1,-1):
        if arg[it][1]: out = arg[it][0]
    return out


@numba.njit(cache=True)
def Abs(x):
    return np.abs(x)


@numba.njit(cache=True)
def ini_dae_jacobian_numba(struct,x):
    N_x = struct[0].N_x
    N_y = struct[0].N_y
    struct[0].x[:,0] = x[0:N_x]
    struct[0].y_ini[:,0] = x[N_x:(N_x+N_y)]

    ini(struct,10)
    ini(struct,11) 

    for row,col in zip(struct[0].Fx_ini_rows,struct[0].Fx_ini_cols):
        struct[0].Ac_ini[row,col] = struct[0].Fx_ini[row,col]
    for row,col in zip(struct[0].Fy_ini_rows,struct[0].Fy_ini_cols):
        struct[0].Ac_ini[row,col+N_x] = struct[0].Fy_ini[row,col]
    for row,col in zip(struct[0].Gx_ini_rows,struct[0].Gx_ini_cols):
        struct[0].Ac_ini[row+N_x,col] = struct[0].Gx_ini[row,col]
    for row,col in zip(struct[0].Gy_ini_rows,struct[0].Gy_ini_cols):
        struct[0].Ac_ini[row+N_x,col+N_x] = struct[0].Gy_ini[row,col]
        

@numba.njit(cache=True)
def ini_dae_problem(struct,x):
    N_x = struct[0].N_x
    N_y = struct[0].N_y
    struct[0].x[:,0] = x[0:N_x]
    struct[0].y_ini[:,0] = x[N_x:(N_x+N_y)]

    ini(struct,2)
    ini(struct,3) 
    struct[0].fg[:N_x,:] = struct[0].f[:]
    struct[0].fg[N_x:,:] = struct[0].g[:]    
        
@numba.njit(cache=True)
def ssate(struct,xy):
    for it in range(100):
        ini_dae_jacobian_numba(struct,xy[:,0])
        ini_dae_problem(struct,xy[:,0])
        xy[:] += np.linalg.solve(struct[0].Ac_ini,-struct[0].fg)
        if np.max(np.abs(struct[0].fg[:,0]))<1e-8: break
    N_x = struct[0].N_x
    struct[0].x[:,0] = xy[:N_x,0]
    struct[0].y_ini[:,0] = xy[N_x:,0]
    return xy,it


@numba.njit(cache=True) 
def daesolver(struct): 
    sin = np.sin
    cos = np.cos
    sqrt = np.sqrt
    i = 0 
    
    Dt = struct[i].Dt 

    N_x = struct[i].N_x
    N_y = struct[i].N_y
    N_z = struct[i].N_z

    decimation = struct[i].decimation 
    eye = np.eye(N_x)
    t = struct[i].t 
    t_end = struct[i].t_end 
    if struct[i].it == 0:
        run(t,struct, 1) 
        struct[i].it_store = 0  
        struct[i]['T'][0] = t 
        struct[i].X[0,:] = struct[i].x[:,0]  
        struct[i].Y[0,:] = struct[i].y_run[:,0]  
        struct[i].Z[0,:] = struct[i].h[:,0]  

    solver = struct[i].solvern 
    while t<t_end: 
        struct[i].it += 1
        struct[i].t += Dt
        
        t = struct[i].t


            
        if solver == 5: # Teapezoidal DAE as in Milano's book

            run(t,struct, 2) 
            run(t,struct, 3) 

            x = np.copy(struct[i].x[:]) 
            y = np.copy(struct[i].y_run[:]) 
            f = np.copy(struct[i].f[:]) 
            g = np.copy(struct[i].g[:]) 
            
            for iter in range(struct[i].imax):
                run(t,struct, 2) 
                run(t,struct, 3) 
                run(t,struct,10) 
                run(t,struct,11) 
                
                x_i = struct[i].x[:] 
                y_i = struct[i].y_run[:]  
                f_i = struct[i].f[:] 
                g_i = struct[i].g[:]                 
                F_x_i = struct[i].Fx[:,:]
                F_y_i = struct[i].Fy[:,:] 
                G_x_i = struct[i].Gx[:,:] 
                G_y_i = struct[i].Gy[:,:]                

                A_c_i = np.vstack((np.hstack((eye-0.5*Dt*F_x_i, -0.5*Dt*F_y_i)),
                                   np.hstack((G_x_i,         G_y_i))))
                     
                f_n_i = x_i - x - 0.5*Dt*(f_i+f) 
                # print(t,iter,g_i)
                Dxy_i = np.linalg.solve(-A_c_i,np.vstack((f_n_i,g_i))) 
                
                x_i = x_i + Dxy_i[0:N_x]
                y_i = y_i + Dxy_i[N_x:(N_x+N_y)]

                struct[i].x[:] = x_i
                struct[i].y_run[:] = y_i

        # [f_i,g_i,F_x_i,F_y_i,G_x_i,G_y_i] =  smib_transient(x_i,y_i,u);
        
        # A_c_i = [[eye(N_x)-0.5*Dt*F_x_i, -0.5*Dt*F_y_i],
        #          [                G_x_i,         G_y_i]];
             
        # f_n_i = x_i - x - 0.5*Dt*(f_i+f);
        
        # Dxy_i = -A_c_i\[f_n_i.',g_i.'].';
        
        # x_i = x_i + Dxy_i(1:N_x);
        # y_i = y_i + Dxy_i(N_x+1:N_x+N_y);
                
                xy = np.vstack((x_i,y_i))
                max_relative = 0.0
                for it_var in range(N_x+N_y):
                    abs_value = np.abs(xy[it_var,0])
                    if abs_value < 0.001:
                        abs_value = 0.001
                                             
                    relative_error = np.abs(Dxy_i[it_var,0])/abs_value
                    
                    if relative_error > max_relative: max_relative = relative_error
                    
                if max_relative<struct[i].itol:
                    
                    break
                
                # if iter>struct[i].imax-2:
                    
                #     print('Convergence problem')

            struct[i].x[:] = x_i
            struct[i].y_run[:] = y_i
                
        # channels 
        if struct[i].store == 1:
            it_store = struct[i].it_store
            if struct[i].it >= it_store*decimation: 
                struct[i]['T'][it_store+1] = t 
                struct[i].X[it_store+1,:] = struct[i].x[:,0] 
                struct[i].Y[it_store+1,:] = struct[i].y_run[:,0]
                struct[i].Z[it_store+1,:] = struct[i].h[:,0]
                struct[i].iters[it_store+1,0] = iter
                struct[i].it_store += 1 
            
    struct[i].t = t

    return t





def nonzeros():
    Fx_ini_rows = [0]

    Fx_ini_cols = [0]

    Fy_ini_rows = []

    Fy_ini_cols = []

    Gx_ini_rows = []

    Gx_ini_cols = []

    Gy_ini_rows = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 29, 29, 29, 30, 30, 30, 31, 31, 31, 32, 32, 32, 33, 33, 33, 34, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37, 37, 38, 38, 38, 39, 39, 39, 40, 40, 40, 41, 41, 41, 42, 42, 42, 43, 43, 43, 44, 44, 44, 45, 45, 45, 46, 46, 46, 47, 47, 47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 