import numpy as np
import numba
import scipy.optimize as sopt
import scipy.sparse as sspa
from scipy.sparse.linalg import spsolve,spilu,splu
from numba import cuda


import json

sin = np.sin
cos = np.cos
atan2 = np.arctan2
sqrt = np.sqrt 
sign = np.sign 
exp = np.exp


class cigre_europe_residential_4w2w_dbf_class: 

    def __init__(self): 

        self.t_end = 10.000000 
        self.Dt = 0.0010000 
        self.decimation = 10.000000 
        self.itol = 1e-6 
        self.Dt_max = 0.001000 
        self.Dt_min = 0.001000 
        self.solvern = 5 
        self.imax = 100 
        self.N_x = 1
        self.N_y = 433 
        self.N_z = 123 
        self.N_store = 10000 
        self.params_list = ['a_R1', 'b_R1', 'c_R1', 'a_R10', 'b_R10', 'c_R10', 'coef_a_R10', 'coef_b_R10', 'coef_c_R10', 'a_R14', 'b_R14', 'c_R14', 'coef_a_R14', 'coef_b_R14', 'coef_c_R14'] 
        self.params_values_list  = [2.92, 0.45, 0.027, 2.92, 0.45, 0.027, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 2.92, 0.45, 0.027, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333] 
        self.inputs_ini_list = ['v_R0_a_r', 'v_R0_a_i', 'v_R0_b_r', 'v_R0_b_i', 'v_R0_c_r', 'v_R0_c_i', 'v_D1_a_r', 'v_D1_a_i', 'v_D1_b_r', 'v_D1_b_i', 'v_D1_c_r', 'v_D1_c_i', 'i_R1_n_r', 'i_R1_n_i', 'i_R11_n_r', 'i_R11_n_i', 'i_R15_n_r', 'i_R15_n_i', 'i_R16_n_r', 'i_R16_n_i', 'i_R17_n_r', 'i_R17_n_i', 'i_R18_n_r', 'i_R18_n_i', 'i_R2_a_r', 'i_R2_a_i', 'i_R2_b_r', 'i_R2_b_i', 'i_R2_c_r', 'i_R2_c_i', 'i_R2_n_r', 'i_R2_n_i', 'i_R3_a_r', 'i_R3_a_i', 'i_R3_b_r', 'i_R3_b_i', 'i_R3_c_r', 'i_R3_c_i', 'i_R3_n_r', 'i_R3_n_i', 'i_R4_a_r', 'i_R4_a_i', 'i_R4_b_r', 'i_R4_b_i', 'i_R4_c_r', 'i_R4_c_i', 'i_R4_n_r', 'i_R4_n_i', 'i_R5_a_r', 'i_R5_a_i', 'i_R5_b_r', 'i_R5_b_i', 'i_R5_c_r', 'i_R5_c_i', 'i_R5_n_r', 'i_R5_n_i', 'i_R6_a_r', 'i_R6_a_i', 'i_R6_b_r', 'i_R6_b_i', 'i_R6_c_r', 'i_R6_c_i', 'i_R6_n_r', 'i_R6_n_i', 'i_R7_a_r', 'i_R7_a_i', 'i_R7_b_r', 'i_R7_b_i', 'i_R7_c_r', 'i_R7_c_i', 'i_R7_n_r', 'i_R7_n_i', 'i_R8_a_r', 'i_R8_a_i', 'i_R8_b_r', 'i_R8_b_i', 'i_R8_c_r', 'i_R8_c_i', 'i_R8_n_r', 'i_R8_n_i', 'i_R9_a_r', 'i_R9_a_i', 'i_R9_b_r', 'i_R9_b_i', 'i_R9_c_r', 'i_R9_c_i', 'i_R9_n_r', 'i_R9_n_i', 'i_R10_a_r', 'i_R10_a_i', 'i_R10_b_r', 'i_R10_b_i', 'i_R10_c_r', 'i_R10_c_i', 'i_R10_n_r', 'i_R10_n_i', 'i_R12_a_r', 'i_R12_a_i', 'i_R12_b_r', 'i_R12_b_i', 'i_R12_c_r', 'i_R12_c_i', 'i_R12_n_r', 'i_R12_n_i', 'i_R13_a_r', 'i_R13_a_i', 'i_R13_b_r', 'i_R13_b_i', 'i_R13_c_r', 'i_R13_c_i', 'i_R13_n_r', 'i_R13_n_i', 'i_R14_a_r', 'i_R14_a_i', 'i_R14_b_r', 'i_R14_b_i', 'i_R14_c_r', 'i_R14_c_i', 'i_R14_n_r', 'i_R14_n_i', 'i_D1_n_r', 'i_D1_n_i', 'i_D3_a_r', 'i_D3_a_i', 'i_D3_b_r', 'i_D3_b_i', 'i_D3_c_r', 'i_D3_c_i', 'i_D3_n_r', 'i_D3_n_i', 'i_D4_a_r', 'i_D4_a_i', 'i_D4_b_r', 'i_D4_b_i', 'i_D4_c_r', 'i_D4_c_i', 'i_D4_n_r', 'i_D4_n_i', 'i_D6_a_r', 'i_D6_a_i', 'i_D6_b_r', 'i_D6_b_i', 'i_D6_c_r', 'i_D6_c_i', 'i_D6_n_r', 'i_D6_n_i', 'i_D9_a_r', 'i_D9_a_i', 'i_D9_b_r', 'i_D9_b_i', 'i_D9_c_r', 'i_D9_c_i', 'i_D9_n_r', 'i_D9_n_i', 'i_D10_a_i', 'i_D10_b_r', 'i_D10_b_i', 'i_D10_c_r', 'i_D10_c_i', 'i_D10_n_i', 'i_D11_b_r', 'i_D11_b_i', 'i_D11_c_r', 'i_D11_c_i', 'i_D16_b_r', 'i_D16_b_i', 'i_D16_c_r', 'i_D16_c_i', 'i_D17_b_r', 'i_D17_b_i', 'i_D17_c_r', 'i_D17_c_i', 'i_D18_b_r', 'i_D18_b_i', 'i_D18_c_r', 'i_D18_c_i', 'i_D14_a_i', 'i_D14_b_r', 'i_D14_b_i', 'i_D14_c_r', 'i_D14_c_i', 'i_D14_n_i', 'i_D15_b_r', 'i_D15_b_i', 'i_D15_c_r', 'i_D15_c_i', 'p_R1_a', 'q_R1_a', 'p_R1_b', 'q_R1_b', 'p_R1_c', 'q_R1_c', 'p_R11_a', 'q_R11_a', 'p_R11_b', 'q_R11_b', 'p_R11_c', 'q_R11_c', 'p_R15_a', 'q_R15_a', 'p_R15_b', 'q_R15_b', 'p_R15_c', 'q_R15_c', 'p_R16_a', 'q_R16_a', 'p_R16_b', 'q_R16_b', 'p_R16_c', 'q_R16_c', 'p_R17_a', 'q_R17_a', 'p_R17_b', 'q_R17_b', 'p_R17_c', 'q_R17_c', 'p_R18_a', 'q_R18_a', 'p_R18_b', 'q_R18_b', 'p_R18_c', 'q_R18_c', 'p_D15_1', 'q_D15_1', 'p_D11_1', 'q_D11_1', 'p_D16_1', 'q_D16_1', 'p_D17_1', 'q_D17_1', 'p_D18_1', 'q_D18_1', 'v_dc_D1', 'q_R1', 'p_R10', 'q_R10', 'p_R14', 'q_R14', 'u_dummy'] 
        self.inputs_ini_values_list  = [11547.0, 0.0, -5773.499999999997, -9999.995337498915, -5773.5000000000055, 9999.99533749891, 800.0, 0.0, 0.0, -0.0, -0.0, 0.0, -0.11377181081280696, -0.062435919138408735, 0.038921773012907224, -0.1048963759937358, 0.34454059643019264, -0.7980789681157034, 0.37357657109664544, -0.8707524308167933, 0.3054824960816518, -0.6990681853205416, 0.4382865509753664, -0.9973969692563287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -63333.333333333765, -20816.659994665173, -63333.33333333563, -20816.659994662015, -63333.33333333578, -20816.65999465767, -4750.000000000053, -1561.2494995996628, -4749.999999999867, -1561.24949959979, -4750.000000000133, -1561.2494995994743, -16466.666666665096, -5412.33159861012, -16466.666666668374, -5412.331598611336, -16466.66666666625, -5412.331598613994, -17416.666666666664, -5724.581498531865, -17416.666666666515, -5724.5814985328325, -17416.66666666606, -5724.581498532622, -11083.333333333874, -3642.9154990660636, -11083.333333333529, -3642.9154990657007, -11083.333333333101, -3642.9154990652314, -14883.33333333232, -4891.91509874379, -14883.333333334123, -4891.91509874528, -14883.333333332876, -4891.915098746649, 174505.2828211094, 0.0, 174505.2828211094, 0.0, 174505.28282110934, 0.0, 174505.28282110937, 0.0, 174505.28282110937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0] 
        self.inputs_run_list = ['v_R0_a_r', 'v_R0_a_i', 'v_R0_b_r', 'v_R0_b_i', 'v_R0_c_r', 'v_R0_c_i', 'v_D1_a_r', 'v_D1_a_i', 'v_D1_b_r', 'v_D1_b_i', 'v_D1_c_r', 'v_D1_c_i', 'i_R1_n_r', 'i_R1_n_i', 'i_R11_n_r', 'i_R11_n_i', 'i_R15_n_r', 'i_R15_n_i', 'i_R16_n_r', 'i_R16_n_i', 'i_R17_n_r', 'i_R17_n_i', 'i_R18_n_r', 'i_R18_n_i', 'i_R2_a_r', 'i_R2_a_i', 'i_R2_b_r', 'i_R2_b_i', 'i_R2_c_r', 'i_R2_c_i', 'i_R2_n_r', 'i_R2_n_i', 'i_R3_a_r', 'i_R3_a_i', 'i_R3_b_r', 'i_R3_b_i', 'i_R3_c_r', 'i_R3_c_i', 'i_R3_n_r', 'i_R3_n_i', 'i_R4_a_r', 'i_R4_a_i', 'i_R4_b_r', 'i_R4_b_i', 'i_R4_c_r', 'i_R4_c_i', 'i_R4_n_r', 'i_R4_n_i', 'i_R5_a_r', 'i_R5_a_i', 'i_R5_b_r', 'i_R5_b_i', 'i_R5_c_r', 'i_R5_c_i', 'i_R5_n_r', 'i_R5_n_i', 'i_R6_a_r', 'i_R6_a_i', 'i_R6_b_r', 'i_R6_b_i', 'i_R6_c_r', 'i_R6_c_i', 'i_R6_n_r', 'i_R6_n_i', 'i_R7_a_r', 'i_R7_a_i', 'i_R7_b_r', 'i_R7_b_i', 'i_R7_c_r', 'i_R7_c_i', 'i_R7_n_r', 'i_R7_n_i', 'i_R8_a_r', 'i_R8_a_i', 'i_R8_b_r', 'i_R8_b_i', 'i_R8_c_r', 'i_R8_c_i', 'i_R8_n_r', 'i_R8_n_i', 'i_R9_a_r', 'i_R9_a_i', 'i_R9_b_r', 'i_R9_b_i', 'i_R9_c_r', 'i_R9_c_i', 'i_R9_n_r', 'i_R9_n_i', 'i_R10_a_r', 'i_R10_a_i', 'i_R10_b_r', 'i_R10_b_i', 'i_R10_c_r', 'i_R10_c_i', 'i_R10_n_r', 'i_R10_n_i', 'i_R12_a_r', 'i_R12_a_i', 'i_R12_b_r', 'i_R12_b_i', 'i_R12_c_r', 'i_R12_c_i', 'i_R12_n_r', 'i_R12_n_i', 'i_R13_a_r', 'i_R13_a_i', 'i_R13_b_r', 'i_R13_b_i', 'i_R13_c_r', 'i_R13_c_i', 'i_R13_n_r', 'i_R13_n_i', 'i_R14_a_r', 'i_R14_a_i', 'i_R14_b_r', 'i_R14_b_i', 'i_R14_c_r', 'i_R14_c_i', 'i_R14_n_r', 'i_R14_n_i', 'i_D1_n_r', 'i_D1_n_i', 'i_D3_a_r', 'i_D3_a_i', 'i_D3_b_r', 'i_D3_b_i', 'i_D3_c_r', 'i_D3_c_i', 'i_D3_n_r', 'i_D3_n_i', 'i_D4_a_r', 'i_D4_a_i', 'i_D4_b_r', 'i_D4_b_i', 'i_D4_c_r', 'i_D4_c_i', 'i_D4_n_r', 'i_D4_n_i', 'i_D6_a_r', 'i_D6_a_i', 'i_D6_b_r', 'i_D6_b_i', 'i_D6_c_r', 'i_D6_c_i', 'i_D6_n_r', 'i_D6_n_i', 'i_D9_a_r', 'i_D9_a_i', 'i_D9_b_r', 'i_D9_b_i', 'i_D9_c_r', 'i_D9_c_i', 'i_D9_n_r', 'i_D9_n_i', 'i_D10_a_i', 'i_D10_b_r', 'i_D10_b_i', 'i_D10_c_r', 'i_D10_c_i', 'i_D10_n_i', 'i_D11_b_r', 'i_D11_b_i', 'i_D11_c_r', 'i_D11_c_i', 'i_D16_b_r', 'i_D16_b_i', 'i_D16_c_r', 'i_D16_c_i', 'i_D17_b_r', 'i_D17_b_i', 'i_D17_c_r', 'i_D17_c_i', 'i_D18_b_r', 'i_D18_b_i', 'i_D18_c_r', 'i_D18_c_i', 'i_D14_a_i', 'i_D14_b_r', 'i_D14_b_i', 'i_D14_c_r', 'i_D14_c_i', 'i_D14_n_i', 'i_D15_b_r', 'i_D15_b_i', 'i_D15_c_r', 'i_D15_c_i', 'p_R1_a', 'q_R1_a', 'p_R1_b', 'q_R1_b', 'p_R1_c', 'q_R1_c', 'p_R11_a', 'q_R11_a', 'p_R11_b', 'q_R11_b', 'p_R11_c', 'q_R11_c', 'p_R15_a', 'q_R15_a', 'p_R15_b', 'q_R15_b', 'p_R15_c', 'q_R15_c', 'p_R16_a', 'q_R16_a', 'p_R16_b', 'q_R16_b', 'p_R16_c', 'q_R16_c', 'p_R17_a', 'q_R17_a', 'p_R17_b', 'q_R17_b', 'p_R17_c', 'q_R17_c', 'p_R18_a', 'q_R18_a', 'p_R18_b', 'q_R18_b', 'p_R18_c', 'q_R18_c', 'p_D15_1', 'q_D15_1', 'p_D11_1', 'q_D11_1', 'p_D16_1', 'q_D16_1', 'p_D17_1', 'q_D17_1', 'p_D18_1', 'q_D18_1', 'v_dc_D1', 'q_R1', 'p_R10', 'q_R10', 'p_R14', 'q_R14', 'u_dummy'] 
        self.inputs_run_values_list = [11547.0, 0.0, -5773.499999999997, -9999.995337498915, -5773.5000000000055, 9999.99533749891, 800.0, 0.0, 0.0, -0.0, -0.0, 0.0, -0.11377181081280696, -0.062435919138408735, 0.038921773012907224, -0.1048963759937358, 0.34454059643019264, -0.7980789681157034, 0.37357657109664544, -0.8707524308167933, 0.3054824960816518, -0.6990681853205416, 0.4382865509753664, -0.9973969692563287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -63333.333333333765, -20816.659994665173, -63333.33333333563, -20816.659994662015, -63333.33333333578, -20816.65999465767, -4750.000000000053, -1561.2494995996628, -4749.999999999867, -1561.24949959979, -4750.000000000133, -1561.2494995994743, -16466.666666665096, -5412.33159861012, -16466.666666668374, -5412.331598611336, -16466.66666666625, -5412.331598613994, -17416.666666666664, -5724.581498531865, -17416.666666666515, -5724.5814985328325, -17416.66666666606, -5724.581498532622, -11083.333333333874, -3642.9154990660636, -11083.333333333529, -3642.9154990657007, -11083.333333333101, -3642.9154990652314, -14883.33333333232, -4891.91509874379, -14883.333333334123, -4891.91509874528, -14883.333333332876, -4891.915098746649, 174505.2828211094, 0.0, 174505.2828211094, 0.0, 174505.28282110934, 0.0, 174505.28282110937, 0.0, 174505.28282110937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0] 
        self.outputs_list = ['v_R0_a_m', 'v_R0_b_m', 'v_R0_c_m', 'v_D1_a_m', 'v_D1_b_m', 'v_D1_c_m', 'v_R1_a_m', 'v_R1_b_m', 'v_R1_c_m', 'v_R1_n_m', 'v_R11_a_m', 'v_R11_b_m', 'v_R11_c_m', 'v_R11_n_m', 'v_R15_a_m', 'v_R15_b_m', 'v_R15_c_m', 'v_R15_n_m', 'v_R16_a_m', 'v_R16_b_m', 'v_R16_c_m', 'v_R16_n_m', 'v_R17_a_m', 'v_R17_b_m', 'v_R17_c_m', 'v_R17_n_m', 'v_R18_a_m', 'v_R18_b_m', 'v_R18_c_m', 'v_R18_n_m', 'v_D15_a_m', 'v_D15_n_m', 'v_D11_a_m', 'v_D11_n_m', 'v_D16_a_m', 'v_D16_n_m', 'v_D17_a_m', 'v_D17_n_m', 'v_D18_a_m', 'v_D18_n_m', 'v_R2_a_m', 'v_R2_b_m', 'v_R2_c_m', 'v_R2_n_m', 'v_R3_a_m', 'v_R3_b_m', 'v_R3_c_m', 'v_R3_n_m', 'v_R4_a_m', 'v_R4_b_m', 'v_R4_c_m', 'v_R4_n_m', 'v_R5_a_m', 'v_R5_b_m', 'v_R5_c_m', 'v_R5_n_m', 'v_R6_a_m', 'v_R6_b_m', 'v_R6_c_m', 'v_R6_n_m', 'v_R7_a_m', 'v_R7_b_m', 'v_R7_c_m', 'v_R7_n_m', 'v_R8_a_m', 'v_R8_b_m', 'v_R8_c_m', 'v_R8_n_m', 'v_R9_a_m', 'v_R9_b_m', 'v_R9_c_m', 'v_R9_n_m', 'v_R10_a_m', 'v_R10_b_m', 'v_R10_c_m', 'v_R10_n_m', 'v_R12_a_m', 'v_R12_b_m', 'v_R12_c_m', 'v_R12_n_m', 'v_R13_a_m', 'v_R13_b_m', 'v_R13_c_m', 'v_R13_n_m', 'v_R14_a_m', 'v_R14_b_m', 'v_R14_c_m', 'v_R14_n_m', 'v_D1_n_m', 'v_D3_a_m', 'v_D3_b_m', 'v_D3_c_m', 'v_D3_n_m', 'v_D4_a_m', 'v_D4_b_m', 'v_D4_c_m', 'v_D4_n_m', 'v_D6_a_m', 'v_D6_b_m', 'v_D6_c_m', 'v_D6_n_m', 'v_D9_a_m', 'v_D9_b_m', 'v_D9_c_m', 'v_D9_n_m', 'v_D10_a_m', 'v_D10_b_m', 'v_D10_c_m', 'v_D10_n_m', 'v_D11_b_m', 'v_D11_c_m', 'v_D16_b_m', 'v_D16_c_m', 'v_D17_b_m', 'v_D17_c_m', 'v_D18_b_m', 'v_D18_c_m', 'v_D14_a_m', 'v_D14_b_m', 'v_D14_c_m', 'v_D14_n_m', 'v_D15_b_m', 'v_D15_c_m'] 
        self.x_list = ['x_dummy'] 
        self.y_run_list = ['v_R1_a_r', 'v_R1_a_i', 'v_R1_b_r', 'v_R1_b_i', 'v_R1_c_r', 'v_R1_c_i', 'v_R1_n_r', 'v_R1_n_i', 'v_R11_a_r', 'v_R11_a_i', 'v_R11_b_r', 'v_R11_b_i', 'v_R11_c_r', 'v_R11_c_i', 'v_R11_n_r', 'v_R11_n_i', 'v_R15_a_r', 'v_R15_a_i', 'v_R15_b_r', 'v_R15_b_i', 'v_R15_c_r', 'v_R15_c_i', 'v_R15_n_r', 'v_R15_n_i', 'v_R16_a_r', 'v_R16_a_i', 'v_R16_b_r', 'v_R16_b_i', 'v_R16_c_r', 'v_R16_c_i', 'v_R16_n_r', 'v_R16_n_i', 'v_R17_a_r', 'v_R17_a_i', 'v_R17_b_r', 'v_R17_b_i', 'v_R17_c_r', 'v_R17_c_i', 'v_R17_n_r', 'v_R17_n_i', 'v_R18_a_r', 'v_R18_a_i', 'v_R18_b_r', 'v_R18_b_i', 'v_R18_c_r', 'v_R18_c_i', 'v_R18_n_r', 'v_R18_n_i', 'v_D15_a_r', 'v_D15_a_i', 'v_D15_n_r', 'v_D15_n_i', 'v_D11_a_r', 'v_D11_a_i', 'v_D11_n_r', 'v_D11_n_i', 'v_D16_a_r', 'v_D16_a_i', 'v_D16_n_r', 'v_D16_n_i', 'v_D17_a_r', 'v_D17_a_i', 'v_D17_n_r', 'v_D17_n_i', 'v_D18_a_r', 'v_D18_a_i', 'v_D18_n_r', 'v_D18_n_i', 'v_R2_a_r', 'v_R2_a_i', 'v_R2_b_r', 'v_R2_b_i', 'v_R2_c_r', 'v_R2_c_i', 'v_R2_n_r', 'v_R2_n_i', 'v_R3_a_r', 'v_R3_a_i', 'v_R3_b_r', 'v_R3_b_i', 'v_R3_c_r', 'v_R3_c_i', 'v_R3_n_r', 'v_R3_n_i', 'v_R4_a_r', 'v_R4_a_i', 'v_R4_b_r', 'v_R4_b_i', 'v_R4_c_r', 'v_R4_c_i', 'v_R4_n_r', 'v_R4_n_i', 'v_R5_a_r', 'v_R5_a_i', 'v_R5_b_r', 'v_R5_b_i', 'v_R5_c_r', 'v_R5_c_i', 'v_R5_n_r', 'v_R5_n_i', 'v_R6_a_r', 'v_R6_a_i', 'v_R6_b_r', 'v_R6_b_i', 'v_R6_c_r', 'v_R6_c_i', 'v_R6_n_r', 'v_R6_n_i', 'v_R7_a_r', 'v_R7_a_i', 'v_R7_b_r', 'v_R7_b_i', 'v_R7_c_r', 'v_R7_c_i', 'v_R7_n_r', 'v_R7_n_i', 'v_R8_a_r', 'v_R8_a_i', 'v_R8_b_r', 'v_R8_b_i', 'v_R8_c_r', 'v_R8_c_i', 'v_R8_n_r', 'v_R8_n_i', 'v_R9_a_r', 'v_R9_a_i', 'v_R9_b_r', 'v_R9_b_i', 'v_R9_c_r', 'v_R9_c_i', 'v_R9_n_r', 'v_R9_n_i', 'v_R10_a_r', 'v_R10_a_i', 'v_R10_b_r', 'v_R10_b_i', 'v_R10_c_r', 'v_R10_c_i', 'v_R10_n_r', 'v_R10_n_i', 'v_R12_a_r', 'v_R12_a_i', 'v_R12_b_r', 'v_R12_b_i', 'v_R12_c_r', 'v_R12_c_i', 'v_R12_n_r', 'v_R12_n_i', 'v_R13_a_r', 'v_R13_a_i', 'v_R13_b_r', 'v_R13_b_i', 'v_R13_c_r', 'v_R13_c_i', 'v_R13_n_r', 'v_R13_n_i', 'v_R14_a_r', 'v_R14_a_i', 'v_R14_b_r', 'v_R14_b_i', 'v_R14_c_r', 'v_R14_c_i', 'v_R14_n_r', 'v_R14_n_i', 'v_D1_n_r', 'v_D1_n_i', 'v_D3_a_r', 'v_D3_a_i', 'v_D3_b_r', 'v_D3_b_i', 'v_D3_c_r', 'v_D3_c_i', 'v_D3_n_r', 'v_D3_n_i', 'v_D4_a_r', 'v_D4_a_i', 'v_D4_b_r', 'v_D4_b_i', 'v_D4_c_r', 'v_D4_c_i', 'v_D4_n_r', 'v_D4_n_i', 'v_D6_a_r', 'v_D6_a_i', 'v_D6_b_r', 'v_D6_b_i', 'v_D6_c_r', 'v_D6_c_i', 'v_D6_n_r', 'v_D6_n_i', 'v_D9_a_r', 'v_D9_a_i', 'v_D9_b_r', 'v_D9_b_i', 'v_D9_c_r', 'v_D9_c_i', 'v_D9_n_r', 'v_D9_n_i', 'v_D10_a_r', 'v_D10_a_i', 'v_D10_b_r', 'v_D10_b_i', 'v_D10_c_r', 'v_D10_c_i', 'v_D10_n_r', 'v_D10_n_i', 'v_D11_b_r', 'v_D11_b_i', 'v_D11_c_r', 'v_D11_c_i', 'v_D16_b_r', 'v_D16_b_i', 'v_D16_c_r', 'v_D16_c_i', 'v_D17_b_r', 'v_D17_b_i', 'v_D17_c_r', 'v_D17_c_i', 'v_D18_b_r', 'v_D18_b_i', 'v_D18_c_r', 'v_D18_c_i', 'v_D14_a_r', 'v_D14_a_i', 'v_D14_b_r', 'v_D14_b_i', 'v_D14_c_r', 'v_D14_c_i', 'v_D14_n_r', 'v_D14_n_i', 'v_D15_b_r', 'v_D15_b_i', 'v_D15_c_r', 'v_D15_c_i', 'i_t_R0_R1_a_r', 'i_t_R0_R1_a_i', 'i_t_R0_R1_b_r', 'i_t_R0_R1_b_i', 'i_t_R0_R1_c_r', 'i_t_R0_R1_c_i', 'i_l_R1_R2_a_r', 'i_l_R1_R2_a_i', 'i_l_R1_R2_b_r', 'i_l_R1_R2_b_i', 'i_l_R1_R2_c_r', 'i_l_R1_R2_c_i', 'i_l_R1_R2_n_r', 'i_l_R1_R2_n_i', 'i_l_D1_D3_a_r', 'i_l_D1_D3_a_i', 'i_l_D1_D3_b_r', 'i_l_D1_D3_b_i', 'i_l_D1_D3_c_r', 'i_l_D1_D3_c_i', 'i_l_D1_D3_n_r', 'i_l_D1_D3_n_i', 'i_l_D3_D4_a_r', 'i_l_D3_D4_a_i', 'i_l_D3_D4_b_r', 'i_l_D3_D4_b_i', 'i_l_D3_D4_c_r', 'i_l_D3_D4_c_i', 'i_l_D3_D4_n_r', 'i_l_D3_D4_n_i', 'i_l_D4_D6_a_r', 'i_l_D4_D6_a_i', 'i_l_D4_D6_b_r', 'i_l_D4_D6_b_i', 'i_l_D4_D6_c_r', 'i_l_D4_D6_c_i', 'i_l_D4_D6_n_r', 'i_l_D4_D6_n_i', 'i_l_D6_D9_a_r', 'i_l_D6_D9_a_i', 'i_l_D6_D9_b_r', 'i_l_D6_D9_b_i', 'i_l_D6_D9_c_r', 'i_l_D6_D9_c_i', 'i_l_D6_D9_n_r', 'i_l_D6_D9_n_i', 'i_l_D9_D10_a_r', 'i_l_D9_D10_a_i', 'i_l_D9_D10_b_r', 'i_l_D9_D10_b_i', 'i_l_D9_D10_c_r', 'i_l_D9_D10_c_i', 'i_l_D9_D10_n_r', 'i_l_D9_D10_n_i', 'i_l_D3_D11_a_r', 'i_l_D3_D11_a_i', 'i_l_D3_D11_b_r', 'i_l_D3_D11_b_i', 'i_l_D3_D11_c_r', 'i_l_D3_D11_c_i', 'i_l_D3_D11_n_r', 'i_l_D3_D11_n_i', 'i_l_D6_D16_a_r', 'i_l_D6_D16_a_i', 'i_l_D6_D16_b_r', 'i_l_D6_D16_b_i', 'i_l_D6_D16_c_r', 'i_l_D6_D16_c_i', 'i_l_D6_D16_n_r', 'i_l_D6_D16_n_i', 'i_l_D9_D17_a_r', 'i_l_D9_D17_a_i', 'i_l_D9_D17_b_r', 'i_l_D9_D17_b_i', 'i_l_D9_D17_c_r', 'i_l_D9_D17_c_i', 'i_l_D9_D17_n_r', 'i_l_D9_D17_n_i', 'i_l_D10_D18_a_r', 'i_l_D10_D18_a_i', 'i_l_D10_D18_b_r', 'i_l_D10_D18_b_i', 'i_l_D10_D18_c_r', 'i_l_D10_D18_c_i', 'i_l_D10_D18_n_r', 'i_l_D10_D18_n_i', 'i_l_D4_D14_a_r', 'i_l_D4_D14_a_i', 'i_l_D4_D14_b_r', 'i_l_D4_D14_b_i', 'i_l_D4_D14_c_r', 'i_l_D4_D14_c_i', 'i_l_D4_D14_n_r', 'i_l_D4_D14_n_i', 'i_l_D14_D15_a_r', 'i_l_D14_D15_a_i', 'i_l_D14_D15_b_r', 'i_l_D14_D15_b_i', 'i_l_D14_D15_c_r', 'i_l_D14_D15_c_i', 'i_l_D14_D15_n_r', 'i_l_D14_D15_n_i', 'i_load_R1_a_r', 'i_load_R1_a_i', 'i_load_R1_b_r', 'i_load_R1_b_i', 'i_load_R1_c_r', 'i_load_R1_c_i', 'i_load_R1_n_r', 'i_load_R1_n_i', 'i_load_R11_a_r', 'i_load_R11_a_i', 'i_load_R11_b_r', 'i_load_R11_b_i', 'i_load_R11_c_r', 'i_load_R11_c_i', 'i_load_R11_n_r', 'i_load_R11_n_i', 'i_load_R15_a_r', 'i_load_R15_a_i', 'i_load_R15_b_r', 'i_load_R15_b_i', 'i_load_R15_c_r', 'i_load_R15_c_i', 'i_load_R15_n_r', 'i_load_R15_n_i', 'i_load_R16_a_r', 'i_load_R16_a_i', 'i_load_R16_b_r', 'i_load_R16_b_i', 'i_load_R16_c_r', 'i_load_R16_c_i', 'i_load_R16_n_r', 'i_load_R16_n_i', 'i_load_R17_a_r', 'i_load_R17_a_i', 'i_load_R17_b_r', 'i_load_R17_b_i', 'i_load_R17_c_r', 'i_load_R17_c_i', 'i_load_R17_n_r', 'i_load_R17_n_i', 'i_load_R18_a_r', 'i_load_R18_a_i', 'i_load_R18_b_r', 'i_load_R18_b_i', 'i_load_R18_c_r', 'i_load_R18_c_i', 'i_load_R18_n_r', 'i_load_R18_n_i', 'i_load_D15_a_r', 'i_load_D15_a_i', 'i_load_D15_n_r', 'i_load_D15_n_i', 'i_load_D11_a_r', 'i_load_D11_a_i', 'i_load_D11_n_r', 'i_load_D11_n_i', 'i_load_D16_a_r', 'i_load_D16_a_i', 'i_load_D16_n_r', 'i_load_D16_n_i', 'i_load_D17_a_r', 'i_load_D17_a_i', 'i_load_D17_n_r', 'i_load_D17_n_i', 'i_load_D18_a_r', 'i_load_D18_a_i', 'i_load_D18_n_r', 'i_load_D18_n_i', 'i_vsc_R1_a_r', 'i_vsc_R1_a_i', 'i_vsc_R1_b_r', 'i_vsc_R1_b_i', 'i_vsc_R1_c_r', 'i_vsc_R1_c_i', 'p_R1', 'p_D1', 'p_loss_R1', 'i_vsc_R10_a_r', 'i_vsc_R10_a_i', 'i_vsc_R10_b_r', 'i_vsc_R10_b_i', 'i_vsc_R10_c_r', 'i_vsc_R10_c_i', 'i_vsc_D10_a_r', 'i_vsc_D10_n_r', 'p_D10', 'p_loss_R10', 'i_vsc_R14_a_r', 'i_vsc_R14_a_i', 'i_vsc_R14_b_r', 'i_vsc_R14_b_i', 'i_vsc_R14_c_r', 'i_vsc_R14_c_i', 'i_vsc_D14_a_r', 'i_vsc_D14_n_r', 'p_D14', 'p_loss_R14'] 
        self.xy_list = self.x_list + self.y_run_list 
        self.y_ini_list = ['v_R1_a_r', 'v_R1_a_i', 'v_R1_b_r', 'v_R1_b_i', 'v_R1_c_r', 'v_R1_c_i', 'v_R1_n_r', 'v_R1_n_i', 'v_R11_a_r', 'v_R11_a_i', 'v_R11_b_r', 'v_R11_b_i', 'v_R11_c_r', 'v_R11_c_i', 'v_R11_n_r', 'v_R11_n_i', 'v_R15_a_r', 'v_R15_a_i', 'v_R15_b_r', 'v_R15_b_i', 'v_R15_c_r', 'v_R15_c_i', 'v_R15_n_r', 'v_R15_n_i', 'v_R16_a_r', 'v_R16_a_i', 'v_R16_b_r', 'v_R16_b_i', 'v_R16_c_r', 'v_R16_c_i', 'v_R16_n_r', 'v_R16_n_i', 'v_R17_a_r', 'v_R17_a_i', 'v_R17_b_r', 'v_R17_b_i', 'v_R17_c_r', 'v_R17_c_i', 'v_R17_n_r', 'v_R17_n_i', 'v_R18_a_r', 'v_R18_a_i', 'v_R18_b_r', 'v_R18_b_i', 'v_R18_c_r', 'v_R18_c_i', 'v_R18_n_r', 'v_R18_n_i', 'v_D15_a_r', 'v_D15_a_i', 'v_D15_n_r', 'v_D15_n_i', 'v_D11_a_r', 'v_D11_a_i', 'v_D11_n_r', 'v_D11_n_i', 'v_D16_a_r', 'v_D16_a_i', 'v_D16_n_r', 'v_D16_n_i', 'v_D17_a_r', 'v_D17_a_i', 'v_D17_n_r', 'v_D17_n_i', 'v_D18_a_r', 'v_D18_a_i', 'v_D18_n_r', 'v_D18_n_i', 'v_R2_a_r', 'v_R2_a_i', 'v_R2_b_r', 'v_R2_b_i', 'v_R2_c_r', 'v_R2_c_i', 'v_R2_n_r', 'v_R2_n_i', 'v_R3_a_r', 'v_R3_a_i', 'v_R3_b_r', 'v_R3_b_i', 'v_R3_c_r', 'v_R3_c_i', 'v_R3_n_r', 'v_R3_n_i', 'v_R4_a_r', 'v_R4_a_i', 'v_R4_b_r', 'v_R4_b_i', 'v_R4_c_r', 'v_R4_c_i', 'v_R4_n_r', 'v_R4_n_i', 'v_R5_a_r', 'v_R5_a_i', 'v_R5_b_r', 'v_R5_b_i', 'v_R5_c_r', 'v_R5_c_i', 'v_R5_n_r', 'v_R5_n_i', 'v_R6_a_r', 'v_R6_a_i', 'v_R6_b_r', 'v_R6_b_i', 'v_R6_c_r', 'v_R6_c_i', 'v_R6_n_r', 'v_R6_n_i', 'v_R7_a_r', 'v_R7_a_i', 'v_R7_b_r', 'v_R7_b_i', 'v_R7_c_r', 'v_R7_c_i', 'v_R7_n_r', 'v_R7_n_i', 'v_R8_a_r', 'v_R8_a_i', 'v_R8_b_r', 'v_R8_b_i', 'v_R8_c_r', 'v_R8_c_i', 'v_R8_n_r', 'v_R8_n_i', 'v_R9_a_r', 'v_R9_a_i', 'v_R9_b_r', 'v_R9_b_i', 'v_R9_c_r', 'v_R9_c_i', 'v_R9_n_r', 'v_R9_n_i', 'v_R10_a_r', 'v_R10_a_i', 'v_R10_b_r', 'v_R10_b_i', 'v_R10_c_r', 'v_R10_c_i', 'v_R10_n_r', 'v_R10_n_i', 'v_R12_a_r', 'v_R12_a_i', 'v_R12_b_r', 'v_R12_b_i', 'v_R12_c_r', 'v_R12_c_i', 'v_R12_n_r', 'v_R12_n_i', 'v_R13_a_r', 'v_R13_a_i', 'v_R13_b_r', 'v_R13_b_i', 'v_R13_c_r', 'v_R13_c_i', 'v_R13_n_r', 'v_R13_n_i', 'v_R14_a_r', 'v_R14_a_i', 'v_R14_b_r', 'v_R14_b_i', 'v_R14_c_r', 'v_R14_c_i', 'v_R14_n_r', 'v_R14_n_i', 'v_D1_n_r', 'v_D1_n_i', 'v_D3_a_r', 'v_D3_a_i', 'v_D3_b_r', 'v_D3_b_i', 'v_D3_c_r', 'v_D3_c_i', 'v_D3_n_r', 'v_D3_n_i', 'v_D4_a_r', 'v_D4_a_i', 'v_D4_b_r', 'v_D4_b_i', 'v_D4_c_r', 'v_D4_c_i', 'v_D4_n_r', 'v_D4_n_i', 'v_D6_a_r', 'v_D6_a_i', 'v_D6_b_r', 'v_D6_b_i', 'v_D6_c_r', 'v_D6_c_i', 'v_D6_n_r', 'v_D6_n_i', 'v_D9_a_r', 'v_D9_a_i', 'v_D9_b_r', 'v_D9_b_i', 'v_D9_c_r', 'v_D9_c_i', 'v_D9_n_r', 'v_D9_n_i', 'v_D10_a_r', 'v_D10_a_i', 'v_D10_b_r', 'v_D10_b_i', 'v_D10_c_r', 'v_D10_c_i', 'v_D10_n_r', 'v_D10_n_i', 'v_D11_b_r', 'v_D11_b_i', 'v_D11_c_r', 'v_D11_c_i', 'v_D16_b_r', 'v_D16_b_i', 'v_D16_c_r', 'v_D16_c_i', 'v_D17_b_r', 'v_D17_b_i', 'v_D17_c_r', 'v_D17_c_i', 'v_D18_b_r', 'v_D18_b_i', 'v_D18_c_r', 'v_D18_c_i', 'v_D14_a_r', 'v_D14_a_i', 'v_D14_b_r', 'v_D14_b_i', 'v_D14_c_r', 'v_D14_c_i', 'v_D14_n_r', 'v_D14_n_i', 'v_D15_b_r', 'v_D15_b_i', 'v_D15_c_r', 'v_D15_c_i', 'i_t_R0_R1_a_r', 'i_t_R0_R1_a_i', 'i_t_R0_R1_b_r', 'i_t_R0_R1_b_i', 'i_t_R0_R1_c_r', 'i_t_R0_R1_c_i', 'i_l_R1_R2_a_r', 'i_l_R1_R2_a_i', 'i_l_R1_R2_b_r', 'i_l_R1_R2_b_i', 'i_l_R1_R2_c_r', 'i_l_R1_R2_c_i', 'i_l_R1_R2_n_r', 'i_l_R1_R2_n_i', 'i_l_D1_D3_a_r', 'i_l_D1_D3_a_i', 'i_l_D1_D3_b_r', 'i_l_D1_D3_b_i', 'i_l_D1_D3_c_r', 'i_l_D1_D3_c_i', 'i_l_D1_D3_n_r', 'i_l_D1_D3_n_i', 'i_l_D3_D4_a_r', 'i_l_D3_D4_a_i', 'i_l_D3_D4_b_r', 'i_l_D3_D4_b_i', 'i_l_D3_D4_c_r', 'i_l_D3_D4_c_i', 'i_l_D3_D4_n_r', 'i_l_D3_D4_n_i', 'i_l_D4_D6_a_r', 'i_l_D4_D6_a_i', 'i_l_D4_D6_b_r', 'i_l_D4_D6_b_i', 'i_l_D4_D6_c_r', 'i_l_D4_D6_c_i', 'i_l_D4_D6_n_r', 'i_l_D4_D6_n_i', 'i_l_D6_D9_a_r', 'i_l_D6_D9_a_i', 'i_l_D6_D9_b_r', 'i_l_D6_D9_b_i', 'i_l_D6_D9_c_r', 'i_l_D6_D9_c_i', 'i_l_D6_D9_n_r', 'i_l_D6_D9_n_i', 'i_l_D9_D10_a_r', 'i_l_D9_D10_a_i', 'i_l_D9_D10_b_r', 'i_l_D9_D10_b_i', 'i_l_D9_D10_c_r', 'i_l_D9_D10_c_i', 'i_l_D9_D10_n_r', 'i_l_D9_D10_n_i', 'i_l_D3_D11_a_r', 'i_l_D3_D11_a_i', 'i_l_D3_D11_b_r', 'i_l_D3_D11_b_i', 'i_l_D3_D11_c_r', 'i_l_D3_D11_c_i', 'i_l_D3_D11_n_r', 'i_l_D3_D11_n_i', 'i_l_D6_D16_a_r', 'i_l_D6_D16_a_i', 'i_l_D6_D16_b_r', 'i_l_D6_D16_b_i', 'i_l_D6_D16_c_r', 'i_l_D6_D16_c_i', 'i_l_D6_D16_n_r', 'i_l_D6_D16_n_i', 'i_l_D9_D17_a_r', 'i_l_D9_D17_a_i', 'i_l_D9_D17_b_r', 'i_l_D9_D17_b_i', 'i_l_D9_D17_c_r', 'i_l_D9_D17_c_i', 'i_l_D9_D17_n_r', 'i_l_D9_D17_n_i', 'i_l_D10_D18_a_r', 'i_l_D10_D18_a_i', 'i_l_D10_D18_b_r', 'i_l_D10_D18_b_i', 'i_l_D10_D18_c_r', 'i_l_D10_D18_c_i', 'i_l_D10_D18_n_r', 'i_l_D10_D18_n_i', 'i_l_D4_D14_a_r', 'i_l_D4_D14_a_i', 'i_l_D4_D14_b_r', 'i_l_D4_D14_b_i', 'i_l_D4_D14_c_r', 'i_l_D4_D14_c_i', 'i_l_D4_D14_n_r', 'i_l_D4_D14_n_i', 'i_l_D14_D15_a_r', 'i_l_D14_D15_a_i', 'i_l_D14_D15_b_r', 'i_l_D14_D15_b_i', 'i_l_D14_D15_c_r', 'i_l_D14_D15_c_i', 'i_l_D14_D15_n_r', 'i_l_D14_D15_n_i', 'i_load_R1_a_r', 'i_load_R1_a_i', 'i_load_R1_b_r', 'i_load_R1_b_i', 'i_load_R1_c_r', 'i_load_R1_c_i', 'i_load_R1_n_r', 'i_load_R1_n_i', 'i_load_R11_a_r', 'i_load_R11_a_i', 'i_load_R11_b_r', 'i_load_R11_b_i', 'i_load_R11_c_r', 'i_load_R11_c_i', 'i_load_R11_n_r', 'i_load_R11_n_i', 'i_load_R15_a_r', 'i_load_R15_a_i', 'i_load_R15_b_r', 'i_load_R15_b_i', 'i_load_R15_c_r', 'i_load_R15_c_i', 'i_load_R15_n_r', 'i_load_R15_n_i', 'i_load_R16_a_r', 'i_load_R16_a_i', 'i_load_R16_b_r', 'i_load_R16_b_i', 'i_load_R16_c_r', 'i_load_R16_c_i', 'i_load_R16_n_r', 'i_load_R16_n_i', 'i_load_R17_a_r', 'i_load_R17_a_i', 'i_load_R17_b_r', 'i_load_R17_b_i', 'i_load_R17_c_r', 'i_load_R17_c_i', 'i_load_R17_n_r', 'i_load_R17_n_i', 'i_load_R18_a_r', 'i_load_R18_a_i', 'i_load_R18_b_r', 'i_load_R18_b_i', 'i_load_R18_c_r', 'i_load_R18_c_i', 'i_load_R18_n_r', 'i_load_R18_n_i', 'i_load_D15_a_r', 'i_load_D15_a_i', 'i_load_D15_n_r', 'i_load_D15_n_i', 'i_load_D11_a_r', 'i_load_D11_a_i', 'i_load_D11_n_r', 'i_load_D11_n_i', 'i_load_D16_a_r', 'i_load_D16_a_i', 'i_load_D16_n_r', 'i_load_D16_n_i', 'i_load_D17_a_r', 'i_load_D17_a_i', 'i_load_D17_n_r', 'i_load_D17_n_i', 'i_load_D18_a_r', 'i_load_D18_a_i', 'i_load_D18_n_r', 'i_load_D18_n_i', 'i_vsc_R1_a_r', 'i_vsc_R1_a_i', 'i_vsc_R1_b_r', 'i_vsc_R1_b_i', 'i_vsc_R1_c_r', 'i_vsc_R1_c_i', 'p_R1', 'p_D1', 'p_loss_R1', 'i_vsc_R10_a_r', 'i_vsc_R10_a_i', 'i_vsc_R10_b_r', 'i_vsc_R10_b_i', 'i_vsc_R10_c_r', 'i_vsc_R10_c_i', 'i_vsc_D10_a_r', 'i_vsc_D10_n_r', 'p_D10', 'p_loss_R10', 'i_vsc_R14_a_r', 'i_vsc_R14_a_i', 'i_vsc_R14_b_r', 'i_vsc_R14_b_i', 'i_vsc_R14_c_r', 'i_vsc_R14_c_i', 'i_vsc_D14_a_r', 'i_vsc_D14_n_r', 'p_D14', 'p_loss_R14'] 
        self.xy_ini_list = self.x_list + self.y_ini_list 
        self.t = 0.0
        self.it = 0
        self.it_store = 0
        self.xy_prev = np.zeros((self.N_x+self.N_y,1))
        self.initialization_tol = 1e-6
        self.N_u = len(self.inputs_run_list) 
        self.sopt_root_method='hybr'
        self.sopt_root_jac=True
        self.u_ini_list = self.inputs_ini_list
        self.u_ini_values_list = self.inputs_ini_values_list
        self.u_run_list = self.inputs_run_list
        self.u_run_values_list = self.inputs_run_values_list
        self.N_u = len(self.u_run_list)
        self.u_ini = np.array(self.inputs_ini_values_list)
        self.p = np.array(self.params_values_list)
        self.xy_0 = np.zeros((self.N_x+self.N_y,))
        self.xy = np.zeros((self.N_x+self.N_y,))
        self.z = np.zeros((self.N_z,))
        
        self.jac_ini = np.zeros((self.N_x+self.N_y,self.N_x+self.N_y))
        self.jac_run = np.zeros((self.N_x+self.N_y,self.N_x+self.N_y))
        self.jac_trap = np.zeros((self.N_x+self.N_y,self.N_x+self.N_y))
        
        self.yini2urun = list(set(self.u_run_list).intersection(set(self.y_ini_list)))
        self.uini2yrun = list(set(self.y_run_list).intersection(set(self.u_ini_list)))
        self.Time = np.zeros(self.N_store)
        self.X = np.zeros((self.N_store,self.N_x))
        self.Y = np.zeros((self.N_store,self.N_y))
        self.Z = np.zeros((self.N_store,self.N_z))
        self.iters = np.zeros(self.N_store) 
        self.u_run = np.array(self.u_run_values_list)
        
        self.sp_jac_trap_ia, self.sp_jac_trap_ja, self.sp_jac_trap_nia, self.sp_jac_trap_nja = sp_jac_trap_vectors()
        data = np.array(self.sp_jac_trap_ia,dtype=np.float64)
        self.sp_jac_trap = sspa.csr_matrix((data, self.sp_jac_trap_ia, self.sp_jac_trap_ja), shape=(self.sp_jac_trap_nia,self.sp_jac_trap_nja))

        self.J_run_d = np.array(self.sp_jac_trap_ia)*0.0
        self.J_run_i = np.array(self.sp_jac_trap_ia)
        self.J_run_p = np.array(self.sp_jac_trap_ja)
        
        self.sp_jac_ini_ia, self.sp_jac_ini_ja, self.sp_jac_ini_nia, self.sp_jac_ini_nja = sp_jac_ini_vectors()
        data = np.array(self.sp_jac_ini_ia,dtype=np.float64)
        self.sp_jac_ini = sspa.csr_matrix((data, self.sp_jac_ini_ia, self.sp_jac_ini_ja), shape=(self.sp_jac_ini_nia,self.sp_jac_ini_nja))

        self.J_ini_d = np.array(self.sp_jac_ini_ia)*0.0
        self.J_ini_i = np.array(self.sp_jac_ini_ia)
        self.J_ini_p = np.array(self.sp_jac_ini_ja)
        

        
        self.max_it,self.itol,self.store = 50,1e-8,1 
        self.lmax_it,self.ltol,self.ldamp=50,1e-8,1.1
        self.mode = 0 

        self.lmax_it_ini,self.ltol_ini,self.ldamp_ini=50,1e-8,1.1

        self.fill_factor_ini,self.drop_tol_ini,self.drop_rule_ini = 10,0.001,'column'       
        self.fill_factor_run,self.drop_tol_run,self.drop_rule_run = 10,0.001,'column' 
        
        # numerical elements of jacobians computing:
        x = self.xy[:self.N_x]
        y = self.xy[:self.N_x]
        
        jac_ini_ss_eval_num(self.jac_ini,x,y,self.u_ini,self.p)
        jac_run_ss_eval_num(self.jac_run,x,y,self.u_run,self.p)
        jac_trap_eval_num(self.jac_trap,x,y,self.u_run,self.p,self.Dt)


        
        sp_jac_ini_eval_num(self.sp_jac_ini.data,x,y,self.u_ini,self.p,self.Dt)
        sp_jac_trap_eval_num(self.J_run_d,x,y,self.u_run,self.p,self.Dt)


        
    def update(self):

        self.Time = np.zeros(self.N_store)
        self.X = np.zeros((self.N_store,self.N_x))
        self.Y = np.zeros((self.N_store,self.N_y))
        self.Z = np.zeros((self.N_store,self.N_z))
        self.iters = np.zeros(self.N_store)
        
    def ss_ini(self):

        xy_ini,it = sstate(self.xy_0,self.u_ini,self.p,self.jac_ini,self.N_x,self.N_y)
        self.xy_ini = xy_ini
        self.N_iters = it
        
        return xy_ini
    
    # def ini(self,up_dict,xy_0={}):

    #     for item in up_dict:
    #         self.set_value(item,up_dict[item])
            
    #     self.xy_ini = self.ss_ini()
    #     self.ini2run()
    #     jac_run_ss_eval_xy(self.jac_run,self.x,self.y_run,self.u_run,self.p)
    #     jac_run_ss_eval_up(self.jac_run,self.x,self.y_run,self.u_run,self.p)
        
        
        
    
    def run(self,t_end,up_dict):
        for item in up_dict:
            self.set_value(item,up_dict[item])
            
        t = self.t
        p = self.p
        it = self.it
        it_store = self.it_store
        xy = self.xy
        u = self.u_run
        
        t,it,it_store,xy = daesolver(t,t_end,it,it_store,xy,u,p,
                                  self.Time,
                                  self.X,
                                  self.Y,
                                  self.Z,
                                  self.iters,
                                  self.Dt,
                                  self.N_x,
                                  self.N_y,
                                  self.N_z,
                                  self.decimation,
                                  max_it=50,itol=1e-8,store=1)
        
        self.t = t
        self.it = it
        self.it_store = it_store
        self.xy = xy
 
    def runsp(self,t_end,up_dict):
        for item in up_dict:
            self.set_value(item,up_dict[item])
            
        t = self.t
        p = self.p
        it = self.it
        it_store = self.it_store
        xy = self.xy
        u = self.u_run
        
        t,it,it_store,xy = daesolver_sp(t,t_end,it,it_store,xy,u,p,
                                  self.sp_jac_trap,
                                  self.Time,
                                  self.X,
                                  self.Y,
                                  self.Z,
                                  self.iters,
                                  self.Dt,
                                  self.N_x,
                                  self.N_y,
                                  self.N_z,
                                  self.decimation,
                                  max_it=50,itol=1e-8,store=1)
        
        self.t = t
        self.it = it
        self.it_store = it_store
        self.xy = xy
        
    def post(self):
        
        self.Time = self.Time[:self.it_store]
        self.X = self.X[:self.it_store]
        self.Y = self.Y[:self.it_store]
        self.Z = self.Z[:self.it_store]
        
    def ini2run(self):
        
        ## y_ini to y_run
        self.y_ini = self.xy_ini[self.N_x:]
        self.y_run = np.copy(self.y_ini)
        self.u_run = np.copy(self.u_ini)
        
        ## y_ini to u_run
        for item in self.yini2urun:
            self.u_run[self.u_run_list.index(item)] = self.y_ini[self.y_ini_list.index(item)]
                
        ## u_ini to y_run
        for item in self.uini2yrun:
            self.y_run[self.y_run_list.index(item)] = self.u_ini[self.u_ini_list.index(item)]
            
        
        self.x = self.xy_ini[:self.N_x]
        self.xy[:self.N_x] = self.x
        self.xy[self.N_x:] = self.y_run
        h_eval(self.z,self.x,self.y_run,self.u_ini,self.p)
        

        
    def get_value(self,name):
        
        if name in self.inputs_run_list:
            value = self.u_run[self.inputs_run_list.index(name)]
            return value
            
        if name in self.x_list:
            idx = self.x_list.index(name)
            value = self.x[idx]
            return value
            
        if name in self.y_run_list:
            idy = self.y_run_list.index(name)
            value = self.y_run[idy]
            return value
        
        if name in self.params_list:
            idp = self.params_list.index(name)
            value = self.p[idp]
            return value
            
        if name in self.outputs_list:
            idz = self.outputs_list.index(name)
            value = self.z[idz]
            return value

    def get_values(self,name):
        if name in self.x_list:
            values = self.X[:,self.x_list.index(name)]
        if name in self.y_run_list:
            values = self.Y[:,self.y_run_list.index(name)]
        if name in self.outputs_list:
            values = self.Z[:,self.outputs_list.index(name)]
                        
        return values

    def get_mvalue(self,names):
        '''

        Parameters
        ----------
        names : list
            list of variables names to return each value.

        Returns
        -------
        mvalue : TYPE
            list of value of each variable.

        '''
        mvalue = []
        for name in names:
            mvalue += [self.get_value(name)]
                        
        return mvalue
    
    def set_value(self,name_,value):
        if name_ in self.inputs_ini_list:
            self.u_ini[self.inputs_ini_list.index(name_)] = value
        if name_ in self.inputs_run_list:
            self.u_run[self.inputs_run_list.index(name_)] = value
            return
        elif name_ in self.params_list:
            self.p[self.params_list.index(name_)] = value
            return
        else:
            print(f'Input or parameter {name_} not found.')
 
    def report_x(self,value_format='5.2f'):
        for item in self.x_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')

    def report_y(self,value_format='5.2f'):
        for item in self.y_run_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')
            
    def report_u(self,value_format='5.2f'):
        for item in self.inputs_run_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')

    def report_z(self,value_format='5.2f'):
        for item in self.outputs_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')

    def report_params(self,value_format='5.2f'):
        for item in self.params_list:
            print(f'{item:5s} = {self.get_value(item):5.2f}')
            
    def ini(self,up_dict,xy_0={}):
        
        self.it = 0
        self.it_store = 0
        self.t = 0.0
    
        for item in up_dict:
            self.set_value(item,up_dict[item])
            
        if type(xy_0) == dict:
            xy_0_dict = xy_0
            self.dict2xy0(xy_0_dict)
            
        if type(xy_0) == str:
            if xy_0 == 'eval':
                N_x = self.N_x
                self.xy_0_new = np.copy(self.xy_0)*0
                xy0_eval(self.xy_0_new[:N_x],self.xy_0_new[N_x:],self.u_ini,self.p)
                self.xy_0_evaluated = np.copy(self.xy_0_new)
                self.xy_0 = np.copy(self.xy_0_new)
            else:
                self.load_xy_0(file_name = xy_0)
                
        self.xy_ini = self.ss_ini()
        self.ini2run()
        jac_run_ss_eval_xy(self.jac_run,self.x,self.y_run,self.u_run,self.p)
        jac_run_ss_eval_up(self.jac_run,self.x,self.y_run,self.u_run,self.p)
    
    def dict2xy0(self,xy_0_dict):
    
        for item in xy_0_dict:
            if item in self.x_list:
                self.xy_0[self.x_list.index(item)] = xy_0_dict[item]
            if item in self.y_ini_list:
                self.xy_0[self.y_ini_list.index(item) + self.N_x] = xy_0_dict[item]
        
    
    def save_xy_0(self,file_name = 'xy_0.json'):
        xy_0_dict = {}
        for item in self.x_list:
            xy_0_dict.update({item:self.get_value(item)})
        for item in self.y_ini_list:
            xy_0_dict.update({item:self.get_value(item)})
    
        xy_0_str = json.dumps(xy_0_dict, indent=4)
        with open(file_name,'w') as fobj:
            fobj.write(xy_0_str)
    
    def load_xy_0(self,file_name = 'xy_0.json'):
        with open(file_name) as fobj:
            xy_0_str = fobj.read()
        xy_0_dict = json.loads(xy_0_str)
    
        for item in xy_0_dict:
            if item in self.x_list:
                self.xy_0[self.x_list.index(item)] = xy_0_dict[item]
            if item in self.y_ini_list:
                self.xy_0[self.y_ini_list.index(item)+self.N_x] = xy_0_dict[item]            

    def load_params(self,data_input):

        if type(data_input) == str:
            json_file = data_input
            self.json_file = json_file
            self.json_data = open(json_file).read().replace("'",'"')
            data = json.loads(self.json_data)
        elif type(data_input) == dict:
            data = data_input

        self.data = data
        for item in self.data:
            self.struct[0][item] = self.data[item]
            if item in self.params_list:
                self.params_values_list[self.params_list.index(item)] = self.data[item]
            elif item in self.inputs_ini_list:
                self.inputs_ini_values_list[self.inputs_ini_list.index(item)] = self.data[item]
            elif item in self.inputs_run_list:
                self.inputs_run_values_list[self.inputs_run_list.index(item)] = self.data[item]
            else: 
                print(f'parameter or input {item} not found')

    def save_params(self,file_name = 'parameters.json'):
        params_dict = {}
        for item in self.params_list:
            params_dict.update({item:self.get_value(item)})

        params_dict_str = json.dumps(params_dict, indent=4)
        with open(file_name,'w') as fobj:
            fobj.write(params_dict_str)

    def save_inputs_ini(self,file_name = 'inputs_ini.json'):
        inputs_ini_dict = {}
        for item in self.inputs_ini_list:
            inputs_ini_dict.update({item:self.get_value(item)})

        inputs_ini_dict_str = json.dumps(inputs_ini_dict, indent=4)
        with open(file_name,'w') as fobj:
            fobj.write(inputs_ini_dict_str)

    def eval_preconditioner_ini(self):
        
        sp_jac_ini_eval_up(self.sp_jac_ini.data,
                        self.x,self.y_ini,self.u_ini,self.p,self.Dt)
        sp_jac_ini_eval_xy(self.sp_jac_ini.data,
                        self.x,self.y_ini,self.u_ini,self.p,self.Dt)
        
        P_slu = spilu(self.sp_jac_ini,
                      fill_factor=self.fill_factor_ini,
                      drop_tol=self.drop_tol_ini,
                      drop_rule = self.drop_rule_ini)
        
        self.P_slu = P_slu
        P_d,P_i,P_p,perm_r,perm_c = slu2pydae(P_slu)   
        self.P_d = P_d
        self.P_i = P_i
        self.P_p = P_p
    
        self.perm_r = perm_r
        self.perm_c = perm_c
        
        #print(f'Preconditioner Nnz = {P_slu.nnz}')
        
    def eval_preconditioner_run(self):
    
        sp_jac_trap_eval_up(self.J_run_d,self.x,self.y_ini,self.u_ini,self.p,self.Dt,xyup = 1)
        sp_jac_trap_eval_xy(self.J_run_d,self.x,self.y_ini,self.u_ini,self.p,self.Dt,xyup = 1)

        self.sp_jac_trap.data = self.J_run_d 
        P_slu_run = spilu(self.sp_jac_trap,
                          fill_factor=self.fill_factor_run,
                          drop_tol=self.drop_tol_run,
                          drop_rule = self.drop_rule_run)
    
        self.P_slu_run = P_slu_run
        P_d,P_i,P_p,perm_r,perm_c = slu2pydae(P_slu_run)   
        self.P_run_d = P_d
        self.P_run_i = P_i
        self.P_run_p = P_p
    
        self.perm_run_r = perm_r
        self.perm_run_c = perm_c   
        
    def sprun(self,t_end,up_dict):
        for item in up_dict:
            self.set_value(item,up_dict[item])
    
        t = self.t
        p = self.p
        it = self.it
        it_store = self.it_store
        xy = self.xy
        u = self.u_run
    
        t,it,it_store,xy = spdaesolver(t,t_end,it,it_store,xy,u,p,
                                  self.jac_trap,
                                  self.J_run_d,self.J_run_i,self.J_run_p,
                                  self.P_run_d,self.P_run_i,self.P_run_p,self.perm_run_r,self.perm_run_c,
                                  self.Time,
                                  self.X,
                                  self.Y,
                                  self.Z,
                                  self.iters,
                                  self.Dt,
                                  self.N_x,
                                  self.N_y,
                                  self.N_z,
                                  self.decimation,
                                  max_it=self.max_it,itol=self.max_it,store=self.store,
                                  lmax_it=self.lmax_it,ltol=self.ltol,ldamp=self.ldamp,mode=self.mode)
    
        self.t = t
        self.it = it
        self.it_store = it_store
        self.xy = xy
            
    def spini(self,up_dict,xy_0={}):
    
        self.it = 0
        self.it_store = 0
        self.t = 0.0
    
        for item in up_dict:
            self.set_value(item,up_dict[item])
    
        if type(xy_0) == dict:
            xy_0_dict = xy_0
            self.dict2xy0(xy_0_dict)
    
        if type(xy_0) == str:
            if xy_0 == 'eval':
                N_x = self.N_x
                self.xy_0_new = np.copy(self.xy_0)*0
                xy0_eval(self.xy_0_new[:N_x],self.xy_0_new[N_x:],self.u_ini,self.p)
                self.xy_0_evaluated = np.copy(self.xy_0_new)
                self.xy_0 = np.copy(self.xy_0_new)
            else:
                self.load_xy_0(file_name = xy_0)
    
        self.xy_ini = self.spss_ini()
        self.ini2run()
        jac_run_ss_eval_xy(self.jac_run,self.x,self.y_run,self.u_run,self.p)
        jac_run_ss_eval_up(self.jac_run,self.x,self.y_run,self.u_run,self.p)

        
    def spss_ini(self):
        J_d,J_i,J_p = csr2pydae(self.sp_jac_ini)
        
        xy_ini,it,iparams = spsstate(self.xy,self.u_ini,self.p,
                 J_d,J_i,J_p,
                 self.P_d,self.P_i,self.P_p,self.perm_r,self.perm_c,
                 self.N_x,self.N_y,
                 max_it=self.max_it,tol=self.itol,
                 lmax_it=self.lmax_it_ini,
                 ltol=self.ltol_ini,
                 ldamp=self.ldamp)
        
        self.xy_ini = xy_ini
        self.N_iters = it
        self.iparams = iparams
    
        return xy_ini



@numba.njit(cache=True)
def sstate(xy,u,p,jac_ini_ss,N_x,N_y,max_it=50,tol=1e-8):
    
    fg = np.zeros((N_x+N_y,1),dtype=np.float64)
    x = xy[:N_x]
    y = xy[N_x:]
    fg = np.zeros((N_x+N_y,),dtype=np.float64)
    f = fg[:N_x]
    g = fg[N_x:]
    
    jac_ini_ss_eval_up(jac_ini_ss,x,y,u,p)


    for it in range(max_it):
        jac_ini_ss_eval_xy(jac_ini_ss,x,y,u,p)
        f_ini_eval(f,x,y,u,p)
        g_ini_eval(g,x,y,u,p)
        fg[:N_x] = f
        fg[N_x:] = g
        xy += np.linalg.solve(jac_ini_ss,-fg)
        if np.max(np.abs(fg))<tol: break

    return xy,it

            
            
@numba.njit(cache=True) 
def daesolver(t,t_end,it,it_store,xy,u,p,T,X,Y,Z,iters,Dt,N_x,N_y,N_z,decimation,max_it=50,itol=1e-8,store=1): 

    jac_trap = np.zeros((N_x+N_y,N_x+N_y),dtype=np.float64)
    fg = np.zeros((N_x+N_y,1),dtype=np.float64)
    fg_i = np.zeros((N_x+N_y),dtype=np.float64)
    x = xy[:N_x]
    y = xy[N_x:]
    fg = np.zeros((N_x+N_y,),dtype=np.float64)
    f = fg[:N_x]
    g = fg[N_x:]
    h = np.zeros((N_z),dtype=np.float64)
    jac_trap_eval(jac_trap,x,y,u,p,Dt,xyup=1) 
    
    if it == 0:
        f_run_eval(f,x,y,u,p)
        h_eval(h,x,y,u,p)
        it_store = 0  
        T[0] = t 
        X[0,:] = x  
        Y[0,:] = y  
        Z[0,:] = h  

    while t<t_end: 
        it += 1
        t += Dt

        f_run_eval(f,x,y,u,p)
        g_run_eval(g,x,y,u,p)

        x_0 = np.copy(x) 
        y_0 = np.copy(y) 
        f_0 = np.copy(f) 
        g_0 = np.copy(g) 
            
        for iti in range(max_it):
            f_run_eval(f,x,y,u,p)
            g_run_eval(g,x,y,u,p)
            jac_trap_eval_xy(jac_trap,x,y,u,p,Dt,xyup=0)             

            f_n_i = x - x_0 - 0.5*Dt*(f+f_0) 

            fg_i[:N_x] = f_n_i
            fg_i[N_x:] = g
            
            Dxy_i = np.linalg.solve(-jac_trap,fg_i) 

            x = x + Dxy_i[:N_x]
            y = y + Dxy_i[N_x:]              

            # iteration stop
            max_relative = 0.0
            for it_var in range(N_x+N_y):
                abs_value = np.abs(xy[it_var])
                if abs_value < 0.001:
                    abs_value = 0.001
                relative_error = np.abs(Dxy_i[it_var])/abs_value

                if relative_error > max_relative: max_relative = relative_error

            if max_relative<itol:
                break
                
        h_eval(h,x,y,u,p)
        xy[:N_x] = x
        xy[N_x:] = y
        
        # store in channels 
        if store == 1:
            if it >= it_store*decimation: 
                T[it_store+1] = t 
                X[it_store+1,:] = x 
                Y[it_store+1,:] = y
                Z[it_store+1,:] = h
                iters[it_store+1] = iti
                it_store += 1 

    return t,it,it_store,xy


def daesolver_sp(t,t_end,it,it_store,xy,u,p,sp_jac_trap,T,X,Y,Z,iters,Dt,N_x,N_y,N_z,decimation,max_it=50,itol=1e-8,store=1): 

    fg = np.zeros((N_x+N_y,1),dtype=np.float64)
    fg_i = np.zeros((N_x+N_y),dtype=np.float64)
    x = xy[:N_x]
    y = xy[N_x:]
    fg = np.zeros((N_x+N_y,),dtype=np.float64)
    f = fg[:N_x]
    g = fg[N_x:]
    h = np.zeros((N_z),dtype=np.float64)
    sp_jac_trap_eval_up(sp_jac_trap.data,x,y,u,p,Dt,xyup=1)
    
    if it == 0:
        f_run_eval(f,x,y,u,p)
        h_eval(h,x,y,u,p)
        it_store = 0  
        T[0] = t 
        X[0,:] = x  
        Y[0,:] = y  
        Z[0,:] = h  

    while t<t_end: 
        it += 1
        t += Dt

        f_run_eval(f,x,y,u,p)
        g_run_eval(g,x,y,u,p)

        x_0 = np.copy(x) 
        y_0 = np.copy(y) 
        f_0 = np.copy(f) 
        g_0 = np.copy(g) 
            
        for iti in range(max_it):
            f_run_eval(f,x,y,u,p)
            g_run_eval(g,x,y,u,p)
            sp_jac_trap_eval(sp_jac_trap.data,x,y,u,p,Dt,xyup=1)            

            f_n_i = x - x_0 - 0.5*Dt*(f+f_0) 

            fg_i[:N_x] = f_n_i
            fg_i[N_x:] = g
            
            Dxy_i = spsolve(sp_jac_trap,-fg_i) 

            x = x + Dxy_i[:N_x]
            y = y + Dxy_i[N_x:]              

            # iteration stop
            max_relative = 0.0
            for it_var in range(N_x+N_y):
                abs_value = np.abs(xy[it_var])
                if abs_value < 0.001:
                    abs_value = 0.001
                relative_error = np.abs(Dxy_i[it_var])/abs_value

                if relative_error > max_relative: max_relative = relative_error

            if max_relative<itol:
                break
                
        h_eval(h,x,y,u,p)
        xy[:N_x] = x
        xy[N_x:] = y
        
        # store in channels 
        if store == 1:
            if it >= it_store*decimation: 
                T[it_store+1] = t 
                X[it_store+1,:] = x 
                Y[it_store+1,:] = y
                Z[it_store+1,:] = h
                iters[it_store+1] = iti
                it_store += 1 

    return t,it,it_store,xy

@numba.njit(cache=True)
def spdaesolver(t,t_end,it,it_store,xy,u,p,jac_trap,
                J_d,J_i,J_p,
                P_d,P_i,P_p,perm_r,perm_c,
                T,X,Y,Z,iters,Dt,N_x,N_y,N_z,decimation,max_it=50,itol=1e-8,store=1,
                lmax_it=20,ltol=1e-4,ldamp=1.0,mode=0):


    fg = np.zeros((N_x+N_y,1),dtype=np.float64)
    fg_i = np.zeros((N_x+N_y),dtype=np.float64)
    x = xy[:N_x]
    y = xy[N_x:]
    fg = np.zeros((N_x+N_y,),dtype=np.float64)
    f = fg[:N_x]
    g = fg[N_x:]
    h = np.zeros((N_z),dtype=np.float64)
    jac_trap_eval_up(jac_trap,x,y,u,p,Dt,xyup=1) 
    jac_trap_eval_xy(jac_trap,x,y,u,p,Dt,xyup=1) 
    iparams = np.array([0],dtype=np.int64)    

    
    if it == 0:
        f_run_eval(f,x,y,u,p)
        h_eval(h,x,y,u,p)
        it_store = 0  
        T[0] = t 
        X[0,:] = x  
        Y[0,:] = y  
        Z[0,:] = h  

    while t<t_end: 
        it += 1
        t += Dt

        f_run_eval(f,x,y,u,p)
        g_run_eval(g,x,y,u,p)

        x_0 = np.copy(x) 
        y_0 = np.copy(y) 
        f_0 = np.copy(f) 
        g_0 = np.copy(g) 
            
        Dxy_i = xy*0.0
        for iti in range(max_it):
            f_run_eval(f,x,y,u,p)
            g_run_eval(g,x,y,u,p)
            
            if mode == 0:
                jac_trap_eval_xy(jac_trap,x,y,u,p,Dt,xyup=0)   
            if mode == 1:
                sp_jac_trap_eval_xy(J_d,x,y,u,p,Dt,xyup=0) 

            f_n_i = x - x_0 - 0.5*Dt*(f+f_0) 

            fg_i[:N_x] = f_n_i
            fg_i[N_x:] = g
            
            if mode == 0:
                Dxy_i = np.linalg.solve(-jac_trap,fg_i) 
            if mode == 1:
                Dxy_i = sprichardson(J_d,J_i,J_p,-fg_i,P_d,P_i,P_p,perm_r,perm_c,0*Dxy_i,iparams,damp=ldamp,max_it=lmax_it,tol=ltol)

            x = x + Dxy_i[:N_x]
            y = y + Dxy_i[N_x:]              

            # iteration stop
            max_relative = 0.0
            for it_var in range(N_x+N_y):
                abs_value = np.abs(xy[it_var])
                if abs_value < 0.001:
                    abs_value = 0.001
                relative_error = np.abs(Dxy_i[it_var])/abs_value

                if relative_error > max_relative: max_relative = relative_error

            if max_relative<itol:
                break
                
        h_eval(h,x,y,u,p)
        xy[:N_x] = x
        xy[N_x:] = y
        
        # store in channels 
        if store == 1:
            if it >= it_store*decimation: 
                T[it_store+1] = t 
                X[it_store+1,:] = x 
                Y[it_store+1,:] = y
                Z[it_store+1,:] = h
                iters[it_store+1] = iti
                it_store += 1 

    return t,it,it_store,xy

@numba.njit()
def sprichardson(A_d,A_i,A_p,b,P_d,P_i,P_p,perm_r,perm_c,x,iparams,damp=1.0,max_it=100,tol=1e-3):
    N_A = A_p.shape[0]-1
    f = np.zeros(N_A)
    for it in range(max_it):
        spMvmul(N_A,A_d,A_i,A_p,x,f) 
        f -= b                          # A@x-b
        x = x - damp*splu_solve(P_d,P_i,P_p,perm_r,perm_c,f)   
        if np.linalg.norm(f,2) < tol: break
    iparams[0] = it
    return x
    
    


    
@numba.njit()
def spsstate(xy,u,p,
             J_d,J_i,J_p,
             P_d,P_i,P_p,perm_r,perm_c,
             N_x,N_y,
             max_it=50,tol=1e-8,
             lmax_it=20,ltol=1e-8,ldamp=1.0):
    
   
    x = xy[:N_x]
    y = xy[N_x:]
    fg = np.zeros((N_x+N_y,),dtype=np.float64)
    f = fg[:N_x]
    g = fg[N_x:]
    iparams = np.array([0],dtype=np.int64)    
    sp_jac_ini_eval_up(J_d,x,y,u,p,0.0)

    Dxy = np.zeros(N_x + N_y)
    for it in range(max_it):
        
        x = xy[:N_x]
        y = xy[N_x:]   
       
        sp_jac_ini_eval_xy(J_d,x,y,u,p,0.0)

        f_ini_eval(f,x,y,u,p)
        g_ini_eval(g,x,y,u,p)
        
        fg[:N_x] = f
        fg[N_x:] = g
               
        Dxy = sprichardson(J_d,J_i,J_p,-fg,P_d,P_i,P_p,perm_r,perm_c,Dxy,iparams,damp=ldamp,max_it=lmax_it,tol=ltol)
   
        xy += Dxy
        #if np.max(np.abs(fg))<tol: break
        if np.linalg.norm(fg,np.inf)<tol: break

    return xy,it,iparams


@cuda.jit()
def ode_solve(x,u,p,f_run,u_idxs,z_i,z,sim):

    N_i,N_j,N_x,N_z,Dt = sim

    # index of thread on GPU:
    i = cuda.grid(1)

    if i < x.size:
        for j in range(N_j):
            f_run_eval(f_run[i,:],x[i,:],u[i,u_idxs[j],:],p[i,:])
            for k in range(N_x):
              x[i,k] +=  Dt*f_run[i,k]

            # outputs in time range
            #z[i,j] = u[i,idxs[j],0]
            z[i,j] = x[i,1]
        h_eval(z_i[i,:],x[i,:],u[i,u_idxs[j],:],p[i,:])
        
def csr2pydae(A_csr):
    '''
    From scipy CSR to the three vectors:
    
    - data
    - indices
    - indptr
    
    '''
    
    A_d = A_csr.data
    A_i = A_csr.indices
    A_p = A_csr.indptr
    
    return A_d,A_i,A_p
    
def slu2pydae(P_slu):
    '''
    From SupderLU matrix to the three vectors:
    
    - data
    - indices
    - indptr
    
    and the premutation vectors:
    
    - perm_r
    - perm_c
    
    '''
    N = P_slu.shape[0]
    P_slu_full = P_slu.L.A - sspa.eye(N,format='csr') + P_slu.U.A
    perm_r = P_slu.perm_r
    perm_c = P_slu.perm_c
    P_csr = sspa.csr_matrix(P_slu_full)
    
    P_d = P_csr.data
    P_i = P_csr.indices
    P_p = P_csr.indptr
    
    return P_d,P_i,P_p,perm_r,perm_c

@numba.njit(cache=True)
def spMvmul(N,A_data,A_indices,A_indptr,x,y):
    '''
    y = A @ x
    
    with A in sparse CRS form
    '''
    #y = np.zeros(x.shape[0])
    for i in range(N):
        y[i] = 0.0
        for j in range(A_indptr[i],A_indptr[i + 1]):
            y[i] = y[i] + A_data[j]*x[A_indices[j]]
            
            
@numba.njit(cache=True)
def splu_solve(LU_d,LU_i,LU_p,perm_r,perm_c,b):
    N = len(b)
    y = np.zeros(N)
    x = np.zeros(N)
    z = np.zeros(N)
    bp = np.zeros(N)
    
    for i in range(N): 
        bp[perm_r[i]] = b[i]
        
    for i in range(N): 
        y[i] = bp[i]
        for j in range(LU_p[i],LU_p[i+1]):
            if LU_i[j]>i-1: break
            y[i] -= LU_d[j] * y[LU_i[j]]

    for i in range(N-1,-1,-1): #(int i = N - 1; i >= 0; i--) 
        z[i] = y[i]
        den = 0.0
        for j in range(LU_p[i],LU_p[i+1]): #(int k = i + 1; k < N; k++)
            if LU_i[j] > i:
                z[i] -= LU_d[j] * z[LU_i[j]]
            if LU_i[j] == i: den = LU_d[j]
        z[i] = z[i]/den
 
    for i in range(N):
        x[i] = z[perm_c[i]]
        
    return x



@numba.njit(cache=True)
def f_ini_eval(f_ini,x,y,u,p,xyup = 0):


    f_ini[0] = u[238] - x[0]





@numba.njit(cache=True)
def f_run_eval(f_run,x,y,u,p,xyup = 0):


    f_run[0] = u[238] - x[0]





@numba.njit(cache=True)
def g_ini_eval(g_ini,x,y,u,p,xyup = 0):


    g_ini[0] = y[336] + y[404] + 0.849044513514155*u[1] + 0.212261128378539*u[0] - 0.849044513514155*u[5] - 0.212261128378539*u[4] - 127.595184532966*y[1] - 123.954122254357*y[0] + 10.2713736253513*y[3] + 39.6392229058202*y[2] + 23.284964480954*y[5] + 24.9575997948692*y[4] + 83.8007853900572*y[7] + 58.0215758469966*y[6] + 54.0657727682604*y[69] + 105.57176931318*y[68] - 10.2713736253513*y[71] - 39.6392229058202*y[70] - 23.284964480954*y[73] - 24.9575997948692*y[72] - 10.2713736253513*y[75] - 39.6392229058202*y[74]
    g_ini[1] = y[337] + y[405] + 0.212261128378539*u[1] - 0.849044513514155*u[0] - 0.212261128378539*u[5] + 0.849044513514155*u[4] - 123.954122254357*y[1] + 127.595184532966*y[0] + 39.6392229058202*y[3] - 10.2713736253513*y[2] + 24.9575997948692*y[5] - 23.284964480954*y[4] + 58.0215758469966*y[7] - 83.8007853900572*y[6] + 105.57176931318*y[69] - 54.0657727682604*y[68] - 39.6392229058202*y[71] + 10.2713736253513*y[70] - 24.9575997948692*y[73] + 23.284964480954*y[72] - 39.6392229058202*y[75] + 10.2713736253513*y[74]
    g_ini[2] = y[338] + y[406] - 0.849044513514155*u[1] - 0.212261128378539*u[0] + 0.849044513514155*u[3] + 0.212261128378539*u[2] + 10.2713736253513*y[1] + 39.6392229058202*y[0] - 127.595184532966*y[3] - 123.954122254357*y[2] + 10.2713736253513*y[5] + 39.6392229058201*y[4] + 96.8143762456598*y[7] + 43.3399527360457*y[6] - 10.2713736253513*y[69] - 39.6392229058202*y[68] + 54.0657727682604*y[71] + 105.57176931318*y[70] - 10.2713736253513*y[73] - 39.6392229058201*y[72] - 23.284964480954*y[75] - 24.9575997948692*y[74]
    g_ini[3] = y[339] + y[407] - 0.212261128378539*u[1] + 0.849044513514155*u[0] + 0.212261128378539*u[3] - 0.849044513514155*u[2] + 39.6392229058202*y[1] - 10.2713736253513*y[0] - 123.954122254357*y[3] + 127.595184532966*y[2] + 39.6392229058201*y[5] - 10.2713736253513*y[4] + 43.3399527360457*y[7] - 96.8143762456598*y[6] - 39.6392229058202*y[69] + 10.2713736253513*y[68] + 105.57176931318*y[71] - 54.0657727682604*y[70] - 39.6392229058201*y[73] + 10.2713736253513*y[72] - 24.9575997948692*y[75] + 23.284964480954*y[74]
    g_ini[4] = y[340] + y[408] - 0.849044513514155*u[3] - 0.212261128378539*u[2] + 0.849044513514155*u[5] + 0.212261128378539*u[4] + 23.284964480954*y[1] + 24.9575997948692*y[0] + 10.2713736253513*y[3] + 39.6392229058202*y[2] - 127.595184532966*y[5] - 123.954122254357*y[4] + 83.8007853900572*y[7] + 58.0215758469966*y[6] - 23.284964480954*y[69] - 24.9575997948692*y[68] - 10.2713736253513*y[71] - 39.6392229058202*y[70] + 54.0657727682604*y[73] + 105.57176931318*y[72] - 10.2713736253514*y[75] - 39.6392229058201*y[74]
    g_ini[5] = y[341] + y[409] - 0.212261128378539*u[3] + 0.849044513514155*u[2] + 0.212261128378539*u[5] - 0.849044513514155*u[4] + 24.9575997948692*y[1] - 23.284964480954*y[0] + 39.6392229058202*y[3] - 10.2713736253513*y[2] - 123.954122254357*y[5] + 127.595184532966*y[4] + 58.0215758469966*y[7] - 83.8007853900572*y[6] - 24.9575997948692*y[69] + 23.284964480954*y[68] - 39.6392229058202*y[71] + 10.2713736253513*y[70] + 105.57176931318*y[73] - 54.0657727682604*y[72] - 39.6392229058201*y[75] + 10.2713736253514*y[74]
    g_ini[6] = 83.8007853900572*y[1] + 58.0215758469966*y[0] + 96.8143762456598*y[3] + 43.3399527360457*y[2] + 83.8007853900572*y[5] + 58.0215758469966*y[4] - 274.654008062378*y[7] - 161.052161470043*y[6] - 10.2713736253513*y[69] - 39.6392229058202*y[68] - 23.284964480954*y[71] - 24.9575997948692*y[70] - 10.2713736253513*y[73] - 39.6392229058202*y[72] + 54.0657727682604*y[75] + 105.57176931318*y[74]
    g_ini[7] = 58.0215758469966*y[1] - 83.8007853900572*y[0] + 43.3399527360457*y[3] - 96.8143762456598*y[2] + 58.0215758469966*y[5] - 83.8007853900572*y[4] - 161.052161470043*y[7] + 274.654008062378*y[6] - 39.6392229058202*y[69] + 10.2713736253513*y[68] - 24.9575997948692*y[71] + 23.284964480954*y[70] - 39.6392229058202*y[73] + 10.2713736253513*y[72] + 105.57176931318*y[75] - 54.0657727682604*y[74]
    g_ini[8] = y[344] - 4.84676915585801*y[9] - 26.5300693004806*y[8] - 1.58482814504483*y[11] + 7.8946133751477*y[10] - 0.67991845328531*y[13] + 7.72144347466701*y[12] - 1.58482814504483*y[15] + 7.89461337514771*y[14] + 4.84676915585801*y[77] + 26.5300693004806*y[76] + 1.58482814504483*y[79] - 7.8946133751477*y[78] + 0.67991845328531*y[81] - 7.72144347466701*y[80] + 1.58482814504483*y[83] - 7.89461337514771*y[82]
    g_ini[9] = y[345] - 26.5300693004806*y[9] + 4.84676915585801*y[8] + 7.8946133751477*y[11] + 1.58482814504483*y[10] + 7.72144347466701*y[13] + 0.67991845328531*y[12] + 7.89461337514771*y[15] + 1.58482814504483*y[14] + 26.5300693004806*y[77] - 4.84676915585801*y[76] - 7.8946133751477*y[79] - 1.58482814504483*y[78] - 7.72144347466701*y[81] - 0.67991845328531*y[80] - 7.89461337514771*y[83] - 1.58482814504483*y[82]
    g_ini[10] = y[346] - 1.58482814504483*y[9] + 7.89461337514771*y[8] - 4.84676915585801*y[11] - 26.5300693004806*y[10] - 1.58482814504483*y[13] + 7.89461337514771*y[12] - 0.679918453285308*y[15] + 7.72144347466701*y[14] + 1.58482814504483*y[77] - 7.89461337514771*y[76] + 4.84676915585801*y[79] + 26.5300693004806*y[78] + 1.58482814504483*y[81] - 7.89461337514771*y[80] + 0.679918453285308*y[83] - 7.72144347466701*y[82]
    g_ini[11] = y[347] + 7.89461337514771*y[9] + 1.58482814504483*y[8] - 26.5300693004806*y[11] + 4.84676915585801*y[10] + 7.89461337514771*y[13] + 1.58482814504483*y[12] + 7.72144347466701*y[15] + 0.679918453285308*y[14] - 7.89461337514771*y[77] - 1.58482814504483*y[76] + 26.5300693004806*y[79] - 4.84676915585801*y[78] - 7.89461337514771*y[81] - 1.58482814504483*y[80] - 7.72144347466701*y[83] - 0.679918453285308*y[82]
    g_ini[12] = y[348] - 0.67991845328531*y[9] + 7.72144347466701*y[8] - 1.58482814504483*y[11] + 7.8946133751477*y[10] - 4.84676915585801*y[13] - 26.5300693004806*y[12] - 1.58482814504483*y[15] + 7.89461337514771*y[14] + 0.67991845328531*y[77] - 7.72144347466701*y[76] + 1.58482814504483*y[79] - 7.8946133751477*y[78] + 4.84676915585801*y[81] + 26.5300693004806*y[80] + 1.58482814504483*y[83] - 7.89461337514771*y[82]
    g_ini[13] = y[349] + 7.72144347466701*y[9] + 0.67991845328531*y[8] + 7.8946133751477*y[11] + 1.58482814504483*y[10] - 26.5300693004806*y[13] + 4.84676915585801*y[12] + 7.89461337514771*y[15] + 1.58482814504483*y[14] - 7.72144347466701*y[77] - 0.67991845328531*y[76] - 7.8946133751477*y[79] - 1.58482814504483*y[78] + 26.5300693004806*y[81] - 4.84676915585801*y[80] - 7.89461337514771*y[83] - 1.58482814504483*y[82]
    g_ini[14] = -1.58482814504483*y[9] + 7.89461337514771*y[8] - 0.679918453285308*y[11] + 7.72144347466701*y[10] - 1.58482814504483*y[13] + 7.89461337514771*y[12] - 4.84676915585801*y[15] - 26.5550693004806*y[14] + 1.58482814504483*y[77] - 7.89461337514771*y[76] + 0.679918453285308*y[79] - 7.72144347466701*y[78] + 1.58482814504483*y[81] - 7.89461337514771*y[80] + 4.84676915585801*y[83] + 26.5300693004806*y[82]
    g_ini[15] = 7.89461337514771*y[9] + 1.58482814504483*y[8] + 7.72144347466701*y[11] + 0.679918453285308*y[10] + 7.89461337514771*y[13] + 1.58482814504483*y[12] - 26.5550693004806*y[15] + 4.84676915585801*y[14] - 7.89461337514771*y[77] - 1.58482814504483*y[76] - 7.72144347466701*y[79] - 0.679918453285308*y[78] - 7.89461337514771*y[81] - 1.58482814504483*y[80] + 26.5300693004806*y[83] - 4.84676915585801*y[82]
    g_ini[16] = y[352] + 4.84676915585801*y[157] + 26.5300693004806*y[156] + 1.58482814504483*y[159] - 7.8946133751477*y[158] + 0.67991845328531*y[161] - 7.72144347466701*y[160] + 1.58482814504483*y[163] - 7.89461337514771*y[162] - 4.84676915585801*y[17] - 26.5300693004806*y[16] - 1.58482814504483*y[19] + 7.8946133751477*y[18] - 0.67991845328531*y[21] + 7.72144347466701*y[20] - 1.58482814504483*y[23] + 7.89461337514771*y[22]
    g_ini[17] = y[353] + 26.5300693004806*y[157] - 4.84676915585801*y[156] - 7.8946133751477*y[159] - 1.58482814504483*y[158] - 7.72144347466701*y[161] - 0.67991845328531*y[160] - 7.89461337514771*y[163] - 1.58482814504483*y[162] - 26.5300693004806*y[17] + 4.84676915585801*y[16] + 7.8946133751477*y[19] + 1.58482814504483*y[18] + 7.72144347466701*y[21] + 0.67991845328531*y[20] + 7.89461337514771*y[23] + 1.58482814504483*y[22]
    g_ini[18] = y[354] + 1.58482814504483*y[157] - 7.89461337514771*y[156] + 4.84676915585801*y[159] + 26.5300693004806*y[158] + 1.58482814504483*y[161] - 7.89461337514771*y[160] + 0.679918453285308*y[163] - 7.72144347466701*y[162] - 1.58482814504483*y[17] + 7.89461337514771*y[16] - 4.84676915585801*y[19] - 26.5300693004806*y[18] - 1.58482814504483*y[21] + 7.89461337514771*y[20] - 0.679918453285308*y[23] + 7.72144347466701*y[22]
    g_ini[19] = y[355] - 7.89461337514771*y[157] - 1.58482814504483*y[156] + 26.5300693004806*y[159] - 4.84676915585801*y[158] - 7.89461337514771*y[161] - 1.58482814504483*y[160] - 7.72144347466701*y[163] - 0.679918453285308*y[162] + 7.89461337514771*y[17] + 1.58482814504483*y[16] - 26.5300693004806*y[19] + 4.84676915585801*y[18] + 7.89461337514771*y[21] + 1.58482814504483*y[20] + 7.72144347466701*y[23] + 0.679918453285308*y[22]
    g_ini[20] = y[356] + 0.67991845328531*y[157] - 7.72144347466701*y[156] + 1.58482814504483*y[159] - 7.8946133751477*y[158] + 4.84676915585801*y[161] + 26.5300693004806*y[160] + 1.58482814504483*y[163] - 7.89461337514771*y[162] - 0.67991845328531*y[17] + 7.72144347466701*y[16] - 1.58482814504483*y[19] + 7.8946133751477*y[18] - 4.84676915585801*y[21] - 26.5300693004806*y[20] - 1.58482814504483*y[23] + 7.89461337514771*y[22]
    g_ini[21] = y[357] - 7.72144347466701*y[157] - 0.67991845328531*y[156] - 7.8946133751477*y[159] - 1.58482814504483*y[158] + 26.5300693004806*y[161] - 4.84676915585801*y[160] - 7.89461337514771*y[163] - 1.58482814504483*y[162] + 7.72144347466701*y[17] + 0.67991845328531*y[16] + 7.8946133751477*y[19] + 1.58482814504483*y[18] - 26.5300693004806*y[21] + 4.84676915585801*y[20] + 7.89461337514771*y[23] + 1.58482814504483*y[22]
    g_ini[22] = 1.58482814504483*y[157] - 7.89461337514771*y[156] + 0.679918453285308*y[159] - 7.72144347466701*y[158] + 1.58482814504483*y[161] - 7.89461337514771*y[160] + 4.84676915585801*y[163] + 26.5300693004806*y[162] - 1.58482814504483*y[17] + 7.89461337514771*y[16] - 0.679918453285308*y[19] + 7.72144347466701*y[18] - 1.58482814504483*y[21] + 7.89461337514771*y[20] - 4.84676915585801*y[23] - 26.5550693004806*y[22]
    g_ini[23] = -7.89461337514771*y[157] - 1.58482814504483*y[156] - 7.72144347466701*y[159] - 0.679918453285308*y[158] - 7.89461337514771*y[161] - 1.58482814504483*y[160] + 26.5300693004806*y[163] - 4.84676915585801*y[162] + 7.89461337514771*y[17] + 1.58482814504483*y[16] + 7.72144347466701*y[19] + 0.679918453285308*y[18] + 7.89461337514771*y[21] + 1.58482814504483*y[20] - 26.5550693004806*y[23] + 4.84676915585801*y[22]
    g_ini[24] = y[360] - 5.65456401516768*y[25] - 30.9517475172273*y[24] - 1.84896616921897*y[27] + 9.21038227100566*y[26] - 0.793238195499529*y[29] + 9.00835072044485*y[28] - 1.84896616921897*y[31] + 9.21038227100566*y[30] + 5.65456401516768*y[101] + 30.9517475172273*y[100] + 1.84896616921897*y[103] - 9.21038227100566*y[102] + 0.793238195499529*y[105] - 9.00835072044485*y[104] + 1.84896616921897*y[107] - 9.21038227100566*y[106]
    g_ini[25] = y[361] - 30.9517475172273*y[25] + 5.65456401516768*y[24] + 9.21038227100566*y[27] + 1.84896616921897*y[26] + 9.00835072044485*y[29] + 0.793238195499529*y[28] + 9.21038227100566*y[31] + 1.84896616921897*y[30] + 30.9517475172273*y[101] - 5.65456401516768*y[100] - 9.21038227100566*y[103] - 1.84896616921897*y[102] - 9.00835072044485*y[105] - 0.793238195499529*y[104] - 9.21038227100566*y[107] - 1.84896616921897*y[106]
    g_ini[26] = y[362] - 1.84896616921897*y[25] + 9.21038227100566*y[24] - 5.65456401516768*y[27] - 30.9517475172273*y[26] - 1.84896616921897*y[29] + 9.21038227100566*y[28] - 0.793238195499528*y[31] + 9.00835072044485*y[30] + 1.84896616921897*y[101] - 9.21038227100566*y[100] + 5.65456401516768*y[103] + 30.9517475172273*y[102] + 1.84896616921897*y[105] - 9.21038227100566*y[104] + 0.793238195499528*y[107] - 9.00835072044485*y[106]
    g_ini[27] = y[363] + 9.21038227100566*y[25] + 1.84896616921897*y[24] - 30.9517475172273*y[27] + 5.65456401516768*y[26] + 9.21038227100566*y[29] + 1.84896616921897*y[28] + 9.00835072044485*y[31] + 0.793238195499528*y[30] - 9.21038227100566*y[101] - 1.84896616921897*y[100] + 30.9517475172273*y[103] - 5.65456401516768*y[102] - 9.21038227100566*y[105] - 1.84896616921897*y[104] - 9.00835072044485*y[107] - 0.793238195499528*y[106]
    g_ini[28] = y[364] - 0.793238195499527*y[25] + 9.00835072044484*y[24] - 1.84896616921897*y[27] + 9.21038227100566*y[26] - 5.65456401516768*y[29] - 30.9517475172273*y[28] - 1.84896616921897*y[31] + 9.21038227100566*y[30] + 0.793238195499527*y[101] - 9.00835072044484*y[100] + 1.84896616921897*y[103] - 9.21038227100566*y[102] + 5.65456401516768*y[105] + 30.9517475172273*y[104] + 1.84896616921897*y[107] - 9.21038227100566*y[106]
    g_ini[29] = y[365] + 9.00835072044484*y[25] + 0.793238195499527*y[24] + 9.21038227100566*y[27] + 1.84896616921897*y[26] - 30.9517475172273*y[29] + 5.65456401516768*y[28] + 9.21038227100566*y[31] + 1.84896616921897*y[30] - 9.00835072044484*y[101] - 0.793238195499527*y[100] - 9.21038227100566*y[103] - 1.84896616921897*y[102] + 30.9517475172273*y[105] - 5.65456401516768*y[104] - 9.21038227100566*y[107] - 1.84896616921897*y[106]
    g_ini[30] = -1.84896616921897*y[25] + 9.21038227100566*y[24] - 0.793238195499527*y[27] + 9.00835072044485*y[26] - 1.84896616921897*y[29] + 9.21038227100566*y[28] - 5.65456401516768*y[31] - 30.9767475172273*y[30] + 1.84896616921897*y[101] - 9.21038227100566*y[100] + 0.793238195499527*y[103] - 9.00835072044485*y[102] + 1.84896616921897*y[105] - 9.21038227100566*y[104] + 5.65456401516768*y[107] + 30.9517475172273*y[106]
    g_ini[31] = 9.21038227100566*y[25] + 1.84896616921897*y[24] + 9.00835072044485*y[27] + 0.793238195499527*y[26] + 9.21038227100566*y[29] + 1.84896616921897*y[28] - 30.9767475172273*y[31] + 5.65456401516768*y[30] - 9.21038227100566*y[101] - 1.84896616921897*y[100] - 9.00835072044485*y[103] - 0.793238195499527*y[102] - 9.21038227100566*y[105] - 1.84896616921897*y[104] + 30.9517475172273*y[107] - 5.65456401516768*y[106]
    g_ini[32] = y[368] - 5.65456401516768*y[33] - 30.9517475172273*y[32] - 1.84896616921897*y[35] + 9.21038227100566*y[34] - 0.793238195499529*y[37] + 9.00835072044485*y[36] - 1.84896616921897*y[39] + 9.21038227100566*y[38] + 5.65456401516768*y[125] + 30.9517475172273*y[124] + 1.84896616921897*y[127] - 9.21038227100566*y[126] + 0.793238195499529*y[129] - 9.00835072044485*y[128] + 1.84896616921897*y[131] - 9.21038227100566*y[130]
    g_ini[33] = y[369] - 30.9517475172273*y[33] + 5.65456401516768*y[32] + 9.21038227100566*y[35] + 1.84896616921897*y[34] + 9.00835072044485*y[37] + 0.793238195499529*y[36] + 9.21038227100566*y[39] + 1.84896616921897*y[38] + 30.9517475172273*y[125] - 5.65456401516768*y[124] - 9.21038227100566*y[127] - 1.84896616921897*y[126] - 9.00835072044485*y[129] - 0.793238195499529*y[128] - 9.21038227100566*y[131] - 1.84896616921897*y[130]
    g_ini[34] = y[370] - 1.84896616921897*y[33] + 9.21038227100566*y[32] - 5.65456401516768*y[35] - 30.9517475172273*y[34] - 1.84896616921897*y[37] + 9.21038227100566*y[36] - 0.793238195499528*y[39] + 9.00835072044485*y[38] + 1.84896616921897*y[125] - 9.21038227100566*y[124] + 5.65456401516768*y[127] + 30.9517475172273*y[126] + 1.84896616921897*y[129] - 9.21038227100566*y[128] + 0.793238195499528*y[131] - 9.00835072044485*y[130]
    g_ini[35] = y[371] + 9.21038227100566*y[33] + 1.84896616921897*y[32] - 30.9517475172273*y[35] + 5.65456401516768*y[34] + 9.21038227100566*y[37] + 1.84896616921897*y[36] + 9.00835072044485*y[39] + 0.793238195499528*y[38] - 9.21038227100566*y[125] - 1.84896616921897*y[124] + 30.9517475172273*y[127] - 5.65456401516768*y[126] - 9.21038227100566*y[129] - 1.84896616921897*y[128] - 9.00835072044485*y[131] - 0.793238195499528*y[130]
    g_ini[36] = y[372] - 0.793238195499527*y[33] + 9.00835072044484*y[32] - 1.84896616921897*y[35] + 9.21038227100566*y[34] - 5.65456401516768*y[37] - 30.9517475172273*y[36] - 1.84896616921897*y[39] + 9.21038227100566*y[38] + 0.793238195499527*y[125] - 9.00835072044484*y[124] + 1.84896616921897*y[127] - 9.21038227100566*y[126] + 5.65456401516768*y[129] + 30.9517475172273*y[128] + 1.84896616921897*y[131] - 9.21038227100566*y[130]
    g_ini[37] = y[373] + 9.00835072044484*y[33] + 0.793238195499527*y[32] + 9.21038227100566*y[35] + 1.84896616921897*y[34] - 30.9517475172273*y[37] + 5.65456401516768*y[36] + 9.21038227100566*y[39] + 1.84896616921897*y[38] - 9.00835072044484*y[125] - 0.793238195499527*y[124] - 9.21038227100566*y[127] - 1.84896616921897*y[126] + 30.9517475172273*y[129] - 5.65456401516768*y[128] - 9.21038227100566*y[131] - 1.84896616921897*y[130]
    g_ini[38] = -1.84896616921897*y[33] + 9.21038227100566*y[32] - 0.793238195499527*y[35] + 9.00835072044485*y[34] - 1.84896616921897*y[37] + 9.21038227100566*y[36] - 5.65456401516768*y[39] - 30.9767475172273*y[38] + 1.84896616921897*y[125] - 9.21038227100566*y[124] + 0.793238195499527*y[127] - 9.00835072044485*y[126] + 1.84896616921897*y[129] - 9.21038227100566*y[128] + 5.65456401516768*y[131] + 30.9517475172273*y[130]
    g_ini[39] = 9.21038227100566*y[33] + 1.84896616921897*y[32] + 9.00835072044485*y[35] + 0.793238195499527*y[34] + 9.21038227100566*y[37] + 1.84896616921897*y[36] - 30.9767475172273*y[39] + 5.65456401516768*y[38] - 9.21038227100566*y[125] - 1.84896616921897*y[124] - 9.00835072044485*y[127] - 0.793238195499527*y[126] - 9.21038227100566*y[129] - 1.84896616921897*y[128] + 30.9517475172273*y[131] - 5.65456401516768*y[130]
    g_ini[40] = y[376] + 5.65456401516768*y[133] + 30.9517475172273*y[132] + 1.84896616921897*y[135] - 9.21038227100566*y[134] + 0.793238195499529*y[137] - 9.00835072044485*y[136] + 1.84896616921897*y[139] - 9.21038227100566*y[138] - 5.65456401516768*y[41] - 30.9517475172273*y[40] - 1.84896616921897*y[43] + 9.21038227100566*y[42] - 0.793238195499529*y[45] + 9.00835072044485*y[44] - 1.84896616921897*y[47] + 9.21038227100566*y[46]
    g_ini[41] = y[377] + 30.9517475172273*y[133] - 5.65456401516768*y[132] - 9.21038227100566*y[135] - 1.84896616921897*y[134] - 9.00835072044485*y[137] - 0.793238195499529*y[136] - 9.21038227100566*y[139] - 1.84896616921897*y[138] - 30.9517475172273*y[41] + 5.65456401516768*y[40] + 9.21038227100566*y[43] + 1.84896616921897*y[42] + 9.00835072044485*y[45] + 0.793238195499529*y[44] + 9.21038227100566*y[47] + 1.84896616921897*y[46]
    g_ini[42] = y[378] + 1.84896616921897*y[133] - 9.21038227100566*y[132] + 5.65456401516768*y[135] + 30.9517475172273*y[134] + 1.84896616921897*y[137] - 9.21038227100566*y[136] + 0.793238195499528*y[139] - 9.00835072044485*y[138] - 1.84896616921897*y[41] + 9.21038227100566*y[40] - 5.65456401516768*y[43] - 30.9517475172273*y[42] - 1.84896616921897*y[45] + 9.21038227100566*y[44] - 0.793238195499528*y[47] + 9.00835072044485*y[46]
    g_ini[43] = y[379] - 9.21038227100566*y[133] - 1.84896616921897*y[132] + 30.9517475172273*y[135] - 5.65456401516768*y[134] - 9.21038227100566*y[137] - 1.84896616921897*y[136] - 9.00835072044485*y[139] - 0.793238195499528*y[138] + 9.21038227100566*y[41] + 1.84896616921897*y[40] - 30.9517475172273*y[43] + 5.65456401516768*y[42] + 9.21038227100566*y[45] + 1.84896616921897*y[44] + 9.00835072044485*y[47] + 0.793238195499528*y[46]
    g_ini[44] = y[380] + 0.793238195499527*y[133] - 9.00835072044484*y[132] + 1.84896616921897*y[135] - 9.21038227100566*y[134] + 5.65456401516768*y[137] + 30.9517475172273*y[136] + 1.84896616921897*y[139] - 9.21038227100566*y[138] - 0.793238195499527*y[41] + 9.00835072044484*y[40] - 1.84896616921897*y[43] + 9.21038227100566*y[42] - 5.65456401516768*y[45] - 30.9517475172273*y[44] - 1.84896616921897*y[47] + 9.21038227100566*y[46]
    g_ini[45] = y[381] - 9.00835072044484*y[133] - 0.793238195499527*y[132] - 9.21038227100566*y[135] - 1.84896616921897*y[134] + 30.9517475172273*y[137] - 5.65456401516768*y[136] - 9.21038227100566*y[139] - 1.84896616921897*y[138] + 9.00835072044484*y[41] + 0.793238195499527*y[40] + 9.21038227100566*y[43] + 1.84896616921897*y[42] - 30.9517475172273*y[45] + 5.65456401516768*y[44] + 9.21038227100566*y[47] + 1.84896616921897*y[46]
    g_ini[46] = 1.84896616921897*y[133] - 9.21038227100566*y[132] + 0.793238195499527*y[135] - 9.00835072044485*y[134] + 1.84896616921897*y[137] - 9.21038227100566*y[136] + 5.65456401516768*y[139] + 30.9517475172273*y[138] - 1.84896616921897*y[41] + 9.21038227100566*y[40] - 0.793238195499527*y[43] + 9.00835072044485*y[42] - 1.84896616921897*y[45] + 9.21038227100566*y[44] - 5.65456401516768*y[47] - 30.9767475172273*y[46]
    g_ini[47] = -9.21038227100566*y[133] - 1.84896616921897*y[132] - 9.00835072044485*y[135] - 0.793238195499527*y[134] - 9.21038227100566*y[137] - 1.84896616921897*y[136] + 30.9517475172273*y[139] - 5.65456401516768*y[138] + 9.21038227100566*y[41] + 1.84896616921897*y[40] + 9.00835072044485*y[43] + 0.793238195499527*y[42] + 9.21038227100566*y[45] + 1.84896616921897*y[44] - 30.9767475172273*y[47] + 5.65456401516768*y[46]
    g_ini[48] = y[384] + 135.4096140826*y[222] - 135.4096140826*y[48]
    g_ini[49] = y[385] + 135.4096140826*y[223] - 135.4096140826*y[49]
    g_ini[50] = y[386] + 135.4096140826*y[228] - 135.4096140826*y[50]
    g_ini[51] = y[387] + 135.4096140826*y[229] - 135.4096140826*y[51]
    g_ini[52] = y[388] - 157.977883096366*y[52] + 157.977883096366*y[166]
    g_ini[53] = y[389] - 157.977883096366*y[53] + 157.977883096366*y[167]
    g_ini[54] = y[390] - 157.977883096366*y[54] + 157.977883096366*y[172]
    g_ini[55] = y[391] - 157.977883096366*y[55] + 157.977883096366*y[173]
    g_ini[56] = y[392] - 157.977883096366*y[56] + 157.977883096366*y[182]
    g_ini[57] = y[393] - 157.977883096366*y[57] + 157.977883096366*y[183]
    g_ini[58] = y[394] - 157.977883096366*y[58] + 157.977883096366*y[188]
    g_ini[59] = y[395] - 157.977883096366*y[59] + 157.977883096366*y[189]
    g_ini[60] = y[396] - 157.977883096366*y[60] + 157.977883096366*y[190]
    g_ini[61] = y[397] - 157.977883096366*y[61] + 157.977883096366*y[191]
    g_ini[62] = y[398] - 157.977883096366*y[62] + 157.977883096366*y[196]
    g_ini[63] = y[399] - 157.977883096366*y[63] + 157.977883096366*y[197]
    g_ini[64] = y[400] + 157.977883096366*y[198] - 157.977883096366*y[64]
    g_ini[65] = y[401] + 157.977883096366*y[199] - 157.977883096366*y[65]
    g_ini[66] = y[402] + 157.977883096366*y[204] - 157.977883096366*y[66]
    g_ini[67] = y[403] + 157.977883096366*y[205] - 157.977883096366*y[67]
    g_ini[68] = 54.0657727682604*y[1] + 105.57176931318*y[0] - 10.2713736253513*y[3] - 39.6392229058202*y[2] - 23.284964480954*y[5] - 24.9575997948692*y[4] - 10.2713736253513*y[7] - 39.6392229058202*y[6] - 108.131545536521*y[69] - 211.14353862636*y[68] + 20.5427472507027*y[71] + 79.2784458116403*y[70] + 46.569928961908*y[73] + 49.9151995897384*y[72] + 20.5427472507027*y[75] + 79.2784458116403*y[74] + 54.0657727682604*y[77] + 105.57176931318*y[76] - 10.2713736253513*y[79] - 39.6392229058202*y[78] - 23.284964480954*y[81] - 24.9575997948692*y[80] - 10.2713736253513*y[83] - 39.6392229058202*y[82]
    g_ini[69] = 105.57176931318*y[1] - 54.0657727682604*y[0] - 39.6392229058202*y[3] + 10.2713736253513*y[2] - 24.9575997948692*y[5] + 23.284964480954*y[4] - 39.6392229058202*y[7] + 10.2713736253513*y[6] - 211.14353862636*y[69] + 108.131545536521*y[68] + 79.2784458116403*y[71] - 20.5427472507027*y[70] + 49.9151995897384*y[73] - 46.569928961908*y[72] + 79.2784458116403*y[75] - 20.5427472507027*y[74] + 105.57176931318*y[77] - 54.0657727682604*y[76] - 39.6392229058202*y[79] + 10.2713736253513*y[78] - 24.9575997948692*y[81] + 23.284964480954*y[80] - 39.6392229058202*y[83] + 10.2713736253513*y[82]
    g_ini[70] = -10.2713736253513*y[1] - 39.6392229058202*y[0] + 54.0657727682604*y[3] + 105.57176931318*y[2] - 10.2713736253513*y[5] - 39.6392229058201*y[4] - 23.284964480954*y[7] - 24.9575997948692*y[6] + 20.5427472507027*y[69] + 79.2784458116403*y[68] - 108.131545536521*y[71] - 211.14353862636*y[70] + 20.5427472507027*y[73] + 79.2784458116403*y[72] + 46.569928961908*y[75] + 49.9151995897384*y[74] - 10.2713736253513*y[77] - 39.6392229058202*y[76] + 54.0657727682604*y[79] + 105.57176931318*y[78] - 10.2713736253513*y[81] - 39.6392229058201*y[80] - 23.284964480954*y[83] - 24.9575997948692*y[82]
    g_ini[71] = -39.6392229058202*y[1] + 10.2713736253513*y[0] + 105.57176931318*y[3] - 54.0657727682604*y[2] - 39.6392229058201*y[5] + 10.2713736253513*y[4] - 24.9575997948692*y[7] + 23.284964480954*y[6] + 79.2784458116403*y[69] - 20.5427472507027*y[68] - 211.14353862636*y[71] + 108.131545536521*y[70] + 79.2784458116403*y[73] - 20.5427472507027*y[72] + 49.9151995897384*y[75] - 46.569928961908*y[74] - 39.6392229058202*y[77] + 10.2713736253513*y[76] + 105.57176931318*y[79] - 54.0657727682604*y[78] - 39.6392229058201*y[81] + 10.2713736253513*y[80] - 24.9575997948692*y[83] + 23.284964480954*y[82]
    g_ini[72] = -23.284964480954*y[1] - 24.9575997948692*y[0] - 10.2713736253513*y[3] - 39.6392229058202*y[2] + 54.0657727682604*y[5] + 105.57176931318*y[4] - 10.2713736253514*y[7] - 39.6392229058201*y[6] + 46.569928961908*y[69] + 49.9151995897384*y[68] + 20.5427472507027*y[71] + 79.2784458116404*y[70] - 108.131545536521*y[73] - 211.14353862636*y[72] + 20.5427472507027*y[75] + 79.2784458116403*y[74] - 23.284964480954*y[77] - 24.9575997948692*y[76] - 10.2713736253513*y[79] - 39.6392229058202*y[78] + 54.0657727682604*y[81] + 105.57176931318*y[80] - 10.2713736253514*y[83] - 39.6392229058201*y[82]
    g_ini[73] = -24.9575997948692*y[1] + 23.284964480954*y[0] - 39.6392229058202*y[3] + 10.2713736253513*y[2] + 105.57176931318*y[5] - 54.0657727682604*y[4] - 39.6392229058201*y[7] + 10.2713736253514*y[6] + 49.9151995897384*y[69] - 46.569928961908*y[68] + 79.2784458116404*y[71] - 20.5427472507027*y[70] - 211.14353862636*y[73] + 108.131545536521*y[72] + 79.2784458116403*y[75] - 20.5427472507027*y[74] - 24.9575997948692*y[77] + 23.284964480954*y[76] - 39.6392229058202*y[79] + 10.2713736253513*y[78] + 105.57176931318*y[81] - 54.0657727682604*y[80] - 39.6392229058201*y[83] + 10.2713736253514*y[82]
    g_ini[74] = -10.2713736253513*y[1] - 39.6392229058202*y[0] - 23.284964480954*y[3] - 24.9575997948692*y[2] - 10.2713736253513*y[5] - 39.6392229058202*y[4] + 54.0657727682604*y[7] + 105.57176931318*y[6] + 20.5427472507027*y[69] + 79.2784458116403*y[68] + 46.569928961908*y[71] + 49.9151995897384*y[70] + 20.5427472507027*y[73] + 79.2784458116403*y[72] - 108.131545536521*y[75] - 211.16853862636*y[74] - 10.2713736253513*y[77] - 39.6392229058202*y[76] - 23.284964480954*y[79] - 24.9575997948692*y[78] - 10.2713736253513*y[81] - 39.6392229058202*y[80] + 54.0657727682604*y[83] + 105.57176931318*y[82]
    g_ini[75] = -39.6392229058202*y[1] + 10.2713736253513*y[0] - 24.9575997948692*y[3] + 23.284964480954*y[2] - 39.6392229058202*y[5] + 10.2713736253513*y[4] + 105.57176931318*y[7] - 54.0657727682604*y[6] + 79.2784458116403*y[69] - 20.5427472507027*y[68] + 49.9151995897384*y[71] - 46.569928961908*y[70] + 79.2784458116403*y[73] - 20.5427472507027*y[72] - 211.16853862636*y[75] + 108.131545536521*y[74] - 39.6392229058202*y[77] + 10.2713736253513*y[76] - 24.9575997948692*y[79] + 23.284964480954*y[78] - 39.6392229058202*y[81] + 10.2713736253513*y[80] + 105.57176931318*y[83] - 54.0657727682604*y[82]
    g_ini[76] = 4.84676915585801*y[9] + 26.5300693004806*y[8] + 1.58482814504483*y[11] - 7.8946133751477*y[10] + 0.67991845328531*y[13] - 7.72144347466701*y[12] + 1.58482814504483*y[15] - 7.89461337514771*y[14] + 54.0657727682604*y[69] + 105.57176931318*y[68] - 10.2713736253513*y[71] - 39.6392229058202*y[70] - 23.284964480954*y[73] - 24.9575997948692*y[72] - 10.2713736253513*y[75] - 39.6392229058202*y[74] - 112.978314692379*y[77] - 237.673607926841*y[76] + 18.9579191056578*y[79] + 87.173059186788*y[78] + 45.8900105086227*y[81] + 57.6366430644055*y[80] + 18.9579191056579*y[83] + 87.173059186788*y[82] + 54.0657727682604*y[85] + 105.57176931318*y[84] - 10.2713736253513*y[87] - 39.6392229058202*y[86] - 23.284964480954*y[89] - 24.9575997948692*y[88] - 10.2713736253513*y[91] - 39.6392229058202*y[90]
    g_ini[77] = 26.5300693004806*y[9] - 4.84676915585801*y[8] - 7.8946133751477*y[11] - 1.58482814504483*y[10] - 7.72144347466701*y[13] - 0.67991845328531*y[12] - 7.89461337514771*y[15] - 1.58482814504483*y[14] + 105.57176931318*y[69] - 54.0657727682604*y[68] - 39.6392229058202*y[71] + 10.2713736253513*y[70] - 24.9575997948692*y[73] + 23.284964480954*y[72] - 39.6392229058202*y[75] + 10.2713736253513*y[74] - 237.673607926841*y[77] + 112.978314692379*y[76] + 87.173059186788*y[79] - 18.9579191056578*y[78] + 57.6366430644055*y[81] - 45.8900105086227*y[80] + 87.173059186788*y[83] - 18.9579191056579*y[82] + 105.57176931318*y[85] - 54.0657727682604*y[84] - 39.6392229058202*y[87] + 10.2713736253513*y[86] - 24.9575997948692*y[89] + 23.284964480954*y[88] - 39.6392229058202*y[91] + 10.2713736253513*y[90]
    g_ini[78] = 1.58482814504483*y[9] - 7.89461337514771*y[8] + 4.84676915585801*y[11] + 26.5300693004806*y[10] + 1.58482814504483*y[13] - 7.89461337514771*y[12] + 0.679918453285308*y[15] - 7.72144347466701*y[14] - 10.2713736253513*y[69] - 39.6392229058202*y[68] + 54.0657727682604*y[71] + 105.57176931318*y[70] - 10.2713736253513*y[73] - 39.6392229058201*y[72] - 23.284964480954*y[75] - 24.9575997948692*y[74] + 18.9579191056579*y[77] + 87.173059186788*y[76] - 112.978314692379*y[79] - 237.673607926841*y[78] + 18.9579191056579*y[81] + 87.173059186788*y[80] + 45.8900105086227*y[83] + 57.6366430644054*y[82] - 10.2713736253513*y[85] - 39.6392229058202*y[84] + 54.0657727682604*y[87] + 105.57176931318*y[86] - 10.2713736253513*y[89] - 39.6392229058201*y[88] - 23.284964480954*y[91] - 24.9575997948692*y[90]
    g_ini[79] = -7.89461337514771*y[9] - 1.58482814504483*y[8] + 26.5300693004806*y[11] - 4.84676915585801*y[10] - 7.89461337514771*y[13] - 1.58482814504483*y[12] - 7.72144347466701*y[15] - 0.679918453285308*y[14] - 39.6392229058202*y[69] + 10.2713736253513*y[68] + 105.57176931318*y[71] - 54.0657727682604*y[70] - 39.6392229058201*y[73] + 10.2713736253513*y[72] - 24.9575997948692*y[75] + 23.284964480954*y[74] + 87.173059186788*y[77] - 18.9579191056579*y[76] - 237.673607926841*y[79] + 112.978314692379*y[78] + 87.173059186788*y[81] - 18.9579191056579*y[80] + 57.6366430644054*y[83] - 45.8900105086227*y[82] - 39.6392229058202*y[85] + 10.2713736253513*y[84] + 105.57176931318*y[87] - 54.0657727682604*y[86] - 39.6392229058201*y[89] + 10.2713736253513*y[88] - 24.9575997948692*y[91] + 23.284964480954*y[90]
    g_ini[80] = 0.67991845328531*y[9] - 7.72144347466701*y[8] + 1.58482814504483*y[11] - 7.8946133751477*y[10] + 4.84676915585801*y[13] + 26.5300693004806*y[12] + 1.58482814504483*y[15] - 7.89461337514771*y[14] - 23.284964480954*y[69] - 24.9575997948692*y[68] - 10.2713736253513*y[71] - 39.6392229058202*y[70] + 54.0657727682604*y[73] + 105.57176931318*y[72] - 10.2713736253514*y[75] - 39.6392229058201*y[74] + 45.8900105086227*y[77] + 57.6366430644054*y[76] + 18.9579191056578*y[79] + 87.1730591867881*y[78] - 112.978314692379*y[81] - 237.673607926841*y[80] + 18.9579191056579*y[83] + 87.173059186788*y[82] - 23.284964480954*y[85] - 24.9575997948692*y[84] - 10.2713736253513*y[87] - 39.6392229058202*y[86] + 54.0657727682604*y[89] + 105.57176931318*y[88] - 10.2713736253514*y[91] - 39.6392229058201*y[90]
    g_ini[81] = -7.72144347466701*y[9] - 0.67991845328531*y[8] - 7.8946133751477*y[11] - 1.58482814504483*y[10] + 26.5300693004806*y[13] - 4.84676915585801*y[12] - 7.89461337514771*y[15] - 1.58482814504483*y[14] - 24.9575997948692*y[69] + 23.284964480954*y[68] - 39.6392229058202*y[71] + 10.2713736253513*y[70] + 105.57176931318*y[73] - 54.0657727682604*y[72] - 39.6392229058201*y[75] + 10.2713736253514*y[74] + 57.6366430644054*y[77] - 45.8900105086227*y[76] + 87.1730591867881*y[79] - 18.9579191056578*y[78] - 237.673607926841*y[81] + 112.978314692379*y[80] + 87.173059186788*y[83] - 18.9579191056579*y[82] - 24.9575997948692*y[85] + 23.284964480954*y[84] - 39.6392229058202*y[87] + 10.2713736253513*y[86] + 105.57176931318*y[89] - 54.0657727682604*y[88] - 39.6392229058201*y[91] + 10.2713736253514*y[90]
    g_ini[82] = 1.58482814504483*y[9] - 7.89461337514771*y[8] + 0.679918453285308*y[11] - 7.72144347466701*y[10] + 1.58482814504483*y[13] - 7.89461337514771*y[12] + 4.84676915585801*y[15] + 26.5300693004806*y[14] - 10.2713736253513*y[69] - 39.6392229058202*y[68] - 23.284964480954*y[71] - 24.9575997948692*y[70] - 10.2713736253513*y[73] - 39.6392229058202*y[72] + 54.0657727682604*y[75] + 105.57176931318*y[74] + 18.9579191056578*y[77] + 87.173059186788*y[76] + 45.8900105086227*y[79] + 57.6366430644054*y[78] + 18.9579191056579*y[81] + 87.173059186788*y[80] - 112.978314692379*y[83] - 237.673607926841*y[82] - 10.2713736253513*y[85] - 39.6392229058202*y[84] - 23.284964480954*y[87] - 24.9575997948692*y[86] - 10.2713736253513*y[89] - 39.6392229058202*y[88] + 54.0657727682604*y[91] + 105.57176931318*y[90]
    g_ini[83] = -7.89461337514771*y[9] - 1.58482814504483*y[8] - 7.72144347466701*y[11] - 0.679918453285308*y[10] - 7.89461337514771*y[13] - 1.58482814504483*y[12] + 26.5300693004806*y[15] - 4.84676915585801*y[14] - 39.6392229058202*y[69] + 10.2713736253513*y[68] - 24.9575997948692*y[71] + 23.284964480954*y[70] - 39.6392229058202*y[73] + 10.2713736253513*y[72] + 105.57176931318*y[75] - 54.0657727682604*y[74] + 87.173059186788*y[77] - 18.9579191056578*y[76] + 57.6366430644054*y[79] - 45.8900105086227*y[78] + 87.173059186788*y[81] - 18.9579191056579*y[80] - 237.673607926841*y[83] + 112.978314692379*y[82] - 39.6392229058202*y[85] + 10.2713736253513*y[84] - 24.9575997948692*y[87] + 23.284964480954*y[86] - 39.6392229058202*y[89] + 10.2713736253513*y[88] + 105.57176931318*y[91] - 54.0657727682604*y[90]
    g_ini[84] = 4.84676915585801*y[141] + 26.5300693004806*y[140] + 1.58482814504483*y[143] - 7.8946133751477*y[142] + 0.67991845328531*y[145] - 7.72144347466701*y[144] + 1.58482814504483*y[147] - 7.89461337514771*y[146] + 54.0657727682604*y[77] + 105.57176931318*y[76] - 10.2713736253513*y[79] - 39.6392229058202*y[78] - 23.284964480954*y[81] - 24.9575997948692*y[80] - 10.2713736253513*y[83] - 39.6392229058202*y[82] - 112.978314692379*y[85] - 237.673607926841*y[84] + 18.9579191056578*y[87] + 87.173059186788*y[86] + 45.8900105086227*y[89] + 57.6366430644055*y[88] + 18.9579191056579*y[91] + 87.173059186788*y[90] + 54.0657727682604*y[93] + 105.57176931318*y[92] - 10.2713736253513*y[95] - 39.6392229058202*y[94] - 23.284964480954*y[97] - 24.9575997948692*y[96] - 10.2713736253513*y[99] - 39.6392229058202*y[98]
    g_ini[85] = 26.5300693004806*y[141] - 4.84676915585801*y[140] - 7.8946133751477*y[143] - 1.58482814504483*y[142] - 7.72144347466701*y[145] - 0.67991845328531*y[144] - 7.89461337514771*y[147] - 1.58482814504483*y[146] + 105.57176931318*y[77] - 54.0657727682604*y[76] - 39.6392229058202*y[79] + 10.2713736253513*y[78] - 24.9575997948692*y[81] + 23.284964480954*y[80] - 39.6392229058202*y[83] + 10.2713736253513*y[82] - 237.673607926841*y[85] + 112.978314692379*y[84] + 87.173059186788*y[87] - 18.9579191056578*y[86] + 57.6366430644055*y[89] - 45.8900105086227*y[88] + 87.173059186788*y[91] - 18.9579191056579*y[90] + 105.57176931318*y[93] - 54.0657727682604*y[92] - 39.6392229058202*y[95] + 10.2713736253513*y[94] - 24.9575997948692*y[97] + 23.284964480954*y[96] - 39.6392229058202*y[99] + 10.2713736253513*y[98]
    g_ini[86] = 1.58482814504483*y[141] - 7.89461337514771*y[140] + 4.84676915585801*y[143] + 26.5300693004806*y[142] + 1.58482814504483*y[145] - 7.89461337514771*y[144] + 0.679918453285308*y[147] - 7.72144347466701*y[146] - 10.2713736253513*y[77] - 39.6392229058202*y[76] + 54.0657727682604*y[79] + 105.57176931318*y[78] - 10.2713736253513*y[81] - 39.6392229058201*y[80] - 23.284964480954*y[83] - 24.9575997948692*y[82] + 18.9579191056579*y[85] + 87.173059186788*y[84] - 112.978314692379*y[87] - 237.673607926841*y[86] + 18.9579191056579*y[89] + 87.173059186788*y[88] + 45.8900105086227*y[91] + 57.6366430644054*y[90] - 10.2713736253513*y[93] - 39.6392229058202*y[92] + 54.0657727682604*y[95] + 105.57176931318*y[94] - 10.2713736253513*y[97] - 39.6392229058201*y[96] - 23.284964480954*y[99] - 24.9575997948692*y[98]
    g_ini[87] = -7.89461337514771*y[141] - 1.58482814504483*y[140] + 26.5300693004806*y[143] - 4.84676915585801*y[142] - 7.89461337514771*y[145] - 1.58482814504483*y[144] - 7.72144347466701*y[147] - 0.679918453285308*y[146] - 39.6392229058202*y[77] + 10.2713736253513*y[76] + 105.57176931318*y[79] - 54.0657727682604*y[78] - 39.6392229058201*y[81] + 10.2713736253513*y[80] - 24.9575997948692*y[83] + 23.284964480954*y[82] + 87.173059186788*y[85] - 18.9579191056579*y[84] - 237.673607926841*y[87] + 112.978314692379*y[86] + 87.173059186788*y[89] - 18.9579191056579*y[88] + 57.6366430644054*y[91] - 45.8900105086227*y[90] - 39.6392229058202*y[93] + 10.2713736253513*y[92] + 105.57176931318*y[95] - 54.0657727682604*y[94] - 39.6392229058201*y[97] + 10.2713736253513*y[96] - 24.9575997948692*y[99] + 23.284964480954*y[98]
    g_ini[88] = 0.67991845328531*y[141] - 7.72144347466701*y[140] + 1.58482814504483*y[143] - 7.8946133751477*y[142] + 4.84676915585801*y[145] + 26.5300693004806*y[144] + 1.58482814504483*y[147] - 7.89461337514771*y[146] - 23.284964480954*y[77] - 24.9575997948692*y[76] - 10.2713736253513*y[79] - 39.6392229058202*y[78] + 54.0657727682604*y[81] + 105.57176931318*y[80] - 10.2713736253514*y[83] - 39.6392229058201*y[82] + 45.8900105086227*y[85] + 57.6366430644054*y[84] + 18.9579191056578*y[87] + 87.1730591867881*y[86] - 112.978314692379*y[89] - 237.673607926841*y[88] + 18.9579191056579*y[91] + 87.173059186788*y[90] - 23.284964480954*y[93] - 24.9575997948692*y[92] - 10.2713736253513*y[95] - 39.6392229058202*y[94] + 54.0657727682604*y[97] + 105.57176931318*y[96] - 10.2713736253514*y[99] - 39.6392229058201*y[98]
    g_ini[89] = -7.72144347466701*y[141] - 0.67991845328531*y[140] - 7.8946133751477*y[143] - 1.58482814504483*y[142] + 26.5300693004806*y[145] - 4.84676915585801*y[144] - 7.89461337514771*y[147] - 1.58482814504483*y[146] - 24.9575997948692*y[77] + 23.284964480954*y[76] - 39.6392229058202*y[79] + 10.2713736253513*y[78] + 105.57176931318*y[81] - 54.0657727682604*y[80] - 39.6392229058201*y[83] + 10.2713736253514*y[82] + 57.6366430644054*y[85] - 45.8900105086227*y[84] + 87.1730591867881*y[87] - 18.9579191056578*y[86] - 237.673607926841*y[89] + 112.978314692379*y[88] + 87.173059186788*y[91] - 18.9579191056579*y[90] - 24.9575997948692*y[93] + 23.284964480954*y[92] - 39.6392229058202*y[95] + 10.2713736253513*y[94] + 105.57176931318*y[97] - 54.0657727682604*y[96] - 39.6392229058201*y[99] + 10.2713736253514*y[98]
    g_ini[90] = 1.58482814504483*y[141] - 7.89461337514771*y[140] + 0.679918453285308*y[143] - 7.72144347466701*y[142] + 1.58482814504483*y[145] - 7.89461337514771*y[144] + 4.84676915585801*y[147] + 26.5300693004806*y[146] - 10.2713736253513*y[77] - 39.6392229058202*y[76] - 23.284964480954*y[79] - 24.9575997948692*y[78] - 10.2713736253513*y[81] - 39.6392229058202*y[80] + 54.0657727682604*y[83] + 105.57176931318*y[82] + 18.9579191056578*y[85] + 87.173059186788*y[84] + 45.8900105086227*y[87] + 57.6366430644054*y[86] + 18.9579191056579*y[89] + 87.173059186788*y[88] - 112.978314692379*y[91] - 237.698607926841*y[90] - 10.2713736253513*y[93] - 39.6392229058202*y[92] - 23.284964480954*y[95] - 24.9575997948692*y[94] - 10.2713736253513*y[97] - 39.6392229058202*y[96] + 54.0657727682604*y[99] + 105.57176931318*y[98]
    g_ini[91] = -7.89461337514771*y[141] - 1.58482814504483*y[140] - 7.72144347466701*y[143] - 0.679918453285308*y[142] - 7.89461337514771*y[145] - 1.58482814504483*y[144] + 26.5300693004806*y[147] - 4.84676915585801*y[146] - 39.6392229058202*y[77] + 10.2713736253513*y[76] - 24.9575997948692*y[79] + 23.284964480954*y[78] - 39.6392229058202*y[81] + 10.2713736253513*y[80] + 105.57176931318*y[83] - 54.0657727682604*y[82] + 87.173059186788*y[85] - 18.9579191056578*y[84] + 57.6366430644054*y[87] - 45.8900105086227*y[86] + 87.173059186788*y[89] - 18.9579191056579*y[88] - 237.698607926841*y[91] + 112.978314692379*y[90] - 39.6392229058202*y[93] + 10.2713736253513*y[92] - 24.9575997948692*y[95] + 23.284964480954*y[94] - 39.6392229058202*y[97] + 10.2713736253513*y[96] + 105.57176931318*y[99] - 54.0657727682604*y[98]
    g_ini[92] = 54.0657727682604*y[85] + 105.57176931318*y[84] - 10.2713736253513*y[87] - 39.6392229058202*y[86] - 23.284964480954*y[89] - 24.9575997948692*y[88] - 10.2713736253513*y[91] - 39.6392229058202*y[90] - 108.131545536521*y[93] - 211.14353862636*y[92] + 20.5427472507027*y[95] + 79.2784458116403*y[94] + 46.569928961908*y[97] + 49.9151995897384*y[96] + 20.5427472507027*y[99] + 79.2784458116403*y[98] + 54.0657727682604*y[101] + 105.57176931318*y[100] - 10.2713736253513*y[103] - 39.6392229058202*y[102] - 23.284964480954*y[105] - 24.9575997948692*y[104] - 10.2713736253513*y[107] - 39.6392229058202*y[106]
    g_ini[93] = 105.57176931318*y[85] - 54.0657727682604*y[84] - 39.6392229058202*y[87] + 10.2713736253513*y[86] - 24.9575997948692*y[89] + 23.284964480954*y[88] - 39.6392229058202*y[91] + 10.2713736253513*y[90] - 211.14353862636*y[93] + 108.131545536521*y[92] + 79.2784458116403*y[95] - 20.5427472507027*y[94] + 49.9151995897384*y[97] - 46.569928961908*y[96] + 79.2784458116403*y[99] - 20.5427472507027*y[98] + 105.57176931318*y[101] - 54.0657727682604*y[100] - 39.6392229058202*y[103] + 10.2713736253513*y[102] - 24.9575997948692*y[105] + 23.284964480954*y[104] - 39.6392229058202*y[107] + 10.2713736253513*y[106]
    g_ini[94] = -10.2713736253513*y[85] - 39.6392229058202*y[84] + 54.0657727682604*y[87] + 105.57176931318*y[86] - 10.2713736253513*y[89] - 39.6392229058201*y[88] - 23.284964480954*y[91] - 24.9575997948692*y[90] + 20.5427472507027*y[93] + 79.2784458116403*y[92] - 108.131545536521*y[95] - 211.14353862636*y[94] + 20.5427472507027*y[97] + 79.2784458116403*y[96] + 46.569928961908*y[99] + 49.9151995897384*y[98] - 10.2713736253513*y[101] - 39.6392229058202*y[100] + 54.0657727682604*y[103] + 105.57176931318*y[102] - 10.2713736253513*y[105] - 39.6392229058201*y[104] - 23.284964480954*y[107] - 24.9575997948692*y[106]
    g_ini[95] = -39.6392229058202*y[85] + 10.2713736253513*y[84] + 105.57176931318*y[87] - 54.0657727682604*y[86] - 39.6392229058201*y[89] + 10.2713736253513*y[88] - 24.9575997948692*y[91] + 23.284964480954*y[90] + 79.2784458116403*y[93] - 20.5427472507027*y[92] - 211.14353862636*y[95] + 108.131545536521*y[94] + 79.2784458116403*y[97] - 20.5427472507027*y[96] + 49.9151995897384*y[99] - 46.569928961908*y[98] - 39.6392229058202*y[101] + 10.2713736253513*y[100] + 105.57176931318*y[103] - 54.0657727682604*y[102] - 39.6392229058201*y[105] + 10.2713736253513*y[104] - 24.9575997948692*y[107] + 23.284964480954*y[106]
    g_ini[96] = -23.284964480954*y[85] - 24.9575997948692*y[84] - 10.2713736253513*y[87] - 39.6392229058202*y[86] + 54.0657727682604*y[89] + 105.57176931318*y[88] - 10.2713736253514*y[91] - 39.6392229058201*y[90] + 46.569928961908*y[93] + 49.9151995897384*y[92] + 20.5427472507027*y[95] + 79.2784458116404*y[94] - 108.131545536521*y[97] - 211.14353862636*y[96] + 20.5427472507027*y[99] + 79.2784458116403*y[98] - 23.284964480954*y[101] - 24.9575997948692*y[100] - 10.2713736253513*y[103] - 39.6392229058202*y[102] + 54.0657727682604*y[105] + 105.57176931318*y[104] - 10.2713736253514*y[107] - 39.6392229058201*y[106]
    g_ini[97] = -24.9575997948692*y[85] + 23.284964480954*y[84] - 39.6392229058202*y[87] + 10.2713736253513*y[86] + 105.57176931318*y[89] - 54.0657727682604*y[88] - 39.6392229058201*y[91] + 10.2713736253514*y[90] + 49.9151995897384*y[93] - 46.569928961908*y[92] + 79.2784458116404*y[95] - 20.5427472507027*y[94] - 211.14353862636*y[97] + 108.131545536521*y[96] + 79.2784458116403*y[99] - 20.5427472507027*y[98] - 24.9575997948692*y[101] + 23.284964480954*y[100] - 39.6392229058202*y[103] + 10.2713736253513*y[102] + 105.57176931318*y[105] - 54.0657727682604*y[104] - 39.6392229058201*y[107] + 10.2713736253514*y[106]
    g_ini[98] = -10.2713736253513*y[85] - 39.6392229058202*y[84] - 23.284964480954*y[87] - 24.9575997948692*y[86] - 10.2713736253513*y[89] - 39.6392229058202*y[88] + 54.0657727682604*y[91] + 105.57176931318*y[90] + 20.5427472507027*y[93] + 79.2784458116403*y[92] + 46.569928961908*y[95] + 49.9151995897384*y[94] + 20.5427472507027*y[97] + 79.2784458116403*y[96] - 108.131545536521*y[99] - 211.14353862636*y[98] - 10.2713736253513*y[101] - 39.6392229058202*y[100] - 23.284964480954*y[103] - 24.9575997948692*y[102] - 10.2713736253513*y[105] - 39.6392229058202*y[104] + 54.0657727682604*y[107] + 105.57176931318*y[106]
    g_ini[99] = -39.6392229058202*y[85] + 10.2713736253513*y[84] - 24.9575997948692*y[87] + 23.284964480954*y[86] - 39.6392229058202*y[89] + 10.2713736253513*y[88] + 105.57176931318*y[91] - 54.0657727682604*y[90] + 79.2784458116403*y[93] - 20.5427472507027*y[92] + 49.9151995897384*y[95] - 46.569928961908*y[94] + 79.2784458116403*y[97] - 20.5427472507027*y[96] - 211.14353862636*y[99] + 108.131545536521*y[98] - 39.6392229058202*y[101] + 10.2713736253513*y[100] - 24.9575997948692*y[103] + 23.284964480954*y[102] - 39.6392229058202*y[105] + 10.2713736253513*y[104] + 105.57176931318*y[107] - 54.0657727682604*y[106]
    g_ini[100] = 5.65456401516768*y[25] + 30.9517475172273*y[24] + 1.84896616921897*y[27] - 9.21038227100566*y[26] + 0.793238195499529*y[29] - 9.00835072044485*y[28] + 1.84896616921897*y[31] - 9.21038227100566*y[30] + 54.0657727682604*y[93] + 105.57176931318*y[92] - 10.2713736253513*y[95] - 39.6392229058202*y[94] - 23.284964480954*y[97] - 24.9575997948692*y[96] - 10.2713736253513*y[99] - 39.6392229058202*y[98] - 113.786109551688*y[101] - 242.095286143588*y[100] + 18.6937810814837*y[103] + 88.488828082646*y[102] + 45.7766907664085*y[105] + 58.9235503101833*y[104] + 18.6937810814837*y[107] + 88.488828082646*y[106] + 54.0657727682604*y[109] + 105.57176931318*y[108] - 10.2713736253513*y[111] - 39.6392229058202*y[110] - 23.284964480954*y[113] - 24.9575997948692*y[112] - 10.2713736253513*y[115] - 39.6392229058202*y[114]
    g_ini[101] = 30.9517475172273*y[25] - 5.65456401516768*y[24] - 9.21038227100566*y[27] - 1.84896616921897*y[26] - 9.00835072044485*y[29] - 0.793238195499529*y[28] - 9.21038227100566*y[31] - 1.84896616921897*y[30] + 105.57176931318*y[93] - 54.0657727682604*y[92] - 39.6392229058202*y[95] + 10.2713736253513*y[94] - 24.9575997948692*y[97] + 23.284964480954*y[96] - 39.6392229058202*y[99] + 10.2713736253513*y[98] - 242.095286143588*y[101] + 113.786109551688*y[100] + 88.488828082646*y[103] - 18.6937810814837*y[102] + 58.9235503101833*y[105] - 45.7766907664085*y[104] + 88.488828082646*y[107] - 18.6937810814837*y[106] + 105.57176931318*y[109] - 54.0657727682604*y[108] - 39.6392229058202*y[111] + 10.2713736253513*y[110] - 24.9575997948692*y[113] + 23.284964480954*y[112] - 39.6392229058202*y[115] + 10.2713736253513*y[114]
    g_ini[102] = 1.84896616921897*y[25] - 9.21038227100566*y[24] + 5.65456401516768*y[27] + 30.9517475172273*y[26] + 1.84896616921897*y[29] - 9.21038227100566*y[28] + 0.793238195499528*y[31] - 9.00835072044485*y[30] - 10.2713736253513*y[93] - 39.6392229058202*y[92] + 54.0657727682604*y[95] + 105.57176931318*y[94] - 10.2713736253513*y[97] - 39.6392229058201*y[96] - 23.284964480954*y[99] - 24.9575997948692*y[98] + 18.6937810814837*y[101] + 88.488828082646*y[100] - 113.786109551688*y[103] - 242.095286143588*y[102] + 18.6937810814837*y[105] + 88.488828082646*y[104] + 45.7766907664085*y[107] + 58.9235503101833*y[106] - 10.2713736253513*y[109] - 39.6392229058202*y[108] + 54.0657727682604*y[111] + 105.57176931318*y[110] - 10.2713736253513*y[113] - 39.6392229058201*y[112] - 23.284964480954*y[115] - 24.9575997948692*y[114]
    g_ini[103] = -9.21038227100566*y[25] - 1.84896616921897*y[24] + 30.9517475172273*y[27] - 5.65456401516768*y[26] - 9.21038227100566*y[29] - 1.84896616921897*y[28] - 9.00835072044485*y[31] - 0.793238195499528*y[30] - 39.6392229058202*y[93] + 10.2713736253513*y[92] + 105.57176931318*y[95] - 54.0657727682604*y[94] - 39.6392229058201*y[97] + 10.2713736253513*y[96] - 24.9575997948692*y[99] + 23.284964480954*y[98] + 88.488828082646*y[101] - 18.6937810814837*y[100] - 242.095286143588*y[103] + 113.786109551688*y[102] + 88.488828082646*y[105] - 18.6937810814837*y[104] + 58.9235503101833*y[107] - 45.7766907664085*y[106] - 39.6392229058202*y[109] + 10.2713736253513*y[108] + 105.57176931318*y[111] - 54.0657727682604*y[110] - 39.6392229058201*y[113] + 10.2713736253513*y[112] - 24.9575997948692*y[115] + 23.284964480954*y[114]
    g_ini[104] = 0.793238195499527*y[25] - 9.00835072044484*y[24] + 1.84896616921897*y[27] - 9.21038227100566*y[26] + 5.65456401516768*y[29] + 30.9517475172273*y[28] + 1.84896616921897*y[31] - 9.21038227100566*y[30] - 23.284964480954*y[93] - 24.9575997948692*y[92] - 10.2713736253513*y[95] - 39.6392229058202*y[94] + 54.0657727682604*y[97] + 105.57176931318*y[96] - 10.2713736253514*y[99] - 39.6392229058201*y[98] + 45.7766907664085*y[101] + 58.9235503101833*y[100] + 18.6937810814837*y[103] + 88.4888280826461*y[102] - 113.786109551688*y[105] - 242.095286143588*y[104] + 18.6937810814837*y[107] + 88.4888280826459*y[106] - 23.284964480954*y[109] - 24.9575997948692*y[108] - 10.2713736253513*y[111] - 39.6392229058202*y[110] + 54.0657727682604*y[113] + 105.57176931318*y[112] - 10.2713736253514*y[115] - 39.6392229058201*y[114]
    g_ini[105] = -9.00835072044484*y[25] - 0.793238195499527*y[24] - 9.21038227100566*y[27] - 1.84896616921897*y[26] + 30.9517475172273*y[29] - 5.65456401516768*y[28] - 9.21038227100566*y[31] - 1.84896616921897*y[30] - 24.9575997948692*y[93] + 23.284964480954*y[92] - 39.6392229058202*y[95] + 10.2713736253513*y[94] + 105.57176931318*y[97] - 54.0657727682604*y[96] - 39.6392229058201*y[99] + 10.2713736253514*y[98] + 58.9235503101833*y[101] - 45.7766907664085*y[100] + 88.4888280826461*y[103] - 18.6937810814837*y[102] - 242.095286143588*y[105] + 113.786109551688*y[104] + 88.4888280826459*y[107] - 18.6937810814837*y[106] - 24.9575997948692*y[109] + 23.284964480954*y[108] - 39.6392229058202*y[111] + 10.2713736253513*y[110] + 105.57176931318*y[113] - 54.0657727682604*y[112] - 39.6392229058201*y[115] + 10.2713736253514*y[114]
    g_ini[106] = 1.84896616921897*y[25] - 9.21038227100566*y[24] + 0.793238195499527*y[27] - 9.00835072044485*y[26] + 1.84896616921897*y[29] - 9.21038227100566*y[28] + 5.65456401516768*y[31] + 30.9517475172273*y[30] - 10.2713736253513*y[93] - 39.6392229058202*y[92] - 23.284964480954*y[95] - 24.9575997948692*y[94] - 10.2713736253513*y[97] - 39.6392229058202*y[96] + 54.0657727682604*y[99] + 105.57176931318*y[98] + 18.6937810814837*y[101] + 88.488828082646*y[100] + 45.7766907664085*y[103] + 58.9235503101832*y[102] + 18.6937810814837*y[105] + 88.488828082646*y[104] - 113.786109551688*y[107] - 242.120286143588*y[106] - 10.2713736253513*y[109] - 39.6392229058202*y[108] - 23.284964480954*y[111] - 24.9575997948692*y[110] - 10.2713736253513*y[113] - 39.6392229058202*y[112] + 54.0657727682604*y[115] + 105.57176931318*y[114]
    g_ini[107] = -9.21038227100566*y[25] - 1.84896616921897*y[24] - 9.00835072044485*y[27] - 0.793238195499527*y[26] - 9.21038227100566*y[29] - 1.84896616921897*y[28] + 30.9517475172273*y[31] - 5.65456401516768*y[30] - 39.6392229058202*y[93] + 10.2713736253513*y[92] - 24.9575997948692*y[95] + 23.284964480954*y[94] - 39.6392229058202*y[97] + 10.2713736253513*y[96] + 105.57176931318*y[99] - 54.0657727682604*y[98] + 88.488828082646*y[101] - 18.6937810814837*y[100] + 58.9235503101832*y[103] - 45.7766907664085*y[102] + 88.488828082646*y[105] - 18.6937810814837*y[104] - 242.120286143588*y[107] + 113.786109551688*y[106] - 39.6392229058202*y[109] + 10.2713736253513*y[108] - 24.9575997948692*y[111] + 23.284964480954*y[110] - 39.6392229058202*y[113] + 10.2713736253513*y[112] + 105.57176931318*y[115] - 54.0657727682604*y[114]
    g_ini[108] = 54.0657727682604*y[101] + 105.57176931318*y[100] - 10.2713736253513*y[103] - 39.6392229058202*y[102] - 23.284964480954*y[105] - 24.9575997948692*y[104] - 10.2713736253513*y[107] - 39.6392229058202*y[106] - 108.131545536521*y[109] - 211.14353862636*y[108] + 20.5427472507027*y[111] + 79.2784458116403*y[110] + 46.569928961908*y[113] + 49.9151995897384*y[112] + 20.5427472507027*y[115] + 79.2784458116403*y[114] + 54.0657727682604*y[117] + 105.57176931318*y[116] - 10.2713736253513*y[119] - 39.6392229058202*y[118] - 23.284964480954*y[121] - 24.9575997948692*y[120] - 10.2713736253513*y[123] - 39.6392229058202*y[122]
    g_ini[109] = 105.57176931318*y[101] - 54.0657727682604*y[100] - 39.6392229058202*y[103] + 10.2713736253513*y[102] - 24.9575997948692*y[105] + 23.284964480954*y[104] - 39.6392229058202*y[107] + 10.2713736253513*y[106] - 211.14353862636*y[109] + 108.131545536521*y[108] + 79.2784458116403*y[111] - 20.5427472507027*y[110] + 49.9151995897384*y[113] - 46.569928961908*y[112] + 79.2784458116403*y[115] - 20.5427472507027*y[114] + 105.57176931318*y[117] - 54.0657727682604*y[116] - 39.6392229058202*y[119] + 10.2713736253513*y[118] - 24.9575997948692*y[121] + 23.284964480954*y[120] - 39.6392229058202*y[123] + 10.2713736253513*y[122]
    g_ini[110] = -10.2713736253513*y[101] - 39.6392229058202*y[100] + 54.0657727682604*y[103] + 105.57176931318*y[102] - 10.2713736253513*y[105] - 39.6392229058201*y[104] - 23.284964480954*y[107] - 24.9575997948692*y[106] + 20.5427472507027*y[109] + 79.2784458116403*y[108] - 108.131545536521*y[111] - 211.14353862636*y[110] + 20.5427472507027*y[113] + 79.2784458116403*y[112] + 46.569928961908*y[115] + 49.9151995897384*y[114] - 10.2713736253513*y[117] - 39.6392229058202*y[116] + 54.0657727682604*y[119] + 105.57176931318*y[118] - 10.2713736253513*y[121] - 39.6392229058201*y[120] - 23.284964480954*y[123] - 24.9575997948692*y[122]
    g_ini[111] = -39.6392229058202*y[101] + 10.2713736253513*y[100] + 105.57176931318*y[103] - 54.0657727682604*y[102] - 39.6392229058201*y[105] + 10.2713736253513*y[104] - 24.9575997948692*y[107] + 23.284964480954*y[106] + 79.2784458116403*y[109] - 20.5427472507027*y[108] - 211.14353862636*y[111] + 108.131545536521*y[110] + 79.2784458116403*y[113] - 20.5427472507027*y[112] + 49.9151995897384*y[115] - 46.569928961908*y[114] - 39.6392229058202*y[117] + 10.2713736253513*y[116] + 105.57176931318*y[119] - 54.0657727682604*y[118] - 39.6392229058201*y[121] + 10.2713736253513*y[120] - 24.9575997948692*y[123] + 23.284964480954*y[122]
    g_ini[112] = -23.284964480954*y[101] - 24.9575997948692*y[100] - 10.2713736253513*y[103] - 39.6392229058202*y[102] + 54.0657727682604*y[105] + 105.57176931318*y[104] - 10.2713736253514*y[107] - 39.6392229058201*y[106] + 46.569928961908*y[109] + 49.9151995897384*y[108] + 20.5427472507027*y[111] + 79.2784458116404*y[110] - 108.131545536521*y[113] - 211.14353862636*y[112] + 20.5427472507027*y[115] + 79.2784458116403*y[114] - 23.284964480954*y[117] - 24.9575997948692*y[116] - 10.2713736253513*y[119] - 39.6392229058202*y[118] + 54.0657727682604*y[121] + 105.57176931318*y[120] - 10.2713736253514*y[123] - 39.6392229058201*y[122]
    g_ini[113] = -24.9575997948692*y[101] + 23.284964480954*y[100] - 39.6392229058202*y[103] + 10.2713736253513*y[102] + 105.57176931318*y[105] - 54.0657727682604*y[104] - 39.6392229058201*y[107] + 10.2713736253514*y[106] + 49.9151995897384*y[109] - 46.569928961908*y[108] + 79.2784458116404*y[111] - 20.5427472507027*y[110] - 211.14353862636*y[113] + 108.131545536521*y[112] + 79.2784458116403*y[115] - 20.5427472507027*y[114] - 24.9575997948692*y[117] + 23.284964480954*y[116] - 39.6392229058202*y[119] + 10.2713736253513*y[118] + 105.57176931318*y[121] - 54.0657727682604*y[120] - 39.6392229058201*y[123] + 10.2713736253514*y[122]
    g_ini[114] = -10.2713736253513*y[101] - 39.6392229058202*y[100] - 23.284964480954*y[103] - 24.9575997948692*y[102] - 10.2713736253513*y[105] - 39.6392229058202*y[104] + 54.0657727682604*y[107] + 105.57176931318*y[106] + 20.5427472507027*y[109] + 79.2784458116403*y[108] + 46.569928961908*y[111] + 49.9151995897384*y[110] + 20.5427472507027*y[113] + 79.2784458116403*y[112] - 108.131545536521*y[115] - 211.14353862636*y[114] - 10.2713736253513*y[117] - 39.6392229058202*y[116] - 23.284964480954*y[119] - 24.9575997948692*y[118] - 10.2713736253513*y[121] - 39.6392229058202*y[120] + 54.0657727682604*y[123] + 105.57176931318*y[122]
    g_ini[115] = -39.6392229058202*y[101] + 10.2713736253513*y[100] - 24.9575997948692*y[103] + 23.284964480954*y[102] - 39.6392229058202*y[105] + 10.2713736253513*y[104] + 105.57176931318*y[107] - 54.0657727682604*y[106] + 79.2784458116403*y[109] - 20.5427472507027*y[108] + 49.9151995897384*y[111] - 46.569928961908*y[110] + 79.2784458116403*y[113] - 20.5427472507027*y[112] - 211.14353862636*y[115] + 108.131545536521*y[114] - 39.6392229058202*y[117] + 10.2713736253513*y[116] - 24.9575997948692*y[119] + 23.284964480954*y[118] - 39.6392229058202*y[121] + 10.2713736253513*y[120] + 105.57176931318*y[123] - 54.0657727682604*y[122]
    g_ini[116] = 54.0657727682604*y[109] + 105.57176931318*y[108] - 10.2713736253513*y[111] - 39.6392229058202*y[110] - 23.284964480954*y[113] - 24.9575997948692*y[112] - 10.2713736253513*y[115] - 39.6392229058202*y[114] - 108.131545536521*y[117] - 211.14353862636*y[116] + 20.5427472507027*y[119] + 79.2784458116403*y[118] + 46.569928961908*y[121] + 49.9151995897384*y[120] + 20.5427472507027*y[123] + 79.2784458116403*y[122] + 54.0657727682604*y[125] + 105.57176931318*y[124] - 10.2713736253513*y[127] - 39.6392229058202*y[126] - 23.284964480954*y[129] - 24.9575997948692*y[128] - 10.2713736253513*y[131] - 39.6392229058202*y[130]
    g_ini[117] = 105.57176931318*y[109] - 54.0657727682604*y[108] - 39.6392229058202*y[111] + 10.2713736253513*y[110] - 24.9575997948692*y[113] + 23.284964480954*y[112] - 39.6392229058202*y[115] + 10.2713736253513*y[114] - 211.14353862636*y[117] + 108.131545536521*y[116] + 79.2784458116403*y[119] - 20.5427472507027*y[118] + 49.9151995897384*y[121] - 46.569928961908*y[120] + 79.2784458116403*y[123] - 20.5427472507027*y[122] + 105.57176931318*y[125] - 54.0657727682604*y[124] - 39.6392229058202*y[127] + 10.2713736253513*y[126] - 24.9575997948692*y[129] + 23.284964480954*y[128] - 39.6392229058202*y[131] + 10.2713736253513*y[130]
    g_ini[118] = -10.2713736253513*y[109] - 39.6392229058202*y[108] + 54.0657727682604*y[111] + 105.57176931318*y[110] - 10.2713736253513*y[113] - 39.6392229058201*y[112] - 23.284964480954*y[115] - 24.9575997948692*y[114] + 20.5427472507027*y[117] + 79.2784458116403*y[116] - 108.131545536521*y[119] - 211.14353862636*y[118] + 20.5427472507027*y[121] + 79.2784458116403*y[120] + 46.569928961908*y[123] + 49.9151995897384*y[122] - 10.2713736253513*y[125] - 39.6392229058202*y[124] + 54.0657727682604*y[127] + 105.57176931318*y[126] - 10.2713736253513*y[129] - 39.6392229058201*y[128] - 23.284964480954*y[131] - 24.9575997948692*y[130]
    g_ini[119] = -39.6392229058202*y[109] + 10.2713736253513*y[108] + 105.57176931318*y[111] - 54.0657727682604*y[110] - 39.6392229058201*y[113] + 10.2713736253513*y[112] - 24.9575997948692*y[115] + 23.284964480954*y[114] + 79.2784458116403*y[117] - 20.5427472507027*y[116] - 211.14353862636*y[119] + 108.131545536521*y[118] + 79.2784458116403*y[121] - 20.5427472507027*y[120] + 49.9151995897384*y[123] - 46.569928961908*y[122] - 39.6392229058202*y[125] + 10.2713736253513*y[124] + 105.57176931318*y[127] - 54.0657727682604*y[126] - 39.6392229058201*y[129] + 10.2713736253513*y[128] - 24.9575997948692*y[131] + 23.284964480954*y[130]
    g_ini[120] = -23.284964480954*y[109] - 24.9575997948692*y[108] - 10.2713736253513*y[111] - 39.6392229058202*y[110] + 54.0657727682604*y[113] + 105.57176931318*y[112] - 10.2713736253514*y[115] - 39.6392229058201*y[114] + 46.569928961908*y[117] + 49.9151995897384*y[116] + 20.5427472507027*y[119] + 79.2784458116404*y[118] - 108.131545536521*y[121] - 211.14353862636*y[120] + 20.5427472507027*y[123] + 79.2784458116403*y[122] - 23.284964480954*y[125] - 24.9575997948692*y[124] - 10.2713736253513*y[127] - 39.6392229058202*y[126] + 54.0657727682604*y[129] + 105.57176931318*y[128] - 10.2713736253514*y[131] - 39.6392229058201*y[130]
    g_ini[121] = -24.9575997948692*y[109] + 23.284964480954*y[108] - 39.6392229058202*y[111] + 10.2713736253513*y[110] + 105.57176931318*y[113] - 54.0657727682604*y[112] - 39.6392229058201*y[115] + 10.2713736253514*y[114] + 49.9151995897384*y[117] - 46.569928961908*y[116] + 79.2784458116404*y[119] - 20.5427472507027*y[118] - 211.14353862636*y[121] + 108.131545536521*y[120] + 79.2784458116403*y[123] - 20.5427472507027*y[122] - 24.9575997948692*y[125] + 23.284964480954*y[124] - 39.6392229058202*y[127] + 10.2713736253513*y[126] + 105.57176931318*y[129] - 54.0657727682604*y[128] - 39.6392229058201*y[131] + 10.2713736253514*y[130]
    g_ini[122] = -10.2713736253513*y[109] - 39.6392229058202*y[108] - 23.284964480954*y[111] - 24.9575997948692*y[110] - 10.2713736253513*y[113] - 39.6392229058202*y[112] + 54.0657727682604*y[115] + 105.57176931318*y[114] + 20.5427472507027*y[117] + 79.2784458116403*y[116] + 46.569928961908*y[119] + 49.9151995897384*y[118] + 20.5427472507027*y[121] + 79.2784458116403*y[120] - 108.131545536521*y[123] - 211.16853862636*y[122] - 10.2713736253513*y[125] - 39.6392229058202*y[124] - 23.284964480954*y[127] - 24.9575997948692*y[126] - 10.2713736253513*y[129] - 39.6392229058202*y[128] + 54.0657727682604*y[131] + 105.57176931318*y[130]
    g_ini[123] = -39.6392229058202*y[109] + 10.2713736253513*y[108] - 24.9575997948692*y[111] + 23.284964480954*y[110] - 39.6392229058202*y[113] + 10.2713736253513*y[112] + 105.57176931318*y[115] - 54.0657727682604*y[114] + 79.2784458116403*y[117] - 20.5427472507027*y[116] + 49.9151995897384*y[119] - 46.569928961908*y[118] + 79.2784458116403*y[121] - 20.5427472507027*y[120] - 211.16853862636*y[123] + 108.131545536521*y[122] - 39.6392229058202*y[125] + 10.2713736253513*y[124] - 24.9575997948692*y[127] + 23.284964480954*y[126] - 39.6392229058202*y[129] + 10.2713736253513*y[128] + 105.57176931318*y[131] - 54.0657727682604*y[130]
    g_ini[124] = 54.0657727682604*y[133] + 105.57176931318*y[132] - 10.2713736253513*y[135] - 39.6392229058202*y[134] - 23.284964480954*y[137] - 24.9575997948692*y[136] - 10.2713736253513*y[139] - 39.6392229058202*y[138] + 5.65456401516768*y[33] + 30.9517475172273*y[32] + 1.84896616921897*y[35] - 9.21038227100566*y[34] + 0.793238195499529*y[37] - 9.00835072044485*y[36] + 1.84896616921897*y[39] - 9.21038227100566*y[38] + 54.0657727682604*y[117] + 105.57176931318*y[116] - 10.2713736253513*y[119] - 39.6392229058202*y[118] - 23.284964480954*y[121] - 24.9575997948692*y[120] - 10.2713736253513*y[123] - 39.6392229058202*y[122] - 113.786109551688*y[125] - 242.095286143588*y[124] + 18.6937810814837*y[127] + 88.488828082646*y[126] + 45.7766907664085*y[129] + 58.9235503101833*y[128] + 18.6937810814837*y[131] + 88.488828082646*y[130]
    g_ini[125] = 105.57176931318*y[133] - 54.0657727682604*y[132] - 39.6392229058202*y[135] + 10.2713736253513*y[134] - 24.9575997948692*y[137] + 23.284964480954*y[136] - 39.6392229058202*y[139] + 10.2713736253513*y[138] + 30.9517475172273*y[33] - 5.65456401516768*y[32] - 9.21038227100566*y[35] - 1.84896616921897*y[34] - 9.00835072044485*y[37] - 0.793238195499529*y[36] - 9.21038227100566*y[39] - 1.84896616921897*y[38] + 105.57176931318*y[117] - 54.0657727682604*y[116] - 39.6392229058202*y[119] + 10.2713736253513*y[118] - 24.9575997948692*y[121] + 23.284964480954*y[120] - 39.6392229058202*y[123] + 10.2713736253513*y[122] - 242.095286143588*y[125] + 113.786109551688*y[124] + 88.488828082646*y[127] - 18.6937810814837*y[126] + 58.9235503101833*y[129] - 45.7766907664085*y[128] + 88.488828082646*y[131] - 18.6937810814837*y[130]
    g_ini[126] = -10.2713736253513*y[133] - 39.6392229058202*y[132] + 54.0657727682604*y[135] + 105.57176931318*y[134] - 10.2713736253513*y[137] - 39.6392229058201*y[136] - 23.284964480954*y[139] - 24.9575997948692*y[138] + 1.84896616921897*y[33] - 9.21038227100566*y[32] + 5.65456401516768*y[35] + 30.9517475172273*y[34] + 1.84896616921897*y[37] - 9.21038227100566*y[36] + 0.793238195499528*y[39] - 9.00835072044485*y[38] - 10.2713736253513*y[117] - 39.6392229058202*y[116] + 54.0657727682604*y[119] + 105.57176931318*y[118] - 10.2713736253513*y[121] - 39.6392229058201*y[120] - 23.284964480954*y[123] - 24.9575997948692*y[122] + 18.6937810814837*y[125] + 88.488828082646*y[124] - 113.786109551688*y[127] - 242.095286143588*y[126] + 18.6937810814837*y[129] + 88.488828082646*y[128] + 45.7766907664085*y[131] + 58.9235503101833*y[130]
    g_ini[127] = -39.6392229058202*y[133] + 10.2713736253513*y[132] + 105.57176931318*y[135] - 54.0657727682604*y[134] - 39.6392229058201*y[137] + 10.2713736253513*y[136] - 24.9575997948692*y[139] + 23.284964480954*y[138] - 9.21038227100566*y[33] - 1.84896616921897*y[32] + 30.9517475172273*y[35] - 5.65456401516768*y[34] - 9.21038227100566*y[37] - 1.84896616921897*y[36] - 9.00835072044485*y[39] - 0.793238195499528*y[38] - 39.6392229058202*y[117] + 10.2713736253513*y[116] + 105.57176931318*y[119] - 54.0657727682604*y[118] - 39.6392229058201*y[121] + 10.2713736253513*y[120] - 24.9575997948692*y[123] + 23.284964480954*y[122] + 88.488828082646*y[125] - 18.6937810814837*y[124] - 242.095286143588*y[127] + 113.786109551688*y[126] + 88.488828082646*y[129] - 18.6937810814837*y[128] + 58.9235503101833*y[131] - 45.7766907664085*y[130]
    g_ini[128] = -23.284964480954*y[133] - 24.9575997948692*y[132] - 10.2713736253513*y[135] - 39.6392229058202*y[134] + 54.0657727682604*y[137] + 105.57176931318*y[136] - 10.2713736253514*y[139] - 39.6392229058201*y[138] + 0.793238195499527*y[33] - 9.00835072044484*y[32] + 1.84896616921897*y[35] - 9.21038227100566*y[34] + 5.65456401516768*y[37] + 30.9517475172273*y[36] + 1.84896616921897*y[39] - 9.21038227100566*y[38] - 23.284964480954*y[117] - 24.9575997948692*y[116] - 10.2713736253513*y[119] - 39.6392229058202*y[118] + 54.0657727682604*y[121] + 105.57176931318*y[120] - 10.2713736253514*y[123] - 39.6392229058201*y[122] + 45.7766907664085*y[125] + 58.9235503101833*y[124] + 18.6937810814837*y[127] + 88.4888280826461*y[126] - 113.786109551688*y[129] - 242.095286143588*y[128] + 18.6937810814837*y[131] + 88.4888280826459*y[130]
    g_ini[129] = -24.9575997948692*y[133] + 23.284964480954*y[132] - 39.6392229058202*y[135] + 10.2713736253513*y[134] + 105.57176931318*y[137] - 54.0657727682604*y[136] - 39.6392229058201*y[139] + 10.2713736253514*y[138] - 9.00835072044484*y[33] - 0.793238195499527*y[32] - 9.21038227100566*y[35] - 1.84896616921897*y[34] + 30.9517475172273*y[37] - 5.65456401516768*y[36] - 9.21038227100566*y[39] - 1.84896616921897*y[38] - 24.9575997948692*y[117] + 23.284964480954*y[116] - 39.6392229058202*y[119] + 10.2713736253513*y[118] + 105.57176931318*y[121] - 54.0657727682604*y[120] - 39.6392229058201*y[123] + 10.2713736253514*y[122] + 58.9235503101833*y[125] - 45.7766907664085*y[124] + 88.4888280826461*y[127] - 18.6937810814837*y[126] - 242.095286143588*y[129] + 113.786109551688*y[128] + 88.4888280826459*y[131] - 18.6937810814837*y[130]
    g_ini[130] = -10.2713736253513*y[133] - 39.6392229058202*y[132] - 23.284964480954*y[135] - 24.9575997948692*y[134] - 10.2713736253513*y[137] - 39.6392229058202*y[136] + 54.0657727682604*y[139] + 105.57176931318*y[138] + 1.84896616921897*y[33] - 9.21038227100566*y[32] + 0.793238195499527*y[35] - 9.00835072044485*y[34] + 1.84896616921897*y[37] - 9.21038227100566*y[36] + 5.65456401516768*y[39] + 30.9517475172273*y[38] - 10.2713736253513*y[117] - 39.6392229058202*y[116] - 23.284964480954*y[119] - 24.9575997948692*y[118] - 10.2713736253513*y[121] - 39.6392229058202*y[120] + 54.0657727682604*y[123] + 105.57176931318*y[122] + 18.6937810814837*y[125] + 88.488828082646*y[124] + 45.7766907664085*y[127] + 58.9235503101832*y[126] + 18.6937810814837*y[129] + 88.488828082646*y[128] - 113.786109551688*y[131] - 242.095286143588*y[130]
    g_ini[131] = -39.6392229058202*y[133] + 10.2713736253513*y[132] - 24.9575997948692*y[135] + 23.284964480954*y[134] - 39.6392229058202*y[137] + 10.2713736253513*y[136] + 105.57176931318*y[139] - 54.0657727682604*y[138] - 9.21038227100566*y[33] - 1.84896616921897*y[32] - 9.00835072044485*y[35] - 0.793238195499527*y[34] - 9.21038227100566*y[37] - 1.84896616921897*y[36] + 30.9517475172273*y[39] - 5.65456401516768*y[38] - 39.6392229058202*y[117] + 10.2713736253513*y[116] - 24.9575997948692*y[119] + 23.284964480954*y[118] - 39.6392229058202*y[121] + 10.2713736253513*y[120] + 105.57176931318*y[123] - 54.0657727682604*y[122] + 88.488828082646*y[125] - 18.6937810814837*y[124] + 58.9235503101832*y[127] - 45.7766907664085*y[126] + 88.488828082646*y[129] - 18.6937810814837*y[128] - 242.095286143588*y[131] + 113.786109551688*y[130]
    g_ini[132] = y[413] - 59.7203367834281*y[133] - 136.523516830407*y[132] + 8.42240745613237*y[135] + 48.8496051768258*y[134] + 22.4917262854545*y[137] + 33.9659505153141*y[136] + 8.42240745613237*y[139] + 48.8496051768258*y[138] + 5.65456401516768*y[41] + 30.9517475172273*y[40] + 1.84896616921897*y[43] - 9.21038227100566*y[42] + 0.793238195499529*y[45] - 9.00835072044485*y[44] + 1.84896616921897*y[47] - 9.21038227100566*y[46] + 54.0657727682604*y[125] + 105.57176931318*y[124] - 10.2713736253513*y[127] - 39.6392229058202*y[126] - 23.284964480954*y[129] - 24.9575997948692*y[128] - 10.2713736253513*y[131] - 39.6392229058202*y[130]
    g_ini[133] = y[414] - 136.523516830407*y[133] + 59.7203367834281*y[132] + 48.8496051768258*y[135] - 8.42240745613237*y[134] + 33.9659505153141*y[137] - 22.4917262854545*y[136] + 48.8496051768258*y[139] - 8.42240745613237*y[138] + 30.9517475172273*y[41] - 5.65456401516768*y[40] - 9.21038227100566*y[43] - 1.84896616921897*y[42] - 9.00835072044485*y[45] - 0.793238195499529*y[44] - 9.21038227100566*y[47] - 1.84896616921897*y[46] + 105.57176931318*y[125] - 54.0657727682604*y[124] - 39.6392229058202*y[127] + 10.2713736253513*y[126] - 24.9575997948692*y[129] + 23.284964480954*y[128] - 39.6392229058202*y[131] + 10.2713736253513*y[130]
    g_ini[134] = y[415] + 8.42240745613237*y[133] + 48.8496051768258*y[132] - 59.720336783428*y[135] - 136.523516830407*y[134] + 8.42240745613238*y[137] + 48.8496051768258*y[136] + 22.4917262854545*y[139] + 33.9659505153141*y[138] + 1.84896616921897*y[41] - 9.21038227100566*y[40] + 5.65456401516768*y[43] + 30.9517475172273*y[42] + 1.84896616921897*y[45] - 9.21038227100566*y[44] + 0.793238195499528*y[47] - 9.00835072044485*y[46] - 10.2713736253513*y[125] - 39.6392229058202*y[124] + 54.0657727682604*y[127] + 105.57176931318*y[126] - 10.2713736253513*y[129] - 39.6392229058201*y[128] - 23.284964480954*y[131] - 24.9575997948692*y[130]
    g_ini[135] = y[416] + 48.8496051768258*y[133] - 8.42240745613237*y[132] - 136.523516830407*y[135] + 59.720336783428*y[134] + 48.8496051768258*y[137] - 8.42240745613238*y[136] + 33.9659505153141*y[139] - 22.4917262854545*y[138] - 9.21038227100566*y[41] - 1.84896616921897*y[40] + 30.9517475172273*y[43] - 5.65456401516768*y[42] - 9.21038227100566*y[45] - 1.84896616921897*y[44] - 9.00835072044485*y[47] - 0.793238195499528*y[46] - 39.6392229058202*y[125] + 10.2713736253513*y[124] + 105.57176931318*y[127] - 54.0657727682604*y[126] - 39.6392229058201*y[129] + 10.2713736253513*y[128] - 24.9575997948692*y[131] + 23.284964480954*y[130]
    g_ini[136] = y[417] + 22.4917262854545*y[133] + 33.9659505153141*y[132] + 8.42240745613236*y[135] + 48.8496051768259*y[134] - 59.7203367834281*y[137] - 136.523516830407*y[136] + 8.42240745613239*y[139] + 48.8496051768258*y[138] + 0.793238195499527*y[41] - 9.00835072044484*y[40] + 1.84896616921897*y[43] - 9.21038227100566*y[42] + 5.65456401516768*y[45] + 30.9517475172273*y[44] + 1.84896616921897*y[47] - 9.21038227100566*y[46] - 23.284964480954*y[125] - 24.9575997948692*y[124] - 10.2713736253513*y[127] - 39.6392229058202*y[126] + 54.0657727682604*y[129] + 105.57176931318*y[128] - 10.2713736253514*y[131] - 39.6392229058201*y[130]
    g_ini[137] = y[418] + 33.9659505153141*y[133] - 22.4917262854545*y[132] + 48.8496051768259*y[135] - 8.42240745613236*y[134] - 136.523516830407*y[137] + 59.7203367834281*y[136] + 48.8496051768258*y[139] - 8.42240745613239*y[138] - 9.00835072044484*y[41] - 0.793238195499527*y[40] - 9.21038227100566*y[43] - 1.84896616921897*y[42] + 30.9517475172273*y[45] - 5.65456401516768*y[44] - 9.21038227100566*y[47] - 1.84896616921897*y[46] - 24.9575997948692*y[125] + 23.284964480954*y[124] - 39.6392229058202*y[127] + 10.2713736253513*y[126] + 105.57176931318*y[129] - 54.0657727682604*y[128] - 39.6392229058201*y[131] + 10.2713736253514*y[130]
    g_ini[138] = 8.42240745613237*y[133] + 48.8496051768258*y[132] + 22.4917262854545*y[135] + 33.965950515314*y[134] + 8.42240745613237*y[137] + 48.8496051768258*y[136] - 59.7203367834281*y[139] - 136.548516830407*y[138] + 1.84896616921897*y[41] - 9.21038227100566*y[40] + 0.793238195499527*y[43] - 9.00835072044485*y[42] + 1.84896616921897*y[45] - 9.21038227100566*y[44] + 5.65456401516768*y[47] + 30.9517475172273*y[46] - 10.2713736253513*y[125] - 39.6392229058202*y[124] - 23.284964480954*y[127] - 24.9575997948692*y[126] - 10.2713736253513*y[129] - 39.6392229058202*y[128] + 54.0657727682604*y[131] + 105.57176931318*y[130]
    g_ini[139] = 48.8496051768258*y[133] - 8.42240745613237*y[132] + 33.965950515314*y[135] - 22.4917262854545*y[134] + 48.8496051768258*y[137] - 8.42240745613237*y[136] - 136.548516830407*y[139] + 59.7203367834281*y[138] - 9.21038227100566*y[41] - 1.84896616921897*y[40] - 9.00835072044485*y[43] - 0.793238195499527*y[42] - 9.21038227100566*y[45] - 1.84896616921897*y[44] + 30.9517475172273*y[47] - 5.65456401516768*y[46] - 39.6392229058202*y[125] + 10.2713736253513*y[124] - 24.9575997948692*y[127] + 23.284964480954*y[126] - 39.6392229058202*y[129] + 10.2713736253513*y[128] + 105.57176931318*y[131] - 54.0657727682604*y[130]
    g_ini[140] = -9.69353831171601*y[141] - 53.0601386009611*y[140] - 3.16965629008966*y[143] + 15.7892267502954*y[142] - 1.35983690657062*y[145] + 15.442886949334*y[144] - 3.16965629008966*y[147] + 15.7892267502954*y[146] + 4.84676915585801*y[149] + 26.5300693004806*y[148] + 1.58482814504483*y[151] - 7.8946133751477*y[150] + 0.67991845328531*y[153] - 7.72144347466701*y[152] + 1.58482814504483*y[155] - 7.89461337514771*y[154] + 4.84676915585801*y[85] + 26.5300693004806*y[84] + 1.58482814504483*y[87] - 7.8946133751477*y[86] + 0.67991845328531*y[89] - 7.72144347466701*y[88] + 1.58482814504483*y[91] - 7.89461337514771*y[90]
    g_ini[141] = -53.0601386009611*y[141] + 9.69353831171601*y[140] + 15.7892267502954*y[143] + 3.16965629008966*y[142] + 15.442886949334*y[145] + 1.35983690657062*y[144] + 15.7892267502954*y[147] + 3.16965629008966*y[146] + 26.5300693004806*y[149] - 4.84676915585801*y[148] - 7.8946133751477*y[151] - 1.58482814504483*y[150] - 7.72144347466701*y[153] - 0.67991845328531*y[152] - 7.89461337514771*y[155] - 1.58482814504483*y[154] + 26.5300693004806*y[85] - 4.84676915585801*y[84] - 7.8946133751477*y[87] - 1.58482814504483*y[86] - 7.72144347466701*y[89] - 0.67991845328531*y[88] - 7.89461337514771*y[91] - 1.58482814504483*y[90]
    g_ini[142] = -3.16965629008966*y[141] + 15.7892267502954*y[140] - 9.69353831171602*y[143] - 53.0601386009611*y[142] - 3.16965629008967*y[145] + 15.7892267502954*y[144] - 1.35983690657062*y[147] + 15.442886949334*y[146] + 1.58482814504483*y[149] - 7.89461337514771*y[148] + 4.84676915585801*y[151] + 26.5300693004806*y[150] + 1.58482814504483*y[153] - 7.89461337514771*y[152] + 0.679918453285308*y[155] - 7.72144347466701*y[154] + 1.58482814504483*y[85] - 7.89461337514771*y[84] + 4.84676915585801*y[87] + 26.5300693004806*y[86] + 1.58482814504483*y[89] - 7.89461337514771*y[88] + 0.679918453285308*y[91] - 7.72144347466701*y[90]
    g_ini[143] = 15.7892267502954*y[141] + 3.16965629008966*y[140] - 53.0601386009611*y[143] + 9.69353831171602*y[142] + 15.7892267502954*y[145] + 3.16965629008967*y[144] + 15.442886949334*y[147] + 1.35983690657062*y[146] - 7.89461337514771*y[149] - 1.58482814504483*y[148] + 26.5300693004806*y[151] - 4.84676915585801*y[150] - 7.89461337514771*y[153] - 1.58482814504483*y[152] - 7.72144347466701*y[155] - 0.679918453285308*y[154] - 7.89461337514771*y[85] - 1.58482814504483*y[84] + 26.5300693004806*y[87] - 4.84676915585801*y[86] - 7.89461337514771*y[89] - 1.58482814504483*y[88] - 7.72144347466701*y[91] - 0.679918453285308*y[90]
    g_ini[144] = -1.35983690657062*y[141] + 15.442886949334*y[140] - 3.16965629008966*y[143] + 15.7892267502954*y[142] - 9.69353831171602*y[145] - 53.0601386009611*y[144] - 3.16965629008967*y[147] + 15.7892267502954*y[146] + 0.67991845328531*y[149] - 7.72144347466701*y[148] + 1.58482814504483*y[151] - 7.8946133751477*y[150] + 4.84676915585801*y[153] + 26.5300693004806*y[152] + 1.58482814504483*y[155] - 7.89461337514771*y[154] + 0.67991845328531*y[85] - 7.72144347466701*y[84] + 1.58482814504483*y[87] - 7.8946133751477*y[86] + 4.84676915585801*y[89] + 26.5300693004806*y[88] + 1.58482814504483*y[91] - 7.89461337514771*y[90]
    g_ini[145] = 15.442886949334*y[141] + 1.35983690657062*y[140] + 15.7892267502954*y[143] + 3.16965629008966*y[142] - 53.0601386009611*y[145] + 9.69353831171602*y[144] + 15.7892267502954*y[147] + 3.16965629008967*y[146] - 7.72144347466701*y[149] - 0.67991845328531*y[148] - 7.8946133751477*y[151] - 1.58482814504483*y[150] + 26.5300693004806*y[153] - 4.84676915585801*y[152] - 7.89461337514771*y[155] - 1.58482814504483*y[154] - 7.72144347466701*y[85] - 0.67991845328531*y[84] - 7.8946133751477*y[87] - 1.58482814504483*y[86] + 26.5300693004806*y[89] - 4.84676915585801*y[88] - 7.89461337514771*y[91] - 1.58482814504483*y[90]
    g_ini[146] = -3.16965629008966*y[141] + 15.7892267502954*y[140] - 1.35983690657062*y[143] + 15.442886949334*y[142] - 3.16965629008966*y[145] + 15.7892267502954*y[144] - 9.69353831171602*y[147] - 53.0601386009611*y[146] + 1.58482814504483*y[149] - 7.89461337514771*y[148] + 0.679918453285308*y[151] - 7.72144347466701*y[150] + 1.58482814504483*y[153] - 7.89461337514771*y[152] + 4.84676915585801*y[155] + 26.5300693004806*y[154] + 1.58482814504483*y[85] - 7.89461337514771*y[84] + 0.679918453285308*y[87] - 7.72144347466701*y[86] + 1.58482814504483*y[89] - 7.89461337514771*y[88] + 4.84676915585801*y[91] + 26.5300693004806*y[90]
    g_ini[147] = 15.7892267502954*y[141] + 3.16965629008966*y[140] + 15.442886949334*y[143] + 1.35983690657062*y[142] + 15.7892267502954*y[145] + 3.16965629008966*y[144] - 53.0601386009611*y[147] + 9.69353831171602*y[146] - 7.89461337514771*y[149] - 1.58482814504483*y[148] - 7.72144347466701*y[151] - 0.679918453285308*y[150] - 7.89461337514771*y[153] - 1.58482814504483*y[152] + 26.5300693004806*y[155] - 4.84676915585801*y[154] - 7.89461337514771*y[85] - 1.58482814504483*y[84] - 7.72144347466701*y[87] - 0.679918453285308*y[86] - 7.89461337514771*y[89] - 1.58482814504483*y[88] + 26.5300693004806*y[91] - 4.84676915585801*y[90]
    g_ini[148] = 4.84676915585801*y[141] + 26.5300693004806*y[140] + 1.58482814504483*y[143] - 7.8946133751477*y[142] + 0.67991845328531*y[145] - 7.72144347466701*y[144] + 1.58482814504483*y[147] - 7.89461337514771*y[146] - 9.69353831171601*y[149] - 53.0601386009611*y[148] - 3.16965629008966*y[151] + 15.7892267502954*y[150] - 1.35983690657062*y[153] + 15.442886949334*y[152] - 3.16965629008966*y[155] + 15.7892267502954*y[154] + 4.84676915585801*y[157] + 26.5300693004806*y[156] + 1.58482814504483*y[159] - 7.8946133751477*y[158] + 0.67991845328531*y[161] - 7.72144347466701*y[160] + 1.58482814504483*y[163] - 7.89461337514771*y[162]
    g_ini[149] = 26.5300693004806*y[141] - 4.84676915585801*y[140] - 7.8946133751477*y[143] - 1.58482814504483*y[142] - 7.72144347466701*y[145] - 0.67991845328531*y[144] - 7.89461337514771*y[147] - 1.58482814504483*y[146] - 53.0601386009611*y[149] + 9.69353831171601*y[148] + 15.7892267502954*y[151] + 3.16965629008966*y[150] + 15.442886949334*y[153] + 1.35983690657062*y[152] + 15.7892267502954*y[155] + 3.16965629008966*y[154] + 26.5300693004806*y[157] - 4.84676915585801*y[156] - 7.8946133751477*y[159] - 1.58482814504483*y[158] - 7.72144347466701*y[161] - 0.67991845328531*y[160] - 7.89461337514771*y[163] - 1.58482814504483*y[162]
    g_ini[150] = 1.58482814504483*y[141] - 7.89461337514771*y[140] + 4.84676915585801*y[143] + 26.5300693004806*y[142] + 1.58482814504483*y[145] - 7.89461337514771*y[144] + 0.679918453285308*y[147] - 7.72144347466701*y[146] - 3.16965629008966*y[149] + 15.7892267502954*y[148] - 9.69353831171602*y[151] - 53.0601386009611*y[150] - 3.16965629008967*y[153] + 15.7892267502954*y[152] - 1.35983690657062*y[155] + 15.442886949334*y[154] + 1.58482814504483*y[157] - 7.89461337514771*y[156] + 4.84676915585801*y[159] + 26.5300693004806*y[158] + 1.58482814504483*y[161] - 7.89461337514771*y[160] + 0.679918453285308*y[163] - 7.72144347466701*y[162]
    g_ini[151] = -7.89461337514771*y[141] - 1.58482814504483*y[140] + 26.5300693004806*y[143] - 4.84676915585801*y[142] - 7.89461337514771*y[145] - 1.58482814504483*y[144] - 7.72144347466701*y[147] - 0.679918453285308*y[146] + 15.7892267502954*y[149] + 3.16965629008966*y[148] - 53.0601386009611*y[151] + 9.69353831171602*y[150] + 15.7892267502954*y[153] + 3.16965629008967*y[152] + 15.442886949334*y[155] + 1.35983690657062*y[154] - 7.89461337514771*y[157] - 1.58482814504483*y[156] + 26.5300693004806*y[159] - 4.84676915585801*y[158] - 7.89461337514771*y[161] - 1.58482814504483*y[160] - 7.72144347466701*y[163] - 0.679918453285308*y[162]
    g_ini[152] = 0.67991845328531*y[141] - 7.72144347466701*y[140] + 1.58482814504483*y[143] - 7.8946133751477*y[142] + 4.84676915585801*y[145] + 26.5300693004806*y[144] + 1.58482814504483*y[147] - 7.89461337514771*y[146] - 1.35983690657062*y[149] + 15.442886949334*y[148] - 3.16965629008966*y[151] + 15.7892267502954*y[150] - 9.69353831171602*y[153] - 53.0601386009611*y[152] - 3.16965629008967*y[155] + 15.7892267502954*y[154] + 0.67991845328531*y[157] - 7.72144347466701*y[156] + 1.58482814504483*y[159] - 7.8946133751477*y[158] + 4.84676915585801*y[161] + 26.5300693004806*y[160] + 1.58482814504483*y[163] - 7.89461337514771*y[162]
    g_ini[153] = -7.72144347466701*y[141] - 0.67991845328531*y[140] - 7.8946133751477*y[143] - 1.58482814504483*y[142] + 26.5300693004806*y[145] - 4.84676915585801*y[144] - 7.89461337514771*y[147] - 1.58482814504483*y[146] + 15.442886949334*y[149] + 1.35983690657062*y[148] + 15.7892267502954*y[151] + 3.16965629008966*y[150] - 53.0601386009611*y[153] + 9.69353831171602*y[152] + 15.7892267502954*y[155] + 3.16965629008967*y[154] - 7.72144347466701*y[157] - 0.67991845328531*y[156] - 7.8946133751477*y[159] - 1.58482814504483*y[158] + 26.5300693004806*y[161] - 4.84676915585801*y[160] - 7.89461337514771*y[163] - 1.58482814504483*y[162]
    g_ini[154] = 1.58482814504483*y[141] - 7.89461337514771*y[140] + 0.679918453285308*y[143] - 7.72144347466701*y[142] + 1.58482814504483*y[145] - 7.89461337514771*y[144] + 4.84676915585801*y[147] + 26.5300693004806*y[146] - 3.16965629008966*y[149] + 15.7892267502954*y[148] - 1.35983690657062*y[151] + 15.442886949334*y[150] - 3.16965629008966*y[153] + 15.7892267502954*y[152] - 9.69353831171602*y[155] - 53.0851386009611*y[154] + 1.58482814504483*y[157] - 7.89461337514771*y[156] + 0.679918453285308*y[159] - 7.72144347466701*y[158] + 1.58482814504483*y[161] - 7.89461337514771*y[160] + 4.84676915585801*y[163] + 26.5300693004806*y[162]
    g_ini[155] = -7.89461337514771*y[141] - 1.58482814504483*y[140] - 7.72144347466701*y[143] - 0.679918453285308*y[142] - 7.89461337514771*y[145] - 1.58482814504483*y[144] + 26.5300693004806*y[147] - 4.84676915585801*y[146] + 15.7892267502954*y[149] + 3.16965629008966*y[148] + 15.442886949334*y[151] + 1.35983690657062*y[150] + 15.7892267502954*y[153] + 3.16965629008966*y[152] - 53.0851386009611*y[155] + 9.69353831171602*y[154] - 7.89461337514771*y[157] - 1.58482814504483*y[156] - 7.72144347466701*y[159] - 0.679918453285308*y[158] - 7.89461337514771*y[161] - 1.58482814504483*y[160] + 26.5300693004806*y[163] - 4.84676915585801*y[162]
    g_ini[156] = y[423] + 4.84676915585801*y[149] + 26.5300693004806*y[148] + 1.58482814504483*y[151] - 7.8946133751477*y[150] + 0.67991845328531*y[153] - 7.72144347466701*y[152] + 1.58482814504483*y[155] - 7.89461337514771*y[154] - 9.69353831171601*y[157] - 53.0601386009611*y[156] - 3.16965629008966*y[159] + 15.7892267502954*y[158] - 1.35983690657062*y[161] + 15.442886949334*y[160] - 3.16965629008966*y[163] + 15.7892267502954*y[162] + 4.84676915585801*y[17] + 26.5300693004806*y[16] + 1.58482814504483*y[19] - 7.8946133751477*y[18] + 0.67991845328531*y[21] - 7.72144347466701*y[20] + 1.58482814504483*y[23] - 7.89461337514771*y[22]
    g_ini[157] = y[424] + 26.5300693004806*y[149] - 4.84676915585801*y[148] - 7.8946133751477*y[151] - 1.58482814504483*y[150] - 7.72144347466701*y[153] - 0.67991845328531*y[152] - 7.89461337514771*y[155] - 1.58482814504483*y[154] - 53.0601386009611*y[157] + 9.69353831171601*y[156] + 15.7892267502954*y[159] + 3.16965629008966*y[158] + 15.442886949334*y[161] + 1.35983690657062*y[160] + 15.7892267502954*y[163] + 3.16965629008966*y[162] + 26.5300693004806*y[17] - 4.84676915585801*y[16] - 7.8946133751477*y[19] - 1.58482814504483*y[18] - 7.72144347466701*y[21] - 0.67991845328531*y[20] - 7.89461337514771*y[23] - 1.58482814504483*y[22]
    g_ini[158] = y[425] + 1.58482814504483*y[149] - 7.89461337514771*y[148] + 4.84676915585801*y[151] + 26.5300693004806*y[150] + 1.58482814504483*y[153] - 7.89461337514771*y[152] + 0.679918453285308*y[155] - 7.72144347466701*y[154] - 3.16965629008966*y[157] + 15.7892267502954*y[156] - 9.69353831171602*y[159] - 53.0601386009611*y[158] - 3.16965629008967*y[161] + 15.7892267502954*y[160] - 1.35983690657062*y[163] + 15.442886949334*y[162] + 1.58482814504483*y[17] - 7.89461337514771*y[16] + 4.84676915585801*y[19] + 26.5300693004806*y[18] + 1.58482814504483*y[21] - 7.89461337514771*y[20] + 0.679918453285308*y[23] - 7.72144347466701*y[22]
    g_ini[159] = y[426] - 7.89461337514771*y[149] - 1.58482814504483*y[148] + 26.5300693004806*y[151] - 4.84676915585801*y[150] - 7.89461337514771*y[153] - 1.58482814504483*y[152] - 7.72144347466701*y[155] - 0.679918453285308*y[154] + 15.7892267502954*y[157] + 3.16965629008966*y[156] - 53.0601386009611*y[159] + 9.69353831171602*y[158] + 15.7892267502954*y[161] + 3.16965629008967*y[160] + 15.442886949334*y[163] + 1.35983690657062*y[162] - 7.89461337514771*y[17] - 1.58482814504483*y[16] + 26.5300693004806*y[19] - 4.84676915585801*y[18] - 7.89461337514771*y[21] - 1.58482814504483*y[20] - 7.72144347466701*y[23] - 0.679918453285308*y[22]
    g_ini[160] = y[427] + 0.67991845328531*y[149] - 7.72144347466701*y[148] + 1.58482814504483*y[151] - 7.8946133751477*y[150] + 4.84676915585801*y[153] + 26.5300693004806*y[152] + 1.58482814504483*y[155] - 7.89461337514771*y[154] - 1.35983690657062*y[157] + 15.442886949334*y[156] - 3.16965629008966*y[159] + 15.7892267502954*y[158] - 9.69353831171602*y[161] - 53.0601386009611*y[160] - 3.16965629008967*y[163] + 15.7892267502954*y[162] + 0.67991845328531*y[17] - 7.72144347466701*y[16] + 1.58482814504483*y[19] - 7.8946133751477*y[18] + 4.84676915585801*y[21] + 26.5300693004806*y[20] + 1.58482814504483*y[23] - 7.89461337514771*y[22]
    g_ini[161] = y[428] - 7.72144347466701*y[149] - 0.67991845328531*y[148] - 7.8946133751477*y[151] - 1.58482814504483*y[150] + 26.5300693004806*y[153] - 4.84676915585801*y[152] - 7.89461337514771*y[155] - 1.58482814504483*y[154] + 15.442886949334*y[157] + 1.35983690657062*y[156] + 15.7892267502954*y[159] + 3.16965629008966*y[158] - 53.0601386009611*y[161] + 9.69353831171602*y[160] + 15.7892267502954*y[163] + 3.16965629008967*y[162] - 7.72144347466701*y[17] - 0.67991845328531*y[16] - 7.8946133751477*y[19] - 1.58482814504483*y[18] + 26.5300693004806*y[21] - 4.84676915585801*y[20] - 7.89461337514771*y[23] - 1.58482814504483*y[22]
    g_ini[162] = 1.58482814504483*y[149] - 7.89461337514771*y[148] + 0.679918453285308*y[151] - 7.72144347466701*y[150] + 1.58482814504483*y[153] - 7.89461337514771*y[152] + 4.84676915585801*y[155] + 26.5300693004806*y[154] - 3.16965629008966*y[157] + 15.7892267502954*y[156] - 1.35983690657062*y[159] + 15.442886949334*y[158] - 3.16965629008966*y[161] + 15.7892267502954*y[160] - 9.69353831171602*y[163] - 53.0601386009611*y[162] + 1.58482814504483*y[17] - 7.89461337514771*y[16] + 0.679918453285308*y[19] - 7.72144347466701*y[18] + 1.58482814504483*y[21] - 7.89461337514771*y[20] + 4.84676915585801*y[23] + 26.5300693004806*y[22]
    g_ini[163] = -7.89461337514771*y[149] - 1.58482814504483*y[148] - 7.72144347466701*y[151] - 0.679918453285308*y[150] - 7.89461337514771*y[153] - 1.58482814504483*y[152] + 26.5300693004806*y[155] - 4.84676915585801*y[154] + 15.7892267502954*y[157] + 3.16965629008966*y[156] + 15.442886949334*y[159] + 1.35983690657062*y[158] + 15.7892267502954*y[161] + 3.16965629008966*y[160] - 53.0601386009611*y[163] + 9.69353831171602*y[162] - 7.89461337514771*y[17] - 1.58482814504483*y[16] - 7.72144347466701*y[19] - 0.679918453285308*y[18] - 7.89461337514771*y[21] - 1.58482814504483*y[20] + 26.5300693004806*y[23] - 4.84676915585801*y[22]
    g_ini[164] = -1067.7048070413*y[164] + 67.7048070412999*y[172]
    g_ini[165] = -1067.7048070413*y[165] + 67.7048070412999*y[173]
    g_ini[166] = 157.977883096366*y[52] + 67.7048070412999*u[6] - 361.092304220266*y[166] + 135.4096140826*y[174]
    g_ini[167] = 157.977883096366*y[53] + 67.7048070412999*u[7] - 361.092304220266*y[167] + 135.4096140826*y[175]
    g_ini[168] = 157.977883096366*y[206] + 67.7048070412999*u[8] - 361.092304220266*y[168] + 135.4096140826*y[176]
    g_ini[169] = 157.977883096366*y[207] + 67.7048070412999*u[9] - 361.092304220266*y[169] + 135.4096140826*y[177]
    g_ini[170] = 157.977883096366*y[208] + 67.7048070412999*u[10] - 361.092304220266*y[170] + 135.4096140826*y[178]
    g_ini[171] = 157.977883096366*y[209] + 67.7048070412999*u[11] - 361.092304220266*y[171] + 135.4096140826*y[179]
    g_ini[172] = 157.977883096366*y[54] + 67.7048070412999*y[164] - 361.092304220266*y[172] + 135.4096140826*y[180]
    g_ini[173] = 157.977883096366*y[55] + 67.7048070412999*y[165] - 361.092304220266*y[173] + 135.4096140826*y[181]
    g_ini[174] = 45.1365380275333*y[222] + 135.4096140826*y[166] - 248.250959151433*y[174] + 67.7048070412999*y[182]
    g_ini[175] = 45.1365380275333*y[223] + 135.4096140826*y[167] - 248.250959151433*y[175] + 67.7048070412999*y[183]
    g_ini[176] = 45.1365380275333*y[224] + 135.4096140826*y[168] - 248.250959151433*y[176] + 67.7048070412999*y[184]
    g_ini[177] = 45.1365380275333*y[225] + 135.4096140826*y[169] - 248.250959151433*y[177] + 67.7048070412999*y[185]
    g_ini[178] = 45.1365380275333*y[226] + 135.4096140826*y[170] - 248.250959151433*y[178] + 67.7048070412999*y[186]
    g_ini[179] = 45.1365380275333*y[227] + 135.4096140826*y[171] - 248.250959151433*y[179] + 67.7048070412999*y[187]
    g_ini[180] = 45.1365380275333*y[228] + 135.4096140826*y[172] - 248.250959151433*y[180] + 67.7048070412999*y[188]
    g_ini[181] = 45.1365380275333*y[229] + 135.4096140826*y[173] - 248.250959151433*y[181] + 67.7048070412999*y[189]
    g_ini[182] = 157.977883096366*y[56] + 67.7048070412999*y[174] - 270.8192281652*y[182] + 45.1365380275333*y[190]
    g_ini[183] = 157.977883096366*y[57] + 67.7048070412999*y[175] - 270.8192281652*y[183] + 45.1365380275333*y[191]
    g_ini[184] = 157.977883096366*y[210] + 67.7048070412999*y[176] - 270.8192281652*y[184] + 45.1365380275333*y[192]
    g_ini[185] = 157.977883096366*y[211] + 67.7048070412999*y[177] - 270.8192281652*y[185] + 45.1365380275333*y[193]
    g_ini[186] = 157.977883096366*y[212] + 67.7048070412999*y[178] - 270.8192281652*y[186] + 45.1365380275333*y[194]
    g_ini[187] = 157.977883096366*y[213] + 67.7048070412999*y[179] - 270.8192281652*y[187] + 45.1365380275333*y[195]
    g_ini[188] = 157.977883096366*y[58] + 67.7048070412999*y[180] - 270.8192281652*y[188] + 45.1365380275333*y[196]
    g_ini[189] = 157.977883096366*y[59] + 67.7048070412999*y[181] - 270.8192281652*y[189] + 45.1365380275333*y[197]
    g_ini[190] = 157.977883096366*y[198] + 157.977883096366*y[60] + 45.1365380275333*y[182] - 361.092304220266*y[190]
    g_ini[191] = 157.977883096366*y[199] + 157.977883096366*y[61] + 45.1365380275333*y[183] - 361.092304220266*y[191]
    g_ini[192] = 157.977883096366*y[200] + 157.977883096366*y[214] + 45.1365380275333*y[184] - 361.092304220266*y[192]
    g_ini[193] = 157.977883096366*y[201] + 157.977883096366*y[215] + 45.1365380275333*y[185] - 361.092304220266*y[193]
    g_ini[194] = 157.977883096366*y[202] + 157.977883096366*y[216] + 45.1365380275333*y[186] - 361.092304220266*y[194]
    g_ini[195] = 157.977883096366*y[203] + 157.977883096366*y[217] + 45.1365380275333*y[187] - 361.092304220266*y[195]
    g_ini[196] = 157.977883096366*y[204] + 157.977883096366*y[62] + 45.1365380275333*y[188] - 361.092304220266*y[196]
    g_ini[197] = 157.977883096366*y[205] + 157.977883096366*y[63] + 45.1365380275333*y[189] - 361.092304220266*y[197]
    g_ini[198] = y[419] - 315.955766192733*y[198] + 157.977883096366*y[64] + 157.977883096366*y[190]
    g_ini[199] = -315.955766192733*y[199] + 157.977883096366*y[65] + 157.977883096366*y[191]
    g_ini[200] = -315.955766192733*y[200] + 157.977883096366*y[218] + 157.977883096366*y[192]
    g_ini[201] = -315.955766192733*y[201] + 157.977883096366*y[219] + 157.977883096366*y[193]
    g_ini[202] = -315.955766192733*y[202] + 157.977883096366*y[220] + 157.977883096366*y[194]
    g_ini[203] = -315.955766192733*y[203] + 157.977883096366*y[221] + 157.977883096366*y[195]
    g_ini[204] = y[420] - 315.955766192733*y[204] + 157.977883096366*y[66] + 157.977883096366*y[196]
    g_ini[205] = -315.955766192733*y[205] + 157.977883096366*y[67] + 157.977883096366*y[197]
    g_ini[206] = -157.977883096366*y[206] + 157.977883096366*y[168]
    g_ini[207] = -157.977883096366*y[207] + 157.977883096366*y[169]
    g_ini[208] = -157.977883096366*y[208] + 157.977883096366*y[170]
    g_ini[209] = -157.977883096366*y[209] + 157.977883096366*y[171]
    g_ini[210] = -157.977883096366*y[210] + 157.977883096366*y[184]
    g_ini[211] = -157.977883096366*y[211] + 157.977883096366*y[185]
    g_ini[212] = -157.977883096366*y[212] + 157.977883096366*y[186]
    g_ini[213] = -157.977883096366*y[213] + 157.977883096366*y[187]
    g_ini[214] = -157.977883096366*y[214] + 157.977883096366*y[192]
    g_ini[215] = -157.977883096366*y[215] + 157.977883096366*y[193]
    g_ini[216] = -157.977883096366*y[216] + 157.977883096366*y[194]
    g_ini[217] = -157.977883096366*y[217] + 157.977883096366*y[195]
    g_ini[218] = 157.977883096366*y[200] - 157.977883096366*y[218]
    g_ini[219] = 157.977883096366*y[201] - 157.977883096366*y[219]
    g_ini[220] = 157.977883096366*y[202] - 157.977883096366*y[220]
    g_ini[221] = 157.977883096366*y[203] - 157.977883096366*y[221]
    g_ini[222] = y[429] - 180.546152110133*y[222] + 135.4096140826*y[48] + 45.1365380275333*y[174]
    g_ini[223] = -180.546152110133*y[223] + 135.4096140826*y[49] + 45.1365380275333*y[175]
    g_ini[224] = -180.546152110133*y[224] + 135.4096140826*y[230] + 45.1365380275333*y[176]
    g_ini[225] = -180.546152110133*y[225] + 135.4096140826*y[231] + 45.1365380275333*y[177]
    g_ini[226] = -180.546152110133*y[226] + 135.4096140826*y[232] + 45.1365380275333*y[178]
    g_ini[227] = -180.546152110133*y[227] + 135.4096140826*y[233] + 45.1365380275333*y[179]
    g_ini[228] = y[430] - 180.546152110133*y[228] + 135.4096140826*y[50] + 45.1365380275333*y[180]
    g_ini[229] = -180.546152110133*y[229] + 135.4096140826*y[51] + 45.1365380275333*y[181]
    g_ini[230] = 135.4096140826*y[224] - 135.4096140826*y[230]
    g_ini[231] = 135.4096140826*y[225] - 135.4096140826*y[231]
    g_ini[232] = 135.4096140826*y[226] - 135.4096140826*y[232]
    g_ini[233] = 135.4096140826*y[227] - 135.4096140826*y[233]
    g_ini[234] = -y[234] + 0.0196078431372549*u[1] + 0.00490196078431373*u[0] - 0.00980392156862745*u[3] - 0.00245098039215686*u[2] - 0.00980392156862745*u[5] - 0.00245098039215686*u[4] - 0.849044513514155*y[1] - 0.212261128378539*y[0] + 0.849044513514155*y[3] + 0.212261128378539*y[2]
    g_ini[235] = -y[235] + 0.00490196078431373*u[1] - 0.0196078431372549*u[0] - 0.00245098039215686*u[3] + 0.00980392156862745*u[2] - 0.00245098039215686*u[5] + 0.00980392156862745*u[4] - 0.212261128378539*y[1] + 0.849044513514155*y[0] + 0.212261128378539*y[3] - 0.849044513514155*y[2]
    g_ini[236] = -y[236] - 0.00980392156862745*u[1] - 0.00245098039215686*u[0] + 0.0196078431372549*u[3] + 0.00490196078431373*u[2] - 0.00980392156862745*u[5] - 0.00245098039215686*u[4] - 0.849044513514155*y[3] - 0.212261128378539*y[2] + 0.849044513514155*y[5] + 0.212261128378539*y[4]
    g_ini[237] = -y[237] - 0.00245098039215686*u[1] + 0.00980392156862745*u[0] + 0.00490196078431373*u[3] - 0.0196078431372549*u[2] - 0.00245098039215686*u[5] + 0.00980392156862745*u[4] - 0.212261128378539*y[3] + 0.849044513514155*y[2] + 0.212261128378539*y[5] - 0.849044513514155*y[4]
    g_ini[238] = -y[238] - 0.00980392156862745*u[1] - 0.00245098039215686*u[0] - 0.00980392156862745*u[3] - 0.00245098039215686*u[2] + 0.0196078431372549*u[5] + 0.00490196078431373*u[4] + 0.849044513514155*y[1] + 0.212261128378539*y[0] - 0.849044513514155*y[5] - 0.212261128378539*y[4]
    g_ini[239] = -y[239] - 0.00245098039215686*u[1] + 0.00980392156862745*u[0] - 0.00245098039215686*u[3] + 0.00980392156862745*u[2] + 0.00490196078431373*u[5] - 0.0196078431372549*u[4] + 0.212261128378539*y[1] - 0.849044513514155*y[0] - 0.212261128378539*y[5] + 0.849044513514155*y[4]
    g_ini[240] = -y[240] + 54.0657727682604*y[1] + 105.57176931318*y[0] - 10.2713736253513*y[3] - 39.6392229058202*y[2] - 23.284964480954*y[5] - 24.9575997948692*y[4] - 10.2713736253513*y[7] - 39.6392229058202*y[6] - 54.0657727682604*y[69] - 105.57176931318*y[68] + 10.2713736253513*y[71] + 39.6392229058202*y[70] + 23.284964480954*y[73] + 24.9575997948692*y[72] + 10.2713736253513*y[75] + 39.6392229058202*y[74]
    g_ini[241] = -y[241] + 105.57176931318*y[1] - 54.0657727682604*y[0] - 39.6392229058202*y[3] + 10.2713736253513*y[2] - 24.9575997948692*y[5] + 23.284964480954*y[4] - 39.6392229058202*y[7] + 10.2713736253513*y[6] - 105.57176931318*y[69] + 54.0657727682604*y[68] + 39.6392229058202*y[71] - 10.2713736253513*y[70] + 24.9575997948692*y[73] - 23.284964480954*y[72] + 39.6392229058202*y[75] - 10.2713736253513*y[74]
    g_ini[242] = -y[242] - 10.2713736253513*y[1] - 39.6392229058202*y[0] + 54.0657727682604*y[3] + 105.57176931318*y[2] - 10.2713736253513*y[5] - 39.6392229058201*y[4] - 23.284964480954*y[7] - 24.9575997948692*y[6] + 10.2713736253513*y[69] + 39.6392229058202*y[68] - 54.0657727682604*y[71] - 105.57176931318*y[70] + 10.2713736253513*y[73] + 39.6392229058201*y[72] + 23.284964480954*y[75] + 24.9575997948692*y[74]
    g_ini[243] = -y[243] - 39.6392229058202*y[1] + 10.2713736253513*y[0] + 105.57176931318*y[3] - 54.0657727682604*y[2] - 39.6392229058201*y[5] + 10.2713736253513*y[4] - 24.9575997948692*y[7] + 23.284964480954*y[6] + 39.6392229058202*y[69] - 10.2713736253513*y[68] - 105.57176931318*y[71] + 54.0657727682604*y[70] + 39.6392229058201*y[73] - 10.2713736253513*y[72] + 24.9575997948692*y[75] - 23.284964480954*y[74]
    g_ini[244] = -y[244] - 23.284964480954*y[1] - 24.9575997948692*y[0] - 10.2713736253513*y[3] - 39.6392229058202*y[2] + 54.0657727682604*y[5] + 105.57176931318*y[4] - 10.2713736253514*y[7] - 39.6392229058201*y[6] + 23.284964480954*y[69] + 24.9575997948692*y[68] + 10.2713736253513*y[71] + 39.6392229058202*y[70] - 54.0657727682604*y[73] - 105.57176931318*y[72] + 10.2713736253514*y[75] + 39.6392229058201*y[74]
    g_ini[245] = -y[245] - 24.9575997948692*y[1] + 23.284964480954*y[0] - 39.6392229058202*y[3] + 10.2713736253513*y[2] + 105.57176931318*y[5] - 54.0657727682604*y[4] - 39.6392229058201*y[7] + 10.2713736253514*y[6] + 24.9575997948692*y[69] - 23.284964480954*y[68] + 39.6392229058202*y[71] - 10.2713736253513*y[70] - 105.57176931318*y[73] + 54.0657727682604*y[72] + 39.6392229058201*y[75] - 10.2713736253514*y[74]
    g_ini[246] = y[240] + y[242] + y[244] - y[246]
    g_ini[247] = y[241] + y[243] + y[245] - y[247]
    g_ini[248] = -y[248] + 67.7048070412999*u[6] - 67.7048070412999*y[166]
    g_ini[249] = -y[249] + 67.7048070412999*u[7] - 67.7048070412999*y[167]
    g_ini[250] = -y[250] + 67.7048070412999*u[8] - 67.7048070412999*y[168]
    g_ini[251] = -y[251] + 67.7048070412999*u[9] - 67.7048070412999*y[169]
    g_ini[252] = -y[252] + 67.7048070412999*u[10] - 67.7048070412999*y[170]
    g_ini[253] = -y[253] + 67.7048070412999*u[11] - 67.7048070412999*y[171]
    g_ini[254] = y[248] + y[250] + y[252] - y[254]
    g_ini[255] = y[249] + y[251] + y[253] - y[255]
    g_ini[256] = -y[256] + 135.4096140826*y[166] - 135.4096140826*y[174]
    g_ini[257] = -y[257] + 135.4096140826*y[167] - 135.4096140826*y[175]
    g_ini[258] = -y[258] + 135.4096140826*y[168] - 135.4096140826*y[176]
    g_ini[259] = -y[259] + 135.4096140826*y[169] - 135.4096140826*y[177]
    g_ini[260] = -y[260] + 135.4096140826*y[170] - 135.4096140826*y[178]
    g_ini[261] = -y[261] + 135.4096140826*y[171] - 135.4096140826*y[179]
    g_ini[262] = y[256] + y[258] + y[260] - y[262]
    g_ini[263] = y[257] + y[259] + y[261] - y[263]
    g_ini[264] = -y[264] + 67.7048070412999*y[174] - 67.7048070412999*y[182]
    g_ini[265] = -y[265] + 67.7048070412999*y[175] - 67.7048070412999*y[183]
    g_ini[266] = -y[266] + 67.7048070412999*y[176] - 67.7048070412999*y[184]
    g_ini[267] = -y[267] + 67.7048070412999*y[177] - 67.7048070412999*y[185]
    g_ini[268] = -y[268] + 67.7048070412999*y[178] - 67.7048070412999*y[186]
    g_ini[269] = -y[269] + 67.7048070412999*y[179] - 67.7048070412999*y[187]
    g_ini[270] = y[264] + y[266] + y[268] - y[270]
    g_ini[271] = y[265] + y[267] + y[269] - y[271]
    g_ini[272] = -y[272] + 45.1365380275333*y[182] - 45.1365380275333*y[190]
    g_ini[273] = -y[273] + 45.1365380275333*y[183] - 45.1365380275333*y[191]
    g_ini[274] = -y[274] + 45.1365380275333*y[184] - 45.1365380275333*y[192]
    g_ini[275] = -y[275] + 45.1365380275333*y[185] - 45.1365380275333*y[193]
    g_ini[276] = -y[276] + 45.1365380275333*y[186] - 45.1365380275333*y[194]
    g_ini[277] = -y[277] + 45.1365380275333*y[187] - 45.1365380275333*y[195]
    g_ini[278] = y[272] + y[274] + y[276] - y[278]
    g_ini[279] = y[273] + y[275] + y[277] - y[279]
    g_ini[280] = -y[280] - 157.977883096366*y[198] + 157.977883096366*y[190]
    g_ini[281] = -y[281] - 157.977883096366*y[199] + 157.977883096366*y[191]
    g_ini[282] = -y[282] - 157.977883096366*y[200] + 157.977883096366*y[192]
    g_ini[283] = -y[283] - 157.977883096366*y[201] + 157.977883096366*y[193]
    g_ini[284] = -y[284] - 157.977883096366*y[202] + 157.977883096366*y[194]
    g_ini[285] = -y[285] - 157.977883096366*y[203] + 157.977883096366*y[195]
    g_ini[286] = y[280] + y[282] + y[284] - y[286]
    g_ini[287] = y[281] + y[283] + y[285] - y[287]
    g_ini[288] = -y[288] - 157.977883096366*y[52] + 157.977883096366*y[166]
    g_ini[289] = -y[289] - 157.977883096366*y[53] + 157.977883096366*y[167]
    g_ini[290] = -y[290] - 157.977883096366*y[206] + 157.977883096366*y[168]
    g_ini[291] = -y[291] - 157.977883096366*y[207] + 157.977883096366*y[169]
    g_ini[292] = -y[292] - 157.977883096366*y[208] + 157.977883096366*y[170]
    g_ini[293] = -y[293] - 157.977883096366*y[209] + 157.977883096366*y[171]
    g_ini[294] = y[288] + y[290] + y[292] - y[294]
    g_ini[295] = y[289] + y[291] + y[293] - y[295]
    g_ini[296] = -y[296] - 157.977883096366*y[56] + 157.977883096366*y[182]
    g_ini[297] = -y[297] - 157.977883096366*y[57] + 157.977883096366*y[183]
    g_ini[298] = -y[298] - 157.977883096366*y[210] + 157.977883096366*y[184]
    g_ini[299] = -y[299] - 157.977883096366*y[211] + 157.977883096366*y[185]
    g_ini[300] = -y[300] - 157.977883096366*y[212] + 157.977883096366*y[186]
    g_ini[301] = -y[301] - 157.977883096366*y[213] + 157.977883096366*y[187]
    g_ini[302] = y[296] + y[298] + y[300] - y[302]
    g_ini[303] = y[297] + y[299] + y[301] - y[303]
    g_ini[304] = -y[304] - 157.977883096366*y[60] + 157.977883096366*y[190]
    g_ini[305] = -y[305] - 157.977883096366*y[61] + 157.977883096366*y[191]
    g_ini[306] = -y[306] - 157.977883096366*y[214] + 157.977883096366*y[192]
    g_ini[307] = -y[307] - 157.977883096366*y[215] + 157.977883096366*y[193]
    g_ini[308] = -y[308] - 157.977883096366*y[216] + 157.977883096366*y[194]
    g_ini[309] = -y[309] - 157.977883096366*y[217] + 157.977883096366*y[195]
    g_ini[310] = y[304] + y[306] + y[308] - y[310]
    g_ini[311] = y[305] + y[307] + y[309] - y[311]
    g_ini[312] = -y[312] + 157.977883096366*y[198] - 157.977883096366*y[64]
    g_ini[313] = -y[313] + 157.977883096366*y[199] - 157.977883096366*y[65]
    g_ini[314] = -y[314] + 157.977883096366*y[200] - 157.977883096366*y[218]
    g_ini[315] = -y[315] + 157.977883096366*y[201] - 157.977883096366*y[219]
    g_ini[316] = -y[316] + 157.977883096366*y[202] - 157.977883096366*y[220]
    g_ini[317] = -y[317] + 157.977883096366*y[203] - 157.977883096366*y[221]
    g_ini[318] = y[312] + y[314] + y[316] - y[318]
    g_ini[319] = y[313] + y[315] + y[317] - y[319]
    g_ini[320] = -y[320] - 45.1365380275333*y[222] + 45.1365380275333*y[174]
    g_ini[321] = -y[321] - 45.1365380275333*y[223] + 45.1365380275333*y[175]
    g_ini[322] = -y[322] - 45.1365380275333*y[224] + 45.1365380275333*y[176]
    g_ini[323] = -y[323] - 45.1365380275333*y[225] + 45.1365380275333*y[177]
    g_ini[324] = -y[324] - 45.1365380275333*y[226] + 45.1365380275333*y[178]
    g_ini[325] = -y[325] - 45.1365380275333*y[227] + 45.1365380275333*y[179]
    g_ini[326] = y[320] + y[322] + y[324] - y[326]
    g_ini[327] = y[321] + y[323] + y[325] - y[327]
    g_ini[328] = -y[328] + 135.4096140826*y[222] - 135.4096140826*y[48]
    g_ini[329] = -y[329] + 135.4096140826*y[223] - 135.4096140826*y[49]
    g_ini[330] = -y[330] + 135.4096140826*y[224] - 135.4096140826*y[230]
    g_ini[331] = -y[331] + 135.4096140826*y[225] - 135.4096140826*y[231]
    g_ini[332] = -y[332] + 135.4096140826*y[226] - 135.4096140826*y[232]
    g_ini[333] = -y[333] + 135.4096140826*y[227] - 135.4096140826*y[233]
    g_ini[334] = y[328] + y[330] + y[332] - y[334]
    g_ini[335] = y[329] + y[331] + y[333] - y[335]
    g_ini[336] = y[337]*y[1] - y[337]*y[7] + y[336]*y[0] - y[336]*y[6] - u[186]
    g_ini[337] = y[339]*y[3] - y[339]*y[7] + y[338]*y[2] - y[338]*y[6] - u[188]
    g_ini[338] = y[341]*y[5] - y[341]*y[7] + y[340]*y[4] - y[340]*y[6] - u[190]
    g_ini[339] = -y[337]*y[0] + y[337]*y[6] + y[336]*y[1] - y[336]*y[7] - u[187]
    g_ini[340] = -y[339]*y[2] + y[339]*y[6] + y[338]*y[3] - y[338]*y[7] - u[189]
    g_ini[341] = -y[341]*y[4] + y[341]*y[6] + y[340]*y[5] - y[340]*y[7] - u[191]
    g_ini[342] = y[336] + y[338] + y[340] + y[342]
    g_ini[343] = y[337] + y[339] + y[341] + y[343]
    g_ini[344] = y[345]*y[9] - y[345]*y[15] + y[344]*y[8] - y[344]*y[14] - u[192]
    g_ini[345] = y[347]*y[11] - y[347]*y[15] + y[346]*y[10] - y[346]*y[14] - u[194]
    g_ini[346] = y[349]*y[13] - y[349]*y[15] + y[348]*y[12] - y[348]*y[14] - u[196]
    g_ini[347] = -y[345]*y[8] + y[345]*y[14] + y[344]*y[9] - y[344]*y[15] - u[193]
    g_ini[348] = -y[347]*y[10] + y[347]*y[14] + y[346]*y[11] - y[346]*y[15] - u[195]
    g_ini[349] = -y[349]*y[12] + y[349]*y[14] + y[348]*y[13] - y[348]*y[15] - u[197]
    g_ini[350] = y[344] + y[346] + y[348] + y[350]
    g_ini[351] = y[345] + y[347] + y[349] + y[351]
    g_ini[352] = y[353]*y[17] - y[353]*y[23] + y[352]*y[16] - y[352]*y[22] - u[198]
    g_ini[353] = y[355]*y[19] - y[355]*y[23] + y[354]*y[18] - y[354]*y[22] - u[200]
    g_ini[354] = y[357]*y[21] - y[357]*y[23] + y[356]*y[20] - y[356]*y[22] - u[202]
    g_ini[355] = -y[353]*y[16] + y[353]*y[22] + y[352]*y[17] - y[352]*y[23] - u[199]
    g_ini[356] = -y[355]*y[18] + y[355]*y[22] + y[354]*y[19] - y[354]*y[23] - u[201]
    g_ini[357] = -y[357]*y[20] + y[357]*y[22] + y[356]*y[21] - y[356]*y[23] - u[203]
    g_ini[358] = y[352] + y[354] + y[356] + y[358]
    g_ini[359] = y[353] + y[355] + y[357] + y[359]
    g_ini[360] = y[361]*y[25] - y[361]*y[31] + y[360]*y[24] - y[360]*y[30] - u[204]
    g_ini[361] = y[363]*y[27] - y[363]*y[31] + y[362]*y[26] - y[362]*y[30] - u[206]
    g_ini[362] = y[365]*y[29] - y[365]*y[31] + y[364]*y[28] - y[364]*y[30] - u[208]
    g_ini[363] = -y[361]*y[24] + y[361]*y[30] + y[360]*y[25] - y[360]*y[31] - u[205]
    g_ini[364] = -y[363]*y[26] + y[363]*y[30] + y[362]*y[27] - y[362]*y[31] - u[207]
    g_ini[365] = -y[365]*y[28] + y[365]*y[30] + y[364]*y[29] - y[364]*y[31] - u[209]
    g_ini[366] = y[360] + y[362] + y[364] + y[366]
    g_ini[367] = y[361] + y[363] + y[365] + y[367]
    g_ini[368] = y[369]*y[33] - y[369]*y[39] + y[368]*y[32] - y[368]*y[38] - u[210]
    g_ini[369] = y[371]*y[35] - y[371]*y[39] + y[370]*y[34] - y[370]*y[38] - u[212]
    g_ini[370] = y[373]*y[37] - y[373]*y[39] + y[372]*y[36] - y[372]*y[38] - u[214]
    g_ini[371] = -y[369]*y[32] + y[369]*y[38] + y[368]*y[33] - y[368]*y[39] - u[211]
    g_ini[372] = -y[371]*y[34] + y[371]*y[38] + y[370]*y[35] - y[370]*y[39] - u[213]
    g_ini[373] = -y[373]*y[36] + y[373]*y[38] + y[372]*y[37] - y[372]*y[39] - u[215]
    g_ini[374] = y[368] + y[370] + y[372] + y[374]
    g_ini[375] = y[369] + y[371] + y[373] + y[375]
    g_ini[376] = y[377]*y[41] - y[377]*y[47] + y[376]*y[40] - y[376]*y[46] - u[216]
    g_ini[377] = y[379]*y[43] - y[379]*y[47] + y[378]*y[42] - y[378]*y[46] - u[218]
    g_ini[378] = y[381]*y[45] - y[381]*y[47] + y[380]*y[44] - y[380]*y[46] - u[220]
    g_ini[379] = -y[377]*y[40] + y[377]*y[46] + y[376]*y[41] - y[376]*y[47] - u[217]
    g_ini[380] = -y[379]*y[42] + y[379]*y[46] + y[378]*y[43] - y[378]*y[47] - u[219]
    g_ini[381] = -y[381]*y[44] + y[381]*y[46] + y[380]*y[45] - y[380]*y[47] - u[221]
    g_ini[382] = y[376] + y[378] + y[380] + y[382]
    g_ini[383] = y[377] + y[379] + y[381] + y[383]
    g_ini[384] = 1.0*y[385]*y[49] - 1.0*y[385]*y[51] + y[384]*y[48] - y[384]*y[50] - u[222]
    g_ini[385] = -1.0*y[385]*y[48] + 1.0*y[385]*y[50] + 1.0*y[384]*y[49] - 1.0*y[384]*y[51] - u[223]
    g_ini[386] = y[384] + y[386]
    g_ini[387] = 1.0*y[385] + 1.0*y[387]
    g_ini[388] = 1.0*y[389]*y[53] - 1.0*y[389]*y[55] + y[388]*y[52] - y[388]*y[54] - u[224]
    g_ini[389] = -1.0*y[389]*y[52] + 1.0*y[389]*y[54] + 1.0*y[388]*y[53] - 1.0*y[388]*y[55] - u[225]
    g_ini[390] = y[388] + y[390]
    g_ini[391] = 1.0*y[389] + 1.0*y[391]
    g_ini[392] = 1.0*y[393]*y[57] - 1.0*y[393]*y[59] + y[392]*y[56] - y[392]*y[58] - u[226]
    g_ini[393] = -1.0*y[393]*y[56] + 1.0*y[393]*y[58] + 1.0*y[392]*y[57] - 1.0*y[392]*y[59] - u[227]
    g_ini[394] = y[392] + y[394]
    g_ini[395] = 1.0*y[393] + 1.0*y[395]
    g_ini[396] = 1.0*y[397]*y[61] - 1.0*y[397]*y[63] + y[396]*y[60] - y[396]*y[62] - u[228]
    g_ini[397] = -1.0*y[397]*y[60] + 1.0*y[397]*y[62] + 1.0*y[396]*y[61] - 1.0*y[396]*y[63] - u[229]
    g_ini[398] = y[396] + y[398]
    g_ini[399] = 1.0*y[397] + 1.0*y[399]
    g_ini[400] = 1.0*y[401]*y[65] - 1.0*y[401]*y[67] + y[400]*y[64] - y[400]*y[66] - u[230]
    g_ini[401] = -1.0*y[401]*y[64] + 1.0*y[401]*y[66] + 1.0*y[400]*y[65] - 1.0*y[400]*y[67] - u[231]
    g_ini[402] = y[400] + y[402]
    g_ini[403] = 1.0*y[401] + 1.0*y[403]
    g_ini[404] = 1.0*y[405]*y[1] - 1.0*y[405]*y[7] + y[404]*y[0] - y[404]*y[6] - y[410]/3
    g_ini[405] = -1.0*y[405]*y[0] + 1.0*y[405]*y[6] + 1.0*y[404]*y[1] - 1.0*y[404]*y[7] - u[233]/3
    g_ini[406] = 1.0*y[407]*y[3] - 1.0*y[407]*y[7] + y[406]*y[2] - y[406]*y[6] - y[410]/3
    g_ini[407] = -1.0*y[407]*y[2] + 1.0*y[407]*y[6] + 1.0*y[406]*y[3] - 1.0*y[406]*y[7] - u[233]/3
    g_ini[408] = 1.0*y[409]*y[5] - 1.0*y[409]*y[7] + y[408]*y[4] - y[408]*y[6] - y[410]/3
    g_ini[409] = -1.0*y[409]*y[4] + 1.0*y[409]*y[6] + 1.0*y[408]*y[5] - 1.0*y[408]*y[7] - u[233]/3
    g_ini[410] = y[411] + y[410] + Piecewise(np.array([(-y[412], y[411] < 0), (y[412], True)]))
    g_ini[411] = y[248]*u[6] + y[254]*y[164] - y[411]
    g_ini[412] = -p[0] - p[1]*sqrt(y[405]**2 + y[404]**2 + 0.1) - p[2]*(y[405]**2 + y[404]**2 + 0.1) + y[412]
    g_ini[413] = -p[6]*u[234] + 1.0*y[414]*y[133] - 1.0*y[414]*y[139] + y[413]*y[132] - y[413]*y[138]
    g_ini[414] = -p[6]*u[235] - 1.0*y[414]*y[132] + 1.0*y[414]*y[138] + 1.0*y[413]*y[133] - 1.0*y[413]*y[139]
    g_ini[415] = -p[7]*u[234] + 1.0*y[416]*y[135] - 1.0*y[416]*y[139] + y[415]*y[134] - y[415]*y[138]
    g_ini[416] = -p[7]*u[235] - 1.0*y[416]*y[134] + 1.0*y[416]*y[138] + 1.0*y[415]*y[135] - 1.0*y[415]*y[139]
    g_ini[417] = -p[8]*u[234] + 1.0*y[418]*y[137] - 1.0*y[418]*y[139] + y[417]*y[136] - y[417]*y[138]
    g_ini[418] = -p[8]*u[235] - 1.0*y[418]*y[136] + 1.0*y[418]*y[138] + 1.0*y[417]*y[137] - 1.0*y[417]*y[139]
    g_ini[419] = y[419] + y[421]/(y[198] - y[204] + 1.0e-8)
    g_ini[420] = y[420] + y[421]/(-y[198] + y[204] + 1.0e-8)
    g_ini[421] = y[421] - u[234] - Piecewise(np.array([(-y[422], y[421] < 0), (y[422], True)]))
    g_ini[422] = -p[3] - p[4]*sqrt(y[414]**2 + y[413]**2 + 0.1) - p[5]*(y[414]**2 + y[413]**2 + 0.1) + y[422]
    g_ini[423] = -p[12]*u[236] + 1.0*y[424]*y[157] - 1.0*y[424]*y[163] + y[423]*y[156] - y[423]*y[162]
    g_ini[424] = -p[12]*u[237] - 1.0*y[424]*y[156] + 1.0*y[424]*y[162] + 1.0*y[423]*y[157] - 1.0*y[423]*y[163]
    g_ini[425] = -p[13]*u[236] + 1.0*y[426]*y[159] - 1.0*y[426]*y[163] + y[425]*y[158] - y[425]*y[162]
    g_ini[426] = -p[13]*u[237] - 1.0*y[426]*y[158] + 1.0*y[426]*y[162] + 1.0*y[425]*y[159] - 1.0*y[425]*y[163]
    g_ini[427] = -p[14]*u[236] + 1.0*y[428]*y[161] - 1.0*y[428]*y[163] + y[427]*y[160] - y[427]*y[162]
    g_ini[428] = -p[14]*u[237] - 1.0*y[428]*y[160] + 1.0*y[428]*y[162] + 1.0*y[427]*y[161] - 1.0*y[427]*y[163]
    g_ini[429] = y[429] + y[431]/(y[222] - y[228] + 1.0e-8)
    g_ini[430] = y[430] + y[431]/(-y[222] + y[228] + 1.0e-8)
    g_ini[431] = y[431] - u[236] - Piecewise(np.array([(-y[432], y[431] < 0), (y[432], True)]))
    g_ini[432] = -p[9] - p[10]*sqrt(y[424]**2 + y[423]**2 + 0.1) - p[11]*(y[424]**2 + y[423]**2 + 0.1) + y[432]





@numba.njit(cache=True)
def g_run_eval(g_run,x,y,u,p,xyup = 1):


    g_run[0] = y[336] + y[404] + 0.849044513514155*u[1] + 0.212261128378539*u[0] - 0.849044513514155*u[5] - 0.212261128378539*u[4] - 127.595184532966*y[1] - 123.954122254357*y[0] + 10.2713736253513*y[3] + 39.6392229058202*y[2] + 23.284964480954*y[5] + 24.9575997948692*y[4] + 83.8007853900572*y[7] + 58.0215758469966*y[6] + 54.0657727682604*y[69] + 105.57176931318*y[68] - 10.2713736253513*y[71] - 39.6392229058202*y[70] - 23.284964480954*y[73] - 24.9575997948692*y[72] - 10.2713736253513*y[75] - 39.6392229058202*y[74]
    g_run[1] = y[337] + y[405] + 0.212261128378539*u[1] - 0.849044513514155*u[0] - 0.212261128378539*u[5] + 0.849044513514155*u[4] - 123.954122254357*y[1] + 127.595184532966*y[0] + 39.6392229058202*y[3] - 10.2713736253513*y[2] + 24.9575997948692*y[5] - 23.284964480954*y[4] + 58.0215758469966*y[7] - 83.8007853900572*y[6] + 105.57176931318*y[69] - 54.0657727682604*y[68] - 39.6392229058202*y[71] + 10.2713736253513*y[70] - 24.9575997948692*y[73] + 23.284964480954*y[72] - 39.6392229058202*y[75] + 10.2713736253513*y[74]
    g_run[2] = y[338] + y[406] - 0.849044513514155*u[1] - 0.212261128378539*u[0] + 0.849044513514155*u[3] + 0.212261128378539*u[2] + 10.2713736253513*y[1] + 39.6392229058202*y[0] - 127.595184532966*y[3] - 123.954122254357*y[2] + 10.2713736253513*y[5] + 39.6392229058201*y[4] + 96.8143762456598*y[7] + 43.3399527360457*y[6] - 10.2713736253513*y[69] - 39.6392229058202*y[68] + 54.0657727682604*y[71] + 105.57176931318*y[70] - 10.2713736253513*y[73] - 39.6392229058201*y[72] - 23.284964480954*y[75] - 24.9575997948692*y[74]
    g_run[3] = y[339] + y[407] - 0.212261128378539*u[1] + 0.849044513514155*u[0] + 0.212261128378539*u[3] - 0.849044513514155*u[2] + 39.6392229058202*y[1] - 10.2713736253513*y[0] - 123.954122254357*y[3] + 127.595184532966*y[2] + 39.6392229058201*y[5] - 10.2713736253513*y[4] + 43.3399527360457*y[7] - 96.8143762456598*y[6] - 39.6392229058202*y[69] + 10.2713736253513*y[68] + 105.57176931318*y[71] - 54.0657727682604*y[70] - 39.6392229058201*y[73] + 10.2713736253513*y[72] - 24.9575997948692*y[75] + 23.284964480954*y[74]
    g_run[4] = y[340] + y[408] - 0.849044513514155*u[3] - 0.212261128378539*u[2] + 0.849044513514155*u[5] + 0.212261128378539*u[4] + 23.284964480954*y[1] + 24.9575997948692*y[0] + 10.2713736253513*y[3] + 39.6392229058202*y[2] - 127.595184532966*y[5] - 123.954122254357*y[4] + 83.8007853900572*y[7] + 58.0215758469966*y[6] - 23.284964480954*y[69] - 24.9575997948692*y[68] - 10.2713736253513*y[71] - 39.6392229058202*y[70] + 54.0657727682604*y[73] + 105.57176931318*y[72] - 10.2713736253514*y[75] - 39.6392229058201*y[74]
    g_run[5] = y[341] + y[409] - 0.212261128378539*u[3] + 0.849044513514155*u[2] + 0.212261128378539*u[5] - 0.849044513514155*u[4] + 24.9575997948692*y[1] - 23.284964480954*y[0] + 39.6392229058202*y[3] - 10.2713736253513*y[2] - 123.954122254357*y[5] + 127.595184532966*y[4] + 58.0215758469966*y[7] - 83.8007853900572*y[6] - 24.9575997948692*y[69] + 23.284964480954*y[68] - 39.6392229058202*y[71] + 10.2713736253513*y[70] + 105.57176931318*y[73] - 54.0657727682604*y[72] - 39.6392229058201*y[75] + 10.2713736253514*y[74]
    g_run[6] = 83.8007853900572*y[1] + 58.0215758469966*y[0] + 96.8143762456598*y[3] + 43.3399527360457*y[2] + 83.8007853900572*y[5] + 58.0215758469966*y[4] - 274.654008062378*y[7] - 161.052161470043*y[6] - 10.2713736253513*y[69] - 39.6392229058202*y[68] - 23.284964480954*y[71] - 24.9575997948692*y[70] - 10.2713736253513*y[73] - 39.6392229058202*y[72] + 54.0657727682604*y[75] + 105.57176931318*y[74]
    g_run[7] = 58.0215758469966*y[1] - 83.8007853900572*y[0] + 43.3399527360457*y[3] - 96.8143762456598*y[2] + 58.0215758469966*y[5] - 83.8007853900572*y[4] - 161.052161470043*y[7] + 274.654008062378*y[6] - 39.6392229058202*y[69] + 10.2713736253513*y[68] - 24.9575997948692*y[71] + 23.284964480954*y[70] - 39.6392229058202*y[73] + 10.2713736253513*y[72] + 105.57176931318*y[75] - 54.0657727682604*y[74]
    g_run[8] = y[344] - 4.84676915585801*y[9] - 26.5300693004806*y[8] - 1.58482814504483*y[11] + 7.8946133751477*y[10] - 0.67991845328531*y[13] + 7.72144347466701*y[12] - 1.58482814504483*y[15] + 7.89461337514771*y[14] + 4.84676915585801*y[77] + 26.5300693004806*y[76] + 1.58482814504483*y[79] - 7.8946133751477*y[78] + 0.67991845328531*y[81] - 7.72144347466701*y[80] + 1.58482814504483*y[83] - 7.89461337514771*y[82]
    g_run[9] = y[345] - 26.5300693004806*y[9] + 4.84676915585801*y[8] + 7.8946133751477*y[11] + 1.58482814504483*y[10] + 7.72144347466701*y[13] + 0.67991845328531*y[12] + 7.89461337514771*y[15] + 1.58482814504483*y[14] + 26.5300693004806*y[77] - 4.84676915585801*y[76] - 7.8946133751477*y[79] - 1.58482814504483*y[78] - 7.72144347466701*y[81] - 0.67991845328531*y[80] - 7.89461337514771*y[83] - 1.58482814504483*y[82]
    g_run[10] = y[346] - 1.58482814504483*y[9] + 7.89461337514771*y[8] - 4.84676915585801*y[11] - 26.5300693004806*y[10] - 1.58482814504483*y[13] + 7.89461337514771*y[12] - 0.679918453285308*y[15] + 7.72144347466701*y[14] + 1.58482814504483*y[77] - 7.89461337514771*y[76] + 4.84676915585801*y[79] + 26.5300693004806*y[78] + 1.58482814504483*y[81] - 7.89461337514771*y[80] + 0.679918453285308*y[83] - 7.72144347466701*y[82]
    g_run[11] = y[347] + 7.89461337514771*y[9] + 1.58482814504483*y[8] - 26.5300693004806*y[11] + 4.84676915585801*y[10] + 7.89461337514771*y[13] + 1.58482814504483*y[12] + 7.72144347466701*y[15] + 0.679918453285308*y[14] - 7.89461337514771*y[77] - 1.58482814504483*y[76] + 26.5300693004806*y[79] - 4.84676915585801*y[78] - 7.89461337514771*y[81] - 1.58482814504483*y[80] - 7.72144347466701*y[83] - 0.679918453285308*y[82]
    g_run[12] = y[348] - 0.67991845328531*y[9] + 7.72144347466701*y[8] - 1.58482814504483*y[11] + 7.8946133751477*y[10] - 4.84676915585801*y[13] - 26.5300693004806*y[12] - 1.58482814504483*y[15] + 7.89461337514771*y[14] + 0.67991845328531*y[77] - 7.72144347466701*y[76] + 1.58482814504483*y[79] - 7.8946133751477*y[78] + 4.84676915585801*y[81] + 26.5300693004806*y[80] + 1.58482814504483*y[83] - 7.89461337514771*y[82]
    g_run[13] = y[349] + 7.72144347466701*y[9] + 0.67991845328531*y[8] + 7.8946133751477*y[11] + 1.58482814504483*y[10] - 26.5300693004806*y[13] + 4.84676915585801*y[12] + 7.89461337514771*y[15] + 1.58482814504483*y[14] - 7.72144347466701*y[77] - 0.67991845328531*y[76] - 7.8946133751477*y[79] - 1.58482814504483*y[78] + 26.5300693004806*y[81] - 4.84676915585801*y[80] - 7.89461337514771*y[83] - 1.58482814504483*y[82]
    g_run[14] = -1.58482814504483*y[9] + 7.89461337514771*y[8] - 0.679918453285308*y[11] + 7.72144347466701*y[10] - 1.58482814504483*y[13] + 7.89461337514771*y[12] - 4.84676915585801*y[15] - 26.5550693004806*y[14] + 1.58482814504483*y[77] - 7.89461337514771*y[76] + 0.679918453285308*y[79] - 7.72144347466701*y[78] + 1.58482814504483*y[81] - 7.89461337514771*y[80] + 4.84676915585801*y[83] + 26.5300693004806*y[82]
    g_run[15] = 7.89461337514771*y[9] + 1.58482814504483*y[8] + 7.72144347466701*y[11] + 0.679918453285308*y[10] + 7.89461337514771*y[13] + 1.58482814504483*y[12] - 26.5550693004806*y[15] + 4.84676915585801*y[14] - 7.89461337514771*y[77] - 1.58482814504483*y[76] - 7.72144347466701*y[79] - 0.679918453285308*y[78] - 7.89461337514771*y[81] - 1.58482814504483*y[80] + 26.5300693004806*y[83] - 4.84676915585801*y[82]
    g_run[16] = y[352] + 4.84676915585801*y[157] + 26.5300693004806*y[156] + 1.58482814504483*y[159] - 7.8946133751477*y[158] + 0.67991845328531*y[161] - 7.72144347466701*y[160] + 1.58482814504483*y[163] - 7.89461337514771*y[162] - 4.84676915585801*y[17] - 26.5300693004806*y[16] - 1.58482814504483*y[19] + 7.8946133751477*y[18] - 0.67991845328531*y[21] + 7.72144347466701*y[20] - 1.58482814504483*y[23] + 7.89461337514771*y[22]
    g_run[17] = y[353] + 26.5300693004806*y[157] - 4.84676915585801*y[156] - 7.8946133751477*y[159] - 1.58482814504483*y[158] - 7.72144347466701*y[161] - 0.67991845328531*y[160] - 7.89461337514771*y[163] - 1.58482814504483*y[162] - 26.5300693004806*y[17] + 4.84676915585801*y[16] + 7.8946133751477*y[19] + 1.58482814504483*y[18] + 7.72144347466701*y[21] + 0.67991845328531*y[20] + 7.89461337514771*y[23] + 1.58482814504483*y[22]
    g_run[18] = y[354] + 1.58482814504483*y[157] - 7.89461337514771*y[156] + 4.84676915585801*y[159] + 26.5300693004806*y[158] + 1.58482814504483*y[161] - 7.89461337514771*y[160] + 0.679918453285308*y[163] - 7.72144347466701*y[162] - 1.58482814504483*y[17] + 7.89461337514771*y[16] - 4.84676915585801*y[19] - 26.5300693004806*y[18] - 1.58482814504483*y[21] + 7.89461337514771*y[20] - 0.679918453285308*y[23] + 7.72144347466701*y[22]
    g_run[19] = y[355] - 7.89461337514771*y[157] - 1.58482814504483*y[156] + 26.5300693004806*y[159] - 4.84676915585801*y[158] - 7.89461337514771*y[161] - 1.58482814504483*y[160] - 7.72144347466701*y[163] - 0.679918453285308*y[162] + 7.89461337514771*y[17] + 1.58482814504483*y[16] - 26.5300693004806*y[19] + 4.84676915585801*y[18] + 7.89461337514771*y[21] + 1.58482814504483*y[20] + 7.72144347466701*y[23] + 0.679918453285308*y[22]
    g_run[20] = y[356] + 0.67991845328531*y[157] - 7.72144347466701*y[156] + 1.58482814504483*y[159] - 7.8946133751477*y[158] + 4.84676915585801*y[161] + 26.5300693004806*y[160] + 1.58482814504483*y[163] - 7.89461337514771*y[162] - 0.67991845328531*y[17] + 7.72144347466701*y[16] - 1.58482814504483*y[19] + 7.8946133751477*y[18] - 4.84676915585801*y[21] - 26.5300693004806*y[20] - 1.58482814504483*y[23] + 7.89461337514771*y[22]
    g_run[21] = y[357] - 7.72144347466701*y[157] - 0.67991845328531*y[156] - 7.8946133751477*y[159] - 1.58482814504483*y[158] + 26.5300693004806*y[161] - 4.84676915585801*y[160] - 7.89461337514771*y[163] - 1.58482814504483*y[162] + 7.72144347466701*y[17] + 0.67991845328531*y[16] + 7.8946133751477*y[19] + 1.58482814504483*y[18] - 26.5300693004806*y[21] + 4.84676915585801*y[20] + 7.89461337514771*y[23] + 1.58482814504483*y[22]
    g_run[22] = 1.58482814504483*y[157] - 7.89461337514771*y[156] + 0.679918453285308*y[159] - 7.72144347466701*y[158] + 1.58482814504483*y[161] - 7.89461337514771*y[160] + 4.84676915585801*y[163] + 26.5300693004806*y[162] - 1.58482814504483*y[17] + 7.89461337514771*y[16] - 0.679918453285308*y[19] + 7.72144347466701*y[18] - 1.58482814504483*y[21] + 7.89461337514771*y[20] - 4.84676915585801*y[23] - 26.5550693004806*y[22]
    g_run[23] = -7.89461337514771*y[157] - 1.58482814504483*y[156] - 7.72144347466701*y[159] - 0.679918453285308*y[158] - 7.89461337514771*y[161] - 1.58482814504483*y[160] + 26.5300693004806*y[163] - 4.84676915585801*y[162] + 7.89461337514771*y[17] + 1.58482814504483*y[16] + 7.72144347466701*y[19] + 0.679918453285308*y[18] + 7.89461337514771*y[21] + 1.58482814504483*y[20] - 26.5550693004806*y[23] + 4.84676915585801*y[22]
    g_run[24] = y[360] - 5.65456401516768*y[25] - 30.9517475172273*y[24] - 1.84896616921897*y[27] + 9.21038227100566*y[26] - 0.793238195499529*y[29] + 9.00835072044485*y[28] - 1.84896616921897*y[31] + 9.21038227100566*y[30] + 5.65456401516768*y[101] + 30.9517475172273*y[100] + 1.84896616921897*y[103] - 9.21038227100566*y[102] + 0.793238195499529*y[105] - 9.00835072044485*y[104] + 1.84896616921897*y[107] - 9.21038227100566*y[106]
    g_run[25] = y[361] - 30.9517475172273*y[25] + 5.65456401516768*y[24] + 9.21038227100566*y[27] + 1.84896616921897*y[26] + 9.00835072044485*y[29] + 0.793238195499529*y[28] + 9.21038227100566*y[31] + 1.84896616921897*y[30] + 30.9517475172273*y[101] - 5.65456401516768*y[100] - 9.21038227100566*y[103] - 1.84896616921897*y[102] - 9.00835072044485*y[105] - 0.793238195499529*y[104] - 9.21038227100566*y[107] - 1.84896616921897*y[106]
    g_run[26] = y[362] - 1.84896616921897*y[25] + 9.21038227100566*y[24] - 5.65456401516768*y[27] - 30.9517475172273*y[26] - 1.84896616921897*y[29] + 9.21038227100566*y[28] - 0.793238195499528*y[31] + 9.00835072044485*y[30] + 1.84896616921897*y[101] - 9.21038227100566*y[100] + 5.65456401516768*y[103] + 30.9517475172273*y[102] + 1.84896616921897*y[105] - 9.21038227100566*y[104] + 0.793238195499528*y[107] - 9.00835072044485*y[106]
    g_run[27] = y[363] + 9.21038227100566*y[25] + 1.84896616921897*y[24] - 30.9517475172273*y[27] + 5.65456401516768*y[26] + 9.21038227100566*y[29] + 1.84896616921897*y[28] + 9.00835072044485*y[31] + 0.793238195499528*y[30] - 9.21038227100566*y[101] - 1.84896616921897*y[100] + 30.9517475172273*y[103] - 5.65456401516768*y[102] - 9.21038227100566*y[105] - 1.84896616921897*y[104] - 9.00835072044485*y[107] - 0.793238195499528*y[106]
    g_run[28] = y[364] - 0.793238195499527*y[25] + 9.00835072044484*y[24] - 1.84896616921897*y[27] + 9.21038227100566*y[26] - 5.65456401516768*y[29] - 30.9517475172273*y[28] - 1.84896616921897*y[31] + 9.21038227100566*y[30] + 0.793238195499527*y[101] - 9.00835072044484*y[100] + 1.84896616921897*y[103] - 9.21038227100566*y[102] + 5.65456401516768*y[105] + 30.9517475172273*y[104] + 1.84896616921897*y[107] - 9.21038227100566*y[106]
    g_run[29] = y[365] + 9.00835072044484*y[25] + 0.793238195499527*y[24] + 9.21038227100566*y[27] + 1.84896616921897*y[26] - 30.9517475172273*y[29] + 5.65456401516768*y[28] + 9.21038227100566*y[31] + 1.84896616921897*y[30] - 9.00835072044484*y[101] - 0.793238195499527*y[100] - 9.21038227100566*y[103] - 1.84896616921897*y[102] + 30.9517475172273*y[105] - 5.65456401516768*y[104] - 9.21038227100566*y[107] - 1.84896616921897*y[106]
    g_run[30] = -1.84896616921897*y[25] + 9.21038227100566*y[24] - 0.793238195499527*y[27] + 9.00835072044485*y[26] - 1.84896616921897*y[29] + 9.21038227100566*y[28] - 5.65456401516768*y[31] - 30.9767475172273*y[30] + 1.84896616921897*y[101] - 9.21038227100566*y[100] + 0.793238195499527*y[103] - 9.00835072044485*y[102] + 1.84896616921897*y[105] - 9.21038227100566*y[104] + 5.65456401516768*y[107] + 30.9517475172273*y[106]
    g_run[31] = 9.21038227100566*y[25] + 1.84896616921897*y[24] + 9.00835072044485*y[27] + 0.793238195499527*y[26] + 9.21038227100566*y[29] + 1.84896616921897*y[28] - 30.9767475172273*y[31] + 5.65456401516768*y[30] - 9.21038227100566*y[101] - 1.84896616921897*y[100] - 9.00835072044485*y[103] - 0.793238195499527*y[102] - 9.21038227100566*y[105] - 1.84896616921897*y[104] + 30.9517475172273*y[107] - 5.65456401516768*y[106]
    g_run[32] = y[368] - 5.65456401516768*y[33] - 30.9517475172273*y[32] - 1.84896616921897*y[35] + 9.21038227100566*y[34] - 0.793238195499529*y[37] + 9.00835072044485*y[36] - 1.84896616921897*y[39] + 9.21038227100566*y[38] + 5.65456401516768*y[125] + 30.9517475172273*y[124] + 1.84896616921897*y[127] - 9.21038227100566*y[126] + 0.793238195499529*y[129] - 9.00835072044485*y[128] + 1.84896616921897*y[131] - 9.21038227100566*y[130]
    g_run[33] = y[369] - 30.9517475172273*y[33] + 5.65456401516768*y[32] + 9.21038227100566*y[35] + 1.84896616921897*y[34] + 9.00835072044485*y[37] + 0.793238195499529*y[36] + 9.21038227100566*y[39] + 1.84896616921897*y[38] + 30.9517475172273*y[125] - 5.65456401516768*y[124] - 9.21038227100566*y[127] - 1.84896616921897*y[126] - 9.00835072044485*y[129] - 0.793238195499529*y[128] - 9.21038227100566*y[131] - 1.84896616921897*y[130]
    g_run[34] = y[370] - 1.84896616921897*y[33] + 9.21038227100566*y[32] - 5.65456401516768*y[35] - 30.9517475172273*y[34] - 1.84896616921897*y[37] + 9.21038227100566*y[36] - 0.793238195499528*y[39] + 9.00835072044485*y[38] + 1.84896616921897*y[125] - 9.21038227100566*y[124] + 5.65456401516768*y[127] + 30.9517475172273*y[126] + 1.84896616921897*y[129] - 9.21038227100566*y[128] + 0.793238195499528*y[131] - 9.00835072044485*y[130]
    g_run[35] = y[371] + 9.21038227100566*y[33] + 1.84896616921897*y[32] - 30.9517475172273*y[35] + 5.65456401516768*y[34] + 9.21038227100566*y[37] + 1.84896616921897*y[36] + 9.00835072044485*y[39] + 0.793238195499528*y[38] - 9.21038227100566*y[125] - 1.84896616921897*y[124] + 30.9517475172273*y[127] - 5.65456401516768*y[126] - 9.21038227100566*y[129] - 1.84896616921897*y[128] - 9.00835072044485*y[131] - 0.793238195499528*y[130]
    g_run[36] = y[372] - 0.793238195499527*y[33] + 9.00835072044484*y[32] - 1.84896616921897*y[35] + 9.21038227100566*y[34] - 5.65456401516768*y[37] - 30.9517475172273*y[36] - 1.84896616921897*y[39] + 9.21038227100566*y[38] + 0.793238195499527*y[125] - 9.00835072044484*y[124] + 1.84896616921897*y[127] - 9.21038227100566*y[126] + 5.65456401516768*y[129] + 30.9517475172273*y[128] + 1.84896616921897*y[131] - 9.21038227100566*y[130]
    g_run[37] = y[373] + 9.00835072044484*y[33] + 0.793238195499527*y[32] + 9.21038227100566*y[35] + 1.84896616921897*y[34] - 30.9517475172273*y[37] + 5.65456401516768*y[36] + 9.21038227100566*y[39] + 1.84896616921897*y[38] - 9.00835072044484*y[125] - 0.793238195499527*y[124] - 9.21038227100566*y[127] - 1.84896616921897*y[126] + 30.9517475172273*y[129] - 5.65456401516768*y[128] - 9.21038227100566*y[131] - 1.84896616921897*y[130]
    g_run[38] = -1.84896616921897*y[33] + 9.21038227100566*y[32] - 0.793238195499527*y[35] + 9.00835072044485*y[34] - 1.84896616921897*y[37] + 9.21038227100566*y[36] - 5.65456401516768*y[39] - 30.9767475172273*y[38] + 1.84896616921897*y[125] - 9.21038227100566*y[124] + 0.793238195499527*y[127] - 9.00835072044485*y[126] + 1.84896616921897*y[129] - 9.21038227100566*y[128] + 5.65456401516768*y[131] + 30.9517475172273*y[130]
    g_run[39] = 9.21038227100566*y[33] + 1.84896616921897*y[32] + 9.00835072044485*y[35] + 0.793238195499527*y[34] + 9.21038227100566*y[37] + 1.84896616921897*y[36] - 30.9767475172273*y[39] + 5.65456401516768*y[38] - 9.21038227100566*y[125] - 1.84896616921897*y[124] - 9.00835072044485*y[127] - 0.793238195499527*y[126] - 9.21038227100566*y[129] - 1.84896616921897*y[128] + 30.9517475172273*y[131] - 5.65456401516768*y[130]
    g_run[40] = y[376] + 5.65456401516768*y[133] + 30.9517475172273*y[132] + 1.84896616921897*y[135] - 9.21038227100566*y[134] + 0.793238195499529*y[137] - 9.00835072044485*y[136] + 1.84896616921897*y[139] - 9.21038227100566*y[138] - 5.65456401516768*y[41] - 30.9517475172273*y[40] - 1.84896616921897*y[43] + 9.21038227100566*y[42] - 0.793238195499529*y[45] + 9.00835072044485*y[44] - 1.84896616921897*y[47] + 9.21038227100566*y[46]
    g_run[41] = y[377] + 30.9517475172273*y[133] - 5.65456401516768*y[132] - 9.21038227100566*y[135] - 1.84896616921897*y[134] - 9.00835072044485*y[137] - 0.793238195499529*y[136] - 9.21038227100566*y[139] - 1.84896616921897*y[138] - 30.9517475172273*y[41] + 5.65456401516768*y[40] + 9.21038227100566*y[43] + 1.84896616921897*y[42] + 9.00835072044485*y[45] + 0.793238195499529*y[44] + 9.21038227100566*y[47] + 1.84896616921897*y[46]
    g_run[42] = y[378] + 1.84896616921897*y[133] - 9.21038227100566*y[132] + 5.65456401516768*y[135] + 30.9517475172273*y[134] + 1.84896616921897*y[137] - 9.21038227100566*y[136] + 0.793238195499528*y[139] - 9.00835072044485*y[138] - 1.84896616921897*y[41] + 9.21038227100566*y[40] - 5.65456401516768*y[43] - 30.9517475172273*y[42] - 1.84896616921897*y[45] + 9.21038227100566*y[44] - 0.793238195499528*y[47] + 9.00835072044485*y[46]
    g_run[43] = y[379] - 9.21038227100566*y[133] - 1.84896616921897*y[132] + 30.9517475172273*y[135] - 5.65456401516768*y[134] - 9.21038227100566*y[137] - 1.84896616921897*y[136] - 9.00835072044485*y[139] - 0.793238195499528*y[138] + 9.21038227100566*y[41] + 1.84896616921897*y[40] - 30.9517475172273*y[43] + 5.65456401516768*y[42] + 9.21038227100566*y[45] + 1.84896616921897*y[44] + 9.00835072044485*y[47] + 0.793238195499528*y[46]
    g_run[44] = y[380] + 0.793238195499527*y[133] - 9.00835072044484*y[132] + 1.84896616921897*y[135] - 9.21038227100566*y[134] + 5.65456401516768*y[137] + 30.9517475172273*y[136] + 1.84896616921897*y[139] - 9.21038227100566*y[138] - 0.793238195499527*y[41] + 9.00835072044484*y[40] - 1.84896616921897*y[43] + 9.21038227100566*y[42] - 5.65456401516768*y[45] - 30.9517475172273*y[44] - 1.84896616921897*y[47] + 9.21038227100566*y[46]
    g_run[45] = y[381] - 9.00835072044484*y[133] - 0.793238195499527*y[132] - 9.21038227100566*y[135] - 1.84896616921897*y[134] + 30.9517475172273*y[137] - 5.65456401516768*y[136] - 9.21038227100566*y[139] - 1.84896616921897*y[138] + 9.00835072044484*y[41] + 0.793238195499527*y[40] + 9.21038227100566*y[43] + 1.84896616921897*y[42] - 30.9517475172273*y[45] + 5.65456401516768*y[44] + 9.21038227100566*y[47] + 1.84896616921897*y[46]
    g_run[46] = 1.84896616921897*y[133] - 9.21038227100566*y[132] + 0.793238195499527*y[135] - 9.00835072044485*y[134] + 1.84896616921897*y[137] - 9.21038227100566*y[136] + 5.65456401516768*y[139] + 30.9517475172273*y[138] - 1.84896616921897*y[41] + 9.21038227100566*y[40] - 0.793238195499527*y[43] + 9.00835072044485*y[42] - 1.84896616921897*y[45] + 9.21038227100566*y[44] - 5.65456401516768*y[47] - 30.9767475172273*y[46]
    g_run[47] = -9.21038227100566*y[133] - 1.84896616921897*y[132] - 9.00835072044485*y[135] - 0.793238195499527*y[134] - 9.21038227100566*y[137] - 1.84896616921897*y[136] + 30.9517475172273*y[139] - 5.65456401516768*y[138] + 9.21038227100566*y[41] + 1.84896616921897*y[40] + 9.00835072044485*y[43] + 0.793238195499527*y[42] + 9.21038227100566*y[45] + 1.84896616921897*y[44] - 30.9767475172273*y[47] + 5.65456401516768*y[46]
    g_run[48] = y[384] + 135.4096140826*y[222] - 135.4096140826*y[48]
    g_run[49] = y[385] + 135.4096140826*y[223] - 135.4096140826*y[49]
    g_run[50] = y[386] + 135.4096140826*y[228] - 135.4096140826*y[50]
    g_run[51] = y[387] + 135.4096140826*y[229] - 135.4096140826*y[51]
    g_run[52] = y[388] - 157.977883096366*y[52] + 157.977883096366*y[166]
    g_run[53] = y[389] - 157.977883096366*y[53] + 157.977883096366*y[167]
    g_run[54] = y[390] - 157.977883096366*y[54] + 157.977883096366*y[172]
    g_run[55] = y[391] - 157.977883096366*y[55] + 157.977883096366*y[173]
    g_run[56] = y[392] - 157.977883096366*y[56] + 157.977883096366*y[182]
    g_run[57] = y[393] - 157.977883096366*y[57] + 157.977883096366*y[183]
    g_run[58] = y[394] - 157.977883096366*y[58] + 157.977883096366*y[188]
    g_run[59] = y[395] - 157.977883096366*y[59] + 157.977883096366*y[189]
    g_run[60] = y[396] - 157.977883096366*y[60] + 157.977883096366*y[190]
    g_run[61] = y[397] - 157.977883096366*y[61] + 157.977883096366*y[191]
    g_run[62] = y[398] - 157.977883096366*y[62] + 157.977883096366*y[196]
    g_run[63] = y[399] - 157.977883096366*y[63] + 157.977883096366*y[197]
    g_run[64] = y[400] + 157.977883096366*y[198] - 157.977883096366*y[64]
    g_run[65] = y[401] + 157.977883096366*y[199] - 157.977883096366*y[65]
    g_run[66] = y[402] + 157.977883096366*y[204] - 157.977883096366*y[66]
    g_run[67] = y[403] + 157.977883096366*y[205] - 157.977883096366*y[67]
    g_run[68] = 54.0657727682604*y[1] + 105.57176931318*y[0] - 10.2713736253513*y[3] - 39.6392229058202*y[2] - 23.284964480954*y[5] - 24.9575997948692*y[4] - 10.2713736253513*y[7] - 39.6392229058202*y[6] - 108.131545536521*y[69] - 211.14353862636*y[68] + 20.5427472507027*y[71] + 79.2784458116403*y[70] + 46.569928961908*y[73] + 49.9151995897384*y[72] + 20.5427472507027*y[75] + 79.2784458116403*y[74] + 54.0657727682604*y[77] + 105.57176931318*y[76] - 10.2713736253513*y[79] - 39.6392229058202*y[78] - 23.284964480954*y[81] - 24.9575997948692*y[80] - 10.2713736253513*y[83] - 39.6392229058202*y[82]
    g_run[69] = 105.57176931318*y[1] - 54.0657727682604*y[0] - 39.6392229058202*y[3] + 10.2713736253513*y[2] - 24.9575997948692*y[5] + 23.284964480954*y[4] - 39.6392229058202*y[7] + 10.2713736253513*y[6] - 211.14353862636*y[69] + 108.131545536521*y[68] + 79.2784458116403*y[71] - 20.5427472507027*y[70] + 49.9151995897384*y[73] - 46.569928961908*y[72] + 79.2784458116403*y[75] - 20.5427472507027*y[74] + 105.57176931318*y[77] - 54.0657727682604*y[76] - 39.6392229058202*y[79] + 10.2713736253513*y[78] - 24.9575997948692*y[81] + 23.284964480954*y[80] - 39.6392229058202*y[83] + 10.2713736253513*y[82]
    g_run[70] = -10.2713736253513*y[1] - 39.6392229058202*y[0] + 54.0657727682604*y[3] + 105.57176931318*y[2] - 10.2713736253513*y[5] - 39.6392229058201*y[4] - 23.284964480954*y[7] - 24.9575997948692*y[6] + 20.5427472507027*y[69] + 79.2784458116403*y[68] - 108.131545536521*y[71] - 211.14353862636*y[70] + 20.5427472507027*y[73] + 79.2784458116403*y[72] + 46.569928961908*y[75] + 49.9151995897384*y[74] - 10.2713736253513*y[77] - 39.6392229058202*y[76] + 54.0657727682604*y[79] + 105.57176931318*y[78] - 10.2713736253513*y[81] - 39.6392229058201*y[80] - 23.284964480954*y[83] - 24.9575997948692*y[82]
    g_run[71] = -39.6392229058202*y[1] + 10.2713736253513*y[0] + 105.57176931318*y[3] - 54.0657727682604*y[2] - 39.6392229058201*y[5] + 10.2713736253513*y[4] - 24.9575997948692*y[7] + 23.284964480954*y[6] + 79.2784458116403*y[69] - 20.5427472507027*y[68] - 211.14353862636*y[71] + 108.131545536521*y[70] + 79.2784458116403*y[73] - 20.5427472507027*y[72] + 49.9151995897384*y[75] - 46.569928961908*y[74] - 39.6392229058202*y[77] + 10.2713736253513*y[76] + 105.57176931318*y[79] - 54.0657727682604*y[78] - 39.6392229058201*y[81] + 10.2713736253513*y[80] - 24.9575997948692*y[83] + 23.284964480954*y[82]
    g_run[72] = -23.284964480954*y[1] - 24.9575997948692*y[0] - 10.2713736253513*y[3] - 39.6392229058202*y[2] + 54.0657727682604*y[5] + 105.57176931318*y[4] - 10.2713736253514*y[7] - 39.6392229058201*y[6] + 46.569928961908*y[69] + 49.9151995897384*y[68] + 20.5427472507027*y[71] + 79.2784458116404*y[70] - 108.131545536521*y[73] - 211.14353862636*y[72] + 20.5427472507027*y[75] + 79.2784458116403*y[74] - 23.284964480954*y[77] - 24.9575997948692*y[76] - 10.2713736253513*y[79] - 39.6392229058202*y[78] + 54.0657727682604*y[81] + 105.57176931318*y[80] - 10.2713736253514*y[83] - 39.6392229058201*y[82]
    g_run[73] = -24.9575997948692*y[1] + 23.284964480954*y[0] - 39.6392229058202*y[3] + 10.2713736253513*y[2] + 105.57176931318*y[5] - 54.0657727682604*y[4] - 39.6392229058201*y[7] + 10.2713736253514*y[6] + 49.9151995897384*y[69] - 46.569928961908*y[68] + 79.2784458116404*y[71] - 20.5427472507027*y[70] - 211.14353862636*y[73] + 108.131545536521*y[72] + 79.2784458116403*y[75] - 20.5427472507027*y[74] - 24.9575997948692*y[77] + 23.284964480954*y[76] - 39.6392229058202*y[79] + 10.2713736253513*y[78] + 105.57176931318*y[81] - 54.0657727682604*y[80] - 39.6392229058201*y[83] + 10.2713736253514*y[82]
    g_run[74] = -10.2713736253513*y[1] - 39.6392229058202*y[0] - 23.284964480954*y[3] - 24.9575997948692*y[2] - 10.2713736253513*y[5] - 39.6392229058202*y[4] + 54.0657727682604*y[7] + 105.57176931318*y[6] + 20.5427472507027*y[69] + 79.2784458116403*y[68] + 46.569928961908*y[71] + 49.9151995897384*y[70] + 20.5427472507027*y[73] + 79.2784458116403*y[72] - 108.131545536521*y[75] - 211.16853862636*y[74] - 10.2713736253513*y[77] - 39.6392229058202*y[76] - 23.284964480954*y[79] - 24.9575997948692*y[78] - 10.2713736253513*y[81] - 39.6392229058202*y[80] + 54.0657727682604*y[83] + 105.57176931318*y[82]
    g_run[75] = -39.6392229058202*y[1] + 10.2713736253513*y[0] - 24.9575997948692*y[3] + 23.284964480954*y[2] - 39.6392229058202*y[5] + 10.2713736253513*y[4] + 105.57176931318*y[7] - 54.0657727682604*y[6] + 79.2784458116403*y[69] - 20.5427472507027*y[68] + 49.9151995897384*y[71] - 46.569928961908*y[70] + 79.2784458116403*y[73] - 20.5427472507027*y[72] - 211.16853862636*y[75] + 108.131545536521*y[74] - 39.6392229058202*y[77] + 10.2713736253513*y[76] - 24.9575997948692*y[79] + 23.284964480954*y[78] - 39.6392229058202*y[81] + 10.2713736253513*y[80] + 105.57176931318*y[83] - 54.0657727682604*y[82]
    g_run[76] = 4.84676915585801*y[9] + 26.5300693004806*y[8] + 1.58482814504483*y[11] - 7.8946133751477*y[10] + 0.67991845328531*y[13] - 7.72144347466701*y[12] + 1.58482814504483*y[15] - 7.89461337514771*y[14] + 54.0657727682604*y[69] + 105.57176931318*y[68] - 10.2713736253513*y[71] - 39.6392229058202*y[70] - 23.284964480954*y[73] - 24.9575997948692*y[72] - 10.2713736253513*y[75] - 39.6392229058202*y[74] - 112.978314692379*y[77] - 237.673607926841*y[76] + 18.9579191056578*y[79] + 87.173059186788*y[78] + 45.8900105086227*y[81] + 57.6366430644055*y[80] + 18.9579191056579*y[83] + 87.173059186788*y[82] + 54.0657727682604*y[85] + 105.57176931318*y[84] - 10.2713736253513*y[87] - 39.6392229058202*y[86] - 23.284964480954*y[89] - 24.9575997948692*y[88] - 10.2713736253513*y[91] - 39.6392229058202*y[90]
    g_run[77] = 26.5300693004806*y[9] - 4.84676915585801*y[8] - 7.8946133751477*y[11] - 1.58482814504483*y[10] - 7.72144347466701*y[13] - 0.67991845328531*y[12] - 7.89461337514771*y[15] - 1.58482814504483*y[14] + 105.57176931318*y[69] - 54.0657727682604*y[68] - 39.6392229058202*y[71] + 10.2713736253513*y[70] - 24.9575997948692*y[73] + 23.284964480954*y[72] - 39.6392229058202*y[75] + 10.2713736253513*y[74] - 237.673607926841*y[77] + 112.978314692379*y[76] + 87.173059186788*y[79] - 18.9579191056578*y[78] + 57.6366430644055*y[81] - 45.8900105086227*y[80] + 87.173059186788*y[83] - 18.9579191056579*y[82] + 105.57176931318*y[85] - 54.0657727682604*y[84] - 39.6392229058202*y[87] + 10.2713736253513*y[86] - 24.9575997948692*y[89] + 23.284964480954*y[88] - 39.6392229058202*y[91] + 10.2713736253513*y[90]
    g_run[78] = 1.58482814504483*y[9] - 7.89461337514771*y[8] + 4.84676915585801*y[11] + 26.5300693004806*y[10] + 1.58482814504483*y[13] - 7.89461337514771*y[12] + 0.679918453285308*y[15] - 7.72144347466701*y[14] - 10.2713736253513*y[69] - 39.6392229058202*y[68] + 54.0657727682604*y[71] + 105.57176931318*y[70] - 10.2713736253513*y[73] - 39.6392229058201*y[72] - 23.284964480954*y[75] - 24.9575997948692*y[74] + 18.9579191056579*y[77] + 87.173059186788*y[76] - 112.978314692379*y[79] - 237.673607926841*y[78] + 18.9579191056579*y[81] + 87.173059186788*y[80] + 45.8900105086227*y[83] + 57.6366430644054*y[82] - 10.2713736253513*y[85] - 39.6392229058202*y[84] + 54.0657727682604*y[87] + 105.57176931318*y[86] - 10.2713736253513*y[89] - 39.6392229058201*y[88] - 23.284964480954*y[91] - 24.9575997948692*y[90]
    g_run[79] = -7.89461337514771*y[9] - 1.58482814504483*y[8] + 26.5300693004806*y[11] - 4.84676915585801*y[10] - 7.89461337514771*y[13] - 1.58482814504483*y[12] - 7.72144347466701*y[15] - 0.679918453285308*y[14] - 39.6392229058202*y[69] + 10.2713736253513*y[68] + 105.57176931318*y[71] - 54.0657727682604*y[70] - 39.6392229058201*y[73] + 10.2713736253513*y[72] - 24.9575997948692*y[75] + 23.284964480954*y[74] + 87.173059186788*y[77] - 18.9579191056579*y[76] - 237.673607926841*y[79] + 112.978314692379*y[78] + 87.173059186788*y[81] - 18.9579191056579*y[80] + 57.6366430644054*y[83] - 45.8900105086227*y[82] - 39.6392229058202*y[85] + 10.2713736253513*y[84] + 105.57176931318*y[87] - 54.0657727682604*y[86] - 39.6392229058201*y[89] + 10.2713736253513*y[88] - 24.9575997948692*y[91] + 23.284964480954*y[90]
    g_run[80] = 0.67991845328531*y[9] - 7.72144347466701*y[8] + 1.58482814504483*y[11] - 7.8946133751477*y[10] + 4.84676915585801*y[13] + 26.5300693004806*y[12] + 1.58482814504483*y[15] - 7.89461337514771*y[14] - 23.284964480954*y[69] - 24.9575997948692*y[68] - 10.2713736253513*y[71] - 39.6392229058202*y[70] + 54.0657727682604*y[73] + 105.57176931318*y[72] - 10.2713736253514*y[75] - 39.6392229058201*y[74] + 45.8900105086227*y[77] + 57.6366430644054*y[76] + 18.9579191056578*y[79] + 87.1730591867881*y[78] - 112.978314692379*y[81] - 237.673607926841*y[80] + 18.9579191056579*y[83] + 87.173059186788*y[82] - 23.284964480954*y[85] - 24.9575997948692*y[84] - 10.2713736253513*y[87] - 39.6392229058202*y[86] + 54.0657727682604*y[89] + 105.57176931318*y[88] - 10.2713736253514*y[91] - 39.6392229058201*y[90]
    g_run[81] = -7.72144347466701*y[9] - 0.67991845328531*y[8] - 7.8946133751477*y[11] - 1.58482814504483*y[10] + 26.5300693004806*y[13] - 4.84676915585801*y[12] - 7.89461337514771*y[15] - 1.58482814504483*y[14] - 24.9575997948692*y[69] + 23.284964480954*y[68] - 39.6392229058202*y[71] + 10.2713736253513*y[70] + 105.57176931318*y[73] - 54.0657727682604*y[72] - 39.6392229058201*y[75] + 10.2713736253514*y[74] + 57.6366430644054*y[77] - 45.8900105086227*y[76] + 87.1730591867881*y[79] - 18.9579191056578*y[78] - 237.673607926841*y[81] + 112.978314692379*y[80] + 87.173059186788*y[83] - 18.9579191056579*y[82] - 24.9575997948692*y[85] + 23.284964480954*y[84] - 39.6392229058202*y[87] + 10.2713736253513*y[86] + 105.57176931318*y[89] - 54.0657727682604*y[88] - 39.6392229058201*y[91] + 10.2713736253514*y[90]
    g_run[82] = 1.58482814504483*y[9] - 7.89461337514771*y[8] + 0.679918453285308*y[11] - 7.72144347466701*y[10] + 1.58482814504483*y[13] - 7.89461337514771*y[12] + 4.84676915585801*y[15] + 26.5300693004806*y[14] - 10.2713736253513*y[69] - 39.6392229058202*y[68] - 23.284964480954*y[71] - 24.9575997948692*y[70] - 10.2713736253513*y[73] - 39.6392229058202*y[72] + 54.0657727682604*y[75] + 105.57176931318*y[74] + 18.9579191056578*y[77] + 87.173059186788*y[76] + 45.8900105086227*y[79] + 57.6366430644054*y[78] + 18.9579191056579*y[81] + 87.173059186788*y[80] - 112.978314692379*y[83] - 237.673607926841*y[82] - 10.2713736253513*y[85] - 39.6392229058202*y[84] - 23.284964480954*y[87] - 24.9575997948692*y[86] - 10.2713736253513*y[89] - 39.6392229058202*y[88] + 54.0657727682604*y[91] + 105.57176931318*y[90]
    g_run[83] = -7.89461337514771*y[9] - 1.58482814504483*y[8] - 7.72144347466701*y[11] - 0.679918453285308*y[10] - 7.89461337514771*y[13] - 1.58482814504483*y[12] + 26.5300693004806*y[15] - 4.84676915585801*y[14] - 39.6392229058202*y[69] + 10.2713736253513*y[68] - 24.9575997948692*y[71] + 23.284964480954*y[70] - 39.6392229058202*y[73] + 10.2713736253513*y[72] + 105.57176931318*y[75] - 54.0657727682604*y[74] + 87.173059186788*y[77] - 18.9579191056578*y[76] + 57.6366430644054*y[79] - 45.8900105086227*y[78] + 87.173059186788*y[81] - 18.9579191056579*y[80] - 237.673607926841*y[83] + 112.978314692379*y[82] - 39.6392229058202*y[85] + 10.2713736253513*y[84] - 24.9575997948692*y[87] + 23.284964480954*y[86] - 39.6392229058202*y[89] + 10.2713736253513*y[88] + 105.57176931318*y[91] - 54.0657727682604*y[90]
    g_run[84] = 4.84676915585801*y[141] + 26.5300693004806*y[140] + 1.58482814504483*y[143] - 7.8946133751477*y[142] + 0.67991845328531*y[145] - 7.72144347466701*y[144] + 1.58482814504483*y[147] - 7.89461337514771*y[146] + 54.0657727682604*y[77] + 105.57176931318*y[76] - 10.2713736253513*y[79] - 39.6392229058202*y[78] - 23.284964480954*y[81] - 24.9575997948692*y[80] - 10.2713736253513*y[83] - 39.6392229058202*y[82] - 112.978314692379*y[85] - 237.673607926841*y[84] + 18.9579191056578*y[87] + 87.173059186788*y[86] + 45.8900105086227*y[89] + 57.6366430644055*y[88] + 18.9579191056579*y[91] + 87.173059186788*y[90] + 54.0657727682604*y[93] + 105.57176931318*y[92] - 10.2713736253513*y[95] - 39.6392229058202*y[94] - 23.284964480954*y[97] - 24.9575997948692*y[96] - 10.2713736253513*y[99] - 39.6392229058202*y[98]
    g_run[85] = 26.5300693004806*y[141] - 4.84676915585801*y[140] - 7.8946133751477*y[143] - 1.58482814504483*y[142] - 7.72144347466701*y[145] - 0.67991845328531*y[144] - 7.89461337514771*y[147] - 1.58482814504483*y[146] + 105.57176931318*y[77] - 54.0657727682604*y[76] - 39.6392229058202*y[79] + 10.2713736253513*y[78] - 24.9575997948692*y[81] + 23.284964480954*y[80] - 39.6392229058202*y[83] + 10.2713736253513*y[82] - 237.673607926841*y[85] + 112.978314692379*y[84] + 87.173059186788*y[87] - 18.9579191056578*y[86] + 57.6366430644055*y[89] - 45.8900105086227*y[88] + 87.173059186788*y[91] - 18.9579191056579*y[90] + 105.57176931318*y[93] - 54.0657727682604*y[92] - 39.6392229058202*y[95] + 10.2713736253513*y[94] - 24.9575997948692*y[97] + 23.284964480954*y[96] - 39.6392229058202*y[99] + 10.2713736253513*y[98]
    g_run[86] = 1.58482814504483*y[141] - 7.89461337514771*y[140] + 4.84676915585801*y[143] + 26.5300693004806*y[142] + 1.58482814504483*y[145] - 7.89461337514771*y[144] + 0.679918453285308*y[147] - 7.72144347466701*y[146] - 10.2713736253513*y[77] - 39.6392229058202*y[76] + 54.0657727682604*y[79] + 105.57176931318*y[78] - 10.2713736253513*y[81] - 39.6392229058201*y[80] - 23.284964480954*y[83] - 24.9575997948692*y[82] + 18.9579191056579*y[85] + 87.173059186788*y[84] - 112.978314692379*y[87] - 237.673607926841*y[86] + 18.9579191056579*y[89] + 87.173059186788*y[88] + 45.8900105086227*y[91] + 57.6366430644054*y[90] - 10.2713736253513*y[93] - 39.6392229058202*y[92] + 54.0657727682604*y[95] + 105.57176931318*y[94] - 10.2713736253513*y[97] - 39.6392229058201*y[96] - 23.284964480954*y[99] - 24.9575997948692*y[98]
    g_run[87] = -7.89461337514771*y[141] - 1.58482814504483*y[140] + 26.5300693004806*y[143] - 4.84676915585801*y[142] - 7.89461337514771*y[145] - 1.58482814504483*y[144] - 7.72144347466701*y[147] - 0.679918453285308*y[146] - 39.6392229058202*y[77] + 10.2713736253513*y[76] + 105.57176931318*y[79] - 54.0657727682604*y[78] - 39.6392229058201*y[81] + 10.2713736253513*y[80] - 24.9575997948692*y[83] + 23.284964480954*y[82] + 87.173059186788*y[85] - 18.9579191056579*y[84] - 237.673607926841*y[87] + 112.978314692379*y[86] + 87.173059186788*y[89] - 18.9579191056579*y[88] + 57.6366430644054*y[91] - 45.8900105086227*y[90] - 39.6392229058202*y[93] + 10.2713736253513*y[92] + 105.57176931318*y[95] - 54.0657727682604*y[94] - 39.6392229058201*y[97] + 10.2713736253513*y[96] - 24.9575997948692*y[99] + 23.284964480954*y[98]
    g_run[88] = 0.67991845328531*y[141] - 7.72144347466701*y[140] + 1.58482814504483*y[143] - 7.8946133751477*y[142] + 4.84676915585801*y[145] + 26.5300693004806*y[144] + 1.58482814504483*y[147] - 7.89461337514771*y[146] - 23.284964480954*y[77] - 24.9575997948692*y[76] - 10.2713736253513*y[79] - 39.6392229058202*y[78] + 54.0657727682604*y[81] + 105.57176931318*y[80] - 10.2713736253514*y[83] - 39.6392229058201*y[82] + 45.8900105086227*y[85] + 57.6366430644054*y[84] + 18.9579191056578*y[87] + 87.1730591867881*y[86] - 112.978314692379*y[89] - 237.673607926841*y[88] + 18.9579191056579*y[91] + 87.173059186788*y[90] - 23.284964480954*y[93] - 24.9575997948692*y[92] - 10.2713736253513*y[95] - 39.6392229058202*y[94] + 54.0657727682604*y[97] + 105.57176931318*y[96] - 10.2713736253514*y[99] - 39.6392229058201*y[98]
    g_run[89] = -7.72144347466701*y[141] - 0.67991845328531*y[140] - 7.8946133751477*y[143] - 1.58482814504483*y[142] + 26.5300693004806*y[145] - 4.84676915585801*y[144] - 7.89461337514771*y[147] - 1.58482814504483*y[146] - 24.9575997948692*y[77] + 23.284964480954*y[76] - 39.6392229058202*y[79] + 10.2713736253513*y[78] + 105.57176931318*y[81] - 54.0657727682604*y[80] - 39.6392229058201*y[83] + 10.2713736253514*y[82] + 57.6366430644054*y[85] - 45.8900105086227*y[84] + 87.1730591867881*y[87] - 18.9579191056578*y[86] - 237.673607926841*y[89] + 112.978314692379*y[88] + 87.173059186788*y[91] - 18.9579191056579*y[90] - 24.9575997948692*y[93] + 23.284964480954*y[92] - 39.6392229058202*y[95] + 10.2713736253513*y[94] + 105.57176931318*y[97] - 54.0657727682604*y[96] - 39.6392229058201*y[99] + 10.2713736253514*y[98]
    g_run[90] = 1.58482814504483*y[141] - 7.89461337514771*y[140] + 0.679918453285308*y[143] - 7.72144347466701*y[142] + 1.58482814504483*y[145] - 7.89461337514771*y[144] + 4.84676915585801*y[147] + 26.5300693004806*y[146] - 10.2713736253513*y[77] - 39.6392229058202*y[76] - 23.284964480954*y[79] - 24.9575997948692*y[78] - 10.2713736253513*y[81] - 39.6392229058202*y[80] + 54.0657727682604*y[83] + 105.57176931318*y[82] + 18.9579191056578*y[85] + 87.173059186788*y[84] + 45.8900105086227*y[87] + 57.6366430644054*y[86] + 18.9579191056579*y[89] + 87.173059186788*y[88] - 112.978314692379*y[91] - 237.698607926841*y[90] - 10.2713736253513*y[93] - 39.6392229058202*y[92] - 23.284964480954*y[95] - 24.9575997948692*y[94] - 10.2713736253513*y[97] - 39.6392229058202*y[96] + 54.0657727682604*y[99] + 105.57176931318*y[98]
    g_run[91] = -7.89461337514771*y[141] - 1.58482814504483*y[140] - 7.72144347466701*y[143] - 0.679918453285308*y[142] - 7.89461337514771*y[145] - 1.58482814504483*y[144] + 26.5300693004806*y[147] - 4.84676915585801*y[146] - 39.6392229058202*y[77] + 10.2713736253513*y[76] - 24.9575997948692*y[79] + 23.284964480954*y[78] - 39.6392229058202*y[81] + 10.2713736253513*y[80] + 105.57176931318*y[83] - 54.0657727682604*y[82] + 87.173059186788*y[85] - 18.9579191056578*y[84] + 57.6366430644054*y[87] - 45.8900105086227*y[86] + 87.173059186788*y[89] - 18.9579191056579*y[88] - 237.698607926841*y[91] + 112.978314692379*y[90] - 39.6392229058202*y[93] + 10.2713736253513*y[92] - 24.9575997948692*y[95] + 23.284964480954*y[94] - 39.6392229058202*y[97] + 10.2713736253513*y[96] + 105.57176931318*y[99] - 54.0657727682604*y[98]
    g_run[92] = 54.0657727682604*y[85] + 105.57176931318*y[84] - 10.2713736253513*y[87] - 39.6392229058202*y[86] - 23.284964480954*y[89] - 24.9575997948692*y[88] - 10.2713736253513*y[91] - 39.6392229058202*y[90] - 108.131545536521*y[93] - 211.14353862636*y[92] + 20.5427472507027*y[95] + 79.2784458116403*y[94] + 46.569928961908*y[97] + 49.9151995897384*y[96] + 20.5427472507027*y[99] + 79.2784458116403*y[98] + 54.0657727682604*y[101] + 105.57176931318*y[100] - 10.2713736253513*y[103] - 39.6392229058202*y[102] - 23.284964480954*y[105] - 24.9575997948692*y[104] - 10.2713736253513*y[107] - 39.6392229058202*y[106]
    g_run[93] = 105.57176931318*y[85] - 54.0657727682604*y[84] - 39.6392229058202*y[87] + 10.2713736253513*y[86] - 24.9575997948692*y[89] + 23.284964480954*y[88] - 39.6392229058202*y[91] + 10.2713736253513*y[90] - 211.14353862636*y[93] + 108.131545536521*y[92] + 79.2784458116403*y[95] - 20.5427472507027*y[94] + 49.9151995897384*y[97] - 46.569928961908*y[96] + 79.2784458116403*y[99] - 20.5427472507027*y[98] + 105.57176931318*y[101] - 54.0657727682604*y[100] - 39.6392229058202*y[103] + 10.2713736253513*y[102] - 24.9575997948692*y[105] + 23.284964480954*y[104] - 39.6392229058202*y[107] + 10.2713736253513*y[106]
    g_run[94] = -10.2713736253513*y[85] - 39.6392229058202*y[84] + 54.0657727682604*y[87] + 105.57176931318*y[86] - 10.2713736253513*y[89] - 39.6392229058201*y[88] - 23.284964480954*y[91] - 24.9575997948692*y[90] + 20.5427472507027*y[93] + 79.2784458116403*y[92] - 108.131545536521*y[95] - 211.14353862636*y[94] + 20.5427472507027*y[97] + 79.2784458116403*y[96] + 46.569928961908*y[99] + 49.9151995897384*y[98] - 10.2713736253513*y[101] - 39.6392229058202*y[100] + 54.0657727682604*y[103] + 105.57176931318*y[102] - 10.2713736253513*y[105] - 39.6392229058201*y[104] - 23.284964480954*y[107] - 24.9575997948692*y[106]
    g_run[95] = -39.6392229058202*y[85] + 10.2713736253513*y[84] + 105.57176931318*y[87] - 54.0657727682604*y[86] - 39.6392229058201*y[89] + 10.2713736253513*y[88] - 24.9575997948692*y[91] + 23.284964480954*y[90] + 79.2784458116403*y[93] - 20.5427472507027*y[92] - 211.14353862636*y[95] + 108.131545536521*y[94] + 79.2784458116403*y[97] - 20.5427472507027*y[96] + 49.9151995897384*y[99] - 46.569928961908*y[98] - 39.6392229058202*y[101] + 10.2713736253513*y[100] + 105.57176931318*y[103] - 54.0657727682604*y[102] - 39.6392229058201*y[105] + 10.2713736253513*y[104] - 24.9575997948692*y[107] + 23.284964480954*y[106]
    g_run[96] = -23.284964480954*y[85] - 24.9575997948692*y[84] - 10.2713736253513*y[87] - 39.6392229058202*y[86] + 54.0657727682604*y[89] + 105.57176931318*y[88] - 10.2713736253514*y[91] - 39.6392229058201*y[90] + 46.569928961908*y[93] + 49.9151995897384*y[92] + 20.5427472507027*y[95] + 79.2784458116404*y[94] - 108.131545536521*y[97] - 211.14353862636*y[96] + 20.5427472507027*y[99] + 79.2784458116403*y[98] - 23.284964480954*y[101] - 24.9575997948692*y[100] - 10.2713736253513*y[103] - 39.6392229058202*y[102] + 54.0657727682604*y[105] + 105.57176931318*y[104] - 10.2713736253514*y[107] - 39.6392229058201*y[106]
    g_run[97] = -24.9575997948692*y[85] + 23.284964480954*y[84] - 39.6392229058202*y[87] + 10.2713736253513*y[86] + 105.57176931318*y[89] - 54.0657727682604*y[88] - 39.6392229058201*y[91] + 10.2713736253514*y[90] + 49.9151995897384*y[93] - 46.569928961908*y[92] + 79.2784458116404*y[95] - 20.5427472507027*y[94] - 211.14353862636*y[97] + 108.131545536521*y[96] + 79.2784458116403*y[99] - 20.5427472507027*y[98] - 24.9575997948692*y[101] + 23.284964480954*y[100] - 39.6392229058202*y[103] + 10.2713736253513*y[102] + 105.57176931318*y[105] - 54.0657727682604*y[104] - 39.6392229058201*y[107] + 10.2713736253514*y[106]
    g_run[98] = -10.2713736253513*y[85] - 39.6392229058202*y[84] - 23.284964480954*y[87] - 24.9575997948692*y[86] - 10.2713736253513*y[89] - 39.6392229058202*y[88] + 54.0657727682604*y[91] + 105.57176931318*y[90] + 20.5427472507027*y[93] + 79.2784458116403*y[92] + 46.569928961908*y[95] + 49.9151995897384*y[94] + 20.5427472507027*y[97] + 79.2784458116403*y[96] - 108.131545536521*y[99] - 211.14353862636*y[98] - 10.2713736253513*y[101] - 39.6392229058202*y[100] - 23.284964480954*y[103] - 24.9575997948692*y[102] - 10.2713736253513*y[105] - 39.6392229058202*y[104] + 54.0657727682604*y[107] + 105.57176931318*y[106]
    g_run[99] = -39.6392229058202*y[85] + 10.2713736253513*y[84] - 24.9575997948692*y[87] + 23.284964480954*y[86] - 39.6392229058202*y[89] + 10.2713736253513*y[88] + 105.57176931318*y[91] - 54.0657727682604*y[90] + 79.2784458116403*y[93] - 20.5427472507027*y[92] + 49.9151995897384*y[95] - 46.569928961908*y[94] + 79.2784458116403*y[97] - 20.5427472507027*y[96] - 211.14353862636*y[99] + 108.131545536521*y[98] - 39.6392229058202*y[101] + 10.2713736253513*y[100] - 24.9575997948692*y[103] + 23.284964480954*y[102] - 39.6392229058202*y[105] + 10.2713736253513*y[104] + 105.57176931318*y[107] - 54.0657727682604*y[106]
    g_run[100] = 5.65456401516768*y[25] + 30.9517475172273*y[24] + 1.84896616921897*y[27] - 9.21038227100566*y[26] + 0.793238195499529*y[29] - 9.00835072044485*y[28] + 1.84896616921897*y[31] - 9.21038227100566*y[30] + 54.0657727682604*y[93] + 105.57176931318*y[92] - 10.2713736253513*y[95] - 39.6392229058202*y[94] - 23.284964480954*y[97] - 24.9575997948692*y[96] - 10.2713736253513*y[99] - 39.6392229058202*y[98] - 113.786109551688*y[101] - 242.095286143588*y[100] + 18.6937810814837*y[103] + 88.488828082646*y[102] + 45.7766907664085*y[105] + 58.9235503101833*y[104] + 18.6937810814837*y[107] + 88.488828082646*y[106] + 54.0657727682604*y[109] + 105.57176931318*y[108] - 10.2713736253513*y[111] - 39.6392229058202*y[110] - 23.284964480954*y[113] - 24.9575997948692*y[112] - 10.2713736253513*y[115] - 39.6392229058202*y[114]
    g_run[101] = 30.9517475172273*y[25] - 5.65456401516768*y[24] - 9.21038227100566*y[27] - 1.84896616921897*y[26] - 9.00835072044485*y[29] - 0.793238195499529*y[28] - 9.21038227100566*y[31] - 1.84896616921897*y[30] + 105.57176931318*y[93] - 54.0657727682604*y[92] - 39.6392229058202*y[95] + 10.2713736253513*y[94] - 24.9575997948692*y[97] + 23.284964480954*y[96] - 39.6392229058202*y[99] + 10.2713736253513*y[98] - 242.095286143588*y[101] + 113.786109551688*y[100] + 88.488828082646*y[103] - 18.6937810814837*y[102] + 58.9235503101833*y[105] - 45.7766907664085*y[104] + 88.488828082646*y[107] - 18.6937810814837*y[106] + 105.57176931318*y[109] - 54.0657727682604*y[108] - 39.6392229058202*y[111] + 10.2713736253513*y[110] - 24.9575997948692*y[113] + 23.284964480954*y[112] - 39.6392229058202*y[115] + 10.2713736253513*y[114]
    g_run[102] = 1.84896616921897*y[25] - 9.21038227100566*y[24] + 5.65456401516768*y[27] + 30.9517475172273*y[26] + 1.84896616921897*y[29] - 9.21038227100566*y[28] + 0.793238195499528*y[31] - 9.00835072044485*y[30] - 10.2713736253513*y[93] - 39.6392229058202*y[92] + 54.0657727682604*y[95] + 105.57176931318*y[94] - 10.2713736253513*y[97] - 39.6392229058201*y[96] - 23.284964480954*y[99] - 24.9575997948692*y[98] + 18.6937810814837*y[101] + 88.488828082646*y[100] - 113.786109551688*y[103] - 242.095286143588*y[102] + 18.6937810814837*y[105] + 88.488828082646*y[104] + 45.7766907664085*y[107] + 58.9235503101833*y[106] - 10.2713736253513*y[109] - 39.6392229058202*y[108] + 54.0657727682604*y[111] + 105.57176931318*y[110] - 10.2713736253513*y[113] - 39.6392229058201*y[112] - 23.284964480954*y[115] - 24.9575997948692*y[114]
    g_run[103] = -9.21038227100566*y[25] - 1.84896616921897*y[24] + 30.9517475172273*y[27] - 5.65456401516768*y[26] - 9.21038227100566*y[29] - 1.84896616921897*y[28] - 9.00835072044485*y[31] - 0.793238195499528*y[30] - 39.6392229058202*y[93] + 10.2713736253513*y[92] + 105.57176931318*y[95] - 54.0657727682604*y[94] - 39.6392229058201*y[97] + 10.2713736253513*y[96] - 24.9575997948692*y[99] + 23.284964480954*y[98] + 88.488828082646*y[101] - 18.6937810814837*y[100] - 242.095286143588*y[103] + 113.786109551688*y[102] + 88.488828082646*y[105] - 18.6937810814837*y[104] + 58.9235503101833*y[107] - 45.7766907664085*y[106] - 39.6392229058202*y[109] + 10.2713736253513*y[108] + 105.57176931318*y[111] - 54.0657727682604*y[110] - 39.6392229058201*y[113] + 10.2713736253513*y[112] - 24.9575997948692*y[115] + 23.284964480954*y[114]
    g_run[104] = 0.793238195499527*y[25] - 9.00835072044484*y[24] + 1.84896616921897*y[27] - 9.21038227100566*y[26] + 5.65456401516768*y[29] + 30.9517475172273*y[28] + 1.84896616921897*y[31] - 9.21038227100566*y[30] - 23.284964480954*y[93] - 24.9575997948692*y[92] - 10.2713736253513*y[95] - 39.6392229058202*y[94] + 54.0657727682604*y[97] + 105.57176931318*y[96] - 10.2713736253514*y[99] - 39.6392229058201*y[98] + 45.7766907664085*y[101] + 58.9235503101833*y[100] + 18.6937810814837*y[103] + 88.4888280826461*y[102] - 113.786109551688*y[105] - 242.095286143588*y[104] + 18.6937810814837*y[107] + 88.4888280826459*y[106] - 23.284964480954*y[109] - 24.9575997948692*y[108] - 10.2713736253513*y[111] - 39.6392229058202*y[110] + 54.0657727682604*y[113] + 105.57176931318*y[112] - 10.2713736253514*y[115] - 39.6392229058201*y[114]
    g_run[105] = -9.00835072044484*y[25] - 0.793238195499527*y[24] - 9.21038227100566*y[27] - 1.84896616921897*y[26] + 30.9517475172273*y[29] - 5.65456401516768*y[28] - 9.21038227100566*y[31] - 1.84896616921897*y[30] - 24.9575997948692*y[93] + 23.284964480954*y[92] - 39.6392229058202*y[95] + 10.2713736253513*y[94] + 105.57176931318*y[97] - 54.0657727682604*y[96] - 39.6392229058201*y[99] + 10.2713736253514*y[98] + 58.9235503101833*y[101] - 45.7766907664085*y[100] + 88.4888280826461*y[103] - 18.6937810814837*y[102] - 242.095286143588*y[105] + 113.786109551688*y[104] + 88.4888280826459*y[107] - 18.6937810814837*y[106] - 24.9575997948692*y[109] + 23.284964480954*y[108] - 39.6392229058202*y[111] + 10.2713736253513*y[110] + 105.57176931318*y[113] - 54.0657727682604*y[112] - 39.6392229058201*y[115] + 10.2713736253514*y[114]
    g_run[106] = 1.84896616921897*y[25] - 9.21038227100566*y[24] + 0.793238195499527*y[27] - 9.00835072044485*y[26] + 1.84896616921897*y[29] - 9.21038227100566*y[28] + 5.65456401516768*y[31] + 30.9517475172273*y[30] - 10.2713736253513*y[93] - 39.6392229058202*y[92] - 23.284964480954*y[95] - 24.9575997948692*y[94] - 10.2713736253513*y[97] - 39.6392229058202*y[96] + 54.0657727682604*y[99] + 105.57176931318*y[98] + 18.6937810814837*y[101] + 88.488828082646*y[100] + 45.7766907664085*y[103] + 58.9235503101832*y[102] + 18.6937810814837*y[105] + 88.488828082646*y[104] - 113.786109551688*y[107] - 242.120286143588*y[106] - 10.2713736253513*y[109] - 39.6392229058202*y[108] - 23.284964480954*y[111] - 24.9575997948692*y[110] - 10.2713736253513*y[113] - 39.6392229058202*y[112] + 54.0657727682604*y[115] + 105.57176931318*y[114]
    g_run[107] = -9.21038227100566*y[25] - 1.84896616921897*y[24] - 9.00835072044485*y[27] - 0.793238195499527*y[26] - 9.21038227100566*y[29] - 1.84896616921897*y[28] + 30.9517475172273*y[31] - 5.65456401516768*y[30] - 39.6392229058202*y[93] + 10.2713736253513*y[92] - 24.9575997948692*y[95] + 23.284964480954*y[94] - 39.6392229058202*y[97] + 10.2713736253513*y[96] + 105.57176931318*y[99] - 54.0657727682604*y[98] + 88.488828082646*y[101] - 18.6937810814837*y[100] + 58.9235503101832*y[103] - 45.7766907664085*y[102] + 88.488828082646*y[105] - 18.6937810814837*y[104] - 242.120286143588*y[107] + 113.786109551688*y[106] - 39.6392229058202*y[109] + 10.2713736253513*y[108] - 24.9575997948692*y[111] + 23.284964480954*y[110] - 39.6392229058202*y[113] + 10.2713736253513*y[112] + 105.57176931318*y[115] - 54.0657727682604*y[114]
    g_run[108] = 54.0657727682604*y[101] + 105.57176931318*y[100] - 10.2713736253513*y[103] - 39.6392229058202*y[102] - 23.284964480954*y[105] - 24.9575997948692*y[104] - 10.2713736253513*y[107] - 39.6392229058202*y[106] - 108.131545536521*y[109] - 211.14353862636*y[108] + 20.5427472507027*y[111] + 79.2784458116403*y[110] + 46.569928961908*y[113] + 49.9151995897384*y[112] + 20.5427472507027*y[115] + 79.2784458116403*y[114] + 54.0657727682604*y[117] + 105.57176931318*y[116] - 10.2713736253513*y[119] - 39.6392229058202*y[118] - 23.284964480954*y[121] - 24.9575997948692*y[120] - 10.2713736253513*y[123] - 39.6392229058202*y[122]
    g_run[109] = 105.57176931318*y[101] - 54.0657727682604*y[100] - 39.6392229058202*y[103] + 10.2713736253513*y[102] - 24.9575997948692*y[105] + 23.284964480954*y[104] - 39.6392229058202*y[107] + 10.2713736253513*y[106] - 211.14353862636*y[109] + 108.131545536521*y[108] + 79.2784458116403*y[111] - 20.5427472507027*y[110] + 49.9151995897384*y[113] - 46.569928961908*y[112] + 79.2784458116403*y[115] - 20.5427472507027*y[114] + 105.57176931318*y[117] - 54.0657727682604*y[116] - 39.6392229058202*y[119] + 10.2713736253513*y[118] - 24.9575997948692*y[121] + 23.284964480954*y[120] - 39.6392229058202*y[123] + 10.2713736253513*y[122]
    g_run[110] = -10.2713736253513*y[101] - 39.6392229058202*y[100] + 54.0657727682604*y[103] + 105.57176931318*y[102] - 10.2713736253513*y[105] - 39.6392229058201*y[104] - 23.284964480954*y[107] - 24.9575997948692*y[106] + 20.5427472507027*y[109] + 79.2784458116403*y[108] - 108.131545536521*y[111] - 211.14353862636*y[110] + 20.5427472507027*y[113] + 79.2784458116403*y[112] + 46.569928961908*y[115] + 49.9151995897384*y[114] - 10.2713736253513*y[117] - 39.6392229058202*y[116] + 54.0657727682604*y[119] + 105.57176931318*y[118] - 10.2713736253513*y[121] - 39.6392229058201*y[120] - 23.284964480954*y[123] - 24.9575997948692*y[122]
    g_run[111] = -39.6392229058202*y[101] + 10.2713736253513*y[100] + 105.57176931318*y[103] - 54.0657727682604*y[102] - 39.6392229058201*y[105] + 10.2713736253513*y[104] - 24.9575997948692*y[107] + 23.284964480954*y[106] + 79.2784458116403*y[109] - 20.5427472507027*y[108] - 211.14353862636*y[111] + 108.131545536521*y[110] + 79.2784458116403*y[113] - 20.5427472507027*y[112] + 49.9151995897384*y[115] - 46.569928961908*y[114] - 39.6392229058202*y[117] + 10.2713736253513*y[116] + 105.57176931318*y[119] - 54.0657727682604*y[118] - 39.6392229058201*y[121] + 10.2713736253513*y[120] - 24.9575997948692*y[123] + 23.284964480954*y[122]
    g_run[112] = -23.284964480954*y[101] - 24.9575997948692*y[100] - 10.2713736253513*y[103] - 39.6392229058202*y[102] + 54.0657727682604*y[105] + 105.57176931318*y[104] - 10.2713736253514*y[107] - 39.6392229058201*y[106] + 46.569928961908*y[109] + 49.9151995897384*y[108] + 20.5427472507027*y[111] + 79.2784458116404*y[110] - 108.131545536521*y[113] - 211.14353862636*y[112] + 20.5427472507027*y[115] + 79.2784458116403*y[114] - 23.284964480954*y[117] - 24.9575997948692*y[116] - 10.2713736253513*y[119] - 39.6392229058202*y[118] + 54.0657727682604*y[121] + 105.57176931318*y[120] - 10.2713736253514*y[123] - 39.6392229058201*y[122]
    g_run[113] = -24.9575997948692*y[101] + 23.284964480954*y[100] - 39.6392229058202*y[103] + 10.2713736253513*y[102] + 105.57176931318*y[105] - 54.0657727682604*y[104] - 39.6392229058201*y[107] + 10.2713736253514*y[106] + 49.9151995897384*y[109] - 46.569928961908*y[108] + 79.2784458116404*y[111] - 20.5427472507027*y[110] - 211.14353862636*y[113] + 108.131545536521*y[112] + 79.2784458116403*y[115] - 20.5427472507027*y[114] - 24.9575997948692*y[117] + 23.284964480954*y[116] - 39.6392229058202*y[119] + 10.2713736253513*y[118] + 105.57176931318*y[121] - 54.0657727682604*y[120] - 39.6392229058201*y[123] + 10.2713736253514*y[122]
    g_run[114] = -10.2713736253513*y[101] - 39.6392229058202*y[100] - 23.284964480954*y[103] - 24.9575997948692*y[102] - 10.2713736253513*y[105] - 39.6392229058202*y[104] + 54.0657727682604*y[107] + 105.57176931318*y[106] + 20.5427472507027*y[109] + 79.2784458116403*y[108] + 46.569928961908*y[111] + 49.9151995897384*y[110] + 20.5427472507027*y[113] + 79.2784458116403*y[112] - 108.131545536521*y[115] - 211.14353862636*y[114] - 10.2713736253513*y[117] - 39.6392229058202*y[116] - 23.284964480954*y[119] - 24.9575997948692*y[118] - 10.2713736253513*y[121] - 39.6392229058202*y[120] + 54.0657727682604*y[123] + 105.57176931318*y[122]
    g_run[115] = -39.6392229058202*y[101] + 10.2713736253513*y[100] - 24.9575997948692*y[103] + 23.284964480954*y[102] - 39.6392229058202*y[105] + 10.2713736253513*y[104] + 105.57176931318*y[107] - 54.0657727682604*y[106] + 79.2784458116403*y[109] - 20.5427472507027*y[108] + 49.9151995897384*y[111] - 46.569928961908*y[110] + 79.2784458116403*y[113] - 20.5427472507027*y[112] - 211.14353862636*y[115] + 108.131545536521*y[114] - 39.6392229058202*y[117] + 10.2713736253513*y[116] - 24.9575997948692*y[119] + 23.284964480954*y[118] - 39.6392229058202*y[121] + 10.2713736253513*y[120] + 105.57176931318*y[123] - 54.0657727682604*y[122]
    g_run[116] = 54.0657727682604*y[109] + 105.57176931318*y[108] - 10.2713736253513*y[111] - 39.6392229058202*y[110] - 23.284964480954*y[113] - 24.9575997948692*y[112] - 10.2713736253513*y[115] - 39.6392229058202*y[114] - 108.131545536521*y[117] - 211.14353862636*y[116] + 20.5427472507027*y[119] + 79.2784458116403*y[118] + 46.569928961908*y[121] + 49.9151995897384*y[120] + 20.5427472507027*y[123] + 79.2784458116403*y[122] + 54.0657727682604*y[125] + 105.57176931318*y[124] - 10.2713736253513*y[127] - 39.6392229058202*y[126] - 23.284964480954*y[129] - 24.9575997948692*y[128] - 10.2713736253513*y[131] - 39.6392229058202*y[130]
    g_run[117] = 105.57176931318*y[109] - 54.0657727682604*y[108] - 39.6392229058202*y[111] + 10.2713736253513*y[110] - 24.9575997948692*y[113] + 23.284964480954*y[112] - 39.6392229058202*y[115] + 10.2713736253513*y[114] - 211.14353862636*y[117] + 108.131545536521*y[116] + 79.2784458116403*y[119] - 20.5427472507027*y[118] + 49.9151995897384*y[121] - 46.569928961908*y[120] + 79.2784458116403*y[123] - 20.5427472507027*y[122] + 105.57176931318*y[125] - 54.0657727682604*y[124] - 39.6392229058202*y[127] + 10.2713736253513*y[126] - 24.9575997948692*y[129] + 23.284964480954*y[128] - 39.6392229058202*y[131] + 10.2713736253513*y[130]
    g_run[118] = -10.2713736253513*y[109] - 39.6392229058202*y[108] + 54.0657727682604*y[111] + 105.57176931318*y[110] - 10.2713736253513*y[113] - 39.6392229058201*y[112] - 23.284964480954*y[115] - 24.9575997948692*y[114] + 20.5427472507027*y[117] + 79.2784458116403*y[116] - 108.131545536521*y[119] - 211.14353862636*y[118] + 20.5427472507027*y[121] + 79.2784458116403*y[120] + 46.569928961908*y[123] + 49.9151995897384*y[122] - 10.2713736253513*y[125] - 39.6392229058202*y[124] + 54.0657727682604*y[127] + 105.57176931318*y[126] - 10.2713736253513*y[129] - 39.6392229058201*y[128] - 23.284964480954*y[131] - 24.9575997948692*y[130]
    g_run[119] = -39.6392229058202*y[109] + 10.2713736253513*y[108] + 105.57176931318*y[111] - 54.0657727682604*y[110] - 39.6392229058201*y[113] + 10.2713736253513*y[112] - 24.9575997948692*y[115] + 23.284964480954*y[114] + 79.2784458116403*y[117] - 20.5427472507027*y[116] - 211.14353862636*y[119] + 108.131545536521*y[118] + 79.2784458116403*y[121] - 20.5427472507027*y[120] + 49.9151995897384*y[123] - 46.569928961908*y[122] - 39.6392229058202*y[125] + 10.2713736253513*y[124] + 105.57176931318*y[127] - 54.0657727682604*y[126] - 39.6392229058201*y[129] + 10.2713736253513*y[128] - 24.9575997948692*y[131] + 23.284964480954*y[130]
    g_run[120] = -23.284964480954*y[109] - 24.9575997948692*y[108] - 10.2713736253513*y[111] - 39.6392229058202*y[110] + 54.0657727682604*y[113] + 105.57176931318*y[112] - 10.2713736253514*y[115] - 39.6392229058201*y[114] + 46.569928961908*y[117] + 49.9151995897384*y[116] + 20.5427472507027*y[119] + 79.2784458116404*y[118] - 108.131545536521*y[121] - 211.14353862636*y[120] + 20.5427472507027*y[123] + 79.2784458116403*y[122] - 23.284964480954*y[125] - 24.9575997948692*y[124] - 10.2713736253513*y[127] - 39.6392229058202*y[126] + 54.0657727682604*y[129] + 105.57176931318*y[128] - 10.2713736253514*y[131] - 39.6392229058201*y[130]
    g_run[121] = -24.9575997948692*y[109] + 23.284964480954*y[108] - 39.6392229058202*y[111] + 10.2713736253513*y[110] + 105.57176931318*y[113] - 54.0657727682604*y[112] - 39.6392229058201*y[115] + 10.2713736253514*y[114] + 49.9151995897384*y[117] - 46.569928961908*y[116] + 79.2784458116404*y[119] - 20.5427472507027*y[118] - 211.14353862636*y[121] + 108.131545536521*y[120] + 79.2784458116403*y[123] - 20.5427472507027*y[122] - 24.9575997948692*y[125] + 23.284964480954*y[124] - 39.6392229058202*y[127] + 10.2713736253513*y[126] + 105.57176931318*y[129] - 54.0657727682604*y[128] - 39.6392229058201*y[131] + 10.2713736253514*y[130]
    g_run[122] = -10.2713736253513*y[109] - 39.6392229058202*y[108] - 23.284964480954*y[111] - 24.9575997948692*y[110] - 10.2713736253513*y[113] - 39.6392229058202*y[112] + 54.0657727682604*y[115] + 105.57176931318*y[114] + 20.5427472507027*y[117] + 79.2784458116403*y[116] + 46.569928961908*y[119] + 49.9151995897384*y[118] + 20.5427472507027*y[121] + 79.2784458116403*y[120] - 108.131545536521*y[123] - 211.16853862636*y[122] - 10.2713736253513*y[125] - 39.6392229058202*y[124] - 23.284964480954*y[127] - 24.9575997948692*y[126] - 10.2713736253513*y[129] - 39.6392229058202*y[128] + 54.0657727682604*y[131] + 105.57176931318*y[130]
    g_run[123] = -39.6392229058202*y[109] + 10.2713736253513*y[108] - 24.9575997948692*y[111] + 23.284964480954*y[110] - 39.6392229058202*y[113] + 10.2713736253513*y[112] + 105.57176931318*y[115] - 54.0657727682604*y[114] + 79.2784458116403*y[117] - 20.5427472507027*y[116] + 49.9151995897384*y[119] - 46.569928961908*y[118] + 79.2784458116403*y[121] - 20.5427472507027*y[120] - 211.16853862636*y[123] + 108.131545536521*y[122] - 39.6392229058202*y[125] + 10.2713736253513*y[124] - 24.9575997948692*y[127] + 23.284964480954*y[126] - 39.6392229058202*y[129] + 10.2713736253513*y[128] + 105.57176931318*y[131] - 54.0657727682604*y[130]
    g_run[124] = 54.0657727682604*y[133] + 105.57176931318*y[132] - 10.2713736253513*y[135] - 39.6392229058202*y[134] - 23.284964480954*y[137] - 24.9575997948692*y[136] - 10.2713736253513*y[139] - 39.6392229058202*y[138] + 5.65456401516768*y[33] + 30.9517475172273*y[32] + 1.84896616921897*y[35] - 9.21038227100566*y[34] + 0.793238195499529*y[37] - 9.00835072044485*y[36] + 1.84896616921897*y[39] - 9.21038227100566*y[38] + 54.0657727682604*y[117] + 105.57176931318*y[116] - 10.2713736253513*y[119] - 39.6392229058202*y[118] - 23.284964480954*y[121] - 24.9575997948692*y[120] - 10.2713736253513*y[123] - 39.6392229058202*y[122] - 113.786109551688*y[125] - 242.095286143588*y[124] + 18.6937810814837*y[127] + 88.488828082646*y[126] + 45.7766907664085*y[129] + 58.9235503101833*y[128] + 18.6937810814837*y[131] + 88.488828082646*y[130]
    g_run[125] = 105.57176931318*y[133] - 54.0657727682604*y[132] - 39.6392229058202*y[135] + 10.2713736253513*y[134] - 24.9575997948692*y[137] + 23.284964480954*y[136] - 39.6392229058202*y[139] + 10.2713736253513*y[138] + 30.9517475172273*y[33] - 5.65456401516768*y[32] - 9.21038227100566*y[35] - 1.84896616921897*y[34] - 9.00835072044485*y[37] - 0.793238195499529*y[36] - 9.21038227100566*y[39] - 1.84896616921897*y[38] + 105.57176931318*y[117] - 54.0657727682604*y[116] - 39.6392229058202*y[119] + 10.2713736253513*y[118] - 24.9575997948692*y[121] + 23.284964480954*y[120] - 39.6392229058202*y[123] + 10.2713736253513*y[122] - 242.095286143588*y[125] + 113.786109551688*y[124] + 88.488828082646*y[127] - 18.6937810814837*y[126] + 58.9235503101833*y[129] - 45.7766907664085*y[128] + 88.488828082646*y[131] - 18.6937810814837*y[130]
    g_run[126] = -10.2713736253513*y[133] - 39.6392229058202*y[132] + 54.0657727682604*y[135] + 105.57176931318*y[134] - 10.2713736253513*y[137] - 39.6392229058201*y[136] - 23.284964480954*y[139] - 24.9575997948692*y[138] + 1.84896616921897*y[33] - 9.21038227100566*y[32] + 5.65456401516768*y[35] + 30.9517475172273*y[34] + 1.84896616921897*y[37] - 9.21038227100566*y[36] + 0.793238195499528*y[39] - 9.00835072044485*y[38] - 10.2713736253513*y[117] - 39.6392229058202*y[116] + 54.0657727682604*y[119] + 105.57176931318*y[118] - 10.2713736253513*y[121] - 39.6392229058201*y[120] - 23.284964480954*y[123] - 24.9575997948692*y[122] + 18.6937810814837*y[125] + 88.488828082646*y[124] - 113.786109551688*y[127] - 242.095286143588*y[126] + 18.6937810814837*y[129] + 88.488828082646*y[128] + 45.7766907664085*y[131] + 58.9235503101833*y[130]
    g_run[127] = -39.6392229058202*y[133] + 10.2713736253513*y[132] + 105.57176931318*y[135] - 54.0657727682604*y[134] - 39.6392229058201*y[137] + 10.2713736253513*y[136] - 24.9575997948692*y[139] + 23.284964480954*y[138] - 9.21038227100566*y[33] - 1.84896616921897*y[32] + 30.9517475172273*y[35] - 5.65456401516768*y[34] - 9.21038227100566*y[37] - 1.84896616921897*y[36] - 9.00835072044485*y[39] - 0.793238195499528*y[38] - 39.6392229058202*y[117] + 10.2713736253513*y[116] + 105.57176931318*y[119] - 54.0657727682604*y[118] - 39.6392229058201*y[121] + 10.2713736253513*y[120] - 24.9575997948692*y[123] + 23.284964480954*y[122] + 88.488828082646*y[125] - 18.6937810814837*y[124] - 242.095286143588*y[127] + 113.786109551688*y[126] + 88.488828082646*y[129] - 18.6937810814837*y[128] + 58.9235503101833*y[131] - 45.7766907664085*y[130]
    g_run[128] = -23.284964480954*y[133] - 24.9575997948692*y[132] - 10.2713736253513*y[135] - 39.6392229058202*y[134] + 54.0657727682604*y[137] + 105.57176931318*y[136] - 10.2713736253514*y[139] - 39.6392229058201*y[138] + 0.793238195499527*y[33] - 9.00835072044484*y[32] + 1.84896616921897*y[35] - 9.21038227100566*y[34] + 5.65456401516768*y[37] + 30.9517475172273*y[36] + 1.84896616921897*y[39] - 9.21038227100566*y[38] - 23.284964480954*y[117] - 24.9575997948692*y[116] - 10.2713736253513*y[119] - 39.6392229058202*y[118] + 54.0657727682604*y[121] + 105.57176931318*y[120] - 10.2713736253514*y[123] - 39.6392229058201*y[122] + 45.7766907664085*y[125] + 58.9235503101833*y[124] + 18.6937810814837*y[127] + 88.4888280826461*y[126] - 113.786109551688*y[129] - 242.095286143588*y[128] + 18.6937810814837*y[131] + 88.4888280826459*y[130]
    g_run[129] = -24.9575997948692*y[133] + 23.284964480954*y[132] - 39.6392229058202*y[135] + 10.2713736253513*y[134] + 105.57176931318*y[137] - 54.0657727682604*y[136] - 39.6392229058201*y[139] + 10.2713736253514*y[138] - 9.00835072044484*y[33] - 0.793238195499527*y[32] - 9.21038227100566*y[35] - 1.84896616921897*y[34] + 30.9517475172273*y[37] - 5.65456401516768*y[36] - 9.21038227100566*y[39] - 1.84896616921897*y[38] - 24.9575997948692*y[117] + 23.284964480954*y[116] - 39.6392229058202*y[119] + 10.2713736253513*y[118] + 105.57176931318*y[121] - 54.0657727682604*y[120] - 39.6392229058201*y[123] + 10.2713736253514*y[122] + 58.9235503101833*y[125] - 45.7766907664085*y[124] + 88.4888280826461*y[127] - 18.6937810814837*y[126] - 242.095286143588*y[129] + 113.786109551688*y[128] + 88.4888280826459*y[131] - 18.6937810814837*y[130]
    g_run[130] = -10.2713736253513*y[133] - 39.6392229058202*y[132] - 23.284964480954*y[135] - 24.9575997948692*y[134] - 10.2713736253513*y[137] - 39.6392229058202*y[136] + 54.0657727682604*y[139] + 105.57176931318*y[138] + 1.84896616921897*y[33] - 9.21038227100566*y[32] + 0.793238195499527*y[35] - 9.00835072044485*y[34] + 1.84896616921897*y[37] - 9.21038227100566*y[36] + 5.65456401516768*y[39] + 30.9517475172273*y[38] - 10.2713736253513*y[117] - 39.6392229058202*y[116] - 23.284964480954*y[119] - 24.9575997948692*y[118] - 10.2713736253513*y[121] - 39.6392229058202*y[120] + 54.0657727682604*y[123] + 105.57176931318*y[122] + 18.6937810814837*y[125] + 88.488828082646*y[124] + 45.7766907664085*y[127] + 58.9235503101832*y[126] + 18.6937810814837*y[129] + 88.488828082646*y[128] - 113.786109551688*y[131] - 242.095286143588*y[130]
    g_run[131] = -39.6392229058202*y[133] + 10.2713736253513*y[132] - 24.9575997948692*y[135] + 23.284964480954*y[134] - 39.6392229058202*y[137] + 10.2713736253513*y[136] + 105.57176931318*y[139] - 54.0657727682604*y[138] - 9.21038227100566*y[33] - 1.84896616921897*y[32] - 9.00835072044485*y[35] - 0.793238195499527*y[34] - 9.21038227100566*y[37] - 1.84896616921897*y[36] + 30.9517475172273*y[39] - 5.65456401516768*y[38] - 39.6392229058202*y[117] + 10.2713736253513*y[116] - 24.9575997948692*y[119] + 23.284964480954*y[118] - 39.6392229058202*y[121] + 10.2713736253513*y[120] + 105.57176931318*y[123] - 54.0657727682604*y[122] + 88.488828082646*y[125] - 18.6937810814837*y[124] + 58.9235503101832*y[127] - 45.7766907664085*y[126] + 88.488828082646*y[129] - 18.6937810814837*y[128] - 242.095286143588*y[131] + 113.786109551688*y[130]
    g_run[132] = y[413] - 59.7203367834281*y[133] - 136.523516830407*y[132] + 8.42240745613237*y[135] + 48.8496051768258*y[134] + 22.4917262854545*y[137] + 33.9659505153141*y[136] + 8.42240745613237*y[139] + 48.8496051768258*y[138] + 5.65456401516768*y[41] + 30.9517475172273*y[40] + 1.84896616921897*y[43] - 9.21038227100566*y[42] + 0.793238195499529*y[45] - 9.00835072044485*y[44] + 1.84896616921897*y[47] - 9.21038227100566*y[46] + 54.0657727682604*y[125] + 105.57176931318*y[124] - 10.2713736253513*y[127] - 39.6392229058202*y[126] - 23.284964480954*y[129] - 24.9575997948692*y[128] - 10.2713736253513*y[131] - 39.6392229058202*y[130]
    g_run[133] = y[414] - 136.523516830407*y[133] + 59.7203367834281*y[132] + 48.8496051768258*y[135] - 8.42240745613237*y[134] + 33.9659505153141*y[137] - 22.4917262854545*y[136] + 48.8496051768258*y[139] - 8.42240745613237*y[138] + 30.9517475172273*y[41] - 5.65456401516768*y[40] - 9.21038227100566*y[43] - 1.84896616921897*y[42] - 9.00835072044485*y[45] - 0.793238195499529*y[44] - 9.21038227100566*y[47] - 1.84896616921897*y[46] + 105.57176931318*y[125] - 54.0657727682604*y[124] - 39.6392229058202*y[127] + 10.2713736253513*y[126] - 24.9575997948692*y[129] + 23.284964480954*y[128] - 39.6392229058202*y[131] + 10.2713736253513*y[130]
    g_run[134] = y[415] + 8.42240745613237*y[133] + 48.8496051768258*y[132] - 59.720336783428*y[135] - 136.523516830407*y[134] + 8.42240745613238*y[137] + 48.8496051768258*y[136] + 22.4917262854545*y[139] + 33.9659505153141*y[138] + 1.84896616921897*y[41] - 9.21038227100566*y[40] + 5.65456401516768*y[43] + 30.9517475172273*y[42] + 1.84896616921897*y[45] - 9.21038227100566*y[44] + 0.793238195499528*y[47] - 9.00835072044485*y[46] - 10.2713736253513*y[125] - 39.6392229058202*y[124] + 54.0657727682604*y[127] + 105.57176931318*y[126] - 10.2713736253513*y[129] - 39.6392229058201*y[128] - 23.284964480954*y[131] - 24.9575997948692*y[130]
    g_run[135] = y[416] + 48.8496051768258*y[133] - 8.42240745613237*y[132] - 136.523516830407*y[135] + 59.720336783428*y[134] + 48.8496051768258*y[137] - 8.42240745613238*y[136] + 33.9659505153141*y[139] - 22.4917262854545*y[138] - 9.21038227100566*y[41] - 1.84896616921897*y[40] + 30.9517475172273*y[43] - 5.65456401516768*y[42] - 9.21038227100566*y[45] - 1.84896616921897*y[44] - 9.00835072044485*y[47] - 0.793238195499528*y[46] - 39.6392229058202*y[125] + 10.2713736253513*y[124] + 105.57176931318*y[127] - 54.0657727682604*y[126] - 39.6392229058201*y[129] + 10.2713736253513*y[128] - 24.9575997948692*y[131] + 23.284964480954*y[130]
    g_run[136] = y[417] + 22.4917262854545*y[133] + 33.9659505153141*y[132] + 8.42240745613236*y[135] + 48.8496051768259*y[134] - 59.7203367834281*y[137] - 136.523516830407*y[136] + 8.42240745613239*y[139] + 48.8496051768258*y[138] + 0.793238195499527*y[41] - 9.00835072044484*y[40] + 1.84896616921897*y[43] - 9.21038227100566*y[42] + 5.65456401516768*y[45] + 30.9517475172273*y[44] + 1.84896616921897*y[47] - 9.21038227100566*y[46] - 23.284964480954*y[125] - 24.9575997948692*y[124] - 10.2713736253513*y[127] - 39.6392229058202*y[126] + 54.0657727682604*y[129] + 105.57176931318*y[128] - 10.2713736253514*y[131] - 39.6392229058201*y[130]
    g_run[137] = y[418] + 33.9659505153141*y[133] - 22.4917262854545*y[132] + 48.8496051768259*y[135] - 8.42240745613236*y[134] - 136.523516830407*y[137] + 59.7203367834281*y[136] + 48.8496051768258*y[139] - 8.42240745613239*y[138] - 9.00835072044484*y[41] - 0.793238195499527*y[40] - 9.21038227100566*y[43] - 1.84896616921897*y[42] + 30.9517475172273*y[45] - 5.65456401516768*y[44] - 9.21038227100566*y[47] - 1.84896616921897*y[46] - 24.9575997948692*y[125] + 23.284964480954*y[124] - 39.6392229058202*y[127] + 10.2713736253513*y[126] + 105.57176931318*y[129] - 54.0657727682604*y[128] - 39.6392229058201*y[131] + 10.2713736253514*y[130]
    g_run[138] = 8.42240745613237*y[133] + 48.8496051768258*y[132] + 22.4917262854545*y[135] + 33.965950515314*y[134] + 8.42240745613237*y[137] + 48.8496051768258*y[136] - 59.7203367834281*y[139] - 136.548516830407*y[138] + 1.84896616921897*y[41] - 9.21038227100566*y[40] + 0.793238195499527*y[43] - 9.00835072044485*y[42] + 1.84896616921897*y[45] - 9.21038227100566*y[44] + 5.65456401516768*y[47] + 30.9517475172273*y[46] - 10.2713736253513*y[125] - 39.6392229058202*y[124] - 23.284964480954*y[127] - 24.9575997948692*y[126] - 10.2713736253513*y[129] - 39.6392229058202*y[128] + 54.0657727682604*y[131] + 105.57176931318*y[130]
    g_run[139] = 48.8496051768258*y[133] - 8.42240745613237*y[132] + 33.965950515314*y[135] - 22.4917262854545*y[134] + 48.8496051768258*y[137] - 8.42240745613237*y[136] - 136.548516830407*y[139] + 59.7203367834281*y[138] - 9.21038227100566*y[41] - 1.84896616921897*y[40] - 9.00835072044485*y[43] - 0.793238195499527*y[42] - 9.21038227100566*y[45] - 1.84896616921897*y[44] + 30.9517475172273*y[47] - 5.65456401516768*y[46] - 39.6392229058202*y[125] + 10.2713736253513*y[124] - 24.9575997948692*y[127] + 23.284964480954*y[126] - 39.6392229058202*y[129] + 10.2713736253513*y[128] + 105.57176931318*y[131] - 54.0657727682604*y[130]
    g_run[140] = -9.69353831171601*y[141] - 53.0601386009611*y[140] - 3.16965629008966*y[143] + 15.7892267502954*y[142] - 1.35983690657062*y[145] + 15.442886949334*y[144] - 3.16965629008966*y[147] + 15.7892267502954*y[146] + 4.84676915585801*y[149] + 26.5300693004806*y[148] + 1.58482814504483*y[151] - 7.8946133751477*y[150] + 0.67991845328531*y[153] - 7.72144347466701*y[152] + 1.58482814504483*y[155] - 7.89461337514771*y[154] + 4.84676915585801*y[85] + 26.5300693004806*y[84] + 1.58482814504483*y[87] - 7.8946133751477*y[86] + 0.67991845328531*y[89] - 7.72144347466701*y[88] + 1.58482814504483*y[91] - 7.89461337514771*y[90]
    g_run[141] = -53.0601386009611*y[141] + 9.69353831171601*y[140] + 15.7892267502954*y[143] + 3.16965629008966*y[142] + 15.442886949334*y[145] + 1.35983690657062*y[144] + 15.7892267502954*y[147] + 3.16965629008966*y[146] + 26.5300693004806*y[149] - 4.84676915585801*y[148] - 7.8946133751477*y[151] - 1.58482814504483*y[150] - 7.72144347466701*y[153] - 0.67991845328531*y[152] - 7.89461337514771*y[155] - 1.58482814504483*y[154] + 26.5300693004806*y[85] - 4.84676915585801*y[84] - 7.8946133751477*y[87] - 1.58482814504483*y[86] - 7.72144347466701*y[89] - 0.67991845328531*y[88] - 7.89461337514771*y[91] - 1.58482814504483*y[90]
    g_run[142] = -3.16965629008966*y[141] + 15.7892267502954*y[140] - 9.69353831171602*y[143] - 53.0601386009611*y[142] - 3.16965629008967*y[145] + 15.7892267502954*y[144] - 1.35983690657062*y[147] + 15.442886949334*y[146] + 1.58482814504483*y[149] - 7.89461337514771*y[148] + 4.84676915585801*y[151] + 26.5300693004806*y[150] + 1.58482814504483*y[153] - 7.89461337514771*y[152] + 0.679918453285308*y[155] - 7.72144347466701*y[154] + 1.58482814504483*y[85] - 7.89461337514771*y[84] + 4.84676915585801*y[87] + 26.5300693004806*y[86] + 1.58482814504483*y[89] - 7.89461337514771*y[88] + 0.679918453285308*y[91] - 7.72144347466701*y[90]
    g_run[143] = 15.7892267502954*y[141] + 3.16965629008966*y[140] - 53.0601386009611*y[143] + 9.69353831171602*y[142] + 15.7892267502954*y[145] + 3.16965629008967*y[144] + 15.442886949334*y[147] + 1.35983690657062*y[146] - 7.89461337514771*y[149] - 1.58482814504483*y[148] + 26.5300693004806*y[151] - 4.84676915585801*y[150] - 7.89461337514771*y[153] - 1.58482814504483*y[152] - 7.72144347466701*y[155] - 0.679918453285308*y[154] - 7.89461337514771*y[85] - 1.58482814504483*y[84] + 26.5300693004806*y[87] - 4.84676915585801*y[86] - 7.89461337514771*y[89] - 1.58482814504483*y[88] - 7.72144347466701*y[91] - 0.679918453285308*y[90]
    g_run[144] = -1.35983690657062*y[141] + 15.442886949334*y[140] - 3.16965629008966*y[143] + 15.7892267502954*y[142] - 9.69353831171602*y[145] - 53.0601386009611*y[144] - 3.16965629008967*y[147] + 15.7892267502954*y[146] + 0.67991845328531*y[149] - 7.72144347466701*y[148] + 1.58482814504483*y[151] - 7.8946133751477*y[150] + 4.84676915585801*y[153] + 26.5300693004806*y[152] + 1.58482814504483*y[155] - 7.89461337514771*y[154] + 0.67991845328531*y[85] - 7.72144347466701*y[84] + 1.58482814504483*y[87] - 7.8946133751477*y[86] + 4.84676915585801*y[89] + 26.5300693004806*y[88] + 1.58482814504483*y[91] - 7.89461337514771*y[90]
    g_run[145] = 15.442886949334*y[141] + 1.35983690657062*y[140] + 15.7892267502954*y[143] + 3.16965629008966*y[142] - 53.0601386009611*y[145] + 9.69353831171602*y[144] + 15.7892267502954*y[147] + 3.16965629008967*y[146] - 7.72144347466701*y[149] - 0.67991845328531*y[148] - 7.8946133751477*y[151] - 1.58482814504483*y[150] + 26.5300693004806*y[153] - 4.84676915585801*y[152] - 7.89461337514771*y[155] - 1.58482814504483*y[154] - 7.72144347466701*y[85] - 0.67991845328531*y[84] - 7.8946133751477*y[87] - 1.58482814504483*y[86] + 26.5300693004806*y[89] - 4.84676915585801*y[88] - 7.89461337514771*y[91] - 1.58482814504483*y[90]
    g_run[146] = -3.16965629008966*y[141] + 15.7892267502954*y[140] - 1.35983690657062*y[143] + 15.442886949334*y[142] - 3.16965629008966*y[145] + 15.7892267502954*y[144] - 9.69353831171602*y[147] - 53.0601386009611*y[146] + 1.58482814504483*y[149] - 7.89461337514771*y[148] + 0.679918453285308*y[151] - 7.72144347466701*y[150] + 1.58482814504483*y[153] - 7.89461337514771*y[152] + 4.84676915585801*y[155] + 26.5300693004806*y[154] + 1.58482814504483*y[85] - 7.89461337514771*y[84] + 0.679918453285308*y[87] - 7.72144347466701*y[86] + 1.58482814504483*y[89] - 7.89461337514771*y[88] + 4.84676915585801*y[91] + 26.5300693004806*y[90]
    g_run[147] = 15.7892267502954*y[141] + 3.16965629008966*y[140] + 15.442886949334*y[143] + 1.35983690657062*y[142] + 15.7892267502954*y[145] + 3.16965629008966*y[144] - 53.0601386009611*y[147] + 9.69353831171602*y[146] - 7.89461337514771*y[149] - 1.58482814504483*y[148] - 7.72144347466701*y[151] - 0.679918453285308*y[150] - 7.89461337514771*y[153] - 1.58482814504483*y[152] + 26.5300693004806*y[155] - 4.84676915585801*y[154] - 7.89461337514771*y[85] - 1.58482814504483*y[84] - 7.72144347466701*y[87] - 0.679918453285308*y[86] - 7.89461337514771*y[89] - 1.58482814504483*y[88] + 26.5300693004806*y[91] - 4.84676915585801*y[90]
    g_run[148] = 4.84676915585801*y[141] + 26.5300693004806*y[140] + 1.58482814504483*y[143] - 7.8946133751477*y[142] + 0.67991845328531*y[145] - 7.72144347466701*y[144] + 1.58482814504483*y[147] - 7.89461337514771*y[146] - 9.69353831171601*y[149] - 53.0601386009611*y[148] - 3.16965629008966*y[151] + 15.7892267502954*y[150] - 1.35983690657062*y[153] + 15.442886949334*y[152] - 3.16965629008966*y[155] + 15.7892267502954*y[154] + 4.84676915585801*y[157] + 26.5300693004806*y[156] + 1.58482814504483*y[159] - 7.8946133751477*y[158] + 0.67991845328531*y[161] - 7.72144347466701*y[160] + 1.58482814504483*y[163] - 7.89461337514771*y[162]
    g_run[149] = 26.5300693004806*y[141] - 4.84676915585801*y[140] - 7.8946133751477*y[143] - 1.58482814504483*y[142] - 7.72144347466701*y[145] - 0.67991845328531*y[144] - 7.89461337514771*y[147] - 1.58482814504483*y[146] - 53.0601386009611*y[149] + 9.69353831171601*y[148] + 15.7892267502954*y[151] + 3.16965629008966*y[150] + 15.442886949334*y[153] + 1.35983690657062*y[152] + 15.7892267502954*y[155] + 3.16965629008966*y[154] + 26.5300693004806*y[157] - 4.84676915585801*y[156] - 7.8946133751477*y[159] - 1.58482814504483*y[158] - 7.72144347466701*y[161] - 0.67991845328531*y[160] - 7.89461337514771*y[163] - 1.58482814504483*y[162]
    g_run[150] = 1.58482814504483*y[141] - 7.89461337514771*y[140] + 4.84676915585801*y[143] + 26.5300693004806*y[142] + 1.58482814504483*y[145] - 7.89461337514771*y[144] + 0.679918453285308*y[147] - 7.72144347466701*y[146] - 3.16965629008966*y[149] + 15.7892267502954*y[148] - 9.69353831171602*y[151] - 53.0601386009611*y[150] - 3.16965629008967*y[153] + 15.7892267502954*y[152] - 1.35983690657062*y[155] + 15.442886949334*y[154] + 1.58482814504483*y[157] - 7.89461337514771*y[156] + 4.84676915585801*y[159] + 26.5300693004806*y[158] + 1.58482814504483*y[161] - 7.89461337514771*y[160] + 0.679918453285308*y[163] - 7.72144347466701*y[162]
    g_run[151] = -7.89461337514771*y[141] - 1.58482814504483*y[140] + 26.5300693004806*y[143] - 4.84676915585801*y[142] - 7.89461337514771*y[145] - 1.58482814504483*y[144] - 7.72144347466701*y[147] - 0.679918453285308*y[146] + 15.7892267502954*y[149] + 3.16965629008966*y[148] - 53.0601386009611*y[151] + 9.69353831171602*y[150] + 15.7892267502954*y[153] + 3.16965629008967*y[152] + 15.442886949334*y[155] + 1.35983690657062*y[154] - 7.89461337514771*y[157] - 1.58482814504483*y[156] + 26.5300693004806*y[159] - 4.84676915585801*y[158] - 7.89461337514771*y[161] - 1.58482814504483*y[160] - 7.72144347466701*y[163] - 0.679918453285308*y[162]
    g_run[152] = 0.67991845328531*y[141] - 7.72144347466701*y[140] + 1.58482814504483*y[143] - 7.8946133751477*y[142] + 4.84676915585801*y[145] + 26.5300693004806*y[144] + 1.58482814504483*y[147] - 7.89461337514771*y[146] - 1.35983690657062*y[149] + 15.442886949334*y[148] - 3.16965629008966*y[151] + 15.7892267502954*y[150] - 9.69353831171602*y[153] - 53.0601386009611*y[152] - 3.16965629008967*y[155] + 15.7892267502954*y[154] + 0.67991845328531*y[157] - 7.72144347466701*y[156] + 1.58482814504483*y[159] - 7.8946133751477*y[158] + 4.84676915585801*y[161] + 26.5300693004806*y[160] + 1.58482814504483*y[163] - 7.89461337514771*y[162]
    g_run[153] = -7.72144347466701*y[141] - 0.67991845328531*y[140] - 7.8946133751477*y[143] - 1.58482814504483*y[142] + 26.5300693004806*y[145] - 4.84676915585801*y[144] - 7.89461337514771*y[147] - 1.58482814504483*y[146] + 15.442886949334*y[149] + 1.35983690657062*y[148] + 15.7892267502954*y[151] + 3.16965629008966*y[150] - 53.0601386009611*y[153] + 9.69353831171602*y[152] + 15.7892267502954*y[155] + 3.16965629008967*y[154] - 7.72144347466701*y[157] - 0.67991845328531*y[156] - 7.8946133751477*y[159] - 1.58482814504483*y[158] + 26.5300693004806*y[161] - 4.84676915585801*y[160] - 7.89461337514771*y[163] - 1.58482814504483*y[162]
    g_run[154] = 1.58482814504483*y[141] - 7.89461337514771*y[140] + 0.679918453285308*y[143] - 7.72144347466701*y[142] + 1.58482814504483*y[145] - 7.89461337514771*y[144] + 4.84676915585801*y[147] + 26.5300693004806*y[146] - 3.16965629008966*y[149] + 15.7892267502954*y[148] - 1.35983690657062*y[151] + 15.442886949334*y[150] - 3.16965629008966*y[153] + 15.7892267502954*y[152] - 9.69353831171602*y[155] - 53.0851386009611*y[154] + 1.58482814504483*y[157] - 7.89461337514771*y[156] + 0.679918453285308*y[159] - 7.72144347466701*y[158] + 1.58482814504483*y[161] - 7.89461337514771*y[160] + 4.84676915585801*y[163] + 26.5300693004806*y[162]
    g_run[155] = -7.89461337514771*y[141] - 1.58482814504483*y[140] - 7.72144347466701*y[143] - 0.679918453285308*y[142] - 7.89461337514771*y[145] - 1.58482814504483*y[144] + 26.5300693004806*y[147] - 4.84676915585801*y[146] + 15.7892267502954*y[149] + 3.16965629008966*y[148] + 15.442886949334*y[151] + 1.35983690657062*y[150] + 15.7892267502954*y[153] + 3.16965629008966*y[152] - 53.0851386009611*y[155] + 9.69353831171602*y[154] - 7.89461337514771*y[157] - 1.58482814504483*y[156] - 7.72144347466701*y[159] - 0.679918453285308*y[158] - 7.89461337514771*y[161] - 1.58482814504483*y[160] + 26.5300693004806*y[163] - 4.84676915585801*y[162]
    g_run[156] = y[423] + 4.84676915585801*y[149] + 26.5300693004806*y[148] + 1.58482814504483*y[151] - 7.8946133751477*y[150] + 0.67991845328531*y[153] - 7.72144347466701*y[152] + 1.58482814504483*y[155] - 7.89461337514771*y[154] - 9.69353831171601*y[157] - 53.0601386009611*y[156] - 3.16965629008966*y[159] + 15.7892267502954*y[158] - 1.35983690657062*y[161] + 15.442886949334*y[160] - 3.16965629008966*y[163] + 15.7892267502954*y[162] + 4.84676915585801*y[17] + 26.5300693004806*y[16] + 1.58482814504483*y[19] - 7.8946133751477*y[18] + 0.67991845328531*y[21] - 7.72144347466701*y[20] + 1.58482814504483*y[23] - 7.89461337514771*y[22]
    g_run[157] = y[424] + 26.5300693004806*y[149] - 4.84676915585801*y[148] - 7.8946133751477*y[151] - 1.58482814504483*y[150] - 7.72144347466701*y[153] - 0.67991845328531*y[152] - 7.89461337514771*y[155] - 1.58482814504483*y[154] - 53.0601386009611*y[157] + 9.69353831171601*y[156] + 15.7892267502954*y[159] + 3.16965629008966*y[158] + 15.442886949334*y[161] + 1.35983690657062*y[160] + 15.7892267502954*y[163] + 3.16965629008966*y[162] + 26.5300693004806*y[17] - 4.84676915585801*y[16] - 7.8946133751477*y[19] - 1.58482814504483*y[18] - 7.72144347466701*y[21] - 0.67991845328531*y[20] - 7.89461337514771*y[23] - 1.58482814504483*y[22]
    g_run[158] = y[425] + 1.58482814504483*y[149] - 7.89461337514771*y[148] + 4.84676915585801*y[151] + 26.5300693004806*y[150] + 1.58482814504483*y[153] - 7.89461337514771*y[152] + 0.679918453285308*y[155] - 7.72144347466701*y[154] - 3.16965629008966*y[157] + 15.7892267502954*y[156] - 9.69353831171602*y[159] - 53.0601386009611*y[158] - 3.16965629008967*y[161] + 15.7892267502954*y[160] - 1.35983690657062*y[163] + 15.442886949334*y[162] + 1.58482814504483*y[17] - 7.89461337514771*y[16] + 4.84676915585801*y[19] + 26.5300693004806*y[18] + 1.58482814504483*y[21] - 7.89461337514771*y[20] + 0.679918453285308*y[23] - 7.72144347466701*y[22]
    g_run[159] = y[426] - 7.89461337514771*y[149] - 1.58482814504483*y[148] + 26.5300693004806*y[151] - 4.84676915585801*y[150] - 7.89461337514771*y[153] - 1.58482814504483*y[152] - 7.72144347466701*y[155] - 0.679918453285308*y[154] + 15.7892267502954*y[157] + 3.16965629008966*y[156] - 53.0601386009611*y[159] + 9.69353831171602*y[158] + 15.7892267502954*y[161] + 3.16965629008967*y[160] + 15.442886949334*y[163] + 1.35983690657062*y[162] - 7.89461337514771*y[17] - 1.58482814504483*y[16] + 26.5300693004806*y[19] - 4.84676915585801*y[18] - 7.89461337514771*y[21] - 1.58482814504483*y[20] - 7.72144347466701*y[23] - 0.679918453285308*y[22]
    g_run[160] = y[427] + 0.67991845328531*y[149] - 7.72144347466701*y[148] + 1.58482814504483*y[151] - 7.8946133751477*y[150] + 4.84676915585801*y[153] + 26.5300693004806*y[152] + 1.58482814504483*y[155] - 7.89461337514771*y[154] - 1.35983690657062*y[157] + 15.442886949334*y[156] - 3.16965629008966*y[159] + 15.7892267502954*y[158] - 9.69353831171602*y[161] - 53.0601386009611*y[160] - 3.16965629008967*y[163] + 15.7892267502954*y[162] + 0.67991845328531*y[17] - 7.72144347466701*y[16] + 1.58482814504483*y[19] - 7.8946133751477*y[18] + 4.84676915585801*y[21] + 26.5300693004806*y[20] + 1.58482814504483*y[23] - 7.89461337514771*y[22]
    g_run[161] = y[428] - 7.72144347466701*y[149] - 0.67991845328531*y[148] - 7.8946133751477*y[151] - 1.58482814504483*y[150] + 26.5300693004806*y[153] - 4.84676915585801*y[152] - 7.89461337514771*y[155] - 1.58482814504483*y[154] + 15.442886949334*y[157] + 1.35983690657062*y[156] + 15.7892267502954*y[159] + 3.16965629008966*y[158] - 53.0601386009611*y[161] + 9.69353831171602*y[160] + 15.7892267502954*y[163] + 3.16965629008967*y[162] - 7.72144347466701*y[17] - 0.67991845328531*y[16] - 7.8946133751477*y[19] - 1.58482814504483*y[18] + 26.5300693004806*y[21] - 4.84676915585801*y[20] - 7.89461337514771*y[23] - 1.58482814504483*y[22]
    g_run[162] = 1.58482814504483*y[149] - 7.89461337514771*y[148] + 0.679918453285308*y[151] - 7.72144347466701*y[150] + 1.58482814504483*y[153] - 7.89461337514771*y[152] + 4.84676915585801*y[155] + 26.5300693004806*y[154] - 3.16965629008966*y[157] + 15.7892267502954*y[156] - 1.35983690657062*y[159] + 15.442886949334*y[158] - 3.16965629008966*y[161] + 15.7892267502954*y[160] - 9.69353831171602*y[163] - 53.0601386009611*y[162] + 1.58482814504483*y[17] - 7.89461337514771*y[16] + 0.679918453285308*y[19] - 7.72144347466701*y[18] + 1.58482814504483*y[21] - 7.89461337514771*y[20] + 4.84676915585801*y[23] + 26.5300693004806*y[22]
    g_run[163] = -7.89461337514771*y[149] - 1.58482814504483*y[148] - 7.72144347466701*y[151] - 0.679918453285308*y[150] - 7.89461337514771*y[153] - 1.58482814504483*y[152] + 26.5300693004806*y[155] - 4.84676915585801*y[154] + 15.7892267502954*y[157] + 3.16965629008966*y[156] + 15.442886949334*y[159] + 1.35983690657062*y[158] + 15.7892267502954*y[161] + 3.16965629008966*y[160] - 53.0601386009611*y[163] + 9.69353831171602*y[162] - 7.89461337514771*y[17] - 1.58482814504483*y[16] - 7.72144347466701*y[19] - 0.679918453285308*y[18] - 7.89461337514771*y[21] - 1.58482814504483*y[20] + 26.5300693004806*y[23] - 4.84676915585801*y[22]
    g_run[164] = -1067.7048070413*y[164] + 67.7048070412999*y[172]
    g_run[165] = -1067.7048070413*y[165] + 67.7048070412999*y[173]
    g_run[166] = 157.977883096366*y[52] + 67.7048070412999*u[6] - 361.092304220266*y[166] + 135.4096140826*y[174]
    g_run[167] = 157.977883096366*y[53] + 67.7048070412999*u[7] - 361.092304220266*y[167] + 135.4096140826*y[175]
    g_run[168] = 157.977883096366*y[206] + 67.7048070412999*u[8] - 361.092304220266*y[168] + 135.4096140826*y[176]
    g_run[169] = 157.977883096366*y[207] + 67.7048070412999*u[9] - 361.092304220266*y[169] + 135.4096140826*y[177]
    g_run[170] = 157.977883096366*y[208] + 67.7048070412999*u[10] - 361.092304220266*y[170] + 135.4096140826*y[178]
    g_run[171] = 157.977883096366*y[209] + 67.7048070412999*u[11] - 361.092304220266*y[171] + 135.4096140826*y[179]
    g_run[172] = 157.977883096366*y[54] + 67.7048070412999*y[164] - 361.092304220266*y[172] + 135.4096140826*y[180]
    g_run[173] = 157.977883096366*y[55] + 67.7048070412999*y[165] - 361.092304220266*y[173] + 135.4096140826*y[181]
    g_run[174] = 45.1365380275333*y[222] + 135.4096140826*y[166] - 248.250959151433*y[174] + 67.7048070412999*y[182]
    g_run[175] = 45.1365380275333*y[223] + 135.4096140826*y[167] - 248.250959151433*y[175] + 67.7048070412999*y[183]
    g_run[176] = 45.1365380275333*y[224] + 135.4096140826*y[168] - 248.250959151433*y[176] + 67.7048070412999*y[184]
    g_run[177] = 45.1365380275333*y[225] + 135.4096140826*y[169] - 248.250959151433*y[177] + 67.7048070412999*y[185]
    g_run[178] = 45.1365380275333*y[226] + 135.4096140826*y[170] - 248.250959151433*y[178] + 67.7048070412999*y[186]
    g_run[179] = 45.1365380275333*y[227] + 135.4096140826*y[171] - 248.250959151433*y[179] + 67.7048070412999*y[187]
    g_run[180] = 45.1365380275333*y[228] + 135.4096140826*y[172] - 248.250959151433*y[180] + 67.7048070412999*y[188]
    g_run[181] = 45.1365380275333*y[229] + 135.4096140826*y[173] - 248.250959151433*y[181] + 67.7048070412999*y[189]
    g_run[182] = 157.977883096366*y[56] + 67.7048070412999*y[174] - 270.8192281652*y[182] + 45.1365380275333*y[190]
    g_run[183] = 157.977883096366*y[57] + 67.7048070412999*y[175] - 270.8192281652*y[183] + 45.1365380275333*y[191]
    g_run[184] = 157.977883096366*y[210] + 67.7048070412999*y[176] - 270.8192281652*y[184] + 45.1365380275333*y[192]
    g_run[185] = 157.977883096366*y[211] + 67.7048070412999*y[177] - 270.8192281652*y[185] + 45.1365380275333*y[193]
    g_run[186] = 157.977883096366*y[212] + 67.7048070412999*y[178] - 270.8192281652*y[186] + 45.1365380275333*y[194]
    g_run[187] = 157.977883096366*y[213] + 67.7048070412999*y[179] - 270.8192281652*y[187] + 45.1365380275333*y[195]
    g_run[188] = 157.977883096366*y[58] + 67.7048070412999*y[180] - 270.8192281652*y[188] + 45.1365380275333*y[196]
    g_run[189] = 157.977883096366*y[59] + 67.7048070412999*y[181] - 270.8192281652*y[189] + 45.1365380275333*y[197]
    g_run[190] = 157.977883096366*y[198] + 157.977883096366*y[60] + 45.1365380275333*y[182] - 361.092304220266*y[190]
    g_run[191] = 157.977883096366*y[199] + 157.977883096366*y[61] + 45.1365380275333*y[183] - 361.092304220266*y[191]
    g_run[192] = 157.977883096366*y[200] + 157.977883096366*y[214] + 45.1365380275333*y[184] - 361.092304220266*y[192]
    g_run[193] = 157.977883096366*y[201] + 157.977883096366*y[215] + 45.1365380275333*y[185] - 361.092304220266*y[193]
    g_run[194] = 157.977883096366*y[202] + 157.977883096366*y[216] + 45.1365380275333*y[186] - 361.092304220266*y[194]
    g_run[195] = 157.977883096366*y[203] + 157.977883096366*y[217] + 45.1365380275333*y[187] - 361.092304220266*y[195]
    g_run[196] = 157.977883096366*y[204] + 157.977883096366*y[62] + 45.1365380275333*y[188] - 361.092304220266*y[196]
    g_run[197] = 157.977883096366*y[205] + 157.977883096366*y[63] + 45.1365380275333*y[189] - 361.092304220266*y[197]
    g_run[198] = y[419] - 315.955766192733*y[198] + 157.977883096366*y[64] + 157.977883096366*y[190]
    g_run[199] = -315.955766192733*y[199] + 157.977883096366*y[65] + 157.977883096366*y[191]
    g_run[200] = -315.955766192733*y[200] + 157.977883096366*y[218] + 157.977883096366*y[192]
    g_run[201] = -315.955766192733*y[201] + 157.977883096366*y[219] + 157.977883096366*y[193]
    g_run[202] = -315.955766192733*y[202] + 157.977883096366*y[220] + 157.977883096366*y[194]
    g_run[203] = -315.955766192733*y[203] + 157.977883096366*y[221] + 157.977883096366*y[195]
    g_run[204] = y[420] - 315.955766192733*y[204] + 157.977883096366*y[66] + 157.977883096366*y[196]
    g_run[205] = -315.955766192733*y[205] + 157.977883096366*y[67] + 157.977883096366*y[197]
    g_run[206] = -157.977883096366*y[206] + 157.977883096366*y[168]
    g_run[207] = -157.977883096366*y[207] + 157.977883096366*y[169]
    g_run[208] = -157.977883096366*y[208] + 157.977883096366*y[170]
    g_run[209] = -157.977883096366*y[209] + 157.977883096366*y[171]
    g_run[210] = -157.977883096366*y[210] + 157.977883096366*y[184]
    g_run[211] = -157.977883096366*y[211] + 157.977883096366*y[185]
    g_run[212] = -157.977883096366*y[212] + 157.977883096366*y[186]
    g_run[213] = -157.977883096366*y[213] + 157.977883096366*y[187]
    g_run[214] = -157.977883096366*y[214] + 157.977883096366*y[192]
    g_run[215] = -157.977883096366*y[215] + 157.977883096366*y[193]
    g_run[216] = -157.977883096366*y[216] + 157.977883096366*y[194]
    g_run[217] = -157.977883096366*y[217] + 157.977883096366*y[195]
    g_run[218] = 157.977883096366*y[200] - 157.977883096366*y[218]
    g_run[219] = 157.977883096366*y[201] - 157.977883096366*y[219]
    g_run[220] = 157.977883096366*y[202] - 157.977883096366*y[220]
    g_run[221] = 157.977883096366*y[203] - 157.977883096366*y[221]
    g_run[222] = y[429] - 180.546152110133*y[222] + 135.4096140826*y[48] + 45.1365380275333*y[174]
    g_run[223] = -180.546152110133*y[223] + 135.4096140826*y[49] + 45.1365380275333*y[175]
    g_run[224] = -180.546152110133*y[224] + 135.4096140826*y[230] + 45.1365380275333*y[176]
    g_run[225] = -180.546152110133*y[225] + 135.4096140826*y[231] + 45.1365380275333*y[177]
    g_run[226] = -180.546152110133*y[226] + 135.4096140826*y[232] + 45.1365380275333*y[178]
    g_run[227] = -180.546152110133*y[227] + 135.4096140826*y[233] + 45.1365380275333*y[179]
    g_run[228] = y[430] - 180.546152110133*y[228] + 135.4096140826*y[50] + 45.1365380275333*y[180]
    g_run[229] = -180.546152110133*y[229] + 135.4096140826*y[51] + 45.1365380275333*y[181]
    g_run[230] = 135.4096140826*y[224] - 135.4096140826*y[230]
    g_run[231] = 135.4096140826*y[225] - 135.4096140826*y[231]
    g_run[232] = 135.4096140826*y[226] - 135.4096140826*y[232]
    g_run[233] = 135.4096140826*y[227] - 135.4096140826*y[233]
    g_run[234] = -y[234] + 0.0196078431372549*u[1] + 0.00490196078431373*u[0] - 0.00980392156862745*u[3] - 0.00245098039215686*u[2] - 0.00980392156862745*u[5] - 0.00245098039215686*u[4] - 0.849044513514155*y[1] - 0.212261128378539*y[0] + 0.849044513514155*y[3] + 0.212261128378539*y[2]
    g_run[235] = -y[235] + 0.00490196078431373*u[1] - 0.0196078431372549*u[0] - 0.00245098039215686*u[3] + 0.00980392156862745*u[2] - 0.00245098039215686*u[5] + 0.00980392156862745*u[4] - 0.212261128378539*y[1] + 0.849044513514155*y[0] + 0.212261128378539*y[3] - 0.849044513514155*y[2]
    g_run[236] = -y[236] - 0.00980392156862745*u[1] - 0.00245098039215686*u[0] + 0.0196078431372549*u[3] + 0.00490196078431373*u[2] - 0.00980392156862745*u[5] - 0.00245098039215686*u[4] - 0.849044513514155*y[3] - 0.212261128378539*y[2] + 0.849044513514155*y[5] + 0.212261128378539*y[4]
    g_run[237] = -y[237] - 0.00245098039215686*u[1] + 0.00980392156862745*u[0] + 0.00490196078431373*u[3] - 0.0196078431372549*u[2] - 0.00245098039215686*u[5] + 0.00980392156862745*u[4] - 0.212261128378539*y[3] + 0.849044513514155*y[2] + 0.212261128378539*y[5] - 0.849044513514155*y[4]
    g_run[238] = -y[238] - 0.00980392156862745*u[1] - 0.00245098039215686*u[0] - 0.00980392156862745*u[3] - 0.00245098039215686*u[2] + 0.0196078431372549*u[5] + 0.00490196078431373*u[4] + 0.849044513514155*y[1] + 0.212261128378539*y[0] - 0.849044513514155*y[5] - 0.212261128378539*y[4]
    g_run[239] = -y[239] - 0.00245098039215686*u[1] + 0.00980392156862745*u[0] - 0.00245098039215686*u[3] + 0.00980392156862745*u[2] + 0.00490196078431373*u[5] - 0.0196078431372549*u[4] + 0.212261128378539*y[1] - 0.849044513514155*y[0] - 0.212261128378539*y[5] + 0.849044513514155*y[4]
    g_run[240] = -y[240] + 54.0657727682604*y[1] + 105.57176931318*y[0] - 10.2713736253513*y[3] - 39.6392229058202*y[2] - 23.284964480954*y[5] - 24.9575997948692*y[4] - 10.2713736253513*y[7] - 39.6392229058202*y[6] - 54.0657727682604*y[69] - 105.57176931318*y[68] + 10.2713736253513*y[71] + 39.6392229058202*y[70] + 23.284964480954*y[73] + 24.9575997948692*y[72] + 10.2713736253513*y[75] + 39.6392229058202*y[74]
    g_run[241] = -y[241] + 105.57176931318*y[1] - 54.0657727682604*y[0] - 39.6392229058202*y[3] + 10.2713736253513*y[2] - 24.9575997948692*y[5] + 23.284964480954*y[4] - 39.6392229058202*y[7] + 10.2713736253513*y[6] - 105.57176931318*y[69] + 54.0657727682604*y[68] + 39.6392229058202*y[71] - 10.2713736253513*y[70] + 24.9575997948692*y[73] - 23.284964480954*y[72] + 39.6392229058202*y[75] - 10.2713736253513*y[74]
    g_run[242] = -y[242] - 10.2713736253513*y[1] - 39.6392229058202*y[0] + 54.0657727682604*y[3] + 105.57176931318*y[2] - 10.2713736253513*y[5] - 39.6392229058201*y[4] - 23.284964480954*y[7] - 24.9575997948692*y[6] + 10.2713736253513*y[69] + 39.6392229058202*y[68] - 54.0657727682604*y[71] - 105.57176931318*y[70] + 10.2713736253513*y[73] + 39.6392229058201*y[72] + 23.284964480954*y[75] + 24.9575997948692*y[74]
    g_run[243] = -y[243] - 39.6392229058202*y[1] + 10.2713736253513*y[0] + 105.57176931318*y[3] - 54.0657727682604*y[2] - 39.6392229058201*y[5] + 10.2713736253513*y[4] - 24.9575997948692*y[7] + 23.284964480954*y[6] + 39.6392229058202*y[69] - 10.2713736253513*y[68] - 105.57176931318*y[71] + 54.0657727682604*y[70] + 39.6392229058201*y[73] - 10.2713736253513*y[72] + 24.9575997948692*y[75] - 23.284964480954*y[74]
    g_run[244] = -y[244] - 23.284964480954*y[1] - 24.9575997948692*y[0] - 10.2713736253513*y[3] - 39.6392229058202*y[2] + 54.0657727682604*y[5] + 105.57176931318*y[4] - 10.2713736253514*y[7] - 39.6392229058201*y[6] + 23.284964480954*y[69] + 24.9575997948692*y[68] + 10.2713736253513*y[71] + 39.6392229058202*y[70] - 54.0657727682604*y[73] - 105.57176931318*y[72] + 10.2713736253514*y[75] + 39.6392229058201*y[74]
    g_run[245] = -y[245] - 24.9575997948692*y[1] + 23.284964480954*y[0] - 39.6392229058202*y[3] + 10.2713736253513*y[2] + 105.57176931318*y[5] - 54.0657727682604*y[4] - 39.6392229058201*y[7] + 10.2713736253514*y[6] + 24.9575997948692*y[69] - 23.284964480954*y[68] + 39.6392229058202*y[71] - 10.2713736253513*y[70] - 105.57176931318*y[73] + 54.0657727682604*y[72] + 39.6392229058201*y[75] - 10.2713736253514*y[74]
    g_run[246] = y[240] + y[242] + y[244] - y[246]
    g_run[247] = y[241] + y[243] + y[245] - y[247]
    g_run[248] = -y[248] + 67.7048070412999*u[6] - 67.7048070412999*y[166]
    g_run[249] = -y[249] + 67.7048070412999*u[7] - 67.7048070412999*y[167]
    g_run[250] = -y[250] + 67.7048070412999*u[8] - 67.7048070412999*y[168]
    g_run[251] = -y[251] + 67.7048070412999*u[9] - 67.7048070412999*y[169]
    g_run[252] = -y[252] + 67.7048070412999*u[10] - 67.7048070412999*y[170]
    g_run[253] = -y[253] + 67.7048070412999*u[11] - 67.7048070412999*y[171]
    g_run[254] = y[248] + y[250] + y[252] - y[254]
    g_run[255] = y[249] + y[251] + y[253] - y[255]
    g_run[256] = -y[256] + 135.4096140826*y[166] - 135.4096140826*y[174]
    g_run[257] = -y[257] + 135.4096140826*y[167] - 135.4096140826*y[175]
    g_run[258] = -y[258] + 135.4096140826*y[168] - 135.4096140826*y[176]
    g_run[259] = -y[259] + 135.4096140826*y[169] - 135.4096140826*y[177]
    g_run[260] = -y[260] + 135.4096140826*y[170] - 135.4096140826*y[178]
    g_run[261] = -y[261] + 135.4096140826*y[171] - 135.4096140826*y[179]
    g_run[262] = y[256] + y[258] + y[260] - y[262]
    g_run[263] = y[257] + y[259] + y[261] - y[263]
    g_run[264] = -y[264] + 67.7048070412999*y[174] - 67.7048070412999*y[182]
    g_run[265] = -y[265] + 67.7048070412999*y[175] - 67.7048070412999*y[183]
    g_run[266] = -y[266] + 67.7048070412999*y[176] - 67.7048070412999*y[184]
    g_run[267] = -y[267] + 67.7048070412999*y[177] - 67.7048070412999*y[185]
    g_run[268] = -y[268] + 67.7048070412999*y[178] - 67.7048070412999*y[186]
    g_run[269] = -y[269] + 67.7048070412999*y[179] - 67.7048070412999*y[187]
    g_run[270] = y[264] + y[266] + y[268] - y[270]
    g_run[271] = y[265] + y[267] + y[269] - y[271]
    g_run[272] = -y[272] + 45.1365380275333*y[182] - 45.1365380275333*y[190]
    g_run[273] = -y[273] + 45.1365380275333*y[183] - 45.1365380275333*y[191]
    g_run[274] = -y[274] + 45.1365380275333*y[184] - 45.1365380275333*y[192]
    g_run[275] = -y[275] + 45.1365380275333*y[185] - 45.1365380275333*y[193]
    g_run[276] = -y[276] + 45.1365380275333*y[186] - 45.1365380275333*y[194]
    g_run[277] = -y[277] + 45.1365380275333*y[187] - 45.1365380275333*y[195]
    g_run[278] = y[272] + y[274] + y[276] - y[278]
    g_run[279] = y[273] + y[275] + y[277] - y[279]
    g_run[280] = -y[280] - 157.977883096366*y[198] + 157.977883096366*y[190]
    g_run[281] = -y[281] - 157.977883096366*y[199] + 157.977883096366*y[191]
    g_run[282] = -y[282] - 157.977883096366*y[200] + 157.977883096366*y[192]
    g_run[283] = -y[283] - 157.977883096366*y[201] + 157.977883096366*y[193]
    g_run[284] = -y[284] - 157.977883096366*y[202] + 157.977883096366*y[194]
    g_run[285] = -y[285] - 157.977883096366*y[203] + 157.977883096366*y[195]
    g_run[286] = y[280] + y[282] + y[284] - y[286]
    g_run[287] = y[281] + y[283] + y[285] - y[287]
    g_run[288] = -y[288] - 157.977883096366*y[52] + 157.977883096366*y[166]
    g_run[289] = -y[289] - 157.977883096366*y[53] + 157.977883096366*y[167]
    g_run[290] = -y[290] - 157.977883096366*y[206] + 157.977883096366*y[168]
    g_run[291] = -y[291] - 157.977883096366*y[207] + 157.977883096366*y[169]
    g_run[292] = -y[292] - 157.977883096366*y[208] + 157.977883096366*y[170]
    g_run[293] = -y[293] - 157.977883096366*y[209] + 157.977883096366*y[171]
    g_run[294] = y[288] + y[290] + y[292] - y[294]
    g_run[295] = y[289] + y[291] + y[293] - y[295]
    g_run[296] = -y[296] - 157.977883096366*y[56] + 157.977883096366*y[182]
    g_run[297] = -y[297] - 157.977883096366*y[57] + 157.977883096366*y[183]
    g_run[298] = -y[298] - 157.977883096366*y[210] + 157.977883096366*y[184]
    g_run[299] = -y[299] - 157.977883096366*y[211] + 157.977883096366*y[185]
    g_run[300] = -y[300] - 157.977883096366*y[212] + 157.977883096366*y[186]
    g_run[301] = -y[301] - 157.977883096366*y[213] + 157.977883096366*y[187]
    g_run[302] = y[296] + y[298] + y[300] - y[302]
    g_run[303] = y[297] + y[299] + y[301] - y[303]
    g_run[304] = -y[304] - 157.977883096366*y[60] + 157.977883096366*y[190]
    g_run[305] = -y[305] - 157.977883096366*y[61] + 157.977883096366*y[191]
    g_run[306] = -y[306] - 157.977883096366*y[214] + 157.977883096366*y[192]
    g_run[307] = -y[307] - 157.977883096366*y[215] + 157.977883096366*y[193]
    g_run[308] = -y[308] - 157.977883096366*y[216] + 157.977883096366*y[194]
    g_run[309] = -y[309] - 157.977883096366*y[217] + 157.977883096366*y[195]
    g_run[310] = y[304] + y[306] + y[308] - y[310]
    g_run[311] = y[305] + y[307] + y[309] - y[311]
    g_run[312] = -y[312] + 157.977883096366*y[198] - 157.977883096366*y[64]
    g_run[313] = -y[313] + 157.977883096366*y[199] - 157.977883096366*y[65]
    g_run[314] = -y[314] + 157.977883096366*y[200] - 157.977883096366*y[218]
    g_run[315] = -y[315] + 157.977883096366*y[201] - 157.977883096366*y[219]
    g_run[316] = -y[316] + 157.977883096366*y[202] - 157.977883096366*y[220]
    g_run[317] = -y[317] + 157.977883096366*y[203] - 157.977883096366*y[221]
    g_run[318] = y[312] + y[314] + y[316] - y[318]
    g_run[319] = y[313] + y[315] + y[317] - y[319]
    g_run[320] = -y[320] - 45.1365380275333*y[222] + 45.1365380275333*y[174]
    g_run[321] = -y[321] - 45.1365380275333*y[223] + 45.1365380275333*y[175]
    g_run[322] = -y[322] - 45.1365380275333*y[224] + 45.1365380275333*y[176]
    g_run[323] = -y[323] - 45.1365380275333*y[225] + 45.1365380275333*y[177]
    g_run[324] = -y[324] - 45.1365380275333*y[226] + 45.1365380275333*y[178]
    g_run[325] = -y[325] - 45.1365380275333*y[227] + 45.1365380275333*y[179]
    g_run[326] = y[320] + y[322] + y[324] - y[326]
    g_run[327] = y[321] + y[323] + y[325] - y[327]
    g_run[328] = -y[328] + 135.4096140826*y[222] - 135.4096140826*y[48]
    g_run[329] = -y[329] + 135.4096140826*y[223] - 135.4096140826*y[49]
    g_run[330] = -y[330] + 135.4096140826*y[224] - 135.4096140826*y[230]
    g_run[331] = -y[331] + 135.4096140826*y[225] - 135.4096140826*y[231]
    g_run[332] = -y[332] + 135.4096140826*y[226] - 135.4096140826*y[232]
    g_run[333] = -y[333] + 135.4096140826*y[227] - 135.4096140826*y[233]
    g_run[334] = y[328] + y[330] + y[332] - y[334]
    g_run[335] = y[329] + y[331] + y[333] - y[335]
    g_run[336] = y[337]*y[1] - y[337]*y[7] + y[336]*y[0] - y[336]*y[6] - u[186]
    g_run[337] = y[339]*y[3] - y[339]*y[7] + y[338]*y[2] - y[338]*y[6] - u[188]
    g_run[338] = y[341]*y[5] - y[341]*y[7] + y[340]*y[4] - y[340]*y[6] - u[190]
    g_run[339] = -y[337]*y[0] + y[337]*y[6] + y[336]*y[1] - y[336]*y[7] - u[187]
    g_run[340] = -y[339]*y[2] + y[339]*y[6] + y[338]*y[3] - y[338]*y[7] - u[189]
    g_run[341] = -y[341]*y[4] + y[341]*y[6] + y[340]*y[5] - y[340]*y[7] - u[191]
    g_run[342] = y[336] + y[338] + y[340] + y[342]
    g_run[343] = y[337] + y[339] + y[341] + y[343]
    g_run[344] = y[345]*y[9] - y[345]*y[15] + y[344]*y[8] - y[344]*y[14] - u[192]
    g_run[345] = y[347]*y[11] - y[347]*y[15] + y[346]*y[10] - y[346]*y[14] - u[194]
    g_run[346] = y[349]*y[13] - y[349]*y[15] + y[348]*y[12] - y[348]*y[14] - u[196]
    g_run[347] = -y[345]*y[8] + y[345]*y[14] + y[344]*y[9] - y[344]*y[15] - u[193]
    g_run[348] = -y[347]*y[10] + y[347]*y[14] + y[346]*y[11] - y[346]*y[15] - u[195]
    g_run[349] = -y[349]*y[12] + y[349]*y[14] + y[348]*y[13] - y[348]*y[15] - u[197]
    g_run[350] = y[344] + y[346] + y[348] + y[350]
    g_run[351] = y[345] + y[347] + y[349] + y[351]
    g_run[352] = y[353]*y[17] - y[353]*y[23] + y[352]*y[16] - y[352]*y[22] - u[198]
    g_run[353] = y[355]*y[19] - y[355]*y[23] + y[354]*y[18] - y[354]*y[22] - u[200]
    g_run[354] = y[357]*y[21] - y[357]*y[23] + y[356]*y[20] - y[356]*y[22] - u[202]
    g_run[355] = -y[353]*y[16] + y[353]*y[22] + y[352]*y[17] - y[352]*y[23] - u[199]
    g_run[356] = -y[355]*y[18] + y[355]*y[22] + y[354]*y[19] - y[354]*y[23] - u[201]
    g_run[357] = -y[357]*y[20] + y[357]*y[22] + y[356]*y[21] - y[356]*y[23] - u[203]
    g_run[358] = y[352] + y[354] + y[356] + y[358]
    g_run[359] = y[353] + y[355] + y[357] + y[359]
    g_run[360] = y[361]*y[25] - y[361]*y[31] + y[360]*y[24] - y[360]*y[30] - u[204]
    g_run[361] = y[363]*y[27] - y[363]*y[31] + y[362]*y[26] - y[362]*y[30] - u[206]
    g_run[362] = y[365]*y[29] - y[365]*y[31] + y[364]*y[28] - y[364]*y[30] - u[208]
    g_run[363] = -y[361]*y[24] + y[361]*y[30] + y[360]*y[25] - y[360]*y[31] - u[205]
    g_run[364] = -y[363]*y[26] + y[363]*y[30] + y[362]*y[27] - y[362]*y[31] - u[207]
    g_run[365] = -y[365]*y[28] + y[365]*y[30] + y[364]*y[29] - y[364]*y[31] - u[209]
    g_run[366] = y[360] + y[362] + y[364] + y[366]
    g_run[367] = y[361] + y[363] + y[365] + y[367]
    g_run[368] = y[369]*y[33] - y[369]*y[39] + y[368]*y[32] - y[368]*y[38] - u[210]
    g_run[369] = y[371]*y[35] - y[371]*y[39] + y[370]*y[34] - y[370]*y[38] - u[212]
    g_run[370] = y[373]*y[37] - y[373]*y[39] + y[372]*y[36] - y[372]*y[38] - u[214]
    g_run[371] = -y[369]*y[32] + y[369]*y[38] + y[368]*y[33] - y[368]*y[39] - u[211]
    g_run[372] = -y[371]*y[34] + y[371]*y[38] + y[370]*y[35] - y[370]*y[39] - u[213]
    g_run[373] = -y[373]*y[36] + y[373]*y[38] + y[372]*y[37] - y[372]*y[39] - u[215]
    g_run[374] = y[368] + y[370] + y[372] + y[374]
    g_run[375] = y[369] + y[371] + y[373] + y[375]
    g_run[376] = y[377]*y[41] - y[377]*y[47] + y[376]*y[40] - y[376]*y[46] - u[216]
    g_run[377] = y[379]*y[43] - y[379]*y[47] + y[378]*y[42] - y[378]*y[46] - u[218]
    g_run[378] = y[381]*y[45] - y[381]*y[47] + y[380]*y[44] - y[380]*y[46] - u[220]
    g_run[379] = -y[377]*y[40] + y[377]*y[46] + y[376]*y[41] - y[376]*y[47] - u[217]
    g_run[380] = -y[379]*y[42] + y[379]*y[46] + y[378]*y[43] - y[378]*y[47] - u[219]
    g_run[381] = -y[381]*y[44] + y[381]*y[46] + y[380]*y[45] - y[380]*y[47] - u[221]
    g_run[382] = y[376] + y[378] + y[380] + y[382]
    g_run[383] = y[377] + y[379] + y[381] + y[383]
    g_run[384] = 1.0*y[385]*y[49] - 1.0*y[385]*y[51] + y[384]*y[48] - y[384]*y[50] - u[222]
    g_run[385] = -1.0*y[385]*y[48] + 1.0*y[385]*y[50] + 1.0*y[384]*y[49] - 1.0*y[384]*y[51] - u[223]
    g_run[386] = y[384] + y[386]
    g_run[387] = 1.0*y[385] + 1.0*y[387]
    g_run[388] = 1.0*y[389]*y[53] - 1.0*y[389]*y[55] + y[388]*y[52] - y[388]*y[54] - u[224]
    g_run[389] = -1.0*y[389]*y[52] + 1.0*y[389]*y[54] + 1.0*y[388]*y[53] - 1.0*y[388]*y[55] - u[225]
    g_run[390] = y[388] + y[390]
    g_run[391] = 1.0*y[389] + 1.0*y[391]
    g_run[392] = 1.0*y[393]*y[57] - 1.0*y[393]*y[59] + y[392]*y[56] - y[392]*y[58] - u[226]
    g_run[393] = -1.0*y[393]*y[56] + 1.0*y[393]*y[58] + 1.0*y[392]*y[57] - 1.0*y[392]*y[59] - u[227]
    g_run[394] = y[392] + y[394]
    g_run[395] = 1.0*y[393] + 1.0*y[395]
    g_run[396] = 1.0*y[397]*y[61] - 1.0*y[397]*y[63] + y[396]*y[60] - y[396]*y[62] - u[228]
    g_run[397] = -1.0*y[397]*y[60] + 1.0*y[397]*y[62] + 1.0*y[396]*y[61] - 1.0*y[396]*y[63] - u[229]
    g_run[398] = y[396] + y[398]
    g_run[399] = 1.0*y[397] + 1.0*y[399]
    g_run[400] = 1.0*y[401]*y[65] - 1.0*y[401]*y[67] + y[400]*y[64] - y[400]*y[66] - u[230]
    g_run[401] = -1.0*y[401]*y[64] + 1.0*y[401]*y[66] + 1.0*y[400]*y[65] - 1.0*y[400]*y[67] - u[231]
    g_run[402] = y[400] + y[402]
    g_run[403] = 1.0*y[401] + 1.0*y[403]
    g_run[404] = 1.0*y[405]*y[1] - 1.0*y[405]*y[7] + y[404]*y[0] - y[404]*y[6] - y[410]/3
    g_run[405] = -1.0*y[405]*y[0] + 1.0*y[405]*y[6] + 1.0*y[404]*y[1] - 1.0*y[404]*y[7] - u[233]/3
    g_run[406] = 1.0*y[407]*y[3] - 1.0*y[407]*y[7] + y[406]*y[2] - y[406]*y[6] - y[410]/3
    g_run[407] = -1.0*y[407]*y[2] + 1.0*y[407]*y[6] + 1.0*y[406]*y[3] - 1.0*y[406]*y[7] - u[233]/3
    g_run[408] = 1.0*y[409]*y[5] - 1.0*y[409]*y[7] + y[408]*y[4] - y[408]*y[6] - y[410]/3
    g_run[409] = -1.0*y[409]*y[4] + 1.0*y[409]*y[6] + 1.0*y[408]*y[5] - 1.0*y[408]*y[7] - u[233]/3
    g_run[410] = y[411] + y[410] + Piecewise(np.array([(-y[412], y[411] < 0), (y[412], True)]))
    g_run[411] = y[248]*u[6] + y[254]*y[164] - y[411]
    g_run[412] = -p[0] - p[1]*sqrt(y[405]**2 + y[404]**2 + 0.1) - p[2]*(y[405]**2 + y[404]**2 + 0.1) + y[412]
    g_run[413] = -p[6]*u[234] + 1.0*y[414]*y[133] - 1.0*y[414]*y[139] + y[413]*y[132] - y[413]*y[138]
    g_run[414] = -p[6]*u[235] - 1.0*y[414]*y[132] + 1.0*y[414]*y[138] + 1.0*y[413]*y[133] - 1.0*y[413]*y[139]
    g_run[415] = -p[7]*u[234] + 1.0*y[416]*y[135] - 1.0*y[416]*y[139] + y[415]*y[134] - y[415]*y[138]
    g_run[416] = -p[7]*u[235] - 1.0*y[416]*y[134] + 1.0*y[416]*y[138] + 1.0*y[415]*y[135] - 1.0*y[415]*y[139]
    g_run[417] = -p[8]*u[234] + 1.0*y[418]*y[137] - 1.0*y[418]*y[139] + y[417]*y[136] - y[417]*y[138]
    g_run[418] = -p[8]*u[235] - 1.0*y[418]*y[136] + 1.0*y[418]*y[138] + 1.0*y[417]*y[137] - 1.0*y[417]*y[139]
    g_run[419] = y[419] + y[421]/(y[198] - y[204] + 1.0e-8)
    g_run[420] = y[420] + y[421]/(-y[198] + y[204] + 1.0e-8)
    g_run[421] = y[421] - u[234] - Piecewise(np.array([(-y[422], y[421] < 0), (y[422], True)]))
    g_run[422] = -p[3] - p[4]*sqrt(y[414]**2 + y[413]**2 + 0.1) - p[5]*(y[414]**2 + y[413]**2 + 0.1) + y[422]
    g_run[423] = -p[12]*u[236] + 1.0*y[424]*y[157] - 1.0*y[424]*y[163] + y[423]*y[156] - y[423]*y[162]
    g_run[424] = -p[12]*u[237] - 1.0*y[424]*y[156] + 1.0*y[424]*y[162] + 1.0*y[423]*y[157] - 1.0*y[423]*y[163]
    g_run[425] = -p[13]*u[236] + 1.0*y[426]*y[159] - 1.0*y[426]*y[163] + y[425]*y[158] - y[425]*y[162]
    g_run[426] = -p[13]*u[237] - 1.0*y[426]*y[158] + 1.0*y[426]*y[162] + 1.0*y[425]*y[159] - 1.0*y[425]*y[163]
    g_run[427] = -p[14]*u[236] + 1.0*y[428]*y[161] - 1.0*y[428]*y[163] + y[427]*y[160] - y[427]*y[162]
    g_run[428] = -p[14]*u[237] - 1.0*y[428]*y[160] + 1.0*y[428]*y[162] + 1.0*y[427]*y[161] - 1.0*y[427]*y[163]
    g_run[429] = y[429] + y[431]/(y[222] - y[228] + 1.0e-8)
    g_run[430] = y[430] + y[431]/(-y[222] + y[228] + 1.0e-8)
    g_run[431] = y[431] - u[236] - Piecewise(np.array([(-y[432], y[431] < 0), (y[432], True)]))
    g_run[432] = -p[9] - p[10]*sqrt(y[424]**2 + y[423]**2 + 0.1) - p[11]*(y[424]**2 + y[423]**2 + 0.1) + y[432]





@cuda.jit(device=True)
def f_run_gpu(f_run,x,u,p):

    sin = math.sin
    cos = math.cos
    sqrt = math.sqrt
    abs = math.fabs

    f_run[0] = u[238] - x[0]





@cuda.jit(device=True)
def h_eval_gpu(z,x,u,p):

    sin = math.sin
    cos = math.cos
    sqrt = math.sqrt
    abs = math.fabs

    z[0] = (u[1]**2 + u[0]**2)**0.5
    z[1] = (u[3]**2 + u[2]**2)**0.5
    z[2] = (u[5]**2 + u[4]**2)**0.5
    z[3] = (u[7]**2 + u[6]**2)**0.5
    z[4] = (u[9]**2 + u[8]**2)**0.5
    z[5] = (u[11]**2 + u[10]**2)**0.5
    z[6] = (y[1]**2 + y[0]**2)**0.5
    z[7] = (y[3]**2 + y[2]**2)**0.5
    z[8] = (y[5]**2 + y[4]**2)**0.5
    z[9] = (y[7]**2 + y[6]**2)**0.5
    z[10] = (y[9]**2 + y[8]**2)**0.5
    z[11] = (y[11]**2 + y[10]**2)**0.5
    z[12] = (y[13]**2 + y[12]**2)**0.5
    z[13] = (y[15]**2 + y[14]**2)**0.5
    z[14] = (y[17]**2 + y[16]**2)**0.5
    z[15] = (y[19]**2 + y[18]**2)**0.5
    z[16] = (y[21]**2 + y[20]**2)**0.5
    z[17] = (y[23]**2 + y[22]**2)**0.5
    z[18] = (y[25]**2 + y[24]**2)**0.5
    z[19] = (y[27]**2 + y[26]**2)**0.5
    z[20] = (y[29]**2 + y[28]**2)**0.5
    z[21] = (y[31]**2 + y[30]**2)**0.5
    z[22] = (y[33]**2 + y[32]**2)**0.5
    z[23] = (y[35]**2 + y[34]**2)**0.5
    z[24] = (y[37]**2 + y[36]**2)**0.5
    z[25] = (y[39]**2 + y[38]**2)**0.5
    z[26] = (y[41]**2 + y[40]**2)**0.5
    z[27] = (y[43]**2 + y[42]**2)**0.5
    z[28] = (y[45]**2 + y[44]**2)**0.5
    z[29] = (y[47]**2 + y[46]**2)**0.5
    z[30] = (y[49]**2 + y[48]**2)**0.5
    z[31] = (y[51]**2 + y[50]**2)**0.5
    z[32] = (y[53]**2 + y[52]**2)**0.5
    z[33] = (y[55]**2 + y[54]**2)**0.5
    z[34] = (y[57]**2 + y[56]**2)**0.5
    z[35] = (y[59]**2 + y[58]**2)**0.5
    z[36] = (y[61]**2 + y[60]**2)**0.5
    z[37] = (y[63]**2 + y[62]**2)**0.5
    z[38] = (y[65]**2 + y[64]**2)**0.5
    z[39] = (y[67]**2 + y[66]**2)**0.5
    z[40] = (y[69]**2 + y[68]**2)**0.5
    z[41] = (y[71]**2 + y[70]**2)**0.5
    z[42] = (y[73]**2 + y[72]**2)**0.5
    z[43] = (y[75]**2 + y[74]**2)**0.5
    z[44] = (y[77]**2 + y[76]**2)**0.5
    z[45] = (y[79]**2 + y[78]**2)**0.5
    z[46] = (y[81]**2 + y[80]**2)**0.5
    z[47] = (y[83]**2 + y[82]**2)**0.5
    z[48] = (y[85]**2 + y[84]**2)**0.5
    z[49] = (y[87]**2 + y[86]**2)**0.5
    z[50] = (y[89]**2 + y[88]**2)**0.5
    z[51] = (y[91]**2 + y[90]**2)**0.5
    z[52] = (y[93]**2 + y[92]**2)**0.5
    z[53] = (y[95]**2 + y[94]**2)**0.5
    z[54] = (y[97]**2 + y[96]**2)**0.5
    z[55] = (y[99]**2 + y[98]**2)**0.5
    z[56] = (y[101]**2 + y[100]**2)**0.5
    z[57] = (y[103]**2 + y[102]**2)**0.5
    z[58] = (y[105]**2 + y[104]**2)**0.5
    z[59] = (y[107]**2 + y[106]**2)**0.5
    z[60] = (y[109]**2 + y[108]**2)**0.5
    z[61] = (y[111]**2 + y[110]**2)**0.5
    z[62] = (y[113]**2 + y[112]**2)**0.5
    z[63] = (y[115]**2 + y[114]**2)**0.5
    z[64] = (y[117]**2 + y[116]**2)**0.5
    z[65] = (y[119]**2 + y[118]**2)**0.5
    z[66] = (y[121]**2 + y[120]**2)**0.5
    z[67] = (y[123]**2 + y[122]**2)**0.5
    z[68] = (y[125]**2 + y[124]**2)**0.5
    z[69] = (y[127]**2 + y[126]**2)**0.5
    z[70] = (y[129]**2 + y[128]**2)**0.5
    z[71] = (y[131]**2 + y[130]**2)**0.5
    z[72] = (y[133]**2 + y[132]**2)**0.5
    z[73] = (y[135]**2 + y[134]**2)**0.5
    z[74] = (y[137]**2 + y[136]**2)**0.5
    z[75] = (y[139]**2 + y[138]**2)**0.5
    z[76] = (y[141]**2 + y[140]**2)**0.5
    z[77] = (y[143]**2 + y[142]**2)**0.5
    z[78] = (y[145]**2 + y[144]**2)**0.5
    z[79] = (y[147]**2 + y[146]**2)**0.5
    z[80] = (y[149]**2 + y[148]**2)**0.5
    z[81] = (y[151]**2 + y[150]**2)**0.5
    z[82] = (y[153]**2 + y[152]**2)**0.5
    z[83] = (y[155]**2 + y[154]**2)**0.5
    z[84] = (y[157]**2 + y[156]**2)**0.5
    z[85] = (y[159]**2 + y[158]**2)**0.5
    z[86] = (y[161]**2 + y[160]**2)**0.5
    z[87] = (y[163]**2 + y[162]**2)**0.5
    z[88] = (y[165]**2 + y[164]**2)**0.5
    z[89] = (y[167]**2 + y[166]**2)**0.5
    z[90] = (y[169]**2 + y[168]**2)**0.5
    z[91] = (y[171]**2 + y[170]**2)**0.5
    z[92] = (y[173]**2 + y[172]**2)**0.5
    z[93] = (y[175]**2 + y[174]**2)**0.5
    z[94] = (y[177]**2 + y[176]**2)**0.5
    z[95] = (y[179]**2 + y[178]**2)**0.5
    z[96] = (y[181]**2 + y[180]**2)**0.5
    z[97] = (y[183]**2 + y[182]**2)**0.5
    z[98] = (y[185]**2 + y[184]**2)**0.5
    z[99] = (y[187]**2 + y[186]**2)**0.5
    z[100] = (y[189]**2 + y[188]**2)**0.5
    z[101] = (y[191]**2 + y[190]**2)**0.5
    z[102] = (y[193]**2 + y[192]**2)**0.5
    z[103] = (y[195]**2 + y[194]**2)**0.5
    z[104] = (y[197]**2 + y[196]**2)**0.5
    z[105] = (y[199]**2 + y[198]**2)**0.5
    z[106] = (y[201]**2 + y[200]**2)**0.5
    z[107] = (y[203]**2 + y[202]**2)**0.5
    z[108] = (y[205]**2 + y[204]**2)**0.5
    z[109] = (y[207]**2 + y[206]**2)**0.5
    z[110] = (y[209]**2 + y[208]**2)**0.5
    z[111] = (y[211]**2 + y[210]**2)**0.5
    z[112] = (y[213]**2 + y[212]**2)**0.5
    z[113] = (y[215]**2 + y[214]**2)**0.5
    z[114] = (y[217]**2 + y[216]**2)**0.5
    z[115] = (y[219]**2 + y[218]**2)**0.5
    z[116] = (y[221]**2 + y[220]**2)**0.5
    z[117] = (y[223]**2 + y[222]**2)**0.5
    z[118] = (y[225]**2 + y[224]**2)**0.5
    z[119] = (y[227]**2 + y[226]**2)**0.5
    z[120] = (y[229]**2 + y[228]**2)**0.5
    z[121] = (y[231]**2 + y[230]**2)**0.5
    z[122] = (y[233]**2 + y[232]**2)**0.5





@numba.njit(cache=True)
def jac_ini_ss_eval_xy(jac_ini,x,y,u,p,xyup = 1):

    jac_ini[337,1] = y[336]
    jac_ini[337,2] = y[337]
    jac_ini[337,7] = -y[336]
    jac_ini[337,8] = -y[337]
    jac_ini[337,337] = y[0] - y[6]
    jac_ini[337,338] = y[1] - y[7]
    jac_ini[338,3] = y[338]
    jac_ini[338,4] = y[339]
    jac_ini[338,7] = -y[338]
    jac_ini[338,8] = -y[339]
    jac_ini[338,339] = y[2] - y[6]
    jac_ini[338,340] = y[3] - y[7]
    jac_ini[339,5] = y[340]
    jac_ini[339,6] = y[341]
    jac_ini[339,7] = -y[340]
    jac_ini[339,8] = -y[341]
    jac_ini[339,341] = y[4] - y[6]
    jac_ini[339,342] = y[5] - y[7]
    jac_ini[340,1] = -y[337]
    jac_ini[340,2] = y[336]
    jac_ini[340,7] = y[337]
    jac_ini[340,8] = -y[336]
    jac_ini[340,337] = y[1] - y[7]
    jac_ini[340,338] = -y[0] + y[6]
    jac_ini[341,3] = -y[339]
    jac_ini[341,4] = y[338]
    jac_ini[341,7] = y[339]
    jac_ini[341,8] = -y[338]
    jac_ini[341,339] = y[3] - y[7]
    jac_ini[341,340] = -y[2] + y[6]
    jac_ini[342,5] = -y[341]
    jac_ini[342,6] = y[340]
    jac_ini[342,7] = y[341]
    jac_ini[342,8] = -y[340]
    jac_ini[342,341] = y[5] - y[7]
    jac_ini[342,342] = -y[4] + y[6]
    jac_ini[345,9] = y[344]
    jac_ini[345,10] = y[345]
    jac_ini[345,15] = -y[344]
    jac_ini[345,16] = -y[345]
    jac_ini[345,345] = y[8] - y[14]
    jac_ini[345,346] = y[9] - y[15]
    jac_ini[346,11] = y[346]
    jac_ini[346,12] = y[347]
    jac_ini[346,15] = -y[346]
    jac_ini[346,16] = -y[347]
    jac_ini[346,347] = y[10] - y[14]
    jac_ini[346,348] = y[11] - y[15]
    jac_ini[347,13] = y[348]
    jac_ini[347,14] = y[349]
    jac_ini[347,15] = -y[348]
    jac_ini[347,16] = -y[349]
    jac_ini[347,349] = y[12] - y[14]
    jac_ini[347,350] = y[13] - y[15]
    jac_ini[348,9] = -y[345]
    jac_ini[348,10] = y[344]
    jac_ini[348,15] = y[345]
    jac_ini[348,16] = -y[344]
    jac_ini[348,345] = y[9] - y[15]
    jac_ini[348,346] = -y[8] + y[14]
    jac_ini[349,11] = -y[347]
    jac_ini[349,12] = y[346]
    jac_ini[349,15] = y[347]
    jac_ini[349,16] = -y[346]
    jac_ini[349,347] = y[11] - y[15]
    jac_ini[349,348] = -y[10] + y[14]
    jac_ini[350,13] = -y[349]
    jac_ini[350,14] = y[348]
    jac_ini[350,15] = y[349]
    jac_ini[350,16] = -y[348]
    jac_ini[350,349] = y[13] - y[15]
    jac_ini[350,350] = -y[12] + y[14]
    jac_ini[353,17] = y[352]
    jac_ini[353,18] = y[353]
    jac_ini[353,23] = -y[352]
    jac_ini[353,24] = -y[353]
    jac_ini[353,353] = y[16] - y[22]
    jac_ini[353,354] = y[17] - y[23]
    jac_ini[354,19] = y[354]
    jac_ini[354,20] = y[355]
    jac_ini[354,23] = -y[354]
    jac_ini[354,24] = -y[355]
    jac_ini[354,355] = y[18] - y[22]
    jac_ini[354,356] = y[19] - y[23]
    jac_ini[355,21] = y[356]
    jac_ini[355,22] = y[357]
    jac_ini[355,23] = -y[356]
    jac_ini[355,24] = -y[357]
    jac_ini[355,357] = y[20] - y[22]
    jac_ini[355,358] = y[21] - y[23]
    jac_ini[356,17] = -y[353]
    jac_ini[356,18] = y[352]
    jac_ini[356,23] = y[353]
    jac_ini[356,24] = -y[352]
    jac_ini[356,353] = y[17] - y[23]
    jac_ini[356,354] = -y[16] + y[22]
    jac_ini[357,19] = -y[355]
    jac_ini[357,20] = y[354]
    jac_ini[357,23] = y[355]
    jac_ini[357,24] = -y[354]
    jac_ini[357,355] = y[19] - y[23]
    jac_ini[357,356] = -y[18] + y[22]
    jac_ini[358,21] = -y[357]
    jac_ini[358,22] = y[356]
    jac_ini[358,23] = y[357]
    jac_ini[358,24] = -y[356]
    jac_ini[358,357] = y[21] - y[23]
    jac_ini[358,358] = -y[20] + y[22]
    jac_ini[361,25] = y[360]
    jac_ini[361,26] = y[361]
    jac_ini[361,31] = -y[360]
    jac_ini[361,32] = -y[361]
    jac_ini[361,361] = y[24] - y[30]
    jac_ini[361,362] = y[25] - y[31]
    jac_ini[362,27] = y[362]
    jac_ini[362,28] = y[363]
    jac_ini[362,31] = -y[362]
    jac_ini[362,32] = -y[363]
    jac_ini[362,363] = y[26] - y[30]
    jac_ini[362,364] = y[27] - y[31]
    jac_ini[363,29] = y[364]
    jac_ini[363,30] = y[365]
    jac_ini[363,31] = -y[364]
    jac_ini[363,32] = -y[365]
    jac_ini[363,365] = y[28] - y[30]
    jac_ini[363,366] = y[29] - y[31]
    jac_ini[364,25] = -y[361]
    jac_ini[364,26] = y[360]
    jac_ini[364,31] = y[361]
    jac_ini[364,32] = -y[360]
    jac_ini[364,361] = y[25] - y[31]
    jac_ini[364,362] = -y[24] + y[30]
    jac_ini[365,27] = -y[363]
    jac_ini[365,28] = y[362]
    jac_ini[365,31] = y[363]
    jac_ini[365,32] = -y[362]
    jac_ini[365,363] = y[27] - y[31]
    jac_ini[365,364] = -y[26] + y[30]
    jac_ini[366,29] = -y[365]
    jac_ini[366,30] = y[364]
    jac_ini[366,31] = y[365]
    jac_ini[366,32] = -y[364]
    jac_ini[366,365] = y[29] - y[31]
    jac_ini[366,366] = -y[28] + y[30]
    jac_ini[369,33] = y[368]
    jac_ini[369,34] = y[369]
    jac_ini[369,39] = -y[368]
    jac_ini[369,40] = -y[369]
    jac_ini[369,369] = y[32] - y[38]
    jac_ini[369,370] = y[33] - y[39]
    jac_ini[370,35] = y[370]
    jac_ini[370,36] = y[371]
    jac_ini[370,39] = -y[370]
    jac_ini[370,40] = -y[371]
    jac_ini[370,371] = y[34] - y[38]
    jac_ini[370,372] = y[35] - y[39]
    jac_ini[371,37] = y[372]
    jac_ini[371,38] = y[373]
    jac_ini[371,39] = -y[372]
    jac_ini[371,40] = -y[373]
    jac_ini[371,373] = y[36] - y[38]
    jac_ini[371,374] = y[37] - y[39]
    jac_ini[372,33] = -y[369]
    jac_ini[372,34] = y[368]
    jac_ini[372,39] = y[369]
    jac_ini[372,40] = -y[368]
    jac_ini[372,369] = y[33] - y[39]
    jac_ini[372,370] = -y[32] + y[38]
    jac_ini[373,35] = -y[371]
    jac_ini[373,36] = y[370]
    jac_ini[373,39] = y[371]
    jac_ini[373,40] = -y[370]
    jac_ini[373,371] = y[35] - y[39]
    jac_ini[373,372] = -y[34] + y[38]
    jac_ini[374,37] = -y[373]
    jac_ini[374,38] = y[372]
    jac_ini[374,39] = y[373]
    jac_ini[374,40] = -y[372]
    jac_ini[374,373] = y[37] - y[39]
    jac_ini[374,374] = -y[36] + y[38]
    jac_ini[377,41] = y[376]
    jac_ini[377,42] = y[377]
    jac_ini[377,47] = -y[376]
    jac_ini[377,48] = -y[377]
    jac_ini[377,377] = y[40] - y[46]
    jac_ini[377,378] = y[41] - y[47]
    jac_ini[378,43] = y[378]
    jac_ini[378,44] = y[379]
    jac_ini[378,47] = -y[378]
    jac_ini[378,48] = -y[379]
    jac_ini[378,379] = y[42] - y[46]
    jac_ini[378,380] = y[43] - y[47]
    jac_ini[379,45] = y[380]
    jac_ini[379,46] = y[381]
    jac_ini[379,47] = -y[380]
    jac_ini[379,48] = -y[381]
    jac_ini[379,381] = y[44] - y[46]
    jac_ini[379,382] = y[45] - y[47]
    jac_ini[380,41] = -y[377]
    jac_ini[380,42] = y[376]
    jac_ini[380,47] = y[377]
    jac_ini[380,48] = -y[376]
    jac_ini[380,377] = y[41] - y[47]
    jac_ini[380,378] = -y[40] + y[46]
    jac_ini[381,43] = -y[379]
    jac_ini[381,44] = y[378]
    jac_ini[381,47] = y[379]
    jac_ini[381,48] = -y[378]
    jac_ini[381,379] = y[43] - y[47]
    jac_ini[381,380] = -y[42] + y[46]
    jac_ini[382,45] = -y[381]
    jac_ini[382,46] = y[380]
    jac_ini[382,47] = y[381]
    jac_ini[382,48] = -y[380]
    jac_ini[382,381] = y[45] - y[47]
    jac_ini[382,382] = -y[44] + y[46]
    jac_ini[385,49] = y[384]
    jac_ini[385,50] = 1.0*y[385]
    jac_ini[385,51] = -y[384]
    jac_ini[385,52] = -1.0*y[385]
    jac_ini[385,385] = y[48] - y[50]
    jac_ini[385,386] = 1.0*y[49] - 1.0*y[51]
    jac_ini[386,49] = -1.0*y[385]
    jac_ini[386,50] = 1.0*y[384]
    jac_ini[386,51] = 1.0*y[385]
    jac_ini[386,52] = -1.0*y[384]
    jac_ini[386,385] = 1.0*y[49] - 1.0*y[51]
    jac_ini[386,386] = -1.0*y[48] + 1.0*y[50]
    jac_ini[389,53] = y[388]
    jac_ini[389,54] = 1.0*y[389]
    jac_ini[389,55] = -y[388]
    jac_ini[389,56] = -1.0*y[389]
    jac_ini[389,389] = y[52] - y[54]
    jac_ini[389,390] = 1.0*y[53] - 1.0*y[55]
    jac_ini[390,53] = -1.0*y[389]
    jac_ini[390,54] = 1.0*y[388]
    jac_ini[390,55] = 1.0*y[389]
    jac_ini[390,56] = -1.0*y[388]
    jac_ini[390,389] = 1.0*y[53] - 1.0*y[55]
    jac_ini[390,390] = -1.0*y[52] + 1.0*y[54]
    jac_ini[393,57] = y[392]
    jac_ini[393,58] = 1.0*y[393]
    jac_ini[393,59] = -y[392]
    jac_ini[393,60] = -1.0*y[393]
    jac_ini[393,393] = y[56] - y[58]
    jac_ini[393,394] = 1.0*y[57] - 1.0*y[59]
    jac_ini[394,57] = -1.0*y[393]
    jac_ini[394,58] = 1.0*y[392]
    jac_ini[394,59] = 1.0*y[393]
    jac_ini[394,60] = -1.0*y[392]
    jac_ini[394,393] = 1.0*y[57] - 1.0*y[59]
    jac_ini[394,394] = -1.0*y[56] + 1.0*y[58]
    jac_ini[397,61] = y[396]
    jac_ini[397,62] = 1.0*y[397]
    jac_ini[397,63] = -y[396]
    jac_ini[397,64] = -1.0*y[397]
    jac_ini[397,397] = y[60] - y[62]
    jac_ini[397,398] = 1.0*y[61] - 1.0*y[63]
    jac_ini[398,61] = -1.0*y[397]
    jac_ini[398,62] = 1.0*y[396]
    jac_ini[398,63] = 1.0*y[397]
    jac_ini[398,64] = -1.0*y[396]
    jac_ini[398,397] = 1.0*y[61] - 1.0*y[63]
    jac_ini[398,398] = -1.0*y[60] + 1.0*y[62]
    jac_ini[401,65] = y[400]
    jac_ini[401,66] = 1.0*y[401]
    jac_ini[401,67] = -y[400]
    jac_ini[401,68] = -1.0*y[401]
    jac_ini[401,401] = y[64] - y[66]
    jac_ini[401,402] = 1.0*y[65] - 1.0*y[67]
    jac_ini[402,65] = -1.0*y[401]
    jac_ini[402,66] = 1.0*y[400]
    jac_ini[402,67] = 1.0*y[401]
    jac_ini[402,68] = -1.0*y[400]
    jac_ini[402,401] = 1.0*y[65] - 1.0*y[67]
    jac_ini[402,402] = -1.0*y[64] + 1.0*y[66]
    jac_ini[405,1] = y[404]
    jac_ini[405,2] = 1.0*y[405]
    jac_ini[405,7] = -y[404]
    jac_ini[405,8] = -1.0*y[405]
    jac_ini[405,405] = y[0] - y[6]
    jac_ini[405,406] = 1.0*y[1] - 1.0*y[7]
    jac_ini[406,1] = -1.0*y[405]
    jac_ini[406,2] = 1.0*y[404]
    jac_ini[406,7] = 1.0*y[405]
    jac_ini[406,8] = -1.0*y[404]
    jac_ini[406,405] = 1.0*y[1] - 1.0*y[7]
    jac_ini[406,406] = -1.0*y[0] + 1.0*y[6]
    jac_ini[407,3] = y[406]
    jac_ini[407,4] = 1.0*y[407]
    jac_ini[407,7] = -y[406]
    jac_ini[407,8] = -1.0*y[407]
    jac_ini[407,407] = y[2] - y[6]
    jac_ini[407,408] = 1.0*y[3] - 1.0*y[7]
    jac_ini[408,3] = -1.0*y[407]
    jac_ini[408,4] = 1.0*y[406]
    jac_ini[408,7] = 1.0*y[407]
    jac_ini[408,8] = -1.0*y[406]
    jac_ini[408,407] = 1.0*y[3] - 1.0*y[7]
    jac_ini[408,408] = -1.0*y[2] + 1.0*y[6]
    jac_ini[409,5] = y[408]
    jac_ini[409,6] = 1.0*y[409]
    jac_ini[409,7] = -y[408]
    jac_ini[409,8] = -1.0*y[409]
    jac_ini[409,409] = y[4] - y[6]
    jac_ini[409,410] = 1.0*y[5] - 1.0*y[7]
    jac_ini[410,5] = -1.0*y[409]
    jac_ini[410,6] = 1.0*y[408]
    jac_ini[410,7] = 1.0*y[409]
    jac_ini[410,8] = -1.0*y[408]
    jac_ini[410,409] = 1.0*y[5] - 1.0*y[7]
    jac_ini[410,410] = -1.0*y[4] + 1.0*y[6]
    jac_ini[411,413] = Piecewise(np.array([(-1, y[411] < 0), (1, True)]))
    jac_ini[412,255] = y[164]
    jac_ini[413,405] = -p[1]*y[404]/sqrt(y[405]**2 + y[404]**2 + 0.1) - 2*p[2]*y[404]
    jac_ini[413,406] = -p[1]*y[405]/sqrt(y[405]**2 + y[404]**2 + 0.1) - 2*p[2]*y[405]
    jac_ini[414,133] = y[413]
    jac_ini[414,134] = 1.0*y[414]
    jac_ini[414,139] = -y[413]
    jac_ini[414,140] = -1.0*y[414]
    jac_ini[414,414] = y[132] - y[138]
    jac_ini[414,415] = 1.0*y[133] - 1.0*y[139]
    jac_ini[415,133] = -1.0*y[414]
    jac_ini[415,134] = 1.0*y[413]
    jac_ini[415,139] = 1.0*y[414]
    jac_ini[415,140] = -1.0*y[413]
    jac_ini[415,414] = 1.0*y[133] - 1.0*y[139]
    jac_ini[415,415] = -1.0*y[132] + 1.0*y[138]
    jac_ini[416,135] = y[415]
    jac_ini[416,136] = 1.0*y[416]
    jac_ini[416,139] = -y[415]
    jac_ini[416,140] = -1.0*y[416]
    jac_ini[416,416] = y[134] - y[138]
    jac_ini[416,417] = 1.0*y[135] - 1.0*y[139]
    jac_ini[417,135] = -1.0*y[416]
    jac_ini[417,136] = 1.0*y[415]
    jac_ini[417,139] = 1.0*y[416]
    jac_ini[417,140] = -1.0*y[415]
    jac_ini[417,416] = 1.0*y[135] - 1.0*y[139]
    jac_ini[417,417] = -1.0*y[134] + 1.0*y[138]
    jac_ini[418,137] = y[417]
    jac_ini[418,138] = 1.0*y[418]
    jac_ini[418,139] = -y[417]
    jac_ini[418,140] = -1.0*y[418]
    jac_ini[418,418] = y[136] - y[138]
    jac_ini[418,419] = 1.0*y[137] - 1.0*y[139]
    jac_ini[419,137] = -1.0*y[418]
    jac_ini[419,138] = 1.0*y[417]
    jac_ini[419,139] = 1.0*y[418]
    jac_ini[419,140] = -1.0*y[417]
    jac_ini[419,418] = 1.0*y[137] - 1.0*y[139]
    jac_ini[419,419] = -1.0*y[136] + 1.0*y[138]
    jac_ini[420,199] = -y[421]/(y[198] - y[204] + 1.0e-8)**2
    jac_ini[420,205] = y[421]/(y[198] - y[204] + 1.0e-8)**2
    jac_ini[420,422] = 1/(y[198] - y[204] + 1.0e-8)
    jac_ini[421,199] = y[421]/(-y[198] + y[204] + 1.0e-8)**2
    jac_ini[421,205] = -y[421]/(-y[198] + y[204] + 1.0e-8)**2
    jac_ini[421,422] = 1/(-y[198] + y[204] + 1.0e-8)
    jac_ini[422,423] = -Piecewise(np.array([(-1, y[421] < 0), (1, True)]))
    jac_ini[423,414] = -p[4]*y[413]/sqrt(y[414]**2 + y[413]**2 + 0.1) - 2*p[5]*y[413]
    jac_ini[423,415] = -p[4]*y[414]/sqrt(y[414]**2 + y[413]**2 + 0.1) - 2*p[5]*y[414]
    jac_ini[424,157] = y[423]
    jac_ini[424,158] = 1.0*y[424]
    jac_ini[424,163] = -y[423]
    jac_ini[424,164] = -1.0*y[424]
    jac_ini[424,424] = y[156] - y[162]
    jac_ini[424,425] = 1.0*y[157] - 1.0*y[163]
    jac_ini[425,157] = -1.0*y[424]
    jac_ini[425,158] = 1.0*y[423]
    jac_ini[425,163] = 1.0*y[424]
    jac_ini[425,164] = -1.0*y[423]
    jac_ini[425,424] = 1.0*y[157] - 1.0*y[163]
    jac_ini[425,425] = -1.0*y[156] + 1.0*y[162]
    jac_ini[426,159] = y[425]
    jac_ini[426,160] = 1.0*y[426]
    jac_ini[426,163] = -y[425]
    jac_ini[426,164] = -1.0*y[426]
    jac_ini[426,426] = y[158] - y[162]
    jac_ini[426,427] = 1.0*y[159] - 1.0*y[163]
    jac_ini[427,159] = -1.0*y[426]
    jac_ini[427,160] = 1.0*y[425]
    jac_ini[427,163] = 1.0*y[426]
    jac_ini[427,164] = -1.0*y[425]
    jac_ini[427,426] = 1.0*y[159] - 1.0*y[163]
    jac_ini[427,427] = -1.0*y[158] + 1.0*y[162]
    jac_ini[428,161] = y[427]
    jac_ini[428,162] = 1.0*y[428]
    jac_ini[428,163] = -y[427]
    jac_ini[428,164] = -1.0*y[428]
    jac_ini[428,428] = y[160] - y[162]
    jac_ini[428,429] = 1.0*y[161] - 1.0*y[163]
    jac_ini[429,161] = -1.0*y[428]
    jac_ini[429,162] = 1.0*y[427]
    jac_ini[429,163] = 1.0*y[428]
    jac_ini[429,164] = -1.0*y[427]
    jac_ini[429,428] = 1.0*y[161] - 1.0*y[163]
    jac_ini[429,429] = -1.0*y[160] + 1.0*y[162]
    jac_ini[430,223] = -y[431]/(y[222] - y[228] + 1.0e-8)**2
    jac_ini[430,229] = y[431]/(y[222] - y[228] + 1.0e-8)**2
    jac_ini[430,432] = 1/(y[222] - y[228] + 1.0e-8)
    jac_ini[431,223] = y[431]/(-y[222] + y[228] + 1.0e-8)**2
    jac_ini[431,229] = -y[431]/(-y[222] + y[228] + 1.0e-8)**2
    jac_ini[431,432] = 1/(-y[222] + y[228] + 1.0e-8)
    jac_ini[432,433] = -Piecewise(np.array([(-1, y[431] < 0), (1, True)]))
    jac_ini[433,424] = -p[10]*y[423]/sqrt(y[424]**2 + y[423]**2 + 0.1) - 2*p[11]*y[423]
    jac_ini[433,425] = -p[10]*y[424]/sqrt(y[424]**2 + y[423]**2 + 0.1) - 2*p[11]*y[424]

@numba.njit(cache=True)
def jac_ini_ss_eval_up(jac_ini,x,y,u,p,xyup = 1):

    jac_ini[412,249] = u[6]

def jac_ini_ss_eval_num(jac_ini,x,y,u,p,xyup = 1):

    jac_ini[0,0] = -1
    jac_ini[1,1] = -123.954122254357
    jac_ini[1,2] = -127.595184532966
    jac_ini[1,3] = 39.6392229058202
    jac_ini[1,4] = 10.2713736253513
    jac_ini[1,5] = 24.9575997948692
    jac_ini[1,6] = 23.2849644809540
    jac_ini[1,7] = 58.0215758469966
    jac_ini[1,8] = 83.8007853900572
    jac_ini[1,69] = 105.571769313180
    jac_ini[1,70] = 54.0657727682604
    jac_ini[1,71] = -39.6392229058202
    jac_ini[1,72] = -10.2713736253513
    jac_ini[1,73] = -24.9575997948692
    jac_ini[1,74] = -23.2849644809540
    jac_ini[1,75] = -39.6392229058202
    jac_ini[1,76] = -10.2713736253513
    jac_ini[1,337] = 1
    jac_ini[1,405] = 1
    jac_ini[2,1] = 127.595184532966
    jac_ini[2,2] = -123.954122254357
    jac_ini[2,3] = -10.2713736253513
    jac_ini[2,4] = 39.6392229058202
    jac_ini[2,5] = -23.2849644809540
    jac_ini[2,6] = 24.9575997948692
    jac_ini[2,7] = -83.8007853900572
    jac_ini[2,8] = 58.0215758469966
    jac_ini[2,69] = -54.0657727682604
    jac_ini[2,70] = 105.571769313180
    jac_ini[2,71] = 10.2713736253513
    jac_ini[2,72] = -39.6392229058202
    jac_ini[2,73] = 23.2849644809540
    jac_ini[2,74] = -24.9575997948692
    jac_ini[2,75] = 10.2713736253513
    jac_ini[2,76] = -39.6392229058202
    jac_ini[2,338] = 1
    jac_ini[2,406] = 1
    jac_ini[3,1] = 39.6392229058202
    jac_ini[3,2] = 10.2713736253513
    jac_ini[3,3] = -123.954122254357
    jac_ini[3,4] = -127.595184532966
    jac_ini[3,5] = 39.6392229058201
    jac_ini[3,6] = 10.2713736253513
    jac_ini[3,7] = 43.3399527360457
    jac_ini[3,8] = 96.8143762456598
    jac_ini[3,69] = -39.6392229058202
    jac_ini[3,70] = -10.2713736253513
    jac_ini[3,71] = 105.571769313180
    jac_ini[3,72] = 54.0657727682604
    jac_ini[3,73] = -39.6392229058201
    jac_ini[3,74] = -10.2713736253513
    jac_ini[3,75] = -24.9575997948692
    jac_ini[3,76] = -23.2849644809540
    jac_ini[3,339] = 1
    jac_ini[3,407] = 1
    jac_ini[4,1] = -10.2713736253513
    jac_ini[4,2] = 39.6392229058202
    jac_ini[4,3] = 127.595184532966
    jac_ini[4,4] = -123.954122254357
    jac_ini[4,5] = -10.2713736253513
    jac_ini[4,6] = 39.6392229058201
    jac_ini[4,7] = -96.8143762456598
    jac_ini[4,8] = 43.3399527360457
    jac_ini[4,69] = 10.2713736253513
    jac_ini[4,70] = -39.6392229058202
    jac_ini[4,71] = -54.0657727682604
    jac_ini[4,72] = 105.571769313180
    jac_ini[4,73] = 10.2713736253513
    jac_ini[4,74] = -39.6392229058201
    jac_ini[4,75] = 23.2849644809540
    jac_ini[4,76] = -24.9575997948692
    jac_ini[4,340] = 1
    jac_ini[4,408] = 1
    jac_ini[5,1] = 24.9575997948692
    jac_ini[5,2] = 23.2849644809540
    jac_ini[5,3] = 39.6392229058202
    jac_ini[5,4] = 10.2713736253513
    jac_ini[5,5] = -123.954122254357
    jac_ini[5,6] = -127.595184532966
    jac_ini[5,7] = 58.0215758469966
    jac_ini[5,8] = 83.8007853900572
    jac_ini[5,69] = -24.9575997948692
    jac_ini[5,70] = -23.2849644809540
    jac_ini[5,71] = -39.6392229058202
    jac_ini[5,72] = -10.2713736253513
    jac_ini[5,73] = 105.571769313180
    jac_ini[5,74] = 54.0657727682604
    jac_ini[5,75] = -39.6392229058201
    jac_ini[5,76] = -10.2713736253514
    jac_ini[5,341] = 1
    jac_ini[5,409] = 1
    jac_ini[6,1] = -23.2849644809540
    jac_ini[6,2] = 24.9575997948692
    jac_ini[6,3] = -10.2713736253513
    jac_ini[6,4] = 39.6392229058202
    jac_ini[6,5] = 127.595184532966
    jac_ini[6,6] = -123.954122254357
    jac_ini[6,7] = -83.8007853900572
    jac_ini[6,8] = 58.0215758469966
    jac_ini[6,69] = 23.2849644809540
    jac_ini[6,70] = -24.9575997948692
    jac_ini[6,71] = 10.2713736253513
    jac_ini[6,72] = -39.6392229058202
    jac_ini[6,73] = -54.0657727682604
    jac_ini[6,74] = 105.571769313180
    jac_ini[6,75] = 10.2713736253514
    jac_ini[6,76] = -39.6392229058201
    jac_ini[6,342] = 1
    jac_ini[6,410] = 1
    jac_ini[7,1] = 58.0215758469966
    jac_ini[7,2] = 83.8007853900572
    jac_ini[7,3] = 43.3399527360457
    jac_ini[7,4] = 96.8143762456598
    jac_ini[7,5] = 58.0215758469966
    jac_ini[7,6] = 83.8007853900572
    jac_ini[7,7] = -161.052161470043
    jac_ini[7,8] = -274.654008062378
    jac_ini[7,69] = -39.6392229058202
    jac_ini[7,70] = -10.2713736253513
    jac_ini[7,71] = -24.9575997948692
    jac_ini[7,72] = -23.2849644809540
    jac_ini[7,73] = -39.6392229058202
    jac_ini[7,74] = -10.2713736253513
    jac_ini[7,75] = 105.571769313180
    jac_ini[7,76] = 54.0657727682604
    jac_ini[8,1] = -83.8007853900572
    jac_ini[8,2] = 58.0215758469966
    jac_ini[8,3] = -96.8143762456598
    jac_ini[8,4] = 43.3399527360457
    jac_ini[8,5] = -83.8007853900572
    jac_ini[8,6] = 58.0215758469966
    jac_ini[8,7] = 274.654008062378
    jac_ini[8,8] = -161.052161470043
    jac_ini[8,69] = 10.2713736253513
    jac_ini[8,70] = -39.6392229058202
    jac_ini[8,71] = 23.2849644809540
    jac_ini[8,72] = -24.9575997948692
    jac_ini[8,73] = 10.2713736253513
    jac_ini[8,74] = -39.6392229058202
    jac_ini[8,75] = -54.0657727682604
    jac_ini[8,76] = 105.571769313180
    jac_ini[9,9] = -26.5300693004806
    jac_ini[9,10] = -4.84676915585801
    jac_ini[9,11] = 7.89461337514770
    jac_ini[9,12] = -1.58482814504483
    jac_ini[9,13] = 7.72144347466701
    jac_ini[9,14] = -0.679918453285310
    jac_ini[9,15] = 7.89461337514771
    jac_ini[9,16] = -1.58482814504483
    jac_ini[9,77] = 26.5300693004806
    jac_ini[9,78] = 4.84676915585801
    jac_ini[9,79] = -7.89461337514770
    jac_ini[9,80] = 1.58482814504483
    jac_ini[9,81] = -7.72144347466701
    jac_ini[9,82] = 0.679918453285310
    jac_ini[9,83] = -7.89461337514771
    jac_ini[9,84] = 1.58482814504483
    jac_ini[9,345] = 1
    jac_ini[10,9] = 4.84676915585801
    jac_ini[10,10] = -26.5300693004806
    jac_ini[10,11] = 1.58482814504483
    jac_ini[10,12] = 7.89461337514770
    jac_ini[10,13] = 0.679918453285310
    jac_ini[10,14] = 7.72144347466701
    jac_ini[10,15] = 1.58482814504483
    jac_ini[10,16] = 7.89461337514771
    jac_ini[10,77] = -4.84676915585801
    jac_ini[10,78] = 26.5300693004806
    jac_ini[10,79] = -1.58482814504483
    jac_ini[10,80] = -7.89461337514770
    jac_ini[10,81] = -0.679918453285310
    jac_ini[10,82] = -7.72144347466701
    jac_ini[10,83] = -1.58482814504483
    jac_ini[10,84] = -7.89461337514771
    jac_ini[10,346] = 1
    jac_ini[11,9] = 7.89461337514771
    jac_ini[11,10] = -1.58482814504483
    jac_ini[11,11] = -26.5300693004806
    jac_ini[11,12] = -4.84676915585801
    jac_ini[11,13] = 7.89461337514771
    jac_ini[11,14] = -1.58482814504483
    jac_ini[11,15] = 7.72144347466701
    jac_ini[11,16] = -0.679918453285308
    jac_ini[11,77] = -7.89461337514771
    jac_ini[11,78] = 1.58482814504483
    jac_ini[11,79] = 26.5300693004806
    jac_ini[11,80] = 4.84676915585801
    jac_ini[11,81] = -7.89461337514771
    jac_ini[11,82] = 1.58482814504483
    jac_ini[11,83] = -7.72144347466701
    jac_ini[11,84] = 0.679918453285308
    jac_ini[11,347] = 1
    jac_ini[12,9] = 1.58482814504483
    jac_ini[12,10] = 7.89461337514771
    jac_ini[12,11] = 4.84676915585801
    jac_ini[12,12] = -26.5300693004806
    jac_ini[12,13] = 1.58482814504483
    jac_ini[12,14] = 7.89461337514771
    jac_ini[12,15] = 0.679918453285308
    jac_ini[12,16] = 7.72144347466701
    jac_ini[12,77] = -1.58482814504483
    jac_ini[12,78] = -7.89461337514771
    jac_ini[12,79] = -4.84676915585801
    jac_ini[12,80] = 26.5300693004806
    jac_ini[12,81] = -1.58482814504483
    jac_ini[12,82] = -7.89461337514771
    jac_ini[12,83] = -0.679918453285308
    jac_ini[12,84] = -7.72144347466701
    jac_ini[12,348] = 1
    jac_ini[13,9] = 7.72144347466701
    jac_ini[13,10] = -0.679918453285310
    jac_ini[13,11] = 7.89461337514770
    jac_ini[13,12] = -1.58482814504483
    jac_ini[13,13] = -26.5300693004806
    jac_ini[13,14] = -4.84676915585801
    jac_ini[13,15] = 7.89461337514771
    jac_ini[13,16] = -1.58482814504483
    jac_ini[13,77] = -7.72144347466701
    jac_ini[13,78] = 0.679918453285310
    jac_ini[13,79] = -7.89461337514770
    jac_ini[13,80] = 1.58482814504483
    jac_ini[13,81] = 26.5300693004806
    jac_ini[13,82] = 4.84676915585801
    jac_ini[13,83] = -7.89461337514771
    jac_ini[13,84] = 1.58482814504483
    jac_ini[13,349] = 1
    jac_ini[14,9] = 0.679918453285310
    jac_ini[14,10] = 7.72144347466701
    jac_ini[14,11] = 1.58482814504483
    jac_ini[14,12] = 7.89461337514770
    jac_ini[14,13] = 4.84676915585801
    jac_ini[14,14] = -26.5300693004806
    jac_ini[14,15] = 1.58482814504483
    jac_ini[14,16] = 7.89461337514771
    jac_ini[14,77] = -0.679918453285310
    jac_ini[14,78] = -7.72144347466701
    jac_ini[14,79] = -1.58482814504483
    jac_ini[14,80] = -7.89461337514770
    jac_ini[14,81] = -4.84676915585801
    jac_ini[14,82] = 26.5300693004806
    jac_ini[14,83] = -1.58482814504483
    jac_ini[14,84] = -7.89461337514771
    jac_ini[14,350] = 1
    jac_ini[15,9] = 7.89461337514771
    jac_ini[15,10] = -1.58482814504483
    jac_ini[15,11] = 7.72144347466701
    jac_ini[15,12] = -0.679918453285308
    jac_ini[15,13] = 7.89461337514771
    jac_ini[15,14] = -1.58482814504483
    jac_ini[15,15] = -26.5550693004806
    jac_ini[15,16] = -4.84676915585801
    jac_ini[15,77] = -7.89461337514771
    jac_ini[15,78] = 1.58482814504483
    jac_ini[15,79] = -7.72144347466701
    jac_ini[15,80] = 0.679918453285308
    jac_ini[15,81] = -7.89461337514771
    jac_ini[15,82] = 1.58482814504483
    jac_ini[15,83] = 26.5300693004806
    jac_ini[15,84] = 4.84676915585801
    jac_ini[16,9] = 1.58482814504483
    jac_ini[16,10] = 7.89461337514771
    jac_ini[16,11] = 0.679918453285308
    jac_ini[16,12] = 7.72144347466701
    jac_ini[16,13] = 1.58482814504483
    jac_ini[16,14] = 7.89461337514771
    jac_ini[16,15] = 4.84676915585801
    jac_ini[16,16] = -26.5550693004806
    jac_ini[16,77] = -1.58482814504483
    jac_ini[16,78] = -7.89461337514771
    jac_ini[16,79] = -0.679918453285308
    jac_ini[16,80] = -7.72144347466701
    jac_ini[16,81] = -1.58482814504483
    jac_ini[16,82] = -7.89461337514771
    jac_ini[16,83] = -4.84676915585801
    jac_ini[16,84] = 26.5300693004806
    jac_ini[17,17] = -26.5300693004806
    jac_ini[17,18] = -4.84676915585801
    jac_ini[17,19] = 7.89461337514770
    jac_ini[17,20] = -1.58482814504483
    jac_ini[17,21] = 7.72144347466701
    jac_ini[17,22] = -0.679918453285310
    jac_ini[17,23] = 7.89461337514771
    jac_ini[17,24] = -1.58482814504483
    jac_ini[17,157] = 26.5300693004806
    jac_ini[17,158] = 4.84676915585801
    jac_ini[17,159] = -7.89461337514770
    jac_ini[17,160] = 1.58482814504483
    jac_ini[17,161] = -7.72144347466701
    jac_ini[17,162] = 0.679918453285310
    jac_ini[17,163] = -7.89461337514771
    jac_ini[17,164] = 1.58482814504483
    jac_ini[17,353] = 1
    jac_ini[18,17] = 4.84676915585801
    jac_ini[18,18] = -26.5300693004806
    jac_ini[18,19] = 1.58482814504483
    jac_ini[18,20] = 7.89461337514770
    jac_ini[18,21] = 0.679918453285310
    jac_ini[18,22] = 7.72144347466701
    jac_ini[18,23] = 1.58482814504483
    jac_ini[18,24] = 7.89461337514771
    jac_ini[18,157] = -4.84676915585801
    jac_ini[18,158] = 26.5300693004806
    jac_ini[18,159] = -1.58482814504483
    jac_ini[18,160] = -7.89461337514770
    jac_ini[18,161] = -0.679918453285310
    jac_ini[18,162] = -7.72144347466701
    jac_ini[18,163] = -1.58482814504483
    jac_ini[18,164] = -7.89461337514771
    jac_ini[18,354] = 1
    jac_ini[19,17] = 7.89461337514771
    jac_ini[19,18] = -1.58482814504483
    jac_ini[19,19] = -26.5300693004806
    jac_ini[19,20] = -4.84676915585801
    jac_ini[19,21] = 7.89461337514771
    jac_ini[19,22] = -1.58482814504483
    jac_ini[19,23] = 7.72144347466701
    jac_ini[19,24] = -0.679918453285308
    jac_ini[19,157] = -7.89461337514771
    jac_ini[19,158] = 1.58482814504483
    jac_ini[19,159] = 26.5300693004806
    jac_ini[19,160] = 4.84676915585801
    jac_ini[19,161] = -7.89461337514771
    jac_ini[19,162] = 1.58482814504483
    jac_ini[19,163] = -7.72144347466701
    jac_ini[19,164] = 0.679918453285308
    jac_ini[19,355] = 1
    jac_ini[20,17] = 1.58482814504483
    jac_ini[20,18] = 7.89461337514771
    jac_ini[20,19] = 4.84676915585801
    jac_ini[20,20] = -26.5300693004806
    jac_ini[20,21] = 1.58482814504483
    jac_ini[20,22] = 7.89461337514771
    jac_ini[20,23] = 0.679918453285308
    jac_ini[20,24] = 7.72144347466701
    jac_ini[20,157] = -1.58482814504483
    jac_ini[20,158] = -7.89461337514771
    jac_ini[20,159] = -4.84676915585801
    jac_ini[20,160] = 26.5300693004806
    jac_ini[20,161] = -1.58482814504483
    jac_ini[20,162] = -7.89461337514771
    jac_ini[20,163] = -0.679918453285308
    jac_ini[20,164] = -7.72144347466701
    jac_ini[20,356] = 1
    jac_ini[21,17] = 7.72144347466701
    jac_ini[21,18] = -0.679918453285310
    jac_ini[21,19] = 7.89461337514770
    jac_ini[21,20] = -1.58482814504483
    jac_ini[21,21] = -26.5300693004806
    jac_ini[21,22] = -4.84676915585801
    jac_ini[21,23] = 7.89461337514771
    jac_ini[21,24] = -1.58482814504483
    jac_ini[21,157] = -7.72144347466701
    jac_ini[21,158] = 0.679918453285310
    jac_ini[21,159] = -7.89461337514770
    jac_ini[21,160] = 1.58482814504483
    jac_ini[21,161] = 26.5300693004806
    jac_ini[21,162] = 4.84676915585801
    jac_ini[21,163] = -7.89461337514771
    jac_ini[21,164] = 1.58482814504483
    jac_ini[21,357] = 1
    jac_ini[22,17] = 0.679918453285310
    jac_ini[22,18] = 7.72144347466701
    jac_ini[22,19] = 1.58482814504483
    jac_ini[22,20] = 7.89461337514770
    jac_ini[22,21] = 4.84676915585801
    jac_ini[22,22] = -26.5300693004806
    jac_ini[22,23] = 1.58482814504483
    jac_ini[22,24] = 7.89461337514771
    jac_ini[22,157] = -0.679918453285310
    jac_ini[22,158] = -7.72144347466701
    jac_ini[22,159] = -1.58482814504483
    jac_ini[22,160] = -7.89461337514770
    jac_ini[22,161] = -4.84676915585801
    jac_ini[22,162] = 26.5300693004806
    jac_ini[22,163] = -1.58482814504483
    jac_ini[22,164] = -7.89461337514771
    jac_ini[22,358] = 1
    jac_ini[23,17] = 7.89461337514771
    jac_ini[23,18] = -1.58482814504483
    jac_ini[23,19] = 7.72144347466701
    jac_ini[23,20] = -0.679918453285308
    jac_ini[23,21] = 7.89461337514771
    jac_ini[23,22] = -1.58482814504483
    jac_ini[23,23] = -26.5550693004806
    jac_ini[23,24] = -4.84676915585801
    jac_ini[23,157] = -7.89461337514771
    jac_ini[23,158] = 1.58482814504483
    jac_ini[23,159] = -7.72144347466701
    jac_ini[23,160] = 0.679918453285308
    jac_ini[23,161] = -7.89461337514771
    jac_ini[23,162] = 1.58482814504483
    jac_ini[23,163] = 26.5300693004806
    jac_ini[23,164] = 4.84676915585801
    jac_ini[24,17] = 1.58482814504483
    jac_ini[24,18] = 7.89461337514771
    jac_ini[24,19] = 0.679918453285308
    jac_ini[24,20] = 7.72144347466701
    jac_ini[24,21] = 1.58482814504483
    jac_ini[24,22] = 7.89461337514771
    jac_ini[24,23] = 4.84676915585801
    jac_ini[24,24] = -26.5550693004806
    jac_ini[24,157] = -1.58482814504483
    jac_ini[24,158] = -7.89461337514771
    jac_ini[24,159] = -0.679918453285308
    jac_ini[24,160] = -7.72144347466701
    jac_ini[24,161] = -1.58482814504483
    jac_ini[24,162] = -7.89461337514771
    jac_ini[24,163] = -4.84676915585801
    jac_ini[24,164] = 26.5300693004806
    jac_ini[25,25] = -30.9517475172273
    jac_ini[25,26] = -5.65456401516768
    jac_ini[25,27] = 9.21038227100566
    jac_ini[25,28] = -1.84896616921897
    jac_ini[25,29] = 9.00835072044485
    jac_ini[25,30] = -0.793238195499529
    jac_ini[25,31] = 9.21038227100566
    jac_ini[25,32] = -1.84896616921897
    jac_ini[25,101] = 30.9517475172273
    jac_ini[25,102] = 5.65456401516768
    jac_ini[25,103] = -9.21038227100566
    jac_ini[25,104] = 1.84896616921897
    jac_ini[25,105] = -9.00835072044485
    jac_ini[25,106] = 0.793238195499529
    jac_ini[25,107] = -9.21038227100566
    jac_ini[25,108] = 1.84896616921897
    jac_ini[25,361] = 1
    jac_ini[26,25] = 5.65456401516768
    jac_ini[26,26] = -30.9517475172273
    jac_ini[26,27] = 1.84896616921897
    jac_ini[26,28] = 9.21038227100566
    jac_ini[26,29] = 0.793238195499529
    jac_ini[26,30] = 9.00835072044485
    jac_ini[26,31] = 1.84896616921897
    jac_ini[26,32] = 9.21038227100566
    jac_ini[26,101] = -5.65456401516768
    jac_ini[26,102] = 30.9517475172273
    jac_ini[26,103] = -1.84896616921897
    jac_ini[26,104] = -9.21038227100566
    jac_ini[26,105] = -0.793238195499529
    jac_ini[26,106] = -9.00835072044485
    jac_ini[26,107] = -1.84896616921897
    jac_ini[26,108] = -9.21038227100566
    jac_ini[26,362] = 1
    jac_ini[27,25] = 9.21038227100566
    jac_ini[27,26] = -1.84896616921897
    jac_ini[27,27] = -30.9517475172273
    jac_ini[27,28] = -5.65456401516768
    jac_ini[27,29] = 9.21038227100566
    jac_ini[27,30] = -1.84896616921897
    jac_ini[27,31] = 9.00835072044485
    jac_ini[27,32] = -0.793238195499528
    jac_ini[27,101] = -9.21038227100566
    jac_ini[27,102] = 1.84896616921897
    jac_ini[27,103] = 30.9517475172273
    jac_ini[27,104] = 5.65456401516768
    jac_ini[27,105] = -9.21038227100566
    jac_ini[27,106] = 1.84896616921897
    jac_ini[27,107] = -9.00835072044485
    jac_ini[27,108] = 0.793238195499528
    jac_ini[27,363] = 1
    jac_ini[28,25] = 1.84896616921897
    jac_ini[28,26] = 9.21038227100566
    jac_ini[28,27] = 5.65456401516768
    jac_ini[28,28] = -30.9517475172273
    jac_ini[28,29] = 1.84896616921897
    jac_ini[28,30] = 9.21038227100566
    jac_ini[28,31] = 0.793238195499528
    jac_ini[28,32] = 9.00835072044485
    jac_ini[28,101] = -1.84896616921897
    jac_ini[28,102] = -9.21038227100566
    jac_ini[28,103] = -5.65456401516768
    jac_ini[28,104] = 30.9517475172273
    jac_ini[28,105] = -1.84896616921897
    jac_ini[28,106] = -9.21038227100566
    jac_ini[28,107] = -0.793238195499528
    jac_ini[28,108] = -9.00835072044485
    jac_ini[28,364] = 1
    jac_ini[29,25] = 9.00835072044484
    jac_ini[29,26] = -0.793238195499527
    jac_ini[29,27] = 9.21038227100566
    jac_ini[29,28] = -1.84896616921897
    jac_ini[29,29] = -30.9517475172273
    jac_ini[29,30] = -5.65456401516768
    jac_ini[29,31] = 9.21038227100566
    jac_ini[29,32] = -1.84896616921897
    jac_ini[29,101] = -9.00835072044484
    jac_ini[29,102] = 0.793238195499527
    jac_ini[29,103] = -9.21038227100566
    jac_ini[29,104] = 1.84896616921897
    jac_ini[29,105] = 30.9517475172273
    jac_ini[29,106] = 5.65456401516768
    jac_ini[29,107] = -9.21038227100566
    jac_ini[29,108] = 1.84896616921897
    jac_ini[29,365] = 1
    jac_ini[30,25] = 0.793238195499527
    jac_ini[30,26] = 9.00835072044484
    jac_ini[30,27] = 1.84896616921897
    jac_ini[30,28] = 9.21038227100566
    jac_ini[30,29] = 5.65456401516768
    jac_ini[30,30] = -30.9517475172273
    jac_ini[30,31] = 1.84896616921897
    jac_ini[30,32] = 9.21038227100566
    jac_ini[30,101] = -0.793238195499527
    jac_ini[30,102] = -9.00835072044484
    jac_ini[30,103] = -1.84896616921897
    jac_ini[30,104] = -9.21038227100566
    jac_ini[30,105] = -5.65456401516768
    jac_ini[30,106] = 30.9517475172273
    jac_ini[30,107] = -1.84896616921897
    jac_ini[30,108] = -9.21038227100566
    jac_ini[30,366] = 1
    jac_ini[31,25] = 9.21038227100566
    jac_ini[31,26] = -1.84896616921897
    jac_ini[31,27] = 9.00835072044485
    jac_ini[31,28] = -0.793238195499527
    jac_ini[31,29] = 9.21038227100566
    jac_ini[31,30] = -1.84896616921897
    jac_ini[31,31] = -30.9767475172273
    jac_ini[31,32] = -5.65456401516768
    jac_ini[31,101] = -9.21038227100566
    jac_ini[31,102] = 1.84896616921897
    jac_ini[31,103] = -9.00835072044485
    jac_ini[31,104] = 0.793238195499527
    jac_ini[31,105] = -9.21038227100566
    jac_ini[31,106] = 1.84896616921897
    jac_ini[31,107] = 30.9517475172273
    jac_ini[31,108] = 5.65456401516768
    jac_ini[32,25] = 1.84896616921897
    jac_ini[32,26] = 9.21038227100566
    jac_ini[32,27] = 0.793238195499527
    jac_ini[32,28] = 9.00835072044485
    jac_ini[32,29] = 1.84896616921897
    jac_ini[32,30] = 9.21038227100566
    jac_ini[32,31] = 5.65456401516768
    jac_ini[32,32] = -30.9767475172273
    jac_ini[32,101] = -1.84896616921897
    jac_ini[32,102] = -9.21038227100566
    jac_ini[32,103] = -0.793238195499527
    jac_ini[32,104] = -9.00835072044485
    jac_ini[32,105] = -1.84896616921897
    jac_ini[32,106] = -9.21038227100566
    jac_ini[32,107] = -5.65456401516768
    jac_ini[32,108] = 30.9517475172273
    jac_ini[33,33] = -30.9517475172273
    jac_ini[33,34] = -5.65456401516768
    jac_ini[33,35] = 9.21038227100566
    jac_ini[33,36] = -1.84896616921897
    jac_ini[33,37] = 9.00835072044485
    jac_ini[33,38] = -0.793238195499529
    jac_ini[33,39] = 9.21038227100566
    jac_ini[33,40] = -1.84896616921897
    jac_ini[33,125] = 30.9517475172273
    jac_ini[33,126] = 5.65456401516768
    jac_ini[33,127] = -9.21038227100566
    jac_ini[33,128] = 1.84896616921897
    jac_ini[33,129] = -9.00835072044485
    jac_ini[33,130] = 0.793238195499529
    jac_ini[33,131] = -9.21038227100566
    jac_ini[33,132] = 1.84896616921897
    jac_ini[33,369] = 1
    jac_ini[34,33] = 5.65456401516768
    jac_ini[34,34] = -30.9517475172273
    jac_ini[34,35] = 1.84896616921897
    jac_ini[34,36] = 9.21038227100566
    jac_ini[34,37] = 0.793238195499529
    jac_ini[34,38] = 9.00835072044485
    jac_ini[34,39] = 1.84896616921897
    jac_ini[34,40] = 9.21038227100566
    jac_ini[34,125] = -5.65456401516768
    jac_ini[34,126] = 30.9517475172273
    jac_ini[34,127] = -1.84896616921897
    jac_ini[34,128] = -9.21038227100566
    jac_ini[34,129] = -0.793238195499529
    jac_ini[34,130] = -9.00835072044485
    jac_ini[34,131] = -1.84896616921897
    jac_ini[34,132] = -9.21038227100566
    jac_ini[34,370] = 1
    jac_ini[35,33] = 9.21038227100566
    jac_ini[35,34] = -1.84896616921897
    jac_ini[35,35] = -30.9517475172273
    jac_ini[35,36] = -5.65456401516768
    jac_ini[35,37] = 9.21038227100566
    jac_ini[35,38] = -1.84896616921897
    jac_ini[35,39] = 9.00835072044485
    jac_ini[35,40] = -0.793238195499528
    jac_ini[35,125] = -9.21038227100566
    jac_ini[35,126] = 1.84896616921897
    jac_ini[35,127] = 30.9517475172273
    jac_ini[35,128] = 5.65456401516768
    jac_ini[35,129] = -9.21038227100566
    jac_ini[35,130] = 1.84896616921897
    jac_ini[35,131] = -9.00835072044485
    jac_ini[35,132] = 0.793238195499528
    jac_ini[35,371] = 1
    jac_ini[36,33] = 1.84896616921897
    jac_ini[36,34] = 9.21038227100566
    jac_ini[36,35] = 5.65456401516768
    jac_ini[36,36] = -30.9517475172273
    jac_ini[36,37] = 1.84896616921897
    jac_ini[36,38] = 9.21038227100566
    jac_ini[36,39] = 0.793238195499528
    jac_ini[36,40] = 9.00835072044485
    jac_ini[36,125] = -1.84896616921897
    jac_ini[36,126] = -9.21038227100566
    jac_ini[36,127] = -5.65456401516768
    jac_ini[36,128] = 30.9517475172273
    jac_ini[36,129] = -1.84896616921897
    jac_ini[36,130] = -9.21038227100566
    jac_ini[36,131] = -0.793238195499528
    jac_ini[36,132] = -9.00835072044485
    jac_ini[36,372] = 1
    jac_ini[37,33] = 9.00835072044484
    jac_ini[37,34] = -0.793238195499527
    jac_ini[37,35] = 9.21038227100566
    jac_ini[37,36] = -1.84896616921897
    jac_ini[37,37] = -30.9517475172273
    jac_ini[37,38] = -5.65456401516768
    jac_ini[37,39] = 9.21038227100566
    jac_ini[37,40] = -1.84896616921897
    jac_ini[37,125] = -9.00835072044484
    jac_ini[37,126] = 0.793238195499527
    jac_ini[37,127] = -9.21038227100566
    jac_ini[37,128] = 1.84896616921897
    jac_ini[37,129] = 30.9517475172273
    jac_ini[37,130] = 5.65456401516768
    jac_ini[37,131] = -9.21038227100566
    jac_ini[37,132] = 1.84896616921897
    jac_ini[37,373] = 1
    jac_ini[38,33] = 0.793238195499527
    jac_ini[38,34] = 9.00835072044484
    jac_ini[38,35] = 1.84896616921897
    jac_ini[38,36] = 9.21038227100566
    jac_ini[38,37] = 5.65456401516768
    jac_ini[38,38] = -30.9517475172273
    jac_ini[38,39] = 1.84896616921897
    jac_ini[38,40] = 9.21038227100566
    jac_ini[38,125] = -0.793238195499527
    jac_ini[38,126] = -9.00835072044484
    jac_ini[38,127] = -1.84896616921897
    jac_ini[38,128] = -9.21038227100566
    jac_ini[38,129] = -5.65456401516768
    jac_ini[38,130] = 30.9517475172273
    jac_ini[38,131] = -1.84896616921897
    jac_ini[38,132] = -9.21038227100566
    jac_ini[38,374] = 1
    jac_ini[39,33] = 9.21038227100566
    jac_ini[39,34] = -1.84896616921897
    jac_ini[39,35] = 9.00835072044485
    jac_ini[39,36] = -0.793238195499527
    jac_ini[39,37] = 9.21038227100566
    jac_ini[39,38] = -1.84896616921897
    jac_ini[39,39] = -30.9767475172273
    jac_ini[39,40] = -5.65456401516768
    jac_ini[39,125] = -9.21038227100566
    jac_ini[39,126] = 1.84896616921897
    jac_ini[39,127] = -9.00835072044485
    jac_ini[39,128] = 0.793238195499527
    jac_ini[39,129] = -9.21038227100566
    jac_ini[39,130] = 1.84896616921897
    jac_ini[39,131] = 30.9517475172273
    jac_ini[39,132] = 5.65456401516768
    jac_ini[40,33] = 1.84896616921897
    jac_ini[40,34] = 9.21038227100566
    jac_ini[40,35] = 0.793238195499527
    jac_ini[40,36] = 9.00835072044485
    jac_ini[40,37] = 1.84896616921897
    jac_ini[40,38] = 9.21038227100566
    jac_ini[40,39] = 5.65456401516768
    jac_ini[40,40] = -30.9767475172273
    jac_ini[40,125] = -1.84896616921897
    jac_ini[40,126] = -9.21038227100566
    jac_ini[40,127] = -0.793238195499527
    jac_ini[40,128] = -9.00835072044485
    jac_ini[40,129] = -1.84896616921897
    jac_ini[40,130] = -9.21038227100566
    jac_ini[40,131] = -5.65456401516768
    jac_ini[40,132] = 30.9517475172273
    jac_ini[41,41] = -30.9517475172273
    jac_ini[41,42] = -5.65456401516768
    jac_ini[41,43] = 9.21038227100566
    jac_ini[41,44] = -1.84896616921897
    jac_ini[41,45] = 9.00835072044485
    jac_ini[41,46] = -0.793238195499529
    jac_ini[41,47] = 9.21038227100566
    jac_ini[41,48] = -1.84896616921897
    jac_ini[41,133] = 30.9517475172273
    jac_ini[41,134] = 5.65456401516768
    jac_ini[41,135] = -9.21038227100566
    jac_ini[41,136] = 1.84896616921897
    jac_ini[41,137] = -9.00835072044485
    jac_ini[41,138] = 0.793238195499529
    jac_ini[41,139] = -9.21038227100566
    jac_ini[41,140] = 1.84896616921897
    jac_ini[41,377] = 1
    jac_ini[42,41] = 5.65456401516768
    jac_ini[42,42] = -30.9517475172273
    jac_ini[42,43] = 1.84896616921897
    jac_ini[42,44] = 9.21038227100566
    jac_ini[42,45] = 0.793238195499529
    jac_ini[42,46] = 9.00835072044485
    jac_ini[42,47] = 1.84896616921897
    jac_ini[42,48] = 9.21038227100566
    jac_ini[42,133] = -5.65456401516768
    jac_ini[42,134] = 30.9517475172273
    jac_ini[42,135] = -1.84896616921897
    jac_ini[42,136] = -9.21038227100566
    jac_ini[42,137] = -0.793238195499529
    jac_ini[42,138] = -9.00835072044485
    jac_ini[42,139] = -1.84896616921897
    jac_ini[42,140] = -9.21038227100566
    jac_ini[42,378] = 1
    jac_ini[43,41] = 9.21038227100566
    jac_ini[43,42] = -1.84896616921897
    jac_ini[43,43] = -30.9517475172273
    jac_ini[43,44] = -5.65456401516768
    jac_ini[43,45] = 9.21038227100566
    jac_ini[43,46] = -1.84896616921897
    jac_ini[43,47] = 9.00835072044485
    jac_ini[43,48] = -0.793238195499528
    jac_ini[43,133] = -9.21038227100566
    jac_ini[43,134] = 1.84896616921897
    jac_ini[43,135] = 30.9517475172273
    jac_ini[43,136] = 5.65456401516768
    jac_ini[43,137] = -9.21038227100566
    jac_ini[43,138] = 1.84896616921897
    jac_ini[43,139] = -9.00835072044485
    jac_ini[43,140] = 0.793238195499528
    jac_ini[43,379] = 1
    jac_ini[44,41] = 1.84896616921897
    jac_ini[44,42] = 9.21038227100566
    jac_ini[44,43] = 5.65456401516768
    jac_ini[44,44] = -30.9517475172273
    jac_ini[44,45] = 1.84896616921897
    jac_ini[44,46] = 9.21038227100566
    jac_ini[44,47] = 0.793238195499528
    jac_ini[44,48] = 9.00835072044485
    jac_ini[44,133] = -1.84896616921897
    jac_ini[44,134] = -9.21038227100566
    jac_ini[44,135] = -5.65456401516768
    jac_ini[44,136] = 30.9517475172273
    jac_ini[44,137] = -1.84896616921897
    jac_ini[44,138] = -9.21038227100566
    jac_ini[44,139] = -0.793238195499528
    jac_ini[44,140] = -9.00835072044485
    jac_ini[44,380] = 1
    jac_ini[45,41] = 9.00835072044484
    jac_ini[45,42] = -0.793238195499527
    jac_ini[45,43] = 9.21038227100566
    jac_ini[45,44] = -1.84896616921897
    jac_ini[45,45] = -30.9517475172273
    jac_ini[45,46] = -5.65456401516768
    jac_ini[45,47] = 9.21038227100566
    jac_ini[45,48] = -1.84896616921897
    jac_ini[45,133] = -9.00835072044484
    jac_ini[45,134] = 0.793238195499527
    jac_ini[45,135] = -9.21038227100566
    jac_ini[45,136] = 1.84896616921897
    jac_ini[45,137] = 30.9517475172273
    jac_ini[45,138] = 5.65456401516768
    jac_ini[45,139] = -9.21038227100566
    jac_ini[45,140] = 1.84896616921897
    jac_ini[45,381] = 1
    jac_ini[46,41] = 0.793238195499527
    jac_ini[46,42] = 9.00835072044484
    jac_ini[46,43] = 1.84896616921897
    jac_ini[46,44] = 9.21038227100566
    jac_ini[46,45] = 5.65456401516768
    jac_ini[46,46] = -30.9517475172273
    jac_ini[46,47] = 1.84896616921897
    jac_ini[46,48] = 9.21038227100566
    jac_ini[46,133] = -0.793238195499527
    jac_ini[46,134] = -9.00835072044484
    jac_ini[46,135] = -1.84896616921897
    jac_ini[46,136] = -9.21038227100566
    jac_ini[46,137] = -5.65456401516768
    jac_ini[46,138] = 30.9517475172273
    jac_ini[46,139] = -1.84896616921897
    jac_ini[46,140] = -9.21038227100566
    jac_ini[46,382] = 1
    jac_ini[47,41] = 9.21038227100566
    jac_ini[47,42] = -1.84896616921897
    jac_ini[47,43] = 9.00835072044485
    jac_ini[47,44] = -0.793238195499527
    jac_ini[47,45] = 9.21038227100566
    jac_ini[47,46] = -1.84896616921897
    jac_ini[47,47] = -30.9767475172273
    jac_ini[47,48] = -5.65456401516768
    jac_ini[47,133] = -9.21038227100566
    jac_ini[47,134] = 1.84896616921897
    jac_ini[47,135] = -9.00835072044485
    jac_ini[47,136] = 0.793238195499527
    jac_ini[47,137] = -9.21038227100566
    jac_ini[47,138] = 1.84896616921897
    jac_ini[47,139] = 30.9517475172273
    jac_ini[47,140] = 5.65456401516768
    jac_ini[48,41] = 1.84896616921897
    jac_ini[48,42] = 9.21038227100566
    jac_ini[48,43] = 0.793238195499527
    jac_ini[48,44] = 9.00835072044485
    jac_ini[48,45] = 1.84896616921897
    jac_ini[48,46] = 9.21038227100566
    jac_ini[48,47] = 5.65456401516768
    jac_ini[48,48] = -30.9767475172273
    jac_ini[48,133] = -1.84896616921897
    jac_ini[48,134] = -9.21038227100566
    jac_ini[48,135] = -0.793238195499527
    jac_ini[48,136] = -9.00835072044485
    jac_ini[48,137] = -1.84896616921897
    jac_ini[48,138] = -9.21038227100566
    jac_ini[48,139] = -5.65456401516768
    jac_ini[48,140] = 30.9517475172273
    jac_ini[49,49] = -135.409614082600
    jac_ini[49,223] = 135.409614082600
    jac_ini[49,385] = 1
    jac_ini[50,50] = -135.409614082600
    jac_ini[50,224] = 135.409614082600
    jac_ini[50,386] = 1
    jac_ini[51,51] = -135.409614082600
    jac_ini[51,229] = 135.409614082600
    jac_ini[51,387] = 1
    jac_ini[52,52] = -135.409614082600
    jac_ini[52,230] = 135.409614082600
    jac_ini[52,388] = 1
    jac_ini[53,53] = -157.977883096366
    jac_ini[53,167] = 157.977883096366
    jac_ini[53,389] = 1
    jac_ini[54,54] = -157.977883096366
    jac_ini[54,168] = 157.977883096366
    jac_ini[54,390] = 1
    jac_ini[55,55] = -157.977883096366
    jac_ini[55,173] = 157.977883096366
    jac_ini[55,391] = 1
    jac_ini[56,56] = -157.977883096366
    jac_ini[56,174] = 157.977883096366
    jac_ini[56,392] = 1
    jac_ini[57,57] = -157.977883096366
    jac_ini[57,183] = 157.977883096366
    jac_ini[57,393] = 1
    jac_ini[58,58] = -157.977883096366
    jac_ini[58,184] = 157.977883096366
    jac_ini[58,394] = 1
    jac_ini[59,59] = -157.977883096366
    jac_ini[59,189] = 157.977883096366
    jac_ini[59,395] = 1
    jac_ini[60,60] = -157.977883096366
    jac_ini[60,190] = 157.977883096366
    jac_ini[60,396] = 1
    jac_ini[61,61] = -157.977883096366
    jac_ini[61,191] = 157.977883096366
    jac_ini[61,397] = 1
    jac_ini[62,62] = -157.977883096366
    jac_ini[62,192] = 157.977883096366
    jac_ini[62,398] = 1
    jac_ini[63,63] = -157.977883096366
    jac_ini[63,197] = 157.977883096366
    jac_ini[63,399] = 1
    jac_ini[64,64] = -157.977883096366
    jac_ini[64,198] = 157.977883096366
    jac_ini[64,400] = 1
    jac_ini[65,65] = -157.977883096366
    jac_ini[65,199] = 157.977883096366
    jac_ini[65,401] = 1
    jac_ini[66,66] = -157.977883096366
    jac_ini[66,200] = 157.977883096366
    jac_ini[66,402] = 1
    jac_ini[67,67] = -157.977883096366
    jac_ini[67,205] = 157.977883096366
    jac_ini[67,403] = 1
    jac_ini[68,68] = -157.977883096366
    jac_ini[68,206] = 157.977883096366
    jac_ini[68,404] = 1
    jac_ini[69,1] = 105.571769313180
    jac_ini[69,2] = 54.0657727682604
    jac_ini[69,3] = -39.6392229058202
    jac_ini[69,4] = -10.2713736253513
    jac_ini[69,5] = -24.9575997948692
    jac_ini[69,6] = -23.2849644809540
    jac_ini[69,7] = -39.6392229058202
    jac_ini[69,8] = -10.2713736253513
    jac_ini[69,69] = -211.143538626360
    jac_ini[69,70] = -108.131545536521
    jac_ini[69,71] = 79.2784458116403
    jac_ini[69,72] = 20.5427472507027
    jac_ini[69,73] = 49.9151995897384
    jac_ini[69,74] = 46.5699289619080
    jac_ini[69,75] = 79.2784458116403
    jac_ini[69,76] = 20.5427472507027
    jac_ini[69,77] = 105.571769313180
    jac_ini[69,78] = 54.0657727682604
    jac_ini[69,79] = -39.6392229058202
    jac_ini[69,80] = -10.2713736253513
    jac_ini[69,81] = -24.9575997948692
    jac_ini[69,82] = -23.2849644809540
    jac_ini[69,83] = -39.6392229058202
    jac_ini[69,84] = -10.2713736253513
    jac_ini[70,1] = -54.0657727682604
    jac_ini[70,2] = 105.571769313180
    jac_ini[70,3] = 10.2713736253513
    jac_ini[70,4] = -39.6392229058202
    jac_ini[70,5] = 23.2849644809540
    jac_ini[70,6] = -24.9575997948692
    jac_ini[70,7] = 10.2713736253513
    jac_ini[70,8] = -39.6392229058202
    jac_ini[70,69] = 108.131545536521
    jac_ini[70,70] = -211.143538626360
    jac_ini[70,71] = -20.5427472507027
    jac_ini[70,72] = 79.2784458116403
    jac_ini[70,73] = -46.5699289619080
    jac_ini[70,74] = 49.9151995897384
    jac_ini[70,75] = -20.5427472507027
    jac_ini[70,76] = 79.2784458116403
    jac_ini[70,77] = -54.0657727682604
    jac_ini[70,78] = 105.571769313180
    jac_ini[70,79] = 10.2713736253513
    jac_ini[70,80] = -39.6392229058202
    jac_ini[70,81] = 23.2849644809540
    jac_ini[70,82] = -24.9575997948692
    jac_ini[70,83] = 10.2713736253513
    jac_ini[70,84] = -39.6392229058202
    jac_ini[71,1] = -39.6392229058202
    jac_ini[71,2] = -10.2713736253513
    jac_ini[71,3] = 105.571769313180
    jac_ini[71,4] = 54.0657727682604
    jac_ini[71,5] = -39.6392229058201
    jac_ini[71,6] = -10.2713736253513
    jac_ini[71,7] = -24.9575997948692
    jac_ini[71,8] = -23.2849644809540
    jac_ini[71,69] = 79.2784458116403
    jac_ini[71,70] = 20.5427472507027
    jac_ini[71,71] = -211.143538626360
    jac_ini[71,72] = -108.131545536521
    jac_ini[71,73] = 79.2784458116403
    jac_ini[71,74] = 20.5427472507027
    jac_ini[71,75] = 49.9151995897384
    jac_ini[71,76] = 46.5699289619080
    jac_ini[71,77] = -39.6392229058202
    jac_ini[71,78] = -10.2713736253513
    jac_ini[71,79] = 105.571769313180
    jac_ini[71,80] = 54.0657727682604
    jac_ini[71,81] = -39.6392229058201
    jac_ini[71,82] = -10.2713736253513
    jac_ini[71,83] = -24.9575997948692
    jac_ini[71,84] = -23.2849644809540
    jac_ini[72,1] = 10.2713736253513
    jac_ini[72,2] = -39.6392229058202
    jac_ini[72,3] = -54.0657727682604
    jac_ini[72,4] = 105.571769313180
    jac_ini[72,5] = 10.2713736253513
    jac_ini[72,6] = -39.6392229058201
    jac_ini[72,7] = 23.2849644809540
    jac_ini[72,8] = -24.9575997948692
    jac_ini[72,69] = -20.5427472507027
    jac_ini[72,70] = 79.2784458116403
    jac_ini[72,71] = 108.131545536521
    jac_ini[72,72] = -211.143538626360
    jac_ini[72,73] = -20.5427472507027
    jac_ini[72,74] = 79.2784458116403
    jac_ini[72,75] = -46.5699289619080
    jac_ini[72,76] = 49.9151995897384
    jac_ini[72,77] = 10.2713736253513
    jac_ini[72,78] = -39.6392229058202
    jac_ini[72,79] = -54.0657727682604
    jac_ini[72,80] = 105.571769313180
    jac_ini[72,81] = 10.2713736253513
    jac_ini[72,82] = -39.6392229058201
    jac_ini[72,83] = 23.2849644809540
    jac_ini[72,84] = -24.9575997948692
    jac_ini[73,1] = -24.9575997948692
    jac_ini[73,2] = -23.2849644809540
    jac_ini[73,3] = -39.6392229058202
    jac_ini[73,4] = -10.2713736253513
    jac_ini[73,5] = 105.571769313180
    jac_ini[73,6] = 54.0657727682604
    jac_ini[73,7] = -39.6392229058201
    jac_ini[73,8] = -10.2713736253514
    jac_ini[73,69] = 49.9151995897384
    jac_ini[73,70] = 46.5699289619080
    jac_ini[73,71] = 79.2784458116404
    jac_ini[73,72] = 20.5427472507027
    jac_ini[73,73] = -211.143538626360
    jac_ini[73,74] = -108.131545536521
    jac_ini[73,75] = 79.2784458116403
    jac_ini[73,76] = 20.5427472507027
    jac_ini[73,77] = -24.9575997948692
    jac_ini[73,78] = -23.2849644809540
    jac_ini[73,79] = -39.6392229058202
    jac_ini[73,80] = -10.2713736253513
    jac_ini[73,81] = 105.571769313180
    jac_ini[73,82] = 54.0657727682604
    jac_ini[73,83] = -39.6392229058201
    jac_ini[73,84] = -10.2713736253514
    jac_ini[74,1] = 23.2849644809540
    jac_ini[74,2] = -24.9575997948692
    jac_ini[74,3] = 10.2713736253513
    jac_ini[74,4] = -39.6392229058202
    jac_ini[74,5] = -54.0657727682604
    jac_ini[74,6] = 105.571769313180
    jac_ini[74,7] = 10.2713736253514
    jac_ini[74,8] = -39.6392229058201
    jac_ini[74,69] = -46.5699289619080
    jac_ini[74,70] = 49.9151995897384
    jac_ini[74,71] = -20.5427472507027
    jac_ini[74,72] = 79.2784458116404
    jac_ini[74,73] = 108.131545536521
    jac_ini[74,74] = -211.143538626360
    jac_ini[74,75] = -20.5427472507027
    jac_ini[74,76] = 79.2784458116403
    jac_ini[74,77] = 23.2849644809540
    jac_ini[74,78] = -24.9575997948692
    jac_ini[74,79] = 10.2713736253513
    jac_ini[74,80] = -39.6392229058202
    jac_ini[74,81] = -54.0657727682604
    jac_ini[74,82] = 105.571769313180
    jac_ini[74,83] = 10.2713736253514
    jac_ini[74,84] = -39.6392229058201
    jac_ini[75,1] = -39.6392229058202
    jac_ini[75,2] = -10.2713736253513
    jac_ini[75,3] = -24.9575997948692
    jac_ini[75,4] = -23.2849644809540
    jac_ini[75,5] = -39.6392229058202
    jac_ini[75,6] = -10.2713736253513
    jac_ini[75,7] = 105.571769313180
    jac_ini[75,8] = 54.0657727682604
    jac_ini[75,69] = 79.2784458116403
    jac_ini[75,70] = 20.5427472507027
    jac_ini[75,71] = 49.9151995897384
    jac_ini[75,72] = 46.5699289619080
    jac_ini[75,73] = 79.2784458116403
    jac_ini[75,74] = 20.5427472507027
    jac_ini[75,75] = -211.168538626360
    jac_ini[75,76] = -108.131545536521
    jac_ini[75,77] = -39.6392229058202
    jac_ini[75,78] = -10.2713736253513
    jac_ini[75,79] = -24.9575997948692
    jac_ini[75,80] = -23.2849644809540
    jac_ini[75,81] = -39.6392229058202
    jac_ini[75,82] = -10.2713736253513
    jac_ini[75,83] = 105.571769313180
    jac_ini[75,84] = 54.0657727682604
    jac_ini[76,1] = 10.2713736253513
    jac_ini[76,2] = -39.6392229058202
    jac_ini[76,3] = 23.2849644809540
    jac_ini[76,4] = -24.9575997948692
    jac_ini[76,5] = 10.2713736253513
    jac_ini[76,6] = -39.6392229058202
    jac_ini[76,7] = -54.0657727682604
    jac_ini[76,8] = 105.571769313180
    jac_ini[76,69] = -20.5427472507027
    jac_ini[76,70] = 79.2784458116403
    jac_ini[76,71] = -46.5699289619080
    jac_ini[76,72] = 49.9151995897384
    jac_ini[76,73] = -20.5427472507027
    jac_ini[76,74] = 79.2784458116403
    jac_ini[76,75] = 108.131545536521
    jac_ini[76,76] = -211.168538626360
    jac_ini[76,77] = 10.2713736253513
    jac_ini[76,78] = -39.6392229058202
    jac_ini[76,79] = 23.2849644809540
    jac_ini[76,80] = -24.9575997948692
    jac_ini[76,81] = 10.2713736253513
    jac_ini[76,82] = -39.6392229058202
    jac_ini[76,83] = -54.0657727682604
    jac_ini[76,84] = 105.571769313180
    jac_ini[77,9] = 26.5300693004806
    jac_ini[77,10] = 4.84676915585801
    jac_ini[77,11] = -7.89461337514770
    jac_ini[77,12] = 1.58482814504483
    jac_ini[77,13] = -7.72144347466701
    jac_ini[77,14] = 0.679918453285310
    jac_ini[77,15] = -7.89461337514771
    jac_ini[77,16] = 1.58482814504483
    jac_ini[77,69] = 105.571769313180
    jac_ini[77,70] = 54.0657727682604
    jac_ini[77,71] = -39.6392229058202
    jac_ini[77,72] = -10.2713736253513
    jac_ini[77,73] = -24.9575997948692
    jac_ini[77,74] = -23.2849644809540
    jac_ini[77,75] = -39.6392229058202
    jac_ini[77,76] = -10.2713736253513
    jac_ini[77,77] = -237.673607926841
    jac_ini[77,78] = -112.978314692379
    jac_ini[77,79] = 87.1730591867880
    jac_ini[77,80] = 18.9579191056578
    jac_ini[77,81] = 57.6366430644055
    jac_ini[77,82] = 45.8900105086227
    jac_ini[77,83] = 87.1730591867880
    jac_ini[77,84] = 18.9579191056579
    jac_ini[77,85] = 105.571769313180
    jac_ini[77,86] = 54.0657727682604
    jac_ini[77,87] = -39.6392229058202
    jac_ini[77,88] = -10.2713736253513
    jac_ini[77,89] = -24.9575997948692
    jac_ini[77,90] = -23.2849644809540
    jac_ini[77,91] = -39.6392229058202
    jac_ini[77,92] = -10.2713736253513
    jac_ini[78,9] = -4.84676915585801
    jac_ini[78,10] = 26.5300693004806
    jac_ini[78,11] = -1.58482814504483
    jac_ini[78,12] = -7.89461337514770
    jac_ini[78,13] = -0.679918453285310
    jac_ini[78,14] = -7.72144347466701
    jac_ini[78,15] = -1.58482814504483
    jac_ini[78,16] = -7.89461337514771
    jac_ini[78,69] = -54.0657727682604
    jac_ini[78,70] = 105.571769313180
    jac_ini[78,71] = 10.2713736253513
    jac_ini[78,72] = -39.6392229058202
    jac_ini[78,73] = 23.2849644809540
    jac_ini[78,74] = -24.9575997948692
    jac_ini[78,75] = 10.2713736253513
    jac_ini[78,76] = -39.6392229058202
    jac_ini[78,77] = 112.978314692379
    jac_ini[78,78] = -237.673607926841
    jac_ini[78,79] = -18.9579191056578
    jac_ini[78,80] = 87.1730591867880
    jac_ini[78,81] = -45.8900105086227
    jac_ini[78,82] = 57.6366430644055
    jac_ini[78,83] = -18.9579191056579
    jac_ini[78,84] = 87.1730591867880
    jac_ini[78,85] = -54.0657727682604
    jac_ini[78,86] = 105.571769313180
    jac_ini[78,87] = 10.2713736253513
    jac_ini[78,88] = -39.6392229058202
    jac_ini[78,89] = 23.2849644809540
    jac_ini[78,90] = -24.9575997948692
    jac_ini[78,91] = 10.2713736253513
    jac_ini[78,92] = -39.6392229058202
    jac_ini[79,9] = -7.89461337514771
    jac_ini[79,10] = 1.58482814504483
    jac_ini[79,11] = 26.5300693004806
    jac_ini[79,12] = 4.84676915585801
    jac_ini[79,13] = -7.89461337514771
    jac_ini[79,14] = 1.58482814504483
    jac_ini[79,15] = -7.72144347466701
    jac_ini[79,16] = 0.679918453285308
    jac_ini[79,69] = -39.6392229058202
    jac_ini[79,70] = -10.2713736253513
    jac_ini[79,71] = 105.571769313180
    jac_ini[79,72] = 54.0657727682604
    jac_ini[79,73] = -39.6392229058201
    jac_ini[79,74] = -10.2713736253513
    jac_ini[79,75] = -24.9575997948692
    jac_ini[79,76] = -23.2849644809540
    jac_ini[79,77] = 87.1730591867880
    jac_ini[79,78] = 18.9579191056579
    jac_ini[79,79] = -237.673607926841
    jac_ini[79,80] = -112.978314692379
    jac_ini[79,81] = 87.1730591867880
    jac_ini[79,82] = 18.9579191056579
    jac_ini[79,83] = 57.6366430644054
    jac_ini[79,84] = 45.8900105086227
    jac_ini[79,85] = -39.6392229058202
    jac_ini[79,86] = -10.2713736253513
    jac_ini[79,87] = 105.571769313180
    jac_ini[79,88] = 54.0657727682604
    jac_ini[79,89] = -39.6392229058201
    jac_ini[79,90] = -10.2713736253513
    jac_ini[79,91] = -24.9575997948692
    jac_ini[79,92] = -23.2849644809540
    jac_ini[80,9] = -1.58482814504483
    jac_ini[80,10] = -7.89461337514771
    jac_ini[80,11] = -4.84676915585801
    jac_ini[80,12] = 26.5300693004806
    jac_ini[80,13] = -1.58482814504483
    jac_ini[80,14] = -7.89461337514771
    jac_ini[80,15] = -0.679918453285308
    jac_ini[80,16] = -7.72144347466701
    jac_ini[80,69] = 10.2713736253513
    jac_ini[80,70] = -39.6392229058202
    jac_ini[80,71] = -54.0657727682604
    jac_ini[80,72] = 105.571769313180
    jac_ini[80,73] = 10.2713736253513
    jac_ini[80,74] = -39.6392229058201
    jac_ini[80,75] = 23.2849644809540
    jac_ini[80,76] = -24.9575997948692
    jac_ini[80,77] = -18.9579191056579
    jac_ini[80,78] = 87.1730591867880
    jac_ini[80,79] = 112.978314692379
    jac_ini[80,80] = -237.673607926841
    jac_ini[80,81] = -18.9579191056579
    jac_ini[80,82] = 87.1730591867880
    jac_ini[80,83] = -45.8900105086227
    jac_ini[80,84] = 57.6366430644054
    jac_ini[80,85] = 10.2713736253513
    jac_ini[80,86] = -39.6392229058202
    jac_ini[80,87] = -54.0657727682604
    jac_ini[80,88] = 105.571769313180
    jac_ini[80,89] = 10.2713736253513
    jac_ini[80,90] = -39.6392229058201
    jac_ini[80,91] = 23.2849644809540
    jac_ini[80,92] = -24.9575997948692
    jac_ini[81,9] = -7.72144347466701
    jac_ini[81,10] = 0.679918453285310
    jac_ini[81,11] = -7.89461337514770
    jac_ini[81,12] = 1.58482814504483
    jac_ini[81,13] = 26.5300693004806
    jac_ini[81,14] = 4.84676915585801
    jac_ini[81,15] = -7.89461337514771
    jac_ini[81,16] = 1.58482814504483
    jac_ini[81,69] = -24.9575997948692
    jac_ini[81,70] = -23.2849644809540
    jac_ini[81,71] = -39.6392229058202
    jac_ini[81,72] = -10.2713736253513
    jac_ini[81,73] = 105.571769313180
    jac_ini[81,74] = 54.0657727682604
    jac_ini[81,75] = -39.6392229058201
    jac_ini[81,76] = -10.2713736253514
    jac_ini[81,77] = 57.6366430644054
    jac_ini[81,78] = 45.8900105086227
    jac_ini[81,79] = 87.1730591867881
    jac_ini[81,80] = 18.9579191056578
    jac_ini[81,81] = -237.673607926841
    jac_ini[81,82] = -112.978314692379
    jac_ini[81,83] = 87.1730591867880
    jac_ini[81,84] = 18.9579191056579
    jac_ini[81,85] = -24.9575997948692
    jac_ini[81,86] = -23.2849644809540
    jac_ini[81,87] = -39.6392229058202
    jac_ini[81,88] = -10.2713736253513
    jac_ini[81,89] = 105.571769313180
    jac_ini[81,90] = 54.0657727682604
    jac_ini[81,91] = -39.6392229058201
    jac_ini[81,92] = -10.2713736253514
    jac_ini[82,9] = -0.679918453285310
    jac_ini[82,10] = -7.72144347466701
    jac_ini[82,11] = -1.58482814504483
    jac_ini[82,12] = -7.89461337514770
    jac_ini[82,13] = -4.84676915585801
    jac_ini[82,14] = 26.5300693004806
    jac_ini[82,15] = -1.58482814504483
    jac_ini[82,16] = -7.89461337514771
    jac_ini[82,69] = 23.2849644809540
    jac_ini[82,70] = -24.9575997948692
    jac_ini[82,71] = 10.2713736253513
    jac_ini[82,72] = -39.6392229058202
    jac_ini[82,73] = -54.0657727682604
    jac_ini[82,74] = 105.571769313180
    jac_ini[82,75] = 10.2713736253514
    jac_ini[82,76] = -39.6392229058201
    jac_ini[82,77] = -45.8900105086227
    jac_ini[82,78] = 57.6366430644054
    jac_ini[82,79] = -18.9579191056578
    jac_ini[82,80] = 87.1730591867881
    jac_ini[82,81] = 112.978314692379
    jac_ini[82,82] = -237.673607926841
    jac_ini[82,83] = -18.9579191056579
    jac_ini[82,84] = 87.1730591867880
    jac_ini[82,85] = 23.2849644809540
    jac_ini[82,86] = -24.9575997948692
    jac_ini[82,87] = 10.2713736253513
    jac_ini[82,88] = -39.6392229058202
    jac_ini[82,89] = -54.0657727682604
    jac_ini[82,90] = 105.571769313180
    jac_ini[82,91] = 10.2713736253514
    jac_ini[82,92] = -39.6392229058201
    jac_ini[83,9] = -7.89461337514771
    jac_ini[83,10] = 1.58482814504483
    jac_ini[83,11] = -7.72144347466701
    jac_ini[83,12] = 0.679918453285308
    jac_ini[83,13] = -7.89461337514771
    jac_ini[83,14] = 1.58482814504483
    jac_ini[83,15] = 26.5300693004806
    jac_ini[83,16] = 4.84676915585801
    jac_ini[83,69] = -39.6392229058202
    jac_ini[83,70] = -10.2713736253513
    jac_ini[83,71] = -24.9575997948692
    jac_ini[83,72] = -23.2849644809540
    jac_ini[83,73] = -39.6392229058202
    jac_ini[83,74] = -10.2713736253513
    jac_ini[83,75] = 105.571769313180
    jac_ini[83,76] = 54.0657727682604
    jac_ini[83,77] = 87.1730591867880
    jac_ini[83,78] = 18.9579191056578
    jac_ini[83,79] = 57.6366430644054
    jac_ini[83,80] = 45.8900105086227
    jac_ini[83,81] = 87.1730591867880
    jac_ini[83,82] = 18.9579191056579
    jac_ini[83,83] = -237.673607926841
    jac_ini[83,84] = -112.978314692379
    jac_ini[83,85] = -39.6392229058202
    jac_ini[83,86] = -10.2713736253513
    jac_ini[83,87] = -24.9575997948692
    jac_ini[83,88] = -23.2849644809540
    jac_ini[83,89] = -39.6392229058202
    jac_ini[83,90] = -10.2713736253513
    jac_ini[83,91] = 105.571769313180
    jac_ini[83,92] = 54.0657727682604
    jac_ini[84,9] = -1.58482814504483
    jac_ini[84,10] = -7.89461337514771
    jac_ini[84,11] = -0.679918453285308
    jac_ini[84,12] = -7.72144347466701
    jac_ini[84,13] = -1.58482814504483
    jac_ini[84,14] = -7.89461337514771
    jac_ini[84,15] = -4.84676915585801
    jac_ini[84,16] = 26.5300693004806
    jac_ini[84,69] = 10.2713736253513
    jac_ini[84,70] = -39.6392229058202
    jac_ini[84,71] = 23.2849644809540
    jac_ini[84,72] = -24.9575997948692
    jac_ini[84,73] = 10.2713736253513
    jac_ini[84,74] = -39.6392229058202
    jac_ini[84,75] = -54.0657727682604
    jac_ini[84,76] = 105.571769313180
    jac_ini[84,77] = -18.9579191056578
    jac_ini[84,78] = 87.1730591867880
    jac_ini[84,79] = -45.8900105086227
    jac_ini[84,80] = 57.6366430644054
    jac_ini[84,81] = -18.9579191056579
    jac_ini[84,82] = 87.1730591867880
    jac_ini[84,83] = 112.978314692379
    jac_ini[84,84] = -237.673607926841
    jac_ini[84,85] = 10.2713736253513
    jac_ini[84,86] = -39.6392229058202
    jac_ini[84,87] = 23.2849644809540
    jac_ini[84,88] = -24.9575997948692
    jac_ini[84,89] = 10.2713736253513
    jac_ini[84,90] = -39.6392229058202
    jac_ini[84,91] = -54.0657727682604
    jac_ini[84,92] = 105.571769313180
    jac_ini[85,77] = 105.571769313180
    jac_ini[85,78] = 54.0657727682604
    jac_ini[85,79] = -39.6392229058202
    jac_ini[85,80] = -10.2713736253513
    jac_ini[85,81] = -24.9575997948692
    jac_ini[85,82] = -23.2849644809540
    jac_ini[85,83] = -39.6392229058202
    jac_ini[85,84] = -10.2713736253513
    jac_ini[85,85] = -237.673607926841
    jac_ini[85,86] = -112.978314692379
    jac_ini[85,87] = 87.1730591867880
    jac_ini[85,88] = 18.9579191056578
    jac_ini[85,89] = 57.6366430644055
    jac_ini[85,90] = 45.8900105086227
    jac_ini[85,91] = 87.1730591867880
    jac_ini[85,92] = 18.9579191056579
    jac_ini[85,93] = 105.571769313180
    jac_ini[85,94] = 54.0657727682604
    jac_ini[85,95] = -39.6392229058202
    jac_ini[85,96] = -10.2713736253513
    jac_ini[85,97] = -24.9575997948692
    jac_ini[85,98] = -23.2849644809540
    jac_ini[85,99] = -39.6392229058202
    jac_ini[85,100] = -10.2713736253513
    jac_ini[85,141] = 26.5300693004806
    jac_ini[85,142] = 4.84676915585801
    jac_ini[85,143] = -7.89461337514770
    jac_ini[85,144] = 1.58482814504483
    jac_ini[85,145] = -7.72144347466701
    jac_ini[85,146] = 0.679918453285310
    jac_ini[85,147] = -7.89461337514771
    jac_ini[85,148] = 1.58482814504483
    jac_ini[86,77] = -54.0657727682604
    jac_ini[86,78] = 105.571769313180
    jac_ini[86,79] = 10.2713736253513
    jac_ini[86,80] = -39.6392229058202
    jac_ini[86,81] = 23.2849644809540
    jac_ini[86,82] = -24.9575997948692
    jac_ini[86,83] = 10.2713736253513
    jac_ini[86,84] = -39.6392229058202
    jac_ini[86,85] = 112.978314692379
    jac_ini[86,86] = -237.673607926841
    jac_ini[86,87] = -18.9579191056578
    jac_ini[86,88] = 87.1730591867880
    jac_ini[86,89] = -45.8900105086227
    jac_ini[86,90] = 57.6366430644055
    jac_ini[86,91] = -18.9579191056579
    jac_ini[86,92] = 87.1730591867880
    jac_ini[86,93] = -54.0657727682604
    jac_ini[86,94] = 105.571769313180
    jac_ini[86,95] = 10.2713736253513
    jac_ini[86,96] = -39.6392229058202
    jac_ini[86,97] = 23.2849644809540
    jac_ini[86,98] = -24.9575997948692
    jac_ini[86,99] = 10.2713736253513
    jac_ini[86,100] = -39.6392229058202
    jac_ini[86,141] = -4.84676915585801
    jac_ini[86,142] = 26.5300693004806
    jac_ini[86,143] = -1.58482814504483
    jac_ini[86,144] = -7.89461337514770
    jac_ini[86,145] = -0.679918453285310
    jac_ini[86,146] = -7.72144347466701
    jac_ini[86,147] = -1.58482814504483
    jac_ini[86,148] = -7.89461337514771
    jac_ini[87,77] = -39.6392229058202
    jac_ini[87,78] = -10.2713736253513
    jac_ini[87,79] = 105.571769313180
    jac_ini[87,80] = 54.0657727682604
    jac_ini[87,81] = -39.6392229058201
    jac_ini[87,82] = -10.2713736253513
    jac_ini[87,83] = -24.9575997948692
    jac_ini[87,84] = -23.2849644809540
    jac_ini[87,85] = 87.1730591867880
    jac_ini[87,86] = 18.9579191056579
    jac_ini[87,87] = -237.673607926841
    jac_ini[87,88] = -112.978314692379
    jac_ini[87,89] = 87.1730591867880
    jac_ini[87,90] = 18.9579191056579
    jac_ini[87,91] = 57.6366430644054
    jac_ini[87,92] = 45.8900105086227
    jac_ini[87,93] = -39.6392229058202
    jac_ini[87,94] = -10.2713736253513
    jac_ini[87,95] = 105.571769313180
    jac_ini[87,96] = 54.0657727682604
    jac_ini[87,97] = -39.6392229058201
    jac_ini[87,98] = -10.2713736253513
    jac_ini[87,99] = -24.9575997948692
    jac_ini[87,100] = -23.2849644809540
    jac_ini[87,141] = -7.89461337514771
    jac_ini[87,142] = 1.58482814504483
    jac_ini[87,143] = 26.5300693004806
    jac_ini[87,144] = 4.84676915585801
    jac_ini[87,145] = -7.89461337514771
    jac_ini[87,146] = 1.58482814504483
    jac_ini[87,147] = -7.72144347466701
    jac_ini[87,148] = 0.679918453285308
    jac_ini[88,77] = 10.2713736253513
    jac_ini[88,78] = -39.6392229058202
    jac_ini[88,79] = -54.0657727682604
    jac_ini[88,80] = 105.571769313180
    jac_ini[88,81] = 10.2713736253513
    jac_ini[88,82] = -39.6392229058201
    jac_ini[88,83] = 23.2849644809540
    jac_ini[88,84] = -24.9575997948692
    jac_ini[88,85] = -18.9579191056579
    jac_ini[88,86] = 87.1730591867880
    jac_ini[88,87] = 112.978314692379
    jac_ini[88,88] = -237.673607926841
    jac_ini[88,89] = -18.9579191056579
    jac_ini[88,90] = 87.1730591867880
    jac_ini[88,91] = -45.8900105086227
    jac_ini[88,92] = 57.6366430644054
    jac_ini[88,93] = 10.2713736253513
    jac_ini[88,94] = -39.6392229058202
    jac_ini[88,95] = -54.0657727682604
    jac_ini[88,96] = 105.571769313180
    jac_ini[88,97] = 10.2713736253513
    jac_ini[88,98] = -39.6392229058201
    jac_ini[88,99] = 23.2849644809540
    jac_ini[88,100] = -24.9575997948692
    jac_ini[88,141] = -1.58482814504483
    jac_ini[88,142] = -7.89461337514771
    jac_ini[88,143] = -4.84676915585801
    jac_ini[88,144] = 26.5300693004806
    jac_ini[88,145] = -1.58482814504483
    jac_ini[88,146] = -7.89461337514771
    jac_ini[88,147] = -0.679918453285308
    jac_ini[88,148] = -7.72144347466701
    jac_ini[89,77] = -24.9575997948692
    jac_ini[89,78] = -23.2849644809540
    jac_ini[89,79] = -39.6392229058202
    jac_ini[89,80] = -10.2713736253513
    jac_ini[89,81] = 105.571769313180
    jac_ini[89,82] = 54.0657727682604
    jac_ini[89,83] = -39.6392229058201
    jac_ini[89,84] = -10.2713736253514
    jac_ini[89,85] = 57.6366430644054
    jac_ini[89,86] = 45.8900105086227
    jac_ini[89,87] = 87.1730591867881
    jac_ini[89,88] = 18.9579191056578
    jac_ini[89,89] = -237.673607926841
    jac_ini[89,90] = -112.978314692379
    jac_ini[89,91] = 87.1730591867880
    jac_ini[89,92] = 18.9579191056579
    jac_ini[89,93] = -24.9575997948692
    jac_ini[89,94] = -23.2849644809540
    jac_ini[89,95] = -39.6392229058202
    jac_ini[89,96] = -10.2713736253513
    jac_ini[89,97] = 105.571769313180
    jac_ini[89,98] = 54.0657727682604
    jac_ini[89,99] = -39.6392229058201
    jac_ini[89,100] = -10.2713736253514
    jac_ini[89,141] = -7.72144347466701
    jac_ini[89,142] = 0.679918453285310
    jac_ini[89,143] = -7.89461337514770
    jac_ini[89,144] = 1.58482814504483
    jac_ini[89,145] = 26.5300693004806
    jac_ini[89,146] = 4.84676915585801
    jac_ini[89,147] = -7.89461337514771
    jac_ini[89,148] = 1.58482814504483
    jac_ini[90,77] = 23.2849644809540
    jac_ini[90,78] = -24.9575997948692
    jac_ini[90,79] = 10.2713736253513
    jac_ini[90,80] = -39.6392229058202
    jac_ini[90,81] = -54.0657727682604
    jac_ini[90,82] = 105.571769313180
    jac_ini[90,83] = 10.2713736253514
    jac_ini[90,84] = -39.6392229058201
    jac_ini[90,85] = -45.8900105086227
    jac_ini[90,86] = 57.6366430644054
    jac_ini[90,87] = -18.9579191056578
    jac_ini[90,88] = 87.1730591867881
    jac_ini[90,89] = 112.978314692379
    jac_ini[90,90] = -237.673607926841
    jac_ini[90,91] = -18.9579191056579
    jac_ini[90,92] = 87.1730591867880
    jac_ini[90,93] = 23.2849644809540
    jac_ini[90,94] = -24.9575997948692
    jac_ini[90,95] = 10.2713736253513
    jac_ini[90,96] = -39.6392229058202
    jac_ini[90,97] = -54.0657727682604
    jac_ini[90,98] = 105.571769313180
    jac_ini[90,99] = 10.2713736253514
    jac_ini[90,100] = -39.6392229058201
    jac_ini[90,141] = -0.679918453285310
    jac_ini[90,142] = -7.72144347466701
    jac_ini[90,143] = -1.58482814504483
    jac_ini[90,144] = -7.89461337514770
    jac_ini[90,145] = -4.84676915585801
    jac_ini[90,146] = 26.5300693004806
    jac_ini[90,147] = -1.58482814504483
    jac_ini[90,148] = -7.89461337514771
    jac_ini[91,77] = -39.6392229058202
    jac_ini[91,78] = -10.2713736253513
    jac_ini[91,79] = -24.9575997948692
    jac_ini[91,80] = -23.2849644809540
    jac_ini[91,81] = -39.6392229058202
    jac_ini[91,82] = -10.2713736253513
    jac_ini[91,83] = 105.571769313180
    jac_ini[91,84] = 54.0657727682604
    jac_ini[91,85] = 87.1730591867880
    jac_ini[91,86] = 18.9579191056578
    jac_ini[91,87] = 57.6366430644054
    jac_ini[91,88] = 45.8900105086227
    jac_ini[91,89] = 87.1730591867880
    jac_ini[91,90] = 18.9579191056579
    jac_ini[91,91] = -237.698607926841
    jac_ini[91,92] = -112.978314692379
    jac_ini[91,93] = -39.6392229058202
    jac_ini[91,94] = -10.2713736253513
    jac_ini[91,95] = -24.9575997948692
    jac_ini[91,96] = -23.2849644809540
    jac_ini[91,97] = -39.6392229058202
    jac_ini[91,98] = -10.2713736253513
    jac_ini[91,99] = 105.571769313180
    jac_ini[91,100] = 54.0657727682604
    jac_ini[91,141] = -7.89461337514771
    jac_ini[91,142] = 1.58482814504483
    jac_ini[91,143] = -7.72144347466701
    jac_ini[91,144] = 0.679918453285308
    jac_ini[91,145] = -7.89461337514771
    jac_ini[91,146] = 1.58482814504483
    jac_ini[91,147] = 26.5300693004806
    jac_ini[91,148] = 4.84676915585801
    jac_ini[92,77] = 10.2713736253513
    jac_ini[92,78] = -39.6392229058202
    jac_ini[92,79] = 23.2849644809540
    jac_ini[92,80] = -24.9575997948692
    jac_ini[92,81] = 10.2713736253513
    jac_ini[92,82] = -39.6392229058202
    jac_ini[92,83] = -54.0657727682604
    jac_ini[92,84] = 105.571769313180
    jac_ini[92,85] = -18.9579191056578
    jac_ini[92,86] = 87.1730591867880
    jac_ini[92,87] = -45.8900105086227
    jac_ini[92,88] = 57.6366430644054
    jac_ini[92,89] = -18.9579191056579
    jac_ini[92,90] = 87.1730591867880
    jac_ini[92,91] = 112.978314692379
    jac_ini[92,92] = -237.698607926841
    jac_ini[92,93] = 10.2713736253513
    jac_ini[92,94] = -39.6392229058202
    jac_ini[92,95] = 23.2849644809540
    jac_ini[92,96] = -24.9575997948692
    jac_ini[92,97] = 10.2713736253513
    jac_ini[92,98] = -39.6392229058202
    jac_ini[92,99] = -54.0657727682604
    jac_ini[92,100] = 105.571769313180
    jac_ini[92,141] = -1.58482814504483
    jac_ini[92,142] = -7.89461337514771
    jac_ini[92,143] = -0.679918453285308
    jac_ini[92,144] = -7.72144347466701
    jac_ini[92,145] = -1.58482814504483
    jac_ini[92,146] = -7.89461337514771
    jac_ini[92,147] = -4.84676915585801
    jac_ini[92,148] = 26.5300693004806
    jac_ini[93,85] = 105.571769313180
    jac_ini[93,86] = 54.0657727682604
    jac_ini[93,87] = -39.6392229058202
    jac_ini[93,88] = -10.2713736253513
    jac_ini[93,89] = -24.9575997948692
    jac_ini[93,90] = -23.2849644809540
    jac_ini[93,91] = -39.6392229058202
    jac_ini[93,92] = -10.2713736253513
    jac_ini[93,93] = -211.143538626360
    jac_ini[93,94] = -108.131545536521
    jac_ini[93,95] = 79.2784458116403
    jac_ini[93,96] = 20.5427472507027
    jac_ini[93,97] = 49.9151995897384
    jac_ini[93,98] = 46.5699289619080
    jac_ini[93,99] = 79.2784458116403
    jac_ini[93,100] = 20.5427472507027
    jac_ini[93,101] = 105.571769313180
    jac_ini[93,102] = 54.0657727682604
    jac_ini[93,103] = -39.6392229058202
    jac_ini[93,104] = -10.2713736253513
    jac_ini[93,105] = -24.9575997948692
    jac_ini[93,106] = -23.2849644809540
    jac_ini[93,107] = -39.6392229058202
    jac_ini[93,108] = -10.2713736253513
    jac_ini[94,85] = -54.0657727682604
    jac_ini[94,86] = 105.571769313180
    jac_ini[94,87] = 10.2713736253513
    jac_ini[94,88] = -39.6392229058202
    jac_ini[94,89] = 23.2849644809540
    jac_ini[94,90] = -24.9575997948692
    jac_ini[94,91] = 10.2713736253513
    jac_ini[94,92] = -39.6392229058202
    jac_ini[94,93] = 108.131545536521
    jac_ini[94,94] = -211.143538626360
    jac_ini[94,95] = -20.5427472507027
    jac_ini[94,96] = 79.2784458116403
    jac_ini[94,97] = -46.5699289619080
    jac_ini[94,98] = 49.9151995897384
    jac_ini[94,99] = -20.5427472507027
    jac_ini[94,100] = 79.2784458116403
    jac_ini[94,101] = -54.0657727682604
    jac_ini[94,102] = 105.571769313180
    jac_ini[94,103] = 10.2713736253513
    jac_ini[94,104] = -39.6392229058202
    jac_ini[94,105] = 23.2849644809540
    jac_ini[94,106] = -24.9575997948692
    jac_ini[94,107] = 10.2713736253513
    jac_ini[94,108] = -39.6392229058202
    jac_ini[95,85] = -39.6392229058202
    jac_ini[95,86] = -10.2713736253513
    jac_ini[95,87] = 105.571769313180
    jac_ini[95,88] = 54.0657727682604
    jac_ini[95,89] = -39.6392229058201
    jac_ini[95,90] = -10.2713736253513
    jac_ini[95,91] = -24.9575997948692
    jac_ini[95,92] = -23.2849644809540
    jac_ini[95,93] = 79.2784458116403
    jac_ini[95,94] = 20.5427472507027
    jac_ini[95,95] = -211.143538626360
    jac_ini[95,96] = -108.131545536521
    jac_ini[95,97] = 79.2784458116403
    jac_ini[95,98] = 20.5427472507027
    jac_ini[95,99] = 49.9151995897384
    jac_ini[95,100] = 46.5699289619080
    jac_ini[95,101] = -39.6392229058202
    jac_ini[95,102] = -10.2713736253513
    jac_ini[95,103] = 105.571769313180
    jac_ini[95,104] = 54.0657727682604
    jac_ini[95,105] = -39.6392229058201
    jac_ini[95,106] = -10.2713736253513
    jac_ini[95,107] = -24.9575997948692
    jac_ini[95,108] = -23.2849644809540
    jac_ini[96,85] = 10.2713736253513
    jac_ini[96,86] = -39.6392229058202
    jac_ini[96,87] = -54.0657727682604
    jac_ini[96,88] = 105.571769313180
    jac_ini[96,89] = 10.2713736253513
    jac_ini[96,90] = -39.6392229058201
    jac_ini[96,91] = 23.2849644809540
    jac_ini[96,92] = -24.9575997948692
    jac_ini[96,93] = -20.5427472507027
    jac_ini[96,94] = 79.2784458116403
    jac_ini[96,95] = 108.131545536521
    jac_ini[96,96] = -211.143538626360
    jac_ini[96,97] = -20.5427472507027
    jac_ini[96,98] = 79.2784458116403
    jac_ini[96,99] = -46.5699289619080
    jac_ini[96,100] = 49.9151995897384
    jac_ini[96,101] = 10.2713736253513
    jac_ini[96,102] = -39.6392229058202
    jac_ini[96,103] = -54.0657727682604
    jac_ini[96,104] = 105.571769313180
    jac_ini[96,105] = 10.2713736253513
    jac_ini[96,106] = -39.6392229058201
    jac_ini[96,107] = 23.2849644809540
    jac_ini[96,108] = -24.9575997948692
    jac_ini[97,85] = -24.9575997948692
    jac_ini[97,86] = -23.2849644809540
    jac_ini[97,87] = -39.6392229058202
    jac_ini[97,88] = -10.2713736253513
    jac_ini[97,89] = 105.571769313180
    jac_ini[97,90] = 54.0657727682604
    jac_ini[97,91] = -39.6392229058201
    jac_ini[97,92] = -10.2713736253514
    jac_ini[97,93] = 49.9151995897384
    jac_ini[97,94] = 46.5699289619080
    jac_ini[97,95] = 79.2784458116404
    jac_ini[97,96] = 20.5427472507027
    jac_ini[97,97] = -211.143538626360
    jac_ini[97,98] = -108.131545536521
    jac_ini[97,99] = 79.2784458116403
    jac_ini[97,100] = 20.5427472507027
    jac_ini[97,101] = -24.9575997948692
    jac_ini[97,102] = -23.2849644809540
    jac_ini[97,103] = -39.6392229058202
    jac_ini[97,104] = -10.2713736253513
    jac_ini[97,105] = 105.571769313180
    jac_ini[97,106] = 54.0657727682604
    jac_ini[97,107] = -39.6392229058201
    jac_ini[97,108] = -10.2713736253514
    jac_ini[98,85] = 23.2849644809540
    jac_ini[98,86] = -24.9575997948692
    jac_ini[98,87] = 10.2713736253513
    jac_ini[98,88] = -39.6392229058202
    jac_ini[98,89] = -54.0657727682604
    jac_ini[98,90] = 105.571769313180
    jac_ini[98,91] = 10.2713736253514
    jac_ini[98,92] = -39.6392229058201
    jac_ini[98,93] = -46.5699289619080
    jac_ini[98,94] = 49.9151995897384
    jac_ini[98,95] = -20.5427472507027
    jac_ini[98,96] = 79.2784458116404
    jac_ini[98,97] = 108.131545536521
    jac_ini[98,98] = -211.143538626360
    jac_ini[98,99] = -20.5427472507027
    jac_ini[98,100] = 79.2784458116403
    jac_ini[98,101] = 23.2849644809540
    jac_ini[98,102] = -24.9575997948692
    jac_ini[98,103] = 10.2713736253513
    jac_ini[98,104] = -39.6392229058202
    jac_ini[98,105] = -54.0657727682604
    jac_ini[98,106] = 105.571769313180
    jac_ini[98,107] = 10.2713736253514
    jac_ini[98,108] = -39.6392229058201
    jac_ini[99,85] = -39.6392229058202
    jac_ini[99,86] = -10.2713736253513
    jac_ini[99,87] = -24.9575997948692
    jac_ini[99,88] = -23.2849644809540
    jac_ini[99,89] = -39.6392229058202
    jac_ini[99,90] = -10.2713736253513
    jac_ini[99,91] = 105.571769313180
    jac_ini[99,92] = 54.0657727682604
    jac_ini[99,93] = 79.2784458116403
    jac_ini[99,94] = 20.5427472507027
    jac_ini[99,95] = 49.9151995897384
    jac_ini[99,96] = 46.5699289619080
    jac_ini[99,97] = 79.2784458116403
    jac_ini[99,98] = 20.5427472507027
    jac_ini[99,99] = -211.143538626360
    jac_ini[99,100] = -108.131545536521
    jac_ini[99,101] = -39.6392229058202
    jac_ini[99,102] = -10.2713736253513
    jac_ini[99,103] = -24.9575997948692
    jac_ini[99,104] = -23.2849644809540
    jac_ini[99,105] = -39.6392229058202
    jac_ini[99,106] = -10.2713736253513
    jac_ini[99,107] = 105.571769313180
    jac_ini[99,108] = 54.0657727682604
    jac_ini[100,85] = 10.2713736253513
    jac_ini[100,86] = -39.6392229058202
    jac_ini[100,87] = 23.2849644809540
    jac_ini[100,88] = -24.9575997948692
    jac_ini[100,89] = 10.2713736253513
    jac_ini[100,90] = -39.6392229058202
    jac_ini[100,91] = -54.0657727682604
    jac_ini[100,92] = 105.571769313180
    jac_ini[100,93] = -20.5427472507027
    jac_ini[100,94] = 79.2784458116403
    jac_ini[100,95] = -46.5699289619080
    jac_ini[100,96] = 49.9151995897384
    jac_ini[100,97] = -20.5427472507027
    jac_ini[100,98] = 79.2784458116403
    jac_ini[100,99] = 108.131545536521
    jac_ini[100,100] = -211.143538626360
    jac_ini[100,101] = 10.2713736253513
    jac_ini[100,102] = -39.6392229058202
    jac_ini[100,103] = 23.2849644809540
    jac_ini[100,104] = -24.9575997948692
    jac_ini[100,105] = 10.2713736253513
    jac_ini[100,106] = -39.6392229058202
    jac_ini[100,107] = -54.0657727682604
    jac_ini[100,108] = 105.571769313180
    jac_ini[101,25] = 30.9517475172273
    jac_ini[101,26] = 5.65456401516768
    jac_ini[101,27] = -9.21038227100566
    jac_ini[101,28] = 1.84896616921897
    jac_ini[101,29] = -9.00835072044485
    jac_ini[101,30] = 0.793238195499529
    jac_ini[101,31] = -9.21038227100566
    jac_ini[101,32] = 1.84896616921897
    jac_ini[101,93] = 105.571769313180
    jac_ini[101,94] = 54.0657727682604
    jac_ini[101,95] = -39.6392229058202
    jac_ini[101,96] = -10.2713736253513
    jac_ini[101,97] = -24.9575997948692
    jac_ini[101,98] = -23.2849644809540
    jac_ini[101,99] = -39.6392229058202
    jac_ini[101,100] = -10.2713736253513
    jac_ini[101,101] = -242.095286143588
    jac_ini[101,102] = -113.786109551688
    jac_ini[101,103] = 88.4888280826460
    jac_ini[101,104] = 18.6937810814837
    jac_ini[101,105] = 58.9235503101833
    jac_ini[101,106] = 45.7766907664085
    jac_ini[101,107] = 88.4888280826460
    jac_ini[101,108] = 18.6937810814837
    jac_ini[101,109] = 105.571769313180
    jac_ini[101,110] = 54.0657727682604
    jac_ini[101,111] = -39.6392229058202
    jac_ini[101,112] = -10.2713736253513
    jac_ini[101,113] = -24.9575997948692
    jac_ini[101,114] = -23.2849644809540
    jac_ini[101,115] = -39.6392229058202
    jac_ini[101,116] = -10.2713736253513
    jac_ini[102,25] = -5.65456401516768
    jac_ini[102,26] = 30.9517475172273
    jac_ini[102,27] = -1.84896616921897
    jac_ini[102,28] = -9.21038227100566
    jac_ini[102,29] = -0.793238195499529
    jac_ini[102,30] = -9.00835072044485
    jac_ini[102,31] = -1.84896616921897
    jac_ini[102,32] = -9.21038227100566
    jac_ini[102,93] = -54.0657727682604
    jac_ini[102,94] = 105.571769313180
    jac_ini[102,95] = 10.2713736253513
    jac_ini[102,96] = -39.6392229058202
    jac_ini[102,97] = 23.2849644809540
    jac_ini[102,98] = -24.9575997948692
    jac_ini[102,99] = 10.2713736253513
    jac_ini[102,100] = -39.6392229058202
    jac_ini[102,101] = 113.786109551688
    jac_ini[102,102] = -242.095286143588
    jac_ini[102,103] = -18.6937810814837
    jac_ini[102,104] = 88.4888280826460
    jac_ini[102,105] = -45.7766907664085
    jac_ini[102,106] = 58.9235503101833
    jac_ini[102,107] = -18.6937810814837
    jac_ini[102,108] = 88.4888280826460
    jac_ini[102,109] = -54.0657727682604
    jac_ini[102,110] = 105.571769313180
    jac_ini[102,111] = 10.2713736253513
    jac_ini[102,112] = -39.6392229058202
    jac_ini[102,113] = 23.2849644809540
    jac_ini[102,114] = -24.9575997948692
    jac_ini[102,115] = 10.2713736253513
    jac_ini[102,116] = -39.6392229058202
    jac_ini[103,25] = -9.21038227100566
    jac_ini[103,26] = 1.84896616921897
    jac_ini[103,27] = 30.9517475172273
    jac_ini[103,28] = 5.65456401516768
    jac_ini[103,29] = -9.21038227100566
    jac_ini[103,30] = 1.84896616921897
    jac_ini[103,31] = -9.00835072044485
    jac_ini[103,32] = 0.793238195499528
    jac_ini[103,93] = -39.6392229058202
    jac_ini[103,94] = -10.2713736253513
    jac_ini[103,95] = 105.571769313180
    jac_ini[103,96] = 54.0657727682604
    jac_ini[103,97] = -39.6392229058201
    jac_ini[103,98] = -10.2713736253513
    jac_ini[103,99] = -24.9575997948692
    jac_ini[103,100] = -23.2849644809540
    jac_ini[103,101] = 88.4888280826460
    jac_ini[103,102] = 18.6937810814837
    jac_ini[103,103] = -242.095286143588
    jac_ini[103,104] = -113.786109551688
    jac_ini[103,105] = 88.4888280826460
    jac_ini[103,106] = 18.6937810814837
    jac_ini[103,107] = 58.9235503101833
    jac_ini[103,108] = 45.7766907664085
    jac_ini[103,109] = -39.6392229058202
    jac_ini[103,110] = -10.2713736253513
    jac_ini[103,111] = 105.571769313180
    jac_ini[103,112] = 54.0657727682604
    jac_ini[103,113] = -39.6392229058201
    jac_ini[103,114] = -10.2713736253513
    jac_ini[103,115] = -24.9575997948692
    jac_ini[103,116] = -23.2849644809540
    jac_ini[104,25] = -1.84896616921897
    jac_ini[104,26] = -9.21038227100566
    jac_ini[104,27] = -5.65456401516768
    jac_ini[104,28] = 30.9517475172273
    jac_ini[104,29] = -1.84896616921897
    jac_ini[104,30] = -9.21038227100566
    jac_ini[104,31] = -0.793238195499528
    jac_ini[104,32] = -9.00835072044485
    jac_ini[104,93] = 10.2713736253513
    jac_ini[104,94] = -39.6392229058202
    jac_ini[104,95] = -54.0657727682604
    jac_ini[104,96] = 105.571769313180
    jac_ini[104,97] = 10.2713736253513
    jac_ini[104,98] = -39.6392229058201
    jac_ini[104,99] = 23.2849644809540
    jac_ini[104,100] = -24.9575997948692
    jac_ini[104,101] = -18.6937810814837
    jac_ini[104,102] = 88.4888280826460
    jac_ini[104,103] = 113.786109551688
    jac_ini[104,104] = -242.095286143588
    jac_ini[104,105] = -18.6937810814837
    jac_ini[104,106] = 88.4888280826460
    jac_ini[104,107] = -45.7766907664085
    jac_ini[104,108] = 58.9235503101833
    jac_ini[104,109] = 10.2713736253513
    jac_ini[104,110] = -39.6392229058202
    jac_ini[104,111] = -54.0657727682604
    jac_ini[104,112] = 105.571769313180
    jac_ini[104,113] = 10.2713736253513
    jac_ini[104,114] = -39.6392229058201
    jac_ini[104,115] = 23.2849644809540
    jac_ini[104,116] = -24.9575997948692
    jac_ini[105,25] = -9.00835072044484
    jac_ini[105,26] = 0.793238195499527
    jac_ini[105,27] = -9.21038227100566
    jac_ini[105,28] = 1.84896616921897
    jac_ini[105,29] = 30.9517475172273
    jac_ini[105,30] = 5.65456401516768
    jac_ini[105,31] = -9.21038227100566
    jac_ini[105,32] = 1.84896616921897
    jac_ini[105,93] = -24.9575997948692
    jac_ini[105,94] = -23.2849644809540
    jac_ini[105,95] = -39.6392229058202
    jac_ini[105,96] = -10.2713736253513
    jac_ini[105,97] = 105.571769313180
    jac_ini[105,98] = 54.0657727682604
    jac_ini[105,99] = -39.6392229058201
    jac_ini[105,100] = -10.2713736253514
    jac_ini[105,101] = 58.9235503101833
    jac_ini[105,102] = 45.7766907664085
    jac_ini[105,103] = 88.4888280826461
    jac_ini[105,104] = 18.6937810814837
    jac_ini[105,105] = -242.095286143588
    jac_ini[105,106] = -113.786109551688
    jac_ini[105,107] = 88.4888280826459
    jac_ini[105,108] = 18.6937810814837
    jac_ini[105,109] = -24.9575997948692
    jac_ini[105,110] = -23.2849644809540
    jac_ini[105,111] = -39.6392229058202
    jac_ini[105,112] = -10.2713736253513
    jac_ini[105,113] = 105.571769313180
    jac_ini[105,114] = 54.0657727682604
    jac_ini[105,115] = -39.6392229058201
    jac_ini[105,116] = -10.2713736253514
    jac_ini[106,25] = -0.793238195499527
    jac_ini[106,26] = -9.00835072044484
    jac_ini[106,27] = -1.84896616921897
    jac_ini[106,28] = -9.21038227100566
    jac_ini[106,29] = -5.65456401516768
    jac_ini[106,30] = 30.9517475172273
    jac_ini[106,31] = -1.84896616921897
    jac_ini[106,32] = -9.21038227100566
    jac_ini[106,93] = 23.2849644809540
    jac_ini[106,94] = -24.9575997948692
    jac_ini[106,95] = 10.2713736253513
    jac_ini[106,96] = -39.6392229058202
    jac_ini[106,97] = -54.0657727682604
    jac_ini[106,98] = 105.571769313180
    jac_ini[106,99] = 10.2713736253514
    jac_ini[106,100] = -39.6392229058201
    jac_ini[106,101] = -45.7766907664085
    jac_ini[106,102] = 58.9235503101833
    jac_ini[106,103] = -18.6937810814837
    jac_ini[106,104] = 88.4888280826461
    jac_ini[106,105] = 113.786109551688
    jac_ini[106,106] = -242.095286143588
    jac_ini[106,107] = -18.6937810814837
    jac_ini[106,108] = 88.4888280826459
    jac_ini[106,109] = 23.2849644809540
    jac_ini[106,110] = -24.9575997948692
    jac_ini[106,111] = 10.2713736253513
    jac_ini[106,112] = -39.6392229058202
    jac_ini[106,113] = -54.0657727682604
    jac_ini[106,114] = 105.571769313180
    jac_ini[106,115] = 10.2713736253514
    jac_ini[106,116] = -39.6392229058201
    jac_ini[107,25] = -9.21038227100566
    jac_ini[107,26] = 1.84896616921897
    jac_ini[107,27] = -9.00835072044485
    jac_ini[107,28] = 0.793238195499527
    jac_ini[107,29] = -9.21038227100566
    jac_ini[107,30] = 1.84896616921897
    jac_ini[107,31] = 30.9517475172273
    jac_ini[107,32] = 5.65456401516768
    jac_ini[107,93] = -39.6392229058202
    jac_ini[107,94] = -10.2713736253513
    jac_ini[107,95] = -24.9575997948692
    jac_ini[107,96] = -23.2849644809540
    jac_ini[107,97] = -39.6392229058202
    jac_ini[107,98] = -10.2713736253513
    jac_ini[107,99] = 105.571769313180
    jac_ini[107,100] = 54.0657727682604
    jac_ini[107,101] = 88.4888280826460
    jac_ini[107,102] = 18.6937810814837
    jac_ini[107,103] = 58.9235503101832
    jac_ini[107,104] = 45.7766907664085
    jac_ini[107,105] = 88.4888280826460
    jac_ini[107,106] = 18.6937810814837
    jac_ini[107,107] = -242.120286143588
    jac_ini[107,108] = -113.786109551688
    jac_ini[107,109] = -39.6392229058202
    jac_ini[107,110] = -10.2713736253513
    jac_ini[107,111] = -24.9575997948692
    jac_ini[107,112] = -23.2849644809540
    jac_ini[107,113] = -39.6392229058202
    jac_ini[107,114] = -10.2713736253513
    jac_ini[107,115] = 105.571769313180
    jac_ini[107,116] = 54.0657727682604
    jac_ini[108,25] = -1.84896616921897
    jac_ini[108,26] = -9.21038227100566
    jac_ini[108,27] = -0.793238195499527
    jac_ini[108,28] = -9.00835072044485
    jac_ini[108,29] = -1.84896616921897
    jac_ini[108,30] = -9.21038227100566
    jac_ini[108,31] = -5.65456401516768
    jac_ini[108,32] = 30.9517475172273
    jac_ini[108,93] = 10.2713736253513
    jac_ini[108,94] = -39.6392229058202
    jac_ini[108,95] = 23.2849644809540
    jac_ini[108,96] = -24.9575997948692
    jac_ini[108,97] = 10.2713736253513
    jac_ini[108,98] = -39.6392229058202
    jac_ini[108,99] = -54.0657727682604
    jac_ini[108,100] = 105.571769313180
    jac_ini[108,101] = -18.6937810814837
    jac_ini[108,102] = 88.4888280826460
    jac_ini[108,103] = -45.7766907664085
    jac_ini[108,104] = 58.9235503101832
    jac_ini[108,105] = -18.6937810814837
    jac_ini[108,106] = 88.4888280826460
    jac_ini[108,107] = 113.786109551688
    jac_ini[108,108] = -242.120286143588
    jac_ini[108,109] = 10.2713736253513
    jac_ini[108,110] = -39.6392229058202
    jac_ini[108,111] = 23.2849644809540
    jac_ini[108,112] = -24.9575997948692
    jac_ini[108,113] = 10.2713736253513
    jac_ini[108,114] = -39.6392229058202
    jac_ini[108,115] = -54.0657727682604
    jac_ini[108,116] = 105.571769313180
    jac_ini[109,101] = 105.571769313180
    jac_ini[109,102] = 54.0657727682604
    jac_ini[109,103] = -39.6392229058202
    jac_ini[109,104] = -10.2713736253513
    jac_ini[109,105] = -24.9575997948692
    jac_ini[109,106] = -23.2849644809540
    jac_ini[109,107] = -39.6392229058202
    jac_ini[109,108] = -10.2713736253513
    jac_ini[109,109] = -211.143538626360
    jac_ini[109,110] = -108.131545536521
    jac_ini[109,111] = 79.2784458116403
    jac_ini[109,112] = 20.5427472507027
    jac_ini[109,113] = 49.9151995897384
    jac_ini[109,114] = 46.5699289619080
    jac_ini[109,115] = 79.2784458116403
    jac_ini[109,116] = 20.5427472507027
    jac_ini[109,117] = 105.571769313180
    jac_ini[109,118] = 54.0657727682604
    jac_ini[109,119] = -39.6392229058202
    jac_ini[109,120] = -10.2713736253513
    jac_ini[109,121] = -24.9575997948692
    jac_ini[109,122] = -23.2849644809540
    jac_ini[109,123] = -39.6392229058202
    jac_ini[109,124] = -10.2713736253513
    jac_ini[110,101] = -54.0657727682604
    jac_ini[110,102] = 105.571769313180
    jac_ini[110,103] = 10.2713736253513
    jac_ini[110,104] = -39.6392229058202
    jac_ini[110,105] = 23.2849644809540
    jac_ini[110,106] = -24.9575997948692
    jac_ini[110,107] = 10.2713736253513
    jac_ini[110,108] = -39.6392229058202
    jac_ini[110,109] = 108.131545536521
    jac_ini[110,110] = -211.143538626360
    jac_ini[110,111] = -20.5427472507027
    jac_ini[110,112] = 79.2784458116403
    jac_ini[110,113] = -46.5699289619080
    jac_ini[110,114] = 49.9151995897384
    jac_ini[110,115] = -20.5427472507027
    jac_ini[110,116] = 79.2784458116403
    jac_ini[110,117] = -54.0657727682604
    jac_ini[110,118] = 105.571769313180
    jac_ini[110,119] = 10.2713736253513
    jac_ini[110,120] = -39.6392229058202
    jac_ini[110,121] = 23.2849644809540
    jac_ini[110,122] = -24.9575997948692
    jac_ini[110,123] = 10.2713736253513
    jac_ini[110,124] = -39.6392229058202
    jac_ini[111,101] = -39.6392229058202
    jac_ini[111,102] = -10.2713736253513
    jac_ini[111,103] = 105.571769313180
    jac_ini[111,104] = 54.0657727682604
    jac_ini[111,105] = -39.6392229058201
    jac_ini[111,106] = -10.2713736253513
    jac_ini[111,107] = -24.9575997948692
    jac_ini[111,108] = -23.2849644809540
    jac_ini[111,109] = 79.2784458116403
    jac_ini[111,110] = 20.5427472507027
    jac_ini[111,111] = -211.143538626360
    jac_ini[111,112] = -108.131545536521
    jac_ini[111,113] = 79.2784458116403
    jac_ini[111,114] = 20.5427472507027
    jac_ini[111,115] = 49.9151995897384
    jac_ini[111,116] = 46.5699289619080
    jac_ini[111,117] = -39.6392229058202
    jac_ini[111,118] = -10.2713736253513
    jac_ini[111,119] = 105.571769313180
    jac_ini[111,120] = 54.0657727682604
    jac_ini[111,121] = -39.6392229058201
    jac_ini[111,122] = -10.2713736253513
    jac_ini[111,123] = -24.9575997948692
    jac_ini[111,124] = -23.2849644809540
    jac_ini[112,101] = 10.2713736253513
    jac_ini[112,102] = -39.6392229058202
    jac_ini[112,103] = -54.0657727682604
    jac_ini[112,104] = 105.571769313180
    jac_ini[112,105] = 10.2713736253513
    jac_ini[112,106] = -39.6392229058201
    jac_ini[112,107] = 23.2849644809540
    jac_ini[112,108] = -24.9575997948692
    jac_ini[112,109] = -20.5427472507027
    jac_ini[112,110] = 79.2784458116403
    jac_ini[112,111] = 108.131545536521
    jac_ini[112,112] = -211.143538626360
    jac_ini[112,113] = -20.5427472507027
    jac_ini[112,114] = 79.2784458116403
    jac_ini[112,115] = -46.5699289619080
    jac_ini[112,116] = 49.9151995897384
    jac_ini[112,117] = 10.2713736253513
    jac_ini[112,118] = -39.6392229058202
    jac_ini[112,119] = -54.0657727682604
    jac_ini[112,120] = 105.571769313180
    jac_ini[112,121] = 10.2713736253513
    jac_ini[112,122] = -39.6392229058201
    jac_ini[112,123] = 23.2849644809540
    jac_ini[112,124] = -24.9575997948692
    jac_ini[113,101] = -24.9575997948692
    jac_ini[113,102] = -23.2849644809540
    jac_ini[113,103] = -39.6392229058202
    jac_ini[113,104] = -10.2713736253513
    jac_ini[113,105] = 105.571769313180
    jac_ini[113,106] = 54.0657727682604
    jac_ini[113,107] = -39.6392229058201
    jac_ini[113,108] = -10.2713736253514
    jac_ini[113,109] = 49.9151995897384
    jac_ini[113,110] = 46.5699289619080
    jac_ini[113,111] = 79.2784458116404
    jac_ini[113,112] = 20.5427472507027
    jac_ini[113,113] = -211.143538626360
    jac_ini[113,114] = -108.131545536521
    jac_ini[113,115] = 79.2784458116403
    jac_ini[113,116] = 20.5427472507027
    jac_ini[113,117] = -24.9575997948692
    jac_ini[113,118] = -23.2849644809540
    jac_ini[113,119] = -39.6392229058202
    jac_ini[113,120] = -10.2713736253513
    jac_ini[113,121] = 105.571769313180
    jac_ini[113,122] = 54.0657727682604
    jac_ini[113,123] = -39.6392229058201
    jac_ini[113,124] = -10.2713736253514
    jac_ini[114,101] = 23.2849644809540
    jac_ini[114,102] = -24.9575997948692
    jac_ini[114,103] = 10.2713736253513
    jac_ini[114,104] = -39.6392229058202
    jac_ini[114,105] = -54.0657727682604
    jac_ini[114,106] = 105.571769313180
    jac_ini[114,107] = 10.2713736253514
    jac_ini[114,108] = -39.6392229058201
    jac_ini[114,109] = -46.5699289619080
    jac_ini[114,110] = 49.9151995897384
    jac_ini[114,111] = -20.5427472507027
    jac_ini[114,112] = 79.2784458116404
    jac_ini[114,113] = 108.131545536521
    jac_ini[114,114] = -211.143538626360
    jac_ini[114,115] = -20.5427472507027
    jac_ini[114,116] = 79.2784458116403
    jac_ini[114,117] = 23.2849644809540
    jac_ini[114,118] = -24.9575997948692
    jac_ini[114,119] = 10.2713736253513
    jac_ini[114,120] = -39.6392229058202
    jac_ini[114,121] = -54.0657727682604
    jac_ini[114,122] = 105.571769313180
    jac_ini[114,123] = 10.2713736253514
    jac_ini[114,124] = -39.6392229058201
    jac_ini[115,101] = -39.6392229058202
    jac_ini[115,102] = -10.2713736253513
    jac_ini[115,103] = -24.9575997948692
    jac_ini[115,104] = -23.2849644809540
    jac_ini[115,105] = -39.6392229058202
    jac_ini[115,106] = -10.2713736253513
    jac_ini[115,107] = 105.571769313180
    jac_ini[115,108] = 54.0657727682604
    jac_ini[115,109] = 79.2784458116403
    jac_ini[115,110] = 20.5427472507027
    jac_ini[115,111] = 49.9151995897384
    jac_ini[115,112] = 46.5699289619080
    jac_ini[115,113] = 79.2784458116403
    jac_ini[115,114] = 20.5427472507027
    jac_ini[115,115] = -211.143538626360
    jac_ini[115,116] = -108.131545536521
    jac_ini[115,117] = -39.6392229058202
    jac_ini[115,118] = -10.2713736253513
    jac_ini[115,119] = -24.9575997948692
    jac_ini[115,120] = -23.2849644809540
    jac_ini[115,121] = -39.6392229058202
    jac_ini[115,122] = -10.2713736253513
    jac_ini[115,123] = 105.571769313180
    jac_ini[115,124] = 54.0657727682604
    jac_ini[116,101] = 10.2713736253513
    jac_ini[116,102] = -39.6392229058202
    jac_ini[116,103] = 23.2849644809540
    jac_ini[116,104] = -24.9575997948692
    jac_ini[116,105] = 10.2713736253513
    jac_ini[116,106] = -39.6392229058202
    jac_ini[116,107] = -54.0657727682604
    jac_ini[116,108] = 105.571769313180
    jac_ini[116,109] = -20.5427472507027
    jac_ini[116,110] = 79.2784458116403
    jac_ini[116,111] = -46.5699289619080
    jac_ini[116,112] = 49.9151995897384
    jac_ini[116,113] = -20.5427472507027
    jac_ini[116,114] = 79.2784458116403
    jac_ini[116,115] = 108.131545536521
    jac_ini[116,116] = -211.143538626360
    jac_ini[116,117] = 10.2713736253513
    jac_ini[116,118] = -39.6392229058202
    jac_ini[116,119] = 23.2849644809540
    jac_ini[116,120] = -24.9575997948692
    jac_ini[116,121] = 10.2713736253513
    jac_ini[116,122] = -39.6392229058202
    jac_ini[116,123] = -54.0657727682604
    jac_ini[116,124] = 105.571769313180
    jac_ini[117,109] = 105.571769313180
    jac_ini[117,110] = 54.0657727682604
    jac_ini[117,111] = -39.6392229058202
    jac_ini[117,112] = -10.2713736253513
    jac_ini[117,113] = -24.9575997948692
    jac_ini[117,114] = -23.2849644809540
    jac_ini[117,115] = -39.6392229058202
    jac_ini[117,116] = -10.2713736253513
    jac_ini[117,117] = -211.143538626360
    jac_ini[117,118] = -108.131545536521
    jac_ini[117,119] = 79.2784458116403
    jac_ini[117,120] = 20.5427472507027
    jac_ini[117,121] = 49.9151995897384
    jac_ini[117,122] = 46.5699289619080
    jac_ini[117,123] = 79.2784458116403
    jac_ini[117,124] = 20.5427472507027
    jac_ini[117,125] = 105.571769313180
    jac_ini[117,126] = 54.0657727682604
    jac_ini[117,127] = -39.6392229058202
    jac_ini[117,128] = -10.2713736253513
    jac_ini[117,129] = -24.9575997948692
    jac_ini[117,130] = -23.2849644809540
    jac_ini[117,131] = -39.6392229058202
    jac_ini[117,132] = -10.2713736253513
    jac_ini[118,109] = -54.0657727682604
    jac_ini[118,110] = 105.571769313180
    jac_ini[118,111] = 10.2713736253513
    jac_ini[118,112] = -39.6392229058202
    jac_ini[118,113] = 23.2849644809540
    jac_ini[118,114] = -24.9575997948692
    jac_ini[118,115] = 10.2713736253513
    jac_ini[118,116] = -39.6392229058202
    jac_ini[118,117] = 108.131545536521
    jac_ini[118,118] = -211.143538626360
    jac_ini[118,119] = -20.5427472507027
    jac_ini[118,120] = 79.2784458116403
    jac_ini[118,121] = -46.5699289619080
    jac_ini[118,122] = 49.9151995897384
    jac_ini[118,123] = -20.5427472507027
    jac_ini[118,124] = 79.2784458116403
    jac_ini[118,125] = -54.0657727682604
    jac_ini[118,126] = 105.571769313180
    jac_ini[118,127] = 10.2713736253513
    jac_ini[118,128] = -39.6392229058202
    jac_ini[118,129] = 23.2849644809540
    jac_ini[118,130] = -24.9575997948692
    jac_ini[118,131] = 10.2713736253513
    jac_ini[118,132] = -39.6392229058202
    jac_ini[119,109] = -39.6392229058202
    jac_ini[119,110] = -10.2713736253513
    jac_ini[119,111] = 105.571769313180
    jac_ini[119,112] = 54.0657727682604
    jac_ini[119,113] = -39.6392229058201
    jac_ini[119,114] = -10.2713736253513
    jac_ini[119,115] = -24.9575997948692
    jac_ini[119,116] = -23.2849644809540
    jac_ini[119,117] = 79.2784458116403
    jac_ini[119,118] = 20.5427472507027
    jac_ini[119,119] = -211.143538626360
    jac_ini[119,120] = -108.131545536521
    jac_ini[119,121] = 79.2784458116403
    jac_ini[119,122] = 20.5427472507027
    jac_ini[119,123] = 49.9151995897384
    jac_ini[119,124] = 46.5699289619080
    jac_ini[119,125] = -39.6392229058202
    jac_ini[119,126] = -10.2713736253513
    jac_ini[119,127] = 105.571769313180
    jac_ini[119,128] = 54.0657727682604
    jac_ini[119,129] = -39.6392229058201
    jac_ini[119,130] = -10.2713736253513
    jac_ini[119,131] = -24.9575997948692
    jac_ini[119,132] = -23.2849644809540
    jac_ini[120,109] = 10.2713736253513
    jac_ini[120,110] = -39.6392229058202
    jac_ini[120,111] = -54.0657727682604
    jac_ini[120,112] = 105.571769313180
    jac_ini[120,113] = 10.2713736253513
    jac_ini[120,114] = -39.6392229058201
    jac_ini[120,115] = 23.2849644809540
    jac_ini[120,116] = -24.9575997948692
    jac_ini[120,117] = -20.5427472507027
    jac_ini[120,118] = 79.2784458116403
    jac_ini[120,119] = 108.131545536521
    jac_ini[120,120] = -211.143538626360
    jac_ini[120,121] = -20.5427472507027
    jac_ini[120,122] = 79.2784458116403
    jac_ini[120,123] = -46.5699289619080
    jac_ini[120,124] = 49.9151995897384
    jac_ini[120,125] = 10.2713736253513
    jac_ini[120,126] = -39.6392229058202
    jac_ini[120,127] = -54.0657727682604
    jac_ini[120,128] = 105.571769313180
    jac_ini[120,129] = 10.2713736253513
    jac_ini[120,130] = -39.6392229058201
    jac_ini[120,131] = 23.2849644809540
    jac_ini[120,132] = -24.9575997948692
    jac_ini[121,109] = -24.9575997948692
    jac_ini[121,110] = -23.2849644809540
    jac_ini[121,111] = -39.6392229058202
    jac_ini[121,112] = -10.2713736253513
    jac_ini[121,113] = 105.571769313180
    jac_ini[121,114] = 54.0657727682604
    jac_ini[121,115] = -39.6392229058201
    jac_ini[121,116] = -10.2713736253514
    jac_ini[121,117] = 49.9151995897384
    jac_ini[121,118] = 46.5699289619080
    jac_ini[121,119] = 79.2784458116404
    jac_ini[121,120] = 20.5427472507027
    jac_ini[121,121] = -211.143538626360
    jac_ini[121,122] = -108.131545536521
    jac_ini[121,123] = 79.2784458116403
    jac_ini[121,124] = 20.5427472507027
    jac_ini[121,125] = -24.9575997948692
    jac_ini[121,126] = -23.2849644809540
    jac_ini[121,127] = -39.6392229058202
    jac_ini[121,128] = -10.2713736253513
    jac_ini[121,129] = 105.571769313180
    jac_ini[121,130] = 54.0657727682604
    jac_ini[121,131] = -39.6392229058201
    jac_ini[121,132] = -10.2713736253514
    jac_ini[122,109] = 23.2849644809540
    jac_ini[122,110] = -24.9575997948692
    jac_ini[122,111] = 10.2713736253513
    jac_ini[122,112] = -39.6392229058202
    jac_ini[122,113] = -54.0657727682604
    jac_ini[122,114] = 105.571769313180
    jac_ini[122,115] = 10.2713736253514
    jac_ini[122,116] = -39.6392229058201
    jac_ini[122,117] = -46.5699289619080
    jac_ini[122,118] = 49.9151995897384
    jac_ini[122,119] = -20.5427472507027
    jac_ini[122,120] = 79.2784458116404
    jac_ini[122,121] = 108.131545536521
    jac_ini[122,122] = -211.143538626360
    jac_ini[122,123] = -20.5427472507027
    jac_ini[122,124] = 79.2784458116403
    jac_ini[122,125] = 23.2849644809540
    jac_ini[122,126] = -24.9575997948692
    jac_ini[122,127] = 10.2713736253513
    jac_ini[122,128] = -39.6392229058202
    jac_ini[122,129] = -54.0657727682604
    jac_ini[122,130] = 105.571769313180
    jac_ini[122,131] = 10.2713736253514
    jac_ini[122,132] = -39.6392229058201
    jac_ini[123,109] = -39.6392229058202
    jac_ini[123,110] = -10.2713736253513
    jac_ini[123,111] = -24.9575997948692
    jac_ini[123,112] = -23.2849644809540
    jac_ini[123,113] = -39.6392229058202
    jac_ini[123,114] = -10.2713736253513
    jac_ini[123,115] = 105.571769313180
    jac_ini[123,116] = 54.0657727682604
    jac_ini[123,117] = 79.2784458116403
    jac_ini[123,118] = 20.5427472507027
    jac_ini[123,119] = 49.9151995897384
    jac_ini[123,120] = 46.5699289619080
    jac_ini[123,121] = 79.2784458116403
    jac_ini[123,122] = 20.5427472507027
    jac_ini[123,123] = -211.168538626360
    jac_ini[123,124] = -108.131545536521
    jac_ini[123,125] = -39.6392229058202
    jac_ini[123,126] = -10.2713736253513
    jac_ini[123,127] = -24.9575997948692
    jac_ini[123,128] = -23.2849644809540
    jac_ini[123,129] = -39.6392229058202
    jac_ini[123,130] = -10.2713736253513
    jac_ini[123,131] = 105.571769313180
    jac_ini[123,132] = 54.0657727682604
    jac_ini[124,109] = 10.2713736253513
    jac_ini[124,110] = -39.6392229058202
    jac_ini[124,111] = 23.2849644809540
    jac_ini[124,112] = -24.9575997948692
    jac_ini[124,113] = 10.2713736253513
    jac_ini[124,114] = -39.6392229058202
    jac_ini[124,115] = -54.0657727682604
    jac_ini[124,116] = 105.571769313180
    jac_ini[124,117] = -20.5427472507027
    jac_ini[124,118] = 79.2784458116403
    jac_ini[124,119] = -46.5699289619080
    jac_ini[124,120] = 49.9151995897384
    jac_ini[124,121] = -20.5427472507027
    jac_ini[124,122] = 79.2784458116403
    jac_ini[124,123] = 108.131545536521
    jac_ini[124,124] = -211.168538626360
    jac_ini[124,125] = 10.2713736253513
    jac_ini[124,126] = -39.6392229058202
    jac_ini[124,127] = 23.2849644809540
    jac_ini[124,128] = -24.9575997948692
    jac_ini[124,129] = 10.2713736253513
    jac_ini[124,130] = -39.6392229058202
    jac_ini[124,131] = -54.0657727682604
    jac_ini[124,132] = 105.571769313180
    jac_ini[125,33] = 30.9517475172273
    jac_ini[125,34] = 5.65456401516768
    jac_ini[125,35] = -9.21038227100566
    jac_ini[125,36] = 1.84896616921897
    jac_ini[125,37] = -9.00835072044485
    jac_ini[125,38] = 0.793238195499529
    jac_ini[125,39] = -9.21038227100566
    jac_ini[125,40] = 1.84896616921897
    jac_ini[125,117] = 105.571769313180
    jac_ini[125,118] = 54.0657727682604
    jac_ini[125,119] = -39.6392229058202
    jac_ini[125,120] = -10.2713736253513
    jac_ini[125,121] = -24.9575997948692
    jac_ini[125,122] = -23.2849644809540
    jac_ini[125,123] = -39.6392229058202
    jac_ini[125,124] = -10.2713736253513
    jac_ini[125,125] = -242.095286143588
    jac_ini[125,126] = -113.786109551688
    jac_ini[125,127] = 88.4888280826460
    jac_ini[125,128] = 18.6937810814837
    jac_ini[125,129] = 58.9235503101833
    jac_ini[125,130] = 45.7766907664085
    jac_ini[125,131] = 88.4888280826460
    jac_ini[125,132] = 18.6937810814837
    jac_ini[125,133] = 105.571769313180
    jac_ini[125,134] = 54.0657727682604
    jac_ini[125,135] = -39.6392229058202
    jac_ini[125,136] = -10.2713736253513
    jac_ini[125,137] = -24.9575997948692
    jac_ini[125,138] = -23.2849644809540
    jac_ini[125,139] = -39.6392229058202
    jac_ini[125,140] = -10.2713736253513
    jac_ini[126,33] = -5.65456401516768
    jac_ini[126,34] = 30.9517475172273
    jac_ini[126,35] = -1.84896616921897
    jac_ini[126,36] = -9.21038227100566
    jac_ini[126,37] = -0.793238195499529
    jac_ini[126,38] = -9.00835072044485
    jac_ini[126,39] = -1.84896616921897
    jac_ini[126,40] = -9.21038227100566
    jac_ini[126,117] = -54.0657727682604
    jac_ini[126,118] = 105.571769313180
    jac_ini[126,119] = 10.2713736253513
    jac_ini[126,120] = -39.6392229058202
    jac_ini[126,121] = 23.2849644809540
    jac_ini[126,122] = -24.9575997948692
    jac_ini[126,123] = 10.2713736253513
    jac_ini[126,124] = -39.6392229058202
    jac_ini[126,125] = 113.786109551688
    jac_ini[126,126] = -242.095286143588
    jac_ini[126,127] = -18.6937810814837
    jac_ini[126,128] = 88.4888280826460
    jac_ini[126,129] = -45.7766907664085
    jac_ini[126,130] = 58.9235503101833
    jac_ini[126,131] = -18.6937810814837
    jac_ini[126,132] = 88.4888280826460
    jac_ini[126,133] = -54.0657727682604
    jac_ini[126,134] = 105.571769313180
    jac_ini[126,135] = 10.2713736253513
    jac_ini[126,136] = -39.6392229058202
    jac_ini[126,137] = 23.2849644809540
    jac_ini[126,138] = -24.9575997948692
    jac_ini[126,139] = 10.2713736253513
    jac_ini[126,140] = -39.6392229058202
    jac_ini[127,33] = -9.21038227100566
    jac_ini[127,34] = 1.84896616921897
    jac_ini[127,35] = 30.9517475172273
    jac_ini[127,36] = 5.65456401516768
    jac_ini[127,37] = -9.21038227100566
    jac_ini[127,38] = 1.84896616921897
    jac_ini[127,39] = -9.00835072044485
    jac_ini[127,40] = 0.793238195499528
    jac_ini[127,117] = -39.6392229058202
    jac_ini[127,118] = -10.2713736253513
    jac_ini[127,119] = 105.571769313180
    jac_ini[127,120] = 54.0657727682604
    jac_ini[127,121] = -39.6392229058201
    jac_ini[127,122] = -10.2713736253513
    jac_ini[127,123] = -24.9575997948692
    jac_ini[127,124] = -23.2849644809540
    jac_ini[127,125] = 88.4888280826460
    jac_ini[127,126] = 18.6937810814837
    jac_ini[127,127] = -242.095286143588
    jac_ini[127,128] = -113.786109551688
    jac_ini[127,129] = 88.4888280826460
    jac_ini[127,130] = 18.6937810814837
    jac_ini[127,131] = 58.9235503101833
    jac_ini[127,132] = 45.7766907664085
    jac_ini[127,133] = -39.6392229058202
    jac_ini[127,134] = -10.2713736253513
    jac_ini[127,135] = 105.571769313180
    jac_ini[127,136] = 54.0657727682604
    jac_ini[127,137] = -39.6392229058201
    jac_ini[127,138] = -10.2713736253513
    jac_ini[127,139] = -24.9575997948692
    jac_ini[127,140] = -23.2849644809540
    jac_ini[128,33] = -1.84896616921897
    jac_ini[128,34] = -9.21038227100566
    jac_ini[128,35] = -5.65456401516768
    jac_ini[128,36] = 30.9517475172273
    jac_ini[128,37] = -1.84896616921897
    jac_ini[128,38] = -9.21038227100566
    jac_ini[128,39] = -0.793238195499528
    jac_ini[128,40] = -9.00835072044485
    jac_ini[128,117] = 10.2713736253513
    jac_ini[128,118] = -39.6392229058202
    jac_ini[128,119] = -54.0657727682604
    jac_ini[128,120] = 105.571769313180
    jac_ini[128,121] = 10.2713736253513
    jac_ini[128,122] = -39.6392229058201
    jac_ini[128,123] = 23.2849644809540
    jac_ini[128,124] = -24.9575997948692
    jac_ini[128,125] = -18.6937810814837
    jac_ini[128,126] = 88.4888280826460
    jac_ini[128,127] = 113.786109551688
    jac_ini[128,128] = -242.095286143588
    jac_ini[128,129] = -18.6937810814837
    jac_ini[128,130] = 88.4888280826460
    jac_ini[128,131] = -45.7766907664085
    jac_ini[128,132] = 58.9235503101833
    jac_ini[128,133] = 10.2713736253513
    jac_ini[128,134] = -39.6392229058202
    jac_ini[128,135] = -54.0657727682604
    jac_ini[128,136] = 105.571769313180
    jac_ini[128,137] = 10.2713736253513
    jac_ini[128,138] = -39.6392229058201
    jac_ini[128,139] = 23.2849644809540
    jac_ini[128,140] = -24.9575997948692
    jac_ini[129,33] = -9.00835072044484
    jac_ini[129,34] = 0.793238195499527
    jac_ini[129,35] = -9.21038227100566
    jac_ini[129,36] = 1.84896616921897
    jac_ini[129,37] = 30.9517475172273
    jac_ini[129,38] = 5.65456401516768
    jac_ini[129,39] = -9.21038227100566
    jac_ini[129,40] = 1.84896616921897
    jac_ini[129,117] = -24.9575997948692
    jac_ini[129,118] = -23.2849644809540
    jac_ini[129,119] = -39.6392229058202
    jac_ini[129,120] = -10.2713736253513
    jac_ini[129,121] = 105.571769313180
    jac_ini[129,122] = 54.0657727682604
    jac_ini[129,123] = -39.6392229058201
    jac_ini[129,124] = -10.2713736253514
    jac_ini[129,125] = 58.9235503101833
    jac_ini[129,126] = 45.7766907664085
    jac_ini[129,127] = 88.4888280826461
    jac_ini[129,128] = 18.6937810814837
    jac_ini[129,129] = -242.095286143588
    jac_ini[129,130] = -113.786109551688
    jac_ini[129,131] = 88.4888280826459
    jac_ini[129,132] = 18.6937810814837
    jac_ini[129,133] = -24.9575997948692
    jac_ini[129,134] = -23.2849644809540
    jac_ini[129,135] = -39.6392229058202
    jac_ini[129,136] = -10.2713736253513
    jac_ini[129,137] = 105.571769313180
    jac_ini[129,138] = 54.0657727682604
    jac_ini[129,139] = -39.6392229058201
    jac_ini[129,140] = -10.2713736253514
    jac_ini[130,33] = -0.793238195499527
    jac_ini[130,34] = -9.00835072044484
    jac_ini[130,35] = -1.84896616921897
    jac_ini[130,36] = -9.21038227100566
    jac_ini[130,37] = -5.65456401516768
    jac_ini[130,38] = 30.9517475172273
    jac_ini[130,39] = -1.84896616921897
    jac_ini[130,40] = -9.21038227100566
    jac_ini[130,117] = 23.2849644809540
    jac_ini[130,118] = -24.9575997948692
    jac_ini[130,119] = 10.2713736253513
    jac_ini[130,120] = -39.6392229058202
    jac_ini[130,121] = -54.0657727682604
    jac_ini[130,122] = 105.571769313180
    jac_ini[130,123] = 10.2713736253514
    jac_ini[130,124] = -39.6392229058201
    jac_ini[130,125] = -45.7766907664085
    jac_ini[130,126] = 58.9235503101833
    jac_ini[130,127] = -18.6937810814837
    jac_ini[130,128] = 88.4888280826461
    jac_ini[130,129] = 113.786109551688
    jac_ini[130,130] = -242.095286143588
    jac_ini[130,131] = -18.6937810814837
    jac_ini[130,132] = 88.4888280826459
    jac_ini[130,133] = 23.2849644809540
    jac_ini[130,134] = -24.9575997948692
    jac_ini[130,135] = 10.2713736253513
    jac_ini[130,136] = -39.6392229058202
    jac_ini[130,137] = -54.0657727682604
    jac_ini[130,138] = 105.571769313180
    jac_ini[130,139] = 10.2713736253514
    jac_ini[130,140] = -39.6392229058201
    jac_ini[131,33] = -9.21038227100566
    jac_ini[131,34] = 1.84896616921897
    jac_ini[131,35] = -9.00835072044485
    jac_ini[131,36] = 0.793238195499527
    jac_ini[131,37] = -9.21038227100566
    jac_ini[131,38] = 1.84896616921897
    jac_ini[131,39] = 30.9517475172273
    jac_ini[131,40] = 5.65456401516768
    jac_ini[131,117] = -39.6392229058202
    jac_ini[131,118] = -10.2713736253513
    jac_ini[131,119] = -24.9575997948692
    jac_ini[131,120] = -23.2849644809540
    jac_ini[131,121] = -39.6392229058202
    jac_ini[131,122] = -10.2713736253513
    jac_ini[131,123] = 105.571769313180
    jac_ini[131,124] = 54.0657727682604
    jac_ini[131,125] = 88.4888280826460
    jac_ini[131,126] = 18.6937810814837
    jac_ini[131,127] = 58.9235503101832
    jac_ini[131,128] = 45.7766907664085
    jac_ini[131,129] = 88.4888280826460
    jac_ini[131,130] = 18.6937810814837
    jac_ini[131,131] = -242.095286143588
    jac_ini[131,132] = -113.786109551688
    jac_ini[131,133] = -39.6392229058202
    jac_ini[131,134] = -10.2713736253513
    jac_ini[131,135] = -24.9575997948692
    jac_ini[131,136] = -23.2849644809540
    jac_ini[131,137] = -39.6392229058202
    jac_ini[131,138] = -10.2713736253513
    jac_ini[131,139] = 105.571769313180
    jac_ini[131,140] = 54.0657727682604
    jac_ini[132,33] = -1.84896616921897
    jac_ini[132,34] = -9.21038227100566
    jac_ini[132,35] = -0.793238195499527
    jac_ini[132,36] = -9.00835072044485
    jac_ini[132,37] = -1.84896616921897
    jac_ini[132,38] = -9.21038227100566
    jac_ini[132,39] = -5.65456401516768
    jac_ini[132,40] = 30.9517475172273
    jac_ini[132,117] = 10.2713736253513
    jac_ini[132,118] = -39.6392229058202
    jac_ini[132,119] = 23.2849644809540
    jac_ini[132,120] = -24.9575997948692
    jac_ini[132,121] = 10.2713736253513
    jac_ini[132,122] = -39.6392229058202
    jac_ini[132,123] = -54.0657727682604
    jac_ini[132,124] = 105.571769313180
    jac_ini[132,125] = -18.6937810814837
    jac_ini[132,126] = 88.4888280826460
    jac_ini[132,127] = -45.7766907664085
    jac_ini[132,128] = 58.9235503101832
    jac_ini[132,129] = -18.6937810814837
    jac_ini[132,130] = 88.4888280826460
    jac_ini[132,131] = 113.786109551688
    jac_ini[132,132] = -242.095286143588
    jac_ini[132,133] = 10.2713736253513
    jac_ini[132,134] = -39.6392229058202
    jac_ini[132,135] = 23.2849644809540
    jac_ini[132,136] = -24.9575997948692
    jac_ini[132,137] = 10.2713736253513
    jac_ini[132,138] = -39.6392229058202
    jac_ini[132,139] = -54.0657727682604
    jac_ini[132,140] = 105.571769313180
    jac_ini[133,41] = 30.9517475172273
    jac_ini[133,42] = 5.65456401516768
    jac_ini[133,43] = -9.21038227100566
    jac_ini[133,44] = 1.84896616921897
    jac_ini[133,45] = -9.00835072044485
    jac_ini[133,46] = 0.793238195499529
    jac_ini[133,47] = -9.21038227100566
    jac_ini[133,48] = 1.84896616921897
    jac_ini[133,125] = 105.571769313180
    jac_ini[133,126] = 54.0657727682604
    jac_ini[133,127] = -39.6392229058202
    jac_ini[133,128] = -10.2713736253513
    jac_ini[133,129] = -24.9575997948692
    jac_ini[133,130] = -23.2849644809540
    jac_ini[133,131] = -39.6392229058202
    jac_ini[133,132] = -10.2713736253513
    jac_ini[133,133] = -136.523516830407
    jac_ini[133,134] = -59.7203367834281
    jac_ini[133,135] = 48.8496051768258
    jac_ini[133,136] = 8.42240745613237
    jac_ini[133,137] = 33.9659505153141
    jac_ini[133,138] = 22.4917262854545
    jac_ini[133,139] = 48.8496051768258
    jac_ini[133,140] = 8.42240745613237
    jac_ini[133,414] = 1
    jac_ini[134,41] = -5.65456401516768
    jac_ini[134,42] = 30.9517475172273
    jac_ini[134,43] = -1.84896616921897
    jac_ini[134,44] = -9.21038227100566
    jac_ini[134,45] = -0.793238195499529
    jac_ini[134,46] = -9.00835072044485
    jac_ini[134,47] = -1.84896616921897
    jac_ini[134,48] = -9.21038227100566
    jac_ini[134,125] = -54.0657727682604
    jac_ini[134,126] = 105.571769313180
    jac_ini[134,127] = 10.2713736253513
    jac_ini[134,128] = -39.6392229058202
    jac_ini[134,129] = 23.2849644809540
    jac_ini[134,130] = -24.9575997948692
    jac_ini[134,131] = 10.2713736253513
    jac_ini[134,132] = -39.6392229058202
    jac_ini[134,133] = 59.7203367834281
    jac_ini[134,134] = -136.523516830407
    jac_ini[134,135] = -8.42240745613237
    jac_ini[134,136] = 48.8496051768258
    jac_ini[134,137] = -22.4917262854545
    jac_ini[134,138] = 33.9659505153141
    jac_ini[134,139] = -8.42240745613237
    jac_ini[134,140] = 48.8496051768258
    jac_ini[134,415] = 1
    jac_ini[135,41] = -9.21038227100566
    jac_ini[135,42] = 1.84896616921897
    jac_ini[135,43] = 30.9517475172273
    jac_ini[135,44] = 5.65456401516768
    jac_ini[135,45] = -9.21038227100566
    jac_ini[135,46] = 1.84896616921897
    jac_ini[135,47] = -9.00835072044485
    jac_ini[135,48] = 0.793238195499528
    jac_ini[135,125] = -39.6392229058202
    jac_ini[135,126] = -10.2713736253513
    jac_ini[135,127] = 105.571769313180
    jac_ini[135,128] = 54.0657727682604
    jac_ini[135,129] = -39.6392229058201
    jac_ini[135,130] = -10.2713736253513
    jac_ini[135,131] = -24.9575997948692
    jac_ini[135,132] = -23.2849644809540
    jac_ini[135,133] = 48.8496051768258
    jac_ini[135,134] = 8.42240745613237
    jac_ini[135,135] = -136.523516830407
    jac_ini[135,136] = -59.7203367834280
    jac_ini[135,137] = 48.8496051768258
    jac_ini[135,138] = 8.42240745613238
    jac_ini[135,139] = 33.9659505153141
    jac_ini[135,140] = 22.4917262854545
    jac_ini[135,416] = 1
    jac_ini[136,41] = -1.84896616921897
    jac_ini[136,42] = -9.21038227100566
    jac_ini[136,43] = -5.65456401516768
    jac_ini[136,44] = 30.9517475172273
    jac_ini[136,45] = -1.84896616921897
    jac_ini[136,46] = -9.21038227100566
    jac_ini[136,47] = -0.793238195499528
    jac_ini[136,48] = -9.00835072044485
    jac_ini[136,125] = 10.2713736253513
    jac_ini[136,126] = -39.6392229058202
    jac_ini[136,127] = -54.0657727682604
    jac_ini[136,128] = 105.571769313180
    jac_ini[136,129] = 10.2713736253513
    jac_ini[136,130] = -39.6392229058201
    jac_ini[136,131] = 23.2849644809540
    jac_ini[136,132] = -24.9575997948692
    jac_ini[136,133] = -8.42240745613237
    jac_ini[136,134] = 48.8496051768258
    jac_ini[136,135] = 59.7203367834280
    jac_ini[136,136] = -136.523516830407
    jac_ini[136,137] = -8.42240745613238
    jac_ini[136,138] = 48.8496051768258
    jac_ini[136,139] = -22.4917262854545
    jac_ini[136,140] = 33.9659505153141
    jac_ini[136,417] = 1
    jac_ini[137,41] = -9.00835072044484
    jac_ini[137,42] = 0.793238195499527
    jac_ini[137,43] = -9.21038227100566
    jac_ini[137,44] = 1.84896616921897
    jac_ini[137,45] = 30.9517475172273
    jac_ini[137,46] = 5.65456401516768
    jac_ini[137,47] = -9.21038227100566
    jac_ini[137,48] = 1.84896616921897
    jac_ini[137,125] = -24.9575997948692
    jac_ini[137,126] = -23.2849644809540
    jac_ini[137,127] = -39.6392229058202
    jac_ini[137,128] = -10.2713736253513
    jac_ini[137,129] = 105.571769313180
    jac_ini[137,130] = 54.0657727682604
    jac_ini[137,131] = -39.6392229058201
    jac_ini[137,132] = -10.2713736253514
    jac_ini[137,133] = 33.9659505153141
    jac_ini[137,134] = 22.4917262854545
    jac_ini[137,135] = 48.8496051768259
    jac_ini[137,136] = 8.42240745613236
    jac_ini[137,137] = -136.523516830407
    jac_ini[137,138] = -59.7203367834281
    jac_ini[137,139] = 48.8496051768258
    jac_ini[137,140] = 8.42240745613239
    jac_ini[137,418] = 1
    jac_ini[138,41] = -0.793238195499527
    jac_ini[138,42] = -9.00835072044484
    jac_ini[138,43] = -1.84896616921897
    jac_ini[138,44] = -9.21038227100566
    jac_ini[138,45] = -5.65456401516768
    jac_ini[138,46] = 30.9517475172273
    jac_ini[138,47] = -1.84896616921897
    jac_ini[138,48] = -9.21038227100566
    jac_ini[138,125] = 23.2849644809540
    jac_ini[138,126] = -24.9575997948692
    jac_ini[138,127] = 10.2713736253513
    jac_ini[138,128] = -39.6392229058202
    jac_ini[138,129] = -54.0657727682604
    jac_ini[138,130] = 105.571769313180
    jac_ini[138,131] = 10.2713736253514
    jac_ini[138,132] = -39.6392229058201
    jac_ini[138,133] = -22.4917262854545
    jac_ini[138,134] = 33.9659505153141
    jac_ini[138,135] = -8.42240745613236
    jac_ini[138,136] = 48.8496051768259
    jac_ini[138,137] = 59.7203367834281
    jac_ini[138,138] = -136.523516830407
    jac_ini[138,139] = -8.42240745613239
    jac_ini[138,140] = 48.8496051768258
    jac_ini[138,419] = 1
    jac_ini[139,41] = -9.21038227100566
    jac_ini[139,42] = 1.84896616921897
    jac_ini[139,43] = -9.00835072044485
    jac_ini[139,44] = 0.793238195499527
    jac_ini[139,45] = -9.21038227100566
    jac_ini[139,46] = 1.84896616921897
    jac_ini[139,47] = 30.9517475172273
    jac_ini[139,48] = 5.65456401516768
    jac_ini[139,125] = -39.6392229058202
    jac_ini[139,126] = -10.2713736253513
    jac_ini[139,127] = -24.9575997948692
    jac_ini[139,128] = -23.2849644809540
    jac_ini[139,129] = -39.6392229058202
    jac_ini[139,130] = -10.2713736253513
    jac_ini[139,131] = 105.571769313180
    jac_ini[139,132] = 54.0657727682604
    jac_ini[139,133] = 48.8496051768258
    jac_ini[139,134] = 8.42240745613237
    jac_ini[139,135] = 33.9659505153140
    jac_ini[139,136] = 22.4917262854545
    jac_ini[139,137] = 48.8496051768258
    jac_ini[139,138] = 8.42240745613237
    jac_ini[139,139] = -136.548516830407
    jac_ini[139,140] = -59.7203367834281
    jac_ini[140,41] = -1.84896616921897
    jac_ini[140,42] = -9.21038227100566
    jac_ini[140,43] = -0.793238195499527
    jac_ini[140,44] = -9.00835072044485
    jac_ini[140,45] = -1.84896616921897
    jac_ini[140,46] = -9.21038227100566
    jac_ini[140,47] = -5.65456401516768
    jac_ini[140,48] = 30.9517475172273
    jac_ini[140,125] = 10.2713736253513
    jac_ini[140,126] = -39.6392229058202
    jac_ini[140,127] = 23.2849644809540
    jac_ini[140,128] = -24.9575997948692
    jac_ini[140,129] = 10.2713736253513
    jac_ini[140,130] = -39.6392229058202
    jac_ini[140,131] = -54.0657727682604
    jac_ini[140,132] = 105.571769313180
    jac_ini[140,133] = -8.42240745613237
    jac_ini[140,134] = 48.8496051768258
    jac_ini[140,135] = -22.4917262854545
    jac_ini[140,136] = 33.9659505153140
    jac_ini[140,137] = -8.42240745613237
    jac_ini[140,138] = 48.8496051768258
    jac_ini[140,139] = 59.7203367834281
    jac_ini[140,140] = -136.548516830407
    jac_ini[141,85] = 26.5300693004806
    jac_ini[141,86] = 4.84676915585801
    jac_ini[141,87] = -7.89461337514770
    jac_ini[141,88] = 1.58482814504483
    jac_ini[141,89] = -7.72144347466701
    jac_ini[141,90] = 0.679918453285310
    jac_ini[141,91] = -7.89461337514771
    jac_ini[141,92] = 1.58482814504483
    jac_ini[141,141] = -53.0601386009611
    jac_ini[141,142] = -9.69353831171601
    jac_ini[141,143] = 15.7892267502954
    jac_ini[141,144] = -3.16965629008966
    jac_ini[141,145] = 15.4428869493340
    jac_ini[141,146] = -1.35983690657062
    jac_ini[141,147] = 15.7892267502954
    jac_ini[141,148] = -3.16965629008966
    jac_ini[141,149] = 26.5300693004806
    jac_ini[141,150] = 4.84676915585801
    jac_ini[141,151] = -7.89461337514770
    jac_ini[141,152] = 1.58482814504483
    jac_ini[141,153] = -7.72144347466701
    jac_ini[141,154] = 0.679918453285310
    jac_ini[141,155] = -7.89461337514771
    jac_ini[141,156] = 1.58482814504483
    jac_ini[142,85] = -4.84676915585801
    jac_ini[142,86] = 26.5300693004806
    jac_ini[142,87] = -1.58482814504483
    jac_ini[142,88] = -7.89461337514770
    jac_ini[142,89] = -0.679918453285310
    jac_ini[142,90] = -7.72144347466701
    jac_ini[142,91] = -1.58482814504483
    jac_ini[142,92] = -7.89461337514771
    jac_ini[142,141] = 9.69353831171601
    jac_ini[142,142] = -53.0601386009611
    jac_ini[142,143] = 3.16965629008966
    jac_ini[142,144] = 15.7892267502954
    jac_ini[142,145] = 1.35983690657062
    jac_ini[142,146] = 15.4428869493340
    jac_ini[142,147] = 3.16965629008966
    jac_ini[142,148] = 15.7892267502954
    jac_ini[142,149] = -4.84676915585801
    jac_ini[142,150] = 26.5300693004806
    jac_ini[142,151] = -1.58482814504483
    jac_ini[142,152] = -7.89461337514770
    jac_ini[142,153] = -0.679918453285310
    jac_ini[142,154] = -7.72144347466701
    jac_ini[142,155] = -1.58482814504483
    jac_ini[142,156] = -7.89461337514771
    jac_ini[143,85] = -7.89461337514771
    jac_ini[143,86] = 1.58482814504483
    jac_ini[143,87] = 26.5300693004806
    jac_ini[143,88] = 4.84676915585801
    jac_ini[143,89] = -7.89461337514771
    jac_ini[143,90] = 1.58482814504483
    jac_ini[143,91] = -7.72144347466701
    jac_ini[143,92] = 0.679918453285308
    jac_ini[143,141] = 15.7892267502954
    jac_ini[143,142] = -3.16965629008966
    jac_ini[143,143] = -53.0601386009611
    jac_ini[143,144] = -9.69353831171602
    jac_ini[143,145] = 15.7892267502954
    jac_ini[143,146] = -3.16965629008967
    jac_ini[143,147] = 15.4428869493340
    jac_ini[143,148] = -1.35983690657062
    jac_ini[143,149] = -7.89461337514771
    jac_ini[143,150] = 1.58482814504483
    jac_ini[143,151] = 26.5300693004806
    jac_ini[143,152] = 4.84676915585801
    jac_ini[143,153] = -7.89461337514771
    jac_ini[143,154] = 1.58482814504483
    jac_ini[143,155] = -7.72144347466701
    jac_ini[143,156] = 0.679918453285308
    jac_ini[144,85] = -1.58482814504483
    jac_ini[144,86] = -7.89461337514771
    jac_ini[144,87] = -4.84676915585801
    jac_ini[144,88] = 26.5300693004806
    jac_ini[144,89] = -1.58482814504483
    jac_ini[144,90] = -7.89461337514771
    jac_ini[144,91] = -0.679918453285308
    jac_ini[144,92] = -7.72144347466701
    jac_ini[144,141] = 3.16965629008966
    jac_ini[144,142] = 15.7892267502954
    jac_ini[144,143] = 9.69353831171602
    jac_ini[144,144] = -53.0601386009611
    jac_ini[144,145] = 3.16965629008967
    jac_ini[144,146] = 15.7892267502954
    jac_ini[144,147] = 1.35983690657062
    jac_ini[144,148] = 15.4428869493340
    jac_ini[144,149] = -1.58482814504483
    jac_ini[144,150] = -7.89461337514771
    jac_ini[144,151] = -4.84676915585801
    jac_ini[144,152] = 26.5300693004806
    jac_ini[144,153] = -1.58482814504483
    jac_ini[144,154] = -7.89461337514771
    jac_ini[144,155] = -0.679918453285308
    jac_ini[144,156] = -7.72144347466701
    jac_ini[145,85] = -7.72144347466701
    jac_ini[145,86] = 0.679918453285310
    jac_ini[145,87] = -7.89461337514770
    jac_ini[145,88] = 1.58482814504483
    jac_ini[145,89] = 26.5300693004806
    jac_ini[145,90] = 4.84676915585801
    jac_ini[145,91] = -7.89461337514771
    jac_ini[145,92] = 1.58482814504483
    jac_ini[145,141] = 15.4428869493340
    jac_ini[145,142] = -1.35983690657062
    jac_ini[145,143] = 15.7892267502954
    jac_ini[145,144] = -3.16965629008966
    jac_ini[145,145] = -53.0601386009611
    jac_ini[145,146] = -9.69353831171602
    jac_ini[145,147] = 15.7892267502954
    jac_ini[145,148] = -3.16965629008967
    jac_ini[145,149] = -7.72144347466701
    jac_ini[145,150] = 0.679918453285310
    jac_ini[145,151] = -7.89461337514770
    jac_ini[145,152] = 1.58482814504483
    jac_ini[145,153] = 26.5300693004806
    jac_ini[145,154] = 4.84676915585801
    jac_ini[145,155] = -7.89461337514771
    jac_ini[145,156] = 1.58482814504483
    jac_ini[146,85] = -0.679918453285310
    jac_ini[146,86] = -7.72144347466701
    jac_ini[146,87] = -1.58482814504483
    jac_ini[146,88] = -7.89461337514770
    jac_ini[146,89] = -4.84676915585801
    jac_ini[146,90] = 26.5300693004806
    jac_ini[146,91] = -1.58482814504483
    jac_ini[146,92] = -7.89461337514771
    jac_ini[146,141] = 1.35983690657062
    jac_ini[146,142] = 15.4428869493340
    jac_ini[146,143] = 3.16965629008966
    jac_ini[146,144] = 15.7892267502954
    jac_ini[146,145] = 9.69353831171602
    jac_ini[146,146] = -53.0601386009611
    jac_ini[146,147] = 3.16965629008967
    jac_ini[146,148] = 15.7892267502954
    jac_ini[146,149] = -0.679918453285310
    jac_ini[146,150] = -7.72144347466701
    jac_ini[146,151] = -1.58482814504483
    jac_ini[146,152] = -7.89461337514770
    jac_ini[146,153] = -4.84676915585801
    jac_ini[146,154] = 26.5300693004806
    jac_ini[146,155] = -1.58482814504483
    jac_ini[146,156] = -7.89461337514771
    jac_ini[147,85] = -7.89461337514771
    jac_ini[147,86] = 1.58482814504483
    jac_ini[147,87] = -7.72144347466701
    jac_ini[147,88] = 0.679918453285308
    jac_ini[147,89] = -7.89461337514771
    jac_ini[147,90] = 1.58482814504483
    jac_ini[147,91] = 26.5300693004806
    jac_ini[147,92] = 4.84676915585801
    jac_ini[147,141] = 15.7892267502954
    jac_ini[147,142] = -3.16965629008966
    jac_ini[147,143] = 15.4428869493340
    jac_ini[147,144] = -1.35983690657062
    jac_ini[147,145] = 15.7892267502954
    jac_ini[147,146] = -3.16965629008966
    jac_ini[147,147] = -53.0601386009611
    jac_ini[147,148] = -9.69353831171602
    jac_ini[147,149] = -7.89461337514771
    jac_ini[147,150] = 1.58482814504483
    jac_ini[147,151] = -7.72144347466701
    jac_ini[147,152] = 0.679918453285308
    jac_ini[147,153] = -7.89461337514771
    jac_ini[147,154] = 1.58482814504483
    jac_ini[147,155] = 26.5300693004806
    jac_ini[147,156] = 4.84676915585801
    jac_ini[148,85] = -1.58482814504483
    jac_ini[148,86] = -7.89461337514771
    jac_ini[148,87] = -0.679918453285308
    jac_ini[148,88] = -7.72144347466701
    jac_ini[148,89] = -1.58482814504483
    jac_ini[148,90] = -7.89461337514771
    jac_ini[148,91] = -4.84676915585801
    jac_ini[148,92] = 26.5300693004806
    jac_ini[148,141] = 3.16965629008966
    jac_ini[148,142] = 15.7892267502954
    jac_ini[148,143] = 1.35983690657062
    jac_ini[148,144] = 15.4428869493340
    jac_ini[148,145] = 3.16965629008966
    jac_ini[148,146] = 15.7892267502954
    jac_ini[148,147] = 9.69353831171602
    jac_ini[148,148] = -53.0601386009611
    jac_ini[148,149] = -1.58482814504483
    jac_ini[148,150] = -7.89461337514771
    jac_ini[148,151] = -0.679918453285308
    jac_ini[148,152] = -7.72144347466701
    jac_ini[148,153] = -1.58482814504483
    jac_ini[148,154] = -7.89461337514771
    jac_ini[148,155] = -4.84676915585801
    jac_ini[148,156] = 26.5300693004806
    jac_ini[149,141] = 26.5300693004806
    jac_ini[149,142] = 4.84676915585801
    jac_ini[149,143] = -7.89461337514770
    jac_ini[149,144] = 1.58482814504483
    jac_ini[149,145] = -7.72144347466701
    jac_ini[149,146] = 0.679918453285310
    jac_ini[149,147] = -7.89461337514771
    jac_ini[149,148] = 1.58482814504483
    jac_ini[149,149] = -53.0601386009611
    jac_ini[149,150] = -9.69353831171601
    jac_ini[149,151] = 15.7892267502954
    jac_ini[149,152] = -3.16965629008966
    jac_ini[149,153] = 15.4428869493340
    jac_ini[149,154] = -1.35983690657062
    jac_ini[149,155] = 15.7892267502954
    jac_ini[149,156] = -3.16965629008966
    jac_ini[149,157] = 26.5300693004806
    jac_ini[149,158] = 4.84676915585801
    jac_ini[149,159] = -7.89461337514770
    jac_ini[149,160] = 1.58482814504483
    jac_ini[149,161] = -7.72144347466701
    jac_ini[149,162] = 0.679918453285310
    jac_ini[149,163] = -7.89461337514771
    jac_ini[149,164] = 1.58482814504483
    jac_ini[150,141] = -4.84676915585801
    jac_ini[150,142] = 26.5300693004806
    jac_ini[150,143] = -1.58482814504483
    jac_ini[150,144] = -7.89461337514770
    jac_ini[150,145] = -0.679918453285310
    jac_ini[150,146] = -7.72144347466701
    jac_ini[150,147] = -1.58482814504483
    jac_ini[150,148] = -7.89461337514771
    jac_ini[150,149] = 9.69353831171601
    jac_ini[150,150] = -53.0601386009611
    jac_ini[150,151] = 3.16965629008966
    jac_ini[150,152] = 15.7892267502954
    jac_ini[150,153] = 1.35983690657062
    jac_ini[150,154] = 15.4428869493340
    jac_ini[150,155] = 3.16965629008966
    jac_ini[150,156] = 15.7892267502954
    jac_ini[150,157] = -4.84676915585801
    jac_ini[150,158] = 26.5300693004806
    jac_ini[150,159] = -1.58482814504483
    jac_ini[150,160] = -7.89461337514770
    jac_ini[150,161] = -0.679918453285310
    jac_ini[150,162] = -7.72144347466701
    jac_ini[150,163] = -1.58482814504483
    jac_ini[150,164] = -7.89461337514771
    jac_ini[151,141] = -7.89461337514771
    jac_ini[151,142] = 1.58482814504483
    jac_ini[151,143] = 26.5300693004806
    jac_ini[151,144] = 4.84676915585801
    jac_ini[151,145] = -7.89461337514771
    jac_ini[151,146] = 1.58482814504483
    jac_ini[151,147] = -7.72144347466701
    jac_ini[151,148] = 0.679918453285308
    jac_ini[151,149] = 15.7892267502954
    jac_ini[151,150] = -3.16965629008966
    jac_ini[151,151] = -53.0601386009611
    jac_ini[151,152] = -9.69353831171602
    jac_ini[151,153] = 15.7892267502954
    jac_ini[151,154] = -3.16965629008967
    jac_ini[151,155] = 15.4428869493340
    jac_ini[151,156] = -1.35983690657062
    jac_ini[151,157] = -7.89461337514771
    jac_ini[151,158] = 1.58482814504483
    jac_ini[151,159] = 26.5300693004806
    jac_ini[151,160] = 4.84676915585801
    jac_ini[151,161] = -7.89461337514771
    jac_ini[151,162] = 1.58482814504483
    jac_ini[151,163] = -7.72144347466701
    jac_ini[151,164] = 0.679918453285308
    jac_ini[152,141] = -1.58482814504483
    jac_ini[152,142] = -7.89461337514771
    jac_ini[152,143] = -4.84676915585801
    jac_ini[152,144] = 26.5300693004806
    jac_ini[152,145] = -1.58482814504483
    jac_ini[152,146] = -7.89461337514771
    jac_ini[152,147] = -0.679918453285308
    jac_ini[152,148] = -7.72144347466701
    jac_ini[152,149] = 3.16965629008966
    jac_ini[152,150] = 15.7892267502954
    jac_ini[152,151] = 9.69353831171602
    jac_ini[152,152] = -53.0601386009611
    jac_ini[152,153] = 3.16965629008967
    jac_ini[152,154] = 15.7892267502954
    jac_ini[152,155] = 1.35983690657062
    jac_ini[152,156] = 15.4428869493340
    jac_ini[152,157] = -1.58482814504483
    jac_ini[152,158] = -7.89461337514771
    jac_ini[152,159] = -4.84676915585801
    jac_ini[152,160] = 26.5300693004806
    jac_ini[152,161] = -1.58482814504483
    jac_ini[152,162] = -7.89461337514771
    jac_ini[152,163] = -0.679918453285308
    jac_ini[152,164] = -7.72144347466701
    jac_ini[153,141] = -7.72144347466701
    jac_ini[153,142] = 0.679918453285310
    jac_ini[153,143] = -7.89461337514770
    jac_ini[153,144] = 1.58482814504483
    jac_ini[153,145] = 26.5300693004806
    jac_ini[153,146] = 4.84676915585801
    jac_ini[153,147] = -7.89461337514771
    jac_ini[153,148] = 1.58482814504483
    jac_ini[153,149] = 15.4428869493340
    jac_ini[153,150] = -1.35983690657062
    jac_ini[153,151] = 15.7892267502954
    jac_ini[153,152] = -3.16965629008966
    jac_ini[153,153] = -53.0601386009611
    jac_ini[153,154] = -9.69353831171602
    jac_ini[153,155] = 15.7892267502954
    jac_ini[153,156] = -3.16965629008967
    jac_ini[153,157] = -7.72144347466701
    jac_ini[153,158] = 0.679918453285310
    jac_ini[153,159] = -7.89461337514770
    jac_ini[153,160] = 1.58482814504483
    jac_ini[153,161] = 26.5300693004806
    jac_ini[153,162] = 4.84676915585801
    jac_ini[153,163] = -7.89461337514771
    jac_ini[153,164] = 1.58482814504483
    jac_ini[154,141] = -0.679918453285310
    jac_ini[154,142] = -7.72144347466701
    jac_ini[154,143] = -1.58482814504483
    jac_ini[154,144] = -7.89461337514770
    jac_ini[154,145] = -4.84676915585801
    jac_ini[154,146] = 26.5300693004806
    jac_ini[154,147] = -1.58482814504483
    jac_ini[154,148] = -7.89461337514771
    jac_ini[154,149] = 1.35983690657062
    jac_ini[154,150] = 15.4428869493340
    jac_ini[154,151] = 3.16965629008966
    jac_ini[154,152] = 15.7892267502954
    jac_ini[154,153] = 9.69353831171602
    jac_ini[154,154] = -53.0601386009611
    jac_ini[154,155] = 3.16965629008967
    jac_ini[154,156] = 15.7892267502954
    jac_ini[154,157] = -0.679918453285310
    jac_ini[154,158] = -7.72144347466701
    jac_ini[154,159] = -1.58482814504483
    jac_ini[154,160] = -7.89461337514770
    jac_ini[154,161] = -4.84676915585801
    jac_ini[154,162] = 26.5300693004806
    jac_ini[154,163] = -1.58482814504483
    jac_ini[154,164] = -7.89461337514771
    jac_ini[155,141] = -7.89461337514771
    jac_ini[155,142] = 1.58482814504483
    jac_ini[155,143] = -7.72144347466701
    jac_ini[155,144] = 0.679918453285308
    jac_ini[155,145] = -7.89461337514771
    jac_ini[155,146] = 1.58482814504483
    jac_ini[155,147] = 26.5300693004806
    jac_ini[155,148] = 4.84676915585801
    jac_ini[155,149] = 15.7892267502954
    jac_ini[155,150] = -3.16965629008966
    jac_ini[155,151] = 15.4428869493340
    jac_ini[155,152] = -1.35983690657062
    jac_ini[155,153] = 15.7892267502954
    jac_ini[155,154] = -3.16965629008966
    jac_ini[155,155] = -53.0851386009611
    jac_ini[155,156] = -9.69353831171602
    jac_ini[155,157] = -7.89461337514771
    jac_ini[155,158] = 1.58482814504483
    jac_ini[155,159] = -7.72144347466701
    jac_ini[155,160] = 0.679918453285308
    jac_ini[155,161] = -7.89461337514771
    jac_ini[155,162] = 1.58482814504483
    jac_ini[155,163] = 26.5300693004806
    jac_ini[155,164] = 4.84676915585801
    jac_ini[156,141] = -1.58482814504483
    jac_ini[156,142] = -7.89461337514771
    jac_ini[156,143] = -0.679918453285308
    jac_ini[156,144] = -7.72144347466701
    jac_ini[156,145] = -1.58482814504483
    jac_ini[156,146] = -7.89461337514771
    jac_ini[156,147] = -4.84676915585801
    jac_ini[156,148] = 26.5300693004806
    jac_ini[156,149] = 3.16965629008966
    jac_ini[156,150] = 15.7892267502954
    jac_ini[156,151] = 1.35983690657062
    jac_ini[156,152] = 15.4428869493340
    jac_ini[156,153] = 3.16965629008966
    jac_ini[156,154] = 15.7892267502954
    jac_ini[156,155] = 9.69353831171602
    jac_ini[156,156] = -53.0851386009611
    jac_ini[156,157] = -1.58482814504483
    jac_ini[156,158] = -7.89461337514771
    jac_ini[156,159] = -0.679918453285308
    jac_ini[156,160] = -7.72144347466701
    jac_ini[156,161] = -1.58482814504483
    jac_ini[156,162] = -7.89461337514771
    jac_ini[156,163] = -4.84676915585801
    jac_ini[156,164] = 26.5300693004806
    jac_ini[157,17] = 26.5300693004806
    jac_ini[157,18] = 4.84676915585801
    jac_ini[157,19] = -7.89461337514770
    jac_ini[157,20] = 1.58482814504483
    jac_ini[157,21] = -7.72144347466701
    jac_ini[157,22] = 0.679918453285310
    jac_ini[157,23] = -7.89461337514771
    jac_ini[157,24] = 1.58482814504483
    jac_ini[157,149] = 26.5300693004806
    jac_ini[157,150] = 4.84676915585801
    jac_ini[157,151] = -7.89461337514770
    jac_ini[157,152] = 1.58482814504483
    jac_ini[157,153] = -7.72144347466701
    jac_ini[157,154] = 0.679918453285310
    jac_ini[157,155] = -7.89461337514771
    jac_ini[157,156] = 1.58482814504483
    jac_ini[157,157] = -53.0601386009611
    jac_ini[157,158] = -9.69353831171601
    jac_ini[157,159] = 15.7892267502954
    jac_ini[157,160] = -3.16965629008966
    jac_ini[157,161] = 15.4428869493340
    jac_ini[157,162] = -1.35983690657062
    jac_ini[157,163] = 15.7892267502954
    jac_ini[157,164] = -3.16965629008966
    jac_ini[157,424] = 1
    jac_ini[158,17] = -4.84676915585801
    jac_ini[158,18] = 26.5300693004806
    jac_ini[158,19] = -1.58482814504483
    jac_ini[158,20] = -7.89461337514770
    jac_ini[158,21] = -0.679918453285310
    jac_ini[158,22] = -7.72144347466701
    jac_ini[158,23] = -1.58482814504483
    jac_ini[158,24] = -7.89461337514771
    jac_ini[158,149] = -4.84676915585801
    jac_ini[158,150] = 26.5300693004806
    jac_ini[158,151] = -1.58482814504483
    jac_ini[158,152] = -7.89461337514770
    jac_ini[158,153] = -0.679918453285310
    jac_ini[158,154] = -7.72144347466701
    jac_ini[158,155] = -1.58482814504483
    jac_ini[158,156] = -7.89461337514771
    jac_ini[158,157] = 9.69353831171601
    jac_ini[158,158] = -53.0601386009611
    jac_ini[158,159] = 3.16965629008966
    jac_ini[158,160] = 15.7892267502954
    jac_ini[158,161] = 1.35983690657062
    jac_ini[158,162] = 15.4428869493340
    jac_ini[158,163] = 3.16965629008966
    jac_ini[158,164] = 15.7892267502954
    jac_ini[158,425] = 1
    jac_ini[159,17] = -7.89461337514771
    jac_ini[159,18] = 1.58482814504483
    jac_ini[159,19] = 26.5300693004806
    jac_ini[159,20] = 4.84676915585801
    jac_ini[159,21] = -7.89461337514771
    jac_ini[159,22] = 1.58482814504483
    jac_ini[159,23] = -7.72144347466701
    jac_ini[159,24] = 0.679918453285308
    jac_ini[159,149] = -7.89461337514771
    jac_ini[159,150] = 1.58482814504483
    jac_ini[159,151] = 26.5300693004806
    jac_ini[159,152] = 4.84676915585801
    jac_ini[159,153] = -7.89461337514771
    jac_ini[159,154] = 1.58482814504483
    jac_ini[159,155] = -7.72144347466701
    jac_ini[159,156] = 0.679918453285308
    jac_ini[159,157] = 15.7892267502954
    jac_ini[159,158] = -3.16965629008966
    jac_ini[159,159] = -53.0601386009611
    jac_ini[159,160] = -9.69353831171602
    jac_ini[159,161] = 15.7892267502954
    jac_ini[159,162] = -3.16965629008967
    jac_ini[159,163] = 15.4428869493340
    jac_ini[159,164] = -1.35983690657062
    jac_ini[159,426] = 1
    jac_ini[160,17] = -1.58482814504483
    jac_ini[160,18] = -7.89461337514771
    jac_ini[160,19] = -4.84676915585801
    jac_ini[160,20] = 26.5300693004806
    jac_ini[160,21] = -1.58482814504483
    jac_ini[160,22] = -7.89461337514771
    jac_ini[160,23] = -0.679918453285308
    jac_ini[160,24] = -7.72144347466701
    jac_ini[160,149] = -1.58482814504483
    jac_ini[160,150] = -7.89461337514771
    jac_ini[160,151] = -4.84676915585801
    jac_ini[160,152] = 26.5300693004806
    jac_ini[160,153] = -1.58482814504483
    jac_ini[160,154] = -7.89461337514771
    jac_ini[160,155] = -0.679918453285308
    jac_ini[160,156] = -7.72144347466701
    jac_ini[160,157] = 3.16965629008966
    jac_ini[160,158] = 15.7892267502954
    jac_ini[160,159] = 9.69353831171602
    jac_ini[160,160] = -53.0601386009611
    jac_ini[160,161] = 3.16965629008967
    jac_ini[160,162] = 15.7892267502954
    jac_ini[160,163] = 1.35983690657062
    jac_ini[160,164] = 15.4428869493340
    jac_ini[160,427] = 1
    jac_ini[161,17] = -7.72144347466701
    jac_ini[161,18] = 0.679918453285310
    jac_ini[161,19] = -7.89461337514770
    jac_ini[161,20] = 1.58482814504483
    jac_ini[161,21] = 26.5300693004806
    jac_ini[161,22] = 4.84676915585801
    jac_ini[161,23] = -7.89461337514771
    jac_ini[161,24] = 1.58482814504483
    jac_ini[161,149] = -7.72144347466701
    jac_ini[161,150] = 0.679918453285310
    jac_ini[161,151] = -7.89461337514770
    jac_ini[161,152] = 1.58482814504483
    jac_ini[161,153] = 26.5300693004806
    jac_ini[161,154] = 4.84676915585801
    jac_ini[161,155] = -7.89461337514771
    jac_ini[161,156] = 1.58482814504483
    jac_ini[161,157] = 15.4428869493340
    jac_ini[161,158] = -1.35983690657062
    jac_ini[161,159] = 15.7892267502954
    jac_ini[161,160] = -3.16965629008966
    jac_ini[161,161] = -53.0601386009611
    jac_ini[161,162] = -9.69353831171602
    jac_ini[161,163] = 15.7892267502954
    jac_ini[161,164] = -3.16965629008967
    jac_ini[161,428] = 1
    jac_ini[162,17] = -0.679918453285310
    jac_ini[162,18] = -7.72144347466701
    jac_ini[162,19] = -1.58482814504483
    jac_ini[162,20] = -7.89461337514770
    jac_ini[162,21] = -4.84676915585801
    jac_ini[162,22] = 26.5300693004806
    jac_ini[162,23] = -1.58482814504483
    jac_ini[162,24] = -7.89461337514771
    jac_ini[162,149] = -0.679918453285310
    jac_ini[162,150] = -7.72144347466701
    jac_ini[162,151] = -1.58482814504483
    jac_ini[162,152] = -7.89461337514770
    jac_ini[162,153] = -4.84676915585801
    jac_ini[162,154] = 26.5300693004806
    jac_ini[162,155] = -1.58482814504483
    jac_ini[162,156] = -7.89461337514771
    jac_ini[162,157] = 1.35983690657062
    jac_ini[162,158] = 15.4428869493340
    jac_ini[162,159] = 3.16965629008966
    jac_ini[162,160] = 15.7892267502954
    jac_ini[162,161] = 9.69353831171602
    jac_ini[162,162] = -53.0601386009611
    jac_ini[162,163] = 3.16965629008967
    jac_ini[162,164] = 15.7892267502954
    jac_ini[162,429] = 1
    jac_ini[163,17] = -7.89461337514771
    jac_ini[163,18] = 1.58482814504483
    jac_ini[163,19] = -7.72144347466701
    jac_ini[163,20] = 0.679918453285308
    jac_ini[163,21] = -7.89461337514771
    jac_ini[163,22] = 1.58482814504483
    jac_ini[163,23] = 26.5300693004806
    jac_ini[163,24] = 4.84676915585801
    jac_ini[163,149] = -7.89461337514771
    jac_ini[163,150] = 1.58482814504483
    jac_ini[163,151] = -7.72144347466701
    jac_ini[163,152] = 0.679918453285308
    jac_ini[163,153] = -7.89461337514771
    jac_ini[163,154] = 1.58482814504483
    jac_ini[163,155] = 26.5300693004806
    jac_ini[163,156] = 4.84676915585801
    jac_ini[163,157] = 15.7892267502954
    jac_ini[163,158] = -3.16965629008966
    jac_ini[163,159] = 15.4428869493340
    jac_ini[163,160] = -1.35983690657062
    jac_ini[163,161] = 15.7892267502954
    jac_ini[163,162] = -3.16965629008966
    jac_ini[163,163] = -53.0601386009611
    jac_ini[163,164] = -9.69353831171602
    jac_ini[164,17] = -1.58482814504483
    jac_ini[164,18] = -7.89461337514771
    jac_ini[164,19] = -0.679918453285308
    jac_ini[164,20] = -7.72144347466701
    jac_ini[164,21] = -1.58482814504483
    jac_ini[164,22] = -7.89461337514771
    jac_ini[164,23] = -4.84676915585801
    jac_ini[164,24] = 26.5300693004806
    jac_ini[164,149] = -1.58482814504483
    jac_ini[164,150] = -7.89461337514771
    jac_ini[164,151] = -0.679918453285308
    jac_ini[164,152] = -7.72144347466701
    jac_ini[164,153] = -1.58482814504483
    jac_ini[164,154] = -7.89461337514771
    jac_ini[164,155] = -4.84676915585801
    jac_ini[164,156] = 26.5300693004806
    jac_ini[164,157] = 3.16965629008966
    jac_ini[164,158] = 15.7892267502954
    jac_ini[164,159] = 1.35983690657062
    jac_ini[164,160] = 15.4428869493340
    jac_ini[164,161] = 3.16965629008966
    jac_ini[164,162] = 15.7892267502954
    jac_ini[164,163] = 9.69353831171602
    jac_ini[164,164] = -53.0601386009611
    jac_ini[165,165] = -1067.70480704130
    jac_ini[165,173] = 67.7048070412999
    jac_ini[166,166] = -1067.70480704130
    jac_ini[166,174] = 67.7048070412999
    jac_ini[167,53] = 157.977883096366
    jac_ini[167,167] = -361.092304220266
    jac_ini[167,175] = 135.409614082600
    jac_ini[168,54] = 157.977883096366
    jac_ini[168,168] = -361.092304220266
    jac_ini[168,176] = 135.409614082600
    jac_ini[169,169] = -361.092304220266
    jac_ini[169,177] = 135.409614082600
    jac_ini[169,207] = 157.977883096366
    jac_ini[170,170] = -361.092304220266
    jac_ini[170,178] = 135.409614082600
    jac_ini[170,208] = 157.977883096366
    jac_ini[171,171] = -361.092304220266
    jac_ini[171,179] = 135.409614082600
    jac_ini[171,209] = 157.977883096366
    jac_ini[172,172] = -361.092304220266
    jac_ini[172,180] = 135.409614082600
    jac_ini[172,210] = 157.977883096366
    jac_ini[173,55] = 157.977883096366
    jac_ini[173,165] = 67.7048070412999
    jac_ini[173,173] = -361.092304220266
    jac_ini[173,181] = 135.409614082600
    jac_ini[174,56] = 157.977883096366
    jac_ini[174,166] = 67.7048070412999
    jac_ini[174,174] = -361.092304220266
    jac_ini[174,182] = 135.409614082600
    jac_ini[175,167] = 135.409614082600
    jac_ini[175,175] = -248.250959151433
    jac_ini[175,183] = 67.7048070412999
    jac_ini[175,223] = 45.1365380275333
    jac_ini[176,168] = 135.409614082600
    jac_ini[176,176] = -248.250959151433
    jac_ini[176,184] = 67.7048070412999
    jac_ini[176,224] = 45.1365380275333
    jac_ini[177,169] = 135.409614082600
    jac_ini[177,177] = -248.250959151433
    jac_ini[177,185] = 67.7048070412999
    jac_ini[177,225] = 45.1365380275333
    jac_ini[178,170] = 135.409614082600
    jac_ini[178,178] = -248.250959151433
    jac_ini[178,186] = 67.7048070412999
    jac_ini[178,226] = 45.1365380275333
    jac_ini[179,171] = 135.409614082600
    jac_ini[179,179] = -248.250959151433
    jac_ini[179,187] = 67.7048070412999
    jac_ini[179,227] = 45.1365380275333
    jac_ini[180,172] = 135.409614082600
    jac_ini[180,180] = -248.250959151433
    jac_ini[180,188] = 67.7048070412999
    jac_ini[180,228] = 45.1365380275333
    jac_ini[181,173] = 135.409614082600
    jac_ini[181,181] = -248.250959151433
    jac_ini[181,189] = 67.7048070412999
    jac_ini[181,229] = 45.1365380275333
    jac_ini[182,174] = 135.409614082600
    jac_ini[182,182] = -248.250959151433
    jac_ini[182,190] = 67.7048070412999
    jac_ini[182,230] = 45.1365380275333
    jac_ini[183,57] = 157.977883096366
    jac_ini[183,175] = 67.7048070412999
    jac_ini[183,183] = -270.819228165200
    jac_ini[183,191] = 45.1365380275333
    jac_ini[184,58] = 157.977883096366
    jac_ini[184,176] = 67.7048070412999
    jac_ini[184,184] = -270.819228165200
    jac_ini[184,192] = 45.1365380275333
    jac_ini[185,177] = 67.7048070412999
    jac_ini[185,185] = -270.819228165200
    jac_ini[185,193] = 45.1365380275333
    jac_ini[185,211] = 157.977883096366
    jac_ini[186,178] = 67.7048070412999
    jac_ini[186,186] = -270.819228165200
    jac_ini[186,194] = 45.1365380275333
    jac_ini[186,212] = 157.977883096366
    jac_ini[187,179] = 67.7048070412999
    jac_ini[187,187] = -270.819228165200
    jac_ini[187,195] = 45.1365380275333
    jac_ini[187,213] = 157.977883096366
    jac_ini[188,180] = 67.7048070412999
    jac_ini[188,188] = -270.819228165200
    jac_ini[188,196] = 45.1365380275333
    jac_ini[188,214] = 157.977883096366
    jac_ini[189,59] = 157.977883096366
    jac_ini[189,181] = 67.7048070412999
    jac_ini[189,189] = -270.819228165200
    jac_ini[189,197] = 45.1365380275333
    jac_ini[190,60] = 157.977883096366
    jac_ini[190,182] = 67.7048070412999
    jac_ini[190,190] = -270.819228165200
    jac_ini[190,198] = 45.1365380275333
    jac_ini[191,61] = 157.977883096366
    jac_ini[191,183] = 45.1365380275333
    jac_ini[191,191] = -361.092304220266
    jac_ini[191,199] = 157.977883096366
    jac_ini[192,62] = 157.977883096366
    jac_ini[192,184] = 45.1365380275333
    jac_ini[192,192] = -361.092304220266
    jac_ini[192,200] = 157.977883096366
    jac_ini[193,185] = 45.1365380275333
    jac_ini[193,193] = -361.092304220266
    jac_ini[193,201] = 157.977883096366
    jac_ini[193,215] = 157.977883096366
    jac_ini[194,186] = 45.1365380275333
    jac_ini[194,194] = -361.092304220266
    jac_ini[194,202] = 157.977883096366
    jac_ini[194,216] = 157.977883096366
    jac_ini[195,187] = 45.1365380275333
    jac_ini[195,195] = -361.092304220266
    jac_ini[195,203] = 157.977883096366
    jac_ini[195,217] = 157.977883096366
    jac_ini[196,188] = 45.1365380275333
    jac_ini[196,196] = -361.092304220266
    jac_ini[196,204] = 157.977883096366
    jac_ini[196,218] = 157.977883096366
    jac_ini[197,63] = 157.977883096366
    jac_ini[197,189] = 45.1365380275333
    jac_ini[197,197] = -361.092304220266
    jac_ini[197,205] = 157.977883096366
    jac_ini[198,64] = 157.977883096366
    jac_ini[198,190] = 45.1365380275333
    jac_ini[198,198] = -361.092304220266
    jac_ini[198,206] = 157.977883096366
    jac_ini[199,65] = 157.977883096366
    jac_ini[199,191] = 157.977883096366
    jac_ini[199,199] = -315.955766192733
    jac_ini[199,420] = 1
    jac_ini[200,66] = 157.977883096366
    jac_ini[200,192] = 157.977883096366
    jac_ini[200,200] = -315.955766192733
    jac_ini[201,193] = 157.977883096366
    jac_ini[201,201] = -315.955766192733
    jac_ini[201,219] = 157.977883096366
    jac_ini[202,194] = 157.977883096366
    jac_ini[202,202] = -315.955766192733
    jac_ini[202,220] = 157.977883096366
    jac_ini[203,195] = 157.977883096366
    jac_ini[203,203] = -315.955766192733
    jac_ini[203,221] = 157.977883096366
    jac_ini[204,196] = 157.977883096366
    jac_ini[204,204] = -315.955766192733
    jac_ini[204,222] = 157.977883096366
    jac_ini[205,67] = 157.977883096366
    jac_ini[205,197] = 157.977883096366
    jac_ini[205,205] = -315.955766192733
    jac_ini[205,421] = 1
    jac_ini[206,68] = 157.977883096366
    jac_ini[206,198] = 157.977883096366
    jac_ini[206,206] = -315.955766192733
    jac_ini[207,169] = 157.977883096366
    jac_ini[207,207] = -157.977883096366
    jac_ini[208,170] = 157.977883096366
    jac_ini[208,208] = -157.977883096366
    jac_ini[209,171] = 157.977883096366
    jac_ini[209,209] = -157.977883096366
    jac_ini[210,172] = 157.977883096366
    jac_ini[210,210] = -157.977883096366
    jac_ini[211,185] = 157.977883096366
    jac_ini[211,211] = -157.977883096366
    jac_ini[212,186] = 157.977883096366
    jac_ini[212,212] = -157.977883096366
    jac_ini[213,187] = 157.977883096366
    jac_ini[213,213] = -157.977883096366
    jac_ini[214,188] = 157.977883096366
    jac_ini[214,214] = -157.977883096366
    jac_ini[215,193] = 157.977883096366
    jac_ini[215,215] = -157.977883096366
    jac_ini[216,194] = 157.977883096366
    jac_ini[216,216] = -157.977883096366
    jac_ini[217,195] = 157.977883096366
    jac_ini[217,217] = -157.977883096366
    jac_ini[218,196] = 157.977883096366
    jac_ini[218,218] = -157.977883096366
    jac_ini[219,201] = 157.977883096366
    jac_ini[219,219] = -157.977883096366
    jac_ini[220,202] = 157.977883096366
    jac_ini[220,220] = -157.977883096366
    jac_ini[221,203] = 157.977883096366
    jac_ini[221,221] = -157.977883096366
    jac_ini[222,204] = 157.977883096366
    jac_ini[222,222] = -157.977883096366
    jac_ini[223,49] = 135.409614082600
    jac_ini[223,175] = 45.1365380275333
    jac_ini[223,223] = -180.546152110133
    jac_ini[223,430] = 1
    jac_ini[224,50] = 135.409614082600
    jac_ini[224,176] = 45.1365380275333
    jac_ini[224,224] = -180.546152110133
    jac_ini[225,177] = 45.1365380275333
    jac_ini[225,225] = -180.546152110133
    jac_ini[225,231] = 135.409614082600
    jac_ini[226,178] = 45.1365380275333
    jac_ini[226,226] = -180.546152110133
    jac_ini[226,232] = 135.409614082600
    jac_ini[227,179] = 45.1365380275333
    jac_ini[227,227] = -180.546152110133
    jac_ini[227,233] = 135.409614082600
    jac_ini[228,180] = 45.1365380275333
    jac_ini[228,228] = -180.546152110133
    jac_ini[228,234] = 135.409614082600
    jac_ini[229,51] = 135.409614082600
    jac_ini[229,181] = 45.1365380275333
    jac_ini[229,229] = -180.546152110133
    jac_ini[229,431] = 1
    jac_ini[230,52] = 135.409614082600
    jac_ini[230,182] = 45.1365380275333
    jac_ini[230,230] = -180.546152110133
    jac_ini[231,225] = 135.409614082600
    jac_ini[231,231] = -135.409614082600
    jac_ini[232,226] = 135.409614082600
    jac_ini[232,232] = -135.409614082600
    jac_ini[233,227] = 135.409614082600
    jac_ini[233,233] = -135.409614082600
    jac_ini[234,228] = 135.409614082600
    jac_ini[234,234] = -135.409614082600
    jac_ini[235,1] = -0.212261128378539
    jac_ini[235,2] = -0.849044513514155
    jac_ini[235,3] = 0.212261128378539
    jac_ini[235,4] = 0.849044513514155
    jac_ini[235,235] = -1
    jac_ini[236,1] = 0.849044513514155
    jac_ini[236,2] = -0.212261128378539
    jac_ini[236,3] = -0.849044513514155
    jac_ini[236,4] = 0.212261128378539
    jac_ini[236,236] = -1
    jac_ini[237,3] = -0.212261128378539
    jac_ini[237,4] = -0.849044513514155
    jac_ini[237,5] = 0.212261128378539
    jac_ini[237,6] = 0.849044513514155
    jac_ini[237,237] = -1
    jac_ini[238,3] = 0.849044513514155
    jac_ini[238,4] = -0.212261128378539
    jac_ini[238,5] = -0.849044513514155
    jac_ini[238,6] = 0.212261128378539
    jac_ini[238,238] = -1
    jac_ini[239,1] = 0.212261128378539
    jac_ini[239,2] = 0.849044513514155
    jac_ini[239,5] = -0.212261128378539
    jac_ini[239,6] = -0.849044513514155
    jac_ini[239,239] = -1
    jac_ini[240,1] = -0.849044513514155
    jac_ini[240,2] = 0.212261128378539
    jac_ini[240,5] = 0.849044513514155
    jac_ini[240,6] = -0.212261128378539
    jac_ini[240,240] = -1
    jac_ini[241,1] = 105.571769313180
    jac_ini[241,2] = 54.0657727682604
    jac_ini[241,3] = -39.6392229058202
    jac_ini[241,4] = -10.2713736253513
    jac_ini[241,5] = -24.9575997948692
    jac_ini[241,6] = -23.2849644809540
    jac_ini[241,7] = -39.6392229058202
    jac_ini[241,8] = -10.2713736253513
    jac_ini[241,69] = -105.571769313180
    jac_ini[241,70] = -54.0657727682604
    jac_ini[241,71] = 39.6392229058202
    jac_ini[241,72] = 10.2713736253513
    jac_ini[241,73] = 24.9575997948692
    jac_ini[241,74] = 23.2849644809540
    jac_ini[241,75] = 39.6392229058202
    jac_ini[241,76] = 10.2713736253513
    jac_ini[241,241] = -1
    jac_ini[242,1] = -54.0657727682604
    jac_ini[242,2] = 105.571769313180
    jac_ini[242,3] = 10.2713736253513
    jac_ini[242,4] = -39.6392229058202
    jac_ini[242,5] = 23.2849644809540
    jac_ini[242,6] = -24.9575997948692
    jac_ini[242,7] = 10.2713736253513
    jac_ini[242,8] = -39.6392229058202
    jac_ini[242,69] = 54.0657727682604
    jac_ini[242,70] = -105.571769313180
    jac_ini[242,71] = -10.2713736253513
    jac_ini[242,72] = 39.6392229058202
    jac_ini[242,73] = -23.2849644809540
    jac_ini[242,74] = 24.9575997948692
    jac_ini[242,75] = -10.2713736253513
    jac_ini[242,76] = 39.6392229058202
    jac_ini[242,242] = -1
    jac_ini[243,1] = -39.6392229058202
    jac_ini[243,2] = -10.2713736253513
    jac_ini[243,3] = 105.571769313180
    jac_ini[243,4] = 54.0657727682604
    jac_ini[243,5] = -39.6392229058201
    jac_ini[243,6] = -10.2713736253513
    jac_ini[243,7] = -24.9575997948692
    jac_ini[243,8] = -23.2849644809540
    jac_ini[243,69] = 39.6392229058202
    jac_ini[243,70] = 10.2713736253513
    jac_ini[243,71] = -105.571769313180
    jac_ini[243,72] = -54.0657727682604
    jac_ini[243,73] = 39.6392229058201
    jac_ini[243,74] = 10.2713736253513
    jac_ini[243,75] = 24.9575997948692
    jac_ini[243,76] = 23.2849644809540
    jac_ini[243,243] = -1
    jac_ini[244,1] = 10.2713736253513
    jac_ini[244,2] = -39.6392229058202
    jac_ini[244,3] = -54.0657727682604
    jac_ini[244,4] = 105.571769313180
    jac_ini[244,5] = 10.2713736253513
    jac_ini[244,6] = -39.6392229058201
    jac_ini[244,7] = 23.2849644809540
    jac_ini[244,8] = -24.9575997948692
    jac_ini[244,69] = -10.2713736253513
    jac_ini[244,70] = 39.6392229058202
    jac_ini[244,71] = 54.0657727682604
    jac_ini[244,72] = -105.571769313180
    jac_ini[244,73] = -10.2713736253513
    jac_ini[244,74] = 39.6392229058201
    jac_ini[244,75] = -23.2849644809540
    jac_ini[244,76] = 24.9575997948692
    jac_ini[244,244] = -1
    jac_ini[245,1] = -24.9575997948692
    jac_ini[245,2] = -23.2849644809540
    jac_ini[245,3] = -39.6392229058202
    jac_ini[245,4] = -10.2713736253513
    jac_ini[245,5] = 105.571769313180
    jac_ini[245,6] = 54.0657727682604
    jac_ini[245,7] = -39.6392229058201
    jac_ini[245,8] = -10.2713736253514
    jac_ini[245,69] = 24.9575997948692
    jac_ini[245,70] = 23.2849644809540
    jac_ini[245,71] = 39.6392229058202
    jac_ini[245,72] = 10.2713736253513
    jac_ini[245,73] = -105.571769313180
    jac_ini[245,74] = -54.0657727682604
    jac_ini[245,75] = 39.6392229058201
    jac_ini[245,76] = 10.2713736253514
    jac_ini[245,245] = -1
    jac_ini[246,1] = 23.2849644809540
    jac_ini[246,2] = -24.9575997948692
    jac_ini[246,3] = 10.2713736253513
    jac_ini[246,4] = -39.6392229058202
    jac_ini[246,5] = -54.0657727682604
    jac_ini[246,6] = 105.571769313180
    jac_ini[246,7] = 10.2713736253514
    jac_ini[246,8] = -39.6392229058201
    jac_ini[246,69] = -23.2849644809540
    jac_ini[246,70] = 24.9575997948692
    jac_ini[246,71] = -10.2713736253513
    jac_ini[246,72] = 39.6392229058202
    jac_ini[246,73] = 54.0657727682604
    jac_ini[246,74] = -105.571769313180
    jac_ini[246,75] = -10.2713736253514
    jac_ini[246,76] = 39.6392229058201
    jac_ini[246,246] = -1
    jac_ini[247,241] = 1
    jac_ini[247,243] = 1
    jac_ini[247,245] = 1
    jac_ini[247,247] = -1
    jac_ini[248,242] = 1
    jac_ini[248,244] = 1
    jac_ini[248,246] = 1
    jac_ini[248,248] = -1
    jac_ini[249,167] = -67.7048070412999
    jac_ini[249,249] = -1
    jac_ini[250,168] = -67.7048070412999
    jac_ini[250,250] = -1
    jac_ini[251,169] = -67.7048070412999
    jac_ini[251,251] = -1
    jac_ini[252,170] = -67.7048070412999
    jac_ini[252,252] = -1
    jac_ini[253,171] = -67.7048070412999
    jac_ini[253,253] = -1
    jac_ini[254,172] = -67.7048070412999
    jac_ini[254,254] = -1
    jac_ini[255,249] = 1
    jac_ini[255,251] = 1
    jac_ini[255,253] = 1
    jac_ini[255,255] = -1
    jac_ini[256,250] = 1
    jac_ini[256,252] = 1
    jac_ini[256,254] = 1
    jac_ini[256,256] = -1
    jac_ini[257,167] = 135.409614082600
    jac_ini[257,175] = -135.409614082600
    jac_ini[257,257] = -1
    jac_ini[258,168] = 135.409614082600
    jac_ini[258,176] = -135.409614082600
    jac_ini[258,258] = -1
    jac_ini[259,169] = 135.409614082600
    jac_ini[259,177] = -135.409614082600
    jac_ini[259,259] = -1
    jac_ini[260,170] = 135.409614082600
    jac_ini[260,178] = -135.409614082600
    jac_ini[260,260] = -1
    jac_ini[261,171] = 135.409614082600
    jac_ini[261,179] = -135.409614082600
    jac_ini[261,261] = -1
    jac_ini[262,172] = 135.409614082600
    jac_ini[262,180] = -135.409614082600
    jac_ini[262,262] = -1
    jac_ini[263,257] = 1
    jac_ini[263,259] = 1
    jac_ini[263,261] = 1
    jac_ini[263,263] = -1
    jac_ini[264,258] = 1
    jac_ini[264,260] = 1
    jac_ini[264,262] = 1
    jac_ini[264,264] = -1
    jac_ini[265,175] = 67.7048070412999
    jac_ini[265,183] = -67.7048070412999
    jac_ini[265,265] = -1
    jac_ini[266,176] = 67.7048070412999
    jac_ini[266,184] = -67.7048070412999
    jac_ini[266,266] = -1
    jac_ini[267,177] = 67.7048070412999
    jac_ini[267,185] = -67.7048070412999
    jac_ini[267,267] = -1
    jac_ini[268,178] = 67.7048070412999
    jac_ini[268,186] = -67.7048070412999
    jac_ini[268,268] = -1
    jac_ini[269,179] = 67.7048070412999
    jac_ini[269,187] = -67.7048070412999
    jac_ini[269,269] = -1
    jac_ini[270,180] = 67.7048070412999
    jac_ini[270,188] = -67.7048070412999
    jac_ini[270,270] = -1
    jac_ini[271,265] = 1
    jac_ini[271,267] = 1
    jac_ini[271,269] = 1
    jac_ini[271,271] = -1
    jac_ini[272,266] = 1
    jac_ini[272,268] = 1
    jac_ini[272,270] = 1
    jac_ini[272,272] = -1
    jac_ini[273,183] = 45.1365380275333
    jac_ini[273,191] = -45.1365380275333
    jac_ini[273,273] = -1
    jac_ini[274,184] = 45.1365380275333
    jac_ini[274,192] = -45.1365380275333
    jac_ini[274,274] = -1
    jac_ini[275,185] = 45.1365380275333
    jac_ini[275,193] = -45.1365380275333
    jac_ini[275,275] = -1
    jac_ini[276,186] = 45.1365380275333
    jac_ini[276,194] = -45.1365380275333
    jac_ini[276,276] = -1
    jac_ini[277,187] = 45.1365380275333
    jac_ini[277,195] = -45.1365380275333
    jac_ini[277,277] = -1
    jac_ini[278,188] = 45.1365380275333
    jac_ini[278,196] = -45.1365380275333
    jac_ini[278,278] = -1
    jac_ini[279,273] = 1
    jac_ini[279,275] = 1
    jac_ini[279,277] = 1
    jac_ini[279,279] = -1
    jac_ini[280,274] = 1
    jac_ini[280,276] = 1
    jac_ini[280,278] = 1
    jac_ini[280,280] = -1
    jac_ini[281,191] = 157.977883096366
    jac_ini[281,199] = -157.977883096366
    jac_ini[281,281] = -1
    jac_ini[282,192] = 157.977883096366
    jac_ini[282,200] = -157.977883096366
    jac_ini[282,282] = -1
    jac_ini[283,193] = 157.977883096366
    jac_ini[283,201] = -157.977883096366
    jac_ini[283,283] = -1
    jac_ini[284,194] = 157.977883096366
    jac_ini[284,202] = -157.977883096366
    jac_ini[284,284] = -1
    jac_ini[285,195] = 157.977883096366
    jac_ini[285,203] = -157.977883096366
    jac_ini[285,285] = -1
    jac_ini[286,196] = 157.977883096366
    jac_ini[286,204] = -157.977883096366
    jac_ini[286,286] = -1
    jac_ini[287,281] = 1
    jac_ini[287,283] = 1
    jac_ini[287,285] = 1
    jac_ini[287,287] = -1
    jac_ini[288,282] = 1
    jac_ini[288,284] = 1
    jac_ini[288,286] = 1
    jac_ini[288,288] = -1
    jac_ini[289,53] = -157.977883096366
    jac_ini[289,167] = 157.977883096366
    jac_ini[289,289] = -1
    jac_ini[290,54] = -157.977883096366
    jac_ini[290,168] = 157.977883096366
    jac_ini[290,290] = -1
    jac_ini[291,169] = 157.977883096366
    jac_ini[291,207] = -157.977883096366
    jac_ini[291,291] = -1
    jac_ini[292,170] = 157.977883096366
    jac_ini[292,208] = -157.977883096366
    jac_ini[292,292] = -1
    jac_ini[293,171] = 157.977883096366
    jac_ini[293,209] = -157.977883096366
    jac_ini[293,293] = -1
    jac_ini[294,172] = 157.977883096366
    jac_ini[294,210] = -157.977883096366
    jac_ini[294,294] = -1
    jac_ini[295,289] = 1
    jac_ini[295,291] = 1
    jac_ini[295,293] = 1
    jac_ini[295,295] = -1
    jac_ini[296,290] = 1
    jac_ini[296,292] = 1
    jac_ini[296,294] = 1
    jac_ini[296,296] = -1
    jac_ini[297,57] = -157.977883096366
    jac_ini[297,183] = 157.977883096366
    jac_ini[297,297] = -1
    jac_ini[298,58] = -157.977883096366
    jac_ini[298,184] = 157.977883096366
    jac_ini[298,298] = -1
    jac_ini[299,185] = 157.977883096366
    jac_ini[299,211] = -157.977883096366
    jac_ini[299,299] = -1
    jac_ini[300,186] = 157.977883096366
    jac_ini[300,212] = -157.977883096366
    jac_ini[300,300] = -1
    jac_ini[301,187] = 157.977883096366
    jac_ini[301,213] = -157.977883096366
    jac_ini[301,301] = -1
    jac_ini[302,188] = 157.977883096366
    jac_ini[302,214] = -157.977883096366
    jac_ini[302,302] = -1
    jac_ini[303,297] = 1
    jac_ini[303,299] = 1
    jac_ini[303,301] = 1
    jac_ini[303,303] = -1
    jac_ini[304,298] = 1
    jac_ini[304,300] = 1
    jac_ini[304,302] = 1
    jac_ini[304,304] = -1
    jac_ini[305,61] = -157.977883096366
    jac_ini[305,191] = 157.977883096366
    jac_ini[305,305] = -1
    jac_ini[306,62] = -157.977883096366
    jac_ini[306,192] = 157.977883096366
    jac_ini[306,306] = -1
    jac_ini[307,193] = 157.977883096366
    jac_ini[307,215] = -157.977883096366
    jac_ini[307,307] = -1
    jac_ini[308,194] = 157.977883096366
    jac_ini[308,216] = -157.977883096366
    jac_ini[308,308] = -1
    jac_ini[309,195] = 157.977883096366
    jac_ini[309,217] = -157.977883096366
    jac_ini[309,309] = -1
    jac_ini[310,196] = 157.977883096366
    jac_ini[310,218] = -157.977883096366
    jac_ini[310,310] = -1
    jac_ini[311,305] = 1
    jac_ini[311,307] = 1
    jac_ini[311,309] = 1
    jac_ini[311,311] = -1
    jac_ini[312,306] = 1
    jac_ini[312,308] = 1
    jac_ini[312,310] = 1
    jac_ini[312,312] = -1
    jac_ini[313,65] = -157.977883096366
    jac_ini[313,199] = 157.977883096366
    jac_ini[313,313] = -1
    jac_ini[314,66] = -157.977883096366
    jac_ini[314,200] = 157.977883096366
    jac_ini[314,314] = -1
    jac_ini[315,201] = 157.977883096366
    jac_ini[315,219] = -157.977883096366
    jac_ini[315,315] = -1
    jac_ini[316,202] = 157.977883096366
    jac_ini[316,220] = -157.977883096366
    jac_ini[316,316] = -1
    jac_ini[317,203] = 157.977883096366
    jac_ini[317,221] = -157.977883096366
    jac_ini[317,317] = -1
    jac_ini[318,204] = 157.977883096366
    jac_ini[318,222] = -157.977883096366
    jac_ini[318,318] = -1
    jac_ini[319,313] = 1
    jac_ini[319,315] = 1
    jac_ini[319,317] = 1
    jac_ini[319,319] = -1
    jac_ini[320,314] = 1
    jac_ini[320,316] = 1
    jac_ini[320,318] = 1
    jac_ini[320,320] = -1
    jac_ini[321,175] = 45.1365380275333
    jac_ini[321,223] = -45.1365380275333
    jac_ini[321,321] = -1
    jac_ini[322,176] = 45.1365380275333
    jac_ini[322,224] = -45.1365380275333
    jac_ini[322,322] = -1
    jac_ini[323,177] = 45.1365380275333
    jac_ini[323,225] = -45.1365380275333
    jac_ini[323,323] = -1
    jac_ini[324,178] = 45.1365380275333
    jac_ini[324,226] = -45.1365380275333
    jac_ini[324,324] = -1
    jac_ini[325,179] = 45.1365380275333
    jac_ini[325,227] = -45.1365380275333
    jac_ini[325,325] = -1
    jac_ini[326,180] = 45.1365380275333
    jac_ini[326,228] = -45.1365380275333
    jac_ini[326,326] = -1
    jac_ini[327,321] = 1
    jac_ini[327,323] = 1
    jac_ini[327,325] = 1
    jac_ini[327,327] = -1
    jac_ini[328,322] = 1
    jac_ini[328,324] = 1
    jac_ini[328,326] = 1
    jac_ini[328,328] = -1
    jac_ini[329,49] = -135.409614082600
    jac_ini[329,223] = 135.409614082600
    jac_ini[329,329] = -1
    jac_ini[330,50] = -135.409614082600
    jac_ini[330,224] = 135.409614082600
    jac_ini[330,330] = -1
    jac_ini[331,225] = 135.409614082600
    jac_ini[331,231] = -135.409614082600
    jac_ini[331,331] = -1
    jac_ini[332,226] = 135.409614082600
    jac_ini[332,232] = -135.409614082600
    jac_ini[332,332] = -1
    jac_ini[333,227] = 135.409614082600
    jac_ini[333,233] = -135.409614082600
    jac_ini[333,333] = -1
    jac_ini[334,228] = 135.409614082600
    jac_ini[334,234] = -135.409614082600
    jac_ini[334,334] = -1
    jac_ini[335,329] = 1
    jac_ini[335,331] = 1
    jac_ini[335,333] = 1
    jac_ini[335,335] = -1
    jac_ini[336,330] = 1
    jac_ini[336,332] = 1
    jac_ini[336,334] = 1
    jac_ini[336,336] = -1
    jac_ini[343,337] = 1
    jac_ini[343,339] = 1
    jac_ini[343,341] = 1
    jac_ini[343,343] = 1
    jac_ini[344,338] = 1
    jac_ini[344,340] = 1
    jac_ini[344,342] = 1
    jac_ini[344,344] = 1
    jac_ini[351,345] = 1
    jac_ini[351,347] = 1
    jac_ini[351,349] = 1
    jac_ini[351,351] = 1
    jac_ini[352,346] = 1
    jac_ini[352,348] = 1
    jac_ini[352,350] = 1
    jac_ini[352,352] = 1
    jac_ini[359,353] = 1
    jac_ini[359,355] = 1
    jac_ini[359,357] = 1
    jac_ini[359,359] = 1
    jac_ini[360,354] = 1
    jac_ini[360,356] = 1
    jac_ini[360,358] = 1
    jac_ini[360,360] = 1
    jac_ini[367,361] = 1
    jac_ini[367,363] = 1
    jac_ini[367,365] = 1
    jac_ini[367,367] = 1
    jac_ini[368,362] = 1
    jac_ini[368,364] = 1
    jac_ini[368,366] = 1
    jac_ini[368,368] = 1
    jac_ini[375,369] = 1
    jac_ini[375,371] = 1
    jac_ini[375,373] = 1
    jac_ini[375,375] = 1
    jac_ini[376,370] = 1
    jac_ini[376,372] = 1
    jac_ini[376,374] = 1
    jac_ini[376,376] = 1
    jac_ini[383,377] = 1
    jac_ini[383,379] = 1
    jac_ini[383,381] = 1
    jac_ini[383,383] = 1
    jac_ini[384,378] = 1
    jac_ini[384,380] = 1
    jac_ini[384,382] = 1
    jac_ini[384,384] = 1
    jac_ini[387,385] = 1
    jac_ini[387,387] = 1
    jac_ini[388,386] = 1.00000000000000
    jac_ini[388,388] = 1.00000000000000
    jac_ini[391,389] = 1
    jac_ini[391,391] = 1
    jac_ini[392,390] = 1.00000000000000
    jac_ini[392,392] = 1.00000000000000
    jac_ini[395,393] = 1
    jac_ini[395,395] = 1
    jac_ini[396,394] = 1.00000000000000
    jac_ini[396,396] = 1.00000000000000
    jac_ini[399,397] = 1
    jac_ini[399,399] = 1
    jac_ini[400,398] = 1.00000000000000
    jac_ini[400,400] = 1.00000000000000
    jac_ini[403,401] = 1
    jac_ini[403,403] = 1
    jac_ini[404,402] = 1.00000000000000
    jac_ini[404,404] = 1.00000000000000
    jac_ini[405,411] = -1/3
    jac_ini[407,411] = -1/3
    jac_ini[409,411] = -1/3
    jac_ini[411,411] = 1
    jac_ini[411,412] = 1
    jac_ini[412,412] = -1
    jac_ini[413,413] = 1
    jac_ini[420,420] = 1
    jac_ini[421,421] = 1
    jac_ini[422,422] = 1
    jac_ini[423,423] = 1
    jac_ini[430,430] = 1
    jac_ini[431,431] = 1
    jac_ini[432,432] = 1
    jac_ini[433,433] = 1





@numba.njit(cache=True)
def sp_jac_ini_eval_xy(sp_jac_ini,x,y,u,p,Dt,xyup = 1):

    sp_jac_ini[4081] = y[336]
    sp_jac_ini[4082] = y[337]
    sp_jac_ini[4083] = -y[336]
    sp_jac_ini[4084] = -y[337]
    sp_jac_ini[4085] = y[0] - y[6]
    sp_jac_ini[4086] = y[1] - y[7]
    sp_jac_ini[4087] = y[338]
    sp_jac_ini[4088] = y[339]
    sp_jac_ini[4089] = -y[338]
    sp_jac_ini[4090] = -y[339]
    sp_jac_ini[4091] = y[2] - y[6]
    sp_jac_ini[4092] = y[3] - y[7]
    sp_jac_ini[4093] = y[340]
    sp_jac_ini[4094] = y[341]
    sp_jac_ini[4095] = -y[340]
    sp_jac_ini[4096] = -y[341]
    sp_jac_ini[4097] = y[4] - y[6]
    sp_jac_ini[4098] = y[5] - y[7]
    sp_jac_ini[4099] = -y[337]
    sp_jac_ini[4100] = y[336]
    sp_jac_ini[4101] = y[337]
    sp_jac_ini[4102] = -y[336]
    sp_jac_ini[4103] = y[1] - y[7]
    sp_jac_ini[4104] = -y[0] + y[6]
    sp_jac_ini[4105] = -y[339]
    sp_jac_ini[4106] = y[338]
    sp_jac_ini[4107] = y[339]
    sp_jac_ini[4108] = -y[338]
    sp_jac_ini[4109] = y[3] - y[7]
    sp_jac_ini[4110] = -y[2] + y[6]
    sp_jac_ini[4111] = -y[341]
    sp_jac_ini[4112] = y[340]
    sp_jac_ini[4113] = y[341]
    sp_jac_ini[4114] = -y[340]
    sp_jac_ini[4115] = y[5] - y[7]
    sp_jac_ini[4116] = -y[4] + y[6]
    sp_jac_ini[4125] = y[344]
    sp_jac_ini[4126] = y[345]
    sp_jac_ini[4127] = -y[344]
    sp_jac_ini[4128] = -y[345]
    sp_jac_ini[4129] = y[8] - y[14]
    sp_jac_ini[4130] = y[9] - y[15]
    sp_jac_ini[4131] = y[346]
    sp_jac_ini[4132] = y[347]
    sp_jac_ini[4133] = -y[346]
    sp_jac_ini[4134] = -y[347]
    sp_jac_ini[4135] = y[10] - y[14]
    sp_jac_ini[4136] = y[11] - y[15]
    sp_jac_ini[4137] = y[348]
    sp_jac_ini[4138] = y[349]
    sp_jac_ini[4139] = -y[348]
    sp_jac_ini[4140] = -y[349]
    sp_jac_ini[4141] = y[12] - y[14]
    sp_jac_ini[4142] = y[13] - y[15]
    sp_jac_ini[4143] = -y[345]
    sp_jac_ini[4144] = y[344]
    sp_jac_ini[4145] = y[345]
    sp_jac_ini[4146] = -y[344]
    sp_jac_ini[4147] = y[9] - y[15]
    sp_jac_ini[4148] = -y[8] + y[14]
    sp_jac_ini[4149] = -y[347]
    sp_jac_ini[4150] = y[346]
    sp_jac_ini[4151] = y[347]
    sp_jac_ini[4152] = -y[346]
    sp_jac_ini[4153] = y[11] - y[15]
    sp_jac_ini[4154] = -y[10] + y[14]
    sp_jac_ini[4155] = -y[349]
    sp_jac_ini[4156] = y[348]
    sp_jac_ini[4157] = y[349]
    sp_jac_ini[4158] = -y[348]
    sp_jac_ini[4159] = y[13] - y[15]
    sp_jac_ini[4160] = -y[12] + y[14]
    sp_jac_ini[4169] = y[352]
    sp_jac_ini[4170] = y[353]
    sp_jac_ini[4171] = -y[352]
    sp_jac_ini[4172] = -y[353]
    sp_jac_ini[4173] = y[16] - y[22]
    sp_jac_ini[4174] = y[17] - y[23]
    sp_jac_ini[4175] = y[354]
    sp_jac_ini[4176] = y[355]
    sp_jac_ini[4177] = -y[354]
    sp_jac_ini[4178] = -y[355]
    sp_jac_ini[4179] = y[18] - y[22]
    sp_jac_ini[4180] = y[19] - y[23]
    sp_jac_ini[4181] = y[356]
    sp_jac_ini[4182] = y[357]
    sp_jac_ini[4183] = -y[356]
    sp_jac_ini[4184] = -y[357]
    sp_jac_ini[4185] = y[20] - y[22]
    sp_jac_ini[4186] = y[21] - y[23]
    sp_jac_ini[4187] = -y[353]
    sp_jac_ini[4188] = y[352]
    sp_jac_ini[4189] = y[353]
    sp_jac_ini[4190] = -y[352]
    sp_jac_ini[4191] = y[17] - y[23]
    sp_jac_ini[4192] = -y[16] + y[22]
    sp_jac_ini[4193] = -y[355]
    sp_jac_ini[4194] = y[354]
    sp_jac_ini[4195] = y[355]
    sp_jac_ini[4196] = -y[354]
    sp_jac_ini[4197] = y[19] - y[23]
    sp_jac_ini[4198] = -y[18] + y[22]
    sp_jac_ini[4199] = -y[357]
    sp_jac_ini[4200] = y[356]
    sp_jac_ini[4201] = y[357]
    sp_jac_ini[4202] = -y[356]
    sp_jac_ini[4203] = y[21] - y[23]
    sp_jac_ini[4204] = -y[20] + y[22]
    sp_jac_ini[4213] = y[360]
    sp_jac_ini[4214] = y[361]
    sp_jac_ini[4215] = -y[360]
    sp_jac_ini[4216] = -y[361]
    sp_jac_ini[4217] = y[24] - y[30]
    sp_jac_ini[4218] = y[25] - y[31]
    sp_jac_ini[4219] = y[362]
    sp_jac_ini[4220] = y[363]
    sp_jac_ini[4221] = -y[362]
    sp_jac_ini[4222] = -y[363]
    sp_jac_ini[4223] = y[26] - y[30]
    sp_jac_ini[4224] = y[27] - y[31]
    sp_jac_ini[4225] = y[364]
    sp_jac_ini[4226] = y[365]
    sp_jac_ini[4227] = -y[364]
    sp_jac_ini[4228] = -y[365]
    sp_jac_ini[4229] = y[28] - y[30]
    sp_jac_ini[4230] = y[29] - y[31]
    sp_jac_ini[4231] = -y[361]
    sp_jac_ini[4232] = y[360]
    sp_jac_ini[4233] = y[361]
    sp_jac_ini[4234] = -y[360]
    sp_jac_ini[4235] = y[25] - y[31]
    sp_jac_ini[4236] = -y[24] + y[30]
    sp_jac_ini[4237] = -y[363]
    sp_jac_ini[4238] = y[362]
    sp_jac_ini[4239] = y[363]
    sp_jac_ini[4240] = -y[362]
    sp_jac_ini[4241] = y[27] - y[31]
    sp_jac_ini[4242] = -y[26] + y[30]
    sp_jac_ini[4243] = -y[365]
    sp_jac_ini[4244] = y[364]
    sp_jac_ini[4245] = y[365]
    sp_jac_ini[4246] = -y[364]
    sp_jac_ini[4247] = y[29] - y[31]
    sp_jac_ini[4248] = -y[28] + y[30]
    sp_jac_ini[4257] = y[368]
    sp_jac_ini[4258] = y[369]
    sp_jac_ini[4259] = -y[368]
    sp_jac_ini[4260] = -y[369]
    sp_jac_ini[4261] = y[32] - y[38]
    sp_jac_ini[4262] = y[33] - y[39]
    sp_jac_ini[4263] = y[370]
    sp_jac_ini[4264] = y[371]
    sp_jac_ini[4265] = -y[370]
    sp_jac_ini[4266] = -y[371]
    sp_jac_ini[4267] = y[34] - y[38]
    sp_jac_ini[4268] = y[35] - y[39]
    sp_jac_ini[4269] = y[372]
    sp_jac_ini[4270] = y[373]
    sp_jac_ini[4271] = -y[372]
    sp_jac_ini[4272] = -y[373]
    sp_jac_ini[4273] = y[36] - y[38]
    sp_jac_ini[4274] = y[37] - y[39]
    sp_jac_ini[4275] = -y[369]
    sp_jac_ini[4276] = y[368]
    sp_jac_ini[4277] = y[369]
    sp_jac_ini[4278] = -y[368]
    sp_jac_ini[4279] = y[33] - y[39]
    sp_jac_ini[4280] = -y[32] + y[38]
    sp_jac_ini[4281] = -y[371]
    sp_jac_ini[4282] = y[370]
    sp_jac_ini[4283] = y[371]
    sp_jac_ini[4284] = -y[370]
    sp_jac_ini[4285] = y[35] - y[39]
    sp_jac_ini[4286] = -y[34] + y[38]
    sp_jac_ini[4287] = -y[373]
    sp_jac_ini[4288] = y[372]
    sp_jac_ini[4289] = y[373]
    sp_jac_ini[4290] = -y[372]
    sp_jac_ini[4291] = y[37] - y[39]
    sp_jac_ini[4292] = -y[36] + y[38]
    sp_jac_ini[4301] = y[376]
    sp_jac_ini[4302] = y[377]
    sp_jac_ini[4303] = -y[376]
    sp_jac_ini[4304] = -y[377]
    sp_jac_ini[4305] = y[40] - y[46]
    sp_jac_ini[4306] = y[41] - y[47]
    sp_jac_ini[4307] = y[378]
    sp_jac_ini[4308] = y[379]
    sp_jac_ini[4309] = -y[378]
    sp_jac_ini[4310] = -y[379]
    sp_jac_ini[4311] = y[42] - y[46]
    sp_jac_ini[4312] = y[43] - y[47]
    sp_jac_ini[4313] = y[380]
    sp_jac_ini[4314] = y[381]
    sp_jac_ini[4315] = -y[380]
    sp_jac_ini[4316] = -y[381]
    sp_jac_ini[4317] = y[44] - y[46]
    sp_jac_ini[4318] = y[45] - y[47]
    sp_jac_ini[4319] = -y[377]
    sp_jac_ini[4320] = y[376]
    sp_jac_ini[4321] = y[377]
    sp_jac_ini[4322] = -y[376]
    sp_jac_ini[4323] = y[41] - y[47]
    sp_jac_ini[4324] = -y[40] + y[46]
    sp_jac_ini[4325] = -y[379]
    sp_jac_ini[4326] = y[378]
    sp_jac_ini[4327] = y[379]
    sp_jac_ini[4328] = -y[378]
    sp_jac_ini[4329] = y[43] - y[47]
    sp_jac_ini[4330] = -y[42] + y[46]
    sp_jac_ini[4331] = -y[381]
    sp_jac_ini[4332] = y[380]
    sp_jac_ini[4333] = y[381]
    sp_jac_ini[4334] = -y[380]
    sp_jac_ini[4335] = y[45] - y[47]
    sp_jac_ini[4336] = -y[44] + y[46]
    sp_jac_ini[4345] = y[384]
    sp_jac_ini[4346] = 1.0*y[385]
    sp_jac_ini[4347] = -y[384]
    sp_jac_ini[4348] = -1.0*y[385]
    sp_jac_ini[4349] = y[48] - y[50]
    sp_jac_ini[4350] = 1.0*y[49] - 1.0*y[51]
    sp_jac_ini[4351] = -1.0*y[385]
    sp_jac_ini[4352] = 1.0*y[384]
    sp_jac_ini[4353] = 1.0*y[385]
    sp_jac_ini[4354] = -1.0*y[384]
    sp_jac_ini[4355] = 1.0*y[49] - 1.0*y[51]
    sp_jac_ini[4356] = -1.0*y[48] + 1.0*y[50]
    sp_jac_ini[4361] = y[388]
    sp_jac_ini[4362] = 1.0*y[389]
    sp_jac_ini[4363] = -y[388]
    sp_jac_ini[4364] = -1.0*y[389]
    sp_jac_ini[4365] = y[52] - y[54]
    sp_jac_ini[4366] = 1.0*y[53] - 1.0*y[55]
    sp_jac_ini[4367] = -1.0*y[389]
    sp_jac_ini[4368] = 1.0*y[388]
    sp_jac_ini[4369] = 1.0*y[389]
    sp_jac_ini[4370] = -1.0*y[388]
    sp_jac_ini[4371] = 1.0*y[53] - 1.0*y[55]
    sp_jac_ini[4372] = -1.0*y[52] + 1.0*y[54]
    sp_jac_ini[4377] = y[392]
    sp_jac_ini[4378] = 1.0*y[393]
    sp_jac_ini[4379] = -y[392]
    sp_jac_ini[4380] = -1.0*y[393]
    sp_jac_ini[4381] = y[56] - y[58]
    sp_jac_ini[4382] = 1.0*y[57] - 1.0*y[59]
    sp_jac_ini[4383] = -1.0*y[393]
    sp_jac_ini[4384] = 1.0*y[392]
    sp_jac_ini[4385] = 1.0*y[393]
    sp_jac_ini[4386] = -1.0*y[392]
    sp_jac_ini[4387] = 1.0*y[57] - 1.0*y[59]
    sp_jac_ini[4388] = -1.0*y[56] + 1.0*y[58]
    sp_jac_ini[4393] = y[396]
    sp_jac_ini[4394] = 1.0*y[397]
    sp_jac_ini[4395] = -y[396]
    sp_jac_ini[4396] = -1.0*y[397]
    sp_jac_ini[4397] = y[60] - y[62]
    sp_jac_ini[4398] = 1.0*y[61] - 1.0*y[63]
    sp_jac_ini[4399] = -1.0*y[397]
    sp_jac_ini[4400] = 1.0*y[396]
    sp_jac_ini[4401] = 1.0*y[397]
    sp_jac_ini[4402] = -1.0*y[396]
    sp_jac_ini[4403] = 1.0*y[61] - 1.0*y[63]
    sp_jac_ini[4404] = -1.0*y[60] + 1.0*y[62]
    sp_jac_ini[4409] = y[400]
    sp_jac_ini[4410] = 1.0*y[401]
    sp_jac_ini[4411] = -y[400]
    sp_jac_ini[4412] = -1.0*y[401]
    sp_jac_ini[4413] = y[64] - y[66]
    sp_jac_ini[4414] = 1.0*y[65] - 1.0*y[67]
    sp_jac_ini[4415] = -1.0*y[401]
    sp_jac_ini[4416] = 1.0*y[400]
    sp_jac_ini[4417] = 1.0*y[401]
    sp_jac_ini[4418] = -1.0*y[400]
    sp_jac_ini[4419] = 1.0*y[65] - 1.0*y[67]
    sp_jac_ini[4420] = -1.0*y[64] + 1.0*y[66]
    sp_jac_ini[4425] = y[404]
    sp_jac_ini[4426] = 1.0*y[405]
    sp_jac_ini[4427] = -y[404]
    sp_jac_ini[4428] = -1.0*y[405]
    sp_jac_ini[4429] = y[0] - y[6]
    sp_jac_ini[4430] = 1.0*y[1] - 1.0*y[7]
    sp_jac_ini[4432] = -1.0*y[405]
    sp_jac_ini[4433] = 1.0*y[404]
    sp_jac_ini[4434] = 1.0*y[405]
    sp_jac_ini[4435] = -1.0*y[404]
    sp_jac_ini[4436] = 1.0*y[1] - 1.0*y[7]
    sp_jac_ini[4437] = -1.0*y[0] + 1.0*y[6]
    sp_jac_ini[4438] = y[406]
    sp_jac_ini[4439] = 1.0*y[407]
    sp_jac_ini[4440] = -y[406]
    sp_jac_ini[4441] = -1.0*y[407]
    sp_jac_ini[4442] = y[2] - y[6]
    sp_jac_ini[4443] = 1.0*y[3] - 1.0*y[7]
    sp_jac_ini[4445] = -1.0*y[407]
    sp_jac_ini[4446] = 1.0*y[406]
    sp_jac_ini[4447] = 1.0*y[407]
    sp_jac_ini[4448] = -1.0*y[406]
    sp_jac_ini[4449] = 1.0*y[3] - 1.0*y[7]
    sp_jac_ini[4450] = -1.0*y[2] + 1.0*y[6]
    sp_jac_ini[4451] = y[408]
    sp_jac_ini[4452] = 1.0*y[409]
    sp_jac_ini[4453] = -y[408]
    sp_jac_ini[4454] = -1.0*y[409]
    sp_jac_ini[4455] = y[4] - y[6]
    sp_jac_ini[4456] = 1.0*y[5] - 1.0*y[7]
    sp_jac_ini[4458] = -1.0*y[409]
    sp_jac_ini[4459] = 1.0*y[408]
    sp_jac_ini[4460] = 1.0*y[409]
    sp_jac_ini[4461] = -1.0*y[408]
    sp_jac_ini[4462] = 1.0*y[5] - 1.0*y[7]
    sp_jac_ini[4463] = -1.0*y[4] + 1.0*y[6]
    sp_jac_ini[4466] = Piecewise(np.array([(-1, y[411] < 0), (1, True)]))
    sp_jac_ini[4468] = y[164]
    sp_jac_ini[4470] = -p[1]*y[404]/sqrt(y[405]**2 + y[404]**2 + 0.1) - 2*p[2]*y[404]
    sp_jac_ini[4471] = -p[1]*y[405]/sqrt(y[405]**2 + y[404]**2 + 0.1) - 2*p[2]*y[405]
    sp_jac_ini[4473] = y[413]
    sp_jac_ini[4474] = 1.0*y[414]
    sp_jac_ini[4475] = -y[413]
    sp_jac_ini[4476] = -1.0*y[414]
    sp_jac_ini[4477] = y[132] - y[138]
    sp_jac_ini[4478] = 1.0*y[133] - 1.0*y[139]
    sp_jac_ini[4479] = -1.0*y[414]
    sp_jac_ini[4480] = 1.0*y[413]
    sp_jac_ini[4481] = 1.0*y[414]
    sp_jac_ini[4482] = -1.0*y[413]
    sp_jac_ini[4483] = 1.0*y[133] - 1.0*y[139]
    sp_jac_ini[4484] = -1.0*y[132] + 1.0*y[138]
    sp_jac_ini[4485] = y[415]
    sp_jac_ini[4486] = 1.0*y[416]
    sp_jac_ini[4487] = -y[415]
    sp_jac_ini[4488] = -1.0*y[416]
    sp_jac_ini[4489] = y[134] - y[138]
    sp_jac_ini[4490] = 1.0*y[135] - 1.0*y[139]
    sp_jac_ini[4491] = -1.0*y[416]
    sp_jac_ini[4492] = 1.0*y[415]
    sp_jac_ini[4493] = 1.0*y[416]
    sp_jac_ini[4494] = -1.0*y[415]
    sp_jac_ini[4495] = 1.0*y[135] - 1.0*y[139]
    sp_jac_ini[4496] = -1.0*y[134] + 1.0*y[138]
    sp_jac_ini[4497] = y[417]
    sp_jac_ini[4498] = 1.0*y[418]
    sp_jac_ini[4499] = -y[417]
    sp_jac_ini[4500] = -1.0*y[418]
    sp_jac_ini[4501] = y[136] - y[138]
    sp_jac_ini[4502] = 1.0*y[137] - 1.0*y[139]
    sp_jac_ini[4503] = -1.0*y[418]
    sp_jac_ini[4504] = 1.0*y[417]
    sp_jac_ini[4505] = 1.0*y[418]
    sp_jac_ini[4506] = -1.0*y[417]
    sp_jac_ini[4507] = 1.0*y[137] - 1.0*y[139]
    sp_jac_ini[4508] = -1.0*y[136] + 1.0*y[138]
    sp_jac_ini[4509] = -y[421]/(y[198] - y[204] + 1.0e-8)**2
    sp_jac_ini[4510] = y[421]/(y[198] - y[204] + 1.0e-8)**2
    sp_jac_ini[4512] = 1/(y[198] - y[204] + 1.0e-8)
    sp_jac_ini[4513] = y[421]/(-y[198] + y[204] + 1.0e-8)**2
    sp_jac_ini[4514] = -y[421]/(-y[198] + y[204] + 1.0e-8)**2
    sp_jac_ini[4516] = 1/(-y[198] + y[204] + 1.0e-8)
    sp_jac_ini[4518] = -Piecewise(np.array([(-1, y[421] < 0), (1, True)]))
    sp_jac_ini[4519] = -p[4]*y[413]/sqrt(y[414]**2 + y[413]**2 + 0.1) - 2*p[5]*y[413]
    sp_jac_ini[4520] = -p[4]*y[414]/sqrt(y[414]**2 + y[413]**2 + 0.1) - 2*p[5]*y[414]
    sp_jac_ini[4522] = y[423]
    sp_jac_ini[4523] = 1.0*y[424]
    sp_jac_ini[4524] = -y[423]
    sp_jac_ini[4525] = -1.0*y[424]
    sp_jac_ini[4526] = y[156] - y[162]
    sp_jac_ini[4527] = 1.0*y[157] - 1.0*y[163]
    sp_jac_ini[4528] = -1.0*y[424]
    sp_jac_ini[4529] = 1.0*y[423]
    sp_jac_ini[4530] = 1.0*y[424]
    sp_jac_ini[4531] = -1.0*y[423]
    sp_jac_ini[4532] = 1.0*y[157] - 1.0*y[163]
    sp_jac_ini[4533] = -1.0*y[156] + 1.0*y[162]
    sp_jac_ini[4534] = y[425]
    sp_jac_ini[4535] = 1.0*y[426]
    sp_jac_ini[4536] = -y[425]
    sp_jac_ini[4537] = -1.0*y[426]
    sp_jac_ini[4538] = y[158] - y[162]
    sp_jac_ini[4539] = 1.0*y[159] - 1.0*y[163]
    sp_jac_ini[4540] = -1.0*y[426]
    sp_jac_ini[4541] = 1.0*y[425]
    sp_jac_ini[4542] = 1.0*y[426]
    sp_jac_ini[4543] = -1.0*y[425]
    sp_jac_ini[4544] = 1.0*y[159] - 1.0*y[163]
    sp_jac_ini[4545] = -1.0*y[158] + 1.0*y[162]
    sp_jac_ini[4546] = y[427]
    sp_jac_ini[4547] = 1.0*y[428]
    sp_jac_ini[4548] = -y[427]
    sp_jac_ini[4549] = -1.0*y[428]
    sp_jac_ini[4550] = y[160] - y[162]
    sp_jac_ini[4551] = 1.0*y[161] - 1.0*y[163]
    sp_jac_ini[4552] = -1.0*y[428]
    sp_jac_ini[4553] = 1.0*y[427]
    sp_jac_ini[4554] = 1.0*y[428]
    sp_jac_ini[4555] = -1.0*y[427]
    sp_jac_ini[4556] = 1.0*y[161] - 1.0*y[163]
    sp_jac_ini[4557] = -1.0*y[160] + 1.0*y[162]
    sp_jac_ini[4558] = -y[431]/(y[222] - y[228] + 1.0e-8)**2
    sp_jac_ini[4559] = y[431]/(y[222] - y[228] + 1.0e-8)**2
    sp_jac_ini[4561] = 1/(y[222] - y[228] + 1.0e-8)
    sp_jac_ini[4562] = y[431]/(-y[222] + y[228] + 1.0e-8)**2
    sp_jac_ini[4563] = -y[431]/(-y[222] + y[228] + 1.0e-8)**2
    sp_jac_ini[4565] = 1/(-y[222] + y[228] + 1.0e-8)
    sp_jac_ini[4567] = -Piecewise(np.array([(-1, y[431] < 0), (1, True)]))
    sp_jac_ini[4568] = -p[10]*y[423]/sqrt(y[424]**2 + y[423]**2 + 0.1) - 2*p[11]*y[423]
    sp_jac_ini[4569] = -p[10]*y[424]/sqrt(y[424]**2 + y[423]**2 + 0.1) - 2*p[11]*y[424]

@numba.njit(cache=True)
def sp_jac_ini_eval_up(sp_jac_ini,x,y,u,p,Dt,xyup = 1):

    sp_jac_ini[4467] = u[6]

def sp_jac_ini_eval_num(sp_jac_ini,x,y,u,p,Dt,xyup = 1):

    sp_jac_ini[0] = -1
    sp_jac_ini[1] = -123.954122254357
    sp_jac_ini[2] = -127.595184532966
    sp_jac_ini[3] = 39.6392229058202
    sp_jac_ini[4] = 10.2713736253513
    sp_jac_ini[5] = 24.9575997948692
    sp_jac_ini[6] = 23.2849644809540
    sp_jac_ini[7] = 58.0215758469966
    sp_jac_ini[8] = 83.8007853900572
    sp_jac_ini[9] = 105.571769313180
    sp_jac_ini[10] = 54.0657727682604
    sp_jac_ini[11] = -39.6392229058202
    sp_jac_ini[12] = -10.2713736253513
    sp_jac_ini[13] = -24.9575997948692
    sp_jac_ini[14] = -23.2849644809540
    sp_jac_ini[15] = -39.6392229058202
    sp_jac_ini[16] = -10.2713736253513
    sp_jac_ini[17] = 1
    sp_jac_ini[18] = 1
    sp_jac_ini[19] = 127.595184532966
    sp_jac_ini[20] = -123.954122254357
    sp_jac_ini[21] = -10.2713736253513
    sp_jac_ini[22] = 39.6392229058202
    sp_jac_ini[23] = -23.2849644809540
    sp_jac_ini[24] = 24.9575997948692
    sp_jac_ini[25] = -83.8007853900572
    sp_jac_ini[26] = 58.0215758469966
    sp_jac_ini[27] = -54.0657727682604
    sp_jac_ini[28] = 105.571769313180
    sp_jac_ini[29] = 10.2713736253513
    sp_jac_ini[30] = -39.6392229058202
    sp_jac_ini[31] = 23.2849644809540
    sp_jac_ini[32] = -24.9575997948692
    sp_jac_ini[33] = 10.2713736253513
    sp_jac_ini[34] = -39.6392229058202
    sp_jac_ini[35] = 1
    sp_jac_ini[36] = 1
    sp_jac_ini[37] = 39.6392229058202
    sp_jac_ini[38] = 10.2713736253513
    sp_jac_ini[39] = -123.954122254357
    sp_jac_ini[40] = -127.595184532966
    sp_jac_ini[41] = 39.6392229058201
    sp_jac_ini[42] = 10.2713736253513
    sp_jac_ini[43] = 43.3399527360457
    sp_jac_ini[44] = 96.8143762456598
    sp_jac_ini[45] = -39.6392229058202
    sp_jac_ini[46] = -10.2713736253513
    sp_jac_ini[47] = 105.571769313180
    sp_jac_ini[48] = 54.0657727682604
    sp_jac_ini[49] = -39.6392229058201
    sp_jac_ini[50] = -10.2713736253513
    sp_jac_ini[51] = -24.9575997948692
    sp_jac_ini[52] = -23.2849644809540
    sp_jac_ini[53] = 1
    sp_jac_ini[54] = 1
    sp_jac_ini[55] = -10.2713736253513
    sp_jac_ini[56] = 39.6392229058202
    sp_jac_ini[57] = 127.595184532966
    sp_jac_ini[58] = -123.954122254357
    sp_jac_ini[59] = -10.2713736253513
    sp_jac_ini[60] = 39.6392229058201
    sp_jac_ini[61] = -96.8143762456598
    sp_jac_ini[62] = 43.3399527360457
    sp_jac_ini[63] = 10.2713736253513
    sp_jac_ini[64] = -39.6392229058202
    sp_jac_ini[65] = -54.0657727682604
    sp_jac_ini[66] = 105.571769313180
    sp_jac_ini[67] = 10.2713736253513
    sp_jac_ini[68] = -39.6392229058201
    sp_jac_ini[69] = 23.2849644809540
    sp_jac_ini[70] = -24.9575997948692
    sp_jac_ini[71] = 1
    sp_jac_ini[72] = 1
    sp_jac_ini[73] = 24.9575997948692
    sp_jac_ini[74] = 23.2849644809540
    sp_jac_ini[75] = 39.6392229058202
    sp_jac_ini[76] = 10.2713736253513
    sp_jac_ini[77] = -123.954122254357
    sp_jac_ini[78] = -127.595184532966
    sp_jac_ini[79] = 58.0215758469966
    sp_jac_ini[80] = 83.8007853900572
    sp_jac_ini[81] = -24.9575997948692
    sp_jac_ini[82] = -23.2849644809540
    sp_jac_ini[83] = -39.6392229058202
    sp_jac_ini[84] = -10.2713736253513
    sp_jac_ini[85] = 105.571769313180
    sp_jac_ini[86] = 54.0657727682604
    sp_jac_ini[87] = -39.6392229058201
    sp_jac_ini[88] = -10.2713736253514
    sp_jac_ini[89] = 1
    sp_jac_ini[90] = 1
    sp_jac_ini[91] = -23.2849644809540
    sp_jac_ini[92] = 24.9575997948692
    sp_jac_ini[93] = -10.2713736253513
    sp_jac_ini[94] = 39.6392229058202
    sp_jac_ini[95] = 127.595184532966
    sp_jac_ini[96] = -123.954122254357
    sp_jac_ini[97] = -83.8007853900572
    sp_jac_ini[98] = 58.0215758469966
    sp_jac_ini[99] = 23.2849644809540
    sp_jac_ini[100] = -24.9575997948692
    sp_jac_ini[101] = 10.2713736253513
    sp_jac_ini[102] = -39.6392229058202
    sp_jac_ini[103] = -54.0657727682604
    sp_jac_ini[104] = 105.571769313180
    sp_jac_ini[105] = 10.2713736253514
    sp_jac_ini[106] = -39.6392229058201
    sp_jac_ini[107] = 1
    sp_jac_ini[108] = 1
    sp_jac_ini[109] = 58.0215758469966
    sp_jac_ini[110] = 83.8007853900572
    sp_jac_ini[111] = 43.3399527360457
    sp_jac_ini[112] = 96.8143762456598
    sp_jac_ini[113] = 58.0215758469966
    sp_jac_ini[114] = 83.8007853900572
    sp_jac_ini[115] = -161.052161470043
    sp_jac_ini[116] = -274.654008062378
    sp_jac_ini[117] = -39.6392229058202
    sp_jac_ini[118] = -10.2713736253513
    sp_jac_ini[119] = -24.9575997948692
    sp_jac_ini[120] = -23.2849644809540
    sp_jac_ini[121] = -39.6392229058202
    sp_jac_ini[122] = -10.2713736253513
    sp_jac_ini[123] = 105.571769313180
    sp_jac_ini[124] = 54.0657727682604
    sp_jac_ini[125] = -83.8007853900572
    sp_jac_ini[126] = 58.0215758469966
    sp_jac_ini[127] = -96.8143762456598
    sp_jac_ini[128] = 43.3399527360457
    sp_jac_ini[129] = -83.8007853900572
    sp_jac_ini[130] = 58.0215758469966
    sp_jac_ini[131] = 274.654008062378
    sp_jac_ini[132] = -161.052161470043
    sp_jac_ini[133] = 10.2713736253513
    sp_jac_ini[134] = -39.6392229058202
    sp_jac_ini[135] = 23.2849644809540
    sp_jac_ini[136] = -24.9575997948692
    sp_jac_ini[137] = 10.2713736253513
    sp_jac_ini[138] = -39.6392229058202
    sp_jac_ini[139] = -54.0657727682604
    sp_jac_ini[140] = 105.571769313180
    sp_jac_ini[141] = -26.5300693004806
    sp_jac_ini[142] = -4.84676915585801
    sp_jac_ini[143] = 7.89461337514770
    sp_jac_ini[144] = -1.58482814504483
    sp_jac_ini[145] = 7.72144347466701
    sp_jac_ini[146] = -0.679918453285310
    sp_jac_ini[147] = 7.89461337514771
    sp_jac_ini[148] = -1.58482814504483
    sp_jac_ini[149] = 26.5300693004806
    sp_jac_ini[150] = 4.84676915585801
    sp_jac_ini[151] = -7.89461337514770
    sp_jac_ini[152] = 1.58482814504483
    sp_jac_ini[153] = -7.72144347466701
    sp_jac_ini[154] = 0.679918453285310
    sp_jac_ini[155] = -7.89461337514771
    sp_jac_ini[156] = 1.58482814504483
    sp_jac_ini[157] = 1
    sp_jac_ini[158] = 4.84676915585801
    sp_jac_ini[159] = -26.5300693004806
    sp_jac_ini[160] = 1.58482814504483
    sp_jac_ini[161] = 7.89461337514770
    sp_jac_ini[162] = 0.679918453285310
    sp_jac_ini[163] = 7.72144347466701
    sp_jac_ini[164] = 1.58482814504483
    sp_jac_ini[165] = 7.89461337514771
    sp_jac_ini[166] = -4.84676915585801
    sp_jac_ini[167] = 26.5300693004806
    sp_jac_ini[168] = -1.58482814504483
    sp_jac_ini[169] = -7.89461337514770
    sp_jac_ini[170] = -0.679918453285310
    sp_jac_ini[171] = -7.72144347466701
    sp_jac_ini[172] = -1.58482814504483
    sp_jac_ini[173] = -7.89461337514771
    sp_jac_ini[174] = 1
    sp_jac_ini[175] = 7.89461337514771
    sp_jac_ini[176] = -1.58482814504483
    sp_jac_ini[177] = -26.5300693004806
    sp_jac_ini[178] = -4.84676915585801
    sp_jac_ini[179] = 7.89461337514771
    sp_jac_ini[180] = -1.58482814504483
    sp_jac_ini[181] = 7.72144347466701
    sp_jac_ini[182] = -0.679918453285308
    sp_jac_ini[183] = -7.89461337514771
    sp_jac_ini[184] = 1.58482814504483
    sp_jac_ini[185] = 26.5300693004806
    sp_jac_ini[186] = 4.84676915585801
    sp_jac_ini[187] = -7.89461337514771
    sp_jac_ini[188] = 1.58482814504483
    sp_jac_ini[189] = -7.72144347466701
    sp_jac_ini[190] = 0.679918453285308
    sp_jac_ini[191] = 1
    sp_jac_ini[192] = 1.58482814504483
    sp_jac_ini[193] = 7.89461337514771
    sp_jac_ini[194] = 4.84676915585801
    sp_jac_ini[195] = -26.5300693004806
    sp_jac_ini[196] = 1.58482814504483
    sp_jac_ini[197] = 7.89461337514771
    sp_jac_ini[198] = 0.679918453285308
    sp_jac_ini[199] = 7.72144347466701
    sp_jac_ini[200] = -1.58482814504483
    sp_jac_ini[201] = -7.89461337514771
    sp_jac_ini[202] = -4.84676915585801
    sp_jac_ini[203] = 26.5300693004806
    sp_jac_ini[204] = -1.58482814504483
    sp_jac_ini[205] = -7.89461337514771
    sp_jac_ini[206] = -0.679918453285308
    sp_jac_ini[207] = -7.72144347466701
    sp_jac_ini[208] = 1
    sp_jac_ini[209] = 7.72144347466701
    sp_jac_ini[210] = -0.679918453285310
    sp_jac_ini[211] = 7.89461337514770
    sp_jac_ini[212] = -1.58482814504483
    sp_jac_ini[213] = -26.5300693004806
    sp_jac_ini[214] = -4.84676915585801
    sp_jac_ini[215] = 7.89461337514771
    sp_jac_ini[216] = -1.58482814504483
    sp_jac_ini[217] = -7.72144347466701
    sp_jac_ini[218] = 0.679918453285310
    sp_jac_ini[219] = -7.89461337514770
    sp_jac_ini[220] = 1.58482814504483
    sp_jac_ini[221] = 26.5300693004806
    sp_jac_ini[222] = 4.84676915585801
    sp_jac_ini[223] = -7.89461337514771
    sp_jac_ini[224] = 1.58482814504483
    sp_jac_ini[225] = 1
    sp_jac_ini[226] = 0.679918453285310
    sp_jac_ini[227] = 7.72144347466701
    sp_jac_ini[228] = 1.58482814504483
    sp_jac_ini[229] = 7.89461337514770
    sp_jac_ini[230] = 4.84676915585801
    sp_jac_ini[231] = -26.5300693004806
    sp_jac_ini[232] = 1.58482814504483
    sp_jac_ini[233] = 7.89461337514771
    sp_jac_ini[234] = -0.679918453285310
    sp_jac_ini[235] = -7.72144347466701
    sp_jac_ini[236] = -1.58482814504483
    sp_jac_ini[237] = -7.89461337514770
    sp_jac_ini[238] = -4.84676915585801
    sp_jac_ini[239] = 26.5300693004806
    sp_jac_ini[240] = -1.58482814504483
    sp_jac_ini[241] = -7.89461337514771
    sp_jac_ini[242] = 1
    sp_jac_ini[243] = 7.89461337514771
    sp_jac_ini[244] = -1.58482814504483
    sp_jac_ini[245] = 7.72144347466701
    sp_jac_ini[246] = -0.679918453285308
    sp_jac_ini[247] = 7.89461337514771
    sp_jac_ini[248] = -1.58482814504483
    sp_jac_ini[249] = -26.5550693004806
    sp_jac_ini[250] = -4.84676915585801
    sp_jac_ini[251] = -7.89461337514771
    sp_jac_ini[252] = 1.58482814504483
    sp_jac_ini[253] = -7.72144347466701
    sp_jac_ini[254] = 0.679918453285308
    sp_jac_ini[255] = -7.89461337514771
    sp_jac_ini[256] = 1.58482814504483
    sp_jac_ini[257] = 26.5300693004806
    sp_jac_ini[258] = 4.84676915585801
    sp_jac_ini[259] = 1.58482814504483
    sp_jac_ini[260] = 7.89461337514771
    sp_jac_ini[261] = 0.679918453285308
    sp_jac_ini[262] = 7.72144347466701
    sp_jac_ini[263] = 1.58482814504483
    sp_jac_ini[264] = 7.89461337514771
    sp_jac_ini[265] = 4.84676915585801
    sp_jac_ini[266] = -26.5550693004806
    sp_jac_ini[267] = -1.58482814504483
    sp_jac_ini[268] = -7.89461337514771
    sp_jac_ini[269] = -0.679918453285308
    sp_jac_ini[270] = -7.72144347466701
    sp_jac_ini[271] = -1.58482814504483
    sp_jac_ini[272] = -7.89461337514771
    sp_jac_ini[273] = -4.84676915585801
    sp_jac_ini[274] = 26.5300693004806
    sp_jac_ini[275] = -26.5300693004806
    sp_jac_ini[276] = -4.84676915585801
    sp_jac_ini[277] = 7.89461337514770
    sp_jac_ini[278] = -1.58482814504483
    sp_jac_ini[279] = 7.72144347466701
    sp_jac_ini[280] = -0.679918453285310
    sp_jac_ini[281] = 7.89461337514771
    sp_jac_ini[282] = -1.58482814504483
    sp_jac_ini[283] = 26.5300693004806
    sp_jac_ini[284] = 4.84676915585801
    sp_jac_ini[285] = -7.89461337514770
    sp_jac_ini[286] = 1.58482814504483
    sp_jac_ini[287] = -7.72144347466701
    sp_jac_ini[288] = 0.679918453285310
    sp_jac_ini[289] = -7.89461337514771
    sp_jac_ini[290] = 1.58482814504483
    sp_jac_ini[291] = 1
    sp_jac_ini[292] = 4.84676915585801
    sp_jac_ini[293] = -26.5300693004806
    sp_jac_ini[294] = 1.58482814504483
    sp_jac_ini[295] = 7.89461337514770
    sp_jac_ini[296] = 0.679918453285310
    sp_jac_ini[297] = 7.72144347466701
    sp_jac_ini[298] = 1.58482814504483
    sp_jac_ini[299] = 7.89461337514771
    sp_jac_ini[300] = -4.84676915585801
    sp_jac_ini[301] = 26.5300693004806
    sp_jac_ini[302] = -1.58482814504483
    sp_jac_ini[303] = -7.89461337514770
    sp_jac_ini[304] = -0.679918453285310
    sp_jac_ini[305] = -7.72144347466701
    sp_jac_ini[306] = -1.58482814504483
    sp_jac_ini[307] = -7.89461337514771
    sp_jac_ini[308] = 1
    sp_jac_ini[309] = 7.89461337514771
    sp_jac_ini[310] = -1.58482814504483
    sp_jac_ini[311] = -26.5300693004806
    sp_jac_ini[312] = -4.84676915585801
    sp_jac_ini[313] = 7.89461337514771
    sp_jac_ini[314] = -1.58482814504483
    sp_jac_ini[315] = 7.72144347466701
    sp_jac_ini[316] = -0.679918453285308
    sp_jac_ini[317] = -7.89461337514771
    sp_jac_ini[318] = 1.58482814504483
    sp_jac_ini[319] = 26.5300693004806
    sp_jac_ini[320] = 4.84676915585801
    sp_jac_ini[321] = -7.89461337514771
    sp_jac_ini[322] = 1.58482814504483
    sp_jac_ini[323] = -7.72144347466701
    sp_jac_ini[324] = 0.679918453285308
    sp_jac_ini[325] = 1
    sp_jac_ini[326] = 1.58482814504483
    sp_jac_ini[327] = 7.89461337514771
    sp_jac_ini[328] = 4.84676915585801
    sp_jac_ini[329] = -26.5300693004806
    sp_jac_ini[330] = 1.58482814504483
    sp_jac_ini[331] = 7.89461337514771
    sp_jac_ini[332] = 0.679918453285308
    sp_jac_ini[333] = 7.72144347466701
    sp_jac_ini[334] = -1.58482814504483
    sp_jac_ini[335] = -7.89461337514771
    sp_jac_ini[336] = -4.84676915585801
    sp_jac_ini[337] = 26.5300693004806
    sp_jac_ini[338] = -1.58482814504483
    sp_jac_ini[339] = -7.89461337514771
    sp_jac_ini[340] = -0.679918453285308
    sp_jac_ini[341] = -7.72144347466701
    sp_jac_ini[342] = 1
    sp_jac_ini[343] = 7.72144347466701
    sp_jac_ini[344] = -0.679918453285310
    sp_jac_ini[345] = 7.89461337514770
    sp_jac_ini[346] = -1.58482814504483
    sp_jac_ini[347] = -26.5300693004806
    sp_jac_ini[348] = -4.84676915585801
    sp_jac_ini[349] = 7.89461337514771
    sp_jac_ini[350] = -1.58482814504483
    sp_jac_ini[351] = -7.72144347466701
    sp_jac_ini[352] = 0.679918453285310
    sp_jac_ini[353] = -7.89461337514770
    sp_jac_ini[354] = 1.58482814504483
    sp_jac_ini[355] = 26.5300693004806
    sp_jac_ini[356] = 4.84676915585801
    sp_jac_ini[357] = -7.89461337514771
    sp_jac_ini[358] = 1.58482814504483
    sp_jac_ini[359] = 1
    sp_jac_ini[360] = 0.679918453285310
    sp_jac_ini[361] = 7.72144347466701
    sp_jac_ini[362] = 1.58482814504483
    sp_jac_ini[363] = 7.89461337514770
    sp_jac_ini[364] = 4.84676915585801
    sp_jac_ini[365] = -26.5300693004806
    sp_jac_ini[366] = 1.58482814504483
    sp_jac_ini[367] = 7.89461337514771
    sp_jac_ini[368] = -0.679918453285310
    sp_jac_ini[369] = -7.72144347466701
    sp_jac_ini[370] = -1.58482814504483
    sp_jac_ini[371] = -7.89461337514770
    sp_jac_ini[372] = -4.84676915585801
    sp_jac_ini[373] = 26.5300693004806
    sp_jac_ini[374] = -1.58482814504483
    sp_jac_ini[375] = -7.89461337514771
    sp_jac_ini[376] = 1
    sp_jac_ini[377] = 7.89461337514771
    sp_jac_ini[378] = -1.58482814504483
    sp_jac_ini[379] = 7.72144347466701
    sp_jac_ini[380] = -0.679918453285308
    sp_jac_ini[381] = 7.89461337514771
    sp_jac_ini[382] = -1.58482814504483
    sp_jac_ini[383] = -26.5550693004806
    sp_jac_ini[384] = -4.84676915585801
    sp_jac_ini[385] = -7.89461337514771
    sp_jac_ini[386] = 1.58482814504483
    sp_jac_ini[387] = -7.72144347466701
    sp_jac_ini[388] = 0.679918453285308
    sp_jac_ini[389] = -7.89461337514771
    sp_jac_ini[390] = 1.58482814504483
    sp_jac_ini[391] = 26.5300693004806
    sp_jac_ini[392] = 4.84676915585801
    sp_jac_ini[393] = 1.58482814504483
    sp_jac_ini[394] = 7.89461337514771
    sp_jac_ini[395] = 0.679918453285308
    sp_jac_ini[396] = 7.72144347466701
    sp_jac_ini[397] = 1.58482814504483
    sp_jac_ini[398] = 7.89461337514771
    sp_jac_ini[399] = 4.84676915585801
    sp_jac_ini[400] = -26.5550693004806
    sp_jac_ini[401] = -1.58482814504483
    sp_jac_ini[402] = -7.89461337514771
    sp_jac_ini[403] = -0.679918453285308
    sp_jac_ini[404] = -7.72144347466701
    sp_jac_ini[405] = -1.58482814504483
    sp_jac_ini[406] = -7.89461337514771
    sp_jac_ini[407] = -4.84676915585801
    sp_jac_ini[408] = 26.5300693004806
    sp_jac_ini[409] = -30.9517475172273
    sp_jac_ini[410] = -5.65456401516768
    sp_jac_ini[411] = 9.21038227100566
    sp_jac_ini[412] = -1.84896616921897
    sp_jac_ini[413] = 9.00835072044485
    sp_jac_ini[414] = -0.793238195499529
    sp_jac_ini[415] = 9.21038227100566
    sp_jac_ini[416] = -1.84896616921897
    sp_jac_ini[417] = 30.9517475172273
    sp_jac_ini[418] = 5.65456401516768
    sp_jac_ini[419] = -9.21038227100566
    sp_jac_ini[420] = 1.84896616921897
    sp_jac_ini[421] = -9.00835072044485
    sp_jac_ini[422] = 0.793238195499529
    sp_jac_ini[423] = -9.21038227100566
    sp_jac_ini[424] = 1.84896616921897
    sp_jac_ini[425] = 1
    sp_jac_ini[426] = 5.65456401516768
    sp_jac_ini[427] = -30.9517475172273
    sp_jac_ini[428] = 1.84896616921897
    sp_jac_ini[429] = 9.21038227100566
    sp_jac_ini[430] = 0.793238195499529
    sp_jac_ini[431] = 9.00835072044485
    sp_jac_ini[432] = 1.84896616921897
    sp_jac_ini[433] = 9.21038227100566
    sp_jac_ini[434] = -5.65456401516768
    sp_jac_ini[435] = 30.9517475172273
    sp_jac_ini[436] = -1.84896616921897
    sp_jac_ini[437] = -9.21038227100566
    sp_jac_ini[438] = -0.793238195499529
    sp_jac_ini[439] = -9.00835072044485
    sp_jac_ini[440] = -1.84896616921897
    sp_jac_ini[441] = -9.21038227100566
    sp_jac_ini[442] = 1
    sp_jac_ini[443] = 9.21038227100566
    sp_jac_ini[444] = -1.84896616921897
    sp_jac_ini[445] = -30.9517475172273
    sp_jac_ini[446] = -5.65456401516768
    sp_jac_ini[447] = 9.21038227100566
    sp_jac_ini[448] = -1.84896616921897
    sp_jac_ini[449] = 9.00835072044485
    sp_jac_ini[450] = -0.793238195499528
    sp_jac_ini[451] = -9.21038227100566
    sp_jac_ini[452] = 1.84896616921897
    sp_jac_ini[453] = 30.9517475172273
    sp_jac_ini[454] = 5.65456401516768
    sp_jac_ini[455] = -9.21038227100566
    sp_jac_ini[456] = 1.84896616921897
    sp_jac_ini[457] = -9.00835072044485
    sp_jac_ini[458] = 0.793238195499528
    sp_jac_ini[459] = 1
    sp_jac_ini[460] = 1.84896616921897
    sp_jac_ini[461] = 9.21038227100566
    sp_jac_ini[462] = 5.65456401516768
    sp_jac_ini[463] = -30.9517475172273
    sp_jac_ini[464] = 1.84896616921897
    sp_jac_ini[465] = 9.21038227100566
    sp_jac_ini[466] = 0.793238195499528
    sp_jac_ini[467] = 9.00835072044485
    sp_jac_ini[468] = -1.84896616921897
    sp_jac_ini[469] = -9.21038227100566
    sp_jac_ini[470] = -5.65456401516768
    sp_jac_ini[471] = 30.9517475172273
    sp_jac_ini[472] = -1.84896616921897
    sp_jac_ini[473] = -9.21038227100566
    sp_jac_ini[474] = -0.793238195499528
    sp_jac_ini[475] = -9.00835072044485
    sp_jac_ini[476] = 1
    sp_jac_ini[477] = 9.00835072044484
    sp_jac_ini[478] = -0.793238195499527
    sp_jac_ini[479] = 9.21038227100566
    sp_jac_ini[480] = -1.84896616921897
    sp_jac_ini[481] = -30.9517475172273
    sp_jac_ini[482] = -5.65456401516768
    sp_jac_ini[483] = 9.21038227100566
    sp_jac_ini[484] = -1.84896616921897
    sp_jac_ini[485] = -9.00835072044484
    sp_jac_ini[486] = 0.793238195499527
    sp_jac_ini[487] = -9.21038227100566
    sp_jac_ini[488] = 1.84896616921897
    sp_jac_ini[489] = 30.9517475172273
    sp_jac_ini[490] = 5.65456401516768
    sp_jac_ini[491] = -9.21038227100566
    sp_jac_ini[492] = 1.84896616921897
    sp_jac_ini[493] = 1
    sp_jac_ini[494] = 0.793238195499527
    sp_jac_ini[495] = 9.00835072044484
    sp_jac_ini[496] = 1.84896616921897
    sp_jac_ini[497] = 9.21038227100566
    sp_jac_ini[498] = 5.65456401516768
    sp_jac_ini[499] = -30.9517475172273
    sp_jac_ini[500] = 1.84896616921897
    sp_jac_ini[501] = 9.21038227100566
    sp_jac_ini[502] = -0.793238195499527
    sp_jac_ini[503] = -9.00835072044484
    sp_jac_ini[504] = -1.84896616921897
    sp_jac_ini[505] = -9.21038227100566
    sp_jac_ini[506] = -5.65456401516768
    sp_jac_ini[507] = 30.9517475172273
    sp_jac_ini[508] = -1.84896616921897
    sp_jac_ini[509] = -9.21038227100566
    sp_jac_ini[510] = 1
    sp_jac_ini[511] = 9.21038227100566
    sp_jac_ini[512] = -1.84896616921897
    sp_jac_ini[513] = 9.00835072044485
    sp_jac_ini[514] = -0.793238195499527
    sp_jac_ini[515] = 9.21038227100566
    sp_jac_ini[516] = -1.84896616921897
    sp_jac_ini[517] = -30.9767475172273
    sp_jac_ini[518] = -5.65456401516768
    sp_jac_ini[519] = -9.21038227100566
    sp_jac_ini[520] = 1.84896616921897
    sp_jac_ini[521] = -9.00835072044485
    sp_jac_ini[522] = 0.793238195499527
    sp_jac_ini[523] = -9.21038227100566
    sp_jac_ini[524] = 1.84896616921897
    sp_jac_ini[525] = 30.9517475172273
    sp_jac_ini[526] = 5.65456401516768
    sp_jac_ini[527] = 1.84896616921897
    sp_jac_ini[528] = 9.21038227100566
    sp_jac_ini[529] = 0.793238195499527
    sp_jac_ini[530] = 9.00835072044485
    sp_jac_ini[531] = 1.84896616921897
    sp_jac_ini[532] = 9.21038227100566
    sp_jac_ini[533] = 5.65456401516768
    sp_jac_ini[534] = -30.9767475172273
    sp_jac_ini[535] = -1.84896616921897
    sp_jac_ini[536] = -9.21038227100566
    sp_jac_ini[537] = -0.793238195499527
    sp_jac_ini[538] = -9.00835072044485
    sp_jac_ini[539] = -1.84896616921897
    sp_jac_ini[540] = -9.21038227100566
    sp_jac_ini[541] = -5.65456401516768
    sp_jac_ini[542] = 30.9517475172273
    sp_jac_ini[543] = -30.9517475172273
    sp_jac_ini[544] = -5.65456401516768
    sp_jac_ini[545] = 9.21038227100566
    sp_jac_ini[546] = -1.84896616921897
    sp_jac_ini[547] = 9.00835072044485
    sp_jac_ini[548] = -0.793238195499529
    sp_jac_ini[549] = 9.21038227100566
    sp_jac_ini[550] = -1.84896616921897
    sp_jac_ini[551] = 30.9517475172273
    sp_jac_ini[552] = 5.65456401516768
    sp_jac_ini[553] = -9.21038227100566
    sp_jac_ini[554] = 1.84896616921897
    sp_jac_ini[555] = -9.00835072044485
    sp_jac_ini[556] = 0.793238195499529
    sp_jac_ini[557] = -9.21038227100566
    sp_jac_ini[558] = 1.84896616921897
    sp_jac_ini[559] = 1
    sp_jac_ini[560] = 5.65456401516768
    sp_jac_ini[561] = -30.9517475172273
    sp_jac_ini[562] = 1.84896616921897
    sp_jac_ini[563] = 9.21038227100566
    sp_jac_ini[564] = 0.793238195499529
    sp_jac_ini[565] = 9.00835072044485
    sp_jac_ini[566] = 1.84896616921897
    sp_jac_ini[567] = 9.21038227100566
    sp_jac_ini[568] = -5.65456401516768
    sp_jac_ini[569] = 30.9517475172273
    sp_jac_ini[570] = -1.84896616921897
    sp_jac_ini[571] = -9.21038227100566
    sp_jac_ini[572] = -0.793238195499529
    sp_jac_ini[573] = -9.00835072044485
    sp_jac_ini[574] = -1.84896616921897
    sp_jac_ini[575] = -9.21038227100566
    sp_jac_ini[576] = 1
    sp_jac_ini[577] = 9.21038227100566
    sp_jac_ini[578] = -1.84896616921897
    sp_jac_ini[579] = -30.9517475172273
    sp_jac_ini[580] = -5.65456401516768
    sp_jac_ini[581] = 9.21038227100566
    sp_jac_ini[582] = -1.84896616921897
    sp_jac_ini[583] = 9.00835072044485
    sp_jac_ini[584] = -0.793238195499528
    sp_jac_ini[585] = -9.21038227100566
    sp_jac_ini[586] = 1.84896616921897
    sp_jac_ini[587] = 30.9517475172273
    sp_jac_ini[588] = 5.65456401516768
    sp_jac_ini[589] = -9.21038227100566
    sp_jac_ini[590] = 1.84896616921897
    sp_jac_ini[591] = -9.00835072044485
    sp_jac_ini[592] = 0.793238195499528
    sp_jac_ini[593] = 1
    sp_jac_ini[594] = 1.84896616921897
    sp_jac_ini[595] = 9.21038227100566
    sp_jac_ini[596] = 5.65456401516768
    sp_jac_ini[597] = -30.9517475172273
    sp_jac_ini[598] = 1.84896616921897
    sp_jac_ini[599] = 9.21038227100566
    sp_jac_ini[600] = 0.793238195499528
    sp_jac_ini[601] = 9.00835072044485
    sp_jac_ini[602] = -1.84896616921897
    sp_jac_ini[603] = -9.21038227100566
    sp_jac_ini[604] = -5.65456401516768
    sp_jac_ini[605] = 30.9517475172273
    sp_jac_ini[606] = -1.84896616921897
    sp_jac_ini[607] = -9.21038227100566
    sp_jac_ini[608] = -0.793238195499528
    sp_jac_ini[609] = -9.00835072044485
    sp_jac_ini[610] = 1
    sp_jac_ini[611] = 9.00835072044484
    sp_jac_ini[612] = -0.793238195499527
    sp_jac_ini[613] = 9.21038227100566
    sp_jac_ini[614] = -1.84896616921897
    sp_jac_ini[615] = -30.9517475172273
    sp_jac_ini[616] = -5.65456401516768
    sp_jac_ini[617] = 9.21038227100566
    sp_jac_ini[618] = -1.84896616921897
    sp_jac_ini[619] = -9.00835072044484
    sp_jac_ini[620] = 0.793238195499527
    sp_jac_ini[621] = -9.21038227100566
    sp_jac_ini[622] = 1.84896616921897
    sp_jac_ini[623] = 30.9517475172273
    sp_jac_ini[624] = 5.65456401516768
    sp_jac_ini[625] = -9.21038227100566
    sp_jac_ini[626] = 1.84896616921897
    sp_jac_ini[627] = 1
    sp_jac_ini[628] = 0.793238195499527
    sp_jac_ini[629] = 9.00835072044484
    sp_jac_ini[630] = 1.84896616921897
    sp_jac_ini[631] = 9.21038227100566
    sp_jac_ini[632] = 5.65456401516768
    sp_jac_ini[633] = -30.9517475172273
    sp_jac_ini[634] = 1.84896616921897
    sp_jac_ini[635] = 9.21038227100566
    sp_jac_ini[636] = -0.793238195499527
    sp_jac_ini[637] = -9.00835072044484
    sp_jac_ini[638] = -1.84896616921897
    sp_jac_ini[639] = -9.21038227100566
    sp_jac_ini[640] = -5.65456401516768
    sp_jac_ini[641] = 30.9517475172273
    sp_jac_ini[642] = -1.84896616921897
    sp_jac_ini[643] = -9.21038227100566
    sp_jac_ini[644] = 1
    sp_jac_ini[645] = 9.21038227100566
    sp_jac_ini[646] = -1.84896616921897
    sp_jac_ini[647] = 9.00835072044485
    sp_jac_ini[648] = -0.793238195499527
    sp_jac_ini[649] = 9.21038227100566
    sp_jac_ini[650] = -1.84896616921897
    sp_jac_ini[651] = -30.9767475172273
    sp_jac_ini[652] = -5.65456401516768
    sp_jac_ini[653] = -9.21038227100566
    sp_jac_ini[654] = 1.84896616921897
    sp_jac_ini[655] = -9.00835072044485
    sp_jac_ini[656] = 0.793238195499527
    sp_jac_ini[657] = -9.21038227100566
    sp_jac_ini[658] = 1.84896616921897
    sp_jac_ini[659] = 30.9517475172273
    sp_jac_ini[660] = 5.65456401516768
    sp_jac_ini[661] = 1.84896616921897
    sp_jac_ini[662] = 9.21038227100566
    sp_jac_ini[663] = 0.793238195499527
    sp_jac_ini[664] = 9.00835072044485
    sp_jac_ini[665] = 1.84896616921897
    sp_jac_ini[666] = 9.21038227100566
    sp_jac_ini[667] = 5.65456401516768
    sp_jac_ini[668] = -30.9767475172273
    sp_jac_ini[669] = -1.84896616921897
    sp_jac_ini[670] = -9.21038227100566
    sp_jac_ini[671] = -0.793238195499527
    sp_jac_ini[672] = -9.00835072044485
    sp_jac_ini[673] = -1.84896616921897
    sp_jac_ini[674] = -9.21038227100566
    sp_jac_ini[675] = -5.65456401516768
    sp_jac_ini[676] = 30.9517475172273
    sp_jac_ini[677] = -30.9517475172273
    sp_jac_ini[678] = -5.65456401516768
    sp_jac_ini[679] = 9.21038227100566
    sp_jac_ini[680] = -1.84896616921897
    sp_jac_ini[681] = 9.00835072044485
    sp_jac_ini[682] = -0.793238195499529
    sp_jac_ini[683] = 9.21038227100566
    sp_jac_ini[684] = -1.84896616921897
    sp_jac_ini[685] = 30.9517475172273
    sp_jac_ini[686] = 5.65456401516768
    sp_jac_ini[687] = -9.21038227100566
    sp_jac_ini[688] = 1.84896616921897
    sp_jac_ini[689] = -9.00835072044485
    sp_jac_ini[690] = 0.793238195499529
    sp_jac_ini[691] = -9.21038227100566
    sp_jac_ini[692] = 1.84896616921897
    sp_jac_ini[693] = 1
    sp_jac_ini[694] = 5.65456401516768
    sp_jac_ini[695] = -30.9517475172273
    sp_jac_ini[696] = 1.84896616921897
    sp_jac_ini[697] = 9.21038227100566
    sp_jac_ini[698] = 0.793238195499529
    sp_jac_ini[699] = 9.00835072044485
    sp_jac_ini[700] = 1.84896616921897
    sp_jac_ini[701] = 9.21038227100566
    sp_jac_ini[702] = -5.65456401516768
    sp_jac_ini[703] = 30.9517475172273
    sp_jac_ini[704] = -1.84896616921897
    sp_jac_ini[705] = -9.21038227100566
    sp_jac_ini[706] = -0.793238195499529
    sp_jac_ini[707] = -9.00835072044485
    sp_jac_ini[708] = -1.84896616921897
    sp_jac_ini[709] = -9.21038227100566
    sp_jac_ini[710] = 1
    sp_jac_ini[711] = 9.21038227100566
    sp_jac_ini[712] = -1.84896616921897
    sp_jac_ini[713] = -30.9517475172273
    sp_jac_ini[714] = -5.65456401516768
    sp_jac_ini[715] = 9.21038227100566
    sp_jac_ini[716] = -1.84896616921897
    sp_jac_ini[717] = 9.00835072044485
    sp_jac_ini[718] = -0.793238195499528
    sp_jac_ini[719] = -9.21038227100566
    sp_jac_ini[720] = 1.84896616921897
    sp_jac_ini[721] = 30.9517475172273
    sp_jac_ini[722] = 5.65456401516768
    sp_jac_ini[723] = -9.21038227100566
    sp_jac_ini[724] = 1.84896616921897
    sp_jac_ini[725] = -9.00835072044485
    sp_jac_ini[726] = 0.793238195499528
    sp_jac_ini[727] = 1
    sp_jac_ini[728] = 1.84896616921897
    sp_jac_ini[729] = 9.21038227100566
    sp_jac_ini[730] = 5.65456401516768
    sp_jac_ini[731] = -30.9517475172273
    sp_jac_ini[732] = 1.84896616921897
    sp_jac_ini[733] = 9.21038227100566
    sp_jac_ini[734] = 0.793238195499528
    sp_jac_ini[735] = 9.00835072044485
    sp_jac_ini[736] = -1.84896616921897
    sp_jac_ini[737] = -9.21038227100566
    sp_jac_ini[738] = -5.65456401516768
    sp_jac_ini[739] = 30.9517475172273
    sp_jac_ini[740] = -1.84896616921897
    sp_jac_ini[741] = -9.21038227100566
    sp_jac_ini[742] = -0.793238195499528
    sp_jac_ini[743] = -9.00835072044485
    sp_jac_ini[744] = 1
    sp_jac_ini[745] = 9.00835072044484
    sp_jac_ini[746] = -0.793238195499527
    sp_jac_ini[747] = 9.21038227100566
    sp_jac_ini[748] = -1.84896616921897
    sp_jac_ini[749] = -30.9517475172273
    sp_jac_ini[750] = -5.65456401516768
    sp_jac_ini[751] = 9.21038227100566
    sp_jac_ini[752] = -1.84896616921897
    sp_jac_ini[753] = -9.00835072044484
    sp_jac_ini[754] = 0.793238195499527
    sp_jac_ini[755] = -9.21038227100566
    sp_jac_ini[756] = 1.84896616921897
    sp_jac_ini[757] = 30.9517475172273
    sp_jac_ini[758] = 5.65456401516768
    sp_jac_ini[759] = -9.21038227100566
    sp_jac_ini[760] = 1.84896616921897
    sp_jac_ini[761] = 1
    sp_jac_ini[762] = 0.793238195499527
    sp_jac_ini[763] = 9.00835072044484
    sp_jac_ini[764] = 1.84896616921897
    sp_jac_ini[765] = 9.21038227100566
    sp_jac_ini[766] = 5.65456401516768
    sp_jac_ini[767] = -30.9517475172273
    sp_jac_ini[768] = 1.84896616921897
    sp_jac_ini[769] = 9.21038227100566
    sp_jac_ini[770] = -0.793238195499527
    sp_jac_ini[771] = -9.00835072044484
    sp_jac_ini[772] = -1.84896616921897
    sp_jac_ini[773] = -9.21038227100566
    sp_jac_ini[774] = -5.65456401516768
    sp_jac_ini[775] = 30.9517475172273
    sp_jac_ini[776] = -1.84896616921897
    sp_jac_ini[777] = -9.21038227100566
    sp_jac_ini[778] = 1
    sp_jac_ini[779] = 9.21038227100566
    sp_jac_ini[780] = -1.84896616921897
    sp_jac_ini[781] = 9.00835072044485
    sp_jac_ini[782] = -0.793238195499527
    sp_jac_ini[783] = 9.21038227100566
    sp_jac_ini[784] = -1.84896616921897
    sp_jac_ini[785] = -30.9767475172273
    sp_jac_ini[786] = -5.65456401516768
    sp_jac_ini[787] = -9.21038227100566
    sp_jac_ini[788] = 1.84896616921897
    sp_jac_ini[789] = -9.00835072044485
    sp_jac_ini[790] = 0.793238195499527
    sp_jac_ini[791] = -9.21038227100566
    sp_jac_ini[792] = 1.84896616921897
    sp_jac_ini[793] = 30.9517475172273
    sp_jac_ini[794] = 5.65456401516768
    sp_jac_ini[795] = 1.84896616921897
    sp_jac_ini[796] = 9.21038227100566
    sp_jac_ini[797] = 0.793238195499527
    sp_jac_ini[798] = 9.00835072044485
    sp_jac_ini[799] = 1.84896616921897
    sp_jac_ini[800] = 9.21038227100566
    sp_jac_ini[801] = 5.65456401516768
    sp_jac_ini[802] = -30.9767475172273
    sp_jac_ini[803] = -1.84896616921897
    sp_jac_ini[804] = -9.21038227100566
    sp_jac_ini[805] = -0.793238195499527
    sp_jac_ini[806] = -9.00835072044485
    sp_jac_ini[807] = -1.84896616921897
    sp_jac_ini[808] = -9.21038227100566
    sp_jac_ini[809] = -5.65456401516768
    sp_jac_ini[810] = 30.9517475172273
    sp_jac_ini[811] = -135.409614082600
    sp_jac_ini[812] = 135.409614082600
    sp_jac_ini[813] = 1
    sp_jac_ini[814] = -135.409614082600
    sp_jac_ini[815] = 135.409614082600
    sp_jac_ini[816] = 1
    sp_jac_ini[817] = -135.409614082600
    sp_jac_ini[818] = 135.409614082600
    sp_jac_ini[819] = 1
    sp_jac_ini[820] = -135.409614082600
    sp_jac_ini[821] = 135.409614082600
    sp_jac_ini[822] = 1
    sp_jac_ini[823] = -157.977883096366
    sp_jac_ini[824] = 157.977883096366
    sp_jac_ini[825] = 1
    sp_jac_ini[826] = -157.977883096366
    sp_jac_ini[827] = 157.977883096366
    sp_jac_ini[828] = 1
    sp_jac_ini[829] = -157.977883096366
    sp_jac_ini[830] = 157.977883096366
    sp_jac_ini[831] = 1
    sp_jac_ini[832] = -157.977883096366
    sp_jac_ini[833] = 157.977883096366
    sp_jac_ini[834] = 1
    sp_jac_ini[835] = -157.977883096366
    sp_jac_ini[836] = 157.977883096366
    sp_jac_ini[837] = 1
    sp_jac_ini[838] = -157.977883096366
    sp_jac_ini[839] = 157.977883096366
    sp_jac_ini[840] = 1
    sp_jac_ini[841] = -157.977883096366
    sp_jac_ini[842] = 157.977883096366
    sp_jac_ini[843] = 1
    sp_jac_ini[844] = -157.977883096366
    sp_jac_ini[845] = 157.977883096366
    sp_jac_ini[846] = 1
    sp_jac_ini[847] = -157.977883096366
    sp_jac_ini[848] = 157.977883096366
    sp_jac_ini[849] = 1
    sp_jac_ini[850] = -157.977883096366
    sp_jac_ini[851] = 157.977883096366
    sp_jac_ini[852] = 1
    sp_jac_ini[853] = -157.977883096366
    sp_jac_ini[854] = 157.977883096366
    sp_jac_ini[855] = 1
    sp_jac_ini[856] = -157.977883096366
    sp_jac_ini[857] = 157.977883096366
    sp_jac_ini[858] = 1
    sp_jac_ini[859] = -157.977883096366
    sp_jac_ini[860] = 157.977883096366
    sp_jac_ini[861] = 1
    sp_jac_ini[862] = -157.977883096366
    sp_jac_ini[863] = 157.977883096366
    sp_jac_ini[864] = 1
    sp_jac_ini[865] = -157.977883096366
    sp_jac_ini[866] = 157.977883096366
    sp_jac_ini[867] = 1
    sp_jac_ini[868] = -157.977883096366
    sp_jac_ini[869] = 157.977883096366
    sp_jac_ini[870] = 1
    sp_jac_ini[871] = 105.571769313180
    sp_jac_ini[872] = 54.0657727682604
    sp_jac_ini[873] = -39.6392229058202
    sp_jac_ini[874] = -10.2713736253513
    sp_jac_ini[875] = -24.9575997948692
    sp_jac_ini[876] = -23.2849644809540
    sp_jac_ini[877] = -39.6392229058202
    sp_jac_ini[878] = -10.2713736253513
    sp_jac_ini[879] = -211.143538626360
    sp_jac_ini[880] = -108.131545536521
    sp_jac_ini[881] = 79.2784458116403
    sp_jac_ini[882] = 20.5427472507027
    sp_jac_ini[883] = 49.9151995897384
    sp_jac_ini[884] = 46.5699289619080
    sp_jac_ini[885] = 79.2784458116403
    sp_jac_ini[886] = 20.5427472507027
    sp_jac_ini[887] = 105.571769313180
    sp_jac_ini[888] = 54.0657727682604
    sp_jac_ini[889] = -39.6392229058202
    sp_jac_ini[890] = -10.2713736253513
    sp_jac_ini[891] = -24.9575997948692
    sp_jac_ini[892] = -23.2849644809540
    sp_jac_ini[893] = -39.6392229058202
    sp_jac_ini[894] = -10.2713736253513
    sp_jac_ini[895] = -54.0657727682604
    sp_jac_ini[896] = 105.571769313180
    sp_jac_ini[897] = 10.2713736253513
    sp_jac_ini[898] = -39.6392229058202
    sp_jac_ini[899] = 23.2849644809540
    sp_jac_ini[900] = -24.9575997948692
    sp_jac_ini[901] = 10.2713736253513
    sp_jac_ini[902] = -39.6392229058202
    sp_jac_ini[903] = 108.131545536521
    sp_jac_ini[904] = -211.143538626360
    sp_jac_ini[905] = -20.5427472507027
    sp_jac_ini[906] = 79.2784458116403
    sp_jac_ini[907] = -46.5699289619080
    sp_jac_ini[908] = 49.9151995897384
    sp_jac_ini[909] = -20.5427472507027
    sp_jac_ini[910] = 79.2784458116403
    sp_jac_ini[911] = -54.0657727682604
    sp_jac_ini[912] = 105.571769313180
    sp_jac_ini[913] = 10.2713736253513
    sp_jac_ini[914] = -39.6392229058202
    sp_jac_ini[915] = 23.2849644809540
    sp_jac_ini[916] = -24.9575997948692
    sp_jac_ini[917] = 10.2713736253513
    sp_jac_ini[918] = -39.6392229058202
    sp_jac_ini[919] = -39.6392229058202
    sp_jac_ini[920] = -10.2713736253513
    sp_jac_ini[921] = 105.571769313180
    sp_jac_ini[922] = 54.0657727682604
    sp_jac_ini[923] = -39.6392229058201
    sp_jac_ini[924] = -10.2713736253513
    sp_jac_ini[925] = -24.9575997948692
    sp_jac_ini[926] = -23.2849644809540
    sp_jac_ini[927] = 79.2784458116403
    sp_jac_ini[928] = 20.5427472507027
    sp_jac_ini[929] = -211.143538626360
    sp_jac_ini[930] = -108.131545536521
    sp_jac_ini[931] = 79.2784458116403
    sp_jac_ini[932] = 20.5427472507027
    sp_jac_ini[933] = 49.9151995897384
    sp_jac_ini[934] = 46.5699289619080
    sp_jac_ini[935] = -39.6392229058202
    sp_jac_ini[936] = -10.2713736253513
    sp_jac_ini[937] = 105.571769313180
    sp_jac_ini[938] = 54.0657727682604
    sp_jac_ini[939] = -39.6392229058201
    sp_jac_ini[940] = -10.2713736253513
    sp_jac_ini[941] = -24.9575997948692
    sp_jac_ini[942] = -23.2849644809540
    sp_jac_ini[943] = 10.2713736253513
    sp_jac_ini[944] = -39.6392229058202
    sp_jac_ini[945] = -54.0657727682604
    sp_jac_ini[946] = 105.571769313180
    sp_jac_ini[947] = 10.2713736253513
    sp_jac_ini[948] = -39.6392229058201
    sp_jac_ini[949] = 23.2849644809540
    sp_jac_ini[950] = -24.9575997948692
    sp_jac_ini[951] = -20.5427472507027
    sp_jac_ini[952] = 79.2784458116403
    sp_jac_ini[953] = 108.131545536521
    sp_jac_ini[954] = -211.143538626360
    sp_jac_ini[955] = -20.5427472507027
    sp_jac_ini[956] = 79.2784458116403
    sp_jac_ini[957] = -46.5699289619080
    sp_jac_ini[958] = 49.9151995897384
    sp_jac_ini[959] = 10.2713736253513
    sp_jac_ini[960] = -39.6392229058202
    sp_jac_ini[961] = -54.0657727682604
    sp_jac_ini[962] = 105.571769313180
    sp_jac_ini[963] = 10.2713736253513
    sp_jac_ini[964] = -39.6392229058201
    sp_jac_ini[965] = 23.2849644809540
    sp_jac_ini[966] = -24.9575997948692
    sp_jac_ini[967] = -24.9575997948692
    sp_jac_ini[968] = -23.2849644809540
    sp_jac_ini[969] = -39.6392229058202
    sp_jac_ini[970] = -10.2713736253513
    sp_jac_ini[971] = 105.571769313180
    sp_jac_ini[972] = 54.0657727682604
    sp_jac_ini[973] = -39.6392229058201
    sp_jac_ini[974] = -10.2713736253514
    sp_jac_ini[975] = 49.9151995897384
    sp_jac_ini[976] = 46.5699289619080
    sp_jac_ini[977] = 79.2784458116404
    sp_jac_ini[978] = 20.5427472507027
    sp_jac_ini[979] = -211.143538626360
    sp_jac_ini[980] = -108.131545536521
    sp_jac_ini[981] = 79.2784458116403
    sp_jac_ini[982] = 20.5427472507027
    sp_jac_ini[983] = -24.9575997948692
    sp_jac_ini[984] = -23.2849644809540
    sp_jac_ini[985] = -39.6392229058202
    sp_jac_ini[986] = -10.2713736253513
    sp_jac_ini[987] = 105.571769313180
    sp_jac_ini[988] = 54.0657727682604
    sp_jac_ini[989] = -39.6392229058201
    sp_jac_ini[990] = -10.2713736253514
    sp_jac_ini[991] = 23.2849644809540
    sp_jac_ini[992] = -24.9575997948692
    sp_jac_ini[993] = 10.2713736253513
    sp_jac_ini[994] = -39.6392229058202
    sp_jac_ini[995] = -54.0657727682604
    sp_jac_ini[996] = 105.571769313180
    sp_jac_ini[997] = 10.2713736253514
    sp_jac_ini[998] = -39.6392229058201
    sp_jac_ini[999] = -46.5699289619080
    sp_jac_ini[1000] = 49.9151995897384
    sp_jac_ini[1001] = -20.5427472507027
    sp_jac_ini[1002] = 79.2784458116404
    sp_jac_ini[1003] = 108.131545536521
    sp_jac_ini[1004] = -211.143538626360
    sp_jac_ini[1005] = -20.5427472507027
    sp_jac_ini[1006] = 79.2784458116403
    sp_jac_ini[1007] = 23.2849644809540
    sp_jac_ini[1008] = -24.9575997948692
    sp_jac_ini[1009] = 10.2713736253513
    sp_jac_ini[1010] = -39.6392229058202
    sp_jac_ini[1011] = -54.0657727682604
    sp_jac_ini[1012] = 105.571769313180
    sp_jac_ini[1013] = 10.2713736253514
    sp_jac_ini[1014] = -39.6392229058201
    sp_jac_ini[1015] = -39.6392229058202
    sp_jac_ini[1016] = -10.2713736253513
    sp_jac_ini[1017] = -24.9575997948692
    sp_jac_ini[1018] = -23.2849644809540
    sp_jac_ini[1019] = -39.6392229058202
    sp_jac_ini[1020] = -10.2713736253513
    sp_jac_ini[1021] = 105.571769313180
    sp_jac_ini[1022] = 54.0657727682604
    sp_jac_ini[1023] = 79.2784458116403
    sp_jac_ini[1024] = 20.5427472507027
    sp_jac_ini[1025] = 49.9151995897384
    sp_jac_ini[1026] = 46.5699289619080
    sp_jac_ini[1027] = 79.2784458116403
    sp_jac_ini[1028] = 20.5427472507027
    sp_jac_ini[1029] = -211.168538626360
    sp_jac_ini[1030] = -108.131545536521
    sp_jac_ini[1031] = -39.6392229058202
    sp_jac_ini[1032] = -10.2713736253513
    sp_jac_ini[1033] = -24.9575997948692
    sp_jac_ini[1034] = -23.2849644809540
    sp_jac_ini[1035] = -39.6392229058202
    sp_jac_ini[1036] = -10.2713736253513
    sp_jac_ini[1037] = 105.571769313180
    sp_jac_ini[1038] = 54.0657727682604
    sp_jac_ini[1039] = 10.2713736253513
    sp_jac_ini[1040] = -39.6392229058202
    sp_jac_ini[1041] = 23.2849644809540
    sp_jac_ini[1042] = -24.9575997948692
    sp_jac_ini[1043] = 10.2713736253513
    sp_jac_ini[1044] = -39.6392229058202
    sp_jac_ini[1045] = -54.0657727682604
    sp_jac_ini[1046] = 105.571769313180
    sp_jac_ini[1047] = -20.5427472507027
    sp_jac_ini[1048] = 79.2784458116403
    sp_jac_ini[1049] = -46.5699289619080
    sp_jac_ini[1050] = 49.9151995897384
    sp_jac_ini[1051] = -20.5427472507027
    sp_jac_ini[1052] = 79.2784458116403
    sp_jac_ini[1053] = 108.131545536521
    sp_jac_ini[1054] = -211.168538626360
    sp_jac_ini[1055] = 10.2713736253513
    sp_jac_ini[1056] = -39.6392229058202
    sp_jac_ini[1057] = 23.2849644809540
    sp_jac_ini[1058] = -24.9575997948692
    sp_jac_ini[1059] = 10.2713736253513
    sp_jac_ini[1060] = -39.6392229058202
    sp_jac_ini[1061] = -54.0657727682604
    sp_jac_ini[1062] = 105.571769313180
    sp_jac_ini[1063] = 26.5300693004806
    sp_jac_ini[1064] = 4.84676915585801
    sp_jac_ini[1065] = -7.89461337514770
    sp_jac_ini[1066] = 1.58482814504483
    sp_jac_ini[1067] = -7.72144347466701
    sp_jac_ini[1068] = 0.679918453285310
    sp_jac_ini[1069] = -7.89461337514771
    sp_jac_ini[1070] = 1.58482814504483
    sp_jac_ini[1071] = 105.571769313180
    sp_jac_ini[1072] = 54.0657727682604
    sp_jac_ini[1073] = -39.6392229058202
    sp_jac_ini[1074] = -10.2713736253513
    sp_jac_ini[1075] = -24.9575997948692
    sp_jac_ini[1076] = -23.2849644809540
    sp_jac_ini[1077] = -39.6392229058202
    sp_jac_ini[1078] = -10.2713736253513
    sp_jac_ini[1079] = -237.673607926841
    sp_jac_ini[1080] = -112.978314692379
    sp_jac_ini[1081] = 87.1730591867880
    sp_jac_ini[1082] = 18.9579191056578
    sp_jac_ini[1083] = 57.6366430644055
    sp_jac_ini[1084] = 45.8900105086227
    sp_jac_ini[1085] = 87.1730591867880
    sp_jac_ini[1086] = 18.9579191056579
    sp_jac_ini[1087] = 105.571769313180
    sp_jac_ini[1088] = 54.0657727682604
    sp_jac_ini[1089] = -39.6392229058202
    sp_jac_ini[1090] = -10.2713736253513
    sp_jac_ini[1091] = -24.9575997948692
    sp_jac_ini[1092] = -23.2849644809540
    sp_jac_ini[1093] = -39.6392229058202
    sp_jac_ini[1094] = -10.2713736253513
    sp_jac_ini[1095] = -4.84676915585801
    sp_jac_ini[1096] = 26.5300693004806
    sp_jac_ini[1097] = -1.58482814504483
    sp_jac_ini[1098] = -7.89461337514770
    sp_jac_ini[1099] = -0.679918453285310
    sp_jac_ini[1100] = -7.72144347466701
    sp_jac_ini[1101] = -1.58482814504483
    sp_jac_ini[1102] = -7.89461337514771
    sp_jac_ini[1103] = -54.0657727682604
    sp_jac_ini[1104] = 105.571769313180
    sp_jac_ini[1105] = 10.2713736253513
    sp_jac_ini[1106] = -39.6392229058202
    sp_jac_ini[1107] = 23.2849644809540
    sp_jac_ini[1108] = -24.9575997948692
    sp_jac_ini[1109] = 10.2713736253513
    sp_jac_ini[1110] = -39.6392229058202
    sp_jac_ini[1111] = 112.978314692379
    sp_jac_ini[1112] = -237.673607926841
    sp_jac_ini[1113] = -18.9579191056578
    sp_jac_ini[1114] = 87.1730591867880
    sp_jac_ini[1115] = -45.8900105086227
    sp_jac_ini[1116] = 57.6366430644055
    sp_jac_ini[1117] = -18.9579191056579
    sp_jac_ini[1118] = 87.1730591867880
    sp_jac_ini[1119] = -54.0657727682604
    sp_jac_ini[1120] = 105.571769313180
    sp_jac_ini[1121] = 10.2713736253513
    sp_jac_ini[1122] = -39.6392229058202
    sp_jac_ini[1123] = 23.2849644809540
    sp_jac_ini[1124] = -24.9575997948692
    sp_jac_ini[1125] = 10.2713736253513
    sp_jac_ini[1126] = -39.6392229058202
    sp_jac_ini[1127] = -7.89461337514771
    sp_jac_ini[1128] = 1.58482814504483
    sp_jac_ini[1129] = 26.5300693004806
    sp_jac_ini[1130] = 4.84676915585801
    sp_jac_ini[1131] = -7.89461337514771
    sp_jac_ini[1132] = 1.58482814504483
    sp_jac_ini[1133] = -7.72144347466701
    sp_jac_ini[1134] = 0.679918453285308
    sp_jac_ini[1135] = -39.6392229058202
    sp_jac_ini[1136] = -10.2713736253513
    sp_jac_ini[1137] = 105.571769313180
    sp_jac_ini[1138] = 54.0657727682604
    sp_jac_ini[1139] = -39.6392229058201
    sp_jac_ini[1140] = -10.2713736253513
    sp_jac_ini[1141] = -24.9575997948692
    sp_jac_ini[1142] = -23.2849644809540
    sp_jac_ini[1143] = 87.1730591867880
    sp_jac_ini[1144] = 18.9579191056579
    sp_jac_ini[1145] = -237.673607926841
    sp_jac_ini[1146] = -112.978314692379
    sp_jac_ini[1147] = 87.1730591867880
    sp_jac_ini[1148] = 18.9579191056579
    sp_jac_ini[1149] = 57.6366430644054
    sp_jac_ini[1150] = 45.8900105086227
    sp_jac_ini[1151] = -39.6392229058202
    sp_jac_ini[1152] = -10.2713736253513
    sp_jac_ini[1153] = 105.571769313180
    sp_jac_ini[1154] = 54.0657727682604
    sp_jac_ini[1155] = -39.6392229058201
    sp_jac_ini[1156] = -10.2713736253513
    sp_jac_ini[1157] = -24.9575997948692
    sp_jac_ini[1158] = -23.2849644809540
    sp_jac_ini[1159] = -1.58482814504483
    sp_jac_ini[1160] = -7.89461337514771
    sp_jac_ini[1161] = -4.84676915585801
    sp_jac_ini[1162] = 26.5300693004806
    sp_jac_ini[1163] = -1.58482814504483
    sp_jac_ini[1164] = -7.89461337514771
    sp_jac_ini[1165] = -0.679918453285308
    sp_jac_ini[1166] = -7.72144347466701
    sp_jac_ini[1167] = 10.2713736253513
    sp_jac_ini[1168] = -39.6392229058202
    sp_jac_ini[1169] = -54.0657727682604
    sp_jac_ini[1170] = 105.571769313180
    sp_jac_ini[1171] = 10.2713736253513
    sp_jac_ini[1172] = -39.6392229058201
    sp_jac_ini[1173] = 23.2849644809540
    sp_jac_ini[1174] = -24.9575997948692
    sp_jac_ini[1175] = -18.9579191056579
    sp_jac_ini[1176] = 87.1730591867880
    sp_jac_ini[1177] = 112.978314692379
    sp_jac_ini[1178] = -237.673607926841
    sp_jac_ini[1179] = -18.9579191056579
    sp_jac_ini[1180] = 87.1730591867880
    sp_jac_ini[1181] = -45.8900105086227
    sp_jac_ini[1182] = 57.6366430644054
    sp_jac_ini[1183] = 10.2713736253513
    sp_jac_ini[1184] = -39.6392229058202
    sp_jac_ini[1185] = -54.0657727682604
    sp_jac_ini[1186] = 105.571769313180
    sp_jac_ini[1187] = 10.2713736253513
    sp_jac_ini[1188] = -39.6392229058201
    sp_jac_ini[1189] = 23.2849644809540
    sp_jac_ini[1190] = -24.9575997948692
    sp_jac_ini[1191] = -7.72144347466701
    sp_jac_ini[1192] = 0.679918453285310
    sp_jac_ini[1193] = -7.89461337514770
    sp_jac_ini[1194] = 1.58482814504483
    sp_jac_ini[1195] = 26.5300693004806
    sp_jac_ini[1196] = 4.84676915585801
    sp_jac_ini[1197] = -7.89461337514771
    sp_jac_ini[1198] = 1.58482814504483
    sp_jac_ini[1199] = -24.9575997948692
    sp_jac_ini[1200] = -23.2849644809540
    sp_jac_ini[1201] = -39.6392229058202
    sp_jac_ini[1202] = -10.2713736253513
    sp_jac_ini[1203] = 105.571769313180
    sp_jac_ini[1204] = 54.0657727682604
    sp_jac_ini[1205] = -39.6392229058201
    sp_jac_ini[1206] = -10.2713736253514
    sp_jac_ini[1207] = 57.6366430644054
    sp_jac_ini[1208] = 45.8900105086227
    sp_jac_ini[1209] = 87.1730591867881
    sp_jac_ini[1210] = 18.9579191056578
    sp_jac_ini[1211] = -237.673607926841
    sp_jac_ini[1212] = -112.978314692379
    sp_jac_ini[1213] = 87.1730591867880
    sp_jac_ini[1214] = 18.9579191056579
    sp_jac_ini[1215] = -24.9575997948692
    sp_jac_ini[1216] = -23.2849644809540
    sp_jac_ini[1217] = -39.6392229058202
    sp_jac_ini[1218] = -10.2713736253513
    sp_jac_ini[1219] = 105.571769313180
    sp_jac_ini[1220] = 54.0657727682604
    sp_jac_ini[1221] = -39.6392229058201
    sp_jac_ini[1222] = -10.2713736253514
    sp_jac_ini[1223] = -0.679918453285310
    sp_jac_ini[1224] = -7.72144347466701
    sp_jac_ini[1225] = -1.58482814504483
    sp_jac_ini[1226] = -7.89461337514770
    sp_jac_ini[1227] = -4.84676915585801
    sp_jac_ini[1228] = 26.5300693004806
    sp_jac_ini[1229] = -1.58482814504483
    sp_jac_ini[1230] = -7.89461337514771
    sp_jac_ini[1231] = 23.2849644809540
    sp_jac_ini[1232] = -24.9575997948692
    sp_jac_ini[1233] = 10.2713736253513
    sp_jac_ini[1234] = -39.6392229058202
    sp_jac_ini[1235] = -54.0657727682604
    sp_jac_ini[1236] = 105.571769313180
    sp_jac_ini[1237] = 10.2713736253514
    sp_jac_ini[1238] = -39.6392229058201
    sp_jac_ini[1239] = -45.8900105086227
    sp_jac_ini[1240] = 57.6366430644054
    sp_jac_ini[1241] = -18.9579191056578
    sp_jac_ini[1242] = 87.1730591867881
    sp_jac_ini[1243] = 112.978314692379
    sp_jac_ini[1244] = -237.673607926841
    sp_jac_ini[1245] = -18.9579191056579
    sp_jac_ini[1246] = 87.1730591867880
    sp_jac_ini[1247] = 23.2849644809540
    sp_jac_ini[1248] = -24.9575997948692
    sp_jac_ini[1249] = 10.2713736253513
    sp_jac_ini[1250] = -39.6392229058202
    sp_jac_ini[1251] = -54.0657727682604
    sp_jac_ini[1252] = 105.571769313180
    sp_jac_ini[1253] = 10.2713736253514
    sp_jac_ini[1254] = -39.6392229058201
    sp_jac_ini[1255] = -7.89461337514771
    sp_jac_ini[1256] = 1.58482814504483
    sp_jac_ini[1257] = -7.72144347466701
    sp_jac_ini[1258] = 0.679918453285308
    sp_jac_ini[1259] = -7.89461337514771
    sp_jac_ini[1260] = 1.58482814504483
    sp_jac_ini[1261] = 26.5300693004806
    sp_jac_ini[1262] = 4.84676915585801
    sp_jac_ini[1263] = -39.6392229058202
    sp_jac_ini[1264] = -10.2713736253513
    sp_jac_ini[1265] = -24.9575997948692
    sp_jac_ini[1266] = -23.2849644809540
    sp_jac_ini[1267] = -39.6392229058202
    sp_jac_ini[1268] = -10.2713736253513
    sp_jac_ini[1269] = 105.571769313180
    sp_jac_ini[1270] = 54.0657727682604
    sp_jac_ini[1271] = 87.1730591867880
    sp_jac_ini[1272] = 18.9579191056578
    sp_jac_ini[1273] = 57.6366430644054
    sp_jac_ini[1274] = 45.8900105086227
    sp_jac_ini[1275] = 87.1730591867880
    sp_jac_ini[1276] = 18.9579191056579
    sp_jac_ini[1277] = -237.673607926841
    sp_jac_ini[1278] = -112.978314692379
    sp_jac_ini[1279] = -39.6392229058202
    sp_jac_ini[1280] = -10.2713736253513
    sp_jac_ini[1281] = -24.9575997948692
    sp_jac_ini[1282] = -23.2849644809540
    sp_jac_ini[1283] = -39.6392229058202
    sp_jac_ini[1284] = -10.2713736253513
    sp_jac_ini[1285] = 105.571769313180
    sp_jac_ini[1286] = 54.0657727682604
    sp_jac_ini[1287] = -1.58482814504483
    sp_jac_ini[1288] = -7.89461337514771
    sp_jac_ini[1289] = -0.679918453285308
    sp_jac_ini[1290] = -7.72144347466701
    sp_jac_ini[1291] = -1.58482814504483
    sp_jac_ini[1292] = -7.89461337514771
    sp_jac_ini[1293] = -4.84676915585801
    sp_jac_ini[1294] = 26.5300693004806
    sp_jac_ini[1295] = 10.2713736253513
    sp_jac_ini[1296] = -39.6392229058202
    sp_jac_ini[1297] = 23.2849644809540
    sp_jac_ini[1298] = -24.9575997948692
    sp_jac_ini[1299] = 10.2713736253513
    sp_jac_ini[1300] = -39.6392229058202
    sp_jac_ini[1301] = -54.0657727682604
    sp_jac_ini[1302] = 105.571769313180
    sp_jac_ini[1303] = -18.9579191056578
    sp_jac_ini[1304] = 87.1730591867880
    sp_jac_ini[1305] = -45.8900105086227
    sp_jac_ini[1306] = 57.6366430644054
    sp_jac_ini[1307] = -18.9579191056579
    sp_jac_ini[1308] = 87.1730591867880
    sp_jac_ini[1309] = 112.978314692379
    sp_jac_ini[1310] = -237.673607926841
    sp_jac_ini[1311] = 10.2713736253513
    sp_jac_ini[1312] = -39.6392229058202
    sp_jac_ini[1313] = 23.2849644809540
    sp_jac_ini[1314] = -24.9575997948692
    sp_jac_ini[1315] = 10.2713736253513
    sp_jac_ini[1316] = -39.6392229058202
    sp_jac_ini[1317] = -54.0657727682604
    sp_jac_ini[1318] = 105.571769313180
    sp_jac_ini[1319] = 105.571769313180
    sp_jac_ini[1320] = 54.0657727682604
    sp_jac_ini[1321] = -39.6392229058202
    sp_jac_ini[1322] = -10.2713736253513
    sp_jac_ini[1323] = -24.9575997948692
    sp_jac_ini[1324] = -23.2849644809540
    sp_jac_ini[1325] = -39.6392229058202
    sp_jac_ini[1326] = -10.2713736253513
    sp_jac_ini[1327] = -237.673607926841
    sp_jac_ini[1328] = -112.978314692379
    sp_jac_ini[1329] = 87.1730591867880
    sp_jac_ini[1330] = 18.9579191056578
    sp_jac_ini[1331] = 57.6366430644055
    sp_jac_ini[1332] = 45.8900105086227
    sp_jac_ini[1333] = 87.1730591867880
    sp_jac_ini[1334] = 18.9579191056579
    sp_jac_ini[1335] = 105.571769313180
    sp_jac_ini[1336] = 54.0657727682604
    sp_jac_ini[1337] = -39.6392229058202
    sp_jac_ini[1338] = -10.2713736253513
    sp_jac_ini[1339] = -24.9575997948692
    sp_jac_ini[1340] = -23.2849644809540
    sp_jac_ini[1341] = -39.6392229058202
    sp_jac_ini[1342] = -10.2713736253513
    sp_jac_ini[1343] = 26.5300693004806
    sp_jac_ini[1344] = 4.84676915585801
    sp_jac_ini[1345] = -7.89461337514770
    sp_jac_ini[1346] = 1.58482814504483
    sp_jac_ini[1347] = -7.72144347466701
    sp_jac_ini[1348] = 0.679918453285310
    sp_jac_ini[1349] = -7.89461337514771
    sp_jac_ini[1350] = 1.58482814504483
    sp_jac_ini[1351] = -54.0657727682604
    sp_jac_ini[1352] = 105.571769313180
    sp_jac_ini[1353] = 10.2713736253513
    sp_jac_ini[1354] = -39.6392229058202
    sp_jac_ini[1355] = 23.2849644809540
    sp_jac_ini[1356] = -24.9575997948692
    sp_jac_ini[1357] = 10.2713736253513
    sp_jac_ini[1358] = -39.6392229058202
    sp_jac_ini[1359] = 112.978314692379
    sp_jac_ini[1360] = -237.673607926841
    sp_jac_ini[1361] = -18.9579191056578
    sp_jac_ini[1362] = 87.1730591867880
    sp_jac_ini[1363] = -45.8900105086227
    sp_jac_ini[1364] = 57.6366430644055
    sp_jac_ini[1365] = -18.9579191056579
    sp_jac_ini[1366] = 87.1730591867880
    sp_jac_ini[1367] = -54.0657727682604
    sp_jac_ini[1368] = 105.571769313180
    sp_jac_ini[1369] = 10.2713736253513
    sp_jac_ini[1370] = -39.6392229058202
    sp_jac_ini[1371] = 23.2849644809540
    sp_jac_ini[1372] = -24.9575997948692
    sp_jac_ini[1373] = 10.2713736253513
    sp_jac_ini[1374] = -39.6392229058202
    sp_jac_ini[1375] = -4.84676915585801
    sp_jac_ini[1376] = 26.5300693004806
    sp_jac_ini[1377] = -1.58482814504483
    sp_jac_ini[1378] = -7.89461337514770
    sp_jac_ini[1379] = -0.679918453285310
    sp_jac_ini[1380] = -7.72144347466701
    sp_jac_ini[1381] = -1.58482814504483
    sp_jac_ini[1382] = -7.89461337514771
    sp_jac_ini[1383] = -39.6392229058202
    sp_jac_ini[1384] = -10.2713736253513
    sp_jac_ini[1385] = 105.571769313180
    sp_jac_ini[1386] = 54.0657727682604
    sp_jac_ini[1387] = -39.6392229058201
    sp_jac_ini[1388] = -10.2713736253513
    sp_jac_ini[1389] = -24.9575997948692
    sp_jac_ini[1390] = -23.2849644809540
    sp_jac_ini[1391] = 87.1730591867880
    sp_jac_ini[1392] = 18.9579191056579
    sp_jac_ini[1393] = -237.673607926841
    sp_jac_ini[1394] = -112.978314692379
    sp_jac_ini[1395] = 87.1730591867880
    sp_jac_ini[1396] = 18.9579191056579
    sp_jac_ini[1397] = 57.6366430644054
    sp_jac_ini[1398] = 45.8900105086227
    sp_jac_ini[1399] = -39.6392229058202
    sp_jac_ini[1400] = -10.2713736253513
    sp_jac_ini[1401] = 105.571769313180
    sp_jac_ini[1402] = 54.0657727682604
    sp_jac_ini[1403] = -39.6392229058201
    sp_jac_ini[1404] = -10.2713736253513
    sp_jac_ini[1405] = -24.9575997948692
    sp_jac_ini[1406] = -23.2849644809540
    sp_jac_ini[1407] = -7.89461337514771
    sp_jac_ini[1408] = 1.58482814504483
    sp_jac_ini[1409] = 26.5300693004806
    sp_jac_ini[1410] = 4.84676915585801
    sp_jac_ini[1411] = -7.89461337514771
    sp_jac_ini[1412] = 1.58482814504483
    sp_jac_ini[1413] = -7.72144347466701
    sp_jac_ini[1414] = 0.679918453285308
    sp_jac_ini[1415] = 10.2713736253513
    sp_jac_ini[1416] = -39.6392229058202
    sp_jac_ini[1417] = -54.0657727682604
    sp_jac_ini[1418] = 105.571769313180
    sp_jac_ini[1419] = 10.2713736253513
    sp_jac_ini[1420] = -39.6392229058201
    sp_jac_ini[1421] = 23.2849644809540
    sp_jac_ini[1422] = -24.9575997948692
    sp_jac_ini[1423] = -18.9579191056579
    sp_jac_ini[1424] = 87.1730591867880
    sp_jac_ini[1425] = 112.978314692379
    sp_jac_ini[1426] = -237.673607926841
    sp_jac_ini[1427] = -18.9579191056579
    sp_jac_ini[1428] = 87.1730591867880
    sp_jac_ini[1429] = -45.8900105086227
    sp_jac_ini[1430] = 57.6366430644054
    sp_jac_ini[1431] = 10.2713736253513
    sp_jac_ini[1432] = -39.6392229058202
    sp_jac_ini[1433] = -54.0657727682604
    sp_jac_ini[1434] = 105.571769313180
    sp_jac_ini[1435] = 10.2713736253513
    sp_jac_ini[1436] = -39.6392229058201
    sp_jac_ini[1437] = 23.2849644809540
    sp_jac_ini[1438] = -24.9575997948692
    sp_jac_ini[1439] = -1.58482814504483
    sp_jac_ini[1440] = -7.89461337514771
    sp_jac_ini[1441] = -4.84676915585801
    sp_jac_ini[1442] = 26.5300693004806
    sp_jac_ini[1443] = -1.58482814504483
    sp_jac_ini[1444] = -7.89461337514771
    sp_jac_ini[1445] = -0.679918453285308
    sp_jac_ini[1446] = -7.72144347466701
    sp_jac_ini[1447] = -24.9575997948692
    sp_jac_ini[1448] = -23.2849644809540
    sp_jac_ini[1449] = -39.6392229058202
    sp_jac_ini[1450] = -10.2713736253513
    sp_jac_ini[1451] = 105.571769313180
    sp_jac_ini[1452] = 54.0657727682604
    sp_jac_ini[1453] = -39.6392229058201
    sp_jac_ini[1454] = -10.2713736253514
    sp_jac_ini[1455] = 57.6366430644054
    sp_jac_ini[1456] = 45.8900105086227
    sp_jac_ini[1457] = 87.1730591867881
    sp_jac_ini[1458] = 18.9579191056578
    sp_jac_ini[1459] = -237.673607926841
    sp_jac_ini[1460] = -112.978314692379
    sp_jac_ini[1461] = 87.1730591867880
    sp_jac_ini[1462] = 18.9579191056579
    sp_jac_ini[1463] = -24.9575997948692
    sp_jac_ini[1464] = -23.2849644809540
    sp_jac_ini[1465] = -39.6392229058202
    sp_jac_ini[1466] = -10.2713736253513
    sp_jac_ini[1467] = 105.571769313180
    sp_jac_ini[1468] = 54.0657727682604
    sp_jac_ini[1469] = -39.6392229058201
    sp_jac_ini[1470] = -10.2713736253514
    sp_jac_ini[1471] = -7.72144347466701
    sp_jac_ini[1472] = 0.679918453285310
    sp_jac_ini[1473] = -7.89461337514770
    sp_jac_ini[1474] = 1.58482814504483
    sp_jac_ini[1475] = 26.5300693004806
    sp_jac_ini[1476] = 4.84676915585801
    sp_jac_ini[1477] = -7.89461337514771
    sp_jac_ini[1478] = 1.58482814504483
    sp_jac_ini[1479] = 23.2849644809540
    sp_jac_ini[1480] = -24.9575997948692
    sp_jac_ini[1481] = 10.2713736253513
    sp_jac_ini[1482] = -39.6392229058202
    sp_jac_ini[1483] = -54.0657727682604
    sp_jac_ini[1484] = 105.571769313180
    sp_jac_ini[1485] = 10.2713736253514
    sp_jac_ini[1486] = -39.6392229058201
    sp_jac_ini[1487] = -45.8900105086227
    sp_jac_ini[1488] = 57.6366430644054
    sp_jac_ini[1489] = -18.9579191056578
    sp_jac_ini[1490] = 87.1730591867881
    sp_jac_ini[1491] = 112.978314692379
    sp_jac_ini[1492] = -237.673607926841
    sp_jac_ini[1493] = -18.9579191056579
    sp_jac_ini[1494] = 87.1730591867880
    sp_jac_ini[1495] = 23.2849644809540
    sp_jac_ini[1496] = -24.9575997948692
    sp_jac_ini[1497] = 10.2713736253513
    sp_jac_ini[1498] = -39.6392229058202
    sp_jac_ini[1499] = -54.0657727682604
    sp_jac_ini[1500] = 105.571769313180
    sp_jac_ini[1501] = 10.2713736253514
    sp_jac_ini[1502] = -39.6392229058201
    sp_jac_ini[1503] = -0.679918453285310
    sp_jac_ini[1504] = -7.72144347466701
    sp_jac_ini[1505] = -1.58482814504483
    sp_jac_ini[1506] = -7.89461337514770
    sp_jac_ini[1507] = -4.84676915585801
    sp_jac_ini[1508] = 26.5300693004806
    sp_jac_ini[1509] = -1.58482814504483
    sp_jac_ini[1510] = -7.89461337514771
    sp_jac_ini[1511] = -39.6392229058202
    sp_jac_ini[1512] = -10.2713736253513
    sp_jac_ini[1513] = -24.9575997948692
    sp_jac_ini[1514] = -23.2849644809540
    sp_jac_ini[1515] = -39.6392229058202
    sp_jac_ini[1516] = -10.2713736253513
    sp_jac_ini[1517] = 105.571769313180
    sp_jac_ini[1518] = 54.0657727682604
    sp_jac_ini[1519] = 87.1730591867880
    sp_jac_ini[1520] = 18.9579191056578
    sp_jac_ini[1521] = 57.6366430644054
    sp_jac_ini[1522] = 45.8900105086227
    sp_jac_ini[1523] = 87.1730591867880
    sp_jac_ini[1524] = 18.9579191056579
    sp_jac_ini[1525] = -237.698607926841
    sp_jac_ini[1526] = -112.978314692379
    sp_jac_ini[1527] = -39.6392229058202
    sp_jac_ini[1528] = -10.2713736253513
    sp_jac_ini[1529] = -24.9575997948692
    sp_jac_ini[1530] = -23.2849644809540
    sp_jac_ini[1531] = -39.6392229058202
    sp_jac_ini[1532] = -10.2713736253513
    sp_jac_ini[1533] = 105.571769313180
    sp_jac_ini[1534] = 54.0657727682604
    sp_jac_ini[1535] = -7.89461337514771
    sp_jac_ini[1536] = 1.58482814504483
    sp_jac_ini[1537] = -7.72144347466701
    sp_jac_ini[1538] = 0.679918453285308
    sp_jac_ini[1539] = -7.89461337514771
    sp_jac_ini[1540] = 1.58482814504483
    sp_jac_ini[1541] = 26.5300693004806
    sp_jac_ini[1542] = 4.84676915585801
    sp_jac_ini[1543] = 10.2713736253513
    sp_jac_ini[1544] = -39.6392229058202
    sp_jac_ini[1545] = 23.2849644809540
    sp_jac_ini[1546] = -24.9575997948692
    sp_jac_ini[1547] = 10.2713736253513
    sp_jac_ini[1548] = -39.6392229058202
    sp_jac_ini[1549] = -54.0657727682604
    sp_jac_ini[1550] = 105.571769313180
    sp_jac_ini[1551] = -18.9579191056578
    sp_jac_ini[1552] = 87.1730591867880
    sp_jac_ini[1553] = -45.8900105086227
    sp_jac_ini[1554] = 57.6366430644054
    sp_jac_ini[1555] = -18.9579191056579
    sp_jac_ini[1556] = 87.1730591867880
    sp_jac_ini[1557] = 112.978314692379
    sp_jac_ini[1558] = -237.698607926841
    sp_jac_ini[1559] = 10.2713736253513
    sp_jac_ini[1560] = -39.6392229058202
    sp_jac_ini[1561] = 23.2849644809540
    sp_jac_ini[1562] = -24.9575997948692
    sp_jac_ini[1563] = 10.2713736253513
    sp_jac_ini[1564] = -39.6392229058202
    sp_jac_ini[1565] = -54.0657727682604
    sp_jac_ini[1566] = 105.571769313180
    sp_jac_ini[1567] = -1.58482814504483
    sp_jac_ini[1568] = -7.89461337514771
    sp_jac_ini[1569] = -0.679918453285308
    sp_jac_ini[1570] = -7.72144347466701
    sp_jac_ini[1571] = -1.58482814504483
    sp_jac_ini[1572] = -7.89461337514771
    sp_jac_ini[1573] = -4.84676915585801
    sp_jac_ini[1574] = 26.5300693004806
    sp_jac_ini[1575] = 105.571769313180
    sp_jac_ini[1576] = 54.0657727682604
    sp_jac_ini[1577] = -39.6392229058202
    sp_jac_ini[1578] = -10.2713736253513
    sp_jac_ini[1579] = -24.9575997948692
    sp_jac_ini[1580] = -23.2849644809540
    sp_jac_ini[1581] = -39.6392229058202
    sp_jac_ini[1582] = -10.2713736253513
    sp_jac_ini[1583] = -211.143538626360
    sp_jac_ini[1584] = -108.131545536521
    sp_jac_ini[1585] = 79.2784458116403
    sp_jac_ini[1586] = 20.5427472507027
    sp_jac_ini[1587] = 49.9151995897384
    sp_jac_ini[1588] = 46.5699289619080
    sp_jac_ini[1589] = 79.2784458116403
    sp_jac_ini[1590] = 20.5427472507027
    sp_jac_ini[1591] = 105.571769313180
    sp_jac_ini[1592] = 54.0657727682604
    sp_jac_ini[1593] = -39.6392229058202
    sp_jac_ini[1594] = -10.2713736253513
    sp_jac_ini[1595] = -24.9575997948692
    sp_jac_ini[1596] = -23.2849644809540
    sp_jac_ini[1597] = -39.6392229058202
    sp_jac_ini[1598] = -10.2713736253513
    sp_jac_ini[1599] = -54.0657727682604
    sp_jac_ini[1600] = 105.571769313180
    sp_jac_ini[1601] = 10.2713736253513
    sp_jac_ini[1602] = -39.6392229058202
    sp_jac_ini[1603] = 23.2849644809540
    sp_jac_ini[1604] = -24.9575997948692
    sp_jac_ini[1605] = 10.2713736253513
    sp_jac_ini[1606] = -39.6392229058202
    sp_jac_ini[1607] = 108.131545536521
    sp_jac_ini[1608] = -211.143538626360
    sp_jac_ini[1609] = -20.5427472507027
    sp_jac_ini[1610] = 79.2784458116403
    sp_jac_ini[1611] = -46.5699289619080
    sp_jac_ini[1612] = 49.9151995897384
    sp_jac_ini[1613] = -20.5427472507027
    sp_jac_ini[1614] = 79.2784458116403
    sp_jac_ini[1615] = -54.0657727682604
    sp_jac_ini[1616] = 105.571769313180
    sp_jac_ini[1617] = 10.2713736253513
    sp_jac_ini[1618] = -39.6392229058202
    sp_jac_ini[1619] = 23.2849644809540
    sp_jac_ini[1620] = -24.9575997948692
    sp_jac_ini[1621] = 10.2713736253513
    sp_jac_ini[1622] = -39.6392229058202
    sp_jac_ini[1623] = -39.6392229058202
    sp_jac_ini[1624] = -10.2713736253513
    sp_jac_ini[1625] = 105.571769313180
    sp_jac_ini[1626] = 54.0657727682604
    sp_jac_ini[1627] = -39.6392229058201
    sp_jac_ini[1628] = -10.2713736253513
    sp_jac_ini[1629] = -24.9575997948692
    sp_jac_ini[1630] = -23.2849644809540
    sp_jac_ini[1631] = 79.2784458116403
    sp_jac_ini[1632] = 20.5427472507027
    sp_jac_ini[1633] = -211.143538626360
    sp_jac_ini[1634] = -108.131545536521
    sp_jac_ini[1635] = 79.2784458116403
    sp_jac_ini[1636] = 20.5427472507027
    sp_jac_ini[1637] = 49.9151995897384
    sp_jac_ini[1638] = 46.5699289619080
    sp_jac_ini[1639] = -39.6392229058202
    sp_jac_ini[1640] = -10.2713736253513
    sp_jac_ini[1641] = 105.571769313180
    sp_jac_ini[1642] = 54.0657727682604
    sp_jac_ini[1643] = -39.6392229058201
    sp_jac_ini[1644] = -10.2713736253513
    sp_jac_ini[1645] = -24.9575997948692
    sp_jac_ini[1646] = -23.2849644809540
    sp_jac_ini[1647] = 10.2713736253513
    sp_jac_ini[1648] = -39.6392229058202
    sp_jac_ini[1649] = -54.0657727682604
    sp_jac_ini[1650] = 105.571769313180
    sp_jac_ini[1651] = 10.2713736253513
    sp_jac_ini[1652] = -39.6392229058201
    sp_jac_ini[1653] = 23.2849644809540
    sp_jac_ini[1654] = -24.9575997948692
    sp_jac_ini[1655] = -20.5427472507027
    sp_jac_ini[1656] = 79.2784458116403
    sp_jac_ini[1657] = 108.131545536521
    sp_jac_ini[1658] = -211.143538626360
    sp_jac_ini[1659] = -20.5427472507027
    sp_jac_ini[1660] = 79.2784458116403
    sp_jac_ini[1661] = -46.5699289619080
    sp_jac_ini[1662] = 49.9151995897384
    sp_jac_ini[1663] = 10.2713736253513
    sp_jac_ini[1664] = -39.6392229058202
    sp_jac_ini[1665] = -54.0657727682604
    sp_jac_ini[1666] = 105.571769313180
    sp_jac_ini[1667] = 10.2713736253513
    sp_jac_ini[1668] = -39.6392229058201
    sp_jac_ini[1669] = 23.2849644809540
    sp_jac_ini[1670] = -24.9575997948692
    sp_jac_ini[1671] = -24.9575997948692
    sp_jac_ini[1672] = -23.2849644809540
    sp_jac_ini[1673] = -39.6392229058202
    sp_jac_ini[1674] = -10.2713736253513
    sp_jac_ini[1675] = 105.571769313180
    sp_jac_ini[1676] = 54.0657727682604
    sp_jac_ini[1677] = -39.6392229058201
    sp_jac_ini[1678] = -10.2713736253514
    sp_jac_ini[1679] = 49.9151995897384
    sp_jac_ini[1680] = 46.5699289619080
    sp_jac_ini[1681] = 79.2784458116404
    sp_jac_ini[1682] = 20.5427472507027
    sp_jac_ini[1683] = -211.143538626360
    sp_jac_ini[1684] = -108.131545536521
    sp_jac_ini[1685] = 79.2784458116403
    sp_jac_ini[1686] = 20.5427472507027
    sp_jac_ini[1687] = -24.9575997948692
    sp_jac_ini[1688] = -23.2849644809540
    sp_jac_ini[1689] = -39.6392229058202
    sp_jac_ini[1690] = -10.2713736253513
    sp_jac_ini[1691] = 105.571769313180
    sp_jac_ini[1692] = 54.0657727682604
    sp_jac_ini[1693] = -39.6392229058201
    sp_jac_ini[1694] = -10.2713736253514
    sp_jac_ini[1695] = 23.2849644809540
    sp_jac_ini[1696] = -24.9575997948692
    sp_jac_ini[1697] = 10.2713736253513
    sp_jac_ini[1698] = -39.6392229058202
    sp_jac_ini[1699] = -54.0657727682604
    sp_jac_ini[1700] = 105.571769313180
    sp_jac_ini[1701] = 10.2713736253514
    sp_jac_ini[1702] = -39.6392229058201
    sp_jac_ini[1703] = -46.5699289619080
    sp_jac_ini[1704] = 49.9151995897384
    sp_jac_ini[1705] = -20.5427472507027
    sp_jac_ini[1706] = 79.2784458116404
    sp_jac_ini[1707] = 108.131545536521
    sp_jac_ini[1708] = -211.143538626360
    sp_jac_ini[1709] = -20.5427472507027
    sp_jac_ini[1710] = 79.2784458116403
    sp_jac_ini[1711] = 23.2849644809540
    sp_jac_ini[1712] = -24.9575997948692
    sp_jac_ini[1713] = 10.2713736253513
    sp_jac_ini[1714] = -39.6392229058202
    sp_jac_ini[1715] = -54.0657727682604
    sp_jac_ini[1716] = 105.571769313180
    sp_jac_ini[1717] = 10.2713736253514
    sp_jac_ini[1718] = -39.6392229058201
    sp_jac_ini[1719] = -39.6392229058202
    sp_jac_ini[1720] = -10.2713736253513
    sp_jac_ini[1721] = -24.9575997948692
    sp_jac_ini[1722] = -23.2849644809540
    sp_jac_ini[1723] = -39.6392229058202
    sp_jac_ini[1724] = -10.2713736253513
    sp_jac_ini[1725] = 105.571769313180
    sp_jac_ini[1726] = 54.0657727682604
    sp_jac_ini[1727] = 79.2784458116403
    sp_jac_ini[1728] = 20.5427472507027
    sp_jac_ini[1729] = 49.9151995897384
    sp_jac_ini[1730] = 46.5699289619080
    sp_jac_ini[1731] = 79.2784458116403
    sp_jac_ini[1732] = 20.5427472507027
    sp_jac_ini[1733] = -211.143538626360
    sp_jac_ini[1734] = -108.131545536521
    sp_jac_ini[1735] = -39.6392229058202
    sp_jac_ini[1736] = -10.2713736253513
    sp_jac_ini[1737] = -24.9575997948692
    sp_jac_ini[1738] = -23.2849644809540
    sp_jac_ini[1739] = -39.6392229058202
    sp_jac_ini[1740] = -10.2713736253513
    sp_jac_ini[1741] = 105.571769313180
    sp_jac_ini[1742] = 54.0657727682604
    sp_jac_ini[1743] = 10.2713736253513
    sp_jac_ini[1744] = -39.6392229058202
    sp_jac_ini[1745] = 23.2849644809540
    sp_jac_ini[1746] = -24.9575997948692
    sp_jac_ini[1747] = 10.2713736253513
    sp_jac_ini[1748] = -39.6392229058202
    sp_jac_ini[1749] = -54.0657727682604
    sp_jac_ini[1750] = 105.571769313180
    sp_jac_ini[1751] = -20.5427472507027
    sp_jac_ini[1752] = 79.2784458116403
    sp_jac_ini[1753] = -46.5699289619080
    sp_jac_ini[1754] = 49.9151995897384
    sp_jac_ini[1755] = -20.5427472507027
    sp_jac_ini[1756] = 79.2784458116403
    sp_jac_ini[1757] = 108.131545536521
    sp_jac_ini[1758] = -211.143538626360
    sp_jac_ini[1759] = 10.2713736253513
    sp_jac_ini[1760] = -39.6392229058202
    sp_jac_ini[1761] = 23.2849644809540
    sp_jac_ini[1762] = -24.9575997948692
    sp_jac_ini[1763] = 10.2713736253513
    sp_jac_ini[1764] = -39.6392229058202
    sp_jac_ini[1765] = -54.0657727682604
    sp_jac_ini[1766] = 105.571769313180
    sp_jac_ini[1767] = 30.9517475172273
    sp_jac_ini[1768] = 5.65456401516768
    sp_jac_ini[1769] = -9.21038227100566
    sp_jac_ini[1770] = 1.84896616921897
    sp_jac_ini[1771] = -9.00835072044485
    sp_jac_ini[1772] = 0.793238195499529
    sp_jac_ini[1773] = -9.21038227100566
    sp_jac_ini[1774] = 1.84896616921897
    sp_jac_ini[1775] = 105.571769313180
    sp_jac_ini[1776] = 54.0657727682604
    sp_jac_ini[1777] = -39.6392229058202
    sp_jac_ini[1778] = -10.2713736253513
    sp_jac_ini[1779] = -24.9575997948692
    sp_jac_ini[1780] = -23.2849644809540
    sp_jac_ini[1781] = -39.6392229058202
    sp_jac_ini[1782] = -10.2713736253513
    sp_jac_ini[1783] = -242.095286143588
    sp_jac_ini[1784] = -113.786109551688
    sp_jac_ini[1785] = 88.4888280826460
    sp_jac_ini[1786] = 18.6937810814837
    sp_jac_ini[1787] = 58.9235503101833
    sp_jac_ini[1788] = 45.7766907664085
    sp_jac_ini[1789] = 88.4888280826460
    sp_jac_ini[1790] = 18.6937810814837
    sp_jac_ini[1791] = 105.571769313180
    sp_jac_ini[1792] = 54.0657727682604
    sp_jac_ini[1793] = -39.6392229058202
    sp_jac_ini[1794] = -10.2713736253513
    sp_jac_ini[1795] = -24.9575997948692
    sp_jac_ini[1796] = -23.2849644809540
    sp_jac_ini[1797] = -39.6392229058202
    sp_jac_ini[1798] = -10.2713736253513
    sp_jac_ini[1799] = -5.65456401516768
    sp_jac_ini[1800] = 30.9517475172273
    sp_jac_ini[1801] = -1.84896616921897
    sp_jac_ini[1802] = -9.21038227100566
    sp_jac_ini[1803] = -0.793238195499529
    sp_jac_ini[1804] = -9.00835072044485
    sp_jac_ini[1805] = -1.84896616921897
    sp_jac_ini[1806] = -9.21038227100566
    sp_jac_ini[1807] = -54.0657727682604
    sp_jac_ini[1808] = 105.571769313180
    sp_jac_ini[1809] = 10.2713736253513
    sp_jac_ini[1810] = -39.6392229058202
    sp_jac_ini[1811] = 23.2849644809540
    sp_jac_ini[1812] = -24.9575997948692
    sp_jac_ini[1813] = 10.2713736253513
    sp_jac_ini[1814] = -39.6392229058202
    sp_jac_ini[1815] = 113.786109551688
    sp_jac_ini[1816] = -242.095286143588
    sp_jac_ini[1817] = -18.6937810814837
    sp_jac_ini[1818] = 88.4888280826460
    sp_jac_ini[1819] = -45.7766907664085
    sp_jac_ini[1820] = 58.9235503101833
    sp_jac_ini[1821] = -18.6937810814837
    sp_jac_ini[1822] = 88.4888280826460
    sp_jac_ini[1823] = -54.0657727682604
    sp_jac_ini[1824] = 105.571769313180
    sp_jac_ini[1825] = 10.2713736253513
    sp_jac_ini[1826] = -39.6392229058202
    sp_jac_ini[1827] = 23.2849644809540
    sp_jac_ini[1828] = -24.9575997948692
    sp_jac_ini[1829] = 10.2713736253513
    sp_jac_ini[1830] = -39.6392229058202
    sp_jac_ini[1831] = -9.21038227100566
    sp_jac_ini[1832] = 1.84896616921897
    sp_jac_ini[1833] = 30.9517475172273
    sp_jac_ini[1834] = 5.65456401516768
    sp_jac_ini[1835] = -9.21038227100566
    sp_jac_ini[1836] = 1.84896616921897
    sp_jac_ini[1837] = -9.00835072044485
    sp_jac_ini[1838] = 0.793238195499528
    sp_jac_ini[1839] = -39.6392229058202
    sp_jac_ini[1840] = -10.2713736253513
    sp_jac_ini[1841] = 105.571769313180
    sp_jac_ini[1842] = 54.0657727682604
    sp_jac_ini[1843] = -39.6392229058201
    sp_jac_ini[1844] = -10.2713736253513
    sp_jac_ini[1845] = -24.9575997948692
    sp_jac_ini[1846] = -23.2849644809540
    sp_jac_ini[1847] = 88.4888280826460
    sp_jac_ini[1848] = 18.6937810814837
    sp_jac_ini[1849] = -242.095286143588
    sp_jac_ini[1850] = -113.786109551688
    sp_jac_ini[1851] = 88.4888280826460
    sp_jac_ini[1852] = 18.6937810814837
    sp_jac_ini[1853] = 58.9235503101833
    sp_jac_ini[1854] = 45.7766907664085
    sp_jac_ini[1855] = -39.6392229058202
    sp_jac_ini[1856] = -10.2713736253513
    sp_jac_ini[1857] = 105.571769313180
    sp_jac_ini[1858] = 54.0657727682604
    sp_jac_ini[1859] = -39.6392229058201
    sp_jac_ini[1860] = -10.2713736253513
    sp_jac_ini[1861] = -24.9575997948692
    sp_jac_ini[1862] = -23.2849644809540
    sp_jac_ini[1863] = -1.84896616921897
    sp_jac_ini[1864] = -9.21038227100566
    sp_jac_ini[1865] = -5.65456401516768
    sp_jac_ini[1866] = 30.9517475172273
    sp_jac_ini[1867] = -1.84896616921897
    sp_jac_ini[1868] = -9.21038227100566
    sp_jac_ini[1869] = -0.793238195499528
    sp_jac_ini[1870] = -9.00835072044485
    sp_jac_ini[1871] = 10.2713736253513
    sp_jac_ini[1872] = -39.6392229058202
    sp_jac_ini[1873] = -54.0657727682604
    sp_jac_ini[1874] = 105.571769313180
    sp_jac_ini[1875] = 10.2713736253513
    sp_jac_ini[1876] = -39.6392229058201
    sp_jac_ini[1877] = 23.2849644809540
    sp_jac_ini[1878] = -24.9575997948692
    sp_jac_ini[1879] = -18.6937810814837
    sp_jac_ini[1880] = 88.4888280826460
    sp_jac_ini[1881] = 113.786109551688
    sp_jac_ini[1882] = -242.095286143588
    sp_jac_ini[1883] = -18.6937810814837
    sp_jac_ini[1884] = 88.4888280826460
    sp_jac_ini[1885] = -45.7766907664085
    sp_jac_ini[1886] = 58.9235503101833
    sp_jac_ini[1887] = 10.2713736253513
    sp_jac_ini[1888] = -39.6392229058202
    sp_jac_ini[1889] = -54.0657727682604
    sp_jac_ini[1890] = 105.571769313180
    sp_jac_ini[1891] = 10.2713736253513
    sp_jac_ini[1892] = -39.6392229058201
    sp_jac_ini[1893] = 23.2849644809540
    sp_jac_ini[1894] = -24.9575997948692
    sp_jac_ini[1895] = -9.00835072044484
    sp_jac_ini[1896] = 0.793238195499527
    sp_jac_ini[1897] = -9.21038227100566
    sp_jac_ini[1898] = 1.84896616921897
    sp_jac_ini[1899] = 30.9517475172273
    sp_jac_ini[1900] = 5.65456401516768
    sp_jac_ini[1901] = -9.21038227100566
    sp_jac_ini[1902] = 1.84896616921897
    sp_jac_ini[1903] = -24.9575997948692
    sp_jac_ini[1904] = -23.2849644809540
    sp_jac_ini[1905] = -39.6392229058202
    sp_jac_ini[1906] = -10.2713736253513
    sp_jac_ini[1907] = 105.571769313180
    sp_jac_ini[1908] = 54.0657727682604
    sp_jac_ini[1909] = -39.6392229058201
    sp_jac_ini[1910] = -10.2713736253514
    sp_jac_ini[1911] = 58.9235503101833
    sp_jac_ini[1912] = 45.7766907664085
    sp_jac_ini[1913] = 88.4888280826461
    sp_jac_ini[1914] = 18.6937810814837
    sp_jac_ini[1915] = -242.095286143588
    sp_jac_ini[1916] = -113.786109551688
    sp_jac_ini[1917] = 88.4888280826459
    sp_jac_ini[1918] = 18.6937810814837
    sp_jac_ini[1919] = -24.9575997948692
    sp_jac_ini[1920] = -23.2849644809540
    sp_jac_ini[1921] = -39.6392229058202
    sp_jac_ini[1922] = -10.2713736253513
    sp_jac_ini[1923] = 105.571769313180
    sp_jac_ini[1924] = 54.0657727682604
    sp_jac_ini[1925] = -39.6392229058201
    sp_jac_ini[1926] = -10.2713736253514
    sp_jac_ini[1927] = -0.793238195499527
    sp_jac_ini[1928] = -9.00835072044484
    sp_jac_ini[1929] = -1.84896616921897
    sp_jac_ini[1930] = -9.21038227100566
    sp_jac_ini[1931] = -5.65456401516768
    sp_jac_ini[1932] = 30.9517475172273
    sp_jac_ini[1933] = -1.84896616921897
    sp_jac_ini[1934] = -9.21038227100566
    sp_jac_ini[1935] = 23.2849644809540
    sp_jac_ini[1936] = -24.9575997948692
    sp_jac_ini[1937] = 10.2713736253513
    sp_jac_ini[1938] = -39.6392229058202
    sp_jac_ini[1939] = -54.0657727682604
    sp_jac_ini[1940] = 105.571769313180
    sp_jac_ini[1941] = 10.2713736253514
    sp_jac_ini[1942] = -39.6392229058201
    sp_jac_ini[1943] = -45.7766907664085
    sp_jac_ini[1944] = 58.9235503101833
    sp_jac_ini[1945] = -18.6937810814837
    sp_jac_ini[1946] = 88.4888280826461
    sp_jac_ini[1947] = 113.786109551688
    sp_jac_ini[1948] = -242.095286143588
    sp_jac_ini[1949] = -18.6937810814837
    sp_jac_ini[1950] = 88.4888280826459
    sp_jac_ini[1951] = 23.2849644809540
    sp_jac_ini[1952] = -24.9575997948692
    sp_jac_ini[1953] = 10.2713736253513
    sp_jac_ini[1954] = -39.6392229058202
    sp_jac_ini[1955] = -54.0657727682604
    sp_jac_ini[1956] = 105.571769313180
    sp_jac_ini[1957] = 10.2713736253514
    sp_jac_ini[1958] = -39.6392229058201
    sp_jac_ini[1959] = -9.21038227100566
    sp_jac_ini[1960] = 1.84896616921897
    sp_jac_ini[1961] = -9.00835072044485
    sp_jac_ini[1962] = 0.793238195499527
    sp_jac_ini[1963] = -9.21038227100566
    sp_jac_ini[1964] = 1.84896616921897
    sp_jac_ini[1965] = 30.9517475172273
    sp_jac_ini[1966] = 5.65456401516768
    sp_jac_ini[1967] = -39.6392229058202
    sp_jac_ini[1968] = -10.2713736253513
    sp_jac_ini[1969] = -24.9575997948692
    sp_jac_ini[1970] = -23.2849644809540
    sp_jac_ini[1971] = -39.6392229058202
    sp_jac_ini[1972] = -10.2713736253513
    sp_jac_ini[1973] = 105.571769313180
    sp_jac_ini[1974] = 54.0657727682604
    sp_jac_ini[1975] = 88.4888280826460
    sp_jac_ini[1976] = 18.6937810814837
    sp_jac_ini[1977] = 58.9235503101832
    sp_jac_ini[1978] = 45.7766907664085
    sp_jac_ini[1979] = 88.4888280826460
    sp_jac_ini[1980] = 18.6937810814837
    sp_jac_ini[1981] = -242.120286143588
    sp_jac_ini[1982] = -113.786109551688
    sp_jac_ini[1983] = -39.6392229058202
    sp_jac_ini[1984] = -10.2713736253513
    sp_jac_ini[1985] = -24.9575997948692
    sp_jac_ini[1986] = -23.2849644809540
    sp_jac_ini[1987] = -39.6392229058202
    sp_jac_ini[1988] = -10.2713736253513
    sp_jac_ini[1989] = 105.571769313180
    sp_jac_ini[1990] = 54.0657727682604
    sp_jac_ini[1991] = -1.84896616921897
    sp_jac_ini[1992] = -9.21038227100566
    sp_jac_ini[1993] = -0.793238195499527
    sp_jac_ini[1994] = -9.00835072044485
    sp_jac_ini[1995] = -1.84896616921897
    sp_jac_ini[1996] = -9.21038227100566
    sp_jac_ini[1997] = -5.65456401516768
    sp_jac_ini[1998] = 30.9517475172273
    sp_jac_ini[1999] = 10.2713736253513
    sp_jac_ini[2000] = -39.6392229058202
    sp_jac_ini[2001] = 23.2849644809540
    sp_jac_ini[2002] = -24.9575997948692
    sp_jac_ini[2003] = 10.2713736253513
    sp_jac_ini[2004] = -39.6392229058202
    sp_jac_ini[2005] = -54.0657727682604
    sp_jac_ini[2006] = 105.571769313180
    sp_jac_ini[2007] = -18.6937810814837
    sp_jac_ini[2008] = 88.4888280826460
    sp_jac_ini[2009] = -45.7766907664085
    sp_jac_ini[2010] = 58.9235503101832
    sp_jac_ini[2011] = -18.6937810814837
    sp_jac_ini[2012] = 88.4888280826460
    sp_jac_ini[2013] = 113.786109551688
    sp_jac_ini[2014] = -242.120286143588
    sp_jac_ini[2015] = 10.2713736253513
    sp_jac_ini[2016] = -39.6392229058202
    sp_jac_ini[2017] = 23.2849644809540
    sp_jac_ini[2018] = -24.9575997948692
    sp_jac_ini[2019] = 10.2713736253513
    sp_jac_ini[2020] = -39.6392229058202
    sp_jac_ini[2021] = -54.0657727682604
    sp_jac_ini[2022] = 105.571769313180
    sp_jac_ini[2023] = 105.571769313180
    sp_jac_ini[2024] = 54.0657727682604
    sp_jac_ini[2025] = -39.6392229058202
    sp_jac_ini[2026] = -10.2713736253513
    sp_jac_ini[2027] = -24.9575997948692
    sp_jac_ini[2028] = -23.2849644809540
    sp_jac_ini[2029] = -39.6392229058202
    sp_jac_ini[2030] = -10.2713736253513
    sp_jac_ini[2031] = -211.143538626360
    sp_jac_ini[2032] = -108.131545536521
    sp_jac_ini[2033] = 79.2784458116403
    sp_jac_ini[2034] = 20.5427472507027
    sp_jac_ini[2035] = 49.9151995897384
    sp_jac_ini[2036] = 46.5699289619080
    sp_jac_ini[2037] = 79.2784458116403
    sp_jac_ini[2038] = 20.5427472507027
    sp_jac_ini[2039] = 105.571769313180
    sp_jac_ini[2040] = 54.0657727682604
    sp_jac_ini[2041] = -39.6392229058202
    sp_jac_ini[2042] = -10.2713736253513
    sp_jac_ini[2043] = -24.9575997948692
    sp_jac_ini[2044] = -23.2849644809540
    sp_jac_ini[2045] = -39.6392229058202
    sp_jac_ini[2046] = -10.2713736253513
    sp_jac_ini[2047] = -54.0657727682604
    sp_jac_ini[2048] = 105.571769313180
    sp_jac_ini[2049] = 10.2713736253513
    sp_jac_ini[2050] = -39.6392229058202
    sp_jac_ini[2051] = 23.2849644809540
    sp_jac_ini[2052] = -24.9575997948692
    sp_jac_ini[2053] = 10.2713736253513
    sp_jac_ini[2054] = -39.6392229058202
    sp_jac_ini[2055] = 108.131545536521
    sp_jac_ini[2056] = -211.143538626360
    sp_jac_ini[2057] = -20.5427472507027
    sp_jac_ini[2058] = 79.2784458116403
    sp_jac_ini[2059] = -46.5699289619080
    sp_jac_ini[2060] = 49.9151995897384
    sp_jac_ini[2061] = -20.5427472507027
    sp_jac_ini[2062] = 79.2784458116403
    sp_jac_ini[2063] = -54.0657727682604
    sp_jac_ini[2064] = 105.571769313180
    sp_jac_ini[2065] = 10.2713736253513
    sp_jac_ini[2066] = -39.6392229058202
    sp_jac_ini[2067] = 23.2849644809540
    sp_jac_ini[2068] = -24.9575997948692
    sp_jac_ini[2069] = 10.2713736253513
    sp_jac_ini[2070] = -39.6392229058202
    sp_jac_ini[2071] = -39.6392229058202
    sp_jac_ini[2072] = -10.2713736253513
    sp_jac_ini[2073] = 105.571769313180
    sp_jac_ini[2074] = 54.0657727682604
    sp_jac_ini[2075] = -39.6392229058201
    sp_jac_ini[2076] = -10.2713736253513
    sp_jac_ini[2077] = -24.9575997948692
    sp_jac_ini[2078] = -23.2849644809540
    sp_jac_ini[2079] = 79.2784458116403
    sp_jac_ini[2080] = 20.5427472507027
    sp_jac_ini[2081] = -211.143538626360
    sp_jac_ini[2082] = -108.131545536521
    sp_jac_ini[2083] = 79.2784458116403
    sp_jac_ini[2084] = 20.5427472507027
    sp_jac_ini[2085] = 49.9151995897384
    sp_jac_ini[2086] = 46.5699289619080
    sp_jac_ini[2087] = -39.6392229058202
    sp_jac_ini[2088] = -10.2713736253513
    sp_jac_ini[2089] = 105.571769313180
    sp_jac_ini[2090] = 54.0657727682604
    sp_jac_ini[2091] = -39.6392229058201
    sp_jac_ini[2092] = -10.2713736253513
    sp_jac_ini[2093] = -24.9575997948692
    sp_jac_ini[2094] = -23.2849644809540
    sp_jac_ini[2095] = 10.2713736253513
    sp_jac_ini[2096] = -39.6392229058202
    sp_jac_ini[2097] = -54.0657727682604
    sp_jac_ini[2098] = 105.571769313180
    sp_jac_ini[2099] = 10.2713736253513
    sp_jac_ini[2100] = -39.6392229058201
    sp_jac_ini[2101] = 23.2849644809540
    sp_jac_ini[2102] = -24.9575997948692
    sp_jac_ini[2103] = -20.5427472507027
    sp_jac_ini[2104] = 79.2784458116403
    sp_jac_ini[2105] = 108.131545536521
    sp_jac_ini[2106] = -211.143538626360
    sp_jac_ini[2107] = -20.5427472507027
    sp_jac_ini[2108] = 79.2784458116403
    sp_jac_ini[2109] = -46.5699289619080
    sp_jac_ini[2110] = 49.9151995897384
    sp_jac_ini[2111] = 10.2713736253513
    sp_jac_ini[2112] = -39.6392229058202
    sp_jac_ini[2113] = -54.0657727682604
    sp_jac_ini[2114] = 105.571769313180
    sp_jac_ini[2115] = 10.2713736253513
    sp_jac_ini[2116] = -39.6392229058201
    sp_jac_ini[2117] = 23.2849644809540
    sp_jac_ini[2118] = -24.9575997948692
    sp_jac_ini[2119] = -24.9575997948692
    sp_jac_ini[2120] = -23.2849644809540
    sp_jac_ini[2121] = -39.6392229058202
    sp_jac_ini[2122] = -10.2713736253513
    sp_jac_ini[2123] = 105.571769313180
    sp_jac_ini[2124] = 54.0657727682604
    sp_jac_ini[2125] = -39.6392229058201
    sp_jac_ini[2126] = -10.2713736253514
    sp_jac_ini[2127] = 49.9151995897384
    sp_jac_ini[2128] = 46.5699289619080
    sp_jac_ini[2129] = 79.2784458116404
    sp_jac_ini[2130] = 20.5427472507027
    sp_jac_ini[2131] = -211.143538626360
    sp_jac_ini[2132] = -108.131545536521
    sp_jac_ini[2133] = 79.2784458116403
    sp_jac_ini[2134] = 20.5427472507027
    sp_jac_ini[2135] = -24.9575997948692
    sp_jac_ini[2136] = -23.2849644809540
    sp_jac_ini[2137] = -39.6392229058202
    sp_jac_ini[2138] = -10.2713736253513
    sp_jac_ini[2139] = 105.571769313180
    sp_jac_ini[2140] = 54.0657727682604
    sp_jac_ini[2141] = -39.6392229058201
    sp_jac_ini[2142] = -10.2713736253514
    sp_jac_ini[2143] = 23.2849644809540
    sp_jac_ini[2144] = -24.9575997948692
    sp_jac_ini[2145] = 10.2713736253513
    sp_jac_ini[2146] = -39.6392229058202
    sp_jac_ini[2147] = -54.0657727682604
    sp_jac_ini[2148] = 105.571769313180
    sp_jac_ini[2149] = 10.2713736253514
    sp_jac_ini[2150] = -39.6392229058201
    sp_jac_ini[2151] = -46.5699289619080
    sp_jac_ini[2152] = 49.9151995897384
    sp_jac_ini[2153] = -20.5427472507027
    sp_jac_ini[2154] = 79.2784458116404
    sp_jac_ini[2155] = 108.131545536521
    sp_jac_ini[2156] = -211.143538626360
    sp_jac_ini[2157] = -20.5427472507027
    sp_jac_ini[2158] = 79.2784458116403
    sp_jac_ini[2159] = 23.2849644809540
    sp_jac_ini[2160] = -24.9575997948692
    sp_jac_ini[2161] = 10.2713736253513
    sp_jac_ini[2162] = -39.6392229058202
    sp_jac_ini[2163] = -54.0657727682604
    sp_jac_ini[2164] = 105.571769313180
    sp_jac_ini[2165] = 10.2713736253514
    sp_jac_ini[2166] = -39.6392229058201
    sp_jac_ini[2167] = -39.6392229058202
    sp_jac_ini[2168] = -10.2713736253513
    sp_jac_ini[2169] = -24.9575997948692
    sp_jac_ini[2170] = -23.2849644809540
    sp_jac_ini[2171] = -39.6392229058202
    sp_jac_ini[2172] = -10.2713736253513
    sp_jac_ini[2173] = 105.571769313180
    sp_jac_ini[2174] = 54.0657727682604
    sp_jac_ini[2175] = 79.2784458116403
    sp_jac_ini[2176] = 20.5427472507027
    sp_jac_ini[2177] = 49.9151995897384
    sp_jac_ini[2178] = 46.5699289619080
    sp_jac_ini[2179] = 79.2784458116403
    sp_jac_ini[2180] = 20.5427472507027
    sp_jac_ini[2181] = -211.143538626360
    sp_jac_ini[2182] = -108.131545536521
    sp_jac_ini[2183] = -39.6392229058202
    sp_jac_ini[2184] = -10.2713736253513
    sp_jac_ini[2185] = -24.9575997948692
    sp_jac_ini[2186] = -23.2849644809540
    sp_jac_ini[2187] = -39.6392229058202
    sp_jac_ini[2188] = -10.2713736253513
    sp_jac_ini[2189] = 105.571769313180
    sp_jac_ini[2190] = 54.0657727682604
    sp_jac_ini[2191] = 10.2713736253513
    sp_jac_ini[2192] = -39.6392229058202
    sp_jac_ini[2193] = 23.2849644809540
    sp_jac_ini[2194] = -24.9575997948692
    sp_jac_ini[2195] = 10.2713736253513
    sp_jac_ini[2196] = -39.6392229058202
    sp_jac_ini[2197] = -54.0657727682604
    sp_jac_ini[2198] = 105.571769313180
    sp_jac_ini[2199] = -20.5427472507027
    sp_jac_ini[2200] = 79.2784458116403
    sp_jac_ini[2201] = -46.5699289619080
    sp_jac_ini[2202] = 49.9151995897384
    sp_jac_ini[2203] = -20.5427472507027
    sp_jac_ini[2204] = 79.2784458116403
    sp_jac_ini[2205] = 108.131545536521
    sp_jac_ini[2206] = -211.143538626360
    sp_jac_ini[2207] = 10.2713736253513
    sp_jac_ini[2208] = -39.6392229058202
    sp_jac_ini[2209] = 23.2849644809540
    sp_jac_ini[2210] = -24.9575997948692
    sp_jac_ini[2211] = 10.2713736253513
    sp_jac_ini[2212] = -39.6392229058202
    sp_jac_ini[2213] = -54.0657727682604
    sp_jac_ini[2214] = 105.571769313180
    sp_jac_ini[2215] = 105.571769313180
    sp_jac_ini[2216] = 54.0657727682604
    sp_jac_ini[2217] = -39.6392229058202
    sp_jac_ini[2218] = -10.2713736253513
    sp_jac_ini[2219] = -24.9575997948692
    sp_jac_ini[2220] = -23.2849644809540
    sp_jac_ini[2221] = -39.6392229058202
    sp_jac_ini[2222] = -10.2713736253513
    sp_jac_ini[2223] = -211.143538626360
    sp_jac_ini[2224] = -108.131545536521
    sp_jac_ini[2225] = 79.2784458116403
    sp_jac_ini[2226] = 20.5427472507027
    sp_jac_ini[2227] = 49.9151995897384
    sp_jac_ini[2228] = 46.5699289619080
    sp_jac_ini[2229] = 79.2784458116403
    sp_jac_ini[2230] = 20.5427472507027
    sp_jac_ini[2231] = 105.571769313180
    sp_jac_ini[2232] = 54.0657727682604
    sp_jac_ini[2233] = -39.6392229058202
    sp_jac_ini[2234] = -10.2713736253513
    sp_jac_ini[2235] = -24.9575997948692
    sp_jac_ini[2236] = -23.2849644809540
    sp_jac_ini[2237] = -39.6392229058202
    sp_jac_ini[2238] = -10.2713736253513
    sp_jac_ini[2239] = -54.0657727682604
    sp_jac_ini[2240] = 105.571769313180
    sp_jac_ini[2241] = 10.2713736253513
    sp_jac_ini[2242] = -39.6392229058202
    sp_jac_ini[2243] = 23.2849644809540
    sp_jac_ini[2244] = -24.9575997948692
    sp_jac_ini[2245] = 10.2713736253513
    sp_jac_ini[2246] = -39.6392229058202
    sp_jac_ini[2247] = 108.131545536521
    sp_jac_ini[2248] = -211.143538626360
    sp_jac_ini[2249] = -20.5427472507027
    sp_jac_ini[2250] = 79.2784458116403
    sp_jac_ini[2251] = -46.5699289619080
    sp_jac_ini[2252] = 49.9151995897384
    sp_jac_ini[2253] = -20.5427472507027
    sp_jac_ini[2254] = 79.2784458116403
    sp_jac_ini[2255] = -54.0657727682604
    sp_jac_ini[2256] = 105.571769313180
    sp_jac_ini[2257] = 10.2713736253513
    sp_jac_ini[2258] = -39.6392229058202
    sp_jac_ini[2259] = 23.2849644809540
    sp_jac_ini[2260] = -24.9575997948692
    sp_jac_ini[2261] = 10.2713736253513
    sp_jac_ini[2262] = -39.6392229058202
    sp_jac_ini[2263] = -39.6392229058202
    sp_jac_ini[2264] = -10.2713736253513
    sp_jac_ini[2265] = 105.571769313180
    sp_jac_ini[2266] = 54.0657727682604
    sp_jac_ini[2267] = -39.6392229058201
    sp_jac_ini[2268] = -10.2713736253513
    sp_jac_ini[2269] = -24.9575997948692
    sp_jac_ini[2270] = -23.2849644809540
    sp_jac_ini[2271] = 79.2784458116403
    sp_jac_ini[2272] = 20.5427472507027
    sp_jac_ini[2273] = -211.143538626360
    sp_jac_ini[2274] = -108.131545536521
    sp_jac_ini[2275] = 79.2784458116403
    sp_jac_ini[2276] = 20.5427472507027
    sp_jac_ini[2277] = 49.9151995897384
    sp_jac_ini[2278] = 46.5699289619080
    sp_jac_ini[2279] = -39.6392229058202
    sp_jac_ini[2280] = -10.2713736253513
    sp_jac_ini[2281] = 105.571769313180
    sp_jac_ini[2282] = 54.0657727682604
    sp_jac_ini[2283] = -39.6392229058201
    sp_jac_ini[2284] = -10.2713736253513
    sp_jac_ini[2285] = -24.9575997948692
    sp_jac_ini[2286] = -23.2849644809540
    sp_jac_ini[2287] = 10.2713736253513
    sp_jac_ini[2288] = -39.6392229058202
    sp_jac_ini[2289] = -54.0657727682604
    sp_jac_ini[2290] = 105.571769313180
    sp_jac_ini[2291] = 10.2713736253513
    sp_jac_ini[2292] = -39.6392229058201
    sp_jac_ini[2293] = 23.2849644809540
    sp_jac_ini[2294] = -24.9575997948692
    sp_jac_ini[2295] = -20.5427472507027
    sp_jac_ini[2296] = 79.2784458116403
    sp_jac_ini[2297] = 108.131545536521
    sp_jac_ini[2298] = -211.143538626360
    sp_jac_ini[2299] = -20.5427472507027
    sp_jac_ini[2300] = 79.2784458116403
    sp_jac_ini[2301] = -46.5699289619080
    sp_jac_ini[2302] = 49.9151995897384
    sp_jac_ini[2303] = 10.2713736253513
    sp_jac_ini[2304] = -39.6392229058202
    sp_jac_ini[2305] = -54.0657727682604
    sp_jac_ini[2306] = 105.571769313180
    sp_jac_ini[2307] = 10.2713736253513
    sp_jac_ini[2308] = -39.6392229058201
    sp_jac_ini[2309] = 23.2849644809540
    sp_jac_ini[2310] = -24.9575997948692
    sp_jac_ini[2311] = -24.9575997948692
    sp_jac_ini[2312] = -23.2849644809540
    sp_jac_ini[2313] = -39.6392229058202
    sp_jac_ini[2314] = -10.2713736253513
    sp_jac_ini[2315] = 105.571769313180
    sp_jac_ini[2316] = 54.0657727682604
    sp_jac_ini[2317] = -39.6392229058201
    sp_jac_ini[2318] = -10.2713736253514
    sp_jac_ini[2319] = 49.9151995897384
    sp_jac_ini[2320] = 46.5699289619080
    sp_jac_ini[2321] = 79.2784458116404
    sp_jac_ini[2322] = 20.5427472507027
    sp_jac_ini[2323] = -211.143538626360
    sp_jac_ini[2324] = -108.131545536521
    sp_jac_ini[2325] = 79.2784458116403
    sp_jac_ini[2326] = 20.5427472507027
    sp_jac_ini[2327] = -24.9575997948692
    sp_jac_ini[2328] = -23.2849644809540
    sp_jac_ini[2329] = -39.6392229058202
    sp_jac_ini[2330] = -10.2713736253513
    sp_jac_ini[2331] = 105.571769313180
    sp_jac_ini[2332] = 54.0657727682604
    sp_jac_ini[2333] = -39.6392229058201
    sp_jac_ini[2334] = -10.2713736253514
    sp_jac_ini[2335] = 23.2849644809540
    sp_jac_ini[2336] = -24.9575997948692
    sp_jac_ini[2337] = 10.2713736253513
    sp_jac_ini[2338] = -39.6392229058202
    sp_jac_ini[2339] = -54.0657727682604
    sp_jac_ini[2340] = 105.571769313180
    sp_jac_ini[2341] = 10.2713736253514
    sp_jac_ini[2342] = -39.6392229058201
    sp_jac_ini[2343] = -46.5699289619080
    sp_jac_ini[2344] = 49.9151995897384
    sp_jac_ini[2345] = -20.5427472507027
    sp_jac_ini[2346] = 79.2784458116404
    sp_jac_ini[2347] = 108.131545536521
    sp_jac_ini[2348] = -211.143538626360
    sp_jac_ini[2349] = -20.5427472507027
    sp_jac_ini[2350] = 79.2784458116403
    sp_jac_ini[2351] = 23.2849644809540
    sp_jac_ini[2352] = -24.9575997948692
    sp_jac_ini[2353] = 10.2713736253513
    sp_jac_ini[2354] = -39.6392229058202
    sp_jac_ini[2355] = -54.0657727682604
    sp_jac_ini[2356] = 105.571769313180
    sp_jac_ini[2357] = 10.2713736253514
    sp_jac_ini[2358] = -39.6392229058201
    sp_jac_ini[2359] = -39.6392229058202
    sp_jac_ini[2360] = -10.2713736253513
    sp_jac_ini[2361] = -24.9575997948692
    sp_jac_ini[2362] = -23.2849644809540
    sp_jac_ini[2363] = -39.6392229058202
    sp_jac_ini[2364] = -10.2713736253513
    sp_jac_ini[2365] = 105.571769313180
    sp_jac_ini[2366] = 54.0657727682604
    sp_jac_ini[2367] = 79.2784458116403
    sp_jac_ini[2368] = 20.5427472507027
    sp_jac_ini[2369] = 49.9151995897384
    sp_jac_ini[2370] = 46.5699289619080
    sp_jac_ini[2371] = 79.2784458116403
    sp_jac_ini[2372] = 20.5427472507027
    sp_jac_ini[2373] = -211.168538626360
    sp_jac_ini[2374] = -108.131545536521
    sp_jac_ini[2375] = -39.6392229058202
    sp_jac_ini[2376] = -10.2713736253513
    sp_jac_ini[2377] = -24.9575997948692
    sp_jac_ini[2378] = -23.2849644809540
    sp_jac_ini[2379] = -39.6392229058202
    sp_jac_ini[2380] = -10.2713736253513
    sp_jac_ini[2381] = 105.571769313180
    sp_jac_ini[2382] = 54.0657727682604
    sp_jac_ini[2383] = 10.2713736253513
    sp_jac_ini[2384] = -39.6392229058202
    sp_jac_ini[2385] = 23.2849644809540
    sp_jac_ini[2386] = -24.9575997948692
    sp_jac_ini[2387] = 10.2713736253513
    sp_jac_ini[2388] = -39.6392229058202
    sp_jac_ini[2389] = -54.0657727682604
    sp_jac_ini[2390] = 105.571769313180
    sp_jac_ini[2391] = -20.5427472507027
    sp_jac_ini[2392] = 79.2784458116403
    sp_jac_ini[2393] = -46.5699289619080
    sp_jac_ini[2394] = 49.9151995897384
    sp_jac_ini[2395] = -20.5427472507027
    sp_jac_ini[2396] = 79.2784458116403
    sp_jac_ini[2397] = 108.131545536521
    sp_jac_ini[2398] = -211.168538626360
    sp_jac_ini[2399] = 10.2713736253513
    sp_jac_ini[2400] = -39.6392229058202
    sp_jac_ini[2401] = 23.2849644809540
    sp_jac_ini[2402] = -24.9575997948692
    sp_jac_ini[2403] = 10.2713736253513
    sp_jac_ini[2404] = -39.6392229058202
    sp_jac_ini[2405] = -54.0657727682604
    sp_jac_ini[2406] = 105.571769313180
    sp_jac_ini[2407] = 30.9517475172273
    sp_jac_ini[2408] = 5.65456401516768
    sp_jac_ini[2409] = -9.21038227100566
    sp_jac_ini[2410] = 1.84896616921897
    sp_jac_ini[2411] = -9.00835072044485
    sp_jac_ini[2412] = 0.793238195499529
    sp_jac_ini[2413] = -9.21038227100566
    sp_jac_ini[2414] = 1.84896616921897
    sp_jac_ini[2415] = 105.571769313180
    sp_jac_ini[2416] = 54.0657727682604
    sp_jac_ini[2417] = -39.6392229058202
    sp_jac_ini[2418] = -10.2713736253513
    sp_jac_ini[2419] = -24.9575997948692
    sp_jac_ini[2420] = -23.2849644809540
    sp_jac_ini[2421] = -39.6392229058202
    sp_jac_ini[2422] = -10.2713736253513
    sp_jac_ini[2423] = -242.095286143588
    sp_jac_ini[2424] = -113.786109551688
    sp_jac_ini[2425] = 88.4888280826460
    sp_jac_ini[2426] = 18.6937810814837
    sp_jac_ini[2427] = 58.9235503101833
    sp_jac_ini[2428] = 45.7766907664085
    sp_jac_ini[2429] = 88.4888280826460
    sp_jac_ini[2430] = 18.6937810814837
    sp_jac_ini[2431] = 105.571769313180
    sp_jac_ini[2432] = 54.0657727682604
    sp_jac_ini[2433] = -39.6392229058202
    sp_jac_ini[2434] = -10.2713736253513
    sp_jac_ini[2435] = -24.9575997948692
    sp_jac_ini[2436] = -23.2849644809540
    sp_jac_ini[2437] = -39.6392229058202
    sp_jac_ini[2438] = -10.2713736253513
    sp_jac_ini[2439] = -5.65456401516768
    sp_jac_ini[2440] = 30.9517475172273
    sp_jac_ini[2441] = -1.84896616921897
    sp_jac_ini[2442] = -9.21038227100566
    sp_jac_ini[2443] = -0.793238195499529
    sp_jac_ini[2444] = -9.00835072044485
    sp_jac_ini[2445] = -1.84896616921897
    sp_jac_ini[2446] = -9.21038227100566
    sp_jac_ini[2447] = -54.0657727682604
    sp_jac_ini[2448] = 105.571769313180
    sp_jac_ini[2449] = 10.2713736253513
    sp_jac_ini[2450] = -39.6392229058202
    sp_jac_ini[2451] = 23.2849644809540
    sp_jac_ini[2452] = -24.9575997948692
    sp_jac_ini[2453] = 10.2713736253513
    sp_jac_ini[2454] = -39.6392229058202
    sp_jac_ini[2455] = 113.786109551688
    sp_jac_ini[2456] = -242.095286143588
    sp_jac_ini[2457] = -18.6937810814837
    sp_jac_ini[2458] = 88.4888280826460
    sp_jac_ini[2459] = -45.7766907664085
    sp_jac_ini[2460] = 58.9235503101833
    sp_jac_ini[2461] = -18.6937810814837
    sp_jac_ini[2462] = 88.4888280826460
    sp_jac_ini[2463] = -54.0657727682604
    sp_jac_ini[2464] = 105.571769313180
    sp_jac_ini[2465] = 10.2713736253513
    sp_jac_ini[2466] = -39.6392229058202
    sp_jac_ini[2467] = 23.2849644809540
    sp_jac_ini[2468] = -24.9575997948692
    sp_jac_ini[2469] = 10.2713736253513
    sp_jac_ini[2470] = -39.6392229058202
    sp_jac_ini[2471] = -9.21038227100566
    sp_jac_ini[2472] = 1.84896616921897
    sp_jac_ini[2473] = 30.9517475172273
    sp_jac_ini[2474] = 5.65456401516768
    sp_jac_ini[2475] = -9.21038227100566
    sp_jac_ini[2476] = 1.84896616921897
    sp_jac_ini[2477] = -9.00835072044485
    sp_jac_ini[2478] = 0.793238195499528
    sp_jac_ini[2479] = -39.6392229058202
    sp_jac_ini[2480] = -10.2713736253513
    sp_jac_ini[2481] = 105.571769313180
    sp_jac_ini[2482] = 54.0657727682604
    sp_jac_ini[2483] = -39.6392229058201
    sp_jac_ini[2484] = -10.2713736253513
    sp_jac_ini[2485] = -24.9575997948692
    sp_jac_ini[2486] = -23.2849644809540
    sp_jac_ini[2487] = 88.4888280826460
    sp_jac_ini[2488] = 18.6937810814837
    sp_jac_ini[2489] = -242.095286143588
    sp_jac_ini[2490] = -113.786109551688
    sp_jac_ini[2491] = 88.4888280826460
    sp_jac_ini[2492] = 18.6937810814837
    sp_jac_ini[2493] = 58.9235503101833
    sp_jac_ini[2494] = 45.7766907664085
    sp_jac_ini[2495] = -39.6392229058202
    sp_jac_ini[2496] = -10.2713736253513
    sp_jac_ini[2497] = 105.571769313180
    sp_jac_ini[2498] = 54.0657727682604
    sp_jac_ini[2499] = -39.6392229058201
    sp_jac_ini[2500] = -10.2713736253513
    sp_jac_ini[2501] = -24.9575997948692
    sp_jac_ini[2502] = -23.2849644809540
    sp_jac_ini[2503] = -1.84896616921897
    sp_jac_ini[2504] = -9.21038227100566
    sp_jac_ini[2505] = -5.65456401516768
    sp_jac_ini[2506] = 30.9517475172273
    sp_jac_ini[2507] = -1.84896616921897
    sp_jac_ini[2508] = -9.21038227100566
    sp_jac_ini[2509] = -0.793238195499528
    sp_jac_ini[2510] = -9.00835072044485
    sp_jac_ini[2511] = 10.2713736253513
    sp_jac_ini[2512] = -39.6392229058202
    sp_jac_ini[2513] = -54.0657727682604
    sp_jac_ini[2514] = 105.571769313180
    sp_jac_ini[2515] = 10.2713736253513
    sp_jac_ini[2516] = -39.6392229058201
    sp_jac_ini[2517] = 23.2849644809540
    sp_jac_ini[2518] = -24.9575997948692
    sp_jac_ini[2519] = -18.6937810814837
    sp_jac_ini[2520] = 88.4888280826460
    sp_jac_ini[2521] = 113.786109551688
    sp_jac_ini[2522] = -242.095286143588
    sp_jac_ini[2523] = -18.6937810814837
    sp_jac_ini[2524] = 88.4888280826460
    sp_jac_ini[2525] = -45.7766907664085
    sp_jac_ini[2526] = 58.9235503101833
    sp_jac_ini[2527] = 10.2713736253513
    sp_jac_ini[2528] = -39.6392229058202
    sp_jac_ini[2529] = -54.0657727682604
    sp_jac_ini[2530] = 105.571769313180
    sp_jac_ini[2531] = 10.2713736253513
    sp_jac_ini[2532] = -39.6392229058201
    sp_jac_ini[2533] = 23.2849644809540
    sp_jac_ini[2534] = -24.9575997948692
    sp_jac_ini[2535] = -9.00835072044484
    sp_jac_ini[2536] = 0.793238195499527
    sp_jac_ini[2537] = -9.21038227100566
    sp_jac_ini[2538] = 1.84896616921897
    sp_jac_ini[2539] = 30.9517475172273
    sp_jac_ini[2540] = 5.65456401516768
    sp_jac_ini[2541] = -9.21038227100566
    sp_jac_ini[2542] = 1.84896616921897
    sp_jac_ini[2543] = -24.9575997948692
    sp_jac_ini[2544] = -23.2849644809540
    sp_jac_ini[2545] = -39.6392229058202
    sp_jac_ini[2546] = -10.2713736253513
    sp_jac_ini[2547] = 105.571769313180
    sp_jac_ini[2548] = 54.0657727682604
    sp_jac_ini[2549] = -39.6392229058201
    sp_jac_ini[2550] = -10.2713736253514
    sp_jac_ini[2551] = 58.9235503101833
    sp_jac_ini[2552] = 45.7766907664085
    sp_jac_ini[2553] = 88.4888280826461
    sp_jac_ini[2554] = 18.6937810814837
    sp_jac_ini[2555] = -242.095286143588
    sp_jac_ini[2556] = -113.786109551688
    sp_jac_ini[2557] = 88.4888280826459
    sp_jac_ini[2558] = 18.6937810814837
    sp_jac_ini[2559] = -24.9575997948692
    sp_jac_ini[2560] = -23.2849644809540
    sp_jac_ini[2561] = -39.6392229058202
    sp_jac_ini[2562] = -10.2713736253513
    sp_jac_ini[2563] = 105.571769313180
    sp_jac_ini[2564] = 54.0657727682604
    sp_jac_ini[2565] = -39.6392229058201
    sp_jac_ini[2566] = -10.2713736253514
    sp_jac_ini[2567] = -0.793238195499527
    sp_jac_ini[2568] = -9.00835072044484
    sp_jac_ini[2569] = -1.84896616921897
    sp_jac_ini[2570] = -9.21038227100566
    sp_jac_ini[2571] = -5.65456401516768
    sp_jac_ini[2572] = 30.9517475172273
    sp_jac_ini[2573] = -1.84896616921897
    sp_jac_ini[2574] = -9.21038227100566
    sp_jac_ini[2575] = 23.2849644809540
    sp_jac_ini[2576] = -24.9575997948692
    sp_jac_ini[2577] = 10.2713736253513
    sp_jac_ini[2578] = -39.6392229058202
    sp_jac_ini[2579] = -54.0657727682604
    sp_jac_ini[2580] = 105.571769313180
    sp_jac_ini[2581] = 10.2713736253514
    sp_jac_ini[2582] = -39.6392229058201
    sp_jac_ini[2583] = -45.7766907664085
    sp_jac_ini[2584] = 58.9235503101833
    sp_jac_ini[2585] = -18.6937810814837
    sp_jac_ini[2586] = 88.4888280826461
    sp_jac_ini[2587] = 113.786109551688
    sp_jac_ini[2588] = -242.095286143588
    sp_jac_ini[2589] = -18.6937810814837
    sp_jac_ini[2590] = 88.4888280826459
    sp_jac_ini[2591] = 23.2849644809540
    sp_jac_ini[2592] = -24.9575997948692
    sp_jac_ini[2593] = 10.2713736253513
    sp_jac_ini[2594] = -39.6392229058202
    sp_jac_ini[2595] = -54.0657727682604
    sp_jac_ini[2596] = 105.571769313180
    sp_jac_ini[2597] = 10.2713736253514
    sp_jac_ini[2598] = -39.6392229058201
    sp_jac_ini[2599] = -9.21038227100566
    sp_jac_ini[2600] = 1.84896616921897
    sp_jac_ini[2601] = -9.00835072044485
    sp_jac_ini[2602] = 0.793238195499527
    sp_jac_ini[2603] = -9.21038227100566
    sp_jac_ini[2604] = 1.84896616921897
    sp_jac_ini[2605] = 30.9517475172273
    sp_jac_ini[2606] = 5.65456401516768
    sp_jac_ini[2607] = -39.6392229058202
    sp_jac_ini[2608] = -10.2713736253513
    sp_jac_ini[2609] = -24.9575997948692
    sp_jac_ini[2610] = -23.2849644809540
    sp_jac_ini[2611] = -39.6392229058202
    sp_jac_ini[2612] = -10.2713736253513
    sp_jac_ini[2613] = 105.571769313180
    sp_jac_ini[2614] = 54.0657727682604
    sp_jac_ini[2615] = 88.4888280826460
    sp_jac_ini[2616] = 18.6937810814837
    sp_jac_ini[2617] = 58.9235503101832
    sp_jac_ini[2618] = 45.7766907664085
    sp_jac_ini[2619] = 88.4888280826460
    sp_jac_ini[2620] = 18.6937810814837
    sp_jac_ini[2621] = -242.095286143588
    sp_jac_ini[2622] = -113.786109551688
    sp_jac_ini[2623] = -39.6392229058202
    sp_jac_ini[2624] = -10.2713736253513
    sp_jac_ini[2625] = -24.9575997948692
    sp_jac_ini[2626] = -23.2849644809540
    sp_jac_ini[2627] = -39.6392229058202
    sp_jac_ini[2628] = -10.2713736253513
    sp_jac_ini[2629] = 105.571769313180
    sp_jac_ini[2630] = 54.0657727682604
    sp_jac_ini[2631] = -1.84896616921897
    sp_jac_ini[2632] = -9.21038227100566
    sp_jac_ini[2633] = -0.793238195499527
    sp_jac_ini[2634] = -9.00835072044485
    sp_jac_ini[2635] = -1.84896616921897
    sp_jac_ini[2636] = -9.21038227100566
    sp_jac_ini[2637] = -5.65456401516768
    sp_jac_ini[2638] = 30.9517475172273
    sp_jac_ini[2639] = 10.2713736253513
    sp_jac_ini[2640] = -39.6392229058202
    sp_jac_ini[2641] = 23.2849644809540
    sp_jac_ini[2642] = -24.9575997948692
    sp_jac_ini[2643] = 10.2713736253513
    sp_jac_ini[2644] = -39.6392229058202
    sp_jac_ini[2645] = -54.0657727682604
    sp_jac_ini[2646] = 105.571769313180
    sp_jac_ini[2647] = -18.6937810814837
    sp_jac_ini[2648] = 88.4888280826460
    sp_jac_ini[2649] = -45.7766907664085
    sp_jac_ini[2650] = 58.9235503101832
    sp_jac_ini[2651] = -18.6937810814837
    sp_jac_ini[2652] = 88.4888280826460
    sp_jac_ini[2653] = 113.786109551688
    sp_jac_ini[2654] = -242.095286143588
    sp_jac_ini[2655] = 10.2713736253513
    sp_jac_ini[2656] = -39.6392229058202
    sp_jac_ini[2657] = 23.2849644809540
    sp_jac_ini[2658] = -24.9575997948692
    sp_jac_ini[2659] = 10.2713736253513
    sp_jac_ini[2660] = -39.6392229058202
    sp_jac_ini[2661] = -54.0657727682604
    sp_jac_ini[2662] = 105.571769313180
    sp_jac_ini[2663] = 30.9517475172273
    sp_jac_ini[2664] = 5.65456401516768
    sp_jac_ini[2665] = -9.21038227100566
    sp_jac_ini[2666] = 1.84896616921897
    sp_jac_ini[2667] = -9.00835072044485
    sp_jac_ini[2668] = 0.793238195499529
    sp_jac_ini[2669] = -9.21038227100566
    sp_jac_ini[2670] = 1.84896616921897
    sp_jac_ini[2671] = 105.571769313180
    sp_jac_ini[2672] = 54.0657727682604
    sp_jac_ini[2673] = -39.6392229058202
    sp_jac_ini[2674] = -10.2713736253513
    sp_jac_ini[2675] = -24.9575997948692
    sp_jac_ini[2676] = -23.2849644809540
    sp_jac_ini[2677] = -39.6392229058202
    sp_jac_ini[2678] = -10.2713736253513
    sp_jac_ini[2679] = -136.523516830407
    sp_jac_ini[2680] = -59.7203367834281
    sp_jac_ini[2681] = 48.8496051768258
    sp_jac_ini[2682] = 8.42240745613237
    sp_jac_ini[2683] = 33.9659505153141
    sp_jac_ini[2684] = 22.4917262854545
    sp_jac_ini[2685] = 48.8496051768258
    sp_jac_ini[2686] = 8.42240745613237
    sp_jac_ini[2687] = 1
    sp_jac_ini[2688] = -5.65456401516768
    sp_jac_ini[2689] = 30.9517475172273
    sp_jac_ini[2690] = -1.84896616921897
    sp_jac_ini[2691] = -9.21038227100566
    sp_jac_ini[2692] = -0.793238195499529
    sp_jac_ini[2693] = -9.00835072044485
    sp_jac_ini[2694] = -1.84896616921897
    sp_jac_ini[2695] = -9.21038227100566
    sp_jac_ini[2696] = -54.0657727682604
    sp_jac_ini[2697] = 105.571769313180
    sp_jac_ini[2698] = 10.2713736253513
    sp_jac_ini[2699] = -39.6392229058202
    sp_jac_ini[2700] = 23.2849644809540
    sp_jac_ini[2701] = -24.9575997948692
    sp_jac_ini[2702] = 10.2713736253513
    sp_jac_ini[2703] = -39.6392229058202
    sp_jac_ini[2704] = 59.7203367834281
    sp_jac_ini[2705] = -136.523516830407
    sp_jac_ini[2706] = -8.42240745613237
    sp_jac_ini[2707] = 48.8496051768258
    sp_jac_ini[2708] = -22.4917262854545
    sp_jac_ini[2709] = 33.9659505153141
    sp_jac_ini[2710] = -8.42240745613237
    sp_jac_ini[2711] = 48.8496051768258
    sp_jac_ini[2712] = 1
    sp_jac_ini[2713] = -9.21038227100566
    sp_jac_ini[2714] = 1.84896616921897
    sp_jac_ini[2715] = 30.9517475172273
    sp_jac_ini[2716] = 5.65456401516768
    sp_jac_ini[2717] = -9.21038227100566
    sp_jac_ini[2718] = 1.84896616921897
    sp_jac_ini[2719] = -9.00835072044485
    sp_jac_ini[2720] = 0.793238195499528
    sp_jac_ini[2721] = -39.6392229058202
    sp_jac_ini[2722] = -10.2713736253513
    sp_jac_ini[2723] = 105.571769313180
    sp_jac_ini[2724] = 54.0657727682604
    sp_jac_ini[2725] = -39.6392229058201
    sp_jac_ini[2726] = -10.2713736253513
    sp_jac_ini[2727] = -24.9575997948692
    sp_jac_ini[2728] = -23.2849644809540
    sp_jac_ini[2729] = 48.8496051768258
    sp_jac_ini[2730] = 8.42240745613237
    sp_jac_ini[2731] = -136.523516830407
    sp_jac_ini[2732] = -59.7203367834280
    sp_jac_ini[2733] = 48.8496051768258
    sp_jac_ini[2734] = 8.42240745613238
    sp_jac_ini[2735] = 33.9659505153141
    sp_jac_ini[2736] = 22.4917262854545
    sp_jac_ini[2737] = 1
    sp_jac_ini[2738] = -1.84896616921897
    sp_jac_ini[2739] = -9.21038227100566
    sp_jac_ini[2740] = -5.65456401516768
    sp_jac_ini[2741] = 30.9517475172273
    sp_jac_ini[2742] = -1.84896616921897
    sp_jac_ini[2743] = -9.21038227100566
    sp_jac_ini[2744] = -0.793238195499528
    sp_jac_ini[2745] = -9.00835072044485
    sp_jac_ini[2746] = 10.2713736253513
    sp_jac_ini[2747] = -39.6392229058202
    sp_jac_ini[2748] = -54.0657727682604
    sp_jac_ini[2749] = 105.571769313180
    sp_jac_ini[2750] = 10.2713736253513
    sp_jac_ini[2751] = -39.6392229058201
    sp_jac_ini[2752] = 23.2849644809540
    sp_jac_ini[2753] = -24.9575997948692
    sp_jac_ini[2754] = -8.42240745613237
    sp_jac_ini[2755] = 48.8496051768258
    sp_jac_ini[2756] = 59.7203367834280
    sp_jac_ini[2757] = -136.523516830407
    sp_jac_ini[2758] = -8.42240745613238
    sp_jac_ini[2759] = 48.8496051768258
    sp_jac_ini[2760] = -22.4917262854545
    sp_jac_ini[2761] = 33.9659505153141
    sp_jac_ini[2762] = 1
    sp_jac_ini[2763] = -9.00835072044484
    sp_jac_ini[2764] = 0.793238195499527
    sp_jac_ini[2765] = -9.21038227100566
    sp_jac_ini[2766] = 1.84896616921897
    sp_jac_ini[2767] = 30.9517475172273
    sp_jac_ini[2768] = 5.65456401516768
    sp_jac_ini[2769] = -9.21038227100566
    sp_jac_ini[2770] = 1.84896616921897
    sp_jac_ini[2771] = -24.9575997948692
    sp_jac_ini[2772] = -23.2849644809540
    sp_jac_ini[2773] = -39.6392229058202
    sp_jac_ini[2774] = -10.2713736253513
    sp_jac_ini[2775] = 105.571769313180
    sp_jac_ini[2776] = 54.0657727682604
    sp_jac_ini[2777] = -39.6392229058201
    sp_jac_ini[2778] = -10.2713736253514
    sp_jac_ini[2779] = 33.9659505153141
    sp_jac_ini[2780] = 22.4917262854545
    sp_jac_ini[2781] = 48.8496051768259
    sp_jac_ini[2782] = 8.42240745613236
    sp_jac_ini[2783] = -136.523516830407
    sp_jac_ini[2784] = -59.7203367834281
    sp_jac_ini[2785] = 48.8496051768258
    sp_jac_ini[2786] = 8.42240745613239
    sp_jac_ini[2787] = 1
    sp_jac_ini[2788] = -0.793238195499527
    sp_jac_ini[2789] = -9.00835072044484
    sp_jac_ini[2790] = -1.84896616921897
    sp_jac_ini[2791] = -9.21038227100566
    sp_jac_ini[2792] = -5.65456401516768
    sp_jac_ini[2793] = 30.9517475172273
    sp_jac_ini[2794] = -1.84896616921897
    sp_jac_ini[2795] = -9.21038227100566
    sp_jac_ini[2796] = 23.2849644809540
    sp_jac_ini[2797] = -24.9575997948692
    sp_jac_ini[2798] = 10.2713736253513
    sp_jac_ini[2799] = -39.6392229058202
    sp_jac_ini[2800] = -54.0657727682604
    sp_jac_ini[2801] = 105.571769313180
    sp_jac_ini[2802] = 10.2713736253514
    sp_jac_ini[2803] = -39.6392229058201
    sp_jac_ini[2804] = -22.4917262854545
    sp_jac_ini[2805] = 33.9659505153141
    sp_jac_ini[2806] = -8.42240745613236
    sp_jac_ini[2807] = 48.8496051768259
    sp_jac_ini[2808] = 59.7203367834281
    sp_jac_ini[2809] = -136.523516830407
    sp_jac_ini[2810] = -8.42240745613239
    sp_jac_ini[2811] = 48.8496051768258
    sp_jac_ini[2812] = 1
    sp_jac_ini[2813] = -9.21038227100566
    sp_jac_ini[2814] = 1.84896616921897
    sp_jac_ini[2815] = -9.00835072044485
    sp_jac_ini[2816] = 0.793238195499527
    sp_jac_ini[2817] = -9.21038227100566
    sp_jac_ini[2818] = 1.84896616921897
    sp_jac_ini[2819] = 30.9517475172273
    sp_jac_ini[2820] = 5.65456401516768
    sp_jac_ini[2821] = -39.6392229058202
    sp_jac_ini[2822] = -10.2713736253513
    sp_jac_ini[2823] = -24.9575997948692
    sp_jac_ini[2824] = -23.2849644809540
    sp_jac_ini[2825] = -39.6392229058202
    sp_jac_ini[2826] = -10.2713736253513
    sp_jac_ini[2827] = 105.571769313180
    sp_jac_ini[2828] = 54.0657727682604
    sp_jac_ini[2829] = 48.8496051768258
    sp_jac_ini[2830] = 8.42240745613237
    sp_jac_ini[2831] = 33.9659505153140
    sp_jac_ini[2832] = 22.4917262854545
    sp_jac_ini[2833] = 48.8496051768258
    sp_jac_ini[2834] = 8.42240745613237
    sp_jac_ini[2835] = -136.548516830407
    sp_jac_ini[2836] = -59.7203367834281
    sp_jac_ini[2837] = -1.84896616921897
    sp_jac_ini[2838] = -9.21038227100566
    sp_jac_ini[2839] = -0.793238195499527
    sp_jac_ini[2840] = -9.00835072044485
    sp_jac_ini[2841] = -1.84896616921897
    sp_jac_ini[2842] = -9.21038227100566
    sp_jac_ini[2843] = -5.65456401516768
    sp_jac_ini[2844] = 30.9517475172273
    sp_jac_ini[2845] = 10.2713736253513
    sp_jac_ini[2846] = -39.6392229058202
    sp_jac_ini[2847] = 23.2849644809540
    sp_jac_ini[2848] = -24.9575997948692
    sp_jac_ini[2849] = 10.2713736253513
    sp_jac_ini[2850] = -39.6392229058202
    sp_jac_ini[2851] = -54.0657727682604
    sp_jac_ini[2852] = 105.571769313180
    sp_jac_ini[2853] = -8.42240745613237
    sp_jac_ini[2854] = 48.8496051768258
    sp_jac_ini[2855] = -22.4917262854545
    sp_jac_ini[2856] = 33.9659505153140
    sp_jac_ini[2857] = -8.42240745613237
    sp_jac_ini[2858] = 48.8496051768258
    sp_jac_ini[2859] = 59.7203367834281
    sp_jac_ini[2860] = -136.548516830407
    sp_jac_ini[2861] = 26.5300693004806
    sp_jac_ini[2862] = 4.84676915585801
    sp_jac_ini[2863] = -7.89461337514770
    sp_jac_ini[2864] = 1.58482814504483
    sp_jac_ini[2865] = -7.72144347466701
    sp_jac_ini[2866] = 0.679918453285310
    sp_jac_ini[2867] = -7.89461337514771
    sp_jac_ini[2868] = 1.58482814504483
    sp_jac_ini[2869] = -53.0601386009611
    sp_jac_ini[2870] = -9.69353831171601
    sp_jac_ini[2871] = 15.7892267502954
    sp_jac_ini[2872] = -3.16965629008966
    sp_jac_ini[2873] = 15.4428869493340
    sp_jac_ini[2874] = -1.35983690657062
    sp_jac_ini[2875] = 15.7892267502954
    sp_jac_ini[2876] = -3.16965629008966
    sp_jac_ini[2877] = 26.5300693004806
    sp_jac_ini[2878] = 4.84676915585801
    sp_jac_ini[2879] = -7.89461337514770
    sp_jac_ini[2880] = 1.58482814504483
    sp_jac_ini[2881] = -7.72144347466701
    sp_jac_ini[2882] = 0.679918453285310
    sp_jac_ini[2883] = -7.89461337514771
    sp_jac_ini[2884] = 1.58482814504483
    sp_jac_ini[2885] = -4.84676915585801
    sp_jac_ini[2886] = 26.5300693004806
    sp_jac_ini[2887] = -1.58482814504483
    sp_jac_ini[2888] = -7.89461337514770
    sp_jac_ini[2889] = -0.679918453285310
    sp_jac_ini[2890] = -7.72144347466701
    sp_jac_ini[2891] = -1.58482814504483
    sp_jac_ini[2892] = -7.89461337514771
    sp_jac_ini[2893] = 9.69353831171601
    sp_jac_ini[2894] = -53.0601386009611
    sp_jac_ini[2895] = 3.16965629008966
    sp_jac_ini[2896] = 15.7892267502954
    sp_jac_ini[2897] = 1.35983690657062
    sp_jac_ini[2898] = 15.4428869493340
    sp_jac_ini[2899] = 3.16965629008966
    sp_jac_ini[2900] = 15.7892267502954
    sp_jac_ini[2901] = -4.84676915585801
    sp_jac_ini[2902] = 26.5300693004806
    sp_jac_ini[2903] = -1.58482814504483
    sp_jac_ini[2904] = -7.89461337514770
    sp_jac_ini[2905] = -0.679918453285310
    sp_jac_ini[2906] = -7.72144347466701
    sp_jac_ini[2907] = -1.58482814504483
    sp_jac_ini[2908] = -7.89461337514771
    sp_jac_ini[2909] = -7.89461337514771
    sp_jac_ini[2910] = 1.58482814504483
    sp_jac_ini[2911] = 26.5300693004806
    sp_jac_ini[2912] = 4.84676915585801
    sp_jac_ini[2913] = -7.89461337514771
    sp_jac_ini[2914] = 1.58482814504483
    sp_jac_ini[2915] = -7.72144347466701
    sp_jac_ini[2916] = 0.679918453285308
    sp_jac_ini[2917] = 15.7892267502954
    sp_jac_ini[2918] = -3.16965629008966
    sp_jac_ini[2919] = -53.0601386009611
    sp_jac_ini[2920] = -9.69353831171602
    sp_jac_ini[2921] = 15.7892267502954
    sp_jac_ini[2922] = -3.16965629008967
    sp_jac_ini[2923] = 15.4428869493340
    sp_jac_ini[2924] = -1.35983690657062
    sp_jac_ini[2925] = -7.89461337514771
    sp_jac_ini[2926] = 1.58482814504483
    sp_jac_ini[2927] = 26.5300693004806
    sp_jac_ini[2928] = 4.84676915585801
    sp_jac_ini[2929] = -7.89461337514771
    sp_jac_ini[2930] = 1.58482814504483
    sp_jac_ini[2931] = -7.72144347466701
    sp_jac_ini[2932] = 0.679918453285308
    sp_jac_ini[2933] = -1.58482814504483
    sp_jac_ini[2934] = -7.89461337514771
    sp_jac_ini[2935] = -4.84676915585801
    sp_jac_ini[2936] = 26.5300693004806
    sp_jac_ini[2937] = -1.58482814504483
    sp_jac_ini[2938] = -7.89461337514771
    sp_jac_ini[2939] = -0.679918453285308
    sp_jac_ini[2940] = -7.72144347466701
    sp_jac_ini[2941] = 3.16965629008966
    sp_jac_ini[2942] = 15.7892267502954
    sp_jac_ini[2943] = 9.69353831171602
    sp_jac_ini[2944] = -53.0601386009611
    sp_jac_ini[2945] = 3.16965629008967
    sp_jac_ini[2946] = 15.7892267502954
    sp_jac_ini[2947] = 1.35983690657062
    sp_jac_ini[2948] = 15.4428869493340
    sp_jac_ini[2949] = -1.58482814504483
    sp_jac_ini[2950] = -7.89461337514771
    sp_jac_ini[2951] = -4.84676915585801
    sp_jac_ini[2952] = 26.5300693004806
    sp_jac_ini[2953] = -1.58482814504483
    sp_jac_ini[2954] = -7.89461337514771
    sp_jac_ini[2955] = -0.679918453285308
    sp_jac_ini[2956] = -7.72144347466701
    sp_jac_ini[2957] = -7.72144347466701
    sp_jac_ini[2958] = 0.679918453285310
    sp_jac_ini[2959] = -7.89461337514770
    sp_jac_ini[2960] = 1.58482814504483
    sp_jac_ini[2961] = 26.5300693004806
    sp_jac_ini[2962] = 4.84676915585801
    sp_jac_ini[2963] = -7.89461337514771
    sp_jac_ini[2964] = 1.58482814504483
    sp_jac_ini[2965] = 15.4428869493340
    sp_jac_ini[2966] = -1.35983690657062
    sp_jac_ini[2967] = 15.7892267502954
    sp_jac_ini[2968] = -3.16965629008966
    sp_jac_ini[2969] = -53.0601386009611
    sp_jac_ini[2970] = -9.69353831171602
    sp_jac_ini[2971] = 15.7892267502954
    sp_jac_ini[2972] = -3.16965629008967
    sp_jac_ini[2973] = -7.72144347466701
    sp_jac_ini[2974] = 0.679918453285310
    sp_jac_ini[2975] = -7.89461337514770
    sp_jac_ini[2976] = 1.58482814504483
    sp_jac_ini[2977] = 26.5300693004806
    sp_jac_ini[2978] = 4.84676915585801
    sp_jac_ini[2979] = -7.89461337514771
    sp_jac_ini[2980] = 1.58482814504483
    sp_jac_ini[2981] = -0.679918453285310
    sp_jac_ini[2982] = -7.72144347466701
    sp_jac_ini[2983] = -1.58482814504483
    sp_jac_ini[2984] = -7.89461337514770
    sp_jac_ini[2985] = -4.84676915585801
    sp_jac_ini[2986] = 26.5300693004806
    sp_jac_ini[2987] = -1.58482814504483
    sp_jac_ini[2988] = -7.89461337514771
    sp_jac_ini[2989] = 1.35983690657062
    sp_jac_ini[2990] = 15.4428869493340
    sp_jac_ini[2991] = 3.16965629008966
    sp_jac_ini[2992] = 15.7892267502954
    sp_jac_ini[2993] = 9.69353831171602
    sp_jac_ini[2994] = -53.0601386009611
    sp_jac_ini[2995] = 3.16965629008967
    sp_jac_ini[2996] = 15.7892267502954
    sp_jac_ini[2997] = -0.679918453285310
    sp_jac_ini[2998] = -7.72144347466701
    sp_jac_ini[2999] = -1.58482814504483
    sp_jac_ini[3000] = -7.89461337514770
    sp_jac_ini[3001] = -4.84676915585801
    sp_jac_ini[3002] = 26.5300693004806
    sp_jac_ini[3003] = -1.58482814504483
    sp_jac_ini[3004] = -7.89461337514771
    sp_jac_ini[3005] = -7.89461337514771
    sp_jac_ini[3006] = 1.58482814504483
    sp_jac_ini[3007] = -7.72144347466701
    sp_jac_ini[3008] = 0.679918453285308
    sp_jac_ini[3009] = -7.89461337514771
    sp_jac_ini[3010] = 1.58482814504483
    sp_jac_ini[3011] = 26.5300693004806
    sp_jac_ini[3012] = 4.84676915585801
    sp_jac_ini[3013] = 15.7892267502954
    sp_jac_ini[3014] = -3.16965629008966
    sp_jac_ini[3015] = 15.4428869493340
    sp_jac_ini[3016] = -1.35983690657062
    sp_jac_ini[3017] = 15.7892267502954
    sp_jac_ini[3018] = -3.16965629008966
    sp_jac_ini[3019] = -53.0601386009611
    sp_jac_ini[3020] = -9.69353831171602
    sp_jac_ini[3021] = -7.89461337514771
    sp_jac_ini[3022] = 1.58482814504483
    sp_jac_ini[3023] = -7.72144347466701
    sp_jac_ini[3024] = 0.679918453285308
    sp_jac_ini[3025] = -7.89461337514771
    sp_jac_ini[3026] = 1.58482814504483
    sp_jac_ini[3027] = 26.5300693004806
    sp_jac_ini[3028] = 4.84676915585801
    sp_jac_ini[3029] = -1.58482814504483
    sp_jac_ini[3030] = -7.89461337514771
    sp_jac_ini[3031] = -0.679918453285308
    sp_jac_ini[3032] = -7.72144347466701
    sp_jac_ini[3033] = -1.58482814504483
    sp_jac_ini[3034] = -7.89461337514771
    sp_jac_ini[3035] = -4.84676915585801
    sp_jac_ini[3036] = 26.5300693004806
    sp_jac_ini[3037] = 3.16965629008966
    sp_jac_ini[3038] = 15.7892267502954
    sp_jac_ini[3039] = 1.35983690657062
    sp_jac_ini[3040] = 15.4428869493340
    sp_jac_ini[3041] = 3.16965629008966
    sp_jac_ini[3042] = 15.7892267502954
    sp_jac_ini[3043] = 9.69353831171602
    sp_jac_ini[3044] = -53.0601386009611
    sp_jac_ini[3045] = -1.58482814504483
    sp_jac_ini[3046] = -7.89461337514771
    sp_jac_ini[3047] = -0.679918453285308
    sp_jac_ini[3048] = -7.72144347466701
    sp_jac_ini[3049] = -1.58482814504483
    sp_jac_ini[3050] = -7.89461337514771
    sp_jac_ini[3051] = -4.84676915585801
    sp_jac_ini[3052] = 26.5300693004806
    sp_jac_ini[3053] = 26.5300693004806
    sp_jac_ini[3054] = 4.84676915585801
    sp_jac_ini[3055] = -7.89461337514770
    sp_jac_ini[3056] = 1.58482814504483
    sp_jac_ini[3057] = -7.72144347466701
    sp_jac_ini[3058] = 0.679918453285310
    sp_jac_ini[3059] = -7.89461337514771
    sp_jac_ini[3060] = 1.58482814504483
    sp_jac_ini[3061] = -53.0601386009611
    sp_jac_ini[3062] = -9.69353831171601
    sp_jac_ini[3063] = 15.7892267502954
    sp_jac_ini[3064] = -3.16965629008966
    sp_jac_ini[3065] = 15.4428869493340
    sp_jac_ini[3066] = -1.35983690657062
    sp_jac_ini[3067] = 15.7892267502954
    sp_jac_ini[3068] = -3.16965629008966
    sp_jac_ini[3069] = 26.5300693004806
    sp_jac_ini[3070] = 4.84676915585801
    sp_jac_ini[3071] = -7.89461337514770
    sp_jac_ini[3072] = 1.58482814504483
    sp_jac_ini[3073] = -7.72144347466701
    sp_jac_ini[3074] = 0.679918453285310
    sp_jac_ini[3075] = -7.89461337514771
    sp_jac_ini[3076] = 1.58482814504483
    sp_jac_ini[3077] = -4.84676915585801
    sp_jac_ini[3078] = 26.5300693004806
    sp_jac_ini[3079] = -1.58482814504483
    sp_jac_ini[3080] = -7.89461337514770
    sp_jac_ini[3081] = -0.679918453285310
    sp_jac_ini[3082] = -7.72144347466701
    sp_jac_ini[3083] = -1.58482814504483
    sp_jac_ini[3084] = -7.89461337514771
    sp_jac_ini[3085] = 9.69353831171601
    sp_jac_ini[3086] = -53.0601386009611
    sp_jac_ini[3087] = 3.16965629008966
    sp_jac_ini[3088] = 15.7892267502954
    sp_jac_ini[3089] = 1.35983690657062
    sp_jac_ini[3090] = 15.4428869493340
    sp_jac_ini[3091] = 3.16965629008966
    sp_jac_ini[3092] = 15.7892267502954
    sp_jac_ini[3093] = -4.84676915585801
    sp_jac_ini[3094] = 26.5300693004806
    sp_jac_ini[3095] = -1.58482814504483
    sp_jac_ini[3096] = -7.89461337514770
    sp_jac_ini[3097] = -0.679918453285310
    sp_jac_ini[3098] = -7.72144347466701
    sp_jac_ini[3099] = -1.58482814504483
    sp_jac_ini[3100] = -7.89461337514771
    sp_jac_ini[3101] = -7.89461337514771
    sp_jac_ini[3102] = 1.58482814504483
    sp_jac_ini[3103] = 26.5300693004806
    sp_jac_ini[3104] = 4.84676915585801
    sp_jac_ini[3105] = -7.89461337514771
    sp_jac_ini[3106] = 1.58482814504483
    sp_jac_ini[3107] = -7.72144347466701
    sp_jac_ini[3108] = 0.679918453285308
    sp_jac_ini[3109] = 15.7892267502954
    sp_jac_ini[3110] = -3.16965629008966
    sp_jac_ini[3111] = -53.0601386009611
    sp_jac_ini[3112] = -9.69353831171602
    sp_jac_ini[3113] = 15.7892267502954
    sp_jac_ini[3114] = -3.16965629008967
    sp_jac_ini[3115] = 15.4428869493340
    sp_jac_ini[3116] = -1.35983690657062
    sp_jac_ini[3117] = -7.89461337514771
    sp_jac_ini[3118] = 1.58482814504483
    sp_jac_ini[3119] = 26.5300693004806
    sp_jac_ini[3120] = 4.84676915585801
    sp_jac_ini[3121] = -7.89461337514771
    sp_jac_ini[3122] = 1.58482814504483
    sp_jac_ini[3123] = -7.72144347466701
    sp_jac_ini[3124] = 0.679918453285308
    sp_jac_ini[3125] = -1.58482814504483
    sp_jac_ini[3126] = -7.89461337514771
    sp_jac_ini[3127] = -4.84676915585801
    sp_jac_ini[3128] = 26.5300693004806
    sp_jac_ini[3129] = -1.58482814504483
    sp_jac_ini[3130] = -7.89461337514771
    sp_jac_ini[3131] = -0.679918453285308
    sp_jac_ini[3132] = -7.72144347466701
    sp_jac_ini[3133] = 3.16965629008966
    sp_jac_ini[3134] = 15.7892267502954
    sp_jac_ini[3135] = 9.69353831171602
    sp_jac_ini[3136] = -53.0601386009611
    sp_jac_ini[3137] = 3.16965629008967
    sp_jac_ini[3138] = 15.7892267502954
    sp_jac_ini[3139] = 1.35983690657062
    sp_jac_ini[3140] = 15.4428869493340
    sp_jac_ini[3141] = -1.58482814504483
    sp_jac_ini[3142] = -7.89461337514771
    sp_jac_ini[3143] = -4.84676915585801
    sp_jac_ini[3144] = 26.5300693004806
    sp_jac_ini[3145] = -1.58482814504483
    sp_jac_ini[3146] = -7.89461337514771
    sp_jac_ini[3147] = -0.679918453285308
    sp_jac_ini[3148] = -7.72144347466701
    sp_jac_ini[3149] = -7.72144347466701
    sp_jac_ini[3150] = 0.679918453285310
    sp_jac_ini[3151] = -7.89461337514770
    sp_jac_ini[3152] = 1.58482814504483
    sp_jac_ini[3153] = 26.5300693004806
    sp_jac_ini[3154] = 4.84676915585801
    sp_jac_ini[3155] = -7.89461337514771
    sp_jac_ini[3156] = 1.58482814504483
    sp_jac_ini[3157] = 15.4428869493340
    sp_jac_ini[3158] = -1.35983690657062
    sp_jac_ini[3159] = 15.7892267502954
    sp_jac_ini[3160] = -3.16965629008966
    sp_jac_ini[3161] = -53.0601386009611
    sp_jac_ini[3162] = -9.69353831171602
    sp_jac_ini[3163] = 15.7892267502954
    sp_jac_ini[3164] = -3.16965629008967
    sp_jac_ini[3165] = -7.72144347466701
    sp_jac_ini[3166] = 0.679918453285310
    sp_jac_ini[3167] = -7.89461337514770
    sp_jac_ini[3168] = 1.58482814504483
    sp_jac_ini[3169] = 26.5300693004806
    sp_jac_ini[3170] = 4.84676915585801
    sp_jac_ini[3171] = -7.89461337514771
    sp_jac_ini[3172] = 1.58482814504483
    sp_jac_ini[3173] = -0.679918453285310
    sp_jac_ini[3174] = -7.72144347466701
    sp_jac_ini[3175] = -1.58482814504483
    sp_jac_ini[3176] = -7.89461337514770
    sp_jac_ini[3177] = -4.84676915585801
    sp_jac_ini[3178] = 26.5300693004806
    sp_jac_ini[3179] = -1.58482814504483
    sp_jac_ini[3180] = -7.89461337514771
    sp_jac_ini[3181] = 1.35983690657062
    sp_jac_ini[3182] = 15.4428869493340
    sp_jac_ini[3183] = 3.16965629008966
    sp_jac_ini[3184] = 15.7892267502954
    sp_jac_ini[3185] = 9.69353831171602
    sp_jac_ini[3186] = -53.0601386009611
    sp_jac_ini[3187] = 3.16965629008967
    sp_jac_ini[3188] = 15.7892267502954
    sp_jac_ini[3189] = -0.679918453285310
    sp_jac_ini[3190] = -7.72144347466701
    sp_jac_ini[3191] = -1.58482814504483
    sp_jac_ini[3192] = -7.89461337514770
    sp_jac_ini[3193] = -4.84676915585801
    sp_jac_ini[3194] = 26.5300693004806
    sp_jac_ini[3195] = -1.58482814504483
    sp_jac_ini[3196] = -7.89461337514771
    sp_jac_ini[3197] = -7.89461337514771
    sp_jac_ini[3198] = 1.58482814504483
    sp_jac_ini[3199] = -7.72144347466701
    sp_jac_ini[3200] = 0.679918453285308
    sp_jac_ini[3201] = -7.89461337514771
    sp_jac_ini[3202] = 1.58482814504483
    sp_jac_ini[3203] = 26.5300693004806
    sp_jac_ini[3204] = 4.84676915585801
    sp_jac_ini[3205] = 15.7892267502954
    sp_jac_ini[3206] = -3.16965629008966
    sp_jac_ini[3207] = 15.4428869493340
    sp_jac_ini[3208] = -1.35983690657062
    sp_jac_ini[3209] = 15.7892267502954
    sp_jac_ini[3210] = -3.16965629008966
    sp_jac_ini[3211] = -53.0851386009611
    sp_jac_ini[3212] = -9.69353831171602
    sp_jac_ini[3213] = -7.89461337514771
    sp_jac_ini[3214] = 1.58482814504483
    sp_jac_ini[3215] = -7.72144347466701
    sp_jac_ini[3216] = 0.679918453285308
    sp_jac_ini[3217] = -7.89461337514771
    sp_jac_ini[3218] = 1.58482814504483
    sp_jac_ini[3219] = 26.5300693004806
    sp_jac_ini[3220] = 4.84676915585801
    sp_jac_ini[3221] = -1.58482814504483
    sp_jac_ini[3222] = -7.89461337514771
    sp_jac_ini[3223] = -0.679918453285308
    sp_jac_ini[3224] = -7.72144347466701
    sp_jac_ini[3225] = -1.58482814504483
    sp_jac_ini[3226] = -7.89461337514771
    sp_jac_ini[3227] = -4.84676915585801
    sp_jac_ini[3228] = 26.5300693004806
    sp_jac_ini[3229] = 3.16965629008966
    sp_jac_ini[3230] = 15.7892267502954
    sp_jac_ini[3231] = 1.35983690657062
    sp_jac_ini[3232] = 15.4428869493340
    sp_jac_ini[3233] = 3.16965629008966
    sp_jac_ini[3234] = 15.7892267502954
    sp_jac_ini[3235] = 9.69353831171602
    sp_jac_ini[3236] = -53.0851386009611
    sp_jac_ini[3237] = -1.58482814504483
    sp_jac_ini[3238] = -7.89461337514771
    sp_jac_ini[3239] = -0.679918453285308
    sp_jac_ini[3240] = -7.72144347466701
    sp_jac_ini[3241] = -1.58482814504483
    sp_jac_ini[3242] = -7.89461337514771
    sp_jac_ini[3243] = -4.84676915585801
    sp_jac_ini[3244] = 26.5300693004806
    sp_jac_ini[3245] = 26.5300693004806
    sp_jac_ini[3246] = 4.84676915585801
    sp_jac_ini[3247] = -7.89461337514770
    sp_jac_ini[3248] = 1.58482814504483
    sp_jac_ini[3249] = -7.72144347466701
    sp_jac_ini[3250] = 0.679918453285310
    sp_jac_ini[3251] = -7.89461337514771
    sp_jac_ini[3252] = 1.58482814504483
    sp_jac_ini[3253] = 26.5300693004806
    sp_jac_ini[3254] = 4.84676915585801
    sp_jac_ini[3255] = -7.89461337514770
    sp_jac_ini[3256] = 1.58482814504483
    sp_jac_ini[3257] = -7.72144347466701
    sp_jac_ini[3258] = 0.679918453285310
    sp_jac_ini[3259] = -7.89461337514771
    sp_jac_ini[3260] = 1.58482814504483
    sp_jac_ini[3261] = -53.0601386009611
    sp_jac_ini[3262] = -9.69353831171601
    sp_jac_ini[3263] = 15.7892267502954
    sp_jac_ini[3264] = -3.16965629008966
    sp_jac_ini[3265] = 15.4428869493340
    sp_jac_ini[3266] = -1.35983690657062
    sp_jac_ini[3267] = 15.7892267502954
    sp_jac_ini[3268] = -3.16965629008966
    sp_jac_ini[3269] = 1
    sp_jac_ini[3270] = -4.84676915585801
    sp_jac_ini[3271] = 26.5300693004806
    sp_jac_ini[3272] = -1.58482814504483
    sp_jac_ini[3273] = -7.89461337514770
    sp_jac_ini[3274] = -0.679918453285310
    sp_jac_ini[3275] = -7.72144347466701
    sp_jac_ini[3276] = -1.58482814504483
    sp_jac_ini[3277] = -7.89461337514771
    sp_jac_ini[3278] = -4.84676915585801
    sp_jac_ini[3279] = 26.5300693004806
    sp_jac_ini[3280] = -1.58482814504483
    sp_jac_ini[3281] = -7.89461337514770
    sp_jac_ini[3282] = -0.679918453285310
    sp_jac_ini[3283] = -7.72144347466701
    sp_jac_ini[3284] = -1.58482814504483
    sp_jac_ini[3285] = -7.89461337514771
    sp_jac_ini[3286] = 9.69353831171601
    sp_jac_ini[3287] = -53.0601386009611
    sp_jac_ini[3288] = 3.16965629008966
    sp_jac_ini[3289] = 15.7892267502954
    sp_jac_ini[3290] = 1.35983690657062
    sp_jac_ini[3291] = 15.4428869493340
    sp_jac_ini[3292] = 3.16965629008966
    sp_jac_ini[3293] = 15.7892267502954
    sp_jac_ini[3294] = 1
    sp_jac_ini[3295] = -7.89461337514771
    sp_jac_ini[3296] = 1.58482814504483
    sp_jac_ini[3297] = 26.5300693004806
    sp_jac_ini[3298] = 4.84676915585801
    sp_jac_ini[3299] = -7.89461337514771
    sp_jac_ini[3300] = 1.58482814504483
    sp_jac_ini[3301] = -7.72144347466701
    sp_jac_ini[3302] = 0.679918453285308
    sp_jac_ini[3303] = -7.89461337514771
    sp_jac_ini[3304] = 1.58482814504483
    sp_jac_ini[3305] = 26.5300693004806
    sp_jac_ini[3306] = 4.84676915585801
    sp_jac_ini[3307] = -7.89461337514771
    sp_jac_ini[3308] = 1.58482814504483
    sp_jac_ini[3309] = -7.72144347466701
    sp_jac_ini[3310] = 0.679918453285308
    sp_jac_ini[3311] = 15.7892267502954
    sp_jac_ini[3312] = -3.16965629008966
    sp_jac_ini[3313] = -53.0601386009611
    sp_jac_ini[3314] = -9.69353831171602
    sp_jac_ini[3315] = 15.7892267502954
    sp_jac_ini[3316] = -3.16965629008967
    sp_jac_ini[3317] = 15.4428869493340
    sp_jac_ini[3318] = -1.35983690657062
    sp_jac_ini[3319] = 1
    sp_jac_ini[3320] = -1.58482814504483
    sp_jac_ini[3321] = -7.89461337514771
    sp_jac_ini[3322] = -4.84676915585801
    sp_jac_ini[3323] = 26.5300693004806
    sp_jac_ini[3324] = -1.58482814504483
    sp_jac_ini[3325] = -7.89461337514771
    sp_jac_ini[3326] = -0.679918453285308
    sp_jac_ini[3327] = -7.72144347466701
    sp_jac_ini[3328] = -1.58482814504483
    sp_jac_ini[3329] = -7.89461337514771
    sp_jac_ini[3330] = -4.84676915585801
    sp_jac_ini[3331] = 26.5300693004806
    sp_jac_ini[3332] = -1.58482814504483
    sp_jac_ini[3333] = -7.89461337514771
    sp_jac_ini[3334] = -0.679918453285308
    sp_jac_ini[3335] = -7.72144347466701
    sp_jac_ini[3336] = 3.16965629008966
    sp_jac_ini[3337] = 15.7892267502954
    sp_jac_ini[3338] = 9.69353831171602
    sp_jac_ini[3339] = -53.0601386009611
    sp_jac_ini[3340] = 3.16965629008967
    sp_jac_ini[3341] = 15.7892267502954
    sp_jac_ini[3342] = 1.35983690657062
    sp_jac_ini[3343] = 15.4428869493340
    sp_jac_ini[3344] = 1
    sp_jac_ini[3345] = -7.72144347466701
    sp_jac_ini[3346] = 0.679918453285310
    sp_jac_ini[3347] = -7.89461337514770
    sp_jac_ini[3348] = 1.58482814504483
    sp_jac_ini[3349] = 26.5300693004806
    sp_jac_ini[3350] = 4.84676915585801
    sp_jac_ini[3351] = -7.89461337514771
    sp_jac_ini[3352] = 1.58482814504483
    sp_jac_ini[3353] = -7.72144347466701
    sp_jac_ini[3354] = 0.679918453285310
    sp_jac_ini[3355] = -7.89461337514770
    sp_jac_ini[3356] = 1.58482814504483
    sp_jac_ini[3357] = 26.5300693004806
    sp_jac_ini[3358] = 4.84676915585801
    sp_jac_ini[3359] = -7.89461337514771
    sp_jac_ini[3360] = 1.58482814504483
    sp_jac_ini[3361] = 15.4428869493340
    sp_jac_ini[3362] = -1.35983690657062
    sp_jac_ini[3363] = 15.7892267502954
    sp_jac_ini[3364] = -3.16965629008966
    sp_jac_ini[3365] = -53.0601386009611
    sp_jac_ini[3366] = -9.69353831171602
    sp_jac_ini[3367] = 15.7892267502954
    sp_jac_ini[3368] = -3.16965629008967
    sp_jac_ini[3369] = 1
    sp_jac_ini[3370] = -0.679918453285310
    sp_jac_ini[3371] = -7.72144347466701
    sp_jac_ini[3372] = -1.58482814504483
    sp_jac_ini[3373] = -7.89461337514770
    sp_jac_ini[3374] = -4.84676915585801
    sp_jac_ini[3375] = 26.5300693004806
    sp_jac_ini[3376] = -1.58482814504483
    sp_jac_ini[3377] = -7.89461337514771
    sp_jac_ini[3378] = -0.679918453285310
    sp_jac_ini[3379] = -7.72144347466701
    sp_jac_ini[3380] = -1.58482814504483
    sp_jac_ini[3381] = -7.89461337514770
    sp_jac_ini[3382] = -4.84676915585801
    sp_jac_ini[3383] = 26.5300693004806
    sp_jac_ini[3384] = -1.58482814504483
    sp_jac_ini[3385] = -7.89461337514771
    sp_jac_ini[3386] = 1.35983690657062
    sp_jac_ini[3387] = 15.4428869493340
    sp_jac_ini[3388] = 3.16965629008966
    sp_jac_ini[3389] = 15.7892267502954
    sp_jac_ini[3390] = 9.69353831171602
    sp_jac_ini[3391] = -53.0601386009611
    sp_jac_ini[3392] = 3.16965629008967
    sp_jac_ini[3393] = 15.7892267502954
    sp_jac_ini[3394] = 1
    sp_jac_ini[3395] = -7.89461337514771
    sp_jac_ini[3396] = 1.58482814504483
    sp_jac_ini[3397] = -7.72144347466701
    sp_jac_ini[3398] = 0.679918453285308
    sp_jac_ini[3399] = -7.89461337514771
    sp_jac_ini[3400] = 1.58482814504483
    sp_jac_ini[3401] = 26.5300693004806
    sp_jac_ini[3402] = 4.84676915585801
    sp_jac_ini[3403] = -7.89461337514771
    sp_jac_ini[3404] = 1.58482814504483
    sp_jac_ini[3405] = -7.72144347466701
    sp_jac_ini[3406] = 0.679918453285308
    sp_jac_ini[3407] = -7.89461337514771
    sp_jac_ini[3408] = 1.58482814504483
    sp_jac_ini[3409] = 26.5300693004806
    sp_jac_ini[3410] = 4.84676915585801
    sp_jac_ini[3411] = 15.7892267502954
    sp_jac_ini[3412] = -3.16965629008966
    sp_jac_ini[3413] = 15.4428869493340
    sp_jac_ini[3414] = -1.35983690657062
    sp_jac_ini[3415] = 15.7892267502954
    sp_jac_ini[3416] = -3.16965629008966
    sp_jac_ini[3417] = -53.0601386009611
    sp_jac_ini[3418] = -9.69353831171602
    sp_jac_ini[3419] = -1.58482814504483
    sp_jac_ini[3420] = -7.89461337514771
    sp_jac_ini[3421] = -0.679918453285308
    sp_jac_ini[3422] = -7.72144347466701
    sp_jac_ini[3423] = -1.58482814504483
    sp_jac_ini[3424] = -7.89461337514771
    sp_jac_ini[3425] = -4.84676915585801
    sp_jac_ini[3426] = 26.5300693004806
    sp_jac_ini[3427] = -1.58482814504483
    sp_jac_ini[3428] = -7.89461337514771
    sp_jac_ini[3429] = -0.679918453285308
    sp_jac_ini[3430] = -7.72144347466701
    sp_jac_ini[3431] = -1.58482814504483
    sp_jac_ini[3432] = -7.89461337514771
    sp_jac_ini[3433] = -4.84676915585801
    sp_jac_ini[3434] = 26.5300693004806
    sp_jac_ini[3435] = 3.16965629008966
    sp_jac_ini[3436] = 15.7892267502954
    sp_jac_ini[3437] = 1.35983690657062
    sp_jac_ini[3438] = 15.4428869493340
    sp_jac_ini[3439] = 3.16965629008966
    sp_jac_ini[3440] = 15.7892267502954
    sp_jac_ini[3441] = 9.69353831171602
    sp_jac_ini[3442] = -53.0601386009611
    sp_jac_ini[3443] = -1067.70480704130
    sp_jac_ini[3444] = 67.7048070412999
    sp_jac_ini[3445] = -1067.70480704130
    sp_jac_ini[3446] = 67.7048070412999
    sp_jac_ini[3447] = 157.977883096366
    sp_jac_ini[3448] = -361.092304220266
    sp_jac_ini[3449] = 135.409614082600
    sp_jac_ini[3450] = 157.977883096366
    sp_jac_ini[3451] = -361.092304220266
    sp_jac_ini[3452] = 135.409614082600
    sp_jac_ini[3453] = -361.092304220266
    sp_jac_ini[3454] = 135.409614082600
    sp_jac_ini[3455] = 157.977883096366
    sp_jac_ini[3456] = -361.092304220266
    sp_jac_ini[3457] = 135.409614082600
    sp_jac_ini[3458] = 157.977883096366
    sp_jac_ini[3459] = -361.092304220266
    sp_jac_ini[3460] = 135.409614082600
    sp_jac_ini[3461] = 157.977883096366
    sp_jac_ini[3462] = -361.092304220266
    sp_jac_ini[3463] = 135.409614082600
    sp_jac_ini[3464] = 157.977883096366
    sp_jac_ini[3465] = 157.977883096366
    sp_jac_ini[3466] = 67.7048070412999
    sp_jac_ini[3467] = -361.092304220266
    sp_jac_ini[3468] = 135.409614082600
    sp_jac_ini[3469] = 157.977883096366
    sp_jac_ini[3470] = 67.7048070412999
    sp_jac_ini[3471] = -361.092304220266
    sp_jac_ini[3472] = 135.409614082600
    sp_jac_ini[3473] = 135.409614082600
    sp_jac_ini[3474] = -248.250959151433
    sp_jac_ini[3475] = 67.7048070412999
    sp_jac_ini[3476] = 45.1365380275333
    sp_jac_ini[3477] = 135.409614082600
    sp_jac_ini[3478] = -248.250959151433
    sp_jac_ini[3479] = 67.7048070412999
    sp_jac_ini[3480] = 45.1365380275333
    sp_jac_ini[3481] = 135.409614082600
    sp_jac_ini[3482] = -248.250959151433
    sp_jac_ini[3483] = 67.7048070412999
    sp_jac_ini[3484] = 45.1365380275333
    sp_jac_ini[3485] = 135.409614082600
    sp_jac_ini[3486] = -248.250959151433
    sp_jac_ini[3487] = 67.7048070412999
    sp_jac_ini[3488] = 45.1365380275333
    sp_jac_ini[3489] = 135.409614082600
    sp_jac_ini[3490] = -248.250959151433
    sp_jac_ini[3491] = 67.7048070412999
    sp_jac_ini[3492] = 45.1365380275333
    sp_jac_ini[3493] = 135.409614082600
    sp_jac_ini[3494] = -248.250959151433
    sp_jac_ini[3495] = 67.7048070412999
    sp_jac_ini[3496] = 45.1365380275333
    sp_jac_ini[3497] = 135.409614082600
    sp_jac_ini[3498] = -248.250959151433
    sp_jac_ini[3499] = 67.7048070412999
    sp_jac_ini[3500] = 45.1365380275333
    sp_jac_ini[3501] = 135.409614082600
    sp_jac_ini[3502] = -248.250959151433
    sp_jac_ini[3503] = 67.7048070412999
    sp_jac_ini[3504] = 45.1365380275333
    sp_jac_ini[3505] = 157.977883096366
    sp_jac_ini[3506] = 67.7048070412999
    sp_jac_ini[3507] = -270.819228165200
    sp_jac_ini[3508] = 45.1365380275333
    sp_jac_ini[3509] = 157.977883096366
    sp_jac_ini[3510] = 67.7048070412999
    sp_jac_ini[3511] = -270.819228165200
    sp_jac_ini[3512] = 45.1365380275333
    sp_jac_ini[3513] = 67.7048070412999
    sp_jac_ini[3514] = -270.819228165200
    sp_jac_ini[3515] = 45.1365380275333
    sp_jac_ini[3516] = 157.977883096366
    sp_jac_ini[3517] = 67.7048070412999
    sp_jac_ini[3518] = -270.819228165200
    sp_jac_ini[3519] = 45.1365380275333
    sp_jac_ini[3520] = 157.977883096366
    sp_jac_ini[3521] = 67.7048070412999
    sp_jac_ini[3522] = -270.819228165200
    sp_jac_ini[3523] = 45.1365380275333
    sp_jac_ini[3524] = 157.977883096366
    sp_jac_ini[3525] = 67.7048070412999
    sp_jac_ini[3526] = -270.819228165200
    sp_jac_ini[3527] = 45.1365380275333
    sp_jac_ini[3528] = 157.977883096366
    sp_jac_ini[3529] = 157.977883096366
    sp_jac_ini[3530] = 67.7048070412999
    sp_jac_ini[3531] = -270.819228165200
    sp_jac_ini[3532] = 45.1365380275333
    sp_jac_ini[3533] = 157.977883096366
    sp_jac_ini[3534] = 67.7048070412999
    sp_jac_ini[3535] = -270.819228165200
    sp_jac_ini[3536] = 45.1365380275333
    sp_jac_ini[3537] = 157.977883096366
    sp_jac_ini[3538] = 45.1365380275333
    sp_jac_ini[3539] = -361.092304220266
    sp_jac_ini[3540] = 157.977883096366
    sp_jac_ini[3541] = 157.977883096366
    sp_jac_ini[3542] = 45.1365380275333
    sp_jac_ini[3543] = -361.092304220266
    sp_jac_ini[3544] = 157.977883096366
    sp_jac_ini[3545] = 45.1365380275333
    sp_jac_ini[3546] = -361.092304220266
    sp_jac_ini[3547] = 157.977883096366
    sp_jac_ini[3548] = 157.977883096366
    sp_jac_ini[3549] = 45.1365380275333
    sp_jac_ini[3550] = -361.092304220266
    sp_jac_ini[3551] = 157.977883096366
    sp_jac_ini[3552] = 157.977883096366
    sp_jac_ini[3553] = 45.1365380275333
    sp_jac_ini[3554] = -361.092304220266
    sp_jac_ini[3555] = 157.977883096366
    sp_jac_ini[3556] = 157.977883096366
    sp_jac_ini[3557] = 45.1365380275333
    sp_jac_ini[3558] = -361.092304220266
    sp_jac_ini[3559] = 157.977883096366
    sp_jac_ini[3560] = 157.977883096366
    sp_jac_ini[3561] = 157.977883096366
    sp_jac_ini[3562] = 45.1365380275333
    sp_jac_ini[3563] = -361.092304220266
    sp_jac_ini[3564] = 157.977883096366
    sp_jac_ini[3565] = 157.977883096366
    sp_jac_ini[3566] = 45.1365380275333
    sp_jac_ini[3567] = -361.092304220266
    sp_jac_ini[3568] = 157.977883096366
    sp_jac_ini[3569] = 157.977883096366
    sp_jac_ini[3570] = 157.977883096366
    sp_jac_ini[3571] = -315.955766192733
    sp_jac_ini[3572] = 1
    sp_jac_ini[3573] = 157.977883096366
    sp_jac_ini[3574] = 157.977883096366
    sp_jac_ini[3575] = -315.955766192733
    sp_jac_ini[3576] = 157.977883096366
    sp_jac_ini[3577] = -315.955766192733
    sp_jac_ini[3578] = 157.977883096366
    sp_jac_ini[3579] = 157.977883096366
    sp_jac_ini[3580] = -315.955766192733
    sp_jac_ini[3581] = 157.977883096366
    sp_jac_ini[3582] = 157.977883096366
    sp_jac_ini[3583] = -315.955766192733
    sp_jac_ini[3584] = 157.977883096366
    sp_jac_ini[3585] = 157.977883096366
    sp_jac_ini[3586] = -315.955766192733
    sp_jac_ini[3587] = 157.977883096366
    sp_jac_ini[3588] = 157.977883096366
    sp_jac_ini[3589] = 157.977883096366
    sp_jac_ini[3590] = -315.955766192733
    sp_jac_ini[3591] = 1
    sp_jac_ini[3592] = 157.977883096366
    sp_jac_ini[3593] = 157.977883096366
    sp_jac_ini[3594] = -315.955766192733
    sp_jac_ini[3595] = 157.977883096366
    sp_jac_ini[3596] = -157.977883096366
    sp_jac_ini[3597] = 157.977883096366
    sp_jac_ini[3598] = -157.977883096366
    sp_jac_ini[3599] = 157.977883096366
    sp_jac_ini[3600] = -157.977883096366
    sp_jac_ini[3601] = 157.977883096366
    sp_jac_ini[3602] = -157.977883096366
    sp_jac_ini[3603] = 157.977883096366
    sp_jac_ini[3604] = -157.977883096366
    sp_jac_ini[3605] = 157.977883096366
    sp_jac_ini[3606] = -157.977883096366
    sp_jac_ini[3607] = 157.977883096366
    sp_jac_ini[3608] = -157.977883096366
    sp_jac_ini[3609] = 157.977883096366
    sp_jac_ini[3610] = -157.977883096366
    sp_jac_ini[3611] = 157.977883096366
    sp_jac_ini[3612] = -157.977883096366
    sp_jac_ini[3613] = 157.977883096366
    sp_jac_ini[3614] = -157.977883096366
    sp_jac_ini[3615] = 157.977883096366
    sp_jac_ini[3616] = -157.977883096366
    sp_jac_ini[3617] = 157.977883096366
    sp_jac_ini[3618] = -157.977883096366
    sp_jac_ini[3619] = 157.977883096366
    sp_jac_ini[3620] = -157.977883096366
    sp_jac_ini[3621] = 157.977883096366
    sp_jac_ini[3622] = -157.977883096366
    sp_jac_ini[3623] = 157.977883096366
    sp_jac_ini[3624] = -157.977883096366
    sp_jac_ini[3625] = 157.977883096366
    sp_jac_ini[3626] = -157.977883096366
    sp_jac_ini[3627] = 135.409614082600
    sp_jac_ini[3628] = 45.1365380275333
    sp_jac_ini[3629] = -180.546152110133
    sp_jac_ini[3630] = 1
    sp_jac_ini[3631] = 135.409614082600
    sp_jac_ini[3632] = 45.1365380275333
    sp_jac_ini[3633] = -180.546152110133
    sp_jac_ini[3634] = 45.1365380275333
    sp_jac_ini[3635] = -180.546152110133
    sp_jac_ini[3636] = 135.409614082600
    sp_jac_ini[3637] = 45.1365380275333
    sp_jac_ini[3638] = -180.546152110133
    sp_jac_ini[3639] = 135.409614082600
    sp_jac_ini[3640] = 45.1365380275333
    sp_jac_ini[3641] = -180.546152110133
    sp_jac_ini[3642] = 135.409614082600
    sp_jac_ini[3643] = 45.1365380275333
    sp_jac_ini[3644] = -180.546152110133
    sp_jac_ini[3645] = 135.409614082600
    sp_jac_ini[3646] = 135.409614082600
    sp_jac_ini[3647] = 45.1365380275333
    sp_jac_ini[3648] = -180.546152110133
    sp_jac_ini[3649] = 1
    sp_jac_ini[3650] = 135.409614082600
    sp_jac_ini[3651] = 45.1365380275333
    sp_jac_ini[3652] = -180.546152110133
    sp_jac_ini[3653] = 135.409614082600
    sp_jac_ini[3654] = -135.409614082600
    sp_jac_ini[3655] = 135.409614082600
    sp_jac_ini[3656] = -135.409614082600
    sp_jac_ini[3657] = 135.409614082600
    sp_jac_ini[3658] = -135.409614082600
    sp_jac_ini[3659] = 135.409614082600
    sp_jac_ini[3660] = -135.409614082600
    sp_jac_ini[3661] = -0.212261128378539
    sp_jac_ini[3662] = -0.849044513514155
    sp_jac_ini[3663] = 0.212261128378539
    sp_jac_ini[3664] = 0.849044513514155
    sp_jac_ini[3665] = -1
    sp_jac_ini[3666] = 0.849044513514155
    sp_jac_ini[3667] = -0.212261128378539
    sp_jac_ini[3668] = -0.849044513514155
    sp_jac_ini[3669] = 0.212261128378539
    sp_jac_ini[3670] = -1
    sp_jac_ini[3671] = -0.212261128378539
    sp_jac_ini[3672] = -0.849044513514155
    sp_jac_ini[3673] = 0.212261128378539
    sp_jac_ini[3674] = 0.849044513514155
    sp_jac_ini[3675] = -1
    sp_jac_ini[3676] = 0.849044513514155
    sp_jac_ini[3677] = -0.212261128378539
    sp_jac_ini[3678] = -0.849044513514155
    sp_jac_ini[3679] = 0.212261128378539
    sp_jac_ini[3680] = -1
    sp_jac_ini[3681] = 0.212261128378539
    sp_jac_ini[3682] = 0.849044513514155
    sp_jac_ini[3683] = -0.212261128378539
    sp_jac_ini[3684] = -0.849044513514155
    sp_jac_ini[3685] = -1
    sp_jac_ini[3686] = -0.849044513514155
    sp_jac_ini[3687] = 0.212261128378539
    sp_jac_ini[3688] = 0.849044513514155
    sp_jac_ini[3689] = -0.212261128378539
    sp_jac_ini[3690] = -1
    sp_jac_ini[3691] = 105.571769313180
    sp_jac_ini[3692] = 54.0657727682604
    sp_jac_ini[3693] = -39.6392229058202
    sp_jac_ini[3694] = -10.2713736253513
    sp_jac_ini[3695] = -24.9575997948692
    sp_jac_ini[3696] = -23.2849644809540
    sp_jac_ini[3697] = -39.6392229058202
    sp_jac_ini[3698] = -10.2713736253513
    sp_jac_ini[3699] = -105.571769313180
    sp_jac_ini[3700] = -54.0657727682604
    sp_jac_ini[3701] = 39.6392229058202
    sp_jac_ini[3702] = 10.2713736253513
    sp_jac_ini[3703] = 24.9575997948692
    sp_jac_ini[3704] = 23.2849644809540
    sp_jac_ini[3705] = 39.6392229058202
    sp_jac_ini[3706] = 10.2713736253513
    sp_jac_ini[3707] = -1
    sp_jac_ini[3708] = -54.0657727682604
    sp_jac_ini[3709] = 105.571769313180
    sp_jac_ini[3710] = 10.2713736253513
    sp_jac_ini[3711] = -39.6392229058202
    sp_jac_ini[3712] = 23.2849644809540
    sp_jac_ini[3713] = -24.9575997948692
    sp_jac_ini[3714] = 10.2713736253513
    sp_jac_ini[3715] = -39.6392229058202
    sp_jac_ini[3716] = 54.0657727682604
    sp_jac_ini[3717] = -105.571769313180
    sp_jac_ini[3718] = -10.2713736253513
    sp_jac_ini[3719] = 39.6392229058202
    sp_jac_ini[3720] = -23.2849644809540
    sp_jac_ini[3721] = 24.9575997948692
    sp_jac_ini[3722] = -10.2713736253513
    sp_jac_ini[3723] = 39.6392229058202
    sp_jac_ini[3724] = -1
    sp_jac_ini[3725] = -39.6392229058202
    sp_jac_ini[3726] = -10.2713736253513
    sp_jac_ini[3727] = 105.571769313180
    sp_jac_ini[3728] = 54.0657727682604
    sp_jac_ini[3729] = -39.6392229058201
    sp_jac_ini[3730] = -10.2713736253513
    sp_jac_ini[3731] = -24.9575997948692
    sp_jac_ini[3732] = -23.2849644809540
    sp_jac_ini[3733] = 39.6392229058202
    sp_jac_ini[3734] = 10.2713736253513
    sp_jac_ini[3735] = -105.571769313180
    sp_jac_ini[3736] = -54.0657727682604
    sp_jac_ini[3737] = 39.6392229058201
    sp_jac_ini[3738] = 10.2713736253513
    sp_jac_ini[3739] = 24.9575997948692
    sp_jac_ini[3740] = 23.2849644809540
    sp_jac_ini[3741] = -1
    sp_jac_ini[3742] = 10.2713736253513
    sp_jac_ini[3743] = -39.6392229058202
    sp_jac_ini[3744] = -54.0657727682604
    sp_jac_ini[3745] = 105.571769313180
    sp_jac_ini[3746] = 10.2713736253513
    sp_jac_ini[3747] = -39.6392229058201
    sp_jac_ini[3748] = 23.2849644809540
    sp_jac_ini[3749] = -24.9575997948692
    sp_jac_ini[3750] = -10.2713736253513
    sp_jac_ini[3751] = 39.6392229058202
    sp_jac_ini[3752] = 54.0657727682604
    sp_jac_ini[3753] = -105.571769313180
    sp_jac_ini[3754] = -10.2713736253513
    sp_jac_ini[3755] = 39.6392229058201
    sp_jac_ini[3756] = -23.2849644809540
    sp_jac_ini[3757] = 24.9575997948692
    sp_jac_ini[3758] = -1
    sp_jac_ini[3759] = -24.9575997948692
    sp_jac_ini[3760] = -23.2849644809540
    sp_jac_ini[3761] = -39.6392229058202
    sp_jac_ini[3762] = -10.2713736253513
    sp_jac_ini[3763] = 105.571769313180
    sp_jac_ini[3764] = 54.0657727682604
    sp_jac_ini[3765] = -39.6392229058201
    sp_jac_ini[3766] = -10.2713736253514
    sp_jac_ini[3767] = 24.9575997948692
    sp_jac_ini[3768] = 23.2849644809540
    sp_jac_ini[3769] = 39.6392229058202
    sp_jac_ini[3770] = 10.2713736253513
    sp_jac_ini[3771] = -105.571769313180
    sp_jac_ini[3772] = -54.0657727682604
    sp_jac_ini[3773] = 39.6392229058201
    sp_jac_ini[3774] = 10.2713736253514
    sp_jac_ini[3775] = -1
    sp_jac_ini[3776] = 23.2849644809540
    sp_jac_ini[3777] = -24.9575997948692
    sp_jac_ini[3778] = 10.2713736253513
    sp_jac_ini[3779] = -39.6392229058202
    sp_jac_ini[3780] = -54.0657727682604
    sp_jac_ini[3781] = 105.571769313180
    sp_jac_ini[3782] = 10.2713736253514
    sp_jac_ini[3783] = -39.6392229058201
    sp_jac_ini[3784] = -23.2849644809540
    sp_jac_ini[3785] = 24.9575997948692
    sp_jac_ini[3786] = -10.2713736253513
    sp_jac_ini[3787] = 39.6392229058202
    sp_jac_ini[3788] = 54.0657727682604
    sp_jac_ini[3789] = -105.571769313180
    sp_jac_ini[3790] = -10.2713736253514
    sp_jac_ini[3791] = 39.6392229058201
    sp_jac_ini[3792] = -1
    sp_jac_ini[3793] = 1
    sp_jac_ini[3794] = 1
    sp_jac_ini[3795] = 1
    sp_jac_ini[3796] = -1
    sp_jac_ini[3797] = 1
    sp_jac_ini[3798] = 1
    sp_jac_ini[3799] = 1
    sp_jac_ini[3800] = -1
    sp_jac_ini[3801] = -67.7048070412999
    sp_jac_ini[3802] = -1
    sp_jac_ini[3803] = -67.7048070412999
    sp_jac_ini[3804] = -1
    sp_jac_ini[3805] = -67.7048070412999
    sp_jac_ini[3806] = -1
    sp_jac_ini[3807] = -67.7048070412999
    sp_jac_ini[3808] = -1
    sp_jac_ini[3809] = -67.7048070412999
    sp_jac_ini[3810] = -1
    sp_jac_ini[3811] = -67.7048070412999
    sp_jac_ini[3812] = -1
    sp_jac_ini[3813] = 1
    sp_jac_ini[3814] = 1
    sp_jac_ini[3815] = 1
    sp_jac_ini[3816] = -1
    sp_jac_ini[3817] = 1
    sp_jac_ini[3818] = 1
    sp_jac_ini[3819] = 1
    sp_jac_ini[3820] = -1
    sp_jac_ini[3821] = 135.409614082600
    sp_jac_ini[3822] = -135.409614082600
    sp_jac_ini[3823] = -1
    sp_jac_ini[3824] = 135.409614082600
    sp_jac_ini[3825] = -135.409614082600
    sp_jac_ini[3826] = -1
    sp_jac_ini[3827] = 135.409614082600
    sp_jac_ini[3828] = -135.409614082600
    sp_jac_ini[3829] = -1
    sp_jac_ini[3830] = 135.409614082600
    sp_jac_ini[3831] = -135.409614082600
    sp_jac_ini[3832] = -1
    sp_jac_ini[3833] = 135.409614082600
    sp_jac_ini[3834] = -135.409614082600
    sp_jac_ini[3835] = -1
    sp_jac_ini[3836] = 135.409614082600
    sp_jac_ini[3837] = -135.409614082600
    sp_jac_ini[3838] = -1
    sp_jac_ini[3839] = 1
    sp_jac_ini[3840] = 1
    sp_jac_ini[3841] = 1
    sp_jac_ini[3842] = -1
    sp_jac_ini[3843] = 1
    sp_jac_ini[3844] = 1
    sp_jac_ini[3845] = 1
    sp_jac_ini[3846] = -1
    sp_jac_ini[3847] = 67.7048070412999
    sp_jac_ini[3848] = -67.7048070412999
    sp_jac_ini[3849] = -1
    sp_jac_ini[3850] = 67.7048070412999
    sp_jac_ini[3851] = -67.7048070412999
    sp_jac_ini[3852] = -1
    sp_jac_ini[3853] = 67.7048070412999
    sp_jac_ini[3854] = -67.7048070412999
    sp_jac_ini[3855] = -1
    sp_jac_ini[3856] = 67.7048070412999
    sp_jac_ini[3857] = -67.7048070412999
    sp_jac_ini[3858] = -1
    sp_jac_ini[3859] = 67.7048070412999
    sp_jac_ini[3860] = -67.7048070412999
    sp_jac_ini[3861] = -1
    sp_jac_ini[3862] = 67.7048070412999
    sp_jac_ini[3863] = -67.7048070412999
    sp_jac_ini[3864] = -1
    sp_jac_ini[3865] = 1
    sp_jac_ini[3866] = 1
    sp_jac_ini[3867] = 1
    sp_jac_ini[3868] = -1
    sp_jac_ini[3869] = 1
    sp_jac_ini[3870] = 1
    sp_jac_ini[3871] = 1
    sp_jac_ini[3872] = -1
    sp_jac_ini[3873] = 45.1365380275333
    sp_jac_ini[3874] = -45.1365380275333
    sp_jac_ini[3875] = -1
    sp_jac_ini[3876] = 45.1365380275333
    sp_jac_ini[3877] = -45.1365380275333
    sp_jac_ini[3878] = -1
    sp_jac_ini[3879] = 45.1365380275333
    sp_jac_ini[3880] = -45.1365380275333
    sp_jac_ini[3881] = -1
    sp_jac_ini[3882] = 45.1365380275333
    sp_jac_ini[3883] = -45.1365380275333
    sp_jac_ini[3884] = -1
    sp_jac_ini[3885] = 45.1365380275333
    sp_jac_ini[3886] = -45.1365380275333
    sp_jac_ini[3887] = -1
    sp_jac_ini[3888] = 45.1365380275333
    sp_jac_ini[3889] = -45.1365380275333
    sp_jac_ini[3890] = -1
    sp_jac_ini[3891] = 1
    sp_jac_ini[3892] = 1
    sp_jac_ini[3893] = 1
    sp_jac_ini[3894] = -1
    sp_jac_ini[3895] = 1
    sp_jac_ini[3896] = 1
    sp_jac_ini[3897] = 1
    sp_jac_ini[3898] = -1
    sp_jac_ini[3899] = 157.977883096366
    sp_jac_ini[3900] = -157.977883096366
    sp_jac_ini[3901] = -1
    sp_jac_ini[3902] = 157.977883096366
    sp_jac_ini[3903] = -157.977883096366
    sp_jac_ini[3904] = -1
    sp_jac_ini[3905] = 157.977883096366
    sp_jac_ini[3906] = -157.977883096366
    sp_jac_ini[3907] = -1
    sp_jac_ini[3908] = 157.977883096366
    sp_jac_ini[3909] = -157.977883096366
    sp_jac_ini[3910] = -1
    sp_jac_ini[3911] = 157.977883096366
    sp_jac_ini[3912] = -157.977883096366
    sp_jac_ini[3913] = -1
    sp_jac_ini[3914] = 157.977883096366
    sp_jac_ini[3915] = -157.977883096366
    sp_jac_ini[3916] = -1
    sp_jac_ini[3917] = 1
    sp_jac_ini[3918] = 1
    sp_jac_ini[3919] = 1
    sp_jac_ini[3920] = -1
    sp_jac_ini[3921] = 1
    sp_jac_ini[3922] = 1
    sp_jac_ini[3923] = 1
    sp_jac_ini[3924] = -1
    sp_jac_ini[3925] = -157.977883096366
    sp_jac_ini[3926] = 157.977883096366
    sp_jac_ini[3927] = -1
    sp_jac_ini[3928] = -157.977883096366
    sp_jac_ini[3929] = 157.977883096366
    sp_jac_ini[3930] = -1
    sp_jac_ini[3931] = 157.977883096366
    sp_jac_ini[3932] = -157.977883096366
    sp_jac_ini[3933] = -1
    sp_jac_ini[3934] = 157.977883096366
    sp_jac_ini[3935] = -157.977883096366
    sp_jac_ini[3936] = -1
    sp_jac_ini[3937] = 157.977883096366
    sp_jac_ini[3938] = -157.977883096366
    sp_jac_ini[3939] = -1
    sp_jac_ini[3940] = 157.977883096366
    sp_jac_ini[3941] = -157.977883096366
    sp_jac_ini[3942] = -1
    sp_jac_ini[3943] = 1
    sp_jac_ini[3944] = 1
    sp_jac_ini[3945] = 1
    sp_jac_ini[3946] = -1
    sp_jac_ini[3947] = 1
    sp_jac_ini[3948] = 1
    sp_jac_ini[3949] = 1
    sp_jac_ini[3950] = -1
    sp_jac_ini[3951] = -157.977883096366
    sp_jac_ini[3952] = 157.977883096366
    sp_jac_ini[3953] = -1
    sp_jac_ini[3954] = -157.977883096366
    sp_jac_ini[3955] = 157.977883096366
    sp_jac_ini[3956] = -1
    sp_jac_ini[3957] = 157.977883096366
    sp_jac_ini[3958] = -157.977883096366
    sp_jac_ini[3959] = -1
    sp_jac_ini[3960] = 157.977883096366
    sp_jac_ini[3961] = -157.977883096366
    sp_jac_ini[3962] = -1
    sp_jac_ini[3963] = 157.977883096366
    sp_jac_ini[3964] = -157.977883096366
    sp_jac_ini[3965] = -1
    sp_jac_ini[3966] = 157.977883096366
    sp_jac_ini[3967] = -157.977883096366
    sp_jac_ini[3968] = -1
    sp_jac_ini[3969] = 1
    sp_jac_ini[3970] = 1
    sp_jac_ini[3971] = 1
    sp_jac_ini[3972] = -1
    sp_jac_ini[3973] = 1
    sp_jac_ini[3974] = 1
    sp_jac_ini[3975] = 1
    sp_jac_ini[3976] = -1
    sp_jac_ini[3977] = -157.977883096366
    sp_jac_ini[3978] = 157.977883096366
    sp_jac_ini[3979] = -1
    sp_jac_ini[3980] = -157.977883096366
    sp_jac_ini[3981] = 157.977883096366
    sp_jac_ini[3982] = -1
    sp_jac_ini[3983] = 157.977883096366
    sp_jac_ini[3984] = -157.977883096366
    sp_jac_ini[3985] = -1
    sp_jac_ini[3986] = 157.977883096366
    sp_jac_ini[3987] = -157.977883096366
    sp_jac_ini[3988] = -1
    sp_jac_ini[3989] = 157.977883096366
    sp_jac_ini[3990] = -157.977883096366
    sp_jac_ini[3991] = -1
    sp_jac_ini[3992] = 157.977883096366
    sp_jac_ini[3993] = -157.977883096366
    sp_jac_ini[3994] = -1
    sp_jac_ini[3995] = 1
    sp_jac_ini[3996] = 1
    sp_jac_ini[3997] = 1
    sp_jac_ini[3998] = -1
    sp_jac_ini[3999] = 1
    sp_jac_ini[4000] = 1
    sp_jac_ini[4001] = 1
    sp_jac_ini[4002] = -1
    sp_jac_ini[4003] = -157.977883096366
    sp_jac_ini[4004] = 157.977883096366
    sp_jac_ini[4005] = -1
    sp_jac_ini[4006] = -157.977883096366
    sp_jac_ini[4007] = 157.977883096366
    sp_jac_ini[4008] = -1
    sp_jac_ini[4009] = 157.977883096366
    sp_jac_ini[4010] = -157.977883096366
    sp_jac_ini[4011] = -1
    sp_jac_ini[4012] = 157.977883096366
    sp_jac_ini[4013] = -157.977883096366
    sp_jac_ini[4014] = -1
    sp_jac_ini[4015] = 157.977883096366
    sp_jac_ini[4016] = -157.977883096366
    sp_jac_ini[4017] = -1
    sp_jac_ini[4018] = 157.977883096366
    sp_jac_ini[4019] = -157.977883096366
    sp_jac_ini[4020] = -1
    sp_jac_ini[4021] = 1
    sp_jac_ini[4022] = 1
    sp_jac_ini[4023] = 1
    sp_jac_ini[4024] = -1
    sp_jac_ini[4025] = 1
    sp_jac_ini[4026] = 1
    sp_jac_ini[4027] = 1
    sp_jac_ini[4028] = -1
    sp_jac_ini[4029] = 45.1365380275333
    sp_jac_ini[4030] = -45.1365380275333
    sp_jac_ini[4031] = -1
    sp_jac_ini[4032] = 45.1365380275333
    sp_jac_ini[4033] = -45.1365380275333
    sp_jac_ini[4034] = -1
    sp_jac_ini[4035] = 45.1365380275333
    sp_jac_ini[4036] = -45.1365380275333
    sp_jac_ini[4037] = -1
    sp_jac_ini[4038] = 45.1365380275333
    sp_jac_ini[4039] = -45.1365380275333
    sp_jac_ini[4040] = -1
    sp_jac_ini[4041] = 45.1365380275333
    sp_jac_ini[4042] = -45.1365380275333
    sp_jac_ini[4043] = -1
    sp_jac_ini[4044] = 45.1365380275333
    sp_jac_ini[4045] = -45.1365380275333
    sp_jac_ini[4046] = -1
    sp_jac_ini[4047] = 1
    sp_jac_ini[4048] = 1
    sp_jac_ini[4049] = 1
    sp_jac_ini[4050] = -1
    sp_jac_ini[4051] = 1
    sp_jac_ini[4052] = 1
    sp_jac_ini[4053] = 1
    sp_jac_ini[4054] = -1
    sp_jac_ini[4055] = -135.409614082600
    sp_jac_ini[4056] = 135.409614082600
    sp_jac_ini[4057] = -1
    sp_jac_ini[4058] = -135.409614082600
    sp_jac_ini[4059] = 135.409614082600
    sp_jac_ini[4060] = -1
    sp_jac_ini[4061] = 135.409614082600
    sp_jac_ini[4062] = -135.409614082600
    sp_jac_ini[4063] = -1
    sp_jac_ini[4064] = 135.409614082600
    sp_jac_ini[4065] = -135.409614082600
    sp_jac_ini[4066] = -1
    sp_jac_ini[4067] = 135.409614082600
    sp_jac_ini[4068] = -135.409614082600
    sp_jac_ini[4069] = -1
    sp_jac_ini[4070] = 135.409614082600
    sp_jac_ini[4071] = -135.409614082600
    sp_jac_ini[4072] = -1
    sp_jac_ini[4073] = 1
    sp_jac_ini[4074] = 1
    sp_jac_ini[4075] = 1
    sp_jac_ini[4076] = -1
    sp_jac_ini[4077] = 1
    sp_jac_ini[4078] = 1
    sp_jac_ini[4079] = 1
    sp_jac_ini[4080] = -1
    sp_jac_ini[4117] = 1
    sp_jac_ini[4118] = 1
    sp_jac_ini[4119] = 1
    sp_jac_ini[4120] = 1
    sp_jac_ini[4121] = 1
    sp_jac_ini[4122] = 1
    sp_jac_ini[4123] = 1
    sp_jac_ini[4124] = 1
    sp_jac_ini[4161] = 1
    sp_jac_ini[4162] = 1
    sp_jac_ini[4163] = 1
    sp_jac_ini[4164] = 1
    sp_jac_ini[4165] = 1
    sp_jac_ini[4166] = 1
    sp_jac_ini[4167] = 1
    sp_jac_ini[4168] = 1
    sp_jac_ini[4205] = 1
    sp_jac_ini[4206] = 1
    sp_jac_ini[4207] = 1
    sp_jac_ini[4208] = 1
    sp_jac_ini[4209] = 1
    sp_jac_ini[4210] = 1
    sp_jac_ini[4211] = 1
    sp_jac_ini[4212] = 1
    sp_jac_ini[4249] = 1
    sp_jac_ini[4250] = 1
    sp_jac_ini[4251] = 1
    sp_jac_ini[4252] = 1
    sp_jac_ini[4253] = 1
    sp_jac_ini[4254] = 1
    sp_jac_ini[4255] = 1
    sp_jac_ini[4256] = 1
    sp_jac_ini[4293] = 1
    sp_jac_ini[4294] = 1
    sp_jac_ini[4295] = 1
    sp_jac_ini[4296] = 1
    sp_jac_ini[4297] = 1
    sp_jac_ini[4298] = 1
    sp_jac_ini[4299] = 1
    sp_jac_ini[4300] = 1
    sp_jac_ini[4337] = 1
    sp_jac_ini[4338] = 1
    sp_jac_ini[4339] = 1
    sp_jac_ini[4340] = 1
    sp_jac_ini[4341] = 1
    sp_jac_ini[4342] = 1
    sp_jac_ini[4343] = 1
    sp_jac_ini[4344] = 1
    sp_jac_ini[4357] = 1
    sp_jac_ini[4358] = 1
    sp_jac_ini[4359] = 1.00000000000000
    sp_jac_ini[4360] = 1.00000000000000
    sp_jac_ini[4373] = 1
    sp_jac_ini[4374] = 1
    sp_jac_ini[4375] = 1.00000000000000
    sp_jac_ini[4376] = 1.00000000000000
    sp_jac_ini[4389] = 1
    sp_jac_ini[4390] = 1
    sp_jac_ini[4391] = 1.00000000000000
    sp_jac_ini[4392] = 1.00000000000000
    sp_jac_ini[4405] = 1
    sp_jac_ini[4406] = 1
    sp_jac_ini[4407] = 1.00000000000000
    sp_jac_ini[4408] = 1.00000000000000
    sp_jac_ini[4421] = 1
    sp_jac_ini[4422] = 1
    sp_jac_ini[4423] = 1.00000000000000
    sp_jac_ini[4424] = 1.00000000000000
    sp_jac_ini[4431] = -1/3
    sp_jac_ini[4444] = -1/3
    sp_jac_ini[4457] = -1/3
    sp_jac_ini[4464] = 1
    sp_jac_ini[4465] = 1
    sp_jac_ini[4469] = -1
    sp_jac_ini[4472] = 1
    sp_jac_ini[4511] = 1
    sp_jac_ini[4515] = 1
    sp_jac_ini[4517] = 1
    sp_jac_ini[4521] = 1
    sp_jac_ini[4560] = 1
    sp_jac_ini[4564] = 1
    sp_jac_ini[4566] = 1
    sp_jac_ini[4570] = 1

def sp_jac_ini_vectors():

    sp_jac_ini_ia = [0, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 337, 405, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 338, 406, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 339, 407, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 340, 408, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 341, 409, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 342, 410, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 9, 10, 11, 12, 13, 14, 15, 16, 77, 78, 79, 80, 81, 82, 83, 84, 345, 9, 10, 11, 12, 13, 14, 15, 16, 77, 78, 79, 80, 81, 82, 83, 84, 346, 9, 10, 11, 12, 13, 14, 15, 16, 77, 78, 79, 80, 81, 82, 83, 84, 347, 9, 10, 11, 12, 13, 14, 15, 16, 77, 78, 79, 80, 81, 82, 83, 84, 348, 9, 10, 11, 12, 13, 14, 15, 16, 77, 78, 79, 80, 81, 82, 83, 84, 349, 9, 10, 11, 12, 13, 14, 15, 16, 77, 78, 79, 80, 81, 82, 83, 84, 350, 9, 10, 11, 12, 13, 14, 15, 16, 77, 78, 79, 80, 81, 82, 83, 84, 9, 10, 11, 12, 13, 14, 15, 16, 77, 78, 79, 80, 81, 82, 83, 84, 17, 18, 19, 20, 21, 22, 23, 24, 157, 158, 159, 160, 161, 162, 163, 164, 353, 17, 18, 19, 20, 21, 22, 23, 24, 157, 158, 159, 160, 161, 162, 163, 164, 354, 17, 18, 19, 20, 21, 22, 23, 24, 157, 158, 159, 160, 161, 162, 163, 164, 355, 17, 18, 19, 20, 21, 22, 23, 24, 157, 158, 159, 160, 161, 162, 163, 164, 356, 17, 18, 19, 20, 21, 22, 23, 24, 157, 158, 159, 160, 161, 162, 163, 164, 357, 17, 18, 19, 20, 21, 22, 23, 24, 157, 158, 159, 160, 161, 162, 163, 164, 358, 17, 18, 19, 20, 21, 22, 23, 24, 157, 158, 159, 160, 161, 162, 163, 164, 17, 18, 19, 20, 21, 22, 23, 24, 157, 158, 159, 160, 161, 162, 163, 164, 25, 26, 27, 28, 29, 30, 31, 32, 101, 102, 103, 104, 105, 106, 107, 108, 361, 25, 26, 27, 28, 29, 30, 31, 32, 101, 102, 103, 104, 105, 106, 107, 108, 362, 25, 26, 27, 28, 29, 30, 31, 32, 101, 102, 103, 104, 105, 106, 107, 108, 363, 25, 26, 27, 28, 29, 30, 31, 32, 101, 102, 103, 104, 105, 106, 107, 108, 364, 25, 26, 27, 28, 29, 30, 31, 32, 101, 102, 103, 104, 105, 106, 107, 108, 365, 25, 26, 27, 28, 29, 30, 31, 32, 101, 102, 103, 104, 105, 106, 107, 108, 366, 25, 26, 27, 28, 29, 30, 31, 32, 101, 102, 103, 104, 105, 106, 107, 108, 25, 26, 27, 28, 29, 30, 31, 32, 101, 102, 103, 104, 105, 106, 107, 108, 33, 34, 35, 36, 37, 38, 39, 40, 125, 126, 127, 128, 129, 130, 131, 132, 369, 33, 34, 35, 36, 37, 38, 39, 40, 125, 126, 127, 128, 129, 130, 131, 132, 370, 33, 34, 35, 36, 37, 38, 39, 40, 125, 126, 127, 128, 129, 130, 131, 132, 371, 33, 34, 35, 36, 37, 38, 39, 40, 125, 126, 127, 128, 129, 130, 131, 132, 372, 33, 34, 35, 36, 37, 38, 39, 40, 125, 126, 127, 128, 129, 130, 131, 132, 373, 33, 34, 35, 36, 37, 38, 39, 40, 125, 126, 127, 128, 129, 130, 131, 132, 374, 33, 34, 35, 36, 37, 38, 39, 40, 125, 126, 127, 128, 129, 130, 131, 132, 33, 34, 35, 36, 37, 38, 39, 40, 125, 126, 127, 128, 129, 130, 131, 132, 41, 42, 43, 44, 45, 46, 47, 48, 133, 134, 135, 136, 137, 138, 139, 140, 377, 41, 42, 43, 44, 45, 46, 47, 48, 133, 134, 135, 136, 137, 138, 139, 140, 378, 41, 42, 43, 44, 45, 46, 47, 48, 133, 134, 135, 136, 137, 138, 139, 140, 379, 41, 42, 43, 44, 45, 46, 47, 48, 133, 134, 135, 136, 137, 138, 139, 140, 380, 41, 42, 43, 44, 45, 46, 47, 48, 133, 134, 135, 136, 137, 138, 139, 140, 381, 41, 42, 43, 44, 45, 46, 47, 48, 133, 134, 135, 136, 137, 138, 139, 140, 382, 41, 42, 43, 44, 45, 46, 47, 48, 133, 134, 135, 136, 137, 138, 139, 140, 41, 42, 43, 44, 45, 46, 47, 48, 133, 134, 135, 136, 137, 138, 139, 140, 49, 223, 385, 50, 224, 386, 51, 229, 387, 52, 230, 388, 53, 167, 389, 54, 168, 390, 55, 173, 391, 56, 174, 392, 57, 183, 393, 58, 184, 394, 59, 189, 395, 60, 190, 396, 61, 191, 397, 62, 192, 398, 63, 197, 399, 64, 198, 400, 65, 199, 401, 66, 200, 402, 67, 205, 403, 68, 206, 404, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 9, 10, 11, 12, 13, 14, 15, 16, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 9, 10, 11, 12, 13, 14, 15, 16, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 9, 10, 11, 12, 13, 14, 15, 16, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 9, 10, 11, 12, 13, 14, 15, 16, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 9, 10, 11, 12, 13, 14, 15, 16, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 9, 10, 11, 12, 13, 14, 15, 16, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 9, 10, 11, 12, 13, 14, 15, 16, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 9, 10, 11, 12, 13, 14, 15, 16, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 141, 142, 143, 144, 145, 146, 147, 148, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 141, 142, 143, 144, 145, 146, 147, 148, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 141, 142, 143, 144, 145, 146, 147, 148, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 141, 142, 143, 144, 145, 146, 147, 148, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 141, 142, 143, 144, 145, 146, 147, 148, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 141, 142, 143, 144, 145, 146, 147, 148, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 141, 142, 143, 144, 145, 146, 147, 148, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 141, 142, 143, 144, 145, 146, 147, 148, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 25, 26, 27, 28, 29, 30, 31, 32, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 25, 26, 27, 28, 29, 30, 31, 32, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 25, 26, 27, 28, 29, 30, 31, 32, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 25, 26, 27, 28, 29, 30, 31, 32, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 25, 26, 27, 28, 29, 30, 31, 32, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 25, 26, 27, 28, 29, 30, 31, 32, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 25, 26, 27, 28, 29, 30, 31, 32, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 25, 26, 27, 28, 29, 30, 31, 32, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 33, 34, 35, 36, 37, 38, 39, 40, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 33, 34, 35, 36, 37, 38, 39, 40, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 33, 34, 35, 36, 37, 38, 39, 40, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 33, 34, 35, 36, 37, 38, 39, 40, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 33, 34, 35, 36, 37, 38, 39, 40, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 33, 34, 35, 36, 37, 38, 39, 40, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 33, 34, 35, 36, 37, 38, 39, 40, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 33, 34, 35, 36, 37, 38, 39, 40, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 41, 42, 43, 44, 45, 46, 47, 48, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 414, 41, 42, 43, 44, 45, 46, 47, 48, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 415, 41, 42, 43, 44, 45, 46, 47, 48, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 416, 41, 42, 43, 44, 45, 46, 47, 48, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 417, 41, 42, 43, 44, 45, 46, 47, 48, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 418, 41, 42, 43, 44, 45, 46, 47, 48, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 419, 41, 42, 43, 44, 45, 46, 47, 48, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 41, 42, 43, 44, 45, 46, 47, 48, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 85, 86, 87, 88, 89, 90, 91, 92, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 85, 86, 87, 88, 89, 90, 91, 92, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 85, 86, 87, 88, 89, 90, 91, 92, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 85, 86, 87, 88, 89, 90, 91, 92, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 85, 86, 87, 88, 89, 90, 91, 92, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 85, 86, 87, 88, 89, 90, 91, 92, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 85, 86, 87, 88, 89, 90, 91, 92, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 85, 86, 87, 88, 89, 90, 91, 92, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 17, 18, 19, 20, 21, 22, 23, 24, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 424, 17, 18, 19, 20, 21, 22, 23, 24, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 425, 17, 18, 19, 20, 21, 22, 23, 24, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 426, 17, 18, 19, 20, 21, 22, 23, 24, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 427, 17, 18, 19, 20, 21, 22, 23, 24, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 428, 17, 18, 19, 20, 21, 22, 23, 24, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 429, 17, 18, 19, 20, 21, 22, 23, 24, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 17, 18, 19, 20, 21, 22, 23, 24, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 173, 166, 174, 53, 167, 175, 54, 168, 176, 169, 177, 207, 170, 178, 208, 171, 179, 209, 172, 180, 210, 55, 165, 173, 181, 56, 166, 174, 182, 167, 175, 183, 223, 168, 176, 184, 224, 169, 177, 185, 225, 170, 178, 186, 226, 171, 179, 187, 227, 172, 180, 188, 228, 173, 181, 189, 229, 174, 182, 190, 230, 57, 175, 183, 191, 58, 176, 184, 192, 177, 185, 193, 211, 178, 186, 194, 212, 179, 187, 195, 213, 180, 188, 196, 214, 59, 181, 189, 197, 60, 182, 190, 198, 61, 183, 191, 199, 62, 184, 192, 200, 185, 193, 201, 215, 186, 194, 202, 216, 187, 195, 203, 217, 188, 196, 204, 218, 63, 189, 197, 205, 64, 190, 198, 206, 65, 191, 199, 420, 66, 192, 200, 193, 201, 219, 194, 202, 220, 195, 203, 221, 196, 204, 222, 67, 197, 205, 421, 68, 198, 206, 169, 207, 170, 208, 171, 209, 172, 210, 185, 211, 186, 212, 187, 213, 188, 214, 193, 215, 194, 216, 195, 217, 196, 218, 201, 219, 202, 220, 203, 221, 204, 222, 49, 175, 223, 430, 50, 176, 224, 177, 225, 231, 178, 226, 232, 179, 227, 233, 180, 228, 234, 51, 181, 229, 431, 52, 182, 230, 225, 231, 226, 232, 227, 233, 228, 234, 1, 2, 3, 4, 235, 1, 2, 3, 4, 236, 3, 4, 5, 6, 237, 3, 4, 5, 6, 238, 1, 2, 5, 6, 239, 1, 2, 5, 6, 240, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 241, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 242, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 243, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 244, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 245, 1, 2, 3, 4, 5, 6, 7, 8, 69, 70, 71, 72, 73, 74, 75, 76, 246, 241, 243, 245, 247, 242, 244, 246, 248, 167, 249, 168, 250, 169, 251, 170, 252, 171, 253, 172, 254, 249, 251, 253, 255, 250, 252, 254, 256, 167, 175, 257, 168, 176, 258, 169, 177, 259, 170, 178, 260, 171, 179, 261, 172, 180, 262, 257, 259, 261, 263, 258, 260, 262, 264, 175, 183, 265, 176, 184, 266, 177, 185, 267, 178, 186, 268, 179, 187, 269, 180, 188, 270, 265, 267, 269, 271, 266, 268, 270, 272, 183, 191, 273, 184, 192, 274, 185, 193, 275, 186, 194, 276, 187, 195, 277, 188, 196, 278, 273, 275, 277, 279, 274, 276, 278, 280, 191, 199, 281, 192, 200, 282, 193, 201, 283, 194, 202, 284, 195, 203, 285, 196, 204, 286, 281, 283, 285, 287, 282, 284, 286, 288, 53, 167, 289, 54, 168, 290, 169, 207, 291, 170, 208, 292, 171, 209, 293, 172, 210, 294, 289, 291, 293, 295, 290, 292, 294, 296, 57, 183, 297, 58, 184, 298, 185, 211, 299, 186, 212, 300, 187, 213, 301, 188, 214, 302, 297, 299, 301, 303, 298, 300, 302, 304, 61, 191, 305, 62, 192, 306, 193, 215, 307, 194, 216, 308, 195, 217, 309, 196, 218, 310, 305, 307, 309, 311, 306, 308, 310, 312, 65, 199, 313, 66, 200, 314, 201, 219, 315, 202, 220, 316, 203, 221, 317, 204, 222, 318, 313, 315, 317, 319, 314, 316, 318, 320, 175, 223, 321, 176, 224, 322, 177, 225, 323, 178, 226, 324, 179, 227, 325, 180, 228, 326, 321, 323, 325, 327, 322, 324, 326, 328, 49, 223, 329, 50, 224, 330, 225, 231, 331, 226, 232, 332, 227, 233, 333, 228, 234, 334, 329, 331, 333, 335, 330, 332, 334, 336, 1, 2, 7, 8, 337, 338, 3, 4, 7, 8, 339, 340, 5, 6, 7, 8, 341, 342, 1, 2, 7, 8, 337, 338, 3, 4, 7, 8, 339, 340, 5, 6, 7, 8, 341, 342, 337, 339, 341, 343, 338, 340, 342, 344, 9, 10, 15, 16, 345, 346, 11, 12, 15, 16, 347, 348, 13, 14, 15, 16, 349, 350, 9, 10, 15, 16, 345, 346, 11, 12, 15, 16, 347, 348, 13, 14, 15, 16, 349, 350, 345, 347, 349, 351, 346, 348, 350, 352, 17, 18, 23, 24, 353, 354, 19, 20, 23, 24, 355, 356, 21, 22, 23, 24, 357, 358, 17, 18, 23, 24, 353, 354, 19, 20, 23, 24, 355, 356, 21, 22, 23, 24, 357, 358, 353, 355, 357, 359, 354, 356, 358, 360, 25, 26, 31, 32, 361, 362, 27, 28, 31, 32, 363, 364, 29, 30, 31, 32, 365, 366, 25, 26, 31, 32, 361, 362, 27, 28, 31, 32, 363, 364, 29, 30, 31, 32, 365, 366, 361, 363, 365, 367, 362, 364, 366, 368, 33, 34, 39, 40, 369, 370, 35, 36, 39, 40, 371, 372, 37, 38, 39, 40, 373, 374, 33, 34, 39, 40, 369, 370, 35, 36, 39, 40, 371, 372, 37, 38, 39, 40, 373, 374, 369, 371, 373, 375, 370, 372, 374, 376, 41, 42, 47, 48, 377, 378, 43, 44, 47, 48, 379, 380, 45, 46, 47, 48, 381, 382, 41, 42, 47, 48, 377, 378, 43, 44, 47, 48, 379, 380, 45, 46, 47, 48, 381, 382, 377, 379, 381, 383, 378, 380, 382, 384, 49, 50, 51, 52, 385, 386, 49, 50, 51, 52, 385, 386, 385, 387, 386, 388, 53, 54, 55, 56, 389, 390, 53, 54, 55, 56, 389, 390, 389, 391, 390, 392, 57, 58, 59, 60, 393, 394, 57, 58, 59, 60, 393, 394, 393, 395, 394, 396, 61, 62, 63, 64, 397, 398, 61, 62, 63, 64, 397, 398, 397, 399, 398, 400, 65, 66, 67, 68, 401, 402, 65, 66, 67, 68, 401, 402, 401, 403, 402, 404, 1, 2, 7, 8, 405, 406, 411, 1, 2, 7, 8, 405, 406, 3, 4, 7, 8, 407, 408, 411, 3, 4, 7, 8, 407, 408, 5, 6, 7, 8, 409, 410, 411, 5, 6, 7, 8, 409, 410, 411, 412, 413, 249, 255, 412, 405, 406, 413, 133, 134, 139, 140, 414, 415, 133, 134, 139, 140, 414, 415, 135, 136, 139, 140, 416, 417, 135, 136, 139, 140, 416, 417, 137, 138, 139, 140, 418, 419, 137, 138, 139, 140, 418, 419, 199, 205, 420, 422, 199, 205, 421, 422, 422, 423, 414, 415, 423, 157, 158, 163, 164, 424, 425, 157, 158, 163, 164, 424, 425, 159, 160, 163, 164, 426, 427, 159, 160, 163, 164, 426, 427, 161, 162, 163, 164, 428, 429, 161, 162, 163, 164, 428, 429, 223, 229, 430, 432, 223, 229, 431, 432, 432, 433, 424, 425, 433]
    sp_jac_ini_ja = [0, 1, 19, 37, 55, 73, 91, 109, 125, 141, 158, 175, 192, 209, 226, 243, 259, 275, 292, 309, 326, 343, 360, 377, 393, 409, 426, 443, 460, 477, 494, 511, 527, 543, 560, 577, 594, 611, 628, 645, 661, 677, 694, 711, 728, 745, 762, 779, 795, 811, 814, 817, 820, 823, 826, 829, 832, 835, 838, 841, 844, 847, 850, 853, 856, 859, 862, 865, 868, 871, 895, 919, 943, 967, 991, 1015, 1039, 1063, 1095, 1127, 1159, 1191, 1223, 1255, 1287, 1319, 1351, 1383, 1415, 1447, 1479, 1511, 1543, 1575, 1599, 1623, 1647, 1671, 1695, 1719, 1743, 1767, 1799, 1831, 1863, 1895, 1927, 1959, 1991, 2023, 2047, 2071, 2095, 2119, 2143, 2167, 2191, 2215, 2239, 2263, 2287, 2311, 2335, 2359, 2383, 2407, 2439, 2471, 2503, 2535, 2567, 2599, 2631, 2663, 2688, 2713, 2738, 2763, 2788, 2813, 2837, 2861, 2885, 2909, 2933, 2957, 2981, 3005, 3029, 3053, 3077, 3101, 3125, 3149, 3173, 3197, 3221, 3245, 3270, 3295, 3320, 3345, 3370, 3395, 3419, 3443, 3445, 3447, 3450, 3453, 3456, 3459, 3462, 3465, 3469, 3473, 3477, 3481, 3485, 3489, 3493, 3497, 3501, 3505, 3509, 3513, 3517, 3521, 3525, 3529, 3533, 3537, 3541, 3545, 3549, 3553, 3557, 3561, 3565, 3569, 3573, 3576, 3579, 3582, 3585, 3588, 3592, 3595, 3597, 3599, 3601, 3603, 3605, 3607, 3609, 3611, 3613, 3615, 3617, 3619, 3621, 3623, 3625, 3627, 3631, 3634, 3637, 3640, 3643, 3646, 3650, 3653, 3655, 3657, 3659, 3661, 3666, 3671, 3676, 3681, 3686, 3691, 3708, 3725, 3742, 3759, 3776, 3793, 3797, 3801, 3803, 3805, 3807, 3809, 3811, 3813, 3817, 3821, 3824, 3827, 3830, 3833, 3836, 3839, 3843, 3847, 3850, 3853, 3856, 3859, 3862, 3865, 3869, 3873, 3876, 3879, 3882, 3885, 3888, 3891, 3895, 3899, 3902, 3905, 3908, 3911, 3914, 3917, 3921, 3925, 3928, 3931, 3934, 3937, 3940, 3943, 3947, 3951, 3954, 3957, 3960, 3963, 3966, 3969, 3973, 3977, 3980, 3983, 3986, 3989, 3992, 3995, 3999, 4003, 4006, 4009, 4012, 4015, 4018, 4021, 4025, 4029, 4032, 4035, 4038, 4041, 4044, 4047, 4051, 4055, 4058, 4061, 4064, 4067, 4070, 4073, 4077, 4081, 4087, 4093, 4099, 4105, 4111, 4117, 4121, 4125, 4131, 4137, 4143, 4149, 4155, 4161, 4165, 4169, 4175, 4181, 4187, 4193, 4199, 4205, 4209, 4213, 4219, 4225, 4231, 4237, 4243, 4249, 4253, 4257, 4263, 4269, 4275, 4281, 4287, 4293, 4297, 4301, 4307, 4313, 4319, 4325, 4331, 4337, 4341, 4345, 4351, 4357, 4359, 4361, 4367, 4373, 4375, 4377, 4383, 4389, 4391, 4393, 4399, 4405, 4407, 4409, 4415, 4421, 4423, 4425, 4432, 4438, 4445, 4451, 4458, 4464, 4467, 4470, 4473, 4479, 4485, 4491, 4497, 4503, 4509, 4513, 4517, 4519, 4522, 4528, 4534, 4540, 4546, 4552, 4558, 4562, 4566, 4568, 4571]
    sp_jac_ini_nia = 434
    sp_jac_ini_nja = 434
    return sp_jac_ini_ia, sp_jac_ini_ja, sp_jac_ini_nia, sp_jac_ini_nja 




@numba.njit(cache=True)
def jac_run_ss_eval_xy(jac_run,x,y,u,p,xyup = 1):

    jac_run[337,1] = y[336]
    jac_run[337,2] = y[337]
    jac_run[337,7] = -y[336]
    jac_run[337,8] = -y[337]
    jac_run[337,337] = y[0] - y[6]
    jac_run[337,338] = y[1] - y[7]
    jac_run[338,3] = y[338]
    jac_run[338,4] = y[339]
    jac_run[338,7] = -y[338]
    jac_run[338,8] = -y[339]
    jac_run[338,339] = y[2] - y[6]
    jac_run[338,340] = y[3] - y[7]
    jac_run[339,5] = y[340]
    jac_run[339,6] = y[341]
    jac_run[339,7] = -y[340]
    jac_run[339,8] = -y[341]
    jac_run[339,341] = y[4] - y[6]
    jac_run[339,342] = y[5] - y[7]
    jac_run[340,1] = -y[337]
    jac_run[340,2] = y[336]
    jac_run[340,7] = y[337]
    jac_run[340,8] = -y[336]
    jac_run[340,337] = y[1] - y[7]
    jac_run[340,338] = -y[0] + y[6]
    jac_run[341,3] = -y[339]
    jac_run[341,4] = y[338]
    jac_run[341,7] = y[339]
    jac_run[341,8] = -y[338]
    jac_run[341,339] = y[3] - y[7]
    jac_run[341,340] = -y[2] + y[6]
    jac_run[342,5] = -y[341]
    jac_run[342,6] = y[340]
    jac_run[342,7] = y[341]
    jac_run[342,8] = -y[340]
    jac_run[342,341] = y[5] - y[7]
    jac_run[342,342] = -y[4] + y[6]
    jac_run[345,9] = y[344]
    jac_run[345,10] = y[345]
    jac_run[345,15] = -y[344]
    jac_run[345,16] = -y[345]
    jac_run[345,345] = y[8] - y[14]
    jac_run[345,346] = y[9] - y[15]
    jac_run[346,11] = y[346]
    jac_run[346,12] = y[347]
    jac_run[346,15] = -y[346]
    jac_run[346,16] = -y[347]
    jac_run[346,347] = y[10] - y[14]
    jac_run[346,348] = y[11] - y[15]
    jac_run[347,13] = y[348]
    jac_run[347,14] = y[349]
    jac_run[347,15] = -y[348]
    jac_run[347,16] = -y[349]
    jac_run[347,349] = y[12] - y[14]
    jac_run[347,350] = y[13] - y[15]
    jac_run[348,9] = -y[345]
    jac_run[348,10] = y[344]
    jac_run[348,15] = y[345]
    jac_run[348,16] = -y[344]
    jac_run[348,345] = y[9] - y[15]
    jac_run[348,346] = -y[8] + y[14]
    jac_run[349,11] = -y[347]
    jac_run[349,12] = y[346]
    jac_run[349,15] = y[347]
    jac_run[349,16] = -y[346]
    jac_run[349,347] = y[11] - y[15]
    jac_run[349,348] = -y[10] + y[14]
    jac_run[350,13] = -y[349]
    jac_run[350,14] = y[348]
    jac_run[350,15] = y[349]
    jac_run[350,16] = -y[348]
    jac_run[350,349] = y[13] - y[15]
    jac_run[350,350] = -y[12] + y[14]
    jac_run[353,17] = y[352]
    jac_run[353,18] = y[353]
    jac_run[353,23] = -y[352]
    jac_run[353,24] = -y[353]
    jac_run[353,353] = y[16] - y[22]
    jac_run[353,354] = y[17] - y[23]
    jac_run[354,19] = y[354]
    jac_run[354,20] = y[355]
    jac_run[354,23] = -y[354]
    jac_run[354,24] = -y[355]
    jac_run[354,355] = y[18] - y[22]
    jac_run[354,356] = y[19] - y[23]
    jac_run[355,21] = y[356]
    jac_run[355,22] = y[357]
    jac_run[355,23] = -y[356]
    jac_run[355,24] = -y[357]
    jac_run[355,357] = y[20] - y[22]
    jac_run[355,358] = y[21] - y[23]
    jac_run[356,17] = -y[353]
    jac_run[356,18] = y[352]
    jac_run[356,23] = y[353]
    jac_run[356,24] = -y[352]
    jac_run[356,353] = y[17] - y[23]
    jac_run[356,354] = -y[16] + y[22]
    jac_run[357,19] = -y[355]
    jac_run[357,20] = y[354]
    jac_run[357,23] = y[355]
    jac_run[357,24] = -y[354]
    jac_run[357,355] = y[19] - y[23]
    jac_run[357,356] = -y[18] + y[22]
    jac_run[358,21] = -y[357]
    jac_run[358,22] = y[356]
    jac_run[358,23] = y[357]
    jac_run[358,24] = -y[356]
    jac_run[358,357] = y[21] - y[23]
    jac_run[358,358] = -y[20] + y[22]
    jac_run[361,25] = y[360]
    jac_run[361,26] = y[361]
    jac_run[361,31] = -y[360]
    jac_run[361,32] = -y[361]
    jac_run[361,361] = y[24] - y[30]
    jac_run[361,362] = y[25] - y[31]
    jac_run[362,27] = y[362]
    jac_run[362,28] = y[363]
    jac_run[362,31] = -y[362]
    jac_run[362,32] = -y[363]
    jac_run[362,363] = y[26] - y[30]
    jac_run[362,364] = y[27] - y[31]
    jac_run[363,29] = y[364]
    jac_run[363,30] = y[365]
    jac_run[363,31] = -y[364]
    jac_run[363,32] = -y[365]
    jac_run[363,365] = y[28] - y[30]
    jac_run[363,366] = y[29] - y[31]
    jac_run[364,25] = -y[361]
    jac_run[364,26] = y[360]
    jac_run[364,31] = y[361]
    jac_run[364,32] = -y[360]
    jac_run[364,361] = y[25] - y[31]
    jac_run[364,362] = -y[24] + y[30]
    jac_run[365,27] = -y[363]
    jac_run[365,28] = y[362]
    jac_run[365,31] = y[363]
    jac_run[365,32] = -y[362]
    jac_run[365,363] = y[27] - y[31]
    jac_run[365,364] = -y[26] + y[30]
    jac_run[366,29] = -y[365]
    jac_run[366,30] = y[364]
    jac_run[366,31] = y[365]
    jac_run[366,32] = -y[364]
    jac_run[366,365] = y[29] - y[31]
    jac_run[366,366] = -y[28] + y[30]
    jac_run[369,33] = y[368]
    jac_run[369,34] = y[369]
    jac_run[369,39] = -y[368]
    jac_run[369,40] = -y[369]
    jac_run[369,369] = y[32] - y[38]
    jac_run[369,370] = y[33] - y[39]
    jac_run[370,35] = y[370]
    jac_run[370,36] = y[371]
    jac_run[370,39] = -y[370]
    jac_run[370,40] = -y[371]
    jac_run[370,371] = y[34] - y[38]
    jac_run[370,372] = y[35] - y[39]
    jac_run[371,37] = y[372]
    jac_run[371,38] = y[373]
    jac_run[371,39] = -y[372]
    jac_run[371,40] = -y[373]
    jac_run[371,373] = y[36] - y[38]
    jac_run[371,374] = y[37] - y[39]
    jac_run[372,33] = -y[369]
    jac_run[372,34] = y[368]
    jac_run[372,39] = y[369]
    jac_run[372,40] = -y[368]
    jac_run[372,369] = y[33] - y[39]
    jac_run[372,370] = -y[32] + y[38]
    jac_run[373,35] = -y[371]
    jac_run[373,36] = y[370]
    jac_run[373,39] = y[371]
    jac_run[373,40] = -y[370]
    jac_run[373,371] = y[35] - y[39]
    jac_run[373,372] = -y[34] + y[38]
    jac_run[374,37] = -y[373]
    jac_run[374,38] = y[372]
    jac_run[374,39] = y[373]
    jac_run[374,40] = -y[372]
    jac_run[374,373] = y[37] - y[39]
    jac_run[374,374] = -y[36] + y[38]
    jac_run[377,41] = y[376]
    jac_run[377,42] = y[377]
    jac_run[377,47] = -y[376]
    jac_run[377,48] = -y[377]
    jac_run[377,377] = y[40] - y[46]
    jac_run[377,378] = y[41] - y[47]
    jac_run[378,43] = y[378]
    jac_run[378,44] = y[379]
    jac_run[378,47] = -y[378]
    jac_run[378,48] = -y[379]
    jac_run[378,379] = y[42] - y[46]
    jac_run[378,380] = y[43] - y[47]
    jac_run[379,45] = y[380]
    jac_run[379,46] = y[381]
    jac_run[379,47] = -y[380]
    jac_run[379,48] = -y[381]
    jac_run[379,381] = y[44] - y[46]
    jac_run[379,382] = y[45] - y[47]
    jac_run[380,41] = -y[377]
    jac_run[380,42] = y[376]
    jac_run[380,47] = y[377]
    jac_run[380,48] = -y[376]
    jac_run[380,377] = y[41] - y[47]
    jac_run[380,378] = -y[40] + y[46]
    jac_run[381,43] = -y[379]
    jac_run[381,44] = y[378]
    jac_run[381,47] = y[379]
    jac_run[381,48] = -y[378]
    jac_run[381,379] = y[43] - y[47]
    jac_run[381,380] = -y[42] + y[46]
    jac_run[382,45] = -y[381]
    jac_run[382,46] = y[380]
    jac_run[382,47] = y[381]
    jac_run[382,48] = -y[380]
    jac_run[382,381] = y[45] - y[47]
    jac_run[382,382] = -y[44] + y[46]
    jac_run[385,49] = y[384]
    jac_run[385,50] = 1.0*y[385]
    jac_run[385,51] = -y[384]
    jac_run[385,52] = -1.0*y[385]
    jac_run[385,385] = y[48] - y[50]
    jac_run[385,386] = 1.0*y[49] - 1.0*y[51]
    jac_run[386,49] = -1.0*y[385]
    jac_run[386,50] = 1.0*y[384]
    jac_run[386,51] = 1.0*y[385]
    jac_run[386,52] = -1.0*y[384]
    jac_run[386,385] = 1.0*y[49] - 1.0*y[51]
    jac_run[386,386] = -1.0*y[48] + 1.0*y[50]
    jac_run[389,53] = y[388]
    jac_run[389,54] = 1.0*y[389]
    jac_run[389,55] = -y[388]
    jac_run[389,56] = -1.0*y[389]
    jac_run[389,389] = y[52] - y[54]
    jac_run[389,390] = 1.0*y[53] - 1.0*y[55]
    jac_run[390,53] = -1.0*y[389]
    jac_run[390,54] = 1.0*y[388]
    jac_run[390,55] = 1.0*y[389]
    jac_run[390,56] = -1.0*y[388]
    jac_run[390,389] = 1.0*y[53] - 1.0*y[55]
    jac_run[390,390] = -1.0*y[52] + 1.0*y[54]
    jac_run[393,57] = y[392]
    jac_run[393,58] = 1.0*y[393]
    jac_run[393,59] = -y[392]
    jac_run[393,60] = -1.0*y[393]
    jac_run[393,393] = y[56] - y[58]
    jac_run[393,394] = 1.0*y[57] - 1.0*y[59]
    jac_run[394,57] = -1.0*y[393]
    jac_run[394,58] = 1.0*y[392]
    jac_run[394,59] = 1.0*y[393]
    jac_run[394,60] = -1.0*y[392]
    jac_run[394,393] = 1.0*y[57] - 1.0*y[59]
    jac_run[394,394] = -1.0*y[56] + 1.0*y[58]
    jac_run[397,61] = y[396]
    jac_run[397,62] = 1.0*y[397]
    jac_run[397,63] = -y[396]
    jac_run[397,64] = -1.0*y[397]
    jac_run[397,397] = y[60] - y[62]
    jac_run[397,398] = 1.0*y[61] - 1.0*y[63]
    jac_run[398,61] = -1.0*y[397]
    jac_run[398,62] = 1.0*y[396]
    jac_run[398,63] = 1.0*y[397]
    jac_run[398,64] = -1.0*y[396]
    jac_run[398,397] = 1.0*y[61] - 1.0*y[63]
    jac_run[398,398] = -1.0*y[60] + 1.0*y[62]
    jac_run[401,65] = y[400]
    jac_run[401,66] = 1.0*y[401]
    jac_run[401,67] = -y[400]
    jac_run[401,68] = -1.0*y[401]
    jac_run[401,401] = y[64] - y[66]
    jac_run[401,402] = 1.0*y[65] - 1.0*y[67]
    jac_run[402,65] = -1.0*y[401]
    jac_run[402,66] = 1.0*y[400]
    jac_run[402,67] = 1.0*y[401]
    jac_run[402,68] = -1.0*y[400]
    jac_run[402,401] = 1.0*y[65] - 1.0*y[67]
    jac_run[402,402] = -1.0*y[64] + 1.0*y[66]
    jac_run[405,1] = y[404]
    jac_run[405,2] = 1.0*y[405]
    jac_run[405,7] = -y[404]
    jac_run[405,8] = -1.0*y[405]
    jac_run[405,405] = y[0] - y[6]
    jac_run[405,406] = 1.0*y[1] - 1.0*y[7]
    jac_run[406,1] = -1.0*y[405]
    jac_run[406,2] = 1.0*y[404]
    jac_run[406,7] = 1.0*y[405]
    jac_run[406,8] = -1.0*y[404]
    jac_run[406,405] = 1.0*y[1] - 1.0*y[7]
    jac_run[406,406] = -1.0*y[0] + 1.0*y[6]
    jac_run[407,3] = y[406]
    jac_run[407,4] = 1.0*y[407]
    jac_run[407,7] = -y[406]
    jac_run[407,8] = -1.0*y[407]
    jac_run[407,407] = y[2] - y[6]
    jac_run[407,408] = 1.0*y[3] - 1.0*y[7]
    jac_run[408,3] = -1.0*y[407]
    jac_run[408,4] = 1.0*y[406]
    jac_run[408,7] = 1.0*y[407]
    jac_run[408,8] = -1.0*y[406]
    jac_run[408,407] = 1.0*y[3] - 1.0*y[7]
    jac_run[408,408] = -1.0*y[2] + 1.0*y[6]
    jac_run[409,5] = y[408]
    jac_run[409,6] = 1.0*y[409]
    jac_run[409,7] = -y[408]
    jac_run[409,8] = -1.0*y[409]
    jac_run[409,409] = y[4] - y[6]
    jac_run[409,410] = 1.0*y[5] - 1.0*y[7]
    jac_run[410,5] = -1.0*y[409]
    jac_run[410,6] = 1.0*y[408]
    jac_run[410,7] = 1.0*y[409]
    jac_run[410,8] = -1.0*y[408]
    jac_run[410,409] = 1.0*y[5] - 1.0*y[7]
    jac_run[410,410] = -1.0*y[4] + 1.0*y[6]
    jac_run[411,413] = Piecewise(np.array([(-1, y[411] < 0), (1, True)]))
    jac_run[412,255] = y[164]
    jac_run[413,405] = -p[1]*y[404]/sqrt(y[405]**2 + y[404]**2 + 0.1) - 2*p[2]*y[404]
    jac_run[413,406] = -p[1]*y[405]/sqrt(y[405]**2 + y[404]**2 + 0.1) - 2*p[2]*y[405]
    jac_run[414,133] = y[413]
    jac_run[414,134] = 1.0*y[414]
    jac_run[414,139] = -y[413]
    jac_run[414,140] = -1.0*y[414]
    jac_run[414,414] = y[132] - y[138]
    jac_run[414,415] = 1.0*y[133] - 1.0*y[139]
    jac_run[415,133] = -1.0*y[414]
    jac_run[415,134] = 1.0*y[413]
    jac_run[415,139] = 1.0*y[414]
    jac_run[415,140] = -1.0*y[413]
    jac_run[415,414] = 1.0*y[133] - 1.0*y[139]
    jac_run[415,415] = -1.0*y[132] + 1.0*y[138]
    jac_run[416,135] = y[415]
    jac_run[416,136] = 1.0*y[416]
    jac_run[416,139] = -y[415]
    jac_run[416,140] = -1.0*y[416]
    jac_run[416,416] = y[134] - y[138]
    jac_run[416,417] = 1.0*y[135] - 1.0*y[139]
    jac_run[417,135] = -1.0*y[416]
    jac_run[417,136] = 1.0*y[415]
    jac_run[417,139] = 1.0*y[416]
    jac_run[417,140] = -1.0*y[415]
    jac_run[417,416] = 1.0*y[135] - 1.0*y[139]
    jac_run[417,417] = -1.0*y[134] + 1.0*y[138]
    jac_run[418,137] = y[417]
    jac_run[418,138] = 1.0*y[418]
    jac_run[418,139] = -y[417]
    jac_run[418,140] = -1.0*y[418]
    jac_run[418,418] = y[136] - y[138]
    jac_run[418,419] = 1.0*y[137] - 1.0*y[139]
    jac_run[419,137] = -1.0*y[418]
    jac_run[419,138] = 1.0*y[417]
    jac_run[419,139] = 1.0*y[418]
    jac_run[419,140] = -1.0*y[417]
    jac_run[419,418] = 1.0*y[137] - 1.0*y[139]
    jac_run[419,419] = -1.0*y[136] + 1.0*y[138]
    jac_run[420,199] = -y[421]/(y[198] - y[204] + 1.0e-8)**2
    jac_run[420,205] = y[421]/(y[198] - y[204] + 1.0e-8)**2
    jac_run[420,422] = 1/(y[198] - y[204] + 1.0e-8)
    jac_run[421,199] = y[421]/(-y[198] + y[204] + 1.0e-8)**2
    jac_run[421,205] = -y[421]/(-y[198] + y[204] + 1.0e-8)**2
    jac_run[421,422] = 1/(-y[198] + y[204] + 1.0e-8)
    jac_run[422,423] = -Piecewise(np.array([(-1, y[421] < 0), (1, True)]))
    jac_run[423,414] = -p[4]*y[413]/sqrt(y[414]**2 + y[413]**2 + 0.1) - 2*p[5]*y[413]
    jac_run[423,415] = -p[4]*y[414]/sqrt(y[414]**2 + y[413]**2 + 0.1) - 2*p[5]*y[414]
    jac_run[424,157] = y[423]
    jac_run[424,158] = 1.0*y[424]
    jac_run[424,163] = -y[423]
    jac_run[424,164] = -1.0*y[424]
    jac_run[424,424] = y[156] - y[162]
    jac_run[424,425] = 1.0*y[157] - 1.0*y[163]
    jac_run[425,157] = -1.0*y[424]
    jac_run[425,158] = 1.0*y[423]
    jac_run[425,163] = 1.0*y[424]
    jac_run[425,164] = -1.0*y[423]
    jac_run[425,424] = 1.0*y[157] - 1.0*y[163]
    jac_run[425,425] = -1.0*y[156] + 1.0*y[162]
    jac_run[426,159] = y[425]
    jac_run[426,160] = 1.0*y[426]
    jac_run[426,163] = -y[425]
    jac_run[426,164] = -1.0*y[426]
    jac_run[426,426] = y[158] - y[162]
    jac_run[426,427] = 1.0*y[159] - 1.0*y[163]
    jac_run[427,159] = -1.0*y[426]
    jac_run[427,160] = 1.0*y[425]
    jac_run[427,163] = 1.0*y[426]
    jac_run[427,164] = -1.0*y[425]
    jac_run[427,426] = 1.0*y[159] - 1.0*y[163]
    jac_run[427,427] = -1.0*y[158] + 1.0*y[162]
    jac_run[428,161] = y[427]
    jac_run[428,162] = 1.0*y[428]
    jac_run[428,163] = -y[427]
    jac_run[428,164] = -1.0*y[428]
    jac_run[428,428] = y[160] - y[162]
    jac_run[428,429] = 1.0*y[161] - 1.0*y[163]
    jac_run[429,161] = -1.0*y[428]
    jac_run[429,162] = 1.0*y[427]
    jac_run[429,163] = 1.0*y[428]
    jac_run[429,164] = -1.0*y[427]
    jac_run[429,428] = 1.0*y[161] - 1.0*y[163]
    jac_run[429,429] = -1.0*y[160] + 1.0*y[162]
    jac_run[430,223] = -y[431]/(y[222] - y[228] + 1.0e-8)**2
    jac_run[430,229] = y[431]/(y[222] - y[228] + 1.0e-8)**2
    jac_run[430,432] = 1/(y[222] - y[228] + 1.0e-8)
    jac_run[431,223] = y[431]/(-y[222] + y[228] + 1.0e-8)**2
    jac_run[431,229] = -y[431]/(-y[222] + y[228] + 1.0e-8)**2
    jac_run[431,432] = 1/(-y[222] + y[228] + 1.0e-8)
    jac_run[432,433] = -Piecewise(np.array([(-1, y[431] < 0), (1, True)]))
    jac_run[433,424] = -p[10]*y[423]/sqrt(y[424]**2 + y[423]**2 + 0.1) - 2*p[11]*y[423]
    jac_run[433,425] = -p[10]*y[424]/sqrt(y[424]**2 + y[423]**2 + 0.1) - 2*p[11]*y[424]

@numba.njit(cache=True)
def jac_run_ss_eval_up(jac_run,x,y,u,p,xyup = 1):

    jac_run[412,249] = u[6]

def jac_run_ss_eval_num(jac_run,x,y,u,p,xyup = 1):

    jac_run[0,0] = -1
    jac_run[1,1] = -123.954122254357
    jac_run[1,2] = -127.595184532966
    jac_run[1,3] = 39.6392229058202
    jac_run[1,4] = 10.2713736253513
    jac_run[1,5] = 24.9575997948692
    jac_run[1,6] = 23.2849644809540
    jac_run[1,7] = 58.0215758469966
    jac_run[1,8] = 83.8007853900572
    jac_run[1,69] = 105.571769313180
    jac_run[1,70] = 54.0657727682604
    jac_run[1,71] = -39.6392229058202
    jac_run[1,72] = -10.2713736253513
    jac_run[1,73] = -24.9575997948692
    jac_run[1,74] = -23.2849644809540
    jac_run[1,75] = -39.6392229058202
    jac_run[1,76] = -10.2713736253513
    jac_run[1,337] = 1
    jac_run[1,405] = 1
    jac_run[2,1] = 127.595184532966
    jac_run[2,2] = -123.954122254357
    jac_run[2,3] = -10.2713736253513
    jac_run[2,4] = 39.6392229058202
    jac_run[2,5] = -23.2849644809540
    jac_run[2,6] = 24.9575997948692
    jac_run[2,7] = -83.8007853900572
    jac_run[2,8] = 58.0215758469966
    jac_run[2,69] = -54.0657727682604
    jac_run[2,70] = 105.571769313180
    jac_run[2,71] = 10.2713736253513
    jac_run[2,72] = -39.6392229058202
    jac_run[2,73] = 23.2849644809540
    jac_run[2,74] = -24.9575997948692
    jac_run[2,75] = 10.2713736253513
    jac_run[2,76] = -39.6392229058202
    jac_run[2,338] = 1
    jac_run[2,406] = 1
    jac_run[3,1] = 39.6392229058202
    jac_run[3,2] = 10.2713736253513
    jac_run[3,3] = -123.954122254357
    jac_run[3,4] = -127.595184532966
    jac_run[3,5] = 39.6392229058201
    jac_run[3,6] = 10.2713736253513
    jac_run[3,7] = 43.3399527360457
    jac_run[3,8] = 96.8143762456598
    jac_run[3,69] = -39.6392229058202
    jac_run[3,70] = -10.2713736253513
    jac_run[3,71] = 105.571769313180
    jac_run[3,72] = 54.0657727682604
    jac_run[3,73] = -39.6392229058201
    jac_run[3,74] = -10.2713736253513
    jac_run[3,75] = -24.9575997948692
    jac_run[3,76] = -23.2849644809540
    jac_run[3,339] = 1
    jac_run[3,407] = 1
    jac_run[4,1] = -10.2713736253513
    jac_run[4,2] = 39.6392229058202
    jac_run[4,3] = 127.595184532966
    jac_run[4,4] = -123.954122254357
    jac_run[4,5] = -10.2713736253513
    jac_run[4,6] = 39.6392229058201
    jac_run[4,7] = -96.8143762456598
    jac_run[4,8] = 43.3399527360457
    jac_run[4,69] = 10.2713736253513
    jac_run[4,70] = -39.6392229058202
    jac_run[4,71] = -54.0657727682604
    jac_run[4,72] = 105.571769313180
    jac_run[4,73] = 10.2713736253513
    jac_run[4,74] = -39.6392229058201
    jac_run[4,75] = 23.2849644809540
    jac_run[4,76] = -24.9575997948692
    jac_run[4,340] = 1
    jac_run[4,408] = 1
    jac_run[5,1] = 24.9575997948692
    jac_run[5,2] = 23.2849644809540
    jac_run[5,3] = 39.6392229058202
    jac_run[5,4] = 10.2713736253513
    jac_run[5,5] = -123.954122254357
    jac_run[5,6] = -127.595184532966
    jac_run[5,7] = 58.0215758469966
    jac_run[5,8] = 83.8007853900572
    jac_run[5,69] = -24.9575997948692
    jac_run[5,70] = -23.2849644809540
    jac_run[5,71] = -39.6392229058202
    jac_run[5,72] = -10.2713736253513
    jac_run[5,73] = 105.571769313180
    jac_run[5,74] = 54.0657727682604
    jac_run[5,75] = -39.6392229058201
    jac_run[5,76] = -10.2713736253514
    jac_run[5,341] = 1
    jac_run[5,409] = 1
    jac_run[6,1] = -23.2849644809540
    jac_run[6,2] = 24.9575997948692
    jac_run[6,3] = -10.2713736253513
    jac_run[6,4] = 39.6392229058202
    jac_run[6,5] = 127.595184532966
    jac_run[6,6] = -123.954122254357
    jac_run[6,7] = -83.8007853900572
    jac_run[6,8] = 58.0215758469966
    jac_run[6,69] = 23.2849644809540
    jac_run[6,70] = -24.9575997948692
    jac_run[6,71] = 10.2713736253513
    jac_run[6,72] = -39.6392229058202
    jac_run[6,73] = -54.0657727682604
    jac_run[6,74] = 105.571769313180
    jac_run[6,75] = 10.2713736253514
    jac_run[6,76] = -39.6392229058201
    jac_run[6,342] = 1
    jac_run[6,410] = 1
    jac_run[7,1] = 58.0215758469966
    jac_run[7,2] = 83.8007853900572
    jac_run[7,3] = 43.3399527360457
    jac_run[7,4] = 96.8143762456598
    jac_run[7,5] = 58.0215758469966
    jac_run[7,6] = 83.8007853900572
    jac_run[7,7] = -161.052161470043
    jac_run[7,8] = -274.654008062378
    jac_run[7,69] = -39.6392229058202
    jac_run[7,70] = -10.2713736253513
    jac_run[7,71] = -24.9575997948692
    jac_run[7,72] = -23.2849644809540
    jac_run[7,73] = -39.6392229058202
    jac_run[7,74] = -10.2713736253513
    jac_run[7,75] = 105.571769313180
    jac_run[7,76] = 54.0657727682604
    jac_run[8,1] = -83.8007853900572
    jac_run[8,2] = 58.0215758469966
    jac_run[8,3] = -96.8143762456598
    jac_run[8,4] = 43.3399527360457
    jac_run[8,5] = -83.8007853900572
    jac_run[8,6] = 58.0215758469966
    jac_run[8,7] = 274.654008062378
    jac_run[8,8] = -161.052161470043
    jac_run[8,69] = 10.2713736253513
    jac_run[8,70] = -39.6392229058202
    jac_run[8,71] = 23.2849644809540
    jac_run[8,72] = -24.9575997948692
    jac_run[8,73] = 10.2713736253513
    jac_run[8,74] = -39.6392229058202
    jac_run[8,75] = -54.0657727682604
    jac_run[8,76] = 105.571769313180
    jac_run[9,9] = -26.5300693004806
    jac_run[9,10] = -4.84676915585801
    jac_run[9,11] = 7.89461337514770
    jac_run[9,12] = -1.58482814504483
    jac_run[9,13] = 7.72144347466701
    jac_run[9,14] = -0.679918453285310
    jac_run[9,15] = 7.89461337514771
    jac_run[9,16] = -1.58482814504483
    jac_run[9,77] = 26.5300693004806
    jac_run[9,78] = 4.84676915585801
    jac_run[9,79] = -7.89461337514770
    jac_run[9,80] = 1.58482814504483
    jac_run[9,81] = -7.72144347466701
    jac_run[9,82] = 0.679918453285310
    jac_run[9,83] = -7.89461337514771
    jac_run[9,84] = 1.58482814504483
    jac_run[9,345] = 1
    jac_run[10,9] = 4.84676915585801
    jac_run[10,10] = -26.5300693004806
    jac_run[10,11] = 1.58482814504483
    jac_run[10,12] = 7.89461337514770
    jac_run[10,13] = 0.679918453285310
    jac_run[10,14] = 7.72144347466701
    jac_run[10,15] = 1.58482814504483
    jac_run[10,16] = 7.89461337514771
    jac_run[10,77] = -4.84676915585801
    jac_run[10,78] = 26.5300693004806
    jac_run[10,79] = -1.58482814504483
    jac_run[10,80] = -7.89461337514770
    jac_run[10,81] = -0.679918453285310
    jac_run[10,82] = -7.72144347466701
    jac_run[10,83] = -1.58482814504483
    jac_run[10,84] = -7.89461337514771
    jac_run[10,346] = 1
    jac_run[11,9] = 7.89461337514771
    jac_run[11,10] = -1.58482814504483
    jac_run[11,11] = -26.5300693004806
    jac_run[11,12] = -4.84676915585801
    jac_run[11,13] = 7.89461337514771
    jac_run[11,14] = -1.58482814504483
    jac_run[11,15] = 7.72144347466701
    jac_run[11,16] = -0.679918453285308
    jac_run[11,77] = -7.89461337514771
    jac_run[11,78] = 1.58482814504483
    jac_run[11,79] = 26.5300693004806
    jac_run[11,80] = 4.84676915585801
    jac_run[11,81] = -7.89461337514771
    jac_run[11,82] = 1.58482814504483
    jac_run[11,83] = -7.72144347466701
    jac_run[11,84] = 0.679918453285308
    jac_run[11,347] = 1
    jac_run[12,9] = 1.58482814504483
    jac_run[12,10] = 7.89461337514771
    jac_run[12,11] = 4.84676915585801
    jac_run[12,12] = -26.5300693004806
    jac_run[12,13] = 1.58482814504483
    jac_run[12,14] = 7.89461337514771
    jac_run[12,15] = 0.679918453285308
    jac_run[12,16] = 7.72144347466701
    jac_run[12,77] = -1.58482814504483
    jac_run[12,78] = -7.89461337514771
    jac_run[12,79] = -4.84676915585801
    jac_run[12,80] = 26.5300693004806
    jac_run[12,81] = -1.58482814504483
    jac_run[12,82] = -7.89461337514771
    jac_run[12,83] = -0.679918453285308
    jac_run[12,84] = -7.72144347466701
    jac_run[12,348] = 1
    jac_run[13,9] = 7.72144347466701
    jac_run[13,10] = -0.679918453285310
    jac_run[13,11] = 7.89461337514770
    jac_run[13,12] = -1.58482814504483
    jac_run[13,13] = -26.5300693004806
    jac_run[13,14] = -4.84676915585801
    jac_run[13,15] = 7.89461337514771
    jac_run[13,16] = -1.58482814504483
    jac_run[13,77] = -7.72144347466701
    jac_run[13,78] = 0.679918453285310
    jac_run[13,79] = -7.89461337514770
    jac_run[13,80] = 1.58482814504483
    jac_run[13,81] = 26.5300693004806
    jac_run[13,82] = 4.84676915585801
    jac_run[13,83] = -7.89461337514771
    jac_run[13,84] = 1.58482814504483
    jac_run[13,349] = 1
    jac_run[14,9] = 0.679918453285310
    jac_run[14,10] = 7.72144347466701
    jac_run[14,11] = 1.58482814504483
    jac_run[14,12] = 7.89461337514770
    jac_run[14,13] = 4.84676915585801
    jac_run[14,14] = -26.5300693004806
    jac_run[14,15] = 1.58482814504483
    jac_run[14,16] = 7.89461337514771
    jac_run[14,77] = -0.679918453285310
    jac_run[14,78] = -7.72144347466701
    jac_run[14,79] = -1.58482814504483
    jac_run[14,80] = -7.89461337514770
    jac_run[14,81] = -4.84676915585801
    jac_run[14,82] = 26.5300693004806
    jac_run[14,83] = -1.58482814504483
    jac_run[14,84] = -7.89461337514771
    jac_run[14,350] = 1
    jac_run[15,9] = 7.89461337514771
    jac_run[15,10] = -1.58482814504483
    jac_run[15,11] = 7.72144347466701
    jac_run[15,12] = -0.679918453285308
    jac_run[15,13] = 7.89461337514771
    jac_run[15,14] = -1.58482814504483
    jac_run[15,15] = -26.5550693004806
    jac_run[15,16] = -4.84676915585801
    jac_run[15,77] = -7.89461337514771
    jac_run[15,78] = 1.58482814504483
    jac_run[15,79] = -7.72144347466701
    jac_run[15,80] = 0.679918453285308
    jac_run[15,81] = -7.89461337514771
    jac_run[15,82] = 1.58482814504483
    jac_run[15,83] = 26.5300693004806
    jac_run[15,84] = 4.84676915585801
    jac_run[16,9] = 1.58482814504483
    jac_run[16,10] = 7.89461337514771
    jac_run[16,11] = 0.679918453285308
    jac_run[16,12] = 7.72144347466701
    jac_run[16,13] = 1.58482814504483
    jac_run[16,14] = 7.89461337514771
    jac_run[16,15] = 4.84676915585801
    jac_run[16,16] = -26.5550693004806
    jac_run[16,77] = -1.58482814504483
    jac_run[16,78] = -7.89461337514771
    jac_run[16,79] = -0.679918453285308
    jac_run[16,80] = -7.72144347466701
    jac_run[16,81] = -1.58482814504483
    jac_run[16,82] = -7.89461337514771
    jac_run[16,83] = -4.84676915585801
    jac_run[16,84] = 26.5300693004806
    jac_run[17,17] = -26.5300693004806
    jac_run[17,18] = -4.84676915585801
    jac_run[17,19] = 7.89461337514770
    jac_run[17,20] = -1.58482814504483
    jac_run[17,21] = 7.72144347466701
    jac_run[17,22] = -0.679918453285310
    jac_run[17,23] = 7.89461337514771
    jac_run[17,24] = -1.58482814504483
    jac_run[17,157] = 26.5300693004806
    jac_run[17,158] = 4.84676915585801
    jac_run[17,159] = -7.89461337514770
    jac_run[17,160] = 1.58482814504483
    jac_run[17,161] = -7.72144347466701
    jac_run[17,162] = 0.679918453285310
    jac_run[17,163] = -7.89461337514771
    jac_run[17,164] = 1.58482814504483
    jac_run[17,353] = 1
    jac_run[18,17] = 4.84676915585801
    jac_run[18,18] = -26.5300693004806
    jac_run[18,19] = 1.58482814504483
    jac_run[18,20] = 7.89461337514770
    jac_run[18,21] = 0.679918453285310
    jac_run[18,22] = 7.72144347466701
    jac_run[18,23] = 1.58482814504483
    jac_run[18,24] = 7.89461337514771
    jac_run[18,157] = -4.84676915585801
    jac_run[18,158] = 26.5300693004806
    jac_run[18,159] = -1.58482814504483
    jac_run[18,160] = -7.89461337514770
    jac_run[18,161] = -0.679918453285310
    jac_run[18,162] = -7.72144347466701
    jac_run[18,163] = -1.58482814504483
    jac_run[18,164] = -7.89461337514771
    jac_run[18,354] = 1
    jac_run[19,17] = 7.89461337514771
    jac_run[19,18] = -1.58482814504483
    jac_run[19,19] = -26.5300693004806
    jac_run[19,20] = -4.84676915585801
    jac_run[19,21] = 7.89461337514771
    jac_run[19,22] = -1.58482814504483
    jac_run[19,23] = 7.72144347466701
    jac_run[19,24] = -0.679918453285308
    jac_run[19,157] = -7.89461337514771
    jac_run[19,158] = 1.58482814504483
    jac_run[19,159] = 26.5300693004806
    jac_run[19,160] = 4.84676915585801
    jac_run[19,161] = -7.89461337514771
    jac_run[19,162] = 1.58482814504483
    jac_run[19,163] = -7.72144347466701
    jac_run[19,164] = 0.679918453285308
    jac_run[19,355] = 1
    jac_run[20,17] = 1.58482814504483
    jac_run[20,18] = 7.89461337514771
    jac_run[20,19] = 4.84676915585801
    jac_run[20,20] = -26.5300693004806
    jac_run[20,21] = 1.58482814504483
    jac_run[20,22] = 7.89461337514771
    jac_run[20,23] = 0.679918453285308
    jac_run[20,24] = 7.72144347466701
    jac_run[20,157] = -1.58482814504483
    jac_run[20,158] = -7.89461337514771
    jac_run[20,159] = -4.84676915585801
    jac_run[20,160] = 26.5300693004806
    jac_run[20,161] = -1.58482814504483
    jac_run[20,162] = -7.89461337514771
    jac_run[20,163] = -0.679918453285308
    jac_run[20,164] = -7.72144347466701
    jac_run[20,356] = 1
    jac_run[21,17] = 7.72144347466701
    jac_run[21,18] = -0.679918453285310
    jac_run[21,19] = 7.89461337514770
    jac_run[21,20] = -1.58482814504483
    jac_run[21,21] = -26.5300693004806
    jac_run[21,22] = -4.84676915585801
    jac_run[21,23] = 7.89461337514771
    jac_run[21,24] = -1.58482814504483
    jac_run[21,157] = -7.72144347466701
    jac_run[21,158] = 0.679918453285310
    jac_run[21,159] = -7.89461337514770
    jac_run[21,160] = 1.58482814504483
    jac_run[21,161] = 26.5300693004806
    jac_run[21,162] = 4.84676915585801
    jac_run[21,163] = -7.89461337514771
    jac_run[21,164] = 1.58482814504483
    jac_run[21,357] = 1
    jac_run[22,17] = 0.679918453285310
    jac_run[22,18] = 7.72144347466701
    jac_run[22,19] = 1.58482814504483
    jac_run[22,20] = 7.89461337514770
    jac_run[22,21] = 4.84676915585801
    jac_run[22,22] = -26.5300693004806
    jac_run[22,23] = 1.58482814504483
    jac_run[22,24] = 7.89461337514771
    jac_run[22,157] = -0.679918453285310
    jac_run[22,158] = -7.72144347466701
    jac_run[22,159] = -1.58482814504483
    jac_run[22,160] = -7.89461337514770
    jac_run[22,161] = -4.84676915585801
    jac_run[22,162] = 26.5300693004806
    jac_run[22,163] = -1.58482814504483
    jac_run[22,164] = -7.89461337514771
    jac_run[22,358] = 1
    jac_run[23,17] = 7.89461337514771
    jac_run[23,18] = -1.58482814504483
    jac_run[23,19] = 7.72144347466701
    jac_run[23,20] = -0.679918453285308
    jac_run[23,21] = 7.89461337514771
    jac_run[23,22] = -1.58482814504483
    jac_run[23,23] = -26.5550693004806
    jac_run[23,24] = -4.84676915585801
    jac_run[23,157] = -7.89461337514771
    jac_run[23,158] = 1.58482814504483
    jac_run[23,159] = -7.72144347466701
    jac_run[23,160] = 0.679918453285308
    jac_run[23,161] = -7.89461337514771
    jac_run[23,162] = 1.58482814504483
    jac_run[23,163] = 26.5300693004806
    jac_run[23,164] = 4.84676915585801
    jac_run[24,17] = 1.58482814504483
    jac_run[24,18] = 7.89461337514771
    jac_run[24,19] = 0.679918453285308
    jac_run[24,20] = 7.72144347466701
    jac_run[24,21] = 1.58482814504483
    jac_run[24,22] = 7.89461337514771
    jac_run[24,23] = 4.84676915585801
    jac_run[24,24] = -26.5550693004806
    jac_run[24,157] = -1.58482814504483
    jac_run[24,158] = -7.89461337514771
    jac_run[24,159] = -0.679918453285308
    jac_run[24,160] = -7.72144347466701
    jac_run[24,161] = -1.58482814504483
    jac_run[24,162] = -7.89461337514771
    jac_run[24,163] = -4.84676915585801
    jac_run[24,164] = 26.5300693004806
    jac_run[25,25] = -30.9517475172273
    jac_run[25,26] = -5.65456401516768
    jac_run[25,27] = 9.21038227100566
    jac_run[25,28] = -1.84896616921897
    jac_run[25,29] = 9.00835072044485
    jac_run[25,30] = -0.793238195499529
    jac_run[25,31] = 9.21038227100566
    jac_run[25,32] = -1.84896616921897
    jac_run[25,101] = 30.9517475172273
    jac_run[25,102] = 5.65456401516768
    jac_run[25,103] = -9.21038227100566
    jac_run[25,104] = 1.84896616921897
    jac_run[25,105] = -9.00835072044485
    jac_run[25,106] = 0.793238195499529
    jac_run[25,107] = -9.21038227100566
    jac_run[25,108] = 1.84896616921897
    jac_run[25,361] = 1
    jac_run[26,25] = 5.65456401516768
    jac_run[26,26] = -30.9517475172273
    jac_run[26,27] = 1.84896616921897
    jac_run[26,28] = 9.21038227100566
    jac_run[26,29] = 0.793238195499529
    jac_run[26,30] = 9.00835072044485
    jac_run[26,31] = 1.84896616921897
    jac_run[26,32] = 9.21038227100566
    jac_run[26,101] = -5.65456401516768
    jac_run[26,102] = 30.9517475172273
    jac_run[26,103] = -1.84896616921897
    jac_run[26,104] = -9.21038227100566
    jac_run[26,105] = -0.793238195499529
    jac_run[26,106] = -9.00835072044485
    jac_run[26,107] = -1.84896616921897
    jac_run[26,108] = -9.21038227100566
    jac_run[26,362] = 1
    jac_run[27,25] = 9.21038227100566
    jac_run[27,26] = -1.84896616921897
    jac_run[27,27] = -30.9517475172273
    jac_run[27,28] = -5.65456401516768
    jac_run[27,29] = 9.21038227100566
    jac_run[27,30] = -1.84896616921897
    jac_run[27,31] = 9.00835072044485
    jac_run[27,32] = -0.793238195499528
    jac_run[27,101] = -9.21038227100566
    jac_run[27,102] = 1.84896616921897
    jac_run[27,103] = 30.9517475172273
    jac_run[27,104] = 5.65456401516768
    jac_run[27,105] = -9.21038227100566
    jac_run[27,106] = 1.84896616921897
    jac_run[27,107] = -9.00835072044485
    jac_run[27,108] = 0.793238195499528
    jac_run[27,363] = 1
    jac_run[28,25] = 1.84896616921897
    jac_run[28,26] = 9.21038227100566
    jac_run[28,27] = 5.65456401516768
    jac_run[28,28] = -30.9517475172273
    jac_run[28,29] = 1.84896616921897
    jac_run[28,30] = 9.21038227100566
    jac_run[28,31] = 0.793238195499528
    jac_run[28,32] = 9.00835072044485
    jac_run[28,101] = -1.84896616921897
    jac_run[28,102] = -9.21038227100566
    jac_run[28,103] = -5.65456401516768
    jac_run[28,104] = 30.9517475172273
    jac_run[28,105] = -1.84896616921897
    jac_run[28,106] = -9.21038227100566
    jac_run[28,107] = -0.793238195499528
    jac_run[28,108] = -9.00835072044485
    jac_run[28,364] = 1
    jac_run[29,25] = 9.00835072044484
    jac_run[29,26] = -0.793238195499527
    jac_run[29,27] = 9.21038227100566
    jac_run[29,28] = -1.84896616921897
    jac_run[29,29] = -30.9517475172273
    jac_run[29,30] = -5.65456401516768
    jac_run[29,31] = 9.21038227100566
    jac_run[29,32] = -1.84896616921897
    jac_run[29,101] = -9.00835072044484
    jac_run[29,102] = 0.793238195499527
    jac_run[29,103] = -9.21038227100566
    jac_run[29,104] = 1.84896616921897
    jac_run[29,105] = 30.9517475172273
    jac_run[29,106] = 5.65456401516768
    jac_run[29,107] = -9.21038227100566
    jac_run[29,108] = 1.84896616921897
    jac_run[29,365] = 1
    jac_run[30,25] = 0.793238195499527
    jac_run[30,26] = 9.00835072044484
    jac_run[30,27] = 1.84896616921897
    jac_run[30,28] = 9.21038227100566
    jac_run[30,29] = 5.65456401516768
    jac_run[30,30] = -30.9517475172273
    jac_run[30,31] = 1.84896616921897
    jac_run[30,32] = 9.21038227100566
    jac_run[30,101] = -0.793238195499527
    jac_run[30,102] = -9.00835072044484
    jac_run[30,103] = -1.84896616921897
    jac_run[30,104] = -9.21038227100566
    jac_run[30,105] = -5.65456401516768
    jac_run[30,106] = 30.9517475172273
    jac_run[30,107] = -1.84896616921897
    jac_run[30,108] = -9.21038227100566
    jac_run[30,366] = 1
    jac_run[31,25] = 9.21038227100566
    jac_run[31,26] = -1.84896616921897
    jac_run[31,27] = 9.00835072044485
    jac_run[31,28] = -0.793238195499527
    jac_run[31,29] = 9.21038227100566
    jac_run[31,30] = -1.84896616921897
    jac_run[31,31] = -30.9767475172273
    jac_run[31,32] = -5.65456401516768
    jac_run[31,101] = -9.21038227100566
    jac_run[31,102] = 1.84896616921897
    jac_run[31,103] = -9.00835072044485
    jac_run[31,104] = 0.793238195499527
    jac_run[31,105] = -9.21038227100566
    jac_run[31,106] = 1.84896616921897
    jac_run[31,107] = 30.9517475172273
    jac_run[31,108] = 5.65456401516768
    jac_run[32,25] = 1.84896616921897
    jac_run[32,26] = 9.21038227100566
    jac_run[32,27] = 0.793238195499527
    jac_run[32,28] = 9.00835072044485
    jac_run[32,29] = 1.84896616921897
    jac_run[32,30] = 9.21038227100566
    jac_run[32,31] = 5.65456401516768
    jac_run[32,32] = -30.9767475172273
    jac_run[32,101] = -1.84896616921897
    jac_run[32,102] = -9.21038227100566
    jac_run[32,103] = -0.793238195499527
    jac_run[32,104] = -9.00835072044485
    jac_run[32,105] = -1.84896616921897
    jac_run[32,106] = -9.21038227100566
    jac_run[32,107] = -5.65456401516768
    jac_run[32,108] = 30.9517475172273
    jac_run[33,33] = -30.9517475172273
    jac_run[33,34] = -5.65456401516768
    jac_run[33,35] = 9.21038227100566
    jac_run[33,36] = -1.84896616921897
    jac_run[33,37] = 9.00835072044485
    jac_run[33,38] = -0.793238195499529
    jac_run[33,39] = 9.21038227100566
    jac_run[33,40] = -1.84896616921897
    jac_run[33,125] = 30.9517475172273
    jac_run[33,126] = 5.65456401516768
    jac_run[33,127] = -9.21038227100566
    jac_run[33,128] = 1.84896616921897
    jac_run[33,129] = -9.00835072044485
    jac_run[33,130] = 0.793238195499529
    jac_run[33,131] = -9.21038227100566
    jac_run[33,132] = 1.84896616921897
    jac_run[33,369] = 1
    jac_run[34,33] = 5.65456401516768
    jac_run[34,34] = -30.9517475172273
    jac_run[34,35] = 1.84896616921897
    jac_run[34,36] = 9.21038227100566
    jac_run[34,37] = 0.793238195499529
    jac_run[34,38] = 9.00835072044485
    jac_run[34,39] = 1.84896616921897
    jac_run[34,40] = 9.21038227100566
    jac_run[34,125] = -5.65456401516768
    jac_run[34,126] = 30.9517475172273
    jac_run[34,127] = -1.84896616921897
    jac_run[34,128] = -9.21038227100566
    jac_run[34,129] = -0.793238195499529
    jac_run[34,130] = -9.00835072044485
    jac_run[34,131] = -1.84896616921897
    jac_run[34,132] = -9.21038227100566
    jac_run[34,370] = 1
    jac_run[35,33] = 9.21038227100566
    jac_run[35,34] = -1.84896616921897
    jac_run[35,35] = -30.9517475172273
    jac_run[35,36] = -5.65456401516768
    jac_run[35,37] = 9.21038227100566
    jac_run[35,38] = -1.84896616921897
    jac_run[35,39] = 9.00835072044485
    jac_run[35,40] = -0.793238195499528
    jac_run[35,125] = -9.21038227100566
    jac_run[35,126] = 1.84896616921897
    jac_run[35,127] = 30.9517475172273
    jac_run[35,128] = 5.65456401516768
    jac_run[35,129] = -9.21038227100566
    jac_run[35,130] = 1.84896616921897
    jac_run[35,131] = -9.00835072044485
    jac_run[35,132] = 0.793238195499528
    jac_run[35,371] = 1
    jac_run[36,33] = 1.84896616921897
    jac_run[36,34] = 9.21038227100566
    jac_run[36,35] = 5.65456401516768
    jac_run[36,36] = -30.9517475172273
    jac_run[36,37] = 1.84896616921897
    jac_run[36,38] = 9.21038227100566
    jac_run[36,39] = 0.793238195499528
    jac_run[36,40] = 9.00835072044485
    jac_run[36,125] = -1.84896616921897
    jac_run[36,126] = -9.21038227100566
    jac_run[36,127] = -5.65456401516768
    jac_run[36,128] = 30.9517475172273
    jac_run[36,129] = -1.84896616921897
    jac_run[36,130] = -9.21038227100566
    jac_run[36,131] = -0.793238195499528
    jac_run[36,132] = -9.00835072044485
    jac_run[36,372] = 1
    jac_run[37,33] = 9.00835072044484
    jac_run[37,34] = -0.793238195499527
    jac_run[37,35] = 9.21038227100566
    jac_run[37,36] = -1.84896616921897
    jac_run[37,37] = -30.9517475172273
    jac_run[37,38] = -5.65456401516768
    jac_run[37,39] = 9.21038227100566
    jac_run[37,40] = -1.84896616921897
    jac_run[37,125] = -9.00835072044484
    jac_run[37,126] = 0.793238195499527
    jac_run[37,127] = -9.21038227100566
    jac_run[37,128] = 1.84896616921897
    jac_run[37,129] = 30.9517475172273
    jac_run[37,130] = 5.65456401516768
    jac_run[37,131] = -9.21038227100566
    jac_run[37,132] = 1.84896616921897
    jac_run[37,373] = 1
    jac_run[38,33] = 0.793238195499527
    jac_run[38,34] = 9.00835072044484
    jac_run[38,35] = 1.84896616921897
    jac_run[38,36] = 9.21038227100566
    jac_run[38,37] = 5.65456401516768
    jac_run[38,38] = -30.9517475172273
    jac_run[38,39] = 1.84896616921897
    jac_run[38,40] = 9.21038227100566
    jac_run[38,125] = -0.793238195499527
    jac_run[38,126] = -9.00835072044484
    jac_run[38,127] = -1.84896616921897
    jac_run[38,128] = -9.21038227100566
    jac_run[38,129] = -5.65456401516768
    jac_run[38,130] = 30.9517475172273
    jac_run[38,131] = -1.84896616921897
    jac_run[38,132] = -9.21038227100566
    jac_run[38,374] = 1
    jac_run[39,33] = 9.21038227100566
    jac_run[39,34] = -1.84896616921897
    jac_run[39,35] = 9.00835072044485
    jac_run[39,36] = -0.793238195499527
    jac_run[39,37] = 9.21038227100566
    jac_run[39,38] = -1.84896616921897
    jac_run[39,39] = -30.9767475172273
    jac_run[39,40] = -5.65456401516768
    jac_run[39,125] = -9.21038227100566
    jac_run[39,126] = 1.84896616921897
    jac_run[39,127] = -9.00835072044485
    jac_run[39,128] = 0.793238195499527
    jac_run[39,129] = -9.21038227100566
    jac_run[39,130] = 1.84896616921897
    jac_run[39,131] = 30.9517475172273
    jac_run[39,132] = 5.65456401516768
    jac_run[40,33] = 1.84896616921897
    jac_run[40,34] = 9.21038227100566
    jac_run[40,35] = 0.793238195499527
    jac_run[40,36] = 9.00835072044485
    jac_run[40,37] = 1.84896616921897
    jac_run[40,38] = 9.21038227100566
    jac_run[40,39] = 5.65456401516768
    jac_run[40,40] = -30.9767475172273
    jac_run[40,125] = -1.84896616921897
    jac_run[40,126] = -9.21038227100566
    jac_run[40,127] = -0.793238195499527
    jac_run[40,128] = -9.00835072044485
    jac_run[40,129] = -1.84896616921897
    jac_run[40,130] = -9.21038227100566
    jac_run[40,131] = -5.65456401516768
    jac_run[40,132] = 30.9517475172273
    jac_run[41,41] = -30.9517475172273
    jac_run[41,42] = -5.65456401516768
    jac_run[41,43] = 9.21038227100566
    jac_run[41,44] = -1.84896616921897
    jac_run[41,45] = 9.00835072044485
    jac_run[41,46] = -0.793238195499529
    jac_run[41,47] = 9.21038227100566
    jac_run[41,48] = -1.84896616921897
    jac_run[41,133] = 30.9517475172273
    jac_run[41,134] = 5.65456401516768
    jac_run[41,135] = -9.21038227100566
    jac_run[41,136] = 1.84896616921897
    jac_run[41,137] = -9.00835072044485
    jac_run[41,138] = 0.793238195499529
    jac_run[41,139] = -9.21038227100566
    jac_run[41,140] = 1.84896616921897
    jac_run[41,377] = 1
    jac_run[42,41] = 5.65456401516768
    jac_run[42,42] = -30.9517475172273
    jac_run[42,43] = 1.84896616921897
    jac_run[42,44] = 9.21038227100566
    jac_run[42,45] = 0.793238195499529
    jac_run[42,46] = 9.00835072044485
    jac_run[42,47] = 1.84896616921897
    jac_run[42,48] = 9.21038227100566
    jac_run[42,133] = -5.65456401516768
    jac_run[42,134] = 30.9517475172273
    jac_run[42,135] = -1.84896616921897
    jac_run[42,136] = -9.21038227100566
    jac_run[42,137] = -0.793238195499529
    jac_run[42,138] = -9.00835072044485
    jac_run[42,139] = -1.84896616921897
    jac_run[42,140] = -9.21038227100566
    jac_run[42,378] = 1
    jac_run[43,41] = 9.21038227100566
    jac_run[43,42] = -1.84896616921897
    jac_run[43,43] = -30.9517475172273
    jac_run[43,44] = -5.65456401516768
    jac_run[43,45] = 9.21038227100566
    jac_run[43,46] = -1.84896616921897
    jac_run[43,47] = 9.00835072044485
    jac_run[43,48] = -0.793238195499528
    jac_run[43,133] = -9.21038227100566
    jac_run[43,134] = 1.84896616921897
    jac_run[43,135] = 30.9517475172273
    jac_run[43,136] = 5.65456401516768
    jac_run[43,137] = -9.21038227100566
    jac_run[43,138] = 1.84896616921897
    jac_run[43,139] = -9.00835072044485
    jac_run[43,140] = 0.793238195499528
    jac_run[43,379] = 1
    jac_run[44,41] = 1.84896616921897
    jac_run[44,42] = 9.21038227100566
    jac_run[44,43] = 5.65456401516768
    jac_run[44,44] = -30.9517475172273
    jac_run[44,45] = 1.84896616921897
    jac_run[44,46] = 9.21038227100566
    jac_run[44,47] = 0.793238195499528
    jac_run[44,48] = 9.00835072044485
    jac_run[44,133] = -1.84896616921897
    jac_run[44,134] = -9.21038227100566
    jac_run[44,135] = -5.65456401516768
    jac_run[44,136] = 30.9517475172273
    jac_run[44,137] = -1.84896616921897
    jac_run[44,138] = -9.21038227100566
    jac_run[44,139] = -0.793238195499528
    jac_run[44,140] = -9.00835072044485
    jac_run[44,380] = 1
    jac_run[45,41] = 9.00835072044484
    jac_run[45,42] = -0.793238195499527
    jac_run[45,43] = 9.21038227100566
    jac_run[45,44] = -1.84896616921897
    jac_run[45,45] = -30.9517475172273
    jac_run[45,46] = -5.65456401516768
    jac_run[45,47] = 9.21038227100566
    jac_run[45,48] = -1.84896616921897
    jac_run[45,133] = -9.00835072044484
    jac_run[45,134] = 0.793238195499527
    jac_run[45,135] = -9.21038227100566
    jac_run[45,136] = 1.84896616921897
    jac_run[45,137] = 30.9517475172273
    jac_run[45,138] = 5.65456401516768
    jac_run[45,139] = -9.21038227100566
    jac_run[45,140] = 1.84896616921897
    jac_run[45,381] = 1
    jac_run[46,41] = 0.793238195499527
    jac_run[46,42] = 9.00835072044484
    jac_run[46,43] = 1.84896616921897
    jac_run[46,44] = 9.21038227100566
    jac_run[46,45] = 5.65456401516768
    jac_run[46,46] = -30.9517475172273
    jac_run[46,47] = 1.84896616921897
    jac_run[46,48] = 9.21038227100566
    jac_run[46,133] = -0.793238195499527
    jac_run[46,134] = -9.00835072044484
    jac_run[46,135] = -1.84896616921897
    jac_run[46,136] = -9.21038227100566
    jac_run[46,137] = -5.65456401516768
    jac_run[46,138] = 30.9517475172273
    jac_run[46,139] = -1.84896616921897
    jac_run[46,140] = -9.21038227100566
    jac_run[46,382] = 1
    jac_run[47,41] = 9.21038227100566
    jac_run[47,42] = -1.84896616921897
    jac_run[47,43] = 9.00835072044485
    jac_run[47,44] = -0.793238195499527
    jac_run[47,45] = 9.21038227100566
    jac_run[47,46] = -1.84896616921897
    jac_run[47,47] = -30.9767475172273
    jac_run[47,48] = -5.65456401516768
    jac_run[47,133] = -9.21038227100566
    jac_run[47,134] = 1.84896616921897
    jac_run[47,135] = -9.00835072044485
    jac_run[47,136] = 0.793238195499527
    jac_run[47,137] = -9.21038227100566
    jac_run[47,138] = 1.84896616921897
    jac_run[47,139] = 30.9517475172273
    jac_run[47,140] = 5.65456401516768
    jac_run[48,41] = 1.84896616921897
    jac_run[48,42] = 9.21038227100566
    jac_run[48,43] = 0.793238195499527
    jac_run[48,44] = 9.00835072044485
    jac_run[48,45] = 1.84896616921897
    jac_run[48,46] = 9.21038227100566
    jac_run[48,47] = 5.65456401516768
    jac_run[48,48] = -30.9767475172273
    jac_run[48,133] = -1.84896616921897
    jac_run[48,134] = -9.21038227100566
    jac_run[48,135] = -0.793238195499527
    jac_run[48,136] = -9.00835072044485
    jac_run[48,137] = -1.84896616921897
    jac_run[48,138] = -9.21038227100566
    jac_run[48,139] = -5.65456401516768
    jac_run[48,140] = 30.9517475172273
    jac_run[49,49] = -135.409614082600
    jac_run[49,223] = 135.409614082600
    jac_run[49,385] = 1
    jac_run[50,50] = -135.409614082600
    jac_run[50,224] = 135.409614082600
    jac_run[50,386] = 1
    jac_run[51,51] = -135.409614082600
    jac_run[51,229] = 135.409614082600
    jac_run[51,387] = 1
    jac_run[52,52] = -135.409614082600
    jac_run[52,230] = 135.409614082600
    jac_run[52,388] = 1
    jac_run[53,53] = -157.977883096366
    jac_run[53,167] = 157.977883096366
    jac_run[53,389] = 1
    jac_run[54,54] = -157.977883096366
    jac_run[54,168] = 157.977883096366
    jac_run[54,390] = 1
    jac_run[55,55] = -157.977883096366
    jac_run[55,173] = 157.977883096366
    jac_run[55,391] = 1
    jac_run[56,56] = -157.977883096366
    jac_run[56,174] = 157.977883096366
    jac_run[56,392] = 1
    jac_run[57,57] = -157.977883096366
    jac_run[57,183] = 157.977883096366
    jac_run[57,393] = 1
    jac_run[58,58] = -157.977883096366
    jac_run[58,184] = 157.977883096366
    jac_run[58,394] = 1
    jac_run[59,59] = -157.977883096366
    jac_run[59,189] = 157.977883096366
    jac_run[59,395] = 1
    jac_run[60,60] = -157.977883096366
    jac_run[60,190] = 157.977883096366
    jac_run[60,396] = 1
    jac_run[61,61] = -157.977883096366
    jac_run[61,191] = 157.977883096366
    jac_run[61,397] = 1
    jac_run[62,62] = -157.977883096366
    jac_run[62,192] = 157.977883096366
    jac_run[62,398] = 1
    jac_run[63,63] = -157.977883096366
    jac_run[63,197] = 157.977883096366
    jac_run[63,399] = 1
    jac_run[64,64] = -157.977883096366
    jac_run[64,198] = 157.977883096366
    jac_run[64,400] = 1
    jac_run[65,65] = -157.977883096366
    jac_run[65,199] = 157.977883096366
    jac_run[65,401] = 1
    jac_run[66,66] = -157.977883096366
    jac_run[66,200] = 157.977883096366
    jac_run[66,402] = 1
    jac_run[67,67] = -157.977883096366
    jac_run[67,205] = 157.977883096366
    jac_run[67,403] = 1
    jac_run[68,68] = -157.977883096366
    jac_run[68,206] = 157.977883096366
    jac_run[68,404] = 1
    jac_run[69,1] = 105.571769313180
    jac_run[69,2] = 54.0657727682604
    jac_run[69,3] = -39.6392229058202
    jac_run[69,4] = -10.2713736253513
    jac_run[69,5] = -24.9575997948692
    jac_run[69,6] = -23.2849644809540
    jac_run[69,7] = -39.6392229058202
    jac_run[69,8] = -10.2713736253513
    jac_run[69,69] = -211.143538626360
    jac_run[69,70] = -108.131545536521
    jac_run[69,71] = 79.2784458116403
    jac_run[69,72] = 20.5427472507027
    jac_run[69,73] = 49.9151995897384
    jac_run[69,74] = 46.5699289619080
    jac_run[69,75] = 79.2784458116403
    jac_run[69,76] = 20.5427472507027
    jac_run[69,77] = 105.571769313180
    jac_run[69,78] = 54.0657727682604
    jac_run[69,79] = -39.6392229058202
    jac_run[69,80] = -10.2713736253513
    jac_run[69,81] = -24.9575997948692
    jac_run[69,82] = -23.2849644809540
    jac_run[69,83] = -39.6392229058202
    jac_run[69,84] = -10.2713736253513
    jac_run[70,1] = -54.0657727682604
    jac_run[70,2] = 105.571769313180
    jac_run[70,3] = 10.2713736253513
    jac_run[70,4] = -39.6392229058202
    jac_run[70,5] = 23.2849644809540
    jac_run[70,6] = -24.9575997948692
    jac_run[70,7] = 10.2713736253513
    jac_run[70,8] = -39.6392229058202
    jac_run[70,69] = 108.131545536521
    jac_run[70,70] = -211.143538626360
    jac_run[70,71] = -20.5427472507027
    jac_run[70,72] = 79.2784458116403
    jac_run[70,73] = -46.5699289619080
    jac_run[70,74] = 49.9151995897384
    jac_run[70,75] = -20.5427472507027
    jac_run[70,76] = 79.2784458116403
    jac_run[70,77] = -54.0657727682604
    jac_run[70,78] = 105.571769313180
    jac_run[70,79] = 10.2713736253513
    jac_run[70,80] = -39.6392229058202
    jac_run[70,81] = 23.2849644809540
    jac_run[70,82] = -24.9575997948692
    jac_run[70,83] = 10.2713736253513
    jac_run[70,84] = -39.6392229058202
    jac_run[71,1] = -39.6392229058202
    jac_run[71,2] = -10.2713736253513
    jac_run[71,3] = 105.571769313180
    jac_run[71,4] = 54.0657727682604
    jac_run[71,5] = -39.6392229058201
    jac_run[71,6] = -10.2713736253513
    jac_run[71,7] = -24.9575997948692
    jac_run[71,8] = -23.2849644809540
    jac_run[71,69] = 79.2784458116403
    jac_run[71,70] = 20.5427472507027
    jac_run[71,71] = -211.143538626360
    jac_run[71,72] = -108.131545536521
    jac_run[71,73] = 79.2784458116403
    jac_run[71,74] = 20.5427472507027
    jac_run[71,75] = 49.9151995897384
    jac_run[71,76] = 46.5699289619080
    jac_run[71,77] = -39.6392229058202
    jac_run[71,78] = -10.2713736253513
    jac_run[71,79] = 105.571769313180
    jac_run[71,80] = 54.0657727682604
    jac_run[71,81] = -39.6392229058201
    jac_run[71,82] = -10.2713736253513
    jac_run[71,83] = -24.9575997948692
    jac_run[71,84] = -23.2849644809540
    jac_run[72,1] = 10.2713736253513
    jac_run[72,2] = -39.6392229058202
    jac_run[72,3] = -54.0657727682604
    jac_run[72,4] = 105.571769313180
    jac_run[72,5] = 10.2713736253513
    jac_run[72,6] = -39.6392229058201
    jac_run[72,7] = 23.2849644809540
    jac_run[72,8] = -24.9575997948692
    jac_run[72,69] = -20.5427472507027
    jac_run[72,70] = 79.2784458116403
    jac_run[72,71] = 108.131545536521
    jac_run[72,72] = -211.143538626360
    jac_run[72,73] = -20.5427472507027
    jac_run[72,74] = 79.2784458116403
    jac_run[72,75] = -46.5699289619080
    jac_run[72,76] = 49.9151995897384
    jac_run[72,77] = 10.2713736253513
    jac_run[72,78] = -39.6392229058202
    jac_run[72,79] = -54.0657727682604
    jac_run[72,80] = 105.571769313180
    jac_run[72,81] = 10.2713736253513
    jac_run[72,82] = -39.6392229058201
    jac_run[72,83] = 23.2849644809540
    jac_run[72,84] = -24.9575997948692
    jac_run[73,1] = -24.9575997948692
    jac_run[73,2] = -23.2849644809540
    jac_run[73,3] = -39.6392229058202
    jac_run[73,4] = -10.2713736253513
    jac_run[73,5] = 105.571769313180
    jac_run[73,6] = 54.0657727682604
    jac_run[73,7] = -39.6392229058201
    jac_run[73,8] = -10.2713736253514
    jac_run[73,69] = 49.9151995897384
    jac_run[73,70] = 46.5699289619080
    jac_run[73,71] = 79.2784458116404
    jac_run[73,72] = 20.5427472507027
    jac_run[73,73] = -211.143538626360
    jac_run[73,74] = -108.131545536521
    jac_run[73,75] = 79.2784458116403
    jac_run[73,76] = 20.5427472507027
    jac_run[73,77] = -24.9575997948692
    jac_run[73,78] = -23.2849644809540
    jac_run[73,79] = -39.6392229058202
    jac_run[73,80] = -10.2713736253513
    jac_run[73,81] = 105.571769313180
    jac_run[73,82] = 54.0657727682604
    jac_run[73,83] = -39.6392229058201
    jac_run[73,84] = -10.2713736253514
    jac_run[74,1] = 23.2849644809540
    jac_run[74,2] = -24.9575997948692
    jac_run[74,3] = 10.2713736253513
    jac_run[74,4] = -39.6392229058202
    jac_run[74,5] = -54.0657727682604
    jac_run[74,6] = 105.571769313180
    jac_run[74,7] = 10.2713736253514
    jac_run[74,8] = -39.6392229058201
    jac_run[74,69] = -46.5699289619080
    jac_run[74,70] = 49.9151995897384
    jac_run[74,71] = -20.5427472507027
    jac_run[74,72] = 79.2784458116404
    jac_run[74,73] = 108.131545536521
    jac_run[74,74] = -211.143538626360
    jac_run[74,75] = -20.5427472507027
    jac_run[74,76] = 79.2784458116403
    jac_run[74,77] = 23.2849644809540
    jac_run[74,78] = -24.9575997948692
    jac_run[74,79] = 10.2713736253513
    jac_run[74,80] = -39.6392229058202
    jac_run[74,81] = -54.0657727682604
    jac_run[74,82] = 105.571769313180
    jac_run[74,83] = 10.2713736253514
    jac_run[74,84] = -39.6392229058201
    jac_run[75,1] = -39.6392229058202
    jac_run[75,2] = -10.2713736253513
    jac_run[75,3] = -24.9575997948692
    jac_run[75,4] = -23.2849644809540
    jac_run[75,5] = -39.6392229058202
    jac_run[75,6] = -10.2713736253513
    jac_run[75,7] = 105.571769313180
    jac_run[75,8] = 54.0657727682604
    jac_run[75,69] = 79.2784458116403
    jac_run[75,70] = 20.5427472507027
    jac_run[75,71] = 49.9151995897384
    jac_run[75,72] = 46.5699289619080
    jac_run[75,73] = 79.2784458116403
    jac_run[75,74] = 20.5427472507027
    jac_run[75,75] = -211.168538626360
    jac_run[75,76] = -108.131545536521
    jac_run[75,77] = -39.6392229058202
    jac_run[75,78] = -10.2713736253513
    jac_run[75,79] = -24.9575997948692
    jac_run[75,80] = -23.2849644809540
    jac_run[75,81] = -39.6392229058202
    jac_run[75,82] = -10.2713736253513
    jac_run[75,83] = 105.571769313180
    jac_run[75,84] = 54.0657727682604
    jac_run[76,1] = 10.2713736253513
    jac_run[76,2] = -39.6392229058202
    jac_run[76,3] = 23.2849644809540
    jac_run[76,4] = -24.9575997948692
    jac_run[76,5] = 10.2713736253513
    jac_run[76,6] = -39.6392229058202
    jac_run[76,7] = -54.0657727682604
    jac_run[76,8] = 105.571769313180
    jac_run[76,69] = -20.5427472507027
    jac_run[76,70] = 79.2784458116403
    jac_run[76,71] = -46.5699289619080
    jac_run[76,72] = 49.9151995897384
    jac_run[76,73] = -20.5427472507027
    jac_run[76,74] = 79.2784458116403
    jac_run[76,75] = 108.131545536521
    jac_run[76,76] = -211.168538626360
    jac_run[76,77] = 10.2713736253513
    jac_run[76,78] = -39.6392229058202
    jac_run[76,79] = 23.2849644809540
    jac_run[76,80] = -24.9575997948692
    jac_run[76,81] = 10.2713736253513
    jac_run[76,82] = -39.6392229058202
    jac_run[76,83] = -54.0657727682604
    jac_run[76,84] = 105.571769313180
    jac_run[77,9] = 26.5300693004806
    jac_run[77,10] = 4.84676915585801
    jac_run[77,11] = -7.89461337514770
    jac_run[77,12] = 1.58482814504483
    jac_run[77,13] = -7.72144347466701
    jac_run[77,14] = 0.679918453285310
    jac_run[77,15] = -7.89461337514771
    jac_run[77,16] = 1.58482814504483
    jac_run[77,69] = 105.571769313180
    jac_run[77,70] = 54.0657727682604
    jac_run[77,71] = -39.6392229058202
    jac_run[77,72] = -10.2713736253513
    jac_run[77,73] = -24.9575997948692
    jac_run[77,74] = -23.2849644809540
    jac_run[77,75] = -39.6392229058202
    jac_run[77,76] = -10.2713736253513
    jac_run[77,77] = -237.673607926841
    jac_run[77,78] = -112.978314692379
    jac_run[77,79] = 87.1730591867880
    jac_run[77,80] = 18.9579191056578
    jac_run[77,81] = 57.6366430644055
    jac_run[77,82] = 45.8900105086227
    jac_run[77,83] = 87.1730591867880
    jac_run[77,84] = 18.9579191056579
    jac_run[77,85] = 105.571769313180
    jac_run[77,86] = 54.0657727682604
    jac_run[77,87] = -39.6392229058202
    jac_run[77,88] = -10.2713736253513
    jac_run[77,89] = -24.9575997948692
    jac_run[77,90] = -23.2849644809540
    jac_run[77,91] = -39.6392229058202
    jac_run[77,92] = -10.2713736253513
    jac_run[78,9] = -4.84676915585801
    jac_run[78,10] = 26.5300693004806
    jac_run[78,11] = -1.58482814504483
    jac_run[78,12] = -7.89461337514770
    jac_run[78,13] = -0.679918453285310
    jac_run[78,14] = -7.72144347466701
    jac_run[78,15] = -1.58482814504483
    jac_run[78,16] = -7.89461337514771
    jac_run[78,69] = -54.0657727682604
    jac_run[78,70] = 105.571769313180
    jac_run[78,71] = 10.2713736253513
    jac_run[78,72] = -39.6392229058202
    jac_run[78,73] = 23.2849644809540
    jac_run[78,74] = -24.9575997948692
    jac_run[78,75] = 10.2713736253513
    jac_run[78,76] = -39.6392229058202
    jac_run[78,77] = 112.978314692379
    jac_run[78,78] = -237.673607926841
    jac_run[78,79] = -18.9579191056578
    jac_run[78,80] = 87.1730591867880
    jac_run[78,81] = -45.8900105086227
    jac_run[78,82] = 57.6366430644055
    jac_run[78,83] = -18.9579191056579
    jac_run[78,84] = 87.1730591867880
    jac_run[78,85] = -54.0657727682604
    jac_run[78,86] = 105.571769313180
    jac_run[78,87] = 10.2713736253513
    jac_run[78,88] = -39.6392229058202
    jac_run[78,89] = 23.2849644809540
    jac_run[78,90] = -24.9575997948692
    jac_run[78,91] = 10.2713736253513
    jac_run[78,92] = -39.6392229058202
    jac_run[79,9] = -7.89461337514771
    jac_run[79,10] = 1.58482814504483
    jac_run[79,11] = 26.5300693004806
    jac_run[79,12] = 4.84676915585801
    jac_run[79,13] = -7.89461337514771
    jac_run[79,14] = 1.58482814504483
    jac_run[79,15] = -7.72144347466701
    jac_run[79,16] = 0.679918453285308
    jac_run[79,69] = -39.6392229058202
    jac_run[79,70] = -10.2713736253513
    jac_run[79,71] = 105.571769313180
    jac_run[79,72] = 54.0657727682604
    jac_run[79,73] = -39.6392229058201
    jac_run[79,74] = -10.2713736253513
    jac_run[79,75] = -24.9575997948692
    jac_run[79,76] = -23.2849644809540
    jac_run[79,77] = 87.1730591867880
    jac_run[79,78] = 18.9579191056579
    jac_run[79,79] = -237.673607926841
    jac_run[79,80] = -112.978314692379
    jac_run[79,81] = 87.1730591867880
    jac_run[79,82] = 18.9579191056579
    jac_run[79,83] = 57.6366430644054
    jac_run[79,84] = 45.8900105086227
    jac_run[79,85] = -39.6392229058202
    jac_run[79,86] = -10.2713736253513
    jac_run[79,87] = 105.571769313180
    jac_run[79,88] = 54.0657727682604
    jac_run[79,89] = -39.6392229058201
    jac_run[79,90] = -10.2713736253513
    jac_run[79,91] = -24.9575997948692
    jac_run[79,92] = -23.2849644809540
    jac_run[80,9] = -1.58482814504483
    jac_run[80,10] = -7.89461337514771
    jac_run[80,11] = -4.84676915585801
    jac_run[80,12] = 26.5300693004806
    jac_run[80,13] = -1.58482814504483
    jac_run[80,14] = -7.89461337514771
    jac_run[80,15] = -0.679918453285308
    jac_run[80,16] = -7.72144347466701
    jac_run[80,69] = 10.2713736253513
    jac_run[80,70] = -39.6392229058202
    jac_run[80,71] = -54.0657727682604
    jac_run[80,72] = 105.571769313180
    jac_run[80,73] = 10.2713736253513
    jac_run[80,74] = -39.6392229058201
    jac_run[80,75] = 23.2849644809540
    jac_run[80,76] = -24.9575997948692
    jac_run[80,77] = -18.9579191056579
    jac_run[80,78] = 87.1730591867880
    jac_run[80,79] = 112.978314692379
    jac_run[80,80] = -237.673607926841
    jac_run[80,81] = -18.9579191056579
    jac_run[80,82] = 87.1730591867880
    jac_run[80,83] = -45.8900105086227
    jac_run[80,84] = 57.6366430644054
    jac_run[80,85] = 10.2713736253513
    jac_run[80,86] = -39.6392229058202
    jac_run[80,87] = -54.0657727682604
    jac_run[80,88] = 105.571769313180
    jac_run[80,89] = 10.2713736253513
    jac_run[80,90] = -39.6392229058201
    jac_run[80,91] = 23.2849644809540
    jac_run[80,92] = -24.9575997948692
    jac_run[81,9] = -7.72144347466701
    jac_run[81,10] = 0.679918453285310
    jac_run[81,11] = -7.89461337514770
    jac_run[81,12] = 1.58482814504483
    jac_run[81,13] = 26.5300693004806
    jac_run[81,14] = 4.84676915585801
    jac_run[81,15] = -7.89461337514771
    jac_run[81,16] = 1.58482814504483
    jac_run[81,69] = -24.9575997948692
    jac_run[81,70] = -23.2849644809540
    jac_run[81,71] = -39.6392229058202
    jac_run[81,72] = -10.2713736253513
    jac_run[81,73] = 105.571769313180
    jac_run[81,74] = 54.0657727682604
    jac_run[81,75] = -39.6392229058201
    jac_run[81,76] = -10.2713736253514
    jac_run[81,77] = 57.6366430644054
    jac_run[81,78] = 45.8900105086227
    jac_run[81,79] = 87.1730591867881
    jac_run[81,80] = 18.9579191056578
    jac_run[81,81] = -237.673607926841
    jac_run[81,82] = -112.978314692379
    jac_run[81,83] = 87.1730591867880
    jac_run[81,84] = 18.9579191056579
    jac_run[81,85] = -24.9575997948692
    jac_run[81,86] = -23.2849644809540
    jac_run[81,87] = -39.6392229058202
    jac_run[81,88] = -10.2713736253513
    jac_run[81,89] = 105.571769313180
    jac_run[81,90] = 54.0657727682604
    jac_run[81,91] = -39.6392229058201
    jac_run[81,92] = -10.2713736253514
    jac_run[82,9] = -0.679918453285310
    jac_run[82,10] = -7.72144347466701
    jac_run[82,11] = -1.58482814504483
    jac_run[82,12] = -7.89461337514770
    jac_run[82,13] = -4.84676915585801
    jac_run[82,14] = 26.5300693004806
    jac_run[82,15] = -1.58482814504483
    jac_run[82,16] = -7.89461337514771
    jac_run[82,69] = 23.2849644809540
    jac_run[82,70] = -24.9575997948692
    jac_run[82,71] = 10.2713736253513
    jac_run[82,72] = -39.6392229058202
    jac_run[82,73] = -54.0657727682604
    jac_run[82,74] = 105.571769313180
    jac_run[82,75] = 10.2713736253514
    jac_run[82,76] = -39.6392229058201
    jac_run[82,77] = -45.8900105086227
    jac_run[82,78] = 57.6366430644054
    jac_run[82,79] = -18.9579191056578
    jac_run[82,80] = 87.1730591867881
    jac_run[82,81] = 112.978314692379
    jac_run[82,82] = -237.673607926841
    jac_run[82,83] = -18.9579191056579
    jac_run[82,84] = 87.1730591867880
    jac_run[82,85] = 23.2849644809540
    jac_run[82,86] = -24.9575997948692
    jac_run[82,87] = 10.2713736253513
    jac_run[82,88] = -39.6392229058202
    jac_run[82,89] = -54.0657727682604
    jac_run[82,90] = 105.571769313180
    jac_run[82,91] = 10.2713736253514
    jac_run[82,92] = -39.6392229058201
    jac_run[83,9] = -7.89461337514771
    jac_run[83,10] = 1.58482814504483
    jac_run[83,11] = -7.72144347466701
    jac_run[83,12] = 0.679918453285308
    jac_run[83,13] = -7.89461337514771
    jac_run[83,14] = 1.58482814504483
    jac_run[83,15] = 26.5300693004806
    jac_run[83,16] = 4.84676915585801
    jac_run[83,69] = -39.6392229058202
    jac_run[83,70] = -10.2713736253513
    jac_run[83,71] = -24.9575997948692
    jac_run[83,72] = -23.2849644809540
    jac_run[83,73] = -39.6392229058202
    jac_run[83,74] = -10.2713736253513
    jac_run[83,75] = 105.571769313180
    jac_run[83,76] = 54.0657727682604
    jac_run[83,77] = 87.1730591867880
    jac_run[83,78] = 18.9579191056578
    jac_run[83,79] = 57.6366430644054
    jac_run[83,80] = 45.8900105086227
    jac_run[83,81] = 87.1730591867880
    jac_run[83,82] = 18.9579191056579
    jac_run[83,83] = -237.673607926841
    jac_run[83,84] = -112.978314692379
    jac_run[83,85] = -39.6392229058202
    jac_run[83,86] = -10.2713736253513
    jac_run[83,87] = -24.9575997948692
    jac_run[83,88] = -23.2849644809540
    jac_run[83,89] = -39.6392229058202
    jac_run[83,90] = -10.2713736253513
    jac_run[83,91] = 105.571769313180
    jac_run[83,92] = 54.0657727682604
    jac_run[84,9] = -1.58482814504483
    jac_run[84,10] = -7.89461337514771
    jac_run[84,11] = -0.679918453285308
    jac_run[84,12] = -7.72144347466701
    jac_run[84,13] = -1.58482814504483
    jac_run[84,14] = -7.89461337514771
    jac_run[84,15] = -4.84676915585801
    jac_run[84,16] = 26.5300693004806
    jac_run[84,69] = 10.2713736253513
    jac_run[84,70] = -39.6392229058202
    jac_run[84,71] = 23.2849644809540
    jac_run[84,72] = -24.9575997948692
    jac_run[84,73] = 10.2713736253513
    jac_run[84,74] = -39.6392229058202
    jac_run[84,75] = -54.0657727682604
    jac_run[84,76] = 105.571769313180
    jac_run[84,77] = -18.9579191056578
    jac_run[84,78] = 87.1730591867880
    jac_run[84,79] = -45.8900105086227
    jac_run[84,80] = 57.6366430644054
    jac_run[84,81] = -18.9579191056579
    jac_run[84,82] = 87.1730591867880
    jac_run[84,83] = 112.978314692379
    jac_run[84,84] = -237.673607926841
    jac_run[84,85] = 10.2713736253513
    jac_run[84,86] = -39.6392229058202
    jac_run[84,87] = 23.2849644809540
    jac_run[84,88] = -24.9575997948692
    jac_run[84,89] = 10.2713736253513
    jac_run[84,90] = -39.6392229058202
    jac_run[84,91] = -54.0657727682604
    jac_run[84,92] = 105.571769313180
    jac_run[85,77] = 105.571769313180
    jac_run[85,78] = 54.0657727682604
    jac_run[85,79] = -39.6392229058202
    jac_run[85,80] = -10.2713736253513
    jac_run[85,81] = -24.9575997948692
    jac_run[85,82] = -23.2849644809540
    jac_run[85,83] = -39.6392229058202
    jac_run[85,84] = -10.2713736253513
    jac_run[85,85] = -237.673607926841
    jac_run[85,86] = -112.978314692379
    jac_run[85,87] = 87.1730591867880
    jac_run[85,88] = 18.9579191056578
    jac_run[85,89] = 57.6366430644055
    jac_run[85,90] = 45.8900105086227
    jac_run[85,91] = 87.1730591867880
    jac_run[85,92] = 18.9579191056579
    jac_run[85,93] = 105.571769313180
    jac_run[85,94] = 54.0657727682604
    jac_run[85,95] = -39.6392229058202
    jac_run[85,96] = -10.2713736253513
    jac_run[85,97] = -24.9575997948692
    jac_run[85,98] = -23.2849644809540
    jac_run[85,99] = -39.6392229058202
    jac_run[85,100] = -10.2713736253513
    jac_run[85,141] = 26.5300693004806
    jac_run[85,142] = 4.84676915585801
    jac_run[85,143] = -7.89461337514770
    jac_run[85,144] = 1.58482814504483
    jac_run[85,145] = -7.72144347466701
    jac_run[85,146] = 0.679918453285310
    jac_run[85,147] = -7.89461337514771
    jac_run[85,148] = 1.58482814504483
    jac_run[86,77] = -54.0657727682604
    jac_run[86,78] = 105.571769313180
    jac_run[86,79] = 10.2713736253513
    jac_run[86,80] = -39.6392229058202
    jac_run[86,81] = 23.2849644809540
    jac_run[86,82] = -24.9575997948692
    jac_run[86,83] = 10.2713736253513
    jac_run[86,84] = -39.6392229058202
    jac_run[86,85] = 112.978314692379
    jac_run[86,86] = -237.673607926841
    jac_run[86,87] = -18.9579191056578
    jac_run[86,88] = 87.1730591867880
    jac_run[86,89] = -45.8900105086227
    jac_run[86,90] = 57.6366430644055
    jac_run[86,91] = -18.9579191056579
    jac_run[86,92] = 87.1730591867880
    jac_run[86,93] = -54.0657727682604
    jac_run[86,94] = 105.571769313180
    jac_run[86,95] = 10.2713736253513
    jac_run[86,96] = -39.6392229058202
    jac_run[86,97] = 23.2849644809540
    jac_run[86,98] = -24.9575997948692
    jac_run[86,99] = 10.2713736253513
    jac_run[86,100] = -39.6392229058202
    jac_run[86,141] = -4.84676915585801
    jac_run[86,142] = 26.5300693004806
    jac_run[86,143] = -1.58482814504483
    jac_run[86,144] = -7.89461337514770
    jac_run[86,145] = -0.679918453285310
    jac_run[86,146] = -7.72144347466701
    jac_run[86,147] = -1.58482814504483
    jac_run[86,148] = -7.89461337514771
    jac_run[87,77] = -39.6392229058202
    jac_run[87,78] = -10.2713736253513
    jac_run[87,79] = 105.571769313180
    jac_run[87,80] = 54.0657727682604
    jac_run[87,81] = -39.6392229058201
    jac_run[87,82] = -10.2713736253513
    jac_run[87,83] = -24.9575997948692
    jac_run[87,84] = -23.2849644809540
    jac_run[87,85] = 87.1730591867880
    jac_run[87,86] = 18.9579191056579
    jac_run[87,87] = -237.673607926841
    jac_run[87,88] = -112.978314692379
    jac_run[87,89] = 87.1730591867880
    jac_run[87,90] = 18.9579191056579
    jac_run[87,91] = 57.6366430644054
    jac_run[87,92] = 45.8900105086227
    jac_run[87,93] = -39.6392229058202
    jac_run[87,94] = -10.2713736253513
    jac_run[87,95] = 105.571769313180
    jac_run[87,96] = 54.0657727682604
    jac_run[87,97] = -39.6392229058201
    jac_run[87,98] = -10.2713736253513
    jac_run[87,99] = -24.9575997948692
    jac_run[87,100] = -23.2849644809540
    jac_run[87,141] = -7.89461337514771
    jac_run[87,142] = 1.58482814504483
    jac_run[87,143] = 26.5300693004806
    jac_run[87,144] = 4.84676915585801
    jac_run[87,145] = -7.89461337514771
    jac_run[87,146] = 1.58482814504483
    jac_run[87,147] = -7.72144347466701
    jac_run[87,148] = 0.679918453285308
    jac_run[88,77] = 10.2713736253513
    jac_run[88,78] = -39.6392229058202
    jac_run[88,79] = -54.0657727682604
    jac_run[88,80] = 105.571769313180
    jac_run[88,81] = 10.2713736253513
    jac_run[88,82] = -39.6392229058201
    jac_run[88,83] = 23.2849644809540
    jac_run[88,84] = -24.9575997948692
    jac_run[88,85] = -18.9579191056579
    jac_run[88,86] = 87.1730591867880
    jac_run[88,87] = 112.978314692379
    jac_run[88,88] = -237.673607926841
    jac_run[88,89] = -18.9579191056579
    jac_run[88,90] = 87.1730591867880
    jac_run[88,91] = -45.8900105086227
    jac_run[88,92] = 57.6366430644054
    jac_run[88,93] = 10.2713736253513
    jac_run[88,94] = -39.6392229058202
    jac_run[88,95] = -54.0657727682604
    jac_run[88,96] = 105.571769313180
    jac_run[88,97] = 10.2713736253513
    jac_run[88,98] = -39.6392229058201
    jac_run[88,99] = 23.2849644809540
    jac_run[88,100] = -24.9575997948692
    jac_run[88,141] = -1.58482814504483
    jac_run[88,142] = -7.89461337514771
    jac_run[88,143] = -4.84676915585801
    jac_run[88,144] = 26.5300693004806
    jac_run[88,145] = -1.58482814504483
    jac_run[88,146] = -7.89461337514771
    jac_run[88,147] = -0.679918453285308
    jac_run[88,148] = -7.72144347466701
    jac_run[89,77] = -24.9575997948692
    jac_run[89,78] = -23.2849644809540
    jac_run[89,79] = -39.6392229058202
    jac_run[89,80] = -10.2713736253513
    jac_run[89,81] = 105.571769313180
    jac_run[89,82] = 54.0657727682604
    jac_run[89,83] = -39.6392229058201
    jac_run[89,84] = -10.2713736253514
    jac_run[89,85] = 57.6366430644054
    jac_run[89,86] = 45.8900105086227
    jac_run[89,87] = 87.1730591867881
    jac_run[89,88] = 18.9579191056578
    jac_run[89,89] = -237.673607926841
    jac_run[89,90] = -112.978314692379
    jac_run[89,91] = 87.1730591867880
    jac_run[89,92] = 18.9579191056579
    jac_run[89,93] = -24.9575997948692
    jac_run[89,94] = -23.2849644809540
    jac_run[89,95] = -39.6392229058202
    jac_run[89,96] = -10.2713736253513
    jac_run[89,97] = 105.571769313180
    jac_run[89,98] = 54.0657727682604
    jac_run[89,99] = -39.6392229058201
    jac_run[89,100] = -10.2713736253514
    jac_run[89,141] = -7.72144347466701
    jac_run[89,142] = 0.679918453285310
    jac_run[89,143] = -7.89461337514770
    jac_run[89,144] = 1.58482814504483
    jac_run[89,145] = 26.5300693004806
    jac_run[89,146] = 4.84676915585801
    jac_run[89,147] = -7.89461337514771
    jac_run[89,148] = 1.58482814504483
    jac_run[90,77] = 23.2849644809540
    jac_run[90,78] = -24.9575997948692
    jac_run[90,79] = 10.2713736253513
    jac_run[90,80] = -39.6392229058202
    jac_run[90,81] = -54.0657727682604
    jac_run[90,82] = 105.571769313180
    jac_run[90,83] = 10.2713736253514
    jac_run[90,84] = -39.6392229058201
    jac_run[90,85] = -45.8900105086227
    jac_run[90,86] = 57.6366430644054
    jac_run[90,87] = -18.9579191056578
    jac_run[90,88] = 87.1730591867881
    jac_run[90,89] = 112.978314692379
    jac_run[90,90] = -237.673607926841
    jac_run[90,91] = -18.9579191056579
    jac_run[90,92] = 87.1730591867880
    jac_run[90,93] = 23.2849644809540
    jac_run[90,94] = -24.9575997948692
    jac_run[90,95] = 10.2713736253513
    jac_run[90,96] = -39.6392229058202
    jac_run[90,97] = -54.0657727682604
    jac_run[90,98] = 105.571769313180
    jac_run[90,99] = 10.2713736253514
    jac_run[90,100] = -39.6392229058201
    jac_run[90,141] = -0.679918453285310
    jac_run[90,142] = -7.72144347466701
    jac_run[90,143] = -1.58482814504483
    jac_run[90,144] = -7.89461337514770
    jac_run[90,145] = -4.84676915585801
    jac_run[90,146] = 26.5300693004806
    jac_run[90,147] = -1.58482814504483
    jac_run[90,148] = -7.89461337514771
    jac_run[91,77] = -39.6392229058202
    jac_run[91,78] = -10.2713736253513
    jac_run[91,79] = -24.9575997948692
    jac_run[91,80] = -23.2849644809540
    jac_run[91,81] = -39.6392229058202
    jac_run[91,82] = -10.2713736253513
    jac_run[91,83] = 105.571769313180
    jac_run[91,84] = 54.0657727682604
    jac_run[91,85] = 87.1730591867880
    jac_run[91,86] = 18.9579191056578
    jac_run[91,87] = 57.6366430644054
    jac_run[91,88] = 45.8900105086227
    jac_run[91,89] = 87.1730591867880
    jac_run[91,90] = 18.9579191056579
    jac_run[91,91] = -237.698607926841
    jac_run[91,92] = -112.978314692379
    jac_run[91,93] = -39.6392229058202
    jac_run[91,94] = -10.2713736253513
    jac_run[91,95] = -24.9575997948692
    jac_run[91,96] = -23.2849644809540
    jac_run[91,97] = -39.6392229058202
    jac_run[91,98] = -10.2713736253513
    jac_run[91,99] = 105.571769313180
    jac_run[91,100] = 54.0657727682604
    jac_run[91,141] = -7.89461337514771
    jac_run[91,142] = 1.58482814504483
    jac_run[91,143] = -7.72144347466701
    jac_run[91,144] = 0.679918453285308
    jac_run[91,145] = -7.89461337514771
    jac_run[91,146] = 1.58482814504483
    jac_run[91,147] = 26.5300693004806
    jac_run[91,148] = 4.84676915585801
    jac_run[92,77] = 10.2713736253513
    jac_run[92,78] = -39.6392229058202
    jac_run[92,79] = 23.2849644809540
    jac_run[92,80] = -24.9575997948692
    jac_run[92,81] = 10.2713736253513
    jac_run[92,82] = -39.6392229058202
    jac_run[92,83] = -54.0657727682604
    jac_run[92,84] = 105.571769313180
    jac_run[92,85] = -18.9579191056578
    jac_run[92,86] = 87.1730591867880
    jac_run[92,87] = -45.8900105086227
    jac_run[92,88] = 57.6366430644054
    jac_run[92,89] = -18.9579191056579
    jac_run[92,90] = 87.1730591867880
    jac_run[92,91] = 112.978314692379
    jac_run[92,92] = -237.698607926841
    jac_run[92,93] = 10.2713736253513
    jac_run[92,94] = -39.6392229058202
    jac_run[92,95] = 23.2849644809540
    jac_run[92,96] = -24.9575997948692
    jac_run[92,97] = 10.2713736253513
    jac_run[92,98] = -39.6392229058202
    jac_run[92,99] = -54.0657727682604
    jac_run[92,100] = 105.571769313180
    jac_run[92,141] = -1.58482814504483
    jac_run[92,142] = -7.89461337514771
    jac_run[92,143] = -0.679918453285308
    jac_run[92,144] = -7.72144347466701
    jac_run[92,145] = -1.58482814504483
    jac_run[92,146] = -7.89461337514771
    jac_run[92,147] = -4.84676915585801
    jac_run[92,148] = 26.5300693004806
    jac_run[93,85] = 105.571769313180
    jac_run[93,86] = 54.0657727682604
    jac_run[93,87] = -39.6392229058202
    jac_run[93,88] = -10.2713736253513
    jac_run[93,89] = -24.9575997948692
    jac_run[93,90] = -23.2849644809540
    jac_run[93,91] = -39.6392229058202
    jac_run[93,92] = -10.2713736253513
    jac_run[93,93] = -211.143538626360
    jac_run[93,94] = -108.131545536521
    jac_run[93,95] = 79.2784458116403
    jac_run[93,96] = 20.5427472507027
    jac_run[93,97] = 49.9151995897384
    jac_run[93,98] = 46.5699289619080
    jac_run[93,99] = 79.2784458116403
    jac_run[93,100] = 20.5427472507027
    jac_run[93,101] = 105.571769313180
    jac_run[93,102] = 54.0657727682604
    jac_run[93,103] = -39.6392229058202
    jac_run[93,104] = -10.2713736253513
    jac_run[93,105] = -24.9575997948692
    jac_run[93,106] = -23.2849644809540
    jac_run[93,107] = -39.6392229058202
    jac_run[93,108] = -10.2713736253513
    jac_run[94,85] = -54.0657727682604
    jac_run[94,86] = 105.571769313180
    jac_run[94,87] = 10.2713736253513
    jac_run[94,88] = -39.6392229058202
    jac_run[94,89] = 23.2849644809540
    jac_run[94,90] = -24.9575997948692
    jac_run[94,91] = 10.2713736253513
    jac_run[94,92] = -39.6392229058202
    jac_run[94,93] = 108.131545536521
    jac_run[94,94] = -211.143538626360
    jac_run[94,95] = -20.5427472507027
    jac_run[94,96] = 79.2784458116403
    jac_run[94,97] = -46.5699289619080
    jac_run[94,98] = 49.9151995897384
    jac_run[94,99] = -20.5427472507027
    jac_run[94,100] = 79.2784458116403
    jac_run[94,101] = -54.0657727682604
    jac_run[94,102] = 105.571769313180
    jac_run[94,103] = 10.2713736253513
    jac_run[94,104] = -39.6392229058202
    jac_run[94,105] = 23.2849644809540
    jac_run[94,106] = -24.9575997948692
    jac_run[94,107] = 10.2713736253513
    jac_run[94,108] = -39.6392229058202
    jac_run[95,85] = -39.6392229058202
    jac_run[95,86] = -10.2713736253513
    jac_run[95,87] = 105.571769313180
    jac_run[95,88] = 54.0657727682604
    jac_run[95,89] = -39.6392229058201
    jac_run[95,90] = -10.2713736253513
    jac_run[95,91] = -24.9575997948692
    jac_run[95,92] = -23.2849644809540
    jac_run[95,93] = 79.2784458116403
    jac_run[95,94] = 20.5427472507027
    jac_run[95,95] = -211.143538626360
    jac_run[95,96] = -108.131545536521
    jac_run[95,97] = 79.2784458116403
    jac_run[95,98] = 20.5427472507027
    jac_run[95,99] = 49.9151995897384
    jac_run[95,100] = 46.5699289619080
    jac_run[95,101] = -39.6392229058202
    jac_run[95,102] = -10.2713736253513
    jac_run[95,103] = 105.571769313180
    jac_run[95,104] = 54.0657727682604
    jac_run[95,105] = -39.6392229058201
    jac_run[95,106] = -10.2713736253513
    jac_run[95,107] = -24.9575997948692
    jac_run[95,108] = -23.2849644809540
    jac_run[96,85] = 10.2713736253513
    jac_run[96,86] = -39.6392229058202
    jac_run[96,87] = -54.0657727682604
    jac_run[96,88] = 105.571769313180
    jac_run[96,89] = 10.2713736253513
    jac_run[96,90] = -39.6392229058201
    jac_run[96,91] = 23.2849644809540
    jac_run[96,92] = -24.9575997948692
    jac_run[96,93] = -20.5427472507027
    jac_run[96,94] = 79.2784458116403
    jac_run[96,95] = 108.131545536521
    jac_run[96,96] = -211.143538626360
    jac_run[96,97] = -20.5427472507027
    jac_run[96,98] = 79.2784458116403
    jac_run[96,99] = -46.5699289619080
    jac_run[96,100] = 49.9151995897384
    jac_run[96,101] = 10.2713736253513
    jac_run[96,102] = -39.6392229058202
    jac_run[96,103] = -54.0657727682604
    jac_run[96,104] = 105.571769313180
    jac_run[96,105] = 10.2713736253513
    jac_run[96,106] = -39.6392229058201
    jac_run[96,107] = 23.2849644809540
    jac_run[96,108] = -24.9575997948692
    jac_run[97,85] = -24.9575997948692
    jac_run[97,86] = -23.2849644809540
    jac_run[97,87] = -39.6392229058202
    jac_run[97,88] = -10.2713736253513
    jac_run[97,89] = 105.571769313180
    jac_run[97,90] = 54.0657727682604
    jac_run[97,91] = -39.6392229058201
    jac_run[97,92] = -10.2713736253514
    jac_run[97,93] = 49.9151995897384
    jac_run[97,94] = 46.5699289619080
    jac_run[97,95] = 79.2784458116404
    jac_run[97,96] = 20.5427472507027
    jac_run[97,97] = -211.143538626360
    jac_run[97,98] = -108.131545536521
    jac_run[97,99] = 79.2784458116403
    jac_run[97,100] = 20.5427472507027
    jac_run[97,101] = -24.9575997948692
    jac_run[97,102] = -23.2849644809540
    jac_run[97,103] = -39.6392229058202
    jac_run[97,104] = -10.2713736253513
    jac_run[97,105] = 105.571769313180
    jac_run[97,106] = 54.0657727682604
    jac_run[97,107] = -39.6392229058201
    jac_run[97,108] = -10.2713736253514
    jac_run[98,85] = 23.2849644809540
    jac_run[98,86] = -24.9575997948692
    jac_run[98,87] = 10.2713736253513
    jac_run[98,88] = -39.6392229058202
    jac_run[98,89] = -54.0657727682604
    jac_run[98,90] = 105.571769313180
    jac_run[98,91] = 10.2713736253514
    jac_run[98,92] = -39.6392229058201
    jac_run[98,93] = -46.5699289619080
    jac_run[98,94] = 49.9151995897384
    jac_run[98,95] = -20.5427472507027
    jac_run[98,96] = 79.2784458116404
    jac_run[98,97] = 108.131545536521
    jac_run[98,98] = -211.143538626360
    jac_run[98,99] = -20.5427472507027
    jac_run[98,100] = 79.2784458116403
    jac_run[98,101] = 23.2849644809540
    jac_run[98,102] = -24.9575997948692
    jac_run[98,103] = 10.2713736253513
    jac_run[98,104] = -39.6392229058202
    jac_run[98,105] = -54.0657727682604
    jac_run[98,106] = 105.571769313180
    jac_run[98,107] = 10.2713736253514
    jac_run[98,108] = -39.6392229058201
    jac_run[99,85] = -39.6392229058202
    jac_run[99,86] = -10.2713736253513
    jac_run[99,87] = -24.9575997948692
    jac_run[99,88] = -23.2849644809540
    jac_run[99,89] = -39.6392229058202
    jac_run[99,90] = -10.2713736253513
    jac_run[99,91] = 105.571769313180
    jac_run[99,92] = 54.0657727682604
    jac_run[99,93] = 79.2784458116403
    jac_run[99,94] = 20.5427472507027
    jac_run[99,95] = 49.9151995897384
    jac_run[99,96] = 46.5699289619080
    jac_run[99,97] = 79.2784458116403
    jac_run[99,98] = 20.5427472507027
    jac_run[99,99] = -211.143538626360
    jac_run[99,100] = -108.131545536521
    jac_run[99,101] = -39.6392229058202
    jac_run[99,102] = -10.2713736253513
    jac_run[99,103] = -24.9575997948692
    jac_run[99,104] = -23.2849644809540
    jac_run[99,105] = -39.6392229058202
    jac_run[99,106] = -10.2713736253513
    jac_run[99,107] = 105.571769313180
    jac_run[99,108] = 54.0657727682604
    jac_run[100,85] = 10.2713736253513
    jac_run[100,86] = -39.6392229058202
    jac_run[100,87] = 23.2849644809540
    jac_run[100,88] = -24.9575997948692
    jac_run[100,89] = 10.2713736253513
    jac_run[100,90] = -39.6392229058202
    jac_run[100,91] = -54.0657727682604
    jac_run[100,92] = 105.571769313180
    jac_run[100,93] = -20.5427472507027
    jac_run[100,94] = 79.2784458116403
    jac_run[100,95] = -46.5699289619080
    jac_run[100,96] = 49.9151995897384
    jac_run[100,97] = -20.5427472507027
    jac_run[100,98] = 79.2784458116403
    jac_run[100,99] = 108.131545536521
    jac_run[100,100] = -211.143538626360
    jac_run[100,101] = 10.2713736253513
    jac_run[100,102] = -39.6392229058202
    jac_run[100,103] = 23.2849644809540
    jac_run[100,104] = -24.9575997948692
    jac_run[100,105] = 10.2713736253513
    jac_run[100,106] = -39.6392229058202
    jac_run[100,107] = -54.0657727682604
    jac_run[100,108] = 105.571769313180
    jac_run[101,25] = 30.9517475172273
    jac_run[101,26] = 5.65456401516768
    jac_run[101,27] = -9.21038227100566
    jac_run[101,28] = 1.84896616921897
    jac_run[101,29] = -9.00835072044485
    jac_run[101,30] = 0.793238195499529
    jac_run[101,31] = -9.21038227100566
    jac_run[101,32] = 1.84896616921897
    jac_run[101,93] = 105.571769313180
    jac_run[101,94] = 54.0657727682604
    jac_run[101,95] = -39.6392229058202
    jac_run[101,96] = -10.2713736253513
    jac_run[101,97] = -24.9575997948692
    jac_run[101,98] = -23.2849644809540
    jac_run[101,99] = -39.6392229058202
    jac_run[101,100] = -10.2713736253513
    jac_run[101,101] = -242.095286143588
    jac_run[101,102] = -113.786109551688
    jac_run[101,103] = 88.4888280826460
    jac_run[101,104] = 18.6937810814837
    jac_run[101,105] = 58.9235503101833
    jac_run[101,106] = 45.7766907664085
    jac_run[101,107] = 88.4888280826460
    jac_run[101,108] = 18.6937810814837
    jac_run[101,109] = 105.571769313180
    jac_run[101,110] = 54.0657727682604
    jac_run[101,111] = -39.6392229058202
    jac_run[101,112] = -10.2713736253513
    jac_run[101,113] = -24.9575997948692
    jac_run[101,114] = -23.2849644809540
    jac_run[101,115] = -39.6392229058202
    jac_run[101,116] = -10.2713736253513
    jac_run[102,25] = -5.65456401516768
    jac_run[102,26] = 30.9517475172273
    jac_run[102,27] = -1.84896616921897
    jac_run[102,28] = -9.21038227100566
    jac_run[102,29] = -0.793238195499529
    jac_run[102,30] = -9.00835072044485
    jac_run[102,31] = -1.84896616921897
    jac_run[102,32] = -9.21038227100566
    jac_run[102,93] = -54.0657727682604
    jac_run[102,94] = 105.571769313180
    jac_run[102,95] = 10.2713736253513
    jac_run[102,96] = -39.6392229058202
    jac_run[102,97] = 23.2849644809540
    jac_run[102,98] = -24.9575997948692
    jac_run[102,99] = 10.2713736253513
    jac_run[102,100] = -39.6392229058202
    jac_run[102,101] = 113.786109551688
    jac_run[102,102] = -242.095286143588
    jac_run[102,103] = -18.6937810814837
    jac_run[102,104] = 88.4888280826460
    jac_run[102,105] = -45.7766907664085
    jac_run[102,106] = 58.9235503101833
    jac_run[102,107] = -18.6937810814837
    jac_run[102,108] = 88.4888280826460
    jac_run[102,109] = -54.0657727682604
    jac_run[102,110] = 105.571769313180
    jac_run[102,111] = 10.2713736253513
    jac_run[102,112] = -39.6392229058202
    jac_run[102,113] = 23.2849644809540
    jac_run[102,114] = -24.9575997948692
    jac_run[102,115] = 10.2713736253513
    jac_run[102,116] = -39.6392229058202
    jac_run[103,25] = -9.21038227100566
    jac_run[103,26] = 1.84896616921897
    jac_run[103,27] = 30.9517475172273
    jac_run[103,28] = 5.65456401516768
    jac_run[103,29] = -9.21038227100566
    jac_run[103,30] = 1.84896616921897
    jac_run[103,31] = -9.00835072044485
    jac_run[103,32] = 0.793238195499528
    jac_run[103,93] = -39.6392229058202
    jac_run[103,94] = -10.2713736253513
    jac_run[103,95] = 105.571769313180
    jac_run[103,96] = 54.0657727682604
    jac_run[103,97] = -39.6392229058201
    jac_run[103,98] = -10.2713736253513
    jac_run[103,99] = -24.9575997948692
    jac_run[103,100] = -23.2849644809540
    jac_run[103,101] = 88.4888280826460
    jac_run[103,102] = 18.6937810814837
    jac_run[103,103] = -242.095286143588
    jac_run[103,104] = -113.786109551688
    jac_run[103,105] = 88.4888280826460
    jac_run[103,106] = 18.6937810814837
    jac_run[103,107] = 58.9235503101833
    jac_run[103,108] = 45.7766907664085
    jac_run[103,109] = -39.6392229058202
    jac_run[103,110] = -10.2713736253513
    jac_run[103,111] = 105.571769313180
    jac_run[103,112] = 54.0657727682604
    jac_run[103,113] = -39.6392229058201
    jac_run[103,114] = -10.2713736253513
    jac_run[103,115] = -24.9575997948692
    jac_run[103,116] = -23.2849644809540
    jac_run[104,25] = -1.84896616921897
    jac_run[104,26] = -9.21038227100566
    jac_run[104,27] = -5.65456401516768
    jac_run[104,28] = 30.9517475172273
    jac_run[104,29] = -1.84896616921897
    jac_run[104,30] = -9.21038227100566
    jac_run[104,31] = -0.793238195499528
    jac_run[104,32] = -9.00835072044485
    jac_run[104,93] = 10.2713736253513
    jac_run[104,94] = -39.6392229058202
    jac_run[104,95] = -54.0657727682604
    jac_run[104,96] = 105.571769313180
    jac_run[104,97] = 10.2713736253513
    jac_run[104,98] = -39.6392229058201
    jac_run[104,99] = 23.2849644809540
    jac_run[104,100] = -24.9575997948692
    jac_run[104,101] = -18.6937810814837
    jac_run[104,102] = 88.4888280826460
    jac_run[104,103] = 113.786109551688
    jac_run[104,104] = -242.095286143588
    jac_run[104,105] = -18.6937810814837
    jac_run[104,106] = 88.4888280826460
    jac_run[104,107] = -45.7766907664085
    jac_run[104,108] = 58.9235503101833
    jac_run[104,109] = 10.2713736253513
    jac_run[104,110] = -39.6392229058202
    jac_run[104,111] = -54.0657727682604
    jac_run[104,112] = 105.571769313180
    jac_run[104,113] = 10.2713736253513
    jac_run[104,114] = -39.6392229058201
    jac_run[104,115] = 23.2849644809540
    jac_run[104,116] = -24.9575997948692
    jac_run[105,25] = -9.00835072044484
    jac_run[105,26] = 0.793238195499527
    jac_run[105,27] = -9.21038227100566
    jac_run[105,28] = 1.84896616921897
    jac_run[105,29] = 30.9517475172273
    jac_run[105,30] = 5.65456401516768
    jac_run[105,31] = -9.21038227100566
    jac_run[105,32] = 1.84896616921897
    jac_run[105,93] = -24.9575997948692
    jac_run[105,94] = -23.2849644809540
    jac_run[105,95] = -39.6392229058202
    jac_run[105,96] = -10.2713736253513
    jac_run[105,97] = 105.571769313180
    jac_run[105,98] = 54.0657727682604
    jac_run[105,99] = -39.6392229058201
    jac_run[105,100] = -10.2713736253514
    jac_run[105,101] = 58.9235503101833
    jac_run[105,102] = 45.7766907664085
    jac_run[105,103] = 88.4888280826461
    jac_run[105,104] = 18.6937810814837
    jac_run[105,105] = -242.095286143588
    jac_run[105,106] = -113.786109551688
    jac_run[105,107] = 88.4888280826459
    jac_run[105,108] = 18.6937810814837
    jac_run[105,109] = -24.9575997948692
    jac_run[105,110] = -23.2849644809540
    jac_run[105,111] = -39.6392229058202
    jac_run[105,112] = -10.2713736253513
    jac_run[105,113] = 105.571769313180
    jac_run[105,114] = 54.0657727682604
    jac_run[105,115] = -39.6392229058201
    jac_run[105,116] = -10.2713736253514
    jac_run[106,25] = -0.793238195499527
    jac_run[106,26] = -9.00835072044484
    jac_run[106,27] = -1.84896616921897
    jac_run[106,28] = -9.21038227100566
    jac_run[106,29] = -5.65456401516768
    jac_run[106,30] = 30.9517475172273
    jac_run[106,31] = -1.84896616921897
    jac_run[106,32] = -9.21038227100566
    jac_run[106,93] = 23.2849644809540
    jac_run[106,94] = -24.9575997948692
    jac_run[106,95] = 10.2713736253513
    jac_run[106,96] = -39.6392229058202
    jac_run[106,97] = -54.0657727682604
    jac_run[106,98] = 105.571769313180
    jac_run[106,99] = 10.2713736253514
    jac_run[106,100] = -39.6392229058201
    jac_run[106,101] = -45.7766907664085
    jac_run[106,102] = 58.9235503101833
    jac_run[106,103] = -18.6937810814837
    jac_run[106,104] = 88.4888280826461
    jac_run[106,105] = 113.786109551688
    jac_run[106,106] = -242.095286143588
    jac_run[106,107] = -18.6937810814837
    jac_run[106,108] = 88.4888280826459
    jac_run[106,109] = 23.2849644809540
    jac_run[106,110] = -24.9575997948692
    jac_run[106,111] = 10.2713736253513
    jac_run[106,112] = -39.6392229058202
    jac_run[106,113] = -54.0657727682604
    jac_run[106,114] = 105.571769313180
    jac_run[106,115] = 10.2713736253514
    jac_run[106,116] = -39.6392229058201
    jac_run[107,25] = -9.21038227100566
    jac_run[107,26] = 1.84896616921897
    jac_run[107,27] = -9.00835072044485
    jac_run[107,28] = 0.793238195499527
    jac_run[107,29] = -9.21038227100566
    jac_run[107,30] = 1.84896616921897
    jac_run[107,31] = 30.9517475172273
    jac_run[107,32] = 5.65456401516768
    jac_run[107,93] = -39.6392229058202
    jac_run[107,94] = -10.2713736253513
    jac_run[107,95] = -24.9575997948692
    jac_run[107,96] = -23.2849644809540
    jac_run[107,97] = -39.6392229058202
    jac_run[107,98] = -10.2713736253513
    jac_run[107,99] = 105.571769313180
    jac_run[107,100] = 54.0657727682604
    jac_run[107,101] = 88.4888280826460
    jac_run[107,102] = 18.6937810814837
    jac_run[107,103] = 58.9235503101832
    jac_run[107,104] = 45.7766907664085
    jac_run[107,105] = 88.4888280826460
    jac_run[107,106] = 18.6937810814837
    jac_run[107,107] = -242.120286143588
    jac_run[107,108] = -113.786109551688
    jac_run[107,109] = -39.6392229058202
    jac_run[107,110] = -10.2713736253513
    jac_run[107,111] = -24.9575997948692
    jac_run[107,112] = -23.2849644809540
    jac_run[107,113] = -39.6392229058202
    jac_run[107,114] = -10.2713736253513
    jac_run[107,115] = 105.571769313180
    jac_run[107,116] = 54.0657727682604
    jac_run[108,25] = -1.84896616921897
    jac_run[108,26] = -9.21038227100566
    jac_run[108,27] = -0.793238195499527
    jac_run[108,28] = -9.00835072044485
    jac_run[108,29] = -1.84896616921897
    jac_run[108,30] = -9.21038227100566
    jac_run[108,31] = -5.65456401516768
    jac_run[108,32] = 30.9517475172273
    jac_run[108,93] = 10.2713736253513
    jac_run[108,94] = -39.6392229058202
    jac_run[108,95] = 23.2849644809540
    jac_run[108,96] = -24.9575997948692
    jac_run[108,97] = 10.2713736253513
    jac_run[108,98] = -39.6392229058202
    jac_run[108,99] = -54.0657727682604
    jac_run[108,100] = 105.571769313180
    jac_run[108,101] = -18.6937810814837
    jac_run[108,102] = 88.4888280826460
    jac_run[108,103] = -45.7766907664085
    jac_run[108,104] = 58.9235503101832
    jac_run[108,105] = -18.6937810814837
    jac_run[108,106] = 88.4888280826460
    jac_run[108,107] = 113.786109551688
    jac_run[108,108] = -242.120286143588
    jac_run[108,109] = 10.2713736253513
    jac_run[108,110] = -39.6392229058202
    jac_run[108,111] = 23.2849644809540
    jac_run[108,112] = -24.9575997948692
    jac_run[108,113] = 10.2713736253513
    jac_run[108,114] = -39.6392229058202
    jac_run[108,115] = -54.0657727682604
    jac_run[108,116] = 105.571769313180
    jac_run[109,101] = 105.571769313180
    jac_run[109,102] = 54.0657727682604
    jac_run[109,103] = -39.6392229058202
    jac_run[109,104] = -10.2713736253513
    jac_run[109,105] = -24.9575997948692
    jac_run[109,106] = -23.2849644809540
    jac_run[109,107] = -39.6392229058202
    jac_run[109,108] = -10.2713736253513
    jac_run[109,109] = -211.143538626360
    jac_run[109,110] = -108.131545536521
    jac_run[109,111] = 79.2784458116403
    jac_run[109,112] = 20.5427472507027
    jac_run[109,113] = 49.9151995897384
    jac_run[109,114] = 46.5699289619080
    jac_run[109,115] = 79.2784458116403
    jac_run[109,116] = 20.5427472507027
    jac_run[109,117] = 105.571769313180
    jac_run[109,118] = 54.0657727682604
    jac_run[109,119] = -39.6392229058202
    jac_run[109,120] = -10.2713736253513
    jac_run[109,121] = -24.9575997948692
    jac_run[109,122] = -23.2849644809540
    jac_run[109,123] = -39.6392229058202
    jac_run[109,124] = -10.2713736253513
    jac_run[110,101] = -54.0657727682604
    jac_run[110,102] = 105.571769313180
    jac_run[110,103] = 10.2713736253513
    jac_run[110,104] = -39.6392229058202
    jac_run[110,105] = 23.2849644809540
    jac_run[110,106] = -24.9575997948692
    jac_run[110,107] = 10.2713736253513
    jac_run[110,108] = -39.6392229058202
    jac_run[110,109] = 108.131545536521
    jac_run[110,110] = -211.143538626360
    jac_run[110,111] = -20.5427472507027
    jac_run[110,112] = 79.2784458116403
    jac_run[110,113] = -46.5699289619080
    jac_run[110,114] = 49.9151995897384
    jac_run[110,115] = -20.5427472507027
    jac_run[110,116] = 79.2784458116403
    jac_run[110,117] = -54.0657727682604
    jac_run[110,118] = 105.571769313180
    jac_run[110,119] = 10.2713736253513
    jac_run[110,120] = -39.6392229058202
    jac_run[110,121] = 23.2849644809540
    jac_run[110,122] = -24.9575997948692
    jac_run[110,123] = 10.2713736253513
    jac_run[110,124] = -39.6392229058202
    jac_run[111,101] = -39.6392229058202
    jac_run[111,102] = -10.2713736253513
    jac_run[111,103] = 105.571769313180
    jac_run[111,104] = 54.0657727682604
    jac_run[111,105] = -39.6392229058201
    jac_run[111,106] = -10.2713736253513
    jac_run[111,107] = -24.9575997948692
    jac_run[111,108] = -23.2849644809540
    jac_run[111,109] = 79.2784458116403
    jac_run[111,110] = 20.5427472507027
    jac_run[111,111] = -211.143538626360
    jac_run[111,112] = -108.131545536521
    jac_run[111,113] = 79.2784458116403
    jac_run[111,114] = 20.5427472507027
    jac_run[111,115] = 49.9151995897384
    jac_run[111,116] = 46.5699289619080
    jac_run[111,117] = -39.6392229058202
    jac_run[111,118] = -10.2713736253513
    jac_run[111,119] = 105.571769313180
    jac_run[111,120] = 54.0657727682604
    jac_run[111,121] = -39.6392229058201
    jac_run[111,122] = -10.2713736253513
    jac_run[111,123] = -24.9575997948692
    jac_run[111,124] = -23.2849644809540
    jac_run[112,101] = 10.2713736253513
    jac_run[112,102] = -39.6392229058202
    jac_run[112,103] = -54.0657727682604
    jac_run[112,104] = 105.571769313180
    jac_run[112,105] = 10.2713736253513
    jac_run[112,106] = -39.6392229058201
    jac_run[112,107] = 23.2849644809540
    jac_run[112,108] = -24.9575997948692
    jac_run[112,109] = -20.5427472507027
    jac_run[112,110] = 79.2784458116403
    jac_run[112,111] = 108.131545536521
    jac_run[112,112] = -211.143538626360
    jac_run[112,113] = -20.5427472507027
    jac_run[112,114] = 79.2784458116403
    jac_run[112,115] = -46.5699289619080
    jac_run[112,116] = 49.9151995897384
    jac_run[112,117] = 10.2713736253513
    jac_run[112,118] = -39.6392229058202
    jac_run[112,119] = -54.0657727682604
    jac_run[112,120] = 105.571769313180
    jac_run[112,121] = 10.2713736253513
    jac_run[112,122] = -39.6392229058201
    jac_run[112,123] = 23.2849644809540
    jac_run[112,124] = -24.9575997948692
    jac_run[113,101] = -24.9575997948692
    jac_run[113,102] = -23.2849644809540
    jac_run[113,103] = -39.6392229058202
    jac_run[113,104] = -10.2713736253513
    jac_run[113,105] = 105.571769313180
    jac_run[113,106] = 54.0657727682604
    jac_run[113,107] = -39.6392229058201
    jac_run[113,108] = -10.2713736253514
    jac_run[113,109] = 49.9151995897384
    jac_run[113,110] = 46.5699289619080
    jac_run[113,111] = 79.2784458116404
    jac_run[113,112] = 20.5427472507027
    jac_run[113,113] = -211.143538626360
    jac_run[113,114] = -108.131545536521
    jac_run[113,115] = 79.2784458116403
    jac_run[113,116] = 20.5427472507027
    jac_run[113,117] = -24.9575997948692
    jac_run[113,118] = -23.2849644809540
    jac_run[113,119] = -39.6392229058202
    jac_run[113,120] = -10.2713736253513
    jac_run[113,121] = 105.571769313180
    jac_run[113,122] = 54.0657727682604
    jac_run[113,123] = -39.6392229058201
    jac_run[113,124] = -10.2713736253514
    jac_run[114,101] = 23.2849644809540
    jac_run[114,102] = -24.9575997948692
    jac_run[114,103] = 10.2713736253513
    jac_run[114,104] = -39.6392229058202
    jac_run[114,105] = -54.0657727682604
    jac_run[114,106] = 105.571769313180
    jac_run[114,107] = 10.2713736253514
    jac_run[114,108] = -39.6392229058201
    jac_run[114,109] = -46.5699289619080
    jac_run[114,110] = 49.9151995897384
    jac_run[114,111] = -20.5427472507027
    jac_run[114,112] = 79.2784458116404
    jac_run[114,113] = 108.131545536521
    jac_run[114,114] = -211.143538626360
    jac_run[114,115] = -20.5427472507027
    jac_run[114,116] = 79.2784458116403
    jac_run[114,117] = 23.2849644809540
    jac_run[114,118] = -24.9575997948692
    jac_run[114,119] = 10.2713736253513
    jac_run[114,120] = -39.6392229058202
    jac_run[114,121] = -54.0657727682604
    jac_run[114,122] = 105.571769313180
    jac_run[114,123] = 10.2713736253514
    jac_run[114,124] = -39.6392229058201
    jac_run[115,101] = -39.6392229058202
    jac_run[115,102] = -10.2713736253513
    jac_run[115,103] = -24.9575997948692
    jac_run[115,104] = -23.2849644809540
    jac_run[115,105] = -39.6392229058202
    jac_run[115,106] = -10.2713736253513
    jac_run[115,107] = 105.571769313180
    jac_run[115,108] = 54.0657727682604
    jac_run[115,109] = 79.2784458116403
    jac_run[115,110] = 20.5427472507027
    jac_run[115,111] = 49.9151995897384
    jac_run[115,112] = 46.5699289619080
    jac_run[115,113] = 79.2784458116403
    jac_run[115,114] = 20.5427472507027
    jac_run[115,115] = -211.143538626360
    jac_run[115,116] = -108.131545536521
    jac_run[115,117] = -39.6392229058202
    jac_run[115,118] = -10.2713736253513
    jac_run[115,119] = -24.9575997948692
    jac_run[115,120] = -23.2849644809540
    jac_run[115,121] = -39.6392229058202
    jac_run[115,122] = -10.2713736253513
    jac_run[115,123] = 105.571769313180
    jac_run[115,124] = 54.0657727682604
    jac_run[116,101] = 10.2713736253513
    jac_run[116,102] = -39.6392229058202
    jac_run[116,103] = 23.2849644809540
    jac_run[116,104] = -24.9575997948692
    jac_run[116,105] = 10.2713736253513
    jac_run[116,106] = -39.6392229058202
    jac_run[116,107] = -54.0657727682604
    jac_run[116,108] = 105.571769313180
    jac_run[116,109] = -20.5427472507027
    jac_run[116,110] = 79.2784458116403
    jac_run[116,111] = -46.5699289619080
    jac_run[116,112] = 49.9151995897384
    jac_run[116,113] = -20.5427472507027
    jac_run[116,114] = 79.2784458116403
    jac_run[116,115] = 108.131545536521
    jac_run[116,116] = -211.143538626360
    jac_run[116,117] = 10.2713736253513
    jac_run[116,118] = -39.6392229058202
    jac_run[116,119] = 23.2849644809540
    jac_run[116,120] = -24.9575997948692
    jac_run[116,121] = 10.2713736253513
    jac_run[116,122] = -39.6392229058202
    jac_run[116,123] = -54.0657727682604
    jac_run[116,124] = 105.571769313180
    jac_run[117,109] = 105.571769313180
    jac_run[117,110] = 54.0657727682604
    jac_run[117,111] = -39.6392229058202
    jac_run[117,112] = -10.2713736253513
    jac_run[117,113] = -24.9575997948692
    jac_run[117,114] = -23.2849644809540
    jac_run[117,115] = -39.6392229058202
    jac_run[117,116] = -10.2713736253513
    jac_run[117,117] = -211.143538626360
    jac_run[117,118] = -108.131545536521
    jac_run[117,119] = 79.2784458116403
    jac_run[117,120] = 20.5427472507027
    jac_run[117,121] = 49.9151995897384
    jac_run[117,122] = 46.5699289619080
    jac_run[117,123] = 79.2784458116403
    jac_run[117,124] = 20.5427472507027
    jac_run[117,125] = 105.571769313180
    jac_run[117,126] = 54.0657727682604
    jac_run[117,127] = -39.6392229058202
    jac_run[117,128] = -10.2713736253513
    jac_run[117,129] = -24.9575997948692
    jac_run[117,130] = -23.2849644809540
    jac_run[117,131] = -39.6392229058202
    jac_run[117,132] = -10.2713736253513
    jac_run[118,109] = -54.0657727682604
    jac_run[118,110] = 105.571769313180
    jac_run[118,111] = 10.2713736253513
    jac_run[118,112] = -39.6392229058202
    jac_run[118,113] = 23.2849644809540
    jac_run[118,114] = -24.9575997948692
    jac_run[118,115] = 10.2713736253513
    jac_run[118,116] = -39.6392229058202
    jac_run[118,117] = 108.131545536521
    jac_run[118,118] = -211.143538626360
    jac_run[118,119] = -20.5427472507027
    jac_run[118,120] = 79.2784458116403
    jac_run[118,121] = -46.5699289619080
    jac_run[118,122] = 49.9151995897384
    jac_run[118,123] = -20.5427472507027
    jac_run[118,124] = 79.2784458116403
    jac_run[118,125] = -54.0657727682604
    jac_run[118,126] = 105.571769313180
    jac_run[118,127] = 10.2713736253513
    jac_run[118,128] = -39.6392229058202
    jac_run[118,129] = 23.2849644809540
    jac_run[118,130] = -24.9575997948692
    jac_run[118,131] = 10.2713736253513
    jac_run[118,132] = -39.6392229058202
    jac_run[119,109] = -39.6392229058202
    jac_run[119,110] = -10.2713736253513
    jac_run[119,111] = 105.571769313180
    jac_run[119,112] = 54.0657727682604
    jac_run[119,113] = -39.6392229058201
    jac_run[119,114] = -10.2713736253513
    jac_run[119,115] = -24.9575997948692
    jac_run[119,116] = -23.2849644809540
    jac_run[119,117] = 79.2784458116403
    jac_run[119,118] = 20.5427472507027
    jac_run[119,119] = -211.143538626360
    jac_run[119,120] = -108.131545536521
    jac_run[119,121] = 79.2784458116403
    jac_run[119,122] = 20.5427472507027
    jac_run[119,123] = 49.9151995897384
    jac_run[119,124] = 46.5699289619080
    jac_run[119,125] = -39.6392229058202
    jac_run[119,126] = -10.2713736253513
    jac_run[119,127] = 105.571769313180
    jac_run[119,128] = 54.0657727682604
    jac_run[119,129] = -39.6392229058201
    jac_run[119,130] = -10.2713736253513
    jac_run[119,131] = -24.9575997948692
    jac_run[119,132] = -23.2849644809540
    jac_run[120,109] = 10.2713736253513
    jac_run[120,110] = -39.6392229058202
    jac_run[120,111] = -54.0657727682604
    jac_run[120,112] = 105.571769313180
    jac_run[120,113] = 10.2713736253513
    jac_run[120,114] = -39.6392229058201
    jac_run[120,115] = 23.2849644809540
    jac_run[120,116] = -24.9575997948692
    jac_run[120,117] = -20.5427472507027
    jac_run[120,118] = 79.2784458116403
    jac_run[120,119] = 108.131545536521
    jac_run[120,120] = -211.143538626360
    jac_run[120,121] = -20.5427472507027
    jac_run[120,122] = 79.2784458116403
    jac_run[120,123] = -46.5699289619080
    jac_run[120,124] = 49.9151995897384
    jac_run[120,125] = 10.2713736253513
    jac_run[120,126] = -39.6392229058202
    jac_run[120,127] = -54.0657727682604
    jac_run[120,128] = 105.571769313180
    jac_run[120,129] = 10.2713736253513
    jac_run[120,130] = -39.6392229058201
    jac_run[120,131] = 23.2849644809540
    jac_run[120,132] = -24.9575997948692
    jac_run[121,109] = -24.9575997948692
    jac_run[121,110] = -23.2849644809540
    jac_run[121,111] = -39.6392229058202
    jac_run[121,112] = -10.2713736253513
    jac_run[121,113] = 105.571769313180
    jac_run[121,114] = 54.0657727682604
    jac_run[121,115] = -39.6392229058201
    jac_run[121,116] = -10.2713736253514
    jac_run[121,117] = 49.9151995897384
    jac_run[121,118] = 46.5699289619080
    jac_run[121,119] = 79.2784458116404
    jac_run[121,120] = 20.5427472507027
    jac_run[121,121] = -211.143538626360
    jac_run[121,122] = -108.131545536521
    jac_run[121,123] = 79.2784458116403
    jac_run[121,124] = 20.5427472507027
    jac_run[121,125] = -24.9575997948692
    jac_run[121,126] = -23.2849644809540
    jac_run[121,127] = -39.6392229058202
    jac_run[121,128] = -10.2713736253513
    jac_run[121,129] = 105.571769313180
    jac_run[121,130] = 54.0657727682604
    jac_run[121,131] = -39.6392229058201
    jac_run[121,132] = -10.2713736253514
    jac_run[122,109] = 23.2849644809540
    jac_run[122,110] = -24.9575997948692
    jac_run[122,111] = 10.2713736253513
    jac_run[122,112] = -39.6392229058202
    jac_run[122,113] = -54.0657727682604
    jac_run[122,114] = 105.571769313180
    jac_run[122,115] = 10.2713736253514
    jac_run[122,116] = -39.6392229058201
    jac_run[122,117] = -46.5699289619080
    jac_run[122,118] = 49.9151995897384
    jac_run[122,119] = -20.5427472507027
    jac_run[122,120] = 79.2784458116404
    jac_run[122,121] = 108.131545536521
    jac_run[122,122] = -211.143538626360
    jac_run[122,123] = -20.5427472507027
    jac_run[122,124] = 79.2784458116403
    jac_run[122,125] = 23.2849644809540
    jac_run[122,126] = -24.9575997948692
    jac_run[122,127] = 10.2713736253513
    jac_run[122,128] = -39.6392229058202
    jac_run[122,129] = -54.0657727682604
    jac_run[122,130] = 105.571769313180
    jac_run[122,131] = 10.2713736253514
    jac_run[122,132] = -39.6392229058201
    jac_run[123,109] = -39.6392229058202
    jac_run[123,110] = -10.2713736253513
    jac_run[123,111] = -24.9575997948692
    jac_run[123,112] = -23.2849644809540
    jac_run[123,113] = -39.6392229058202
    jac_run[123,114] = -10.2713736253513
    jac_run[123,115] = 105.571769313180
    jac_run[123,116] = 54.0657727682604
    jac_run[123,117] = 79.2784458116403
    jac_run[123,118] = 20.5427472507027
    jac_run[123,119] = 49.9151995897384
    jac_run[123,120] = 46.5699289619080
    jac_run[123,121] = 79.2784458116403
    jac_run[123,122] = 20.5427472507027
    jac_run[123,123] = -211.168538626360
    jac_run[123,124] = -108.131545536521
    jac_run[123,125] = -39.6392229058202
    jac_run[123,126] = -10.2713736253513
    jac_run[123,127] = -24.9575997948692
    jac_run[123,128] = -23.2849644809540
    jac_run[123,129] = -39.6392229058202
    jac_run[123,130] = -10.2713736253513
    jac_run[123,131] = 105.571769313180
    jac_run[123,132] = 54.0657727682604
    jac_run[124,109] = 10.2713736253513
    jac_run[124,110] = -39.6392229058202
    jac_run[124,111] = 23.2849644809540
    jac_run[124,112] = -24.9575997948692
    jac_run[124,113] = 10.2713736253513
    jac_run[124,114] = -39.6392229058202
    jac_run[124,115] = -54.0657727682604
    jac_run[124,116] = 105.571769313180
    jac_run[124,117] = -20.5427472507027
    jac_run[124,118] = 79.2784458116403
    jac_run[124,119] = -46.5699289619080
    jac_run[124,120] = 49.9151995897384
    jac_run[124,121] = -20.5427472507027
    jac_run[124,122] = 79.2784458116403
    jac_run[124,123] = 108.131545536521
    jac_run[124,124] = -211.168538626360
    jac_run[124,125] = 10.2713736253513
    jac_run[124,126] = -39.6392229058202
    jac_run[124,127] = 23.2849644809540
    jac_run[124,128] = -24.9575997948692
    jac_run[124,129] = 10.2713736253513
    jac_run[124,130] = -39.6392229058202
    jac_run[124,131] = -54.0657727682604
    jac_run[124,132] = 105.571769313180
    jac_run[125,33] = 30.9517475172273
    jac_run[125,34] = 5.65456401516768
    jac_run[125,35] = -9.21038227100566
    jac_run[125,36] = 1.84896616921897
    jac_run[125,37] = -9.00835072044485
    jac_run[125,38] = 0.793238195499529
    jac_run[125,39] = -9.21038227100566
    jac_run[125,40] = 1.84896616921897
    jac_run[125,117] = 105.571769313180
    jac_run[125,118] = 54.0657727682604
    jac_run[125,119] = -39.6392229058202
    jac_run[125,120] = -10.2713736253513
    jac_run[125,121] = -24.9575997948692
    jac_run[125,122] = -23.2849644809540
    jac_run[125,123] = -39.6392229058202
    jac_run[125,124] = -10.2713736253513
    jac_run[125,125] = -242.095286143588
    jac_run[125,126] = -113.786109551688
    jac_run[125,127] = 88.4888280826460
    jac_run[125,128] = 18.6937810814837
    jac_run[125,129] = 58.9235503101833
    jac_run[125,130] = 45.7766907664085
    jac_run[125,131] = 88.4888280826460
    jac_run[125,132] = 18.6937810814837
    jac_run[125,133] = 105.571769313180
    jac_run[125,134] = 54.0657727682604
    jac_run[125,135] = -39.6392229058202
    jac_run[125,136] = -10.2713736253513
    jac_run[125,137] = -24.9575997948692
    jac_run[125,138] = -23.2849644809540
    jac_run[125,139] = -39.6392229058202
    jac_run[125,140] = -10.2713736253513
    jac_run[126,33] = -5.65456401516768
    jac_run[126,34] = 30.9517475172273
    jac_run[126,35] = -1.84896616921897
    jac_run[126,36] = -9.21038227100566
    jac_run[126,37] = -0.793238195499529
    jac_run[126,38] = -9.00835072044485
    jac_run[126,39] = -1.84896616921897
    jac_run[126,40] = -9.21038227100566
    jac_run[126,117] = -54.0657727682604
    jac_run[126,118] = 105.571769313180
    jac_run[126,119] = 10.2713736253513
    jac_run[126,120] = -39.6392229058202
    jac_run[126,121] = 23.2849644809540
    jac_run[126,122] = -24.9575997948692
    jac_run[126,123] = 10.2713736253513
    jac_run[126,124] = -39.6392229058202
    jac_run[126,125] = 113.786109551688
    jac_run[126,126] = -242.095286143588
    jac_run[126,127] = -18.6937810814837
    jac_run[126,128] = 88.4888280826460
    jac_run[126,129] = -45.7766907664085
    jac_run[126,130] = 58.9235503101833
    jac_run[126,131] = -18.6937810814837
    jac_run[126,132] = 88.4888280826460
    jac_run[126,133] = -54.0657727682604
    jac_run[126,134] = 105.571769313180
    jac_run[126,135] = 10.2713736253513
    jac_run[126,136] = -39.6392229058202
    jac_run[126,137] = 23.2849644809540
    jac_run[126,138] = -24.9575997948692
    jac_run[126,139] = 10.2713736253513
    jac_run[126,140] = -39.6392229058202
    jac_run[127,33] = -9.21038227100566
    jac_run[127,34] = 1.84896616921897
    jac_run[127,35] = 30.9517475172273
    jac_run[127,36] = 5.65456401516768
    jac_run[127,37] = -9.21038227100566
    jac_run[127,38] = 1.84896616921897
    jac_run[127,39] = -9.00835072044485
    jac_run[127,40] = 0.793238195499528
    jac_run[127,117] = -39.6392229058202
    jac_run[127,118] = -10.2713736253513
    jac_run[127,119] = 105.571769313180
    jac_run[127,120] = 54.0657727682604
    jac_run[127,121] = -39.6392229058201
    jac_run[127,122] = -10.2713736253513
    jac_run[127,123] = -24.9575997948692
    jac_run[127,124] = -23.2849644809540
    jac_run[127,125] = 88.4888280826460
    jac_run[127,126] = 18.6937810814837
    jac_run[127,127] = -242.095286143588
    jac_run[127,128] = -113.786109551688
    jac_run[127,129] = 88.4888280826460
    jac_run[127,130] = 18.6937810814837
    jac_run[127,131] = 58.9235503101833
    jac_run[127,132] = 45.7766907664085
    jac_run[127,133] = -39.6392229058202
    jac_run[127,134] = -10.2713736253513
    jac_run[127,135] = 105.571769313180
    jac_run[127,136] = 54.0657727682604
    jac_run[127,137] = -39.6392229058201
    jac_run[127,138] = -10.2713736253513
    jac_run[127,139] = -24.9575997948692
    jac_run[127,140] = -23.2849644809540
    jac_run[128,33] = -1.84896616921897
    jac_run[128,34] = -9.21038227100566
    jac_run[128,35] = -5.65456401516768
    jac_run[128,36] = 30.9517475172273
    jac_run[128,37] = -1.84896616921897
    jac_run[128,38] = -9.21038227100566
    jac_run[128,39] = -0.793238195499528
    jac_run[128,40] = -9.00835072044485
    jac_run[128,117] = 10.2713736253513
    jac_run[128,118] = -39.6392229058202
    jac_run[128,119] = -54.0657727682604
    jac_run[128,120] = 105.571769313180
    jac_run[128,121] = 10.2713736253513
    jac_run[128,122] = -39.6392229058201
    jac_run[128,123] = 23.2849644809540
    jac_run[128,124] = -24.9575997948692
    jac_run[128,125] = -18.6937810814837
    jac_run[128,126] = 88.4888280826460
    jac_run[128,127] = 113.786109551688
    jac_run[128,128] = -242.095286143588
    jac_run[128,129] = -18.6937810814837
    jac_run[128,130] = 88.4888280826460
    jac_run[128,131] = -45.7766907664085
    jac_run[128,132] = 58.9235503101833
    jac_run[128,133] = 10.2713736253513
    jac_run[128,134] = -39.6392229058202
    jac_run[128,135] = -54.0657727682604
    jac_run[128,136] = 105.571769313180
    jac_run[128,137] = 10.2713736253513
    jac_run[128,138] = -39.6392229058201
    jac_run[128,139] = 23.2849644809540
    jac_run[128,140] = -24.9575997948692
    jac_run[129,33] = -9.00835072044484
    jac_run[129,34] = 0.793238195499527
    jac_run[129,35] = -9.21038227100566
    jac_run[129,36] = 1.84896616921897
    jac_run[129,37] = 30.9517475172273
    jac_run[129,38] = 5.65456401516768
    jac_run[129,39] = -9.21038227100566
    jac_run[129,40] = 1.84896616921897
    jac_run[129,117] = -24.9575997948692
    jac_run[129,118] = -23.2849644809540
    jac_run[129,119] = -39.6392229058202
    jac_run[129,120] = -10.2713736253513
    jac_run[129,121] = 105.571769313180
    jac_run[129,122] = 54.0657727682604
    jac_run[129,123] = -39.6392229058201
    jac_run[129,124] = -10.2713736253514
    jac_run[129,125] = 58.9235503101833
    jac_run[129,126] = 45.7766907664085
    jac_run[129,127] = 88.4888280826461
    jac_run[129,128] = 18.6937810814837
    jac_run[129,129] = -242.095286143588
    jac_run[129,130] = -113.786109551688
    jac_run[129,131] = 88.4888280826459
    jac_run[129,132] = 18.6937810814837
    jac_run[129,133] = -24.9575997948692
    jac_run[129,134] = -23.2849644809540
    jac_run[129,135] = -39.6392229058202
    jac_run[129,136] = -10.2713736253513
    jac_run[129,137] = 105.571769313180
    jac_run[129,138] = 54.0657727682604
    jac_run[129,139] = -39.6392229058201
    jac_run[129,140] = -10.2713736253514
    jac_run[130,33] = -0.793238195499527
    jac_run[130,34] = -9.00835072044484
    jac_run[130,35] = -1.84896616921897
    jac_run[130,36] = -9.21038227100566
    jac_run[130,37] = -5.65456401516768
    jac_run[130,38] = 30.9517475172273
    jac_run[130,39] = -1.84896616921897
    jac_run[130,40] = -9.21038227100566
    jac_run[130,117] = 23.2849644809540
    jac_run[130,118] = -24.9575997948692
    jac_run[130,119] = 10.2713736253513
    jac_run[130,120] = -39.6392229058202
    jac_run[130,121] = -54.0657727682604
    jac_run[130,122] = 105.571769313180
    jac_run[130,123] = 10.2713736253514
    jac_run[130,124] = -39.6392229058201
    jac_run[130,125] = -45.7766907664085
    jac_run[130,126] = 58.9235503101833
    jac_run[130,127] = -18.6937810814837
    jac_run[130,128] = 88.4888280826461
    jac_run[130,129] = 113.786109551688
    jac_run[130,130] = -242.095286143588
    jac_run[130,131] = -18.6937810814837
    jac_run[130,132] = 88.4888280826459
    jac_run[130,133] = 23.2849644809540
    jac_run[130,134] = -24.9575997948692
    jac_run[130,135] = 10.2713736253513
    jac_run[130,136] = -39.6392229058202
    jac_run[130,137] = -54.0657727682604
    jac_run[130,138] = 105.571769313180
    jac_run[130,139] = 10.2713736253514
    jac_run[130,140] = -39.6392229058201
    jac_run[131,33] = -9.21038227100566
    jac_run[131,34] = 1.84896616921897
    jac_run[131,35] = -9.00835072044485
    jac_run[131,36] = 0.793238195499527
    jac_run[131,37] = -9.21038227100566
    jac_run[131,38] = 1.84896616921897
    jac_run[131,39] = 30.9517475172273
    jac_run[131,40] = 5.65456401516768
    jac_run[131,117] = -39.6392229058202
    jac_run[131,118] = -10.2713736253513
    jac_run[131,119] = -24.9575997948692
    jac_run[131,120] = -23.2849644809540
    jac_run[131,121] = -39.6392229058202
    jac_run[131,122] = -10.2713736253513
    jac_run[131,123] = 105.571769313180
    jac_run[131,124] = 54.0657727682604
    jac_run[131,125] = 88.4888280826460
    jac_run[131,126] = 18.6937810814837
    jac_run[131,127] = 58.9235503101832
    jac_run[131,128] = 45.7766907664085
    jac_run[131,129] = 88.4888280826460
    jac_run[131,130] = 18.6937810814837
    jac_run[131,131] = -242.095286143588
    jac_run[131,132] = -113.786109551688
    jac_run[131,133] = -39.6392229058202
    jac_run[131,134] = -10.2713736253513
    jac_run[131,135] = -24.9575997948692
    jac_run[131,136] = -23.2849644809540
    jac_run[131,137] = -39.6392229058202
    jac_run[131,138] = -10.2713736253513
    jac_run[131,139] = 105.571769313180
    jac_run[131,140] = 54.0657727682604
    jac_run[132,33] = -1.84896616921897
    jac_run[132,34] = -9.21038227100566
    jac_run[132,35] = -0.793238195499527
    jac_run[132,36] = -9.00835072044485
    jac_run[132,37] = -1.84896616921897
    jac_run[132,38] = -9.21038227100566
    jac_run[132,39] = -5.65456401516768
    jac_run[132,40] = 30.9517475172273
    jac_run[132,117] = 10.2713736253513
    jac_run[132,118] = -39.6392229058202
    jac_run[132,119] = 23.2849644809540
    jac_run[132,120] = -24.9575997948692
    jac_run[132,121] = 10.2713736253513
    jac_run[132,122] = -39.6392229058202
    jac_run[132,123] = -54.0657727682604
    jac_run[132,124] = 105.571769313180
    jac_run[132,125] = -18.6937810814837
    jac_run[132,126] = 88.4888280826460
    jac_run[132,127] = -45.7766907664085
    jac_run[132,128] = 58.9235503101832
    jac_run[132,129] = -18.6937810814837
    jac_run[132,130] = 88.4888280826460
    jac_run[132,131] = 113.786109551688
    jac_run[132,132] = -242.095286143588
    jac_run[132,133] = 10.2713736253513
    jac_run[132,134] = -39.6392229058202
    jac_run[132,135] = 23.2849644809540
    jac_run[132,136] = -24.9575997948692
    jac_run[132,137] = 10.2713736253513
    jac_run[132,138] = -39.6392229058202
    jac_run[132,139] = -54.0657727682604
    jac_run[132,140] = 105.571769313180
    jac_run[133,41] = 30.9517475172273
    jac_run[133,42] = 5.65456401516768
    jac_run[133,43] = -9.21038227100566
    jac_run[133,44] = 1.84896616921897
    jac_run[133,45] = -9.00835072044485
    jac_run[133,46] = 0.793238195499529
    jac_run[133,47] = -9.21038227100566
    jac_run[133,48] = 1.84896616921897
    jac_run[133,125] = 105.571769313180
    jac_run[133,126] = 54.0657727682604
    jac_run[133,127] = -39.6392229058202
    jac_run[133,128] = -10.2713736253513
    jac_run[133,129] = -24.9575997948692
    jac_run[133,130] = -23.2849644809540
    jac_run[133,131] = -39.6392229058202
    jac_run[133,132] = -10.2713736253513
    jac_run[133,133] = -136.523516830407
    jac_run[133,134] = -59.7203367834281
    jac_run[133,135] = 48.8496051768258
    jac_run[133,136] = 8.42240745613237
    jac_run[133,137] = 33.9659505153141
    jac_run[133,138] = 22.4917262854545
    jac_run[133,139] = 48.8496051768258
    jac_run[133,140] = 8.42240745613237
    jac_run[133,414] = 1
    jac_run[134,41] = -5.65456401516768
    jac_run[134,42] = 30.9517475172273
    jac_run[134,43] = -1.84896616921897
    jac_run[134,44] = -9.21038227100566
    jac_run[134,45] = -0.793238195499529
    jac_run[134,46] = -9.00835072044485
    jac_run[134,47] = -1.84896616921897
    jac_run[134,48] = -9.21038227100566
    jac_run[134,125] = -54.0657727682604
    jac_run[134,126] = 105.571769313180
    jac_run[134,127] = 10.2713736253513
    jac_run[134,128] = -39.6392229058202
    jac_run[134,129] = 23.2849644809540
    jac_run[134,130] = -24.9575997948692
    jac_run[134,131] = 10.2713736253513
    jac_run[134,132] = -39.6392229058202
    jac_run[134,133] = 59.7203367834281
    jac_run[134,134] = -136.523516830407
    jac_run[134,135] = -8.42240745613237
    jac_run[134,136] = 48.8496051768258
    jac_run[134,137] = -22.4917262854545
    jac_run[134,138] = 33.9659505153141
    jac_run[134,139] = -8.42240745613237
    jac_run[134,140] = 48.8496051768258
    jac_run[134,415] = 1
    jac_run[135,41] = -9.21038227100566
    jac_run[135,42] = 1.84896616921897
    jac_run[135,43] = 30.9517475172273
    jac_run[135,44] = 5.65456401516768
    jac_run[135,45] = -9.21038227100566
    jac_run[135,46] = 1.84896616921897
    jac_run[135,47] = -9.00835072044485
    jac_run[135,48] = 0.793238195499528
    jac_run[135,125] = -39.6392229058202
    jac_run[135,126] = -10.2713736253513
    jac_run[135,127] = 105.571769313180
    jac_run[135,128] = 54.0657727682604
    jac_run[135,129] = -39.6392229058201
    jac_run[135,130] = -10.2713736253513
    jac_run[135,131] = -24.9575997948692
    jac_run[135,132] = -23.2849644809540
    jac_run[135,133] = 48.8496051768258
    jac_run[135,134] = 8.42240745613237
    jac_run[135,135] = -136.523516830407
    jac_run[135,136] = -59.7203367834280
    jac_run[135,137] = 48.8496051768258
    jac_run[135,138] = 8.42240745613238
    jac_run[135,139] = 33.9659505153141
    jac_run[135,140] = 22.4917262854545
    jac_run[135,416] = 1
    jac_run[136,41] = -1.84896616921897
    jac_run[136,42] = -9.21038227100566
    jac_run[136,43] = -5.65456401516768
    jac_run[136,44] = 30.9517475172273
    jac_run[136,45] = -1.84896616921897
    jac_run[136,46] = -9.21038227100566
    jac_run[136,47] = -0.793238195499528
    jac_run[136,48] = -9.00835072044485
    jac_run[136,125] = 10.2713736253513
    jac_run[136,126] = -39.6392229058202
    jac_run[136,127] = -54.0657727682604
    jac_run[136,128] = 105.571769313180
    jac_run[136,129] = 10.2713736253513
    jac_run[136,130] = -39.6392229058201
    jac_run[136,131] = 23.2849644809540
    jac_run[136,132] = -24.9575997948692
    jac_run[136,133] = -8.42240745613237
    jac_run[136,134] = 48.8496051768258
    jac_run[136,135] = 59.7203367834280
    jac_run[136,136] = -136.523516830407
    jac_run[136,137] = -8.42240745613238
    jac_run[136,138] = 48.8496051768258
    jac_run[136,139] = -22.4917262854545
    jac_run[136,140] = 33.9659505153141
    jac_run[136,417] = 1
    jac_run[137,41] = -9.00835072044484
    jac_run[137,42] = 0.793238195499527
    jac_run[137,43] = -9.21038227100566
    jac_run[137,44] = 1.84896616921897
    jac_run[137,45] = 30.9517475172273
    jac_run[137,46] = 5.65456401516768
    jac_run[137,47] = -9.21038227100566
    jac_run[137,48] = 1.84896616921897
    jac_run[137,125] = -24.9575997948692
    jac_run[137,126] = -23.2849644809540
    jac_run[137,127] = -39.6392229058202
    jac_run[137,128] = -10.2713736253513
    jac_run[137,129] = 105.571769313180
    jac_run[137,130] = 54.0657727682604
    jac_run[137,131] = -39.6392229058201
    jac_run[137,132] = -10.2713736253514
    jac_run[137,133] = 33.9659505153141
    jac_run[137,134] = 22.4917262854545
    jac_run[137,135] = 48.8496051768259
    jac_run[137,136] = 8.42240745613236
    jac_run[137,137] = -136.523516830407
    jac_run[137,138] = -59.7203367834281
    jac_run[137,139] = 48.8496051768258
    jac_run[137,140] = 8.42240745613239
    jac_run[137,418] = 1
    jac_run[138,41] = -0.793238195499527
    jac_run[138,42] = -9.00835072044484
    jac_run[138,43] = -1.84896616921897
    jac_run[138,44] = -9.21038227100566
    jac_run[138,45] = -5.65456401516768
    jac_run[138,46] = 30.9517475172273
    jac_run[138,47] = -1.84896616921897
    jac_run[138,48] = -9.21038227100566
    jac_run[138,125] = 23.2849644809540
    jac_run[138,126] = -24.9575997948692
    jac_run[138,127] = 10.2713736253513
    jac_run[138,128] = -39.6392229058202
    jac_run[138,129] = -54.0657727682604
    jac_run[138,130] = 105.571769313180
    jac_run[138,131] = 10.2713736253514
    jac_run[138,132] = -39.6392229058201
    jac_run[138,133] = -22.4917262854545
    jac_run[138,134] = 33.9659505153141
    jac_run[138,135] = -8.42240745613236
    jac_run[138,136] = 48.8496051768259
    jac_run[138,137] = 59.7203367834281
    jac_run[138,138] = -136.523516830407
    jac_run[138,139] = -8.42240745613239
    jac_run[138,140] = 48.8496051768258
    jac_run[138,419] = 1
    jac_run[139,41] = -9.21038227100566
    jac_run[139,42] = 1.84896616921897
    jac_run[139,43] = -9.00835072044485
    jac_run[139,44] = 0.793238195499527
    jac_run[139,45] = -9.21038227100566
    jac_run[139,46] = 1.84896616921897
    jac_run[139,47] = 30.9517475172273
    jac_run[139,48] = 5.65456401516768
    jac_run[139,125] = -39.6392229058202
    jac_run[139,126] = -10.2713736253513
    jac_run[139,127] = -24.9575997948692
    jac_run[139,128] = -23.2849644809540
    jac_run[139,129] = -39.6392229058202
    jac_run[139,130] = -10.2713736253513
    jac_run[139,131] = 105.571769313180
    jac_run[139,132] = 54.0657727682604
    jac_run[139,133] = 48.8496051768258
    jac_run[139,134] = 8.42240745613237
    jac_run[139,135] = 33.9659505153140
    jac_run[139,136] = 22.4917262854545
    jac_run[139,137] = 48.8496051768258
    jac_run[139,138] = 8.42240745613237
    jac_run[139,139] = -136.548516830407
    jac_run[139,140] = -59.7203367834281
    jac_run[140,41] = -1.84896616921897
    jac_run[140,42] = -9.21038227100566
    jac_run[140,43] = -0.793238195499527
    jac_run[140,44] = -9.00835072044485
    jac_run[140,45] = -1.84896616921897
    jac_run[140,46] = -9.21038227100566
    jac_run[140,47] = -5.65456401516768
    jac_run[140,48] = 30.9517475172273
    jac_run[140,125] = 10.2713736253513
    jac_run[140,126] = -39.6392229058202
    jac_run[140,127] = 23.2849644809540
    jac_run[140,128] = -24.9575997948692
    jac_run[140,129] = 10.2713736253513
    jac_run[140,130] = -39.6392229058202
    jac_run[140,131] = -54.0657727682604
    jac_run[140,132] = 105.571769313180
    jac_run[140,133] = -8.42240745613237
    jac_run[140,134] = 48.8496051768258
    jac_run[140,135] = -22.4917262854545
    jac_run[140,136] = 33.9659505153140
    jac_run[140,137] = -8.42240745613237
    jac_run[140,138] = 48.8496051768258
    jac_run[140,139] = 59.7203367834281
    jac_run[140,140] = -136.548516830407
    jac_run[141,85] = 26.5300693004806
    jac_run[141,86] = 4.84676915585801
    jac_run[141,87] = -7.89461337514770
    jac_run[141,88] = 1.58482814504483
    jac_run[141,89] = -7.72144347466701
    jac_run[141,90] = 0.679918453285310
    jac_run[141,91] = -7.89461337514771
    jac_run[141,92] = 1.58482814504483
    jac_run[141,141] = -53.0601386009611
    jac_run[141,142] = -9.69353831171601
    jac_run[141,143] = 15.7892267502954
    jac_run[141,144] = -3.16965629008966
    jac_run[141,145] = 15.4428869493340
    jac_run[141,146] = -1.35983690657062
    jac_run[141,147] = 15.7892267502954
    jac_run[141,148] = -3.16965629008966
    jac_run[141,149] = 26.5300693004806
    jac_run[141,150] = 4.84676915585801
    jac_run[141,151] = -7.89461337514770
    jac_run[141,152] = 1.58482814504483
    jac_run[141,153] = -7.72144347466701
    jac_run[141,154] = 0.679918453285310
    jac_run[141,155] = -7.89461337514771
    jac_run[141,156] = 1.58482814504483
    jac_run[142,85] = -4.84676915585801
    jac_run[142,86] = 26.5300693004806
    jac_run[142,87] = -1.58482814504483
    jac_run[142,88] = -7.89461337514770
    jac_run[142,89] = -0.679918453285310
    jac_run[142,90] = -7.72144347466701
    jac_run[142,91] = -1.58482814504483
    jac_run[142,92] = -7.89461337514771
    jac_run[142,141] = 9.69353831171601
    jac_run[142,142] = -53.0601386009611
    jac_run[142,143] = 3.16965629008966
    jac_run[142,144] = 15.7892267502954
    jac_run[142,145] = 1.35983690657062
    jac_run[142,146] = 15.4428869493340
    jac_run[142,147] = 3.16965629008966
    jac_run[142,148] = 15.7892267502954
    jac_run[142,149] = -4.84676915585801
    jac_run[142,150] = 26.5300693004806
    jac_run[142,151] = -1.58482814504483
    jac_run[142,152] = -7.89461337514770
    jac_run[142,153] = -0.679918453285310
    jac_run[142,154] = -7.72144347466701
    jac_run[142,155] = -1.58482814504483
    jac_run[142,156] = -7.89461337514771
    jac_run[143,85] = -7.89461337514771
    jac_run[143,86] = 1.58482814504483
    jac_run[143,87] = 26.5300693004806
    jac_run[143,88] = 4.84676915585801
    jac_run[143,89] = -7.89461337514771
    jac_run[143,90] = 1.58482814504483
    jac_run[143,91] = -7.72144347466701
    jac_run[143,92] = 0.679918453285308
    jac_run[143,141] = 15.7892267502954
    jac_run[143,142] = -3.16965629008966
    jac_run[143,143] = -53.0601386009611
    jac_run[143,144] = -9.69353831171602
    jac_run[143,145] = 15.7892267502954
    jac_run[143,146] = -3.16965629008967
    jac_run[143,147] = 15.4428869493340
    jac_run[143,148] = -1.35983690657062
    jac_run[143,149] = -7.89461337514771
    jac_run[143,150] = 1.58482814504483
    jac_run[143,151] = 26.5300693004806
    jac_run[143,152] = 4.84676915585801
    jac_run[143,153] = -7.89461337514771
    jac_run[143,154] = 1.58482814504483
    jac_run[143,155] = -7.72144347466701
    jac_run[143,156] = 0.679918453285308
    jac_run[144,85] = -1.58482814504483
    jac_run[144,86] = -7.89461337514771
    jac_run[144,87] = -4.84676915585801
    jac_run[144,88] = 26.5300693004806
    jac_run[144,89] = -1.58482814504483
    jac_run[144,90] = -7.89461337514771
    jac_run[144,91] = -0.679918453285308
    jac_run[144,92] = -7.72144347466701
    jac_run[144,141] = 3.16965629008966
    jac_run[144,142] = 15.7892267502954
    jac_run[144,143] = 9.69353831171602
    jac_run[144,144] = -53.0601386009611
    jac_run[144,145] = 3.16965629008967
    jac_run[144,146] = 15.7892267502954
    jac_run[144,147] = 1.35983690657062
    jac_run[144,148] = 15.4428869493340
    jac_run[144,149] = -1.58482814504483
    jac_run[144,150] = -7.89461337514771
    jac_run[144,151] = -4.84676915585801
    jac_run[144,152] = 26.5300693004806
    jac_run[144,153] = -1.58482814504483
    jac_run[144,154] = -7.89461337514771
    jac_run[144,155] = -0.679918453285308
    jac_run[144,156] = -7.72144347466701
    jac_run[145,85] = -7.72144347466701
    jac_run[145,86] = 0.679918453285310
    jac_run[145,87] = -7.89461337514770
    jac_run[145,88] = 1.58482814504483
    jac_run[145,89] = 26.5300693004806
    jac_run[145,90] = 4.84676915585801
    jac_run[145,91] = -7.89461337514771
    jac_run[145,92] = 1.58482814504483
    jac_run[145,141] = 15.4428869493340
    jac_run[145,142] = -1.35983690657062
    jac_run[145,143] = 15.7892267502954
    jac_run[145,144] = -3.16965629008966
    jac_run[145,145] = -53.0601386009611
    jac_run[145,146] = -9.69353831171602
    jac_run[145,147] = 15.7892267502954
    jac_run[145,148] = -3.16965629008967
    jac_run[145,149] = -7.72144347466701
    jac_run[145,150] = 0.679918453285310
    jac_run[145,151] = -7.89461337514770
    jac_run[145,152] = 1.58482814504483
    jac_run[145,153] = 26.5300693004806
    jac_run[145,154] = 4.84676915585801
    jac_run[145,155] = -7.89461337514771
    jac_run[145,156] = 1.58482814504483
    jac_run[146,85] = -0.679918453285310
    jac_run[146,86] = -7.72144347466701
    jac_run[146,87] = -1.58482814504483
    jac_run[146,88] = -7.89461337514770
    jac_run[146,89] = -4.84676915585801
    jac_run[146,90] = 26.5300693004806
    jac_run[146,91] = -1.58482814504483
    jac_run[146,92] = -7.89461337514771
    jac_run[146,141] = 1.35983690657062
    jac_run[146,142] = 15.4428869493340
    jac_run[146,143] = 3.16965629008966
    jac_run[146,144] = 15.7892267502954
    jac_run[146,145] = 9.69353831171602
    jac_run[146,146] = -53.0601386009611
    jac_run[146,147] = 3.16965629008967
    jac_run[146,148] = 15.7892267502954
    jac_run[146,149] = -0.679918453285310
    jac_run[146,150] = -7.72144347466701
    jac_run[146,151] = -1.58482814504483
    jac_run[146,152] = -7.89461337514770
    jac_run[146,153] = -4.84676915585801
    jac_run[146,154] = 26.5300693004806
    jac_run[146,155] = -1.58482814504483
    jac_run[146,156] = -7.89461337514771
    jac_run[147,85] = -7.89461337514771
    jac_run[147,86] = 1.58482814504483
    jac_run[147,87] = -7.72144347466701
    jac_run[147,88] = 0.679918453285308
    jac_run[147,89] = -7.89461337514771
    jac_run[147,90] = 1.58482814504483
    jac_run[147,91] = 26.5300693004806
    jac_run[147,92] = 4.84676915585801
    jac_run[147,141] = 15.7892267502954
    jac_run[147,142] = -3.16965629008966
    jac_run[147,143] = 15.4428869493340
    jac_run[147,144] = -1.35983690657062
    jac_run[147,145] = 15.7892267502954
    jac_run[147,146] = -3.16965629008966
    jac_run[147,147] = -53.0601386009611
    jac_run[147,148] = -9.69353831171602
    jac_run[147,149] = -7.89461337514771
    jac_run[147,150] = 1.58482814504483
    jac_run[147,151] = -7.72144347466701
    jac_run[147,152] = 0.679918453285308
    jac_run[147,153] = -7.89461337514771
    jac_run[147,154] = 1.58482814504483
    jac_run[147,155] = 26.5300693004806
    jac_run[147,156] = 4.84676915585801
    jac_run[148,85] = -1.58482814504483
    jac_run[148,86] = -7.89461337514771
    jac_run[148,87] = -0.679918453285308
    jac_run[148,88] = -7.72144347466701
    jac_run[148,89] = -1.58482814504483
    jac_run[148,90] = -7.89461337514771
    jac_run[148,91] = -4.84676915585801
    jac_run[148,92] = 26.5300693004806
    jac_run[148,141] = 3.16965629008966
    jac_run[148,142] = 15.7892267502954
    jac_run[148,143] = 1.35983690657062
    jac_run[148,144] = 15.4428869493340
    jac_run[148,145] = 3.16965629008966
    jac_run[148,146] = 15.7892267502954
    jac_run[148,147] = 9.69353831171602
    jac_run[148,148] = -53.0601386009611
    jac_run[148,149] = -1.58482814504483
    jac_run[148,150] = -7.89461337514771
    jac_run[148,151] = -0.679918453285308
    jac_run[148,152] = -7.72144347466701
    jac_run[148,153] = -1.58482814504483
    jac_run[148,154] = -7.89461337514771
    jac_run[148,155] = -4.84676915585801
    jac_run[148,156] = 26.5300693004806
    jac_run[149,141] = 26.5300693004806
    jac_run[149,142] = 4.84676915585801
    jac_run[149,143] = -7.89461337514770
    jac_run[149,144] = 1.58482814504483
    jac_run[149,145] = -7.72144347466701
    jac_run[149,146] = 0.679918453285310
    jac_run[149,147] = -7.89461337514771
    jac_run[149,148] = 1.58482814504483
    jac_run[149,149] = -53.0601386009611
    jac_run[149,150] = -9.69353831171601
    jac_run[149,151] = 15.7892267502954
    jac_run[149,152] = -3.16965629008966
    jac_run[149,153] = 15.4428869493340
    jac_run[149,154] = -1.35983690657062
    jac_run[149,155] = 15.7892267502954
    jac_run[149,156] = -3.16965629008966
    jac_run[149,157] = 26.5300693004806
    jac_run[149,158] = 4.84676915585801
    jac_run[149,159] = -7.89461337514770
    jac_run[149,160] = 1.58482814504483
    jac_run[149,161] = -7.72144347466701
    jac_run[149,162] = 0.679918453285310
    jac_run[149,163] = -7.89461337514771
    jac_run[149,164] = 1.58482814504483
    jac_run[150,141] = -4.84676915585801
    jac_run[150,142] = 26.5300693004806
    jac_run[150,143] = -1.58482814504483
    jac_run[150,144] = -7.89461337514770
    jac_run[150,145] = -0.679918453285310
    jac_run[150,146] = -7.72144347466701
    jac_run[150,147] = -1.58482814504483
    jac_run[150,148] = -7.89461337514771
    jac_run[150,149] = 9.69353831171601
    jac_run[150,150] = -53.0601386009611
    jac_run[150,151] = 3.16965629008966
    jac_run[150,152] = 15.7892267502954
    jac_run[150,153] = 1.35983690657062
    jac_run[150,154] = 15.4428869493340
    jac_run[150,155] = 3.16965629008966
    jac_run[150,156] = 15.7892267502954
    jac_run[150,157] = -4.84676915585801
    jac_run[150,158] = 26.5300693004806
    jac_run[150,159] = -1.58482814504483
    jac_run[150,160] = -7.89461337514770
    jac_run[150,161] = -0.679918453285310
    jac_run[150,162] = -7.72144347466701
    jac_run[150,163] = -1.58482814504483
    jac_run[150,164] = -7.89461337514771
    jac_run[151,141] = -7.89461337514771
    jac_run[151,142] = 1.58482814504483
    jac_run[151,143] = 26.5300693004806
    jac_run[151,144] = 4.84676915585801
    jac_run[151,145] = -7.89461337514771
    jac_run[151,146] = 1.58482814504483
    jac_run[151,147] = -7.72144347466701
    jac_run[151,148] = 0.679918453285308
    jac_run[151,149] = 15.7892267502954
    jac_run[151,150] = -3.16965629008966
    jac_run[151,151] = -53.0601386009611
    jac_run[151,152] = -9.69353831171602
    jac_run[151,153] = 15.7892267502954
    jac_run[151,154] = -3.16965629008967
    jac_run[151,155] = 15.4428869493340
    jac_run[151,156] = -1.35983690657062
    jac_run[151,157] = -7.89461337514771
    jac_run[151,158] = 1.58482814504483
    jac_run[151,159] = 26.5300693004806
    jac_run[151,160] = 4.84676915585801
    jac_run[151,161] = -7.89461337514771
    jac_run[151,162] = 1.58482814504483
    jac_run[151,163] = -7.72144347466701
    jac_run[151,164] = 0.679918453285308
    jac_run[152,141] = -1.58482814504483
    jac_run[152,142] = -7.89461337514771
    jac_run[152,143] = -4.84676915585801
    jac_run[152,144] = 26.5300693004806
    jac_run[152,145] = -1.58482814504483
    jac_run[152,146] = -7.89461337514771
    jac_run[152,147] = -0.679918453285308
    jac_run[152,148] = -7.72144347466701
    jac_run[152,149] = 3.16965629008966
    jac_run[152,150] = 15.7892267502954
    jac_run[152,151] = 9.69353831171602
    jac_run[152,152] = -53.0601386009611
    jac_run[152,153] = 3.16965629008967
    jac_run[152,154] = 15.7892267502954
    jac_run[152,155] = 1.35983690657062
    jac_run[152,156] = 15.4428869493340
    jac_run[152,157] = -1.58482814504483
    jac_run[152,158] = -7.89461337514771
    jac_run[152,159] = -4.84676915585801
    jac_run[152,160] = 26.5300693004806
    jac_run[152,161] = -1.58482814504483
    jac_run[152,162] = -7.89461337514771
    jac_run[152,163] = -0.679918453285308
    jac_run[152,164] = -7.72144347466701
    jac_run[153,141] = -7.72144347466701
    jac_run[153,142] = 0.679918453285310
    jac_run[153,143] = -7.89461337514770
    jac_run[153,144] = 1.58482814504483
    jac_run[153,145] = 26.5300693004806
    jac_run[153,146] = 4.84676915585801
    jac_run[153,147] = -7.89461337514771
    jac_run[153,148] = 1.58482814504483
    jac_run[153,149] = 15.4428869493340
    jac_run[153,150] = -1.35983690657062
    jac_run[153,151] = 15.7892267502954
    jac_run[153,152] = -3.16965629008966
    jac_run[153,153] = -53.0601386009611
    jac_run[153,154] = -9.69353831171602
    jac_run[153,155] = 15.7892267502954
    jac_run[153,156] = -3.16965629008967
    jac_run[153,157] = -7.72144347466701
    jac_run[153,158] = 0.679918453285310
    jac_run[153,159] = -7.89461337514770
    jac_run[153,160] = 1.58482814504483
    jac_run[153,161] = 26.5300693004806
    jac_run[153,162] = 4.84676915585801
    jac_run[153,163] = -7.89461337514771
    jac_run[153,164] = 1.58482814504483
    jac_run[154,141] = -0.679918453285310
    jac_run[154,142] = -7.72144347466701
    jac_run[154,143] = -1.58482814504483
    jac_run[154,144] = -7.89461337514770
    jac_run[154,145] = -4.84676915585801
    jac_run[154,146] = 26.5300693004806
    jac_run[154,147] = -1.58482814504483
    jac_run[154,148] = -7.89461337514771
    jac_run[154,149] = 1.35983690657062
    jac_run[154,150] = 15.4428869493340
    jac_run[154,151] = 3.16965629008966
    jac_run[154,152] = 15.7892267502954
    jac_run[154,153] = 9.69353831171602
    jac_run[154,154] = -53.0601386009611
    jac_run[154,155] = 3.16965629008967
    jac_run[154,156] = 15.7892267502954
    jac_run[154,157] = -0.679918453285310
    jac_run[154,158] = -7.72144347466701
    jac_run[154,159] = -1.58482814504483
    jac_run[154,160] = -7.89461337514770
    jac_run[154,161] = -4.84676915585801
    jac_run[154,162] = 26.5300693004806
    jac_run[154,163] = -1.58482814504483
    jac_run[154,164] = -7.89461337514771
    jac_run[155,141] = -7.89461337514771
    jac_run[155,142] = 1.58482814504483
    jac_run[155,143] = -7.72144347466701
    jac_run[155,144] = 0.679918453285308
    jac_run[155,145] = -7.89461337514771
    jac_run[155,146] = 1.58482814504483
    jac_run[155,147] = 26.5300693004806
    jac_run[155,148] = 4.84676915585801
    jac_run[155,149] = 15.7892267502954
    jac_run[155,150] = -3.16965629008966
    jac_run[155,151] = 15.4428869493340
    jac_run[155,152] = -1.35983690657062
    jac_run[155,153] = 15.7892267502954
    jac_run[155,154] = -3.16965629008966
    jac_run[155,155] = -53.0851386009611
    jac_run[155,156] = -9.69353831171602
    jac_run[155,157] = -7.89461337514771
    jac_run[155,158] = 1.58482814504483
    jac_run[155,159] = -7.72144347466701
    jac_run[155,160] = 0.679918453285308
    jac_run[155,161] = -7.89461337514771
    jac_run[155,162] = 1.58482814504483
    jac_run[155,163] = 26.5300693004806
    jac_run[155,164] = 4.84676915585801
    jac_run[156,141] = -1.58482814504483
    jac_run[156,142] = -7.89461337514771
    jac_run[156,143] = -0.679918453285308
    jac_run[156,144] = -7.72144347466701
    jac_run[156,145] = -1.58482814504483
    jac_run[156,146] = -7.89461337514771
    jac_run[156,147] = -4.84676915585801
    jac_run[156,148] = 26.5300693004806
    jac_run[156,149] = 3.16965629008966
    jac_run[156,150] = 15.7892267502954
    jac_run[156,151] = 1.35983690657062
    jac_run[156,152] = 15.4428869493340
    jac_run[156,153] = 3.16965629008966
    jac_run[156,154] = 15.7892267502954
    jac_run[156,155] = 9.69353831171602
    jac_run[156,156] = -53.0851386009611
    jac_run[156,157] = -1.58482814504483
    jac_run[156,158] = -7.89461337514771
    jac_run[156,159] = -0.679918453285308
    jac_run[156,160] = -7.72144347466701
    jac_run[156,161] = -1.58482814504483
    jac_run[156,162] = -7.89461337514771
    jac_run[156,163] = -4.84676915585801
    jac_run[156,164] = 26.5300693004806
    jac_run[157,17] = 26.5300693004806
    jac_run[157,18] = 4.84676915585801
    jac_run[157,19] = -7.89461337514770
    jac_run[157,20] = 1.58482814504483
    jac_run[157,21] = -7.72144347466701
    jac_run[157,22] = 0.679918453285310
    jac_run[157,23] = -7.89461337514771
    jac_run[157,24] = 1.58482814504483
    jac_run[157,149] = 26.5300693004806
    jac_run[157,150] = 4.84676915585801
    jac_run[157,151] = -7.89461337514770
    jac_run[157,152] = 1.58482814504483
    jac_run[157,153] = -7.72144347466701
    jac_run[157,154] = 0.679918453285310
    jac_run[157,155] = -7.89461337514771
    jac_run[157,156] = 1.58482814504483
    jac_run[157,157] = -53.0601386009611
    jac_run[157,158] = -9.69353831171601
    jac_run[157,159] = 15.7892267502954
    jac_run[157,160] = -3.16965629008966
    jac_run[157,161] = 15.4428869493340
    jac_run[157,162] = -1.35983690657062
    jac_run[157,163] = 15.7892267502954
    jac_run[157,164] = -3.16965629008966
    jac_run[157,424] = 1
    jac_run[158,17] = -4.84676915585801
    jac_run[158,18] = 26.5300693004806
    jac_run[158,19] = -1.58482814504483
    jac_run[158,20] = -7.89461337514770
    jac_run[158,21] = -0.679918453285310
    jac_run[158,22] = -7.72144347466701
    jac_run[158,23] = -1.58482814504483
    jac_run[158,24] = -7.89461337514771
    jac_run[158,149] = -4.84676915585801
    jac_run[158,150] = 26.5300693004806
    jac_run[158,151] = -1.58482814504483
    jac_run[158,152] = -7.89461337514770
    jac_run[158,153] = -0.679918453285310
    jac_run[158,154] = -7.72144347466701
    jac_run[158,155] = -1.58482814504483
    jac_run[158,156] = -7.89461337514771
    jac_run[158,157] = 9.69353831171601
    jac_run[158,158] = -53.0601386009611
    jac_run[158,159] = 3.16965629008966
    jac_run[158,160] = 15.7892267502954
    jac_run[158,161] = 1.35983690657062
    jac_run[158,162] = 15.4428869493340
    jac_run[158,163] = 3.16965629008966
    jac_run[158,164] = 15.7892267502954
    jac_run[158,425] = 1
    jac_run[159,17] = -7.89461337514771
    jac_run[159,18] = 1.58482814504483
    jac_run[159,19] = 26.5300693004806
    jac_run[159,20] = 4.84676915585801
    jac_run[159,21] = -7.89461337514771
    jac_run[159,22] = 1.58482814504483
    jac_run[159,23] = -7.72144347466701
    jac_run[159,24] = 0.679918453285308
    jac_run[159,149] = -7.89461337514771
    jac_run[159,150] = 1.58482814504483
    jac_run[159,151] = 26.5300693004806
    jac_run[159,152] = 4.84676915585801
    jac_run[159,153] = -7.89461337514771
    jac_run[159,154] = 1.58482814504483
    jac_run[159,155] = -7.72144347466701
    jac_run[159,156] = 0.679918453285308
    jac_run[159,157] = 15.7892267502954
    jac_run[159,158] = -3.16965629008966
    jac_run[159,159] = -53.0601386009611
    jac_run[159,160] = -9.69353831171602
    jac_run[159,161] = 15.7892267502954
    jac_run[159,162] = -3.16965629008967
    jac_run[159,163] = 15.4428869493340
    jac_run[159,164] = -1.35983690657062
    jac_run[159,426] = 1
    jac_run[160,17] = -1.58482814504483
    jac_run[160,18] = -7.89461337514771
    jac_run[160,19] = -4.84676915585801
    jac_run[160,20] = 26.5300693004806
    jac_run[160,21] = -1.58482814504483
    jac_run[160,22] = -7.89461337514771
    jac_run[160,23] = -0.679918453285308
    jac_run[160,24] = -7.72144347466701
    jac_run[160,149] = -1.58482814504483
    jac_run[160,150] = -7.89461337514771
    jac_run[160,151] = -4.84676915585801
    jac_run[160,152] = 26.5300693004806
    jac_run[160,153] = -1.58482814504483
    jac_run[160,154] = -7.89461337514771
    jac_run[160,155] = -0.679918453285308
    jac_run[160,156] = -7.72144347466701
    jac_run[160,157] = 3.16965629008966
    jac_run[160,158] = 15.7892267502954
    jac_run[160,159] = 9.69353831171602
    jac_run[160,160] = -53.0601386009611
    jac_run[160,161] = 3.16965629008967
    jac_run[160,162] = 15.7892267502954
    jac_run[160,163] = 1.35983690657062
    jac_run[160,164] = 15.4428869493340
    jac_run[160,427] = 1
    jac_run[161,17] = -7.72144347466701
    jac_run[161,18] = 0.679918453285310
    jac_run[161,19] = -7.89461337514770
    jac_run[161,20] = 1.58482814504483
    jac_run[161,21] = 26.5300693004806
    jac_run[161,22] = 4.84676915585801
    jac_run[161,23] = -7.89461337514771
    jac_run[161,24] = 1.58482814504483
    jac_run[161,149] = -7.72144347466701
    jac_run[161,150] = 0.679918453285310
    jac_run[161,151] = -7.89461337514770
    jac_run[161,152] = 1.58482814504483
    jac_run[161,153] = 26.5300693004806
    jac_run[161,154] = 4.84676915585801
    jac_run[161,155] = -7.89461337514771
    jac_run[161,156] = 1.58482814504483
    jac_run[161,157] = 15.4428869493340
    jac_run[161,158] = -1.35983690657062
    jac_run[161,159] = 15.7892267502954
    jac_run[161,160] = -3.16965629008966
    jac_run[161,161] = -53.0601386009611
    jac_run[161,162] = -9.69353831171602
    jac_run[161,163] = 15.7892267502954
    jac_run[161,164] = -3.16965629008967
    jac_run[161,428] = 1
    jac_run[162,17] = -0.679918453285310
    jac_run[162,18] = -7.72144347466701
    jac_run[162,19] = -1.58482814504483
    jac_run[162,20] = -7.89461337514770
    jac_run[162,21] = -4.84676915585801
    jac_run[162,22] = 26.5300693004806
    jac_run[162,23] = -1.58482814504483
    jac_run[162,24] = -7.89461337514771
    jac_run[162,149] = -0.679918453285310
    jac_run[162,150] = -7.72144347466701
    jac_run[162,151] = -1.58482814504483
    jac_run[162,152] = -7.89461337514770
    jac_run[162,153] = -4.84676915585801
    jac_run[162,154] = 26.5300693004806
    jac_run[162,155] = -1.58482814504483
    jac_run[162,156] = -7.89461337514771
    jac_run[162,157] = 1.35983690657062
    jac_run[162,158] = 15.4428869493340
    jac_run[162,159] = 3.16965629008966
    jac_run[162,160] = 15.7892267502954
    jac_run[162,161] = 9.69353831171602
    jac_run[162,162] = -53.0601386009611
    jac_run[162,163] = 3.16965629008967
    jac_run[162,164] = 15.7892267502954
    jac_run[162,429] = 1
    jac_run[163,17] = -7.89461337514771
    jac_run[163,18] = 1.58482814504483
    jac_run[163,19] = -7.72144347466701
    jac_run[163,20] = 0.679918453285308
    jac_run[163,21] = -7.89461337514771
    jac_run[163,22] = 1.58482814504483
    jac_run[163,23] = 26.5300693004806
    jac_run[163,24] = 4.84676915585801
    jac_run[163,149] = -7.89461337514771
    jac_run[163,150] = 1.58482814504483
    jac_run[163,151] = -7.72144347466701
    jac_run[163,152] = 0.679918453285308
    jac_run[163,153] = -7.89461337514771
    jac_run[163,154] = 1.58482814504483
    jac_run[163,155] = 26.5300693004806
    jac_run[163,156] = 4.84676915585801
    jac_run[163,157] = 15.7892267502954
    jac_run[163,158] = -3.16965629008966
    jac_run[163,159] = 15.4428869493340
    jac_run[163,160] = -1.35983690657062
    jac_run[163,161] = 15.7892267502954
    jac_run[163,162] = -3.16965629008966
    jac_run[163,163] = -53.0601386009611
    jac_run[163,164] = -9.69353831171602
    jac_run[164,17] = -1.58482814504483
    jac_run[164,18] = -7.89461337514771
    jac_run[164,19] = -0.679918453285308
    jac_run[164,20] = -7.72144347466701
    jac_run[164,21] = -1.58482814504483
    jac_run[164,22] = -7.89461337514771
    jac_run[164,23] = -4.84676915585801
    jac_run[164,24] = 26.5300693004806
    jac_run[164,149] = -1.58482814504483
    jac_run[164,150] = -7.89461337514771
    jac_run[164,151] = -0.679918453285308
    jac_run[164,152] = -7.72144347466701
    jac_run[164,153] = -1.58482814504483
    jac_run[164,154] = -7.89461337514771
    jac_run[164,155] = -4.84676915585801
    jac_run[164,156] = 26.5300693004806
    jac_run[164,157] = 3.16965629008966
    jac_run[164,158] = 15.7892267502954
    jac_run[164,159] = 1.35983690657062
    jac_run[164,160] = 15.4428869493340
    jac_run[164,161] = 3.16965629008966
    jac_run[164,162] = 15.7892267502954
    jac_run[164,163] = 9.69353831171602
    jac_run[164,164] = -53.0601386009611
    jac_run[165,165] = -1067.70480704130
    jac_run[165,173] = 67.7048070412999
    jac_run[166,166] = -1067.70480704130
    jac_run[166,174] = 67.7048070412999
    jac_run[167,53] = 157.977883096366
    jac_run[167,167] = -361.092304220266
    jac_run[167,175] = 135.409614082600
    jac_run[168,54] = 157.977883096366
    jac_run[168,168] = -361.092304220266
    jac_run[168,176] = 135.409614082600
    jac_run[169,169] = -361.092304220266
    jac_run[169,177] = 135.409614082600
    jac_run[169,207] = 157.977883096366
    jac_run[170,170] = -361.092304220266
    jac_run[170,178] = 135.409614082600
    jac_run[170,208] = 157.977883096366
    jac_run[171,171] = -361.092304220266
    jac_run[171,179] = 135.409614082600
    jac_run[171,209] = 157.977883096366
    jac_run[172,172] = -361.092304220266
    jac_run[172,180] = 135.409614082600
    jac_run[172,210] = 157.977883096366
    jac_run[173,55] = 157.977883096366
    jac_run[173,165] = 67.7048070412999
    jac_run[173,173] = -361.092304220266
    jac_run[173,181] = 135.409614082600
    jac_run[174,56] = 157.977883096366
    jac_run[174,166] = 67.7048070412999
    jac_run[174,174] = -361.092304220266
    jac_run[174,182] = 135.409614082600
    jac_run[175,167] = 135.409614082600
    jac_run[175,175] = -248.250959151433
    jac_run[175,183] = 67.7048070412999
    jac_run[175,223] = 45.1365380275333
    jac_run[176,168] = 135.409614082600
    jac_run[176,176] = -248.250959151433
    jac_run[176,184] = 67.7048070412999
    jac_run[176,224] = 45.1365380275333
    jac_run[177,169] = 135.409614082600
    jac_run[177,177] = -248.250959151433
    jac_run[177,185] = 67.7048070412999
    jac_run[177,225] = 45.1365380275333
    jac_run[178,170] = 135.409614082600
    jac_run[178,178] = -248.250959151433
    jac_run[178,186] = 67.7048070412999
    jac_run[178,226] = 45.1365380275333
    jac_run[179,171] = 135.409614082600
    jac_run[179,179] = -248.250959151433
    jac_run[179,187] = 67.7048070412999
    jac_run[179,227] = 45.1365380275333
    jac_run[180,172] = 135.409614082600
    jac_run[180,180] = -248.250959151433
    jac_run[180,188] = 67.7048070412999
    jac_run[180,228] = 45.1365380275333
    jac_run[181,173] = 135.409614082600
    jac_run[181,181] = -248.250959151433
    jac_run[181,189] = 67.7048070412999
    jac_run[181,229] = 45.1365380275333
    jac_run[182,174] = 135.409614082600
    jac_run[182,182] = -248.250959151433
    jac_run[182,190] = 67.7048070412999
    jac_run[182,230] = 45.1365380275333
    jac_run[183,57] = 157.977883096366
    jac_run[183,175] = 67.7048070412999
    jac_run[183,183] = -270.819228165200
    jac_run[183,191] = 45.1365380275333
    jac_run[184,58] = 157.977883096366
    jac_run[184,176] = 67.7048070412999
    jac_run[184,184] = -270.819228165200
    jac_run[184,192] = 45.1365380275333
    jac_run[185,177] = 67.7048070412999
    jac_run[185,185] = -270.819228165200
    jac_run[185,193] = 45.1365380275333
    jac_run[185,211] = 157.977883096366
    jac_run[186,178] = 67.7048070412999
    jac_run[186,186] = -270.819228165200
    jac_run[186,194] = 45.1365380275333
    jac_run[186,212] = 157.977883096366
    jac_run[187,179] = 67.7048070412999
    jac_run[187,187] = -270.819228165200
    jac_run[187,195] = 45.1365380275333
    jac_run[187,213] = 157.977883096366
    jac_run[188,180] = 67.7048070412999
    jac_run[188,188] = -270.819228165200
    jac_run[188,196] = 45.1365380275333
    jac_run[188,214] = 157.977883096366
    jac_run[189,59] = 157.977883096366
    jac_run[189,181] = 67.7048070412999
    jac_run[189,189] = -270.819228165200
    jac_run[189,197] = 45.1365380275333
    jac_run[190,60] = 157.977883096366
    jac_run[190,182] = 67.7048070412999
    jac_run[190,190] = -270.819228165200
    jac_run[190,198] = 45.1365380275333
    jac_run[191,61] = 157.977883096366
    jac_run[191,183] = 45.1365380275333
    jac_run[191,191] = -361.092304220266
    jac_run[191,199] = 157.977883096366
    jac_run[192,62] = 157.977883096366
    jac_run[192,184] = 45.1365380275333
    jac_run[192,192] = -361.092304220266
    jac_run[192,200] = 157.977883096366
    jac_run[193,185] = 45.1365380275333
    jac_run[193,193] = -361.092304220266
    jac_run[193,201] = 157.977883096366
    jac_run[193,215] = 157.977883096366
    jac_run[194,186] = 45.1365380275333
    jac_run[194,194] = -361.092304220266
    jac_run[194,202] = 157.977883096366
    jac_run[194,216] = 157.977883096366
    jac_run[195,187] = 45.1365380275333
    jac_run[195,195] = -361.092304220266
    jac_run[195,203] = 157.977883096366
    jac_run[195,217] = 157.977883096366
    jac_run[196,188] = 45.1365380275333
    jac_run[196,196] = -361.092304220266
    jac_run[196,204] = 157.977883096366
    jac_run[196,218] = 157.977883096366
    jac_run[197,63] = 157.977883096366
    jac_run[197,189] = 45.1365380275333
    jac_run[197,197] = -361.092304220266
    jac_run[197,205] = 157.977883096366
    jac_run[198,64] = 157.977883096366
    jac_run[198,190] = 45.1365380275333
    jac_run[198,198] = -361.092304220266
    jac_run[198,206] = 157.977883096366
    jac_run[199,65] = 157.977883096366
    jac_run[199,191] = 157.977883096366
    jac_run[199,199] = -315.955766192733
    jac_run[199,420] = 1
    jac_run[200,66] = 157.977883096366
    jac_run[200,192] = 157.977883096366
    jac_run[200,200] = -315.955766192733
    jac_run[201,193] = 157.977883096366
    jac_run[201,201] = -315.955766192733
    jac_run[201,219] = 157.977883096366
    jac_run[202,194] = 157.977883096366
    jac_run[202,202] = -315.955766192733
    jac_run[202,220] = 157.977883096366
    jac_run[203,195] = 157.977883096366
    jac_run[203,203] = -315.955766192733
    jac_run[203,221] = 157.977883096366
    jac_run[204,196] = 157.977883096366
    jac_run[204,204] = -315.955766192733
    jac_run[204,222] = 157.977883096366
    jac_run[205,67] = 157.977883096366
    jac_run[205,197] = 157.977883096366
    jac_run[205,205] = -315.955766192733
    jac_run[205,421] = 1
    jac_run[206,68] = 157.977883096366
    jac_run[206,198] = 157.977883096366
    jac_run[206,206] = -315.955766192733
    jac_run[207,169] = 157.977883096366
    jac_run[207,207] = -157.977883096366
    jac_run[208,170] = 157.977883096366
    jac_run[208,208] = -157.977883096366
    jac_run[209,171] = 157.977883096366
    jac_run[209,209] = -157.977883096366
    jac_run[210,172] = 157.977883096366
    jac_run[210,210] = -157.977883096366
    jac_run[211,185] = 157.977883096366
    jac_run[211,211] = -157.977883096366
    jac_run[212,186] = 157.977883096366
    jac_run[212,212] = -157.977883096366
    jac_run[213,187] = 157.977883096366
    jac_run[213,213] = -157.977883096366
    jac_run[214,188] = 157.977883096366
    jac_run[214,214] = -157.977883096366
    jac_run[215,193] = 157.977883096366
    jac_run[215,215] = -157.977883096366
    jac_run[216,194] = 157.977883096366
    jac_run[216,216] = -157.977883096366
    jac_run[217,195] = 157.977883096366
    jac_run[217,217] = -157.977883096366
    jac_run[218,196] = 157.977883096366
    jac_run[218,218] = -157.977883096366
    jac_run[219,201] = 157.977883096366
    jac_run[219,219] = -157.977883096366
    jac_run[220,202] = 157.977883096366
    jac_run[220,220] = -157.977883096366
    jac_run[221,203] = 157.977883096366
    jac_run[221,221] = -157.977883096366
    jac_run[222,204] = 157.977883096366
    jac_run[222,222] = -157.977883096366
    jac_run[223,49] = 135.409614082600
    jac_run[223,175] = 45.1365380275333
    jac_run[223,223] = -180.546152110133
    jac_run[223,430] = 1
    jac_run[224,50] = 135.409614082600
    jac_run[224,176] = 45.1365380275333
    jac_run[224,224] = -180.546152110133
    jac_run[225,177] = 45.1365380275333
    jac_run[225,225] = -180.546152110133
    jac_run[225,231] = 135.409614082600
    jac_run[226,178] = 45.1365380275333
    jac_run[226,226] = -180.546152110133
    jac_run[226,232] = 135.409614082600
    jac_run[227,179] = 45.1365380275333
    jac_run[227,227] = -180.546152110133
    jac_run[227,233] = 135.409614082600
    jac_run[228,180] = 45.1365380275333
    jac_run[228,228] = -180.546152110133
    jac_run[228,234] = 135.409614082600
    jac_run[229,51] = 135.409614082600
    jac_run[229,181] = 45.1365380275333
    jac_run[229,229] = -180.546152110133
    jac_run[229,431] = 1
    jac_run[230,52] = 135.409614082600
    jac_run[230,182] = 45.1365380275333
    jac_run[230,230] = -180.546152110133
    jac_run[231,225] = 135.409614082600
    jac_run[231,231] = -135.409614082600
    jac_run[232,226] = 135.409614082600
    jac_run[232,232] = -135.409614082600
    jac_run[233,227] = 135.409614082600
    jac_run[233,233] = -135.409614082600
    jac_run[234,228] = 135.409614082600
    jac_run[234,234] = -135.409614082600
    jac_run[235,1] = -0.212261128378539
    jac_run[235,2] = -0.849044513514155
    jac_run[235,3] = 0.212261128378539
    jac_run[235,4] = 0.849044513514155
    jac_run[235,235] = -1
    jac_run[236,1] = 0.849044513514155
    jac_run[236,2] = -0.212261128378539
    jac_run[236,3] = -0.849044513514155
    jac_run[236,4] = 0.212261128378539
    jac_run[236,236] = -1
    jac_run[237,3] = -0.212261128378539
    jac_run[237,4] = -0.849044513514155
    jac_run[237,5] = 0.212261128378539
    jac_run[237,6] = 0.849044513514155
    jac_run[237,237] = -1
    jac_run[238,3] = 0.849044513514155
    jac_run[238,4] = -0.212261128378539
    jac_run[238,5] = -0.849044513514155
    jac_run[238,6] = 0.212261128378539
    jac_run[238,238] = -1
    jac_run[239,1] = 0.212261128378539
    jac_run[239,2] = 0.849044513514155
    jac_run[239,5] = -0.212261128378539
    jac_run[239,6] = -0.849044513514155
    jac_run[239,239] = -1
    jac_run[240,1] = -0.849044513514155
    jac_run[240,2] = 0.212261128378539
    jac_run[240,5] = 0.849044513514155
    jac_run[240,6] = -0.212261128378539
    jac_run[240,240] = -1
    jac_run[241,1] = 105.571769313180
    jac_run[241,2] = 54.0657727682604
    jac_run[241,3] = -39.6392229058202
    jac_run[241,4] = -10.2713736253513
    jac_run[241,5] = -24.9575997948692
    jac_run[241,6] = -23.2849644809540
    jac_run[241,7] = -39.6392229058202
    jac_run[241,8] = -10.2713736253513
    jac_run[241,69] = -105.571769313180
    jac_run[241,70] = -54.0657727682604
    jac_run[241,71] = 39.6392229058202
    jac_run[241,72] = 10.2713736253513
    jac_run[241,73] = 24.9575997948692
    jac_run[241,74] = 23.2849644809540
    jac_run[241,75] = 39.6392229058202
    jac_run[241,76] = 10.2713736253513
    jac_run[241,241] = -1
    jac_run[242,1] = -54.0657727682604
    jac_run[242,2] = 105.571769313180
    jac_run[242,3] = 10.2713736253513
    jac_run[242,4] = -39.6392229058202
    jac_run[242,5] = 23.2849644809540
    jac_run[242,6] = -24.9575997948692
    jac_run[242,7] = 10.2713736253513
    jac_run[242,8] = -39.6392229058202
    jac_run[242,69] = 54.0657727682604
    jac_run[242,70] = -105.571769313180
    jac_run[242,71] = -10.2713736253513
    jac_run[242,72] = 39.6392229058202
    jac_run[242,73] = -23.2849644809540
    jac_run[242,74] = 24.9575997948692
    jac_run[242,75] = -10.2713736253513
    jac_run[242,76] = 39.6392229058202
    jac_run[242,242] = -1
    jac_run[243,1] = -39.6392229058202
    jac_run[243,2] = -10.2713736253513
    jac_run[243,3] = 105.571769313180
    jac_run[243,4] = 54.0657727682604
    jac_run[243,5] = -39.6392229058201
    jac_run[243,6] = -10.2713736253513
    jac_run[243,7] = -24.9575997948692
    jac_run[243,8] = -23.2849644809540
    jac_run[243,69] = 39.6392229058202
    jac_run[243,70] = 10.2713736253513
    jac_run[243,71] = -105.571769313180
    jac_run[243,72] = -54.0657727682604
    jac_run[243,73] = 39.6392229058201
    jac_run[243,74] = 10.2713736253513
    jac_run[243,75] = 24.9575997948692
    jac_run[243,76] = 23.2849644809540
    jac_run[243,243] = -1
    jac_run[244,1] = 10.2713736253513
    jac_run[244,2] = -39.6392229058202
    jac_run[244,3] = -54.0657727682604
    jac_run[244,4] = 105.571769313180
    jac_run[244,5] = 10.2713736253513
    jac_run[244,6] = -39.6392229058201
    jac_run[244,7] = 23.2849644809540
    jac_run[244,8] = -24.9575997948692
    jac_run[244,69] = -10.2713736253513
    jac_run[244,70] = 39.6392229058202
    jac_run[244,71] = 54.0657727682604
    jac_run[244,72] = -105.571769313180
    jac_run[244,73] = -10.2713736253513
    jac_run[244,74] = 39.6392229058201
    jac_run[244,75] = -23.2849644809540
    jac_run[244,76] = 24.9575997948692
    jac_run[244,244] = -1
    jac_run[245,1] = -24.9575997948692
    jac_run[245,2] = -23.2849644809540
    jac_run[245,3] = -39.6392229058202
    jac_run[245,4] = -10.2713736253513
    jac_run[245,5] = 105.571769313180
    jac_run[245,6] = 54.0657727682604
    jac_run[245,7] = -39.6392229058201
    jac_run[245,8] = -10.2713736253514
    jac_run[245,69] = 24.9575997948692
    jac_run[245,70] = 23.2849644809540
    jac_run[245,71] = 39.6392229058202
    jac_run[245,72] = 10.2713736253513
    jac_run[245,73] = -105.571769313180
    jac_run[245,74] = -54.0657727682604
    jac_run[245,75] = 39.6392229058201
    jac_run[245,76] = 10.2713736253514
    jac_run[245,245] = -1
    jac_run[246,1] = 23.2849644809540
    jac_run[246,2] = -24.9575997948692
    jac_run[246,3] = 10.2713736253513
    jac_run[246,4] = -39.6392229058202
    jac_run[246,5] = -54.0657727682604
    jac_run[246,6] = 105.571769313180
    jac_run[246,7] = 10.2713736253514
    jac_run[246,8] = -39.6392229058201
    jac_run[246,69] = -23.2849644809540
    jac_run[246,70] = 24.9575997948692
    jac_run[246,71] = -10.2713736253513
    jac_run[246,72] = 39.6392229058202
    jac_run[246,73] = 54.0657727682604
    jac_run[246,74] = -105.571769313180
    jac_run[246,75] = -10.2713736253514
    jac_run[246,76] = 39.6392229058201
    jac_run[246,246] = -1
    jac_run[247,241] = 1
    jac_run[247,243] = 1
    jac_run[247,245] = 1
    jac_run[247,247] = -1
    jac_run[248,242] = 1
    jac_run[248,244] = 1
    jac_run[248,246] = 1
    jac_run[248,248] = -1
    jac_run[249,167] = -67.7048070412999
    jac_run[249,249] = -1
    jac_run[250,168] = -67.7048070412999
    jac_run[250,250] = -1
    jac_run[251,169] = -67.7048070412999
    jac_run[251,251] = -1
    jac_run[252,170] = -67.7048070412999
    jac_run[252,252] = -1
    jac_run[253,171] = -67.7048070412999
    jac_run[253,253] = -1
    jac_run[254,172] = -67.7048070412999
    jac_run[254,254] = -1
    jac_run[255,249] = 1
    jac_run[255,251] = 1
    jac_run[255,253] = 1
    jac_run[255,255] = -1
    jac_run[256,250] = 1
    jac_run[256,252] = 1
    jac_run[256,254] = 1
    jac_run[256,256] = -1
    jac_run[257,167] = 135.409614082600
    jac_run[257,175] = -135.409614082600
    jac_run[257,257] = -1
    jac_run[258,168] = 135.409614082600
    jac_run[258,176] = -135.409614082600
    jac_run[258,258] = -1
    jac_run[259,169] = 135.409614082600
    jac_run[259,177] = -135.409614082600
    jac_run[259,259] = -1
    jac_run[260,170] = 135.409614082600
    jac_run[260,178] = -135.409614082600
    jac_run[260,260] = -1
    jac_run[261,171] = 135.409614082600
    jac_run[261,179] = -135.409614082600
    jac_run[261,261] = -1
    jac_run[262,172] = 135.409614082600
    jac_run[262,180] = -135.409614082600
    jac_run[262,262] = -1
    jac_run[263,257] = 1
    jac_run[263,259] = 1
    jac_run[263,261] = 1
    jac_run[263,263] = -1
    jac_run[264,258] = 1
    jac_run[264,260] = 1
    jac_run[264,262] = 1
    jac_run[264,264] = -1
    jac_run[265,175] = 67.7048070412999
    jac_run[265,183] = -67.7048070412999
    jac_run[265,265] = -1
    jac_run[266,176] = 67.7048070412999
    jac_run[266,184] = -67.7048070412999
    jac_run[266,266] = -1
    jac_run[267,177] = 67.7048070412999
    jac_run[267,185] = -67.7048070412999
    jac_run[267,267] = -1
    jac_run[268,178] = 67.7048070412999
    jac_run[268,186] = -67.7048070412999
    jac_run[268,268] = -1
    jac_run[269,179] = 67.7048070412999
    jac_run[269,187] = -67.7048070412999
    jac_run[269,269] = -1
    jac_run[270,180] = 67.7048070412999
    jac_run[270,188] = -67.7048070412999
    jac_run[270,270] = -1
    jac_run[271,265] = 1
    jac_run[271,267] = 1
    jac_run[271,269] = 1
    jac_run[271,271] = -1
    jac_run[272,266] = 1
    jac_run[272,268] = 1
    jac_run[272,270] = 1
    jac_run[272,272] = -1
    jac_run[273,183] = 45.1365380275333
    jac_run[273,191] = -45.1365380275333
    jac_run[273,273] = -1
    jac_run[274,184] = 45.1365380275333
    jac_run[274,192] = -45.1365380275333
    jac_run[274,274] = -1
    jac_run[275,185] = 45.1365380275333
    jac_run[275,193] = -45.1365380275333
    jac_run[275,275] = -1
    jac_run[276,186] = 45.1365380275333
    jac_run[276,194] = -45.1365380275333
    jac_run[276,276] = -1
    jac_run[277,187] = 45.1365380275333
    jac_run[277,195] = -45.1365380275333
    jac_run[277,277] = -1
    jac_run[278,188] = 45.1365380275333
    jac_run[278,196] = -45.1365380275333
    jac_run[278,278] = -1
    jac_run[279,273] = 1
    jac_run[279,275] = 1
    jac_run[279,277] = 1
    jac_run[279,279] = -1
    jac_run[280,274] = 1
    jac_run[280,276] = 1
    jac_run[280,278] = 1
    jac_run[280,280] = -1
    jac_run[281,191] = 157.977883096366
    jac_run[281,199] = -157.977883096366
    jac_run[281,281] = -1
    jac_run[282,192] = 157.977883096366
    jac_run[282,200] = -157.977883096366
    jac_run[282,282] = -1
    jac_run[283,193] = 157.977883096366
    jac_run[283,201] = -157.977883096366
    jac_run[283,283] = -1
    jac_run[284,194] = 157.977883096366
    jac_run[284,202] = -157.977883096366
    jac_run[284,284] = -1
    jac_run[285,195] = 157.977883096366
    jac_run[285,203] = -157.977883096366
    jac_run[285,285] = -1
    jac_run[286,196] = 157.977883096366
    jac_run[286,204] = -157.977883096366
    jac_run[286,286] = -1
    jac_run[287,281] = 1
    jac_run[287,283] = 1
    jac_run[287,285] = 1
    jac_run[287,287] = -1
    jac_run[288,282] = 1
    jac_run[288,284] = 1
    jac_run[288,286] = 1
    jac_run[288,288] = -1
    jac_run[289,53] = -157.977883096366
    jac_run[289,167] = 157.977883096366
    jac_run[289,289] = -1
    jac_run[290,54] = -157.977883096366
    jac_run[290,168] = 157.977883096366
    jac_run[290,290] = -1
    jac_run[291,169] = 157.977883096366
    jac_run[291,207] = -157.977883096366
    jac_run[291,291] = -1
    jac_run[292,170] = 157.977883096366
    jac_run[292,208] = -157.977883096366
    jac_run[292,292] = -1
    jac_run[293,171] = 157.977883096366
    jac_run[293,209] = -157.977883096366
    jac_run[293,293] = -1
    jac_run[294,172] = 157.977883096366
    jac_run[294,210] = -157.977883096366
    jac_run[294,294] = -1
    jac_run[295,289] = 1
    jac_run[295,291] = 1
    jac_run[295,293] = 1
    jac_run[295,295] = -1
    jac_run[296,290] = 1
    jac_run[296,292] = 1
    jac_run[296,294] = 1
    jac_run[296,296] = -1
    jac_run[297,57] = -157.977883096366
    jac_run[297,183] = 157.977883096366
    jac_run[297,297] = -1
    jac_run[298,58] = -157.977883096366
    jac_run[298,184] = 157.977883096366
    jac_run[298,298] = -1
    jac_run[299,185] = 157.977883096366
    jac_run[299,211] = -157.977883096366
    jac_run[299,299] = -1
    jac_run[300,186] = 157.977883096366
    jac_run[300,212] = -157.977883096366
    jac_run[300,300] = -1
    jac_run[301,187] = 157.977883096366
    jac_run[301,213] = -157.977883096366
    jac_run[301,301] = -1
    jac_run[302,188] = 157.977883096366
    jac_run[302,214] = -157.977883096366
    jac_run[302,302] = -1
    jac_run[303,297] = 1
    jac_run[303,299] = 1
    jac_run[303,301] = 1
    jac_run[303,303] = -1
    jac_run[304,298] = 1
    jac_run[304,300] = 1
    jac_run[304,302] = 1
    jac_run[304,304] = -1
    jac_run[305,61] = -157.977883096366
    jac_run[305,191] = 157.977883096366
    jac_run[305,305] = -1
    jac_run[306,62] = -157.977883096366
    jac_run[306,192] = 157.977883096366
    jac_run[306,306] = -1
    jac_run[307,193] = 157.977883096366
    jac_run[307,215] = -157.977883096366
    jac_run[307,307] = -1
    jac_run[308,194] = 157.977883096366
    jac_run[308,216] = -157.977883096366
    jac_run[308,308] = -1
    jac_run[309,195] = 157.977883096366
    jac_run[309,217] = -157.977883096366
    jac_run[309,309] = -1
    jac_run[310,196] = 157.977883096366
    jac_run[310,218] = -157.977883096366
    jac_run[310,310] = -1
    jac_run[311,305] = 1
    jac_run[311,307] = 1
    jac_run[311,309] = 1
    jac_run[311,311] = -1
    jac_run[312,306] = 1
    jac_run[312,308] = 1
    jac_run[312,310] = 1
    jac_run[312,312] = -1
    jac_run[313,65] = -157.977883096366
    jac_run[313,199] = 157.977883096366
    jac_run[313,313] = -1
    jac_run[314,66] = -157.977883096366
    jac_run[314,200] = 157.977883096366
    jac_run[314,314] = -1
    jac_run[315,201] = 157.977883096366
    jac_run[315,219] = -157.977883096366
    jac_run[315,315] = -1
    jac_run[316,202] = 157.977883096366
    jac_run[316,220] = -157.977883096366
    jac_run[316,316] = -1
    jac_run[317,203] = 157.977883096366
    jac_run[317,221] = -157.977883096366
    jac_run[317,317] = -1
    jac_run[318,204] = 157.977883096366
    jac_run[318,222] = -157.977883096366
    jac_run[318,318] = -1
    jac_run[319,313] = 1
    jac_run[319,315] = 1
    jac_run[319,317] = 1
    jac_run[319,319] = -1
    jac_run[320,314] = 1
    jac_run[320,316] = 1
    jac_run[320,318] = 1
    jac_run[320,320] = -1
    jac_run[321,175] = 45.1365380275333
    jac_run[321,223] = -45.1365380275333
    jac_run[321,321] = -1
    jac_run[322,176] = 45.1365380275333
    jac_run[322,224] = -45.1365380275333
    jac_run[322,322] = -1
    jac_run[323,177] = 45.1365380275333
    jac_run[323,225] = -45.1365380275333
    jac_run[323,323] = -1
    jac_run[324,178] = 45.1365380275333
    jac_run[324,226] = -45.1365380275333
    jac_run[324,324] = -1
    jac_run[325,179] = 45.1365380275333
    jac_run[325,227] = -45.1365380275333
    jac_run[325,325] = -1
    jac_run[326,180] = 45.1365380275333
    jac_run[326,228] = -45.1365380275333
    jac_run[326,326] = -1
    jac_run[327,321] = 1
    jac_run[327,323] = 1
    jac_run[327,325] = 1
    jac_run[327,327] = -1
    jac_run[328,322] = 1
    jac_run[328,324] = 1
    jac_run[328,326] = 1
    jac_run[328,328] = -1
    jac_run[329,49] = -135.409614082600
    jac_run[329,223] = 135.409614082600
    jac_run[329,329] = -1
    jac_run[330,50] = -135.409614082600
    jac_run[330,224] = 135.409614082600
    jac_run[330,330] = -1
    jac_run[331,225] = 135.409614082600
    jac_run[331,231] = -135.409614082600
    jac_run[331,331] = -1
    jac_run[332,226] = 135.409614082600
    jac_run[332,232] = -135.409614082600
    jac_run[332,332] = -1
    jac_run[333,227] = 135.409614082600
    jac_run[333,233] = -135.409614082600
    jac_run[333,333] = -1
    jac_run[334,228] = 135.409614082600
    jac_run[334,234] = -135.409614082600
    jac_run[334,334] = -1
    jac_run[335,329] = 1
    jac_run[335,331] = 1
    jac_run[335,333] = 1
    jac_run[335,335] = -1
    jac_run[336,330] = 1
    jac_run[336,332] = 1
    jac_run[336,334] = 1
    jac_run[336,336] = -1
    jac_run[343,337] = 1
    jac_run[343,339] = 1
    jac_run[343,341] = 1
    jac_run[343,343] = 1
    jac_run[344,338] = 1
    jac_run[344,340] = 1
    jac_run[344,342] = 1
    jac_run[344,344] = 1
    jac_run[351,345] = 1
    jac_run[351,347] = 1
    jac_run[351,349] = 1
    jac_run[351,351] = 1
    jac_run[352,346] = 1
    jac_run[352,348] = 1
    jac_run[352,350] = 1
    jac_run[352,352] = 1
    jac_run[359,353] = 1
    jac_run[359,355] = 1
    jac_run[359,357] = 1
    jac_run[359,359] = 1
    jac_run[360,354] = 1
    jac_run[360,356] = 1
    jac_run[360,358] = 1
    jac_run[360,360] = 1
    jac_run[367,361] = 1
    jac_run[367,363] = 1
    jac_run[367,365] = 1
    jac_run[367,367] = 1
    jac_run[368,362] = 1
    jac_run[368,364] = 1
    jac_run[368,366] = 1
    jac_run[368,368] = 1
    jac_run[375,369] = 1
    jac_run[375,371] = 1
    jac_run[375,373] = 1
    jac_run[375,375] = 1
    jac_run[376,370] = 1
    jac_run[376,372] = 1
    jac_run[376,374] = 1
    jac_run[376,376] = 1
    jac_run[383,377] = 1
    jac_run[383,379] = 1
    jac_run[383,381] = 1
    jac_run[383,383] = 1
    jac_run[384,378] = 1
    jac_run[384,380] = 1
    jac_run[384,382] = 1
    jac_run[384,384] = 1
    jac_run[387,385] = 1
    jac_run[387,387] = 1
    jac_run[388,386] = 1.00000000000000
    jac_run[388,388] = 1.00000000000000
    jac_run[391,389] = 1
    jac_run[391,391] = 1
    jac_run[392,390] = 1.00000000000000
    jac_run[392,392] = 1.00000000000000
    jac_run[395,393] = 1
    jac_run[395,395] = 1
    jac_run[396,394] = 1.00000000000000
    jac_run[396,396] = 1.00000000000000
    jac_run[399,397] = 1
    jac_run[399,399] = 1
    jac_run[400,398] = 1.00000000000000
    jac_run[400,400] = 1.00000000000000
    jac_run[403,401] = 1
    jac_run[403,403] = 1
    jac_run[404,402] = 1.00000000000000
    jac_run[404,404] = 1.00000000000000
    jac_run[405,411] = -1/3
    jac_run[407,411] = -1/3
    jac_run[409,411] = -1/3
    jac_run[411,411] = 1
    jac_run[411,412] = 1
    jac_run[412,412] = -1
    jac_run[413,413] = 1
    jac_run[420,420] = 1
    jac_run[421,421] = 1
    jac_run[422,422] = 1
    jac_run[423,423] = 1
    jac_run[430,430] = 1
    jac_run[431,431] = 1
    jac_run[432,432] = 1
    jac_run[433,433] = 1





@numba.njit(cache=True)
def jac_trap_eval_xy(jac_trap,x,y,u,p,Dt,xyup = 1):

    jac_trap[337,1] = y[336]
    jac_trap[337,2] = y[337]
    jac_trap[337,7] = -y[336]
    jac_trap[337,8] = -y[337]
    jac_trap[337,337] = y[0] - y[6]
    jac_trap[337,338] = y[1] - y[7]
    jac_trap[338,3] = y[338]
    jac_trap[338,4] = y[339]
    jac_trap[338,7] = -y[338]
    jac_trap[338,8] = -y[339]
    jac_trap[338,339] = y[2] - y[6]
    jac_trap[338,340] = y[3] - y[7]
    jac_trap[339,5] = y[340]
    jac_trap[339,6] = y[341]
    jac_trap[339,7] = -y[340]
    jac_trap[339,8] = -y[341]
    jac_trap[339,341] = y[4] - y[6]
    jac_trap[339,342] = y[5] - y[7]
    jac_trap[340,1] = -y[337]
    jac_trap[340,2] = y[336]
    jac_trap[340,7] = y[337]
    jac_trap[340,8] = -y[336]
    jac_trap[340,337] = y[1] - y[7]
    jac_trap[340,338] = -y[0] + y[6]
    jac_trap[341,3] = -y[339]
    jac_trap[341,4] = y[338]
    jac_trap[341,7] = y[339]
    jac_trap[341,8] = -y[338]
    jac_trap[341,339] = y[3] - y[7]
    jac_trap[341,340] = -y[2] + y[6]
    jac_trap[342,5] = -y[341]
    jac_trap[342,6] = y[340]
    jac_trap[342,7] = y[341]
    jac_trap[342,8] = -y[340]
    jac_trap[342,341] = y[5] - y[7]
    jac_trap[342,342] = -y[4] + y[6]
    jac_trap[345,9] = y[344]
    jac_trap[345,10] = y[345]
    jac_trap[345,15] = -y[344]
    jac_trap[345,16] = -y[345]
    jac_trap[345,345] = y[8] - y[14]
    jac_trap[345,346] = y[9] - y[15]
    jac_trap[346,11] = y[346]
    jac_trap[346,12] = y[347]
    jac_trap[346,15] = -y[346]
    jac_trap[346,16] = -y[347]
    jac_trap[346,347] = y[10] - y[14]
    jac_trap[346,348] = y[11] - y[15]
    jac_trap[347,13] = y[348]
    jac_trap[347,14] = y[349]
    jac_trap[347,15] = -y[348]
    jac_trap[347,16] = -y[349]
    jac_trap[347,349] = y[12] - y[14]
    jac_trap[347,350] = y[13] - y[15]
    jac_trap[348,9] = -y[345]
    jac_trap[348,10] = y[344]
    jac_trap[348,15] = y[345]
    jac_trap[348,16] = -y[344]
    jac_trap[348,345] = y[9] - y[15]
    jac_trap[348,346] = -y[8] + y[14]
    jac_trap[349,11] = -y[347]
    jac_trap[349,12] = y[346]
    jac_trap[349,15] = y[347]
    jac_trap[349,16] = -y[346]
    jac_trap[349,347] = y[11] - y[15]
    jac_trap[349,348] = -y[10] + y[14]
    jac_trap[350,13] = -y[349]
    jac_trap[350,14] = y[348]
    jac_trap[350,15] = y[349]
    jac_trap[350,16] = -y[348]
    jac_trap[350,349] = y[13] - y[15]
    jac_trap[350,350] = -y[12] + y[14]
    jac_trap[353,17] = y[352]
    jac_trap[353,18] = y[353]
    jac_trap[353,23] = -y[352]
    jac_trap[353,24] = -y[353]
    jac_trap[353,353] = y[16] - y[22]
    jac_trap[353,354] = y[17] - y[23]
    jac_trap[354,19] = y[354]
    jac_trap[354,20] = y[355]
    jac_trap[354,23] = -y[354]
    jac_trap[354,24] = -y[355]
    jac_trap[354,355] = y[18] - y[22]
    jac_trap[354,356] = y[19] - y[23]
    jac_trap[355,21] = y[356]
    jac_trap[355,22] = y[357]
    jac_trap[355,23] = -y[356]
    jac_trap[355,24] = -y[357]
    jac_trap[355,357] = y[20] - y[22]
    jac_trap[355,358] = y[21] - y[23]
    jac_trap[356,17] = -y[353]
    jac_trap[356,18] = y[352]
    jac_trap[356,23] = y[353]
    jac_trap[356,24] = -y[352]
    jac_trap[356,353] = y[17] - y[23]
    jac_trap[356,354] = -y[16] + y[22]
    jac_trap[357,19] = -y[355]
    jac_trap[357,20] = y[354]
    jac_trap[357,23] = y[355]
    jac_trap[357,24] = -y[354]
    jac_trap[357,355] = y[19] - y[23]
    jac_trap[357,356] = -y[18] + y[22]
    jac_trap[358,21] = -y[357]
    jac_trap[358,22] = y[356]
    jac_trap[358,23] = y[357]
    jac_trap[358,24] = -y[356]
    jac_trap[358,357] = y[21] - y[23]
    jac_trap[358,358] = -y[20] + y[22]
    jac_trap[361,25] = y[360]
    jac_trap[361,26] = y[361]
    jac_trap[361,31] = -y[360]
    jac_trap[361,32] = -y[361]
    jac_trap[361,361] = y[24] - y[30]
    jac_trap[361,362] = y[25] - y[31]
    jac_trap[362,27] = y[362]
    jac_trap[362,28] = y[363]
    jac_trap[362,31] = -y[362]
    jac_trap[362,32] = -y[363]
    jac_trap[362,363] = y[26] - y[30]
    jac_trap[362,364] = y[27] - y[31]
    jac_trap[363,29] = y[364]
    jac_trap[363,30] = y[365]
    jac_trap[363,31] = -y[364]
    jac_trap[363,32] = -y[365]
    jac_trap[363,365] = y[28] - y[30]
    jac_trap[363,366] = y[29] - y[31]
    jac_trap[364,25] = -y[361]
    jac_trap[364,26] = y[360]
    jac_trap[364,31] = y[361]
    jac_trap[364,32] = -y[360]
    jac_trap[364,361] = y[25] - y[31]
    jac_trap[364,362] = -y[24] + y[30]
    jac_trap[365,27] = -y[363]
    jac_trap[365,28] = y[362]
    jac_trap[365,31] = y[363]
    jac_trap[365,32] = -y[362]
    jac_trap[365,363] = y[27] - y[31]
    jac_trap[365,364] = -y[26] + y[30]
    jac_trap[366,29] = -y[365]
    jac_trap[366,30] = y[364]
    jac_trap[366,31] = y[365]
    jac_trap[366,32] = -y[364]
    jac_trap[366,365] = y[29] - y[31]
    jac_trap[366,366] = -y[28] + y[30]
    jac_trap[369,33] = y[368]
    jac_trap[369,34] = y[369]
    jac_trap[369,39] = -y[368]
    jac_trap[369,40] = -y[369]
    jac_trap[369,369] = y[32] - y[38]
    jac_trap[369,370] = y[33] - y[39]
    jac_trap[370,35] = y[370]
    jac_trap[370,36] = y[371]
    jac_trap[370,39] = -y[370]
    jac_trap[370,40] = -y[371]
    jac_trap[370,371] = y[34] - y[38]
    jac_trap[370,372] = y[35] - y[39]
    jac_trap[371,37] = y[372]
    jac_trap[371,38] = y[373]
    jac_trap[371,39] = -y[372]
    jac_trap[371,40] = -y[373]
    jac_trap[371,373] = y[36] - y[38]
    jac_trap[371,374] = y[37] - y[39]
    jac_trap[372,33] = -y[369]
    jac_trap[372,34] = y[368]
    jac_trap[372,39] = y[369]
    jac_trap[372,40] = -y[368]
    jac_trap[372,369] = y[33] - y[39]
    jac_trap[372,370] = -y[32] + y[38]
    jac_trap[373,35] = -y[371]
    jac_trap[373,36] = y[370]
    jac_trap[373,39] = y[371]
    jac_trap[373,40] = -y[370]
    jac_trap[373,371] = y[35] - y[39]
    jac_trap[373,372] = -y[34] + y[38]
    jac_trap[374,37] = -y[373]
    jac_trap[374,38] = y[372]
    jac_trap[374,39] = y[373]
    jac_trap[374,40] = -y[372]
    jac_trap[374,373] = y[37] - y[39]
    jac_trap[374,374] = -y[36] + y[38]
    jac_trap[377,41] = y[376]
    jac_trap[377,42] = y[377]
    jac_trap[377,47] = -y[376]
    jac_trap[377,48] = -y[377]
    jac_trap[377,377] = y[40] - y[46]
    jac_trap[377,378] = y[41] - y[47]
    jac_trap[378,43] = y[378]
    jac_trap[378,44] = y[379]
    jac_trap[378,47] = -y[378]
    jac_trap[378,48] = -y[379]
    jac_trap[378,379] = y[42] - y[46]
    jac_trap[378,380] = y[43] - y[47]
    jac_trap[379,45] = y[380]
    jac_trap[379,46] = y[381]
    jac_trap[379,47] = -y[380]
    jac_trap[379,48] = -y[381]
    jac_trap[379,381] = y[44] - y[46]
    jac_trap[379,382] = y[45] - y[47]
    jac_trap[380,41] = -y[377]
    jac_trap[380,42] = y[376]
    jac_trap[380,47] = y[377]
    jac_trap[380,48] = -y[376]
    jac_trap[380,377] = y[41] - y[47]
    jac_trap[380,378] = -y[40] + y[46]
    jac_trap[381,43] = -y[379]
    jac_trap[381,44] = y[378]
    jac_trap[381,47] = y[379]
    jac_trap[381,48] = -y[378]
    jac_trap[381,379] = y[43] - y[47]
    jac_trap[381,380] = -y[42] + y[46]
    jac_trap[382,45] = -y[381]
    jac_trap[382,46] = y[380]
    jac_trap[382,47] = y[381]
    jac_trap[382,48] = -y[380]
    jac_trap[382,381] = y[45] - y[47]
    jac_trap[382,382] = -y[44] + y[46]
    jac_trap[385,49] = y[384]
    jac_trap[385,50] = 1.0*y[385]
    jac_trap[385,51] = -y[384]
    jac_trap[385,52] = -1.0*y[385]
    jac_trap[385,385] = y[48] - y[50]
    jac_trap[385,386] = 1.0*y[49] - 1.0*y[51]
    jac_trap[386,49] = -1.0*y[385]
    jac_trap[386,50] = 1.0*y[384]
    jac_trap[386,51] = 1.0*y[385]
    jac_trap[386,52] = -1.0*y[384]
    jac_trap[386,385] = 1.0*y[49] - 1.0*y[51]
    jac_trap[386,386] = -1.0*y[48] + 1.0*y[50]
    jac_trap[389,53] = y[388]
    jac_trap[389,54] = 1.0*y[389]
    jac_trap[389,55] = -y[388]
    jac_trap[389,56] = -1.0*y[389]
    jac_trap[389,389] = y[52] - y[54]
    jac_trap[389,390] = 1.0*y[53] - 1.0*y[55]
    jac_trap[390,53] = -1.0*y[389]
    jac_trap[390,54] = 1.0*y[388]
    jac_trap[390,55] = 1.0*y[389]
    jac_trap[390,56] = -1.0*y[388]
    jac_trap[390,389] = 1.0*y[53] - 1.0*y[55]
    jac_trap[390,390] = -1.0*y[52] + 1.0*y[54]
    jac_trap[393,57] = y[392]
    jac_trap[393,58] = 1.0*y[393]
    jac_trap[393,59] = -y[392]
    jac_trap[393,60] = -1.0*y[393]
    jac_trap[393,393] = y[56] - y[58]
    jac_trap[393,394] = 1.0*y[57] - 1.0*y[59]
    jac_trap[394,57] = -1.0*y[393]
    jac_trap[394,58] = 1.0*y[392]
    jac_trap[394,59] = 1.0*y[393]
    jac_trap[394,60] = -1.0*y[392]
    jac_trap[394,393] = 1.0*y[57] - 1.0*y[59]
    jac_trap[394,394] = -1.0*y[56] + 1.0*y[58]
    jac_trap[397,61] = y[396]
    jac_trap[397,62] = 1.0*y[397]
    jac_trap[397,63] = -y[396]
    jac_trap[397,64] = -1.0*y[397]
    jac_trap[397,397] = y[60] - y[62]
    jac_trap[397,398] = 1.0*y[61] - 1.0*y[63]
    jac_trap[398,61] = -1.0*y[397]
    jac_trap[398,62] = 1.0*y[396]
    jac_trap[398,63] = 1.0*y[397]
    jac_trap[398,64] = -1.0*y[396]
    jac_trap[398,397] = 1.0*y[61] - 1.0*y[63]
    jac_trap[398,398] = -1.0*y[60] + 1.0*y[62]
    jac_trap[401,65] = y[400]
    jac_trap[401,66] = 1.0*y[401]
    jac_trap[401,67] = -y[400]
    jac_trap[401,68] = -1.0*y[401]
    jac_trap[401,401] = y[64] - y[66]
    jac_trap[401,402] = 1.0*y[65] - 1.0*y[67]
    jac_trap[402,65] = -1.0*y[401]
    jac_trap[402,66] = 1.0*y[400]
    jac_trap[402,67] = 1.0*y[401]
    jac_trap[402,68] = -1.0*y[400]
    jac_trap[402,401] = 1.0*y[65] - 1.0*y[67]
    jac_trap[402,402] = -1.0*y[64] + 1.0*y[66]
    jac_trap[405,1] = y[404]
    jac_trap[405,2] = 1.0*y[405]
    jac_trap[405,7] = -y[404]
    jac_trap[405,8] = -1.0*y[405]
    jac_trap[405,405] = y[0] - y[6]
    jac_trap[405,406] = 1.0*y[1] - 1.0*y[7]
    jac_trap[406,1] = -1.0*y[405]
    jac_trap[406,2] = 1.0*y[404]
    jac_trap[406,7] = 1.0*y[405]
    jac_trap[406,8] = -1.0*y[404]
    jac_trap[406,405] = 1.0*y[1] - 1.0*y[7]
    jac_trap[406,406] = -1.0*y[0] + 1.0*y[6]
    jac_trap[407,3] = y[406]
    jac_trap[407,4] = 1.0*y[407]
    jac_trap[407,7] = -y[406]
    jac_trap[407,8] = -1.0*y[407]
    jac_trap[407,407] = y[2] - y[6]
    jac_trap[407,408] = 1.0*y[3] - 1.0*y[7]
    jac_trap[408,3] = -1.0*y[407]
    jac_trap[408,4] = 1.0*y[406]
    jac_trap[408,7] = 1.0*y[407]
    jac_trap[408,8] = -1.0*y[406]
    jac_trap[408,407] = 1.0*y[3] - 1.0*y[7]
    jac_trap[408,408] = -1.0*y[2] + 1.0*y[6]
    jac_trap[409,5] = y[408]
    jac_trap[409,6] = 1.0*y[409]
    jac_trap[409,7] = -y[408]
    jac_trap[409,8] = -1.0*y[409]
    jac_trap[409,409] = y[4] - y[6]
    jac_trap[409,410] = 1.0*y[5] - 1.0*y[7]
    jac_trap[410,5] = -1.0*y[409]
    jac_trap[410,6] = 1.0*y[408]
    jac_trap[410,7] = 1.0*y[409]
    jac_trap[410,8] = -1.0*y[408]
    jac_trap[410,409] = 1.0*y[5] - 1.0*y[7]
    jac_trap[410,410] = -1.0*y[4] + 1.0*y[6]
    jac_trap[411,413] = Piecewise(np.array([(-1, y[411] < 0), (1, True)]))
    jac_trap[412,255] = y[164]
    jac_trap[413,405] = -p[1]*y[404]/sqrt(y[405]**2 + y[404]**2 + 0.1) - 2*p[2]*y[404]
    jac_trap[413,406] = -p[1]*y[405]/sqrt(y[405]**2 + y[404]**2 + 0.1) - 2*p[2]*y[405]
    jac_trap[414,133] = y[413]
    jac_trap[414,134] = 1.0*y[414]
    jac_trap[414,139] = -y[413]
    jac_trap[414,140] = -1.0*y[414]
    jac_trap[414,414] = y[132] - y[138]
    jac_trap[414,415] = 1.0*y[133] - 1.0*y[139]
    jac_trap[415,133] = -1.0*y[414]
    jac_trap[415,134] = 1.0*y[413]
    jac_trap[415,139] = 1.0*y[414]
    jac_trap[415,140] = -1.0*y[413]
    jac_trap[415,414] = 1.0*y[133] - 1.0*y[139]
    jac_trap[415,415] = -1.0*y[132] + 1.0*y[138]
    jac_trap[416,135] = y[415]
    jac_trap[416,136] = 1.0*y[416]
    jac_trap[416,139] = -y[415]
    jac_trap[416,140] = -1.0*y[416]
    jac_trap[416,416] = y[134] - y[138]
    jac_trap[416,417] = 1.0*y[135] - 1.0*y[139]
    jac_trap[417,135] = -1.0*y[416]
    jac_trap[417,136] = 1.0*y[415]
    jac_trap[417,139] = 1.0*y[416]
    jac_trap[417,140] = -1.0*y[415]
    jac_trap[417,416] = 1.0*y[135] - 1.0*y[139]
    jac_trap[417,417] = -1.0*y[134] + 1.0*y[138]
    jac_trap[418,137] = y[417]
    jac_trap[418,138] = 1.0*y[418]
    jac_trap[418,139] = -y[417]
    jac_trap[418,140] = -1.0*y[418]
    jac_trap[418,418] = y[136] - y[138]
    jac_trap[418,419] = 1.0*y[137] - 1.0*y[139]
    jac_trap[419,137] = -1.0*y[418]
    jac_trap[419,138] = 1.0*y[417]
    jac_trap[419,139] = 1.0*y[418]
    jac_trap[419,140] = -1.0*y[417]
    jac_trap[419,418] = 1.0*y[137] - 1.0*y[139]
    jac_trap[419,419] = -1.0*y[136] + 1.0*y[138]
    jac_trap[420,199] = -y[421]/(y[198] - y[204] + 1.0e-8)**2
    jac_trap[420,205] = y[421]/(y[198] - y[204] + 1.0e-8)**2
    jac_trap[420,422] = 1/(y[198] - y[204] + 1.0e-8)
    jac_trap[421,199] = y[421]/(-y[198] + y[204] + 1.0e-8)**2
    jac_trap[421,205] = -y[421]/(-y[198] + y[204] + 1.0e-8)**2
    jac_trap[421,422] = 1/(-y[198] + y[204] + 1.0e-8)
    jac_trap[422,423] = -Piecewise(np.array([(-1, y[421] < 0), (1, True)]))
    jac_trap[423,414] = -p[4]*y[413]/sqrt(y[414]**2 + y[413]**2 + 0.1) - 2*p[5]*y[413]
    jac_trap[423,415] = -p[4]*y[414]/sqrt(y[414]**2 + y[413]**2 + 0.1) - 2*p[5]*y[414]
    jac_trap[424,157] = y[423]
    jac_trap[424,158] = 1.0*y[424]
    jac_trap[424,163] = -y[423]
    jac_trap[424,164] = -1.0*y[424]
    jac_trap[424,424] = y[156] - y[162]
    jac_trap[424,425] = 1.0*y[157] - 1.0*y[163]
    jac_trap[425,157] = -1.0*y[424]
    jac_trap[425,158] = 1.0*y[423]
    jac_trap[425,163] = 1.0*y[424]
    jac_trap[425,164] = -1.0*y[423]
    jac_trap[425,424] = 1.0*y[157] - 1.0*y[163]
    jac_trap[425,425] = -1.0*y[156] + 1.0*y[162]
    jac_trap[426,159] = y[425]
    jac_trap[426,160] = 1.0*y[426]
    jac_trap[426,163] = -y[425]
    jac_trap[426,164] = -1.0*y[426]
    jac_trap[426,426] = y[158] - y[162]
    jac_trap[426,427] = 1.0*y[159] - 1.0*y[163]
    jac_trap[427,159] = -1.0*y[426]
    jac_trap[427,160] = 1.0*y[425]
    jac_trap[427,163] = 1.0*y[426]
    jac_trap[427,164] = -1.0*y[425]
    jac_trap[427,426] = 1.0*y[159] - 1.0*y[163]
    jac_trap[427,427] = -1.0*y[158] + 1.0*y[162]
    jac_trap[428,161] = y[427]
    jac_trap[428,162] = 1.0*y[428]
    jac_trap[428,163] = -y[427]
    jac_trap[428,164] = -1.0*y[428]
    jac_trap[428,428] = y[160] - y[162]
    jac_trap[428,429] = 1.0*y[161] - 1.0*y[163]
    jac_trap[429,161] = -1.0*y[428]
    jac_trap[429,162] = 1.0*y[427]
    jac_trap[429,163] = 1.0*y[428]
    jac_trap[429,164] = -1.0*y[427]
    jac_trap[429,428] = 1.0*y[161] - 1.0*y[163]
    jac_trap[429,429] = -1.0*y[160] + 1.0*y[162]
    jac_trap[430,223] = -y[431]/(y[222] - y[228] + 1.0e-8)**2
    jac_trap[430,229] = y[431]/(y[222] - y[228] + 1.0e-8)**2
    jac_trap[430,432] = 1/(y[222] - y[228] + 1.0e-8)
    jac_trap[431,223] = y[431]/(-y[222] + y[228] + 1.0e-8)**2
    jac_trap[431,229] = -y[431]/(-y[222] + y[228] + 1.0e-8)**2
    jac_trap[431,432] = 1/(-y[222] + y[228] + 1.0e-8)
    jac_trap[432,433] = -Piecewise(np.array([(-1, y[431] < 0), (1, True)]))
    jac_trap[433,424] = -p[10]*y[423]/sqrt(y[424]**2 + y[423]**2 + 0.1) - 2*p[11]*y[423]
    jac_trap[433,425] = -p[10]*y[424]/sqrt(y[424]**2 + y[423]**2 + 0.1) - 2*p[11]*y[424]

@numba.njit(cache=True)
def jac_trap_eval_up(jac_trap,x,y,u,p,Dt,xyup = 1):

    jac_trap[0,0] = 0.5*Dt + 1
    jac_trap[412,249] = u[6]

def jac_trap_eval_num(jac_trap,x,y,u,p,Dt,xyup = 1):

    jac_trap[1,1] = -123.954122254357
    jac_trap[1,2] = -127.595184532966
    jac_trap[1,3] = 39.6392229058202
    jac_trap[1,4] = 10.2713736253513
    jac_trap[1,5] = 24.9575997948692
    jac_trap[1,6] = 23.2849644809540
    jac_trap[1,7] = 58.0215758469966
    jac_trap[1,8] = 83.8007853900572
    jac_trap[1,69] = 105.571769313180
    jac_trap[1,70] = 54.0657727682604
    jac_trap[1,71] = -39.6392229058202
    jac_trap[1,72] = -10.2713736253513
    jac_trap[1,73] = -24.9575997948692
    jac_trap[1,74] = -23.2849644809540
    jac_trap[1,75] = -39.6392229058202
    jac_trap[1,76] = -10.2713736253513
    jac_trap[1,337] = 1
    jac_trap[1,405] = 1
    jac_trap[2,1] = 127.595184532966
    jac_trap[2,2] = -123.954122254357
    jac_trap[2,3] = -10.2713736253513
    jac_trap[2,4] = 39.6392229058202
    jac_trap[2,5] = -23.2849644809540
    jac_trap[2,6] = 24.9575997948692
    jac_trap[2,7] = -83.8007853900572
    jac_trap[2,8] = 58.0215758469966
    jac_trap[2,69] = -54.0657727682604
    jac_trap[2,70] = 105.571769313180
    jac_trap[2,71] = 10.2713736253513
    jac_trap[2,72] = -39.6392229058202
    jac_trap[2,73] = 23.2849644809540
    jac_trap[2,74] = -24.9575997948692
    jac_trap[2,75] = 10.2713736253513
    jac_trap[2,76] = -39.6392229058202
    jac_trap[2,338] = 1
    jac_trap[2,406] = 1
    jac_trap[3,1] = 39.6392229058202
    jac_trap[3,2] = 10.2713736253513
    jac_trap[3,3] = -123.954122254357
    jac_trap[3,4] = -127.595184532966
    jac_trap[3,5] = 39.6392229058201
    jac_trap[3,6] = 10.2713736253513
    jac_trap[3,7] = 43.3399527360457
    jac_trap[3,8] = 96.8143762456598
    jac_trap[3,69] = -39.6392229058202
    jac_trap[3,70] = -10.2713736253513
    jac_trap[3,71] = 105.571769313180
    jac_trap[3,72] = 54.0657727682604
    jac_trap[3,73] = -39.6392229058201
    jac_trap[3,74] = -10.2713736253513
    jac_trap[3,75] = -24.9575997948692
    jac_trap[3,76] = -23.2849644809540
    jac_trap[3,339] = 1
    jac_trap[3,407] = 1
    jac_trap[4,1] = -10.2713736253513
    jac_trap[4,2] = 39.6392229058202
    jac_trap[4,3] = 127.595184532966
    jac_trap[4,4] = -123.954122254357
    jac_trap[4,5] = -10.2713736253513
    jac_trap[4,6] = 39.6392229058201
    jac_trap[4,7] = -96.8143762456598
    jac_trap[4,8] = 43.3399527360457
    jac_trap[4,69] = 10.2713736253513
    jac_trap[4,70] = -39.6392229058202
    jac_trap[4,71] = -54.0657727682604
    jac_trap[4,72] = 105.571769313180
    jac_trap[4,73] = 10.2713736253513
    jac_trap[4,74] = -39.6392229058201
    jac_trap[4,75] = 23.2849644809540
    jac_trap[4,76] = -24.9575997948692
    jac_trap[4,340] = 1
    jac_trap[4,408] = 1
    jac_trap[5,1] = 24.9575997948692
    jac_trap[5,2] = 23.2849644809540
    jac_trap[5,3] = 39.6392229058202
    jac_trap[5,4] = 10.2713736253513
    jac_trap[5,5] = -123.954122254357
    jac_trap[5,6] = -127.595184532966
    jac_trap[5,7] = 58.0215758469966
    jac_trap[5,8] = 83.8007853900572
    jac_trap[5,69] = -24.9575997948692
    jac_trap[5,70] = -23.2849644809540
    jac_trap[5,71] = -39.6392229058202
    jac_trap[5,72] = -10.2713736253513
    jac_trap[5,73] = 105.571769313180
    jac_trap[5,74] = 54.0657727682604
    jac_trap[5,75] = -39.6392229058201
    jac_trap[5,76] = -10.2713736253514
    jac_trap[5,341] = 1
    jac_trap[5,409] = 1
    jac_trap[6,1] = -23.2849644809540
    jac_trap[6,2] = 24.9575997948692
    jac_trap[6,3] = -10.2713736253513
    jac_trap[6,4] = 39.6392229058202
    jac_trap[6,5] = 127.595184532966
    jac_trap[6,6] = -123.954122254357
    jac_trap[6,7] = -83.8007853900572
    jac_trap[6,8] = 58.0215758469966
    jac_trap[6,69] = 23.2849644809540
    jac_trap[6,70] = -24.9575997948692
    jac_trap[6,71] = 10.2713736253513
    jac_trap[6,72] = -39.6392229058202
    jac_trap[6,73] = -54.0657727682604
    jac_trap[6,74] = 105.571769313180
    jac_trap[6,75] = 10.2713736253514
    jac_trap[6,76] = -39.6392229058201
    jac_trap[6,342] = 1
    jac_trap[6,410] = 1
    jac_trap[7,1] = 58.0215758469966
    jac_trap[7,2] = 83.8007853900572
    jac_trap[7,3] = 43.3399527360457
    jac_trap[7,4] = 96.8143762456598
    jac_trap[7,5] = 58.0215758469966
    jac_trap[7,6] = 83.8007853900572
    jac_trap[7,7] = -161.052161470043
    jac_trap[7,8] = -274.654008062378
    jac_trap[7,69] = -39.6392229058202
    jac_trap[7,70] = -10.2713736253513
    jac_trap[7,71] = -24.9575997948692
    jac_trap[7,72] = -23.2849644809540
    jac_trap[7,73] = -39.6392229058202
    jac_trap[7,74] = -10.2713736253513
    jac_trap[7,75] = 105.571769313180
    jac_trap[7,76] = 54.0657727682604
    jac_trap[8,1] = -83.8007853900572
    jac_trap[8,2] = 58.0215758469966
    jac_trap[8,3] = -96.8143762456598
    jac_trap[8,4] = 43.3399527360457
    jac_trap[8,5] = -83.8007853900572
    jac_trap[8,6] = 58.0215758469966
    jac_trap[8,7] = 274.654008062378
    jac_trap[8,8] = -161.052161470043
    jac_trap[8,69] = 10.2713736253513
    jac_trap[8,70] = -39.6392229058202
    jac_trap[8,71] = 23.2849644809540
    jac_trap[8,72] = -24.9575997948692
    jac_trap[8,73] = 10.2713736253513
    jac_trap[8,74] = -39.6392229058202
    jac_trap[8,75] = -54.0657727682604
    jac_trap[8,76] = 105.571769313180
    jac_trap[9,9] = -26.5300693004806
    jac_trap[9,10] = -4.84676915585801
    jac_trap[9,11] = 7.89461337514770
    jac_trap[9,12] = -1.58482814504483
    jac_trap[9,13] = 7.72144347466701
    jac_trap[9,14] = -0.679918453285310
    jac_trap[9,15] = 7.89461337514771
    jac_trap[9,16] = -1.58482814504483
    jac_trap[9,77] = 26.5300693004806
    jac_trap[9,78] = 4.84676915585801
    jac_trap[9,79] = -7.89461337514770
    jac_trap[9,80] = 1.58482814504483
    jac_trap[9,81] = -7.72144347466701
    jac_trap[9,82] = 0.679918453285310
    jac_trap[9,83] = -7.89461337514771
    jac_trap[9,84] = 1.58482814504483
    jac_trap[9,345] = 1
    jac_trap[10,9] = 4.84676915585801
    jac_trap[10,10] = -26.5300693004806
    jac_trap[10,11] = 1.58482814504483
    jac_trap[10,12] = 7.89461337514770
    jac_trap[10,13] = 0.679918453285310
    jac_trap[10,14] = 7.72144347466701
    jac_trap[10,15] = 1.58482814504483
    jac_trap[10,16] = 7.89461337514771
    jac_trap[10,77] = -4.84676915585801
    jac_trap[10,78] = 26.5300693004806
    jac_trap[10,79] = -1.58482814504483
    jac_trap[10,80] = -7.89461337514770
    jac_trap[10,81] = -0.679918453285310
    jac_trap[10,82] = -7.72144347466701
    jac_trap[10,83] = -1.58482814504483
    jac_trap[10,84] = -7.89461337514771
    jac_trap[10,346] = 1
    jac_trap[11,9] = 7.89461337514771
    jac_trap[11,10] = -1.58482814504483
    jac_trap[11,11] = -26.5300693004806
    jac_trap[11,12] = -4.84676915585801
    jac_trap[11,13] = 7.89461337514771
    jac_trap[11,14] = -1.58482814504483
    jac_trap[11,15] = 7.72144347466701
    jac_trap[11,16] = -0.679918453285308
    jac_trap[11,77] = -7.89461337514771
    jac_trap[11,78] = 1.58482814504483
    jac_trap[11,79] = 26.5300693004806
    jac_trap[11,80] = 4.84676915585801
    jac_trap[11,81] = -7.89461337514771
    jac_trap[11,82] = 1.58482814504483
    jac_trap[11,83] = -7.72144347466701
    jac_trap[11,84] = 0.679918453285308
    jac_trap[11,347] = 1
    jac_trap[12,9] = 1.58482814504483
    jac_trap[12,10] = 7.89461337514771
    jac_trap[12,11] = 4.84676915585801
    jac_trap[12,12] = -26.5300693004806
    jac_trap[12,13] = 1.58482814504483
    jac_trap[12,14] = 7.89461337514771
    jac_trap[12,15] = 0.679918453285308
    jac_trap[12,16] = 7.72144347466701
    jac_trap[12,77] = -1.58482814504483
    jac_trap[12,78] = -7.89461337514771
    jac_trap[12,79] = -4.84676915585801
    jac_trap[12,80] = 26.5300693004806
    jac_trap[12,81] = -1.58482814504483
    jac_trap[12,82] = -7.89461337514771
    jac_trap[12,83] = -0.679918453285308
    jac_trap[12,84] = -7.72144347466701
    jac_trap[12,348] = 1
    jac_trap[13,9] = 7.72144347466701
    jac_trap[13,10] = -0.679918453285310
    jac_trap[13,11] = 7.89461337514770
    jac_trap[13,12] = -1.58482814504483
    jac_trap[13,13] = -26.5300693004806
    jac_trap[13,14] = -4.84676915585801
    jac_trap[13,15] = 7.89461337514771
    jac_trap[13,16] = -1.58482814504483
    jac_trap[13,77] = -7.72144347466701
    jac_trap[13,78] = 0.679918453285310
    jac_trap[13,79] = -7.89461337514770
    jac_trap[13,80] = 1.58482814504483
    jac_trap[13,81] = 26.5300693004806
    jac_trap[13,82] = 4.84676915585801
    jac_trap[13,83] = -7.89461337514771
    jac_trap[13,84] = 1.58482814504483
    jac_trap[13,349] = 1
    jac_trap[14,9] = 0.679918453285310
    jac_trap[14,10] = 7.72144347466701
    jac_trap[14,11] = 1.58482814504483
    jac_trap[14,12] = 7.89461337514770
    jac_trap[14,13] = 4.84676915585801
    jac_trap[14,14] = -26.5300693004806
    jac_trap[14,15] = 1.58482814504483
    jac_trap[14,16] = 7.89461337514771
    jac_trap[14,77] = -0.679918453285310
    jac_trap[14,78] = -7.72144347466701
    jac_trap[14,79] = -1.58482814504483
    jac_trap[14,80] = -7.89461337514770
    jac_trap[14,81] = -4.84676915585801
    jac_trap[14,82] = 26.5300693004806
    jac_trap[14,83] = -1.58482814504483
    jac_trap[14,84] = -7.89461337514771
    jac_trap[14,350] = 1
    jac_trap[15,9] = 7.89461337514771
    jac_trap[15,10] = -1.58482814504483
    jac_trap[15,11] = 7.72144347466701
    jac_trap[15,12] = -0.679918453285308
    jac_trap[15,13] = 7.89461337514771
    jac_trap[15,14] = -1.58482814504483
    jac_trap[15,15] = -26.5550693004806
    jac_trap[15,16] = -4.84676915585801
    jac_trap[15,77] = -7.89461337514771
    jac_trap[15,78] = 1.58482814504483
    jac_trap[15,79] = -7.72144347466701
    jac_trap[15,80] = 0.679918453285308
    jac_trap[15,81] = -7.89461337514771
    jac_trap[15,82] = 1.58482814504483
    jac_trap[15,83] = 26.5300693004806
    jac_trap[15,84] = 4.84676915585801
    jac_trap[16,9] = 1.58482814504483
    jac_trap[16,10] = 7.89461337514771
    jac_trap[16,11] = 0.679918453285308
    jac_trap[16,12] = 7.72144347466701
    jac_trap[16,13] = 1.58482814504483
    jac_trap[16,14] = 7.89461337514771
    jac_trap[16,15] = 4.84676915585801
    jac_trap[16,16] = -26.5550693004806
    jac_trap[16,77] = -1.58482814504483
    jac_trap[16,78] = -7.89461337514771
    jac_trap[16,79] = -0.679918453285308
    jac_trap[16,80] = -7.72144347466701
    jac_trap[16,81] = -1.58482814504483
    jac_trap[16,82] = -7.89461337514771
    jac_trap[16,83] = -4.84676915585801
    jac_trap[16,84] = 26.5300693004806
    jac_trap[17,17] = -26.5300693004806
    jac_trap[17,18] = -4.84676915585801
    jac_trap[17,19] = 7.89461337514770
    jac_trap[17,20] = -1.58482814504483
    jac_trap[17,21] = 7.72144347466701
    jac_trap[17,22] = -0.679918453285310
    jac_trap[17,23] = 7.89461337514771
    jac_trap[17,24] = -1.58482814504483
    jac_trap[17,157] = 26.5300693004806
    jac_trap[17,158] = 4.84676915585801
    jac_trap[17,159] = -7.89461337514770
    jac_trap[17,160] = 1.58482814504483
    jac_trap[17,161] = -7.72144347466701
    jac_trap[17,162] = 0.679918453285310
    jac_trap[17,163] = -7.89461337514771
    jac_trap[17,164] = 1.58482814504483
    jac_trap[17,353] = 1
    jac_trap[18,17] = 4.84676915585801
    jac_trap[18,18] = -26.5300693004806
    jac_trap[18,19] = 1.58482814504483
    jac_trap[18,20] = 7.89461337514770
    jac_trap[18,21] = 0.679918453285310
    jac_trap[18,22] = 7.72144347466701
    jac_trap[18,23] = 1.58482814504483
    jac_trap[18,24] = 7.89461337514771
    jac_trap[18,157] = -4.84676915585801
    jac_trap[18,158] = 26.5300693004806
    jac_trap[18,159] = -1.58482814504483
    jac_trap[18,160] = -7.89461337514770
    jac_trap[18,161] = -0.679918453285310
    jac_trap[18,162] = -7.72144347466701
    jac_trap[18,163] = -1.58482814504483
    jac_trap[18,164] = -7.89461337514771
    jac_trap[18,354] = 1
    jac_trap[19,17] = 7.89461337514771
    jac_trap[19,18] = -1.58482814504483
    jac_trap[19,19] = -26.5300693004806
    jac_trap[19,20] = -4.84676915585801
    jac_trap[19,21] = 7.89461337514771
    jac_trap[19,22] = -1.58482814504483
    jac_trap[19,23] = 7.72144347466701
    jac_trap[19,24] = -0.679918453285308
    jac_trap[19,157] = -7.89461337514771
    jac_trap[19,158] = 1.58482814504483
    jac_trap[19,159] = 26.5300693004806
    jac_trap[19,160] = 4.84676915585801
    jac_trap[19,161] = -7.89461337514771
    jac_trap[19,162] = 1.58482814504483
    jac_trap[19,163] = -7.72144347466701
    jac_trap[19,164] = 0.679918453285308
    jac_trap[19,355] = 1
    jac_trap[20,17] = 1.58482814504483
    jac_trap[20,18] = 7.89461337514771
    jac_trap[20,19] = 4.84676915585801
    jac_trap[20,20] = -26.5300693004806
    jac_trap[20,21] = 1.58482814504483
    jac_trap[20,22] = 7.89461337514771
    jac_trap[20,23] = 0.679918453285308
    jac_trap[20,24] = 7.72144347466701
    jac_trap[20,157] = -1.58482814504483
    jac_trap[20,158] = -7.89461337514771
    jac_trap[20,159] = -4.84676915585801
    jac_trap[20,160] = 26.5300693004806
    jac_trap[20,161] = -1.58482814504483
    jac_trap[20,162] = -7.89461337514771
    jac_trap[20,163] = -0.679918453285308
    jac_trap[20,164] = -7.72144347466701
    jac_trap[20,356] = 1
    jac_trap[21,17] = 7.72144347466701
    jac_trap[21,18] = -0.679918453285310
    jac_trap[21,19] = 7.89461337514770
    jac_trap[21,20] = -1.58482814504483
    jac_trap[21,21] = -26.5300693004806
    jac_trap[21,22] = -4.84676915585801
    jac_trap[21,23] = 7.89461337514771
    jac_trap[21,24] = -1.58482814504483
    jac_trap[21,157] = -7.72144347466701
    jac_trap[21,158] = 0.679918453285310
    jac_trap[21,159] = -7.89461337514770
    jac_trap[21,160] = 1.58482814504483
    jac_trap[21,161] = 26.5300693004806
    jac_trap[21,162] = 4.84676915585801
    jac_trap[21,163] = -7.89461337514771
    jac_trap[21,164] = 1.58482814504483
    jac_trap[21,357] = 1
    jac_trap[22,17] = 0.679918453285310
    jac_trap[22,18] = 7.72144347466701
    jac_trap[22,19] = 1.58482814504483
    jac_trap[22,20] = 7.89461337514770
    jac_trap[22,21] = 4.84676915585801
    jac_trap[22,22] = -26.5300693004806
    jac_trap[22,23] = 1.58482814504483
    jac_trap[22,24] = 7.89461337514771
    jac_trap[22,157] = -0.679918453285310
    jac_trap[22,158] = -7.72144347466701
    jac_trap[22,159] = -1.58482814504483
    jac_trap[22,160] = -7.89461337514770
    jac_trap[22,161] = -4.84676915585801
    jac_trap[22,162] = 26.5300693004806
    jac_trap[22,163] = -1.58482814504483
    jac_trap[22,164] = -7.89461337514771
    jac_trap[22,358] = 1
    jac_trap[23,17] = 7.89461337514771
    jac_trap[23,18] = -1.58482814504483
    jac_trap[23,19] = 7.72144347466701
    jac_trap[23,20] = -0.679918453285308
    jac_trap[23,21] = 7.89461337514771
    jac_trap[23,22] = -1.58482814504483
    jac_trap[23,23] = -26.5550693004806
    jac_trap[23,24] = -4.84676915585801
    jac_trap[23,157] = -7.89461337514771
    jac_trap[23,158] = 1.58482814504483
    jac_trap[23,159] = -7.72144347466701
    jac_trap[23,160] = 0.679918453285308
    jac_trap[23,161] = -7.89461337514771
    jac_trap[23,162] = 1.58482814504483
    jac_trap[23,163] = 26.5300693004806
    jac_trap[23,164] = 4.84676915585801
    jac_trap[24,17] = 1.58482814504483
    jac_trap[24,18] = 7.89461337514771
    jac_trap[24,19] = 0.679918453285308
    jac_trap[24,20] = 7.72144347466701
    jac_trap[24,21] = 1.58482814504483
    jac_trap[24,22] = 7.89461337514771
    jac_trap[24,23] = 4.84676915585801
    jac_trap[24,24] = -26.5550693004806
    jac_trap[24,157] = -1.58482814504483
    jac_trap[24,158] = -7.89461337514771
    jac_trap[24,159] = -0.679918453285308
    jac_trap[24,160] = -7.72144347466701
    jac_trap[24,161] = -1.58482814504483
    jac_trap[24,162] = -7.89461337514771
    jac_trap[24,163] = -4.84676915585801
    jac_trap[24,164] = 26.5300693004806
    jac_trap[25,25] = -30.9517475172273
    jac_trap[25,26] = -5.65456401516768
    jac_trap[25,27] = 9.21038227100566
    jac_trap[25,28] = -1.84896616921897
    jac_trap[25,29] = 9.00835072044485
    jac_trap[25,30] = -0.793238195499529
    jac_trap[25,31] = 9.21038227100566
    jac_trap[25,32] = -1.84896616921897
    jac_trap[25,101] = 30.9517475172273
    jac_trap[25,102] = 5.65456401516768
    jac_trap[25,103] = -9.21038227100566
    jac_trap[25,104] = 1.84896616921897
    jac_trap[25,105] = -9.00835072044485
    jac_trap[25,106] = 0.793238195499529
    jac_trap[25,107] = -9.21038227100566
    jac_trap[25,108] = 1.84896616921897
    jac_trap[25,361] = 1
    jac_trap[26,25] = 5.65456401516768
    jac_trap[26,26] = -30.9517475172273
    jac_trap[26,27] = 1.84896616921897
    jac_trap[26,28] = 9.21038227100566
    jac_trap[26,29] = 0.793238195499529
    jac_trap[26,30] = 9.00835072044485
    jac_trap[26,31] = 1.84896616921897
    jac_trap[26,32] = 9.21038227100566
    jac_trap[26,101] = -5.65456401516768
    jac_trap[26,102] = 30.9517475172273
    jac_trap[26,103] = -1.84896616921897
    jac_trap[26,104] = -9.21038227100566
    jac_trap[26,105] = -0.793238195499529
    jac_trap[26,106] = -9.00835072044485
    jac_trap[26,107] = -1.84896616921897
    jac_trap[26,108] = -9.21038227100566
    jac_trap[26,362] = 1
    jac_trap[27,25] = 9.21038227100566
    jac_trap[27,26] = -1.84896616921897
    jac_trap[27,27] = -30.9517475172273
    jac_trap[27,28] = -5.65456401516768
    jac_trap[27,29] = 9.21038227100566
    jac_trap[27,30] = -1.84896616921897
    jac_trap[27,31] = 9.00835072044485
    jac_trap[27,32] = -0.793238195499528
    jac_trap[27,101] = -9.21038227100566
    jac_trap[27,102] = 1.84896616921897
    jac_trap[27,103] = 30.9517475172273
    jac_trap[27,104] = 5.65456401516768
    jac_trap[27,105] = -9.21038227100566
    jac_trap[27,106] = 1.84896616921897
    jac_trap[27,107] = -9.00835072044485
    jac_trap[27,108] = 0.793238195499528
    jac_trap[27,363] = 1
    jac_trap[28,25] = 1.84896616921897
    jac_trap[28,26] = 9.21038227100566
    jac_trap[28,27] = 5.65456401516768
    jac_trap[28,28] = -30.9517475172273
    jac_trap[28,29] = 1.84896616921897
    jac_trap[28,30] = 9.21038227100566
    jac_trap[28,31] = 0.793238195499528
    jac_trap[28,32] = 9.00835072044485
    jac_trap[28,101] = -1.84896616921897
    jac_trap[28,102] = -9.21038227100566
    jac_trap[28,103] = -5.65456401516768
    jac_trap[28,104] = 30.9517475172273
    jac_trap[28,105] = -1.84896616921897
    jac_trap[28,106] = -9.21038227100566
    jac_trap[28,107] = -0.793238195499528
    jac_trap[28,108] = -9.00835072044485
    jac_trap[28,364] = 1
    jac_trap[29,25] = 9.00835072044484
    jac_trap[29,26] = -0.793238195499527
    jac_trap[29,27] = 9.21038227100566
    jac_trap[29,28] = -1.84896616921897
    jac_trap[29,29] = -30.9517475172273
    jac_trap[29,30] = -5.65456401516768
    jac_trap[29,31] = 9.21038227100566
    jac_trap[29,32] = -1.84896616921897
    jac_trap[29,101] = -9.00835072044484
    jac_trap[29,102] = 0.793238195499527
    jac_trap[29,103] = -9.21038227100566
    jac_trap[29,104] = 1.84896616921897
    jac_trap[29,105] = 30.9517475172273
    jac_trap[29,106] = 5.65456401516768
    jac_trap[29,107] = -9.21038227100566
    jac_trap[29,108] = 1.84896616921897
    jac_trap[29,365] = 1
    jac_trap[30,25] = 0.793238195499527
    jac_trap[30,26] = 9.00835072044484
    jac_trap[30,27] = 1.84896616921897
    jac_trap[30,28] = 9.21038227100566
    jac_trap[30,29] = 5.65456401516768
    jac_trap[30,30] = -30.9517475172273
    jac_trap[30,31] = 1.84896616921897
    jac_trap[30,32] = 9.21038227100566
    jac_trap[30,101] = -0.793238195499527
    jac_trap[30,102] = -9.00835072044484
    jac_trap[30,103] = -1.84896616921897
    jac_trap[30,104] = -9.21038227100566
    jac_trap[30,105] = -5.65456401516768
    jac_trap[30,106] = 30.9517475172273
    jac_trap[30,107] = -1.84896616921897
    jac_trap[30,108] = -9.21038227100566
    jac_trap[30,366] = 1
    jac_trap[31,25] = 9.21038227100566
    jac_trap[31,26] = -1.84896616921897
    jac_trap[31,27] = 9.00835072044485
    jac_trap[31,28] = -0.793238195499527
    jac_trap[31,29] = 9.21038227100566
    jac_trap[31,30] = -1.84896616921897
    jac_trap[31,31] = -30.9767475172273
    jac_trap[31,32] = -5.65456401516768
    jac_trap[31,101] = -9.21038227100566
    jac_trap[31,102] = 1.84896616921897
    jac_trap[31,103] = -9.00835072044485
    jac_trap[31,104] = 0.793238195499527
    jac_trap[31,105] = -9.21038227100566
    jac_trap[31,106] = 1.84896616921897
    jac_trap[31,107] = 30.9517475172273
    jac_trap[31,108] = 5.65456401516768
    jac_trap[32,25] = 1.84896616921897
    jac_trap[32,26] = 9.21038227100566
    jac_trap[32,27] = 0.793238195499527
    jac_trap[32,28] = 9.00835072044485
    jac_trap[32,29] = 1.84896616921897
    jac_trap[32,30] = 9.21038227100566
    jac_trap[32,31] = 5.65456401516768
    jac_trap[32,32] = -30.9767475172273
    jac_trap[32,101] = -1.84896616921897
    jac_trap[32,102] = -9.21038227100566
    jac_trap[32,103] = -0.793238195499527
    jac_trap[32,104] = -9.00835072044485
    jac_trap[32,105] = -1.84896616921897
    jac_trap[32,106] = -9.21038227100566
    jac_trap[32,107] = -5.65456401516768
    jac_trap[32,108] = 30.9517475172273
    jac_trap[33,33] = -30.9517475172273
    jac_trap[33,34] = -5.65456401516768
    jac_trap[33,35] = 9.21038227100566
    jac_trap[33,36] = -1.84896616921897
    jac_trap[33,37] = 9.00835072044485
    jac_trap[33,38] = -0.793238195499529
    jac_trap[33,39] = 9.21038227100566
    jac_trap[33,40] = -1.84896616921897
    jac_trap[33,125] = 30.9517475172273
    jac_trap[33,126] = 5.65456401516768
    jac_trap[33,127] = -9.21038227100566
    jac_trap[33,128] = 1.84896616921897
    jac_trap[33,129] = -9.00835072044485
    jac_trap[33,130] = 0.793238195499529
    jac_trap[33,131] = -9.21038227100566
    jac_trap[33,132] = 1.84896616921897
    jac_trap[33,369] = 1
    jac_trap[34,33] = 5.65456401516768
    jac_trap[34,34] = -30.9517475172273
    jac_trap[34,35] = 1.84896616921897
    jac_trap[34,36] = 9.21038227100566
    jac_trap[34,37] = 0.793238195499529
    jac_trap[34,38] = 9.00835072044485
    jac_trap[34,39] = 1.84896616921897
    jac_trap[34,40] = 9.21038227100566
    jac_trap[34,125] = -5.65456401516768
    jac_trap[34,126] = 30.9517475172273
    jac_trap[34,127] = -1.84896616921897
    jac_trap[34,128] = -9.21038227100566
    jac_trap[34,129] = -0.793238195499529
    jac_trap[34,130] = -9.00835072044485
    jac_trap[34,131] = -1.84896616921897
    jac_trap[34,132] = -9.21038227100566
    jac_trap[34,370] = 1
    jac_trap[35,33] = 9.21038227100566
    jac_trap[35,34] = -1.84896616921897
    jac_trap[35,35] = -30.9517475172273
    jac_trap[35,36] = -5.65456401516768
    jac_trap[35,37] = 9.21038227100566
    jac_trap[35,38] = -1.84896616921897
    jac_trap[35,39] = 9.00835072044485
    jac_trap[35,40] = -0.793238195499528
    jac_trap[35,125] = -9.21038227100566
    jac_trap[35,126] = 1.84896616921897
    jac_trap[35,127] = 30.9517475172273
    jac_trap[35,128] = 5.65456401516768
    jac_trap[35,129] = -9.21038227100566
    jac_trap[35,130] = 1.84896616921897
    jac_trap[35,131] = -9.00835072044485
    jac_trap[35,132] = 0.793238195499528
    jac_trap[35,371] = 1
    jac_trap[36,33] = 1.84896616921897
    jac_trap[36,34] = 9.21038227100566
    jac_trap[36,35] = 5.65456401516768
    jac_trap[36,36] = -30.9517475172273
    jac_trap[36,37] = 1.84896616921897
    jac_trap[36,38] = 9.21038227100566
    jac_trap[36,39] = 0.793238195499528
    jac_trap[36,40] = 9.00835072044485
    jac_trap[36,125] = -1.84896616921897
    jac_trap[36,126] = -9.21038227100566
    jac_trap[36,127] = -5.65456401516768
    jac_trap[36,128] = 30.9517475172273
    jac_trap[36,129] = -1.84896616921897
    jac_trap[36,130] = -9.21038227100566
    jac_trap[36,131] = -0.793238195499528
    jac_trap[36,132] = -9.00835072044485
    jac_trap[36,372] = 1
    jac_trap[37,33] = 9.00835072044484
    jac_trap[37,34] = -0.793238195499527
    jac_trap[37,35] = 9.21038227100566
    jac_trap[37,36] = -1.84896616921897
    jac_trap[37,37] = -30.9517475172273
    jac_trap[37,38] = -5.65456401516768
    jac_trap[37,39] = 9.21038227100566
    jac_trap[37,40] = -1.84896616921897
    jac_trap[37,125] = -9.00835072044484
    jac_trap[37,126] = 0.793238195499527
    jac_trap[37,127] = -9.21038227100566
    jac_trap[37,128] = 1.84896616921897
    jac_trap[37,129] = 30.9517475172273
    jac_trap[37,130] = 5.65456401516768
    jac_trap[37,131] = -9.21038227100566
    jac_trap[37,132] = 1.84896616921897
    jac_trap[37,373] = 1
    jac_trap[38,33] = 0.793238195499527
    jac_trap[38,34] = 9.00835072044484
    jac_trap[38,35] = 1.84896616921897
    jac_trap[38,36] = 9.21038227100566
    jac_trap[38,37] = 5.65456401516768
    jac_trap[38,38] = -30.9517475172273
    jac_trap[38,39] = 1.84896616921897
    jac_trap[38,40] = 9.21038227100566
    jac_trap[38,125] = -0.793238195499527
    jac_trap[38,126] = -9.00835072044484
    jac_trap[38,127] = -1.84896616921897
    jac_trap[38,128] = -9.21038227100566
    jac_trap[38,129] = -5.65456401516768
    jac_trap[38,130] = 30.9517475172273
    jac_trap[38,131] = -1.84896616921897
    jac_trap[38,132] = -9.21038227100566
    jac_trap[38,374] = 1
    jac_trap[39,33] = 9.21038227100566
    jac_trap[39,34] = -1.84896616921897
    jac_trap[39,35] = 9.00835072044485
    jac_trap[39,36] = -0.793238195499527
    jac_trap[39,37] = 9.21038227100566
    jac_trap[39,38] = -1.84896616921897
    jac_trap[39,39] = -30.9767475172273
    jac_trap[39,40] = -5.65456401516768
    jac_trap[39,125] = -9.21038227100566
    jac_trap[39,126] = 1.84896616921897
    jac_trap[39,127] = -9.00835072044485
    jac_trap[39,128] = 0.793238195499527
    jac_trap[39,129] = -9.21038227100566
    jac_trap[39,130] = 1.84896616921897
    jac_trap[39,131] = 30.9517475172273
    jac_trap[39,132] = 5.65456401516768
    jac_trap[40,33] = 1.84896616921897
    jac_trap[40,34] = 9.21038227100566
    jac_trap[40,35] = 0.793238195499527
    jac_trap[40,36] = 9.00835072044485
    jac_trap[40,37] = 1.84896616921897
    jac_trap[40,38] = 9.21038227100566
    jac_trap[40,39] = 5.65456401516768
    jac_trap[40,40] = -30.9767475172273
    jac_trap[40,125] = -1.84896616921897
    jac_trap[40,126] = -9.21038227100566
    jac_trap[40,127] = -0.793238195499527
    jac_trap[40,128] = -9.00835072044485
    jac_trap[40,129] = -1.84896616921897
    jac_trap[40,130] = -9.21038227100566
    jac_trap[40,131] = -5.65456401516768
    jac_trap[40,132] = 30.9517475172273
    jac_trap[41,41] = -30.9517475172273
    jac_trap[41,42] = -5.65456401516768
    jac_trap[41,43] = 9.21038227100566
    jac_trap[41,44] = -1.84896616921897
    jac_trap[41,45] = 9.00835072044485
    jac_trap[41,46] = -0.793238195499529
    jac_trap[41,47] = 9.21038227100566
    jac_trap[41,48] = -1.84896616921897
    jac_trap[41,133] = 30.9517475172273
    jac_trap[41,134] = 5.65456401516768
    jac_trap[41,135] = -9.21038227100566
    jac_trap[41,136] = 1.84896616921897
    jac_trap[41,137] = -9.00835072044485
    jac_trap[41,138] = 0.793238195499529
    jac_trap[41,139] = -9.21038227100566
    jac_trap[41,140] = 1.84896616921897
    jac_trap[41,377] = 1
    jac_trap[42,41] = 5.65456401516768
    jac_trap[42,42] = -30.9517475172273
    jac_trap[42,43] = 1.84896616921897
    jac_trap[42,44] = 9.21038227100566
    jac_trap[42,45] = 0.793238195499529
    jac_trap[42,46] = 9.00835072044485
    jac_trap[42,47] = 1.84896616921897
    jac_trap[42,48] = 9.21038227100566
    jac_trap[42,133] = -5.65456401516768
    jac_trap[42,134] = 30.9517475172273
    jac_trap[42,135] = -1.84896616921897
    jac_trap[42,136] = -9.21038227100566
    jac_trap[42,137] = -0.793238195499529
    jac_trap[42,138] = -9.00835072044485
    jac_trap[42,139] = -1.84896616921897
    jac_trap[42,140] = -9.21038227100566
    jac_trap[42,378] = 1
    jac_trap[43,41] = 9.21038227100566
    jac_trap[43,42] = -1.84896616921897
    jac_trap[43,43] = -30.9517475172273
    jac_trap[43,44] = -5.65456401516768
    jac_trap[43,45] = 9.21038227100566
    jac_trap[43,46] = -1.84896616921897
    jac_trap[43,47] = 9.00835072044485
    jac_trap[43,48] = -0.793238195499528
    jac_trap[43,133] = -9.21038227100566
    jac_trap[43,134] = 1.84896616921897
    jac_trap[43,135] = 30.9517475172273
    jac_trap[43,136] = 5.65456401516768
    jac_trap[43,137] = -9.21038227100566
    jac_trap[43,138] = 1.84896616921897
    jac_trap[43,139] = -9.00835072044485
    jac_trap[43,140] = 0.793238195499528
    jac_trap[43,379] = 1
    jac_trap[44,41] = 1.84896616921897
    jac_trap[44,42] = 9.21038227100566
    jac_trap[44,43] = 5.65456401516768
    jac_trap[44,44] = -30.9517475172273
    jac_trap[44,45] = 1.84896616921897
    jac_trap[44,46] = 9.21038227100566
    jac_trap[44,47] = 0.793238195499528
    jac_trap[44,48] = 9.00835072044485
    jac_trap[44,133] = -1.84896616921897
    jac_trap[44,134] = -9.21038227100566
    jac_trap[44,135] = -5.65456401516768
    jac_trap[44,136] = 30.9517475172273
    jac_trap[44,137] = -1.84896616921897
    jac_trap[44,138] = -9.21038227100566
    jac_trap[44,139] = -0.793238195499528
    jac_trap[44,140] = -9.00835072044485
    jac_trap[44,380] = 1
    jac_trap[45,41] = 9.00835072044484
    jac_trap[45,42] = -0.793238195499527
    jac_trap[45,43] = 9.21038227100566
    jac_trap[45,44] = -1.84896616921897
    jac_trap[45,45] = -30.9517475172273
    jac_trap[45,46] = -5.65456401516768
    jac_trap[45,47] = 9.21038227100566
    jac_trap[45,48] = -1.84896616921897
    jac_trap[45,133] = -9.00835072044484
    jac_trap[45,134] = 0.793238195499527
    jac_trap[45,135] = -9.21038227100566
    jac_trap[45,136] = 1.84896616921897
    jac_trap[45,137] = 30.9517475172273
    jac_trap[45,138] = 5.65456401516768
    jac_trap[45,139] = -9.21038227100566
    jac_trap[45,140] = 1.84896616921897
    jac_trap[45,381] = 1
    jac_trap[46,41] = 0.793238195499527
    jac_trap[46,42] = 9.00835072044484
    jac_trap[46,43] = 1.84896616921897
    jac_trap[46,44] = 9.21038227100566
    jac_trap[46,45] = 5.65456401516768
    jac_trap[46,46] = -30.9517475172273
    jac_trap[46,47] = 1.84896616921897
    jac_trap[46,48] = 9.21038227100566
    jac_trap[46,133] = -0.793238195499527
    jac_trap[46,134] = -9.00835072044484
    jac_trap[46,135] = -1.84896616921897
    jac_trap[46,136] = -9.21038227100566
    jac_trap[46,137] = -5.65456401516768
    jac_trap[46,138] = 30.9517475172273
    jac_trap[46,139] = -1.84896616921897
    jac_trap[46,140] = -9.21038227100566
    jac_trap[46,382] = 1
    jac_trap[47,41] = 9.21038227100566
    jac_trap[47,42] = -1.84896616921897
    jac_trap[47,43] = 9.00835072044485
    jac_trap[47,44] = -0.793238195499527
    jac_trap[47,45] = 9.21038227100566
    jac_trap[47,46] = -1.84896616921897
    jac_trap[47,47] = -30.9767475172273
    jac_trap[47,48] = -5.65456401516768
    jac_trap[47,133] = -9.21038227100566
    jac_trap[47,134] = 1.84896616921897
    jac_trap[47,135] = -9.00835072044485
    jac_trap[47,136] = 0.793238195499527
    jac_trap[47,137] = -9.21038227100566
    jac_trap[47,138] = 1.84896616921897
    jac_trap[47,139] = 30.9517475172273
    jac_trap[47,140] = 5.65456401516768
    jac_trap[48,41] = 1.84896616921897
    jac_trap[48,42] = 9.21038227100566
    jac_trap[48,43] = 0.793238195499527
    jac_trap[48,44] = 9.00835072044485
    jac_trap[48,45] = 1.84896616921897
    jac_trap[48,46] = 9.21038227100566
    jac_trap[48,47] = 5.65456401516768
    jac_trap[48,48] = -30.9767475172273
    jac_trap[48,133] = -1.84896616921897
    jac_trap[48,134] = -9.21038227100566
    jac_trap[48,135] = -0.793238195499527
    jac_trap[48,136] = -9.00835072044485
    jac_trap[48,137] = -1.84896616921897
    jac_trap[48,138] = -9.21038227100566
    jac_trap[48,139] = -5.65456401516768
    jac_trap[48,140] = 30.9517475172273
    jac_trap[49,49] = -135.409614082600
    jac_trap[49,223] = 135.409614082600
    jac_trap[49,385] = 1
    jac_trap[50,50] = -135.409614082600
    jac_trap[50,224] = 135.409614082600
    jac_trap[50,386] = 1
    jac_trap[51,51] = -135.409614082600
    jac_trap[51,229] = 135.409614082600
    jac_trap[51,387] = 1
    jac_trap[52,52] = -135.409614082600
    jac_trap[52,230] = 135.409614082600
    jac_trap[52,388] = 1
    jac_trap[53,53] = -157.977883096366
    jac_trap[53,167] = 157.977883096366
    jac_trap[53,389] = 1
    jac_trap[54,54] = -157.977883096366
    jac_trap[54,168] = 157.977883096366
    jac_trap[54,390] = 1
    jac_trap[55,55] = -157.977883096366
    jac_trap[55,173] = 157.977883096366
    jac_trap[55,391] = 1
    jac_trap[56,56] = -157.977883096366
    jac_trap[56,174] = 157.977883096366
    jac_trap[56,392] = 1
    jac_trap[57,57] = -157.977883096366
    jac_trap[57,183] = 157.977883096366
    jac_trap[57,393] = 1
    jac_trap[58,58] = -157.977883096366
    jac_trap[58,184] = 157.977883096366
    jac_trap[58,394] = 1
    jac_trap[59,59] = -157.977883096366
    jac_trap[59,189] = 157.977883096366
    jac_trap[59,395] = 1
    jac_trap[60,60] = -157.977883096366
    jac_trap[60,190] = 157.977883096366
    jac_trap[60,396] = 1
    jac_trap[61,61] = -157.977883096366
    jac_trap[61,191] = 157.977883096366
    jac_trap[61,397] = 1
    jac_trap[62,62] = -157.977883096366
    jac_trap[62,192] = 157.977883096366
    jac_trap[62,398] = 1
    jac_trap[63,63] = -157.977883096366
    jac_trap[63,197] = 157.977883096366
    jac_trap[63,399] = 1
    jac_trap[64,64] = -157.977883096366
    jac_trap[64,198] = 157.977883096366
    jac_trap[64,400] = 1
    jac_trap[65,65] = -157.977883096366
    jac_trap[65,199] = 157.977883096366
    jac_trap[65,401] = 1
    jac_trap[66,66] = -157.977883096366
    jac_trap[66,200] = 157.977883096366
    jac_trap[66,402] = 1
    jac_trap[67,67] = -157.977883096366
    jac_trap[67,205] = 157.977883096366
    jac_trap[67,403] = 1
    jac_trap[68,68] = -157.977883096366
    jac_trap[68,206] = 157.977883096366
    jac_trap[68,404] = 1
    jac_trap[69,1] = 105.571769313180
    jac_trap[69,2] = 54.0657727682604
    jac_trap[69,3] = -39.6392229058202
    jac_trap[69,4] = -10.2713736253513
    jac_trap[69,5] = -24.9575997948692
    jac_trap[69,6] = -23.2849644809540
    jac_trap[69,7] = -39.6392229058202
    jac_trap[69,8] = -10.2713736253513
    jac_trap[69,69] = -211.143538626360
    jac_trap[69,70] = -108.131545536521
    jac_trap[69,71] = 79.2784458116403
    jac_trap[69,72] = 20.5427472507027
    jac_trap[69,73] = 49.9151995897384
    jac_trap[69,74] = 46.5699289619080
    jac_trap[69,75] = 79.2784458116403
    jac_trap[69,76] = 20.5427472507027
    jac_trap[69,77] = 105.571769313180
    jac_trap[69,78] = 54.0657727682604
    jac_trap[69,79] = -39.6392229058202
    jac_trap[69,80] = -10.2713736253513
    jac_trap[69,81] = -24.9575997948692
    jac_trap[69,82] = -23.2849644809540
    jac_trap[69,83] = -39.6392229058202
    jac_trap[69,84] = -10.2713736253513
    jac_trap[70,1] = -54.0657727682604
    jac_trap[70,2] = 105.571769313180
    jac_trap[70,3] = 10.2713736253513
    jac_trap[70,4] = -39.6392229058202
    jac_trap[70,5] = 23.2849644809540
    jac_trap[70,6] = -24.9575997948692
    jac_trap[70,7] = 10.2713736253513
    jac_trap[70,8] = -39.6392229058202
    jac_trap[70,69] = 108.131545536521
    jac_trap[70,70] = -211.143538626360
    jac_trap[70,71] = -20.5427472507027
    jac_trap[70,72] = 79.2784458116403
    jac_trap[70,73] = -46.5699289619080
    jac_trap[70,74] = 49.9151995897384
    jac_trap[70,75] = -20.5427472507027
    jac_trap[70,76] = 79.2784458116403
    jac_trap[70,77] = -54.0657727682604
    jac_trap[70,78] = 105.571769313180
    jac_trap[70,79] = 10.2713736253513
    jac_trap[70,80] = -39.6392229058202
    jac_trap[70,81] = 23.2849644809540
    jac_trap[70,82] = -24.9575997948692
    jac_trap[70,83] = 10.2713736253513
    jac_trap[70,84] = -39.6392229058202
    jac_trap[71,1] = -39.6392229058202
    jac_trap[71,2] = -10.2713736253513
    jac_trap[71,3] = 105.571769313180
    jac_trap[71,4] = 54.0657727682604
    jac_trap[71,5] = -39.6392229058201
    jac_trap[71,6] = -10.2713736253513
    jac_trap[71,7] = -24.9575997948692
    jac_trap[71,8] = -23.2849644809540
    jac_trap[71,69] = 79.2784458116403
    jac_trap[71,70] = 20.5427472507027
    jac_trap[71,71] = -211.143538626360
    jac_trap[71,72] = -108.131545536521
    jac_trap[71,73] = 79.2784458116403
    jac_trap[71,74] = 20.5427472507027
    jac_trap[71,75] = 49.9151995897384
    jac_trap[71,76] = 46.5699289619080
    jac_trap[71,77] = -39.6392229058202
    jac_trap[71,78] = -10.2713736253513
    jac_trap[71,79] = 105.571769313180
    jac_trap[71,80] = 54.0657727682604
    jac_trap[71,81] = -39.6392229058201
    jac_trap[71,82] = -10.2713736253513
    jac_trap[71,83] = -24.9575997948692
    jac_trap[71,84] = -23.2849644809540
    jac_trap[72,1] = 10.2713736253513
    jac_trap[72,2] = -39.6392229058202
    jac_trap[72,3] = -54.0657727682604
    jac_trap[72,4] = 105.571769313180
    jac_trap[72,5] = 10.2713736253513
    jac_trap[72,6] = -39.6392229058201
    jac_trap[72,7] = 23.2849644809540
    jac_trap[72,8] = -24.9575997948692
    jac_trap[72,69] = -20.5427472507027
    jac_trap[72,70] = 79.2784458116403
    jac_trap[72,71] = 108.131545536521
    jac_trap[72,72] = -211.143538626360
    jac_trap[72,73] = -20.5427472507027
    jac_trap[72,74] = 79.2784458116403
    jac_trap[72,75] = -46.5699289619080
    jac_trap[72,76] = 49.9151995897384
    jac_trap[72,77] = 10.2713736253513
    jac_trap[72,78] = -39.6392229058202
    jac_trap[72,79] = -54.0657727682604
    jac_trap[72,80] = 105.571769313180
    jac_trap[72,81] = 10.2713736253513
    jac_trap[72,82] = -39.6392229058201
    jac_trap[72,83] = 23.2849644809540
    jac_trap[72,84] = -24.9575997948692
    jac_trap[73,1] = -24.9575997948692
    jac_trap[73,2] = -23.2849644809540
    jac_trap[73,3] = -39.6392229058202
    jac_trap[73,4] = -10.2713736253513
    jac_trap[73,5] = 105.571769313180
    jac_trap[73,6] = 54.0657727682604
    jac_trap[73,7] = -39.6392229058201
    jac_trap[73,8] = -10.2713736253514
    jac_trap[73,69] = 49.9151995897384
    jac_trap[73,70] = 46.5699289619080
    jac_trap[73,71] = 79.2784458116404
    jac_trap[73,72] = 20.5427472507027
    jac_trap[73,73] = -211.143538626360
    jac_trap[73,74] = -108.131545536521
    jac_trap[73,75] = 79.2784458116403
    jac_trap[73,76] = 20.5427472507027
    jac_trap[73,77] = -24.9575997948692
    jac_trap[73,78] = -23.2849644809540
    jac_trap[73,79] = -39.6392229058202
    jac_trap[73,80] = -10.2713736253513
    jac_trap[73,81] = 105.571769313180
    jac_trap[73,82] = 54.0657727682604
    jac_trap[73,83] = -39.6392229058201
    jac_trap[73,84] = -10.2713736253514
    jac_trap[74,1] = 23.2849644809540
    jac_trap[74,2] = -24.9575997948692
    jac_trap[74,3] = 10.2713736253513
    jac_trap[74,4] = -39.6392229058202
    jac_trap[74,5] = -54.0657727682604
    jac_trap[74,6] = 105.571769313180
    jac_trap[74,7] = 10.2713736253514
    jac_trap[74,8] = -39.6392229058201
    jac_trap[74,69] = -46.5699289619080
    jac_trap[74,70] = 49.9151995897384
    jac_trap[74,71] = -20.5427472507027
    jac_trap[74,72] = 79.2784458116404
    jac_trap[74,73] = 108.131545536521
    jac_trap[74,74] = -211.143538626360
    jac_trap[74,75] = -20.5427472507027
    jac_trap[74,76] = 79.2784458116403
    jac_trap[74,77] = 23.2849644809540
    jac_trap[74,78] = -24.9575997948692
    jac_trap[74,79] = 10.2713736253513
    jac_trap[74,80] = -39.6392229058202
    jac_trap[74,81] = -54.0657727682604
    jac_trap[74,82] = 105.571769313180
    jac_trap[74,83] = 10.2713736253514
    jac_trap[74,84] = -39.6392229058201
    jac_trap[75,1] = -39.6392229058202
    jac_trap[75,2] = -10.2713736253513
    jac_trap[75,3] = -24.9575997948692
    jac_trap[75,4] = -23.2849644809540
    jac_trap[75,5] = -39.6392229058202
    jac_trap[75,6] = -10.2713736253513
    jac_trap[75,7] = 105.571769313180
    jac_trap[75,8] = 54.0657727682604
    jac_trap[75,69] = 79.2784458116403
    jac_trap[75,70] = 20.5427472507027
    jac_trap[75,71] = 49.9151995897384
    jac_trap[75,72] = 46.5699289619080
    jac_trap[75,73] = 79.2784458116403
    jac_trap[75,74] = 20.5427472507027
    jac_trap[75,75] = -211.168538626360
    jac_trap[75,76] = -108.131545536521
    jac_trap[75,77] = -39.6392229058202
    jac_trap[75,78] = -10.2713736253513
    jac_trap[75,79] = -24.9575997948692
    jac_trap[75,80] = -23.2849644809540
    jac_trap[75,81] = -39.6392229058202
    jac_trap[75,82] = -10.2713736253513
    jac_trap[75,83] = 105.571769313180
    jac_trap[75,84] = 54.0657727682604
    jac_trap[76,1] = 10.2713736253513
    jac_trap[76,2] = -39.6392229058202
    jac_trap[76,3] = 23.2849644809540
    jac_trap[76,4] = -24.9575997948692
    jac_trap[76,5] = 10.2713736253513
    jac_trap[76,6] = -39.6392229058202
    jac_trap[76,7] = -54.0657727682604
    jac_trap[76,8] = 105.571769313180
    jac_trap[76,69] = -20.5427472507027
    jac_trap[76,70] = 79.2784458116403
    jac_trap[76,71] = -46.5699289619080
    jac_trap[76,72] = 49.9151995897384
    jac_trap[76,73] = -20.5427472507027
    jac_trap[76,74] = 79.2784458116403
    jac_trap[76,75] = 108.131545536521
    jac_trap[76,76] = -211.168538626360
    jac_trap[76,77] = 10.2713736253513
    jac_trap[76,78] = -39.6392229058202
    jac_trap[76,79] = 23.2849644809540
    jac_trap[76,80] = -24.9575997948692
    jac_trap[76,81] = 10.2713736253513
    jac_trap[76,82] = -39.6392229058202
    jac_trap[76,83] = -54.0657727682604
    jac_trap[76,84] = 105.571769313180
    jac_trap[77,9] = 26.5300693004806
    jac_trap[77,10] = 4.84676915585801
    jac_trap[77,11] = -7.89461337514770
    jac_trap[77,12] = 1.58482814504483
    jac_trap[77,13] = -7.72144347466701
    jac_trap[77,14] = 0.679918453285310
    jac_trap[77,15] = -7.89461337514771
    jac_trap[77,16] = 1.58482814504483
    jac_trap[77,69] = 105.571769313180
    jac_trap[77,70] = 54.0657727682604
    jac_trap[77,71] = -39.6392229058202
    jac_trap[77,72] = -10.2713736253513
    jac_trap[77,73] = -24.9575997948692
    jac_trap[77,74] = -23.2849644809540
    jac_trap[77,75] = -39.6392229058202
    jac_trap[77,76] = -10.2713736253513
    jac_trap[77,77] = -237.673607926841
    jac_trap[77,78] = -112.978314692379
    jac_trap[77,79] = 87.1730591867880
    jac_trap[77,80] = 18.9579191056578
    jac_trap[77,81] = 57.6366430644055
    jac_trap[77,82] = 45.8900105086227
    jac_trap[77,83] = 87.1730591867880
    jac_trap[77,84] = 18.9579191056579
    jac_trap[77,85] = 105.571769313180
    jac_trap[77,86] = 54.0657727682604
    jac_trap[77,87] = -39.6392229058202
    jac_trap[77,88] = -10.2713736253513
    jac_trap[77,89] = -24.9575997948692
    jac_trap[77,90] = -23.2849644809540
    jac_trap[77,91] = -39.6392229058202
    jac_trap[77,92] = -10.2713736253513
    jac_trap[78,9] = -4.84676915585801
    jac_trap[78,10] = 26.5300693004806
    jac_trap[78,11] = -1.58482814504483
    jac_trap[78,12] = -7.89461337514770
    jac_trap[78,13] = -0.679918453285310
    jac_trap[78,14] = -7.72144347466701
    jac_trap[78,15] = -1.58482814504483
    jac_trap[78,16] = -7.89461337514771
    jac_trap[78,69] = -54.0657727682604
    jac_trap[78,70] = 105.571769313180
    jac_trap[78,71] = 10.2713736253513
    jac_trap[78,72] = -39.6392229058202
    jac_trap[78,73] = 23.2849644809540
    jac_trap[78,74] = -24.9575997948692
    jac_trap[78,75] = 10.2713736253513
    jac_trap[78,76] = -39.6392229058202
    jac_trap[78,77] = 112.978314692379
    jac_trap[78,78] = -237.673607926841
    jac_trap[78,79] = -18.9579191056578
    jac_trap[78,80] = 87.1730591867880
    jac_trap[78,81] = -45.8900105086227
    jac_trap[78,82] = 57.6366430644055
    jac_trap[78,83] = -18.9579191056579
    jac_trap[78,84] = 87.1730591867880
    jac_trap[78,85] = -54.0657727682604
    jac_trap[78,86] = 105.571769313180
    jac_trap[78,87] = 10.2713736253513
    jac_trap[78,88] = -39.6392229058202
    jac_trap[78,89] = 23.2849644809540
    jac_trap[78,90] = -24.9575997948692
    jac_trap[78,91] = 10.2713736253513
    jac_trap[78,92] = -39.6392229058202
    jac_trap[79,9] = -7.89461337514771
    jac_trap[79,10] = 1.58482814504483
    jac_trap[79,11] = 26.5300693004806
    jac_trap[79,12] = 4.84676915585801
    jac_trap[79,13] = -7.89461337514771
    jac_trap[79,14] = 1.58482814504483
    jac_trap[79,15] = -7.72144347466701
    jac_trap[79,16] = 0.679918453285308
    jac_trap[79,69] = -39.6392229058202
    jac_trap[79,70] = -10.2713736253513
    jac_trap[79,71] = 105.571769313180
    jac_trap[79,72] = 54.0657727682604
    jac_trap[79,73] = -39.6392229058201
    jac_trap[79,74] = -10.2713736253513
    jac_trap[79,75] = -24.9575997948692
    jac_trap[79,76] = -23.2849644809540
    jac_trap[79,77] = 87.1730591867880
    jac_trap[79,78] = 18.9579191056579
    jac_trap[79,79] = -237.673607926841
    jac_trap[79,80] = -112.978314692379
    jac_trap[79,81] = 87.1730591867880
    jac_trap[79,82] = 18.9579191056579
    jac_trap[79,83] = 57.6366430644054
    jac_trap[79,84] = 45.8900105086227
    jac_trap[79,85] = -39.6392229058202
    jac_trap[79,86] = -10.2713736253513
    jac_trap[79,87] = 105.571769313180
    jac_trap[79,88] = 54.0657727682604
    jac_trap[79,89] = -39.6392229058201
    jac_trap[79,90] = -10.2713736253513
    jac_trap[79,91] = -24.9575997948692
    jac_trap[79,92] = -23.2849644809540
    jac_trap[80,9] = -1.58482814504483
    jac_trap[80,10] = -7.89461337514771
    jac_trap[80,11] = -4.84676915585801
    jac_trap[80,12] = 26.5300693004806
    jac_trap[80,13] = -1.58482814504483
    jac_trap[80,14] = -7.89461337514771
    jac_trap[80,15] = -0.679918453285308
    jac_trap[80,16] = -7.72144347466701
    jac_trap[80,69] = 10.2713736253513
    jac_trap[80,70] = -39.6392229058202
    jac_trap[80,71] = -54.0657727682604
    jac_trap[80,72] = 105.571769313180
    jac_trap[80,73] = 10.2713736253513
    jac_trap[80,74] = -39.6392229058201
    jac_trap[80,75] = 23.2849644809540
    jac_trap[80,76] = -24.9575997948692
    jac_trap[80,77] = -18.9579191056579
    jac_trap[80,78] = 87.1730591867880
    jac_trap[80,79] = 112.978314692379
    jac_trap[80,80] = -237.673607926841
    jac_trap[80,81] = -18.9579191056579
    jac_trap[80,82] = 87.1730591867880
    jac_trap[80,83] = -45.8900105086227
    jac_trap[80,84] = 57.6366430644054
    jac_trap[80,85] = 10.2713736253513
    jac_trap[80,86] = -39.6392229058202
    jac_trap[80,87] = -54.0657727682604
    jac_trap[80,88] = 105.571769313180
    jac_trap[80,89] = 10.2713736253513
    jac_trap[80,90] = -39.6392229058201
    jac_trap[80,91] = 23.2849644809540
    jac_trap[80,92] = -24.9575997948692
    jac_trap[81,9] = -7.72144347466701
    jac_trap[81,10] = 0.679918453285310
    jac_trap[81,11] = -7.89461337514770
    jac_trap[81,12] = 1.58482814504483
    jac_trap[81,13] = 26.5300693004806
    jac_trap[81,14] = 4.84676915585801
    jac_trap[81,15] = -7.89461337514771
    jac_trap[81,16] = 1.58482814504483
    jac_trap[81,69] = -24.9575997948692
    jac_trap[81,70] = -23.2849644809540
    jac_trap[81,71] = -39.6392229058202
    jac_trap[81,72] = -10.2713736253513
    jac_trap[81,73] = 105.571769313180
    jac_trap[81,74] = 54.0657727682604
    jac_trap[81,75] = -39.6392229058201
    jac_trap[81,76] = -10.2713736253514
    jac_trap[81,77] = 57.6366430644054
    jac_trap[81,78] = 45.8900105086227
    jac_trap[81,79] = 87.1730591867881
    jac_trap[81,80] = 18.9579191056578
    jac_trap[81,81] = -237.673607926841
    jac_trap[81,82] = -112.978314692379
    jac_trap[81,83] = 87.1730591867880
    jac_trap[81,84] = 18.9579191056579
    jac_trap[81,85] = -24.9575997948692
    jac_trap[81,86] = -23.2849644809540
    jac_trap[81,87] = -39.6392229058202
    jac_trap[81,88] = -10.2713736253513
    jac_trap[81,89] = 105.571769313180
    jac_trap[81,90] = 54.0657727682604
    jac_trap[81,91] = -39.6392229058201
    jac_trap[81,92] = -10.2713736253514
    jac_trap[82,9] = -0.679918453285310
    jac_trap[82,10] = -7.72144347466701
    jac_trap[82,11] = -1.58482814504483
    jac_trap[82,12] = -7.89461337514770
    jac_trap[82,13] = -4.84676915585801
    jac_trap[82,14] = 26.5300693004806
    jac_trap[82,15] = -1.58482814504483
    jac_trap[82,16] = -7.89461337514771
    jac_trap[82,69] = 23.2849644809540
    jac_trap[82,70] = -24.9575997948692
    jac_trap[82,71] = 10.2713736253513
    jac_trap[82,72] = -39.6392229058202
    jac_trap[82,73] = -54.0657727682604
    jac_trap[82,74] = 105.571769313180
    jac_trap[82,75] = 10.2713736253514
    jac_trap[82,76] = -39.6392229058201
    jac_trap[82,77] = -45.8900105086227
    jac_trap[82,78] = 57.6366430644054
    jac_trap[82,79] = -18.9579191056578
    jac_trap[82,80] = 87.1730591867881
    jac_trap[82,81] = 112.978314692379
    jac_trap[82,82] = -237.673607926841
    jac_trap[82,83] = -18.9579191056579
    jac_trap[82,84] = 87.1730591867880
    jac_trap[82,85] = 23.2849644809540
    jac_trap[82,86] = -24.9575997948692
    jac_trap[82,87] = 10.2713736253513
    jac_trap[82,88] = -39.6392229058202
    jac_trap[82,89] = -54.0657727682604
    jac_trap[82,90] = 105.571769313180
    jac_trap[82,91] = 10.2713736253514
    jac_trap[82,92] = -39.6392229058201
    jac_trap[83,9] = -7.89461337514771
    jac_trap[83,10] = 1.58482814504483
    jac_trap[83,11] = -7.72144347466701
    jac_trap[83,12] = 0.679918453285308
    jac_trap[83,13] = -7.89461337514771
    jac_trap[83,14] = 1.58482814504483
    jac_trap[83,15] = 26.5300693004806
    jac_trap[83,16] = 4.84676915585801
    jac_trap[83,69] = -39.6392229058202
    jac_trap[83,70] = -10.2713736253513
    jac_trap[83,71] = -24.9575997948692
    jac_trap[83,72] = -23.2849644809540
    jac_trap[83,73] = -39.6392229058202
    jac_trap[83,74] = -10.2713736253513
    jac_trap[83,75] = 105.571769313180
    jac_trap[83,76] = 54.0657727682604
    jac_trap[83,77] = 87.1730591867880
    jac_trap[83,78] = 18.9579191056578
    jac_trap[83,79] = 57.6366430644054
    jac_trap[83,80] = 45.8900105086227
    jac_trap[83,81] = 87.1730591867880
    jac_trap[83,82] = 18.9579191056579
    jac_trap[83,83] = -237.673607926841
    jac_trap[83,84] = -112.978314692379
    jac_trap[83,85] = -39.6392229058202
    jac_trap[83,86] = -10.2713736253513
    jac_trap[83,87] = -24.9575997948692
    jac_trap[83,88] = -23.2849644809540
    jac_trap[83,89] = -39.6392229058202
    jac_trap[83,90] = -10.2713736253513
    jac_trap[83,91] = 105.571769313180
    jac_trap[83,92] = 54.0657727682604
    jac_trap[84,9] = -1.58482814504483
    jac_trap[84,10] = -7.89461337514771
    jac_trap[84,11] = -0.679918453285308
    jac_trap[84,12] = -7.72144347466701
    jac_trap[84,13] = -1.58482814504483
    jac_trap[84,14] = -7.89461337514771
    jac_trap[84,15] = -4.84676915585801
    jac_trap[84,16] = 26.5300693004806
    jac_trap[84,69] = 10.2713736253513
    jac_trap[84,70] = -39.6392229058202
    jac_trap[84,71] = 23.2849644809540
    jac_trap[84,72] = -24.9575997948692
    jac_trap[84,73] = 10.2713736253513
    jac_trap[84,74] = -39.6392229058202
    jac_trap[84,75] = -54.0657727682604
    jac_trap[84,76] = 105.571769313180
    jac_trap[84,77] = -18.9579191056578
    jac_trap[84,78] = 87.1730591867880
    jac_trap[84,79] = -45.8900105086227
    jac_trap[84,80] = 57.6366430644054
    jac_trap[84,81] = -18.9579191056579
    jac_trap[84,82] = 87.1730591867880
    jac_trap[84,83] = 112.978314692379
    jac_trap[84,84] = -237.673607926841
    jac_trap[84,85] = 10.2713736253513
    jac_trap[84,86] = -39.6392229058202
    jac_trap[84,87] = 23.2849644809540
    jac_trap[84,88] = -24.9575997948692
    jac_trap[84,89] = 10.2713736253513
    jac_trap[84,90] = -39.6392229058202
    jac_trap[84,91] = -54.0657727682604
    jac_trap[84,92] = 105.571769313180
    jac_trap[85,77] = 105.571769313180
    jac_trap[85,78] = 54.0657727682604
    jac_trap[85,79] = -39.6392229058202
    jac_trap[85,80] = -10.2713736253513
    jac_trap[85,81] = -24.9575997948692
    jac_trap[85,82] = -23.2849644809540
    jac_trap[85,83] = -39.6392229058202
    jac_trap[85,84] = -10.2713736253513
    jac_trap[85,85] = -237.673607926841
    jac_trap[85,86] = -112.978314692379
    jac_trap[85,87] = 87.1730591867880
    jac_trap[85,88] = 18.9579191056578
    jac_trap[85,89] = 57.6366430644055
    jac_trap[85,90] = 45.8900105086227
    jac_trap[85,91] = 87.1730591867880
    jac_trap[85,92] = 18.9579191056579
    jac_trap[85,93] = 105.571769313180
    jac_trap[85,94] = 54.0657727682604
    jac_trap[85,95] = -39.6392229058202
    jac_trap[85,96] = -10.2713736253513
    jac_trap[85,97] = -24.9575997948692
    jac_trap[85,98] = -23.2849644809540
    jac_trap[85,99] = -39.6392229058202
    jac_trap[85,100] = -10.2713736253513
    jac_trap[85,141] = 26.5300693004806
    jac_trap[85,142] = 4.84676915585801
    jac_trap[85,143] = -7.89461337514770
    jac_trap[85,144] = 1.58482814504483
    jac_trap[85,145] = -7.72144347466701
    jac_trap[85,146] = 0.679918453285310
    jac_trap[85,147] = -7.89461337514771
    jac_trap[85,148] = 1.58482814504483
    jac_trap[86,77] = -54.0657727682604
    jac_trap[86,78] = 105.571769313180
    jac_trap[86,79] = 10.2713736253513
    jac_trap[86,80] = -39.6392229058202
    jac_trap[86,81] = 23.2849644809540
    jac_trap[86,82] = -24.9575997948692
    jac_trap[86,83] = 10.2713736253513
    jac_trap[86,84] = -39.6392229058202
    jac_trap[86,85] = 112.978314692379
    jac_trap[86,86] = -237.673607926841
    jac_trap[86,87] = -18.9579191056578
    jac_trap[86,88] = 87.1730591867880
    jac_trap[86,89] = -45.8900105086227
    jac_trap[86,90] = 57.6366430644055
    jac_trap[86,91] = -18.9579191056579
    jac_trap[86,92] = 87.1730591867880
    jac_trap[86,93] = -54.0657727682604
    jac_trap[86,94] = 105.571769313180
    jac_trap[86,95] = 10.2713736253513
    jac_trap[86,96] = -39.6392229058202
    jac_trap[86,97] = 23.2849644809540
    jac_trap[86,98] = -24.9575997948692
    jac_trap[86,99] = 10.2713736253513
    jac_trap[86,100] = -39.6392229058202
    jac_trap[86,141] = -4.84676915585801
    jac_trap[86,142] = 26.5300693004806
    jac_trap[86,143] = -1.58482814504483
    jac_trap[86,144] = -7.89461337514770
    jac_trap[86,145] = -0.679918453285310
    jac_trap[86,146] = -7.72144347466701
    jac_trap[86,147] = -1.58482814504483
    jac_trap[86,148] = -7.89461337514771
    jac_trap[87,77] = -39.6392229058202
    jac_trap[87,78] = -10.2713736253513
    jac_trap[87,79] = 105.571769313180
    jac_trap[87,80] = 54.0657727682604
    jac_trap[87,81] = -39.6392229058201
    jac_trap[87,82] = -10.2713736253513
    jac_trap[87,83] = -24.9575997948692
    jac_trap[87,84] = -23.2849644809540
    jac_trap[87,85] = 87.1730591867880
    jac_trap[87,86] = 18.9579191056579
    jac_trap[87,87] = -237.673607926841
    jac_trap[87,88] = -112.978314692379
    jac_trap[87,89] = 87.1730591867880
    jac_trap[87,90] = 18.9579191056579
    jac_trap[87,91] = 57.6366430644054
    jac_trap[87,92] = 45.8900105086227
    jac_trap[87,93] = -39.6392229058202
    jac_trap[87,94] = -10.2713736253513
    jac_trap[87,95] = 105.571769313180
    jac_trap[87,96] = 54.0657727682604
    jac_trap[87,97] = -39.6392229058201
    jac_trap[87,98] = -10.2713736253513
    jac_trap[87,99] = -24.9575997948692
    jac_trap[87,100] = -23.2849644809540
    jac_trap[87,141] = -7.89461337514771
    jac_trap[87,142] = 1.58482814504483
    jac_trap[87,143] = 26.5300693004806
    jac_trap[87,144] = 4.84676915585801
    jac_trap[87,145] = -7.89461337514771
    jac_trap[87,146] = 1.58482814504483
    jac_trap[87,147] = -7.72144347466701
    jac_trap[87,148] = 0.679918453285308
    jac_trap[88,77] = 10.2713736253513
    jac_trap[88,78] = -39.6392229058202
    jac_trap[88,79] = -54.0657727682604
    jac_trap[88,80] = 105.571769313180
    jac_trap[88,81] = 10.2713736253513
    jac_trap[88,82] = -39.6392229058201
    jac_trap[88,83] = 23.2849644809540
    jac_trap[88,84] = -24.9575997948692
    jac_trap[88,85] = -18.9579191056579
    jac_trap[88,86] = 87.1730591867880
    jac_trap[88,87] = 112.978314692379
    jac_trap[88,88] = -237.673607926841
    jac_trap[88,89] = -18.9579191056579
    jac_trap[88,90] = 87.1730591867880
    jac_trap[88,91] = -45.8900105086227
    jac_trap[88,92] = 57.6366430644054
    jac_trap[88,93] = 10.2713736253513
    jac_trap[88,94] = -39.6392229058202
    jac_trap[88,95] = -54.0657727682604
    jac_trap[88,96] = 105.571769313180
    jac_trap[88,97] = 10.2713736253513
    jac_trap[88,98] = -39.6392229058201
    jac_trap[88,99] = 23.2849644809540
    jac_trap[88,100] = -24.9575997948692
    jac_trap[88,141] = -1.58482814504483
    jac_trap[88,142] = -7.89461337514771
    jac_trap[88,143] = -4.84676915585801
    jac_trap[88,144] = 26.5300693004806
    jac_trap[88,145] = -1.58482814504483
    jac_trap[88,146] = -7.89461337514771
    jac_trap[88,147] = -0.679918453285308
    jac_trap[88,148] = -7.72144347466701
    jac_trap[89,77] = -24.9575997948692
    jac_trap[89,78] = -23.2849644809540
    jac_trap[89,79] = -39.6392229058202
    jac_trap[89,80] = -10.2713736253513
    jac_trap[89,81] = 105.571769313180
    jac_trap[89,82] = 54.0657727682604
    jac_trap[89,83] = -39.6392229058201
    jac_trap[89,84] = -10.2713736253514
    jac_trap[89,85] = 57.6366430644054
    jac_trap[89,86] = 45.8900105086227
    jac_trap[89,87] = 87.1730591867881
    jac_trap[89,88] = 18.9579191056578
    jac_trap[89,89] = -237.673607926841
    jac_trap[89,90] = -112.978314692379
    jac_trap[89,91] = 87.1730591867880
    jac_trap[89,92] = 18.9579191056579
    jac_trap[89,93] = -24.9575997948692
    jac_trap[89,94] = -23.2849644809540
    jac_trap[89,95] = -39.6392229058202
    jac_trap[89,96] = -10.2713736253513
    jac_trap[89,97] = 105.571769313180
    jac_trap[89,98] = 54.0657727682604
    jac_trap[89,99] = -39.6392229058201
    jac_trap[89,100] = -10.2713736253514
    jac_trap[89,141] = -7.72144347466701
    jac_trap[89,142] = 0.679918453285310
    jac_trap[89,143] = -7.89461337514770
    jac_trap[89,144] = 1.58482814504483
    jac_trap[89,145] = 26.5300693004806
    jac_trap[89,146] = 4.84676915585801
    jac_trap[89,147] = -7.89461337514771
    jac_trap[89,148] = 1.58482814504483
    jac_trap[90,77] = 23.2849644809540
    jac_trap[90,78] = -24.9575997948692
    jac_trap[90,79] = 10.2713736253513
    jac_trap[90,80] = -39.6392229058202
    jac_trap[90,81] = -54.0657727682604
    jac_trap[90,82] = 105.571769313180
    jac_trap[90,83] = 10.2713736253514
    jac_trap[90,84] = -39.6392229058201
    jac_trap[90,85] = -45.8900105086227
    jac_trap[90,86] = 57.6366430644054
    jac_trap[90,87] = -18.9579191056578
    jac_trap[90,88] = 87.1730591867881
    jac_trap[90,89] = 112.978314692379
    jac_trap[90,90] = -237.673607926841
    jac_trap[90,91] = -18.9579191056579
    jac_trap[90,92] = 87.1730591867880
    jac_trap[90,93] = 23.2849644809540
    jac_trap[90,94] = -24.9575997948692
    jac_trap[90,95] = 10.2713736253513
    jac_trap[90,96] = -39.6392229058202
    jac_trap[90,97] = -54.0657727682604
    jac_trap[90,98] = 105.571769313180
    jac_trap[90,99] = 10.2713736253514
    jac_trap[90,100] = -39.6392229058201
    jac_trap[90,141] = -0.679918453285310
    jac_trap[90,142] = -7.72144347466701
    jac_trap[90,143] = -1.58482814504483
    jac_trap[90,144] = -7.89461337514770
    jac_trap[90,145] = -4.84676915585801
    jac_trap[90,146] = 26.5300693004806
    jac_trap[90,147] = -1.58482814504483
    jac_trap[90,148] = -7.89461337514771
    jac_trap[91,77] = -39.6392229058202
    jac_trap[91,78] = -10.2713736253513
    jac_trap[91,79] = -24.9575997948692
    jac_trap[91,80] = -23.2849644809540
    jac_trap[91,81] = -39.6392229058202
    jac_trap[91,82] = -10.2713736253513
    jac_trap[91,83] = 105.571769313180
    jac_trap[91,84] = 54.0657727682604
    jac_trap[91,85] = 87.1730591867880
    jac_trap[91,86] = 18.9579191056578
    jac_trap[91,87] = 57.6366430644054
    jac_trap[91,88] = 45.8900105086227
    jac_trap[91,89] = 87.1730591867880
    jac_trap[91,90] = 18.9579191056579
    jac_trap[91,91] = -237.698607926841
    jac_trap[91,92] = -112.978314692379
    jac_trap[91,93] = -39.6392229058202
    jac_trap[91,94] = -10.2713736253513
    jac_trap[91,95] = -24.9575997948692
    jac_trap[91,96] = -23.2849644809540
    jac_trap[91,97] = -39.6392229058202
    jac_trap[91,98] = -10.2713736253513
    jac_trap[91,99] = 105.571769313180
    jac_trap[91,100] = 54.0657727682604
    jac_trap[91,141] = -7.89461337514771
    jac_trap[91,142] = 1.58482814504483
    jac_trap[91,143] = -7.72144347466701
    jac_trap[91,144] = 0.679918453285308
    jac_trap[91,145] = -7.89461337514771
    jac_trap[91,146] = 1.58482814504483
    jac_trap[91,147] = 26.5300693004806
    jac_trap[91,148] = 4.84676915585801
    jac_trap[92,77] = 10.2713736253513
    jac_trap[92,78] = -39.6392229058202
    jac_trap[92,79] = 23.2849644809540
    jac_trap[92,80] = -24.9575997948692
    jac_trap[92,81] = 10.2713736253513
    jac_trap[92,82] = -39.6392229058202
    jac_trap[92,83] = -54.0657727682604
    jac_trap[92,84] = 105.571769313180
    jac_trap[92,85] = -18.9579191056578
    jac_trap[92,86] = 87.1730591867880
    jac_trap[92,87] = -45.8900105086227
    jac_trap[92,88] = 57.6366430644054
    jac_trap[92,89] = -18.9579191056579
    jac_trap[92,90] = 87.1730591867880
    jac_trap[92,91] = 112.978314692379
    jac_trap[92,92] = -237.698607926841
    jac_trap[92,93] = 10.2713736253513
    jac_trap[92,94] = -39.6392229058202
    jac_trap[92,95] = 23.2849644809540
    jac_trap[92,96] = -24.9575997948692
    jac_trap[92,97] = 10.2713736253513
    jac_trap[92,98] = -39.6392229058202
    jac_trap[92,99] = -54.0657727682604
    jac_trap[92,100] = 105.571769313180
    jac_trap[92,141] = -1.58482814504483
    jac_trap[92,142] = -7.89461337514771
    jac_trap[92,143] = -0.679918453285308
    jac_trap[92,144] = -7.72144347466701
    jac_trap[92,145] = -1.58482814504483
    jac_trap[92,146] = -7.89461337514771
    jac_trap[92,147] = -4.84676915585801
    jac_trap[92,148] = 26.5300693004806
    jac_trap[93,85] = 105.571769313180
    jac_trap[93,86] = 54.0657727682604
    jac_trap[93,87] = -39.6392229058202
    jac_trap[93,88] = -10.2713736253513
    jac_trap[93,89] = -24.9575997948692
    jac_trap[93,90] = -23.2849644809540
    jac_trap[93,91] = -39.6392229058202
    jac_trap[93,92] = -10.2713736253513
    jac_trap[93,93] = -211.143538626360
    jac_trap[93,94] = -108.131545536521
    jac_trap[93,95] = 79.2784458116403
    jac_trap[93,96] = 20.5427472507027
    jac_trap[93,97] = 49.9151995897384
    jac_trap[93,98] = 46.5699289619080
    jac_trap[93,99] = 79.2784458116403
    jac_trap[93,100] = 20.5427472507027
    jac_trap[93,101] = 105.571769313180
    jac_trap[93,102] = 54.0657727682604
    jac_trap[93,103] = -39.6392229058202
    jac_trap[93,104] = -10.2713736253513
    jac_trap[93,105] = -24.9575997948692
    jac_trap[93,106] = -23.2849644809540
    jac_trap[93,107] = -39.6392229058202
    jac_trap[93,108] = -10.2713736253513
    jac_trap[94,85] = -54.0657727682604
    jac_trap[94,86] = 105.571769313180
    jac_trap[94,87] = 10.2713736253513
    jac_trap[94,88] = -39.6392229058202
    jac_trap[94,89] = 23.2849644809540
    jac_trap[94,90] = -24.9575997948692
    jac_trap[94,91] = 10.2713736253513
    jac_trap[94,92] = -39.6392229058202
    jac_trap[94,93] = 108.131545536521
    jac_trap[94,94] = -211.143538626360
    jac_trap[94,95] = -20.5427472507027
    jac_trap[94,96] = 79.2784458116403
    jac_trap[94,97] = -46.5699289619080
    jac_trap[94,98] = 49.9151995897384
    jac_trap[94,99] = -20.5427472507027
    jac_trap[94,100] = 79.2784458116403
    jac_trap[94,101] = -54.0657727682604
    jac_trap[94,102] = 105.571769313180
    jac_trap[94,103] = 10.2713736253513
    jac_trap[94,104] = -39.6392229058202
    jac_trap[94,105] = 23.2849644809540
    jac_trap[94,106] = -24.9575997948692
    jac_trap[94,107] = 10.2713736253513
    jac_trap[94,108] = -39.6392229058202
    jac_trap[95,85] = -39.6392229058202
    jac_trap[95,86] = -10.2713736253513
    jac_trap[95,87] = 105.571769313180
    jac_trap[95,88] = 54.0657727682604
    jac_trap[95,89] = -39.6392229058201
    jac_trap[95,90] = -10.2713736253513
    jac_trap[95,91] = -24.9575997948692
    jac_trap[95,92] = -23.2849644809540
    jac_trap[95,93] = 79.2784458116403
    jac_trap[95,94] = 20.5427472507027
    jac_trap[95,95] = -211.143538626360
    jac_trap[95,96] = -108.131545536521
    jac_trap[95,97] = 79.2784458116403
    jac_trap[95,98] = 20.5427472507027
    jac_trap[95,99] = 49.9151995897384
    jac_trap[95,100] = 46.5699289619080
    jac_trap[95,101] = -39.6392229058202
    jac_trap[95,102] = -10.2713736253513
    jac_trap[95,103] = 105.571769313180
    jac_trap[95,104] = 54.0657727682604
    jac_trap[95,105] = -39.6392229058201
    jac_trap[95,106] = -10.2713736253513
    jac_trap[95,107] = -24.9575997948692
    jac_trap[95,108] = -23.2849644809540
    jac_trap[96,85] = 10.2713736253513
    jac_trap[96,86] = -39.6392229058202
    jac_trap[96,87] = -54.0657727682604
    jac_trap[96,88] = 105.571769313180
    jac_trap[96,89] = 10.2713736253513
    jac_trap[96,90] = -39.6392229058201
    jac_trap[96,91] = 23.2849644809540
    jac_trap[96,92] = -24.9575997948692
    jac_trap[96,93] = -20.5427472507027
    jac_trap[96,94] = 79.2784458116403
    jac_trap[96,95] = 108.131545536521
    jac_trap[96,96] = -211.143538626360
    jac_trap[96,97] = -20.5427472507027
    jac_trap[96,98] = 79.2784458116403
    jac_trap[96,99] = -46.5699289619080
    jac_trap[96,100] = 49.9151995897384
    jac_trap[96,101] = 10.2713736253513
    jac_trap[96,102] = -39.6392229058202
    jac_trap[96,103] = -54.0657727682604
    jac_trap[96,104] = 105.571769313180
    jac_trap[96,105] = 10.2713736253513
    jac_trap[96,106] = -39.6392229058201
    jac_trap[96,107] = 23.2849644809540
    jac_trap[96,108] = -24.9575997948692
    jac_trap[97,85] = -24.9575997948692
    jac_trap[97,86] = -23.2849644809540
    jac_trap[97,87] = -39.6392229058202
    jac_trap[97,88] = -10.2713736253513
    jac_trap[97,89] = 105.571769313180
    jac_trap[97,90] = 54.0657727682604
    jac_trap[97,91] = -39.6392229058201
    jac_trap[97,92] = -10.2713736253514
    jac_trap[97,93] = 49.9151995897384
    jac_trap[97,94] = 46.5699289619080
    jac_trap[97,95] = 79.2784458116404
    jac_trap[97,96] = 20.5427472507027
    jac_trap[97,97] = -211.143538626360
    jac_trap[97,98] = -108.131545536521
    jac_trap[97,99] = 79.2784458116403
    jac_trap[97,100] = 20.5427472507027
    jac_trap[97,101] = -24.9575997948692
    jac_trap[97,102] = -23.2849644809540
    jac_trap[97,103] = -39.6392229058202
    jac_trap[97,104] = -10.2713736253513
    jac_trap[97,105] = 105.571769313180
    jac_trap[97,106] = 54.0657727682604
    jac_trap[97,107] = -39.6392229058201
    jac_trap[97,108] = -10.2713736253514
    jac_trap[98,85] = 23.2849644809540
    jac_trap[98,86] = -24.9575997948692
    jac_trap[98,87] = 10.2713736253513
    jac_trap[98,88] = -39.6392229058202
    jac_trap[98,89] = -54.0657727682604
    jac_trap[98,90] = 105.571769313180
    jac_trap[98,91] = 10.2713736253514
    jac_trap[98,92] = -39.6392229058201
    jac_trap[98,93] = -46.5699289619080
    jac_trap[98,94] = 49.9151995897384
    jac_trap[98,95] = -20.5427472507027
    jac_trap[98,96] = 79.2784458116404
    jac_trap[98,97] = 108.131545536521
    jac_trap[98,98] = -211.143538626360
    jac_trap[98,99] = -20.5427472507027
    jac_trap[98,100] = 79.2784458116403
    jac_trap[98,101] = 23.2849644809540
    jac_trap[98,102] = -24.9575997948692
    jac_trap[98,103] = 10.2713736253513
    jac_trap[98,104] = -39.6392229058202
    jac_trap[98,105] = -54.0657727682604
    jac_trap[98,106] = 105.571769313180
    jac_trap[98,107] = 10.2713736253514
    jac_trap[98,108] = -39.6392229058201
    jac_trap[99,85] = -39.6392229058202
    jac_trap[99,86] = -10.2713736253513
    jac_trap[99,87] = -24.9575997948692
    jac_trap[99,88] = -23.2849644809540
    jac_trap[99,89] = -39.6392229058202
    jac_trap[99,90] = -10.2713736253513
    jac_trap[99,91] = 105.571769313180
    jac_trap[99,92] = 54.0657727682604
    jac_trap[99,93] = 79.2784458116403
    jac_trap[99,94] = 20.5427472507027
    jac_trap[99,95] = 49.9151995897384
    jac_trap[99,96] = 46.5699289619080
    jac_trap[99,97] = 79.2784458116403
    jac_trap[99,98] = 20.5427472507027
    jac_trap[99,99] = -211.143538626360
    jac_trap[99,100] = -108.131545536521
    jac_trap[99,101] = -39.6392229058202
    jac_trap[99,102] = -10.2713736253513
    jac_trap[99,103] = -24.9575997948692
    jac_trap[99,104] = -23.2849644809540
    jac_trap[99,105] = -39.6392229058202
    jac_trap[99,106] = -10.2713736253513
    jac_trap[99,107] = 105.571769313180
    jac_trap[99,108] = 54.0657727682604
    jac_trap[100,85] = 10.2713736253513
    jac_trap[100,86] = -39.6392229058202
    jac_trap[100,87] = 23.2849644809540
    jac_trap[100,88] = -24.9575997948692
    jac_trap[100,89] = 10.2713736253513
    jac_trap[100,90] = -39.6392229058202
    jac_trap[100,91] = -54.0657727682604
    jac_trap[100,92] = 105.571769313180
    jac_trap[100,93] = -20.5427472507027
    jac_trap[100,94] = 79.2784458116403
    jac_trap[100,95] = -46.5699289619080
    jac_trap[100,96] = 49.9151995897384
    jac_trap[100,97] = -20.5427472507027
    jac_trap[100,98] = 79.2784458116403
    jac_trap[100,99] = 108.131545536521
    jac_trap[100,100] = -211.143538626360
    jac_trap[100,101] = 10.2713736253513
    jac_trap[100,102] = -39.6392229058202
    jac_trap[100,103] = 23.2849644809540
    jac_trap[100,104] = -24.9575997948692
    jac_trap[100,105] = 10.2713736253513
    jac_trap[100,106] = -39.6392229058202
    jac_trap[100,107] = -54.0657727682604
    jac_trap[100,108] = 105.571769313180
    jac_trap[101,25] = 30.9517475172273
    jac_trap[101,26] = 5.65456401516768
    jac_trap[101,27] = -9.21038227100566
    jac_trap[101,28] = 1.84896616921897
    jac_trap[101,29] = -9.00835072044485
    jac_trap[101,30] = 0.793238195499529
    jac_trap[101,31] = -9.21038227100566
    jac_trap[101,32] = 1.84896616921897
    jac_trap[101,93] = 105.571769313180
    jac_trap[101,94] = 54.0657727682604
    jac_trap[101,95] = -39.6392229058202
    jac_trap[101,96] = -10.2713736253513
    jac_trap[101,97] = -24.9575997948692
    jac_trap[101,98] = -23.2849644809540
    jac_trap[101,99] = -39.6392229058202
    jac_trap[101,100] = -10.2713736253513
    jac_trap[101,101] = -242.095286143588
    jac_trap[101,102] = -113.786109551688
    jac_trap[101,103] = 88.4888280826460
    jac_trap[101,104] = 18.6937810814837
    jac_trap[101,105] = 58.9235503101833
    jac_trap[101,106] = 45.7766907664085
    jac_trap[101,107] = 88.4888280826460
    jac_trap[101,108] = 18.6937810814837
    jac_trap[101,109] = 105.571769313180
    jac_trap[101,110] = 54.0657727682604
    jac_trap[101,111] = -39.6392229058202
    jac_trap[101,112] = -10.2713736253513
    jac_trap[101,113] = -24.9575997948692
    jac_trap[101,114] = -23.2849644809540
    jac_trap[101,115] = -39.6392229058202
    jac_trap[101,116] = -10.2713736253513
    jac_trap[102,25] = -5.65456401516768
    jac_trap[102,26] = 30.9517475172273
    jac_trap[102,27] = -1.84896616921897
    jac_trap[102,28] = -9.21038227100566
    jac_trap[102,29] = -0.793238195499529
    jac_trap[102,30] = -9.00835072044485
    jac_trap[102,31] = -1.84896616921897
    jac_trap[102,32] = -9.21038227100566
    jac_trap[102,93] = -54.0657727682604
    jac_trap[102,94] = 105.571769313180
    jac_trap[102,95] = 10.2713736253513
    jac_trap[102,96] = -39.6392229058202
    jac_trap[102,97] = 23.2849644809540
    jac_trap[102,98] = -24.9575997948692
    jac_trap[102,99] = 10.2713736253513
    jac_trap[102,100] = -39.6392229058202
    jac_trap[102,101] = 113.786109551688
    jac_trap[102,102] = -242.095286143588
    jac_trap[102,103] = -18.6937810814837
    jac_trap[102,104] = 88.4888280826460
    jac_trap[102,105] = -45.7766907664085
    jac_trap[102,106] = 58.9235503101833
    jac_trap[102,107] = -18.6937810814837
    jac_trap[102,108] = 88.4888280826460
    jac_trap[102,109] = -54.0657727682604
    jac_trap[102,110] = 105.571769313180
    jac_trap[102,111] = 10.2713736253513
    jac_trap[102,112] = -39.6392229058202
    jac_trap[102,113] = 23.2849644809540
    jac_trap[102,114] = -24.9575997948692
    jac_trap[102,115] = 10.2713736253513
    jac_trap[102,116] = -39.6392229058202
    jac_trap[103,25] = -9.21038227100566
    jac_trap[103,26] = 1.84896616921897
    jac_trap[103,27] = 30.9517475172273
    jac_trap[103,28] = 5.65456401516768
    jac_trap[103,29] = -9.21038227100566
    jac_trap[103,30] = 1.84896616921897
    jac_trap[103,31] = -9.00835072044485
    jac_trap[103,32] = 0.793238195499528
    jac_trap[103,93] = -39.6392229058202
    jac_trap[103,94] = -10.2713736253513
    jac_trap[103,95] = 105.571769313180
    jac_trap[103,96] = 54.0657727682604
    jac_trap[103,97] = -39.6392229058201
    jac_trap[103,98] = -10.2713736253513
    jac_trap[103,99] = -24.9575997948692
    jac_trap[103,100] = -23.2849644809540
    jac_trap[103,101] = 88.4888280826460
    jac_trap[103,102] = 18.6937810814837
    jac_trap[103,103] = -242.095286143588
    jac_trap[103,104] = -113.786109551688
    jac_trap[103,105] = 88.4888280826460
    jac_trap[103,106] = 18.6937810814837
    jac_trap[103,107] = 58.9235503101833
    jac_trap[103,108] = 45.7766907664085
    jac_trap[103,109] = -39.6392229058202
    jac_trap[103,110] = -10.2713736253513
    jac_trap[103,111] = 105.571769313180
    jac_trap[103,112] = 54.0657727682604
    jac_trap[103,113] = -39.6392229058201
    jac_trap[103,114] = -10.2713736253513
    jac_trap[103,115] = -24.9575997948692
    jac_trap[103,116] = -23.2849644809540
    jac_trap[104,25] = -1.84896616921897
    jac_trap[104,26] = -9.21038227100566
    jac_trap[104,27] = -5.65456401516768
    jac_trap[104,28] = 30.9517475172273
    jac_trap[104,29] = -1.84896616921897
    jac_trap[104,30] = -9.21038227100566
    jac_trap[104,31] = -0.793238195499528
    jac_trap[104,32] = -9.00835072044485
    jac_trap[104,93] = 10.2713736253513
    jac_trap[104,94] = -39.6392229058202
    jac_trap[104,95] = -54.0657727682604
    jac_trap[104,96] = 105.571769313180
    jac_trap[104,97] = 10.2713736253513
    jac_trap[104,98] = -39.6392229058201
    jac_trap[104,99] = 23.2849644809540
    jac_trap[104,100] = -24.9575997948692
    jac_trap[104,101] = -18.6937810814837
    jac_trap[104,102] = 88.4888280826460
    jac_trap[104,103] = 113.786109551688
    jac_trap[104,104] = -242.095286143588
    jac_trap[104,105] = -18.6937810814837
    jac_trap[104,106] = 88.4888280826460
    jac_trap[104,107] = -45.7766907664085
    jac_trap[104,108] = 58.9235503101833
    jac_trap[104,109] = 10.2713736253513
    jac_trap[104,110] = -39.6392229058202
    jac_trap[104,111] = -54.0657727682604
    jac_trap[104,112] = 105.571769313180
    jac_trap[104,113] = 10.2713736253513
    jac_trap[104,114] = -39.6392229058201
    jac_trap[104,115] = 23.2849644809540
    jac_trap[104,116] = -24.9575997948692
    jac_trap[105,25] = -9.00835072044484
    jac_trap[105,26] = 0.793238195499527
    jac_trap[105,27] = -9.21038227100566
    jac_trap[105,28] = 1.84896616921897
    jac_trap[105,29] = 30.9517475172273
    jac_trap[105,30] = 5.65456401516768
    jac_trap[105,31] = -9.21038227100566
    jac_trap[105,32] = 1.84896616921897
    jac_trap[105,93] = -24.9575997948692
    jac_trap[105,94] = -23.2849644809540
    jac_trap[105,95] = -39.6392229058202
    jac_trap[105,96] = -10.2713736253513
    jac_trap[105,97] = 105.571769313180
    jac_trap[105,98] = 54.0657727682604
    jac_trap[105,99] = -39.6392229058201
    jac_trap[105,100] = -10.2713736253514
    jac_trap[105,101] = 58.9235503101833
    jac_trap[105,102] = 45.7766907664085
    jac_trap[105,103] = 88.4888280826461
    jac_trap[105,104] = 18.6937810814837
    jac_trap[105,105] = -242.095286143588
    jac_trap[105,106] = -113.786109551688
    jac_trap[105,107] = 88.4888280826459
    jac_trap[105,108] = 18.6937810814837
    jac_trap[105,109] = -24.9575997948692
    jac_trap[105,110] = -23.2849644809540
    jac_trap[105,111] = -39.6392229058202
    jac_trap[105,112] = -10.2713736253513
    jac_trap[105,113] = 105.571769313180
    jac_trap[105,114] = 54.0657727682604
    jac_trap[105,115] = -39.6392229058201
    jac_trap[105,116] = -10.2713736253514
    jac_trap[106,25] = -0.793238195499527
    jac_trap[106,26] = -9.00835072044484
    jac_trap[106,27] = -1.84896616921897
    jac_trap[106,28] = -9.21038227100566
    jac_trap[106,29] = -5.65456401516768
    jac_trap[106,30] = 30.9517475172273
    jac_trap[106,31] = -1.84896616921897
    jac_trap[106,32] = -9.21038227100566
    jac_trap[106,93] = 23.2849644809540
    jac_trap[106,94] = -24.9575997948692
    jac_trap[106,95] = 10.2713736253513
    jac_trap[106,96] = -39.6392229058202
    jac_trap[106,97] = -54.0657727682604
    jac_trap[106,98] = 105.571769313180
    jac_trap[106,99] = 10.2713736253514
    jac_trap[106,100] = -39.6392229058201
    jac_trap[106,101] = -45.7766907664085
    jac_trap[106,102] = 58.9235503101833
    jac_trap[106,103] = -18.6937810814837
    jac_trap[106,104] = 88.4888280826461
    jac_trap[106,105] = 113.786109551688
    jac_trap[106,106] = -242.095286143588
    jac_trap[106,107] = -18.6937810814837
    jac_trap[106,108] = 88.4888280826459
    jac_trap[106,109] = 23.2849644809540
    jac_trap[106,110] = -24.9575997948692
    jac_trap[106,111] = 10.2713736253513
    jac_trap[106,112] = -39.6392229058202
    jac_trap[106,113] = -54.0657727682604
    jac_trap[106,114] = 105.571769313180
    jac_trap[106,115] = 10.2713736253514
    jac_trap[106,116] = -39.6392229058201
    jac_trap[107,25] = -9.21038227100566
    jac_trap[107,26] = 1.84896616921897
    jac_trap[107,27] = -9.00835072044485
    jac_trap[107,28] = 0.793238195499527
    jac_trap[107,29] = -9.21038227100566
    jac_trap[107,30] = 1.84896616921897
    jac_trap[107,31] = 30.9517475172273
    jac_trap[107,32] = 5.65456401516768
    jac_trap[107,93] = -39.6392229058202
    jac_trap[107,94] = -10.2713736253513
    jac_trap[107,95] = -24.9575997948692
    jac_trap[107,96] = -23.2849644809540
    jac_trap[107,97] = -39.6392229058202
    jac_trap[107,98] = -10.2713736253513
    jac_trap[107,99] = 105.571769313180
    jac_trap[107,100] = 54.0657727682604
    jac_trap[107,101] = 88.4888280826460
    jac_trap[107,102] = 18.6937810814837
    jac_trap[107,103] = 58.9235503101832
    jac_trap[107,104] = 45.7766907664085
    jac_trap[107,105] = 88.4888280826460
    jac_trap[107,106] = 18.6937810814837
    jac_trap[107,107] = -242.120286143588
    jac_trap[107,108] = -113.786109551688
    jac_trap[107,109] = -39.6392229058202
    jac_trap[107,110] = -10.2713736253513
    jac_trap[107,111] = -24.9575997948692
    jac_trap[107,112] = -23.2849644809540
    jac_trap[107,113] = -39.6392229058202
    jac_trap[107,114] = -10.2713736253513
    jac_trap[107,115] = 105.571769313180
    jac_trap[107,116] = 54.0657727682604
    jac_trap[108,25] = -1.84896616921897
    jac_trap[108,26] = -9.21038227100566
    jac_trap[108,27] = -0.793238195499527
    jac_trap[108,28] = -9.00835072044485
    jac_trap[108,29] = -1.84896616921897
    jac_trap[108,30] = -9.21038227100566
    jac_trap[108,31] = -5.65456401516768
    jac_trap[108,32] = 30.9517475172273
    jac_trap[108,93] = 10.2713736253513
    jac_trap[108,94] = -39.6392229058202
    jac_trap[108,95] = 23.2849644809540
    jac_trap[108,96] = -24.9575997948692
    jac_trap[108,97] = 10.2713736253513
    jac_trap[108,98] = -39.6392229058202
    jac_trap[108,99] = -54.0657727682604
    jac_trap[108,100] = 105.571769313180
    jac_trap[108,101] = -18.6937810814837
    jac_trap[108,102] = 88.4888280826460
    jac_trap[108,103] = -45.7766907664085
    jac_trap[108,104] = 58.9235503101832
    jac_trap[108,105] = -18.6937810814837
    jac_trap[108,106] = 88.4888280826460
    jac_trap[108,107] = 113.786109551688
    jac_trap[108,108] = -242.120286143588
    jac_trap[108,109] = 10.2713736253513
    jac_trap[108,110] = -39.6392229058202
    jac_trap[108,111] = 23.2849644809540
    jac_trap[108,112] = -24.9575997948692
    jac_trap[108,113] = 10.2713736253513
    jac_trap[108,114] = -39.6392229058202
    jac_trap[108,115] = -54.0657727682604
    jac_trap[108,116] = 105.571769313180
    jac_trap[109,101] = 105.571769313180
    jac_trap[109,102] = 54.0657727682604
    jac_trap[109,103] = -39.6392229058202
    jac_trap[109,104] = -10.2713736253513
    jac_trap[109,105] = -24.9575997948692
    jac_trap[109,106] = -23.2849644809540
    jac_trap[109,107] = -39.6392229058202
    jac_trap[109,108] = -10.2713736253513
    jac_trap[109,109] = -211.143538626360
    jac_trap[109,110] = -108.131545536521
    jac_trap[109,111] = 79.2784458116403
    jac_trap[109,112] = 20.5427472507027
    jac_trap[109,113] = 49.9151995897384
    jac_trap[109,114] = 46.5699289619080
    jac_trap[109,115] = 79.2784458116403
    jac_trap[109,116] = 20.5427472507027
    jac_trap[109,117] = 105.571769313180
    jac_trap[109,118] = 54.0657727682604
    jac_trap[109,119] = -39.6392229058202
    jac_trap[109,120] = -10.2713736253513
    jac_trap[109,121] = -24.9575997948692
    jac_trap[109,122] = -23.2849644809540
    jac_trap[109,123] = -39.6392229058202
    jac_trap[109,124] = -10.2713736253513
    jac_trap[110,101] = -54.0657727682604
    jac_trap[110,102] = 105.571769313180
    jac_trap[110,103] = 10.2713736253513
    jac_trap[110,104] = -39.6392229058202
    jac_trap[110,105] = 23.2849644809540
    jac_trap[110,106] = -24.9575997948692
    jac_trap[110,107] = 10.2713736253513
    jac_trap[110,108] = -39.6392229058202
    jac_trap[110,109] = 108.131545536521
    jac_trap[110,110] = -211.143538626360
    jac_trap[110,111] = -20.5427472507027
    jac_trap[110,112] = 79.2784458116403
    jac_trap[110,113] = -46.5699289619080
    jac_trap[110,114] = 49.9151995897384
    jac_trap[110,115] = -20.5427472507027
    jac_trap[110,116] = 79.2784458116403
    jac_trap[110,117] = -54.0657727682604
    jac_trap[110,118] = 105.571769313180
    jac_trap[110,119] = 10.2713736253513
    jac_trap[110,120] = -39.6392229058202
    jac_trap[110,121] = 23.2849644809540
    jac_trap[110,122] = -24.9575997948692
    jac_trap[110,123] = 10.2713736253513
    jac_trap[110,124] = -39.6392229058202
    jac_trap[111,101] = -39.6392229058202
    jac_trap[111,102] = -10.2713736253513
    jac_trap[111,103] = 105.571769313180
    jac_trap[111,104] = 54.0657727682604
    jac_trap[111,105] = -39.6392229058201
    jac_trap[111,106] = -10.2713736253513
    jac_trap[111,107] = -24.9575997948692
    jac_trap[111,108] = -23.2849644809540
    jac_trap[111,109] = 79.2784458116403
    jac_trap[111,110] = 20.5427472507027
    jac_trap[111,111] = -211.143538626360
    jac_trap[111,112] = -108.131545536521
    jac_trap[111,113] = 79.2784458116403
    jac_trap[111,114] = 20.5427472507027
    jac_trap[111,115] = 49.9151995897384
    jac_trap[111,116] = 46.5699289619080
    jac_trap[111,117] = -39.6392229058202
    jac_trap[111,118] = -10.2713736253513
    jac_trap[111,119] = 105.571769313180
    jac_trap[111,120] = 54.0657727682604
    jac_trap[111,121] = -39.6392229058201
    jac_trap[111,122] = -10.2713736253513
    jac_trap[111,123] = -24.9575997948692
    jac_trap[111,124] = -23.2849644809540
    jac_trap[112,101] = 10.2713736253513
    jac_trap[112,102] = -39.6392229058202
    jac_trap[112,103] = -54.0657727682604
    jac_trap[112,104] = 105.571769313180
    jac_trap[112,105] = 10.2713736253513
    jac_trap[112,106] = -39.6392229058201
    jac_trap[112,107] = 23.2849644809540
    jac_trap[112,108] = -24.9575997948692
    jac_trap[112,109] = -20.5427472507027
    jac_trap[112,110] = 79.2784458116403
    jac_trap[112,111] = 108.131545536521
    jac_trap[112,112] = -211.143538626360
    jac_trap[112,113] = -20.5427472507027
    jac_trap[112,114] = 79.2784458116403
    jac_trap[112,115] = -46.5699289619080
    jac_trap[112,116] = 49.9151995897384
    jac_trap[112,117] = 10.2713736253513
    jac_trap[112,118] = -39.6392229058202
    jac_trap[112,119] = -54.0657727682604
    jac_trap[112,120] = 105.571769313180
    jac_trap[112,121] = 10.2713736253513
    jac_trap[112,122] = -39.6392229058201
    jac_trap[112,123] = 23.2849644809540
    jac_trap[112,124] = -24.9575997948692
    jac_trap[113,101] = -24.9575997948692
    jac_trap[113,102] = -23.2849644809540
    jac_trap[113,103] = -39.6392229058202
    jac_trap[113,104] = -10.2713736253513
    jac_trap[113,105] = 105.571769313180
    jac_trap[113,106] = 54.0657727682604
    jac_trap[113,107] = -39.6392229058201
    jac_trap[113,108] = -10.2713736253514
    jac_trap[113,109] = 49.9151995897384
    jac_trap[113,110] = 46.5699289619080
    jac_trap[113,111] = 79.2784458116404
    jac_trap[113,112] = 20.5427472507027
    jac_trap[113,113] = -211.143538626360
    jac_trap[113,114] = -108.131545536521
    jac_trap[113,115] = 79.2784458116403
    jac_trap[113,116] = 20.5427472507027
    jac_trap[113,117] = -24.9575997948692
    jac_trap[113,118] = -23.2849644809540
    jac_trap[113,119] = -39.6392229058202
    jac_trap[113,120] = -10.2713736253513
    jac_trap[113,121] = 105.571769313180
    jac_trap[113,122] = 54.0657727682604
    jac_trap[113,123] = -39.6392229058201
    jac_trap[113,124] = -10.2713736253514
    jac_trap[114,101] = 23.2849644809540
    jac_trap[114,102] = -24.9575997948692
    jac_trap[114,103] = 10.2713736253513
    jac_trap[114,104] = -39.6392229058202
    jac_trap[114,105] = -54.0657727682604
    jac_trap[114,106] = 105.571769313180
    jac_trap[114,107] = 10.2713736253514
    jac_trap[114,108] = -39.6392229058201
    jac_trap[114,109] = -46.5699289619080
    jac_trap[114,110] = 49.9151995897384
    jac_trap[114,111] = -20.5427472507027
    jac_trap[114,112] = 79.2784458116404
    jac_trap[114,113] = 108.131545536521
    jac_trap[114,114] = -211.143538626360
    jac_trap[114,115] = -20.5427472507027
    jac_trap[114,116] = 79.2784458116403
    jac_trap[114,117] = 23.2849644809540
    jac_trap[114,118] = -24.9575997948692
    jac_trap[114,119] = 10.2713736253513
    jac_trap[114,120] = -39.6392229058202
    jac_trap[114,121] = -54.0657727682604
    jac_trap[114,122] = 105.571769313180
    jac_trap[114,123] = 10.2713736253514
    jac_trap[114,124] = -39.6392229058201
    jac_trap[115,101] = -39.6392229058202
    jac_trap[115,102] = -10.2713736253513
    jac_trap[115,103] = -24.9575997948692
    jac_trap[115,104] = -23.2849644809540
    jac_trap[115,105] = -39.6392229058202
    jac_trap[115,106] = -10.2713736253513
    jac_trap[115,107] = 105.571769313180
    jac_trap[115,108] = 54.0657727682604
    jac_trap[115,109] = 79.2784458116403
    jac_trap[115,110] = 20.5427472507027
    jac_trap[115,111] = 49.9151995897384
    jac_trap[115,112] = 46.5699289619080
    jac_trap[115,113] = 79.2784458116403
    jac_trap[115,114] = 20.5427472507027
    jac_trap[115,115] = -211.143538626360
    jac_trap[115,116] = -108.131545536521
    jac_trap[115,117] = -39.6392229058202
    jac_trap[115,118] = -10.2713736253513
    jac_trap[115,119] = -24.9575997948692
    jac_trap[115,120] = -23.2849644809540
    jac_trap[115,121] = -39.6392229058202
    jac_trap[115,122] = -10.2713736253513
    jac_trap[115,123] = 105.571769313180
    jac_trap[115,124] = 54.0657727682604
    jac_trap[116,101] = 10.2713736253513
    jac_trap[116,102] = -39.6392229058202
    jac_trap[116,103] = 23.2849644809540
    jac_trap[116,104] = -24.9575997948692
    jac_trap[116,105] = 10.2713736253513
    jac_trap[116,106] = -39.6392229058202
    jac_trap[116,107] = -54.0657727682604
    jac_trap[116,108] = 105.571769313180
    jac_trap[116,109] = -20.5427472507027
    jac_trap[116,110] = 79.2784458116403
    jac_trap[116,111] = -46.5699289619080
    jac_trap[116,112] = 49.9151995897384
    jac_trap[116,113] = -20.5427472507027
    jac_trap[116,114] = 79.2784458116403
    jac_trap[116,115] = 108.131545536521
    jac_trap[116,116] = -211.143538626360
    jac_trap[116,117] = 10.2713736253513
    jac_trap[116,118] = -39.6392229058202
    jac_trap[116,119] = 23.2849644809540
    jac_trap[116,120] = -24.9575997948692
    jac_trap[116,121] = 10.2713736253513
    jac_trap[116,122] = -39.6392229058202
    jac_trap[116,123] = -54.0657727682604
    jac_trap[116,124] = 105.571769313180
    jac_trap[117,109] = 105.571769313180
    jac_trap[117,110] = 54.0657727682604
    jac_trap[117,111] = -39.6392229058202
    jac_trap[117,112] = -10.2713736253513
    jac_trap[117,113] = -24.9575997948692
    jac_trap[117,114] = -23.2849644809540
    jac_trap[117,115] = -39.6392229058202
    jac_trap[117,116] = -10.2713736253513
    jac_trap[117,117] = -211.143538626360
    jac_trap[117,118] = -108.131545536521
    jac_trap[117,119] = 79.2784458116403
    jac_trap[117,120] = 20.5427472507027
    jac_trap[117,121] = 49.9151995897384
    jac_trap[117,122] = 46.5699289619080
    jac_trap[117,123] = 79.2784458116403
    jac_trap[117,124] = 20.5427472507027
    jac_trap[117,125] = 105.571769313180
    jac_trap[117,126] = 54.0657727682604
    jac_trap[117,127] = -39.6392229058202
    jac_trap[117,128] = -10.2713736253513
    jac_trap[117,129] = -24.9575997948692
    jac_trap[117,130] = -23.2849644809540
    jac_trap[117,131] = -39.6392229058202
    jac_trap[117,132] = -10.2713736253513
    jac_trap[118,109] = -54.0657727682604
    jac_trap[118,110] = 105.571769313180
    jac_trap[118,111] = 10.2713736253513
    jac_trap[118,112] = -39.6392229058202
    jac_trap[118,113] = 23.2849644809540
    jac_trap[118,114] = -24.9575997948692
    jac_trap[118,115] = 10.2713736253513
    jac_trap[118,116] = -39.6392229058202
    jac_trap[118,117] = 108.131545536521
    jac_trap[118,118] = -211.143538626360
    jac_trap[118,119] = -20.5427472507027
    jac_trap[118,120] = 79.2784458116403
    jac_trap[118,121] = -46.5699289619080
    jac_trap[118,122] = 49.9151995897384
    jac_trap[118,123] = -20.5427472507027
    jac_trap[118,124] = 79.2784458116403
    jac_trap[118,125] = -54.0657727682604
    jac_trap[118,126] = 105.571769313180
    jac_trap[118,127] = 10.2713736253513
    jac_trap[118,128] = -39.6392229058202
    jac_trap[118,129] = 23.2849644809540
    jac_trap[118,130] = -24.9575997948692
    jac_trap[118,131] = 10.2713736253513
    jac_trap[118,132] = -39.6392229058202
    jac_trap[119,109] = -39.6392229058202
    jac_trap[119,110] = -10.2713736253513
    jac_trap[119,111] = 105.571769313180
    jac_trap[119,112] = 54.0657727682604
    jac_trap[119,113] = -39.6392229058201
    jac_trap[119,114] = -10.2713736253513
    jac_trap[119,115] = -24.9575997948692
    jac_trap[119,116] = -23.2849644809540
    jac_trap[119,117] = 79.2784458116403
    jac_trap[119,118] = 20.5427472507027
    jac_trap[119,119] = -211.143538626360
    jac_trap[119,120] = -108.131545536521
    jac_trap[119,121] = 79.2784458116403
    jac_trap[119,122] = 20.5427472507027
    jac_trap[119,123] = 49.9151995897384
    jac_trap[119,124] = 46.5699289619080
    jac_trap[119,125] = -39.6392229058202
    jac_trap[119,126] = -10.2713736253513
    jac_trap[119,127] = 105.571769313180
    jac_trap[119,128] = 54.0657727682604
    jac_trap[119,129] = -39.6392229058201
    jac_trap[119,130] = -10.2713736253513
    jac_trap[119,131] = -24.9575997948692
    jac_trap[119,132] = -23.2849644809540
    jac_trap[120,109] = 10.2713736253513
    jac_trap[120,110] = -39.6392229058202
    jac_trap[120,111] = -54.0657727682604
    jac_trap[120,112] = 105.571769313180
    jac_trap[120,113] = 10.2713736253513
    jac_trap[120,114] = -39.6392229058201
    jac_trap[120,115] = 23.2849644809540
    jac_trap[120,116] = -24.9575997948692
    jac_trap[120,117] = -20.5427472507027
    jac_trap[120,118] = 79.2784458116403
    jac_trap[120,119] = 108.131545536521
    jac_trap[120,120] = -211.143538626360
    jac_trap[120,121] = -20.5427472507027
    jac_trap[120,122] = 79.2784458116403
    jac_trap[120,123] = -46.5699289619080
    jac_trap[120,124] = 49.9151995897384
    jac_trap[120,125] = 10.2713736253513
    jac_trap[120,126] = -39.6392229058202
    jac_trap[120,127] = -54.0657727682604
    jac_trap[120,128] = 105.571769313180
    jac_trap[120,129] = 10.2713736253513
    jac_trap[120,130] = -39.6392229058201
    jac_trap[120,131] = 23.2849644809540
    jac_trap[120,132] = -24.9575997948692
    jac_trap[121,109] = -24.9575997948692
    jac_trap[121,110] = -23.2849644809540
    jac_trap[121,111] = -39.6392229058202
    jac_trap[121,112] = -10.2713736253513
    jac_trap[121,113] = 105.571769313180
    jac_trap[121,114] = 54.0657727682604
    jac_trap[121,115] = -39.6392229058201
    jac_trap[121,116] = -10.2713736253514
    jac_trap[121,117] = 49.9151995897384
    jac_trap[121,118] = 46.5699289619080
    jac_trap[121,119] = 79.2784458116404
    jac_trap[121,120] = 20.5427472507027
    jac_trap[121,121] = -211.143538626360
    jac_trap[121,122] = -108.131545536521
    jac_trap[121,123] = 79.2784458116403
    jac_trap[121,124] = 20.5427472507027
    jac_trap[121,125] = -24.9575997948692
    jac_trap[121,126] = -23.2849644809540
    jac_trap[121,127] = -39.6392229058202
    jac_trap[121,128] = -10.2713736253513
    jac_trap[121,129] = 105.571769313180
    jac_trap[121,130] = 54.0657727682604
    jac_trap[121,131] = -39.6392229058201
    jac_trap[121,132] = -10.2713736253514
    jac_trap[122,109] = 23.2849644809540
    jac_trap[122,110] = -24.9575997948692
    jac_trap[122,111] = 10.2713736253513
    jac_trap[122,112] = -39.6392229058202
    jac_trap[122,113] = -54.0657727682604
    jac_trap[122,114] = 105.571769313180
    jac_trap[122,115] = 10.2713736253514
    jac_trap[122,116] = -39.6392229058201
    jac_trap[122,117] = -46.5699289619080
    jac_trap[122,118] = 49.9151995897384
    jac_trap[122,119] = -20.5427472507027
    jac_trap[122,120] = 79.2784458116404
    jac_trap[122,121] = 108.131545536521
    jac_trap[122,122] = -211.143538626360
    jac_trap[122,123] = -20.5427472507027
    jac_trap[122,124] = 79.2784458116403
    jac_trap[122,125] = 23.2849644809540
    jac_trap[122,126] = -24.9575997948692
    jac_trap[122,127] = 10.2713736253513
    jac_trap[122,128] = -39.6392229058202
    jac_trap[122,129] = -54.0657727682604
    jac_trap[122,130] = 105.571769313180
    jac_trap[122,131] = 10.2713736253514
    jac_trap[122,132] = -39.6392229058201
    jac_trap[123,109] = -39.6392229058202
    jac_trap[123,110] = -10.2713736253513
    jac_trap[123,111] = -24.9575997948692
    jac_trap[123,112] = -23.2849644809540
    jac_trap[123,113] = -39.6392229058202
    jac_trap[123,114] = -10.2713736253513
    jac_trap[123,115] = 105.571769313180
    jac_trap[123,116] = 54.0657727682604
    jac_trap[123,117] = 79.2784458116403
    jac_trap[123,118] = 20.5427472507027
    jac_trap[123,119] = 49.9151995897384
    jac_trap[123,120] = 46.5699289619080
    jac_trap[123,121] = 79.2784458116403
    jac_trap[123,122] = 20.5427472507027
    jac_trap[123,123] = -211.168538626360
    jac_trap[123,124] = -108.131545536521
    jac_trap[123,125] = -39.6392229058202
    jac_trap[123,126] = -10.2713736253513
    jac_trap[123,127] = -24.9575997948692
    jac_trap[123,128] = -23.2849644809540
    jac_trap[123,129] = -39.6392229058202
    jac_trap[123,130] = -10.2713736253513
    jac_trap[123,131] = 105.571769313180
    jac_trap[123,132] = 54.0657727682604
    jac_trap[124,109] = 10.2713736253513
    jac_trap[124,110] = -39.6392229058202
    jac_trap[124,111] = 23.2849644809540
    jac_trap[124,112] = -24.9575997948692
    jac_trap[124,113] = 10.2713736253513
    jac_trap[124,114] = -39.6392229058202
    jac_trap[124,115] = -54.0657727682604
    jac_trap[124,116] = 105.571769313180
    jac_trap[124,117] = -20.5427472507027
    jac_trap[124,118] = 79.2784458116403
    jac_trap[124,119] = -46.5699289619080
    jac_trap[124,120] = 49.9151995897384
    jac_trap[124,121] = -20.5427472507027
    jac_trap[124,122] = 79.2784458116403
    jac_trap[124,123] = 108.131545536521
    jac_trap[124,124] = -211.168538626360
    jac_trap[124,125] = 10.2713736253513
    jac_trap[124,126] = -39.6392229058202
    jac_trap[124,127] = 23.2849644809540
    jac_trap[124,128] = -24.9575997948692
    jac_trap[124,129] = 10.2713736253513
    jac_trap[124,130] = -39.6392229058202
    jac_trap[124,131] = -54.0657727682604
    jac_trap[124,132] = 105.571769313180
    jac_trap[125,33] = 30.9517475172273
    jac_trap[125,34] = 5.65456401516768
    jac_trap[125,35] = -9.21038227100566
    jac_trap[125,36] = 1.84896616921897
    jac_trap[125,37] = -9.00835072044485
    jac_trap[125,38] = 0.793238195499529
    jac_trap[125,39] = -9.21038227100566
    jac_trap[125,40] = 1.84896616921897
    jac_trap[125,117] = 105.571769313180
    jac_trap[125,118] = 54.0657727682604
    jac_trap[125,119] = -39.6392229058202
    jac_trap[125,120] = -10.2713736253513
    jac_trap[125,121] = -24.9575997948692
    jac_trap[125,122] = -23.2849644809540
    jac_trap[125,123] = -39.6392229058202
    jac_trap[125,124] = -10.2713736253513
    jac_trap[125,125] = -242.095286143588
    jac_trap[125,126] = -113.786109551688
    jac_trap[125,127] = 88.4888280826460
    jac_trap[125,128] = 18.6937810814837
    jac_trap[125,129] = 58.9235503101833
    jac_trap[125,130] = 45.7766907664085
    jac_trap[125,131] = 88.4888280826460
    jac_trap[125,132] = 18.6937810814837
    jac_trap[125,133] = 105.571769313180
    jac_trap[125,134] = 54.0657727682604
    jac_trap[125,135] = -39.6392229058202
    jac_trap[125,136] = -10.2713736253513
    jac_trap[125,137] = -24.9575997948692
    jac_trap[125,138] = -23.2849644809540
    jac_trap[125,139] = -39.6392229058202
    jac_trap[125,140] = -10.2713736253513
    jac_trap[126,33] = -5.65456401516768
    jac_trap[126,34] = 30.9517475172273
    jac_trap[126,35] = -1.84896616921897
    jac_trap[126,36] = -9.21038227100566
    jac_trap[126,37] = -0.793238195499529
    jac_trap[126,38] = -9.00835072044485
    jac_trap[126,39] = -1.84896616921897
    jac_trap[126,40] = -9.21038227100566
    jac_trap[126,117] = -54.0657727682604
    jac_trap[126,118] = 105.571769313180
    jac_trap[126,119] = 10.2713736253513
    jac_trap[126,120] = -39.6392229058202
    jac_trap[126,121] = 23.2849644809540
    jac_trap[126,122] = -24.9575997948692
    jac_trap[126,123] = 10.2713736253513
    jac_trap[126,124] = -39.6392229058202
    jac_trap[126,125] = 113.786109551688
    jac_trap[126,126] = -242.095286143588
    jac_trap[126,127] = -18.6937810814837
    jac_trap[126,128] = 88.4888280826460
    jac_trap[126,129] = -45.7766907664085
    jac_trap[126,130] = 58.9235503101833
    jac_trap[126,131] = -18.6937810814837
    jac_trap[126,132] = 88.4888280826460
    jac_trap[126,133] = -54.0657727682604
    jac_trap[126,134] = 105.571769313180
    jac_trap[126,135] = 10.2713736253513
    jac_trap[126,136] = -39.6392229058202
    jac_trap[126,137] = 23.2849644809540
    jac_trap[126,138] = -24.9575997948692
    jac_trap[126,139] = 10.2713736253513
    jac_trap[126,140] = -39.6392229058202
    jac_trap[127,33] = -9.21038227100566
    jac_trap[127,34] = 1.84896616921897
    jac_trap[127,35] = 30.9517475172273
    jac_trap[127,36] = 5.65456401516768
    jac_trap[127,37] = -9.21038227100566
    jac_trap[127,38] = 1.84896616921897
    jac_trap[127,39] = -9.00835072044485
    jac_trap[127,40] = 0.793238195499528
    jac_trap[127,117] = -39.6392229058202
    jac_trap[127,118] = -10.2713736253513
    jac_trap[127,119] = 105.571769313180
    jac_trap[127,120] = 54.0657727682604
    jac_trap[127,121] = -39.6392229058201
    jac_trap[127,122] = -10.2713736253513
    jac_trap[127,123] = -24.9575997948692
    jac_trap[127,124] = -23.2849644809540
    jac_trap[127,125] = 88.4888280826460
    jac_trap[127,126] = 18.6937810814837
    jac_trap[127,127] = -242.095286143588
    jac_trap[127,128] = -113.786109551688
    jac_trap[127,129] = 88.4888280826460
    jac_trap[127,130] = 18.6937810814837
    jac_trap[127,131] = 58.9235503101833
    jac_trap[127,132] = 45.7766907664085
    jac_trap[127,133] = -39.6392229058202
    jac_trap[127,134] = -10.2713736253513
    jac_trap[127,135] = 105.571769313180
    jac_trap[127,136] = 54.0657727682604
    jac_trap[127,137] = -39.6392229058201
    jac_trap[127,138] = -10.2713736253513
    jac_trap[127,139] = -24.9575997948692
    jac_trap[127,140] = -23.2849644809540
    jac_trap[128,33] = -1.84896616921897
    jac_trap[128,34] = -9.21038227100566
    jac_trap[128,35] = -5.65456401516768
    jac_trap[128,36] = 30.9517475172273
    jac_trap[128,37] = -1.84896616921897
    jac_trap[128,38] = -9.21038227100566
    jac_trap[128,39] = -0.793238195499528
    jac_trap[128,40] = -9.00835072044485
    jac_trap[128,117] = 10.2713736253513
    jac_trap[128,118] = -39.6392229058202
    jac_trap[128,119] = -54.0657727682604
    jac_trap[128,120] = 105.571769313180
    jac_trap[128,121] = 10.2713736253513
    jac_trap[128,122] = -39.6392229058201
    jac_trap[128,123] = 23.2849644809540
    jac_trap[128,124] = -24.9575997948692
    jac_trap[128,125] = -18.6937810814837
    jac_trap[128,126] = 88.4888280826460
    jac_trap[128,127] = 113.786109551688
    jac_trap[128,128] = -242.095286143588
    jac_trap[128,129] = -18.6937810814837
    jac_trap[128,130] = 88.4888280826460
    jac_trap[128,131] = -45.7766907664085
    jac_trap[128,132] = 58.9235503101833
    jac_trap[128,133] = 10.2713736253513
    jac_trap[128,134] = -39.6392229058202
    jac_trap[128,135] = -54.0657727682604
    jac_trap[128,136] = 105.571769313180
    jac_trap[128,137] = 10.2713736253513
    jac_trap[128,138] = -39.6392229058201
    jac_trap[128,139] = 23.2849644809540
    jac_trap[128,140] = -24.9575997948692
    jac_trap[129,33] = -9.00835072044484
    jac_trap[129,34] = 0.793238195499527
    jac_trap[129,35] = -9.21038227100566
    jac_trap[129,36] = 1.84896616921897
    jac_trap[129,37] = 30.9517475172273
    jac_trap[129,38] = 5.65456401516768
    jac_trap[129,39] = -9.21038227100566
    jac_trap[129,40] = 1.84896616921897
    jac_trap[129,117] = -24.9575997948692
    jac_trap[129,118] = -23.2849644809540
    jac_trap[129,119] = -39.6392229058202
    jac_trap[129,120] = -10.2713736253513
    jac_trap[129,121] = 105.571769313180
    jac_trap[129,122] = 54.0657727682604
    jac_trap[129,123] = -39.6392229058201
    jac_trap[129,124] = -10.2713736253514
    jac_trap[129,125] = 58.9235503101833
    jac_trap[129,126] = 45.7766907664085
    jac_trap[129,127] = 88.4888280826461
    jac_trap[129,128] = 18.6937810814837
    jac_trap[129,129] = -242.095286143588
    jac_trap[129,130] = -113.786109551688
    jac_trap[129,131] = 88.4888280826459
    jac_trap[129,132] = 18.6937810814837
    jac_trap[129,133] = -24.9575997948692
    jac_trap[129,134] = -23.2849644809540
    jac_trap[129,135] = -39.6392229058202
    jac_trap[129,136] = -10.2713736253513
    jac_trap[129,137] = 105.571769313180
    jac_trap[129,138] = 54.0657727682604
    jac_trap[129,139] = -39.6392229058201
    jac_trap[129,140] = -10.2713736253514
    jac_trap[130,33] = -0.793238195499527
    jac_trap[130,34] = -9.00835072044484
    jac_trap[130,35] = -1.84896616921897
    jac_trap[130,36] = -9.21038227100566
    jac_trap[130,37] = -5.65456401516768
    jac_trap[130,38] = 30.9517475172273
    jac_trap[130,39] = -1.84896616921897
    jac_trap[130,40] = -9.21038227100566
    jac_trap[130,117] = 23.2849644809540
    jac_trap[130,118] = -24.9575997948692
    jac_trap[130,119] = 10.2713736253513
    jac_trap[130,120] = -39.6392229058202
    jac_trap[130,121] = -54.0657727682604
    jac_trap[130,122] = 105.571769313180
    jac_trap[130,123] = 10.2713736253514
    jac_trap[130,124] = -39.6392229058201
    jac_trap[130,125] = -45.7766907664085
    jac_trap[130,126] = 58.9235503101833
    jac_trap[130,127] = -18.6937810814837
    jac_trap[130,128] = 88.4888280826461
    jac_trap[130,129] = 113.786109551688
    jac_trap[130,130] = -242.095286143588
    jac_trap[130,131] = -18.6937810814837
    jac_trap[130,132] = 88.4888280826459
    jac_trap[130,133] = 23.2849644809540
    jac_trap[130,134] = -24.9575997948692
    jac_trap[130,135] = 10.2713736253513
    jac_trap[130,136] = -39.6392229058202
    jac_trap[130,137] = -54.0657727682604
    jac_trap[130,138] = 105.571769313180
    jac_trap[130,139] = 10.2713736253514
    jac_trap[130,140] = -39.6392229058201
    jac_trap[131,33] = -9.21038227100566
    jac_trap[131,34] = 1.84896616921897
    jac_trap[131,35] = -9.00835072044485
    jac_trap[131,36] = 0.793238195499527
    jac_trap[131,37] = -9.21038227100566
    jac_trap[131,38] = 1.84896616921897
    jac_trap[131,39] = 30.9517475172273
    jac_trap[131,40] = 5.65456401516768
    jac_trap[131,117] = -39.6392229058202
    jac_trap[131,118] = -10.2713736253513
    jac_trap[131,119] = -24.9575997948692
    jac_trap[131,120] = -23.2849644809540
    jac_trap[131,121] = -39.6392229058202
    jac_trap[131,122] = -10.2713736253513
    jac_trap[131,123] = 105.571769313180
    jac_trap[131,124] = 54.0657727682604
    jac_trap[131,125] = 88.4888280826460
    jac_trap[131,126] = 18.6937810814837
    jac_trap[131,127] = 58.9235503101832
    jac_trap[131,128] = 45.7766907664085
    jac_trap[131,129] = 88.4888280826460
    jac_trap[131,130] = 18.6937810814837
    jac_trap[131,131] = -242.095286143588
    jac_trap[131,132] = -113.786109551688
    jac_trap[131,133] = -39.6392229058202
    jac_trap[131,134] = -10.2713736253513
    jac_trap[131,135] = -24.9575997948692
    jac_trap[131,136] = -23.2849644809540
    jac_trap[131,137] = -39.6392229058202
    jac_trap[131,138] = -10.2713736253513
    jac_trap[131,139] = 105.571769313180
    jac_trap[131,140] = 54.0657727682604
    jac_trap[132,33] = -1.84896616921897
    jac_trap[132,34] = -9.21038227100566
    jac_trap[132,35] = -0.793238195499527
    jac_trap[132,36] = -9.00835072044485
    jac_trap[132,37] = -1.84896616921897
    jac_trap[132,38] = -9.21038227100566
    jac_trap[132,39] = -5.65456401516768
    jac_trap[132,40] = 30.9517475172273
    jac_trap[132,117] = 10.2713736253513
    jac_trap[132,118] = -39.6392229058202
    jac_trap[132,119] = 23.2849644809540
    jac_trap[132,120] = -24.9575997948692
    jac_trap[132,121] = 10.2713736253513
    jac_trap[132,122] = -39.6392229058202
    jac_trap[132,123] = -54.0657727682604
    jac_trap[132,124] = 105.571769313180
    jac_trap[132,125] = -18.6937810814837
    jac_trap[132,126] = 88.4888280826460
    jac_trap[132,127] = -45.7766907664085
    jac_trap[132,128] = 58.9235503101832
    jac_trap[132,129] = -18.6937810814837
    jac_trap[132,130] = 88.4888280826460
    jac_trap[132,131] = 113.786109551688
    jac_trap[132,132] = -242.095286143588
    jac_trap[132,133] = 10.2713736253513
    jac_trap[132,134] = -39.6392229058202
    jac_trap[132,135] = 23.2849644809540
    jac_trap[132,136] = -24.9575997948692
    jac_trap[132,137] = 10.2713736253513
    jac_trap[132,138] = -39.6392229058202
    jac_trap[132,139] = -54.0657727682604
    jac_trap[132,140] = 105.571769313180
    jac_trap[133,41] = 30.9517475172273
    jac_trap[133,42] = 5.65456401516768
    jac_trap[133,43] = -9.21038227100566
    jac_trap[133,44] = 1.84896616921897
    jac_trap[133,45] = -9.00835072044485
    jac_trap[133,46] = 0.793238195499529
    jac_trap[133,47] = -9.21038227100566
    jac_trap[133,48] = 1.84896616921897
    jac_trap[133,125] = 105.571769313180
    jac_trap[133,126] = 54.0657727682604
    jac_trap[133,127] = -39.6392229058202
    jac_trap[133,128] = -10.2713736253513
    jac_trap[133,129] = -24.9575997948692
    jac_trap[133,130] = -23.2849644809540
    jac_trap[133,131] = -39.6392229058202
    jac_trap[133,132] = -10.2713736253513
    jac_trap[133,133] = -136.523516830407
    jac_trap[133,134] = -59.7203367834281
    jac_trap[133,135] = 48.8496051768258
    jac_trap[133,136] = 8.42240745613237
    jac_trap[133,137] = 33.9659505153141
    jac_trap[133,138] = 22.4917262854545
    jac_trap[133,139] = 48.8496051768258
    jac_trap[133,140] = 8.42240745613237
    jac_trap[133,414] = 1
    jac_trap[134,41] = -5.65456401516768
    jac_trap[134,42] = 30.9517475172273
    jac_trap[134,43] = -1.84896616921897
    jac_trap[134,44] = -9.21038227100566
    jac_trap[134,45] = -0.793238195499529
    jac_trap[134,46] = -9.00835072044485
    jac_trap[134,47] = -1.84896616921897
    jac_trap[134,48] = -9.21038227100566
    jac_trap[134,125] = -54.0657727682604
    jac_trap[134,126] = 105.571769313180
    jac_trap[134,127] = 10.2713736253513
    jac_trap[134,128] = -39.6392229058202
    jac_trap[134,129] = 23.2849644809540
    jac_trap[134,130] = -24.9575997948692
    jac_trap[134,131] = 10.2713736253513
    jac_trap[134,132] = -39.6392229058202
    jac_trap[134,133] = 59.7203367834281
    jac_trap[134,134] = -136.523516830407
    jac_trap[134,135] = -8.42240745613237
    jac_trap[134,136] = 48.8496051768258
    jac_trap[134,137] = -22.4917262854545
    jac_trap[134,138] = 33.9659505153141
    jac_trap[134,139] = -8.42240745613237
    jac_trap[134,140] = 48.8496051768258
    jac_trap[134,415] = 1
    jac_trap[135,41] = -9.21038227100566
    jac_trap[135,42] = 1.84896616921897
    jac_trap[135,43] = 30.9517475172273
    jac_trap[135,44] = 5.65456401516768
    jac_trap[135,45] = -9.21038227100566
    jac_trap[135,46] = 1.84896616921897
    jac_trap[135,47] = -9.00835072044485
    jac_trap[135,48] = 0.793238195499528
    jac_trap[135,125] = -39.6392229058202
    jac_trap[135,126] = -10.2713736253513
    jac_trap[135,127] = 105.571769313180
    jac_trap[135,128] = 54.0657727682604
    jac_trap[135,129] = -39.6392229058201
    jac_trap[135,130] = -10.2713736253513
    jac_trap[135,131] = -24.9575997948692
    jac_trap[135,132] = -23.2849644809540
    jac_trap[135,133] = 48.8496051768258
    jac_trap[135,134] = 8.42240745613237
    jac_trap[135,135] = -136.523516830407
    jac_trap[135,136] = -59.7203367834280
    jac_trap[135,137] = 48.8496051768258
    jac_trap[135,138] = 8.42240745613238
    jac_trap[135,139] = 33.9659505153141
    jac_trap[135,140] = 22.4917262854545
    jac_trap[135,416] = 1
    jac_trap[136,41] = -1.84896616921897
    jac_trap[136,42] = -9.21038227100566
    jac_trap[136,43] = -5.65456401516768
    jac_trap[136,44] = 30.9517475172273
    jac_trap[136,45] = -1.84896616921897
    jac_trap[136,46] = -9.21038227100566
    jac_trap[136,47] = -0.793238195499528
    jac_trap[136,48] = -9.00835072044485
    jac_trap[136,125] = 10.2713736253513
    jac_trap[136,126] = -39.6392229058202
    jac_trap[136,127] = -54.0657727682604
    jac_trap[136,128] = 105.571769313180
    jac_trap[136,129] = 10.2713736253513
    jac_trap[136,130] = -39.6392229058201
    jac_trap[136,131] = 23.2849644809540
    jac_trap[136,132] = -24.9575997948692
    jac_trap[136,133] = -8.42240745613237
    jac_trap[136,134] = 48.8496051768258
    jac_trap[136,135] = 59.7203367834280
    jac_trap[136,136] = -136.523516830407
    jac_trap[136,137] = -8.42240745613238
    jac_trap[136,138] = 48.8496051768258
    jac_trap[136,139] = -22.4917262854545
    jac_trap[136,140] = 33.9659505153141
    jac_trap[136,417] = 1
    jac_trap[137,41] = -9.00835072044484
    jac_trap[137,42] = 0.793238195499527
    jac_trap[137,43] = -9.21038227100566
    jac_trap[137,44] = 1.84896616921897
    jac_trap[137,45] = 30.9517475172273
    jac_trap[137,46] = 5.65456401516768
    jac_trap[137,47] = -9.21038227100566
    jac_trap[137,48] = 1.84896616921897
    jac_trap[137,125] = -24.9575997948692
    jac_trap[137,126] = -23.2849644809540
    jac_trap[137,127] = -39.6392229058202
    jac_trap[137,128] = -10.2713736253513
    jac_trap[137,129] = 105.571769313180
    jac_trap[137,130] = 54.0657727682604
    jac_trap[137,131] = -39.6392229058201
    jac_trap[137,132] = -10.2713736253514
    jac_trap[137,133] = 33.9659505153141
    jac_trap[137,134] = 22.4917262854545
    jac_trap[137,135] = 48.8496051768259
    jac_trap[137,136] = 8.42240745613236
    jac_trap[137,137] = -136.523516830407
    jac_trap[137,138] = -59.7203367834281
    jac_trap[137,139] = 48.8496051768258
    jac_trap[137,140] = 8.42240745613239
    jac_trap[137,418] = 1
    jac_trap[138,41] = -0.793238195499527
    jac_trap[138,42] = -9.00835072044484
    jac_trap[138,43] = -1.84896616921897
    jac_trap[138,44] = -9.21038227100566
    jac_trap[138,45] = -5.65456401516768
    jac_trap[138,46] = 30.9517475172273
    jac_trap[138,47] = -1.84896616921897
    jac_trap[138,48] = -9.21038227100566
    jac_trap[138,125] = 23.2849644809540
    jac_trap[138,126] = -24.9575997948692
    jac_trap[138,127] = 10.2713736253513
    jac_trap[138,128] = -39.6392229058202
    jac_trap[138,129] = -54.0657727682604
    jac_trap[138,130] = 105.571769313180
    jac_trap[138,131] = 10.2713736253514
    jac_trap[138,132] = -39.6392229058201
    jac_trap[138,133] = -22.4917262854545
    jac_trap[138,134] = 33.9659505153141
    jac_trap[138,135] = -8.42240745613236
    jac_trap[138,136] = 48.8496051768259
    jac_trap[138,137] = 59.7203367834281
    jac_trap[138,138] = -136.523516830407
    jac_trap[138,139] = -8.42240745613239
    jac_trap[138,140] = 48.8496051768258
    jac_trap[138,419] = 1
    jac_trap[139,41] = -9.21038227100566
    jac_trap[139,42] = 1.84896616921897
    jac_trap[139,43] = -9.00835072044485
    jac_trap[139,44] = 0.793238195499527
    jac_trap[139,45] = -9.21038227100566
    jac_trap[139,46] = 1.84896616921897
    jac_trap[139,47] = 30.9517475172273
    jac_trap[139,48] = 5.65456401516768
    jac_trap[139,125] = -39.6392229058202
    jac_trap[139,126] = -10.2713736253513
    jac_trap[139,127] = -24.9575997948692
    jac_trap[139,128] = -23.2849644809540
    jac_trap[139,129] = -39.6392229058202
    jac_trap[139,130] = -10.2713736253513
    jac_trap[139,131] = 105.571769313180
    jac_trap[139,132] = 54.0657727682604
    jac_trap[139,133] = 48.8496051768258
    jac_trap[139,134] = 8.42240745613237
    jac_trap[139,135] = 33.9659505153140
    jac_trap[139,136] = 22.4917262854545
    jac_trap[139,137] = 48.8496051768258
    jac_trap[139,138] = 8.42240745613237
    jac_trap[139,139] = -136.548516830407
    jac_trap[139,140] = -59.7203367834281
    jac_trap[140,41] = -1.84896616921897
    jac_trap[140,42] = -9.21038227100566
    jac_trap[140,43] = -0.793238195499527
    jac_trap[140,44] = -9.00835072044485
    jac_trap[140,45] = -1.84896616921897
    jac_trap[140,46] = -9.21038227100566
    jac_trap[140,47] = -5.65456401516768
    jac_trap[140,48] = 30.9517475172273
    jac_trap[140,125] = 10.2713736253513
    jac_trap[140,126] = -39.6392229058202
    jac_trap[140,127] = 23.2849644809540
    jac_trap[140,128] = -24.9575997948692
    jac_trap[140,129] = 10.2713736253513
    jac_trap[140,130] = -39.6392229058202
    jac_trap[140,131] = -54.0657727682604
    jac_trap[140,132] = 105.571769313180
    jac_trap[140,133] = -8.42240745613237
    jac_trap[140,134] = 48.8496051768258
    jac_trap[140,135] = -22.4917262854545
    jac_trap[140,136] = 33.9659505153140
    jac_trap[140,137] = -8.42240745613237
    jac_trap[140,138] = 48.8496051768258
    jac_trap[140,139] = 59.7203367834281
    jac_trap[140,140] = -136.548516830407
    jac_trap[141,85] = 26.5300693004806
    jac_trap[141,86] = 4.84676915585801
    jac_trap[141,87] = -7.89461337514770
    jac_trap[141,88] = 1.58482814504483
    jac_trap[141,89] = -7.72144347466701
    jac_trap[141,90] = 0.679918453285310
    jac_trap[141,91] = -7.89461337514771
    jac_trap[141,92] = 1.58482814504483
    jac_trap[141,141] = -53.0601386009611
    jac_trap[141,142] = -9.69353831171601
    jac_trap[141,143] = 15.7892267502954
    jac_trap[141,144] = -3.16965629008966
    jac_trap[141,145] = 15.4428869493340
    jac_trap[141,146] = -1.35983690657062
    jac_trap[141,147] = 15.7892267502954
    jac_trap[141,148] = -3.16965629008966
    jac_trap[141,149] = 26.5300693004806
    jac_trap[141,150] = 4.84676915585801
    jac_trap[141,151] = -7.89461337514770
    jac_trap[141,152] = 1.58482814504483
    jac_trap[141,153] = -7.72144347466701
    jac_trap[141,154] = 0.679918453285310
    jac_trap[141,155] = -7.89461337514771
    jac_trap[141,156] = 1.58482814504483
    jac_trap[142,85] = -4.84676915585801
    jac_trap[142,86] = 26.5300693004806
    jac_trap[142,87] = -1.58482814504483
    jac_trap[142,88] = -7.89461337514770
    jac_trap[142,89] = -0.679918453285310
    jac_trap[142,90] = -7.72144347466701
    jac_trap[142,91] = -1.58482814504483
    jac_trap[142,92] = -7.89461337514771
    jac_trap[142,141] = 9.69353831171601
    jac_trap[142,142] = -53.0601386009611
    jac_trap[142,143] = 3.16965629008966
    jac_trap[142,144] = 15.7892267502954
    jac_trap[142,145] = 1.35983690657062
    jac_trap[142,146] = 15.4428869493340
    jac_trap[142,147] = 3.16965629008966
    jac_trap[142,148] = 15.7892267502954
    jac_trap[142,149] = -4.84676915585801
    jac_trap[142,150] = 26.5300693004806
    jac_trap[142,151] = -1.58482814504483
    jac_trap[142,152] = -7.89461337514770
    jac_trap[142,153] = -0.679918453285310
    jac_trap[142,154] = -7.72144347466701
    jac_trap[142,155] = -1.58482814504483
    jac_trap[142,156] = -7.89461337514771
    jac_trap[143,85] = -7.89461337514771
    jac_trap[143,86] = 1.58482814504483
    jac_trap[143,87] = 26.5300693004806
    jac_trap[143,88] = 4.84676915585801
    jac_trap[143,89] = -7.89461337514771
    jac_trap[143,90] = 1.58482814504483
    jac_trap[143,91] = -7.72144347466701
    jac_trap[143,92] = 0.679918453285308
    jac_trap[143,141] = 15.7892267502954
    jac_trap[143,142] = -3.16965629008966
    jac_trap[143,143] = -53.0601386009611
    jac_trap[143,144] = -9.69353831171602
    jac_trap[143,145] = 15.7892267502954
    jac_trap[143,146] = -3.16965629008967
    jac_trap[143,147] = 15.4428869493340
    jac_trap[143,148] = -1.35983690657062
    jac_trap[143,149] = -7.89461337514771
    jac_trap[143,150] = 1.58482814504483
    jac_trap[143,151] = 26.5300693004806
    jac_trap[143,152] = 4.84676915585801
    jac_trap[143,153] = -7.89461337514771
    jac_trap[143,154] = 1.58482814504483
    jac_trap[143,155] = -7.72144347466701
    jac_trap[143,156] = 0.679918453285308
    jac_trap[144,85] = -1.58482814504483
    jac_trap[144,86] = -7.89461337514771
    jac_trap[144,87] = -4.84676915585801
    jac_trap[144,88] = 26.5300693004806
    jac_trap[144,89] = -1.58482814504483
    jac_trap[144,90] = -7.89461337514771
    jac_trap[144,91] = -0.679918453285308
    jac_trap[144,92] = -7.72144347466701
    jac_trap[144,141] = 3.16965629008966
    jac_trap[144,142] = 15.7892267502954
    jac_trap[144,143] = 9.69353831171602
    jac_trap[144,144] = -53.0601386009611
    jac_trap[144,145] = 3.16965629008967
    jac_trap[144,146] = 15.7892267502954
    jac_trap[144,147] = 1.35983690657062
    jac_trap[144,148] = 15.4428869493340
    jac_trap[144,149] = -1.58482814504483
    jac_trap[144,150] = -7.89461337514771
    jac_trap[144,151] = -4.84676915585801
    jac_trap[144,152] = 26.5300693004806
    jac_trap[144,153] = -1.58482814504483
    jac_trap[144,154] = -7.89461337514771
    jac_trap[144,155] = -0.679918453285308
    jac_trap[144,156] = -7.72144347466701
    jac_trap[145,85] = -7.72144347466701
    jac_trap[145,86] = 0.679918453285310
    jac_trap[145,87] = -7.89461337514770
    jac_trap[145,88] = 1.58482814504483
    jac_trap[145,89] = 26.5300693004806
    jac_trap[145,90] = 4.84676915585801
    jac_trap[145,91] = -7.89461337514771
    jac_trap[145,92] = 1.58482814504483
    jac_trap[145,141] = 15.4428869493340
    jac_trap[145,142] = -1.35983690657062
    jac_trap[145,143] = 15.7892267502954
    jac_trap[145,144] = -3.16965629008966
    jac_trap[145,145] = -53.0601386009611
    jac_trap[145,146] = -9.69353831171602
    jac_trap[145,147] = 15.7892267502954
    jac_trap[145,148] = -3.16965629008967
    jac_trap[145,149] = -7.72144347466701
    jac_trap[145,150] = 0.679918453285310
    jac_trap[145,151] = -7.89461337514770
    jac_trap[145,152] = 1.58482814504483
    jac_trap[145,153] = 26.5300693004806
    jac_trap[145,154] = 4.84676915585801
    jac_trap[145,155] = -7.89461337514771
    jac_trap[145,156] = 1.58482814504483
    jac_trap[146,85] = -0.679918453285310
    jac_trap[146,86] = -7.72144347466701
    jac_trap[146,87] = -1.58482814504483
    jac_trap[146,88] = -7.89461337514770
    jac_trap[146,89] = -4.84676915585801
    jac_trap[146,90] = 26.5300693004806
    jac_trap[146,91] = -1.58482814504483
    jac_trap[146,92] = -7.89461337514771
    jac_trap[146,141] = 1.35983690657062
    jac_trap[146,142] = 15.4428869493340
    jac_trap[146,143] = 3.16965629008966
    jac_trap[146,144] = 15.7892267502954
    jac_trap[146,145] = 9.69353831171602
    jac_trap[146,146] = -53.0601386009611
    jac_trap[146,147] = 3.16965629008967
    jac_trap[146,148] = 15.7892267502954
    jac_trap[146,149] = -0.679918453285310
    jac_trap[146,150] = -7.72144347466701
    jac_trap[146,151] = -1.58482814504483
    jac_trap[146,152] = -7.89461337514770
    jac_trap[146,153] = -4.84676915585801
    jac_trap[146,154] = 26.5300693004806
    jac_trap[146,155] = -1.58482814504483
    jac_trap[146,156] = -7.89461337514771
    jac_trap[147,85] = -7.89461337514771
    jac_trap[147,86] = 1.58482814504483
    jac_trap[147,87] = -7.72144347466701
    jac_trap[147,88] = 0.679918453285308
    jac_trap[147,89] = -7.89461337514771
    jac_trap[147,90] = 1.58482814504483
    jac_trap[147,91] = 26.5300693004806
    jac_trap[147,92] = 4.84676915585801
    jac_trap[147,141] = 15.7892267502954
    jac_trap[147,142] = -3.16965629008966
    jac_trap[147,143] = 15.4428869493340
    jac_trap[147,144] = -1.35983690657062
    jac_trap[147,145] = 15.7892267502954
    jac_trap[147,146] = -3.16965629008966
    jac_trap[147,147] = -53.0601386009611
    jac_trap[147,148] = -9.69353831171602
    jac_trap[147,149] = -7.89461337514771
    jac_trap[147,150] = 1.58482814504483
    jac_trap[147,151] = -7.72144347466701
    jac_trap[147,152] = 0.679918453285308
    jac_trap[147,153] = -7.89461337514771
    jac_trap[147,154] = 1.58482814504483
    jac_trap[147,155] = 26.5300693004806
    jac_trap[147,156] = 4.84676915585801
    jac_trap[148,85] = -1.58482814504483
    jac_trap[148,86] = -7.89461337514771
    jac_trap[148,87] = -0.679918453285308
    jac_trap[148,88] = -7.72144347466701
    jac_trap[148,89] = -1.58482814504483
    jac_trap[148,90] = -7.89461337514771
    jac_trap[148,91] = -4.84676915585801
    jac_trap[148,92] = 26.5300693004806
    jac_trap[148,141] = 3.16965629008966
    jac_trap[148,142] = 15.7892267502954
    jac_trap[148,143] = 1.35983690657062
    jac_trap[148,144] = 15.4428869493340
    jac_trap[148,145] = 3.16965629008966
    jac_trap[148,146] = 15.7892267502954
    jac_trap[148,147] = 9.69353831171602
    jac_trap[148,148] = -53.0601386009611
    jac_trap[148,149] = -1.58482814504483
    jac_trap[148,150] = -7.89461337514771
    jac_trap[148,151] = -0.679918453285308
    jac_trap[148,152] = -7.72144347466701
    jac_trap[148,153] = -1.58482814504483
    jac_trap[148,154] = -7.89461337514771
    jac_trap[148,155] = -4.84676915585801
    jac_trap[148,156] = 26.5300693004806
    jac_trap[149,141] = 26.5300693004806
    jac_trap[149,142] = 4.84676915585801
    jac_trap[149,143] = -7.89461337514770
    jac_trap[149,144] = 1.58482814504483
    jac_trap[149,145] = -7.72144347466701
    jac_trap[149,146] = 0.679918453285310
    jac_trap[149,147] = -7.89461337514771
    jac_trap[149,148] = 1.58482814504483
    jac_trap[149,149] = -53.0601386009611
    jac_trap[149,150] = -9.69353831171601
    jac_trap[149,151] = 15.7892267502954
    jac_trap[149,152] = -3.16965629008966
    jac_trap[149,153] = 15.4428869493340
    jac_trap[149,154] = -1.35983690657062
    jac_trap[149,155] = 15.7892267502954
    jac_trap[149,156] = -3.16965629008966
    jac_trap[149,157] = 26.5300693004806
    jac_trap[149,158] = 4.84676915585801
    jac_trap[149,159] = -7.89461337514770
    jac_trap[149,160] = 1.58482814504483
    jac_trap[149,161] = -7.72144347466701
    jac_trap[149,162] = 0.679918453285310
    jac_trap[149,163] = -7.89461337514771
    jac_trap[149,164] = 1.58482814504483
    jac_trap[150,141] = -4.84676915585801
    jac_trap[150,142] = 26.5300693004806
    jac_trap[150,143] = -1.58482814504483
    jac_trap[150,144] = -7.89461337514770
    jac_trap[150,145] = -0.679918453285310
    jac_trap[150,146] = -7.72144347466701
    jac_trap[150,147] = -1.58482814504483
    jac_trap[150,148] = -7.89461337514771
    jac_trap[150,149] = 9.69353831171601
    jac_trap[150,150] = -53.0601386009611
    jac_trap[150,151] = 3.16965629008966
    jac_trap[150,152] = 15.7892267502954
    jac_trap[150,153] = 1.35983690657062
    jac_trap[150,154] = 15.4428869493340
    jac_trap[150,155] = 3.16965629008966
    jac_trap[150,156] = 15.7892267502954
    jac_trap[150,157] = -4.84676915585801
    jac_trap[150,158] = 26.5300693004806
    jac_trap[150,159] = -1.58482814504483
    jac_trap[150,160] = -7.89461337514770
    jac_trap[150,161] = -0.679918453285310
    jac_trap[150,162] = -7.72144347466701
    jac_trap[150,163] = -1.58482814504483
    jac_trap[150,164] = -7.89461337514771
    jac_trap[151,141] = -7.89461337514771
    jac_trap[151,142] = 1.58482814504483
    jac_trap[151,143] = 26.5300693004806
    jac_trap[151,144] = 4.84676915585801
    jac_trap[151,145] = -7.89461337514771
    jac_trap[151,146] = 1.58482814504483
    jac_trap[151,147] = -7.72144347466701
    jac_trap[151,148] = 0.679918453285308
    jac_trap[151,149] = 15.7892267502954
    jac_trap[151,150] = -3.16965629008966
    jac_trap[151,151] = -53.0601386009611
    jac_trap[151,152] = -9.69353831171602
    jac_trap[151,153] = 15.7892267502954
    jac_trap[151,154] = -3.16965629008967
    jac_trap[151,155] = 15.4428869493340
    jac_trap[151,156] = -1.35983690657062
    jac_trap[151,157] = -7.89461337514771
    jac_trap[151,158] = 1.58482814504483
    jac_trap[151,159] = 26.5300693004806
    jac_trap[151,160] = 4.84676915585801
    jac_trap[151,161] = -7.89461337514771
    jac_trap[151,162] = 1.58482814504483
    jac_trap[151,163] = -7.72144347466701
    jac_trap[151,164] = 0.679918453285308
    jac_trap[152,141] = -1.58482814504483
    jac_trap[152,142] = -7.89461337514771
    jac_trap[152,143] = -4.84676915585801
    jac_trap[152,144] = 26.5300693004806
    jac_trap[152,145] = -1.58482814504483
    jac_trap[152,146] = -7.89461337514771
    jac_trap[152,147] = -0.679918453285308
    jac_trap[152,148] = -7.72144347466701
    jac_trap[152,149] = 3.16965629008966
    jac_trap[152,150] = 15.7892267502954
    jac_trap[152,151] = 9.69353831171602
    jac_trap[152,152] = -53.0601386009611
    jac_trap[152,153] = 3.16965629008967
    jac_trap[152,154] = 15.7892267502954
    jac_trap[152,155] = 1.35983690657062
    jac_trap[152,156] = 15.4428869493340
    jac_trap[152,157] = -1.58482814504483
    jac_trap[152,158] = -7.89461337514771
    jac_trap[152,159] = -4.84676915585801
    jac_trap[152,160] = 26.5300693004806
    jac_trap[152,161] = -1.58482814504483
    jac_trap[152,162] = -7.89461337514771
    jac_trap[152,163] = -0.679918453285308
    jac_trap[152,164] = -7.72144347466701
    jac_trap[153,141] = -7.72144347466701
    jac_trap[153,142] = 0.679918453285310
    jac_trap[153,143] = -7.89461337514770
    jac_trap[153,144] = 1.58482814504483
    jac_trap[153,145] = 26.5300693004806
    jac_trap[153,146] = 4.84676915585801
    jac_trap[153,147] = -7.89461337514771
    jac_trap[153,148] = 1.58482814504483
    jac_trap[153,149] = 15.4428869493340
    jac_trap[153,150] = -1.35983690657062
    jac_trap[153,151] = 15.7892267502954
    jac_trap[153,152] = -3.16965629008966
    jac_trap[153,153] = -53.0601386009611
    jac_trap[153,154] = -9.69353831171602
    jac_trap[153,155] = 15.7892267502954
    jac_trap[153,156] = -3.16965629008967
    jac_trap[153,157] = -7.72144347466701
    jac_trap[153,158] = 0.679918453285310
    jac_trap[153,159] = -7.89461337514770
    jac_trap[153,160] = 1.58482814504483
    jac_trap[153,161] = 26.5300693004806
    jac_trap[153,162] = 4.84676915585801
    jac_trap[153,163] = -7.89461337514771
    jac_trap[153,164] = 1.58482814504483
    jac_trap[154,141] = -0.679918453285310
    jac_trap[154,142] = -7.72144347466701
    jac_trap[154,143] = -1.58482814504483
    jac_trap[154,144] = -7.89461337514770
    jac_trap[154,145] = -4.84676915585801
    jac_trap[154,146] = 26.5300693004806
    jac_trap[154,147] = -1.58482814504483
    jac_trap[154,148] = -7.89461337514771
    jac_trap[154,149] = 1.35983690657062
    jac_trap[154,150] = 15.4428869493340
    jac_trap[154,151] = 3.16965629008966
    jac_trap[154,152] = 15.7892267502954
    jac_trap[154,153] = 9.69353831171602
    jac_trap[154,154] = -53.0601386009611
    jac_trap[154,155] = 3.16965629008967
    jac_trap[154,156] = 15.7892267502954
    jac_trap[154,157] = -0.679918453285310
    jac_trap[154,158] = -7.72144347466701
    jac_trap[154,159] = -1.58482814504483
    jac_trap[154,160] = -7.89461337514770
    jac_trap[154,161] = -4.84676915585801
    jac_trap[154,162] = 26.5300693004806
    jac_trap[154,163] = -1.58482814504483
    jac_trap[154,164] = -7.89461337514771
    jac_trap[155,141] = -7.89461337514771
    jac_trap[155,142] = 1.58482814504483
    jac_trap[155,143] = -7.72144347466701
    jac_trap[155,144] = 0.679918453285308
    jac_trap[155,145] = -7.89461337514771
    jac_trap[155,146] = 1.58482814504483
    jac_trap[155,147] = 26.5300693004806
    jac_trap[155,148] = 4.84676915585801
    jac_trap[155,149] = 15.7892267502954
    jac_trap[155,150] = -3.16965629008966
    jac_trap[155,151] = 15.4428869493340
    jac_trap[155,152] = -1.35983690657062
    jac_trap[155,153] = 15.7892267502954
    jac_trap[155,154] = -3.16965629008966
    jac_trap[155,155] = -53.0851386009611
    jac_trap[155,156] = -9.69353831171602
    jac_trap[155,157] = -7.89461337514771
    jac_trap[155,158] = 1.58482814504483
    jac_trap[155,159] = -7.72144347466701
    jac_trap[155,160] = 0.679918453285308
    jac_trap[155,161] = -7.89461337514771
    jac_trap[155,162] = 1.58482814504483
    jac_trap[155,163] = 26.5300693004806
    jac_trap[155,164] = 4.84676915585801
    jac_trap[156,141] = -1.58482814504483
    jac_trap[156,142] = -7.89461337514771
    jac_trap[156,143] = -0.679918453285308
    jac_trap[156,144] = -7.72144347466701
    jac_trap[156,145] = -1.58482814504483
    jac_trap[156,146] = -7.89461337514771
    jac_trap[156,147] = -4.84676915585801
    jac_trap[156,148] = 26.5300693004806
    jac_trap[156,149] = 3.16965629008966
    jac_trap[156,150] = 15.7892267502954
    jac_trap[156,151] = 1.35983690657062
    jac_trap[156,152] = 15.4428869493340
    jac_trap[156,153] = 3.16965629008966
    jac_trap[156,154] = 15.7892267502954
    jac_trap[156,155] = 9.69353831171602
    jac_trap[156,156] = -53.0851386009611
    jac_trap[156,157] = -1.58482814504483
    jac_trap[156,158] = -7.89461337514771
    jac_trap[156,159] = -0.679918453285308
    jac_trap[156,160] = -7.72144347466701
    jac_trap[156,161] = -1.58482814504483
    jac_trap[156,162] = -7.89461337514771
    jac_trap[156,163] = -4.84676915585801
    jac_trap[156,164] = 26.5300693004806
    jac_trap[157,17] = 26.5300693004806
    jac_trap[157,18] = 4.84676915585801
    jac_trap[157,19] = -7.89461337514770
    jac_trap[157,20] = 1.58482814504483
    jac_trap[157,21] = -7.72144347466701
    jac_trap[157,22] = 0.679918453285310
    jac_trap[157,23] = -7.89461337514771
    jac_trap[157,24] = 1.58482814504483
    jac_trap[157,149] = 26.5300693004806
    jac_trap[157,150] = 4.84676915585801
    jac_trap[157,151] = -7.89461337514770
    jac_trap[157,152] = 1.58482814504483
    jac_trap[157,153] = -7.72144347466701
    jac_trap[157,154] = 0.679918453285310
    jac_trap[157,155] = -7.89461337514771
    jac_trap[157,156] = 1.58482814504483
    jac_trap[157,157] = -53.0601386009611
    jac_trap[157,158] = -9.69353831171601
    jac_trap[157,159] = 15.7892267502954
    jac_trap[157,160] = -3.16965629008966
    jac_trap[157,161] = 15.4428869493340
    jac_trap[157,162] = -1.35983690657062
    jac_trap[157,163] = 15.7892267502954
    jac_trap[157,164] = -3.16965629008966
    jac_trap[157,424] = 1
    jac_trap[158,17] = -4.84676915585801
    jac_trap[158,18] = 26.5300693004806
    jac_trap[158,19] = -1.58482814504483
    jac_trap[158,20] = -7.89461337514770
    jac_trap[158,21] = -0.679918453285310
    jac_trap[158,22] = -7.72144347466701
    jac_trap[158,23] = -1.58482814504483
    jac_trap[158,24] = -7.89461337514771
    jac_trap[158,149] = -4.84676915585801
    jac_trap[158,150] = 26.5300693004806
    jac_trap[158,151] = -1.58482814504483
    jac_trap[158,152] = -7.89461337514770
    jac_trap[158,153] = -0.679918453285310
    jac_trap[158,154] = -7.72144347466701
    jac_trap[158,155] = -1.58482814504483
    jac_trap[158,156] = -7.89461337514771
    jac_trap[158,157] = 9.69353831171601
    jac_trap[158,158] = -53.0601386009611
    jac_trap[158,159] = 3.16965629008966
    jac_trap[158,160] = 15.7892267502954
    jac_trap[158,161] = 1.35983690657062
    jac_trap[158,162] = 15.4428869493340
    jac_trap[158,163] = 3.16965629008966
    jac_trap[158,164] = 15.7892267502954
    jac_trap[158,425] = 1
    jac_trap[159,17] = -7.89461337514771
    jac_trap[159,18] = 1.58482814504483
    jac_trap[159,19] = 26.5300693004806
    jac_trap[159,20] = 4.84676915585801
    jac_trap[159,21] = -7.89461337514771
    jac_trap[159,22] = 1.58482814504483
    jac_trap[159,23] = -7.72144347466701
    jac_trap[159,24] = 0.679918453285308
    jac_trap[159,149] = -7.89461337514771
    jac_trap[159,150] = 1.58482814504483
    jac_trap[159,151] = 26.5300693004806
    jac_trap[159,152] = 4.84676915585801
    jac_trap[159,153] = -7.89461337514771
    jac_trap[159,154] = 1.58482814504483
    jac_trap[159,155] = -7.72144347466701
    jac_trap[159,156] = 0.679918453285308
    jac_trap[159,157] = 15.7892267502954
    jac_trap[159,158] = -3.16965629008966
    jac_trap[159,159] = -53.0601386009611
    jac_trap[159,160] = -9.69353831171602
    jac_trap[159,161] = 15.7892267502954
    jac_trap[159,162] = -3.16965629008967
    jac_trap[159,163] = 15.4428869493340
    jac_trap[159,164] = -1.35983690657062
    jac_trap[159,426] = 1
    jac_trap[160,17] = -1.58482814504483
    jac_trap[160,18] = -7.89461337514771
    jac_trap[160,19] = -4.84676915585801
    jac_trap[160,20] = 26.5300693004806
    jac_trap[160,21] = -1.58482814504483
    jac_trap[160,22] = -7.89461337514771
    jac_trap[160,23] = -0.679918453285308
    jac_trap[160,24] = -7.72144347466701
    jac_trap[160,149] = -1.58482814504483
    jac_trap[160,150] = -7.89461337514771
    jac_trap[160,151] = -4.84676915585801
    jac_trap[160,152] = 26.5300693004806
    jac_trap[160,153] = -1.58482814504483
    jac_trap[160,154] = -7.89461337514771
    jac_trap[160,155] = -0.679918453285308
    jac_trap[160,156] = -7.72144347466701
    jac_trap[160,157] = 3.16965629008966
    jac_trap[160,158] = 15.7892267502954
    jac_trap[160,159] = 9.69353831171602
    jac_trap[160,160] = -53.0601386009611
    jac_trap[160,161] = 3.16965629008967
    jac_trap[160,162] = 15.7892267502954
    jac_trap[160,163] = 1.35983690657062
    jac_trap[160,164] = 15.4428869493340
    jac_trap[160,427] = 1
    jac_trap[161,17] = -7.72144347466701
    jac_trap[161,18] = 0.679918453285310
    jac_trap[161,19] = -7.89461337514770
    jac_trap[161,20] = 1.58482814504483
    jac_trap[161,21] = 26.5300693004806
    jac_trap[161,22] = 4.84676915585801
    jac_trap[161,23] = -7.89461337514771
    jac_trap[161,24] = 1.58482814504483
    jac_trap[161,149] = -7.72144347466701
    jac_trap[161,150] = 0.679918453285310
    jac_trap[161,151] = -7.89461337514770
    jac_trap[161,152] = 1.58482814504483
    jac_trap[161,153] = 26.5300693004806
    jac_trap[161,154] = 4.84676915585801
    jac_trap[161,155] = -7.89461337514771
    jac_trap[161,156] = 1.58482814504483
    jac_trap[161,157] = 15.4428869493340
    jac_trap[161,158] = -1.35983690657062
    jac_trap[161,159] = 15.7892267502954
    jac_trap[161,160] = -3.16965629008966
    jac_trap[161,161] = -53.0601386009611
    jac_trap[161,162] = -9.69353831171602
    jac_trap[161,163] = 15.7892267502954
    jac_trap[161,164] = -3.16965629008967
    jac_trap[161,428] = 1
    jac_trap[162,17] = -0.679918453285310
    jac_trap[162,18] = -7.72144347466701
    jac_trap[162,19] = -1.58482814504483
    jac_trap[162,20] = -7.89461337514770
    jac_trap[162,21] = -4.84676915585801
    jac_trap[162,22] = 26.5300693004806
    jac_trap[162,23] = -1.58482814504483
    jac_trap[162,24] = -7.89461337514771
    jac_trap[162,149] = -0.679918453285310
    jac_trap[162,150] = -7.72144347466701
    jac_trap[162,151] = -1.58482814504483
    jac_trap[162,152] = -7.89461337514770
    jac_trap[162,153] = -4.84676915585801
    jac_trap[162,154] = 26.5300693004806
    jac_trap[162,155] = -1.58482814504483
    jac_trap[162,156] = -7.89461337514771
    jac_trap[162,157] = 1.35983690657062
    jac_trap[162,158] = 15.4428869493340
    jac_trap[162,159] = 3.16965629008966
    jac_trap[162,160] = 15.7892267502954
    jac_trap[162,161] = 9.69353831171602
    jac_trap[162,162] = -53.0601386009611
    jac_trap[162,163] = 3.16965629008967
    jac_trap[162,164] = 15.7892267502954
    jac_trap[162,429] = 1
    jac_trap[163,17] = -7.89461337514771
    jac_trap[163,18] = 1.58482814504483
    jac_trap[163,19] = -7.72144347466701
    jac_trap[163,20] = 0.679918453285308
    jac_trap[163,21] = -7.89461337514771
    jac_trap[163,22] = 1.58482814504483
    jac_trap[163,23] = 26.5300693004806
    jac_trap[163,24] = 4.84676915585801
    jac_trap[163,149] = -7.89461337514771
    jac_trap[163,150] = 1.58482814504483
    jac_trap[163,151] = -7.72144347466701
    jac_trap[163,152] = 0.679918453285308
    jac_trap[163,153] = -7.89461337514771
    jac_trap[163,154] = 1.58482814504483
    jac_trap[163,155] = 26.5300693004806
    jac_trap[163,156] = 4.84676915585801
    jac_trap[163,157] = 15.7892267502954
    jac_trap[163,158] = -3.16965629008966
    jac_trap[163,159] = 15.4428869493340
    jac_trap[163,160] = -1.35983690657062
    jac_trap[163,161] = 15.7892267502954
    jac_trap[163,162] = -3.16965629008966
    jac_trap[163,163] = -53.0601386009611
    jac_trap[163,164] = -9.69353831171602
    jac_trap[164,17] = -1.58482814504483
    jac_trap[164,18] = -7.89461337514771
    jac_trap[164,19] = -0.679918453285308
    jac_trap[164,20] = -7.72144347466701
    jac_trap[164,21] = -1.58482814504483
    jac_trap[164,22] = -7.89461337514771
    jac_trap[164,23] = -4.84676915585801
    jac_trap[164,24] = 26.5300693004806
    jac_trap[164,149] = -1.58482814504483
    jac_trap[164,150] = -7.89461337514771
    jac_trap[164,151] = -0.679918453285308
    jac_trap[164,152] = -7.72144347466701
    jac_trap[164,153] = -1.58482814504483
    jac_trap[164,154] = -7.89461337514771
    jac_trap[164,155] = -4.84676915585801
    jac_trap[164,156] = 26.5300693004806
    jac_trap[164,157] = 3.16965629008966
    jac_trap[164,158] = 15.7892267502954
    jac_trap[164,159] = 1.35983690657062
    jac_trap[164,160] = 15.4428869493340
    jac_trap[164,161] = 3.16965629008966
    jac_trap[164,162] = 15.7892267502954
    jac_trap[164,163] = 9.69353831171602
    jac_trap[164,164] = -53.0601386009611
    jac_trap[165,165] = -1067.70480704130
    jac_trap[165,173] = 67.7048070412999
    jac_trap[166,166] = -1067.70480704130
    jac_trap[166,174] = 67.7048070412999
    jac_trap[167,53] = 157.977883096366
    jac_trap[167,167] = -361.092304220266
    jac_trap[167,175] = 135.409614082600
    jac_trap[168,54] = 157.977883096366
    jac_trap[168,168] = -361.092304220266
    jac_trap[168,176] = 135.409614082600
    jac_trap[169,169] = -361.092304220266
    jac_trap[169,177] = 135.409614082600
    jac_trap[169,207] = 157.977883096366
    jac_trap[170,170] = -361.092304220266
    jac_trap[170,178] = 135.409614082600
    jac_trap[170,208] = 157.977883096366
    jac_trap[171,171] = -361.092304220266
    jac_trap[171,179] = 135.409614082600
    jac_trap[171,209] = 157.977883096366
    jac_trap[172,172] = -361.092304220266
    jac_trap[172,180] = 135.409614082600
    jac_trap[172,210] = 157.977883096366
    jac_trap[173,55] = 157.977883096366
    jac_trap[173,165] = 67.7048070412999
    jac_trap[173,173] = -361.092304220266
    jac_trap[173,181] = 135.409614082600
    jac_trap[174,56] = 157.977883096366
    jac_trap[174,166] = 67.7048070412999
    jac_trap[174,174] = -361.092304220266
    jac_trap[174,182] = 135.409614082600
    jac_trap[175,167] = 135.409614082600
    jac_trap[175,175] = -248.250959151433
    jac_trap[175,183] = 67.7048070412999
    jac_trap[175,223] = 45.1365380275333
    jac_trap[176,168] = 135.409614082600
    jac_trap[176,176] = -248.250959151433
    jac_trap[176,184] = 67.7048070412999
    jac_trap[176,224] = 45.1365380275333
    jac_trap[177,169] = 135.409614082600
    jac_trap[177,177] = -248.250959151433
    jac_trap[177,185] = 67.7048070412999
    jac_trap[177,225] = 45.1365380275333
    jac_trap[178,170] = 135.409614082600
    jac_trap[178,178] = -248.250959151433
    jac_trap[178,186] = 67.7048070412999
    jac_trap[178,226] = 45.1365380275333
    jac_trap[179,171] = 135.409614082600
    jac_trap[179,179] = -248.250959151433
    jac_trap[179,187] = 67.7048070412999
    jac_trap[179,227] = 45.1365380275333
    jac_trap[180,172] = 135.409614082600
    jac_trap[180,180] = -248.250959151433
    jac_trap[180,188] = 67.7048070412999
    jac_trap[180,228] = 45.1365380275333
    jac_trap[181,173] = 135.409614082600
    jac_trap[181,181] = -248.250959151433
    jac_trap[181,189] = 67.7048070412999
    jac_trap[181,229] = 45.1365380275333
    jac_trap[182,174] = 135.409614082600
    jac_trap[182,182] = -248.250959151433
    jac_trap[182,190] = 67.7048070412999
    jac_trap[182,230] = 45.1365380275333
    jac_trap[183,57] = 157.977883096366
    jac_trap[183,175] = 67.7048070412999
    jac_trap[183,183] = -270.819228165200
    jac_trap[183,191] = 45.1365380275333
    jac_trap[184,58] = 157.977883096366
    jac_trap[184,176] = 67.7048070412999
    jac_trap[184,184] = -270.819228165200
    jac_trap[184,192] = 45.1365380275333
    jac_trap[185,177] = 67.7048070412999
    jac_trap[185,185] = -270.819228165200
    jac_trap[185,193] = 45.1365380275333
    jac_trap[185,211] = 157.977883096366
    jac_trap[186,178] = 67.7048070412999
    jac_trap[186,186] = -270.819228165200
    jac_trap[186,194] = 45.1365380275333
    jac_trap[186,212] = 157.977883096366
    jac_trap[187,179] = 67.7048070412999
    jac_trap[187,187] = -270.819228165200
    jac_trap[187,195] = 45.1365380275333
    jac_trap[187,213] = 157.977883096366
    jac_trap[188,180] = 67.7048070412999
    jac_trap[188,188] = -270.819228165200
    jac_trap[188,196] = 45.1365380275333
    jac_trap[188,214] = 157.977883096366
    jac_trap[189,59] = 157.977883096366
    jac_trap[189,181] = 67.7048070412999
    jac_trap[189,189] = -270.819228165200
    jac_trap[189,197] = 45.1365380275333
    jac_trap[190,60] = 157.977883096366
    jac_trap[190,182] = 67.7048070412999
    jac_trap[190,190] = -270.819228165200
    jac_trap[190,198] = 45.1365380275333
    jac_trap[191,61] = 157.977883096366
    jac_trap[191,183] = 45.1365380275333
    jac_trap[191,191] = -361.092304220266
    jac_trap[191,199] = 157.977883096366
    jac_trap[192,62] = 157.977883096366
    jac_trap[192,184] = 45.1365380275333
    jac_trap[192,192] = -361.092304220266
    jac_trap[192,200] = 157.977883096366
    jac_trap[193,185] = 45.1365380275333
    jac_trap[193,193] = -361.092304220266
    jac_trap[193,201] = 157.977883096366
    jac_trap[193,215] = 157.977883096366
    jac_trap[194,186] = 45.1365380275333
    jac_trap[194,194] = -361.092304220266
    jac_trap[194,202] = 157.977883096366
    jac_trap[194,216] = 157.977883096366
    jac_trap[195,187] = 45.1365380275333
    jac_trap[195,195] = -361.092304220266
    jac_trap[195,203] = 157.977883096366
    jac_trap[195,217] = 157.977883096366
    jac_trap[196,188] = 45.1365380275333
    jac_trap[196,196] = -361.092304220266
    jac_trap[196,204] = 157.977883096366
    jac_trap[196,218] = 157.977883096366
    jac_trap[197,63] = 157.977883096366
    jac_trap[197,189] = 45.1365380275333
    jac_trap[197,197] = -361.092304220266
    jac_trap[197,205] = 157.977883096366
    jac_trap[198,64] = 157.977883096366
    jac_trap[198,190] = 45.1365380275333
    jac_trap[198,198] = -361.092304220266
    jac_trap[198,206] = 157.977883096366
    jac_trap[199,65] = 157.977883096366
    jac_trap[199,191] = 157.977883096366
    jac_trap[199,199] = -315.955766192733
    jac_trap[199,420] = 1
    jac_trap[200,66] = 157.977883096366
    jac_trap[200,192] = 157.977883096366
    jac_trap[200,200] = -315.955766192733
    jac_trap[201,193] = 157.977883096366
    jac_trap[201,201] = -315.955766192733
    jac_trap[201,219] = 157.977883096366
    jac_trap[202,194] = 157.977883096366
    jac_trap[202,202] = -315.955766192733
    jac_trap[202,220] = 157.977883096366
    jac_trap[203,195] = 157.977883096366
    jac_trap[203,203] = -315.955766192733
    jac_trap[203,221] = 157.977883096366
    jac_trap[204,196] = 157.977883096366
    jac_trap[204,204] = -315.955766192733
    jac_trap[204,222] = 157.977883096366
    jac_trap[205,67] = 157.977883096366
    jac_trap[205,197] = 157.977883096366
    jac_trap[205,205] = -315.955766192733
    jac_trap[205,421] = 1
    jac_trap[206,68] = 157.977883096366
    jac_trap[206,198] = 157.977883096366
    jac_trap[206,206] = -315.955766192733
    jac_trap[207,169] = 157.977883096366
    jac_trap[207,207] = -157.977883096366
    jac_trap[208,170] = 157.977883096366
    jac_trap[208,208] = -157.977883096366
    jac_trap[209,171] = 157.977883096366
    jac_trap[209,209] = -157.977883096366
    jac_trap[210,172] = 157.977883096366
    jac_trap[210,210] = -157.977883096366
    jac_trap[211,185] = 157.977883096366
    jac_trap[211,211] = -157.977883096366
    jac_trap[212,186] = 157.977883096366
    jac_trap[212,212] = -157.977883096366
    jac_trap[213,187] = 157.977883096366
    jac_trap[213,213] = -157.977883096366
    jac_trap[214,188] = 157.977883096366
    jac_trap[214,214] = -157.977883096366
    jac_trap[215,193] = 157.977883096366
    jac_trap[215,215] = -157.977883096366
    jac_trap[216,194] = 157.977883096366
    jac_trap[216,216] = -157.977883096366
    jac_trap[217,195] = 157.977883096366
    jac_trap[217,217] = -157.977883096366
    jac_trap[218,196] = 157.977883096366
    jac_trap[218,218] = -157.977883096366
    jac_trap[219,201] = 157.977883096366
    jac_trap[219,219] = -157.977883096366
    jac_trap[220,202] = 157.977883096366
    jac_trap[220,220] = -157.977883096366
    jac_trap[221,203] = 157.977883096366
    jac_trap[221,221] = -157.977883096366
    jac_trap[222,204] = 157.9778830963