# See LICENSE for details

import os
from ruamel.yaml import YAML
from cerberus import Validator

root = os.path.abspath(os.path.dirname(__file__))
testlist_schema = '''
asm_file:
  type: string
  nullable: False
  required: True
  check_with: filecheck
cc:
  type: string
  nullable: True
cc_args:
  type: string
  nullable: True
generator:
  type: string
  required: True
isa: 
  type: string
  required: True
linker_file:
  type: string
  check_with: filecheck
linker_args:
  type: string
  required: True
mabi:
  type: string
  required: True
march:
  type: string
  required: True
work_dir:
  type: string
  required: True
  check_with: dircheck
result:
  type: string
compile_macros:
  type: list
  schema:
    type: string
    nullable: True
  empty: True
  default: []
extra_compile:
  type: list
  schema:
    type: string
    nullable: True
    check_with: filecheck
  empty: True
  default: []
include:
  type: list
  schema:
    type: string
    nullable: True
    check_with: dircheck
  empty: True
''' #: This contains the schema for validation

sample_config = '''
[river_core]
# Main directory for all files generated by river_core
work_dir = mywork 

# Name of the target DuT plugin
target = chromite_verilator

# Name of the reference model plugin
reference = spike 

# Name of the generator(s) to be used. Comma separated
generator = aapg

# ISA for the tests
isa = rv64imafdc

# Set paths for each plugin
# TODO Change the following paths
path_to_target = /home/user/myquickstart/river_core_plugins/dut_plugins
path_to_ref = /home/user/myquickstart/river_core_plugins/reference_plugins
path_to_suite = /home/user/myquickstart/river_core_plugins/generator_plugins

# To open the report automatically in the browser
open_browser = True

# Enable Space Saver
space_saver = True

# Coverage Options
# Enable via True/False
[coverage]
code = False
functional = False

[aapg]
# Number of jobs to use to generate the tests
jobs = 8
filter = rv64imafdc_hazards_s
seed = random
count = 2
config_yaml = /home/user/myquickstart/river_core_plugins/generator_plugins/aapg_plugin/aapg_gen_config.yaml

[chromite_verilator]
jobs = 8
filter = 
count = 1
# src dir: Verilog Dir, BSC Path, Wrapper path
src_dir = /home/user/myquickstart/chromite/build/hw/verilog/,/tools/bsc/inst/lib/Verilog,/home/user/myquickstart/chromite/bsvwrappers/common_lib
top_module = mkTbSoc

[spike]
jobs = 1
filter =
count = 1

'''

header_temp = '''------------RiVer Core Verification Framework------------
Version: {0}
Copyright (c) 2021 InCore Semiconductors Pvt. Ltd.
'''

class YamlValidator(Validator):

    def _check_with_filecheck(self, field, value):
        if not os.path.isfile(value):
            self._error(field, 'File {0} not found'.format(value))

    def _check_with_dircheck(self, field, value):
        if not os.path.isdir(value):
            self._error(field, 'Dir {0} not found'.format(value))


cwd = os.getcwd()
