# Generated by Django 3.2.9 on 2021-12-16 09:46

from django.db import migrations, models


class Migration(migrations.Migration):
    def init_default_sorting_name(apps, _):
        naturalpersons = apps.get_model("core.NaturalPerson").objects.all()
        other_persons = (
            *apps.get_model("core.LegalPerson").objects.all(),
            *apps.get_model("core.PersonAssociation").objects.all(),
        )

        for person in naturalpersons:
            person.default_sorting_name = person.last_name
            person.save()

        for person in other_persons:
            person.default_sorting_name = person.name
            person.save()

    dependencies = [
        ("core", "0025_alter_term_slug"),
    ]

    operations = [
        migrations.AddField(
            model_name="historicallegalperson",
            name="default_sorting_name",
            field=models.CharField(
                blank=True, max_length=255, verbose_name="Default Sorting Name"
            ),
        ),
        migrations.AddField(
            model_name="historicalnaturalperson",
            name="default_sorting_name",
            field=models.CharField(
                blank=True, max_length=255, verbose_name="Default Sorting Name"
            ),
        ),
        migrations.AddField(
            model_name="historicalperson",
            name="default_sorting_name",
            field=models.CharField(
                blank=True, max_length=255, verbose_name="Default Sorting Name"
            ),
        ),
        migrations.AddField(
            model_name="historicalpersonassociation",
            name="default_sorting_name",
            field=models.CharField(
                blank=True, max_length=255, verbose_name="Default Sorting Name"
            ),
        ),
        migrations.AddField(
            model_name="person",
            name="default_sorting_name",
            field=models.CharField(
                blank=True, max_length=255, verbose_name="Default Sorting Name"
            ),
        ),
        migrations.RunPython(init_default_sorting_name, migrations.RunPython.noop),
    ]
