import click

from grid.cli import rich_click
from grid.cli.client import Grid


@rich_click.command()
@rich_click.argument('experiment', type=str, nargs=1)
@rich_click.argument('metric', type=str, nargs=1)
@click.option('--n_lines', default=10, type=int, help='Number of metrics lines (from the end) to return.')
def metrics(experiment: str, metric: str, n_lines: int) -> None:
    """Get value of some METRIC generated by some EXPERIMENT."""
    # Instantiate client.
    client = Grid()

    # Call client.
    client.experiment_metrics(experiment_name=experiment, metric=metric, n_lines=n_lines)
