# Generated by Django 4.1.7 on 2023-02-27 22:28

from django.db import migrations, models
import django.db.models.deletion
import onto.authz.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("onto", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Action",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "label",
                    models.SlugField(
                        help_text="Internal reference key for this action.",
                        max_length=255,
                    ),
                ),
                (
                    "default_permit",
                    models.BooleanField(
                        default=True,
                        help_text="Whether this action is allowed to be performed by default. If False, a Policy must explicitly grant it.",
                    ),
                ),
                (
                    "dispatch_changes",
                    models.BooleanField(
                        default=False,
                        help_text="Whether to track the state of all entitlements for this action, and emit signals when they change.",
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        help_text="A human-readable name for this action.",
                        max_length=255,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        help_text="Describe the action, including its intended purpose.",
                        null=True,
                    ),
                ),
                (
                    "source_type",
                    models.ForeignKey(
                        default=onto.authz.models.user_ct_id,
                        help_text="The ContentType of objects that perform this action, defaults to AUTH_USER_MODEL.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="actions_as_source",
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "target_type",
                    models.ForeignKey(
                        help_text="The ContentType of objects that this action affects.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="actions_as_target",
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Policy",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("label", models.SlugField(max_length=255)),
                (
                    "principal_filters",
                    models.JSONField(
                        default=dict,
                        help_text="This policy affects entities (as source principals) that match this specification (or all entities in the domain if NULL).",
                    ),
                ),
                (
                    "resource_filters",
                    models.JSONField(
                        default=dict,
                        help_text="This policy affects entities (as target resources) that match this specification (or all entities in the domain if NULL).",
                    ),
                ),
                (
                    "disabled",
                    models.BooleanField(
                        default=False,
                        help_text="When this policy is disabled, it will not be considered for authorization.",
                    ),
                ),
                (
                    "actions",
                    models.ManyToManyField(
                        related_name="policies", to="onto_authz.action"
                    ),
                ),
                (
                    "domain",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="policies",
                        to="onto.domain",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "policies",
            },
        ),
        migrations.CreateModel(
            name="Entitlement",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "action",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="entitlements",
                        to="onto_authz.action",
                    ),
                ),
                (
                    "domain",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="entitlements",
                        to="onto.domain",
                    ),
                ),
                (
                    "policy",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="entitlements",
                        to="onto_authz.policy",
                    ),
                ),
                (
                    "principal",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="entitlements_as_principal",
                        to="onto.entity",
                    ),
                ),
                (
                    "resource",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="entitlements_as_resource",
                        to="onto.entity",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="policy",
            constraint=models.UniqueConstraint(
                fields=("label", "domain"), name="onto_authz_policy_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="action",
            constraint=models.UniqueConstraint(
                fields=("label", "target_type", "source_type"),
                name="onto_authz_action_unique",
            ),
        ),
    ]
