#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject
from pycatia.system_interfaces.cat_base_dispatch import CATBaseDispatch


class DrawingViewGenerativeLinks(CATBaseDispatch):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 DrawingViewGenerativeLinks
                | 
                | Represents the generative links of a drawing view.
                | 
                | The generative links of a drawing view is an object that manages the way the
                | generative view points at the 3D document.
    
    """

    def __init__(self, com_object):
        super().__init__()
        self.drawing_view_generative_links = com_object

    def add_link(self, i_link: AnyObject) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub AddLink(AnyObject iLink)
                | 
                |     Adds a link to the drawing view.
                | 
                |     Example:
                |         This example adds a link to the Part document MyPartDocument to the
                |         MyView drawing view.
                | 
                |          Dim viewLinks As DrawingViewGenerativeLinks
                |          Set viewLinks = MyView.GenerativeLinks
                |          viewLinks.AddLink(MyPartDocument)

        :param AnyObject i_link:
        :return: None
        :rtype: None
        """
        return self.drawing_view_generative_links.AddLink(i_link.com_object)

    def copy_links_to(self, i_links: 'DrawingViewGenerativeLinks') -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub CopyLinksTo(DrawingViewGenerativeLinks iLinks)
                | 
                |     Copies the links of the drawing view.
                | 
                |     Example:
                |         This example copies the links of the MyView drawing view to the MyLinks
                |         object.
                | 
                |          Dim viewLinks As DrawingViewGenerativeLinks
                |          Set viewLinks = MyView.GenerativeLinks
                |          Dim MyLinks As DrawingViewGenerativeLinks
                |          viewLinks.CopyLinksTo(MyLinks)

        :param DrawingViewGenerativeLinks i_links:
        :return: None
        :rtype: None
        """
        return self.drawing_view_generative_links.CopyLinksTo(i_links.drawing_view_generative_links)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'copy_links_to'
        # # vba_code = """
        # # Public Function copy_links_to(drawing_view_generative_links)
        # #     Dim iLinks (2)
        # #     drawing_view_generative_links.CopyLinksTo iLinks
        # #     copy_links_to = iLinks
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def first_link(self) -> AnyObject:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func FirstLink() As AnyObject
                | 
                |     Returns the first link of the drawing view.
                | 
                |     Example:
                |         This example retrieves the first link of the MyView drawing
                |         view.
                | 
                |          Dim viewLinks As DrawingViewGenerativeLinks
                |          Set viewLinks = MyView.GenerativeLinks
                |          Dim firstLink As AnyObject
                |          Set firstLink = MyView.FirstLink()

        :return: AnyObject
        :rtype: AnyObject
        """
        return AnyObject(self.drawing_view_generative_links.FirstLink())

    def next_link(self) -> AnyObject:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Func NextLink() As AnyObject
                | 
                |     Returns the next link of the drawing view.
                | 
                |     Example:
                |         This example retrieves the next link of the MyView drawing
                |         view.
                | 
                |          Dim viewLinks As DrawingViewGenerativeLinks
                |          Set viewLinks = MyView.GenerativeLinks
                |          Dim nextLink As AnyObject
                |          nextLink = viewLinks.NextLink()

        :return: AnyObject
        :rtype: AnyObject
        """
        return AnyObject(self.drawing_view_generative_links.NextLink())

    def remove_all_links(self) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub RemoveAllLinks()
                | 
                |     Removes all links of the drawing view.
                | 
                |     Example:
                |         This example retrieves all links of the MyView drawing
                |         view.
                | 
                |          Dim viewLinks As DrawingViewGenerativeLinks
                |          Set viewLinks = MyView.GenerativeLinks
                |          viewLinks.RemoveAllLinks()

        :return: None
        :rtype: None
        """
        return self.drawing_view_generative_links.RemoveAllLinks()

    def __repr__(self):
        return f'DrawingViewGenerativeLinks()'
