#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class FeatureGenerator(AnyObject):

    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     FeatureGenerator
                | 
                | The interface to access a CATIAFeatureGenerator.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.feature_generator = com_object

    @property
    def nb_generated_features(self) -> int:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)
                | o Property NbGeneratedFeatures() As long (Read Only)
                | 
                |     Number of generated features in last generation.

        :return: int
        :rtype: int
        """

        return self.feature_generator.NbGeneratedFeatures

    @property
    def script(self) -> str:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)
                | o Property Script() As CATBSTR
                | 
                |     Returns or sets the script that describes what is to be generated.

        :return: str
        :rtype: str
        """

        return self.feature_generator.Script

    @script.setter
    def script(self, value: str):
        """
        :param str value:
        """

        self.feature_generator.Script = value

    def generate(self, i_context: AnyObject) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub Generate(AnyObject iContext)
                | 
                |     Generates the features.

        :param AnyObject i_context:
        :return: None
        :rtype: None
        """
        return self.feature_generator.Generate(i_context.com_object)

    def generate_in_context(self, i_inputs_array: tuple) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub GenerateInContext(CATSafeArrayVariant iInputsArray)
                | 
                |     Generates the features.

        :param tuple i_inputs_array:
        :return: None
        :rtype: None
        """
        return self.feature_generator.GenerateInContext(i_inputs_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'generate_in_context'
        # # vba_code = """
        # # Public Function generate_in_context(feature_generator)
        # #     Dim iInputsArray (2)
        # #     feature_generator.GenerateInContext iInputsArray
        # #     generate_in_context = iInputsArray
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def load_script_from_file_path(self, i_file_path: str) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub LoadScriptFromFilePath(CATBSTR iFilePath)
                | 
                |     Sets a script from a document file.

        :param str i_file_path:
        :return: None
        :rtype: None
        """
        return self.feature_generator.LoadScriptFromFilePath(i_file_path)

    def __repr__(self):
        return f'FeatureGenerator(name="{ self.name }")'
