import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 */
export interface CfnDataSourceProps {
    /**
     * `AWS::Kendra::DataSource.IndexId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-indexid
     * @external
     */
    readonly indexId: string;
    /**
     * `AWS::Kendra::DataSource.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Kendra::DataSource.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::Kendra::DataSource.DataSourceConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-datasourceconfiguration
     * @external
     */
    readonly dataSourceConfiguration?: CfnDataSource.DataSourceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::DataSource.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Kendra::DataSource.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-rolearn
     * @external
     */
    readonly roleArn?: string;
    /**
     * `AWS::Kendra::DataSource.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-schedule
     * @external
     */
    readonly schedule?: string;
    /**
     * `AWS::Kendra::DataSource.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare class CfnDataSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kendra::DataSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataSource;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::Kendra::DataSource.IndexId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-indexid
     * @external
     */
    indexId: string;
    /**
     * `AWS::Kendra::DataSource.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-name
     * @external
     */
    name: string;
    /**
     * `AWS::Kendra::DataSource.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-type
     * @external
     */
    type: string;
    /**
     * `AWS::Kendra::DataSource.DataSourceConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-datasourceconfiguration
     * @external
     */
    dataSourceConfiguration: CfnDataSource.DataSourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Kendra::DataSource.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Kendra::DataSource.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * `AWS::Kendra::DataSource.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-schedule
     * @external
     */
    schedule: string | undefined;
    /**
     * `AWS::Kendra::DataSource.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Kendra::DataSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataSourceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-accesscontrollistconfiguration.html
     * @external
     */
    interface AccessControlListConfigurationProperty {
        /**
         * `CfnDataSource.AccessControlListConfigurationProperty.KeyPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-accesscontrollistconfiguration.html#cfn-kendra-datasource-accesscontrollistconfiguration-keypath
         * @external
         */
        readonly keyPath?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-aclconfiguration.html
     * @external
     */
    interface AclConfigurationProperty {
        /**
         * `CfnDataSource.AclConfigurationProperty.AllowedGroupsColumnName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-aclconfiguration.html#cfn-kendra-datasource-aclconfiguration-allowedgroupscolumnname
         * @external
         */
        readonly allowedGroupsColumnName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-changedetectingcolumns.html
     * @external
     */
    interface ChangeDetectingColumnsProperty {
        /**
         * `CfnDataSource.ChangeDetectingColumnsProperty.ChangeDetectingColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-changedetectingcolumns.html#cfn-kendra-datasource-changedetectingcolumns-changedetectingcolumns
         * @external
         */
        readonly changeDetectingColumns?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html
     * @external
     */
    interface ColumnConfigurationProperty {
        /**
         * `CfnDataSource.ColumnConfigurationProperty.ChangeDetectingColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-changedetectingcolumns
         * @external
         */
        readonly changeDetectingColumns: CfnDataSource.ChangeDetectingColumnsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ColumnConfigurationProperty.DocumentDataColumnName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-documentdatacolumnname
         * @external
         */
        readonly documentDataColumnName: string;
        /**
         * `CfnDataSource.ColumnConfigurationProperty.DocumentIdColumnName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-documentidcolumnname
         * @external
         */
        readonly documentIdColumnName: string;
        /**
         * `CfnDataSource.ColumnConfigurationProperty.DocumentTitleColumnName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-documenttitlecolumnname
         * @external
         */
        readonly documentTitleColumnName?: string;
        /**
         * `CfnDataSource.ColumnConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentconfiguration.html
     * @external
     */
    interface ConfluenceAttachmentConfigurationProperty {
        /**
         * `CfnDataSource.ConfluenceAttachmentConfigurationProperty.AttachmentFieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentconfiguration.html#cfn-kendra-datasource-confluenceattachmentconfiguration-attachmentfieldmappings
         * @external
         */
        readonly attachmentFieldMappings?: CfnDataSource.ConfluenceAttachmentFieldMappingsListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceAttachmentConfigurationProperty.CrawlAttachments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentconfiguration.html#cfn-kendra-datasource-confluenceattachmentconfiguration-crawlattachments
         * @external
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentfieldmappingslist.html
     * @external
     */
    interface ConfluenceAttachmentFieldMappingsListProperty {
        /**
         * `CfnDataSource.ConfluenceAttachmentFieldMappingsListProperty.ConfluenceAttachmentFieldMappingsList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentfieldmappingslist.html#cfn-kendra-datasource-confluenceattachmentfieldmappingslist-confluenceattachmentfieldmappingslist
         * @external
         */
        readonly confluenceAttachmentFieldMappingsList?: Array<CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html
     * @external
     */
    interface ConfluenceAttachmentToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html#cfn-kendra-datasource-confluenceattachmenttoindexfieldmapping-datasourcefieldname
         * @external
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html#cfn-kendra-datasource-confluenceattachmenttoindexfieldmapping-datefieldformat
         * @external
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html#cfn-kendra-datasource-confluenceattachmenttoindexfieldmapping-indexfieldname
         * @external
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogconfiguration.html
     * @external
     */
    interface ConfluenceBlogConfigurationProperty {
        /**
         * `CfnDataSource.ConfluenceBlogConfigurationProperty.BlogFieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogconfiguration.html#cfn-kendra-datasource-confluenceblogconfiguration-blogfieldmappings
         * @external
         */
        readonly blogFieldMappings?: CfnDataSource.ConfluenceBlogFieldMappingsListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogfieldmappingslist.html
     * @external
     */
    interface ConfluenceBlogFieldMappingsListProperty {
        /**
         * `CfnDataSource.ConfluenceBlogFieldMappingsListProperty.ConfluenceBlogFieldMappingsList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogfieldmappingslist.html#cfn-kendra-datasource-confluenceblogfieldmappingslist-confluenceblogfieldmappingslist
         * @external
         */
        readonly confluenceBlogFieldMappingsList?: Array<CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html
     * @external
     */
    interface ConfluenceBlogToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html#cfn-kendra-datasource-confluenceblogtoindexfieldmapping-datasourcefieldname
         * @external
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html#cfn-kendra-datasource-confluenceblogtoindexfieldmapping-datefieldformat
         * @external
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html#cfn-kendra-datasource-confluenceblogtoindexfieldmapping-indexfieldname
         * @external
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html
     * @external
     */
    interface ConfluenceConfigurationProperty {
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.AttachmentConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-attachmentconfiguration
         * @external
         */
        readonly attachmentConfiguration?: CfnDataSource.ConfluenceAttachmentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.BlogConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-blogconfiguration
         * @external
         */
        readonly blogConfiguration?: CfnDataSource.ConfluenceBlogConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.ExclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-exclusionpatterns
         * @external
         */
        readonly exclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.InclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-inclusionpatterns
         * @external
         */
        readonly inclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.PageConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-pageconfiguration
         * @external
         */
        readonly pageConfiguration?: CfnDataSource.ConfluencePageConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-secretarn
         * @external
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.ServerUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-serverurl
         * @external
         */
        readonly serverUrl: string;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.SpaceConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-spaceconfiguration
         * @external
         */
        readonly spaceConfiguration?: CfnDataSource.ConfluenceSpaceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-version
         * @external
         */
        readonly version: string;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.VpcConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-vpcconfiguration
         * @external
         */
        readonly vpcConfiguration?: CfnDataSource.DataSourceVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepageconfiguration.html
     * @external
     */
    interface ConfluencePageConfigurationProperty {
        /**
         * `CfnDataSource.ConfluencePageConfigurationProperty.PageFieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepageconfiguration.html#cfn-kendra-datasource-confluencepageconfiguration-pagefieldmappings
         * @external
         */
        readonly pageFieldMappings?: CfnDataSource.ConfluencePageFieldMappingsListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagefieldmappingslist.html
     * @external
     */
    interface ConfluencePageFieldMappingsListProperty {
        /**
         * `CfnDataSource.ConfluencePageFieldMappingsListProperty.ConfluencePageFieldMappingsList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagefieldmappingslist.html#cfn-kendra-datasource-confluencepagefieldmappingslist-confluencepagefieldmappingslist
         * @external
         */
        readonly confluencePageFieldMappingsList?: Array<CfnDataSource.ConfluencePageToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html
     * @external
     */
    interface ConfluencePageToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.ConfluencePageToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html#cfn-kendra-datasource-confluencepagetoindexfieldmapping-datasourcefieldname
         * @external
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.ConfluencePageToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html#cfn-kendra-datasource-confluencepagetoindexfieldmapping-datefieldformat
         * @external
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.ConfluencePageToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html#cfn-kendra-datasource-confluencepagetoindexfieldmapping-indexfieldname
         * @external
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html
     * @external
     */
    interface ConfluenceSpaceConfigurationProperty {
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.CrawlArchivedSpaces`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-crawlarchivedspaces
         * @external
         */
        readonly crawlArchivedSpaces?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.CrawlPersonalSpaces`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-crawlpersonalspaces
         * @external
         */
        readonly crawlPersonalSpaces?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.ExcludeSpaces`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-excludespaces
         * @external
         */
        readonly excludeSpaces?: CfnDataSource.ConfluenceSpaceListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.IncludeSpaces`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-includespaces
         * @external
         */
        readonly includeSpaces?: CfnDataSource.ConfluenceSpaceListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.SpaceFieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-spacefieldmappings
         * @external
         */
        readonly spaceFieldMappings?: CfnDataSource.ConfluenceSpaceFieldMappingsListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacefieldmappingslist.html
     * @external
     */
    interface ConfluenceSpaceFieldMappingsListProperty {
        /**
         * `CfnDataSource.ConfluenceSpaceFieldMappingsListProperty.ConfluenceSpaceFieldMappingsList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacefieldmappingslist.html#cfn-kendra-datasource-confluencespacefieldmappingslist-confluencespacefieldmappingslist
         * @external
         */
        readonly confluenceSpaceFieldMappingsList?: Array<CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacelist.html
     * @external
     */
    interface ConfluenceSpaceListProperty {
        /**
         * `CfnDataSource.ConfluenceSpaceListProperty.ConfluenceSpaceList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacelist.html#cfn-kendra-datasource-confluencespacelist-confluencespacelist
         * @external
         */
        readonly confluenceSpaceList?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html
     * @external
     */
    interface ConfluenceSpaceToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html#cfn-kendra-datasource-confluencespacetoindexfieldmapping-datasourcefieldname
         * @external
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html#cfn-kendra-datasource-confluencespacetoindexfieldmapping-datefieldformat
         * @external
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html#cfn-kendra-datasource-confluencespacetoindexfieldmapping-indexfieldname
         * @external
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html
     * @external
     */
    interface ConnectionConfigurationProperty {
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.DatabaseHost`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-databasehost
         * @external
         */
        readonly databaseHost: string;
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-databasename
         * @external
         */
        readonly databaseName: string;
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.DatabasePort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-databaseport
         * @external
         */
        readonly databasePort: number;
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-secretarn
         * @external
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-tablename
         * @external
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html
     * @external
     */
    interface DataSourceConfigurationProperty {
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.ConfluenceConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-confluenceconfiguration
         * @external
         */
        readonly confluenceConfiguration?: CfnDataSource.ConfluenceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.DatabaseConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-databaseconfiguration
         * @external
         */
        readonly databaseConfiguration?: CfnDataSource.DatabaseConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.GoogleDriveConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-googledriveconfiguration
         * @external
         */
        readonly googleDriveConfiguration?: CfnDataSource.GoogleDriveConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.OneDriveConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-onedriveconfiguration
         * @external
         */
        readonly oneDriveConfiguration?: CfnDataSource.OneDriveConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.S3Configuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-s3configuration
         * @external
         */
        readonly s3Configuration?: CfnDataSource.S3DataSourceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.SalesforceConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-salesforceconfiguration
         * @external
         */
        readonly salesforceConfiguration?: CfnDataSource.SalesforceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.ServiceNowConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-servicenowconfiguration
         * @external
         */
        readonly serviceNowConfiguration?: CfnDataSource.ServiceNowConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.SharePointConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-sharepointconfiguration
         * @external
         */
        readonly sharePointConfiguration?: CfnDataSource.SharePointConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceinclusionsexclusionsstrings.html
     * @external
     */
    interface DataSourceInclusionsExclusionsStringsProperty {
        /**
         * `CfnDataSource.DataSourceInclusionsExclusionsStringsProperty.DataSourceInclusionsExclusionsStrings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceinclusionsexclusionsstrings.html#cfn-kendra-datasource-datasourceinclusionsexclusionsstrings-datasourceinclusionsexclusionsstrings
         * @external
         */
        readonly dataSourceInclusionsExclusionsStrings?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html
     * @external
     */
    interface DataSourceToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.DataSourceToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html#cfn-kendra-datasource-datasourcetoindexfieldmapping-datasourcefieldname
         * @external
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.DataSourceToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html#cfn-kendra-datasource-datasourcetoindexfieldmapping-datefieldformat
         * @external
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.DataSourceToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html#cfn-kendra-datasource-datasourcetoindexfieldmapping-indexfieldname
         * @external
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmappinglist.html
     * @external
     */
    interface DataSourceToIndexFieldMappingListProperty {
        /**
         * `CfnDataSource.DataSourceToIndexFieldMappingListProperty.DataSourceToIndexFieldMappingList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmappinglist.html#cfn-kendra-datasource-datasourcetoindexfieldmappinglist-datasourcetoindexfieldmappinglist
         * @external
         */
        readonly dataSourceToIndexFieldMappingList?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcevpcconfiguration.html
     * @external
     */
    interface DataSourceVpcConfigurationProperty {
        /**
         * `CfnDataSource.DataSourceVpcConfigurationProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcevpcconfiguration.html#cfn-kendra-datasource-datasourcevpcconfiguration-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnDataSource.DataSourceVpcConfigurationProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcevpcconfiguration.html#cfn-kendra-datasource-datasourcevpcconfiguration-subnetids
         * @external
         */
        readonly subnetIds: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html
     * @external
     */
    interface DatabaseConfigurationProperty {
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.AclConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-aclconfiguration
         * @external
         */
        readonly aclConfiguration?: CfnDataSource.AclConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.ColumnConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-columnconfiguration
         * @external
         */
        readonly columnConfiguration: CfnDataSource.ColumnConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.ConnectionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-connectionconfiguration
         * @external
         */
        readonly connectionConfiguration: CfnDataSource.ConnectionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.DatabaseEngineType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-databaseenginetype
         * @external
         */
        readonly databaseEngineType: string;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.SqlConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-sqlconfiguration
         * @external
         */
        readonly sqlConfiguration?: CfnDataSource.SqlConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.VpcConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-vpcconfiguration
         * @external
         */
        readonly vpcConfiguration?: CfnDataSource.DataSourceVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-documentsmetadataconfiguration.html
     * @external
     */
    interface DocumentsMetadataConfigurationProperty {
        /**
         * `CfnDataSource.DocumentsMetadataConfigurationProperty.S3Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-documentsmetadataconfiguration.html#cfn-kendra-datasource-documentsmetadataconfiguration-s3prefix
         * @external
         */
        readonly s3Prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-excludemimetypeslist.html
     * @external
     */
    interface ExcludeMimeTypesListProperty {
        /**
         * `CfnDataSource.ExcludeMimeTypesListProperty.ExcludeMimeTypesList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-excludemimetypeslist.html#cfn-kendra-datasource-excludemimetypeslist-excludemimetypeslist
         * @external
         */
        readonly excludeMimeTypesList?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-excludeshareddriveslist.html
     * @external
     */
    interface ExcludeSharedDrivesListProperty {
        /**
         * `CfnDataSource.ExcludeSharedDrivesListProperty.ExcludeSharedDrivesList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-excludeshareddriveslist.html#cfn-kendra-datasource-excludeshareddriveslist-excludeshareddriveslist
         * @external
         */
        readonly excludeSharedDrivesList?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-excludeuseraccountslist.html
     * @external
     */
    interface ExcludeUserAccountsListProperty {
        /**
         * `CfnDataSource.ExcludeUserAccountsListProperty.ExcludeUserAccountsList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-excludeuseraccountslist.html#cfn-kendra-datasource-excludeuseraccountslist-excludeuseraccountslist
         * @external
         */
        readonly excludeUserAccountsList?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html
     * @external
     */
    interface GoogleDriveConfigurationProperty {
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.ExcludeMimeTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-excludemimetypes
         * @external
         */
        readonly excludeMimeTypes?: CfnDataSource.ExcludeMimeTypesListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.ExcludeSharedDrives`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-excludeshareddrives
         * @external
         */
        readonly excludeSharedDrives?: CfnDataSource.ExcludeSharedDrivesListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.ExcludeUserAccounts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-excludeuseraccounts
         * @external
         */
        readonly excludeUserAccounts?: CfnDataSource.ExcludeUserAccountsListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.ExclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-exclusionpatterns
         * @external
         */
        readonly exclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.InclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-inclusionpatterns
         * @external
         */
        readonly inclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-secretarn
         * @external
         */
        readonly secretArn: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html
     * @external
     */
    interface OneDriveConfigurationProperty {
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.DisableLocalGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-disablelocalgroups
         * @external
         */
        readonly disableLocalGroups?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.ExclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-exclusionpatterns
         * @external
         */
        readonly exclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.InclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-inclusionpatterns
         * @external
         */
        readonly inclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.OneDriveUsers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-onedriveusers
         * @external
         */
        readonly oneDriveUsers: CfnDataSource.OneDriveUsersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-secretarn
         * @external
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.TenantDomain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-tenantdomain
         * @external
         */
        readonly tenantDomain: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveuserlist.html
     * @external
     */
    interface OneDriveUserListProperty {
        /**
         * `CfnDataSource.OneDriveUserListProperty.OneDriveUserList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveuserlist.html#cfn-kendra-datasource-onedriveuserlist-onedriveuserlist
         * @external
         */
        readonly oneDriveUserList?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveusers.html
     * @external
     */
    interface OneDriveUsersProperty {
        /**
         * `CfnDataSource.OneDriveUsersProperty.OneDriveUserList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveusers.html#cfn-kendra-datasource-onedriveusers-onedriveuserlist
         * @external
         */
        readonly oneDriveUserList?: CfnDataSource.OneDriveUserListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.OneDriveUsersProperty.OneDriveUserS3Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveusers.html#cfn-kendra-datasource-onedriveusers-onedriveusers3path
         * @external
         */
        readonly oneDriveUserS3Path?: CfnDataSource.S3PathProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html
     * @external
     */
    interface S3DataSourceConfigurationProperty {
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.AccessControlListConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-accesscontrollistconfiguration
         * @external
         */
        readonly accessControlListConfiguration?: CfnDataSource.AccessControlListConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-bucketname
         * @external
         */
        readonly bucketName: string;
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.DocumentsMetadataConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-documentsmetadataconfiguration
         * @external
         */
        readonly documentsMetadataConfiguration?: CfnDataSource.DocumentsMetadataConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.ExclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-exclusionpatterns
         * @external
         */
        readonly exclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.InclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-inclusionpatterns
         * @external
         */
        readonly inclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.InclusionPrefixes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-inclusionprefixes
         * @external
         */
        readonly inclusionPrefixes?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3path.html
     * @external
     */
    interface S3PathProperty {
        /**
         * `CfnDataSource.S3PathProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3path.html#cfn-kendra-datasource-s3path-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnDataSource.S3PathProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3path.html#cfn-kendra-datasource-s3path-key
         * @external
         */
        readonly key: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html
     * @external
     */
    interface SalesforceChatterFeedConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceChatterFeedConfigurationProperty.DocumentDataFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-documentdatafieldname
         * @external
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.SalesforceChatterFeedConfigurationProperty.DocumentTitleFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-documenttitlefieldname
         * @external
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceChatterFeedConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceChatterFeedConfigurationProperty.IncludeFilterTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-includefiltertypes
         * @external
         */
        readonly includeFilterTypes?: CfnDataSource.SalesforceChatterFeedIncludeFilterTypesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedincludefiltertypes.html
     * @external
     */
    interface SalesforceChatterFeedIncludeFilterTypesProperty {
        /**
         * `CfnDataSource.SalesforceChatterFeedIncludeFilterTypesProperty.SalesforceChatterFeedIncludeFilterTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedincludefiltertypes.html#cfn-kendra-datasource-salesforcechatterfeedincludefiltertypes-salesforcechatterfeedincludefiltertypes
         * @external
         */
        readonly salesforceChatterFeedIncludeFilterTypes?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html
     * @external
     */
    interface SalesforceConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.ChatterFeedConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-chatterfeedconfiguration
         * @external
         */
        readonly chatterFeedConfiguration?: CfnDataSource.SalesforceChatterFeedConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.CrawlAttachments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-crawlattachments
         * @external
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.ExcludeAttachmentFilePatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-excludeattachmentfilepatterns
         * @external
         */
        readonly excludeAttachmentFilePatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.IncludeAttachmentFilePatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-includeattachmentfilepatterns
         * @external
         */
        readonly includeAttachmentFilePatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.KnowledgeArticleConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-knowledgearticleconfiguration
         * @external
         */
        readonly knowledgeArticleConfiguration?: CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-secretarn
         * @external
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.ServerUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-serverurl
         * @external
         */
        readonly serverUrl: string;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.StandardObjectAttachmentConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-standardobjectattachmentconfiguration
         * @external
         */
        readonly standardObjectAttachmentConfiguration?: CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.StandardObjectConfigurations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-standardobjectconfigurations
         * @external
         */
        readonly standardObjectConfigurations?: CfnDataSource.SalesforceStandardObjectConfigurationListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html
     * @external
     */
    interface SalesforceCustomKnowledgeArticleTypeConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty.DocumentDataFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-documentdatafieldname
         * @external
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty.DocumentTitleFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-documenttitlefieldname
         * @external
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-name
         * @external
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfigurationlist.html
     * @external
     */
    interface SalesforceCustomKnowledgeArticleTypeConfigurationListProperty {
        /**
         * `CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationListProperty.SalesforceCustomKnowledgeArticleTypeConfigurationList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfigurationlist.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfigurationlist-salesforcecustomknowledgearticletypeconfigurationlist
         * @external
         */
        readonly salesforceCustomKnowledgeArticleTypeConfigurationList?: Array<CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html
     * @external
     */
    interface SalesforceKnowledgeArticleConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty.CustomKnowledgeArticleTypeConfigurations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html#cfn-kendra-datasource-salesforceknowledgearticleconfiguration-customknowledgearticletypeconfigurations
         * @external
         */
        readonly customKnowledgeArticleTypeConfigurations?: CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty.IncludedStates`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html#cfn-kendra-datasource-salesforceknowledgearticleconfiguration-includedstates
         * @external
         */
        readonly includedStates: CfnDataSource.SalesforceKnowledgeArticleStateListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty.StandardKnowledgeArticleTypeConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html#cfn-kendra-datasource-salesforceknowledgearticleconfiguration-standardknowledgearticletypeconfiguration
         * @external
         */
        readonly standardKnowledgeArticleTypeConfiguration?: CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticlestatelist.html
     * @external
     */
    interface SalesforceKnowledgeArticleStateListProperty {
        /**
         * `CfnDataSource.SalesforceKnowledgeArticleStateListProperty.SalesforceKnowledgeArticleStateList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticlestatelist.html#cfn-kendra-datasource-salesforceknowledgearticlestatelist-salesforceknowledgearticlestatelist
         * @external
         */
        readonly salesforceKnowledgeArticleStateList?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html
     * @external
     */
    interface SalesforceStandardKnowledgeArticleTypeConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty.DocumentDataFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration-documentdatafieldname
         * @external
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty.DocumentTitleFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration-documenttitlefieldname
         * @external
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectattachmentconfiguration.html
     * @external
     */
    interface SalesforceStandardObjectAttachmentConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty.DocumentTitleFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectattachmentconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectattachmentconfiguration-documenttitlefieldname
         * @external
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectattachmentconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectattachmentconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html
     * @external
     */
    interface SalesforceStandardObjectConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceStandardObjectConfigurationProperty.DocumentDataFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-documentdatafieldname
         * @external
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.SalesforceStandardObjectConfigurationProperty.DocumentTitleFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-documenttitlefieldname
         * @external
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceStandardObjectConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceStandardObjectConfigurationProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-name
         * @external
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfigurationlist.html
     * @external
     */
    interface SalesforceStandardObjectConfigurationListProperty {
        /**
         * `CfnDataSource.SalesforceStandardObjectConfigurationListProperty.SalesforceStandardObjectConfigurationList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfigurationlist.html#cfn-kendra-datasource-salesforcestandardobjectconfigurationlist-salesforcestandardobjectconfigurationlist
         * @external
         */
        readonly salesforceStandardObjectConfigurationList?: Array<CfnDataSource.SalesforceStandardObjectConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html
     * @external
     */
    interface ServiceNowConfigurationProperty {
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.HostUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-hosturl
         * @external
         */
        readonly hostUrl: string;
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.KnowledgeArticleConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-knowledgearticleconfiguration
         * @external
         */
        readonly knowledgeArticleConfiguration?: CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-secretarn
         * @external
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.ServiceCatalogConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-servicecatalogconfiguration
         * @external
         */
        readonly serviceCatalogConfiguration?: CfnDataSource.ServiceNowServiceCatalogConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.ServiceNowBuildVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-servicenowbuildversion
         * @external
         */
        readonly serviceNowBuildVersion: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html
     * @external
     */
    interface ServiceNowKnowledgeArticleConfigurationProperty {
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.CrawlAttachments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-crawlattachments
         * @external
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.DocumentDataFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-documentdatafieldname
         * @external
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.DocumentTitleFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-documenttitlefieldname
         * @external
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.ExcludeAttachmentFilePatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-excludeattachmentfilepatterns
         * @external
         */
        readonly excludeAttachmentFilePatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.IncludeAttachmentFilePatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-includeattachmentfilepatterns
         * @external
         */
        readonly includeAttachmentFilePatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html
     * @external
     */
    interface ServiceNowServiceCatalogConfigurationProperty {
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.CrawlAttachments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-crawlattachments
         * @external
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.DocumentDataFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-documentdatafieldname
         * @external
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.DocumentTitleFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-documenttitlefieldname
         * @external
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.ExcludeAttachmentFilePatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-excludeattachmentfilepatterns
         * @external
         */
        readonly excludeAttachmentFilePatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.IncludeAttachmentFilePatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-includeattachmentfilepatterns
         * @external
         */
        readonly includeAttachmentFilePatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html
     * @external
     */
    interface SharePointConfigurationProperty {
        /**
         * `CfnDataSource.SharePointConfigurationProperty.CrawlAttachments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-crawlattachments
         * @external
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.DisableLocalGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-disablelocalgroups
         * @external
         */
        readonly disableLocalGroups?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.DocumentTitleFieldName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-documenttitlefieldname
         * @external
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.ExclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-exclusionpatterns
         * @external
         */
        readonly exclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.FieldMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-fieldmappings
         * @external
         */
        readonly fieldMappings?: CfnDataSource.DataSourceToIndexFieldMappingListProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.InclusionPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-inclusionpatterns
         * @external
         */
        readonly inclusionPatterns?: CfnDataSource.DataSourceInclusionsExclusionsStringsProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-secretarn
         * @external
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.SharePointVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-sharepointversion
         * @external
         */
        readonly sharePointVersion: string;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.Urls`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-urls
         * @external
         */
        readonly urls: string[];
        /**
         * `CfnDataSource.SharePointConfigurationProperty.UseChangeLog`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-usechangelog
         * @external
         */
        readonly useChangeLog?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.VpcConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-vpcconfiguration
         * @external
         */
        readonly vpcConfiguration?: CfnDataSource.DataSourceVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 */
export declare namespace CfnDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sqlconfiguration.html
     * @external
     */
    interface SqlConfigurationProperty {
        /**
         * `CfnDataSource.SqlConfigurationProperty.QueryIdentifiersEnclosingOption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sqlconfiguration.html#cfn-kendra-datasource-sqlconfiguration-queryidentifiersenclosingoption
         * @external
         */
        readonly queryIdentifiersEnclosingOption?: string;
    }
}
/**
 * Properties for defining a `AWS::Kendra::Faq`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html
 * @external
 */
export interface CfnFaqProps {
    /**
     * `AWS::Kendra::Faq.IndexId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-indexid
     * @external
     */
    readonly indexId: string;
    /**
     * `AWS::Kendra::Faq.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Kendra::Faq.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::Kendra::Faq.S3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-s3path
     * @external
     */
    readonly s3Path: CfnFaq.S3PathProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::Faq.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Kendra::Faq.FileFormat`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-fileformat
     * @external
     */
    readonly fileFormat?: string;
    /**
     * `AWS::Kendra::Faq.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Kendra::Faq`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html
 * @external
 * @cloudformationResource AWS::Kendra::Faq
 */
export declare class CfnFaq extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kendra::Faq";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFaq;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::Kendra::Faq.IndexId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-indexid
     * @external
     */
    indexId: string;
    /**
     * `AWS::Kendra::Faq.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-name
     * @external
     */
    name: string;
    /**
     * `AWS::Kendra::Faq.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::Kendra::Faq.S3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-s3path
     * @external
     */
    s3Path: CfnFaq.S3PathProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::Faq.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Kendra::Faq.FileFormat`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-fileformat
     * @external
     */
    fileFormat: string | undefined;
    /**
     * `AWS::Kendra::Faq.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Kendra::Faq`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFaqProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kendra::Faq`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html
 * @external
 * @cloudformationResource AWS::Kendra::Faq
 */
export declare namespace CfnFaq {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-faq-s3path.html
     * @external
     */
    interface S3PathProperty {
        /**
         * `CfnFaq.S3PathProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-faq-s3path.html#cfn-kendra-faq-s3path-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnFaq.S3PathProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-faq-s3path.html#cfn-kendra-faq-s3path-key
         * @external
         */
        readonly key: string;
    }
}
/**
 * Properties for defining a `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 */
export interface CfnIndexProps {
    /**
     * `AWS::Kendra::Index.Edition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition
     * @external
     */
    readonly edition: string;
    /**
     * `AWS::Kendra::Index.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Kendra::Index.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::Kendra::Index.CapacityUnits`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits
     * @external
     */
    readonly capacityUnits?: CfnIndex.CapacityUnitsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::Index.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Kendra::Index.DocumentMetadataConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations
     * @external
     */
    readonly documentMetadataConfigurations?: Array<CfnIndex.DocumentMetadataConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Kendra::Index.ServerSideEncryptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration
     * @external
     */
    readonly serverSideEncryptionConfiguration?: CfnIndex.ServerSideEncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::Index.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Kendra::Index.UserContextPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy
     * @external
     */
    readonly userContextPolicy?: string;
    /**
     * `AWS::Kendra::Index.UserTokenConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations
     * @external
     */
    readonly userTokenConfigurations?: Array<CfnIndex.UserTokenConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare class CfnIndex extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kendra::Index";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnIndex;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::Kendra::Index.Edition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition
     * @external
     */
    edition: string;
    /**
     * `AWS::Kendra::Index.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name
     * @external
     */
    name: string;
    /**
     * `AWS::Kendra::Index.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::Kendra::Index.CapacityUnits`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits
     * @external
     */
    capacityUnits: CfnIndex.CapacityUnitsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Kendra::Index.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Kendra::Index.DocumentMetadataConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations
     * @external
     */
    documentMetadataConfigurations: Array<CfnIndex.DocumentMetadataConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Kendra::Index.ServerSideEncryptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration
     * @external
     */
    serverSideEncryptionConfiguration: CfnIndex.ServerSideEncryptionConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Kendra::Index.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Kendra::Index.UserContextPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy
     * @external
     */
    userContextPolicy: string | undefined;
    /**
     * `AWS::Kendra::Index.UserTokenConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations
     * @external
     */
    userTokenConfigurations: Array<CfnIndex.UserTokenConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Kendra::Index`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIndexProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html
     * @external
     */
    interface CapacityUnitsConfigurationProperty {
        /**
         * `CfnIndex.CapacityUnitsConfigurationProperty.QueryCapacityUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-querycapacityunits
         * @external
         */
        readonly queryCapacityUnits: number;
        /**
         * `CfnIndex.CapacityUnitsConfigurationProperty.StorageCapacityUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-storagecapacityunits
         * @external
         */
        readonly storageCapacityUnits: number;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html
     * @external
     */
    interface DocumentMetadataConfigurationProperty {
        /**
         * `CfnIndex.DocumentMetadataConfigurationProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnIndex.DocumentMetadataConfigurationProperty.Relevance`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-relevance
         * @external
         */
        readonly relevance?: CfnIndex.RelevanceProperty | cdk.IResolvable;
        /**
         * `CfnIndex.DocumentMetadataConfigurationProperty.Search`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-search
         * @external
         */
        readonly search?: CfnIndex.SearchProperty | cdk.IResolvable;
        /**
         * `CfnIndex.DocumentMetadataConfigurationProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html
     * @external
     */
    interface JsonTokenTypeConfigurationProperty {
        /**
         * `CfnIndex.JsonTokenTypeConfigurationProperty.GroupAttributeField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-groupattributefield
         * @external
         */
        readonly groupAttributeField: string;
        /**
         * `CfnIndex.JsonTokenTypeConfigurationProperty.UserNameAttributeField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-usernameattributefield
         * @external
         */
        readonly userNameAttributeField: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html
     * @external
     */
    interface JwtTokenTypeConfigurationProperty {
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.ClaimRegex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-claimregex
         * @external
         */
        readonly claimRegex?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.GroupAttributeField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-groupattributefield
         * @external
         */
        readonly groupAttributeField?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.Issuer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-issuer
         * @external
         */
        readonly issuer?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.KeyLocation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-keylocation
         * @external
         */
        readonly keyLocation: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.SecretManagerArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-secretmanagerarn
         * @external
         */
        readonly secretManagerArn?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.URL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-url
         * @external
         */
        readonly url?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.UserNameAttributeField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-usernameattributefield
         * @external
         */
        readonly userNameAttributeField?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html
     * @external
     */
    interface RelevanceProperty {
        /**
         * `CfnIndex.RelevanceProperty.Duration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-duration
         * @external
         */
        readonly duration?: string;
        /**
         * `CfnIndex.RelevanceProperty.Freshness`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-freshness
         * @external
         */
        readonly freshness?: boolean | cdk.IResolvable;
        /**
         * `CfnIndex.RelevanceProperty.Importance`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-importance
         * @external
         */
        readonly importance?: number;
        /**
         * `CfnIndex.RelevanceProperty.RankOrder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-rankorder
         * @external
         */
        readonly rankOrder?: string;
        /**
         * `CfnIndex.RelevanceProperty.ValueImportanceItems`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-valueimportanceitems
         * @external
         */
        readonly valueImportanceItems?: CfnIndex.ValueImportanceItemsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html
     * @external
     */
    interface SearchProperty {
        /**
         * `CfnIndex.SearchProperty.Displayable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-displayable
         * @external
         */
        readonly displayable?: boolean | cdk.IResolvable;
        /**
         * `CfnIndex.SearchProperty.Facetable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-facetable
         * @external
         */
        readonly facetable?: boolean | cdk.IResolvable;
        /**
         * `CfnIndex.SearchProperty.Searchable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-searchable
         * @external
         */
        readonly searchable?: boolean | cdk.IResolvable;
        /**
         * `CfnIndex.SearchProperty.Sortable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-sortable
         * @external
         */
        readonly sortable?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html
     * @external
     */
    interface ServerSideEncryptionConfigurationProperty {
        /**
         * `CfnIndex.ServerSideEncryptionConfigurationProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html#cfn-kendra-index-serversideencryptionconfiguration-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html
     * @external
     */
    interface UserTokenConfigurationProperty {
        /**
         * `CfnIndex.UserTokenConfigurationProperty.JsonTokenTypeConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jsontokentypeconfiguration
         * @external
         */
        readonly jsonTokenTypeConfiguration?: CfnIndex.JsonTokenTypeConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnIndex.UserTokenConfigurationProperty.JwtTokenTypeConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jwttokentypeconfiguration
         * @external
         */
        readonly jwtTokenTypeConfiguration?: CfnIndex.JwtTokenTypeConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html
     * @external
     */
    interface ValueImportanceItemProperty {
        /**
         * `CfnIndex.ValueImportanceItemProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnIndex.ValueImportanceItemProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-value
         * @external
         */
        readonly value?: number;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 * @external
 * @cloudformationResource AWS::Kendra::Index
 */
export declare namespace CfnIndex {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitems.html
     * @external
     */
    interface ValueImportanceItemsProperty {
        /**
         * `CfnIndex.ValueImportanceItemsProperty.ValueImportanceItems`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitems.html#cfn-kendra-index-valueimportanceitems-valueimportanceitems
         * @external
         */
        readonly valueImportanceItems?: Array<CfnIndex.ValueImportanceItemProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
