"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimePhoneNumber = exports.PhoneProductType = exports.PhoneCountry = exports.PhoneNumberType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const phoneNumberValidator_1 = require("./phoneNumberValidator");
const pstnCustomResources_1 = require("./pstnCustomResources");
var PhoneNumberType;
(function (PhoneNumberType) {
    PhoneNumberType["LOCAL"] = "Local";
    PhoneNumberType["TOLLFREE"] = "TollFree";
})(PhoneNumberType = exports.PhoneNumberType || (exports.PhoneNumberType = {}));
var PhoneCountry;
(function (PhoneCountry) {
    PhoneCountry["AU"] = "AU";
    PhoneCountry["AT"] = "AT";
    PhoneCountry["CA"] = "CA";
    PhoneCountry["DK"] = "DK";
    PhoneCountry["DE"] = "DE";
    PhoneCountry["IE"] = "IE";
    PhoneCountry["IT"] = "IT";
    PhoneCountry["NZ"] = "NZ";
    PhoneCountry["NG"] = "NG";
    PhoneCountry["PR"] = "PR";
    PhoneCountry["KR"] = "KR";
    PhoneCountry["SE"] = "SE";
    PhoneCountry["CH"] = "CH";
    PhoneCountry["UK"] = "UK";
    PhoneCountry["US"] = "US";
})(PhoneCountry = exports.PhoneCountry || (exports.PhoneCountry = {}));
var PhoneProductType;
(function (PhoneProductType) {
    PhoneProductType["SMA"] = "SipMediaApplicationDialIn";
    PhoneProductType["VC"] = "VoiceConnector";
})(PhoneProductType = exports.PhoneProductType || (exports.PhoneProductType = {}));
class ChimePhoneNumber extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { phoneAreaCode, phoneCity, phoneState, phoneNumberTollFreePrefix, phoneNumberType, phoneCountry, phoneProductType, } = props;
        phoneNumberValidator_1.phoneNumberValidator(props);
        const phoneNumberRequest = new pstnCustomResources_1.PSTNResources(this, 'ChimePhoneNumber', {
            resourceType: 'PhoneNumber',
            uid: uid,
            properties: {
                phoneAreaCode: phoneAreaCode,
                phoneCity: phoneCity,
                phoneState: phoneState,
                phoneNumberType: phoneNumberType,
                phoneNumberTollFreePrefix: phoneNumberTollFreePrefix,
                phoneCountry: phoneCountry || PhoneCountry.US,
                phoneProductType: phoneProductType,
            },
        });
        this.phoneNumber =
            phoneNumberRequest.pstnCustomResource.getAttString('phoneNumber');
    }
    associateWithVoiceConnector(voiceConnectorId) {
        return this.associateNumber(voiceConnectorId.voiceConnectorId, this.phoneNumber);
    }
    associateNumber(voiceConnectorId, e164PhoneNumber) {
        const result = new pstnCustomResources_1.PhoneAssociation(this, 'phoneAssociation', {
            voiceConnectorId,
            e164PhoneNumber,
        });
        return result;
    }
}
exports.ChimePhoneNumber = ChimePhoneNumber;
_a = JSII_RTTI_SYMBOL_1;
ChimePhoneNumber[_a] = { fqn: "cdk-amazon-chime-resources.ChimePhoneNumber", version: "0.1.37" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGhvbmVOdW1iZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcHN0bi9waG9uZU51bWJlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLG1DQUFtQztBQUNuQywyQ0FBdUM7QUFDdkMsaUVBQThEO0FBQzlELCtEQUF3RTtBQUd4RSxJQUFZLGVBR1g7QUFIRCxXQUFZLGVBQWU7SUFDekIsa0NBQWUsQ0FBQTtJQUNmLHdDQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFIVyxlQUFlLEdBQWYsdUJBQWUsS0FBZix1QkFBZSxRQUcxQjtBQUVELElBQVksWUFnQlg7QUFoQkQsV0FBWSxZQUFZO0lBQ3RCLHlCQUFTLENBQUE7SUFDVCx5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtJQUNULHlCQUFTLENBQUE7SUFDVCx5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtJQUNULHlCQUFTLENBQUE7SUFDVCx5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtJQUNULHlCQUFTLENBQUE7SUFDVCx5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtJQUNULHlCQUFTLENBQUE7SUFDVCx5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtBQUNYLENBQUMsRUFoQlcsWUFBWSxHQUFaLG9CQUFZLEtBQVosb0JBQVksUUFnQnZCO0FBRUQsSUFBWSxnQkFHWDtBQUhELFdBQVksZ0JBQWdCO0lBQzFCLHFEQUFpQyxDQUFBO0lBQ2pDLHlDQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFIVyxnQkFBZ0IsR0FBaEIsd0JBQWdCLEtBQWhCLHdCQUFnQixRQUczQjtBQXdERCxNQUFhLGdCQUFpQixTQUFRLHNCQUFTO0lBRzdDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBdUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEdBQUcsR0FBVyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUU3QyxNQUFNLEVBQ0osYUFBYSxFQUNiLFNBQVMsRUFDVCxVQUFVLEVBQ1YseUJBQXlCLEVBQ3pCLGVBQWUsRUFDZixZQUFZLEVBQ1osZ0JBQWdCLEdBQ2pCLEdBQUcsS0FBSyxDQUFDO1FBRVYsMkNBQW9CLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDNUIsTUFBTSxrQkFBa0IsR0FBRyxJQUFJLG1DQUFhLENBQUMsSUFBSSxFQUFFLGtCQUFrQixFQUFFO1lBQ3JFLFlBQVksRUFBRSxhQUFhO1lBQzNCLEdBQUcsRUFBRSxHQUFHO1lBQ1IsVUFBVSxFQUFFO2dCQUNWLGFBQWEsRUFBRSxhQUFhO2dCQUM1QixTQUFTLEVBQUUsU0FBUztnQkFDcEIsVUFBVSxFQUFFLFVBQVU7Z0JBQ3RCLGVBQWUsRUFBRSxlQUFlO2dCQUNoQyx5QkFBeUIsRUFBRSx5QkFBeUI7Z0JBQ3BELFlBQVksRUFBRSxZQUFZLElBQUksWUFBWSxDQUFDLEVBQUU7Z0JBQzdDLGdCQUFnQixFQUFFLGdCQUFnQjthQUNuQztTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxXQUFXO1lBQ2Qsa0JBQWtCLENBQUMsa0JBQWtCLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ3RFLENBQUM7SUFFRCwyQkFBMkIsQ0FBQyxnQkFBcUM7UUFDL0QsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUN6QixnQkFBZ0IsQ0FBQyxnQkFBZ0IsRUFDakMsSUFBSSxDQUFDLFdBQVcsQ0FDakIsQ0FBQztJQUNKLENBQUM7SUFFTyxlQUFlLENBQUMsZ0JBQXdCLEVBQUUsZUFBdUI7UUFDdkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxzQ0FBZ0IsQ0FBQyxJQUFJLEVBQUUsa0JBQWtCLEVBQUU7WUFDNUQsZ0JBQWdCO1lBQ2hCLGVBQWU7U0FDaEIsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQzs7QUFsREgsNENBbURDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgcGhvbmVOdW1iZXJWYWxpZGF0b3IgfSBmcm9tICcuL3Bob25lTnVtYmVyVmFsaWRhdG9yJztcbmltcG9ydCB7IFBTVE5SZXNvdXJjZXMsIFBob25lQXNzb2NpYXRpb24gfSBmcm9tICcuL3BzdG5DdXN0b21SZXNvdXJjZXMnO1xuaW1wb3J0IHsgQ2hpbWVWb2ljZUNvbm5lY3RvciB9IGZyb20gJy4vdm9pY2VDb25uZWN0b3InO1xuXG5leHBvcnQgZW51bSBQaG9uZU51bWJlclR5cGUge1xuICBMT0NBTCA9ICdMb2NhbCcsXG4gIFRPTExGUkVFID0gJ1RvbGxGcmVlJyxcbn1cblxuZXhwb3J0IGVudW0gUGhvbmVDb3VudHJ5IHtcbiAgQVUgPSAnQVUnLFxuICBBVCA9ICdBVCcsXG4gIENBID0gJ0NBJyxcbiAgREsgPSAnREsnLFxuICBERSA9ICdERScsXG4gIElFID0gJ0lFJyxcbiAgSVQgPSAnSVQnLFxuICBOWiA9ICdOWicsXG4gIE5HID0gJ05HJyxcbiAgUFIgPSAnUFInLFxuICBLUiA9ICdLUicsXG4gIFNFID0gJ1NFJyxcbiAgQ0ggPSAnQ0gnLFxuICBVSyA9ICdVSycsXG4gIFVTID0gJ1VTJyxcbn1cblxuZXhwb3J0IGVudW0gUGhvbmVQcm9kdWN0VHlwZSB7XG4gIFNNQSA9ICdTaXBNZWRpYUFwcGxpY2F0aW9uRGlhbEluJyxcbiAgVkMgPSAnVm9pY2VDb25uZWN0b3InLFxufVxuXG4vKipcbiAqIFByb3BzIGZvciBgUGhvbmVOdW1iZXJgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFBob25lTnVtYmVyUHJvcHMge1xuICAvKipcbiAgICogQXJlYSBDb2RlIGZvciBwaG9uZSBudW1iZXIgcmVxdWVzdCAob3B0aW9uYWwpICAtIFVzYWJsZSBvbmx5IHdpdGggVVMgQ291bnRyeVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHBob25lQXJlYUNvZGU/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIENpdHkgZm9yIHBob25lIG51bWJlciByZXF1ZXN0IChvcHRpb25hbCkgLSBVc2FibGUgb25seSB3aXRoIFVTIENvdW50cnlcbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBwaG9uZUNpdHk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFN0YXRlIGZvciBwaG9uZSBudW1iZXIgcmVxdWVzdCAob3B0aW9uYWwpIC0gVXNhYmxlIG9ubHkgd2l0aCBVUyBDb3VudHJ5XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgcGhvbmVTdGF0ZT86IHN0cmluZztcblxuICAvKipcbiAgICogVG9sbCBGcmVlIFByZWZpeCBmb3IgcGhvbmUgbnVtYmVyIHJlcXVlc3QgKG9wdGlvbmFsKVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHBob25lTnVtYmVyVG9sbEZyZWVQcmVmaXg/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFBob25lIE51bWJlciBUeXBlIGZvciBwaG9uZSBudW1iZXIgcmVxdWVzdCAob3B0aW9uYWwpIC0gTG9jYWwgb3IgVG9sbEZyZWUgLSBSZXF1aXJlZCB3aXRoIG5vbi1VUyBjb3VudHJ5XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgcGhvbmVOdW1iZXJUeXBlPzogUGhvbmVOdW1iZXJUeXBlO1xuXG4gIC8qKlxuICAgKiBDb3VudHJ5IGZvciBwaG9uZSBudW1iZXIgcmVxdWVzdCAob3B0aW9uYWwpIC0gU2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jaGltZS9sYXRlc3QvYWcvcGhvbmUtY291bnRyeS1yZXFzLmh0bWwgZm9yIG1vcmUgZGV0YWlsc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIFVTXG4gICAqL1xuICByZWFkb25seSBwaG9uZUNvdW50cnk/OiBQaG9uZUNvdW50cnk7XG5cbiAgLyoqXG4gICAqIFBob25lIFByb2R1Y3QgVHlwZSAocmVxdWlyZWQpIC0gU2lwTWVkaWFBcHBsaWNhdGlvbkRpYWxJbiBvciBWb2ljZUNvbm5lY3RvclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHBob25lUHJvZHVjdFR5cGU6IFBob25lUHJvZHVjdFR5cGU7XG59XG5cbmV4cG9ydCBjbGFzcyBDaGltZVBob25lTnVtYmVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IHBob25lTnVtYmVyOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFBob25lTnVtYmVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgdWlkOiBzdHJpbmcgPSBjZGsuTmFtZXMudW5pcXVlSWQodGhpcyk7XG5cbiAgICBjb25zdCB7XG4gICAgICBwaG9uZUFyZWFDb2RlLFxuICAgICAgcGhvbmVDaXR5LFxuICAgICAgcGhvbmVTdGF0ZSxcbiAgICAgIHBob25lTnVtYmVyVG9sbEZyZWVQcmVmaXgsXG4gICAgICBwaG9uZU51bWJlclR5cGUsXG4gICAgICBwaG9uZUNvdW50cnksXG4gICAgICBwaG9uZVByb2R1Y3RUeXBlLFxuICAgIH0gPSBwcm9wcztcblxuICAgIHBob25lTnVtYmVyVmFsaWRhdG9yKHByb3BzKTtcbiAgICBjb25zdCBwaG9uZU51bWJlclJlcXVlc3QgPSBuZXcgUFNUTlJlc291cmNlcyh0aGlzLCAnQ2hpbWVQaG9uZU51bWJlcicsIHtcbiAgICAgIHJlc291cmNlVHlwZTogJ1Bob25lTnVtYmVyJyxcbiAgICAgIHVpZDogdWlkLFxuICAgICAgcHJvcGVydGllczoge1xuICAgICAgICBwaG9uZUFyZWFDb2RlOiBwaG9uZUFyZWFDb2RlLFxuICAgICAgICBwaG9uZUNpdHk6IHBob25lQ2l0eSxcbiAgICAgICAgcGhvbmVTdGF0ZTogcGhvbmVTdGF0ZSxcbiAgICAgICAgcGhvbmVOdW1iZXJUeXBlOiBwaG9uZU51bWJlclR5cGUsXG4gICAgICAgIHBob25lTnVtYmVyVG9sbEZyZWVQcmVmaXg6IHBob25lTnVtYmVyVG9sbEZyZWVQcmVmaXgsXG4gICAgICAgIHBob25lQ291bnRyeTogcGhvbmVDb3VudHJ5IHx8IFBob25lQ291bnRyeS5VUyxcbiAgICAgICAgcGhvbmVQcm9kdWN0VHlwZTogcGhvbmVQcm9kdWN0VHlwZSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnBob25lTnVtYmVyID1cbiAgICAgIHBob25lTnVtYmVyUmVxdWVzdC5wc3RuQ3VzdG9tUmVzb3VyY2UuZ2V0QXR0U3RyaW5nKCdwaG9uZU51bWJlcicpO1xuICB9XG5cbiAgYXNzb2NpYXRlV2l0aFZvaWNlQ29ubmVjdG9yKHZvaWNlQ29ubmVjdG9ySWQ6IENoaW1lVm9pY2VDb25uZWN0b3IpIHtcbiAgICByZXR1cm4gdGhpcy5hc3NvY2lhdGVOdW1iZXIoXG4gICAgICB2b2ljZUNvbm5lY3RvcklkLnZvaWNlQ29ubmVjdG9ySWQsXG4gICAgICB0aGlzLnBob25lTnVtYmVyLFxuICAgICk7XG4gIH1cblxuICBwcml2YXRlIGFzc29jaWF0ZU51bWJlcih2b2ljZUNvbm5lY3RvcklkOiBzdHJpbmcsIGUxNjRQaG9uZU51bWJlcjogc3RyaW5nKSB7XG4gICAgY29uc3QgcmVzdWx0ID0gbmV3IFBob25lQXNzb2NpYXRpb24odGhpcywgJ3Bob25lQXNzb2NpYXRpb24nLCB7XG4gICAgICB2b2ljZUNvbm5lY3RvcklkLFxuICAgICAgZTE2NFBob25lTnVtYmVyLFxuICAgIH0pO1xuICAgIHJldHVybiByZXN1bHQ7XG4gIH1cbn1cbiJdfQ==