#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['lenskit',
 'lenskit.algorithms',
 'lenskit.algorithms.tf',
 'lenskit.batch',
 'lenskit.math',
 'lenskit.metrics',
 'lenskit.sharing',
 'lenskit.util']

package_data = \
{'': ['*']}

install_requires = \
['pandas >= 0.24',
 'numpy >= 1.16',
 'scipy >= 1.2',
 'numba >= 0.51, < 0.53',
 'pyarrow >= 0.15',
 'cffi >= 1.12.2',
 'binpickle >= 0.3.2',
 'csr >=0.2,<0.3']

extras_require = \
{'demo': ['notebook', 'nbval', 'matplotlib', 'ipywidgets', 'tqdm'],
 'dev': ['flit', 'packaging', 'flake8', 'coverage', 'pytest-cov', 'ipython'],
 'doc': ['sphinx >= 1.8',
         'sphinx_rtd_theme',
         'nbsphinx',
         'recommonmark',
         'ipython'],
 'hpf': ['hpfrec'],
 'implicit': ['implicit'],
 'sklearn': ['scikit-learn >= 0.22'],
 'test': ['pytest >= 3.9', 'pytest-doctestplus', 'hypothesis'],
 'tf': ['tensorflow >= 2.1']}

setup(name='lenskit',
      version='0.12.0',
      description='The LensKit package.',
      author='Michael Ekstrand',
      author_email='michaelekstrand@boisestate.edu',
      url='https://lenskit.lenskit.org',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>= 3.6.1',
     )
