#!/usr/bin/env python3
#
# GlobalChem - Schedule Five
#
# -----------------------------------

class Pihkal(object):

    def __init__(self):

        self.name = 'pihkal'

    @staticmethod
    def get_smiles():

        smiles = {
            'alpha-ethylmescaline': 'CCC(N)CC1=CC(=C(OC)C(=C1)OC)OC',
            '4-allyloxy-3,5-dimethoxyphenethylamine': 'COC1=CC(=CC(=C1OCC=C)OC)CCN',
            '2,5-dimethoxy-4-methylthioamphetamine': 'COC1=CC(=C(OC)C=C1CC(C)N)SC',
            '2,5-dimethoxy-4-ethylthioamphetamine': 'CCSC1=C(OC)C=C(CC(C)N)C(=C1)OC',
            '2,5-dimethoxy-4-(i)-propylthioamphetamine': 'COC1=CC(=C(OC)C=C1CC(C)N)SC(C)C',
            '2,5-dimethoxy-4-phenylthioamphetamine': 'COC1=CC(=C(OC)C=C1CC(C)N)SC2=CC=CC=C2',
            '2,5-dimethoxy-4-(n)-propylthioamphetamine': 'CCCSC1=C(OC)C=C(CC(C)N)C(=C1)OC',
            'dimoxamine': 'CCC(N)CC1=CC(=C(C)C=C1OC)OC',
            'asymbescaline': 'CCOC1=CC(=CC(=C1OCC)OC)CCN',
            'buscaline': 'CCCCOC1=C(OC)C=C(CCN)C=C1OC',
            '2,5-dimethoxy-4,n-dimethylamphetamine': 'CNC(C)CC1=CC(=C(C)C=C1OC)OC',
            '4-methyl-2,5-bis-(methylthio)amphetamine': 'CSC1=C(C)C=C(SC)C(=C1)CC(C)N',
            '4-bromo-2,5-beta-trimethoxyphenethylamine': 'COC(CN)C1=CC(=C(Br)C=C1OC)OC',
            '4-methyl-2,5,beta-trimethoxyphenethylamine': 'COC(CN)C1=CC(=C(C)C=C1OC)OC',
            'beta-methoxy-3,4-methylenedioxyphenethylamine': 'COC(CN)C1=CC(=C(C)C=C1OC)OC',
            '2,5-dimethoxy-beta-hydroxy-4-methylphenethylamine': 'CC1=C(O)C=C(C(O)CN)C(=C1)Br',
            'beta-methoxymescaline': 'COC(CN)C1=CC(=C(OC)C(=C1)OC)OC',
            '3,5-dimethoxy-4-bromoamphetamine': 'COC1=C(Br)C(=CC(=C1)CC(C)N)OC',
            '2-bromo-4,5-methylenedioxyamphetamine': 'CC(N)CC1=C(Br)C=C2OCOC2=C1',
            '4-bromo-2,5-dimethoxyphenethylamine': '[CH3:20][O:13][C:6]1=[CH:5][C:4](=[C:3]([O:16][CH3:11])[CH:2]=[C:1]1[Br:12])[CH2:8][CH2:9][NH2:10]',
            '4-benzyloxy-3,5-dimethoxyamphetamine': 'COC1=C(OCC2=CC=CC=C2)C(=CC(=C1)CC(C)N)OC',
            '2,5-dimethoxy-4-chlorophenethylamine': 'COC1=CC(=C(OC)C=C1Cl)CCN',
            '2,5-dimethoxy-4-methylphenethylamine': '[CH3:20][O:13][C:6]1=[CH:5][C:4](=[C:3]([O:16][CH3:11])[CH:2]=[C:1]1[CH3:12])[CH2:8][CH2:9][NH2:10]',
            '2,5-dimethoxy-4-ethylphenethylamine': 'CCC1=CC(=C(CCN)C=C1OC)OC',
            '3,5-dimethoxy-4-ethoxyamphetamine': 'CCOC1=C(OC)C=C(CC(C)N)C=C1OC',
            '2,5-dimethoxy-4-fluorophenethylamine': 'COC1=CC(=C(OC)C=C1F)CCN',
            '2,5-dimethoxy-3,4-dimethylphenethylamine': 'COC1=CC(=C(OC)C(=C1C)C)CCN',
            '2,5-dimethoxy-3,4-(trimethylene)phenethylamine': 'COC1=CC(=C(OC)C2=C1CCC2)CCN',
            '2,5-dimethoxy-3,4-(tetramethylene)phenethylamine': 'COC1=CC(=C(OC)C2=C1CCCC2)CCN',
            '3,6-dimethoxy-4-(2-aminoethyl)benzonorbornane': 'COC1=CC(=C(OC)C2=C1C3CCC2C3)CCN',
            '1,4-dimethoxynaphthyl-2-ethylamine': 'COC1=CC(=C(OC)C2=C1C=CC=C2)CCN',
            '2,5-dimethoxyphenethylamine': 'COC1=CC(=C(OC)C=C1)CCN',
            '2,5-dimethoxy-4-iodophenethylamine': '[CH3:20][O:13][C:6]1=[CH:5][C:4](=[C:3]([O:16][CH3:11])[CH:2]=[C:1]1[I:12])[CH2:8][CH2:9][NH2:10]',
            '2,5-dimethoxy-4-nitrophenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)[N](=O)=O',
            '2,5-dimethoxy-4-(i)-propoxyphenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)OC(C)C',
            '2,5-dimethoxy-4-(n)-propylphenethylamine': 'CCCOC1=CC(=C(CCN)C=C1OC)OC',
            'cyclopropylmescaline': 'COC1=C(CCN)C=C(OC)C(=C1)OCC2CC2',
            '2,5-dimethoxy-4-methylseleneophenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)[Se]C',
            '2,5-dimethoxy-4-methylthiophenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)SC',
            '2,5-dimethoxy-4-ethylthiophenethylamine': '[CH3:30][CH2:29][S:12][C:1]1=[CH:2][C:3](=[C:4]([CH2:8][CH2:9][NH2:10])[CH:5]=[C:6]1[O:13][CH3:20])[O:16][CH3:11]',
            '2,5-dimethoxy-4-(i)-propylthiophenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)SC(C)C',
            '2,6-dimethoxy-4-(i)-propylthiophenethylamine)': 'COC1=C(CCN)C(=CC(=C1)SC(C)C)OC',
            '2,5-dimethoxy-4-(n)-propylthiophenethylamine': '[CH3:33][CH2:30][CH2:29][S:12][C:1]1=[CH:2][C:3](=[C:4]([CH2:8][CH2:9][NH2:10])[CH:5]=[C:6]1[O:13][CH3:20])[O:16][CH3:11]',
            '2,5-dimethoxy-4-cyclopropylmethylthiophenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)SCC2CC2',
            '2,5-dimethoxy-4-(t)-butylthiophenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)SC(C)(C)C',
            '2,5-dimethoxy-4-(2-methoxyethylthio)phenethylamine': 'COCCSC1=CC(=C(CCN)C=C1OC)OC',
            '2,5-dimethoxy-4-cyclopropylthiophenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)SC2CC2',
            '2,5-dimethoxy-4-(s)-butylthiophenethylamine': 'CCC(C)SC1=CC(=C(CCN)C=C1OC)OC',
            '2,5-dimethoxy-4-(2-fluoroethylthio)phenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)SCCF',
            '3,5-dimethoxy-4-trideuteromethoxy-phenethylamine': 'COC1=CC(=CC(=C1OC)OC)CCN',
            '3,4,5-trimethoxy-beta,beta-dideuterophenethylamine': 'COC1=CC(=CC(=C1OC)OC)CCN',
            '3,5-dimethoxy-4-methylphenethylamine': 'COC1=CC(=CC(=C1C)OC)CCN',
            '2,4-dimethoxyamphetamine': 'COC1=CC=C(CC(C)N)C(=C1)OC',
            '2,5-dimethoxyamphetamine': 'COC1=CC=C(OC)C(=C1)CC(C)N',
            '3,4-dimethoxyamphetamine': 'COC1=CC=C(CC(C)N)C=C1OC',
            '2-(2,5-dimethoxy-4-methylphenyl)cyclopropylamine': 'COC1=CC(=C(OC)C=C1C)C2CC2N',
            '3,4-dimethoxy-beta-hydroxyphenethylamine': 'COC1=CC=C(C=C1OC)C(O)CN',
            '2,5-dimethoxy-3,4-methylenedioxyamphetamine': 'COC1=C2OCOC2=C(OC)C(=C1)CC(C)N',
            '2,3-dimethoxy-4,5-methylenedioxyamphetamine': 'COC1=C(CC(C)N)C=C2OCOC2=C1OC',
            '3,4-dimethoxyphenethylamine': 'COC1=CC=C(CCN)C=C1OC',
            '2,5-dimethoxy-4-(n)-amylamphetamine': 'CCCCCC1=CC(=C(CC(C)N)C=C1OC)OC',
            '2,5-dimethoxy-4-bromoamphetamine': 'COC1=CC(=C(OC)C=C1Br)CC(C)N',
            '2,5-dimethoxy-4-(n)-butylamphetamine': 'CCCCC1=CC(=C(CC(C)N)C=C1OC)OC',
            '2,5-dimethoxy-4-chloroamphetamine': 'COC1=CC(=C(OC)C=C1Cl)CC(C)N',
            '2,5-dimethoxy-4-(2-fluoroethyl)-amphetamine': 'COC1=CC(=C(OC)C=C1CCF)CC(C)N',
            '2,5-dimethoxy-4-ethylamphetamine': 'CCC1=CC(=C(CC(C)N)C=C1OC)OC',
            '2,5-dimethoxy-4-iodoamphetamine': 'COC1=CC(=C(OC)C=C1I)CC(C)N',
            '2,5-dimethoxy-4-methylamphetamine': 'COC1=CC(=C(OC)C=C1C)CC(C)N',
            '2,6-dimethoxy-4-methylamphetamine': 'COC1=C(CC(C)N)C(=CC(=C1)C)OC',
            '2,5-dimethoxy-4-nitroamphetamine': 'COC1=C(CC(C)N)C=C(OC)C(=C1)[N](=O)=O',
            '2,5-dimethoxy-4-(n)-propylamphetamine': 'CCCC1=CC(=C(CC(C)N)C=C1OC)OC',
            '3,5-dimethoxy-4-ethoxyphenethylamine': 'CCOC1=C(OC)C=C(CCN)C=C1OC',
            '2,4,5-triethoxyamphetamine': 'CCOC1=C(CC(C)N)C=C(OCC)C(=C1)OCC',
            '2,4-diethoxy-5-methoxyamphetamine': 'CCOC1=C(CCN)C=C(OC)C(=C1)OCC',
            '2,5-diethoxy-4-methoxyamphetamine': 'CCOC1=C(CCN)C=C(OCC)C(=C1)OC',
            '4,5-dimethoxy-2-ethoxyamphetamine': 'CCOC1=C(CCN)C=C(OC)C(=C1)OC',
            '2-ethylamino-1-(3,4-methylenedioxyphenyl)butane': 'CCC(N)CC1=CC=C2OCOC2=C1',
            '2-ethylamino-1-(3,4-methylenedioxyphenyl)pentane': 'CCCC(CC1=CC=C2OCOC2=C1)NCC',
            '6-(2-aminopropyl)-5-methoxy-2-methyl-2,3-dihydrobenzofuran': 'COC1=C(CC(C)N)C=C2OC(C)CC2=C1',
            '6-(2-aminopropyl)-2,2-dimethyl-5-methoxy-2,3-dihydrobenzofuran': 'COC1=C(CC(C)N)C=C2OC(C)(C)CC2=C1',
            'n-hydroxy-n-methyl-3,4-methylenedioxyamphetamine': 'CC(CC1=CC=C2OCOC2=C1)N(C)O',
            '2,5-dimethoxy-3,4-(trimethylene)amphetamine': 'COC1=C2CCCC2=C(OC)C(=C1)CC(C)N',
            '2,5-dimethoxy-3,4-(tetramethylene)amphetamine': 'COC1=C2CCCCC2=C(OC)C(=C1)CC(C)N',
            '3,6-dimethoxy-4-(2-aminopropyl)benzonorbornane': 'COC1=C2C3CCC(C3)C2=C(OC)C(=C1)CC(C)N',
            '2,5-dimethoxy-3,4-dimethylamphetamine': 'COC1=CC(=C(OC)C(=C1C)C)CC(C)N',
            '1,4-dimethoxynaphthyl-2-isopropylamine': 'COC1=CC(=C(OC)C2=C1C=CC=C2)CC(C)N',
            '2,5-dimethoxy-4-ethylthio-n-hydroxyphenethylamine': 'CCSC1=CC(=C(CCNO)C=C1OC)OC',
            '2,5-dimethoxy-n-hydroxy-4-(n)-propylthiophenethylamine': 'CCCSC1=CC(=C(CCNO)C=C1OC)OC',
            '2,5-dimethoxy-4-(s)-butylthio-n-hydroxyphenethylamine': 'CCC(C)SC1=CC(=C(CCNO)C=C1OC)OC',
            '2,5-dimethoxy-n,n-dimethyl-4-iodoamphetamine': 'COC1=CC(=C(OC)C=C1I)CC(C)N(C)C',
            'isomescaline': 'COC1=C(OC)C(=C(CCN)C=C1)OC',
            'isoproscaline': 'COC1=CC(=CC(=C1OC(C)C)OC)CCN',
            '5-ethoxy-2-methoxy-4-methylamphetamine': 'CCOC1=CC(=C(OC)C=C1C)CC(C)N',
            '2-amino-1-(3,4-methylenedioxyphenyl)butane': 'CCC(N)CC1=CC=C2OCOC2=C1',
            '3-methoxy-4,5-methylenedioxyphenethylamine': 'COC1=C2OCOC2=CC(=C1)CCN',
            'mescaline': 'COC1=CC(=CC(=C1OC)OC)CCN',
            '4-methoxyamphetamine': 'CC(CC1=CC=C(C=C1)OC)N',
            '2,n-dimethyl-4,5-methylenedioxyamphetamine': 'CNC(C)CC1=C(C)C=C2OCOC2=C1',
            'methallylescaline': 'COC1=CC(=CC(=C1OCC(C)=C)OC)CCN',
            '3,4-methylenedioxyamphetamine': 'CC(N)CC1=CC=C2OCOC2=C1',
            '3,4-methylenedioxy-n- allylamphetamine': 'CC(CC1=CC=C2OCOC2=C1)NCC=C',
            '3,4-methylenedioxy-n-butylamphetamine': 'CCCCNC(C)CC1=CC=C2OCOC2=C1',
            '3,4-methylenedioxy-n-benzylamphetamine': 'CC(CC1=CC=C2OCOC2=C1)NCC3=CC=CC=C3',
            '3,4-methylenedioxy-ncyclopropylmethylamphetamine': 'CC(CC1=CC=C2OCOC2=C1)NCC3CC3',
            '3,4-methylenedioxy-n,n-dimethylamphetamine': 'CC(CC1=CC=C2OCOC2=C1)N(C)C',
            '3,4-methylenedioxy-n-ethylamphetamine': 'CCNC(C)CC1=CC=C2OCOC2=C1',
            '3,4-methylenedioxy-n-(2-hydroxyethyl)amphetamine': 'CC(CC1=CC=C2OCOC2=C1)NCCO',
            '(3,4-methylenedioxy-n-isopropylamphetamine)': 'CC(C)NC(C)CC1=CC=C2OCOC2=C1',
            '3,4-methylenedioxy-n-methylamphetamine': 'CNC(C)CC1=CC=C2OCOC2=C1',
            '3,4-ethylenedioxy-n-methylamphetamine': 'CNC(C)CC1=CC=C2OCCOC2=C1',
            '3,4-methylenedioxy-n-methyoxyamphetamine': 'CONC(C)CC1=CC=C2OCOC2=C1',
            '3,4-methylenedioxy-n-(2-methoxyethyl)amphetamine': 'COCCNC(C)CC1=CC=C2OCOC2=C1',
            'a,a,n-trimethyl-3,4-methylenedioxy-phenethylamine': 'CNC(C)(C)CC1=CC=C2OCOC2=C1',
            '3,4-methylenedioxy-n-hydroxyamphetamine': 'CC(CC1=CC=C2OCOC2=C1)NO',
            '3,4-methylenedioxyphenethylamine': 'NCCC1=CC=C2OCOC2=C1',
            'a,a-dimethyl-3,4-methylenedioxy-phenethylamine': 'CC(C)(N)CC1=CC=C2OCOC2=C1',
            '3,4-methylenedioxy-npropargylamphetamine)': 'CC(CC1=CC=C2OCOC2=C1)NCC#C',
            '3,4-methylenedioxy-n-propylamphetamine': 'CCCNC(C)CC1=CC=C2OCOC2=C1',
            'metaescaline': 'CCOC1=CC(=CC(=C1OC)OC)CCN',
            '3-methoxy-4,5-ethylenedioxyamphetamine': 'COC1=C2OCCOC2=CC(=C1)CCN',
            '4,5-diethoxy-2-methoxyamphetamine': 'CCOC1=CC(=C(OC)C=C1OCC)CC(C)N',
            '2,5-dimethoxy-4-ethoxyamphetamine': 'CCOC1=CC(=C(CC(C)N)C=C1OC)OC',
            '3-methoxy-4-ethoxyphenethylamine': 'CCOC1=CC=C(CCN)C=C1OC',
            '5-bromo-2,4-dimethoxyamphetamine': 'COC1=CC(=C(CC(C)N)C=C1Br)OC',
            '2,4-dimethoxy-5-methylthioamphetamine': 'COC1=C(CC(C)N)C=C(SC)C(=C1)OC',
            '2,5-dimethoxy-n-methylamphetamine': 'CNC(C)CC1=C(OC)C=CC(=C1)OC',
            '4-bromo-2,5-dimethoxy-n-methylamphetamine': 'CNC(C)CC1=C(OC)C=C(Br)C(=C1)OC',
            '2-methylamino-1-(3,4-methylenedioxyphenyl)butane': 'CCC(CC1=CC=C2OCOC2=C1)NC',
            '2-methylamino-1-(3,4-methylenedioxyphenyl)pentane': 'CCCC(CC1=CC=C2OCOC2=C1)NC',
            '4-methoxy-n-methylamphetamine': 'CNC(C)CC1=CC=C(OC)C=C1',
            '2-methoxy-n-methyl-4,5-methylenedioxyamphetamine': 'CNC(C)CC1=C(OC)C=C2OCOC2=C1',
            '3-methoxy-4,5-methylenedioxyamphetamine': 'COC1=C2OCOC2=CC(=C1)CC(C)N',
            '2-methoxy-4,5-methylenedioxyamphetamine': 'COC1=C(CC(C)N)C=C2OCOC2=C1',
            '2-methoxy-3,4-methylenedioxyamphetamine': 'COC1=C2OCOC2=CC=C1CC(C)N',
            '4-methoxy-2,3-methylenedioxyamphetamine': 'COC1=CC=C(CC(C)N)C2=C1OCO2',
            '2,4-dimethoxy-5-ethoxyamphetamine': 'CCOC1=CC(=C(OC)C=C1OC)CC(C)N',
            'metaproscaline': 'CCCOC1=CC(=CC(=C1OC)OC)CCN',
            '2,5-dimethoxy-4-(n)-propoxyamphetamine': 'COc1cc(OC)c(cc1OCCC)CC(C)N',
            '4,5-dimethoxy-2-methylthioamphetamine': 'COC1=CC(=C(SC)C=C1OC)CC(C)N',
            'proscaline': 'CCCOC1=C(OC)C=C(CCN)C=C1OC',
            'phenescaline': 'COC1=CC(=CC(=C1OCCCC2=CC=CC=C2)OC)CCN',
            'phenethylamine': 'NCCC1=CC=CC=C1',
            '3,5-dimethoxy-4-(2-propynyloxy)phenethylamine': 'COC1=CC(=CC(=C1OCC=C)OC)CCN',
            'symbescaline': 'CCOC1=CC(=CC(=C1OC)OCC)CCN',
            '2,3,4,5-tetramethoxyamphetamine': 'COC1=C(OC)C(=C(OC)C(=C1)CC(C)N)OC',
            '3-thioasymbescaline': '[CH3:16][CH2:15][O:14][C:8]1=[C:1]([S:10][CH2:11][CH3:17])[CH:2]=[C:3]([CH2:5][CH2:6][NH2:7])[CH:4]=[C:9]1[O:12][CH3:13]',
            '4-thioasymbescaline': 'CCOC1=CC(=CC(=C1SCC)OC)CCN',
            '5-thioasymbescaline': 'CCOC1=CC(=CC(=C1OCC)SC)CCN',
            '4-thiobuscaline': 'CCCCSC1=C(OC)C=C(CCN)C=C1OC',
            '3-thioescaline': 'CCOC1=C(OC)C=C(CCN)C=C1SC',
            '4-thioescaline': '[CH3:16][CH2:11][S:10][C:8]1=[C:1]([O:12][CH3:13])[CH:2]=[C:3]([CH2:5][CH2:6][NH2:7])[CH:4]=[C:9]1[O:14][CH3:15]',
            '2-thioisomescaline': 'COC1=C(OC)C(=C(CCN)C=C1)SC',
            '3-thiomescaline': 'COC1=C(SC)C(=C(CCN)C=C1)OC',
            '4-thioisomescaline': 'COC1=C(CCN)C=CC(=C1OC)SC',
            '2-thiomescaline': 'COC1=CC(=CC(=C1OC)SC)CCN',
            '4-thiomescaline': 'COC1=CC(=CC(=C1SC)OC)CCN',
            '3,4,5-trimethoxyamphetamine': 'COC1=CC(=CC(=C1OC)OC)CC(C)N',
            '2,4,5-trimethoxyamphetamine': 'COC1=C(CC(C)N)C=C(OC)C(=C1)OC',
            '2,3,4-trimethoxyamphetamine': 'COC1=C(OC)C(=C(CC(C)N)C=C1)OC',
            '2,3,5-trimethoxyamphetamine': 'COC1=CC(=C(OC)C(=C1)OC)CC(C)N',
            '2,3,6-trimethoxyamphetamine': 'COC1=CC=C(OC)C(=C1CC(C)N)OC',
            '2,4,6-trimethoxyamphetamine': 'COC1=CC(=C(CC(C)N)C(=C1)OC)OC',
            '3-thiometaescaline': 'CCSC1=CC(=CC(=C1OC)OC)CCN',
            '4-thiometaescaline': 'CCOC1=CC(=CC(=C1SC)OC)CCN',
            '5-thiometaescaline': 'CCOC1=CC(=CC(=C1OC)SC)CCN',
            '3,4-methylenedioxy-2-methylthioamphetamine': 'CSC1=C2OCOC2=CC=C1CC(C)N',
            '6-(2-aminopropyl)-5-methoxy-1,3-benzoxathiol': 'COC1=C(CC(C)N)C=C2OCSC2=C1',
            '2,4,5-trimethoxyphenethylamine': 'COC1=C(CCN)C=C(OC)C(=C1)OC',
            '4-ethyl-5-methoxy-2-methylthioamphetamine': 'CCC1=CC(=C(CC(C)N)C=C1OC)SC',
            '4-ethyl-2-methoxy-5-methylthioamphetamine': 'CCC1=CC(=C(CC(C)N)C=C1SC)OC',
            '5-methoxy-4-methyl-2-methylthioamphetamine': 'COC1=CC(=C(SC)C=C1C)CC(C)N',
            '2-methoxy-4-methyl-5-methylthioamphetamine': 'COC1=C(CC(C)N)C=C(SC)C(=C1)C',
            '2-methoxy-4-methyl-5-methylsulfinylamphetamine': 'COC1=C(CC(C)N)C=C(C(=C1)C)[S](C)=O',
            'thioproscaline': 'CCCSC1=C(OC)C=C(CCN)C=C1OC',
            'trescaline': 'CCOC1=CC(=CC(=C1OCC)OCC)CCN',
            '3-thiosymbescaline': 'CCOC1=C(OC)C(=CC(=C1)CCN)SCC',
            '4-thiosymbescaline': 'CCOC1=CC(=CC(=C1SC)OCC)CCN',
            '3-thiotrescaline': 'CCOC1=C(OCC)C(=CC(=C1)CCN)SCC',
            '4-thiotrescaline': 'CCOC1=CC(=CC(=C1SCC)OCC)CCN',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'alpha-ethylmescaline': '[#6]-[#6]-[#6](-[#7])-[#6]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#8]-[#6])-[#8]-[#6]',
            '4-allyloxy-3,5-dimethoxyphenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6]-[#6]=[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '2,5-dimethoxy-4-methylthioamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#6]-[#6](-[#6])-[#7])-[#16]-[#6]',
            '2,5-dimethoxy-4-ethylthioamphetamine': '[#6]-[#6]-[#16]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#6]-[#6](-[#6])-[#7]):[#6](:[#6]:1)-[#8]-[#6]',
            '2,5-dimethoxy-4-(i)-propylthioamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#6]-[#6](-[#6])-[#7])-[#16]-[#6](-[#6])-[#6]',
            '2,5-dimethoxy-4-phenylthioamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#6]-[#6](-[#6])-[#7])-[#16]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '2,5-dimethoxy-4-(n)-propylthioamphetamine': '[#6]-[#6]-[#6]-[#16]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#6]-[#6](-[#6])-[#7]):[#6](:[#6]:1)-[#8]-[#6]',
            'dimoxamine': '[#6]-[#6]-[#6](-[#7])-[#6]-[#6]1:[#6]:[#6](:[#6](-[#6]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            'asymbescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            'buscaline': '[#6]-[#6]-[#6]-[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6]',
            '2,5-dimethoxy-4,n-dimethylamphetamine': '[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6](:[#6](-[#6]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '4-methyl-2,5-bis-(methylthio)amphetamine': '[#6]-[#16]-[#6]1:[#6](-[#6]):[#6]:[#6](-[#16]-[#6]):[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7]',
            '4-bromo-2,5-beta-trimethoxyphenethylamine': '[#6]-[#8]-[#6](-[#6]-[#7])-[#6]1:[#6]:[#6](:[#6](-[#35]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '4-methyl-2,5,beta-trimethoxyphenethylamine': '[#6]-[#8]-[#6](-[#6]-[#7])-[#6]1:[#6]:[#6](:[#6](-[#6]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            'beta-methoxy-3,4-methylenedioxyphenethylamine': '[#6]-[#8]-[#6](-[#6]-[#7])-[#6]1:[#6]:[#6](:[#6](-[#6]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-beta-hydroxy-4-methylphenethylamine': '[#6]-[#6]1:[#6](-[#8]):[#6]:[#6](-[#6](-[#8])-[#6]-[#7]):[#6](:[#6]:1)-[#35]',
            'beta-methoxymescaline': '[#6]-[#8]-[#6](-[#6]-[#7])-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#8]-[#6])-[#8]-[#6]',
            '3,5-dimethoxy-4-bromoamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#35]):[#6](:[#6]:[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7])-[#8]-[#6]',
            '2-bromo-4,5-methylenedioxyamphetamine': '[#6]-[#6](-[#7])-[#6]-[#6]1:[#6](-[#35]):[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '4-bromo-2,5-dimethoxyphenethylamine': '[#6H3:20]-[#8:13]-[#6:6]1:[#6H:5]:[#6:4](:[#6:3](-[#8:16]-[#6H3:11]):[#6H:2]:[#6:1]:1-[#35:12])-[#6H2:8]-[#6H2:9]-[#7H2:10]',
            '4-benzyloxy-3,5-dimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2):[#6](:[#6]:[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7])-[#8]-[#6]',
            '2,5-dimethoxy-4-chlorophenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#17])-[#6]-[#6]-[#7]',
            '2,5-dimethoxy-4-methylphenethylamine': '[#6H3:20]-[#8:13]-[#6:6]1:[#6H:5]:[#6:4](:[#6:3](-[#8:16]-[#6H3:11]):[#6H:2]:[#6:1]:1-[#6H3:12])-[#6H2:8]-[#6H2:9]-[#7H2:10]',
            '2,5-dimethoxy-4-ethylphenethylamine': '[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '3,5-dimethoxy-4-ethoxyamphetamine': '[#6]-[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#8]-[#6]',
            '2,5-dimethoxy-4-fluorophenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#9])-[#6]-[#6]-[#7]',
            '2,5-dimethoxy-3,4-dimethylphenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6](:[#6]:1-[#6])-[#6])-[#6]-[#6]-[#7]',
            '2,5-dimethoxy-3,4-(trimethylene)phenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]2:[#6]:1-[#6]-[#6]-[#6]-2)-[#6]-[#6]-[#7]',
            '2,5-dimethoxy-3,4-(tetramethylene)phenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]2:[#6]:1-[#6]-[#6]-[#6]-[#6]-2)-[#6]-[#6]-[#7]',
            '3,6-dimethoxy-4-(2-aminoethyl)benzonorbornane': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]2:[#6]:1-[#6]1-[#6]-[#6]-[#6]-2-[#6]-1)-[#6]-[#6]-[#7]',
            '1,4-dimethoxynaphthyl-2-ethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6]-[#7]',
            '2,5-dimethoxyphenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1)-[#6]-[#6]-[#7]',
            '2,5-dimethoxy-4-iodophenethylamine': '[#6H3:20]-[#8:13]-[#6:6]1:[#6H:5]:[#6:4](:[#6:3](-[#8:16]-[#6H3:11]):[#6H:2]:[#6:1]:1-[#53:12])-[#6H2:8]-[#6H2:9]-[#7H2:10]',
            '2,5-dimethoxy-4-nitrophenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#7+](-[#8-])=[#8]',
            '2,5-dimethoxy-4-(i)-propoxyphenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#8]-[#6](-[#6])-[#6]',
            '2,5-dimethoxy-4-(n)-propylphenethylamine': '[#6]-[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            'cyclopropylmescaline': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#8]-[#6]-[#6]1-[#6]-[#6]-1',
            '2,5-dimethoxy-4-methylseleneophenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[Se]-[#6]',
            '2,5-dimethoxy-4-methylthiophenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#16]-[#6]',
            '2,5-dimethoxy-4-ethylthiophenethylamine': '[#6H3:30]-[#6H2:29]-[#16:12]-[#6:1]1:[#6H:2]:[#6:3](:[#6:4](-[#6H2:8]-[#6H2:9]-[#7H2:10]):[#6H:5]:[#6:6]:1-[#8:13]-[#6H3:20])-[#8:16]-[#6H3:11]',
            '2,5-dimethoxy-4-(i)-propylthiophenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#16]-[#6](-[#6])-[#6]',
            '2,6-dimethoxy-4-(i)-propylthiophenethylamine)': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6](:[#6]:[#6](:[#6]:1)-[#16]-[#6](-[#6])-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-4-(n)-propylthiophenethylamine': '[#6H3:33]-[#6H2:30]-[#6H2:29]-[#16:12]-[#6:1]1:[#6H:2]:[#6:3](:[#6:4](-[#6H2:8]-[#6H2:9]-[#7H2:10]):[#6H:5]:[#6:6]:1-[#8:13]-[#6H3:20])-[#8:16]-[#6H3:11]',
            '2,5-dimethoxy-4-cyclopropylmethylthiophenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#16]-[#6]-[#6]1-[#6]-[#6]-1',
            '2,5-dimethoxy-4-(t)-butylthiophenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#16]-[#6](-[#6])(-[#6])-[#6]',
            '2,5-dimethoxy-4-(2-methoxyethylthio)phenethylamine': '[#6]-[#8]-[#6]-[#6]-[#16]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-4-cyclopropylthiophenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#16]-[#6]1-[#6]-[#6]-1',
            '2,5-dimethoxy-4-(s)-butylthiophenethylamine': '[#6]-[#6]-[#6](-[#6])-[#16]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-4-(2-fluoroethylthio)phenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#16]-[#6]-[#6]-[#9]',
            '3,5-dimethoxy-4-trideuteromethoxy-phenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '3,4,5-trimethoxy-beta,beta-dideuterophenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '3,5-dimethoxy-4-methylphenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '2,4-dimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#6]-[#6](-[#6])-[#7]):[#6](:[#6]:1)-[#8]-[#6]',
            '2,5-dimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7]',
            '3,4-dimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#8]-[#6]',
            '2-(2,5-dimethoxy-4-methylphenyl)cyclopropylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#6])-[#6]1-[#6]-[#6]-1-[#7]',
            '3,4-dimethoxy-beta-hydroxyphenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1-[#8]-[#6])-[#6](-[#8])-[#6]-[#7]',
            '2,5-dimethoxy-3,4-methylenedioxyamphetamine': '[#6]-[#8]-[#6]1:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7]',
            '2,3-dimethoxy-4,5-methylenedioxyamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1-[#8]-[#6]',
            '3,4-dimethoxyphenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6]',
            '2,5-dimethoxy-4-(n)-amylamphetamine': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-4-bromoamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#35])-[#6]-[#6](-[#6])-[#7]',
            '2,5-dimethoxy-4-(n)-butylamphetamine': '[#6]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-4-chloroamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#17])-[#6]-[#6](-[#6])-[#7]',
            '2,5-dimethoxy-4-(2-fluoroethyl)-amphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#6]-[#6]-[#9])-[#6]-[#6](-[#6])-[#7]',
            '2,5-dimethoxy-4-ethylamphetamine': '[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-4-iodoamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#53])-[#6]-[#6](-[#6])-[#7]',
            '2,5-dimethoxy-4-methylamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#6])-[#6]-[#6](-[#6])-[#7]',
            '2,6-dimethoxy-4-methylamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6](:[#6]:[#6](:[#6]:1)-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-4-nitroamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#7+](-[#8-])=[#8]',
            '2,5-dimethoxy-4-(n)-propylamphetamine': '[#6]-[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '3,5-dimethoxy-4-ethoxyphenethylamine': '[#6]-[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6]',
            '2,4,5-triethoxyamphetamine': '[#6]-[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6](-[#8]-[#6]-[#6]):[#6](:[#6]:1)-[#8]-[#6]-[#6]',
            '2,4-diethoxy-5-methoxyamphetamine': '[#6]-[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#8]-[#6]-[#6]',
            '2,5-diethoxy-4-methoxyamphetamine': '[#6]-[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]-[#6]):[#6](:[#6]:1)-[#8]-[#6]',
            '4,5-dimethoxy-2-ethoxyamphetamine': '[#6]-[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#8]-[#6]',
            '2-ethylamino-1-(3,4-methylenedioxyphenyl)butane': '[#6]-[#6]-[#6](-[#7])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '2-ethylamino-1-(3,4-methylenedioxyphenyl)pentane': '[#6]-[#6]-[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7]-[#6]-[#6]',
            '6-(2-aminopropyl)-5-methoxy-2-methyl-2,3-dihydrobenzofuran': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]2-[#8]-[#6](-[#6])-[#6]-[#6]:2:[#6]:1',
            '6-(2-aminopropyl)-2,2-dimethyl-5-methoxy-2,3-dihydrobenzofuran': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]2-[#8]-[#6](-[#6])(-[#6])-[#6]-[#6]:2:[#6]:1',
            'n-hydroxy-n-methyl-3,4-methylenedioxyamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7](-[#6])-[#8]',
            '2,5-dimethoxy-3,4-(trimethylene)amphetamine': '[#6]-[#8]-[#6]1:[#6]2-[#6]-[#6]-[#6]-[#6]:2:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7]',
            '2,5-dimethoxy-3,4-(tetramethylene)amphetamine': '[#6]-[#8]-[#6]1:[#6]2-[#6]-[#6]-[#6]-[#6]-[#6]:2:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7]',
            '3,6-dimethoxy-4-(2-aminopropyl)benzonorbornane': '[#6]-[#8]-[#6]1:[#6]2-[#6]3-[#6]-[#6]-[#6](-[#6]-3)-[#6]:2:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7]',
            '2,5-dimethoxy-3,4-dimethylamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6](:[#6]:1-[#6])-[#6])-[#6]-[#6](-[#6])-[#7]',
            '1,4-dimethoxynaphthyl-2-isopropylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)-[#6]-[#6](-[#6])-[#7]',
            '2,5-dimethoxy-4-ethylthio-n-hydroxyphenethylamine': '',
            '2,5-dimethoxy-n-hydroxy-4-(n)-propylthiophenethylamine': '[#6]-[#6]-[#6]-[#16]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6]-[#7]-[#8]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-4-(s)-butylthio-n-hydroxyphenethylamine': '[#6]-[#6]-[#6](-[#6])-[#16]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6]-[#7]-[#8]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '2,5-dimethoxy-n,n-dimethyl-4-iodoamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#53])-[#6]-[#6](-[#6])-[#7](-[#6])-[#6]',
            'isomescaline': '[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6](:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1)-[#8]-[#6]',
            'isoproscaline': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6](-[#6])-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '5-ethoxy-2-methoxy-4-methylamphetamine': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#6])-[#6]-[#6](-[#6])-[#7]',
            '2-amino-1-(3,4-methylenedioxyphenyl)butane': '[#6]-[#6]-[#6](-[#7])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3-methoxy-4,5-methylenedioxyphenethylamine': '[#6]-[#8]-[#6]1:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:[#6](:[#6]:1)-[#6]-[#6]-[#7]',
            'mescaline': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '4-methoxyamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#7]',
            '2,n-dimethyl-4,5-methylenedioxyamphetamine': '[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6](-[#6]):[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            'methallylescaline': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6]-[#6](-[#6])=[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '3,4-methylenedioxyamphetamine': '[#6]-[#6](-[#7])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3,4-methylenedioxy-n- allylamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7]-[#6]-[#6]=[#6]',
            '3,4-methylenedioxy-n-butylamphetamine': '[#6]-[#6]-[#6]-[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3,4-methylenedioxy-n-benzylamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '3,4-methylenedioxy-ncyclopropylmethylamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7]-[#6]-[#6]1-[#6]-[#6]-1',
            '3,4-methylenedioxy-n,n-dimethylamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7](-[#6])-[#6]',
            '3,4-methylenedioxy-n-ethylamphetamine': '[#6]-[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3,4-methylenedioxy-n-(2-hydroxyethyl)amphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7]-[#6]-[#6]-[#8]',
            '(3,4-methylenedioxy-n-isopropylamphetamine)': '[#6]-[#6](-[#6])-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3,4-methylenedioxy-n-methylamphetamine': '[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3,4-ethylenedioxy-n-methylamphetamine': '[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3,4-methylenedioxy-n-methyoxyamphetamine': '[#6]-[#8]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3,4-methylenedioxy-n-(2-methoxyethyl)amphetamine': '[#6]-[#8]-[#6]-[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            'a,a,n-trimethyl-3,4-methylenedioxy-phenethylamine': '[#6]-[#7]-[#6](-[#6])(-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3,4-methylenedioxy-n-hydroxyamphetamine': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7]-[#8]',
            '3,4-methylenedioxyphenethylamine': '[#7]-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            'a,a-dimethyl-3,4-methylenedioxy-phenethylamine': '[#6]-[#6](-[#6])(-[#7])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3,4-methylenedioxy-npropargylamphetamine)': '[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7]-[#6]-[#6]#[#6]',
            '3,4-methylenedioxy-n-propylamphetamine': '[#6]-[#6]-[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            'metaescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '3-methoxy-4,5-ethylenedioxyamphetamine': '[#6]-[#8]-[#6]1:[#6]2-[#8]-[#6]-[#6]-[#8]-[#6]:2:[#6]:[#6](:[#6]:1)-[#6]-[#6]-[#7]',
            '4,5-diethoxy-2-methoxyamphetamine': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#8]-[#6]-[#6])-[#6]-[#6](-[#6])-[#7]',
            '2,5-dimethoxy-4-ethoxyamphetamine': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#8]-[#6]',
            '3-methoxy-4-ethoxyphenethylamine': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6]',
            '5-bromo-2,4-dimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#35])-[#8]-[#6]',
            '2,4-dimethoxy-5-methylthioamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6](-[#16]-[#6]):[#6](:[#6]:1)-[#8]-[#6]',
            '2,5-dimethoxy-n-methylamphetamine': '[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6]:[#6](:[#6]:1)-[#8]-[#6]',
            '4-bromo-2,5-dimethoxy-n-methylamphetamine': '[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#35]):[#6](:[#6]:1)-[#8]-[#6]',
            '2-methylamino-1-(3,4-methylenedioxyphenyl)butane': '[#6]-[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7]-[#6]',
            '2-methylamino-1-(3,4-methylenedioxyphenyl)pentane': '[#6]-[#6]-[#6]-[#6](-[#6]-[#6]1:[#6]:[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1)-[#7]-[#6]',
            '4-methoxy-n-methylamphetamine': '[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6]:[#6]:1',
            '2-methoxy-n-methyl-4,5-methylenedioxyamphetamine': '[#6]-[#7]-[#6](-[#6])-[#6]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '3-methoxy-4,5-methylenedioxyamphetamine': '[#6]-[#8]-[#6]1:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7]',
            '2-methoxy-4,5-methylenedioxyamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:1',
            '2-methoxy-3,4-methylenedioxyamphetamine': '[#6]-[#8]-[#6]1:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:[#6]:[#6]:1-[#6]-[#6](-[#6])-[#7]',
            '4-methoxy-2,3-methylenedioxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]2:[#6]:1-[#8]-[#6]-[#8]-2',
            '2,4-dimethoxy-5-ethoxyamphetamine': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6]:[#6]:1-[#8]-[#6])-[#6]-[#6](-[#6])-[#7]',
            'metaproscaline': '[#6]-[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '2,5-dimethoxy-4-(n)-propoxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:[#6]:1-[#8]-[#6]-[#6]-[#6])-[#6]-[#6](-[#6])-[#7]',
            '4,5-dimethoxy-2-methylthioamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#16]-[#6]):[#6]:[#6]:1-[#8]-[#6])-[#6]-[#6](-[#6])-[#7]',
            'proscaline': '[#6]-[#6]-[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6]',
            'phenescaline': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6]-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#8]-[#6])-[#6]-[#6]-[#7]',
            'phenethylamine': '[#7]-[#6]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            '3,5-dimethoxy-4-(2-propynyloxy)phenethylamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6]-[#6]=[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            'symbescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6]-[#6])-[#6]-[#6]-[#7]',
            '2,3,4,5-tetramethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6](:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#6]-[#6](-[#6])-[#7])-[#8]-[#6]',
            '3-thioasymbescaline': '[#6H3:16]-[#6H2:15]-[#8:14]-[#6:8]1:[#6:1](-[#16:10]-[#6H2:11]-[#6H3:17]):[#6H:2]:[#6:3](-[#6H2:5]-[#6H2:6]-[#7H2:7]):[#6H:4]:[#6:9]:1-[#8:12]-[#6H3:13]',
            '4-thioasymbescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#16]-[#6]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '5-thioasymbescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6]-[#6])-[#16]-[#6])-[#6]-[#6]-[#7]',
            '4-thiobuscaline': '[#6]-[#6]-[#6]-[#6]-[#16]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6]',
            '3-thioescaline': '[#6]-[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#16]-[#6]',
            '4-thioescaline': '[#6H3:16]-[#6H2:11]-[#16:10]-[#6:8]1:[#6:1](-[#8:12]-[#6H3:13]):[#6H:2]:[#6:3](-[#6H2:5]-[#6H2:6]-[#7H2:7]):[#6H:4]:[#6:9]:1-[#8:14]-[#6H3:15]',
            '2-thioisomescaline': '[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6](:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1)-[#16]-[#6]',
            '3-thiomescaline': '[#6]-[#8]-[#6]1:[#6](-[#16]-[#6]):[#6](:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1)-[#8]-[#6]',
            '4-thioisomescaline': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#16]-[#6]',
            '2-thiomescaline': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#16]-[#6])-[#6]-[#6]-[#7]',
            '4-thiomescaline': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#16]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '3,4,5-trimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6])-[#6]-[#6](-[#6])-[#7]',
            '2,4,5-trimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#8]-[#6]',
            '2,3,4-trimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1)-[#8]-[#6]',
            '2,3,5-trimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#8]-[#6])-[#6]-[#6](-[#6])-[#7]',
            '2,3,6-trimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1-[#6]-[#6](-[#6])-[#7])-[#8]-[#6]',
            '2,4,6-trimethoxyamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6](:[#6]:1)-[#8]-[#6])-[#8]-[#6]',
            '3-thiometaescaline': '[#6]-[#6]-[#16]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '4-thiometaescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#16]-[#6])-[#8]-[#6])-[#6]-[#6]-[#7]',
            '5-thiometaescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6])-[#16]-[#6])-[#6]-[#6]-[#7]',
            '3,4-methylenedioxy-2-methylthioamphetamine': '[#6]-[#16]-[#6]1:[#6]2-[#8]-[#6]-[#8]-[#6]:2:[#6]:[#6]:[#6]:1-[#6]-[#6](-[#6])-[#7]',
            '6-(2-aminopropyl)-5-methoxy-1,3-benzoxathiol': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]2-[#8]-[#6]-[#16]-[#6]:2:[#6]:1',
            '2,4,5-trimethoxyphenethylamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6]-[#7]):[#6]:[#6](-[#8]-[#6]):[#6](:[#6]:1)-[#8]-[#6]',
            '4-ethyl-5-methoxy-2-methylthioamphetamine': '[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#8]-[#6])-[#16]-[#6]',
            '4-ethyl-2-methoxy-5-methylthioamphetamine': '[#6]-[#6]-[#6]1:[#6]:[#6](:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6]:1-[#16]-[#6])-[#8]-[#6]',
            '5-methoxy-4-methyl-2-methylthioamphetamine': '[#6]-[#8]-[#6]1:[#6]:[#6](:[#6](-[#16]-[#6]):[#6]:[#6]:1-[#6])-[#6]-[#6](-[#6])-[#7]',
            '2-methoxy-4-methyl-5-methylthioamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6](-[#16]-[#6]):[#6](:[#6]:1)-[#6]',
            '2-methoxy-4-methyl-5-methylsulfinylamphetamine': '[#6]-[#8]-[#6]1:[#6](-[#6]-[#6](-[#6])-[#7]):[#6]:[#6](:[#6](:[#6]:1)-[#6])-[#16](-[#6])=[#8]',
            'thioproscaline': '[#6]-[#6]-[#6]-[#16]-[#6]1:[#6](-[#8]-[#6]):[#6]:[#6](-[#6]-[#6]-[#7]):[#6]:[#6]:1-[#8]-[#6]',
            'trescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#8]-[#6]-[#6])-[#8]-[#6]-[#6])-[#6]-[#6]-[#7]',
            '3-thiosymbescaline': '[#6]-[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]):[#6](:[#6]:[#6](:[#6]:1)-[#6]-[#6]-[#7])-[#16]-[#6]-[#6]',
            '4-thiosymbescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#16]-[#6])-[#8]-[#6]-[#6])-[#6]-[#6]-[#7]',
            '3-thiotrescaline': '[#6]-[#6]-[#8]-[#6]1:[#6](-[#8]-[#6]-[#6]):[#6](:[#6]:[#6](:[#6]:1)-[#6]-[#6]-[#7])-[#16]-[#6]-[#6]',
            '4-thiotrescaline': '[#6]-[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#16]-[#6]-[#6])-[#8]-[#6]-[#6])-[#6]-[#6]-[#7]',
        }

        return smarts
