"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3EventSource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const notifs = require("@aws-cdk/aws-s3-notifications");
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 */
class S3EventSource {
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_event_sources_S3EventSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
_a = JSII_RTTI_SYMBOL_1;
S3EventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.S3EventSource", version: "1.156.1" };
//# sourceMappingURL=data:application/json;base64,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