# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['qary',
 'qary.actions',
 'qary.data',
 'qary.data.constants',
 'qary.etl',
 'qary.orm',
 'qary.plugins',
 'qary.qa',
 'qary.scores',
 'qary.skills',
 'qary.wip']

package_data = \
{'': ['*'],
 'qary.data': ['book_smarts/*',
               'corpora/*',
               'corpora/rss_feeds/*',
               'corpora/web_pages/*',
               'corpora/wikipedia/README.md',
               'corpora/wikipedia/README.md',
               'corpora/wikipedia/george_floyd_karma.yml',
               'corpora/wikipedia/george_floyd_karma.yml',
               'factquest/*',
               'faq/*',
               'life_coach/*',
               'life_coach/moderating/*',
               'log/*',
               'models/qa/*',
               'parul/*',
               'quizbot/*',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/dialog/*',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'training_sets/*',
               'tutor-bot/*',
               'unittests/*',
               'wikipedia/*',
               'writing/*',
               'yes_no/*'],
 'qary.skills': ['writing/*']}

install_requires = \
['ConfigArgParse==1.2.2',
 'Sphinx==3.0.3',
 'beautifulsoup4>=4.9.3,<5.0.0',
 'boto3==1.13.19',
 'botocore==1.16.19',
 'django==3.0.7',
 'docutils==0.15.2',
 'edit-distance==1.0.4',
 'elasticsearch>=7.6.0,<8.0.0',
 'environment==1.0.0',
 'gitpython==3.1.1',
 'html5lib==1.1',
 'jedi>=0.18.0,<0.19.0',
 'jupyter==1.0.0',
 'lxml==4.5.0',
 'm2r==0.2.1',
 'nltk==3.5',
 'pandas==1.0.3',
 'pre_commit==2.3.0',
 'pronouncing==0.2.0',
 'psutil==5.8.0',
 'pytest-cov==2.11.1',
 'pytest==6.2.2',
 'python-dotenv>=0.13.0,<0.14.0',
 'python-slugify==4.0.0',
 'rapidfuzz==0.9.1',
 'recommonmark==0.6.0',
 'regex==2020.4.4',
 'rich>=9.8.2,<10.0.0',
 'scikit-image>=0.17.2,<0.18.0',
 'scikit-learn==0.22.2',
 'scipy==1.4.1',
 'seaborn==0.10.0',
 'spacy>=3.0.0,<3.1.0',
 'torch>=1.8.0,<1.9.0',
 'tox>=3.23.0,<4.0.0',
 'tqdm>=4.38.0,<4.39.0',
 'transformers>=4.3.0,<4.4.0',
 'typer[all]>=0.3.2,<0.4.0',
 'wikipedia-api==0.5.4',
 'yake==0.4.6']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=1.6.0,<2.0.0']}

entry_points = \
{'console_scripts': ['qary = qary.__main__:app']}

setup_kwargs = {
    'name': 'qary',
    'version': '0.6.23',
    'description': 'A chatbot that assists rather than manipulates.',
    'long_description': '[![Buy Us Tea](https://github.com/nlpia/nlpia-bot/raw/develop/docs/media/small-leaf-and-name-screenshot-31x80.png)](https://buymeacoffee.com/hobs)\n[![PyPI version](https://img.shields.io/pypi/pyversions/qary.svg)](https://pypi.org/project/qary/)\n[![License](https://img.shields.io/pypi/l/qary.svg)](https://pypi.python.org/pypi/qary/)\n[![codecov](https://codecov.io/gl/tangibleai/qary/branch/master/graph/badge.svg)](https://codecov.io/gl/tangibleai/qary)\n\n# `qary`\n\nThe `qary` package is both a chatbot framework and a working "reference implementation" virtual assistant that actually assists! Most bots manipulate you to make money for their corporate masters. With qary, you can build **your** bot to protect you and amplify your intelligence and prosocial instincts.\n\n`qary` was conceived as part of [NLP in Action](https://www.manning.com/books/natural-language-processing-in-action) book, is maintained by an [active developer community](/docs/wiki/contributors.md) and is supported by [San Diego Python User Group](https://www.pythonsd.org/index.html) (some qary talks [here](https://www.youtube.com/playlist?list=PLOa5qP-zwt22Noym1Nf8BeL24NeE__ofj) and in `docs/`) and [San Diego Machine Learning Group](https://www.meetup.com/San-Diego-Machine-Learning/).\n\n\n## Install\n\n### Package install\n`qary` package can be installed from [PyPi](https://pypi.org/project/qary/) by running:\n\n```bash\npip install qary\n```\n\n### Developer install\n\nFirst retrieve a copy of the source code for `qary`:\n\n```bash\ngit clone git@gitlab.com:tangibleai/qary\ncd qary\n```\n\nThen, install and use the `conda` python package manager within the [Anaconda](https://www.anaconda.com/products/individual#Downloads) software package.\n\n```bash\nconda update -y -n base -c defaults conda\nconda create -y -n qaryenv \'python>=3.6.5,<3.9\'\nconda env update -n qaryenv -f environment.yml\nconda activate qaryenv || source activate qaryenv\npip install --editable .\n```\n\n**Windows Users**: [docs/README-windows-install.md](docs/README-windows-install.md)\n\n## Usage\n\n```bash\n$ qary --help\nusage: qary [-h] [--version] [--name STR] [-p] [-s STR] [-v] [-vv] [words [words ...]]\n```\n\n### Running `qary` for just one skill\n\n```bash\n$ qary -s qa\n# ... (logging messages)\nYOU: When was Barack Obama born?\n# ... (logging messages)\nqary: August 4, 1961\n```\n\n### `qary` skills\n\n`qary`\'s probabilistic conversation manager chooses a reply from the possiblities generated by the different personalities:\n\n- `pattern` (`skills/pattern.py`): example skill using regex patterns to reply to greetings like "hi"\n- `qa` (`skills/qa.py`): BERT and ALBERT Wikipedia Question Answering (WikiQA reading comprehension tests)\n- `faq` (`skills/faq.py`): answers to frequently asked questions using data/faq/*.yml\n- `glossary` (`skills/glossary.py`): definitions from glossary yml files in data/faq/glossary-*.yml\n- `eliza` (`eliza.py`): a python port of the ELIZA therapist bot\n\n### Configuring default personalities\n\nBy default, `qary` runs with `qa` personality. Check out the config file in `qary.ini` to change the default skills loaded for your own custom skill in the skills directory.\n\n## Approach\n\n`qary`\'s chatbot framework allows you to combine many approaches to give you state-of-the-art capability to answer questions and carry on a conversation:\n\n1. search: [chatterbot](https://github.com/gunthercox/ChatterBot), [will](https://github.com/skoczen/will)\n2. pattern matching and response templates: Alexa, [AIML](https://github.com/keiffster/program-y)\n3. generative deep learning: [robot-bernie](https://github.com/nlpia/robot-bernie), [movie-bot](https://github.com/totalgood/nlpia/blob/master/src/nlpia/book/examples/ch10_movie_dialog_chatbot.py)\n4. grounding: [snips](https://github.com/snipsco/snips-nlu)\n\nIt\'s all explained in detail at [NLP in Action](https://www.manning.com/books/natural-language-processing-in-action).\n\nPresentations for San Diego Python User Group are in [docs/](/docs/2019-08-22--San Diego Python User Group -- How to Build a Chatbot.odp) and on the web at [http://totalgood.org/midata/talks](http://totalgood.org/midata/talks/)\n\n## Contributing pattern for developers\n\nDM @hobs if you\'d like to join us for weekly Zoom collaborative-coding sessions.\n\n1. [Create a fork](https://docs.gitlab.com/ee/user/project/repository/forking_workflow.html#creating-a-fork) of the [main qary repository](https://gitlab.com/tangibleai/qary) on Gitlab.\n2. Make your changes in a branch named something different from `master`, e.g. create\n   a new branch `my-pull-request`.\n3. [Create a merge request](https://docs.gitlab.com/ee/user/project/merge_requests/creating_merge_requests.html).\n4. Help your fellow contributors out by:\n  - Follow the [PEP-8 style guide](https://www.python.org/dev/peps/pep-0008/).\n  - Try to include a docstring, at least a single line, in any function, method, or class\n  - Bonus points for adding a [doctest](https://docs.python.org/3/library/doctest.html) as part of your contribution.\n  - If you add a new feature, write some quick docs in the README.\n  - Add your name and attribution to the AUTHORS file.\n  - Know we are grateful for your contribution! You\'ve made the chatbot world a little better!\n\n',
    'author': 'ProAI',
    'author_email': 'hobson@proai.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/qary/qary',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<3.9',
}


setup(**setup_kwargs)
