# mypy-boto3-networkmanager

[![PyPI - mypy-boto3-networkmanager](https://img.shields.io/pypi/v/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.NetworkManager 1.14.55](https://boto3.amazonaws.com/v1/documentation/api/1.14.55/reference/services/networkmanager.html#NetworkManager) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-networkmanager](#mypy-boto3-networkmanager)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `NetworkManager` service.

```bash
python -m pip install boto3-stubs[networkmanager]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[networkmanager]` in your environment: `python -m pip install 'boto3-stubs[networkmanager]'`

Both type checking and auto-complete should work for `NetworkManager` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[networkmanager]` in your environment: `python -m pip install 'boto3-stubs[networkmanager]'`

Both type checking and auto-complete should work for `NetworkManager` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[networkmanager]` in your environment: `python -m pip install 'boto3-stubs[networkmanager]'`
- Run `mypy` as usual

Type checking should work for `NetworkManager` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[networkmanager]` in your environment: `python -m pip install 'boto3-stubs[networkmanager]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `NetworkManager` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`NetworkManagerClient` provides annotations for `boto3.client("networkmanager")`.

```python
import boto3

from mypy_boto3_networkmanager import NetworkManagerClient

client: NetworkManagerClient = boto3.client("networkmanager")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: NetworkManagerClient = session.client("networkmanager")
```

### Paginators annotations

`mypy_boto3_networkmanager.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_networkmanager import NetworkManagerClient
from mypy_boto3_networkmanager.paginator import (
    DescribeGlobalNetworksPaginator,
    GetCustomerGatewayAssociationsPaginator,
    GetDevicesPaginator,
    GetLinkAssociationsPaginator,
    GetLinksPaginator,
    GetSitesPaginator,
    GetTransitGatewayRegistrationsPaginator,
)

client: NetworkManagerClient = boto3.client("networkmanager")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_global_networks_paginator: DescribeGlobalNetworksPaginator = client.get_paginator("describe_global_networks")
get_customer_gateway_associations_paginator: GetCustomerGatewayAssociationsPaginator = client.get_paginator("get_customer_gateway_associations")
get_devices_paginator: GetDevicesPaginator = client.get_paginator("get_devices")
get_link_associations_paginator: GetLinkAssociationsPaginator = client.get_paginator("get_link_associations")
get_links_paginator: GetLinksPaginator = client.get_paginator("get_links")
get_sites_paginator: GetSitesPaginator = client.get_paginator("get_sites")
get_transit_gateway_registrations_paginator: GetTransitGatewayRegistrationsPaginator = client.get_paginator("get_transit_gateway_registrations")
```







### Typed dictionations

`mypy_boto3_networkmanager.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_networkmanager.type_defs import (
    AssociateCustomerGatewayResponseTypeDef,
    AssociateLinkResponseTypeDef,
    BandwidthTypeDef,
    CreateDeviceResponseTypeDef,
    CreateGlobalNetworkResponseTypeDef,
    CreateLinkResponseTypeDef,
    CreateSiteResponseTypeDef,
    CustomerGatewayAssociationTypeDef,
    DeleteDeviceResponseTypeDef,
    DeleteGlobalNetworkResponseTypeDef,
    DeleteLinkResponseTypeDef,
    DeleteSiteResponseTypeDef,
    DeregisterTransitGatewayResponseTypeDef,
    DescribeGlobalNetworksResponseTypeDef,
    DeviceTypeDef,
    DisassociateCustomerGatewayResponseTypeDef,
    DisassociateLinkResponseTypeDef,
    GetCustomerGatewayAssociationsResponseTypeDef,
    GetDevicesResponseTypeDef,
    GetLinkAssociationsResponseTypeDef,
    GetLinksResponseTypeDef,
    GetSitesResponseTypeDef,
    GetTransitGatewayRegistrationsResponseTypeDef,
    GlobalNetworkTypeDef,
    LinkAssociationTypeDef,
    LinkTypeDef,
    ListTagsForResourceResponseTypeDef,
    LocationTypeDef,
    PaginatorConfigTypeDef,
    RegisterTransitGatewayResponseTypeDef,
    SiteTypeDef,
    TagTypeDef,
    TransitGatewayRegistrationStateReasonTypeDef,
    TransitGatewayRegistrationTypeDef,
    UpdateDeviceResponseTypeDef,
    UpdateGlobalNetworkResponseTypeDef,
    UpdateLinkResponseTypeDef,
    UpdateSiteResponseTypeDef,
)

def get_structure() -> BandwidthTypeDef:
    return {
      ...
    }
```
