import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdSecretBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * Use anonymous binds when performing LDAP group searches (if true the initial credentials will still be used for the initial connection test).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#anonymous_group_search AdSecretBackend#anonymous_group_search}
    */
    readonly anonymousGroupSearch?: boolean | cdktf.IResolvable;
    /**
    * The mount path for a backend, for example, the path given in "$ vault auth enable -path=my-ad ad".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#backend AdSecretBackend#backend}
    */
    readonly backend?: string;
    /**
    * Distinguished name of object to bind when performing user and group search.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#binddn AdSecretBackend#binddn}
    */
    readonly binddn: string;
    /**
    * LDAP password for searching for the user DN.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#bindpass AdSecretBackend#bindpass}
    */
    readonly bindpass: string;
    /**
    * If true, case sensitivity will be used when comparing usernames and groups for matching policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#case_sensitive_names AdSecretBackend#case_sensitive_names}
    */
    readonly caseSensitiveNames?: boolean | cdktf.IResolvable;
    /**
    * CA certificate to use when verifying LDAP server certificate, must be x509 PEM encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#certificate AdSecretBackend#certificate}
    */
    readonly certificate?: string;
    /**
    * Client certificate to provide to the LDAP server, must be x509 PEM encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#client_tls_cert AdSecretBackend#client_tls_cert}
    */
    readonly clientTlsCert?: string;
    /**
    * Client certificate key to provide to the LDAP server, must be x509 PEM encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#client_tls_key AdSecretBackend#client_tls_key}
    */
    readonly clientTlsKey?: string;
    /**
    * Default lease duration for secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#default_lease_ttl_seconds AdSecretBackend#default_lease_ttl_seconds}
    */
    readonly defaultLeaseTtlSeconds?: number;
    /**
    * Denies an unauthenticated LDAP bind request if the user's password is empty; defaults to true
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#deny_null_bind AdSecretBackend#deny_null_bind}
    */
    readonly denyNullBind?: boolean | cdktf.IResolvable;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#description AdSecretBackend#description}
    */
    readonly description?: string;
    /**
    * If set, opts out of mount migration on path updates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#disable_remount AdSecretBackend#disable_remount}
    */
    readonly disableRemount?: boolean | cdktf.IResolvable;
    /**
    * Use anonymous bind to discover the bind DN of a user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#discoverdn AdSecretBackend#discoverdn}
    */
    readonly discoverdn?: boolean | cdktf.IResolvable;
    /**
    * Text to insert the password into, ex. "customPrefix{{PASSWORD}}customSuffix".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#formatter AdSecretBackend#formatter}
    */
    readonly formatter?: string;
    /**
    * LDAP attribute to follow on objects returned by <groupfilter> in order to enumerate user group membership. Examples: "cn" or "memberOf", etc. Default: cn
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#groupattr AdSecretBackend#groupattr}
    */
    readonly groupattr?: string;
    /**
    * LDAP search base to use for group membership search (eg: ou=Groups,dc=example,dc=org)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#groupdn AdSecretBackend#groupdn}
    */
    readonly groupdn?: string;
    /**
    * Go template for querying group membership of user. The template can access the following context variables: UserDN, Username Example: (&(objectClass=group)(member:1.2.840.113556.1.4.1941:={{.UserDN}})) Default: (|(memberUid={{.Username}})(member={{.UserDN}})(uniqueMember={{.UserDN}}))
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#groupfilter AdSecretBackend#groupfilter}
    */
    readonly groupfilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#id AdSecretBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Skip LDAP server SSL Certificate verification - insecure and not recommended for production use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#insecure_tls AdSecretBackend#insecure_tls}
    */
    readonly insecureTls?: boolean | cdktf.IResolvable;
    /**
    * The number of seconds after a Vault rotation where, if Active Directory shows a later rotation, it should be considered out-of-band.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#last_rotation_tolerance AdSecretBackend#last_rotation_tolerance}
    */
    readonly lastRotationTolerance?: number;
    /**
    * The desired length of passwords that Vault generates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#length AdSecretBackend#length}
    */
    readonly length?: number;
    /**
    * Mark the secrets engine as local-only. Local engines are not replicated or removed by replication.Tolerance duration to use when checking the last rotation time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#local AdSecretBackend#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Maximum possible lease duration for secrets in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#max_lease_ttl_seconds AdSecretBackend#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * In seconds, the maximum password time-to-live.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#max_ttl AdSecretBackend#max_ttl}
    */
    readonly maxTtl?: number;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#namespace AdSecretBackend#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the password policy to use to generate passwords.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#password_policy AdSecretBackend#password_policy}
    */
    readonly passwordPolicy?: string;
    /**
    * Timeout, in seconds, for the connection when making requests against the server before returning back an error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#request_timeout AdSecretBackend#request_timeout}
    */
    readonly requestTimeout?: number;
    /**
    * Issue a StartTLS command after establishing unencrypted connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#starttls AdSecretBackend#starttls}
    */
    readonly starttls?: boolean | cdktf.IResolvable;
    /**
    * Maximum TLS version to use. Accepted values are 'tls10', 'tls11', 'tls12' or 'tls13'. Defaults to 'tls12'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#tls_max_version AdSecretBackend#tls_max_version}
    */
    readonly tlsMaxVersion?: string;
    /**
    * Minimum TLS version to use. Accepted values are 'tls10', 'tls11', 'tls12' or 'tls13'. Defaults to 'tls12'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#tls_min_version AdSecretBackend#tls_min_version}
    */
    readonly tlsMinVersion?: string;
    /**
    * In seconds, the default password time-to-live.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#ttl AdSecretBackend#ttl}
    */
    readonly ttl?: number;
    /**
    * Enables userPrincipalDomain login with [username]@UPNDomain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#upndomain AdSecretBackend#upndomain}
    */
    readonly upndomain?: string;
    /**
    * LDAP URL to connect to (default: ldap://127.0.0.1). Multiple URLs can be specified by concatenating them with commas; they will be tried in-order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#url AdSecretBackend#url}
    */
    readonly url?: string;
    /**
    * In Vault 1.1.1 a fix for handling group CN values of different cases unfortunately introduced a regression that could cause previously defined groups to not be found due to a change in the resulting name. If set true, the pre-1.1.1 behavior for matching group CNs will be used. This is only needed in some upgrade scenarios for backwards compatibility. It is enabled by default if the config is upgraded but disabled by default on new configurations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#use_pre111_group_cn_behavior AdSecretBackend#use_pre111_group_cn_behavior}
    */
    readonly usePre111GroupCnBehavior?: boolean | cdktf.IResolvable;
    /**
    * If true, use the Active Directory tokenGroups constructed attribute of the user to find the group memberships. This will find all security groups including nested ones.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#use_token_groups AdSecretBackend#use_token_groups}
    */
    readonly useTokenGroups?: boolean | cdktf.IResolvable;
    /**
    * Attribute used for users (default: cn)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#userattr AdSecretBackend#userattr}
    */
    readonly userattr?: string;
    /**
    * LDAP domain to use for users (eg: ou=People,dc=example,dc=org)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend#userdn AdSecretBackend#userdn}
    */
    readonly userdn?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend vault_ad_secret_backend}
*/
export declare class AdSecretBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_ad_secret_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend vault_ad_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdSecretBackendConfig
    */
    constructor(scope: Construct, id: string, config: AdSecretBackendConfig);
    private _anonymousGroupSearch?;
    get anonymousGroupSearch(): boolean | cdktf.IResolvable;
    set anonymousGroupSearch(value: boolean | cdktf.IResolvable);
    resetAnonymousGroupSearch(): void;
    get anonymousGroupSearchInput(): boolean | cdktf.IResolvable | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _binddn?;
    get binddn(): string;
    set binddn(value: string);
    get binddnInput(): string | undefined;
    private _bindpass?;
    get bindpass(): string;
    set bindpass(value: string);
    get bindpassInput(): string | undefined;
    private _caseSensitiveNames?;
    get caseSensitiveNames(): boolean | cdktf.IResolvable;
    set caseSensitiveNames(value: boolean | cdktf.IResolvable);
    resetCaseSensitiveNames(): void;
    get caseSensitiveNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _clientTlsCert?;
    get clientTlsCert(): string;
    set clientTlsCert(value: string);
    resetClientTlsCert(): void;
    get clientTlsCertInput(): string | undefined;
    private _clientTlsKey?;
    get clientTlsKey(): string;
    set clientTlsKey(value: string);
    resetClientTlsKey(): void;
    get clientTlsKeyInput(): string | undefined;
    private _defaultLeaseTtlSeconds?;
    get defaultLeaseTtlSeconds(): number;
    set defaultLeaseTtlSeconds(value: number);
    resetDefaultLeaseTtlSeconds(): void;
    get defaultLeaseTtlSecondsInput(): number | undefined;
    private _denyNullBind?;
    get denyNullBind(): boolean | cdktf.IResolvable;
    set denyNullBind(value: boolean | cdktf.IResolvable);
    resetDenyNullBind(): void;
    get denyNullBindInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disableRemount?;
    get disableRemount(): boolean | cdktf.IResolvable;
    set disableRemount(value: boolean | cdktf.IResolvable);
    resetDisableRemount(): void;
    get disableRemountInput(): boolean | cdktf.IResolvable | undefined;
    private _discoverdn?;
    get discoverdn(): boolean | cdktf.IResolvable;
    set discoverdn(value: boolean | cdktf.IResolvable);
    resetDiscoverdn(): void;
    get discoverdnInput(): boolean | cdktf.IResolvable | undefined;
    private _formatter?;
    get formatter(): string;
    set formatter(value: string);
    resetFormatter(): void;
    get formatterInput(): string | undefined;
    private _groupattr?;
    get groupattr(): string;
    set groupattr(value: string);
    resetGroupattr(): void;
    get groupattrInput(): string | undefined;
    private _groupdn?;
    get groupdn(): string;
    set groupdn(value: string);
    resetGroupdn(): void;
    get groupdnInput(): string | undefined;
    private _groupfilter?;
    get groupfilter(): string;
    set groupfilter(value: string);
    resetGroupfilter(): void;
    get groupfilterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _insecureTls?;
    get insecureTls(): boolean | cdktf.IResolvable;
    set insecureTls(value: boolean | cdktf.IResolvable);
    resetInsecureTls(): void;
    get insecureTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _lastRotationTolerance?;
    get lastRotationTolerance(): number;
    set lastRotationTolerance(value: number);
    resetLastRotationTolerance(): void;
    get lastRotationToleranceInput(): number | undefined;
    private _length?;
    get length(): number;
    set length(value: number);
    resetLength(): void;
    get lengthInput(): number | undefined;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number;
    set maxLeaseTtlSeconds(value: number);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _maxTtl?;
    get maxTtl(): number;
    set maxTtl(value: number);
    resetMaxTtl(): void;
    get maxTtlInput(): number | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _passwordPolicy?;
    get passwordPolicy(): string;
    set passwordPolicy(value: string);
    resetPasswordPolicy(): void;
    get passwordPolicyInput(): string | undefined;
    private _requestTimeout?;
    get requestTimeout(): number;
    set requestTimeout(value: number);
    resetRequestTimeout(): void;
    get requestTimeoutInput(): number | undefined;
    private _starttls?;
    get starttls(): boolean | cdktf.IResolvable;
    set starttls(value: boolean | cdktf.IResolvable);
    resetStarttls(): void;
    get starttlsInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsMaxVersion?;
    get tlsMaxVersion(): string;
    set tlsMaxVersion(value: string);
    resetTlsMaxVersion(): void;
    get tlsMaxVersionInput(): string | undefined;
    private _tlsMinVersion?;
    get tlsMinVersion(): string;
    set tlsMinVersion(value: string);
    resetTlsMinVersion(): void;
    get tlsMinVersionInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _upndomain?;
    get upndomain(): string;
    set upndomain(value: string);
    resetUpndomain(): void;
    get upndomainInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _usePre111GroupCnBehavior?;
    get usePre111GroupCnBehavior(): boolean | cdktf.IResolvable;
    set usePre111GroupCnBehavior(value: boolean | cdktf.IResolvable);
    resetUsePre111GroupCnBehavior(): void;
    get usePre111GroupCnBehaviorInput(): boolean | cdktf.IResolvable | undefined;
    private _useTokenGroups?;
    get useTokenGroups(): boolean | cdktf.IResolvable;
    set useTokenGroups(value: boolean | cdktf.IResolvable);
    resetUseTokenGroups(): void;
    get useTokenGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _userattr?;
    get userattr(): string;
    set userattr(value: string);
    resetUserattr(): void;
    get userattrInput(): string | undefined;
    private _userdn?;
    get userdn(): string;
    set userdn(value: string);
    resetUserdn(): void;
    get userdnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
