import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityGroupMemberGroupIdsConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set to true, allows the resource to manage member group ids
  exclusively. Beware of race conditions when disabling exclusive management
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_member_group_ids#exclusive IdentityGroupMemberGroupIds#exclusive}
    */
    readonly exclusive?: boolean | cdktf.IResolvable;
    /**
    * ID of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_member_group_ids#group_id IdentityGroupMemberGroupIds#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_member_group_ids#id IdentityGroupMemberGroupIds#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Group IDs to be assigned as group members.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_member_group_ids#member_group_ids IdentityGroupMemberGroupIds#member_group_ids}
    */
    readonly memberGroupIds?: string[];
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_member_group_ids#namespace IdentityGroupMemberGroupIds#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_group_member_group_ids vault_identity_group_member_group_ids}
*/
export declare class IdentityGroupMemberGroupIds extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_group_member_group_ids";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_group_member_group_ids vault_identity_group_member_group_ids} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityGroupMemberGroupIdsConfig
    */
    constructor(scope: Construct, id: string, config: IdentityGroupMemberGroupIdsConfig);
    private _exclusive?;
    get exclusive(): boolean | cdktf.IResolvable;
    set exclusive(value: boolean | cdktf.IResolvable);
    resetExclusive(): void;
    get exclusiveInput(): boolean | cdktf.IResolvable | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memberGroupIds?;
    get memberGroupIds(): string[];
    set memberGroupIds(value: string[]);
    resetMemberGroupIds(): void;
    get memberGroupIdsInput(): string[] | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
