"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LdapAuthBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/ldap_auth_backend vault_ldap_auth_backend}
*/
class LdapAuthBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/ldap_auth_backend vault_ldap_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LdapAuthBackendConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_ldap_auth_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.10.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._binddn = config.binddn;
        this._bindpass = config.bindpass;
        this._caseSensitiveNames = config.caseSensitiveNames;
        this._certificate = config.certificate;
        this._clientTlsCert = config.clientTlsCert;
        this._clientTlsKey = config.clientTlsKey;
        this._denyNullBind = config.denyNullBind;
        this._description = config.description;
        this._disableRemount = config.disableRemount;
        this._discoverdn = config.discoverdn;
        this._groupattr = config.groupattr;
        this._groupdn = config.groupdn;
        this._groupfilter = config.groupfilter;
        this._id = config.id;
        this._insecureTls = config.insecureTls;
        this._local = config.local;
        this._namespace = config.namespace;
        this._path = config.path;
        this._starttls = config.starttls;
        this._tlsMaxVersion = config.tlsMaxVersion;
        this._tlsMinVersion = config.tlsMinVersion;
        this._tokenBoundCidrs = config.tokenBoundCidrs;
        this._tokenExplicitMaxTtl = config.tokenExplicitMaxTtl;
        this._tokenMaxTtl = config.tokenMaxTtl;
        this._tokenNoDefaultPolicy = config.tokenNoDefaultPolicy;
        this._tokenNumUses = config.tokenNumUses;
        this._tokenPeriod = config.tokenPeriod;
        this._tokenPolicies = config.tokenPolicies;
        this._tokenTtl = config.tokenTtl;
        this._tokenType = config.tokenType;
        this._upndomain = config.upndomain;
        this._url = config.url;
        this._useTokenGroups = config.useTokenGroups;
        this._userattr = config.userattr;
        this._userdn = config.userdn;
        this._userfilter = config.userfilter;
        this._usernameAsAlias = config.usernameAsAlias;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // accessor - computed: true, optional: false, required: false
    get accessor() {
        return this.getStringAttribute('accessor');
    }
    get binddn() {
        return this.getStringAttribute('binddn');
    }
    set binddn(value) {
        this._binddn = value;
    }
    resetBinddn() {
        this._binddn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binddnInput() {
        return this._binddn;
    }
    get bindpass() {
        return this.getStringAttribute('bindpass');
    }
    set bindpass(value) {
        this._bindpass = value;
    }
    resetBindpass() {
        this._bindpass = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bindpassInput() {
        return this._bindpass;
    }
    get caseSensitiveNames() {
        return this.getBooleanAttribute('case_sensitive_names');
    }
    set caseSensitiveNames(value) {
        this._caseSensitiveNames = value;
    }
    resetCaseSensitiveNames() {
        this._caseSensitiveNames = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caseSensitiveNamesInput() {
        return this._caseSensitiveNames;
    }
    get certificate() {
        return this.getStringAttribute('certificate');
    }
    set certificate(value) {
        this._certificate = value;
    }
    resetCertificate() {
        this._certificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certificateInput() {
        return this._certificate;
    }
    get clientTlsCert() {
        return this.getStringAttribute('client_tls_cert');
    }
    set clientTlsCert(value) {
        this._clientTlsCert = value;
    }
    resetClientTlsCert() {
        this._clientTlsCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTlsCertInput() {
        return this._clientTlsCert;
    }
    get clientTlsKey() {
        return this.getStringAttribute('client_tls_key');
    }
    set clientTlsKey(value) {
        this._clientTlsKey = value;
    }
    resetClientTlsKey() {
        this._clientTlsKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTlsKeyInput() {
        return this._clientTlsKey;
    }
    get denyNullBind() {
        return this.getBooleanAttribute('deny_null_bind');
    }
    set denyNullBind(value) {
        this._denyNullBind = value;
    }
    resetDenyNullBind() {
        this._denyNullBind = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get denyNullBindInput() {
        return this._denyNullBind;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get disableRemount() {
        return this.getBooleanAttribute('disable_remount');
    }
    set disableRemount(value) {
        this._disableRemount = value;
    }
    resetDisableRemount() {
        this._disableRemount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableRemountInput() {
        return this._disableRemount;
    }
    get discoverdn() {
        return this.getBooleanAttribute('discoverdn');
    }
    set discoverdn(value) {
        this._discoverdn = value;
    }
    resetDiscoverdn() {
        this._discoverdn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get discoverdnInput() {
        return this._discoverdn;
    }
    get groupattr() {
        return this.getStringAttribute('groupattr');
    }
    set groupattr(value) {
        this._groupattr = value;
    }
    resetGroupattr() {
        this._groupattr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupattrInput() {
        return this._groupattr;
    }
    get groupdn() {
        return this.getStringAttribute('groupdn');
    }
    set groupdn(value) {
        this._groupdn = value;
    }
    resetGroupdn() {
        this._groupdn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupdnInput() {
        return this._groupdn;
    }
    get groupfilter() {
        return this.getStringAttribute('groupfilter');
    }
    set groupfilter(value) {
        this._groupfilter = value;
    }
    resetGroupfilter() {
        this._groupfilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupfilterInput() {
        return this._groupfilter;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get insecureTls() {
        return this.getBooleanAttribute('insecure_tls');
    }
    set insecureTls(value) {
        this._insecureTls = value;
    }
    resetInsecureTls() {
        this._insecureTls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureTlsInput() {
        return this._insecureTls;
    }
    get local() {
        return this.getBooleanAttribute('local');
    }
    set local(value) {
        this._local = value;
    }
    resetLocal() {
        this._local = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localInput() {
        return this._local;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get starttls() {
        return this.getBooleanAttribute('starttls');
    }
    set starttls(value) {
        this._starttls = value;
    }
    resetStarttls() {
        this._starttls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get starttlsInput() {
        return this._starttls;
    }
    get tlsMaxVersion() {
        return this.getStringAttribute('tls_max_version');
    }
    set tlsMaxVersion(value) {
        this._tlsMaxVersion = value;
    }
    resetTlsMaxVersion() {
        this._tlsMaxVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsMaxVersionInput() {
        return this._tlsMaxVersion;
    }
    get tlsMinVersion() {
        return this.getStringAttribute('tls_min_version');
    }
    set tlsMinVersion(value) {
        this._tlsMinVersion = value;
    }
    resetTlsMinVersion() {
        this._tlsMinVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsMinVersionInput() {
        return this._tlsMinVersion;
    }
    get tokenBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('token_bound_cidrs'));
    }
    set tokenBoundCidrs(value) {
        this._tokenBoundCidrs = value;
    }
    resetTokenBoundCidrs() {
        this._tokenBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenBoundCidrsInput() {
        return this._tokenBoundCidrs;
    }
    get tokenExplicitMaxTtl() {
        return this.getNumberAttribute('token_explicit_max_ttl');
    }
    set tokenExplicitMaxTtl(value) {
        this._tokenExplicitMaxTtl = value;
    }
    resetTokenExplicitMaxTtl() {
        this._tokenExplicitMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExplicitMaxTtlInput() {
        return this._tokenExplicitMaxTtl;
    }
    get tokenMaxTtl() {
        return this.getNumberAttribute('token_max_ttl');
    }
    set tokenMaxTtl(value) {
        this._tokenMaxTtl = value;
    }
    resetTokenMaxTtl() {
        this._tokenMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenMaxTtlInput() {
        return this._tokenMaxTtl;
    }
    get tokenNoDefaultPolicy() {
        return this.getBooleanAttribute('token_no_default_policy');
    }
    set tokenNoDefaultPolicy(value) {
        this._tokenNoDefaultPolicy = value;
    }
    resetTokenNoDefaultPolicy() {
        this._tokenNoDefaultPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNoDefaultPolicyInput() {
        return this._tokenNoDefaultPolicy;
    }
    get tokenNumUses() {
        return this.getNumberAttribute('token_num_uses');
    }
    set tokenNumUses(value) {
        this._tokenNumUses = value;
    }
    resetTokenNumUses() {
        this._tokenNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNumUsesInput() {
        return this._tokenNumUses;
    }
    get tokenPeriod() {
        return this.getNumberAttribute('token_period');
    }
    set tokenPeriod(value) {
        this._tokenPeriod = value;
    }
    resetTokenPeriod() {
        this._tokenPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPeriodInput() {
        return this._tokenPeriod;
    }
    get tokenPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('token_policies'));
    }
    set tokenPolicies(value) {
        this._tokenPolicies = value;
    }
    resetTokenPolicies() {
        this._tokenPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPoliciesInput() {
        return this._tokenPolicies;
    }
    get tokenTtl() {
        return this.getNumberAttribute('token_ttl');
    }
    set tokenTtl(value) {
        this._tokenTtl = value;
    }
    resetTokenTtl() {
        this._tokenTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTtlInput() {
        return this._tokenTtl;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    get upndomain() {
        return this.getStringAttribute('upndomain');
    }
    set upndomain(value) {
        this._upndomain = value;
    }
    resetUpndomain() {
        this._upndomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upndomainInput() {
        return this._upndomain;
    }
    get url() {
        return this.getStringAttribute('url');
    }
    set url(value) {
        this._url = value;
    }
    // Temporarily expose input value. Use with caution.
    get urlInput() {
        return this._url;
    }
    get useTokenGroups() {
        return this.getBooleanAttribute('use_token_groups');
    }
    set useTokenGroups(value) {
        this._useTokenGroups = value;
    }
    resetUseTokenGroups() {
        this._useTokenGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useTokenGroupsInput() {
        return this._useTokenGroups;
    }
    get userattr() {
        return this.getStringAttribute('userattr');
    }
    set userattr(value) {
        this._userattr = value;
    }
    resetUserattr() {
        this._userattr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userattrInput() {
        return this._userattr;
    }
    get userdn() {
        return this.getStringAttribute('userdn');
    }
    set userdn(value) {
        this._userdn = value;
    }
    resetUserdn() {
        this._userdn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userdnInput() {
        return this._userdn;
    }
    get userfilter() {
        return this.getStringAttribute('userfilter');
    }
    set userfilter(value) {
        this._userfilter = value;
    }
    resetUserfilter() {
        this._userfilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userfilterInput() {
        return this._userfilter;
    }
    get usernameAsAlias() {
        return this.getBooleanAttribute('username_as_alias');
    }
    set usernameAsAlias(value) {
        this._usernameAsAlias = value;
    }
    resetUsernameAsAlias() {
        this._usernameAsAlias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameAsAliasInput() {
        return this._usernameAsAlias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            binddn: cdktf.stringToTerraform(this._binddn),
            bindpass: cdktf.stringToTerraform(this._bindpass),
            case_sensitive_names: cdktf.booleanToTerraform(this._caseSensitiveNames),
            certificate: cdktf.stringToTerraform(this._certificate),
            client_tls_cert: cdktf.stringToTerraform(this._clientTlsCert),
            client_tls_key: cdktf.stringToTerraform(this._clientTlsKey),
            deny_null_bind: cdktf.booleanToTerraform(this._denyNullBind),
            description: cdktf.stringToTerraform(this._description),
            disable_remount: cdktf.booleanToTerraform(this._disableRemount),
            discoverdn: cdktf.booleanToTerraform(this._discoverdn),
            groupattr: cdktf.stringToTerraform(this._groupattr),
            groupdn: cdktf.stringToTerraform(this._groupdn),
            groupfilter: cdktf.stringToTerraform(this._groupfilter),
            id: cdktf.stringToTerraform(this._id),
            insecure_tls: cdktf.booleanToTerraform(this._insecureTls),
            local: cdktf.booleanToTerraform(this._local),
            namespace: cdktf.stringToTerraform(this._namespace),
            path: cdktf.stringToTerraform(this._path),
            starttls: cdktf.booleanToTerraform(this._starttls),
            tls_max_version: cdktf.stringToTerraform(this._tlsMaxVersion),
            tls_min_version: cdktf.stringToTerraform(this._tlsMinVersion),
            token_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenBoundCidrs),
            token_explicit_max_ttl: cdktf.numberToTerraform(this._tokenExplicitMaxTtl),
            token_max_ttl: cdktf.numberToTerraform(this._tokenMaxTtl),
            token_no_default_policy: cdktf.booleanToTerraform(this._tokenNoDefaultPolicy),
            token_num_uses: cdktf.numberToTerraform(this._tokenNumUses),
            token_period: cdktf.numberToTerraform(this._tokenPeriod),
            token_policies: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenPolicies),
            token_ttl: cdktf.numberToTerraform(this._tokenTtl),
            token_type: cdktf.stringToTerraform(this._tokenType),
            upndomain: cdktf.stringToTerraform(this._upndomain),
            url: cdktf.stringToTerraform(this._url),
            use_token_groups: cdktf.booleanToTerraform(this._useTokenGroups),
            userattr: cdktf.stringToTerraform(this._userattr),
            userdn: cdktf.stringToTerraform(this._userdn),
            userfilter: cdktf.stringToTerraform(this._userfilter),
            username_as_alias: cdktf.booleanToTerraform(this._usernameAsAlias),
        };
    }
}
exports.LdapAuthBackend = LdapAuthBackend;
_a = JSII_RTTI_SYMBOL_1;
LdapAuthBackend[_a] = { fqn: "@cdktf/provider-vault.ldapAuthBackend.LdapAuthBackend", version: "3.0.14" };
// =================
// STATIC PROPERTIES
// =================
LdapAuthBackend.tfResourceType = "vault_ldap_auth_backend";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvbGRhcC1hdXRoLWJhY2tlbmQvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFJQSwrQkFBK0I7QUF3TC9COztFQUVFO0FBQ0YsTUFBYSxlQUFnQixTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPMUQsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQ7Ozs7OztNQU1FO0lBQ0YsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBNkI7UUFDNUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSx5QkFBeUI7WUFDaEQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxPQUFPO2dCQUNyQixlQUFlLEVBQUUsUUFBUTtnQkFDekIseUJBQXlCLEVBQUUsUUFBUTthQUNwQztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVk7WUFDakMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVO1lBQzdCLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTztTQUN4QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUM7UUFDN0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQztRQUN2QyxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQyxjQUFjLENBQUM7UUFDN0MsSUFBSSxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDL0IsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxHQUFHLEdBQUcsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDO1FBQzNCLElBQUksQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDL0MsSUFBSSxDQUFDLG9CQUFvQixHQUFHLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQztRQUN2RCxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLHFCQUFxQixHQUFHLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQztRQUN6RCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMsSUFBSSxHQUFHLE1BQU0sQ0FBQyxHQUFHLENBQUM7UUFDdkIsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBQzdDLElBQUksQ0FBQyxTQUFTLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQztRQUNqQyxJQUFJLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUM7UUFDN0IsSUFBSSxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO0lBQ2pELENBQUM7SUFFRCxhQUFhO0lBQ2IsYUFBYTtJQUNiLGFBQWE7SUFFYiw4REFBOEQ7SUFDOUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDMUQsQ0FBQztJQUNELElBQVcsa0JBQWtCLENBQUMsS0FBa0M7UUFDOUQsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQztJQUNuQyxDQUFDO0lBQ00sdUJBQXVCO1FBQzVCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxTQUFTLENBQUM7SUFDdkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFhO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFhO1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUFhO1FBQ25DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFDTSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDakMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUFrQztRQUN4RCxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ00saUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWtDO1FBQzFELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFDTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7SUFDbkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBa0M7UUFDdEQsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUNNLGVBQWU7UUFDcEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxTQUFTLENBQUM7SUFDL0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQWE7UUFDaEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUNNLGNBQWM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7SUFDOUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQWE7UUFDOUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQWE7UUFDekIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUNNLE9BQU87UUFDWixJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQztJQUN2QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBa0M7UUFDdkQsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsS0FBSyxDQUFDLEtBQWtDO1FBQ2pELElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO0lBQ3RCLENBQUM7SUFDTSxVQUFVO1FBQ2YsSUFBSSxDQUFDLE1BQU0sR0FBRyxTQUFTLENBQUM7SUFDMUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQWE7UUFDaEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUNNLGNBQWM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7SUFDOUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFrQztRQUNwRCxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFhO1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFhO1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsZUFBZTtRQUN4QixPQUFPLEtBQUssQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDckUsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWU7UUFDeEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztJQUNoQyxDQUFDO0lBQ00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUM7SUFDcEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUMvQixDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBQ0QsSUFBVyxtQkFBbUIsQ0FBQyxLQUFhO1FBQzFDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUM7SUFDcEMsQ0FBQztJQUNNLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsb0JBQW9CLEdBQUcsU0FBUyxDQUFDO0lBQ3hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx3QkFBd0I7UUFDakMsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzdELENBQUM7SUFDRCxJQUFXLG9CQUFvQixDQUFDLEtBQWtDO1FBQ2hFLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUM7SUFDckMsQ0FBQztJQUNNLHlCQUF5QjtRQUM5QixJQUFJLENBQUMscUJBQXFCLEdBQUcsU0FBUyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUFhO1FBQ25DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFDTSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDakMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxLQUFLLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO0lBQ2xFLENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFlO1FBQ3RDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztJQUM5QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztJQUM5QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUlELElBQVcsR0FBRztRQUNaLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFDRCxJQUFXLEdBQUcsQ0FBQyxLQUFhO1FBQzFCLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNuQixDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWtDO1FBQzFELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFDTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7SUFDbkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9DLENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWtDO1FBQzNELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUNNLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsU0FBUyxDQUFDO0lBQ3BDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVGLG9CQUFvQjtRQUM1QixPQUFPO1lBQ0wsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO1lBQzdDLFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztZQUNqRCxvQkFBb0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1lBQ3hFLFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN2RCxlQUFlLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDN0QsY0FBYyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDO1lBQzNELGNBQWMsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQztZQUM1RCxXQUFXLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDdkQsZUFBZSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO1lBQy9ELFVBQVUsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUN0RCxTQUFTLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7WUFDbkQsT0FBTyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQy9DLFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN2RCxFQUFFLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7WUFDckMsWUFBWSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQ3pELEtBQUssRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQztZQUM1QyxTQUFTLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7WUFDbkQsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3pDLFFBQVEsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztZQUNsRCxlQUFlLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDN0QsZUFBZSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO1lBQzdELGlCQUFpQixFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztZQUMxRixzQkFBc0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDO1lBQzFFLGFBQWEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN6RCx1QkFBdUIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDO1lBQzdFLGNBQWMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQztZQUMzRCxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDeEQsY0FBYyxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDckYsU0FBUyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO1lBQ2xELFVBQVUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQztZQUNwRCxTQUFTLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7WUFDbkQsR0FBRyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO1lBQ3ZDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO1lBQ2hFLFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztZQUNqRCxNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7WUFDN0MsVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3JELGlCQUFpQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7U0FDbkUsQ0FBQztJQUNKLENBQUM7O0FBM3NCSCwwQ0E0c0JDOzs7QUExc0JDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ0csOEJBQWMsR0FBRyx5QkFBeUIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgTGRhcEF1dGhCYWNrZW5kQ29uZmlnIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjYmluZGRuIExkYXBBdXRoQmFja2VuZCNiaW5kZG59XG4gICovXG4gIHJlYWRvbmx5IGJpbmRkbj86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCNiaW5kcGFzcyBMZGFwQXV0aEJhY2tlbmQjYmluZHBhc3N9XG4gICovXG4gIHJlYWRvbmx5IGJpbmRwYXNzPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI2Nhc2Vfc2Vuc2l0aXZlX25hbWVzIExkYXBBdXRoQmFja2VuZCNjYXNlX3NlbnNpdGl2ZV9uYW1lc31cbiAgKi9cbiAgcmVhZG9ubHkgY2FzZVNlbnNpdGl2ZU5hbWVzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI2NlcnRpZmljYXRlIExkYXBBdXRoQmFja2VuZCNjZXJ0aWZpY2F0ZX1cbiAgKi9cbiAgcmVhZG9ubHkgY2VydGlmaWNhdGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjY2xpZW50X3Rsc19jZXJ0IExkYXBBdXRoQmFja2VuZCNjbGllbnRfdGxzX2NlcnR9XG4gICovXG4gIHJlYWRvbmx5IGNsaWVudFRsc0NlcnQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjY2xpZW50X3Rsc19rZXkgTGRhcEF1dGhCYWNrZW5kI2NsaWVudF90bHNfa2V5fVxuICAqL1xuICByZWFkb25seSBjbGllbnRUbHNLZXk/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjZGVueV9udWxsX2JpbmQgTGRhcEF1dGhCYWNrZW5kI2RlbnlfbnVsbF9iaW5kfVxuICAqL1xuICByZWFkb25seSBkZW55TnVsbEJpbmQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjZGVzY3JpcHRpb24gTGRhcEF1dGhCYWNrZW5kI2Rlc2NyaXB0aW9ufVxuICAqL1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICogSWYgc2V0LCBvcHRzIG91dCBvZiBtb3VudCBtaWdyYXRpb24gb24gcGF0aCB1cGRhdGVzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjZGlzYWJsZV9yZW1vdW50IExkYXBBdXRoQmFja2VuZCNkaXNhYmxlX3JlbW91bnR9XG4gICovXG4gIHJlYWRvbmx5IGRpc2FibGVSZW1vdW50PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI2Rpc2NvdmVyZG4gTGRhcEF1dGhCYWNrZW5kI2Rpc2NvdmVyZG59XG4gICovXG4gIHJlYWRvbmx5IGRpc2NvdmVyZG4/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjZ3JvdXBhdHRyIExkYXBBdXRoQmFja2VuZCNncm91cGF0dHJ9XG4gICovXG4gIHJlYWRvbmx5IGdyb3VwYXR0cj86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCNncm91cGRuIExkYXBBdXRoQmFja2VuZCNncm91cGRufVxuICAqL1xuICByZWFkb25seSBncm91cGRuPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI2dyb3VwZmlsdGVyIExkYXBBdXRoQmFja2VuZCNncm91cGZpbHRlcn1cbiAgKi9cbiAgcmVhZG9ubHkgZ3JvdXBmaWx0ZXI/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjaWQgTGRhcEF1dGhCYWNrZW5kI2lkfVxuICAqXG4gICogUGxlYXNlIGJlIGF3YXJlIHRoYXQgdGhlIGlkIGZpZWxkIGlzIGF1dG9tYXRpY2FsbHkgYWRkZWQgdG8gYWxsIHJlc291cmNlcyBpbiBUZXJyYWZvcm0gcHJvdmlkZXJzIHVzaW5nIGEgVGVycmFmb3JtIHByb3ZpZGVyIFNESyB2ZXJzaW9uIGJlbG93IDIuXG4gICogSWYgeW91IGV4cGVyaWVuY2UgcHJvYmxlbXMgc2V0dGluZyB0aGlzIHZhbHVlIGl0IG1pZ2h0IG5vdCBiZSBzZXR0YWJsZS4gUGxlYXNlIHRha2UgYSBsb29rIGF0IHRoZSBwcm92aWRlciBkb2N1bWVudGF0aW9uIHRvIGVuc3VyZSBpdCBzaG91bGQgYmUgc2V0dGFibGUuXG4gICovXG4gIHJlYWRvbmx5IGlkPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI2luc2VjdXJlX3RscyBMZGFwQXV0aEJhY2tlbmQjaW5zZWN1cmVfdGxzfVxuICAqL1xuICByZWFkb25seSBpbnNlY3VyZVRscz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogU3BlY2lmaWVzIGlmIHRoZSBhdXRoIG1ldGhvZCBpcyBsb2NhbCBvbmx5XG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCNsb2NhbCBMZGFwQXV0aEJhY2tlbmQjbG9jYWx9XG4gICovXG4gIHJlYWRvbmx5IGxvY2FsPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBUYXJnZXQgbmFtZXNwYWNlLiAocmVxdWlyZXMgRW50ZXJwcmlzZSlcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI25hbWVzcGFjZSBMZGFwQXV0aEJhY2tlbmQjbmFtZXNwYWNlfVxuICAqL1xuICByZWFkb25seSBuYW1lc3BhY2U/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjcGF0aCBMZGFwQXV0aEJhY2tlbmQjcGF0aH1cbiAgKi9cbiAgcmVhZG9ubHkgcGF0aD86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCNzdGFydHRscyBMZGFwQXV0aEJhY2tlbmQjc3RhcnR0bHN9XG4gICovXG4gIHJlYWRvbmx5IHN0YXJ0dGxzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI3Rsc19tYXhfdmVyc2lvbiBMZGFwQXV0aEJhY2tlbmQjdGxzX21heF92ZXJzaW9ufVxuICAqL1xuICByZWFkb25seSB0bHNNYXhWZXJzaW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI3Rsc19taW5fdmVyc2lvbiBMZGFwQXV0aEJhY2tlbmQjdGxzX21pbl92ZXJzaW9ufVxuICAqL1xuICByZWFkb25seSB0bHNNaW5WZXJzaW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIGJsb2NrcyBvZiBJUCBhZGRyZXNzZXMgd2hpY2ggYXJlIGFsbG93ZWQgdG8gdXNlIHRoZSBnZW5lcmF0ZWQgdG9rZW5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI3Rva2VuX2JvdW5kX2NpZHJzIExkYXBBdXRoQmFja2VuZCN0b2tlbl9ib3VuZF9jaWRyc31cbiAgKi9cbiAgcmVhZG9ubHkgdG9rZW5Cb3VuZENpZHJzPzogc3RyaW5nW107XG4gIC8qKlxuICAqIEdlbmVyYXRlZCBUb2tlbidzIEV4cGxpY2l0IE1heGltdW0gVFRMIGluIHNlY29uZHNcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI3Rva2VuX2V4cGxpY2l0X21heF90dGwgTGRhcEF1dGhCYWNrZW5kI3Rva2VuX2V4cGxpY2l0X21heF90dGx9XG4gICovXG4gIHJlYWRvbmx5IHRva2VuRXhwbGljaXRNYXhUdGw/OiBudW1iZXI7XG4gIC8qKlxuICAqIFRoZSBtYXhpbXVtIGxpZmV0aW1lIG9mIHRoZSBnZW5lcmF0ZWQgdG9rZW5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI3Rva2VuX21heF90dGwgTGRhcEF1dGhCYWNrZW5kI3Rva2VuX21heF90dGx9XG4gICovXG4gIHJlYWRvbmx5IHRva2VuTWF4VHRsPzogbnVtYmVyO1xuICAvKipcbiAgKiBJZiB0cnVlLCB0aGUgJ2RlZmF1bHQnIHBvbGljeSB3aWxsIG5vdCBhdXRvbWF0aWNhbGx5IGJlIGFkZGVkIHRvIGdlbmVyYXRlZCB0b2tlbnNcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI3Rva2VuX25vX2RlZmF1bHRfcG9saWN5IExkYXBBdXRoQmFja2VuZCN0b2tlbl9ub19kZWZhdWx0X3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgdG9rZW5Ob0RlZmF1bHRQb2xpY3k/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoZSBtYXhpbXVtIG51bWJlciBvZiB0aW1lcyBhIHRva2VuIG1heSBiZSB1c2VkLCBhIHZhbHVlIG9mIHplcm8gbWVhbnMgdW5saW1pdGVkXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCN0b2tlbl9udW1fdXNlcyBMZGFwQXV0aEJhY2tlbmQjdG9rZW5fbnVtX3VzZXN9XG4gICovXG4gIHJlYWRvbmx5IHRva2VuTnVtVXNlcz86IG51bWJlcjtcbiAgLyoqXG4gICogR2VuZXJhdGVkIFRva2VuJ3MgUGVyaW9kXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCN0b2tlbl9wZXJpb2QgTGRhcEF1dGhCYWNrZW5kI3Rva2VuX3BlcmlvZH1cbiAgKi9cbiAgcmVhZG9ubHkgdG9rZW5QZXJpb2Q/OiBudW1iZXI7XG4gIC8qKlxuICAqIEdlbmVyYXRlZCBUb2tlbidzIFBvbGljaWVzXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCN0b2tlbl9wb2xpY2llcyBMZGFwQXV0aEJhY2tlbmQjdG9rZW5fcG9saWNpZXN9XG4gICovXG4gIHJlYWRvbmx5IHRva2VuUG9saWNpZXM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogVGhlIGluaXRpYWwgdHRsIG9mIHRoZSB0b2tlbiB0byBnZW5lcmF0ZSBpbiBzZWNvbmRzXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCN0b2tlbl90dGwgTGRhcEF1dGhCYWNrZW5kI3Rva2VuX3R0bH1cbiAgKi9cbiAgcmVhZG9ubHkgdG9rZW5UdGw/OiBudW1iZXI7XG4gIC8qKlxuICAqIFRoZSB0eXBlIG9mIHRva2VuIHRvIGdlbmVyYXRlLCBzZXJ2aWNlIG9yIGJhdGNoXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCN0b2tlbl90eXBlIExkYXBBdXRoQmFja2VuZCN0b2tlbl90eXBlfVxuICAqL1xuICByZWFkb25seSB0b2tlblR5cGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjdXBuZG9tYWluIExkYXBBdXRoQmFja2VuZCN1cG5kb21haW59XG4gICovXG4gIHJlYWRvbmx5IHVwbmRvbWFpbj86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCN1cmwgTGRhcEF1dGhCYWNrZW5kI3VybH1cbiAgKi9cbiAgcmVhZG9ubHkgdXJsOiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjdXNlX3Rva2VuX2dyb3VwcyBMZGFwQXV0aEJhY2tlbmQjdXNlX3Rva2VuX2dyb3Vwc31cbiAgKi9cbiAgcmVhZG9ubHkgdXNlVG9rZW5Hcm91cHM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvbGRhcF9hdXRoX2JhY2tlbmQjdXNlcmF0dHIgTGRhcEF1dGhCYWNrZW5kI3VzZXJhdHRyfVxuICAqL1xuICByZWFkb25seSB1c2VyYXR0cj86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCN1c2VyZG4gTGRhcEF1dGhCYWNrZW5kI3VzZXJkbn1cbiAgKi9cbiAgcmVhZG9ubHkgdXNlcmRuPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI3VzZXJmaWx0ZXIgTGRhcEF1dGhCYWNrZW5kI3VzZXJmaWx0ZXJ9XG4gICovXG4gIHJlYWRvbmx5IHVzZXJmaWx0ZXI/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEZvcmNlIHRoZSBhdXRoIG1ldGhvZCB0byB1c2UgdGhlIHVzZXJuYW1lIHBhc3NlZCBieSB0aGUgdXNlciBhcyB0aGUgYWxpYXMgbmFtZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kI3VzZXJuYW1lX2FzX2FsaWFzIExkYXBBdXRoQmFja2VuZCN1c2VybmFtZV9hc19hbGlhc31cbiAgKi9cbiAgcmVhZG9ubHkgdXNlcm5hbWVBc0FsaWFzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiogUmVwcmVzZW50cyBhIHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci9sZGFwX2F1dGhfYmFja2VuZCB2YXVsdF9sZGFwX2F1dGhfYmFja2VuZH1cbiovXG5leHBvcnQgY2xhc3MgTGRhcEF1dGhCYWNrZW5kIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtUmVzb3VyY2Uge1xuXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIC8vIFNUQVRJQyBQUk9QRVJUSUVTXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgdGZSZXNvdXJjZVR5cGUgPSBcInZhdWx0X2xkYXBfYXV0aF9iYWNrZW5kXCI7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL2xkYXBfYXV0aF9iYWNrZW5kIHZhdWx0X2xkYXBfYXV0aF9iYWNrZW5kfSBSZXNvdXJjZVxuICAqXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaWQgVGhlIHNjb3BlZCBjb25zdHJ1Y3QgSUQuIE11c3QgYmUgdW5pcXVlIGFtb25nc3Qgc2libGluZ3MgaW4gdGhlIHNhbWUgc2NvcGVcbiAgKiBAcGFyYW0gb3B0aW9ucyBMZGFwQXV0aEJhY2tlbmRDb25maWdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogTGRhcEF1dGhCYWNrZW5kQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICd2YXVsdF9sZGFwX2F1dGhfYmFja2VuZCcsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICd2YXVsdCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzMuMTAuMCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICd+PiAzLjcnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGUsXG4gICAgICBwcm92aXNpb25lcnM6IGNvbmZpZy5wcm92aXNpb25lcnMsXG4gICAgICBjb25uZWN0aW9uOiBjb25maWcuY29ubmVjdGlvbixcbiAgICAgIGZvckVhY2g6IGNvbmZpZy5mb3JFYWNoXG4gICAgfSk7XG4gICAgdGhpcy5fYmluZGRuID0gY29uZmlnLmJpbmRkbjtcbiAgICB0aGlzLl9iaW5kcGFzcyA9IGNvbmZpZy5iaW5kcGFzcztcbiAgICB0aGlzLl9jYXNlU2Vuc2l0aXZlTmFtZXMgPSBjb25maWcuY2FzZVNlbnNpdGl2ZU5hbWVzO1xuICAgIHRoaXMuX2NlcnRpZmljYXRlID0gY29uZmlnLmNlcnRpZmljYXRlO1xuICAgIHRoaXMuX2NsaWVudFRsc0NlcnQgPSBjb25maWcuY2xpZW50VGxzQ2VydDtcbiAgICB0aGlzLl9jbGllbnRUbHNLZXkgPSBjb25maWcuY2xpZW50VGxzS2V5O1xuICAgIHRoaXMuX2RlbnlOdWxsQmluZCA9IGNvbmZpZy5kZW55TnVsbEJpbmQ7XG4gICAgdGhpcy5fZGVzY3JpcHRpb24gPSBjb25maWcuZGVzY3JpcHRpb247XG4gICAgdGhpcy5fZGlzYWJsZVJlbW91bnQgPSBjb25maWcuZGlzYWJsZVJlbW91bnQ7XG4gICAgdGhpcy5fZGlzY292ZXJkbiA9IGNvbmZpZy5kaXNjb3ZlcmRuO1xuICAgIHRoaXMuX2dyb3VwYXR0ciA9IGNvbmZpZy5ncm91cGF0dHI7XG4gICAgdGhpcy5fZ3JvdXBkbiA9IGNvbmZpZy5ncm91cGRuO1xuICAgIHRoaXMuX2dyb3VwZmlsdGVyID0gY29uZmlnLmdyb3VwZmlsdGVyO1xuICAgIHRoaXMuX2lkID0gY29uZmlnLmlkO1xuICAgIHRoaXMuX2luc2VjdXJlVGxzID0gY29uZmlnLmluc2VjdXJlVGxzO1xuICAgIHRoaXMuX2xvY2FsID0gY29uZmlnLmxvY2FsO1xuICAgIHRoaXMuX25hbWVzcGFjZSA9IGNvbmZpZy5uYW1lc3BhY2U7XG4gICAgdGhpcy5fcGF0aCA9IGNvbmZpZy5wYXRoO1xuICAgIHRoaXMuX3N0YXJ0dGxzID0gY29uZmlnLnN0YXJ0dGxzO1xuICAgIHRoaXMuX3Rsc01heFZlcnNpb24gPSBjb25maWcudGxzTWF4VmVyc2lvbjtcbiAgICB0aGlzLl90bHNNaW5WZXJzaW9uID0gY29uZmlnLnRsc01pblZlcnNpb247XG4gICAgdGhpcy5fdG9rZW5Cb3VuZENpZHJzID0gY29uZmlnLnRva2VuQm91bmRDaWRycztcbiAgICB0aGlzLl90b2tlbkV4cGxpY2l0TWF4VHRsID0gY29uZmlnLnRva2VuRXhwbGljaXRNYXhUdGw7XG4gICAgdGhpcy5fdG9rZW5NYXhUdGwgPSBjb25maWcudG9rZW5NYXhUdGw7XG4gICAgdGhpcy5fdG9rZW5Ob0RlZmF1bHRQb2xpY3kgPSBjb25maWcudG9rZW5Ob0RlZmF1bHRQb2xpY3k7XG4gICAgdGhpcy5fdG9rZW5OdW1Vc2VzID0gY29uZmlnLnRva2VuTnVtVXNlcztcbiAgICB0aGlzLl90b2tlblBlcmlvZCA9IGNvbmZpZy50b2tlblBlcmlvZDtcbiAgICB0aGlzLl90b2tlblBvbGljaWVzID0gY29uZmlnLnRva2VuUG9saWNpZXM7XG4gICAgdGhpcy5fdG9rZW5UdGwgPSBjb25maWcudG9rZW5UdGw7XG4gICAgdGhpcy5fdG9rZW5UeXBlID0gY29uZmlnLnRva2VuVHlwZTtcbiAgICB0aGlzLl91cG5kb21haW4gPSBjb25maWcudXBuZG9tYWluO1xuICAgIHRoaXMuX3VybCA9IGNvbmZpZy51cmw7XG4gICAgdGhpcy5fdXNlVG9rZW5Hcm91cHMgPSBjb25maWcudXNlVG9rZW5Hcm91cHM7XG4gICAgdGhpcy5fdXNlcmF0dHIgPSBjb25maWcudXNlcmF0dHI7XG4gICAgdGhpcy5fdXNlcmRuID0gY29uZmlnLnVzZXJkbjtcbiAgICB0aGlzLl91c2VyZmlsdGVyID0gY29uZmlnLnVzZXJmaWx0ZXI7XG4gICAgdGhpcy5fdXNlcm5hbWVBc0FsaWFzID0gY29uZmlnLnVzZXJuYW1lQXNBbGlhcztcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYWNjZXNzb3IgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBhY2Nlc3NvcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2FjY2Vzc29yJyk7XG4gIH1cblxuICAvLyBiaW5kZG4gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9iaW5kZG4/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGJpbmRkbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2JpbmRkbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgYmluZGRuKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9iaW5kZG4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRCaW5kZG4oKSB7XG4gICAgdGhpcy5fYmluZGRuID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBiaW5kZG5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYmluZGRuO1xuICB9XG5cbiAgLy8gYmluZHBhc3MgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9iaW5kcGFzcz86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgYmluZHBhc3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdiaW5kcGFzcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgYmluZHBhc3ModmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2JpbmRwYXNzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QmluZHBhc3MoKSB7XG4gICAgdGhpcy5fYmluZHBhc3MgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJpbmRwYXNzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2JpbmRwYXNzO1xuICB9XG5cbiAgLy8gY2FzZV9zZW5zaXRpdmVfbmFtZXMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jYXNlU2Vuc2l0aXZlTmFtZXM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGNhc2VTZW5zaXRpdmVOYW1lcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdjYXNlX3NlbnNpdGl2ZV9uYW1lcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2FzZVNlbnNpdGl2ZU5hbWVzKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9jYXNlU2Vuc2l0aXZlTmFtZXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDYXNlU2Vuc2l0aXZlTmFtZXMoKSB7XG4gICAgdGhpcy5fY2FzZVNlbnNpdGl2ZU5hbWVzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjYXNlU2Vuc2l0aXZlTmFtZXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2FzZVNlbnNpdGl2ZU5hbWVzO1xuICB9XG5cbiAgLy8gY2VydGlmaWNhdGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jZXJ0aWZpY2F0ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY2VydGlmaWNhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjZXJ0aWZpY2F0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2VydGlmaWNhdGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2NlcnRpZmljYXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q2VydGlmaWNhdGUoKSB7XG4gICAgdGhpcy5fY2VydGlmaWNhdGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNlcnRpZmljYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NlcnRpZmljYXRlO1xuICB9XG5cbiAgLy8gY2xpZW50X3Rsc19jZXJ0IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2xpZW50VGxzQ2VydD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY2xpZW50VGxzQ2VydCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NsaWVudF90bHNfY2VydCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2xpZW50VGxzQ2VydCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fY2xpZW50VGxzQ2VydCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENsaWVudFRsc0NlcnQoKSB7XG4gICAgdGhpcy5fY2xpZW50VGxzQ2VydCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2xpZW50VGxzQ2VydElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jbGllbnRUbHNDZXJ0O1xuICB9XG5cbiAgLy8gY2xpZW50X3Rsc19rZXkgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jbGllbnRUbHNLZXk/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNsaWVudFRsc0tleSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NsaWVudF90bHNfa2V5Jyk7XG4gIH1cbiAgcHVibGljIHNldCBjbGllbnRUbHNLZXkodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2NsaWVudFRsc0tleSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENsaWVudFRsc0tleSgpIHtcbiAgICB0aGlzLl9jbGllbnRUbHNLZXkgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNsaWVudFRsc0tleUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jbGllbnRUbHNLZXk7XG4gIH1cblxuICAvLyBkZW55X251bGxfYmluZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbnlOdWxsQmluZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZGVueU51bGxCaW5kKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2RlbnlfbnVsbF9iaW5kJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZW55TnVsbEJpbmQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2RlbnlOdWxsQmluZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlbnlOdWxsQmluZCgpIHtcbiAgICB0aGlzLl9kZW55TnVsbEJpbmQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlbnlOdWxsQmluZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZW55TnVsbEJpbmQ7XG4gIH1cblxuICAvLyBkZXNjcmlwdGlvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Rlc2NyaXB0aW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBkZXNjcmlwdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2Rlc2NyaXB0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZXNjcmlwdGlvbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZGVzY3JpcHRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZXNjcmlwdGlvbigpIHtcbiAgICB0aGlzLl9kZXNjcmlwdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVzY3JpcHRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVzY3JpcHRpb247XG4gIH1cblxuICAvLyBkaXNhYmxlX3JlbW91bnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGlzYWJsZVJlbW91bnQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGRpc2FibGVSZW1vdW50KCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2Rpc2FibGVfcmVtb3VudCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGlzYWJsZVJlbW91bnQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2Rpc2FibGVSZW1vdW50ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGlzYWJsZVJlbW91bnQoKSB7XG4gICAgdGhpcy5fZGlzYWJsZVJlbW91bnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRpc2FibGVSZW1vdW50SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rpc2FibGVSZW1vdW50O1xuICB9XG5cbiAgLy8gZGlzY292ZXJkbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Rpc2NvdmVyZG4/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGRpc2NvdmVyZG4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZGlzY292ZXJkbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGlzY292ZXJkbih2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fZGlzY292ZXJkbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERpc2NvdmVyZG4oKSB7XG4gICAgdGhpcy5fZGlzY292ZXJkbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGlzY292ZXJkbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kaXNjb3ZlcmRuO1xuICB9XG5cbiAgLy8gZ3JvdXBhdHRyIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZ3JvdXBhdHRyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBncm91cGF0dHIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdncm91cGF0dHInKTtcbiAgfVxuICBwdWJsaWMgc2V0IGdyb3VwYXR0cih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZ3JvdXBhdHRyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0R3JvdXBhdHRyKCkge1xuICAgIHRoaXMuX2dyb3VwYXR0ciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZ3JvdXBhdHRySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2dyb3VwYXR0cjtcbiAgfVxuXG4gIC8vIGdyb3VwZG4gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ncm91cGRuPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBncm91cGRuKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZ3JvdXBkbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZ3JvdXBkbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZ3JvdXBkbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEdyb3VwZG4oKSB7XG4gICAgdGhpcy5fZ3JvdXBkbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZ3JvdXBkbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9ncm91cGRuO1xuICB9XG5cbiAgLy8gZ3JvdXBmaWx0ZXIgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ncm91cGZpbHRlcj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZ3JvdXBmaWx0ZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdncm91cGZpbHRlcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZ3JvdXBmaWx0ZXIodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2dyb3VwZmlsdGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0R3JvdXBmaWx0ZXIoKSB7XG4gICAgdGhpcy5fZ3JvdXBmaWx0ZXIgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGdyb3VwZmlsdGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2dyb3VwZmlsdGVyO1xuICB9XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SWQoKSB7XG4gICAgdGhpcy5faWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkO1xuICB9XG5cbiAgLy8gaW5zZWN1cmVfdGxzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaW5zZWN1cmVUbHM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGluc2VjdXJlVGxzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2luc2VjdXJlX3RscycpO1xuICB9XG4gIHB1YmxpYyBzZXQgaW5zZWN1cmVUbHModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2luc2VjdXJlVGxzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SW5zZWN1cmVUbHMoKSB7XG4gICAgdGhpcy5faW5zZWN1cmVUbHMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGluc2VjdXJlVGxzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2luc2VjdXJlVGxzO1xuICB9XG5cbiAgLy8gbG9jYWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbG9jYWw/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGxvY2FsKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2xvY2FsJyk7XG4gIH1cbiAgcHVibGljIHNldCBsb2NhbCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fbG9jYWwgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRMb2NhbCgpIHtcbiAgICB0aGlzLl9sb2NhbCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbG9jYWxJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbG9jYWw7XG4gIH1cblxuICAvLyBuYW1lc3BhY2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbmFtZXNwYWNlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBuYW1lc3BhY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCduYW1lc3BhY2UnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG5hbWVzcGFjZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbmFtZXNwYWNlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TmFtZXNwYWNlKCkge1xuICAgIHRoaXMuX25hbWVzcGFjZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbmFtZXNwYWNlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWVzcGFjZTtcbiAgfVxuXG4gIC8vIHBhdGggLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcGF0aD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcGF0aCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BhdGgnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHBhdGgodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BhdGggPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQYXRoKCkge1xuICAgIHRoaXMuX3BhdGggPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBhdGhJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcGF0aDtcbiAgfVxuXG4gIC8vIHN0YXJ0dGxzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3RhcnR0bHM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHN0YXJ0dGxzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3N0YXJ0dGxzJyk7XG4gIH1cbiAgcHVibGljIHNldCBzdGFydHRscyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fc3RhcnR0bHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTdGFydHRscygpIHtcbiAgICB0aGlzLl9zdGFydHRscyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RhcnR0bHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc3RhcnR0bHM7XG4gIH1cblxuICAvLyB0bHNfbWF4X3ZlcnNpb24gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90bHNNYXhWZXJzaW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB0bHNNYXhWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndGxzX21heF92ZXJzaW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCB0bHNNYXhWZXJzaW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl90bHNNYXhWZXJzaW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGxzTWF4VmVyc2lvbigpIHtcbiAgICB0aGlzLl90bHNNYXhWZXJzaW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0bHNNYXhWZXJzaW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Rsc01heFZlcnNpb247XG4gIH1cblxuICAvLyB0bHNfbWluX3ZlcnNpb24gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90bHNNaW5WZXJzaW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB0bHNNaW5WZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndGxzX21pbl92ZXJzaW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCB0bHNNaW5WZXJzaW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl90bHNNaW5WZXJzaW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGxzTWluVmVyc2lvbigpIHtcbiAgICB0aGlzLl90bHNNaW5WZXJzaW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0bHNNaW5WZXJzaW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Rsc01pblZlcnNpb247XG4gIH1cblxuICAvLyB0b2tlbl9ib3VuZF9jaWRycyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90b2tlbkJvdW5kQ2lkcnM/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgdG9rZW5Cb3VuZENpZHJzKCkge1xuICAgIHJldHVybiBjZGt0Zi5Gbi50b2xpc3QodGhpcy5nZXRMaXN0QXR0cmlidXRlKCd0b2tlbl9ib3VuZF9jaWRycycpKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRva2VuQm91bmRDaWRycyh2YWx1ZTogc3RyaW5nW10pIHtcbiAgICB0aGlzLl90b2tlbkJvdW5kQ2lkcnMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUb2tlbkJvdW5kQ2lkcnMoKSB7XG4gICAgdGhpcy5fdG9rZW5Cb3VuZENpZHJzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0b2tlbkJvdW5kQ2lkcnNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdG9rZW5Cb3VuZENpZHJzO1xuICB9XG5cbiAgLy8gdG9rZW5fZXhwbGljaXRfbWF4X3R0bCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90b2tlbkV4cGxpY2l0TWF4VHRsPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCB0b2tlbkV4cGxpY2l0TWF4VHRsKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgndG9rZW5fZXhwbGljaXRfbWF4X3R0bCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgdG9rZW5FeHBsaWNpdE1heFR0bCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fdG9rZW5FeHBsaWNpdE1heFR0bCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRva2VuRXhwbGljaXRNYXhUdGwoKSB7XG4gICAgdGhpcy5fdG9rZW5FeHBsaWNpdE1heFR0bCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdG9rZW5FeHBsaWNpdE1heFR0bElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90b2tlbkV4cGxpY2l0TWF4VHRsO1xuICB9XG5cbiAgLy8gdG9rZW5fbWF4X3R0bCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90b2tlbk1heFR0bD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgdG9rZW5NYXhUdGwoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd0b2tlbl9tYXhfdHRsJyk7XG4gIH1cbiAgcHVibGljIHNldCB0b2tlbk1heFR0bCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fdG9rZW5NYXhUdGwgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUb2tlbk1heFR0bCgpIHtcbiAgICB0aGlzLl90b2tlbk1heFR0bCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdG9rZW5NYXhUdGxJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdG9rZW5NYXhUdGw7XG4gIH1cblxuICAvLyB0b2tlbl9ub19kZWZhdWx0X3BvbGljeSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90b2tlbk5vRGVmYXVsdFBvbGljeT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgdG9rZW5Ob0RlZmF1bHRQb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgndG9rZW5fbm9fZGVmYXVsdF9wb2xpY3knKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRva2VuTm9EZWZhdWx0UG9saWN5KHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl90b2tlbk5vRGVmYXVsdFBvbGljeSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRva2VuTm9EZWZhdWx0UG9saWN5KCkge1xuICAgIHRoaXMuX3Rva2VuTm9EZWZhdWx0UG9saWN5ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0b2tlbk5vRGVmYXVsdFBvbGljeUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90b2tlbk5vRGVmYXVsdFBvbGljeTtcbiAgfVxuXG4gIC8vIHRva2VuX251bV91c2VzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Rva2VuTnVtVXNlcz86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgdG9rZW5OdW1Vc2VzKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgndG9rZW5fbnVtX3VzZXMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRva2VuTnVtVXNlcyh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fdG9rZW5OdW1Vc2VzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VG9rZW5OdW1Vc2VzKCkge1xuICAgIHRoaXMuX3Rva2VuTnVtVXNlcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdG9rZW5OdW1Vc2VzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Rva2VuTnVtVXNlcztcbiAgfVxuXG4gIC8vIHRva2VuX3BlcmlvZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90b2tlblBlcmlvZD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgdG9rZW5QZXJpb2QoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd0b2tlbl9wZXJpb2QnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRva2VuUGVyaW9kKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl90b2tlblBlcmlvZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRva2VuUGVyaW9kKCkge1xuICAgIHRoaXMuX3Rva2VuUGVyaW9kID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0b2tlblBlcmlvZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90b2tlblBlcmlvZDtcbiAgfVxuXG4gIC8vIHRva2VuX3BvbGljaWVzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Rva2VuUG9saWNpZXM/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgdG9rZW5Qb2xpY2llcygpIHtcbiAgICByZXR1cm4gY2RrdGYuRm4udG9saXN0KHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgndG9rZW5fcG9saWNpZXMnKSk7XG4gIH1cbiAgcHVibGljIHNldCB0b2tlblBvbGljaWVzKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX3Rva2VuUG9saWNpZXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUb2tlblBvbGljaWVzKCkge1xuICAgIHRoaXMuX3Rva2VuUG9saWNpZXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRva2VuUG9saWNpZXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdG9rZW5Qb2xpY2llcztcbiAgfVxuXG4gIC8vIHRva2VuX3R0bCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90b2tlblR0bD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgdG9rZW5UdGwoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd0b2tlbl90dGwnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRva2VuVHRsKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl90b2tlblR0bCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRva2VuVHRsKCkge1xuICAgIHRoaXMuX3Rva2VuVHRsID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0b2tlblR0bElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90b2tlblR0bDtcbiAgfVxuXG4gIC8vIHRva2VuX3R5cGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdG9rZW5UeXBlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB0b2tlblR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd0b2tlbl90eXBlJyk7XG4gIH1cbiAgcHVibGljIHNldCB0b2tlblR5cGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3Rva2VuVHlwZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRva2VuVHlwZSgpIHtcbiAgICB0aGlzLl90b2tlblR5cGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRva2VuVHlwZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90b2tlblR5cGU7XG4gIH1cblxuICAvLyB1cG5kb21haW4gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF91cG5kb21haW4/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHVwbmRvbWFpbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3VwbmRvbWFpbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgdXBuZG9tYWluKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl91cG5kb21haW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVcG5kb21haW4oKSB7XG4gICAgdGhpcy5fdXBuZG9tYWluID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1cG5kb21haW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXBuZG9tYWluO1xuICB9XG5cbiAgLy8gdXJsIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3VybD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdXJsKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndXJsJyk7XG4gIH1cbiAgcHVibGljIHNldCB1cmwodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3VybCA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1cmxJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXJsO1xuICB9XG5cbiAgLy8gdXNlX3Rva2VuX2dyb3VwcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VzZVRva2VuR3JvdXBzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCB1c2VUb2tlbkdyb3VwcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCd1c2VfdG9rZW5fZ3JvdXBzJyk7XG4gIH1cbiAgcHVibGljIHNldCB1c2VUb2tlbkdyb3Vwcyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fdXNlVG9rZW5Hcm91cHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVc2VUb2tlbkdyb3VwcygpIHtcbiAgICB0aGlzLl91c2VUb2tlbkdyb3VwcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdXNlVG9rZW5Hcm91cHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlVG9rZW5Hcm91cHM7XG4gIH1cblxuICAvLyB1c2VyYXR0ciAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VzZXJhdHRyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB1c2VyYXR0cigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3VzZXJhdHRyJyk7XG4gIH1cbiAgcHVibGljIHNldCB1c2VyYXR0cih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdXNlcmF0dHIgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVc2VyYXR0cigpIHtcbiAgICB0aGlzLl91c2VyYXR0ciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdXNlcmF0dHJJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlcmF0dHI7XG4gIH1cblxuICAvLyB1c2VyZG4gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF91c2VyZG4/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHVzZXJkbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3VzZXJkbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgdXNlcmRuKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl91c2VyZG4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVc2VyZG4oKSB7XG4gICAgdGhpcy5fdXNlcmRuID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1c2VyZG5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlcmRuO1xuICB9XG5cbiAgLy8gdXNlcmZpbHRlciAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VzZXJmaWx0ZXI/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHVzZXJmaWx0ZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd1c2VyZmlsdGVyJyk7XG4gIH1cbiAgcHVibGljIHNldCB1c2VyZmlsdGVyKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl91c2VyZmlsdGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VXNlcmZpbHRlcigpIHtcbiAgICB0aGlzLl91c2VyZmlsdGVyID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1c2VyZmlsdGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3VzZXJmaWx0ZXI7XG4gIH1cblxuICAvLyB1c2VybmFtZV9hc19hbGlhcyAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VzZXJuYW1lQXNBbGlhcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgdXNlcm5hbWVBc0FsaWFzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3VzZXJuYW1lX2FzX2FsaWFzJyk7XG4gIH1cbiAgcHVibGljIHNldCB1c2VybmFtZUFzQWxpYXModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3VzZXJuYW1lQXNBbGlhcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFVzZXJuYW1lQXNBbGlhcygpIHtcbiAgICB0aGlzLl91c2VybmFtZUFzQWxpYXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHVzZXJuYW1lQXNBbGlhc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl91c2VybmFtZUFzQWxpYXM7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGJpbmRkbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fYmluZGRuKSxcbiAgICAgIGJpbmRwYXNzOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9iaW5kcGFzcyksXG4gICAgICBjYXNlX3NlbnNpdGl2ZV9uYW1lczogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2Nhc2VTZW5zaXRpdmVOYW1lcyksXG4gICAgICBjZXJ0aWZpY2F0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fY2VydGlmaWNhdGUpLFxuICAgICAgY2xpZW50X3Rsc19jZXJ0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jbGllbnRUbHNDZXJ0KSxcbiAgICAgIGNsaWVudF90bHNfa2V5OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jbGllbnRUbHNLZXkpLFxuICAgICAgZGVueV9udWxsX2JpbmQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9kZW55TnVsbEJpbmQpLFxuICAgICAgZGVzY3JpcHRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2Rlc2NyaXB0aW9uKSxcbiAgICAgIGRpc2FibGVfcmVtb3VudDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2Rpc2FibGVSZW1vdW50KSxcbiAgICAgIGRpc2NvdmVyZG46IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9kaXNjb3ZlcmRuKSxcbiAgICAgIGdyb3VwYXR0cjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fZ3JvdXBhdHRyKSxcbiAgICAgIGdyb3VwZG46IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2dyb3VwZG4pLFxuICAgICAgZ3JvdXBmaWx0ZXI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2dyb3VwZmlsdGVyKSxcbiAgICAgIGlkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9pZCksXG4gICAgICBpbnNlY3VyZV90bHM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9pbnNlY3VyZVRscyksXG4gICAgICBsb2NhbDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2xvY2FsKSxcbiAgICAgIG5hbWVzcGFjZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbmFtZXNwYWNlKSxcbiAgICAgIHBhdGg6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3BhdGgpLFxuICAgICAgc3RhcnR0bHM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9zdGFydHRscyksXG4gICAgICB0bHNfbWF4X3ZlcnNpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3Rsc01heFZlcnNpb24pLFxuICAgICAgdGxzX21pbl92ZXJzaW9uOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl90bHNNaW5WZXJzaW9uKSxcbiAgICAgIHRva2VuX2JvdW5kX2NpZHJzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkodGhpcy5fdG9rZW5Cb3VuZENpZHJzKSxcbiAgICAgIHRva2VuX2V4cGxpY2l0X21heF90dGw6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX3Rva2VuRXhwbGljaXRNYXhUdGwpLFxuICAgICAgdG9rZW5fbWF4X3R0bDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fdG9rZW5NYXhUdGwpLFxuICAgICAgdG9rZW5fbm9fZGVmYXVsdF9wb2xpY3k6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl90b2tlbk5vRGVmYXVsdFBvbGljeSksXG4gICAgICB0b2tlbl9udW1fdXNlczogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fdG9rZW5OdW1Vc2VzKSxcbiAgICAgIHRva2VuX3BlcmlvZDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fdG9rZW5QZXJpb2QpLFxuICAgICAgdG9rZW5fcG9saWNpZXM6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0sIGZhbHNlKSh0aGlzLl90b2tlblBvbGljaWVzKSxcbiAgICAgIHRva2VuX3R0bDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fdG9rZW5UdGwpLFxuICAgICAgdG9rZW5fdHlwZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdG9rZW5UeXBlKSxcbiAgICAgIHVwbmRvbWFpbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdXBuZG9tYWluKSxcbiAgICAgIHVybDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdXJsKSxcbiAgICAgIHVzZV90b2tlbl9ncm91cHM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl91c2VUb2tlbkdyb3VwcyksXG4gICAgICB1c2VyYXR0cjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdXNlcmF0dHIpLFxuICAgICAgdXNlcmRuOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl91c2VyZG4pLFxuICAgICAgdXNlcmZpbHRlcjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdXNlcmZpbHRlciksXG4gICAgICB1c2VybmFtZV9hc19hbGlhczogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX3VzZXJuYW1lQXNBbGlhcyksXG4gICAgfTtcbiAgfVxufVxuIl19