"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VaultProvider = exports.vaultProviderHeadersToTerraform = exports.vaultProviderClientAuthToTerraform = exports.vaultProviderAuthLoginUserpassToTerraform = exports.vaultProviderAuthLoginRadiusToTerraform = exports.vaultProviderAuthLoginOidcToTerraform = exports.vaultProviderAuthLoginOciToTerraform = exports.vaultProviderAuthLoginKerberosToTerraform = exports.vaultProviderAuthLoginJwtToTerraform = exports.vaultProviderAuthLoginGcpToTerraform = exports.vaultProviderAuthLoginCertToTerraform = exports.vaultProviderAuthLoginAzureToTerraform = exports.vaultProviderAuthLoginAwsToTerraform = exports.vaultProviderAuthLoginToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function vaultProviderAuthLoginToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        method: cdktf.stringToTerraform(struct.method),
        namespace: cdktf.stringToTerraform(struct.namespace),
        parameters: cdktf.hashMapper(cdktf.stringToTerraform)(struct.parameters),
        path: cdktf.stringToTerraform(struct.path),
    };
}
exports.vaultProviderAuthLoginToTerraform = vaultProviderAuthLoginToTerraform;
function vaultProviderAuthLoginAwsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        aws_access_key_id: cdktf.stringToTerraform(struct.awsAccessKeyId),
        aws_iam_endpoint: cdktf.stringToTerraform(struct.awsIamEndpoint),
        aws_profile: cdktf.stringToTerraform(struct.awsProfile),
        aws_region: cdktf.stringToTerraform(struct.awsRegion),
        aws_role_arn: cdktf.stringToTerraform(struct.awsRoleArn),
        aws_role_session_name: cdktf.stringToTerraform(struct.awsRoleSessionName),
        aws_secret_access_key: cdktf.stringToTerraform(struct.awsSecretAccessKey),
        aws_session_token: cdktf.stringToTerraform(struct.awsSessionToken),
        aws_shared_credentials_file: cdktf.stringToTerraform(struct.awsSharedCredentialsFile),
        aws_sts_endpoint: cdktf.stringToTerraform(struct.awsStsEndpoint),
        aws_web_identity_token_file: cdktf.stringToTerraform(struct.awsWebIdentityTokenFile),
        header_value: cdktf.stringToTerraform(struct.headerValue),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
    };
}
exports.vaultProviderAuthLoginAwsToTerraform = vaultProviderAuthLoginAwsToTerraform;
function vaultProviderAuthLoginAzureToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        client_id: cdktf.stringToTerraform(struct.clientId),
        jwt: cdktf.stringToTerraform(struct.jwt),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        resource_group_name: cdktf.stringToTerraform(struct.resourceGroupName),
        role: cdktf.stringToTerraform(struct.role),
        scope: cdktf.stringToTerraform(struct.scope),
        subscription_id: cdktf.stringToTerraform(struct.subscriptionId),
        tenant_id: cdktf.stringToTerraform(struct.tenantId),
        vm_name: cdktf.stringToTerraform(struct.vmName),
        vmss_name: cdktf.stringToTerraform(struct.vmssName),
    };
}
exports.vaultProviderAuthLoginAzureToTerraform = vaultProviderAuthLoginAzureToTerraform;
function vaultProviderAuthLoginCertToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cert_file: cdktf.stringToTerraform(struct.certFile),
        key_file: cdktf.stringToTerraform(struct.keyFile),
        mount: cdktf.stringToTerraform(struct.mount),
        name: cdktf.stringToTerraform(struct.name),
        namespace: cdktf.stringToTerraform(struct.namespace),
    };
}
exports.vaultProviderAuthLoginCertToTerraform = vaultProviderAuthLoginCertToTerraform;
function vaultProviderAuthLoginGcpToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        credentials: cdktf.stringToTerraform(struct.credentials),
        jwt: cdktf.stringToTerraform(struct.jwt),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
        service_account: cdktf.stringToTerraform(struct.serviceAccount),
    };
}
exports.vaultProviderAuthLoginGcpToTerraform = vaultProviderAuthLoginGcpToTerraform;
function vaultProviderAuthLoginJwtToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        jwt: cdktf.stringToTerraform(struct.jwt),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
    };
}
exports.vaultProviderAuthLoginJwtToTerraform = vaultProviderAuthLoginJwtToTerraform;
function vaultProviderAuthLoginKerberosToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disable_fast_negotiation: cdktf.booleanToTerraform(struct.disableFastNegotiation),
        keytab_path: cdktf.stringToTerraform(struct.keytabPath),
        krb5conf_path: cdktf.stringToTerraform(struct.krb5ConfPath),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        realm: cdktf.stringToTerraform(struct.realm),
        remove_instance_name: cdktf.booleanToTerraform(struct.removeInstanceName),
        service: cdktf.stringToTerraform(struct.service),
        token: cdktf.stringToTerraform(struct.token),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.vaultProviderAuthLoginKerberosToTerraform = vaultProviderAuthLoginKerberosToTerraform;
function vaultProviderAuthLoginOciToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        auth_type: cdktf.stringToTerraform(struct.authType),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
    };
}
exports.vaultProviderAuthLoginOciToTerraform = vaultProviderAuthLoginOciToTerraform;
function vaultProviderAuthLoginOidcToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        callback_address: cdktf.stringToTerraform(struct.callbackAddress),
        callback_listener_address: cdktf.stringToTerraform(struct.callbackListenerAddress),
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        role: cdktf.stringToTerraform(struct.role),
    };
}
exports.vaultProviderAuthLoginOidcToTerraform = vaultProviderAuthLoginOidcToTerraform;
function vaultProviderAuthLoginRadiusToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        password: cdktf.stringToTerraform(struct.password),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.vaultProviderAuthLoginRadiusToTerraform = vaultProviderAuthLoginRadiusToTerraform;
function vaultProviderAuthLoginUserpassToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        mount: cdktf.stringToTerraform(struct.mount),
        namespace: cdktf.stringToTerraform(struct.namespace),
        password: cdktf.stringToTerraform(struct.password),
        password_file: cdktf.stringToTerraform(struct.passwordFile),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.vaultProviderAuthLoginUserpassToTerraform = vaultProviderAuthLoginUserpassToTerraform;
function vaultProviderClientAuthToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cert_file: cdktf.stringToTerraform(struct.certFile),
        key_file: cdktf.stringToTerraform(struct.keyFile),
    };
}
exports.vaultProviderClientAuthToTerraform = vaultProviderClientAuthToTerraform;
function vaultProviderHeadersToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.vaultProviderHeadersToTerraform = vaultProviderHeadersToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault vault}
*/
class VaultProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VaultProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.10.0',
                providerVersionConstraint: '~> 3.7'
            },
            terraformProviderSource: 'hashicorp/vault'
        });
        this._addAddressToEnv = config.addAddressToEnv;
        this._address = config.address;
        this._caCertDir = config.caCertDir;
        this._caCertFile = config.caCertFile;
        this._maxLeaseTtlSeconds = config.maxLeaseTtlSeconds;
        this._maxRetries = config.maxRetries;
        this._maxRetriesCcc = config.maxRetriesCcc;
        this._namespace = config.namespace;
        this._skipChildToken = config.skipChildToken;
        this._skipGetVaultVersion = config.skipGetVaultVersion;
        this._skipTlsVerify = config.skipTlsVerify;
        this._tlsServerName = config.tlsServerName;
        this._token = config.token;
        this._tokenName = config.tokenName;
        this._vaultVersionOverride = config.vaultVersionOverride;
        this._alias = config.alias;
        this._authLogin = config.authLogin;
        this._authLoginAws = config.authLoginAws;
        this._authLoginAzure = config.authLoginAzure;
        this._authLoginCert = config.authLoginCert;
        this._authLoginGcp = config.authLoginGcp;
        this._authLoginJwt = config.authLoginJwt;
        this._authLoginKerberos = config.authLoginKerberos;
        this._authLoginOci = config.authLoginOci;
        this._authLoginOidc = config.authLoginOidc;
        this._authLoginRadius = config.authLoginRadius;
        this._authLoginUserpass = config.authLoginUserpass;
        this._clientAuth = config.clientAuth;
        this._headers = config.headers;
    }
    get addAddressToEnv() {
        return this._addAddressToEnv;
    }
    set addAddressToEnv(value) {
        this._addAddressToEnv = value;
    }
    resetAddAddressToEnv() {
        this._addAddressToEnv = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get addAddressToEnvInput() {
        return this._addAddressToEnv;
    }
    get address() {
        return this._address;
    }
    set address(value) {
        this._address = value;
    }
    // Temporarily expose input value. Use with caution.
    get addressInput() {
        return this._address;
    }
    get caCertDir() {
        return this._caCertDir;
    }
    set caCertDir(value) {
        this._caCertDir = value;
    }
    resetCaCertDir() {
        this._caCertDir = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caCertDirInput() {
        return this._caCertDir;
    }
    get caCertFile() {
        return this._caCertFile;
    }
    set caCertFile(value) {
        this._caCertFile = value;
    }
    resetCaCertFile() {
        this._caCertFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caCertFileInput() {
        return this._caCertFile;
    }
    get maxLeaseTtlSeconds() {
        return this._maxLeaseTtlSeconds;
    }
    set maxLeaseTtlSeconds(value) {
        this._maxLeaseTtlSeconds = value;
    }
    resetMaxLeaseTtlSeconds() {
        this._maxLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlSecondsInput() {
        return this._maxLeaseTtlSeconds;
    }
    get maxRetries() {
        return this._maxRetries;
    }
    set maxRetries(value) {
        this._maxRetries = value;
    }
    resetMaxRetries() {
        this._maxRetries = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxRetriesInput() {
        return this._maxRetries;
    }
    get maxRetriesCcc() {
        return this._maxRetriesCcc;
    }
    set maxRetriesCcc(value) {
        this._maxRetriesCcc = value;
    }
    resetMaxRetriesCcc() {
        this._maxRetriesCcc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxRetriesCccInput() {
        return this._maxRetriesCcc;
    }
    get namespace() {
        return this._namespace;
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get skipChildToken() {
        return this._skipChildToken;
    }
    set skipChildToken(value) {
        this._skipChildToken = value;
    }
    resetSkipChildToken() {
        this._skipChildToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipChildTokenInput() {
        return this._skipChildToken;
    }
    get skipGetVaultVersion() {
        return this._skipGetVaultVersion;
    }
    set skipGetVaultVersion(value) {
        this._skipGetVaultVersion = value;
    }
    resetSkipGetVaultVersion() {
        this._skipGetVaultVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipGetVaultVersionInput() {
        return this._skipGetVaultVersion;
    }
    get skipTlsVerify() {
        return this._skipTlsVerify;
    }
    set skipTlsVerify(value) {
        this._skipTlsVerify = value;
    }
    resetSkipTlsVerify() {
        this._skipTlsVerify = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipTlsVerifyInput() {
        return this._skipTlsVerify;
    }
    get tlsServerName() {
        return this._tlsServerName;
    }
    set tlsServerName(value) {
        this._tlsServerName = value;
    }
    resetTlsServerName() {
        this._tlsServerName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsServerNameInput() {
        return this._tlsServerName;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get tokenName() {
        return this._tokenName;
    }
    set tokenName(value) {
        this._tokenName = value;
    }
    resetTokenName() {
        this._tokenName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNameInput() {
        return this._tokenName;
    }
    get vaultVersionOverride() {
        return this._vaultVersionOverride;
    }
    set vaultVersionOverride(value) {
        this._vaultVersionOverride = value;
    }
    resetVaultVersionOverride() {
        this._vaultVersionOverride = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vaultVersionOverrideInput() {
        return this._vaultVersionOverride;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get authLogin() {
        return this._authLogin;
    }
    set authLogin(value) {
        this._authLogin = value;
    }
    resetAuthLogin() {
        this._authLogin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginInput() {
        return this._authLogin;
    }
    get authLoginAws() {
        return this._authLoginAws;
    }
    set authLoginAws(value) {
        this._authLoginAws = value;
    }
    resetAuthLoginAws() {
        this._authLoginAws = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginAwsInput() {
        return this._authLoginAws;
    }
    get authLoginAzure() {
        return this._authLoginAzure;
    }
    set authLoginAzure(value) {
        this._authLoginAzure = value;
    }
    resetAuthLoginAzure() {
        this._authLoginAzure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginAzureInput() {
        return this._authLoginAzure;
    }
    get authLoginCert() {
        return this._authLoginCert;
    }
    set authLoginCert(value) {
        this._authLoginCert = value;
    }
    resetAuthLoginCert() {
        this._authLoginCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginCertInput() {
        return this._authLoginCert;
    }
    get authLoginGcp() {
        return this._authLoginGcp;
    }
    set authLoginGcp(value) {
        this._authLoginGcp = value;
    }
    resetAuthLoginGcp() {
        this._authLoginGcp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginGcpInput() {
        return this._authLoginGcp;
    }
    get authLoginJwt() {
        return this._authLoginJwt;
    }
    set authLoginJwt(value) {
        this._authLoginJwt = value;
    }
    resetAuthLoginJwt() {
        this._authLoginJwt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginJwtInput() {
        return this._authLoginJwt;
    }
    get authLoginKerberos() {
        return this._authLoginKerberos;
    }
    set authLoginKerberos(value) {
        this._authLoginKerberos = value;
    }
    resetAuthLoginKerberos() {
        this._authLoginKerberos = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginKerberosInput() {
        return this._authLoginKerberos;
    }
    get authLoginOci() {
        return this._authLoginOci;
    }
    set authLoginOci(value) {
        this._authLoginOci = value;
    }
    resetAuthLoginOci() {
        this._authLoginOci = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginOciInput() {
        return this._authLoginOci;
    }
    get authLoginOidc() {
        return this._authLoginOidc;
    }
    set authLoginOidc(value) {
        this._authLoginOidc = value;
    }
    resetAuthLoginOidc() {
        this._authLoginOidc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginOidcInput() {
        return this._authLoginOidc;
    }
    get authLoginRadius() {
        return this._authLoginRadius;
    }
    set authLoginRadius(value) {
        this._authLoginRadius = value;
    }
    resetAuthLoginRadius() {
        this._authLoginRadius = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginRadiusInput() {
        return this._authLoginRadius;
    }
    get authLoginUserpass() {
        return this._authLoginUserpass;
    }
    set authLoginUserpass(value) {
        this._authLoginUserpass = value;
    }
    resetAuthLoginUserpass() {
        this._authLoginUserpass = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authLoginUserpassInput() {
        return this._authLoginUserpass;
    }
    get clientAuth() {
        return this._clientAuth;
    }
    set clientAuth(value) {
        this._clientAuth = value;
    }
    resetClientAuth() {
        this._clientAuth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientAuthInput() {
        return this._clientAuth;
    }
    get headers() {
        return this._headers;
    }
    set headers(value) {
        this._headers = value;
    }
    resetHeaders() {
        this._headers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get headersInput() {
        return this._headers;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            add_address_to_env: cdktf.stringToTerraform(this._addAddressToEnv),
            address: cdktf.stringToTerraform(this._address),
            ca_cert_dir: cdktf.stringToTerraform(this._caCertDir),
            ca_cert_file: cdktf.stringToTerraform(this._caCertFile),
            max_lease_ttl_seconds: cdktf.numberToTerraform(this._maxLeaseTtlSeconds),
            max_retries: cdktf.numberToTerraform(this._maxRetries),
            max_retries_ccc: cdktf.numberToTerraform(this._maxRetriesCcc),
            namespace: cdktf.stringToTerraform(this._namespace),
            skip_child_token: cdktf.booleanToTerraform(this._skipChildToken),
            skip_get_vault_version: cdktf.booleanToTerraform(this._skipGetVaultVersion),
            skip_tls_verify: cdktf.booleanToTerraform(this._skipTlsVerify),
            tls_server_name: cdktf.stringToTerraform(this._tlsServerName),
            token: cdktf.stringToTerraform(this._token),
            token_name: cdktf.stringToTerraform(this._tokenName),
            vault_version_override: cdktf.stringToTerraform(this._vaultVersionOverride),
            alias: cdktf.stringToTerraform(this._alias),
            auth_login: vaultProviderAuthLoginToTerraform(this._authLogin),
            auth_login_aws: vaultProviderAuthLoginAwsToTerraform(this._authLoginAws),
            auth_login_azure: vaultProviderAuthLoginAzureToTerraform(this._authLoginAzure),
            auth_login_cert: vaultProviderAuthLoginCertToTerraform(this._authLoginCert),
            auth_login_gcp: vaultProviderAuthLoginGcpToTerraform(this._authLoginGcp),
            auth_login_jwt: vaultProviderAuthLoginJwtToTerraform(this._authLoginJwt),
            auth_login_kerberos: vaultProviderAuthLoginKerberosToTerraform(this._authLoginKerberos),
            auth_login_oci: vaultProviderAuthLoginOciToTerraform(this._authLoginOci),
            auth_login_oidc: vaultProviderAuthLoginOidcToTerraform(this._authLoginOidc),
            auth_login_radius: vaultProviderAuthLoginRadiusToTerraform(this._authLoginRadius),
            auth_login_userpass: vaultProviderAuthLoginUserpassToTerraform(this._authLoginUserpass),
            client_auth: vaultProviderClientAuthToTerraform(this._clientAuth),
            headers: cdktf.listMapper(vaultProviderHeadersToTerraform, true)(this._headers),
        };
    }
}
exports.VaultProvider = VaultProvider;
_a = JSII_RTTI_SYMBOL_1;
VaultProvider[_a] = { fqn: "@cdktf/provider-vault.provider.VaultProvider", version: "3.0.14" };
// =================
// STATIC PROPERTIES
// =================
VaultProvider.tfResourceType = "vault";
//# sourceMappingURL=data:application/json;base64,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