"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RaftAutopilot = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot}
*/
class RaftAutopilot extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RaftAutopilotConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_raft_autopilot',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.10.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._cleanupDeadServers = config.cleanupDeadServers;
        this._deadServerLastContactThreshold = config.deadServerLastContactThreshold;
        this._id = config.id;
        this._lastContactThreshold = config.lastContactThreshold;
        this._maxTrailingLogs = config.maxTrailingLogs;
        this._minQuorum = config.minQuorum;
        this._namespace = config.namespace;
        this._serverStabilizationTime = config.serverStabilizationTime;
    }
    get cleanupDeadServers() {
        return this.getBooleanAttribute('cleanup_dead_servers');
    }
    set cleanupDeadServers(value) {
        this._cleanupDeadServers = value;
    }
    resetCleanupDeadServers() {
        this._cleanupDeadServers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cleanupDeadServersInput() {
        return this._cleanupDeadServers;
    }
    get deadServerLastContactThreshold() {
        return this.getStringAttribute('dead_server_last_contact_threshold');
    }
    set deadServerLastContactThreshold(value) {
        this._deadServerLastContactThreshold = value;
    }
    resetDeadServerLastContactThreshold() {
        this._deadServerLastContactThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deadServerLastContactThresholdInput() {
        return this._deadServerLastContactThreshold;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get lastContactThreshold() {
        return this.getStringAttribute('last_contact_threshold');
    }
    set lastContactThreshold(value) {
        this._lastContactThreshold = value;
    }
    resetLastContactThreshold() {
        this._lastContactThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lastContactThresholdInput() {
        return this._lastContactThreshold;
    }
    get maxTrailingLogs() {
        return this.getNumberAttribute('max_trailing_logs');
    }
    set maxTrailingLogs(value) {
        this._maxTrailingLogs = value;
    }
    resetMaxTrailingLogs() {
        this._maxTrailingLogs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTrailingLogsInput() {
        return this._maxTrailingLogs;
    }
    get minQuorum() {
        return this.getNumberAttribute('min_quorum');
    }
    set minQuorum(value) {
        this._minQuorum = value;
    }
    resetMinQuorum() {
        this._minQuorum = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minQuorumInput() {
        return this._minQuorum;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get serverStabilizationTime() {
        return this.getStringAttribute('server_stabilization_time');
    }
    set serverStabilizationTime(value) {
        this._serverStabilizationTime = value;
    }
    resetServerStabilizationTime() {
        this._serverStabilizationTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverStabilizationTimeInput() {
        return this._serverStabilizationTime;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cleanup_dead_servers: cdktf.booleanToTerraform(this._cleanupDeadServers),
            dead_server_last_contact_threshold: cdktf.stringToTerraform(this._deadServerLastContactThreshold),
            id: cdktf.stringToTerraform(this._id),
            last_contact_threshold: cdktf.stringToTerraform(this._lastContactThreshold),
            max_trailing_logs: cdktf.numberToTerraform(this._maxTrailingLogs),
            min_quorum: cdktf.numberToTerraform(this._minQuorum),
            namespace: cdktf.stringToTerraform(this._namespace),
            server_stabilization_time: cdktf.stringToTerraform(this._serverStabilizationTime),
        };
    }
}
exports.RaftAutopilot = RaftAutopilot;
_a = JSII_RTTI_SYMBOL_1;
RaftAutopilot[_a] = { fqn: "@cdktf/provider-vault.raftAutopilot.RaftAutopilot", version: "3.0.14" };
// =================
// STATIC PROPERTIES
// =================
RaftAutopilot.tfResourceType = "vault_raft_autopilot";
//# sourceMappingURL=data:application/json;base64,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