import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TerraformCloudSecretBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the address of the Terraform Cloud instance, provided as "host:port" like "127.0.0.1:8500".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#address TerraformCloudSecretBackend#address}
    */
    readonly address?: string;
    /**
    * Unique name of the Vault Terraform Cloud mount to configure
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#backend TerraformCloudSecretBackend#backend}
    */
    readonly backend?: string;
    /**
    * Specifies the base path for the Terraform Cloud or Enterprise API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#base_path TerraformCloudSecretBackend#base_path}
    */
    readonly basePath?: string;
    /**
    * Default lease duration for secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#default_lease_ttl_seconds TerraformCloudSecretBackend#default_lease_ttl_seconds}
    */
    readonly defaultLeaseTtlSeconds?: number;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#description TerraformCloudSecretBackend#description}
    */
    readonly description?: string;
    /**
    * If set, opts out of mount migration on path updates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#disable_remount TerraformCloudSecretBackend#disable_remount}
    */
    readonly disableRemount?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#id TerraformCloudSecretBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Maximum possible lease duration for secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#max_lease_ttl_seconds TerraformCloudSecretBackend#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#namespace TerraformCloudSecretBackend#namespace}
    */
    readonly namespace?: string;
    /**
    * Specifies the Terraform Cloud access token to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend#token TerraformCloudSecretBackend#token}
    */
    readonly token?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend vault_terraform_cloud_secret_backend}
*/
export declare class TerraformCloudSecretBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_terraform_cloud_secret_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_backend vault_terraform_cloud_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TerraformCloudSecretBackendConfig = {}
    */
    constructor(scope: Construct, id: string, config?: TerraformCloudSecretBackendConfig);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _basePath?;
    get basePath(): string;
    set basePath(value: string);
    resetBasePath(): void;
    get basePathInput(): string | undefined;
    private _defaultLeaseTtlSeconds?;
    get defaultLeaseTtlSeconds(): number;
    set defaultLeaseTtlSeconds(value: number);
    resetDefaultLeaseTtlSeconds(): void;
    get defaultLeaseTtlSecondsInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disableRemount?;
    get disableRemount(): boolean | cdktf.IResolvable;
    set disableRemount(value: boolean | cdktf.IResolvable);
    resetDisableRemount(): void;
    get disableRemountInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number;
    set maxLeaseTtlSeconds(value: number);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
